﻿USE sofia;
DROP TABLE IF EXISTS sofia.qxl_vpl;
CREATE TABLE qxl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qxl_vpl WRITE;
INSERT INTO qxl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristoga Taita Abrahambuj Rey Davidbuj churigunaj churimiga. Jesusbuj ñaubadij kausuj taitagunaj shutigunadami kaibiga rurushka tiyan: ");
INSERT INTO qxl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamga Isaacbuj taitamiga. Isaacga Jacob-buj, Jacobga Judaj, paibuj waukigunakish. ");
INSERT INTO qxl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaga Faresbuj shinaidi Zerakish taitamiga, mamaga Tamarmiga. Faresga Esrombuj taita, Esromga Arambuj taita. ");
INSERT INTO qxl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramga Aminadab-buj taita. Aminadabga Naasonbuj, Naasonga Salmonbuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonga Boozbuj taita, mamaga Rahabmiga. Boozga Obedbuj taita; mamaga Rutmiga. Obedga Isaíbuj taita. ");
INSERT INTO qxl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíga Rey Davidbuj taita. Rey Davidga Salomonbuj, mamaga Uriasbuj warmimishka. ");
INSERT INTO qxl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonga Roboambuj taitamiga. Roboamga Abiasbuj, Abiasga Asabuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaga Josafatbuj taita. Josafatka Jorambuj, Joramga Uziasbuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziasga Jotambuj taita. Jotamga Acazbuj, Acazga Ezequiasbuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiasga Manasesbuj taita. Manasesga Amonbuj, Amonga Josiasbuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasga Jeconiasbuj paibuj waukigunakish taitamiga. Paiguna kausi p'unllagunabimi israelgunada Babilonia llaktamu prezusha apusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Prezusha rishka k'ipa Jeconiasga Salatielbuj taita tukuga; Salatielga Zorobabelbuj, ");
INSERT INTO qxl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelga Abiudbuj, Abiudga Eliaquimbuj, Eliaquimga Azorbuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorga Sadocbuj taita. Sadocga Aquimbuj, Aquimga Eliudbuj. ");
INSERT INTO qxl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudga Eleazarbuj. Eleazarga Matanbuj, Matanga Jacob-buj. ");
INSERT INTO qxl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobga Mariaj kusa Jozij taitamiga. Mariamunda Jesús wachariga; Cristo shutimiga. ");
INSERT INTO qxl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Shinakiga Abraham-munda Davidgama chunga chusku (14) ñauba taitagunami; Davidmunda Babilonia llaktamu apashka p'unllagama chunga chusku (14); Babiloniamu apashka p'unllamunda Cristogama chunga chusku (14) ñauba taitagunami gashka. ");
INSERT INTO qxl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo wacharinaga kashnami gashka: Paibuj mama Mariaga Jozin kazarangu ari ninukushkami gaga. Narikish paiyun purishaidimi Diosbuj Espiritumunda Mariaga iksa charij tukushka. ");
INSERT INTO qxl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Paibuj kusa Joziga allilladi k'ari gashkamunda, Mariada na gentegunaj ñaubuki pinganaidi sakichingumi, pish na yachujllabidi partirisha ringu munuga. ");
INSERT INTO qxl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Shina yuyariguki, ñash Manduj Diosbuj shuj ángel suñibi rikurigallami kashna nisha: “Jozi, ñauba Rey Davidbuj churigunaj churi, Marian kazaranadaga ama mancharichu; paiga Diosbuj Espiritumundami iksa charij gan. ");
INSERT INTO qxl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Paimi shuj churida mirunga. Chi maraga tuki juchagunamunda Paida crijkunada kishpichinashkamunda, Jesús shutida shutichingui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tuki kaigunaga Manduj Dios nishkada parluj Isaiasmu Dios parlachishka p'aktachunmi shina tukuga: ");
INSERT INTO qxl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“¡Uyichi! Shuj warmi pi k'arinbish na purijmi iksa charij tukusha shuj churida mirunga. Paidaga Emanueldami shutichingaguna.” (Kai shutiga, “Diosga ñukuchinmi,” nisha shina nin.) ");
INSERT INTO qxl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jozi rijcharishaga imada Manduj Diosbuj ángel mandushkadami rurusha, Mariada kazaraga. ");
INSERT INTO qxl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Shinash María churida mirungagama na kusandij warmindij laya puñugagunachu. Chi maradaga Joziga Jesustami shutichiga. ");
INSERT INTO qxl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jatun mandaj Herodes mandashka p'unllagunaga Jesús Judea llakta Belén pueblobi wacharishka k'ipaga indi llujshina ladumunda yachuj tukushkaguna Jerusalén pueblomu chayushaga, ");
INSERT INTO qxl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“¿Maibidi israelgunada jatun mandajka wacharishka?” nisha tapugaguna, “Indi llujshina ladubimi pai wacharishkada rikuchij luzeroda rikushkanchi. Shinushami paida <Allimi gangui> ningu shamuganchi.” ");
INSERT INTO qxl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jatun manduj Herodesga kai nishkada uyusha tuki layaidi yuyarisha muspariga; tuki Jerusalenbi kausujkunash shinaidi tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Shinushaga tuki curada mandujkunada, Moisés mandushkada yachachijkunadash tandachisha tapuga, “¿Cristoga maibidi wacharina gan?” ");
INSERT INTO qxl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Shina niki kashna nigaguna: “Judea llakta Belén pueblobi, Dios nishkada parluj kaida escribishka tiyashkamunda: ");
INSERT INTO qxl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kan Belén pueblo Judaj achpamunda Judaj achpabi tiyuj mandujkunamunda na uchillachu gangui. Ashtangarin kanmundami shuj jatun manduj llujshinga. Paimi ñukaj agllashka israelgunadaga michij shina pushunga.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chimundami Herodesga yachuj tukushkagunada pakallada kayachun kachusha ima uramunda luzero rikurishkada tapushaga yachuj chayuga. ");
INSERT INTO qxl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Chi k'ipa Belenmu kachusha kashna niga: “Chimu richi; chi maramunda tuki ima yachi pudishkada yachamunguichi. Japishaga ñukash paida <Allimi gangui> ningu ringaj ñukamu parlanguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herodes ima nishkada uyushka k'ipa paigunaga rigaguna. Indi llujshina ladubi rikushka luzeroga ñash paigunada ñaubushka rigushami chi mara sirishka pushtubi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Shina luzeroda rikushami manchanaidi kushilladi tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chi wasimu waigushaga marada paibuj mama Mariandijta rikugaguna. Chimundami kungurisha kumurisha <Allimi gangui> nisha kumbidanagunadash llujshichisha kurida inciensoda mirradash maramu kugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dios sueñobi yachuj tukushkagunamu <Ama Herodesbujmu vueltanguichichu> nisha rikuchiki, shuj ñanda paigunaj llaktamu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Paiguna rishka k'ipa Jozimu sueñobi Mandaj Diosbuj ángel rikurisha kashna niga: “¡Jatari! Marada japisha marabuj mamadash pushusha Egipto llaktamu mitikusha ri. Herodesga marada wañuchingu mashkangami. Shinusha, ñuka parlungagama chibi sakiringui.” ");
INSERT INTO qxl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Shina nin, rijcharisha Joziga marada maraj mamadash pushusha chi tutaidi Egiptomu llujshish riga. ");
INSERT INTO qxl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chibimi Herodes wañungagama sakirigaguna. “Egiptomundami Ñukaj Churidaga kayugani,” nisha Dios nishkada parlujmu Mandaj Dios parlachishka p'aktachunmi kaigunaga tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yachuj tukushkaguna na vueltamukiga <Ñukada uma takushkagunami> nisha Herodes manchanaidi p'iñariga. Ima uramunda luzero rikurishkada yachuj tukushkagunada tapushkada yuyarisha, mashnalla Belenbi shinaidi Belén muyundiki kausuj tuki k'ari mara ishki watamunda urimu charijkunadaga illujta wañuchichunmi mandush kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Shinami Dios nishkada parluj Jeremías kashna parlashka p'aktuga: ");
INSERT INTO qxl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá pueblobimi shuj jinchida kaparisha mejor llakirisha wakushkami uyarishka. Raquelmiga. ‘Ama wakichu’ nikish nima na uyanachisha wakaguga. Paibuj churiguna ña wañushkamundami shina wakaga.” ");
INSERT INTO qxl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes wañushka k'ipa Jozi Egipto llaktabi gaki Mandaj Diosbuj ángel sueñobi rikurisha kashna niga: ");
INSERT INTO qxl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Marada wañuchingu munujkunaga ñami wañushkaguna. ¡Shinusha jatari! Marada japisha paibuj mamadash pushusha Israel llaktamu ri.” ");
INSERT INTO qxl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chimundami jatarisha Joziga marada mamundash pushusha Israel llaktamu vueltuga. ");
INSERT INTO qxl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Shinash Arquelao paibuj taita Herodesbuj randi Judeabi mandujta Jozi yachi chayushaga chimu rinada manchuga. Shinalladi Dios sueñobi parlushkamunda Israel llaktallabidi tiyuj Galilea achpamu karuyasha riga. ");
INSERT INTO qxl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chimu chayushaga Nazaret shuti pueblobimi kausugaguna. Dios nishkada parlujkuna Jesusmunda kashna parlushka p'aktachunmi shina tukuga: “Paidaga ‘Nazaretmunda’ nishami ningaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chi wataguna k'ipami Bautizaj Juanchuga Diosbuj Shimida Judea llakta shitushka pushtubi parlusha chayushaga ");
INSERT INTO qxl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kashna niga: “Jawa Pacha Dios Kangunada Mandanaga ñami kuchuyamugun. Shinusha juchagunada sakisha Diosmu kuchuyichi,” nishami parlaguga. ");
INSERT INTO qxl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dios nishkada parluj Isaiasga Juanchumundami kashna nishaga escribishka: “Shitashka pushtubi kaparijka uyarigun, ‘Mandujbuj ñanda derecho rurusha alli parijichi,’ ” nisha nin. ");
INSERT INTO qxl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bautizaj Juanchuj churanaga camello millmallanmi rurushkaga. Shinaidi kara chumbilladami chumbillishkaga. Chuzbitigunadash sacha bunga mishkidash mikujmiga. ");
INSERT INTO qxl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tuki Judea llaktabi kausujkunash, chi llaktallabidi tiyuj Jerusalén pueblobi kausujkunash shinaidi Jordán yaku kuchu muyundiki kausujkunashmi paimu kuchuyagujllagunaga. ");
INSERT INTO qxl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Paigunaj juchagunada Diosmu parlukiga Juanchuga Jordán yakubimi bautizajkuga. ");
INSERT INTO qxl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tauga fariseoguna saduceoguna bautizaringu shamujta rikusha Juanchuga niga, “Culebra shina millida rurajkunaminguichi. Dios p'iñarisha llakichina p'unlla shamunamunda <Kangunaga kishpiringuichimi> nisha ¿pidi parlugari? ");
INSERT INTO qxl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Juchagunada sakishkashaga alli grano shina allida rurusha rikuchichiri. ");
INSERT INTO qxl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama kangunaj yuyillabi, ‘Abrahamga ñukuchij ñauba taitamigun,’ yuyusha nisha ama nichichu. Ñukaga ninimi, Diosga kai rumigunada Abrahambuj wawagunada rurunmullami. ");
INSERT INTO qxl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yurada angundi p'itingu jacha ña tiyanmi. Tuki na alli aparij yuragunadaga p'itishami ninabi shitun. ");
INSERT INTO qxl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kanguna juchagunada sakisha Diosmu kuchuyaki, ñukaga yakunllami bautizani. Ñukaj k'ipa shamujmi Diosbuj Espiritun ninanbish bautizanga. Paimi ñukada yalli imadash ruri pudijllagun. Ñukaga Paibuj pargatida apungujllash na kabinichu. ");
INSERT INTO qxl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Paiga trigoda wairachingu palada Paibuj makibi charisha t'amumunda ch'ikunyachij shinami ruranga. Trigolladami wakichinga. T'amudaga na wañuj ninabi shitashami rupachinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chi p'unllagunaidi Jesús Galilea llaktamunda risha Jordán yaku kuchumu Juanchu bautizachun nisha chayuga. ");
INSERT INTO qxl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ashtanbish Juanchuga na bautizash nisha kashna niga: “Ñukami Kan bautizachunga ministini. ¿Ashtan Kan ñukamu shamushkanguindi?” ");
INSERT INTO qxl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Shina niki Jesusga, “Kununllaga shinash saki; Dios tuki mandushkadami p'aktachina ganchi,” niga. Chimundami <Ari> nisha Juanchuga bautizaga. ");
INSERT INTO qxl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautizarishka k'ipa, Jesús yakumunda llujshinmi, jawa pacha paskariki Diosbuj Espíritu Paibuj jawamu paloma shina uriyajta Jesús rikuga. ");
INSERT INTO qxl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chi k'ipa jawa pachamunda, “Kaimigun Ñuka k'uyashka Churi; Paibimi manchanaidi kushiyani,” nisha shuj parlarishka uyariga. ");
INSERT INTO qxl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chi k'ipami diablo pandachingu nisha imalladash nichun Diosbuj Espirituga Jesusta shitushka pushtumu pushaga. ");
INSERT INTO qxl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chusku chunga (40) p'unllada tutadash ayunashka k'ipaga Jesusga yarijachigami. ");
INSERT INTO qxl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chibi diabloga pandachisha nisha Jesusbujmu kuchuyashaga, “Kan Diosbuj churidij gashaga kai rumigunadaga tanda tukuchun niri,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Shina niki Jesusga niga, “Diosbuj Shimibiga ninmi, ‘Gentegunaga tandallada mikushaga na kausungachu. Ashtangarin tuki Diosbuj Shimibi ima nishkamundash kausungallami.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chi k'ipa diabloga Jesusta Diosbujlla gaj Jerusalén pueblomu pushusha israelgunaj Diosbuj wasi jawamundi shayachisha kashna niga: ");
INSERT INTO qxl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Kan Diosbuj churidij gashaga kaimunda pambamu urmi. Diosbuj Shimibi kashna nishkamunda: ‘Dios Paibuj angelgunada Kanda chapachun kachungami; Kambuj chaki rumibi ama takarichun, paigunaj makin chariringami.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Shina niki Jesusga niga, “Shinalladi Diosbuj Shimibiga, ‘Kambuj Manduj Diostaga ama urmachingu munichu,’ ninmi.” ");
INSERT INTO qxl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kutinlladi diabloga Jesusta pandachingu munusha shuj jatun urku jawamundi pushusha riga. Chimundami kai pachabi tiyaj tuki llaktagunada, shinaidi paiguna tuki k'uilla charishkagunandij rikuchisha, ");
INSERT INTO qxl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","kashna niga: “Ñukaj ñaubuki kungurisha kumurisha <Allimi gangui> nikiga kai tukidami kanmu kusha.” ");
INSERT INTO qxl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Shina nikiga Jesusga niga, “Kaimunda ri, Satanás. Diosbuj Shimibiga, ‘Kambuj Manduj Diosllada <Allimi gangui> nisha Pai nishkallada rurangui,’ nishka tiyashkamunda.” ");
INSERT INTO qxl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chimundami diabloga Jesusbuj kuchumundaga rigallami. Chibi tauga angelguna ñash rikurisha Pai ima ministishkada rurungu kuchuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bautizaj Juanchuda carcelbi churushkada Jesús uyushaga Galilea llaktamu vueltamuga. ");
INSERT INTO qxl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaretmunda llujshisha Galilea yaku kucha manyabi tiyuj Capernaúm pueblomu Zabulón Neftalibuj kausushka achpabi kausungu riga. ");
INSERT INTO qxl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kaigunaga Dios nishkada parluj Isaías kashna escribishka p'aktachunmi shina tukuga: ");
INSERT INTO qxl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulonbuj shinaidi Neftalibuj achpabi, yaku kucha manyabi, Jordán yaku ch'imbabi, na israelguna kausana Galilea achpabi, ");
INSERT INTO qxl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","tuki chi llaktabi tutabi laya kausujkuna p'unllayachijtami rikugaguna. P'unllayachij luzmi wañuna manchin tutabi laya kausujkunamu p'alanishka.” ");
INSERT INTO qxl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chimundami Jesusga Diosbuj Shimida parlungu kallariga kashna nisha: “Diosbuj mandanaga ñami kuchuyamugun. Shinushaga juchagunada sakisha Diosmu kuchuyichi.” ");
INSERT INTO qxl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Galilea yaku kucha manyada rigushami Jesusga Simonda paibuj wauki Andikundijta rikuga. Simonga Pedro nishkamiga. Paigunaga chaula japijkunashami chaulada japinada yakumu shitagugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chimunda Jesusga, “Katimichi; Ñukami kangunadaga chaulada japij shina, gentegunada japijta rurusha,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Shina ninmi, chaulada japinada chi pushtubi shitusha, Paigun rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chimunda ashallada rishami Zebedeoj churi Jacoboda paibuj wauki Juanchudash barcabi paigunaj taita Zebedeon chaulada japinada p'utyusha tiyajta rikuga. Shina tiyajta Jesús rikusha kayunmi, ");
INSERT INTO qxl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","barcada shinaidi paigunaj taita Zebedeodash sakisha Jesuskun rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesusga illujta Galileada purishami Diosmunda yachana wasigunabi yachachiga. Diosbuj mandanamunda Alli Shimida parlaga. Shinalladi tuki unguiyuj, naniyujkunada alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tuki Siria llaktabimi Jesusmunda parlushkaga. Shinushami imalla ungui nanigunama charijkunadash, yana katishkagunadash, urmuj ungui charijkunadash, suchugunadash pushamukiga Jesusga alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galileamunda taugalladijkuna, Decapolismunda, Jerusalén pueblomunda, Judeamundash, shinaidi Jordán yaku ch'imba ladu llaktabi kausujkunashmi Jesusta katisha purigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Shina taugalladijkunada Jesús rikushaga urkumu risha tiyariga. Paibuj yachagujkuna kuchuyakiga, ");
INSERT INTO qxl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Paiga yachachingu kallariga kashna nisha: ");
INSERT INTO qxl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kushiyachishka ganguichi, mashnalla Diosta ministishkada yuyarijkuna; Diosbuj mandanaga kangunajmigun. ");
INSERT INTO qxl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kushiyachishka ganguichi, llakigunan purijkuna; Diosga k'uyusha kushichingami. ");
INSERT INTO qxl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kushiyachishka ganguichi, na jatun tukujkuna; kangunamu Dios <kusha> nishka achpada japinguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kushiyachishka ganguichi, mashnalla yarijachij yakunachij shina kabishkada yallidij rurungu munujkunaga; kanguna munashkada sajsachishkama shinami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kushiyachishka ganguichi, mashnalla shujkunamunda llakirijkuna; shinaidi Diosga kangunadash llakiringami. ");
INSERT INTO qxl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kushiyachishka ganguichi, mashnalla linshu shunguguna; kangunami Diostaga rikunguichi. ");
INSERT INTO qxl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kushiyachishka ganguichi, mashnalla p'iñanukushkagunada allichijkuna; kangunami Diosbuj churi ushiguna nishka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kushiyachishka ganguichi, Dios mandushkada p'aktachishkamunda llakichisha katik'ichushkaguna; Diosbuj mandanaga kangunajmigun. ");
INSERT INTO qxl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ñukada katishkamunda rimukish imadadikish nisha llagmusha kangunada katik'ichukish, kushiyachishka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mejor kushilla ganguichi. Jawa pachabiga kangunamu alli kumbidanami tiyan. Shinaidimi ñauba Dios nishkada parlajkunadash katik'ichugaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kangunaga kai pachabi kausujkunamuga kachi shinami ganguichi. Kachi chamujyashaga ¿ima layadi kutin kachij tukunga? Imakish ña na valinchu. Ashtangarin ñanbi shituki genteguna sarunga. ");
INSERT INTO qxl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kangunaga kai pachabi kausujkunamunga p'unllayachij shinami ganguichi. Shuj jatun pueblo urkubi rurushkaga na pakalla gai pudinchu. ");
INSERT INTO qxl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Shinaidi pish luzta katichishaga mangan urisingusha churungujka na katichinchu. Ashtangarin mashnalla wasi ukubi tiyujkuna p'unllallabi tiyachunmi, katichisha jawamu churun. ");
INSERT INTO qxl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Shinalladij tukigunaj ñaubuki kangunash alli kausasha luz shina rikuchichi, kanguna alli rurushkagunada genteguna rikusha jawa pachabi tiyuj Taita Diosta jatunyachichunguna.” ");
INSERT INTO qxl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moisés mandushkada Dios nishkada parlujkuna yachachishkadash <Chingachingujmami kai pachamu shamushkanga> nishaga ama yuyunguichichu. Ñukaga na chingachingabuj shamushkanichu, ashtangarin alli yachachisha p'aktachingabujmi shamugani. ");
INSERT INTO qxl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kabishkadadimi nini; kai pachash, jawa pachash narij tukurikiga Dios mandashkagunamundaga shuj letra, shuj shimi, imawalladash ima ura tuki ima nishkaguna p'aktungagama na anchuchishkachunga. ");
INSERT INTO qxl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chimundami maijin kai mandashkagunamunda shujllada, p'ichillawa gakish, na kazusha, shujkunamush shinaidi rurachun yachachijka, Diosbuj mandanabiga uchilla nishkami ganga. Ashtan maijinbish Dios mandashkagunada kazusha shujkunamush shinaidi rurachun yachachijka Diosbuj mandanabiga jatun nishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Shinalladi kangunamu ninimi, Diosbuj ñaubuki allida rurusha kangunaga Moisés mandushkada yachachijkunadash fariseogunadash yalli na rurushaga Diosbuj mandanamunga ima layash na waigunguichichu.” ");
INSERT INTO qxl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesús parlusha katishaga, “Kangunaj ñauba taitagunamu Moisés kashna mandushkadaga uyushkanguichimi: ‘Ama wañuchinguichu; maijin wañuchijtaga juezbujmu pushusha juchachishka ganga.’ ");
INSERT INTO qxl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ashtangarin Ñukaga ninimi, maijinbish shujkunan p'iñarijtaga juezbujmu pushusha juchachishkami ganga. Maijinbish shujkunan p'iñarisha maidadikish rimujtaga israelgunada mandujkunapura tandanukushkabi juchachishkami ganga. Shinaidi maijinbish shujkunan p'iñarisha ‘Imadikish tukuchun’ nijka, uku pacha ninamu kachanallami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Shinakiga Diosmu imadash kumbidangu rigusha altar ñaubuki maijin kangun p'iñarishkada yuyarishaga ");
INSERT INTO qxl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kumbidanada narij kumbidashaidi chi altar ñaubuki sakisha paigundij alli tukungu ri. Chimundaga imada Diosmu kungu rigushkadash kutin vueltamushaga kunguilla. ");
INSERT INTO qxl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Maijinbish kanda juchachisha juezbujmu pushakiga ñanda rigushaidi narij juezbujmu chayushaidi ut'kada parlanukusha paigun alli tukungui, juezbujmu ama pushachun, juez guardamu ama kuchun, guarda carcelbi ama churachun. ");
INSERT INTO qxl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kabishkadadimi nini; ima ura illujta kuchkida pagusha tukuchingagama chimundaga na llujshinguichu.” ");
INSERT INTO qxl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kangunaga, ‘Ama wainayanguichu,’ nisha mandushkadash uyashkanguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ashtangarin Ñukaga ninimi, maijinbish shuj warmida purina yuyin rikushaga chi warmin paibuj yuyibi ñami wainayashka. ");
INSERT INTO qxl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Shinushaga kambuj alli ladu ñawi na alligunada rikusha juchabi urmachikiga llujshichisha kanmunda shiti. Allimi ganmu kambuj ñawilla chingarina, ashtan na illujta cuerpo uku pachamu shitushka ganaga. ");
INSERT INTO qxl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Shinalladi kambuj alli ladu maki juchabi urmachikiga p'itishtasha kanmunda shiti. Allimi ganmu kambuj cuerpomunda shujlla chingarina ashtan na tuki cuerpo illujta uku pachamu rinaga.” ");
INSERT INTO qxl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Shinaidi nigami, ‘Maijin k'aribish paibuj warmimunda partirijka, partirishkada rikuchingaj firmashka p'angadami kunagun.’ ");
INSERT INTO qxl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ashtangarin Ñukaga ninimi, maijin kusash nash warmi wainayaki partirijka, chi warmidaga wainayachunmi kachushka tukun. Shinalladi maijin k'arish partirishka warmin kazarajka wainayajmi tukun.” ");
INSERT INTO qxl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Chimundash kangunaj ñauba taitagunamu kashna mandushkadaga uyushkanguichimi, ‘Manduj Diosbuj shutida nisha <P'aktachishami> nisha na p'aktachishallaga ama sakinguichu. Ashtangarin Diosmu <P'aktachishami> nishkadaga p'aktachingui.’ ");
INSERT INTO qxl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Ashtangarin Ñukaga ninimi, <Jawa pacha> nishash ama parlunguichichu, Dios mandashka pushtu gashkamunda. <Kai pachamundash> ama ninguichichu, Dios chakida churusha samana pushtu gashkamunda. <Jerusalén pueblomundash> ama ninguichichu, Jatun Manduj Diosbuj puebloshkamunda. Shinaidi <Ñukachari imash tukusha> nishash ama ninguichichu. Kangunaj umamunda shuj juakchalladash yurujta yanadash na ruri pudinguichichu. Shinushami imamundash <P'aktachishami> nisha ama ninguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kanguna <ari> nishkaga shina gachun. Kanguna <mana> nishkash shina gachun. Kaimunda ashtan shuj shimigunada nishkaga diablomundami shamun.” ");
INSERT INTO qxl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘Maijinbish p'iñasha ñawida llujshichiki paidash ñawida llujshichingami; shinaidi kiruda p'akikish paidash kiruda p'akingami,’ nisha mandushkada uyushkanguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ashtangarin Ñukaga kangunada ninimi, kanda ima na allida rurakish kanga imadash ama rurunguichu. Ashtanbish maijin alli ladu ñawi ichibi lutskikiga chaishuj ladudash lutskichun rikuchilla. ");
INSERT INTO qxl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Maijinbish comisariojmu kayachisha kambuj camisada kichusha nikiga ashtanbish pillurishkadash apush richun saki. ");
INSERT INTO qxl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Maijinbish kanmu imadash apachisha, ‘Shuj kilometroda jaku,’ nisha mandukiga ashtanbish ishki kilometroda ringui. ");
INSERT INTO qxl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maijinbish imadash <Kubai> nikiga kunguilla. Shinaidi <Mañachibai> nikish ama mitsushalla mañachinguilla.” ");
INSERT INTO qxl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘Kangunan alli apanukujkunadaga k'uyungui; shinaidi kanda na rikunachijkunadaga p'iñungui,’ nisha mandushkadash uyashkanguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ashtangarin Ñukaga ninimi, kangunada na rikunachijkunada k'uyichi, shinalladi kangunada p'iñusha katik'ichujkunamundash Diosta mañichi. ");
INSERT INTO qxl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Shina rurushami jawa pachabi tiyuj kangunaj Taita Diosbuj churigunashkada rikuchinguichi. Paimi alligunamu na alligunamush Paibuj indida llujshichisha rupida shitachin. Shinalladi Dios mandushkada rurujkunamu, na rurujkunamush tamiada kachun. ");
INSERT INTO qxl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kangunada k'uyujkunallada k'uyushaga ima kumbidanadash Diosmundaga na japinguichichu. Kanguna layaidimi impuestoda cobrujkunash rurunguna. ");
INSERT INTO qxl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kangunapuralla <¿Allillachu gangui?> nishaga ¿paigunada yallichu ruranguichi? ¿Diosta na rijsijkunash nachu shinaidi rurunguna? ");
INSERT INTO qxl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Shinushaga ima layami kangunaj jawa pachabi tiyuj Taita Dios alligunallada ruruj gan, shinaidi kangunash alligunaida rurunguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús yachachish katisha kashna niga: “Ima alligunada rurushash p'akta gentegunaj ñaubuki paiguna rikuchun nishalla rurunguichimu. Shina rurukiga jawa pachabi tiyuj kangunaj Taitaga ima alli kumbidanadash na kungachu. ");
INSERT INTO qxl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Shinushaga ima ura maijin imada ministijkunamu kushaga ishki siki imadash nij tukushalla purijkuna laya ama buzinada tukujma laya tukigunamu yachi chayachinguichichu. Paigunami genteguna alli parlushka gangu munushalla, Diosmunda yachana wasigunabish shinaidi ñangunabish shujkunamu parlunguna. Kabishkadadimi nini, paigunaga <Alligunamigun> nisha genteguna parlushkalladami japingaguna. ");
INSERT INTO qxl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Shinushaga kangunaga ima ura imadash ministijkunamu kumbidashaga kangunan yalli apanukujkunamush ama parlunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Imada kumbidashash pakalla pish na rikujllabi kuki kangunaj Taita Dios pakalla rurushkada rikujka, kangunamush alli kumbidanada kungami.” ");
INSERT INTO qxl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kanguna Diosta mañushaga nij tukushalla ishki sikiguna laya ama gaichichu. Paigunami genteguna rikuchun nishalla Diosmunda yachana wasigunabi shinaidi genteguna purina ñan manyagunabish shayarisha mañunguna. Shinushaga kabishkadadimi nini, paigunaga <Alligunamigun> nisha genteguna parlushkaidami japingaguna. ");
INSERT INTO qxl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ashtan kanga Diosta mañushaga kambuj ukumu waigusha punguda ichkusha pakalla kambuj Taitada mañungui. Taita Dios pakalla rurushkada rikujka alli kumbidanadami kanmu kunga. ");
INSERT INTO qxl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Diosta mañushaga Paida na rijsijkuna mañushka layaidi ama chi shimigunalladadij ñalla ñalla mañunguichichu. Paigunaga taugalladi shimigunada parlarishkamundaga <Uyushkami gashun> nisha yuyunguna. ");
INSERT INTO qxl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Shinushaga ama paiguna laya gaichichu. Imada ministishkadash kanguna narikish mañujllabidimi kambuj Taitaga ña yachun. ");
INSERT INTO qxl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kangunaga kashna laya mañunguichi: ‘Jawa pachabi tiyuj ñukuchij Taita Dioslla, Kan jucha illuj gashkamunda <Alli> nishka gachun. ");
INSERT INTO qxl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kambuj mandana shamuchun. Ima layami Kan munashkada jawa pachabi rurushka gan, shinaidi kai pachabish rurushka gachun. ");
INSERT INTO qxl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ñukuchimu p'unllandi ministishka tandada kunun kubai. ");
INSERT INTO qxl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ñukuchida na alli rurujkunada perdonaganchimi, shinaidi ñukuchij juchagunada perdonabai. ");
INSERT INTO qxl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jucha ruranagunabi urmachunga amalladi sakibaichu, ashtangarin na alligunamunda wakichibai.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesús yachachish katishaga, “Shujkuna kangunada na alligunada rurusha p'iñachijkunada perdonakiga kangunaj jawa pachabi tiyuj Taita kangunadash perdonangami. ");
INSERT INTO qxl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ashtangarin shujkunada na perdonakiga kangunaj juchagunadash kangunaj Taita na perdonangachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kangunaga na mikusha Diosta mañusha kainashaga ishki siki nij tukushalla purijkuna rurushka laya ama llakilladi tukusha rikuchichichu. Paigunami na mikusha kainagushkada gentegunamu rikuchingaj nishalla urmarishka ñawi tukunguna. Kabishkadadimi nini, kaibi genteguna <Alligunamigun> nishkalladami japingaguna. ");
INSERT INTO qxl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ashtangarin kanga na mikusha Diosta mañusha kainashaga kambuj uma juakchada nakchari; ñawidash mailli, ");
INSERT INTO qxl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","na mikusha kainashkada gentegunamu ama rikuchingu, ashtanbish kambuj Taita Dioslla rikuchun. Kangunaj Taita Diosga pakalla rurushkada rikuj gashami kangunamush alli kumbidanada kunga.” ");
INSERT INTO qxl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yalli valijkunadaga ama kai pachabi tandachisha charichichu, maibimi polillagunash mikunlla; ima charishkagunash wakushka jirru laya tukuringallami; shinaidi shuwagunash waigusha shuwanllami. ");
INSERT INTO qxl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ashtangarin yalli valijkunada jawa pachabi tandachichi, maibimi polillash na mikunga; ima charishkash na tukuringa; chibimi shuwagunash na waigunga. ");
INSERT INTO qxl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yalli valijkunadaga maibimi wakichinguichi, kangunaj shunguga chibimi yuyagun.” ");
INSERT INTO qxl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kambuj ñawigunami cuerpobuj luz shinagun. Shinushaga kambuj ñawi alli rikukiga tuki kambuj cuerpomi p'unllagun. ");
INSERT INTO qxl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kambuj ñawi na alli rikukiga kambuj cuerpoga tutabi layaminga. Shinushaga kambuki tiyuj luz tuta laya gakiga ¡yanamangagarin ima layashi ganga!” ");
INSERT INTO qxl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ishki trabajachij nishkadaga pish na ruri pudinchu. Shujta p'iñungami, chaishujta llakingami. Na gashaga shujtaga paillada k'uyunga, kaishujtaga na rikunachinga. Shinushaga charij ganaida yuyagusha Diosbujllada rurush nishash ishkimunga na ruri pudinchu.” ");
INSERT INTO qxl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Chimundami ñukaga kangunada kashna nini: Kangunaj kausibiga <¿Imadadi mikushun? ¿Imadadi ubiashun? ¿Imadadi churarishun?> nisha, ama mancharij shina chi yuyilla gaichichu. ¿Kausiga nachu mikunada yalli valin? ¿Kikinbuj cuerpoga nachu churanadash yalli valin? ");
INSERT INTO qxl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jawada vuluj pishkugunada rikusha yuyarichi. Paigunaga na tarbunchu. Granudash na tandachisha wakichinchu. Shina gakish jawa pachabi tiyuj Taitaga karanllami. Kangunagarin pishkugunadash yallimi valinguichi. ");
INSERT INTO qxl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Shinaidi maijinsh chaida kaida yuyarishash kikinbuj kausidaga shuj urawaidash na mirachi pudinchu. ");
INSERT INTO qxl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Imamundadi kangunaga churanamunda mancharij shina kaida chaida yuyaringuichi? Rikunguichimungandi tarbushkabi iñuj lirio sisagunada. Chigunaga imadash na rurungunachu, puchkidash na puchkungunachu. ");
INSERT INTO qxl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Shinash kangunada ninimi, Rey Salomonbish pai tukida charij gashash kai sisaguna laya k'uilladaga na churarigachu. ");
INSERT INTO qxl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kununga k'iwaguna tarbunabi iñagun. Kayaga jurnubi shitana gakish Diosga k'uilladami sisachin. Kangunamungarin churanada kungami. ¡Na tuki shungun crij genteguna! ");
INSERT INTO qxl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chimundaga ‘¿Imadadi mikushun? ¿Imadadi ubiashun? ¿Imadadi churarishun?’ tapusha ama kaida chaida yuyunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kai tukigunadaga Diosta na rijsijkunami shina mancharij laya kaida chaida yuyarisha puringuna. Ashtangarin kangunaj jawa pachabi tiyuj Taitaga imada ministigushkagunadash ñami yachun. ");
INSERT INTO qxl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Shinusha kallarimunga Diosbuj mandanada shinaidi Pai mandushkada p'aktachinadash mashkichi. Shina kausakiga Diosga kangunamu ima ministishkagunadami kunga. ");
INSERT INTO qxl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Shinushaga <Kayaga ¿ima tukungashi?> nishaga mancharij laya ama chi yuyilla gaichichu. Ima llakigunash tuki p'unllagunami shamun. Shinushaga kaya ima tukunadash kayalladimi yuyarina gan.” ");
INSERT INTO qxl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Shujkunada ama juchachinguichichu, kangunadash Dios ama juchachichun. ");
INSERT INTO qxl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ima shinami shujkunada juchachinguichi, shinalladimi Diosga kangunadash juchachinga. Ima layami shujkunada rurunguichi, shinalladijmi rurushka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kambuj waukij ñawibi uchinlladi astis tiyajtaga ¿imamundadi rikungui, kambuj ñawibi jatun kaspi tiyashkadash narij rikushaidijka? ");
INSERT INTO qxl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kambuj ñawibi jatun kaspi tiyakiga kambuj waukidaga, ‘Kambuj ñawibi tiyaj uchilla astista ñuka llujshichingu saki,’ nisha ¿ima layadi ni pudinguiri? ");
INSERT INTO qxl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ishki siki! Kambuj ñawimundadi jatun kaspida surkiri. Shina rurushami alli rikusha kambuj waukij ñawibi uchilla astis tiyajtash surki pudingui. ");
INSERT INTO qxl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Diosllamu ch'ikunyachishkadaga ama achkugunamu shitichichu. Kangunalladadimi vueltarisha kanisha chugrichishtangaguna. Shinaidi kangunaj k'uilla perlagunadash k'uchigunamush ama shitichichu chakigunan saru saru rurachunllaga.” ");
INSERT INTO qxl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mañichi, Diosga kungallami. Mashkichi, japinguichillami. Kayichi, punguda kangunamu paskangallami. ");
INSERT INTO qxl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maijin mañujka japingami; maijin mashkujkish japingami; shinaidi kayujmush paskangallami. ");
INSERT INTO qxl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kangunaj churi tandada mañukiga maijinbish na rumida kunguichimuchu. ");
INSERT INTO qxl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Shinalladi chaulada mañukish na culebrada kunguichimuchu. ");
INSERT INTO qxl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kanguna na alliguna gashash kangunaj churigunamunga alligunada kungu yachunguichindi. Shina gakiga ¡kangunaj jawa pachabi tiyuj Taitagarin maijin mañujkunamunga alligunadami kunga! ");
INSERT INTO qxl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Shinakiga ima layami shujkuna kangunamu rurachun mununguichi, shinaidimi kangunash paigunamu rurananguichi. Kaimigun Moisés mandushka, shinaidi Dios nishkada parlujkuna yachachishkash.” ");
INSERT INTO qxl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kichki punguda waiguichi. Uku pachamu waiguna punguga jatunmi; ñanbish anchumi. Chidaga taugagunami rin. ");
INSERT INTO qxl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ashtangarin na tukurij kausanamu pushuj ñanga jinchilladimigun, pungubish kichkimi. Ashallagunami chi ñandaga japinguna.” ");
INSERT INTO qxl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Diosmunda llagmusha yachachijkunamunda yuyin ganguichi. Paigunami ovejaguna laya kangunamu shamunguna. Ashtangarin paigunaj uku shungubiga p'iña loboguna layamigun. ");
INSERT INTO qxl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kangunaga paiguna rurushkagunabimi rijsinguichi. Uvadaga na pallunchichu kasha yuramundaga; shinaidi jigustash na chini yuramundaga pallunchichu. ");
INSERT INTO qxl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Shinalladi alli yuraga alli granudami aparin. Na alli yuraga na alli granudami aparin. ");
INSERT INTO qxl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Alli yuraga na alli granudaga mana aparinchu. Na alli yurash alli granudaga na aparinchu. ");
INSERT INTO qxl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Maijin alli granuda na aparij yuradaga p'itisha ninabimi shitanagun. ");
INSERT INTO qxl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Shinushaga kangunaga chi llullajkunada imada rurushkabimi rijsinguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ ‘Mandujlla, Mandujlla,’ nisha Ñukada nijkunamunda na tukigunaga Diosbuj mandanamu waigungachu, ashtangarin jawa pachabi tiyuj Ñukaj Taita munushkada rurujkunalla. ");
INSERT INTO qxl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chi p'unllaga taugagunami Ñukada ninga, ‘Mandujlla, Mandujlla, ñukuchiga ¿nachu Kambuj shutibi Diosmunda parluganchi? ¿Nachu Kambuj shutibi yanagunadash llujshichisha kachuganchi? Shinaidi Kambuj shutibi pish na ruri pudishkagunada ¿nachu taugada ruruganchi?’ ");
INSERT INTO qxl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Shina nikiga Ñukaga kashnami nisha, ‘Kangunaga Ñukamunga na rijsishkagunachunguichi; Ñukamunda anchichi milligunada rurujkuna.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Shinushaga maijin Ñuka nishka shimigunada uyusha kazujka alli yuyiyuj k'ari wasida rumi jawabi ruruj layami. ");
INSERT INTO qxl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chi wasi rumi jawabi rurushka gashkamunda mashna tamia shamusha yakuguna mirarisha waira manchanaidi lutskigukish na urmagachu. ");
INSERT INTO qxl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Shinakiga maijinbish Ñuka nishka shimigunada uyushash na kazujka yuyi illuj k'ari wasida yugzi achpa jawabi ruruj layami. ");
INSERT INTO qxl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tamia shamusha yakuguna mirarisha waira p'ukusha lutskiguki chi wasiga pambamu urmugallami. Shinushaga manchanaidimi llaki tukuga.” ");
INSERT INTO qxl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Shina Jesús parlusha tukuchikiga mashnalla chibi tiyujkunaga Jesús ima laya Paibuj yuyillan yachachisha na Moisés mandushkada yachachijkuna laya yachachishkada uyusha mancharishkaidi kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús urkumunda uriyagukiga taugalladigunami Paida katisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Shina rigukimi lepran ungushka k'ariga Jesusbuj ñaubujmu kuchuyasha kungurishaga kashna niga: “Manduj Jesús, Kan munushaga lepradaga ñukamunda p'ichushti pudinguimi.” ");
INSERT INTO qxl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chimunda Jesusga, “Ari, munanimi,” nisha Paibuj makin tupasha, “¡Linshuyi!” nin ñash leprayujka alliyagallami. ");
INSERT INTO qxl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chi k'ipa Jesusga kashna nisha manduga: “P'akta pimush parlanguimu. Kambuj lepra ungui anchushkada tukiguna yachachunguna ri, curamu rikuringui, shinaidi Moisés mandushka shina Diosmu kunada apusha ringui.” ");
INSERT INTO qxl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaúm pueblomu Jesús waigukimi, Roma llaktamunda soldadogunada mandujka, Jesusbuj kuchumu mañungu kuchuyaga kashna nisha: ");
INSERT INTO qxl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Manduj Jesús, ñukada sirvijmi wasibi ungushka na kuyuri pudisha sirin. Shinaidi nanigunash paida manchanaidi llakichigun.” ");
INSERT INTO qxl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Shina niki Jesusga, “Ñuka alliyachingu risha,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Soldadogunada manduj kashna niga: “Manduj Jesuslla, Kan ñukaj wasimu waiguchunga ñukaga imash na ganichu. Alliyachun nillada nibai. Shina nikiga ñukada sirvijka alliyangallami. ");
INSERT INTO qxl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ñukalladi jatun mandujkuna mandashkallami kausani; shinaidi ñukash soldadogunadami mandani. Ñuka shuj soldadoda ‘Ri’ niki rinllami. Shujta ‘Shami’ nikish shamunllami. Shinaidi ñukada sirvijta imadash rurachun mandukiga rurunllami.” ");
INSERT INTO qxl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús shina nijta uyushaga kushilla sakirisha Paida katijkunamu shina niga: “Kabishkadadimi nini, Israelbi pilladash kai k'ari laya tuki shungun crijtaga na rijsishkanichu. ");
INSERT INTO qxl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Shinaidi ninimi, taugalladigunami tuki ladumunda kai k'ari laya shamungaguna. Diosbuj mandanabi ñauba taita Abraham, Isaac, Jacobgunbish mizabi mikungu tiyaringaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ashtanbish Diosbuj mandanabi tiyanagunaga uku pacha yanamangabimi shitushkaguna ganga. Chibimi kirugunash kanirisha karrusk'ichisha wakungaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chi k'ipa soldadogunada mandujta Jesusga, “Wasimu rilla. Kan crishka shina tukuchun,” niga. Shina ninmi paida sirvijka alliyaga. ");
INSERT INTO qxl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedroj wasimu Jesús rishaga Pedroj suegrada rupuj unguin sirijta rikuga. ");
INSERT INTO qxl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Shina sirijta Jesús makibi tupunmi rupuj unguiga anchuga. Chimunda chi warmiga jatarisha paigunamu karungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ña tutayagukimi, Jesusbuj kuchumu tauga yana katishkagunada pushamugaguna. Shuj shimi nishkallanmi chi yanagunada llujshichish kachuga, shinaidi tuki ungushkagunadash alliyachigallami. ");
INSERT INTO qxl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dios nishkada parluj Isaiasga, “Paimi ñukuchij unguigunada shinaidi ñukuchij nanigunadash apaga,” nisha parlashka p'aktachunmi kaigunaga shina tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús Paibuj muyundijbi taugalladigunada rikushami yachagujkunamu <Yaku kuchada ch'imbashunchi> niga. ");
INSERT INTO qxl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Narij rijllabidi Moisés mandashkagunada shuj yachachij kuchuyashaga kashna niga: “Yachachij, maimu rikish kandami katish ringu munani.” ");
INSERT INTO qxl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Shina niki Jesusga kashna niga: “Zorroguna maibi kausana ut'kuda charinmi. Pishkugunash tazinlladash charingunami. Ashtangarin Aichayuj tukushka Churiga maibi samanaidash na charinchu.” ");
INSERT INTO qxl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Paibuj yachagujkunamunda shujka, “Manduj Jesús, ñukaj taitadadi pambangu ringu shuyabai,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Shina niki Jesusga, “Ñukada katimi. Wañushkagunaidi paigunaj wañushkagunada pambachun saki,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chimundaga Jesús barcabi sikuki Paibuj yachagujkunash rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Shina rigukimi ñash manchanaidi waira tamia shamusha yaku kuchada jatarichiki barcabi yaku jundungu kallariga. Shinash Jesusga puñurishkamiga. ");
INSERT INTO qxl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Shinushami Paibuj yachagujkuna Jesusta rijchachingu kuchuyashaga, “¡Manduj Jesús, kishpichibairi! Ña wañugunchijka,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Shina niki Jesusga, “¿Imasha manchanaidi mancharinguichi? ¡Ashaida crijkuna!” niga. Shina nishka k'ipaga jatarisha wairadash yakudash, chulunlla tukuchun mandukiga chi pushtubimi tuki chulunlla sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chi k'ariguna chida rikushaga, “¿Pishigun kai k'ariga? Wairama yakumash Paida kazunllandi,” nisha mancharishkaidi tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús yaku kuchada ch'imbusha Gadara llaktamu chayukiga ishki yana katishka k'arigunami pantiunmunda llujshisha Jesusbujmu kuchuyagaguna. Chigunaga millilladigunashkamunda chi pushtu ñandaga pish na pasi pudijchuga. ");
INSERT INTO qxl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ñash kaparigaguna kashna nisha: “Diosbuj Churi Jesús, ¿ñukuchinga imada rikuna charingui? ¿Narikish p'unlla p'aktujllabidichu ñukuchida llakichingu shamugangui?” ");
INSERT INTO qxl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chimunda chainijllamumi taugalladi k'uchiguna mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chi k'arigunabi tiyuj yanaguna Jesusta, “Ñukuchida kaimunda llujshichishtushaga chi k'uchigunabi waiguchun sakibai,” nisha mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús, “Richilla,” niki chi yanaguna k'arigunamunda llujshishaga k'uchigunabi waigunmi, tuki k'uchiguna ut'kada risha k'akada uriyasha yaku kuchamu urmusha wañugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chi k'uchigunada michijkunaga mancharishkaidi rigaguna. Ña pueblomu chayushaga tuki ima tukushkadami, shinaidi ima laya yana katishka k'ariguna tukushkadash parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Shinushami tuki chi pueblomunda gentegunaga maibi Jesús purishkamu rigaguna. Jesusta rikushaga chi pueblomunda richun nisha mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kai k'ipami, Jesusga barcabi sikusha yaku kuchada ch'imbusha Paibuj pueblomu chayuga. ");
INSERT INTO qxl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chimu chayuki na kuyurij k'arida wandunabi apushka Jesusbuj kuchumu chayugaguna. Paiguna Diosta crishkada Jesús rikushaga chi ungushkada kashna niga: “Kushilla gai, Ñukaj k'uyashka. Kambuj juchagunaga p'ichushkami gan.” ");
INSERT INTO qxl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Moisés mandushkada yachachijkunamunda shujkunaga, “Pai nishkaga Diosta imakish na valichishkamigun,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Paiguna ima yuyashkada Jesús yachushaga tapuga, “¿Imasha kangunaga shina na alli yuyigunada charinguichi? ");
INSERT INTO qxl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Maijindikun ashtan jawalla ruranaga? ‘Kambuj juchagunaga p'ichushkami gan’ ¿ninachu? Na gashaga ‘Jatarisha rilla’ ¿ninachu? ");
INSERT INTO qxl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aichayuj tukushka Churiga kai pachabi juchagunada p'ichi pudishkada rikuchingami,” nishka k'ipaga chi na kuyuri pudijta kashna niga: “Jatari. Kanda wandumushkada japisha wasimu ri.” ");
INSERT INTO qxl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Shina nikimi, chi na kuyurijka jatarisha wasimu riga. ");
INSERT INTO qxl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chida rikusha taugaguna mancharishaga shina alliyachingu pudinada kai k'arimu kushkamunda Diosta <K'uillami gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús chimunda rigushami impuestoda cobrana pushtubi tiyaj Mateo shuti k'arida rikushaga, “Jaku, katimi,” niga. Chimundami Mateoga jatarisha Jesusta katisha riga. ");
INSERT INTO qxl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chi k'ipa Jesús wasibi mikuki tauga impuestoda cobrujkuna, shinalladi juchabi kausujkunash chayushaga Jesuskun shinaidi Paibuj yachagujkunandij mizabi mikungu tiyarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kaida rikushami Jesusbuj yachagujkunada fariseoguna tapuga, “Kangunada yachachijka ¿imamundadi impuestoda cobrujkunan shinaidi juchabi kausujkunan mikun?” ");
INSERT INTO qxl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Shina tapujta Jesús uyasha kashna niga: “Na ungushkagunaga jambijta na ministinchu. Ungushkagunallami jambijta ministin. ");
INSERT INTO qxl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Richi kai escribishkabi ima nishkada yachunguichi: ‘Animalgunada wañuchisha kumbidajkunalla gachunga na munanichu, ashtanbish shujkunamunda llakirijkuna gachunmi yalliga munani.’ Shinushaga Ñukaga na shamuganichu kabishkada rurujkunamunga, ashtangarin juchayujkuna Diosmu kuchuyachunmi shamugani.” ");
INSERT INTO qxl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chimundaga Bautizaj Juanchuda katijkunaga Jesusmu kuchuyasha tapugaguna, “Fariseogunash, ñukuchikish na mikusha Diosta mañusha tauga kutin kainunchindi. ¿Imasha Kambuj yachagujkunaga na shina rurunguna?” ");
INSERT INTO qxl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Shina niki Jesusga niga, “Shuj bodamu kayushkagunaga novio paigunan purigukiga ¿llakilladi gai pudinchu? Ashtangarin novioda pushusha rina p'unlla chayamungami. Chibimi na mikusha Diosta mañungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mauga churanabiga mushuj linsudaga pish na p'utyunchu. Shina rurukiga mushuj linsuga tandarisha mauga churanada llikichiki ashtan llikimi sakiringa. ");
INSERT INTO qxl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Shinaidi mauga p'urugunash tugyanashkamunda rurushkalla vinoda karan rurushka mauga p'urugunabiga na churanachu. Shina tugyukiga vino jicharinga; shinaidi p'urubish chingaringami. Shinushami rurushkalla vinodaga mushuj kara p'urugunabi churanagun. Chibimi vinosh p'urush imash na tukunga.” ");
INSERT INTO qxl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús kaigunada parlaguki Israelbi ashallada manduj ñash kuchuyashaga Jesusbuj ñaubuki kumurisha kungurisha kashna niga: “Ñukaj ushiga ñami wañun. Ashtan Kan shamusha makida paibuj jawabi churabai; shina rurukiga kausaringallami.” ");
INSERT INTO qxl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Shina niki Jesús jatarishaga Paibuj yachagujkunandij paida katisha riga. ");
INSERT INTO qxl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Shina rigukimi shuj warmi chunga ishki watada yaur shitusha purij, washa ladumunda kuchuyasha Jesusbuj churana manyada ñash tupuga. ");
INSERT INTO qxl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chi warmiga <Jesusbuj churanada tupushkanllash alliyashami> nisha yuyuga. ");
INSERT INTO qxl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chimunda Jesús vueltarisha chi warmida rikusha kashna niga: “Kushilla gai, Ñuka k'uyashka. Ñukada crishkallamundami alliyashkangui.” Shina nin, chi warmiga alliyagallami. ");
INSERT INTO qxl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ashallada mandujbuj wasimu Jesús chayushaga flauta tukujkunada shinaidi genteguna wakush kaparigujta rikusha, ");
INSERT INTO qxl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kashna niga: “Kaimunda richi. Kai maraga na wañushkachugun; ashtanbish puñugunmi.” Shina niki genteguna Jesusta asigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tuki chibi gajkunada llujshichishaga waigusha, chi maraj makida chaririki maraga jatarigallami. ");
INSERT INTO qxl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Shina rurushkadaga tuki chi llaktabimi yachi chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chimunda Jesús llujshisha rigukimi ishki ciguguna katishaga, “¡Ñukuchida llakiribai Rey Davidbuj Churi!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús wasimu waigushami, ciguguna kuchuyamuki tapuga, “¿Kangunada sanuyachi pudinashkada cringuichichu?” Shina niki, “Ari, Manduj Jesús,” nigagunami. ");
INSERT INTO qxl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chimundami Jesús ñawigunada tupusha kashna niga: “Kanguna crishka laya tukuchun.” ");
INSERT INTO qxl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Shinami cigugunaga rikuj tukugaguna. Chi k'ipa Jesusga, “P'aktalladi pish yachuj chayanmu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ashtangarin chimunda llujshinmi, Jesús imada rurushkada tuki chi llaktabi parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Paiguna llujshigukimi shuj k'arida Jesusbujmu pushushka chayugaguna. Paiga yana katishkamundami upa tukushkaga. ");
INSERT INTO qxl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Chi yanada upamunda Jesús llujshichikiga chi upaga ñash parlugallami. Chida rikusha taugagunami kushilladi tukusha, “Kai layadaga Israel llaktabiga ima urash na rikushkanchichu,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ashtanbish fariseogunaga, “Kai k'arimunga yanagunada manduj llujshichichikimi yanagunada llujshichishtan,” nisha ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesusga tuki jatun pueblogunabi uchilla pueblogunabish, Diosmunda yachana wasigunabi yachachisha puriga. Diosbuj mandanamunda Alli Shimida parlaga. Shinalladi tuki unguiyuj naniyujkunada alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesús taugalladigunada rikushaga paiguna llakilladi, shitushka laya, ovejada michij illuj layama purishkamunda, paigunada shungundijta llakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Shinusha chi gentegunamundaga Paibuj yachagujkunada, “Tandanalla granugunaga milgadimigun; tandachijkunaga ashallami. ");
INSERT INTO qxl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Shinusha tandachijkunada ashtan kachachun nisha Granuyuj Manduj Diosta mañichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chunga ishki Paibuj yachagujkunada Jesús kayusha paigunamu poderda kuga, na alli espiritugunada llujshichishtachun shinaidi tuki unguiyuj naniyujkunadash alliyachichun. ");
INSERT INTO qxl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kaigunamigun chunga ishki agllushka apostolgunaj shutiguna: kallarimu Simón nishka (pailladi Pedro shuti), paibuj wauki Andikush; Zebedeoj churiguna Jacobo, paibuj wauki Juanchush; ");
INSERT INTO qxl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipesh, Bartolomesh, Tiumash, shinaidi sarun impuestoda cobruj Mateosh; Alfeoj churi Jacobosh, Tadeosh, ");
INSERT INTO qxl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón Celote nishka, shinalladi Judas Iscariote; kaimi k'ipaga Jesusta wañuchisha nijkunamu japichiga. ");
INSERT INTO qxl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kai chunga ishkigunadami Jesús kashna nisha mandusha kachuga: “Ama ringuichichu na israelguna kausushka pushtumuga. Samaria pueblogunamush ama waigunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ashtanbish Israel llaktabi chingushka oveja layagunajmu ringuichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kashna parlungu risha, ‘Diosbuj mandanaga kuchuyamunmi,’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ungushkagunada alliyachichi. Wañushkagunadash kausachichi. Lepra unguiyujkunadash linshuyachichi. Shinalladi yanagunadash llujshichichi. Kaigunada rurushaga kai poderda yanga japishkamundaga ama cobrunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ima kuchkidash chumbillishkabi ama apusha ringuichichu. ");
INSERT INTO qxl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Shinaidi kipidash, shuj churanadash, pargatidash, shinaidi taunalladash ama apusha ringuichichu. Maijinbish trabajashkamundaga mikunash kabinmi. ");
INSERT INTO qxl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Maijin pueblomush chayushaga alli shunguyujta mashkichi; shinushaga chi wasibi sakiringuichi chi pueblomunda ringagama. ");
INSERT INTO qxl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chi wasimu waigushaga ‘K'uilla kausida Dios kuchun’ nisha mashnalla chibi kausujkunan saludanguichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chi wasibi kausujkuna kangunada alli shungun japikiga ‘K'uilla kausida Dios kuchun’ nishkaga p'aktungami. Na alli shungun japikiga chi nishkaga na p'aktungachu. ");
INSERT INTO qxl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kangunada na japish niki, Diosmunda parlukish na uyanachikiga chi wasimunda pueblomundash llujshisha risha chakimunda achpada chaspisha ringuichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kabishkadadimi nini, alli rurushkada na alli rurushkada Dios rikusha juchachina p'unllabiga Sodoma Gomorra pueblobi kausujkunadash yallimi chi pueblodaga llakichishka ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Rikichi! Ñukami kangunada ovejagunada laya lobogunaj chaubimu kachani. Shinushaga culebra laya imamundash yuyin ganguichi; shinaidi palomaguna laya alli shungu gaichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gentegunamunda yuyin ganguichi. Paigunaga mandujkunapura tandanukushkabi kangunada kungagunami; shinaidi Diosmunda yachana wasigunabish azilgun dalingagunami. ");
INSERT INTO qxl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Shinaidi mandujkunamush jatun mandujkunamush Ñukaj yachajkuna gashkamunda paigunaj ñaubujmu pushushkami ganguichi. Shina rurukiga paigunamush na israelgunamush Ñukamunda parli pudinguichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ima ura mandujkunaj ñaubujmu pushuki kaida chaida yuyarisha <¿Imada nishun? ¿Ima laya nishun?> nisha ama mancharinguichichu. Parlarina ratu chayukiga Dioslladimi ima nina shimigunadash kunga. ");
INSERT INTO qxl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Shinushaga na kangunaga parlunguichichu; ashtangarin kangunaj Taita Diosbuj Espiritulladimi kangunamu parlachinga. ");
INSERT INTO qxl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Waukibish kikinbuj waukidami wañuchichun kunga; taitash paibuj churida. Shinaidi churigunash taita mamada p'iñusha wañuchichun kunga. ");
INSERT INTO qxl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Shinushaga Ñukada katishkamunda tukigunami na rikunachinga. Shinaidi maijinbish tukurina p'unllagama Ñukada tuki shungun crisha katijka kishpichishkaminga. ");
INSERT INTO qxl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Shuj pueblobi Ñukamunda katik'ichukiga shuj ladumu mitikusha ringuichi. Kabishkadadimi nini, narikish tuki Israel llaktabi illujta tukuchijllabidimi Aichayuj tukushka Churiga vueltamunga. ");
INSERT INTO qxl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maijin yachagujka yachachijtaga na yallichu. Shinaidi mandushkada rurujbish na paibuj mandujtaga yallichu. ");
INSERT INTO qxl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yachagujka paibuj yachachijkun igulda yachuj gangujllami munana gan; mandushkada rurukish paibuj manduj laya. Shinaidi wasibi mandujta, ‘Yanagunada manduj Beelzebú’ nisha nikiga paibuj familiadagarin ¿nachu shinaidi ningaguna?” ");
INSERT INTO qxl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Shinushaga gentegunamunda ama mancharinguichichu. Ima pakushkash rikuchishkadiminga. Imada washalla rurushkash k'ipaga yacharingaidimi. ");
INSERT INTO qxl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tutabi Ñuka nishkadash kangunaga p'unllabi parlunguichi; shinaidi rinrin sikibi parlanukushkadash wasi jawamunda jinchida kaparinguichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama manchichichu, kangunaj aichada wañuchijtaga; kambuj almadaga na wañuchi pudingachu. Ashtangarin, uku pacha ninamu shitusha almadash aichadash chingachi pudij Diosta manchichi. ");
INSERT INTO qxl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“¿Nachu ishki pishkulladash shuj monedallabi k'atunguna? Shina gakish shuj pishkullash na urmasha wañunchu, narikish Taita Diosbuj muni gakiga. ");
INSERT INTO qxl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kangunadagarin Taita Diosga kangunaj uma juakchada mashna charishkadash illujtami yachun. ");
INSERT INTO qxl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Shinushaga ama manchunguichichu. Kangunaga tauga pishkugunadash yallimi valinguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Maijinbish Ñukada gentegunaj ñaubuki <Rijsinimi> nijtaga jawa pachabi tiyuj Ñukaj Taitaj ñaubuki Ñukash paidaga <Rijsinimi> nishami. ");
INSERT INTO qxl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Shinaidi maijinbish gentegunaj ñaubuki Ñukada rijsishash <Na rijsinichu> nijtaga jawa pachabi tiyuj Ñukaj Taitaj ñaubuki Ñukash <Na rijsinichu> nishami.” ");
INSERT INTO qxl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesús parlarish katishaga kashna niga: “ ‘Kaibi kausujkunamu k'uilla kausida kungumi kai pachamu shamushkanga,’ nishaga ama yuyunguichichu. Ñukaga k'uilla kausida churungujka na shamuganichu; ashtanbish p'iñanukunada churungumi shamugani. ");
INSERT INTO qxl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Churiga paibuj taitagun, ushiga paibuj mamungun, shinaidi k'achunbish paibuj suegrandij, shina p'iñanukida churungumi shamugani. ");
INSERT INTO qxl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Shinakiga kikingunaj familiapurallamundadimi kashna na rikunachijkunaga tiyunga. ");
INSERT INTO qxl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ñukadash yalli kikinbuj taita mamada k'uyajka Ñukada katij tukunaga na kabinchu; shinaidi kikinbuj churidash ushidash yalli k'uyajka, Ñukada katij tukunaga na kabinchu. ");
INSERT INTO qxl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Maijinbish cruzta aparishka shina Ñukada na katijka Ñukaj tukunaga na kabinchu. ");
INSERT INTO qxl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Maijinsh kikinbuj kausida yalli llakirijka, na tukurij kausidaga na japingachu. Ashtanbish maijin Ñukada katishkamunda kikinbuj kausida na llakirijka, na tukurij kausidaga japingami.” ");
INSERT INTO qxl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Maijinbish kangunada alli japijka, Ñukada japishka layaidimi japin. Shinaidi maijin Ñukada japijka Ñukada kachuj Taita Diosta japishka layaidimigun. ");
INSERT INTO qxl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Maijinbish Diosbuj randi shamushkamunda Dios nishkada parlujta wasibi alli japijka, ima kumbidanadash Dios nishkada parlujmu kumbidana layaidadimi japinga. Shinaidi Dios mandushkabi kausuj shuj alli k'arida pai allilladishkamunda japijka chi alli k'arimu kumbidana layaidadimi japinga. ");
INSERT INTO qxl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Shinaidi Ñukaj yachagujkunashkamunda maijinbish imash na gaj shinagunamu shuj pilchi chiri yakuidash kujka, kabishkadadimi nini, ima kumbidanagunadash japingami.” ");
INSERT INTO qxl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús Paibuj chunga ishki yachagujkunamu imada ruranada yachachishka k'ipaga israelgunaj pueblogunabi Diosbuj Shimida parlungu shinaidi yachachingu chi pushtumunda riga. ");
INSERT INTO qxl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bautizaj Juanchu carcelbi tiyasha Jesucristo imada rurashkada yachij chayushaga paibuj yachagujkunada Jesusta tapuchun kachuga ");
INSERT INTO qxl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kashna nisha: “¿Kanchu gangui <Shamungami> nishka Dios kachushka Cristo? Na gashaga ¿shujtachu shuyana ganchi?” ");
INSERT INTO qxl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Shina niki Jesusga niga, “Imada rikushkada shinaidi imada uyashkadash Juanchujmu risha parlanguichi. ");
INSERT INTO qxl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na rikujkunash rikun, suchugunash purin, lepra unguiyujkunadash alliyachishkamigun, na uyajkunash uyun, wañushkagunadash kausachishkamigun, shinaidi na charijkunamush Alli Shimida parlashkamigun. ");
INSERT INTO qxl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Maijin Ñukabi trankarinada na japisha crishkada na chingachijka kushiyachishkami gan.” ");
INSERT INTO qxl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanchu kachashkaguna riki Jesusga Juanchumunda gentegunamu parlungu kallarisha kashna nisha tapuga: “Shitashka pushtubiga ¿imadadi rikungu llujshiganguichi? ¿Shuj iru yurada waira chaspishkadachu? ");
INSERT INTO qxl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na gashaga ¿imadadi rikungu llujshiganguichi? ¿K'uidi churana churashka k'arida rikungu riganguichi? K'uidi churashkagunaga jatun mandujkunaj wasigunabimi tiyanguna. ");
INSERT INTO qxl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Shinakiga ¿imadadi rikungu llujshiganguichi? ¿Dios nishkada parlujtachu? Ari, Dios nishkada parlujtash ashtan yallidami rikuganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dios escribichishkabiga Juanchumunda parlasha kashna nin, ‘Riki. Kanda ñaubusha risha, Kishpichij purina ñanda parijachunmi ñukamunda parlujta kachani.’ ");
INSERT INTO qxl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Kabishkadadimi nini, tuki wacharishkagunamunda maijinsh na Bautizaj Juanchuda yallichu. Shina gakish Diosbuj mandanabi imash na gajka, Juanchuda yallimi. ");
INSERT INTO qxl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juanchu parlungu kallarishka p'unllamunda kunungama, Diosbuj mandanaga jursarishaidi shamugushkalla. T'angushtaj shina ima layash waigush nijkunami Diosbuj mandanamunga waigungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Shinushaga tuki Dios nishkada parlujkuna parlushkash Moisés mandushkash Diosbuj mandanallamundadimi Juanchu parlushkagama parlagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","‘Dios nishkada parluj Eliasmi shamunga,’ nishkaga Juanchumiga; shinushaga kai nishkada japisha nishaga japichilla. ");
INSERT INTO qxl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Maijinsh rinrinda uyungu charijka uyichi! ");
INSERT INTO qxl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kunun p'unllabi kausujkunadaga ¿imamu rijchujkunadikun nisha? Kangunaga lasabi tiyarij maraguna layami ganguichi. Kaparisha kashna ninguna: ");
INSERT INTO qxl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Lautabi tukukish na dansuganguichichu. Llakilladi cantogunada cantakish na wakuganguichichu.’ ");
INSERT INTO qxl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Shinalladi Juanchush shamushaga na mikukish na ubiakish, ‘Diablo katishkamigun,’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chi k'ipa Aichayuj tukushka Churi shamusha mikuki ubiakish, ‘¡Yallida mikuj! ¡Ubish purijlla! Impuestoda cobrujkunanbish, juchayujkunanbish apanukujllamigun,’ ninguichi. Ashtangarin Dios tukida yachaj gashkadaga Paida kazusha allida rurushkagunabimi rikuchishka gan.” ");
INSERT INTO qxl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chimundami pish na ruri pudishkagunada maibi yalli rurushka pueblogunada Jesús juchachisha rimungu kallariga. Chi pueblogunabi kausujkuna juchagunada na sakisha Diosmu na kuchuyashkamunda kashna nisha rimuga: ");
INSERT INTO qxl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Ai Corazín pueblobi kausajkunalla! ¡Ai Betsaida pueblobi kausajkunalla! ¿Ima tukunguichichari? Ñuka pi na ruri pudishkagunada kangunamu rurushka shina, Tiro, Sidón pueblogunabi rurushkakiga sarunmundadi paza churanagunada churusha, uchpabi tiyarisha juchagunada sakishkada rikuchisha Diosmu kuchuyangunamuga. ");
INSERT INTO qxl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ashtanbish kangunada ninimi, Dios juchachina p'unllabiga kangunaga Tiro Sidón pueblogunabi kausajkunadash yallimi llakichishka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaumbi kausujkunalla, kangunaga, <Jawa pachamu pushungami> yuyanguichichari. ¡Ashtangarin uku pachamundimi shitashka ganguichi! Pish na ruri pudishkagunada kangunamu rurushka shina, Sodoma pueblobi rurushkakiga chi puebloga kunun p'unllagama tiyanmumiga. ");
INSERT INTO qxl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ashtanbish kangunada ninimi, Dios juchachina p'unllabiga kangunaga Sodoma llaktabi kausajkunadash yallimi llakichishka ganguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chi p'unllagunami Jesús kashna niga: “Jawa pachada kai pachadash Mandaj Ñuka Taitalla, alli yuyida charijkunamu, yachajkunamush Kan pakushkagunada, ashtanbish ashalla yachajkunamu rikuchishkamundami Kandaga <Alli> nini. ");
INSERT INTO qxl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Shinushaga Taitalla, shina tukuchunga kan munashkami gashka. ");
INSERT INTO qxl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ñukaj Taitami tukida Ñukamu minguga. Maijinbish Churidaga na rijsinchu, Taitallami rijsin. Maijinbish Taitadaga na rijsinchu, ashtanbish Churillami rijsin. Shinaidi Ñukaj Taitadaga Ñuka rijsichisha nishkallagunamumi rijsichisha. ");
INSERT INTO qxl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Shinushaga tuki mashnalla trabajasha llashijkunada aparisha shaikushkaidi layaguna Ñukajmu shamichilla; Ñukami kangunadaga samachisha. ");
INSERT INTO qxl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ñuka na ratu p'iñarij alli shungumi gani. Shinushaga Ñukaj yugoda aparij laya Ñuka yachachishkada katichi. Shinada rurushaga samarinada japinguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ñuka kangunamu churashka yugo, shinaidi Ñuka kushka aparinaga p'angallami gan.” ");
INSERT INTO qxl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chi p'unllagunami Jesusga samana p'unllada tarbushkagunabi riguki Paibuj yachagujkuna yarijachishaga trigo k'atsugunada pilusha granuda mikungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chida fariseoguna rikushaga Jesusta nigaguna, “Riki, Kambuj yachagujkunaga samana p'unllagunabiga nash kabida rurungunandi.” ");
INSERT INTO qxl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Shina niki Jesusga niga, “Shuj ratu ñauba Rey David paigun igulda purijkunandij yarijachisha imada rurushkada ¿nachu liyushkanguichiri? ");
INSERT INTO qxl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Diosmu kusha ñaubuki churushka tandagunadaga Davidga Diosbuj wasimu waigushaga paibish paigun igulda purijkunash na mikuna gakish ashtangarin curagunalla mikuna tandagunadami paigunaga mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Shinaidi curagunaga samana p'unllabish na samashalla Diosbuj wasibi trabajashash na juchayuj tukunachu nisha Moisés mandushkabi ¿nachu liyuganguichi? ");
INSERT INTO qxl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ashtanbish Ñukaga ninimi, Diosbuj wasidash yalli valijka kaibimigun. ");
INSERT INTO qxl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kangunaga kai shimiguna ima nisha nishkadash na intindishkanguichindi: ‘Animalgunada wañuchisha shinaidi kumbidanagunadash kujkunalla gachunga na munanichu; ashtanbish shujkunamunda llakirijkuna gachunmi yalliga munani.’ Shina munashkada intindishkashaga imash na rurujkunada na juchachinguichimuchuga. ");
INSERT INTO qxl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ashtanbish Aichayuj tukushka Churiga samana p'unlladash Mandujmi gan.” ");
INSERT INTO qxl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chimunda Jesús rishami Diosmunda yachana wasimu waiguga. ");
INSERT INTO qxl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chibimi shuj maki chakirishka k'ari tiyaga. Fariseoguna imallamundash Jesusta juchachingu munashkamundaga tapugaguna: “¿Samana p'unllabish shuj ungushkada alliyachinallachari?” ");
INSERT INTO qxl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Shina tapuki Jesús niga, “¿Kangunamunda maijinsh shujlladi ovejada charisha, samana p'unllabi ut'kubi urmukiga nachu llujshichinguichimu? ");
INSERT INTO qxl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ashtanbish shuj gentegarin shuj ovejadash yallimi valin! Shinushaga allida ruranadaga samana p'unllabish rurana allimigun.” ");
INSERT INTO qxl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Shinushami chi k'aridaga, “Makida chutallada churi,” niga. Makida chutallada churunmi alliyasha chaishuj maki laya sanu sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Shina alliyachijta rikushami fariseoguna llujshish rishaga ima layash Jesusta wañuchingu nisha tandanukusha parlanukungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús chida yachushaga chi pushtumunda riga. Taugalladijkunash katisha riki tuki ungushkagunadash alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Shinaidi <Ñukamundaga pimush ama parlunguichichu> nisha mandaga. ");
INSERT INTO qxl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kaiga Dios nishkada parluj Isaiasmu kashna nisha parlachishka p'aktachunmi shina tukuga: ");
INSERT INTO qxl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kaibimi Ñukajta ruruj, maijinda Ñuka agllashka, Ñuka k'uyushka, maijinbi Ñuka manchanaidi kushiyani. Ñukaj Espirituda Paibimi churusha, shinalladi tuki llaktagunabi tiyujkunamu Paimi kabishkada ruranada parlunga. ");
INSERT INTO qxl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pigunbish na p'iñanukungachu, na kaparingachu; Pai parlarishkadash ñangunabish pish na uyungachu. ");
INSERT INTO qxl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","P'akiriguj sukus laya p'akirichunga shinaidi wañuj nina laya wañuchunga Pai kabishka rurushkash vincichichingama gentegunadaga na sakingachu. ");
INSERT INTO qxl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Shinushaga tuki llaktagunami <Paimi kishpichinga> nisha chapangaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chimundaga yana katishkamunda na rikuj upa k'arida Jesusbujmu pushamuga. Chibimi Jesusga paida alliyachiki rikuj parluj tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tukiguna mancharishkaidi tapunukugaguna, “¿Kaichu ganga shamuna gaj Rey Davidbuj Churi?” nisha. ");
INSERT INTO qxl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Shina nishkada fariseoguna uyushaga, “Yanagunada manduj Beelzebú poderda kai k'arimu kushkanmi yanagunada llujshichishtan,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Paiguna yuyagushkada Jesús yachusha kashna niga: “Maijin llakta kausujkunapuraidi p'iñanukusha partirinukukiga chi llakta chingaringami. Pueblobish wasibish tiyujkunapura p'iñanukusha partirisha tukuringagunami. ");
INSERT INTO qxl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Shinaidi Satanás Satanaslladadi llujshichishaga pailladimi partirigun. ¿Shinushaga ima layadi mandi pudinga? ");
INSERT INTO qxl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kanguna ninguichimi Ñukadaga, ‘Beelzebú poderda kushkanmi yanagunada llujshichishtan.’ Shina gakiga ¿pidi kangunada katijkunamunga yanagunada llujshichina poderda kun? Shinushaga paigunalladimi kanguna pandarishkadaga rikuchinguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Chimundami Ñukaga Diosbuj Espíritu poderda kushkan yanagunada llujshichisha Diosbuj mandana ña kangunamu chayushkada rikuchini. ");
INSERT INTO qxl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Maijinbish shuj jinchi k'ari ima charishkada shuwangu wasimu waigush nishaga tsagnidadimi chi k'aridaga tsagnanagun. Shina rurushallami shuwi pudinga. ");
INSERT INTO qxl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Maijinbish Ñukan na gajkunaga Ñukada p'iñujkunami. Shinaidi maijinbish na Ñukan igulda gentegunada tandachijka chingachishami kachun. ");
INSERT INTO qxl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Shinushami nini, tuki juchagunadash shinaidi Diosta imakish na valichisha rimashkagunadash Diosga perdonangami. Ashtangarin Diosbuj Espirituda imakish na valichisha rimushkadaga nalladi perdonangachu. ");
INSERT INTO qxl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Shinushaga Aichayuj tukushka Churida p'iñusha rimujtash Diosga perdonangami. Ashtangarin Diosbuj Espirituda p'iñusha rimujtaga kai kausibish k'ipa kausibish na perdonashkachunga.” ");
INSERT INTO qxl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesusga kashna niga: “Alli yuraga alli granudami aparin; na alli yuraga na alli granudami aparin. Shinushaga alli yura na alli yura gashkadaga granukimi rijsinagun. ");
INSERT INTO qxl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Culebra shina millida rurajkunaminguichi! Kanguna na alliguna gashkamunda ¿ima layadi alligunada ni pudinguichiri? Shungu ukubi imalla tiyashkadami shimimundaga parlun. ");
INSERT INTO qxl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Shinushaga alli gajka shungubi alli yuyiguna junda gashami alligunadaga nin. Na alli gajka shungubi na alli yuyiguna junda gashami na alligunadaga nin. ");
INSERT INTO qxl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ashtanbish Ñukaga kangunamu ninimi, Dios juchachina p'unllabiga tukigunami imakish na valij shimigunamundaga imamunda nishkadash parlana tukunguichi. ");
INSERT INTO qxl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Shinaki kambuj nishka shimigunamundami <Kauzayujmingui,> <Na kauzayujchungui,> nisha juchachishkash gangui.” ");
INSERT INTO qxl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chi k'ipaga fariseoguna shinaidi Moisés mandushkada yachachijkuna Jesusta, “Yachachij, pish na ruri pudishkada rurusha Dios kachushka gashkada rikuchichun ninchimi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Shina nikimi Jesusga niga, “Kunun p'unlla milli gentegunaga wainayaj laya, Diosta na kazujkunaga pish na ruri pudishkada rurusha rikuchichunmi mañunguna. Ashtangarin Dios nishkada parluj Jonás ima tukushka layallami rikuchishka ganga. ");
INSERT INTO qxl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ima layami Jonás kinsa p'unlla kinsa tutada jatundij chaulaj iksa ukubi tiyuga, Aichayuj tukushka Churish shinalladi kinsa p'unlla kinsa tutadami achpa ukubi ganga. ");
INSERT INTO qxl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dios juchachina p'unllaga ñaubadi kausuj Ninivemundagunami kunun p'unllabi kausujkunadaga juchachingu jatarisha shayaringaguna. Ninivebi kausajkuna Jonás parluki juchagunada sakisha Diosmu kuchuyagaguna. Jonastash yalliga kaibimi gan. ");
INSERT INTO qxl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Shinalladi Dios juchachina p'unllaga ura llakta jatun manduj warmishmi kunun p'unllabi kausujkunadaga juchachingu shayaringa. Pai Salomón alli yachushkada uyungu karulladi llaktamunda shamuga. Salomondash yalli valijka kaibi tiyan.” ");
INSERT INTO qxl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Milli espíritu shuj gentemunda llujshichiki llujshishaga chakishka pushtugunabimi samanada mashkusha purin. Na japishami, ");
INSERT INTO qxl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Ashtan ñukaj wasimunda llujshishkallamundi vueltusha,’ nisha yuyarin. Shina kutin chimu vueltushaga chushuj, p'ichushka, k'uilladi parijashka wasi layada chi genteda japishaga ");
INSERT INTO qxl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","paida yalli na alli kanchis espiritugunada tandachishaga pushusha chi tukigunanmi chibi kausungu waigunguna. Shinushami chi gentega ñauba kausidash ashtan yalli na alli tukun. Paiguna na alli gashkamundaga kunun kausajkunash shinaidimi tukungaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Chairijtij Jesús taugalladigunamu parlusha katijllabidi, Paibuj mamash waukigunash Paiyun parlaringu munushami washabi chapagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chibimi maijinchari Jesusmu parluga, “Kambuj mamash waukigunash Kangun parlarish nisha washabi shayangunandi.” ");
INSERT INTO qxl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ashtangarin shina parlujta Jesús kashna nisha yuyachiga: “¿Maijindi Ñukaj mama? ¿Shinaidi maijingunadi Ñukaj waukigunagun?” ");
INSERT INTO qxl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chimundami Paibuj yachagujkunamu makin rikuchisha, “Ñukaj mamash, Ñukaj waukigunash kaigunamigun,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Shinushaga maijinbish jawa pachabi tiyuj Ñukaj Taita munushkada rurujkunallami, Ñukaj mama, shinaidi Ñukaj wauki paniguna gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chi p'unllalladimi Jesús wasimunda llujshisha risha, yaku kucha manyabi tiyariga. ");
INSERT INTO qxl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Taugalladiguna tandanukushkamunda Jesús shuj barcabi sikusha tiyariga. Gentegunaga yaku manyabi shayariga. ");
INSERT INTO qxl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yuyachina parlugunan milgalladadi yachachishaga kashna niga: “¡Uyichi! Shuj tarbujmi tarbungu llujshiga. ");
INSERT INTO qxl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jichusha tarbukimi asha muyugunaga ñan manyabi urmuga. Chimundami pishkuguna shamusha mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Asha muyugunaga rumilla ashalla achpa pushtubimi urmuga. Shinushami chi muyuga p'itinlla achpa tiyashkamunda ratu iñuga. ");
INSERT INTO qxl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Indi llujshisha rupachiki anguda na charishkamunda chakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Asha muyuga kasha ukubimi urmuga. Chi kasha yuraguna iñushaga chi muyuguna iñajta jarkusha wañuchiga. ");
INSERT INTO qxl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ashtangarin alli achpabi urmushka muyugunaga pachundimi granuga. Shuj k'atsullamunda kinsa chunga (30), sujta chunga (60), patsujmadami (100) granuga. ");
INSERT INTO qxl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Maijinsh rinrinda uyungu charijka uyichi!” ");
INSERT INTO qxl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chimunda Jesusbujmu Paibuj yachagujkuna kuchuyasha tapuga kashna nisha: “¿Imamundadi gentegunamuga yuyachina parlugunan yachachingui?” ");
INSERT INTO qxl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Shina tapuki Jesús niga, “Diosmi Paibuj mandanamunda pakalla tiyashkagunada kangunamunga yachachun kushka. Ashtanbish paigunamunga na shina yachachun kushkachu. ");
INSERT INTO qxl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maijinsh charijmunga ashtanmi kushka ganga, shinusha yallidashmi charinga; ashtanbish na charijmundaga ashalla charishkaidash kichushkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Shinushami yuyachina parlugunan parlani. Paigunaga rikushash na rikuj layami; uyushash na uyuj layami; shinaidi na intindingunachu. ");
INSERT INTO qxl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Shinushami Dios nishkada parluj Isaías ima parlushka paigunabi p'aktun, ‘Uyagushash na intindinguichichu. Rikuriashash na rikuj shinami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kai gentegunaga muspa laya yuyi illujkunami; rinringunada tapachishka layagunami; ñawigunadash ichkushka layagunamigun. Ama uyangu, rikungu, intindingu, ama Ñukajmu shamungu shina rurunguna. Na shina rurushkakiga alliyachinimumiga.’ ");
INSERT INTO qxl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ashtangarin kushiyachishka ganguichi, kanguna ñawigunadash rikujta rinringunadash uyujta charishkamunda. ");
INSERT INTO qxl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kabishkadadimi nini, Dios nishkada tauga parlujkunash, Dios mandushkada rurujkunash kanguna rikushkada rikungu munashash na rikugagunachu. Kanguna uyushkada uyungu munushash na uyugagunachu.” ");
INSERT INTO qxl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Uyichi, tarbujmunda yuyachinaga ima nishadi nigun. ");
INSERT INTO qxl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ñan manyabi tarbushka muyu shinaga Diosbuj mandanamunda yachachishkada uyushash na intindikiga paigunamu alli parlashkada shungubi tarbushkada diablo shamushaga kichunllami. ");
INSERT INTO qxl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Rumi ukubi urmuj muyuga Diosbuj Shimida parlushkada uyusha chi ratulla kushilla japijkunadami rikuchin. ");
INSERT INTO qxl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Shina gashash Diosbuj Shimida crishkamunda ima llakiguna rikuriki, paida katik'ichukish pai crishkash chingarinllami. Ashalla anguda charij yura layashkamundami na jinchida shayarin. ");
INSERT INTO qxl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kasha ukubi tarbushka muyuga Diosbuj Shimi parlushkada uyushash ashtangarin kai pachabi ima ruranagunadash yallidij yuyusha imadash ashtan charina yuyin purisha pandarijkunadami rikuchin. Kai yuyigunami Diosbuj Shimida llapij shina ima granudash kuchun na sakin. ");
INSERT INTO qxl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ashtangarin alli achpabi tarbushka muyuga Diosbuj Shimida parlushkada uyusha intindisha shungubi wakichisha alli granuda kuj layadami rikuchin. Kaigunami shuj muyullamunda patsuj (100) granuma, sujta chungama (60) shinaidi kinsa chungamada (30) kujkuna laya gan.” ");
INSERT INTO qxl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Shinaidi kai yuyachinan kutin Jesús parlusha kashna niga: “Diosbuj mandanaga shuj k'ari alli muyuda paibuj achpabi tarbuj shinami gan. ");
INSERT INTO qxl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Shina gakish tukiguna puñugukimi paida p'iñusha na rikunachij chayushaga mapa k'iwa muyuda trigo ukubi jichusha riga. ");
INSERT INTO qxl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo yura iñusha granukimi mapa k'iwa yurash rikuriga. ");
INSERT INTO qxl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Shinushami trabajajkuna achpayujmu parlungu rigaguna kashna nisha: ‘Manduj, kambuj achpabi kan tarbushaga ¿nachu alli muyuda tarbugangui? Shinushaga ¿imamundadi mapa k'iwa yuraga iñushkanga?’ ");
INSERT INTO qxl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Shina niki achpayujka niga, ‘Maijin p'iñusha na rikunachijmi shinadaga rurushkanga.’ Shinusha trabajajkunaga, ‘¿Chi mapa k'iwada tirungu richun mununguichu?’ nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Achpayujka niga, ‘¡Na! Mapa k'iwada tirukiga trigogunash tiraringami. ");
INSERT INTO qxl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ashtangarin trigo granuda japina p'unllagama igulda iñachun sakichilla. Chibimi trigoda tandujkunada kachusha mapa k'iwadadi ch'ikunyachisha watigunada rurusha ninabi rupachishtachun, ashtanbish trigodaga ñukaj wakichinabi tandachichun nishami.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Shinaidi kai yuyachinan kutin Jesús parlusha kashna niga: “Diosbuj mandanaga shuj k'ari paibuj achpabi mostaza muyuda tarbushka shinamigun. ");
INSERT INTO qxl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tuki muyumunda uchilladi muyu gashash tarbushka yuragunamunda jatundimi iñun. Jatundi ramasapa yura gashkamundami pishkuguna ramagunabi tazunda rurusha kausungu ringuna.” ");
INSERT INTO qxl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Shinaidi kai yuyachinan kutin parlusha kashna niga: “Diosbuj mandanaga levadura shinami gan. Shuj warmi tandada rurungu kinsa batia vali kutabi ashalla levadurada churusha chapukish illijtami masushkada p'unguichin.” ");
INSERT INTO qxl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kai tukigunadami Jesusga taugalladigunamu kashna yuyachinagunanlla parlujkuga. ");
INSERT INTO qxl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dios nishkada parluj kashna nishka p'aktachunmi kaigunaga tukuga: “Yuyachinagunanmi parlusha. Kai pachada Dios rurushkamunda pachadi pakushka tiyashkagunadash yachi chayachishami.” ");
INSERT INTO qxl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chi k'ipaga tukigunada <Shuj ratugamachi> nisha Jesús wasimu waigukimi, Paibuj yachagujkuna kuchuyashaga, “Tarbushka pambabi mapa k'iwa iñushka yuyachinaga imada rikuchin parlabai,” nisha mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Shina mañaki Jesusga niga, “Alli muyuda tarbujka, Aichayuj tukushka Churimi gan. ");
INSERT INTO qxl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tarbushka pambaga kai pachamigun. Alli muyuga Diosbuj mandanabi gajkunadami rikuchin. Mapa k'iwaga diabloj gajkunadami rikuchin. ");
INSERT INTO qxl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Shinaidi mapa k'iwada jichujka diablodami rikuchin. Granoda tandanaga rikuchinmi kai pacha tukurina p'unllada. Chi p'ukushka granoda tandachijkunaga Diosbuj angelgunamigun. ");
INSERT INTO qxl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ima layami mapa k'iwada tandachisha rupachingu ninabi shitun, shinaidimi kai pacha tukurina p'unllash tukunga. ");
INSERT INTO qxl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Shinushaga Aichayuj tukushka Churimi Paibuj mandanamunda tuki juchabi urmachijkunada millida rurusha kausajkunadash tandachun Paibuj angelgunada kachunga. ");
INSERT INTO qxl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Shina rurushami nina katiriaj jurnubi shitunga. Chibimi kirugunash kanirisha karrusk'ichisha wakungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ashtangarin mashnalla kabishkada rurujkunaga paigunaj Taita Diosbuj mandanabi indi layami p'alaninga. ¡Maijinsh rinrinda uyungu charijka uyichi!” ");
INSERT INTO qxl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Diosbuj mandanaga manchanaidi valijta achpabi pakusha pambushka shinami gan. Chi manchanaidi valijta pambusha churushkada shuj k'ari japishaga chillabidi kutin pambush churun. Manchanaidi kushiyasha pai charishkagunada illijta k'atusha chi achpadami randiga. ");
INSERT INTO qxl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kutinga shuj k'atuj tukimunda yalli allidij perlagunada randingu mashkusha purij shinami Diosbuj mandanaga gan. ");
INSERT INTO qxl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Shuj perlada mejorlladi valijta japishaga pai ima charishkada illujta k'atusha chi perlada randiga.” ");
INSERT INTO qxl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Shinaidi Diosbuj mandanaga chaulada japinada yaku kuchabi shituki tuki laya chaulagunada japij shinami. ");
INSERT INTO qxl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ima ura chaulada japina jundukiga chaulada japijkunaga yaku manyamu llujshichin. Chibimi tiyarisha alli chaulagunada tandusha canastagunabi wakichin; shinaidi na alligunadaga shitun. ");
INSERT INTO qxl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Shina layaidimi kai pacha tukurina p'unllash tukunga. Kabishkada rurujkunapuramunda Diosta na kazujkunada angelgunami shamusha ch'ikunyachinga. ");
INSERT INTO qxl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Shina rurushami nina katiriaj jurnubi Diosta na kazujkunada shitunga. Chibimi kirugunash kanirisha karrusk'ichisha wakungaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesusga, “¿Kangunaga kai tuki parlushkagunada intindishkanguichichu?” nisha tapuki, “Ari,” nigagunami. ");
INSERT INTO qxl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chimundami Jesusga niga, “Moisés mandushkada maijin yachachijkish Diosbuj mandanamunda yachushaga shuj wasiyuj shinami. Alligunada wakichishkamunda mushujkunadash maugagunadash llujshichinllami.” ");
INSERT INTO qxl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús yuyachinagunan parlusha tukuchishka k'ipaga chimunda risha, ");
INSERT INTO qxl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pai kausushka achpallamundimi chayuga. Chibimi Diosmunda yachana wasibi yachachingu kallariga. Genteguna mancharishkaidi parlanukugaguna kashna nisha: “¿Maibidi kai tuki yachashkagunada yachugashi? ¿Ima layashi kai pish na ruri pudishkagunadaga rurun? ");
INSERT INTO qxl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Nachu kaikuga carpinteroj churi; paibuj mamunga Mariagun? ¿Nachu Jacoboj, Jozij, Simonbuj, Judasbukish waukigun? ");
INSERT INTO qxl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Shinaidi paibuj panigunash ¿nachu ñukuchipurallabidi kausagun? Shinushaga kaikuga ¿maimundadi kai tukidaga yachamugashi?” ");
INSERT INTO qxl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Shina Jesús parlashkada na japish nikiga Paiga niga, “Shuj ladugunabiga Dios nishkada parlujkunaga valichishkamigun. Ashtan kikinbuj kausushka achpabiga shinaidi kikinpurallabidikish na valichinchu.” ");
INSERT INTO qxl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chi genteguna Paida na crishkamundami, chi pueblobiga pish na ruri pudishkagunada ashallada ruruga. ");
INSERT INTO qxl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chi p'unllagunalladimi Galileada manduj Herodesga Jesusmunda ima nisha parlajta uyusha, ");
INSERT INTO qxl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","paibuj sirvijkunamu niga, “Paiga Bautizaj Juanchumi; wañushkamunda kausarishkanchin. Shinushami pish na ruri pudishkagunada ruragun.” ");
INSERT INTO qxl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Juanchu Herodesta, “Kambuj wauki Felipej warmi Herodiastaga kambuj warmida laya charinaga na kabichugun,” nishkamundami Herodesga Juanchuda japichiga. Chimundami watusha pushush risha carcelbi churugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chi llaktabi kausujkunaga, “Juanchuga Dios nishkada parlujmigun,” nisha crishkamunda Herodes paida wañuchingu munushash manchuga. ");
INSERT INTO qxl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodes watagunada p'aktachisha pishtada rurakimi tuki chi pishtabi tiyujkunaj ñaubuki Herodiasbuj ushi llujshisha dansakimi Herodes manchanaidi munushaga, ");
INSERT INTO qxl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Kan ima mañushkadash kushaidimi,” nisha juraga. ");
INSERT INTO qxl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Shinushami chi solterada mamun yachachiki, “Bautizaj Juanchuj umada shuj ichibi kui,” nisha Herodesta mañuga. ");
INSERT INTO qxl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Shina mañuki Manduj Herodesga llakiriga. Shina gashash tuki chi pishtabi gajkunaj ñaubuki <Chi soltera ima mañushkada kushaidimi> nisha jurashkamundaga kuchun mandusha, ");
INSERT INTO qxl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","paibuj soldadogunada Bautizaj Juanchuj kungada p'itingu richun carcelmu kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chi k'ipami Juanchuj umada shuj ichibi apamusha chi solteramu kuga. Solteraga paibuj mamunmu kuga. ");
INSERT INTO qxl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juanchubuj yachagujkuna chayushaga Juanchu wañushkada apush risha pambuga. Chi k'ipami Jesusmu parlungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Shina tukushkada yachusha Jesús barcabi sikusha shitushka pushtumu Pailla chibi gangu chimunda riga. Taugalladiguna shina rigushkada yachusha chi pueblogunamunda llujshishami chakinlla Jesusta katisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesusga barcomunda uriyasha taugalladigunada rikusha paigunamunda shungundijta llakirisha tuki ungushkagunadami alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ña tutayagukimi Paibuj yachagujkuna kuchuyashaga, “Ña tutayagunmi. Kai pushtuga shitushkaidimigun. Shinusha gentegunada kachabai, paiguna risha pueblogunabi mikunada randisha mikuchunguna,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Shina niki Jesusga, “Na ministingunachu ringujka; kangunaidi karichiri,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Paida katijkunaga, “Pichka tanda ishki chaulaidami charinchi; ashtanga illujminchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Shina niki Jesusga, “Apamichi kaimu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chimunda tukigunada kanis jawabi tiyarichun manduga. Chi k'ipa Jesusga pichka tandada ishki chaulada japisha jawa pachada rikusha Diosta <Diosolopai> nisha tandada chaubisha Paibuj yachagujkunamu kuki chi tukigunamu karuga. ");
INSERT INTO qxl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tukiguna sajsungamami mikugaguna. Shinash chi p'akishka tandaguna puchushkada tandachikiga chunga ishki canasta jundami gaga. ");
INSERT INTO qxl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chi mikujkunamunda k'arigunalla pichka warangagunamamishkanga (5.000), warmigunadash maragunadash na cuentujllabidi. ");
INSERT INTO qxl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chi ratuidimi Jesusga Paibuj yachagujkunada <Barcabi sikusha yaku kucha ch'imbamu Ñukada ñaubusha richi> nisha kachuga. <Ñukaga kaibi gentegunada <Shuj p'unllagamachi> ningumi sakirini.> ");
INSERT INTO qxl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Shina kachushka k'ipaga Jesusga Pailla Diosta mañungu shuj urkumu ichiyaga. Ña tutayaki Paillami chibi gaga. ");
INSERT INTO qxl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Achpamunda yakubi barca ña milgada karuyasha riguki, ñaubujmunda manchanai waira t'anguki yaku kaimu chaimu apik'ichuga. ");
INSERT INTO qxl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Narikish p'unllayajllabidimi Jesusga Paibuj yachagujkunaj kuchumu yaku jawada purisha riguga. ");
INSERT INTO qxl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Shina yaku jawada purijta rikusha Jesusbuj yachagujkunaga pachunlladi mancharisha, “¡Kukuminchin!” nisha mancharisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Shina kaparinmi Jesús parlarishaga, “¡Jinchi gaichiri! ¡Ñukaidimi gani; ama manchichichu!” niga. ");
INSERT INTO qxl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Shina nikimi Pedroga, “Manduj, Kandij gashaga yaku jawada Kambuj kuchumu ñukash ringu mandabai,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús, “Shamilla,” niki Pedroga barcamunda uriyasha yaku jawada purisha Jesusbujmu riguga. ");
INSERT INTO qxl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ashtanbish pachunlladi wairada rikusha manchuga. Yakubi millpuringu kallarishaga, “Manduj, kishpichibai,” nisha kapariga. ");
INSERT INTO qxl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Shina kaparinmi Jesusga Pedroda makimunda charirishaga, “Ashallada crij k'ari, ¿imashti na crigangui?” niga. ");
INSERT INTO qxl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Paiguna barcabi sikukiga wairash chi pushtubimi chulunlla sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chida rikusha mashnalla barcabi gajkuna Jesusbuj ñaubuki kungurisha, “Kanga Diosbuj Churidimishkangui,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yaku kuchada ch'imbushami Genesaret llaktamu chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chibi kausujkuna Jesusta rijsishaga tuki chi muyundij llaktabimi shimi shimi parlusha yachi chayachigaguna. Shinushami tuki ungushkagunada pushusha rishaga, ");
INSERT INTO qxl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“Kan churarishka churana manyawaidash tupachun sakibai,” nisha Jesusta mañagaguna. Mashnalla tupujkunaga tukigunami alliyachishkagunaga. ");
INSERT INTO qxl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chimundaga Jerusalén pueblomunda wakin fariseoguna shinaidi Moisés mandushkada yachachijkunash Jesusbuj kuchumu kuchuyasha tapugaguna: ");
INSERT INTO qxl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imashadi kambuj yachagujkunaga ñauba taitaguna yachachishkada p'akinguna? Narikish mikushaidi makida maillana nishkadaga na p'aktachingunandi.” ");
INSERT INTO qxl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Shina niki Jesús kashna niga, “¿Imashadi kangunash Dios mandushkagunada sakisha kangunaj ñauba genteguna yachachishkagunaida rurush katinguichi? ");
INSERT INTO qxl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Shinushami Dios mandushaga kashna niga, ‘Kambuj taitada mamadash allibi churungui,’ shinaidi, ‘Maijinbish paibuj taitada mamadash ima llakish tukuchun munujka wañuchun nishkami ganga.’ ");
INSERT INTO qxl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ashtanbish kangunaga kashna nisha nichunmi yachachinguichi: Maijinbish taitada mamada, ‘Ayudangu na pudinichu; tuki kangunamu imalla kunashkadaga Diosmumi kushkagun,’ nijka taitada mamada ayudangujka na ministinchu. Shinami kangunaga ñauba genteguna yachachishkagunada katish nisha Dios mandushkagunadaga chingachishkanguichi. ");
INSERT INTO qxl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ishki siki imadash nij tukushalla purijkuna! Dios nishkada parluj Isaiasga kangunamundaga allidami parlushka kashna nishaga: ");
INSERT INTO qxl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kai gentegunaga jawa shimillanmi <Allimi gangui> ninguna, ashtanbish paigunaj shungugunaga Ñukamundaga karubimigun. ");
INSERT INTO qxl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ñukamunga <Allimi gangui> nishkash imakish na valinchu. Paiguna yachachishkash genteguna mandashkallami gan.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chi k'ipa Jesús Paibuj kuchumu taugalladigunada kayushaga, “Uyichi shinaidi intindichi. ");
INSERT INTO qxl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shimimu waiguj mikunaga mapalladaga na rurunchu. Ashtanbish paibuj shimimunda llujshijmi mapalladaga rurun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chimunda Paibuj yachagujkuna kuchuyasha, “¿Fariseoguna Kan parlashka shimigunada uyusha litushka tukushkada yachuganguichu?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Shina tapuki Jesús niga, “Jawa pachamunda Ñuka Taita na tarbushka tuki yuragunadaga angundijtami tirushtashka ganga. ");
INSERT INTO qxl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paigunada sakichi. Na rikujkuna laya kaishuj na rikujta aisusha purij layagunamigun. Shinaidi shuj na rikujlladi chaishuj na rikujta aisusha purishagarin ishkindijlladimi shuj ut'kubi urmungaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chimunda Pedroga Jesusta, “Kai yuyachinan parlushkaga ¿imadadi nisha nin? Ñukuchimu yachachibai,” nisha mañuga. ");
INSERT INTO qxl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Shina niki Jesusga niga, “¿Ashtanbish kangunashchu chairijtij ima yuyish illuj ganguichi? ");
INSERT INTO qxl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tuki shimimu waiguj mikunaga iksamu risha chimunda llujshishkadaga ¿nachu yachunguichi? ");
INSERT INTO qxl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ashtanbish shimimunda llujshijka shungu ukumundami llujshin. Chimi gentedaga juchayujta rurun. ");
INSERT INTO qxl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ashtanbish shuj gentej shungumundaga llujshinmi millanai yuyiguna, wañuchina, wainayana, piyunbish siririna, shuwana, llagmusha maidash juchachina, pidash na alli shimigunan mirachisha parlanukuna. ");
INSERT INTO qxl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kaigunami gentegunada juchayujta rurun. Ashtanbish makida na maillushalla mikunaga juchayujtaga na rurunchu.” ");
INSERT INTO qxl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chi k'ipa Jesús chimunda llujshishaga Tirobuj shinaidi Sidonbuj kuchulla pueblogunamu riga. ");
INSERT INTO qxl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chi llaktabi tiyuj shuj Cananea warmi kaparishaga, “Manduj, Davidbuj Churi, ñukamunda llakiribai. Yana katishka ñukaj ushida manchanaidi llakichin,” nisha kuchuyaga. ");
INSERT INTO qxl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Shina mañakish Jesusga imash na nigachu. Chimunda Jesusbuj yachagujkuna Paibuj kuchumu risha, “Chi warmi kaparishaidi washada shamushkamunda richun nibai,” nisha mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chibi Jesusga, “Ñukaga chingushka oveja laya israelgunallamumi Dios kachushka gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pai warmiga kuchuyasha Jesusbuj ñaubuki kungurisha kumurisha, “Manduj Jesús, ayudabailladi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús, “Churiguna mikuna tandada kichusha achkugunamu shitanaga na allichugun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pai warmiga, “Shinamigun, Manduj Jesús. Ashtanbish achkuyujkuna mizamunda urmachishka p'iligunada achkugunash mikunllagunandi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chimunda Jesusga, “Warmi, kan Diosta crishkaga jatundimishka. Shinushaga kan munushka p'aktachun,” niga. Shina ninmi paibuj ushiga sanu tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chi pushtumunda Jesús llujshisha risha Galilea yaku kucha manyamu chayuga. Chibimi jawa urkumu ichiyasha tiyariga. ");
INSERT INTO qxl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Taugalladiguna Pai tiyashkamu kuchuyasha suchugunada, na rikujkunada, ishtu makigunada, upagunada shinaidi tuki laya unguida charijkunadash Jesusbuj kuchumu pushuki alliyachigallami. ");
INSERT INTO qxl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Shina upaguna parlaki ishtu makigunash alliyaki suchugunash puriki shinaidi na rikujkunash rikuki mancharishkaidi tukusha kushiyarisha Israelbuj Diosta <K'uillami gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús Paibuj yachagujkunada kayusha, “Kai genteguna kinsa p'unllada Ñukan igulda purisha ima mikunadash na charishkamunda Ñukaga shungundijtami llakirini. Shinusha yarijinga wasimu na kachush ninichu, ñanda rigusha ama ñawi ansayasha tigrachunguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chimunda Paibuj yachagujkunaga, “¿Kai shitushka pushtubidijka maimundadi milga tandadaga japishun kai tukigunamu sajsujta karungujka?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Shinusha Jesusga, “¿Kangunaga mashna tandada charinguichi?” nisha tapuki, paigunaga, “Kanchis tandada shinaidi ashalla chaulaidami charinchi,” nisha nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chimunda gentegunada pambabi tiyarichun mandushaga ");
INSERT INTO qxl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","kanchis tandada shinaidi chauladash japisha Diosta <Diosolopai> nisha chaubisha Paibuj yachagujkunamu kuki chi gentegunamu kuga. ");
INSERT INTO qxl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Shinami tukiguna sajsujta mikugaguna. Chimundash chi p'akishka tandaguna puchushkada tandachikiga kanchis canasta jundami gaga. ");
INSERT INTO qxl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mikujpuragunamunda k'arigunalla chusku warangagunamishka (4.000), warmigunadash maragunadash na cuentujllabi. ");
INSERT INTO qxl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chimunda Jesús gentegunada wasimu kachushka k'ipa barcabi sikusha Magdala llaktamu riga. ");
INSERT INTO qxl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseoguna shinaidi saduceoguna Jesusbuj kuchumu kuchuyasha imallabish pandariki rimungu jawa pachamunda pi na ruri pudishkada rurusha rikuchichun mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ashtanbish Jesusga niga, “Tutayamukiga jawa cielo pukalla gajta rikushaga kangunaga ‘K'uilla p'unllami ganga,’ nijkuna ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Shinaidi puzu puzu p'unllayaguki jawa cielo pukalla tukuki p'uyugunash junduki ‘Kununga tamialla wairalla gana p'unllaminga,’ ninguichi. Shinusha kanguna jawa cieloda rikusha ima laya p'unlla ganada parlungu yachajkunashdijka ¿imashti imada kunun p'unllaguna rikuchigushkada na alli yachi pudinguichi? ");
INSERT INTO qxl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kunun p'unlla wainayaj laya milli gentegunaga pish na ruri pudishkada rurusha rikuchichunmi mañunguna. Ashtangarin Dios nishkada parluj Jonás ima tukushka layallami rikuchishka ganga.” Shina nishaga sakish rigallami. ");
INSERT INTO qxl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesusbuj yachagujkuna Galilea yaku kuchada ch'imbusha tandada na apushalla kungarisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús niga, “Uyichi. Fariseogunaj saduceogunaj levaduramunda yuyin puringuichi.” ");
INSERT INTO qxl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Shina niki Paibuj yachagujkunaga, “Tandada na apamushkamundami chida nin,” nisha kaishuj chaishuj ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Shina yuyagushkada yachusha Jesús niga, “¿Imashti tandadaga na charinchijka ninukunguichi? ¡Ashaida crijkuna! ");
INSERT INTO qxl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Narijchu chairijtij alli yachunguichi? Pichka tandallan pichka warangagunamu (5.000) karushkada shinaidi mashna canasta tandada kanguna tandachishkadash ¿nachu yuyaringuichiri? ");
INSERT INTO qxl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Shinaidi kanchis tandallan chusku waranga (4.000) gentegunamu karushkada shinaidi mashna canasta tandada kanguna tandachishkadash ¿nachu yuyaringuichi? ");
INSERT INTO qxl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‘Yuyin puringuichi fariseogunaj saduceogunaj levaduramunda,’ nishaga tandada kungamushkamundaga na parlaganichu. ¿Imashti kangunaga chidaga na intindinguichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jesús shina nikimi na tandabi churana levaduramunda yuyin purichun nishkadaga, ashtanbish <fariseoguna saduceogunash yachachishkamunda yuyin puringuichi> nishkada chibimi alli yachugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea Filipo pueblo kuchullamu chayushaga Jesús Paibuj yachagujkunada, “Aichayuj tukushka Churiga ¿pi gashkada gentegunaga nigunguna?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Shina tapuki, “Shujkunaga <Bautizaj Juanchumi>; chaishujkunaga <Eliasmi>; maijingunaga <Jeremiasmi> na gashaga <Dios nishkada parlujkunamundaminga> ningunami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Kangunaga ¿Pi gashkadadi Ñukadaga yuyinguichi?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedroga, “Kanmi Cristo, kausujti Diosbuj Churi gangui,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chimunda Jesusga, “Kan Jonasbuj churi Simón, kushilla gangui. Pi gentesh kanmunga kaidaga na rikuchishkachu; ashtanbish jawa pachabi tiyuj Ñuka Taitallami kaidaga rikuchishka,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Shinaidi Ñuka kandaga Pedromi gangui, nini. Shinushaga kai rumi jawabi wasichij shinami Ñukada crijkunadaga mirachisha. Wañuna chayamushash paigunada na vinci pudingachu. ");
INSERT INTO qxl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Shinushaga Diosbuj mandana llavedash kanmumi kusha. Kan kai pachabi ima watushkaga jawa pachabish watushkami ganga. Shinaidi kan kai pachabi ima kacharishkaga jawa pachabish kacharishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chi k'ipa Jesús Paibuj yachagujkunada Pai Cristo gashkadaga pimush ama parlachunmi manduga. ");
INSERT INTO qxl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chimunda pacha Jesús Paibuj yachagujkunamu yachi chayachingu kallarishaga, “Ñukaga Jerusalén pueblomu rinami gani. Chibimi pushaj yuyijkunamunda, manduj curagunamundash, Moisés mandashkada yachachijkunaj makimundash manchanaidi llakida japisha. Shinaidi wañuchichunbish kachushkami gasha. Shinash kinsa p'unllabiga kausarishami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chimunda Pedroga Jesusta ch'ikunyachisha pushush risha, “Manduj, kan shina tukuchunga Dios amalladi sakichun,” nisha jarkusha rimungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ashtanbish Jesús vueltarisha rikusha Pedrodaga, “Ñukaj ñaubujmunda anchi, Satanás. Kanga trankarij laya urmachunmi shina ningui. Imadash Dios rikushka layada na rikunguichu. Ashtangarin genteguna rikushka layallami rikungui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chi k'ipa Jesusga Paibuj yachagujkunada kashna niga: “Maijin Ñukada katingu munujka kikinbuj munida sakisha, cruzta japisha katimilla. ");
INSERT INTO qxl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Shinushaga maijinsh kikinbuj kausida yalli llakirijka, na tukurij kausidaga mana japingachu. Ashtanbish maijin Ñukada katishkamunda kikinbuj kausida na llakirijka, na tukurij kausida japingami. ");
INSERT INTO qxl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Shuj gentemu kai pachabi tuki ima tiyujta charij tukushash ¿imaj alli gangari wañusha kikinbuj almada chingachishaga? Kikinbuj kausi kishpirichunga ¿imada kui pudingari? ");
INSERT INTO qxl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Shinusha Aichayuj tukushka Churiga Paibuj Taitaj k'uilla gashkan angelgunandij shamunga. Chibimi tukigunamu ima imada rurashkamunda kunashkada kunga. ");
INSERT INTO qxl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kabishkadadimi nini: kaibi tiyajkunamunda wakingunaga Aichayuj tukushka Churi mandungu shamujta narikish rikushaidijka na wañungachu.” ");
INSERT INTO qxl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sujta p'unlla k'ipa Jesús Pedroda Jacoboda paibuj wauki Juanchudash agllusha paigunallada shuj jatun urkumu pushush riga. ");
INSERT INTO qxl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chibi paigunaj ñaubuki Jesús shuj laya tukuga. Paibuj ñawi indi laya p'alaniga; shinaidi churanash yurujlladi luz shinami tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ñash Dios nishkada parluj Moisesta Eliasta Jesuskun parlanukujta rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chimunda Pedroga Jesusta niga, “Manduj Jesús, allimi gashka kaibi ganaga. Kan munukiga kinsa carpada rurushallami, shujtaga kanmu, chaishujtaga Moisesmu, kaishujtaga Eliasmu.” ");
INSERT INTO qxl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro shina nigujllabidi paigunaj muyundiki p'alaniguj p'uyu tiyariki ñash p'uyumunda, “Kaimigun Ñuka k'uyashka Churi. Paibimi manchanaidi kushiyani. Paida uyunguichi,” nisha shuj parlarishka uyariga. ");
INSERT INTO qxl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kaida uyashaga Jesusbuj yachagujkuna mancharishkaidiguna kungurisha kumuriki, ");
INSERT INTO qxl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús paigunajmu kuchuyasha tupushaga, “Jatarichi. Ama mancharichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Chimunda umada alsusha rikushaga pidash ña na rikusha Jesuslladami rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ña jawa urkumunda uriyagushaga, “Kai rikushkadaga Aichayuj tukushka Churi wañushkagunapuramunda kausaringagama ama pimush parlunguichichu,” nisha Jesús manduga. ");
INSERT INTO qxl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chimunda yachagujkuna Jesusta tapugaguna, “¿Imasha Moisés mandushkada yachachijkunaga, ‘Eliasmi ñaubusha shamunagun,’ ninguna?” ");
INSERT INTO qxl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Shina niki Jesusga niga, “Kabishkadimigun; Eliasmi ñaubusha shamunaga, tukida k'uillada parijangaj. ");
INSERT INTO qxl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ashtanbish Ñukaga ninimi, Eliasga ña shamugami. Paida na rijsisha paiguna ima munushkadash rurugaguna. Shinaidimi Aichayuj tukushka Churish paigunaj makibi llakichishka ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chibimi Paibuj yachagujkunaga Bautizaj Juanchumunda Jesús parlashkada yachi tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Paiguna taugaguna purishka pushtumu chayuki, shuj k'ariga Jesusbujmu kuchuyasha Paibuj ñaubuki kungurishaga, ");
INSERT INTO qxl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Manduj Jesús, ñukaj churimunda llakiribai. Urmuj unguida charisha mejorlladimi llakirin. Tauga kutinmi ninabish shinaidi yakubish urmun. ");
INSERT INTO qxl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kambuj yachagujkunamu pushamukish na alliyachi pudishkagunachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Shina niki Jesusga, “¡Ashallada crijkuna; na alli genteguna! ¿Ima uragamashi kangunan purisha? ¿Maigamachari shinagunada rikusha kausagushalla? Marada kaimu pushamichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chimunda Jesús chi yanada p'iña rimuki maramunda llujshiga. Chimunda pacha maraga alliyagallami. ");
INSERT INTO qxl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jesusbuj yachagujkuna Paillada ch'ikunyachisha shamusha tapugaguna, “Ñukuchiga ¿imasha na yanadaga llujshichi pudiganchi?” nisha. ");
INSERT INTO qxl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Shina niki Jesús niga, “Kangunaga ashallada crishkamunda. Kabishkadadimi nini: Kanguna shuj mostaza muyu shinawaidash crishaga chi urkuda, ‘Kaimunda anchi; shuj pushtumu ri,’ nin, anchunmunllami. Kangunamunga imash na pudibujka na ganmunchu.” ");
INSERT INTO qxl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesusbuj yachagujkuna Galilea llaktabi tandanukuki Jesús niga, “Aichayuj tukushka Churiga gentegunaj makibimi kushka ganga. ");
INSERT INTO qxl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Shinaidi wañuchingagunami. Ashtanbish kinsa p'unllabiga kausaringami.” Shina nijta uyusha mejorlladi llakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús Paibuj yachagujkunan Capernaum-mu chayuki Diosbuj wasimu impuestoda cobrujkuna Pedroj kuchumu kuchuyasha tapugaguna, “Kangunada yachachijka ¿nachu Diosbuj wasimu impuestoda kujkun?” ");
INSERT INTO qxl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Shina tapuki, “Ari, kujmigun,” niga. Chi k'ipa Pedro wasimu waiguki Jesús ñaubushadi parlarisha kashna niga: “Simón, ¿kanga imada yuyangui? Kai pachabi jatun mandujkunaga ¿pigunada impuestoda cobrunguna? ¿Kikinbuj llaktamundagunada? ¿Na gashaga shuj llaktamundagunada?” ");
INSERT INTO qxl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Shina niki Pedroga, “Shuj llaktamundagunada,” niga. Chimunda Jesús niga, “Shinushaga chi llaktallamundadi gajkunaga pagungujka na kabinchu. ");
INSERT INTO qxl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Shina gakish pidash ama p'iñachingu jatun yaku kuchamu risha anzueloda shiti. Ñaubusha japi tukuj chaulada llujshichisha shimida paskusha shuj kuchkidami japingui. Chi kuchkillandi Ñukaj impuestodash kambujtash paigunamu pagungu ringui.” ");
INSERT INTO qxl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chi ratugunaidimi Jesusbuj yachagujkuna Paibujmu kuchuyasha tapugaguna, “Diosbuj mandanabiga ¿maijindi yalli valij gan?” ");
INSERT INTO qxl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Shina niki Jesús shuj marada kayusha paigunaj chaubibi shayachishaga ");
INSERT INTO qxl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kashna niga: “Kabishkadadimi nini, kanguna shina gashkada na sakisha na kutin mara laya tukushaga Diosbuj mandanamunga na waigunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Shinushaga maijin <Imash na ganichu> nisha kai mara laya gajka, Diosbuj mandanabiga yalli valijmi ganga. ");
INSERT INTO qxl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Shinaidi maijin Ñukaj shutibi kai marada laya shuj marada japijka Ñukadami japin.” ");
INSERT INTO qxl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Shuj uchilla mara laya Ñukada crijta juchabi maijinbish urmachijka, jatun kutana rumida kungabi watushka jatun yaku kucha jundu pushtubi millpuchishka ganami ashtan allimunga. ");
INSERT INTO qxl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tauga juchagunabi urmanaguna tiyashkamundaga kai pachabi tiyujkunaga ¿imachari tukunga? Shinash chigunaga tiyanalladijmi gan. Ashtanbish maijinsh shujkunada juchabi urmachijka ¿imachari tukunga? ");
INSERT INTO qxl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Shinushaga kambuj makima chakima juchabi urmachikiga p'itishtasha kanmunda shiti. Ishki maki ishki chaki na tukurij nina rupajmu shitushka gana randiga ashtanbish maki illuj chaki illuj kan na tukurij kausimu waigunami alli ganmu. ");
INSERT INTO qxl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Shinaidi kambuj ñawi juchabi urmachikiga llujshichisha shiti. Uku pacha ninamu ishki ñawin shitashka gana randiga ashtan shuj ñawillan na tukurij kausanamu rinami alli ganmu.” ");
INSERT INTO qxl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kai uchillagunamunda maijindash na valichisha ama ch'ikunyachinguichichu. Ashtanbish ninimi, jawa pachabi paigunaj angelgunaga jawa pachabi tiyuj Ñukaj Taitaj ñawida rikurianllagunami. ");
INSERT INTO qxl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Ima laya rikurin? Maijinsh patsuj (100) ovejada charisha paigunapuramunda shuj chingarikiga ¿nachu iskun chunga iskun (99) ovejada urkubi sakisha chingushka ovejada mashkungu rinmu? ");
INSERT INTO qxl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chingarishka ovejada japishaidijka chi iskun chunga iskun maimush na risha na chinguj ovejagunadash yallimi kushiyaringa ninimi. ");
INSERT INTO qxl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Shinaidimi kangunaj jawa pachabi tiyuj Taita Diosbish kai uchillagunamunda shujllash chingarichunga na munanchu.” ");
INSERT INTO qxl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Crijkunamunda shuj wauki juchada rurukiga paigunlla parlarisha pai na allida rurushkada rikuchingui. Kan nishkada uyakiga kutin kambuj waukidi gachun japinguimumi. ");
INSERT INTO qxl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ashtanbish na uyash nikiga shujma ishkimadash kangun richun kayungui. ‘Ima tukushkaga ishki na gashaga kinsa rikujkuna kabishkada parlashkan tuki allichishka gachun shina ruranami.’ ");
INSERT INTO qxl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Shinaidi paigunadash na uyush nikiga tuki tandanukushka crijkunamu parlungui. Chi tukigunadash na uyush nikiga paidaga Diosta na rijsij na alligunaida rurungu munuj gashkabi sakingui. ");
INSERT INTO qxl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Kabishkadadimi nini, kanguna kai pachabi ima watushkaga jawa pachabish watushkami ganga. Shinaidi kanguna kai pachabi ima kacharishkaga jawa pachabish kacharishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kaidash ninimi, kai pachabi kangunamunda ishkindijlladi <Allimigun> ninukusha imadash Diosta mañukiga jawa pachabi tiyuj Ñukaj Taitaga kungallami. ");
INSERT INTO qxl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maibi ishkima kinsama Ñukaj shutibi tandanukukish Ñukaga paigunaj chaubibimi gani.” ");
INSERT INTO qxl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chimunda Pedro Jesusbujmu kuchuyasha tapuga, “Manduj Jesús, ¿mashna kutinda ñuka wauki ñukada na allida rurukiga perdonana gani? ¿Kanchis kutingamachu perdonasha?” ");
INSERT INTO qxl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Shina tapuki Jesús niga, “Na ninichu kanchis kutida, ashtanbish kanchis chunga (70) kutin kanchisgama perdonangui ninimi. ");
INSERT INTO qxl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Shinushaga ima layami shuj llaktada mandujka pai nishkada rurujkunamunda mashna kuchki fiachishkada japish nin Diosbuj mandanash shinalladimi gan. ");
INSERT INTO qxl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ña shina rurusha kallariguki sujta chunga waranga waranga denarioda fiujtaga llaktada mandujbuj ñaubujmu pushagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chi fiujka iman na pagui pudishkamundaga llaktada mandujka pai fiachishkada pagushka gachun nishami, ‘Fiujta warmindij maragunandij tuki paiguna ima charishkadash k'atunguichi,’ nisha manduga. ");
INSERT INTO qxl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Shinushami chi sirvijka llaktada mandujbuj ñaubuki pambamu kumurisha kungurishaga, ‘Ashawan ñukada shuyabairi. Tukida illujta kushallami,’ nisha mañaga. ");
INSERT INTO qxl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Shina mañaki llaktada mandujka paimunda llakirisha chi fiachishkadaga illujta kungarisha sirvijta kacharisha sakiga. ");
INSERT INTO qxl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ashtangarin chimunda llujshishaga chi sirvijka paigun igulda purij paida patsuj denarioda fiujkun tupanukushaga, ‘Ñuka fiachishkada kui,’ nisha kungabi charirisha makin sipingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Shina rurukimi paigun igulda purijka pambamu kumurisha kungurishaga, ‘Ashawan shuyabairi. Tuki ñuka fiushkada kushallami,’ nisha mañaga. ");
INSERT INTO qxl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Chi fiachijka na uyush nisha ashtanbish pushush risha carcelbimi churachiga ima fiushkada vueltachingagama. ");
INSERT INTO qxl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chida rikusha chaishuj sirvijkunaga mejorlladi llakirisha llaktada mandujmu tuki ima tukushkada parlungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Chimundami mandujka kayachun kachuga. Ña pushamukiga, ‘¡Milli sirvij! Ñukaga kan <Shuyabairi> nikiga kan fiushkada illujta kungarisha sakiganindi. ");
INSERT INTO qxl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ñuka ima layami kanmunda llakirigani, shinaidi ¿nachu kambish kangun igulda purijmunda llakirisha kungarina gagangui?’ ");
INSERT INTO qxl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","nisha paida mandujka manchanaidi p'iñarishaga carcelbi llakichichun kuga tuki fiushkada vueltachingagama.” ");
INSERT INTO qxl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesusga, “Kangunapura maijin p'iñachij waukida tukiguna na tuki shungun perdonakiga jawa pacha Ñuka Taitash shinaidimi kangunadash rurunga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Shina Jesús parlush tukuchishka k'ipaga Galileamunda llujshisha Jordán yaku ch'imbapurabi tiyuj Judea llaktagunamu chayuki, ");
INSERT INTO qxl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","taugalladiguna katigaguna. Chibimi ungushkagunada alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Shuj fariseoguna Jesusmu kuchuyasha imallabi pandarikish juchachingaj, “¿Imallamundash kusaga warmimunda ch'ikunyanallachu gan?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús parlarishaga, “¿Nachu Diosbuj Shimibi kaida liyushkanguichi? Kallarimunda tukigunada ruruj Diosga, ‘K'aridash warmidashmi ruruga.’ ");
INSERT INTO qxl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Shinaidi kaidash niga, ‘Chimundami k'ariga taitada mamada sakinga paibuj warmin kazarasha tandanukungaj. Shinami ishkindijmunda shuj shinalla tukunga.’ ");
INSERT INTO qxl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Shinushaga ña mana ishkindijchu gan. Ashtangarin shuj aichallami gan. Shinashkamundaga Dios tandachishkadaga pish ama ch'ikunyachichun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Shina niki fariseoguna tapugaguna, “¿Imasha shinadijka maijin kusa warmida kachangajka partirishkada rikuchingaj firmashka p'angada paimu kuchun Moisesga manduga?” ");
INSERT INTO qxl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Shina niki Jesús niga, “Kanguna uyiti na uyujkunashkallamundadimi Moisesga warmimunda ch'ikunyachun sakiga. Ashtanbish kallarimunga Diosga na shinada munugachu. ");
INSERT INTO qxl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Shinushami Ñukaga nini, maijin kusaga warmi nash wainayaki partirisha, shuj warmin kazarajka wainayanmi.” ");
INSERT INTO qxl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chimunda Jesusbuj yachagujkunaga, “Kusan warmin shina kausanakiga na kazarashkami alli ganmu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús niga, “Na tukiguna kai parlushkadaga <Allimigun> ni pudingunachu. Ashtanbish maijingunamu Dios chi yuyida kushkagunallami pudinguna. ");
INSERT INTO qxl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Shujkunaga lulun illuj wacharishkamundami na kazaran, kaishujkunadaga genteguna kapashkamunda. Maijingunaga Diosbujllada rurush nisha paigunaidimi <Na kazarasha> ninguna. Maijin kaida <Allimigun> nisha japi pudijka japichunlla.” ");
INSERT INTO qxl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Maragunaj jawabi makida churusha Diosta mañachun Jesusbujmu pushamuki, Paibuj yachagujkunaga pushush rijkunada takush nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chimunda Jesusga niga, “Maraguna Ñukajmu shamuchun sakichi, ama jarkichichu. Ashtanbish Diosbuj mandanaga kai maraguna laya gajkunajmigun.” ");
INSERT INTO qxl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Maragunaj jawabi makida churusha mañushaga chi pushtumunda rigallami. ");
INSERT INTO qxl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chi k'ipa Jesusbujmu shuj musu kuchuyashaga, “Yachachij, na tukurij kausida japingajka ¿ima allidadi rurana gani?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesusga, “¿Imashadi alli ruranagunamunda Ñukada tapungui? Alliga Diosllami tiyun. Ashtanbish kan na tukurij kausida japish nishaga Diosbuj mandushkagunada kazi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chi musuga, “¿Maijingunada?” niki, Jesús niga, “Ama wañuchingui. Ama wainayangui. Ama shuwangui. Shujta na allida rurungajka ama juchachisha llagmunguichu. ");
INSERT INTO qxl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kambuj taita mamadash k'uyusha allida rurungui; shinaidi shujkunadash kikinda layaidi k'uyungui.” ");
INSERT INTO qxl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chi musu niga, “Tuki chi nishkadaga p'aktachishkanimi. ¿Imadadi ashtan p'aktachina gani?” ");
INSERT INTO qxl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Shina niki Jesús niga, “Kan allidadi ruruj gangu munushaga ri, kan charishkada k'atusha imash na charijkunamu kungui. Shinami jawa pachabi tukimunda yalli alli charinagunada charingui. Chida ruramushaga Ñukada katimi.” ");
INSERT INTO qxl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chi musuga Jesús shina nijta uyushaga milgalladi charij gashkamundaga llakirisha rigallami. ");
INSERT INTO qxl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chimunda Jesús Paibuj yachagujkunamu niga, “Kabishkadadimi nini: shuj charij Diosbuj mandanamu waigunaga jinchimi gan. ");
INSERT INTO qxl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kutinbish ninimi, jatun camello akuja ut'kuda waigunash, charijkuna Diosbuj mandanamu waigunadash yalli jawallami gan.” ");
INSERT INTO qxl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yachagujkuna kaida uyushagarin ashtanlladi mancharisha, “Shina gakiga ¿pishi kishpiri pudinga?” niguki, ");
INSERT INTO qxl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús paigunada rikuriasha, “Kaiga gentegunamunga na ruri pudibujmi, ashtanbish Taita Diosmunga ima na ruri pudinaga illunmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Shina niki Pedroga, “¡Riki, ñukuchiga tuki ima charishkagunada sakishkanchindi Kanda katingaj! ¿Shinushaga imadadi japishun?” niga. ");
INSERT INTO qxl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Shina niki Jesusga, “Kabishkadadimi nini, ima ura tukida mushujyachina p'unlla chayukimi, Aichayuj tukushka Churi k'uilladi p'alanigujti mandanabi tiyariki kangunashmi Ñukada katishkamundaga chunga ishki mandana tiyarinagunabi Israelbuj chunga ishki tribugunada mandungu tiyaringuichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Shinushaga mashnalla Ñukamunda wasida, wauki panigunada, turi ñañagunada, taitada, mamada, maragunada, achpagunamada sakijkunaga patsuj (100) kutin ashtan yallidami japingaguna. Shinaidi na tukurij kausidash japingagunami. ");
INSERT INTO qxl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ashtanbish taugaguna kunun ñaubusha gajkunaga k'ipabimi ganga. Shinaidi taugaguna k'ipa gajkunaga ñaubungagunami.” ");
INSERT INTO qxl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Shinushaga jawa pacha Diosbuj mandanaga milga achpada charij k'ari shinamigun. Puzu puzudi paibuj uva tarbushkabi trabajachun trabajajkunada mashkungu riga. ");
INSERT INTO qxl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ña trabajajkunan parlanukusha shuj p'unllamunda denario kuchkida kungu ari ninukusha uva tarbushkabi trabajachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kutin asha p'unllallabi risha shujkunash imadash na rurasha lasabi gajkunada rikusha, ");
INSERT INTO qxl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","niga, ‘Kangunash ñukaj uva tarbushkabi trabajangu richi. Mashna kuchkida kunashkadaga kushallami.’ Shina niki paigunash riga. ");
INSERT INTO qxl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Chi achpayuj kutin chaubi p'unlla shinabi, shinaidi duzi k'ipa llujshisha rishash trabajajkunada japishaga shinaidimi ruruga. ");
INSERT INTO qxl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ña indi waigusha niguki kutinlladi llujshish risha shujkunadash imadash na rurujkunada japisha, ‘¿Imashadi kangunaga na trabajashalla tuki p'unlla kaibi kainanguichi?’ nisha rimaga. ");
INSERT INTO qxl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Shina niki, ‘Pish na trabajachun japishkamunda,’ nigaguna. “ ‘Shinadijka kangunash ñukaj uva tarbushkabi trabajangu richi,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ña tutayaki uva tarbushka achpayujka trabajajkunada mandujtaga, ‘Trabajajkunada kayushaga k'ipa trabajangu waigujkunamunda pagungu kallarishaga ñaubushadi shamujkunamu pagusha tukuchingui,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Indi waigush niguki trabajangu waigujkuna kuchuyashaga tukigunami denario kuchkida japigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ñaubusha trabajangu waigujkuna kuchuyana tukukiga <Paigunada yallimi japishun> nisha yuyagaguna. Shina gakish paigunash shuj denariolladadimi japigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ña japishaga achpayujmunda rimungu kallarigaguna, ");
INSERT INTO qxl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kashna nisha: ‘Kaigunamuga k'ipa chayamusha shuj urawaida trabajakish ashtanbish ñukuchiga rupibi tuki p'unlla trabajasha kainukish paigunamu kushkaidadi ñukuchimu kushkanguindi.’ ");
INSERT INTO qxl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Shina nikish achpayujka paigunamunda shujtaga, ‘Hijo taita, kandaga ima na allidaga mana ruragushkanichu. ¿Parlanukushaga nachu shuj denarioda japingu <Ari> nigangui? ");
INSERT INTO qxl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Shinakiga kanmu kushkada japisha ri. K'ipadi trabajangu waigujmush kanmu kushka layaidimi kush nini. ");
INSERT INTO qxl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Shinaga nachari ñuka kuchkinga ñuka munushkada ruri pudini? Na gashaga ¿ñuka kujlla gashkamunda wañurigungui?’ ");
INSERT INTO qxl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Shina layaidi k'ipa gajkunaga ñaubungagunami. Shinaidi ñaubusha gajkunaga k'ipabimi ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús ña Jerusalén pueblomu ñanda ichimu rigushaga Paibuj chunga ishki yachagujkunada ch'ikunyachisha kayushaga kashna niga: ");
INSERT INTO qxl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kununga Jerusalenmu rigunchi maibimi Aichayuj tukushka Churiga manduj curagunamu shinaidi Moisés mandushkada yachachijkunamu japichishka ganga. Paigunami wañuchichun nisha juchachinga. ");
INSERT INTO qxl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Shinaidimi na israelgunamuga maidadikish nisha asisha, azilgun dalisha shinaidi cruzbi chakatasha wañuchichun kungaguna. Ashtangarin kinsa p'unllabiga kausaringallami.” ");
INSERT INTO qxl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeoj churigunaj mamun paibuj churigunandij Jesusbujmu kuchuyashaga Paibuj ñaubuki kungurisha <Shuj ruranada rurabai> nisha mañuga. ");
INSERT INTO qxl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chimunda Jesusga, “¿Imadadi ningui?” nisha tapuki chi warmiga, “Kai ishki ñukaj churiguna Kambuj mandanabi paigunash mandachun shujka alli ladumu kaishujka lluki ladumu tiyarichun nibai,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Shina niki Jesús niga, “Kanguna imada mañashkadash na yachunguichichu. Ashtangarin ¿jatun llakida shina, Ñuka jayuj ubianada ubyi pudinguichichu?” Shina niki paigunaga, “Pudinchimi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chimunda Jesús niga, “Kangunaga kai jayuj yakuda ubianguichillami, ashtanbish Ñukaj alli ladumu lluki ladumu tiyarichun kunaga na Ñukajka kabinchu. Ashtanbish maijin Ñukaj Taita chibi tiyarichun nishkallagunamumi kushka ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Shina nishkamunda chaishuj chunga yachagujkuna chi ishki waukindijkunanga p'iñarigallagunami. ");
INSERT INTO qxl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ashtan Jesús tukigunada kayusha niga, “Ima layami kanguna yachunguichi, llaktagunada mandujkunaga pueblobi kausujkunadaga paiguna munushkaida rurusha mandun, shinaidi jatun tukushkagunash shujkunadash llakichisha kazuchinguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kangunapurabiga na shinaga ganachugun. Ashtangarin maijin kangunamunda jatun tukush nijka chaishujkunada sirvichun. ");
INSERT INTO qxl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Shinaidi kangunapuramunda maijin ñaubusha gash nijka kangunamu watushka shina ruruj gachun. ");
INSERT INTO qxl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Shina layaidi Aichayuj tukushka Churiga na Pai nishkada rurachingujka shamugachu, ashtan shujkunaj ruranada rurungumi, shinaidi kausida kusha taugagunada kacharisha kishpichingujmi shamuga.” ");
INSERT INTO qxl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Paiguna Jericó puebloda pasusha llujshisha riguki taugalladijkunami Jesusta katish rigugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ñan kuchubi tiyaj ishki na rikujkunaga Jesús rigushkada uyusha, “Manduj Jesús, Rey Davidbuj Churi, ñukuchida llakiribairi,” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Upallachun nisha genteguna rimakish, “Manduj Jesús, Rey Davidbuj Churi, ñukuchida llakiribairi,” nisha ashtanmi kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chida uyusha Jesús shayarisha paigunada kayushaga, “¿Imadadi kangunamu rurachun ninguichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Shina niki, “Manduj Jesuslla, rikujmi gangu munanchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chimunda Jesús paigunamunda llakirisha ñawigunabi tupunmi, na rikujkunaga rikuj tukusha Jesusta katigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús Paibuj yachagujkunan Jerusalenmu ña kuchuyagusha Betfagé pueblomu Olivos urkubi chayusha Jesús ishki yachagujkunada kachuga, ");
INSERT INTO qxl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kashna nisha: “Ch'imbapura uchilla pueblomu richi. Chillabidimi warmi burru watushka wawa burrundij shayajta japinguichi. Chimundaga kacharisha burrugunada pushamunguichilla. ");
INSERT INTO qxl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Maijinbish imash nikiga, ‘Manduj Jesusmi ministigun,’ ninguichi. Shina nikiga kachungallami.” ");
INSERT INTO qxl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kaiga Dios nishkada parluj kashna nishka p'aktachunmi shina tukuga: ");
INSERT INTO qxl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión pueblobi kausujkunamu parlichi: ‘Riki, kambuj Jatun Mandujka k'uyaj shungumi, burrubi sikushka kangunajmumi shamun, shuj wawa burrubi, cargada aparij burruj wawabi.’ ” ");
INSERT INTO qxl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chi ishki yachagujkuna risha ima laya Jesús mandushkada rurasha, ");
INSERT INTO qxl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","mamun burruda wawandij pushusha rishaga paigunaga jawalla churarishkada chi burrugunabi paltuki chi jawabi Jesusga sikuga. ");
INSERT INTO qxl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Taugalladigunami paigunaj jawalla churanada ñanbi chutachigaguna. Chaishujkunaga ramagunada yuramunda p'itisha ñanbi mandugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Shinaidi ñaubusha rijkunash washada katijkunash kashna nisha kaparigaguna: “¡Hosana Rey Davidbuj Churi! Manduj Diosbuj shutibi shamujtaga <Alli nishka gai> ninchimi. ¡Jawa pachabish Hosana nishka gachun!” ");
INSERT INTO qxl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalenmu Jesús waiguki tuki chibi kausajkunami bullaidi jatarisha kaida chaida yuyusha “¿Kaiga pidikun?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Shina niki gentegunaga, “Dios nishkada parluj Jesusmigun, Galilea llaktabi tiyuj Nazaret pueblomunda,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús Diosbuj wasimu waigusha tuki chibi k'atujkunada shinaidi randigujkunada washamu llujshichisha kachuga. Gentegunaj kuchkida cambiusha tiyajkunaj mizagunadash shinaidi palomada k'atuna tiyarinagunadash tangushtaga. ");
INSERT INTO qxl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chimunda Jesús niga, “Dios escribichishkabi ninmi: ‘Ñukaj wasiga Diosta mañana wasi nishkami ganga.’ Ashtanbish kangunaga kai wasida ‘shuwaguna tiyana ut'ku shinadami’ rurashkanguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Diosbuj wasibi na rikujkunama suchugunama Jesusbujmu kuchuyaki Paiga alliyachigallami. ");
INSERT INTO qxl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ashtanbish manduj curaguna shinaidi Moisés mandushkada yachachijkunash pish na ruri pudishkagunada rurujta rikushaga shinaidi Diosbuj wasibi maraguna, “¡Hosana Rey Davidbuj Churi!” nisha kaparijta uyushaga p'iñarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Shinamunda Jesusta, “¿Paiguna ima laya nisha nigujta uyunguichu?” nigaguna. Chimunda Jesús niga, “Ari, uyanimi. Ashtanbish kangunaga ¿nachu kaida liyushkanguichi? Dios escribichishkabiga, ‘Uchilla maragunakish chuchuj maragunakish, Kan Diosmi Kanlladadi <Allimi gangui> nina shimigunada churushkangui,’ ninmi.” ");
INSERT INTO qxl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Shinushami paigunada sakisha chi pueblomunda llujshisha Betania pueblomu rishaga chibimi pakariga. ");
INSERT INTO qxl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kayundij tutamunda Jerusalén pueblomu ichiyagusha Jesús yarijachiga. ");
INSERT INTO qxl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chi ñan kuchubi shuj jigus yurada rikusha kuchuyaga. Ashtanbish ima mikunadash na japisha p'angagunaida rikushaga Jesusga chi yuradaga, “¡Kununmunda ichimunga ima granudash amalladi aparichun!” nisha niga. Chi k'ipaga yuraga ñash chakirigallami. ");
INSERT INTO qxl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Shina tukushkada rikushaga Paibuj yachagujkuna mancharishkaidijkuna Jesusta kashna nisha tapuga: “¿Ima layamunda jigus yuraga ñash chakirinllandi?” ");
INSERT INTO qxl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chimunda Jesús niga, “Kabishkadadimi nini: kanguna tuki shungun crisha kaida chaida na yuyushalla na kai jigus yurada rurushka layaidaga rurunguichimuchu. Ashtanbish kanguna kai urkudaga, ‘Kaimunda anchi; jatun yaku kuchamu ri tigrungui,’ nikiga shina rurunmullami. ");
INSERT INTO qxl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kanguna Diosta crisha mañushaga ima mañushkagunadash japinguichillami.” ");
INSERT INTO qxl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Diosbuj wasimu Jesús waigusha chibi yachachiguki curagunada mandujkuna israelgunaj pushaj yuyijkunash kuchuyasha tapushaga, “¿Pi mandukidi kaigunadaga kashna rurangui? ¿Pidi kandaga kashna rurachigun?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Shina niki Jesusga niga, “Ñukash kangunada shuj tapunaida tapusha; tapushkada parlakiga Ñukash pi mandushkamunda kaigunada rurushkada parlushallami. ");
INSERT INTO qxl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juanchu bautizashaga ¿pi kachukidi bautizajkuga? ¿Dioschu, na gashaga gentegunachu?” Shina niki kaishuj chaishuj parlanukungu kallarigaguna kashna nisha: “ ‘Diosmi kachuga,’ nikiga ‘Shinadijka ¿imashadi Juanchu nishkada na criganguichi?’ ningami. ");
INSERT INTO qxl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Shinaidi gentegunada mancharishkamundami, ‘Gentegunami kachashkanga,’ ningukish na pudinchi, Juanchu Dios nishkada parluj gashkada tukiguna crishkamunda.” ");
INSERT INTO qxl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Shinushaga Jesusmunga, “Na yachanchichu,” nigaguna. Shina niki Jesusga, “Shinadijka Ñukash pi manduki kaigunada kashna rurashkadash na parlushachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús parlusha katishaga, “¿Kai parlanamunda imada yuyanguichi? Shuj k'arimi ishki churida chariga. Ñauba churij kuchumu rishaga, ‘Churi, kunun p'unllaga ñukaj uva tarbushkabi trabajangu ri,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Shina niki chi churiga, ‘Na rish ninichu,’ niga. Shinash k'ipa yuyarishaga rigallami. ");
INSERT INTO qxl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Shinaidi taitaga chaishuj churijmu kuchuyasha shina layaidi niga. Shina niki, ‘Ari, taita, rishallami,’ niga. Shina nishash na rigachu. ");
INSERT INTO qxl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“¿Maijindi ishkimundaga taita munushkada ruruga?” nisha Jesús tapuga. Paigunaga, “Ñauba churi,” nigaguna. Jesusga niga, “Kabishkadadimi nini, impuestoda cobrujkuna shinaidi k'arigunamu k'aturisha purij warmigunadijmi kanguna narikish waigujllabidi Diosbuj mandanamuga ñaubungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bautizaj Juanchu kabishkada rurusha kausana ñanda rikuchingu shamukish kangunaga na crishkamundami kashna nini. Ashtangarin impuestoda cobrujkuna shinaidi k'arigunamu k'aturisha purij warmigunash pai parlushkada crigagunami. Kangunagarin shinagunada rikushash pai nishkada cringujka nalladi yuyariganguichichu.” ");
INSERT INTO qxl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ashtan shuj yuyachinadash uyichi: Shuj achpayujka paibuj milga achpabi uvada lantusha muyundijtash pirkasha churuga. Shuj ut'kuda ut'kuga vinoda chibi rurungaj, shinaidi jawamunda tukida rikusha chapana wasidash ruruga. Chi k'ipaga achpabi rurujkunamu partido rurachun kushaga karu llaktamu riga. ");
INSERT INTO qxl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ña uvada pallana p'unlla p'aktukiga chi partido rurujkunajmunda pai japina gashkada tandachichun paibuj sirvijkunada kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ashtanbish chi partido rurujkunaga chi sirvijkunada japishaga shujtaga takugaguna, kaishujtaga wañuchiga shinaidi chaishujtaga rumigunan pigugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chi achpayujka ñaubusha kachushka sirvijkunadash ashtandi yalli kutin kachukish chi sirvijkunanbish shinaidimi rurugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Tukigunada kachushka k'ipa, ‘Ñukaj churidaga kazungagunami,’ nisha yuyasha paibuj churidaga kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ashtanbish chi partido rurujkunaga paibuj churida rikusha paigunapura, ‘Kaikumi paibuj taitamunda kai achpadaga japinga. Pai japinada ñukuchilla japingu wañuchishtashunchi,’ nisha ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Shinusha paida charirisha uva chagramunda washamu llujshichish shitusha wañuchigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Shinadijka kununga ima ura chi uva chagrayuj shamushaga ¿chi partido rurujkunadaga imada rurunga yuyanguichi?” ");
INSERT INTO qxl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Shina niki nigaguna, “Chi na alligunadaga na llakirisha illujtami tukuchishtanga. Uva chagradaga shuj partido rurujkunamu kunga, pallana p'unlla chayuki pai japina gashkada kuchunllaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús nigusha niga, “Ima urash kaidaga ¿nachu kangunaga Dios escribichishkabi liyushkanguichi? ‘Wasichijkuna na munusha shitushka rumiga ashtan kallarimu churana rumimi tukushka. Kaidaga Manduj Diosmi rurushka. Shinushaga ñukuchij ñawibiga k'uilladijmi gan.’ ");
INSERT INTO qxl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Shinushaga ninimi, Diosbuj mandanaga kangunamunda kichushkami ganga. Shinaidi Paibujta rurusha alli frutoda kujkunamumi kushka ganga. ");
INSERT INTO qxl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Maijin kai rumi jawabi urmujka p'akiringami. Maijinbuj jawabi kai rumi urmushash ñutushtangami.” ");
INSERT INTO qxl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Curagunada mandujkuna fariseogunash chi yuyachinagunan Jesús parlajta uyushaga paigunamunda rimashkadami yachugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chimundami ima layash prezungu munushash Dios nishkada parluj gashkada tukiguna crishkamunda, Jesustaga japinada manchagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kutinlladi Jesús yuyachinagunan parlungu kallarishaga paigunada kashna niga: ");
INSERT INTO qxl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Diosbuj mandanaga shuj jatun manduj paibuj churimu bodada ruruj shinami. ");
INSERT INTO qxl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chi mandujka paibuj sirvijkunadaga bodamu kayushkagunada pushamuchun kachuga; ashtanbish chigunaga na shamush nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kutin shuj sirvijkunada kachuga, kashna nisha: ‘Bodamu kayushkagunada kashna ninguichi: Rikichi, mikunaga ña yanushkamigun; ñukaj k'ari wagragunadash shinaidi lluchkalla animalgunadash ñami wañuchishkagun. Tukimi ña karanallagun. Bodamu shamichilla.’ ");
INSERT INTO qxl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Shina niki chi kayushkagunaga ima na uyash nisha, shujka paibuj achpamu, kaishujka paibuj randishkagunada k'atunamu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Chaishujkunaga jatun mandujbuj sirvijkunada japisha wañuchingagamami takugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jatun mandujka kaigunada uyushaga manchanaidi p'iñarisha chi wañuchijkunada tukuchishtachun shinaidi paigunaj kausashkagunadash illujta rupachichun paibuj soldadogunada kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chi k'ipa paibuj sirvijkunada niga, ‘Kai bodajka ña tuki mikuna rurushkallami gan, ashtangarin chi bodamu kayashkaguna shamunaga na kabishkagunachushka. ");
INSERT INTO qxl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Shinushaga jatun ñangunamu richi. Mashnalla tupujkunada bodamu kayunguichi.’ ");
INSERT INTO qxl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Chimunda chi sirvijkunaga ñangunamu llujshishaga tuki tupanukujkunada pushusha tandachigaguna, alligunada na alligunadash; shinami chi gentegunan boda wasi junduga. ");
INSERT INTO qxl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Jatun manduj pai kayashkagunada rikungu waigushaga shuj k'ari bodamu rina churanada na churarishkada rikuga. ");
INSERT INTO qxl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Paidaga, ‘Uyi, bodamu shamuna churanada nash churashkadijka ¿ima layadi kaimu waiguganguiri?’ niga. Shina niki upalla sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Chimunda jatun mandujka sirvijkunada niga, ‘Chakidash makidash watusha washa yanamangabi shitichi. Chibimi kirugunash kanirisha karrusk'ichisha wakungaguna.’ ");
INSERT INTO qxl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Diosbuj mandanabi shinalladijmi. Taugagunami kayushka gashka; ashtangarin ashallagunami agllushka gan.” ");
INSERT INTO qxl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chimunda fariseoguna risha Jesusta Pai parlashkallabidi urmachisha juchachingu nisha parlanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Shinushami paigunada katijkunada shinaidi Herodesbuj katijkunadash igulda mandusha kachugaguna kashna nichun: “Yachachij, kan kabishkada parluj gashkada, Dios nishka laya kausachun yachachij gashkadash, genteguna ima nishkadash na kazusha, paiguna <Alli> nichunbish na parluj gashkadash yachanchimi. ");
INSERT INTO qxl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Shinushaga ¿kanmunga ima alli rikurin? ¿Roma llaktada jatun mandujmu impuestoda kunaga kabinchu?” ");
INSERT INTO qxl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ashtanbish Jesús paigunaj na alli yuyigunada yachushkamundaga niga, “Ishki siki nij tukushalla purijkuna, ¿imashadi Ñukada juchachingaj pandachingu munanguichi? ");
INSERT INTO qxl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Impuestomu kuna kuchkida ñukamu rikuchichiri.” Shina niki shuj denarioda apamusha kugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chimunda Jesusga, “Kuchkibi tiyuj musrhash shutish ¿pibujtikun?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Shina niki, “Romada mandujbujmi,” nigaguna. Chimunda Jesusga niga, “Shinushaga Romada mandujbujtaga paillamundi kuichiri. Diosbujtaga Diosllamundi kuichiri.” ");
INSERT INTO qxl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kai nishkagunada uyusha mancharishkaidiguna gasha Jesusta sakisha rigallagunami. ");
INSERT INTO qxl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chi p'unllalladi saduceoguna Jesusbujmu shamushaga wañushkaguna kausarinada na crijkunashkamunda tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yachachij, Moisés yachachishkabiga kashnami nin: <Maijin k'arish marada na charishalla wañukiga wañujbuj warminmi paibuj waukiga kazarana gan, wañushka wauki maragunada charij laya gachun.> ");
INSERT INTO qxl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Shinadijka ñukuchipuramundami kanchis waukiguna tiyashka. Ñauba wauki kazarashaga wañuga. Na maragunada charishkamundaga paibuj warmidaga k'ipa wauki kazarachun sakiga. ");
INSERT INTO qxl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Katij waukinbish, k'ipadij waukinbish, kanchis waukigunagama shinaidimi tukuga. ");
INSERT INTO qxl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tukiguna wañushka k'ipaga warmish wañugami. ");
INSERT INTO qxl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Shinadijka, tukigunan kazarashka gashkamundaga ¿wañushkaguna kausari p'unllabiga chi kanchis waukigunamundaga maijinbujti warmidijka ganga?” ");
INSERT INTO qxl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chimunda Jesusga niga, “Kangunaga Diosbuj Shimibi ima nishkadash shinaidi Dios imada ruri pudishkadash na rijsishkamundaga manchanaidimi pandaringuichi. ");
INSERT INTO qxl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Shinushaga wañushkaguna kausarina p'unllabiga k'arigunash warmigunash na kazarangagunachu; ashtanbish jawa pachamunda angelguna shinami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ashtanbish wañushkaguna kausarinamundaga Dios kangunamu kashna nishkadaga ¿nachu liyushkanguichi? Dios kaidami niga: ");
INSERT INTO qxl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ñukaga Abrahambuj Isaacbuj Jacob-buj Diosmi gani.’ Shinushaga Paiga na wañushkagunaj Dioschu; ashtanbish kausujkunaj Diosmigun.” ");
INSERT INTO qxl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kai nishkada uyusha gentegunaga Jesús yachachishkagunamunda mancharishkaidi tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chi saduceogunada Jesús upayachishkada uyusha fariseogunaga tandanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Paigunamunda shujka mandushkagunada pachun yachujka imallabish pandariki rimungu nishallami kashna nisha tapuga: ");
INSERT INTO qxl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yachachij, mandushkagunamundaga ¿maijindij yallidi jatun mandushka gan?” ");
INSERT INTO qxl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Shina niki Jesusga, “ ‘Kambuj Manduj Diostaga tuki shungun tuki alman tuki yuyinbish k'uyangui.’ ");
INSERT INTO qxl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kai mandushkami tukigunamunda jatun yalli alli gan. ");
INSERT INTO qxl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kai mandushka k'ipabish shinaidimi nin: ‘Shujkunadash kikinda layaidi k'uyungui.’ ");
INSERT INTO qxl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kai ishki mandashkagunabimi Moisés mandushkash, Dios nishkada parlujkuna yachachishkash, chillabidi apachishka gan.” ");
INSERT INTO qxl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseoguna chairijti tandanukushka gaki Jesús paigunada kashna nisha tapuga: ");
INSERT INTO qxl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Cristomundaga ¿imadadi yuyunguichi? ¿Pimundadi shamun?” Shina niki, “Ñauba Rey Davidmundami shamun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chimunda Jesusga niga, “Shinadijka, Davidga Diosbuj Espíritu yuyida kuki ¿ima nishadi paidaga <Ñukada Manduj> nigari? Davidlladimi niga: ");
INSERT INTO qxl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Manduj Diosga ñukada Mandujtaga, “Kanda p'iñujkunada ñuka kambuj chaki sarunabi churungagama ñukaj alli ladubi tiyari,” nisha nishkami.’ ");
INSERT INTO qxl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Shinushaga Cristoga ¿ima layadij Davidmunda shamushka gangari? Davidlladi, <ñukada Manduj> nisha paida nikiga.” ");
INSERT INTO qxl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesús shina nikiga shuj shimiwaidash pish na ni pudigachu. Chi p'unllamunda pachami tukiguna kutin tapunadaga manchugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chiguna k'ipaga gentegunada shinaidi Paibuj yachagujkunada Jesusga niga, ");
INSERT INTO qxl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés mandushkada yachachijkunash fariseogunash Moisés manduj gashka shinaidimi mandunguna. ");
INSERT INTO qxl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Shinushaga yachachishkagunada kazunaminguichi, shinaidi paiguna nishkadash ruranaminguichi. Ashtangarin paiguna purishka layadaga ama katinguichichu; paigunaga <Kaidami ruranagun> nishash na p'aktachijkunachu. ");
INSERT INTO qxl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pish na apari pudibuj llashij cargadami shujkunaj rigra jawabi shitusha apachijkuna layami mandan. Ashtanbish paigunaga dedollanbish na tuparisha nij shinami p'aktachingujka na jursaringuna. ");
INSERT INTO qxl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Imada rurushash genteguna paigunada rikuchunllami rurunguna. Paigunaga jatun p'atuj karabi Diosbuj Shimi escribishkada frentebi rigrabish watarishka purijkunami gan; shinaidi paiguna alli gashka rikuringajlla churanadash jatun tsuntsulladadimi churarijkuna gan. ");
INSERT INTO qxl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jatun mikunagunabish ñaubukimi tiyarisha mikungu manchanaidi munujkuna gan; Diosmunda yachana wasigunabish alli pushtuda mashkusha ñaubuki tiyarijkuna gan; ");
INSERT INTO qxl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","shinaidi genteguna lasagunabi tupushash allidijkunada shina saludachun, shinaidi ‘Rabí’ nichunmi munujkuna gan. ");
INSERT INTO qxl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ashtanbish kangunaga ‘Rabí’ nichunga ama mununguichichu. Ashtangarin tukigunami waukindijkuna ganguichi; shinushaga shuj yachachijlladami charinguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Shinaidi kai pachabi gajkunadaga ama pidash ‘Taita’ ninguichichu. Kangunaga jawa pachabi tiyuj shuj Taitaidami charinguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","‘Yachachij’ nichunllash ama mununguichichu, shuj Yachachijlla Cristoda charishkamunda. ");
INSERT INTO qxl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kangunamunda maijin jatun tukushkaga kangunada sirvij gachun. ");
INSERT INTO qxl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Maijinsh <Ñukalla yallimini> nijka na valichishkami ganga. <Na valichuni> nijka jatunyachishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Ay, ishki siki imadash nij tukushalla purij fariseoguna, mandushkagunada yachachijkuna! ¡Imachari tukunguichi! Jawa pacha Diosbuj mandanamu genteguna waiguna punguda ichkuj shina jarkunguichi. Waigungu munujkunadash waiguchunga na sakinguichichu. Shinaidi kangunalladikish na waigunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Ay, ishki siki imadash nij tukushalla purij fariseoguna, mandushkagunada yachachijkuna! ¡Imachari tukunguichi! Shujllash kangunada katichun nishalla, kangunaga tuki ladu achpadash, jatun yaku kuchadashmi puringuichi. Ña shina rurushaga kangunaidi japina uku pacha ninadami paidaga ishki kutin yalli japinallada ruranguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Ay, ñawi na rikuj pushujkunalla! ¡Imachari tukunguichi! Kangunami, ‘Maijin, <Diosbuj wasimunda p'aktachishami> nishash imash na imachugun,’ ninguichi. ‘Ashtanbish, <Diosbuj wasibi tiyaj kurimunda> nishaga imadash p'aktachinami gan,’ nishami yachachinguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Yuyi illuj, na rikujkuna! ¿Imadi yalli vali gan? ¿Kurichu na gashaga Diosbuj wasichu? Diosbuj wasimi kuridaga Diosbujlladi gashkada rurun. ");
INSERT INTO qxl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Shinaidi ninguichi: ‘Maijinbish, <Altarmunda p'aktachishami> nishash imash na imachugun. Ashtangarin maijin <Altar jawabi tiyaj kumbidashkamunda> nijka ima nishkadaga p'aktachinami gan,’ nisha ninguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Na rikujkuna! ¿Imadi yalli vali gan? ¿Diosmu kumbidashkachu na gashaga altarchu? Altarmi Diosmu kumbidashkadash Diosbujlladi gashkada rurun. ");
INSERT INTO qxl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Shinushaga maijin ‘Kai altarmunda p'aktachishami,’ nijka na chi altarllamundachu nin; ashtanbish chi altarmundash, chi jawabi tuki tiyajkunamundashmi nin. ");
INSERT INTO qxl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Shinaidi maijin <Diosbuj wasimundadimi nini> nijka na chillamundachu nin; ashtanbish chi wasibi kausuj Diosmundashmi nin. ");
INSERT INTO qxl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Maijin <Jawa pachamundadimi p'aktachisha> nijka Dios mandashka pushtumundami nin, shinalladi chibi tiyarij Diosmundashmi nin. ");
INSERT INTO qxl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Ay, ishki siki imadash nij tukushalla purij fariseoguna, mandushkagunada yachachijkuna! ¡Imachari tukunguichi! Kangunami mintada, anista, cominoda, patsujmunda (100) chungada Diosmu kujkuna ganguichi. Shina gashash tuki Moisés mandushkamunda yalli jatun yachachishkagunadaga na kazushkanguichichu. Chibimi kabishkada ruraj, shujkunamunda llakirij, shinaidi Diosta chi yuyillan crijkuna gachun yachachin. Kaidami ruranadij gashkanguichi, chaishuj ruranagunadash na sakishalla. ");
INSERT INTO qxl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Na rikuj pushujkunalla! ¡Kangunami uchilla chuspida mikunamunda shushushash jatun camellodaga millpuj shina pandaringuichi! ");
INSERT INTO qxl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Ay, ishki siki imadash nij tukushalla purij fariseoguna, mandushkagunada yachachijkuna! ¡Imachari tukunguichi! Vazudash latudash washalladami maillujkuna layanguichi. Ashtangarin kangunaj shungu ukubiga shujkunajta shuwana yuyigunan, juchagunada rurusha na jarkarina yuyigunanmi junda ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Na rikuj fariseoguna! Ñaubushadi, vazu ukudash latu ukudash mailluj shina linshichiri; shina rurushami washamush linshushka sakiringuichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Ay, ishki siki imadash nij tukushalla purij fariseoguna, mandushkagunada yachachijkuna! ¡Imachari tukunguichi! Kangunami wañushkada churana wasida yurujlladi rurushka shina ganguichi. Washallaga k'uilladij ashtanbish ukumunga wañushka tullugunan shinaidi tuki laya mapagunan jundagunanguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kangunaga shinami ganguichi. Washalla genteguna rikibiga allilladigunami rikuringuichi. Ashtanbish uku shungubiga milli yuyigunan jundashka nij tukushalla purij ishki sikigunaminguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Ay, ishki siki imadash nij tukushalla purij fariseoguna, mandushkagunada yachachijkuna! ¡Imachari tukunguichi! Dios nishkada parlujkuna wañuki bovedagunada rurujkuna, shinaidi alligunada rurujkunaj musrhagunada k'uillada parijajkuna. ");
INSERT INTO qxl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chimundaga ninguichi, ‘Ñukuchi ñauba taitagunaj p'unllabi kausashkashaga Dios nishkada parlajkunadaga paigunan na wañuchinchimuchuga.’ ");
INSERT INTO qxl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kashna nishaga Dios nishkada parlujkunada wañuchijkunamunda wacharimushkada kangunaidimi parlusha rijsiringuichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Shinusha kangunaj ñauba taitaguna rurungu kallarishkadaga tukuchichiri. ");
INSERT INTO qxl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Culebra shina millida rurujkunaminguichi! Chi llakichina uku pacha ninamu rinamundaga ima layash na mitikunguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Shinushami Ñukaga Dios nishkada parlajkunada, yachuj tukushkagunada, yachachijkunadash kachusha. Chimundaga kangunaga shujkunadaga wañuchishami cruzbi chakatanguichi; kaishujkunadaga Diosmunda yachana wasibimi azilgun dalinguichi; shinaidi pueblogunamu rikish katik'ichunguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Shina gashkamundaga kai tuki alli gentegunamunda shinaidi allida ruruj Abelmunda pacha Berequiasbuj churi Zacariasgama yaur kai pachabi jicharishkamundaga kangunaj jawabimi llakichinaga urmunga. Zacariastami Diosbuj wasibi tiyaj altar kuchubi wañuchiganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kabishkadadimi nini, kai tukigunamunda llakichinaga kai p'unllabi kausajkunaj jawabimi urmunga.” ");
INSERT INTO qxl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalén, Jerusalén, Dios nishkada parlujkunadami wañuchishkanguichi; shinaidi Dios kachushkagunadash rumigunanmi pigushkanguichi! Ima layami warmi atil, wawagunada rigra ukubi ugllun, shinaidimi kambuj wawagunadash tauga kutin tandachingu munashkani; shinash na munashkanguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Shinushaga rikunguichi, kangunaj wasiga shitushkami sakiringa. ");
INSERT INTO qxl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaidami kangunamu nini, kununmunda pacha kutinlladijka Ñukadaga na rikunguichichu, kanguna ‘¡Manduj Diosbuj shutibi shamuj allimi gangui!’ ningama.” ");
INSERT INTO qxl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Diosbuj wasimunda Jesús llujshisha ña riguki, chi wasi pirkagunada rikuchingu Paibuj yachagujkuna kuchuyamugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Shina rikuchiki Jesusga niga, “¿Kai tukigunada rikunguichichu? Kabishkadadimi nini, kaibiga shuj rumillash pirkushkaga na sakiringachu. Illujtami urmachisha tukuchishka ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chi k'ipaga Olivos urkumu risha Jesús tiyariga. Chibimi Paibuj yachagujkuna kuchuyasha ch'ikunyachisha tapugaguna, “Kaigunaga ima uradi kashna tukunga parlachunmi munanchi. ¿Kan shamunash, kai pacha tukurinash ima rikuchinandij rikuchishka ganga?” ");
INSERT INTO qxl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Shina tapuki Jesusga niga, “Ama pish kangunada pandachichunga yuyin ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Taugagunami Ñukaj shutibi shamunga; ‘Ñukami Cristo gani,’ nishami taugagunada llagmusha pandachinga. ");
INSERT INTO qxl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Llaktapuragunabi pachun p'iñanuki wañunuki kaibish chaibish tiyajta uyushash ama mancharinguichichu. Shinaidimi tukuna gan. Shina gakish kai pachajka narij tukurichu ganga. ");
INSERT INTO qxl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Shuj llaktabi kausujkunan chaishuj llaktabi kausujkunanmi takanukungu jataringaguna; shinaidi achpa kuyish, mikuna illushkamunda yarijish tauga pushtubimi tiyunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Chairijti kaigunaga kallari wachi nani shinallami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Chimundaga kangunada llakichichun japichingagunami; shinaidi wañuchingagunami; shinaidi Ñukada katishkamundami kangunadaga tuki llaktamunda genteguna na rikunachinga. ");
INSERT INTO qxl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chi p'unllagunadaga taugagunami Ñukada crishkadash chingachingaguna. Shinaidi na rikunachinukusha llakichichunbish kaishuj chaishujmumi japichinukungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Shinaidi taugagunami Diosmunda llagmusha yachachijkuna shamunga. Taugagunada pandachingaguna. ");
INSERT INTO qxl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Shina na allida ruranaguna mirariki taugaguna k'uyanukushkami chingaringa. ");
INSERT INTO qxl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ashtangarin maijinsh tukurina p'unllagama Ñukada tuki shungun crisha alli katijka kishpichishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dios mandanamunda Alli Shimiga tuki kai pachabi kausajkunamumi parlushka ganga, tuki llaktagunabi yachi chayachun. Chimundaga tukurina p'unlla shamungami. ");
INSERT INTO qxl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Dios nishkada parluj Daniel parlusha escribishka shinami millanaidi na rikunachibujlladadi rurashkada Diosbuj wasibi rikunguichi. (Maijinbish chi parlushkada liyujka alli intindinguichi.) ");
INSERT INTO qxl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chida rikushaga Judea llaktabi gajkunaga urkugunabi mitikungu richun. ");
INSERT INTO qxl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Shinaidi kikinbuj wasi jawabi gajkunaga ima charishkada llujshichingujllash uku pambamu ama uriyachun. ");
INSERT INTO qxl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chagrabi purijkunash wasimunda churanada apungujllash ama vueltachun. ");
INSERT INTO qxl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chi p'unllaguna iksa charij warmigunash, chuchuchigujkunash ¡imachari tukunga! ");
INSERT INTO qxl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kanguna mitikusha rinaga ama tamia chiri p'unllaguna shinaidi ama samana p'unllash gachun Diosta mañichi. ");
INSERT INTO qxl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chibiga jatun llakimi tiyanga. Kai pacha kallarishkamundadi kunungama kashna jatun llakiga narij tiyashkachu. K'ipa p'unllagunash na tiyangachu. ");
INSERT INTO qxl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chi llaki p'unllaguna ashtan katichun Dios na jarkushkakiga pish na kishpirinmunchu. Pai k'uyasha agllushkagunamundami chi llaki p'unllagunadaga ashallada rurunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kangunada maijinsh, ‘Rikichi, Cristoga kaibimi gan,’ na gashaga ‘Chaibimi gan,’ nikish ama cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Llagmushami, ‘Cristomi gani,’ nisha, na gashaga ‘Dios nishkada parlujmi gani,’ nisha shamungaguna. Pish na ruri pudishkagunada, pish na rikuchishkagunadash rurusha Dios agllushkagunadash pudishallaga pandachingumi munungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Imash narij tukujllabidi ñami kangunamu nini. ");
INSERT INTO qxl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Shinushaga maijinsh, ‘Rikichi, Pai Cristo chi shitushka pushtubimigun,’ nikish ama ringuichichu. Na gashaga, ‘Rikichi, kai ukubimi mitikushka,’ nikish ama cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ima layami indi llujshina ladumunda indi waiguna ladugama relámpago p'alanij rikurin shinami Aichayuj tukushka Churi shamuna p'unllash ganga. ");
INSERT INTO qxl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maibimi wañushkaguna sirin, chibimi angagunaga tandanukunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Chi manchanai llakichina p'unllaguna ña tukurishka k'ipaga, ‘indish ansayangami, lunash na p'unllayachingachu. Luzerogunash jawa cielomunda urmungami. Jawabi tuki imalla tiyajkunash ch'ujchuchishkaminga.’ ");
INSERT INTO qxl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chimundaga Aichayuj tukushka Churida rikuchinaga jawa cielobimi rikuringa. Tuki kai pachabi tiyaj tuki laya gentegunami manchillandi wakungaguna. Shinami Aichayuj tukushka Churi tukida ruri pudijlla jatun k'uilla p'alaniguj gashkan jawa pachamunda p'uyugunabi shamujta rikungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Paiga Paibuj angelgunadami chusku ladumunda kai pachabi tiyuj shuj ladu manyamundash chaishuj ladu manyagama jinchida buzinabi tukasha Paibuj agllushkagunada tandachichun kachunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Jigus yura ima laya tukujta rikusha yuyida japinguichi. Chi yuramunda llullu ramaguna iñuki p'angagunash kutin iñusha jundukiga k'uilla rupi p'unllaguna chayamugushkada kangunalladi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Shinalladi kai tukigunada rikushaga chi p'unllagunaga ña pungubi gashkada yachichi. ");
INSERT INTO qxl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kabishkadadimi nini, kausajkuna narij wañujllabidimi kai tukigunaga shina tukunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jawa pachash kai pachash tukuringami, ashtanbish Ñuka nishka shimigunaga na tukuringachu. ");
INSERT INTO qxl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ima p'unlla ima uras shina tukunadaga pish na yachunchu. Jawa pachamunda angelgunash Diosbuj Churilladikish na yachunchu. Taitallami yachun. ");
INSERT INTO qxl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ima layami Noé kausi p'unllaguna tukuga, shinaidimi Aichayuj tukushka Churi shamuna p'unllabish tukunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chi p'unllaguna narikish pachun tamiujllabidi Noé arcabi sikungamaga genteguna ubiasha, mikusha, kazarasha, kazarachisha kausagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ashtanbish kungushkadami ñash manchanaidi tamia shamusha yaku jatarisha tukigunada apush riga. Shinaidimi Aichayuj tukushka Churi shamunajka tukunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chi ratugunaga ishki k'arigunami achpabi rurusha puringaguna; shujka pushushkami ganga, chaishujka sakishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Shinaidi ishki warmimi rumibi kutangaguna; shujka pushushkami ganga, chaishujka sakishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Shinushaga Ñuka kangunada Manduj ima ura shamunada kanguna na yachushkamundaga yuyin chapanguichi. ");
INSERT INTO qxl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kaidash yachichi. Shuj wasiyujka tutabi ima urasta shuwa shamunada yachushaga shuwa wasimu waiguchunbish na sakisha yuyinmi chapanmu. ");
INSERT INTO qxl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Shinushaga kangunash rinalla chapanguichi. Aichayuj tukushka Churiga nash yuyashka urastami shamunga. ");
INSERT INTO qxl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Maijindi alli kazuj, alli yuyiyuj sirvij gan? Paimumi mandujka paibuj wasibi tiyujkunamush mikuna uras p'aktuki karachunbish mingun. ");
INSERT INTO qxl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Manduj chayushaga pai mingashkagunada p'aktachigujta japikiga chi sirvijka kushilla gachun. ");
INSERT INTO qxl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kabishkadadimi nini. Chi mandujka tuki imalla charishkada paimumi minganmu. ");
INSERT INTO qxl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ashtanbish chi sirvijka na alli milli gasha, <Manduj narij shamungachu> yuyusha, ");
INSERT INTO qxl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","paigun igulda purij sirvijkunada takungu kallarisha, shinaidi shingagunan tandanukusha mikusha ubiaki, ");
INSERT INTO qxl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","na chapashka p'unlla shinaidi na yachushka uras paibuj manduj shamushaga ");
INSERT INTO qxl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","jinchida llakichinga, ishki siki imadash nij tukushalla purijkunada llakichishka laya. Chibimi kirugunash kanirisha karrusk'ichisha wakungaguna.” ");
INSERT INTO qxl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Jawa pacha Diosbuj mandanaga chunga maralla solteraguna michada japisha kazaraguj novion igulda ringaj tupungu llujshij shinami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pichkaguna alli yuyi charijkunamiga; chaishuj pichkagunaga na alli yuyi charijkunachuga. ");
INSERT INTO qxl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na alli yuyi charij solteragunaga michada apush rishash aceiteda churungajka na apush rigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ashtanbish chaishuj alli yuyi charijkunaga michadash shinaidi aceite p'urudash apugagunami. ");
INSERT INTO qxl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kazaraj novio na ut'kada shamuki, chi solteraguna puñunachishaga tukigunami puñurigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ña chaubi tuta shinada, ‘Ñami novio shamun. Llujshichi tupungaj,’ nisha kaparishka uyariga. ");
INSERT INTO qxl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Chida uyusha, tuki solteraguna rijcharishaga paigunaj michagunada parijangu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chimunda na alli yuyi charij solteragunaga chaishuj alli yuyi charijkunada, ‘Ñukuchij michagunaga ñami wañugun; kangunaj p'itilla aceitewada kumbidichi,’ nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Shina niki alli yuyi charij solteragunaga, ‘Shina rurukiga ñukuchimush kangunamush na p'aktungachu. Ashtanbish aceiteda k'atujkunajmunda kangunallamundi randingu rinami allinmu,’ nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ashtanbish paiguna randingu riguki ñash novio chayamuga. Chi waigunalla solteragunaga novion boda wasimu waigukiga punguda ichkugallagunami. ");
INSERT INTO qxl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chi k'ipa chaishuj solteraguna chayamushaga, ‘Manduj, manduj, ñukuchimush punguda paskabai,’ nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Shina nikiga, ‘Kabishkadadimi nini; kangunadaga na rijsinichu,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesusga kaidashmi niga, “Shinushaga ima p'unlla ima uras shamunada na yachushkamundaga yuyin chapanguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Diosbuj mandanaga shuj k'ari karu llaktamu rinalla gasha pai nishkada rurujkunada kayusha paigunamu kuchkida minguj shinami gan. ");
INSERT INTO qxl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Shujmunga pichka waranga (5.000), kaishujmunga ishki waranga (2.000), shinaidi chaishujmunga waranga (1.000) kuchkigunadami kuga. Ch'ikun ch'ikun paiguna ruri pudishkada mingusha karu llaktamu rigallami. ");
INSERT INTO qxl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pichka waranga kuchkida japijka chi kuchkin rishaga k'atunagunada churusha pichka warangadashmi mirachiga. ");
INSERT INTO qxl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Shina layaidi kaishuj ishki warangada japijkish kutin ishki warangadashmi mirachiga. ");
INSERT INTO qxl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ashtanbish chaishuj warangallada japijka mandujbuj kuchkin rishaga achpada ut'kusha pakushami churuga. ");
INSERT INTO qxl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Uni uni p'unllaguna k'ipa pai nishkada rurujkunada manduj shamushaga mingushka kuchkida mashna mirachishkada paigunan rikungaj kallariga. ");
INSERT INTO qxl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pichka waranga kuchkida japij ñaubusha shamushaga kutin pichka warangadashmi paida mandujmu kuga, kashna nisha: ‘Manduj, kanga pichka warangadami kugangui. Shinushaga riki, kai pichka waranganbishmi mirachishkani.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Shina niki paida mandujka, ‘Allimishka; mandushkada allidami ruruj gashkangui. Kai ashallanbish allida rikuchishkamundaga milgadami kanmunga mingusha. Ñukan kushilla gangu shami,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Shinaidi ishki waranga kuchkida japij k'ipalla shamushaga kashna niga: ‘Manduj, kanga ishki warangadami kugangui. Shinushaga riki, kutin kai ishki waranganbishmi mirachishkani.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Shina niki paida mandujka, ‘Allimishka; mandushkada allidami ruruj gashkangui. Kai ashallanbish allida rikuchishkamundaga milgadami kanmunga mingusha. Ñukan kushilla gangu shami,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Shinaidi chaishuj warangaida japij sirvij chayamushaga mandujmunga niga, ‘Manduj, kan p'aktachichij jinchi k'ari gashkada, na tarbushash japijllada, shinaidi na jichushash tandachijllada ñukaga yachuganimi. ");
INSERT INTO qxl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Shinushami manchusha kambuj kuchkida apusha rishaga achpabi pambusha pakugani. Ashtanbish kambujtaga japi.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Shina niki mandujka, ‘Kan sirvijka na alli killasikimishkangui; ñuka na tarbushash japijllada shinaidi na jichushash tandachijllada kan yachushkashaga ");
INSERT INTO qxl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ñukaj kuchkida apusha bancobi shitungu ringuimugandi. Ñuka shamushaga mama kuchkidash wawa kuchkidash japinimumiga.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chimunda chibi gajkunada, ‘Waranga (1.000) kuchkida kichusha chaishuj chunga warangada (10.000) charijmu kuichi,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Maijinsh charijmunga ashtanmi kushka ganga, shinusha yallidashmi charinga; ashtanbish na charijmundaga ashalla charishkaidash kichushkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kai na alli sirvij imadash na pudijtaga washa yanamangamu shitichi. Chibimi kirugunash kanirisha karrusk'ichisha wakunga.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ima ura Aichayuj tukushka Churij muyundijta k'uilla p'alaniguj shinaidi tuki Paibuj angelgunandi shamushaga Paibuj k'uilladi p'alaniguj mandana tiyarinabimi tiyaringa. ");
INSERT INTO qxl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Shinami tuki llaktagunamundaguna Paibuj ñaubuki tandanukungaguna; chimundaga ima layami shuj michij ovejagunada chivogunamunda ch'ikunyachin shinami paigunapuramunda ch'ikunyachinga. ");
INSERT INTO qxl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ovejagunadaga Paibuj alli ladumu, chivogunadaga Paibuj lluki ladumumi churunga. ");
INSERT INTO qxl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chimunda Jatun Mandujka Paibuj alli ladumu tiyajkunadaga ningami, ‘Kanguna, Ñukaj Taita alligunada kushkaguna, shamichi. Shinaidi kai pachada rurushka pachamundadi kangunamu parijashka Diosbuj mandanada japichi. ");
INSERT INTO qxl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yarijin puriki kangunaga Ñukamu mikunada karuganguichimi; yakunachikish ubiachun kuganguichimi; shuj ladumunda shamusha na rijsisha purikish puñuna ukuda mañachiganguichimi. ");
INSERT INTO qxl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ñuka churana illuj tukukish kuganguichimi; ungushka gakish jambichiganguichimi; carcelbi tiyakish rikungu shamuganguichimi.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Shinushaga allida rurujkunaga tapungagunami, ‘Manduj, ¿ima ura yarijin kanda rikusha mikunada karuganchiri, na gashaga yakunachijta rikusha ubiachiganchiri? ");
INSERT INTO qxl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ima ura kan na rijsisha purijta rikusha puñuna ukuda kuganchiri, na gashaga churana illuj gaki kanmu kuganchiri? ");
INSERT INTO qxl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ima ura kan ungushkada na gashaga carcelbi tiyajtash rikungu riganchiri?’ ");
INSERT INTO qxl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Shina niki Jatun Mandujka, ‘Kabishkadadimi nini, kai uchilla maragunamu laya, Ñukaj waukigunamunda shujllamush tuki imada rurushkash Ñukallamundimi rurushkanguichi,’ ningami. ");
INSERT INTO qxl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Chi k'ipa Jatun Mandujka Paibuj lluki ladumu tiyajkunadaga, ‘Ñukamunda anchichi milliguna; diablomush paibuj angelgunamush parijashka na tukurij ninamu richi,’ ningami. ");
INSERT INTO qxl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‘Ñuka yarijin purikish kangunaga mikunada na karuganguichichu; yakunachikish ubiachun na kuganguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na rijsishka pushtubi purikish puñuna ukuda na mañachiganguichichu; churana illuj tukukish na kuganguichichu; ungushka gakish carcelbi tiyakish rikungujmash na shamuganguichichu.’ ");
INSERT INTO qxl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Shina niki paigunash, ‘Manduj, ¿ima uradi yarijin gajta, yakunachijta, shuj ladumunda shamusha purijta, churana illujta, ungushka gajta, carcelbi tiyajtash kanda rikushash imada na ruruganchi?’ nisha tapungagunami. ");
INSERT INTO qxl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Chimunda Jatun Mandujka, ‘Kabishkadadimi nini, kai uchilla mara laya gentegunamu shujllamush, kai tukigunada na rurushkamundaga ñukamush na rurushkanguichichu,’ ningami. ");
INSERT INTO qxl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chigunaga na tukurij llakichinamu ringaguna; allida rurujkunaga na tukurij kausimu.” ");
INSERT INTO qxl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kai tuki parlanagunada nishka k'ipaga Jesús Paibuj yachagujkunada kashna niga: ");
INSERT INTO qxl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kangunaga ishki p'unllabi Pascua pishta gashkada yachunguichimi. Chibimi Aichayuj tukushka Churiga cruzbi chakatasha wañuchichun kushka ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chi p'unllagunami manduj curagunash shinaidi israelgunada pushaj yuyijkunash curagunada jatun manduj Caifasbuj wasibi tandanukushaga ");
INSERT INTO qxl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ima layash pandachisha Jesusta japingaj shinaidi wañuchingaj yuyarinukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ashtanbish, “Genteguna ama bulla rurachunga chi pishta p'unllagunabiga ama japichishunchi,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betania pueblobi gasha lepra unguiyuj nishka Simonbuj wasibimiga. ");
INSERT INTO qxl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús mizabi tiyakimi shuj warmi milga kuchki valij k'uilla ashnariguj yakuda alabastro rumida rurushka uchilla puñubi apushka kuchuyasha Jesusbuj uma jawabi talliga. ");
INSERT INTO qxl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesusbuj yachagujkuna chida rikusha p'iñarisha, “¿Imashadi kai k'uilla ashnariguj yakuda yangadi jichushtan? ");
INSERT INTO qxl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ashtanbish kai yakuda milga kuchkibi k'atushaga imadash na charijkunamu kunami allinmuga,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús uyushaga, “¿Imashadi kai warmidaga p'iñachinguichi? Pai Ñukada kashna rurushaga allidami rurushka. ");
INSERT INTO qxl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Shinalladi imadash na charijkunadaga kangunapurabiga charinguichilladijmi. Ashtanbish Ñukadaga na tuki ratu charigunguichillachu. ");
INSERT INTO qxl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kai warmi kai k'uilla ashnariguj yakuda Ñukaj cuerpobi tallishaga Ñukada pambanabujmi shina parijaga. ");
INSERT INTO qxl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kabishkadadimi nini. Kai pachabi mai pushtubish Dios kishpichina Alli Shimida yachachishaga kai warmi imada rurushkadashmi parlushka ganga. Shinami kai warmimunda yuyarishka ganga.” ");
INSERT INTO qxl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chunga ishki yachagujkunamunda shujka, Judas Iscariote shuti manduj curagunada rikungu risha, ");
INSERT INTO qxl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kashna niga: “Ñuka kangunamu Jesusta kuchunga ¿mashnada kush ninguichi?” Shina niki paigunaga kinsa chunga (30) kuchkidami kugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chimunda pacha Judasga chi yuyilla gasha ima layash Jesusta japichinada mashkaga. ");
INSERT INTO qxl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Levadura illuj tandada mikuna pishta kallari p'unlla chayamukimi yachagujkuna Jesusbujmu kuchuyashaga, “¿Maibidi Pascua mikunada Kanmu parijachunga munungui?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Shina niki Jesusga, “Pueblomu richi; chibi shuj k'arij wasimu chayushaga kashna ninguichi: ‘Yachachijka, “Ñukaj p'unllaga ñami p'aktamugun. Kambuj wasimumi Ñukaj yachagujkunan Pascuada yuyarisha mikungu risha,” ninmi,’ ninguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesús ima laya mandushkadami Paibuj yachagujkunaga rurugaguna; shinami Pascua mikunada tukida parijagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ña tutayaki Jesusga Paibuj chunga ishki yachagujkunandij mizabi tiyasha, ");
INSERT INTO qxl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","mikugushka ratu Jesusga, “Kabishkadadimi nini, Ñukada p'iñajkunamu kangunapuramunda shujka Ñukada japichingami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Shina niki llakilladi tukusha kaishuj chaishuj, “Manduj, ¿ñukachu gasha kanda japichijka?” nisha tapungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesusga niga, “Ñukan kai latullabidi tandada nuyuchijmi Ñukadaga japichinga. ");
INSERT INTO qxl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kabishkadimigun; Dios escribichishka shina Aichayuj tukushka Churidaga wañuchinga. ¡Ashtangarin maijin japichijka imachari tukunga! Na wacharishkashami alli ganmuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chimunda Jesusta japichingu purij Judasga, “Yachachij, ¿ñukachu gasha kanda japichijka?” nisha tapuki Jesusga, “Kanlladimi ningui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Shinaidi mikugushami Jesusga tandada japisha Diosta, “Diosolopai,” nishka k'ipa yachagujkunamu, “K'aigachi. Mikichi. Kaimigun Ñukaj cuerpo,” nisha chaubisha kuga. ");
INSERT INTO qxl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chi k'ipa shuj copada japisha Diosta <Diosolopai> nisha Paibuj yachagujkunamu kuga. “Kai copamunda tukiguna ubiyichi. ");
INSERT INTO qxl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kaimi Ñukaj yaur. Kai yaurgunmi Ñuka ari nishkada p'aktachingu rikuchisha. Taugagunamundami kai yaurga jichushka ganga, paigunaj juchagunada perdonangaj. ");
INSERT INTO qxl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Shinaidi Ñukaga ninimi, Ñukaj Taitabuj mandanabi mushuj vinoda kangunan ubiana p'unllagama uvan rurushka vinodaga kutinga na ubiashachu,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Salmoskunada cantushka k'ipami Olivos urkumu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chibimi Jesusga, “Kunun tutami kangunaga tukiguna Ñukada crinada chingachinguichi. Dios escribichishkabi kashna nishka shina: ‘Michijta wañuchikiga oveja kanllaga kaida chaida rishami chingashka ganga.’ ");
INSERT INTO qxl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Shinash Ñuka kausarishaga kanguna Galilea llaktamu narij rijllabidimi Ñukaga ñaubusha risha,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Shina nikimi Pedroga, “Tukiguna Kanda crinada chingachikish ñukaga ima urasgamash na chingachishachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chimunda Jesusga, “Kabishkadadimi nini, kunun tutaidimi gallo narikish cantujllabidi kinsa kutin Ñukadaga <Na rijsinichu> ninguimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Shinash Pedroga, “Kangun wañuna gakish Kandaga <Na rijsinichu> nishaga na nishachu,” niga. Tuki yachagujkunash shinaidimi nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chi k'ipa Jesús Paibuj yachagujkunan Getsemaní nishka pushtumu chayushaga, “Ñuka chaida risha Diosta mañungama kaibi tiyarichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chimunda Jesusga Pedrodash shinaidi Zebedeoj ishki churidash pushusha riga. Shina rishami Paibuj shungubi llakin gasha manchanaidi llakiringu kallarisha, ");
INSERT INTO qxl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","paigunadaga, “Ñuka shungubiga wañi llakidami yuyani. Kangunaga kaillabi sakirichi. Na puñushalla Ñukan rijchuj ganguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesusga ashan ñaubujmu risha kungurishaga pambabi tuparingama kumurishami, “Ñuka Taitalla, pudinalla gakiga kai jayuj yakuda ubiana shina llakimunda Ñukada anchuchibai; ashtangarin ama Ñuka munushka gachun, ashtanbish Kan munushka shina gachun,” nisha Diosta mañuga. ");
INSERT INTO qxl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chi k'ipa Paibuj yachagujkuna tiyashkamu shamushaga puñujkunada japishami Pedroda niga, “¿Shuj urawaidash nachu rijchuj Ñukan gai pudiganguichi? ");
INSERT INTO qxl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ama ima jucha ruranabi urmachishka gangujka na puñushalla Diosta mañichi. Kangunaj espirituga allida rurungu munakish aichami shaikushka shinagun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kutinlladi risha kashna nisha mañuga: “Ñuka Taitalla, kai jayuj yakuda ubiuj shinada na jarkana gakiga Kan munushka shina rurushka gachun.” ");
INSERT INTO qxl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yachagujkuna puñunaimunda ñawi ichkariki Jesús shamushaga kutin puñujkunada japiga. ");
INSERT INTO qxl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chimunda paigunada sakisha kinsa kutibi Diosta mañungu rishaga chi shimigunallandi kutin mañuga. ");
INSERT INTO qxl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chimunda Paibuj yachagujkuna tiyashkamu shamushaga Jesusga, “¿Kangunaga puñush katisha samanguichillachu? Rikichi, Aichayuj tukushka Churida juchayujkunaj makibi japichina uras ñami chayamushka. ");
INSERT INTO qxl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jatarichi. Jakuchi. Ñukada japichijka ñami kuchuyamugun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús chairijtij nigujllabidimi chunga ishki yachagujkunamunda Judasga kaspigunama espadagunamada apushka taugalladijkunan shamuga. Chigunaga manduj curaguna, israelgunada pushaj yuyijkuna kachushkami shamugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Japichij Judasga, “Ñawi ichibi ñuka muchushkami, Jesusga ganga; Paida japinguichi,” nishami paigunada ña yachachishkaga. ");
INSERT INTO qxl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Paiga ña Jesusbujmu kuchuyasha, “Yachachij, ¿allillachu gangui?” nisha Paida muchuga. ");
INSERT INTO qxl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Chimunda Jesusga niga, “Amigo, imada rurungu shamushkadaga rurilla.” Chimunda chaishujkuna kuchuyasha Jesusta japisha charirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chibimi Jesusta katijkunapuramunda shujka paibuj espadada surkushaga jatun manduj curaj sirvijta juaktusha rinrinda p'itiga. ");
INSERT INTO qxl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chimunda Jesusga niga, “Kambuj espadada wakichi, wakichina pushtullabidi. Tuki espadan takanukujkunaga ashtanbish espadallandimi wañungaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Nachu yachungui? Ñukaga Ñukaj Taitada mañukiga kununlladi chunga ishki kanllalladi angelgunada yalli kachunmunllami. ");
INSERT INTO qxl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Shina gakiga ¿ima layadi Diosbuj Shimibi ‘Kashnami tukunagun’ nishkaga p'aktungari?” ");
INSERT INTO qxl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chibimi Jesusga gentegunada tapuga, “¿Imashadi kangunaga kaspigunan espadagunan Ñukada shuj shuwamada laya japingu shamuganguichi? Tuki p'unllagunami israelgunaj Diosbuj wasibi yachachigukish ima urash Ñukada na prezu japiganguichichu. ");
INSERT INTO qxl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ashtangarin tuki kaigunaga tukunmi Dios nishkada parlujkuna escribishka shina p'aktachun.” Chimundaga tuki yachagujkunami Jesusllada sakisha mitikusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta japijkunaga curagunada mandaj Caifasbuj wasimu pushusha rigaguna, maibimi Moisés mandushkada yachachijkunash pushaj yuyijkunash tandanukushka tiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesusta pushakimi Pedroga washa washa katisha jatun manduj curaj wasi kanlla pambagama chayuga. Chimu waigusha chapujkunan igulda tiyarisha imabi tukurinashkada rikungu sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chibimi manduj curaguna, israelgunada mandajkunapura tandanukushkabish Jesusta wañuchingaj nisha imalladash llagmusha juchachijkunada mashkagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Taugaguna kuchuyasha llagmusha juchachigukish ima jucha rurashkadash na japigagunachu. Chibimi ishkigunabish kuchuyasha, ");
INSERT INTO qxl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Kai k'ariga, ‘Ñukaga kai Diosbuj wasidaga urmachi pudinimi; kinsa p'unlla k'ipaga kutin shayachimunllami,’ nigami,” nisha juchachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chimunda jatun manduj cura shayarisha Jesusta, “¿Shina nikish nachu ima ninadash charingui? ¿Imadi gan kai tuki kanda juchachishkagunaga?” nisha tapugukish, ");
INSERT INTO qxl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús upalla sakiriga. Shinusha curagunada manduj curaga niga, “Kausuj Diosbuj shutibi, ñukuchimu kabishkada nichun mandanimi. ¿Kanchungui Cristo, Diosbuj Churi?” ");
INSERT INTO qxl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Shina niki Jesusga, “Kanlladimi nishkangui. Kangunadash Ñukash ninimi, Aichayuj tukushka Churidaga Tukida Ruri Pudijbuj alli ladubi tiyajtami kunun p'unllagunamundaga rikunguichi, shinaidi jawa pachamunda p'uyubi shamujtashmi rikunguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Shina niki curagunada manduj curaga paibuj churanada llikishtashaga kashna niga: “Kai k'ari parlushka shimigunaga ¡Diosta imakish na valichishkagunamigun! ¿Imajtikish juchachijkunadaga ashtanga ministishun? Kangunaidimi pai imakish Diosta na valichishkada uyushkanguichi.” ");
INSERT INTO qxl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Shina nishaga, “¿Ima layadi rikurin?” niki chaishujkunaga, “Paiga wañunami kabin,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chimundaga ñawibi t'iukushtashaga juaktugaguna. Chaishujkunaga lutskishaga, ");
INSERT INTO qxl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kan Cristo gashaga ¿maijindi kanda juaktanchi? Parli,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chigunabiga washa pungu pambabi Pedro tiyaki chibi gaj sirvij warmi kuchuyashaga, “Kambish Galileamunda Jesuskundijmi purij gangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Shina niki Pedroga tukigunaj ñaubuki “Na shinachugun. ¿Imadachari nigungui? Na yachanichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chimunda pungu llujshinamu riki kutin shuj warmish rikusha chibi gajkunamu, “Paiga Nazaretmunda Jesuskundij purijmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kutinmi Pedroga, “¡Na shinachugun! ¡Chi k'aridaga nalladi rijsinichu!” nisha juraga. ");
INSERT INTO qxl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chi k'ipalladimi chibi gajkunaga Pedrojmu kuchuyashaga, “Kabishkadimigun, kambish paigunapurallamundadimingui; kan parlarishkabish rijsinallamigun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Shina niki kutin kutin <Kabishkadadimi nini, Ñuka llagmakiga Dios llakichichun> nisha Pedroga, “¡Chi k'aridaga nalladi rijsinichu!” nigujllabidimi gallo cantuga. ");
INSERT INTO qxl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chibimi Pedroga, “Gallo narikish cantujllabidimi kinsa kutin Ñukadaga ‘Na rijsinichu,’ ningui,” nisha Jesús nishkada yuyariga. Chimunda llujshish risha llakirishaidi pachun wakuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ña p'unllayaguki tuki manduj curagunan israelgunada pushaj yuyijkunan ima laya Jesusta wañuchina yuyin parlanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesusta watusha pushushaga Judea llaktada manduj Pilatomu kugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusta juchachisha wañuchinada ña rikushaga Paida japichij Judasga na alli rurashkada manchanaidi yuyarisha, manduj curagunamu yuyijkunamush kinsa chunga (30) kuchkigunada vueltachiga, ");
INSERT INTO qxl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","kashna nisha: “Ima jucha illuj k'arida wañuchichun japichisha juchadami rurashkani.” Ashtanbish paigunaga, “Chiga ñukuchimunga ¿imadi valin? ¡Kambujmi ganga!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chimunda Judasga Diosbuj wasi ukubi kuchkida pigush rishaga sipirishami wañuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Manduj curaguna chi kuchkida tandachishaga, “Kai kuchkiga shuj genteda wañuchingu randishka kuchkimigun; shinushaga Diosmu kushkada tandanabiga na churanachu ganchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Shinushami chi kuchkinga shuj ladumunda shamushkaguna wañuki pambungaj yuyarinukusha Mangada Rurujbuj Achpada randigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Shinushami chi achpaga kunun p'unllagama, “Yaur Pamba” nishkagun. ");
INSERT INTO qxl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Shinami Dios nishkada parluj Jeremías kashna parlashkaga p'aktuga: “Israelguna Paida randingaj ‘Kushun’ nishka kinsa chunga kuchkidami japigaguna; chigunmi Mangada Rurujbuj Achpada randigaguna, ima laya Manduj Dios ñukada mandushka shinalladi.” ");
INSERT INTO qxl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chi llaktada mandachun churashka Pilatoj ñaubuki Jesús ña shayaki, “¿Kanchu israelgunaj jatun manduj gangui?” nisha Pilato tapuki, Jesusga, “Kanlladimi ningui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Manduj curaguna pushaj yuyijkunash Paida juchachigukish Jesusga imadash na nigachu. ");
INSERT INTO qxl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Shinushami Pilatoga, “Tukilladadi kanda juchachisha nigushkagunadash ¿nachu uyungui?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ashtanbish Jesusga shuj shimiwaidash na nigachu; shinushami manduj Pilatoga mancharishkaidi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chi Pascua pishtagunabimi llaktada mandujka genteguna munashka prezuda paigunamu kacharijkuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chigunabimi uyarishkaidi Barrabás shuti prezu tiyaga. ");
INSERT INTO qxl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Jesusta envidiashkamunda paibujmu pushushkada Pilatoga yachugami. Shinushami paiguna tandanukushkabi Pilatoga, “¿Kangunaga maijindadi kacharichun ninguichi: Barrabastachu na gashaga Cristo nishka Jesustachu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ña Pilato juchachisha mandanabi tiyaki paibuj warmiga, “Chi allida ruruj k'aridaga ama imadash rurunguichu. Kunun tutami paimundaga pachun llakirinada suñugani,” nisha parlachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ashtanbish manduj curagunash pushaj yuyijkunashmi Barrabasta kacharinada shinaidi Jesustaga wañuchinada mañachun taugalladijkunada <Ari> nichigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Manduj Pilatoga, “Kai ishkimundaga ¿maijindadi kacharichun ninguichi?” nisha kutin tapuki gentegunaga, “¡Barrabasta!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatoga, “Cristo nishka Jesustaga ¿imadadi rurusha?” nisha tapuki tukiguna, “¡Cruzbi chakatachun!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatoga, “¿Imadadi na allida rurushka?” nisha tapukish paigunaga ashtan jinchida, “¡Chakatachun!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoga ña imadash na ruri pudigushkada yachushaga tukiguna ashtan ashtan kaparigujllabi yakuda apamuchun kachusha tukigunaj ñaubuki makida maillagusha kashna niga: “Kai k'arij yaurga na ñukaj jawachunga; ashtanbish kangunaj jawaminga.” ");
INSERT INTO qxl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Shina niki tukiguna, “¡Paibuj yaurga ñukuchij shinaidi ñukuchij wawagunaj jawabi gachun!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Shinushami Pilatoga Barrabasta kachariga; ashtanbish Jesustaga azilgun dalichun kachushka k'ipaga cruzbi chakatachun kuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Manduj Pilatoj soldadogunaga mandana jatun wasimu Jesusta pushusha rishaga chi kanllalladi tuki soldadogunadashmi Paibuj muyundiki tandachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chibimi Paibuj churanada kichusha k'uilla puka churanada jawalla p'achallichiga. ");
INSERT INTO qxl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kashan rurushka coronada umabish churachisha alli ladu makibi shuj kaspidash tsutsukichiga. Chi k'ipaga nij tukushalla Jesusbuj ñaubuki kungurisha, “¡Israelgunada manduj alli gachun!” nisha asigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Shinaidi Paida t'iukushtasha chi kaspillandimi umabi takagugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Paimunda kaida chaida nisha asishka k'ipaga jawalla p'achallishkadash kichusha Paibuj churanaidadimi churachisha cruzbi chakatangu pushusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ña llujshisha rigushaga Cirene pueblomunda Simón shuti k'arin tupusha paimu Jesús aparishka cruzta uyi na uyidi apachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ña Gólgota urkumu chayugaguna (Gólgota nishaga <Uma Tullu> nishami nin). ");
INSERT INTO qxl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uvan rurushka vinoda hiel nishka jayuj yakun chapusha ubiachun kugaguna. Ashtanbish Jesús mallishaga na ubiusha nigachu. ");
INSERT INTO qxl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ña Jesusta cruzbi chakatashka k'ipa soldadogunaga paigunapura Jesusbuj churanada sorteoda rurusha japinukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chibi tiyarisha Paida chapungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Paibuj uma jawamunga imamunda wañuchishkada escribisha, “ISRAELGUNADA JATUN MANDUJ JESÚS KAIMIGUN,” nishami churugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Shinaidi ishki shuwagunadashmi cruzbi chakataga shujtaga alli ladumu, chaishujtaga lluki ladumu. ");
INSERT INTO qxl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Chida rijkunaga umada kuyuchisha, “Kan, ‘Diosbuj wasida p'akishtasha kinsa p'unllabi kutin shayachishallami,’ nisha nijtijka, kanlladi kishpiriri; kan Diosbuj Churi gashaga cruzmunda uriyiri,” nisha litugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Shinalladi manduj curaguna Moisés mandashkada yachachijkunash pushaj yuyijkunan tandanukusha Jesusta asisha kashna nigaguna: ");
INSERT INTO qxl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Shujkunadaga kishpichigami. Ashtan pailladijka na kishpiri pudinchu. Israelda jatun manduj gashaga cruzmunda uriyachun, ñukuchi rikusha cringaj. ");
INSERT INTO qxl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pai Dios yuyilla purigandi. Shina gakiga kabishkadi k'uyushkashaga Dioslladi kununga kishpichichun. ¿Nachu, ‘Diosbuj Churimini,’ niga?” ");
INSERT INTO qxl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Paigun cruzbi chakatashka ishki shuwagunashmi Jesusta shinaidi litugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chaubi p'unllamunda kinsa uras tardigamami tuki kai pachaga tutayaga. ");
INSERT INTO qxl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chi uras kinribimi Jesusga, “Elí, Elí, ¿lama sabactani?” nisha jinchida kapariga. (Kai nishkaga: “Ñukaj Dios, Ñukaj Dios, ¿imashadi Ñukallada sakiganguiri?” nishami nin.) ");
INSERT INTO qxl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Maijin chibi gajkuna uyushaga, “Dios nishkada parluj Eliastami paiga kayagun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Shina kaparinmi shujka apuruidi risha esponjada japiga. Chidaga uvan rurushka jayujyashka vinobi lapujyachisha kaspibi watusha ubiachun nisha kuchuyachiga. ");
INSERT INTO qxl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Chaishujkunaga, “Elías cruzmunda kishpichingu shamunchu rikungu saki,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chimunda kutinlladi Jesús jinchida kaparishaga Paibuj espirituda Diosmu mingusha wañugallami. ");
INSERT INTO qxl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chi ratuidi Diosbuj wasibi ch'ikunyachishka tiyuj linsoga jawamunda urimu manyujta chaubibi llikiriga, achpash kuyuga, rumigunash chaubirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Shinaidi pambushka ut'kugunash paskarikiga Diosbujlla kaususha wañuj tauga gentegunash kausachishka gagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús kausarishka k'ipami pambushka ut'kugunamunda llujshisha Diosbuj pueblo Jerusalenmu waigugaguna. Chibimi paigunada taugaguna rikuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldadogunada mandujkish paigun igulda Jesusta chapusha gajkunash achpa kuyujta tuki ima tukushkagunadash rikusha manchanaidi mancharisha, “¡Kai k'ariga kabishkadimi Diosbuj Churi gashka!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chibimi Galileamunda pacha Jesusta katisha shinaidi Pai ima ministishkada rurusha shamuj tauga warmiguna karullamunda rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paigunapuradi Magdala pueblomunda Mariash, Jacoboj Jozij mama Mariash, Zebedeoj churigunaj mamash chibimi gagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ña tutayaguki Arimatea pueblobi kausuj charijlladi Jozi shuti shamuga. Paibish Jesusta katijmiga. ");
INSERT INTO qxl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jozi Pilatoda rikungu risha Jesusbuj cuerpoda mañuga. Shina mañuki Pilatoga kuchun mandush kachuga. ");
INSERT INTO qxl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Cuerpoda Jozi japishaga linshu alli linsun pilluchishaga ");
INSERT INTO qxl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","rurushkalla mushuj pambana ut'kubimi churuga. Chi ut'kuga Jozijmiga. Pailladimi chi k'aka rumidaga ut'kuchishkaga. Chimundaga waiguna ut'kudaga jatun rumin tapachishaga rigallami. ");
INSERT INTO qxl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdala pueblomunda Mariash chaishuj Mariash chi pambana ut'ku ñaubukimi tiyarisha sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kayundij samana p'unllabi tukida alli parijana p'unlla k'ipabi, manduj curaguna fariseogunan igulda Pilatoda rikungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Paidaga, “Manduj, chi llulla Jesús chairijti kausagushaga, ‘Kinsa p'unlla k'ipaga kausarishami,’ nishkadami yuyariganchi. ");
INSERT INTO qxl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Shinushami paida pambushka ut'kuda kinsa p'unllagama chapachun kachachun ninchi. Paibuj yachagujkuna tuta shamusha, cuerpoda shuwasha, ‘Jesusga ñami kausarishka,’ nisha ama gentegunamu crichichunguna. Shina rurushagarin ñaubusha llagmushkadash yallimi ashtan llagmungaguna,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Shina niki Pilatoga, “Kaibimi soldadogunada kachani. Kanguna yachushka shina ima layash alli chapachingu richi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chimunda rishaga ama imash tukuchun pambana ut'kuda alli tapachishka rumibi selloda llutachisha churugaguna. Shinami chapuj soldadogunada chibi sakigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Samana p'unllamunda kayundij domingo tutamunda ña p'unllayaguki, Magdalamunda María shinaidi chaishuj Mariandij pambushka ut'kuda rikungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Manduj Diosbuj ángel jawa pachamunda uriyakimi ñash jinchida achpa ch'ujchuga. Chibimi tapachishka ut'kumu chayusha tapushka rumida anchuchisha chi rumi jawabi tiyariga. ");
INSERT INTO qxl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chi angelga relampa laya p'alaniguj; paibuj churanash rasu laya yurujlladimiga. ");
INSERT INTO qxl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chapuj soldadoguna paida rikushaga manchin ch'ujchurisha wañushkaguna layami tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ashtanbish angelga chi warmigunada, “Ama mancharichichu. Cruzbi chakatashka Jesusta mashkagushkada ñukaga yachanimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","“Na kaibichugun. Pai nishka shinaidi kausarishkami. Mai churushka pushtubi rikungu shamichi. ");
INSERT INTO qxl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chimundaga Paibuj yachagujkunamu, ‘Wañushkapuramunda ñami kausarishka. Galilea llaktamu kangunada ñaubusha rigun; chibimi Paida rikunguichi,’ nisha ut'kada parlungu richi. Kaidami ñukaga kangunamu parlagani,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chimunda warmigunaga mancharishkaidi kushilladi chi pambushka ut'kumunda ut'kada risha yachagujkunamu parlungu shujlla rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Shina rigukimi paigunaj ñaubuki Jesús ñash rikurisha, “¿Allillachu ganguichi?” niga; shina niki chi warmiguna Jesusbujmu kuchuyashaga chakida ugllarisha <Allimi gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chimunda Jesusga, “Ama mancharichichu. Richi, Ñukaj waukigunamu Galilea llaktamu richun parlunguichi. Chibimi Ñukada rikungaguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chi warmiguna riguki chapuj soldadogunapuramunda shujkunaga Jerusalén pueblomu waigusha manduj curagunamu tuki ima tukushkada parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chi curagunada mandujkunaga pushaj yuyijkunan tandanukusha imadash rurungu parlanukushaga milga kuchkida soldadogunamu kugaguna, ");
INSERT INTO qxl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kashna nisha: “Kangunaga, ‘Tuta ñukuchi puñugukimi Jesusbuj yachagujkuna shamusha wañushkadaga shuwashkaguna,’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Manduj Pilato kaigunada yachi chayukiga ñukuchimi ima layash paigun parlanukusha crichishun; kangunada llakichichunga na sakishunchu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldadogunaga shina kuchkida japishami ima nisha yachachishkada rurugaguna. Shina nishkaga kunun p'unllagamami israelgunapurabiga parlushka gan. ");
INSERT INTO qxl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Shinami chunga shuj yachagujkunaga Galilea llaktamu risha Jesús mandushka shina urkumu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chibimi Jesusta rikushaga <Allimi gangui> nigaguna. Shinash shujkunaga <¿Paichushigun?> nisha yuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús paigunajmu kuchuyashaga, “Diosmi Ñukamunga kai pachadash jawa pachadash tuki imadash mandachun kushka,” niga. ");
INSERT INTO qxl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","“Shinushami tuki llaktagunabi kausujkunajmu risha Ñukaj yachagujkunada rurichi, shinaidi Taitabuj, Churibuj, shinaidi Diosbuj Espirituj shutibi paigunada bautizichi. ");
INSERT INTO qxl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Shinaidi tuki Ñuka imada kangunamu mandushkadash kazuchun paigunada yachachichi. Ñukaga kai pacha tukurina p'unllagamami tuki p'unllaguna kangunan gasha,” niga.");
INSERT INTO qxl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diosbuj Churi Jesucristomunda Alli Shimiga kashnami kallarin. ");
INSERT INTO qxl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dios nishkada parluj Isaiasbuj escribishkabimi: “Kanda ñaubusha risha, Kishpichij purina ñanda parijachunmi Ñukamunda parlujta kachani. ");
INSERT INTO qxl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Mandujbuj ñanda parijichi, uchilla dirichu ñanda rurichi,’ nisha shitashka pushtubi shuj shimi kaparishka uyarigun,” nisha escribishkami tiyan. ");
INSERT INTO qxl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juanchuga shitashka pushtubi bautizagushaga, “Juchagunada sakisha Diosmu kuchuyasha bautizarichi. Diosga juchagunada perdonangami,” nisha parluga. ");
INSERT INTO qxl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Shinami tuki Judea kuchu llaktagunabi kausujkuna, Jerusalén pueblobi kausujkunash pai parlushkada uyungaj kuchuyagaguna. Juanchuga <Juchayujmini> nigujkunada Jordán jatiyakubi bautizaga. ");
INSERT INTO qxl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bautizaj Juanchuj churanaga camello millmallanmi rurushkaga. Shinaidi kara chumbilladami chumbillishka gaga. Chuzbitigunadash sacha abejaj mishkidash mikujmiga. ");
INSERT INTO qxl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pai yachachigushaga, “Ñukaj k'ipa shamujka ñukada yalli imadash rurujllami. Ñukaga Paibuj pargati watashkaidash paskungujka na kabinichu. ");
INSERT INTO qxl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ñukaga kangunadaga yakullanmi bautizagani, ashtan Paimi Diosbuj Espiritun bautizanga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chi p'unllagunaidimi Jesusga Galilea llaktabi tiyaj Nazaret pueblomunda llujshisha Juanchujmu chayaki, Jordán jatiyakubi Juanchuga Paida bautizaga. ");
INSERT INTO qxl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús yakumunda llujshigusha, jawa pacha paskarijta Diosbuj Espíritu paloma shina Paibuj jawamu uriyamujtash rikuga. ");
INSERT INTO qxl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Shinalladi jawa pachamunda, “Kanmi Ñuka k'uyashka Churi gangui. Kanbimi kushiyani,” nishkashmi uyariga. ");
INSERT INTO qxl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Kai k'ipami Diosbuj Espirituga p'iña animalguna tiyashka shitashka pushtumu Jesusta pushuga. Chusku chunga (40) p'unllada chibi gakimi Satanasbish pandachisha nisha purigugalla. Angelgunash Jesusta sirvigugami. ");
INSERT INTO qxl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bautizaj Juanchuda carcelbi churashka gashka k'ipami Jesusga Galilea llaktamu risha Diosmunda Alli Shimida yachi chayachishaga, ");
INSERT INTO qxl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“P'unllaguna ñami p'aktamushka. Diosbuj mandanash ñami kuchuyamugun. Juchagunada sakisha Diosmu kuchuyichi. Paibuj Alli Shimidash tuki shungun crichi,” nishami yachachiga. ");
INSERT INTO qxl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea yaku kucha manyada rigushami Jesusga Simonda paibuj wauki Andikundijta rikuga. Paigunaga chaula japijkunashami chaulada japinada yakumu shitaguga. ");
INSERT INTO qxl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chimunda Jesusga, “Katimichi. Ñukami kangunadaga chaulada japij shina, gentegunada japijta rurusha,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Shina ninmi chaulada japinada chi pushtubi shitusha, Paida katisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chimunda ashallada rishami Jacoboda paibuj wauki Juanchudash barcabi chaulada japinada parijasha tiyajta rikuga. Paigunaga Zebedeoj churigunamiga. ");
INSERT INTO qxl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Shina tiyajta rikunmi Jesús kayaga. Paigunaj taita Zebedeoda, paida ayudajkunandijta barcabi sakisha Jesusta katigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chimunda rishaga Capernaúm pueblomu chayagaguna. Samana p'unlla chayunmi Jesusga Diosmunda yachana wasimu waigusha, yachachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesusga Moisés mandashkada yachachijkunadash yalli yachachisha mandaj laya parlashkamunda uyujkunaga mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chi wasillabidimi aya katishka k'ari tiyaga. Paiga ñash kaparishaga, ");
INSERT INTO qxl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nazaretmunda Jesús ¿imadi ningui? ¿Ñukuchida tukuchinguchu shamugangui? Ñukaga Kanda rijsinimi. Shinaidi Kanga jucha illij Diosmunda gashkadash yachanimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Shina nikimi Jesusga chi ayadaga, “¡Upalli! ¡Paimunda llujshisha ri!” nisha mandaga. ");
INSERT INTO qxl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Shina ninmi ayaga jinchida ch'ujchuchisha shinaidi manchanaidi kaparishaga llujshisha riga. ");
INSERT INTO qxl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Shina llujshichikimi tukiguna manchanai mancharisha, paigunapura kaishuj chaishuj, “¿Imadikun kaiga? Paiga imadash mandi pudishkan mushujtami yachachishka. Ayagunash Pai mandukiga kazunllagunami,” nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kishna rurukimi Jesusta tuki Galilea llaktabi tiyujkuna ut'kada yachi chayuga. ");
INSERT INTO qxl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Diosmunda yachana wasimunda llujshinmi Jacobon Juanchun Jesusga Simonbuj, Andikuj wasimu riga. ");
INSERT INTO qxl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chi ratumi Jesusmuga, “Simonbuj suegraga k'awitubi calenturan ungushkami sirigun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús kuchuyasha, makimunda japisha jatarichinmi calentura unguiga anchuga. Chimunda tukigunamu karungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Indi waigusha ña tutayakimi tauga ungushkagunada aya katishkagunadash Jesusbujmu pushusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Shinalladi chi pueblobi kausujkunashmi pungubi tandanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chibimi Jesusga taugagunada tuki laya unguigunamunda alliyachisha, Pi gashkada rijsishkamundami ayagunada na rimarichun sakishallami llujshichiga. ");
INSERT INTO qxl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kayundij tutamunda puzu puzudi jatarisha, Jesusga chi pueblomunda llujshisha, chulunlla pushtubi Diosta mañungu riga. ");
INSERT INTO qxl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simonbish paigun purijkunash Jesusta mashkungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mashkagushkan japishaga, “Tukigunami Kandaga mashkagun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Shina nikimi Paiga, “Diosmunda yachachingu kuchulla uchilla pueblogunamush jakuchi. Ñukaga chibujmi shamugani,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Shinami Jesusga tuki Galilea llaktabi, Diosbuj Shimida Diosmunda yachana tuki wasigunabi yachachiga. Ayagunadash llujshichisha puriga. ");
INSERT INTO qxl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aichada ismuchisha katij lepra unguiyuj k'ariga Jesusbujmu kuchuyasha Paibuj ñaubuki kungurisha, “Kan munushaga ñukaj unguida linshi pudinguimi,” nisha mañaga. ");
INSERT INTO qxl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Shina niki, paida manchanaidi llakirishami makin tupasha, “Ari, alliyachun munanimi. ¡Linshu sakiri!” niga. ");
INSERT INTO qxl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesús shina ninmi aichada ismuchisha katij ungui chingariki, linshu sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Shina alliyanmi Jesusga <Ut'kada ri> jinchida nishka k'ipaga kutin kutin, ");
INSERT INTO qxl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Uyi, p'akta pimush yachi chayachinguimu, ashtan kanda alliyachishkamunda Moisés mandushka shina linshuyachishka gangu ofrendada apusha curajmu ri. Shinami paiguna kan alliyashkadaga yachunga,” nisha mandaga. ");
INSERT INTO qxl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Shina nishkadash na uyashami chi k'ariga imadash na pakushalla ima laya Jesús alliyachishkada tukigunamu yachi chayachiga. Shinashami Jesusga mai pueblomush ña na sarunguna laya waigui pudigachu. Shinushami washa washa risha, shitashka llaktagunallabi puriga. Shina pakalla purikish tuki llaktagunamundami Pai purishkamu chayamugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Asha p'unllaguna k'ipami Jesusga Capernaúm pueblomu kutin waiguga. Wasibi gajta uyushami ");
INSERT INTO qxl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","pungu pamba maida na p'aktidi taugaguna tandanukukimi Jesusga paigunamu Diosbuj Shimida yachachiguki, ");
INSERT INTO qxl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","na kuyurij k'arida chuskupura wandusha apamugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Taugalladijkuna gashkamunda Jesusbuj kuchumu na kuyurijta maida na waiguchi pudishami wasi jawamu sikusha, Jesús maibi gashka jawa k'atashkada anchuchisha Jesusbuj ñaubujmu na kuyurij tiyashka wandushkada uriyachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Paiguna tuki shungun crishkada Jesús rikushami na kuyurijtaga, “Uyi, kambuj juchaguna perdonashkami sakirin,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chibi uyusha tiyaguj Moisés mandushkada yachachij ashagunaga, ");
INSERT INTO qxl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ima nishadi paiga shina nin? Paiga Diostami p'iñasha riman. ¡Diosllami juchagunadaga perdoni pudin!” nisha yuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús Paibuj espiritubi kishna yuyajta yachunmi Moisés mandushkada yachachijkunada, “¿Imasha kangunaga shina yuyinguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Kangunamunga, ‘Kambuj juchagunada perdonashkami sakiringui,’ ¿ninachu jawalla rikurin? Na gashaga, ‘Jatarisha kanda wandumushkada japisha ri,’ ¿ninachu alli ganga? ");
INSERT INTO qxl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aichayuj tukushka Churiga kai pachabi juchagunada perdoni pudij gashkadami rikuchinga.” Na kuyurijta, ");
INSERT INTO qxl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Uyi, kandami nini. Jatari, kanda wandumushkada japisha wasimu ri,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Shina ninmi na kuyurijka jatarisha paida wandumushkada japisha tukiguna rikuki llujshisha riga. Chida rikusha tukiguna mancharisha, “Kishna rurujtaga ima urash na rikushkanchichu,” ninukusha, Diostaga <Allimi gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesusga yaku kucha manyamu kutin riki taugaguna kuchuyakimi yachachiga. ");
INSERT INTO qxl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chida rigushami Alfeoj churi Levida Romamu impuestoda japinabi tiyajta rikuga. Chimunda Jesusga, “Ñukada katimi,” niga. Shina nikimi Leviga jatarisha katish riga. ");
INSERT INTO qxl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Levij wasibimi Jesusga mikusha tiyaga. Jesusta katijkuna tauga gaki manchanai juchayujkunapuramundash Romamu impuestoda cobrajkunapuramundash taugaguna mizabiga Jesuskun Paibuj yachagujkunanbish tiyaga. ");
INSERT INTO qxl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na alli gentegunan Jesús mikusha tiyajta rikusha fariseogunamunda Moisés mandashkada yachachijkuna Jesusbuj yachagujkunada, “¿Imashti kangunada pushujka impuestoda cobrajkunan juchayujkunan mikun?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Shina tapujta Jesús uyishami paigunada niga, “Ungushkagunallami jambijta ministin. Na ungushkagunaga jambijta na ministinchu. Ñukaga kabishkada rurujkunada na kayungu shamuganichu, ashtangarin juchayujkunadami kayungu shamugani.” ");
INSERT INTO qxl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Shuj p'unllami Bautizaj Juanchuj yachagujkuna, fariseogunaj yachagujkunash, na mikushalla kainajta rikusha, shujkuna Jesusbuj kuchumu rishaga, “Juanchuj yachagujkuna, fariseogunaj yachagujkunash na mikushallami kainan. ¿Imasha kambuj yachagujkunaga paiguna shina na kainunguna?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesusga, “¿Bodamu kayushkaguna novio paigunan chibi gaki na mikushalla kainungachu? Novio chibi gakiga na ayuni pudingachu. ");
INSERT INTO qxl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Novioda pushusha rina p'unllaga chayamungami. Chi k'ipami imaidash na mikushalla kainangaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Maijinsh mauga churanada mushuj linson na p'utyunchu. Shina rurukiga mushuj linsoga tandanukusha mauga churanada llikishtangami, ashtan llikimi sakiringa. ");
INSERT INTO qxl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Shinalladi rurushkalla vinodash karan rurushka mauga p'urugunabiga na churanallachu. Rurushkalla vinoda mauga p'urubi churukiga p'uruga tugyusha llikiriki vinosh jicharisha chingaringami. Shinusha rurushkalla vinodaga mushuj p'urubimi churana,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Shuj samana p'unlla, Paibuj yachagujkunan tarbushka ukuda Jesús rigukimi trigo k'atsugunada pilungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chida rikushami fariseoguna, “Uyi. ¿Imashti kambuj yachagujkunaga samana p'unllabi Moisés mandashkabi Dios ama rurachun nishkada ruranguna?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Shina nikimi Jesusga, “Shuj p'unlla, manduj David paiyun purijkunandij ministisha yarijachishaga ima rurushkada ¿nachu liyashkanguichi? ");
INSERT INTO qxl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar jatun manduj cura gaki, israelgunaj Diosbuj tuldushka wasimu David waigushami Diosmu kushka tandada Moisés mandashkabi curagunalla mikuna gakish mikuga. Shinami paiyun purijkunamush karuga.” ");
INSERT INTO qxl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kaida nishka k'ipaga, “Samana p'unllaga gentegunamumi rurushka gaga. Gentegunadaga samana p'unllajka na rurugachu. ");
INSERT INTO qxl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Shinushami Aichayuj tukushka Churiga samana p'unlladash mandi pudin,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Diosmunda yachana wasimu Jesús kutin waigushami chi ukubi chakishka makida charij k'ari tiyajta rikuga. ");
INSERT INTO qxl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Shinaidi samana p'unllabi alliyachikiga juchachingaj nisha pakalla rikujkunashmi tiyaga. Shina chapariakimi ");
INSERT INTO qxl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesusga chakishka makiyujta, “Jatarisha kai chaubibi shayari,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chi k'ipa chaishujkunada, “Samana p'unllaga ¿imadadi rurana gan: allidachu, na allidachu? Shuj kausida ¿kishpichinachu, wañuchinachu?” nisha tapukish imadash na nisha upalla tiyagallagunami. ");
INSERT INTO qxl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Upalla tiyakimi Jesusga Paibuj muyundijta tiyajkunada p'iñada rikusha jinchi shunguda charishkamundash paiguna na intindingu munushkamundash llakirisha chakishka makiyujta, “Makida chutalla churusha rikuchi,” niga. Shina rurashaga alliyagallami. ");
INSERT INTO qxl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Shina alliyachijta rikunmi fariseoguna llujshish rishaga Herodeskun purijkunan tandanukusha Jesusta wañuchingu yuyarinukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Galilea llaktamunda taugalladijkuna katishkami Jesusga Paibuj yachagujkunandij yaku kucha manyamu riga. Judea llaktamunda, ");
INSERT INTO qxl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalén pueblomunda, Idumea llaktamunda, Jordán jatiyaku ch'imbamunda, Tiro Sidón puebloguna kuchumundash taugagunaga imadash alli ruruj nijta uyashami rikungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesusga Paibuj yachagujkunada, “Shuj barcada ña rinaida churungu richi. Taugaguna gashkamundaga manchanai llapiminga,” nishami kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Taugagunada alliyachishkamundami tuki ungushkaguna llapirinukidi Jesusta tupush nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Shinaidi ayagunash Jesusta rikushaga Paibuj ñaubuki kungurisha kumurishami, “¡Kanmi Diosbuj Churi gangui!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Shina kaparikimi Jesusga, “P'akta Ñuka pi gashkamada tukigunamu yachi chayachigunguichimamu,” nisha rimuga. ");
INSERT INTO qxl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chi k'ipami Jesusga shuj urkumu ichiyasha, munashkagunada kayushka k'ipa tandachishaga ");
INSERT INTO qxl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Paigun purichun Alli Shimidash parlachun kachungaj nisha chi kayushkagunamunda chunga ishkida aglluga. Paigunadami agllushka apostolguna nisha shutichisha ");
INSERT INTO qxl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","shinaidi Jesusga ayagunada llujshichingu ruri pudinallada rurush kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesús chunga ishki agllushkagunaga kaigunami gan: Simón (pailladi Pedro nisha Jesús shutichishka); ");
INSERT INTO qxl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobosh, paibuj wauki Juanchush (Kaigunaga Zebedeoj churigunamiga. Paigunadami Boanerges nisha shutichiga. Boanerges nishaga <Gulun nishkaj churiguna> nishami nin); ");
INSERT INTO qxl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andikush, Felipesh, Bartolomesh, Mateosh, Tiumash, Alfeoj churi Jacobosh, Tadeosh, Simón Celote nishkash, ");
INSERT INTO qxl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","shinaidi Judas Iscariotesh. Paimi k'ipaga Jesusta wañuchisha nijkunamu japichiga. ");
INSERT INTO qxl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chi k'ipaga Jesús wasimu waiguki, taugagunalladi kutin tandanukushkamunda Paish Paibuj yachagujkunash mikungullash na pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","“Yuyi illuj tukushami purigun,” nishkada yachi chayushami Paibuj familiagunaga pushungu riga. ");
INSERT INTO qxl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalén pueblomunda chayamuj Moisés mandushkada yachachijkunash, “Ayagunada manduj Beelzebuga Jesusta japishami paidaga ayagunada llujshichichun rurashkanga,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kishna nikimi Jesusga paigunada kayushaga kai yuyachinan parlasha, “¿Ima layadi Satanaslladijka Satanasta llujshichingari?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Shinaidi shuj llaktabi kausujkunapura p'iñanukusha takanukilla kausukiga chi llaktaga tukurinmumi. ");
INSERT INTO qxl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Shinaidi wasi ukubi kausujpura p'iñanukilla kausashaga chingarinmumi. ");
INSERT INTO qxl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Shinaidimi Satanasbish ayagunan p'iñanukilla tiyashaga na kausi pudingagunachu. Pai mandanash tukurinmullami. ");
INSERT INTO qxl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Maijinbish shuj jatun jursayujbuj wasimu waigushaga paida na tsagnushaga imadash na api pudinchu. Tsagnushallami ima charishkadash api pudinga. ");
INSERT INTO qxl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kabishkadadimi nini, gentegunadaga Diosga tuki juchagunada ima p'iñasha rimashkadash perdoni pudinmi. ");
INSERT INTO qxl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Shina gakish maijinsh Diosbuj Espirituda p'iñasha rimajtaga manadij perdonangachu; paiga na tukuribuj juchamunda kauzachishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesustaga, “Yana katishkami gangui,” nishkamundami Paiga kaigunadaga niga. ");
INSERT INTO qxl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Shina niguki Jesusbuj mama Paibuj waukigunandij chayamusha washallabi sakirisha kayachun kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesusbuj muyundijta tiyagujkunamundaga, “Kambuj mama, kambuj waukigunashmi kanda washabi mashkagunguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Shina nikimi Jesusga, “¿Pishi gan Ñukaj mama, Ñukaj waukigunaga?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Shina nishka k'ipa Paibuj muyundijta tiyajkunada rikushaga, “Ñukaj mama, Ñukaj waukigunaga kaigunami gan. ");
INSERT INTO qxl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maijinsh Dios munushkada rurujkunami, Ñukaj wauki, panish, Ñukaj mamash gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yaku kucha manyabi kutin Jesús yachachingu kallarikimi taugalladijkuna tandanukuki, Jesusga yakubi tiyaj barcabi sikusha tiyariga. Gentegunaga chi manyallabimi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chimunda tauga yuyachinagunan yachachishaga kishna niga, ");
INSERT INTO qxl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kaida uyichi: Shuj tarbujmi tarbungu llujshiga. ");
INSERT INTO qxl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tarbukimi shuj muyugunaga ñan manyabi urmuga. Pishkuguna shamusha mikugami. ");
INSERT INTO qxl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Shuj muyugunaga ashalla achpa tiyashkabi rumi ukubimi urmuga. P'itilla achpa tiyashkamunda ratu iñusha, ");
INSERT INTO qxl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","indi llujshisha p'angada anguyachiki anguda na charishkamunda chakiriga. ");
INSERT INTO qxl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kutin shuj muyugunaga kasha ukubi urmuga. Kasha yuraguna iñusha, sipij shina ruraki na granugachu. ");
INSERT INTO qxl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Shinalladi wakin muyugunaga alli achpabi urmusha, k'uillada iñusha, pachundimi granuga. Shinami shuj muyullamunda shujkunaga kinsa chungada (30), shujkunaga sujta chungada (60), shujkunaga patsujtami (100) granuga.” ");
INSERT INTO qxl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kaidash Jesusga niga, “¡Maijinsh rinrinda uyungu charijka, uyichi!” ");
INSERT INTO qxl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesús Pailla sakirikimi Paibuj kuchubi gajkunash chunga ishki yachagujkunash, “Shina yuyachishkaga ¿imada nishadi nin?” nisha tapukimi ");
INSERT INTO qxl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesusga, “Kangunamumi Diosga Paibuj mandanamunda pi na rijsishkada yachi chayachishka. Chaishuj washabi gajkunamunga yuyachinagunallanmi parlani, ");
INSERT INTO qxl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Diosbuj Shimi p'aktachunmi: ‘Rikuriagushash ama rikuchun; uyariagushash ama intindichun; paiguna na Diosmu vueltamuki paigunaj juchagunadash na perdonangachu.’ ” ");
INSERT INTO qxl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Kai yuyachishkada na intindishadijka ¿chaishujkunadagarin ima layadi intindinguichi? ");
INSERT INTO qxl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tarbujka Diosbuj Shimida parluj shinami gan. ");
INSERT INTO qxl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Shuj uyajkunaga ñan kuchubi muyuda tarbushka achpa shinagunami gan. Diosbuj Shimida uyusha paigunabi tarbushka shina gakish Satanás shamusha chi alli yuyigunada kichunllami. ");
INSERT INTO qxl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Shujkunaga muyuda rumi ukubi tarbushka achpa shinagunami gan. Paigunaga Diosbuj Shimida uyunmi kushilla japinguna. ");
INSERT INTO qxl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na mirga anguda charij yura shina gashkamundaga na jinchi shayari pudingunachu. Diosbuj Shimimunda ima llaki japiki na gashaga katik'ichuki urmuj shina Diosta kungarinllaguna. ");
INSERT INTO qxl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Shujkunaga muyuda kasha ukubi tarbushka achpa shinami gan. Diosbuj Shimida uyashash ");
INSERT INTO qxl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kai kausibujllada yuyasha mancharishami, ashtan charinagunan pandachishka kausashami, charinagunada munigunanlla gashami tauga na alli yuyigunash Diosbuj Shimi uyushkada sipij shina iñachun na sakin. ");
INSERT INTO qxl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ashtangarin Diosbuj Shimida uyisha kazujkunaga muyuda tarbushka pachun granuda kuj achpa shinagunami gan. Shinushami shujkunaga shuj muyullamunda, kinsa chungada (30), shujkunaga sujta chungada (60), kutin shujkunaga patsuj (100) granuda kuj alli achpa shinagunami gan.” ");
INSERT INTO qxl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Shinalladi, “¿Luztaga cajón ukubi na gashaga k'awitu ukubi churungajchu apamun? Na shinachu. P'unllallada rurachunga jawamumi churana gan. ");
INSERT INTO qxl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Shinaidi ima pakushkash na pakalla sakiringachu. Tukimi rikuringa. Imada washalla rurushkash k'ipaga yacharingami. ");
INSERT INTO qxl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Maijinsh rinrinda uyungu charijka, uyichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Ñuka nishkada alli uyichi. Kanguna, mashna kutin shujkunamu imada kukish Diosbish shinaidi ashtan yallinbishmi imadash kunga. ");
INSERT INTO qxl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Shinusha maijinsh yalli charijmunga ashtanmi kunga. Na charijtaga ashalla charishkaidash kichungami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesusga kaidashmi niga, “Diosbuj mandanaga shuj tarbuj paibuj achpabi muyuda jichaj shinami gan. ");
INSERT INTO qxl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Puñukish rijchij gakish tutash p'unllash tarbushka muyuga achpayuj na yachujllabidimi iñusha iñush katin. ");
INSERT INTO qxl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Achpaga pailladimi granuda kun. Kallaribiga yurallami rikurisha iñan. K'atsuguna tukushka k'ipaga granugunada kun. ");
INSERT INTO qxl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Shinalladi p'ukushka granu gaki usiskun p'itisha tandachina p'unllagunami chayun.” ");
INSERT INTO qxl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kaidash nish katishaga, “¿Imandi Diosbuj mandanaga ch'imbapurashkada na gashaga ima laya yuyachina gashkada ni pudishun? ");
INSERT INTO qxl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Diosbuj mandanaga achpabi tarbushka mostaza muyu shinami gan. Kai achpabi tiyuj muyugunamundash tukida yalli uchilla gashash, ");
INSERT INTO qxl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tarbushka k'ipa iñushaga tuki chagra yuragunada yalli jatunmi tukun. Ramagunash pachun t'undujyaki, llanduda mashkusha pishkugunash tazinda rurushami tiyarin,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Shinami Jesusga Diosbuj Shimida tauga yuyachinagunan mashna intindi pudishkagama yachachiga. ");
INSERT INTO qxl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Shinami tukigunamu yuyachinagunallan yachachiga. Paibuj yachagujkunallan gashami yuyachinagunamunda illijta yachachiga. ");
INSERT INTO qxl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chi p'unllalladi ña tutayaguki, Paibuj yachagujkunada Jesusga, “Yaku kucha ch'imbamu jakuchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Shina nikimi taugalladijkunada sakisha, Pai tiyashka barcallabidi rigaguna. Shina riki shuj barcagunash riga. ");
INSERT INTO qxl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Shina rigukimi manchanai wairash shamusha, yakuda jatarichisha, barcada kaimu chaimu apik'ichuki yaku junduki pambaringu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusga barca washamu k'uillada saunarishami puñurishkaga. Shinushami Paida rijchachisha, “Yachachij, barcabi yaku jundusha ukuyagukish ¿nachu ñukuchida llakingui?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Shina nisha rijchachiki Jesusga jatarisha wairada jinchi rimun yakuda, “¡Upalli! ¡Chulunlla gaichi!” nisha mandunmi waira upallaga, shinaidi illujta chulunlla sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kishna rurushka k'ipami Paibuj yachagujkunada Jesusga, “¿Imashti shina mancharinguichi? ¿Narijchu Ñukada alli cringuichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Shinada rikusha, manchanai mancharishami kaishuj chaishuj tapunukusha, “¿Kaiga pishigun? Paidaga yakush wairash kazushkallandi,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Galilea yaku kuchada ch'imbamu rishami Jesusga yachagujkunandi Gadara llaktamu chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús barcamunda urikunmi pantiunmunda llujshisha yana katishkaga Paibujmu kuchuyaga. ");
INSERT INTO qxl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yana katishkaga pantiunbimi kausuj gashkaga. Paidaga cadenan watashash, ña pish chariri pudijchuga. ");
INSERT INTO qxl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tauga kutin chakigunadash makigunadash cadenan alli tsagnusha churukish p'itishtajllamiga. Pachun jursada charishkamunda pish na chariri pudijkunachuga. ");
INSERT INTO qxl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yana katishkaga tutash p'unllash urkugunabi, pantiungunabi kaparisha, pailladi rumin juaktarisha purijllamiga. ");
INSERT INTO qxl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Paiga karumunda Jesús rigujta rikusha, manchanai saltush risha, Paibuj ñaubuki kungurishami, ");
INSERT INTO qxl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“¡Jawa pachabi kausaj Jatun Mandaj Diosbuj Churi Jesús! ¿Ima ningu shamungui? ¡Diosmundami <Amalladi llakichibaichu> nisha mañani!” nishami jinchida kapariga. ");
INSERT INTO qxl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","“Milli aya, ¡kai k'arimunda llujshi!” nisha, Jesús rimushkamundami shina kapariguga. ");
INSERT INTO qxl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Shina kaparikimi Jesusga, “¿Ima shutingui?” nisha tapuga. Shina tapukimi paiga, “Taugapurashkamunda, ñuka shutiga Warangagunami gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chimunda paiga, “Kai llaktamundaga amalladi llujshichisha kachabaichu,” nishami Jesusta manchanai ruguga. ");
INSERT INTO qxl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chi lumabi tauga k'uchiguna mikuguki, ");
INSERT INTO qxl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ayagunaga, “Chi k'uchigunamu waiguchun sakibai,” nisha rugugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Shinaga <K'uchigunabi waiguichilla> nikimi ayagunaga chi k'arimunda llujshisha k'uchigunabi waiguga. Ishki warunga vali k'uchigunaga paiguna waiguki k'akada urimu risha yaku kuchabi urmusha wañugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","K'uchi michijkuna rishaga pueblobish shuj ladugunabish ima tukushkada tukigunamu nigaguna. Shina nikimi gentegunaga ima tukushkada rikungu chimu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesusbuj kuchumu chayashaga waranga yanaguna katishkaga churana churushka tuki yuyin tiyajtash rikushami mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yana katishka alliyashkadash k'uchiguna ima tukushkadash rikujkunami chaishujkunamu parlakiga ");
INSERT INTO qxl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","<Kai llaktamunda ribailladi> nisha Jesustaga rugugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús barcabi sikuki ayagunada llujshichishkaga <Ñukadash kangun richun sakibai> nisha rugaga. ");
INSERT INTO qxl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Na Paiyun richun sakishami Jesusga, “Kambuj wasimu risha, Manduj Dios kanda llakisha tuki ima rurushkada kambujkunamu yachi chayachingu ri,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Shina nikimi chimunda risha, Chunga Puebloguna nishka shuti llaktabi, Jesús paida ima laya alliyachishkada parlungu kallariga. Tukiguna kushiyashash mancharishka shina sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yaku kucha chaishuj ladumu Jesús barcabi kutin rishami manyallabi gaki Paibuj muyundijta taugalladi tandanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Diosmunda yachana wasibi mandujkunapuramunda Jairo nishkaga kuchuyasha, Jesusta rikusha, Paibuj ñaubuki kungurisha kumurishaga, ");
INSERT INTO qxl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Ñukaj ushiwa wañugunga. Jakubai kambuj makida paibuj jawabi churungaj. Shina churaki paiga alliyasha kausaringallami,” nisha ruguga. ");
INSERT INTO qxl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chimunda Jesusga paiyun riga. Chibi gajkuna Paibuj kuchuda taugalladijkuna llapinukidi katisha riga. ");
INSERT INTO qxl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chi taugalladijkunamundami chunga ishki watada yaur shitusha purij ungushka warmish riguga. ");
INSERT INTO qxl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Paiga tauga jambijkunaki jambirisha llakirishami puriga. Ima charishkada tukida tukuchishash ima na alliyagachu. Alliyana randiga ashtan anchayasha katiga. ");
INSERT INTO qxl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesusmunda uyushami gente ukuda washamunda kuchuyasha, Jesusbuj churanada tupuga. ");
INSERT INTO qxl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Paibuj churanaida tupushash alliyachishka gashami,” yuyushami shina ruruga. ");
INSERT INTO qxl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Shina tupunmi yaur sakiriki, paibuj cuerpoda llakichij unguimunda ña alliyashkada pailladi cuenta kuga. ");
INSERT INTO qxl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chi tukunmi Jesusga Paibuj poder llujshishkada yachashami gentegunada vueltusha rikuga, “¿Maijindi Ñukaj churanada tupuga?” nisha tapukimi, ");
INSERT INTO qxl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Paibuj yachagujkunaga, “Kai tuki llapibidijka ¿imashti ‘¿Maijindi tupuga?’ nisha tapungui?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Shinash maijin tupushkada rikungu nishami Jesusga muyundijta rikuga. ");
INSERT INTO qxl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chimundami Paibuj churanada tupuj warmiga ima tukushkada yachusha, manchin ch'ujchurishaidi kuchuyasha, Paibuj ñaubuki kungurisha kumurisha tuki ima tukushkada kabishkada parluga. ");
INSERT INTO qxl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Shina ninmi Jesusga, “K'uyashka, kan Ñukada crishkallamundami alliyashkangui. Kushilla ri. Kambuj llakimunda alliyachishka gai,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Chairitij Jesús nigujllabidimi Diosmunda yachana wasida manduj Jairoj wasimunda k'ariguna shamusha paidaga, “Kambuj ushiga ña wañushkami. ¿Imajtikish Yachachijta ña pushangui?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Shina nijta uyishash na uyuj shinalla Jesusga Diosmunda yachana wasida mandujta, “Ama manchichu. Crillada cri,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pidash Paigun richun na sakishami shinash Pedroda, Jacoboda, Jacoboj wauki Juanchudash pushusha riga. ");
INSERT INTO qxl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Diosmunda yachana wasida mandujbujmu chayashaga bullada rurujkunada jinchida kaparisha wakajta llakilladi tiyajkunadash Jesús rikuga. ");
INSERT INTO qxl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ña ukumu waigushaga, “¿Imashti bulla rurusha, shina kaparisha wakagunguichi? Maraga nash wañushkachu, puñilladami puñugun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chimunda tukiguna Jesusta asigaguna. Shinushami tukigunada kanllamu llujshichish kachusha, maraj taita maman, Paigun rij yachagujkunallan mara sirishka ukumu waigushaga ");
INSERT INTO qxl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","maraj makida japisha, “Talitá cum,” niga. (Talitá cum nishaga, “Mara, kandami jatari, nini,” nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Shina ninmi chunga ishki watayujka jatarisha puri kallariga. Shina kausarijta rikushash kushilla manchanai mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","<Kishna rurushkada p'aktalladi pimush yachi chayachigunguichimu> nisha mandushka k'ipami <Maramu karungu richi> nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Maibi gashkamunda llujshisha Jesusga Paibuj llaktamu riki, Paibuj yachagujkunash Paiyun rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samana p'unlla chayukiga Diosmunda yachana wasibi yachachingu kallariga. Chibi gajkuna Jesusta uyashami kushilla mancharisha, “¿Maibishi paiga kai tukida yachamugashi? ¿Maimundashi shina alli yuyigunada pi na ruri pudishkadash rurana poderdaga japigashi?” nisha tapunukugushami, ");
INSERT INTO qxl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“¿Nachu kaiga Mariabuj churi carpinterolla gan? ¿Nachu paibuj waukigunaga Jacobosh, Jozish, Judasbish, Simonbish gan? ¿Nachu paibuj panigunash ñukuchi kausushkallabidi kausun?” nishami Jesustaga na rikunachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Shina gakish Jesusga, “Dios nishkada parlujtaga tuki llaktagunabimi <Alli> nisha japinguna, ashtan kikinbuj llakta, familiapuraguna, kikinbuj wasibi kausujkunash na valichishkami gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chibiga pi na ruri pudishkadaga na ruragachu. Shinash ungushka ashagunaj jawabi Paibuj makida churusha alliyachigallami. ");
INSERT INTO qxl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chibi gajkuna Paida na crishkamunda Jesusga mancharij shina tukuga. Jesusga tuki kuchulla muyundijkunabimi yachachish puriga. ");
INSERT INTO qxl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Paibuj chunga ishki yachagujkunada kayushaga ayagunada llujshichina poderda kusha, ishki ishkida kachungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Shina kachagushaga, “Ñanbujka p'akta tandada, shigrada, chumbibi kuchkida apush rigunguichimu, ashtan shuj taunaida apush ringuichi. ");
INSERT INTO qxl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pargatidaga churusha ringuichi. Ama shuj churanagunadaga apunguichichu,” nisha manduga. ");
INSERT INTO qxl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Shinaidi Jesusga, “Kanguna maijin wasibi waigushash, chi llaktamunda ringagama chillabi sakiringuichi. ");
INSERT INTO qxl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kanguna chayushka pushtubi na japish nisha uyilladash na uyanachikiga kangunaj chaki achpada chaspisha na uyanachishkada rikuchingu chimunda llujshisha ringuichi,” nisha yachachisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chunga ishkiguna llujshisha rishami gentegunada <Juchayuj gashkada llakirisha Diosmu vueltichi> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ayagunadash llujshichisha tauga ungushkagunadash aceiteda churusha alliyachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesús imada rurush purigujta tukigunami maibish ninukugaguna. Shina ninukujta jatun manduj Herodes uyagukimi maijinguna, “Bautizaj Juanchumi wañushkapuramunda kausarimushkanga. Shinushami pi na ruri pudishkagunada ruraj ganga,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Shujkunaga, “Dios nishkada parluj Eliasmi gan,” nigaguna. Kutin shujkunaga, “Dios nishkada ñauba parlujkuna layami ganga,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Shina ninukujkunada uyushash, Herodesga, “Chiga Juanchulladimi ganga. Ñukami paidaga kungada p'itishtasha wañuchichun kachugani. Kununga kausarishkanga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodesga paibuj wauki Felipej warmi Herodiasta kazarashkaga. Chi warmimundaga Juanchuda prezu japichun kachusha cadenan tsagnusha carcelbi churushkaga. ");
INSERT INTO qxl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","“Kambuj waukij warmidaga kambujta laya charina na kabinchu,” nigushkamundami Herodesga Juanchudaga shina ruruga. ");
INSERT INTO qxl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Shina nishkamundami Herodiasga Juanchuda na rikunachisha wañuchingu munushash na pudigachu. ");
INSERT INTO qxl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juanchu imadash kabishkada ruruj gashkadami Dios mandushka shina kausuj gashkadash Herodes yachushkamunda manchushkamundash alli chapachisha chariga. Herodesga Juanchu ima nijta uyasha, imadash na ni pudisha, imadash na rurushash, paida kushilla uyujmiga. ");
INSERT INTO qxl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodesbuj wacharishka p'unlla chayuki jatun pishtada rurusha mikuchun jatun mandujkunadash soldadogunada mandujkunadash, Galilea llaktamunda yalli rijsishkagunadash pushachun kachuj gakimi Herodiasga chi p'unlla chayamujta chapaga. ");
INSERT INTO qxl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiasbuj ushi, mikugushka ukumu waigusha dansuga. Shina dansushkaga Herodesmush paigun gajkunamush k'uidi rikuriga. Shinushami Herodesga, “Ima kan munushkada mañi. Mañushkadami kusha,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Kan ima munushkadash kushami. Na llullanichu,” nisha kutin kutin niga. “Kan munukiga ñuka mandagushka llaktagunada chaubimadash kushami,” nikimi ");
INSERT INTO qxl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","chi dansashkamunda llujshisha, “¿Imadadi mañusha?” nisha paibuj mamunda tapungu riga. Mamaga, “Bautizaj Juanchuj umada mañi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Shina ninmi solteraga Herodes tiyushkamu ut'kada waigusha, “Kunun ratu Bautizaj Juanchuj umada shuj latubi kuchunmi munani,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Shina mañuki jatun manduj Herodesga manchanaidi llakiriga. Shina llakirishash tuki kayashkagunaj ñaubuki, “Imadash kushallami,” nishkamundaga <Na> ningujka na pudigachu. ");
INSERT INTO qxl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chimundami chi ratu shuj soldadoda <Bautizaj Juanchuj umada apamungu ri> nisha kachuga. Shina mandush kachukimi soldadoga carcelmu risha Bautizaj Juanchuj kungada p'itisha ");
INSERT INTO qxl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","latubi umada apush shamushami solteramu kuga. Paiga paibuj mamunmumi kuga. ");
INSERT INTO qxl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanchuda katijkuna shina wañuchishkada yachushami cuerpoda japisha pambana ut'kubi churagaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesusbuj agllushkaguna tandanukusha tuki ima rurushkada, ima laya yachachishkadash Jesusmu nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Taugaguna paigunajmu shamujkunash rigujkunash tiyakimi ni mikilladash na miki pudigagunachu. Shinushami Jesusga, “Shamichi. Shuj chulunlla pambamu ñukuchilla ashada samungaj jakuchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesusga Paibuj agllushkagunandij barcabi sikusha chulunlla pambamu riga. ");
INSERT INTO qxl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Shina rigujta taugaguna rikusha paiguna gashkada rijsishkamundash, tuki llaktagunamunda chakillan ut'kada risha, narikish paiguna chayujllabidi ñaubusha chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús barcamunda urikigusha, taugagunada rikusha paiguna michij illuj ovejaguna laya gashkamunda llakirisha tuki layada yachachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ña indi tardiyagukimi Paibuj yachagujkuna kuchuyasha, “Kai pushtuga shitushkami gan. Ñami tardiyagun. ");
INSERT INTO qxl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Paigunadaga kai kuchugunabi uchilla pueblogunamush risha imaidash randisha mikuchun kachi,” nikimi, ");
INSERT INTO qxl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesusga, “Kangunalladi karichiri,” niga. Shina nikimi paigunaga, “Kai tukimu karungujka ¿ishki patsuj (200) denario nishka kuchki validachu tandada randingu richun ningui?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Shina nikimi Jesusga, “¿Mashna tandadadi kangunaga charinguichi? Rikungu richi,” nisha kachuga. Rikusha shamushaga, “Pichka tandada ishki chaulallada,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Shina nikimi tukigunada asha ashalla tandanukusha muya pambabi tiyarichichun manduga. ");
INSERT INTO qxl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Shina mandukimi wakingunaga patsujpura (100), shujkunaga pichka chungapura (50) tandanukusha tiyarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chimunda Jesusga pichka tandada, ishki chaulada Paibuj makin japisha, jawa pachada rikusha Diosta <Diosolopai> nisha tandada chaubishka k'ipaga Paibuj yachagujkunamu, “Karungu richi,” nisha kuga. Ishki chauladash tukimumi chaubish karuga. ");
INSERT INTO qxl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tukiguna sajsungama mikushka k'ipash ");
INSERT INTO qxl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","puchu tandaguna chaulagunadash tandachishaga chunga ishki canastadami yachagujkunaga jundachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tandada mikujpuragunaga k'arigunallami pichka warunga gaga. ");
INSERT INTO qxl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kai k'ipami Jesusga Paibuj yachagujkunada barcabi sikachisha yaku kuchada ch'imbusha Betsaida pueblomu ñaubachishami taugalladi chibi gajkunadaga <Shuj p'unllagamachi> niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Paigunada kachashka k'ipami urkumu Diosta mañungu riga. ");
INSERT INTO qxl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tutayagukimi barcaga ña chaubi yaku kuchada riguga. Jesusga Pailla achpabi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Waira ñaubujmunda manchanai t'angaki manchanai shaikusha barcada purichijkunada Jesusga rikuga. Narij p'unllayajllabidimi Jesusga yaku jawada purisha paigunajmu kuchuyamushadi, pasujta ñaubusha ringu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yaku jawada shamujta rikushami <Kukumi shamushka> yuyisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Shina shamujta tukiguna rikusha mancharinmi Paiga, “¡Jinchi gaichi! ¡Ñukami gani; ama mancharichichu!” niga. ");
INSERT INTO qxl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesús barcabi sikun, waira chulunlla sakirikimi paigunaga kushiyasha manchanaidi mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tandada manchanai mirachishkadash jinchi shungun gashkamunda narij intindigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yaku kuchada ch'imbusha Genesaret llaktamu chayushami barcada yaku manyabi watush churugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Barcamunda paiguna uriyagujllabidimi gentegunaga Jesusta rijsigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tuki chi kuchugunamunda ungushkagunada wandusha Jesús maibi gashkada uyushami chimu pushusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mai llaktamush pueblomush wasimush Jesús rikish Pai maida purina lasagunabimi ungushkagunada churusha <Kambuj churana manyawaidash tupachun sakibai> nisha rugagaguna. Maijinsh Jesusbuj churanada tupujka alliyagallami. ");
INSERT INTO qxl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseogunash Moisés mandashkada yachachij maijingunash Jerusalén pueblomunda chayamushkallaguna Jesusbujmu kuchuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Paigunaga Jesusbuj yachagujkunamunda maijingunaga <Makida maillashami mikuna> nishkada na p'aktachishalla mikujta rikushami rimugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseogunash tuki israelgunash paigunaj ñauba taitaguna yachachishkada katijkuna gashami makida narij maillushaidijka na mikujllagunachuga. ");
INSERT INTO qxl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mai lasamunda chayamushash, narij maillarishaidijka na mikujkunachu gan, ashtan shuj mandashkagunadash charijkuna gashami vazugunadash, jarrugunadash, mangagunadash maillujkunamiga.) ");
INSERT INTO qxl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Shinushami fariseogunash Moisés mandashkada yachachijkunash Jesustaga, “Kambuj yachagujkunaga ¿imashti ñukuchij ñauba taitaguna rurushkada na katisha mapalla makigunan mikun?” nisha tapukimi, ");
INSERT INTO qxl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusga, “¡Kangunaga ishki siki imadash nijkunami! Dios parlachiki Isaiasga kangunamunda na yangachu niga: ‘Kai gentegunaga shimillanmi <Allimi gangui> ninguna, ashtanbish paigunaj shungugunaga Ñukamundaga karubimigun. ");
INSERT INTO qxl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñukamunga <Allimi gangui> nishkash imakish na valinchu. Paiguna yachachishkash genteguna mandashkallami gan’ nishaga kabishkadami escribishka. ");
INSERT INTO qxl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","¿Imashti kangunaga Dios mandushkadaga sakisha genteguna ñaubamundadi mandushkagunallada rurush ninguichi?” ");
INSERT INTO qxl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kaidashmi niga, “Kanguna ñauba taitaguna rurushkada na sakish nishallami Dios mandushkadaga na valichisha ladumu churushkanguichi. ");
INSERT INTO qxl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisesbish kashnami niga, ‘Kambuj taita mamada k'uyusha tukida kazungui.’ ‘Maijinsh taita mamada na alli rimujka wañuchun nishkami ganga.’ ");
INSERT INTO qxl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ashtan, kangunaga taita mama ministishkada charishash ‘Ñuka charishkaga Diosmu kushkallami gan’ nichun yachachinguichi. ");
INSERT INTO qxl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Shinusha taita mamadash ayudachun na sakinguichichu. ");
INSERT INTO qxl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Shinami kangunaga Diosbuj Shimida na valichisha ñauba taitaguna rurush yachachishkaida kaishuj chaishujmu nisha katinguichi. Shina laya tauga ruranagunadash rurajkunami ganguichi.” ");
INSERT INTO qxl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kutin tukigunada kayusha Jesusga, “Ñuka nishkada tukiguna uyisha intindichi. ");
INSERT INTO qxl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ima mikunash iksamu waigujka na mapayachinchu, ashtan kikinmunda na alli yuyiguna llujshijmi mapayachin. ");
INSERT INTO qxl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Maijinsh rinrinda uyungu charijka uyichi.” ");
INSERT INTO qxl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Gentegunada sakisha wasimu waigushka k'ipa Paibuj yachagujkuna <¿Imada nisha shina ch'imbapurusha yachachingui?> nisha tapukimi, ");
INSERT INTO qxl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesusga, “Shinadijka ¿kangunash nachu intindinguichi? ¿Nachu yachunguichi, ima mikunash iksamu waigushaga juchayujtaga na rurunchu? ");
INSERT INTO qxl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mikushkaga na shungumu chayunchu, ashtan iksamu rishami mapa tukusha llujshin.” (Shinushaga <Ima mikunash linshumi. Miki pudinguichimi> nishami yachachiga.) ");
INSERT INTO qxl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Shinaidi, “Kikinmunda llujshijkunami juchayujkunada rurun. ");
INSERT INTO qxl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Shungu ukumundami kaiguna llujshin: na alli yuyiguna, piyunbish siririna, shuwana, wañuchina, ");
INSERT INTO qxl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kazarashka k'ipa wainayana, charij tukunallada munana, millida rurana, llullana, imadash munushkada ñalla ñalla ruragujlla gana, shujkuna charishkada munana, shujkunada na allida rimana, jatun tukuna yuyana, shinaidi shungu munushkallada yuyi illasha imadash ruruj gana. ");
INSERT INTO qxl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tuki kai milliguna kikinbuj ukumunda llujshishami juchayujkunada rurun.” ");
INSERT INTO qxl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chimunda rishami Jesusga Tiro pueblo Sidón pueblo kuchu llaktagunada risha, pish ama Pai chayushkada yachachun nisha shuj wasimu waiguga. Shinash na mitiki pudigachu. ");
INSERT INTO qxl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Shinami Jesús chibi gajta yachi chayunlladimi yana katishka ushiyuj mamunga Jesusmu kuchuyasha ñaubuki kungurisha kumuriga. ");
INSERT INTO qxl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chi griega warmiga Sirofenicia karu llaktamunda shamushkamiga. Paiga Jesusbuj kuchumu risha, “Ñuka ushimunda ayada llujshichibai,” nisha ruguga. ");
INSERT INTO qxl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Shinash Jesusga, “Maragunadi mikuchun shuyi. Maraguna mikuna tandada kichusha achkumu karanaga na allichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Shina nikimi chi warmiga, “Ari, shinami gan, Manduj Jesús. Shina gakish miza ukubi tiyaj achkugunash, maraguna mikushka tanda p'ilikirishkaidash mikunmi,” nikimi, ");
INSERT INTO qxl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesusga, “Kan alli nishkamunda wasimu kutin rilla. Kambuj ushimunda aya ñami llujshishkada japingui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Shina niki, mamunga wasimu chayushaga paibuj ushimunda aya llujshiki k'awitubi alliyashka sirijta japiga. ");
INSERT INTO qxl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro pueblo kuchu llaktagunamunda llujshishami Sidón pueblodash Galilea yaku kuchadash pasusha Chunga Puebloguna nishka llaktamu chayuga. ");
INSERT INTO qxl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chibimi shuj uyish na uyuj, upash upada Jesusmu pushush risha <Kambuj makida paibuj umabi churabai> nisha mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chimunda Jesusga taugalladimunda paillada ladumu pushush risha rinrinbi dedo satisha, shinaidi k'allubiga Paibuj t'iukada churuga. ");
INSERT INTO qxl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Shina rurushka k'ipami jawa pachada rikusha, shungu llakirisha paida, “Efatá,” niga. (<Efatá> nishaga <Paskari> nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Shina ninmi na uyujbuj rinrin paskariki paibuj k'allush alliyaki alli rimari pudiga. ");
INSERT INTO qxl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kishna alliyachishkamunda <P'akta pimush nigunguichimu> nishami Jesusga kachuga. <Ama ninguichichu> nishkash ashtan taugagunamumi nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Shinada yachushami manchanai mancharisha kushiyashaga, “Paiga tukida alli rurushami ¡na uyajkunadash uyachinmi! ¡Upagunadash rimarichinmi!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Shuj p'unlla kutin taugaguna tandanukusha ima mikunada mikungu na chariki Jesusga yachagujkunada kayusha, ");
INSERT INTO qxl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Paigunamunda llakirinimi. Ña kinsa p'unllada ñukan kaibi gashkamunda ima mikunadash na charingunachu. ");
INSERT INTO qxl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Imadash na karusha wasigunamu kachukiga paigunaga taugaguna karumunda shamushkamunda ñanbi ñawi ansayasha tigrangagunamami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Shina nikimi Paibuj yachagujkunaga, “Kai shitushka pushtubidijka ¿maimundadi imadash kai tukigunamunga kari pudishunri?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chimunda Jesusga, “Kangunaga ¿mashna tandada charinguichi?” nisha tapuki, “Kanchistami charinchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chimunda gentegunada pambabi tiyarichun mandusha kanchis tandada japisha Diosta <Diosolopai> nisha chaubisha Paibuj yachagujkunamu karachun kuga. Paigunash tukigunamu karaga. ");
INSERT INTO qxl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yachagujkunaga ashalla utilla chaulagunadashmi chariga. Jesús chimundash Diosta <Diosolopai> nisha karachun kuga. ");
INSERT INTO qxl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tukigunami sajsujta mikuga. Na miki pudisha puchuchishkadash kanchis canastabimi tandachiga. ");
INSERT INTO qxl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chi mikujkunaga chusku waranga (4.000) shinagunamiga. Karushka k'ipami Jesusga wasimu kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chi k'ipaga Jesús Paibuj yachagujkunandij barcabi sikusha Dalmanuta llaktamu riga. ");
INSERT INTO qxl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseoguna chayamushaga Jesuskun rimanukungumi kallariga. Pandachingu nishami Jesusta <Pi na ruri pudishkada rurusha Dios jawa pachamunda kachashkada rikuchi> nisha mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesusga shungu manchanai llakirisha, “¿Imashadi kaigunaga pi na ruri pudishkada rurachun mañagun? Kabishkadadimi nini, imadash na rurusha rikuchishka gangachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chimunda Jesusga paigunada chibi sakisha kutin barcabi sikusha yaku kucha ch'imbamu riga. ");
INSERT INTO qxl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yachagujkunaga mikunada apusha rinadami kungarishkagunaga. Barcabiga shuj tandalladami charigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesusga paigunadaga, “P'akta, yuyin puringuichi fariseogunaj shinaidi Herodesbuj levaduragunamundash,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","“Tandada na apamushkamundami shina nigun,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Shina ninukujta Jesús yachushaga, “¿Imashadi <Tandadaga na charinchijka> ninguichi? ¿Chairijti nachu rikunguichi? ¿Nachu yachunguichi? ¿Ima yuyidi illujkunachumadi ganguichi? ");
INSERT INTO qxl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ñawida charishash nachu rikunguichi? ¿Rinrinda charishash nachu uyanguichi? ¿Nachu yuyaringuichi? ");
INSERT INTO qxl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pichka tandada pichka waranga (5.000) k'arigunamu karukiga ¿mashna canasta junda puchushkadaga japiganguichi?” nikimi, paigunaga, “Chunga ishkida,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Kanchis tandada chusku warangagunamush (4.000) karuki ¿mashna canastabidi puchushkagunada tandachiganguichi?” nishash tapuga. Yachagujkunaga, “Kanchista,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Shina niki Jesusga, “¿Narijchu intindinguichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chi k'ipaga Betsaida pueblomu chayagaguna. Chibimi na rikujta Jesusbujmu pushamusha tupachun rugugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesusga makimunda japisha chi pueblomunda llujshichiga. Paibuj t'iukada ñawibi churusha makidash na rikujbuj jawabi churusha, “¿Imalladash riki pudinguichu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na rikujka rikungu kallarishami, “Gentegunaga purij yura shinami rikurin,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús Paibuj makida kutin ñawibi churuga. Shina churukimi ñawi alliyasha tukida laru rikugallami. ");
INSERT INTO qxl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesusga, “Ama chi pueblomu waigunguichu,” nisha wasimu kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kai k'ipaga Cesarea Filipo pueblo kuchulla uchilla pueblogunamu Jesusga Paibuj yachagujkunandij ñanda rigushaga, “Genteguna Ñukada ¿pi gashkadadi ninguna?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Shina tapukimi paigunaga, “Maijingunaga Bautizaj Juanchu gashkada, kutin partigunaga Elías gashkada, shujkunaga Dios nishkada parluj gashkadashmi ninguna,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesusga, “Kangunaga ¿pi gashkadadi yuyanguichi?” nisha tapukimi, Pedroga, “Kanga Dios agllusha kachushka Cristomi gangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pedro shina nikimi Jesusga yachagujkunadaga <Ñuka pi gashkadash ama pimush parlunguichichu> niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yachagujkunamu Jesusga yachachingu kallarishaga, “Aichayuj tukushka Churiga manchanai llakidami apunga. Yuyijkunash manduj curagunash Moisés mandashkada yachachijkunash na rikunachisha wañuchichunmi kachunga. Shinash kinsa p'unlla k'ipaga kausaringami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kaidami yachagujkunamunga intindinaida yachachiga. Chimundami Pedroga shuj ladumu Jesusllada kayusha, “Ama shina nichu,” rimusha jarkungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ashtan Jesusga yachagujkunada vueltush rikushaga, “¡Anchi Ñukamunda, Satanás! Kanga kaidaga Dios rikushka layaga na rikunguichu, ashtangarin genteguna rikushka layami rikungui,” nisha Pedroda rimuga. ");
INSERT INTO qxl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chi k'ipa Jesusga taugalladijkunada Paibuj yachagujkunandi kayushaga, “Maijin Ñukada katisha nijka kikinbuj munida sakisha cruzta aparij laya ima llakidash japisha katimilla. ");
INSERT INTO qxl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maijinsh kikinbuj kausillada yuyarijka chingaringami, ashtangarin Ñukadash kishpichina Alli Shimidash katigushkamunda kikinbuj kausida na llakijka kishpichishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Maijinsh kai pachabi mashna charishkash kausida chingachikiga ¿ima allidi gangari? ");
INSERT INTO qxl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kikinbuj kausida kishpichingajka imaidash na kui pudingachu. ");
INSERT INTO qxl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maijinsh kai wainayaj juchayuj gentegunaj ñaubuki Ñukamunda shinaidi Ñuka yachachishkamundash pingui tukukiga Aichayuj tukushka Churish Paibuj Taitaj k'uilla gashkan jucha illuj angelgunan shamushaga pingui tukungami.” ");
INSERT INTO qxl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Paigunamu Jesusga, “Kabishkadadimi nini, Diosbuj mandana tukida mandi pudishkan shamunada rikungagama kaibi gajkunamunda shujkunaga na wañungachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sujta p'unlla k'ipa Jesús shuj jatun urkumu Pedroda Jacoboda Juanchudash pushush riga. Paigunallan gashami Jesusga paigunaj ñaubuki shuj laya tukuga. ");
INSERT INTO qxl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Paibuj churanash yurujlladi p'alanigujmi tukuga. Kai pachabiga manchanai takshagushash shina yurujlladaga na takshi pudinmuchu. ");
INSERT INTO qxl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chibiga Eliastash Moisestash Jesuskun parlanukujta rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedroga Jesusta kashna niga, “Yachachij, ¡Ñukuchi kaibi gashkamunda allimi gashka! Kinsa carpadami rurashun: shujtaga kanmu Moisesmush Eliasmush.” ");
INSERT INTO qxl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mancharishkaguna gashkamundami Pedroga imada ninadash na yachuga. ");
INSERT INTO qxl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kashna nigukimi p'uyu shamusha paigunada killpusha llanduga. Chi p'uyumundaga, “Paiga Ñuka k'uyashka Churimi. Paida uyichi,” nishkami uyariga. ");
INSERT INTO qxl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Shina uyarinmi yachagujkunaga muyundijta rikushash pidash ña na rikugagunachu. Jesuslladami rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Urkumunda uriyagushami Jesusga <Aichayuj tukushka Churi wañushkagunapuramunda kausaringama ima rikushkadash pimush ama yachi chayachinguichichu> niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chimundami paiguna rikushkadaga pimush na yachi chayachigaguna, ashtanbish imamunda <Wañushkagunapuramunda kausaringama> nishkadaga paigunapura tapunukushash na yachugagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yachagujkunaga Jesusta kashna nisha tapugaguna, “¿Imasha Moisés mandashkada yachachijkunaga ‘Eliasmi ñaubusha shamuna gan’ ninguna?” ");
INSERT INTO qxl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesusga kashna niga, “Kabishkami gan, Eliasmi ñaubusha shamusha tukida parijanga. ¿Imashadi Dios escribichishkabiga <Aichayuj tukushka Churida na rikunachisha manchanaidimi llakichinga> nin? ");
INSERT INTO qxl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kangunamu nini, Eliasga ña shamugami; Dios escribichishkabi nishka layami paidaga paiguna munushkada rurusha llakichiga.” ");
INSERT INTO qxl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ña chaishuj yachagujkunajmu chayamushaga paigunaj muyundijta taugaguna shayajta japiga. Moisés mandashkada yachachijkunash paigunan rimanukuga. ");
INSERT INTO qxl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chibi gajkuna Jesús shamujta rikusha tukiguna mancharij shina kushiyasha ut'kalladi risha saludagaguna. ");
INSERT INTO qxl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusga, “¿Imadadi paigunan rimanukunguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chibi gaj taugalladimunda shuj niga, “Yachachij, ñuka churidami kambujmu pushamugani. Paidaga aya japisha upadami rurusha charigun. ");
INSERT INTO qxl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maibi gakish aya japishaga pambamu urmachiki shimimunda pusku shitusha kiru kanirisha kaspi layami tukun. Ayada llujshichichun kambuj yachagujkunada mañukish na pudigachu.” ");
INSERT INTO qxl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Shina niki Jesusga, “¡Kangunaga mana crijkunami ganguichi! ¿Ima p'unllagamashi kangunan gasha? ¿Ima p'unllagamashi kashnada rikusha? Marada kaimu pushamichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Shina nikimi marada Jesusbujmu pushagaguna. Jesusta rikunmi ayaga marada manchanai ch'ujchuchisha shimimunda puskuda shitachisha pambamu urmachisha pelotachiga. ");
INSERT INTO qxl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chimunda Jesusga, “¿Ima p'unllamunda shina tukush purin?” nisha taitada tapuga. Paiga, “Uchillamunda pachami shina gan. ");
INSERT INTO qxl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tauga kutinmi ayaga wañuchish nisha ninabish yakubish urmachishka. Shinakiga imadash ruri pudishaga ñukuchida llakisha ayudabai,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Shina niki Jesusga, “¿Imashadi ‘Pudishaga,’ ningui? ¡Tuki shungun crikiga Diosga imadash rurunllami!” ninmi, ");
INSERT INTO qxl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","maraj taitaga kaparisha, “Ñukaga crinimi. ¡Ashtan crina yuyida churabai!” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Taugaguna tandanukumugujta Jesús rikusha ayada rimungu kallarishaga, “Na rimuj, na uyuj aya, ¡kai maramunda llujshichunmi mandani! ¡Kutinga ama paibi waiguchunbishmi mandani!” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chimunda ayaga kaparisha pachun ch'ujchuchisha maramunda llujshiga. Wañushka layada sakikimi taugaguna, “Mara ña wañushkami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Chimunda Jesús makimunda japisha jatarichiki maraga shayarigallami. ");
INSERT INTO qxl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús wasimu waigushka k'ipa chibi yachagujkunapuralla Paida, “¿Imasha ñukuchiga ayada na llujshichi pudiganchi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Shina niki Jesusga, “Kai laya ayagunadaga Diosta mañushallami llujshichingu pudina,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Chimunda rishaga Galilea llaktadami pasugaguna. Jesusga Paibuj yachagujkunamu yachachigushkamundaga Pai maibi gashkada pish ama yachachunmi munaga. Shina yachachigushaga, “Aichayuj tukushka Churiga gentegunaj makibimi kushka ganga. Paiguna wañuchikish kinsa p'unllabiga kausaringami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Paigunaga ima nishkadash na intindigagunachu; tapunadash manchagagunami. ");
INSERT INTO qxl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaúm pueblomu chayushaga ña wasibi gashami Jesusga, “¿Imadadi kangunapuralla ñanbi rimanukusha shamuganguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","<¿Maijinshi yalli valij ganchishi?> nisha rimanukusha shamushkamundami paigunaga upalla sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chimundami Jesusga tiyarisha chunga ishki yachagujkunada kayushaga, “Maijinsh yalli alli gasha nijka tukigunada yalli yangami tukuna gan; tukigunadash sirvijmi gana gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chi k'ipaga paigunaj chaubibi shuj marada churusha markushaga, ");
INSERT INTO qxl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Maijinsh Ñukaj shutibi kai laya marada japijka Ñukadami japin. Ñukada japijka na Ñukalladash japingachu, ashtangarin Ñukada Kachujtashmi japin,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chimunda Juanchuga, “Yachachij, shujmi kambuj shutibi ayagunada llujshichijta rikushkanchi. Paiga na ñukuchipura gashkamundaga <Ama shina rurunguichu> nishami jarkuganchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesusga, “Ama jarkunguichichu. Ñukaj shutibi maijinsh pi na ruri pudishkada ruragushaga Ñukamunda ima na allidaga na ni pudingachu. ");
INSERT INTO qxl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maijinsh ñukuchida na p'iñujka ñukuchipuralladiminga. ");
INSERT INTO qxl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kabishkadadimi nini, maijinsh kanguna Cristoj gashkamunda Ñukaj shutibi shuj ubiana yakulladash kujmunga alli japinagunada na chingachingachu.” ");
INSERT INTO qxl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ñukada crij kai uchillagunada ama katichun pandachijtaga kutana jatun rumida kungabi watusha jatun yaku kuchabi shitanami paidaga alli ganmu. ");
INSERT INTO qxl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kambuj maki juchada rurachikiga p'iti. Ishki makin uku pacha na wañuj ninamu rina randiga ashtan shuj maki illuj kausimu waigunami alli ganmu. ");
INSERT INTO qxl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Uku pachabiga k'urugunash ninash na wañunchu. ");
INSERT INTO qxl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kambuj chaki juchada rurachikiga p'iti. Ishki chakin uku pachamu shitashka gana randiga ashtan shuj chaki illuj kausimu waigunami alli ganmu. ");
INSERT INTO qxl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uku pachabiga k'urugunash ninash na wañunchu. ");
INSERT INTO qxl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kambuj ñawi juchada rurachikiga llujshichi. Ishki ñawin uku pachamu shitashka gana randiga ashtan shuj ñawi illuj Diosbuj mandanamu waigunami alli ganmu. ");
INSERT INTO qxl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uku pachabiga ‘k'urugunash ninash na wañunchu.’ ");
INSERT INTO qxl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ima laya mikunabi kachiga churashka gan, shinaidi tukigunamu ninaga churashka ganga. ");
INSERT INTO qxl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kachiga allimi gan. Kachi chamujyakiga ¿imandi kachiyujta rurunguichi? Kangunalladi kachida charichi shinaidi kaishujkun chaishujkun k'uilla kausichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaúm pueblomunda Jesús llujshishaga Judea llaktamush indi llujshina Jordán jatiyaku ladumushmi riga. Chibi taugalladijkuna kutin tandanukukimi Jesusga yachachij gashka shina yachachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Shuj fariseoguna Jesusmu kuchuyasha imada pandarikiga juchachingaj, “¿Kusa paibuj warmida shitanaga ñukuchij mandashkagunabi nishka shina allichu gan?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Shina tapukimi Jesusga, “Kangunamunga Moisesga ¿ima nisha manduga?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Shina nikimi paigunaga, “Moisesga partirishkada rikuchingaj shuj p'angabi firmushaga warmimunda partirichunlla nisha sakishkami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chimunda Jesusga, “Kanguna jinchi shunguda charishkamundami Moisesga shinaga escribiga. ");
INSERT INTO qxl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Shina gakish Diosga kallaribiga tukida ruragushaga ‘K'aridash warmidashmi ruraga.’ ");
INSERT INTO qxl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Chimundami k'ariga taitada mamada sakisha paibuj warmin kazarasha tandanukunga. ");
INSERT INTO qxl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Shinusha ishkindijka shuj aichallami tukunga.’ Shinakiga ña na ishkindijchu, ashtangarin shujllami gan. ");
INSERT INTO qxl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kashna gashkamunda Dios tandachishkadaga pish na ch'ikanyachinachu gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ña wasimu waigushami yachagujkunaga chillamundadij kutin tapungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Shina tapukimi Jesusga, “Maijinsh paibuj warmida shitusha shujkun kazarashaga ñauba warmimunga wainayajmi gan. ");
INSERT INTO qxl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Shinaidi warmish paibuj kusada shitusha shujkun kazarashaga wainayajlladimi gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Maragunada Jesús bendiciasha tupachun nisha pushamukimi yachagujkunaga marada pushusha rigujkunada rimungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Shinada rikusha Jesusga p'iñarisha, “Ama jarkichichu. Maraguna Ñukajmu shamuchun sakichi. Diosbuj mandanaga kai maraguna laya gajkunajmi gan. ");
INSERT INTO qxl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kabishkadadimi nini, maijinsh kai maraguna japishka laya Diosbuj mandanada na japijka chimunga na waigungachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Shina nishka k'ipami Jesusga maragunada ugllarisha paigunaj jawabi makida churusha bendiciaga. ");
INSERT INTO qxl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús ña chimunda rinalla gakimi shujka ut'kalladi Jesusbujmu kuchuyasha Paibuj ñaubuki kungurishaga, “Alli Yachachij, na tukurij kausida japingujka ¿imadadi rurana gani?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Shina tapuki Jesusga, “¿Imasha Ñukadaga <Alli> ningui? Pish alliga na tiyanchu. Diosllami alli gan. ");
INSERT INTO qxl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mandushkagunada ña yachunguimi: Ama wañuchingui. Ama wainayangui. Ama shuwangui. Ama shujkunada llullusha rimungui. Ama llagmusha crichingui. Kambuj taita mamada alli nisha k'uyungui,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Shina nijta uyushami, “Yachachij, tuki chigunadaga maramunda pachami p'aktachishkani,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chimunda Jesusga paida k'uyusha rikushaga, “Shuj ruranash jualtunmi: ri, tuki kan charishkada k'atusha na charijkunamu kungaj. Shinami jawa pachabiga yalli alligunada charingui. Chi k'ipaga Ñukada katimilla,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kaida uyushaga pachun charij gashkamundaga shungu urmarisha llakirisha riga. ");
INSERT INTO qxl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús muyundijta rikushaga Paibuj yachagujkunamuga, “Charijkuna Diosbuj mandanamu waigunaga manchanai jinchimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Shina nikimi yachagujkunaga mancharishka sakirigaguna. Chimunda Jesusga kutinlladi, “Churigunalla, Diosbuj mandanabi waigunaga jinchimi gan. ");
INSERT INTO qxl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jatun camello akuja ut'kuda waigunash charijkuna Diosbuj mandanamu waigunadash yalli jawallami ganga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaida uyushaga ashtan mancharisha kaishuj chaishuj, “Shinadijka ¿pidi kishpiri pudinga?” nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús paigunada rikushaga, “Chida rurungujka gentegunaga na pudinchu. Diosllami tukida ruri pudin. Diosmunga ima na ruri pudinaga illunmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chi k'ipa Pedroga, “Ñukuchiga tuki charishkada sakishami kandaga katishkanchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Shina nikimi Jesusga, “Kabishkadadimi nini, maijinsh Ñukaj kauzamunda Alli Shimimundash wasida, wauki panida, turi ñañada, mamada, taitada, maragunada, achpagunadash sakijka ");
INSERT INTO qxl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kai pachabiga (wasida, wauki panigunada, turi ñañagunada, taitada, mamada, maragunada, shinaidi achpagunada katik'ichushka gashash) chigunada patsuj (100) kutin yallidami japingaguna; shamuj p'unllagunabiga na tukurij kausidami japingaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Shinash taugagunami kunun ñaubusha purijkunaga k'ipallaga washada katijkunami ganga. Kunun washada katijkunaga k'ipallaga ñaubusha purijkunami ganga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús paigunada ñaubushka, Jerusalén pueblomu ichimu ñanda rigugaguna. Paibuj yachagujkunaga mancharishka shinamiga; washada katijkunagarin ashtan manchinmiga. Kutin Pai ima tukunashkada yachachun Jesusga chunga ishkigunallada kayusha parlungu kallarishaga, ");
INSERT INTO qxl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jerusalenmumi kununga rigunchi. Chibimi Aichayuj tukushka Churidaga manduj curagunamu Moisés mandashkada yachachijkunamush japichichingaguna. Paigunaga juchachisha ‘Wañuchinami gan’ nisha na israelgunamumi kunga. ");
INSERT INTO qxl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Shina japisha paigunaga Paida asingami, t'iukushtangami, azilgun dalingami, wañuchingami. Shina rurukish kinsa p'unllabiga kausaringami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeoj churiguna Jacobo Juanchu Jesusmu kuchuyasha, “Yachachij ¿ñukuchij mañashkada nachu rurunguimu?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesusga, “¿Imada rurachun ninguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Shina niki paigunaga, “Kambuj k'uilla mandanabi ñukuchimunda shujtaga alli ladubi kaishujtaga lluki ladubi tiyarichun sakibai,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesusga, “Kanguna imada mañagushkada na yachunguichichu. Ñuka jayuj ubianada ubiuj shina, bautizarinada bautizarij shina llakida apungu ¿Ñuka laya pudinguichichu?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Shina nikimi paigunaga, “Ari, pudinchimi,” nigaguna. Chimundami Jesusga, “Kangunaga kai jayuj ubianada ubiuj shina, bautizarij shina Ñuka laya japinguichimi. ");
INSERT INTO qxl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ñukaj alli ladubish lluki ladubish tiyachingujka na pudinichu. Parijasha agllashkagunamumi kushka ganga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Shina nijta uyushaga kaishuj chunga yachagujkunaga Jacobon Juanchudash p'iñarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chimunda paigunada kayusha Jesusga, “Diosta na rijsijkunapura jatun mandujkuna paigunaj munashkaida rurachigujkunadi gashkada shinaidi jatun pushujkuna rurachisha manchanaidi llakichijkuna gashkadash kangunalladi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kangunaga shinada na ruranachunguichi, ashtangarin kangunapurabi jatun tukush nijka chaishujkunada sirvijmi gana gan. ");
INSERT INTO qxl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Shinaidi kangunapurabi maijinsh tukida yalli gasha nijka tukigunaj esclavo gachun. ");
INSERT INTO qxl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aichayuj tukushka Churish sirvichunga na shamugachu, ashtangarin shujkunada sirvingakish wañushash taugagunada kishpichingakishmi shamuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chi k'ipaga Jericó pueblomumi chayugaguna. Ashalla k'ipami Jesús Paibuj yachagujkunan taugagunanbish chimunda ña llujshigukiga Timeoj churi Bartimeo na rikujka ñan kuchubi kuchkida mañusha tiyaga. ");
INSERT INTO qxl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","<Nazaretmunda Jesusmi shamugun> nijta uyushaga, “Ñauba taita Davidbuj familiamunda Jesús, ¡Ñukada llakibai!” nisha kaparingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Shinushami taugaguna upayachun jarkugaguna. Shinash paiga, “Davidbuj churi, ¡ñukada llakibai!” nisha ashtan kapariga. ");
INSERT INTO qxl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chimunda Jesús shayarishaga, “Kayamichi,” niga. Shina nikimi gentegunaga na rikujta, “Kushilla jatari. Jesusga kanda kayagunmi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Shina ninmi na rikujka pai pillurishkada shitusha ñash jatarisha Jesusmu kuchuyaga. ");
INSERT INTO qxl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesusga, “¿Imada kanmunda rurachun ningui?” nisha tapuga. Na rikujka, “Yachachij, ñukaga rikuj gasha niniga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusga, “Rilla. Kan Ñukada crishkamundami ña alliyachishka gangui,” niga. Shina ninmi Bartimeoga rikuj tukusha ñanllati Jesusta katisha riga. ");
INSERT INTO qxl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén pueblomu rigusha Olivos urku kuchubi gaj Betfagé Betania pueblogunabi chayushaga Jesusga Paibuj yachagujkunamunda ishkida kachashaga, ");
INSERT INTO qxl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ch'imba uchilla pueblomu ribaichi. Chimu chayushaga pish na sikushka malta burru watushka shayajta japishaga kacharisha pushamichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Maijinsh ‘¿Imaj kacharigunguichi?’ nisha tapukiga <Manduj Jesusmi ministigun. Na uniyashalla sakichun kachungallami> ninguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yachagujkuna rishaga burruga pungu ñaubuj ñanbi watushka shayajta rikushami kacharingu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Shina kacharigukimi maijin chibi gajkunaga, “Kangunaga ¿imadadi ruranguichi? ¿Imajti chi burrudaga kacharinguichi?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Shina nikimi ishkindijkunaga Jesús nichun nishka layaidi nikiga sakigallagunami. ");
INSERT INTO qxl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesusmu malta burruda pushamusha paigunaj jawa churanagunada burrubi mandukiga Paiga sikuga. ");
INSERT INTO qxl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Taugaguna paigunaj churanagunada ñanbi mandusha churugaguna. Shujkunash pambamunda ramagunada p'itimushami paigunash ñanbi mandusha churugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesusta ñaubujkunash katijkunash, “¡Hosana!” “¡Manduj Diosbuj shutibi Shamuj, alli nishka gachun! ");
INSERT INTO qxl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ñukuchij ñauba jatun manduj David mandushka layaidi mandungu shamugujtash alli k'uilla nishka gachun! ¡Jawa pachabish alli nishka gachun!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús Jerusalenmu chayushaga israelgunaj Diosbuj wasimu waiguga. Chibi tukida muyundijta rikushka k'ipaga ña tardiyagushkamunda paibuj chunga ishki yachagujkunandij Betania pueblomumi riga. ");
INSERT INTO qxl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kayundij p'unlla Betania pueblomunda llujshigushami Jesusga yarijachiga. ");
INSERT INTO qxl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Shinusha Paiga p'anga jundushka jigus yurada karumunda rikuga. Jigus tiyashka na tiyashka rikungu rishaga narij granuna p'unlla gashkamundaga p'angagunalladami rikuga. ");
INSERT INTO qxl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chimundami Jesusga chi jigus yurada, “¡Kununmunda ichimunga pish ama kambuj granuda mikuchun!” niga. Shina nigujtaga Paibuj yachagujkunash uyugami. ");
INSERT INTO qxl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesusga Jerusalén pueblomu chayushka k'ipaga Diosbuj wasimu waigusha tuki k'atugujkunadash randigujkunadash llujshichisha kachungu kallariga. Shinaidi kuchkida cambiagujkunaj mezadash palomagunada k'atuna tiyarinagunadash ladumu piguga. ");
INSERT INTO qxl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Shinaidi Diosbuj wasi ukuda imadash apushka pasachunga na sakigachu. ");
INSERT INTO qxl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chimunda Jesusga chibi gajkunamush yachachingu kallarisha, “Dios escribichishkabiga ‘Ñukaj wasiga tuki llaktagunabi kausujkuna tandanukusha Ñukada mañana wasi nishkami ganga’ ninmi. Shinash kangunaga ‘shuwaguna tiyana ut'ku shinadami’ rurushkanguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kaida uyushaga manduj curagunaga Moisés mandashkada yachachijkunash Jesusta manchusha Pai yachachishkada tukiguna ashtan kushilla uyashkamunda ima layash wañuchinada yuyaringu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ña tutayagukimi Jesusga Paibuj yachagujkunandij chi pueblomunda llujshisha riga. ");
INSERT INTO qxl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kayundij tutamunda jigus yura kuchuda pasagusha angumunda pacha chakirishka gashkadami rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedroga Jesús rimushkada yuyarisha, “Yachachij, riki. Kan rimushka jigus yura chakirishkami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Shina nijta uyushami Jesusga, “Diosta crichi. ");
INSERT INTO qxl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kabishkadadimi nini, maijinsh kai urkuda, ‘Anchi. Kaimunda jatun yaku kuchabi urmi,’ nisha shungubi kaida chaida na yuyashalla ashtan paibuj nishkada p'aktunada crikiga paimunga shina rurashka gangami. ");
INSERT INTO qxl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chimundami nini, kanguna Diosta imadash mañashaga ña japigushkada crisha mañashkada japinguichimi. ");
INSERT INTO qxl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Shinaidi kanguna Diosta mañagushaga pi ima rurashkadash perdonichi. Shinami jawa pachabi tiyaj Taitabish kangunaj juchagunada perdonanga. ");
INSERT INTO qxl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kanguna na perdonakiga jawa pachabi tiyaj Taitabish kangunaj juchada na perdonangachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kutinga Jerusalenmumi chayagaguna. Diosbuj wasibi Jesús purigukimi manduj curaguna, Moisés mandashkada yachachijkuna, yuyijkunash Paimu kuchuyashaga, ");
INSERT INTO qxl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“¿Pi mandakidi kashna rurangui? ¿Pidij kandaga kashna rurachun mandagun?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Shina tapukimi Jesusga, “Ñukash kangunada shuj kutinlla tapusha ninimi. ¿Pidij Juanchudaga bautizachun kachuga? ¿Dioschu? na gashaga ¿gentegunachuga? Kanguna nikiga Ñukash pi mandaki shina rurashkada kangunamu nishami,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chimunda paiguna kaishuj chaishuj ninukuga, “ ‘Diosmi kachuga,’ nikiga ‘¿Imashti Juanchuda na criganguichi?’ ningami. ");
INSERT INTO qxl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ima layadi, ‘Gentegunallami kachuga,’ nishun?” ninukugaguna. (Juanchuga Dios nishkada parlujlladi gashkadami tukiguna yachushkamunda manchugaguna.) ");
INSERT INTO qxl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chimundami Jesusmuga, “Na yachunchichu,” nigaguna. Shina niki Jesusbish, “Ñukash kangunamu pi mandaki shina ruragushkadaga na nishachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yuyachinagunan yachachingu kallarishami Jesusga, “Shuj achpayujmi uva yuragunada tarbuga. Chimunda muyundijta rumigunan pirkusha churuga. Uvada ñutusha vinoda ruranadash jawamunda tuki laduda rikusha chapana wasidash ruraga. Chi k'ipa uva chagrayujka achpada shujkunamu partido kusha karumu riga. ");
INSERT INTO qxl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uvada pallana p'unlla ña chayamukimi achpayujka shuj sirvijta paibuj partida japichun nisha partido charijkunajmu kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Partido charijkunaga chi sirvijta japisha takusha imash illijtami kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chimundami achpayujka kutin shuj sirvijta kachuga. Paidash umada chugrichisha rimushash kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Shinaidi kutin shuj sirvijtash kachukiga kaidash wañuchigagunami. Taugagunada kachukish shujkunadaga takugaguna, kutin shujkunadaga wañuchigagunami. ");
INSERT INTO qxl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ña tukida kachushka k'ipaga paibuj k'uyashka churillami sakiriga. Shinusha ‘Ñukaj churidaga kazungagunami,’ yuyusha kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Achpada partido charijkunaga kaishuj chaishuj ninukushaga, ‘Paimi tuki achpada taitamunda japinga. Kaida ñukuchi japingujka paida wañuchishunchi,’ nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Shinusha paida japisha wañuchishaga uvas chagramunda llujshichisha shitugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Shina rurukiga achpayujka ¿imadadij rurunga?” nishami Jesusga tapuga. “Pai rishaga partido charijkunada tukuchisha chi achpadaga shujkunamumi kunga. ");
INSERT INTO qxl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Nachu kangunaga Diosbuj Shimibi escribishkada liyushkanguichi? Chibiga: ‘Wasichijkuna na munusha shitushka rumiga ashtan kallarimu churana rumimi tukushka. ");
INSERT INTO qxl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kaidaga Manduj Diosmi shina rurushka. Mancharishash kushiyanchi,’ ninmi” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kai yuyachinan Jesús yachachikiga paigunada rimashkada yachushami Jesusta prezu japingu munushash tukigunada manchushkamundaga imash na rurashalla rigallagunami. ");
INSERT INTO qxl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jesusta pandachingu nisha tapuchun maijin fariseogunada maijin Herodeskun purijkunadash Jesusbujmu kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ña rishaga, “Yachachij, ñukuchiga kan na llagmusha parluj gashkada yachunchimi. Na ñawillan rikuj gashkamunda na genteguna nishkada rurasha imadash juchachinguichu. Dios munushka shina Paibuj ñandami tukigunamu yachachij gangui. ¿Roma llaktada jatun mandujmu impuestoda paganaga allichu? ¿Paganachunchi? ¿Nachu pagananchi?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jawa shimillan nij tukujllagunashkada Jesús yachushkamundaga, “¿Imashti shina tapusha Ñukada pandachingu mununguichi? Shuj Romamunda kuchkida rikungaj apamichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kuchkida kukiga Jesusga, “Kai ñawish kai shutish ¿pibujti gan?” nisha tapuga. Shina tapukiga, “Kai llaktada jatun mandujbujmi gan,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Shina nikimi Jesusga, “Mandujbujtaga mandujmu, Diosbujtaga Diosmu kuichi,” niga. Paida uyushaga imadash na ni pudisha mancharisha sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Shinaki wañushkaguna kausarinadaga na crij saduceogunamunda shujkuna Jesusbujmu rishaga, ");
INSERT INTO qxl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yachachij, Moisés escribishkabiga kashnami nin: Shuj k'ari warmin na mara charishalla wañukiga wañushkamu maragunada kungaj waukiga viudanmi kazarana gan. ");
INSERT INTO qxl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Shuj kutinmi kanchis waukiguna kausuga. Ñauba wauki kazarashaga narij maragunada charishaidimi wañuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Shina wañukiga k'ipa waukimi chi viudan kazaraga. Paish narij maragunada charishaidimi wañuga. K'ipa waukish shinaidimi tukuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tuki kanchis waukigunami chi warmin kazarasha narij maragunada charishaidi wañugaguna. Chi k'ipaga warmish wañugami. ");
INSERT INTO qxl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wañushkaguna kausarinabiga kanchis waukigunan kazarashkamundaga ¿maijinbuj warmishi ganga?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Shina niki Jesusga, “Kangunaga Diosbuj Shimibi escribishkada, Paibuj poderdash na rijsishkamundami pandarisha puringuichi. ");
INSERT INTO qxl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wañushkagunada kausachikiga na kazarangachu, na kazarachingachu, ashtan jawa pachabi tiyaj angelguna layami ganga. ");
INSERT INTO qxl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wañushkagunada kausachinamundaga Moisés escribishkabi, zarza yura rupashka pushtuda ¿nachu liyushkanguichi? Chibimi Diosga Moisesmunga, ‘Abrahambuj, Isaacbuj, shinaidi Jacob-buj Diosmi gani,’ niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Shinakiga ¡Diosga na wañushkagunaj Dioschu! ¡Kausujkunajmi gan! Chimundami kangunaga pachun pandarishka puringuichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Imada tapukish Jesús kabishkada nisha rimanukujta uyushami Moisés mandashkada yachachijkunamunda shujka Jesusbujmu kuchuyashaga, “Mandushkagunamundaga ¿maijindi yalli alli gan?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Shina niki Jesusga, “Tuki mandushkagunamundaga ashtan yalli alliga kaimi gan: ‘Uyichi, israelguna. Ñukuchida Manduj Diosga shujllami tiyan. ");
INSERT INTO qxl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kambuj Manduj Diostaga tuki shungun tuki alman tuki yuyin tuki jursanbish k'uyungui.’ ");
INSERT INTO qxl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kai mandushka k'ipa mandushkaga kaimi gan: ‘Shujkunadash kikinda layaidi k'uyungui.’ Kai ishki mandushkagunami yalli alli gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chimunda Moisés mandashkada yachachijka niga, “Allimi, Yachachij. Kanga kabishkadami nishkangui. Shuj Diosllami tiyan. Kutin shujka na tiyanchu. ");
INSERT INTO qxl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Diosta tuki shungun, tuki yuyin, tuki jursan shujkunadash kikinda layaidi k'uyanaga allimi gan. Kai ishki mandushkagunaga Diosbuj altar kuchubi p'aktachinagunada animalgunadash Diosmu kusha wañuchinadash rupachinadash yalli allimi gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Moisés mandashkada yachachij alli nijta uyasha Jesusga, “Kanga Diosbuj mandanamundaga na karubi ganguichu,” niga. Jesús tukida alli nikiga ashtan tapungujka mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Diosbuj wasibi Jesús yachachigushaga, “¿Imashadi, Moisés mandashkada yachachijkunaga <Cristoga jatun manduj Davidbuj wawagunaj wawami gan> ninguna? ");
INSERT INTO qxl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Diosbuj Espíritu yuyida kukimi jatun manduj Davidlladi, ‘Manduj Diosga ñukada Mandujtaga “Kanda p'iñujkunada ñuka kambuj chaki sarunabi churungama kanga ñukaj alli ladubi tiyari.” ’ ");
INSERT INTO qxl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidlladi <Ñukada Manduj> nigukidijka ¿ima shinadi Dios agllusha kachushka Mesiasga jatun manduj Davidbuj churigunaj churinga?” niga. Chibi gaj taugagunami Jesusta kushilla uyugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús yachachigushaga, “Moisés mandashkada yachachijkunamunda yuyin puringuichi. Paigunaga k'uilla sundij churanada churungu shinaidi lasagunabi <Alli> nisha saludachun munujkunami gan. ");
INSERT INTO qxl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Diosmunda yachana wasi ukubish ñaubukimi tiyarijkuna, mikungu rishash alli pushtudami mashkajkuna gan. ");
INSERT INTO qxl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Viuda warmigunaj charishkagunadash kichujkunami gan, shinaidi alli rikuringaj nisha unida Diosta mañuj tukujllagunami gan. Paigunaga ashtan yalli llakichishkadami apungaguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesusga Diosbuj wasibi gasha, kuchki churana cajón ch'imbapurabi tiyarisha piguna churujta rikuga. Tauga charijkunaga mirga kuchkidami churuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ashtan shuj na charij viuda shamusha ashalla vali ishki cobre kuchkida churuga. ");
INSERT INTO qxl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chimunda Jesusga Paibuj yachagujkunada kayushaga, “Kabishkadadimi nini, kai viudaga kuchki churanabiga tuki chaishujkunada yallidami kushka. ");
INSERT INTO qxl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tukigunami puchushka kuchkillada chibiga churushka. Paiga na charishkamunda pai kausungu charishka chilladi kuchkidami churushka,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Diosbuj wasimunda llujshigukimi Paibuj yachagujkunamunda shujka, “¡Yachachij, riki chi k'uilla rumigunada chi jatun wasigunadash!” niga. ");
INSERT INTO qxl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Shina nikimi Jesusga, “¿Kai jatun wasigunada rikunguichu? Kai wasigunamundaga shuj rumillash na shuj rumi jawabi sakiringachu. Tukimi urmachishka ganga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesusga Diosbuj wasi ch'imbapura Olivos urkubi tiyarikimi Pedro, Jacobo, Juanchu, Andikush pakalla tapugaguna, ");
INSERT INTO qxl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“¿Ima uradi kan nishkaga p'aktunga? Ña p'aktanalla gashkada rikuchingujka ¿imagunadi rikuringa? nibai,” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusga, “P'akta ama pish pandachichun yuyin ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Taugagunami Ñukaj shutida japisha, ‘Ñukami Kishpichij Cristo gani,’ nisha taugagunada llullasha pandachinga. ");
INSERT INTO qxl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Llaktapuragunami pachun p'iñanuki wañunuki kaibish chaibish tiyajta uyushash ama mancharinguichichu. Shinaidimi tukuna gan. Shinash kai pachaga narij tukuringachu. ");
INSERT INTO qxl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Shuj llaktabi kausujkunan kaishuj llaktabi kausujkunan shuj mandanan kaishuj mandanan wañunukungu takanukungu kallaringagunami. Tauga pushtugunabi achpa ch'ujchungami. Ima granush na p'ukuki yarijish tiyangami. Kaigunaga kallari llakigunallami ganga. ");
INSERT INTO qxl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kangunaidi yuyin puringuichi. Kangunada japishaga mandujkunamu kusha kachungagunami. Shinaidi Diosmunda yachana wasigunabi azilgun jinchida takungagunami. Ñukaj kauzamunda kai llaktada mandujkunajmu jatun mandujkunaj ñaubujmush kayungagunami. Shina pushaki chibi Ñukamunda rimari pudinguichi. ");
INSERT INTO qxl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kai pacha narij tukurijllabidimi Alli Shimidaga tuki llaktagunabi ña parlashkami gana ganga. ");
INSERT INTO qxl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Llaktada mandujkunajmu kangunada japisha juchachisha pushaki <¿Imadadi nishari?> nisha ama chi yuyin ganguichichu. Dios chi ratu nichun nishkada nichi. Shina rurashaga kangunaj yuyillamundaga na rimaringuichichu, ashtangarin Diosbuj Espiritumi nichinga. ");
INSERT INTO qxl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Waukigunaidimi waukida taitagunaidimi wawagunada wañuchichun kunga. Wawagunash taita mamagunada p'iñushami wañuchichun kunga. ");
INSERT INTO qxl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ñukaj shutimundami kai pachabi kausujkunaga kangunada p'iñunga. Shinash tukuringagama alli katijka kishpichishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Alligunada rurana pushtubi ashtangarin millanai tukuchishtachijta na chibi gana gakish kanguna rikushaga Judea llaktabi gajkunaga urkugunabi mitikungu ringuichi. (Maijin liyujkunaga intindichi.) ");
INSERT INTO qxl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kikinbuj wasi jawabi gajkunaga uku pambamu ama uriyachun ima charishkada llujshichingujllash ama wasimu waiguchun. ");
INSERT INTO qxl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chagrabi purijkunash wasimunda churanada apungujllash ama kutin ringuichichu. ");
INSERT INTO qxl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chi p'unllaguna iksa charij warmigunash chuchuchigujkunash ¡¿imachari tukunga?! ");
INSERT INTO qxl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kai llakiguna ama tamia p'unllagunabi tiyachun Diosta mañichi. ");
INSERT INTO qxl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi p'unllagunaga jatun llakimi ganga. Dios kai pachada rurushka p'unllamunda kunungama kashna jatun llakiga narij tiyashkachu. K'ipa p'unllagunash na tiyangachu. ");
INSERT INTO qxl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chi llaki p'unllaguna ashtan katichun Manduj Dios na jarkushkakiga pish na kishpirinmunchu. Pai k'uyasha agllushkagunamundami chi llaki p'unllagunadaga ashallada rurashka. ");
INSERT INTO qxl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kangunada maijinsh ‘Rikichi, Mesiasga kaibimi gan’ na gashaga ‘Paiga chaibimi gan’ nikish ama cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi p'unllagunaga llullushami <Cristomi gani> na gashaga <Dios nishkada parlujmi gani> nishami llagmusha maijinsh shamungallami. Pandachi pudishaga Dios agllushkagunadash ima layash pandachingu pi na rikuchishkagunadash pi na ruri pudishkadash rurangallagunami. ");
INSERT INTO qxl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaidaga narij imash tukujllabidimi kangunamu nisha sakini. ¡P'akta yuyin ganguichi!” ");
INSERT INTO qxl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Chi manchanai llakichina p'unllaguna tukurishka k'ipaga ‘indish ansayangami; lunash na p'unllayachingachu. ");
INSERT INTO qxl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Luzerogunash jawa cielomunda urmungami. Jawa cielobi imalla tiyajkunash chaspiringami.’ ");
INSERT INTO qxl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Kashna tukukiga Aichayuj tukushka Churi tukida ruri pudishkan k'uilla p'alaniguj gashkan p'uyugunabi shamujtami rikungaguna. ");
INSERT INTO qxl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Paiga Paibuj angelguna tuki chusku ladumu Paibuj agllushkagunada karu karu kai pachamunda karu karu jawa pachagama tandachichun kachungami. ");
INSERT INTO qxl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Jigus yura ima laya tukujta rikusha yuyida japingu yachichi. Chi yuramunda llullu ramaguna iñuki p'angagunash kutin iñusha jundukiga k'uilla rupi p'unllaguna chayamugushkada kangunalladi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Shinalladi kashna tukujta rikushaga chi p'unllagunaga ña pungubi gashkada yachichi. ");
INSERT INTO qxl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kabishkadadimi nini, kai llakigunaga kunun p'unllagunabi kausujkuna narij wañujllabidimi shina tukunga. ");
INSERT INTO qxl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jawa pachash kai pachash tukuringami. Shinash Ñuka nishka shimigunaga nalladi tukuringachu. ");
INSERT INTO qxl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ima p'unlla ima uras shina tukunadaga pish na yachunchu. Jawa pachamunda angelgunash na yachunchu. Ñuka Diosbuj Churish na yachanichu. Taitallami yachun. ");
INSERT INTO qxl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ima ura shina tukunada na yachashkamundaga kangunaga rijchuj shina gasha chaparianami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ima layami shujka karu llaktamu rina tukusha paibuj wasida sirvijkunamu chapachun mingusha shuj shujmu ima ruranadash rurachun sakisha shinaidi punguda chapujmu alli chapachun sakisha rij layami gana gan. ");
INSERT INTO qxl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kangunash wasiyuj shamuna urasta na yachushkamunda alli chapichi. Paiga tutayagujtachari, chaubi tutadachari, gallo cantana urastachari, p'unllayanadachari shamunga. ");
INSERT INTO qxl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ñash shamusha p'akta kangunada puñujta japinmu. ");
INSERT INTO qxl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kangunamu nishkadaga tukigunamumi nini. ¡Rijchuj ganguichi!” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ishki p'unlla Pascua pishtash levadura illij tandada mikuna pishtash jualtaki manduj curagunash Moisés mandashkada yachachijkunash ima layash pandachisha Jesusta japisha wañuchingaj yuyarigugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Paigunaga, “Genteguna ama bulla rurachunga pishta p'unllagunaga na japinachunchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania pueblomu chayushaga Leprayuj nishka Simonbuj wasimu risha ña mikungu mezabi tiyakimi shuj warmi nardomunda rurushka manchanaidi valijta alabastro rumida rurashka uchilla botellabi apush chayuga. Chi botellada p'akishaga k'uilla ashnariguj yakuda Jesusbuj uma jawabi talliga. ");
INSERT INTO qxl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chibi gajkunapuramunda shujkunaga <Na alli rurunchu> yuyisha p'iñarisha kaishuj chaishuj, “¿Imashadi kai k'uilla ashnariguj yakudaga yangadi jichushtan? ");
INSERT INTO qxl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kai yakudaga kinsa patsaj (300) yalli denario nishka kuchkimabimi k'ati pudinmuga. Na charijkunamamu kumbidanash allimi ganmuga,” ninukusha chi warmida rimugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chimunda Jesusga, “Sakichi. ¿Imashti p'iñachinguichi? Ñukaj jawabi kishna tallishkaga k'uilladami rurushka. ");
INSERT INTO qxl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Imash na charijkunadaga jursami kangunapurabi charinguichi. Paigunamu ima allida rurush nishash ima urasbish ruri pudinguichillami. Ñukaga kangunan na gagushallachu. ");
INSERT INTO qxl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kai warmiga pudishkada rurushami Ñuka narij wañujllabidi Ñukaj cuerpoda ut'kumu waiguchingu parijagusha k'uilla ashnariguj yakuda talliga. ");
INSERT INTO qxl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kabishkadadimi nini, Alli Shimida yachachigushaga maibi gashash kai warmi rurushkaga yachachishka ganga. Shinami paida yuyachishka ganga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chunga ishki yachagujkunapuramunda Judas Iscariotemi Jesusta japichingu manduj curagunajmu riga. ");
INSERT INTO qxl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kaida uyushami paigunaga kushiyasha Judasmu kuchkida kunadash ari ninukugaguna. Shinushami Judasga Jesusta ima laya japichinada mashkaguga. ");
INSERT INTO qxl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Levadura illij tandada mikuna pishta p'unllagunamunda Pascuabi malta ovejada Diosmu kusha wañuchina kallari p'unllami Jesusbuj yachagujkunaga, “Kan Pascua nishkada mikuchunga ¿maibidi parijachun ningui?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chimunda Jesusga Paibuj yachagujkunapuramunda ishkida, “Richi pueblomu. Chibimi yaku p'unduda aparisha riguj k'arida rikunguichi. Paida katish ringuichi. ");
INSERT INTO qxl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Maimu waigukish wasiyujta ‘¿Maijin ukubidi Ñukaj yachagujkunanga Pascua mikunadaga mikusha? nishami ñukuchida yachachij tapuchun kachun’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chimi paiga jawa altubi shuj jatun k'uilla parijashka tuki churashka ukuda rikuchinga. Chibi ñukuchimu mikunada parijanguichi,” nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yachagujkunaga llujshisha risha pueblomu waigushaga Jesús nishka layaidimi japigaguna. Shinami Pascuada parijagaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tutayagukimi Paibuj chunga ishki yachagujkunandi Jesusga chayuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mezabi mikush tiyashami Jesusga, “Kabishkadadimi nini, Ñukan mikusha tiyujkunamundami shujka Ñukada wañuchish nisha purijkunamu japichinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Shina niki paigunaga llakirisha shuj shujlla, “Na ñukachuni ¿nachu?” nisha tapungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Shina tapukimi Jesusga, “Chunga ishkipuramunda, latubidi tandada Ñukan nuyuchigujmi Ñukada japichinga. ");
INSERT INTO qxl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dios escribichishka shinaidimi Aichayuj tukushka Churidaga wañuchinga. Maijin japichijka ¡¿imachari tukunga?! Ashtangarin na wacharishkashami alli ganmuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Shina mikugukimi Jesusga tandada japisha Diosta <Diosolopai> nishka k'ipa paigunamu, “K'aigachi. Kaimi Ñuka cuerpo gan,” nisha partisha kuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chi k'ipaga shuj copada japisha Diosta <Diosolopai> nisha paigunamu kuga. Shinami tukiguna ubiuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Shinami Jesusga, “Kaimi Ñukaj yaur. Dios ari ninukushkada p'aktachij kai yaurga taugagunabujmi jichushka gan. ");
INSERT INTO qxl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kabishkadadimi nini, Diosbuj mandanabi mushuj vinoda ubiana p'unllagama kutinga uvan rurushka vinodaga na ubiashachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Salmoskunada cantushka k'ipami Olivos urkumu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chibimi Jesusga, “Kangunaga tukigunami Ñukallada sakisha ringuichi. Dios escribichishkabi kashna nishka shina, ‘Michijta wañuchikiga ovejagunaga kaida chaida rishami chingashka ganga.’ ");
INSERT INTO qxl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Shinash Ñuka kausarishaga kangunada ñaubushami Galilea llaktamu risha,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedroga, “Tukiguna kanllada sakisha rikish ñukaga na sakishachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Shina niki Jesusga, “Kabishkadadimi nini, kunun tutaidimi gallo narikish ishki kutin cantujllabidi kinsa kutin Ñukadaga <Na rijsinichu> ninguimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Shinash Pedroga, “Kangun wañuna gakish Kandaga <Na rijsinichu> nishaga na nishachu,” nisha katiga. Kaishujkunash shinaidimi nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chi k'ipaga Getsemaní shuti huertomumi rigaguna. Chibiga Paibuj yachagujkunamu, “Ñuka Diosta mañungama kaibi tiyarichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chimunda Jesusga Pedroda Jacoboda Juanchudash pushusha riga. Shina rishami Paibuj shungubi llakin gasha manchanai llakiringu kallarisha ");
INSERT INTO qxl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","paigunadaga, “Ña wañubuj shinami Ñuka shunguga manchanaidi llakirin. Kangunaga kaillabi sakirisha yuyin chaparianguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesusga ashan ñaubujmu risha kungurishaga achpabi tuparingama kumurishami <Kai llakida apana uras ama p'aktachun imadash ruranalla valikiga ima layash rurabai> nisha ");
INSERT INTO qxl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Diosta mañagushaga, “Abba, Ñuka Taitawalla, Kanga tukidami ruri pudingui. Kai jayuj ubiana shina jatun llakida anchuchibai. Shinash ama Ñuka munushkada rurichu, ashtan Kan munushkada rurabai,” nishami mañuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chi k'ipa paiguna tiyashkamu shamushaga puñujkunadami japiga. Chimunda Pedroda, “Simón ¿puñugunguichu? ¿Shuj uralladash nachu rijchuj chapi pudigangui? ");
INSERT INTO qxl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ama juchabi urmungajka rijchuj chapusha Diosta mañichi. Kangunaj shunguga mañungu munakish cuerpomi shaikushka shinalla ruran,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chi k'ipa kutin rishaga ñaubamu mañashka layaidimi Diosta mañuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Shina mañusha shamushami yachagujkunaj ñawi vinciti vincisha ichkarishkamunda kutin puñujta japiki imada na ni pudigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ña kinsa kutin risha shamushami Jesusga, “¿Kangunaga puñush katisha samanguichillachu? Chilla puñichi. Aichayuj tukushka Churida juchayujkunaj makibi kuna uras ñami chayamushka. ");
INSERT INTO qxl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jatarisha jakuchi. Ñukada japichijka ñami kuchuyamun,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús chairij nigujllabidimi chunga ishki yachagujkunamunda Judasga taugagunan shamuga. Chigunaga kaspi aisushka, espada tsutsukishka, manduj curaguna, Moisés mandashkada yachachijkuna, yuyijkuna kachushkami shamugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Japichij Judasga, “Ñawi ichibi ñuka muchushkami Jesusga ganga. Paida japisha alli alli charirisha pushusha ringuichi,” nishami ña yachachishkaga. ");
INSERT INTO qxl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Shinushami Judasga Jesusmu kuchuyan, “¡Yachachij!” nisha muchuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chimunda Jesusta charirisha japigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Chibi gajpuramunda shujka espadada llujshichisha jatun manduj curaj sirvijta juaktusha rinrindami p'itiga. ");
INSERT INTO qxl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chimundami Jesusga tapuga, “¿Imashadi kangunaga kaspigunan espadagunan shuj shuwada laya Ñukada japingu shamuganguichi? ");
INSERT INTO qxl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tuki p'unllagunami kangunan gasha Diosbuj wasibi yachachigushkani. Shinash na prezu japiganguichichu. Kununga Dios escribichishkaguna p'aktachunmi shina rurashkanguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tuki yachagujkunami Jesusllada sakisha mitikusha shujlla rigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Shina rigukiga shuj musumi linsullada pillurishka katisha riguga. Paidash charirikiga ");
INSERT INTO qxl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","linsuda shitusha llatunlla vincisha mitikusha riga. ");
INSERT INTO qxl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesusta japishaga jatun manduj curajmu pushush rigaguna. Chibimi manduj curaguna, yuyijkuna, Moisés mandashkada yachachijkunash tukiguna tandanukuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesusta pushakimi Pedroga washa washa katisha jatun manduj curaj wasi kanllagama riga. Chibimi chapujkunan ninabi kunungu tiyariga. ");
INSERT INTO qxl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chi wasibimi manduj curaguna, israelgunada mandajkunaj tandanukushkash Jesusta imanllash juchachisha wañuchingaj nisha mashkashash ima juchachinadash na japigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Taugaguna llagmusha Jesusta juchachishash paigunapuraidimi na shuj yuyilla tukusha kaida chaida ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Shinaidi shujkunaga llullasha Jesusta juchachingu munusha, shayarisha, ");
INSERT INTO qxl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ ‘Ñukaga genteguna rurushka Diosbuj wasida urmachishami. Kinsa p'unlla k'ipami shujta shayachisha. Kaiga na genteguna rurushkachu ganga,’ nijtami ñukuchiga uyishkanchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Shinash paiguna nishkabi na shuj yuyillan juchachi pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Shina gakimi jatun manduj cura tukigunaj chaubibi shayarisha Jesusta, “¿Ima ninadash nachu charingui? Kai tuki kanda juchachishkagunaga ¿imadi gan?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Shinash Jesusga imadash na nishalla upalla shayakimi jatun manduj cura kutin, “¿Kanchu Dios agllusha kachushka Mesías, bendiciashka Diosbuj Churi gangui?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Shina tapuki Jesusga, “Ari, Ñukami gani. Kangunami Aichayuj tukushka Churi Tukida Ruri Pudijbuj alli ladubi tiyajta jawa pachamunda p'uyugunabi shamujtash rikunguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Shina nikimi jatun manduj curaga p'iñarishkada rikuchingu Paibuj churanada llikishaga, “Paida juchachichun ¿imajtikish shujkunadaga ministishun? ");
INSERT INTO qxl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kangunaidimi Diosta p'iñasha rimajta uyushkanguichi. ¿Imadadi kangunaga yuyinguichi?” niga. Shina tapukimi tukiguna <Kauzayujmigun. Paiga wañunami kabin> ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Shujkunaga t'iukushtangu kallarigaguna. Shinaidi ñawida watusha juaktushka k'ipaga, “¿Pidi takagunchi? ¡Parli!” nisha tapugaguna. Guardagunash lutskigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro pungu pambabi gakimi jatun manduj curada sirvij warmigunamunda shujka chayamuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Chi warmiga Pedroda ninabi kunujta rikuriashkanmi, “Kambish Nazaret pueblomunda Jesuskun purijmi gangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Shina nikimi Pedroga, “Na rijsinichu. Kan imada nigushkadash na yachanichu,” nisha kanlla waiguna pungumu llujshikiga galloga cantuga. ");
INSERT INTO qxl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chi sirvij warmi Pedroda kutin rikusha tukigunamu, “Paibish paigunapurami gan,” ningu kallariki, ");
INSERT INTO qxl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedroga kutin <Na rijsinichu> niga. Ashalla k'ipaga chibi gajkuna kutin, “Kanga paigunapuramundadimi gangui. ¡Galilea llaktamundashmi gangui!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Shina nikimi Pedroga, “Ñuka llagmakiga Dios llakichichun, ¡kanguna nigushka k'aridaga nalladi rijsinichu! Diosbish yachunmi,” ningu kallarigujllabidimi, ");
INSERT INTO qxl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ishki kutin gallo cantuga. Chibimi Pedroga, “Narij ishki kutin gallo cantujllabidimi kinsa kutin <Na rijsinichu> ninguimi,” nisha Jesús nishkada yuyariga. Shinushami manchanaidi wakuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ña p'unllayaguki manduj curagunaga yuyijkunan, Moisés mandashkada yachachijkunan, israelgunada mandujkunaj tandanukushkagunanbish yuyarinukungu tandanukushaga Jesusta watusha pushusha Pilatomu kugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatoga, “¿Kanchu israelgunaj jatun manduj gangui?” nisha tapuga. Shina niki Jesusga, “Kanlladimi ningui,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Manduj curaguna kaida chaida juchachiguki ");
INSERT INTO qxl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoga kutinlladi, “¿Nachu imash ningui? Manchanai juchachigujkunadaga rikiri,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Shinash Jesusga imadash na nigachu. Pilatoga imada na ni pudisha mancharij shina sakiriga. ");
INSERT INTO qxl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pascua pishta p'unllabimi shuj prezuda genteguna mañashkada Pilatoga kacharij gaga. ");
INSERT INTO qxl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chi p'unllagunami Barrabasga takanukungu jatarisha paiyun wañuchijkunandij carcelbi tiyaga. ");
INSERT INTO qxl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Prezuda kacharij gakimi shujta kacharichun nisha taugalladijkuna Pilatojmu shamusha paida mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Chimunda Pilatoga, “¿Israelgunaj jatun Mandujta kacharichun kangunaga mununguichichu?” niga. ");
INSERT INTO qxl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatoga manduj curagunaga Jesús imalla rurashkamunda p'iñusha paimu kushkadaga yachugami. ");
INSERT INTO qxl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Shinash manduj curagunaga <Barrabasta kacharichun mañunguichi> nisha taugalladijkunamu na alli yuyida kugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chimunda Pilatoga, “¿Kanguna israelgunaj jatun Manduj nishkadaga imadadi rurusha?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Paigunaga, “¡Cruzbi wañuchichun!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatoga, “¿Imadadi na alli rurushka?” niga. Shinash, “¡Cruzbi wañuchichun!” nisha ashtan jinchida kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chimunda Pilatoga alli rikurish nisha Barrabasta kachariga. Shinaidi Jesusta azilgun jinchida takachun mandusha kachushka k'ipaga chakatasha wañuchichun kachuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldadogunaga Pilatoj jatun wasi kanlla ukumu Jesusta pushush rishaga chaishuj soldadogunadashmi tandachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chibimi jatun mandujkuna jawalla churana yana puka churanada Jesusmu p'achallichisha coronada kashan rurusha umabi churachigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chi k'ipaga, “¡Israelgunaj Jatun Manduj Jesús, Alli gachun!” nisha kaparingu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Shinaidi kaspin umabi takugusha t'iukushtagaguna. Jatun manduj layamumi Paibuj ñaubuki kungurisha kumurigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jesusta shina asishka k'ipaga yana puka p'achallichishkada paskusha, Paibuj churanalladadi churachisha cruzbi chakatangu pushugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Alejandroj Rufoj taita Simón, Cirene pueblomunda gashami chagramunda chida vueltaki, soldadogunaga Jesusbuj cruzta aparichun mandugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota shuti urkumumi Jesustaga pushush rigaguna. (Gólgota nishaga Uma Tullu nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chibimi Jesusmunga mirran chagrushka vinoda ubiachun nisha kuga, ashtangarin Jesusga mana ubiugachu. ");
INSERT INTO qxl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chi k'ipa Jesustaga chakatagaguna. Jesusbuj churanada <¿Maijinshi japishun?> nisha soldadogunaga paigunapura sorteoda rurusha japinukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesusta chakatagukiga iskun uras tutamundamiga. ");
INSERT INTO qxl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Imamunda wañuchishkada escribishkabiga “ISRAELGUNAJ JATUN MANDUJMI” nishkami tiyaga. ");
INSERT INTO qxl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chibiga ishki shuwagunadami Jesuskun chakatagaguna, shujtaga alli ladumu, chaishujtaga lluki ladumu. ");
INSERT INTO qxl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Shinami Diosbuj Shimibi, “Milli rurujkunanmi tandachishka gaga,” nishkaga p'aktuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Jesusbuj kuchuda rigujkunaga umada kuyuchisha, “Kanwadijka <Diosbuj wasida urmachishash ña kinsa p'unllallabi shayachisha> nij, ¡Kanlladi kishpirisha chi cruzmunda uriki!” nisha litugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Shinaidi manduj curaguna, Moisés mandashkada yachachijkunash Jesusta asinukusha, “Shujkunadaga kishpichigami, ashtan pailladijka na kishpiri pudinchu. ");
INSERT INTO qxl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo, Israelda jatun Manduj cruzmunda uriyachun, ñukuchi rikusha cringaj,” nigaguna. Jesuskun chakatashka tiyajkunashmi Paidaga litugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ña chaubi p'unlla tukuki, kinsa uras tardigama tuki kai llaktaga yana tuta shina tukuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chunga pichka urastami Jesusga tuki jursan jinchida kaparisha, “Eloi, Eloi ¿lama sabactani?” niga. (Ñukuchij shimibiga “Ñuka Dios, Ñuka Dios, ¿imashadi Ñukallada sakigangui?” nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chibi gajkunamunda shujkunaga shina nijta uyushaga, “Uyichi. Eliastami kayagun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chibi gajkunamunda shujka saltusha risha esponjada jayuj vinobi lapujyachisha shuj jatun kaspibi churusha Jesusmu ubiachingu kuchuyashaga, “Sakichi. Rikushun Elías paida cruzmunda uriyachingu shamujchumashkadi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesusga jinchida kaparisha wañugallami. ");
INSERT INTO qxl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Diosbuj wasibi tiyaj velo nishka linsosh jawamunda urimu mañujta chaubibi llikiriga. ");
INSERT INTO qxl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldadogunada mandujka Jesusbuj ñaubukimi shayasha, ña ima laya wañujtash rikushaga, “Paiga Diosbuj Churidimishka,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Shuj warmigunaga Jesusta karumunda rikuguga. Chi warmigunapurabiga Magdala pueblomunda Mariash, k'ipa Jacoboj Jozij mama Mariash, Salomesh chibimiga. ");
INSERT INTO qxl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kai warmigunami Jesusta katish purisha Galilea llaktabi gaki ayudaga. Shinaidi Jesuskun Jerusalén pueblomu rij tauga warmigunashmi chibi gaga. ");
INSERT INTO qxl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Samana p'unlla ña chayamugukiga tukida alli parijana p'unllami gaga. Ña tutayaguki ");
INSERT INTO qxl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","israelguna mandujkuna tandanukushkapuramunda gaj Diosbuj mandanadash shuyaguj Arimatea pueblomunda Jozimi na manchushalla Pilatojmu risha Jesusta ut'kubi churungu nisha mañuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesús ña wañushkada uyusha Pilatoga mancharisha na crishami soldadogunada mandujta kayachun kachushaga <¿Ñachu wañuga?> niga. ");
INSERT INTO qxl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Soldadogunada manduj tukida parlashka k'ipami Pilatoga cuerpoda Jozimu kuga. ");
INSERT INTO qxl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chimunda Joziga shuj lino linsoda randisha Jesusta cruzmunda uriyachisha linson pillushaga rumi k'akabi rurushka ut'kubi wañushkada churuga. Chi ut'kumu waigunadaga shuj ruminmi tapachisha churaga. ");
INSERT INTO qxl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdalamunda María, Jozij mama Mariash maibi churujta rikugugagunami. ");
INSERT INTO qxl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samana p'unlla pasushka k'ipaga Magdala pueblomunda Mariash, Jacoboj mama Mariash Salomesh Jesusbuj cuerpobi k'akungaj nisha k'uilla ashnariguj yuragunada kutashkada randigaguna. ");
INSERT INTO qxl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semana kallari p'unlla tutamundadi indi narij alli llujshijllabidi pambushka ut'kumu rigushaga, ");
INSERT INTO qxl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“Pambushka ut'kuda tapushka rumidaga ¿pishi t'angusha anchuchinga?” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jawada rikushaga chi jatun rumi ña na chi pushtubi tiyajtami rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pambushka ut'kumu waigushaga shuj musu sundij yuruj churanada churushka alli ladubi tiyajta rikusha warmigunaga manchariga. ");
INSERT INTO qxl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Shina manchariki paiga, “Ama mancharichichu. Kangunaga chakatasha wañuchishka Nazaret pueblomunda Jesustami mashkanguichi. Paiga kausarishkami. Ña na kaibichu. Churushka pushtubi rikichilla. ");
INSERT INTO qxl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yachagujkunamush Pedromush, ‘Paiga Galilea llaktamu kangunada ñaubusha ringa. Pai nishka layaidi chibimi rikunguichi,’ ningu richi,” niga. ");
INSERT INTO qxl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Shina nikimi warmigunaga manchin ch'ujchurisha ut'kumunda llujshigaguna. Manchimundaga pimush imadash na nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semana kallari domingo p'unlla puzu puzudi Jesús kausarishka k'ipa kanchis ayada llujshichishka Magdala pueblomunda Mariamumi primeroga rikuriga. ");
INSERT INTO qxl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Paimi Jesuskun purijkunamu yachi chayachingu riga. Paigunaga Jesusmunda llakirisha wakagugaguna. ");
INSERT INTO qxl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Paigunaga chi warmi <Jesús kausagunmi. Rikuganimi> nishkadash na crigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kai k'ipaga ishki yachagujkuna pueblomunda llujshisha chagra pambamu rij ñanda riguki Jesusga shuj laya tukusha rikuriga. ");
INSERT INTO qxl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Paiguna chaishujkunamu <Rikuganchimi> nigukish, paigunadash na crigagunachu. ");
INSERT INTO qxl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chi k'ipaga chunga shuj yachagujkuna mezabi tiyaki Jesusga rikuriga. Shina rikurishaga <Kausarishkami> nisha shujkuna nigukish paiguna jinchi shunguda charisha na crishkamunda rimaga. ");
INSERT INTO qxl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesusga, “Kai pachabi tiyaj llaktagunamu risha tukigunamu kishpichina Alli Shimida parlungu richi. ");
INSERT INTO qxl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Maijinsh crisha bautizarijka kishpichishkami ganga. Na crijka juchachisha llakichishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Crijkunaga pish na ruri pudishkagunada rurangu pudinada japinga: Ñukaj shutibi ayagunada llujshichingami. Na yachashka shimigunadash rimaringami. ");
INSERT INTO qxl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Culebragunada makin japingami. Venenoda ubiushash imash na tukungagunachu. Shinaidi ungushkagunaj jawabi makida churuki paigunash alliyangami.” ");
INSERT INTO qxl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Shina nishka k'ipaga Mandaj Jesusga jawa pachamu pushushka gasha Diosbuj alli ladubimi tiyariga. ");
INSERT INTO qxl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yachagujkuna tuki llaktagunabi Diosbuj Shimida parlungu rigaguna. Shinaidi Manduj Jesusga paigunada ayudasha paiguna pi na ruri pudishkagunada rurushkamunda Paibuj shimi shina gashkada rikuchiga.");
INSERT INTO qxl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kai ñukuchipurabi ima tukushkagunadaga taugagunami kallarisha escribingu munugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kallarimunda paigunaj ñawin rikusha Alli Shimida parlachun mingushkagunami ñukuchimush yachachishka, Jesús tuki alli rurashkagunadash parlushka. ");
INSERT INTO qxl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Chimunda k'uyashka Teófilo, ñukash kallarimunda tuki imalla tukushkada alli tapusha kanmu yachachishkaga na llullashka gashkada ñukamu alli rikuriki alli yachachunmi escribiguni. ");
INSERT INTO qxl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea llaktada jatun manduj Herodes mandaguki, ñauba Abiasbuj curagunaj parti Zacarías shuti curami tiyaga. Paibuj warmi Elisabetbish ñauba Aarón curaj wawagunaj wawamiga. ");
INSERT INTO qxl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paiguna ishkindij Diosbuj ñaubuki alli kausajkuna gashkamunda pish na juchachi pudishkachu. Manduj Dios mandushkadash yachachishkadash tukida kazusha alli rurujkunamiga. ");
INSERT INTO qxl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet na wachuj gashkamunda marada na charigagunachu. Paigunaga ña yuyijkunamiga. ");
INSERT INTO qxl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Shuj p'unlla Zacariasbuj parti curaguna Diosbujta rurana p'unllaguna chayamuga. ");
INSERT INTO qxl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Curaguna israelgunaj Diosbuj wasibi rurana p'aktukiga <¿Maijinbujshi urmunga?> nisha sorteoda rurugaguna. Shina ruraki Manduj Diosmu ch'ikanyachishka ukumu waigusha inciensoda rupachinaga Zacariasbujmi urmuga. ");
INSERT INTO qxl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Inciensoda rupachigukiga tuki kanllabi gajkunaga Diosta mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Shina mañagukiga Zacarías inciensoda rupachigushka altar alli ladubi Manduj Dios kachushka ángel shayariga. ");
INSERT INTO qxl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chi angelda rikusha Zacariasga sustoidi mejor manchariga. ");
INSERT INTO qxl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Shina manchariki angelga, “Zacarías, ama mancharichu. Kan mañashkada Diosga uyushkami. Kambuj warmi Elisabetga k'ari maradami mirunga. Paidaga Juanchuda shutichingui. ");
INSERT INTO qxl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kan manchanaidimi kushiyangui. Pai wacharikiga taugagunash kushiyanga. ");
INSERT INTO qxl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Manduj Diosbuj ñaubuki kambuj churiga jatun nishkami ganga. Paiga vinoda tragodash na ubiungachu. Mamaj iksabi tiyajllabidimi Diosbuj Espíritu jundashka ganga. ");
INSERT INTO qxl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Paiga tauga israelgunadami Manduj Diosmu vueltachinga. ");
INSERT INTO qxl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juanchuga Mandujta ñaubusha Dios nishkada parlaj Elías layaidi Diosbuj Espiritun podergunbishmi ringa. Chimundami taitagunash maragunan kutin alli apanukuchun alli shunguda rurunga. Na kazujkunadash alli rurana yuyillan imadash alli kazuna yuyidashmi kunga. Shina rurukimi Kishpichijta japichun parijaki alli tukungaguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ángel shina niki Zacariasga kashna tapuga, “Ñukash ñuka warmish yuyijmi ganchi. ¿Ima layadij kan parlushka p'aktanadaga yachashari?” ");
INSERT INTO qxl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Shina niki angelga, “Ñukaga Diosbuj ñaubuki Paibujta ruruj Gabrielmi gani. Paimi kanmu kai alli shimigunada parlachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pailladimi Pai munushka p'unllabi p'aktachinga. Ñuka parlushkada na crishkamunda, upami tukungui. Ñuka parlushka p'aktana p'unllagamami imadash na rimi pudinguichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Shina ukubi parlanukugukiga kanllabi gajkunaga <Diosbuj ukumunda ¿imashadi Zacariasga na ut'ka shamun?> nisha tapurisha shuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías llujshishaga upa sakirishkamunda ima tukushkadash makillan señasta rurusha rikuchiga. Shina na parli pudikiga <Diosbuj ukubimi sueñobi laya imadash rikushkanga> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Diosbuj wasi ukubi pai rurana p'unllaguna tukuriki, Zacariasga wasimu riga. ");
INSERT INTO qxl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chi k'ipa Elisabetga iksa charij tukuga. Chimunda pichka killada wasimunda na llujshigachu. ");
INSERT INTO qxl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Na miruj gakish ñukada Mandaj Dios k'uyasha kashna rurushkada genteguna rikusha ña valichinga,” nisha parlaga. ");
INSERT INTO qxl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet iksa charij tukushka sujta killabiga Diosga Paibuj ángel Gabrielda Galileabi tiyaj Nazaret pueblobi ");
INSERT INTO qxl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pi k'arinbish na purij Mariamu kachuga. Paiga Rey Davidbuj familiamunda Jozinmi kazarangu ari ninukushka gaga. ");
INSERT INTO qxl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelga María tiyashkamu waigusha, “Kushi gai, tuki warmimunda Dios agllashka gasha. Mandaj Diosga kangunmi gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ángel rikurisha, shina niki, Mariaga mejor manchariga. <¿Ima nishadij shina nin?> yuyaga. ");
INSERT INTO qxl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chimunda angelga, “María, ama mancharichu. Kandaga Diosmi mejor k'uyusha agllaga. ");
INSERT INTO qxl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iksa charij tukusha shuj churidami charingui. Paidaga Jesusta shutichingui. ");
INSERT INTO qxl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Paiga jatun allish Jatun Mandaj Diosbuj Churish nishkami ganga. Mandaj Diosga Paidaga ñauba Rey David-da shina jatun mandajta ruranga. ");
INSERT INTO qxl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paiga israelgunada na tukuribujta mandagungallami. Pai mandanaga na tukuringachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María angelda tapuga, “¿Ima layamundadi shina tukusha? Pi k'arinbish na purij ganiga.” ");
INSERT INTO qxl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Shina niki ángel kashna niga, “Diosbuj Espirituga Jatun Mandaj Diosbuj podergun kambuj jawamu p'uyu layami shamunga. Shinusha, chi wacharina maraga jucha illuj, Diosbuj Churi nishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kambuj familia Elisabetbish yuyij gashash, na miruj nishka gashabish ñami sujta killada iksa charij gan. ");
INSERT INTO qxl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diosmunga na ruri pudinaga na tiyanchu.” ");
INSERT INTO qxl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chimunda María niga, “Kan nishka shina, Manduj Dios ñukada rurachunlla, ñukaga Paibujta rurajmi gani.” Shina nikiga angelga rigallami. ");
INSERT INTO qxl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chi p'unllaguna Mariaga Judea llaktabi tiyaj urku kuchu pueblomu ut'kada riga. ");
INSERT INTO qxl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacariasbuj wasimu risha Elisabetda <¿Tiyanguichu?> nisha waiguga. ");
INSERT INTO qxl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Shina nishkada Elisabet uyunmi paibuj mara iksa ukubi kushilladi kuyuriga. Chimundami Elisabetga Diosbuj Espíritu junda tukuga. ");
INSERT INTO qxl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chimunda, kushiyasha jinchida rimarishaga, “Kanga tuki warmigunada yalli, Dios alli nishkami gangui. Kan mirana churish Dios alli nishkami gan. ");
INSERT INTO qxl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ñukaj Mandujbuj mama rikungu shamuchunga ñukaga imash na ganichu. ");
INSERT INTO qxl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kan rimarishkada uyunmi ñuka maraga kushilladi iksa ukubi kuyuga. ");
INSERT INTO qxl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mandaj Dios nishka p'aktanada crishkamunda kushiyachishkami gangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chimunda Mariaga, “Ñukaga tuki shungunmi Mandaj Diosta <Allimi gangui> nini,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Ñukaj espiritush ñukada Kishpichij Diosmunda kushiyanmi. ");
INSERT INTO qxl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ñuka tukimunda imabuj na sirvij gakish Dios agllashkamunda tukiguna kununmunda pacha k'ipa wacharijkunashmi <Kushichishkami gangui> ningaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diosga tukida ruri Pudij gashami jatun alligunada ñukamu kashna rurashka. ¡Paibuj shutiga linshulladimi! ");
INSERT INTO qxl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diosta manchusha alli kazugujkunadaga Paiga sarunbish kununbish k'ipa kausujkunadash llakigungallami. ");
INSERT INTO qxl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Paiga imadash tuki podergun ruraj gashami, jatun tukushkaguna ‘Rurushun’ nishkagunadash rurachun na sakiga. ");
INSERT INTO qxl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jatun mandujkunada paigunaj tiyanamunda llujshichisha imash na gajkunadami valichiga. ");
INSERT INTO qxl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Imadash na charij yarijin gajkunamu kuga. Charijkunadaga imash illujtami kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ñuka ñauba taita Abrahamdaga <Kandash kambuj wawagunaj wawagunadash na tukuribuj llakishami> nishkadaga na kungarishalla Diosga Paida sirvij israelgunadaga ayudaga.” ");
INSERT INTO qxl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaga kinsa killa shinadami Elisabetgun kausaga. Chi k'ipa wasimu riga. ");
INSERT INTO qxl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet mirana p'unlla p'aktakiga k'ari maradami miruga. ");
INSERT INTO qxl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chida yachasha <Manduj Diosmi kanda alli rurashka> nisha vezinogunash familiagunash paiyun kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pusuj p'unllayuj marada circuncisión nishkada rurachingumi rigaguna. Chi maradaga yayunbuj shuti Zacarías shutida churungu munagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamunga, “¡Mana! Juanchumi ganga,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Shina nikimi, “Kangunapurabiga pish na chi shutidaga charingandi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chimunda maraj yayunda ima shutida churasha nishkada makin señasta rurusha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Maraj yayunga shuj uchilla tablada mañusha, “Paibuj shutiga Juanchumi ganga,” nisha escribiga. Shinada rikushami tukiguna manchariga. ");
INSERT INTO qxl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarías shimi watushka shina gashkada Dioslladi parlachiki ñash kutin parlungu kallarishaga Diosta <Kanga allimi gangui> niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tuki vezinoguna manchariga. Shina tukushkada parlanukukiga Judea llakta urkuguna kuchubi kausajkunash shimi shimi parlagugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tuki mashnalla uyujkunaga, “Kai mara jatunyashaga ¿imashi ganga?” nisha tapunukugaguna. Kai maradaga Mandaj Diosmi Paibuj makin chapaguga. ");
INSERT INTO qxl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Juanchuj taita Zacariasga Diosbuj Espíritu jundashka gashami Diosmunda parlushaga, ");
INSERT INTO qxl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israelgunaj jatun Manduj Dios, Kambuj gentegunada randisha kishpichingu shamushkamunda Kanga <Alli> nishka gachun. ");
INSERT INTO qxl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kambujta ruraj Davidbuj familiamunda jatun Kishpichijta ñukuchimu kachugangui. ");
INSERT INTO qxl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ñaubamundadimi Kan nishkada parluj allida rurujkunamu parlushka shina, ");
INSERT INTO qxl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","<Kangunada p'iñujkunamundash shungun manchanaidi na rikunachijkunamundash kishpichishami> nishkangui. ");
INSERT INTO qxl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ñukuchij ñauba taitagunadash Kanmi llakishkangui. Na kungarishalla, Kan Ari nishkagunada p'aktachigushkangui. ");
INSERT INTO qxl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ñukuchij taita Abraham-mu, <P'aktachishami> nishkaga kaimi gan: ");
INSERT INTO qxl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ñukuchidaga imadash na manchushalla Kambujta rurachunmi ñukuchida p'iñujkunamunda <Kacharichishami> nishkangui. ");
INSERT INTO qxl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ñukuchij tuki kausibi Kambuj ñaubuki alli linshu gasha allida rurachunmi munashkangui. ");
INSERT INTO qxl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ñuka k'uyashka churi, kanga Jatun Mandaj Dios nishkada parlaj nishkami gangui. Kanmi Kishpichijta ñaubusha ñanda parijasha ringui. ");
INSERT INTO qxl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dios juchagunada perdonaj kishpichijkish gashkadaga israelgunamu yachachijmi gangui. ");
INSERT INTO qxl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ñukuchij Diosmi mejorda llakishkamunda, p'unllayachij shinada, kishpichinada jawa pachamunda kachunga. ");
INSERT INTO qxl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Diosga yanamangabi ashtan manchanaidi yanamangabi kausujkunamu luzta kungaj shinaidi ñukuchida k'uilla kausij ñanbi pushangukishmi shamunga,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chi maraga Taita Diosmunda alli yachajmi iñasha israelgunamu parlana p'unlla chayungama shitushka pushtubimi kausuga. ");
INSERT INTO qxl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chi p'unllagunami Roma llaktada jatun mandaj Augusto Cesarga tuki pai mandashka kausajkunada paigunaj shutida apuntachichun manduga. ");
INSERT INTO qxl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kai kallari censobiga Cireniomi Siria llaktada mandaguki rurariga. ");
INSERT INTO qxl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tukigunami ñauba taitaguna kausashka llaktabi paigunaj shutigunada apuntachingu riga. ");
INSERT INTO qxl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jozish Galileabi tiyaj Nazaret pueblomunda, Davidbuj familia gasha, Rey David wacharishka Judea llaktabi tiyaj Belén pueblomu riga. ");
INSERT INTO qxl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Paibuj warmi gana Mariandijmi shutida apuntachingujka chi pueblomu riga. Mariaga iksa charijmiga. ");
INSERT INTO qxl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Paiguna Belenbi gaki, María mirana p'unlla p'aktuga. ");
INSERT INTO qxl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pozada wasi na p'aktushkamundami paibuj ligítimu churidaga wagraguna shayana ukubi miruga. Maradaga maitusha wagra mikuna cajonbimi sirichiga. ");
INSERT INTO qxl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén kuchubimi michijkunaga ovejagunada chapusha pakariguga. ");
INSERT INTO qxl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Manduj Diosbuj ángel rikurisha Manduj Diosbuj jatun k'uilla gashkaga muyundijta p'unlla laya p'alaniki mejor mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angelga kashna niga, “¡Ama mancharichichu! Ñukaga tukigunada manchanaidi kushiyachina alli shimigunadami kangunamu parlungu shamuni. ");
INSERT INTO qxl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kununmi Rey Davidbuj pueblobi kangunada Kishpichij wacharishka. Paiga Dios agllasha kachashka Mandaj Cristomi gan. ");
INSERT INTO qxl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Paidaga wagra mikuna cajonbi maitushka sirijtami japinguichi. Chi marada rikushaga pai gashkada yachanguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Shina niguki, ashtan tauga angelguna ñash rikurisha, chi angelgun Diosta alabasha kashna nigaguna, ");
INSERT INTO qxl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Jawa pachabi gaj Diostaga <Kanga alli k'uilladimi gangui> nichun. Kai pachabi kausajkunash Dios k'uyashkaguna gashkamunda k'uilla kausida charichun.” ");
INSERT INTO qxl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelguna jawa pachamu vueltashka k'ipaga michijkuna kaishuj chaishuj, “Ima tukushkada Mandaj Dios parlashkada rikungu Belenmu jakuchi,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ut'ka rishaga Jozida Mariadash mara wagra mikuna cajonbi sirijta japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Marada rikushaga ángel maramunda imada nishkada parlagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Michijkuna parlashkada uyashaga tukigunami mancharisha kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaga tuki uyashkada shungubi wakichisha na kungarishallami yuyin puriga. ");
INSERT INTO qxl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Michijkuna paigunamu parlashka shina tukida uyushkamundash rikushkamundash Diosta, “¡Jatun allimi gangui!” nisha vueltagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pusuj p'unlla tukukimi mara Jesusta israelguna mandashkada p'aktachingu nisha circuncisión nishkada rurachigaguna. Mariamu narij iksa charij tukujllabidi ángel nishka shinaidimi Jesús shutida shutichigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Mara Jesusta apusha Manduj Diosmu mingangu Jerusalén pueblobi Diosbuj wasimu rigaguna. Mirushka k'ipa linshu rikurina p'unllaguna p'aktakimi Manduj Dios mandusha apuntachishkabiga, “Tuki kallarimu charishka churigunaga Manduj Diosbujlla ch'ikanyachishkami ganga,” nisha Moisés mandushkada ruragaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Manduj Dios mandushkabi nishka shina, “Ishki urpida na gashaga ishki wawa palomada wañuchisha Diosmu kungui,” nishkada p'aktachingumi rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chi p'unllagunabi Simeonga Jerusalenbi kausaga. Paiga alligunaida rurusha Diosta kazusha kausashkamundami israelgunada Kishpichij shamunada shuyaga. Diosbuj Espíritu Simeonbi gasha, ");
INSERT INTO qxl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","kashna yachachiga, “Mandaj Dios agllasha kachashka Cristoda rikungama kanga na wañunguichu,” nisha. ");
INSERT INTO qxl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dios mandashkada p'aktachingu nisha taita mamaga mara Jesusta Diosbuj wasimu apusha riki Diosbuj Espíritu Simeonda chimu pushaga. ");
INSERT INTO qxl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonga marada markusha Diosta alabasha kashna niga, ");
INSERT INTO qxl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tukida ruri Pudij Mandaj Dios, kan <Kusha> nishkadaga ñami p'aktachishkangui. Ñuka ñawin Kishpichijta rikushkamunda Kambujta rurajtaga kununga kushilla wañuchun sakibailla. ");
INSERT INTO qxl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Paidaga tuki llakta rikuki p'aktachingumi kallarishkangui. ");
INSERT INTO qxl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Paiga luz shinami ganga, na israelgunamush kishpichinada rikuchingu israelgunada <Allimi ganguichi> nichun.” ");
INSERT INTO qxl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jozish Jesusbuj mamash maramunda Simeón ima nishkada uyusha mancharishash kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeonga paigunamu alligunada kuchun nishka k'ipa, Jesusbuj mama Mariada kashna niga, “Riki, kai maraga tauga israelgunada jatarichingu na gashaga urmachingu kachushkami gan, shinaidi taugaguna na rikunachinabujmi ganga. ");
INSERT INTO qxl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Shina p'iñaki paigunaj shungubi ima yuyashkash yacharingami. Kambuj espirituda shuj espada laya pasunga.” ");
INSERT INTO qxl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Shinaidi Ana yuyij warmishmi tiyaga. Chi warmiga Dios nishkada parlujmi. Paiga Aserbuj familiamunda Fanuelbuj ushimiga. Paiga soltera tukunmi kazaraga. Kusanga kanchis watalladami kausaga. ");
INSERT INTO qxl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chimundaga kusa wañugami. Anaga pusuj chunga chusku (84) watadami chariga. Chi warmiga Diosbuj wasimundaga na llujshishalla, tutash p'unllash Diosbujta rurusha, wakin p'unllaga na mikushalla Diosta mañusha kausajmiga. ");
INSERT INTO qxl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anash ñash chayushaga Diosta <Diosolopai> ningu mashnalla Jerusalenda Kishpichijta shuyajkunamush chi mara Jesusmunda parlungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mandaj Dios mandushkada tukida p'aktachishka k'ipami Joziga Mariandij Galilea llaktamu paiguna kausana Nazaret pueblomu vueltamuga. ");
INSERT INTO qxl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dios alligunada kushkamundami mara Jesusga alli jinchi iñusha mejor yachaj gaga. ");
INSERT INTO qxl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesusbuj taita mamaga watandijta Jerusalén Pascua pishtamu ichiyajkunaga. ");
INSERT INTO qxl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chimunda Jesusga chunga ishki watada p'aktachisha tukigunandij pishtamu riga, paiguna rurujkuna gashka layadi. ");
INSERT INTO qxl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pishta tukurishka k'ipa wasimu vueltamugusha, mamash taitash na yachujllabi, mara Jesusga Jerusalenbi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","<Kai shamujkunanmi shamunga> yuyusha shuj p'unllada rigaguna. Chi k'ipa familiagunada rijsishkagunadash tapusha mashkashash ");
INSERT INTO qxl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","na japigagunachu. Kutinmi Jerusalenmu vueltasha mashkungaj rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kinsa p'unllada mashkagushkan Jesustaga Diosbuj wasibi Moisés mandushkada yachachijkunaj chaubibi uyasha tapusha tiyajta japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tuki uyujkuna imada tapushkadash Pai yalli yachushkada rikusha mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Paibuj taita mamaga chibi tiyajta rikusha kushiyasha manchariga. Mama niga, “Ñuka Churi ¿ima nishadij ñukuchidaga kashna rurangui? Kambuj taitash ñukash llakilladimi mashkashkanchi.” ");
INSERT INTO qxl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Shina niki Jesús kashna niga, “¿Imashadi Ñukadaga mashkaganguichi? ¿Nachu Ñuka Taitaj wasibi ganashkada yachanguichi?” ");
INSERT INTO qxl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Paigunaga Jesús imamunda shina nishkadash na intindigachu. ");
INSERT INTO qxl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chi k'ipa paigunan Nazaretmu vueltamuga. Chibi tukida kazusha kausuga. Paibuj mamaga kai tukida shungubi wakichisha na kungarishalla yuyin puriga. ");
INSERT INTO qxl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesusga iñasha yachasha katiga. Diosbish gentegunash alli nishkami kausaguga. ");
INSERT INTO qxl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chunga pichka watada Roma llaktada jatun manduj Tiberio César tuki llaktada mandaguki Judea llaktaj Gobernadorga Poncio Pilatomiga. Herodesga Galilea llaktabi, paibuj wauki Felipega Itureadash Traconitedash mandaguga; Lisaniasbish Abiliniada mandaga. ");
INSERT INTO qxl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasbish Caifasbish jatun manduj curagunamiga. Chi p'unllagunabi Zacariasbuj churi Juanchumu shitashka pushtubi Diosbuj Shimi chayaga. ");
INSERT INTO qxl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juanchuga tuki Jordán jatiyaku kuchulla llaktabi parlashaga <Juchagunada sakisha Diosmu kuchuyasha bautizarichi. Diosga juchagunada perdonangami> kashna niga. ");
INSERT INTO qxl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dios nishkada parluj ñauba Isaías escribishaga kashna nisha, “Shitushka pushtubi kaparijka uyarigun, ‘Mandujbuj ñanda derecho rurusha alli parijichi, ");
INSERT INTO qxl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tuki waikuguna, urkuguna, lomagunash pamballada rurashkami ganga. Ishtu ñanguna dirichashka, pugru ñangunash layashkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tuki kai pachabi kausajkunaga Dios kishpichij gashkadami rikunga,’ ” nishkami p'aktuga. ");
INSERT INTO qxl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Taugalladi bautizaringu shamujkunada Juanchu niga, “Culebra shina, millida rurajkunaminguichi. Dios p'iñarisha llakichina shamunamunda <Kangunaga kishpiringuichimi> nishaga ¿pidi parlagari? ");
INSERT INTO qxl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kangunaga juchagunada sakisha Diosmu kuchuyashkada rikuchingujka alli p'ukuj granu shina allida rurusha rikuchichiri. ‘Ñauba Abrahambuj wawagunami ganchi’ nisha ama nichichu. Ñukaga ninimi, Diosga kai rumigunada Abrahambuj wawagunada rurunmullami. ");
INSERT INTO qxl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yurada angundi p'itingu jacha ña tiyanmi. Tuki na alli aparij yuragunada shina, gentegunada p'itisha ninabi shitangami.” ");
INSERT INTO qxl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chimunda gentegunaga tapugami, “¿Imadadij rurana ganchi?” nisha. ");
INSERT INTO qxl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pai niga, “Maijin ishki churanada charijka shujtaga na charijmu kuchun; mikunadash charijka na charijmu karachun.” ");
INSERT INTO qxl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Impuestoda cobrajkunash Juanchu bautizachun nisha kuchuyasha kashna tapugaguna, “Yachachij ¿imadadij rurana ganchi?” ");
INSERT INTO qxl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pai niga, “Cobranaida cobrusha, ama yalli cobranguichichu.” ");
INSERT INTO qxl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Guardaguna tapuga, “Ñukuchiga ¿imadadij rurana ganchi?” Juanchu niga, “Ama takusha manchachisha allidi imadash kichichichu. Ama llullusha juchachichichu. Mashnalla ganashkan kushi gaichi.” ");
INSERT INTO qxl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tukiguna shuyashkamunda Juanchudaga, “¿Dios agllusha kachashka Cristomachari?” nisha yuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chimunda Juanchuga tukigunada niga, “Ñukaga yakunllami bautizani. Shuj shamujmi Diosbuj Espiritun ninanbish bautizanga. Paiga ñukadash yalli imadash ruri pudijllami shamunga. Ñukaga Paibuj pargati watashkalladash paskungu na kabinichu. ");
INSERT INTO qxl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Paiga trigoda wairachingu palada Paibuj makibi charisha t'amumunda ch'ikanyachij shinami ruranga. Trigolladami wakichinga. T'amu shinadaga na wañuj ninabi shitashami rupachinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kashna tauga shujtij nishkagunanbish Juanchuga alli shimigunada gentegunamu parluga. ");
INSERT INTO qxl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gobernador Herodestaga paibuj wauki Felipebuj warmi Herodiasta wainayasha tiyashkamundash milligunada rurashkamundashmi Juanchuga rimaga. ");
INSERT INTO qxl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Rimakish Herodesga na allida rurasha katiga, ashtanga Juanchuda carcelbi churaga. ");
INSERT INTO qxl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juanchu tukigunada bautizagusha Jesustash bautizaga. Chi k'ipa Jesús Taita Diosta mañaguki jawa pacha paskarikimi ");
INSERT INTO qxl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Paibuj jawamu Diosbuj Espíritu paloma shina uriyamuga. Chimunda shuj rimarishka jawa pachamunda uyariga, “Kanmi Ñuka k'uyashka Churi gangui. Kanbimi kushiyani.” ");
INSERT INTO qxl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús Diosbuj Shimida parlungu kallarishaga kinsa chunga (30) wata shinadami chariga. Jozibuj churi gashkadami gentegunaga yuyaga. Joziga Elij churimiga. ");
INSERT INTO qxl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliga Matatbuj, Matatga Levij, Leviga Melquij, Melquiga Janaj, Janaga Jozij, ");
INSERT INTO qxl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joziga Matatiasbuj, Matatiasga Amosbuj, Amosga Nahumbuj, Nahumga Eslij, Esliga Nagaibuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiga Maatbuj, Maatga Matatiasbuj, Matatiasga Semeibuj, Semeiga Jozecbuj, Jozecga Judaj, ");
INSERT INTO qxl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judaga Joanaj, Joanaga Resaj, Resaga Zorobabelbuj, Zorobabelga Salatielbuj, Salatielga Nerij, ");
INSERT INTO qxl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriga Melquij, Melquiga Adij, Adiga Cosambuj, Cosamga Elmadambuj, Elmadamga Erbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erga Josuej, Josuega Eliezerbuj, Eliezerga Jorimbuj, Jorimga Matatbuj, Matatga Levij, ");
INSERT INTO qxl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leviga Simeonbuj, Simeonga Judaj, Judaga Jozij, Joziga Jonanbuj, Jonanga Eliaquimbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimga Meleaj, Meleaga Menaj, Menaga Matataj, Matataga Natanbuj, Natanga Davidbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidga Isaíbuj, Isaíga Obedbuj, Obedga Boozbuj, Boozka Salmonbuj, Salmonga Naasonbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonga Aminadab-buj, Aminadabga Adminbuj, Adminga Arambuj, Aramga Esrombuj, Esromga Faresbuj, Faresga Judaj, ");
INSERT INTO qxl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaga Jacob-buj, Jacobga Isaacbuj, Isaacga Abrahambuj, Abrahamga Tarej, Tarega Nacorbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorga Serugbuj, Serug-ga Ragaubuj, Ragauga Pelegbuj, Peleg-ga Heberbuj, Heberga Salaj, ");
INSERT INTO qxl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaga Cainanbuj, Cainanga Arfaxadbuj, Arfaxadga Sembuj, Semga Noej, Noega Lamecbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecga Matusalenbuj, Matusalenga Enocbuj, Enocga Jaredbuj, Jaredga Mahalaleelbuj, Mahalaleelga Cainanbuj, ");
INSERT INTO qxl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanga Enosbuj, Enosga Setbuj, Setga Adanbuj, Adanga Diosbuj churimiga. ");
INSERT INTO qxl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesusga Diosbuj Espíritu jundashka gashami, Jordán jatiyakumunda vueltamuki Paidaga Espíritu shitashka pushtumu pushaga. ");
INSERT INTO qxl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chibi chusku chunga (40) p'unllada puriki diablo pandachingu munaga. Chi p'unllaguna na mikushkamunda Jesusga yarijachigami. ");
INSERT INTO qxl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shina puriguki diabloga Jesusta kashna niga, “Kan Diosbuj churidij gashaga kai rumida <Tanda tuki> niri.” ");
INSERT INTO qxl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Shina nikimi Jesusga, “Diosbuj Shimibiga ninmi, ‘Gentegunaga na tandallanga kausangachu, ashtanbish tuki Diosbuj Shiminbishmi kausan,’ ” niga. ");
INSERT INTO qxl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Diabloga urku jawamu Jesusta pushasha riga. Chimunda kai pachabi tiyaj tuki llaktagunada ñash rikuchisha ");
INSERT INTO qxl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kashna niga, “Tuki llaktagunada mandachun imalla tiyashkadash kushami. Kaigunadaga ñukami japishkani; ñuka <kusha> nishkamunmi kusha. ");
INSERT INTO qxl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kan ñukada kungurisha <Allimi gangui> nikiga tuki Kambujmi ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Shina nikiga Jesusga niga, “Anchi kaimunda, Satanás. Diosbuj Shimibiga kashnami nin ‘Kambuj Manduj Diosllada <K'uilladimi gangui> nisha Pai nishkallada rurangui.’ ” ");
INSERT INTO qxl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Diabloga Jesusta Jerusalén pueblomu pushusha Diosbuj wasi jawamundi shayachisha kashna niga, “Kan Diosbuj Churidij gashaga kaimunda pambamu urmi. ");
INSERT INTO qxl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diosbuj Shimibiga kashnami nin, ‘Dios Paibuj angelgunada kanda chapachun kachungami. ");
INSERT INTO qxl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kambuj chaki rumibi ama takarichun paigunaj makin chariringami.’ ” ");
INSERT INTO qxl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Shina niki Jesusga, “ ‘Kambuj Manduj Diostaga p'aktachij na p'aktachijta rikungu ama munanguichu,’ ninmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ña diabloga ima shina na juchada rurachingu pudishaga shuj p'unllagunaj sakisha rigallami. ");
INSERT INTO qxl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesusga Diosbuj Espirituj podergun Galilea llaktamu shamuga. Chi llaktabish kuchubi gajkunash Paimunda parlanukuga. ");
INSERT INTO qxl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Diosmunda yachana wasibi Jesús yachachiguki tukiguna Paida <Allimi gangui> niga. ");
INSERT INTO qxl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesusga Pai iñashka Nazaret pueblomu riga. Samana p'unlla Diosmunda yachana wasimu rij gasha waiguga. Dios escribichishkagunada liyungu shayariga. ");
INSERT INTO qxl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dios nishkada parluj Isaías escribishkadami liyachun kugaguna. Chida paskushaga kai escribishkadami japiga, ");
INSERT INTO qxl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Manduj Dios agllashkamundami Paibuj Espíritu Ñukabi gan. Parlachun kachashkami gani. Imadash na charijkunada alli shimigunada parlachun, prezu tiyajkunada kacharichichun, na rikujkunada rikujta rurachun, llakichishka kausujkunada kacharichij shina rurachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mandaj Dios perdonana p'unlla chayamujta parlachun kachashkami gani.” ");
INSERT INTO qxl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesusga libroda pilluchishka k'ipaga Diosmunda yachana wasibi ayudajmu kusha tiyariki tukigunami Jesusta rikuriaga. ");
INSERT INTO qxl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chimunda Paiga kashna parlungu kallariga, “Kai escribishkada liyashkaga kununlladimi kanguna uyaki p'aktushka.” ");
INSERT INTO qxl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesusga k'uidi uyanaidi shimigunada parlaki, “Allidami parlun,” nisha tukiguna mancharisha, “¡¿Paiga nachu Jozij churi gan?!” nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chimunda Jesús kashna niga, “Kanguna nij gashka shina Ñukada kashnash ninguichimami ‘¡Jambij gashaga kanlladi jambiriri! ¡Capernaúm pueblobi rurushkada ñukuchi uyushka layada kai kambuj llaktabish ruriri!’ ” ");
INSERT INTO qxl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Shina nisha katigusha kaidash niga, “Kabishkadadimi nini, ni maijin Dios nishkada parlujkish kikinbuj llaktabiga na valichishkachu gan. ");
INSERT INTO qxl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kashnamiga Dios nishkada parluj Elías parli p'unllagunabish, tauga viudagunash Israel llaktabi kausaga. Kinsa wata chaubida na tamiaki manchanai yarijibish tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Shinash Diosga Eliastaga israel viudagunajmunga na kachugachu, ashtan Sidón pueblo kuchubi tiyaj Sarepta pueblo viudajmumi kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dios nishkada parluj Eliseoj p'unllagunash Israel llaktabiga aichada ismuchij unguin ungushkagunaga taugagunami tiyaga. Pidash na alliyachigachu, ashtan Siria llaktamunda Naamán k'arilladami alliyachiga.” ");
INSERT INTO qxl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Shina nishkada uyushaga tukiguna Diosmunda yachana wasibi gajkunaga manchanaidi p'iñariga. ");
INSERT INTO qxl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chimunda jatarishaga Jesusta Nazaret pueblomunda llujshichishtasha jawa urkumu pushasha waikumu t'angushtangu rigaguna. Chi puebloga urkubimi tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Shina rigukish Jesusga paigunaj chaubida pasusha rigallami. ");
INSERT INTO qxl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Galileabi tiyaj Capernaúm pueblomu Jesús riga. Chibimi samana p'unllaga gentegunamu yachachiga. ");
INSERT INTO qxl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Paiga tukida yachasha mandaj laya allida yachachishkamunda mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Diosmunda yachana wasibi yana katishka tiyaga. Paiga jinchilladadi kapariga, ");
INSERT INTO qxl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nazaretmunda Jesús, ñukuchimuga ¿imadadi rurash ningui? ¿Imashadi ñukuchida tukuchishtangu shamungui? ¡Sakibai! Kan Diosmundash jucha illuj gashkadaga ñukaga yachanimi.” ");
INSERT INTO qxl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chimunda Jesusga yanada rimuga, “Upalli. Paimunda llujshi,” nisha rimaki yanaga paida tukigunaj ñaubuki pambabi pigusha, na chugrichishalla llujshigallami. ");
INSERT INTO qxl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tuki chibi rikujkuna mancharisha kushiyasha, kaishuj chaishuj, kashna ninukugaguna, “Paibuj rimashkabiga ¿imadi tiyun? Imadash ruri pudishkan na manchushalla, yanagunadash rimusha llujshichinllami.” ");
INSERT INTO qxl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús shina rurushkada tuki chi llaktagunabi parlanukuga. ");
INSERT INTO qxl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesusga Diosmunda yachana wasimunda llujshishaga Simonbuj wasimumi waiguga. Simonbuj suegrami rupuj unguin wañujti siriki Jesusta, “Alliyachibai,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús ungushkaj kuchubi kumurisha, “¡Rupuj ungui, anchi!” nikiga ñash alliyashaga jatarisha paigunamu karungu kallarigallami. ");
INSERT INTO qxl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Indi waigujta tuki laya ungushkagunada Jesusbujmu pushamugaguna. Jesusga tukigunaj jawabi makida churusha alliyachigallami. ");
INSERT INTO qxl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ungushkagunajmunda yanaguna llujshishaga, “Kanga Diosbuj Churimi gangui,” nisha kaparigaguna. Shina kapariki Jesusga, “Upallichi,” niga. Dios agllusha kachushka Cristo gashkada yachashkamundami paigunadaga kaparichunga na sakiga. ");
INSERT INTO qxl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","P'unllayagukimi Jesusga chi pueblomunda llujshisha chulunlla pushtumu riga. Shina rikimi taugaguna Jesusta mashkusha Pai maibi gashkamu chayaga. “Jesús ama maimush richun,” nisha jarkungu munagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús kashna niga, “Ñukaga Diosbuj mandanamunda Alli Shimida parlungu shuj pueblogunamush rinami gani. Ñukaga shina parlachunmi kachashka gani.” ");
INSERT INTO qxl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesusga Judea llaktagunabi tiyaj Diosmunda yachana wasigunabi parlusha riguga. ");
INSERT INTO qxl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Shuj p'unlla Diosbuj Shimida uyangu taugalladijkuna llapinukidimi Jesusmu kuchuyaki Pai Genesaret yaku kucha manyabi gasha ");
INSERT INTO qxl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","chibi ishki chushuj barcagunadami rikuga. Chaulada japijkunaga japinada takshungu uriyashkaga. ");
INSERT INTO qxl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesusga Simonbuj barcabimi sikusha paida, “Yaku manyamunda ashada karuyichi,” niga. Chi k'ipaga barcabi tiyarisha taugalladijkunamu yachachiga. ");
INSERT INTO qxl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachachishka k'ipa Jesusga Simonda niga, “Barcada jundujmu pushi. Chibi chaulada japina red-da shitichi.” ");
INSERT INTO qxl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón niga, “Yachachij, tuki tuta ni shujlladash na japishkanchichu. Shinash kan nishkamunda kutin redgunada shitasha.” ");
INSERT INTO qxl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Shina shitakiga redgunabi junda llikirijtami taugalladi chaulada japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chimunda chaishuj barcabi gajkunada ayudangu shamuchun nisha señasta ruragaguna. Paiguna shamushaga ishki barcallabidimi pambarisha nijta jundachiga. ");
INSERT INTO qxl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kashna rikushami Simón Pedroga Jesusbuj ñaubuki kungurisha, “Juchasapami gani, Mandaj. Kaimunda ribailla,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simonbish chaishujkunash tauga chaulada japishkamundami kushiyasha mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Paigunapuramunda Zebedeoj churi Jacobobish Juanchush Simongun igulda trabajasha purijkunamiga. Jesús Simonda niga, “Ama manchichu. Kununmundaga gentegunadami Ñukamu japingu kallaringui.” ");
INSERT INTO qxl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Shina nikiga barcagunada achpamu apasha chibi tukida sakisha Jesusta katisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús shuj pueblobi gakimi aichada ismuchisha katij lepran illujta ungushkaga kuchuyasha Paida rikushami kungurisha pambagama kumurisha Jesusta, “Mandaj, kan munashaga ñukaj unguida anchuchi pudinguimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chimunda Jesusga, “Ari, munanimi,” nisha Paibuj makin tupasha, “¡Linshuyi!” nikiga ñash leprayujka alliyaga. ");
INSERT INTO qxl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chi k'ipa Jesusga kashna nisha manduga, “P'akta pimush parlanguimu. Ri, curamu rikuringui. Linsharishkamunda Moisés mandashka shina Diosmu kunada apusha ringui. Shinami kambuj lepra ungui anchushkada tukiguna yachunga.” ");
INSERT INTO qxl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ashtangarin Jesús rurashkada p'unllandijta ashtan yachush katigaguna. Taugagunami Pai parlushkada uyungu ungushkagunash alliyangu nisha tandanukuga. ");
INSERT INTO qxl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Shina gakish Jesusga chulunlla pushtugunabi Dioskun parlanukungu rigujllamiga. ");
INSERT INTO qxl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Shuj p'unlla Jesús yachachiguki fariseoguna Moisés mandashkada yachachijkunash Galilea Judea llaktagunabi tiyaj tuki uchilla pueblogunamunda Jerusalenmundash shamusha chibi tiyariga. Jesús ungushkagunada alliyachichunmi Mandaj Diosbuj poder Paibi tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Shina yachachigukimi wandunabi shuj k'arigunaga na kuyurij k'arida wandumusha Jesús tiyagushka wasi ukumu waiguchishaga Paibuj ñaubuki churungu munagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Taugaguna gashkamunda maida na waigui pudishaga jawamu sikusha wasi k'atada ut'kushami chi na kuyurijtaga wandushkanlladi gentegunaj chaubibi Jesusbuj ñaubujmu uriyachigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesusga paigunaj crishkada yachashaga na kuyurijta kashna niga, “Uyi, kambuj juchagunaga perdonashkami gan.” ");
INSERT INTO qxl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Moisés mandashkada yachachijkunash fariseogunash kashna yuyungu kallarigaguna, “Dios tukusha rimaringujka ¿pidikun paiga? ¡Diosllami juchagunada perdoni pudin!” ");
INSERT INTO qxl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Paiguna yuyashkada Jesús yachasha kashna tapuga, “¿Imashadij kangunaga kashna yuyagunguichi? ");
INSERT INTO qxl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Imada ninadij ashtan jawalla ganga? ‘Kambuj juchagunaga perdonashkami gan,’ ¿ninachu? Na gashaga ‘Jatarisha rilla,’ ¿ninachu jawalla ganga?” ");
INSERT INTO qxl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kaidash Jesusga niga, “Aichayuj tukushka Churiga kai pachabi juchagunada perdonana poderda charishkadami rikuchinga.” Nishka k'ipaga chi na kuyurijta kashna niga, “Kandami nini, jatari. Kanda wandumushkada japisha wasimu ri.” ");
INSERT INTO qxl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na kuyurijka tukigunaj ñaubujmunda ñash jatarisha pai sirishka wandumushkada shayachishaga <Dios, Kanga allimi gangui> nisha wasimu riga. ");
INSERT INTO qxl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaida rikusha tukiguna manchanaidi mancharisha, “Pish na ruri pudishkadaga kununmi rikushkanchi,” nisha Diosta <Allimi gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chi k'ipa Jesusga wasimunda llujshigusha Leví nishka Romamu impuestoda cobranabi tiyajta rikusha, “Katimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Shina nikimi Leviga jatarisha tukida sakisha Jesusta katisha riga. ");
INSERT INTO qxl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chimunda paibuj wasibi Jesusmu jatun pishtada ruraga. Chibimi impuestoda cobrajkuna shujkunash paigunan mikungu tiyariga. ");
INSERT INTO qxl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseoguna Moisés mandashkada yachachijkunash paigunapura gasha Jesusbuj yachagujkunada kashna nisha rimungu kallariga, “¿Imashadi impuestoda na alli nishka cobrajkunan chaishuj juchayujkunanbish mikunguichi, ubianguichilla?” ");
INSERT INTO qxl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Shina niki Jesusga kashna niga, “Sanugunaga jambijta na ministinchu. Ungushkagunallami ministin. ");
INSERT INTO qxl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ñukaga kabishkada rurujkunada kayungujka na shamuganichu, ashtangarin juchagunada sakisha Diosmu kuchuyachun nisha juchayujkunada kayungumi shamugani.” ");
INSERT INTO qxl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesusta kashna nigaguna, “Bautizaj Juanchuda katijkunash fariseogunada katijkunash tauga kutin na mikushalla Diosta mañunguna, ashtan kambuj yachagujkunaga ubian mikugujllagunami gan.” ");
INSERT INTO qxl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Shina niki Jesús kashna niga, “¿Kangunaga bodamu shamujkunada <Novio kaibi gakish ama mikunguichi> nisha ayunachun mandanguichimuchu? ");
INSERT INTO qxl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Paigunamunda novioda kichuna p'unlla chayamungami. Chi k'ipaga Ñukaj yachagujkunaga na mikungagunachu.” ");
INSERT INTO qxl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesusga kai yachachinadash parlaga, “Maijinbish mauga churana ut'kurishkabi mushuj churanada p'itisha na p'utyungachu. Shina rurakiga mushuj churanaga llikinmi. Mushujka mauganga na alli rikurinchu. ");
INSERT INTO qxl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Rurushkalla vinodash karan rurushka mauga p'urugunabi na churanchu. Chibi churakiga p'uruda ut'kuchingami. Shina rurakiga vinosh p'urubish chingaringami. ");
INSERT INTO qxl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chimunda rurushkalla vinodaga karan rurushka mushuj p'urugunabi churana gan. ");
INSERT INTO qxl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Maijinsh unida wakichishka vinoda ubiajka ‘K'uilla,’ ninmi. Mushuj vinodaga na munanchu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Samana p'unllada Jesús trigu ukuda riguga. Paibuj yachagujkunaga trigo k'atsuda pilusha makin k'akusha granuda mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Shuj fariseogunaga tapuga, “¿Imashadi kangunaga samana p'unllabi Dios ama rurachun nishkada ruranguichi?” ");
INSERT INTO qxl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Shina niki Jesusga niga, “Davidbish paiyun gajkunash yarijachisha ima rurashkada Diosbuj Shimibi ¿nachu liyashkanguichi? ");
INSERT INTO qxl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Israelgunaj Diosbuj tuldushka wasimu waigusha Diosmu kushka tandagunada curagunalla mikuna gakish Davidga japisha mikusha paiyun gajkunamush karaga.” ");
INSERT INTO qxl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesusga kaidash niga, “Aichayuj tukushka Churiga samana p'unlladash Mandajmi gan.” ");
INSERT INTO qxl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Shuj samana p'unllabi Jesusga Diosmunda yachana wasimu waigusha yachachingu kallariga. Chibimi alli maki chakirishkada charij k'ari tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés mandashkada yachachijkuna fariseogunash samana p'unllabi Jesús alliyachikiga juchachingaj nisha pakalla rikuriagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesusga shina yuyajta yachushami maki chakirishkada niga, “Jatarisha chaubibi shayari.” Shina nikimi paiga chaubibi shayariga. ");
INSERT INTO qxl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chimunda Jesús pakalla rikuriajkunada kashna niga, “Kangunadami tapuni. Samana p'unllaga ¿imadadi rurana gan: allida na gashaga na allida? Shuj kausida ¿kishpichinachu na gashaga tukuchinachu?” ");
INSERT INTO qxl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Paibuj muyundijta tukigunada rikushka k'ipaga maki chakirishkada, “Makida chutallada ruri,” niga. Shina rurashaga alliyagallami. ");
INSERT INTO qxl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Rukudi manchanaidi p'iñarishami <¿Jesustaga imadadi rurashun?> nisha ninukungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chi p'unllagunabi Jesusga urkumu risha tuki tuta Dioskun parlanukusha pakariga. ");
INSERT INTO qxl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","P'unllayaki Paibuj yachagujkunada kayushaga chunga ishkidami aglluga. Paigunadaga “Ñukamunda parlachun nisha agllashkagunami ganguichi” niga. ");
INSERT INTO qxl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paigunaga kaigunami gan: Simón, pailladadij Pedro nisha shutichishka; paibuj wauki Andikush; Jacobo, Juanchu, Felipe, Bartolomé, ");
INSERT INTO qxl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tiuma, Alfeobuj churi Jacobo, Simón Celote nishka, ");
INSERT INTO qxl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacoboj churi Judas, Judas Iscariotesh. Paimi k'ipallaga Jesusta wañuchisha nijkunamu japichiga. ");
INSERT INTO qxl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesusga urkumunda paigunan uriyashaga pamballabi shayaga. Paibuj tauga yachagujkunash shujkunash Judea llaktamunda, Jerusalén pueblomunda, Tiro pueblo, Sidón pueblo jatun yaku kucha manyagunamundashmi, ");
INSERT INTO qxl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús parlashkada uyungaj unguigunadash alliyachichun nishami taugalladijkuna shamuga. Jesusga yanaguna katishkagunada llakinaida kausajkunadash alliyachigami. ");
INSERT INTO qxl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Paimunda llujshij podergun tuki ungushkagunada alliyachishkamundami tukiguna Jesusta tupungu munuga. ");
INSERT INTO qxl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesusga Paibuj yachagujkunada rikusha kashna niga, “Kai pachabi imada na charijkuna, kushilla ganguichi. Diosbuj mandanaga kangunajmi gan. ");
INSERT INTO qxl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Yarijin gajkunash, kushilla ganguichi. Kangunaga sajsachishkami ganguichi. “Kunun wakusha kausajkunash, kushilla ganguichi. K'ipaga asinguichimi. ");
INSERT INTO qxl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Aichayuj tukushka Churida katishkamunda, genteguna p'iñaki, llujshichisha kachuki, rimaki, kangunaj shutida na valichikish kushilla ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Shinalladimi kunun kashna rimagujkunaj ñauba taitaguna Dios nishkada parlujkunadash llakichigaguna. Kashna llakichigukish mejor kushilla ganguichi; jawa pachabiga kangunamu alli kumbidanami tiyan. ");
INSERT INTO qxl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Kai pachabi charijkuna charishkagunan kushiyagujkuna, k'ipaga ¿imachari tukunguichi? ");
INSERT INTO qxl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kunun alli mikusha kausajkunaga k'ipa p'unllaga yarijin ¿imachari tukunguichi? Kunun asigujkunaga k'ipaga llakinaidami wakanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tukiguna kangunada <Alligunami ganguichi> niki ¿imachari tukunguichi? Shinalladimi ñauba taitagunash Diosmunda llullusha yachachijkunada <Alli> nigaguna.” ");
INSERT INTO qxl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ñuka parlushkada uyajkunadaga kaidami nini, na rikunachijkunada k'uyichi. Kangunada p'iñajkunamush ashtan allida rurichi. ");
INSERT INTO qxl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kangunada litujkunadaga ‘Alligunada kuchun’ nichi. Llaki tukuchun nijkunamundash Diosta mañichi. ");
INSERT INTO qxl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pish ñawi ichibi takukiga chaishuj ladudash rikuchilla. Kambuj jawa churushkada maijin kichukiga uku churushkadash japichun sakilla. ");
INSERT INTO qxl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pi imada mañukiga kuilla. Kambujta imada kichukiga ama vueltachichun mañanguichu. ");
INSERT INTO qxl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ima layami kangunamu shujkuna rurachun ninguichi, kangunash paigunamu shinaidi rurichi. ");
INSERT INTO qxl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kangunada k'uyajkunallada k'uyashaga ¿ima allidadi ruranguichi? Juchagunada rurujkunash shinalladijka ruranmi. ");
INSERT INTO qxl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kangunamu allida rurujkunallamu allida rurashaga ¿chiga imadi alli gangari? Juchagunada rurujkunapura shinalladijka ruranmi. ");
INSERT INTO qxl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Imada mañachisha, randi imadash japina yuyillan mañachishaga ¿ima allidadi ruranguichi? Juchagunada rurujkunapura shinaidijka ruranmi. ");
INSERT INTO qxl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Diosga milli rurujkunamu na <Diosolopai> nijkunamush allida ruranmi. Shinaidimi kangunada p'iñajkunadaga k'uyusha allida rurananguichi. Ama imadash randi japina yuyin mañachinguichichu. Shina rurashami Jatun Mandaj Diosbuj alli kumbidanada japisha Paibuj wawagunashmi ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ima layami Taita Dios kangunada llakin, kangunash shujkunada llakichi.” ");
INSERT INTO qxl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ama shujkunada juchachinguichichu. Diosbish kangunada na juchachingachu. Pidash ama <Kauzayujminguichi> ninguichichu. Diosbish kangunada ‘Na kauzayuj’ ningami. Perdonichi, Diosbish perdonangami. ");
INSERT INTO qxl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Shujkunamu imadash kuichi, Diosbish kangunamunga kushtul jundalladi tushuchishka tallirij shinadami kunga. Kanguna ima shina ruranguichi, Diosbishmi kangunamu ruranga.” ");
INSERT INTO qxl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús kai yuyachinan kashna niga, “Na rikuj ¿shuj na rikujta pushi pudinchu? ¿Nachu ishkindijlladi ut'kubi urmunga? ");
INSERT INTO qxl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yachagujka yachachijtaga na yallichu. Yachanada tukuchishami yachachij laya tukunga. ");
INSERT INTO qxl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Imashadi kambuj waukij ñawibi tiyaj uchilla kaspida rikungui? Ashtan kambuj ñawibi tiyaj jatun kaspidari rikiri. ");
INSERT INTO qxl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kambuj ñawibi jatun kaspi tiyajta na cuenta kushaga ¿ima layadi waukida kashna ningui? ‘Kambuj ñawibi tiyaj uchilla kaspida ñuka llujshichisha.’ Ishki siki imadash nij tukusha crichijlla, kambuj ñawimundadi jatun kaspida llujshichiri. Shina rurashami kambuj waukij ñawibi tiyaj uchilla kaspidash llujshichi pudingui.” ");
INSERT INTO qxl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Alli yuraga na alli granudaga mana aparinchu. Na alli yurash alli granudaga na aparinchu. ");
INSERT INTO qxl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Granukimi ima laya yurashkada rijsina: Jigustaga na kashamunda japinchichu. Uvadash mana zarzamunda japinchichu. ");
INSERT INTO qxl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Shungubi ima tiyashkadami shimimundaga rimarin. Alli shunguyujka paibuj shungubi alli yuyiguna junda gashami alligunada parlan. Shinalladi na alli shunguyujka paibuj shungubi milli yuyiguna junda gashami na alligunada rimarin.” ");
INSERT INTO qxl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ñuka mandushkada na rurashaga ¿imashadi kangunaga ‘Mandaj Jesús, Mandaj Jesús’ ninguichiri? ");
INSERT INTO qxl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Maijinsh Ñukajmu shamusha, Ñuka yachachishkada rurajka imamu rijchij gashkada kunun parlasha. ");
INSERT INTO qxl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Shuj wasichij uku ukuda ut'kusha wasida shayachingu rumida churusha kallarij shinami gan. Alli wasichishkamundaga jatiyaku jatarisha shamusha takashash na walinkichi pudinchu. ");
INSERT INTO qxl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Maijin Ñuka yachachishkada uyashash, na kazujka achpa jawallabi wasichisha na ut'kushalla rumish illuj na jinchida ruruj shinami gan. Yaku jatarisha shamusha takunmi tukida urmachishtakiga jatun llaki tukun.” ");
INSERT INTO qxl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gentegunamu yachachishka k'ipami Jesusga Capernaúm pueblomun riga. ");
INSERT INTO qxl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chibimi soldadogunada mandaj tiyaga. Paibuj k'uyashka sirvijmi ungusha wañunalla siriguga. ");
INSERT INTO qxl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesusmunda parlajta uyashami soldadogunada mandajka israelgunada pushuj yuyijkunada, “Ñukaj sirvijta alliyachichun Jesusta pushamungu ribaichi,” nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Paiguna Jesusbujmu kuchuyashaga, “Hijo taita, soldadogunada mandujta ayudanaga kabinmi. ");
INSERT INTO qxl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Paimi ñukuchij llaktada k'uyusha, Diosmunda yachana wasidash rurachiga. Chimunda ayudabai,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Shina nikimi Jesús paigunan riga. Wasimu chayagukimi chi mandujka paiyun purijkunada kashna nisha nichun kachuga, “Mandaj, ñuka wasimundijka ama shamichu. Kan kaimundi shamuchunga ñukaga imash na ganichu. ");
INSERT INTO qxl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Shinushami ñukaidijka kandaga mashkungu rilladash na riganichu. <Alliyi> nillada nibairi. Shina niki ñukada sirvijka alliyangallami. ");
INSERT INTO qxl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ñukash jatun mandajkuna mandashkallami kausasha soldadogunadami mandani. Ñuka, ‘Ri,’ nikish rinllami. ‘Shami,’ niki shamunllami. Ñukada sirvijkish, ‘Kaida ruri,’ niki rurunllami.” ");
INSERT INTO qxl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Shina nijta Jesús uyasha kushiyaga. Paida katij taugagunada rikusha kashna niga, “Kangunada nini, israelgunapurabiga pai laya alli crijtaga na rikushkanichu.” ");
INSERT INTO qxl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Manduj kachashkaguna wasimu chayushaga ungushkada alliyashkadami japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chi k'ipami Jesusga yachagujkunandij taugalladijkunanbish Naín pueblomu riga. ");
INSERT INTO qxl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chayagushaga wañushkada taugagunalladi pambungu rigujtami rikuga. Wañushkaga viudaj shujlla churimiga. ");
INSERT INTO qxl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mandaj Jesusga chi warmida rikusha llakishami, “Ama wakichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kuchuyashaga wandushkada tupuki aparijkuna shayariga. Chimunda Jesusga wañushkada, “Musu, kandami jatarichun mandani,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Shina niki wañushkaga tiyarisha parlungu kallariga. Shina kausachisha Jesusga mamunmu kuga. ");
INSERT INTO qxl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tuki chida rikujkuna mancharisha, “Dios nishkada parlujmi ñukuchipurabi rikurishka. Diosmi paibujkunada ayudangaj shamushka,” nisha Diosta <Allimi gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tuki Judea llaktabi kausajkunash Judea muyundiki kausajkunashmi Jesús ima rurashkadaga yachi chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús imalla rurashkagunada Bautizaj Juanchuda katijkuna parluki paibuj ishki katijkunada kayusha, ");
INSERT INTO qxl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Manduj Jesusta, “¿Kanchu shamuna gagangui? Na gashaga ¿shujtachu shuyana ganchi?” nisha tapuchun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanchu kachashkaguna Jesusbuj kuchumu rishaga kashna niga, “Bautizaj Juanchumi kaidaga tapuchun kachuga, ‘¿Kanchu shamuna gagangui? Na gashaga ¿shujtachu shuyana ganchi?’ nisha.” ");
INSERT INTO qxl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tapugujllabidimi Jesusga ungushkagunada, manchanai llakichishka gajkunada, yana katishkagunada na rikujkunadash rikujta rurasha alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chimundami Jesusga, “Kanguna rikushkada, uyashkada Juanchumu parlangu richi: ñawi na rikujkunash rikujta, suchugunash purijta, aichada ismuchij unguiyujkunadash alliyachishkada, na uyajkunash uyajta, wañushkagunadash kausachishkada, na charijkunamush Alli Shimida parlashkada. ");
INSERT INTO qxl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Ñukaj kauzamunda na trankarishalla crishkada katijka kushillami gan!” niga. ");
INSERT INTO qxl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanchu kachashkaguna riki Jesusga taugagunamu Juanchumunda parlungu kallariga, “Shitashka pushtubiga ¿imadadi rikungu llujshiganguichi? ¿Shuj iru yurada waira chaspishkada? ");
INSERT INTO qxl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na gashaga ¿k'uidi churana churashkadachu rikungu riganguichi? K'uidi churashkagunaga paiguna munashka shina kausajkunash jatun mandujkunaj wasibi tiyajmi. ");
INSERT INTO qxl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Shinashaga ¿imadadi rikungu llujshiganguichi? ¿Dios nishkada parlujta? Ari, Dios nishkada parlujtash ashtan yallidami rikuganguichi, ninimi. ");
INSERT INTO qxl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanchumunda Diosbuj Shimibiga ‘Kanda ñaubusha risha, Kishpichij purina ñanda parijachunmi, Ñukamunda parlujta kachani’ ninmi. ");
INSERT INTO qxl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kaidash nini, tuki wacharishkagunamunda maijinsh na Bautizaj Juanchuda yallichu. Shina gakish Diosbuj mandanabi imash na gajka Juanchuda yallimi.” ");
INSERT INTO qxl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tuki chibi gajkuna ashtangarin impuestoda Romamu cobrajkunash, Juanchu parlushkada uyushka k'ipaga Diosga kabishkadami ruraj gashkada cuenta kusha bautizashkaguna gaga. ");
INSERT INTO qxl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ashtangarin fariseogunaga Moisés mandushkada yachachijkunash Dios paigunamu allida rurush nishkada na munushami Juanchumu na bautizarigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesusga paigunada kashna niga, “Kunun p'unllagunabi kausajkunaga ¿imamundi rijchin? ");
INSERT INTO qxl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kangunaga lasabi tiyarij maraguna shinami ganguichi. Kaishuj chaishuj kaparinukunguichi ‘Lautabi tukukish na dansanguichichu. Llakilladi cantogunada cantakish na wakanguichichu.’ ");
INSERT INTO qxl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bautizaj Juanchu shamushaga tandada na mikujchuga vinoda na ubiujchuga. Shina gakimi paidaga, ‘Yana katishkami,’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aichayuj tukushka Churi shamushaga mikun, ubian. Chida rikusha ‘Paiga manchanaidi mikuj ubiaj Romamu impuestoda cobrujkunan juchayujkunanbish tandanukuj’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dios yachaj gashkadaga Paida kazujkunami allida rurusha rikuchigunguna,” nigami. ");
INSERT INTO qxl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chimunda Simón fariseoga Jesusta, “Ñukaj wasibi mikungu jaku,” niga. Shina niki rishaga mizamu tiyariga. ");
INSERT INTO qxl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Fariseobuj wasibi Jesús mikungu rishkada yachashaga chi pueblobi kausuj juchayuj warmiga alabastro rumida rurashka uchilla puñubi k'uilla ashnariguj perfumeda apusha chayaga. ");
INSERT INTO qxl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pai kuchuyasha juchayuj gashkada sintirishkamunda manchanaidi wakusha Jesusbuj chakibi ikida shutuchisha paibuj juakchan chakichisha chakida muchusha k'uilla ashnariguj perfumedash talliga. ");
INSERT INTO qxl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jesusta kayuj fariseoga chida rikusha kashna yuyaga, “Dios nishkada parlujtij gashaga chi tupajka ima shina warmi gashkada yachanmumi. Paiga juchayujmi gan.” ");
INSERT INTO qxl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Shina yuyagujta Jesús yachasha kashna niga, “Simón, kanda shuj shimida nisha nini.” Shina niki, “Yachachij, imadash nilla,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chimunda Jesús kashna niga, “Ishkigunami kuchkida alquilachijmu dibiga: shujka pichka patsuj (500) denarioda, chaishujka pichka chungada (50). ");
INSERT INTO qxl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na pagui pudiki alquilachijka ishkindijlladadi sakiga. Kununga Simón, ishkindijmundaga ¿maijindi yalli k'uyanga?” ");
INSERT INTO qxl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Paiga niga, “Milgada dibijmi yalli k'uyashkada yuyani.” Chimunda Jesusga, “Allidami ningui,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesusga warmida rikusha Simonda niga, “Kambuj wasimu waiguki yakulladash Ñukaj chakida maillachunga na kuganguichu. ¿Kai warmida rikunguichu? Paiga Ñukaj chakida ikin lapujyachisha juakchan chakichishkami. ");
INSERT INTO qxl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kanga Ñukada ñawi ichibi na muchashkanguichu, ashtan kai warmiga Ñuka shamushkamundadimi chakida muchagushkalla. ");
INSERT INTO qxl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kanga Ñukaj umabi aceitelladash na churaganguichu. Paiga k'uilla ashnariguj perfumedami Ñukaj chakibi tallishka. ");
INSERT INTO qxl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chimundami nini, paibuj tuki juchaguna perdonashkamundami paiga Ñukada ashtan k'uyashka. Ashaida perdonashkagunaga ashaidami k'uyanguna.” ");
INSERT INTO qxl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chi k'ipa warmida niga, “Kambuj juchaguna perdonashkami gan.” ");
INSERT INTO qxl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Shina niki chibi gajkunaga kashna tapunukungu kallariga, “Kai juchagunadash perdonajka ¿pidijkun?” ");
INSERT INTO qxl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Chimunda Jesusga chi warmida kashna niga, “Kan Ñukada crishkallamundami kishpichishka gangui. Kushilla ri.” ");
INSERT INTO qxl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Chi k'ipami Jesusga Diosbuj mandanamunda Alli Shimida parlasha jatun pueblogunabish uchilla pueblogunabish chunga ishki agllashkagunandij yana katishkamundash unguimundash alliyachishka warmigunanbish riguga. Chi warmigunapurabiga kanchis yanagunada llujshichishka Magdalamunda Mariash katisha puriga. ");
INSERT INTO qxl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herodesbuj wasibi mandaj Chuzaj warmi Juanash, Susanash, ashtan shuj warmigunash imalla charishkagunan Jesusta ayudasha puriga. ");
INSERT INTO qxl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pueblogunamunda llujshisha Jesusta rikungu taugalladi tandanukukimi Paiga yuyachisha parlungu kallariga, ");
INSERT INTO qxl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Shuj tarbujmi tarbungu llujshiga. Ña tarbuguki parti muyuga ñanbi urmuki sarugaguna. Pishkugunash mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Parti muyuga rumi ukubi urmuga. Iñushash húmedo ishkamunda chakigallami. ");
INSERT INTO qxl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Shuj muyugunaga kasha ukubi urmasha iñaga. Kashaguna makukiga chingagallami. ");
INSERT INTO qxl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Parti muyuga alli achpabi urmuga. Iñushaga alli granudami kuga. Shuj muyullamunda patsuj (100) granudami kuga.” Chida parlashka k'ipaga Jesusga jinchida kashna niga, “¡Maijinsh rinrinda uyungu charijka uyichi!” ");
INSERT INTO qxl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesusbuj yachagujkuna kashna tapuga, “¿Imada nishadi kai yuyachinaga nin?” ");
INSERT INTO qxl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chimunda Jesús kashna niga, “Kangunamunga pi na rijsishka Diosbuj mandanadaga Pailladimi rijsichin. Shujkunamunga rikushash na rikushka shina, uyushash na intindishka shina tukuchunmi yuyachinagunallanga parlani.” ");
INSERT INTO qxl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kai yuyachisha parlushka muyuga Diosbuj Shimidami rikuchin. ");
INSERT INTO qxl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ñanbi urmuj muyu shinaga Diosbuj Shimida uyasha na crisha ama kishpirichun diablo shamushaga shungumunda uyashkada kungachinllami. ");
INSERT INTO qxl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Rumi ukubi urmuj muyuga Diosbuj Shimida parlaki uyasha kushilla japijkunadami rikuchin. Asha angugunada charishkamunda asha p'unlla k'ipa llakiguna rikurikiga sakirijllagunami. ");
INSERT INTO qxl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kasha ukubi urmuj muyuga Diosbuj Shimida uyashka jawa, asha asha kungarijllagunadami rikuchin. Paigunaj llakigunan, ashtan charina yuyin, kikin munida rurashkamunda, llapishka shina tukusha granudash na kunchu. ");
INSERT INTO qxl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Alli achpabi urmuj muyuga Diosbuj Shimida uyusha ashtan tuki shungun alli kazusha na sakijkunadami rikuchin. Shina kausashami alli granugunada p'ukuj laya gashkada rikuchin.” ");
INSERT INTO qxl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Maijinsh luzta japichishaga manga ukubi na gashaga k'awitu ukubiga na churanchu, ashtangarin wasi uku p'unllalla gachunmi, luztaga jawamun churun. ");
INSERT INTO qxl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ima pakushka tiyashkash k'ipaga tukimi rikuringa. Washalla rurashkadash k'ipaga tukidami yachungaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Shinakiga alli alli uyichi. Maijinsh charijmunga ashtanmi kushka ganga; na charijmundaga mashna charishkada yuyashkaida kichushkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesusbuj mamash waukigunash Pai maibi gashkamu chayuga. Taugaguna gakimi na kuchuyi pudigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Shujka Jesusmu parlushaga, “Kambuj mama waukigunash kanda rikush nisha washabimi shayagun.” ");
INSERT INTO qxl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Shina niki Jesusga, “Diosbuj Shimida uyasha p'aktachijkunami Ñukaj mama Ñukaj waukiguna shina gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Shuj p'unlla Jesusga Paibuj yachagujkunan barcabi sikusha, “Yaku kucha ch'imbamu jakuchi,” niki rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yaku kuchada pasaki Jesús puñuriga. Ñash mejor waira shamusha yakuda kaimu chaimu kuyuchikiga barcabi yaku jundungu kallariki chingarinallami tukuga. ");
INSERT INTO qxl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Shina tukuki mejorda mancharishami Jesusbujmu kuchuyasha, “Yachachij, yachachij, wañugunchijka,” nisha rijchachiga. Jesús rijcharishaga wairada yakuda, “Ama shinichu,” nisha jinchida rimuga. Shina nikiga wairash yakush chulunllami sakiriga. ");
INSERT INTO qxl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chi k'ipa Jesusga yachagujkunada, “Kanguna crishkaga ¿ima tukuga?” niga. Shina niki mejorda mancharisha kaishuj chaishuj, “Paiga ¿pidij ganla? Yakush wairash Pai rimakiga chulunlla sakirinllami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chi k'ipami Jesusga yachagujkunandij Gadara llaktamu chayuga. Chi llaktaga kucha ladu Galilea llaktan ch'imbapuramiga. ");
INSERT INTO qxl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ña chayusha barcamunda Jesús uriyagukiga shujka tauga watagunada yana katishka gasha churanadash na churashka wasibish na tiyaj, pantiunllabi kausaj chi pueblomunda kuchuyaga. ");
INSERT INTO qxl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Paidaga yanaga tauga kutinmi waigushami llakichij gashkaga mandaj gashkaga. Chimunda genteguna japisha chakidash makidash cadenan alli watasha churakish chi k'ariga p'itishtaga. Yana pushaki shitushka pushtumu rigujllamiga. Shinashkamundami paiga Jesusbujmu kuchuyasha kungurishaga kashna niga, “¡Jawa pachabi kausaj Jatun Mandaj Diosbuj Churi Jesús! ¿Ima ningu shamungui? Ñukada ama llakichichu.” Jesús yanada, “¡Paida saki!” nigushkamundami shina kaparisha rugaga. ");
INSERT INTO qxl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chimunda Jesusga, “¿Ima shutingui?” niki, “Ñukaga Warangaguna shutimi gani,” niga. Tauga yanaguna japishkamundami shina shutiga. ");
INSERT INTO qxl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Paigunami, “Ama ñukuchida yana ut'ku pachamu kachabaichu,” nisha mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chai lumabi tauga k'uchiguna mikuguki yanagunaga kashna nisha rugugaguna, “Chi k'uchigunabi waiguchun sakibai.” Shina mañuki Jesusga waiguchun sakiga. ");
INSERT INTO qxl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yanaguna llujshishaga k'uchigunabi waigugaguna. Chimunda k'uchigunaga k'akamunda yaku kuchabi uriyasha yakubi wañugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","K'uchiguna shina tukujta rikusha michijkunaga llaktagunabi pueblogunabish parlungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ima tukushkada rikungu nisha genteguna rigaguna. Jesús tiyashkamu chayushaga yanagunada anchuchishkaga Jesusbuj ñaubuki yuyi japishka, churanada churushka tiyajta rikusha, mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kaida rikujkunaga yana katishka ima laya alliyashkada parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chimunda Gadara llaktabi kausujkunaga manchanai mancharishkamundaga Jesusta, “Kaimunda ribai,” nigaguna. Shina nikimi Paiga barcabi sikusha riga. ");
INSERT INTO qxl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jesús rigujta rikusha yanagunada llujshichishkaga, “Ñukadash pushusha ribai,” niki Jesusga, “Kaillabidi sakirilla,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kanda Dios imada rurashkada wasimu risha parli.” Shina nikimi paiga Jesús ima rurashkada tuki pueblobi tiyajkunamu parluga. ");
INSERT INTO qxl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yaku kucha ch'imba ladumunda Jesús vueltamuki taugagunaga chapagusha kushilladimi japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Shinaga Diosmunda yachana wasibi pushuj Jairo kuchuyashaga Jesusbuj ñaubuki kungurisha, “Jakubai ñukaj wasimu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairoga chunga ishki watayuj shina shujlla ushidami chariga. Chi ushiga ña wañunallami siriguga. Jesús riguki taugalladijkuna Paida llapinukidimi katiga. ");
INSERT INTO qxl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chunga ishki watada yaur shitasha ungushka warmish chi gente ukubi riguga. Jambirishash manchanaidi kuchkida tukuchiga. Shinash pish na alliyachi pudishkachuga. ");
INSERT INTO qxl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chi warmiga washamunda shamusha Jesusbuj churana manyada tupun yaurga sakirigallami. ");
INSERT INTO qxl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chimunda Jesusga, “¿Pi Ñukada tupuga?” nisha tapuki, tukiguna nigariga. Shinasha Pedroga kashna niga, “Yachachij, taugalladijkunami tuki ladumunda llapidi shamugun.” ");
INSERT INTO qxl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Shinash Jesús kashna niga, “¿Maijinchari tupugami? Chimunda Ñukaj poder llujshishkada sintigani.” ");
INSERT INTO qxl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Alliyashka warmiga na mitikungu pudishami ch'ujchurisha Jesusbuj ñaubuki kunguriga. Tukigunaj ñaubuki imamunda tupushkada, ima layash ña alliyashkadash parluga. ");
INSERT INTO qxl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesusga, “Ñuka k'uyashka, kanga Ñukada crishkallamundami alliyashkangui. Kushilla rilla,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús parlagujllabidi Diosmunda yachana wasibi pushuj Jairomu shuj parlungu shamuga, “Yachachij Jesusta ama p'iñachichu. Kambuj ushiga ña wañushkami.” ");
INSERT INTO qxl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús chida uyushaga, “Ama mancharichu. Kan Ñukada crillada cri, kambuj ushiga kausaringami,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wasimu chayushaga shujkunada na waiguchun sakigachu. Jesusga Pedroda Jacoboda Juanchuda maraj yayun mamundash pushusha waiguga. ");
INSERT INTO qxl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tuki chibi gajkuna kaparisha wakagukimi, Jesusga kashna niga, “Ama wakichichu. Maraga na wañushkachu, puñilladami puñugun.” ");
INSERT INTO qxl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Shina niki wañushkadij gashkada yachashkamunda gentegunaga asigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chimunda Jesusga makimunda japisha jinchida niga, “Mara, ¡Jatari!” ");
INSERT INTO qxl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Shina nin maraga ñash kausarigallami. Jesusga maramu karachun manduga. ");
INSERT INTO qxl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Paibuj taita mamaga kausarijta rikusha mancharigaguna. Jesusga, “Kaidaga p'akta pimush parlunguichimu,” nisha mandaga. ");
INSERT INTO qxl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesusga Paibuj chunga ishki agllashkagunada kayusha ungushkagunada alliyachichun tuki laya ayagunadash llujshichichun mandi pudij gachun nishami poderda kuga, ");
INSERT INTO qxl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","shinaidi Diosbuj mandanamunda parlachun, ungushkagunadash alliyachichun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús kashna niga, “Kanguna rishaga ni imadash ama apunguichichu. Taunada, kipida, tandada, kuchkida, churanadash p'akta apanguichimu. Churashkallan ringuichi. ");
INSERT INTO qxl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Shuj pueblomu ringagama pibuj wasimu chayashash chillabi sakiringuichilla. ");
INSERT INTO qxl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Shinaidi maijin pueblomu chayakish na japisha nikiga paiguna na alli rurushkada parlashka shina sakirichun chimunda llujshisha kangunaj chakimunda achpada chaspisha ringuichilla.” ");
INSERT INTO qxl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Shinaki paiguna rishaga Alli Shimidami parlaga. Ungushkagunadash alliyachishami tuki uchilla pueblogunabi puriga. ");
INSERT INTO qxl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Jesús imalla rurashkagunada Galilea llaktada mandaj Herodes uyuga. “Bautizaj Juanchumi kausarishka,” nigugaguna. Shujkunaga, “Paiga Dios nishkada parluj Eliasmi,” nigugaguna. Partigunaga, “Dios nishkada parlujmi kausarishkanga,” niguki Herodesga maida na yuyi pudiguga. ");
INSERT INTO qxl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodesga kashna niga, “Paiga na Juanchuchunga. Ñukaidimi kungada p'itichunga kachagani, ashtan kai k'arimunda imadadikish parlujkunada uyani. Shinaga ¿pidikun paiga?” Chimunda Herodesga Jesusta paidij rikungu munaga. ");
INSERT INTO qxl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chunga ishki agllashkaguna vueltamushaga Jesusmu tuki imalla rurushkada parlagaguna. Chi k'ipaga Jesusga paigunallan Betsaida pueblomumi pushusha riga. ");
INSERT INTO qxl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chimu rigujta taugaguna yachushami katisha rigaguna. Shina katimukimi Jesusga, “Shamichilla,” nisha Diosbuj mandanamunda parlaga. Ungushkagunadash alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tutayamuguki Jesusbuj chunga ishkigunaga Paibuj kuchumu rishaga, “Kai gentegunada kai kuchugunabi pueblogunabish samachun mikunadash mashkachun kachabai. Kaibiga imash ishkami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Shina nikiga Jesusga kashna niga, “Mikunadaga kanguna karabaichi.” Yachagujkuna kashna niga, “Pichka tandada ishki chaulalladami charinchi. Kai tukigunamundijka randingu rikimami p'aktanga.” ");
INSERT INTO qxl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chibiga pichka waranga (5.000) shina k'arigunamiga. Chimunda Jesusga Paibuj yachagujkunada kashna niga, “Paigunada pichka chunga (50) pichka chungada (50) tiyachichi.” ");
INSERT INTO qxl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Shina rurachun tukigunada tiyachigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesusga pichka tandada ishki chaulada japisha jawa pachada rikusha, Taita Diosta <Diosolopai> nisha chibi gajkunamu karachun Paibuj yachagujkunamu partisha kuga. ");
INSERT INTO qxl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tukiguna sajsujta mikushka k'ipash chunga ishki canasta jundami puchushkada Paibuj yachagujkuna japiga. ");
INSERT INTO qxl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Shuj p'unlla Jesuslla Diosta mañagusha Paibuj yachagujkunada kashna nisha tapuga, “Gentegunaga Ñukada ¿pi gashkada nigunguna?” ");
INSERT INTO qxl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Shina tapuki paiguna kashna niga, “Kandaga shujkunaga ‘Bautizaj Juanchumi gan’ nigun. Maijingunaga ‘Ñauba Eliasmi gan’ nigun. Kutin shujkunaga ‘Dios nishkada parluj kausarishkami gan’ nigungunami.” ");
INSERT INTO qxl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Kangunaga Ñukadaga ¿pi gashkada yuyanguichi?” nisha Jesús tapuki, Pedroga kashna niga, “Kanga Dios agllusha kachashka Cristomi gangui.” ");
INSERT INTO qxl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesusga paigunada kashna niga, “Ñuka pi gashkadaga ama pimush parlunguichichu.” ");
INSERT INTO qxl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesús kaidash parlaga, “Aichayuj tukushka Churiga manchanai llakida apanaidimi gan. Yuyijkuna, manduj curaguna, Moisés mandashkada yachachijkunash na rikunachinga. Wañuchishka gashash kinsa p'unlla k'ipaga kausaringami.” ");
INSERT INTO qxl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Paiga tukigunada kashna niga, “Maijin Ñukada katingu munujka kikinbuj munida sakisha p'unllandij cruzta aparij laya ima llakida japisha katimilla. ");
INSERT INTO qxl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Maijinsh kikinbuj kausillada yuyarijka chingaringami, ashtangarin Ñukada katishkamunda kikinbuj kausida na llakijka kishpichishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Maijinsh kai pachabi imada charij tukushash pailladi llakinaida chingarishaga ¿imadi alli gangari? ");
INSERT INTO qxl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Maijinbish Ñukada Ñukaj parlushkadash pinganachijtaga Taitaj k'uilla gashkan jucha illuj angelgunaj k'uilla gashkan Aichayuj tukushka Churi k'uilla gashkanbish shamushaga pinganachingami. ");
INSERT INTO qxl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kabishkadadimi nini, Dios ima shina mandanada rikungagama kaibi gajkunamunda shujkunaga na wañungachu.” ");
INSERT INTO qxl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kaigunada parlanukushka shuj semana k'ipa Jesusga Pedroda, Jacoboda, Juanchudash Taita Dioskun parlanukungaj urkumu pushusha riga. ");
INSERT INTO qxl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús Dioskun parlanukukiga k'uilla ñawi rikuriga. Churanabish yurajlla p'alanigujmi tukuga. ");
INSERT INTO qxl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chibiga ishkiguna rikurisha shujka Moisés kaishujka Elías Jesuskun parlanukuga. ");
INSERT INTO qxl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","K'uilla p'unllalla p'alaniguj chaubibi shayarishami Jesusta ima shina Jerusalén pueblobi wañuchinada p'aktachinamunda parlanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrosh paigun rijkunash mejor puñunachigushash rijchuj tukushami Jesusbuj k'uilla p'unllalla p'alanigujta ishkiguna Paigun gajta rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ishkiguna Jesusbuj kuchumunda riguki Pedroga pailladi ima nigushkadash na yachashalla kashna nigalla, “Yachachij, allidikish kaibi ganchi. Kinsa carpadami rurashun: shujtaga kanmu Moisesmu Eliasmush.” ");
INSERT INTO qxl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Shina nigujllabidi p'uyu rikuriki paigunaj muyundijta tiyariki mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chi k'ipa p'uyu ukumunda kashna parlashka uyariga, “Kaimi Ñukaj agllushka churi. Paida uyunguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Shina rimashka uyarigujllabidi Jesusga Pailla rikuriga. Shina rikushkadaga paigunaga upalla sakirisha pimush na parlagagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kayundij p'unlla Jesús Paibuj kinsa katijkunandij urkumunda uriyamukiga taugagunami tupungu llujshiga. ");
INSERT INTO qxl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Taugagunapuramunda shuj k'ariga kapariga, “Yachachij, hijo taita, ñuka churida alliyachibai. Paillada chariniga. ");
INSERT INTO qxl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kai maradaga shuj yana japisha mejor kaparichisha shimimunda puskuda shitachisha ñalla ñalla ataque alsan. Na kacharish nisha llakinaida piguik'ichun. ");
INSERT INTO qxl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kambuj yachagujkunada <Yanada llujshichisha kubai> nikish na pudigachu.” ");
INSERT INTO qxl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chimunda Jesusga kashna niga, “¡Ñukada na alli crishami na alliguna ganguichi! ¿Ima uragamachari kangunan gasha?” Chi k'ipa yayunda kashna niga, “Kambuj churida kaimu pushami.” ");
INSERT INTO qxl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mara kuchuyamuki yana pambabi urmachiki kutin ataque alsuga. Chi yanada Jesús rimusha llujshichisha marada alliyachishaga taitamu kuga. ");
INSERT INTO qxl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tukigunami jatun Dios poderyuj gashkada rikusha mejor kushiyasha mancharigaguna. Pai rurashkada rikusha tukiguna kushilla gaki Jesusga Paibuj yachagujkunada kashna niga, ");
INSERT INTO qxl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kaida alli uyunguichi. P'akta kungaringuichimu. Aichayuj tukushka Churiga wañuchichun japichishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Shina parlakish yachagujkunaga pakalla gaki yachana yuyida Diosmunda na japisha ima ninada manchashkamunda Jesusta na tapugagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chi k'ipa yachagujkunaga rimanukungu kallarishaga, “¿Maijinshi yalli valij ganchishi?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Paiguna shina yuyashkada Jesús yachashaga shuj marada japisha Paibuj kuchubi shayachishaga ");
INSERT INTO qxl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kashna niga, “Ñukaj shutibi kai marada alli japijka Ñukadami japin. Ñukada alli japijka Ñukada Kachujtash japinmi. Kangunapuramunda manadi valijka ashtan yalli valijmi gan.” ");
INSERT INTO qxl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juanchu kashna niga, “Yachachij, kambuj shutibi ayagunada shuj llujshichijta rikuganchi. Na ñukuchipura gashkamunda <Ama shina rurichu> niganchimi.” ");
INSERT INTO qxl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Shina niki Jesusga kashna niga, “Ama trankunguichichu. Maijinbish ñukuchida na p'iñujka ñukuchibujlladimi gan.” ");
INSERT INTO qxl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesusga jawa pachamu rina p'unlla p'aktamugukiga Jerusalén pueblomu ringu munashkamunda na manchushalla riga. ");
INSERT INTO qxl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Shinalladi Jesusga samana wasida mashkachun nishami parlajkunada Samaria llaktabi tiyaj uchilla pueblomu ñaubachisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ashtangarin Samaria llaktabi kausujkunaga Jesús Jerusalenmu rigujta yachashaga chibi samachunga na sakigagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kaida rikusha yachagujkunaga Jacobosh Juanchush kashna nigaguna, “Manduj Jesús ¿jawa pachamunda nina uriyasha paigunada tukuchichun Elías rurushka shina mandachun ninguichu?” ");
INSERT INTO qxl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Shina nikimi Jesusga vueltarisha kashna rimuga, “Kangunaga maijin yuyin gashkada na yachanguichichu. ");
INSERT INTO qxl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aichayuj tukushka Churiga gentegunaj kausida chingachingajka na shamugachu, ashtangarin kishpichingajmi shamuga.” Shina rimushka k'ipaga shuj uchilla pueblomu rigallagunami. ");
INSERT INTO qxl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ñanda rigusha shujka kashna niga, “Manduj Jesús, maimu rikish Kandami katisha nini.” ");
INSERT INTO qxl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Shina niki Jesusga kashna niga, “Zorroguna maibi kausana ut'kuda charingunami. Pishkugunash tazinlladash charingunami, ashtangarin Aichayuj tukushka Churiga maibi samanaidash na charinchu.” ");
INSERT INTO qxl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús shujtaga kashna niga, “Katimi.” Shina niki, “Manduj, shuyi. Ñukaj taitadadi pambamungu rini,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Shina niki Jesusga kashna niga, “Wañushka layagunalladi paigunaj wañushkagunada pambachun saki. Kanga Diosbuj mandanamunda parlungaj ri.” ");
INSERT INTO qxl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Shujbish kashna niga, “Manduj Jesús, Kandami katisha nini. Shinash ñukaj wasibi tiyajkunada <Rinimi> nisha vueltungama shuyabai.” ");
INSERT INTO qxl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chimunda Jesusga kashna niga, “Maijinsh yapugusha timunda charirisha rigushka ratu washamu vueltusha rikuj shina gajka Diosbuj mandanabiga imakish na valinchu.” ");
INSERT INTO qxl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chi k'ipaga Mandaj Jesusga kanchis chunga ishkipuradash (72) agllushami Pai rina pueblogunamu llaktagunamush ishki ishkida ñaubachisha kachusha, ");
INSERT INTO qxl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","kashna niga, “Granuda tandanaga mejormi tiyan; tandujkunaga ashallagunami gan. Ashtan kachachun nisha Manduj Dios Granuyujta mañanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Shinaga ringuichilla. Kangunadaga malta ovejagunada lobogunaj chaubida kachuj layami kachani. ");
INSERT INTO qxl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kipidash kuchkidash pargatidash ama apusha ringuichichu. Ñanbi tupushash saludangu ama shayaringuichichu. ");
INSERT INTO qxl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Shujbuj wasimu waigushash ‘K'uilla kausi kangunan gachun’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chibi kushilla kausida japijkuna tiyakiga kanguna ‘K'uilla kausi kangunan gachun’ nishkaga p'aktungami. Na shina gakiga na p'aktungachu. ");
INSERT INTO qxl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ama wasin wasin puringuichichu. Shuj wasillabi sakirisha paiguna ima karashkallada mikunguichi, ubianguichi. Trabajajkunaga pagoda japinami kabin. ");
INSERT INTO qxl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Shuj pueblomu chayushash kangunada alli japikiga paiguna karushkada mikunguichi. ");
INSERT INTO qxl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chibi ungushkagunada alliyachinguichi. ‘Diosbuj mandana ña kuchuyamugunmi,’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Shuj pueblomu chayuki na japisha nikiga kashna nisha ñanmu llujshinguichi, ");
INSERT INTO qxl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kangunaj pueblobi tiyaj achpa ñukuchij chakibi aparishkadash kanguna na uyash nishkada rikuchingumi chaspinchi. Shinash Diosbuj mandana ña kuchubi gashkada yachichi.’ ");
INSERT INTO qxl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kaidash ninimi, chi llakichina p'unlla chi pueblodaga Sodoma pueblobi kausujkunadash yallimi llakichishka ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Ai Corazín pueblobi kausajkunalla! ¡Ai Betsaida pueblobi kausajkunalla! Ñuka pi na ruri pudishkagunada kangunamu rurushka shina Tiro, Sidón pueblogunabi rurushkakiga sarunmundadimi llakirisha paza churanagunada churusha uchpabi tiyarisha Diosmu vueltushkada rikuchinmuga. ");
INSERT INTO qxl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Llakichina p'unllaga kangunaga Tirobi Sidonbi kausajkunadash yallimi llakichishka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaúm pueblobi kausujkunalla, kangunaga <Jawa cielomu rishunmi> yuyanguichichari. ¡Uku pachamumi shitashka ganguichi! ");
INSERT INTO qxl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Maijin kanguna parlashkada uyujka Ñukadami uyan. Kangunada na uyash nijka Ñukadami na uyash nin. Ñukada na uyash nijka Ñukada Kachajtash na uyash ninchu.” ");
INSERT INTO qxl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kanchis chunga ishkiguna kushilla vueltusha kashna nigaguna, “Manduj Jesús, Kambuj shutibi yanagunash ñukuchida kazusha llujshigagunallami.” ");
INSERT INTO qxl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús niga, “Ñukaga jawa pachamunda relampa shina Satanás urmujta rikuganimi. ");
INSERT INTO qxl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ñukaidimi kangunamu trijis k'urugunada culebragunadash saruchun imash na tukushalla diabloda vincichun poderda kugani. ");
INSERT INTO qxl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yanagunada llujshichishkallamunda ama manchanaidi kushiyichichu, ashtangarin kangunaj shuti jawa pachabi apuntashka tiyashkamunda kushiyichi.” ");
INSERT INTO qxl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Shina nigujllabidimi Jesusga Diosbuj Espiritumunda mejordi kushiyasha kashna niga, “Jawa pachada kai pachadash Mandaj Ñuka Taitalla, Kandaga <Alli> ninimi. Alli yuyida charijkunamu yachajkunamush Kan pakushkagunada ashtan maraguna shinamumi yachachishkangui. Taitalla, kashna rurangumi munashkangui. ");
INSERT INTO qxl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ñukaj Taitami tukida Ñukamu kuga. Pi Churi gashkada ni pish na yachanchu. Taitallami yachun. Pi Taita gashkada ni pish na yachanchu. Churillami shinaidi Pai rijsichisha nishkagunashmi yachun.” ");
INSERT INTO qxl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Paibuj yachagujkunada rikusha paigunallamumi kashna niga, “Maijin kanguna rikushkada rikujka kushilla gachun. ");
INSERT INTO qxl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Shinushami Ñuka nini, tauga Dios nishkada parlujkuna mandajkunash kanguna rikushkada rikusha nishash na rikugagunachu. Uyushkadash uyusha nishash na uyagagunachu.” ");
INSERT INTO qxl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moisés mandashkada yachachij Jesuskun parlanukungu risha ima panda nikiga juchachingu nishami kashna tapuga, “Yachachij, na tukurij kausida japingujka ¿imadadi rurana gani?” ");
INSERT INTO qxl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús niga, “Moisés mandushkabiga ¿imadi escribishka tiyan? ¿Ima layadi liyungui?” ");
INSERT INTO qxl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Paiga, “Kambuj Manduj Diostaga tuki shungun tuki alman tuki yuyin tuki jursanbish k'uyungui. Shujkunadash kikinda layaidi k'uyungui,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús niga, “Allimi ningui. Kan kaida rurushaga na tukurij kausidami charingui.” ");
INSERT INTO qxl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Shinaki alli rikuringu nisha Jesusta niga, “¿Maijindadi ñukada layaidijka k'uyana gani?” ");
INSERT INTO qxl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Shina niki Jesús niga, “Shuj k'ari Jerusalén pueblomunda Jericó pueblomu uriyagujta shuwaguna japisha churanadash kichushaga takusha wañunallada shitusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chi ñanlladadi shuj israelmunda cura rigushash wañunalla sirijta rikushaga laduyasha rigallami. ");
INSERT INTO qxl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Israelmunda curada ayudaj levitash chi ñanlladadi rigusha wañunalla sirijta alli rikushash laduyasha rigallami. ");
INSERT INTO qxl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chi k'ipa Samaria llaktamunda shuj k'ari ñanda shamusha, wañunalla sirijta rikusha llakisha ");
INSERT INTO qxl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","kuchuyashami chugrigunada aceiten vinon jambisha linsun pilluchisha samana wasibi jambingu paibuj burrubi sikachisha pushush riga. ");
INSERT INTO qxl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kayundij p'unlla samaritanoga samana wasiyujmu ishki kuchkida kushami ‘Kai ungushkada rikubangui. Yalli gastarikish vueltamusha kushallami,’ nisha kusha riga. ");
INSERT INTO qxl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Chi kinsamundaga ¿maijindi shuwaguna takushka k'aridaga kikinda layaidijka llakiga?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moisés mandashkada yachachijka kashna niga, “Paida llakijmi.” Shina niki Jesusga, “Kambish shinaidi rurungu ri,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesusga katijkunandi rigusha shuj uchilla pueblomu chayuga. Martaga paibuj wasibi Jesusta japiga. ");
INSERT INTO qxl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martaga María shuti ñañadami chariga. Mariaga Manduj Jesús yachachishkada ñaubuki tiyarisha alli uyaga. ");
INSERT INTO qxl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","María tiyaguki Martaga wasibi chaida kaida rurusha na p'aktashami Jesusmu kuchuyasha kashna niga, “Mandaj ¿nachu rikungui ñuka ñañaga kai tuki rurana tiyakish ñukallamu sakinga? Ñukada ayudachun nibai.” ");
INSERT INTO qxl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Shina niki Manduj Jesús niga, “Marta, Marta, tauga ruranagunan ama llakirichu. ");
INSERT INTO qxl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Imadash shujlladami ruranangui. Mariaga ashtan alli ruranada agllashami kaibi tiyagun. Chidaga pish na kichi pudingachu.” ");
INSERT INTO qxl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Shuj p'unlla Jesús, Taita Diosta mañashka k'ipa shuj yachagujka kashna niga, “Mandaj Jesús, Bautizaj Juanchu paibuj yachagujkunamu yachachishka shina ñukuchimush Taita Diosta mañanada yachachibai.” ");
INSERT INTO qxl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Shina niki Jesús kashna niga, “Taita Diosta mañashaga kashna ninguichi: Jawa pachabi tiyaj Taitalla, Kambuj shuti <Alli> nishka gachun, Kambuj mandana shamuchun. ");
INSERT INTO qxl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ñukuchimu p'unllandi tandada karabai. ");
INSERT INTO qxl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ñukuchida na allida tuki rurujkunada perdonanchimi, shinaidi ñukuchij juchagunada perdonabai. Ima na alli ruranabi ama sakibaichu, ashtangarin chimunda anchuchibai.” ");
INSERT INTO qxl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesusga kaidashmi niga, “Kanguna shuj apanukushkajmu chaubi tuta risha kashnachu ninguichimu ‘Kinsa tandada fiachi. ");
INSERT INTO qxl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ñukaj wasimu shuj rijsishka karumunda kununlla chayamun. Paimu karungaj imadash na chariniga.’ ");
INSERT INTO qxl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Shina niki kashna nin ‘Ama p'iñachichu. Pungubish ichkashkami. Maragunash ñukan puñunmi. Shinashami kan mañashkada kungajka na jatari pudini.’ ");
INSERT INTO qxl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kangunada nini, apanukuj gashkamundaga na kungu jatarish nigushash ama ashtan p'iñachichun ima ministishkadash kungallami. ");
INSERT INTO qxl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ñukaga kaidash nini: Mañichi, Diosga kungallami. Mashkichi, japinguichillami. Punguda takichi, kangunamu paskangallami. ");
INSERT INTO qxl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maijinsh mañakiga kungallami. Mashkashaga japingallami. Punguda takaki paskangallami. ");
INSERT INTO qxl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kangunamunda pi taitadi mara chaulada mañuki ¿culebradachu kunguichimu? ");
INSERT INTO qxl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na gashaga lulunda mañukiga ¿diablo trijistachu kunguichimu? ");
INSERT INTO qxl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kanguna na alli gashash maraguna imada mañakish allidami kunguichi. ¡Jawa pachabi tiyaj Taitagarin kanguna mañakiga Espiritudami kunga!” ");
INSERT INTO qxl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yana waiguki upa tukushkamunda Jesús yanada llujshichiki k'ariga rimariga. Chida rikusha genteguna mejor mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ashtan shujkuna kashna niga, “Jesusga, yanagunada manduj Beelzebúj podergunmi yanada llujshichin.” ");
INSERT INTO qxl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Shujkunaga imallabish pandachiki rimungu nisha, “Jawa pacha Dios kachashka gashaga pi na ruri pudishkada rurusha rikuchiri,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ashtan paiguna ima yuyashkada Jesús yachushaga kashnami niga, “Llaktada mandujkunapura ishki yuyi tukusha kaishuj chaishuj takanukuki chi llakta tukuringami. Shinalladi wasibi takanukujkunash tukuringami. ");
INSERT INTO qxl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanasbish yanagunan paigunapuraidi gashash p'iñanukukiga pai mandushkaga tukurinmunllami. Ñukadaga ‘Beelzebúj poderda japishkamundami yanagunada llujshichin’ nisha parlanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Beelzebúj poder japishkamunda yanagunada Ñuka llujshichikiga kangunaj katijkunamunga ¿pidi yanagunada llujshichina poderda kun? Shinushami paigunaidi kanguna pandarigushkada rikuchin. ");
INSERT INTO qxl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dios Ñukamu poderda kushkamundami yanagunada llujshichini. Shina rurukimi Diosbuj mandana p'unllaga ña kangunajmu chayamushkada rikuchin. ");
INSERT INTO qxl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Shuj jinchi k'ariga imanbish paibuj wasida chapagukiga ima wakichishkash tiyanllami. ");
INSERT INTO qxl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Shina gakish ashtan paidash yalli jinchi k'ari shamushaga takusha pai vincingu yuyasha takanagunada kichushaga wasibi tuki imalla tiyashkadash apungallami. ");
INSERT INTO qxl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Maijin na Ñukaj parti gajka ñukada p'iñanmi. Maijin na Ñukan tandachijka chaibi kaibi shitusha chingachijmi gan.” ");
INSERT INTO qxl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Shujmunda yana llujshishaga chakishka pushtugunada risha samanada mashkan. Na japishaga, ‘Ñukaga maimunda llujshichishka wasimu kutin vueltamushami,’ ninga. ");
INSERT INTO qxl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Shina kutin shamushaga wasida p'ichusha parijashka shinadami japin. ");
INSERT INTO qxl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Shinada rikusha paidash yalli milli kanchis yanagunan tandanukusha chibi kausungu waigun. Shinushami sarun kausashkadash yalli na alli tukun.” ");
INSERT INTO qxl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús shina nikiga shuj warmi taugagunaj chaubimunda kashna kapariga, “Maijin warmi kanda mirusha iñachijka kushilla gachun.” ");
INSERT INTO qxl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Shina niki Jesús kashna niga, “Ashtanbish Dios nishkada uyusha maijinsh kazujmi yalli kushilla ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Taugaguna Jesusbuj kuchumu shamusha katiki Paiga kashna ningu kallariga, “Kunun p'unllaguna kausujkunaga milligunami gan. Pi na ruri pudishkada rurusha rikuchichunmi mañanguna, ashtanbish Jonás ima laya tukushkalladami rikuchishka ganga. ");
INSERT INTO qxl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ima laya tukusha Jonás ninivitagunamu rikuchishka gaga, shinalladi Aichayuj tukushka Churish kunun p'unllagunabi kausujkunamu rikuchishka tukungami. ");
INSERT INTO qxl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kai pacha tukuri llakichina p'unllaga kai p'unllaguna gentegunada Saba llaktamunda jatun mandaj warmi jatarisha <Kauzayujminguichi> ningami. Paiga Salomón yachashkada tapungaj karumundami shamuga. Ñukaga Salomondash yallimi gani. ");
INSERT INTO qxl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivebi kausajkuna llakichina p'unllabi jatarishaga kai p'unllaguna gentegunada <Kauzayujminguichi> ningami. Paigunaga Jonás parlashkada uyusha Diosmu vueltarigami. Ñukaga Jonastash yallimi gani.” ");
INSERT INTO qxl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Pish luzta katichishaga na pakusha manga ukubish na churanchu, ashtangarin waigujkuna luzta rikuchun jawamumi churan. ");
INSERT INTO qxl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kambuj ñawigunaga cuerpobuj luz shinami gan. Kambuj ñawiguna alli gakiga tuki kambuj cuerpoga p'unllabi purisha kausaj shinami ganga, ashtanbish kambuj ñawi na alli gakiga yanamangabi kausuj shinami gangui. ");
INSERT INTO qxl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kambuj cuerpobi tiyaj luz ama yanamanga shina gachun alli yuyarisha kausangui. ");
INSERT INTO qxl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tuki kambuj cuerpo luzta charikiga yanamangaga na tiyangachu. Luzta katichishka shinabimi p'unllalla tukida rikungui.” ");
INSERT INTO qxl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús parlushka k'ipaga shuj fariseo, “Jaku ñukaj wasibi mikungu,” nikiga Jesús paibujmu chayusha mizamu tiyariga. ");
INSERT INTO qxl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Paiguna shina makida na maillushalla mikungu tiyarijta rikusha chi fariseoga manchariga. ");
INSERT INTO qxl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chimunda Manduj Jesusga kashna niga, “Kanguna fariseoguna vazudash latudash washallada maillanguichi, ashtan ukubiga shujkunaj charishkada munigunan shinaidi milli ruranagunan jundami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Yuyi illujkuna! Washadash ukudash Pailladi rurashkadaga ¿nachu yachunguichi? ");
INSERT INTO qxl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kangunaga imalla charishkamunda na charijkunamu kujkuna gaichi. Shina gakiga tukimi maillushka shina linshu ganga. ");
INSERT INTO qxl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mintada rudada shujtij uchilla k'iwagunadash patsujmunda (100) chungada Diosmu kuj fariseoguna gashash kangunaga allida rurunada Diosta k'uyanada na yuyarishkamundaga ¿imachari tukunguichi? Diosmu kunadash na sakishallami kai alligunadash rurana ministirin. ");
INSERT INTO qxl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Fariseoguna, kangunaga alli rikuringu nishalla Diosmunda yachana wasigunabi ñaubuki tiyaringu munashkamunda shinaidi kangunada ñangunabi tukiguna saludabachun munashkamundash ¿imachari tukunguichi? ");
INSERT INTO qxl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kangunaga wañushkagunada pambana pi na rikibuj ut'ku layaguna gashkamundaga ¿imachari tukunguichi? Chi jawada purijkunaga kangunaj ukubi ima ismushkada na yachanchu.” ");
INSERT INTO qxl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Shina niki Moisés mandashkada yachachijkunapuramunda shujka kashna niga, “Yachachij, kan shina nishaga ñukuchidashmi rimangui.” ");
INSERT INTO qxl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Shina niki Jesús niga, “Moisés mandashkada yachachijkunash ¿imachari tukunguichi? Shujkunadaga na aguantibuj ruranadash rurachun ninguichi. Kangunaga imalladash na ayudanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¿Imachari tukunguichi? Kangunaj ñauba taitaguna wañuchishka Dios nishkada parlujkunaj samarina ukugunada rurashkanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Shina rurashkamundaga tukiguna kangunaj ñauba taitagunan shuj yuyilla tukushkada yachanmi. Paigunaga Dios nishkada parlujkunada wañuchishka. Kangunaga Dios nishkada parlujkunaj wañushka samarina ukugunada ruragunguichi. ");
INSERT INTO qxl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Chimundami Diosga tukida yachuj gasha kashna niga ‘Ñukamunda parlujkunada, Ñukaj agllashkagunadash kachushami. Maijindaga wañuchingami, shujkunadaga katik'ichungagunami.’ ");
INSERT INTO qxl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Chimundami Diosga kunun p'unllagunabi kausujkunadaga kai pachada rurashkamundadi Dios nishkada parlujkunada, Abelmunda pacha Zacariasgama yaurda jicharishkamundaga kangunaj jawabimi llakichinaga urmunga. Zacariastami Diosbuj altargun Paibujlla ukun chaubibi wañuchishkaguna. Ari, kangunada nini, tuki kaigunamundami kai p'unllabi kausajkunaj jawabi llakiga urmunga. ");
INSERT INTO qxl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Moisés mandashka ima shina gashkada yachachijkunalla ¿imachari tukunguichi? Kangunaga yachangu munajkunada llaveda kichushkanguichi. Kangunalladikish na waigushkanguichichu, shinaidi munajkuna waiguchunbish na sakinguichichu.” ");
INSERT INTO qxl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús chimunda llujshikiga Moisés mandashkada yachachijkuna, fariseogunash mejor p'iñarisha tauga tapunagunan Paida p'iñachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Paigunaj yuyibiga na allida vueltachikiga juchachingu nishami shinaga tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Waranga waranga vali genteguna tandanukusha kaishuj chaishuj llapirinukugukiga Jesusga Paibuj yachagujkunadadi kashna niga, “Levadura laya gaj fariseogunamunda yuyin puringuichi. Paigunaga imadash nij tukujllagunami gan. ");
INSERT INTO qxl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ima pakushkash na pakalla tiyangachu. Imada washalla rurushkash k'ipaga yacharingami. ");
INSERT INTO qxl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kanguna tuta pakalla parlanukushkash p'unllami yacharinga. Wasi ukubi kanguna pungu ichkarisha allilla imadash parlanukushkash wasi jawamunda kaparisha parlashka layami uyaringa.” ");
INSERT INTO qxl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesusga kashnami niga, “K'uyashkaguna, kangunamumi parlani. Aichada wañuchijkunadaga ama manchanguichichu. Chi k'ipaga imadash na ruri pudingagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pida manchana gashkadami parlasha nini. Kausida kichushka k'ipa uku pachamu kachi pudij Diostami manchana ganguichi. Ari, Paida manchichi, kangunada nini. ");
INSERT INTO qxl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Nachu pichka pishkuga ishki kuchkilla valin? Ashalla valijkuna gakish Diosga paigunadaga ni shujlladash na kungarinchu. ");
INSERT INTO qxl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kangunaga tauga pishkugunadash yalli valijmi ganguichi. Uma juakchash tuki cuentashkami gan. Shinusha ama manchanguichichu.” ");
INSERT INTO qxl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kaidash parlanimi, gentegunamu Ñukamunda parlujtaga Aichayuj tukushka Churish paigunada Diosbuj angelgunaj ñaubuki <Rijsinimi> ningami. ");
INSERT INTO qxl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ashtanbish gentegunaj ñaubuki <Na rijsinichu> nijtaga Diosbuj angelgunaj ñaubukish <Na rijsinichu> nishami. ");
INSERT INTO qxl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Aichayuj tukushka Churida rimujtaga Diosga perdonangami, ashtan Diosbuj Espirituda millusha p'iñasha rimujtaga Diosga nalladi perdonangachu. ");
INSERT INTO qxl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Diosmunda yachana wasimu na gashaga jatun mandajkunajmu juezkunajmu kangunada juchachisha pushaki <¿Imadadi nishun?> nishaga ama manchanguichichu. ");
INSERT INTO qxl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chibiga Diosbuj Espiritulladimi kangunamu ima parlana ministishkada yachachinga.” ");
INSERT INTO qxl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Gentegunaj chaubimunda shujka Jesusta kashna niga, “Yachachij, ñuka waukida taita mamamunda japishkada ñukamu kuna gashkada chaubisha kuchun nisha mandabai.” ");
INSERT INTO qxl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Shina niki Jesús kashna niga, “¿Pidi Ñukada kangunaj juez na gashaga partij gachun nisha churaga?” ");
INSERT INTO qxl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kaidash niga, “Charij tukunallada ama mununguichichu. Yalli charishkallamundaga kausiga na tiyanchu.” ");
INSERT INTO qxl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chimundami kai yuyachinada Jesús parlaga, “Shuj charijmi tiyaga. Paibuj achpamundaga mejor granugunada japiga. ");
INSERT INTO qxl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Shina japisha paiga ‘¿Imadadi kai tuki granudaga rurasha? Maibi wakichinada na chariniga,’ nisha yuyariga. ");
INSERT INTO qxl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chimunda kashna yuyariga ‘Kununga imada ruranadash ña yachanimi. Kai wasigunada urmachisha. Tuki granuda imalla charishkadash wakichingu shuj jatun wasigunada kutin rurasha. ");
INSERT INTO qxl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chi k'ipa ñukaga kashnami yuyasha, tauga watagunajmi alligunada charini. Kunundijka samasha, mikusha, ubiasha, kushilla kausasha.’ ");
INSERT INTO qxl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Diosga paida kashna niga ‘Na intindij, kunun tutaidimi wañungui. Kan wakichishkaga ¿pibujshi ganga?’ ");
INSERT INTO qxl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Shinami maijinsh kai kausillabi pachun tandachisha wakichigujllaga Diosbuj ñaubukiga na charij gasha llaki tukun.” ");
INSERT INTO qxl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús Paibuj yachagujkunada kashna niga, “Chimunda kaidami kangunamu nini <¿Imadadi mikushun, churashun?> nisha, ama mancharij shina chi yuyilla gaichichu. ");
INSERT INTO qxl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kausimi mikunada yalli valin. Kikinbuj aichami churanadash yalli valin. ");
INSERT INTO qxl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Angagunada rikusha yuyarichi. Paigunaga na tarbunchu, granuda na tandachinchu. Wakichina ukudash wasidash na charinchu. Shina gakish Diosga karanllami. Kangunagarin pishkugunadash yallimi valinguichi. ");
INSERT INTO qxl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Shina gakiga maijinsh mancharishka yuyin unida kausungu munashash ¿ima layadi shuj uraidash ashtan kausangari? ");
INSERT INTO qxl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chi p'ichilladash na ruri pudishaga ¿ima nishadi chishuj ruranagunadash yuyanguichi? ");
INSERT INTO qxl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lirio sisada rikichiri. Paigunaga na imadash ruranchu, na puchkanchu. Shinash kangunada ninimi, Rey Salomonga pai tukida charij gashash na kai sisaguna layaga k'uillada churarigachu. ");
INSERT INTO qxl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","¡Na tuki shungun crijkuna! Diosga kunun sisaguj k'iwadash kaya rupachina gakish k'uillada iñachij gashadijka kangunamungarin Paiga chidash yallidami churachinga. ");
INSERT INTO qxl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chimunda mikunada, ubianada mashkusha ama llakilla puringuichichu. ");
INSERT INTO qxl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Diosta na rijsijkunallami kashna yuyusha kausun. Kangunaj Taitaga ima ministigushkadash yachanmi. ");
INSERT INTO qxl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kangunaga Diosbuj mandanabi kausanada mashkichi. Shinaga ima ministigushkash kushkallami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ñuka agllashkagunalla, ashalla gashash ama mancharichichu. Taitaga kangunamu kungu munashkamundami Pai mandanada kusha nin. ");
INSERT INTO qxl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Imalla charishkada k'atusha ministijkunamu kuichi. Jawa pachabi tukimunda yalli alli na tukurij charinagunada wakichisha na maugayaj shigragunada rurichi. Chibiga shuwagunash na waigungachu, polilla k'urugunash na tukuchingachu. ");
INSERT INTO qxl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kaida yuyarichi, maibimi imalla charishkagunada wakichinguichi, chibimi kangunaj shunguga yuyagun.” ");
INSERT INTO qxl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kangunaga alli churarishka, luzta katichishka shina alli yuyin chapanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ima layami sirvijkuna amo bodamunda shamusha punguda takuki paskungu chapagun, shinaidimi kangunash shuyananguichi. ");
INSERT INTO qxl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Amo shamusha rijchujta japiki chapagujkunaga kushiyangami. Kabishkadadimi nini, amolladimi sirvijkuna churanada churarisha paigunadaga mizamu tiyachisha karungu kallaringa. ");
INSERT INTO qxl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaubi tuta na gashaga p'unllayanada shamushash rijchuj chapagujkunada japishkamunda kushiyanguna. ");
INSERT INTO qxl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kaidash yachichi. Shuwa shamunada wasiyuj yachushaga shuwa waiguchunga na sakinmunchu. ");
INSERT INTO qxl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kangunash rinalla shuyanguichi. Nash yuyashkadami Aichayuj tukushka Churiga shamunga.” ");
INSERT INTO qxl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro tapuga, “Mandaj Jesús ¿kai yuyachinadaga ñukuchillamuchu tukigunamuchu parlugangui?” ");
INSERT INTO qxl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Shina tapuki Jesusga kai parluda yachachingu kallariga, “¿Maijindi alli kazusha alli yuyarisha sirvij gan?” nisha tapushka k'ipaga, “Sirvijkunada sirvijmu paibuj amo <Wasida rikubangui. Sirvijkunamush mikuna uras tukuki karabangui> nisha mingusha rishaga ");
INSERT INTO qxl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","amo shamusha kai mingashkada p'aktachigujta japiki sirvijmi kushilla ganga. ");
INSERT INTO qxl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kabishkadadimi nini, alli rurashkamunda amoga tuki imalla charishkada paimu mingusha churanga. ");
INSERT INTO qxl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ashtan chi sirvijka, ‘Amo na ut'ka shamungachu,’ yuyusha, chaishuj sirvijkunada k'arida warmida takusha paiga mikusha ubiasha shinga puriguga. ");
INSERT INTO qxl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Paibuj amo ima p'unlla ima uras shamunadash na yachusha shina puriguki amo shamushaga mandushkada na kazushkamundaga jinchida takasha na crijkunapura llakichishka gachun llujshichishami kachunga. ");
INSERT INTO qxl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Amo imada rurachun nishkada yachushash na kazujka mejorda takasha llakichishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ashtan amo nishkada na yachushalla imadash na alli rurashaga na mejor takushka gangachu. Pimush yalli kukiga chish yallidami mañashka ganga. Maijinmush alli mingashaga ashtan allidami rurachun ninga.” ");
INSERT INTO qxl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ñukaga kai pachabi ninada japichingumi shamugani. ¡Ña rupagushaga allichari ganmu! ");
INSERT INTO qxl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Shuj llaki bautismo layadami apana gani. Chi p'aktangagamaga manchanaidi llakimi purini. ");
INSERT INTO qxl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kangunaga <Kai pachabi alli apanukunagunada kungajmi shamushkanga> nisha ama yuyanguichichu, ashtan Ñuka shamushkamundami p'iñanukiguna tiyanga, kangunada ninimi. ");
INSERT INTO qxl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kununmundaga shuj wasibi pichkapura kausujkunamundaga ishkiga kinsadami p'iñanga, kinsagunaga ishkidami p'iñanga. ");
INSERT INTO qxl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taitaga churida, churiga taitada, mamaga ushida, ushiga mamada, suegraga k'achunda, k'achunga suegradami p'iñanga.” ");
INSERT INTO qxl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kaidash Jesús taugagunada niga, “P'uyu indi waiguna ladumunda shamujta rikushaga, ‘Tamiangami,’ nijminguichi. Shinami tukun. ");
INSERT INTO qxl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","‘Chakishka pushtumunda waira shamukiga rupiga katinga,’ ninguichi. Shinami tukun. ");
INSERT INTO qxl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ishki siki na alli shunguguna, kangunaga p'uyuda rikusha ima laya p'unlla ganada yachajkunashdijka ima p'unllabi kausashkada ¿imashti na yachanguichi?” ");
INSERT INTO qxl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Imashti alli gashkada na alli gashkada tuki shungun kanlladi na yuyaringui? ");
INSERT INTO qxl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pish kanda juchachisha juezbujmu pushakiga ñanda rigushaidi paigun alli tukunada mashkungui, ama juezbujmu pushachun, juez guardamu ama kuchun, guarda carcelbi ama churachun. ");
INSERT INTO qxl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tukida pagungama kanga chimundaga na llujshinguichu, ninimi.” ");
INSERT INTO qxl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chi p'unllagunalladimi gentegunaga Jesusbujmu risha, “Galilea llaktabi kausajkuna animalgunada Diosmu kusha sacrificioda ruraguki Pilatoga chi israelgunada wañuchishkami,” nisha parluga. ");
INSERT INTO qxl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Shina niki Jesusga kashna niga, “Kangunaga <Chi wañujkunaga chaishuj galileogunada ashtan yalli juchayujkunashkamundami shina tukushkanga> ¿yuyanguichichu? ");
INSERT INTO qxl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na shinachugun, ninimi. Paiguna laya kangunalladikish Diosmu na vueltashaga wañunguichimi. ");
INSERT INTO qxl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloebish tiyaj jatun torre urmushaga chunga pusujkunadami (18) llapisha wañuchiga. <Paigunaga Jerusalén pueblobi kausagujkunada yalli juchayuj gashkamundami wañushkanga> ¿yuyanguichichu? ");
INSERT INTO qxl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na shinachugun, ninimi. Kangunalladikish juchagunada na sakisha Diosmu na vueltashaga wañunguichimi.” ");
INSERT INTO qxl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Paiguna yuyarichun nisha Jesús kashna parluga, “Shujka paibuj achpabi jigus yurada lantusha chariga. <Ña aparishkaminga> yuyusha rikungu rishaga ni shuj jigustash na japigachu. ");
INSERT INTO qxl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Shina imadash na japishaga yurada chapajta, ‘Ñami kinsa watada kai yurabiga imadash na japini. ¿Imajti yangaga kai achpabi tiyanga? P'itisha shiti,’ nigami. ");
INSERT INTO qxl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Shina niki achpada chapajka kashna niga ‘Achpayuj, kai watan sakibai. Achpada ñutusha majadadash churungumi rini. ");
INSERT INTO qxl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kashna rurukiga aparish aparingachari. Na aparikiga p'itishtashkami ganga.’ ” ");
INSERT INTO qxl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Samana p'unllabi Diosmunda yachana wasibi Jesús yachachiguga. ");
INSERT INTO qxl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chibiga chunga pusuj (18) watada ungushka warmi tiyaga. Yana japishkamundami lumuda tukusha imakish na dirichu shayari pudij gaga. ");
INSERT INTO qxl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús paida rikusha kayushaga, “Riki, kambuj unguiga ñami anchuchishka gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chimunda paibuj jawabi makida churunmi warmiga dirichu shayarisha Diosta <Allimi gangui> ningu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Samana p'unllabi Jesús alliyachijta rikushami Diosmunda yachana wasibi pushujka ashtan mejorda p'iñarisha chibi gajkunada, “Imada rurungukish sujta p'unlladami charinchi. Chi p'unllagunabimi jambiringajka shamuna ganguichi, samana p'unllabiga mana,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Shina niki Mandaj Jesusga niga, “Ishki siki yachuj shinalla purijkuna kangunash wagrada burruda yaku ubiachunga samana p'unlla gakish ¿nachu kacharinguichimu? ");
INSERT INTO qxl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kai warmiga ñauba taita Abrahambuj wawagunaj wawami gan. Paidami chunga pusuj (18) watada kai unguin watushka layada Satanás charishka. ¿Nachu samana p'unlla gakish paidaga alliyachina gan?” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús shina nikiga tuki Paida p'iñujkunaga pinganaidi tukugaguna. Kaishujkunaga Jesús tauga k'uilladij alli rurujta rikusha kushiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kutin Jesusga, “Diosbuj mandanaga ¿ima layadi rikurin? ¿Imandij ch'imbapurusha ‘Kai layami chai layami gan’ nisha? ");
INSERT INTO qxl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Diosbuj mandanaga uchilla mostaza muyu shinami gan. Shujka paibuj achpabi tarbuki iñusha jatun yura tukuki pishkugunash ramagunabi tazunda rurusha kausanllami,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kaidash Jesusga, “Diosbuj mandanadaga ¿imandij ch'imbapurusha?” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","“Diosbuj mandanaga levadura shinami gan. Shuj warmi tandada rurungu kinsa batia vali kutabi ashalla levadurada churusha chapukish illijtami masada p'unguichin,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalenmu rigushami Jesusga, pueblogunabi, uchilla pueblogunabish yachachisha riga. ");
INSERT INTO qxl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Shina riguki shujka, “Mandaj Jesús ¿ashagunallachu kishpichishka ganga?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesús kashna niga, “Kangunada ninimi, taugaguna waigungu munashash na waigui pudingagunachu. Chimunda kichki punguda waigungujka ima pudishkada ruranguichi. ");
INSERT INTO qxl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wasiyuj jatarisha punguda ichkushka k'ipa kanguna washabi sakirijkunaga waigusha nishami, ‘¡Wasiyuj! Ñukuchidash waiguchibai,’ ninguichi. Shina niki Ñukaga, ‘¿Maimundachari ganguichi? Na rijsinichu,’ nishami. ");
INSERT INTO qxl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Shina nikimi kangunaga, ‘Kangun igulda mikuganchindi, ubiaganchindi, shinaidi ñukuchi ñangunabish yachachiguganguindi,’ ninguichimi. ");
INSERT INTO qxl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Shina niki Ñukaga wasiyuj gashkamundaga, ‘Na rijsinichu, maimundacharinguichi. ¡Imadash na alli ruragujkuna Ñukamunda anchichi!’ nishami. ");
INSERT INTO qxl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ñauba Abrahamda, Isaacta, Jacobda, shinaidi Dios nishkada parlujkunadash Diosbuj mandanabi tiyajta rikusha kangunaga kanllamu shitushka gashkamundaga kiru kanirisha karrusk'ichisha llakinaidami wakunguichi. ");
INSERT INTO qxl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Diosbuj mandanabi tiyarisha mikungujka tuki ladumundami shamunga. ");
INSERT INTO qxl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chibiga taugaguna kunun k'ipa gajkunaga k'ipaga ñaubungagunami. Shinaidi taugaguna kunun ñaubusha gajkunaga k'ipabi gangami,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Shinaidi fariseoguna shamusha Jesusta, “Kaimunda ut'ka ri. Kandaga Herodes wañuchisha nigunmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Shina niki Jesusga, “Chi engañaj zorro shinamu, ‘Uyi. Kununbish kayash yanagunada llujshichisha, ungushkagunadash alliyachisha, chaishuj kayagamash tukuchishami,’ ninmi ningaj richi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Shina gakish Ñukaj ñandaga kunun kaya chaishuj kayash rigushallami. Dios nishkada parlujka shuj llaktabiga mana wañunallachu, Jerusalenllabidimi wañuna gan. ");
INSERT INTO qxl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ai Jerusalén pueblobi kausujkuna, kangunaga Dios nishkada parlujkunada wañuchijkunami ganguichi. Kangunamu parlachun nisha Dios kachushkagunadash rumigunan pigujkunami ganguichi. Ñukaga tauga kutin mama atil wawagunada kayusha tandachisha uglluj shina kangunada tandachisha nigani. Shinash kangunaga na uyuganguichichu. ");
INSERT INTO qxl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Shinushaga kangunaj Diosbuj wasiga shitushkami sakiringa. Kangunada ninimi, Manduj Diosbuj shutibi Shamujtaga ‘Alli nishka gachun’ ningagama Ñukadaga kutinga na rikunguichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Samana p'unllabi fariseogunada mandujbuj wasibi Jesús mikungu riki chaishuj fariseogunaga yuyin rikuriaga. ");
INSERT INTO qxl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chibimi paibuj aicha p'unguishka llakinaida kausujbish Jesusbuj ñaubuki tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ungushkada rikusha Moisés mandashkada yachachijkunada fariseogunadash Jesusga, “Samana p'unllabiga ¿ungushkagunada alliyachinallachu gan?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Shina tapuki paigunaga upalla tiyaga. Jesusga chi ungushkada japisha alliyachishaga <Rilla> nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chi k'ipa fariseogunada kashna niga, “Samana p'unllabi kangunaj churi na gashaga wagra yaku ut'kubi urmukiga ¿nachu llujshichinguichimu?” ");
INSERT INTO qxl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Shina niki imada na ni pudisha tiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kayashkaguna alli pushtuda mashkusha tiyarijta rikusha Jesús kai yuyachinan yachachiga: ");
INSERT INTO qxl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bodamu shamuchun niki rishaga ama alli pushtubi tiyaringuichu. Ñadikish kanda yalli valij kayushka shamunmu. ");
INSERT INTO qxl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chimunda bodamu kayuj shamusha ‘Kaimunda anchi pai tiyarichun’ niki p'akta pinganaida washabi tiyaringu ringuimu. ");
INSERT INTO qxl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ashtan <Bodamu shamungui> nikiga washamu tiyaringui. Chibi tiyajta rikusha bodamu kayujka, ‘Kaiwamu tiyari,’ ningami. Shina niki kanga <Alli> nishkami tukigunaj ñaubuki rikuringui. ");
INSERT INTO qxl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","<Tukimunda yallimi gani> yuyashkamundaga <Imash na ganchu> nishkami ganga. Shinaidi <Imash na ganichu> nijka jatunyachishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús bodamu kayujtash kashna niga, “Bodamu kayushaga kambuj rijsishkagunada, wauki panigunada, familiagunada, charij vezinogunalladash ama kayunguichu. Paigunash kan kayushkaguna gashkamundaga kan layaidimi karunga. Shina rurushami randimunda kayanukusha mikunguichi. ");
INSERT INTO qxl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ashtan bodada rurashaga imadash na charijkunada, imadash na ruri pudijkunada, suchugunada, na rikujkunadash kayangui. ");
INSERT INTO qxl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Shina rurashaga ashtan kushiyanguimi. Paigunaga iman na pagui pudingachu. Shinash kanga kabishkada rurujkuna kausari p'unllaga alli kumbidashkadami japingui.” ");
INSERT INTO qxl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kashna nijta uyusha Jesuskun tiyarishkagunamunda shujka Paida kashna niga, “¡Pish Diosbuj mandanabi k'uilla mikunada mikujka kushiyangami!” ");
INSERT INTO qxl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Shina niki Jesús niga, “Shujmi jatun boda shinada rurasha mikunada karungu taugagunamu parlachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ña mikunalla gaki sirvijtaga kayushkagunajmu ‘Tukida ña parijashkami gan; shamichilla,’ nichun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Shina kayukish tukigunami ‘Na ri pudinichu,’ nij tukungu kallarigaguna. Shujka kashna niga ‘Achpada randigani. Chida rikungumi rina gani. Perdonabai.’ ");
INSERT INTO qxl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kaishujkish niga ‘Chunga wagragunada randigani. Ima laya yapujta rikungu riguni. Perdonabai.’ ");
INSERT INTO qxl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chaishujka niga ‘Kazaranillami. Chimunda na ri pudinichu.’ ");
INSERT INTO qxl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sirvij ña kutin shamushaga tukida amomu parluga. Chida uyusha amo p'iñarisha paida sirvijta kashna niga ‘Pueblobi, lasagunabi, ñangunabi purigujkunada, imadash na charijkunada, imadash na ruri pudijkunada, suchugunada, na rikujkunadash kununlladi pushamungu ri.’ ");
INSERT INTO qxl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sirvij ña kutin shamusha kashna niga ‘Amo, kan mandushkada ña ruramunimi. Shinash chairijti genteguna jualtunmi.’ ");
INSERT INTO qxl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Shina niki amoga paibuj sirvijta niga ‘Ñukaj wasibi junda gachun chaishuj ñangunada lindi kuchugunabi purijkunadash <Shamuchunlladi> ningaj ri.’ ");
INSERT INTO qxl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kangunada ninimi, ñaubashadi kayushkagunaga maijinsh ñuka mikunadaga na mikungachu,” nishami Jesusga parlaga. ");
INSERT INTO qxl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tauga taugalladijkuna Jesusta katiki Paiga vueltarisha kashna niga, ");
INSERT INTO qxl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Maijinsh Ñukamu shamush nisha, taitada, mamada, warmida, kusada, maragunada, wauki panigunada, turi ñañagunada, kai pacha kausidash ashtan Ñukadash yalli llakisha na sakijka na Ñukaj yachaguj gai pudinchu. ");
INSERT INTO qxl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Maijinsh cruzbi llakichinada manchusha na Ñukada katijka na Ñukaj yachaguj gai pudinchu. ");
INSERT INTO qxl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Maijinsh kanguna torreda rurungu kallarish nigushaga <¿Tukuchingujka p'aktachinachushkani?> nisha ¿nachu mashna gastarinashkada cuenta rurunguichimu? ");
INSERT INTO qxl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ashtan rumigunada pambushka k'ipa na tukuchi pudikiga tuki rikujkunami paida asingu kallaringa ");
INSERT INTO qxl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kashna nisha ‘Kai wasichijka kallarishash ¡na tukuchi pudishkachu!’ ");
INSERT INTO qxl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Shinalladi maijin mandujbish shuj mandujkun takanukungu rigushaga ¿nachu yuyaringudi kallarinmu? Ñukaj chunga warangagunan (10.000) chaishujbuj ishki chunga waranga (20.000) soldadogunan shamuki ¿shayaringu pudishacha? ");
INSERT INTO qxl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na shayari pudina gashaga chaishuj manduj karuda shamugujllabidimi ‘Na takanukush ninichu. Ima layash alli tukushun’ nisha paibuj parlujkunada kachunmu. ");
INSERT INTO qxl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Shinaidi maijinsh kangunamunda tuki imalla charishkada na sakishaga na Ñukaj yachaguj gai pudinchu.” ");
INSERT INTO qxl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kachiga allimi. Chamuj tukushaga ¿imajti valingari? ");
INSERT INTO qxl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Achpajllash ni majadan chapunajllash na valinchu. Shinushaga shitanami gan. ¡Maijinsh uyungu rinrinda charijka uyichi!” ");
INSERT INTO qxl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impuestoda Romamu cobrajkuna juchayujkunash Jesús parlashkada uyungu kuchuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseoguna Moisés mandushkada yachachijkunash kashna nisha rimagugaguna, “Paiga juchayujkunan alli apanukuj iguldash mikujllami gan.” ");
INSERT INTO qxl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chimunda Jesusga kai yuyachinagunada parlaga, ");
INSERT INTO qxl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kangunapuramunda maijin patsuj (100) ovejada charisha shuj oveja chingarikiga ¿nachu iskun chunga iskun (99) ovejada michina pushtubi sakisha chingarishkada japingagama mashkungu rinmu? ");
INSERT INTO qxl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Japishaga kushilladimi rigra jawabi churunmu. ");
INSERT INTO qxl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wasimu chayushaga paibuj apanukujkunada vezinogunadash kayusha kashnami ninmu ‘Ña chingushka ovejada japiganimi. Kushiyashunchi.’ ");
INSERT INTO qxl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kangunada kashnami nini, shinaidimi jawa pachabish shuj juchayuj Diosmu vueltamukiga manchanaidimi kushi tiyan. Iskun chunga iskun (99) alliguna, Diosmu vueltanada na ministijkunadash yalli kushimi ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Maijin warmish chunga kuchkida charisha shujta chingachishaga ¿nachu luzta japichisha wasi ukuda p'ichusha kallarishaldi japingagama mashkunmu? ");
INSERT INTO qxl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chingarishka kuchkida japishaga paibuj apanukujkunada vezinagunada kayusha, ‘Chingarishka kuchkida ña japiganimi. Kushiyashunchi,’ ningami. ");
INSERT INTO qxl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Shinaidi kangunada ninimi, shuj juchayuj Diosmu vueltamukiga Diosbuj angelgunabi jatun kushimi tiyan.” ");
INSERT INTO qxl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús kaidash parluga, “Shuj taitaga ishki churida chariga. ");
INSERT INTO qxl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","K'ipa churimi taitada niga, ‘Taitalla, kan charishkamunda ñuka japina partida kunundi kubai.’ Shina niki partisha kuga. ");
INSERT INTO qxl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Asha p'unlla k'ipaga paibuj partida k'atusha kuchkin shuj llaktamu riga. Paibuj munida rurasha imadash randisha llakinaidi kaususha tuki kuchkida tukuchiga. ");
INSERT INTO qxl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Shina tukuchishka k'ipaga chi llaktabi mikuna illashkamunda imadash na miki pudisha yarijin puringu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Shina kausagushami chi llaktamunda k'aridaga <Trabajachibai> nikiga paibuj achpagunabi k'uchida michichunmi kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pai manchanai yarijachishaga k'uchigunamu karashka k'iwa layada sajsangama mikungu munaga. Shina yuyakish pish na karugachu. ");
INSERT INTO qxl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Chimunda yuyaringu kallariga, ‘Ñukaj taitaj wasibi trabajajkunaga mikunada yallimanaidimi charinguna. Ñukaga kaibi yarijinmi wañuguni. ");
INSERT INTO qxl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ñukaj taitaj wasimu vueltasha chayushaga kashna nisha “Diosbuj ñaubuki kambuj ñaubukish juchadami rurashkani. ");
INSERT INTO qxl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ñukaga kambuj churi shinaga na gai pudinichu. Ñukadaga kambuj trabajagujta laya rurabai.” ’ ");
INSERT INTO qxl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Shina yuyarishami paibuj taitaj wasimu vueltamuga. “Karuda shamujta paibuj taita rikushaga paida manchanaidi llakisha ut'kada kuchuyashaga ugllarisha muchuga. ");
INSERT INTO qxl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Churiga kashna niga, ‘Taita, Diosbuj ñaubuki kambuj ñaubukish juchadami rurashkani. Ñukaga kambuj churi shinaga na gai pudinichu.’ ");
INSERT INTO qxl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Shina gakish paibuj taitaga trabajajkunada kashna niga, ‘Tukida yalli k'uilla churanada apamusha, makibi sortijista chakibiga pargatida churachichi. ");
INSERT INTO qxl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","¡Alli pishtada rurusha k'uilla mikungu gordo billida aisamusha wañuchichi! ");
INSERT INTO qxl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kai ñuka churiga wañushka laya gashash kausarij layami vueltamushka. Chingarishka laya gashash kutin shamushkami,’ nisha pishtada rurungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Chigamaga ñauba churiga chagrabi puriga. Pai vueltamushaga wasimu kuchuyamugusha dansujkunadash tonodash uyaga. ");
INSERT INTO qxl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chimunda shuj sirvijta kayushaga <¿Imadadi ruragunri?> nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Shina tapuki kashna niga, ‘Kambuj waukimi imash na tukushalla shamushka. Chimundami ñukuchida kambuj taitaga gordo billida aisamusha wañuchichun kachuga.’ ");
INSERT INTO qxl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Shina nikiga ñauba waukiga manchanai p'iñarisha wasimu na waigush niga. Chimunda paibuj taita llujshisha waiguchun nisha mañuga. ");
INSERT INTO qxl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Churiga taitada kashna niga, ‘Kan yachunguimi. Kai tuki watagunada ima mandushkadash kazushami kausashkani, ashtan ñukan apanukujkunan mikuchun shuj chivowaidash na kuganguichu. ");
INSERT INTO qxl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ashtan, kununga kai kambuj churi, na alli warmigunan kuchkida tukuchisha shamukish gordo billidami wañuchishkangui.’ ");
INSERT INTO qxl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Shina niki taitaga, ‘Ñuka churilla, kanga tukibimi ñukan gashkangui. Tuki ima charishkash kambujmi gan. ");
INSERT INTO qxl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kambuj waukiga kaimunda rishaga wañushka laya gashash kununga kutin shamushaga kausarishka layami gan. Chingashka laya gakish ña japishkanchimi. Shinushkamundaga alli pishtada rurusha kushillami gananchi,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús Paibuj yachagujkunamu kai yuyachinanbish parluga, “Shuj charij amoga sirvijkunada mandujta chariga. Shujkunaga amomunga ‘Chi kanda sirvijka kambuj charishkada yangabimi tukuchigun’ nisha paibuj ñaubuki juchachiga. ");
INSERT INTO qxl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Amoga chi mandujta kayusha kashna niga, ‘Kanmunda shujkuna juchachigushkaga ¿imadikun? Ñuka charishkagunan imada rurashkada parli. Kununga ñukaj sirvijkunada mandusha katingujka na pudinguichu.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chida uyasha chi mandujka yuyaringu kallariga, ‘Kununga amo na trabajachikiga ¿imadadi rurasha? Achpabi jinchida rurangujka na pudinichu. Limusnangu rinadash pingananmi. ");
INSERT INTO qxl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Trabajo illuj sakiriki maijinsh ñukada paigunaj wasibi japichun ima ruranada ñami yachani.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chimunda paibuj amomu dibijkunada shuj shuj kayusha ñaubusha shamujtaga, ‘¿Mashnadadi ñukaj amomunga dibingui?’ tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Shina tapuki, ‘Patsuj (100) barril aceitedami dibini,’ niga. Chi mandujka niga, ‘K'aiga. Kaimi gan kan pagana recibo. Tiyari. Kununga pichka chungaida paganada ruri.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chi k'ipa shujta tapuga, ‘Kanga ¿mashnadadi dibingui?’ Paiga, ‘Patsuj (100) sako trigoidami dibini,’ niga. Chimunda chi mandujka, ‘K'aiga. Kaimi gan kan pagana recibo. Kununga pusuj chungaida (80) paganada ruri,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chi na alli manduj ima laya rurashkada yachashaga amoga paida <Allidimi yuyashkangui> niga. Shinaidimi Diosta na crijkunapuraga imada rurungabujka Diosta crijkunadaga yallimi yuyajkuna gan. ");
INSERT INTO qxl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kangunada nini, kai pachabi tukurijlla charishkagunada kusha ashtan apanukujkunada japichi. Charishkaguna tukurikish na tukurij kausanagunabimi japishka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Maijin ashallan allida rurujka milganbish allidami rurunga. Shinaidi ashallan na allida rurujka milganbish na allida rurunga. ");
INSERT INTO qxl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Shinaidi kai pachabi imalla charishkadash kanguna na alli rurukiga ¿pidij jawa pachabi imalla valij charishkadash mingungari? ");
INSERT INTO qxl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Shujkuna mingashkada na alli rurakiga ¿pidij kangunamu kunashkadaga kungari? ");
INSERT INTO qxl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Maijin sirvijkish ishki amodaga na sirvi pudinchu. Shujtaga p'iñangami, chaishujtaga llakingami. Na gashaga shuj amo mandashkada rurungami, chaishujbujta na rurusha paida na rikunachinga. Diostash charishkagunadash na sirvi pudinguichu.” ");
INSERT INTO qxl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseoguna kuchkida charinaida munujkunashkamunda kaida uyushaga Jesusta p'iñasha asigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús kashna niga, “Kangunaga shujkunaj ñaubuki alli rikurisha puringuichi, ashtangarin kangunaj shunguda Diosga rijsinmi. Kai pachabi gajkuna alli nishkadaga Diosga na rikunachinchu.” ");
INSERT INTO qxl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moisés mandashkaguna, Dios nishkada parlujkuna escribishkash Bautizaj Juanchu parlangamamiga. Chimundaga Diosbuj mandana ima layashka Alli Shimida parlungumi kallariga. Tukigunami Diosbuj mandanamunga ima layash waigusha ninguna. ");
INSERT INTO qxl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Jawa pachash kai pachash tukurinmullami, ashtanbish tuki Dios mandashka shimiguna p'aktagungallami.” ");
INSERT INTO qxl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Shuj kusa paibuj warmin partirisha shuj warmida kazarajka wainayajmi. Partirishka warmida kazarakish wainayajlladimi gan.” ");
INSERT INTO qxl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Shuj charijmi alli k'uilla churanada churaj, cada p'unlla k'uilla mikunada karaj gaga. ");
INSERT INTO qxl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Charijbuj wasi pungubimi imadash na charijka illujta ismushka aicha karayuj Lazaroga tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Paiga charijbuj mizamunda urmachishkalladash mikungu munaga. Shina tiyakimi achkuguna llagada lambingu kuchuyaga. ");
INSERT INTO qxl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Shuj p'unlla kai mañaguj wañukiga angelguna shamusha ñauba Abrahamgun jawa k'uilla llaktabi kausachun pushuga. Charijkish wañukiga pambugami. ");
INSERT INTO qxl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Chi charijka uku pachabi llakinaida tiyagusha jawada rikusha karumunda Abrahamgun Lázaro igul tiyajta rikuga. ");
INSERT INTO qxl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chimunda kapariga, ‘Taita Abraham, ñukada llakibairi. Lazaroda kachabai yakubi didu puntada satisha ñukaj k'alluda chiriyachingu shamuchun. Ñukaga kai ninabi llakinaida rupaguniga.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamga kashna niga, ‘Ñuka k'uyashka, yuyari. Kanga alli kausaganguindi, paiga llakinaidami kausaga. Kununga Lazaroga allimi kausagun, kanga jatun llakibimi tiyangui. ");
INSERT INTO qxl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ñukuchi tiyashkamunda kanguna tiyashkagamaga ima laya na ribujmi. Maijin kaimunda chaimu, chaimundash kaimu risha nishash na ri pudingachu.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Shina niki charijka niga, ‘Taitalla, shinakiga Lazaroda ñukaj taitaj wasimu kachachun mañani. ");
INSERT INTO qxl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chibimi ñukaj pichka waukiguna tiyan. Paigunash kai llaki ninamu ama shamuchun parlachun kachabai.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamga niga, ‘Paigunaga Moisesmundash Dios nishkada parlujkunaj escribishkadash charinmi. ¡Chigunada kazuchun!’ ");
INSERT INTO qxl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Charijka niga, ‘Taita Abraham, ashtan shuj wañusha kausarishka paigunamu parlakiga juchagunada sakisha Diosmu vueltaringami.’ ");
INSERT INTO qxl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamga, ‘Moisesmundash Dios nishkada parlujkunaj escribishkadash na kazushtijka shuj wañushka kausarikish na cringagunachu,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús Paibuj yachagujkunada niga, “Juchada rurana yuyiga jursa tiyagungallami. Shinash juchada rurachun inquitajka ¿imachari tukunga? ");
INSERT INTO qxl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kai uchillaguna layada juchabi urmachijtaga kutana jatun rumida kungabi watusha jatun yaku kuchabi shitanami ashtan alli ganmu. ");
INSERT INTO qxl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Yuyin puringuichi! “Kangunapuramunda kambuj wauki juchada rurakiga <¡Ama shina rurichu!> nisha yuyachingui. Shina nishkada uyusha juchagunada sakisha Diosmu vueltarikiga perdonanguilla. ");
INSERT INTO qxl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Shuj p'unllalla kanchis kutin juchada rurusha kanda p'iñachishka k'ipa kanchis kutinlladi, ‘Kutinga na shina rurushachu,’ ningu shamukiga perdonanguilla.” ");
INSERT INTO qxl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pai agllushka chunga ishkiguna Mandaj Jesusta, “Ashtan crina yuyida ñukuchimu kubai,” nisha mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Manduj Jesusga kashna niga, “Ashaida crijkuna, kai uchilla mostaza muyu valilladash kanguna crij gashaga kai jatun sicómoro yurada, ‘Kaimunda anchi. Jatun yaku kuchabi tiyaringu ri,’ nikish kazunmumi.” ");
INSERT INTO qxl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Maijin shuj sirvijta charijka pai yapusha na gashaga michisha shamukiga amoga sirvijmu, ‘Tiyaribai mikungu,’ na ninchu. ");
INSERT INTO qxl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ashtan amoga sirvijtaga ninmumi, ‘Ut'ka churarisha yanusha karasha ubiachishka k'ipami kanga miki ubi pudingui,’ nisha. ");
INSERT INTO qxl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kashna rurakish ruranalladadi rurashkamundaga sirvijtaga amoga na <Diosolopai> ninchu. ");
INSERT INTO qxl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Shinaidi kangunash Dios mandushkada tukida p'aktachishka k'ipami, ‘Ñukuchij ruranagunalladadi rurashkanchi. <Diosolopai> ninamash na kabinchichu,’ ninanguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalén pueblomu Jesús rigushaga Galilea, Samaria llaktaguna chaubidami pasuga. ");
INSERT INTO qxl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Shina rigusha shuj uchilla pueblomu chayaguki aichada ismuchij unguida charij chungaguna Jesuskun tupanukungu shamuga. Paigunaga na kuchuyashalla karubi shayarishaga, ");
INSERT INTO qxl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“¡Yachachij Jesús, ñukuchida llakibai!” nisha kapariga. ");
INSERT INTO qxl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús rikusha kashna niga, “Kangunaj aichada rikuchingu curagunajmu richi.” Shina rigujllabidimi paigunaj unguiga linshu alliyaga. ");
INSERT INTO qxl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Shujka alliyashkada yachushaga Diosta kaparisha <Allimingui> nisha vueltamuga. ");
INSERT INTO qxl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesusbuj ñaubuki <Diosolopai> nisha kungurisha achpabi tuparingama kumuriga. Paiga Samaria llaktamundamiga. ");
INSERT INTO qxl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús niga, “¿Nachu chungada alliyachigani? Iskunga ¿maibidikun? ");
INSERT INTO qxl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kai na israel-llami Diosta ‘¡Kanga allimingui!’ ningu vueltamushka.” ");
INSERT INTO qxl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chimundami Jesusga, “Kan crishkamundami alliyachishka gangui. Jatarisha rilla,” nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","“Diosbuj mandanaga ¿ima p'unlladi chayamunga?” nisha fariseoguna Jesusta tapukiga Paiga kashna niga, “Diosbuj mandana shamujtaga na rikibujllachu. ");
INSERT INTO qxl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Diosbuj mandanaga kangunabi gashkamunda, ‘Kaibimi, chaibimi tiyagun,’ nishkaga na uyaringachu.” ");
INSERT INTO qxl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Paibuj yachagujkunadash Jesús niga, “Aichayuj tukushka Churi shamuna p'unllada rikungu munashash narij rikunguichichu. ");
INSERT INTO qxl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Shujkunaga, ‘Paiga kaibimi chaibimi,’ ningagunami. Shina nikish p'akta ringuichimu, p'akta katinguichimu. ");
INSERT INTO qxl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ima layami relampa illujta p'alanisha p'unllayachin, Aichayuj tukushka Churi shamuna p'unllash shinalladimi ganga. ");
INSERT INTO qxl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Chi p'unlla narij chayaki Paiga kunun p'unlla kausajkuna p'iñushka manchanaidi llakichishkashmi gana gan. ");
INSERT INTO qxl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ima layami ñauba Noé kausi p'unllaguna tukuga, shinaidimi Aichayuj tukushka Churi shamuna p'unllabish tukunga. ");
INSERT INTO qxl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé arcabi sikungagamami gentegunaga ubiasha mikusha kazarasha kazarachisha kausagujllabidimi manchanai tamia shamusha yaku jundashaga tukigunada wañuchiga. ");
INSERT INTO qxl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Shinaidimi ñauba Lot kausi p'unllagunabish ubiasha mikusha randisha k'atusha tarbusha wasichisha kausagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot Sodoma pueblomunda llujshikiga jawa pachamunda nina azufren tamiasha tukigunada wañuchiga. ");
INSERT INTO qxl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Shinaidimi Aichayuj tukushka Churi shamunajka tukunga. ");
INSERT INTO qxl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Chi p'unllagunaga maijinguna wasi jawabi gashaga ama uku pambamu imada apangu uriyanguichu. Shinaidi chagrabi gashash ama wasimu kutin ringuichu, ashtangarin ut'kada llujshisha ringui, ninimi. ");
INSERT INTO qxl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotbuj warmi ima tukushkada yuyarichi. ");
INSERT INTO qxl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Maijinsh kikinbuj kausida llakisha kishpirijka chingaringami, ashtan kikinbuj kausida na llakishalla wañujka na tukurij kausidami japinga. ");
INSERT INTO qxl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Kaidash nini, shuj tuta ishkigunami k'awitubi puñugunga. Shujka apashka, chaishujka sakishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishki warmigunami kutagunga. Shujka apashka, chaishujka sakishkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishki k'ari chagrabi purigunga. Shujka apashka, chaishujka sakishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Shina niki Paibuj yachagujkuna tapuga, “¿Maibidi chiga tukunga, Mandaj Jesús?” Pai niga, “Maibimi wañushka sirigun, chibimi aichada mikuj angagunaga tandanukunga.” ");
INSERT INTO qxl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na tukuribujlla Diosta mañasha ama shungu urmarichun nisha Jesusga kai yuyachinan parluga, ");
INSERT INTO qxl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Sarunmi shuj pueblobi Diostash na manchuj, shujkunadash na llakij juez kausuga. ");
INSERT INTO qxl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chi pueblollabidi shuj viudaga, ‘Ñukada p'iñajkun alli gangaj allichisha kui,’ nisha juezbujmu riga. ");
INSERT INTO qxl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Juezka viuda mañushkada na ut'ka rurugachu. Chi k'ipaga, ‘Diostash na manchuj, shujkunadash na llakirij gashash, ");
INSERT INTO qxl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kai warmi kutin kutin shamushkamunda ama ashtan ñukada p'iñachisha puriguchunlla paida p'iñajkun rimarisha allichisha kusha,’ nisha yuyariga.” ");
INSERT INTO qxl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mandaj Jesusga kaidash niga, “Na alli juez gashash shina rurukidijka ");
INSERT INTO qxl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Diosgarin Pai agllashkaguna tutash p'unllash Paida mañagujllashkamundaga ¿nachu ayudanga? na gashaga ¿shuyachingachu? ");
INSERT INTO qxl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kangunada ninimi, na shuyachishallami Diosga ayudanga. Shinash Aichayuj tukushka Churi shamushaga ¿kai pachabi Paida crijkunada japingachu? ¿Imashi?” ");
INSERT INTO qxl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","<Alligunami ganchi> nisha shujkunada na valichijkunamu Jesús kutin kai yuyachinan parluga, ");
INSERT INTO qxl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishkigunami Diosta mañangu Diosbuj wasimu riga. Shujka fariseo, chaishujka impuestoda Romamu cobrajmiga. ");
INSERT INTO qxl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chi fariseoga shayarisha kashna mañuga, ‘Dioslla, ñukaga na shujkuna laya: shuwama, millima, wainayajma, chi impuestoda cobraj layash na ganichu. Chimunda Kandaga <Diosolopai> ninimi. ");
INSERT INTO qxl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ñukaga semanabi ishki kutin ayunajmi gani. Imada japishkadash patsujmunda (100) chungada kujmi gani,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ashtangarin impuestoda cobrajka karubi shayarisha llakirisha shungubi juaktarisha jawa pachamush na rikushalla, ‘Dioslla, ñukada llakibairi. Ñukaga juchayujmi gani,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kangunamu parlanimi, impuestoda cobrajtijmi wasimunga Dios perdonashka riga. Fariseoga mana. Maijinsh <Valijmi gani> nijka pinganaida na valichishkami ganga. Shinaidi <Na valichuni> nijka alli valichishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Maragunada tupachun nisha Jesusbujmu pushamukimi yachagujkunaga chida rikusha jarkugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chimundami Jesusga maragunada kayusha kashna niga, “¡Ama jarkichichu! Maraguna Ñukajmu shamuchun sakichi. Diosbuj mandanaga kashna maraguna laya gajkunajmi gan. ");
INSERT INTO qxl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kabishkadadimi nini, maijinsh Diosbuj mandanada kai maraguna laya na japijka chimunga na waigungachu.” ");
INSERT INTO qxl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Shuj mandujka Jesusta tapuga, “Alli Yachachij, na tukurij kausida japingujka ¿imadadi rurana gani?” ");
INSERT INTO qxl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús niga, “¿Imashadi Ñukada <Alli> ningui? Pillash alliga na tiyanchu. Diosllami alliga tiyan. ");
INSERT INTO qxl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mandushkagunada ña yachunguimi. Chibiga: Ama wainayanguichu. Ama wañuchinguichu. Ama shuwanguichu. Pidash juchachisha ama llullanguichu. Taita mamadash k'uyusha allida rurungui, ninmi.” ");
INSERT INTO qxl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Paiga, “Musumundadimi kai tukida p'aktachishkani,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chida uyusha Jesús niga, “Shuj ruranash jualtunmi. Tuki imalla charishkada k'atusha, na charijkunamu kuiri. Shina rurashami jawa pachabiga tukida yalli alli charinada japingui. Kushka k'ipaga Ñukada katimilla.” ");
INSERT INTO qxl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Shina nijta uyusha chi k'ariga pachun charij gashkamunda llakilladijmi tukuga. ");
INSERT INTO qxl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Llakirijta Jesús rikusha yachagujkunamu kashna niga, “¡Charijkuna Diosbuj mandanamu waigunaga manchanai jinchimi! ");
INSERT INTO qxl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jatun camello akuja ut'kuda waigunash charijkuna Diosbuj mandanamu waigunadash yalli jawallami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chida uyajkunaga tapuga, “Shinushaga ¿pidi kishpiri pudinga?” ");
INSERT INTO qxl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús niga, “Genteguna na ruri pudishkadaga Diosllami rurun.” ");
INSERT INTO qxl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Paimu Pedroga niga, “Riki, ñukuchi tuki charishkada sakishami kandaga katishkanchi.” ");
INSERT INTO qxl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesusga kaidash niga, “Kabishkadadimi nini, maijinsh Diosbuj mandana kauzamunda wasida, warmida, kusada, wauki panigunada, turi ñañagunada, taita mamada, maragunadash sakijka ");
INSERT INTO qxl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kai pachabiga ashtan yalli alligunadami japinga. Jawa pachabigarin na tukurij kausidami japinga.” ");
INSERT INTO qxl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesusga Paibuj chunga ishki yachagujkunallada kayusha kashna niga, “Kununga Jerusalén pueblomumi ichiyagunchi. Chibimi Aichayuj tukushka Churimunda Dios nishkada parlujkuna tuki imalla escribishkaga p'aktunga. ");
INSERT INTO qxl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chibimi na israelgunamu kungaguna. Chimunda paigunaga Ñukada asisha, rimusha, t'iukushtasha, ");
INSERT INTO qxl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","azilgun jinchida takushami wañuchingaguna. Shinash kinsa p'unlla k'ipaga kausarishami.” ");
INSERT INTO qxl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Shina nikiga ima nigushkadash na intindiribuj gashkamundaga ima parlashkadash na intindigagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesusga Jericó pueblomu chayaguki ñanbi limosnada mañusha tiyaj na rikujka ");
INSERT INTO qxl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","taugaguna pasajta uyasha <¿Imadi tukun?> nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Shina tapuki, “Nazaretmunda Jesusmi pasagun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chimundami na rikujka, “Rey Davidbuj familiamunda Jesús, ¡ñukada llakibairi!” nisha kapariga. ");
INSERT INTO qxl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ñaubusha rijkuna <¡Upalli!> nisha rimakish paiga ashtan kapariga, “Rey Davidbuj familiamunda churi, ¡ñukada llakibai!” nisha. ");
INSERT INTO qxl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Shina kapariki Jesús shayarisha pushamuchun kachaga. Ña kuchuyachikimi kashna tapuga, ");
INSERT INTO qxl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Imadadi kanmu rurachun ningui?” Na rikujka niga, “Manduj Jesús, rikungu munaniga.” ");
INSERT INTO qxl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús niga, “¡Rikuj gai! Kan crishkamundami alliyachishka gangui.” ");
INSERT INTO qxl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chida ninmi na rikujka alliyaga. Chimunda Diosta <Allimi gangui> nisha Jesusta katiga. Tuki chida rikujkunash Diosta <Allimi gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericomu waigusha chi pueblo chaubida riguga. ");
INSERT INTO qxl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Zaqueoga Jericobi kausaga. Paiga Romamu impuestoda cobrajkunada manduj gashaga charijmiga. ");
INSERT INTO qxl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesusta rijsingu munushash taugaguna gaki uchilla gashkamundash na riki pudigachu. ");
INSERT INTO qxl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chimunda Jesús chida rinaki rikungaj nisha ut'kada ñaubusha rishaga sicómoro yurabi sikuga. ");
INSERT INTO qxl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús ña chayagusha paida rikushaga, “Zaqueo, ut'kada uriki. Kambuj wasibimi kununga sakirina gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Shina niki Zaqueoga ut'kada uriyasha kushilladimi Jesusta wasibi japiga. ");
INSERT INTO qxl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chida rikusha, “¡Juchayujbuj wasibimi Jesusga sakiringu riga!” nisha tukiguna rimanukungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chimunda Zaqueo shayarisha Mandaj Jesusta, “Riki, Manduj. Chaubi charishkada imadash na charijkunamu kushami. Maijinda yalli cobrashkadash chusku kutin valida vueltachisha,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Shina nikimi Jesusga kashna niga, “Kununmi kai wasibi kausujkunamu kishpichina p'unlla chayamushka. Kai k'arish ñauba taita Abrahambuj familiamigun. ");
INSERT INTO qxl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aichayuj tukushka Churiga chingarishkagunada mashkusha kishpichingumi shamuga.” ");
INSERT INTO qxl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Chibi gajkuna Jesús nishkagunada uyaguki Jerusalén pueblomu kuchuyamugushkamunda Diosbuj mandana ñallami chayamunada yuyagushkamundash Paiga kai yuyachinada ningu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Valichisha alli nishka k'arimi llaktada mandangu churaki mandanada japisha kutin shamungu karu llaktamu riga. ");
INSERT INTO qxl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Paiga narij rishaidi paibuj chunga rurujkunada kayushaga, ‘K'aigachi. Kai kuchkinga randisha, k'atusha ñuka shamungagama mirachinguichi,’ nisha shuj, shujmu milgada kusha riga. ");
INSERT INTO qxl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Shina kusha rikiga chi llaktabi paida na rikunachisha kausajkunaga, ‘Paiga ñukuchida mandachunga na mununchichu,’ nisha parlachun paibuj washada shujkunada kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Shina kachakish jatun manduj ganada japishaga paibuj llaktamu vueltamuga. Chayushaga <Ñuka kushka kuchkida ¿mashnadadi mirachishka?> nisha yachungu paibuj rurujkunada kayachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ñaubusha shamujka, ‘Manduj, kan kushka kuchkidaga chunga kutinmi mirachigani,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Shina niki jatun mandujka, ‘Allida ruruj gasha, kanga allidami rurashkangui. Shina ashallanbish alli rurashkamundaga chunga pueblodami mandungui,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kutin shuj shamushaga kashna niga, ‘Manduj, kan kushka kuchkidaga pichka kutinmi mirachigani.’ ");
INSERT INTO qxl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mandujka, ‘Kanga pichka pueblodami mandangui,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kutin shuj shamushaga kashna niga, ‘Manduj, k'aiga kambuj kuchki. Ñukaga pañubimi wakichigani. ");
INSERT INTO qxl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Rurachijti gakimi kandaga manchugani. Na kushash japijllamingui. Na tarbushash tandachijllamingui,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Shina niki chi mandujka paida kashna niga, ‘Milli sirvij, kan nishka layaidi kandash nini. Rurachijti gasha na kushash japij gashkada, na tarbushash tandachij gashkada yachushkanguimi. ");
INSERT INTO qxl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chida yachushagarin ¿ima nishadij ñuka kushka kuchkidaga mirarichun nisha na bancobi churugangui? Ñuka shamushaga wawa kuchkin japinillamumiga,’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chi k'ipaga chibi tiyajkunada niga, ‘Kuchkida kichusha, chunga kuchkida charijmu kuichi.’ ");
INSERT INTO qxl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Shina niki paigunaga, ‘Manduj, ¡ñami chunga kuchkida paiga charin!’ niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jatun mandujka, ‘Kangunada nini, maijinsh charijmunga ashtanmi kushka ganga; ashtanbish na charijmundaga ashalla charishkaidash kichushkami ganga. ");
INSERT INTO qxl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kununga ñukada na rikunachisha, ama manduj gachun munajkunadaga pushamusha ñukaj ñaubuki wañuchichi,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Shina nishka k'ipa Jesusga ñaubusha Jerusalén pueblomu ichiyagushallami ");
INSERT INTO qxl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé, Betania pueblomush kuchuyasha Olivos urku chakibi gasha Jesusga Paibuj yachagujkunamunda ishkida kachuga ");
INSERT INTO qxl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kashna nisha, “Ch'imba uchilla pueblomu richi. Chimu chayushaga pish na sikushka malta burru watushka shayajta rikushaga kacharisha pushamunguichi. ");
INSERT INTO qxl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Maijinsh, ‘¿Imajti kacharigunguichi?’ nisha tapukiga, ‘Manduj Jesusmi kai malta burruda ministigun,’ ninguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kachashkaguna risha Jesús nishka layaidi burru shayajta japiga. ");
INSERT INTO qxl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ña kachariguki burruyujkunaga, “¿Imajti kacharigunguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Shina tapukiga, “Manduj Jesusmi ministigun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesusmu pushusha rishaga paigunaj churanada malta burru lumubi churusha Paida sikachigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús malta burrubi sikusha riguki shujkunaga paigunaj churanada ñanbi mandagugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos urku urida Jesús riguki taugalladi Paibuj yachagujkuna Jesús pi na ruri pudishkagunada rurajta rikushkamunda Diosta <Allimi gangui> nisha kashna kushilla kaparigaguna, ");
INSERT INTO qxl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Manduj Diosbuj shutibi kachuki shamuj Jatun Manduj Kandaga ‘¡Alli!’ nichun. Jatun k'uilla gachun jawa pachabi, shinaidi jawabi k'uilladi p'alanij shina gachun,” nisha nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Taugagunamunda shuj fariseoguna kashna niga, “Yachachij, kambuj yachagujkunada upayachun niri.” ");
INSERT INTO qxl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chimunda Jesusga, “Paiguna upayakish rumiguna kaparingami, ninimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalén kuchumu chayushaga chi puebloda rikusha ");
INSERT INTO qxl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kashna nisha wakuga, “¡Kai pueblobi kausajkunalla! K'uilla kausida kuna gashkada kunun p'unllallash yachashaga allichari ganguichimu. Shinash kununga pakashka gashkamundaga ñawi watashka shinami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Llaki p'unllaguna chayuki kangunada na rikunachijkuna, shuj pirkada churuj shinami chaubinchisha kangunaj muyundijta shayarisha tuki pushtumunda llapingaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chimundaga kangunadash kangunaj churi ushigunadashmi chingachinga. Pirka rurushka rumigunash shuj rumillash na chaishuj rumi jawabi sakiringachu. Dios kangunada kishpichingu shamukish na rijsishkamundami shina llakichishka tukunguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chi k'ipa Jesús Diosbuj wasimu chayushaga chibi k'atugujkunada kashna nisha llujshichisha kachungu kallarishaga, ");
INSERT INTO qxl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Diosbuj Shimibiga kashnami nin, ‘Ñukaj wasiga Diosta mañana wasi gangami.’ Ashtan kangunaga ‘shuwaguna tiyana ut'ku shinadami’ rurashkanguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Diosbuj wasibi Jesús tuki p'unllaguna yachachiguki manduj curaguna, Moisés mandashkada yachachijkuna, puebloda mandujkunash, ima laya wañuchinada yuyarisha purigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Shina gakish tukiguna Pai yachachishkada alli k'uilladi uyagushkamunda ima laya ruranadash na yachugagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Shuj p'unlla Diosbuj wasibi Jesús Alli Shimida chibi gajkunamu parlusha yachachiguki manduj curaguna, Moisés mandashkada yachachijkuna, yuyijkunandi chayamusha ");
INSERT INTO qxl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kashna tapugaguna, “¿Pi mandakidi kashna ruragungui? ¿Pidi kanda kashna rurachigun?” ");
INSERT INTO qxl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús niga, “Ñukash kangunada kaida tapusha. Parlichi. ");
INSERT INTO qxl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pidi Juanchudaga bautizachun kachuga? ¿Jawa pachamunda Dioschu? na gashaga ¿kaimunda gentechu?” ");
INSERT INTO qxl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Shina niki kaishuj chaishuj parlanukungu kallariga, “ ‘Diosmi kachuga,’ nikiga ‘¿Imashadij na Juanchuda criganguichi?’ ningami. ");
INSERT INTO qxl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Gentemi,’ nikiga tukiguna rumida pigusha wañuchingamami. Paigunaga Juanchu Dios nishkada parluj gashkadaga crinmi.” ");
INSERT INTO qxl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chimunda kashna nigaguna, “Pi kachushkadash na yachanchichu.” ");
INSERT INTO qxl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Shina niki Jesús kashna niga, “Pi kaida rurachun mandashkadaga Ñukash kangunamunga na parlushachu.” ");
INSERT INTO qxl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús shuj yuyachinada chibi gajkunamu parlungu kallariga, “Shuj achpayujmi uva yuragunada tarbuga. Chi k'ipa achpabi rurajkunamu partido kusha unida sakiringu karuda riga. ");
INSERT INTO qxl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ña p'ukuna p'unlla p'aktuki achpayujka shuj sirvijta paibuj partida apachun nisha kachuga. Partido charijkunaga takusha imash illujtami kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chi k'ipa kutin shuj sirvijta kachuga. Shinaidi rimusha takusha imash illujtami kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kutin shuj sirvijta kachuga. Chidash chugringama takusha achpamunda llujshichisha kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Shina ruragujllabi uva yurada tarbuj achpayujka niga, ‘¿Imadadij rurasha? Ñuka k'uyashka churida kachusha. Paidaga kazush kazunga.’ ");
INSERT INTO qxl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Partido charijkuna pai shamujta rikusha kashna parlanukuga, ‘Paimi kai achpada taitamunda japinga. Ñukuchi japingujka wañuchishunchi.’ ");
INSERT INTO qxl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chimundami uva tarbushkamunda llujshichisha wañuchigaguna.” Jesús tapuga, “Achpayujka ¿imadadij rurunga? ");
INSERT INTO qxl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Partido charijkunada wañuchichingami. Chi achpadaga shujkunamumi kunga.” Kaida uyajkunaga mancharisha niga, “¡Ñukuchi chashna tukuchunga Dios ama munachun!” ");
INSERT INTO qxl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús paigunada rikuriasha niga, “Shinaga ¿imada nishadi nigun Diosbuj Shimibi kashna nishkaga? ‘Wasichijkuna na munusha shitushka rumimi, ashtan kallarimu churana rumimi tukushka.’ ");
INSERT INTO qxl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Maijin chi rumi jawabi urmujka p'akiringami. Maijinbuj jawabi rumi urmushash ñutushtangami.” ");
INSERT INTO qxl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Manduj curaguna, Moisés mandashkada yachachijkunash kai yuyachinada parlushaga paigunada rimagushkada yachunmi Jesusta prezungu munashash shujkunada manchashkamunda na japigagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Llaktada mandujmu japichingu nishami pakalla alli rikurisha purij na alligunada Jesusta pandachingu nisha kashna tapuchun kachugaguna, ");
INSERT INTO qxl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","“Yachachij, kan nishkash yachachishkash kabishkami gan. Kanga ñawida rikushallaga na yachachinguichu, ashtangarin Diosbuj ñanda kanllami kabishkada yachachingui. ");
INSERT INTO qxl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ñukuchida nibai, ¿Roma llaktada jatun mandujmu impuestodaga paganachu ganchi?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesusga paiguna na alli yuyin tapugushkada yachasha kashna niga, ");
INSERT INTO qxl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Shuj Romamunda kuchkida rikuchichi. Kai ñawish shutish ¿pibujtikun?” Paigunaga niga, “Kai llaktada mandujbujmi.” ");
INSERT INTO qxl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús niga, “Chimunda jatun mandujbujtaga paillamundi kuichi. Diosbujtaga Diosllamundi kuichi.” ");
INSERT INTO qxl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Shujkunaj ñaubuki parlaki Jesusta na pandachishkamunda japingu yuyushash na pudigagunachu, ashtangarin tapushkada alli nishkamunda mancharisha upalla sakirigallagunami. ");
INSERT INTO qxl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chi k'ipa wañushka kausarinada na crij saduceogunamunda shujkuna Jesusta tapungu kuchuyasha nishaga, ");
INSERT INTO qxl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Yachachij, Moisés escribishkabiga kashnami nin: Shuj k'ari warmin na mara charishalla wañukiga wañushkamu maragunada kungaj waukiga viudanmi kazarana gan. ");
INSERT INTO qxl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Shuj kutinmi kanchis waukiguna kausuga. Ñauba wauki kazarashaga narij maragunada charishaidimi wañuga. ");
INSERT INTO qxl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Paibuj k'ipa wauki chi warmillandi kazaraga. Paish na mara charishaidij wañuga. ");
INSERT INTO qxl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Katij waukish kazaraga. Kanchis waukigunagama kazarashash na marada charishalla wañugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chi k'ipaga warmish wañuga. ");
INSERT INTO qxl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kanchis waukindijkunan kazarashkamundaga wañushkaguna kausarina p'unllaga ¿maijinbuj warmishi ganga?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús niga “Kai pachabi shujkunaga kazaran, shujkunaga kazarachin. ");
INSERT INTO qxl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ashtanbish k'ipa kausida japingukish wañushkamunda kausachishka gangu <Alli> nishkagunaga na kazaranga, kazarachishkash na ganga. ");
INSERT INTO qxl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Angelguna laya gasha na wañunga shinaidi kausarishkamunda Diosbuj wawagunami gan. ");
INSERT INTO qxl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Uchilla zarza yura rupagushkamunda Moisés escribishkabi Mandujka ‘ñauba Abrahambuj, Isaacbuj, Jacob-buj Dios’ gashkada nishkami. Kashna nishaga wañushkaguna kausarina gashkadami niga. ");
INSERT INTO qxl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Diosga na wañushkagunajchu, ashtan kausujkunaj Diosmi. Paibuj ñaubukiga tukigunami kausujkuna gan.” ");
INSERT INTO qxl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moisés mandashkada yachachijkunamunda shujkuna niga, “Yachachij, allimi nishkangui.” ");
INSERT INTO qxl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chimunda mancharisha imadash ashtanga pish na tapugagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús tapuga, “¿Imashadi ‘Dios agllusha kachashka Cristoga jatun manduj Davidbuj wawagunaj wawami gan’ ninguichi? ");
INSERT INTO qxl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Davidlladimi Salmos librobi kashna nin: ‘Manduj Diosga ñukada Mandajta niga “Kanda na rikunachijkunada ñuka kambuj chaki sarunabi churungama ñukaj alli ladubi tiyari.” ’ ");
INSERT INTO qxl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jatun manduj Davidlladi Dios agllusha kachashka Cristoda ‘Ñukada mandaj’ nigukidijka ¿ima layadij Davidbuj churi ganga?” ");
INSERT INTO qxl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tukiguna uyagukimi Jesús Paibuj yachagujkunada niga, ");
INSERT INTO qxl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moisés mandashkada yachachijkunamunda yuyin puringuichi. Paigunaga k'uilla sundij churanada churujkunami, lasagunabish saludachun paigunada kazuchun munujkunami gan. Diosmunda yachana wasi ukubi ñaubukimi tiyarijkuna, mikungu rishash alli pushtugunabimi tiyaringu munujkuna gan. ");
INSERT INTO qxl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Viudaj wasigunadash kichusha na alli rurushash Diosta unida mañaj tukujllagunami. Shina rurujkunaga shujkunada yalli llakichishkami ganga.” ");
INSERT INTO qxl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Diosbuj wasibi ofrenda churanabi charijkuna kuchkida churajtami Jesusga rikuguga. ");
INSERT INTO qxl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Imadash na charij viudash ishki ashalla valij kuchkida churajta rikusha ");
INSERT INTO qxl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","kashna niga, “Kabishkadadimi nini, imadash na charij viudaga tuki chaishujkunadash yallimi kuga. ");
INSERT INTO qxl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chaishuj charijkunaga puchushkagunadami churugaguna. Chi viudaga imada na charishash pai imajllash charishkada tukidami kuga.” ");
INSERT INTO qxl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Diosbuj wasi k'uilla rikunaidi rumigunan Diosmu kumbidasha churashkagunanbish k'uilladi rurashkada rikusha wakingunaga parlanukuga. Shina parlanukukimi Jesusga kashna niga, ");
INSERT INTO qxl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“P'unllaguna p'aktukiga kanguna kunun rikugushkaga tukidami tukuchishka ganga. Shuj rumillash na chaishuj rumi jawabi sakiringachu.” ");
INSERT INTO qxl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kashna nikimi yachagujkunaga, “Yachachij ¿ima p'unlladi kashnaga tukungari? Ña chashna tukungujka ¿imagunadi rikuringari?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Shina niki Jesusga niga, “Taugagunami Ñukaj shutibi shamusha, ‘Ñukami kishpichij Cristo gani.’ ‘Kununmi tukurina p'unlla chayamun,’ nikish ama katinguichichu. Yuyin ganguichi. P'akta paiguna llagmushkada cringuichimu. ");
INSERT INTO qxl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Llaktagunapura takanukiguna mandajkunada bulla rurashka wañunukigunash uyarikiga ama mancharinguichichu. Chi llakigunaga tiyungaidimi. Shinash tukurina p'unllaga narij chayamungachu.” ");
INSERT INTO qxl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kaidash nigami, “Shuj llaktaga kaishuj llaktan takanukungami. Llaktada mandujkunapurash p'iñanukusha jataringami. ");
INSERT INTO qxl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jatun achpa ch'ujchiguna tiyangami. Yarijish unguigunash kaibi chaibimi tiyanga. Jawa pachabish pish na rikuchishkagunash manchanai jatun mancharinagunash rikuringami. ");
INSERT INTO qxl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Narij shina tukujllabidij prezungu munusha kangunada katik'ichungami. Diosmunda yachana wasigunamush carcelgunamush pushungagunami. Ñuka shutimundash jatun mandujkunajmu llaktada mandujkunajmush pushungami. ");
INSERT INTO qxl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Paigunaj ñaubujmu pushukish kangunaga ashtan Ñukamunda parli pudinguichimi. ");
INSERT INTO qxl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kangunada pushukiga ñaubushadi <¿Imadadi ñukada ama llakichichunga nishari?> yuyashaga ama chi yuyin ganguichichu. ");
INSERT INTO qxl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ñukaidimi kangunamunga alli rimarina yuyida kusha. Chimunda kangunada p'iñujkunaga na ch'imbapuri pudingukish <Kan parlashkaga na allichu> ningujllash na pudingagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kangunaj taita mamagunaidi, wauki panigunaidi, ñaña turigunaidi, familiagunaidi, alli rijsishkagunaidimi upalla llullasha japichinga. Kangunapuramundash shujkunada wañuchingami. ");
INSERT INTO qxl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tukigunami Ñukamunda kangunadaga na rikunachinga. ");
INSERT INTO qxl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Shina rurukish kangunaj uma juakchallash na chingaringachu. ");
INSERT INTO qxl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Shina llakichigukish Ñukada na sakishalla jinchi shayarishaga kishpiringuichimi. ");
INSERT INTO qxl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Tauga soldadoguna Jerusalén puebloda muyundijta shayajta rikushaga ñalla tukuchishtashka ganada yachichi. ");
INSERT INTO qxl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Shina tukukiga Judea llaktabi gajkunaga urkugunabi mitikungu ringuichi. Jerusalenbi gajkunash llujshisha ringuichi. Chagrabi gajkunash ama kutin pueblomu ringuichi. ");
INSERT INTO qxl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi p'unllagunabiga manchanaidimi llakichinga. Dios parlusha escribichishka Shimigunaga tukimi p'aktunga. ");
INSERT INTO qxl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chi jatun llakigunabiga iksa charij warmigunash chuchuchigujkunash ¿imachari tukunga? Kai pachabiga llakinaidijminga. Kaibi kausujkunadaga Dios p'iñarisha manchanaidimi llakichinga. ");
INSERT INTO qxl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Shujkunadaga espadanmi wañuchinga. Chaishujkunadash prezu japisha tuki llaktagunamumi pushunga. Jerusalendaga saruj laya llakichichun Dios sakishka p'unllaguna p'aktungagama na israelgunami mandunga.” ");
INSERT INTO qxl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Chi k'ipaga indibi, lunabi, luzerogunabish, nash rikushkagunami rikuringa. Jatun yaku kuchaguna manchanaidi kaimu chaimu jatarisha juass mandaki kai pachabi kausujkuna musparishka shinami tukusha mancharingaguna. ");
INSERT INTO qxl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kaibi kausujkunaga jawa cielobi imalla tiyashkash kuyuchishkamundami kai pacha ima tukunada ashtan mancharisha yuyida chingachisha musparingaguna. ");
INSERT INTO qxl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kashna tukukiga Aichayuj tukushka Churi tukida ruri pudishkan k'uilla p'alaniguj gashkan p'uyubi shamujtami rikungaguna. ");
INSERT INTO qxl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kai tuki llakiguna kallarimukiga kangunada kishpichina p'unlla p'aktagushkada yachunguichimi. Chimunda kanguna ñaubujmu risha kushilla chapagunguichilla.” ");
INSERT INTO qxl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yuyachingu nisha Jesusga kaidash niga, “Jigus yuragunada, shuj yuragunadash rikichi. ");
INSERT INTO qxl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chi yuragunabi p'anga jundujta rikusha, tamia paskarina p'unlla chayamugujta kangunalladi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Shinalladi kai llakigunadash rikusha Diosbuj mandana p'unlla chayamunada yachichi. ");
INSERT INTO qxl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Kabishkadadimi nini, kausajkuna narij wañullabidimi tuki shina tukunadi p'aktashka ganga. ");
INSERT INTO qxl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jawa pachash kai pachash tukuringami, ashtanbish Ñuka nishka shimigunaga nalladi tukuringachu. ");
INSERT INTO qxl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kangunalladi alli yuyarichi. P'akta machanallabi, mikunallabi, kai pachabi imadash charinallabi kangunaj shunguda churasha kausagunguichimu. Shina kausuguki p'akta kanguna na yuyashka uras chai p'unllaga chayamunmu. ");
INSERT INTO qxl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Shuj trampa shina kai pachabi kausujkunadaga tukigunadami kai llakigunaga japinga. ");
INSERT INTO qxl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Shinusha rinalla shuyanguichi. Kai shamuna llakigunamunda llujshi pudingajka Aichayuj tukushka Churij ñaubuki alli rikuri pudingajka Diosta mañunguichi,” nigami. ");
INSERT INTO qxl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","P'unllaga Diosbuj wasibi Jesusga yachachiga. Tutaga Olivos shuti urkubimi pakarij gaga. ");
INSERT INTO qxl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pai yachachishkada uyungajmi tukiguna tutamundadi Diosbuj wasimu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Levadura illuj tandada mikuna Pascua pishta p'unlla chayamuguga. ");
INSERT INTO qxl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Manduj curaguna, Moisés mandushkada yachachijkunash, shujkunada manchushkamunda Jesusta ima laya wañuchinada pakalla parlanukuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kashna yuyagukiga Jesusbuj chunga ishki yachagujkunamunda Judasbi Satanás waiguga. Judasga Iscariote nishkashmi gaga. ");
INSERT INTO qxl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paimi manduj curagunajmu Diosbuj wasida chapujkunajmush risha Jesusta ima laya japichinada paigunamu parlaga. ");
INSERT INTO qxl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chida uyashaga paiguna kushiyasha, Judasmu kuchkida kunadash ari ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kashna niki Judasbish ari nisha, Jesusta pish illashka alli ura japichinada yuyariguga. ");
INSERT INTO qxl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Levadura illuj tandada mikuna p'unlla chayamukiga Pascua nishka malta ovejada Diosmu kusha wañuchijkunami gaga. ");
INSERT INTO qxl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús Pedroda Juanchudash kashna nisha kachuga, “Ñukuchi Pascua mikunada mikuchun parijangu richi.” ");
INSERT INTO qxl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Paiguna tapuga, “¿Maibidi parijachun ningui?” ");
INSERT INTO qxl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús niga, “Rikichi, kanguna chi pueblomu waiguki shuj k'ari yaku p'unduda aparishka rigujkun tupasha pai wasimu waigungama katisha ringuichi. ");
INSERT INTO qxl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chimu waigushaga wasiyujta, ‘Ñukuchida yachachijka ¿maijin ukubidij ñukaj yachagujkunanga Pascua mikunada mikushun? ninmi,’ ninguichi. ");
INSERT INTO qxl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kashna niki wasiyujka parijashka shuj jatun ukudami jawa altubi rikuchinga. Chibi mikunada parijichilla.” ");
INSERT INTO qxl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Paiguna risha Jesús nishka layaidadimi rikuga. Chibimi Pascua mikunada parijaga. ");
INSERT INTO qxl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mikuna uras chayukiga Jesús Pai agllashkagunandi mizamu tiyarisha, ");
INSERT INTO qxl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Paiga niga, “¡Narij llakida apashaidimi kangunan Pascua p'unllabi mikungu mejor munugani! ");
INSERT INTO qxl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kangunamu ninimi, Diosbuj mandana p'unlla p'aktangagama kaida kutinga na mikushachu.” ");
INSERT INTO qxl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chi k'ipa vino vazuda japisha Diosta <Diosolopai> nisha Jesusga, “K'aigachi. Tukiguna ubiyichi. ");
INSERT INTO qxl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kaidash kangunamu ninimi, Diosbuj mandana shamungama uvan rurushka vinoda kutinga na ubiashachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tandadash japisha Diosta <Diosolopai> nishka k'ipaga paigunamu chaubisha karaga, “Kaimigun Ñukaj cuerpo, kangunamunda kushka. Ñukada yuyarisha kaidaga rurichilla.” ");
INSERT INTO qxl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mikushka k'ipa vinodash shinaidi japisha kashna niga, “Kai vinoga mushuj ari ninukushkada p'aktachingujmi gan. Kangunamundami Ñukaj yaur jichushka ganga. ");
INSERT INTO qxl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kaidash ninimi, Ñukada japichish nijka kai mizabimi tiyan. ");
INSERT INTO qxl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aichayuj tukushka Churidaga ima shina tukuchun Dios munashka shinalladimi rurangaguna, ashtangarin Paida japichijka ¿imachari tukunga?” ");
INSERT INTO qxl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Shina niki chaishuj kaishuj <¿Maijinshi shinadijka rurunga?> nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yachagujkunapuramunda <¿Maijinshi yalli alli ganchi?> nisha rimanukuki, ");
INSERT INTO qxl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús niga, “Diosta na rijsijkunapuramunda jatun mandujkunaga paiguna munashkada shina rurachijkunami. Paigunaj mandujkunaga <Kangunaga allidami ruranguichi> nishka gangumi munujkuna gan. ");
INSERT INTO qxl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Shinakish kangunaga na shina gachun, ashtangarin kangunapurabi maijin <Yalli valij gasha> nijka na valij shinami gachun. Mandujka sirvij layashmi gachun. ");
INSERT INTO qxl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Maijindi yalli valij gan, mizabi tiyarish mikuj na gashaga sirvij? ¿Nachu mizabi tiyarij gan? Ashtangarin Ñukaga kangunada sirvij layami gani. ");
INSERT INTO qxl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Llaki japikish kangunaga Ñukanmi gashkanguichi. ");
INSERT INTO qxl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chimundami Ñukaj Taita mandanada Ñukamu kushka layaidi kangunamush kuni. ");
INSERT INTO qxl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ñuka mandanabiga kangunaga Ñukan mizabi mikunguichimi, ubianguichimi. Israelbuj chunga ishki (12) tribugunada alli gashka na alli gashkada tapusha mandangaj manduj tiyanabi Ñukan tiyaringuichimi.” ");
INSERT INTO qxl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mandaj Jesús kashna niga, “Simón, trigoda shushuj shinami alli gaj na alli gajta rikungu kangunadaga Satanasga mañashka. ");
INSERT INTO qxl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kan crishkada amalladi kungarichun nisha Ñukaga Diosta mañushkanimi. Kan Ñukamu kutin shamushaga kaishuj crijkuna alli katichun ayudangui.” ");
INSERT INTO qxl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón niga, “Mandaj, Kanda carcelmu apakish rinalla, wañukish Kangun wañushallami.” ");
INSERT INTO qxl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Shina niki Jesús kashna niga, “Pedro, kanda nini, kunundimi narij gallo cantujllabidi Ñukadaga kinsa kutin <Na rijsinichu> ningui.” ");
INSERT INTO qxl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chi k'ipa Jesusga, “Ñuka kangunada kuchki aparina illuj, shigra illuj, pargatish illujta kachukiga ¿imallash jualtagachu?” nisha tapuga. Paigunaga, “Imash na jualtagachu,” nisha niki ");
INSERT INTO qxl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesusga, “Ashtan kununga maijinsh kuchki aparinada shigradash charishaga apichilla. Maijinsh espadada na charijka jawa churushkada k'atusha randichilla. ");
INSERT INTO qxl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kangunamumi parlani, Dios ñaubamu Ñuka ima tukunada escribichishaga, ‘Milliguna shinami llakichishka ganga,’ nishkaga p'aktanadimi gan. Shinalladi Ñukamunda Dios tuki escribichishkaga p'aktangami,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Paibuj yachagujkunaga, “Mandaj Jesús, ishki espadadami charinchi,” nisha niki, Jesusga, “Chidaga upallichi,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chi k'ipa pueblomunda llujshishaga Jesús Olivos urkumu rigujllashkamunda chimu riki Paibuj yachagujkunash katiga. ");
INSERT INTO qxl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ña chayushaga, “Ima milli yuyiguna ama urmachichunga Diosta mañichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Paigunaj kuchumunda rumida jinchida piguki urmana vali karumu risha kungurisha Taita Diosta mañuga, ");
INSERT INTO qxl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taita, Kan munushaga kai jayuj ubiana shina jatun llakida anchuchibai. Shinash ama Ñuka nishkaida ashtangarin Kan munashkada rurabai.” ");
INSERT INTO qxl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Shinaki shuj ángel jawa pachamunda Jesusta jinchiyachingu shamuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Llakin gashash Jesusga ashtan yalli Diosta tuki shungun mañuga. Jumbiga yaur laya pambamu shutuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Diosta mañushka k'ipa jatarisha shamushaga Paibuj yachagujkuna manchanai llakin shaikushkamunda puñujta japiga. ");
INSERT INTO qxl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Shina japisha niga, “¿Imasha puñugunguichi? Ima milli yuyiguna ama pandachichunga jatarisha Diosta mañichi.” ");
INSERT INTO qxl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús shina parlajllabidi taugaguna chayamuga. Chunga ishki (12) yachagujkunamunda Judas ñaubusha shamushami Jesusta muchungu kuchuyaga. ");
INSERT INTO qxl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Shina ruruki Jesusga, “Judas ¿Aichayuj tukushka Churidaga muchushallachu japichingui?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesuskun gajkuna kaida rikushaga, “Mandaj Jesús ¿espadan takashunchu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Shinaga Jesuskun gajkunamunda shujka jatun manduj curaj sirvij alli ladu rinrinda p'itiga. ");
INSERT INTO qxl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jinchida Jesusga, “Sakichi,” nishka k'ipaga rinrinda tupusha alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chimunda Jesús Paida japingu shamuj manduj curagunamu, Diosbuj wasida chapajkunamu, yuyijkunamush kashna niga, “¿Imashadi kangunaga espadagunan kaspigunanbish shuwada laya Ñukada japingu shamunguichi? ");
INSERT INTO qxl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cada p'unlla kangunan Diosbuj wasibi gakish na Ñukada japiganguichindi. Kununmi kanguna Ñukada japina uras chayamushka. Ansabi mandaj aya kangunamu yuyida kukimi shamushkanguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta japishaga jatun manduj curaj wasimu pushusha riga. Pedroga karullada washa washa katiga. ");
INSERT INTO qxl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chaubi pambabi ninada katichisha muyundijta tiyarigaguna. Pedrosh paigunan tiyariga. ");
INSERT INTO qxl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chibi shuj iñachishka warmi nina kuchubi tiyajta rikuriasha, “Paish paigunmiga,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Shina niki chi warmida Pedroga, “Ñukaga nalladi rijsiniga,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Asha k'ipa shuj rikushash kutin kashna niga, “Kambish Jesusta katisha purijmingui.” Shina niki k'arida Pedroga, “Na shinachuni,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Shuj ura k'ipa shujbish nigami, “Kaish paigun purijlladimigun. Paish Galileallamundadimi.” ");
INSERT INTO qxl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro niga, “Uyi. Na intindinichu. ¿Imada parlunguichari?” Pedro parlagujllabidimi galloga cantuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chimunda Mandaj Jesús vueltarisha Pedroda rikuga. Pedroga Mandaj ima laya nishkada yuyariga, “Kunun gallo narij cantujllabidimi kinsa kutin <Na rijsinichu> ningui.” ");
INSERT INTO qxl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro chimunda llujshisha manchanai llakirisha wakuga. ");
INSERT INTO qxl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesusta chapajkunaga Paida takusha asigugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawidash watushaga, “Dios nishkada parlujti gashaga ¿pidi takun? parliri,” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Shinaidi rimush katisha imadadikish nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ña p'unllayaki israelgunamunda yuyijkuna, manduj curaguna, Moisés mandashkada yachachijkunash tandanukuga. Chi tandanukushkamu Jesusta pushuki, ");
INSERT INTO qxl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","chibi kashna tapugaguna, “Parli, ¿kanchu Dios agllasha kachashka Cristo gangui?” Pai niga, “Ñuka <ari> nikiga na cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kangunada tapukiga na parlunguichichu. ");
INSERT INTO qxl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Shinushami kununmundadi Aichayuj tukushka Churiga Tukida Ruri Pudij Diosbuj alli ladubi tiyanga.” ");
INSERT INTO qxl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chimunda tukiguna tapuga, “¿Shinaga Diosbuj churichungui?” Jesús niga, “Kangunaidimi Ñuka pi gashkadash ninguichi.” ");
INSERT INTO qxl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Shina niki paiguna niga, “Pailladi na alli nishkada uyunchimi. Chimunda paida juchachichunga shujkunadaga ña na tapunachunchi.” ");
INSERT INTO qxl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tuki israelgunada mandajkunandi jatarisha Jesusta Pilatojmu pushugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kashna nisha juchachingu kallarigaguna, “Paidaga ñukuchij llaktabi kausujkuna p'iñanukuchun yachachisha purijtami japimunchi. Paiga <Dios agllusha kachushka Cristosh jatun mandujkish gani> nisha Roma llaktada jatun mandujmu impuestoda ama pagachun ninmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato tapuga, “¿Kanchu israelgunada jatun Manduj gangui?” “Kanlladi ninguiga,” nisha Jesús niga. ");
INSERT INTO qxl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chimunda Pilatoga manduj curagunadash taugagunadash niga, “Paibiga ima na alli rurushkadaga na japinichu.” ");
INSERT INTO qxl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Paiguna ashtan juchachisha katigugaguna, “Galilea llaktamunda kallarisha kai Judea llaktabi kausujkunagama yachachisha bullada rurashami purin,” nisha. ");
INSERT INTO qxl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato kaida uyusha tapuga, “Paiga ¿Galilea llaktamundachu?” ");
INSERT INTO qxl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","<Ari> niki Galileada manduj Herodesbujmu kachuga. Chi p'unllagunaga Herodesga Jerusalén pueblollabidimiga. ");
INSERT INTO qxl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes Jesusta rikusha pachun kushiyaga. Paiga sarunmundadijmi Jesusmunda tauga nishkaida uyuga. Chimunda pi na ruri pudishkada Jesús rurajta rikush niga. ");
INSERT INTO qxl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes tauga tapunada tapukish Jesusga imadash na nigachu. ");
INSERT INTO qxl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Manduj curaguna, Moisés mandushkada yachachijkunash chibimiga. Paigunaga kaida chaida nisha ashtan juchachiga. ");
INSERT INTO qxl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes paibuj soldadogunan Jesusta na valichisha asingaj nisha jatun mandujkunada laya k'uilla churanada churachiga. Shina rurushka k'ipa Pilatojmu kachuga. ");
INSERT INTO qxl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ñaubamundadimi Herodesga Pilaton p'iñanukushka gaga. Chi p'unllalladimi alli tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatoga manduj curagunada, israelgunada mandujkunada, chi llaktabi kausujkunadash tandachisha, ");
INSERT INTO qxl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kashna niga, “Kangunaga ‘Paiga bullada rurusha purin’ nisha pushamushkanguichi, ashtanbish kangunaj ñaubujllabidi tapushash paidaga kanguna juchachishka laya ima na alli rurushkagunada na japinichu. ");
INSERT INTO qxl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesbish ima juchachinadash na japishaga kaillamundimi kachushka. Kangunaidi rikushkanguichi. Paida wañuchingukish ima na alli rurushkadaga na japishkanichu. ");
INSERT INTO qxl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chimunda paidaga llakichishka k'ipaga kacharisha kachushallami,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatoga Pascua pishta p'unlla chayamukiga prezu tiyajkunamunda maijindash shujta kacharina gaga. ");
INSERT INTO qxl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tukiguna shuj shinalla kaparingu kallariga, “¡Kai Jesusta wañuchi! ¡Barrabasta kachari!” ");
INSERT INTO qxl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabasga chi pueblobi kausajkunada tandachisha bulla rurashkamundash shujta wañuchishkamundashmi carcelbi tiyaga. ");
INSERT INTO qxl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesusta kacharingu nisha Pilatoga kutin paigunada tapuga. ");
INSERT INTO qxl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Paiguna ashtan jinchida kapariga, “¡Cruzbi wañuchi! ¡Cruzbi wañuchi!” nisha. ");
INSERT INTO qxl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kaiyunga kinsa kutin Pilato tapuga, “¿Imadadi na allida rurushka? Ñukaga wañuchingukish pai ima millida rurushkadaga na rikunichu. Takusha kachushallami.” ");
INSERT INTO qxl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tukiguna <¡Cruzbi wañuchichun!> nisha kuchun mandasha kutin kutin kaparigushkanmi vincigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatoga shina kaparigujllabi <ari> nisha sakiriga. ");
INSERT INTO qxl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chi pueblobi bulla rurashkamundash shujta wañuchishkamundash prezu tiyajta kacharisha kachuga. Jesustaga israelguna imadash rurachun nisha kuchun mandaga. ");
INSERT INTO qxl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Romamunda soldadoguna Jesusta cruzbi wañuchingu pushusha rigukiga chagramunda shamuj Cirene pueblomunda Simonmu cruzta apachisha Jesusbuj washada katichisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Taugalladijkunami katisha chi pueblomunda riguga. Shinaidi warmigunashmi Jesusta llakisha kaparisha wakusha katigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Paigunamu vueltarisha Jesús niga, “Jerusalén pueblomunda warmiguna, ama Ñukamunda wakichichu, ashtan kangunaj maragunamunda kangunallamundadij wakichi. ");
INSERT INTO qxl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‘Na miruj, na iksa charij, na chuchuchij warmigunajka allimi ganga,’ nisha parlana p'unllagunaga chayamungami. ");
INSERT INTO qxl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chi p'unllaga kashna ningumi kallaringaguna, ‘¡Urkuguna, ñukuchij jawabi urmabaichi! ¡Lomagunash, pakabaichi!’ ");
INSERT INTO qxl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ñuka iñajlla yura layan kashna rurashdijka kanguna chakishka yura layagunadadijka ¿imadachari rurungaguna?” ");
INSERT INTO qxl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Millida rurushkamunda juchachishka ishkigunadash chakatangu Jesuskun igulda pushush riga. ");
INSERT INTO qxl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Uma Tullu shuti pushtumu chayushaga Jesusta chakataga. Ishki milli rurujkunadash, shujtaga Jesusbuj lluki ladumu, kaishujtaga alli ladumu chakataga. ");
INSERT INTO qxl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesusga, “Ñuka Taitalla, perdonabai, paiguna ima rurashkadash na yachunchu,” niga. Soldadogunaga Jesusbuj churanagunada japinukungajka sorteoda rurushami japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chibi gajkunaga ima tukushkada rikuguga. Mandujkunash Paida asishaga, “Dios agllusha kachushka Cristo gashaga shujkunada kishpichishka layaidi Pailladikish kishpirichun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadogunash Jesusta asiga. Paibuj kuchumu risha jayuj vinoda ubiachun kushaga, ");
INSERT INTO qxl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Kan israelgunada manduj gashaga ¡Kanlladi kishpiriri!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesusbuj jawabiga kashna nisha escribishka letrero tiyaga, “KAIMI ISRAELGUNADA MANDUJ GAN.” ");
INSERT INTO qxl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cruzbi lavushka shuj millida rurujka kashna rimuga, “Kanga Cristo gashaga ¡Kanlladi kishpiri! ¡Ñukuchidash kishpichi!” ");
INSERT INTO qxl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chaishujka chi rimujta kashna rimuga, “¿Diosta nachu manchungui? Kambish pai layaidi kai llakida apagunguindi. ");
INSERT INTO qxl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ñukuchiga na allilladijka kai llakida na apagunchichu. Millida rurushkamundami shina llakichigun. Paiga imadash milligunadaga na rurushkachu.” ");
INSERT INTO qxl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kaidash nisha katiga, “Jesús, Kambuj mandanabi shamushaga ñukada yuyaribangui.” ");
INSERT INTO qxl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús niga, “Kununlladimi Ñukan jawa k'uilla llaktabi gangui. Kabishkadadimi nini.” ");
INSERT INTO qxl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chaubi p'unllamunda tardi kinsa urasgama, tuki kai pachaga tutayagami. ");
INSERT INTO qxl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Indish ansayaga. Diosbuj wasi ukubi tiyaj velo nishka linsosh chaubibi llikiriga. ");
INSERT INTO qxl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chimunda Jesús jinchi kapariga, “¡Ñuka Taitalla, Kambuj makibimi Ñukaj espirituda mingani!” Shina nishka k'ipaga wañugallami. ");
INSERT INTO qxl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldadogunada mandujka tuki imalla tukushkada rikusha Diosta <Allimi gangui> nisha kashna niga, “¡Paiga kabishkadimi allida ruruj gashka!” ");
INSERT INTO qxl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tuki chibi gajkuna chida rikusha mancharisha shungubi juaktasha llakirisha rigallami. ");
INSERT INTO qxl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tuki Jesusta rijsijkunaga Galilea llaktamunda katisha rij warmigunash ima tukushkada karumunda rikusha shayaga. ");
INSERT INTO qxl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Shuj alli gasha imadash alli p'aktachisha kausaj Jozi shuti tiyaga. Paish israelgunada mandujkuna tandanukushkapuramundamiga. ");
INSERT INTO qxl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Chimunda gashash paiguna na allida rurashkada na munugachu. Judea llaktabi tiyaj Arimatea pueblomunda Joziga Diosbuj mandana chayamunadami chapaga. ");
INSERT INTO qxl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Paimi manduj Pilatojmu risha Jesusbuj cuerpoda pambungaj mañuga. ");
INSERT INTO qxl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cruzmunda uriyachishka k'ipaga lino linsubi pilluchisha pidash narij pambushka k'akabi rurashka ut'kubi pambusha churuga. ");
INSERT INTO qxl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Samana p'unlla ña chayamugukiga tukida alli parijana p'unllamiga. ");
INSERT INTO qxl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea llaktamunda pacha Jesuskun shamuj warmiguna wañushkada apusha ut'kubi ima laya churajta katish risha rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wasimu vueltamushaga k'uilla ashnariguj yuragunada aceitedash rurugaguna. Samana p'unlla chayamukiga Moisés mandashkabi shinaidimi samugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kayundij domingo puzu puzudi chi warmiguna k'uilla ashnariguj yuragunada rurushkagunan pambushka ut'kumu apusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chimu chayushaga ut'kuda tapashka rumi na chi pushtubi tiyajta rikugagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chi ut'kumu waigushash wañushka Mandaj Jesusta na japigagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mancharisha imadash na ruri pudisha shayaki ñash ishkiguna k'uilla p'alaniguj churanada churushka paigunaj kuchubi shayariga. ");
INSERT INTO qxl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Warmigunaga ashtan mancharisha uma achpamu tuparingama kumuriga. Chi ishkigunaga niga, “¿Imashadi kausagujtaga wañushkada pambushka ut'kubi mashkagunguichi? ");
INSERT INTO qxl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Paiga na kaibichu. Ña kausarigami. Pai Galilea llaktabi chairijti kangunan gasha kashna nishkada yuyarichi, ");
INSERT INTO qxl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Aichayuj tukushka Churida juchayujkuna japisha cruzbi wañuchingami. Shinash kinsa p'unllabiga kausaringallami.’ ” ");
INSERT INTO qxl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Shina nijta uyusha warmiguna Jesús ima nishkada yuyariga. ");
INSERT INTO qxl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pambushka ut'kumunda kutin shamushaga chunga shuj agllushkagunamu chaishujkunamush ima tukushkada parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jesús agllushkagunamu parlungu rij warmigunaga Magdalamunda María, Juana, Jacoboj mamun María, shujkunashmiga. ");
INSERT INTO qxl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Shina parlukish agllashkagunaga <Nij tukushalla allilladimi shina nin> nishkada yuyasha na crish nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ashtanbish Pedro jatarinmi ut'kalladi riga. Pambushka ut'kumu chayusha pillushka linsulladami rikuga. Chida rikusha mancharishaga <¿Imashi tukuga?> yuyasha wasimu vueltuga. ");
INSERT INTO qxl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Domingo p'unllaidimi ishki yachagujkuna Emaús pueblomu riga. Chi puebloga Jerusalén pueblomunda chunga shuj kilómetro karumiga. ");
INSERT INTO qxl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tuki ima tukushkada parlanukusha rigugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Shina rimarisha ninukusha rigukimi Jesuslladij kuchuyasha paigunan riga. ");
INSERT INTO qxl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Paida rikushash imashachari pi gashkada na rijsigagunachu. ");
INSERT INTO qxl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Shina rigushami Jesús paigunada tapuga, “¿Imada kangunapura parlanukusha rigunguichi?” nisha. Shina tapuki, llakilladi shayarigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ishkindijmunda Cleofas shutiga kashna niga, “¿Kanllachu Jerusalén pueblollabidi tiyashash kai p'unllaguna chibi ima tukushkada na yachushkangui?” ");
INSERT INTO qxl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“¿Imadi tukushka?” nisha Jesús tapuki, paiguna niga, “Nazaretmunda Jesusga Diosbuj ñaubuki tukigunaj ñaubukish Diosbuj Shimida parlaj tukidash ruri pudijmiga. ");
INSERT INTO qxl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Shina gakish paidami manduj curaguna, ñukuchida mandujkunash ‘Wañunami gan’ nisha chakatasha wañuchichun kachagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ñukuchiga <Paimi Israel llaktada romanogunaj mandanamunda kacharichinga> nisha chapaganchi. Shina yuyajllabidi pai wañushkash ñami kinsa p'unlla gan.” ");
INSERT INTO qxl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Shina gakish ñukuchipura shuj warmiguna puzu puzuidi pambushka ut'kumu risha na japishaga ñukuchijmu vueltamugaguna. Shina shamushaga <Angelguna rikurisha <Jesusga kausagunmi> nishami parlugaguna.> Shina parlushami ñukuchidaga manchachigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Shina parluki ñukuchipuramunda shujkuna pambushka pushtubi rikungu risha, warmiguna nishka shinaidimi japigaguna. Shinash paidaga chibiga na rikugagunachu.” ");
INSERT INTO qxl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Shina nikimi Jesús niga, “Kangunaga ashalla intindijkuna, Dios nishkada parlujkunadash cringujka jinchigunami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristoga ¿alli nisha jatunyachishka gangajka nachu llakidadi apana gaga?” niga. ");
INSERT INTO qxl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chimunda Diosbuj Shimibi Jesusga Paimundalladi tuki parlushkagunada Moisesbuj escribishkamunda kallarisha Dios nishkada tuki parlujkuna escribishkagunabi imalla parlushkada yachachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús pueblomu chayagusha Jesusga ashtan karumu rij shina kallariga. ");
INSERT INTO qxl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ama richun paigunaga, “Ña indi waigugusha ña tutayagushkamunda ñukuchin kaibi sakiri,” nigaguna. Shina niki Jesús paigunan wasimu waiguga. ");
INSERT INTO qxl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mikungu mizabi tiyasha tandada japisha Diosta <Diosolopai> nishaga chaubisha karuga. ");
INSERT INTO qxl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Shina karaki paigunaj ñawi paskarij shinalla Jesusta rijsigaguna. Rijsinmi, Paiga chingariga. ");
INSERT INTO qxl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chingariki kashna ninukugaguna, “Ñanda ñukuchimu pai parlamusha Diosbuj Shimi nishkada yuyachikiga ñukuchij shungu kushilladimi rauraguga ¿nachu?” ");
INSERT INTO qxl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Shina ninukushka k'ipa Jerusalenmu vueltasha chunga shuj agllashkagunash paigunaj rijsishkagunash tandanukusha tiyajta japigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tandanukushkagunaga, “¡Mandaj Jesús kausarishkami! ¡Simonmumi rikurishka!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chimunda ishkindijmu ñanbi ima laya rikurishkada, tandada chaubisha karaki rijsishkadash parlagaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Paiguna ima tukushkada parlanukuki Jesús paigunaj chaubibi ñash shayarishaga, “K'uilla kausi kangunan gachun,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","<Almami rikurin> yuyisha paigunaga pachun manchariga. ");
INSERT INTO qxl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús chida rikusha niga, “¿Imashadi mancharishka ganguichi? Kangunaj shungubi na crisha ¿imashadi chaida kaida yuyaringuichi? ");
INSERT INTO qxl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñukaj makida chakidash rikichi. Ñukaidimi gani. Tupusha rikichi. Almaga na aichayujchu, na tulluyujchu. Ñuka chigunada charishkada rikugunguichimi.” ");
INSERT INTO qxl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Shina nishka k'ipaga makida chakidash rikuchiga. ");
INSERT INTO qxl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Paiguna kushiyasha mancharisha narij crikish Jesusga, “¿Ima mikunadash charinguichichu?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","kusushka ashalla chaulada karugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chida karukiga japisha paigunaj ñaubujllabidi mikuga. ");
INSERT INTO qxl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chi k'ipa Jesusga, “Kangunan purishaidi kangunamu, tuki Ñukamunda Moisés mandushkabish ñauba parlujkuna parlushkabish Salmosbish escribishkaga p'aktanami ganga, nisha nishkagunada Ñuka ima tukushkaga ña p'aktachishkami,” niga. ");
INSERT INTO qxl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chimunda Dios escribichishkagunada paigunamu alli intindichisha, ");
INSERT INTO qxl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","kaida paigunamu niga, “Kai escribishkaga tiyan. Dios agllusha kachushka Cristoga wañunami gan, kinsa p'unlla k'ipaga kausarinami, ");
INSERT INTO qxl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","shinash tuki llaktabi kausujkunamumi Paimunda parlashka gana gan. Jerusalén pueblomunda kallarisha Paibuj shutibi <Juchada sakisha kangunaj juchagunada perdonachun Diosmu kuchuyichi> nisha yachachinami gan. ");
INSERT INTO qxl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kangunaga tuki kai imalla tukushkada rikujkunami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kununga Ñuka Taita <Kushami> nishkada kachushami. Shinaki jawamunda tukida rurachi pudijta japingagama Jerusalenbi shuyagunguichilla.” ");
INSERT INTO qxl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesusga yachagujkunada Jerusalén pueblo washamu Betania pueblomu pushusha riga. Chibimi paigunaj jawabi makida alsusha alligunada kuchun niga. ");
INSERT INTO qxl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Paigunamu alligunada kuchun nigujllabidimi jawa pachamu pushushka gaga. ");
INSERT INTO qxl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Paigunaga Paida <Allimi gangui> nishka k'ipaga manchanai kushiyashami Jerusalenmu kutin shamugaguna. ");
INSERT INTO qxl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Diosbuj wasibish tandanukusha ashtan p'unllandijta Diosta <Allimi gangui> nisha tiyagaguna.");
INSERT INTO qxl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Taita Dios imadash narij rurujllabidimi, Parlashka Shimiga ña tiyaga, Parlashka Shimiga Dioskunmiga, chi Parlashka Shimiga Dioslladimiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tukida kallarikiga Paiga ña Dioskunmiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paimundami Diosga tuki ima tiyashkadash rurushka; ima tiyashkamundash Pai illujka, imadash na rurugachu. ");
INSERT INTO qxl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Paibimi kausiga tiyaga, chi kausiga gentegunajka p'unllayachij Luzmiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yanamangabi chi Luzmi p'unllayachin, shinaidi yanamangaga chi Luztaga na vinci pudishkachu. ");
INSERT INTO qxl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios kachushka k'arimi tiyaga, paiga Juanchu shutimiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pai rikushkada yachi chayachingu shamuga; pai nishkada uyusha tukiguna crichunmi, Luzmunda yachi chayachiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanchuga na Luzchuga; ashtanbish Luzmunda yachi chayachichunmi kachushkaga. ");
INSERT INTO qxl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tuki gentegunada p'unllayachij kabishkadadi Luzmi kai pachamu chayamuguga. ");
INSERT INTO qxl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chi Parlashka Shimiga kai pachabimi tiyaga, Dios Paiyun kai pachada rurushka gakish, kai pachamundagunaga pi gashkadash na yachushkamundami na rijsigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Paibuj gentegunamumi shamuga, shinash Paibuj gentegunaga na japish nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ashtangarin mashnalla Paida japijkunamu, Paibuj shutibi crijkunamunga, Diosbuj wawagunadi tukuchunmi kuga. ");
INSERT INTO qxl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Paigunaga yaurmundama, aicha munimundama, kusa munashkamundamash na wacharishkachu, ashtanbish Taita Diosbuj munimundami Paibujti wawaguna tukunguna. ");
INSERT INTO qxl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chi Parlashka Shimiga aicha tukushami, ñukuchin kausaga. Shujlla Churi gashkamunda Taitamunda japishka Pai k'uilladi gashkadami rikushkanchi. Pachunlladi k'uyi junda, imadash kabishkada parlujmiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanchuga Paimundami kashna nisha yachi chayachiga: “ ‘Ñukamunda k'ipa shamujka, ñukada yalli valijmi gan, ñukamunda ñaubushadi tiyashkamunda,’ nisha Ñuka parlagushaga Paimundami nigugani.” ");
INSERT INTO qxl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pai pachundi k'uyi junda gashkamunda, tuki ñukuchikish chi jawa chi jawa Dios kushka alligunada japishkanchi. ");
INSERT INTO qxl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Diosga mandushkagunadaga Moisesmumi kuga, ashtanbish k'uyidash, kabishka parludash Jesucristomundami japishkanchi. ");
INSERT INTO qxl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Diostaga rikidadijka pish na rikujchushka; shujlla Churi Dioslladi shinaidi Taitandij igulda gajmi ñukuchimu rijsi chayachishka. ");
INSERT INTO qxl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kaiga Juanchu kabishkagunada yachi chayachishkamigun. Manduj israelgunami Juanchuda <¿Pidi gangui?> nisha tapuchun, curagunadash levitagunadash Jerusalenmunda kachugaguna. Shina tapukimi, ");
INSERT INTO qxl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","paiga na pakushalla parlusha, “Ñukaga na Cristochu gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Shinadijka, ¿pidi gangui? ¿Dios nishkada parluj Eliaschu gangui?” nisha tapuki, “Na paichuni,” niga. “¿Shinaga Dios nishkada parlungu shamuna nishkachu gangui?” niki, “Na,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kutinlladi tapusha, “Shinadijka ¿pidi ganguiri? Ñukuchida kachujkunamuga pi gashkada parlanami ganchi. ¿Kanllamundadijka imada ningui?” niki, ");
INSERT INTO qxl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanchuga Dios nishkada parluj Isaías parlashka shina niga, “ ‘Manduj Diosbuj ñanda derecho rurusha alli parijichi,’ nisha shitashka pushtubi kaparijmi gani.” ");
INSERT INTO qxl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanchun parlarichun kachushkagunaga fariseogunamiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Paigunaga, “Kan Cristo na gasha, Eliasbish, Dios nishkada parlukish na gashaga, ¿imashadi bautizangui?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Shina niki Juanchuga, “Ñukaga yakunmi bautizani, ashtanbish kangunapurallabidimi shujka tiyan, kangunaga na rijsinguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Paimi ñukaj k'ipa shamunga. Ñukaga Paibuj pargati watushkada paskungujllash na kabinichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kaigunaga Juanchu bautizagushka Jordán yaku ch'imba ladumu gaj Betania pueblobimi shina tukuga. ");
INSERT INTO qxl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kayundij p'unlla Jesús paibuj kuchumu kuchuyamujta Juanchu rikushaga, “Rikichi, Paimigun Dios kachashka Malta Oveja shina; Paiga kai pachabi kausujkunaj juchagunadash p'ichajmi gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Ñuka parlagushkaga Paimigun; ‘Ñukamunda k'ipa shamujka, ñukada yalli valijmi gan, ñukamunda ñaubushadi tiyashkamunda,’ nishaga Paimundami nigugani. ");
INSERT INTO qxl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ñukaidikish pi gashkada na yachuganichu, ashtangarin Israel genteguna rijsichun nishallami yakun bautizasha shamugani.” ");
INSERT INTO qxl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Shinaidi kaidash Juanchuga yachi chayachigami: “Jawa pachamunda paloma shina uriyamusha Diosbuj Espíritu Jesusbuj jawabi tiyarijtami rikugani. ");
INSERT INTO qxl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ñukaga Pai pi gashkada chairijti na yachuganichu, ashtanbish yakun bautizachun ñukada Kachujmi, ‘Maijinbuj jawabi Diosbuj Espíritu uriyamusha tiyarin, Paimi Diosbuj Espiritunga bautizaj gan,’ nisha ñukamu parlaga. ");
INSERT INTO qxl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ñukaga Paida ña rikushkanimi, shinushami Paiga Diosbuj Churi gashkada yachi chayachini,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kayundij p'unlla Juanchuga kutin paibuj ishki yachagujkunandi chibi gasha, ");
INSERT INTO qxl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús chibi purijta rikushaga, “¡Rikichi; Dios kachashka Malta Oveja shinaga Paimigun!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Shina parlujta uyusha chi ishki yachagujkunaga Jesusta katigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paiguna katisha rigujta Jesús vueltusha rikushaga, “¿Imada mashkanguichi?” niga. Shina niki paigunaga, “Rabí, ¿pibukidi kausagungui?” nigaguna. (Rabí nishaga Yachachij nishami nin.) ");
INSERT INTO qxl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Shina niki Jesusga, “Jakuchi rikungu,” niga. Shina pibuki kausagushkada rikungu rishaga, ña tardi chusku uras shina gashkamundaga chi illujta tardidaga Paigunmi kainugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juanchu parlushkada uyusha Jesusta katish rij ishkigunamundaga, shujka Simón Pedroj wauki Andikumiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Imadash narij rurushaidimi Andikuga paibuj wauki Simonda japishaga, “Mesiastami japishkanchi,” niga. (<Mesías> nishaga Cristo nishkami gan). ");
INSERT INTO qxl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chimunda Andikuga Simonda Jesusbujmu pushusha riki, Jesús paida rikushaga, “Kanga Juanchuj churi Simonmi gangui; ashtanbish kununmundaga Cefas shutimi gangui,” niga. (Cefas nishaga Pedro nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kayundij p'unlla Jesús Galilea llaktamu ringu munusha rigushaga Felipen tupanukusha, “Ñukada katimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipega, Andikush Pedrosh kausushka pueblo Betsaidamundamiga. ");
INSERT INTO qxl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipega Natanaelda mashkungu risha japishaga, “Moisés escribishka Mandushkabi shinaidi Dios nishkada parlujkuna escribishkagunabi parlushka k'aridami japishkanchi. Paiga Jesusmi, Jozij churi Nazaretmundamigun,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelga, “¿Nazaretmundaga ima alligunadi llujshi pudingari?” niki, Felipega, “Shinadijka jaku rikungu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael kuchuyamujta Jesús rikushaga, “Rikichi, kaimu shamujka, imabish na llagmuj, kabishka Israelmigun,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Shina niki Natanaelga, “¿Ima layamundadi ñukadaga rijsingui?” nisha tapuga. Chimunda Jesusga, “Narikish Felipe kanda kayujllabidi, jigus yura ukubi gakimi kandaga rikugani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Shina niki Natanaelga, “Rabí, ¡Kanga Diosbuj Churi, israelgunada Jatun Manduj ganguindi!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Shina niki Jesusga, “ ‘¿Jigus yura ukubimi rikugani,’ nijllabichu cringuiri? Kaidash yalligunadami rikungui,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Shinaidi, “Kabishkadadimi kangunada nini: jawa pacha paskarijta shinaidi Aichayuj tukushka Churibimi Diosbuj angelgunaga ichimu urimu uriyagujkunada rikunguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kinsa p'unllabiga Galileabi gaj Caná pueblobi shuj boda tiyaga; Jesusbuj mamash chibimiga. ");
INSERT INTO qxl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Shinaidi Jesusbish Paibuj yachagujkunashmi bodamu shamuchun kayashkagunaga. ");
INSERT INTO qxl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Uvan rurashka vino tukuriki Jesusbuj mamaga Paidaga, “Ña vino illujkunami tukushka,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Shina niki Jesusga, “Kan warmi, ¿ima nishadi shina ninguiri? Ñukaj uraska chairijti narij chayungandi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Shina niki Paibuj mamaga sirvijkunamu, “Pai ima nishkada rurichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chibimi israelguna Diosbuj ñaubuki maillarina yakuda churana sujta rumi p'unduguna tiyaga. Shuj p'unduga pichka chungama (50), kanchis chungama (70) litro yakuda apujkunamiga. ");
INSERT INTO qxl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chibimi sirvijkunamu Jesusga, “Kai p'undugunabi yakuda jundachichi,” niga. Shina nikimi p'undu shimigama yakuda jundachigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chimunda Jesusga, “Kununga ashawada ishisha bodada mingarishka k'arimu apichi,” niga. Shinami apusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bodada mingarishkaga vinoda rurushka yakudami malliga, maimunda llujshishkadash na yachushalla; yakuda ishij sirvijkunallami yachugaguna. Chimunda bodada mingushkaga novioda kayushaga, ");
INSERT INTO qxl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Tukigunami kallaribiga alli vinodadi rakinguna; kayushkaguna milgada ubiashka k'ipami yangalla vinodaga rakinguna. Ashtanbish kanga kunungama alli vinoda charishkanguindi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galilea llakta Caná pueblobimi Jesusga kai pish na ruri pudishka rikuchinan rikuchisha kallariga; shina rurushami Pai k'uilladi gashkada rikuchiga; shinami Paibuj yachagujkuna Paida crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chi k'ipaga Paibuj maman, Paibuj waukigunan, shinaidi Paibuj yachagujkunanbish Jesusga Capernaum-mu uriyaga. Chibimi shuj p'unllagunada sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israelgunaj Pascua pishta ña kuchuyamugukimi, Jesusga Jerusalenmu ichiyaga. ");
INSERT INTO qxl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chibimi Diosbuj wasi pungubi wagragunada, ovejagunada, palomagunada k'atusha gajkunada shinaidi kuchkida cambiasha tiyajkunadash japiga. ");
INSERT INTO qxl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chida rikusha Jesusga shuj waskada japisha dalinada rurushaga, tukigunada wagragunandi ovejagunandi, Diosbuj wasimunda llujshichisha kachuga. Kuchkida cambiajkunajtash, kuchkigunada pambabi tsirapasha piguga, mizagunadash t'angushtasha shituga. ");
INSERT INTO qxl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Shinaidi palomagunada k'atujkunadaga, “¡Kaimunda kaigunada anchuchichi! Ñukaj Taitaj wasidaga ama k'atuna wasida rurichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chibimi Diosbuj Shimibiga, “Kambuj wasida Kambujlla gachun munushami manchanai shungundijta llakirini,” nisha escribishka tiyashkada Paibuj yachagujkunaga yuyarigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chimunda israelgunada mandujkuna, “¿Imadi gangui kashna rurungujka? ¿Ima pi na ruri pudishkadadi rurusha rikuchisha ninguiri?” nisha Jesusta tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Shina tapuki Jesusga, “Kai Diosbuj wasidaga p'akishtakish, kinsa p'unllabiga kutin shayachishallami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Shina niki israelgunada mandujkuna, “Kai Diosbuj wasidaga chusku chunga sujta (46) watagunadami ruragusha shayachishkagunaga. ¿Kanga kinsa p'unllabichu jatarichisha ninguiri?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ashtanbish Jesusga Diosbuj wasimunda parlushaga, Paibuj cuerpollamundadimi parluga. ");
INSERT INTO qxl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chimunda wañushkagunapuramunda Jesús kausariki, Paibuj yachagujkuna Pai shina nishkada yuyarigaguna, shinushami Diosbuj Shimi nishkadash Jesús parlushkadash crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua pishta p'unllagunabi, Jesús Jerusalenbi gasha pish na ruri pudishka rikuchinagunada ruraki, taugaguna chida rikusha Paibuj shutibi crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ashtanbish Jesús tukigunaj yuyida rijsishkamundaga paigunada na crigachu. ");
INSERT INTO qxl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pailladi gentegunaj shungu ima laya gashkada yachushkamundami, chi gentegunamunda maijin imada parlachunbish na ministiga. ");
INSERT INTO qxl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Israelgunapuramunda shuj pushaj Nicodemo shuti fariseo tiyaga. ");
INSERT INTO qxl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paiga Jesusta tuta rikungu rishaga, “Yachachij, ñukuchimu yachachichun Dios kanda kachushkadaga yachanchimi; maijinbish Dios paigun na igulda gakiga, pish na ruri pudishka rikuchinagunada kan ruragushka layaga, na ruri pudinmuchu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Shina niki Jesusga, “Kabishkadadimi nini, maijin na kutinlladi wacharishaga, Dios ima laya mandashkadaga rijsilladash na rijsi pudingachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chimunda Nicodemoga, “Shuj k'ari ña ruku gashaga, ¿ima layadi kutin wacharingari? ¿Mamaj iksa ukubi kutin waigusha wachari pudingacha?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Shina tapuki Jesusga kashnami niga: “Kabishkadadimi nini, maijinbish yakumunda shinaidi Diosbuj Espiritumunda na wacharijka, Diosbuj mandanamunga na waigui pudingachu. ");
INSERT INTO qxl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Gentemunda wacharijka gentemi gan; Diosbuj Espiritumunda wacharijka espiritumi gan. ");
INSERT INTO qxl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Shinushaga, ‘Kutinmi wacharina ganguichi,’ nisha Ñuka nishkadaga, ama mancharichu. ");
INSERT INTO qxl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Waira maimundash shitanllami; chi waira shitashkada uyushash maimunda shamushkada maimu rigushkadash na yachunguichu; Diosbuj Espiritumunda maijin wacharishkaga shinami gan.” ");
INSERT INTO qxl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Shina niki Nicodemoga, “¿Kaiga ima layadi ganga?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chimunda Jesusga kashna niga: “Kan, israelgunada yachachij gashash ¿kaigunada nachu yachuganguiri? ");
INSERT INTO qxl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kabishkadadimi nini, Ñukuchiga ima yachushkadami parlanchi, shinaidi ima rikushkadami yachi chayachinchi; shinash ñukuchi yachi chayachishkadaga kangunaga na cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kai pachabi ima laya gashkada Ñuka parlakish na crishadijka, jawa pachabi ima laya gashkada parlukigarin, ¿ima layadi cringuichiri? ");
INSERT INTO qxl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jawa pachamunga pish na ichiyashkachu, ashtanbish jawa pachamunda uriyamuj, Aichayuj tukushka Churillami ichiyaj gan. ");
INSERT INTO qxl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ima layami Moisés shitushka pushtubi culebrada shuj kaspibi alsuga, shina layaidimi Aichayuj tukushka Churish alzushka gana gan, ");
INSERT INTO qxl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mashnalla Paibi crijkuna na tukurij kausida charichun.” ");
INSERT INTO qxl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Taita Dios kai pachabi kausujkunada manchanaidi k'uyushami, Paibuj shujlla Churida kachuga, maijinsh Paida crijka ama chingarishalla, ashtangarin na tukurij kausida charichun. ");
INSERT INTO qxl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Taita Diosga Paibuj Churidaga kai pacha gentegunada juchachisha llakichingujka na kachugachu, ashtangarin paigunada llakichinamunda kishpichingajmi Paidaga kachuga. ");
INSERT INTO qxl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Maijin Paida crijka, na juchachisha llakichishkachu gan. Ashtanbish maijin na crijka, shujlla Diosbuj Churida na crishkamundaga ña juchachishkami gashka. ");
INSERT INTO qxl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Luz kai pachamu shamukish gentegunaga na alligunada rurushkamundaga Luzbuj randiga tutadami yalliga munugaguna; shinushaga ña juchachishkagunami gashka. ");
INSERT INTO qxl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tuki na allida rurujkunaga luztaga na rikunachijkunami; chimunda paiguna ima rurashkagunash ama yacharichunmi Luzmunga na kuchuyanguna. ");
INSERT INTO qxl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ashtanbish maijin kabishkada rurusha kausujka Dios munushka shina ruragushka rikurichunmi luzmunga shamun.” ");
INSERT INTO qxl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chi k'ipa Jesusga Paibuj yachagujkunanmi Judea llaktamu riga, chibimi tauga p'unllagunada paigunan gasha bautizasha puriga. ");
INSERT INTO qxl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanchush Salim kuchullabi gaj Enón llaktabi, chibi milga yaku tiyashkamundami bautizaguga; chimu rishami bautizashkaguna gaga. ");
INSERT INTO qxl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kaigunaga Juanchu chairijti narij carcelbi churushka gakimi shina tukuga. ");
INSERT INTO qxl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chimundaga Juanchuj yachagujkunamunda maijingunaga, shuj Israelgun Diosbuj ñaubuki linsharinamunda rimanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chimunda Juanchujmu rishaga, “Yachachij, riki. Jordán yaku ch'imbabi kangun gaj, Paimunda kan yachi chayachigushkami bautizagushka; tukigunami Paibujmu chayanguna,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Shina niki Juanchuga, “Imadash Dios na kukiga pish na japi pudinchu. ");
INSERT INTO qxl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Ñuka na Cristochu gani, ashtanbish Paimunda ñaubusha kachushkallami gani,’ nisha ñuka parlushkadaga kangunaidi uyuganguichimi. ");
INSERT INTO qxl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Shuj bodabiga noviada charijka noviomi gan, novion igulda gaj apanukujka novio parlushkada uyusha manchanaidimi kushiyarin; shinaidimi ñukash Jesusmunda uyusha kushilladi gani. ");
INSERT INTO qxl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Shinushami Paiga ichiyaj shina ashtan ashtan <Alli> nishka gachun, ñukaga uriyaj shina yanga tukuna ministirin,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jawamunda Shamujmi tukigunada yalli gan. Kai pachamunda gajka kai pachajlladi gashami kai pachamundagunaida parlan. Ashtanbish jawa pachamunda Shamujka tukigunada yalli gashami, ");
INSERT INTO qxl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","imada rikushkada, uyushkada parlan; shinash Pai parlushkadaga pish na uyash ninchu. ");
INSERT INTO qxl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ashtangarin maijin Pai parlashkada uyusha japijmi, Dios kabishkada parluj gashkada rikuchin. ");
INSERT INTO qxl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios Paibuj Espirituda yallimanaidi kushkamundaga, Dios kachashkaga Dios parlushka shimigunadami parlan. ");
INSERT INTO qxl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taita Diosga Churida k'uyushami tukida rurachun Paibuj makibi churashka. ");
INSERT INTO qxl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Maijinsh Diosbuj Churida crijka na tukurij kausidami charin; ashtanbish maijin Diosbuj Churida na crish nijka, na tukurij kausidaga na charingachu, ashtanbish Taita Dios p'iñarisha llakichishkabimi kausagun. ");
INSERT INTO qxl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","<Jesusga Juanchudash yalli katijkunada rurashami shinaidi bautizagun> nijta fariseoguna uyushkadami Jesusga yachi chayuga. ");
INSERT INTO qxl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesustijka na bautizagachu, ashtangarin Paibuj yachagujkunami bautizagaguna.) ");
INSERT INTO qxl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Shinami kutin Galilea llaktamu vueltungaj Judea llaktamundaga llujshisha riga. ");
INSERT INTO qxl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Shina rigushaga Samariada pasana ministirigaidimi. ");
INSERT INTO qxl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Shinami ñauba taita Jacob paibuj churi Jozimu kushka achpa kuchulla, Samaria llaktabi tiyaj Sicar nishka pueblomu chayuga. ");
INSERT INTO qxl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chibimi Jacob-buj yaku puzuga tiyashkaga. Ña chaubi p'unlla tukukimi Jesusga ñanbi shaikushkaidi shamushaga chi yaku puzu manyabi tiyariga. ");
INSERT INTO qxl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chi ratuga Paibuj yachagujkunaga mikunada randingujmi pueblomu rishkagunaga. Chibimi Jesusga Samariamunda shuj warmi yakuda ishingaj shamuki, “Yakuda ubiangu kumbidi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Israelgunan Samariamundagunan na apanukujkuna gashami chimunda warmiga Paidaga, “Kan Israel gashash, Samariamunda warmi gakish, ¿ima nishadi yakuda ñukada mañungui?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Shina niki Jesusga, “Dios imada kuj gashkada, pi yakuda mañagujta kan rijsishaga ashtan kanmi Ñukada mañunguimu; shina mañukiga Ñukaga kausida kuj yakudami kunimu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Shina niki chi warmiga, “Hijo taita, yaku puzuga jundudimi, iman ishinadash na charinguindi. Shinadijka, ¿maimundadi kausida kuj yakudaga kunguiri? ");
INSERT INTO qxl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ñukuchij ñauba taita Jacobdash ¿kanga yallichuma imadi gangui? Paimi kai yaku puzudaga ñukuchimu kuga; kai yakudami pailladi, paibuj churigunash, paibuj animalgunash ubiagaguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Shina niki Jesusga kashna niga: “Tuki kai yakuda ubiujkunaga kutinmi yakunachingaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ashtanbish maijin Ñuka kuna yakuda ubiashaga ima uragamash na yakunachingachu; Ñuka kushka yakugarin paibuj ukumunda p'ugyu yaku shina llujshigushallami na tukurij kausida kunga.” ");
INSERT INTO qxl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Shina niki chi warmiga, “Hijo taita, ama ñuka yakunachingaj, yakuda ishingu ama shamungajkish, chi yakuda ñukamu kubai,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chimunda Jesusga, “Kambuj kusada kaimu pushamungaj ri,” niki, ");
INSERT INTO qxl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","chi warmiga, “Kusa illujmini,” niga. Shina niki Jesusga, “ ‘Kusa illujmini,’ nishaga allidami nishkangui. ");
INSERT INTO qxl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kanga pichka kusadami charishkangui, shinaidi kunun kangun kausagushkash na kambuj kusachugun. Kaidaga kabishkadadimi nishkangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Shina niki chi warmiga, “Kanga Dios nishkada parlujmishkanguinchin,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Ñukuchij ñauba taitagunash kai urkubimi Diosta adorajkunaga; ashtanbish kanguna israelgunaga ‘Jerusalenbimi Diosta adoranagun,’ ninguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Shina niki Jesusga chi warmidaga kashna niga: “Ñuka nishkada cri, kangunaga kai urkumu na shamushalla Jerusalenmush na rishalla Diosta <Allimi gangui> nina uraska chayamugunmi. ");
INSERT INTO qxl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kanguna Pida <Allimi gangui> nigushkadash na yachunguichichu; israelgunapuramunda Kishpichij shamuna gashkamundami ñukuchiga Pida <Allimi gangui> nigushkadash yachanchi. ");
INSERT INTO qxl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ashtangarin Diosta kabishkadi adorajkunaga Diosbuj Espíritu yachachishka shina tuki shungun <Allimi gangui> nina p'unlla kuchuyamugun, chi p'unllaga kununlladimi gan. Shina Paida <Allimi gangui> nijkunadami Taita Dioslladi mashkagun. ");
INSERT INTO qxl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosga Espiritumi gan; shinusha Paida adorajkunaga Diosbuj Espíritu yachachishka shina tuki shungun <Allimi gangui> ninaga kabinlladimi.” ");
INSERT INTO qxl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chimunda chi warmiga, “Cristo nishka Mesías shuti shamuna gashkadaga ñukaga yachanimi; Pai shamushami tuki kaigunadaga alli intindichinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Shina niki Jesusga, “Paiga Ñukaidimi gani; Pailladimi kangun parlarigun,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Shina parlariguki Paibuj yachagujkuna chayamushaga Jesús shuj warmin parlarigujta rikusha mancharishkaidi tukugaguna; shinash chi warmi imada nigushkada shinaidi “¿Imamunda paigun parlarigungui?” nishamallash maijinbish na tapugagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chimunda chi warmiga paibuj p'unduda chi pushtubi sakisha pueblomu riga. Chibimi gentegunamu, ");
INSERT INTO qxl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tuki ñuka ima rurushkagunada ñukamu parluj k'arida jakuchi rikungu. ¿Nachu Paiga Cristo ganga?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Shina nikimi pueblomunda llujshisha Jesusbujmu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chigamaga yachagujkunaga, “Yachachij, imaidash mikiri,” nisha atirigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Shina niki Paiga, “Ñukaga kanguna na rijsishka mikunadami mikungu charini,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Shina niki Paibuj yachagujkunaga, “¿Mikunada maijinsh apamugachashi?” nisha kaishuj chaishuj tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ashtanbish Jesusga, “Ñukada Kachuj munushka shinada rurana, Pai kushka ruranagunadash tukuchinami Ñukaj mikuna shina gan. ");
INSERT INTO qxl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kangunaga ¿nachu, ‘P'ukushka granuda tandanaga chairijtij chusku killami jualtun,’ nijkuna ganguichi? Ashtanbish Ñukaga, ‘Tarbushkada alli rikichi, granuga ñami p'ukushka tandanalla gan,’ ninimi. ");
INSERT INTO qxl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maijin p'ukushka granoda tandachisha trabajajka paimu paganada japinmi, shinaidi p'ukushka granoda layami na tukurij kausida japichun gentegunada tandachin, shinami tarbujkish tandachijkish igulda kushilla ganguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nishkagunabiga, ‘Tarbujkish shujmi, tandachijkish shujmi,’ nishaga kabishkadami nishka. ");
INSERT INTO qxl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kanguna na trabajashka granoda tandachunga Ñukami kachugani; trabajajkunadijka shujkunamiga; kangunaga paiguna trabajashkallamundami allida japishkanguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chi warmi, “Tuki ñuka ima rurushkagunadami ñukamu niga,” nisha parlushkamundami chi pueblobi kausuj tauga Samariamundaguna Jesusta crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chimunda Samariamundaguna Jesusbujmu shamushaga paigunan sakirichun mañakimi ishki p'unllada chibi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Shinaidi Paidi parlushkada uyushagarin ashtan taugagunami crij tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chimunda chi warmimu, “Kununga na kan nishkallamundaga crinchichu, ashtangarin ñukuchilladi uyushkamunda, shinaidi kai pachabi kausujkunada Pai kabishkadi Kishpichij gashkada yachushkamundami crinchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chi ishki p'unllada Samaria llaktabi gashka k'ipaga Jesús Galileamumi riga. ");
INSERT INTO qxl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Jesuslladimi <Dios nishkada parlujtaga kikinbuj llaktallabidijka na valichishkami gan> nisha nishkaga). ");
INSERT INTO qxl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea llaktabi gajkunaga paigunash Pascua pishtamu risha Jesús Jerusalenbi tuki ima rurushkagunada rikushkamundami Pai Galileamu chayukiga alli japigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Maibi yakuda vinoda rurushka Galilea llaktabi tiyaj Caná pueblomumi Jesusga kutin shamuga. Chi llaktada jatun manduj churashka k'arimi Capernaumbi tiyaga; paibuj churimi ungushka siriga. ");
INSERT INTO qxl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chi k'ariga Jesús Judeamunda Galileamu chayamushkada uyusha Paibujmu rishaga, “Ñukaj churimi ña wañunalla sirigun; alliyachingu jakubai,” nisha mañaga. ");
INSERT INTO qxl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Shina niki Jesusga, “Kangunaga jatun mancharinagunan rikuchigujta na rikushaga naidi cringuichimuchu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jatun manduj churashka k'ariga, “Mandujlla, ñukaj mara narij wañujllabidi ut'kada jakubairi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Shina niki Jesús paidaga, “Wasimu ri; kambuj churiga kausungami,” niga. Chi k'ariga Jesús shina nishkada crisha rigallami. ");
INSERT INTO qxl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ña wasimu vueltusha uriyamuki paibuj sirvijkuna paigun tupungu rigushaga, “Kambuj churiga kausagunmi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chimunda paiga, “¿Ima uradi alli tukungu kallariga?” nisha tapuki, paigunaga, “Kaina p'unlla la una shinadami rupuj unguiga p'itiriga,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chibimi <Kambuj churiga kausungami> nisha chi uraslladadi Jesús nishkada taitaga yuyariga; shinami paibish paibuj wasi ukupuragunandi illujta Jesusta crij tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesusga Judea llaktamunda Galileamu vueltashaga kaigunga ña ishki kutinmi pish na ruri pudishkada rurusha rikuchishkaga. ");
INSERT INTO qxl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kaiguna k'ipa israelguna Diosta yuyarina pishtada ruraki Jesusbish Jerusalenmu ichiyaga. ");
INSERT INTO qxl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenbimi Oveja nishka pungu kuchubi armana yaku kucha tiyaga; hebreo shimibiga Betzatá shutimi gan. Chibimi yaku muyundijbi pichka corredorguna rurushka tiyaga. ");
INSERT INTO qxl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chigunabimi tauga ungushkaguna, na rikujkuna, suchuguna, na kuyuri pudijkunama sirigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chi ungushkagunapurabimi kinsa chunga pusuj (38) watada suchu k'ari tiyaga. ");
INSERT INTO qxl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chibi shina sirijta Jesús rikusha unilladadi shina gashkada yachi chayushaga chi k'arida, “¿Alliyangu mununguichu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Shina niki ungushkaga, “Taita, yakuda kuyuchiki ñukada yaku tandarishkamu waiguchijtaga pidash na charinichu; ñuka waigungu rigujllabidimi shuj ñaubusha waigun,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chimunda Jesusga, “Jatari, kambuj wandunada japisha purisha ri,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Shina nin, chi k'ari alliyashaga paibuj wandunada japishaga puringumi kallariga. Chi p'unllaga samana p'unllamiga. ");
INSERT INTO qxl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Shinushami israelgunada mandujkunaga chi alliyashka k'aridaga, “Kununga samana p'unllamigun; shinusha wandunadaga na apusha rinachu gangui,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Shina niki chi k'ariga, “Ñukada alliyachijmi ñukadaga, ‘Kambuj wandunada japisha ri,’ niga,” nisha parluga. ");
INSERT INTO qxl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Paigunaga, “ ‘Kambuj wandunada japisha ri,’ nijka, ¿pidi gan?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Shinakish chi pushtubiga taugaguna tiyakimi Jesusga upalla laduyasha chingarishkallaga. Chimunda chi k'ariga pi alliyachishkadash na yachugachu. ");
INSERT INTO qxl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chi k'ipaga Diosbuj wasibi paida Jesús japishaga, “Riki, kununga alliyashkami gangui; ama kaidash ashtan yalli llaki tukungujka kununmundaga ama juchada rurunguichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chimunda chi k'ariga Jesús alliyachij gashkadaga israelgunada mandujkunamumi risha parluga. ");
INSERT INTO qxl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Samana p'unllagunabi Jesús shina alliyachij gashkamundami manduj israelgunaga katik'ichagugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ashtanbish Jesusga paigunadaga, “Ñukaj Taitaga tuki ratumi shina ruragushka, shinaidimi Ñukash ruraguni,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Shina nishkamundaga samana p'unlla mandushkada na p'akishkallamunda, ashtandijkarin <Diosga Ñukaj Taitami> nishaga Paiga Dios gashkada nigushkamundash manduj israelgunaga wañuchingu ashtallandi munugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chimunda Jesusga paigunamu kashna niga: “Kabishkadadimi nini, Diosbuj Churiga Paibuj munillamundadijka imadash na ruri pudinchu, ashtanbish Taita rurushkada rikushami rurun; Taita imalla rurushkagunadami Churish shinaidi rurun. ");
INSERT INTO qxl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taitaga Churida k'uyashami Pai tuki ima rurushkada rikuchin; kaigunamundash ashtandi yallidami rikuchinga, chida rikushami kangunaga mancharishkaidi sakiringuichi. ");
INSERT INTO qxl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ima layami wañushkagunada jatarichisha Taita kausida kun, shinaidimi Churish Pai kusha nishkagunamu kausida kun. ");
INSERT INTO qxl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taitaga pidash na juchachinchu, ashtanbish Paibuj Churimumi juchachina na juchachina tuki poderdaga kushka. ");
INSERT INTO qxl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taitada allibi churushka layaidi Churidash tukiguna allibi churachunmi chi poderdaga kushka. Maijinsh Churida allibi na churujka, Paida Kachuj Taitadash shinaidimi ruruj gan. ");
INSERT INTO qxl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kabishkadadimi nini, maijinsh Ñuka parlushkada uyusha Ñukada Kachuj Diosta crijka, na tukurij kausidami charin, na llakichishkachu ganga; ashtanbish wañimundami kausimu ña pasushka. ");
INSERT INTO qxl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kabishkadadimi nini, wañushka layaguna Diosbuj Churi parlushkada uyana uras chayamunmi, kununlladimi gan; maijin uyujkunaga kausungagunami. ");
INSERT INTO qxl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ima layami Taitaga kausida kungau Paillabidi charin, shinaidimi Churimush kausida kunada Paillabidi charichun kushka. ");
INSERT INTO qxl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Shinaidi Pailladimi Aichayuj tukushka Churi gashkamunda juchachina na juchachina poderda kuga. ");
INSERT INTO qxl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kaimundaga ama mancharichichu, tuki wañushkaguna Pai parlashkada uyana p'unlla chayamukiga, ");
INSERT INTO qxl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tuki allida rurujkunami pambushkamunda kausida charingu kausaringaguna; ashtanbish na allida rurujkunaga llakichishka gangajmi kausaringaguna.” ");
INSERT INTO qxl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ñukallamundadijka imadash na ruri pudinichu. Taita mandushkada uyashallami juchachingukish na juchachingukish pudini. Ñuka munushkada rurungujka na mashkanichu, ashtanbish Ñukada Kachuj Taita munushkaidami rurani. Shinushami Ñuka juchachishkaga kabishka gan. ");
INSERT INTO qxl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ñukallamundadi imadash yachi chayachishaga Ñuka yachi chayachishkaga imakish na valinmuchu, ");
INSERT INTO qxl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","shinash Ñukamunda yachi chayachijka shujmi tiyan. Pai yachi chayachishkaga kabishka gashkada yachanimi. ");
INSERT INTO qxl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kangunaga bautizaj Juanchuda tapuchun kachukiga, pai yachi chayachishkaga kabishkamiga. ");
INSERT INTO qxl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ashtanbish Ñukaga Ñukamunda maijin k'arish yachi chayachichunga na ministinichu. Kanguna kishpichishka gachun nishallami Juanchumunda parlani. ");
INSERT INTO qxl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanchu parlashkaga p'alaniguj nina japichishka micha shinami p'unllayachij gaga, chi p'unllayachij luz shina pai parlashkadaga ashagamallami kushiyasha uyaganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Shina gakish Ñukaga Juanchu parlushkamundash ashtandi yallidami rikuchinada charini. Ñukaga Ñukaj Taita rurachun nishkagunalladami rurani; kai rurushkagunaga Ñukaj Taita Ñukada kachushkadami rikuchin. ");
INSERT INTO qxl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Shinaidi Ñukada Kachuj Taitash Ñukamundami yachi chayachishka. Kangunaga Pai rimarishkadaga ima urash na uyushkanguichichu, Pai ima laya gashkadash na rikushkanguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pai kachukish Ñukada na crishkamundami Pai parlushka kangunabi na sakirin. ");
INSERT INTO qxl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Shinusha kangunaga Dios escribichishkagunadaga <Na tukurij kausida chibi japishun> nishami alli liyusha yachagunguichi, shinash Diosbuj Shimi Ñukamunda yachi chayachigukish, ");
INSERT INTO qxl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kangunaga chi na tukurij kausida charingujka na Ñukajmu shamush ninguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ñukaga genteguna <Alli> nishkadaga na japisha ninichu. ");
INSERT INTO qxl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ashtanbish Ñukaga kanguna Diosta na k'uyushkadaga yachanimi. ");
INSERT INTO qxl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ñuka Taitaj shutibi kachashka shamukish Ñukada na japish ninguichichu. Ashtanbish shuj kikinbuj shutillabidi shamukiga paidaga japinguichimumi. ");
INSERT INTO qxl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kanguna randi randi <Alli> nishka gashadijka, ashtangarin shujlla Dios <Alli> nichun na mashkushadijka, ¿ima layadi Ñukada cringuichiri? ");
INSERT INTO qxl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ñuka Taitaj ñaubuki kanguna na alli rurushkada Ñuka parlanadaga ama yuyunguichichu; kangunaj tuki yuyida churushka Moisesmi kangunadaga juchachinga. ");
INSERT INTO qxl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Shinaidi kanguna Moisesta crishaga Ñukadash cringuichimumi; paiga Ñukamundami escribiga. ");
INSERT INTO qxl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pai escribishkadash na crishadijka, ¿Ñuka parlushkadagarin ima layadi cringuichiri?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kaiguna k'ipa Jesusga Galilea yaku kucha ch'imba ladumumi riga. Chi kuchaga Tiberias nishkamiga. ");
INSERT INTO qxl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pish na ruri pudishkagunan rikuchisha ungushkagunada alliyachijta rikushkamundami taugalladiguna Paida katigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chimunda Jesusga shuj urkumu sikushaga Paibuj yachagujkunanmi tiyariga. ");
INSERT INTO qxl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israelgunaj Pascua pishtaga ñami kuchuyamuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Taugalladiguna katisha shamujta Jesús rikushaga Felipedaga, “¿Maimundadi kai tuki gentegunamunga tandada randishun?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Felipe imadami nijkushka uyungujllami shina niga; imada ruranashkada Jesuslladi allimi yachuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Shina niki Felipega, “Ishki patsuj (200) p'unllada trabajashkamunda pagushka kuchkish asha asha tukigunamu tandada randisha karanallash na p'aktungachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chimunda yachagujkunamunda Simón Pedroj wauki Andikuga, ");
INSERT INTO qxl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kaibimi shuj k'ari mara pichka cebada tandada shinaidi ishki chaulada charishka; kaikudijka kai taugagunamunga ¿ima layadi p'aktungari?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Shina niki Jesusga, “Tukigunada tiyarichun nichi,” niga. Chi pushtuga k'iwaidi pambamiga. Chibi tiyarij k'arigunaga pichka warungamamishkanga (5.000). ");
INSERT INTO qxl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chibimi Jesusga tandada makibi japisha Diosta <Diosolopai> nishaga chibi tiyajkunamu kuchun kuga. Chaulanbish shinaidi rurushami paiguna mashna munushkada kuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ña tukiguna sajsushka k'ipaga Paibuj yachagujkunada, “Imash ama yangadi shitushka gachun tuki p'aki puchugunada tandachichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Paigunaga chi pichka cebada tandamunda puchushka p'akigunamunda chunga ishki (12) canasta jundadami tandachigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kashna pish na ruri pudishkada Jesús rikuchishkada genteguna rikushaga, “Dios nishkada parluj kai pachamu shamuna nishkaga Pailladimishka,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Genteguna uyi na uyi jatun manduj tukuchun pushusha ringu munushkada Jesús yachushaga kutinmi ch'ikunyasha Pailla gangaj urkumu riga. ");
INSERT INTO qxl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ña tutayaguki Jesusbuj yachagujkuna yaku kuchamu uriyasha, ");
INSERT INTO qxl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","barcabi sikusha yaku kuchada Capernaum-mu ch'imbusha rigugaguna. Ña illujta tuta gakish Jesús narij paigunajmu shamushkachuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chibimi pachundi waira shamuki yaku jatarisha kaimu chaimu apik'ichuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ña pichka na gashaga sujta kilómetro shinada barcabi rigushami Jesús yaku jawada purisha barca kuchumu kuchuyamujta rikusha mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chimunda Jesusga, “Ama mancharichichu, Ñukami gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Shina niki paigunaga Jesusta barcabi kushilladi sikachigaguna. Chi k'ipa maimu rigushka achpamu ratuidi chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kayundij p'unllaga yaku kucha ch'imbamu sakirij gentegunaga chibi tiyashka shujlla barcabi yachagujkunalla sikusha risha ashtanbish Jesusga na paigunan sikush rishkadami cuenta kugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ashtanbish shuj barcagunaga Tiberias pueblomunda shamusha, maibi Manduj Jesús Diosta <Diosolopai> niki tandada mikugaguna, chi kuchulla pushtumumi chayagaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gentegunaga Jesusbish Paibuj yachagujkunash na chibi gashkada rikushaga chi barcagunabi sikusha Jesusta mashkungu Capernaum-mu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yaku kucha ch'imbamu chayusha Jesusta japishaga, “Yachachij, ¿ima uradi kaimu chayamugangui?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Shina niki Jesusga kashna niga: “Kabishkadadimi nini, kangunaga pish na ruri pudishkagunada rurusha rikuchishkada intindishkamundaga na mashkanguichichu, ashtanbish sajsungama tandada mikushkamundami Ñukadaga mashkanguichi. ");
INSERT INTO qxl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ismujlla mikunamundaga ama trabajichichu, ashtanbish na tukurij mikunamunda shinaidi na tukurij kausida kuj mikunamunda trabajichi. Kai mikunadaga Aichayuj tukushka Churiga Taita Dios Paibi selloda churusha <Alli> nishkamundami kangunamu kunga.” ");
INSERT INTO qxl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Shinusha paigunaga, “Dios nishkada rurungajka ¿imagunadadi rurana ganchi?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesusga, “Ñukada Pai Kachushka gashkada crichunmi Diosga munun,” nigami. ");
INSERT INTO qxl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chimunda, “Kanda rikusha cringujka ¿imadadi rurusha rikuchi pudingui? ¿Imagunadadi ruribuj gangui?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“Ñukuchij ñauba taitagunaga shitashka pushtubimi <maná> nishka tandada mikugaguna, Diosbuj Shimibi escribishka shina: ‘Jawa pachamundami tandada karaga.’ ” ");
INSERT INTO qxl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Shina niki Jesusga, “Kabishkadadimi nini, kangunamunga jawa pachamunda tandadaga Moisesga na karugachu, ashtanbish jawa pachamunda kabishkadi tandadaga Ñukaj Taitami kangunamu kuj gan. ");
INSERT INTO qxl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Diosbuj tandaga jawa pachamunda uriyasha kai pacha gentegunamu kausida kujmi gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Shina niki, “Hijo taita, tuki ratuj chi tandada kubangui,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chimunda Jesusga kashna niga: “Na tukurij kausida kuj tandaga Ñukami gani. Maijin Ñukajmu shamujka ima uragamash na yarijachingachu; shinaidi Ñukada crijka ima uragamash na yakunachingachu. ");
INSERT INTO qxl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ashtangarin ña kangunamu nishka shinaidi kangunaga Ñukada rikushash na cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Taita Ñukamu kushkagunami tuki Ñukajmu shamungaguna; shina Ñukajmu shamujkunadaga nalladi washamu vueltachish kachashachu. ");
INSERT INTO qxl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jawa pachamundaga Ñuka munushkada rurungujka na shamuganichu, ashtanbish Ñukada Kachuj munushkada rurungajmi shamugani. ");
INSERT INTO qxl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ñukada Kachujbuj muniga kaimigun: Pai Ñukamu kushkagunamunda maijinlladash ama chingachichun, ashtanbish tukurij p'unllabi kausachichunmi munan. ");
INSERT INTO qxl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Shinaidi Ñukaj Taitaj muniga, mashnalla Diosbuj Churida rikusha Paida crijkunaga, na tukurij kausida charichunmi munan; Ñukami tukurij p'unllabiga kausachisha.” ");
INSERT INTO qxl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chimundaga, “Ñukami jawa pachamunda uriyashka tanda gani,” nishkamundami israelgunaga Paimunda washalla rimungu kallarigaguna, ");
INSERT INTO qxl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","kashna ninukusha: “¿Nachu kaikuga Jozij churi Jesús gan? ¿Nachu paibuj taita mamadash rijsinchi? Shinadijka kununga, ¿imashadi, ‘Jawa pachamunda uriyashkami gani,’ ninri?” ");
INSERT INTO qxl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Shina niki Jesusga kashna niga: “Kangunapuraidijka ama Ñukamunda washalla imadash ninukichichu. ");
INSERT INTO qxl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ñukada Kachuj Taita na kuchuyachimukiga pish na Ñukajmunga shami pudinchu; shinaidi tukurij p'unllabiga Ñukami kausachisha. ");
INSERT INTO qxl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios nishkada parlujkuna escribishkabiga, ‘Diosmi tukigunamu yachachinga,’ ninmi. Shinushaga Taita nishkada maijin uyusha yachujka Ñukajmumi shamun. ");
INSERT INTO qxl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Maijinbish Taitadaga na rikushkachu; Diosmunda Shamujllami Taitadaga rikushka. ");
INSERT INTO qxl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kabishkadadimi nini, maijin Ñukada crijka na tukurij kausidami charin. ");
INSERT INTO qxl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ñukami kausida kuj tanda gani. ");
INSERT INTO qxl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kangunaj ñauba taitagunaga shitashka pushtubi ‘maná’ nishka tandada mikushash wañugagunami. ");
INSERT INTO qxl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ashtanbish Ñukaga jawa pachamunda uriyashka tandadami parlani, maijin chida mikujka na wañungachu. ");
INSERT INTO qxl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ñukami jawa pachamunda uriyashka kausuj tanda gani. Maijin kai tandada mikujka tuki ratumi kausunga; Ñuka kuna tandaga Ñukaj cuerpoidimi gan, chidami kai pacha genteguna kausachunga kusha.” ");
INSERT INTO qxl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Shinushami israelgunaga, “Kaikuga, ¿ima layadi paibuj cuerpodaga ñukuchimu kari pudingari?” nisha kaishuj chaishujkun rimanukungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chimunda Jesusga paigunadaga kashna niga, “Kabishkadadimi nini, Aichayuj tukushka Churij cuerpoda na mikusha shinaidi Paibuj yaurda na ubiushaga na tukurij kausidaga na charinguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Shinaidi maijin Ñukaj cuerpoda mikuj Ñukaj yaurda ubiujka na tukurij kausidami charin, shinaidi Ñukami tukurij p'unllabiga kausachisha. ");
INSERT INTO qxl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ñukaj cuerpoga kabishkadi mikunami gan, Ñukaj yaurga kabishkadi ubianami gan. ");
INSERT INTO qxl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Maijin Ñukaj cuerpoda mikuj shinaidi Ñukaj yaurda ubiujka Ñukan tandanukushkami kausan. Ñukash paigunmi tandanukushka kausani. ");
INSERT INTO qxl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ñukada Kachuj Taita kausida charin, Ñukash Paimundami kausani, shina layaidimi maijin Ñukamunda mikujka paibish Ñukamunda kausunga. ");
INSERT INTO qxl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kai tandalladimi jawa pachamunda uriyamushka tanda gan; kai tandaga na kangunaj ñauba taitaguna maná-da mikusha wañushka shinachu gan; maijin kai tandada mikujka tuki ratumi kausunga.” ");
INSERT INTO qxl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kaigunadami Jesusga Capernaúm pueblobi Diosmunda yachana wasibiga yachachiga. ");
INSERT INTO qxl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesusta katijkunamunda kai nishkagunada uyushaga taugagunami, “Kai nishkagunada japingujka jinchimi gan. ¿Pai nishkada pidi kazungari?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Shina Paida katijkuna kaigunamunda washalla rimagushkada Jesuslladi yachushaga, “¿Kai nishkagunaga jarkachinchuma imadi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Aichayuj tukushka Churi sarun tiyashkallamundi ichiyajta rikushaga, ¿ima ninguichimushi? ");
INSERT INTO qxl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiritumi kausidaga kun, aichaga imakish na valinchu. Ñuka parlushka shimigunaga Diosbuj Espiritumundami, shinaidi kausidash kuj shimigunami. ");
INSERT INTO qxl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Shinash kangunapuramunda shujkunaga na cringuichichu,” niga. Jesusga kallarimundadi piguna na crinadash shinaidi pi Paida japichinadash yachushami shina niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús kutin parlarishaga, “Shinushaga Taita pushamusha na kukiga maijinbish Ñukajmunga na shami pudinchu, niganimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chimunda pachami Paida katijkunamunda taugaguna washayasha ña na Paigun purigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Shinushami Jesusga chunga ishki (12) yachagujkunada, “¿Kangunash ringu mununguichichari?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Shina niki Simón Pedroga, “Manduj, ¿pibujmundi rishun? Kambuj shimigunami na tukurij kausida kuj shimigunagun. ");
INSERT INTO qxl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ñukuchigarin Diosmunda jucha illuj Cristo gashkada rijsisha ña crishkanchimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Shina niki Jesusga, “Kanguna chunga ishkigunadaga ¿nachu Ñuka agllugani? Shina gakish kangunamunda shujka diablo layami gan.” ");
INSERT INTO qxl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Shina nishaga Simón Iscariotej churi Judasmundami parlaga; Judasga chunga ishki yachagujkunamunda gashash paimi Jesusta japichinaga. ");
INSERT INTO qxl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chiguna k'ipa, israelgunada mandujkuna wañuchingu mashkushkamundami Jesusga Judeabiga na purish nisha Galilea llaktabi puriga. ");
INSERT INTO qxl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Israelguna carpada rurasha Diosta yuyarina pishta p'unllaguna ña chayamuguki, ");
INSERT INTO qxl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesusbuj waukigunaga, “Ama kaibi sakirichu; kanda crisha katijkuna kan ima rurushkagunadash rikuchunguna Judea llaktamu ri. ");
INSERT INTO qxl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maijin rijsi tukush nishaga imadash na pakallaga rurunchu. Kan shinagunada ruruj gashadijka tuki kai pacha gentegunaj ñaubuki rurush rikuchiri,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Paibuj waukigunaidikish Paida na crigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Shina niki Jesusga, “Ñukaj uraska chairijti narij chayunchu, ashtanbish kangunamunga ima urasbish allimigun. ");
INSERT INTO qxl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kai pachamundagunaga kangunadaga na p'iñi pudinchu; ashtanbish paiguna rurushkaguna na alli gashkada yachi chayachishkamundami Ñukadaga p'iñunguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kangunaga pishtamu richi, Ñukaj uras narij p'aktushkamundaga na rinichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kaigunada nishka k'ipaga Galileabimi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Shinash Jesusbuj waukiguna Diosta yuyarina pishtamu rishka k'ipaga pish ama yachi chayachun pakalla shinami Paibish pishtamu riga. ");
INSERT INTO qxl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israelgunada mandujkunaga pishtabiga, “¿Chi k'ariga maibi purinshi?” nishami mashkagugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gentegunapurabimi Paimunda washalla pachun parlagaguna; shujkunaga, “Pai k'ariga allimigun,” nigaguna. Chaishujkunaga, “Na allichugun, gentegunada llagmushami purin,” nigagunami. ");
INSERT INTO qxl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Shinash israelgunada mandujkunada manchushkamunda maijinbish na larudaga parlugagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ña chaubi pishta shina gakimi Jesusga Diosbuj wasimu risha yachachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Shina yachachigukimi chi israelgunaga, “Kaikuga maibish yachungu na rishadijka, ¿ima layadi manchanaidi yachuj ganshi?” nisha mancharishkaidi nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Shina niki Jesusga kashna niga: “Ñuka yachachishkaga na Ñukaj munimundachu; ashtanbish Ñukada Kachujbuj munimundami. ");
INSERT INTO qxl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Maijinbish Dios munushkada rurush nijka, Ñuka yachachishkaga Diosmundachu, na gashaga Ñukaj munillamundachu gashkada yachanmumi. ");
INSERT INTO qxl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Maijin kikinbuj yuyillamunda parlujka kikin <Alli> nishka gangujllami mashkun; ashtanbish maijin paida kachujta <Alli> nishka gachun mashkujka paimi kabishkada parluj imamundash na juchachibuj gan. ");
INSERT INTO qxl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisesga mandushkagunadaga ¿nachu kangunamu kuga? Shina kushka gakish kangunamundaga maijinbish mandushkagunada na p'aktachinguichichu. Shinaga, ¿imashadi Ñukadaga wañuchisha ninguichiri?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Shina niki gentegunaga, “¡Yana katishkamishkanguinchin! ¿Pidi kanda wañuchisha nigunri?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chimunda Jesusga, “Samana p'unllabi pish na ruri pudishkada shuj kutinlla rurushkamundami tukiguna mancharishkanguichi. ");
INSERT INTO qxl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ashtangarin Moisesmi circuncisión nishkada rurachun nisha mandushkamunda kangunaga samana p'unlla gakish k'ari marada aicha karada p'itichinguichillami. (Kai mandushkadaga Moisesga na kallarichigachu, ashtanbish ñauba taitagunamundami shamushka gan.) ");
INSERT INTO qxl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Shinushaga Moisés mandushkada ama p'akingu nishalla, samana p'unllabish k'ari marada aicha karada p'itichijllagunadijka ¿ima nishadi samana p'unllabi shuj k'arida illujta alliyachishkallamunda Ñukan p'iñaringuichiri? ");
INSERT INTO qxl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Shinushaga <Shinamami gashkanga> nishallaga ama juchachichichu; ashtanbish juchachina gakiga ima laya gashkadadi alli rikusha juchachichiri,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chimunda Jerusalén pueblobi kausujkunamunda maijingunaga, “¿Wañuchingu mashkagushkaga nachu pai gan?” nigugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Rikichi, tukigunaj ñaubuki parlarigukish pish na imash ningandi. ¿Pai Cristo gashkada kabishkadichu mandujkunaga cringunashi?” ");
INSERT INTO qxl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Pai maimunda gashkada ñukuchiga yachunchimi, ashtanbish Cristo shamukiga maimunda gashkadash pish na yachungachu.” ");
INSERT INTO qxl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kai nishkagunada uyusha israelgunaj Diosbuj wasibi yachachigushaga Jesusga jinchidi parlarisha, “Shinadijka kangunaga Ñukadaga, ‘Rijsinchimi, maimunda gashkadash yachanchimi,’ ninguichimi. Ñuka munushkallamundaga na shamushkanichu, ashtanbish Ñukada Kachujka kabishkami gan, kanguna Paidaga na rijsishkanguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ñukagarin Pai kachushkamunda shinaidi Paimunda shamushka gashami Paidaga rijsini,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Shina nikiga prezu japingumi munugaguna; shinash Paibuj uras narij chayushkamundaga maijinbish Paida tupiidash na tupi pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Chi gentegunamundaga taugaguna Paida crishaga, “Cristo shamushaga, ¿kai k'ari rurushkadash yallichu pish na ruri pudishkagunada rurusha rikuchingachashi?” nisha ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Genteguna Jesusmunda shina washalla nigushkada fariseoguna uyusha paigunash manduj curagunash Diosbuj wasida chapujkunada Jesusta prezu japichun kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chimunda Jesusga, “Asha killagunaidami kangunan gasha, k'ipaga Ñukada Kachujbujmu rishallami. ");
INSERT INTO qxl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ñukada mashkunguichimi, shinash na japinguichichu. Ñuka maibi tiyanamunga kangunaga na ri pudinguichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chimunda manduj israelgunaga tapunukungu kallarishaga, “Ñukuchi na japi pudichundijka ¿maimushi paikuga ringashi? ¿Ñukuchipuramundaguna kaimunda risha griego llaktagunabi gajkunamuchu ringa? shinaidi ¿na israelgunamuchu yachachingu ringa imashi? ");
INSERT INTO qxl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Paiga, ‘Ñukada mashkunguichimi, shinash na japinguichichu, Ñuka maibi tiyanamunga kangunaga na ri pudinguichichu,’ nishaga ¿ima nishadi shina nin?” nisha kaishuj chaishuj ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pishta tukurij jatun p'unllami Jesusga shayarisha jinchida kaparishaga, “Maijin yakunachijka Ñukajmu shamusha ubiachun. ");
INSERT INTO qxl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Diosbuj Shimibi nishka shina, maijin Ñukada crijbuj ukumundaga kausida kuj yaku p'ugyuguna shinami llujshinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesusga kashna nishaga maijin Paida crijkunaga Diosbuj Espirituda japina gashkadami nisha niga; Jesusta k'uilla gashkada narij rikuchishkamundami, Diosbuj Espirituga narij shamushkaga. ");
INSERT INTO qxl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chi tauga gentegunamunda shujkunaga kai nishkagunada uyusha, “Paiga kabishkadimi Dios nishkada parluj shamuna nishka gan,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Shujkunaga, “Paiga Cristomi gan,” nigaguna, ashtanbish maijingunaga, “Na shinachugun, Cristoga ¿ima layadi Galileamunda gangari? ");
INSERT INTO qxl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diosbuj Shimibiga Cristoga Rey Davidbuj wawagunaj wawagunamundaminga, shinaidi Davidbuj pueblo Belenmundami shamunga nisha ¿nachu nin?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Shinushami genteguna Jesusmunda kaida chaida yuyasha partirigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Shujkunaga prezu japingumi munugaguna, shinash Paida tupidash na tupugagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chimunda Diosbuj wasida chapujkuna, manduj curagunajmu fariseogunajmu chayamuki, “¿Imashadi na pushamuganguichi?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Shina niki chi guardagunaga, “Pai k'ari parlushka layaga ima urash pish na parlushkachu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chimunda fariseogunaga, “¿Kangunadashchu pandachigachari?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Mandujkunamunda na gashaga fariseogunamunda maijinllash, ¿paida crishkacha? ");
INSERT INTO qxl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ashtanbish Moisés mandushkadash na yachuj gentegunaga Dios llakichichun nishkagunami gan.” ");
INSERT INTO qxl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Shina niki fariseo Nicodemoga shuj tuta Jesusta rikungu rijka paigunamu kashna niga: ");
INSERT INTO qxl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ñukuchida mandushkabi nishka shinaga shuj k'ari ima nishkada narij uyusha shinaidi ima rurushkadash narij yachushaidijka, imadash na juchachinallachunchi.” ");
INSERT INTO qxl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Shina niki paigunaga, “¿Kambishchu Galileamunda ganguiri? Diosbuj Shimida alli liyusha yachungui, chibiga Galileamundaga Dios nishkada parlujka shujllash shamunashkadaga na parlanchu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chimundaga tukigunami wasimu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Chigamaga Olivos urkumu Jesús riga. ");
INSERT INTO qxl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kayundij ña p'unllayaguki Diosbuj wasimu vueltuga. Tuki genteguna kuchuyaki Paiga tiyarisha yachachingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Moisés mandushkada yachachijkunash fariseogunash shuj warmi wainayagujta japisha pushamushaga tuki chibi gajkunaj ñaubuki churushaga, ");
INSERT INTO qxl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusmu, “Yachachij, kai warmidaga wainayagujtadimi japimunchi; ");
INSERT INTO qxl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés mandushkabiga shina warmigunadaga rumin pigusha wañuchichunmi mandun. Kanga, ¿imada ningui?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Paigunaga, pandariki juchachingu munushami kaidaga tapugaguna. Ashtanbish Jesusga kumurishaga achpabimi maki dedon escribingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Shina Paida tapusha katishkallamunda shayarishaga, “Kangunamunda maijin jucha illuj gashaga rumida pigusha kallarichun,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chimunda kutin kumurishaga achpa pambabi escribisha katigallami. ");
INSERT INTO qxl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Shina nijta uyushaga rukugunamunda kallarisha k'ipagunagamami shuj shuj ringu kallarigaguna; shinami chi chaubibi shayuj warmilla Jesuskunga sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chimunda Jesús shayarisha chi warmidaga, “Kanda juchachijkunaga, ¿maibidi gan? ¿Pish nachu juchachiga?” niki, ");
INSERT INTO qxl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","chi warmiga, “Manduj, pish na juchachishkachu,” niga. Chimunda Jesusga, “Ñukash na juchachinichu; kununga ri, ama ashtanga juchada rurunguichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kutinmi Jesusga gentegunamu, “Ñukami kai pachaj Luz gani; maijin Ñukada katijka yanamangabiga nalladi puringachu, ashtanbish kausida kuj Luztami charinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chimunda fariseogunaga, “Kanga kanllamundadimi yachi chayachingui; chi parlushkaga imakish na valinchu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Shina niki Jesusga kashna niga: “Ñuka Ñukallamundadi parlushka gashash Ñuka parlushkaga kabishkamigun, Ñukaga maimunda shamushkadash shinaidi maimu rigushkadash yachanimi; kangunaga Ñuka maimunda shamushkadash maimu rigushkadash na yachunguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kangunaga genteguna yuyushkallamundami juchachinguichi; Ñukaga pidash na juchachinichu. ");
INSERT INTO qxl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ñuka juchachishash kabishka juchachishkami gan. Ñukallaga na ganichu, ashtanbish Ñukada kachuj Taitami Ñukan juchachin. ");
INSERT INTO qxl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kangunajti mandushkabiga, ‘Ishkiguna ima rikushkada chilladadi yachi chayachikiga kabishkamigun,’ nisha escribishkami tiyan. ");
INSERT INTO qxl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ñukami Ñukallamundadi imadash yachi chayachini, Ñukada kachuj Taitash Ñukamunda yachi chayachin.” ");
INSERT INTO qxl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chimunda paigunaga, “¿Maibidi kambuj Taitaga tiyan?” niki, Jesusga, “Kangunaga Ñukadash, Ñukaj Taitadash na rijsinguichichu; Ñukada rijsishkashaga Ñukaj Taitadash rijsij ganguichimumiga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Israelgunaj Diosbuj wasibi, Diosmu kuchkida churana kuchubi yachachigushami kai shimigunadaga niga; Paibuj uras narij chayamushkamundaga pish na prezu japigachu. ");
INSERT INTO qxl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kutin Jesusga, “Ñukaga rishami, shinusha kangunaga Ñukada mashkunguichimi, ashtanbish kangunaj juchallabidimi wañunguichi. Ñuka rinamunga kangunaga na ri pudinguichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chimunda manduj israelgunaga, “ ‘Ñuka rinamunga na ri pudinguichichu,’ nigushaga, ¿pailladichu wañuringu munanshi?” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chimunda Jesusga, “Kangunaga uramundami ganguichi, Ñukaga jawamundami gani. Kangunaga kai pachamundami ganguichi, Ñukaga na kai pachamundachu gani. ");
INSERT INTO qxl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chimundadimi kangunamuga, ‘Kangunaj juchallabidi wañunguichi,’ nigani. Shinaidi ‘Ñukadimi gani,’ nishkada na crishaga kangunaj juchabimi wañunguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Shina niki paigunaga, “¿Kanga pidi gangui?” nigaguna. Shina niki Jesusga, “¿Imashadi kangunamunga parlashari? ");
INSERT INTO qxl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kangunada juchachisha tauga ninagunadashmi charini, shina gakish Ñukada Kachujka kabishkadami nin; shinaidi Ñuka Pai parlushkada uyushkallamundadimi kai pachamundagunamu chidadi nini,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ashtanbish paigunaga Taita Diosmunda parlashkadaga na intindigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Shinusha Jesusga, “Ima ura Aichayuj tukushka Churida cruzbi jawamu alzushami ‘Ñukadimi gani’ nijta Ñukadaga rijsinguichi, shinaidi imadash na Ñuka munushkallamunda rurushkada, ashtanbish Taita yachachishkagunaidami Ñuka parlashkada yachunguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ñukada Kachujka Ñukanmi gan; ima rurushkabish tuki ratu Paida kushichigushkamundami Ñukaj Taitaga Ñukalladaga na sakishkachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kaigunada nijta uyushaga taugagunami Paibi crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chimunda Jesusga Paibi crij israelgunada, “Kanguna Ñuka parlushkada kazusha kausagushaga, Ñukada katijkunadimi tukunguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Shinami Diosmunda kabishkada rijsinguichi, chi kabishkami kangunadaga kacharichinga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Shina niki, “Ñukuchiga Abrahambuj wawagunaj wawagunami ganchi, pibukish sirvichun randishka shinamaga ima urash na gashkanchichu. ¿Imashadi kanga ‘Kacharishkami ganguichi,’ ningui?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Shina niki Jesusga kashna niga: “Kabishkadadimi nini, maijinbish juchada rurujka, sirvichun randishka shina juchada rurungu watushka shinamigun. ");
INSERT INTO qxl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Maijin sirvichun randishkaga dueñoj wasibiga na tuki ratu kausagungallachu, ashtanbish churiga tuki ratumi taitaj wasibiga kausunga. ");
INSERT INTO qxl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Shinushaga Diosbuj Churi kangunada kacharichikiga, kangunaga kacharishkadimi ganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kanguna Abrahambuj wawagunaj wawaguna gashkadaga yachanimi; ashtanbish Ñuka parlushkada na japish nishallachu wañuchingu mununguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ñukaga Ñukaj Taita rikuchishkadami parlani, kangunash kangunaj taitamunda uyushkada ruranguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Shina niki paigunaga, “Ñukuchij taitaga Abraham-mi gan,” nigaguna. Jesusga, “Kanguna Abrahambuj wawagunaj wawagunadi gashkashaga Abraham rurushka layaidimi rurunguichimuga. ");
INSERT INTO qxl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ashtanbish Dios yachachishkada uyusha kabishkadi shimigunada kangunamu parluj gakish kangunaga Ñukada wañuchingumi mununguichi. ¡Abrahamga ima urash shinaga na rurugachu! ");
INSERT INTO qxl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kangunagarin kangunaj taita rurushka layaidimi rurunguichi,” niga. Shina niki, “Ñukuchiga wainayasha charishka churigunaga na ganchichu; shuj Taitalladami charinchi. Paiga, ¡Diosmi gan!” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chimunda Jesusga, “Kangunaj Taita, Dios gashkakiga Ñukada k'uyanguichimumiga; Ñukaga Diosmunda shamushami kaibi gani. Ñukaj munimundaga na shamuganichu, ashtanbish Diosmi Ñukadaga kachuga. ");
INSERT INTO qxl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ñuka parlushkada ¿imashadi na intindi pudinguichi? Ñuka nish nigushkada naidi uyush nishallami shina ganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kangunaj taitaga diablomi gan; paibuj gashami pai munushkada rurungu mununguichi. Paiga kallarimunda pachami wañuchij gashka; paibuki ima kabishkash illushkamundaga, imadash ima urash kabishkadaga na parlujchu. Paiga llagmaidi shinaidi llagmagunaj taitash gashkamunda, imada llagmusha parlushash paillamundadi parlan. ");
INSERT INTO qxl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ñukadaga, kabishkada parlagushkamundaga na cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kangunamunda, ¿maijindi Ñuka ima juchada rurashkada rikuchi pudinguichi? Shina kabishkada parlukidijka ¿imamundadi na cringuichiri? ");
INSERT INTO qxl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maijinsh Diosbuj gashaga, Diosbuj Shimigunadami uyun; shinushaga kangunaga na Diosbuj gashkamundami na uyush ninguichi.” ");
INSERT INTO qxl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Shina niki israelgunaga Jesustaga, “ ‘Kanga yana katishka Samariamundami gangui,’ nishaga, ¿ñukuchiga nachu allida nishkanchi?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chimunda Jesusga, “Ñukaga na yana katishkachu gani. Taitadami allibi churuj gani, ashtanbish kangunaga Ñukadaga na allibimi churanguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Shinash Ñukaga Ñukada jatunyachichunga na mashkanichu. Shujmi jatunyachichun mashkujka tiyan, Paimi kabishkadi juchachij gan. ");
INSERT INTO qxl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kabishkadadimi nini, Ñuka parlushkada maijin kazujka ima urash na wañungachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Shina niki israelgunaga, “Kununmi allidijka yana katishka gashkadagarin yachanchi. Abrahambish, Dios nishkada parlujkunash wañushkami, shinash kanga, ‘Ñuka nishkada kazujka ima urash na wañungachu,’ ningui. ");
INSERT INTO qxl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ñukuchij taita Abrahamga wañugami. Kanga Abrahamdash ashtan yallichuma ¿imadi gangui? Dios nishkada parlujkunash wañugami. ¿Pi gashkadadi kanga yuyanguiri?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chimunda Jesusga kashna niga: “Ñukada Ñukaidi jatunyachishaga Ñuka jatunyashkash imakish na valinchu. Ñukada jatunyachijka Ñukaj Taitalladimigun; Pailladadimi kangunaga <Ñukuchij Diosmi> ninguichi. ");
INSERT INTO qxl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ashtanbish kangunaga Paidaga na rijsinguichichu, Ñukagarin Paida rijsinimi. <Na rijsinichu> nishadijka kanguna laya Ñukash llagmami ganimu. Ñukaga Paidaga rijsinidimi, shinaidi Pai parlushkada kazuni. ");
INSERT INTO qxl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kangunaj ñauba taita Abrahamga Ñuka shamuna p'unllada <Rikushami> yuyusha kushiyaga, rikushagarin ashtanmi kushiyaga.” ");
INSERT INTO qxl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Shina niki israelgunaga, “Narij pichka chunga (50) watada charishash ¿Abrahamda rikuganguichari?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chimunda Jesusga, “Kabishkadadimi nini, narikish Abraham tiyajllabidimi Ñukadimi gagani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chimunda paigunaga Jesusta rumigunan pigungu japigaguna, ashtanbish Jesusga mitikusha israelgunaj Diosbuj wasimunda llujshisha riga. ");
INSERT INTO qxl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús rigushami wacharishkamundadi cigu k'arida rikuga. ");
INSERT INTO qxl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Paibuj yachagujkuna, “Yachachij, ¿imashadi kai k'ariga na rikuj wacharishka? ¿Paibuj yayungunaj juchamundachu, na gashaga paibuj juchallamundadichu shina tukushkanga?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Shina niki Jesusga, “Na paibuj juchamunda, na paibuj taita mamaj juchamundashchu; ashtanbish Dios ima ruri pudishkaguna paibi rikurichunmi shina wacharishka. ");
INSERT INTO qxl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","P'unlla gajllabidi Ñukada Kachujbuj mandashkagunadaga ruranalladi ganchi. Ñami tutayamugun. Chibimi pish imadash na ruri pudinga. ");
INSERT INTO qxl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ñuka kai pachabi purishkagamallami, kai pachaj Luz shina gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kashna nishka k'ipaga achpabi t'iukusha, t'iukan lododa rurusha, chi lodon na rikuj ñawigunabi llutachishaga, ");
INSERT INTO qxl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Siloé yaku tandarishka kuchabi maillungu ri,” niga. (Siloé nishaga <Kachushka> nishami nin). Shina niki na rikujka chimu risha maillarishaga ña rikujmi shamuga. ");
INSERT INTO qxl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chimundaga pai kuchkida mañujta sarun rikujkunash, kuchullabi kausujkunash, “¿Nachu kaikuga kuchkida mañusha tiyuj gan?” nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Maijingunaga, “Ari, paimigun,” nigaguna. Kutin kaishujkunaga, “Na paichu gan, shinash paimu rijchujmi,” nigaguna. Shina niki paiga “Ari, ñukaidimi gani,” nisha nigugallami. ");
INSERT INTO qxl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chimunda, “¿Ima layadi kununga riki pudingui?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","paiga, “Jesús nishka k'arimi lododa rurusha ñawibi llutachisha, ‘Siloé yaku tandarishka kuchabi maillungu ri,’ nikiga rigani. Ña maillushaga riki pudiganillami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Shina niki paigunaga, “¿Pai k'ariga maibidi gan?” nisha tapuki, “Na yachanichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chimunda chi alliyashka k'aridaga fariseogunajmu pushugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús lododa rurusha ñawida alliyachibiga samana p'unllamiga. ");
INSERT INTO qxl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Shinusha kutinmi ima laya rikuj tukushkada fariseogunaga tapugaguna. Paiga, “Jesús lododa ñawibi churushka k'ipa maillarishaga ña rikuj tukuganillami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chimunda maijin fariseogunaga, “Samana p'unllada chi k'ari na kazushtijka na Diosmunda shamunchu,” nigaguna. Kutin kaishujkunaga, “Juchayuj gashkashaga, ¿ima layadi pi na ruri pudishkagunadaga kashna ruri pudinmugari?” nigaguna. Shinami paigunapura kaida chaida ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Shinusha chi ña rikuj tukushka k'aridaga kutin, “Kanga kambuj ñawida rikujta rurujmundaga, ¿imada ningui?” nisha tapuki, “Dios nishkada parlujmigun ninimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Shinash manduj israelgunaga na rikuj gashkadaga, shinaidi kutin rikuj tukushkadash na crigagunachu. Ashtanbish rikuj tukushkaj taita mamada kayushaga, ");
INSERT INTO qxl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“¿Paichu kanguna, ‘Na rikujmi wacharishka,’ nigushka kangunaj churi gan? Shinadijka, ¿ima layadi kununga rikuj ganri?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Shina niki taita mamaga, “Ñukuchij churi gashkada, shinaidi na rikuj wacharishkadash yachanchimi; ");
INSERT INTO qxl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","shinash ima laya rikuj tukushkada na yachunchichu, pi ñawigunada rikujta rurushkadash ñukuchikish na yachunchichu. Pailladadi tapichilla, ñami wataguna p'aktushka gan; pailladi ima laya gashkadash parlungallami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maijinbish Jesusta <Cristomi> nijtaga Diosmunda yachana wasimunda llujshichisha kachungu, manduj israelguna ña parlanukushkada yachusha manchushkamundami paibuj taita mamaga shina niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chimundami taita mamaga, “Pailladadi tapichilla, ñami watagunash p'aktushka gan,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Shinusha na rikuj alliyashka k'arida israelguna kutin kayushaga, “Chi k'ariga juchayuj gashkadaga ñukuchiga yachanchimi, shinushaga Diosbuj ñaubuki kabishkada parli,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chimunda paiga, “Juchayuj gashkakish ñukaga na yachanichu, ñuka na rikuj gashash kununga rikuj gashkaidami yachani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Paigunaga kutinlladi, “¿Imadadi kandaga ruruga? ¿Ima rurushadi rikujta ruruga?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","paiga, “Ña niganindi, na uyush nishkanguichichu. ¿Imashadi kutin parlachun ninguichi? ¿Kangunashchu paida katij tukush ninguichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Shina niki, “Kanchari pai k'arida katijma imash gangui. Ñukuchiga Moisestami katij ganchi,” nisha paida rimagaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Moisesmu Dios parlushkadaga yachanchimi, ashtanbish chikudaga maimunda gashkadash na yachanchichu,” nisha nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Shina niki chi k'ari paigunadaga, “Ñukadaga ñawida rikujta rurukish, kangunaga pai maimunda shamushkadash na yachungudijka ima layashigunshi. ");
INSERT INTO qxl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Paida manchujkunaida Pai munashkada rurajkunaida Diosga uyaj gashkada ashtanbish juchayujkunadaga na uyaj gashkadaga allimi yachanchi. ");
INSERT INTO qxl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Shinaidi ñukada rurushka shina na rikuj wacharishkada rikujta rurushka nishkadaga pimundash ima urash na uyushkanchichu. ");
INSERT INTO qxl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pai k'ari na Diosmunda shamushkashaga imadash na ruri pudinmuchuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chimunda paigunaga, “Kan juchasapaidi wacharishkakuchu ¿ñukuchida yachachinguiri?” nishka k'ipaga Diosmunda yachana wasimunda llujshichisha kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chi k'arida llujshichisha kachushkada Jesús yachushaga paida mashkusha ña tupanukushaga, “¿Aichayuj tukushka Churibi cringuichu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chi k'ariga, “Hijo taita, Paibi cringujka Paiga pidikun parlabai,” niki, ");
INSERT INTO qxl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusga, “Ña rikushkanguimi, kangun parlarijlladi Ñukaidimi gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chimunda chi k'ariga Jesusbuj ñaubuki kungurishaga, “Manduj, crinimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chi k'ipa Jesusga, “Ñukaga juchayujkuna gashkada rikuchingu, na rikujkunaga rikuj gachun, shinaidi rikujkunaga na rikuj tukuchunmi kai pachamunga shamugani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Paigun gaj fariseoguna shina nijta uyushaga, “¿Ñukuchikish shinadijka na rikujkunachu ganchiri?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Shina niki Jesusga, “Kanguna na rikujkuna gashkashaga juchamunda na kauzayuj ganguichimuchuga; ashtangarin <Rikujmi ganchi> nishkamundaga juchaguna kangunaj jawabi gagungallami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Chimunda Jesusga kashna niga: “Kabishkadadimi nini, maijinbish ovejagunaj currulmu na punguda waigushalla maidash sikusha waigujka shuwajmi, shinaidi uyi na uyidi takusha shuwajmi gan. ");
INSERT INTO qxl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ashtanbish punguda waigujka ovejagunada michijmi gan. ");
INSERT INTO qxl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chi michijmu punguda chapuj paskuki, michijka paibuj ovejagunada paigunaj shutin shutin kayuki paigunaga paibuj shimida rijsinllami. Currulmundash paimi llujshichin. ");
INSERT INTO qxl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ña tuki paibuj ovejagunada llujshichishaga michijka paigunada ñaubushami rin; shinami ovejagunaga paibuj shimida rijsishkamundaga katinguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ashtangarin na rijsishkadaga nalladi katingachu; shujbuj shimida na rijsishkamundami paimundaga mitikusha ringaguna.” ");
INSERT INTO qxl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kai yuyachinan Jesús parlakish paigunaga ima nisha nigushkadash na intindigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Shinushaga kutinlladi Jesusga, “Kabishkadadimi nini, Ñukaga ovejagunaj waiguna pungumi gani. ");
INSERT INTO qxl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ñukada ñaubusha tuki shamujkunaga shuwaguna, uyi na uyidi takusha shuwajkunamiga; shinash ovejagunaga paigunada na uyush nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ñuka pungumi gani; maijin Ñukamunda waigujka kishpichishkami ganga. Shuj oveja layami waigusha llujshisha shinaidi mikuna muyadash japingami. ");
INSERT INTO qxl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Maijin shuwa shamushaga wañuchingu, shuwangu, tukuchishtangajllami shamun; ashtanbish Ñukaga kanguna na tukurij kausida charichun shinaidi chi kausida charishash yallimanaidi charichunmi shamugani. ");
INSERT INTO qxl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ñukaga alli michijmi gani. Alli michijka kikinbuj kausidash ovejagunamunda kujmi. ");
INSERT INTO qxl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kuchkida paganallamunda michijka, na michijti gashkamunda shinaidi na paibuj oveja gashkamundaga lobo shamujta rikushash ovejagunada sakisha shujllami mitikusha rin; chibimi loboga ovejagunada japishaga kani kani rurusha kaida chaida kachun. ");
INSERT INTO qxl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chi michijka pagushkallamunda michishkamundaga ovejaguna imash tukuchun nishami shitusha rin. ");
INSERT INTO qxl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ñukaga alli michijmi gani. Ima layami Ñukaj Taita Ñukada rijsin Ñukash Taitada rijsini; shina layaidimi Ñukaga Ñukaj ovejagunadaga rijsini, paigunash Ñukada rijsingunami. Shinushami Ñukaj kausida ovejagunamunda kuni. ");
INSERT INTO qxl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Shinaidi na kai currulmunda shuj ovejagunadashmi charini, chigunadash pushamunami gani; paigunaga Ñuka parlashkadaga uyangagunami, shinami kanllalladi shujlla tukusha shuj michijllada charingaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ñukaj kausida kutin japingumi kuni. Chimundami Taitaga Ñukada k'uyun. ");
INSERT INTO qxl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ñukaj kausidaga pish na kichunchu, Ñukaj munillamundadimi Ñukaga kuni. Ñukaj kausida kungajkish kutin japingajkish Ñukaga pudinimi. Shina rurachunmi Ñukaj Taitaga manduga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kai shimigunamundami israelgunaga kaida chaida yuyasha kutin rimanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Paigunapuramunda taugagunami, “Yana katishka gashami paiga loco gan. ¿Imashadi kazu ruranguichi?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kutin shujkunaga, “Kai shimigunaga na yana katishkajchu gan; ¿shuj yanaga na rikujtaga rikujta ruri pudinchari?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalenbimi Diosbuj wasida Diosllamu linshuyachishkada yuyarisha pishtada ruragaguna. Tamia shinaidi chiri killagunami gaga. ");
INSERT INTO qxl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesusga Diosbuj wasibi gashami Salomonbuj nishka Corredorbi puriguki, ");
INSERT INTO qxl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","israelguna muyundijta shayarishaga, “¿Ima uragamadi kaida chaida yuyarichun chapachisha ninguiri? Kan Cristo gashaga ashtan laruda parlillari,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Shina niki Jesusga kashna niga: “Ñami kangunamu nigani, shinash na cringuichichu. Ñukaj Taitaj shutibi rurushkagunami laru rikuchigungandi. ");
INSERT INTO qxl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Shina gakish kanguna na Ñukaj ovejaguna gashkamundami na cringuichi. ");
INSERT INTO qxl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ñukaj ovejagunaga Ñuka parlashkada uyajkunami, shinaidi paigunada rijsinimi, shinami Ñukada katinguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ñukami paigunamuga na tukurij kausida kuni; shinusha ima uragamash na chingaringagunachu, shinaidi Ñukaj makimundaga pish na kichungachu. ");
INSERT INTO qxl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ñukamu kuj Ñukaj Taitaga tukimunda yalli jatunmi, Ñukaj Taitaj makimundaga pish na kichi pudingachu. ");
INSERT INTO qxl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ñukash Taitash shujllami ganchi.” ");
INSERT INTO qxl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Israelgunaga kutinmi paidaga rumigunan pigungaj japigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chimunda Jesusga, “Taitaj podergunmi tauga alli ruranagunada kangunaj ñaubuki rurusha rikuchishkani; ¿chigunamundaga maijinmundadi rumida pigush ninguichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Shina niki israelgunaga, “Allida rurushkamundaga na rumin pigush ninchichu, ashtanbish kan Diosta imakish na valichisha parlashkamunda; kan gente gashash kanlladi Dios tukush nishkamundami rumin pigush ninchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Shina niki Jesusga kashna niga: “¿Nachu kangunamu mandushkagunabiga Dios escribichisha, ‘Ñukaga “dioskunami ganguichi” ninimi,’ nishka tiyan? ");
INSERT INTO qxl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Diosbuj Shimi nishkadaga <Na shinachugun> ningujka na pudinachugun. Maijingunamu Dios parlushkada uyujkunadaga Diosga, ‘dioskunami ganguichi,’ nikidijka, ");
INSERT INTO qxl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Taita Dioslladimi Paibujlla gachun ch'ikunyachisha kai pachamu kachushkadaga, ‘Diosbuj Churimi gani,’ nishkallamundachu Ñukadaga, ‘Diosta imakish na valichin,’ ninguichiri? ");
INSERT INTO qxl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ñukaj Taita rurushkagunada laya Ñuka na rurukiga ama cringuichichu. ");
INSERT INTO qxl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ashtanbish Taita rurushka laya rurakiga Ñukada na crishash Ñuka rurushkagunalladash crichiri; shina crishallami Ñukaj Taita Ñukabi gashkada shinaidi Ñukash Paibi gashkada ashtan illujta alli yachunguichimu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kutinlladimi paigunaga Jesusta prezungu munugaguna, shinash Jesusga paigunaj makimunda kachachirishami riga. ");
INSERT INTO qxl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Shinami Jesusga maibi sarun Juanchu bautizasha purishka Jordán yaku ch'imbamu kutin risha chibimi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tauga genteguna Paibuj kuchumu chayushaga, “Kabishkadadimi Juanchuga pish na ruri pudishkadaga ima urash na ruragachu, shina gakish kai k'arimunda tuki nishkagunaga kabishkami gashka,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Shinami chibiga taugaguna Jesusta crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania pueblomunda Lázaro shuti k'arimi ungushka kausaga; paibuj pani Mariash, Martash chillamundadimiga. ");
INSERT INTO qxl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Chi ungushka Lazaroj pani Marialladimi Manduj Jesusbuj chakibi k'uilla ashnariguj yakuda tallisha juakchan chakichiga.) ");
INSERT INTO qxl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Shinushaga chi ishki ñañundijkunami, “Manduj, kan k'uyashka Lazaroga ungushkamigun,” nisha Jesusmu parlachun kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Shina nijta Jesús uyushaga, “Kai unguiga na wañuchingabujchu, ashtanbish Diostash, Diosbuj Churidash <Alli k'uillami gangui> nichunmi shina tukushka,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusga Martadash, paibuj ñañadash, Lazarodashmi k'uyajkuga. ");
INSERT INTO qxl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázaro ungushkada yachi chayushash ishki p'unlladami maibi gashkallabidi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chi k'ipa Paibuj yachagujkunada, “Kutin jakuchi Judea llaktamu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Shina niki Paibuj yachagujkunaga, “Yachachij, chibi gaj israelguna rumigunan pigusha wañuchingu munushkaga na uningandi. ¿Shinashchu kutinlladi chimu rish ninguiri?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesusga, “¿Nachu shuj p'unllaga chunga ishki (12) urasta charinri? Shinushaga maijinsh p'unllapachabi purishaga, kai pachada p'unllayachijta rikushkamundaga imabish na trankarisha urmangachu. ");
INSERT INTO qxl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ashtanbish maijinsh tutabi purijka luz paibuki illushkamundaga trankarisha urmangallami.” ");
INSERT INTO qxl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Shina nishka k'ipa Jesusga, “Ñukuchin alli apanukuj Lazaroga puñurishkami; shinash rijchachingu rinimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chimunda Paibuj yachagujkunaga, “Manduj, puñurishkamundaga alliyangami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesusga Lázaro wañushkamundami shina niga, ashtanbish Paibuj yachagujkunaga <Puñurishkallamundami shina nigushkanchin> yuyugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Shinushami Jesusga paigunada, “Lazaroga wañushkami,” nisha laruda niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","“Ñuka na chibi gashkamunda kushiyanimi, kanguna crichunga shinami alli gashka. Ashtanbish paibujmu jakuchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chimunda Ishkipura Wacharishka nishka Tiumaga, kaishuj yachagujkunadaga, “Ñukuchish Jesuskun wañungu jakuchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús chayushaga Lázaro ña chusku p'unllada pambana ut'kubi churushkadami japiga. ");
INSERT INTO qxl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania puebloga Jerusalenmunda kinsa kilómetro vali kuchullabimi gaga. ");
INSERT INTO qxl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tauga judeamundagunami Martada Mariadash <turi wañushkamunda ñukuchikish llakirinchimi> ningu shamushkagunaga. ");
INSERT INTO qxl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martaga Jesús shamugushkada yachushaga tupanukungumi llujshisha riga. Ashtanbish Mariaga wasibimi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martaga Jesusta, “Manduj, kan kaibi gashkakiga ñukaj turiga na wañunmuchuga; ");
INSERT INTO qxl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ashtanbish Diosta kan ima mañushkadash kununbish kanmu Pailladi kuna gashkadaga ñukaga yachanimi,” niki, ");
INSERT INTO qxl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusga, “Kambuj turiga kausaringami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Shina niki Martaga, “Ari, wañushkaguna kausarina tukurij p'unllabi kausarinadaga yachanidimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesusga paidaga, “Ñukami wañushkagunada kausachijkish, kausida kujkish gani; maijin Ñukada crijka wañushka gashash kausangami. ");
INSERT INTO qxl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Shinaidi tuki Ñukada crisha kausujkunaga ima uragamash na wañungachu, ¿kaigunadaga cringuichu?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Shina niki Martaga, “Ari, Manduj; Kan Cristo shinaidi Diosbuj Churi gashkada, Kan kai pachamu shamuna gashkadash ñukaga crinimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Shina nishka k'ipaga Martaga paibuj ñaña Mariada kayungu risha pakalla kashna niga, “Yachachijka kaibimi gan, kanda kayagunmi.” ");
INSERT INTO qxl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Shina nijta uyunmi Mariaga apuruidi jatarisha Jesusta rikungu riga. ");
INSERT INTO qxl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesusga narij pueblomu waigushkachuga, chairijtij Martan tupanukushka pushtullabidimiga. ");
INSERT INTO qxl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María apuruidi jatarisha rijta rikusha <llakirinchimi> nisha wasibi paigun igulda gaj Judeamundaguna <Pambushka ut'kumumi wakungu rinchin> yuyusha washa katigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesús maibi gashka pushtumu María chayushaga Paibuj ñaubuki kungurisha, “Manduj, kan kaibi gashkakiga ñukaj turiga na wañunmuchuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Shina María wakajta, paigun igulda chayuj israelgunash wakajta Jesús rikushaga shungundijta manchanaidi llakirishaga, ");
INSERT INTO qxl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“¿Maibidi churaganguichi?” nisha tapuki, paigunaga, “Manduj, jaku rikungu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chibi Jesús wakuga. ");
INSERT INTO qxl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chimundami israelgunaga, “Rikichi, manchanaidimi Lazaroda k'uyashka,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ashtanbish shujkunaga, “Na rikuj k'arida rikujta rurujtika, ¿Lázaro ama wañuchunga nachu imaidash ruri pudishkangari?” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús shungundijta kutin llakilladimi pambushka ut'kumu kuchuyaga. Chi ut'kuga k'akabi kinrimu ut'kusha shuj rumin tapachishkamiga. ");
INSERT INTO qxl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chibi Jesusga, “Rumida anchuchichi,” niki, wañushkaj pani Martaga, “Mandujlla, pai wañushkaga ñami chusku p'unllagun, ña ashnarigungami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesusga, “ <Kan crishaga Dios ima allidash rurujlla gashkada rikunguimi> nisha ¿nachu kanda nigani?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chimunda rumida anchuchiki Jesús jawa pachada rikushaga kashna niga: “Taitalla, Ñuka mañushkada uyushkamunda <Diosolopai> nini. ");
INSERT INTO qxl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ñuka mañushkada Kan jursa uyuj gashkadaga yachanimi; ashtanbish kaibi gaj genteguna Kan Ñukada kachushkada crichunmi kaidaga nini.” ");
INSERT INTO qxl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Shina nishka k'ipaga, “¡Lázaro, washamu llujshi!” nisha jinchida kapariki, ");
INSERT INTO qxl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","chi wañushkaga makida chakidash llikishka linsun pilluchishka, ñawidash illujta linsun pilluchishka llujshiga. Chimunda Jesusga, “Pilluchishkada kanguna paskusha richun sakichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Shinushami Mariagun igulda gangu shamuj israelgunamunda taugaguna Jesús ima rurushkada rikusha Paida crigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Shinash paigunapuramunda maijingunaga fariseogunajmu rishaga Jesús imada rurushkadami parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chimunda manduj curagunash, fariseogunash, israelgunada mandujkunapura tandanukushaga kashna nigaguna: “¿Imadadi rurashun? Kai k'ariga tauga pish na ruri pudishka rikuchinagunadami ruragun. ");
INSERT INTO qxl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Paida shinalla sakikiga tukigunami paida cringaguna; shinushaga Romamundaguna shamusha ñukuchij Diosbuj wasida, ñukuchij pueblodashmi illujta tukuchishtunga.” ");
INSERT INTO qxl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Shina niki paigunapuramunda chi watabi jatun manduj cura Caifás shutiga, “Kangunaga imadash na yachunguichichu; ");
INSERT INTO qxl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","kai tuki pueblo tukuchishtashka gana randiga shuj k'arilla tukigunamunda wañuna gashkaga kangunaj allibujmigun; chidaga na intindinguichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifasga kaidaga na paibuj yuyillamunda nigachu. Pai chi watabi jatun manduj cura gashkamunda Dios yuyida kukimi israelgunamunda Jesús wañuna gashkadaga parluga. ");
INSERT INTO qxl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na chi pueblollamundash, ashtanbish kaibi chaibi kausuj Diosbuj wawagunash shujlla tukuchun tandachingajmi shina wañuna gashka. ");
INSERT INTO qxl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Shina ninukushka p'unllamundami manduj israelgunaga Jesusta wañuchingu ari ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Shina gakimi Jesusga Judeagunapurabiga ima laya purishka shina ña na puriga; ashtanbish chi Judea llaktamunda llujshisha shitashka pushtu kuchullabi gaj Efraín shuti pueblomu riga. Chibimi Paibuj yachagujkunandi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israelgunaj Pascua pishtaga ña kuchubimiga, pueblogunamunda tauga gentegunami narij Pascua pishta chayujllabidi Diosbuj ñaubuki linsharingaj Jerusalenmu ichiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chibimi Jesusta mashkusha purisha Diosbuj wasi pungubi gasha randi randi, “¿Imada ninguichi? ¿Pishtamu shamungachuma imashi?” nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Manduj curaguna, fariseogunash, Jesús maibi gashkada maijin yachushaga prezu japingaj parlachun nisha mandushkagunaga. ");
INSERT INTO qxl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chimunda Pascua pishtaj sujta p'unlla jualtagukimi Jesusga Pai kausachishka Lázaro kausashka Betania pueblomu riga. ");
INSERT INTO qxl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chibimi Jesús shamushkamunda mikunada ruragaguna. Martaga mikunada karaguga; Jesuskun mizabi mikusha tiyajkunapurabi shujka Lazaromi gaga. ");
INSERT INTO qxl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chimunda Mariaga nardo yuramundadi rurushka imanbish na chagrushka manchanaidi valij k'uilladi ashnariguj yakuda chaubi litro shinada apamusha Jesusbuj chakibimi tallisha k'akuga. Chi k'ipa paibuj juakchanmi chakichiga; shinami wasi ukuga illujta ashnarigujti k'uidi tukuga. ");
INSERT INTO qxl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chimunda Jesusbuj yachagujkunamunda Jesusta k'ipalla japichingu gaj Judas Iscariotega, ");
INSERT INTO qxl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imashadi kai k'uilla ashnariguj yakudaga na kinsa patsuj (300) denario kuchkibi k'atusha imadash na charijkunamu kugashi?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kaidaga imadash na charijkunada llakirishkamundaga na nigachu, ashtanbish shuwa gashkamunda, pai kuchki bolsada wakichij gasha chibi churashkada asha asha shuwajlla gashami shina niga. ");
INSERT INTO qxl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chimunda Jesusga, “Sakilla, Mariaga Ñukada pambana p'unllajmi chidaga wakichigushka. ");
INSERT INTO qxl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Imadash na charijkunadaga jursami kangunan charigunguichilla, ashtanbish Ñukadaga na jursa charigunguichillachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús Betania pueblobi gashkada yachushami tauga israelguna chimu rigaguna, na Jesusta rikungajllaga ashtanbish Jesús kausachishka Lazaroda rikungajkishmi rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lázaro shina tukushkada rikusha tauga israelguna manduj curagunamunda ch'ikunyasha Jesusta cringu kallarigaguna. Chimundami manduj curagunaga Lazarodash wañuchingu ari ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tauga gentegunami Pascua pishtajka Jerusalenmu rishkagunaga. Jerusalenmu Jesús shamunada paiguna kayundij p'unlla yachusha, ");
INSERT INTO qxl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","palmera ramagunada p'itisha Jesuskun tupungaj llujshishaga, “¡Hosana! ¡Manduj Diosbuj shutibi Shamuj, Israelgunada Jatun Manduj alli nishka gachun!” nishami kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesusga shuj malta burruda japisha sikushka shamuga, Diosbuj Shimibi kashna nishka shina: ");
INSERT INTO qxl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sión pueblobi kausujkunalla, ama mancharichichu; rikichi, kangunaj Jatun Mandujka shuj malta burrubimi sikushka shamugun.” ");
INSERT INTO qxl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kallarimunga Jesusbuj yachagujkunaga ima tukugushkadash narij intindigagunachu. Ashtan Jesús kausarishka k'ipami, kai tuki Paida rurashkagunaga ñaubamundadi Paimunda escribishka tiyashkadami cuenta kugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pambushka Lazaroda Jesús kayusha kausachijta rikusha Paigun gaj gentegunaga ima tukushkadami tukigunamu parlagaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Shinusha kai pish na ruri pudishkada rurusha rikuchishkada yachi chayushami, chi tauga gentegunaga Jesuskun tupungaj llujshiga. ");
INSERT INTO qxl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chimundami fariseogunaga kaishuj chaishuj, “Ñukuchi imada rurungu munashash imadash na rurushkadaga, kangunaidi ña rikunguichimi. Rikichi, tukiguna Paillada katisha ringuna,” nisha ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua pishtabi Diosta <Allimi gangui> ningu Jerusalenmu rijkunapuramundaga shuj griegogunashmi puriga. ");
INSERT INTO qxl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paigunaga Galilea llaktabi tiyaj Betsaida pueblomunda gaj Felipejmu kuchuyashaga, “Hijo Taita, Jesuskunmi parlaringu munanchi,” nisha mañuki, ");
INSERT INTO qxl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe rishaga Andikumu parluga. Chimunda Felipesh Andikush Jesusmumi parluga. ");
INSERT INTO qxl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Shina niki Jesusga kashnami niga: “Kununmi Aichayuj tukushka Churida k'uilladi gashkada rikuchina uraska ña chayushka. ");
INSERT INTO qxl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kabishkadadimi kangunada nini, trigo muyu na pambabi urmusha wañushaga, chi muyuidimi sakirin; ashtanbish wañushaga manchanaidimi granuda apan. ");
INSERT INTO qxl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Maijin kikinbuj kausida k'uyajka chingaringami; maijin kikinbuj kausida kai pachabi na llakirijka tuki ratu kausanadami wakichinga. ");
INSERT INTO qxl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maijin Ñukada sirvish nijka Ñukada katichun; shinaidi maibi Ñuka gashkabimi paibish ganga, shina maijinsh Ñukada sirvijtaga Ñukaj Taitaga allibimi churanga.” ");
INSERT INTO qxl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kunun kai ratu Ñukaga llakilladimi gani. ¿Imadadi nisha? ‘Taitalla, kai llakimundaga anchuchibairi,’ nisha ¿nishachu? ¡Kaigunada p'aktachingujlladimi kai uraska Ñukaga shamugani! ");
INSERT INTO qxl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taita, Kan k'uilladi gashkada rikuchibairi.” Shina niki, “Ñami k'uilladi gashkada rikuchishkani, shinaidi kutinbish rikuchishami,” nisha parlarishka jawa pachamunda uyariga. ");
INSERT INTO qxl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chibi gaj genteguna uyashaga, “Relampami gulun mandushka,” nigaguna; kutin shujkunaga <Shuj angelmi Paigun parlarishka> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chimunda Jesusga, “Chi parlarishkaga na Ñukaj allibuj uyarigachu, ashtanbish kangunaj allijmi uyariga. ");
INSERT INTO qxl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kai pachada juchachishka ganaga ñami chayamushka, kununmi kai pachada manduj diablodaga llujshichishtashka ganga. ");
INSERT INTO qxl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ashtanbish Ñuka kai pachamunda jatarichishka gashaga tukigunadami Ñukajmu pushasha,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Kaida nishaga Pai ima laya wañuna gashkada yachi chayachisha nishami shina niga.) ");
INSERT INTO qxl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chimunda gentegunaga kashna nisha tapugaguna: “Mandushkagunabi nishkada uyushami tuki ratugama Cristoga kausana gashkadaga yachuganchi. ¿Imamundadi, ‘Aichayuj tukushka Churiga jatarichishkami ganga,’ nishaga ninguiri? Chi Aichayuj tukushka Churiga, ¿pidi gan?” ");
INSERT INTO qxl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Shina niki Jesusga, “Asha p'unllagunaidami Luzga kangunan ganga. Shinushaga yanamanga kangunada ama kunguida japichunga chairijti Luzta charishkamundaga Luzbi purichi; maijinsh yanamangabi purijka maimu rigushkadash na yachunchu. ");
INSERT INTO qxl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chi Luzbuj gangujka Luz kangunan gashka ratuidi Luzbi crichi,” niga. Kaigunada nishka k'ipaga Jesusga risha paigunamunda mitikuga. ");
INSERT INTO qxl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Paigunaj ñaubuki taugaidi pish na ruri pudishkagunada Jesús rikuchigukish Paida na crigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dios nishkada parluj Isaías kashna escribishka p'aktachunmi shina tukuga: “Manduj, ñukuchi parlushkadaga ¿pidi crishkari? Manduj Diosga Paibuj poderdaga ¿pimundi yachi chayachishka?” ");
INSERT INTO qxl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Shina nishkamundami na cri pudigaguna, Isaiasga kaida escribishkamundash: ");
INSERT INTO qxl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Diosmi paigunaj ñawidash ichkushka paiguna ama rikuchun; shungudash jinchida rurushka ama intindichun; ama Ñukajmu shamuchun shinaidi Ñuka ama alliyachingaj.” ");
INSERT INTO qxl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiasga Jesús k'uilladi gashkada rikusha Paimunda parlashkamundami kaidaga niga. ");
INSERT INTO qxl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Shina gakish israelgunada mandujkunapuramundash taugaguna Jesusta crigaguna, ashtangarin fariseogunada manchushami Diosmunda yachana wasimunda ama llujshichisha kachachun, crishkadaga tukigunamunga na yachi chayachijkunachuga. ");
INSERT INTO qxl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Paigunaga Dios <Alli> nishka gangu munashash yalliga genteguna <Alli> nishka ganada munushkamundami na parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chimunda Jesusga jinchida kaparisha, “Maijinbish Ñukada crijka na Ñukallada crinchu, ashtanbish Ñukada Kachuj Taitadashmi crin. ");
INSERT INTO qxl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Shinaidi maijin Ñukada rikujka Ñukada Kachujtashmi rikun. ");
INSERT INTO qxl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ñukaga Luz gashami tuki Ñukada crijkuna ama yanamangabi sakirichun nishkamunda kai pachamu shamugani. ");
INSERT INTO qxl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Maijinsh Ñukaj shimigunada uyushash na kazukiga Ñukaga na juchachishachu. Kai pachada juchachingujka na shamuganichu, ashtanbish kishpichingujmi shamugani. ");
INSERT INTO qxl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Maijin Ñukada na rikunachisha Ñukaj shimigunada na kazujka llakimu kachujtaga ñami charin. Ñuka parlushka shimigunaidimi tukurij p'unllabiga juchachinga. ");
INSERT INTO qxl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ñukaga Ñukaj munillamundaga na parluganichu; Ñukada Kachuj Taitami imada parlanadash imada yachachinadash manduga. ");
INSERT INTO qxl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pai mandushkaga na tukurij kausimu pushaj gashkadaga yachanimi. Shinakiga imada Ñuka parlushash Taita mandushka shinami parlani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jesusga kai pachamunda llujshisha Taitaj kuchumu rina uras chayamushkadaga Pascua pishta narikish chayujllabidi yachushami Paiga kai pachabi gaj Paibujkunadaga tuki ratu k'uyujkuga, shinami tukurina p'unllagama k'uyuga. ");
INSERT INTO qxl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tuta mikuna urasmi gaga; Simón Iscariotej churi Judasbuj yuyibiga diabloga Jesusta japichina yuyida ñami churashkaga. ");
INSERT INTO qxl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusga Taita tukida rurachun Paimu poderda kushkada, shinaidi Diosmunda shamushkada Diosllamundi vueltanashkadash yachushami, ");
INSERT INTO qxl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","mikushka ratu mizamunda jatarisha, jawalla churanada anchuchisha, shuj toalladash chumbillinabi watariga. ");
INSERT INTO qxl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chi k'ipa shuj batiabi yakuda churusha Paibuj yachagujkunaj chakida maillushami chumbillinabi watarishka toallan chakichingu kallariga. ");
INSERT INTO qxl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ña Simón Pedroj chakida Jesús maillungu kuchuyaki paiga, “Manduj, ¿Kanchu ñukaj chakigunada maillush ninguiri?” niki, ");
INSERT INTO qxl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesusga, “Ñuka ima ruragushkadash kununga na intindinguichu, k'ipallami alli yachungui,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chimunda Pedroga, “Ñukaj chakida maillachunga nalladi sakishachu,” niki, Jesusga, “Chakida Ñuka na maillukiga Ñukaj gangujka na pudinguichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chimunda Simón Pedroga, “¡Manduj, ñukaj chakilladaga ama maillichu, ashtanbish makidash umadash maillabai!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesusga, “Maijinbish kununlla armushkalla gashaga tuki linshu gashkamundaga chakilladami maillana gan. Kangunaga linshu ganguichi; shinash na tukigunadijka linshu ganguichichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Maijin japichina gashkada Jesús yachushkamundami <Na tukigunaga linshu ganguichichu> niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Shinushaga chakida maillushka k'ipaga jawalla churanada kutin churarisha mizamu kutin tiyarishaga, “¿Ñuka kangunada ima rurushkada intindinguichichu?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Kangunaga Ñukada ‘Yachachij’ shinaidi ‘Manduj’ nishaga allidami ninguichi; Ñukaga shinami gani. ");
INSERT INTO qxl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Shinushaga Ñuka, Manduj shinaidi Yachachij gashash kangunaj chakida maillukidijka, kangunash kaishuj chaishujmi chakida maillanukunanguichi. ");
INSERT INTO qxl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ñuka rurushka layada kangunash rurachunmi shina rurusha rikuchishkani. ");
INSERT INTO qxl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kabishkadadimi nini, maijin mandushkada rurujbish mandujtaga na yallichugun, shinaidi kachushkabish kachujtaga na yallichugun. ");
INSERT INTO qxl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kaigunada alli intindisha shinaidi p'aktachishaga kushiyachishkami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kangunapuramunda tukigunadaga na ninichu; maijingunada Ñuka agllushkadash rijsinimi. Shina gakish Diosbuj Shimibi kashna nishkaga p'aktanaidimi gan, ‘Ñukan igulda mikujlladimi Ñukada jaituj laya ruruga.’ ");
INSERT INTO qxl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ima ura shina tukukiga <Ñukadimi gani> nigujta kanguna crichunmi narikish imash tukujllabidi kununmundadi nini. ");
INSERT INTO qxl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kabishkadadimi nini, maijin Ñuka kachushkada japijka, Ñukadami japin; shinaidi maijin Ñukada japijka Ñukada Kachujtami japin,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kaigunada nishka k'ipaga Jesusga llakilladi tukushaga, “Kabishkadadimi nini, kangunamunda shujka Ñukadaga japichingami,” nisha yachi chayachiga. ");
INSERT INTO qxl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chimunda Paibuj yachagujkunaga maijinda nishkadash na yachusha kaishuj chaishujmi rikunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yachagujkunapuramunda Jesús pachun llakishkaga mikuna ratuga Paibimi kimirishkaga. ");
INSERT INTO qxl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chimunda Simón Pedroga, pimunda shina nigushkada Jesusta tapuchun nishami señaskunada ruruga. ");
INSERT INTO qxl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Shina ruraki pai Jesusbuj kuchubi gashaidi, “Manduj, ¿pidikun?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chibimi Jesusga, “Tanda p'akida nuyuchisha maijinmu Ñuka kushka, paimi gan,” nisha tanda p'akida nuyuchishaga Simón Iscariotej churi Judasmu kuga. ");
INSERT INTO qxl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tandada Judas japinmi Satanasga paibi waiguga. Shinusha Jesusga, “Kan ima rurana gashkada ut'kada rurilla,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mizabi tiyajkunamunda maijinbish imamunda paida shina nishkadaga na intindigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas kuchkida apuj gashkamundaga shujkunaga <Jesusga pishtaj ima ministishkada randichun, na gashaga, imadash na charijkunamu imaidash kuchun nishami shina nigushkanchin> yuyugagunami. ");
INSERT INTO qxl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tandada japishka k'ipaga Judasga llujshisha rigallami; ña tutamiga. ");
INSERT INTO qxl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas llujshisha rishka k'ipaga Jesusga kashna niga: “Kununmi Aichayuj tukushka Churiga k'uilla gashkadadi rikuchina chayamun. Taita Diosbish k'uilla gashkaga Ñukamundami rikuchishka gan. ");
INSERT INTO qxl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aichayuj tukushka Churi Dios k'uilla gashkada rikuchikiga, shinaidi Dioslladimi Churida k'uilla gashkada ñalla rikuchinga. ");
INSERT INTO qxl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ñuka k'uyashka wawagunalla, ña ashalladami kangunan gasha. Kangunaga Ñukada mashkunguichimi, shinash manduj israelgunada nishka layaidimi kangunadash nini, Ñuka rigushkamunga na ri pudinguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kai mushuj mandushkadash kangunamunga kunimi: kaishuj chaishuj k'uyanukichi; ima laya Ñuka kangunada k'uyani, shinaidimi kangunash kaishuj chaishuj k'uyanukuna ganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kanguna kaishujkun chaishujkun k'uyanukukimi Ñukaj yachagujkunadi gashkada tukiguna rijsingaguna.” ");
INSERT INTO qxl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedroga Jesusta, “Mandaj, ¿maimundi ringui?” nisha tapuki, Jesusga, “Ñuka rigushkamunga kunundijka na katisha ri pudinguichu; k'ipallaga katinguillami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Shina niki Pedroga, “Manduj, ¿imamundadi kununlladi na katish ri pudiniri? ¡Kanmunda ñukaj kausida kuna gakish kushallami!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Shina niki Jesusga, “¿Ñukamunda kambuj kausida kunguimuchari? Ashtanbish kanda kabishkadadimi nini, narikish gallo cantujllabidimi kinsa kutin Ñukadaga <Na rijsinichu> ninguimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús paigunada kashna niga: “Ama kaida chaida yuyasha mancharichichu, ashtanbish Diostash Ñukadash crichi. ");
INSERT INTO qxl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ñukaj Taitaj wasibiga tauga kausana ukugunami tiyan; na shina gashkakiga ñami kangunamu parlanimuga. Shuj pushtudami kangunamu parijangu rini. ");
INSERT INTO qxl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Shina risha shuj pushtuda parijashka k'ipaga Ñuka tiyashka pushtullabidi kangunash gachun Ñukan pushusha ringu kutinmi shamusha. ");
INSERT INTO qxl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kangunaga Ñuka maimu rigushka pushtumu pushuj ñandaga rijsinguichimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Shina niki Tiumaga, “Manduj, Kan maimu rigushkadash na yachunchichu; ¿ñandagarin ima layadi yachashunri?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chimunda Jesusga, “Ñukami ñanbish, kabishkash, kausish gani. Maijinbish Ñukallamundami Taitajmunga chayi pudin. ");
INSERT INTO qxl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kanguna Ñukada rijsishadijka Ñukaj Taitadash rijsinguichimi; ña rikushkamundaga kununmundadimi rijsinguichi.” ");
INSERT INTO qxl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chimunda Felipega, “Mandaj, ñukuchimu Taitada rikuchibai; chilladami mañanchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Shina niki Jesusga, “Felipe, unida kangunan ganindi; ¿shinash Ñukada narijchu rijsingui? Maijin Ñukada rikujka Taitadami rikushka. ¿Imashadi, ‘Taitada ñukuchimu rikuchibai,’ nisha mañungui? ");
INSERT INTO qxl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ñukaga Taitabi shinaidi Taitash Ñukabi gashkada nachu cringui? Kangunamu imada nishash na Ñukaj munimunda ninichu. Ashtanbish Ñukabi kausuj Taitami Paibujti ruranagunadaga rurun. ");
INSERT INTO qxl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ñuka Taitabi gashkadash Taitash Ñukabi gashkadash crichi; na gashaga Ñuka rurushkagunallamundash crichiri. ");
INSERT INTO qxl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kabishkadadimi nini, maijin Ñukada crijka Ñuka rurushkagunaidadimi rurunga; shinaidi Ñuka Taitajmu rigushkamundaga ashtandi yalligunadami rurunga. ");
INSERT INTO qxl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Shinaidi kanguna Ñukaj shutibi ima mañushkadash rurushami. Taita k'uilla gashkaga Churimunda rikuchishka gachunmi Ñukaga shinada rurusha. ");
INSERT INTO qxl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kanguna imadash Ñukaj shutibi Ñukada mañukiga rurushami.” ");
INSERT INTO qxl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kanguna Ñukada k'uyushaga Ñuka mandushkagunada kazunguichimi. ");
INSERT INTO qxl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ñukaga, kutin shuj Allimu Pushaj Espirituda kuchunmi Ñukaj Taitada mañasha. Chi Pushajka tuki ratumi kangunan ganga. ");
INSERT INTO qxl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Chi Espirituga kabishkadadi yachachijmi, na crijkunaga Paida na rikushkamunda, na rijsishkamundaga na japi pudingagunachu; ashtanbish kangunan kausagushkamundaga Paida rijsinguichimi, shinaidi kangunabimi ganga. ");
INSERT INTO qxl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Shitashkagunadaga na sakishachu, kangunan gangu shamushami. ");
INSERT INTO qxl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Asha k'ipaga kai pachamundagunaga Ñukadaga na ashtan rikungagunachu; ashtanbish kangunaga rikunguichimi, shinaidi Ñuka kausagunalla gashkamundaga kangunash kausunguichimi. ");
INSERT INTO qxl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chi p'unllabimi Ñukaga Ñukaj Taitabi gashkada, kangunash Ñukabi gashkada, Ñukash kangunabi gashkada yachi chayunguichi. ");
INSERT INTO qxl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Maijin Ñuka mandushkagunada japisha kazujka, Ñukada kabishkadi k'uyushkadami rikuchin. Maijin Ñukada k'uyujtaga Ñukaj Taitash k'uyungami, Ñukash k'uyushami; shinaidi paimumi rijsirisha,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chimunda chaishuj Judasga (paiga na Iscariotechuga), “Mandaj Jesús, ¿imashadi ñukuchimu rijsirisha ashtan kai pachaj gajkunamunga na rijsirisha ninguiri?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Shina tapuki Jesusga, “Maijin Ñukada k'uyujka Ñuka parlushkada kazungami, Ñukaj Taitash paida k'uyungami, shinaidi Taitash Ñukash paibimi kausungu shamushun. ");
INSERT INTO qxl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Maijin Ñukada na k'uyajka, Ñuka parlushkadaga na kazunchu; kanguna uyashka shimigunaga na Ñukajchugun, ashtanbish Ñukada kachuj Taitajmi gan. ");
INSERT INTO qxl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Kaigunadaga kangunan gashka ratuidimi niguni. ");
INSERT INTO qxl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ashtanbish Taita Diosga Ñukaj shutibimi Paibuj Allimu Pushaj Espirituda kachunga; Paimi tukida yachachinga, shinaidi kangunamu Ñuka ima nishkadash tukida yuyachinga. ");
INSERT INTO qxl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ñuka rishaga k'uilla kausidami kangunamu sakini; chi k'uilla kausiga Ñukallamundadimi shamun, kai pachamundaguna kushka shinaga na kunichu. Shinusha ama kaida chaida yuyasha musparichichu, shinaidi ama mancharichichu. ");
INSERT INTO qxl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“ ‘Rinimi,’ nishkada shinaidi, ‘Kutin kangunan gangu shamushami,’ nishkadash ña uyushkanguichimi. Kanguna Ñukada kabishkadi k'uyushkashaga, Taitajmu rinashkada yachushaga kushiyanguichimumiga. Taitaga Ñukadash yallimi gan. ");
INSERT INTO qxl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kai nishkaguna p'aktuki kanguna crichunmi narij shina tukujllabidi kaidaga parlani. ");
INSERT INTO qxl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kai pachada manduj diablo shamugushkamundaga kangunanga yalliga ña na parlarigushallachu. Chi shamuj Ñukada imadash na ruri pudinchu. ");
INSERT INTO qxl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ashtanbish Ñukaga, Taitada k'uyuj gashkada shinaidi Pai mandushkalladadi ruruj gashkada kai pachabi kausujkuna yachachunga, shinaidimi gana gan. “Kununga, jatarisha kaimunda jakuchilla,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesusga nigami, “Ñukaga kabishkadi uva yura shinami gani, Ñukaj Taitaga achpabi rurujmi. ");
INSERT INTO qxl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ñukaj ramagunamunda maijin uvada na aparij ramadaga p'itishtangami; ashtanbish uvada tuki aparijtaga ashtan aparichun linshushami parijanga. ");
INSERT INTO qxl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kangunaga Ñuka parlushkagunan ñami linshushka ganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ima layami Ñuka kangunan tandanukushka gani, shinaidi Ñukan tandanukushka gaichi. Shuj ramaga yuran na tandanukushka gashaga pailladijka na uvada apari pudinchu. Shina layaidi Ñukan na tandanukushka gashaga kangunallaga ima granudash na kui pudinguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ñukaga uva yurami gani, kangunaga ramagunami ganguichi. Ñuka illujka imadash na ruri pudinguichichu. Chimundami maijin Ñukan tandanukushka gasha, Ñukash paigun tandanukushka gakiga granuda pachun kunga. ");
INSERT INTO qxl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Maijin na Ñukan tandanukushka gajka ramagunada shina washamu shitashkami ganga. Chakirishka ramagunada tandachisha ninamu shitusha rupachishka shinami ganga. ");
INSERT INTO qxl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kanguna Ñukan tandanukushka kausasha, shinaidi Ñuka yachachishkagunada rurusha katishaga, tuki ima munushkadash mañichilla; kangunamu kungami. ");
INSERT INTO qxl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Shina pachun granuda kuj gashami kanguna Ñukaj yachagujkunadi tukunguichi; chibimi Ñukaj Taitaga k'uilladi gashkan rikuchishka ganga. ");
INSERT INTO qxl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ñukaj Taita ima laya Ñukada k'uyun, shinaidimi Ñukash kangunada k'uyani. Shinushaga Ñuka k'uyushkabi katichi. ");
INSERT INTO qxl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ima layami Ñukaga Ñukaj Taita mandushkagunada kazusha Paibuj k'uyushkabi katini, shinaidi kangunash Ñuka mandushkagunada kazushaga Ñuka k'uyushkabimi katinguichi. ");
INSERT INTO qxl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ñuka kushiyashka laya kushilla gachun kangunaj kushilla ganash illujta p'aktushka gachunmi kaigunada parlani. ");
INSERT INTO qxl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ñukaga kaidami mandani: ima layami Ñuka kangunada k'uyani, shinaidi kangunash kaishujkun chaishujkun k'uyanukuchun. ");
INSERT INTO qxl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maijinsh alli apanukujkunamunda kikinbuj kausida kujmi jatun k'uyidaga charin. Chida yalliga pish na k'uyanchu. ");
INSERT INTO qxl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kangunaga Ñuka mandushkada rurushaga Ñukan alli apanukujkunami ganguichi. ");
INSERT INTO qxl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kununmundaga kangunadaga <sirvijkuna> nishaga na nishachu; sirvijka paida manduj imada ruragushkada na yachunchu; ashtangarin kangunadaga Ñukaj Taita Ñukamu ima nishkagunada tukida kangunamu yachi chayachishkamundaga <Ñukan alli apanukujkuna> ninimi. ");
INSERT INTO qxl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kangunaga Ñukadaga na aglluganguichichu, Ñukami kangunadaga agllugani. Kanguna risha pachun granuda kuj yura shina gachun shinaidi kanguna apashka granugunaga na chingarichunmi mingugani. Shinami Ñukaj shutibi imadash mañukiga Taitaga kangunamu kunga. ");
INSERT INTO qxl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kaishujkun chaishujkun k'uyanukuchunmi kangunadaga mandani.” ");
INSERT INTO qxl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kai pachamundaguna kangunada p'iñukiga Ñukadadi p'iñushkada yuyunguichi. ");
INSERT INTO qxl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ñukami kai pachagunapuramunda kangunadaga agllugani, shinusha na kai pachaj gashkamundami kai pachaj gentegunaga kangunada p'iñunguna. Kanguna kai pachaj gakiga kai pacha gentegunaga paigunapura k'uyanukushka laya k'uyunmumi. ");
INSERT INTO qxl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ñuka kai parlushkada yuyarichi: ‘Maijin mandushkada rurujkish mandujtaga na yallichu.’ Ñukadash katik'ichujkunadijka kangunadash katik'ichungagunami; Ñuka parlushkagunadash paiguna kazushkashaga, kanguna parlushkadash kazungagunami. ");
INSERT INTO qxl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ashtanbish Ñukada Kachujta na rijsishkamundami kanguna Ñukada katishkamunda kai tukigunadaga rurungaguna. ");
INSERT INTO qxl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ñuka parlungu na shamushkakiga jucha illujkunami ganmuga. Ashtanbish kununga <Ima juchash na charinichu> ningujka na pudingagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Maijin Ñukada p'iñujka Ñukaj Taitadash p'iñunmi. ");
INSERT INTO qxl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Pish narij rurushkagunada paigunaj ñaubuki Ñuka na rurushkakiga, jucha illujkunami ganmuga; ashtanbish ña kaigunada rikushkagunami; shina rikushash Ñukada Ñukaj Taitadash p'iñungunami. ");
INSERT INTO qxl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Paigunada mandushkabi, ‘Ñukada yangami p'iñagaguna,’ nisha escribishka shimiguna p'aktachunmi shina tukuga. ");
INSERT INTO qxl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ashtanbish Taitamunda shamuj Espíritu shamushami Ñukamunda yachi chayachinga. Paimi Taitajmunda Ñuka kachana Allimu Pushaj shinaidi kabishkada yachachij Espíritu gan. ");
INSERT INTO qxl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Shinaidi kangunash kallarimundadi Ñukan gashkamundaga Ñukamunda yachi chayachinguichimi. ");
INSERT INTO qxl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kanguna Ñukada crishkada ama chingachichunmi kaigunadaga nini. ");
INSERT INTO qxl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Diosmunda yachana wasimundash kangunada llujshichisha kachungagunami, shinaidi maijinsh kangunada wañuchishaga <Shinami Dios munushkada ruranchi> nina p'unllagunash chayamungami. ");
INSERT INTO qxl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Taitadash Ñukadash na rijsishkamundami kaigunadaga shina rurungaguna. ");
INSERT INTO qxl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Chi p'unllaguna chayukiga Ñuka kangunamu ña nishkada yuyarichunmi kaigunadaga shina parlani.” “Kangunan igulda gashkamundami kallarimundadijka kaigunadaga na parlugani. ");
INSERT INTO qxl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kununga Ñukada Kachujbujmumi riguni; kangunamunda maijinllash ‘¿Maimu ringui?’ nishash na tapunguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ashtanbish Ñuka kaigunada parlushkamundaga shungundijta llakilladimi tukushkanguichi. ");
INSERT INTO qxl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ashtanbish kangunabujka Ñuka rishkami alli ganga, nishaga kabishkadami nini. Ñuka na rikiga Allimu Pushaj Espirituga kangunan gangujka na shamungachu; ashtanbish Ñuka rishaga Paida kangunamu kachushami. ");
INSERT INTO qxl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pai shamushaga maijindi juchayuj maijindi kabishkada ruruj gashkada, shinaidi maijindi Diosbuj llakichinada japina gashkadash tuki kai pachamundagunamu laruda rikuchinga. ");
INSERT INTO qxl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Juchamunda parlashaga Ñukada na crishkamunda juchayuj gashkadami rikuchinga. ");
INSERT INTO qxl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kabishkada ruruj gashkamundaga, Ñuka Taitajmu rigushkamunda, kanguna Ñukada ña na rikunashkamundash, Paimi rikuchinga. ");
INSERT INTO qxl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Diosbuj llakichinamundaga, kai pachada manduj diablodaga ñami juchachishka gashkadash rikuchinga. ");
INSERT INTO qxl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kangunamu parlanadaga chairijtij manchanaidimi charini, ashtanbish kununbiga ashtan cargada apachij shina parluki japingujka na pudinguichichu. ");
INSERT INTO qxl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ashtanbish kabishkada yachachij Espíritu shamushami tuki kabishkamu pushanga; na Paibuj munillamunda parlungachu, ashtanbish tuki ima uyushkaidami parlunga, shinaidi ima tukunagunadash yachi chayachingami. ");
INSERT INTO qxl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ñuka parlashkada japishami kangunamu rijsichinga, shina rurushami Ñuka k'uilla gashkadash rikuchinga. ");
INSERT INTO qxl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ñukaj Taita tuki ima charishkash Ñukajmi gan, shinushami, ‘Diosbuj Espíritu Ñuka parlashkada japisha kangunamu rijsichinga,’ nigani. ");
INSERT INTO qxl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Asha k'ipallaga Ñukada ña na rikunguichichu. Shinaidi ashan k'ipallagunaga kutinmi Ñukada rikunguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Shinushaga Paibuj yachagujkunamunda maijingunaga, “ ‘Asha k'ipallaga Ñukada ña na rikunguichichu. Shinaidi ashan k'ipallagunaga kutinmi Ñukada rikunguichi,’ nisha shinaidi ‘Ñuka Taitajmu rigushkamunda,’ nishaga ¿ima nishadi shina nin?” nisha kaishuj chaishuj tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Shina, “ ‘Ashan k'ipallaga,’ nishaga, ¿imadadi nisha nigun? Na intindinchichu,” ninukukimi, ");
INSERT INTO qxl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesusga Paida tapungu munushkada yachushami kashna niga: “¿Ñuka, ‘Asha k'ipa ña na rikunguichichu, asha k'ipallaga kutin rikunguichimi,’ nishkadachu kangunapura tapunukunguichi? ");
INSERT INTO qxl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kabishkadadimi nini, kangunaga wakusha llakilla ganguichimi, ashtanbish kai pacha gentegunaga kushiyangagunami. Ashtangarin kanguna llakilla gashkash kushimi tukunga. ");
INSERT INTO qxl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Shuj warmi wachanalla gasha ña uras p'aktushkamundaga nanachishami llakirin. Shinash marada mirushka k'ipaga kai pachamu shuj mara wacharishkamundaga kushiyarishami nanidash kungarin. ");
INSERT INTO qxl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Shinaidimi kangunash kununga llakiringuichi; shinakish Ñuka kutin rikungu shamushami. Chibimi kangunaj shungubiga pish na anchuchi pudibuj kushi jundunga. ");
INSERT INTO qxl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chi p'unllabiga Ñukada ña imadash na tapunguichichu. Kabishkadadimi nini, Ñukaj shutibi imadash Taitada mañukiga kangunamu kungami. ");
INSERT INTO qxl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kangunaga Ñukaj shutibi kunungamaga imadash na mañushkanguichichu. Shinusha mañichi, japinguichimi, kangunaj kushi illujta p'aktushka gachun.” ");
INSERT INTO qxl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kaigunadaga ch'imbapurashallami kangunamu parlushkani; shinaidi ch'imbapurashkagunan ña na parlushalla ashtanbish Ñukaj Taitamunda tukida laru parlana urasbish chayamungami. ");
INSERT INTO qxl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chi p'unllagunaga Ñukaj shutibimi kangunaga Paida mañunguichi. <Kangunamunda Taitada Ñukalladi mañushami> nishaga na ninichu. ");
INSERT INTO qxl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taitalladimi kangunadaga k'uyan. Kanguna Ñukada k'uyushkamunda shinaidi Diosmunda Ñuka shamushkada crishkamundashmi kangunadaga k'uyan. ");
INSERT INTO qxl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taitajmundami kai pachamu shamugani; kutin kai pachamunda risha Taitajllamundimi riguni,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Shina niki Paibuj yachagujkunaga, “Kununmi ch'imbapurashkagunada na churusha laruda parlangui. ");
INSERT INTO qxl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kununmi Kan tukida yachuj gashkada, shinaidi pi ima tapunash na ministirishkadash yachanchi, shinushami Kanga Diosmunda shamushkada crinchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Shina niki Jesusga, “Shinushaga ¿kununchu cringuichi? ");
INSERT INTO qxl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Rikichi, ñami uraska kuchuyamun, kanguna Ñukaida sakisha kangunaj wasimu t'siraparisha rinash kununlladimi gan. Shinash Taita Ñukan gashkamundaga na Ñukalla ganichu. ");
INSERT INTO qxl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kanguna Ñukan tandanukushka gasha k'uilla kausida japichunmi kai tukigunadaga parlugani. Kai pachabi kangunaga llakidami apana ganguichi; shinash jinchi tukunguichi, Ñukami kai pachadaga ña vincigani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kaigunada nishka k'ipaga jawa pachada Jesús rikushaga, “Taita, ñami uraska chayamushka: Kambuj Churi pachun k'uidij gashkada rikuchibai, Kambuj Churish Kanda pachun k'uidij gashkada rikuchichun. ");
INSERT INTO qxl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Shinaidi mashnalla Kan Ñukamu kushkagunamush na tukurij kausida kuchunmi, tuki gentegunada mandachun Kan Ñukada churashkangui. ");
INSERT INTO qxl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kan shujlla kabishka Diosta shinaidi Kan kachushka Jesucristodash rijsishami paigunaga chi na tukurij kausidaga japinga. ");
INSERT INTO qxl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Kan kushka ruranagunada tukuchishami kai pachabi Kan pachun k'uidij gashkadaga Ñukaga rikuchishkani. ");
INSERT INTO qxl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kununga Taitalla, kai pacha narikish tiyajllabidi Ñuka Kangun gasha charishka k'uilla gashkalladadi Kambuj ñaubuki rikuchibai.” ");
INSERT INTO qxl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kai pachabi gajkunamunda Kan agllusha kushkagunamunga Kan pi gashkada rijsichishkanimi. Kambujkunamiga. Shinash Ñukamumi kugangui. Shinaidi Kan parlushkadash kazushkagunami. ");
INSERT INTO qxl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kununga Kan tuki imalla Ñukamu kushkagunaga Kanmundadi shamushkadami yachunguna. ");
INSERT INTO qxl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kan parlachun nishkagunadash parluganimi. Paigunaga japishkami. Kabishkadi Kanmunda shamushkada yachi chayagagunami. Shinaidi Ñukadaga Kan kachushkadash crishkagunami. ");
INSERT INTO qxl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Paigunamundami mañani. Kai pachabuj gajkunamundaga na mañanichu. Ashtangarin Kambujkuna gashkamundami Kan Ñukamu kushkagunamunda mañani. ");
INSERT INTO qxl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Imalla Ñukabuj gashkaga Kambujmi, imalla Kambuj gashkaga Ñukajmi. Shinaidi Ñuka pachun k'uilladi gashkaga paigunabi laru rikunallami. ");
INSERT INTO qxl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ñukaga kai pachabiga na gashachu, paigunaga kai pachabimi katingaguna; ashtanbish Ñukaga Kangun gangumi riguni. Jucha illuj Taitalla, ima shina Ñukash Kambish shujlla ganchi, shinaidi paigunash shujlla gachun, Ñukamu kushka Kambuj shutibi wakichibai. ");
INSERT INTO qxl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ñuka kai pachabi paigunan gashaga Ñukamu kushka Kambuj shutibi ama imash tukuchun wakichigugani. Paigunamunda maijinsh na chingarigachu, ashtanbish Diosbuj Shimi nishka p'aktachunga chingarinaj k'arillami chingariga. ");
INSERT INTO qxl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Kununga Kan maibi tiyashkamumi riguni. Ñukada katijkuna Ñuka kushiyashka laya kushilla gana illujta p'aktushka gachunmi kai pachabi gashaidi kaigunadaga niguni. ");
INSERT INTO qxl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ñukaga Kan parlachun nishkadami paigunamu parlugani. Ñuka na kai pachamundachu gani, paigunash na kai pachaj ganchu. Chimundami paigunadaga kai pachamundaguna p'iñunguna. ");
INSERT INTO qxl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ñukajkunada kai pachamunda anchuchichunga Kanda na mañanichu, ashtangarin paigunada na allimunda wakichichunmi mañani. ");
INSERT INTO qxl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ima layami Ñukash na kai pachabuj gani, shinaidi paigunash na kai pachabujchu gan. ");
INSERT INTO qxl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kan parlashkami kabishka gan. Kan kabishka parlashkan paigunada Kambujlla gachun rurabai. ");
INSERT INTO qxl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ima layami Ñukada kai pachabi kausujkunajmu kachugangui, shinaidimi Ñukash paigunadaga kai pachabi gajkunajmu kachani. ");
INSERT INTO qxl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Paigunash kabishka parluda crisha Kambujlla gachunmi, Ñukaga Ñukalladi Kambujlla gangu ch'ikunyarishka gani.” ");
INSERT INTO qxl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","“Paigunallamundaga na mañanichu, ashtanbish paiguna parlushkada uyusha k'ipalla Ñukada crij ganagunamundashmi, tukiguna shujlla gachun mañani. Taitalla, Ñukada Kan kachashka gashkada kai pachabi kausajkuna crichunga, ima layami Kan Ñukabi gangui Ñukash Kambi gani, shinaidi paigunash Ñukuchibi shujlla gachun nishami mañani. ");
INSERT INTO qxl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ñukuchi shujlla gashka layaidi paigunash shujlla gachunmi Kan Ñukamu kushka chi k'uilla gashkalladadi rikuchichun paigunamush kugani. ");
INSERT INTO qxl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ñukash paigunabi, Kambish Ñukabi shujlla gana illujta p'aktushka gachunmi mañani. Shinami kai pachamundaguna Kan Ñukada kachushka gashkada shinaidi Ñukada k'uyashka layaidi paigunadash k'uyushkada yachungaguna. ");
INSERT INTO qxl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taitalla, kai pachada narij rurujllabidimi Ñukada k'uyasha pachun k'uidij ganada Ñukamu kugangui. Kan Ñukamu kushka gentegunaga shina k'uilla gashkada paiguna rikuchunga Ñuka maibi gashkallabidimi paigunash Ñukan gachun munani. ");
INSERT INTO qxl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Kabishkada ruruj Taitalla, kai pachabi gajkunaga Kandaga na rijsinchu; ashtanbish Ñukaga Kandaga rijsinimi, shinaidi kaigunash Ñukada Kan kachashkadaga yachungunami. ");
INSERT INTO qxl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kan Ñukada k'uyushka layaidi paigunash chi k'uyillandi shujkunada k'uyachun, shinaidi Ñukaidikish paigunabi gangu, Kan pi gashkadaga rijsichishkanimi; shina rijsichisha katigushallami,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Shina nishka k'ipa Jesusga Paibuj yachagujkunandijmi Cedrón waiku yaku ch'imbamu riga. Chibiga huertomi tiyaga. Chimumi Jesusga Paibuj yachagujkunandij waiguga. ");
INSERT INTO qxl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Shinaidi Jesús Paibuj yachagujkunan tauga kutin chibi tandanukuj gashkamundaga Paida japichiguj Judasbish chi pushtudaga rijsijmiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Shinami Judasga tauga soldadogunan shinaidi Diosbuj wasida chapujkunandij, manduj curaguna fariseogunash kachushka chayugaguna. Paigunaga nina japichishka kaspigunan lamparagunan tuki laya takanukunagunadash apushkagunamiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ashtanbish Jesusga Pai ima tukunashkadash tukida ña yachushkamunda llujshishaga, “¿Pida mashkagunguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paigunaga, “Nazaretmunda Jesusta,” niki, Jesusga, “Ñukami gani,” niga. Japichingu purij Judasbish chibi paigunanmiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Shina, “Ñukami gani,” nisha Jesús nikiga, washamu sikiyasha pambamu urmugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chimunda Jesusga, “¿Pida mashkagunguichi?” nisha kutinlladi tapuki, paigunaga, “Nazaretmunda Jesusta,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Shina niki Jesusga, “Ñukaidimi gani nisha ña niganindi. Ñukada mashkagushaga Ñukaj katijkunadaga richun sakichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“Ñukamu kushkagunamundaga shujlladash na chingachiganichu,” nisha ña parlashka p'aktachunmi Jesusga shina niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chimunda Simón Pedroga pai charishka espadada surkusha jatun manduj curamu sirvij Malco shuti k'arij alli ladu rinrinda p'itishtaga. ");
INSERT INTO qxl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chimunda Jesusga Pedrodaga, “Kambuj espadada chi pushtullabidi churi. Taita Ñukamu jayuj ubiana shinada kukidijka, ¿maidadi na ubiashallari?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kanllalladi soldadogunaga paigunada mandajbish shinaidi israelgunaj chapujkunash Jesusta prezu japisha watugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chimundaga Caifasbuj suegro gashkamundami Anasbuj wasimundi Jesustaga pushugaguna; Caifasga chi watabiga jatun manduj curamiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifaslladimi, “Kai llaktabi kausujkunamunda tukiguna wañuna randiga shuj k'arillami wañuna alli gan,” nisha israelgunamunga nishkaga. ");
INSERT INTO qxl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedroga shuj yachagujkunmi Jesusta katisha rigugaguna. Pedron rij yachagujka jatun manduj curaj rijsishka gashkamundami Jesuskundij pungu pambamu waiguga. ");
INSERT INTO qxl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroga washa pungullabimi sakiriga. Chimundami curagunada manduj rijsishka yachagujka kanllamu llujshisha punguda chapuj warmin parlanukusha Pedroda ukumu waiguchiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedro waiguki punguda chapuj warmiga, “¿Nachu kambish chi k'arij yachaguj gangui?” nisha tapuga. Shina niki Pedroga, “Na, na ñukachuni,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chiri gakimi Diosbuj wasida chapujkunash sirvijkunash ninada japichishkagunaga. Chibimi Pedrosh paigunandi igulda kunusha shayaguga. ");
INSERT INTO qxl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jatun manduj curaga Jesusta Paibuj yachagujkunamunda shinaidi Pai ima yachachishkadami tapungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chimunda Jesusga, “Ñukaga tukigunaj ñaubukimi parlushkani. Diosbuj wasibish Diosmunda yachana wasigunabish tuki israelguna maibi tandanukushkabimi yachachishkani; imadash pakalla na yachachishkanichu. ");
INSERT INTO qxl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imasha Ñukada tapungui? Ñuka parlushkada uyujkunada tapiri. Paigunaga Ñuka ima nishkadash yachunmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús shina niki chibi gaj chapujkunamunda shujka, “¡¿Jatun manduj curadachu shina ninguiri?!” nisha Jesusbuj ñawibi lutskiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chimunda Jesusga, “Imada na alli nishkakish, ima na alli gashkada rikuchibai. Shinaidi Ñuka ima nishka alli gakiga, ¿imashti Ñukada lutskingui?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chimunda Anasga jatun manduj cura Caifasbujmu Jesusta watushkada kachuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedroga ninabi kunusha katigallami. Chimunda shujkunaga, “¿Nachu kambish chi k'arij yachagujkunapuramunda gangui?” nisha tapuki, Pedroga, “Na ñukachuni,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Shina niki jatun manduj curaj sirvijkunamunda shujka, “¿Nachu paigun huertobi kanda rikugani?” niga. Tapujka Pedro rinrinda p'itishkaj familiamiga. ");
INSERT INTO qxl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kutinlladi Pedro, “Na” ninmi, gallo cantuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caifasbuj wasimundaga manduj Pilatoj wasimumi Jesusta pushusha rigaguna. Ña p'unllayamuki israelgunaga ama mapalla tukungu ashtanbish Pascua mikunadaga linshu gasha mikungajmi chi wasi ukumunga na waigugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chimunda manduj Pilato parlaringu llujshishaga, “Kai k'aridaga, ¿imadadi juchachinguichi?” niki, ");
INSERT INTO qxl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Ima millidash na ruruj gashkakiga kambujmuga na pushamunchimuchuga,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Shina niki Pilatoga, “Kangunaj mandushkabi nishka shina juchachingujka pushusha richilla,” niga. Chimunda manduj israelgunaga, “Ñukuchijka pidash na wañuchinallachu ganchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Shinami Jesús Pai ima laya wañuna gashkada parlushka p'aktuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chimunda Pilato pai mandusha tiyana ukumu kutin waigusha Jesusta kayushaga, “¿Kanchu israelgunaj jatun manduj gangui?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Shina tapuki Jesusga, “¿Kaidaga kambuj yuyimundachu? na gashaga ¿shujkuna Ñukamunda nishkalladachu tapungui?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chimunda Pilatoga, “¿Ñukaga israelchu gani? Kambuj llaktabi kausujkuna manduj curagunashmi kandaga ñukajmunga pushamuga. ¿Imada rurugangui?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Shina tapushkamunda Jesusga, “Ñuka mandanaga na kai pachabujchu. Kai pachabi mandana gakiga Ñuka nishkada rurujkunaga takanukusha israelda mandajkunamu kuchunga na sakinmuchuga. Ashtangarin Ñuka mandanaga na kai pachabujchu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chimunda Pilatoga, “Shinaga ¿kanga jatun mandujchu gangui?” nisha tapuga. Shina tapuki Jesusga, “Ñuka jatun manduj gashkadaga kanlladimi nishkangui, Ñukaga kai pachamu shamusha kabishkada parlungumi wacharigani. Shinaidi mashnalla kabishkabuj gajkunaga Ñuka parlushkada uyanmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Shina niki Pilatoga, “¿Imadikun kabishka shimiga?” nisha tapuga. Shina tapushka k'ipa Pilatoga kutinmi israelgunan parlaringu llujshiga; chibimi, “Kai k'aribiga ima na alli rurushkadaga na japinichu. ");
INSERT INTO qxl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ashtanbish kangunaga Pascua pishtagunabiga prezu tiyajkunamunda shujta kacharichun nijkunami ganguichi. ¿Israelgunada jatun mandujta kacharichun ninguichichu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Shina tapuki tukigunami, “¡Paidaga ama kacharichu! ¡Barrabasta ashtan kachari!” nisha kutin kaparigaguna. Barrabasga manchanaidi shuwami gaga. ");
INSERT INTO qxl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chimunda Pilatoga Jesusta japishaga azilgun dalichunmi kachuga. ");
INSERT INTO qxl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldadogunaga Paida mandujma layada rurusha shuj coronada kashan rurushami Jesusbuj umabi churachigaguna. Shinaidi jawalla yana puka churanadash churachigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chi k'ipaga, “¡Israelgunada jatun manduj alli gachun!” nishalla kuchuyashaga takugallagunami. ");
INSERT INTO qxl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kutin washamu llujshishaga paigunada, “Rikichi. Ima na alli rurashkada paibiga na japinichu; chida kanguna yachachunmi washamu pushamushkani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesusga kashan rurashka coronada umabi churashka shinaidi yana puka churanada churashkami washamu llujshiga. Chimunda Pilatoga, “¡Kaibimi kai k'arida charinguichi!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Manduj curagunash shinaidi chapujkunash Jesusta rikushaga, “¡Chakati! ¡Chakati!” nisha kaparigaguna. Chimunda Pilatoga, “Kangunaidi paida pushush risha chakatichilla. Ñukaga ima na alli rurushkadaga paibiga na japinichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Shina niki israelgunaga, “Ñukuchiga mandushkadami charinchi. Chi mandashka shinaga, ‘Diosbuj Churimi gani,’ nisha purishkamundaga wañunami kabin,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Shina nijta uyushagarin Pilatoga ashtanmi manchariga. ");
INSERT INTO qxl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilatoga pai mandusha tiyanamu kutin waigushaga, “Kanga, ¿maimundadi gangui?” nisha Jesusta tapuga. Shinash Jesusga imadash na nigachu. ");
INSERT INTO qxl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chimunda Pilatoga, “¿Nachu ñukamu imadash parlasha ningui? Ñukaga kacharichunbish na gashaga cruzbi chakatachunbish mandi pudinashkadaga, ¿nachu yachungui?” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Shina niki Jesusga, “Dios kanmu na kushkakiga Ñukada ima rurachun mandanada na charinguimuchuga. Shinushaga Ñukada maijin kanmu chayachijmi kandash yalli juchayuj gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Shina nishkamunda pachami Pilatoga Jesusta ima layash kacharingu yuyaguga. Shinash israelgunaga, “Kan kai k'arida kacharishaga, ¡jatun manduj Cesargun na apanukujchu tukungui! Maijinsh jatun manduj tukush nijka ¡Cesarda p'iñajmi gan!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Shina nishkada Pilato uyusha Jesusta washamu llujshichichun mandushka k'ipaga juez gangu mandanabi tiyariga. Chi pushtuga hebreo parlubiga, Gabata shutimiga. Shina nishaga Rumi Pamba nishkami gan. ");
INSERT INTO qxl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua pishtaj shuj p'unlla jualtaguki chi chaubi p'unlla shinadami Pilatoga israelgunamu, “¡Kaibimi kangunaj jatun mandujta charinguichi!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Shinash paigunaga, “¡Llujshichi, llujshichi! ¡Cruzbi lavusha wañuchilla!” nisha kapariga. Chimunda Pilatoga, “¿Kangunaj jatun mandujtachu chakatashari?” nisha tapuga. Chimunda manduj curagunaga, “Ñukuchijka jatun manduj Cesarlladami charinchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chimundami Pilatoga cruzbi lavungu richun Jesusta paigunamu kuga. Shina kukimi pushusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesusga cruzta aparisha Uma Tullu nishka pushtumumi llujshisha riga. Hebreo parlubiga, Gólgota nishkami gan. ");
INSERT INTO qxl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chibimi Jesustaga ishki k'arigunandij shujta alli ladubi chaishujta lluki ladubi cruzbi lavusha chakataga. Shinami Jesusga chaubibi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Shinaidi Pilatoga, “NAZARETMUNDA JESUSGA ISRAELGUNADA JATUN MANDAJMI,” nisha escribishaga cruzbi churachun manduga. ");
INSERT INTO qxl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Maibi Jesusta cruzbi lavushkaga, Jerusalén kuchullabi gashkamundami tauga israelguna chi escribishkada liyuga. Shinaidi hebreo parlubi, latín parlubi, griego parlubishmi rurashkaga. ");
INSERT INTO qxl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chimundami israelgunada manduj curagunaga Pilatoda, “ ‘Israelgunada jatun manduj,’ nishaga ama escribichu, ashtangarin, ‘ “Israelgunada jatun mandujmi gani,” nijmi,’ nisha escribiri,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Shina niki Pilatoga, “Ñuka escribishkaga escribishkami sakiringa,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldadogunaga Jesusta ña cruzbi lavushka k'ipaga churanada japisha chuskubi partishaga shuj shujmi japinukugaguna. Shinaidi na sirushalla jawamunda ura chakigama awashka ukumu churanadashmi japigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chimundami soldadogunaga, “Ashtan na llikishalla maijinmumi urmushkada rikungu sorteoda rurashunchi,” nisha parlanukugaguna. Shina rurukimi, “Ñuka churanada partinukugaguna, shinaidi ukumu churanadash surtiyashami japigaguna,” nisha Dios escribichishkaga p'aktuga. Shinaidimi soldadogunaga ruruga. ");
INSERT INTO qxl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesusta lavushka cruz kuchubiga Paibuj mamash, Paibuj mamaj ñañash, Cleofasbuj warmi Mariash, shinaidi Magdalamunda Mariashmi chibiga. ");
INSERT INTO qxl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesusga mamadash Pai k'uyashka yachaguj maman shayajta rikushaga mamadaga, “Riki mama, kaibimi kambuj churi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chi k'ipa Paibuj yachagujmu, “Chibimi kambuj mamada charingui,” niga. Shina nishka p'unllamunda pachami chi yachagujka Jesusbuj mamadaga paibuj wasibi kausachun japiga. ");
INSERT INTO qxl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chi k'ipa Jesusga ña tuki p'aktushkada yachushami Dios escribichishka p'aktachunga, “Yakunayunmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chibimi shuj wallu junda jayuj vino tiyaga. Chimunda hisopo ramabi shuj esponjada watusha chi jayuj vinon lapujyachisha Jesusbuj shimimu kuchuyachigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jayuj vinoda Jesús ubiushaga, “Ña tukimi p'aktachishka gan,” niga. Shina nishka k'ipaga umada kumurichisha Paibuj espirituda Diosmu mingusha wañugallami. ");
INSERT INTO qxl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua pishta p'unllajka shuj p'unllallami jualtuga. Chi samana p'unllaga yalli valij gashkamundami israelgunaga chi wañushkaguna cruzbi lavushkaidi sakirichunga na munagaguna. Shinushami changagunada p'akishtasha cruzgunamundash cuerpogunada uriyachichun nisha Pilatoda mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Shinusha soldadoguna rishaga Jesuskun igulda cruzbi lavushkagunaj changagunada kaishujbujtash chaishujbujtash p'akiga. ");
INSERT INTO qxl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusbujmu kuchuyashaga ña wañushkada rikushami Paibuj changagunadaga na p'akigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Shina gakish shuj soldadoga lanzan tujsisha Jesusbuj kustista chugrichinmi, chi chugrimundaga yakush yaurbish llujshiga. ");
INSERT INTO qxl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kaigunada parlujka rikushkadami parlan. Rikushkamundami kabishkada parlushkada pailladi yachan. Kanguna crichunmi paiga kabishkada parlan. ");
INSERT INTO qxl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dios escribichishkabiga, “Shuj tullulladash na p'akishkachu ganga,” nishka p'aktachunmi kaigunaga shina tukuga. ");
INSERT INTO qxl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Shinaidi shuj pushtubiga Dios escribichishkabiga, “Tujsisha chugrichishkadash rikungagunami,” nishkashmi tiyan. ");
INSERT INTO qxl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kaiguna k'ipaga Arimatea pueblomunda Joziga Jesusbuj cuerpoda apusha ringaj Pilatoda mañungu riga. Joziga mandaj israelgunada manchushkamundami Jesustaga pish na yachushkalla katij gaga. Shina mañuki Pilato <Ari> nikiga Joziga Jesusbuj cuerpoda apusha rigallami. ");
INSERT INTO qxl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Shinaidi sarundi shuj tuta Jesusta rikungu rij Nicodemosh, mirran, áloe nishkan chagrushka k'uilla ashnarigujta patsuj libra shinada apashka chayamuga. ");
INSERT INTO qxl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Shinami Jozish Nicodemosh Jesusbuj cuerpoda apusha rishaga pi wañukish israelguna pambungu rurushka shina chi k'uilla ashnarigujkunan linsun Jesusta pilluchigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta chakatashka pushtubimi shuj huerto tiyaga. Chi huertobimi pidash narij pambushka mushuj pambana ut'ku tiyaga. ");
INSERT INTO qxl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Israelgunaj samana p'unlla ña chayamugushkamunda shinaidi chi ut'kuga kuchullabi gashkamundashmi Jesusbuj cuerpoda chibi churugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semana kallari domingo p'unlla puzu puzuidimi Magdala pueblomunda Mariaga Jesusta pambushka ut'kumu riga. Chimu chayushaga ut'kuda tapushka tiyaj rumida anchuchishkada rikuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chida rikushaga Simón Pedrojmu shinaidi Jesús k'uyashka kaishuj yachagujbujmu apuruidi riga. Paigunajmu chayushaga, “Manduj Jesusbuj cuerpoda ut'kumunda apush rishkagunandi. Maibi churushkadash na yachanchichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Shina niki Pedrosh kaishuj yachagujkish llujshisha pambushkamu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishkindijkunami vulusha rigaguna. Shinash kaishujka Pedrodash yalli apuruidi vulush rishaga ut'kumunga ñaubusha chayuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rikungu kumurishaga pillushka linsugunalladami chibiga rikuga; shinash na waigugachu. ");
INSERT INTO qxl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Paibuj k'ipa Simón Pedro chayamusha ut'kumu waigushaga paibish linsuguna chibi sirijlladami rikuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Shinaidi Jesusbuj umada pilluchishka linsuga na chaishuj linsugunan igulda tiyagachu, ashtanbish shuj ladumu kururasha churashkadami rikuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chimunda pambushka ut'kumu ñaubusha chayuj yachajbish ukumu waigusha rikushaga crigami. ");
INSERT INTO qxl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Diosbuj Shimibi Pai kausarinadi gashkada escribishkada paigunaga narij intindishkagunachuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chi k'ipaga chi yachagujkunaga wasimumi vueltugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariaga pambushka ut'ku ladullabidimi wakusha sakiriga. Shina wakusha shayagushami ukuda rikungu kumuriga. ");
INSERT INTO qxl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chibimi yurajlladi churanada churushka ishki angelguna Jesusbuj cuerpoda churashka pushtubi shujka uma ladumu kutin shujka chaki ladumu tiyajkunada rikuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chimunda angelguna pai warmidaga, “¿Imasha wakangui?” nisha tapuki, paiga, “Ñukada Manduj Jesusbuj cuerpodami apush rishkaguna; maibi churushkadash na yachanichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chida nin washamu vueltush rikushaga Jesús chibi shayajta rikuga. Shinash Mariaga Paidaga na rijsigachu. ");
INSERT INTO qxl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chimunda Jesusga, “¿Imasha wakangui? ¿Pidadi mashkagungui?” niga. Shina niki paiga <Huertoda cuidujmishkanchin> yuyashaga, “Hijo Taita, kan Paida apush rishkashaga Paida maibi churashkada ñuka mashkungu ringu parlabai,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Shina niki Jesusga, “María,” niga. Chimunda María washamu vueltarishaga hebreo shimibi, “¡Rabuni!” niga. (“Rabuni” nishaga “Yachachij” nishami shina nin). ");
INSERT INTO qxl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chimunda Jesusga, “Ama Ñukada tupichu, Ñukaj Taitan gangujka narij rishkanichu. Ashtanbish Ñukada katij waukigunajmu ri. ‘ “Ñukakish kangunakish Taitajmu, Ñukakish kangunakish Diosbujmumi Ñukaga riguni,” ninmi,’ nisha parlungui,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chimunda Magdalamunda Mariaga Manduj Jesusta rikushkada shinaidi Pai imada nishkada yachagujkunamu parlungu chayuga. ");
INSERT INTO qxl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chi p'unllaidi ña tutayamuki semana kallari p'unllami yachagujkunaga manduj israelgunada manchushkamunda pungugunada alli ichkusha tandanukusha tiyakish Jesús rikurisha paigunaj chaubibi shayarishaga, “K'uilla kausi kangunan gachun,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Shina nishka k'ipa Paibuj makigunadash kustistash rikuchiga. Shinami yachagujkunaga Mandujta rikushkamunda kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chimunda kutinlladi Jesusga, “¡K'uilla kausi kangunan gachun! Taita Ñukada kachushka layaidimi, Ñukash kangunada kachani,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Shina nishka k'ipa paigunada p'ukushaga, “Diosbuj Espirituda japichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Maijin juchayujkunada kanguna perdonakiga perdonashkami sakiringa. Shinaidi maijindash na perdonakiga na perdonashkalladimi sakiringa,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús chimu chayamushka ratuga chunga ishki (12) yachagujkunapuramunda Ishkipura Wacharishka nishka Tiumaga illugami. ");
INSERT INTO qxl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Shinusha chaishuj yachagujkunaga paidaga, “Manduj Jesustami rikushkanchi,” nigaguna. Shina nikish Tiumaga, “Makibi lavugunan chugrichishkada na rikusha shinaidi chi chugribi ñukaj dedoda na waiguchisha Paibuj kustisbish ñukaj makin na tupushaga nalladi crishachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pusuj p'unlla k'ipash yachagujkunaga kutin shuj wasibi tandanukugaguna. Chi ratuga Tiumaga chibimi gaga. Pungugunash alli ichkushkami gaga, shinash Jesús rikurisha paigunaj chaubibi shayarishaga, “K'uilla kausi kangunan gachun,” nisha saludaga. ");
INSERT INTO qxl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chi k'ipa Tiumadaga, “Kambuj dedoda Ñukaj makibi churusha riki. Kambuj makida apami, Ñukaj kustista tupusha riki. Ama shina na crij gaichu, ¡ashtanbish cri!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Shina niki Tiumaga, “¡Ñukada Mandujlla! ¡Ñukaj Dioslla!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chimunda Jesusga, “Kanga Ñukada rikushadimi crishkangui. ¡Na rikushash crijkunaga kushiyachishka gachun!” niga. ");
INSERT INTO qxl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusga Paibuj yachagujkunaj ñaubukimi kutin shuj tauga pish na ruri pudishka rikuchinagunada ruruga. Kai librobiga na tukiguna escribishka tiyanchu. ");
INSERT INTO qxl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ashtanbish Jesusta Cristo gashkadash Diosbuj Churi gashkadash kanguna crichun, shinalladi Paida crishami na tukurij kausida charichun kaigunadaga escribishka gan. ");
INSERT INTO qxl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chi k'ipa Jesusga Tiberias shuti yaku kucha manyabimi Paibuj yachagujkunamu kutinlladi rikuriga. Chibiga kashnami tukuga. ");
INSERT INTO qxl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jesusbuj yachagujkunapuramunda Simón Pedrosh, Ishkipura Wacharishka nishka Tiumash, Galilea llaktabi gaj Caná pueblomunda Natanaelbish, Zebedeoj churigunash, shinaidi ishkigunashmi chibi tandanukushka gaga. ");
INSERT INTO qxl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Chimunda Simón Pedroga, “Chaulagunada japingumi rini,” niki, paigunaga, “Ñukuchikish kangunmi rigunchi,” nigaguna. Shina ninukushaga shuj uchilla barcabimi sikusha rigaguna. Chi tutaga shuj chaulaidash na japigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ña p'unllayamugukimi Jesusga yaku kucha manyabi rikuriga; shinash yachagujkunaga Jesús gashkadaga na rijsigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chimunda Jesusga Paibuj yachagujkunada, “Maraguna, ¿chaulada nachu japishkanguichi?” nisha tapuki, “Na,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Shina niki Jesusga, “Barcaj alli ladumu chaula japinada piguichi. Chimi chaulagunada japinguichi,” niga. Shina nishkada rurashka k'ipaga taugalladi chaulaguna tiyashkamundaga chaula japinada llujshichingukish na pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chimunda Jesús pachun k'uyushka yachagujka Pedromu, “¡Manduj Jesús gashkandi!” niga. Shina Manduj gashkada uyun Simón Pedroga na churanada churarishka gashkamundaga chi ratu churanada churarisha yakumu waigugallami. ");
INSERT INTO qxl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chaishuj yachagujkunaga yaku manyamunda patsuj (100) metro shinallada karubi gashkamundami chaula japinada barcabi aisusha yaku manyamu chayamugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Paiguna barcamunda pambamu uriyashaga nina katichishkabi shuj chaula paltushka kusarigujta shinaidi tandash tiyajtami rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chibimi Jesusga, “Kununlla japishka chaulagunamunda ashada apamichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Shina niki Simón Pedroga barcomu sikusha chaula japinada jatun chaulagunan jundada yaku manyamu aisamuga. Patsuj pichka chunga kinsa (153) chaulaguna gaga; taugalladi gakish chaula japinaga na llikirigachu. ");
INSERT INTO qxl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chimunda Jesusga, “Shamichi mikungu,” niga. Manduj Jesús gashkada yachushkamundaga maijinllash, “¿Kanga pidi gangui?” nisha tapungumallash manchagagunami. ");
INSERT INTO qxl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chi k'ipa Jesús kuchuyashaga tandada japisha shinaidi chauladash paigunamu kuga. ");
INSERT INTO qxl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús wañusha kausarishka jawaga kaigunga kinsa kutinmi Paibuj yachagujkunamu rikurishkaga. ");
INSERT INTO qxl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mikusha tukuchishka k'ipa Jesusga Simón Pedroda, “Juanchuj churi Simón, ¿paiguna Ñukada k'uyushkadash yallichu k'uyangui?” nisha tapuga. Shina niki Pedroga, “Ari, Mandujlla; ñuka Kanda k'uyushkada yachunguimi,” niga. Chimunda Jesusga, “Ñukaj malta ovejagunada michingui,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kutinlladi Jesusga, “Juanchuj churi Simón, ¿Ñukada k'uyanguichu?” nisha tapuga. Chimunda Pedroga, “Ari, Mandujlla; ñuka Kanda k'uyashkada Kanlladi yachunguimi,” niga. Shina niki Jesusga, “Ñukaj ovejagunada michingui,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kaigunga kinsa kutin Jesusga, “Juanchuj churi Simón, ¿Ñukada k'uyanguichu?” nisha tapuga. “¿Ñukada k'uyanguichu?” nisha kinsa kutin tapushkamunda Pedroga llakilladi, “Mandajlla, Kanga tukidami yachuj gangui. Shinusha ñuka Kanda k'uyashkadash yachunguimi,” niga. Chimunda Jesusga, “Ñukaj ovejagunada michingui. ");
INSERT INTO qxl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kabishkadadimi nini, kan chairijti gashaga kan munushkamu ringujka kanlladi churanadash churarijmi gagangui; ashtan ña yuyij tukushaga makidami rikuchingui, shinusha churanadash shujmi churachinga, shinaidi kan na munushkamumi pushusha ringa,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kashna nishaga Jesusga Pedro ima laya wañunashkada shinaidi pai shina wañusha Diosta k'uilla gashkada rikuchinashkadami parlaguga. Chi k'ipa Jesusga, “Ñukada katimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro washamu vueltush rikushaga Jesús pachun k'uyashka yachaguj katimugujta rikuga. Paimi chi Pascua mikunabi Jesusbuj ladubi kimirisha, “Mandajlla, ¿pidij Kandaga shujkunamu japichinga?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Paida Pedro rikushaga, “Mandaj, ¿paiga ima tukunga?” nisha Jesusta tapuga. ");
INSERT INTO qxl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Shina tapuki Jesusga, “Ñuka shamungama paidaga kausachun nikish kanga ¿ima ninadadi charingui? Kanga Ñukada kati,” niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Shina nishkamundami crijkunapurabi chi yachagujka na wañuna gashka parlu uyariga. “Paiga na wañungachu,” nishaga Jesusga na nigachu. Ashtangarin, “Ñuka shamungama paidaga kausachun nikish kanga, ¿ima ninadadi charingui?” nishami shina niga. ");
INSERT INTO qxl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chi yachagujka kai parlugunada yachi chayachij shinaidi kaida escribijlladimi gan. Paiga kabishkada parlagushkadash yachanchimi. ");
INSERT INTO qxl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesusga shujtij ruranagunadash pachunmi ruraga. Imalla rurashkagunada shuj shuj kallarisha escribisha nikiga tuki escribina gaj librogunada tuki kai pachabi churangujka na p'aktanmuchu yuyanimi.");
INSERT INTO qxl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","K'uyashka Teófilo, kallarimunda jawa pachamu ichiyana p'unllagama Jesús tuki imalla rurashkada yachachishkadash kallari librobi ñami escribishkani. Narij rishaidi Diosbuj Espíritu yuyida kuki Paibuj agllusha kachashkagunamu ima rurana gashkada yachachiga. ");
INSERT INTO qxl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Llakichisha wañuchishka k'ipash Pai kausashkadadi rikuchun tuki layada rurasha paigunaj ñaubuki rikurishami chusku chunga (40) p'unllada paigunamu Diosbuj mandana ima laya ganashkada parluga. ");
INSERT INTO qxl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pai agllushkagunan mikushaidimi, “Jerusalén pueblomunda ama rishalla kangunamu nishka shina Ñukaj Taita <Kushami> nishkada chapanguichi. ");
INSERT INTO qxl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yakullanmi Juanchuga bautizaga, ashtangarin asha p'unllaguna k'ipaga Diosbuj Espiritunmi bautizashka ganguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesuskun tandanukushkagunaga, “¿Mandaj, israelguna mandanadaga kununlladichu kutin churash ningui?” nisha tapukimi ");
INSERT INTO qxl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesusga, “Ima p'unlla, ima ura, Ñuka Taita rurusha nishkada kanguna yachanaga na kabinchu. Paillami ima urash rurunada agllanga. ");
INSERT INTO qxl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ashtan Diosbuj Espíritu kangunamu shamuki tuki imadash ruri tukunguichillami. Chimundaga kangunaga Ñukamunda Jerusalenbi, tuki Judea llaktabi, Samaria llaktabi, tuki karu llaktagunabish parlungu llujshinguichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Shina nishka k'ipa paiguna rikuki Jesusga jawamu pushushka gasha p'uyubi chinguga. Chimunda kutinga Paida na rikugagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús ichiyajta rikuriaki ñash paigunaj kuchubi yurujlla churushka ishki k'ariguna rikurishaga, ");
INSERT INTO qxl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilea llaktamundaguna ¿ima nishadi ichimu rikurianguichi? Kangunaj kuchumunda jawa pachamu pushushka Jesuslladi ichiyaj layaidi kutin shamungami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chi k'ipaga Jesusbuj agllushkagunaga Olivos shuti urkumunda Jerusalén pueblomu kutin shamugaguna. Chi urkuga Jerusalenmunda samana p'unlla purina vali karumiga. ");
INSERT INTO qxl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalenmu chayashaga paigunaga pozadada mañusha tiyashka wasi jawa altumumi sikugaguna. Chibi tandanukujkunaga kaigunamiga: Pedro, Jacobo, Juanchu, Andiku, Felipe, Tiuma, Bartolomé, Mateo, Alfeobuj churi Jacobo, Simón Celote nishka, Jacoboj churi Judasbish. ");
INSERT INTO qxl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Paigunaga shuj warmigunan, Jesusbuj mama Marian, Paibuj waukigunandij, shuj shinalla tukusha tandanukusha Diosta mañagujllagunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chi p'unllagunaga patsuj ishki chunga (120) shina crijkunami tandanukuga. Paigunan gashami Pedro shayarishaga kashna niga, ");
INSERT INTO qxl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wauki paniguna, Davidbuj shimimunda Diosbuj Espíritu parlachiki Paibuj Shimi nishka shinaga Jesusta japichingu pushuj Judasmunda nishkaga p'aktanadimi gaga. Shinushami Judasga Jesusta japichingu pushuga. ");
INSERT INTO qxl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Paish ñukuchipuramunda gasha Diosbujta rurangu puriga. ");
INSERT INTO qxl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Jesusta japichishkamunda pagushka kuchkinga achpadami randiga. Pai millida rurushkamundami chi achpallabidi jawamunda uma satisha tigrusha iksa tugyuki puzunguna tsirapariga. ");
INSERT INTO qxl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Shina tukushkada tuki Jerusalenbi kausujkuna yachushaga chi achpadaga Acéldama nishami shutichigaguna. Acéldama nishaga paigunaj arameo shimibiga <Yaur Pamba> nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Salmos escribishkabiga: ‘Pai kausushka wasi shitushka sakirichun pish ama kausachun.’ ‘Pai ruranada shuj japirichun’ nishkagunashmi tiyan. ");
INSERT INTO qxl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Shinusha sarunmunda kunun p'unllagama ñukuchin igulda Mandaj Jesuskun purijkunamunda shujta Judasbuj randi churangaj agllanami ganchi. ");
INSERT INTO qxl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Agllashkaga Jesusta Juanchu bautizashkamunda jawa pachamu rishkagama rikujmi. Chi rikujkunapuramunda shujta Jesús kausarishkamunda ñukuchin parluj tukuchun ministinchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Shinushami paigunapuramunda ishkida aglluga: Justo nishka Barsabás shuti Jozidash Matikudash. ");
INSERT INTO qxl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ishkida agllushka k'ipaga, “Manduj, Kanga tukigunaj shungudami rijsingui. Judas juchada rurusha wañushaga pai rinashka pushtumu rishkamunda Kan rurachun mandashkada rurungaj shuj japirichun kai ishkindijmunda Kan agllashka maijindikun yuyida kubai,” nisha Diosta mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Shina mañushka k'ipa sorteoda rurukiga Matikujmi urmuga. Shinami paiga chunga shuj (11) agllashkagunan tandanukuga. ");
INSERT INTO qxl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés nishka pishta chayukiga tuki crijkunami shuj pushtullabi tandanukusha tiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ñash jawa pachamunda manchanai waira wakashka laya, paiguna tiyashka wasi illijtabi uyariga. ");
INSERT INTO qxl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Diosbuj Espíritu nina k'alluguna shina rikurishami paigunaj jawabi partirisha tiyariga. ");
INSERT INTO qxl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tukiguna Diosbuj Espíritu jundashka gashaga Espíritu parlachishka shina shuj shimigunabi rimaringu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chi p'unllagunaga Diosta yuyarij israelgunami tuki llaktagunamunda shamusha Jerusalén pueblobi tiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chi waira gulun nijta uyusha rikungu taugaguna tandanukushaga kikinbuj shimigunabi rimarijta uyushkamundami ima tukugushkada na yuyari pudigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kushiyashka mancharishka na crillabuj gashkamundaga, “Kai shimigunada nigujkunaga ¿nachu Galilea llaktamunda gan? ");
INSERT INTO qxl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Shinash ¿imashti ñukuchij shimigunabi rimarigujta uyanchi? ");
INSERT INTO qxl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kaibiga, Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO qxl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, Cirene kuchu Libiamunda Romamunda shamujkunashmi tiyan. ");
INSERT INTO qxl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Shujkunaga wacharimundadi israelguna, chaishujkunaga israel tukushkagunallami, Creta islamunda Arabia llaktamundagunashmi ganguna. Dios imalla k'uilla rurushkada ñukuchij shimibi rimarijtami uyuganchi,” nisha ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Shina tukiguna mancharisha imada na yuyari pudishaga, “¿Kaiga imadikun?” nisha tapunukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Shujkunaga, “Paigunaga shingagunami gan,” nisha asigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jesús agllushka chaishuj chunga shuj (11) agllashkagunandij shayarisha Pedroga jinchida rimarisha, “Ñukuchij israelpuraguna, tuki Jerusalenbi kausujkuna, kaida yachachichun sakichi, ñuka nishkada alli uyabaichi. ");
INSERT INTO qxl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na kanguna yuyashka laya paigunaga na machashkagunachu; chairij iskun uras tutamundallami gan. ");
INSERT INTO qxl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ashtangarin Dios nishkada parlaj Joel kashna nishkami p'aktagun, ");
INSERT INTO qxl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Diosga kashnami nin, tukuri p'unllagunabiga tukigunamumi Ñukaj Espirituda tallij shina kusha. Kangunaj churi ushigunash Ñuka ima ruranada ninga. K'ipa iñajkunash ñuka ima rikuchinashkadash rikungami. Yuyijkunash suñungami. ");
INSERT INTO qxl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Shinalladi Ñukada sirvij k'ari warmigunamush chi p'unllagunami Ñukaj Espirituda tallij shina kuki Ñuka ima ruranada ningaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jawa cielobi k'uilladi mancharinagunadash rikuchisha, kai pachabi pish na rikuchishkagunadash rurukimi, yaurda, ninada, p'uyu kushnidashmi rikunguichi. ");
INSERT INTO qxl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mandujbuj k'uilla jatun alli p'unlla narikish chayamujllabidimi indish ansayanga, lunash yaur shina tukunga. ");
INSERT INTO qxl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Shinakish Mandujbuj shutibi kayusha tuki mañujkunallami kishpichishka ganga.’ ");
INSERT INTO qxl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Uyichi, israelguna. Diosga Nazaretmunda Jesús pish na rikushkada, pish na ruri pudishkada, k'uilladi mancharinagunada rurachisha kangunapurabi rikuchiga. Chidaga kangunaidi allimi yachunguichi. ");
INSERT INTO qxl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Chidaga Diosga shina tukuchun munusha ñaubamundimi ima shina ganadaga allimi yachaga; chimundami kangunaga millida rurujkunamu japisha kusha chakatasha wañuchiganguichi. ");
INSERT INTO qxl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Shina gakish wañi ña na mandusha charina gashkamundami Diosga Jesustaga wañi nanimunda llujshichisha kausachiga. ");
INSERT INTO qxl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Rey Davidbish Jesusmunda kashnami niga, ‘Ñukaj Mandujtaga tuki p'unllagunami ñukaj ñaubuki rikugani. Pai ñukaj alli ladubi tiyakiga pish na urmachi pudingachu. ");
INSERT INTO qxl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Chimunda ñukaj shunguga kushiyan. Shiminbish kushilladi cantani. Wañushkagunaj pambushkabi ñuka gachun Kambuj jucha illujbujta ismuchunbish na sakina gashkamunda tuki ñukaj yuyigunaga Kandami crisha chapanga. ");
INSERT INTO qxl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Alli kausana ñangunadami yachachigangui. Ñukada Kambuj ñaubukiga ashtan kushiyachinguimi.’ ");
INSERT INTO qxl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Wauki paniguna, ñuka laru parlachun sakibaichi. Ñukuchij ñauba taita David wañukiga paida ut'kubi churugaguna. Paibuj ut'kuga kunungama kaillabidimi gan. ");
INSERT INTO qxl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidga Dios nishkada parluj gashami Dios <P'aktachishami> nishkamundaga paibuj wawagunaj wawagunamunda jatun manduj tukunada yachuga. ");
INSERT INTO qxl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidga rikuj layami kishpichij Cristo kausarinashkadaga <Paibuj almash na pambushkabi sakiringachu, aichash na ismungachu> niga. ");
INSERT INTO qxl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chi Jesuslladadi Diosga kausachishkami; shina tukushkadadimi tukiguna rikuganchi, uyuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Diosga Paibuj alli ladubi tiyarichunmi Jesusta kausachiga. Taita Dios <Kusha> nishka Paibuj Espirituda japishami Jesusga ñukuchimu tallij shina kushka. Chiga kanguna rikugushka uyugushkami gan. ");
INSERT INTO qxl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Davidga na jawa pachamu rigachu. Shinash pailladimi kashna niga: ‘Manduj Diosga ñukada Mandajta niga, “Kanda na rikunachijkunada ñuka kambuj chaki sarunabi churungama ñukaj alli ladubi tiyari.” ’ ");
INSERT INTO qxl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Tuki israelguna, kanguna cruzbi wañuchichun mandashka Jesuslladadimi Diosga Mandujta Cristodash rurushkada alli alli yachichi,” nisha parlaga. ");
INSERT INTO qxl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chibi gajkuna kashna nishkada uyusha shungubi manchanai llakirishami Pedroda chaishuj agllashkagunadash, “Waukiguna ¿imadadi rurana ganchi?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Shina tapuki Pedroga, “Juchagunada sakisha Diosmu vueltarisha Jesucristobuj shutibi bautizarichi. Shinami kangunaj juchagunada Dios perdonasha Paibuj Espiritudash kunga. ");
INSERT INTO qxl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kai <Kusha> nishkadaga kangunamu, kangunaj wawagunamu, karubi kausujkunamush tuki mashnalla ñukuchij Manduj Dios kayusha agllashkagunamumi kunga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kai nishkan shujti nishkagunanbish Pedroga, “¡Kai milli gajkunan llakichishka ganamunda kishpirichi!” nisha yachachiguga. ");
INSERT INTO qxl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Shinami pai nishkada kazujkunaga bautizashka gaga. Chi p'unllaga chaishuj crijkunan kinsa waranga (3.000) shina tandanukuga. ");
INSERT INTO qxl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jesusbuj agllashkaguna yachachishkadaga tukigunami alli jinchida katisha, alli apanukusha, Diosta mañusha tandada chaubisha mikungu tandanukujllagunaga. ");
INSERT INTO qxl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesusbuj agllushkaguna tauga pi na rikushkadash pi na ruri pudishkagunadash rurusha rikuchiki tukigunami manchanai mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tuki crijkunami shuj shinalla tandanukusha, ima charishkadash kunukusha kausugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Paigunaj achpada ima charishkadash k'atusha, maijin ministikish mashna ministishkada tukigunamu kuga. ");
INSERT INTO qxl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","P'unllandijtami israelgunaj Diosbuj wasibi tandanukugaguna. Paigunaj wasigunabish tandanukusha tandada chaubisha kushiyasha alli shungun mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diostaga <Allimi gangui> nij crijkunaga tukiguna <Alliguna> nishkamiga. Mandujka Pai kishpichigushkagunada p'unllandijta tandanukushka crijkunan mirachiga. ");
INSERT INTO qxl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Shuj p'unlla tardi kinsa urasta Diosta mañana uras gashkamundaga Diosbuj wasimu Pedroga Juanchundij rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wacharishkamunda pacha suchudaga tuki p'unllagunami mashnalla chimu waigujkunada kuchkida mañasha tiyachun Diosbuj wasibi tiyaj K'uilla nishka pungumu shujkuna pushusha rigujllagunaga. ");
INSERT INTO qxl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro, Juanchundij Diosbuj wasi ukumu waigujta rikusha suchuga imaidash kumbidachun mañuga. ");
INSERT INTO qxl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedroga Juanchundi paida alli rikusha, “Ñukuchida riki,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Suchuga imalladash japinada yuyasha rikuriaga. ");
INSERT INTO qxl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ashtan Pedroga, “Ñukaga kuchkida kuridash na charinichu. Shinash ñuka charishkaidami kuni. Nazaretmunda Jesucristoj shutibi jatarisha puri,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro chi k'arida alli makimunda chutusha jatarichinmi chakiguna chaki mukugunash jinchiyaki ");
INSERT INTO qxl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ñash jawalla shayarisha puringu kallariga. Chi k'ipaga Diosta <Allimingui> nisha, saltasha, paigunada katisha, Diosbuj wasimu waiguga. ");
INSERT INTO qxl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Shina Diosta <Allimingui> nijta purijtash tukigunami rikuga. ");
INSERT INTO qxl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","K'uilla nishka pungubi kuchkida mañush tiyaj k'arida rijsijkunaga ña purijta rikusha kushilla pachun mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Alliyachishkaga Pedroda Juanchudash na kachariki tukigunaga Diosbuj wasi Salomonbuj Corredorbi shayajta rikushami manchanaidi mancharisha rikungu ut'kalladi kuchuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro chida rikusha kashna niga, “Israelguna ¿imasha kai tukushkamunda mancharinguichi? ¿Imamunda ñukuchida rikurianguichi? Kai k'aridaga na ñukuchij rurajkun na ñukuchi Diosta alli katishkamunda alliyashkachu. ");
INSERT INTO qxl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñukuchij ñauba taitagunaj Abrahambuj Isaacbuj Jacob-buj Diosmi Paibujta ruruj Jesús k'uilla nishka gachun kachaga. Kangunalladimi Jesustaga mandajkunajmu pushuganguichi. Pilato Paida kacharisha nikish kangunaga na sakiganguichichu. ");
INSERT INTO qxl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jucha Illij, kabishkada Ruruj Jesusta kacharichun nina randiga wañuchijta kacharichun mañaganguichi. ");
INSERT INTO qxl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kausida Kujtami wañuchichiganguichi, ashtan Diosga wañushkagunapuramunda Paida kausachigami. Chida rikujkunami ganchi. ");
INSERT INTO qxl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Chi Jesuslladimi Paibuj shutida crishkamunda kanguna rikushka rijsishka suchudaga jinchiyachishka. Jesús crina yuyida kuki crishkamundami kangunaj ñaubuki linshu alliyashka shayan. ");
INSERT INTO qxl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Kununga waukiguna, kangunash kangunaj llaktada mandajkunash na yachashalla rurashkada yachanimi. ");
INSERT INTO qxl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Shinakish Diosga kai laya Paibuj nishkada tuki parlujkunabuj nishkabi Cristoda llakichinada parlashkadaga p'aktachishka. ");
INSERT INTO qxl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Shinusha juchagunada sakisha Dios kangunaj juchada p'ichachun Paimu vueltichi Mandujmunda kushiyana p'unllaguna shamuchunbish ");
INSERT INTO qxl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","kangunamu agllashka Cristoda Jesucristolladijta kachachunbish. ");
INSERT INTO qxl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ñaubamundadi Diosga <Tukida mushujyachishami> nisha Pai nishkada parluj linshuyachishkagunamu parlachiga. Mushujyachingama Jesús jawa pachabi gana ministirinlladimi. ");
INSERT INTO qxl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ñukuchij ñauba taitagunadami Moisesga kaida nishkaga, ‘Kangunada Mandaj Diosga ñukada layaidimi kangunapuramunda Dios nishkada parlujta agllunga. Pai tuki ima nishkada kazunguichi. ");
INSERT INTO qxl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Maijin kai Dios nishkada parlujta na kazujka Diosbujkunamunda llujshichishtashkaminga.’ ");
INSERT INTO qxl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samuelmunda kallarisha Dios nishkada tuki parlujkunashmi kai p'unllaguna chayamunada parluga. ");
INSERT INTO qxl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dios nishkada parlajkunamu Dios <P'aktachishami> nisha nichishkada kangunaj ñauba taitagunamush ari ninukushkadash japinguichi. Shinushami Diosga Abrahamda, ‘Kambuj wawagunaj wawagunamunda tuki kai pachabi kausujkuna kushiyachishkash alligunada japishkash ganga,’ nishkami. ");
INSERT INTO qxl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Diosga Paibujta Rurujta jatarichishaga kallaribi kangunajmundi alligunada kuchunmi milli rurushkagunamundash anchuchichun kachuga,” nisha parlaga. ");
INSERT INTO qxl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedroga Juanchun chibi gajkunamu parlagujllabidimi curagunaga Diosbuj wasida chapujkunada mandujkish saduceogunash chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paigunaga <Jesús kausarishaga wañushkaguna kausarinadami rikuchiga> nisha yachachishkamundami paigunan p'iñarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chimunda japisha rishaga tutayagushkamunda kayundijgama carcelbi churugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Shinash paiguna nishkada uyusha taugaguna crisha mirariga. Pichka waranga (5.000) shinami gaga. ");
INSERT INTO qxl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kayundij p'unllaga israelgunada mandujkuna yuyijkuna Moisés mandashkada yachachijkunash Jerusalén pueblobi tandanukuga. ");
INSERT INTO qxl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Shinaidi jatun manduj cura Anasbish Caifasbish Juanchush Alejandrosh jatun mandaj curaj familiamunda chaishujkunashmi chibi gagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedrodash Juanchudash pushusha tukij chaubibi churushami, “¿Pi manduki pibuj shutibidi kangunaga kaigunada rurunguichi?” tapungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Diosbuj Espíritu jundashka gashami Pedroga kashna niga, “Israelgunada mandujkuna yuyijkunash, ");
INSERT INTO qxl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kangunaga shuj ungushkada alliyachijta rikushami ima laya alliyachishkada yachungaj tapunguichi. ");
INSERT INTO qxl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kangunash tuki israelgunash yachachunmi kaida ninchi: Kaibi shayajka Nazaretmunda Jesucristoj shutibimi alliyachishka gaga. Chi Jesuslladadi kanguna chakatasha wañuchishka k'ipa Diosga kausachiga. ");
INSERT INTO qxl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesusga ‘wasichijkuna na munusha shitushka rumimi, ashtan kallarimu churana rumimi tukushka.’ ");
INSERT INTO qxl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Paillamundadi kishpichishkada japinchi. Jesusbuj shutillabi kishpichina tiyanmi; shujbuj shutibi kishpichina mana tiyanchu,” nigami. ");
INSERT INTO qxl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pedrosh Juanchush yachana wasimu na rijkuna gashash na manchushalla rimarijta rikushami mandujkunaga mancharisha Jesuskun gashkada cuenta kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Alliyachishkash paigunan chibi gashkamunda imadash na juchachi pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chimundami israelgunada mandujkuna tandanukushkamunda paigunada llujshichun mandusha mandujkunapura kaishuj chaishuj parlanukusha sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Kai k'arigunadaga ¿imadadi rurashun? Tuki Jerusalenbi kausujkunaga paiguna alliyachishkada yachunmi. <Na shina rurugagunachu> ningujka na ni pudinchichu. ");
INSERT INTO qxl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Paiguna alliyachishkada shimi shimi ama yachachun <Kutin Jesusbuj shutida parlukiga llakichishunmi> nisha manchachishunchi,” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chimunda kutin ukumu kayusha <Kutinbujka kununmundaga amalladi Jesusbuj shutida parlusha yachachisha puringuichichu> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Shina nikimi Pedrosh Juanchush, “¿Diosbuj ñaubuki alli ruranachu Paida kazuna randiga kangunadachu kazuna alli ganga? Chidaga kangunalladi yuyarichiri.” ");
INSERT INTO qxl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","“Ñukuchi rikushkada uyushkadash na upalla sakiri pudinchichu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mandujkunaga <Kanguna kutin shina rurukiga llakichishunmi> nisha manchachisha kacharigaguna. Tukiguna alliyachishkada rikusha Diosta <Allimi gangui> nishkamunda paigunada na llakichi pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pish na alliyachingu pudishka alliyachishka k'ariga chusku chunga (40) yalli watadami chariga. ");
INSERT INTO qxl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedrosh Juanchush kacharikiga paigunan purijkunajmu rishaga manduj curagunash yuyijkunash tuki ima nishkada yachi chayachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kaida uyushka k'ipaga tukigunami tandanukusha Diosta, “Tukida manduj Dios, Kanmi jawa pachada kai pachada yakudash tuki imalla maibi tiyajkunadash rurushkangui. ");
INSERT INTO qxl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kambujta ruraj ñukuchij taita Davidbuj shimimunda Kambuj Espirituda parlachigangui, Na israelgunaga ‘¿imasha p'iñalla kaparisha tandanukun? ¿Imashti na valij ruranagunada yuyaringuna? ");
INSERT INTO qxl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kai pachada jatun mandajkuna llaktagunada mandajkunash tandanukusha takungu yuyasha Mandujtash Cristodash p'iñanguna.’ ");
INSERT INTO qxl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","28","Kashna nishka shinami Kan agllusha kachashka, Kambujta ruruj na juchayuj Jesusta p'iñusha na rikunachisha ñaubamundadi Kambuj munushkan ruri pudishkanbish Kan <Kai tukiguna p'aktungami> nishkada rurangu Herodesga Poncio Pilatondij na israelgunash israelgunash kai pueblobi tandanukuga. ");
INSERT INTO qxl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mandaj, kununga paiguna <Llakichishunmi> nishkada yuyarisha Kan nishkada rurujkunamu Kambuj shimida ama manchushalla parlachibai. ");
INSERT INTO qxl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Alliyachingu Kambuj makida chutasha churangui. Kambuj mandushkada ruruj na juchayuj Jesusbuj shutibi pi na ruri pudinagunadash mancharinagunadash rikuchichun kubai,” nishami mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Diosta mañushka k'ipa chi tandanukushkabi achpa kuyukiga tukiguna Diosbuj Espíritu jundushka gashami na manchushalla Diosbuj Shimidaga tukigunamu parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Taugaguna gashash tuki crijkuna shuj shungullan shuj yuyillanbish gasha ima charishkadash tukigunamu kunukusha maijinbish <Kaigunaga ñukajllami> na nijkunachuga. ");
INSERT INTO qxl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Manduj Jesús ima laya kausarishkadami Pai agllushkagunaga tukigunamu shungumu waigujta parlusha katigaguna. Shinami tukigunamu Diosga tuki laya alligunada kuga. ");
INSERT INTO qxl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Shinusha paigunapuramunda imadash ministijka illaga. Achpada wasida imalla charishkada k'atushash kuchkida apushaga ");
INSERT INTO qxl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesús agllushkagunamu kugaguna. Paigunami mashna ministishkada maijin ministijmu kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chipre islamunda Jozi nishka levitash shinami ruruga. Paidami Jesús agllushkagunaga Bernabé nisha shutichigaguna. (Kai shutiga <Kushiyachij> nishkami gan.) ");
INSERT INTO qxl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Pai charishka achpada k'atushami kuchkidaga Jesús agllushkagunaj makibi kuga. ");
INSERT INTO qxl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananiasmi paibuj warmi Safirandi achpada k'atuga. ");
INSERT INTO qxl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Paiga warmindij ari ninukusha achpa k'atushka kuchkimunda wakichisha tukida apush kuj layami Jesús agllushkagunamu kuga. ");
INSERT INTO qxl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro niga, “Ananías ¿imashadi kambuj shungubi Satanás waiguchunga sakigangui? Diosbuj Espiritumu llullasha achpa k'atushka kuchkida ¿imashti na tukida kugangui? ");
INSERT INTO qxl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Achpaga nachu kambujkuga? ¿K'atushka kuchkish nachu kambujkuga? ¿Imashti shina rurungu yuyarigangui? Na ñukuchillamu ashtangarin Diosmumi llullashkangui.” ");
INSERT INTO qxl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Shina nijta uyushaga Ananiasga urmun wañugallami. Shina tukushkada yachajkunaga pachun mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chibi k'ipa iñaj k'ariguna shamushami Ananiasbuj cuerpoda pilluchisha pambungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kinsa uras k'ipa shinabi Ananiasbuj warmi, kusa ima tukushkada na yachushalla waigukimi ");
INSERT INTO qxl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedroga, “Parli. ¿Kangunaj achpada chillabichu k'atuganguichi?” nisha tapuki, “Ari, chillabimi k'atuganchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Shina niki Pedroga, “¿Imashadi ishkindij <Allimi> ninukusha <Mandajbuj Espirituga na yachangachu> yuyisha llullaganguichi? Riki, kambuj kusada pambungu rijkunaga ñami shamugun. Kununga paigunaidimi kandash pambungu ringaguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Shina ninmi Pedroj chaki ñaubujllabidi urmusha Safirash wañugallami. Pambusha shamujkuna waigushaga wañushkada japisha kusaj kuchullabidi pambungu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tuki tandanukushka crijkunash ima tukushkada uyujkunashmi pachunlladi mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesús agllushkagunami chibi gajkunaj ñaubuki pish na ruri pudishkagunada na rikushkagunadash rurusha rikuchigugaguna. Shinushami tuki crijkunaga shuj yuyillan Salomonbuj Corredorbi tandanukujkunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Chibi kausujkuna paigunada alli alli k'uyasha yalli valichikish manchashkamunda pish paigunan tandanukunada na munagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ashtanga k'ariguna warmigunash Mandaj Jesusta crish katisha mirarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Taugagunami Pedro pasaki paibuj llandullash alliyachichun yuyashami ungushkagunada wandumushkagunallabidi llujshichisha ñanbi churugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kuchulla pueblogunamunda taugagunami ungushkagunadash yana katishkagunadash pushusha Jerusalén pueblomu shamuki tukiguna alliyachishkamiga. ");
INSERT INTO qxl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Shinami jatun manduj cura tuki paiyun gaj saduceogunash manchanaidi p'iñarishaga ");
INSERT INTO qxl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","agllushkagunada japisha jatun carcelbi churuki ");
INSERT INTO qxl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mandaj kachushka ángel tuta shamusha cárcel punguda paskusha ishkigunada llujshichisha kashna niga, ");
INSERT INTO qxl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Shujkunamu kai mushuj kausimunda illijta parlungu Diosbuj wasimu richi.” ");
INSERT INTO qxl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Narij alli p'unllayajllabidi ángel nishka shinami Diosbuj wasimu risha yachachingu kallarigaguna. Jatun manduj curaga paiyun gajkunash chayashaga israelmunda yuyijkunada israelgunada mandujkunapura tandanukungajmi kayuga. Jesús agllushkagunadash carcelmunda pushamuchun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Guardaguna carcelmu risha paigunada na japishaga parlungu kutin shamugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Cárcel pungush alli ichkushka, guardagunash pungubi chapajtami japinchi. Shinakish punguda paskusha ukubiga pidash na japiganchichu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chida uyushaga Diosbuj wasida guardagunada mandujkish manduj curagunash <¿Imashi tukungaguna?> nisha tapunukuga. ");
INSERT INTO qxl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Shujka shamushami, “Kanguna carcelbi churushkagunaga Diosbuj wasibimi yachachigunguna,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Shinakiga manduj guardaga guardagunanbish mashkungu riga. Chibi gajkuna rumigunan piganada manchushkamundami imadash na rurushalla paigunada pushamuga. ");
INSERT INTO qxl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Israelgunada mandujkunapura tandanukushkaj ñaubujmu pushusha chayukiga jatun manduj cura kashna niga, ");
INSERT INTO qxl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ <Jesusbuj shutibi p'akta imadash yachachinguichimu> niganchindi. ¿Imadadij kangunaga rurushkanguichi? Tuki Jerusalenbimi yachachishkanguichi. Shina rurushka jawash Paida wañuchishkadash ñukuchilladadij juchachigunguichi.” ");
INSERT INTO qxl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedrosh chaishuj agllushkagunash kashna niga, “Ñukuchiga kangunada kazuna randiga Diostami kazuna ganchi. ");
INSERT INTO qxl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ñukuchij ñauba taitagunaj Diosmi kanguna cruzbi warkusha wañuchichun mandashka Jesuslladadi kausachiga. ");
INSERT INTO qxl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israelguna Diosmu vueltarisha juchagunada perdonashka gachun Diosga Paibuj podergun Jesustaga Jatun Mandujbuj Churi shinaidi Kishpichij gachun alli ladubi churashami jatunyachiga. ");
INSERT INTO qxl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Diosbuj Espiritush ñukuchish shina tukushkada yachusha parlujkunami ganchi. Diosga Paida kazujkunamumi Espirituda kuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Shina nijta uyajkunaga manchanaidi p'iñarisha, Jesús agllushkagunada wañuchichingu yuyarinukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Israelgunada mandujkunapura tandanukushkaj ñaubuki shayarisha Moisés mandushkada yachachij tukiguna alli nishka Gamaliel shuti fariseoga <Paigunada ratuwaida kanllamu llujshichichi> niga. ");
INSERT INTO qxl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Llujshichishka k'ipaga chaishuj mandujkunada kashna niga, “Israelguna, paigunada p'akta imadash ruranguichimu. Imada rurush nishash alli yuyaringuichi. ");
INSERT INTO qxl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sarungunami Teudasga jatarisha manduj tukusha <Jatunmi gani> nisha puriki chusku patsuj (400) shinaguna katiga. Shujkuna Teudasta wañuchikiga paida katijkunash kaida chaida risha chingarigallagunami. Tuki tukurigami. ");
INSERT INTO qxl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chi k'ipash shutigunada apuntachina p'unllaguna Galilea llaktamunda Judasbish jatarisha taugagunada katichisha puriga. Shujkuna paidash wañuchiga; tuki paida katijkunash kaida chaida rishami chingariga. ");
INSERT INTO qxl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Shinushami kai tukushkabi kangunada nini: paigunada sakichi, ama imadash rurichichu. Paiguna yachachigushkash imada ruragushkash paiguna yuyillamunda gashaga chingaringallami. ");
INSERT INTO qxl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ashtan Diosti yachachichun kachushkakiga kangunaga na chingachi pudinguichichu. P'akta kangunalladi Diosta vincisha nigushkada k'ipamu yachi chayanguichimu,” nikimi paida kazugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jesús agllashkagunada kutin kayusha azilgun dalishaga <P'akta kutin Jesusbuj shutibi yachachisha katinguichimu> nishami kacharish kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dios paigunada valichisha Jesusbuj shutimunda antes llakida apachun sakishkamundami Israelgunada Mandujkunapura Tandanukushkaj ñaubujmunda manchanaidi kushilla rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","<Jesusga Cristomi> nisha p'unllandijta Diosbuj wasibish kausana wasigunabish Alli Shimida yachachigujllagunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chi p'unllagunami agllashkagunadaga griegobi rimujkunaga yachagujkuna mirariki paigunaj viudagunamunga <P'unllandi karashkabi na alli chaubisha kun> nisha hebreo shimibi parlujkunamunda rimugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Shinaga chunga ishki (12) agllashkagunaga tuki yachagujkunada tandachisha kashna niga, “Ñukuchiga Diosbuj Shimida parlanada sakisha mikunada karanaga na allishkadami yuyanchi. ");
INSERT INTO qxl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Shinasha wauki paniguna, kangunapuramunda alli rijsishka, alli yachaj, Diosbuj Espíritu jundashka kanchiskunada agllichi. Mikunada chaubisha karachun paigunamu mingasha ");
INSERT INTO qxl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Diosta mañagusha Paibuj shimidash parlusha katigushunllami,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tuki crijkuna <Chi yuyiga allimi gan> nisha agllungu kallarishaga Diosbuj Espíritu junda gaj alli crij Ishtikuda shinaidi Felipeda, Procoroda, Nicanorda, Timonda, Parmenasta, Antioquía pueblomunda israel tukushka Nicolastashmi agllugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chi k'ipaga Jesús agllashkagunajmu pushusha riki paigunaga kanchiskunaj jawabi makida churashami Diosta mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Diosbuj Shimida parlush katikimi taugaguna Jerusalén pueblobi yachagujkuna tukusha mirariga. Israelmunda tauga curagunash crishkada kazugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ishtikuga Diosbuj tukida rurajllan Paibuj k'uyinbish gashami pish na ruri pudishkagunadash na rikushkagunadash israelgunapurabi rurasha rikuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Cirene shinaidi Alejandría pueblogunamunda Cilicia shinaidi Asia llaktagunamunda israelguna, Diosmunda yachana (Kacharishkagunaj nishka) wasibi tandanukujkuna jatarisha maijingunaga Ishtikun rimanukungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Diosbuj Espíritu alli yachashkada Ishtikumu kusha allida rimachiki paigunaga paiyunga na ch'imbapuri pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chimundami, “Moisesta Diostash imakish na valichij shimigunan rimajtami uyaganchi,” nichunmi shujkunamu kuchkida pakalla kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Shina llullashami gentegunada, yuyijkunada, Moisés mandushkada yachachijkunadash crichigaguna. Ishtikudaga japisha Israelgunada Mandujkunapura Tandanukushkajmu pushusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Shinaidi <Llullunguichi> nisha mandajkunamu pushamukimi llullajkunaga, “Kai Ishtikuga Diosbujlla gaj wasidash Moisés mandushkadash na valichisha rimanadaga na sakijchu. ");
INSERT INTO qxl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","<Nazaretmunda Jesusga Diosbuj wasida urmachisha Moisés ñukuchimu yachachishkagunadash sakichisha shujtijtami yachachisha tukuchinga> nijtami uyaganchi,” nigagunami. ");
INSERT INTO qxl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Israelgunada Mandujkunapura tuki Tandanukushkash Ishtikuj ñawida rikushaga angelbuj ñawida rikushka layaidimi rikugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jatun manduj curaga, “Kanda juchachigushkaga ¿shinaidichu gan?” nisha Ishtikuda tapukimi, ");
INSERT INTO qxl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","paiga kashna niga, “Waukiguna taitaguna, uyichi. Ñukuchij jatun k'uilladi Diosmi ñauba taita Abraham narikish Harán pueblobi kausungu risha Mesopotamia llaktabi gajllabidi rikurishami ");
INSERT INTO qxl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","kashna niga ‘Kambuj achpada, familiagunadash sakisha <Ñuka rikuchisha> nishka achpamu ri.’ ");
INSERT INTO qxl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chimundami Abrahamga Mesopotamiabi tiyashka Caldea llaktamunda llujshisha Haranbi kausungu riga. Paibuj taita wañushka k'ipami Diosga Abrahamda kunun kanguna kausashka achpamu pushamuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Shina pushamushash achpadaga chaki sarunaidash na kugachu. <Kan wañushka k'ipa kambuj wawagunaj wawagunamumi kusha> niga. (Chi p'unllagunaga Abrahamga narij marayujchuga.) ");
INSERT INTO qxl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Diosga shinaidi ‘Kambuj wawagunaj wawagunaga na rijsishka karu llaktabi kaususha chusku patsuj (400) watagunada esclavogunada rurushkash jinchi rurachisha takusha llakichishkami kausunga. ");
INSERT INTO qxl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sirvijta rurusha llakichij llaktada Ñuka llakichishka k'ipami chimunda llujshisha Ñukada <Alli k'uillami gangui> nisha kaibi kausunga,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Diosga Abrahamdaga paigun ari ninukushkada p'aktachingajka ‘K'ari llullu marada circuncisión nishkada rurachun’ nishami manduga. Shinushami paibuj churi Isaac wacharishka pusuj p'unllabi Abrahamga paibuj marada aicha karada p'itiga. Isaacbish paibuj churi Jacobda Jacob-bish paibuj churigunadash shinaidimi ruruga. Jacob-buj churigunaga Israelmunda chunga ishki (12) ñukuchij ñauba taitagunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Paigunaj wauki Jozida na rikunachishkamunda Egipto llaktamu pushuchun k'atusha kachugaguna. Shinash Dios Jozin gashami ");
INSERT INTO qxl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ima llakimundash llujshichisha Egipto llaktada manduj faraonmu alli rikurichun alli yuyigunada kuga. Chimundami faraonga paidaga Egipto llaktada k'ipa manduj gachun shinaidi paibuj wasibish mandujta ruraga. ");
INSERT INTO qxl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Chi p'unllagunabi Egiptobi Canaanbish yariji tukukimi manchanai llaki tukuga. Ñukuchij ñauba taitagunash chi llaktabi ima mikunash illashkamunda mikunada na japigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chimundami Jacobga Egiptobi mikuna tiyajta yachi chayusha paibuj churigunada kachuga. Chimu paiguna rishkaga kallarillamiga. ");
INSERT INTO qxl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kutin k'ipamu rikimi Joziga paigunaj waukishkadaga niga. Chibimi faraonga piguna Jozij waukigunadi gashkadash yachuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chi k'ipami Joziga paibuj taita Jacobda familiagunadash Egiptomu pushamuchun kachuga. Paigunaga kanchis chunga pichkapuramiga (75). ");
INSERT INTO qxl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Shinakimi Jacobga Egiptobi kausungu riga. Paish ñukuchij ñauba taitagunash chibi kausushka k'ipa wañugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jacob tullugunada Siquem shuti pueblomu apusha rishaga Abraham Hamorbuj churigunajta mirga kuchkin randishka ut'kubimi pambuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Dios, Abraham-mu <Kai llaktada kushami> nishka p'unllaguna p'aktamugukiga israelguna Egiptobi mirarisha taugagunami tukuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chi p'unllagunabimi mushuj jatun manduj Egiptoda mandungu kallariga. Paiga Jozidaga na rijsijchuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chi mandujka ñukuchigunada ñukuchij ñauba taitagunadash engañasha llakichisha, <Wacharishkalla k'ari maragunada shitusha wañuchun sakinguichi> nisha manduga. ");
INSERT INTO qxl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Chi p'unllagunami Moisesga wachariga. Diosta kushiyachij mara gakimi paibuj taita mamaga kinsa killagama pakushami paigunaj wasibi iñachiga. ");
INSERT INTO qxl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ashtan yakubi wambuchun sakiki Faraonbuj ushi japisha paibuj churida laya iñachiga. ");
INSERT INTO qxl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chimundami Moisesga egiptoguna yachachishka iñusha imadash rurajllan gasha rimarinabish ruranabish alli alli tukuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chusku chunga watada p'aktachishami Moisesga paigunapura wauki pani israelgunada rikungu munusha riga. ");
INSERT INTO qxl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Egiptomunda shujka israelda takujta rikusha Moisesga jarkungu risha takushkamunda p'iñarisha egiptoda wañuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisesga <Ñukaj wauki pani israelgunaga <Diosmi paidaga llakimunda llujshichichun kachushka> nisha yuyangagunami> nisha yuyaga. Shinash israelgunaga na yachagagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kayundikish Moisesga kutin ishki israelgunapura takanukujta japiga. Chigunadash jarkungu munasha kashna niga, ‘Kangunaga waukindijminguichi. ¿Imasha kangunapura takanukunguichi?’ ");
INSERT INTO qxl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Shina nikimi takagujka Moisesta t'angushtasha, ‘¿Pidij kandaga ñukuchida mandusha juez tukuchun churuga? ");
INSERT INTO qxl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Egiptoda kaina wañuchishka layaidichu, ñukadash wañuchisha ningui?’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Shina nijta uyushami Moisesga mitikusha Madián llaktamu riga. Chibimi karu llaktamunda chayuj shinalla kaususha kazarasha ishki marada chariga. ");
INSERT INTO qxl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Chusku chunga wata k'ipami Sinaí urku kuchu shitushka pushtubi zarza yura rupashkabi shuj ángel rikuriga. ");
INSERT INTO qxl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Shina rikuriki Moisesga mancharisha kushiyashash ashtan alli rikungu nisha kuchuyashami Manduj rimarijta uyuga, ");
INSERT INTO qxl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ñukaga kambuj ñauba taitagunaj, Abrahambuj, Isaacbuj, Jacob-buj Diosmi gani.’ Shina niki Moisesga rikunadash mancharisha ch'ujchuringu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Shinushami Mandujka ‘Kambuj chakimunda pargatida surki. Kan sarushka achpaga Diosbujlla gashkamunda ima mapash illujmi gan’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","‘Egiptobi tiyaj Ñuka agllashkaguna llaki apagushkada rikugani. Jiguigujtash uyuganimi. Shinusha llakimunda llujshichingajmi shamugani. Shami kandaga Egiptomumi kachasha.’ ");
INSERT INTO qxl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moisesta na uyanachisha israelguna ‘¿Pidij kandaga ñukuchida mandusha juez tukuchun churuga?’ nishka jawash Diosmi rupaguj zarzabi rikurij angelda kai Moisesga mandujkish llujshichijkish tukuchun kachaga. ");
INSERT INTO qxl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Shinushami Moisesga ñukuchij ñauba taitagunada Egiptomunda llujshichiga. Shina llujshichishami pi na ruri pudishkagunada na rikushkagunadash Egiptollabidi Jatun Puka Yakubi chusku chunga (40) watada shitushka pushtubish rurusha rikuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Kai Moiseslladimi israelgunadaga niga ‘Dioslladimi kangunamunda ñuka layaidi Pai nishkada parlujta agllunga.’ ");
INSERT INTO qxl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisesga shitushka pushtubi ñukuchij ñauba taitaguna tandanukushkan gashami Sinaí urkubi paiyun rimarij angelgun tupasha na tukurij kausida kuj shimigunada ñukuchimu yachachichun ángel kuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Shinash ñukuchij taitagunaga na kazush nisha Moisesta shitusha Egiptomu kutin ringu munagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaronda kashna nigaguna ‘Ñukuchida pushachun dioskunada ruri. Egiptomunda llujshichimuj Moisés ima tukushkadash na yachunchichu.’ ");
INSERT INTO qxl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Shina nishami billi musrha diosta rurushaga animalgunada wañuchisha rupachisha paigunaj maki rurashka diosmu pishtada rurusha kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Shinushami Diosga paigunamunda laduyasha jawa cielobi tiyaj luzerogunada <Alliminguichi> nichun sakiga. Shinami Dios nishkada parlujkunaj escribishkabish tiyan ‘Israelguna, chusku chunga (40) watada shitushka pushtubi gashash ¿Ñukamunchu animalgunada wañuchisha kuganguichi? Mana. ");
INSERT INTO qxl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ashtangarin Moloc nishka dios tiyana carpada, dios Refanbuj luzerogunada, kangunaidi <Alliminguichi> ningu nisha rurushka musrhagunadash apariganguichi. ¡Chimundami kangunadaga kaimunda llujshichisha, Babilonia llaktada pasusha ashtan karumumi kachusha!’ ");
INSERT INTO qxl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ñukuchij ñauba taitaguna shitashka pushtubi gasha tuldushka wasidami chariga. Chi wasiga Moisesmu rikuchishkada Dios rurachun mandushka shinaidimi rurushkaga. ");
INSERT INTO qxl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chi wasida japishka k'ipaga ñukuchij ñauba taitagunaga Josué mandaki apusha shamuga. Dios paigunada ñaubusha na israelgunada llujshichikiga israelgunaga waigusha paigunamunda achpada japiga. Rey David kausi p'unllagunagama chi wasida kaibi chariga. ");
INSERT INTO qxl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidga Diosbuj alligunada japishami paiga <Ñauba taita Jacob-buj Dioslla, Kan chibi kausachun ñuka wasichichun sakibai> nisha mañaga. ");
INSERT INTO qxl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Shinakish Diosbuj wasidaga Davidbuj churi Salomonmi ruruga. ");
INSERT INTO qxl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Shina gakish jawa pachabi gaj Jatun Mandaj Diosga makin rurushka wasibi na kausunchu. Dios nishkada parluj nishka shinaga, ");
INSERT INTO qxl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Jawa pachaga Ñuka mandungu tiyarinami. Kai pachaga Ñuka chaki sarunami gan. ¿Ima laya wasida Ñukamunga rurunguichi? ¿Ñuka samanaga maibidi ganga?’ nishami Mandujka nin. ");
INSERT INTO qxl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","‘¿Nachu Ñukaidi tuki kaibi tiyajkunada rurugani?’ ");
INSERT INTO qxl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kangunaga upa shina jinchi shungu imadash na uyush nijkunami ganguichi. Kangunaj ñauba taitaguna layami Diosbuj Espiritudash nalladi valichinguichichu,” nisha katiga Ishtikuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Kangunaj taitagunaj taitagunaga Dios nishkada parlujkuna <Kabishkada Rurujka shamungami> nisha ñaubamunda pacha yachachijkunada katik'ichusha wañuchigaguna. Shinalladimi kangunash Paidaga na alligunamu japichisha wañuchichij ganguichi. ");
INSERT INTO qxl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dios mandushkada angelguna kangunamu kuki japishash na kazuganguichichu.” ");
INSERT INTO qxl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tandanukushkaguna shina nijta uyushami kiru kanirisha karrusk'ichisha Ishtikun manchanai p'iñarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Shinash Ishtikuga Diosbuj Espíritu junda gasha jawa pachada rikusha Diosbuj k'uilla p'alanigushkada Jesustash Diosbuj alli ladubi shayagujta rikuga. ");
INSERT INTO qxl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“¡Rikichi! Jawa pacha paskarishkadami rikuni. Aichayuj tukushka Churish Diosbuj alli ladubi shayajtashmi rikuni,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ishtikuda paigunaj rinrinda tapusha tukiguna ut'ka kuchuyashami jinchida kaparisha ");
INSERT INTO qxl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","chi pueblomunda llujshichisha rumida pigugaguna. Chi juchachijkunaga paigunaj churanagunada Saulo musumumi mingugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Rumigunan pigagukimi Ishtikuga Diosta mañusha, “¡Mandaj Jesús, ñukaj espirituda japibai!” niga. ");
INSERT INTO qxl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chi k'ipa kungurishaga, “¡Mandajlla, paigunaj juchada ama rikunguichu!” nisha jinchida kaparishaga wañugallami. ");
INSERT INTO qxl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulosh chibi gashami <Ishtikuda wañuchishkaga allimi> niguga. Chi p'unllaidimi Jerusalén pueblobi crijkunada manchanaidi katik'ichungu kallariga. Chimundami tuki crijkuna Judea Samaria llaktagunamu mitikusha kaida chaida risha chingarigaguna. Jesús agllushkagunallami Jerusalenbi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dios yuyilla kausuj maijingunallami Ishtikuda llakisha manchanaidi wakusha pambugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ashtanbish Sauloga tuki crijkunada katik'ichusha chingachish nishami wasindijta waigusha k'arigunadash warmigunadash aisusha risha carcelbi churachun mandaga. ");
INSERT INTO qxl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalenmunda mitikusha rijkunaga Alli Shimida maida rigushash parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipesh Samaria llaktabi tiyij pueblomu risha Cristomunda parlaguga. ");
INSERT INTO qxl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Felipe rimarijta uyushami pi na rikuchishkada rurujta rikushami taugaguna tandanukusha pai nishkada alli uyugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tauga yana katishkagunada alliyachikimi yanagunash kaparisha llujshiga. Tauga suchugunash ringugunash alliyachishkami gaga. ");
INSERT INTO qxl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chimundami chi pueblobiga manchanai kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chi pueblobiga Simón shuti ñauba yumbu gasha jatun yachuj laya tukusha Samariamundagunada manchachisha <Jatunmi gani> nisha purigujllamiga. ");
INSERT INTO qxl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tukiguna uchillagunash jatungunash paida alli uyasha, “Kai k'arimi, ‘Dios shinalla imadash rurajlla,’ ” nijkunaga. ");
INSERT INTO qxl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Unidami yumbu pai yachashkan rurusha manchachiki paida katijkunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ashtangarin Diosbuj mandanamunda Jesucristoj shutimundash Alli Shimida Felipe nishkada crishaga k'arigunash warmigunash bautizarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simonbish crisha bautizarishami Felipeda katish purisha pi na ruri pudishkagunada, na rikuchishkagunadash rurujta rikusha manchanai manchariga. ");
INSERT INTO qxl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesusbuj agllushkaguna Jerusalenbi gasha Samaria llaktabi kausujkunash Diosbuj Shimida parluki alli japisha crishkada yachushami Pedroda Juanchundij kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paiguna chayushaga Samariamunda crijkuna Diosbuj Espirituda japichun nishami Diosta mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Diosbuj Espíritu maijinbujmush narij chayamukiga Manduj Jesusbuj shutibi bautizashka gagagunallami. ");
INSERT INTO qxl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Shinakimi Pedroga Juanchundij makida paigunaj jawabi churuki Diosbuj Espirituda japigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jesusbuj agllushkaguna crijkunaj jawabi makida churuki Diosbuj Espirituda japijta rikusha Simonga kuchkida kungu yuyasha ");
INSERT INTO qxl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kashna niga, “Ñukamush maijinbuj jawabi makida ñuka churushka gajkuna Diosbuj Espirituda japichun kai poderda kubaichi.” ");
INSERT INTO qxl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Shina nikimi Pedroga, “¡Kanga Dios kushkada kuchkin randinada yuyishkamunda kambuj kuchkindij uku pachamu ringuimu! ");
INSERT INTO qxl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Diosbuj ñaubuki kambuj shungu milli gashkamunda kan na Diosbujta rurangu ñukuchin puri pudinguichu. ");
INSERT INTO qxl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kambuj millida ruranada sakisha Mandajta mañi. Shungubi na alli yuyishkagunada charishkamunda kanda perdonangachari. ");
INSERT INTO qxl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kambuj shunguga jayuj laya jucha rurana yuyin prezuda shina charijta rikuni,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Shina nikimi Simonga, “Kanguna nishka shina ama ñuka imash tukuchun, Mandajta mañichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Paigunada Manduj rurushkadash Diosbuj Shimidash parlushka k'ipaga Pedroga Juanchundij Samariabi tiyaj uchilla pueblogunabi Alli Shimida parlush katisha Jerusalenmu kutin rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mandajbuj angelga Felipeda kashna niga, “Jatarisha Jerusalén pueblomunda Gaza pueblomu rina ñanda lluki laduda urimu ri. Chi ñanga shitashka pushtudami pasun.” ");
INSERT INTO qxl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipega jatarin ñanda rigushaga Etiopía llaktamunda eunuconmi tupaga. Paiga Etiopiada jatun mandaj warmi Candace nishkaj kuchkida tandachisha alli apaj. Paiga Jerusalenbi Diosta <Allimingui> ningu shamushkaga. ");
INSERT INTO qxl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Etiopiamu kutin rigushami carretabi tiyarisha Dios nishkada parluj Isaías escribishkada liyush katisha riguga. ");
INSERT INTO qxl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Diosbuj Espíritu Felipeda niga, “Chi carretamu kuchuyasha paiyun ri.” ");
INSERT INTO qxl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe ut'kada kuchuyashaga Dios nishkada parlaj Isaías escribishkada pai liyajta uyushami, “¿Kan liyashkada intindinguichu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Shina tapukimi paiga, “Pish na yachachikiga ¿ima layadi intindisha?” niga. Felipeda carretamu sikachisha paibuj kuchubi tiyarichun mañuga. ");
INSERT INTO qxl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pai liyashkabiga kashna nishkami tiyaga, “Ovejada wañuchinamu aisushka shinami pushushka riga. Rutujbuj ñaubuki upalla sirij malta oveja layami Paiga na shimida paskuga. ");
INSERT INTO qxl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Llakichishka gakish pish na jarkagachu. <Paibuj wawagunaj wawagunaga kausagunmi> nishaga ¿pidi parli pudinga? Paibuj kausish kai pachamunda anchuchishkami.” ");
INSERT INTO qxl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopiamunda eunuco Felipeda, “Dios nishkada parlujka ¿pimundadi kaidaga nishkanga? ¿Paillamundadichu na gashaga shujmundachu nishkanga? Nibai,” nisha tapukimi, ");
INSERT INTO qxl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipega pai liyushkamunda intindichingu kallarisha Jesusmunda Alli Shimida parlaga. ");
INSERT INTO qxl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ñanda rigusha yaku tiyashkamu chayusha chi eunucoga, “Riki. Yaku kaibi tiyanmi. ¿Nachu kaibi bautizashka gaibuj gani?” niga. ");
INSERT INTO qxl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Shina niki Felipega, “Kan tuki shungun crishaga bautizari pudinguimi,” niki, “Ari. Jesucristoga Diosbuj Churishkada crinimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Carretada shayachichisha ishkindijlladi urikusha yakubi waigusha Felipega paida bautizaga. ");
INSERT INTO qxl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yakumunda llujshishka k'ipa Felipeda Mandujbuj Espíritu apuki eunucoga paidaga kutinga na rikugachu. Shina gakish kushiyasha paibuj ñanda katiga. ");
INSERT INTO qxl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipega Azoto pueblobimi rikuriga. Shinami Cesarea pueblomu chayungama pueblondijta Alli Shimida parlusha riga. ");
INSERT INTO qxl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauloga Mandujta crijkunada llakichish nishami <Paigunada wañuchishami> nisha puriga. Chimundami jatun manduj curajmu risha ");
INSERT INTO qxl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","paida <Permisoda escribisha kui> nisha mañuga. Shina mañushaga Damasco pueblobi tandanukusha Diosmunda yachana wasigunamu waigusha Ñanda katijkunada k'ari gachun warmi gachunbish Jerusalén pueblomu prezu pushamungu munaga. ");
INSERT INTO qxl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasco pueblomu chayaguki jawa pachamunda shuj luz Sauloj muyundijta ñash p'alaniki ");
INSERT INTO qxl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo pambamu urmusha shuj shimi, “Saulo, Saulo ¿imashti Ñukada katik'ichungui?” nijta uyusha, ");
INSERT INTO qxl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Manduj ¿pidij gangui?” nisha tapukimi, chi shimiga, “Ñukaga kan katik'ichushka Jesuslladimi gani. ");
INSERT INTO qxl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jatari, pueblomu ri. Chibimi kan imada rurachunbish ninga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Rimarijta uyushash pidash na rikushkamundami Saulon rigujkunaga manchanaidi mancharisha imada na nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo pambamunda jatarishka k'ipaga ñawida paskushash imadash na rikugachu. Chimundami makimunda aisusha Damasco pueblomu pushusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chibimi kinsa p'unllada na rikusha na mikushalla imadash na ubiashalla tiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco pueblollabidimi yachaguj Ananías kausuga. Mandaj paimu suñubi rikurisha, “Ananías,” nikimi, paiga, “Kaibimi gani, Manduj,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Shina niki Mandajka, “Jatari, <Dirichu> nishka ñanmu risha Judasbuj wasibi Tarso pueblomunda Sauloda tapungui. Paiga Diosta mañagushaga ");
INSERT INTO qxl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ñami sueñobi kan Ananías nishka paibujmu waigusha kutin rikuchun makida paibuj jawabi churashkada rikuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Shina nijta uyashami Ananiasga kashna niga, “Manduj, chi Sauloga Jerusalenbi Kambujlla linshuyachishkagunada p'iñusha manchanai llakichij gashkada taugaguna nijtami uyushkani. ");
INSERT INTO qxl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kunungarin manduj curaguna kachushka permisonmi tuki Kambuj shutida kayasha mañujkunada prezusha japingu kaimu shamushka.” ");
INSERT INTO qxl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Shina nikimi Mandujka kashna niga, “Ri. Paidami Ñukamunda na israelgunamu paigunada jatun mandujkunamush israelgunamush yachi chayachichun agllugani. ");
INSERT INTO qxl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ñukamunda mashna llakida apana ganadash Ñukalladi rikuchishami.” ");
INSERT INTO qxl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Shinaki Ananiasga Saulo tiyashka wasimu riga. Chimu waigusha paibuj makida Sauloj jawabi churushaga, “Wauki Saulo, kan ñanda shamuki rikurij Manduj Jesusmi kambuj ñawida rikujta rurachun Diosbuj Espiritush kambi jundashka gachun ñukada kaimu kachuga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Shina ninmi Sauloj ñawimunda chaula kara layalla urmuki pai kutin rikuga. Chimunda jatariki bautizashka gaga. ");
INSERT INTO qxl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mikusha jinchi tukushka k'ipa Damasco pueblobi kausuj yachagujkunan shuj p'unllagunada sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sauloga na shuyashalla Diosmunda yachana wasigunamu risha <Jesusga Diosbuj Churimi gan> nisha parlungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tuki uyujkuna manchanai mancharisha, “¿Nachu paiga Jerusalenbi Jesusbuj shutida kayasha mañujkunada tukuchingujti katik'ichusha purij gan? ¿Kaimush prezu japisha manduj curagunajmu pushungu shamujlladi gan?” ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ashtandi na manchushalla Sauloga <Jesusmi Cristo gan> nisha Damasco pueblobi kausuj israelgunada upayachingamami yalli alli yachachiga. ");
INSERT INTO qxl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tauga p'unllaguna k'ipami Sauloda wañuchingu israelguna yuyarinukushkada ");
INSERT INTO qxl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pai yachi chayuga. Paiguna tuti p'unllami wañuchingu nisha chi pueblomunda llujshina pungugunabi chapagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sauloj yachagujkunaga shuj tuta jatun canastabi churusha chi puebloj pirkamunda uriyachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Jerusalén pueblomu chayushaga Jesusbuj yachagujkunan tandanukungu munaga. <Na Jesusta katijchunga> yuyisha tukigunami paida manchuga. ");
INSERT INTO qxl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Shina manchagukish Bernabemi Sauloda Jesusbuj agllushkagunamunga pushusha rikuchiga. Paiga ima laya Saulo ñanbi Mandajta rikushkadash Mandaj paimu rimarishkadash ima laya Saulo Damasco pueblobi na manchushalla Jesusbuj shutibi yachachishkadash parluga. ");
INSERT INTO qxl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Chimundami Sauloga tuki Jerusalenda paigunan purisha na manchushalla Mandujbuj Shimida parlagusha ");
INSERT INTO qxl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","griegobi rimuj israelgunan parlanukusha ch'imbapura rimanukush katiga, ashtan paigunaga wañuchingu yuyarinukuga. ");
INSERT INTO qxl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chaishuj crijkuna chida yachi chayushami Saulodaga Cesarea pueblomu pushush risha chimundaga Tarso pueblomu kachagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Shinushami Judeabi Galileabi Samariabish tuki crijkunaga chi llaktagunabi ña na katik'ichushka gagaguna. Diosbuj Espíritu ayudaki Mandajta manchusha kausushami crijkuna jinchiyasha ashtan mirariga. ");
INSERT INTO qxl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedroga maida risha parlanukushaga Lida pueblobi linshuyachishkagunajmu riga. ");
INSERT INTO qxl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chibimi pusuj watada suchu tukusha k'awitubi sirij Eneas shuti k'arida japiga. ");
INSERT INTO qxl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedroga paida niga, “Eneas, Jesucristomi kanda alliyachin. Jatari. Kambuj k'awituda pariji.” Shina ninmi paiga jatariga. ");
INSERT INTO qxl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tuki Lidabi Sarón llaktabish kausujkuna jatarijta rikushaga Mandajta crigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Shuj Jesusta katij Tabita nishka warmi Jope pueblobi kausuga. Paibuj shuti griego shimibiga Dorcas nishkamiga. Paiga allida rurusha ministijkunamush ayudashami kausaga. ");
INSERT INTO qxl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chi p'unllagunami Dorcasga ungusha wañuga. Paibuj cuerpoda armachishka k'ipaga jawa alto shuj ukubimi churugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope puebloga Pedro purishka Lida pueblo kuchullabimiga. Crijkuna Lida pueblobi purijta yachushami, “Pedroda, ‘Jope pueblomu ut'kada shamubai,’ ningu richi,” nisha ishkida kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro paigunan risha chayukiga wañushka sirij ukumumi pushusha riga. Chibi viudagunaga paibuj muyundijta shayarisha wakusha Dorcas kausagusha rurushka churanagunada rikuchigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro chibi gajkunada tukida llujshichisha kachushaga kungurisha Diosta mañashka k'ipa wañushkada kutin rikushaga, “Tabita, ¡Jatari!” nikiga chi warmiga ñawida paskusha Pedroda rikusha tiyariga. ");
INSERT INTO qxl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedroga makimunda jatarichiga. Chi k'ipaga crijkunada viudagunadash kayusha kausujta rikuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jope pueblobi tuki kausujkunaga kaida yachi chayaga; taugagunami Mandajta crigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedroga Jope pueblobi animalgunaj karada k'akusha ñutuyachij Simonbuj wasibimi tauga p'unllagunada sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","<Batallón Italiano> nishkagunapura patsuj soldadogunada manduj Cornelio shutimi Cesarea pueblobi kausuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Paiga allida rurusha familiagunandi Diosta <Allimingui> nisha israelgunada kuchkin ayudasha, Diostash manchusha mañagujllamiga. ");
INSERT INTO qxl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Shuj p'unlla tardi kinsa uras shinada sueñobi laya Diosbuj ángel ukumu waigumusha “Cornelio,” nijta laruidi rikuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mancharishkaidi Cornelioga angelda rikuriasha, “¿Imada ningui, Manduj?” nisha tapuga. Angelga, “Kan mañushkagunada uyusha, maijin ministijkunamu kushkagunada rikusha, Dios yuyarishkami. ");
INSERT INTO qxl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jope pueblomu Simón pailladi Pedrosh nishkada pushamuchun maijingunadash kachi. ");
INSERT INTO qxl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Paiga animalgunaj karada k'akusha ñutuyachij jatun yaku kucha ladubi kausaj Simonbuj wasibimi pozadada mañusha tiyan,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ángel paiyun rimarisha rikimi Cornelioga paibuj ishki alli sirvijkunada paiyun maimush purij Diosta kazuj shuj soldadodash kayusha ");
INSERT INTO qxl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","tuki ima tukushkada nishka k'ipaga Jope pueblomu kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kayundij chaubi p'unlla shinada kachashkaguna ñanda rigusha Jope pueblomu chayaguki Pedroga wasi jawamu Diosta mañungu sikuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Chibi yarijachisha mikush nigukimi yanungama k'uidi kushilla sueñobi laya ");
INSERT INTO qxl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","jawa pacha paskarijta shuj jatun linsu shina chusku puntabi watushka pambamu uriyamujtash rikuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chi linso layabiga tuki laya chusku chakiyujkunash llukusha purijkunash alisyujkunashmi rikuriga. ");
INSERT INTO qxl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Shuj rimarishka uyarisha paida, “Pedro, jatarisha wañuchisha miki,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Shina niki Pedroga, “Mana, Mandajlla. Ñukaga mapalla nishka na gashaga na mikuchun mandashka animalgunadaga shuj kutinllash mana mikushkanichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Shina niki kutinlladi rimarishaga, “Dios ‘Linshushkami gan’ nishkadaga ama ‘Mapallami gan’ nichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kinsa kutin shina tukushkanmi jatun linsoga jawa pachamu apushka gaga. ");
INSERT INTO qxl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","<Sueñobi shinalla rikushkaga ¿imashi ganga?> nisha Pedro mancharishkaidi yuyarigukimi Cornelio kachushka k'ariguna tapi tapi Simonbuj wasi pungumu chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chimu chayusha kayashaga tapugaguna <¿Kaibichu Simón pailladi Pedro nishkaga kausagun?> ");
INSERT INTO qxl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sueñobi laya ima tukushkada Pedro yuyarigujllabidimi Diosbuj Espirituga, “Riki. Kandaga kinsagunami mashkagun. ");
INSERT INTO qxl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Jatari; uriyasha imadash na yuyarishalla paigunan ri. Ñukaidimi kachugani,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro uriyasha mashkagujkunada, “Kanguna mashkagushkaga ñukaidimi gani. ¿Imamunda shamuganguichi?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Paigunaga, “Diosta manchusha kabishkada ruruj tuki israelgunash <Allimingui> nisha k'uyushka soldadogunada manduj Cornelio kachushkami shamunchi. Kan nishkada pai uyachun Diosbuj angelmi paibuj wasimu kanda pushamuchun nishka,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Shina nikimi Pedroga paigunada ukumu chi tutaga paigun chibi pakarichun waiguchisha kayundij p'unlla rigukimi Jope pueblobi kausuj maijin crijkunaga katisha riga. ");
INSERT INTO qxl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kayundij p'unllaga Cesareamu chayugaguna. Chibimi Cornelioga paibuj alli apanukujkunada familiagunadash tandachisha chapaga. ");
INSERT INTO qxl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro wasimu chayuki Cornelioga paigun tupusha paibuj ñaubuki kungurisha kumuriga. ");
INSERT INTO qxl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedroga, “Jatari. Ñukash kan layaidi k'arimi gani,” nisha shayachiga. ");
INSERT INTO qxl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Shina ninukush katisha ukumu waigushaga taugaguna tandanukusha tiyajtami japiga. ");
INSERT INTO qxl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Paigunamu Pedroga, “Israelguna crishkabi na israelgunan ama tandanukuchun, wasigunamush ama waiguchun yachachishkada kangunaga yachanguichimi. Shina gakish Diosmi pidash <Juchayujmingui> na gashaga <Mapallamingui> nisha ama ñuka nichun yachachiga. ");
INSERT INTO qxl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chimundami paiguna parluki imash na nishalla shamugani. Kununga <¿Imamunda ñukada pushachun kachugangui?> nisha tapuguni.” ");
INSERT INTO qxl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Shina tapukimi Cornelioga, “Ñami chusku p'unlla gan. Kishna uraslladimi tardi kinsa urasta ñukaj wasibi Diosta mañagunmi p'alaniguj churana churashka k'ari rikurisha, ");
INSERT INTO qxl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelio, kan mañushkada Diosga uyushkami ministijkunamu kushkadash yuyarishkami. ");
INSERT INTO qxl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jope pueblomu Simón pailladi Pedro nishkada pushamuchun kachi. Paiga animalgunaj karada k'akusha ñutuyachij jatun yaku kucha ladubi kausaj Simonbuj wasibimi pozadada mañusha tiyan,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chimunda shina ninmi mashkachun kachugani. Kaimu shamusha allidami rurushkangui. Kununga imallada kan nichun Mandaj kachushkada uyungu tukigunami Diosbuj ñaubuki ganchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro rimaringu kallarishaga, “Diosmunga tukiguna pish na yalli gashkada kununmi alli yachani. ");
INSERT INTO qxl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Paida manchusha kazujkunada kabishkada rurujkunadash maijin llaktamunda gakish Diosga paigunanmi kushiyan. ");
INSERT INTO qxl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kangunaga israelgunamu Dios kachashka parluda yachanguichi. Kai k'uilla kausida kuj Alli Shimiga tukigunada Mandaj Jesucristomundami. ");
INSERT INTO qxl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Juanchu bautizachun nishka k'ipa Galileamunda kallarisha tuki Judea llaktagunabi ima tukushkada kangunaidi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazaretmunda Jesusmu Diosbuj Espiritudash imadash ruranadash kusha Dios ch'ikanyachishkada yachunguichimi. Dios Paigun gashkamundaga allida rurusha diablo katishkagunadash alliyachisha puriga. ");
INSERT INTO qxl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Judea llaktabi Jerusalén pueblobish Jesús tuki ima rurushkada rikujkunami ganchi. Paida cruzbi warkusha wañuchigaguna, ");
INSERT INTO qxl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","shinash Diosga Jesusta kinsa p'unllabi kausachishami rikurichun sakiga. ");
INSERT INTO qxl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jesusga tukigunamunga na rikurigachu, ashtangarin ñukuchi ima rikushkada nichun ñaubamundadi Dios agllushkagunallamumi wañushkagunajmunda kausarishka k'ipaga paiyun mikujkunamu ubiajkunamu rikuriga. ");
INSERT INTO qxl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesusga ñukuchidaga <Wañushkagunash kausujkunash alli na alli gashkada juchachichun Ñukada Dios churashkami> nisha tukigunamu parlachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dios nishkada tuki parlujkunami Jesusmundaga <Maijin Paida crijkunaga Paibuj shutimundami juchagunada perdonashkami> nisha ñami parlushka,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro rimarigujllabidimi paibuj shimida tuki uyagujkunaj jawamu Diosbuj Espíritu uriyamuga. ");
INSERT INTO qxl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedron chayaj circuncidashka crijkunaga na israelgunamush Diosbuj Espirituda kujta rikushami ");
INSERT INTO qxl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","na israelguna Diosta <Allimingui> nisha shuj shimigunabi rimarijtash uyushkamundami mancharigaguna. Chimunda Pedroga, ");
INSERT INTO qxl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ñukuchi laya Diosbuj Espirituda japijkuna yakun bautizashka gachunga ¿pidi jarki pudingari?” niga. ");
INSERT INTO qxl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Paigunadaga Jesucristoj shutibi bautizashka gachunmi manduga. Chi k'ipaga Pedroda <Asha p'unllagunada ñukuchin sakiribai> nisha mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Diosbuj Shimida na israelgunash crishkadami Jesusbuj agllashkaguna Judea llaktabi crijkunash yachi chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jerusalén pueblomu Pedro ichiyamukiga circuncisión parti crijkunaga paida rimagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“¿Imashti na israelgunaj wasimu risha paigunan mikugangui?” nisha tapugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedroga kallarimunda pacha ima tukushkada ningu kallarishami, ");
INSERT INTO qxl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ñukaga Jope pueblobi kausagusha Diosta mañagukimi k'uilladi sueñobi laya shuj jatun linsu shina chusku puntabi watushka jawa pachamunda ñuka tiyashkamu uriyamujta rikugani. ");
INSERT INTO qxl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chida alli rikukimi chusku chakiyuj animalguna, sachabi tiyuj p'iña animalguna, llukusha purijkuna, alisyujkunashmi rikuriga. ");
INSERT INTO qxl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Shinalladi rimarisha, ‘Pedro, jatarisha wañuchisha miki,’ nijta uyushami ");
INSERT INTO qxl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ñukaga, ‘Mana, Mandaj. Mapayashka mikunaga shuj kutinllash na ñukaj shimimu waigugachu,’ nigani. ");
INSERT INTO qxl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Shina nikimi jawa pachamunda kutin rimarishaga, ‘Dios <Linshushkami gan> nishkadaga <Mapallami gan> ama nichu,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kinsa kutin shina tukushka k'ipami jawa pachamu kutin tukiguna ichiyashka gaga. ");
INSERT INTO qxl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Shina tukunmi Cesarea pueblomunda ñukamu kachushka kinsa k'arigunaga ñuka tiyashka wasimu chayamuga. ");
INSERT INTO qxl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Diosbuj Espiritumi <Imadash na yuyarishalla paigunan ringui> nisha manduga. Shinami kai sujta waukigunandi chi kachuj k'aribujmu risha wasimu waiguganchi. ");
INSERT INTO qxl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Paiga ima laya shuj ángel paibuj wasibi shayarisha, ‘Simón pailladi Pedro nishkada pushamuchun maijindash Jope pueblomu kachi. ");
INSERT INTO qxl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paimi ima laya kanda kambuj familiagunandij kishpichinashkadash ninga,’ nijta rikushkada ñukuchimu niga. ");
INSERT INTO qxl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ñuka rimaringu kallarikimi Diosbuj Espirituga ñukuchimu kallaribi shamuj layaidi paigunaj jawamush uriyamuga. ");
INSERT INTO qxl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chida rikushami, ‘Juanchuga yakullanmi bautizaga, ashtan kangunaga Diosbuj Espiritunmi bautizashka ganguichi,’ nisha Mandaj nishkada yuyarigani. ");
INSERT INTO qxl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dioslladi ñukuchimu layaidi Manduj Jesucristoda crishkamunda na israelguna gakish paigunamush kushka. Shinakimi ñukaga <Dios, ama kuichu> ningujka imash na ganiga.” ");
INSERT INTO qxl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chida uyashami crijkunaga upalla sakirisha kashna niga, “Diosga na israelguna juchada sakisha Paimu vueltariki kausida charichun kushka,” nisha Diosta <Allimi gangui> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ishtikuda wañuchishka k'ipaga katik'ichushkamunda risha chingarishka crijkunamunda shujkunaga Fenicia llaktamu Chipre islamu Antioquía pueblomu risha israelgunallamu Diosbuj Shimida parlagugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Shina gakish Chipre islamunda Cirene pueblomundash maijin crij k'ariguna Antioquía pueblomu chayushami na israelgunamush Manduj Jesusmunda Alli Shimida parlagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mandajbuj imadash rurajllan paigunan gakimi taugaguna crisha Mandajmu vueltariga. ");
INSERT INTO qxl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalenmunda crijkuna kaida uyushami Bernabeda Antioquía pueblomu kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Chimu chayusha Dios alligunada kushkamunda ima rikuchishkagunada rikusha kushiyashami <Mandajta na sakisha tuki shungun alli katinguichi> nisha tukigunamu yachachiga. ");
INSERT INTO qxl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabega alli k'ari Diosbuj Espíritu junda gasha tuki shungun crijmiga. Shinushami taugaguna Mandajta criga. ");
INSERT INTO qxl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chi k'ipami Bernabega Tarso pueblomu Sauloda mashkungu riga. ");
INSERT INTO qxl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chibi japishami Antioquía pueblomu pushusha riga. Wata jundadami shuj crijkunan taugagunamu yachachisha tandanukugaguna. Antioquía pueblobimi yachagujkunadaga <Cristoda crijkunami> nisha shutichi kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chi p'unllagunami Dios nishkada maijin parlujkunaga Jerusalenmunda Antioquía pueblomu riga. ");
INSERT INTO qxl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Paigunapuramunda Ágabo shuti Diosbuj Espíritu yuyida kuki shayarishaga <Jatun yarijimi tuki kai pachabiga tiyanga> niga. Shina nishkaga Roma llaktada jatun manduj Claudioj mandanabimi p'aktuga. ");
INSERT INTO qxl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Shina tukukimi chi yachagujkuna ayudangu yuyarishaga paiguna pudishkan imalladash Judea llaktabi crijkunamu kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Shinada rurusha Bernaben Saulon yuyijkunamu kuchun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chi p'unllagunami jatun manduj Herodesga maijin crijkunada katik'ichachichun japiga. ");
INSERT INTO qxl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juanchuj wauki Jacobodash espadan wañuchichun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Shina rurushkamunda israelguna kushiyashkada rikusha Pedrodash japichun kachuga. Levadura illuj tandada mikuna pishta p'unllagunabimi shina ruruga. ");
INSERT INTO qxl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedroda japimushka k'ipaga Herodesga carcelbi churusha chunga sujta (16) soldadogunada chusku chusku tandanukusha chapachun kachuga. Pedrodaga Pascua p'unlla k'ipa tukigunaj ñaubuki tapik'ichusha rikuchingumi yuyaga. ");
INSERT INTO qxl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Shinusha Pedro carcelbi tiyakimi tuki crijkuna paimunda Diosta mañariagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","<Kayaga gentegunaj ñaubukimi rikuchisha> nisha Herodes yuyashka tuta Pedroga ishki cadenan watushka ishki soldadogunaj chaubibi puñuga. Chaishuj soldadogunash cárcel pungubi chapusha shayakimi ");
INSERT INTO qxl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ñash Mandajbuj ángel rikurisha cárcel ukuda p'unllallada ruruga. Angelga Pedroda kustisbi tupusha rijchachishaga, “Ut'kada jatari,” nin, Pedroj makimunda cadenaguna paskarisha urmuga. ");
INSERT INTO qxl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angelga Pedroda, “Chumbillirisha kambuj pargatida churiri,” niga. Paiga ángel nishkadami ruraga. “Kambuj jawa churanadash churusha ñukada katimi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ángel ima rurushkada shinadi gashkada na yachushallami sueñobi layalla yuyusha Pedroga katisha riga. ");
INSERT INTO qxl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ukumunda pacha llujshingujka ishki pushtubi chapajkunaj kuchuda rishami ñanmu llujshina pueblomu waiguna jirru pungumu chayuki punguga pailladi paskariga. Llujshisha asha karullada ña rigukimi ñash angelga paillada sakisha riga. ");
INSERT INTO qxl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Chimunda Pedroga, “Herodesbuj makimunda israelguna imalla rurush nishkamundash llujshichichun Mandajka Paibuj angelda kachushka. Kununmi allidijka yuyi japini,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Shina yuyushami Pedroga Marcos nishka Juanchuj mama Mariaj wasimu riga. Chibimi taugaguna tandanukusha Diosta mañaguga. ");
INSERT INTO qxl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kanllamunda pungu takakimi Rode shuti warmi mara sirvij pi gashkada rikungu riga. ");
INSERT INTO qxl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedro rimarijta rijsisha manchanai kushiyashami punguda paskana randiga ashtan ukumu ut'kada risha, “Pedromi pungu waigunabi shayan,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Chida uyushaga, “¡¿Lokachumadi gangui?!” nigaguna. Pai Pedrolladi gashkada nigukimi, “Nash paichunga; paibuj angelmishkanga,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro punguda takusha katigujllabi paiguna paskusha pailladi gashkada rikushaga kushiyasha mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Upayachun nisha Pedroga makin señasta rurushaga Mandajka carcelmunda ima laya llujshichishkada niga. “Kaidaga Jacobomu wauki panigunamush yachi chayachinguichi,” nishka k'ipaga llujshisha shuj ladumu riga. ");
INSERT INTO qxl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ña p'unllayaki carcelda chapagujkunaga Pedro ima tukushkada tapunukusha kaparinukusha mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pedroda mashkachun Herodesga kachuga. Shinash na japishaga Pedroda chapujkunada tapik'ichusha wañuchichun kachuga. Chi k'ipami Herodesga Judea llaktamunda llujshisha Cesarea pueblomu risha chibi sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Manduj Herodesga Tiro Sidón pueblogunamundagunanmi manchanai p'iñariga. Shinusha chimundagunaga shuj yuyilla tukusha paibuj ñaubujmu ringu yuyarishaga mandujbuj wasibi <Alli> nishka, sirvichun churashka Blaston alli apanukuj tukushaga Mandajbuj llaktamunda chi puebloguna illujta mikunagunada japijkuna gashkamunda Mandujkun alli tukungumi pailladi mañachun mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodesga shuj p'unllaj churashami manduj gashkada rikuchij churanada churarisha jatun manduj tiyarinabi tiyarishaga tiyajkunamu rimaringu kallarikimi ");
INSERT INTO qxl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","tandanukushkagunaga, “¡Chi rimajka na gentechu, ashtangarin diosmi gan!” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Shina kaparigujllabidimi Herodesga Diosta <Allimingui> na nishkamunda Manduj kachushka ángel shamusha unguchikimi k'uruguna mikushka wañuga. ");
INSERT INTO qxl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Shina gakish Diosbuj Shimiga mirarish katisha tuki ladubish yachi chayachishka gaga. ");
INSERT INTO qxl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabega Saulondij paiguna ruranada tukuchishami Marcos nishka Juanchuda Jerusalén pueblomunda pushusha Antioquía pueblomu kutin rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía pueblobi gaj iglillabimi Dios nishkada parlujkuna yachachijkunash tiyaga. Paigunaga kaigunamiga: Bernabé, Yana nishka Simón, Cirene pueblomunda Lucio, Galilea llaktada manduj Herodeskun pariju iñuj Manaén, Saulosh. ");
INSERT INTO qxl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Shuj p'unlla paiguna na mikusha Mandajta <Alli> nigukimi Diosbuj Espirituga, “Ñuka agllusha kayashkada rurachunmi Bernabedash, Saulodash anchuchibaichi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Shina nikimi na mikusha Diosta mañushka k'ipaga paigunaj jawabi makida churusha kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Diosbuj Espíritu kachukimi Bernabesh Saulosh Seleucia pueblomu riga. Chimundami barcobi sikusha Chipre islamu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina pueblomu chayushami israelgunaj Diosmunda yachana wasibi Diosbuj Shimida parlugaguna. Juanchu paigunada ayudashami puriga. ");
INSERT INTO qxl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tuki islada purishami Pafos pueblomu chayugaguna. Chibimi Israelmunda yumbu Barjesuskun tupanukugaguna. Paiga <Diosmunda parlujmini> nisha llullashami puriga. ");
INSERT INTO qxl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesusga Chipre islada manduj Sergio Paulon apanukujmiga. Chi mandujka alli yachuj gashami Diosbuj Shimida uyungu nisha Bernabeda Saulondijta pushachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yumbuga griego shimibiga Elimas shutimiga. Paiga ama crichun nishami mandujtaga jarkungu munuga. ");
INSERT INTO qxl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Shinushami Saulo pailladi Pabloga Diosbuj Espíritu junda gasha Elimasta rikuriashaga ");
INSERT INTO qxl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kashna niga, “¡Diabloj churi, tuki allida na rikunachij! ¡Tuki llullashkan tuki milli ruranagunan jundashkangui! ¿Imashti Mandujbuj dirichu ñanda ishtuyachinadaga na sakingui? ");
INSERT INTO qxl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Manduj llakichiki kunun na rikuj tukusha tauga p'unllagunadami indida na rikungui.” Shina ninmi Elimasbuj jawabi yanamanga ansan uriyaki makimunda pushachun nisha maijindash mashkaga. ");
INSERT INTO qxl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Shina tukujta rikusha Sergio Pauloga Mandujmunda yachachiki kushilla mancharishami criga. ");
INSERT INTO qxl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pabloga paigun purijkunandi Pafos pueblomunda barcobi sikushami Panfilia llaktabi gaj Perge pueblomu chayuga. Chibi paigunada sakishami Juanchu pailladi Marcos nishkaga Jerusalén pueblomu kutin shamuga. ");
INSERT INTO qxl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perge pueblomundaga Pisidia llaktabi gaj Antioquía pueblomu rigaguna. Chibimi samana p'unlla Diosmunda yachana wasimu waigusha tiyarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisés mandashka escribishkagunadash Dios nishkada parlujkuna escribishkadash liyushka k'ipami Diosmunda yachana wasibi pushujkuna parlachun kachashaga kashna niga, “Waukiguna, imaidash kushiyachina shimigunada charishaga kunundi tukigunamu parlabaichi.” ");
INSERT INTO qxl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Shina nikimi Pabloga jatarisha makin upayachun rikuchishaga kashna niga, “Israelgunash Diosta manchuj na israelgunash, uyichi. ");
INSERT INTO qxl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelgunaj Diosmi ñukuchij ñauba taitagunada agllushka. Paigunadaga na Egiptomunda gakish Diosmi Egiptobi taugagunada mirachishka. Chi k'ipami Paibuj ruri pudijllan chimunda llujshichisha ");
INSERT INTO qxl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","shitushka pushtubi chusku chunga (40) watada paiguna ima na alligunada rurakish Diosga aguantashami ");
INSERT INTO qxl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaán llaktamunda kanchis llaktada chingachishtasha ñukuchij ñauba taitagunamu chi achpada kuga. ");
INSERT INTO qxl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Chigunaga chusku patsuj pichka chunga (450) shina watabimi p'aktuga. “Chi k'ipaga Dios nishkada parluj Samuelbuj p'unllagama mandachun nishami juezkunada churuga. ");
INSERT INTO qxl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chimunda shuj jatun manduj paigunada mandachun nisha Diosta mañukimi Benjamín nishka tribumunda Cisbuj churi Saulda churaki chusku chunga (40) watada mandaga. ");
INSERT INTO qxl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Diosga Saúl mandashkada kichushka k'ipaga David-da mandachun churushami, ‘Isaíbuj churi David Ñukaj shunguda kushiyachijta tuki Ñuka munushka shinada rurujta yachashkani,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Davidbuj wawagunaj wawagunallamundadimi Kishpichij Jesusta israelgunamu Diosga Pai nishka layadi kachushka. ");
INSERT INTO qxl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús narij shamujllabidimi Juanchuga tuki israelgunamu <Juchagunada sakisha Diosmu vueltarisha bautizarichi> niga. ");
INSERT INTO qxl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juanchuga paibuj rurana tukurigukimi, ‘Ñukadaga ¿pidi gani, yuyanguichi? Na chichuni, ashtan ñukaj k'ipami shuj shamunga. Paibuj chakimunda pargati watashkalladash paskungu na kabinichu,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Uyichi, Abrahambuj wawaguna ñukaj waukiguna Diosta manchuj na israelgunagunash. Kai kishpichij shimigunaga ñukuchimumi gan. ");
INSERT INTO qxl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalenbi kausujkuna paigunada mandujkunash Jesusta pi gashkadash Dios nishkada ñauba parlujkuna escribishkada samana p'unllandi liyashkadash na yachugagunachu. Shinakish paigunalladi Jesusta wañuchichun kachasha Dios nichishkada p'aktachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesusta wañuchingaj ima na alli rurushkada na japishash Pilatodaga Jesusta wañuchichun nisha mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Diosbuj Shimibi Paimunda tuki nishkada p'aktachishka k'ipa cruzmunda uriyachisha ut'kubi pambugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Shina gakish Diosga wañushkagunapuramunda kausachigami. ");
INSERT INTO qxl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesusga Galilea llaktamunda Jerusalenmu Paiyun rigujkunallamumi tauga p'unllagunada rikuriga. Paida rikujkunami kununga Paimunda israelgunamu parlujkuna gan. ");
INSERT INTO qxl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Shinushami Alli Shimida kangunamu parlagunchi: Diosga ñukuchij ñauba taitagunamu <Kusha> nishkada ");
INSERT INTO qxl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jesusta kausachishalla paigunaj wawashkamundaga ñukuchimu p'aktachishkami. Salmos capítulo dosbi nishka laya ‘Kanmi Ñukaj Churi gangui. Kununga Ñuka Kambuj Taita tukugani’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Diosga wañushkagunaj chaubimunda Jesusbuj aicha ama ismuchun kausachiga. Kai nishka tiyan: ‘David-da mingushash p'aktachinash alligunada kusha nishkadaga kangunamumi kusha,’ nishkami. ");
INSERT INTO qxl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Shinushami shuj Salmobish, ‘Kambuj Jucha Illujbujta ama ismuchun sakinguichu,’ nishka tiyan. ");
INSERT INTO qxl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Davidga pai kausi p'unllagunabi kausujkunada Dios munashka shina mandashka k'ipa wañuki paibuj ñauba taitagunaj kuchubi pambuga; paibuj aichaga ismugami. ");
INSERT INTO qxl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ashtan Dios Kausachijbuj cuerpoga na ismugachu. ");
INSERT INTO qxl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Shinusha waukiguna, Moisés mandashkada katinaga ima juchachinash illuj tukuchun na pudinchu, ashtanbish Jesús kangunaj juchagunada perdoni pudishkada yachichi. Mashnalla Jesusta crijkuna Paimundami ima juchachinash illuj tukun. ");
INSERT INTO qxl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yuyin ganguichi. P'akta Dios nishkada parlujkunaj escribishka kangunabi p'aktanmu: ");
INSERT INTO qxl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Rikichi, Ñuka nishkada na valichisha rimujkuna, mancharisha chingarichi. Chi p'unllagunaga Ñuka rurashkada shujkuna intindichikish kangunaga na cringuichichu,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo Bernabendij Diosmunda yachana wasimunda llujshiki chibi gajkunaga shamuj samana p'unllash chigunalladadi nisha katichun mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Diosmunda yachana wasibi parlanuki tukuriki tauga israelguna Dios yuyilla gaj israel tukushkagunash Pabloda Bernabedash katisha rigaguna. Paigunaga <Dios kushka alligunada na kungarisha ñaubujmu katinguichi> nisha yachachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chi katij samana p'unllabi kazi tuki chi pueblobi kausujkuna Mandajbuj shimida uyungu tandanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Israelgunaga taugalladijkuna tandanukujta rikusha ama crichun munasha p'iñarisha Pabloj parluda jarkungu nisha rimugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chimundami Pabloga Bernabendij na manchushalla jinchi shayarisha kashna nigaguna, “Kanguna israelgunamundimi kallaribiga Diosbuj Shimida yachi chayachishkaga ministiriga. Kanguna na uyanachisha na tukurij kausida na valichikimi na israelgunajmu rishun. ");
INSERT INTO qxl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mandujka ñukuchidaga ‘Kandaga na israelgunaj luz laya gachunmi churushkani, pish na chayushka karubi kausujkunamu Ñukaj kishpichinada apachun’ nisha manduga.” ");
INSERT INTO qxl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kishna nijta uyushami na israelgunaga kushiyasha <Mandajbuj nishkaga allimishka> nigaguna. Mashnalla Dios na tukurij kausida japichun agllashkagunaga criga. ");
INSERT INTO qxl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Shinami tuki llaktabi tiyajkuna Mandujbuj shimida yachi chayaga. ");
INSERT INTO qxl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kashna nigukish israelgunaga paigunaj Diosta yuyarij <Alli> nishka charij warmigunan shinaidi chi puebloda pushuj k'arigunamushmi na alli yuyigunada kugaguna. Pabloda Bernabedash katik'ichushka gachun jatarichisha kai llaktamunda llujshichiga. ");
INSERT INTO qxl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chimundami Pablosh Bernabesh chakimunda achpada chaspisha chiguna na alli gashkada rikuchisha Iconio pueblomu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Shinash yachagujkunami Diosbuj Espíritu jundashka gasha kushilla kausugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo, Bernaben Iconio pueblobi gasha israelgunaj Diosmunda yachana wasimu waigusha Diosbuj Shimida alli parlukimi taugalladij israelgunash na israelgunash crigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ashtan na crish nij israelgunaga <Crijkunaga na allichu> nisha yuyarichunmi na israelgunamu milli yuyigunada kusha p'iñachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chimunda Pablo Bernabendij unida chibi sakirisha Mandujbuj shimida tuki shungun imadash na mancharishalla parlugaguna. Mandajka pish na ruri pudishkagunada pish na rikuchishkagunadash paigunamu rurachun kushami Paibuj kushka alligunada parlashkadaga kabishka gashkada rikuchiguga. ");
INSERT INTO qxl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Shinushami chi pueblobi kausujkuna chaubirisha shujkunaga israelgunaj parti shujkunaga Jesusbuj agllashkagunaj parti gagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chimundami israelguna na israelgunash mandujkunan paigunada llakichingu shinalladi rumigunan pigungu ninukuga. ");
INSERT INTO qxl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablo Bernabendij chida yachi chayushaga Licaonia llaktabi tiyaj Listra Derbe pueblogunamu chi llakta muyundijkunamush rigallagunami. ");
INSERT INTO qxl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chigunabish Alli Shimida parlush katishami purigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra pueblobimi wacharishkamunda pacha nadij purij suchuga tiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablo rimarigujta uyushaga chi suchu tuki shungumunda alliyanada crigujta Pabloga rikuriasha ");
INSERT INTO qxl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","jinchida kaparisha, “¡Jatari! ¡Kambuj chakida alli churusha shayari!” ninmi, suchuga saltusha shayarisha puringu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo shina rurujta rikushami chibi gajkunaga Licaonia shimibi, “¡Ñukuchimu dioskuna ñukuchi laya tukusha uriyamushkami!” nisha kaparingu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabedaga <Paiga ñukuchij dios Jupitermi> shinaidi Pablodash parluj gashkamunda <Paiga ñukuchij dios Mercuriomi> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kai pueblomu waigunabi dios Jupiterda <Allimingui> nina wasimi tiyaga. Chibi sirvij curami k'ari wagragunada tuki laya sisagunan rurashka coronagunadash punguguna ñaubujmu apamuga. Paiga tukigunan Pablomu Bernabemush wagragunada kusha wañuchingu munugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bernabega Pablosh ima tukunada ña yachashaga paigunaj churanada llikisha chi taugagunaj chaubimu waigusha kaparigaguna, ");
INSERT INTO qxl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Taitaguna ¿imasha shina rurunguichi? Ñukuchikish kanguna layalladi gentegunami ganchi. Ñukuchiga Alli Shimida kusha kangunamu nishaga <Diosga jawa pachada, kai achpada, jatun yaku kuchada, tuki chibi imalla tiyajkunadash rurushkami. Imakish na valijta sakisha chi kausuj Diosmu kuchuyichi> ningumi shamuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ñaubamundadi Diosga tuki llaktamundagunada paiguna munushka shina kausachun sakishash ");
INSERT INTO qxl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pai allida rurushkaga Pai pi gashkada rikuchin. Diosga kangunamu jawa pachamunda tamialladash kachusha tarbushkadash iñachisha mikunadash kushami kangunaj shunguda kushiyachin,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kaigunada nigushash diosmu kuj laya wagrada chi taugaguna ama wañuchichun kaziidimi na jarkugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Antioquía Iconio pueblogunamunda israelguna chayamusha taugagunaj yuyida pandachigaguna. Paigunaga Pabloda rumin pigushaga wañushka gashkada yuyusha pueblomunda aisusha llujshichisha shitugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yachagujkuna paibuj muyundijta tandanukukimi Pabloga jatarisha kutin chi pueblomu waigusha, kayundij p'unlla Bernabendij Derbe pueblomu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbebi Alli Shimida parluki taugaguna Diosta crijkuna tukushka k'ipami kutin Listra, Iconio, Antioquía pueblogunamush ishkindij shamugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chi pueblogunabi yachagujkunamu kushilla crisha katichun nisha jinchiyachishami, “Diosbuj mandanamu waigungujka manchanai llakidami apana ganchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Shinaidi maibi iglilla tiyashkabimi yuyijkunada agllusha na mikusha Diosta mañusha paiguna crishka Mandajmu mingugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kutin Pisidia llaktada rigushami Panfilia llaktamu chayugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge pueblobi Diosbuj Shimida yachi chayachishka k'ipa Atalía pueblomu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chimunda Siriabi gaj Antioquiamu kutin ringu barcobi sikugaguna. Sarun Antioquiabi crijkuna paigunada Dios chapasha p'aktachichun na kuna gakish Diosbuj k'uyimu mingushkamunda ishkindijka ña tukida tukuchigagunami. ");
INSERT INTO qxl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ña Antioquía pueblomu chayushami iglillada tandachisha Dios paigunan gasha tuki rurushkagunadash Paida crichun na israelgunaj yuyida paskashkadash nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Shinami Pablosh Bernabesh unida yachagujkunan chibi sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chi p'unllagunami Judea llaktamunda Antioquía pueblomu rijkuna waukigunamu, “Moisés mandushka shina aicha karada na p'itichishaga na kishpichishka ganguichichu,” nisha yachachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chimundami Pablosh Bernabesh paigunan manchanai jinchida rimanukuga. Shinaga Pabloda Bernabeda shuj crijkunada agllusha Jerusalén pueblomu ichiyasha Jesús agllashkagunan yuyijkunan kai yachachishkamunda yuyarisha ninukuchun kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chi iglilla Pabloda Bernabeda shuj crijkunadash Jerusalenmu kachuki rigusha Fenicia Samaria llaktagunada rigushami na israelguna ima laya ñauba crishkada sakisha kununga Diosta katishkamunda yachi chayachikimi tuki wauki paniguna manchanai kushiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalenmu chayukimi iglillash Jesús agllushkagunash yuyijkunash <¿Alli shamushka ganguichi?> nisha japiki Dios paigunan ima rurushkada nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fariseogunamunda shuj crijkuna shayarisha, “Chi na israelgunash crij tukushaga, ‘Circuncisionda ruranadash Moisés mandushkadash kazunaminguichi,’ ninaminchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Shinushami Jesús agllushkaguna yuyijkunash chi nishkagunada yuyarinukungu tandanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Unida rimanukushka k'ipami Pedro shayarisha, “Waukiguna, Diosga Alli Shimida na israelgunamu parlachun paigunash crichun nisha kangunapuramunda ña unimunda ñukada agllushkadaga yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tukigunaj shunguda rijsij Diosmi ñukuchimu kushka layaidi Paibuj Espirituda na israelgunamush kusha shinami paigunada japij gashkada rikuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Diosga ñukuchidash paigunadash na shuj layagunadaga rurushkachu. Crishkallamundami Diosga paigunaj shunguda linshuyachishka. ");
INSERT INTO qxl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kununga chi ñauba mandushka shimigunadaga ñukuchij ñauba taitagunash ñukuchish na p'aktachi pudishkanchichu. Kangunaga chi llashij yugo layada crijkunabi churushaga ñauba mandushkada crijkuna p'aktachichun nishaga ama Diosta p'iñachingu yuyaringuichichu. ");
INSERT INTO qxl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ima shina Mandaj Jesús na kabikish alligunada kusha ñukuchida kishpichishkadaga paiguna layaidi yanga japishkanchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tukiguna upalla tukusha Pablo Bernabendij na rikushkagunada pi na ruri pudishkadash na israelgunaj ñaubuki Dios paigunamu rurachishkada nigujta uyugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Paiguna tukuchiki Jacobo kashna niga, “Waukiguna, uyabaichi. ");
INSERT INTO qxl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simonlladimi ñukuchimunga <Diosga na israelgunamunda shujkunada agllusha Paibuj tukuchun k'uyida rikuchingu kallarishka> niga. ");
INSERT INTO qxl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kai nishkaga Dios nishkada parlujkunash igulmi nin: ");
INSERT INTO qxl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kai k'ipa kutin shamushami. Davidbuj mandanada urmachishkada wasichisha p'akirishkagunadash tandachisha kutinmi shayachisha. ");
INSERT INTO qxl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chaishujkunash Ñukaj shutida tuki apaj na israelgunash Ñuka Mandajta mashkachunmi shina rurusha,’ ");
INSERT INTO qxl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mandajka shina nishka. Paiga ñaubamunda pacha kai tukida rijsichigujmi gan. ");
INSERT INTO qxl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Chimundami ñuka yuyibiga: na israelguna ñauba crishkagunada sakisha Diosta katish nikiga na jinchi gachun ministirinchu. ");
INSERT INTO qxl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Shina randiga paigunamunga <Rurushkalla dioskunamu kushka animalgunaj aichada ama mikunguichichu. Piyunbish siririjkunaga ama gaichichu. Sipisha wañuchishka animalbuj aichadash yaurdash ama mikunguichichu> nisha escribisha kachashunchi. ");
INSERT INTO qxl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ñaubamundadi tuki pueblogunabi Moisés mandushkada parlusha tuki samana p'unllagunabi tandanukusha Diosmunda yachana wasigunabi liyushash katishkamundami paigunamu escribishun.” ");
INSERT INTO qxl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Chimundami Jesusbuj agllashkaguna, yuyijkunash iglillandij, waukigunapura <Alli> nishka ishkigunada Barsabás nishka Judasta Silastash Pablon Bernabendij Antioquía pueblomu richun agllanukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paiguna apasha richunmi cartabi kashna nisha escribigaguna, “Ñukuchi Jesusbuj agllushkaguna, yuyijkunashmi Antioquía pueblobi Siria Cilicia llaktagunabi kausuj na israel wauki panigunada saludanchi. ");
INSERT INTO qxl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Na ñukuchi kachashkaguna ñukuchijpuramunda risha, kangunada paigunaj shimigunan manchachisha muspachigushkada yachushkanchimi. ");
INSERT INTO qxl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chimundami tuki tandanukusha ñukuchipuramunda kai waukigunada ñukuchij k'uyushkaguna Bernaben Pablondij kangunada rikungu richun aglluganchi. ");
INSERT INTO qxl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paigunami ñukuchij Mandaj Jesucristo shutimunda wañunadash na manchushalla purishkaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Shinushami Judasta Silastash kangunamu ñukuchi escribishkada alli yachi chayachichun kachunchi. ");
INSERT INTO qxl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Diosbuj Espiritumu ñukuchimush alli gakimi kanguna ama ashtan apachun kaigunallada nisha ninchi: ");
INSERT INTO qxl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Rurushka dioskunamu wañuchishka animalgunaj aichada ama mikunguichichu, yaurdash sipisha wañuchishka animalbuj aichadash ama mikunguichichu, shinaidi piyunbish siririjkunaga ama gaichichu. Kaigunada kazushaga allidami rurunguichi. Shuj p'unllagamachi.” ");
INSERT INTO qxl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chi chuskugunaga <Shuj p'unllagamachi> nishka k'ipa Antioquiamu rigaguna. Chibimi tuki crijkunada tandachisha chi escribishkada kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chida liyushka k'ipa paigunada llakisha kushiyachingu kachushkada rikushami tukiguna kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judasbish Silasbish Dios nishkada parlaj gashami crijkunada paigunaj shimin kushiyachisha ashtan katina yuyidash kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tauga p'unlla k'ipa paigunada kachujkunajmu vueltachun <Alli k'uillada ringuichi> nisha kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Shina gakish Silasga chibi sakiringu yuyaga. ");
INSERT INTO qxl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Shinalladi Pablosh Bernabesh Antioquiabi sakirishaga taugagunandij Mandujbuj Alli Shimida parlusha yachachish katigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tauga p'unllagunada chibi gashka k'ipami Pabloga Bernabeda, “Mandujbuj Alli Shimida sarun ñukuchi parlushka pueblogunabi crijkuna ima laya katishkada rikungu kutin jaku,” nikimi, ");
INSERT INTO qxl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabega <Marcos nishka Juanchudash ñukuchin pushashun> niga. ");
INSERT INTO qxl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Panfilia llaktabi paigunan na katisha shitusha rishkamundami Pabloga Marcosta na pushush niga. ");
INSERT INTO qxl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Shujta shujta yuyasha naidi intindinukushami ch'ikunyarisha Bernabega Marcosta Chipre islamu pushusha ringu barcobi sikuki ");
INSERT INTO qxl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pabloga Silasta pushusha ringu aglluga. Wauki paniguna Manduj alligunada kuchun ishkindijta minguki llujshiga. ");
INSERT INTO qxl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paigunaga Siria Cilicia llaktagunabi crijkuna tandanukigunamu ashtan Diosta alli katina yuyida kushami purigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pabloga Derbe puebloda risha Listra pueblomu chayusha yachaguj Timoteon tupanukuga. Paibuj mamaga israelgunapura Jesusta crij warmimiga. Taitaga griegomiga. ");
INSERT INTO qxl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoteodaga Listra Iconio pueblogunabi tiyaj wauki panigunaga <Allimi> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pabloga Timoteoda pushusha ringu munusha Timoteoj taita griego gashkada tukiguna yachashkamundami chibi kausaj israelguna ama rimachun nisha Timoteoda circuncisionda rurachiga. ");
INSERT INTO qxl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paiguna chayushka pueblogunabi crijkunamu Jerusalén pueblobi Jesusbuj agllushkaguna yuyijkunash kazuchun yuyanukushkada kusha katigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chimundami iglillaguna crinabi jinchiyachishka gasha shujkunash criki p'unllandij mirarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Diosbuj Espíritu Asia llaktabi Alli Shimida parlachun na sakikiga Frigia Galacia llaktagunada rigushami ");
INSERT INTO qxl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia lindigama chayusha Bitinia llaktamu waigungu munaki shinaidi Jesusbuj Espíritu na sakikimi ");
INSERT INTO qxl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misia llaktada shujlla rigusha Troas pueblomu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chibimi Pabloga shuj tuta sueñobi shinalla Macedonia llaktamunda k'ari shayarisha, “Macedoniamu shamusha ayudabai,” nigujta rikuga. ");
INSERT INTO qxl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Shina sueñobi layalla rikushka k'ipaga Dioslladi chi llaktabi Alli Shimida parlachun kayashkada yachi chayanmi Macedoniamu ringu parijaganchi. ");
INSERT INTO qxl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas pueblomunda barcobi sikusha Samotracia islamu dirichu rishami kayundij p'unllaga Neápolis pueblomu chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chimundaga Macedonia llaktabi pushuj pueblo Filipos romanoguna japishkamu chayuganchi. Chibimi shuj p'unllagunada puriganchi. ");
INSERT INTO qxl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Shuj samana p'unlla chi pueblo washamu llujshisha jatiyakumu chayushaga kaibimi israelguna Diosta mañana pushtushkada yuyisha tiyarisha tandanukushka warmigunamu parlungu kallariganchi. ");
INSERT INTO qxl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tiatira pueblomunda shamusha k'uilla papa sisa laya morado linsogunada k'atuj Lidiash chibimiga. Kai warmiga Diosta <Allimingui> nij gasha Pablo nishkada alli uyagukimi paibuj shunguda paskuj shina Mandaj ruraki Pablo nishkada alli japiga. ");
INSERT INTO qxl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Chi warmi paibuj familiandij bautizarishka k'ipaga, “Kangunaga ñuka Mandajta criki alli katij gashkada yachushaga jakuchi, ñukaj wasibi sakiringuichi,” mañusha uyi na uyilladi ñukuchida pushush riga. ");
INSERT INTO qxl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Shuj p'unlla Diosta mañana pushtumu rigushami ima tukunada yachaj yana katishka solteran tupanukuganchi. Paiga paida mandujkuna randishka gashami ima tukunagunada nisha milga kuchkida japishash paigunallamumi kuj gaga. ");
INSERT INTO qxl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chi solterami ñukuchida Pablodash, “¡Kai k'arigunaga jawa pachamunda Jatun Mandaj Diosta sirvijkunami. Shinushami kishpichina ñanmunda kangunamush nigunguna!” nisha jinchida kaparisha katiga. ");
INSERT INTO qxl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ña tauga p'unllagunada shina kaparisha purijllabimi Pabloga p'iñaidi paida rikusha chi solterabi tiyaj yanada, “Jesucristobuj shutibimi paimunda llujshichun mandani,” ninmi yanaga solteramunda llujshisha riga. ");
INSERT INTO qxl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Solterada mandujkuna <Kununga kuchkida ¿ima layadi japishun?> nishami Pabloda Silastash japisha lasamu pushusha chi llaktada mandujkunaj ñaubujmu pushush rishaga ");
INSERT INTO qxl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","mandujkunajmu kuchuyachisha, “Kai israelguna ñukuchij pueblobi bullada rurusha puringuna. ");
INSERT INTO qxl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ñukuchi romanoguna gashkamunda paigunaj yachachishka costumbregunada japingu rurungu na kabinchichu.” ");
INSERT INTO qxl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Chibi gaj taugagunaga paigunada llakichingu kuchuyaki mandujkunaga <Churanada llujshichisha takichi> nisha nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Azilgun manchanai dalishka k'ipaga carcelbi churashami carcelda chapujta <Yuyin chapungui> nisha mandagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Shina mandushkada uyushaga uku sikimu pushusha ut'kushka kaspigunabi chakida kanichisha churuga. ");
INSERT INTO qxl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ña chaubi tuta tukukimi Pablon Silaskun Diosta mañusha cantasha tiyaki shuj prezugunash uyaki ");
INSERT INTO qxl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ñash achpa ch'ujchuki cárcel patagunash kuyurinmi punguguna paskarisha tuki prezugunada watashka cadenagunash kachachiriga. ");
INSERT INTO qxl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Carcelda chapuj rijcharisha tuki punguguna paskarishkada rikushaga prezuguna mitikusha rishkada yuyushkamunda paibuj espadada llujshichisha pailladi wañungu kallarigukimi ");
INSERT INTO qxl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pabloga, “¡Ama imadash rurichu! ¡Tukimi kaibi ganchi!” nisha kapariga. ");
INSERT INTO qxl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Shinaga carcelda chapujka ninada mañusha ut'kada waigusha manchin ch'ujchurisha Pabloj Silasbuj chaki kuchubi kungurisha kumuriga. ");
INSERT INTO qxl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Chi ukumunda llujshichishka k'ipaga, “Hijo taitaguna, kishpichishka gangujka ¿imadadi rurana gani?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paigunaga, “Manduj Jesusta cri. Shinamunda kan kishpichishka ganguimi, shinalladi kambuj wasibi gajkunandi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Chi k'ipami paimush tuki paibuj wasibi tiyajkunamush Mandajbuj Shimida parlaga. ");
INSERT INTO qxl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Chi tutaidi carcelda chapujka dalisha chugrichishkagunada maillunmi tuki paibuj familiandij bautizariga. ");
INSERT INTO qxl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Paibuj wasimu pushusha mikunada karusha tuki familiandij Diosbuj Shimida uyusha crishkamunda kushillami tiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","P'unllayakiga mandujkunaga guardagunada, “Pabloda Silastash kacharichun ninmi,” nisha carcelda chapujbujmu nichun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Carcelda chapujka Pabloda kashna niga, “Mandujkunaga kanguna kacharishka gachun nisha ñukamu nichun kachuga. Ña llujshi pudinguichi. Na manchushalla richilla.” ");
INSERT INTO qxl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pabloga guardagunada kashna niga, “Ñukuchi romanoguna gakish imadash narij tapushaidimi chibi gajkunaj ñaubuki takusha carcelbi churugaguna. Kununga ¿shina rurushka k'ipachu pakalla kacharingu mununguna? Paigunaidi llujshichingu shamuchun mana rishunchu.” ");
INSERT INTO qxl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Guardaguna shina nishkada mandujkunamu nikimi romanoguna gashkada yachusha manchanaidi mancharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Shinushami Pabloj Silasbuj kuchumu mandujkunadi risha <Na allida rurushkamunda perdonabai> nisha llujshichishka k'ipa <Kai pueblomunda ribaichilladi> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carcelmunda llujshishaga Pablo Silasbish Lidiaj wasimu risha wauki panigunan tandanukusha <Ñaubujmu katinguichi> nishka k'ipaga chi pueblomunda llujshisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pabloga Silaskun Anfípolis Apolonia pueblogunada rigusha Tesalónica pueblomu chayugaguna. Chibimi israelgunaj Diosmunda yachana wasiga tiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pabloga maibi gashash Diosmunda yachana wasigunamu chayuj gashkamunda kinsa semanada samana p'unllagunabi chimu risha Dios escribichishkagunabi rikusha paigunan parlanukushaga ");
INSERT INTO qxl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Cristo llakichishka wañushash kausarina ministirishkadami rikuchiguga. “Kai ñuka kangunamu nigushka Jesuslladi Cristomi gan,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Shuj israelguna crishaga Pablon Silaskun tandanukuga. Tauga Diosta yuyarij griegogunash tauga alli nishka warmigunashmi criga. ");
INSERT INTO qxl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Shina taugaguna crishkada rikushami israelguna p'iñarisha ñanbi purijlla killa milli k'arigunada tandachisha chi pueblobi bulla rurungu kallarisha Pabloda Silastash japish nisha tukigunaj ñaubujmu pushungu nisha Jasonbuj wasimu p'iñalla waigusha mashkugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ashtan paigunada na japishami Jasonda chaishuj crijkunadash chi puebloda mandujkunaj ñaubujmu aisusha kaparishaga, “¡Maibish na allida rurusha shujta yachachisha purijkunami kaimush shamushka! ");
INSERT INTO qxl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasonga paibuj wasibimi paigunada japishka. ¡Paigunami shuj jatun manduj Jesús nishka tiyashkada yuyasha Cesarbuj mandushkagunada na kazush nisha puringuna!” ");
INSERT INTO qxl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kaida uyushami taugagunash jatun mandujkunash manchanaidi kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Shinash kacharichun kuchkida kunashkaiti kukimi Jasonda chaishujkunadash kacharigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ña tuta gakimi crijkunaga Pablodash Silastash Berea pueblomu richun kachugaguna. Ishkindij chimu chayushaga Diosmunda yachana wasimu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Chi israelgunaga Pablo nigushkada uyungu alli munusha shinashkada na shinashkada yachungu nisha Dios escribichishkadash p'unllandijta alli liyusha yachagushkamunda Tesalónica pueblobi kausujkunadash yalli valichishkagunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Paigunapuramunda tauga israelgunaga criga. Griegomundash alli nishka charij warmigunaga tauga k'arigunashmi crigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Berea pueblobi Diosbuj Shimida Pablo yachachigujta yachushami Tesalónica pueblomunda israelguna risha bulla rurusha chibi taugalladijkunada jatarichigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Shina tukunmi crijkuna ut'kada jatun yaku kucha ladumu Pabloda kachuki ashtan Silasga Timoteon Berea pueblobi sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablon Atenas pueblogama rijkuna kutin shamushaga Silasbish Timoteosh ut'kalladi Pablojmu richun nisha kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenas pueblobi Silasta Timoteodash Pablo shuyagushami chi pueblobi rurushka dioskuna jundaidi tiyajta rikusha shungu raurajta llakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Shinushami Diosmunda yachana wasibi israelgunan Diosta yuyarij na israelgunanbish parlanukusha jatun lasabi tandanukujkunan p'unllandijta crichingu yuyachiga. ");
INSERT INTO qxl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Shinaidi alli yachuj epicureoguna estoicogunash paigun rimanukungu kallariki shujkunaga, “Kai maidash nisha purijllaga ¿imada ninshi?” nikimi chaishujkunaga, “Karu llaktamunda dioskunada parlujmishkanchin,” nigaguna. Pablo Jesusmunda Alli Shimida parlushkamunda wañushka k'ipa kausarina gashkada nishkamundashmi shina nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chimunda Areópago nishka tandanukushkamu pushusha risha, “Kan mushuj yachachishkadaga ¿chi ima gashkada yachi pudinchichu? ");
INSERT INTO qxl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ñukuchi na yachushkagunada kan nijta uyishami imamunda shina nishkada yachush ninchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenas pueblomundagunash chibi kausuj karumundagunash tukigunami tandanukusha imalla mushuj uyarishkagunada parlanukusha kausujkunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Chimundami Areópago nishka tandanukushkagunaj chaubibi Pablo shayarisha kashna niga, “Atenas pueblobi kausajkuna, kangunaj dioskunada alli yuyarijkunashkadami ñukaga rikuni. ");
INSERT INTO qxl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kai pueblobi purigusha kangunaj dioskunada yuyarina wasigunada rikushami altarbish <Na rijsishka Diosta yuyarinami> nisha escribishkada rikugani. Chi Diostami na rijsishash yuyarijkuna gashkanguichi. Chi Dioslladadimi kangunamunga niguni. ");
INSERT INTO qxl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Diosmi kai pachada kaibi ima tiyashkadash ruruga. Pailladi jawa pachadash kai pachadash Mandujmi. Makin rurushka diosta yuyarina wasigunabiga na kausunchu. ");
INSERT INTO qxl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pailladi na ministij gasha tukigunamu kausida samida tuki imagunada kuj gashkamundaga ñukuchij makigunan Paimun imada rurachunga na ministinchu. ");
INSERT INTO qxl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Diosmi shuj k'arillamunda tuki llaktagunada rurasha tuki kai achpabi kausachun nisha maibi tiyanada maijin watagunabi kausanadash churuga. ");
INSERT INTO qxl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kikin kausagushaidi Diosta mashkusha ima layash Paiyun tupanukuchun nishami shina ruruga. Shina gakish Diosga na ñukuchimunda karubi tiyunchu. ");
INSERT INTO qxl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Diosllamundami kausanchi, kuyurinchi, purinchi. Kangunapuramunda alli yachuj escribijkunash, ‘Ñukuchiga Diosbuj wawaminchi,’ nishkagunami. ");
INSERT INTO qxl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Diosbuj wawagunadij gashami kurin kuchkin rumin genteguna yuyushkada makin k'uilla rurushka dioskunada na Diosta shina yuyanachunchi. ");
INSERT INTO qxl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ñauba kausujkuna Diosta na rijsisha paigunaj munida rurusha kausukish Diosga imadash na nigachu. Kununga tuki maibi kausujkuna juchagunada sakisha Diosmu vueltarichunmi mandun. ");
INSERT INTO qxl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dios yuyashka p'unllabi Pai agllushka Jesusmi kabishkada llakichisha tuki kai pachabi kausujkunada juchachichun kachunga. Wañushkagunaj chaubimunda Paida kausachishami shina juchachichun kachanadaga tukigunamu alli rikuchiga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Shina wañushka k'ipa kausarishkada parlujta uyisha maijinguna na crisha asiki shujkunaga, “Kutinmi kan parlushkada uyash ninchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Shinushami Pabloga paigunaj chaubimunda llujshisha riga. ");
INSERT INTO qxl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Shina gakish maijingunaga katish risha crigaguna. Areópago nishka tandanukujkunamunda Dionisiosh Dámaris warmish shujkunash chigunapurabimi gaga. ");
INSERT INTO qxl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chi k'ipami Pabloga Atenas pueblomunda llujshisha Corinto pueblomu risha ");
INSERT INTO qxl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","chibimi Ponto llaktamunda israelita Aquilan tupanukuga. Roma llaktada jatun mandaj Claudio tuki israelgunada Roma pueblomunda llujshisha richun nishkamunda Aquilaga paibuj warmi Priscilandij Italiamunda chayamushkalla chibi puriga. Pablo paigunada rikungu rishaga ");
INSERT INTO qxl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","paish puñuna carpada paiguna layaidi ruruj gashami paigunan rurangu sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tuki samana p'unllagunabi Pabloga Diosmunda yachana wasibi parlanukushami israelgunadash na israelgunadash yachachisha crichingu munaga. ");
INSERT INTO qxl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas Timoteon Macedonia llaktamunda chayamuki Pabloga Diosbuj Shimida yachachingullami kallariga. Shina yachachisha Jesusga Cristomi gashkadaga israelgunamu rikuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pai yachachishkada na valichisha israelgunaga rimungu kallariga. Chimundami Pabloga paibuj churanada chaspisha paiguna na uyanachishkamunda p'iñarisha, “Kangunaj juchamunda chingarishaga kangunalladadimi juchachina ganguichi; ñukadaga mana. Kununmunda ichimuga na israelgunamumi yachachingu rini,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pablo Diosmunda yachana wasimunda llujshisha Diosta <Allimingui> nij kuchullabi kausaj Ticio Justojmu riga. ");
INSERT INTO qxl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Diosmunda yachana wasibi pushuj Crisposh paibuj familiandijmi Mandajta crigaguna. Tauga corintogunash paida uyusha crishami bautizi tukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Shuj tuta Pablomu sueñobi laya Mandajka, “Na mancharishalla, ama upayashalla Diosbuj Shimida parlush katilla. ");
INSERT INTO qxl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ñuka kangun gashkamundaga pish kanda takush nishash imadash na ruri pudingachu. Kai pueblobiga tauga Ñukajkunadami charini,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Shinushami Pabloga shuj wata chaubida Diosbuj Shimida yachachisha sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Shinash Acaya llaktabi Galión mandagukimi israelgunaga shujlla tukusha Pabloda p'iñasha mandujkunaj ñaubujmu pushusha rishaga ");
INSERT INTO qxl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Kai Pablomi tukiguna mandushkagunamunda shuj laya Diosta yuyarichun munasha yuyachigun,” rimagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo parlangu kallarigukimi Galionga israelgunada kashna niga, “Uyichi, israelguna. Pai ima na allidash na gashaga millidash ruruj gashkakiga kanguna nishkada uyanimumiga. ");
INSERT INTO qxl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Paibuj nishkagunada shuj shutigunadash yachachisha, kangunamu kikingunaj mandushkabi laya na rurashkakiga kangunaidi paidaga imadash rurichi. Ñukaga ima rikunadash na charinichu.” ");
INSERT INTO qxl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Shina nishka k'ipaga paibuj ñaubujmunda kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Chimunda rigushaga Diosmunda yachana wasida pushaj Sóstenes nishkada tukigunaga japishami chi ñaubujllabidi takagaguna. Shina takakish Galionga na rikuj shina imadash na nigachu. ");
INSERT INTO qxl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pabloga tauga p'unllagunada Corinto pueblobi sakirishka k'ipami wauki panigunada <Shuj p'unllagamachi> nisha Aquilan Priscilandij barcobi sikusha Siria llaktamu ringajmi Cencrea pueblomunda narij llujshishaidi Diosbujta rurasha p'aktachishkada rikuchingaj juakchada illijta rutuchiga. ");
INSERT INTO qxl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Éfeso pueblomu chayushami Pabloga Aquilada Prisciladash sakisha Diosmunda yachana wasimu risha israelgunan yuyachingu parlanukuga. ");
INSERT INTO qxl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Chimundami paigunaga <Asha p'unllagunan kaibi sakiribai> nisha mañaki paiga <Na p'aktanichu> niga. ");
INSERT INTO qxl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Llujshigushaga, “Dios munukiga kutin kangunada rikungu shamushami,” nishka k'ipaga barcobi sikusha Éfeso pueblomunda riga. ");
INSERT INTO qxl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea pueblomu chayushaga Jerusalén pueblomu ichiyasha chi iglillada saludaga. Chi k'ipaga Antioquía pueblomumi uriyaga. ");
INSERT INTO qxl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Asha p'unllagunada chibi sakirishka k'ipami Galacia Frigia llaktagunabish kutin rikungu rishaga ashtan tuki crijkunamu alli katina yuyida kuga. ");
INSERT INTO qxl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Chi p'unllagunami israelgunapura crij, Alejandría pueblobi wacharishka Apolosga Éfeso pueblomu chayuga. Paiga alli yachajmi Dios escribichishkagunadash alli alli intindijmiga. ");
INSERT INTO qxl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Paida Manduj Ñanmunda yachachiki tuki shungun parluga. Bautizaj Juanchu bautismollada rijsij gashash Jesusmunda alli yachachiga. ");
INSERT INTO qxl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolosbish Diosmunda yachana wasibi na manchushalla tukimu rimaringu kallariki Aquilash Priscilash uyushaga wasimu kayusha Diosbuj Ñan ashtan ima laya gashkada alli yachachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Acaya llaktamu Apolos rish nikimi Éfeso pueblobi kausuj wauki paniguna <Rinaga allimi> nisha shuj cartada rurusha alli japichun kachugaguna. Acayamu Apolos chayushaga Dios alli kushkamunda crijkunada ashtan ayudaga. ");
INSERT INTO qxl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tukigunaj ñaubuki israelgunada k'uillada parlusha Diosbuj Shimimunda Jesusga Cristo gashkada rikuchiki pish na imada ni pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corinto pueblobi gaki Pabloga urkugunada rigusha Éfeso pueblomu chayuga. Chibi shuj yachagujkunan tupanukushami, ");
INSERT INTO qxl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“¿Kanguna crij tukushaga Diosbuj Espirituda japiganguichichu?” nisha tapuga. Shina tapukimi paigunaga, “Diosbuj Espíritu tiyashkada na uyushkanchichu,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Chimundami Pabloga, “Shinushaga ¿ima bautismodadi kangunaga japiganguichi?” nisha tapuki, paigunaga, “Juanchuj bautismoda,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pabloga paigunadaga, “Juanchuga juchagunada sakisha Diosmu vueltarijkunada bautizajmiga. Shinash paiga ‘Ñukaj k'ipa shamujta crichun’ nigami. K'ipa shamujka Jesusmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Shina nijta uyusha Manduj Jesusbuj shutibimi bautizashka gagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Chimundami Pablo paigunaj jawabi makida churukiga Diosbuj Espíritu shamuki shuj shimigunabi rimarisha Dios yuyi kushkagunada shujkunamush parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Paigunaga chunga ishki (12) shina k'arigunamiga. ");
INSERT INTO qxl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pabloga kinsa killada Diosmunda yachana wasimu rishami imadash na manchushalla Diosbuj mandana ima laya ganashkada tukigunamu crichingu parlusha puriga. ");
INSERT INTO qxl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Shinash maijingunaga p'iñasha na crish nishami taugagunaj ñaubuki <Chi Ñanmunda parlushkaga na allichu> nigaguna. Chimundami Pabloga yachagujkunada karuyachisha Tirano nishkaj yachachina wasimu pushusha risha p'unllandijta yachachisha katiga. ");
INSERT INTO qxl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Asia llaktabi tuki kausuj israelgunash na israelgunash Mandujbuj shimida uyachun ishki watada yachachigami. ");
INSERT INTO qxl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Diosga pish na ruri pudishka k'uillagunada Pabloj makin ruruga. ");
INSERT INTO qxl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Shinushami Pabloj cuerpobi tuparishka pañugunada churanagunadash ungushkagunajmu apusha riki ungushkagunash alliyaga, yanagunash paigunamunda llujshigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yanagunada llujshichisha purij israelgunaga Manduj Jesusbuj shutida kayusha shina rurungu munusha yanagunada, “¡Pablo parlushka Jesusbuj shutibi llujshichi! ninimi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Israelgunapuramunda shuj manduj cura Escevaj kanchis churigunami shina rurush puriga. ");
INSERT INTO qxl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Shinash shuj p'unlla yanaga, “Jesusta rijsinimi. Pablo pi gashkadash yachanimi. Kangunaga ¿pidij ganguichi?” niga. ");
INSERT INTO qxl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chi yana jundushka k'ariga saltusha paigunada japisha manchanai takusha churanagunadash llikishtaki chugri chugrilladi llatunllaguna chi wasimunda vincisha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Éfeso pueblobi kausuj israelgunash na israelgunash kishna tukushkada yachi chayushaga manchanai mancharisha Manduj Jesusta <Alli k'uillami gangui> ashtan nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tauga crijkuna shamusha paigunalladi tukigunaj ñaubuki sarun ima na alli rurushkada parlugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tauga yumbugunashmi paigunaj yachana escribishkagunada apamusha tukigunaj ñaubuki rupachisha shitugaguna. Chi rupachishka escribishkagunada cuenta rurukiga pichka chunga waranga (50.000) kuchkin rurushka kuchkimi valiga. ");
INSERT INTO qxl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Shina tukushkamundaga Mandujbuj Shimi yachi chayasha mirarisha katiga. ");
INSERT INTO qxl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tuki kaiguna tukushka k'ipa Pabloga Jerusalén pueblomu narij rishaidi Macedonia Acaya llaktagunamush ringu munaga. Shinaidi, “Jerusalenmu chayushka k'ipash Roma pueblomu rinami gani,” niguga. ");
INSERT INTO qxl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Shinushami paida ayudajkunapuramunda Timoteodash Erastodash ishkindijta Macedonia llaktamu kachusha paiga Asia llaktabi shuj p'unllagunan sakiriga. ");
INSERT INTO qxl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chi p'unllagunalladimi chibi kausujkuna Ñanmunda na uyanachisha manchanai bulla rurugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kuchkida yakuyachisha imadash rurujlla Demetrio nishkamiga. Paimi Diana diosada yuyarina uchilla wasi shinagunadash ruruj alli k'atuj gaga. Paiyun rurujkunaga mirga kuchkidami japigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Paibujta rurujkunada pai laya rurujkunadash tandachisha kashna niga, “Kashna ruranada yachujkuna, kaigunada rurusha mirga kuchkida japishkada kangunaidi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pablo <Makillan rurushka dioskunaga na dioschu> nisha taugagunamu crichisha purijtash kangunaidi rikunguichimi uyunguichimi. Kaigunadaga na kai Éfeso pueblollabi nisha purishkachu, ashtangarin kazi tuki Asia llaktabimi shina nisha purishka. ");
INSERT INTO qxl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Shina nishkamunda jatun llakimi rikurinmu. Ñukuchi diosa musrhada ruranadash <Allimi> ningu sakingachari. Diana diosada yuyarina wasidash na munangagunachari. Asia llaktabi kai pachabi tuki kausujkunash paida <Alli> nij gashash kununga <Jatun allimi gangui> nisha na ningachu.” ");
INSERT INTO qxl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kaida uyushaga taugagunami manchanai p'iñarishaga, “Kai Éfeso pueblobi kausujkunajka Diana diosami alli gan,” nisha kaparigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Chimunda tuki chi pueblobi kausujkuna ashtan p'iñanukuj shina tukugaguna. Shinushami Macedonia llaktamunda Pablon rij Gayoda Aristarcodash waikada japisha tandanukusha imadash rikuna wasimu aisush rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo chibi gaj taugagunaj ñaubujmu rikurish niki yachagujkunaga na sakigachu. ");
INSERT INTO qxl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia llaktada pushujkunapurabish Pabloj rijsishkaguna mañashami <Ama chimu waigubanguichu> nichun kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Chi tandanukushkabi bulla rurashkamunda shujkuna kaida shujkuna chaida kaparigaguna. Chaubi yalligunagarin imaj tandanukushkadash na yachugagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Shinushami israelgunaga Alejandroda ñaubuki shayarichun t'anguga, taugagunamunda shujkunaga imamunda pai shina rurashkada parlachun kaparigaguna. Paiga yanga juchachishkada rikuchish nisha paiguna upayachun makida alsuga. ");
INSERT INTO qxl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ashtanbish paish israel gashkada yachi chayashami tukiguna ishki uras shinada, “¡Ñukuchi kai Éfeso pueblobi kausujkunajka Diana diosami alli gan!” nisha shuj shimilla laya kaparigugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Chi pueblomunda secretarioga taugagunada upayachi pudishami kashna niga, “Éfeso pueblobi kausujkuna, kai jatun alli nishka Diana diosada yuyarina wasidash jawa pachamunda kaillamu paibuj uriyashka musrhadash ñukuchimu mingashkada tuki kai pachabi kausujkunami yachan. ");
INSERT INTO qxl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kaidaga maijinbish <Na shinachu> nisha na ni pudinguichichu. Upayasha narij alli yuyarishaga imadash na rurunallachunguichi. ");
INSERT INTO qxl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kanguna pushamushkagunaga ñukuchij diosada yuyarina wasidash na imash rurushkachu; ñukuchij diosadash ima millimadaga na nishkagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrioda pai laya rurujkunadash pish p'iñachikiga mandujkunash juezkunash tiyanmi. Ima ninada charishash chibimi ninukungu ri pudinguna. ");
INSERT INTO qxl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kanguna imada juchachish nikish mandushkagunada katij tandanukushkabimi yuyarinukuna ganchi. ");
INSERT INTO qxl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kunun p'unlla tukushkamunda ñukuchi bulla rurasha jatarichishkada juchachingaguna. Shina juchachikiga imamunda kai p'iñarinukuna tukushkada na parli pudinchimu. Imamunda ninaga illan.” ");
INSERT INTO qxl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Shina nishka k'ipami tukigunada <Richilla> nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","P'iñarinukusha tukurishka k'ipa Pabloga yachagujkunada kayusha alli katina yuyida kushaga paigunada <Shuj p'unllagamachi> nisha Macedonia llaktamu riga. ");
INSERT INTO qxl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Chi llaktabi crijkunamu ñaubujmu katina yuyida kusha katisha chi llaktagunada risha Grecia llaktamu chayuga. ");
INSERT INTO qxl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Chibi kinsa killada gashami Siria llaktamu rij barcoda japingu purishaidi israelguna paida wañuchingu yuyagushkada yachi chayushaga Macedonia llaktalladadi kutin chakillan ringu yuyariga. ");
INSERT INTO qxl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Berea pueblomunda Pirroj churi Sópater Tesalónica pueblomunda Aristarcosh Segundosh Derbe pueblomunda Gayo Timoteo Asia llaktamunda Tiquicosh Trofimosh paiyun rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kai waukigunami Troas pueblobi ñukuchida shuyungaj ñaubugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ñukuchiga levadura illuj tandada mikuna pishta k'ipaga Filipos pueblomunda barcobi llujshisha rishami pichka p'unlla k'ipaga Troas pueblobi paigunan tupanukusha kanchis p'unllada chibi sakiriganchi. ");
INSERT INTO qxl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Semana kallari domingo p'unlla tandada chaubingu tandanukuganchi. Pablo kayundij p'unlla ña llujshina gashami chaubi tutagama crijkunamu parlusha yachachiga. ");
INSERT INTO qxl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ñukuchij tandanukushka altibajo ukubiga tauga lamparagunabimi nina katiriaga. ");
INSERT INTO qxl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Chi ukubimi Eutico musu ventanabi tiyarishkaga. Pablo unida rimariki paida puñunai japiki linshu puñurishaga kinsa jawa altomunda pambamu urmukimi ña wañushkada jatarichigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Chimunda Pablo uriyasha musuda japin ugllarisha, “Ama mancharichichu. Kausujmigun,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kutin jawa altomu sikusha tandada chaubisha mikushaga p'unllayangama yachachiga. Chi k'ipaga Pabloga rigallami. ");
INSERT INTO qxl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jawa altomunda urmuj musuda kausujta pushusha risha ashtan kushiyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablo <Asón pueblomu chakillanmi rish nini> nikimi ña yuyarinukushka shinaga paida chi pueblobi japingu ñukuchiga barcobi ñaubushadi riganchi. ");
INSERT INTO qxl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asonbi ñukuchin tupanukusha barcobi sikuki Mitilene pueblomu riganchi. ");
INSERT INTO qxl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Chimunda llujshishka kayundij p'unllaga Quío llakta ch'imbapurada pasusha shuj p'unlla k'ipaga barco tiyarina Samos islamu chayuganchi. Kutin shuj p'unllada rigushkanmi Mileto pueblomu chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ima layash Pentecostés pishta p'unllaj Jerusalén pueblomu chayush nishami Pabloga Asia llaktabi na unida sakirisha nisha Éfeso pueblomu na chayashalla riga. ");
INSERT INTO qxl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pablo Mileto pueblobi gashami Éfeso pueblomunda crijkunada pushaj yuyijkunada kayachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Paiguna chayamukimi Pablo kashna niga, “Asia llaktamu chayamushkamunda pacha ñuka kangunan ima laya gashkada yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ñukaga israelguna imadash rurusha llakichikish manchanai wakasha na jatun tukushallami kangunan Mandujbujllada rurasha purigani. ");
INSERT INTO qxl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tukigunaj ñaubukish kangunaj wasigunabish Alli Shimida kangunaj allijlladi na sakishalla yachachishkada yachanguichimi. ");
INSERT INTO qxl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Chimundami israelgunada na israelgunadash <Juchagunada sakisha Diosmu vueltarisha Manduj Jesusta crina ganguichi> nishkani. ");
INSERT INTO qxl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kununga Jerusalenbi ima tukunadash na yachushallami Diosbuj Espíritu kachushkada kazusha chimu rina gani. ");
INSERT INTO qxl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ashtan <Carcelbi churusha llakichishkami gangui> nisha mai pueblomu chayukish Diosbuj Espíritu nishkalladami yachani. ");
INSERT INTO qxl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Shina gakish ñukaj kausilladadi na llakirinichu, ashtangarin Dios alligunada kushkamunda Paibuj Alli Shimida parlachun Manduj Jesús Paibujta rurachun mingashkadaga mishanukibi vincij shina kushilla p'aktachinadijmi gani. ");
INSERT INTO qxl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ñuka Dios ima shina mandanada parlaki kangunaga ñukan puriganguichimi. Kununmundaga kangunapuramunda pish ñukada kutin na rikunadaga ña yachanimi. ");
INSERT INTO qxl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Shinushaga kununbish nisha nini, kangunamunda maijin chingarikish pish ñukadaga na juchachi pudinguichichu. ");
INSERT INTO qxl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Dios imalla munushkadaga imadash na pakushallami kangunamu nishkani. ");
INSERT INTO qxl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Diosbuj Espiritumi michijkuna laya rikuchun churushka. Kangunaga tuki crijkunadash kangunadash alli rikusha yuyin chapanguichi. Mandujbuj yaurgun randishka Diosbuj iglillada michinguichi. ");
INSERT INTO qxl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ñuka rishka k'ipaga p'iña lobo layaguna shamusha tandanukushka crijkunada tukuchingu munanada yachanimi. ");
INSERT INTO qxl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Shinalladi kangunapurallamundadimi paigunada katichun nisha maijingunaga yachagujkunamu llullusha yachachijkuna tukungaguna. ");
INSERT INTO qxl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","¡Shinami rijcharij gaichi! Kinsa watada tuti p'unlla kangunamu wakusha ima laya ñuka purinada yachachishkada yuyaringuichi. ");
INSERT INTO qxl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Wauki paniguna, Diosmunbish Pai alligunada kushkamunda Shimimunbishmi kangunada mingani. Kai shimiga kangunada jinchiyachi pudin; Dios linshuyachishkagunapura japinada kui tukun. ");
INSERT INTO qxl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ñukaga pibuj kuchkidash kuridash churanadash na munashkanichu. ");
INSERT INTO qxl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ashtangarin ñukamush ñukan purijkunamush ima ministishkada charingujka ñukaj makillandij trabajashkadaga kangunaidi yachunguichimi. ");
INSERT INTO qxl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ñuka tuki rurashkabi jinchi trabajasha shujkunadash ima ministishkabi ayudanada yachachishkani. Manduj Jesús nishka shina, ‘Shujkunamu kushaga japijta yalli kushiyanguichi,’ nisha yuyachishkada yuyaringuichi.” ");
INSERT INTO qxl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Shina nishka k'ipami Pabloga kungurisha paigunandij Diosta mañaga. ");
INSERT INTO qxl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tukiguna manchanaidi wakusha ugllarisha Pabloda ñawi ichibi muchugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tauga nishkamunda llakirishaga <Ñukadaga kutinga na rikunguichichu> nisha kai nishkamunda manchanai llakirigaguna. Chi k'ipaga barcogama paigun rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Paigunada sakishka k'ipaga barcobi sikusha Cos islamu risha kayundij p'unllaga Rodas islamu chimundaga Pátara pueblomu chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patarabiga Fenicia llaktamu rij barcoda japishami riganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chipre islada rikusha lluki ladumu sakisha Siria llaktagama chayuganchi. Chi barcoga Tiro pueblobi aparisha rigushkada sakina gakimi chimu waiguganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Chibi gaj yachagujkunan tupanukusha kanchis p'unllada paigunan sakiriganchi. Chibimi paigunaga Diosbuj Espíritu nishka layaidi Pabloda ama Jerusalén pueblomu ichiyachun nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kanchis p'unlla k'ipaga chimunda llujshiganchi. Tuki yachagujkuna warmindij maragunandij chi pueblomunda llujshisha jatun yaku manyabi kungurisha Diosta mañuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Paigunada <Shuj p'unllagamachi> nishka k'ipa barcobi sikusha rikiga wasimu kutin rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro pueblomunda barcobi risha Tolemaida pueblomu chayusha wauki panigunan tupanukusha saludasha paigunan shuj p'unllada kainuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kayundij p'unlla chimunda llujshisha Cesarea pueblomu chayushaga Alli Shimida parluj Felipej wasibi sakiriganchi. Paiga crijkunada ayudachun nisha agllushka kanchispuramundamiga. ");
INSERT INTO qxl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipega Dios nishkada parluj na kazarashka chusku ushigunadami chariga. ");
INSERT INTO qxl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tauga p'unllagunada chibi gaki Dios nishkada parluj Agabomi Judea llaktamunda chayamuga. ");
INSERT INTO qxl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Paiga ñukuchimu kuchuyashami Pabloj chumbida japisha Agaboga makidash chakidash watarishaga, “Diosbuj Espirituga, ‘Kai chumbiyujtaga Jerusalenbi gaj israelguna kashna watusha na israelgunamumi kunga,’ ninmi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kaida uyushami ñukuchish Cesareabi kausujkunash Pabloda <Ama Jerusalenmu ribaichu> nisha mañaki, ");
INSERT INTO qxl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pabloga, “¿Imashti shina wakusha ñukada llakichinguichi? Ñukaga watushkalla gana gani, ashtan Jerusalenbiga Manduj Jesusbuj shutimunda wañunallashmi gani,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Na jarki pudishaga, “Manduj munashkada rurachun,” nisha sakiganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chi k'ipa tukida parijashaga Jerusalenmumi riganchi. ");
INSERT INTO qxl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cesareamunda shuj yachagujkunan rikimi Chipre islamunda crij Mnasonbuj wasimu ñukuchida pushusha rigaguna. Paiga uni yachagujmiga. Paimi ñukuchimu pozadada kuga. ");
INSERT INTO qxl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalenmu chayukiga wauki paniguna kushilladi ñukuchida japigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kayundij p'unllaga Pabloga Jacobojmu ñukuchin riga. Tuki yuyijkunash chibi tiyajta rikushaga ");
INSERT INTO qxl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pabloga saludashka k'ipaga pai Diosbujta ruraki na israelgunamu Dios tuki ima rurushkagunada shuj shujlla yachi chayachiga. ");
INSERT INTO qxl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Shina nijta uyushami Diostaga <Allimingui> nigaguna. Shinaidi Pablodaga, “Wauki, riki. Waranga waranga israelgunami Jesustaga crishka. Tukigunami <Mandashkada kazunaminchi> ninguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Shinaidi paigunamuga <Pabloga karu llaktabi kausuj israelgunamuga <Moisés mandushkada ama kazusha kangunaj k'ari maragunadash circuncisionda na rurachinachunguichi. Israelguna ruranadash na ruranachunguichi> nisha yachachinmi> nisha shujkuna rimashkaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kan shamushkada yachushaga taugalladijkuna tandanukungaidimi. ¿Imadadi rurashun? ");
INSERT INTO qxl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ñukuchi nishkada ruri. Ñukuchipuramunda chusku k'arigunami <Diosbujta rurusha> p'aktachingu purigun. ");
INSERT INTO qxl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kan pushusha risha paigunan juchagunada maillaringui. Juakchada rutuchichunbish paigunamunda kanlladi pagui. Shina rurukimi tuki israelguna <Kanmunda nishkadaga na shinachushka, ashtan Moisés mandushkada kazushkangui> ningaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ashtanbish na israel crijkunamunga ñukuchiga <Rurashkalla dioskunamu ima kushkadash yaurdash sipisha wañuchishka animalbuj aichadash ama mikunguichichu. Shinaidi piyunbish siririjkunaga ama gaichichu> nisha yuyarishkadaga ñami escribisha kachushkanchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kayundij p'unlla Pabloga chusku k'arida pushusha risha paigunan juchada maillarishka k'ipaga Diosbuj wasimu waigusha Diosbujta ruragushka ima p'unlla tukurina gashkada ofrendada ima p'unlla kuna gashkadash parlungu waiguga. ");
INSERT INTO qxl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kanchis p'unlla ñalla p'aktamukiga Asia llaktamunda israelguna Diosbuj wasibi Pabloda rikusha tukigunada bullada rurungu waikalladi jatarichisha japishami ");
INSERT INTO qxl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Israelguna, ayudichi,” nisha kaparigaguna. “Kaimi tuki ladu llaktagunabi Moisés mandashkadash ñukuchij pueblobi kausujkunadash kai Diosbuj wasidash <Na allichu> nisha yachachisha purin. Kunungarin kai jucha illij pushtudash mapayachishka laya na kazushami griegogunada waiguchishka.” ");
INSERT INTO qxl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Chi pueblobi Efesomunda Trofimon purijta rikushami Pablodaga <Diosbuj wasimush pushushkaminga> yuyisha shina nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tuki chi pueblobi kausujkuna p'iñaidi tandanukushaga Pabloda Diosbuj wasibi japisha washamu pambada aisusha llujshichinmi pungudash ichkushtagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pabloda ña wañuchingu kallariguki Romamunda soldadogunada mandujmu tuki Jerusalenbi kausujkunami p'iñarisha jatarishkada yachi chayachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mandujka soldadogunadash paigunaj mandujkunadash tandachisha israelguna shayarishkamu ut'kada riga. Shina shamugujta rikushami israelgunaga Pabloda takanada sakigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Chimunda chi manduj kuchuyashaga Pabloda japisha ishki cadenan watachun manduga. Chi k'ipaga, “¿Pidij gan? ¿Ima na allidadi rurushka?” nisha tapukimi ");
INSERT INTO qxl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","chibi taugagunapuramunda p'iñarinukusha shujta shujta kaparinukukimi mandujka israelguna yuyashkada na yachi pudisha <Soldadoguna kausana wasimu pushusha richi> nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Chi wasi gradamu ña chayaki paida manchanai p'iñajkuna katimugukimi soldadogunaga Pabloda wandusha apuga. ");
INSERT INTO qxl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Chibi gajkuna, “Pabloda wañuchichi,” nisha kaparish katigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Soldadoguna kausana wasimu waiguchigukimi Pabloga, “¿Kangun parli pudinichu?” nisha mandujta tapuki, chi mandujka, “¿Griego shimibi rimi pudinguichu? ");
INSERT INTO qxl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Nachu kanga sarun Egipto llaktamunda shamusha ñukuchida wañuchisha nisha chusku waranga (4.000) na alligunada shitushka pushtubi tandachij gangui?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Shina niki Pabloga, “Ñukaga Cilicia llaktabi gaj tukiguna <Alli> nishka Tarso pueblomunda israelmi gani. Chimunda israelgunamu parlachun sakibai,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Chi manduj rimarichun sakiki Pabloga gradabi shayarisha upayachun nisha makida alsuga. Tukiguna upayaki hebreo shimibi kashna niga, ");
INSERT INTO qxl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Taitaguna waukiguna, ñuka yanga juchachishka gashkada rikuchichun uyabaichi.” ");
INSERT INTO qxl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebreo shimibi nigujta uyushami ashtan upalla uyagaguna. Pabloga parlasha katisha kishna niga, ");
INSERT INTO qxl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ñukaga Cilicia llaktamunda Tarso pueblobi wacharishka israelmi gani, ashtan kai pueblobi iñushami ñauba taitagunaj mandushkada Gamaliel yachachishkada yachagugani. Ima layami kunun p'unllaguna kanguna Diosbujllada ruranguichi, shinaidimi ñukash tuki shungun rurushkani. ");
INSERT INTO qxl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Sarungunaga ñukash kai Ñanda katijkunada wañuchingu katik'ichusha k'arigunada warmigunadash aisusha carcelbi churujmi gagani. ");
INSERT INTO qxl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Shina rurujtaga jatun manduj curash israelgunaj yuyijkunash rikugami. Paigunalladimi Damasco pueblobi tiyaj israelgunamu cartada kuchun ñukan kachugaguna. Chibi tiyaj crijkunada mashkusha Jerusalenbi llakichisha carcelbi churungaj japingu rigugani.” ");
INSERT INTO qxl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Damasco pueblomu ña chayagukimi chaubi p'unlla shinada jawa pachamunda shuj luz ñuka rigushka muyundijta ñash manchanai p'alanisha rikuriki ");
INSERT INTO qxl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","pambamu urmusha shuj shimi, ‘Saulo, Saulo ¿imamundadi Ñukada katik'ichungui?’ nijta uyusha, ");
INSERT INTO qxl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘Manduj ¿pidij gangui?’ nisha tapukimi chi shimiga, ‘Ñukaga kan katik'ichushka Nazaretmunda Jesusmini,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ñukan rigujkunash chi p'alanigujta rikusha mancharishash chi shimi ñukamu rimarishkadaga na intindigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kashna tapugani, ‘Mandaj ¿imadadi rurana gani?’ Mandujka kashna niga, ‘Jatarisha Damascomu ri. Chibimi tuki ima ruranadash ninga.’ ");
INSERT INTO qxl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Chi p'alaniguj ñukada na rikujta rurukimi ñukan rigujkunaga makimunda aisusha Damascomu pushush riga. ");
INSERT INTO qxl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Diosta kazusha manchuj, Moisés mandushkadash kazuj, Damascobi kausuj israelgunash <Alli> nishka Ananías tiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Paiga ñukada rikungu chayamushaga, ‘Wauki Saulo, kambuj ñawin kutin riki,’ ninmi kutin rikusha paida rikugani. ");
INSERT INTO qxl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Chi k'ipa kashna niga, ‘Ñukuchij taitagunaj Diosmi Pai munushkada rijsichun kabishkada Rurujta rikuchun Paibuj shimindi nishkada uyachunmi kandaga agllushka. ");
INSERT INTO qxl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kanmi Pai imalla nishkada uyushkadash rikushkadash tukigunamu yachi chayachingui. ");
INSERT INTO qxl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kununga ama ashtanga shuyushalla jatarisha bautizarisha kambuj juchagunada maillachun Mandujbuj shutibi kayusha mañi,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalenmu kutin shamushaga Diosbuj wasibi mañungu rishami sueño layabi ");
INSERT INTO qxl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mandujta rikuki Paiga, ‘Jerusalenmunda ut'kada llujshisha ri. Ñukamunda kan parlushkadaga na kazungagunachu,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ñukaga, ‘Mandaj, Diosmunda yachana wasigunabi waigusha Kanda crijkunada takusha carcelmu apush rij gashkada tukigunami yachun. ");
INSERT INTO qxl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kanmunda parluj Ishtikuda yaursapada rurusha wañuchigukish chibi gasha <Wañuchilla> nisha wañuchigujkunaj churanadash chapaguganimi.’ ");
INSERT INTO qxl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Shinash Mandujka, ‘Rilla. Ñukaga kanda na israelgunamu karuda kachushami,’ nisha niga.” ");
INSERT INTO qxl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Chigama uyishami, “¡Kai k'ariga na kausanachu! ¡Wañuchichi!” nisha kaparingu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Shina kaparisha churanagunadash chaspisha achpada shitagukimi ");
INSERT INTO qxl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Romamunda soldadogunada mandujka <Soldadoguna kausana wasimu Pabloda pushusha imamunda israelguna p'iñusha shina kaparigushkada parlungama azilgun dalichi> nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Dalingu watusha charigukimi Pablo chibi gaj soldadogunada mandujta, “Romano gakiga imadash narij tapushaidi ¿paida dalinaga kabinchu?” nikimi, ");
INSERT INTO qxl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","kaida uyasha soldadogunada mandujka paibuj mandujmu kashna nisha parlungu riga, “Kununga ¿imadadi rurusha ningui? Kaiga romanomi gashka.” ");
INSERT INTO qxl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Chimunda mandujka Pablomu kuchuyashaga, “Parli, ¿kanga romano ganguichu?” nisha tapuki, Pabloga, “Ari,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Shina nikimi, “Ñuka kai romano gashka shina tukungajka mirga kuchkidami pagagani,” niga. Shina niki Pabloga, “Wacharimundadimi romano gani,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pablo shina nishkamundami paida takungu kallarigujkunash ñash karuyakimi mandujlladikish romano gashkada yachi chayasha paida cadenan watachishkamunda manchanai manchariga. ");
INSERT INTO qxl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kayundij p'unlla Pabloda israelguna imamunda juchachishkada alli yachush nishami mandujka makibi watashka cadenada kacharisha manduj curagunadash Israelgunada Mandujkunapura tandanukuchun mandushka k'ipami Pabloda llujshichisha paigunaj ñaubuki churuga. ");
INSERT INTO qxl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Israelgunada Mandujkunapura Tandanukushkada rikuriashami Pabloga, “Waukiguna, kunungamaga Diosbuj ñaubuki alli yuyigunanmi kausushkani,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Shina nikimi jatun manduj cura Ananiasga Pabloj kuchubi gajkunada <Shimibi takichi> nisha manduga. ");
INSERT INTO qxl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Chimunda Pabloga, “¡Diosmi kandaga takunga, yurajyachishka pirka! Kanlladi mandushkada rurusha juchachingaj chibi tiyashaga ¿imasha mandushkada na kazusha takachun kachungui?” nikimi, ");
INSERT INTO qxl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","chibi gajkunaga, “¿Shinachu Diosbuj jatun manduj curada litungui?” niga. ");
INSERT INTO qxl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Shina nikimi Pabloga, “Waukiguna, ñukaga jatun manduj cura gashkadaga na yachashkanichu. Diosbuj Shimibish, ‘Kangunada mandujta ama <Na alli> nisha rimunguichu,’ nisha escribishkami tiyan.” ");
INSERT INTO qxl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Chi Israelgunada Mandujkunapura Tandanukushkabiga saduceoguna fariseogunash tiyajta yachashami, “Waukiguna, ñukaga fariseosh fariseogunaj familiamundashmi gani. Wañushka k'ipa kausarinada crishkamundami juchachisha llakichish nigunguna,” nisha jinchida kapariga. ");
INSERT INTO qxl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pablo shina ninmi fariseogunaga saduceogunandij paigunapura rimanukungu kallariga. Chimunda mashnalla tandanukusha tiyajkunaga shujta shujta yuyagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Saduceogunaga wañushkaguna kausarinada angelguna tiyanadash ayaguna tiyanadash na cringunachu, ashtan fariseogunaga tuki kaigunada cringunami.) ");
INSERT INTO qxl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","P'iñarinukusha kaparinukuki fariseogunaj parti gaj Moisés mandushkada yachachijkuna jatarisha, “Kai k'ariga ima na allidaga na rurashkachu. Paimunga shuj espíritu na gashaga shuj ángel nishamash nigachari,” rimagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ashtan bulla tukukimi mandujka <Pabloda p'iti p'iti rurangamami> nisha mancharisha chimunda llujshichisha kutin soldadoguna kausana wasimu pushachun nisha paigunada kayachun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kayundij tuta Pablomu Manduj rikurishami, “Pablo, jinchi jinchi shayari. Jerusalén pueblobi ima laya Ñukamunda yachi chayachigangui, shinaidimi Roma pueblobish nina gangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kayundij tutamundaga maijin israelguna ima laya Pabloda wañuchingu yuyarinukusha wañuchingama na mikungu na ubiungu ari ninukugaguna. <Chida na p'aktachikiga Dios ñukuchida llakichichun> nisha sakirigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Chusku chunga yalligunami shina rurungu ari ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Manduj curagunajmu israelgunaj yuyijkunajmushmi, “Ñukuchiga Pabloda wañuchingama imadash ama mikungu chida na p'aktachikiga Dios ñukuchida llakichichun nishami ari ninukuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kununga kanguna Israelgunada Mandujkunapura Tandanukushkandij mandujta <Pabloda ashtan alli tapush ninchi> nishalla kaya kangunaj ñaubujmu pushamuchun nichi. Chimi ñukuchiga narikish chayamujllabidi wañuchingu chapashun,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pabloj panij churi shina ninukujta yachusha soldadoguna kausana wasibi Pablomu yachi chayachingu riga. ");
INSERT INTO qxl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Shina nijta uyishami Pabloga soldadogunada mandujpuramunda shujta kayusha, “Kai musuda mandujbujmu pushusha ri. Paimi shuj parlanada charin,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Chi mandujka pushush risha paida mandujbujmu chayushaga, “Prezu tiyaj Pablomi ñukada kayusha ‘Kai musuda mandujbujmu pushasha ri. Paimi shuj parlanada charin’ niga,” nikimi, ");
INSERT INTO qxl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","mandujka musuda makimunda japisha, chaimu pushusha, “¿Imada nisha ningui?” nisha tapuki, ");
INSERT INTO qxl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","musuga, “Israelgunami, ‘Ashtan alli tapush ninchi,’ nij tukushalla Israelgunada Mandujkuna Tandanukushkaj ñaubujmu kaya Pabloda kan pushachun mañungu ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama cringuichu. Chusku chunga (40) yalligunami wañuchingu mitikusha chapagungaguna. Paigunami Pabloda wañuchingama ama mikungukish ubiungukish chida na p'aktachikiga Dios paigunada llakichichun nisha ari ninukushkaguna. Kununga kan <Ari Pabloda kachushami> nijlladami chapagunguna.” ");
INSERT INTO qxl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Shina nikimi mandujka chi musuda, “Ñukamu kaida nishkadaga p'akta pimush nigunguimu,” nisha kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Paibuj soldadogunada mandujkunamunda ishkida kayushami mandujka, “Kunun tuta iskun urasta Cesarea pueblomu ringu ishki patsuj (200) chakillan rij soldadogunada kanchis chunga (70) caballobi rij soldadogunada ishki patsuj (200) lanzan rij soldadogunadash tandachingu richi,” nisha kachaga. ");
INSERT INTO qxl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","“Pablo sikachunbish caballogunada alli parijash kusha manduj Felixbujmu imash na tukushkalla allida chayachichun,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Paigunanmi shuj cartada kashna nisha rurush kachuga, ");
INSERT INTO qxl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ñuka Claudio Lisias mandujmi. Kan tuki alli manduj nishka Felixta saludani. ");
INSERT INTO qxl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Israelguna kai Pabloda japisha wañuchingu nigukimi romano gashkada yachushkamunda ñukaj soldadogunan risha chi llakimunda llujshichigani. ");
INSERT INTO qxl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Imamunda juchachishkada yachush nishami Israelgunada Mandujkunapura Tandanukushkamu pushugani. ");
INSERT INTO qxl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","‘Ñukuchij israelgunaj mandushkada na kazun’ nishallami juchachishkagunaga. Ñuka yuyibiga ima na allida na rurushkamundaga imamunda wañuchinama carcelbi churanamash na gagachu. ");
INSERT INTO qxl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Israelguna wañuchingu yuyarinukujta yachi chayunmi kanmu kachani. Paida imamunda juchachishash kambuj ñaubuki nichun nishami chi juchachijkunadash nishkani.” ");
INSERT INTO qxl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Soldadogunash mandushkada uyushami Pabloda Antípatris pueblomu chi tutaidi pushush rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kayundij p'unllami caballon rij soldadogunallada Pablon kachusha chakin rij soldadogunaga paigunaj kausana wasimu kutin shamugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesareamu chayasha cartada kushami Pablodash manduj Felixmu kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Chi cartada liyashka k'ipami manduj Felixga, “Pabloga ¿maimundadijkun?” nisha tapuga. Cilicia llaktamunda gashkada yachi chayashami, ");
INSERT INTO qxl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Juchachijkuna shamuki kan ima nijtash uyusha,” nishka k'ipa, soldadoguna Pabloda alli chapachun nisha manduj Herodes tiyashka wasibi churachun manduga. ");
INSERT INTO qxl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pichka p'unlla k'ipami jatun manduj cura Ananiasga yuyijkunan abogado Tertulonbish Cesarea pueblomu chayugaguna. Paigunaga gobernadorbuj ñaubuki Pabloda juchachingumi riga. ");
INSERT INTO qxl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pabloda Felixbuj ñaubujmu pushamukimi paida juchachingu Tertuloga chi mandujmu kashna nisha kallariga, “Kan alli yachuj gashkamundami kai llaktabi alligunada rurushkangui. Kanmundami piyunbish na takanukusha k'uilla kausagunchi. ");
INSERT INTO qxl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kaida japishami maibi gashash p'unllandi <Diosolopai> ninchi, alli manduj Felix. ");
INSERT INTO qxl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Chimundami ama ashtandadi kainangu ñukuchi ima nishkada ashawaida uyabachun mañani. ");
INSERT INTO qxl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kai Pablomi unguida yayuj shina tuki kai pachabi kausuj israelpuragunada jatarichisha purij gashkada yachashkanchi. Paimi Nazaretmunda Jesusta katijkunadash pushuj gan. ");
INSERT INTO qxl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Diosbuj wasida mapayachij laya rurusha munushkamundami prezusha ñukuchij leybi mandushka shina tapungu kallariganchi. ");
INSERT INTO qxl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Manduj Lisias shamushaga jinchida chutusha ñukuchij makimunda kichusha ");
INSERT INTO qxl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","maijin paida juchachijkunaga kambuj ñaubujmu richun nisha kachuga. Ñukuchi juchachigushkaga kabishka gashkada yachungujka kanlladi tapi pudinguimi,” nikimi, ");
INSERT INTO qxl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","mashnalla chibi gaj israelgunash shinadash juchachisha <Ari, shinami gan> nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pablo rimarichun gobernador señasta rurukimi paiga, “Tauga watagunada kai llaktada kan alli na alli gashkada juchachij gashkamundami kushilla ñuka ima shina gashkada parlani. ");
INSERT INTO qxl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kanlladi tapusha alli yachi pudinguimi. Ñuka Diosta <Allimingui> ningu Jerusalén pueblomu ichiyashkaga chunga ishki (12) p'unllagunallami tukun. ");
INSERT INTO qxl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ñukada juchachijkunaga ñukadi Diosbuj wasibi p'iñada rimanukugujtash Diosmunda yachana wasigunabi chi pueblobi maibi gakish bullada rurachun waikada jatarichijtash na japigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Shinusha kunun ñukada juchachigushkadaga ima laya na rikuchi pudingagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ashtan kailladami nisha nini: Ñuka ñauba taitagunaj Diosta crisha Paibujta rurukimi paigunaga ‘Ñanda katij’ nisha juchachinguna. Ñukaga tuki imalla Moisés mandushkagunadash Dios nishkada parlujkunadash escribichishkabi crinimi. ");
INSERT INTO qxl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Alligunash na alligunash wañushka k'ipaga kausarinashkada crisha paiguna layaidi Diosbi yuyida churushami chapani. ");
INSERT INTO qxl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Shinushami Diosbuj ñaubuki tukigunaj ñaubukish ñukaj yuyigunan linshu gangu p'unllandijta ashtan munani. ");
INSERT INTO qxl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Tauga watagunada shuj llaktagunabi purishka k'ipami ñukaj llaktabi na charijkunamu kumbidashkada apangaj Diosmush kungukish Jerusalenmu shamugani. ");
INSERT INTO qxl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Diosbuj ñaubuki alli rikuringaj mandushkabi nishka shina linsharishka k'ipa Diosbuj wasi ukubi purikimi Asia llaktamunda tauga israelguna ñukada japigaguna. Chibi gashash taugagunada tandachishama bulla rurushamash na puriganichu. Ñukada imada juchachish nishash paigunami kambuj ñaubuki ña gana gan. ");
INSERT INTO qxl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Shinakiga Israelgunada Mandujkunapuralla Tandanukushkaj ñaubuki ñuka ima na alli rurushkada japishkakiga kaibi gajkunallash kanmu nichun. ");
INSERT INTO qxl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ñuka shuj nishkamundaga paiguna juchachi pudinguna. Paigunan gasha jinchida kaparisha, ‘Wañushkaguna kausarinada crishkallamundami kangunaj ñaubuki kunun juchachigunguichi,’ nigani,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Manduj Felixga Ñan ima layashkada alli yachuj gashami, “Kununga kanda imamunda juchachishkada rikuchingu parlashkada sakishunchi. Manduj Lisias shamukimi kanguna ima juchachigushkada alli yachusha ñuka imaidash nisha,” sakisha ");
INSERT INTO qxl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Felixga soldadogunada mandujta <Ama prezu laya gachun Pabloda kacharishka laya chapangui. Paibuj rijsishkagunash imada kugukish sakinguilla> nisha manduga. ");
INSERT INTO qxl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Shuj p'unllaguna k'ipaga Felix israelgunamunda paibuj warmi Drusilandij kutin shamushaga Pabloda kayachun kachusha, Jesucristoda ima laya crinada parlachiga. ");
INSERT INTO qxl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pabloga kabishkada ruranada na alli yuyigunada jarkarinada Dios llakichina p'unlla juchachinadash nikimi Felixga mancharisha, “Kununga rilla. Kutin parlachun nishaga kayushallami,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kacharichun nishkan <Kuchkida kungami> yuyishami Felixga tauga kutin Pablon parlanukungaj kayachun kachagugalla. ");
INSERT INTO qxl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ishki watadami shina katiga. Chi k'ipa Felix mandashkamunda llujshikimi Porcio Festo nishka waiguga. Felixga israelgunaj ñaubuki alli rikuringu nishami Pabloda prezu sakisha llujshiga. ");
INSERT INTO qxl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Cesarea pueblobi mandangu chayushka kinsa p'unlla k'ipami Festoga Jerusalén pueblomu ichiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Chimu chayukimi manduj curaguna israelgunada shuj pushujkunash Festojmu risha Pabloda juchachigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Paigunaga ñanllabidi wañuchichun mandangu yuyarinukushami <Ñukuchij allida rurusha Pabloda Jerusalenmu kachachun mandabai> nisha mañagugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Shina nikimi Festoga, “Pablodaga Cesareabimi prezu charigunguna. Ñukaidi ñallami chimu risha. ");
INSERT INTO qxl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Chimundaga kangunada pushujkunash Pablo ima na allida rurashkakiga chibi juchachingu ñukan Cesareamu richun,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festoga pusuj p'unlla na gashaga chunga p'unlla shinaida Jerusalenbi gashka k'ipami Cesareamu kutin riga. Kayundij p'unllaga juchachishka gachun mandanabi tiyarisha Pabloda pushamuchun kachuga. ");
INSERT INTO qxl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pablo waigukiga Jerusalenmunda shamuj israelguna paibuj muyundiki <Paiga manchanai na allida rurajmi> nisha kaida chaida juchachigushash shinashkada na rikuchi pudigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Shinakimi yanga juchachishkada rikuchish nisha Pabloga, “Israelgunaj mandushkada Diosbuj wasida Cesardash ima na allidaga na rurashkanichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Israelgunaj ñaubuki alli rikuringu nishami Festoga Pabloda, “¿Kai juchachishkagunamunda Jerusalenbi tapik'ichusha alli yachachun ringuimuchu?” nisha tapuga. ");
INSERT INTO qxl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Shina tapukimi Pabloga, “César churashka juezkunaj ñaubukimi gani. Kaillabidi juchachishkami ganani. Israelgunada ima na allida na rurushkadaga kanlladi yachunguimi. ");
INSERT INTO qxl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ñuka ima na alli rurushkada japisha wañuchina gakiga wañuchichunlla na manchanichu. Ima na allida paiguna juchachishkada ima shinashkada na rikuchikiga pish na ñukada paigunamu kui pudinchu. Shinusha Cesarbuj ñaubukimi juchachishkamunda parlangu munani,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festoga paida yuyachijkunada tapushka k'ipa kashna niga, “Kanlladi Cesarbuj ñaubuki parlangu mañuki paibujmumi ringui.” ");
INSERT INTO qxl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Shuj p'unllaguna k'ipa jatun manduj Agripaga paibuj pani Berenicen Cesareamu Festoda <¿Allillachu gangui?> ningu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Tauga p'unllagunada chibi gakimi Festoga jatun mandujmu Pablomunda parlungu kallarishaga, “Manduj Felix sakish rishka k'arimi kaibi prezu tiyan. Paidaga ");
INSERT INTO qxl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalenbi gakimi manduj curaguna israel yuyijkunandij <Juchachisha wañuchichun nibai> nisha ñukada mañugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ñukaga kashna nigani ‘Juchachijkunan narij ch'imbapura imamunda na alli juchachishkada rikuchingu ñukuchij ñaubuki ninukujllabidijka Roma llaktamunda mandujkunaga na wañuchichun mandanchichu.’ ");
INSERT INTO qxl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Paiguna tandanukusha kaimu shamukimi na shuyushalla kayundijti juchachishka gachun mandanabi tiyarisha Pabloda pushamuchun kachugani. ");
INSERT INTO qxl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Paida juchachisha nijkuna shayarishash na ima milligunada rurashkadash na ñuka yuyashka layadash nigagunachu. ");
INSERT INTO qxl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ashtangarin Pabloda juchachisha paibuj crinagunallamunda wañushka Jesusmundash rimagaguna. Shinash Pabloga <Jesusga kausagunmi> niki ");
INSERT INTO qxl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ñukaga imadash na ruri pudishami Pablodaga <¿Kai juchachishkagunamunda Jerusalenbi tapik'ichusha alli yachachun ringuimuchu?> nisha tapukiga ");
INSERT INTO qxl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","<Cesarmi tapuchun mañani> nikimi ñuka Cesarmu kachi pudingama prezu charichun nisha mandugani,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripaga Festoda, “Ñukash Pablo ima nijta uyush ninimi,” nikimi, Festoga, “Kayaidimi uyangui,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kayundij p'unlla jatun manduj Agripaga paibuj pani Berenicendij k'uilla churanada churarishka soldadoda mandujkunandij chi puebloda manduj k'arigunanbish Festoj mandana jatun wasi ukumu waiguki Festoga Pabloda pushamuchun kachusha ");
INSERT INTO qxl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","kishna niga “Jatun manduj Agripa, mashnalla ñukuchin kaibi tandanukushka gajkunash Jerusalenbi kai Cesareabish tauga israelguna juchachisha wañuchichun nisha kaparigushkaga kaibimi gan. ");
INSERT INTO qxl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ñuka rikibiga wañuchichun kachungukish pai ima na allidaga na rurashkachu. Shina gashash pailladi Cesarmu kachachun nisha mañukimi chimu kachush niguni. ");
INSERT INTO qxl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ñukaga Roma llaktada Jatun Mandujmu paimunda imadash na escribish kachi pudishami kaibi gajkunamush tukigunamunda yalliga kan jatun manduj Agripaj ñaubujmumi pushamushkani. <Tapik'ichushka k'ipaga imalladash escribish kachi pudishami> yuyusha kaidaga rurashkani. ");
INSERT INTO qxl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ñuka rikibiga shuj prezuda imamunda juchachigushkada na parlushalla kachanaga na allichu.” ");
INSERT INTO qxl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Chimunda Agripaga Pabloda, “Kan kikinllamundadi parlachun sakinchi,” shina nikimi yanga juchachishkada rikuchingu munusha Pabloga tukiguna upayachun makida alsusha kashna ningu kallariga, ");
INSERT INTO qxl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Jatun manduj Agripalla, ñukada israelguna juchachigushkamunda kambuj ñaubuki parlachun sakishkamundami kushiyachishka gani. ");
INSERT INTO qxl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Israelgunapurash ima laya ruruj imamunda rimanukujta kanlladi alli rijsij gashkamundami ashtan kushilladi gani. Chimunda ñuka nishkada na p'iñarishalla uyabachun mañani.” ");
INSERT INTO qxl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ñukaj llaktabish Jerusalén pueblobish uchillamunda pacha ñukuchipurabi ñuka ima shina kausushkada tuki israelgunami alli yachunguna. ");
INSERT INTO qxl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Israelgunamunda yallida p'aktachichisha nij fariseo nishkagunamunda ñuka uchillamunda pacha p'aktachij gashkada israelgunaga rijsingunami. Ñukamunda maijin parlangu munashaga parlachunlla. ");
INSERT INTO qxl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ñukaga <Ñukuchij ñauba taitagunamu Dios <Kushami> nishkadaga kungami> nisha chapagushkallamundami kaibi juchachishka shuyaguni. ");
INSERT INTO qxl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ñukuchij chunga ishki (12) tribugunaga tuki Pai nishkada p'aktachun chapashami Diosta <Allimingui> nisha tuti p'unlla rurunguna. Ñukadash chi <Kusha> nishkada crishkallamundami israelguna juchachinguna, jatun manduj Agripa. ");
INSERT INTO qxl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Imasha kangunaga <Wañushkagunada Dios kausachingami> nishkada na cringuichi?” ");
INSERT INTO qxl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Sarunga ñukaidimi <Nazaretmunda Jesusbuj shutida jarkasha imadash rurana gani> nisha yuyagani. ");
INSERT INTO qxl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Shinushami Jerusalenbiga shinada rurugani. Manduj curagunada permisoda mañusha Dios linshuyachishka taugagunada carcelbi churugani. Paigunada wañuchikish ‘Allimi gan’ niguganimi. ");
INSERT INTO qxl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Paiguna Jesusta na valichisha rimachun nishami tauga kutin Diosmunda yachana tuki wasigunabi paigunada japisha takugani. Manchanai p'iñusha karu pueblogunadash risha katik'ichusha llakichijmi gagani.” ");
INSERT INTO qxl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Llakichina yuyin gashami manduj curaguna permisoda kusha kachakish Damasco pueblomu rigani. ");
INSERT INTO qxl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ñanda rigukimi chaubi p'unlla jawa pachamunda indidash yalli p'alaniguj ñuka muyundiki rijkunaj muyundikish p'alanijta rikugani, jatun manduj Agripa. ");
INSERT INTO qxl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tukiguna pambamu urmuganchi. Chibimi hebreo shimibi, ‘Saulo, Saulo ¿imamundadi katik'ichungui? Ñukada katik'ichushaga akuja laya jatun kaspibi jaitusha chugrij shinami kanlladadi na allida ruragungui,’ nijta uyugani. ");
INSERT INTO qxl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Manduj ¿pidij gangui?’ nisha tapukimi Mandujka, ‘Ñukaga kan katik'ichushka Jesuslladimi gani. ");
INSERT INTO qxl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Shinushaga jatarisha shayari. Ñukajllada rurachunmi kandaga churani. Kunun ima tukushkada rikushkadash k'ipalla ñuka ima rurujta rikushash parlachunmi kambuj ñaubuki rikurishkani. ");
INSERT INTO qxl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israelgunamundash na israelgunamundash kanda kacharichisha na israelgunamu kunun kandaga kachani ");
INSERT INTO qxl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ama tutabi shinalla purisha paigunaj ñawida paskuj shina p'unlla layada rikuchun Satanasbuj podermunda llujshisha Diosta katichun. Ñukada crikimi Diosga juchagunadash perdonanga. Shinami Pai linshuyachishkagunamu <Kushami> nishkadash japingaguna,’ niga.” ");
INSERT INTO qxl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Shinushami sueñobi laya jawa pachamunda rikushkadaga kazugani, jatun manduj Agripa. ");
INSERT INTO qxl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Damasco pueblobi parli kallarisha Jerusalenbish Judea kuchu tuki llaktagunabish na israelgunamush <Juchagunada sakisha Diosmu vueltarisha Paida kazusha juchagunada sakishkada alligunada rurashkagunan rikuchinguichi> nigani. ");
INSERT INTO qxl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Chillamundami Diosbuj wasibi ñukada japisha israelgunaga wañuchingu yuyarinukushkaguna. ");
INSERT INTO qxl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Shinash kunungama Dios ñukada rikugukimi uchillagunamush jatungunamush Diosmunda parlusha alli katishkani. Ñukaga imadash mirachishaga na nishkanichu, ashtangarin Dios nishkada parlujkuna Moisesbish <Kashnami tukunga> nisha parlushkaidami nigani. ");
INSERT INTO qxl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Paigunaga <Cristoga llakichishka gasha wañushkagunaj chaubimunda ñaubusha kausarisha israelgunamush na israelgunamush p'unllayachij shina kishpichinada ningami> nigaguna. Ñukaga chidami nisha puriguni,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Shina nisha Pablo nikimi Festoga, “¡Yuyi illuj tukushkangui, Pablo! ¡Yalli yachuj tukushami locomadi gangui!” nisha kapariga. ");
INSERT INTO qxl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Shina kaparikimi Pabloga, “Na locochuni, alli manduj Festo, ashtan ñuka nishkaga na llullashkachu, kabishkami gan. ");
INSERT INTO qxl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kaibi tiyaj jatun manduj Agripash tukidami yachun. Shinushami paibuj ñaubuki imadash na pakushalla nini. Paiga tuki kaigunadash yachashkadaga ñukaga allimi yachani. Kai nishkaga mai karu pakalla pushtumabish na tukushkachu. ");
INSERT INTO qxl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Jatun manduj Agripa, ¿Dios nishkada parlujkuna nishkada cringuichu? Kan crishkada ñukaga yachanimi,” niki, ");
INSERT INTO qxl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripaga, “¿Ashallada parlashachu crij tukuchun munangui?” niga. ");
INSERT INTO qxl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Shina nikimi Pabloga, “Ashamunda na gashaga mirgamundash na kan jatun mandujlla ashtangarin tuki kaibi uyujkunash ñuka laya crij gachunmi Diosta mañani, ashtan ñuka laya cadenan watushka gachunga na munanichu,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Chi k'ipaga jatun mandujkish mandujkish Berenicendij chibi tuki tiyajkunandij shayarisha ");
INSERT INTO qxl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","chi ukumunda llujshishami, “Kai k'aridaga wañuchinash carcelbish churanallash na kabinchu. Ima millidaga na rurushkachu,” nisha paigunapuralla ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripaga Festoda, “Pailladi <Cesarbuj ñaubukimi juchachishkamunda parlasha nini> nisha na nishkakiga paida kachari pudinchimumiga,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italia llaktamu ñukuchida kachungu yuyarishami Pablodaga chaishuj prezugunandijka <Batallón Imperial> nishkamunda soldadogunada manduj Julio shutimu kugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Shina kachukimi Adramitio pueblomunda Asia llaktabi barcoguna tiyarinagunamu riguj barcobi sikuganchi. Chi barcobiga Macedonia llaktabi tiyaj Tesalónica pueblomunda Aristarcosh ñukuchinmiga. ");
INSERT INTO qxl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kayundij p'unllaga Sidón pueblomu chayuganchi. Chibimi manduj Julioga Pabloda llakisha imada kukish japichun paibuj rijsishkagunada rikungu richun sakiga. ");
INSERT INTO qxl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Jatun barcobi sikusha Sidonmunda llujshisha riguki manchanai waira shamuki wairada mitikungaj nisha Chipre islaj alli laduda riganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cilicia Panfilia llaktaguna ch'imbapurada rigushami Licia llaktabi gaj Mira pueblomu chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Chibimi soldadogunada mandajka Italia llaktamu riguj Alejandría pueblomunda barcoda japisha chibi sikachiga. ");
INSERT INTO qxl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tauga p'unllagunada gushtulla risha manchanai shaikusha Gnido pueblo ch'imbapuramu chayuganchi. Waira ashtan jarkukimi Creta islada lluki laduda riganchi. Salmón achpa ch'imbapurada rigushami ");
INSERT INTO qxl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","trabajollandi yaku manya manya risha Lasea pueblo kuchubi gaj barcoguna chayana <Alli Tiyarinaguna> shuti pushtumu chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tauga p'unllagunada uniyashkamunda Na Mikuna P'unllaguna tukuriki yakuda rish katina llaki tukunalla gakimi Pabloga, ");
INSERT INTO qxl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“K'ariguna, jatun llakimi tukunashka gashkada riki pudini. Kai tuki ima apashkagunash kai barcosh yakubi chingarinmu. P'akta ñukuchikish wañunchimu,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Shina nikish soldadogunada mandujka Pablo nishkada na uyusha ashtan barco dueñodash pushajtashmi kazuga. ");
INSERT INTO qxl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Tamia p'unllaguna chayuki chibi tiyana na alli gakimi chimunda llujshisha <Ima layash Fenice pueblomu chayashunchi; tamia killagunadaga chaibi sakirishun> ari ninukugaguna. Chi pueblobiga Creta islabi barcoguna tiyarinamiga; jawamunda uramunda waira shamushash mana imada rurujchu gaga. ");
INSERT INTO qxl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lluki ladumunda ashalla waira shamukiga <Rishunllami> yuyusha barcoda charirij jerrogunadash japisha chimunda llujshisha Creta isla ladu ladu rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Shina rigukimi akapana laya Euroclidón shuti wairadi alli ladumunda shamusha barcon tupanukushaga ");
INSERT INTO qxl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","t'angusha ringu kallariga. Barcoda wairan ch'imbapura na jinchi shayachi pudishkamundami waira apachun sakina tukuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Clauda nishka uchilla isla washa laduda rigushami canoada pudi na pudiidi sikachisha shaikuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Chi uchilla canoada barcomu sikachishka k'ipami barcoda waskagunan jinchida watugaguna. Sirte nishka yugzi achpa muntunbi pambarinada manchushami barcoda purichij linsuda uriyachisha waira apushkaida ringu sakigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kayundij p'unllash ashtan waira gakimi barcobi imallada apagushkagunadaga yakubi shitungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ña kinsa p'unllada shina gajllabimi kikingunaj makin barcoda wambuchingu imalla charishkada yakubi shitugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tauga p'unllagunada indish luzerogunash na rikuriki manchanaidi waira kaimu chaimu piguik'ichukiga <Ña na kausashunchu> yuyuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Shinaidi tauga p'unllagunada tukiguna na mikushka gashami Pabloga tukigunaj chaubibi shayarisha, “Tuki kaibi gajkuna, ñukada kazusha Creta islamunda na llujshishka gashaga allimi ganchimuga. Kai llakidash na rikusha imadash na shitunchimuchuga. ");
INSERT INTO qxl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kununga ñaubujmu katina yuyida japichi. Shujllash na wañungachu. Shinash barcollaga chingaringami. ");
INSERT INTO qxl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ñukaga Diosbuj gasha Paida sirvij gakimi kunun tuta Paibuj angelda kachaga. ");
INSERT INTO qxl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Chi angelmi ñukadaga, ‘Pablo, ama mancharichu. Cesarbujmu chayanadimi gangui. Shinalladi kai barcobi tuki kangun rigujkunash kanmundami kausachun Diosga sakinga,’ niga. ");
INSERT INTO qxl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Shinushaga kaibi gaj taitaguna, ñaubujmu katina yuyida japichi. Ñukamu ángel nishkada Dios p'aktachinada crinimi. ");
INSERT INTO qxl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ñukuchiga maijin islamush shitushkami gana ganchi,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ña ishki semanadami riguganchi. Adriático nishka jatun yaku kuchabi gasha kaimu chaimu apik'ichushka rigushami chaubi tuta shinada barcoda purichijkunaga <Ña achpamu chayagushkalayanchin> yuyasha ");
INSERT INTO qxl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","junduda midiki kinsa chunga kanchis (37) metromi gashkaga. Asha ñaubuki kutin midikish ña ishki chunga kanchis (27) metrollami gashkaga. ");
INSERT INTO qxl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Rumigunan takarinada manchushami barco washa ladumu yaku ukubi charirij chusku jerrogunada washamu kacharishami <Ut'kada p'unllayachun> nisha Diosta mañagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Shinash shujkuna na yachajllabi barcoda purichijkunaga wañunada manchusha shitusha ringu munushami ñaubuki barcoda charirij jerrogunada kacharij tukushalla uchilla canoada uriyachingu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Chida rikushami Pabloga soldadogunada mandujmu paibuj soldadogunamush, “Paiguna na barcobi sakirikiga kanguna na kishpiri pudinguichichu,” nikimi ");
INSERT INTO qxl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","soldadogunaga chi uchilla canoada watushka waskagunada p'itiki yakubi urmaga. ");
INSERT INTO qxl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Puzu puzumi Pabloga tukigunamu imaidash mikuchun ñaubujmu katina yuyidash yuyachiga. “ <¿Imashi tukushun?> nigusha ishki semanadami imadash na mikushalla katigushkanguichi. ");
INSERT INTO qxl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kausush nishaga imaidash mikunaminguichi. Kangunamundaga ni pish shuj juakchawaidash na chingachingachu,” niga. ");
INSERT INTO qxl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kishna nishka k'ipami Pabloga tandada japisha tukigunaj ñaubuki Diosta <Diosolopai> nisha chaubisha mikungu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Chimundami ñaubujmu katina yuyida kunukusha tukigunami mikugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Chi barcobiga ishki patsuj kanchis chunga sujtapurami (276) gaganchi. ");
INSERT INTO qxl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Sajsushka k'ipami barco p'angayachun nisha trigoda yakumu jichushtagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ña p'unllayaki barcoda purichijkuna mai achpabi gashkada na rijsigagunachu. Shinash achpabi yaku waigurishka rikurikimi manya achpada rikusha barcoda chimu kuchuyachingu munushami ");
INSERT INTO qxl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","barcoda charirij watushka waskagunada p'itisha yakubi kacharisha barcoda pushaj kaspigunadash plujushka k'ipaga waira t'angachun nisha ñaubuj ladu linsuda alsuki barcoga yaku manya achpamu kuchuyangu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Shina rigushami yugzi achpa muntunbi takarisha ñaubuj laduga chi pushtubi jinchi tukusha maimu na kuyuri pudisha tiyarikimi washa laduda yaku jatarisha pachun juaktuki illijta p'akiringu kallariga. ");
INSERT INTO qxl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Prezuguna ama nadusha vincish richun nishami soldadogunaga wañuchingu yuyarinukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Pabloda kausujta pushungu munushami soldadogunada mandujka na wañuchichun sakisha <Maijin nadungu yachujkunaga ñaubusha risha achpabi chapungu richi. ");
INSERT INTO qxl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Chaishujkunaga barco p'akirishka kaspigunabi tablagunabish wambusha katichun> niga. Shina rishami tukiguna achpamu kausuj chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tukiguna yakumunda kausuj llujshishami chi islaga Malta shutishkada yachi chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Chi islabi kausujkunaga ñukuchida llakisha alli japishami tamiabi chirin kindiyaguki ninada japichisha kunuchun kayugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pablo chakishka mirga yantada tandusha ninabi churakimi shuj culebra nina calurda mitikusha llujshimusha paibuj makida kanisha chaririga. ");
INSERT INTO qxl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Pabloj makibi culebra warkuriajta rikushami chibi kausujkunaga, “Paiga wañuchijmishkanga. Yakumunda kausuj llujshimukish ashtan ñukuchij diosmi na kausachun sakin,” nisha ninukugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pablo paibuj makimunda culebrada ninabi chaspishtasha imash na tukugachu. ");
INSERT INTO qxl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","<Ñallami maki p'unguinga na gashaga wañungadikishchari> nisha chapariagaguna. Unida chapashash imash na tukujta rikushami shuj yuyida japisha <Pabloga diosmi gashkanchin> ninukungu kallarigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ñukuchi kunugushka kuchubi sirij achpaga chi llaktada manduj Publio shutijmi gashkaga. Paiga ñukuchida llakisha kinsa p'unllagama paibuj wasibi alli japiga. ");
INSERT INTO qxl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publioj wasibimi paibuj taita calenturan yaur kicha unguin k'awitubi sirishkaga. Pablo chida rikungu risha Diosta mañushka k'ipa paibuj makida ungushkaj jawabi churusha alliyachiga. ");
INSERT INTO qxl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Shina alliyachishkamundami chi islabi kausuj chaishuj ungushkagunash Pablojmu shamusha tukiguna alliyaga. ");
INSERT INTO qxl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Paigunaga ñukuchida manchanaidi k'uyushkada rikuchiki ña ringu barcobi sikuki ñukuchij ima ministishkada kusha kachugaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kinsa killada chi islabi purishka k'ipami tamia killaguna pasungama chibi sakirij barcobi sikuganchi. Alejandría pueblomunda barcoga Cástor nishka Pólux nishka dioskunaj musrhayujmi. ");
INSERT INTO qxl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Chibi rishami Siracusa pueblomu chayusha kinsa p'unllada chibi gaganchi. ");
INSERT INTO qxl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Chimunda llujshish risha chi llakta ladu ladu rishami Regio pueblomu chayuganchi. Kayundij p'unllaga washa ladumunda waira t'angakimi shuj p'unlla k'ipa Puteoli pueblomunga chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Chi pueblobimi shuj crijkunan tupusha kanchis p'unllada paigunan sakirichun niki sakirishka k'ipa rigushkan Roma pueblomunga chayuganchi. ");
INSERT INTO qxl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romabi crijkunaga ñukuchi chi llaktamu shamugushkada yachushami Apio pueblo lasabi Kinsa Pozada shuti pueblobish chapungu llujshishkagunaga. Paigunada rikushami Pabloga Diosta <Diosolopai> nisha ashtan kutin alli katina yuyida japisha kushiyaga. ");
INSERT INTO qxl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romamu chayushami shuj wasibi Pablodaga shuj soldadolla chapushka kausachun romanogunaga sakigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Romamu chayushka kinsa p'unlla k'ipami Pabloga israelgunapuramunda pushujkunada kayachun kachuga. Paiguna tandanukukimi kashna niga, “Crijkuna, ñukaga israelgunada imada na rurushkanichu. Ñukuchij ñauba taitaguna imada ruraj gashkada ruranadash na sakiganichu. Shinash Jerusalén pueblobimi ñukadaga israelguna prezu japishka, romanogunamu kushkami. ");
INSERT INTO qxl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Chi romanoguna ñukada alli tapik'ichushka k'ipa ima kauzadash na charishkamundaga na wañuchi pudisha kacharisha kachungu munagaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ashtan israelgunaga manchanai p'iñarigaguna. Shinushami <Ñukaga Cesarbuj ñaubukimi juchachishkamunda parlangu munani> nisha mañanami gagani. Shinash ñukaj llaktamundagunadaga ima juchachinadash na chariganichu. ");
INSERT INTO qxl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Israelguna shuyagushkada crishkallamundami kaibi kashna cadenan watushka tiyaguni. Kishna tukushkada kangunada rikusha ningullami kayugani,” nisha niga. ");
INSERT INTO qxl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Shina niki paigunaga, “Ñukuchiga kanmunda imadash nisha Judea llaktamunda wauki panigunaj cartalladash na japishkanchichu. Judeamunda shamuj ñukuchipuragunash maijinbish kanmunda <Na alli ruranchu> nishkalladash na uyashkanchichu. ");
INSERT INTO qxl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kan yachachishka mushuj yachanada tuki llaktagunabi na allibi churashka gashkada yachunchimi. Chimunda kan ima yuyishkadami uyush ninchi,” nigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Chimundami kayushka p'unllabi taugaguna tandanukusha ima nijta uyungu pai kausashka wasimu shamugaguna. Chibimi Pabloga paiguna Jesusta crichun Moisés mandushkabi Dios nishkada parlujkuna escribishkabi rikuchish katishami Dios ima shina mandanashkadash tutamunda kallarisha tuki p'unlla parluga. ");
INSERT INTO qxl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Pablo nishkada uyusha maijingunaga criga; shujkunaga na crigachu. ");
INSERT INTO qxl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Paigunapura na shuj yuyilla tukusha llujshisha ringu kallarikimi Pabloga kishna niga, “Diosbuj Espíritu yuyachisha Dios nishkada parluj Isaiasta ñukuchij ñauba taitagunamu allimi kashna nisha parlachishka, ");
INSERT INTO qxl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Israelgunamu kashna ningu ri: “Uyagushash na intindinguichichu. Rikuriashash na rikuj shinami ganguichi.” ");
INSERT INTO qxl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","¿Imamunda? Israelgunaj shungugunaga rumi shina jinchiyashkami, rinringunash na laru uyanchu, ñawigunash ichkashkami. Na shina gashkashaga ñawigunan rikunmumi, rinringunan uyanmumi, shungun intindinmumi, Ñukajmu vueltunmumi, shinaidi Ñuka alliyachinimumi,’ nishkami. ");
INSERT INTO qxl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Kununmundaga kishpichinada na israelgunamu Dios kushkada yachichi. Paigunaga uyingami,” Pabloga niga. ");
INSERT INTO qxl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pablo shina nijta uyashka k'ipami israelgunapuraidi rimanukusha rigaguna. ");
INSERT INTO qxl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pabloga ishki wata jundada pai arrendashka wasibi kausushami tuki rikungu shamujkunada alli japisha katijllamiga. ");
INSERT INTO qxl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Shina shamukimi Dios ima laya mandana gashkada parlusha Manduj Jesucristomundash na manchusha yachachisha pish na imada nishka kausuga.");
INSERT INTO qxl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ñukaga, Jesucristobujta rurujkish, Dios agllusha kachushka gachun kayashkash shinaidi Diosbuj Alli Shimida yachi chayachichun ch'ikunyachishka Pablomi gani. ");
INSERT INTO qxl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Chi Alli Shimidaga Diosga Pai nishkada parlujkunamu ñaubamu escribichisha Paibuj jucha illaj Shimibi <Kushami> nishkaga. ");
INSERT INTO qxl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Kai Alli Shimiga ñukuchij Mandaj Jesucristomundami parlan; Paiga aichamunda rikukiga Rey Davidbuj wawagunaj wawagunamundami wachariga; Paiga ima mapash illuj Espiritumundaga, wañushkagunaj chaubimunda kausachikimi poderyuj Diosbuj Churi gashkada rikuchishka gaga. ");
INSERT INTO qxl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesucristomundami Paida sirvichun agllushkash kachushkash gasha, jatun kushida japigani. Tuki llaktagunabi Paida crisha kazujkuna tiyachunmi shina ruraga. ");
INSERT INTO qxl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Chigunapuramundaga kangunashmi Jesucristoj gachun kayashkaguna ganguichi. ");
INSERT INTO qxl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Tuki mashnalla Romabi gaj Dios k'uyashkagunalla, Diosbujlla gachun kayashkaguna: ñukuchij Taita Diosbuj shinaidi Mandaj Jesucristoj kushka alligunash k'uilla kausish kangunan gachun. ");
INSERT INTO qxl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kallaringaudijka ñuka Diostaga, Jesucristoj shutibi tuki kangunamunda <Diosolopai> niguni; illujta kai pachabiga kanguna Diosta crishkadaga alli parlashkagunami. ");
INSERT INTO qxl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Paibuj Churimunda Alli Shimida parlusha ñuka tuki shungumunda sirvishka Diosmi ima urash na kungarishalla kangunamunda Paida mañagushkadash alli yachan. ");
INSERT INTO qxl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Diosta mañagushami Paibuj muni gakiga kunun maidikish kangunada rikungu ringu ñanguna paskarichun p'unllandijta mañagunilla. ");
INSERT INTO qxl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kanguna jinchi crijkuna gachun, Diosbuj Espiritumunda japishkada yachachingajmi kangunada manchanaidi rikungu munani. ");
INSERT INTO qxl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ashtan laru ningajka, kangunash ñukash chi Dioslladadi crishkamunda kaishuj chaishujkun ñaubujmu katina yuyin kushiyanukungajmi gan. ");
INSERT INTO qxl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Wauki paniguna, kaida yachachunmi munani, tauga kutinmi kangunada rikungu ringu munagani; shina gakish kunungamami trankaguna rikurigushkalla. Chimu rishaga ima layami shuj llaktagunabi japigani, shina layaidi kangunapurabibish granoda shina tandachingu munani. ");
INSERT INTO qxl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Griegogunamush na griegogunamush, yachujkunamush na yachujkunamushmi dibijma laya gani; ");
INSERT INTO qxl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","shinushami ñukaga kanguna Romabi kausujkunamush Alli Shimida parlungu manchanaidi munani. ");
INSERT INTO qxl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ñukaga Alli Shimimundaga nalladi pinganachinichu; chi Shimiga Diosbuj poder gashkamundami tuki mashnalla crijkunadaga kishpichingaj gan; kallarimunga israelgunamu, chi k'ipaga na israelgunamushmi gan. ");
INSERT INTO qxl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ñukuchida ima juchachinash illajta Dios rurashkadami kai Alli Shimiga rikuchin; chiga crishkallamundami gan. Dios escribichishkabi nishka shinaga, “Juchachinash illujka crishkallamundami kausanga.” ");
INSERT INTO qxl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Diosga tuki na alli rurushkadash genteguna milligunada rurushkadash Pai p'iñarishkadaga jawa pachamundami rikuchin; na allida rurushami kabishka shimida jarkusha charinguna. ");
INSERT INTO qxl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Diosmunda ima yachanaga paigunamunga rikunallami gan, Dioslladimi rijsichiga. ");
INSERT INTO qxl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Diosmunda imalla na rikibujkunadash Pai rurashkada rikushaga yachi chayi pudinmi; kai pachada rurushkamunda pacha Paiga ima uragamash Dios gashkadash tukida ruri pudishkadash larulladimi rikunchi. Shinusha paigunaga <Na yachashkanichu> ningumallash na pudinchu. ");
INSERT INTO qxl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Diosta rijsishka jawash <Alli k'uilla Diosmi gangui, Diosolopai> nishamallash na nigagunachu. Ashtangarin imash na vali yuyashkallabi yuyasha, paigunaj naidi uyush nij shungush yanamanga tukuga. ");
INSERT INTO qxl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","<Alli yachujkunami ganchi> nigushash, ashtan muspagunami tukuga. ");
INSERT INTO qxl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Shinami ima urash na wañuna Diosta, <Alli k'uillami gangui> nina randiga ashtangarin musrhagunada rurushaga wañujlla gentegunama, pishkugunama, chusku chakiyujkunama shinaidi culebrama layagunada <Allimi gangui> ningu ruragaguna. ");
INSERT INTO qxl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Shinusha milli na alli yuyiguna paigunaj shungubi tiyashkagunan katichunllami Diosga sakiga, shinami paigunapuraidi kikinbuj cuerpolladadi pinganaidigunada ruragaguna. ");
INSERT INTO qxl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Diosbuj kabishka parluda na uyush nisha ashtan llagmashkadami crigaguna; Tukida Rurujta kazuna randiga Pai rurushkagunadami allibi churasha <Allimi gangui> nigaguna. Diosllami tuki ratugama <Alli> nishka gana gan. Shina gachun. ");
INSERT INTO qxl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Shinushami paigunaj pinganaidi munashkagunada rurachun Diosga sakiga; paigunapuramunda warmigunashmi k'arin siririnada na munasha warmipuralladi na rurana gashkada rurugaguna. ");
INSERT INTO qxl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Shinaidimi k'arigunash warmin siririnada ña na munushami paiguna manchanaidi rupaguj shina munigunallada rurusha k'arigunapura pinganaida ruranukujkunaga. Millida rurashkamundaga paigunallabidimi llakida japina gashkadaga japigaguna. ");
INSERT INTO qxl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Paigunalladi Dios tiyashkadash na uyanachikimi, na ruranagunada rurachun milli yuyigunan gachun Diosga sakiga. ");
INSERT INTO qxl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Tuki laya na alli ruranagunan, milligunada ruranan, charij ganaida munanan, na rikunachisha p'iña yuyigunan jundami ganguna. Shujkunajta munusha wañurijkuna, wañuchijkuna, p'iñanukunaida munajkuna, jawalla shimin crichijkuna, shujkunamunda na alli yuyijkuna, washalla rimujkuna, ");
INSERT INTO qxl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","p'iñusha shujkunada juchachijkuna, Diosta p'iñajkuna, na kazuj tukushkaidijkuna, alabarijkuna, jatun tukushkaidijkuna, millida rurungu yuyarinukujkuna, taita mamadash na kazush nijkuna, ");
INSERT INTO qxl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","uyiti na uyungu munajkuna, ari nishash na p'aktachijkuna, pimundash k'uyida na sintijkuna, pimundash na llakirijkuna, ");
INSERT INTO qxl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","shina rurujkunaga Dios llakichisha wañuchishka ganaidimi kabin; paigunaga shina Dios mandashkada alli yachushka jawash na rurushamallash katinllagunachu, ashtangarin shujkuna shinaidi rurukish kushillami rikunguna. ");
INSERT INTO qxl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Shinusha, kan pi gashash shujkunada juchachigushtijka <Jucha illujmi gani> ningujka naidij pudinguichu. Ima layami chaishujkuna ruran shinaidimi kambish rurangui. Chimundami shujkunada juchachishaga kanlladi juchachishka gangujmi shinaga rurangui. ");
INSERT INTO qxl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ashtangarin shina rurasha kausujkunadaga Dios kabishkadadi juchachij gashkadami yachanchi. ");
INSERT INTO qxl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","¿Shujkunada juchachigushash kambish paiguna rurushkalladadi ruragushaga <Dios juchachinamundaga mitikushami> yuyanguichu? ");
INSERT INTO qxl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Dios manchanai alli shunguyuj gashkada, shinaidi na ut'kada p'iñarishalla shuyagushkadaga ¿yangabichu churangui? Juchada sakisha Paimu kuchuyachun nisha kangunga alli shungu gashkadaga ¿nachu yachunguiri? ");
INSERT INTO qxl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kangarin ima rurashkamunda na llakirij jinchi shungu gashami, Dios p'iñarishkash shinaidi kabishka juchachinash rikurina p'unllagama kanllamundi Pai p'iñarishkada mirachisha tandachigungui. ");
INSERT INTO qxl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Tukigunamumi imalla rurashkamunda Diosga kuna gashkalladadi kunga. ");
INSERT INTO qxl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Dios <Alli> nishka gangu, allibi churashka gangu shinaidi naidi wañunada mashkusha allida ruragujllagunamunga na tukurij kausidami kunga. ");
INSERT INTO qxl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Shina gakish maijinbish kikinbuj munushkaida rurusha, kabishkada kazuna randi na alli ruranallada kazujkunamunga, Pai colerasha p'iñarishkanmi llakichinga. ");
INSERT INTO qxl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Tuki na allida rurujkunadaga israelgunadadij chi k'ipa na israelgunadashmi manchanaidi llakish mancharinash japinga. ");
INSERT INTO qxl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Shinash ashtangarin allida rurujkunamunga israelgunamundij chi k'ipa na israelgunamushmi Dios <Alli> nishka ganada, allibi churashka ganada shinaidi k'uilla kausidash kunga. ");
INSERT INTO qxl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Diosmunga yalli alli nishkagunamaga pish na tiyanchu. ");
INSERT INTO qxl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Moisés mandushkada na yachusha juchada rurajkunaga chi mandashka illukishmi tukiguna juchachishka chingangaguna; shinaidi mandashkada charishka jawash juchada rurujka chi mandashkallandimi juchachishka ganga. ");
INSERT INTO qxl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mandushkada uyushkallanga Diosbuj ñaubuki <Alli> nishkaga na gai pudinchu, ashtangarin chida kazujkunallami ima juchachinash illujkuna ganga. ");
INSERT INTO qxl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mandashkagunada na charij na israelgunaga munashkamundadi mandashkabi nishka shina rurashaga mandashkagunada na charishash paigunalladimi mandashkagunama laya tukun. ");
INSERT INTO qxl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Paiguna rurushkanga chi mandashkaguna shungubi escribishka tiyashkadami rikuchinguna; shungubi ima yuyashkami chidaga yachi chayachin; chilladimi wakinbiga <Na alli rurangui> nisha juchachinga, shuj kutingunaga <Alli rurangui> nishami ninga;