﻿USE sofia;
DROP TABLE IF EXISTS sofia.qxhNT_vpl;
CREATE TABLE qxhNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qxhNT_vpl WRITE;
INSERT INTO qxhNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristu caran mandaj Davidpa willcan, Abrahampa willcan. Canan Jesúspa auquilluncunata ricsicushun. Cay librućhu jutincuna isquirbiraycan: ");
INSERT INTO qxhNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham churiyäcuran Isaacta. Isaacna churiyäcuran Jacobta. Jacobna churiyäcuran Judáta, waquin wauguincunatapis. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judána churiyäcuran Faréstawan Zérata. Paycunapa maman caran Tamar. Farésna churiyäcuran Esrónta. Esrónna churiyäcuran Aramta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramna churiyäcuran Aminadabta. Aminadabna churiyäcuran Naasónta. Naasónna churiyäcuran Salmónta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónna warmin Rahabćhu churiyäcuran Boozta. Boozna warmin Rutćhu churiyäcuran Obedta. Obedna churiyäcuran Jeséta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jeséna churiyäcuran mandaj Davidta. Mandaj Davidna churiyäcuran Salomónta. Salomónpa maman caran Uríaspa warmin. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónna churiyäcuran Roboamta. Roboamna churiyäcuran Abíasta. Abíasna churiyäcuran Asáta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asána churiyäcuran Josafatta. Josafatna churiyäcuran Joramta. Joramna churiyäcuran Ocíasta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ocíasna churiyäcuran Yotamta. Yotamna churiyäcuran Ajazta. Ajazna churiyäcuran Ezequíasta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasna churiyäcuran Manasésta. Manasésna churiyäcuran Amónta. Amónna churiyäcuran Josíasta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasna churiyäcuran Jeconíasta. Jeconíaspa wauguincunapis caran. Jeconías cawashan wichan Babilonia runacuna Israel runacunata marcanman apacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chay marcaćhu Jeconíaspa wamran Salatiel yuriran. Salatielna churiyäcuran Zorobabelta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelna churiyäcuran Abiudta. Abiudna churiyäcuran Eliacimta. Eliacimna churiyäcuran Azorta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorna churiyäcuran Sadocta. Sadocna churiyäcuran Aquimta. Aquimna churiyäcuran Eliudta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudna churiyäcuran Eleazarta. Eleazarna churiyäcuran Matánta. Matánna churiyäcuran Jacobta. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobna churiyäcuran Joséta. Joséga Maríapa majan caran. Maríapita Jesús yuriran. Jesústa ricsinchi: «Tayta Diosninchi caćhamushan Washäcuj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahampita mandaj Davidcaman ćhunca ćhuscuwan (14) willcacaman runacuna miraran. Mandaj Davidpita Israelcunata Babilonia marcaman apashancaman yapay ćhunca ćhuscuwan (14) willcacaman miraran. Chaypita Tayta Diosninchi caćhamushan Washäcuj yurishancaman yapay ćhunca ćhuscuwan (14) willcacaman miraran. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Canan Jesucristupita tantiyacushun. Maríawan José majachacänanpaj parlanacush caycaran. Ichanga manasi yataptillan Espíritu Santu camacächiptinmi, María jishyaj ricacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mana yataycaptin María jishyaj ricacuptin, José jaguiricuyta munaran. Payga Tayta Diosninchita sumaj manchapacuran. Chaymi runa washanta rimananta mana munar, pacayllapa jaguiricuyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jaguiriyta munaptin, suyñuyllanćhu Tayta Diosninchi caćhamushan anjil niran: «José, mandaj Davidpa willcan canqui. Maríawan majachacayta ama pingacuychu. Payga Espíritu Santu camacächiptin, jishyaj ricacusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wamranpis ullgu yuringa. Marca-masincunata jucha aparicuypita washanga. Chaymi: ‹Jesús› nir jutinta ćhurapanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Llapanpis camacaran Tayta Diosninchipa shimin ćharcucänanpaj. Paypa willacujnin unayna musyachicuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Runa yatäni jipash jishyaj ricacunga. Ullguta jishyacunga. Jutintana ćhurapanga: ‹Emmanuel› nir. ‹Emmanuel› ninanga: ‹Tayta Diosninchi nuwanchiwan iwal juyan› ninan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José puñushanpita ricchapacurir anjilpa shiminta wiyacur, Maríawan majachacaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wamran manaraj yurishancaman Maríata mana yataparanchu. Wamran yuriptin: «Jesús» nir jutichaparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea quinran Belén marcaćhu Jesús yuriran. Judea marcacuna mandaj Herodespa maquinćhu caycaran. Chay wichan inti jigamunanpita Jerusalén marcacaman tantiyaj runacuna ćhayaran. Paycuna ima-imapaj istrïlla cashantapis sumaj tantiyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalén marcaćhüna tapucuran: «Israel runacunapa mandajnin, ¿mayćhütaj yurisha? Marcäpita-pacha musyachicuj istrïllata ricamushcä. Chaymi ricsichimashan mallwata alliman ćhuraj shamushcä» nir ");
INSERT INTO qxhNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","«Israel runacunapa mandajnin, ¿mayćhütaj yurisha?» niptin, mandaj Herodespis, Jerusalén marca runacunapis mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaymi mandaj Herodes mayur cüracunata, Moiséspa shiminta yaćhajcunata jayachiran: «Tayta Diosninchi caćhamushan Washäcuj, ¿mayćhütaj yurinan casha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tapuptin, niran: «Judá quinran Belén marcaćhüshi. Chayćhu yurinanpäshi unay willacuj musyachicur isquirbiran: ");
INSERT INTO qxhNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Judá quinran Belén runacuna, waquin marca runacuna jatun-tucuptinsi, alli ricash canquipaj. Marcayquićhu juc mandaj yuringa. Paypa maquinćhu llapan Israel runa cawanga. Uysha michij ricashan-jina llapanta ricanga› » nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chaura yaćhajcunata pacayllapa jayarcachir, mandaj Herodes tapuran: «¿Imaypitanataj istrïllata ricashcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Imaypita ricarishantapis willaycuptin, Belén marcaman caćharan: «Mallwa ashij mä, ayway. Tarirga, nuwatapis willamanqui mallwata alliman ćhuraj aywanäpaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chaura chaynuy niptin, Belén marcapa aywacuran. Maypa aywananpäpis ricarij istrïlla ñaupaparan. Ichanga mallwa yurishan marca ricänanćhu ićhicuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Istrïlla ićhicuycuptin, yaćhajcuna jatunpa cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wasiman yaycur, Maríata mallwantinta tariran. Mallwanpa ñaupanman jungurpacuycur, alliman ćhuraran. Jipinta pascarir, cuyachicuynin jurita, insinsuta, pirjümita juycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaypita suyñuynillanćhu Tayta Diosninchi willaran mandaj Herodesman mana cutinanpaj. Suyñuyninćhu willaycuptin jucläpa tumarcur, yaćhaj runacuna marcanman cuticäriran. Mandaj Herodesman mana cutirannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Istrïlla tantiyaj runacuna aywacuriptin, suyñuynillanćhu Tayta Diosninchi caćhamushan anjil Joséta niran: «Jatariy. Warmiquitawan mallwata Egipto marcaman jishpichicuy. Willaptïraj, cutimunqui. Mandaj Herodes wamrayquita wañuchinanpaj ashinga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chaynuy niptin, José jataricurcuran. Chay chacaylla warmintawan mallwanta pushacurcur, Egipto marcaman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egipto marcallaćhu mandaj Herodes wañushancaman tiyacuran. Chaynuy ćharcunanpaj unay willacujninwan Tayta Diosninchi musyachicuran: «Egipto marcapita Wawäta jayamushcä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chaura istrïlla tantiyajcuna mana ćhayaptin, mandaj Herodes juyupa ullgucäcuran: «Istrïlla tantiyajcuna llullapämasha» nir. Chaymi willashanta tantiyacurir, Belén marca quinranćhu iti wamracunata murucuncunawan wañuchiran. Ishcay watayujpita uraman llapan ullgu wamrata wañuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chaymi willacuj Jeremíaspa shimin ćharcucaran. Jeremíasga unayna niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ramá marcaćhu tiyaj runacuna ataran. Atashanta llapan wiyaran. Raquelpa wawancunata wañuchishanpita juyupa wagaran. Wawancuna ushyacashanpita wagar amachaptinsi, mana ćhawaranchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mandaj Herodes wañucuptinna Egipto marcaćhu José caycaptillanraj, suyñuynillanćhu Tayta Diosninchi caćhamushan anjil niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«José, jatariy. Warmiquita mallwantinta pushacurcur, Israel marcaman cuticäriy. Wamrata wañuchiyta munajcuna wañucushana.» ");
INSERT INTO qxhNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chaynuy niptin, José jataricurcuran. Warminta mallwantinta pushacurcur, Israel marcaman cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chay wichan Judea quinranta mandaj Herodespa wamran Arquelao mandaycaran. Chaymi Judea quinranman ćhayayta José mana munaranchu. Tayta Diosninchipa anjilninpis suyñuynillanćhu willaran Galilea quinranpana aywacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Willaptin, Nazaret marcaman juyaj aywacuran. Llapanpis camacaran willacujcunapa shimin ćharcucänanpaj. Willacujcuna unayna niran: «Washäcujta ricsingapaj: ‹Nazaret runa› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chaypita unayllata Judea quinran chunyaj pachaćhu Ushyachicuj Juan ricariran. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Llapanta willapar niran: «Juchayquipita wanacäriy. Tayta Diosninchi jananchićhünam. Maquinćhünam purichimäshun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan willacuran willacuj Isaíaspa shimin ćharcucänanpaj. Isaíasga unayna niran: «Chunyajćhümi juc runa jayacuypa willacuycan: ‹Taytanchi shamunanpaj camaricuy. Caminuta pichay. Wicsu caminucunatapis allchay.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpa müdanan camïllupa ajchanpita caran. Sinturunninpis jarachapita caran. Chaynuypis chunyajćhu tarishan chucluscunallatawan munti abïjapa mishquillanta micuj. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén marcapita, Judea marcacunapita, Jordán mayu rajra quinranpita runacuna Juanpa shiminta wiyaj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jucha aparicushanta mana pacaptin, Jordán mayućhu Juan ushyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseu runacunapis, saduceu runacunapis ushyacuyta munar ćhayaran. Chaypis Juan niran: «Supaypa wawancuna, ushyacurpis juchallaćhu aruptiquiga, Tayta Diosninchi ñacachishunquipämi. Mana jishpinquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wanacushayqui musyacänanpaj Tayta Diosninchita manchapacur allillata rurar caway. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama chapacunquichu: ‹Abrahampa willcan caycanchi. Paypita Tayta Diosninchi alli ricaycämanchi› nir. Abrahampa willcan cananpäga Tayta Diosninchi rumitapis ticrarachinman wiyacuj cananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ushyacurpis juchapita mana wanacuptiqui, Tayta Diosninchipis jargurishunquipaj. Yüratapis mana sumaj wayuptin, jächawan muturij-muturijllana shuyaranchi. Muturir, ninaman jaycurinchi. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Juchapita wanacushayqui musyacänanpaj yacullawan ushyachiycaj. Jucmi ichanga Espíritu Santuwanpis, ninawanpis ushyachishunquipaj. Payga munayniyujmi. Chaymi llanguinta apäshiyllatapis manchapacü. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Juchapita wanacujcunata alli ñawinwan Tayta Diosninchi ricanga. Juchaćhu arujcunatam ichanga mana upij ninaman jaycuringa. Sumaj tantiyacärinquiman. Rïguta wapyarpis, punshanta ruparachin. Muruntam ichanga wasinman shuntan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chay wichan Jesús aywaran Galilea quinranpita Jordán mayuman Ushyachicuj Juan ushyachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ushyachiyta mana munar, Juan niran: «Tayta Jesús, mana ushyachijmanchu. Manchäga ushyachimanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesúsna niran: «Ushyachimay. Chayraj Tayta Diosninchipa shungun munashanta ćharcushun.» Chaymi Jesústa Juan ushyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ushyacuriycur yacupita Jesús llucshiriptin, janaj pachapa puncun quićhacäcamuran. Espíritu Santuna paluma-jina Jesúsman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Janaj pachapitana nimuran: «Jesúsga cuyay Wawämi. Shungüman tincun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaypita chunyaj pachaman Espíritu Santu Jesústa aparan Supay maquichacuyta camananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesúsga ćhuscu ćhunca (40) pagas, ćhuscu ćhunca (40) junaj micuyta mana mallir, yargaranna. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaypita juchacachicuj Supay ćhayarcur, niran: «Tayta Diosninchipa Wawan car, cay rumita tantaman mä, ticrarachiy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesúsna niran: «Tayta Diosninchipa shimin nin: ‹Runa mana tantallawanchu cawan. Manchäga Tayta Diosninchipa shiminta wiyacurpis cawan.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaypita Jerusalén marcamanna Jesústa Supay aparan. Tayta Diosninchipa wasinpa siswanman ićhichiran. Jinarcur niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«Tayta Diosninchipa Wawan car, pachaman mä, jigacurpuy. Tayta Diosninchipa shimin nin: ‹Anjilnincunata Tayta Diosninchi caćhamunga washäshunayquipaj. Ćhaquiqui rumiman mana tacacunanpäpis maquinwan charishunquipaj.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesúsna niran: «Tayta Diosninchipa shimin nin: ‹Tayta Diosninchita maquichacuyta ama camanquimanchu.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaypita jatunnin puntamanna Jesústa Supay aparan. Jatun marcacunata ima-aycancunatawanpis ricachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jinarcur niran: «Ñaupäman jungurpaycur alliman ćhuramaptiqui, llapan marcäcunata juycushayqui. Maquiquićhu purichinquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesúsna niran: «Washata ayway, Supay. Tayta Diosninchipa shimin nin: ‹Tayta Diosnillanchita manchapacunquiman. Paypa maquillanćhu cawanquiman.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jarguriptin, supay aywacuran. Anjilcunana Jesúsman ćhayarcur, pishishanta tarichiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ushyachicuj Juanta carsilćhu wićhgachishanta mayar, Galilea quinranmanna Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ichanga Nazaret wasinman mana ćhayaranchu. Manchäga Cafarnaún marcaman tiyaj aywacuran. Cafarnaún marca Galilea püsu cantunćhu caran. Chay quinranćhu Zabulónpa yawar-masincuna, Neftalípa yawar-masincuna tiyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Cafarnaún marcaćhüna Jesús tiyaran willacuj Isaíaspa shimin ćharcucänanpaj. Isaíasga unayna niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Galilea runacuna, sumaj wiyacunquiman. Wiyacunquiman Zabulónpa yawar-masin carpis, Neftalípa yawar-masin carpis, Jordán mayu wajtanćhu tiyarpis, Galilea quinran jäpa runacunapa marcanćhu tiyarpis. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Shunguyqui yanayash caycan juchaćhu cawashayquipita. Chaypis Washäcuj ćhayamuptin, shunguyqui achicyacäcunga. Juchata aparicushayquipita wañuy janayquićhu caycasha. Chaypis achquipäshunayquipaj Washäcuj ćhayamushana.» ");
INSERT INTO qxhNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Isaíaspa shiminta ćharcur Tayta Diosninchipa shiminta willapäcur, Jesús niran: «Juchayquipita wanacäriy. Tayta Diosninchi shuyaraycämanchina. Maquinćhüna purichimäshun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Galilea püsu cantunpa aywaycashanćhu Jesús ricaran «Pedro» nishan Simónta, wauguin Andrésta-ima. Piscädu charij car, ridinta yacuman jitarcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesúsna niran: «Purïshimay. Piscäduta charishayqui-jina runacunata shuntanquipaj Tayta Diosninchipa maquinćhu cawananpaj. Chaytaga quiquïmi camacächishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chaura ridinta jaguiriycur, Jesúswan aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Washlänijta aywaycashanćhu Santiagutawan Juanta bütillaćhu ridinta allcharcaycajta tariran. Paycunapa taytan caran Zebedeo. Ridinta allchaycajta Jesús jayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jayaptin papänin Zebedeuta bütićhu jaguiycur, Jesúswan aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilea quinranćhu marcan-marcan Jesús puriran. Shuntacäna wasicunaćhüpis Tayta Diosninchipa alli willacuyninta willapäcuran. Jishyaćhucunatapis allchacächiran. Nanapäcujcunatapis allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesús ima-imata rurashanta llapan Siria runacunapis mayaran. Chaymi apamuran nanächicujcunata, jishyaćhücunata, supay pucllacushan runacunata, wañupayyujcunata, cumllucashcunata. Ima jishyawan jishyaptinsi, llapallanta Jesús allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymi chay-tucuypita ćhayar, achcaj runa Jesústa jatirpararan. Jatirpararan: Galilea runacunapis, Decápolis runacunapis, Jerusalén runacunapis, Judea runacunapis, Jordán mayu chimpanćhu tiyaj runacunapis. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chay-chicaj runata ricar pataman jigarcur, Jesús jamacuycuran. Purïshijnincuna jutupaycuptin, ");
INSERT INTO qxhNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tantiyachicur Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Pishipacujcuna, cushicärinquiman. Llapan shunguyquiwan yupachicuptiqui, Tayta Diosninchi yanapaycäshunqui. Maquinćhümi cawaycächishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ñacajcuna, cushicärinquiman. Llaquicur wagaptiquisi, Tayta Diosninchi yanapaycäshunqui. Shacyaycächishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ćhacraynaj, wasiynaj runacuna, cushicärinquiman. Pampa runa captiquisi, Tayta Diosninchi yanapaycäshunqui. Maquiquimanmi cay pachatapis ćhuranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wañuy-caway Tayta Diosninchipa shungun munashannuy cawayta ashijcuna, cushicärinquiman. Tayta Diosninchi yanapaycäshunqui. Shunguyqui munashantapis tarichishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Llaquipäcujcuna, cushicärinquiman. Tayta Diosninchi yanapaycäshunqui. Sumaj llaquipaycäshunquim. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Shungunćhu juchata mana pacajcuna, cushicärinquiman. Tayta Diosninchi yanapaycäshunqui. Quiquinwanmi tincunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pï-maytapis amachajcuna, cushicärinquiman. Tayta Diosninchi yanapaycäshunqui. Payga wamrachacushunquim. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tayta Diosninchipa shungun munashanta rurajcuna, cushicärinquiman. Runacuna ñacachishuptiquisi, Tayta Diosninchi yanapaycäshunqui. Maquinćhümi puriycächishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Wiyacamashayqui-janan ashllishuptiquisi, chiquir ushyashuptiquisi, imapita tumpashuptiquisi, cushicärinquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ñacachishushayqui-jina chiqui runacuna Tayta Diosninchipa unay-unay willacujnincunatapis ñacachir ushyaran. Janaj pachaćhümi ichanga Tayta Diosninchi alli cawayta shuyaraycächishunqui. Chaymi sumaj cushicärinquiman. Shunguyquicunapis achicyacärinman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Jamcuna caćhi-jina carcaycanqui. Caćhipa puchguynin illariptin, ¿yapay puchguyninman cutichinquimanchuraj? Mana. Puchguynin illariptin, wicaparin. Runacuna lluchcar ushyan. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Tayta Diosninchipa shiminta wiyacushayquipita achquita alli ricashan-jina jamcunatapis llapan runa alli ricashunquiman. Juc pataćhu marca captinshi, llapan runa rican. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Achquita ratarcachir, pipis manash manca rurinman ćhuranmanchu. Manchäga wasićhu llapanta achicyänanpaj patacmanshi ćhuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Achqui allipaj cashan-jina jamcunapis alli shungu canquiman. Alli shungu cashayquita ricar, janaj pachaćhu tiyaj Tayta Diosninchitapis llapan runa alliman ćhuranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Sumaj tantiyacunquiman. Mana Moiséspa shiminta, unay willacujcunapa shiminta ushyacächijchu shamushcä; manchäga llapanta alliman camacächijmi. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cay pachawan janaj pacha mana ushyacaptillan, Moiséspa shimin ćharcucanga Tayta Diosninchipa shimin cashpan. Mana ichicllapis jungacangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chaymi pipis Tayta Diosninchipa shiminta llapanta ćharcurpis juc-ishcayllatasi pantaptin, Tayta Diosninchipis mana ricaj-tucungachu. Juc-ishcayllata mana wiyacunanpaj shimiyajcunatapis Tayta Diosninchi mana ricaj-tucungachu. Shiminta wiyacujcunatawan sumaj yaćhachicujcunatam ichanga alli ricar, maquinćhu cawachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Fariseucunapis, Moiséspa shiminta yaćhajcunapis janan-janallan Tayta Diosninchipa shiminta wiyacun. Tayta Diosninchipa ñaupanman ćhayanayquipämi ichanga llapan shunguyquiwanraj wiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Mä, wiyamay. Unay auquillunchicunata Moisés niran: ‹Ama wañuchicunquichu. Wañuchicujpa juchan jurgapash canga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Canan nuwana willashayqui. Shungullanćhu warmijcunapa, ullgujcunapa juchantapis Tayta Diosninchi jurgapanga. Runa-masinta ashllicujcunata mayur Israel runacunapa ñaupanman ćhayachinga. Pipis runa-masinta ashllir: ‹Upa. Tacra› nir pampaman ćhuraptin, chacaj pachaman ćhayanga. Ninaćhu Tayta Diosninchi ñacachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Chaymi: ‹Tayta Diosninchita cuyachicuynïta jarashaj› nir runa-masiquiwan jagayächinacush caycar, ama ćhuranquirächu. Manchä juclla ushyacächinquiman. Jinarcurraj cuyachicuyniquita Tayta Diosninchita jaranquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Pipis dimandashuptiqui jatunman mana ćhayallar, juclla ushyacächinquiman. Manchäga juiswan charichishunquipaj. Juisga murucucunawan carsilman apachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Carsilpita llap-llapanta pägarraj llucshimunquipaj. Chayta sumaj tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Moiséspa shiminta musyanqui. Shiminćhu nin: ‹Majayquita ama jananpachinquichu.› ");
INSERT INTO qxhNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Canan nuwana willashayqui. Pipis juc warmiwan cacuyta yarpar, mayna shungullanćhu juchata aparicusha. Majanta jananpachishana. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chaymi ñawiqui juchata aparicachishuptiqui ujtirir wicapariptiqui, alli canman. Ñawiyuj caycar chacaj pachaman aywanayquipita ñawiquita wicapariptiqui, alli canman. Manchäga chacaj pachaćhu ñacanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Maquiquipis juchata aparicachishuptiqui muturir wicapariptiqui, alli canman. Maquiyuj caycar ñacayman aywanayquipita maquiquita muturir wicapariptiqui, alli canman. Manchäga chacaj pachaćhu ñacanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Moiséspa shiminta yaćhacushcanqui. Shiminćhu nin: ‹Pipis warminta jaguirir, actaman jamachinman.› ");
INSERT INTO qxhNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Canan nuwana willashayqui. Juc runa majanta jaguiriycur jucwan jananpachiptillanraj, jaguirinman. Manchäga mana camacanchu. Jaguirirga, jucha aparicuyman warminta ćhayachin. Juc runatana ćhasquir, juchaman ćhayan. Runan jaguirish warmiwan majachacaj runapis juchata aparicun. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Unay auquillunchicunata Moisés niran: ‹Ama llullacunquichu. Manchäga shimiquita ćharcunquiman. Tayta Diosninchipa ñaupanćhu aunishcanqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Canan nuwana willashayqui. Imatapis aunir, janaj pachaman ama ricarinquichu. Janaj pachaga Tayta Diosninchipa wasin. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ćhacrayquitapis ama auninquichu. Ćhacracunapis Tayta Diosninchipa maquinćhümi. Jerusalén marcamanpis ama ricarinquichu. Jerusalén marcapis munayniyuj Tayta Diosninchipa maquinćhümi. Paypa marcanmi. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‹Mana ćharcuptï, wañurachimanqui› ama ninquichu. Cawayniquipis Tayta Diosninchipa maquinćhümi. Ajchayqui yana cananpäpis, yuraj cananpäpis quiquin camasha. Jucnayllatasi rucayta mana junquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Rimacuyniquiga juc shimilla cachun. Aunir, ama cutiricunquichu. ‹Mana› aunirpis, ama auninquinachu. Ishcay-quimsata rimar, supay yarpashanta rimaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Moiséspa shiminta musyanqui. Shiminćhu nin: ‹Maganacur, iwal cutichinacunqui. Ñawiyquićhu ćhayachishuptiqui, ñawillanćhu cutichinqui. Quiruyquićhu ćhayachishuptiqui, quirullanćhu cutichinqui.› Canan nuwana willashayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pipis magashuptiqui, ayninta ama cutichinquichu. Juc-caj jajllayquićhu lajyashuptiqui, juc-cajlätana camapunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Camsayquita jićhushunayqui-cashan dimandashuptiqui, punchuyquitapis jaguipaycunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Juc murucu juc lïwacaman jipinta apachishuptiqui, ishcay lïwacaman apaparcunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mañacushuptiqui, tarichinquiman. ‹Challimay› nishuptiqui, ama upa-tucunquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Moiséspa shiminta musyanqui. Shiminćhu nin: ‹Yaćhänacushayquita alli ricanqui. Juyucunatam ichanga chiquinqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Canan nuwana willashayqui. Pipis chiquishuptiqui, llaquipanquiman. Juyu ñawinpa ricashuptiquisi, alli ñawiquipa ricanqui. Paycunapaj Tayta Diosninchita mañacunqui alli cawayta tarichinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chayrämi Tayta Diosninchipa wawan cashayqui musyacanga. Payga alli runacunapäpis, juyu runacunapäpis intita achicyächimun. Chaynuypis shiminta wiyacujcunapäpis, mana wiyacujcunapäpis tamyachimun. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","«Yaćhänacushallayquiwan llaquipänacur, ¿rasunpachuraj llaquipayta yaćhanqui? Mana. Aynillanta cutiycächinqui. Chiqui runacunapis yaćhänacushallanwan alli ricanacun. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ricsinacushallayquiwan wamayänacur, ¿allitachuraj ruraycanqui? Mana. Aynillanta cutiycächinqui. Tayta Diosninchita mana manchapacujcunapis ricsinacushallanwan wamayänacun. ");
INSERT INTO qxhNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chaymi Tayta Diosninchi llaquipäcuj cashan-jina, allillata ruraj cashan-jina, jamcunapis llapan runa-masiquita llaquipanquiman. Alli ricanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Runa ricanallanpaj ama alli-tucuychu. Runa ricanallanpaj ruraptiqui, janaj pachaćhu tiyaj Tayta Diosninchi mana imatapis tarichishunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chaymi pishipacujta jarar, willacuräcur ama purinquichu. Janan shungu runacunalla cällicunaćhüpis, shuntacäna wasicunaćhüpis willacuräcur purin. Chay-niraj cashanpita runa-masin alli ricaptin, ashishanta mayna tarisha. Chaymi Tayta Diosninchi imatapis mana tarichinganachu. Chayta sumaj tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chaura wacchata jarar, pitapis ama musyachinquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Llaquipäcuj cashayquita mana willacuptiquiraj Tayta Diosninchi shunguyquita musyapar, imatapis tarichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Tayta Diosninchita mañacur, janan shungu runacuna-jina ama ruranquichu. Paycunaga runa ricanallanpaj shuntacäna wasicunaćhüpis, cällicunaćhüpis ićhicaycärir Tayta Diosninchita mañacun. Chay-niraj cashanpita runa-masin alli ricaptin, ashishanta mayna tarisha. Chaymi Tayta Diosninchi imatapis mana tarichinganachu. Chayta sumaj tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tayta Diosninchita mañacushayquita shungullayqui musyaranman. Wasi puncuyquita wićhgacurcur, mañacunqui. Pacayllapa mañacushayquita ricar, Tayta Diosninchi imatapis tarichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Juc rimashallayquita cutiparir-cutiparir Tayta Diosninchita ama mañacunquichu. Jäpa runacuna Tayta Diosninchi pï cashantapis mana musyar, yarpan: ‹Cutiparir-cutiparir mañacuptïräshi, Tayta Diosninchi wiyamanga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Chay-niraj runacuna yarpashanta ama jatinquichu. Ima-imata mañacunanchipaj cashantapis mayna Tayta Diosninchi musyaycan. Shiminchi mana pashtapacuptillanraj, musyaycanna. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chaymi Tayta Diosninchita mañacur ninqui: ‹Papäninchi, Janaj pachaćhu tiyajmi canqui. Llapanpis manchapacuyculläshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Maquiquićhu cawaycachillämay. Janaj pachaćhu wiyacushushayqui-jina cay pachaćhüpis llapanmi wiyayculläshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Waran-waran cawanäpäpis tariycachillämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Juchäcunatapis ama yarparaynachu. Manchäga chiquimajcunata alli ricashä-jina alli ricaycallämay. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Juchaman ćhayanätapis ama camacaycachillaychu. Manchäga Supaypa maquinpita washaycallämay.› ");
INSERT INTO qxhNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Runa-masiquiwan imatapis alli shimillayquipa ushyacächiptiqui, Tayta Diosninchipis llapan juchayquita junganga. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Quiquiqui-pura mana ushyacächiptiquim ichanga, Tayta Diosninchipis juchayquita mana jungangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ayünar, llaquish-niraj ama canquichu. Janan shungu runacuna-jina ama canquichu. Paycunaga ayünashanta runacuna musyananpaj llaquish-tucur purin. Chay-niraj cashanpita runa-masin alli ricaycaptin, ashishanta mayna tarisha. Chaymi Tayta Diosninchipita mana imatapis ćhasquinganachu. Chayta sumaj tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jamcunam ichanga ayünar, umayquita pajpacurir ñajchacunqui. Jajllayquitapis mayllacunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chaura ayünashayquita pipis mana tantiyangachu. Tayta Diosninchim ichanga pacayllapa mañacushayquita ricar, imatapis tarichishunquipaj. Payga llapan runapa shungunta musyapan. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Cay pachallaćhu rïcuyaytapis, ima-aycatapis ama ashinquichu. Cayćhüga imanchicuna mupallin. Puyun. Suwapis apacun. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Chaymi cay pachaćhu imatapis ama ćhuracunquichu. Manchäga janaj pachaman ćhuracunqui. Runa-masiquita llaquipar yanapashayquita Tayta Diosninchi ricanga. Ricaptinga, mana mupallinchu. Mana puyunchu. Suwapis mana apanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sumaj tantiyacunquiman. Runaga shungun imata munashallanta yarparäcun. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Achquiga shimïwan tincun. Ñawinchiwan llapantapis ricanchi. Ñawinchi achquita ricaptin, shungunchipis achicyacäcun. Shunguyquiman shimï ćhayaptin, Tayta Diosninchipa shungun munashanta tantiyacunquipaj. Shunguyquiman mana ćhayaptinmi ichanga, jucha aruyllaćhu cawanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ñawinchi chacash captin, rama-ramalla ricashanchi-jina juyu shungu cashanchipis ricacan Tayta Diosninchipa shungun munashanta mana ruraptinchi. Ñawinchi japra captin, allita, mana allitapis mana tantiyacushunpächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Juc runa ishcaj patrunpa maquinćhu mana cawanmanchu. Ishcanwan shungun mana tincunmanchu. Ishcajpa maquinćhu cawar, juc-cajpita carupayllapa purir, juc-cajllamanna jillicurcunga. Juc-cajta pampaman ćhurar, juc-cajllatana alli ñawinwan ricanga. Jamcunapis jillayllaman yarparar, Tayta Diosninchita jungaycärinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Canan sumaj willapäshayqui. Ama llaquicunquichu: ‹¿Imawanraj cawashaj? ¿Imataraj micushaj? ¿Imataraj ushtucushaj?› nir. Cawaycar paćhayquipaj pishiptinpis, janayquipaj pishiptinpis, ama llaquicunquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pichuysacunata mä, ricacushun. Paycuna mana murupacunchu. Mana pallapacunchu. Murutapis mana ćhuracunchu. Imatapis mana ruracuycaptinsi, Tayta Diosninchi micunanta camapan. Pichuysacunata camapaycarga, ¿pishïchishunquimanchuraj? Mana. Tarichishunquipämi. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","«May-jina llaquicurpis wañuy ćhayamuptin, mana jishpinquipächu: ‹Cawapärishäraj› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Müdanayquipaj ama yarpaćhacunquichu. Waytacunata mä, ricacushun. Waytacunaga mana arucuycarsi, mana puchcacuycarsi cuyayllapaj waytan. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wayta cuyayllapaj cashanman unay mandaj Salomónpis mana tincuranchu achic-achicyaycaj müdanash caycarsi. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Waytacuna juc-ishcay junajllapämi. Juc junaj cuyayllapaj waytan. Waranninna capllupäna chaquicäcun. Nircur tullpallaćhu ushyacäcun. Chaypis Tayta Diosninchi cuyayllapaj waytachin. Chaynuy caycaptin, ¿jamcunata Tayta Diosninchi pishïchishunquimanchuraj? Mana. Chaymi sumaj yupachicärinquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ama llaquicunquichu: ‹¿Imataraj micushaj? ¿Imataraj upushaj? ¿Imataraj ushtucushaj?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tayta Diosninchiman mana yupachicujcunallam chaycunapaj llaquicun. Jamcunam ichanga Tayta Diosninchiman yupachicunqui. Payga imalla pishïshushayquitapis mayna musyaycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chaymi maquillanćhu cawanquiman. Shungun munashallanta rurar cawanquiman. Maquinćhu purichishushpayqui pishijcunatapis tarichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chaymi: ‹Wara-warantin, ¿imanuyraj cawashaj?› nir ama llaquicunquichu. Wara-warantinpis cawashayquinuylla cawanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Runa-masiquita pampaman mana ćhuraptiqui, Tayta Diosninchipis pampaman mana ćhurashunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Runa-masiquita pampaman ćhurashayquiman-tupu Tayta Diosninchipis pampaman ćhurashunquipaj. Runa-masiquita juyu ñawiquiwan ricashayquiman-tupu Tayta Diosninchipis juyu ñawinwan ricashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mä, tincuchiypa tantiyacushun. Quiquiquipa ñawiquićhu cullu jatiraycaptin, ¿jucpa ñawinpita pujrita jurgapunquimanchuraj? Mana. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Quiquiquipa ñawiquićhu cullu caycaptin, ¿imanuyparaj runa-masiquita ninquiman: ‹Ñawiquipita pujrita jurgapushayqui›? ");
INSERT INTO qxhNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Chaynuy nir, juchaynaj-tucurcaycanqui. Ñawiquipitaraj culluta jurgunquiman runa-masiquipa ñawinpita pujrita jurgapunayquipaj. Chay-jina juchaćhu cawaycarga, jucpa juchanta ama jurgapanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Tayta Diosninchipa shiminta mana wiyacujcunata ama willapanquimanchu. Quishatapis allguta mana jaranchichu. Jaraptinchi, caniramäshuwan. Achic-achicyaycaj rumipita piñitapis cuchicunata mana wallgapanchichu. Wallgapaptinchi, achicyaycaj rumi piñitapis lluchcar ushyarinman. Chay-jina mana wiyacujcunapis Tayta Diosninchipa shiminta pampaman ćhuranga. Allita willapaptiqui, ticrapushunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Mañacuptiqui, Tayta Diosninchi jushunquipaj. Ashiptiqui, tarichishunquipaj. Jayacuptiqui, puncuta quićhapushunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mañacujcunaga ćhasquinmi. Ashijcunaga tarinmi. Jayacujcunataga puncuta quićhapunmi. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mä, tapushayqui. Wawayquicuna tantata mañacushuptiqui, ¿rumitachuraj aptaparcunquiman? ");
INSERT INTO qxhNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Piscäduta mañacushuptiqui, ¿wañuchicuj curutachuraj aptaparcunquiman? ");
INSERT INTO qxhNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jamcuna jucha-sapa carcaycarsi, wamrayquicunata allita jaranqui. Tayta Diosninchipis llaquipäcujmi. Mañacuptiquiga, quiquinmi janaj pachaćhu caycashpan alli-allillata tarichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Alli ricashunayquita munashayqui-jina runa-masiquitapis alli ricanquiman. Alli ricanacunanchipämi Moiséspa shiminpis, unay willacujcunapa shiminpis willapämanchi. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","«Quićhqui puncupa yaycuy sasa cashan-jina Tayta Diosninchipa maquinćhu puriyga sasa. Paypa shungun munashannuy cawar, ñacanquipaj. Chaymi wallcajlla quićhqui puncupa yaycun. Paycunalla imaycamanpis Tayta Diosninchipa maquinćhu cawanga. Jatun puncupa yaycuyga mana sasachu. Ichanga ushyacayman ćhayan. Chaypis achcaj runa jatun puncupa yaycushan-jina quiquinpa shungun munashallanta rurar cawan. Chaymi ushyacayman mana ćhayanayquipaj quićhqui puncupa yaycuy. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Pipis pantachishurunquiman: ‹Tayta Diosninchipa shiminta willapäcuycä› nir. Paycunaga micucuj liyun-jina caycarsi, shuti uysha-jina ćhayapushunquipaj: ‹Tayta Diosninchipa shungun munashallanta rurashun› nillar. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ichanga ruracuyninpa, cawacuyninpa ricsican. ¿Mishqui übasta wangurpitachuraj pallanchi? ¿Durashnutapis wirca-cashapitachuraj pallanchi? ");
INSERT INTO qxhNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Rüta yüra mishquijta wayun. Casha jaćhapis asgajta wayun. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Rüta yüra asgajta mana wayunmanchu. Casha jaćhapis mishquijta mana wayunmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Cashayuj jaćhata cuchurin. Ninaman jaycurin. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Casha jaćhacunata wayuyninpa ricsishayqui-jina pantachicujcunatapis ruracuyninpa, cawacuyninpa ricsinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","« ‹Taytallau Tayta› nimaj runacuna mana llapanchu Tayta Diosninchipa ñaupanman ćhayanga imaycamanpis maquinćhu cawananpaj. Papänïpa maquinćhu shungun munashanta rurajcunalla cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cay pacha ushyacaptin, llapan runapa juchanta jurgapashä junaj achcajmi nimanga: ‹Taytallau Tayta, nimashayquinuylla shimiquita willapäcushcä. Yaćhachimashayquinuylla supaycunata jargur, pucllacushancunata allchacächishcä. Camacächishayquinuylla runa mana rurashancunata rurashcä.› ");
INSERT INTO qxhNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nuwam ichanga nishaj: ‹Juchaćhu arujcuna, ¿piraj cacullanquipis? Ricaytapis mana munallajchu. Washata ayway.› ");
INSERT INTO qxhNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Shimïta wiyacujcunata alli wasita rurajwan tincuchï. Wasita alli rurar, rumiwan simintuta jallarachin. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Rumi jananćhu wasi tapyarar, mana jućhunchu. Chigaypa tamyar llujlla ćhayaptinsi, mayu ćhayaptinsi, chicchinpa pücaptinsi, wasi mana jućhunchu. Llapantapis ićhipun rumiwan simintuta jallarish captin. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Shimïta mana wiyacujcunatam ichanga upa rinri runawan tincuchï. Upa runaga ñushya allpallaman wasinta jatarachin. ");
INSERT INTO qxhNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chaymi tamyar llujlla ćhayaptin, mayu ćhayaptin, chicchinpa pücaptin, wasin jućhucäcun. Llapallan ushyacäcun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Rimayta ushyarcuptin, llapan runa cushicuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","«Moiséspa shiminta yaćhajcuna willapäcushanta mana tantiyanchichu. Jesús willapäcushanmi ichanga shungunchiman sumaj ćhayan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sumaj willapäcurir puntapita yarpuptin, achcaj runa Jesúspa jipanpa aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jaraćhu jishyaj runapis Jesústa taripar ñaupanman jungurpacuycur, niran: «Llaquipämashpayqui allchacaycachillämay. Tayta Diosninchipa ricay ñawinćhüpis alli cayta munä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesúsna llaquipashpan maquinwan yataycur, niran: «Llaquipajmi. Allchacayna.» Niptin, jaraćhu jishya illaricäcuran. Allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jinarcur Jesús niran: «Ama pitapis willapanquichu. Manchäga cüraman ayway. Moiséspa shiminta ćharcur cuyachicuyniquitapis Tayta Diosninchita jaray. Chayraj llapanpa ricay ñawinćhu alli canquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cafarnaún marcaman Jesús ćhayaycaptin, Roma murucucunapa capitannin ćhayapuran. Ćhayarcur mañacuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Tayta, uywaynï jishyaycan. Ćhaquinta, maquinta mana cuyuchinchu. Juyupa nanächicun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesúsna niran: «Wasiquiman aywashun. Allchacächishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitanmi ichanga niran: «Wasïman ćhayanayqui mana camacanchu. Roma runa captï, Israel-masiquicuna ricamaytapis mana munanchu. Chaypis aunimaptiqui, uywaynï allchacäcunga. Mana aywanayquirächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nuwapis jucpa maquinćhu juyä. Quiquïpis maquïćhu murucucunata purichï. Chaymi: ‹Shamuy› niptï, shamun. ‹Ayway› niptï, aywan. Wasïćhüpis llapan mincaynï shimïta wiyacun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitanpa shiminta wiyar, Jesús jatunpa cushicuran. Jatirpaj runacunata niran: «Jäpa runa caycarsi, llapan shungunwan cay runa manchapacaman; Israel-masinchicunam ichanga janan shungulla. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sumaj tantiyacunquiman. Tayta Diosninchipa maquinćhu cawajcuna chay-tucuy marcapita jutucangapaj. Auquillunchi Abrahamwan, Isaacwan, Jacobwan, llapanmi Tayta Diosninchipa ñaupallanćhu micupacungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel-masinchicunam ichanga: ‹Tayta Diosninchipa wawanmi cä› nirpis, mana jutucangachu. Paycunata chacaj pachaman Tayta Diosninchi jargungapaj. Chayćhüraj llaquicunga. Atar waganga. Juyupa ñacar quiruntapis ućhunga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jinarcur capitanta Jesús niran: «Wasiquimanna cuticuy. Yupachicamashayquiman-tupu camacanga.» Nishan ürash capitanpa uywaynin allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chaypita Pedrupa wasinman Jesús aywaran. Pedrupa suydan wayllaywan jishyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Maquinpita Jesús yataycuptinmi ichanga, wayllay caćhariycuran. Chaura jatarcur, yanucuriycuran jarananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chacanaycaptinna, Jesúsman jishyaćhucunata apamuran: «Diyawarda ushyashanam» nir. Supay pucllacushan jishyaćhucunatapis ćhayachiran. Jesúsmi ichanga juc shimi rimarillar, supaycunata jarguriran. Jishyaćhucunatapis llapallanta allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chaynuymi unay willacuj Isaíaspa shimin ćharcucaran. Isaíasga unayna niran: «Quiquinmi jishyanchicunata jurgusha. Nanayninchicunatapis apasha.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Juc cuti achcaj runata ricar, purïshijnincunata Jesús niran: «Yacu püsuta chimpashun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chaynuy niptin, Moiséspa shiminta yaćhaj runa niran: «Tayta, aywashayquipa aywayta munä. Maypapis purimushun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesúsna niran: «Atujcunapis maćhayninćhu tiyan. Pichuysacunapis jishuyuj. Nuwapam ichanga Tayta Diosninchipa caćhan captïsi, mayman ćhayanäpäpis wasï mana canchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chaypita juc purïshijninna Jesústa niran: «Tayta, papänïtaraj ricashaj. Wañucuptin pampaycurraj, purïshishayqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesúsna niran: «Papäniqui chapata ama rurashunquimanchu. Juclla purïshimay. Wañushta wañush-masincuna pampachun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chaypita purïshijnincunawan-ima Jesús bütiman jigaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bütiwan aywaycashanćhu Jesús puñucäcuran. Puñucäcushancaman shucucuy wayra ricacamuran. Yacu büchiypa-büchir, bütiman yaycuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Purïshijnincunana Jesústa ricchachiran: «Washämay. Washämay, Tayta. Challpucaycanchina» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesúsna niran: «¿Imanirtaj mancharinqui? ¿Janan shungullachu Tayta Diosninchiman yupachicunqui?» Jatarcurna, yacutawan wayrata Jesús piñacuran. Piñacuptin, shucucuy wayra ćhawacäcuran. Yacupis puñucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chaura purïshijnincuna mancharicäcur, quiquin-pura ninacäriran: «¿Piraj cay runa? Piñacuriptin, shucucuy wayra ćhawacäcun. Yacupis puñucäcun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Püsuta chimpar, Gadara quinranman Jesús ćhayaran. Ćhayaptin, pantyunpita ishcaj runa llucshiramuran. Supaypa maquinćhu purir, juyu caran. Chaymi chay quinranpa pipis mana puricujnachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Supay pucllacushan runacunana supay rimachiptin, jayacuran: «Tayta Diosninchipa Wawan Jesús, ¿imanirtaj ashipämanqui? ¿Imanirtaj juclla ñacayman jitarpamayta munaycanqui? Amaraj ñacachimaychu, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chay junaj washlänin quinranćhu chay-chica cuchi pagupacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chaymi supaycuna Jesústa mañacuran: «Cay runapita jargumashpayqui cuchicunata pucllacunäpaj aunimay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mañacushanta Jesús auniran: «Ayway» nir. Auniptinga runata caćhariycur, cuchicunatana pucllacuran. Cuchicunana jishyayar, chagapita yacuman jigapurcuran. Llapallan shugupacaypa wañuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cuchi michijcunana mancharish jishpicäriran. Marcanman ćhayar, imallata ricashantapis willacuran. Ishcaj jishyayash runa allchacashantapis willacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Willaptin, llapan runa Jesúsman aywaran. Ćhayar, mañacuran: «Cay marcapita aywacuy, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaypita bütiman jigarcur, marcanman Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ćhayaptin, runacuna quirmallawan cumllucash runata Jesúsman ćhayachiran. Paycuna llapan shungunwan yupachicushanta musyar, cumllucash runata Jesús niran: «Wawallau wawa, ama llaquicuychu. Juchayquicunata jungashcäna.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chaura Moiséspa shiminta yaćhajcuna shungullanćhu ullgucäcuran: «Caynuy rimar, Tayta Diosninchita apäriycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yarpashanta musyar, Jesús tapuran: «¿Imanirtaj llutanta yarparcaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mä, tapushayqui. ¿Allchacächiychu, jucha aparicushanta jungacächiychu sasa? ");
INSERT INTO qxhNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sumaj tantiyacunquiman. Tayta Diosninchi cay pachaman caćhamasha. Munayniyujmi cä pipa juchantapis jungacächinäpaj.» Chaymi cumllucash runata niran: «Jatariy. Quirmayquita shuntacurcur, wasiquiman cuticuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chaynuy niptin, cumllucash runa änir, jatarcur wasinman cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Runacunana jatunpa mancharicäcuran. Tayta Diosninchitapis alliman ćhuraran: «Ima allish Tayta Diosninchi runacunatapis yanapan munayniyuj cananpaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaypita aywaycurna, Mateo jutiyuj runata Jesús ricaran. Payga Roma marcapa mandajninpaj jillayta shuntaycaran. Ricar, Jesús niran: «Mateo, purïshimay.» Niptin, Jesústana Mateo purïshiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chaypita Mateupa wasinćhu purïshijnincunawan Jesús micurcaycaran. Waquin juchaćhu arujcunawanpis, jillayta shuntajcunawanpis micurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Paycunata ricar, fariseucuna Jesúspa purïshijnincunata jamurparan: «¿Imanirtaj jillayta shuntaj chiqui runacunawan, juchaćhu arujcunawan Taytayqui Jesús micun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jamurpaptin, Jesúspis niran: «Jishyaćhucunallash jampicujta ashin. Mana jishyarga, mana ashinchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sumaj tantiyacunquiman. Tayta Diosninchipa shiminćhu nin: ‹Jaramänayquitachu mana munaycä; manchäga runa-masiquita llaquipänayquitam.› Nuwapis juchaćhu arujcunata Tayta Diosninchiman cutichijmi shamushcä. ‹Juchaynajmi cä› nijcunatachu mana ashiycä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chaypita Ushyachicuj Juanpa purïshijnincuna Jesúsman ćhayar, tapucuran: «Fariseucunapis, nuwacunapis ayünar, Tayta Diosninchita mañacü. ¿Imanirtaj purïshijniquicuna mana ayünanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chaynuy niptin quiquinman tincuchicur, Jesús niran: «Warmi ashïshijcuna manash llaquishachu ayünan. Manchäga cushishash micupacärin. Warmi ashij müsuta jićhuptinshi ichanga, ayünangapaj. Jatunpash llaquicungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Chaynuypis mauca müdanata mushuj raćhipawan manash pipis jiranmanchu. Mushujwan jiraptin, jintishpan mauca müdanatapis jatunpanash raćhirachin. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bïnuta puguchinanpäpis manash pipis chaquish jaracha putuman wiñanmanchu. Bïnu pugur, chaquish jaracha pututa pashtarachinshi. Pashtaptin, bïnupis ushyacäcunshi. Jaracha putupis raćhicäcunshi. Chayshi llullu bïnuta llullu jaracha putumanraj wiñan. Chaynuypa bïnupis, jaracha putupis manash ushyacanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús rimaycaptillan juc mayur Israel runa ćhayarcur, Jesúspa ñaupanman jungurpacuycuran: «Tayta, warmi wamrä chayraj wañucusha. Wasïman aywashun. Maquiquiwan yatarcuptiqui, wamrä cawarimungapämi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Niptin, purïshijnincunawan-ima Jesús aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yawar-apaywan jishyaycaj warmipis tallucash aywaycaran. Ćhunca ishcaywan (12) watana jishyaycaran. Jipallanpita tariparcur, Jesúspa müdananta yataycuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","«Müdanallantapis yatar, allchacashaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yataptin, ticrarcur Jesús niran: «Wawallau wawa, ama llaquicuychu. Yupachicamashayquipita allchacashcanqui.» Chaynuy niptin, warmi allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaypita mayur runapa wasinman ćhayar, Jesús yaycuran. Canturcunapis pampananpaj camaricuycaranna. Runacunapis atarcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesúsna niran: «Witicuy. Wamra jipash mana wañushachu. Manchäga puñucashalla caycan.» Niptin, täpajcuna Jesústa asiparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jurpacunata jarguriptin, maquinpita charircur, wamra jipashta Jesús cawarachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Cawarachishanta chay quinranćhu llapan runa mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús aywacuptin, ishcaj japrana Jesúspa jipanta jayacuraycar aywacullaran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wasiman ćhayaptin, ishcaj japracunapis ćhayaran. Paycunata Jesús tapuran: «Allchacächinäpaj yupachicamanquichu» nir. Japracunana: «Aumi, Tayta» niran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chaynuy niptin japra runacunapa ñawinta yataycur, Jesús niran: «Yupachicamashayquiman-tupu allchacashana canquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chaura ñawin quićhacäcuran. Ñawincuna quićhacäcuptin, Jesús piñaparan: «Pitasi ama willapanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Paycunam ichanga shiminta chapacuyta mana camäpacuranchu. Manchäga marcanman aywaycur llapanta willaparan: «Ñawïta Jesúsmi allchacächisha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Japracuna aywacurishallanta supay pucllacushan upa runatapis Jesúsman ćhayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Supayta Jesús jarguptin, upa runa rimariranna. Upa runa rimariptin, llapan runa cushicuran: «Cay Israel marcanchićhu upa rimajta imaypis mana ricaranchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseucunam ichanga niran: «Mayur supayta jayararshi, supaycunata jarguycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chaypita marcan-marcan purir shuntacäna wasicunaćhu Tayta Diosninchipa shiminta Jesús willapäcuran. Alli willapata willapäcur niran: «Maquinćhu cawananchipaj Tayta Diosninchi shuyaraycämanchi» nir. Jishyaćhucunatapis, nanapäcujcunatapis allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Achcaj runata ricar, Jesús llaquiparan: «Cay runacunata pipis mana ricanchu. Ujracash uysha-yupay mancharish carcaycan. Llaquish carcaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaymi micuy shuntaywan tincuchir purïshijnincunata niran: «Micuy puguraycaj-yupay chay-chicaj runa Tayta Diosninchipa shiminta wiyaj-wiyajlla shuyaraycan. Shiminta willacujcunam ichanga wallcajlla. ");
INSERT INTO qxhNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chaymi willacujcuna juclla yapacämunanpaj Tayta Diosninchita mañacäriy. Shiminta ćhasquicujcunata shuntamunan carcaycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaypita ćhunca ishcaywan purïshijnincunata Jesús shuntaran. Nircur cargunman ćhuraycur niran: «Nuwapita munayniyuj caycanqui supaycunata jargunayquipäpis, jishyaćhucunatawan nanapäcujcunata allchacächinayquipäpis.» ");
INSERT INTO qxhNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesúspa purïshijnincuna ćhunca ishcaywanmi caran: «Pedro» nishan Simón, Simónpa wauguin Andrés, Zebedeupa ishcan wamran Santiaguwan Juan, ");
INSERT INTO qxhNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, jillayta shuntaj Mateo, Alfeupa wamran Santiago, Tadeo, ");
INSERT INTO qxhNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","«Marcanpaj nanachicuj» nishan Simón, Judas Iscariote. Payga Jesústa wañuyman jitarpuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Ćhunca ishcaywan purïshijnincunata caćhacuran. Cargunman ćhurar, Jesús niran: «Sumaj wiyamay. Israel runacunallaman caćhashayqui. Paycuna ujracash uysha-yupay cawan. Jäpa runacunamanmi ichanga ama aywanquichu. Samaria runacunapa marcanmanpis ama yaycunquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Israel runacunata willapar ninqui: ‹Tayta Diosninchi shuyaraycämanchi. Maquinćhüna purichimäshun› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jishyaćhucunatapis allchacächinqui. Wañushcunatapis cawarachinqui. Jaraćhu jishyacunatapis allchacächir, allina ricanqui. Supaycunatapis jargunqui. Carguyquiman ćhurar, llapan shungüwan ćhurashcaj. Mana imatapis mañacushcajchu. Jamcunapis imatapis mana mañacullar, llapan shunguyquiwan carguyquita ćharcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Willapäcuj aywar, jillayniquita ama apanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jipiquitapis, rucanayquitapis, llanguiquitapis, garutiquitapis ama apanquichu. Shimïta willapäcujcunaga micush-upush purinan camacan. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Marcacunaman ćhayar, alli runata ashinqui. Pachacur, jucläpa aywacushayquicaman jinallanćhu pacharäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Juc wasiman ćhayar: ‹Tayta Diosninchi yanapayculläshunqui› nir wamayanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ćhasquicushushpayqui änirmi alli cawayta taringa; manchä, mana. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ćhayashayqui marcaćhu, ćhayashayqui wasićhu mana ćhasquishuptiqui, mana wiyashuptiqui, ćhaquiquita pichacurir aywacunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sumaj tantiyacunquiman. Cay pacha ushyacaptin, Sodoma quinran runacunatawan Gomorra quinran runacunata ñacachirpis, Tayta Diosninchi llaquipangaraj. Wasguipajcunatam ichanga mana llaquipällar ñacachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Sumaj tantiyacunquiman. Willapäcuj caćhar, uyshata liyun rurinman jaycurij-yupay caćhaycaj. Juyu runacunaman ćhayanquipaj. Chaymi pichuysa curu-yupaypis jishpij-jishpijlla purinqui. Paluma-yupaypis llutalla purinqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sumaj tantiyacunquiman. Chiquishushpayqui mayur Israel runacunaman ćhayachishunquipaj. Shuntacäna wasicunaćhüsi magashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ćhasquicamashayqui-janan Roma auturdäcunamanpis, Roma mandajcunamanpis ćhayachishunquipaj. Wacpa-caypa purichishuptiquisi, shimiquita ama amucurcunquichu. Manchäga auturdä captinsi, jäpa runacuna captinsi, pï-maytapis nuwapita willapanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Auturdäcunaman ćhayachishuptiqui, ama llutäpacunquichu: ‹¿Imataraj rimashaj? ¿Imanayparaj chapacusha?› nir. Manchäga shimiquiman Tayta Diosninchi ćhurashallanta rimanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Quiquillayquipitachu mana rimanquipaj. Manchäga quiquin Espíritu Santu rimachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Waugui-purapis nuwa-janan wañuyman jitarpanacunga. Juc waugui chiquimar, ćhasquicamaj wauguinta wañuyman jitarpunga. Papänincunapis wamrancunata wañuyman jitarpunga. Wamrancunapis maman-taytanta chiquir, wañuyman jitarpunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ćhasquicamashayqui-janan llapan runa chiquishunquipaj. Imaman ćhayarpis mana wasguimaptiquiga, maquinćhümi Tayta Diosninchi imaycamanpis cawachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","«Juc marcapita jaticaćhäshuptiqui, juc marcamanna jishpicunqui. Sumaj tantiyacunquiman. Cutimushäcaman llapan Israel marcacunaman ćhayayta mana atipanquipächu. Llapanman mana ćhayaptiquisi, Tayta Diosninchipa caćhan cashpä cutimushaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Jipa wamracuna mayur runacuna yarpashanta manash yarpanrächu. Uyway runapis patrunninta manash apärinmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jipa wamracuna mayur runa yarpashanta yarparraj cushicunman. Uyway runapis patrunninta ricacurraj, cushicunman. Sumaj wiyacunquiman. Juyu runacuna ashllimar nin: ‹Supaycunapa mandajnin Beelzebulmi canqui.› Chaynuy ashllimaptin, ¿imamanraj tincuchishunquipaj maquïćhu cawaptiqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Chiqui runacuna imata rurashuptiquisi, ama manchacunquichu. Runacuna shungullanćhu pacarächishanpis mayacanga. Imata yarpashanpis unayllata musyacanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chaymi rinrillayquićhu willashäta llapan runapa rinrinman ćhayachiy. Quiquillayquita willapashätapis llapan runata musyachiy. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chiqui runacuna wañuchishunayquita ama manchacunquichu. Wañuchishushpayquisi, almayquita mana wañuchingachu. Tayta Diosninchitam ichanga manchapacärinquiman. Payga munayniyujmi wañuyman jitarpushunayquipäpis, almayquita ninaćhu illarachinanpäpis. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Chaymi ama mancharinquichu. Acapalla pichuysacuna mana ćhaninchu. Chaypis Tayta Diosninchi camacächiptinraj, wañuyman ćhayan. Pichuysata ricaycarga, ¿jungaycushunquimanchuraj? Mana. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tayta Diosninchipa maquinćhümi cawaycanqui. Mana imaysi jungashunquichu. Ajchayquitapis yuparaycächin. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chaymi imatapis ama manchacuychu. Jamcunaman pichuysacunapis mana tincunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","33","Runacunata mana manchacur ćhasquicamashayquita willacuptiqui, janaj pachaćhu Papänïpa ñaupanćhu nuwapis willacushaj: ‹Rasunpa maquïćhu purin› nir. Runata manchacur wasguimaptiquim ichanga, nuwapis janaj pachaćhu Papänïpa ñaupanćhu wasguishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Shunguyquićhu ama yarpanquichu: ‹Cay pachaman Jesús shamusha alli cawayta tarichimänanchipaj.› Runacuna mana alli cawayllaćhüchu cawanga. Manchäga ćhasquicamashayqui-janan chiquir ushyashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nuwa-janan papänintapis ullgu wamran chiquinga. Warmi wamranpis mamanta chiquinga. Llumchuyninpis suydanta chiquinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Juc wasićhu quiquin-puralla tincupänacunga. Chiquinacunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Shungü munashallanta ruranquiman. Mamayqui-taytayqui-janan ama jungaramanquimanchu. Wamrayquicuna-janan ama wasguiramanquimanchu. Shimïta wiyacuptiquiraj, alli ricashayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Shimïta wiyacujcuna imanuy ñacarsi, rusćhu wañuyman ćhayarsi, ricay ñawïćhu alli cawanman. Manchäga purïshimayta mana camäpacungachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ñacaytapis, wañuytapis manchacur maquïćhu puriyta mana munar, ushyacayman ćhayangapaj. Maquïćhu purir llapanta jaguijcunam ichanga imaycamanpis Tayta Diosninchipa maquinćhu cawangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Shimiquita ćhasquicujcuna nuwatapis ćhasquicaman. Ćhasquicamajcunana Tayta Diosninchitapis ćhasquicun. Paymi caćhamasha. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pipis Tayta Diosninchipa shiminta willacujcunata ćhasquiptin, willacujta-jina Tayta Diosninchipis alli ricar ayninta cutichinga. Wiyacuj runata ćhasquiptin, wiyacuj runata-jina Tayta Diosninchipis alli ricar ayninta cutichinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sumaj tantiyacunquiman. Pipis: ‹Washäcuj Jesúspa purïshijnin canqui› nir yacullatasi macyaycushuptiqui, Tayta Diosninchipis alli ricar ayninta cutichinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ćhunca ishcaywan purïshijnincunata willapariycur, Jesús aywacuran. Waquin marcacunaćhüna Tayta Diosninchipa shiminta willapäcuräcur puriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chay wichan Ushyachicuj Juan carsilćhu wićhgaraycaran. Jesús ima-imata rurashallanta mayar, purïshijnincunata Jesúsman caćharan: ");
INSERT INTO qxhNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«¿Jamchush Tayta Diosninchi caćhamushan Washäcuj caycanqui? ¿Juctarächush shuyäcärishaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tapuptin, Jesús niran: «Cutircur, ricashayquicunata, wiyashayquicunata, Juanta willar ninqui: ");
INSERT INTO qxhNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‹Japracuna ricaycanna. Wijrucunapis puriycanna. Jaraćhu jishyajcunapis allchacaycanna. Upacunapis wiyaycanna. Wañushcunatapis cawarachin. Pishipacujcunatapis Tayta Diosninchipa alli willapanta willapäcuycanna.› ");
INSERT INTO qxhNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chaymi Tayta Diosninchipa caćhan cashäta mana wasguijcuna sumaj cushicärinman. Imaman ćhayaptinsi, paycunata Tayta Diosninchi sumaj yanapan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chaura Ushyachicuj Juanpa caćhancuna cuticuriptin, juturashan runacunata Jesús niran: «Jamcunapis chunyaj pachaman aywar, Juanpa shiminta wiyarayquim, ¿au? Payga imatapis mana manchacujchu. Mana ishcay-quimsatachu rimaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Imamanraj aywashcanqui? ¿Alli müdanashtachu tarishcanqui? Mana. Alli müdanashcunata achic-achicyaycaj wasillaćhu juyaycajtam tarinqui. Jatun auturdäcunallam alli-alliga cawan. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pï runataraj ashishcanqui? Chunyaj pachaćhu Juanpa shiminta wiyaycur, Tayta Diosninchipa willacujnin cashanta tantiyacärishcanqui. Payman waquin willacujcunapis mana tincuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanta caćhamunanpaj unayna Tayta Diosninchi musyachicuran. Shiminćhu nin: ‹Caćhäta ñaupapäshunayquipaj juc runata ñaupachishaj. Camaricushalla shuyaräshunayquipaj runacunata willapäcungapaj› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Sumaj tantiyacunquiman. Chay-chicaj runa carsi, Ushyachicuj Juanman mayganpis mana tincushachu. Chaypis maygan runa mana alli ricash caycaptinsi, Tayta Diosninchipa maquinćhu cawajcunaman Juanpis mana tincunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","«Ushyachicuj Juan willapäcushanpita-pacha Tayta Diosninchitapis, shiminta wiyacujcunatapis runacuna chiquin. Maquichacuyta munan. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chaynuy cananta manaraj Juan willapäcuptillan, unay willacujcunapis, Moiséspis musyachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","‹Willacuj Elíasta caćhamushaj› nir Ushyachicuj Juanta caćhamunanpaj musyachicuycaran. Chayta tantiyar, rimashantapis tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Rinriyujmi canqui. Tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Chaymi paycunata wiyächipar Jesús niran: «Canan wichan runacunata, ¿imawanraj tincuchïman? Yupay-tucuj wamracunawanćhi tincuchishaj. Upa wamracuna-jina mana imatapis tantiyacunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Cushicuywan jachwashun› nir quïnata tucapaptinpis, mana jachwashcanquichu. ‹Llaquicuywan wagashun› niptinpis, mana wagashcanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«Chay-jina Ushyachicuj Juan ichic-ichicllata micuj. Bïnutapis mana mallishachu. Chaypis Juanta ashllishcanqui: ‹Supay pucllacusha› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nuwatapis Tayta Diosninchi caćhamasha. Llapanta micü. Bïnutapis upü. Chaypis ashllircaycämanqui: ‹Shincanan-raycullar, paćhan-raycullar purin. Juchaćhu arujcunawanpis, jillayta shuntaj chiqui runacunawanpis purin› nir. Imata rimarsi, Tayta Diosninchi yarpashanta pipis mana chapanmanchu. Shiminta wiyacujcunaga ricsipalla cawan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Shiminta mana wiyacushanpita runacunata Jesús piñacuran. Payga Tayta Diosninchi sumaj munayniyuj cashanta musyachicur tucuy-jinanpa imatapis rurar, runacunata sumaj yanaparan. Chaypis runacuna jucha aparicushanpita mana wanacuranchu. Chaymi Jesús piñacur niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Corozaín runacuna, Betsaida runacuna, Israel runa captiquisi, juyupa Tayta Diosninchi ñacachishunquipaj. Pay camacächiyninpa shiminta willapaycaptïsi, jishyaćhucunata allchacaycächiptïsi, chay-chicaj runata jaraycaptïsi, supaycunata jarguycaptïsi, maquinćhu cawayta mana munashcanquichu. Jäpa Tiro marca runacunawan jäpa Sidón marca runacunam ichanga jishyaćhucunata allchacächishäta ricar, supaycunata jargushäta ricar, mayna Tayta Diosninchipa shiminta ćhasquicur juchanpita wanacunman caran. Wanacushan musyacänanpaj llaquicuywan mayna waganman caran. Umanman ućhpata pićhucunman caran. Jaćhga müdananta ushtucunman caran. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chaymi Tiro runacunatawan Sidón runacunata Tayta Diosninchi yangallaraj ñacachingapaj. Jamcunatam ichanga ricaycarsi mana wanacushayquipita cay pacha ushyacashan junaj juyupa ñacachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Cafarnaún runacuna: ‹Janaj pachaman aywashaj› niptiquisi, yarpashayqui mana camacangachu. Chacaj pachaman Tayta Diosninchi jargushunquipaj. Sodoma runacunam ichanga wanacunman caran Tayta Diosninchi camacächishanta ricaycar. Wanacurga, marcantin mana ushyacanmanchu caran. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sodoma runacuna mana wanacushanpita ushyacaran. Jamcunatam ichanga mana wanacuptiqui cay pacha ushyacaptin, llaquipaypaj Tayta Diosninchi ñacachishunquipaj. Chay junajmi juchayquita sumaj jurgapäshunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chaypita Tayta Diosninchita alliman ćhurar, wiyächipaypa Jesús niran: «Papällau Papä, jatunpa cushicü. Cay pachapis, janaj pachapis maquiquićhu caycan. Alli shungu runacunata wamra-jina wiyacuj captin, yarpashayquita musyachishcanqui. Yaćhaj-tucujcunatam ichanga shunguyqui yarpashanta mana musyachishcanquichu. Papä, shunguyqui munashanta llapantam camacächishcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jinarcur llapan runata niran: «Shungun munaptin, Papänï maquïman llapanta ćhurasha. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wawan cashäta Papänï musyan. Wawan carmi, Papänï pï cashantapis musyä. Yanapaptïraj, pipis Papänïpa shungunta musyapanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«¿Imanirtaj jamcuna llaquish juyanqui? ¿Imanirtaj llutäpacur cawanqui? Wiyacamaptiquiga, alli cawayta tarichishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Shimïta wiyacunquiman. Imanuy cawashätapis ricacunquiman. Tantiyacujmi cä. Alli shungu cä. Allilla cawachishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Shimïga mana sasachu ćharcunayquipaj. Mana yamacanquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juc cuti diyawarda junajćhu rïgu cantunpa purïshijnincunawan Jesús aywaycaran. Purïshijnincunana yargar rïguta shipircur-shipircur cupacaćhärir, ućhuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cupacaćhashanta ricar, waquin fariseucuna tapuran: «¿Imanirtaj diyawardaćhu purïshijniquicuna rïguta cupacaćharcaycan? Diyawardaćhu Tayta Diosninchipa shiminta ćharcurmi, mana arunchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Chaura Jesús niran: «¿Auquillunchi David imata rurashantapis manachu musyanqui? Tayta Diosninchipa shiminta liguiycarsi, ¿yargaywan David imata rurashantapis manachu tantiyacushcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yargay chariptin Tayta Diosninchipa wasinman yaycurir, jarashan tantanta micuran. Cüracunallapa micunan caycaptinsi, yanaguincunawanraj David micupäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Moiséspa shimintapis manachu liguishcanqui? Shiminćhu nin: ‹Diyawarda captinsi, Tayta Diosninchipa wasinćhu aruj cüracuna arucunman. Arursi, juchata mana aparicunchu.› ");
INSERT INTO qxhNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","«Sumaj wiyamay. Tayta Diosninchipa wasinta ama manchapacunquichu. Manchäga quiquïta sumaj manchapacamanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jamcuna Tayta Diosninchipa shiminta mana tantiyacunquirächu. Shiminćhu nin: ‹Jaramänayquitachu mana munaycä; manchäga runa-masiquita llaquipänayquitam.› Shiminta tantiyacur, purïshimajnïcunata mana tumpanquimanchu caran: ‹Juchata aparicusha› nir. Paycunaga juchata mana aparicushachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tayta Diosninchi caćhamasha. Chaymi diyawardapis maquïćhu caycan. Diyawardaćhu runa imata rurananpäpis, imata mićhänäpäpis maquïćhu caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaypita aywacur, juc shuntacäna wasiman Jesús ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Maquin wañush runapis caycaran. Waquin runa achäquita ashinan-cashallan Jesústa tapucuran: «Tayta, ¿diyawarda caycaptin, Moiséspa shimin auninchu jishyaćhucunata allchacächinanchipaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesúsna niran: «Diyawarda caycaptin japallan uyshayqui ućhcuman shicwaptin, ¿manachu utgaylla jurgurinquiman? ");
INSERT INTO qxhNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Uyshatapis cawananpaj jurguycar, ¿jishyaćhu runata manachu yanapäshuwan? Chaymi diyawarda captinsi, yanapänacunanchi camacan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jinarcur maquin wañush runata Jesús niran: «Maquiquita chutapacuy.» Chutapacuriptin, maquin änir allchacäcuranna. Juc-caj maquin-jina allina ricacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseucunam ichanga ullgush llucshicur, parlanacuran Jesústa wañurachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chaura wañuchiyta munashanta musyar, Jesús aywacuran. Aywacuptinsi, achcaj runa aywäshiran. Jishyaćhucunatapis allchacächir, piñaparan: ");
INSERT INTO qxhNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","«Pï cashätapis ama willacunquichu» nir. Ricsichinanta mana munaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chaynuypa unay willacuj Isaíaspa shimin ćharcucaran. Tayta Diosninchi musyachiptin, Isaías unay niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Mä, wiyamay. Mandu-rurajnïta quiquï acracushcä. Payta llaquï. Shungüwan sumaj tincun. Espíritu Santupa maquinćhu purichishaj. Llapan runacunata may-chayćhu juyarpis, shacyächinga: ‹Maquinćhu Tayta Diosninchi puriycächishunqui› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Piwanpis mana piñanacungachu. Mana tincupänacungachu. Runa ricay mana rimangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wañunächi runacunatapis alli ñawinpa ricanga. Pishipacuj wacchacunata llaquipanga. Llapan runa Tayta Diosninchipa maquinćhu alli cawananta munar, llapantapis ruranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Llapan runa may-chayćhu juyarpis, payman yupachicunga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaypita supay pucllacushan runata Jesúsman apamuran. Chay runa mana ricaranchu. Mana rimaranchu. Jesús allchacächiptinmi ichanga, shiminpis rimaricuranna. Ñawinpis ricaranna. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chayta ricar, runacuna mancharicäcushpan tapunacuran: «¿Cay runa washämäshunchuraj? ¿Rasunpachuraj unay mandaj Davidpa willcan?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Runacuna rimashanta wiyarmi ichanga, fariseucuna Jesústa pampaman ćhuraran: «Supaycunapa mandajnin Beelzebulta jayararshi, supaycunata jarguycan. Mana Tayta Diosninchitachu jayaraycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Shungun yarpashanta musyar, Jesús tincuchiypa niran: «Juc marcaćhu runacuna quiquin-pura ticrapanacurshi, wacpa-caypa aywacärin. May marcaćhüpis, may wasićhüpis majanwan ticrapanacur, raquicaymanshi ćhayan. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mayur supaypis supay-masinwan ticrapanacur, ima ruraytapis mana camäpacunmanchu, ¿au? Raquicar-raquicar, ushyacäcunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿Imanirtaj Beelzebulta jayararraj supaycunata jargushäta yarparcaycanqui? Mä, tapucushayqui. Jamcunapis supayta jargur, ¿pitataj jayaranqui? ¿Tayta Diosninchita jayararchu, supayta jayararchu? Beelzebulta jayararraj jarguptï, jamcunapis payta jayararräćhi jarguycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sumaj tantiyacunquiman. Tayta Diosninchi camacächiptin, munayninwan supaycunata jargur, Tayta Diosninchi munayniyuj cashanta musyachicuycä. Chayta ricar, maquinćhüna Tayta Diosninchi runacunata puriycächishantapis tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tincuchiypa tantiyachishayqui. Juc runash quiquinpa imancunata sumaj rican. Chayshi sumaj callpayuj yaycurraj, wasiyujta mancurnan. Jinarcurräshi imancunatapis ushyajpaj apacun. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Chaymi Tayta Diosninchi caćhamashanta mana aunirga, chiquircaycämanqui. Tayta Diosninchipa shiminta willacuptï mana yanapämarga, chapata rurarcaycämanqui. Runacunatapis manchaycächinqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Sumaj wiyamay. Runacuna tucuy-jinanpa juchata aparicun. Chaypis wanacuptin Tayta Diosninchi llaquipar, juchanta mana yarparanganachu. Tayta Diosninchi Espíritu Santuwan allita ruraycaptinsi: ‹Rurashanta supaypa maquinćhi› nir runa ashllir ushyaptinmi ichanga, Tayta Diosninchi juchanta mana imaysi jungangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tayta Diosninchi caćhamashanta mana aunir tincupämaptinsi, Tayta Diosninchi juchanta mana yarparanganachu. Allita ruranäpaj Espíritu Santu camacächiptin: ‹Payga supayta jayaran› nir tincupaptinmi ichanga, Tayta Diosninchi juchanta mana imaysi jungangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Chay-jina yürata wayuyninpa ricsinchi. Alli yüra mishquijta wayun. Wañunächi yüram ichanga wamajllata wayun. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tumpamashayquipita jamcuna supaypa wawan carcaycanqui. Juchallaćhu arurcaycanqui. Shunguyqui yarpashanta musyachicur, tucuytapis rimanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tayta Diosninchita manchapacuj runa Tayta Diosninchipa shungun munashallanta ruran. Juchaćhu aruj runam ichanga llutanta ruran shungun llutanta yarpaptin. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sumaj wiyacäriy. Cay pacha ushyacaptin, llapan runata ima-imata rimashanpitapis Tayta Diosninchi ñauquinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Shiminman-tupu runacunapa juchanta jurgapanga. Shimillayquipita alli cawaytapis tarinquipaj. Ñacaymanpis ćhayanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chaura waquin fariseucunawan Moiséspa shiminta yaćhajcuna niran: «Tayta Jesús, Tayta Diosninchi camacächiyninpa mä, imallatapis ruray.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesúsna niran: «Jamcuna juchallaćhu arunqui. Jananpachicuj carcaycanqui. Tayta Diosninchi camacächiyninpa imallata ruranäta munaptiquisi, mana rurashächu. Chaypis tantiyayta munar, unay willacuj Jonáspa willapanta yarparanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonásga quimsa pagas, quimsa junaj jatun piscädupa paćhanćhu caran. Chay-jina nuwapis Tayta Diosninchi caćhamash captin, quimsa pagas, quimsa junaj pacha rurinćhu pamparäshaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","«Jucha aparicushanpita llapan runata Tayta Diosninchi ñauquiptin, Nínive marca runacunapis ñauquishunquipaj: ‹Tayta Diosninchi llaquipämashanta Jonás willapämaptin, wanacärishcä. Jamcunam ichanga mana wanacärishcanquichu› nir. Jonásga Tayta Diosninchipa willacujnin carsi, nuwaman mana tincushachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sumaj tantiyacunquiman. Cay pacha ushyacaptin, llapan runata jucha aparicushanpita Tayta Diosninchi ñauquiptin, Saba marca mandaj warmipis cawarimunga. Paymi ñauquishunquipaj: ‹Mandaj Salomónpa shiminta wiyar, Tayta Diosninchi llaquipäcuj cashanta tantiyacushcä. Jamcunam ichanga mana tantiyacärishcanquichu› nir. Chay warmi carupita-pacha shamuran mandaj Salomón rimashanta wiyananpaj. Wiyar, Tayta Diosninchipa shiminta ćhasquicuran. Mandaj Salomón yaćhaj carsi, nuwaman mana tincushachu. Chaypis shimïta wiyacuyta mana munanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Supay imata rurashantapis tantiyacunquiman. Runapita jargush captin, chunyajćhüshi purin. Jamaytapis manash tarinchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mayćhüpis jamayta mana tarir, yarpaćhacun: ‹Chay runaman cuticushaj› nir. Cutirshi, chay runata pichapacush wasita-jina, jäcuycaj wasita-jina tarin. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chayshi janćhis mas juyu supay-masincunata pushacurcur runaćhu tiyananpaj cutin. Supaycuna cutiptin, juyu cashanpitash masna runa juyuyacäcun. Chay runa juyuyacäcushan-jina jamcunapis juchallaćhu arur, juyuyacäcunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Juturaj runacunata parlapaycaptillan, Jesúspa mamanwan wauguincuna ćhayaran. Paywan parlayta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chaymi juc runa niran: «Tayta Jesús, mamayquiwan wauguiquicunash jawaćhu shuyarpaycäshunqui. Jamwan parlaytash munaycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Willaptin, Jesús niran: «¿Pitaj mamä? ¿Pitaj wauguïcuna?» ");
INSERT INTO qxhNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Purïshijnincunata ricärir, niran: «Jamcuna mamä, wauguïcuna canqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pï-maypis janaj pachaćhu Papänïpa shungun munashanta rurajcunaga mamäwan, wauguïwan, panïwanmi tincun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay junaj wasipita aywacur, jatun püsu cantunćhu Jesús jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jamaraycaptin, achcaj runa ćhayapuran. Chay-chicajta ricar, willapäcunanpaj bütiman jigacurcuran. Runacunam ichanga püsupa cantullanćhu juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaymi imawanpis tincuchiyllapa tantiyachir, Jesús niran: «Juc runash murupacuj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Machiptinshi, waquin muru caminuman ćhayasha. Caminuman ćhayajta pichuysacunash pashacurcusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waquin murunash jarapshu allpaman ćhayasha. Jarapshu captinshi, juclla wiñacarcamusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ichanga janallanćhu sapin captin inti rupaptinshi, chaquicäcusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin murunash shata-shataman ćhayasha. Shata atayäcurcurshi, muru wiñamujtapis jarwashtärachisha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waquin murunash alli allpaman ćhayasha. Sumajshi wayusha. Juc murullapitash waquin wayusha juc paćhacta (100), waquinnash sujta ćhuncata (60), waquinnash quimsa ćhuncata (30). ");
INSERT INTO qxhNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Rinriyujmi canqui. Tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Purïshijnincunana lädunman ashurcur, Jesústa tapuran: «¿Imanirtaj tincuchiyllapa willapäcunqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesúsna niran: «Jamcunata mayna tantiyachishcaj: ‹Maquinćhu cawananchipaj Tayta Diosninchi shuyaraycämanchi› nir. Waquincunatam ichanga mana tantiyachirächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wiyacuptin, pitapis Tayta Diosninchi sumaj tantiyachinga. Mana wiyacujcunatam ichanga ichicllata tantiyashallantapis jungaycachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chaymi imawanpis tincuchiyllapa tantiyachï sumaj tantiyacunanpaj. Ichanga ima-imata rurashätapis ricaycarsi, ñawiynaj-tucun. Wiyaycämarsi, rinriynaj-tucun. Mana tantiyaj-tucunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chayrämi willacuj Isaíaspa shimin ćharcucan. Yarpashanta Tayta Diosninchi musyachiptin, Isaías unayna niran: ‹Wiyajcuna wiyaycarsi, mana tantiyacunchu. Ricajcuna ricaycarsi, tantiyayta mana munanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cay runacuna rumi shungum. Rinriyuj carsi, upa-tucun mana wiyananpaj. Ñawiyuj carsi, japra-tucun mana ricananpaj. Alli shungu carmi ichanga ñawiyuj cashpan rurashäta ricar, tantiyacunman. Rinriyuj cashpan shimïta wiyar, tantiyacunman. Shungunman ćhayaptin, juchata aparicushanpitapis wanacunman. Nuwapis tucuypita allchacächïman.› ");
INSERT INTO qxhNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Purïshimajcuna, jamcunaga cushicärinquiman. Llapan rurashäta ricanayquipäpis, shimïta wiyanayquipäpis Tayta Diosninchi yanapaycäshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sumaj tantiyacunquiman. Unay willacujcunapis, Tayta Diosninchita manchapacuj runacunapis ricamayta munaran. Ima-imata rurashätapis ricayta munaran. Shimïtapis wiyayta munaran. Ichanga mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Canan murupacujwan tincuchiypa willapashajta sumaj tantiyacuy. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Caminu chucru shungu runacunawan tincun. Chucru shungu runacuna Tayta Diosninchipa shiminta wiyarpis shungunman mana ćhayaptin, mana tantiyacunchu. Chaymi yangalla tantiyacushallantapis supay jungaycachin Tayta Diosninchipita witicunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","«Jarapshu allpana janan shungu runawan tincun. Paycuna cushi-cushilla Tayta Diosninchipa shiminta ćhasquicun. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chaypis mana sapichashan-jina janan shungulla. Chaymi Tayta Diosninchita wiyacushan-janan ñacaycuna ćhayapuptin, witicurin. Mana ićhipunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","«Shata wiñanan allpana tincupacaj runawan tincun. Paycuna Tayta Diosninchipa shiminta wiyan. Wiyarsi, cay pachaćhu imapäpis alläpa yarpaćhacur, jillayllata ashir tincupacan. Chaymi Tayta Diosninchipa shiminta wiyash carsi, Tayta Diosninchipa shungun munashanta mana ruranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","«Alli allpana wiyacuj runawan tincun. Paycuna Tayta Diosninchipa shiminta sumaj tantiyacur, manchapacur cawan. Juc murulla alli wayushan-jina allita rurar cawan. Alli muruga wayun paćhacta (100), waquinna sujta ćhuncata (60), waquinna quimsa ćhuncata (30).» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yapay tincuchiypa willapäcur, Jesús niran: «Tayta Diosninchipa maquinćhu cawaypita tantiyachishayqui. Juc runash ćhacranman rïguta murusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Llapan puñucashancamanshi chiqui runa chacayllapa aywarcur, juyu jiwata rïgu murushan jananman mururisha. Jinarcurshi jishpicusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","«Rïgu atayar shicshiyta jallaycuptinshi, juyu jiwapis shicshiyta jallaycusha. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mincaynincunanash ćhacrayujta tapusha: ‹Tayta, alli murullata murushcanqui, ¿au? ¿Imanaypataj juyu jiwaga wiñamusha?› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ćhacrayujnash niran: ‹Chiquimashpan juc runa murupaycamasha.› Mincaynincunanash tapuran: ‹¿Llupiramushächu?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ćhacrayujnash niran: ‹Mana. Jiwata llupiptiqui, rïgupis llupicäcungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Rïguwan tallushalla pugunancaman cacuchun. Puguptin, rutüshimajcunata nishaj: «Puntata juyu jiwacunallata shuntarcur, wancuy. Jinarcur rupachiy. Rïgutam ichanga wasïman shuntay.» › » ");
INSERT INTO qxhNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yapay tincuchiypa willapäcur, Jesús niran: «Tayta Diosninchipa maquinćhu cawajcuna ñäpus muruwan tincun. Juc runash wirtanman ñäpusta mururan. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chay muruga llapan murupitapis mas acapallash. Wiñamurshi ichanga, waquin jaćhacunapitapis mas atayan. Yüranpis sumaj atayäcurcun. Callapancunaćhüpis pichuysacunasi jishucun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yapaypis tincuchiypa willapäcur, Jesús niran: «Tayta Diosninchipa maquinćhu cawajcuna libadürawan tincun. Tantata rurananpaj juc warmi quimsa arüba arinatash libadürawan chapusha. Chapurächisha llapan arinata jacachinancamanshi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Juturashan runacunata imawanpis tincuchiyllapa Jesús willapäcuran. Imapis tincuchinanpaj mana captin, jinalla mana tantiyachijchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chaymi juc willacuj rimashan ćharcuran. Tayta Diosninchi rimachiptin, unayna niran: «Imawanpis tincuchiyllapa willapäcushaj. Shungulläćhu musyashäta willapäcushaj. Cay pachata camashanpita-pacha mana musyachishäta tantiyachicushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chaypita llapan runata jaguiycur, wasinman Jesús cuticuran. Wasipina purïshijnincuna niran: «¿Imamantaj ćhacraćhu murupacushan juyu jiwata tincuchishcanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesúsna niran: «Tayta Diosninchi caćhamasha. Rïgu muruj runawan tincü. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ćhacrana llapan runawan tincun. Rïgu muruna Tayta Diosninchipa maquinćhu cawajcunawan tincun. Juyu jiwana supaypa maquinćhu cawajcunawan tincun. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chiquimajna supaywan tincun. Rutuy junajna cay pacha ushyacaywan tincun. Rutujcunana anjilcunawan tincun. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«Juyu jiwata ninawan rupachishan-jina cay pacha ushyacänan junajćhu canga. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tayta Diosninchipa caćhan carmi, llapan runacunata maquïćhu purichï. Chaymi anjilcunata caćhamushaj waquin runata raquinanpaj. Runa-masinta juchaman janćhash captin, juchaćhu arush captin, shuntarcur ñacayman jaycuringa. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ratataycaj ninaman jaycuringa. Chayćhu atayparaj waganga. Juyupa ñacar, quiruntapis ućhunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tayta Diosninchipa shiminta wiyacujcunam ichanga Tayta Diosninchipa ñaupanćhu cuyayllapaj juturanga. Inti achicyashan-niraj ricacanga. Rinriyujmi canqui. Tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Tayta Diosninchipa maquinćhu caway ćhacraćhu jillay pamparajwan tincun. Juc runash ćhacraćhu jillay pamparajta tarir, jinallanman yapay pampaycun. Jinarcurshi cushicuyllawan jillay pamparaj ćhacrata rantin. Rantinanpäshi quiquinpa imancunatapis ushyaypa ranticuycun. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Tayta Diosninchipa maquinćhu caway achic-achicyaycaj rumiwan tincun. Ranticujcunash sumaj achicyaycaj rumita ashin. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sumaj achic-achicyaycaj rumita tarirshi, llapan imancunatapis ranticuycun. Llapanninta ranticuycurshi, achic-achicyaycaj rumita rantin. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Tayta Diosninchipa maquinćhu caway ridiwan tincun. Ridita yacuman jitarga, tucuy-niraj piscädutash charin. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ridiman piscädu juntaptin, pallgamanshi jurgun. Jinarcurshi acran. Allicajtash canistaman wiñan. Mana allicajcunatash ichanga wicaparin. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chaynuymi canga cay pacha ushyacaptin. Anjilcuna shamur, Tayta Diosninchipa shiminta wiyacujcunatapis, juyu runacunatapis acranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Juyu runacunataga ratataycaj ninaman jaycuringa. Chayćhu atayparaj waganga. Juyupa ñacar, quiruntapis ućhunga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chaura llapanta willapariycur, Jesús tapuran: «¿Yaćhachishäta llapantachu tantiyashcanqui?» nir. Paycunana niran: «Au. Tantiyashcämi, Tayta.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesúsna niran: «Tayta Diosninchipa maquinćhu cawayta yaćhajcuna wasiyuj runawan tincun. Wasiyujga allitash jipirächin. Pascar, mushujcunatapis, unay-cajcunatapis ricachicunshi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tincuchiypa willapäcuricur, Jesús aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Marcanman cuticur, shuntacäna wasićhüna willapäcuran. Runacuna tantiyayta mana atipar, tapunacurcaycaran: «Jesús sumaj yaćhan, ¿au? ¿Mayćhüraj llapanta yaćhacusha? ¿Imanuyparaj Tayta Diosnillanchi camacächishancunata ruran? ");
INSERT INTO qxhNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Payga carpintïru Josépa wamrallan, ¿au? Mamanpis, ¿manachu María? Wauguincunapis Santiago, José, Simón, Judas, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Panincunawanpis waran-waran tincuycanchi, ¿manachu? Jinan runa caycar, ¿imanuyparaj llapanta yaćhacusha?» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chaynuy nir Jesústa pampaman ćhuraran. Jesúsna niran: «May-chayćhüpis alli ñawinpa Tayta Diosninchipa willacujninta rican. Yurishan marcaćhümi ichanga marca-masincunapis, yawar-masincunapis pampaman ćhuran. Ricaytapis mana munanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Runacuna payman mana yupachicushanpita Tayta Diosninchi camacächiyninpa mana imatapis ruranchu. Juc-ishcay jishyaćhucunallata allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay wichan Galilea marcacunata mandaj Herodes Jesús ima-imata rurashantapis mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wiyashpan yanapajnincunata niran: « ‹Jesús› nishan runa Ushyachicuj Juanćhi wañushanpita cawarircamusha. Chayćhi munayniyuj ricarimusha Tayta Diosnillanchi camacächishancunata rurananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ushyachicuj Juanta piñacushallanpita quiquin mandaj Herodes unayna mancurnarcachir, carsilman wićhgachish caran. Juan piñacurunaj: «Tayta Herodes, mama Herodíasga wauguiqui Felipupa warminmi. Wauguiquipa warminta ama jićhunquimanchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mandaj Herodes wañurachiyta munarsi, runacunata manchacuran. Runacuna niran: «Ushyachicuj Juan Tayta Diosninchipa willacujninmi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Juc junaj mandaj Herodes diyanta tünaran. Tünaćhu mama Herodíaspa jipashninraj sumaj jachwaptin, mandaj Herodes cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sumaj cushicur, jipashta niran: «Shunguyqui munashanta mañacamay. Munaptiqui, imätapis juycushayquim.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jipashna maman shacyächiptin, mandaj Herodesta niran: «Ushyachicuj Juanpa umanta mañacushayqui. Juclla matiwan macyamay.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chaura mandaj Herodes juyupa llaquicäcuran. Llaquicursi, jurpancunapa ñaupanćhu aunish cashpan mañacushanta ćharcuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chaymi mincaynincunata caćharan Juanpa umanta rugunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mincaynincunana Juanpa umanta änir matillawan jipashta macyaycuran. Jipashna mamanta juycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juanpa purïshijnincuna aywarcur ayanta shuntaran. Pampaycäriran. Jinarcur Jesústa willaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juanta wañuchishanta mayar, Jesús bütiman jigarcuran. Püsuta chimpar, chunyaj pachaman aywacuran. Shuyninpa aywacushanta mayar, chay-tucuy marcapita runacuna ćhaquillapa tariparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bütipita Jesús llucshirir achcaj runata ricar, llaquiparan. Jishyaćhucunatapis allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pacha chacanaycaptin, purïshijnincuna Jesústa niran: «Chunyaj pachaćhu carcaycanchi. Pachapis chacanaycan. Runacuna marcacunaman aywacuchun micuyta rantircur micunanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesúsna niran: «Ama aywacuchunchu. Jamcuna jaranquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Paycunana niran: «Pichga tantatawan ishcay piscädullata chararcaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesúsna niran: «Mä, apamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jinarcur llapan runata pashpallaman jamachiran. Pichga tantatawan ishcay piscäduta aptacurcur janaj pachaman ricärir, niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Nircur tantacunata paquircur-paquircur, purïshijnincunata macyaran. Paycunana llapan runata jararan. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Runacunana puchupacushancaman micuran. Micurcuptin, puchupacushanta ćhunca ishcaywan (12) canista juntataraj shuntaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Micujcunata yupaptin, ullgulla pichga waranga-yupay (5,000) caycaran. Warmicunatawan wamracunatam ichanga mana yuparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jinarcur chimpapa ñaupacärinanpaj purïshijnincunata bütiman Jesús jigachiran. Nircur llapan runata wasinman-caman cutircachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Llapan aywacuriptin, quiquillanna Jesús puntaman aywaran Tayta Diosninchita mañacunanpaj. Mañacuycaptillan, pachapis chacacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Purïshijnincunana bütiwan jatun püsu ćhaupinta aywaycaran. Chicchinpa wacman-cayman purichicuycaran. Wayrapis chapacaćhaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pacha waraycaptillan, yacu janallanpa Jesús taripaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Purïshijnincunana yacu jananpa taripaycajta ricar mancharir, japaćhacäriran: «Alma shaycämun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesúsna niran: «Ama manchacamaychu. Quiquïmi caycä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedruna niran: «Tayta, rasunpa quiquiqui cashpayqui, yacu janallanpa shamunäpaj camacächiy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesúsna: «Shamuy, ari» nir Pedruta jayaran. Payna bütipita llucshirir, yacu janallanpa Jesúsman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yacu büchiypa-büchicurcuptinmi ichanga, mancharicäcuran. Mancharir, yacu rurinman challpucäcuycaran. Chaymi japaćhacuran: «Washämay. Washämay, Tayta» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesúsna juclla maquinpita Pedruta jurguran: «Janan shungulla runa, ¿imanirtaj mana yupachicamanquichu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ishcanin bütiman jigacurcuptin, wayrapis ćhawacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bütićhu aywajcunana Jesúspa ñaupanman jungurpacuycuran: «Rasunpa Tayta Diosninchipa Wawan canqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jatun püsuta chimparir, Genesaret marcaman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chay runacuna Jesústa ricsicuycur, chay-tucuypa willanacäriran. Chaymi jishyaćhucunata Jesúsman apamuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jishyaćhucunana mañacuran: «Tayta Jesús, müdanayquipa cantullantapis yataycachillämay, ari» nir. Yataycujcuna änir allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chaypita waquin fariseucunawan Moiséspa shiminta yaćhajcuna Jerusalén marcapita ćhayarcur, Jesústa tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«¿Imanirtaj purïshijniquicuna auquillunchicuna yaćhachishanta jungaycun? Maquinta awicurinman. Janra maquinwan micur, Tayta Diosninchipa ricay ñawinćhu llutanta ruraycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesúsna tapuran: «¿Imanirtaj Tayta Diosninchipa shiminta jungaycur, auquilluyquicuna yaćhachishushayquita ćharcurcaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tayta Diosninchipa shimin nin: ‹Mamayqui-taytayquita alli ricanqui. Maman-taytanta ashllijcuna ama cawachunpishchu.› ");
INSERT INTO qxhNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jamcunam ichanga mamayqui-taytayquita mana yanapänayqui-cashan nircaycanqui: ‹Cananga imätapis llapantam Tayta Diosninchipa maquinman ćhurashcä. Yanapänajpaj mana puchunnachu.› ");
INSERT INTO qxhNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","«Chaynuy nir pipis maman-taytanta mana yanapänanpaj shimiyaycanqui. Auquilluyquicuna yaćhachishushayquita rurar, Tayta Diosninchipa shiminta pampaman ćhurarcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Janan shungulla carcaycanqui. Rasullantaćhari Tayta Diosninchi rimachiptin, willacuj Isaías unayna niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Cay runacuna shimillanwan alliman ćhuramaj-tucun. Shungunmi ichanga juccunata manchapacun. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Janan shungulla alliman ćhuraman. «Tayta Diosninchipa shimin allim» nirpis, runa yarpashallanta willapäcun.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chaynuy nir llapan runata jayarcur, Jesús niran: «Llapaniqui wiyamay. Shimïta sumaj tantiyacuy. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shiminchiwan micushanchiga, upushanchiga mana juchata aparicachimanchichu. Shungunchićhu llutanta yarpashanchita rimarmi ichanga, Tayta Diosninchipa ricay ñawinćhüpis jucha aparicuyman ćhayachimanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Purïshijnincunana Jesúsman witircur, willaran: «Rimashayquita wiyar, fariseucuna ullgusham» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesúsna niran: «Juyu jiwata sapintinta llupirir ćhacrapita wicapashan-jina paycunatapis janaj pachaćhu tiyaj Papänï illarachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chaymi fariseucunata ama rimapaychu. Paycunaga japra-masinta pushaycaj-jina. Pipis japra-masinwan pushanacur, ishcanin ućhcuman tunicun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaura Pedro niran: «Tayta, micuypita rimashayquita tantiyachimay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesúsna niran: «¿Jamcunapis manachu tantiyacärinquiraj? ");
INSERT INTO qxhNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Runa micushan paćhallaman ćhayan. Micucurcur, ishpacurin. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Runa shungunćhu yarpashanmi ichanga juchaman ćhayachin. Llutanta rimar, Tayta Diosninchipa ricay ñawinćhüpis juchata aparicun. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","«Runa shungunćhu yarpaćhacun juchata rurananpaj, runa-masinta wañuchicunanpaj, majanta jananpachinanpaj, warmi-paćha runa-paćha cananpaj, suwacunanpaj, llullapäcunanpaj, pipa washantapis rimananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Shungun yarpashanta rurar, Tayta Diosninchipa ricay ñawinćhüpis juchata aparicun. Maquinta mana awicullar micurmi ichanga, mana juchatachu aparicun. Tayta Diosninchitapis mana pampamanchu ćhuran.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chaypita aywacur, Tiro marca quinranman, Sidón marca quinranman Jesús ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chay quinranćhu Canaán marca warmi tiyaran. Jäpa warmi carsi Jesústa ricar, japariypa niran: «Taytallau Tayta, unay mandaj Davidpa willcan canqui. Llaquipaycallämay, ari. Warmi wamräta supay pucllacusha. Juyupa ñacaycächin.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yaparir-yaparir mañacuptinsi, Jesús mana wiyaj-tucuranchu. Purïshijnincunana niran: «Tayta Jesús, yanapaycuptiquićhi, alli canga. Japariypa mañacuycäshunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesúsna niran: «Ujracash uysha-jina captin, Israel runacunallaman Tayta Diosninchi caćhamasha, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Warmina Jesúspa ñaupanman jungurpacuycur, mañacuran: «Tayta, yanapaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chaura jäpa runacunata allguwan tincuchir, Jesús niran: «Wamracuna micushanta jićhurir allguta jarananchi mana camacanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Warmina niran: «Rasullanta rimashcanqui, Tayta. Allgucunam ichanga wamracuna caćhapacushallantapis micucun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesúsna niran: «Mamacha, allita rimashcanqui. Llapan shunguyquiwan yupachicamanqui. Mañacamashayqui camacan.» Niptin, jucllash warmipa wamran allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chaypita Galilea püsu cantullanpa Jesús aywaran. Pataman yagaycur, jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jamaraycaptin, achcaj runa ćhayapuran. Wijrucunatapis, cumllucunatapis, japracunatapis, upacunatapis ćhayachiran. Ima jishya charish captinsi, Jesúspa ñaupanman ćhayachiran. Payna llapanta allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Upacuna rimaptin, cumllucuna allchacaptin, wijrucuna alli puriptin, japracuna ricaptin, runacuna jatunpa cushicuran. Tayta Diosninchita alliman ćhuraran: «Israel runacunapa Tayta Diosnin sumaj munayniyuj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Purïshijnincunata shuntarcur, Jesús niran: «Cay runacunata llaquipämi. Quimsa junajna purïshiycämanchi. Micunanpäpis mana canchu. Micünillata wasinman caćhaptinchi, shungunpis ushyacäcunga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Purïshijnincunana niran: «Chunyaj pachaćhu carcaycanchi. ¿Cayćhu tantata tarishuwanchuraj? Runacunapis chay-chicajmi caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesúsna tapuran: «¿Ayca tantatataj chararcaycanqui?» nir. Tapuptin, niran: «Janćhis tantatawan ishcay-quimsa piscädullata.» ");
INSERT INTO qxhNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chaynuy niptin, llapan runata pampallaman jamachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Janćhis tantata, piscäduta aptacurcur, Jesús niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur paquircur-paquircur, purïshijnincunata macyaran. Paycunana llapan runata aypuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Runacunana puchupacushancaman micupacäriran. Puchupacushanta shuntaptin, janćhis canistamanraj juntaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Micujcunata yupaptin, ullgulla ćhuscu waranga (4,000) caran. Warmitawan wamracunatam ichanga mana yuparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Micucurcuptinna, llapan runata Jesús niran: «Wasiquicunaman cuticäriy.» Quiquinmi ichanga bütiman jigarcur, Magadán quinranman chimparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Juc cuti fariseucunawan saduceucuna Jesúsman ćhayaran. Achäquita ashipashpan niran: «Tayta Diosninchi camacächiyninpa mä, imallatapis ruray.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesúsna niran: «Pacha lliuyaraptin: ‹Wara usyanga› nir rimapäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yana pucutayta ricar: ‹Canan tamyanga› nir rimapäcunqui. Tamyanantapis, usyanantapis tantiyanqui. Tayta Diosninchi caćhamashantam ichanga mana tantiyacunquichu, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jamcuna juchallaćhu arunqui. Jananpachicuj carcaycanqui. Tayta Diosninchi camacächiyninpa imallatapis ruranäta munaptiquisi, mana imatapis rurashächu. Tantiyayta munar, unay willacuj Jonáspa willapanta yarparanquiman.» Chaynuy nir Jesús aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chaypita purïshijnincuna-ima Jesús Galilea püsuta chimparan. Purïshijnincunam ichanga micuy apayta jungaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesúsna niran: «Sumaj tantiyacunquiman. Fariseucunapa, saduceucunapa libadüranta ama ćhasquipanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Purïshijnincunana quiquin-puralla parlanacäriran: «Tantata mana apamushanchipitaćhi wiyächipaycämanchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tapunacuycashanta musyar, Jesús niran: «¿Imanirtaj: ‹Tanta mana canchu› ninacurcaycanqui? ¿Manachu yupachicamanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pichga tantallata pichga waranga (5,000) runacunapaj aypächishäta jungaycushcanquinachu? Puchupacushanta, ¿ayca canista juntatataj shuntarayqui? ¿Tantiyayta manachu atipanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Janćhis tantallata ćhuscu waranga (4,000) runapaj aypächishäta jungaycushcanquinachu? Puchupacushancunata, ¿ayca canista juntatataj shuntarayqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imanirtaj mana tantiyacunquirächu? ‹Fariseucunapa, saduceucunapa libadüranta yatarunquiman› nirga, mana tantapächu rimaycarä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chayrämi purïshijnincuna tantiyacurisha. Jesús mana libadürapächu rimaycaran; manchäga fariseucunapa, saduceucunapa yarpashanta mana ćhasquicunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chaypita Cesarea Filipo marca quinranman purïshijnincunawan Jesús aywaran. Aywarcaycashanćhu purïshijnincunata tapuran: «Runacuna, ¿imatataj yarpan Tayta Diosninchi caćhamushan Washäcujpita?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chaura purïshijnincuna niran: «Waquin runash nin: ‹Ushyachicuj Juan.› Waquinnash: ‹Elías› nin. Waquinnash: ‹Jeremías› nin. Waquinnash: ‹Pï carpis, Tayta Diosninchipa willacujnin canga› nin.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chaura quiquincunata Jesús tapuran: «Jamcunapäga, ¿pitaj cä?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedruna niran: «Washäcujmi canqui. Cawaj Tayta Diosninchipa Wawanmi canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesúsna niran: «Jonáspa wawan Simón, cushicunquiman. Janaj pachapita Papänï yanapashcashunqui pï cashätapis musyanayquipaj. Runapa shiminpitachu mana musyashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","«Rasunpa Pedro canqui. (‹Pedro› ninanga: ‹rumi› ninanmi.) Pedro, jutucaj irmänucunata ricanayquipaj ćhurashayqui. Paycunata supaypis mana ićhipungachu. Irmänucuna wañurpis, chacaj pachallaćhu mana imaysi tiyacungachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Canan lläbi charaj-jina llapan irmänucuna maquiquićhu cawanga. Pipis cay pachaćhu Tayta Diosninchipa maquinćhu cawayta munaptin, ricanqui. Mićhashayquita janaj pachaćhüpis Tayta Diosninchi mićhanga. Aunishayquitapis auninga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jinarcur purïshijnincunata piñaparan: «Tayta Diosninchi caćhamushan Washäcuj cashäta pitapis ama willapanquichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chay junajpita-pacha purïshijnincunata Jesús niran: «Jerusalén marcamanna aywanä. Aywaptïga, mayur runacuna, mayur cüracuna, Moiséspa shiminta yaćhaj runacuna juyupa ñacachimanga. Wañuchimanga. Wañuchimaptinsi, quimsa junajta Tayta Diosninchi cawarachimanga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedruna yatalla jayarcur, Jesústa piñacuran: «Tayta, rimashayqui ama camacächunchu. Tayta Diosninchipis ama camacächichunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesúsna ullgüparan: «Pedro, Supaymi canqui. Washata ayway. Chapata ama ruramaychu. Tayta Diosninchipa shiminta ćharcunäta mićhaycämanqui. Imatapis munapashayquitaga runacunalla ashin. Tayta Diosninchipa shungun yarpashanwan ichanga mana tincunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jinarcur purïshijnincunata Jesús niran: «Pipis purïshimayta munar, quiquinpa shungun munashanta ama ruranmanchu. Manchäga nuwa-janan ñacachiptinsi, rusćhu wañuchiptinsi shimïta wiyacuchun. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ñacaytapis, wañuytapis manchacur maquïćhu puriyta mana munar, ushyacayman ćhayangapaj. Maquïćhu purir llapanninta jaguijcunam ichanga imaycamanpis Tayta Diosninchipa maquinćhu cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sumaj rïcuyayta tarirpis ushyacayman ćhayaptin, rïcu cayninga, ¿imapäraj alli? ¿Rïcu cayninga Tayta Diosninchipa ñaupanman ćhayachingachuraj? ");
INSERT INTO qxhNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Washäcuj car Tayta Diosninchi caćhamaptin, anjilcunawan-ima achic-achicyaycar shamushaj. Llapan runata Tayta Diosninchipa shiminta wiyacushanman-tupu tarichishaj. Wiyacujcunata alli cawayta tarichishaj. Mana wiyacujcunatam ichanga ñacayman jaycushaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sumaj tantiyacunquiman. Tayta Diosninchipa caćhan cashpä shamushaj llapan runata maquïćhu purichinäpaj. Waquinniquiga manaraj wañullarmi, cutimunäta ricanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaypita sujta junajta Pedruta, Santiaguta, Santiagupa wauguin Juanta pushacurcur, puntaman Jesús jigaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Puntaćhu quimsan purïshijnincunalla ricapaycaptin, achic-achicyaycajman Jesús ticracuriran. Inti-jinaraj jajllan achic-achicyäcurcuran. Müdananpis yuraj llutpiman ticracuriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Unay willacuj Moiséswan Elíaspis ricariparcur, Jesúswan parlaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaura Pedro niran: «Tayta Jesús, cayćhüga alli juyäcuymi. Munaptiqui, quimsa tacmata rurarishaj: jucta jampaj, jucta Moiséspaj, jucta Elíaspaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro rimaycaptillan, quimsanta achic-achicyaycaj pucutay chapacurcuran. Pucutay rurinpitana Tayta Diosninchi nimuran: «Jesúsga cuyay Wawämi. Shungüman tincun. Shiminta wiyacuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Rimamushanta wiyar, purïshijnincuna manchariywan pampaman llashtacaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Paycunata yataycur, Jesús niran: «Jatariy. Ama manchariychu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Niptin, ricaćhacurishanćhu quiquillantana Jesústa ricaran. Pipis mana carannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Puntapita yarpaycämushanćhu purïshijnincunata Jesús willaparan: «Tayta Diosninchi caćhamasha. Canan ricashayquita pitapis ama willapanquichu wañushäpita manaraj cawarimushäcaman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaynuy niptin, paycuna tapuran: «¿Imanirtaj Moiséspa shiminta yaćhajcuna willacun: ‹Elías shamushanpitaraj Washäcuj shamunga› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chaura Jesús niran: «Au, rasunpa Elías cutimur, runacunata anyapanga Tayta Diosninchipa shungun munashannuy cawananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Chaypis tantiyacunquiman. Elías mayna shamusha. Shamuptinsi, runacuna mana ricsij-tucur shimintapis mana ćhasquiranchu. Manchäga shungun munashallanta ruraran. Elíasta ñacachishan-jina ñacachimanga Tayta Diosninchipa caćhan caycaptïsi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chayrämi purïshijnincuna tantiyacuriran Elíaspaj rimar, Ushyachicuj Juanpaj rimaycashanta. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Puntapita yarpur runacuna juturpashanman ćhayaptin, juc runa Jesúspa ñaupanman jungurpacuycuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Tayta, llaquipämar yanapaycallämay, ari. Wamräta wañupay charin. Juyupa ñacan. Ninamanpis, yacumanpis yaparir-yaparir tunin. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Waquin purïshijniquicunata mañacurä allchacächinanpaj. Ichanga mana camäpacuranchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesúsna niran: «Jamcuna Tayta Diosninchiman mana yupachicunquichu. Juchallaćhüpis arunqui. ¿Imaycamanraj tantiyachishayqui? Mana yupachicamaptiquim, yamacashcäna.» Wamrapa papänintana niran: «Wamrayquita mä, apamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wamranta ćhayachiptin Jesús piñacuptin, wamrata supay caćhariycuran. Wamrana allchacash ricacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaypita purïshijnincuna pacayllapa Jesústa tapuran: «¿Imanirtaj nuwacuna supayta jarguyta mana camäpacushcächu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chaura Jesús niran: «¿Imanirtaj Tayta Diosninchiman mana yupachicunquichu? Sumaj tantiyacunquiman. Yangallapis yupachicurga, tagay jatun puntata ninquiman: ‹Caypita washaman witicuy.› Niptiqui, änir witicunman. Imapis sasa mana cangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Chay-niraj supayta ayünunpawan Tayta Diosninchita mañacurraj jargunqui.») ");
INSERT INTO qxhNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea quinranpa puriycashanćhu purïshijnincunata Jesús niran: «Tayta Diosninchi caćhamasha. Chaypis juc runa charimar, juyu runacunapa maquinman ćhayachimanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Paycunana wañuchimanga. Quimsa junajtam ichanga cawarimushaj.» Niptin, purïshijnincuna juyupa llaquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cafarnaún marcaman purïshijnincunawan Jesús ćhayaptin, jillayta shuntajcuna Pedruta tapuran: «Mandajniqui, ¿manachu jillayta ćhuran Tayta Diosninchipa wasinpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedruna niran: «Au. Ćhuran.» Wasiman cutir mana rimaptinraj, Jesús tapuran: «Simón Pedro, cay pachaćhu caycaj auturdäcuna, ¿pitataj jillayta ćhurachin: castancunatachu, jäpa runacunatachu?» ");
INSERT INTO qxhNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tapuptin, Pedro niran: «Jäpa runacunatam.» Jesúsna niran: «Chaura castancuna jillayta mana ćhuranchu, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ima captinpis, jillayta ćhurachij mana ullgüpämänanchipaj ćhurashun. Juclla yacuman ayway. Punta-caj piscädu charishayquipa shiminta quićharir, juc jillayta tarinquipaj. Ishcaninchipaj jillayta ćhuray.» ");
INSERT INTO qxhNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chay junajlla purïshijnincuna Jesústa tapucuran: «Tayta Diosninchipa maquinćhüga, ¿mayganïtaj mayur cayman ćhayashaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tapuptin, juc wamrata jayarcur purïshijnincunapa ćhaupinman ićhichiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jinarcur niran: «Sumaj tantiyacunquiman. Tayta Diosninchipa maquinćhu cawanayquipaj wamracuna-jina imatapis mana yarpaćhacullar cawanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cay pachaćhu wamracuna mana alli-tucushannuy cawaptiquiraj, janaj pachaćhüpis Tayta Diosninchi sumaj alli ñawinpa ricashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yupachicamashayqui-janan cay-niraj wamrata alli ricar, nuwatapis alli ñawiquipa ricarcaycämanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Wamra-jina llapan shungunwan nuwaman yupachicamajcunata juchaman janćhajcuna wañuyman ćhayachun. Jatun-caray marayta cuncanman wallgaparcur, yacu ruri-ruricaman wicaparinman. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Cay pachaćhu imanayllapapis runa juchaman ćhayan. Juchanpita ñacanga. Runa-masinta juchaman janćhacujcunam ichanga llaquipaypaj ñacanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Maquiquipis, ćhaquiquipis juchata aparicachishuptiqui muturir, wicaparinquiman. Maquiynaj, ćhaquiynaj caycar juchata mana aparicurna, Tayta Diosninchipa maquinćhu imaycamanpis cawanquipaj. Maquiyuj, ćhaquiyuj caycar juchaćhu aruptiquim ichanga, mana upij ninaman Tayta Diosninchi jaycurishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ñawiqui juchata aparicachishuptiqui ujtirir, caruman wicaparinquiman. Ñawiynaj caycar juchaćhu mana cawaycarna, Tayta Diosninchipa maquinćhu imaycamanpis cawanquipaj. Ñawiyuj caycar juchaćhu cawaptiquim ichanga, mana upij ninaman Tayta Diosninchi jaycurishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","«Pipis wamra-jina llapan shungunwan nuwaman yupachicuptin, pampaman ama ćhuranquichu. Yupachicamajcunata ricaj-anjilcuna Papänïpa ricay ñawinćhu cawarcaycan. Quiquinpa ñaupanćhümi janaj pachaćhu cawarcaycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Mä, yarpaćhacushun. Juc runapash paćhac (100) uyshan caran. Jucta ujraycur, ¿manachu waquinta juc pachaman jutuycur ujrashanta ashir purin? ");
INSERT INTO qxhNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ujrash uyshanta tariycurshi, jatunpa cushicun. Isgun ćhunca isgunwan (99) uysha captinsi ujracashta tariptin, shungunpis jatunpash cushicun. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Janaj pachaćhüpis chaynuymi. Papäniqui pipis ujracänanta mana munanchu. Llapan wawancunata llaquipan. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Maygan irmänupis juchata aparicush captin, watucunqui. Ćhayar, quiquillanta piñacunqui. Piñacushayquita wiyacuptin, allina ricanacunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana wiyacuptin, juc-ishcay irmänuta jayachinqui. Tayta Diosninchipa shiminćhüpis nin: ‹Ishcay-quimsa runa wiyaycaptin, piñacunqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Paycunata mana wiyacuptinmi ichanga, jutucaj irmänucunata willanqui. Irmänucuna piñacuptinpis mana wiyacuptinga, jargurinquiman: ‹Tayta Diosninchita mana manchapacunchu. Chiqui runa› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Sumaj tantiyacunquiman. Cay pachaćhu mana wiyacujcunata jargushayquita Tayta Diosninchipis janaj pachaćhu jargunga. Wiyacujcunata ćhasquishayquita Tayta Diosninchipis ćhasquinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ishcaniqui parlanacuriycur mañacuptiqui, Papänï sumaj yanapäshunqui imatapis ruranayquipaj. Cay pachaćhu parlanacuptiqui, janaj pachaćhüpis wiyashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ishcaj-quimsajllapis yupachicamashayqui-janan jutucaptiqui, jamcunawan caycäshaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaura Pedro tapuran: «Tayta, juc irmänu juchaćhu arur jagayächimaptin, ¿ayca cuticamantaj juchanta jungashaj? ¿Janćhis cuticamanchuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesúsna niran: «Janćhis cutillaga ama; manchäga imay-imaypis juchanta junganquiman. Janćhis ćhunca janćhiswan (77) cutipis juchanta junganquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Tayta Diosninchipa maquinćhu purichimashanchita tincuchiypa willapäshayqui. Juc jatun patrunshi capuralnincunata jayachiran. Paycunatash jayachiran jillayninta cutichinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cutichinan junaj ćhayamuptinshi, juc jaga-tucuj capuralninta jayachisha. Chay runa mana yupaysi atipaypäshi jagan caran. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cutichiyta mana camäpacuptinshi, murucuncunata patrunnin niran: ‹Jagäta cutichimänanpaj cay runata ranticuycuy. Wamrancunatapis, warmintapis, llapan imancunatapis ranticucuy. Chay jillaywanraj jagäta cutichimanga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chayshi jaga runa jungurpacuycur mañacuran: ‹Taytallau tayta, tarishäcaman shuyaycallämay, ari. Tarir, llapanta cutichilläshayqui› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mañacuptinshi, llaquipar jillayninta mana shuntarannachu. ‹Ama cutichimaynachu› nirshi caćhariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Patrunninpa wasinpita llucshirir, capural-masinwannash tincusha. Capural-masinga juc paćhacllash (100) jagan caran. Chayshi cuncanpita charircur, awicaćhärir ullgüparan: ‹¿Jagäta cutichimanquichu? ¿Manachu cutichimanquipis?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jucninnash jungurpacuycur mañacuran: ‹Ichicllata shuyaycallämay, ari. Taripacurir, llapallanta cutichilläshayqui› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jucninnash ichanga shuyayta mana munar, juclla carsilman wićhgachisha. Mana llaquipällarshi, jaganta cutichinancaman wićhgachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Waquin capural-masincunash chayta ricar, juyupa llaquiparan. Patrunninman aywarcurshi, llap-llapanta willaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Patrunninnash juyu capuralninta jayachiran: ‹Juyu canqui. Chay-chica jagä captiquisi, mañacamaptiqui: «Ama cutichimaynachu» nishcaj. Jagäta mana shuntashcänachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Llaquipashaj-jina jampis capural-masiquita llaquipanquiman caran.› ");
INSERT INTO qxhNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Patrunnin sumaj ullgüpariycurshi, carsilman wićhgachiran: ‹Llapan jagäta cutichimashancaman sumaj wascapamay› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Sumaj tantiyacunquiman. Ticshaparänacur irmänuyquipa juchanta yarparäcuptiqui, Papänïpis juchayquita yarparäcunga. Mana imaysi jungangapächu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Willapäcurir, Galilea quinranpita Judea quinranmanna Jesús aywacuran. Jordán mayu chimpanman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Achcaj runapis jipanpa aywaran. Pipis jishyaćhu caycaptin, Jesús allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Waquin fariseucunana achäquita ashipar, Jesústa tapuran: «¿Imallapitasi warminpita runa raquicänan camacanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesúsna niran: «¿Tayta Diosninchipa shiminta jungashcanquinachu? Shiminćhu nin: ‹Cay pachata, janaj pachata camar, warmitapis, ullgutapis Tayta Diosninchi ruraran.› ");
INSERT INTO qxhNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chaynuypis nin: ‹Runa warmita ashir, maman-taytanpa maquinpita llucshicunman. Warmillanwanna ujllanacärinman juc shungulla cawananpaj.› ");
INSERT INTO qxhNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ishcaj carsi, juc shungullana cawan. Chaymi Tayta Diosninchi majachacächishanta runa mana raquicächinmanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseucunana niran: «Chaynuy captin, ¿imanirtaj Moisés auniran: ‹Actaman jamaycachir warmiquiwan raquicar, jargurinquiman› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesúsna niran: «Chucru shungu car nishayqui-nishayqui rurashayquipita raquicänayquita Moisés auniran. Tayta Diosninchim ichanga runa warminwan raquicänanta imaypis mana munanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","«Jucwan jananpachishuptiquiraj, majayquita jargurinquiman; manchäga mana. Juchan mana caycaptin warmiquita jaguiriycur, juc warmitapis ama ashinquimanchu. Chayta rurar, jananpachiycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Purïshijnincunana Jesústa niran: « Warminwan runa chaynuy cawaptin, mana majachacayllaćhu jampi, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesúsna niran: «Llapan runa majanwan cawanman. Chaypis Tayta Diosninchi camacächiptin, waquin mana majananchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquinga mana majananchu chicla yurishpan, waquinna capash cashpan. Waquinmi ichanga mana majananchu Tayta Diosninchipa shiminta willapäcur puricunan cashpan. Shimïta tantiyayta atiparraj, majaynajlla cawanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Waquin runacunana Jesúsman ćhayaran: «Maquiquiwan yataycur mallwa wamräcunapaj Tayta Diosninchita mañacapamay, ari» nir. Wamracunata ćhayachijta ricarmi ichanga, purïshijnincuna piñacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesúsna niran: «Ama mićhaychu. Wamracunata apamuchun. Shacamuchun. Wamra alli shungu cawashan-jina runacunallapis Tayta Diosninchiman yupachicushpan maquinćhu cawan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wamracunapäna mañacapuran. Maquinwan yataycur niran: «Taytallau Tayta, cay wamracunata sumaj yanapaycullay» nir. Jinarcur Jesús aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juc cuti juc runa Jesúsman ćhayarcur, tapuran: «Tayta, ¿ima allitataj ruräman Tayta Diosninchipa ñaupanćhu imaycamanpis cawanäpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesúsna niran: «¿Imanirtaj allita ruranayquipaj tapumanqui? Tayta Diosnillanchim alli. Ñaupanćhu imaycamanpis cawanayquipaj paypa shiminta wiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chay runana tapuran: «¿Ima-imatataj wiyacüman?» nir. Jesúsna niran: «Ama wañuchicunquichu. Majayquita ama jananpachinquichu. Ama suwacunquichu. Runa-masiquita ama tumpanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mamayqui-taytayquita alli ricanquiman. Quiquiqui alli ricacushayqui-jina runa-masiquitapis alli ricanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chaura niran: «Chaycunata llapantam ćharcushcä. ¿Imarätaj pishïman?» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesúsna niran: «Llap-llapanta ćharcuyta munarga, llapan charashayquicunata ranticuycur pishipacujcunata aypurir, purïshimay. Chayraj Tayta Diosninchipa maquinćhu imaycamanpis cawanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chaynuy niptin, shungun ishquicäcuran. Puchuy-puchuy jananćhu cawashpan juyupa llaquish aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Purïshijnincunatana Jesús niran: «Sumaj tantiyacunquiman. Puchuy-puchuy jananćhu cawajcuna Tayta Diosninchipa maquinćhu cawananpaj sumaj sasa. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","‹Camïllu› nishan jatun-caray uywa aujapa ñawinpa yaycuyta mana jushan-jina puchuy-puchuy jananćhu cawajcunapis Tayta Diosninchipa maquinćhu cawayta mana junchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chaura chayta wiyar, purïshijnincuna mancharicäcuran: «Chaynuy captin, ¿piraj Tayta Diosninchipa ñaupanman ćhayanga?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Llapanta ricapärir Jesús niran: «Runacuna ushyacajllam. Chaymi alli cawarpis, sasächicun. Tayta Diosninchipämi ichanga imapis mana sasachu. Payga munayniyujmi pitapis ñaupanman ćhayachinanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedruna niran: «Tayta, nuwacuna llapan imäcunatapis jaguiycurmi purïshiycaj. Chayta rurashäpita, ¿imataraj ćhasquishaj?» ");
INSERT INTO qxhNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesúsna niran: «Sumaj tantiyacunquiman. Tayta Diosninchi caćhamasha. Payga cay pachata mushujman ticrachishan wichanpita-pacha llapanta mandaptï, jamcunapis mandäshimanquipaj. Israel runacuna ćhunca ishcaywan (12) casta captin, llapanta maquiquićhu purichinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nuwa-raycur imancunata jaguijcuna paćhac (100) janapaytana ćhasquinga. Paycunaga wasinta, mayurnincunata, shullcancunata, mamanta, taytanta, wawancunata, ćhacrancunata ćhasquinga. Tayta Diosninchipa ñaupanman ćhayarpis, mana ushyacaj cawaytapis taringa. ");
INSERT INTO qxhNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ima captinpis, sumaj tantiyacunquiman. Cay pachaćhu achcaj runa alli ricash captinsi, Tayta Diosninchipa ñaupanman ćhayar, mana alli ricashnachu canga. Waquincunatam ichanga Tayta Diosninchi alli ñawinpa ricanga runa-masin pampaman ćhurash captinsi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mä, tincuchiypa tantiyachishayqui. «Piyunta ashij-yupay Tayta Diosninchipis runacunata maquinman shuntan. Juc runash tuta-tutalla piyuncunata ashiran ćhacranćhu arüshinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","‹Juc jurnalta pägashayqui› nirshi llapanta aruchiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Ćhajćha inti-yupayshi ćhacrayuj runa yapay ricaćhacuj aywaran. Marcaćhu jitaraj runacunata ricarshi, ");
INSERT INTO qxhNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","niran: ‹Arüshimay. Arupacushayquipita juc jurnalta pägashayqui.› Niptin, änirshi chay runacuna arüshij aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","«Ćhacrayuj runa tarishanman-tupush piyunta aruj caćharan waquinta lasdüsi, waquintanash jatun mallway. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tacsha mallwaypis ćhacrayuj runa yapayshi marcaman aywaran. Runacuna jitarpäcuycajta tarir, tapusha: ‹¿Imanirtaj jitarpäcuycanqui? ¿Manachu aruyniqui can? ¿Juyaytachu jitarpäcunqui?› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chay runacunanash niran: ‹Pillasi mana mincacamashapishchu.› Ćhacrayuj runana niran: ‹Arüshimay. Ćhacräman ayway.› Niptin, paycunapis änirshi aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Chacarcuptinnash, capuralninta ćhacrayuj niran: ‹Piyunninchicunata jayarcur-jayarcur llapanta pägay. Jipata ćhayamujta puntata päganqui. Tutapita arujcunata ushyanantaraj päganqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Piyuncunana ćhacrayuj pägashantash ćhasquiran. Tacsha mallway aruj yaycujcunapis juc jurnaltash ćhasquiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chaynuy pägaptinshi, tutapita-pacha arujcuna achcata ćhasquiyta yarparaycaran. Chaynuy yarparcaycarsi, juc jurnaltash ćhasquiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chayllata ćhasquirshi, ćhacrayujta jagayapar niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Jipataraj ćhayamujcuna juc ćhajćhalla arusha. Juc ćhajćhalla arush caycaptin, ¿imanirtaj juc jurnaltaraj pägashcanqui? Nuwacunam ichanga rasunpa juyayta arushcä. Juyayta aruptï, shanaypis wapćhamasha. Sumaj uticashcä.› ");
INSERT INTO qxhNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Chayshi ćhacrayujna niran: ‹Tayta mishti, mana llutantachu rurashcä. Jamwan juc jurnalta päganajpaj parlashcanchi. Rimashä-jina pägashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cananga päguyquita ćhasquicurcur, aywacuyna. Shungü munaptin, jamcunata pägashä-jina junajraj aruyman yaycamujcunatapis pägayta munä. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Quiquïpa jillaynïta imatapis ruracüman, ¿au? Ama jaticämuychu. Alli shungu caycaptïpis, mallaj carcaycanqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«Canan sumaj tantiyacuy. Waquin runa pampaman ćhurash captinsi, Tayta Diosninchi alli ñawinpa ricanga. Waquincunam ichanga alli ricash captinsi, Tayta Diosninchipa ñaupanman ćhayar, mana alli ricashnachu canga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalén marcaman wichaypa aywarcaycashanćhu ćhunca ishcaywan purïshijnincunallata shuntarcur, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Jerusalén marcaman aywaycashanchita musyanqui. Tayta Diosninchi caćhamasha. Chaypis waquin runacuna mayur cüracunapa maquinman, Moiséspa shiminta yaćhajcunapa maquinman ćhayachimanga. Paycuna wañuyman jitarpamanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wañuchimänanpaj jäpa runacunapa maquinman ćhayachimanga. Ashllir ushyamanga. Juyupa wascamanga. Rusćhu wañuchimanga. Wañuchimaptinsi, quimsa junajta Tayta Diosninchi cawarachimanga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wamran Santiagutawan Juanta pushacurcur, Zebedeupa warmin Jesúsman ćhayaran. Ñaupanman jungurpacuycur, Jesústa niran: «Tayta, mañacushäta aunimay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesúsna tapuran: «¿Imaćhütaj yanapäshayqui?» nir. Tapuptin, niran: «Tayta, mayur mandaj cayman ćhayar, wamräcunatapis mandäshishunayquipaj ćhurapaycamanqui, ari. Jucninta dirïcha-caj läduyquiman jamachiy; jucnintana isquirda-caj läduyquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wamrancunatana Jesús niran: «Imata mañacaycämashayquitapis mana musyanquichu. Tapushayqui. Nuwata-jina juyupa ñacarcachir imamanpis ćhayachishuptiqui, ¿ićhipunquimanchuraj?» nir. Paycunana niran: «Au. Ićhipushämi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesúsna niran: «Rasunpa ñacashä-jina ñacanquipaj. Mandäshimänayquipaj ćhuranajmi ichanga mana camacanchu. Chayga Papänïpa maquinćhu caycan. Paymi quiquin acracushanta dirïcha-caj lädümanpis, isquirda-caj lädümanpis jamachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Santiaguwan Juan mañacushanta wiyar, ćhuncaj purïshij-masincuna ullgucaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chaura llapanta jayaycur, Jesús niran: «Jäpa runacuna juc-niraj cawashanta musyanqui. Paycuna Tayta Diosninchita mana manchapacunchu. Mandajnincunapis ullgurcur-ullgurcur, nishan-nishan marca-masincunata imatapis rurachin. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","«Jamcunam ichanga chaynuy ama canquimanchu. Munayniyuj cayta munar, llapantaraj yanapanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mandaj cayta munar, llapanpa manduntaraj ruranquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tayta Diosninchi caćhamasha. Chaypis mana munayniyuj cayta ashirchu shamushcä; manchäga pï-maytapis yanapänäpaj. Tayta Diosninchipa maquinćhu cawananpaj cawaynïpa ćhaninwan may-may runata jishpichishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó marcapita Jesús aywacuptin, achcaj runa jipanta aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jesús aywaycashanta wiyar, caminu wajtallanćhu jamarpaj ishcaj japracunapis jayacuran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Runacunana ullgüparan: «Upälla» nir. Chaypis callpacuycurraj japracuna jayacuycaran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chaynuy jayacuptin, Jesús ićhicuycuran. Nircur japracunata jayarcur, tapuran: «¿Imallaćhütaj yanapäshayqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Japracunana niran: «Tayta, ñawï ricananta munä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Japracunata llaquipar, Jesús ñawincunata yataycuran. Yataycuptin, ñawin quićhacäcuran. Ricashpan Jesústana purïshiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén marcaman mana ćhayallar, Betfagé marcamanna purïshijnincunawan Jesús ćhayaran. Betfagé marca Ulïbus punta ćhaquinćhu caycaran. Ishcaj purïshijnincunata caćharna, ");
INSERT INTO qxhNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jesús niran: «Wac chimpa tacsha marcaman aywariycuy. Ćhayar, mallwayuj büruta tarinquipaj. Watarashanpita pascarir, apacamunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","«Pascaycaptiqui pipis mićhäshuptiqui, ninqui: ‹Mandamajnïtash mañanqui. Cutirachipamushayqui.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Llapantapis ruraran juc willacujpa shimin ćharcucänanpaj. Willacujga unay niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Jerusalén marca runacunata ninqui: ‹Mä, ricay. Mandajniqui shaycämun. Lluta runa-jina bürun muntash shaycämun. Manta bürun muntash shaycämun.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chaura Jesúspa shiminta wiyacur, purïshijnincuna llapanta ruraran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wawantinta büruta Jesúsman aparan. Jacuncunata shawaparcur, Jesústa muntachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bürun muntash Jesús aywaycaptin, runacuna cushicuywan jacuncunatapis, jaćhapa rämancunatapis caminuman mashtapuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesúspa jipanta, ñaupanta aywajcunapis cushicushpan japarpararan: «Taytallau Tayta, washaycallämay, ari. Unay mandaj Davidpa willcanta washaycullächun. Tayta Diosninchi caćhamushan runa alli ricash caycullächun. Janaj pachaćhu cawaj Tayta Diosninchita alliman ćhurayculläshun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jinan Jerusalén marcaman ćhayaptin, runacuna wichaypa-uraypa rimacullaran: «¿Piraj cay runa?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesúswan purijcunam ichanga niran: «Cay runa willacuj Jesúsmi. Galilea quinran Nazaret marcapita shamusha. Tayta Diosninchipa shimintam willapäcun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tayta Diosninchipa wasinpa sawanninman yaycurirna, ranticujcunatapis, rantipacujcunatapis Jesús jarguriran. Jillay rucapacuj runacunapa mïsancunatapis sajtar ushyariran. Jillaynintapis mashtar ushyariran. Paluma ranticujcunapa jamacunancunatapis wicapar ushyariran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Llapanta wicapar niran: «Tayta Diosninchipa shiminćhu nin: ‹Wasïga mañacamajcunallapämi.› Jamcunam ichanga suwapa maćhayninman ticrachishcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tayta Diosninchipa wasillanćhu caycaptin, japracunawan wijrucuna Jesústa ćhayapuran. Payga llapanta allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tayta Diosninchi camacächiyninpa runacuna imaypis mana ricashancunata Jesús ruraptin, wamracunapis cushicushpan niran: «Unay mandaj Davidpa willcan alli ricash caycullächun.» Jesústa alliman ćhuraptin, mayur cüracunawan Moiséspa shiminta yaćhajcuna ullgucaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ullgur, Jesústa tapuran: «¿Wamracuna imata rimashantapis manachu wiyanqui?» nir. Jesúsna niran: «Au, wiyashcä. Jamcunapis wiyamay. Tayta Diosninchipa shiminta liguishcanqui, ¿au? Isquirbirächishanćhu nuwapaj rimar nin: ‹Sinćhi wamracunapis, chuchućhu waguiraj wamracunapis alliman ćhurananta quiquin Tayta Diosninchi camacächisha.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Paycunata jaguiycur Betania marcamanna Jesús pachacuj aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Warannin tuta Jerusalén marcaman Jesús cutiptin, yargay chariran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Caminu lädunćhu jïgus yürata ricar, wayuyninta ashij aywaran. Ćhayar, wayuyninta mana tariranchu. Üjallanta tariran. Chaymi jïgus yürata niran: «Cananpita mana imaypis wayunquipänachu.» Niptin, chaquicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chaquicäcujta ricar, purïshijnincuna mancharicäcuran: «¿Imanirraj yüra juclla chaquicäcusha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesúsna niran: «Sumaj tantiyacunquiman. Mana llutäpacullar Tayta Diosninchiman yupachicur, mana jïgus yürallatachu chaquichinquipaj. Manchäga puntacunatasi yacu püsuman witirachinquipaj. Llapanta camäpacunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Llapan shunguyquiwan Tayta Diosninchita mañacur, ćhasquinquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chaypita Tayta Diosninchipa wasinman yaycurir, Jesús willapäcuran. Mayur cüracunawan mayur runacuna Jesústa tapuran: «Tayta, ¿pitaj caćhamushcashunqui? ¿Pipa munayninwantaj imacunatapis ruraycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesúsna niran: «Nuwapis mä, tapucushayqui. Willamaptiqui, pï caćhamashantapis willashayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juanta ushyachicunanpaj, ¿pitaj caćhamusha: Tayta Diosninchichu, runa-masillanchu? Mä, willamay.» Chaura quiquin-pura parlanacäriran: « ‹Tayta Diosninchi caćhamusha› niptinchi: ‹¿Imanirtaj mana wiyacushcanquichu?› nimäshun. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‹Runa-masinchicunalla caćhamusha› niptinchi, runacuna wañuchimäshun.» Runacuna Ushyachicuj Juanta ćhasquicush caran: «Tayta Diosninchipa willacujninmi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaymi Jesústa niran: «Tapumashayquita mana musyächu.» Chaura Jesúspis niran: «Mana camäpacuptiqui, nuwapis pï caćhamashanta mana willashayquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jananmanpis: «Mä, tapushayqui» nir tincuchiypa willapar, Jesús niran: «Juc runapash ishcay wamran caran. Jichpa wamrantash niran: ‹Wawallau, canan junaj übasta uryamuy.› ");
INSERT INTO qxhNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wamrannash niran: ‹Mana aywashäpächu.› ‹Mana aywashäpächu› nirpis yarpaćhacurirshi, aruj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Shullca wamrantapis arujshi caćharan. Caćhaptin, jucllash auniran. Chaypis manash aywaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","«Canan mä, tapushayqui. ¿Maygan wamrantaj papäninpa shiminta ćharcusha?» Niptin: «Jichpa wamran» nipäcuran. Jesúsna niran: «Sumaj tantiyacunquiman. ‹Chiqui runacunapis, wayrapacuj warmicunapis juchallaćhu arun. Mana imaysi Tayta Diosninchipa maquinćhu juyangachu› nirpis llutanta yarpaycanqui. Yarpaćhacurirga, Tayta Diosninchipa maquinćhu cawanga; jamcunam ichanga mana. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ushyachicuj Juan: ‹Tayta Diosninchipa shiminta wiyacuy› nir willapäshuptiquisi, mana wiyacushcanquichu. Juchayquipita mana wanacushcanquichu. Chiqui runacunawan wayrapacuj warmicunam ichanga wiyacusha. Juchanpita wanacushanta ricaycarsi, mana yarpaćhacushcanquichu. Tayta Diosninchipa shiminta mana ćhasquicushcanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yapay tincuchiypa willapäcur, Jesús niran: «Juc ćhacrayuj runash übasta mururan. Ushyaypash pirgaran. Übasta japchinanpäpis püsutash ruraran. Ćhacranta täpananpänash türi wasita pirgachiran. Jinarcur ćhacra runacunata allimshaycurshi, juclä marcapa aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Übas pallay ćhayamuptin, uywaynincunatash caćhacuran: ‹Dirïchüta shuntamuy› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Caćhancuna ćhayaptinshi, allimshacuj runacuna juc caćhanta magaran. Juctanash wañuycachiran. Juctanash sajmar ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaura ćhacrayuj juc uywaynincunatanash caćhacuran. Chaynuyllash paycunatapis allimshacujcuna ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chayshi ćhacrayuj quiquinpa wamranta caćhacuran: ‹Quiquïpa wamräta manchapacungam› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ćhacrayujpa wamranta ricarshi ichanga, allimshacujcuna quiquin-puralla parlanacäriran: ‹Papänin tagay wamrallanpaj llapan imancunatapis jaguipaycunga. Chaymi wañurachishun. Chaura cay ćhacra nuwanchipaj canga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chaynuy nirshi, ćhacrayujpa wamranta charipäcuran. Ćhacranpita jargurcurshi, wañuycachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Canan mä, willamay. Ćhacrayuj cutimur, ¿imataraj ruranga chay ćhacra runacunata?» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Paycunana niran: «Chay ćhacra runacunata mana llaquipällar wañurachinga. Ćhacranta alli runacunatana allimshaycunga. Allimshaycunga ćhacrapa wawanta cutichijcunallata.» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesúsna niran: «¿Tayta Diosninchipa shiminta manachu liguishcanqui? Shiminćhu niycan: ‹Wasi rurajcuna: «Cay rumi mana allichu» nir wicapashantapis Tayta Diosninchi simintuta jallarachinanpaj ćhurasha. Chayta quiquin Tayta Diosninchi camacächisha. Chaypita cushicurcaycanchi.› ");
INSERT INTO qxhNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","«Sumaj tantiyacunquiman. Mana wiyacuptiqui, Tayta Diosninchipis caćhariycushunquipaj. Wiyacuj runacunatam ichanga maquinćhu purichinga. Wiyacujcunaga Tayta Diosninchipa shungun munashanta ruranga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Fariseucunawan mayur cüracuna wiyächipaycashanta tantiyacuriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaura juclla Jesústa chariyta munaran. Ichanga achcaj runa juturaptin, mancharishpan mana chariranchu. Runacuna Jesústa ćhasquicuran: «Tayta Diosninchipa willacujnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yapay imawanpis tincuchiyllapa willapäcur, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«¿Imanuytaj maquinćhu Tayta Diosninchi cawachimäshun? Mä, tantiyacushun. Juc mandaj runapa ullgu wamran majachacaptinshi, sumaj camaricuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jinarcurshi sirbintincunata caćhacuran: ‹Jayachishä runacuna micuj shamuchunna› nirshi. Tünaman jayaycächiptinsi, manash aywaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Mana aywaptinshi, yapay waquin sirbintincunata caćhacur niran: ‹Jayachishä runacunata shamunanpaj willanqui: «Micupacärinayquipäshi aywanqui. Camaricushallanash caycan. Allinnin türucunatapis, wanllannin wäcacunatapis pishtashana. Jucllash majachacay tünaman aywanqui» nir.› ");
INSERT INTO qxhNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jayachishan runacunash ichanga upa-tucäriran. Waquinnash ćhacraman aruj aywacuran. Waquinnash rantipacuj aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquinnash mandaj runapa sirbintincunata ashllir ushyaran. Wañuycachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Chayshi mandaj runa juyupa ullgucäcuran. Murucuncunatanash caćharan: ‹Wañuchicujcunata wañurachimuy. Marcantapis rupachiypa ushyariy› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jinarcurnash, juc sirbintincunata niran: ‹Wamrä majachacänanpaj micuy mayna ćhayash caycan. Jayachimushäcunatam ichanga upa-tucushanpita mana jayachimümanchu caran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cananga lluta runacuna cashan-cajman ayway. Tincushayqui runata jayachimuy majachacay tünaman shamunanpaj.› ");
INSERT INTO qxhNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chayshi sirbintincuna ćhaquin ćhayashanpa aywacäriran. Tincushan runatash allicunatapis, juyucunatapis micupacuj pusharan. Wasi juntash runacunana jutucaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Tünaman ćhayajcunata ricananpäshi quiquin mandaj runa yaycuriran. Yaycuriptin, juc runash mana rucacullar jamaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chayshi tapuriran: ‹Tayta mishti, ¿imanaypataj majachacay tünaman rucacünilla yaycamushcanqui?› nirshi. Tapuptin, imata niytapis manash camäpacuranchu. Upällash cacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chayshi sirbintincunata niran: ‹Maquin-ćhaquinta mancurnarcur wajtaman wicapay. Chacajman jaycuriy. Chayćhu atayparaj waganga. Juyupa ñacar, quiruntapis ućhunga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«Canan tantiyachishayqui. Tayta Diosninchi llapan runata jayachin. Chaypis acracushancunallatam maquinćhu purichinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaypita fariseucuna parlanacuran Jesústa achäquita ashipänanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chaymi fariseu-masincunatawan, mandaj Herodespa purïshijnincunata Jesúsman caćharan. Paycuna Jesústa tapuran: «Tayta, alli shungu cashayquita musyä. Pitapis Tayta Diosninchipa shimillanta willapanqui. Llapan runata alli ricanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chaymi tapucushayqui. ¿Mandaj Césarpaj jillayta ćhurashuwanchuraj, manachuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesúsmi ichanga achäquita ashipaycashanta musyar niran: «Janan shungulla runacuna, ¿imanirtaj maquichacamayta munanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mandajta pägashayqui jillayta mä, ricachimay.» Chaura jillayta apapuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesúsna tapuran: «¿Pipa liträtunta jillayćhu caycan? ¿Pipa jutinta isquirbiraycan?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Paycunana niran: «Mandaj Césarpa.» Jesúsna niran: «Mandaj Césarpata Césarpaj ćhuray. Tayta Diosninchipata Tayta Diosninchipaj ćhuray.» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Niptin, ima rimapacuytapis mana camäpacuranchu. Upällallana aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay junajlla saduceu runacunapis Jesúsman ćhayaran. Paycuna yarpaj: «Wañushcuna mana cawaringapächu» nir. Chaymi niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Tayta Jesús, isquirbishanćhu Moisés niran: ‹Runa wañucur warminta wawaynajllata jaguiptin, wañucuj runapa wauguillan biyüdawan majachacanman. Mushuj majanwan tarishan wamrata wañucuj runanpa jutinta apanga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Canan mä, tapucushayqui. Janćhis wauguish caran. Juc wauguish warmiwan majachacaran. Ichanga warminta mana mirachillarshi wañucuran. Wañuptin, juc-caj wauguinnash biyüdawan majachacaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Juc warmillawan majachacarcur-majachacarcur, chay janćhis waugui wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Llapan wañushanpa jipantaräshi warmipis wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","«Tayta, mä, willamay. Wañushanpita cawarcamur, chay warmi, ¿maygan wauguipa warmintaj canga janćhiswan majachacash caycar? ¿Llapanpachuraj warmin canga?» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesúsna niran: «Jamcuna llutanta yarparcaycanqui. Tayta Diosninchipa shimintapis, munayniyuj cashantapis mana tantiyanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cawarimuj runacuna warmi ullgupis mana majachacanganachu. Manchäga janaj pachaćhu anjilcuna-jina cawangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wañushcuna cawarimunanta mayna Tayta Diosninchi musyachicuran. ¿Manachu shiminta liguishcanqui? Shiminćhu nin: ");
INSERT INTO qxhNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Unay auquilluyqui Abraham, Isaac, Jacob wañush carsi, cawaycan. Tayta Diosnin caycaptï, manchapacaycäman.› Cawaycajcunalla Tayta Diosninchita manchapacun; wañushcuna mana.» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chaura Jesúspa shiminta wiyar, runacuna jatunpa cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceucunata upällachishanta mayaycur, fariseu runacuna jutucaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Moiséspa shiminta yaćhajnin fariseucunana achäquita ashipashpan Jesústa tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Tayta, Moisés isquirbishan llapan yaćhachicuycunapita, ¿maygantaj allicaj yaćhachicuy?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesúsna niran: « ‹Llapan shunguyquiwan Tayta Diosninchita manchapacäriy.› ");
INSERT INTO qxhNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Caymi llapan yaćhachicuycunapita mas allicaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Juc-cajpis chay-nirajlla. ‹Quiquiqui alli ricacushayqui-jina runa-masiquitapis alli ricanquiman.› ");
INSERT INTO qxhNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ishcan yaćhachicuycunata ćharcurga, Tayta Diosninchipa shimintapis, willacujcunapa shimintapis llapantana ćharcuycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseucuna juturaycaptin, Jesús tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«¿Pipa willcanraj Washäcuj canga?» nir. Paycunana niran: «Unay mandajninchi Davidpa willcallanmi.» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Jesúsna niran: «Salmos librućhu nin: ‹Espíritu Santu rimachiptin, quiquin mandaj David niran: «Tayta Diosninchi Washäcujnïta nisha: ‹Mandäshimänayquipaj dirïcha-caj lädüman jamacuy cunćharyuyquicunata pampaman ćhuranäcaman. Nishayqui-nishayqui munashayquita rurachinquipaj.› » › ");
INSERT INTO qxhNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Chaynuy niycaptin, ¿Washäcujga rasunpachuraj Davidpa willcallan canga? ¿Runapa wamranchuraj canga? Au, paypitam. Chaypis quiquin mandaj David manchapacur, Taytachacuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesús tapuptin, pipis mana rimacuranchu. Chay junajpita-pacha pipis mana tapuparannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaypita juturaj runacunatapis, purïshijnincunatapis willapar, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Fariseucunawan Moiséspa shiminta yaćhajcuna Moisés-jina yaćhaj ricarin. Shiminta sumaj yaćhachicun. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chaymi willapäcushanta wiyacunquiman. Llupinpam ichanga ama jatinquichu. Paycunaga ishcay cäram. Allita rimarsi, shiminta mana ćharcunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Runacunata tucuy-tucuyta yaćhachin. Ćharcunan sasacunatapis yaćhachin. Quiquincunam ichanga juc maquillasi mana yanaparcunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Runa ricanallanpämi Tayta Diosninchipa shiminta jatun-jatunta isquirbircur, ricranman, urcunman watacun. Jacunpa puntanćhu jatusaj-jatusaj waytashcunata watacun runacuna: ‹Tayta Diosninchita sumaj manchapacun, ¿au?› nir ninanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","«Micupacuj jayachiptinpis, allillata jarananta ashin. Shuntacäna wasiman aywarpis, ñaupa-ñaupallaćhu jamayta ashin. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Läsacunaćhüpis llapan runa manchapacunallanta munan. ‹Taytallau tayta, yaćhajmi canqui› ninallanta ashin. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Paycuna-jinam ichanga ama canquimanchu. ‹Taytallau tayta› nir manchapacushushayqui mana camacanchu. Manchäga juc taytallapita car, payllata manchapacunquiman. Juc shungulla cawanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cay pachaćhu pitapis ama taytachacunquimanchu. Manchäga janaj pachaćhu cawaj Tayta Diosnillanchita taytachacunquiman. Payllam Taytayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chaynuypis pitapis ama taytachacunquichu: ‹Jamlla yaćhaj canqui› nir. Washäcuj canäpaj Tayta Diosninchi caćhamash captin, nuwallata taytachacamanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Alli ricash cayta munar, runa-masiquitaraj sumaj yanapanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sumaj tantiyacunquiman. Alli-tucujcunata Tayta Diosninchi pampaman ćhuranga. Maquinćhu cawajcunatam ichanga alliman ćhuranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Moiséspa shiminta yaćhajcuna, fariseucuna, ishcay cära canqui. Llaquicärinquiman. Juyupa ñacanquipaj. Yaćhaj carsi, Tayta Diosninchita mana manchapacunquichu. Shimintapis runa-masiquicunata mana yaćhachinquichu. Manchäga Tayta Diosninchipa shungun munashannuy cawayta munarcaycaptin, mićharcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Moiséspa shiminta yaćhajcuna, fariseucuna, ishcay cära canqui. Llaquicärinquiman. Juyupa ñacanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","May-chayman ćhayarpis aunishunayquita munallar, tucuyta ruranqui: ‹Moiséspa shiminta yaćhajcunawan fariseucuna yarpashannuylla cawashun› nir. Runa aunircushuptiqui, supaypa jipanpana janćhanqui. Juyu caycaptiquisi, paycunapa juyu cayninman mana tincunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","«Yaćhajcuna, fariseucuna, japra-yupay canqui. Llaquicärinquiman. Juyupa ñacanquipaj. Upa cayniquiwan imatapis mana tantiyashpayqui waquincunata tantiyachiycanqui. Chaymi ninqui: ‹Tayta Diosninchipa wasinćhu ćhurashanchi cuyachicuyninchicuna manchapacuypaj. Chaymi shiminchi ćharcucänanpaj camacächinga. Tayta Diosninchipa wasinmi ichanga mana manchapacuypächu. Shiminchi ćharcucänantapis mana camacächingachu.› Upa runa carcaycanqui. ¿Manachu musyanqui cuyachicuyninchicuna Tayta Diosninchipa wasinćhüraj manchapacuypaj cashanta? ");
INSERT INTO qxhNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","19","Chaynuypis ninqui: ‹Tayta Diosninchita jarashanchicuna manchapacuypaj. Chaymi shiminchi ćharcucänanpaj camacächinga. Tayta Diosninchita jarananchi tullpam ichanga mana manchapacuypächu. Shiminchi ćharcucänantapis mana camacächingachu.› Upa runa canqui. ¿Manachu musyanqui jarayninchipis Tayta Diosninchipa tullpanćhüraj manchapacuypaj cashanta? Payga ishcanta alli rican. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sumaj tantiyacunquiman. Pipis: ‹Shimïta ćharcucächinanpaj Tayta Diosninchita jarananchi tullpa manchapacuypämi› nirga, tullpatapis jarayninchita manchapacuycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pipis: ‹Shimïta ćharcucächinanpaj Tayta Diosninchipa wasin manchapacuypämi› nirga wasintinta Tayta Diosninchitapis manchapacuycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pipis: ‹Shimïta ćharcucächinanpaj janaj pacha manchapacuypämi› nirga munayniyuj Tayta Diosninchitapis manchapacuycan. Payga janaj pachapita llapan runata maquinćhu puriycächin. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Moiséspa shiminta yaćhajcuna, fariseucuna, ishcay cära canqui. Llaquicärinquiman. Juyupa ñacanquipaj. Alli ricash cayta munar, llapan imayquicunapitapis Tayta Diosninchipaj raquinqui. Irbabuynatasi, añistasi, cuminustasi raquinqui. Chaypis Tayta Diosninchipa shiminta mana llapan shunguyquiwanchu ćharcuycanqui. Mana paypa shungun munashannuyllachu cawaycanqui. Runa-masiquitapis mana llaquipanquichu. Tayta Diosninchitapis mana manchapacunquichu. Paypa-cajta raquir, allita rurarcaycanqui. Ichanga imatapis allillata ruranquiman. Shiminta sumaj-sumaj ćharcunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","«Yaćhaj carpis, upa canqui. Runa ricanallanpaj alli-tucunqui. Tayta Diosninchipa ricay ñawinćhümi ichanga juchaćhu aruycanqui. Yacuta upunayquipaj acapalla chuspita jurgurpis, ‹camïllu› nishan jatun-caray uywantinta upurcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Moiséspa shiminta yaćhajcuna, fariseucuna, ishcay cära canqui. Llaquicärinquiman. Juyupa ñacanquipaj. Mati janallan mayllash-niraj carcaycanqui. Runapa ricay ñawinćhu juchaynaj-tucursi, juchaćhu arunqui. Mallaj caycar, suwacuyllaćhu arunqui. Shunguyqui munashallanta ashir purinqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Upacuna, Tayta Diosninchi shunguyquita musyapan. Shiminta wiyacunquiman. Wiyacuptiqui, runacunapis allina ricashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Moiséspa shiminta yaćhajcuna, fariseucuna, ishcay cära canqui. Llaquicärinquiman. Juyupa ñacanquipaj. Mïchu-niraj canqui. Jananpita ricaptinchi, cuyayllapaj mïchu. Rurinćhümi ichanga millanaypaj ayapa tulluncuna ismuycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chay-niraj canqui. Runa ricashunallayquipaj alli-tucunqui. Tayta Diosninchipa shimintam ichanga wiyaytapis mana munanquichu. Jucha aparicuyllata shunguyqui yarparaycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Moiséspa shiminta yaćhajcuna, fariseucuna, ishcay cära canqui. Llaquicärinquiman. Juyupa ñacanquipaj. Tayta Diosninchita manchapacujcunapa, unay willacujnincunapa mïchuncunata yapay rurarcaycanqui. Yarparänayquipaj, cuyayllapaj cananpaj picharcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jananmanpis ninquiraj: ‹Auquillunchicuna cawashan wichan cawarga, willacujcunata mana wañuchishuwanchu caran.› ");
INSERT INTO qxhNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chaypis wañuchicujcunapa wawan cashayquita shimillayqui musyachicuycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mïchunta pichar: ‹Auquillücuna willacujcunata wañuchir, allita rurasha› nir rurarcaycanqui. Cananpis yaćhachishushayquinuylla mä, ruray. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Supaypa wawan car, wañuchicuj curu-jina canqui. Chaymi Tayta Diosninchi ninaman jaycushunquipaj. Chacaj pachapita jishpiyta mana camäpacunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sumaj tantiyacunquiman. Tayta Diosninchipa shiminta willapäcunanpaj achcajtam caćhamushaj. Willacujcunatapis, yaćhachicujcunatapis, Moiséspa shiminta yaćhajcunatapis caćhamushaj. Jamcunam ichanga waquinta rusćhüraj wañuchinquipaj. Waquintana shuntacäna wasicunaćhu wascar ushyanquipaj. Waquintana marcan-marcan jaticaćhar ushyanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","«Tayta Diosninchipa shiminta wiyacujcunata wañuchicur, auquilluyquicuna wañuchicushantapis aparicunquipaj. Juchanta aparicunquipaj wiyacuj Abelta wañuchishanpita-pacha Baraquíaspa wamran Zacaríasta wañuchishancaman. Payta Tayta Diosninchipa wasi puncunćhu, tullpa wajtallanćhu wañuchishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sumaj tantiyacunquiman. Auquilluyquicuna wañuchishanpita jamcunatana Tayta Diosninchi ñacachishunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén marca runacunata llaquipar, Jesús niran: «Jerusalénllau Jerusalén, ¿imanirtaj Tayta Diosninchipa willacujnincunata wañuchinqui? ¿Imanirtaj caćhancunata sajmar ushyanqui? Chipsancunata maman ujllananpaj shuntashan-jina shuntayta munashcaj. Munaptïsi, wasguipämashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chay-niraj cashayquipita marcayquipis ragäman ticranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nuwatapis mana ricamanquipänachu. ‹Tayta Diosninchi caćhamushan runa alli ricash caycullächun› nir ćhasquicamashpayquim ichanga, imayllapis ricamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tayta Diosninchipa wasinpita Jesús llucshiycaptin, purïshijnincuna niran: «Tayta, mä, ricay. Achic-achicyaycaj rumicunawan Tayta Diosninchipa wasinta pirgasha. Sumaj cuyayllapaj, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesúsna niran: «Au, llapanta ricaycanchi. Chaypis sumaj tantiyacunquiman. Imayllaga llapan ricashayqui ushyacanga. Rumiwan pirgararsi, llapanmi jućhurachish canga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chaypita Ulïbus puntaćhu Jesús jamaraycaptin, purïshijnincuna rinrillanćhu tapuran: «Tayta, ¿imaytaj Tayta Diosninchipa wasinta jućhurachinga? ¿Imanaypataj shimiqui ćharcucänantapis, cay pacha ushyacänantapis musyashaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesúsna niran: «Pipis pantachishurunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Achcaj pantachicujcuna shamunga: ‹Tayta Diosninchi caćhamushan Washäcujmi cä› nir. Achcaj ćhasquicamajta pantachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wacćhu-cayćhu wañuchinacuy jatariptinpis, ama mancharinquichu. Chaycunaraj cangapaj. Chaypis cay pacha mana ushyacangarächu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cay pacha ushyacänanpäga marcan-marcan wañuchinacungapaj. Mućhuy captinpis, yargaywan runacuna wañunga. Chay-tucuyćhüpis pacha juyupa sicsicyanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Chaypis runacuna mana ushyacangarächu. Manchäga ñacayllarämi jallaringa. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ćhasquicamashayqui-janan juyu runacunapa maquinman ćhayachishunquipaj. Ñacachishunquipaj. Wañuchishunquipaj. Llapan runa chiquishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Achcaj runa: ‹Jesúspa shiminta ćhasquicushcä› nirpis, wasguimanga. Quiquin-puralla wañuymanpis jitarpanacunga. Chiquipänacunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","«Juchallaćhu arujcuna jataringa: ‹Tayta Diosninchipa shiminta willacü› nir. Achcajta pantachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Runacunana Tayta Diosninchipa shiminta wiyayta mana munar, juyuyanga. Mana llaquipänacunganachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ima captinpis, jipaman ama cutiricunquichu. Mana yamacällar shimïta wiyacuptiqui, imaycamanpis maquinćhu Tayta Diosninchi cawachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","May-chayćhüpis llapan runata shimï willapäcush canga: ‹Tayta Diosninchi maquinćhümi llapan runata cawachiyta munan. Alli willapäta wiyaptinraj, cay pacha ushyacänan ćhayamunga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Willacuj Danielpa shiminta sumaj tantiyacärinquiman. Payga unayna niran: ‹Chiqui runacuna yaycapur, Tayta Diosninchita wasintinta pampaman ćhuranga. Manchapacushantapis ićhichinga.› Millanaypaj rurashancunata ricar, ");
INSERT INTO qxhNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","juclla jishpicärinquiman. Judea quinranćhu tiyajcuna puntacunaman jishpicärinman. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasi puncućhu caycar, ruriman ama yaycunquimanchu. Imayquicunatapis ama jurgunquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ćhacrapitapis wasiquiman ama cutinquimanchu. Müdanayquita ama shuntanquimanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Ñacachishan wichan jishyaj warmicunapis, pishi wamrayujcunapis cuyapaypaj ñacanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chaymi jishpinayqui junaj tamya wichanman mana ćhayananpaj, diyawardaman mana ćhayananpaj Tayta Diosninchita mañacäriy. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay wichan juyupa ñacay canga. Chaynuy ñacay imaypis mana caranchu Tayta Diosninchi cay pachata camashanpita-pacha. Chaynuypis yapay mana imaysi cangapänachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wamrachacushancunata llaquipar, Tayta Diosninchi chay ñacay junajcunata wallcayächinga. Manchäga pipis mana wañuypita jishpinmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Chaymi pipis: ‹Mä, ricay. Tayta Diosninchi caćhamushan Washäcujninchi shamusha. Ćhayaycämun› nir nishuptiquisi, ama ćhasquipanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chay wichan Washäcuj-tucujcuna, willacuj-tucujcuna ricarimungapaj. Munayniyuj car, tucuyta ruranga runacunata riguichinanpaj. Imaysi runa mana ricashancunatapis ruranga. Chayta rurar, Tayta Diosninchi acracushan runacunatapis waquinta pantachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Canan sumaj tantiyacunquiman. Willapänajpaj cashanta mayna willapashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Chaymi: ‹Washäcujninchi chunyajćhu caycan› nishuptiqui, ama aywanquichu. ‹Wasi rurićhümi Washäcujninchi pacaraycan› nishuptiquipis, ama ćhasquipanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","«Tayta Diosninchi caćhamasha. Cutimuptïga, illaguta llapan ricashan-jina llap-llapanmi ricamanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rimaypis purin. ‹Siucacunash micunanta ricar, maymanpis jutucan.› Cutimushätapis llapan runa mayanga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Juyupa ñacaycuna ćhawarcuptillan, ‹Inti wañucäcunga. Quillapis mana achicyämunganachu. Istrïllacunapis shicwamunga. Janaj pachapis juyupa tapsinga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Chaypitaraj cutimunäta mayanquipaj. Llapan runa mancharir, waganga. Chay junaj Tayta Diosninchi caćhamaptin, munayniyuj car, pucutay jananćhu achic-achicyaycar cutiycämujta ricamanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","«Tayta Diosninchina anjilcunata caćhamunga. Paycunana curnïtanta sumaj suynachimur, chay-tucuypita Tayta Diosninchi acracushan runacunata shuntamunga. Janaj pachapa cantunpita juc-caj cantuncaman shuntamunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Jïgus yürawan tincuchiypa tantiyacushun. Yüran chillguiptin, tamya quilla jallaycunanta musyanchi. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chay-jina llapan willapashäcuna ćharcuptin, cutimunä caycashanta tantiyacärinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sumaj tantiyacunquiman. Waquinniquipa ricay ñawiquićhu llapan ćharcucanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Janaj pachapis, cay pachapis ushyacanga. Shimïmi ichanga mana jungacangachu. Llapanmi ćharcucanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Cutimunä junajta Tayta Diosninchi pitapis mana musyachishachu. Anjilnincunatapis, nuwatapis mana musyachimashachu. Quiquin Taytallanchim musyaraycan. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","«Sumaj tantiyacunquiman. Tayta Diosninchi caćhamasha. Yapay caćhamänan wichanga Noé cawashan wichan-jina runacuna cawarcaycangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noé cawashan wichan lücu tamya mana jallarishancaman runacuna cawashanwan cawacurcaycaran. Jauca micucuran. Upucuran. Waquinga majachacaycaran. Bütiman Noé jigacurcuptinmi ichanga, lücu tamya jallacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chaycaman runacuna imatapis mana yarpaćhacullar cawaran. Yacu ćhayar jananćhu ricacuptin llapan wañur, ushyacayman ćhayaran. Chay-jina Tayta Diosninchi caćhamaptin, cutimushä wichanpis runacuna cawashanwan cawarcaycangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Cutimunä junaj ishcaj runa ćhacraćhu arurcaycaptin, juc-cajllata shuntacushaj. Jucnintam ichanga jaguiycushaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ishcaj warmi agacurcaycaptinpis, juc-cajllata shuntacushaj. Jucnintam ichanga jaguiycushaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Chaymi ricchaycar imaypis cawanquiman. Nuwam Taytayqui caycä. Imay üra cutimunätapis mana musyanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sumaj tantiyacunquiman. Wasiman suwa yaycunanta musyar, wasiyuj mana puñucunmanchu. Manchäga suwa suwapänanpita ricchaycar waranman. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chaymi jamcunapis mayaj-mayajlla shuyarpaycämanquiman. Tayta Diosninchipa caćhan cashpä mana yarpashpita cutimushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Mä, sumaj tantiyacunquiman. ¿Mayganiquiraj alli mincayman, tantiyacuj mincayman tincunquiman? Mincay alli captin, tantiyacuj captin, capural cananpäshi wasiyuj ćhuranga. Capuralga mincay-masincunata sumajshi rican. Jaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Capuralninpa shiminta ćharcuptin wasiyuj cutimur, allipash ricanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sumaj tantiyacunquiman. Allita rurashanpita, capuralpa maquinmanna llapanta ćhuranga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Juyu capuralshi ichanga shungullanćhu yarpaćhacunman: ‹Wasiyuj mana cutimungarächu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chayshi mincay-masincunata magar ushyan. Micur, upyallar juyan. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wasiyuj mana musyash junajćhu illajpita cutiramunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Llutanta rurashanpitash juyu mincayninta mana cuyapaypa wascar ushyanga. Jarguringa: ‹Juyu-masiquicunawan juyämuy› nirshi. Chayćhu atayparaj waganga. Juyupa ñacar, quiruntapis ućhunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Tayta Diosninchi maquinćhu purichimashanchipita tincuchiypa tantiyachishayqui. Juc cutićhüshi ćhuncaj jipash achquinwan-caman majachacaj müsuta shuyarpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pichgaj jipashnash yarpay-sapa caran; pichgajnash pishi-yarpayyuj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pishi-yarpayyuj jipashcuna achquinwan puriptinsi, wira wiñacunanta manash purichiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yarpay-sapa jipashcunash ichanga achquinta, wira wiñacunantinta purichicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Majachacaj müsu juclla mana ćhayaptinshi, jipashcunata puñunay chariran. Llapanshi puñucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Pullan-pagas ćhayamuptinna, juc runash jayacuriran: ‹Majachacaj müsu yaycaycämunna. Ćhasquicäriyna› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chayshi jipashcuna achquinta camaricäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pishi-yarpayyuj jipashcunanash yarpay-sapa jipashcunata niran: ‹Achquïga upicäcuycannam. Wirayquita challicallämay.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yarpay-sapa jipashcunanash niran: ‹Challinacurga, llapanchi pishipacushunpaj. Wirata munar, ranticujcunaman aywariycunquiman.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Chayshi wira rantij aywashancaman majachacaj müsu ćhayaran. Majachacay tünaman achquin rataycajcunallatash yaycuchiran. Jinarcur wasipa puncuntash wićhgacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Chaypita pishi-yarpay jipashcunanash cutimur, puncupita jayacuran: ‹Taytallau tayta, puncuyquita quićhapaycallämay, ari› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Majachacaj müsunash wasi ruripita nimuran: ‹Mana ricsillajchu. ¿Piraj cacullanquipis?› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Yarpay-sapa jipash-jina jamcunapis camaricushalla cawanquiman. Cutimunäta mana musyanquichu. Mana yarpashpita cutimushaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Sumaj tantiyacunayquipaj tincuchiypa willapäshayqui. Juc runash carupa aywacunanpaj quimsa uywaynincunata jayachiran. Paycunapa maquinmanshi llapan imancunatapis ćhuraycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Callpanta tantiyaycur-tantiyaycur, llapallantash jaguipuran. Juc uywaynintash jaguipuran pichga waranga (5,000) jillayta, juctanash ishcay waranga (2,000) jillayta, juctanash juc waranga (1,000) jillayta. Jinarcur carupash aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","«Pichga waranga (5,000) jillayta ćhasquijnash juclla aruchiran. Aruchiptinshi, wawallan pichga waranga (5,000) llucshiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chay-jinash ishcay waranga (2,000) jillayta ćhasquijpis aruchishanpita wawallanta ishcay warangata (2,000) shuntaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Juc waranga (1,000) jillayta ćhasquijnash ichanga pachata ućhcuriycur pacaycuran. Manash aruchiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Unayllatanash wasinman runa cutiran. Jinarcur uywaynincunatash jayachiran jillayninta wawantinta shuntananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pichga waranga (5,000) jillayta ćhasquijnash niran: ‹Tayta, pichga waranga (5,000) jillayta jaguipamashcanqui. Wawanpis pichga (5,000) warangata mirasha. Wawantintam cutiycächij. Cayllä callan.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Runanash niran: ‹Allita rurashcanqui. Ichicllatapis alli ricashayquipita achcatana jaguipushayqui. Canan tünashun. Micupacushun.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Ishcay waranga (2,000) jillayta ćhasquijnash niran: ‹Tayta, ishcay waranga (2,000) jillayta jaguipamashcanqui. Wawantapis ishcay warangata (2,000) shuntashcä. Wawantintam cutiycächij. Jillayllä.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Runanash niran: ‹Allita rurashcanqui. Wallcallatapis alli ricashayquipita achcatana jaguipushayqui. Canan tünashun. Micupacushun.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Juc waranga (1,000) jillayta ćhasquijnash niran: ‹Tayta, manchacuypa runa cashayquita musyä. Jamashalla imatapis ćhasquinqui. Mana murupacuycarsi, achca-achcata shuntayta munanqui. Mana arucuycarsi, chay-chicata pallayta munanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chaymi manchacurä. Manchacurmi, jillayniquitapis mana yatapashcächu. Manchäga pachata ućhcurcullar pacaycurä. Catay jillayniqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Chayshi runa niran: ‹Juyu runa canqui. Jilla. Jamashalla achca-achcata shuntayta musyaycar, ");
INSERT INTO qxhNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","jillay mirachijcunallamanpis jillaynïta ćhuranquiman caran. Cutimur, wawantinta shuntacüman caran.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Waquin uywaynincunatanash niran: ‹Waranga jillayninta jićhurir, ćhunca waranga (10,000) charaj-cajta juycuy. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sumaj wiyamay. Wiyacamaptin, pitapis yanapäshaj. Paycuna may-mayta charangapaj. Mana wiyacamajcunatam ichanga ichicllata charashantapis jićhushaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jilla uywaytaga wajtaman wicapay. Chacajman jaycuriy. Chayćhu atayparaj waganga. Juyupa ñacar, quiruntapis ućhunga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Tayta Diosninchipa caćhan car, anjilcunawan-ima cutimushaj. Jatun auturdä-jina achic-achicyaycar mandajpa jamacunanćhu jamashaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Llapan marcapita runacuna ñaupäman jutucanga. Llapan jutucaptin, capshicunapa ćhaupinpita uyshata raquiycaj-yupay shimïta wiyacujcunata raquicurishaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wiyacamajcunata alli ricar, dirïcha-caj lädüman raquicurishaj. Mana wiyacamajcunatam ichanga juyu ñawïwan ricar, isquirda-caj lädüman raquirishaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Jatun auturdä carmi, wiyacujcunata nishaj: ‹Papänï alli ricashunqui. Paypa maquinćhüna caway. Cay pachata camashanpita-pacha maquinćhu cawanayquipaj shuyaraycäshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yargaycajta ricaycämar, jaramashcanqui. Yacunaycajta ricaycämarpis, upuchimashcanqui. Jurpay-tucur puriptïpis, pachächimashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Müdanaynajta ricaycämarpis, ushtucunäpaj camaripamashcanqui. Jishyaptïpis, carsilćhu wićhgaraptïpis, watucallämashcanqui.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Chaura wiyacuj runacuna tapumanga: ‹Tayta, ¿imaytaj yargaycajta ricar, jarallashcaj? Yacunaycajta ricar, ¿imaytaj upuchillashcaj? ");
INSERT INTO qxhNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Jurpay-tucur puriptiqui, ¿imaytaj pachächillashcaj? Müdanaynajta ricar, ¿imaytaj camaripullashcaj? ");
INSERT INTO qxhNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Jishyaycaptiqui, carsilćhu wićhgaraptiqui, ¿imaytaj watucullashcaj?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Canan sumaj tantiyacunquiman. Wiyacamaj irmänucunata tarichir yanapar, quiquïta yanapämashcanqui. Nuwa-janan paycunata yanapashcanqui runa-masincuna mana alli ricacaptinsi. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Jinarcur mana wiyacujcunata chapata rurar nishaj: ‹Juyu runacuna, ricaytasi mana munallajchu. Ratataycaj ninaman jaycushayqui. Mana ushyacaj ninata Tayta Diosninchi camarisha supay-masintincunapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yargaycaptïsi, mana jaramashcanquichu. Yacunaycaptïsi, mana upuchimashcanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jurpay-tucur puriptïsi, mana pachächimashcanquichu. Müdanaynaj caycaptïsi, ushtucunäpaj mana camaripamashcanquichu. Jishyaycaptïsi, carsilćhu wićhgaraycaptïsi, mana watucamashcanquichu.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Chaura mana wiyacujcunapis tapumanga: ‹Tayta, yargaycajta, yacunaycajta, jurpay-tucur puriycajta, müdanaynajta imaypis mana ricashcajchu. Jishyaycashayquitapis, carsilćhu wićhgaraycashayquitapis mana musyashcächu. Ricar-imarga, yanapajmanmi caran.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nuwana nishaj: ‹Sumaj tantiyacunquiman. Wiyacamajcunata mana alli ricashpayqui mana yanaparga, nuwatapis mana yanapämashcanquichu.› ");
INSERT INTO qxhNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Chaymi mana wiyacamajcuna imaycamanpis ñacangapaj. Wiyacamajcunatam ichanga maquinćhu imaycamanpis Tayta Diosninchi cawachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Willapäcuriycur, purïshijnincunallatana Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Cananpita ishcay junajllata Pascua fiesta jallaycunga. Fiestaćhu Tayta Diosninchipa caćhan caycaptïsi, runacuna charimanga rusćhu wañuchimänanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chay junajcuna mayur cüra Caifás mandaj cüra-masincunata, mayur runacunata, yaćhajcunata wasinman jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Parlanacur, llapan auniran tumpayllapa Jesústa charircur wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Chaypis waquinga mana munaranchu: «Fiestaćhu ama wañuchishunchu. Runacuna ticraparamäshuwan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania marcaman ćhayar, Simónpa wasinćhu Jesús micupacuycaran. Simón jaraćhu jishyapita allchacash captin: «Jaraćhu Simón» nir ricsij. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Micupacuycaptin, butïlla pirjümin aptash warmi ćhayaran. Chay pirjümi sumaj ćhaninyuj caran. Butïllata quićharir, Jesúspa umanman jaycapuriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesúspa purïshijnincunana ullgucäcuran: «¿Imapäraj pirjümita usuchisha? ");
INSERT INTO qxhNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ama usuchinmanchu caran. Manchäga pishipacujcunata aypunanpaj ćhaninćhu ranticunman caran» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesúsmi ichanga niran: «Ama rimapaychu. Cay warmi llaquipämar, allita rurasha. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pishipacujcunata imaypis ricanquipaj. Nuwatam ichanga waran-waran mana ricamanquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chaymi cay warmi allita rurasha. Cawaycaptillä, pampamänanpaj armachimasha. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sumaj tantiyacunquiman. May-chayćhüpis Tayta Diosninchipa alli willacuyninta willapäcur, cay warmi allita rurashantapis willacunga. Mana jungacangachu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chay junajlla Judas Iscariote Jesúspa purïshijnin caycarsi, mayur cüracunaman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ćhayarcur niran: «Jesústa charïshiptï, ¿imatataj jumanquiman?» Paycunana quimsa ćhunca (30) jillayta yupapuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chay junajpita-pacha charij-charijllana Judas caycaran mayćhüpis Jesústa charinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascua fiesta jallariran. Chay fiestaćhu Israel runacuna libadüraynaj tantata micuj. Acrashan cashnitapis pishtaj. Chay junaj purïshijnincuna Jesústa tapuran: «Tayta, ¿mayćhütaj Pascua micuyta camaricamushaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesúsna niran: «Jerusalén marcaman ñaupay. Juc runapa wasinman ćhayar, ninqui: ‹Tayta Jesús caćhamasha. Warasi-chicasi wañucunganash. ¿Mayćhütäshi wasi jäcuycan purïshijnincunallawan Pascua micuyta micunanpaj?› » ");
INSERT INTO qxhNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Purïshijnincunana änir marcaman ćhayar, Jesúspa shiminman-tupu llapantapis tariran. Chayllaćhu Pascua micuyta camaricuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chacas-chacasna ćhunca ishcaywan purïshijnincunawan micunanpaj Jesús jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Micurcaycashanćhu niran: «Sumaj tantiyacunquiman. Mayganiquipis ticrapamar, wañuyman jitarpamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chaura llaquicäcur, jucnin-jucninpis Jesústa tapuran: «Tayta, ¿nuwachuraj? ¿Nuwachuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesúsna niran: «Nuwanchiwan iwal micujmi wañuyman jitarpamanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tayta Diosninchi caćhamasha. Quiquin camacächiptin, wañuyman ćhayashaj shimin ćharcucänanpaj. Jitarpamaj runam ichanga juyupa ñacanga. Ama yurinmanpishchu caran.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wañuyman jitarpuyta yarpaj Judaspis niran: «Tayta, ¿nuwachuraj?» Jesúsna niran: «Shimillayquipita musyä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Micurcaycashanćhu tantata aptacurcur, Jesús niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur tantata paquircur-paquircur, purïshijnincunata aypuran: «Catay. Micupacuy. Cay tanta quiquïmi caycä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaypita bïnuyuj cüpata aptacurcur, niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur purïshijnincunata aypuran: «Cayllapita llapaniqui upuchinacuy. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay bïnu yawarnïmi. Washänaj-raycur wañuyman ćhayaptï, yawarnï jićhanga. Yawarnïwanraj parlanacushanta Tayta Diosninchi ćharcucaycächin. Pï-maypa juchantapis jungaycur, alli ñawinpana ricashunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sumaj tantiyacunquiman. Cananpita bïnuta mana upushänachu. Llapanchita Papänïpa maquinman jishpichimaptinchiraj, mushuj bïnuta upushunpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Micupacuyta ushyariycur, Tayta Diosninchita alliman ćhurashpan cantarir, Ulïbus puntaman aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chayćhüna purïshijnincunata Jesús niran: «Canan pagas llapaniqui jaguiraycamanquipaj. Mana yupachicamanquipänachu. Tayta Diosninchipa shiminpis nin: ‹Uysha michijta wañuchishaj. Wañuycachiptï, uyshancuna mashtaypa-mashtar aywacunga.› ");
INSERT INTO qxhNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«Cawarircamurmi ichanga Galilea marcaman ñaupashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedruna niran: «Llapan jaguirishuptiquipis, mana imaysi jaguirishayquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesúsna niran: «Pedro, sumaj tantiyacunquiman. Canan chacayllasi wasguimanquipaj. Mana ricsij tucumanquipächu. Gällu manaraj cantaptillansi, quimsa cutiparaj wasguimanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedruna niran: «Mana imaypis wasguishayquichu. Ishcaninchitapis jina wañuchimäshun.» Llapan purïshijnincunapis Pedro-jina niran: «Mana wasguishayquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaypita «Getsemaní» nishan ćhacraman purïshijnincunawan Jesús aywaran. Ćhayar, niran: «Washanijćhu Tayta Diosninchita mañacushäcaman cayllaćhu jamapäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chaynuy nir Pedrutawan Zebedeupa ishcay wamrantapis pusharan. Paycunapa ricay ñawinćhu jatunpa llaquicuran. Shungun ishquicäcuptin, niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","«Llaquicuy juyupa ćhayapamasha. Wañuy janäćhüna. Yanagaycallämay, ari. Waräshimay.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jinarcur carushman aywarcur pachacaman jungurpacuycur, Jesús mañacuran: «Papä, camacaptin, shuyarämaj ñacay ama ćhayapamanmanchu. Jishpiyta munaptïsi, shungü munashan ama camacächunchu. Manchäga munashayquinuylla llapanpis caycullächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cutircur, quimsaj purïshijnincunata puñuycajta tariran. Chaymi Pedruta niran: «¿Puñucuycanquichu? ¿Manachu juc ürallasi yanagämanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ricchay-llapa. Mana wasguimänayquipaj Tayta Diosninchita mañacäriy. Allita yarparsi, ushyacajllam carcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jinarcur yapay Tayta Diosninchita mañacuj aywacuran: «Papällau Papä, ñacanä camacaptin, munashayquinuylla jina ñacashäpis» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yapay purïshijnincunaman cutircur, puñucashta tariran. Wañuypa puñunay chariptin, puñucurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chaura puñuycajta jaguiycur yapay Tayta Diosninchita mañacuj aywacuran. Mañacushan-jinalla quimsa cutipa mañacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yapay purïshijnincunaman cutircur, niran: «¿Puñurcaycanquićhim? ¿Jitarpaycanquićhim? Juyu runacuna ćhayamushana. Tayta Diosninchipa caćhan caycaptïsi, charimanga. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jataripacuyna. Wañuyman jitarpamaj runa jananchićhünam. Aywapushun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús rimaycaptillan, purïshijnin cashpansi Judas ćhayapuran. Mayur cüracunawan mayur runacuna caćhaptin, chay-chicaj runa aywaran jirunwan-caman, tucsicunanwan-caman. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas mayna nish caran: «Macallarcushä runa Jesúsmi canga. Mana caćharillar, charicurcunqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chaymi juclla Jesústa macallarcur, wamayaran: «Taytallau tayta» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesúsna niran: «Wawallau, yarpashayquita juclla ruray.» Chaynuy niptin, Jesústa charicarcäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chaura Jesúspa juc purïshijninna cuchillunta jurgurir, mayur cürapa uywayninpa rinrinta rugupariran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesúsna niran: «Cuchilluta ćhuraycuy. Ama jugariychu. Cuchilluta jugarijcuna cuchilluwan tucsish wañunga. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Papänïta mañacuptï, washämänanpaj ćhunca ishcaywan (20) batallun anjilcunatapis juclla caćharamunman. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Chaypis mana mañacushächu. Jina wañuchimächun Tayta Diosninchipa unay willacujnincunapa shimin ćharcucänanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Llapan runatana Jesús niran: «¿Imatataj yarpanqui? ¿Suwa cashätachu? ¿Imanirtaj jiruyquiwan-jiruyquiwan, cuchilluyquiwan-cuchilluyquiwan shamushcanqui? Waran-waran Tayta Diosninchipa wasinćhu tantiyachicuycajta ricamashcanqui. ¿Imanirtaj mana charimashcanquichu? ");
INSERT INTO qxhNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ichanga Tayta Diosninchipa shimin ćharcucänanpämi charimashcanqui. Unay willacujcuna llapanta musyachicuran.» Niycaptillan, purïshijnincuna jishpicäriran. Japallantana Jesústa jaguiycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Charijcunana Jesústa aparan mayur cüra Caifáspa wasinman. Chayćhu Moiséspa shiminta yaćhajcunawan mayur runacuna shuntacaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesúspa caru jipallanta aywar, sawan ruricaman Pedro yaycuran. Rurićhu Jesús imaman ćhayanantapis ricananpaj Tayta Diosninchipa wasinta täpajcunawan jamacuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wasi rurićhu mayur cüracunawan llapan mayur Israel runacuna tumpajcunata ashircaycaran Jesústa wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ichanga mana tariranchu. Imata tumparpis, juchanta mana tariranchu. Mayllantana ishcaj runa niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Chay runash nisha: ‹Tayta Diosninchipa wasinta jućhurachïman. Jinarcur, quimsa junajllaćhu jatarachïman.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chaynuy tumpaptin mayur cüra jatarcur, Jesústa tapuran: «¿Manachu rimacunqui? ¿Rasunpachu rimashcanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Chaynuy tapuptinsi, Jesús mana rimacuranchu. Chaura mayur cüra niran: «Cawaj Tayta Diosninchipa ricay ñawinćhu caycanchi. Mä, willamay. ¿Tayta Diosninchipa Wawanchu canqui? ¿Caćhamushan Washäcujchu canqui?» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsna niran: «Rimashcanquinam. Chaypis Tayta Diosninchipa caćhan cashpä willashayqui: ‹Cananpita mandäshinäpaj Munayniyuj Tayta Diosninchipa dirïcha-caj lädunćhu jamashaj. Pucutay jananćhu cutiycämujta ricamanquipaj.› » ");
INSERT INTO qxhNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chaura mayur cüra ullgucäcuran. Müdanantapis raćhir ushyarir japariran: «Quiquin Tayta Diosninchita apäriycan. Shiminpita wiyashcanchi. Tistïguta mana ashishunnachu. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Waquinniqui, ¿manachu rimacunqui?» Chaynuy tapuptin, llapan runa juc shimilla niran: «Wañuchicächun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Waquin runa Jesústa tuwapur ushyaran. Waquinna lajyar ushyaran. Waquinna magaran: ");
INSERT INTO qxhNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«¿Pitaj lajyashcashunqui? Tayta Diosninchi caćhamushan Washäcuj caycar, mä, willamay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro sawanćhu jamaraycaptin, cürapa uywaynin jipash aywarcur, niran: «Galilea runa Jesúswan purishcanqui, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedrum ichanga llapanpa ñaupanćhu wasguiran: «Mana. Imatash rimacullanquipis» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chaynuy nir sawan wajtapa llucshicuran. Cürapa juc-caj uywaynin jipashna Pedruta ricar, llapan runata willaran: «Cay runa Nazaret marca Jesúspa purïshijnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedruna niran: «Mana. Jesús pï cashantapis mana musyächu. Tayta Diosninchipa ricay ñawinćhu rimaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mayllanta jinan runacunana Pedruta niran: «Galilea runa canqui, ¿au? Rimacuynillayqui musyachicuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chaura Pedro ullgucäcuran: «Chay runata mana ricsïchu. ¿Piraj cacullanpis? Llullacuptïga, jina Tayta Diosninchi ñacaycachimächun» nir. Rimaycaptillan, gällu cantariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chayraj Pedro yarpäriran: «Mana ricsij tucumanquipächu. Gällu manaraj cantaptillansi, quimsa cutipa wasguimanquipaj» nishanta. Jesúspa shiminta yarpärir wajtaman llucshiycur, llaquicuywan juyupa wagaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pacha wararcuptin, mayur cüracunawan mayur runacuna yapay jutucaran. Sisyunćhu Jesústa imanuypa wañuchinanpaj parlanacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jinarcur Jesústa sumaj watacurcur, mandaj Pilatupa dispächunman aparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesús wañuyman ćhayananta musyar, chigaypa Judas llaquicuran. Chaymi wañuyman jitarpushanpita wanacuran. Quimsa ćhunca (30) jillayta ćhasquishantapis mayur cüracunatawan mayur runacunata cutiycachiran: ");
INSERT INTO qxhNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Tayta Diosninchipa ricay ñawinćhu juchata aparicushcä. Jesús mana juchacush caycaptinsi, wañuyman jitarpushcä» nir. Paycunana niran: «Mana imanämanpishchu. Quiquiquipitana.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chaura jillay ćhasquishantapis Tayta Diosninchipa wasin ruriman machirir aywacuran. Carushta aywaycur, maticuriran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mayur cüracunana jillayta shuntarcur, parlanacäriran: «Cay jillayta Tayta Diosninchita jarashan cuyachicuyninwan mana talluchishuwanchu. Wañuchicuj runapa jillayninta mana ćhasquishuwanchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Parlanacuriycur, jäpa runacuna pampacunanpaj ćhacrata rantiran. Chay ćhacrapa jutin caran: «Allpa manca pampa.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Canancamanpis chay ćhacrata ricsin: «Yawar pampa» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Llapanpis camacaran willacuj Jeremíaspa shimin ćharcucänanpaj. Payga unayna niran: «Waquin Israel runacunapa shiminta ćharcur, runata wañuchishanpita quimsa ćhunca (30) jillayta juturan. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chay jillayllawan ‹Allpa manca pampa› nishanta rantiran. Tayta Diosninchipa shiminpita llapanpis camacaran.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dispächuman ćhayachiptin, mandaj Pilato Jesústa tapuran: «¿Rasunpachu Israel runacunapa mandajnin canqui?» nir. Jesúsna niran: «Quiquiquim rimashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mayur cüracunawan mayur runacunana tucuy-tucuypita Jesústa tumparan. Jesúsmi ichanga mana rimacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chaura mandaj Pilato Jesústa tapuran: «Ima-imata nishuptiquipis, ¿manachu rimacunqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesúsmi ichanga imatapis mana rimacuranchu. Chaymi mandaj Pilato mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pascua fiestaćhu runacuna mañacuptin, watan-watan mandaj Pilato juc rïsuta caćharij. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay wichan juyu runa Barrabás rïsu wićhgaraycaran. Juyu cashanta llapan runa musyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaymi mandaj Pilato llapan runata tapuran: «¿Maygantataj caćharishaj: Barrabástachu, ‹Washäcuj› ricsishan Jesústachu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesústa chiquir mayur runacuna apapushanta mandaj Pilato mayna musyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dispächućhu caycaptillan, mandaj Pilatuta warmin willachiran: «Chay runa juchata mana aparicushachu. Imatapis ama ruraychu. Chacay chiquita suyñushcä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Chaycaman mayur cüracunawan mayur Israel runacuna llapan runata shimiyaran: «Barrabásta caćhariy. Jesústa wañuycachiy» nir mañacärinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chaymi mandaj Pilato: «¿Mayganta caćharinätataj munanqui?» nir tapuptin, runacuna: «Barrabásta caćhariy» nir mañacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mañacuptin, mandaj Pilato tapuran: « ‹Washäcuj› ricsishan Jesústa, ¿imanäshätaj?» nir. Runacunana llapallan japariypa niran: «Rusćhu wañuchicächun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mandaj Pilatuna yapay tapuran: «¿Imaćhütaj juchata aparicusha?» Runacunana sumaj japariran: « Rusćhu wañuchicächun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Runacuna sumaj ullgucarcäriptin, ima ruraytapis mandaj Pilato mana camäpacurannachu. Chaymi llapan ricay maquinta yacuwan awicuran: «Cay runata wañuchiptin, nuwapa juchä mana cangachu. Munashayquita imatapis mä, ruracäriy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chaura llapan runa niran: «Cay runa wañuchishanpita nuwacunana, wamräcuna juchata aparicushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaymi mandaj Pilato Barrabásta caćhariycuran. Jesústam ichanga sumaj wascachiriycur, murucuncunata inćhigaran rusćhu wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Murucucuna mandajninpa sawanninman Jesústa yaycuchiran. Jinarcur llapan murucu-masincunata shuntachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jalapaćhar, Jesústa ushyaran. Asipänan cashpan mandajpa puca jacunta jacuparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Umanmanpis curünata jatiparan, ichanga cashata pilltarcullar. Dirïcha-caj maquinmanpis shugush garutillata aptaparan. Jinarcur ñaupanman jungurpacaycärir ashllir ushyaran. Alliman ćhuraj-tucuran: «Israel runacunapa mandajnin alli ricash caycullächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jananmanpis tuwapur ushyaran. Shugushwan umanćhu wirur ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pampaman ćhurariycur, puca jacunta jićhuriran. Quiquinpa müdananta ushtuparcur, rusćhu wañuchinanpaj aparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesústa wañuchinanpaj apaycashanćhu Cirene marca Simónwan tincuran. Simóntana Jesús apashan rusta apachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ćhayaran «Gólgota» nishan pachaman. Rimayninćhu: «Gólgota» ninanta: «Calabïra pata» nir ricsin. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Usuncachicuj jampitawan bïnuta tallurcachir, Jesústa upuchiyta munaran. Malliycur, mana upuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Rusman läbaycur, murucucuna surtita jitaran Jesúspa müdananta mayganinpis apacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jinarcur jamacuycur täparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Imapita wañuchishanpis musyacänanpaj rus jananman isquirbiran: «Cayga Jesús, Israel runacunapa mandajnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesústawan ishcaj suwatapis iwal rusman läbaran: jucninta dirïcha-caj lädunman, jucninta isquirda-caj lädunman. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chay quinranpa purij runacuna Jesústa pampaman ćhuraran. Ashllishpan umanta awir ");
INSERT INTO qxhNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","niran: «Tayta Diosninchipa wasinta jućhurachirshi, quimsa junajllata pirgaypa jatarachinqui. Tayta Diosninchipa Wawan carga, wañuypita mä, jishpiy. Ruspita mä, yarpamuy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mayur cüracunapis, mayur runacunapis, Moiséspa shiminta yaćhajcunapis Jesústa pampaman ćhurar, niran: ");
INSERT INTO qxhNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Waquin runacunata cawarachishash. Quiquinmi ichanga jishpiyta mana junchu. Israel runacunapa mandajnin carga, ruspita mä, yarpamuchun. Yarpamuptin, shiminta ćhasquicushunćhi. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tayta Diosninchimanshi yupachicuran. ‹Tayta Diosninchipa Wawanmi cä› nishash. Tayta Diosninchi llaquipar, mä, wañuypita jishpichichun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lädunćhu läbaraj suwacunapis Jesústa ashllir ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lasdüsipita mallwaycaman pacha chacacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mallwayna Jesús japaćhacuran: «Elí, Elí, ¿lamá sabactani?» nir. Rimayninćhu: «Elí, Elí, ¿lamá sabactani?» ninanga: «Taytallau Tayta, ¿imanirtaj jaguiraycamashcanqui?» ninanmi. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Japaćhacuptin, wiyajcuna niran: «Mä, wiyashun. Tayta Diosninchipa unay willacujnin Elíastaćhim jayacuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Juc runana juclla shigui bïnuman shaputa ushmarcachir shugushman watarcur, Jesústa shuguchiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waquin runam ichanga ricaparcaycaran: «Ama yanapaychu. Mä, ricapäshun. Rasunpachush Elías shamunga ruspita jishpichinanpaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesúsmi ichanga sumaj japarir, wañucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wañucäcuptin, Tayta Diosninchipa wasinćhu chaparaj bayïtapis janapita uraypa callacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pachapis sicsicyacurcuran. Chagacunapis shillicäcuran. Mïchucunapis quićhacäcuran. Tayta Diosninchita wiyacujcunaga wañush caycashanćhüsi achcaj cawaricarcamuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Cawarimur, pamparashan ućhcupita llucshiramuran. Paycunapis Jesús cawarimushanpita Jerusalén marcaman aywaran. Achcaj runa ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pacha sicsicyaptin, Jesústa täpaj capitanpis, murucucunapis juyupa manchariran: «Cay runa rasunpa Tayta Diosninchipa Wawan casha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jesústa yanapar Galilea marcapita-pacha aywäshij warmicunapis carullapita ricapaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ricapaycaran Magdalena marcapita María, Santiagupawan Josépa maman María, Zebedeupa warmin-ima. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pacha chacanaycaptin, mandaj Pilatuman Arimatea marcapita José aywaran. Payga puchuy-puchuy jananćhu cawaj runa caran. Jesúswanpis purij. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ćhayarcur, mandaj Pilatuta niran: «Jesústa pampachicushaj.» Mañacuptin, murucuncunata: «Apacuchun» nir auniran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chaura ayanta shuntaycur, tacshash bayïtawan José pituran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jinarcur quiquin pampacunanpaj ućhcuchishan chagaman pampaycuran. Chayman pitapis mana pamparanrächu. Puncuntapis jatun rumiwan chapachiran. Nircur aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pamparaycaptin, Magdalena marca Maríawan Josépa maman María pamparashan ñaupanćhu jamaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Diyawarda tutana Pascua fiesta camaricuy junaj ushyarcuptinna, mayur cüracunawan fariseucuna parlanacuriycur, mandaj Pilatuman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ćhayar, niran: «Tayta, llulla Jesús cawaycällar niran: ‹Quimsa junajpita cawarimushaj.› ");
INSERT INTO qxhNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chaymi pamparashanta quimsa junajcaman täpachiy. Manchä purïshijnincuna ayanta suwacurunman. Jinarcur runacunata willapanga: ‹Wañushanpita Jesús cawarimusha› nir. Chaynuy llullacuptin, llapan shungunwanna runacuna ćhasquicunga.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mandaj Pilatuna niran: «Murucucunaga maquiquićhümi. Jesús pamparashanta sumaj täpachun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Niptin, murucucunawan aywar, Jesús pamparashanta chaparaj rumita chäpaypa chapaycuran. Murucucunatapis täpananpaj ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Diyawarda ushyarcuptin dumingu warariycaptillan, Magdalena marca Maríawan juc-caj María Jesús pamparashanman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Illajpita pacha juyupa sicsicyacurcuran. Janaj pachapitapis Tayta Diosninchipa anjilnin ćhayamuran. Anjilna ućhcu chaparaj rumita witircachir, jananman jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Payga illagu-jina achic-achicyaran. Müdananpis rajupa-niraj yuraj llutpi caran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Täpaj murucucunana juyupa mancharicäcuran. Wañush-jina jitacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Warmicunatana anjil niran: «Ama manchariychu. Rusćhu wañuj Jesústa ashiycashayquita musyä. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Cayćhu pampacush carsi, mana cannachu. Shiminman-tupu Tayta Diosninchi cawarachimusha. Mä, aya pamparashanta ricay. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Canan purïshijnincunata juclla willamuy. Cawarishantapis, Galilea quinranman ñaupaycashantapis willanqui. Chayćhümi tincunquipaj. Imatapis ama tapupämaynachu. Llapantana willashcaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Warmicunana mancharir, pamparashanpita aywacullaran. Chaypis shungun achicyacäcuptin, juclla Jesúswan purij-masincunata willaj aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aywarcaycaptin, Jesús ricaripuran: «¿Allillachu caycanqui?» nir. Wamayaptin, Jesúspa ćhaquinta macallacurcur alliman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesúsna niran: «Ama manchariychu. Purïshimajnïcunata willaraycamuy. Galilea marcaman aywachun. Chayćhümi tincushun.» ");
INSERT INTO qxhNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmicuna aywacuriptin, pamparashanta täpaj murucucunapis waquinga marcaman cuticuran. Mayur cüracunata llapallanta willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaura mayur cüracunawan mayur runacuna parlanacuran. Sumaj parlanacuriycur, murucucunata achca jillayta juycuran: ");
INSERT INTO qxhNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«Pitapis willanqui: ‹Nuwacuna puñuycaptï purïshijnincuna chacaypa sharcamur, Jesúspa ayanta suwapaycamasha› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mandaj Pilato mayaptin, parlapushayqui mana imamanpis ćhayanayquipaj. Mana wascashunayquipaj amachashaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chaura murucucuna jillayta ćhasquicurcuran. Mayur runacuna yaćhachishallanta runacunata willaparan. Rimashanga Israel runacunapa yarpayninćhu canancamanpis jinalla cacun. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chaura Galilea quinranman Jesús ricsichishan puntaćhu tincunanpaj ćhunca jucwan (11) purïshijnincuna aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesústa ricar waquin tantiyayta mana camäpacursi, llapallan alliman ćhuraran. Waquincunam ichanga llutäpacuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Paycunawan juturar, Jesús niran: «Janaj pachatapis, cay pachatapis maquïman Tayta Diosninchi ćhurasha. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cananga jamcunapis chay-tucuyman aywanquiman. May marcaćhüpis shimïta willapäcunqui. Shimïta wiyacujcunata Tayta Diosninchipa jutinćhu, Wawanpa jutinćhu, Espíritu Santupa jutinćhu ushyachinqui. ");
INSERT INTO qxhNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wiyacunanpaj ima-imata willapashätapis llapanta tantiyachinqui. Cay pacha ushyacänancaman ricaycäshayqui.»");
INSERT INTO qxhNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cay librućhu isquirbiraycan Tayta Diosninchi acracushan Jesucristupa alli willapan. Jesúsga Tayta Diosninchipa Wawan. Caynuy jallarin. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Unay willacujnin Isaíaswan musyachicur, Tayta Diosninchi niran: «Mä, wiyamay. Juc runa ñaupapäshunquipaj. Quiquinta caćhashaj. Paymi runacunata willapäcungapaj camaricushalla shuyaräshunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chunyajćhümi jayacuypa willacuycan: ‹Taytanchi shamunanpaj camaricuy. Caminuta pichay. Wicsu caminucunatapis allchay› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chaura Isaías musyachicushan ćharcuptin, chunyaj pachaćhu runacunata Juan anyaparan. Llapanta anyapar, niran: «Tayta Diosninchipa shiminta wiyacäriy. Juchapita wanacäriy. Ushyacäriy. Chayrämi Tayta Diosninchi llapan juchayquita junganga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Achcaj runa Jerusalén marcapita, Judea quinran marcacunapitapis aywaran Juan willapäcushanta wiyaj. Jucha aparicushanta mana pacaptin, Jordán mayućhu Juan ushyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanpa müdanan camïllupa ajchanpita caran; sinturunninpis jarachapita. Chunyajćhu tarishan chucluscunallatawan munti abïjapa mishquillanta micuj. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Runacunatana willapaj: «Juc runa shamunga. Payga munayniyujmi. Llanguinta llushtipuyllatapis manchapacü. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jamcunata yacullawan ushyachicuycä. Shamuj runam ichanga Espíritu Santuwan ushyachishunquipaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay wichan Galilea quinran Nazaret marcapita Juan ushyachicushan-cajman Jesúspis aywaran. Paytapis Jordán mayućhu Juan ushyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ushyacuriycur yacupita llucshiramur, janaj pacha quićhacämujta Jesús ricaran. Espíritu Santuna paluma-jina jananman yarpamuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Janaj pachapita rimamushanpis wiyacämuran: «Cuyay Wawämi canqui. Shungümanmi sumaj tincunqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chaypita Espíritu Santu charicurcur, chunyaj pachaman Jesústa aparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Micucuj uywacuna tiyananćhu ćhuscu ćhunca (40) junaj juyaptin, Supay maquichacuyta munaran. Anjilcunam ichanga Jesústa pishishanta tarichiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ushyachicuj Juanta carsilman wićhgachishanpita-pacha Galilea marcacunamanna Jesús aywacuran. Chay marcacunaćhu Tayta Diosninchipa alli willacuyninta willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Willapäcur niran: «Tayta Diosninchi shuyaraycämanchinam. Maquinćhünam purichimäshun. Jucha aparicushayquicunapita wanacäriy. Tayta Diosninchiman yupachicäriy. Alli willacuyninta wiyacäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea püsu cantunpa aywaycashanćhu Jesús ricaran Simóntawan wauguin Andrésta. Piscädu charij car, ridinta yacuman jitarcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paycunata Jesús niran: «Purïshimay. Piscäduta charishayqui-jina runacunata shuntanquipaj Tayta Diosninchipa maquinćhu cawananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chaura ridinta jaguiriycur, Jesúswan aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Washanijta aywaycashanćhüna Santiagutawan Juanta bütillaćhu ridinta allcharcaycajta tariran. Paycunapa taytan caran Zebedeo. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús jayaptin, papänintawan mincaynincunata bütinćhu jaguiycur, aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaypita Cafarnaún marcaman aywacäriran. Diyawarda junaj shuntacäna wasiman yaycurir, Tayta Diosninchipa shiminta Jesús willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Willapäcushanta wiyar, runacuna sumaj cushicäriran: «Moiséspa shiminta yaćhajcuna willapäcushanta mana tantiyanchichu. Jesús willapäcushanmi ichanga shungunchiman sumaj ćhayan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay shuntacäna wasićhu supay pucllacushan runapis caycaran. Supay rimachiptin, japarir niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Nazaret runa Jesús, ¿imatataj ashiycanqui? ¿Illarachimajchu shamushcanqui? Pï cashayquitapis musyä. Tayta Diosninchipa Wawanmi canqui. Acracuyninmi canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesúsna supayta piñacuran: «Upälla. Chay runata caćhariy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chaura supay runata wañunajpaj tapsirir, juyupa japarir, aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chayta ricar, llapan runa juyupa manchariran. Jucnin-jucnin ninacuran: «¿Imatataj ricanchi? ¿Imatataj wiyanchi? Cananraj munayniyuj runata ricanchi. Supaycunata jarguptinpis, aywacun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaynuy Jesús ima-ima rurashanpis llapan Galilea marcacunaćhu juclla mayacaran. Quiquin-pura runacuna willanacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Shuntacäna wasipita aywacur Santiagutawan Juanta pushacurcur, Jesús aywaran Simónpawan Andréspa wasinman. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ćhayaptin, juclla willaran: «Tayta Jesús, Simónpa suydan wayllaywan jishyaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chaura jishyajman ćhayar, maquinpita jatarcachiran. Jatarcachiptin, wayllay caćhariycuran. Jinarcur yanucuriycuran jarananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chacanaycaptinna, runacuna jishyaćhucunata Jesúsman apamuran. «Diyawarda ushyacashanam» nir tucuy-niraj jishyaćhucunata, supay pucllacushancunata ćhayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Simónpa marca-masincunapis llapan-yupay wasi puncunćhu juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chaymi tucuy-niraj jishyawan jishyaćhucunata achcajta Jesús allchacächiran. Waquin runacunapita pucllacuj supaycunatapis jarguran. Pï cashantapis musyaptin, supaycunata mana rimachiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chaca-chacalla marcapita llucshir, chunyaj pachaman Jesús aywaran Tayta Diosninchita mañacuj. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Chaura purïshij-masincunawan Jesústa ashij Simón aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Taripar, niran: «Tayta, llapan runa ashircaycäshunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesúsna niran: «Washa marcacunamanpis aywashun Tayta Diosninchipa alli willacuyninta willapäcuj. Chaypämi shamushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chaymi Galilea quinranćhu marcan-marcan Jesús puriran. Shuntacäna wasicunaćhüpis Tayta Diosninchipa alli willacuyninta willapäcuran. Supaycunatapis runacunapita jarguran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jaraćhu jishyawan runana Jesúspa ñaupanman jungurpacuycur, mañacuran: «Llaquipämashpayqui allchacaycachillämay. Tayta Diosninchipa ricay ñawinćhüpis alli cayta munä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mañacuptinga, llaquipashpan maquinwan yataycur, Jesús niran: «Llaquipajmi. Allchacayna.» ");
INSERT INTO qxhNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chaynuy niptin, jaraćhu jishyawan jishyaycashanćhu allchacäcuran. Tayta Diosninchipa ricay ñawinćhüpis allina caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chaura pitapis mana willapällar aywacunanpaj Jesús piñaparan: ");
INSERT INTO qxhNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Pitapis ama willapanquichu. Manchäga cüraman ayway allina cashayquita ricashunayquipaj. Moiséspa shiminta ćharcur, cuyachicuyniquitapis Tayta Diosninchita jaray. Chayrämi llapanpa ricay ñawinćhu alli canquipaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Chaynuy willapaptinpis, willacuraycar aywacuran. Chaura chay-tucuyćhu mayacaran. Chaynuypa Jesús llapan runa ricay may marcamanpis mana yaycurannachu. Marca wajtancunallaćhüna puricuran. Runacunam ichanga chay-tucuypita Jesúsman shamuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chaypita ishcay-quimsa junajtana Cafarnaún marcaman Jesús yapay cutiran. Wasinćhu caycashanta musyar, ");
INSERT INTO qxhNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","achcaj runa shuntacaran. Wasi puncu pampapis mana jäcurannachu. Jesúsna Tayta Diosninchipa alli willacuyninta willapäcuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chaynuy juturpaycaptin, quirmallawan cumllucash runata ćhuscuj runa ćhayachimuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wasi junta runa juturpaycaptin, Jesúspa ñaupanman yaycuchiyta mana camäpacuranchu. Chaymi wasi jananman jigarcur, ućhcuriycäriran. Jinarcur Jesúsman quirmantinta warcuyllapa yarpuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Paycuna llapan shungunwan yupachicushanta musyar, cumllucash runata Jesús niran: «Wawallau wawa, juchayquicunata jungashcänam.» ");
INSERT INTO qxhNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chaura Moiséspa shiminta yaćhajcuna shungullanćhu ullguran: ");
INSERT INTO qxhNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Cay runa, ¿imanirtaj chaynuy riman? Chaynuy rimarga, Tayta Diosninchita apäriycan. Juchanchita Tayta Diosnillanchi junganman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yarpashanta musyar, Jesús tapuran: «¿Imanirtaj llutanta yarparcaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mä, tapushayqui. ¿Cumllucash runata allchacächiychu, jucha aparicushanta jungacächiychu sasa? ");
INSERT INTO qxhNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Canan tantiyacunquiman. Tayta Diosninchi cay pachaman caćhamasha. Munayniyujmi cä pipa juchantapis jungacächinäpaj.» Cumllucash runatana niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Jatariy. Quirmayquita shuntacurcur, wasiquiman cuticuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chaura cumllucash runa jataricurcuran. Quirmanta apacurcur, llapan ricay llucshicuran. Chaynuypa llapan runa cushicushpan Tayta Diosninchita alliman ćhuraran: «Canan ricashanchita mana imaypis ricashcanchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaypita Galilea püsu cantunpa Jesús yapay aywaycaran. Runacunapis achcaj ricäcuj aywaran. Paycunatam Jesús yaćhachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aywaycashanćhu Alfeupa wamran Levíta ricaran. Levíga Roma marcapa mandajninpaj jillayta shuntaycaran. Ricar, Jesús niran: «Leví, purïshimay.» Niptin, Jesústa Leví purïshiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chaypita Levípa wasinćhu purïshijnincunawan Jesús micurcaycaran. Waquin juchaćhu arujcunawanpis, jillayta shuntajcunawanpis micurcaycaran. Chay-niraj runacuna achcajmi Jesústa purïshiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moiséspa shiminta yaćhaj fariseucunana Jesústa chiquipashan ricaran juchaćhu arujcunawan jillayta shuntajcunawan micurcaycajta. Chaymi Jesúspa purïshijnincunata tapuran: «¿Imanirtaj juchaćhu arujcunawan, jillayta shuntaj chiqui runacunawan Jesús micun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jamurpaptin, Jesúspis niran: «Jishyaćhucunallash jampicujta ashin. Mana jishyarga, mana ashinchu. Chay-jina nuwapis juchaćhu arujcunata Tayta Diosninchiman cutichij shamushcä. Manam: ‹Juchaynajmi cä› nijcunatachu ashiycä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cuti Ushyachicuj Juanpa purïshijnincunapis, fariseucunapis ayünashpan Tayta Diosninchita mañacurcaycaran. Chaymi waquin runacuna Jesústa tapuran: «Ushyachicuj Juanpa purïshijnincunapis, fariseucunapa purïshijnincunapis ayünashpan Tayta Diosninchita mañacun. Purïshijniquicunam ichanga, ¿imanirtaj mana ayünanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chaynuy niptin quiquinman tincuchicur, Jesús niran: «Warmi ashïshijcuna manash llaquishachu ayünan. Manchäga cushishash micupacärin. Majachacaj müsuta yanagaycar, manash ayünanmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Warmi ashij müsuta jićhuptinshi ichanga, ayünangapaj. Jatunpash llaquicungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Chaynuypis mauca müdanata mushuj raćhipawan manash pipis jiranmanchu. Mushujwan jiraptin, jintishpan mauca müdanatapis jatunpanash raćhirachin. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bïnuta puguchinanpäpis manash pipis chaquish jaracha putuman wiñanmanchu. Bïnu pugur, chaquish jaracha pututa pashtarachinshi. Pashtaptin, bïnupis ushyacäcunshi. Jaracha putupis raćhicäcunshi. Chayshi llullu bïnuta llullu jaracha putumanraj wiñan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Diyawarda junaj rïgu cantunpa purïshijnincunawan Jesús aywaycaran. Purïshijnincuna rïguta shipircur-shipircur, maquinćhu cupacaćharcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chaymi fariseucuna Jesústa tapuran: «¿Mä, arushanta ricanquichu? ¿Imanirtaj diyawardaćhu purïshijniquicuna rïguta cupacaćharcaycan? Diyawardaćhu Tayta Diosninchipa shiminta ćharcurmi, mana arunchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chaura Jesús niran: «¿Auquillunchi David imata rurashantapis manachu musyanqui? Tayta Diosninchipa shiminta liguiycarsi, ¿yargaywan David imata rurashantapis manachu tantiyacushcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mayur cüra Abiatar caycashan wichan yargay chariptin Tayta Diosninchipa wasinman yaycurir, jarashan tantanta David micuran. Cüracunalla micunan caycaptinsi, yanaguincunawanraj David micupäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","«Mä, wiyamay. Tayta Diosninchi diyawardata camacächiran runacuna jamaycunanpaj, mana chay junajta manchapacunanpächu. ");
INSERT INTO qxhNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tayta Diosninchi caćhamasha. Chaymi diyawarda maquïćhu. Diyawardaćhu runa imata rurananpäpis, imata mićhänäpäpis maquïćhümi caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Juc cuti shuntacäna wasiman Jesús ćhayaran. Chayćhu maquin wañush runapis caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ricapacujcunana Jesústa ricaparcaycaran: «Diyawarda caycaptin, mä, allchacächingachush. Allchacächishallanmi achäqui canga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Maquin wañush runatana Jesús niran: «Llapan ricashunayquipaj ićhiy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Waquin runatana tapuran: «Diyawardaćhu, ¿allitachu, llutantachu rurashuwan? ¿Washäshuwanchu? ¿‹Wañucuchun› nishuwanchu?» nir. Tapuptin, llapan upällacaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chaura Jesús ricapacujcunata ullgush ricapäriran. Rumi shungu captin, sumaj llaquicuran. Maquin wañush runatana niran: «Maquiquita chutapacuy.» Chutapacuriptin, maquin allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseucunam ichanga juclla aywarcur, mandaj Herodespa yanapajnincunawan parlanacuran imanuypapis Jesústa wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chaypita püsu cantunman purïshijnincunawan Jesús aywacuran. Jipantana achcaj Galilea runacuna aywaran. Judea quinranpitapis aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesús ima rurashancunata mayar, chay-tucuypita runacuna aywaran. Aywaran Judea quinranpita, Jerusalén marcapita, Idumea quinranpita, Jordán mayu wajtanpita, Tiro marca quinranpita, Sidón marca quinranpita. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chaymi purïshijnincunata Jesús niran: «Runacuna quićhquipämashpanchi lluchcamänanchipita bütita camariy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Achcajta allchacächish caycaptin, jishyaćhucuna Jesúsman imanuypapis aywaj yatayllapis yataycunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jesústa ricashpan supay pucllacushan runacunapis jungurpacuycur, japariypa niran: «Jamga Tayta Diosninchipa Wawanmi canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Niptin, pï cashantapis mana musyachicunanpaj Jesús sumaj piñacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaypita puntaman Jesús aywaran. Chayćhu shungunman tincushancunata shuntaran. Shuntaptin, ");
INSERT INTO qxhNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","ćhunca ishcaywanta (12) acracuran purïshinanpaj, shiminta willapäcunanpaj, supaycunata jargunanpaj. Paycunata acracuran caćhacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ćhunca ishcaywan acracushancuna caycaran: «Pedro» nishan Simón, ");
INSERT INTO qxhNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeupa wamran Santiaguwan Juan. Paycunatam jutichaparan: «Boanerges» nir. «Boanerges» ninanga: «Räyupa wamrancuna» ninanmi. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeupa wamran Santiago, Tadeo, «Marcanpaj nanachicuj» nishan Simón, ");
INSERT INTO qxhNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote. Payga Jesústa wañuyman jitarpuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaypita purïshijnincunawan Jesús wasinman cuticuran. Yapay achcaj runa shuntacaptin, micunanpäpis mana jäcuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chayta mayaycur, yawar-masincuna aywaran apacunanpaj: «Supayćhi pucllacusha» nir runacuna rimaptin. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalén marcapita ćhayaj Moiséspa shiminta yaćhajcunapis nircaycaran: «Mayur supay Beelzebulta jayararshi, supaycunata jarguycan. Mana Tayta Diosninchitachu jayaraycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chaynuy niptin, Jesús jayapar, tincuchiypa willaparan: «Quiquin Supay, ¿imanuyparaj quiquinta jargucunman? ");
INSERT INTO qxhNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","May marcaćhüpis quiquin-pura ticrapanacur, wacpa-caypash aywacärin. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","May wasićhüpis majanwan ticrapanacur, raquicaymanshi ćhayan. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chay-jina mayur supaypis supay-masinwan ticrapanacur, ima ruraytapis mana camäpacunmanchu. Ushyacaymanpis ćhayanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Juc runash wasiman yaycapur, wasiyujpa imancunatapis suwacun. Ichanga callpayuj runataräshi mancurnan. Jinarcurräshi imancunatapis ushyajpaj apacun. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Sumaj tantiyacunquiman. Runacunapa llapan juchantapis, tucuy-jinanpa pampaman ćhurashantapis Tayta Diosninchi junganga. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Espíritu Santuta ashllir ushyaptinmi ichanga, mana jungangachu. Juchanta aparicushalla imaypis cawanga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús chaynuy niran: «Supaypa maquinćhu purin» nir tumpashanpita. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chaynuy willapäcuycaptin, Jesúspa mamanwan wauguincuna ćhayaran. Jawallapita jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Juturpaycajcunana niran: «Tayta Jesús, mamayquiwan wauguiquicunash jawaćhu shuyarpaycäshunqui. Ashishunquish.» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chaura Jesús tapuran: «¿Pitaj mamä? ¿Pitaj wauguïcuna?» ");
INSERT INTO qxhNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Juturpaycajcunata ricärir, niran: «Jamcuna mamä, wauguïcuna canqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pipis Tayta Diosninchipa shungun munashanta rurajcunaga mamäwan, wauguïcunawan, panïcunawanmi tincun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chaura yapayna jatun püsu cantunćhu Jesús yaćhachicuycaran. Achcaj runa jutucaptin, bütiman jigacurcuran willapäcunanpaj. Runacunam ichanga yacu cantullanćhu juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bütipitana Jesús imawanpis tincuchiyllapa tantiyachir, niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Sumaj wiyamay. Juc runash murupacuj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Machiptinshi, waquin muru caminuman ćhayasha. Caminuman ćhayajta pichuysacunash pashacurcusha. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquin murunash jarapshu allpaman ćhayasha. Jarapshu captinshi, juclla wiñacarcamuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ichanga janallanćhu sapin captin, inti rupaptinshi, chaquicäcusha. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin murunash shata-shataman ćhayasha. Shata atayäcurcurshi, muru wiñamujtapis jarwashtärachisha. Chayshi wiñarsi, mana wayushanachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquin murunash alli allpaman ćhayasha. Sumajshi wayusha. Waquin juc murullapitash wayusha quimsa ćhuncata (30); waquinshi sujta ćhuncata (60); waquinnash paćhacta (100).» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Willapäcuriycur, Jesús niran: «Rinriyujmi canqui. Tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Runacuna aywacuriptin, ćhunca ishcaywan purïshijnincunawan waquin jatirajnincuna Jesústa tapuran: «Tincuchiypa willapäcushayquita mä, tantiyachimay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesúsna niran: «Jamcunata mayna tantiyachishcaj: ‹Maquinćhu cawananchipaj Tayta Diosninchi shuyaraycämanchi› nir. Mana wiyacujcunatam ichanga tincuchiyllapa tantiyachï. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tayta Diosninchipa shiminćhu nin: ‹Ricaycarpis, ñawiynaj-tucun. Wiyaycarpis, rinriynaj-tucun. Shimïta wasguiptinga, jucha aparicushantapis Tayta Diosninchi mana jungangachu.› » ");
INSERT INTO qxhNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chaypita Jesús niran: «Jamcunapis, ¿manachu tantiyanqui tincuchiypa willapäcushäta? Mana tantiyaycarga, ¿imanuyparaj llapan willapäcushäcunata tantiyanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","«Murupacuj murushan Tayta Diosninchipa shiminwan tincun. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Caminuman muru shicwashan-jina shimin achcaj runaman ćhayan. Ichanga wiyashantapis Supay juclla jungaycachin. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","«Jarapshu allpaman muru shicwashan-jina shimin waquin runaman ćhayan. Shiminta wiyar, cushishalla ćhasquicun. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ichanga jarapshu ćhacraćhu mana sapichashan-jina shungunmanpis mana ćhayanchu. Chaymi runa ñacayman ćhayar, Tayta Diosninchita wiyacushan-janan jaticaćhar ushyaptin, juclla jungaycun. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","«Shata-shataman murushan-jina shimin waquin runaman ćhayan. Shiminta wiyarpis ");
INSERT INTO qxhNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","chapa mana pishiptin, Tayta Diosninchipa shimin nishannuylla mana cawanchu. Imapäpis alläpa yarpaćhacur, rïcuyayllata ashir, shungun munashallanta ashir, tincupacan. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","«Alli allpaman murushan-jina shimin waquin runaman ćhayan. Paycuna shiminta wiyar, llapan shungunwanmi ćhasquicun. Juc muru alli wayur, quimsa ćhuncata (30), sujta ćhuncata (60), paćhacta (100) juc shicshillaćhu wayushan-jina Tayta Diosninchipa shimin nishallanta rurar cawan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yapaypis tincuchiypa Jesús niran: «Achquita ratarcachir, pipis manash manca rurinman, cäma ćhaquinman ćhuranmanchu. Manchäga patacmanshi ćhuran llapanta achicyänanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sumaj tantiyacunquiman. Runacuna shungullanćhu pacarächishanpis mayacanga. Imata yarpashanpis unayllata musyacanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Rinriyujmi canqui. Tantiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","«Canan willapashäta sumaj tantiyacunquiman. Tantiyacushayquiman-tupu Tayta Diosninchipis tantiyachishunquipaj. Sumaj-sumaj tantiyachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chaymi wiyacuptin, pitapis Tayta Diosninchi sumaj tantiyachinga. Mana wiyacujcunatam ichanga, ichicllata tantiyashallantapis jungaycachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yapay Jesús niran: «Tayta Diosninchipa maquinćhu juyaypita tantiyacushun. Juc runash ćhacraman muruta mururan. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Murushanpita pashtamur, wiñamun. Runa pagaspa puñurpis, junajpa riccharpis, muruta manash pashtachimunmanchu. Manash wiñachimunmanpishchu. Imanuy pashtashantapis, wiñamushantapis manash musyanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Allpalla pashtachimun. Tullunta wiñachin. Shicshichin. Puguchin. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Puguptinna: ‹Murushäpa wawanta shuntashäna› nir rutun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yapay tincuchiypa willapäcur, Jesús niran: «¿Imawanraj Tayta Diosninchipa maquinćhu cawajcunata tincuchishuwan? ¿Imawan tincuchiyparaj tantiyacushuwan? ");
INSERT INTO qxhNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Paypa maquinćhu cawajcuna ñäpus muruwan tincun. Chay muruga llapan murupitapis mas acapallash. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Muruptinshi ichanga, wirtaćhu sumaj wiñan. Waquin jaćhacunapitasi atayayta llallin. Callapancunapis ata captin, pichuysacuna llantucushpan jishucärin.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Runacuna sumaj tantiyacunanpaj imawanpis tincuchiyllapa Jesús willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imatapis tincuchiyllapa tantiyachicuj. Jinalla mana tantiyachijchu. Purïshijnincunatam ichanga yatalla sumaj tantiyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay junajlla pacha chacanaycaptin, purïshijnincunata Jesús niran: «Yacu püsuta chimpashun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chaynuy niptin, runacunata: «Aywallä» nir bütiwan Jesústa apacuran. Waquin büticunapis jipanta aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aywarcaycaptin, shucucuy wayra ricacamuran. Yacuna büchiypa-büchir bütiman yaycuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsmi ichanga jipaman aywaycur jawanacurcur, puñucash caycaran. Chaura purïshijnincuna juyupa mancharir, Jesústa ricchachiran: «Tayta, yacuman challpucaycanchina. ¿Manachu imasi jucunqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chaura riccharir, wayratawan yacuta piñacur Jesús niran: «Ćhawayna. Ama büchiypa-büchiynachu.» Chaura wayra ćhawacäcuran. Yacupis puñucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Purïshijnincunatana niran: «¿Imanirtaj mancharish carcaycanqui? ¿Tayta Diosninchipa maquinćhu cawashanchita manachu yupachicunqui?» ");
INSERT INTO qxhNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paycunana juyupa mancharishpan quiquin-pura tapunacäriran: «¿Piraj cay runa? Piñacuriptin, shucucuy wayra ćhawacäcun. Yacupis puñucäcun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Püsuta chimparcur, Gerasa quinranman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bütipita Jesús yarpuriptin, supay pucllacushan runa pantyunpita llucshiramuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay runaga runa pamparashan maćhaycunallaćhu tiyacuj. Cadinawan wataptinpis, raćhir ushyarij. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Achca cuti maquin-ćhaquinpita cadinawan wataptinsi, raćhirij. Pipis mana ićhipujchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Payga pagas-junajta, chaga quinranpa, runa pamparashan maćhaycunapa japaraycar puricuj. Quiquinpis rumicunawan tacacuj. Cuchucuj. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Carushćhu ricärir waracaylla aywarcur, Jesúspa ñaupanman jungurpacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Llapan callpanwan japarir niran: «Llapanta Camaj Tayta Diosninchipa Wawan Jesús, ¿imanirtaj ashipämanqui? Ama ñacaycachimaychu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chaynuy ninanpäga mayna Jesús niran: «Supay, cay runata caćhariy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesúsna tapuran: «¿Imataj jutiqui?» Tapuptin, niran: « ‹Batallun› jutï chay-chicaj cashpä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nircur llapan supaycuna yaparir-yaparir Jesústa mañacuran: «Cay quinranpita ama jarguycamaychu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chaura chagapa janallanćhu chay-chica cuchi pagupacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chaymi supaycuna mañacuran: «Tagay cuchicunata pucllacunäpaj aunimay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chaymi mañacushanta Jesús auniran. Auniptin supaycuna runata caćhariycur, cuchicunatana pucllacuran. Cuchicunana jishyayar, chagapita yacuman jigapurcuran. Llapallan shugupacaypa wañuran. Cuchicunaga ishcay waranga-ima (2,000) caran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cuchi michijcunana mancharish jishpicäriran. Aywaycur ćhacracunaćhüpis, marcaćhüpis imallata ricashantapis willacuran. Chaymi runacuna imanuy cashantapis ricaj shamuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesúsman ćhayar, supaycuna pucllacushan runata allchacashtana tariran. Jamaraycaranna. Müdanashana caycaran. Chaynuyta ricaycur, juyupa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ricajcunaga ćhayamuj runacunata willaparan imanuy allchacashantapis, cuchicuna imaman ćhayashantapis. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ćhayamuj runacunana Jesústa mañacuran: «Cay marcapita aywacuy, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mañacuptinga, bütiman jigaran aywacunanpaj. Allchacaj runam ichanga Jesústa mañacuran: «Tayta, pushacamay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Chaypis Jesús niran: «Mana camacanchu. Wasiquiman cuticuy, ari. Yawar-masiquicunata Tayta Diosninchi llaquipar allchacächishushayquipita llapanta willapay.» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chaura Decápolis marcacuna quinranpana chay runa willacuräcur puriran: «Jesús allchacächimasha» nir. Willacuptin, llapan runa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaura bütiwan wac chimpaman Jesús ćhayaptin, achcaj runa shuntacaran. Jesúspis yacu pallgallanćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Niycaptillan, Jairo ćhayaran. Payga shuntacäna wasićhu mayur runa caran. Jesúspa ñaupanman jungurpacuycur, ");
INSERT INTO qxhNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mañacuran: «Tayta, wasïman aywashun. Warmi wamrä wañuycan. Yatayllapis maquiquiwan yataycunquiman wamrä allchacänanpaj. Chayllawan cawanga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mañacuptin, Jesús aywaran. Achcaj runa aywaycaptin, Jesústa juyupa quićhquipaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ćhunca ishcaywan (12) watana yawar-apaywan jishyaj warmipis tallucash aywaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Warmiga jampicujcunawan jampicur imancunatapis ushyapacashana caycaran. Pipis mana allchacächiranchu. Manchäga alläpana ćhuracaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesús munayniyuj cashanta mayar runacunapa ćhaupinpa yaycurir jipallanpita tariparcur, Jesúspa müdananta yataycuran: ");
INSERT INTO qxhNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","«Müdanallantapis yatar, allchacashämi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yataycuptillan, yawar-apaynin änir ćhawacäcuran. Janan ancashyacäcushantapis quiquin mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Munayninwan pitapis allchacächishanta Jesúspis mayariran. Chaymi ticrarcur, tapuran: «¿Pitaj yataycamasha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chaura purïshijnincuna niran: «Achcaj runa quićhquipaycäshuptiquiga, ¿imanirtaj tapumanqui: ‹¿Pitaj yataycamasha?› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pipis yatashanta musyananpaj Jesús jinalla ricapaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Warmina manchariywan sicsicyaycar, Jesúspa ñaupanman jungurpacuycuran. Imanir yatashantapis llapanta willaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesúsna niran: «Wawallau wawa, yupachicamashayquipita allchacashcanqui. Mana yarpaćhacullarna wasiquiman cuticuy. Mana jishyanquinapishchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús rimayta mana ushyaptillan, Jairupa wasinpita caćhacuna ćhayamuran. Jairuta niran: «Tayta, wamrayqui wañucäcushana. ¿Imapänataj tayta Jesústa pushanquipis?» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mana wiyaj-tucullar, Jesús niran: «Tayta Jairo, ama llaquicuychu. Nuwaman yupachicamanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chaura waquin runacunata jaguiycur, Pedruta, Santiagutawan wauguin Juanta pusharan. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairupa wasinman ćhayarna, atarcaycajcunata tariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chaymi yaycurir, Jesús niran: «¿Imanirtaj atarcaycanqui? Wamra mana wañushachu. Manchäga puñucashalla caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chaynuy niptin, täpajcuna Jesústa asiparan. Jesúsmi ichanga atarcaycajcunata jawaman jarguran. Aya chutarashanman pushashan purïshijnincunatapis, Jairutapis, warmintinta yaycuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ruriman yaycurir maquinpita charircurna, wañush wamra jipashta niran: «Talitá cum.» Rimayninćhüga: «Talitá cum» ninantam: «Ricchayna wamra» nin. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chaynuy niptin, juclla jataricurcuran. Puripacuranna. Chay wamra jipashga ćhunca ishcaywan (12) watatana aywaycaran. Chayta ricar, runacuna juyupa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesúsna runacunata piñacuran: «Cawarishanta pitapis ama willapanquichu. Wamrayquitapis jaray» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaypita aywar, marcanman purïshijnincunawan Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Diyawarda junaj shuntacäna wasićhu willapäcuran. Wiyajcunana tantiyayta mana atipar, tapunacurcaycaran: «¿Mayćhüraj llapanta yaćhacusha? ¿Piraj yaćhachisha? ¿Imanuyparaj Tayta Diosnillanchi camacächishancunata ruran? ");
INSERT INTO qxhNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Cay runa, ¿manachu carpintïru? ¿Manachu Maríapa wamran? ¿Manachu wauguincunapis Santiago, Joset, Judas, Simón? Panincunapis, ¿manachu carcaycan?» nir. Chaynuy nir Jesústa pampaman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesúsna niran: «May-chayćhüpis alli ñawinpa Tayta Diosninchipa willacujninta rican. Yurishan marcaćhümi ichanga marca-masincunapis, yawar-masincunapis pampaman ćhuran. Ricaytapis mana munanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chaymi marcanćhüga Tayta Diosninchi camacächiyninpa imatapis mana rurarannachu. Juc-ishcay jishyaćhucunallata maquinwan yatayllapa allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Marca-masincuna mana ćhasquicuptin, juyupa llaquicuran: «¿Imanirraj mana ćhasquicamanchu?» nir. Chaypita marcan-marcan Tayta Diosninchipa shiminta willapäcur, Jesús puriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ćhunca ishcaywan purïshijnincunata ishcay-caman-ishcay-caman willapäcuj caćharan. Caćhar, niran: «Nuwapita munayniyuj caycanqui supaycunata jargunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Imatapis ama apanquichu. Ama apanquichu jipita, mircapata, jillayta, rucanayquita. Garutillayquita apanqui. Llanguillayquita jaticunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","«Juc wasiman ćhayashpayqui jucläpa aywacushayquicaman jinallanćhu pacharäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ćhayashayqui marcaćhu mana ćhasquishuptiqui, mana wiyashuptiqui, aywacunqui. Ćhaquiquita pichacurir aywacunqui: ‹Mana ćhasquimashayquipita ñacayman ćhayanquipaj› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chaura purïshijnincuna wacpa-caypa aywar, willapäcuran: «Jucha aparicuypita wanacäriy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pucllacuj supaycunatapis jarguran. Jishyaćhucunatapis wirawan jampir, achcajta allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chay wichan mandaj Herodes Jesús ima-imata rurashantapis mayaran. Runacuna wichaypa-uraypa rimar niycaran: «Ushyachicuj Juanćhi wañushanpita cawarircamusha. Chayćhi munayniyuj ricarimusha Tayta Diosnillanchi camacächishancunata rurananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waquinnash nircaycaran: «Willacuj Elíasćhi.» Waquinnash niycaran: «Unay willacujcuna-jinaćhi ricarimusha.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chaura chay rimashancunata mayar, mandaj Herodespis niran: «Rasunpa Juanćhi canga. Umanta quiquï ruguchish caycaptï, cawarimush canga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ushyachicuj Juanta piñacushallanpita quiquin mandaj Herodes unayna mancurnarcachir, carsilman wićhgachish caran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan piñacurunaj: «Tayta Herodes, mama Herodíasga wauguiqui Felipupa warminmi. Wauguiquipa warminta ama jićhunquimanchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chaynuy nishanpita mama Herodías Juanta wañuylla chiquiparan. Wañuchiyta munarpis, mana camäpacuranchu ");
INSERT INTO qxhNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","quiquin mandaj Herodes chapaptin. Payga manchapacuran: «Juanga juchaynaj runam. Tayta Diosninchipa maquinćhu juyan» nir. Chaymi Juan rimashan shungunman mana tincuptinsi, cushish wiyapararan. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Chaura chay wichan mandaj Herodespa diyan ćhayamuran. Chaymi tünata rurar, yaćhänacushancunata, murucuncunapa mandajnincunata, Galilea quinran mayur runacunata jarananpaj jayachiran. Chay junajraj mama Herodías yarpashan camacaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jurpancunawan mandaj Herodes micurcaycaptin, llapanpa ricay ñawinćhu mama Herodíaspa jipashninraj sumaj jachwaran. Jachwar, llapan jurpantinta mandaj Herodesta cushicachiran. Chaymi jipashta mandaj Herodes niran: «Shunguyqui munashanta mañacamay. Munaptiqui, imätapis juycushayquim.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chaynuylla yaparir-yaparir auniran: «Imata mañacamaptiquipis, jushayquim. Marcäcunatapis pullanta juycujmanmi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chaynuy niptin, jipashga mamanta tapuran: «¿Imatataj mañacushaj?» nir. Maman Herodíasna niran: «Ushyachicuj Juanpa umanta mañacuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jipashna juclla mandaj Herodesta niran: «Ushyachicuj Juanpa umanta mañacushayqui. Juclla matiman wiñarcur, macyamay.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Chaura mandaj Herodes juyupa llaquicäcuran. Llaquicursi, jurpancunapa ñaupanćhu aunish cashpan shiminta mana cutiricurannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Manchäga juc murucunta caćharan Juanpa umanta apapunanpaj. Chaymi murucuga carsilman aywarcur, Juanpa umanta ruguriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jinarcur matiwan aparcamur, jipashta juycuran. Jipashna mamanta macyaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaura Juanta wañuchishanta mayar, purïshijnincuna ayanta shuntaycur, pampaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaura Jesús caćhacushancuna cutimuran. Ćhayar, imata rurashantapis, imata yaćhachishantapis willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Parlanacurcaycaptin, achcaj runa ćhayapuran. Chaymi jamaycunanpäpis, micunanpäpis mana jäcuranchu. Chaynuypa caćhacushancunallata niran: «Jucläman aywashun. Yata jamapärishun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chaymi quiquincunalla yata bütiwan chunyaj pachaman aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mayman aywashantapis musyar, chay-tucuy marcapita runacuna ćhaquillapa tariparan. Jesús ćhayaptin, shuyarpaycaranna. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bütipita llucshirir achcaj runata ricar, Jesús llaquiparan: «Cay runacunata pipis mana ricanchu. Ujracash uysha-yupay carcaycan» nir. Llaquipar, sumaj willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pacha chacanaycaptin, purïshijnincuna Jesústa niran: «Chunyaj pachaćhu carcaycanchi. Pachapis chacanaycan. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Runacuna marcacunaman aywacuchun micuyta rantircur micunanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesúsna niran: «Jamcuna jaranquiman.» Paycunana tapuran: «¿Tanta rantimuj aywanätarächu munanqui? Llapanta jarananchipäga ishcay paćhac (200) jurnalpa ćhaninwanrämi tantata rantish aypanga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesúsna tapuran: «¿Ayca tantatataj chararcaycanqui? Mä, ricamuy» nir. Ricaycamurna, niran: «Pichga tantallawan ishcay piscädullam caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaura Jesús niran: «Pashpallaman runacunata shuntaycur-shuntaycur jamachiy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chaymi runacunata jamachiran paćhac-caman (100), pichga ćhunca-caman (50). ");
INSERT INTO qxhNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jinarcur pichga tantatawan ishcay piscäduta aptacurcur, janaj pachaman Jesús ricäriran: «Taytallau Tayta, ima allish tarichillämashcanqui» nir. Nircur tantacunata paquircur-paquircur, ishcay piscädutapis raćhircur-raćhircur, purïshijnincunata macyaran aypucunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Llapan runacuna puchupacushancaman micuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Micurcuptin, purïshijnincuna puchupacushanta ćhunca ishcaywan (12) canista juntataraj shuntaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Micujcunaga ullgucunalla pichga waranga-ima (5,000) caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jinarcur Betsaida chimpapa ñaupacärinanpaj purïshijnincunata bütiman Jesús jigachiran. Runacunatana niran: «Wasiquicunaman cuticäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Llapan aywacuptin, Tayta Diosninchita mañacuj puntaman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pacha chacanaycaptin, purïshijnincuna püsu ćhaupillantaraj aywaycaran. Jesúsmi ichanga paycunawan mana aywaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wayra chapaycaćhaycaptin, büti apayta ñacarcaycashanta Jesús ricaran. Pacha waraycaptillan, yacu janallanpa purïshijnincunata Jesús taripaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Purïshijnincunana yacu jananpa taripaycajta ricärir, mancharir japaćhacäriran: «Alma shaycämun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Llapan manchariran. Jesúsmi ichanga niran: «Ama manchacamaychu. Quiquïmi caycä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chaynuy nir bütiman jigarcuptin, wayrapis ćhawacäcuran. Purïshijnincunam ichanga tantiyacuyta mana atiparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Achcaj runapaj tantata aypächiptinsi, Jesús munayniyuj cashanta mana tantiyacuranrächu. Yarpaynincunapis pishiranraj chucru shungu cashpan. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jatun püsuta chimparir, Genesaret marcaman ćhayaran. Ćhayar, püsu cantunman bütinta wataran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bütipita yarpuriptillan, runacuna Jesústa ricsiriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ricsircur, chay-tucuypa willanacäriran. Chaura Jesús maymanpis ćhayashanman jishyaćhucunata quirmallawan wintuypa ćhayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jatun marcacunamanpis, tacsha marcacunamanpis, ćhacracunamanpis runa juturashanman jishyaćhucunata ćhayachiran: «Tayta Jesús, müdanayquipa cantullantapis yataycachillämay, ari» nir. Yatajcunana änir allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chaura chaypita Jerusalén marcapita fariseucunapis, Moiséspa shiminta yaćhajcunapis Jesúsman shamuran achäquita ashipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ćhayamur Jesúspa purïshijnincuna maquinta awicünilla micurcaycajta ricar, jamurparan: «Tayta Diosninchita mana manchapacunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseucunaga, Israel runacunaga unay auquilluncuna yaćhachicushanta mana jungajchu. Maquinta mana awicullar, imatapis mana micujchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rantipacuj aywashanpita cutimurpis, armacuriycurraj micuj. Cüpatapis, puyñutapis, mancatapis awij, Tayta Diosninchipa ricay ñawinćhu alli cayta munar. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chaymi Fariseucunawan Moiséspa shiminta yaćhajcuna Jesústa tapuran: «¿Imanirtaj purïshijniquicuna auquillunchicuna yaćhachishanta jungaycun? Maquinta awicurinman. Janra maquinwan micur, Tayta Diosninchipa ricay ñawinćhu llutanta ruraycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chaura Jesús niran: «Janan shungulla carcaycanqui. Rasullantaćhari Tayta Diosninchi rimachiptin, willacujnin Isaías unayna niran: ‹Cay runacuna shimillanwan alliman ćhuramaj-tucun. Shungunmi ichanga juccunata manchapacun. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Janan shungulla alliman ćhuraman. «Tayta Diosninchipa shimin alli» nirpis, runa yarpashallanta willapäcun.› ");
INSERT INTO qxhNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Chay-jina jamcunapis Tayta Diosninchipa shiminta jungaycur, runacunapa shimillanta ćharcurcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jananmanpis Jesús niran: «Quiquiquicunapa yaćhacashayquita ruranayqui-cashan Tayta Diosninchipa shiminta jungaycärishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Paypa shiminta musyachicurmi Moisés niran: ‹Mamayqui-taytayquita alli ricanqui. Maman-taytanta ashllijcuna ama cawachunpishchu.› ");
INSERT INTO qxhNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jamcunam ichanga mamayqui-taytayquita mana yanapänayqui-cashan nircaycanqui: ‹Cananga llapan imätapis Tayta Diosninchipa maquinman ćhurashcä. Yanapänajpaj mana puchunnachu.› ");
INSERT INTO qxhNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Pipis maman-taytanta yanapänanta mićharcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yarpashayquita rurar, Tayta Diosninchipa shiminta pampaman ćhurarcaycanqui. Quiquiquicunapa shimillayquita yaćhaycächinqui: ‹Wac-niraj, cay-niraj rurashun› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chaynuy nir llapan runata jayarcur, Jesús niran: «Llapaniqui wiyamay. Shimïta sumaj tantiyacuy. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Shiminchiwan micushanchiga, upushanchiga mana juchata aparicachimanchichu. Shungunchićhu llutanta yarpashanchim ichanga Tayta Diosninchipa ricay ñawinćhüpis jucha aparicuyman ćhayachimanchi. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Rinriyujmi canqui. Tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chaynuy yaćhachicuyta ushyarcur, wasiman yaycuptin, purïshijnincuna tapuran: «Tayta, ¿imanirtaj tincuchiypa yaćhachicushcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chaura Jesús niran: «¿Jamcunapis manachu tantiyacärinquiraj? ¿Runa micushancuna mana juchata aparicachishanta manachu tantiyacunqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Micushanchi mana llutantachu yarpächimanchi. Paćhallaman yaycun. Jinarcur ishpacurinchi.» Chaynuy willapar, micuy mana juchata aparicachishanta tantiyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jananmanpis niran: «Runa shungunćhu yarpashanmi ichanga juchaman ćhayachin. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Shungunćhu yarpaćhacun juchata rurananpaj, warmi-paćha runa-paćha cananpaj, suwacunanpaj, runata wañuchinanpaj, ");
INSERT INTO qxhNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","majanta jananpachinanpaj, yargaj cananpaj, chiquicunanpaj, llullapäcunanpaj, shungun munashallanta rurananpaj, jucpa imantapis munapänanpaj, washata rimananpaj, alli-tucunanpaj, mana tantiyacuj cananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Chaycuna runapa shungunćhu yurimuptin, Tayta Diosninchipa ricay ñawinćhüpis juchata aparicun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaypita aywacur, Tiro marca quinranmanna Jesús ćhayaran. Juc wasiman ćhayar pachacuran ćhayashanta pipis mana musyananpaj. Runacunam ichanga pacharashanta mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Supay pucllacushan warmi wamrapa mamanpis Jesús ćhayashanta mayaran. Juclla ćhayarcur, ñaupanman jungurpacuycuran: «Tayta, yanapaycallämay. Wamräta supay pucllacusha. Allchacaycachipallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chay jäpa warmi Sirofenicia marcapita caran. Griego rimayta rimaj. Wamranpaj Jesústa mañacapuran: «Supayta jarguy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chaura jäpa runacunata allguwan tincuchir, Jesús niran: «Wamracuna micushanta jićhurir allguta jarananchi mana camacanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Warmina niran: «Rasullanta rimashcanqui, Tayta. Allgucunam ichanga wamracuna caćhapacushallantapis micucun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesúsna niran: «Shimiqui allim. Canan cuticuyna, ari. Wamrayquita supay caćhariycushanam.» ");
INSERT INTO qxhNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chaynuy niptin, wasinman cuticuran. Ćhayar, wamranta cämaćhu paucapacuycajta tariran. Supaypis caćhariycushana caran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chaura Sidón-Tiro quinranpita llucshicur, Decápolis marca quinranman ćhayaran. Chay quinran Galilea püsuwan tincuraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chayćhu caycaptin, acllu-acllu rimaj upa runata ćhayachimuran: «Maquiquiwan yataycapallämay. Allchacaycachipallämay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chaynuy mañacuptin, runacunapita carushman ashurcachir, caru-wiyaj runapa rinrinman dïdunta Jesús jatiran. Tuwayninwan jallunta yataycuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Janaj pachapa ricärirna, llaquipar niran: «Efatá.» Rimayninćhu: «Efatá» ninanta: «Quićhacay» ninan. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chaynuy niptin, rinrin wiyaranna. Jallunpis allchacäcuranna. Allina rimaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Runacunatana Jesús niran: «Pitapis ama willapanquichu.» Willacunanta mićhaycaptinsi, shiminta mana chapacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jatunpa cushicushpan nircaycaran: «Llapantapis allitam ruran. Upacunatapis wiyachin. Rimachin.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chay junajcuna achcaj runa shuntacaran. Micunanpaj imapis mana caranchu. Chaymi purïshijnincunata shuntarcur, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Cay runacunata llaquipämi. Quimsa junajna purïshiycämanchi. Micunanpäpis mana canchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Micünillata wasinman-caman caćhaptï, aywaycaptillan, shungunpis ushyacanga. Waquin carupita shamusha.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Purïshijnincunana niran: «Chunyaj pachaćhu carcaycanchi. ¿Cayćhu tantata tarishuwanchuraj?» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesúsna tapuran: «¿Ayca tantatataj chararcaycanqui?» nir. Tapuptin, niran: «Janćhis tantallata.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chaynuy niptin, llapan runata pampallaman Jesús jamachiran. Janćhis tantata aptarcurna, Tayta Diosninchita niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur paquircur-paquircur, purïshijnincunata macallaran runacunata aypunanpaj. Paycunana llapan runata aypuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ishcay-quimsa acapa piscäducunatapis charaycaran. Chay piscäducunatapis aptarcur, niran: «Ima allish tarichillämashcanqui, Tayta.» Jinarcur aypucachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Runacunana puchupacushancaman micupacäriran. Puchupacushanta shuntaptin, janćhis canista juntataraj puchuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Micujcunaga ćhuscu waranga-ima (4,000) caran. Micucurcuptinna, llapan runata Jesús niran: «Wasiquicunaman cuticäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jinarcur purïshijnincunawan bütiman jigarcur, Dalmanuta quinranman chimparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chaura fariseucuna ćhayaycur, Jesústa achäquita ashiparan. Tincupar niran: «Tayta Diosninchi camacächiyninpa mä, imallatapis ruray.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chaura llaquicushpan wiyächipaypa Jesús niran: «¿Imanirraj achäquita ashipämaj shamunqui? Sumaj tantiyacunquiman. Tayta Diosninchi camacächiyninpa imallatapis ruranäta munaptiquisi, mana imatapis rurashächu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chaymi fariseucunata jaguiycur, bütiwan chimpaman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesúspa purïshijnincuna micuy apayta jungaycäriran. Juc tantallata bütićhu apaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aywarcaycashanćhu Jesús piñaparan: «Fariseucunapa, mandaj Herodespa libadüranta ama ćhasquipanquichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Purïshijnincunana quiquin-puralla parlanacäriran: «Tantata mana apamushanchipitaćhi wiyächipaycämanchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tapunacuycashanta musyar, Jesús niran: «¿Imanirtaj: ‹Tanta mana canchu› ninacurcaycanqui? Ricaycarpis, ¿manachu tantiyacunquiraj? ¿Chucru shunguchu canqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tantata aypächishäta ricaycarpis, japra-nirajmi carcaycanqui. Tayta Diosninchipa shiminta willacuycaptïpis, upa-nirajmi carcaycanqui. ¿Llapanta jungashcanquichuraj? ");
INSERT INTO qxhNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Imanirtaj pichga tantallata pichga waranga (5,000) runacunapaj aypächishäta manachu yarparanqui? Chay junaj, ¿ayca canistatataj puchupacushanta shuntarayqui?» Purïshijnincunana niran: «Ćhunca ishcaywanta.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Janćhis tantata ćhuscu waranga (4,000) runacunapaj aypächishäpita, ¿ayca canista juntatataj shuntarayqui?» Paycunana: «Janćhistam» niran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesúsna niran: «Chaycunata ricaycarpis, ¿manachu tantiyacärinquiraj?» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaypita Betsaida marcaman ćhayaran. Chayćhu carcaycaptin, japra runata ćhayachimuran: «Maquiquiwan yataycapallämay. Allchacaycachipallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chaura maquinpita charicurcullar, marca wajtanman Jesús pusharan. Ñawinćhu tuwapuran. Maquinwan yataran. Nircur tapuran: «¿Imallatapis ricanquichu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Rama-ramalla ricashpan: «Runacunata yüra-niraj puriycajta ricä» niran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yapay maquinwan yatarcuptin, sumaj ricaćhacurishanćhu allina ricaran. Ñawin allchacäcuranna. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesúsna niran: «Marcaman mana yaycullar wasiquiman cuticuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaypita Cesarea Filipo marca quinranman purïshijnincunawan Jesús aywaran. Aywarcaycashanćhu purïshijnincunata tapuran: «Runacunapäga, ¿pitaj caycä?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chaura niran: «Waquin runash nin: ‹Ushyachicuj Juan.› Waquinnash: ‹Elías› nin. Waquinnash: ‹Pï carpis, Tayta Diosninchipa willacujnin canga› nin.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chaura quiquincunata Jesús tapuran: «Jamcunapäga, ¿pitaj caycä?» nir. Pedruna niran: «Washäcujmi canqui. Tayta Diosninchi caćhamushcashunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chaura mana willacunanpaj Jesús sumaj willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaypita purïshijnincunata Jesús niran: «Tayta Diosninchi caćhamasha. Chaypis sumajraj ñacashaj. Mayur runacunapis, mayur cüracunapis, Moiséspa shiminta yaćhajcunapis wasguimanga. Juyupa ñacachimanga. Wañuchimanga. Chaypis quimsa junajta Tayta Diosninchi cawarachimanga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chaynuy nir mana chapacullarna willapäcuran. Pedruna yata jayarcur, piñacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Chaura Jesúspis waquin purïshijnincunaman ricärir, ullgüparan: «Pedro, Supaymi canqui. Washata ayway. Chapata ama ruramaychu. Tayta Diosninchipa shiminta ćharcunäta mićhaycämanqui. Imatapis munapashayquita runacunalla ashin. Tayta Diosninchipa shungun yarpashanwanmi ichanga mana tincunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chaypita llapan juturajcunatapis, purïshijnincunatapis jayarcur, Jesús niran: «Pipis purïshimayta munar, quiquinpa shungun munashanta ama ruranmanchu. Manchäga nuwa-janan ñacachiptinsi, rusćhu wañuchiptinsi, shimïta wiyacuchun. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ñacaytapis, wañuytapis manchacur maquïćhu puriyta mana munar, ushyacayman ćhayangapaj. Maquïćhu purir llapanninta jaguijcunam ichanga, alli willacuynïta wiyacujcunam ichanga, imaycamanpis Tayta Diosninchipa maquinćhu cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","«Sumaj rïcuyayta tarirpis ushyacayman ćhayaptin, rïcu cayninga, ¿imapäraj alli? ");
INSERT INTO qxhNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Rïcu cayninga Tayta Diosninchipa ñaupanman ćhayachingachuraj? ");
INSERT INTO qxhNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","«Tayta Diosninchi caćhamasha. Pipis shimïta mana wiyacuptin jananpachicuj car, juchaćhu arujcunapa ñaupanćhu wasguimaptin, nuwapis janaj pachapita achic-achicyaycar cutimur wasguishämi. Cutimuptïga, Tayta Diosninchipa anjilnincunapis achic-achicyaycar yanagämanga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jananmanpis Jesús niran: «Sumaj tantiyacunquiman. Tayta Diosninchi munayniyuj cashpan llapan runata maquinćhu purichinga. Chayta waquinniquipis manaraj wañullarmi ricanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chaypita sujta junajta Pedruta, Santiaguta, Juanta pushacurcur puntaman Jesús jigaran. Puntaćhu quimsan purïshijnincunalla ricapaycaptin, achic-achicyaycajman Jesús ticracuriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Müdananpis llutpi utcunuy achicyaypa achicyacurcuran. Chaynuy pï tacshacurpis, mana yurajyächinchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Unay willacuj Elíaswan Moiséspis ricariparcur, Jesúswan parlaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Chaura purïshijnincuna juyupa mancharicäcuran. Rimapacuytapis mana camäpacuranchu. Chaypis Pedro sumaj mana yarpaćhacullar niran: «Tayta Jesús, cayćhüga alli juyäcuymi. Quimsa tacmata rurarishaj: jucta jampaj, jucta Moiséspaj, jucta Elíaspaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaynuy ricapaycaptillan, quimsanta pucutay chapacurcuran. Pucutay rurinpitana Tayta Diosninchi nimuran: «Jesúsga cuyay Wawämi. Shiminta wiyacuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Purïshijnincunana ricaćhacurishanćhu quiquillanta Jesústa ricaran. Waquin mana carannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Puntapita yarpaycämushanćhu purïshijnincunata Jesús willaparan: «Tayta Diosninchi caćhamasha. Canan ricashayquita pitapis ama willapanquichu wañushäpita manaraj cawarimushäcaman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Quimsan musyajcuna pitapis mana willaparanchu. Ichanga quiquin-puralla parlanacäriran: «¿Imanuyparaj wañushanpita cawarimunga?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chaynuy niptin, paycuna tapuran: «¿Imanirtaj Moiséspa shiminta yaćhajcuna willacun: ‹Elías shamushanpitaraj Washäcuj shamunga› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chaura Jesús niran: «Au, rasunpa Elías cutimur, runacunata anyapanga Tayta Diosninchipa shungun munashannuy cawananpaj. Chaypis Tayta Diosninchipa shimin isquirbirashanćhu nin: ‹Tayta Diosninchipa caćhan captinsi, Washäcujta runacuna ñacachinga. Pampaman ćhurar, wasguingapaj.› ");
INSERT INTO qxhNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Chaypis tantiyacunquiman. Elías mayna shamusha. Paytapis Tayta Diosninchipa shiminćhu isquirbirashan-jina tucuyta rurasha. Juyupa ñacachisha.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chaura waquin purïshijnincunaman cutir, achcaj runa juturpaycajta tariran. Purïshijnincunana Moiséspa shiminta yaćhajcunawan tincupänacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesústa ricar, wamayar juclla tariparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chaura Jesús tapuran: «¿Imapitataj tincupänacurcaycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Juc runana ćhaupipita nimuran: «Tayta, supay upayächishan wamräta apallämushcä. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Charir, mayćhüpis sajtar ushyan. Lausallana shiminpita aycun. Quirunta caćh-caćhyaylla ućhun. Uyutacäcun. Waquin purïshijniquicunata mañacurä supayta jargunanpaj. Ichanga mana camäpacuranchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesúsna niran: «Jamcuna Tayta Diosninchiman mana yupachicunquichu. ¿Imaycamanraj tantiyachishayqui? Mana yupachicamaptiquim, yamacashcäna.» Wamrapa papänintana niran: «Wamrayquita mä, apamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chaura apapuptin Jesústa ricärir, supay wamrata sajtar ushyariran. Chaymi wamra jućhpacaćharanraj. Lausallata ajturan. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chaura wamrapa papäninta Jesús tapuran: «¿Imaypita-pachanataj jishyan?» nir. Tapuptin, niran: «Mallwa cashanpita-pacha. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Achca cutina wañuchiyta munar, ninamanpis, yacumanpis jitarpuran. Tayta, camäpacur, llaquipaycallämay. Yanapaycallämay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chaura Jesús niran: «¿Imanirtaj: ‹Camäpacur, yanapaycallämay› nimanqui? Tayta Diosninchiman yupachicuptinchi, paymi llapantapis camacächin.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chaura wamrapa papänin juclla niran: «Payman yupachicümi. Sumaj yupachicunäpaj yanapaycallämay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chay-chicaj runa jutucarcaycajta ricar, Jesús supayta piñacuran: «Upayächicuj supay, cay wamrata caćhariy. Imaypis ama cutimuynachu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chaura wamrata caćhariycuran. Sajtar ushyarir, japarir, supay aywacuran. Wamraga wañush-jina jitacäcuran. Chutaraycajta ricar, waquin runacuna: «Wañucäcushanam» ninacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Maquinpita Jesús chutariptinmi ichanga, wamra ićhicurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaypita juc wasiman Jesús yaycuran. Purïshijnincunana pacayllapa tapuran: «¿Imanirtaj nuwacuna supayta jarguyta mana camäpacushcächu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chaura niran: «Chay-niraj supayta Tayta Diosninchita mañacurraj jargunchi.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chaypita Galilea quinranpa Jesús aywaycaran. Pipis musyananta mana munaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Manchäga purïshijnincunallata tantiyachir niran: «Tayta Diosninchi caćhamasha. Chaypis juc runa charimar, juyu runacunapa maquinman ćhayachimanga. Paycunana wañuchimanga. Quimsa junajtam ichanga cawarimushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Purïshijnincunam ichanga tantiyayta mana atiparanchu. Tapucuytapis manchacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chaypita Cafarnaún marcaman ćhayaran. Wasinman yaycurir, purïshijnincunata Jesús tapuran: «¿Imanirtaj tincupänacushcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tapuptin, llapan upällacaycäriran. Aywaycashanćhu mayna tincupänacush caycaran: «¿Mayganchiraj mayur cayman ćhayashun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaymi Jesús ćhunca ishcaywan purïshijnincunata niran: «Pipis mayur cayta munar, jipata purij cachun. Llapanpa mandu-rurajninraj cachun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jinarcur llapanpa ricay ñawinćhu wamrata jayarcur margacurcur, ");
INSERT INTO qxhNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","niran: «Yupachicamashan-janan wamracunata alli ricajcuna nuwatapis alli ricaman. Nuwata alli ricamar, caćhamaj Tayta Diosninchitapis alli rican.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jinarcur Juan niran: «Tayta, nimashayquinuylla supayta jarguycajta ricapäcushcä. Chaypis mana purïshimaptinchi, mićhapäcushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesúsna niran: «Ama mićhanquimanchu. Pipis yupachicamashan-janan Tayta Diosnillanchi camacächishancunata rurar, mana ashllimangachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mana chiquimashpanchi yanapaycämanchi. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pipis: ‹Washäcuj Jesúspa purïshijnin canqui› nir yacullatasi macyaycushuptiqui, Tayta Diosninchipis alli ricar ayninta cutichinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Wamra-jina llapan shungunwan nuwaman yupachicamajcunata juchaman janćhajcuna wañuyman ćhayachun. Jatun-caray marayta cuncanman wallgaparcur yacu ruri-ruricaman wicaparinman. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","«Maquiqui juchata aparicachishuptiqui, muturinquiman. Ishcay maquiyuj caycar chacaj pachaman aywanayquipita alli canman juc-caj maquiyujlla cawaptiqui. Chacaj pachaćhu nina imaypis mana upingachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ćhaquiqui juchata aparicachishuptiqui, muturinquiman. Ishcay ćhaquiyuj caycar chacaj pachaman aywanayquipita alli canman juc-caj ćhaquiyujlla cawaptiqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ñawiqui juchata aparicachishuptiqui, ujtirinquiman. Ishcay ñawiyuj caycar chacaj pachaman aywanayquipita alli canman juc-caj ñawiyujlla manchapacur cawaptiqui. Tayta Diosninchita manchapacur, maquinćhu cawachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‹Chacaj pachaćhu aycha curucuna mana wañunchu. Ninapis mana upinchu.› ");
INSERT INTO qxhNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Pitapis juchaman janćhajcunata llapantam illararachinga caćhi ruparishan-jina. ");
INSERT INTO qxhNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Caćhipis sumaj alli. Puchguynin illariptinmi ichanga, ¿yapay puchguyninman cutichinquimanchuraj? Mana. Chaymi caćhi alli cashan-jina jamcunapis Tayta Diosninchipa shungun munashannuylla cawanquiman. Alli ricanacur, juc shungulla cawanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cafarnaún marcapita Judea quinranman aywacur, Jordán mayuta Jesús chimparan. Chayćhu achcaj runa jutucaptin, imaypis yaćhachicushannuylla yaćhachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Waquin fariseucuna achäquita ashipar, Jesústa tapuran: «¿Runa warminpita raquicänan camacanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesúsna tapuran: «Moiséspa shimin, ¿imanirantaj?» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseucunana niran: «Paymi auniran: ‹Actaman jamaycachir, warmiquiwan raquicar, jargurinquiman› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesúsna niran: «Chucru shungu captiqui shiminta isquirbir, raquicänayquita Moisés auniran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Chaypis cay pachata camashan wichan Tayta Diosninchi warmitapis, ullgutapis ruraran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Runa warmita ashir, maman-taytanpa maquinpita llucshicunman. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Warmillanwan juyar, ujllaränacun juc shungulla cawananpaj. Ishcaj cashpansi juc shungulla cawan. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chaymi Tayta Diosninchi majachacächishanta runa mana raquicächinmanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chaura wasiman ćhayar, purïshijnincunapis Jesústa tapucuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tapucuptin, Jesús tantiyachiran: «Juc runa majanta jaguiriycur juc warmiwan majachacarga, juchata aparicun. Unay-caj warminta jananpaycächin. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Juc warmipis majanta jaguiriycur juc runawan majachacarga, juchata aparicun. Unay-caj majanta jananpaycächin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Waquin runacunana Jesúsman ćhayaran: «Yataycur mallwa wamräcunapaj Tayta Diosninchita mañacapamay, ari» nir. Wamracunata ćhayachijta ricarmi ichanga, purïshijnincuna piñacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mićhaycajta ricar, Jesús piñacuran: «Ama mićhaychu. Wamracunata apamuchun. Shacamuchun. Wamra alli shungu cawashan-jina alli shungu runacunalla Tayta Diosninchiman yupachicushpan maquinćhu cawan. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sumaj tantiyacunquiman. Tayta Diosninchipa maquinćhu cawanayquipaj wamracuna-jina wiyacunquiman. Manchäga maquinćhu mana cawanquipächu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesúsna wamracunata margarcur-margarcur, umanta maquinwan yataycur-yataycur mañacapuran: «Taytallau Tayta, cay wamracunata sumaj yanapaycullay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chaypita Jesús aywacunanpaj caycaptin, juc runa juclla ćhayarcur, jungurpacuycur tapuran: «Alli Tayta, ¿imatataj ruräman Tayta Diosninchipa ñaupanćhu imaycamanpis cawanäpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsna niran: «¿Imanirtaj: ‹Alli› nimanqui? Tayta Diosnillanchi alli. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Paypa shiminta musyanqui. Ama wañuchicunquichu. Majayquita ama jananpachinquichu. Ama suwacunquichu. Runa-masiquita ama tumpanquichu. Ama llullapäcunquichu. Mamayqui-taytayquita alli ricanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chaura niran: «Tayta, wamra cashäpita-pacha chaycunata llapallantam ćharcushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaynuy niptin, alli ñawinpa ricapärir, Jesús niran: «Jucrämi pishïshunqui. Llapan imayquicunatapis ranticuycur pishipacujcunata aypurir, purïshimay. Chayrämi imaycamanpis Tayta Diosninchipa maquinćhu cawanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chaynuy niptin, runapa shungun ishquicäcuran. Puchuy-puchuy jananćhu juyashpan juyupa llaquish aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chaura Jesús ricaćhacurir, purïshijnincunatana niran: «Puchuy-puchuy jananćhu cawajcuna Tayta Diosninchipa maquinćhu cawananpaj sumaj sasa.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Niptin, purïshijnincunapis mancharicäcuran. Chaymi Jesús niran: «Wawacuna, Tayta Diosninchipa maquinćhu cawayga sumaj sasa. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","‹Camïllu› nishan jatun-caray uywa aujapa ñawinpa ushtuyta mana jushan-jina puchuy-puchuy jananćhu cawajcunapis Tayta Diosninchipa maquinćhu cawayta mana junchu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chaynuy niptin, purïshijnincuna juyupa mancharicäcuran: «Chaynuy captin, ¿piraj Tayta Diosninchipa ñaupanman ćhayanga? ¿Piraj jishpichish canga?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Llapanta ricapärir, Jesús niran: «Runacunaga ushyacajllam. Chaymi alli cawarpis, sasächicun. Tayta Diosninchipämi ichanga imapis mana sasachu. Payga munayniyujmi pitapis ñaupanman ćhayachinanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedruna niran: «Tayta, nuwacuna llapan imäcunatapis jaguiycurmi, purïshiycaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesúsna niran: «Sumaj tantiyacunquiman. Pipis nuwa-raycur, Tayta Diosninchipa alli willacuyninta willapäcunan-raycur wasinta, mayurnincunata, shullcancunata, mamanta, taytanta, wamrancunata, ćhacrancunata jaguiycujga ");
INSERT INTO qxhNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cay pachaćhu paćhac (100) janapaytam taringa. Ñacash caycarsi, wasincunata, mayurnincunata, shullcancunata, mamancunata, wamrancunata, ćhacracunatapis taringa. Tayta Diosninchipa ñaupanman ćhayarpis, mana ushyacaj cawaytapis taringa. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ima captinpis, sumaj tantiyacunquiman. Cay pachaćhu achcaj runa alli ricash captinsi, Tayta Diosninchipa ñaupanman ćhayar, mana alli ricashnachu canga. Waquincunatam ichanga Tayta Diosninchi alli ñawinpa ricanga runa-masin pampaman ćhurash captinsi.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chaura Jerusalén marcaman Jesús wichaypa ñaupaptin, purïshijnincunapis mancharish aywaycaran. Waquin jatirajcunapis mancharish aywarcaycaran. Chaura ćhunca ishcaywan purïshijnincunallata shuntarcur, imamanpis ćhayananta willar, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Jerusalén marcaman aywaycashanchita musyanqui. Tayta Diosninchi caćhamasha. Chaypis waquin runacuna mayur cüracunapa maquinman, Moiséspa shiminta yaćhajcunapa maquinman ćhayachimanga. Paycunaga wañuyman jitarpamanga. Wañuchimänanpaj jäpa runacunapa maquinman ćhayachimanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jäpa runacunana pampaman ćhuramanga. Tuwapamanga. Wascamanga. Wañuchimanga. Wañuchimaptinsi, quimsa junajta cawarimushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chaura Zebedeupa wamran Santiaguwan Juan Jesúsman ashurcur niran: «Tayta, mañacushäta aunimay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chaura Jesús tapuran: «¿Imaćhütaj yanapäshayqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tapuptin, niran: «Tayta, mayur mandaj cayman ćhayar, nuwacunatapis mandäshinajpaj ćhuramay. Jucnïta dirïcha-caj läduyquiman jamachimay; jucnïtana isquirda-caj läduyquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesúsna niran: «Imata mañacaycämashayquitapis mana musyanquichu. Tapushayqui. Juyupa ñacarcachir wañuchimashan-jina rurashuptiqui, ¿ićhipunquimanchuraj?» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Paycunana niran: «Au. Ićhipushämi.» Jesúsna niran: «Rasunpam ñacashä-jina ñacanquipaj. Wañushä-jina wañunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Chaypis mandäshimänayquipaj ćhuranaj mana camacanchu. Chaytaga Tayta Diosnillanchi camacächisha. Paymi acracushancunata dirïcha-caj lädümanpis, isquirda-caj lädümanpis jamachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiaguwan Juan mañacushanta wiyar, ćhuncaj purïshij-masincuna ullgucaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chaura llapanta jayaycur, Jesús niran: «Jäpa runacuna juc-niraj cawashanta musyanqui. Paycuna Tayta Diosninchita mana manchapacunchu. Mayur auturdänincunapis ullgurcur-ullgurcur, nishan-nishan marca-masincunata imatapis rurachin. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jamcunam ichanga chaynuy ama canquimanchu. Munayniyuj cayta munar, llapantaraj yanapanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mandaj cayta munar, llapanpa manduntaraj ruranquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tayta Diosninchi caćhamasha. Chaypis mana munayniyuj cayta ashirchu shamushcä; manchäga pï-maytapis yanapänäpaj. Tayta Diosninchipa maquinćhu cawananpämi cawaynïpa ćhaninwan may-may runata jishpichishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chaypita Jericó marcaman ćhayaran. Marcapita purïshijnincunawan Jesús aywacuptin, runacunapis achcajmi aywäshiran. Caminu wajtallanćhu Timeupa wamran japra Bartimeo mañapacuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazaret runa Jesús aywaycashanta wiyar, sumaj jayacuran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Runacunana ullgüparan: «Upälla» nir. Chaypis callpacuycurraj jayacuran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ićhiycur, japrata Jesús jayachiran. Jayajcunana Bartimeuta niran: «Ama manchacuychu. Jucllash aywanqui. Jayaycäshunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chaura jacunta jitariycur, juclla Jesúsman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ćhayaptin, Jesús tapuran: «¿Imallaćhütaj yanapäshayqui?» nir. Japrana niran: «Tayta, ñawï ricananta munä.» ");
INSERT INTO qxhNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chaura Jesús niran: «Cuticuyna. Yupachicamashayquipita allchacashcanqui.» «Allchacashcanqui» niptin, rasunpa ricaran. Ricar, Jesús aywashanpa aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén marcaman Jesús yaycupaycar, Betfagé marcaman, Betania marcaman ćhayaycaran. Chay marcacuna quinranćhu Ulïbus punta caran. Ishcaj purïshijnincunata caćhar, Jesús ");
INSERT INTO qxhNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","niran: «Wac chimpa tacsha marcaman aywariycuy. Ćhayar, manta büruta tarinquipaj. Pipis mana muntacunrächu. Watarashanpita pascarir, apacamunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pascaycaptiqui pipis mićhäshuptiqui, ninqui: ‹Mandamajnïtash mañanqui. Cutirachipamushayqui.› » ");
INSERT INTO qxhNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chaynuy niptin, purïshijnincuna aywaran. Ćhayar, wasi puncućhu büru wataraycajta tariran. Pascapacuycaptin, ");
INSERT INTO qxhNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","waquin runa tapuran: «¿Imapätaj büruta pascaycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chaura Jesús nishanta willaptin, mana mićharannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chaura büruta Jesúsman aparan. Jacuncunata shawaparcur, Jesústa muntachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bürun muntash Jesús aywaycaptin runacuna cushicuywan jacuncunatapis, jaćhapa rämancunatapis caminuman mashtapuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesúspa jipanta-ñaupanta aywajcunapis cushicushpan japarpararan: «Taytallau Tayta, washaycallämay, ari. Tayta Diosninchi caćhamushan runa alli ricash caycullächun. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ima allish unay mandaj David mandashan marcata jatarachinanpaj shamusha. Janaj pachaćhu cawaj Tayta Diosninchita alliman ćhurayculläshun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalén marcaman Jesús ćhayarna, Tayta Diosninchipa wasinman yaycuran. Sumaj ricapacurir pacha chacanaycaptinna, Betania marcaman ćhunca ishcaywan purïshijnincunawan-ima cuticäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Warannin Betania marcapita Jesús llucshiptin, yargay chariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Carushnijćhu jïguspa yüran birdiraycajta ricäriran. Chaymi wayuynin ashij aywaran. Ćhayar, wayuyninta mana tariranchu. Wayunan wichan mana ćhayamuptinraj, üjallanta tariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chaymi jïgus yürata Jesús niran: «Cananpita mana wayunquipänachu. Wayuyniquita pipis mana imaysi micunganachu.» Wiyächipaypa nishanta purïshijnincunapis wiyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalén marcaman ćhayar, Tayta Diosninchipa wasinmanna Jesús aywaran. Wasinpa sawanninpita ranticujcunatapis, rantipacujcunatapis jarguran. Jillay rucapacuj runacunapa mïsancunatapis jillaynintinta sajtar ushyaran. Paluma ranticujcunapa jamanancunatapis wicapar ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tayta Diosninchipa wasinpa sawanninćhu ima-imata rantipaj purichinantapis mićharan. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Llapanta wicapar, runacunata tantiyachiran: «Tayta Diosninchipa shiminćhu nin: ‹Wasïga chay-tucuy marcapita sharcamur mañacamajcunallapämi.› Jamcunam ichanga suwapa maćhayninman ticrachishcanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Allita willapäcuptin, runacuna Jesústa alliman ćhuraran. Payta manchapacuranna. Chaymi mayur cüracunawan Moiséspa shiminta yaćhajcuna mancharicäcushpan Jesústa imanuypa wañuchinanpäpis ashiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pacha chacanaycaptinna, marcapita purïshijnincunawan Jesús aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Warannin tuta aywar, jïgus yüra sapincaman chaquiraycajtana ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chaura Jesús nishanta yarpärir, Pedro niran: «Tayta, mä, ricay. Chapata rurashayqui jïgus yüra chaquicäcusha.» ");
INSERT INTO qxhNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsna niran: «Imatapis mañacur, Tayta Diosninchiman sumaj yupachicuy. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sumaj tantiyacunquiman. Yupachicurga, tagay puntatapis ninquiman: ‹Caypita yacu püsuman jigacurpuy.› Llapan shunguyquiwan yupachicur niptiqui, änirmi tagay punta yacuman jigacurpungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tayta Diosninchita mañacur llapan shunguyquiwan yupachicur, mañacushayquita ćhasquinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tayta Diosninchita mañacuycashayquićhu pitapis jagayächishayquita yarpärir, wanacuy. Llapanta jungay. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chaynuypa janaj pachaćhu tiyaj Tayta Diosninchipis llapan jucha aparicushayquita jungangapaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chaypita Jerusalén marcaman cutircur, Tayta Diosninchipa wasin puncunćhu Jesús puriycaptin, mayur cüracuna, Moiséspa shiminta yaćhajcuna, mayur runacunapis ");
INSERT INTO qxhNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tapuran: «¿Pitaj caćhamushcashunqui? ¿Pipa munayninwantaj imacunatapis ruraycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsna niran: «Nuwapis mä, tapucushayqui. Willamaptiqui, pï caćhamashantapis willashayqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juanta ushyachicunanpaj, ¿pitaj caćhamusha: Tayta Diosninchichu, runa-masillanchu? Mä, willamay. Willamaptiqui, willashayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chaura quiquin-pura parlanacäriran: « ‹Tayta Diosninchi caćhamusha› niptinchi: ‹¿Imanirtaj mana wiyacushcanquichu?› nimäshun. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹Runa-masinchicunalla caćhamusha› niytapis mana camäpacunchichu.» Runacunaga Ushyachicuj Juanta ćhasquicush caran: «Tayta Diosninchipa willacujninmi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chaymi Jesústa niran: «Tapumashayquita mana musyächu.» Chaura Jesúspis niran: «Mana camäpacuptiqui, pï caćhamashanta nuwapis mana willashayquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chaura tincuchiypa willapäcur Jesús niran: «Juc ćhacrayuj runash übasta mururan. Ushyaypash pirgaran. Übasta japchinanpäpis püsutash ruraran. Ćhacranta täpananpänash türi wasita pirgachiran. Jinarcur ćhacra runacunata allimshaycurshi, juclä marcapa aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Übas pallay ćhayamuptin, uywaynintash caćhacuran: ‹Dirïchüta shuntamuy› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Caćha ćhayaptin allimshacuj runacuna sumaj magaraycärirshi, jinallata jarguriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chaura ćhacrayuj juc uywaynintanash caćhacuran. Paytapis sajmaycällarshi, umanta raćhipariran. Ashllir ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chaura ćhacrayuj juc uywaynintanash caćhacuran. Paytapis wañuycachiran. Chaypis ćhacrayuj runa achcajtaräshi caćhacuran. Paycunatapis waquintash magaran. Waquintanash wañuycachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Chaypita jucsi caycasharäshi caćhacunanpaj. Yarpaćhacuriycurshi, cuyay wawanta caćhacuran: ‹Quiquïpa wamräta manchapacungam› nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ćhacrayujpa wamranta ricarshi ichanga, allimshacujcuna quiquin-puralla parlanacäriran: ‹Tagay wamrallanpämi llapan imancunatapis papänin jaguipaycunga. Chaymi wañurachishun. Chaura cay ćhacra nuwanchipaj canga.› ");
INSERT INTO qxhNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chaynuy nirshi, ćhacrayujpa wamranta charipäcuran. Wañuycachiran. Ayantanash ćhacranpita wicapariran.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Willapariycur, Jesús tapuran: «Canan mä, willamay. Ćhacrayuj cutimur, ¿imataraj ruranga chay ćhacra runacunata? Chay ćhacra runacunata wañurachinga. Ćhacrantapis juctana allimshacunga. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Tayta Diosninchipa shiminta manachu liguishcanqui? Shiminćhu niycan: ‹Wasi rurajcuna: «Cay rumi mana allichu» nir wicapashantapis Tayta Diosninchi simintuta jallarachinanpaj ćhurasha.› ");
INSERT INTO qxhNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chaytaga quiquin Tayta Diosninchi camacächisha. Chaypitam cushicurcaycanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mayur cüracunawan yaćhajcuna wiyächipaycashanta tantiyacuriran. Chaymi Jesústa juclla chariyta munaran. Ichanga achcaj runa juturpaycaptin, mana chariranchu. Runacunata manchacuran. Chaymi jaguiycur aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaypita fariseucuna achäquita ashipashpan ishcay-quimsa fariseu-masincunatawan mandaj Herodespa purïshijnincunata Jesúsman caćharan. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jesúsman ćhayar, paycuna niran: «Tayta, alli shungu cashayquita musyä. Pitapis Tayta Diosninchipa shimillanta willapanqui. Llapan runata alli ricanqui. Chaymi tapucushayqui. ¿Mandaj Césarpaj jillayta ćhurashuwanchuraj, manachuraj? ¿Ćhurananchi camacanchuraj, manachuraj?» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesúsmi ichanga achäquita ashipashanta musyar, niran: «¿Imanirtaj maquichacamayta munarcaycanqui? Jillayniquita mä, ricachimay.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chaura jillayta apapuran. Jesúsna tapuran: «Jillayćhu, ¿pipa liträtuntaj caycan? ¿Pipa jutintaj isquirbiraycan?» nir. Paycunana niran: «Mandaj Césarpa.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesúsna niran: «Mandaj Césarpata Césarpaj ćhuray. Tayta Diosninchipata Tayta Diosninchipaj ćhuray.» Niptin, mancharishpan ima rimapacuytapis mana camäpacurannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaypita saduceu runacunana Jesúsman ćhayaran. Paycuna yarpaj: «Wañushcuna mana cawaringapächu» nir. Chaymi Jesústa niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Tayta Jesús, Moiséspa shiminćhu nin: ‹Runa wañucur warminta wawaynajllata jaguiptin, wañucuj runapa wauguillan biyüdawan majachacanman. Mushuj majanwan wamrata tarishanna wañucuj runanpa jutinta apanga.› ");
INSERT INTO qxhNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Canan mä, tapucushayqui. Janćhis wauguish caran. Juc wauguish warmiwan majachacaran. Ichanga warminta mana mirachillarshi wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chaura juc-caj wauguinnash warmiwan majachacaran. Ichanga mana mirachillarshi wañucuran. Chaynuyllash juc wauguiwan, juc wauguiwan majachacasha. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Juc warmillawan majachacarcur-majachacarcurshi, chay janćhis waugui wañucuran. Ichanga mayganpis warmita mana mirachillarshi, wañucuran. Llapan wañushanpa jipantaräshi warmipis wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tayta, mä, willamay. Wañushanpita cawarircamur, chay warmi, ¿maygan wauguipa warmintaj canga janćhiswan majachacash caycar? ¿Llapanpa warminchuraj canga?» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesúsna niran: «Jamcuna llutanta yarparcaycanqui. Tayta Diosninchipa shimintapis, munayniyuj cashantapis mana tantiyanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cawarimuj runacuna mana majachacanganachu. Anjilcuna-jina mana ushyacanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wañushcuna cawarimunanta mayna Moisés musyachicuran, ¿au? Isquirbirashan librućhu nin: ‹Shira-shiraćhu Tayta Diosninchi niran: «Moisés, unay auquilluyqui Abraham, Isaac, Jacob wañush carsi, cawaycan. Tayta Diosnin caycaptï, manchapacaycäman.» › ");
INSERT INTO qxhNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tayta Diosninchita cawajcunalla manchapacun; mana wañushcunachu. Chaymi jamcuna llutanta yarparcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tapupajcunata tantiyachishanta wiyarmi Jesúsman ashurcur, Moiséspa shiminta yaćhaj runana tapucuran: «Tayta, llapan yaćhachicuycunapita, ¿maygantaj allicaj yaćhachicuy?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chaura Jesús niran: « ‹Israel runacuna, wiyacäriy. Tayta Diosninchi jucnayllam. Juc mana canchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Llapan shunguyquiwan Tayta Diosninchita manchapacäriy.› ");
INSERT INTO qxhNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jananmanpis: ‹Quiquiqui alli ricacushayqui-jina runa-masiquitapis alli ricanquiman.› Cay ishcan yaćhachicuypita mas allicajga mana cannachu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chaura Moiséspa shiminta yaćhaj runa niran: «Allim, tayta. Rasullanta rimashcanqui. Rasunpa jucnaylla Tayta Diosninchi. Juc mana canchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Llapan shungunchiwan Tayta Diosninchita manchapacushun. Quiquinchi alli ricacushanchi-jina runa-masinchitapis alli ricashuwan. Chaura Tayta Diosninchi alli ricamäshun cuyachicuyninchita, jaracuyninchita mana ćhuraptinchisi.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chaura yaćhaj runa allita rimashanta wiyar, Jesús niran: «Tayta Diosninchipa maquinćhu-yupayna cawaycanqui.» Chaynuy nishanpita pipis mana tapuparannachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chaura Tayta Diosninchipa wasinćhu willapäcuycashanćhu Jesús niran: «¿Imanirtaj Moiséspa shiminta yaćhajcuna riman: ‹Washäcujga unay mandajninchi Davidpa willcanmi› nir? ");
INSERT INTO qxhNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espíritu Santu rimachiptin, quiquin David niran: ‹Tayta Diosninchi Washäcujnïta nisha: «Mandäshimänayquipaj dirïcha-caj lädüman jamacuy cunćharyuyquicunata pampaman ćhuranäcaman. Nishayqui-nishayqui munashayquita rurachinquipaj» nir.› ");
INSERT INTO qxhNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Chaynuy niptin, Washäcuj, ¿rasunpachuraj Davidpa willcallan canga? ¿Runapa wawanchuraj canga? Au, paypitam. Chaypis quiquin mandaj David manchapacur, Taytachacuycan.» Jesús willapäcuptin, runacuna cushish wiyaparaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yaćhachishpan Jesús niycaran: «Moiséspa shiminta yaćhajcunapa llupinpa ama jatinquichu. Paycuna rucapäcushalla läsacunaćhu purin runacuna manchapacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Shuntacäna wasicunaćhüpis ñaupa-ñaupallaćhu jamayta ashin. Micupacuj jayachiptinpis, allillata jarananta munan. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Majan wañupacush warmicunapa imancunatapis ushyapan. Jinarcur, Tayta Diosninchita sumaj mañacuj-tucun. Paycunata Tayta Diosninchi sumaj ñacachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tayta Diosninchipa wasinćhu caycar, jillay ćhuracuna ñaupanćhu Jesús jamaraycaran. Jillay ćhurajcunata ricapaycaran. Puchuy-puchuy jananćhu tiyaj runacuna chay-chica jillayta ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Biyüda warmipis pishipacuyćhu juyaycar, ishcay ćhaniynaj-yupay jillayta ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chayta ricar, purïshijnincunata Jesús niran: «Sumaj tantiyacunquiman. Pishipacuyćhu juyaycaj biyüda warmi ćhurashanman waquin ćhurashan mana tincunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Waquin runa jillaynin puchuptinraj, ćhurasha. Cay warmim ichanga paćhallanpaj charashantapis llapanta ćhurasha.» ");
INSERT INTO qxhNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tayta Diosninchipa wasinpita llucshiycashanćhu juc purïshijnin Jesústa niran: «Tayta, mä, ricay. Achic-achicyaycaj rumicunawan Tayta Diosninchipa wasinta pirgasha. Sumaj cuyayllapaj, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesúsna niran: «Musyachishayqui. Imayllaga llapan ricashayqui ushyacanga. Rumiwan pirgararsi, llapanmi jućhurachish canga.» ");
INSERT INTO qxhNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaypita Ulïbus puntaman Jesús aywacuran. Chayćhu Tayta Diosninchipa wasinman ricajćhu jamaraycaptin, Pedro, Santiago, Juan, Andrés tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Tayta Jesús, ¿imaytaj Tayta Diosninchipa wasinta jućhurachinga? ¿Imanaypataj shimiqui ćharcucänanta musyashaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesúsna niran: «Pipis pantachishurunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achcajmi shamunga: ‹Nuwata shuyaraycämanqui. Washäcujmi caycä› nir. Achcaj runatam pantachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","«Wacćhu-cayćhu wañuchinacuy jatariptinpis, ama manchacärinquichu. Chaycunaraj cangapaj. Chaypis cay pacha mana ushyacangarächu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cay pacha ushyacänanpäga marcan-marcan wañuchinacungapaj. Chay-tucuyćhüpis pacha juyupa sicsicyanga. Mućhuy captinpis, yargaywan runacuna wañunga. Chaypis runacuna mana ushyacangarächu. Manchäga ñacayllarämi jallaringa. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Quiquiquicunapis sumaj tantiyacunquiman. Ćhasquicamashayqui-janan mayur Israel runacunapa maquinman ćhayachishunquipaj. Shuntacäna wasicunaman rïsu apachishunquipaj. Chayćhu sumaj wascashunquipaj. Roma auturdäcunamanpis ćhayachishunquipaj. Wacpa-caypa purichishuptiquipis, shimiquita ama amucurcunquichu. Manchäga pï-maytapis nuwapita willapanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cay pacha manaraj ushyacaptin, Tayta Diosninchipa alli willacuyninta chay-tucuy marcaćhu willapäcunga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","«Auturdäcunaman ćhayachishuptiqui, ama llutäpacunquichu: ‹¿Imataraj rimashaj?› nir. Manchäga Tayta Diosninchi shimiquiman ćhurashallanta rimanquipaj. Espíritu Santu rimachishunquipaj. Mana quiquiqui yarpashayquitanachu rimanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Nuwata ćhasquicamashan-janan waugui-pura auturdäcunamanpis ćhayachinacunga. Papäninpis wamrancunata wañuyman ćhayachinga. Wamrancunapis maman-taytanta chiquir, wañuyman jitarpunga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ćhasquicamashayqui-janan llapan runa chiquishunquipaj. Mana yamacällar shimïta wiyacuptiqui, imaycamanpis maquinćhu Tayta Diosninchi cawachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Tayta Diosninchipa unay willacujnin isquirbishanta liguir, sumaj tantiyacärinquiman. Tayta Diosninchipa wasinta pampaman ćhuraptin, manchapacushantapis ićhichiptin, Judea marcacunapita puntacunaman juclla jishpicäriy. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasi puncućhu caycar, ruriman ama yaycunquimanchu. Imayquicunatapis ama jurgunquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ćhacrapitapis wasiquiman ama cutinquimanchu. Müdanayquita ama shuntanquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","«Ñacachishan wichan jishyaj warmicunapis, pishi wamrayujcunapis cuyapaypaj ñacanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chaymi jishpinayqui junaj tamya wichanman mana ćhayananpaj, Tayta Diosninchita mañacäriy. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay wichan juyupa ñacay canga. Tayta Diosninchi cay pachata camashanpita-pacha chaynuy ñacay mana imaypis caranchu. Chaynuypis yapay mana imaysi cangapänachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wamrachacushancunata llaquipar, Tayta Diosninchi chay ñacay junajcunata wallcayächinga. Manchäga pipis mana wañuypita jishpinmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Chay wichan pantachicujcuna pantachishurunquiman: ‹Mä, ricay. Tayta Diosninchi caćhamushan Washäcujninchi shamusha. Mä, ricay. Washäcujninchi ćhayaycämun› nir. Chaynuy nishuptiquisi, ama ćhasquipanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chay wichan Washäcuj-tucujcuna, willacuj-tucujcuna ricarimungapaj. Munayniyuj car, tucuyta ruranga runacunata riguichinanpaj. Chayta rurar, Tayta Diosninchi acracushan runacunatapis waquinta pantachinga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Canan sumaj tantiyacunquiman. Willapänajpaj cashanta mayna willapashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Juyupa ñacaycuna ćhawarcuptillan, inti wañucäcunga. Quilla mana achicyanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Istrïllacuna shicwamunga. Janaj pachapis juyupa tapsinga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chay junajmi Tayta Diosninchi caćhamaptin, nuwata ricamanquipaj munayniyuj car, pucutay jananćhu achic-achicyaycar cutiycämujta. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tayta Diosninchi anjilnincunata caćhamunga acrashan runacunata chay-tucuypita shuntamunanpaj. Shuntanga janaj pachapa cantunpita juc-caj cantuncaman. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Jïgus yürawan tincuchiypa tantiyacushun. Yüran chillguiptin, tamya quilla jallaycunanta musyanchi. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chay-jina willapashäcuna ćharcuptin, cutimunä caycashanta tantiyacärinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sumaj tantiyacunquiman. Waquinniquipa ricay ñawiquićhu llapan ćharcucanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Janaj pachapis, cay pachapis ushyacanga. Shimïmi ichanga mana jungacangachu. Llapanmi ćharcucanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Cutimunä junajta Tayta Diosninchi pitapis mana musyachishachu. Wawan captïsi, mana musyachimashachu. Janaj pachaćhu tiyaj anjilcunatapis mana musyachishachu. Quiquin Taytallanchim musyaraycan. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","«Cutimunäta mana musyaycar, camaricushalla cawanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sumaj tantiyacunayquipaj tincuchiypa willapäshayqui. Juc wasiyujshi aywacuyta yarpar, mincaynincunata jaguipusha llapanta imatapis rurananpaj. Wasi täpajtana ricaćhacuycänanpaj jaguisha. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chaymi ricchaycar imaypis cawanquiman. Wasiyuj imay cutimunantapis mana musyanquichu. Ćhayaramunman pacha chacarcuptillanpis, pullan-pagaspis, wallpa-wagaypis, pacha-waraypis. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mana yarpashpita ćhayamur, puñuycajta tarishurunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chaymi mayganiquipis Tayta Diosninchita ama yamacanquichu. Llapaniqui mayaj-mayajlla shuyämanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chay wichan Israel runacunapa «Libadüraynaj tanta» nishan fiesta jallarinanpaj ishcay junajllana pishiycaran. Chay fiestata ricsij: «Pascua» nir. Cüracunapa mandajninwan Moiséspa shiminta yaćhajcuna yarpaćhacuycaran Jesústa chariycur wañurachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Waquinna niycaran: «Fiestaćhu ama charishunchu. Chariptinchi, runacuna ullgucäcur ticraparamäshuwan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania marcaćhu «Jaraćhu» nishan Simónpa wasinćhu Jesús micupacurcaycaptin, butïlla pirjümin aptash warmi ćhayaran. Chay pirjümi sumaj ćhaninyuj caran. Butïllata quićharir, Jesúspa umanman jaycapuriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chayta ricar, waquin jurpacuna ullgucäcur quiquin-puralla parlanacuran: «¿Imapäraj pirjümita usuchisha? Ama usuchinmanchu caran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Manchäga quimsa paćhac (300) junaj aruypa ćhaninćhu ranticunman caran. Jinarcur pishipacujcunata aypunman caran.» Chaynuy nir warmita chiquiparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesúsmi ichanga niran: «Ama rimapaychu. ¿Imanirtaj tincupanqui? Umäman jaycapamar, allitam rurasha. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pishipacujcunata imaypis ricanquipaj. Yanapayta munar, imaypis yanapanquiman. Nuwatam ichanga waran-waran mana ricamanquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Chaymi cay warmi allita rurasha. Cawaycaptillä, pampamänanpaj armachimasha. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sumaj tantiyacunquiman. May-chayćhüpis Tayta Diosninchipa alli willacuyninta willapäcur, cay warmi allita rurashantapis willacunga. Mana imaysi jungacangachu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chaura Judas Iscariote Jesúspa purïshijnin caycarsi, mayur cüracunaman aywaran: «Jesústa charïshishayqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Judas nishanta wiyar sumaj cushicur: «Jillayta jushayqui» niran. Chay junajpita-pacha charij-charijllana Judas caycaran mayćhüpis Jesústa charinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chaypita Pascua fiesta jallariran. Chay fiestaćhu Israel runacuna libadüraynaj tantata micuj. Acrashan cashnitapis pishtaj. Chay junaj purïshijnincuna Jesústa tapuran: «Tayta, ¿mayćhütaj Pascua micuyta camaricamushaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chaura Jesús ishcaj purïshijnincunata caćhar, niran: «Jerusalén marcaman ćhayaptiqui, puyñullawan runa yacuta apaycajta ricanquipaj. Jipallanta aywanqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wasiman yaycuptin, wasiyujta ninqui: ‹Tayta Jesús caćhamasha. ¿Mayćhütäshi wasi jäcuycan purïshijnincunallawan Pascua micuyta micupacunanpaj?› ");
INSERT INTO qxhNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Quiquin camarishallata jäcuj altusninta ricachishunquipaj. Chayllaćhu pishijcunata camaricunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Purïshijnincunana änir marcaman ćhayar, Jesúspa shiminman-tupu llapantapis tariran. Chayllaćhu Pascua micuyta camaricuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chacas-chacasna ćhunca ishcaywan purïshijnincunawan Jesús ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Micurcaycashanćhu niran: «Sumaj tantiyacunquiman. Mayganiquipis ticrapamar, wañuyman jitarpamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chaura llaquicäcur, jucnin-jucnin Jesústa tapuran: «¿Nuwachuraj? ¿Nuwachuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ćhunca ishcaywan purïshijnincunatana Jesús niran: «Nuwanchiwan iwal micujmi wañuyman jitarpamanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tayta Diosninchi caćhamasha. Quiquin camacächiptin, wañuyman ćhayashaj shimin ćharcucänanpaj. Jitarpamaj runam ichanga juyupa ñacanga. Chaymi ama yurinmanpishchu caran.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Micurcaycashanćhu tantata aptacurcur, Jesús niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur tantata paquircur-paquircur, purïshijnincunata aypuran: «Catay. Cay tanta quiquïmi caycä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaypita bïnuyuj cüpata aptacurcur, niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur macyaptin, llapan upuchinacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesúsna niran: «Cay bïnu yawarnïmi. Washänaj-raycur wañuyman ćhayaptï, yawarnï jićhanga. Yawarnïwanraj parlanacushanta Tayta Diosninchi ćharcucaycächin. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sumaj tantiyacunquiman. Cananpita bïnuta mana upushänachu. Llapanchita Tayta Diosninchi maquinman jishpichimaptinchiraj, mushuj bïnuta upushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Micupacuyta ushyariycur, Tayta Diosninchita alliman ćhurashpan cantarir, Ulïbus puntaman aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chayćhüna Jesús niran: «Canan pagas llapaniqui jaguiraycamanquipaj. Tayta Diosninchipa shiminpis nin: ‹Uysha michijta wañuchishaj. Wañuycachiptï, uyshancuna mashtaypa-mashtar aywacunga.› ");
INSERT INTO qxhNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","«Cawarircamurmi ichanga, Galilea marcaman ñaupashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedruna niran: «Llapan jaguirishuptiquipis, mana imaysi jaguirishayquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesúsna niran: «Pedro, sumaj tantiyacunquiman. Canan chacaylla wasguimanquipaj. Mana ricsij tucumanquipächu. Ishcay cutipa gällu manaraj cantaptillan, quimsa cutipa wasguimanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedruna niran: «Mana imaypis wasguishayquichu. Ishcaninchitapis jina wañuchimäshun.» Llapan purïshijnincunapis Pedro-jina niran: «Mana wasguishayquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaypita «Getsemaní» nishan ćhacraman purïshijnincunawan Jesús aywaran. Ćhayar, niran: «Washanijćhu Tayta Diosninchita mañacushäcaman cayllaćhu jamapäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chaynuy nir Pedruta, Santiaguta, Juanta pusharan. Paycunapa ricay ñawinćhu jatunpa llaquicuran. Shungun ishquicäcuptin, niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","«Llaquicuy juyupa ćhayapamasha. Wañuy janäćhüna. Yanagaycallämay, ari. Waräshimay.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jinarcur carushman aywarcur pachacaman jungurpacuycur Tayta Diosninchita mañacur, Jesús niran: «Papällau Papä, camacaptin, shuyarämaj ñacay ama ćhayamächunchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jampäga imapis mana sasachu. Shuyarämaj ñacaypita jishpichimay, ari. Jishpiyta munaptïpis, shungü munashan ama camacächunchu. Manchäga munashayquinuylla llapanpis caycullächun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jinarcur quimsaj purïshijnincunaman cutir, puñuycajta tariran. Chaymi Pedruta niran: «Simón, ¿puñucuycanquićhim? ¿Manachu juc ürallasi ricchashcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ricchay-llapa. Mana wasguimänayquipaj Tayta Diosninchita mañacäriy. Allita yarparsi, ushyacajllam carcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jinarcur mañacushan-cajman yapay cutiran. Mañacushannuylla yapay mañacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cutir, yapay puñucashta tariran. Wañuypa puñunay chariptin, puñucurcaycaran. Chaymi ima niytapis mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quimsa cutićhu cutirna, Jesús niran: «¿Puñurcaycanquićhim? ¿Jitarpaycanquićhim? Jataripacuyna. Juchaćhu aruj runacuna ćhayamushana. Tayta Diosninchipa caćhan caycaptïsi, charimanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jataripacuyna. Wañuyman jitarpamaj runa jananchićhünam. Aywapushun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús rimaycaptillan, purïshijnin cashpansi Judas ćhayapuran achcaj runata pushacurcur. Mayur cüracunapis, Moiséspa shiminta yaćhajcunapis, mayur runacunapis caćhaptin, chay-chicaj runa aywaran jirunwan-caman, tucsicunanwan-caman. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas mayna nish caran: «Macallarcushä runa Jesúsmi canga. Charircur mana caćharillar, apacunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chaymi ćhayaycur juclla Jesústa macallarcur, wamayaran: «Taytallau tayta» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chaura Jesústa charicarcäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesúspa juc purïshijninna cuchillunta jurgurir, mayur cürapa uywayninpa rinrinta rugupariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Llapan runata Jesús niran: «¿Imatataj yarpanqui? ¿Suwa cashätachu? ¿Imanirtaj jiruyquiwan-jiruyquiwan, cuchilluyquiwan-cuchilluyquiwan shapäcamushcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Waran-waran Tayta Diosninchipa wasinćhu ricamashcanqui. Paypa shiminta ricay ñawiquićhu tantiyachishcä. ¿Imanirtaj mana charimashcanquichu? Ichanga Tayta Diosninchipa shimin ćharcucänanpämi charimashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Purïshijnincunam ichanga jishpicäriran. Japallantana Jesústa jaguiycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesústa apacuptin, bayïtawan pitushalla juc müsu jipanta aywaycaran. Chaura müsutapis chariran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chariptin, piturashan bayïtata jaguiycur, jalapaćhalla jishpicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chaypita mayur cüraman Jesústa aparan. Mayur cürapa wasinman cüracuna, mayur runacuna, Moiséspa shiminta yaćhajcuna shuntacaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrupis Jesúspa caru jipallanta aywar sawan ruricaman yaycuran. Chayćhu Tayta Diosninchipa wasinta täpajcunawan mashacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chaura mayur cüracuna, llapan mayur Israel runacuna Jesústa wañuchinanpaj achäquita ashircaycaran. Ichanga mana tariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achcaj tumparpis, quiquin-puralla apaycaćhänacuran. Rimashancuna mana tincuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Waquin runa Jesústa tumpar niran: ");
INSERT INTO qxhNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Cay runash nisha: ‹Runacuna rurashan Tayta Diosninchipa wasinta jućhuchishaj. Jinarcur, quimsa junajllaćhu jatarachishaj runa mana aruycaptinsi.› » ");
INSERT INTO qxhNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chaynuy nirpis, quiquin-puralla apaycaćhänacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chaynuy tumpaptin, mayur Israel runacunapa ricay ñawinćhu mayur cüra jatarcur, Jesústa tapuran: «¿Manachu rimacunqui? ¿Rasunpachu rimashcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesúsmi ichanga imatapis mana rimacuranchu. Chaura mayur cüra yapay tapuran: «Mä, willamay. ¿Tayta Diosninchipa Wawanchu canqui? ¿Caćhamushan Washäcujchu canqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesúsna niran: «Au. Nuwam caycä. Caćhan cashpämi mandäshinäpaj Munayniyuj Tayta Diosninchiwan iwal jamashaj. Pucutay jananćhu cutiycämujta ricamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chaura mayur cüra ullgucuycuran. Quiquinpa müdanantapis raćhir ushyarir, japariran: «Tistïguta mana munanchinachu. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Shiminpita musyanchi Tayta Diosninchita apäriycashanta.» Chaynuy niptin, juc shimillaraj niran: «Wañuchicächun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chaypita waquin runa Jesústa tuwapur ushyaran. Ñawinta chaparcur, magaran: «Tayta Diosninchipa willacujnin carga, ¿pitaj cutashcashunqui? Mä, willamay» nir. Tayta Diosninchipa wasin täpajcunapis lajyar ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro sawan rurićhu caycaptin, mayur cürapa uywaynin jipash ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mashacuycajta tarir sumaj ricapärir, niran: «Nazaret runa Jesúswan purishcanqui, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedrum ichanga wasguipar, niran: «Chay runata mana ricsïchu. Imatash rimacullanquipis.» Chaynuy nir puncuman llucshicuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chaypita uyway jipash Pedruta ricar, yapay llapanta willaran: «Cay runa Jesúspa purïshijnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro yapay wasguiran. Mayllantana jinan runacunapis Pedruta niran: «Jampis Galilea runa caycanqui. Rasunpa Jesústa purïshishcanqui, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaura Pedro ullgucäcuran: «Chay runata mana ricsïchu. ¿Piraj cacullanpis? Llullacuptïga, Tayta Diosninchi jina ñacachimächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Niycaptillan, ishcay cutipa gällu cantariran. Chayraj Pedro yarpäriran: «Mana ricsij tucumanquipächu. Gällu ishcay cutipa manaraj cantaptillan, quimsa cutipa wasguimanquipaj» nishanta. Jesúspa shiminta yarpärir shungun ishquicäcuptin, juyupa wagaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pacha wararcuptin, mayur cüracuna, mayur runacuna, Moiséspa shiminta yaćhajcuna jutucaran. Sisyunćhu parlanacarcärir, llapan mayur Israel runacuna Jesústa watashta mandaj Pilatuman aparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ćhayachiptin, mandaj Pilato Jesústa tapuran: «¿Rasunpachu Israel runacunapa mandajnin canqui?» nir. Jesúsna niran: «Quiquiquim rimashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chaura mayur cüracuna tucuy-tucuypita Jesústa tumparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chaymi mandaj Pilato yapay Jesústa tapuran: «¿Imata nishuptiquipis, manachu chapacunqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Chaynuy niptinsi Jesús mana rimacuptin, mandaj Pilato ima ruraytapis mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pascua fiestaćhu runacuna mañacuptin, watan-watan mandaj Pilato juc rïsuta caćharij. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay wichan juyu Barrabás rïsu wićhgaraycaran magacushanpita, wañuchicushanpita. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaymi achcaj runa mandaj Pilatuta mañacuran: «Watan-watan caćharishayqui-jina juc rïsuta caćhariy, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Chaura mandaj Pilato tapuran: «¿Israel runacunapa mandajnintachu caćharishaj? Paypa maquinćhüshi cawanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chiquipayllawan Jesústa mayur cüracuna apashanta mandaj Pilato mayna musyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mayur cüracunana achcaj runata shimiyaran: «Barrabásta caćhariy» nir mañacärinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yapay mandaj Pilato tapuran: « ‹Israelcunapa mandajnin› ricsishayqui Jesústa, ¿imanäshätaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tapuptin, runacuna japariran: «Rusćhu wañuchicächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mandaj Pilatuna niran: «¿Imaćhütaj juchata aparicusha?» Paycunam ichanga: «Rusćhu wañuchicächun» nir sumaj japarpararan. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mandaj Pilato Israel runacuna alli ricananta munar, Barrabásta caćhariycuran. Jesústana sumaj wascaraycächir, murucuncunata inćhigaran rusćhu wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Murucucunana mandajninpa sawanninman Jesústa yaycuchiran. Jinarcur llapan murucu-masincunata shuntachiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesústa pampaman ćhurar puca jacuta jacuparan. Umanmanpis cashapita pilltarcullar curünata jatiparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Asipänan cashpan niran: «Israel runacunapa mandajnin alli ricash caycullächun.» ");
INSERT INTO qxhNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jananmanpis shugushwan umanćhu wirur ushyaran. Tuwapuran. Jungurpacuycur, alliman ćhuraj-tucuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pampaman ćhurariycur, puca jacunta jićhuriran. Quiquinpa müdananta ushtuparcur, rusćhu wañuchinanpaj aparan. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesústa wañuchinanpaj apaycashanćhu Cirene marcapita Simónwan tincuran. Ćhacrapita cutiycämuptin, paytana Jesús apashan rusta murucucuna apachiran. Simónga Alejandrupawan Rufupa taytan caran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Murucucunana «Gólgota» nishan pachaman Jesústa ćhayachiran. «Gólgota» ninantam rimayninćhu: «Calabïra pata» nin. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Usuncachicuj jampitawan bïnuta tallurcachir, Jesústa upuchiyta munaran. Paymi ichanga mana upuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Rusman läbaycur, murucucuna surtita jitaran Jesúspa müdananta mayganinpis apacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ćhajćha intiman mana ćhayaptillan, rusman Jesústa läbaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Imapita wañuchishanpis musyacänanpaj rus jananman isquirbiran: «Cayga Israel runacunapa mandajnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesústawan ishcaj suwatapis iwal rusman läbaran: jucninta dirïcha-caj lädunman, jucnintana isquirda-caj lädunman. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chaynuypa Tayta Diosninchi isquirbichishan ćharcuran: «Juchaćhu arujta-jina runacuna ricanga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chay quinranpa purij runacunapis Jesústa pampaman ćhuraran. Ashllishpan umanta awir niran: «Jamga Tayta Diosninchipa wasinta jućhurachir, quimsa junajllatash jatarachinqui, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Canan mä, wañuypita jishpiy. Ruspita mä, yarpamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mayur cüracunapis, Moiséspa shiminta yaćhajcunapis Jesústa pampaman ćhurar, quiquin-pura ninacuran: «Payga waquin runacunata jishpichishaćhi. Quiquinpis jishpiyta mana junchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tayta Diosninchipa caćhamushan Washäcuj caycarga, Israelpa mandajnin carga, ruspita yarpamunman. Yarpamujta ricarraj, shiminta ćhasquicushun.» Rusman ishcaj läbaraj runapis Jesústa ashllir ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chaypita lasdüsipita mallwaycaman pacha chacacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mallwayna Jesús japaćhacuran: «Eloí, Eloí, ¿lammá sabactani?» nir. Rimayninćhu: «Eloí, Eloí, ¿lammá sabactani?» ninanga: «Taytallau Tayta, ¿imanirtaj jaguiraycamashcanqui?» ninanmi. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Japaćhacuptin, wiyajcuna niran: «Mä, wiyashun. Tayta Diosninchipa unay willacujnin Elíastaćhim jayacuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Juc runana shigui bïnuman shaputa ushmarcachir shugushman watarcur, Jesústa shuguchiyta munaran. Shuguchishpan niran: «Mä, ricapäshun. Rasunpachush Elías shamunga ruspita jurgunanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesúsmi ichanga sumaj japarir, wañucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wañucäcuptin, Tayta Diosninchipa wasinćhu chaparaj bayïtapis janapita uraypa callacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Imanuy wañucäcushantapis ricar, murucucunapa capitannin niran: «Cay runa rasunpa Tayta Diosninchipa Wawan casha.» ");
INSERT INTO qxhNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Warmicunapis carushllapita ricapaycaran. Ricapaycaran Magdalena marcapita Maríapis, shullca-caj Santiagupawan Josépa maman Maríapis, Salomépis. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Paycuna Jesústa yanapar purïshiran Galilea marcacunaćhu puriptin. Jesúswan Jerusalén marcaman aywaj warmicunapis achcaj ricapaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Diyawardaman ćhayanan junaj chacanaycaptin, ");
INSERT INTO qxhNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea marca José mana manchacullar mandaj Pilatuman aywaran: «Jesústa pampachicushaj» nir. Payga mayur cürapa mandäshij-masin carpis, Tayta Diosninchipa maquinćhu juyayta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pampachicunanpaj mañacuptin, mandaj Pilato yarpaćhacuran: «¿Wañushanachuraj?» nir. Chaymi jayarcachir, murucucunapa capitanninta tapuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","«Au, wañushanam» niptin, mandaj Pilato Joséta auniran: «Pampachicuy, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Auniptin ruspita ayata jurgurcur, rantishan bayïtawan José pituran. Jinarcur runa pampacunan chaga ućhcuman ćhuraycuran. Ućhcu puncutana rumiwan chaparcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mayman pampashantapis ricapaycaran Magdalena marca Maríawan Josépa maman María. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Diyawarda ushyarcuptin, Magdalena marcapita María, Santiagupa maman María, mama Salomé ayata chaquichij pirjümita rantiran. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dumingu warariycaptillan, Jesús pamparashanman aywaran: ");
INSERT INTO qxhNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","«¿Piraj chaparaj rumita witichipämäshun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ćhayaptin jatun carpis, rumi witiraycaranna. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pamparashan ućhcuman yaycuriptin, dirïcha-caj lädunćhu achic-achicyaycaj yuraj müdanash müsu jamaraycaran. Chayta ricar, warmicuna mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Manchariptin, müsu niran: «Ama manchariychu. Rusćhu wañuj Nazaret marca Jesústa ashircaycanqui, ¿au? Cayćhu pamparash carsi, mana cannachu. Mayna cawarisha. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Canan cuticuy. Jesúspa purïshijnincunata willar, Pedrutasi ninqui: ‹Galilea quinranman ñaupashana. Quiquin nishannuylla chayćhu tincunquipaj.› » ");
INSERT INTO qxhNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Warmicunana manchariywan sicsicyaycar jishpicuran. Manchariyllawan imatapis mana willacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chaura dumingu tuta waraycaptillan, Jesús cawarimuran. Cawarcamur, puntata Magdalena marcapita Maríata ricaripuran. Paypita janćhis supayta jargush caran. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesúspa purïshijnincuna juyupa llaquicur wagarcaycaptin: «Jesús ricaripamasha. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cawaycan. Rasunpa ricashcä» nir María willaptinsi, mana yupachicuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaypita ishcaj purïshijnincuna ćhacrapa aywaycaptin, juc-nirajnash Jesús ricaripuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Paycunapis purïshij-masincunata willaran: «Jesús ricaripamasha» nir. Willaptinpis, mana yupachicuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaypita ćhunca jucwan (11) purïshijnincuna micupacurcaycaptin, Jesús ricaripuran. Piñacuran: «Cawarimushäta willaycäshuptiqui, ¿imanirtaj mana yupachicamashcanquichu? ¿Imanirtaj chucru shungu carcaycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jinarcur niran: «Canan chay-tucuy marcacunaman ayway. Tayta Diosninchipa alli willacuyninta llapanta willapäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipis yupachicamar ushyacur, alli cawayta taringa. Mana yupachicamajcunatam ichanga Tayta Diosninchi ñauquinga. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pipis yupachicamar, Tayta Diosninchi camacächiyninpa supaycunata jargunga. Juc-niraj rimaycunata rimanga. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wañuchicuj curucunata charirpis, wañuchicuj jampita upurpis, mana wañungachu. Maquinwan yataptin, jishyaćhucunapis allchacangam.» ");
INSERT INTO qxhNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesús willapäcuriptin, janaj pachaman Tayta Diosninchi shuntacuran. Payta mandäshinanpaj dirïcha-caj lädunman Tayta Jesús jamacuran. ");
INSERT INTO qxhNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Purïshijnincunana Jesúspita chay-tucuyćhu willapäcuran. Willapäcunanpaj Tayta Jesús sumaj yanaparan. Ima-imatapis rurananpaj camacächiran. Shiminta wiyar, rurashancunata ricar, runacuna Jesús willapäcushancunata tantiyacuran.");
INSERT INTO qxhNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Tayta Teófilo, nuwa Lucas cay libruta isquirbiycämü jallaycunanpita-pacha Jesúspa willapanta sumaj musyanayquipaj. Paypa willapanta achcaj runa isquirbiran ricajcunata tapucurir-tapucurir. Ricajcunata quiquincunata Jesús caćhacuran Tayta Diosninchipa shiminta willapäcur purinanpaj. Chaymi nuwapis cay libruta isquirbiycämü camacächiypa imanuy cashancunatapis sumaj tapucaćhärir. Cay libruta liguir, llapan willapäshushayqui rasun cashanta, mana rasun cashantapis musyanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea marcacuna mandaj Herodespa maquinćhu caycashan wichan Zacarías jutiyuj cüra caran. Warmin caran Isabel. Paycunapa auquillunpis cüra caran. Zacarías caran Abías cüra casta. Warmin Isabelna caran Aarón cüra casta. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacaríaswan Isabel Tayta Diosninchipa shiminta wiyacur, cuyay-munaypaj cawaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Chaypis Isabel wawata mana tarij warmi cashpan wamran mana caranchu. Jananmanpis ishcan chacha caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zacarías arunan junaj ćhayamuptin, Abías cüra-masinwan Tayta Diosninchipa wasinman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Cüra-masincuna yaćhacashan-jina surtita jitaptin, Zacaríasman ćhayaran. Chaymi Tayta Diosninchipa wasin rurinman Zacarías yaycuran insinsuwan saumachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Insinsuwan saumachishancaman jawallaćhu runacuna Tayta Diosninchita mañacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Saumaycächiptin, Tayta Diosninchi caćhamushan anjil ricaripuran insinsuta rupachicuna tullpapa dirïcha-caj lädunćhu. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías juyupa mancharicäcuran. Ima ruraytasi mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anjil niran: «Zacarías, ama manchacamaychu. Mañacushayquita Tayta Diosninchi wiyasha. Warmiqui Isabel ullgu wamrata jishyacunga. Jutinta: ‹Juan› nir ćhurapanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jatunpa cushicachishunquipaj. Wamrayqui yuriptin, achcaj runa cushicungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tayta Diosninchipa ricay ñawinćhu wamrayqui allillata ruranga. Manasi yurillar, Espíritu Santupa maquinćhu cawanga. Imaypis mana maćhanmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel-masiquicunata anyapanga juchanpita wanacunanpaj, Tayta Diosninchita wiyacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Unay willacuj Elías-jina cawanga. Maquinćhu purichir munayniyuj cananpaj Tayta Diosninchi sumaj yanapanga. Chaynuy cawashpan Tayta Diosninchi caćhamushan Washäcujtapis ñaupapämunga. Wamrayqui willapäcuptin, runacunapis wamrancunawan llaquinacäringa. Rumi shungucunapis Tayta Diosninchita wiyacäringa. Chayraj llapan runa Tayta Diosninchi acracushan runata camaricushalla shuyaranga. Acracushan runa Washäcuj canga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chaura anjilta Zacarías tapuran: «Rasunpa wamrä cananta, ¿imanuyparaj musyashaj? Auquinna caycä, warmïpis chachana» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anjilna niran: «Tayta Diosninchipa caćha-anjilnin caycä. Paypa ñaupanćhu purï. Gabrielmi jutï. Quiquin caćhamasha alli willapata willapänajpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cananga shimïta mana ćhasquicushayquipita wamrayqui yurinancaman rimaytapis mana pashtachinquipächu. Chaypis rimashäga ćharcunga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chaycaman runacuna puncućhu shuyarpaycaran: «¿Imanirraj Zacarías mana llucshimunchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tayta Diosninchipa wasinpita llucshiramur, Zacarías rimayta mana pashtachiranchu. Maquillanwan tantiyachiyta munaran. Chaymi runacuna tantiyacuran rurićhu imasi ricaripushanta. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tayta Diosninchipa wasinćhu ima ruraynintapis ushyaycur, wasinman Zacarías cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaypita warmin Isabel jishyaj ricacur, pichga quilla wasillanćhu cacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Shungullanćhu niran: «Tayta Diosninchi yanapämasha wamrata tarinäpaj. Cananga mana pipis pampaman ćhuramangachu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sujta quillayujna Isabel jishyaj caycaptin, Tayta Diosninchi anjil Gabrielta caćharan Galilea quinranćhu Nazaret marcaman Maríata willachij. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María runa yatäni caycar, Joséwan majachacänanpaj parlaraycächiran. José caran unay mandaj Davidpa willcan. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anjil ricariparcur, niran: «María, ¿allillachu caycanqui? Alli ñawinwan Tayta Diosninchi ricashcashunqui. Maquinćhu cawaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chaura María mancharicäcuran: «¿Imanirraj chaynuy niman?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anjilna niran: «María, ama manchacuychu. Alli ñawinwan Tayta Diosninchi ricashunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jishyaj ricacunquipaj. Ullgu wamrayqui yuringapaj. Jutintapis: ‹Jesús› nir ćhurapanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mayur runa canga. Llapan runa ninga: ‹Llapanta Camaj Tayta Diosninchipa Wawan.› Auquillun David mandashan-jina mandaj cayman Tayta Diosninchi ćhuranga. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jacobpa willcan Israel runacuna maquinćhu cawanga. Mandaj cayninpita imaypis mana llucshingachu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Anjiltana María tapuran: «Runa yatäni caycar, ¿imanaypataj wawata tarïman?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anjilna niran: «Jishyaj ricacunayquipaj Llapanta Camaj Tayta Diosninchi camacächiptin, Espíritu Santu ćhayapushunquipaj. Llantucurcushunquipaj. Chaymi Tayta Diosninchi acracush captin, wamrayquita ninga: ‹Tayta Diosninchipa Wawan.› ");
INSERT INTO qxhNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tïyayqui Isabelpis chachana caycarsi, jishyaj caycan. Wawaynaj cashanpita pampaman ćhurash captinpis, sujta quillana paćhayuj caycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tayta Diosninchipaj imapis mana sasachu. Payga llapallanta camacächin.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maríana anjilta niran: «Tayta Diosninchipa maquinćhu cawä. Nishayquinuylla camacächun.» Chaynuy niptin, anjil aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chaypita María juclla camaricuriycur, puntan-puntan Judá quinranćhu juc marcaman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacaríaspa wasinman ćhayar, tïyan Isabelta wamayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María wamayaptin paćhanćhu caycällar, Isabelpa wamra cuyuriran. Espíritu Santu rimachiptin sumaj cushicushpan wiyächipaypa Isabel niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","«María, chay-chicaj warmi captinsi, ima allish Tayta Diosninchi jamllata acracushcashunqui. Wamrayquitapis acracusha. Ishcaniquita yanapayculläshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Imaraj carä Washäcujpa maman watucamänanpäga? ");
INSERT INTO qxhNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Watucamar shimiquita wiyaptï, wamräsi cushicuyllawan paćhäćhu cuyuriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tayta Diosninchipa shiminta aunishayquipita cushish cawaj-aywanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chaura María niran: «Llapan shungüwan Tayta Diosninchita alliman ćhurä. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jatunpa cushicü. Tayta Diosninchi Washäcujnï. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Runacuna pampaman ćhuramaptinsi, Tayta Diosninchi llaquipämasha. Cananpita llapan runa ninga: ‹Ima allish Tayta Diosninchi Maríata acracusha. Imaraj cushicun.› ");
INSERT INTO qxhNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mana tantiyashäcunata Munayniyuj Tayta Diosninchi camacächisha. Payga manchapacuypämi. Imatapis allillata ruran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Manchapacujcunata imaypis Tayta Diosninchi llaquipan. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Munayniyuj cayninwan imatapis camacächin. Sumaj-tucujcunata mashtaypa-mashtar ushyarin. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Alli-tucuj mandajcunata jargun. Pampaman ćhurashcunata alliman ćhuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Puchuy-puchuy jananćhu cawajcunata pishipacuyman ćhuran. Pishipacuyćhu cawajcunata puchupacushancaman tarichin. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Maquinćhu cawaptinchi, Israel runa-masintïta yanapaycäman. Imaypis llaquipaycämanchi. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Auquillü Abrahamta aunishan-jina, willcancunata aunishan-jina imaypis mana jungamangachu. Canancamanpis yanapaycäman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Quimsa quilla-yupay tïyan Isabelpa wasinćhu María juyaran. Jinarcur wasinpa cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Quillan ćhayamuptin, Isabel ullgu wamranta jishyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jishyacuptin, castancunapis, ricsinacushancunapis watucuran. Jatunpa cushicuran: «Ima allish Tayta Diosninchi yanapashcashunqui wawata tarinayquipaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wamra pusaj junajyuj captin yaćhachishancunata ćharcur, mallwata jïruran. Papäninpa jutinwan tincunanpaj: «Zacarías» nir jutichayta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Maman niran: «Mana. Juanmi jutinga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Runacunam ichanga niran: «Juan jutiyuj castayquicunapis mana canchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chaymi ima jutinta ćhurapänanpäpis maquillanwan tantiyachir, Zacaríasta tapuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tapuptin, papilta mañarcur: «Juanmi jutin» nir isquirbiran. Chaura llapan mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacaríasna rimariran. Tayta Diosninchita alliman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chaura Zacaríaspa castancuna, Isabelpa castancuna sumaj manchariran. Rimay ćhayaptin, Judea quinranćhüpis runacuna manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chay willapata mayar, yarpaćhacuran: «¿Imapäraj Isabelpa wamran yurisha? Llapan alli ricanga» nir. Isabelpa wamranta Tayta Diosninchi yanapaycashanta llapan runa musyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Santu rimachiptin Tayta Diosninchi yarpashanta musyachicur, Zacarías niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Ima allish Tayta Diosninchi Israel runacunata mana junganchu. Payga shamusha nuwanchita jishpichimänanchipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wiyacuj Davidpa castallanpita munayniyuj runata jatarachisha washämänanchipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chaynuy cananpaj unay willacujnincunawan Tayta Diosninchi musyachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Musyachimaranchi ñacachicuj runacunapita washämänanchitapis, chiquicuj runacunapita jishpichimänanchitapis, ");
INSERT INTO qxhNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","auquillunchicunata llaquipar aunishanta ćharcucänantapis. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Auquillunchi Abrahamta Tayta Diosninchi auniran ");
INSERT INTO qxhNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","allilla cawananchipaj, chiqui runacunapita jishpichimänanchipaj. Maquinćhu cawaycar, ");
INSERT INTO qxhNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","shungun yarpashallanta rurashunpaj. Wañuyman ćhayashanchicaman llapan juchapita wanacushunpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wamran Juanta Zacarías niran: «Wawallau wawa, jamta: ‹Llapanta Camaj Tayta Diosninchipa willacujnin› nishunquipaj. Washäcujta ñaupapanquipaj. Runacunata willapanquipaj Washäcujta shuyaränanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tantiyachinquipaj: ‹Tayta Diosninchi juchanchita jungaycur, washämäshunpaj› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","«Inti jigamuptin pacha achicyashan-jina shungunchipis achicyacäcunga llaquipäcuj Tayta Diosninchi Washäcujta caćhamuptin. ");
INSERT INTO qxhNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tayta Diosninchita mana wiyacur, llapanchi wañuy jananćhu cawaycanchi. Washäcuj shamurmi ichanga, alli cawayta tarichimäshun. Yanapämäshun Tayta Diosninchipa maquinćhu manchapacur cawananchipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chaura wiñashanman-tupu Juan runayaran. Espíritu Santu shacyächiptinpis, Tayta Diosninchipa shungun munashannuylla cawaran. Ichanga yatalla tiyacuran. Tayta Diosninchipa shiminta Israel-masincunata willapayta jallaycurraj llapan ricay puriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Jesús yurishan wichan mandaj Augusto llapan Roma marcacunata maquinćhu puriycächiran. Siria marcata ricananpäna mandaj Quirinuta ćhurash caran. Paymi Israelcunatapis yupachiran mandaj Augusto: «Maquïćhu juyaj runacunata llapanta yupachiy» niptin. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yupacänanpaj llapan runa yurishan marcanman-caman cutiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Chaymi Josépis warmin Maríawan aywaran Galilea quinranćhu Nazaret marcapita Judá quinranćhu Belén marcacaman. Chay marca unay auquillun Davidpa marcan caran. Davidpa yawar-masin cashpan Josépis Belén marcaman aywaran. Warmin María quillanćhüna caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Belén marcaćhu pachacuna wasi mana jäcuptin, uywacunapa wasillanman pachacuran. Nanay chariptin, jichpanta María jishyacuran. Inćhanawan piturcur jinallanćhu wamranta ujllacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chay chacay Belén wajtanćhu uyshïrucuna uyshancunata täparcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tayta Diosninchi caćhamuptin, illajpita anjil achic-achicyaycar ricaripuran. Achicyacurcuptin, uyshïrucuna juyupa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anjil niran: «Ama manchacamaychu. Alli willapata apamushcä. Cay willapata wiyar, achcaj runa cushicäringa. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mandaj Davidpa marcanćhu Jishpichicujniqui yurisha. Paymi Washäcujniqui, Taytayqui. Payta Tayta Diosninchi caćhamusha maquinćhu purichishunayquipaj, imapitapis washäshunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mä, ayway. Ćhayar, uywapa wasinćhu inćhanawan pintushta tarir, willashaj rasun cashanta tantiyacunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anjil willaycaptillan, illajpita chay-chicaj anjilcuna ricacamuran. Tayta Diosninchita llapan alliman ćhuraran: ");
INSERT INTO qxhNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Janaj pachaćhu Tayta Diosninchi alli ricash caycullächun. Cay pachaćhüpis wiyacuj runacuna allilla cawachun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anjilcuna janaj pachaman cuticuptin, uyshïrucuna ninacuran: «Juclla Belén marcaman aywashun. Tayta Diosninchi willachimashanchita ricamushun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Juclla Belén marcaman aywar, rasunpa Josétawan Maríata tariran. Mallwa wamrantapis uywacunapa wasillanćhu ujllaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mallwa wamrata tariycur, willaran: «Cay mallwa yurinanpaj mayna anjil musyachimaran» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Uyshïrucuna willaptin, llapan sumaj cushicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríam ichanga llapantapis shungunman ćhuracuran mana jungananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Uyshïrucuna anjil nishallanta tariycur, Tayta Diosninchita alliman ćhuraycar cushish cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chaypita pusaj junajyujta mallwa wamrata jïrur, maman-taytan jutinta ćhuraparan: «Jesús» nir. Jutichananpaj manaräsi jishyaj ricariptillan, Maríata anjil musyachirunaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jishyacushanpita awicunan junaj ćhayamuptin Moiséspa shiminta ćharcur, majantin María Jerusalén marcaman aywaran. Wamrantapis aparan Tayta Diosninchipa maquinman ćhuraj. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Moiséswan Tayta Diosninchi shiminta musyachiran. Shiminćhu nin: «Jichpa ullgu wamrata Tayta Diosninchipa maquinman ćhuranqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jananmanpis nin: «Cuyachicuyniquitapis apanqui ishcay pülla palumata, manchäga ishcay wampata.» Chaymi Maríawan José Tayta Diosninchipa shiminta ćharcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chay wichan Jerusalén marcaćhu Simeón jutiyuj runa tiyaran. Tayta Diosninchipa ricay ñawinćhüpis, runa-masincunapa ricay ñawinćhüpis alli cawaran. Israel-masintinta Tayta Diosninchi jishpichinantapis shuyäcuycaran. Payga Espíritu Santupa maquinćhu cawaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chaymi Espíritu Santu shacyächiptin, Tayta Diosninchi caćhamushan Washäcujta ricashancaman cawananta musyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Santu shacyächiptin, Tayta Diosninchipa wasi puncunman Simeón aywaran. Maríawan Josépis Tayta Diosninchipa wasinman aywaran. Jesústa aparan Tayta Diosninchipa shiminta ćharcur. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Maríawan José tincur Jesústa margacurcur, Simeón Tayta Diosninchita alliman ćhuraran: ");
INSERT INTO qxhNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Taytallau Tayta, maquiquićhu cawaycä. Allina wañucümanpis. Shimiquitapis ćharcushcanquina. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ñawïwan Washäcujta ricashcä. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Washäcujta caćhamushayquita llapan runa musyanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pï cashayquitapis jäpa runacuna tantiyacunga. Israel-masïcunapis alli ricash cayta taringa» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeónpa shiminta wiyar, Joséwan María tantiyayta mana atiparanchu: «Imanuyraj canga, ¿au?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Paycunata Tayta Diosninchipa maquinman ćhurar, Simeón niran: «María, wiyamay. Wawayqui waquin Israel-masinchicunata alli cawayta tarichingapaj. Waquintam ichanga llaquicuyman ćhayachingapaj. Tayta Diosninchi caćhamush captinsi, shiminta willapaptinsi, runacuna wasguinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Llapan runata imallata yarpashantapis musyapanga. María, cuchillu tucsishushayqui-jina shunguyquipis nanangaraj llapanta ricaptiqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tayta Diosninchipa wasinćhu chacha warmi Anapis caycaran. Papänin caran Fanuel. Auquillun caran Aser. Chacha Anaga Tayta Diosninchipa willacujnin caran. Janćhis watalla majanwan juyaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Majan wañucuptin, piwanpis mana yapapacurannachu. Manchäga pagas-junajpis Tayta Diosninchipa wasillanćhu cawaj. Manchapacur, ayünaj. Mañacuj. Payga pusaj ćhunca ćhuscuwan (84) watatana aywaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón rimayta ushyarcuptin Anana Jesústa ricar, Tayta Diosninchita alliman ćhuraran. Juturpaj runacunata niran: «Cay mallwa nuwanchi-raycur shamusha. Washäcujninchi. Jerusalén marcantinchita jishpichimäshunpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joséwan María Tayta Diosninchipa shiminta llapanta ćharcuriycur, wasinman cuticuran. Paycunapa wasin Galilea quinran Nazaret marcaćhu caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wawanpis wiñashanman-tupu runayaran. Yarpayninmanpis ćhayaran. Llaquipashpan Tayta Diosninchipis sumaj yanapaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesúspa maman-taytan watan-watan aywaj Jerusalén marcaman Pascua fiestaman. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ćhunca ishcaywan (12) watayyuj caycaptin, Jesústapis Pascua fiestaman pusharan. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pascua fiesta ushyaptin, marcanpa cuticäriran. Jerusalén marcaćhu Jesús caycashantam ichanga maman-taytan mana musyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Manchäga runacunawan tallucash aywaycashanta yarparan. Juc junaj aywaycashanćhu castancunata tapucur, ricsinacushancunata tapucur, Jesústa ashiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ashirpis mana tarir, Jerusalén marcacaman cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quimsa junajtaraj Tayta Diosninchipa wasinćhu Moiséspa shiminta yaćhajcunawan tapunacurcaycajta Jesústa tariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tapunacuptin Jesús allipa cutichiptin, runacuna cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tapunacuycajta tariycur, maman-taytanpis tantiyayta mana atiparanchu. Maman niran: «Wawallau, ¿imanirtaj cayta ruramashcanqui? Papäniquiwan ishcanï yarpaćhacuycar ashiycashcaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesúsna niran: «Mama, ¿imanirtaj ashiycämashcanqui? ¿Manachu musyanqui Papänïpa wasinćhu caycänäta?» ");
INSERT INTO qxhNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Paycunam ichanga imata rimashantapis mana tantiyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaypita Nazaret marcaman maman-taytanwan Jesús cuticuran. Maman-taytanta wiyacuran. Mamanga Jerusalén marcaćhu Jesús imata rurashantapis shungunman ćhuracuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Chaura wiñashanman-tupu Jesús yarpay-sapayaran. Tayta Diosninchipis, runa-masincunapis alli ñawinpa ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ushyachicuj Juan chunyaj pachaćhu tiyashan wichan ćhunca pichgawan (15) watana llapan Roma marcacunata Tiberio César mandaycaran. Paymi Judea marcacunata Poncio Pilatupa maquinman ćhuraran. Galilea marcatana Herodespa maquinman ćhuraran. Itureawan Traconítide marcatana Herodespa wauguin Felipupa maquinman ćhuraran. Abilene marcatana Lisaniaspa maquinman ćhuraran. Israel runacunana Anáspawan Caifáspa maquinćhu cawaran. Paycuna Jerusalén marcaćhu mayur cüra caran. Chay wichan Zacaríaspa wamran Juanta Tayta Diosninchi niran: «Shimïta willacamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chaymi Jordán mayu quinranćhu Juan anyapäcuran: «Tayta Diosninchipa shiminta wiyacäriy. Juchapita wanacäriy. Ushyacäriy. Chayrämi Tayta Diosninchi llapan juchayquita junganga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anyapäcuran unay willacuj Isaíaspa shimin ćharcucänanpaj. Payga unayna niran: «Chunyajćhu juc runa jayacuypa willacuycan: ‹Taytanchi shamunanpaj camaricuy. Caminuta pichay. Wicsu caminucunatapis allchay. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mana camaricurga, rajra-rajra-jina caycanqui. Punta-punta-jina caycanqui. Wicsu-wicsu caminu-jina caycanqui. Chaymi llapan juchapita wanacäriy. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tayta Diosninchi caćhamushan Washäcujta llapan runa ricanga. Washäcujga jishpichimäshun› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ushyacuj ćhayajcunata Juan niran: «Supaypa wawancuna, ushyacurpis juchallaćhu aruptiqui, Tayta Diosninchi ñacachishunquipaj. Mana jishpinquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wanacushayqui musyacänanpaj Tayta Diosninchita manchapacur allillata rurar caway. Ama chapacunquichu: ‹Israelcunata Abrahampa willcan cashanchipita Tayta Diosninchi alli ricamanchi› nir. Abrahampa willcan cananpäga rumitapis Tayta Diosninchi ticrarachinman wiyacuj cananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ushyacurpis juchapita mana wanacuptiqui, Tayta Diosninchi jargurishunquipaj. Yüratapis mana sumaj wayuptin, jächawan muturij-muturijllana shuyaranchi. Muturir, ninaman jaycurinchi.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chaura runacuna Juanta tapuran: «¿Imatataj ruräman?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tapuptin, Juan niran: «Ishcay janapay müdanayqui captin, juc-cajta pishipacujta juycunquiman. Micuy captin, ashijta tarichinquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Roma marcapa mandajninpaj jillayta shuntajcunapis tapucuran: «Tayta, ¿imatataj ruräman?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanna niran: «Aycatapis shuntanayquipaj nishallanta shuntanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Waquin murucucunapis tapucuran: «¿Imatataj ruräman?» nir. Juanna niran: «Jillayta jurgunayqui cashallan runacunata ama manchachinquichu. Pitapis ama tumpanquichu. Mandajniqui pägashushallayquita aypächicunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Runacuna shungullanćhu yarpaćhacuycaran: «Juanga Tayta Diosninchi caćhamushan Washäcujćhi canga, ¿au?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chaymi Juan niran: «Mana Washäcujchu cä. Nuwa yacullawan ushyachicuycä wanacushayqui musyacänanpaj. Washäcujmi ichanga Espíritu Santuwanpis, ninawanpis ushyachishunquipaj. Payga munayniyuj. Llanguinta llushtipuyllatapis manchapacü. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wanacujcunata alli ñawinwan Tayta Diosninchi rican. Juchaćhu arujcunatam ichanga mana upij ninaman jaycuringa. Sumaj tantiyacärinquiman. Rïguta wapyarpis, punshanta ruparachin. Muruntam ichanga wasinman shuntacun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ushyachicuj Juan Tayta Diosninchipa shiminta sumaj willapäcuran. Runacunata tucuy-jinanpa shacyächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mandaj Herodestam ichanga sumaj piñacuran wauguin Felipupa warmin Herodíasta jićhushanpita, juchallaćhu arushanpita. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Piñacuptin, mandaj Herodes Juanta wićhgachiran. Wićhgachir, jucha aparicushanpa jananmanpis mastaraj juchata aparicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mandaj Herodes manaraj wićhgachiptillan, runacunata ushyaycächishanćhu Jesústapis Juan ushyachiran. Ushyacuriycur, Tayta Diosninchita Jesús mañacuycaran. Niycaptillan, janaj pacha quićhacäcamuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Espíritu Santu paluma-niraj Jesúsman ćhayamuran. Janaj pachapita nimuran: «Cuyay Wawämi canqui. Shungüman sumaj tincunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quimsa ćhunca (30) watata aywaycashanćhüraj Tayta Diosninchipa shiminta willapäcuyta Jesús jallaycuran. Runacuna yarparan: «Jesúsga Josépa wamranmi canga» nir. Josépa papänin caran Helí. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helípa papäninna caran Matat. Matatpa papäninna caran Leví. Levípa papäninna caran Melquí. Melquípa papäninna caran Janaí. Janaípa papäninna caran José. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josépa papäninna caran Matatías. Matatíaspa papäninna caran Amós. Amóspa papäninna caran Nahúm. Nahúmpa papäninna caran Eslí. Eslípa papäninna caran Nagai. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaipa papäninna caran Maat. Maatpa papäninna caran Matatías. Matatíaspa papäninna caran Semeí. Semeípa papäninna caran José. Josépa papäninna caran Judá. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judápa papäninna caran Joanán. Joanánpa papäninna caran Resí. Resípa papäninna caran Zorobabel. Zorobabelpa papäninna caran Salatiel. Salatielpa papäninna caran Nerib. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neribpa papäninna caran Melquí. Melquípa papäninna caran Adí. Adípa papäninna caran Koram. Korampa papäninna caran Elmada. Elmadapa papäninna caran Er. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erpa papäninna caran Jesús. Jesúspa papäninna Eliecer. Eliecerpa papäninna caran Jarim. Jarimpa papäninna caran Matat. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatpa papäninna caran Leví. Levípa papäninna caran Simeón. Simeónpa papäninna caran Judá. Judápa papäninna caran José. Josépa papäninna caran Jonán. Jonánpa papäninna caran Eliaquim. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimpa papäninna caran Milea. Mileapa papäninna caran Mená. Menápa papäninna caran Matatá. Matatápa papäninna caran Natán. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánpa papäninna caran David. Davidpa papäninna caran Jesé. Jesépa papäninna caran Obed. Obedpa papäninna caran Booz. Boozpa papäninna caran Salomón. Salomónpa papäninna caran Najasón. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Najasónpa papäninna caran Aminadab. Aminadabpa papäninna caran Admín. Admínpa papäninna caran Arní. Arnípa papäninna caran Esrón. Hesrónpa papäninna caran Farés. Faréspa papäninna caran Judá. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judápa papäninna caran Jacob. Jacobpa papäninna caran Isaac. Isaacpa papäninna caran Abraham. Abrahampa papäninna caran Tara. Tarapa papäninna caran Najor. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Najorpa papäninna caran Seruc. Serucpa papäninna caran Ragau. Ragaupa papäninna caran Falec. Falecpa papäninna caran Eber. Eberpa papäninna caran Sala. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salapa papäninna caran Cainam. Cainampa papäninna caran Arfaxad. Arfaxadpa papäninna caran Sem. Sempa papäninna caran Noé. Noépa papäninna caran Lamec. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecpa papäninna caran Matusalén. Matusalénpa papäninna caran Henoc. Henocpa papäninna caran Jared. Jaredpa papäninna caran Malaleel. Malaleelpa papäninna caran Cainam. ");
INSERT INTO qxhNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainampa papäninna caran Enós. Enóspa papäninna caran Set. Setpa papäninna caran Adán. Adánta Tayta Diosninchi camaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jordán mayupita llucshirir, Espíritu Santupa maquinćhu Jesús puriran. Chunyaj pachaman Jesústa Espíritu Santu aparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ćhuscu ćhunca (40) junaj micuyta mana mallir, Jesús yargaran. Supay maquichacuyta munar ");
INSERT INTO qxhNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","niran: «Tayta Diosninchipa Wawan car, cay rumita tantaman mä, ticrarachiy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chaynuy niptin, Jesús niran: «Tayta Diosninchipa shimin nin: ‹Runa mana tantallawanchu cawan.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaypita jatunnin puntaman Jesústa Supay aparan. Jatun marcacunata ima-aycancunatawanpis ricachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jinarcur niran: «Ricashayqui marcacunata mandanayquipaj ćhurajman. Ima-aycancunapis nuwapam. Cay marcacunapis nuwapam. Maquïćhu charä. Munar, pitapis juycümanmi. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ñaupäman jungurpaycur alliman ćhuramaptiqui, llapan marcäcunata juycushayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesúsna niran: «Tayta Diosninchipa shimin nin: ‹Tayta Diosnillanchita manchapacunquiman. Paypa maquillanćhu cawanquiman.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaypita Jerusalén marcaman Jesústa Supay aparan. Tayta Diosninchipa wasinpa siswanman ićhichiran. Jinarcur niran: «Tayta Diosninchipa Wawan car, pachaman mä, jigacurpuy. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tayta Diosninchipa shimin nin: ‹Tayta Diosninchi anjilnincunata caćhamunga washäshunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ćhaquiqui rumiman mana tacacunanpäpis maquinwan charishunquipaj.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesúsna niran: «Tayta Diosninchipa shimin nin: ‹Tayta Diosninchita maquichacuyta ama camanquimanchu.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jesústa maquichacuyta mana camäpacur, Supay aywacuran: «Imayllaga maquichacushayquiraj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Espíritu Santupa maquinćhu cawashpan Galilea marcacunaman Jesús cuticuran. Chay-tucuyćhu runacuna Jesúspa willapanta mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Shuntacäna wasicunaćhu Tayta Diosninchipa shiminta Jesús willapäcuptin, runacuna sumaj cushicuran: «Allita yaćhachicun, ¿au?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wiñashan Nazaret marcaman Jesús ćhayaran. Diyawarda junaj shuntacäna wasiman yaćhacashannuylla aywaran. Tayta Diosninchipa shiminta liguinanpaj ićhicuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Unay willacuj Isaías isquirbishan libruta macyaran. Libruta quićhar liguiy munashanta tarir, liguiran: ");
INSERT INTO qxhNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Maquinćhu Espíritu Santu purichiman. Pishipacujcunata alli willapata willapänäpaj ćhuramasha. Caćhamasha ñacajcunata willapänäpaj, japracunapa ñawinta quićhanäpaj, juyu runapa maquinćhu cawajcunata washänäpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Caćhamasha: ‹Canan watapita-pacha Tayta Diosninchi llaquipämanchi› nir willapänäpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Liguiyta ushyaycur, libruta wićhgarcuran. Libru macyaj runata cutiycachiran. Jinarcur tantiyachinanpaj jamacuycuran. Llapallan juturajcuna ricapacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Willapäcur Jesús niran: «Liguishä canan junajmi ćharcusha. Tayta Diosninchipa unay willacujnin nuwapaj yarpar isquirbiran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesús sumaj alli rimaptin, llapan runa cushicushpan alli ricaran. Waquinmi ichanga pampaman ćhurar niran: «Cayga Josépa wamrallan, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesúsna niran: «Rimay purishan-jinaćhi: ‹Jampicuj carga, quiquiquiraj allchacanquiman› nimänayquipaj carcaycanqui, ¿au? ¿Imanirtaj yarparcaycanqui: ‹Cafarnaún marcaćhüshi jishyaćhucunata allchacächishcanqui. Cayćhüpis allchacächinquiman› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","«Sumaj tantiyacunquiman. Yurishan marcaćhu Tayta Diosninchipa willacujnincunata marca-masincuna pampaman ćhuran. Ricaytapis mana munanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Sumaj tantiyacunquiman. Unay willacuj Elías cawashan wichan tamya mana shicwaptin, quimsa wata pullan mućhuy caran. Chaypis Israel biyüdacunata Tayta Diosninchi mana yanaparanchu. Manchä Sidón quinranćhu Sarepta marcacaman willacujnin Elíasta caćharan biyüdata yanapänanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Unay willacuj Eliseo cawashan wichanpis Israel runacuna achcajmi jaraćhu jishyawan cawaran. Chaypis Israel runacunata mana allchacächiranchu. Manchä Siria runa Naamánllata mana Israel runa captinsi, Tayta Diosninchi allchacächiran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesús tincupaptin, shuntacäna wasinćhu juturajcuna chigaypa ullgucaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ullguyllawan Jesústa aparan chagapita jitarpuycunanpaj. Paycunapa marcan pata jananćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tangarinanpaj apaycaptin runacunapa ricay ñawinpita llucshir, Jesús aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Galilea quinranćhu Cafarnaún marcaman ćhayar, diyawardacunaćhu Tayta Diosninchipa shiminta Jesús willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sumaj willapäcuptin, runacuna sumaj cushicäriran: «Jesús willapäcushan shungunchiman sumaj ćhayan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Shuntacäna wasićhu supay pucllacushan runapis caycaran. Supay rimachiptin, japarir niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aćhaćhau, Nazaret runa Jesús. ¿Imatataj ashiycanqui? ¿Illarachimajchu shamushcanqui? Pï cashayquitapis musyä. Tayta Diosninchipa Wawan canqui. Paypa acracuynin canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesúsna piñacuran: «Upälla supay. Chay runata caćhariy» nir. Chaura llapan ricay runata sajtarillar, supay aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Runa allina caycashanta ricar, llapan runa juyupa mancharicäcuran. Jucnin-jucnin ninacuran: «¿Imatataj ricanchi? ¿Imatataj wiyanchi? Payga munayniyujtaj. Juc shimilla supaycunatapis jargun. Jarguptin, aywacun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chay quinranćhu Jesús ima-ima rurashanpis mayacaran. Quiquin-pura runacuna willanacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Shuntacäna wasipita Simónpa wasinman Jesús aywaran. Ćhayaptin, willaran: «Simónpa suydan wayllaywan jishyaycan. Allchacächiy, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lädunman ashuycur jishyata piñacuriptin, wayllay caćhariycuran. Chaura jatarcur, yanucuriycuran jarananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chacanaycaptin: «Diyawarda ushyashana» nir jishyaćhucunata Jesúsman apamuran. Maquinwan Jesús yataycuptin, llapan jishyaćhucuna allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Waquin runapita supaycunatapis jarguran. Supaycuna llucshir japariran: «Jesús, Tayta Diosninchipa Wawanmi canqui» nir. Jesúsmi ichanga piñaparan. Tayta Diosninchi caćhamushan Washäcuj cashanta musyaptin, mana rimachiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chaca-chacalla marcapita llucshir, chunyaj pachaman Jesús aywaran Tayta Diosninchita mañacuj. Chaypis achcaj runa ashiran. Taripar, niran: «Tayta, ama aywacuychu, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesúsmi ichanga niran: «Tayta Diosninchi shuyarämashanchita juclä marcacunaćhüpis willapäcunä. Payga maquinćhu cawananchita munan. Shungun munashanta willapäcur purinäpaj caćhacamasha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chaymi Judea quinranćhu marcan-marcan Jesús puriran. Shuntacäna wasicunaćhüpis Tayta Diosninchipa shiminta willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Genesaret püsu cantunćhu Jesús willapäcuptin, chay-chicaj runa jutucaj Tayta Diosninchipa shiminta wiyananpaj. Runacuna quiquin-pura tacanacujraj. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yacućhu ishcay büti ićhiraycajta Jesús ricaran. Piscädu charijcuna bütipita yarpurir, ridinta tacsharcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bütita ricar, Simónpa bütinman jigaran: «Simón, bütiquiwan washanijman apamay» nir. Jinarcur bütićhu jamacuycullar, llapan runata willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Rimayta ushyarcur, Simónta niran: «Simón, püsu ćhaupinman aywashun. Piscäduta charinayquipaj jundunnin yacuman ridiquita jitanquiman-llapa.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónna niran: «Tayta, warayllata piscapäcushcä. Ichanga mana jucnayllatapis charishcächu. Chaypis shimiquita wiyar, mä, yapay ridïta jitashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jesúspa shiminta wiyacur ridinta yacunman jitar, änir may-may piscäduta chariran. Ridinpis raćhinasharaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chaymi piscädu charij-masincunata maquinwan Simón jayaran. Chaura juc-caj bütitapis aparan yanapänanpaj. Juc-caj bütita ćhayachiptin, ishcan bütiman piscädu juntaran. May-may piscäduta wiñaptin, bütipis yacuman challpunaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Chay-chica piscäduta ricar, Simón Pedro, Juan, Jacobo, yanapajnincunapis mancharicäcuran. Simón Pedruna Jesúspa ñaupanman jungurpacuycur, niran: «Tayta, manchacujmi. Witicunquiman. Jucha-sapa car, ñaupayquićhu caytapis pingacü.» Jesúsna niran: «Simón Pedro, ama manchariychu. Piscäduta charishayqui-jina runacunata shuntanquipaj Tayta Diosninchipa maquinćhu cawananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chaura jinan üra bütita yacupa pallganman ićhiycachir llapan imancunatapis jaguiriycur, Jesúswan aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Juc marcaćhu Jesús caycaptin, jaraćhu jishyawan runa ćhayapuran. Ñaupanman uysucuycuran: «Tayta Jesús, llaquipämashpayqui allchacaycachillämay, ari. Tayta Diosninchipa ricay ñawinćhüpis alli cayta munä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Llaquipashpan maquinwan yataycur, Jesús niran: «Llaquipajmi. Allchacayna.» Niptin, jaraćhu jishya illaricäcuran. Allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jinarcur Jesús niran: «Ama pitapis willapanquichu. Manchäga allina cashayquita ricashunayquipaj cüraman ayway. Moiséspa shiminta ćharcur, cuyachicuyniquitapis Tayta Diosninchita jaray. Chayraj llapanpa ricay ñawinćhu alli canquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","«Ama willanquichu» niptinsi, Jesúspa willapan chay-tucuyćhu mayacaran. Tayta Diosninchipa shiminta wiyayta munar, allchacayta ashir, may-may runacuna shuntacaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Achcaj shuntacaptinsi, chunyaj pachaman Jesús witicuj Tayta Diosninchita mañacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc junajćhu Jesús willapäcuptin, fariseucunapis, Moiséspa shiminta yaćhaj runacunapis jamarpaycaran. Paycunaga Galilea marcacunapita, Judea marcacunapita, jinan Jerusalén marcapita shamuran Jesúspa shiminta wiyananpaj. Tayta Diosninchi camacächiptin, jishyaćhucunata Jesús allchacaycächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Waquin runana quirmallawan cumllucash runata ćhayachiran. Ichanga wasi junta runa caycaptin, Jesúspa ñaupanman yaycuchiyta mana camäpacuranchu. Chaymi wasi jananman jigarcur tïjata ashuraycächir, ućhcuriycäriran. Jinarcur Jesúspa ñaupanman warcuyllapa quirmantinta yarpuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Paycuna llapan shungunwan yupachicushanta musyar, cumllucash runata Jesús niran: «Wawallau wawa, juchayquicunata jungashcäna.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chaura fariseucunawan Moiséspa shiminta yaćhajcuna shungullanćhu ullguran: «¿Imanaycantaj cay runa? Tayta Diosninchita apäriycan. Juchanchita Tayta Diosnillanchi junganman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yarpashanta musyar, Jesús tapuran: «¿Imanirtaj llutanta yarparcaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mä, tapushayqui. ¿Allchacächiychu, jucha aparicushanta jungacächiychu sasa? ");
INSERT INTO qxhNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Canan tantiyacunquiman. Tayta Diosninchi cay pachaman caćhamasha. Munayniyujmi cä pipa juchantapis jungacächinäpaj.» Cumllucash runatana niran: «Mä, wiyamay. Jatariy. Quirmayquita shuntacurcur, wasiquiman cuticuy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cumllucash runana llapan ricay jataricurcuran. Quirmanta apacurcur, wasinman cuticuran: «Ima allish Tayta Diosninchi allchacächimasha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Llapan runacunapis jatunpa cushicuran. Tayta Diosninchita alliman ćhuraran: «Canan ricashanchicunata mana imaypis ricashcanchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaypita llucshircur, Leví jutiyuj runata Jesús ricaran. Levíga Roma marcapa mandajninpaj jillayta shuntaycaran. Ricar, Jesús niran: «Leví, purïshimay.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Niptin llapan imantapis jaguiriycur, Jesústana Leví purïshiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levípa wasinćhüna Jesústa alliman ćhurar, sumaj micupäcuran. Jillayta shuntaj-masinwanpis, waquin chay-niraj runacunawanpis micurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseucunawan Moiséspa shiminta yaćhajcunam ichanga Jesústa pampaman ćhurar purïshijnincunata tapuran: «¿Imanirtaj jillayta shuntaj chiqui runacunawan, juchaćhu arujcunawan micupäcunqui?» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jamurpaptin, Jesúspis niran: «Jishyaćhucunallash jampicujta ashin. Mana jishyarga, mana ashinchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chay-jina nuwapis juchaćhu arujcunata Tayta Diosninchiman cutichij shamushcä. ‹Juchaynajmi cä› nijcunatachu mana ashiycä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Waquin runa Jesústa tapucuran: «Tayta, Ushyachicuj Juanpa purïshijnincunapis, fariseucunapa purïshijnincunapis ayünashpan Tayta Diosninchita mañacuj. Purïshijniquicunam ichanga paćhanta mana yargächinchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chaynuy niptin quiquinman tincuchicur, Jesús niran: «Warmi ashïshijcuna manash llaquishachu ayünan. Manchäga cushishash micupacärin. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Warmi ashij müsuta jićhuptinshi ichanga, ayünangapaj. Jatunpash llaquicungapaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yapay tincuchiypa willapar, Jesús niran: «Mauca müdanata mushuj raćhipawan manash pipis jiranmanchu. Mushujwan jiraptin, jintishpan mauca müdanatapis shiullirachinshi. Mushuj müdanapis ućhcucäcunshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bïnuta puguchinanpäpis manash pipis chaquish jaracha putuman wiñanmanchu. Bïnu pugur, chaquish jaracha pututa pashtarachinshi. Pashtaptin, bïnupis ushyacäcunshi. Jaracha putupis raćhicäcunshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Llullu jaracha putuman wiñaptinshi ichanga, bïnu sumaj pugun. ");
INSERT INTO qxhNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pugush bïnuta malliycur, shigui bïnuta pipis manash upunnachu: ‹Pugush bïnu sumaj mishquin› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juc diyawarda junaj rïgu puguraycaj cantunpa purïshijnincunawan Jesús aywaycaran. Purïshijnincunaga rïguta shipircur-shipircur cupacaćhärir, ućhuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Waquin fariseucuna tapuran: «¿Imanirtaj diyawardaćhu rïguta cupacaćharcaycan? Diyawardaćhu Tayta Diosninchipa shiminta ćharcur, mana arunchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chaura Jesús niran: «¿Auquillunchi David imata rurashantapis manachu musyanqui? Tayta Diosninchipa shiminta liguiycarsi, ¿yargaywan David imata rurashantapis manachu tantiyacushcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yargay chariptin Tayta Diosninchipa wasinman yaycurir, jarashan tantanta micuran. Cüracunalla micunan caycaptinsi, yanaguincunawanraj David micupäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tayta Diosninchi caćhamasha. Chaymi diyawardapis maquïćhu caycan. Diyawardaćhu runa imata rurananpäpis, imata mićhänäpäpis maquïćhümi caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Juc junajpis diyawardaćhu shuntacäna wasiman aywarcur, Jesús willapäcuran. Dirïcha-caj maquin wañush runapis caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseucunawan Moiséspa shiminta yaćhajcuna achäquita ashishpan ricapaycaran: «¿Diyawarda caycaptin, maquin wañush runata mä, allchacächingachush? Allchacächiptinga, chaylla achäqui canga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Fariseucunapa shungunta musyar, maquin wañush runatana Jesús niran: «Llapan ricashunayquipaj ićhiy.» Maquin wañush runa änir llapan ricananpaj ićhiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jinarcur Jesús niran: «Taytacuna, tapucushayqui. Diyawarda captinsi, ¿allitachu, llutantachu rurashuwan? ¿Washäshuwanchu? ¿‹Wañucuchun› nishuwanchu?» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Llapanman ricärir, maquin wañush runatana Jesús niran: «Maquiquita chutapacuy.» Chutapacuriptin, maquin allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Diyawardaćhu allchacächishanta ricaycur, fariseucuna ullgucarcäriran. Jesústa wañurachinanpaj parlanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay wichan Jesús aywaran puntaman Tayta Diosninchita mañacuj. Warayllata Tayta Diosninchita mañacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pacha wararcuptin, purïshijnincunata shuntaran. Llapanta shuntaycur, ćhunca ishcaywanta (12) acracuran caćhacunanpaj. Paycunata jutichaparan: «Caćhacuna» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Caćhananpaj acracuran: «Pedro» nishan Simónta, Simónpa wauguin Andrésta, Santiaguta, Juanta, Felipita, Bartolomíta, ");
INSERT INTO qxhNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateuta, Tomásta, Alfeupa wamran Santiaguta, «Marcanpaj nanachicuj» nishan Simónta, ");
INSERT INTO qxhNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa wauguin Judasta, Judas Iscariotita. Judas Iscariote Jesústa wañuyman jitarpuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Puntapita pampaman yarpurcur, caćhancunallawan Jesús ićhicaycäriran. Chayćhu waquin purïshijnincunapis, Judea quinran runacunapis, jinan Jerusalén runacunapis, lamar cantunćhu tiyaj Tiro runacunapis, Sidón runacunapis juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Llapan juturpaycaran Jesúspa shiminta wiyananpaj. Jishyaćhucunatapis apamuran allchacächinanta munar. Jesús llapanta allchacächiran. Supay pucllacushan runacunatapis allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chaymi pï-maypis Jesústa yatarcuyta munaj. Payga munayninwan llapanta allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Purïshijnincunata ricapärir, Jesús niran: «Pishipacujcuna, cushicärinquiman. Tayta Diosninchi yanapaycäshunqui. Maquinćhu cawaycächishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","«Pishipacujcuna, cushicärinquiman. Maquinćhu Tayta Diosninchi purichishunqui. «Yargayćhu cawajcuna, cushicärinquiman. Shunguyqui munashantapis tarichishunqui. «Llaquish cawajcuna, cushicärinquiman. Tayta Diosninchi yanapaycäshunqui. Cushishalla cawachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Wiyacamashayqui-janan runacuna chiquishuptiquisi, ashllishuptiquisi, ricayta mana munashuptiquisi, cushicärinquiman. Nuwatapis runacuna chiquimasha Tayta Diosninchi caćhamash caycaptinsi. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Imata rurashuptiquisi, sumaj cushicärinquiman. Tayta Diosninchi alli cawayta shuyaraycächishunqui. Unay willacujnincunata alli cawayta tarichishan-jina tarichishunquipaj. Chay wichanpis marca-masiquicuna unay willacujcunata juyupa ñacachiran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Waquin runacunatam ichanga Jesús niran: «Puchuy-puchuy jananćhu cawajcuna, llaquicärinquiman. Ñacayman Tayta Diosninchi ćhayachishunquipaj. Cay pachaćhu alli cawayta mayna tarishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","«Micuy jananćhu cawajcuna, llaquicärinquiman. Yargayman Tayta Diosninchi ćhayachishunquipaj. «Asicaćhar cawajcuna, llaquinacärinquiman. Ñacayman Tayta Diosninchi ćhayachishunquipaj. Atayparaj waganquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Alli ricash cayllata ashijcuna, llaquicärinquiman. Ñacayman Tayta Diosninchi ćhayachishunquipaj. Unay wichanpis llutan willacujcunata alli ricash cayllata ashiptin, marca-masiquicuna llapanmi alli ricaran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Purïshijnincunata Jesús niran: «Shimïta sumaj wiyacunquiman. Runacuna chiquipäshuptiquisi, llaquipanquiman. Alli ñawiquiwan ricar, yanapanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chapata rurashuptiquisi, Tayta Diosninchita mañacapunqui. Chiquishuptiquisi, mañacapunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Juc-caj jajllayquićhu lajyashuptiqui, juc-cajlätana camapunqui. Punchuyquita jićhushuptiqui, camsayquitapis jaguipaycunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Imatapis mañacushuptiqui, tarichinquiman. Jićhushuptiqui, cutichishunayquita ama shuyaranquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","«Alli ricashunayquita munashayqui-jina runa-masiquitapis alli ricanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Juchaćhu arujcunapis yaćhänacushallanwan llaquipänacun. Yaćhänacushallayquiwan llaquipänacur, ¿rasunpachuraj llaquipayta yaćhanqui? Mana. Aynillanta cutiycächinqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Juchaćhu arujcunapis yanapäcuj-masillanwan yanapänacun. Yanapäcuj-masillayquiwan yanapänacur, ¿rasunpachuraj yanapayta yaćhanqui? Mana. Aynillanta cutiycächinqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Juchaćhu arujcunapis challicuj-masillanwan challinacun achcata ćhasquiyta munar. Challicuj-masillayquiwan challinacur, ¿rasunpachuraj challicuj cayta yaćhanqui? Mana. Aynillanta cutiycächinqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Chiquishuptiquisi, llaquipanquiman. Alli ñawiquiwan ricar, yanapanquiman. Pitapis challir, cutichishunayquitaraj ama shuyaranquimanchu. Chaynuy alli cawashayquipita Llapanta Camaj Tayta Diosninchi sumaj alli ricashunquipaj. Paypa wawan cashayquipis musyacanga. Payga llapan runata llaquipan juchaćhu aruptinsi, mana imasi jucuptinsi. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tayta Diosninchi alli shungu cashan-jina llapan runata llaquipanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jananmanpis Jesús niran: «Runa-masiquita pampaman mana ćhuraptiqui, Tayta Diosninchipis pampaman mana ćhurashunquipächu. Mana llaquipänacuptiqui, Tayta Diosninchipis mana llaquipäshunquipächu. Runa-masiquipa juchanta jungaptiqui, Tayta Diosninchipis juchayquita junganga. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Runa-masiquita llaquipar yanapaptiqui, Tayta Diosninchipis llaquipäshunquipaj. Yanapäshunquipaj. Payga ima-imata rurashanchitapis ricaycan. Llaquipänacushayquiman-tupu Tayta Diosninchipis llaquipäshunquipaj. Puchuy-puchuy imatapis tarichishunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tantiyacunanpaj tincuchiypa Jesús niran: «Japra runa japra-masinta manash pushanmanchu. Pushanacur, ishcaninshi ućhcuman shicwan. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jipa wamracuna mayur runacuna yarpashanta manash yarpanrächu. Llapanpaj uman aypaptinshi ichanga, mayur runacuna yarpashantana yarpanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Juchaćhu aruycar runa-masiqui llutanta ruraptin, ama jamurpanquimanchu. Quiquiquipa ñawiquićhu cullu jatiraycaptin, ¿jucpa ñawinpita pujrita jurgapunquimanchuraj? Mana. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Manchäga ñawiquipitaraj culluta jurgunquiman jucpa ñawinpita pujrita jurgapunayquipaj. Juchaynaj-tucuj carcaycanqui. Ñawiquipitaraj culluta jurgunquiman runa-masiquipa ñawinpita pujrita jurgapunayquipaj. Chay-jina juchaćhu cawaycarga, jucpa juchanta ama jurgapanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Yüra juc casta yürapa wayuyninta mana wayunchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yürata wayuyninpa ricsinchi. Durashnuta mana wangurpitachu pallanchi. Übasta mana shirapitachu pallanchi. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yüra-jina runacunapis ricsican. Tayta Diosninchita manchapacuj runa Tayta Diosninchipa shungun munashallanta ruran. Juchaćhu aruj runam ichanga quiquinpa shungun yarpashallanta ruran. Runa shungun yarpashanman-tupu allitapis, mana allitapis riman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«¿Imanirtaj: ‹Taytallau Tayta› nimarpis, shimïta mana wiyacunquichu? ");
INSERT INTO qxhNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Juc runa ćhasquicamar shimïta wiyacuptin, shungü munashanta ruraptin, alli wasita rurajwan tincuchï. Wasita alli rurar, chucruman ćhayashancaman simintuta ujtin. Jinarcur rumiwan simintuta jallarachin. Chaymi llujlla ćhayarsi, wasita mana jućhuchinchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Shimïta mana wiyacujcunatam ichanga ñushya allpallaman wasinta jatarachijwan tincuchï. Chaymi llujlla ćhayar, jućhurachin. Wasinpis ushyacäcun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Runacunata willapäcuriycur, Cafarnaún marcaman Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chay marcaćhu Roma murucucunapa capitannin juyaran. Capitanpa cuyay uywaynin juyupa jishyaycaran. Wañunaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chaymi Jesús ćhayamushanta mayar, mayur Israel runacunata capitan caćhacuran: «Jesústa ruwacamuy. Uywaynïta allchacächinanpaj shamuchun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mayur runacuna Jesúsman ćhayar, änir mañacuran: «Tayta, capitanta yanapaptiqui, alli canga. Uywayninta allchacächiy, ari. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Israel runa captinchisi, alli ñawinpa ricamanchi. Quiquinmi shuntacäna wasitapis rurachisha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chaynuy niptin, capitanpa wasinpana Jesús aywäshiran. Wasiman yaycupaycaptin, mincaynincunata capitan caćharan: «Tayta Jesús, wasïman ama ćhayamunquimanchu. Manacaj runa car, pingacü. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chaymi quiquïpis mana shamushcächu. ‹Allchacächun› niptiqui, uywaynï allchacäcunga. Mana aywanayquirächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nuwapis jucpa maquinćhu juyä. Quiquïpis maquïćhu murucucunata purichï. Chaymi: ‹Shamuy› niptï, shamun. ‹Ayway› niptï, aywan. Llapan mincaynï shimïta wiyacun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Capitanpa shiminta wiyar, Jesús jatunpa cushicuran. Jatirpaj runacunatana niran: «Jäpa runa caycarsi, llapan shungunwan chay capitan manchapacaman; Israel-masinchicunam ichanga janan shungulla.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chaura capitanpa caćhancuna cuticäriran. Wasinman ćhayar, capitanpa uywayninta allchacashtana tariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Manasi aycällatana Naím marcaman Jesús aywaran. Purïshijnincunapis, runacunapis may-may aywäshiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Marcaman ćhayaycashanćhu chay-chicaj runa ayata apaycajwan tincuran. Juc biyüdapa japallan wamran wañush caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Biyüdata llaquipar, Jesús niran: «Mamallau mama, ama wagaynachu, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Matancajcunata ićhicachir quirmata yataycur, niran: «Müsitu, ricchapacuy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chaura müsupis cawaricurcur, rimapacuranna. Mamantana Jesús niran: «Catay wawayqui. Cawarishana.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Runacuna sumaj mancharicäcuran. Tayta Diosninchitapis alliman ćhuraran: «Wawan caycaptinchi, Tayta Diosninchi yanapaycämanchi. Munayniyuj willacujninta caćhamusha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Judea quinran runacunapis, chimpan quinranćhu tiyaj runacunapis ayata Jesús cawarachimushanta mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Quiquinpa purïshijnincuna willaptin, Ushyachicuj Juanpis Jesús ima-imata rurashallanta musyaran. Chaymi ishcaj purïshijninta jayarcachir, caćhacuran: ");
INSERT INTO qxhNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«Jesústa tapumuy: ‹¿Jamchush Tayta Diosninchi caćhamushan Washäcuj caycanqui? ¿Juctarächush shuyäcärishaj?› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanpa caćhancuna ćhayar, änir tapuran: «Tayta Jesús, Ushyachicuj Juan caćhamasha. ¿Jamchush Tayta Diosninchi caćhamushan Washäcuj caycanqui? ¿Juctarächush shuyäcärishaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Juanpa caćhancuna ćhayaptin, jishyaćhucunata, supay pucllacushancunata, japracunata Jesús allchacaycächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chaymi tapuptin, niran: «Jucta ama shuyanquimanchu. Manchäga llapan ricashayquita, llapan wiyashayquita Juanta willar ninqui: ‹Japracuna ricaycanna. Wijrucunapis alli puriycanna. Jaraćhu jishyajcunapis allchacaycanna. Upacunapis wiyaycanna. Wañushcunapis cawariycanna. Pishipacujcunatapis Tayta Diosninchipa alli willapanta willapäcuycanna.› ");
INSERT INTO qxhNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chaymi Tayta Diosninchipa caćhan cashäta mana wasguijcuna sumaj cushicärinman. Imaman ćhayaptinsi, paycunata Tayta Diosninchi sumaj yanapan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chaura Ushyachicuj Juanpa caćhancuna cuticuriptin, juturashan runacunata Jesús niran: «Jamcunapis chunyaj pachaman aywar, Juanpa shiminta wiyarayquim, ¿au? Payga imatapis mana manchacujchu. Mana ishcay-quimsatachu rimaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Imamanraj aywashcanqui? ¿Alli müdanashtachu tarishcanqui? Mana. Alli müdanashta achic-achicyaycaj wasillaćhu juyaycajta tarinqui. Jatun auturdäcunalla alli-alliga cawan. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pï runataraj ashishcanqui? Chunyaj pachaćhu Juanpa shiminta wiyaycur, Tayta Diosninchipa willacujnin cashanta tantiyacärishcanqui. Payman waquin willacujcunapis mana tincuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanta caćhamunanpaj unayna Tayta Diosninchi musyachicuran. Shiminćhu nin: ‹Caćhäta ñaupapäshunayquipaj juc runata ñaupachishaj. Runacunata willapäcungapaj camaricushalla shuyaräshunayquipaj› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Sumaj wiyaycallämay. Chay-chicaj runa carsi, Ushyachicuj Juanman mayganpis mana tincunchu. Chaypis maygan runa mana alli ricash caycaptinsi, Tayta Diosninchipa maquinćhu cawajcunaman Juanpis mana tincunchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Juanpa shiminta wiyacur, runacuna llapan-yupay ushyacuran. Jillayta shuntaj chiqui runacunapis Tayta Diosninchipa shiminta ćhasquir, juchapita wanacurcur ushyacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseucunawan Moiséspa shiminta yaćhajcunam ichanga mana ushyacuranchu. Tayta Diosninchi llaquipaycaptinsi, mana wiyacuranchu. Maquinćhu puriyta mana munar, wasguiparan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chaymi wiyächipar Jesús niran: «Canan wichan runacunata, ¿imawanraj tincuchïman? ");
INSERT INTO qxhNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yupay-tucuj wamracunawanćhi tincuchishaj. Upa wamracuna-jina mana imatapis tantiyacunchu. ‹Cushicuywan jachwashun› nir quïnata tucapaptinpis, mana jachwanchu. ‹Llaquicuywan wagashun› niptinpis, mana waganchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Chay-jina Ushyachicuj Juan, tantata mana micujchu. Bïnutapis mana mallishachu. Chaypis Juanta ashllishcanqui: ‹Supay pucllacusha› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nuwatapis Tayta Diosninchi caćhamasha. Llapanta micü. Bïnutapis upü. Chaypis ashllircaycämanqui: ‹Shincanan-raycullar, paćhan-raycullar purin. Juchaćhu arujcunawanpis, jillayta shuntaj chiqui runacunawanpis purin› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Imata rimarsi, Tayta Diosninchi yarpashanta pipis mana chapanmanchu. Shiminta wiyacujcunaga ricsipalla cawan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Juc junajćhu fariseu Simón jutiyuj runa Jesústa jayachiran: «Micupacuj aywashun» nir. Chaymi wasiman ćhayar, Jesúspis micupacunanpaj jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jesús micupacuycashanta mayar, marca-pingay warmipis butïlla pirjümin aptash ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesúspa ćhaquinman jamacuycur, sumaj wagaran. Wiguinpis Jesúspa ćhaquinta ushmaran. Ajchanwan chaquichipuran. Mucharan. Jananmanpis pirjümita jaycapuriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jayachij fariseu runana yarparan: «Tayta Diosninchipa willacujnin carga, jucha-sapa warmi cashanta Jesús musyanman. Yatananpitapis witicunman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yarpashanta tantiyar, Jesús niran: «Simón, mä, tapucushayqui.» Niptin, Simónpis niran: «¿Imallataraj, Tayta?» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tincuchiypana Jesús niran: «Ishcaj runash juc runapa jagan caran. Jucninshi pichga paćhacta (500) jaga-tucuran, jucninnash pichga ćhuncallata (50). ");
INSERT INTO qxhNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jagan cutichiyta mana camäpacuptinshi, ishcaninta niran: ‹Jaganchi ushyaräcuchun. Ama cutichimaynachu› nir. Cananga mä, willamay. ¿Maygantaj jillayyuj runata sumaj llaquinga?» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tapuptin, Simón niran: «Achcata jaga-tucush-cajćhi, Tayta.» Jesúsna niran: «Au. Rasullanta rimarcushcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Warmita ricärir, niran: «Simón, cay warmita ricacunquiman. Wasiquiman ćhayamuptï, ćhaquïta mayllacunäpaj yacuta mana camapämashcanquichu. Cay warmim ichanga wiguinwanraj ćhaquïta chajchurcur ajchanwan pichapämasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ćhayamuptï, mana wamayämashcanquichu. Cay warmim ichanga sumaj wamayämasha. Jamaycushäpita-pacha ćhaquïtaraj muchasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ćhayamuptï, umäta wirawan mana pajpapämashcanquichu. Cay warmim ichanga pirjümitaraj ćhaquïman jaycapamasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sumaj tantiyacunquiman. Marca-pingay captinsi, warmipa juchantapis llapanta Tayta Diosninchi jungasha. Chaymi sumaj llaquipäman. Juchaynaj-tucujcunam ichanga janan shungulla Tayta Diosninchita manchapacun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jinarcur warmita niran: «Llapan juchayquita jungashcä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Simónpa wasinćhu juturaj runacuna Jesúspa shiminta wiyar, yarpaćhacuran: «¿Piraj cay runa? Jucha aparicushantapis jungacächin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesúsna warmita niran: «Yupachicamashayquipita Tayta Diosninchipa maquinćhüna cawaycanqui. Paymi yanapäshunqui allilla cawanayquipaj. Cuticuyna.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Marcan-marcan purir ćhunca ishcaywan caćhancunawan Jesús willapäcuran: «Maquinćhu cawananchipaj Tayta Diosninchi shuyaraycämanchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Allchacächishan warmicunapis Jesústa yanapar puriran. Magdalena Maríapis purïshiran. Paypita janćhis supayta Jesús jargush caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Susanapis, Juanapis, waquin warmicunapis purïshiran. Juanaga mandaj Herodespa capuralnin Cuzapa warmin caran. Warmicunaga charashancunawan Jesústa tarichiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Juc junajćhu chay-tucuy marcapita runacuna jutucaran Jesústa ricäcunanpaj. Chay-chicajta ricar tincuchiypa willapar, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Juc runash murupacuj aywaran. Machiptinshi, waquin muru caminuman ćhayasha. Caminuman ćhayajta runacuna lluchcar ushyasha. Pichuysacunapis pashacurcusha. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquin murunash jarapshu allpaman ćhayasha. Jarapshu captinshi juclla wiñarsi, chaquicäcusha. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquin murunash shata-shataman ćhayasha. Shata atayäcurcurshi, muru wiñamujtapis jarwashtärachisha. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waquin murunash alli allpaman ćhayasha. Sumajshi wayusha. Waquin juc murullapitash juc paćhacta (100) wayusha.» Willapäcuriycur, wiyächipaypa Jesús niran: «Rinriyujmi canqui. Tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Purïshijnincuna Jesústa tapuran: «Tincuchiypa willapäcushayquita mä, tantiyachimay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesúsna niran: «Mayna tantiyachishcaj: ‹Maquinćhu cawananchipaj Tayta Diosninchi shuyaraycämanchi› nir. Paypa shungun munashanta sumaj tantiyachishcaj. Mana wiyacujcunatam ichanga tincuchiyllapa tantiyachï wiyaycarpis, ricaycarpis, mana tantiyacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Tincuchiypa willapashäta sumaj tantiyacuy. Muruga Tayta Diosninchipa shiminwan tincun. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Caminuna chucru shungu runawan tincun. Chucru shungucuna Tayta Diosninchipa shiminta wiyarpis shungunman mana ćhayaptin, mana tantiyacunchu. Chaymi yangalla tantiyacushallantapis supay jungaycachin Tayta Diosninchipita witicunanpaj. Witicur, Tayta Diosninchita mana wiyacunchu. Maquinćhüpis mana cawanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jarapshu allpana janan shungu runawan tincun. Paycuna cushi-cushilla Tayta Diosninchipa shiminta ćhasquicun. Chaypis mana sapichashan-jina janan shungulla. Chaymi Tayta Diosninchita wiyacushan-janan ñacaycuna ćhayapuptin, witicurin. Mana ićhipunchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Shata wiñanan allpana tincupacaj runawan tincun. Paycuna Tayta Diosninchipa shiminta wiyan. Wiyarsi, imapäpis alläpa yarpaćhacur, jillayllata ashir, shungun munashallanta ashir, tincupacan. Chaymi Tayta Diosninchipa shiminta wiyash carsi, Tayta Diosninchipa shungun munashanta mana ruranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Alli allpana wiyacuj runawan tincun. Paycuna alli shungu cashpan Tayta Diosninchipa shiminta sumaj tantiyacur, manchapacur cawan. Ñacarpis, Tayta Diosninchipita mana witicunchu. Chaymi juc murulla alli wayushan-jina allita rurar cawan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jananmanpis Jesús niran: «Achquita ratarcachir, manash pipis manca rurinman, cäma ćhaquinman ćhuranmanchu. Manchäga patacmanshi ćhuran llapanta achicyänanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Willapashätapis imayllasi llap-llapanmi tantiyacunga. Mana pacacangachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chaymi sumaj tantiyacunquiman. Wiyacuptin, pitapis Tayta Diosninchi sumaj tantiyachinga. Mana wiyacujcunatam ichanga ichicllata tantiyashallantapis, jungaycachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Rimaycaptillan, Jesúspa mamanwan wauguincuna ćhayaran. Ichanga achcaj runa caycaptin, tincuyta mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaymi juc runa willaran: «Tayta Jesús, mamayquiwan wauguiquicunash jawaćhu shuyarpaycäshunqui. Jamwan tincuytash munaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesúsna niran: «Tayta Diosninchipa shiminta wiyacujcunaga pï-maypis mamäwan wauguïcunawanmi tincun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Juc junajćhu: «Yacu püsuta chimpashun» nir purïshijnincunawan-ima Jesús bütiman jigaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aywarcaycashanćhu Jesús puñucäcuran. Puñucäcushancaman shucucuy wayra ricacamusha. Yacu büchiypa-büchir bütiman yaycuycaran. Wañuy jananćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaura purïshijnincuna Jesústa ricchachiran: «Tayta Jesús, wañuy jananchićhüna» nir. Jatarcur, yacutawan wayrata Jesús piñacuran. Piñacuptin, shucucuy wayra ćhawacäcuran. Yacupis puñucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Purïshijnincunatana niran: «¿Imanirtaj mancharinqui? ¿Janan shungullachu Tayta Diosninchiman yupachicunqui?» Purïshijnincuna quiquin-pura parlanacäriran: «¿Piraj cay runa? Piñacuriptin, shucucuy wayra ćhawacäcun. Yacupis puñucäcun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Püsuta chimpar, Gerasa quinranman purïshijnincunawan Jesús ćhayaran. Chay quinran Galilea marca chimpanćhu caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bütipita llucshiriptin, Gerasa runa Jesústa ćhayapuran. Chay runa supaypa maquinćhu purir, jalapaćhalla puricuj. Wasićhüpis mana juyajchu. Manchäga pantyunllaćhu juyäcuj. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesústa ricar ñaupanćhu jungurpacuycur, japariran: «Llapanta Camaj Tayta Diosninchipa Wawan Jesús, ¿imanirtaj ashipämanqui? Ama ñacaycachimaychu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesús jarguptin, supaycuna japarish caran. Pucllacush captin, runa juyuyash caran. Cadinawan maquin-ćhaquinta wancurcur runa täpaptinpis, raćhirij. Chunyaj pachamanpis supay apacuj. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chaura: «¿Imanirtaj ashipämanqui?» niptin, Jesús tapuran: «¿Imataj jutiqui?» nir. Tapuptin, chay-chicaj supay cashpan: «Batallun jutï» niran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jesústa llapan supay mañacuran: «Chacaj pachaman ama jitarpaycamaychu, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chagapa janallanćhu chay-chica cuchi pagupacurcaycaran. Chaymi supaycuna Jesústa mañacuran: «Cay runata caćharir, cuchicunatana pucllacushaj» nir. Chaynuy mañacuptin, Jesús auniran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Auniptin runata caćhariycur, cuchicunata pucllacuran. Cuchicunana jishyayar, chagapita yacuman jigapurcuran. Shugupacaypa llapan wañuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chaura chayta ricar, cuchi michijcuna juclla marcanman jishpicäriran. Aywaycur, ćhacracunaćhüpis, marcaćhüpis imallata ricashantapis llapanta willacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Runacuna ricäcuj aywacullaran. Jesúsman ćhayar, supaycuna pucllacushan runata allchacashta tariran. Müdanashana caycaran. Jesúspa ñaupallanćhu jamaraycaran. Chaynuyta ricaycur, juyupa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ricajcuna ćhayamuj runacunata willaparan supay pucllacushan runata Jesús imanuypa allchacächishantapis. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa marca runacuna manchacur, Jesústa niran: «Tayta, cay marcapita aywacuy, ari.» Niptin bütiman jigarcur, cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mana llucshiptillan, allchacaj runa Jesústa mañacuran: «Pushacamay, Tayta» nir. Jesúsna ");
INSERT INTO qxhNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","niran: «Mana camacanchu. Wasiquiman cuticuy, ari. Llapan runata willapanquiman: ‹Tayta Diosninchi yanapämasha› nir.» Chaura marcanman cutircur, willacuran: «Jesús allchacächimasha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Chaura püsu chimpanman Jesús ćhayaptin, shuyaj runacuna sumaj cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Niycaptillan, Jairo ćhayaran. Payga shuntacäna wasićhu mayur runa caran. Jungurpacuycur, Jesústa mañacuran: «Tayta, wasïman aywashun. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Japallan warmi wamrä wañucuycan. Ćhunca ishcaywan watayujllarämi» nir. Jairuwan aywaycaptin achcaj runa aywar, Jesústapis quićhquiparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ćhunca ishcaywan watana yawar-apaywan jishyaj warmipis tallucash aywaycaran. Warmiga jampicujcunawan jampicur, imancunatapis ushyapacaran. Pipis mana allchacächiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chaymi jipallanpita tariparcur, Jesúspa müdananta yataycuran. Yataycuptillan, yawar-apaynin ćhawacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chaura Jesús tapucuran: «¿Pitaj yataycamasha?» nir. Niptin, llapan runa niran: «Mana nuwachu. Mana nuwachu.» Pedruna niran: «Achcaj runa quićhquipaycäshuptiqui, ¿imanirtaj tapumanqui: ‹¿Pitaj yataycamasha?› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesúsna niran: «Shuyninpa pipis yataycamasha. Yatamajtaga munaynïwanmi allchacächishcä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Warmina pacacuyta mana camäpacur, sicsicyaycar Jesúspa ñaupanman jungurpacuycuran. Llapanpa ñaupanćhu juyupa jishyashantapis, Jesúspa müdananta yataycur allchacäcushantapis willacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesúsna niran: «Wawallau wawa, yupachicamashayquipita allchacashcanqui. Mana yarpaćhacullarna, wasiquiman cuticuy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús rimayta mana ushyaptillan, Jairupa wasinpita caćha ćhayamuran. Jairuta niran: «Tayta, wamrayqui wañucäcushana. ¿Imapänataj tayta Jesústa pushanquipis?» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nishanta wiyar, Jesús niran: «Tayta Jairo, ama llaquicuychu. Nuwaman yupachicamanquiman. Wamrayqui allchacanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairupa wasinman ćhayaptin, aya chutarashanman yaycuchiran wañucuj wamrapa maman-taytanta, Pedruta, Santiaguta, Juanta. Waquincunatana mana yaycuchiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wasi puncućhu runacuna wagarcaycaran. Atarcaycaran. Jesúsna niran: «Ama wagaychu. Wamra mana wañushachu. Manchäga puñucashalla caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Täpajcuna wamra rasunpa wañushanta musyashpan Jesústa asiparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wañush wamra jipashta maquinpita charircur, Jesús niran: «Wamra, ricchay.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chaura alman cutiptin, cawaricurcuran. Cawaricurcuptin, niran: «Jaray.» ");
INSERT INTO qxhNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wamrapa maman-taytan juyupa manchariran. Jesúsna niran: «Wamrayquita cawarachishäta pitapis ama willapanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ćhunca ishcaywan caćhancunata shuntaycur cargunman ćhuraycur, Jesús niran: «Nuwapita munayniyuj caycanqui supaycunata jargunayquipäpis, jishyaćhucunata allchacächinayquipäpis.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nircur caćharan Tayta Diosninchipa shiminta willapäcunanpaj, jishyaćhucunata allchacächinanpaj. Caćhar niran: «Willapäcur ninqui: ‹Maquinćhu purichimänanchipaj Tayta Diosninchi shuyaraycämanchi› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Purir, imatapis ama apanquichu. Ama apanquichu: garutiquitasi, jipiquitasi, mircapayquitasi, jillayniquitasi, rucanayquitasi. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Juc wasiman pachacur, jucläpa aywacushayquicaman jinallanćhu pacharäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ćhayashayqui marcaćhu mana ćhasquishuptiqui, ćhaquiquita pichacurir aywacunqui: ‹Mana ćhasquicamashayquipita ñacayman ćhayanquipaj› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chaymi marcan-marcan purir caćhancuna Tayta Diosninchipa shiminta willapäcäriran. Jishyaćhucunatapis allchacaycächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chay wichan Galilea marcacunata mandaj Herodespis Jesús ima-imata rurashantapis mayaran. Ichanga tantiyayta mana atiparanchu. Jesús pï cashanta mana musyar, runacuna wichaypa-uraypa rimar niycaran: «Ushyachicuj Juanćhi wañushanpita cawarimusha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Waquinshi nircaycaran: «Willacuj Elíasćhi.» Waquinnash niycaran: «Unay willacujcunaćhi maygan carsi, cawarimusha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","«Ushyachicuj Juanćhi cawarimusha» niptin, mandaj Herodes niran: «Ushyachicuj Juanpa umanta quiquï ruguchish caycaptï, ¿piraj chay Jesús? Chay runata ricsicüman» nir Jesúswan tincuyta sumaj munaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Caćhancuna willapäcur purishanpita Jesúsman cutiran. Imata rurashancunatapis willaran. Jesúsna paycunata pushacurcur, Betsaida marcaman aywacuran: «Yata juyapärishun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Shuyninpa aywacuptinsi aywashanta musyar, chay-chicaj runa Jesústa tariparan. Jesúsna tucuy-jinanpa tantiyachiran Tayta Diosninchipa maquinćhu cawananpaj. Jishyaćhucunatapis allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pacha chacanaycaptin, purïshijnincuna Jesústa niran: «Chunyaj pachaćhu carcaycanchi. Runacuna marcacunaman micuy ashij aywacuchun. Pachacunanpäpis ashimunman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chaynuy niptin, Jesús niran: «Jamcuna jaranquiman.» Paycunana niran: «Pichga tantallatawan ishcay piscädullata charaycä. Chay-chicaj runata jarananchipaj, ¿tanta rantimuj aywanätarächu munanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Runacuna pichga waranga-ima (5,000) juturpaycaran. Chaypis purïshijnincunata Jesús niran: «Llapan runata pichga ćhunca-caman (50) jamachiy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesúspa shiminta wiyacur, llapanta jamachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesúsna pichga tantatawan ishcay piscäduta aptarcur, mañacuran: «Taytallau Tayta, ima allish tarichillämashcanqui» nir. Nircur tantacunata paquircur-paquircur, piscäduta raćhircur-raćhircur, purïshijnincunata macyaran llapanta jarananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Runacuna puchupacushancaman micuran. Micucurcuptin, puchupacushanta ćhunca ishcaywan (12) canista juntataraj shuntaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc junajćhu Jesús quiquillan Tayta Diosninchita mañacuycaran. Niycashanćhu purïshijnincunata tapuran: «Runacunapaj, ¿pitaj cä?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Paycuna niran: «Waquin runash nin: ‹Ushyachicuj Juan.› Waquinnash nin: ‹Elías.› Waquinnash nin: ‹Pï carpis, Tayta Diosninchipa unay willacujnin canga. Cawarircamurćhi puriycan.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chaura quiquincunata Jesús tapuran: «Jamcunapäga, ¿pitaj cä?» nir. Pedruna niran: «Washäcujmi canqui. Tayta Diosninchi caćhamushcashunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chaura Jesús sumaj piñaparan: «Tayta Diosninchi caćhamashan Washäcuj cashäta pitapis ama willapanquichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Purïshijnincunata Jesús niran: «Tayta Diosninchi caćhamasha. Chaypis sumajraj ñacashaj. Mayur runacunapis, mayur cüracunapis, Moiséspa shiminta yaćhajcunapis wasguimanga. Wañuchimanga. Chaypis quimsa junajta Tayta Diosninchi cawarachimanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jinarcur llapan runata Jesús niran: «Pipis purïshimayta munar, quiquinpa shungun munashanta ama ruranmanchu. Manchäga nuwa-janan ñacachiptinsi, rusćhu wañuchiptinsi, waran-waran shimïta wiyacuchun. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ñacaytapis, wañuytapis manchacur maquïćhu puriyta mana munar, ushyacayman ćhayangapaj. Maquïćhu purir llapanninta jaguijcunam ichanga imaycamanpis Tayta Diosninchipa maquinćhu cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sumaj rïcuyayta tarirpis ushyapacayman ćhayaptin, rïcu cayninga, ¿imapäraj alli? Llapan imancunapis ushyacanga. Quiquinpis ñacayman ćhayanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","«Tayta Diosninchi caćhamasha. Pipis shimïta mana wiyacushpan wasguimaptin, nuwapis janaj pachapita achic-achicyaycar cutimur, wasguishaj. Cutimuptï, Tayta Diosninchipa anjilnincunapis achic-achicyaycar yanagämanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sumaj tantiyacunquiman. Tayta Diosninchi llapan runata maquinćhu purichinga. Chaynuy cananta waquinniqui manaraj wañullar ricanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chaypita pusaj junajta-ima Tayta Diosninchita mañacuj Jesús aywaran. Pedruta, Santiaguta, Juanta pushacurcur, puntaman jigaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tayta Diosninchita mañacuycaptin, Jesúspa jajllanpis, müdananpis achic-achicyaj yurajman ticracuriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Unay willacuj Moiséswan Elíaspis ricaripuran. Paycunapis achic-achicyaycaran. Jesúswan parlaycaran. Cay pachapita aywacur Jerusalén marcaćhu imaman ćhayanantapis Jesústa willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Niycashanćhu Pedro, Santiago-ima, Juan-ima puñucäcuran. Ricchapacurirmi ichanga, achic-achicyaycajta Jesústapis, ishcaj runacunatapis ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moiséswan Elías aywacuyta jallaycuptin, mana yarpaćhacullar Pedro rimariran: «Tayta Jesús, cayćhüga alli juyäcuymi. Quimsa tacmata rurarishaj: jucta jampaj, jucta Moiséspaj, jucta Elíaspaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro rimaycaptillan, quimsanta pucutay chapacurcuran. Jesúspa purïshijnincuna juyupa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pucutay rurinpita Tayta Diosninchi nimuran: «Jesúsga Wawämi. Payllata acracushcä. Shiminta wiyacuy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Rimashan ćhawacäcuptin, quiquillantana Jesústa ricaran. Chay wichan quimsaj purïshijcuna imata ricashantapis mana willacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Warannin junaj puntapita yarpamuptin, achcaj runa Jesústa taripaj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Runa ćhaupinpita juc runa jayacuran: «Tayta Jesús, yanapaycallämay. Wawämi ñacaycan. Chaylla wamräpis. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Charir, supay japarächin. Tapsir ushyan. Pushgayta ajtuchin. Sajtar ushyan. Mana caćharinchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Supayta jargunanpaj waquin purïshijniquicunata mañacurä. Ichanga mana camäpacuranchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chaynuy mañacuptin, Jesús niran: «Jamcuna Tayta Diosninchiman mana yupachicunquichu. Juchallaćhüpis aruycanqui. ¿Imaycamanraj tantiyachishayqui? Mana yupachicamaptiqui, yamacashcä.» Nircur wamrapa papäninta niran: «Wamrayquita mä, apamuy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wamranta ćhayaycächiptin, supay pampaman sajtariran. Tapsir ushyariran. Chaymi supayta Jesús piñacuran. Piñacuriptin, supay aywacuran. Chaura wamrana allchacäcuran. Allchacashtana papäninwan tincuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tayta Diosninchi allchacächishanta ricar, llapan runa mancharisha: «¿Imatataj ricanchi? Tayta Diosninchi munayniyuj, ¿au?» nir. Runacuna mancharish caycaptin, purïshijnincunallata Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Rimashäta sumaj wiyacunqui. Ama junganquichu. Tayta Diosninchi caćhamasha. Chaypis juc runa charimar, juyu runacunapa maquinman ćhayachimanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Purïshijnincunam ichanga mana tantiyaranchu. Tayta Diosninchi mana camacächiptin, tantiyacuyta mana camäpacuranchu. Tapucuytapis manchacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Juc junaj Jesúspa purïshijnincuna mayur runa cayta ashir, piñanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Shungun munashanta tantiyar, juc wamrata Jesús jayaran. Lädullanman ićhiycachir, ");
INSERT INTO qxhNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","niran: «Pipis yupachicamashan-janan wamracunata alli ricar, nuwatapis alli ricaman. Alli ricamarga, caćhamaj Tayta Diosninchitapis alli rican. Chaymi sumaj tantiyacunquiman. Pampaman ćhurash runacunata alli ricarraj, mayur runa cayman ćhayanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan Jesústa niran: «Tayta, nimashayquinuylla supayta jarguycajta ricapäcushcä. Chaypis mana purïshimaptinchi, mićhapäcushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesúsna niran: «Ama mićhanquimanchu. Mana chiquimashpanchi yanapaycämanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tayta Diosninchi janaj pachaman shuntananpaj wallcana pishiptin, Jerusalén marcaman aywananpaj Jesús camaricuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ñaupanta caćhacuran: «Pachacunanchipaj Samaria quinranćhu camaricunqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jerusalén marcaman aywaycashanta musyarmi ichanga Samaria runacuna pachächiyta mana munaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaura purïshijnin Santiaguwan Juan niran: «Tayta Jesús, Samaria runacunata nina tamyawan ushyarachishun, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","«Ushyarachishun, ¿au?» tapuptin, Jesús piñacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chaypita juclä marcapa aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aywacurcaycaptin, juc runa Jesústa niran: «Tayta, aywashayquipa aywayta munä. Maypapis purimushun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesúsna niran: «Atujcunapis maćhayninćhu tiyan. Pichuysacunapis jishuyuj. Nuwapam ichanga Tayta Diosninchipa caćhan captïsi, mayman ćhayanäpäpis wasï mana canchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Juc runatapis Jesús niran: «Purïshimay.» Chaura mana munaranchu: «Tayta, papänïtaraj ricashaj. Wañucuptin, pampaycurraj purïshishayqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesúsna niran: «Papäniqui chapata ama rurashunquimanchu. Juclla purïshimay. Wañushta wañush-masincuna pampachun. Tayta Diosninchipa shiminta willacuj aywashun. Payga shuyaraycämanchi maquinćhu purichimänanchipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Juc runana Jesústa niran: «Tayta, nuwapis aywäshishayqui. Ima captinpis, ichicllata shuyaycallämay. Mamä taytätaraj willaycamushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesúsna niran: «Yapyajcuna jipaman ticrärir, wicsu-wicsu yapyan. Tayta Diosninchipa shiminta llapan shunguyquiwan wiyacunquiman; ama janan shungullaga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaypita janćhis ćhunca ishcaywan (72) purïshijnincunata acracuran caćhacunanpaj. Ishcaycaman-ishcaycaman caćharan: «Ćhayanä marcacunaman ñaupay» nir. Nircur tincuchiypa niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","«Micuy puguraycaj-yupay chay-chicaj runa Tayta Diosninchipa shiminta wiyaj-wiyajlla shuyarpaycan. Shiminta willacujcunam ichanga wallcajlla. Chaymi willacujcuna juclla yapacämunanpaj Tayta Diosninchita mañacäriy. Shiminta ćhasquicujcunata shuntamunan carcaycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ichanga sumaj tantiyacäriy. Shimïta willacuptiqui, runacuna chiquishunquipaj. Uyshata liyun rurinman jaycurij-yupay caćhaycaj. Aywayna. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Shimïta willapäcuj aywar, jillayniquitapis, jipiquitapis, rucanayqui llanguiquitapis ama apanquichu. Piwanpis caminućhu tincur, ama mayaräcunquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Juc wasiman ćhayar: ‹¿Jaucallachu? Allilla juyaycullay› nir wamayanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Allilla cawayta munar ćhasquishuptiqui, Tayta Diosninchipis yanapanga allilla cawananpaj; mana ćhasquishuptiquim ichanga, mana. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pachächishuptiqui, chay wasillaćhu pachacunqui. Wasin-wasin ama purinquichu. Jarashuptiqui, llapanta ćhasquicunqui. Shimïta willacujcunaga micush-upush cawanan camacan. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«May marcaćhüpis jarashuptiqui, ćhasquicunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jishyaćhucunatapis allchacächinqui. Willapanqui: ‹Tayta Diosninchi shuyaraycämanchi. Maquinćhüna purichimäshun› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","«Juc marcaćhu mana ćhasquishuptiquim ichanga, llapanta ninqui: ");
INSERT INTO qxhNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Tayta Diosninchi shuyaraycämanchi. Maquinćhüna purichimäshun. Jamcunam ichanga wasguishcanqui. Chaymi ñacayman ćhayanquipaj. Jamcunata mana ricanäpaj ćhaquïtapis pichacurir aywacü. Shimïta ama junganquichu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sumaj tantiyacunquiman. Cay pacha ushyacaptin Sodoma runacunata ñacachirpis, Tayta Diosninchi llaquipangaraj. Payta wasguipajcunatam ichanga mana llaquipällar ñacachinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Corozaín runacuna, Betsaida runacuna, Israel runa captiquisi, juyupa Tayta Diosninchi ñacachishunquipaj. Pay camacächiyninpa shiminta willapaycaptïsi, jishyaćhucunata allchacaycächiptïsi, chay-chicaj runata jaraycaptïsi, supaycunata jarguycaptïsi, maquinćhu cawayta mana munashcanquichu. Jäpa Tiro marca runacunawan jäpa Sidón marca runacunam ichanga jishyaćhucunata allchacächishäta ricar, supaycunata jargushäta ricar, mayna Tayta Diosninchipa shiminta ćhasquicur juchanpita wanacunman caran. Wanacushan musyacänanpaj llaquicuywan mayna waganman caran. Umanman ućhpata pićhucunman caran. Jaćhga müdananta ushtucunman caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chaymi Tiro runacunatawan Sidón runacunata Tayta Diosninchi yangallaraj ñacachingapaj. Jamcunatam ichanga ricaycarsi mana wanacushayquipita cay pacha ushyacashan junaj juyupa ñacachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Cafarnaún runacuna: ‹Janaj pachaman aywashaj› niptiquisi, yarpashayqui mana camacangachu. Chacaj pachaman Tayta Diosninchi jargushunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jinarcur caćhancunata niran: «Shimiquita wiyacujcuna nuwatapis, Tayta Diosninchitapis wiyacun. Shimiquita mana wiyacujcunam ichanga nuwatapis, caćhamaj Tayta Diosninchitapis wasguiycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Juc junajćhu janćhis ćhunca ishcaywan (72) caćhacuna cushish cutiran. Jesúswan tincur, niran: «Tayta, shimiquita wiyacur jarguptï, supaycunapis änir, aywacun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesúsna niran: «Jarguptiqui, supaycunapa mandajninta janaj pachapita shicwamushanta ricashcä. Räyu-jina pampaman shicwamusha. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jamcunata munayniyuj canayquipaj ćhurashcaj. Chaymi supaycunapis mana ićhipushunquipächu. Wañuchicuj curucunatapis, alacrancunatapis lluchcar ushyarinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Chaypis supayta jargushayquipita alläpa ama cushicärinquimanchu. Cushicurga, Tayta Diosninchipa wawan cashayquipita cushicunquiman. Janaj pachaćhu acta librunćhüpis jutiquicuna isquirbiraycanna.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Niycaptillan Espíritu Santu shacyächiptin, Jesúspa shungun achicyacäcusha. Chaymi niran: «Papällau Papä, jatunpa cushicü. Alli shungu runacunata wamra-jina wiyacuj captin, yarpashayquita musyachishcanqui. Yaćhaj-tucujcunatam ichanga shunguyqui yarpashanta mana musyachishcanquichu. Cay pachapis, janaj pachapis maquiquićhu caycan. Shunguyqui munashanta llapanta camacächishcanqui, Papä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jinarcur llapan runata niran: «Papänï llap-llapanta maquïman ćhurasha. Wawan cashäta Papänï musyan. Wawan carmi, Papänï pï cashantapis musyä. Yanapaptïraj, pipis Papänïpa shungunta musyapanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaypita purïshijnincunallata niran: «Cushicärinquiman. Llapan rurashäta ricanayquipaj Tayta Diosninchi yanapaycäshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sumaj tantiyacunquiman. Unay willacujcunapis, mandajcunapis ricamayta munaran. Ima-imata rurashätapis ricayta munaran. Shimïtapis wiyayta munaran. Ichanga mana camäpacuranchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moiséspa shiminta yaćhaj runa achäquita ashipällar, Jesústa tapucuran: «Tayta, ¿imatataj ruräman Tayta Diosninchipa maquinćhu imaycamanpis cawanäpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesúsna niran: «Moiséspa shiminta musyanqui, ¿au? ¿Imanintaj liguishayqui?» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chaura niran: «Moisés isquirbishanćhu nin: ‹Llapan shunguyquiwan Tayta Diosninchita manchapacäriy. Quiquiqui alli ricacushayqui-jina runa-masiquitapis alli ricanquiman.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesúsna niran: «Rasullanta rimashcanqui. Rimashayquita ćharcur, Tayta Diosninchipa maquinćhu imaycamanpis cawanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chaypis alli llucshiyta munar, yaćhaj runa Jesústa tapuran: «¿Pitaj runa-masï?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chaura tincuchiypa willapar, Jesús niran: «Juc junajshi Israel runa Jerusalén marcapita Jericó marcaman aywaycaran. Asaltanticunash shuyaycur, llapan imancunatapis jićhuran. Müdanantapis jićhuran. Wañunashancamanshi magaran. Chutaraycajtash jaguiycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","«Mayllanta mana yarpashpita cürapis aywaycaran. Runa chutaraycajta ricar carunijpa tumarcurshi, aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cüra yanapaj runapis chay quinranpa aywaycaran. Runa chutaraycajta ricar carunijpa tumarcurshi, aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Samaria runapis chay quinranpa aywaycaran. Runa chutaraycajta ricarshi ichanga, sumaj llaquipasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jucllash charipacusha. Jirincunatapis jampircurshi watapasha. Bürunman jigarcachirshi, wasiman apasha. Sumaj ricasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Waranin tuta wasiyujta nisha: ‹Cay runata ricapaycallämay. Catay jillay. Pishiptin-imaptin, jillayniquita ćhurapamanqui. Cutimur, cutichilläshayqui› Jinarcurshi Samaria runa aywacusha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Willapayta ushyarcur, yaćhaj runata Jesús tapuran: «¿Maygantaj runa-masinta llaquipasha? ¿Cürachu? ¿Cüra yanapajchu? ¿Samaria runachu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moiséspa shiminta yaćhajna niran: «Llaquipar yanapaj-cajmi.» Jesúsna niran: «Cananpita llaquipäcuj runa-jina jampis runa-masiquita llaquipanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jerusalén marcapa aywaycashanćhu juc marcaman purïshijnincuna-ima Jesús ćhayaran. Martapa wasinman ćhayaptin, pachächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa ñañan caran María. Jesús willapäcuptin, jamacuycur María sumaj wiyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martam ichanga wasi rurayninwan tincuypa-tincuycaran. Chaymi Jesústa niran: «Tayta, ñañäta piñacamuy. Yanapamächun. Quiquilläta ima ruraytapis jaguiparamasha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesúsna niran: «Martallau Marta, ¿imanirtaj warminqui? Wasi rurayniquicunallawan tincuypa-tincuycanqui. Allipaj willapashäta mana wiyayta munanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maríam ichanga sumaj wiyacuycan. Wiyacushanta shungunpita pipis mana jićhungapächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Juc junaj Tayta Diosninchita Jesús mañacuycaran. Mañacuyta ushyarcuptin, juc purïshijnin niran: «Tayta Jesús, Tayta Diosninchita mañacunäpaj yaćhachimay, ari. Ushyachicuj Juan purïshijnincunata yaćhachishannuylla yaćhachimay.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesúsna niran: «Tayta Diosninchita mañacur ninqui: ‹Papäninchi, Llapanpis manchapacuyculläshunqui. Maquiquićhu cawaycachillämay. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Waran-waran cawanäpäpis tariycachillämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Juchäcunatapis ama yarparaynachu. Manchäga chiquimajcunata alli ricashäpita alli ricaycallämay. Juchaman ćhayanätapis ama camacaycachillaychu.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jananmanpis Jesús niran: «Pullan-pagasshi ricsinacushayquita jayacunquiman: ‹Tayta, quimsa tantallata mañacushayqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ricsinacushä runa yargaycar ćhayamusha. Jaranäpaj mana imäpis canchu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jayacuptiquish, nishunquiman: ‹Ama rimapämaychu. Puncü wićhgaraycan. Wamräcunapis puñuycan. Mana jatarimümanchu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chaypis yaparir-yaparir jayacuptinshi, jatarimunman. Mañacushantash tarichinman. Jatarimunga manash ricsinacushayquipitachu, manchäga: ‹Runacuna pampaman ćhuramanga› nishpan. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Chay-jina mañacuptiqui, Tayta Diosninchi jushunquipaj. Ashiptiqui, tarichishunquipaj. Puncupita jayacuptiqui, quićhapushunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mañacujcuna ćhasquin. Ashijcunapis tarin. Puncupita jayacujcunatapis quićhapun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Wamrayqui yarganar piscäduta mañacushuptiqui, ¿wañuchicuj curuta jaranquimanchuraj? ");
INSERT INTO qxhNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Runtuta mañacushuptiqui, ¿alacranta jaranquimanchuraj? ");
INSERT INTO qxhNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jamcuna jucha-sapa carcaycarsi, wamrayquicunata allita jaranqui. Tayta Diosninchipis llaquipäcuj. Mañacuptiqui, janaj pachaćhu caycashpan alli-allillata tarichishunquipaj. Espíritu Santupa maquinćhüpis purichishunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cuti upayächicuj supayta Jesús jarguran. Jarguriptin, upa runa rimariran. Upa runa rimariptin, llapan runa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waquin runam ichanga Jesústa pampaman ćhurar, niran: «Supaycunapa mandajnin Beelzebulta jayararshi, supaycunata jarguycan. Mana Tayta Diosninchitachu jayaraycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquin runana achäquita ashipashpan Jesústa niran: «Tayta Diosninchi camacächiyninpa mä, imallatapis ruray.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Supay yanapashanta yarpaptin, tincuchiypa Jesús niran: «May marcaćhüshi quiquin-pura ticrapanacur, wacpa-caypa aywacärin. May wasićhüpis majanwan ticrapanacur, raquicaymanshi ćhayan. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chaymi mayur supaypis supay-masinwan ticrapanacur, ima ruraytapis mana camäpacunmanchu, ¿au? Chaynuy captin, ¿imanirtaj Beelzebulta jayarar supaycunata jargushäta yarpanqui? ");
INSERT INTO qxhNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mä, tapushayqui. Waquinniqui supayta jargur, ¿pita jayarartaj jarguycanqui? ¿Tayta Diosninchitachu, supaytachu jayaraycanqui? ‹Tayta Diosninchita› nimaptiqui, tumparcaycämashayquita tantiyacushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","«Sumaj tantiyacunquiman. Tayta Diosninchi camacächiyninpa supaycunata jargur, Tayta Diosninchi munayniyuj cashanta musyachicuycä. Chayta ricar, tantiyacunquiman maquinćhüna Tayta Diosninchi runacunata puriycächishantapis. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tincuchiypa willapäshayqui. Callpayuj runa garutinwan wasinta täpaptin, pipis manash yaycunchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sumaj-sumaj callpayuj runa ricarimurshi ichanga garutintapis jićhurir, wicaparinga. Maquinpita imantapis jićhurirshi, jucninta-jucninta raquiparinga. Nuwapis sumaj callpayuj runa-jina supaycunata jarguycä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Tayta Diosninchi caćhamashanta mana ćhasquicuyta munar, chiquircaycämanqui. Tayta Diosninchipa maquinman runacunata shuntayta mana yanapämar, chapata rurarcaycämanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Supay imata rurashantapis tantiyacunquiman. Runapita jargush car, chunyajćhüshi purin. Jamaytapis manash tarinchu. Mayćhüpis jamayta mana tarir, yarpaćhacun: ‹Chay runaman cuticushaj› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cutirshi, chay runata pichapacush wasita-jina, jäcuycaj wasita-jina tarin. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chayshi janćhis mas juyu supay-masincunata pushacurcur, runaćhu tiyananpaj cutin. Supaycuna cutiptin, juyu cashanpita masnash runa juyuyacäcun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús rimaycaptillan, llapanpa ćhaupinpita juc warmi jayacuran: «Tayta Jesús, mamayqui imaraj cushicun. Ima allish jishpichishcashunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesúsna niran: «Llapan wiyacujcuna cushish cawan. Shiminta wiyacuptin, pitapis Tayta Diosninchi yanapan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Chay-chicaj runa shiminta wiyananpaj jutucaptin, Jesús niran: «Juyu runa carcaycanqui. Tayta Diosninchi camacächiyninpa imallatapis ruranäta munarcaycanqui. Tantiyayta munar, unay willacuj Jonáspa willapanta yarparanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chaypis unay willacuj Jonás imamanpis ćhayashallanta ricanquipaj. Paytaga Tayta Diosninchi caćharan Nínive marca runacunata willapaj. Jonásta caćhashan-jina nuwatapis caćhamasha canan wichan runacunata willapänäpaj. Tantiyacuyta munar, ricamanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sumaj tantiyacunquiman. Cay pacha ushyacaptin, llapan runata jucha aparicushanpita Tayta Diosninchi ñauquiptin, Saba marca mandaj warmipis cawarimunga. Paymi ñauquishunquipaj: ‹Mandaj Salomónpa shiminta wiyar, Tayta Diosninchi llaquipäcuj cashanta tantiyacushcä. Jamcunam ichanga mana tantiyacärishcanquichu› nir. Chay warmi carupita-pacha shamuran mandaj Salomón rimashanta wiyananpaj. Wiyar, Tayta Diosninchipa shiminta ćhasquicuran. Mandaj Salomón yaćhaj carsi, nuwaman mana tincushachu. Chaypis shimïta wiyacuyta mana munanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Cay pacha ushyacaptin, Nínive marca runacunapis cawarimunga. Paycuna ñauquishunquipaj: ‹Tayta Diosninchipa shiminta mana wiyacushcanquichu› nir. Nínive runacuna Jonás willapäcuptin, wanacäriran. Jonás Tayta Diosninchipa willacujnin carsi, nuwaman mana tincunchu. Chaypis shimïta wiyacuyta mana munanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Achquita ratarcachir, pipis manash pacaycunmanchu. Manchäga patacmanshi ćhuran llapanta achquipänanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","«Achquiga shimïwan tincun. Ñawinchiwan llapantapis ricanchi. Ñawinchi achquita ricaptin, shungunchipis achicyacäcun. Shunguyquiman shimï ćhayaptin, Tayta Diosninchipa shungun munashanta tantiyacunquipaj. Shunguyquiman mana ćhayaptinmi ichanga, jucha aruyllaćhu cawanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chaymi Tayta Diosninchipa shungun munashanta sumaj tantiyacunquiman. Ama upa-tucunquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tayta Diosninchipa shiminta llapan shunguyquiwan wiyacur, manchapacur cawanquiman. Tayta Diosninchipa maquinćhu cawashayquita llapan runa musyanga. Achäquitapis mana taringachu pampaman ćhurashunayquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Rimayta ushyarcuptin, juc fariseu runa Jesústa wasinman pusharan: «Micupacushun» nir. Wasiman ćhayar, maquinta mana awicullar micunanpaj Jesús jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Maquinta mana awicuptin, fariseu runa jamurparan: «Tayta Diosninchita mana manchapacur, yaćhacashanchitapis mana ćharcunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesúsna niran: «Tayta, fariseu-masiquicunawan janallan awish mati-niraj carcaycanqui. Runa ricanallanpaj alli-tucunqui. Mallaj cashayquita shunguyqui musyaraycan. Jucha rurayllapaj wañunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Upa-rinri canqui. Tayta Diosninchi mana janallanchitachu camasha. Manchäga shungunchitapis camasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tayta Diosninchi alli ricashunayquipaj wacchacunataraj llapan shunguyquiwan yanapanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Fariseucuna, llaquicärinquiman. Juyupa ñacanquipaj. Alli ricash cayta munar, llapan imayquicunapitapis Tayta Diosninchipaj raquinqui. Irbabuynatasi, rüdatasi, caldu jaćhatasi raquinqui. Chaypis runa-masiquita mana llaquipanquichu. Tayta Diosninchitapis mana manchapacunquichu. Paypa-cajta raquir, allita ruraycanqui. Ichanga llapan shunguyquiwanpis manchapacunquiman. Runa-masiquitapis alli ricanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Fariseucuna, llaquicärinquiman. Juyupa ñacanquipaj. Shuntacäna wasiman ćhayar, ñaupa-ñaupallaćhu jamayta ashinqui. Läsacunaćhüpis llapan runa manchapacushunayquita munanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Fariseucuna, llaquicärinquiman. Juyupa ñacanquipaj. Waquin runacuna shunguyqui ima-niraj cashantapis mana musyar: ‹Alli runa› nishunqui. Chaypis mïchu-jina carcaycanqui. Jananga alli. Rurinćhüna aya ismuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesús piñacuptin, Moiséspa shiminta yaćhaj runa jataricurcuran: «Tayta, fariseu-masïcunata piñacur, nuwacunatapis ashlliycamanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesúsna niran: «Moiséspa shiminta yaćhajcuna, llaquicärinquiman. Juyupa ñacanquipaj. Runacunata tucuy-tucuyta yaćhachinqui. Ćharcunan sasa-cajcunatapis yaćhachinqui. Quiquiquicunam ichanga juc maquillasi mana yanapanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Moiséspa shiminta yaćhajcuna, llaquicärinquiman. Juyupa ñacanquipaj. Unay auquilluyquicuna Tayta Diosninchipa willacujnincunapa shiminta mana wiyacur, wañuycachiran. Jamcunana unay willacujcunapa mïchunta picharcaycanqui. Ichanga shiminta mana wiyacärinquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mïchunta pichar: ‹Auquillücuna willacujcunata wañuchir, allita rurasha› nir yarparcaycanqui. Auquilluyquicuna wañuycachisha. Jamcuna mïchunta pichaycar, auquilluyquicunapa llupinparaj aywarcaycanqui: ‹Allipämi wañush› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","«Chayćhi Tayta Diosninchipis niran: ‹Shimïta willapäcunanpaj willacujnïcunatapis, caćhäcunatapis, achcajta caćhamushaj. Paycunata waquinta wañuchinquipaj. Waquinta marcan-marcan jaticaćhar ushyanquipaj.› ");
INSERT INTO qxhNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Willacujninta wañuchir, cay pacha camashanpita-pacha wañuchicushantapis aparicunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aparicunquipaj Abelta wañuchishanpita-pacha Zacaríasta wañuchishancaman. Payta Tayta Diosninchipa wasi puncunćhu, tullpa wajtallanćhu wañuchiran. Paycunata wañuchishanpita jamcunatana Tayta Diosninchi ñacachishunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Moiséspa shiminta yaćhajcuna, llaquicärinquiman. Juyupa ñacanquipaj. Yaćhaj carsi, Tayta Diosninchipa shiminta mana manchapacunquichu. Runa-masiquitapis mana yaćhachinquichu. Manchäga Tayta Diosninchipa shungun munashannuy cawayta munarcaycaptin, mićharcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Rimayta ushyarcur wasipita llucshir, Jesús aywacuran. Chay junajpita-pacha Moiséspa shiminta yaćhajcunawan fariseucuna ullgucarcäriran. Achäquita ashipällar, jucta-jucta Jesústa tapupaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Achäquita ashiparan: «Llutanta rimaptin, wañuycachishun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Runacunam ichanga yupaysi mana atipaypaj jutucaran Jesúspa shiminta wiyananpaj. Quiquin-puraraj tacanacuranpis. Chaymi Fariseucunapa shiminta libadürawan tincuchir, purïshijnincunallata Jesús niran: «Fariseucunapa libadüranta ama ćhasquipanquichu. Paycuna ishcay cära runa. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Runacuna shungullanćhu pacarächishanpis mayacanga. Imata yarpashanpis unayllata musyacanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chaymi shunguyqui pacarächishanpis llapanpa rinrinman ćhayanga. Pacayllapa rurashayquitapis llapan musyanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Wawacuna, chiqui runacuna wañuchishunayquita ama manchacunquichu. Wañuchishushpayquisi almayquita mana wañuchingachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tayta Diosninchitam ichanga manchapacärinquiman. Payga munayniyuj wañuyman jitarpushunayquipäpis, almayquita chacaj pachaman jaycunanpäpis. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Manchapacuptiqui, Tayta Diosninchi mana jungashunquipächu. Acapalla pichuysacuna mana ćhaninchu. Chaypis Tayta Diosninchi llapan pichuysata rican. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Acapalla pichuysata ricaycar, ¿jungashunquimanchuraj? Mana. Tayta Diosninchipa maquinćhu cawaycanqui. Payga mana imaysi jungashunquipächu. Ajchayquitapis yuparaycächin. Chaymi imatapis ama manchacuychu. Jamcunaman pichuysacunapis mana tincunchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Sumaj wiyacunquiman. Tayta Diosninchi caćhamasha. Chaymi runacunapa ñaupanćhu: ‹Jesúspa shiminta ćhasquicushcä› nir willacuptiqui, Tayta Diosninchipa anjilnincunapa ñaupanćhu nuwapis willacushaj: ‹Rasunpa maquïćhu purin› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Runata manchacur wasguimaptiquim ichanga, nuwapis Tayta Diosninchipa anjilnincunapa ñaupanćhu wasguishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Tayta Diosninchipa caćhan caycaptïsi ashllimaptiquisi, Tayta Diosninchi juchayquita junganga. Espíritu Santuta ashllir ushyaptiquim ichanga, mana jungangachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Wawacuna, watacurcur shuntacäna wasiman apashuptiqui, Israel mayur cüracunaman apashuptiqui, mayur runacunaman apashuptiqui, ama llutäpacunquichu: ‹¿Imataraj rimashaj? ¿Imanayparaj chapacushaj?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Paycuna rimachishuptiqui, Espíritu Santu shimiquiman ćhurashallanta rimanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Juc runa llapanpa ćhaupinpita Jesústa mañacuran: «Tayta, wauguillä papänï jaguishan ćhacrata charicurcusha. Raquipamächun, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mañacuptin, Jesús niran: «Wauguiquiwan jićhunacushayquita ricanä mana camacanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jinarcur llapan runata niran: «Imapäpis mallaj ama canquimanchu. Alli cawananchipaj mana rïcuyänanchirächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jinarcur juc willapata willapar, Jesús niran: «Puchuy-puchuy jananćhu cawaj runapash ćhacran achca caran. Murupacushanpis may-maytash wayuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Micuyninta may-mayta shuntarcur, mayman ćhuraytapis manash camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chayshi sumaj yarpaćhacuran: ‹Tacshalla wasïcunata jućhurachishaj. Jinarcur llapanta jutunäpaj jatun-caray wasicunata rurachishaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jutucushäga achca watapaj aypämanga. Micuy mana pishïmangapächu. Upunäpaj canga. Cushishallana juyäshaj› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tayta Diosninchishi ichanga niran: ‹Upa rinri canqui. Canan chacay wañuy ćhayapushunqui. Jutucushayquitapis jucmi micunga.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Willapariycur, Jesús niran: «Chay-niraj mallajcuna Tayta Diosninchita jungaycun. Tayta Diosninchita jungajcuna imata rurashantapis mana musyanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaypita purïshijnincunallata Jesús niran: «Wiyaycallämay. Ama llaquicunquichu: ‹¿Imawanraj cawashaj? ¿Imataraj micushaj? ¿Imataraj ushtucushaj?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cawaycar paćhayquipaj pishiptinsi, janayquipaj pishiptinsi, ama llaquicunquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mä, pichuysacunata ricacushun. Paycuna manash murupacunchu. Manash pallapacunchu. Murutapis manash ćhuracunchu. Imatapis mana ruraycaptinsi, Tayta Diosninchi micunanta camapan. Pichuysacunata camapaycar, ¿pishïchishunquimanchuraj? Mana. Manchäga tarichishunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","«May-jina llaquicurpis wañuy ćhayamuptin, mana jishpinquipächu: ‹Cawapärishäraj› nirsi. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chaynuy caycaptin, ¿imapäraj llaquicunqui: ‹¿Imawanraj cawashaj? ¿Imataraj micushaj? ¿Imataraj ushtucushaj?› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Waytacunatapis mä, ricacushun. Waytacuna mana arucuycarshi, mana puchcacuycarshi, cuyayllapaj waytaran. Wayta cuyayllapaj cashanman unay mandaj Salomónpis mana tincuranchu achic-achicyaycaj müdanash caycarsi. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Waytacuna juc-ishcay junajllapaj. Juc junaj cuyayllapaj waytaran. Warannin capllupäna chaquicäcun. Nircur tullpallaćhu ushyacäcun. Chaypis Tayta Diosninchi cuyayllapaj waytachin. Chaynuy caycaptin, ¿jamcunata Tayta Diosninchi pishïchishunquimanchuraj? Mana. Chaymi sumaj yupachicärinquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Ama llaquicunquimanchu: ‹¿Imataraj micushaj? ¿Imataraj upushaj?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tayta Diosninchiman mana yupachicujcunalla may marcaćhu juyarpis, chaycunapaj llaquicun. Jamcunam ichanga Tayta Diosninchiman yupachicunqui. Payga imalla pishïshushayquitapis mayna musyaycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chaymi maquillanćhu cawanquiman. Shungun munashallanta rurar cawanquiman. Maquinćhu purichishushpayqui pishïshushayquitapis tarichishunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Wawacuna, ama manchacuychu, ari. Yupashalla captiquisi, alli ricashushpayqui Tayta Diosninchi acracushcashunqui maquinćhu purinayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chaymi imayquicunatapis ranticuycur, pishipacujcunata yanapay. Shungun munashallanta ruraptiqui, Tayta Diosninchipis alli cawayta tarichishunquipaj. Tarichishuptiquiga, pipis mana jićhushunquipächu. Suwapis mana suwapäshunquipächu. Puyupis mana ushyapäshunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sumaj tantiyacunquiman. Runaga shungun munashallanta imatapis yarparäcun. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Wawacuna, mincay-jina achquiqui ratachipacushalla, ricaj-ricajlla shuyarämanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","38","Sumaj tantiyacunquiman. ‹Juc runash warmi ashiyman aywar, mana yarpashpita wasinman cutin. Pullan-pagaspis, waränanpis cutinmanshi. Imay üra cutiptinpis, alli mincayga ricaj-ricajllash shuyan. Puncuta tacariptin, jucllash quićhapun. Ricchaycar shuyaptinshi, wasiyujpis sumaj cushicun. Chayshi juclla alli müdananta rucacurir, mincaynintaraj jaran: «Ricchaycar shuyämar, allita rurashcanqui» nir.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Juctapis Jesús niran: «Wasinman suwa yaycunanta musyar, pipis manash puñucunmanchu. Manchäga suwa imancunatapis apananpita ricchaycarshi waran. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jamcunapis ricchaycaj-jina camaricushalla shuyarcaycämanquiman. Tayta Diosninchipa caćhan cashpä mana yarpashpita cutimushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chaura Pedro tapucuran: «Tayta, ¿nuwacunallatachu tantiyaycächimanqui? ¿Llapan runatachu willapaycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesúsna niran: «Mä, tantiyacunquiman. ¿Mayganiquiraj alli mincayman, tantiyacuj mincayman tincunquiman? Mincay alli captin, tantiyacuj captin, capural cananpäshi wasiyuj ćhuranga. Capuralga mincay-masincunata sumajshi rican. Jaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Capuralnin shiminta ćharcuptin wasiyuj ćhayar, allipash rican. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sumaj tantiyacunquiman. Allita rurashanpita capuralpa maquinman llapanta ćhuranga. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","«Juyu capuralshi ichanga shungullanćhu yarpaćhacunman: ‹Wasiyuj mana cutimungarächu› nir. Chayshi mincay-masincunata warmitapis, ullgutapis magar ushyan. Micur, upyallar juyäcun. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chaypis wasiyuj runa mana yarpashpita cutiramunga. Llutanta rurashanpitash juyu mincayninta mana cuyapaypa wascar ushyanga. Jarguringa: ‹Juyu-masiquicunawan juyämuy› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Wasiyujpa shiminta wiyaycarsi mana camaricuptin, llutanta ruraptin, chigaypash ñacachinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mana musyayninwan llutanta ruraptinshi ichanga, yangallaraj ñacachinman. Wawacuna, sumaj tantiyacunquiman. Llapan runata Tayta Diosninchi mincacun. Chaypis jamcunata capuralta-jina ćhurashcashunqui. Chaymi alli mincay-jina llapantapis allillata ruranquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Cay pachaman ninawan ushyacächij-yupay shamushcä. Ichanga mayna ninapis ratariycanman. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Chaypis quiquïraj juyupa ñacashaj. Ñacayman ćhayayta musyar, juyupa llaquicü. Juclla ushyacächun. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Shunguyquićhu ama yarpanquichu: ‹Cay pachaman Jesús shamusha alli cawayta tarichimänanchipaj› nir. Runacuna mana alli cawayllaćhüchu cawanga. Manchäga ćhasquicamashayqui-janan tincupänacuyćhu cawanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Juc wasićhu quiquin-puralla tincupänacunga. Chiquinacunga. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Papäninpis ullgu wamranta chiquinga. Wamranpis papäninta chiquinga. Mamanpis warmi wamranta chiquinga. Warmi wamranpis mamanta chiquinga. Suydanpis llumchuyninta chiquinga. Llumchuyninpis suydanta chiquinga. Ćhasquicamashan-janan mana ćhasquicujcuna chiquinga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chaypita llapan runata Jesús piñaparan: «Yana pucutayta ricar: ‹Tamyanga› ninqui. Änir, tamyan. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Urapa wayrämuptin: ‹Usyanga› ninqui. Änir, usyan. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Janan shungu runacuna, tamyanantapis, usyanantapis tantiyanqui. Ricay ñawiquićhu Tayta Diosninchi camacächiyninpa ima-imata rurashätapis, ¿imanirtaj tantiyayta mana atipanquichu? ");
INSERT INTO qxhNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Chaynuy caycaptin, ¿imanirtaj Tayta Diosninchipa shungun imata munashantapis mana tantiyacunquichu? ");
INSERT INTO qxhNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tincuchiypa tantiyachishayqui. Pipis dimandashuptiqui, jatunman mana ćhayallar, juclla ushyacächinquiman. Manchäga juiswan charichishunquipaj. Juisga wardiyacunawan carsilman apachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Carsilpita llap-llapanta pägarraj llucshimunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay wichallan waquin runa Jesústa willaran: «Tayta, ¿mandaj Pilato waquin Galilea runacunata wañuchishanta musyashcanquichu? Cuyachicuynincunata jaraptinshi, Tayta Diosninchipa wasinćhu wañuycachisha. Yawarninpis pishtashan uywapa yawarninwan tallucashash» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Willaptin, Jesús niran: « ‹Chay Galilea runacuna jatun jucha aparicushanpitaćhi wañusha› nir yarparcaycanqui, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chaypis ama chapacunquichu. Jucha aparicuypita mana wanacurga, paycuna-jina wañuyta tarinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chaynuypis: ‹Jerusalén marcaćhu Siloé türi jućhuptin, ćhunca pusajwan (18) runacuna wañusha jatun jucha aparicushanpitaćhi› nir yarparcaycanqui, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chaypis ama chapacunquichu. Jucha aparicuypita mana wanacurga, paycuna-jina wañuyta tarinquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tincuchiypa willapar, Jesús niran: «Juc runapa ćhacranćhüshi mana wayuj jïgus yüra caran. Wayuyninta ashirshi, jucnayllatasi mana tariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chayshi mincayninta niran: ‹Quimsa watana mana wayunchu. Ćhacrallata wayaycan. Mana wayuycaptin, juclla muturiy.› ");
INSERT INTO qxhNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mincayninshi ichanga niran: ‹Tayta, juclla ama mutushunrächu. Juc watacamanraj shuyaycushun. Ujtipärir, sapincunaman chullpata jaycapäshaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chullpata jaycupaptï, wayunmanpishćhi. Mana wayuptinmi ichanga, muturishunpaj.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Diyawarda junaj juc shuntacäna wasićhu Tayta Diosninchipa shiminta Jesús willapäcuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Supay curcuyächishan warmipis caycaran. Wäcacashalla puriran. Ćhunca pusajwan (18) watana ñacaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Warmita ricar jayarcur, Jesús niran: «Mamacha, jishya caćharishcashunquinam.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chaynuy nir maquinwan yataycuran. Warmina dirïchacäcur, Tayta Diosninchita alliman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Diyawardaćhu curcu warmita allchacächiptin, shuntacäna wasipa mayur runa ullgucäcuran: «Sujta junaj arunchi. Alli diyaćhu shamunquiman allchacächishunayquipaj. Diyawardaćhu ama shamunquimanchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesúsna niran: «Janan shungu runa, ¿imanirtaj alli-tucunqui? Quiquiquicunapis diyawardaćhu büruyquitawan türuyquita pascariycur, yacuta upuchinqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uywata caćharishayqui-jina cay warmitapis caćharishcä. Auquillunchi Abrahampa willcan captinsi, yawar-masinchi captinsi, ćhunca pusajwan (18) watana mayur supay ñacaycächisha. Ñacaycächiptin, ¿manachu allchacächishuwan diyawarda captinsi?» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesúspa shiminta wiyar, chiqui runacuna pingayman ćhayaran. Waquin runacunam ichanga Jesús allita rurashanpita jatunpa cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tincuchiypa willapäcur, Jesús niran: «¿Imawanraj Tayta Diosninchipa maquinćhu cawajcunata tincuchishuwan? ");
INSERT INTO qxhNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Paypa maquinćhu cawajcuna ñäpus muruwan tincun. Juc runash wirtanman ñäpusta murusha. Acapalla muru captinsi, yüranshi atayäcurcusha. Callapancunaćhüpis pichuysacuna jishucärisha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yapaypis tincuchiypa willapäcur, Jesús niran: «¿Imawanraj Tayta Diosninchipa maquinćhu cawajcunata tincuchishuwan? ");
INSERT INTO qxhNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Paypa maquinćhu cawajcuna libadürawan tincun. Juc warmish ichiclla libadürawan ishcay arüba arinata chapusha. Ichiclla carpis, llapan arinatash jacachisha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén marcapa aywar, Jesús marcan-marcan puriran Tayta Diosninchipa shiminta willapäcuraycur. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Willapäcuptin, juc runa tapuran: «Tayta, ¿rasunpachu wallcajlla Tayta Diosninchipa maquinćhu cawanga?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesúsna niran: «Quićhqui puncupa callpacuycur yaycushayqui-jina callpacunquiman Tayta Diosninchipa maquinćhu cawanayquipaj. Juc junajman ama jitapanquichu. Achcaj runa maquinćhu cawayta munangapaj. Ichanga mana llapanchu camäpacunga. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sumaj tantiyanquiman. Wasiyuj puncunta wićhgacurcuptin, pipis mana yaycunnachu. Chaymi juclla Tayta Diosninchipa shiminta wiyacunquiman. Manchäga llaquicuywan ninquipaj: ‹Wasillayqui, Tayta. Puncuyquita quićhapaycallämay› nir. Jayacuptiquisi: ‹Mana ricsillajchu. ¿Maypitash cacullanquipis?› nishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chaura ninquipaj: ‹Tayta, ¿imanirtaj mana ricsimanquichu? ¿Micur, upur puriycaptinchisi, mana ricsimanquichu? Marcäcunaćhüpis Tayta Diosninchipa shiminta willacushayquita wiyashcä.› ");
INSERT INTO qxhNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chaypis nishunquipaj: ‹Mana ricsillajchu. ¿Maypitash cacullanquipis? Juchaćhu arujcuna, ricaytapis mana munallajchu. Washata ayway.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Puncupita jargushuptiqui, carullapita auquillunchi Abrahamta, Isaacta, Jacobta, Tayta Diosninchipa unay willacujnincunatapis ricanquipaj. Paycunata Tayta Diosninchipa ñaupanćhu ricar, atayparaj waganquipaj. Juyupa ñacar quiruyquitapis ućhunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tayta Diosninchipa maquinćhu cawajcunam ichanga chay-tucuypita jutucanga. Llapanmi Tayta Diosninchipa ñaupallanćhu micupacungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chay junaj alli-tucujcunata Tayta Diosninchi pampaman ćhuranga. Wiyacujcunatam ichanga alliman ćhuranga runa-masincuna pampaman ćhurash captinsi.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Waquin Fariseucuna ćhayarcur, Jesústa niran: «Tayta, jucläman aywacuy. Mandaj Herodesshi wañuchishunayquipaj yarpaycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús niran: «Chay atuj-jina Herodesta willay: ‹Ishcay-quimsa junajllana supaycunata jargushaj. Jishyaćhucunatapis allchacächishaj. Warantin llapanta ćharcushaj.› ");
INSERT INTO qxhNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ima captinpis, Jerusalén marcamanraj ćhayashaj. Jerusalén marcallaćhu Tayta Diosninchipa willacujnincunata wañuchin.» ");
INSERT INTO qxhNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén marca runacunata llaquipar, Jesús niran: «Jerusalénllau Jerusalén, ¿imanirtaj Tayta Diosninchipa willacujnincunata wañuchinqui? ¿Imanirtaj caćhancunata wañuchinqui? Chipsancunata maman ujllananpaj shuntashan-jina shuntayta munashcaj. Munaptïsi, wasguipämashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chay-niraj cashayquipita marcayquipis ragäman ticranga. Nuwatapis mana ricamanquipänachu. ‹Tayta Diosninchi caćhamushan runa alli ricash caycullächun› nir ćhasquimashpayquim ichanga imayllapis ricamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Diyawarda junaj mayur fariseu runa Jesústa jayachiran micupacunanpaj. Waquin fariseu-masincuna achäquita ashipällar ricapaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ricapaycaptin, Jesúspa ñaupanman maquin-ćhaquin jacash runa ićhicuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jacash runata ricar, fariseucunatawan Moiséspa shiminta yaćhajcunata Jesús tapuran: «Diyawardaćhu, ¿jishyaćhuta allchacächishuwanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Paycunam ichanga upällacuycuran. Mana rimacuptin, jacash runata Jesús allchacächiran. Jinarcur wasinman caćharcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Fariseucunatana niran: «Diyawarda captin, wamrayqui, türuyqui yacu püsuman shicwaptin, ¿manachu utgaylla jurgurinquiman?» ");
INSERT INTO qxhNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tapuptinsi, upällalla cacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Micupacuj ćhayaj fariseucuna ñaupa-ñaupallaćhu jamayta ashiycaran. Chaymi tantiyachicur Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Warmi ashiyman jayachishuptiqui, ñaupa-ñaupaćhu jamayta ama ashinquichu. Ñaupaćhu jamaraycaptiquish mayur runa ćhayamuptin, ");
INSERT INTO qxhNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","wasiyuj nishunquiman: ‹Jipaman witicuy mayur runata jamachinäpaj.› Chayrämi pingay-tucush jipaman witicunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","«Chaymi pipis jayachishuptiqui, jawa-jawallaćhu jamacunquiman. Jawaćhu caycaptiqui, wasiyuj: ‹Ruriman yaycushun› nir ñaupaman jamachishuptiquim ichanga, llapan alli ricashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tayta Diosninchi alli-tucujcunata pingayman ćhuran. Tantiyacujcunatam ichanga alliman ćhuran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Micupacunanpaj jayachij runatana Jesús niran: «Micuyta jaracur, ricsinacushayquicunallata, yawar-masiquicunallata, puchuy-puchuy jananćhu cawajcunallata ama jayachinquichu. Micurcachiptiquipis quiquiquitaraj jayarcachir, ayniquita cutichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Micuyta jaracur, wacchacunata, cumllucunata, wijrucunata, japracunata jayachinquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paycunata micurcachiptiqui, quiquin Tayta Diosninchi ayniquita cutichishunquipaj. Cutichishunquipaj shiminta wiyacujcunata cawarachishan junaj. Chaura jatunpa cushicunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesúspa shiminta wiyar, juc jurpa niran: «Tayta Diosninchipa maquinćhu cawar quiquinwan iwal micur, imaraj cushicushun, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chaynuy niptin, Jesús niran: «Juc runash micuyta camaricush caran. Jurpancunatapis achcajtash jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Micuy ćhayaptin, sirbintincunata caćharan: ‹Jayachishä runacuna micuj shamuchun› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jurpancunash ichanga jayachiptinsi, mana aywaranchu. Juc runash niran: ‹Rantishä ćhacrata ricamushaj. Mana atipashächu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Juc-cajnash niran: ‹Pichga yunta türuta rantirü. Sumajraj ricashaj. Mana atipashächu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jucninnash niran: ‹Chayraj majachacashcä. Mana atipashächu.› Llapan jayachishancuna aywayta mana munashpan chapacuran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Sirbinticunash wasiyujta llapanta willaycuran. Wasiyuj ullgur, niran: ‹Canan micupacärinanchipaj tarishayqui runata juclla jayamuy. Wacchacunatapis, macllucunatapis, wijrucunatapis, japracunatapis jayamuy.› ");
INSERT INTO qxhNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sirbinticuna nishannuylla ruraran. Jinarcur wasiyujta niran: ‹Tayta, nimashayquicunata jayamushcä. Chaypis wasiqui jäcuycanraj.› ");
INSERT INTO qxhNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chaura wasiyuj niran: ‹Ćhaquiqui ćhayashanpa ayway. Tincushayqui runacunata imanuypapis pushamuy wasïćhu juntay-juntay micupacunanchipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jayachishä wasguijcunam ichanga jaracushäta imaysi mana mallingapächu.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesús aywaptin, achcaj runa aywäshiran. Chaymi ićhiycur Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Pipis purïshimayta munar, llapan shungunwan purïshimächun. Mamanpis, taytanpis, warminpis, wamrancunapis, yawar-masincunapis jipaman ama cutichinmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Shimïta wiyacujcuna imanuy ñacarsi, rusćhu wañuyman ćhayarsi, ricay ñawïćhu alli cawanman. Manchäga purïshimayta mana camäpacungachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Sumaj tantiyacushun. Wasi rurajcunapis wasinta mana jallaycachillarshi, aypäpacunanta, mana aypäpacunantapis sumaj yarpaćhacun. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jallarishan wasita mana ushyaptinga, runacuna pampamanshi ćhuran: ");
INSERT INTO qxhNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹Mana aypäpacuycar, chican-caray wasita jallarachisha. Upa runa› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Yapaypis yarpaćhacushun. Ćhunca waranga (10,000) murucucuna ishcay ćhunca waranga (20,000) murucucunata maganacur, manash ićhipunmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ićhipuyta mana camäpacurshi, mayur mandaj caćhacunman: ‹Ama maganacushunchu. Allilla cawashun› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chaymi yaparir-yaparir yarpaćhacunquiman. Purïshimayta munar llapanta jaguiriycur, nuwallata purïshimanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Caćhipis sumaj alli. Ichanga puchguynin illariptin, ¿puchguyninman yapay cutichinquimanchuraj? Mana. ");
INSERT INTO qxhNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Allpatapis mana jamyayächinnachu. Chullpamanpis mana talluchinnachu. Chaymi wicaparin. Rinriyuj carga, shimïta sumaj wiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesús rimaycaptin, jillayta shuntaj chiqui runacunapis, waquin juchaćhu arujcunapis shiminta wiyananpaj jutucaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chaymi fariseucunawan Moiséspa shiminta yaćhajcuna Jesústa jamurparan: «¿Imanirtaj juchaćhu arujcunawan Jesús talluran? Iwal micunpis» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tincuchiypa willapar Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Juc runapash paćhac (100) uyshan caran. Jucta ujraycur, ¿manachu waquinta juc pachaman jutuycur ujrashan-cajta ashin tarishancaman? ");
INSERT INTO qxhNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tarir, aparicurcurshi cushish wasinman apacun. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Llapan yawar-masincunatawan bisïnuncunata jayachin: ‹Tünashun. Ujracash uyshäta tarirü› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Juchaćhu aruj runa wanacuptinpis, taricash uyshapaj cushicushan-jina Tayta Diosninchipis, anjilcunapis cushicun. Isgun ćhunca isgunwan (99) alli runa captinsi juc juchaćhu aruj runa wanacuptin, janaj pachaćhu llapan sumaj cushicärin.» ");
INSERT INTO qxhNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yapaypis tincuchiypa willapar Jesús niran: «Juc warmish ćhunca jillayta chararan. Jucta ujraycur achquita ratachicuycurshi, pichananpawan tarishancaman ashin. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tariycur, llapan yawar-masincunata, bisïnuncunata jayachin: ‹Tünashun. Ujracash jillaynïta tarirü› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Juchaćhu aruj runa wanacuptin, taricash jillaypaj cushicushan-jina Tayta Diosninchipa anjilnincunapis cushicun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Juctapis tincuchiypa willapar Jesús niran: «Juc runapash ishcay wamran caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Shullca wamranshi taytanta niran: ‹Papä, ćhacrayquita raćhishun. Dirïchüta raquipaycamay.› Chaura papänin ishcantash ricachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Shullca wamranga manasi aycallatash imancunatapis ranticuycuran. Jinarcur caru marcapash aywacuran. Carućhu shungun munashallanta rurarshi, jillaynintapis llapanta ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jillayninta ushyashallantash mućhuypis jallacuycuran. Chaura micunanpaj imapis manash caranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Imansi mana captin arupacuyta ashir, juc runaman ćhayaran. Chay runa cuchillatash michichiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mućhuy captin, juyupash yargaran. Cuchipa micuynintapis munaparan. Ichanga pipis manash jararanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Chayräshi yarpaćhacuran: ‹Papänïpa piyunnincuna micuy jananćhu cawan. Nuwam ichanga yargaypita wañuycä. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chaymi papänïman cuticushaj. Ćhayar, nishaj: «Papä, juchata aparicushcä. Shimiquitapis, Tayta Diosninchipa shimintapis mana wiyacushcächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cananga piyunllayquipis cacushaj. Jucha-sapa caycaptï, ama: ‹Wawä canqui› nimanquimanchu» nirshi.› ");
INSERT INTO qxhNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yarpaćhacuriycur, änir papäninman cuticuran. Wamranta caruta shaycamujta ricar, papänin jucllash tariparan. Llaquipashan macallacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mushćhincu wamrannash niran: ‹Papä, juchata aparicushcä. Shimiquitapis, Tayta Diosninchipa shimintapis mana wiyacushcächu. Jucha-sapa caycaptï, ama: «Wawä canqui» nimaychu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Papäninnash piyunnincunata niran: ‹Wawä ushtucunanpaj mushuj müdanata, llanguita, surtïjata juclla apamuy. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Micupacunanchipäpis manta türituta pishtay. Canan tünashun. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","«Wañucush canga» niycaptïpis, wamrä cutircamusha. Illarish carpis, taricasha.› Chayshi mushćhincu wamra cutiyninta tüna jallacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Shullcan ćhayaptin, mayur wauguin ćhacraćhüshi aruycaran. Wasiman yaycuycashanćhüshi tünaycajta wiyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chaura papäninpa piyunnintash jayaran: ‹¿Wasićhu imataj caycan?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Piyunnash niran: ‹Shullcayqui taricasha. Alli ćhayamusha. Cushicushpan papäniqui manta türitutapis pishtachisha.› ");
INSERT INTO qxhNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Chaura mayur wauguin juyupa ullgurshi, wasiman ćhayaytapis mana munaranchu. Chaymi llucshircur, papänin jayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jayaptinsi mana munarshi, niran: ‹Papä, chay-chica wata maquiquićhu juyä. Shimiquitapis llapanta wiyacushcä. Chaypis mana juc capshillatapis jumashcanquichu tünata rurar micupacunäpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ñuñushniquipämi ichanga allinnin türitutaraj pishtaycachishcanqui. Payga runan-runan puricuj warmicunawanshi llapan jillayniquita ushyasha.› ");
INSERT INTO qxhNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Papäninnash niran: ‹Wawallau wawa, rasunpa maquïćhu juyaycanqui. Chaymi llapan imäcunapis maquiquićhu caycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Shullcayquim ichanga wañushpita-jina cutircamusha. Ujracashpita-jina taricasha. Chaymi shungü achicyacäcuptin, tünananchi camacan.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tincuchiypa willapar, purïshijnincunata Jesús niran: «Puchuy-puchuy jananćhu cawaj runash llapan imancunatapis capuralpa maquinman ćhuraran. Chaypitaräshi capuralnin suwapashanta mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chaura capuralninta jayarcurshi tapuran: ‹Suwapaycämashayquita runacuna willamasha. Mä, ima-imata charashallätapis willamay. Canancamalla arushcanqui› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Chaynuy niptinshi, shungullanćhu capuralnin yarpaćhacuran: ‹Jargumaptin, ¿imawanraj cawashaj? Ćhacra aruyta mana jüchu. Mañapacuytapis pingacü. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cananga ima ruraytapis musyäna. Yarpashäta ruraptï aruy mana captinsi, marca-masïcuna alli ricamanga› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Yarpaćhacuriycurshi, patrunninpa jaga-tucuj runacunata jayachiran. Juc ćhayaptin, tapuran: ‹¿Aycataj patrunnïpa jagan caycanqui?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jaga runanash niran: ‹Ishcay paćhac (200) läta wiram jagan caycä.› Capuralnash niran: ‹Cananga papilta rurashun pullallanta patrunnïta cutichinayquipaj. Paćhac (100) läta wirallatana cutichinqui.› ");
INSERT INTO qxhNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chaypita juc jagatash tapuran: ‹¿Aycataj patrunnïpa jagan caycanqui?› nir. Jucninnash niran: ‹Ishcay waranga (2,000) arüba rïgum jagan caycä.› Capuralnash niran: ‹Cananga papilta rurashun waquillanta patrunnïta cutichinayquipaj. Waranga pichga paćhac (1,500) arüba rïgullatana cutichinqui.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Chaura capuralnin ima-imata rurashantapis mayar, patrunninshi niran: ‹Capuralnïga llutanta ruraycarsi, yarpay-sapa. Sumaj cuyachicusha marca-masin alli ricananpaj.› » Tincuchiypa willapariycur, purïshijnincunata Jesús niran: «Juchaćhu arujcuna Tayta Diosninchita mana manchapacursi, quiquin-pura alli ricanacuyta yaćhan. Jamcunam ichanga alli ricanacuyta mana yaćhanquirächu: ‹Tayta Diosninchipa wawan caycanchi› nirsi. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sumaj tantiyacunquiman. Cay pachaćhu llapanwan alli ricanacunquiman. Jillayniqui captin, runa-masiquita yanapanquiman. Ushyapacaptiquisi, janaj pachaćhu imaycamanpis Tayta Diosninchipa ñaupanćhu cawanayquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Sumaj wiyacunquiman. Ichicllata suwacur, achcatapis runa suwacun. Ichicllatapis mana yatapacur, achcatapis mana yatapacunchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sumaj tantiyacunquiman. Runa-masiquipa jillayninta yatapacuptiqui, imancunata pampata ruraptiqui, Tayta Diosninchipis mana yupachicushunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jucpa imancunata yatapacuptiqui, pampata ruraptiqui, Tayta Diosninchipis irinsayquita mana jushunquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Juc mincaylla ishcaj patrunpa maquinćhu mana cawanmanchu. Ishcanwan shungun mana tincunmanchu. Ishcajpa maquinćhu cawar, juc-cajpita carupayllapa purir, juc-cajllaman jillicunga. Juc-cajta pampaman ćhurar, juc-cajta alli ñawinwan ricanga. Jamcunapis jillayllaman yarparar, Tayta Diosninchita jungaycärinquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseucuna jillay-raycullar imatapis ruran. Chaymi Jesúspa shiminta wiyar, ashllir ushyaran: «Yangalla rimacun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesúsna niran: «Runacunapa ricay ñawillanćhu jamcuna juchaynaj-tucunqui. ‹Alli runa› nishuptiquisi, Tayta Diosninchi musyapäshunqui. Yarpashayquita millanäcun. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Ushyachicuj Juan willapäcushan wichancaman runacuna Moiséspa shimintapis, unay willacujcunapa shimintapis wiyacuran. Cananmi ichanga Tayta Diosninchipa shiminta willacuycä. Maquinćhu cawachinäpaj caćhamasha. Waquin runa imanuypapis llapan shungunwan shimïta wiyacurcaycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","«Cay pachawan janaj pacha ushyacaptinsi, Moiséspa shimin mana ichicllapis jungacangapächu. Llapanta ćharcucänan. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Juc runa majanta jaguiriycur juc warmiwan majachacar, juchata aparicun. Raquicash warmiwan majachacarpis, jucpa warminta llallipaycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Juc willapata willapar, Jesús niran: «Juc runash puchuy-puchuy jananćhu cawar, achic-achicyaj müdanallata ushtucuj. Waran-waranshi tünaj. Sillullatash micuj. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Puchuy-puchuy jananćhu cawaj runapa wasin puncunćhünash pishipacuyćhu cawaj jiri ushyash Lázaro jitaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jirintasi allgucunash llajwar ushyaran. Yargaypita wañurshi, Lázaro yarpaćhacuran: ‹Puchuy-puchuy jananćhu cawaj runapa usupallantasi micurcüman› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Unayllata Lázaro wañucuranshi. Wañucuptin, anjilcunash janaj pachaman Abrahampa ñaupanman shuntacuran. Manasi aycällatash puchuy-puchuy jananćhu cawaj runapis wañucuran. Wañucuptin, pampaycuranshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","«Puchuy-puchuy jananćhu cawash runa chacaj pachaćhu ñacaycashanćhüshi Lázaruta ricaran Abrahamwan-ima janaj pachaćhu jamaraycämujta. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ricarshi, Abrahamta jayacuran: ‹Tayta Abraham, llaquipaycallämay. Lázaruta caćhamuy. Maquinta ushmarcachir, shamuchun jallüta ushmarcachinanpaj. Cay ninaćhu juyupa ñacaycä› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Abrahamnash niran: ‹Wawallau wawa, ¿pachaćhu cawashayquita yarpanquirächu? Pachaćhu puchuy-puchuy jananćhu cawashcanqui. Cananmi ichanga ñacaycanqui. Lázaruna pachaćhu ñacash carsi, canan allićhu caycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jananmanpis chimpayta mana camäpacüchu. Jatun rajra raquiraycämanchi. Chaymi wacman-cayman pipis mana chimpanmanchu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Chaura puchuy-puchuy jananćhu cawaj runash niran: ‹Tayta Abraham, jatunpa mañacuycushayqui. Papänïpa wasinman Lázaruta caćhaycullay. ");
INSERT INTO qxhNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Wauguïcuna pichgajraj cawaycan. Wauguïcuna juchata ama aparicuchunnachu. Mana piñacamuptin, ñacayman paycunapis ćhayamunga.› ");
INSERT INTO qxhNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamnash niran: ‹Wauguiquicuna Moiséspa shimintapis, Tayta Diosninchipa willacujnincunapa shimintapis musyan. ¿Imanirtaj mana wiyacunchu?› ");
INSERT INTO qxhNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Puchuy-puchuy jananćhu cawaj runanash niran: ‹Tayta Abraham, paycunapa shimillanta mana wiyacunmanchu. Wañushanpita cawarircamur piñapaptinmi ichanga, rasunpa wanacäringa.› ");
INSERT INTO qxhNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Abrahamnash niran: ‹Moiséspa shiminta, willacujcunapa shiminta mana wiyacur, wañushanpita cawarircamur piñapaptinsi, manam wiyacungapishchu.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Purïshijnincunata Jesús niran: «Imallapis canga runa juchaman ćhayananpaj. Chaypis juchaman janćhacujcunata chigaypa Tayta Diosninchi ñacachinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wamra-jina llapan shungunwan nuwaman yupachicujcunata juchaman janćhajcunaga wañuyman ćhayachun. Jatun-caray marayta cuncanman wallgaparcur, yacu ruri-ruricaman wicaparinman. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chaymi juchaman ama janćhanacunquichu. «Runa-masiqui juchata aparicuptin, piñacunqui. Piñacushayquita wiyacuptin, allina ricanacunqui. Juchanta ama yarparanquinachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Juc junajllaćhu janćhis cutipis juchata aparicuriycur: ‹Mana llutanta rurashänachu› nishuptiqui, imaypis junganquiman. Alli ñawiquiwan ricanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Caćhancuna Tayta Jesústa mañacuran: «Tayta, llapan shungüwan yupachicunajpaj yanapaycallämay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesúsna niran: «Yangallapis yupachicur, tagay jatun yürata ninquiman: ‹Caypita washaman witicuy.› Niptiqui änir, llupicäcur jatun yacu püsucamansi witicaramunman. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Piyuncuna yapyashanpita, michipacushanpita ćhayaptin, patrun manash ninchu: ‹Jamacuy. Micushun.› ");
INSERT INTO qxhNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Manchäga nin: ‹Canan yanucaraycamuy. Micucurcuptïraj, micunqui.› ");
INSERT INTO qxhNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nishanta llapanta ruraptinsi, manash ninchu: ‹Ima allish yanapämashcanqui.› ");
INSERT INTO qxhNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chay-jina jamcunapis Tayta Diosninchipa maquinćhu cawarcaycanqui. Shungun munashanta rurar, ninquiman: ‹Tayta Diosninchipa maquinćhu cawaycä. Nimashallanta imatapis rurashcä.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalén marcaman aywar, Galilea uranpa, Samaria uranpa Jesús yarpuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Juc marcaman ćhayaycaptin, ćhuncaj jaraćhu jishyawan jishyajcuna ricaripuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Carullapita jayacuran: «Tayta Jesús, llaquipaycallämay, ari. Allchacaycachillämay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesúsna niran: «Cüracunaman ayway. Allchacashayquita ricachiy.» Cüraman aywaycashallanćhüna jaraćhu jishyawan jishyajcuna änir allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jucnin allchacashanta tantiyacurir, cushish cuticullaran. Sumaj wiyächipaypa Tayta Diosninchita alliman ćhuraran: «Taytallau Tayta, ima allish llaquipämashcanqui» niycar. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesúspa ñaupanman ćhayar, jungurpacuycuran: «Tayta Jesús, ima allish allchacächimashcanqui» nir. Jesúsman cutij runaga Samaria runa caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesúsna juturajcunata tapuran: «¿Manachu ćhuncaj jaraćhu jishyawan jishyajcuna allchacasha? Waquin, ¿maytaj? ");
INSERT INTO qxhNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Cay jäpa runallachu Tayta Diosninchita alliman ćhuran? Waquinga Israel runa caycarsi, Tayta Diosninchita jungaycushaćhi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jungurparaj jäpa runata niran: «Jatariy. Yupachicamashayquipita allchacashcanqui. Aywacuyna.» ");
INSERT INTO qxhNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Waquin fariseucuna Jesústa tapuran: «¿Imaypitataj Tayta Diosninchipa maquinćhu cawashun?» nir. Jesúsna niran: «Maquinćhu cawashanchita musyananchipaj mana Tayta Diosninchitarächu ricananchi. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mana pipis ninmanchu: ‹Cayćhu runacunata maquinćhu puriycächin. Washaćhu maquinćhu puriycächin.› Mana ricarpis, waquinninchi Tayta Diosninchipa maquinćhu cawarcaycanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jinarcur purïshijnincunata Jesús niran: «Ñacay captin, maquïćhu cawapäriytasi munanquipaj. Washänajtapis munanquipaj. Chaypaj Tayta Diosninchi caćhamasha. Ichanga mana ricamanquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‹Tayta Diosninchipa caćhan cayćhu caycan› nishuptiquisi: ‹Washaćhu caycan› nishuptiquisi, ashij ama aywanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cutimuptï, illaguta llapan ricashan-jina llapan runa ricamanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Chaypis cananllaraj runacuna wasguimanga. Ñacachir ushyamanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Sumaj tantiyacunquiman. Tayta Diosninchi caćhamasha. Yapay caćhamänan wichan runacuna cawashanwan cawarcaycangapaj. Noé cawashan wichanpis runacuna chaynuy cawarcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lücu tamya mana jallarishancaman runacuna cawashanwan cawacurcaycaran. Jaucalla micucurcaycaran. Upucurcaycaran. Waquinpis majachacaycaran. Bütiman Noé jigacurcuptinmi ichanga, lücu tamya jallacuycuran. Yacu limbucurcuptin, llapan runa shugupacaypa wañuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot cawashan wichanpis runacuna cawashanwan cawarcaycaran. Cushish micucuran. Upucuran. Rantipacuran. Murupacuran. Wasintapis rurapacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma marcapita Lot llucshicuriptinmi ichanga, nina tamya jallacuycuran. Llapan runata ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tayta Diosninchi caćhamaptin, cutimushä junajpis runacuna cawashanwan cawarcaycangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Chay junaj wasi puncullaćhu caycarsi, ruriman ama yaycunmanchu. Imancunatapis ama jurgunmanchu. Ćhacrapitapis wasiman ama cutinmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotpa warmin imaman ćhayashanta jungarunquiman. Payga jipaman ticrärishanćhu caćhi rumiman ticracuriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pipis shungun munashallanta rurar, ushyacayman ćhayangapaj. Shimïta wiyacurmi ichanga runa ñacachiptinsi, wañuchiptinsi, imaycamanpis Tayta Diosninchipa maquinćhu cawangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Chay junaj juc cämallaćhu ishcaj puñuycaptin, juc-cajllata shuntacushaj. Jucnintam ichanga jaguiycushaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishcaj warmi agacurcaycaptinpis, juc-cajllata shuntacushaj. Jucnintam ichanga jaguiycushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chaura purïshijnincuna Jesústa tapucuran: «¿Maymantaj cutimuj aywanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesúsna niran: «Rimaypis purin. ‹Siucacunash micunanta ricar, maymanpis jutucan.› Cutimushätapis llapan runa mayanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Purïshijnincuna mana yamacällar Tayta Diosninchita mañacunanpaj willapar, tincuchiypa Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Juc marcaćhüshi juyu juis caran. Tayta Diosninchita manash manchapacujchu. Runa-masintapis manash llaquipajchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Biyüda warmipis dimandacurshi puriycaran. Waran-waranshi juisman aywaj: ‹Dimandüta juclla ushyacaycachipämay, ari› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Juisga manash wiyaj-tucuranchu. Chaypita unayllatash yarpaćhacuran: ‹Mana Tayta Diosninchipitachu cawä. Runa-masïpis mana imanämanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Chaypis cay warmita umäta mana nanächinanpaj mañacamashanta wiyashaj. Waran-waran mana yaycaycämunanpaj yanapaycushaj› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Willapariycur, Jesús niran: «Juyu juispita tantiyacunquiman. Juyu carsi, biyüda mañacushanta wiyashash. Washashash. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Chayrächuraj Tayta Diosninchi mana wiyashunquimanchu? Acracushan wawan caycaptiqui, ¿upa-tucungachuraj? Mana. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pagas-junajpis mana yamacällar mañacuptiqui, juclla washäshunqui. Chaypis janaj pachapita washänäpaj Tayta Diosninchi caćhamaptin, ¿cay pachaćhu tiyaj runacuna Tayta Diosninchipa maquinćhüchuraj cawaycangapaj?» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Alli-tucuj runacuna juchaynaj-tucur waquinta pampaman ćhuraptin, wiyächipaypa Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ishcaj runash Tayta Diosninchipa wasinman aywaran. Juc-caj caran fariseu, juc-cajna jillayta shuntaj chiqui runa. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseu runaga ićhicuycurräshi Tayta Diosninchita mañacuran: ‹Taytallau Tayta, jatunpa cushicullä. Waquin runa-jinachu mana juchata aparicü. Mana suwacüchu. Llutanta mana rurächu. Warmïtapis mana jananpachïchu. Tagay chiqui runa-jinachu mana caycä. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Manchäga allillata rurä. Simänaćhu ishcay cuti ayunä. Gänashäman-tupu jampa-cajta raquir, wasiquiman ćhurä› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Jillayta shuntaj runash ichanga juyupa llaquicuran. Pingacuywan uysucuycur mañacuran: ‹Taytallau Tayta, llaquipaycallämay, ari. Pasaypa jucha-sapa runa cä› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Willapariycur, Jesús niran: «Tayta Diosninchi chiqui runata llaquiparan. Juchantapis jungaycuran; fariseu runatam ichanga mana. Alli-tucujcunata Tayta Diosninchi pampaman ćhuran. Mana alli-tucujcunatam ichanga alliman ćhuran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Waquin runacuna Jesúsman ćhayaran: «Yataycur mallwa wamräcunapaj Tayta Diosninchita mañacapamay, ari» nir. Wamracunata ćhayachijta ricarmi ichanga, purïshijnincuna piñacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chaura Jesús niran: «Ama mićhaychu. Wamracunata apamuchun. Shacamuchun. Wamra alli shungu cawashan-jina alli shungu runacunallapis Tayta Diosninchiman yupachicushpan maquinćhu cawan. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sumaj tantiyacunquiman. Tayta Diosninchipa maquinćhu cawanayquipaj wamracuna-jina wiyacunquiman. Manchäga mana camäpacunquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mayur Israel runa Jesústa tapuran: «Alli Tayta, ¿imatataj ruräman Tayta Diosninchipa ñaupanćhu imaycamanpis cawanäpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesúsna niran: «¿Imanirtaj: ‹Alli› nimanqui? Tayta Diosnillanchi alli. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Moisés isquirbishanta musyanqui. Shiminćhu nin: ‹Majayquita ama jananpachinquichu. Ama wañuchicunquichu. Ama suwacunquichu. Runa-masiquita ama tumpanquichu. Mamayqui-taytayquitapis alli ricanquiman.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chaura mayur runa niran: «Wamra cashäpita-pacha chaycunata llapallanta ćharcushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesúsna niran: «Jucrämi pishïshunqui. Llapan imayquicunatapis ranticuycur, wacchacunata aypuriy. Jinarcur purïshimay. Chayraj imaycamanpis Tayta Diosninchipa maquinćhu cawanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chaynuy niptin, shungun ishquicäcuran. Puchuy-puchuy jananćhu cawashpan juyupa llaquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Llaquicujta ricar, Jesús niran: «Puchuy-puchuy jananćhu cawajcuna Tayta Diosninchipa maquinćhu cawananpaj sumaj sasa. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","‹Camïllu› nishan jatun-caray uywa aujapa ñawinpa ushtucuyta mana jushan-jina puchuy-puchuy jananćhu cawajcunapis Tayta Diosninchipa maquinćhu cawayta mana junchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chaura wiyajcuna parlanacäriran: «Chaynuy caycaptin, ¿piraj Tayta Diosninchipa ñaupanman ćhayanga?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesúsna niran: «Runacuna ushyacajlla. Chaymi alli cawarpis, sasächicun. Tayta Diosninchipämi ichanga imapis mana sasachu. Payga munayniyuj pitapis ñaupanman ćhayachinanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedruna niran: «Tayta, nuwacuna llapan imäcunatapis jaguiycur, purïshiycaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesúsna niran: «Sumaj tantiyacunquiman. Tayta Diosninchipa maquinćhu cawayta munaywan wasinta, majanta, mayurnincunata, shullcancunata, maman-taytanta, wamranta jaguijcunata ");
INSERT INTO qxhNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ima-imapis mana pishingachu. Tayta Diosninchipa ñaupanman ćhayarpis, mana ushyacaj cawaytapis ćhasquingapaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chaypita ćhunca ishcaywan purïshijnincunata shuntarcur, Jesús niran: «Jerusalén marcaman aywaycanchi. Unay willacujcuna nuwapaj rimashan llapan ćharcucanga. Runacunata washänäpaj Tayta Diosninchi caćhamasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chaypis Jerusalén marcaćhu Israel-masïcuna Roma runacunapa maquinman ćhayachimanga. Paycuna pampaman ćhuramanga. Ashllir ushyamanga. Tuwapamanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sumaj wascamanga. Wañuchimanga. Wañuchimaptinsi, quimsa junajta cawarimushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Purïshijnincunam ichanga Jesús rimashanta mana tantiyaranchu. Umanman mana yaycuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jerusalén marcaman aywaycashanćhu Jericó marcaman Jesús ćhayaran. Marca yaycunanćhu japra runa mañapacuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Achcaj runa ćhayashanta mayar, japra runa tapucuran: «¿Imataj caycan?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Runacuna willaran: «Nazaret marca Jesús shaycämun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chaura japra runa jayacuran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ñaupaj runacuna ullgüparan: «Upälla» nir. Chaypis japra runa yapay callpaycur-callpaycur jayacuran: «Unay mandaj Davidpa willcan Jesús, llaquipaycallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ićhiycur, japrata Jesús jayachiran. Ćhayachiptin, tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«¿Imallaćhütaj yanapäshayqui?» nir. Japrana niran: «Tayta, ñawï ricananta munä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chaynuy niptin, Jesús niran: «Ricay. Yupachicamashayquipita allchacashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Niptin, änir, ñawin quićhacäcuran. Ñawin ricaptin, Jesústa purïshiran: «Ima allish Tayta Diosninchi allchacächimasha» nir. Waquin runacunapis japra runa allchacashanta ricar, Tayta Diosninchita alliman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericó marcaman Jesús ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chay marcaćhu Zaqueo jutiyuj runa tiyaran. Payga jillayta shuntaj runacunapa mandajnin car, puchuy-puchuy jananćhu cawaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesús aywaycashanta mayar, Zaqueo sumaj ricayta munaran. Chaypis chay-chicaj runapa ćhaupinćhu Jesús aywaycaran. Zaqueo tacshalla cashpan ricayta mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mana camäpacur ñauparcur, juc yüraman jigacurcuran. Jesús yüra ćhaquinpa aywanan caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yüra ćhaquinpa aywaycashanćhu ćhuquircur Jesús niran: «Zaqueo, yarpamuy. Wasiquićhu pachächimänayqui camacan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueuna juclla yarpuran. Cushi-cushilla wasinman pusharan. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chaura waquin runacuna Jesústa jamurparan: «Juchaćhu aruj runapa wasinćhüćhi pachacunga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Micupacurir, llapanpa ñaupanćhu Zaqueo niran: «Tayta Jesús, wacchacunata imäcunatapis pullanta raquipushaj. Pipa imallantapis suwapash carga, ćhuscu janapayyujta cutichishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesúsna niran: «Zaqueo, auquilluyqui Abraham-jina wiyacushayquipita yawar-masintiquita Tayta Diosninchi wamrachacushcashunqui. Juchayquitapis mana yarparanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tayta Diosninchi caćhamasha. Juchaćhu arujcunata ashircur, Tayta Diosninchiman cutichij shamushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesúspa shiminta wiyaj runacuna yarpaycaran: «Tayta Diosninchipa maquinćhüna Jesús purichimäshun. Roma marca runacunata jargushun» nir. Llutanta yarpaptin Jerusalén marcaman ćhayaycashanćhu tincuchiypa willapar, Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","«Juc runash auturdä cananpaj ćhuraptin, mayur auturdäman aywaran. Carguntawan sïllunta ćhasquij caru marcacamanräshi aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manaraj llucshirshi, ćhuncaj piyunnincunata jayachiran: ‹Cay jillayta cutimunäcaman mirachinqui. Llapaniquita chay-chicata jaguipuycaj› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Marca-masincunash ichanga ricaytapis mana munaranchu. Chayshi mayur auturdäman waquinta caćhacuran: ‹Auturdä ćhurashayqui runa cargunta ama ćhasquinmanchu. Ricaytapis mana munallächu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Chaypis mayur auturdä cargunmanshi ćhuraran. Sïlluntapis caćhapuran. Chaura marcanman cutircurshi, piyunnincunata jayachiran: ‹¿Jillaynïta mirachishcanquichu-llapa?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Punta ćhayaj piyunninnash niran: ‹Tayta, jillayniqui ćhunca janapayta mirasha.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Auturdänash niran: ‹Allita rurashcanqui. Ichicllatapis alli ricashayquipita ćhunca marcata maquiquiman ćhurashaj.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Juc-caj piyunninnash niran: ‹Tayta, jillayniqui pichga janapayta mirasha.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Auturdänash niran: ‹Jampis allita rurashcanqui. Pichga marcata maquiquiman ćhurashaj.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Juc-caj piyunninnash jamurpar niran: ‹Tayta, catay jillayniqui. Jillayniquita mana yatapashcächu. Jipilläman jatircushcä. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Manchacuypa runa canqui. Jamashalla imatapis ćhasquiyta munanqui. Mana murupacuycarsi, achca-achcata shuntayta munanqui. Chaymi manchacurä.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chaura auturdä runanash niran: ‹Manacaj runa canqui. Shimillayqui jitarpushcashunqui. Jamashalla imatapis shuyarashäta musyaycar, mana arucuycar achca-achcata shuntayta munashäta musyaycar, ");
INSERT INTO qxhNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","jillaynïta jillay mirachijcunallamanpis jutunquiman caran. Cutimur, wawantinta shuntacüman caran.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Waquin piyunnintanash niran: ‹Jillay charashallantapis jićhurir, ćhunca janapaypa mirachij-cajta juycuy.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Piyunnincunash niran: ‹Tayta, chay runa ćhunca janapayta jillayta charaycan.› ");
INSERT INTO qxhNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Auturdä runanash niran: ‹Wiyacuptin, pitapis Tayta Diosninchi sumaj tantiyachinga. Mana wiyacujcunatam ichanga ichicllata tantiyashallantapis jungaycachinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Auturdä cayman yaycunäta mana munaj runatana apamuy. Ricay ñawïćhu llapanta wañurachiy.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Willapäcuyta ushyarcur, mana jamallar Jerusalén marcaman Jesús aywaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé marcaman, Betania marcaman ćhayaycaran. Chay quinranćhu Ulïbus punta caran. Ishcaj purïshijnincunata caćhar, ");
INSERT INTO qxhNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jesús niran: «Wac chimpa tacsha marcaman aywariycuy. Ćhayar, manta büruta tarinquipaj. Pipis mana muntacunrächu. Watarashanpita pascarir, apacamunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pascaptiqui pipis mićhäshuptiqui, ninqui: ‹Mandamajnïtash mañanqui.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Purïshijcunana aywar, Jesúspa shiminman-tupu büruta tariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pascapacuycaptin, runacuna niran: «¿Imapätaj bürüta pascaycanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Paycuna niran: «Mandamajnï Jesústash mañanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chaura büruta Jesúsman aparan. Jacuncunata shawaparcur Jesústa muntachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bürun muntash Jerusalén marcaman Jesús aywaycaptin, runacuna cushicuywan jacuncunatapis caminuman mashtapuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalén marcaman ricänan Ulïbus punta uranpa yarpuptin, Jesúspa purïshijnincuna llapanmi cushicäriran: «Tayta Diosninchi sumaj munayniyuj. Camacächiptin, Jesús jishyaćhucunata allchacächisha. Supaycunatapis jargusha. Wañushcunatapis cawarachisha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Llapallan cushicuywan japarparan: «Tayta Diosninchi caćhamushan mandaj runa alli ricash caycullächun. Maquinćhu allilla purichimächun. Janaj pachaćhüpis jatunpa cushicullächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Runacuna cushicuptinsi, waquin fariseucuna Jesústa piñacuran: «Tayta, purïshijniquicunata upällachiy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesúsna niran: «Upällachiptï, rumicunapis cushicuywan rimarinman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Jerusalén marcaman yaycupaycashanćhu marcata ricapärir, Jesús wagaran: «Jerusalén runacuna, allilla cawanayquita Tayta Diosninchi munan. Wasguimaptiquim ichanga tantiyacunayquita mana camacächishachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Imayllaga juyupa ñacanquipaj. Cunćharyuyquicuna chapaycur-chapaycur magashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wasiquicunatapis ushyaypa jućhurachinga. Llapaniquita wañurachishunquipaj. Marcayquitapis ragällata jaguiycunga. Juyupa ñacanquipaj washänajta mana munashayquipita. Tayta Diosninchi caćhamashanta mana tantiyacushcanquichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalén marcaman ćhayar, Tayta Diosninchipa wasinpa sawanninman Jesús yaycuran. Sawanpita ranticujcunata jargur ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Llapanta wicapar niran: «Tayta Diosninchipa shiminćhu nin: ‹Wasïga mañacamajcunallapaj.› Jamcunam ichanga suwapa maćhayninman ticrachishcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Waran-waran Tayta Diosninchipa wasinćhu Jesús willapäcuran. Mayur cüracuna, Moiséspa shiminta yaćhajcuna, mayur runacunam ichanga achäquita ashiycaran wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Chaypis mana tariranchu. Runacuna Jesústa mana caćhariranchu. Shiminta sumaj wiyarcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Juc cuti Tayta Diosninchipa wasinćhu Jesús willapäcuycaran: «Shimïta wiyacäriy. Maquinćhüna Tayta Diosninchi purichimäshun» nir. Mayur cüracuna, Moiséspa shiminta yaćhajcuna, mayur runacuna ćhayarcur, Jesústa ");
INSERT INTO qxhNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tapuran: «Tayta, ¿pitaj caćhamushcashunqui? ¿Pipa munayninwantaj imacunatapis ruraycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesúsna niran: «Nuwapis mä, tapucushayqui. Willamaptiqui, nuwapis willashayqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juanta ushyachicunanpaj, ¿pitaj caćhamusha: Tayta Diosninchichu, runa-masillanchu? Mä, willamay.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chaura quiquin-pura parlanacäriran: « ‹Tayta Diosninchi caćhamusha› niptinchi: ‹¿Imanirtaj mana wiyacushcanquichu?› nimäshun. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‹Runa-masinchicunalla caćhamusha› niptinchi, runacuna sajmaypa wañuchimäshun» nir. Runacuna Ushyachicuj Juanta ćhasquicush caran: «Tayta Diosninchipa willacujnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chaymi Jesústa niran: «Tapumashayquita mana musyächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chaura Jesúspis niran: «Mana camäpacuptiqui, pï caćhamashanta nuwapis mana willashayquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaypita tincuchiypa willapäcur, Jesús niran: «Juc ćhacrayuj runash übasta mururan. Jinarcur ćhacra runacunata allimshaycurshi, juclä marcaman juyaj aywacuran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","«Übas pallay ćhayamuptin, uywaynintash caćhacuran: ‹Dirïchüta shuntamuy› nir. Caćha ćhayaptin allimshacuj runacuna sumaj magariycärirshi, jinallata jarguriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chaura ćhacrayuj juc uywaynintanash caćhacuran. Allimshacujcunana chaytapis ashlliran. Magar ushyarirshi, jinallata jarguran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chaura ćhacrayuj juc uywaynintanash caćhacuran. Paytapis magar ushyariycurshi, jarguriran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Chaura ćhacrayuj yarpaćhacuran. Yarpaćhacuriycurshi, niran: ‹Cuyay wamräta caćhacushaj. Paytaga manchapacunga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ćhacrayujpa wamranta ricarshi, allimshacujcuna quiquin-puralla parlanacäriran: ‹Papäninga tagay wamrallanpaj llapan imancunatapis jaguinga. Chaymi wañurachishun. Chaura cay ćhacra maquinchićhüna canga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chaynuy nirshi, ćhacrayujpa wamranta charipäcuran. Ćhacranpita jargurcurshi, wañuycachiran. «Canan mä, willamay. Ćhacrayuj cutimur, ¿imataraj ruranga chay ćhacra runacunata? ");
INSERT INTO qxhNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chay ćhacra runacunata wañurachinga. Ćhacrantapis juctana allimshaycunga.» Jesúspa shiminta wiyar, runacuna niran: «Chayta rurananchita Tayta Diosninchi ama camacächichunchu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Llapan runata ricapärir Jesús niran: «Chaura Tayta Diosninchipa shimin imapätaj niycan: ‹Wasi rurajcuna: «Cay rumi mana allichu» nir wicapashantapis Tayta Diosninchi simintuta jallarachinanpaj ćhurasha.› ");
INSERT INTO qxhNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Wicapash rumiman pipis tacacur, ushyacanga. Runapa jananman rumi shicwar, nitiringa.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mayur cüracunawan Moiséspa shiminta yaćhajcuna wiyächipaycashanta tantiyacuriran. Chaymi Jesústa juclla chariyta munaran. Ichanga achcaj runa juturpaycaptin, runacunata manchacushpan mana chariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chaypis Jesústa charircur, Roma auturdäpa maquinman ćhayachiyta munaran. Ichanga achäquita mana tariranchu. Chaymi achäqui ashijcunawan watgachiran alli-tucullar tapunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Achäquita ashijcuna Jesústa tapuran: «Tayta, alli shungu cashayquita musyä. Pitapis Tayta Diosninchipa shimillanta willapanqui. Llapan runata alli ricanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chaymi tapucushayqui. ¿Mandaj Césarpaj jillayta ćhurashuwanchuraj, manachuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Achäquita ashipashanta musyashpan Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Jillayniquita mä, ricachimay. Jillayćhu, ¿pipa liträtuntaj caycan? ¿Pipa jutintaj isquirbiraycan?» Tapuptin, paycuna niran: «Mandaj Césarpa.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesúsna niran: «Mandaj Césarpata Césarpaj ćhuray. Tayta Diosninchipata Tayta Diosninchipaj ćhuray.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Achäqui ashijcuna ima rimapacuytapis mana camäpacuranchu. Runa ricay pantachiyta mana camäpacur: «Jesús allita riman, ¿au?» nir upällacaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaypita waquin saduceu runacuna Jesúsman ćhayaran. Paycuna yarpaj: «Wañushcuna mana cawaringapächu» nir. Chaymi Jesústa niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Tayta Jesús, Moiséspa shimin nin: ‹Runa wañucur warminta wawaynajllata jaguiptin, wañucuj runapa wauguillan biyüdanwan majachacanman. Mushuj majanwan wamrata tarishan wañucuj runanpa jutinta apanga.› ");
INSERT INTO qxhNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Canan mä, tapucushayqui. Janćhis wauguish caran. Juc wauguish warmiwan majachacaran. Ichanga warminta mana mirachillarshi wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chaura juc-caj wauguinnash chay warmiwan majachacaran. Paypis mana mirachillarshi wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chay warmillawan majachacarcur-majachacarcur mana mirachillar, janćhis waugui wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jipantaräshi warmipis wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tayta, mä, willamay. Wañushanpita cawarcamur, chay warmi, ¿maygan wauguipa warmintaj canga janćhiswan majachacash caycar? ¿Llapanpa warminchuraj canga?» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesúsna niran: «Cay pachaćhu cawashancamalla runacuna majachacan. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tayta Diosninchi acracushan runacuna cawarimur, janaj pachaćhu mana majachacanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wañuymanpis yapay mana ćhayanganachu. Cawarachishancunata wawanpana Tayta Diosninchi ricanga. Anjilcuna-jina mana ushyacangachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wañushcuna cawarinanta mayna Moisés musyachicuran. Isquirbishan librućhu willamanchi. Shira-shiraćhu Tayta Diosninchi niran: ‹Moisés, unay auquilluyqui Abraham, Isaac, Jacob wañush carsi, cawaycan. Tayta Diosnin caycaptï, manchapacaycäman.› ");
INSERT INTO qxhNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cawaycajcunalla Tayta Diosninchita manchapacun; wañushcuna mana. Maquinćhu cawajcuna wañush carsi, cawaycan. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chaura waquin Moiséspa shiminta yaćhajcuna niran: ‹Tayta, allita rimashcanqui.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaypita-pacha pipis mana tapuparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesúsna niran: «¿Imanirtaj runacuna riman: ‹Washäcuj unay mandajninchi Davidpa willcan› nir? ");
INSERT INTO qxhNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Salmos librućhu quiquin David nin: ‹Tayta Diosninchi Washäcujnïta nisha: «Mandäshimänayquipaj dirïcha-caj lädüman jamacuy ");
INSERT INTO qxhNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","cunćharyuyquicunata pampaman ćhuranäcaman. Nishayqui-nishayqui munashayquita rurachinquipaj.» › ");
INSERT INTO qxhNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«¿Washäcuj, rasunpachuraj Davidpa willcallan canga? ¿Runapa wamranchuraj canga? Au, paypitam. Chaypis quiquin mandaj David manchapacur, Taytachacuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Llapan runapa ricay ñawinćhu purïshijnincunata Jesús niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Moiséspa shiminta yaćhajcunapa llupinpa ama aywanquichu. Paycuna alli-tucullar rucapäcushalla purin. Pï-maypis manchapacunanta munan. Shuntacäna wasićhüpis, micupacuyćhüpis ñaupa-ñaupallaćhu jaman. ");
INSERT INTO qxhNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Biyüdacunapa imancunatapis ushyapan. Jinarcur alli-tucur Tayta Diosninchita mañacuj-tucun. Chaypita Tayta Diosninchi sumaj ñacachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tayta Diosninchipa wasinćhu puchuy-puchuy jananćhu cawajcuna cuyachicuyninta ćhurajta Jesús ricapaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Biyüda warmipis pishipacuyćhu cawar, ishcay ćhaniynaj-yupay jillayta ćhurashanta ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chayta ricar, purïshijnincunata Jesús niran: «Sumaj tantiyacunquiman. Waccha biyüda mas achcata ćhurasha puchuy-puchuy jananćhu cawajcunapita. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Paycuna achcata ćhurarpis, puchupacushallanta ćhurasha. Waccha biyüdam ichanga llapan charashallantapis ćhurasha. Chayllawan cawanan caran.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waquin runa parlaycaran: «Achic-achicyaycaj rumicunawan Tayta Diosninchipa wasinta pirgasha. Sumaj cuyayllapaj, ¿au? Runacuna cuyachicuynintapis ćhurasha Tayta Diosninchipa wasin achic-achicyaycaj cananpaj» nir. Jesúsna niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Sumaj ricacuy. Imayllaga llapan ricashayqui ushyaypa ushyacanga. Rumiwan pirgararsi, llapanmi jućhurachish canga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Waquin runa Jesústa tapuran: «Tayta, ¿imaytaj Tayta Diosninchipa wasinta jućhuchinga? ¿Imanaypataj shimiqui ćharcucänanta musyashaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesúsna niran: «Pipis pantachishurunquiman. Achcaj runa shamunga: ‹Tayta Diosninchi caćhamushan Washäcuj caycä. Cay pacha ushyacangana› nir. Imata nishuptiquisi, ama ćhasquipanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wacćhu-cayćhu wañuchinacuy jatariptinpis, ama mancharinquichu. Chaycunaraj cangapaj. Chaypis cay pacha mana ushyacangarächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","«Cay pacha ushyacänanpäga marcan-marcan wañuchinacunga. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chay-tucuyćhüpis pacha juyupa sicsicyanga. Mućhuy captinpis, yargaywan runacuna wañunga. Juyu jishyapis timpuringa. Janaj pachaćhüpis mana ricashanchicunata ricar, mancharinquipaj. Sicsicyanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Chaycunaman mana ćhayaptillayqui, jaticaćhar ushyashunquipaj. Ćhasquicamashayqui-janan mayur Israel runacunapa maquinmanpis, carsilcunamanpis ćhayachishunquipaj. Roma auturdäcunamanpis, mandajcunapis rïsu apashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","«Wacpa-caypa purichishuptiquisi, shimiquita ama amucurcunquichu. Manchäga pï-maytapis nuwapita willapanqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ama yarpaćhacunquichu: ‹Chapacunäpaj, ¿imataraj rimashaj?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chapacunayquipaj quiquïmi yarpächishayqui. Yarpächishäta rimaptiqui, pipis mana ićhipushunquipächu. Pipis mana achäquita taringachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","«Ćhasquicamashayqui-janan mamayqui-taytayquisi, wauguiquicunasi, yawar-masiquicunasi chiquishunquipaj. Paycunapis auturdäcunapa maquinman ćhayachishunquipaj. Waquinniquita wañuchishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ćhasquicamashayqui-janan llapan runa chiquishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chaypis ama llaquicunquichu. Tayta Diosninchi mana jungashunquipächu. Maquinpita mana pipis jurgushunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chaymi jipaman ama cutiricunquichu. Mana yamacällar shimïta wiyacuptiqui, imaycamanpis maquinćhu Tayta Diosninchi cawachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Tayta Diosninchipa wasin jućhunanpaj wallcana pishiptin, jäpa murucucunapis Jerusalén marcaman ćhayapunga. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chayta ricar Judea quinranćhu tiyar, puntacunaman jishpicäriy. Marcaćhu tiyar, ćhacracunaman jishpicäriy. Ćhacrapitapis marcayquiman ama cutiychu. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chay wichan shiminman-tupu Tayta Diosninchi mana wiyacujcunata ñacachinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","«Ñacachishan wichan llapan Israel runacuna juyupa ñacanga. Jishyaj warmicunapis, pishi wamrayujcunapis cuyapaypaj ñacanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquin runa cuchur ushyash wañunga. Waquintana watacurcur ushyashta jäpa marcacunaman apanga. Jäpa runacuna Jerusalén marcata ñacachir ushyanga Tayta Diosninchi jitashan junajcaman.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Intipis, quillapis, istrïllacunapis juc-nirajman ticracuringa. Lamar yacupis bunyaypa-bunyaptin, may-chayćhüpis runacuna mancharinga. Tantiyaytapis mana atipangachu. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Janaj pachatapis Tayta Diosninchi tapsir ushyaringa. Chaymi runacuna manchariyllawan wañucäcungaraj: ‹¿Imamanraj ćhayashun, au?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chay junaj Tayta Diosninchi caćhamaptin munayniyuj caycar, pucutay jananćhu achic-achicyaycar cutiycämujta ricamanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Rimashäcuna ćharcuptin, cushicärinquiman. Ama llaquicärinquimanchu. Washänäpämi cutiramushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","«Jïgus yürawan tincuchiypa tantiyacushun. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yüran chillguiptin, tamya quilla jallaycunanta musyanchi. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chay-jina willapashäcuna ćharcuptin, cutimunä caycashanta tantiyacärinquipaj. Cutimuptï, maquinćhüna Tayta Diosninchi runacunata purichinga. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sumaj tantiyacunquiman. Waquinniquipa ricay ñawiquićhu llapan ćharcucanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Janaj pachapis, cay pachapis ushyacanga. Shimïmi ichanga mana imaysi jungacangapächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Chaymi sumaj tantiyacärinquiman. Shunguyqui munashallanta ama ruranquichu. Upyallaćhu ama cawanquichu. Cay pachaćhu cawanayquipaj yarpaćhacullar jungaycamärunquiman. Mana yarpashpita cutiramushaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Cay pachaman cutimushä junaj pipis mana jishpingachu. Wiyacamajcunata washäshaj; juchaćhu arujcunatam ichanga mana. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chaymi Tayta Diosninchipa caćhan captï, cutimunäta shuyaj-shuyajlla cawanquiman. Mana yamacällar Tayta Diosninchita mañacunqui jishpichishunayquipäpis, ñaupäman cushish ćhayachishunayquipäpis.» ");
INSERT INTO qxhNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Waran-waran Tayta Diosninchipa wasinćhu Jesús willapäcuran. Chacaypam ichanga Ulïbus punta quinranćhu pachacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Runacunapis waran-waran tutalla aywaran Tayta Diosninchipa wasinman Jesúspa shiminta wiyaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chay wichan Israel runacunapa «Libadüraynaj tanta» nishan fiestan yaycaycämuran. Chay fiestata ricsij: «Pascua» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chay junajcuna mayur cüracunawan Moiséspa shiminta yaćhajcuna parlanacuran: «Jesústa pacayllapa wañurachishun» nir. Runacunata manchacur, pacayllapa wañuchiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Supayna Judas Iscariotita maquichacur yarpächiran Jesústa wañuyman jitarpunanpaj. Chaymi Jesúspa purïshijnin carsi, ");
INSERT INTO qxhNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","mayur cüraman, Tayta Diosninchipa wasinta täpajcunapa capitanninman aywaran: «Jesústa charïshishayqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chaura paycuna jatunpa cushicur: «Jillayta jushayqui» niran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chay junajpita-pacha charij-charijllana caycaran runa mana caycaptin mayćhüpis Jesústa charinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pascua fiesta änir ćhayamuran. Chay fiestaćhu Israel runacuna libadüraynaj tantata micuj. Acrashan cashnitapis pishtaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesúsna Pedrutawan Juanta caćharan: «Mä, ayway. Pascua micuyta camaricamuy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Paycuna tapuran: «¿Mayćhütaj camaricamushaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesúsna niran: «Jerusalén marcaman ćhayaptiqui, puyñullawan runa yacuta apaycajta ricanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jipallanta aywanqui. Wasiman yaycuptin, wasiyujta ninqui: ‹Tayta Jesús caćhamasha. ¿Mayćhütäshi wasi jäcuycan purïshijnincunallawan Pascua micuyta micunanpaj?› ");
INSERT INTO qxhNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Paynam camarishallata jäcuj altusninta ricachishunquipaj. Chayllaćhu pishijcunata camaricunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chaynuy niptin, purïshijnincuna aywar, Jesúspa shiminman-tupu llapantapis tariran. Chayllaćhu Pascua micuyta camaricuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chacas-chacasna caćhancunawan micunanpaj Jesús jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nircur niran: «Wañuy mana ćhayapamaptillan, llapaniquiwan Pascua micuyta sumaj munashcä. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cananpita Pascua micuyta mana micushänachu. Llapanchita Tayta Diosninchi maquinman jishpichimaptinchiraj, yapay micushunpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chaypita bïnuyuj cüpata aptacurcur niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Caćhancunatana niran: «Cay cüpallapita llapaniqui upuchinacuy. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sumaj tantiyacunquiman. Cananpita bïnuta mana upushänachu. Llapanchita Tayta Diosninchi maquinman jishpichimaptinchiraj, upushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chaypita tantata aptacurcur, niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur tantata paquircur-paquircur, aypuran: «Catay. Cay tanta quiquïmi caycä. Jamcuna-raycur wañuyman ćhayashaj. Chaymi tantata paquipanacur, washänaj-raycur wañuyman ćhayashäta yarparämanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Micuyta ushyarcur juc bïnuyuj cüpata aptacurcur, niran: «Cay bïnu yawarnïmi. Washänaj-raycur wañuyman ćhayaptï, yawarnï jićhanga. Yawarnïwanraj parlanacushanta juctana Tayta Diosninchi ćharcucaycächin.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Nuwanchiwan micujmi wañuyman jitarpamanga. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tayta Diosninchi caćhamasha. Quiquin camacächiptin, wañuyman ćhayashaj shimin ćharcucänanpaj. Jitarpamaj runam ichanga juyupa ñacanga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chaura caćhancuna tapunacuran: «¿Mayganinchiraj wañuyman jitarpushun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chaypita Jesúspa caćhancuna mandaj cayta ashishpan quiquin-puralla piñanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chaymi Jesús niran: «Jäpa runacuna juc-niraj cawashanta musyanqui. Paycuna Tayta Diosninchita mana manchapacunchu. Mandajnincunapis ullgurcur-ullgurcur, nishan-nishan marca-masincunata imatapis rurachin. Pipis apärinanta mana munanchu. Alli-tucushpan pipis: ‹Llaquipäcuj runa› ninanta munan. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jamcunam ichanga chaynuy ama canquimanchu. Mayur runa carpis, ama mayur-tucunquimanchu. Mandaj carpis, llapanta yanapanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mä, tapucushayqui. Runacuna, ¿pitataj alli ñawinwan rican: mïsaćhu jamajtachu, micuy jaracujtachu? Mayur runa captin, mïsaćhu jamajta alli rican, ¿au? Chaypis nuwaga llapaniquita jarashcaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Ñacapacuptïsi, jamcuna shacyächimashcanqui. Mana caćharaycamashcanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chaymi mandaj canäpaj Papänï ćhuramashan-jina nuwapis mandaj canayquipaj ćhurashayqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mandaj carga, jamarashäćhu jamachishayquipaj. Micushäćhu micunquipaj. Ćhunca ishcaywan casta Israel-masiquicunatapis maquiquiman ćhurashaj. Paycunata mandanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chaypita Simón Pedruta Jesús niran: «Simónllau Simón, wiyacamashayquitapis, mana wiyacamashayquitapis llapaniquita mayur Supay musyapayta munaycäshunqui. Quiquin Tayta Diosninchita mañacusha musyapäshunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Maquichacushunquipaj. Chaypis mayna Tayta Diosninchita mañacushcä maquinpita mana witicunayquipaj. Chaymi wanacurir, willacuj-masiquicunata shacyächinqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedruna niran: «Tayta, wićhgachishuptiquisi, wañuchishuptiquisi, mana imaysi jaguirishayquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesúsna niran: «Pedro, mana ricsij tucumanquipächu. Gällu mana cantaptillan, quimsa cutiparaj wasguimanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaypita caćhancunata Jesús niran: «Ñaupata wallguiynajta, jipiynajta caćhäraj. ¿Imallasi pishishcashunquichu?» Paycunana niran: «Mana imapis pishïmashachu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesúsna niran: «Cananmi ichanga camaricuy. Jillayniquita, jipiquita camaricuy. Cuchilluyqui mana captin punchuyquita ranticuycur, juc cuchilluta rantiy. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sumaj wiyamay. Nuwapaj Tayta Diosninchipa shiminćhu nin: ‹Juchaćhu arujta-jina runacuna ricanga.› Rimashan ćhayamunanpaj wallcallana pishin.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Caćhancunana niran: «Tayta, ishcay cuchilluta charaycä.» Jesúsna niran: «Amana rimashunchu. Mana tantiyamanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chaypita imaypis aywashan-jina purïshijnincunawan-ima Ulïbus punta quinranman Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pacharänanman ćhayar, niran: «Mana wasguimänayquipaj Tayta Diosninchita mañacäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Carushman aywaycur jungurpacuycur, mañacuran: ");
INSERT INTO qxhNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Papä, camacaptin, shuyarämaj ñacay ama ćhayapämanmanchu. Jishpiyta munaptïsi, shungü munashan ama camacächunchu. Manchäga munashayquinuylla llapanpis caycullächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Llaquish mañacuycaptin anjil ćhayarcur, Jesústa shacyächiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Payga juyupa llaquicur, llapan shungunwan Tayta Diosninchita mañacuran. Jananpitapis yawar-jinaraj südaynin shuturan.) ");
INSERT INTO qxhNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mañacuyta ushyaycur, purïshijnincuna juturashanman cutiran. Paycuna llaquicuyllawan puñucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chaymi niran: «¿Puñurcaycanquićhim? Ricchapacuy. Mana wasguimänayquipaj Tayta Diosninchita mañacäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús rimaycaptillan, purïshijnin cashpansi Judas ćhayapuran achcaj runata pushacurcur. Jesústa wamayaj-tucur macallarcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesúsna niran: «Judas, ¿Tayta Diosninchipa caćhan caycaptïchu, wamayämaj tumpaylla wañuyman jitarpaycamanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Charinanta musyar, purïshijnincuna niran: «Tayta Jesús, ¿cuchilluwanchu washäcushun?» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chaynuy nir jucnin mayur cürapa uywayninpa dirïchicaj rinrinta rugupariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesúsna niran: «Ama ruraychu.» Jinarcur runapa rinrinta yataycullar, allchacärachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesústa charij aywarunaj mayur cüracuna, Tayta Diosninchipa wasinta täpajcuna, mayur runacuna. Paycunata Jesús niran: «¿Imatataj yarpanqui? ¿Suwa cashätachu? ¿Imanirtaj jiruyquiwan-jiruyquiwan, cuchilluyquiwan-cuchilluyquiwan shamushcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Waran-waran Tayta Diosninchipa wasinćhu ricamashcanqui. ¿Imanirtaj mana charimashcanquichu? ¿Imanirtaj supay purishan üra shamushcanqui? Supay shacyächishuptiqui munashanta rurar, shamushcanqui. Chaypis Tayta Diosninchiraj llapanta camacächisha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesústa charircur, mayur cürapa wasinman aparan. Caru jipallanta Pedrupis aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Waquin runacuna cürapa wasinman ćhayar sawan rurinćhu ninata ratarcachir, mashacuycaran. Pedrupis mashacuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mashacuycajta ricapärir, cürapa uywaynin jipash niran: «Cay runapis Jesúswan purij runa.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedrum ichanga wasguiran: «Mana ricsïchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mayllanta juc runapis Pedruta ricar, wiyächipaypa niran: «Jampis Jesústa purïshishcanqui, ¿au?» Pedruna niran: «Mana.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chaypita mana aycällatasi juc runapis niran: «Cay runa Galilea marca runam, ¿au? Jesúswan purish canga.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedruna yapay wasguiran: «Mana. Imatash rimacullanquipis» nir. Rimaycaptillan, gällu cantariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesúsna ticrarcur, Pedruta ricäriran. Ricäriptin, Pedro yarpäriran: «Mana ricsij tucumanquipächu. Gällu manaraj cantaptillan, quimsa cutipa wasguimanquipaj» nishanta. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tayta Jesúspa shiminta yarpärir sawan wajtaman llucshiycur, llaquicuywan juyupa wagaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Täpaj runacuna Jesústa pucllacur ushyaran. Wascaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawinta chaparcur, magar ushyaran: «¿Pï magashushayquitapis musyanquichu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tucuyta ashllir ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pacha wararcuptin, mayur runacuna, mayur cüracuna, Moiséspa shiminta yaćhajcuna jutucaran. Mayur Israel runacunapa sisyunninman Jesústa aparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Paycuna Jesústa tapuran: «Mä, willamay. ¿Tayta Diosninchi caćhamushan Washäcujchu canqui?» nir. Jesúsna niran: « ‹Au. Nuwa caycä› niptïsi, mana ćhasquicamanquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Imallata tapuptijsi, mana willamanquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Imata yarpaptiquisi, Tayta Diosninchi caćhamasha. Cananpita Munayniyuj Tayta Diosninchipa dirïcha-caj lädunćhu jamashaj mandäshinäpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesúspa shiminta wiyar, llapan ullgucäcuran: «¿Jamchush Tayta Diosninchipa Wawan canqui?» nir. Jesúsna niran: «Rasullanta rimashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Paycunana niran: «Tistïguta ama ashishunnachu. Wañuchinanchipaj quiquinpa shimillan jitarpuycusha. Shiminpita musyanchi Tayta Diosninchita apärishanta.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jinarcur mayur Israel runacuna Jesústa aparan mandaj Pilatuman. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dispächunman ćhayachir, niran: «Cay runa marca-masïcunatash shimiyaycan Roma auturdäcunata ticrapunanpaj. Mandaj Césarpaj jillayta ćhuranantapis manash munanchu. Mandaj carshi, quiquinpa maquinćhu purichimäshun. Washämänanchipäshi cargunman Tayta Diosninchi ćhurasha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mandaj Pilato Jesústa tapuran: «¿Rasunpachu Israel runacunapa mandajnin canqui?» nir. Jesúsna niran: «Quiquiqui rimashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mayur cüracunatawan llapan runata mandaj Pilato niran: «Tantiyaptï, cay runa mana juchallicushachu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Paycunam ichanga niran: «Rasunpa, llapan Judea runata shimiyaycan. Galilea quinranpita-pachash jallaycamusha. Cayćhüpis shimiyaycashash.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chaura mandaj Pilato tapuran: «¿Cay runa rasunpachu Galilea quinranpita?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Galilea runa cashanta willaptin, mandaj Herodesman Jesústa apachiran. Mandaj Herodesga Galilea marcapa mandajnin caycar, chay junajcuna Jerusalén marcaćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesústa ćhayachiptin, mandaj Herodes sumaj cushicuran. Unaypita-pacha willapanta mayar, Jesúswan tincuyta munaran. Runacuna willash caran: «Jesús jishyaćhucunata allchacaycächin. Supaycunata jargun. Wañushcunatasi cawarachin. Tayta Diosninchi camacächiptinshi, llapanta ruraycan» nir. Chaynuy willaptin, mandaj Herodespis imatapis ricayta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaymi tucuy-tucuyta Jesústa tapuran. Jesúsmi ichanga imatapis mana rimacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mana rimacuptinsi, mayur cüracunawan Moiséspa shiminta yaćhajcuna tucuy-tucuypita tumpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mandaj Herodespis, murucuncunapis Jesústa pampaman ćhuraran. Asipänan cashpan jatun auturdäpa achic-achicyaycaj müdananta ushtuparan. Jinarcur mandaj Pilatupa dispächunman cutichiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay junaj mandaj Herodeswan mandaj Pilato chiquinacuycashanćhu allina ricanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mandaj Pilatuna mayur cüracunata, mayur runacunata, pampa runacunata jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jinarcur niran: «Jamcuna: ‹Roma auturdäcunata ticrapunanchipaj shimiyasha› niptiquisi, juchanta mana tarïchu. Ricay ñawiquićhu sumaj tapurpis, llutan rurashanta mana tarïchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mandaj Herodespis juchallicushanta mana tarishachu. Chaymi dispächüman cutichimusha. Canan cay runa juchata mana aparicushanta musyanchi. Wañuchinanchipäpis achäqui mana canchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Chaymi sumaj wascariycullar, caćhariycushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mandaj Pilatupa shiminta wiyar, llapan runa juc shimillawan japariran: «Barrabásta caćhariy. Jesústam ichanga wañuchiy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabásga Jerusalén marcaćhu auturdäcunata ticrapushanpita, wañuchicushanpita wićhgaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mandaj Pilato Jesústa caćhariycuyta munar, runacunata yapay parlaparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Runacunam ichanga japarpaycaran: «Jesústa rusćhu wañuchicächun. Rusćhu wañuchicächun.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mandaj Pilato yapaypis niran: «¿Llutantatächu rurasha wañuchinäpaj? Wañuchinanchipaj juchallicushanta mana tarïchu. Chaymi sumaj wascariycullar, caćhariycushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Runacuna llapan shungunwan japarparan: «Rusćhu wañuchicächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Japarpaycällar, mandaj Pilatuta aunichiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aunichiptin, ticrapuj captinsi, wañuchicuj captinsi, mañacushannuylla Barrabásta caćhariycuran. Jesústam ichanga rusćhu wañuchinanpaj caćhapaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesústa wañuchinanpaj apaycashanćhu Cirene marcapita Simónwan tincuran. Payga ćhacrapita cutiycaran. Charircur, Simónwan murucucuna rusta matancachiran. Jesúspa jipallanta rusnin matancash aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ricäcujcunapis chay-chicajmi aywaran. Waquin warmicuna llaquicuywan atar aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Wagajta ricar, Jesús niran: «Jerusalén warmicuna, nuwapaj ama wagaychu. Manchäga quiquiquicunapaj, wamrayquicunapaj waganquiman. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chigaypa ñacay ćhayamungapaj. Chaymi runacuna ninga: ‹Ima alliraj waquin warmicuna wawata mana tariranchu. Mana jishyacuranchu. Chuchunanpäpis wamran mana caranchu.› ");
INSERT INTO qxhNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Juyupa ñacay ćhayamuptin juclla wañucuriyta munar, llapan runa ningapaj: ‹Chagacunallasi nitiycamanman. Jućhucunallapis ushyaramanman.› ");
INSERT INTO qxhNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mä, wiyacäriy. Juchaynaj caycaptï runacuna ñacaycächimaptin, ¿imanuyraj Tayta Diosninchi juchallaćhu aruj runacunata ñacachinga?» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesústa wañuchinanpaj apaycar, ishcaj juyu runatapis wañuchinanpaj apaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","«Calabïra» nishan pataman ćhayar, murucucuna rusman Jesústa läbaran. Juyucunatapis jucninta dirïcha-caj lädunman, jucnintana isquirda-caj lädunman läbaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","(Rusćhu läbaraycashanćhu Jesús niran: «Papä, cay runacunapa juchanta jungaycullay, ari. Mana musyayninwan rurashanta ama yarparaychu.») Chaypita murucucuna surtita jitaran Jesúspa müdananta mayganinpis apacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Runacuna imata rurashantapis llapanta ricaparan. Mayur runacuna Jesústa pampaman ćhurar niran: «Waquin runacunata cawarachishash. Washäcuj cananpaj Tayta Diosninchi acracushan captin, quiquillan ruspita mä, yarpamuchun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Murucucunapis Jesústa pampaman ćhuraran. Shigui bïnuta upuchir, niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Israel runacunapa mandajnin car, wañuypita mä, jishpiy.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Rus jananćhüna isquirbiraycaran: «Cayga Israel runacunapa mandajnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lädunćhu läbaraj runapis jucnin Jesústa ashlliran: «Washäcuj car, ruspita mä, jishpiy. Nuwacunatapis jishpichimanquiman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Juc-cajläninćhu läbarajmi ichanga jucninta piñacuran: «Quimsaninchita wañuycächimanchi. Chaypis, ¿Tayta Diosninchita manachu manchapacunqui? ");
INSERT INTO qxhNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuwanchita juchanchipita wañuycächimanchi. Jesúsmi ichanga ima juchatapis mana aparicushachu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jinarcur Jesústa niran: «Tayta, llapan runata maquiquićhu purichir, nuwatapis ama jungamanquichu, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesúsna niran: «Sumaj tantiyacunquiman. Canan junajmi Tayta Diosninchipa ñaupanman ćhayashun. Alli cawayćhu juyäshunpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Lasdüsipita mallwaycaman pacha chacacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Intipis wañucäcuran. Tayta Diosninchipa wasinćhu chaparaj bayïtapis pullanpa callacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesúsna sumaj japariran: «Papä, almallä maquiquićhu caycan» nir. Chaynuy nir wañucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chayta ricar, murucucunapa capitannin Tayta Diosninchita alliman ćhuraran: «Cay runa rasunpa juchaynaj casha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ricaj runacuna jatunpa llaquish wasinman-caman cuticäriran: «Llutanta rurashcanchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesúswan yaćhänacushancunam ichanga carullaćhu ićhirpaycaran. Galilea marcapita purïshij warmicunapis ricaparcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Judea quinran Arimatea marcaćhu José tiyaran. Payga alli runa caran. Tayta Diosninchipa shungun munashallanta rurar cawaj. Paypa maquinćhu cawayta yarparpis, sumaj manchapacuj. Mayur Israel runa caycarsi Jesústa wañuchinanpaj parlanacuptin, mana auniranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chaymi mandaj Pilatuman aywar, José niran: «Jesúspa ayanta apacushaj pampachicunäpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mandaj Pilato aunircuptin, ruspita ayata yarpuchiran. Jinarcur bayïtawan piturcur, ućhcu rurinman pampaycuran. Chay ućhcuman pipis mana pampacusharächu. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pampacushan junaj runacuna camaricuycaran diyawarda captin, warannin jamananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea warmicunapis Joséta aywäshiran Jesústa pampajta ricananpaj. Mayninman pampashantapis sumaj ricaparan. ");
INSERT INTO qxhNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jinarcur wasinman cutiycur, aya jananman jaycunanpaj pirjümicunata camaricuran. Chaypis diyawarda captin, mana aparanchu. Manchäga Moiséspa shiminta wiyacur, jamaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dumingu warariycaptillan, warmicuna pirjümin apacurcur, Jesús pamparashanman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ćhayaptin, chaparaj rumi witiraycajta tariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pamparashan ućhcuman yaycurir, ayata mana tariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Warmicuna ima yarpaćhacuytapis mana camäpacuranchu. Niycaptin ishcaj runa müdananpis achic-achicyaycar, ricaripuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Manchacuywan uysuraycaptin, ricaripushan runa niran: «¿Pitataj ashiycanqui? Cawaj runa wañushcunapa ćhaupinćhu mana canchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ashishayqui runa mana cayćhüchu caycan. Manchäga cawarishana. Galilea marcaćhu caycällar, ");
INSERT INTO qxhNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nishurayqui: ‹Tayta Diosninchi caćhamash captinsi, juchaćhu arujcunapa maquinman runacuna ćhayachimanga. Rusćhu wañuchimanga. Wañuchimaptinsi, quimsa junajta cawarimushaj.› » ");
INSERT INTO qxhNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chayta wiyar, warmicuna Jesúspa shiminta yarpäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chaymi pamparashanpita cutircur, ćhunca jucwan caćhacunatawan waquin purïshijnincunatapis llapallanta willaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Willacuj warmicuna caran Magdalena María, Juana, Santiagupa maman María, waquin warmicunapis. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Warmicuna willacuptin, caćhacuna mana riguiranchu: «Jinam rimacurcaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Waquin mana riguiptinsi, Jesús pamparashanman Pedro aywacullaran. Maćhay rurinman watgaycur, pitushan bayïta juturaycajllata ricaran. Chaura yarpaćhacuycar wasipa cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay junajlla Jesúspa ishcaj purïshijnincuna Jerusalén marcapita Emaús marcaman aywaycaran. Jerusalén marcapita Emaús marcaman ishcay üra puriylla caran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Imapis cashancunata rimaräcur aywaycaptin, ");
INSERT INTO qxhNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","quiquin Jesús tariparcur aywäshiran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Paycunam ichanga mana ricsiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesúsna tapuriran: «¿Imatataj rimarcaycanqui?» nir. Chaura llaquish ićhicaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleofás jutiyuj runana Jesústa tapuran: «¿Jerusalén marcaćhu pacharaycar, imatapis mana musyanquichu? ¿Janyancuna ima cashantapis manachu mayashcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesúsna tapuran: «¿Imataj casha?» nir. Paycuna niran: «Nazaret marca Jesústa wañuycachisha. Payga Tayta Diosninchipa willacujnin car, sumaj willapäcuran. Jishyaćhucunatapis allchacächiran. Supaycunatapis jarguran. Tayta Diosninchipa ricay ñawinćhüpis, runa-masincunapa ricay ñawinćhüpis alli cawaran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Israel marca-masintï payman yupachicuycarä: ‹Jäpa runacunapa maquinpita Jesús jishpichimäshun› nir. Chaypis marcanchipa mayur cürancunawan mayur runacuna rusćhu wañuycachisha. Wañuycachishanpis cananwan quimsa junajna. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","«Jananmanpis chaca-chacalla Jesús pamparashanman aywaj warmicuna cutircamur manchachimasha. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesúspa ayanta manash tarishachu. Ricariparcurshi, anjilcuna nisha: ‹Jesús cawaycan.› ");
INSERT INTO qxhNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Warmicuna willacuptin, waquinnï aywasha. Ćhayaptin, änirshi Jesúspa ayan mana carannachu. Quiquin Jesústapis manash ricarannachu.» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesúsna niran: «¿Upa-jina tantiyacuyta manachu atipanqui? ¿Unay willacujcunapa shimin shunguyquiman manachu ćhayaran? ");
INSERT INTO qxhNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manachu musyarayqui Washäcuj ñacariycurraj Tayta Diosninchipa achic-achicyaycaj wasinman cutinanta?» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Washäcuj cashanta tantiyacunanpaj Tayta Diosninchipa shiminta ima-imapis isquirbirashanta Jesús sumaj willaparan. Moisés isquirbishanpita unay willacujcuna isquirbishanwancaman tantiyachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús marcaman ćhayaycar, Jesús ñaupacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ñaupacuyta camaycuptin, paycuna niran: «Ama aywacuychu. Pachapis chacanaycan. Cayllaćhu pachacushun.» Chaynuy niptin, Jesús auniran. Paycunawan pachacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Micunanpaj jamaraycashanćhu tantata aptarcur, Jesús niran: «Taytallau Tayta, ima allish tarichillämashcanqui.» Jinarcur paquircur-paquircur aypuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chayraj ishcaj purïshijnincuna Jesús cashanta tantiyacuriran. Jesúsmi ichanga illaricäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chaura quiquin-pura ninacäriran: «Parlaräcur aywäshimaptinchi, Tayta Diosninchipa shimin isquirbirajta willapämaptinchi, ¿manachu shungunchisi shacya-shacyalla ricacuran?» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chaymi Jerusalén marcaman juclla cuticäriran. Ćhayar, ćhunca jucwan caćhacunatapis, waquin purïshijcunatapis juturpaycajta tariran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Juturpajcunapis niran: «Nuwacunapis Tayta Jesús rasunpa cawarishanta musyäna. Simón Pedrutapis ricaripusha.» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chaura Emaús marcapita cutijcunapis aywäshishanta willaran: «Jesúswan caminućhu tincushcä. Ichanga tantata paquiriptinraj tantiyacärishcä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Emaús marcapita cutijcuna rimaycaptillanraj, llapanpa ćhaupinćhu Jesús ricacuran. (Nircur niran: «Allilla juyaycullay, ari.») ");
INSERT INTO qxhNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chaura llapan mancharicäcuran: «Almata-imataćhi ricaycanchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesúsmi ichanga niran: «¿Imanirtaj mancharinqui? ¿Imanirtaj llutäpacuycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Almaga aychaynaj, tulluynaj. Nuwam ichanga aychayuj, tulluyuj caycä. Maquï ćhaquïta sumaj ricay. Rasunpa musyanayquipaj mä, yataycamay. Quiquïmi caycä.» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(Chaynuy nir ćhaquintawan maquinta ricachiran.) ");
INSERT INTO qxhNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Llapan juturajcunawan purïshijnincuna sumaj cushicuran. Chaypis tantiyacuyta mana atiparanchu. Chaymi Jesús niran: «¿Imallapis micunanchipaj caycanchu?» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chaura cancash piscäduta jararan. (Abïjapa mishquintapis jararan.) ");
INSERT INTO qxhNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jaraptin, llapanpa ricay ñawinćhu micuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Micucurcur, niran: «Unay willaparaj: ‹Nuwapaj Tayta Diosninchipa shimin rimashan llapanmi ćharcucänan. Moisés isquirbishanćhüpis, unay willacujcuna isquirbishanćhüpis, Salmos isquirbishanćhüpis nuwapaj riman› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chaypita sumaj tantiyachir niran: ");
INSERT INTO qxhNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","«Tayta Diosninchipa shimin isquirbirashanćhu nin: ‹Washäcuj ñacar, wañuyman ćhayanga. Quimsa junajta cawaringa. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nuwapita chay-tucuy marcaćhu willapäcunga. Shimïta wiyacur pipis wanacuptinga, llapan juchanta Tayta Diosninchi jungaycur alli ñawinwanna ricanga.› Chaymi jamcunapis willapäcur purir, Jerusalén marcapita-pacha jallarinqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","May marcaćhüpis ricamashayquita, wiyamashayquita willapäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chaypis Jerusalén marcapita ama llucshinquirächu. Papänï aunishan-jina Espíritu Santuta caćhamushaj shacyächishunayquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaypita llapan purïshijnincunata Betania marcapa Jesús pusharan. Maquinta jugarcur, mañacuran: «Taytallau Tayta, llapanta alli ñawiquiwan ricaycullay, ari. Llapallanćhu yanapaycullay.» ");
INSERT INTO qxhNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mañacuycashallanćhu aywacuran. (Janaj pachaman Jesústa apacuran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Apacuptin purïshijnincuna jungurpacuycur, Jesústa manchapacuran.) Jinarcur Jerusalén marcaman cushishalla cuticäriran. ");
INSERT INTO qxhNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chayćhu waran-waran Tayta Diosninchipa wasillanćhu Tayta Diosninchita alliman ćhuraran.");
INSERT INTO qxhNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Manaraj imapis caycaptillan, Tayta Diosninchipa shiminta Camacächicuj cawaycaran. Shiminta Camacächicuj Tayta Diosninchiwan jucnaylla caran. Camacächicujga Tayta Diosninchim. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Manaraj imapis caycaptillan, Camacächicujwan-ima Tayta Diosninchi cawaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paywanmi llapan imacunatapis Tayta Diosninchi camaran. Payllapita llap-llapanpis caycan. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Paylla cawachicuj. Achqui-jina Tayta Diosninchi pï cashantapis runacunata tantiyachin. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Achicyapämashpanchi Tayta Diosninchipa shungun munashanta tantiyachimanchi. Jucha aparicujcunam ichanga chacajćhu juyar, quiquinpa shungun munashallanta ruran. Achquita wañuchishan-jina Camacächicujtapis wañurachiyta munaran. Ichanga mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tayta Diosninchi juc runata caćhamuran. Caćhamushan runa Juanmi caran. Pay willapäcuran: ");
INSERT INTO qxhNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","«Camacächicujman llapan runa yupachicunanpaj willacamuy. Payga achqui-yupay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan mana achquichu caran. Manchäga achqui pï cashantapis tantiyachicuj shamuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Achqui-yupay Camacächicuj cay pachaman shaycamuran llapan runata Tayta Diosninchipa shiminta musyachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tayta Diosninchipa shiminta Camacächicuj cay pachaćhu caycaran. Cay pachatapis quiquin camaran. Runacunam ichanga pï cashantapis mana ricsiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Camacächicujga Israel marcaćhu yuriran. Chaypis marca-masincuna mana ćhasquicuranchu. Manchäga wasguiparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Payta ćhasquicujcunatam ichanga Tayta Diosninchi wamrachacun: «Wawämi canqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Camacächicujman yupachicuptin, pï-pïtapis Tayta Diosninchi wamrachacun. Ichanga mana runapa shungun munashanpitachu, mana runa churiyäcushanpitachu, mana warmi mirashanpitachu, manchäga quiquinpa shungun munaptin, pitapis wamrachacun. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tayta Diosninchipa shiminta Camacächicuj runa-masinchi yuriran. Cay pachaćhu cawaran. Sumaj munayniyuj cashanta nuwacuna ricashcä. Tayta Diosninchipa japallan Wawan cashantapis tantiyacushcä. Llaquipäcujmi caran. Shiminta ćharcujmi caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Camacächicujpita rimar, Juan niran: « ‹Shaycämun› nishä runa cayćhüna caycan. Puntata yurish captïsi mana yuriptillä, cawaycaran. Mayurnï cashpan alli ricash canan camacan.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pay-raycur Tayta Diosninchi llaquipämashpanchi sumaj-sumaj yanapaycämanchi. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Unayga Tayta Diosninchipa shiminta ima-imata ćharcunanchipäpis Moisés tantiyachimaranchi. Cananmi ichanga Jesucristu tantiyachimanchi Tayta Diosninchi llaquipäcuj cashantapis, shungun yarpashantapis. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Quiquin Tayta Diosninchita pipis mana imaypis ricashachu. Wawallanta ricasha. Payga Tayta Diosninchi. Jesúsga Tayta Diosninchiwanpis juc shungulla cawan. Chaymi Tayta Diosninchi imanuy-imanuy cashantapis tantiyachimanchi. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Chaura Juan willapäcuptin, cüracunawan, Leví runacunawan, Jerusalén marca mayur runacuna tapuchiran: «¿Pitaj caćhamushcashunqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tapuptin, Juan mana chapacuranchu. Manchä juclla niran: «Mana Tayta Diosninchi caćhamushan Washäcujchu cä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yapaypis tapuran: «¿Pitaj caćhamushcashunqui? ¿Tayta Diosninchipa unay willacujnin Elías-jinachu canqui?» nir. Juanna niran: «Mana Elías-jinapishchu cä.» Yapaypis tapuran: «¿Tayta Diosninchi ćhurashan Willacujchu canqui?» nir. Juanna: «Mana» niran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chaura yapay tapuran: «¿Pitaj caćhamushcashunqui? Pï cashayquitapis mä, willamay caćhamaj runacunata willanäpaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanna niran: «Unay willacuj Isaíaspa shimin ćharcucänanpaj shamushcä. Paypa shimin nin: ‹Chunyajćhu juc runa jayacuypa willacuycan: «Taytanchi shamunanpaj wicsu caminuta allchay» nir.› » ");
INSERT INTO qxhNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chaypis fariseucunapa caćhancuna Juanta yapay tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","«Washäcujpis mana carga, Elíaspis mana carga, Tayta Diosninchi ćhurashan Willacujpis mana carga, ¿imanirtaj ushyachicuycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanna niran: «Pipis Tayta Diosninchipa maquinćhu cawayta munar juchapita wanacuptin, yacullawan ushyachicuycä. Chaypis mana ricsishanchi runa marcanchićhu puriycan. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jipäta shamuptinsi, payga munayniyujmi. Llanguinta llushtipuyllatapis manchapacü.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juanta tapurunaj chimpaćhu-caj Betabará marca ćhaquinćhu. Juanga runacunata ushyachirunaj Jordán mayućhu. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Warannin junaj Jordán mayuman Jesús ćhayaycaran. Payta ricar, llapan runata wiyächipaypa Ushyachicuj Juan niran: «Mä, ricay. Paymi Tayta Diosninchi caćhamushan runa. Payga uysha-yupay wañuyman ćhayanga llapan runapa juchanta aparicur. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paypaj willacurä: ‹Jipäta shamuj runa munayniyujmi. Puntata yurish caycaptïsi mana yuriptillä, mayna cawaycaran› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Quiquïpis mana ricsishcächu. Chaypis Israel-masintinchi ricsicunanchi-raycur yacuwan ushyachicuycashcä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jananmanpis Juan niran: «Janaj pachapita Espíritu Santu paluma-jina Jesúsman ćhayamujta ricashcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Washäcuj pï cashantapis mana musyashcärächu. Yacuwan ushyachij caćhamaj Tayta Diosninchim ichanga nimaran: ‹Espíritu Santupa maquinćhu Washäcujta purichishaj. Paypis Espíritu Santuwan pitapis ushyachinga maquïćhu purinanpaj.› ");
INSERT INTO qxhNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nuwaga ñawïwanraj llapanta ricashcä. Tayta Diosninchipa Wawan cashanta musyä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Warannin junajpis Juan ishcaj purïshijnincunawan-ima jinallanćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús aywaycajta ricar, Juan niran: «Tagaymi Tayta Diosninchi caćhamushan runa. Payga uysha-yupay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chaynuy niptin, Juanpa purïshijnincuna Jesústa jaticurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jaticurcuptin ticrarcur, Jesús niran: «¿Imatataj ashinqui?» Paycuna niran: «Yaćhaj tayta, ¿mayćhütaj tiyanqui?» Rimayninćhu: «Yaćhaj tayta» ninanta: «Rabbí» nin. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesúsna niran: «Shamuy. Ricsichishayqui, ari.» Aywar, Jesús tiyashanman ćhayaran. Tacsha mallwayna caycaptin, jinallanćhu pachacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jesústa aywäshijcuna jucnin caran «Simón» nishan Pedrupa wauguin Andrés. Paymi Ushyachicuj Juan willapäcushanta wiyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrésna wauguin Simónta tarir, willaran: «Tayta Diosninchi acracushan Washäcujwan tincushcä» nir. «Washäcuj» ninanta hebreo rimayćhu: «Mesías» nin; Griego rimayćhüna: «Cristo» nin. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nircur Jesúsman pusharan. Ćhayachiptin, Simónta sumaj ricapärir, Jesús niran: «Juanpa wamran Simón canqui, ¿au? Cananpita jutiqui canga: ‹Pedro.› » «Pedro» ninanpaj: «Kefas» nir jutichaparan. «Kefas» ninanga: «rumi» ninanmi. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Warannin junaj Galilea quinranman aywayta Jesús yarparan. Felipiwan tincur, niran: «Purïshimay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipiga Betsaida marcapita caran. Andréswan Pedrupis chay marcallapita caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipina Natanaelta tarir, willaran: «Washäcujwan tincushcä. Paypaj Moiséspa shiminpis, unay willacujcunapa shiminpis riman. Washäcuj Jesúsga Nazaret marca Josépa wawan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelna niran: «¿Nazaret marcaćhu alli runa yurinmanćhi?» Felipina niran: «Ricanayquipaj mä, aywashun, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael ćhayaycaptin, Jesús niran: «Paymi rasunpa unay auquillunchi Israelpa willcan. Payga llullacuytapis mana yaćhanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelna tapuran: «¿Imanuypataj pï cashätapis musyanqui?» nir. Chaura Jesús niran: «Manaräpis Felipiwan tincuptillayqui, ricashcaj. Jïgus yüra ćhaquinćhu jamaraycarayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelna wiyächipaypa niran: «Taytallau tayta, rasunpa Tayta Diosninchipa Wawan canqui. Israelcunapa mandajnin canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesúsna niran: «¿‹Jïgus yüra ćhaquinćhu ricashcaj› nishalläpitachu yupachicamanqui? Wara-warantinraj sumaj-sumaj tantiyacunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jinarcur niran: «Sumaj tantiyacunquiman. Caćhan captï, Tayta Diosninchi sumaj ricaman. Jamcuna janaj pachata quićharaycajta ricanquipaj. Anjilcunapis waquinga nuwapita jigarcaycanga. Waquinna janaj pachapita nuwaman yarpurcaycämunga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chaypita quimsa junajta Galilea quinran Caná marcaćhu juc runa warmita ashiran. Jesúspa mamanpis warmi ashiyćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jayachish captin, purïshijnintin Jesúspis warmi ashiyćhu caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Warmi ashiyćhu bïnu ushyacäcuran. Ushyacäcuptin, maman Jesústa niran: «Bïnu ushyacäcushana.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesúsna niran: «Mamallau mama, ¿imanirtaj jaticanqui? Pï cashätapis ricsichicunä junaj mana ćhayamunrächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chaypis Jesúspa maman sirbinticunata niran: «Wawä Jesús nishanta llapanta ruranqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chay wasićhu rumipita sujta urpu caycaran. Cada urpuman yaycuj paćhac (100) litru-yupay yacu. Israelcuna Tayta Diosninchipa ricay ñawinchu alli cayta munar, urpucunaćhu yacuta wiñarächij. Chay yacullawan mayllacuj. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesúsna sirbinticunata niran: «Urpucunaman yacuta juntachiy.» Chaura änir yacuta juntachiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Juntarcachiptin, Jesús niran: «Wallcallata ćhagarcur, mayur sirbintiman apay.» Nishanta änir ruraran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mayur sirbintina mallircuran. Ichanga maypita jurgamushantapis mana musyaranchu. Waquin sirbintilla yacupita bïnuman ticrachishanta musyaraycaran. Chaura mayur sirbinti warmi ashij müsuta jayarcur niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Llapanpis puntata alli bïnuta runata upuchin. Sumaj upucurcuptinraj, shigui bïnuta upuchin. Jammi ichanga ushyacänancaman pugush bïnuta ćhurarächicushcanqui, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chayraj Jesús munayniyuj cashanta musyachicuran. Galilea quinran Caná marcaćhu yacuta bïnuman ticrachishanta ricar, Tayta Diosninchipa maquinćhu Jesús purishanta purïshijnincuna tantiyacuran. Llapan shungunwanna Jesúsman yupachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaypita Cafarnaún marcaman mamanwan, wauguincunawan, purïshijnincunawan-ima Jesús aywacuran. Chayćhüna ishcay-quimsa junaj juyapäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel runacunapa Pascua fiestan yaycaycämuptin, Jesúspis Jerusalén marcaman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ćhayaptin, Tayta Diosninchipa wasinpa sawanninćhu runacuna türucunata, uyshacunata, palumacunata ranticurcaycaran. Jillaytapis rucanacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesúsna wascata aptacurcur, Tayta Diosninchipa wasinpa sawanninpita uyshantinta, türuntinta jarguran. Jillaynincunatapis mashtariran. Mïsancunatapis sajtar ushyariran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Paluma ranticujcunatapis niran: «Imayquicunatapis jurguy. Papänïpa wasinćhu mana ranticunayquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chaynuy ruraptin, purïshijnincuna Tayta Diosninchipa shiminta yarpäriran. Shiminćhu nin: «Tayta, wasiqui-raycur imamanpis ćhayäman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mayur Israel runacunam ichanga niran: «¿Pitaj ćhurashcashunqui jargumänayquipaj? Tayta Diosninchi caćhamushayquita musyanäpaj mä, imatapis ruray.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesúsna niran: «Mä, Tayta Diosninchipa wasinta jućhurachiy. Nuwam ichanga quimsa junajllaćhu cashganman jatarachishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mayur runacunana niran: «Tayta Diosninchipa wasinta ćhuscu ćhunca sujtawan (46) watataraj rurayta ushyash caran. ¿Imanaypash quimsa junajllata yapay jatarachinquiman?» ");
INSERT INTO qxhNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tayta Diosninchipa wasinpaj rimarpis, wañushanpita cawarimunanpaj Jesús rimaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wañushanpita Jesús cawarimuptinraj, purïshijnincunapis chaynuy nishanta yarpäriran. Chayrämi Jesúspa shiminpis, Tayta Diosninchipa shiminpis shungunman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalén marcaćhu Pascua fiesta wichan Tayta Diosninchipita shamushanta Jesús musyachicuran. Ima-imatapis rurashanta ricar, achcaj runa Jesúsman yupachicuran. Jesúsmi ichanga shungunta musyar, paycunaman mana yupachicuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Payga runapa shungunta musyaparan pipis mana willaycaptillan, rurashantapis mana ricaycällar. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Chay marcaćhu Nicodemo jutiyuj runa tiyaran. Mayur fariseu runa caycaptin, Israel-masincuna alli ñawinpa ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Juc chacay Jesúsman aywaran. Ćhayar, niran: «Yaćhaj tayta, Tayta Diosninchipa caćhan car, shiminta willapäcuycanqui. Camacächiyninpa tucuy-jinanpa runacunatapis yanapaycanqui. Rurashayquicunata runa mana ruranmanchu. Chaymi caćhamushushayquita nuwacuna musyä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesúsna niran: «Sumaj tantiyacunquiman. Tayta Diosninchipa maquinćhu imaypis cawanayquipaj yapayraj yurinayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemuna tapuran: «Auquis runa caycar, ¿imanaypataj yapay yurïman? ¿Yapay yurinäpaj mamäpa paćhanman cutïmanchuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chaura Jesús niran: «Sumaj tantiyacunquiman. Pipis Tayta Diosninchipa maquinćhu cawayta munar, yacupitapis, Espíritu Santupitapis yurinman. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maman-taytanpita yurijcuna wañucujlla. Espíritu Santupita yurijcunam ichanga Tayta Diosninchipa maquinćhu cawan. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama yarpaćhacuychu: ‹Yapayraj yuriy› niptï. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayrata mayarsi, maypita shamushantapis, maypa aywashantapis runacuna mana musyanchu. Chay-jina Espíritu Santu pï-pïta cawachishantapis runacuna mana musyanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chaura Nicodemo niran: «Tayta, shimiqui umäman mana yaycunchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesúsna niran: «Moiséspa shiminta Israel-masiquicunata willapaycarsi, ¿manaćhi tantiyacunquichu? ");
INSERT INTO qxhNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sumaj tantiyacunquiman. Musyashäta, ricashäta nuwacuna willacü. ¿Imanirtaj jamcuna shimïta mana ćhasquicunquichu? ");
INSERT INTO qxhNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ricashallayquita willapaycaptïsi mana ćhasquicur, ¿imanuyparaj ćhasquicunquiman janaj pachapita willapaptï? ");
INSERT INTO qxhNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Janaj pachaman jigarcur, pipis mana willacuj cutimunmanchu. Nuwam ichanga Tayta Diosninchipa caćhan car, janaj pachapita yarpamushcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Unayga chaqui pachaćhu brunsipita curuta rurarcur, Moisés jugarächiran. Chay-jina nuwatapis Tayta Diosninchipa caćhan caycaptïsi, jugarachimanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pipis nuwaman yupachicamaptin, mana ushyacaj cawayta taringa.» ");
INSERT INTO qxhNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tayta Diosninchi llapan runata llaquipashpan cay pachaman japallan Wawanta caćhamuran. Pipis Wawanman yupachicur, ushyacayman mana ćhayangapächu. Manchäga imaycamanpis cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tayta Diosninchi Wawanta caćhamuran mana ñacayman runacunata ćhayachinanpächu; manchäga llapanta jishpichinanpaj. Paylla jishpichimäshun. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Chaymi Wawan Jesúsman yupachicuptinchi, Tayta Diosninchipis alli ñawinwan ricamanchi. Mana yupachicuptinmi ichanga, pitapis juyu ñawinwan rican. Ñacaymanpis mayna ćhayachisha japallan Wawanman mana yupachicushanpita. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Runacunapa shungunta musyapänanpaj Tayta Diosninchi Jesústa caćhamuran. Paymi achqui-jina Tayta Diosninchipa shungunta musyachicuran. Juchaćhu arujcunam ichanga chacajćhu-jina cawayllata munaran. Achquićhu cawayta mana munashan-jina, Tayta Diosninchitapis mana wiyacuranchu. Chaymi Jesústapis wasguiparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Llapan juchallaćhu arujcuna achquita chiquin. Ricaytapis mana munanchu jucha aparicushanta mana taripunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tayta Diosninchipa shungun munashannuy cawajcunam ichanga achquiman witipushan-jina Jesúsman witipun. Paycuna allita rurar cawaptin, Tayta Diosninchipa maquinćhu cawaycashantapis runacuna musyanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaypita Judea quinranman purïshijnincunawan-ima Jesús aywaran. Chay quinranćhu runacunata ushyachishpan juyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ainón marca rajraćhu achca yacu captin, Juanpis runacunata ushyachiycaran. Ainón marcaga Salín marcapa washlällanćhu caran. Ushyachicuycashanta mayar, waquin runa ushyacuj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Juan ushyachicuycaran carsilman manaraj wićhgaptillan.) ");
INSERT INTO qxhNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chaura Ushyachicuj Juanpa purïshijnincuna juc Israel runawan tincupänacuran: «¿Imanayparaj juchanchita ushyacächishuwan Tayta Diosninchi alli ricamänanchipaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chaymi Juanta willaran: «Tayta, Jordán mayu chimpanćhu tincushayqui runa ushyachicuycan. Chay-chicaj runa aywarcaycan. Paypaj: ‹Washäcuj› nir willacurayqui, ¿au?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ushyachicuj Juanna niran: «Runa imatapis ruran. Chaypis Tayta Diosninchi camacächiptinraj, allimanpis ćhayan. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jamcunata mayna willashcaj: ‹Mana Tayta Diosninchi caćhamushan Washäcujchu cä. Manchäga Washäcuj Jesús shamunanta willacujlla caćhamasha.› ");
INSERT INTO qxhNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jipash müsu majachacaptinshi majachacächij runa yanagar, munashanta camacächin. Yanagashpanshi sumaj cushicun. Chay-jina Jesúspa ñaupanćhu aywar, sumaj cushicü. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesúsllata llapanpis taytachacunan. Nuwam ichanga jungacaypa aywanä. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Janaj pachapita shamujman pipis mana tincunchichu. Nuwanchim ichanga cay pachaćhu yurish car, pishi-yarpaylla caycanchi. Rimanchipis cay pachaćhu cawanallanchipaj. Janaj pachapita shamujmi ichanga munayniyuj. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Chaymi janaj pachaćhu ricashancunata, wiyashancunata willacuycan. Willacuptinpis, waquin runa shiminta mana ćhasquinchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Washäcuj Jesúspa shiminta ćhasquicurmi ichanga, Tayta Diosninchipa shimintapis aunin: ‹Tayta Diosninchiga shiminta ćharcun› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","«Tayta Diosninchipa caćhan car, shimintapis Jesús willapäcun. Sumaj yanapashpan maquinćhüpis Espíritu Santu purichin. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wawan Jesústa llaquishpan alli ñawinwan Tayta Diosninchi rican. Chaymi llap-llapanta paypa maquinman ćhurasha. ");
INSERT INTO qxhNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pipis Wawanman yupachicur, mana ushyacaj cawayta tarishana. Wawanpa shiminta mana wiyacuptinmi ichanga, maquinćhu Tayta Diosninchi mana cawachingachu. Manchäga juyu ñawinwan ricar, imaycamanpis ñacachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chaura fariseucuna imata rimaycashantapis Jesús mayaran. Paycuna rimaycaran: «Jesúspa purïshijnincuna achcayaycan. Ushyachicuj Juan ichicllata ushyachiran; Jesúsmi ichanga sumaj achcajta» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Chaypis mana quiquin Jesúschu runacunata ushyachiran; manchä purïshijnincunalla. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chaura fariseucuna rimaptin, Judea quinranpita Galilea quinranman purïshijnincunawan-ima Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilea marcacunaman ćhayananpaj Samaria quinranparaj aywanan caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chaymi Samaria quinranćhu Sicar marca ñaupanman ćhayaran. Chay quinran caran Jacobpa wamran Josépa ćhacran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob ućhcuchishan püsuman lasdüsi ćhayar, uticash cashpan Jesús jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chaycaman purïshijnincuna rantipacuj aywaran. Marcaman rantipacuj aywacushallanta Samaria warmi yacu jurguj püsuman ćhayaran. Jesúsna warmita niran: «Yacullayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Israel runacunawan Samaria runacuna juyupa chiquinacuptin, ricanacuytapis mana munaranchu. Chaymi Samaria warmi Jesústa niran: «Israel runa caycar, ¿imanirtaj yacuta mañacamanqui? ¿Samaria warmi cashäta manachu musyanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesúsna niran: «¿Manachu musyanqui Tayta Diosninchi llaquipäcuj cashanta? ¿Pï cashätapis manachu musyanqui? Yacuta mañacamaptiqui, cawachicuj yacuta tarichijman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Warmina niran: «Yacu rurićhüraj caycan. Jurgamunayquipäpis mana imayquisi canchu. ¿Maypitaraj cawachicuj yacuta jurgapamanquiman? ");
INSERT INTO qxhNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Unay auquillunchi Jacobshi cay püsuta ućhcuchiran. Nuwacunata jaguipamaran. Quiquinpis, wamrancunapis, uywancunapis cay püsullapitash yacuta upuran. ¿Jamrächuraj payman tincunquiman?» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chaura Jesús niran: «Tincuchiypa tantiyachishayqui. Cay püsupita yacuta upujcuna imaypis yacunaycangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nuwa jushä yacuta upurmi ichanga, imaypis mana yacunanganachu. Manchä yacupa ñawin pashtamushan-jina quiquinćhu cawachicuj yacu pashtamunga. Cawachicuj Tayta Diosninchi maquinćhu imaycamanpis cawachimäshun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chaura warmi niran: «Imaypis mana yacunänäpaj, cay püsumanpis yacucuj mana cutimunäpaj mä, yacuyquita jumay ari, tayta.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesúsna niran: «Majayquita pushamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chaura warmi niran: «Majä mana canchu.» Jesúsna niran: «Rasullanta rimashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Runa rucachijmi canqui. Pichgajwan juyashcanqui. Canan-cajwanmi ichanga puripänacuycanqui. Chaymi: ‹Majä mana canchu› nir mana llullacushcanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chaura Samaria warmi niran: «Tayta Diosninchipa shiminta willacuj canqui, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Unay auquillücuna tagay puntaćhüraj Tayta Diosninchita alliman ćhuraj. Jamcunam ichanga Israel runa car, ninqui: ‹Jerusalén marcallaćhu llapan runapis Tayta Diosninchita alliman ćhuranman.› » ");
INSERT INTO qxhNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chaura Jesús niran: «Mamallau, sumaj tantiyacunquiman. Juc junaj ćhayamuptin, Tayta Diosninchita manchapacunanpaj runa tagay puntamansi, Jerusalén marcamansi mana aywangachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria marca-masintiqui manchapacursi, Tayta Diosninchi pï cashantapis mana musyanquichu. Nuwacunam ichanga musyä. Washämajninchi Israel runacunapita llucshimungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tayta Diosninchita alliman ćhurananchi junajcuna ćhayamushana. Chaymi Tayta Diosninchita llapan shungunwan manchapacujcunata Espíritu Santu yanapaycan. Cawachicuj Tayta Diosninchi shungun yarpashanta musyachicujmi. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Espíritu Santu yanapaptin, Tayta Diosninchipa shungun munashannuy pipis manchapacunman. Tayta Diosninchi cawachicuj caycaptin, shungun munashanta musyachicuj caycaptin, llapan shungunwan pipis manchapacunman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chaura warmi niran: «Washäcuj shamunanta musyä. Shamur, Tayta Diosninchipa shungun yarpashanta tantiyachimäshunpaj.» (Washäcujta ricsij: «Cristu» nir.) ");
INSERT INTO qxhNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Niptin, Jesús niran: «Nuwa Washäcujmi cä. Quiquïwan parlaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Samaria warmiwan Jesús parlaycaptin, micuyta rantij aywamushanpita purïshijnincuna ćhayaran. Samaria warmiwan parlaycajta tariycur, mancharicäcuran. Ichanga imata parlashantapis mana tapuparanchu. Chaypis shimin rurillanćhu parlaran: «Tagay warmi, ¿imatataj ashiycan? ¿Imanirtaj paywanraj Jesúspis parlaycan?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Warmina yacu puyñunta jaguiycur, wasinman cuticullaran. Marca-masincunata niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Yacu püsućhu juc runa caycan. Imanuy-imanuy cawashallätapis llapanta willaramasha. Aywashun-llapa ricanayquipaj. ¿Manachuraj Tayta Diosninchi caćhamushan Washäcuj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chaymi llapan runa Jesúsman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Manaraj ćhayaptillan, purïshijnincuna Jesústa niran: «Tayta, micucurcuy, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesúsna niran: «Micuynï caycan. Jamcunam ichanga mana tantiyanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Purïshijnincunana quiquin-pura tapunacuran: «¿Piraj micuyta apapämusha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesúsna niran: «Tayta Diosninchi caćhamasha. Chaymi shungun munashanta ruraptï, paćhäpis mana yarganchu. Paypa shiminta ćharcur, sumaj cushicü. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rimaypis purin: ‹Murushanchipita ćhuscu quillataräshi micuy pugun› nir. Chaypis micuy jarwaraycan. Mä, sumaj ricaćhacuriy. May-may runacuna caycan. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Micuy shuntajcuna pägunta ćhasquin. Shuntarcuptin, murujpis, shuntajpis sumaj cushicun. Chay-jina Tayta Diosninchipa shiminta willacujpis, runacunata tantiyachijpis sumaj cushicun: ‹Shiminta ćhasquicujcuna Tayta Diosninchi maquinćhu imaycamanpis cawanga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Juc rimaypis purin: ‹Jucshi murun. Jucshi shuntan› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Juc runacuna murupacur ñacasha. Jamcunata juc murushanman shuntaj caćhashcaj. Juc arucushallanman aywaj-aywanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chaura Samaria runacuna warmipa shiminta wiyar, Jesúsman yupachicuran. Warmi mayna nish caran: «Imanuy-imanuy cawashallätapis llapanta willaramasha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chaynuypa Samaria runacuna ćhayar, Jesústa niran: «Tayta, juyapärishun, ari» Chaymi ishcay junaj Jesús juyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chayćhu juyaptin quiquinpa shiminta wiyar, achcaj runa Jesúsman yupachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chaymi Samaria warmita llapan runa niran: «Canan mana shimillayquipitachu payman yupachicü. Manchäga rinrïwan quiquinpa shiminta wiyashcä. Chaymi Washäcuj cashanta musyä. Payga llapan runata washanga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Samaria marcaćhu ishcay junaj juyapärir, Galilea quinranman Jesús cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pay nirunaj: «Yurishan marcaćhu marca-masincuna Tayta Diosninchipa willacujnincunata pampaman ćhuran. Ricaytapis mana munanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chaypis Galilea quinranman ćhayaptin, runacuna cushish ćhasquicäriran. Paycuna Pascua fiestaman aywar, Jerusalén marcaćhu Jesús ima-imata rurashantapis ricarunaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yacuta bïnuman ticrachishan Caná marcaman Jesús ćhayaran. Chayćhu juc Roma marcapita mandaj runa caycaran. Cafarnaún marcaćhu chay mandajpa wamran juyupa jishyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chaymi: «Judea quinranpita Galilea quinranman Jesús ćhayamusha» niptin, taripaj aywaran. Ćhayar, mañacuran: «Tayta Jesús, wawäta allchacaycachipallämay, ari. Wasïman aywashun. Wawä wañuycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesúsna niran: «¿Yupachicamänayquipaj allchacächinätarächu munarcaycanqui? ¿Tayta Diosninchi camacächishanta camacächinätarächu shuyarcaycanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mandaj runam ichanga niran: «Tayta, manaraj wamrä wañushancaman juclla aywashun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesúsna niran: «Cuticuyna. Wamrayqui allchacashana.» Mandaj runana änir Jesúspa shiminman yupachicur, wasinpa cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ćhayaycaptin, mincaynincuna tariparan: «Wamrayqui allchacashana» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mandaj runana tapuran: «¿Imay ürataj allchacasha?» nir. Paycunana willaran: «Janyan inti tumariycaptin, allchacasha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mandaj runana niran: «Janyan caynuy üra Jesús nimaran: ‹Wamrayqui allchacashana.› » Chaymi quiquin mandaj runapis, wasinpa Jesúsman yupachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea quinranpita cutircur, ishcay cutipa Galilea quinranćhu Jesús musyachicuran Tayta Diosninchipa maquinćhu cawashanta. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaypita unayllata Jerusalén marcaćhu fiesta caycaptin, Jesúspis aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén marcapa puncunta jucta ricsiran: «Uysha llucshinan puncu» nir. Puncupa ñaupanćhu armacuna püsu caycaran. Hebreo rimayćhu: «Betesda» nij. Püsuta ćhuscu curidur tumaraycaran. Juc curidurna pullanta raquiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Curidurcunaćhu jishyaćhucunapis, japracunapis, wijrucunapis, cumllucashcunapis juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chayćhu juc runapis jitaraycaran. Payga quimsa ćhunca pusajwan (38) watana jishyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Unaylla jishyashanta musyar, Jesús tapuran: «¿Allchacayta munanquimanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jishyaćhu runana niran: «Au, tayta, allchacayta munä. Ichanga anjil yacuta cuyuchiptin, mana pipis canchu yacuman yaycachimänanpaj. Imaypis yaycuyta munaptï, jucmi llalliraman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chaura Jesús niran: «Jatariy. Mashtacuyquita shuntacurcur, aywacuyna.» ");
INSERT INTO qxhNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chaynuy niptin, allchacäcuran. Änir, mashacunta shuntacurcur, aywacuran. Allchacashan junaj diyawarda caran. Diyawardaćhu Israel runacuna mana ima aruytapis rurajchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chaymi mayur Israel runacuna allchacaj runata piñacuran: «Diyawarda caycaptin, mashtacuyqui aysash ama purinquimanchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Allchacaj runana niran: «Allchacächimaj runa nimasha: ‹Mashtacuyquita shuntacurcur, aywacuy.› » ");
INSERT INTO qxhNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chaura mayur Israel runacuna tapuran: «¿Pitaj nishcashunqui: ‹Mashtacuyquita shuntacurcur, aywacuy›?» ");
INSERT INTO qxhNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Allchacaraycachir juturaj runacunaman yaycurir, Jesús illaricäcuran. Chaymi allchacaj runa pï allchacächishantapis mana musyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mayllanta Tayta Diosninchipa wasinćhu allchacaj runawan Jesús tincuran. Tincur, niran: «Allchacash caycar, juchata ama aparicuynachu. Yapay juchata rurar, imamanräshi ćhayanquipäsi.» ");
INSERT INTO qxhNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Allchacaj runa aywarcur, mayur Israel runacunata willaycuran: «Jesús allchacächimasha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chaymi mayur Israel runacuna Jesústa chiquir jatiparan: «Diyawardaćhu allchacächir arushanpita imamanpis ćhayanman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesúsmi ichanga chapacuran: «Nuwapis, Papänïpis mana jamaräcushächu. Chaymi diyawarda captinpis, Tayta Diosninchi-ima runacunata yanapaycäshaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chaura mayur Israel runacuna Jesústa wañurachiyta munaran: «Diyawarda junajćhu cumllu runata allchacächisha. Jananmanpis: ‹Tayta Diosninchipa Wawan caycä› nir quiquin Tayta Diosninchiwan tincuchicuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chaura Jesús niran: «Sumaj tantiyacunquiman. Tayta Diosninchipa Wawan car, Papänïpa shungun munashallanta rurä. Papänï shacyächimashallanta, ricacushalläta imatapis rurä. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tayta Diosninchi shungunman tincuptï, llaquipäman. Shungun munashanta musyachiman. Mana cumllu runallatachu allchacächishaj. Manchäga mana ricashayquicunata ruraptï, tantiyacuyta mana atipanquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tayta Diosninchi munayniyujmi wañushcunata cawarachinanpaj. Nuwapis, Wawan cashpä munayniyuj cä shungüman tincujcunata cawachinäpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Llapan runa Tayta Diosninchipa maquinćhu cawan. Cananga wañuyman ćhayachinäpäpis, cawachinäpäpis maquïman llapanta ćhurasha. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tayta Diosninchi munan quiquinta manchapacushan-jina nuwatapis manchapacamänanta. Quiquinmi caćhamasha. Chaymi pipis nuwata mana manchapacamar, Tayta Diosninchitapis mana manchapacunchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Sumaj tantiyacunquiman. Shimïta wiyajcuna Tayta Diosninchi caćhamashanta ćhasquicur, mana ushyacaj cawayta tarishana. Tayta Diosninchi imaycamanpis cawachinga. Juchantapis mana jurgapanganachu wañuyman ćhayachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Canan tantiyacunquiman. Tayta Diosninchita mana wiyacujcuna wañush-yupay caycan. Shimïta wiyar ćhasquicamajcunatam ichanga Tayta Diosninchipa Wawan car, imaycamanpis cawachishaj. Cawachinä wichan ćhayamushana. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tayta Diosninchi cawachicujmi. Nuwapis Wawan car, cawachicuj cä. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Caćhan captï, llapan runata maquïman ćhurasha cawachinäpäpis, wañuyman jitarpunäpäpis. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ama mancharinquichu. Imay junajlla wañushcunapis shimïta wiyanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pamparashanpita cawarimunga. Tayta Diosninchipa shungun munashanta rurajcuna maquinćhu imaycamanpis cawanga. Juchallaćhu arujcunam ichanga cawarimurpis, imay-imaypis ñacayllaman ćhayanga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Nuwa mana shungü munashallantachu rurä; manchäga Tayta Diosninchipa shungun munashanta. Quiquinmi caćhamasha. Paypa shiminta ćharcur, waquin runata mana ushyacaj cawayta tarichishaj. Waquintana ñacayman jitarpushaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tayta Diosninchi caćhamashanta mana shimilläpitachu rimä. Ishcay tistïgu caycaptinraj, ćhasquicamanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Caćhan cashäta quiquin Tayta Diosninchipis musyachicuycan. Payga llullacuyta mana yaćhanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Pï cashätapis musyanayquipaj Ushyachicuj Juanmanraj caćhacamushcanqui, ¿au? Payga rasullanta nuwapita willashcashunqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Rasunpa Tayta Diosninchipa caćhan caycä. Rasunpa cashäta musyachicunäpaj tistïguta mana ashïchu. Ima captinpis, Tayta Diosninchi washäshunayquipäpis, maquinćhu cawanayquipäpis Juan willapäcushanta yarpaycächij. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ushyachicuj Juan achqui achicyashan-jina Tayta Diosninchipa shiminta willacur, shamunäta musyachicuran. Paywan tincur, jatunpa cushicupärishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tayta Diosninchi caćhamashanta mana Ushyachicuj Juanllachu musyachicun; manchä quiquin Tayta Diosninchipis musyachicuycan. Chaymi camacächiyninpa jishyaćhucunata allchacaycächï. Supaycunatapis jarguycä. Chayta ruranäpaj caćhamasha. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Caćhan cashäta quiquin Tayta Diosninchi musyachicusha. Jamcunam ichanga shiminta mana wiyashcanquichu. Quiquinwan mana ricanacushcanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Caćhamashanta mana ćhasquicuptiqui, shiminpis shunguyquiman mana ćhayanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Jamcuna mana ushyacaj cawayta yarpar, Tayta Diosninchipa shiminta sumaj liguinqui. Paypa shimin sumaj nuwapita willacun. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chaypis mana ushyacaj cawayta tarinayquipaj mana wiyacamanquichu. Manchä wasguircaycämanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Runacunapa ricay ñawinćhu mana alli caytachu ashiycä. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jamcunata musyapä. Mana llapan shunguyquiwanchu Tayta Diosninchita wiyacuycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Papänïpa Wawanmi caycä. Paypita shamushcä. Jamcunam ichanga mana ćhasquicamanquichu. Juc runa shungun yarpashanta rimaptinmi ichanga, juclla ćhasquicärinqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Quiquiqui-puralla alli ricanacuyta ashinqui. Tayta Diosninchiwan alli ricanacuytam ichanga imasi mana jucunquichu. Imasi mana jucurga, paypa shungun munashannuychu mana cawaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Chaypis mana nuwachu Tayta Diosninchipa ñaupanćhu juchayquita jurgapushayqui; manchä quiquin Moisésmi. Jamcuna: ‹Moiséspa shiminta llapanta ćharcushcä. Chaymi Tayta Diosninchi alli ñawinwan ricamanga› nirpis, mana llap-llapantachu ćharcushcanqui. Chaymi payga juchayquita jurgapushunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moiséspa shimin sumaj nuwapita riman. Chaymi Moiséspa shiminta ćhasquiycar, nuwamanpis yupachicamanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moiséspa shiminta mana ćhasquicur, ¿imanuyparaj shimïman yupachicunquiman?» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chaypita Galilea püsuta Jesús chimparan. Galilea püsuta ricsij: «Tiberíades püsu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tayta Diosninchi camacächiyninpa jishyaćhucunata allchacächiptin, achcaj runa Jesústa jatirpararan. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Paymi ichanga purïshijnincunallawan pataman jamaj aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chay wichan Israel runacunapa Pascua fiestan ćhayaycämuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chaymi achcaj runa ćhayajta ricar, Jesús niran: «Felipe, ¿maypitaraj tantata rantimushun achcaj runapaj?» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Shungunta musyapayta munar, yarparan: «¿Mä, imaningash Felipe?» nir. Quiquinmi ichanga imata ruranantapis musyaranna. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chaura tapuptin, Felipe niran: «Ichic-ichicllatapis jarananchipaj ishcay paćhac (200) jurnalpa ćhaninwanräćhi tantata rantish aypanga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Simón Pedrupa wauguin Andrésna niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Juc wamra pichga sibäda tantatawan ishcay piscädullata charaycan. Chayllaga llapan runapaj mana aypangachu.» Andréspis Jesústa purïshiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesúsna niran: «Llapan runata jamachiy.» Chaura runacuna pashpallaman jamacuran. Yupaptin, ullgulla pichga waranga-ima (5,000) caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chaura Jesús tantata aptacurcur, niran: «Taytallau Tayta, ima allish tarichillämashcanqui» nir. Jinarcur tantatapis, piscädutatapis llapan runata aypuran. Runacunana puchupacushancaman micuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Runacuna puchupacushancaman micucurcuptin, purïshijnincunata Jesús niran: «Puchupacushanta shuntay. Ama usuchishunchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pichga sibäda tanta puchupacushanta shuntaptin, ćhunca ishcaywan (12) canista juntataraj shuntaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pichga tantata chay-chicajpaj aypächishanta ricacuycur, runacuna cushicuran: «Payga Tayta Diosninchipa willacujnin canga. Ricarimunanta Moisés musyachicuran» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chaynuy nir mayur mandaj cananpaj shuyninpa ćhurayta munaran. Chayta musyar, Jesús quiquillan wichaypa witicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chacas-chacasna Jesúspa purïshijnincuna püsuman cutiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesúsmi ichanga mana ćhayaranrächu. Chaypis purïshijnincuna bütiman jigarcur, chacashana Cafarnaún marcapa llucshicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yacu püsu wayra pücaptin, büchiypa-büchiycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Juc lïwata aywarcaycashanćhüna Jesús yacu jananpa taripaycajta ricaran. Chaymi llapan manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesúsmi ichanga niran: «Ama manchacamaychu. Quiquïmi caycä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chaura bütiman jigachiyta munaran. Niycaptillan, büti Cafarnaún marcaman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Warannin tuta püsu cantullanćhu pachacujcuna parlanacuran: «Jucnayllataj büti caran, ¿au? Chay bütiwan Jesús mana aywashachu. Purïshijnincunalla chimparan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chaypita ishcay-quimsa büticuna Tiberíades marcapita ćhayaran. Jesús tantata achcajpaj aypächishan quinranćhu ićhicaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chaura Jesúspis, purïshijnincunapis mana ćhayaptin, Cafarnaún marcaman ashij aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tarir, Jesústa tapuran: «Yaćhaj Tayta, ¿imaytaj shamushcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesúsna niran: «Sumaj tantiyacunquiman. Mana Tayta Diosninchipa maquinćhu cawashäta tantiyashpayquichu ashircaycämanqui; manchäga tanta-raycullarmi. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Paćhallayquita ama ashinquimanchu. Manchäga mana ushyacaj cawayta tarinayquipaj shimïta wiyacunquiman. Tayta Diosninchi alli ñawinpa ricamar, caćhamasha. Mana ushyacaypa cawachinäpaj pitapis maquïman ćhurasha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chaura runacuna tapuran: «Tayta, ¿imatataj ruräman Tayta Diosninchipa shungun munashanta ruranäpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesúsna niran: «Tayta Diosninchi caćhamashanta ćhasquicunayquita munan.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chaura tapuran: «Tayta Diosninchi caćhamushushayquita auninäpaj, munayniyuj cayniquitaraj mä, musyachicuy. Tayta Diosninchi camacächiyninpa mä, imatapis ruray. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay auquillunchicuna chaqui pacha quinranćhu manäta micuran. Moisés isquirbirashanćhüpis nin: ‹Tayta Diosninchi ricarachishan tantata micuran.› » ");
INSERT INTO qxhNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chaura Jesús niran: «Sumaj tantiyacunquiman. Mana Moiséschu janaj pacha tantata shicwachimusha; manchäga quiquin Papänï. Paymi cawachicuj tantata tarichishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chay tantata janaj pachapita caćhamusha llapan runata cawachinanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chaura runacuna niran: «Chay tantata waran-waran jaraycallämay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesúsna niran: «Cawachicuj tanta caycä. Tayta Diosninchipa caćhan cashäta ćhasquicur, mana imaypis yarganquipächu. Yupachicamar, mana imaypis yacunanquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jamcuna ricsimanqui. Tayta Diosninchi caćhamashantam ichanga mana auninquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Alli ricashancunatam Tayta Diosninchi maquïćhu cawachinga. Pipis ćhasquicamaptin, maquïćhu charäshaj. Mana wasguipäshächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tayta Diosninchi caćhamasha mana quiquï yarpashäta ruranäpächu; manchäga quiquinpa shungun munashanta ruranäpaj. Chaypämi janaj pachapita shamushcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tayta Diosninchi munashanta ćharcunä camacan. Chaymi pipis maquïćhu cawar, mana jishpipämanmanchu. Manchäga ushyacay junajćhu llapanta cawarachimushaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Llapan runa mana ushyacaj cawayta tarinanta Papänï munan. Chaymi pipis musyapämar yupachicamarga, mana ushyacaj cawayta tarin. Ushyacay junajćhüpis Tayta Diosninchipa Wawan cashpä yupachicamajcunata cawarachimushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tincuchiypa rimar: «Tayta Diosninchi caćhamashan tanta caycä» niptin, Israel runacuna ullgucuycuran. Chaymi niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","«Payga Josépa wamran Jesúslla. Maman-taytan pï cashantapis ricsinchi. ¿Imanirtaj: ‹Janaj pachapita shamushcä› niycämanchi?» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chaura Jesús niran: «Ama jamurpämaychu. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tayta Diosninchi caćhamasha. Mana camacächiptin, pipis mana nuwaman yupachicungachu. Yupachicamajcunatam ichanga ushyacay junaj cawarachishaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Unay willacujcunapa shiminpis nin: ‹Tayta Diosninchi llapan runata tantiyachinga.› Chaymi Tayta Diosninchipa shiminta wiyar shungunman ćhayaptin, nuwatapis ćhasquicaman. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mana pipis Tayta Diosninchita ricashachu. Paypita shamush carmi ichanga Tayta Diosninchiwan ricsinacü. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sumaj tantiyacunquiman. Pipis nuwaman yupachicur, mana ushyacaj cawayta tarishana. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Chaypitam nishcä: ‹Nuwa cawachicuj tanta caycä.› ");
INSERT INTO qxhNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Unay auquilluyquicuna chaqui pacha quinranćhu manäta micurpis, wañuyta tariran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Janaj pachapita shamuj tantata micujcunam ichanga mana ushyacaj cawayta tarin. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuwa cawachicuj tanta caycä. Janaj pachapita Tayta Diosninchi caćhamasha. Cay tantata micujcuna mana ushyacaj cawayta taringa. Tantapita rimarga, quiquïpaj rimaycä. Llapan runata cawachinä-raycur wañuyman ćhayashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chaura Israel runacuna tincupänacuran: «¿Tantata micushanchi-jina quiquintaräćhi micushun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesúsna niran: «Sumaj tantiyacunquiman. Tayta Diosninchi caćhamasha. Quiquïta mana micur, yawarnïta mana upur, wañush-yupay carcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Quiquïta micur, yawarnïta upur, Tayta Diosninchipa maquinćhu imaycamanpis cawarcaycanqui. Ushyacay junajćhüpis cawarachimushayqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quiquïmi cawachicuj micuy caycä. Yawarnïpis cawachicuj yacu caycan. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Quiquïta micujcuna, yawarnïta upujcuna shungüwan tincun. Paycunawan alli ricanacü. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tayta Diosninchi cawachicujmi. Payga caćhamasha. Paypita cawaycä. Chaymi ćhasquicamajcunata quiquïta micuptin, cawachishaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mä, sumaj tantiyacuy. Janaj pachapita Tayta Diosninchi caćhamasha. Chaymi: ‹Cawachicuj tanta caycä› nï. Unay auquilluyquicuna manäta micursi, wañuyman ćhayaran. Ćhasquicamajcunam ichanga mana ushyacaj cawayta taringa.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Cafarnaún marcapi shuntacäna wasićhu Jesús llapantapis willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chaura Jesúspa shiminta wiyar, waquin jatirajnincuna parlanacuran: «Jesús imatash rimacullanpis. Mana tantiyanchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jamurpashanta musyar, Jesús niran: «¿Rimashä nanäshunquichu? ");
INSERT INTO qxhNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tayta Diosninchi caćhamasha. Janaj pachaman cuticuptï, ¿imaninquimanraj? ");
INSERT INTO qxhNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tayta Diosninchi Espíritu Santuwan cawachimanchi; mana runa-masinchichu. Cawachicuj Tayta Diosninchipa shiminta willapaycaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Chaypis waquinniqui mana aunimanquichu.» Pï-pï ćhasquicunantapis, pï wañuyman jitarpunantapis Jesús mayna musyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chaymi niran: «Tayta Diosninchi camacächiptinraj, pipis yupachicamanga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chaura achcaj runa wasinman-caman cuticäriran. Jesústa mana purïshirannachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Achcaj runa aywacuptin, ćhunca ishcaywan (12) purïshijnincunatapis niran: «Munar, jamcunapis cuticunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedruna niran: «Tayta, nuwacuna jamllata wiyacushayqui. Imaycamanpis cawanäpaj willapämashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jamllaman yupachicü. Tayta Diosninchi caćhamushcashunqui. Acracushan Washäcujninmi canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chaura Jesús niran: «Purïshimänayquipaj ćhunca ishcaywanta acracushcaj. Chaypis jucniqui supaymi canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","«Supaymi canqui» nirga, Judaspaj rimaycaran. Paymi Simón Iscariotipa wamran caran. Judasga Jesústa wañuyman jitarpuran purïshinanpaj acracush caycaptinsi. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaypita-pacha Galilea quinrallanćhu marcan-marcan Jesús puriran. Mayur Israel runacuna wañuchinanpaj ashiycaptin, Judea quinranman mana aywaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Tacma ruray fiesta ćhayaycämuptin, wauguincuna Jesústa niran: «Judea quinran Jerusalén marcaman fiestata ruraj aywanquiman. Tayta Diosninchipa maquinćhu purir, ima-imata rurashayquitapis llapan jatiräshujniquicuna ricanman. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Llapan runa ricsimänanchita munar, llapan ricay imatapis ruranchi. Runa captiqui, jamtapis llapan runa ricashunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Wauguincuna chaynuy niran Jesústa Tayta Diosninchi caćhamushanta mana ćhasquicur. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesúsna niran: «Mana aywashärächu. Tayta Diosninchi caćhamashanta mana musyachicümanrächu. Jamcunam ichanga juclla aywanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pipis mana chiquishunquichu. Jucha aparicushanta jurgapaptïmi ichanga, chiquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jamcunalla fiestaman ayway. Aywanä mana camacanrächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chaynuy nir Galilea quinranpita Jesús mana llucshiranrächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wauguincuna fiestaman aywacuriptin, Jesúspis pacayllapa aywaran. Pitapis mana willaparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiestaćhu mayur Israel runacuna Jesústa ashiycaran: «¿Mayćhüraj chay runa jatiraycan?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pampa runacunapis Jesús-janan tincupänacurcaycaran. Waquin runa Jesúspaj niran: «Pay alli runa.» Waquinna niran: «Mana. Runacunata pantaycächin.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ichanga mayur Israel runacunata manchacushpan pacayllapa parlanacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pullan fiestaćhu caycaptinna, Tayta Diosninchipa wasinman Jesús aywaran. Willapäcuyta jallaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yarpay-sapa cashanta tantiyar, mayur runacuna manchariran: «Cay runa mana istudiash caycarćhi, llapanta musyan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesúsna niran: «Tayta Diosninchi caćhamasha. Paypa shiminta willapäcuycä; mana shungü munashallantachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wiyacujcuna Tayta Diosninchipa shiminta willacushäta tantiyacunga. Mana umä yarpashallantachu rimaycä. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Shungun munashallanta willapäcujcuna quiquillan alli-tucun. Nuwam ichanga mana llullacüchu. Manchä Tayta Diosninchi yarpashallanta willapäcuycä. Payllata alliman ćhurashun. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Taytacuna, Moiséspa shiminta ćhasquicushcanqui, ¿au? Ćhasquicush carga, ¿imanirtaj mana ćharcunquichu? ¿Imapitataj wañuchimayta ashiycanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chaura runacuna japariran: «¿Piraj wañuchiyta munaycäshunqui? Supay pucllacushcashunqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesúsna niran: «¿Diyawardaćhu jishyaćhuta allchacächishalläpitachu wichaypa-uraypa rimarcaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mä, tantiyacushun. Moiséspa shiminćhu nin: ‹Ullgu wamra yuriptin, pusaj junajyujllata jïrunqui.› Chaymi jïrucuy junaj ćhayamuptin diyawarda captinsi, jïruyćhu aruycanqui. Ullgu wamrata jïrunanpaj Tayta Diosninchi auquillunchi Abrahamta, Isaacta, Jacobta willaparan. Jipataraj Moisés yuriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moiséspa shiminta ćharcunayqui-cashan diyawardaćhüpis jïruyćhu aruycar, ¿imanirtaj diyawardaćhu jishyaćhu runata allchacächishäpita chiquircaycämanqui? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Imatapis sumaj mana tantiyar, ama rimacunquimanchu. Sumajraj tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Waquin Jerusalén runacuna Jesúspaj parlaran: «Mayur runacuna tagay runata wañuchiyta munarcaycan, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Canan llapanpa ñaupanćhu willapäcuptinsi, mana rimapanchu, ¿au? ¿Mayur runacunapis ćhasquicushachuraj: ‹Tayta Diosninchi caćhamushan Washäcuj› nir? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Payga mana Washäcuj canmanchu; manchäga marca-masillanchi. Washäcuj shamuptinmi ichanga, maypita ricarimunantapis mana musyashunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chay wichan Tayta Diosninchipa wasinćhu Jesús willapäcuycaran. Chaymi runacuna wasguipashanta wiyar, wiyächipaypa niran: «May marcaćhu yurishätapis, pï cashätapis musyanqui. Ichanga mana shungü munashanta rurarchu puriycä. Shiminta ćharcushpan Tayta Diosninchi caćhamasha. Jamcuna Tayta Diosninchi pï cashantapis mana musyanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nuwam ichanga ricsinacü. Paypita cawä. Quiquin caćhamasha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chaynuy niptin, runacuna ullgucäcuran. Rïsu charicurcuyta munaran. Tayta Diosninchim ichanga mana camacächiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Waquin runacuna Jesúspa shiminta ćhasquicur, niran: «¿Jesús rurashanta lluta runa rurangachuraj? Mana. Payga Washäcujćhi canga. Tucuyta rurar, Tayta Diosninchipa maquinćhu purishanta musyachicun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Runacuna parlanacushanta mayar, fariseucunapis, mayur cüracunapis ullgucurcuran. Tayta Diosninchipa wasinta täpajcunata niran: «Jesústa rïsu chariy.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesúsna niran: «Unayllaraj juyapärishun. Jinarcur caćhacamajman cuticushaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ashimashpayquipis mana tarimanquipächu. Mayman aywashämanpis mana ćhayamunquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chaura mayur runacuna tapunacuran: «Mana tarinanchipaj, ¿mayparaj aywacunga? ¿Jucläćhu tiyaj marca-masinchicunamanchuraj willapaj aywanga? ¿Jäpa runacunatachuraj willapämunga? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imanirtaj nimanchi: ‹Ashimashpayquipis mana tarimanquipächu. Mayman aywashämanpis mana ćhayamunquipächu› nir?» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tacma ruray fiestaćhu ushyanan junajraj jatun diya caran. Chay junaj llapan wiyananpaj tincuchiypa Jesús niran: «Pipis yacunar, mañacamächun mishquilla upunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tayta Diosninchipa shiminpis nin: ‹Nuwaman yupachicamajcuna mana yacunangachu. Nuwapita upuptin, quiquincunapita cawachicuj yacu pashtamunga.› » ");
INSERT INTO qxhNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaynuy tantiyachicur, tincuchiyllapa Espíritu Santupita rimaycaran. Ichanga Espíritu Santuta mana caćhamuranrächu. Jesús wañushanpita cawarcamur janaj pachaman cuticurraj, Espíritu Santuta caćhamunan caran. Caćhamuptinraj, Jesúsman yupachicujcunata Espíritu Santu maquinćhu purichinga. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesúspa shiminta wiyar, waquin runa niran: «Jesús Tayta Diosninchipa willacujnin canga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquinna niran: «Payga Washäcuj canga.» Waquinnam ichanga niran: «Galilea marcapita Washäcujga mana yurimunmanchu, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tayta Diosninchipa shiminpis nin: ‹Washäcujga unay mandaj Davidpa yawar-masillanpita yuringa. Paypa marcan Belén marca›.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Runacuna Jesús-janan wichaypa-uraypa rimaran. Mayganinpis mana tantiyanacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Chaymi waquin runa Jesústa chariyta munaran. Ichanga pipis mana yataparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tayta Diosninchipa wasinta täpajcuna cutiptin, fariseucunawan mayur cüracuna tapuran: «¿Imanirtaj Jesústa mana charishcanquichu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chaura täpajcuna niran: «Payga rasunpa Tayta Diosninchipa shiminta willapäcun. Payman pipis mana tincunchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseucunana niran: «¿Jamcunapis Jesúspa shiminta ćhasquicurcushcanquićhi? ");
INSERT INTO qxhNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nuwacunam ichanga mayur cüra cashpä, fariseu cashpä imanillarpis mana ćhasquicushächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Upa runacunalla paypa shiminta ćhasquicun. Moiséspa shiminta pampaman ćhurashanpita paycunata Tayta Diosninchi ñacayman ćhayachinga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chaura chacaypa Jesúsman aywaj Nicodemo mayur Israel runa carpis, niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Moiséspa shimin nin: ‹Pitapis ñacachinayquipaj juchantaraj sumaj ashinqui.› Chaymi sumajraj tapupäshun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Waquin fariseucunana niran: «¿Jampis Galilea marcapita Washäcuj ricarimunantachu riguinqui? Tayta Diosninchipa shiminta mä, sumaj liguiy. Willacujcunapis Galilea marcapita mana ricarimunmanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chaypita llapan runa wasinman-caman cuticäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesúsmi ichanga Ulïbus puntaman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Warannin tuta-tutalla Jerusalén marcaman cutiran. Tayta Diosninchipa wasinćhu achcaj runawan tincur, sumaj willapäcuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Willapaycaptin, Moiséspa shiminta yaćhajcunawan fariseu runacuna juc warmita Jesúsman ćhayachiran. Chay warmita runanta jananpachir, juc runawan cacuycajta tarirunaj. Ćhayarcachir, llapanpa ricay ñawinćhu Jesústa niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«Cay warmita jucwan cacuycajta tarishcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moiséspa shimin nin: ‹Majayuj caycar jucwan cacuptin, sajmaycällar wañuchinqui.› ¿Imaninquitaj jam?» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Paycuna achäquita ashillar tapuran. Chaymi Jesús pachaman uysucuycur, dïdunwan isquirbiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaparir-yaparir tapuptin, ićhircur niran: «Mayganiquipis juchaynaj cashpayqui mä, sajmay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chaynuy nir, yapay uysucuycuran. Pachaman isquirbiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chaura Jesúspa shiminta wiyar, mayur runacuna aywacuran. Jipanta müsucunapis llucshicuran. Quiquillantana warmita jaguiycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ićhircur, warmitana Jesús niran: «Juchayquita ashijcuna aywacushana.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Warmina niran: «Au. Aywacusha.» Jesúsna niran: «Nuwapis juchayquita mana ashipäshayquinachu. Canan wasiquiman cuticuy. Ichanga juchata ama aparicunquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Juc cuti llapan runata Jesús niran: «Cay pachapa achquinmi cä. Chaymi Tayta Diosninchipa shungun yarpashanta llapan runata musyachicuycä. Shimïta wiyacur, mana chacajćhu-jinachu juchaćhu cawanquipaj; manchäga achquićhu-jina alli cawayta tarinquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseucunana niran: «Alli-tucuycanqui. Yangalla rimaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chaura Jesús niran: «Rimashäta mana ćhasquicuptiquisi, rasullanta rimaycä. Pipa maquinćhu cawashätapis, pï caćhamashätapis musyä; jamcunam ichanga mana. Maypita shamushätapis, mayman cuticushätapis mana musyanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jamcuna ñawiqui ricashallanta: ‹Alli›, ‹Mana alli› ninqui. Pitapis ricapanqui; nuwam ichanga mana. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pitapis: ‹Alli›, ‹Mana alli› niyta munar-imarga, rasun-cajta nishaj. Mana quiquilläpitachu imatapis rurä. Manchäga caćhamaj Papänï yanapäman llapantapis rasun-cajta ricanäpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Jamcunapaj Moisés isquirbishanpis nin: ‹Ishcaj tistïgu ricaptinraj, rasunpa cashan musyacan.› ");
INSERT INTO qxhNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pï cashätapis rasunpa cashan musyacänanpaj quiquïmi niycä. Caćhamaj Papänïpis musyacächin.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chaura tapuran: «Papäniqui, ¿mayćhütaj caycan?» nir. Jesúsna niran: «Jamcuna Papänïwanpis, nuwawanpis mana yaćhänacunquichu. Sumaj ricsinacuycaptinchi, Papänï pï cashantapis musyanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús llapantapis willapäcuycaran Tayta Diosninchipa wasinćhu, cuyachicuycunata jutunan ñaupallanpi. Llapanpa ricay ñawinćhu willapäcuptinsi Tayta Diosninchi mana camacächiptinraj, Jesústa mana chariranrächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jananmanpis Jesús niran: «Tayta Diosninchi shuntacamanga; jamcunatam ichanga mana. Ashimarsi, mana tarimanquipächu. Juchata aparicushayquipita wañuyta tarinquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chaura mayur Israel runacuna niran: «Wañucuriyta yarparćhi: ‹Mana tarimanquipächu› niycan, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesúsna niran: «Jamcuna cay pachaćhu yurish car, shunguyqui munashallanta ruranqui. Nuwam ichanga janaj pachapita shamush car, Tayta Diosninchipa shungun munashallanta rurä. Jamcuna wañucujlla canqui; nuwam ichanga mana. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chaymi nishcaj: ‹Juchayqui aparicushalla wañunqui. Cawachicuj cashäta mana aunirga, wañuyllaman ćhayanquipaj›.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chaura tapuran: «¿Pitaj canqui?» nir. Jesúsna niran: «Pï cashätapis mayna willashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jucha-sapa cashayquipita sumajraj jurgapäman. Jamcunapita rimäman. Shimïta mana ćhasquicuptiquisi, caćhamajpa shiminta wiyashpä llapantapis rasullanta rimä. Payga imatapis rasullanta rimaptin, llapan runata willapä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tayta Diosninchipa maquinćhu cawashanta Jesús tantiyachiptinsi, mayur runacuna mana tantiyacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chaura Jesús niran: «Jugarachimaptinraj, Papänï caćhamashanta tantiyacunquipaj. Chayraj Washäcuj cashäta musyanquipaj. Papänï tantiyachimashallanta rimashäta, shungü munashallanta imatapis mana rimashäta tantiyacunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Paypa maquinćhu cawä. Sumaj ricamar, mana caćharimanchu. Nuwapis shungun munashallanta imatapis rurä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chaynuy niptin, achcaj runa Jesústa ćhasquicuran: «Taytallau tayta, Washäcujmi canqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Shiminta ćhasquicuj Israelcunata Jesús niran: «Shimïta wiyacur, shungüman tincunqui. Maquïćhümi purinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ćhasquicamaptiqui, jucpa maquinpita jurgushayqui Tayta Diosninchipa maquillanćhu purinayquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chaura Jesústa ticrapuran: «Auquillunchi Abrahamta quiquin Tayta Diosninchi wamrachacuran. Abrahampa willcan carcaycä; mana jucpa uywayninchu. ¿Imanirtaj: ‹Jucpa maquinpita jurgushayqui› nimanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesúsna niran: «Sumaj tantiyacunquiman. Pipis juchallaćhu arur, uyway jucpa maquinćhu cawashan-jina juchacachicuj supaypa maquinćhu cawan. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Uywayga mana wasiyujpa wamranchu. Wamranmi ichanga taytanpa wasinpita imaypis mana llucshinchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chaymi Tayta Diosninchipa Wawan cashpä washaptij, supaypa maquinćhu mana cawanquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahampa willcan cashayquita musyä. Chaypis shimïta mana ćhasquicunquichu. Manchäga wañuchimayta munarcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Papänï yaćhachimashallanta willapaycaj. Jamcunapis taytayqui yaćhachishushayquillata rurarcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chaura niran: «Abrahampa willcan carcaycä. Payga taytämi.» Jesúsna niran: «Rasuypa Abrahampa willcan cashpayqui Abraham-jina cawanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Jamcunam ichanga Tayta Diosninchipa shiminta willapaptijsi, wañuchimayta ashircaycanqui. Abraham mana imaypis wañuchicuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Taytayquiga jucmi. Taytayqui rurashan-jina rurarcaycanqui.» Chaura paycuna niran: «Mana jucpa churinchu cä. Tayta Diosninchipa wawanmi carcaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesúsna niran: «Tayta Diosninchipa wawan caycar, nuwatapis alli ñawiquipa ricamanquiman. Paymi caćhamasha. Mana shungü munashanta rurarchu puriycä. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Chaypis upa-tucur, shimïta mana ćhasquicunquichu. Tantiyacuyta mana munar, willapashäta mana wiyacunquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Llapantapis ruranqui supaypa maquinćhu cawar. Paymi taytayqui. Paypa shungun munashallanta imatapis rurarcaycanqui. Taytayqui supayga unaypita-pacha wañuchicuj. Llullacuj. Rasun-caj rimaytapis mana junchu. Llullacuyllata shungun yarpan. Llulla cashpan runacunatapis llullacachin. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Chaymi shimïta mana ćhasquicunquichu. Rasunpa Tayta Diosninchipa shiminta willapaycaj. Paypa shimin rasullanta riman. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ima juchatapis mana aparicushcächu. Munar, mä, mayganiquipis ashipämanquiman. Tayta Diosninchipa shiminta willacuptïsi, mana yupachicamanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tayta Diosninchipa wawancuna shiminta cushish wiyacun. Jamcunam ichanga jucpa churin cashpayqui imasi mana jucunquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chaura chaynuy niptin, Israel runacuna Jesústa ashllir ushyaran: «Samaria runapa churin canqui. Supay pucllacushcashunqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesúsna niran: «Mana pucllacamashachu. Manchäga Papänïta alliman ćhuraycä. Jamcunam ichanga pampaman ćhuraycämanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pitapis mana mañacüchu: ‹Alliman ćhuramay› nir. Tayta Diosninchim ichanga alliman ćhuramänayquita munan. Paymi ima-imata rurashanchitapis jurgapämäshun. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sumaj tantiyacunquiman. Shimïta wiyacujcuna wañuyman mana imaypis ćhayangachu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chaura runacuna niran: «Supay pucllacushcashunqui, ¿au? Auquillunchi Abrahampis, unay willacujcunapis llapanmi wañucuran. Chaypis niycanqui: ‹Shimïta wiyacujcuna wañuyman mana imaypis ćhayangachu.› ");
INSERT INTO qxhNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Auquillunchi Abrahampis, unay willacujcunapis Tayta Diosninchipa shiminta sumaj-sumaj wiyacuran. Chaypis wañuyta tariran. Paycunata apärinayquipaj, ¿pitaj canqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","Jesúsna niran: «Quiquillä alli-tucuptï, pipis mana alli ricamanmanchu. Papänïmi ichanga alliman ćhuraycäman. Paypa maquinćhu cawä. Jamcunam ichanga: ‹Tayta Diosninchita manchapacü› nirpis, mana wiyacunquichu. Nuwam ichanga wiyacü. ‹Wiyacü› nir rasun-cajta rimaycä. Mana jamcuna-jinachu llullacuycä. ");
INSERT INTO qxhNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Auquilluyqui Abraham shamunäta musyar, jatunpa cushicuran. Ricamar, sumaj-sumaj cushicuran.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chaura runacuna niran: «Pichga ćhunca (50) watatapis mana ushyanquirächu. ¿Imanuypataj auquillunchi Abrahamta ricsinquiman caran?» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesúsna niran: «Sumaj tantiyacunquiman. Abraham manaraj yuriptin, cawaycarä. Cawajmi cä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","«Cawajmi cä» niptin, runacuna sajmariyta munaran. Chaypis achcaj runapa ćhaupinman yaycur, Jesús illaricäcuran. Tayta Diosninchipa wasinpita aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Aywacuycashanćhu yuriyninpita-pacha japra runata Jesús tariran. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chaymi purïshijnincuna tapuran: «Tayta Jesús, ¿imanirtaj cay runa japra yurisha? ¿Maman-taytan jucha-sapa cashanpitachu, quiquinpa juchanpitachu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesúsna niran: «Mana quiquinpa juchanpitachu, mana maman-taytanpa juchanpitachu; manchäga Tayta Diosninchi munayniyuj cashanta runacuna musyananpämi. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cay pachaćhu cashäcaman caćhamaj Tayta Diosninchipa shungun munashanta rurashun. Aywacuptï, ima ruraytapis mana camäpacunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cay pachaćhu cashäcaman achqui achicyashan-jina Tayta Diosninchipa shiminta willacuycäshaj. Shungun munashantapis ruraycäshaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chaynuy nir Jesús tuwayllanwan mituta ruraran. Nircur japrapa ñawinta pićhuparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pićhuparcur, niran: «Siloé püsuman aywaycur, mayllacuy.» Rimayninćhu: «Siloé» ninan: «Caćhamusha» ninanmi. Japra runana änir mayllacuran. Ñawinta mayllacurir, ricaycarna cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chaura bisïnuncuna, ricsinacushancuna niran: «Tagay runa mañapacuj japra, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquin niran: «Au, paymi.» Waquinna niran: «Mana paychu. Ichanga pay-nirajmi.» Quiquinna niran: «Chay japra carä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chaura tapuran: «¿Imanuypataj ñawiqui quićhacasha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Allchacaj runana niran: «Mituwan ñawïta Jesús pićhupamasha. Jinarcur Siloé püsućhu ñawïta mayllacunäpaj caćhamasha. Mayllacushallä ñawï quićhacäcusha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chaura tapuran: «¿Mayćhütaj chay runa caycan?» nir. Tapuptin, niran: «Mana musyächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Mituta rurarcur japra runata Jesús allchacächishan junajga diyawarda caran. Chaymi chay runata fariseucunaman aparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseucunana allchacaj runata tapuran imanuypa ñawin quićhacashantapis. Tapuptin, niran: «Ñawïta mituwan pićhupamasha. Mayllacuriptï, ricarä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseucunana niran: «Chay allchacächij runa Tayta Diosninchita mana manchapacunchu. Diyawardaćhu allchacächir, juchaćhu aruycan.» Waquincunana niran: «Jucha-sapa caycar, ¿imanaypataj jishyaćhuta allchacächinman? Tayta Diosninchi jucha-sapata mana yanapanmanchu.» Chaynuy nir quiquin-pura apaycaćhänacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chaura yapay tapuran: «Ñawiquita quićhaj runapaj, ¿imatataj yarpanqui?» Tapuptin, niran: «Tayta Diosninchipa willacujninmi canga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mayur Israel runacunam ichanga mana riguiranchu: «Llullacuycanqui. Mana japrachu cashcanqui» nir. Chaymi allchacaj runapa maman-taytanta jayarcachir, tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","«¿Cay runa rasunpachu wamrayqui? ¿Rasunpachu japra yuriran? ¿Imanuypataj allchacasha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chaura maman-taytan niran: «Au, wamrämi. Rasunpa yurishanpita-pacha japra caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ichanga imanuypa allchacashantapis, pï allchacächishantapis mana musyächu. Payga auquisna. Sumaj musyayta munar, quiquinta tapunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","«Payga auquisna. Sumaj musyayta munar, quiquinta tapunquiman» niran mayur runacunata manchacushpan. Mayur runacuna mayna parlanacuran: «Pipis Jesústa: ‹Washäcujninchi› nir ćhasquicuptin, shuntacäna wasipita jargushun. Ama ricalläshunpishchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaypis mayur runacuna ñawin quićhacaj runata yapay tapuran: «Tayta Diosninchi ricaycämanchim. Canan rasullanta willamay. Chay Jesús jucha-sapa cashanta musyä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chaura allchacaj runa niran: «Jucha-sapa cashantapis, mana cashantapis mana musyächu. Japra captïpis, ñawï quićhacashallanta musyä. Ricaycäna.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chaypis yapayraj tapuran: «¿Imatataj rurasha ñawiqui quićhacänanpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chaura niran: «Mayna willashcaj. Willaptijpis, mana riguinquichu. ¿Imanirtaj yaparir-yaparir tapupaycämanqui? ¿Jamcunapis Jesústachu jaticurcuyta munarcaycanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chaura ashllir mayur runacuna niran: «Jucha-sapa runaman yupachicunqui. Jatiraycanquipis. Nuwacunam ichanga Moiséspa shimillanman yupachicü. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Payga Tayta Diosninchipa shiminta willacuran. Jesústam ichanga mana ricsillächu. Pipa wawanraj cacullanpis.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Allchacaj runana niran: «¿Imataraj rimacunquipis? Pipa wawan cashanta mana musyaptiquisi, paymi ñawïta quićhasha. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Juchaćhu arujcunata Tayta Diosninchi mana yanapashanta musyanchi. Wiyacujcunallatam, manchapacujcunallatam yanapan. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yuriyninpita-pacha japrata allchacächishanta imaypis mana wiyashcanchichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chaymi Tayta Diosninchipa Wawan cashanta musyä. Manchäga imatapis mana ruranmanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chaura mayur runacuna niran: «Yurishayquipita-pacha marca-pingay caycar, ¿piraj canqui piñapämänayquipaj?» Shuntacäna wasipitapis jarguran: «Ricaytapis mana munallajchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Allchacächishan runata jargushanta Jesúspis mayaran. Chaymi allchacaj runawan tincur, niran: «¿Tayta Diosninchi caćhamushan Washäcujman yupachicunquichu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Allchacaj runana niran: «Au, tayta. Ichanga, ¿pitaj Washäcuj canga?» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesúsna niran: «Washäcujmi cä. Mayna ñawiquitapis quićhashcä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaura Jesúspa ñaupanman jungurpacuycur, alliman ćhuraran: «Jammanmi yupachicü, Tayta» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesúsna niran: «Cay pachaman shamushcä llapan runapa shungunta musyapänäpaj. Tayta Diosninchipa maquinćhu cawananpaj japracunapa ñawinta quićhashaj. Ricajcunapa ñawintam ichanga chapashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesúspa shiminta wiyar, waquin fariseucuna niran: «¿Japraćhi carcaycä?» ");
INSERT INTO qxhNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesúsna niran: «Rasunpa japra caycar, mana juchayujchu canquiman. Ricaycämar mana aunimashayquipitam ichanga, juchayuj carcaycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Chaura Jesús niran: «Sumaj tantiyacunquiman. Suwacunash, asaltanticunash chicuta wacman-cayman jiwirir, uyshaman yaycun. Uysha michijshi ichanga puncunpa yaycun. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Michijpa shiminta chicu täpajpis, uyshacunapis wiyanshi. Llapan uyshantapis jutinpa-caman jayan. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chicupita jurgurir, uyshancunata jaticun. Uyshancunapis michijta ricsir, ñaupallantash aywan. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mana ricsishcunatash ichanga manchacun. Jayaptinpis, jishpirshi aywacärin.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tincuchiypa Jesús willapaptinsi, fariseucuna mana tantiyacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chaymi runata uyshawan tincuchir, Jesús niran: «Sumaj tantiyacunquiman. Uyshapa chicunpa puncun-yupay caycä. Uyshacuna maquïćhu purin. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ñaupata purijcuna michij-tucursi, suwa casha. Asaltanti casha. Chaymi uyshacuna mana wiyashachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nuwaga puncu-yupay caycä. Uyshacuna maquïćhu puriptin, sumaj ricä. Pipis nuwaman yupachicur, Tayta Diosninchipa maquinćhu cawanga. Imapitapis washäshaj. Cawananpaj imatapis mana pishïchishächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwacuna suwacullar, uyshacunata wañuchillar purin. Nuwam ichanga llapaniquita alli cawayta tarichinajpaj shamushcä. Cushi-cushilla cawayta tarichishayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Alli michij caycä. Llaquipäcuj cä. Llaquipäcuj michijga uyshancuna-raycur wañuytapis tarin. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Paytacushan uyshata michijcunam ichanga liyunta ricar, jishpir aywacärin. Quiquinpa uywan mana captin, caćhariycur aywacun. Chaura liyun uyshata apacun. Waquin uyshacuna wacpa-caypa jishpicärin. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Paytacushan michipacujpis jishpir aywacun. Uyshata liyun micuptinsi, mana imasi jucunchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nuwam ichanga alli michij caycä. Uyshäcuna shimïta ricsin. Nuwapis llapanta ricsï. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Chay-jinapis Tayta Diosninchiwan sumaj ricsinacü. Chaymi uyshäcuna-raycur imamanpis ćhayäman. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Uyshäcuna mana juc pachallaćhüchu caycan. Jucläćhüpis caycan. Paycunapis shimïta ricsinga. Imayllaga juc pachallaman llapanta shuntashaj. Nuwalla llapanta michishaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Uyshäcunata wañuy-caway llaquipaptï, Tayta Diosninchi sumaj llaquipäman. Wañuyta tarirsi, cawarishaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mana pipis wañuchimangachu. Manchäga quiquïmi wañuymanpis aywapushaj. Wañuypis, cawaypis maquïćhu caycan. Papänï llapantapis maquïman ćhurasha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chaura chaynuy niptin, Israelcuna yapay quiquin-pura apaycaćhänacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Waquin niran: «¿Imapätaj Jesúspa shiminta wiyashunpis? Supay pucllacusha. Jishyayächisha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waquinna niran: «Mana supaychu rimaycächin. ¿Yuriyninpita-pacha japrata supay allchacächinmanchuraj?» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalén marcaćhu Tayta Diosninchipa wasinpa diyanta fiestata rurashan wichan sumaj jasay caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Paypa wasinćhu «Salomónpa curidurnin» nishan curidurćhu Jesús puriycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Shuntacarcur, Israelcuna tapupäcuran: «¿Imaycamantaj yarpaćhacuyman ćhuramanqui? Tayta Diosninchi caćhamushan Washäcuj caycar, juclla willamay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesúsna niran: «Mayna willashcaj. Willaptijpis, mana ćhasquicunquichu. Papänï camacächiptin, jishyaćhucunata allchacächishäpis, runacunata jarashäpis Washäcuj cashäta musyacaycächin. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jamcunam ichanga Tayta Diosninchita wasguipar, shimïta mana wiyacunquichu. Mana uyshächu canqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Uyshäcunam ichanga shimïta wiyacun. Paycunata ricsïmi. Jatishäpa aywan. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mana ushyacaj cawaytapis tarichï. Ushyacayman imaypis mana ćhayangachu. Maquïpita pipis mana jićhumangachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","Papänïwan juc shungulla cawä. Payga llap-llapanpita mas munayniyujmi. Shimïta wiyacujcunata maquïman ćhurasha ricanäpaj. Maquïćhu cawar, Papänïpa maquinćhüpis cawaycan. Chaymi Papänïpa maquinpita pipis mana jićhungachu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chaynuy niptin, mayur Israel runacuna rumita chariran Jesústa sajmananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesúsna niran: «Papänï camacächiptin, jishyaćhucunata allchacächishäta, supaycunata jargushäta, chay-chicaj runata jarashäta ricashcanqui, ¿au? Cananga, ¿allita rurashäpitachu wañuchimayta munarcaycanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mayur runacunana niran: «Mana allita rurashayquipitachu wañuchishayqui; manchäga Tayta Diosninchita apärishayquipita. Runalla caycar, Tayta Diosninchi-tucuycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesúsna niran: «¿Shiminćhu Tayta Diosninchi manachu nin: ‹Nuwa-jina carcaycanqui›? ");
INSERT INTO qxhNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Unay wichan shiminta ćhasquicuptin, Tayta Diosninchi niran: ‹Nuwa-jina carcaycanqui.› Paypa shiminta pipis juc-nirajman mana rucanmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Quiquinmi acracamasha. Cay pachaman caćhacamasha. Chaymi: ‹Tayta Diosninchipa Wawan caycä› niptï, ama ullgunquimanchu: ‹Tayta Diosninchita apäriycan› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Imata rurashäpis Papänïpa shungunwan mana tincuptinmi ichanga, shimïtapis ama ćhasquicunquimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Shimïta mana aunirpis Papänï camacächiptin, ima-imatapis rurashäta auninquiman. Camacächiyninpa jishyaćhucunatapis allchacächishcä. Supaycunatapis jargushcä. Runacunatapis jarashcä. Chaymi Papänïwan juc shungulla cawashäta tantiyacunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chaura yapay Jesústa chariyta munaran. Chariyta munaptinsi, llucshir aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chaypita Juan ushyachicushan quinranman Jesús cuticuran. Ishcay-quimsa simäna Jordán mayu chimpanćhu juyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Chay-chicaj runa Jesústa ćhayapuran. Paycuna quiquin-puralla ninacuran: «Tayta Diosnillanchi camacächishancunata Ushyachicuj Juan mana ruraranchu. Jesúspaj rimashanmi ichanga llapanpis ćharcucaycan.» ");
INSERT INTO qxhNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaymi achcaj runa Jesústa ćhasquicuran: «Payga Tayta Diosninchi caćhamushan Washäcuj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania marcaćhu Lázaro jutiyuj runa tiyaran. Juyupa jishyaycaran. Panin caran Maríawan Marta. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maríaga Tayta Jesúspa ćhaquinman pirjümita jaycapurir, ajchanwan chaquipush carunaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chaura turin Lázaro juyupa jishyaptin, Maríawan Marta Jesúsman caćhacuran: «Tayta, yaćhänacushayqui Lázaro juyupa jishyaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Caćha willaptin, Jesús niran: «Chay jishya Lázaruta mana wañuchingachu. Manchäga achäquilla canga Tayta Diosninchi munayniyuj cashantapis, nuwa munayniyuj cashätapis runacuna tantiyacunanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesúsga Lázaruwan, Martawan, Maríawan sumaj yaćhänacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chaypis: «Lázaro jishyaycan» nir willaptin, mana aywaranchu. Ishcay junajraj jinallanćhu juyapäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ishcay junajpitaraj purïshijnincunata niran: «Yapay Judea quinranman cutishun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Paycunana niran: «Tayta, janyancunarätaj sajmaypa wañuchiyta munashurayqui. ¿Imamantaj cutishun?» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesúsna niran: «Intipis juyayta achicyan. Achicyaptin junajpa purir, mana tacacunchichu. Chay-jina Tayta Diosninchipa maquinćhu purir, imamanpis mana ćhayashunchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Chacaptinmi ichanga pipis purir, tacacun. Chay-jina shungun munashanta rurar, juchaćhu arujcuna ñacayta taringa. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Canan Judea quinranman aywananchi camacan. Yaćhänacushanchi Lázaro puñucäcusha. Ricchachij aywashun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Purïshijnincunana niran: «Tayta, puñucash caycar, allina riccharamunga, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","«Lázaro puñucäcusha» nir tincuycächiran: «Wañush» ninanta. Purïshijnincunam ichanga rasunpa puñucashallanta tantiyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaymi Jesús niran: «Lázaro wañusha. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jishya wañuycachiptin, ima allish mana ricashcächu. Ima captinpis, aywashun ricaj. Canan munayniyuj cashäta ricar, llapan shunguyquiwan yupachicamanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chaura Tomás niran: «Nuwanchipis aywashun Jesúswan iwal wañunanchipaj.» Tomásta: «Milli» nir ricsiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betania marcaman ćhayaycar, Lázaro ćhuscu junaj pamparaycashanta mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalén marcapita Betania marcacaman pullan lïwalla caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chaymi wañupacush captin, achcaj runa Martatawan Maríata yanagaj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús ćhayaycashanta musyar, María mana llucshiranchu. Martam ichanga tariparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesústa niran: «Juclla shamunquiman caran, Tayta. Turï mana wañunmanchu caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ima captinpis, jamman yupachicü. Ima-imata mañacuptiquisi, Tayta Diosninchi wiyashushayquita musyä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesúsna niran: «Turiqui cawarimunga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martana niran: «Cawarinanta musyä. Ichanga llapan wañushcuna cawarimunan junajćhüraj cawarimunga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesúsna niran: «Nuwaga cawarachicujmi cä. Wañushcunatapis cawarachïmi. Shimïta ćhasquicujcuna wañurpis, cawarimunga. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maquïćhu cawajcunata, ćhasquicamajcunata imaysi mana caćharishächu. ¿Rasunpa yupachicamanquichu?» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chaura Marta niran: «Aumi, Tayta. Tayta Diosninchipa Wawan canqui. Paymi cay pachaman caćhamushcashunqui. Washäcujmi canqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jinarcur ñañan Maríaman cuticur, rinrillanćhu willaran: «Tayta Jesús ćhayamushana. Jayaycäshunqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chaura juclla María aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesúsmi ichanga marcaman manaraj ćhayasharächu. Martawan tincushan pachallaćhüraj caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wasinpita juclla María llucshiptin, yanagajcunapis jipanta aywaran: «Wagajćhi pantyunman aywaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maríana Jesústa tariparcur ñaupanman jungurpacuycur, niran: «Juclla shamunquiman caran, Tayta. Cayćhu caycaptiqui, turï mana wañunmanchu caran.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maríapis, yanagajcunapis ataptin, Jesúspa shungunpis llaquicuywan ishquicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chaymi tapuran: «¿Mayninmantaj Lázaruta pampashcanqui?» nir. Paycunana niran: «Ricanayquipaj shamuy, Tayta.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Willaptin, Jesúspis wagaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wagaptin, runacuna niran: «Sumajćhari Lázaruwan yaćhänacuran.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waquinna niran: «Japra runatapis allchacaycachir, ¿manachuraj Lázarutapis allchacächinman caran? Wañuypita jishpichinman caran, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chaura pushaptin, Lázaro pamparashan chaga ućhcuman Jesús juyupa llaquish ćhayaran. Ućhcuta jatun rumi chaparaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesúsna niran: «Rumita witichiy.» Martana niran: «Tayta, turï ćhuscu junajna pamparaycan. Asyariycannaćhi.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesúsna niran: «Mayna willashcaj. Yupachicamar, Tayta Diosninchi munayniyuj cashanta ricanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chaura runacuna rumita witirachiran. Jesúsna janaj pachapa ricärir, wiyächipaypa niran: «Papällau Papä, ima allish mañacushäta wiyamanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Imaypis wiyamashayquita musyä. Caćhacamashayquitapis cay runacuna tantiyacunanta munä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nircur jayacuriran: «Lázaro, llucshimuy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lázaruna ućhcupita llucshiramuran. Umanpis, maquinwan ćhaquinpis pitush caran. Llucshiramuptin, Jesús niran: «Pascapuy. Purichunna.» ");
INSERT INTO qxhNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lázaruta cawarachiptin, Maríata yanagaj Israel runacunapis achcajmi Jesúsman yupachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin runam ichanga fariseucunaman aywaycur, Jesús imata rurashantapis willaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaura mayur Israel runacunapa sisyunninpaj llapan mayur cüracunapis, fariseucunapis shuntacaran: «¿Imatataj rurashun? Chay runa Tayta Diosnillanchi camacächishancunata ruraycan. Japracunatapis allchacächin. Jishyaćhucunatapis allchacächin. Wañushcunatapis cawarachin. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chapata mana ruraptinchi, llapan runa Jesúsman yupachicunga. Yupachicuptin, Roma mandaj runa ullgucäcunga. Murucuncunata caćhamunga. Murucucunaga Tayta Diosninchipa wasinta jućhurachinga. Marca-masinchita-ima wañurachimäshun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Mayur cüra Caifásna llapan mayur Israel runacunata piñaparan: «Upam carcaycanqui. Imatapis mana tantiyacunquichu. Marca-masinchita-ima ama wañuchimäshuwanchu. Llapanchi-raycur juc runalla wañunman.» Mayur cüra cashpan chay wata llapan cüra-masinta maquinćhu Caifás purichiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Payga mana yarpaypachu rimaran. Manchäga chay wata mayur cüra cashpan Tayta Diosninchi yarpächiptin, cüra-masinta shimiyaran. Llapan Israel runacunata washänan-raycur Jesús wañuyman ćhayananta quiquin Tayta Diosninchi camacächiran. Ichanga mana Israel runacuna-raycurllachu wañuyman ćhayanga; manchäga llapan runata washänan-raycur. Paycuna may-chayćhu juyarpis, Tayta Diosninchipa wawan cashpan maquinćhu cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chay junajpita-pacha mayur Israel runacuna parlanacuran Jesústa wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chaymi marca-masincuna ricay Jesús mana puriranchu. Manchäga mana musyachicullar Efraím marcaman aywacuran. Efraím marcaga chunyaj pacha wajtallanćhu caycaran. Chay quinrallanćhu purïshijnincunawan juyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chay wichan Pascua fiesta ćhayaycämuran. Chaymi wacpita-caypita Israel runacuna Jerusalén marcaman aywarcaycaran fiestapaj camaricuj. Camaricuran Tayta Diosninchi alli ricananta munar. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesústapis ashircaycaran. Chaymi Tayta Diosninchipa wasinćhüpis tapunacurcaycaran: «¿Fiestaman shamungachuraj, manachuraj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseu runacunawan mayur cüracuna mayna runacunata nish caran: «Mayćhüpis Jesústa ricar-imarga, juclla willaycamanqui charichinäpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiestapaj sujta junaj pishiycaptin, Betania marcaman purïshijnincunawan-ima Jesús aywaran. Chay marcaćhu Lázarupis tiyaran. Paytaga wañushanpita Jesús cawarachimush caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesús ćhayaptin, micupacunanpaj yanucuran. Marta jaracuptin, Lázarupis Jesúswan-ima micurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Micurcaycaptin, María alli pirjümita ćhayachiran. Tacshalla butïllan captinsi, sumaj ćhaninyuj caran. Pirjümita Jesúspa ćhaquinman jaycapurir, ajchanwan chaquichipuran. Wasi junta pirjümi asyacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chaura Jesústa wañuyman jitarpuj Judas Iscariote niran: ");
INSERT INTO qxhNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«¿Imapätaj alli cuyayllapaj pirjümita jićhaycächinqui? Juc wata aruypa ćhaninćhu ranticunman caran. Chay jillayta wacchacunata, pishipacujcunata aypunman caran.» Judas Iscariote Jesúspa purïshijnin caycarpis, ");
INSERT INTO qxhNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","mana pishipacujcunata llaquiparchu rimaran; manchäga suwa cashpan. Paymi Jesúspa tisurïrun caran. Ichanga wallca-wallcalla jillayta raquicurij. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chaura Jesús niran: «Pirjümita jićhapämänanta ama mićhanquichu. Cawaycaptillä, pampacunäpaj armaycächiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pishipacujcunatawan wacchacunata imaypis ricanquipaj. Nuwatam ichanga waran-waran mana ricamanquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Betania marcaćhu Jesús caycashanta mayar, chay-chicaj Israel runacuna aywaran. Mana Jesúsllamanchu aywaran; manchäga Lázarutapis ricäcuj. Payta Jesús cawarachish caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lázaruta cawarachishanpita runacuna cüracunapa shiminta mana ćhasquirannachu; manchäga Jesúspa shimillanta. Payllaman yupachicuran. Chaymi mayur cüracuna Lázarutapis, Jesústapis wañurachiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Warannin Jerusalén marcaćhu chay-chicaj runa fiestata rurananpaj caycashanćhu Jesús ćhayaycashantapis mayaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mayar, runacuna palmapa üjanta cuchuran. Jesústa ćhasquicuj llucshir, cushicushpan japarpararan: «Taytallau Tayta, washaycallämay, ari. Tayta Diosninchi caćhamushan runa alli ricash caycullächun. Israel runacunapa mandajnin alli ricash caycullächun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesúsna Tayta Diosninchipa shimin ćharcucänanpaj mañacushan manta bürun muntash ćhayaran. Tayta Diosninchipa shiminćhu isquirbiraycan: ");
INSERT INTO qxhNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Jerusalén marca runacuna, Ama manchariychu. Mandajniqui shaycämun. Manta bürullan muntash yaycaycämun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chay wichan purïshijnincunapis Jesús mandaj cashanta mana tantiyaranchu. Cawarircamur janaj pachaman aywacuptinraj, Jesús rurashancuna Tayta Diosninchipa shiminćhu isquirbishanwan tincushanta yarpäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lázaruta Jesús cawarachishanta ricajcunam ichanga willacur cushish purircaycaran: «Wañush Lázaruta Jesús jayaptin, pamparaycashan ućhcupita cawaycaj llucshimuran» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaymi: «Tayta Diosninchi sumaj Jesústa yanapan» nir waquin runacunapis Jerusalén marcapita Jesústa ćhasquij llucshiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseucunam ichanga ninacuran: «Llapan runa payman yupachicun. ¿Canan imatataj rurashun? ¿Pïnaraj nuwanchita alli ricamäshun?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua fiesta caycaptin, jäpa runacunapis Jerusalén marcaman aywaran Tayta Diosninchita alliman ćhuraj. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jäpa runacuna Felipita niran: «Jesústa ricsichimay, ari.» Felipiga Galilea quinran Betsaida marcapita caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipina Andrésta willaran. Ishcaninna Jesústa willaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Willaptin, Jesús niran: «Cananga Tayta Diosninchipa caćhan cashäta llapan runa musyanga. Llapanmi alliman ćhuramanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sumaj tantiyacunquiman. Rïgu muruta mana pampaptinchi, manash wiñamunchu. Murullash jitaräcun. Pampaptinchish ichanga wañush-yupay captin, mamayrunta mana ricanchinachu. Wiñamurshi ichanga, atayar sumaj wayun. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jamcunapis shunguyqui munashallanta rurar mana wiyacamar, ushyacayman ćhayanquipaj. Shunguyqui munashanta jungaycur shimïta wiyacurmi ichanga, cay pachaćhüpis, janaj pachaćhüpis mana ushyacaypa cawanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maquïćhu cawayta munar, wiyacamar nuwa-jina cawanquiman. Wiyacamar, ćhayashäman ćhayanquipaj. Wiyacamaptiqui, Papänïpis allićhu jurgushunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Cananga juyupa llutäpacuycä. ¿Imataraj rurashaj? ‹Papä, wañuypita washaycallämay› niyta munarsi, mana nishächu. Papänïpa shungun munashallanta ruranäpaj cay pachaman shamushcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chaymi Papänïta imaypis alliman ćhurashaj.» Chaura janaj pachapita nimuran: «Munayniyuj cashäta mayna musyachicushcä. Yapaypis musyachicushämi.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chayta wiyar, waquin juturajcuna niran: «Räyu-imaćhi pashtamusha.» Waquinna niran: «Anjil-imaćhi rimamusha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesúsna niran: «Mana nuwatachu jayacamasha. Manchäga jamcunata jayacamusha sumaj tantiyacunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Canan llapan runapa shungunta Tayta Diosninchi musyapanga. Supayta jargunga. Cay pachaćhu mandaj cayninta jićhunga. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jugarachimaptin, janaj pachaman Tayta Diosninchi shuntacamaptin, camacächishaj llapan runa yupachicamänanpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","«Jugarachimaptin» nir imanuypapis rusćhu wañuyman ćhayananta musyachicuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Runacunana niran: «Tayta Diosninchipa shiminta isquirbir, Moisés niran: ‹Washäcujga imaycamanpis cawanga.› Jammi ichanga niycanqui: ‹Tayta Diosninchipa caćhan captïsi, rusćhu jugarachimanga.› ¿Pitaj canqui? Mä, Tayta Diosninchipa caćhamushan Washäcujpita tantiyachimay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesúsna niran: «Ishcay-quimsa junajlla ricanacushun. Achqui achicyashan-jina Tayta Diosninchipa shungun munashanta tantiyachishayqui. Chaymi shimïta sumaj wiyacunquiman. Manchä chacay ćhayapushunquipaj. Chacaypa purijcuna imamanpis ćhayashanta mana musyanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chaymi ricay ñawiquićhu purishäcaman ćhasquicamanquiman. Tayta Diosninchipis: ‹Wawämi canqui› nir alli ñawinwan ricashunquipaj.» Willapäcuyta ushyariycur, Jesús aywacuran. Runacuna ricay mana puriranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chaura ricay ñawinćhu Tayta Diosninchi camacächiyninpa jishyaćhucunata allchacaycächiptinsi, wañushcunata cawariycachiptinsi, runacuna Jesúsman mana yupachicuranchu. Shiminta mana ćhasquicuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mana ćhasquicuranchu unay willacuj Isaíaspa shimin ćharcucänanpaj. Payga unay niran: «Taytallau Tayta, shimiquita willaptïsi, ¿pillapis ćhasquicushachuraj? Munayniyuj cashayquita musyachicuptiquisi, ¿yupachicushachuraj?» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chay-jina Jesúsmanpis mana yupachicuranchu. Isaíaspa shimin niycaran: ");
INSERT INTO qxhNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Runacunapa ñawinta Tayta Diosninchi japrayächisha. Shunguntapis chucruyächisha. Japrayächisha mana imatapis ricananpaj. Shunguntapis chucruyächisha mana imatapis tantiyacunanpaj. Jucha aparicushanpitapis mana wanacunanpaj camacächisha. Wanacuptinmi ichanga, Tayta Diosnin cashpan allchacächïman caran.» ");
INSERT INTO qxhNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Unayga Jesús munayniyuj cashanta Isaíasta ricachiptin, rimash caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Achcaj runa Jesústa wasguipaptinsi, waquin Israel runacuna Jesúsman yupachicuran. Waquin mayur runacunapis Jesúspa shiminta wiyacuran. Ichanga shuntacäna wasipita jargunanta manchacur, runa wiyay mana rimacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Paycuna Tayta Diosninchi alli ricananta munarsi, runa-masin alli ricanantaraj sumaj munaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chaura wiyächipaypa Jesús niran: «Pipis yupachicamar, Tayta Diosninchimanpis yupachicun. Paymi caćhamasha. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ricamarpis, caćhamaj Tayta Diosninchitapis rican. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Achqui achicyashan-jina Tayta Diosninchipa shungun yarpashanta tantiyachicunäpaj shamushcä. Yupachicamajcuna Tayta Diosninchipa maquinćhu cawanga. Mana chacajćhu-jina supaypa maquinćhu cawanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Runacuna shimïta mana wiyacuptinsi, mana ñacayman ćhayachinäpächu shamushcä; manchäga llap-llapanta washänäpämi. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wasguimajcunam ichanga, shimïta mana ćhasquicujcunam ichanga, quiquillanpita imamanpis ćhayangapaj. Shimïta wiyacushanman-tupu ushyacay junajćhu juchanta jurgapash canga. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mana umäpita jurgurcullarchu rimä; manchäga quiquin Tayta Diosninchipa shiminta. Paymi caćhamasha: ‹Shimïta llap-llapanta willay› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Paypa shiminta wiyacuptinchi, mana ushyacaj cawayta tarichimanchi. Chaymi rimashäga Tayta Diosninchipa shimillan. Nimashannuylla willacuycä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua fiesta manaraj jallariptillan, wañuy jananćhu caycashantapis, cay pachapita janaj pachaman Tayta Diosninchiwan tincuj aywanantapis Jesús mayna musyaycaran. Chaynuy captinpis purïshijnincunata sumaj llaquipar, mana caćhariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chacanaycaptin, llapanwan micupacunanpaj jutucasha. Jesústa wañuyman jitarpunanpämi ichanga Simónpa wamran Judas Iscariotita supay yarpächiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Chaypis Jesús Papänin llap-llapanta maquinman ćhurashanta musyaran. Chaynuypis janaj pachapita shamushanta, janaj pachaman Tayta Diosninchi shuntacunantapis musyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaymi micupacuycashanćhu Jesús jataricurcuran. Punchunta jurgurir, chijllanman jacuta watacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Angarawan yacuta ćhagarcur, purïshijnincunapa ćhaquinta mayllapuran. Jinarcur watacushan jacuwan chaquichipuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ćhaquinta mayllapunanpaj ćhayaptin, Simón Pedro niran: «Tayta, ćhaquïta ama mayllapamanquimanchu. Jucpa ćhaquinta manacaj uyway runalla mayllapun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesúsna niran: «Imapaj rurashätapis mana tantiyanquirächu. Ichanga imayllapis tantiyacunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedruna niran: «Ćhaquïta imaypis ama yatanquimanchu.» Jesúsna niran: «Sumaj tantiyacunquiman. Ćhaquiquita mana mayllapuptï, mana purïshimanquinapishchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chaura Simón Pedro niran: «Tayta, ćhaquilläta ama mayllapamaychu. Manchäga maquïtapis, umätapis mayllapamay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesúsna niran: «Chayraj armacushcuna mana janrachu. Chaymi ćhaquillanta mayllacurin. Jamcunapis mana janrachu canqui. Chaypis jucniqui janraraj caycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Judas wañuyman jitarpunanta Jesús musyaran. Chaymi niran: «Jucniqui janraraj caycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Purïshijnincunapa ćhaquinta mayllapurir punchunta jaticurcur, Jesús jamacuycuran. Jinarcur tapuran: «¿Imanir ćhaquiquita mayllapushätapis tantiyanquichu? ");
INSERT INTO qxhNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","‹Yaćhaj tayta› nimar: ‹Taytallau Tayta› nimar, allita rimaycanqui. Rasunpa Taytayqui cä. Yaćhajmi cä. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Taytayqui caycarsi, mayurniqui carsi, ćhaquiquita mayllapuycaptij, nuwa-jina jamcunapis mayllapanacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","«Ricacunayquipaj mayllapushcaj. Ricacamar, nuwa-jina cawanquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sumaj tantiyacunquiman. Uyway runa patrunninta manash apärinmanchu. Caćhapis caćhacujninta mana apärinmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Shimïta wiyashcanqui. Wiyashayquita ćharcuptiqui, Tayta Diosninchipis sumaj yanapäshunquipaj. Sumaj cushicärinquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Chaypis llapaniquita ricsipaycaj. Shuyninpa acracushcaj. Jucniquipämi ichanga Tayta Diosninchipa shimin ćharcucänanpaj nin: ‹Jarashäta micujmi ticrapacarcamasha.› ");
INSERT INTO qxhNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Canan llapanta willapaycaj. Cananllapita imamanpis ćhayaptï, Cawachicuj cashäta ama junganquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sumaj tantiyacunquiman. Caćhäcunata ćhasquicur, quiquïtapis ćhasquicaman. Ćhasquicamarga, Tayta Diosninchitapis ćhasquicuycan. Paymi caćhamasha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chaynuy nir shungun ishquicäcuptin, purïshijnincunata Jesús niran: «Sumaj tantiyacunquiman. Mayganiquipis ticrapamar, wañuyman jitarpamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chaura mayganin cashantapis mana musyashpan jucnin-jucnin ricapänacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Juc purïshijninga yaćhänacushan cashpan Jesúswan jaganacushalla jamaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chaymi payta Simón Pedro tapuran: «¿Piraj jitarpuj runa, au? Mä, Jesústa tapushun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yaćhänacushan purïshijninna jagaycur, Jesústa tapuran: «Tayta, ¿mayganïtaj wañuyman jitarpushayqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesúsna niran: «Tantata paquircur ushmarcachir mallichishä runa canga.» Chaynuy nir tantata paquircur ushmarcachir, Simónpa wamran Judas Iscariotita mallichiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tantata ćhasquircuptillan, Supay charicurcuran. Jesúsna niran: «Judas, yarpaycashayquita juclla ruranquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesús rimashanta maygan purïshijninpis mana tantiyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Waquin yarparan: «Judas tisurïru captinćhi, Pascua fiestapaj rantipacuj caćhaycan. Manchäga pishipacujcunata jillayta aypunanpäćhi caćhaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasna Jesús macyashan tantata micucurcur, juclla llucshicuran. Pachapis chacashana caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Judas aywacuptin, waquin purïshijnincunata Jesús niran: «Cananga Tayta Diosninchi alliman ćhuramanga. Runacunata washänä-raycur wañuptïsi, Tayta Diosninchi cawarachimanga. Chaynuypa Tayta Diosninchi caćhamashantapis, munayniyuj cashantapis runacuna tantiyacunga. Allimanpis ćhuranga. Manasi aycällatana Tayta Diosninchi llapantapis camacächinga. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wawacuna, mana ricamanquipänachu. Mayur Israel runacunata willashä-jina ashimarsi, mana tarimanquipänachu. Aywashäman mana ćhayamunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chaymi shimïta ama junganquichu. Llaquipäshaj-jina, jamcunapis llaquipänacärinqui, ari. ");
INSERT INTO qxhNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Llaquipänacuptiqui, maquïćhu cawashayquita llapan runa tantiyacunga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chaura Simón Pedro tapuran: «Tayta, ¿maymantaj aywacunqui?» nir. Jesúsna niran: «Aywashäman mana aywanquipärächu. Juc junajmi ichanga ćhayamunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedruna niran: «Tayta, ¿imanirtaj mana aywäshijmanchu? Purïshinaj-raycur jina wañuymanpis ćhayäman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesúsna niran: «¿Rasunpachuraj nuwa-janan wañuymanpis ćhayanquiman? Sumaj tantiyacunquiman. Mana ricsij tucumanquipächu. Gällu mana cantaptillan, quimsa cutiparaj wasguimanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Chaypita purïshijnincunata Jesús niran: «Alläpa ama llaquicunquichu-llapa. Manchäga Tayta Diosninchimanpis, nuwamanpis yupachicunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Papänïpa wasin jatun-caray. Juyänanchipaj aypan. Chaymi camarij aywashaj. Wasin mana aypaptin: ‹Camarij aywashaj› mana nijmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Camaricuriycur, pushanajpaj cutimushaj. Papänïpa wasinćhu llapanchi cawashunpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Maypa aywanätapis mayna musyanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chaynuy niptin, Tomás niran: «Maypa aywanayquitapis mana musyar, ¿imanuypataj shamüman?» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesúsna niran: «Nuwalla Tayta Diosninchipa shungun yarpashanta willapashcaj. Imaycamanpis cawachishayqui. Tayta Diosninchimanpis ćhayachishayqui. Mana yupachicamarmi ichanga, Tayta Diosninchipa ñaupanmanpis mana ćhayanquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Shungüwan tincur, Tayta Diosninchipa shungunwanpis tincunqui. Cananpita-pacha quiquin Tayta Diosninchiwan yaćhänacuycanqui. Mayna ricashcanquipis.» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipina niran: «Tayta Diosninchita ricachimay, ari. Ricsiyta munarcaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesúsna niran: «Unaylla juyaycaptinchichu, ¿shungüta mana musyapanqui? Shungüta musyapar, Tayta Diosninchipa shunguntapis musyapanqui. Chaymi ama nimanquimanchu: ‹Tayta Diosninchita ricsichimay.› ");
INSERT INTO qxhNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tayta Diosninchiwan juc shungulla cawashäta ćhasquicushcanqui, ¿au? Chaypis mana yarpashallätachu rimä; manchäga Tayta Diosninchipa shungun yarpashallanta. Chayraj Tayta Diosninchi camacächishancunatapis tantiyacunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chaymi Tayta Diosninchiwan juc shungulla cawashäta ćhasquicunquiman. Shimïta mana ćhasquicursi ima-imata rurashäcunata ricar, ćhasquicamanquiman. Tayta Diosninchi camacächiptin, jishyaćhucunata allchacächishcä. Supaycunata jargushcä. Chay-chicaj runata jarashcä. Wañushcunata cawarachishcä. Chaymi ima-imata rurashäcunata ricaycar, shimïtapis ćhasquicunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sumaj tantiyacunquiman. Tayta Diosninchiwan iwal juyäshaj. Yupachicamaptiqui, shungun munashanta ruranäpaj camacächishan-jina jamcunapis ruranayquipaj camacächinga. Nuwa-jina jishyaćhucunata allchacächinquipaj. Supaycunata jargunquipaj. Chay-chicaj runata jaranquipaj. Wañushcunata cawarachinquipaj. Runacuna Tayta Diosninchipa maquinćhu cawananpaj may-chayćhüpis nuwapita willapanquipaj. Tayta Diosninchi camacächiptin, tucuyta ruranquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yupachicamashayqui-janan imatapis mañacamaptiqui, Wawan cashpä camacächishaj. Chayta rurar, Tayta Diosninchitapis allićhu jurgü. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Shungü munashanta ruraptiqui ima-imata mañacamaptiquipis, wiyashayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Llapan shunguyquiwan manchapacamar, shimïtapis sumaj wiyacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Espíritu Santu yanagäshunayquipaj Tayta Diosninchita mañacushaj. Payga Espíritu Santuta caćhamunga imaypis yanagäshunayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu Santuga Tayta Diosninchipa shungun yarpashanta tantiyachishunquipaj. Tayta Diosninchipa maquinćhu mana cawajcunam ichanga Espíritu Santu pï cashantapis mana musyanchu. Mana ćhasquicunpishchu. Espíritu Santupis paycunata mana yanaganchu. Jamcunam ichanga Espíritu Santuta ćhasquicushcanqui. Maquinćhüpis cawanqui. Payga imaycamanpis yanagäshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mana wacchata-jina jaguishayquichu. Yanagänajpaj cutimushaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tayta Diosninchipa maquinćhu mana cawajcuna imaypis mana ricamangapächu. Jamcunawanmi ichanga ricanacuycäshunpaj. Wañurpis, cawarimushaj. Wañuptiquipis, cawarachishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Papänï cawarachimaptin, paywan juc shungulla cawashäta, jamcunawanpis juc shungulla cawashäta tantiyacunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ćhasquicamajcuna manchapacamashpan shimïta wiyacunga. Shimïta wiyacujcunata Papänïpis sumaj llaquipanga. Llaquipashpä nuwapis yanagäshaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chaura allicaj Judas tapuran: «Tayta, ¿imanirtaj nuwacunallata yanagämanquipaj; waquinta mana?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesúsna niran: «Ćhasquicamajcuna manchapacamar, shimïtapis wiyacun. Chaymi Papänï-ima maquïćhu purichishaj. Llaquipashpä iwal cawäshishaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wasguimajcunam ichanga mana manchapacamar shimïtapis mana wiyacunchu. Willapäcushäga mana umällapitachu. Manchäga: ‹Shimïta llapanta willanqui› nir quiquin Tayta Diosninchi caćhamasha. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Ricay ñawiquićhu puriycällar, llapantapis willapashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aywacuptï, Tayta Diosninchi Espíritu Santuta caćhamunga. Paymi yanagäshunquipaj. Shimïtapis llapanta yarpächishunquipaj. Pishïshushayquitapis tantiyachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Runacuna alli cawayta ashirpis, quiquinpita mana tarinchu. Nuwam ichanga alli cawayman ćhayachishayqui. Allilla juyaycullay, ari. Ima captinpis, ama llaquicunquichu. Ama manchacunquichu. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aywacunäta mayna willashcaj. Chaypis jamcuna-raycur cutimushaj. Rasunpa manchapacamarga, shacya-shacyalla shuyämanquiman. Tayta Diosninchiman cuticushaj. Paypa maquinćhu cawä. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Llapantapis willapaycaj aywacuptï, sumaj yupachicamänayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Alläpa ama rimashunnachu. Supay jananchićhüna. Cay pachaćhu paymi munayniyuj. Ichanga mana ićhipamangachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Imaman ćhayarpis, Papänïpa shiminta ćharcüman. Chayräćhi llapan runa Papänïta llaquishäta, shiminta wiyacushäta musyanga. Cananga aywacushun. Jatariy-llapa.» ");
INSERT INTO qxhNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Chaypita tincuchiypa willapar Jesús niran: «Übas yüra cä. Papänï sumaj ricaman. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Callapäcuna mana wayuptin, llaumarin. Wayuptinmi ichanga pichan sumaj wayunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jamcuna shimïta wiyacur, pichash wayuj übas-jina cawarcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Maquïćhu cawaptiqui, mana caćharishayquichu. Juc callapa yüraman mana tanarar, mana wayunmanchu. Chay-jina jamcunapis nuwaman mana tanarämar, Tayta Diosninchipa shungun munashannuy cawayta mana camäpacunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Übas yüra cä. Jamcunana callapä canqui. Nuwaman tanarämar, callapäcunapis sumaj alli. Yata cawarmi ichanga, ima ruraytapis mana camäpacunquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Shimïta mana wiyacuptiqui, mana wayuj callapata-jina Tayta Diosninchi llaumashunquipaj. Mana wayuj callapata llaumarin. Chaquiptin shuntarcur, ninaćhu ruparachin. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Maquïćhu cawaptiqui, shimïta wiyacuptiqui, Tayta Diosninchipis llapan mañacushayquita tarichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Shimïta wiyacur, manchapacur cawar, Papänïta allićhu jurgunqui. Chaynuypa maquïćhu cawashayqui musyacanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Papänï alli ricamashan-jina jamcunatapis alli ricashayqui. Maquïćhu cawaptiqui, alli ñawïwan ricashayqui. Yaćhänacushunpäpis. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Shimïta wiyacuptiqui llaquipar, mana caćharishayquichu. Papänïpis shiminta wiyacuptï, llaquimar mana caćharimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Llapantapis willapaycaj nuwa-jina shacya-shacyalla cawanayquipaj. Shunguyquipis achicyacäcungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ichanga ama junganquimanchu. Llaquipäshaj-jina jucniqui-jucniquipis llaquipänacärinquiman. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tantiyacunquiman. Pipis rasunpa llaquipäcuyta yaćhar, yaćhänacushanta yanapänan-cashan wañuymanpis ćhayan. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Shimïta wiyacuptiqui, yaćhänacunchi. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mana uyway runachu carcaycanqui. Manchäga sumaj yaćhänacunchi. Uyway runata imata yarpashanchitapis mana willanchichu. Jamcunatam ichanga Papänï imallata nimashantapis willashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","«Mana quiquillayquipitachu ćhasquicamashcanqui. Manchäga quiquïmi camacächishcä. Canan übas alli wayushan-jina allita rurar cawanqui, ari. Alli cawashayquita ricacur waquincunapis ćhasquicamar, mana yamacällar alli cawanga. Chaymi yupachicamashayqui-janan ima-imata mañacuptiquisi, Papänï wiyashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Shimïta ama jungaychu. Jucniqui-jucniquipis sumaj llaquipänacäriy.» ");
INSERT INTO qxhNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Runacuna chiquimashan-jina jamcunatapis chiquishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Juchata aparicushan-jina cawaptiquim ichanga, paycuna alli ñawinpa ricashunquipaj. Jamcunatam ichanga wamrachacushcaj. Chaypita juchaćhu arujcuna chiquishunqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nishajta ama junganquichu. Uyway runa patrunninta manash apärinmanchu. Chaymi maquïćhu purishayquipita waquin runa chiquir jaticaćhäshunquipaj. Nuwatapis jaticaćhaycäman. Waquin runam ichanga shimïta wiyacushan-jina shimiquitapis wiyacunga. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","«Purïshimashayquipita chiquijcuna chiquishunquipaj. Paycunaga caćhamajnïpa shungunta mana musyanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Cay pachaman shamur, Tayta Diosninchipa shungun munashanta willapashcä. Shimïta wasguirmi ichanga, runacuna juchata aparicun. Paycuna mana chapacunmanchu: ‹Tayta Diosninchipa shiminta mana imaysi wiyashcächu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","«Pipis chiquimar, Papänïtapis chiquin. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cay pachaman shamuptï, jishyaćhucunata allchacächishäta, supaycunata jargushäta, chay-chicajta jarashäta, wañushcunata cawarachishäta ricasha. Ricaycarpis, mana ćhasquicamashachu. Chaymi juchayuj ricarisha. Jananmanpis chiquiman. Papänïtapis chiquin. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Llapanpis camacaycan Moiséspa shimin ćharcucänanpaj. Paypa shimin nin: ‹Juchaynaj caycaptïsi, chiquimasha.› ");
INSERT INTO qxhNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ima captinpis, Tayta Diosninchipita Espíritu Santuta caćhamushaj yanagäshunayquipaj. Payga Tayta Diosninchipita caycar, shungun yarpashantapis musyachishunquipaj. Nuwapitapis tantiyachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chay-jina jamcunapis waquin runacunata nuwapita willapäcunqui. Unaypita-pacha purïshimashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Wawacuna, runacuna chiquishuptiquisi, mana yamacällar yupachicamanquiman. Llapanta sumaj willapaycaj mana wasguimänayquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chiqui runacuna shuntacäna wasicunapitapis jargushunquipaj. Wañuchishushpayquipis ninga: ‹Tayta Diosninchipa ricay ñawinćhu allita ruraycä.› ");
INSERT INTO qxhNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ichanga Tayta Diosninchi pï cashantapis, pï cashätapis mana musyashpan llapanta ruranga. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Rimashäman ćhayar, yarpänayquipaj llapanta willapaycaj. Ñaupata iwal purishpanchi mana willaparajchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Cananga caćhamajnïman cuticushaj. Chaypis mayganiquipis mana tapumanquirächu: ‹¿Maymantaj aywanqui?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Shimïta wiyar, ¿imanirtaj llaquish mayarpaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sumaj tantiyacunquiman. Allipaj aywacushaj. Aywacur, Espíritu Santuta caćhamushaj yanagäshunayquipaj. Manchäga mana shamungapächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Paymi llapan ricay tantiyachinga ima jucha cashantapis, pï juchaynaj cashantapis, pï imaman ćhayanantapis. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","¿Imataj jucha? Juchaga nuwaman mana yupachicuy. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","¿Pitaj juchaynaj? Juchaynajga nuwallam cä. Cananga Papänïman aywacushaj. Mana ricamanquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","¿Pitataj imamanpis ćhayachisha? Cay pachaćhu mayur supay ñacananpäga mayna Tayta Diosninchi camacächisha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Achcaraj caycan willapänajpaj. Ichanga tantiyacuyta mana atipanquirächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Espíritu Santu shamurmi ichanga, Tayta Diosninchi ima-imata yarpashantapis, camacächinantapis tantiyachishunquipaj. Mana quiquinpa yarpayllanpitachu tantiyachishunquipaj; manchäga Tayta Diosninchipita wiyashallanta. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Espíritu Santu allićhu jurgamanga. Shimïta wiyar, musyachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tayta Diosninchiwan juc shungulla cawä. Chaymi nishcä: ‹Shimïta wiyar, musyachishunquipaj.› ");
INSERT INTO qxhNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Manasi aycällata aywacushaj. Mana ricamanquipänachu. Ichanga manasi aycällata cutimuptï, yapay ricamanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chaura purïshijnincuna tapunacuran: «¿Imatataj rimaycan: ‹Manasi aycällata mana ricamanquipächu. Ichanga manasi aycällata yapay ricamanquipaj› nir? ¿Imanirtaj: ‹Papänïman aywacushaj› niycan? ");
INSERT INTO qxhNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imanirtaj: ‹Manasi aycällata cutimushaj› nimanchi? Imata rimashantapis mana tantiyanchichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yarpaćhacurir tapucuyta munashanta musyar, Jesús niran: «¿‹Cananpita manasi aycällata mana ricamanquipächu. Chaypita manasi aycällata yapay tincushunpaj› nishäpitachu tapunacurcaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sumaj tantiyacunquiman. Llaquimashpayqui wagaptiquisi, ataptiquisi, mana ćhasquicamajcuna jatunpa cushicunga. Yapay tincuptinchim ichanga, atash caycarpis, jatunpa cushicunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Warmipis nanay chariptin, llaquicuywan atan. Jishyacurirmi ichanga, jatunpa cushicun: ‹Ima allish wawäta tarishcä› nir. Nanashantapis mana yarparannachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chay-jina aywacuptï, jamcunapa shunguyquipis sumaj nananga. Yapay tincuptinchim ichanga, shunguyquipis jatunpa cushicunga. Pipis mana llaquicuyman ćhurashunquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tincuptinchi, imatapis mana tapumanquipänachu. Sumaj tantiyacunquiman. Yupachicamashayqui-janan mañacuptiqui, Tayta Diosninchi imatapis tarichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yupachicamashayqui-janan mana imatapis mañacushcanquirächu. Mä, mañacuy. Mañacur, ćhasquinqui. Chayraj jatunpa cushicunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Tincuchiyllapa willapashcaj. Cananmi ichanga Tayta Diosninchipita llap-llapanta tantiyachishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tincushanchi junaj mana jayarämanquipänachu. Yupachicamashayqui-janan quiquiquicunana Tayta Diosninchita mañacunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Payga llaquipäshunqui ćhasquicamashayquipita, paypita shamushäta yupachicushayquipita. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Paypita shamushcä. Paymi cay pachaman shamunäpaj camacächisha. Cananga janaj pachaman cuticushaj. Tayta Diosninchiwan cawashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chaura purïshijnincuna niran: «Cananmi ichanga mana chapacullar willacuycanqui. Tincuchipayllapa mana rimanquinachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Runacuna yarpashantapis musyanqui. Llapanta tantiyanqui. Chaymi mana tapupajmanchu. Manchäga Tayta Diosninchipita shamushayquita ćhasquicüna.» ");
INSERT INTO qxhNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesúsna niran: « ‹¿Rasunpachu ćhasquicamanqui?› ");
INSERT INTO qxhNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Manasi aycällata llapaniqui wasiquiman-caman jishpicärinquipaj. Japalläta jaguiycamanquipaj. Tayta Diosninchim ichanga mana imaypis jaguimanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Llapallanta willapashcaj sumaj yupachicamänayquipaj. Maquïćhu juyar ñacayman ćhayaptiquisi, yanapäshayqui allilla cawanayquipaj. Mana ćhasquicamajcunatapis mandaj supaynintinta mayna ićhipushcä. Chaymi cushish cawanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Llapanta willapariycur janaj pachaman ricärir, wiyächipaypa Jesús niran: «Papä, cananllapaj cashcä. Wawayquim caycä. Allićhu jurgaycamay, ari. Nuwapis allićhu jurgushayqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Llapan runata maquïman ćhurashcanqui. Ćhasquicamajcunata imaycamanpis cawachinäpaj camacächishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ćhasquicamaptinchi, imaycamanpis cawanga. Jamlla Tayta Diosninchi canqui. Nuwana Washäcuj Jesús caycä. Washäcuj canäpaj cay pachaman caćhamashcanqui. Chaymi maquinchićhu purir, pipis imaycamanpis cawanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Papä, cay pachaćhu allićhu jurgur, shimiquita llap-llapanta ćharcushcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ñaupayquimanna shuntacamay, ari. Allićhu jurgaycallämay. Cay pacha manaraj captillan, alli ricanacushanchi-jina yapay alli ricanacushun. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Cay pachaćhu waquin runacuna purïshimänanta camacächishcanqui. Wawayqui captinpis, maquïman ćhurashcanqui purichinäpaj. Pï cashayquitapis paycunata sumaj tantiyachishcä. Shimiquita willapashäta llapanta wiyacusha. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","«Jamllapita cawashäta musyanna. Shimiquita willacuptï, ćhasquicushana. Cay pachaman caćhacamashayquitapis aunisha. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Purïshimajcunapaj mañacamuj. Paycuna wawayquim. Maquïman ćhurashcanqui. Chaypita mañacamuj. Shimïta mana wiyacujcunam ichanga imanuypis cawacullächun. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Papä, shiminchita wiyacujcuna nuwanchipa caycan. Purïshimajcuna allićhu jurgamaptin, munayniyuj cashä musyacanga. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","«Papällau papä, cay pachata jaguishäna. Cuticamushäna. Chaymi purïshimajcunapaj mañacuj. Paycuna cay pachaćhüraj juyanga. Papä, sumaj alli canqui. Juc shungulla cawananchipaj camacächishayqui-jina paycunapis juc shungulla cawananpaj ricaycullay. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Camacächishayqui-jina iwal purishäcaman sumaj ricashcä. Maquïćhu purichishäcaman mayganpis ushyacayman mana ćhayashachu. Judas Iscariotilla ushyacayman ćhayasha shimiqui ćharcucänanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Papä, janaj pachaman cuticamushpä jatunpa cushicü. Chaypis cay pachaćhu cashpä mañacushayqui. Nuwa-jina cushish cawananpaj purïshimajcunata ricaycullay. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Shimiquita mayna willapashcä. Nuwa-jina maquiquićhu cawan. Juchata mana aparicushä-jina wawayquicunapis juchaćhu mana arunchu. Chaymi shungun munashanta mana ruräshiptin, shimiquita mana wiyacujcuna chiquin. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","«Purïshimajcunata cay pachapita ama jurgunquichu. Manchäga cay pachaćhu cawashancaman supaypita washaycunqui, ari. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Maquiquićhu cawä. Purïshimajcunapis maquiquićhu cawan; mana supaypa maquinćhüchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Shimiquiga shunguyqui yarpashanwan tincun. Shimiqui imata rimashantapis llap-llapanta purïshimajcunata willapashcä. Chaymi sumaj tantiyaycächï shunguyqui munashannuy cawananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Cananga cay pachaman caćhamashayqui-jina nuwapis caćhacushaj shimiquita llapan runata willapäcunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Llapan shungüwan shimiquita wiyacushä-jina paycunapis shimiquita wiyacunman. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Papä, mana purïshimajcunallapächu mañacuj. Manchäga paycunapa shiminta wiyar waquin ćhasquicamajcunapäpis mañacuj. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nuwanchi juc shungulla cawashanchi-jina ćhasquicamajcunapis juc shungulla cawanman. Llapanï juc shungulla cawananchita munä. Chayräćhi waquin runapis caćhamashayquita ćhasquicunga. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","«Alli ricamashayqui-jina ćhasquicamajcunatapis alli ñawïwan ricä. Alli ricanacushanchi-jina paycunapis alli ricanacunman juc shungulla cawananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","«Papä, juc shungulla cawashanchi-jina ćhasquicamajcunawan juc shungulla cawä. Chaynuypa paycunapis juc shungulla cawanga. Juc shungulla cawaptin, llaquipäcuj cashayquita waquin runacunapis tantiyacunga. Llaquipäcuj cashpayqui cay pachaman caćhamashcanqui. Llaquipämashpayqui alli ricamashayqui-jina ćhasquicamajcunatapis llaquipar alli ricanqui. Chayta llapan runa tantiyacunman. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Papä, acrapamashayqui runacunawan juturpayta munä. Achic-achicyaycajta ricamangapaj. Cay pachapis manaraj caycaptin, llaquipämashpayqui alliman ćhuramarayqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Papä, jamlla allillata ruranqui. Runacunam ichanga alli shungu cashayquita mana musyaranchu. Nuwam ichanga alli shungu cashayquita musyä. Caćhamashayquita ćhasquicamajcunapis musyan. ");
INSERT INTO qxhNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pï cashayquitapis tantiyachishcä. Sumajraj tantiyaycächï. Chayrämi alli ricamashayquita tantiyacunga. Nuwapis mana caćharishächu. Quiquin-pura alli ricanacunanpäpis yanapäshaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tayta Diosninchita mañacurir, purïshijnincunawan-ima Jesús aywacuran «Cedrón» nishan rajra chimpanman. Juc ćhacraman ćhayar, yaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Shuntacänan pacha captin, chay ćhacrata Jesústa wañuyman jitarpuj Judas Iscariotipis ricsiraran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaymi Jesústa charinanpaj murucucunata Judas ćhayachiran. Mayur cüracunawan fariseucuna caćhaptin, Roma marcapa mandaj murucuncunapis, Tayta Diosninchipa wasinta täpajcunapis achquincunawan-caman, cuchilluncunawan-caman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Charij ćhayananta Jesús mayna musyaran. Chaymi tariparcur ćhayajcunata tapuriran: «¿Pitataj ashircaycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Murucucunana niran: «Nazaret runa Jesústa.» Jesúsna niran: «Nuwa cä.» Jesústa wañuyman jitarpuj Judaspis caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","«Nuwa cä» niptin, llapan runa jipapa tunicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús yapay tapuran: «¿Pitataj ashircaycanqui?» nir. Murucucunana niran: «Nazaret runa Jesústa.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesúsna niran: «Mayna willashcaj. Nuwata ashimar, quiquilläta apamanquiman. Purïshimajnïcunata ama yatapanquimanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesús rimashan ćharcucänanpaj nish caran: «Jammi llapan runata maquïman ćhurashcanqui. Jucpis mana ushyacayman ćhayashachu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedruna cuchilluwan juc runapa dirïcha-caj rinrinta rugupariran. Ruguparishan runapa jutin caran Malco. Payga mayur cürapa uywaynin caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesúsna niran: «Cuchilluta ama jugariychu. Cashgallaman ćhuraycuy. Papänï camacächiptin, ¿ñacaypita jishpishächuraj?» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chaura murucucuna mandajnintin Tayta Diosninchipa wasinta täpaj Israel runacuna-ima Jesústa charircur, watarcäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nircur Anáspa wasinman aparan. Anásga mayur cüra Caifáspa suydun caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifásmi waquin mayur runacunata willapash caran: «Alli canman juc runalla llapanchipa rucanchi wañuptin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Chaura Jesústa apaycaptin, caru jipallanta aywaran juc purïshij-masinwan Simón Pedro. Chay purïshijga mayur cürawan ricsinacuran. Ricsinacur, Jesúspa jipanta sawan ruricaman yaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrum ichanga puncu wajtapita mana yaycuranchu. Chaymi ruriman yaycuj purïshijga puncu quićhaj warmita ruwacuran Pedrutapis ruriman yaycuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Puncu quićhaj warmi Pedruta tapuran: «¿Manachu chay Jesúspa purïshijnin canqui?» nir. Pedruna niran: «Mana.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Juyupa jasaptin, ninata ratarcachir uywaycunapis, Tayta Diosninchipa wasinta täpajcunapis mashacurcaycaran. Pedrupis mashacuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mayur cürana Jesústa tapuycaran imata yaćhachishantapis, purïshijnincuna pï cashantapis. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesúsna niran: «Llapan wiyay Tayta Diosninchipa shiminta willapäcushcä. Shuntacäna wasicunaćhüpis, Tayta Diosninchipa wasinćhüpis tantiyachicushcä. Israel-masinchicuna llapanmi chay wasicunaćhu jutucan. Mana pacayllapachu willapäcushcä. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imanirtaj tapumanqui? Shimïta wiyajcunata mä, tapuy. Paycuna imata rimashätapis musyan.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chaynuy niptin, Tayta Diosninchipa wasinta täpaj runa Jesústa cutariran: «¿Imanirtaj mayur cürapaj shimiquita jugarishcanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesúsna niran: «¿Imatataj llutanta rimashcä? Mä, nimay. Llutanta mana rimaycaptï, ama magamanquimanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chaypita mayur cüra Caifásmanna watashta Jesústa Anás apachiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jinallaraj Simón Pedro mashacuycaran. Mashacuycaptin, waquin runa tapuran: «Jesúspa purïshijnin canqui, ¿au?» nir. Pedruna chapacuran: «Mana.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mayllanta mayur cürapa uywayninpis niran: «Ćhacraćhu Jesústawan ishcaniquita ricashcaj.» Tapuj runapa yawar-masinpa rinrinta Pedro rugush caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chaynuy niptin, yapay Pedro Jesústa wasguiran. Niycaptillan, gällu cantariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Manaräpis pacha waraptillan, mandaj cüra Caifáspa wasinpita mandaj Pilatupa dispächunman Jesústa aparan. Mandaj Pilatuta Roma marca mandaj ćhuraran Jerusalén marcaćhu mayur auturdä cananpaj. Israel runacunam ichanga dispächunman mana yaycuranchu: «Roma runapa wasinman yaycur, juchata aparicushun. Tayta Diosninchipis juyu ñawinwan ricamäshun. Pascua fiesta micuyta mana micushunpächu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chaymi dispächunpita llucshirir, mandaj Pilato tapuran: «¿Imaćhütaj juchata aparicush dispächüman apamunayquipaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Runacunana niran: «Jatunpa juchata aparicusha captin, apamushcä. Juchaynaj captinga, mana apamümanchu caran.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mandaj Pilatuna niran: «Jucha aparicush caycaptin, quiquiquicuna yarpashayquita ruray.» Chaura Israel runacuna niran: «Israel runacuna pitapis mana wañuchinmanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Llapanpis camacaran Jesúspa shimin ćharcuptin, imanaypapis wañuyman ćhayananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dispächunman cutircur, mandaj Pilato Jesústa tapuran: «¿Rasunpachu Israel runacunapa mandajnin canqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesúsna niran: «¿Yarpayllayquipitachu rimaycanqui? ¿Jucchu willashcashunqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mandaj Pilatuna niran: «Mana Israel runachu cä. Marca-masiquicunawan cüracunapa mandajnincuna apamushcashunqui. ¿Imataj juchayqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesúsna niran: «Mana cay pachaćhüchu mandaj cayta ashiycä. Mandaj cayta ashiptï, mayur Israel runacunapita alli ricamajcuna tucuy-jinanpa washämanman caran. Washämänan-janan maganacuyta jallaycärinman caran. Ichanga mana cay pachaćhüchu runacunata maquïćhu purichï.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mandaj Pilatuna tapuran: «¿Chaura rasunpachu mandaj canqui?» nir. Jesúsna niran: «Rasunpa cä. Quiquiqui rimashcanqui. Tayta Diosninchipa shiminta willacunäpaj cay pachaćhu yurishcä. Paypa shungun munashanta rurajcuna shimïta ćhasquicun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mandaj Pilatuna niran: «¿Piraj Tayta Diosninchipa shungunta musyan?» Jesústa tapupärir, mayur Israel runacunatana mandaj Pilato niran: «Cay runapa juchanta mana tarïchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ichanga imaypis Pascua fiestaćhu juc runata caćharishäta musyanqui. ¿Jesústa caćharinäta munanquichu? Paypa maquinćhüshi cawanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chaura llapan runa japararan: «Mana. Jesústa ama caćhariychu. Barrabásta caćhariy» nir. Barrabásga asaltanti caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chaura mandaj Pilato Jesústa sumaj wascachiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wascariycur murucucuna cashapita curünata pilltarcur, Jesúspa umanman jatiparan. Mandajpa punchunta-jina puca punchutapis ushtuparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Asipänan cashpan: «Israel runacunapa mandajnin alli ricash caycullächun» nir, lajyar ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Runacunaman llucshircur, yapay mandaj Pilato niran: «Ima juchatapis Jesús mana aparicushachu. Caćhariycushun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jinarcur casha curünan jatishta, puca punchushta Jesústa jurgamuran: «Cay runata mä, ricay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesústa ricar, mayur cüracunawan Tayta Diosninchipa wasinta täpajcuna ullgucurcuran: «Rusćhu wañuchicächun. Rusćhu wañuchicächun» nir. Japarpaptin, mandaj Pilato niran: «Ricaptï, cay runa juchata mana aparicushachu. Wañuchiyta munar, quiquiquicuna imatapis ruracullay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Israel runacunana niran: « ‹Tayta Diosninchipa Wawan cä› nishanpita wañunman. Moiséspa shiminta ćharcunan.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","«Tayta Diosninchipa Wawan cä» nishanpita llapan runa ullguptin, mandaj Pilatupis mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chaymi dispächunman yaycurir, Jesústa tapuran: «¿Maypitataj caycanqui?» nir. Paymi ichanga upällalla cacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chaura mandaj Pilato niran: «Tapuycaptij, ¿manachu imatapis rimacunqui? Caćharinäpäpis, rusćhu wañuchishunayquipaj auninäpäpis maquïćhümi caycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesúsna niran: «Llapantapis Tayta Diosninchi camacächin. Manchäga imata ruramänayquipäpis munayniqui mana canmanchu. Chaypis wañuyman jitarpamaj runa jatunpa juchata aparicusha.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mandaj Pilato imanayllapapis Jesústa caćhariyta munaran. Israel runacunam ichanga chigaypa japarparan: «Mandaj-tucur mandamajninchi Césarta pampaman ćhurasha. Chaymi Jesústa caćharir, jampis mandamajninchi Césarta pampaman ćhuranquipaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chaura dispächunpita mandaj Pilato Jesústa jurgamuran. Pusharan Gábbata läsaman. Mandajpa jamananman jamachiran. Hebreo rimayćhu: «Gábbata läsa» ninanga: «Läja rumicunawan pirgasha» ninanmi. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chay junaj Pascua fiestapa wispiran caran. Lasdüsi caran. Mandaj Pilatuna Israel runacunata niran: «Catay mandajniqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Runacunana ullgucäcuran: «Wañuchun. Wañuchun. Rusćhu wañuchicächun» nir. Mandaj Pilatuna niran: «¿Rasunpachu mandajniquita wañuchinäta munarcaycanqui?» Chaura mayur cüracuna niran: «Mandamajninchiga Césarllam. Juc mana canchu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chaura chaynuy niptin, Jesústa inćhigaran rusćhu wañuchinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Chaura rusnin matancashta «Calabïra» nishan pataman Jesústa aparan. «Calabïra» ninanta hebreo rimayćhu: «Gólgota» nin. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pataman ćhayaycachir, rusćhu wañuchiran. Ishcaj runatapis rusćhu wañuchiran: jucninta juc-caj lädunman, jucnintana juc-caj lädunman, Jesústana ćhaupićhu. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mandaj Pilato ruspa puntanman litrïruta ćhurachiran: «Cay runa Nazaret marca Jesús, Israel runacunapa mandajnin» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Marca washlällanćhu captin, ćhurachishan litrïruta achcaj runa ricäcuran. Hebreo rimayćhüpis, latín rimayćhüpis, griego rimayćhüpis isquirbiraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Israel mayur cüracunam ichanga mandaj Pilatuta niran: « ‹Israel runacunapa mandajnin› nir ama isquirbirächunchu. Manchäga: ‹Israel runacunapa mandajnin-tucun› nir isquirbirächun.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mandaj Pilatuna niran: «Isquirbishäta mana rucashächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Rusman läbaycur, murucucuna Jesúspa jacunta ćhuscuman raćhiran. Jucta-caman apacäriran. Müdanantam ichanga pampan mana captin, raćhiyta mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chaymi ninacuran: «Ama raćhishunchu. Manchäga surtita jitashun mayganinchisi apacunanchipaj.» Chaynuypa Tayta Diosninchipa shimin ćharcucächiran. Shiminćhu nin: «Müdanäta jićhunacusha. Mayganpis müdanäta apacunanpäpis surtita jitasha.» Nishannuylla murucucuna rasunpa ruraran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Rusćhu läbarashan lädullanćhu Jesúspa mamanpis ñañantin ricaparcaycaran. Cleofáspa warmin Maríapis, Magdalena marcapita Maríapis ricaparcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chaymi yaćhänacushan purïshijtawan mamanta ricärir, Jesús niran: «Mamallau mama, paymi wawayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Purïshijnintana niran: «Paymi mamayqui.» Chaypita-pacha chay purïshijninga Jesúspa mamanta wasinman pushacuran ricananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chaypita Jesús yarparan: «Llapantana ćharcushcä» nir. Chaymi Tayta Diosninchipa shiminta ćharcucächinanpaj niran: «Yacunaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Juc puyñućhu shigui bïnu wiñaraycaran. Chaymi jirupa puntanman shaputa watarcur bïnuman ushmarcachir, Jesústa shuguchiran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Shugurcur, Jesús niran: «Llapanta ćharcushcä.» Chaynuy nir uysucäcur wañucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Waranin junaj diyawarda captin, Israel runacuna rusćhu wañushcuna läbaränanta mana munaranchu. Chay junajga Pascua fiestapis jallariycaran. Chaymi mandaj Pilatuta niran: «Juclla wañucunanpaj rusćhu läbarajcunapa ćhancanta paquirachinquiman. Ruspita jurgachinquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Auniptin, murucucuna Jesúspa lädunćhu ishcaj läbaraj runapa ćhancancunata paquipariran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesústam ichanga wañushta ricar, mana yataparanchu. Ćhancantapis mana paquiparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Juc murucum ichanga llicllacchun ćhaquinpa tucsiriran. Tucsiriptin, yawarwan yaculla llucshimuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Chaymi ñawïwan ricashäta willacü. Ricashäta rasunpa rimä Tayta Diosninchiman llapanchi sumaj yupachicunanchipaj. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Llapanpis camacaran Tayta Diosninchipa shimin ćharcucänanpaj. Shiminćhu nin: «Juc tullullantapis mana paquingachu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jananmanpis nin: «Tucsishantapis runacuna ricanga.» ");
INSERT INTO qxhNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaypita Arimatea marca José mandaj Pilatuta mañacuran: «Jesústa pampachicushaj» nir. Josépis Jesúspa purïshijnin caran. Ichanga mayur Israel-masincunata manchacushpan mana musyachicuranchu. Mañacuptin, mandaj Pilato auniran. Chaura Jesúspa ayanta pampananpaj José apacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemupis quimsa arüba aya chaquichicuna pirjümita apacurcur, aywäshiran. Nicodemuga ñaupata Jesúswan parlaj chacaypa aywarunaj. Apashan pirjümi caran mïrapita, áloipita. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Israel runacuna pamparashan-jina Joséwan Nicodemo pirjümita murtäjiman pićhuriycur, ayata pituran. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesústa rusćhu wañuchishan ñaupallanćhu murupacuna ćhacra caran. Chayllaćhu runa pampacunanpaj mushuj ućhcu caran. Pitapis manaraj pamparanrächu. ");
INSERT INTO qxhNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Diyawarda junaj jallarinanpaj captin, chay ućhcullaman Jesústa pamparan. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dumingu tuta chaca-chacalla Jesús pamparashanman Magdalena marcapita María aywaran. Pamparashanman ćhayar, chaparaj rumi witiraycajta tariran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chaymi juclla cutircur Simón Pedrutawan Jesúspa yaćhänacushan purïshijninta willaran: «Ayata apacusha. Mayman apacushantapis mana musyanchichu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chaynuy niptin, purïshij-masinwan Pedrupis Jesús pamparashanman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishcan juclla aywarpis, juc-cajga Pedruta llallishpan ñaupata ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ućhcuman watgaycuptin, pitushan bayïta juturaycajllata ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jipanta Simón Pedro ćhayaran. Ruricaman yaycur, paypis pitushan bayïta juturaycajllata ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesúspa uman watashanpis jucläćhu lluylluraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pedro ućhcu rurinman yaycushanpitaraj ñaupa ćhayajpis rurincaman yaycuran. Llapanta ricar, Jesúsman yupachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chay wichan Jesúspa purïshijnincuna Tayta Diosninchipa shiminta mana tantiyacuranrächu. Shiminćhu nin: «Wañushcunapita cawarimunan camacan.» Chaymi pitushan bayïta juturaycajllata tarir, Jesús cawarishanta tantiyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaymi wasiman cuticäriran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maríam ichanga pamparashan puncullanćhu wagaycaran. Wagaräcur, ućhcuman watgaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ricäriptin, ishcay anjil yuraj müdanash caycaran. Juc-caj anjil aya ćhurarashanpa jawananćhu jamaraycaran; juc-cajna jaytacunćhu. Ayam ichanga mana carannachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Anjilcunaga Maríata tapuran: «Mamallau mama, ¿imanirtaj wagaycanqui?» nir. Tapuptin, niran: «Taytä Jesús mana canchu. Ayanta mayman apacushantapis mana musyächu.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Rimayta ushyarcur ticräriptin, Jesús ićhiraycaran. Maríam ichanga Jesústa ricaycashanta mana tantiyacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesúsna tapuran: «Mamallau mama, ¿imanirtaj wagaycanqui? ¿Pitataj ashiycanqui?» nir. Ćhacra aruj runa cashanta yarpar, María niran: «Tayta, ayata maymanpis apash carga, willaycamay, ari. Shuntacushaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesúsna niran: «Maríallau María.» Chaura Jesús caycashanta ricsircurna, niran: «Taytallau tayta.» «Taytallau tayta» ninanta hebreo rimayćhu: «Rabboní» nin. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesúsna niran: «Papänïwan tincuj aywanäta ama mićhämaychu. Paywan manaraj tincurächu. Cananga purïshimajnïcunata Papäninchiwan tincuj aywaycashäta willamuy. Papäninchiga Tayta Diosninchi. Paypa maquinćhu cawanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chaynuy niptin, Jesúspa purïshijnincunata Magdalena María willaj aywariycuran. Tayta Jesústa ricashantapis, imata nishantapis llapanta willaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay junajlla captin, dumingu chacay Jesúspa purïshijnincuna juc wasiman jutucaran. Mayur Israel runacunata manchacur, puncutapis sumaj wićhgaran. Jesúsna ñaupallanćhu ricaripuran: «Allilla juyaycullay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nircur maquintawan llicllacchun ćhaquinta ricachiran. Purïshijnincunana Tayta Jesústa ricaycur, jatunpa cushicuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesúsna yapay niran: «Allilla juyaycäriy. Tayta Diosninchi caćhamashan-jina jamcunatapis caćhacushayqui shimïta willapäcunayquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jinarcur llapanman pücarir, niran: «Espíritu Santupa maquinćhüna cawarcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jamcunapitana shimïta wiyanga. Pipis jucha aparicushanpita wanacuptin, shacyächinqui: ‹Juchayquita Tayta Diosninchipis mayna jungasha› nir. Mana wanacuptinmi ichanga piñapanqui: ‹Juchayquita Tayta Diosninchipis yarparaycanraj› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús ricaripuptin purïshijnin carsi, millish Tomás mana caranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chaymi purïshij-masincuna willaran: «Tayta Jesús ricaripamasha» nir. Tomásna niran: «Rasunpa cawarishanta yupachicunäpaj maquinman läbus yaycushanta ricanä. Yatashäraj. Maquïwanraj llicllacchun ćhaquintapis yatanä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chaypita pusaj junajta wasićhu Jesúspa purïshijnincuna yapay jutucaran. Tomáspis chayćhu caycaran. Puncu sumaj wićhgarash caycaptinsi, Jesús yaycuriran. Llapanpa ćhaupinćhu ricaripuran: «Allilla juyaycäriy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomástana niran: «Tomás, maquïta mä, yatay. Mä, ricay. Llicllacchü ćhaquinpa tucsimashantapis yatay. Ama llutäpacunquinachu. Manchäga cawarimushäta yupachicunquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chayraj jatunpa cushicur, Tomás niran: «Taytallau, Tayta. Cananga Tayta Diosninchi cashayquita yupachicü. Maquiquićhüna caycä.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesúsna niran: «¿Cawarimushäta ricarrächu yupachicunqui? Mana ricaycämar yupachicujcunam ichanga cushicärinman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Chaura purïshijnincunapa ricay ñawinćhu Tayta Diosninchi camacächiyninpa Jesús achcaj jishyaćhucunata allchacächiran. Supaycunatapis jarguran. Cay librućhu mana llapanchu isquirbiraycan. ");
INSERT INTO qxhNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Manchäga Tayta Diosninchipa Wawan Jesús cashanta sumaj tantiyacunanchipaj isquirbishcä. Washäcuj Jesúsman yupachicuptinchi, maquinćhu imaycamanpis cawachimanchi. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaypita Tiberíades püsu cantunćhu Jesús purïshijnincunata ricaripuran. Ricaripushanpita tantiyachishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedrupis, millish Tomáspis, Natanaelpis juturaycaran. Natanaelga Galilea quinran Caná marcapita caran. Zebedeupa ishcan wamrancunapis, ishcaj purïshijnincunapis caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Purïshij-masincunata Simón Pedro niran: «Canan chacay piscädu charij aywä.» Waquinpis niran: «Nuwacunatapis pushamay.» Chaynuy nir bütiman jigarcur llapan aywacäriran. Chay chacayga warayllata piscäduta ashirsi, jucnayllatapis mana chariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pacha wararcuptinna, püsu cantunćhu Jesús ićhiraycaran. Purïshijnincunam ichanga mana ricsiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesúsna jayacuran: «Wawacuna, ¿piscäduta charishcanquichu?» nir. Paycuna niran: «Mana.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesúsna niran: «Bütiquipa dirïcha-caj lädunman ridiquita jitay. Charinquipaj.» Niptin, shiminta wiyacuran. Chay-chica piscäduta chariran. Chutaytapis mana jushnachu. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesúswan yaćhänacuj purïshijna Simón Pedruta niran: «Payga Tayta Jesús.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wiyar, jala paćha-niraj mana cananpaj camsanta ushtucurcur, Pedro yacullanpa Jesústa tariparan. Waquillan piscädun janćhash püsu cantunman ćhayaran. Büti wampuycashanpita püsupa cantuncaman sujta ćhunca sujtawan (66) ricralla caran. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bütipita llucshirir, püsu cantunćhu tullpata tariran. Piscädutawan tantata cancaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesúsna niran: «Charimushayqui piscäduta juc-ishcayllata apamuy.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chaura Simón Pedro bütiman jigarcur, llapan piscäduta püsu cantunman janćhamuran. Jatusajlla paćhac pichga ćhunca quimsawan (153) caran. Chay-chica carsi, ridita mana raćhiranchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesúsna niran: «Miculläshun.» Purïshijnincuna Jesústa ricarsi, tantiyacuyta mana atiparanchu. Chaypis manchacur mana tapuparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesúsna tantata aptacurcur, llapanta aypuran. Piscädutapis aypuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wañushanpita cawarircamur, quimsa cutipana Jesús purïshijnincunata ricaripuran. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micuyta ushyarcur, Juanpa wamran Simón Pedruta Jesús tapuran: «Tayta Simón, ¿waquin purïshimajnïcunapita maschu llaquipämanqui?» nir. Pedruna niran: «Au, Tayta. Llaquipäshajta musyanqui.» Jesúsna niran: «Uysha mallwata michishan-jina wawäcunata sumaj ricay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yapay Jesús tapuran: «Juanpa wamran Simón, ¿llaquipämanquichu?» nir. Pedruna niran: «Au, Tayta. Llaquipäshajta musyanqui.» Jesúsna niran: «Uyshata ricashan-jina wamräcunata sumaj ricay.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Quimsa cutipana Jesús tapuran: «Juanpa wamran Simón, ¿rasunpachu llaquipämanqui?» nir. Chaynuy quimsa cuti tapuptin, Pedro llaquicäcuran. Chaymi niran: «Llapanta musyanqui, Tayta. Llaquipäshajtapis musyanqui.» Jesúsna niran: «Uyshata michishan-jina wamräcunata sumaj ricay. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sumaj tantiyacunquiman. Müsu caycar quiquillayqui müdanayquita ushtucur, quiquillayqui watacurayqui. Munashayquimanpis aywacurayqui. Auquisyar, ricrayquita quiquiqui mashtaptiquipis, jucmi watashunquipaj. Mana munaycaptiquipis, jucläman apashunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pedro imanuypa wañuyman ćhayanantapis, Tayta Diosninchita alliman ćhuranantapis tincuchiyllapa Jesús willaparan. Tayta Diosninchita mana wasguir wañuyman ćhayarsi, Tayta Diosninchita alliman ćhuraran. Jinarcur Pedruta niran: «Llupilläpa jatinquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedruna Jesúspa yaćhänacushan purïshijta ricapaycaran. Paymi Pascua micuyćhu Jesústa jagacushalla tapurunaj: «Tayta, ¿pitaj wañuyman jitarpushunquipaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedruna Jesústa tapuran: «Tayta, yaćhänacushayqui purïshijniqui, ¿imamantaj ćhayanga?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesúsna niran: «Munaptïga, cutimunäcamanpis cawaycangaćhari. Chaypis, ¿imata jucushunqui? Llupilläpa aywanquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesúspa shiminta wiyar, irmänucuna yarparan Jesúspa yaćhänacushan runa imaypis mana wañunanta. Jesúsmi ichanga nish caran: «Munaptïga, cutimunäcamanpis cawaycangaćhari. Chaypis, ¿imata jucushunqui?» ");
INSERT INTO qxhNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesúspa yaćhänacushan runa cashpä cay libruta isquirbishcä. Ricashätapis, wiyashätapis willacur puriycä. Llapantapis rasun-cajta rimä. ");
INSERT INTO qxhNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesúspa willapan achca caycan. Llap-llapanta isquirbiptin, cay pachaćhu papilpis pishinmanmi.");
INSERT INTO qxhNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tayta Teófilo, yapay cartacallämuj. Ñaupata cartacamurä Jesús willacushancunata, rurashancunata musyanayquipaj. Llapanta willacamurä. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Jesús wañushanpita cawarcamur janaj pachaman Tayta Diosninchi shuntacushancaman ćhuscu ćhunca (40) junajcamanraj achca cuti caćhancunata ricaripuran. Paycunata quiquin acracusha. Espíritu Santu yanapaptin, imata rurananpäpis willaparan. Rasunpa cawarishantapis tucuy-jinanpa musyachicuran. Tayta Diosninchipa maquinćhu cawananpäpis sumaj willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Juc junaj caćhancunallawan juturpaycashanćhu Tayta Diosninchi aunishanta yarpächir, Jesús niran: «Espíritu Santu mana charishushayquicaman cay Jerusalén marcapita ama aywacärinquirächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ñaupata Tayta Diosninchipa maquinćhu cawayta munajcunata yacullawan Juan ushyachiran. Ichanga waracunallana Espíritu Santuwan Tayta Diosninchi ushyachishunquipaj shungun munashannuy cawanayquipaj. Mayna llapanta tantiyachishcaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chaura llapan juturpajcuna tapucuran: «Tayta Jesús, jäpa runacunapa maquinpita, ¿cananchuraj Israel marcantïta jishpichimanqui? ¿Imayraj maquiquićhu purichimanqui marcanchi yapay munayniyuj cananpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesúsna niran: «Musyanayqui mana camacanchu. Tayta Diosnillanchi musyan imay junaj camacächinantapis. Munayninćhu caycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sumaj wiyacuy. Espíritu Santu maquinćhu charäshuptiquim ichanga, munayniyuj ricacunquipaj. Shungun munashanta ruranayquipaj yanapäshunquipaj. Nuwapita willapäcunquipaj Jerusalén marcaćhu, Judea quinranćhu, Samaria quinranćhu, chay-tucuy marcacunaćhu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Parlayta ushyarcuptin caćhancuna ricapaycaptillan, Tayta Diosninchi Jesústa shuntacuran. Janaj pachaćhu pucutay chapacurcuran. Mana ricarannachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús janaj pachaman aywacushanta ricaraycaptin, achic-achicyaycaj müdanash ishcaj runa ñaupanćhu ricariparcur ");
INSERT INTO qxhNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","niran: «Galilea runacuna, janaj pachaman ama ricaraynachu. Aywacujta ricashayquinuylla janaj pachapita Jesús cutimungapaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chaypita Jesúspa caćhancuna Ulïbus puntapita Jerusalén marcaman cuticuran. Chay puntapita Jerusalén marcaman pullan lïwalla caran. Chayllata diyawardaćhu Israel runacuna purij. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalén marcaman ćhayaycärir, pacharashan altusman jigaran. Jigaran: Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeupa wamran Santiago, «Marcanpaj nanachicuj» nishan Simón, Santiagupa wamran Judas. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chay wasićhu jutucaj Tayta Diosninchita mañacunanpaj. Jutucaj Jesúspa wauguincunapis, maman Maríapis, waquin warmicunapis. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay junajcuna irmänucuna paćhac ishcay ćhuncawan-ima (120) shuntacaran. Llapan juturpaycaptin, Pedro niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Irmänucuna, Espíritu Santu musyachiptin, mandaj David rimashan ćharcucaycan. Rimashan ćharcucänanpaj Judas Iscariote runacunata pusharan Jesústa charinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasga caran purïshimaj-masinchi, willacäshimaj-masinchi. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chaypis Jesústa wañuyman jitarpusha. Jillayta ćhasquishanwanna juc ćhacrata rantisha. Chayćhu uray-singaypa tunir, wañucurisha. Paćhan pashtaptin, chinchilluncunapis mashtaypa-mashtacaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chayta musyar, Jerusalén marca runacuna chay ćhacrata jutichaparan: ‹Yawar pata› nir. Rimayninćhu: ‹Yawar pata› ninanta: ‹Hakeldamá› nin. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Judaspaj rimar, Salmos librućhu isquirbiraycaran: ‹Wasinpis ragäyächun. Pipis ama tiyachunchu› nir. Juc Salmućhüna nin: ‹Aruyninmanpis jucta ćhurachun.› ");
INSERT INTO qxhNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Chaymi paypa aruyninman juctana ćhurashuwan. Jesúswan puriyta jallaycushanchipita-pacha purïshimajninchicuna caycan. Juan ushyachicushanpita-pacha janaj pachaman Jesús aywacushancaman purïshimajninchicuna cayćhu juturpaycan. Paycunapita jucta acrashun Tayta Jesús cawarishanta willacäshimänanchipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chaynuy niptin, ishcajta acraran. Acraran: «Justo» nishan José Barsabástawan Matíasta. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ishcanta acrarcur, Tayta Diosninchita mañacuran: «Taytallau Tayta, llapanïpa shungüta musyanqui. Maygan acracushayquitapis canan musyaycachillämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Acracushayqui runana willacäshimanga. Purïshimanga. Judasga juchata aparicur, Jesúspa maquinćhu puriycarpis, witicurisha. Chaynuypa shungun apashanman aywacusha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mañacuriycur, surtita jitasha. Jitaptin, surti llucshimuran Matíaspaj. Chaymi Matíaswan ćhunca ishcaywanna (12) Jesúspa caćhancuna caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chaura Pentecostés junaj Jesústa wiyacuj irmänucuna juc pachallaćhu juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Illajpita shucucuy wayra japaraycaj-jina janaj pachapita ćhayamuran. Llapan wiyaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ratataycaj nina-jina raćhicar-raćhicar llapan juturajcunaman aypucaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Espíritu Santu charicurcuptin, juclä marcacunapa rimaynintana llapanpis rimaran. Espíritu Santu rimachishanman-tupulla rimaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chay wichan Tayta Diosninchita manchapacuj Israel runacuna chay-tucuy marcapita sharcamur, Jerusalén marcaćhu juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Shucucuy wayra japaraycajta-jina wiyarga, llapan runa shuntacaran. Ćhayaptin, irmänucuna juclä marcacunapa rimaynincunata rimarcaycaran. Chaura runacuna yarpaćhacuran: «Imaniraj rimayninchita riman, ¿au?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mancharishpan quiquin-pura parlanacäriran: «Cay runacuna, ¿manachu Galilea marcallapita? ");
INSERT INTO qxhNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Juc marcallapita caycar, ¿imanirtaj marcanchi rimashanta riman? ");
INSERT INTO qxhNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Cayćhu juturpaycanchi Partia marcapita, Media marcapita, Elam marcapita, Mesopotamia marcapita, Judea marcapita, Capadocia marcapita, Ponto marcapita, Asia marcapita, ");
INSERT INTO qxhNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia marcapita, Panfilia marcapita, Egipto marcapita, Cirene marca washlänin Libia quinranpita, Roma marcapita. Waquinninchina yurishanchipita-pacha Israel runa canchi. Waquinninchim ichanga jäpa runa caycar, Israel runaman ticrashcanchi. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Waquinninchi Arabia marca quinranpita, Creta marca quinranpita shamushcanchi. Chay-tucuy marcaćhu yurish caycarpis, quiquinchipa shiminchićhu wiyaycanchi munayniyuj Tayta Diosninchi imatapis rurashancunata.» ");
INSERT INTO qxhNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chaymi tantiyacuyta mana camäpacur, quiquin-pura tapunacärisha: «¿Imaraj, au?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Waquin runacunam ichanga ashllir niran: «Chaycuna maćhacäcusha. Ima rimashantapis mana musyanchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chaura Pedro ćhunca jucwan caćha-masincunawan juturpaycashanćhu jatarcur, niran: «Jerusalén runacuna, Israel-masicuna, jäpa runacunapis, sumaj wiyacäriy. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Llutanta yarpaycanqui. Mana maćhashchu carcaycä. Chayraj runacunapis aruj yaycusha. Ćhajćha intipis mana ćhayamunrächu. ¿Imanuypataj maćhash carcaycäman? ");
INSERT INTO qxhNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Manchäga unay willacuj Joel rimashan ćharcuycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Tayta Diosninchi rimachiptin, Joel niran: «Tayta Diosninchi nin: ‹Cay pacha mana ushyacaptillan, Espíritu Santuwan llapan runata charicurcushaj. Wamrayquicuna warmi ullgupis shimïta willapäcunga. Jipashcunatapis, müsucunatapis ricapacachishaj shungü munashäta rurananpaj. Auquincunatapis suyñuyninćhu musyachishaj shungü munashanta. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chay wichan Espíritu Santuta caćhamushaj wiyacamajcunaman. Chaymi paycuna warmi ullgupis shimïta willapäcungapaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cay pacha mana ushyacaptillanraj, janaj pachaćhüpis mana imaypis ricashancunata ricachishaj. Cay pachaćhüpis mana ricashancunata ricanga. Ricangapaj yawarta, ninata, jushtayta. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Inti wañucäcunga. Quilla wañucäcur yawarman ticracuringa. Chaypitaraj Tayta Diosninchi munashanta camacächinga. Chay junaj sumaj manchariypaj canga. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pipis: «Taytallau Tayta, washaycallämay» nir mañacuptin, llapanta Tayta Diosninchi jishpichinga.› » › ");
INSERT INTO qxhNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Israel marca-masicuna, wiyamay. Nazaret marca Jesústa quiquin Tayta Diosninchi acracusha. Pï cashantapis tantiyachimashcanchi. Tayta Diosninchi caćhamushanta tantiyacunanchipaj ricay ñawinchićhu tucuyta Jesús rurasha. Tayta Diosninchi camacächiyninpa runacunata micuchisha. Jishyaćhucunatapis allchacächisha. Wañushcunatapis cawarachisha. Supaycunatapis jargusha. Wayratapis ćhawachisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ichanga Tayta Diosninchi camacächiptin, rusćhu wañuchinanpaj juyu runacunapa maquinman Jesústa ćhurashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wañuchish caycaptinsi, Tayta Diosninchi cawarachisha. Chacaj pachaćhu ushyacänan mana camacaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chaymi unay mandaj Davidpis Jesúspaj yarpar isquirbiran: ‹Imay-imaypis ricay ñawïćhu Washämajnï dirïcha-caj lädunćhu caycan. Yanagämaptin, imatapis mana manchacüchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Manchäga jatunpa cushicü. Cushicuyllawan Tayta Diosninchita alliman ćhurä. Wañucush carpis, jamllaman imaypis yupachicushaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wañushllata chacaj pachaćhu mana jaguiycamanquipächu. Acramashayqui mincayniqui caycaptï, ayä ismunantapis mana camacächinquipächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Alli cawayta tarichimashcanqui. Ricay ñawiquićhu juyar, cushi-cushilla cawashaj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Marca-masicuna, sumaj tantiyacunquiman. Mandaj David unayna wañucusha. Pamparaycan. Pamparashantapis canancaman ricsinchi. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Payga Tayta Diosninchipa willacujnin caran. Willacujnin captin, quiquin Tayta Diosninchi musyachicuran: ‹Juc willcayqui Israel marcapa mandajnin cangapaj› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mandaj David musyachicuran Washäcujta wañushllata chacaj pachaćhu mana jaguinanta, pamparashallanćhu mana ushyacänanta, ayanpis mana ismunanta. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Musyachicushannuylla Washäcuj Jesústa Tayta Diosninchi cawarachimusha. Cawarishtana llapanï ricashcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Janaj pachaman shuntacusha. Alliman ćhurar, mandäshinanpaj jamarashanman jamachisha. Quiquin Jesúspis Tayta Diosninchi camacächiptin Espíritu Santupa maquinćhu car, camacächisha nuwacunatapis Espíritu Santu charimänanpaj. Aunishan-jina llapanïta charicarcamashanta musyanquina. Ñawiquiwan ricarcaycanqui. Rinriquiwan wiyarcaycanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","«Sumaj tantiyacuy. Mandaj David mana janaj pachaman aywashachu. Chaypis quiquin isquirbiran: ‹Tayta Diosninchi Washäcujnïta nisha: «Mandäshimänayquipaj lädüćhu jamacuy ");
INSERT INTO qxhNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","cunćharyuyquicunata pampaman ćhuranäcaman. Nishayqui-nishayqui munashayquita rurachinquipaj.» › ");
INSERT INTO qxhNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Israel-masïcuna, sumaj tantiyacuy. Rusćhu wañuchishayqui Jesústa cawarcachir, Tayta Diosninchi ćhurasha Washäcujninchi cananpaj. Payga Taytanchi caycar, maquinćhu purichimanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chaura llapan runa juyupa llaquicur, Pedrutawan waquin caćhacunata tapuran: «Marca-masicuna, cananga, ¿imatataj ruräman?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedruna llapanta piñapar, niran: «Llapan jucha aparicuypita wanacäriy. Washäcuj Jesúspa shiminta ćhasquicur, ushyacäriy. Chaura Tayta Diosninchi juchayquita jungaycur mana yarparanganachu. Pay camacächiptin, Espíritu Santupis maquinćhu purichishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Espíritu Santu mana nuwacunallatachu maquinćhu purichiman. Manchäga Tayta Diosninchi aunisha llapaniquipis Espíritu Santupa maquinćhu purinayquipaj. Payga maquinćhu purichishunquipaj jamcunatapis, wamrayquicunatapis, Israel runa captiquisi, jäpa runa captiquisi. Pï-maytapis acracushancunata maquinćhu purichinga.» ");
INSERT INTO qxhNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tucuy-jinanpa llapan runata Pedro piñaparan: «Waquin runa juchata aparicullar cawaptinpis, ama juchata aparicuychu. Manchäga ñacaypita jishpicäriy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro willapashanta ćhasquicujcuna quimsa waranga-ima (3,000) caycaran. Chay junajlla ushyacuran. Ushyacur niran: «Ima allish Tayta Diosninchi Washäcuj Jesúswan jishpichimanchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Paycuna Jesúspa caćhancuna willapashanta wiyacuj. Juc shungulla cawaj. Tantata paquipanacur mallichinacärij. Tayta Diosninchita mañacärij. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesúspa caćhancuna Tayta Diosninchi camacächishanta ruraptin, pipis tantiyayta mana atiparanchu. Chaymi llapan runa Tayta Diosninchita manchapacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesústa wiyacuj irmänucuna juc shungulla cawaj. Imancunatapis raquipänacuj. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ćhacrancunatapis, imancunatapis ranticuycur, pishipacushanman-tupulla tarichij. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Waran-waran Tayta Diosninchipa wasinćhu jutucaj. Wasincunaćhüpis shuntacaycur-shuntacaycur cushi-cushilla micupacärij. Juc shungulla cawaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tayta Diosninchita alliman ćhuraj. Chaymi llapan runa alli ñawinpa ricaran. Chaynuypa waranmaylla Jesúspa shiminta ćhasquicuran. Sumaj achcajyaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc junaj mallway intina Pedruwan Juan Tayta Diosninchipa wasinman aywaycaran Tayta Diosninchita mañacuj. Chay üra Israel runacuna Tayta Diosninchita mañacärij. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Cumllu runapis Tayta Diosninchipa wasinćhu «Cuyayllapaj» nishan puncunćhu mañapacuycaran. Payga yuriyninpita-pacha cumllu caran. Chaymi waran-waran yawar-masincuna apaj mañapacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tayta Diosninchipa wasinman Pedruwan Juan ćhayaptin, jillayta mañacuriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mañacuriptin cumllu runata ricapärir, Pedro niran: «¿Ricäramanquimanchu?» ");
INSERT INTO qxhNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chay runa: «¿Aycataraj jillayta jumanga?» nishpan ricaraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedruna niran: «Jillayta mana charächu. Ichanga Nazaret marca Washäcuj Jesúsman yupachicü. Paypa maquinćhu cawä. Paymi yanapäshunqui. Jatariy. Puripacuyna.» ");
INSERT INTO qxhNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chaynuy nir dirïcha-caj maquinpita jatarcachiran. Jatarcachiptin, llapan muguncunapis allchacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ićhishpan puriranna. Wancacaćhar Tayta Diosninchita alliman ćhurar, wasinmanpis yaycuran Pedruwan, Juanwan. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tayta Diosninchita alliman ćhurar purishanta llapan runacuna ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Chaypis tantiyacuyta mana atipar, quiquin-pura tapunacuycaran: «¿Tagay runa manachu ‹Cuyayllapaj› nishan puncućhu mañapacuj? ¿Imanuyparaj puriycanna?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Allchacaj cumllu runa Pedrutawan Juanta mana caćhariranchu. Chaymi runacuna mancharir ricäcunanpaj juclla shuntacaran «Salomón» nishan puncuman. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Runacunata ricar, Pedro niran: «Israel-masicuna, ¿imanirtaj mancharish ricaparcaycämanqui? ‹Alli cayninwanćhi, munayniyuj cayninwanćhi allchacächisha› nir yarpaptiquisi, mana nuwacunachu allchacächishcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","Manchäga Jesúsman yupachicuptin, Tayta Diosninchi allchacächisha. Unaypita-pacha auquillunchicuna Tayta Diosninchita manchapacuj. Auquillunchi Abrahampis, Isaacpis, Jacobpis manchapacuran. Tayta Diosninchi mandu-rurajnin Jesústa alliman ćhurasha. Chaypis jamcuna mandaj Pilato: ‹Jesústa caćhariycushaj› niptin, mana munashcanquichu. Manchäga Tayta Diosninchipa shungun munashanta ruraptinsi, allillata ruraptinsi wasguipashcanqui. Wañuchicuj runata caćhariycachir Tayta Diosninchi caćhamushan Washäcujta wañuchishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Quiquin cawachimajninchita wañuchishcanqui. Wañuchish captiquipis, Tayta Diosninchi cawarachisha. Cawarachishanta ñawïwan ricashcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesúsman yupachicur, cay cumllu runapis allchacasha. Ricay ñawiquićhu ićhiraycan. Cumllu runawan ricsinacunqui. Jesúsman yupachicur llapan ricapaycaptin, allchacasha. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Israel-masicuna, upa cayniquiwan Jesústa wañuchishcanqui. Mayur runacunapis upa cayninwan llapanta camacächisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chaynuypa unay willacujnincunawan Tayta Diosninchi musyachicushan ćharcucasha. Paycuna niran: ‹Washäcuj wañungaraj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","«Cananga Tayta Diosninchita wiyacäriy. Jucha aparicushayquipita wanacäriy. Wanacuptiqui, Tayta Diosninchi juchayquita jungaycur, mana yarparanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Maquinćhu cawaptiqui, shunguyquitapis shacyächinga. Unaypita-pacha aunishan-jina Washäcuj Jesústapis yapay caćhamunga. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cananga janaj pachallaćhüraj Washäcuj Jesús caycan Tayta Diosninchi llapanta camacächishancaman. Chaynuy cananpaj unay acracushan willacujnincunawan musyachicush caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","«Moiséspis auquillunchicunata willapash caran: ‹Jamcunapita nuwata-jina juc willacujninta Tayta Diosninchi acracusha. Paypa shiminta wiyacunqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mana wiyacujcunatam ichanga marcanpita illarachinga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Canan wichanpaj Tayta Diosninchipa unay willacujnin Samuel cashanpita-pacha llapan willacujcuna musyachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nuwanchi-raycur unay willacujnincunawan Tayta Diosninchi shiminta musyachicuran. Nuwanchi-raycur auquillunchicunawan parlanacuran. Auquillunchi Abrahamta niran: ‹Willcayquicunapita jucta acracushaj. Payga llapan runata sumaj yanapanga alli cawananpaj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","«Chaymi acracushan Jesústa cawarircachimur, nuwacunamanraj caćhamusha. Juchaćhu cawashanchipita wanacunanchipaj sumaj yanapämäshun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedruwan Juan runacunata willapaycaptillan, cüracunawan Tayta Diosninchipa wasinta täpajcunapa capitanninpis, saduceucunapis ćhayapuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedruwan Juan yaćhaycächiran: «Cananga quiquin Jesús cawarishan-jina nuwanchisi cawarishun» nir. Chaypita mayur runacuna ullgush ćhayapuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ullgur, charicarcäriran. Pacha chacanaycaptin, warannin tuta tapunanpaj carsilman wićhgaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Waquinmi ichanga Tayta Diosninchipa shiminta wiyar, llapan shungunwan ćhasquicuran. Ullgullata yupaptin, pichga waranga-yupay (5,000) yapacaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Chaura pacha wararcuptin, Jerusalén marcaćhu shuntacaran mayur cüra Anás, mandäshij-masin Caifáswan, Jonatánwan, Alejandruwan. Shuntacaran waquin mayur runacunapis, Moiséspa shiminta yaćhajcunapis. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jinarcur Pedrutawan Juanta carsilpita jurgarcachimur, dispächunćhu tapupäcuran: «¿Pipa munayninwantaj allchacächishcanqui? ¿Pitaj caćhamushcashunqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Chaura Espíritu Santu rimachiptin, Pedro niran: «Tayta cüracuna, Tayta mayur runacuna, sumaj wiyaycallämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Canan allita rurar, cay cumllu runata allchacächishäpita tapuparcaycämanqui. Imanuy allchacächishätapis musyayta munarcaycanqui, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Israel-masicuna, llapaniqui musyanayquipaj willashayqui. Cay cumllu runata Nazaret marca Jesucristu camacächiyninpa allchacächish caran. Jesústa rusćhu wañuchishcanqui. Tayta Diosninchim ichanga cawarachisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesúspaj tincuchiypa isquirbiraycan: ‹Wasi rurajcuna: «Cay rumi mana allichu» nir wicapashantapis Tayta Diosninchi simintuta jallarachinanpaj ćhurasha› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Tayta Diosninchi Jesúsllata washämänanchipaj ćhurasha. Cay pachaćhu juc mana canchu jishpichimänanchipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chaura Pedruwan Juan liguiyta sumaj mana yaćharpis mana manchacullar willapäcuptin, mayur Israel runacuna äyacash ricacuran. Jesúswan purishantapis tantiyacuriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Cumllu runapis allchacashana Pedruwan Juanwan ićhiraptin, mayur runacuna ima ruraytapis mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chaura Pedrutawan Juanta dispächunpita wajtaman jargurir, quiquin-puralla parlanacuran: ");
INSERT INTO qxhNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«¿Cay runacunata imanäshuntaj? Jerusalén marca runacuna musyanna Tayta Diosninchi camacächiyninpa cumllu runata allchacächishanta. Chapaytapis mana camäpacunchichu. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ichanga chay Jesúspita wacćhu-cayćhu mana willacunanpaj sumaj ullgupäshun. Mancharachishun pitapis mana willapänanpaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jinarcur wajtapita jayarcachir, Jesúspa caćhancunata änir sumaj ullgüparan. Ullgüparan Jesúspita mana willacunanpaj, mana tantiyachicunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ullgüpaptin, Pedruwan Juan niran: «Taytacuna, sumaj wiyacäriy. Tayta Diosninchipa shiminta jungaycur jamcunapa shimillayquita ruraptï, mana allichu canman, ¿au? ");
INSERT INTO qxhNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jesúswan purishcä. Chaymi ricashäta, wiyashäta pï-maytapis willapänä. Mana upällacushäpächu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Chaynuy niptin juchanta mana tarir, Pedrutawan Juanta mayur runacuna ullgüparillar caćhariycuran. Ullgüpash carsi llapan runa Tayta Diosninchita alliman ćhuraptin, mana wascaranchu. Cumllu runa allchacäcushanpita runacuna Tayta Diosninchita alliman ćhuraycaran. Allchacaj runa ćhuscu ćhunca (40) wata-imatana aywaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chaura mayur runacuna caćhariycuptin, Pedruwan Juan irmänucuna juturashanman cuticuran. Ćhayarcur, mayur cüracuna, mayur runacuna ullgüpashanta willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Willapashanta wiyaycur, juc shungulla Tayta Diosninchita mañacuran: «Taytallau Tayta, munayniyuj canqui. Llapanta camaj canqui. Cay pachatapis, janaj pachatapis, lamar yacutapis, llapan ima-aycacunatapis camashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tayta, Espíritu Santu musyachiptin, mandu-rurajniqui Davidpis niran: ‹¿Imanirraj may-chayćhüpis runacuna ullgucäcun? ¿Imanirraj ticrapunanpaj parlanacun? ");
INSERT INTO qxhNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Llapan jatun mandajcuna parlanacushana. Auturdäcunapis jutucushana. Llap-llapanmi Tayta Diosninchitapis, acracushan Washäcujtapis ticrapuyta yarpaycan.› ");
INSERT INTO qxhNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Cananga mandaj David musyachicushan änir ćharcucaycan. Acracushayqui Jesústa Washäcuj cananpaj ćhuraptiquisi, mandaj Herodes, mandaj Poncio Pilato, llapan jäpa runacuna, Israel runacuna chiquipacurcusha. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chaynuypa paycuna unaypita-pacha camacächishayquita ćharcucächisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tayta, cananga ricay ñawiquićhu llapan mayur runacuna manchaycächiman. Chiquimaptinsi, mana manchacullar shimiquita willapäcunäpaj yanapaycallämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Munayniyuj cashayqui musyacänanpaj yanapaycallämay. Yanapaycallämay acracushayqui Jesúspa camacächiyninpa imatapis ruranäpaj, jishyaćhucunatapis allchacächinäpaj, supaycunatapis jargunäpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tayta Diosninchita mañacuyta ushyarcuptin, juturashan wasi sicsicyasharaj. Chaura llapaninta Espíritu Santu maquinćhu charaptin, mana manchacullar Tayta Diosninchipa shiminta willacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Chaymi chay-chicaj irmänucuna carpis, juc yarpaylla cawaj. Imallata charashantapis llapanin raquipänacärij. Juc shungulla cawaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Espíritu Santu yanapaptin, Jesúspa caćhancuna sumaj musyachicuycaran Taytanchi Jesús cawarimushanta. Llapan irmänucunatapis llaquipashpan Tayta Diosninchi sumaj yanaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mayganinpis pishipacuyćhu mana cawananpaj ćhacrancunata, wasincunata ranticuycur, ");
INSERT INTO qxhNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesúspa caćhancunapa maquinman ćhuraran. Paycunana pishipacushanman-tupulla aypuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Chipre marca Josépis ćhacranta ranticuran. Payga Levípa yawar-masin caran. Ćhacranpa ćhaninta llapanta Jesúspa caćhancunapa maquinman ćhuraran. Paycuna Joséta jutichaparan: «Shacyächicuj» nir. «Shacyächicuj» ninanta: «Bernabé» nin. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Warmin Safirawan Ananíaspis ćhacranta ranticuycur, llutanta ruraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sumaj parlanacurir, ćhacranpa ćhaninta puchuchicuran. Waquillanta Jesúspa caćhancunapa maquinman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chaura waquillanta ćhayachishanta musyar, Pedro tapuran: «Ananías, ¿imanirtaj Supay maquichacushunayquita aunishcanqui? ¿Imanirtaj Espíritu Santuta llullapaycanqui? ¿Imanirtaj: ‹Ćhacräpa ćhaninta llapanta apamushcä› nir waquinta puchuchicushcanqui? ");
INSERT INTO qxhNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ćhacrayqui quiquiquipa casha. Ćhacrayquipa ćhaninpis quiquiquipa casha. Quiquiquipa caycaptin, ama llullacunquimanchu caran. Mana nuwatachu llullapämashcanqui. Manchäga quiquin Tayta Diosninchita llullapashcanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Nishanta wiyar, Ananías wañucäcusha. Müsucuna yaycurcur, ayanta pituran. Jinarcur pampaycäriran. Ananías wañucäcushanta mayar, llapan runa juyupa manchapacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chaypita ishcay-quimsa ürata Ananíaspa warmin Safirapis ćhayaran. Payga runan wañushanta mana musyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ćhayaptin, Pedro tapuriran: «¿Rasunpachu majayqui willamashanuylla ćhacrayquita ranticushcanqui?» nir. Chaura Safira niran: «Au, chayllaćhümi ranticushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedruna niran: «¿Imanirtaj majayquiwan parlanacushcanqui Espíritu Santuta llullapänayquipaj? Majayquita pampaj müsucuna yaycaycämunna. Jamtana pampaj apacushunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Niycaptillan, Pedrupa ricay ñawinćhu Safira wañucäcuran. Müsucuna ćhayar, wañushta tariran. Wañushta tarir, apacuran majanwan jaganacushllata pampaycärinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ananíaswan Safira wañushanta mayar, jutucaj irmänucunapis, mana irmänucunapis sumaj mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesúspa caćhancuna Tayta Diosninchi camacächiptin, runacunata sumaj yanaparan. Ricashanta tantiyayta mana atiparsi, runacuna sumaj cushicäriran: «Tayta Diosnillanchi chay-niraj jishyaćhucunata allchacächin» nir. Irmänucunapis Tayta Diosninchipa wasinman yaycur, Salomónpa puncunćhu jutucaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Waquin runacuna irmänucunata alli ñawinpa ricarsi, tallupayta manchacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chaynuy captinsi, warmi ullgupis waran-waran Tayta Diosninchipa shiminta ćhasquicuran. Payman yupachicuran. Ćhasquicujcuna achcajmi yapacaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","16","Jerusalén marcaćhu Pedro puriptin, mashtacuntinta, jirgantinta jishyaćhucunata wajtaman jurguran: «Pedrupa llantuyllanwansi allchacangam» nir. Chimpan marcacunapitasi chay-chicaj shuntacaran. Apamuran jishyaćhucunata, supay pucllacushan runacunata. Jesúspa caćhancuna llapallanta allchacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chaura mayur cürawan achcaj saduceucunapis juyupa ullgucaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chaymi Jesúspa caćhancunata charicurcur, carsilman wićhgachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wićhgaraycächiptin, Tayta Diosninchi caćhamushan anjil chacaypa ćhayar, carsil puncuta quićhariran. Jesúspa caćhancunata jurgurir, niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Tayta Diosninchipa wasinman ayway. Llapan runata sumaj willapay Tayta Diosninchipa maquinćhu cawananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Warannin tuta anjil nishannuylla Jesúspa caćhancuna Tayta Diosninchipa wasinman yaycurir, llapan runata willapaycaran. Chaycaman yanapajnincunawan mayur cüra jayachiran llapan mayur Israel runacunata sisyunta rurapäcunanpaj. Jinarcur: «Jesúspa caćhancunata apamuy» nir carsilman caćharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Carsilman ćhayarmi ichanga, Jesúspa caćhancunata mana tariranchu. Chaymi cutircur, willaran: ");
INSERT INTO qxhNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Taytacuna, carsil puncuta sumaj wićhgaraycajta tarishcä. Puncućhüpis täparcaycasha. Puncuta quićharirmi ichanga, rurićhu pitapis mana tarishcächu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chaura Tayta Diosninchipa wasinta täpaj murucucunapa capitanninwan mayur cüracuna: «¿Imaraj canga, au?» nir mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Upatash caycaptin, juc runa ćhayaran: «Carsilman wićhgachishayqui runacuna Tayta Diosninchipa wasinćhu carcaycan. Runacunata willapaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chaynuy niptin, Tayta Diosninchipa wasinta täpajcunapa mandajnin murucuncunata pushacurcur, Tayta Diosninchipa wasinman aywaran Jesúspa caćhancuna ashij. Tarirga, mana yatapällar aparan: «Runacuna sajmaramäshun-ima» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Llapan mayur Israel runacuna juturpashanman ćhayachiptin, mayur cüra niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Rinriquićhu willaraj chay Jesúspa shiminta mana willapäcunayquipaj. Rinriquićhu willaycaptï, ¿imanirtaj mana wiyacamashcanquichu? Cananga Jerusalén marcaćhu llapan runata tantiyachishcanqui. Jinarcurpis jitapaycämanqui: ‹Paycuna Jesústa wañuchisha› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chaura caćha-masincunawan Pedro niran: «Jamcuna mana munaptiquisi, Tayta Diosninchita wiyacunä. Runapa shiminta mana wiyacümanchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jamcuna rusćhu wañuycachiptiquisi, unay auquillunchicuna manchapacushan Tayta Diosninchi Jesústa cawarachimusha. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jinarcur dirïcha-caj lädunman ćhurasha mandäshinanpaj. Jesústa ćhurasha maquinćhu cawachimänanchipaj, washämänanchipaj. Chaymi Israel runacuna wanacuptin, jucha aparicushantapis jungaycur mana yarparanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Rimashäta musyä. Espíritu Santupis musyan. Paypa maquinćhümi llapan wiyacujcunata Tayta Diosninchi purichin.» ");
INSERT INTO qxhNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chaynuy niptin, sisyun ruraj mayur Israel runacuna juyupa ullgucaycäriran. Jesúspa caćhancunata wañurachiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mandaj-masin Gamalielmi ichanga wañuchinanta mićharan. Payta fariseu runa captin, yaćhaj captin, llapan Israel runacuna alli ricaran. Paymi Jesúspa caćhancunata wajtaman jurgurachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jurguriptin, llapan mayur Israel runa-masincunatana niran: «Taytacuna, cay runacunata imatapis ruranayquipaj sumajraj yarpaćhacunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Teudaspa willapanta musyanqui, ¿au? Payga: ‹Mandaj cä› nirshi auturdäcunata ticrapuran. Maquinćhüpis ćhuscu paćhac (400) runatash purichiran. Chay Teudasta wañuycachiptinshi ichanga, mashtaypa-mashtar jatirajnincuna aywacäriran. Llapallan illaricäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jipatapis llapan runata yupachishan wichanshi Galilea marcapita Judas auturdäcunata ticrapuran. Payta achcaj runash jatirpararan. Judasta wañuycachiptinshi ichanga, llapan mashtaypa-mashtar aywacäriran. Llapallan illaricäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Taytacuna, sumaj wiyaycallämay. Cay runacunata imatapis ama rurashunchu. Imata ruracuptinpis, ama mićhäshunchu. Umallanpita jurgurcur willapäcuptin, jungacaypa aywangapaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tayta Diosninchipa shiminta willacuptinmi ichanga, imanuypa jungacächiyta munarpis, mana camäpacushunpächu. Chaymi sumaj yarpaćhacushun. Tayta Diosninchita ima chapatapis rurarushuwan.» Gamaliel piñacuptin, llapan mayur Israel runa-masincuna wiyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chaypita Jesúspa caćhancunata yapay ruriman jayachiran. Jinarcur sumaj wascarillar, caćhariycuran: «Cananpita shimiquita amucuy. Jesúspita ama willacunquinachu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesús-janan wascaptinsi, pampaman ćhuraptinsi, cushicuran. Sisyunpita mayur Israel runacuna ricapaycaptin, cushishallana llucshicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mićhaycaptinsi, Jesúspa caćhancuna Tayta Diosninchipa wasinćhüpis, wasicunaćhüpis waran-waran willapäcuran: «Jesúsga Washäcujninchi. Payta Tayta Diosninchi caćhamusha jishpichimänanchipaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay wichan Tayta Diosninchipa shiminta ćhasquicujcuna sumaj achcayaran. Ichanga hebreo rimaj irmänucunawan griego rimaj irmänucuna micuy-janallan ticshaparänacuran. Hebreo rimaj irmänucunata jamurparan: «Waran-waran griego biyüdacuna ichic-ichicllata micuyta ćhasquiycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chaymi Jesúspa ćhunca ishcaywan caćhancuna llapan irmänucunata jayarcachir, niran: «Jamcunapa paćhayquita, janayquita ricallar cawanä mana camacanchu. Tayta Diosninchipa shiminta willacunäpaj mana atipashänachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Irmänucuna, chaymi janćhis runata acray. Alli ricashcunata, Espíritu Santupa maquinćhu cawajcunata, yarpay-sapacunata acray. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nuwacuna Jesúspa shiminta willapäcullar, Tayta Diosninchita mañacullar cawashaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chaynuy niptin, llapan auniran. Chaymi janćhista acraran. Acraran Estebanta. Payga llapan shungunwan Tayta Diosninchita wiyacuj. Espíritu Santupa maquinćhu cawaj. Chaynuypis acraran Felipita, Prócoruta, Nicanorta, Timónta, Pármenasta, Nicolásta. Payga Antioquía runa caycarpis, Israel runaman ticraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Janćhis runacunata acrarcur, Jesúspa caćhancunaman pusharan. Jesúspa caćhancunana maquinta umanman ćhuraycur paycunapaj mañacuran: «Taytallau Tayta, cay runacuna aruyninta ćharcunanpaj yanapaycullay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chaura Tayta Diosninchipa shiminta willacuptin, Jerusalén marcaćhu Tayta Diosninchipa shiminta ćhasquicujcuna achcayaycaran. Tayta Jesúsmanna yupachicuran. Israel cüracunapis achcajmi payman yupachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanta Tayta Diosninchi llaquipar, alli ricaran. Sumaj yanaparan. Maquinćhu purichir, Tayta Diosninchi ruranantapis musyachicuran. Llapanpa ricay ñawinćhu munashantapis camacächiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chaypis waquin runacuna Estebanta ticrapuran. Ticrapuran Cirene runacuna, Alejandría runacuna, Cilicia runacuna, Asia runacuna. Paycuna Israel runa caran. Jutucaj «Caćharishcuna shuntacäna wasi» nishanćhu. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Espíritu Santu yanapaptin, Esteban yarpay-sapa caran. Chaymi tincupajcuna imata rimarpis, Estebanta mana ićhipuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chaymi jillayta juycur, llullacujcunawan tumpachiran: «Esteban Tayta Diosninchitapis, Moiséstapis pampaman ćhuraycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chaynuy niptin, llapan runa ullgucaycäriran. Ullgucaycäriran mayur runacunapis, Moiséspa shiminta yaćhajcunapis. Ullgur, mayur Israel runacunapa sisyunninman Estebanta aparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tumpajcunatapis pusharan. Tumpacujcuna niran: «Cay runa Tayta Diosninchipa wasintapis, Moiséspa shimintapis pampaman ćhuraycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tayta Diosninchipa wasintapis Nazaret marca Jesússhi jućhurachinga. Moiséspa shimintapis jungaycachingash. Llapantapis quiquinpa shiminpita musyanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chaura llapan mayur Israel runacuna ricapäriptin, anjilpa jajllan achic-achicyashan-jinaraj Estebanpa jajllan achic-achicyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chaura mayur cüra Estebanta tapuran: «¿Rasunpachu juchayqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estebanna niran: «Israel-masicuna, taytacuna, tantiyacunquiman. Musyashanchinuypis auquillunchi Abraham Mesopotamia quinranćhu tiyaycaptillan Jarán marcaman manaraj aywaptillanshi, munayniyuj Tayta Diosninchi ricaripuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ricaripaycurshi, niran: ‹Marcayquita, yawar-masiquicunata jaguiycur, ricachinaj ćhacraman aywacuy.› ");
INSERT INTO qxhNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chayshi Caldea quinranpita Jarán marcaman Abraham aywacuran. Chay marcaćhu tiyaycaptinshi, papänin wañucuran. Chaypita cay marcamannash Tayta Diosninchi Abrahamta pushamuran. Chay marcaćhüna cawanchi. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","6","Cayman ćhayachimurpis, quiquinpaj ćhacrata manash ricachiranchu. Mana ricachirpis Abrahampa wamran mana captillan, willcancunata ćhacrata junanpaj Tayta Diosninchi auniran. Willcancunapis jäpa marcaćhu ćhuscu paćhac wata (400) jurpay-tucullar juyänanpaj musyachiran: ‹Willcayquicunata jäpa runacuna sumaj ñacachinga. Maquillanćhu purichinga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jananmanpis Tayta Diosninchi niran: ‹Ñacachicuj runacunata marcantinta sumaj ñacachishaj. Chay marcapita shacamurmi ichanga, willcayquicuna taytachacamar alliman ćhuramanga.› ");
INSERT INTO qxhNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nircur parlanacushan mana jungacänanpaj Abrahamta jïrucachiran. Chayshi Abrahampis ullgu wamran Isaacta churiyäcur, pusaj junajyujllata jïruran. Isaacpis ullgu wamran Jacobta jïruran. Jacobpis ullgu wamrancunata jïruran. Jacobpa ćhunca ishcaywan (12) ullgu wamrancuna cashanman-tupu Israel runacunapis ćhunca ishcaywan marca. Auquillunchicuna Jacobpa ćhunca ishcaywan wamrancunapita miraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Auquillunchi Jacobpa wamrancunana chiquicuywan Egipto marcaman shullcan Joséta ranticaycäriran. Juclä marcaman ranticuptinsi, Tayta Diosninchi Joséta mana caćhariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Egipto marcaćhu sumaj ñacachiptinsi, washaran. Yaćhaj-sapa cananpaj yanaparan. Yarpay-sapa captinshi, Egipto marca mandaj Faraón Joséta alli ricaran. Chayshi Egipto marcacunatapis, wasi ruraynincunatapis Josépa maquinman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Chay wichanshi Egipto marcaćhüpis, Canaán marcaćhüpis mućhuy captin, juyupa ñacaran. Auquillunchicunapis paćhanpaj pishiptin, juyupa yargaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chaura Egipto marcaćhu micuy juturashanta mayar, micuy rantij wamrancunata Jacob caćharan. Chayräshi auquillunchicuna Egipto marcaman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Auquillunchicuna yapay micuy rantij cutiptinshi ichanga, José ricsichicuranna: ‹Wauguiquim caycä› nir. Chaynuypash mandaj Faraónpis Josépa yawar-masincunata ricsicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chaypita Egipto marcaman papänin Jacobta, llapan yawar-masincunata José jayachiran. Chayshi janćhis ćhunca pichgajwan (75) Israel-masinchicuna Egipto marcaman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chaynuypash Jacob Egipto marcaćhu tiyacuran. Jinallanćhu Jacobpis, auquillunchicunapis wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tulluncunatash ichanga Siquem marcaman apaycur-apaycur pamparan. Siquem ćhacrata Hamorpa wamrancunapitash auquillunchi Abraham jillaywan rantish caran llapan yawar-masincuna pampacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Abrahampa willcancunata jishpichimunanpaj Tayta Diosninchi aunishan wallcana pishiptin, Egipto marcaćhu yawar-masinchicuna sumaj achcayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chay wichanshi Egipto marca juc runapa maquinćhu caycaran. Payga José pï cashantapis mana musyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chayshi auquillunchicunata llullaparcur-llullaparcur aruchiran. Ñacachiran. Ullgu wamrancunatapis yurircuptillan, wicapachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Moiséspis chay wichanshi yuriran. Payta sumaj camarajlla captin, maman-taytan pacayllapa uywacuran quimsa quillacaman. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chaypita jaguiycushallanta mandaj Faraónpa jipashnin tarir, wamrachacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chaynuypash Moisés Egipto runacunapa yarpashanta yaćhacuran. Yarpay-sapayar, imatapis alli ruraran. Alli rimaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Moisés ćhuscu ćhunca (40) watata aywaycarnash, Israel-masincunawan tincuyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Watucuj ćhayaptin, juc Egipto runa Moiséspa marca-masin Israel runata magaycaran. Payta washashanćhüshi Egipto runata Moisés wañuycachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Marca-masinta washar, Moisés yarparan: ‹Israel-masïcuna ñacaypita jishpichinäpaj Tayta Diosninchi caćhamashanta tantiyacungaćhi› nirshi. Chaynuy yarpaptinsi, Israel-masincuna mana tantiyacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chaypita Egipto runata wañuchishan warannin Israel-masincuna quiquin-purana maganacurcaycaran. Paycunata raquirshi, Moisés piñacuran: ‹¿Imanirtaj maganacurcaycanqui Israel-masilla caycar?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Chaura magacuj runa Moisésta tangariycuran: ‹Raquimänayquipaj, ¿pitaj canqui? Mana maquiquićhüchu juyaycä. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Nuwatapis wañuchimaytachu munaycanqui? Egipto runataćhi janyan wañuchirayqui› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chaynuy niptinshi, Madián marcaman Moisés jishpicuran. Chay marcaćhu jurpay-tucullar juyaycashanćhüshi ishcay ullgu wamranta churiyäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ćhuscu ćhunca (40) watapitanash chunyaj Sinaí punta quinranćhu Moisésta Tayta Diosninchi ricaripuran ratataycar shira-shiraćhu. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ricaripuptin, manchapayllapa Moisés aywapuran. Yaycapuycaptinshi, Tayta Diosninchi nimuran: ");
INSERT INTO qxhNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Unay auquilluyqui Abrahampa, Isaacpa, Jacobpa Tayta Diosnin caycä. Paycuna manchapacamaranmi.› Chayta wiyarshi, Moisés manchariywan sicsicyaran. Ricäriytapis manchacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tayta Diosninchina niran: ‹Ićhirashayqui pacha nuwapam. Llanguiquita llushtiy. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egipto runacuna Israel wawäcunata ñacachishanta ricashcä. Llaquicuywan mañacamashantapis wiyashcä. Chaymi jishpichinäpaj yarpamushcä. Canan sumaj wiyacamay. Egipto marcaman caćhashayqui.› ");
INSERT INTO qxhNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Yawar-masincuna Moisésta: ‹Mana maquiquićhüchu juyä› nir wasguipash caycaptinsi, shira-shiraćhu ricaripaycur Tayta Diosninchi caćharan Israel-masincunata maquinćhu purichinanpaj, jishpichinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Unayllatana Moisés Israel runacunata Egipto marcapita rasunpa jishpichisha. Ćhuscu ćhunca (40) watantin Tayta Diosninchi camacächiyninpa sumaj yanapasha Egipto marcaćhüpis, Puca yacu püsućhüpis, chunyaj pachaćhüpis. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Israel-masincunatana Moisés niran: ‹Jamcunapita nuwata-jina juc willacujninta Tayta Diosninchi jatarachinga.› ");
INSERT INTO qxhNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Chunyaj pachaćhüshi Israel-masinchicunawan Moisés juturpaycaran. Sinaí puntaćhu Tayta Diosninchi llapan yarpashanta Moisésta willaparan. Moisésna auquillunchicunata willaparan. Paypa shiminta pipis wiyacur, alli cawayta tarinan caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Auquillunchicunash ichanga wiyaytapis mana munaranchu. Wasguiparirshi, Egipto marcaman cuticuyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chayshi Aarónta niran: ‹Egipto marcapita jurgamajninchi Moisés, ¿mayparaj aywacusha? Illaricusha. Juctana manchapacushun pusharämänanchipaj. Yaya jircaman ricchacujta rurapämay.› ");
INSERT INTO qxhNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chaynuy niptin, manta türituman ricchacujta rurapuran. Rurashan manta türitutapis manchapacur, uywacunata jararan. Rurashan ushyapayninta tünapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chayshi Israel runacunapita Tayta Diosninchi witicuriran. Camacächiran intillaman, quillallaman, istrïllacunallaman manchapacunanpaj. Jipata willacujnincunawan piñacachir, musyachicuran: ‹Israel runacuna, ćhuscu ćhunca (40) wata chunyaj pachaćhu puriycarpis, uywacunatapis, cuyachicuyniquitapis mana jaramashcanquichu. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Manchäga yaya jirca Molocta manchapacur, capillantinta yaya Molocman ricchacujta matancashcanqui. Yaya jirca Refántapis manchapacur, istrïllaman ricchacujta jipirpashcanqui. Manchapacunayqui-cashan yaya jircaman ricchacujcunata rurashcanqui. Chaypitam Babilonia marca wajta quinranman jargushayqui› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Chunyaj pachaćhüpis unay auquillunchicuna purichina jiru ćhaqui capillata purichiran Tayta Diosninchiwan ricanacunanpaj. Capillata Moisés ruraran Tayta Diosninchi tantiyachishannuylla. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Josuépis auquillunchicunapa capillanta matancash ćhayachiran Tayta Diosninchi acrashan ćhacraman. Acrashan ćhacraman yaycuptinshi, llapan jäpa runacunatapis Tayta Diosninchi jarguran. Marca-masinchicunapis mandaj Davidpa maquinćhu cawashan wichancamanshi purichina jiru ćhaqui capillata chararäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mandaj Davidwan Tayta Diosninchi sumaj yaćhänacuran. Chayshi David tapuran: ‹Taytallau Tayta, ¿Jacobpa willcancuna jarashunayquipaj wasiquita rurämanchu?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Munaptinsi, mandaj Davidpa wamran Salomónräshi Tayta Diosninchipa wasinta rurachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Llapanta Camaj Tayta Diosninchim ichanga mana runa rurashan wasicunaćhüchu tiyan. Chayshi juc willacujta musyachir, Tayta Diosninchi unayna niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Janaj pacha jamanä. Cay pacha ćhaquïta ćhurarächinalläpaj. Chaynuy caycaptin, ¿wasita rurapämanquimanchuraj? ¿Tiyanäpaj camacächinquimanchuraj? ");
INSERT INTO qxhNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mana. Quiquï llapantapis camashcä.› ");
INSERT INTO qxhNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Tayta cüracuna, jamcuna auquilluyqui-jina rumi shungu canqui. Upa canqui. Tayta Diosninchipa wawan caycarpis, mana wiyacunquichu. Juchallaćhu arunqui. Wiyacunayquipaj Espíritu Santu shacyächishuptiquipis, wasguipanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Auquilluyquicunapis: ‹Tayta Diosninchipa shungun munashallanta ruraj runa shamunga› nir willacuptin, llapan willacujcunata wañuchiran. Tayta Diosninchi acracushan runa, änir ricarimuptin, ticrapur wañuycachishcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Unaypis caćha-anjilnincuna Tayta Diosninchipa shiminta willapäcuran. Chay willapata musyarpis, wasguipashcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chaura Estebanpa shiminta wiyar, mayur Israel runacuna chigaypa ullgur, sijćhicurcuranraj. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebannam ichanga Espíritu Santu maquinćhu charaptin, janaj pachaman ricärishanćhu Tayta Diosninchi achic-achicyaycämujta, Jesúspis dirïchan lädunćhu ićhiraycämujta ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ricar, wiyacächipaypa niran: «Mä ricay. Janaj pachapa puncun quićharaycämun. Caćhamushan Jesústapis, Tayta Diosninchita-ima ricaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Niptin, wiyayta mana munar, rinrintapis chapacarcäriran. Japarir, Estebanta llapan aćhcucarcäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Marca wajtanman jurgurir, sajmar ushyaran. Tumpar ñauquijcunapis Estebanta sajmananpaj punchunta paytacuran müsu Sauluman. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sajmaycaptin, Esteban mañacuran: «Tayta Jesús, shuntacallämay, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jungurpacuycur japariypa niran: «Tayta, cay runacunapa juchanta ama yarparaychu.» Nircur, wañucäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Estebanta wañuycachiptin, Saulupis aunir cushicuran. Chay junaj Jerusalén marcaćhu jutucaj irmänucunata runacuna chiquicarcäriran. Tucuy-jinanpa jaticaćhar ushyaran. Irmänucunana mashtaypa-mashtar jishpicäriran Judea quinranpa, Samaria quinranpa. Jesúspa caćhancunam ichanga Jerusalén marcallaćhu juyaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Waquin Tayta Diosninchita manchapacuj runacunana Estebanpa ayanta pampaycäriran. Llaquicuywan sumaj wagaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulumi ichanga jutucaj irmänucunata wasin-wasin jaticaćharan. Charir, warmitapis, ullgutapis janćhacurcur carsilman aparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalén marcapita jishpij irmänucuna may-chaymanpis aywacuran Jesúspa shiminta willacuraycar. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipipis Samaria marcaman ćhayar, Washäcujpita willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Achcaj runa wiyacäriran. Tayta Diosninchi camacächishanta Felipe ruraptinpis, cushish juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tucuy-niraj jishyaćhucunata, cumllucashcunata, wijrucunata, supay pucllacushancunata Felipe allchacächiran. Jarguptin, supaycuna japarpaycar jishpicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chaynuypa Samaria marcaćhu llapan runa sumaj cushicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chay marcaćhu Simónpis caycaran. Payga chapata rurar unaypita-pachana llapan Samaria runata riguichiran: «Musyapacuj cä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","«Musyapacuj cä» niptin, runacuna llapan-yupay shiminta wiyacuran. Warmi ullgupis niran: «Cay runa rasunpa Tayta Diosninchipa maquinćhu cawan. Munayninwan imatapis ruraycan.» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Unaypita-pacha Simónpa shiminta runacuna wiyacuran musyapacuj cayninwan riguichiptin. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipim ichanga tantiyachicuran: «Tayta Diosninchi shuyaraycämanchi. Maquinćhu cawashun. Washäcuj Jesúspis jishpichimänanchi-raycur wañuyman ćhayasha» nir. Chaura shiminta ćhasquicur, warmi ullgupis ushyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Quiquin musyapacuj Simónpis Jesúspa shiminta ćhasquicur, ushyacuran. Felipe jishyaćhucunata allchacächir, supaycunata jargur, tucuy-jinanpa Tayta Diosninchi munayniyuj cashanta musyachicuycaran. Chaymi Simónpis cushish ricaparan. Mana caćhariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria runacunapis Tayta Diosninchipa shiminta ćhasquicushanta mayar, Jesúspa caćhancuna Jerusalén marcapita Pedrutawan Juanta caćharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paycuna Samaria marcaman ćhayar, llapan irmänucunapaj mañacapuran Espíritu Santupa maquinćhu cawananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Samaria marcaćhu irmänucunata Tayta Diosninchipa maquinćhu purinanpaj Espíritu Santu manaraj chariranrächu. Manchäga Jesúspa maquinćhu cawayta munar, ushyacushalla caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chaymi irmänucunapa umanman maquinta ćhuraycur: «Tayta, cay runacunata yanapaycullay» nir Pedruwan Juan mañacuptin, Espíritu Santu charicurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jesúspa caćhancuna runacunapa umanta yataycur mañacuptin, Espíritu Santu charicurcushanta musyapacuj Simónpis ricaran. Chaymi jillayta munachiran: ");
INSERT INTO qxhNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Munayniquita nuwatapis ranticaycallämay. Nuwapis runapa umanta yataycuptï, Espíritu Santu charicurcunanta munä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedruna niran: «Jillaynintiqui ñacayman ayway. Tayta Diosninchi jaramashanchita mana ranticunchichu. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tayta Diosninchi shunguyquita musyaraycan. Juchallapaj yarparaycanqui. Chaymi Espíritu Santupa maquinćhu cawanayqui mana camacanchu. Ama purïshimaynapishchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cananga jucha aparicushayquipita wanacuy. Wanacur mañacuptiqui, Tayta Diosninchi juchayquita jungaycur manaćhi yarparanganachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Chiqui runa cashayquita musyä. Jucha caćhariyta mana junquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Chaura musyapacuj Simón niran: «Nuwapaj Tayta Diosninchita mañacuy, ari. Nimashayquicuna ama ćhayaycamächunchu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chaypita Pedruwan Juan willapäcuran Jesústa ricashantapis, shimintapis. Jinarcur Samaria uranpa Jesúspa shiminta willapäcuräcur Jerusalén marcaman cuticäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chaypita Tayta Diosninchipa anjilnin ricariparcur, niran: «Felipe, cananga Jerusalén marcapita Gaza chunyaj pacha quinranpa yarpuj caminupa ayway.» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Chaymi Felipe aywaran. Caminućhu Etiopía marca runata tariparan. Payga mandaj warmi Candacespa jillay charajnin caran. Jerusalén marcaman Tayta Diosninchita manchapacuj aywarunaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Cärunwan cutir, Tayta Diosninchipa willacujnin Isaías isquirbishanta liguiycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chaymi Espíritu Santu Felipita shacyächiran: «Tagay cäruyujta taripay. Tariparcur, cäruyujta yanagay» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chaura juclla aywaran. Cäruyujta taripar, unay willacuj Isaías isquirbishanta liguijta wiyar, tapuran: «¿Liguishayquita tantiyanquichu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Payna niran: «Pipis mana tantiyachimaptin, ¿imanuyparaj tantiyashaj? Jigamuy. Tantiyaycächillämay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Liguiycashan librućhu isquirbiraycaran: «Pishtapaj uyshata apashan-yupay payta apasha. Millwanta rutuptin mana japarashan-yupay, mana rimacushachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pampaman ćhuraptinsi, pipis mana nanachicushachu. Wamran mana captin, ¿piraj imallatapis rimarcunman? Cay pachapita illaricunanpaj wañuycachisha.» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Liguiyta ushyarcur, Etiopía runa Felipita tapuran: «Tayta, tapucushayqui. Willacuj Isaías, ¿pipätaj isquirbiran? ¿Quiquinpächu, jucpächu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chaymi quiquin liguishallanwan: «Alli willapata willapäshayqui» nir Jesús pï cashantapis tantiyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aywarcaycashanćhu yacuta tarir, Felipita niran: «Cayćhu yacu caycan. ¿Manachu ushyaycachillämanquiman?» ");
INSERT INTO qxhNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Felipina niran: «Llapan shunguyquiwan ćhasquicuptiqui, ushyachishayqui.» Etiopía runana niran: «Au. Jesúsga Tayta Diosninchipa Wawan. Llapan shungüwan ćhasquicü.») ");
INSERT INTO qxhNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chaura cärunta ićhiycachir, ishcanin yacuman yarpuran. Felipe ushyachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yacupita llucshircuptin, Espíritu Santu Felipita apacuran. Etiopía runa Felipita mana ricarannachu. Ichanga cushish aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Chaypita Felipe Azoto marcaćhüna ricacuran. Marcan-marcan Jesúspa shiminta willapäcuräcur, Cesarea marcacaman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Chay wichan Tayta Jesústa wiyacuj irmänucunata wañuchiyta munar, Jerusalén mayur cürawan Saulo parlanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Payga warmi ullgutapis charircur-charircur Jerusalén marcaman apamuyta munaran. Chaymi mayur cüra urdinta juran Damasco marcaćhu shuntacäna wasipita irmänucunata charinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasco marcaman yaycuycaptillan, janaj pachapita mana yarpashpita Sauluman achqui chillap-chillapyaramuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Chaura Saulo: tunicuran. Janaj pachapitana nimuran: «Saulullau Saulo, ¿imanirtaj chiquir jaticaćhaycämanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Chayta wiyar, Saulo tapuran: «Tayta, ¿pitaj canqui?» nir. Chaura nimuran: «Tayta Jesúsmi caycä. Chiquir jaticaćhaycämanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Cananga Damasco marcaman ayway. Chayćhüna imata ruranayquipäpis willashunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauluta aywäshijcuna rimamujta wiyaran. Ichanga pitapis mana ricar, juyupa manchariran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauluna japrayash jatarcuran. Ñawin imatapis mana ricarannachu. Chaymi aywäshijcuna charishalla Damasco marcaman ćhayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chayćhu quimsa junaj japrayashalla cacuran. Micuytapis, yacutapis mana malliranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco marcaćhu Tayta Jesústa manchapacuj Ananías tiyaran. Payta ricariparcur, Tayta Jesús niran: «Ananías.» Ananíasna niran: «¿Imallaraj, Tayta?» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tayta Jesúsna niran: «Ananías, ‹Dirïchu› nishan cälliman ayway. Judaspa wasinman ćhayar, Tarso marca Saulupaj tapucunqui. Payga Tayta Diosninchita mañacuycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ricapacuyninćhu ricashurayqui. Ñawin allchacänanpaj yatashayquitapis ricashurayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananíasna niran: «Taytallau Tayta, payga juyush. Juyu cashanta llapan runa musyan. Jerusalén marcaćhu irmänucunata llapanta-yupayshi juyupa ñacachisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cananga mayur cürapita urdinta jurgurcur shamusha pipis taytachacushuptiqui, carsilman apananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Chaura Tayta Jesús niran: «Ama manchacuychu. Chay runata willacujnï cananpaj acracushcä. Auturdänintinta jäpa runacunatapis, Israel runacunatapis shimïta willapanga. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nuwa-janan juyupa ñacanga. Quiquï llapanta tantiyachishaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Chaura Saulo pachacushan wasiman Ananías aywaran. Yaycurir, Sauluta yataycur niran: «Irmänu Saulo, shaycämuptiqui, ricaripushushayqui Tayta Jesús caćhamasha ñawiquita quićhanäpaj. Espíritu Santupis charicurcushunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chaynuy niptin, Saulupa ñawinpita carca shicwacuriran. Ricaranna. Jatarcur, ushyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chaypita micupacuranna. Janancunapis ancashyacäcuran. Tayta Jesústa wiyacuj irmänucunawanpis Damasco marcaćhu ishcay-quimsa junaj juyapäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Damasco marcaćhu juyar, shuntacäna wasicunaćhu Saulo willapäcuran: «Jesús Tayta Diosninchipa Wawanmi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulupa shiminta wiyar, runacuna tantiyayta mana atiparanchu: «Cay runa, ¿imanacäcushtaj? Jesústa ćhasquicujcunata Jerusalén marcaćhu chiquicur jaticaćharan. Caymanpis shamusha irmänucunata charircur-charircur mayur cüraman apananpaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulum ichanga mana manchacullarna tantiyachicuran: «Tayta Jesús rasunpa Washämajninchi» nir. Damasco marcaćhu tiyaj Israel runacunam ichanga tantiyacuyta mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Chaypita unayllata Sauluta wañuycachinanpaj waquin Israel runacuna parlanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Parlanacuriycur, pagas-junaj Sauluta marca wajtancunaćhu shuyarpararan. Parlanacushanmi ichanga quiquin Saulupa rinrinmanpis ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Chaymi purïshijnincuna canistaman wiñarcur, warcuyllapa sawan wajtanpa chacaypa jishpichiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jerusalén marcaman ćhayar, irmänucunawan tincuyta Saulo munaran. Munaptinsi, Jesúspa shiminta rasunpa ćhasquicushanta mana tantiyar, tincuyta manchacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabími ichanga Jesúspa caćhancunaman Sauluta pusharan. Ćhayarcachir, niran: «Damasco marcaman aywaycaptin, Tayta Jesús Sauluta ricaripusha. Parlapasha. Damasco marcaćhüsi mana manchacullar Tayta Jesúspita willapäcusha.» ");
INSERT INTO qxhNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Chaynuypa Saulo Jerusalén marcaćhu irmänucunawan juyapäriran. Mana manchacullar llapanpa ricay ñawinćhu puriran. Tayta Jesúspitapis willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Griego rimaj Israel runacunam ichanga tincuparan. Sauluta wañurachiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chayta mayar, Cesarea marcamanna irmänucuna Sauluta jishpichicäriran. Jinarcur Tarso marcaman caćharcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chay wichan jutucaj irmänucuna allilla juyaran. Judea quinranćhu, Samaria quinranćhu, Galilea quinranćhu Tayta Diosninchita manchapacur cawapäcuran. Espíritu Santu shacyächiptin, Tayta Jesúspa shimin shungunmanpis ćhayaran. Waran-waran yapacaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chay wichan Pedro irmänucunata watucur chay-tucuypa puriycaran. Chaymi Lida marcamanpis ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chayćhu Eneasta tariran. Payga pusaj watana cumllucash wiguraycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Chaymi Pedro niran: «Eneas, Jesucristu allchacächishunqui. Jatariy. Mashtacuyquita shuntay.» Chaura juclla jataricurcusha. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Puriycajta ricar, Lida marcaćhüpis, Sarón marcaćhüpis Tayta Jesúspa shiminta runacuna ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chay wichan Jope marcaćhu Tayta Jesústa wiyacuj warmi tiyaran. Jutin caran Tabita. Griego rimayćhu: «Dorcas» nir ricsiran. Payga Tayta Diosninchita manchapacuj car, cuyay-munaypaj cawaj. Pishipacujcunatapis yanapaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Juc junajmi ichanga jishya chariptin, wañucuran. Wañucuptin armaraycachir, chutaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Chaura washlänin Lida marcallaćhu Pedro caycaptin, waquin irmänucuna ishcaj runata caćhacuran: «Tayta Pedro, Jope marcaman shamuy, ari. Ama juyapacämunquichu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Caćha willaptin, juclla Pedro aywäshiran. Ćhayaptin, aya chutarashan altusman pusharan. Biyüda warmicunapis juntapaycur Dorcas jirapushan müdanancunata wiguinpawan ricachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chaura Pedro llapan täpajcunata wajtaman jargurir jungurpacuycur, Tayta Diosninchita mañacuran. Mañacurir, ayata niran: «Tabita, jatariy.» Niptin, cawaricurcuran. Pedruta ricärir, jamacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedruna maquinpita jatarcachiran. Biyüdacunatapis, irmänucunatapis jayachiran. Llapanta jayarcachir, Tabitawan tincuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tabita cawarishanta Jope marcaćhu llapan musyaran. Chaynuypa achcaj runa Tayta Jesúspa shiminta ćhasquicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Chaypita unaylla suyla-ruraj Simónpa wasinćhu Pedro pachararan. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Chay wichan Cesarea marcaćhu Cornelio tiyaran. Payga «Italia batallun» nishan murucucunata mandaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wasinpa Cornelio Tayta Diosninchita manchapacuran. Manchapacushpan Israel runacunatapis yanapaj. Tayta Diosninchitapis mañacuj. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Juc junaj jatun mallway inti mañacuycaptin anjil ricariparcur, jayacuran: «Cornelio» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Chaura mancharish ricapaycashanćhu niran: «¿Imallaraj, Tayta?» Anjilna niran: «Cornelio, mañacushayquita Tayta Diosninchi wiyashcashunqui. Wacchacunata yanapashayquitapis alli ñawinwan ricasha. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cananga Jope marcaman caćhacuy ‹Pedro› nishan Simónta pushamunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payga suyla-ruraj Simónpa wasinćhu pacharaycan. Wasin yacu cantullanćhu caycan.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anjil illaricäcuptin, Cornelio ishcaj mincaynintawan juc murucuta jayachiran. Chay murucu Corneliuta ricaj. Tayta Diosninchitapis manchapacuj. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jayarcachir llapanta willapariycur, Jope marcaman caćharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Warannin junaj Corneliupa caćhancuna Jope marcaman ćhayarcaycaptin, Pedro Tayta Diosninchita mañacuycaran. Mañacunanpaj mirinday üra wasi altusman jigaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Micuy mana ćhayaptillan, yarganaycashanćhu Pedro ricapacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ricaran janaj pachapa puncun quićhacäcamujta, jatun jacu ćhuscun puntan icsish yarpaycämujta. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ñaupanman ćhayamuptin, tucuy-niraj uywacunata, paćhanpa purijcunata, altullapa pärijcunata ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ricapaycaptin, janaj pachapitana nimuran: «Pedro, micunayquipaj llapanta pishtay.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedruna niran: «Mana micümanchu, Tayta. Millanäcushayqui, asyächicushayqui uywacunata imaypis mana micushcächu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Chaura yapay nimuran: «Tayta Diosninchi alli ricashanta ama millanäcunquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chaynuylla quimsa cutiparaj nimuran. Jinarcur jacuta janaj pachaman chutacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ricapacushanta Pedro yarpaćhacuycaptillan, Corneliupa caćhancuna tapucurir-tapucurir ćhayaran suyla-ruraj Simónpa wasi puncuncaman. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Puncupita jayacuriran: « ‹Pedro› nishan Simón, ¿cayćhüchu pacharaycan?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ricapacushanpita yarpaćhacuycaptillan, Espíritu Santu niran: «Pedro, quimsaj runa ashiycäshunqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Juclla yarpuy. Mana manchacullar aywäshiy. Quiquï caćhamuptï, shamusha.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Chaura altuspita yarpuriycur, caćhacunata Pedro niran: «¿Nuwatachu ashiycämanqui? ¿Imallapäraj ashiycämanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Paycuna niran: «Capitan Cornelio caćhacamasha. Payga Tayta Diosninchita manchapacun. Israel runacunapis alli ñawinpa rican. Jayachishunayquipaj Tayta Diosninchipa anjilninshi willapasha. Wasinmanshi aywanqui shimiquita wiyananpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chay chacay Corneliupa caćhancunata Pedro pachächiran. Warannin tuta aywacäriran. Aywacuptin, Jope marcaćhu irmänucunapis yanagaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Waranninna Cesarea marcaman ćhayaran. Cornelio shuyaraycaran waquin ricsinacushancunata, yawar-masincunata shuntaycur. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wasinman ćhayaptin, manchapacushpan Pedrupa ñaupanman jungurpacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrum ichanga jatarcachiran: «Alliman ama ćhuramaychu. Nuwapis runa-masillayquim cä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Chaypita Corneliuwan wamayänacur wasi ruriman yaycur, chay-chicaj runata tariran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Paycunata Pedro niran: «Musyashayquinuypis Israel runacuna Moiséspa shiminta wiyacun. Tayta Diosninchiwan alli ricanacuyta munar, jäpa runacunawan mana jutucanchu. Wasinmanpis mana yaycunchu. Tayta Diosninchim ichanga tantiyachimasha pitasi mana millanäcunäpaj, mana asyächicunäpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chaymi jayachimaptiqui, juclla shamushcä. Cananga mä, willamay. ¿Imapätaj jayachimashcanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Corneliuna niran: « Tayta Diosninchita mañacuycaptï, caynuy üra achic-achicyaycaj müdanash runa ricaripamasha. Jatun mallway inti caycasha. Ricaripamashan ćhuscu junajna. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ricaripamaj runa nimaran: ‹Cornelio, mañacushayquita Tayta Diosninchi wiyasha. Wacchacunata yanapashayquitapis ricasha. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cananga Jope marcaman caćhacuy. «Pedro» nishan Simónta jayachimuy. Pacharaycan suyla-ruraj Simónpa wasinćhu. Wasin yacu cantullanćhu caycan.› ");
INSERT INTO qxhNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chaynuy nimaptin, juclla caćhacamushcä. Allipaj shamushcanqui. Tayta Diosninchipa ñaupanćhu juturpaycanchi. ¿Imata willapämänayquipätaj Tayta Diosninchi caćhamushcashunqui? Mä, willamay.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Chaymi Pedro niran: «Tayta Diosninchi pï-maytapis llaquipashanta tantiyacüna. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","May-chayćhu juyaptinpis llaquipashpan manchapacujcunata, shungun munashanta rurajcunata wamrachacun. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Israel runacuna Jesúspa shiminta wiyacuptin, allilla cawachinga. Shiminta willapäcunanpaj Washäcuj Jesústa caćhamuran. Taytanchi cashpan llapan runata maquinćhu purichin. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Juan ushyachicur willapäcushanpita-pacha Galilea quinranpita Judea quinrancaman Jesúspa willapan purishanta musyanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tayta Diosninchi camacächiptin, Nazaret marca Jesústa Espíritu Santu charicurcuran. Chaymi munayniyuj ricacuran. Marcan-marcan purir, allita ruraran. Supay pucllacushan runacunatapis allchacächiran. Tayta Diosninchipa maquinćhüpis cawaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Judea quinran marcacunaćhüpis, Jerusalén marcaćhüpis nuwacuna Jesúswan purishcä. Chaynuypa Jesús ima-imata rurashantapis willacü. Rusćhu wañuycachishantapis ricashcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ichanga quimsa junajta Tayta Diosninchi cawarachimusha runacunawan tincunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mana llapan runatachu ricaripusha; manchäga unaypita-pacha Tayta Diosninchi acracushan runacunallata. Nuwacunata ricaripamasha paypita willapäcunäpaj. Chaymi cawarcamuptinpis, Jesúswan micupacushcäraj. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Chaypita pï-maytapis willapäcunäpaj Tayta Jesús caćhacamasha: ‹Wañushcunapa, cawajcunapa juchantapis jurgapänäpaj Tayta Diosninchi ćhuramasha› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tayta Diosninchipa unay willacujnincunapis Jesúspita willacuran: ‹Pipis shiminta ćhasquicuptin, Tayta Diosninchi juchancunata mana yarparanganachu. Runacunata washänan-raycur shamur, llapanta camacächin› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro rimaycaptillan, Corneliupa wasinćhu juturpaycajcunata Espíritu Santu charicurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jäpa runacunatapis Espíritu Santu charicurcuptin, Jope marcapita yanagaj Israel irmänucuna tantiyacuyta mana atiparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Espíritu Santu charicurcushanpita jäpa runacuna juc-niraj rimaytapis rimaran. Tayta Diosninchitapis alliman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tantiyayta mana atipaptin, yanagajcunata Pedro niran: «Jäpa runacunatapis nuwanchita-jina Espíritu Santu charicurcush caycaptin, juclla ushyachishun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Chaynuy nir Jesucristupa jutinćhu ushyachiran. Ushyacujcunana Pedruta mañacuran: «Tayta, ishcay-quimsa junajllapis juyapärishun, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Chaura Judea quinranćhu Jesúspa caćhancunapis, irmänucunapis mayaran waquin jäpa runacunapis Tayta Diosninchipa shiminta ćhasquicushanta. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chaymi Jerusalén marcaman Pedro ćhayaptin, Israel-masin irmänucuna jamurpar niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«¿Imanirtaj jäpa runacunapa wasinćhu pachacushcanqui? ¿Imanirtaj micupacärishcanqui?» ");
INSERT INTO qxhNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jamurpaptin, llapallanta willar, Pedro niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Jope marcaćhu Tayta Diosninchita mañacuycashäćhu ricapacurä. Janaj pachapita jatun jacu ćhuscun puntan icsish yarpaycämuran. Ñaupäman ćhayamuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Sumaj ricapärir, ricarä tucuy-niraj uywacunata, micucuj uywacunata, paćhanpa purijcunata, altullapa pärijcunata. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ricapaycaptï, janaj pachapita nimaran: ‹Pedro, jatariy. Ricashayquita llapanta pishtay micunayquipaj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Chaura nishcä: ‹Mana micümanchu. Tayta Diosninchi millanäcushan, asyächicushan uywacunata imaypis mana micurüchu.› ");
INSERT INTO qxhNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yapay janaj pachapita nimaran: ‹Tayta Diosninchi alli ricashanta ama millanäcunquichu.› ");
INSERT INTO qxhNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chaynuy quimsa cutipa nimaran. Jinarcur janaj pachaman jipita chutacurcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Niycaptillan, Cesarea marcapita quimsaj jäpa runacuna ashimar, pacharashäman ćhayamuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chaura mana manchacullar aywanäpaj Espíritu Santu shacyächimaran. Chaymi sujtaj irmänunchicunawanpis aywarä. Cesarea marcapita jayachimaj runapa wasinman ćhayarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wasiyujna willamaran: ‹Wasïćhu anjil ricariparcamar, nimasha: «Jope marcaman caćhacuy. ‹Pedro› nishan Simónta jayachimuy. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pay willapäshunquipaj llapaniqui Tayta Diosninchipa maquinćhu cawanayquipaj.» › ");
INSERT INTO qxhNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Willapaycaptilläna, nuwanchita ñaupata charicarcamashanchi-jina paycunatapis Espíritu Santu charicurcusha. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chayraj Tayta Jesúspa shiminta yarpärirä. Pay niran: ‹Ushyachicuj Juan yacullawan ushyachicusha. Jamcunatam ichanga Espíritu Santuwan Tayta Diosninchi ushyachishunquipaj shungun munashannuy cawanayquipaj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Chaura Tayta Jesúspa shiminta ćhasquicuptinchi, Espíritu Santu yanapämashanchi-jina paycunatapis yanapaycan. Tayta Diosninchi camacaycachiptin, mana mićhämanchu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chaynuy Pedro willaptin, pipis mana jamurparannachu; manchäga Tayta Diosninchita alliman ćhuraran: «Jäpa runacuna wanacunantapis Tayta Diosninchi camacächin. Paycunasi wanacuptin, maquinćhu imaycamanpis cawachinga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Canan tantiyacushun. Estebanta wañuycachishan wichan Jesúspa shiminta wiyacuj irmänucunata jaticaćhar ushyaptin, aywacäriran Fenicia marcacunaman, waquin Chipre marcacunaman, waquinna Antioquía marcaman. Chay marcacunaćhu Israel-masincunallata Jesúspita willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Waquin irmänucunam ichanga jäpa runacunatapis willaparan. Willacujcuna caran Chipre marcacunapita, Cirene marcapita. Paycunana Antioquía marcaćhu jäpa runacunatapis Tayta Jesúspita willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Willapäcunanpaj Tayta Diosninchi sumaj yanaparan. Chaymi achcaj jäpa runa jucha aparicuypita wanacuran. Jesúspa shiminta ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chayta mayar, Jerusalén marcaćhu jutucaj irmänucuna Antioquía marcaman Bernabíta caćharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ćhayar, jäpa runacuna Jesúspa shiminta wiyacushanpita sumaj cushicuran. Paycunata Tayta Diosninchi llaquipashanta tantiyacuran. Chaymi shacyächiran mana yamacällar Jesúspa shiminta wiyacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Achcaj runa Jesúspa shiminta wiyacäriran Bernabé alli runa captin, Tayta Diosninchita manchapacuptin, Espíritu Santupa maquinćhu puriptin. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Antioquía marcapita Tarso marcamanna Bernabé aywaran Saulo ashij. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tarir, Antioquía marcaman pushacuran. Jutucaj irmänucunawan ishcan juc wata juyapäriran. Tayta Diosninchipa shiminta achcaj runata tantiyachiran. Chay marcaćhüraj Jesúspa maquinćhu cawajcunata «Cristianucuna» nirshi jutichaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chay wichan Tayta Diosninchipa willacujnincuna aywaran Jerusalén marcapita Antioquía marcaman. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Chay marcaćhu Espíritu Santu rimachiptin, willacuj Agabo jatarcur musyachiran: «Chay-tucuyćhu juyupa mućhuy cangapaj» nir. Chaura musyachishannuylla änir ćharcucaran. Roma marcacunata mandaj Claudio maquinćhu purichishan wichan änir mućhuy caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mućhuy captin, Antioquía marcaćhu irmänucuna parlanacuran Judea marcaćhu irmänucunata taripacushan-tupulla tarichinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Chaymi cuyachicuynincunata shuntariycur, Sauluwan, Bernabíwan Jerusalén marcaman apachiran. Ćhayachirga, mayur irmänucunapa maquinman inćhigaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chay wichan mandaj Herodes ishcay-quimsa irmänucunata charichisha ñacachinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juanpa wauguin Santiagupa cuncanta ruguriptin, ");
INSERT INTO qxhNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","waquin Israel runacuna jatunpa cushicuran. Chaymi Libadüraynaj tantata micuna fiestata rurashan wichan Pedrutapis chariran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Charircur, carsilman wićhgaran: «Pascua fiesta ushyayraj llapan runa ricay tapushun» nir. Ćhuscu jutuy murucucunapa maquinman ćhuraran. Täparanpis ćhuscuj murucu-caman. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedruta sumaj täparcaycaran. Chaypis jutucaj irmänucuna Pedrupaj mana yamacällar Tayta Diosninchita mañacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chaura mandaj Herodes ñauquinan warämuj Pedro ishcaj murucupa ćhaupinćhu puñuycaran. Ishcay cadinawan wataraycächiran. Waquin murucucunapis puncućhu täparcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Täparcaycaptin, Tayta Diosninchipa anjilnin achic-achicyaycar ricaripuran. Pedruta tapsirir: «Juclla jatariy» niptin, wataraycächishan cadinapis pascacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jinarcur niran: «Pedro, juclla cinturunniquita watacuy. Llanguiquitapis jaticuy.» Anjil nishanta änir Pedro ruraran. Jatarcuptin, niran: «Punchuyquita ushtucurcur, jipalläta llucshimuy.» ");
INSERT INTO qxhNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Chaura anjilpa jipallanta Pedro llucshiran. Ichanga mana tantiyacur, yarpaćhacuran: «¿Rasunpachu llucshiycä? ¿Nuspaycächu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ruri puncucunata täpaycaj murucucunatapis ćhancarir-ćhancarir jawa puncuman ćhayaran. Jawa puncuman ćhayaptin, jïru puncu quiquillan quićhacäcuran. Chaura wajtaćhüna ricacuran. Carunijcaman pusharcur, anjil illaricäcuran. Quiquillanna Pedro ricacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tantiyacurir, Pedro niran: «Cananmi ichanga Tayta Diosninchi anjilninta caćhamushanta rasunpa musyä. Mayur Israel runacunapita, mandaj Herodespita jishpirachimasha. Wañuchimänanpita washämasha.» ");
INSERT INTO qxhNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chaura carsilpita llucshishanta sumaj tantiyacurir, Maríapa wasinman aywacuran. Paymi «Marcos» nishan Juanpa maman caran. Maríapa wasinćhu irmänucuna Pedrupaj Tayta Diosninchita mañacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chaura sawan puncupita Pedro jayacuriptin, pï cashantapis musyananpaj yanapäcuj jipash Rodesa llucshiriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedrupa shiminta wiyar, jatunpa cushicuran. Puncu quićhapuytapis jungaycur, cuticuran: «Pedro ćhayamusha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Willaptin, llapan niran: «Supayćhi pucllacushcashunqui.» Niptinpis, yapayraj niran: «Mana llullacüchu. Rasunpa Pedro.» Chaura niran: «Alman-imataćhi wiyapacushcanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Puncuta mana quićhapuptin, yaparir-yaparir Pedro jayacuycaran. Puncuta quićharir, Pedruta ricashpan tantiyacuyta mana atiparanchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Chaura Pedro upällachiran. Jinarcur carsilpita Tayta Diosninchi jurgushanta willacuran. Chaypita jucläpa aywacuran: «Llucshimushäta waquin irmänunchicunatapis, Jesúspa wauguin Santiagutapis willanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Chaura carsilćhu Pedro mana warämuptin, quiquin-puralla täpaj murucucuna ullgüpänacuran «¿Mayraj Pedro?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pedro mana captin, wacpa-caypa mandaj Herodes ashichiran. Täpacuj murucucunatapis sumaj tapuran. Pedruta mana tariptin, quiquin täpaj murucucunata wañuycachiran. Jinarcur Judea quinranpita Cesarea marcamanna Herodes tiyaj aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mandaj Herodes Tiro marca runacunatapis, Sidón marca runacunatapis juyupa chiquipacurcuran. Chiquipaptin, parlaj aywariycur Blastuta mañacuran: «Tayta Blasto, capuralnin cashpayqui mandaj Herodeswan yaćhänacunqui. Ullguynin jasacänanpaj parlapaycallämay, ari. Marca-masïpaj micuyta apaptï, ama mićhämanmanchu» nir. Chaymi Blasto parlapaptin, änir mandaj Herodespa ullguynin jasacaran. Juc junajpaj jitaparan: «Tiro runacunawan, Sidón runacunawan parlanacunäpaj shamuchun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sisyunpaj jitapashan junaj ćhayamuptin, achic-achicyaycaj müdananta ushtucurcur, runacunapa ñaupanćhu mandaj Herodes jamacuycuran. Cushichipayllapa rimaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Rimashanta wiyar, japarir-japarir runacuna niran: «Taytallau Tayta, Munayniyuj Tayta Diosninchi canqui. Imaypis mana ushyacanquipächu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Runacuna alliman ćhuraptin, Herodes sumaj cushicuran. Quiquin Tayta Diosninchiwan tincuchiptinsi, mana mićharanchu. Chaypitam Tayta Diosninchipa anjilnin wañurachiran. Mandaj Herodes aycha curu ushyaypa wañucuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tayta Diosninchita wiyacujcunam ichanga Jesúspa shiminta chay-tucuyćhu willapäcuycaran. Runa achcajmi Tayta Jesúspa shiminta ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Chay wichan Bernabíwan Saulo cuyachicuycunata Jerusalén marcaman ćhayachiran. Jinarcur «Marcos» nishan Juanta pushacurcur, Antioquía marcaman cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Chaura chay wichan Antioquía marcaćhüpis irmänucuna jutucaycaran. Waquin caran willacujcuna, waquinna yaćhajcuna. Chayćhu Bernabípis, «Yana Runa» nishan Simeónpis, Cirene marca Luciupis, Saulupis, Manahempis caycaran. Irmänu Manahemga Galilea marcacunata mandaj Herodespa wiñay-masin caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Juc junaj irmänucuna Tayta Diosninchita manchapacurcaycaptin, ayünarcaycaptin, Espíritu Santu musyachiran: «Bernabítawan Sauluta shimïta willacur purinanpaj raquicushcä. Jamcuna caćhacuy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chaura ayünayta, mañacuyta ushyarcur, ishcanta Tayta Diosninchipa maquinman ćhuraran. Umanta yataycur, niran: «Taytallau Tayta, cay runacuna aruyninta ćharcunanpaj yanapaycullay, ari.» Jinarcur, Bernabítawan Sauluta caćharcuran willapäcur purinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Chaura Espíritu Santu pushaptin, Bernabíwan Saulo Seleucia marcaman ćhayaran. Chaypita bütiwan Chipre quinranman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chipre quinranćhu Salamina marcaman ćhayar, Israelcunapa shuntacäna wasincunaćhu Jesúspa shiminta willapäcuran. Juan Marcospis yanapar purïshiycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jesúspa shiminta willacur Chipre quinranćhu puriycashanćhu Pafos marcamanpis ćhayaran. Chayćhu musyapacuj Bar-Jesúswan tincusha. Paypis Israel runa caran. Achcaj runata riguichiran: «Tayta Diosninchipa willacujnin cä» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Chipre marcapa mandajnin Sergio Pauluwanpis yaćhänacuran. Mandaj Sergio Pauluga yarpay-sapa runa caran. Tayta Diosninchipa shiminta wiyayta munar, Bernabítawan Sauluta jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Musyapacuj runam ichanga mandaj Sergio wiyacunanta mana munar, tucuy-jinanpa chapata ruraran. Griego rimajcuna musyapacujta: «Elimas» nir ricsiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Chapata ruraptin Espíritu Santupa maquinćhu purir, Saulo musyapacuj runata ullgüparan. Saulullata griego rimajcuna: «Pablo» nir ricsiran. «Pablo» nishan Saulo musyapacujta ullgüpar, niran: «Llulla runa canqui. Pingacuytapis mana yaćhanquichu. Supaypa wawan canqui. Tayta Diosninchitapis tucuy-jinanpa chapata ruraycanqui. ¿Imaycamanraj llullacunqui: ‹Taytanchipa shiminta rimä› nir? ");
INSERT INTO qxhNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chay-niraj cashayquipita Tayta Diosninchi ñacachishunquipaj. Achicyaj pachatapis unaylla mana ricanquipächu.» Chaynuy niptin, Elimas japrayacäcuran. Puriyta mana camäpacur, tumaycaćhaycaran pipis maquinpita purichinanta munar. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Japrayashta ricar mancharir, mandaj Sergio tantiyacuran Tayta Jesús munayniyuj cashanta. Juclla shiminta ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chaypita Pablo llapan yanaguincunawan bütiwan aywacuran Pafos marcapita Panfilia quinran Perge marcaman. Juanmi ichanga paycunata jaguiriycur, Jerusalén marcaman cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pabluna yanaguincunawan Perge marcapita Pisidia quinran Antioquía marcaman ćhayaran. Diyawarda captin, Israelcunapa shuntacäna wasinman aywaran. Ćhayar ruriman yaycurir, jamacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Shuntacäna wasićhu yaćhajcuna Moiséspa shiminta, willacujcunapa shiminta liguiycaran. Liguiyta ushyarcuptin, mayur runacuna Pablutawan Bernabíta niran: «Irmänucuna, shacyächimayta munar, juclla willapäramay, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Chaura jatarcur llapan runata upällaraycachir, Pablo niran: «Israel-masicunapis, Tayta Diosninchita manchapacujcuna jäpa runacunapis, mä, shimïta wiyaycallämay. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Unay Israel-masinchicunallatash Tayta Diosninchi wamrachacuran. Chayshi Egipto marcaćhu jurpay-tucullar puriptinpis, sumaj achcayänanpaj camacächiran. Chaypita munayniyuj cayninwan unay auquillunchicunata Egipto marcapita jishpichimuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Chunyaj pachaćhu ćhuscu ćhunca (40) wata purir llutanta ruraptinpis, Tayta Diosninchi manash yamacaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Manchäga Canaán marcaman ćhayachimuran. Chayćhüshi janćhis marca runacunata ushyaran. Llapanta ushyariycurshi, ćhacrantapis auquillunchicunata raquipuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Wamrachacushanpita-pacha ćhuscu paćhac pichga ćhuncawan (450) watataräshi Canaán marcaćhu mirar shillaran. Chaypita Israel runacunata ricananpäshi mayur runacunata ćhurapuran. Paycunapa maquillanćhu juyaran willacuj Samuel cawashan wichancaman. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chay wichan unay auquillunchicuna Tayta Diosninchita mañacuran: ‹Llapanïta ricamänanpaj juc mandaj runallata ćhuray. Llapanï cawashaj paypa maquillanćhu› nir. Chayshi mandananpaj Tayta Diosninchi Saúlta ćhuraran. Papänin caran Cis, auquillunnash Benjamín. Saúlga ćhuscu ćhunca (40) watash Israelcunata maquinćhu purichiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chaypita Saúlta jargurir, Davidtanash mandaj cananpaj ćhuraran. Manaräsi mandaj cayman ćhayaptillan, Tayta Diosninchi musyachicuran: ‹Jesépa wamran David shungüman tincun. Payraj shungü munashanta ruranga› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Chaura Tayta Diosninchi aunishanta ćharcurshi, Davidpa willcanpita jucta ćhuraran Israelcunata washänanpaj. Ćhurashan runa Jesúsmi caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tayta Jesús manaraj ricarimuptillanshi, Ushyachicuj Juan llapan Israel runacunata anyaparan wanacunanpaj, ushyacunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Chaypita wañucunanpaj wallcana pishiycaptin, Ushyachicuj Juan niran: ‹Yarpaptiquipis, mana Washäcujchu cä. Jipätam ichanga munayniyuj shamunga. Munayniyuj captin, llanguinta llushtipuyllatapis manchapacü.› ");
INSERT INTO qxhNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Israel-masicuna, Abrahampa willcan carpis, Tayta Diosninchita manchapacuj jäpa runa carpis, shimïta wiyaycallämay. Tayta Jesúspa shiminta ćhasquicuptinchi, llapanchita washämäshun. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tayta Jesús Washäcuj cashanta Jerusalén marca runacunapis, mayur runacunapis manash tantiyacuranchu. Diyawardacunaćhu unay willacujcunapa shiminta liguiycarsi, manash tantiyacuranchu. Chayshi willacujcunapa shimin rimashanman-tupu Jesústa wañuycachisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wañuchiyta munar juchan mana caycaptinsi, ullgur mandaj Pilatuta mañacuran: ‹Jesústa wañuycachiy› nirshi. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Willacujcunapa shimin rimashan-tupu rusćhu wañuchiran. Jinarcur pampaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","«Wañush pamparaycaptinsi, Tayta Diosninchi cawarachimusha. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Cawarcamur, Galilea marcapita Jerusalén marcaman aywäshijcunata achca cutish ricaripuran. Aywäshijcunanash Israel-masinchicunata Jesúspita willapäcurcaycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Unay auquillunchicunata Tayta Diosninchi auniran: ‹Washäcujta caćhamushaj› nirshi. Cananga Tayta Diosninchi aunishanta ćharcucächishana. Chay alli willapata willacurcaycä. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Shiminta ćharcushpan Tayta Diosninchi Jesústa cawarachisha. Jesús cawarinanpaj ishcay-caj Salmućhu nin: ‹Wawämi canqui. Nuwapita cawanqui.› ");
INSERT INTO qxhNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Tayta Diosninchi nishannuylla änir Jesústa cawarachimusha. Yapay wañuyman ćhayar ayan ismunanta mana camacächingachu. Shiminćhu nin: ‹Jamcunata sumaj yanapäshaj. Mandaj Davidta aunishäta llapanta ćharcushaj› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Juc Salmućhüpis isquirbiraycan: ‹Acrashayqui runapa ayan ismunanta mana camacächinquipächu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Chaura mandaj David änirshi, Tayta Diosninchipa shungun munashannuylla Israel-masincunata mandaran. Wañucuptinshi, unay yawar-masincuna pamparashallanman pampaycusha. Ayanpis ismur, ushyacaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesústam ichanga Tayta Diosninchi cawarachiran. Ayanpis mana ismuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Israel-masicuna, sumaj tantiyacushun. ‹Tayta Diosninchi alli ricamänanchipaj Moiséspa shimintaraj ćharcushun› nir llapanta ćharcuyta mana atipaptinchi, juchanchitapis Tayta Diosninchi yarparaycaranraj. Juchanchi jungacash cananpämi ichanga quiquin Jesús camacächisha. Paypa shiminta ćhasquicuptinchi, juchanchita Tayta Diosninchi mana yarparanganachu. Alli ñawinpana ricamäshun. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Chaymi unay auquillunchicuna ćhayashanman ćhayarunquiman. Unay willacujnincunawan Tayta Diosninchi musyachicuran: ");
INSERT INTO qxhNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Wasguipämajcuna, wiyamanquiman. Mancharinquipämi. Illarinquipämi. Munaynïwan imatapis camacächishaj. Camacächishäta willashuptiquipis, mana tantiyacunquipächu› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Willacuyta ushyarcur, shuntacäna wasipita Pabluwan Bernabé llucshicuran. Llucshicuptin, llapan shungunwan runacuna mañacurcaycaran: «Shamuj diyawardapis willapämänayquipaj yapay cutimunqui, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shuntacäna wasipita llapan llucshicur, Israelcunapis, Tayta Diosninchita manchapacuj jäpa runacunapis Pablutawan Bernabíta aywäshiran. Aywäshijcunata shacyächiran llaquipäcuj Tayta Diosninchipa shiminta mana yamacällar ćharcunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chaymi shamuj diyawarda junaj ćhayamuptin, Tayta Diosninchipa shiminta wiyananpaj llapan-yupay runacuna shuntacaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Chay-chicajta ricar, Israel runacuna ullgucarcäriran. Pabluta tincuparan. Ashllir ushyaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chaura Pabluwan Bernabé mana manchacullar niran: «Taytacuna, Israel runa car, Israel-masinchicunataraj Tayta Diosninchipa shiminta willaparä. Cananga shiminta wasguipashayqui-jina mana ushyacaj cawaytapis wasguipaycanqui. Chaymi cananpita-pacha jäpa runacunata willapäcushaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tayta Diosninchi llapan runata willapänäpaj musyachicuran: ‹Jäpa runacunata shimïta willapäcunayquipaj ćhurashcaj. May-chayćhüpis willapäcushayquita ćhasquicuptin, washäshaj› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chayta wiyar, jäpa runacuna jatunpa cushicuran: «Tayta Diosninchi llaquipäcuj. Allipaj Jesúspa shiminta wiyashcanchi» nir. Mana ushyacaj cawayta tarinanpaj Tayta Diosninchi acracushancuna Jesúspa alli willapanta ćhasquicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chaynuypa chay marcacunaćhu Jesúspa shiminta willacurcaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Waquin Israelcunam ichanga ullgucarcäriran. Chaymi waquin Tayta Diosninchita manchapacuj mama-warmicunatawan mayur runacunata shimiyaran Pablutawan Bernabíta chiquipacurcunanpaj. Chiquipayllawan marcanpitasi jarguran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jarguriptin: «Wasguimashayquipita ñacayman ćhayanquipaj» nir ćhaquinta pichacurir, Iconio marcaman aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aywacuptinsi, Tayta Jesúspa shiminta ćhasquicujcuna cushi-cushilla cawarcaycaran. Maquinćhüpis Espíritu Santu puriycächiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio marcaman ćhayarna, Pabluwan Bernabé Israelcunapa shuntacäna wasinman aywaran. Paycuna willapäcuptin, Israel runacunapis, jäpa runacunapis Jesúspa shiminta ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Waquin Israel runacunam ichanga Jesúspa shiminta wasguir, waquin jäpa runacunata shimiyaran irmänucunata chiquipänanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Imanuy captinpis, unaylla Iconio marcaćhu Jesúspa caćhancuna juyapäriran. Tayta Jesúsman yupachicur pitasi mana manchacullar willapäcuran: «Tayta Diosninchi llaquipäcuj car, acracushan Jesústa caćhamusha washämänanchipaj» nir. Tantiyachishannuylla willapäcur, jishyaćhucunata allchacächir, supaycunata jargur, tucuy-jinanpa Tayta Diosninchi munayniyuj cashantapis, llaquipäcuj cashantapis musyachicuycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iconio marca runacuna quiquin-puralla ticrapanacuran. Waquin runa Jesúspa caćhancunata ćhasquicuran; waquinmi ichanga mana. Mana wiyacuj Israelcunapa shiminta wiyacur, mana ćhasquicuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mana ćhasquicujcuna mayur Israel runacunapis marca-masintin, jäpa mayur runacunapis marca-masintin parlanacuran Pablutawan Bernabíta sajmar ushyananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Parlanacushanta mayar, jishpicäriran. Aywaran Licaonia quinran Derbe marcaman, Listra marcaman, waquin marcacunamanpis. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chay marcacunaman ćhayar, Tayta Diosninchipa shiminta willacur Jesúspita willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra marcaćhu cumllu runawan tincuran. Yuriyninpita-pacha cumllu car, puriyta mana camäpacuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Payga Pablo willacushanta wiyaraycaran. Chaura cumlluta ricärir tantiyacuran: «Cay runa allchacayta munar, llapan shungunwan Tayta Diosninchiman yupachicun» nir. Chaymi Pablo niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","«Muguyquicunata chutapacuy. Jatariy.» Niptin, cumllu runa juclla jataricurcuran. Allina puriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Chaura Pablo allchacächishanta ricar, quiquincunapa rimayninćhu Licaonia runacuna ninacuran: «Yaya taytanchi runa-tucullar watucamashcanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Manchapacur, Bernabípaj niran: «Caymi yaya taytanchi Zeus.» Pablupäna willacuj captin, niran: «Caymi yaya taytanchi Hermes.» ");
INSERT INTO qxhNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Listra marca yaycunaćhu caycaran yaya tayta Zeuspa capillan. Chay capillaćhu aruj cüra marca-masintin Jesúspa caćhancunata cuyachicuynincunata jarayta munar, waytan wallgash türucunata apamuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Chaura: «Yaya tayta» nir jarayta munaptin, Pabluwan Bernabé juyupa mancharicäcuran. Müdanantapis raćhir ushyarir, runacunapa ćhaupinpa ushtucuycur wiyacächiypa llapan runata niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Taytacuna, yaya taytayquiman ama tincuchimaychu. Nuwacunapis runa-masillayquim caycä. Rasunpa-caj Tayta Diosninchi caćhamasha shiminta willapänäpaj. Payga cawan. Camasha janaj pachatapis, cay pachatapis, yacucunatapis, llapan imacunatapis. Chaymi manacaj jircacunaman ama manchapacunquimanchu. Manchäga quiquin Tayta Diosninchita manchapacunquiman. Paylla munayniyuj. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Unayga quiquin yarpashannuylla runacuna cawaran. Imanuy cawaptinpis, Tayta Diosninchi mana mićharanchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Jamcunapis chaynuy cawaptiquisi, Tayta Diosninchi llaquipäshurayqui. Llaquipäcuj car, tamyachimun micuyniquicuna sumaj waćhananpäpis, sumaj wayunanpäpis. Yanapaycäshunqui cushi-cushilla cawanayquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Runacuna jarayta munaycaptin, Pabluwan Bernabé tucuy-jinanpa tantiyachirraj mićharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Listra marcaćhu caycaptin, chiquicuj Israel mayur runacuna ćhayaran Pisidia quinran Antioquía marcapita, Iconio marcapita. Paycuna Jesúspa caćhancunata chiquichinan-cashallan runacunata shimiyaran. Shimiyaptin, Pabluta sajmar ushyaran. Wañush-jina jitacäcuptin: «Wañuycachirunchi» nir marca wajtanman janćharcur wicapariran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Chaypis irmänucuna jutuparaycaptin, cawarcamuran. Jinarcur marcaman Pablo cutiran. Warannin Bernabíwan ishcanin Derbe marcaman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe marcaćhu willapäcuptin, achcaj runa Tayta Jesúspa shiminta ćhasquicuran. Paycunata sumaj willapariycur, aywashan caminullapa cuticuran Listra marcapa, Iconio marcapa, Antioquía marcacaman. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chay marcacunaman ćhayar, Tayta Diosninchita mana yamacänanpaj irmänucunata shacyächir niran: «Tantiyacunquiman. Tayta Diosninchipa ñaupanman mana ćhayashanchicaman runacuna chiquir ushyamäshunpaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cutishan marcacunaman ćhayar, jutucaj irmänucunata ricananpaj mayur irmänucunata ćhuraran. Ayünar Tayta Diosninchita mañacuran: «Taytallau Tayta, mayur irmänucuna aruyninta ćharcunanpaj yanapaycullay, ari. Paycuna maquiquićhümi cawan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chaypita Pisidia quinranpa aywaycur, ishcanin Panfilia quinranman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jinarcur Perge marcaćhu Jesúspa shiminta willapäcuriycur, Atalía marcamanna yarpamuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Willapäcuyta ushyarcur, bütiwan Antioquía marcaman cuticuran. Chay marcapita llaquipäcuj Tayta Diosninchipa maquinman ćhuraycuptin, Pabluwan Bernabé willacuj llucshipäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Chaura llucshishan marcaman ćhayar, jutucaj irmänucunata jayarcur, willaparan: «Jesúspa shiminta willacuptï, sumaj Tayta Diosninchi yanapämasha. Chaymi jäpa runacunapis shungun shacyäcuptin, Tayta Jesúspa shiminta ćhasquicäriran. Paycuna Tayta Diosninchipa maquinćhu cawarcaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Llapallanta willapariycur, wiyacuj-masincunawan unaylla juyapäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chay wichan Judea quinranpita Antioquía marcaman aywarcur, waquin Israel irmänucuna willapäcuycaran: «Jäpa runacuna, Tayta Jesúspa shiminta ćhasquicush carsi, Moiséspa shimintaraj ćharcunquiman. Jïrucunquiman. Chayraj maquinćhu Tayta Diosninchi purichishunquipaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pabluwan Bernabími ichanga paycunawan sumaj tincupänacuran. Chaymi Antioquía mayur irmänucuna Pablutapis, Bernabítapis, waquin irmänucunatapis Jerusalén marcaman caćharan. Caćhaptin, Jesúspa caćhancunawan, mayur irmänucunawan parlanacuj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chaura Antioquía marcaćhu jutucaj irmänucuna caćhaptin, Fenicia uranpa, Samaria uranpa aywacäriran. Waquin irmänucunawan tincur, willaparan: «Jäpa runacunapis Tayta Diosninchipa shiminta ćhasquicun» nir. Willapaptin, jatunpa cushicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pabluwan Bernabé Jerusalén marcaman ćhayaptin, Jesúspa caćhancunapis, mayur irmänucunapis, jutucaj irmänucunapis cushi-cushilla ćhasquicäriran. Chaura Pablo tucuy-jinanpa Tayta Diosninchi yanapashanta willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Waquin Tayta Jesúspa shiminta ćhasquicuj fariseucunam ichanga niran: «Jäpa runacuna Tayta Jesústa ćhasquicurpis, Israel ullgucuna-jina jïrucuchun. Moiséspa shimintaraj llapanta ćharcuchun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Chaynuy niptin, Jesúspa caćhancunawan llapan mayur irmänucuna-ima parlanacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sumaj apaycaćhänacuptin, Pedro jatarcur niran: «Irmänucuna, jäpa runacunata willapänäpaj Tayta Diosninchi acracamashanta musyanqui. Acracamasha Jesúspa alli willapanta willapaptï, jäpa runacunapis ćhasquicunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tayta Diosninchi llapan runapa shungunta musyapan. Chaymi yanagämashanchi-jina jäpa runacunatapis acracushpan Espíritu Santu maquinćhu puriycächin. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jesúspa shiminta ćhasquicuptinchi, Israel runacunatapis, jäpa runacunatapis maquinćhu Tayta Diosninchi purichimanchi. Paypäga llapanchipis jucnaylla caycanchi. Jäpa runacunapa juchantapis jungashana. Alli ñawinpana rican. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Chaymi Tayta Diosninchita chapata ama rurashunchu. Jesúspa shiminta wiyacuptin, jäpa runacunata ama nishuwanchu: ‹Moiséspa shimintaraj ćharcuy.› Moiséspa shiminta unay auquillunchicuna mana ćharcuranchu. Nuwanchipis ćharcuyta mana camäpacunchichu. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tayta Diosninchim ichanga llaquipäcuj cashpan washämanchi. Washämänanchi-raycur Tayta Jesús wañuyman ćhayashanpita nuwanchitapis, jäpa runacunatapis alli ricamanchi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chaypita Pabluwan Bernabé Tayta Diosninchi imanuy-imanuy yanapashantapis willaran: «Jäpa runacunata willapäcuptï, Tayta Diosninchi camacächiyninpa jishyaćhucunata allchacächishcä. Supaycunatapis jargushcä» nir. Chaynuy niptin, llapan runa wiyarpararan. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Llapanta willaptin, Santiagupis niran: «Irmänucuna, mä, wiyaycallämay. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeón Pedro cananraj willapämashcanchi jäpa runacunatapis unaypita-pacha Tayta Diosninchi llaquipaycashanta. Paycunatapis acracusha maquinćhu cawananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Chaynuy cananpaj Tayta Diosninchipa unay willacujnincunapis musyachicur niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Tayta Diosninchi nimanchi: «Juc junaj cutimushaj. Mandaj Davidpa marcan ushyacash captinsi, mandajnin mana captinsi, yawar-masillanpita juc mandajta ćhurashaj. Maquillanćhu marca-masincunata purichishaj. Ushyacash marcantapis quiquin-purallapita yapay marcayächishaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chaynuy camacächiptï, llapan runa ashimanga. Acracushä jäpa runacunatapis maquïćhu purichishaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Chaynuy cananpaj quiquin Tayta Diosninchi unaypita-pacha auniran.» › ");
INSERT INTO qxhNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Irmänucuna, chaymi jäpa runacunapa umanta alläpa ama nanächishunchu. Ama pantacächishunchu. Quiquincuna yarpashannuylla Tayta Diosninchita wiyacunman. Israel runacuna yarpashantapis llapallanta ama ćharcunmanchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Manchäga Tayta Diosninchiwan alli ricanacunanpaj cartacushun: ‹Jircacunata jarashanta ama micunquimanchu. Ricashayqui warmitapis ama yatapanquimanchu. Ricashayqui runatapis ama ćhasquipanquimanchu. Maticuypa wañush uywatapis, yawartapis ama micunquimanchu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Chaycunata unaypita-pacha Moiséspa shiminta liguiycur, willapäcuran. Canan wichanpis diyawarda junajcunaćhu marcan-marcan shuntacäna wasicunaćhu Moiséspa shiminta willapäcun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Chaura chaynuy niptin, Jesúspa caćhancunapis, mayur irmänucunapis, llapan jutucaj irmänucunapis cushish ćhasquicärisha. Pabluwan Bernabé Antioquía marcaman cutiptin, aywäshinanpäpis juc-ishcay mayur irmänucunata acraran. Acraran «Barsabás» nishan Judastawan Silasta. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawan cartata apachiran Antioquía marcaman, Siria quinranwan Cilicia quinran marcacunaman. Tayta Jesúspa shiminta ćhasquicuj jäpa runacunata cartacuran. Cartaćhu niran: «Irmänucuna, ¿allillachu juyaparcaycanqui? Jesúspa caćhancunawan mayur irmänucunawan-ima cartacaycämü. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Waquin irmänunchicuna umayquita nanächinallanpaj cashanta mayashcä. Mana caćhaycämuptïsi, sharcamur willapashcashunqui: ‹Moiséspa shimintaraj ćharcuy. Janayquitapis jïrucuy› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chaymi sumaj parlanacuriycur, juc-ishcay irmänunchicunata caćhaycämü. Shaycämun yaćhänacushanchi Bernabíwan Pablo. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paycuna wañuytapis mana manchacullar, Taytanchi Jesucristupa shiminta willapäcurcaycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Chaynuypis irmänunchi Judastawan Silasta caćhamushcä. Cartacamushäta shiminwanpis tantiyachishunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","«Espíritu Santupis, nuwacunapis chapata mana rurämanchu. Ichanga Espíritu Santu shacyächimaptin, ichicllatapis anyapärishayqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jircacunaman jarashanta ama micunquimanchu. Uyshata pishtar, yawarninta shutuchinquiman. Ima yawartapis ama micunquimanchu. Ricashayqui warmiwanpis, ricashayqui runawanpis ama cacunquimanchu. Willapashäcunata ćharcur, allina cawanquipaj. Chayllata cartacamü.» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chaynuypa carta apajcuna Antioquía marcaman aywacuran. Ćhayar, llapan irmänucunata shuntaycur, cartata juycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Cartata liguipaptin shacyächishanta wiyar, jatunpa cushicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Silaswan Judaspis Tayta Diosninchipa willacujnin car, shiminpawanraj llapan irmänucunata sumaj shacyächiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chaypita unayllata carta apajcuna Jerusalén marcaman cuticäriran. Cuticuptin, niran: «Allilla cutiycullay, ari. Jerusalén marcaćhu irmänunchicunatapis wamayapämanqui, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Jucnin cuticuptinsi, Silas mana cuticuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pabluwan Bernabípis mana cuticuranchu. Manchäga waquin irmänucunawan Antioquía marcaćhu juyar, Tayta Diosninchipa shiminta willapäcuran. Jesúspita tantiyachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chaypita unayllata Pablo niran: «Bernabé, irmänunchicuna watucuj cutishun. Tayta Diosninchipa willacuyninta willapäcur purishanchi marcacunata watucushun. Mä, ¿imanuyshi caycan?» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","«Cutishun» niptin, Bernabé niran: « ‹Marcos› nishan Juantapis pushashun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablum ichanga mana munaranchu ñaupata Panfilia quinranpita cuticushanpita, mana purïshishanpita. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Chay janan Pabluwan Bernabé apaycaćhänacur raquicaran. Bernabíwan Marcos ishcanin bütiwan Chipre marcaman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablum ichanga purïshinanpaj Silasta pushacuran. Chaymi Antioquía irmänucuna imaćhüpis yanapaycunanpaj Tayta Diosninchipa maquinman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Chaura Siria quinranćhüpis, Cilicia quinranćhüpis jutucaj irmänucunata shacyaycächir Pabluwan Silas puriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Chaypita Derbe marcaman, Listra marcaman ćhayaran. Listra marcaćhu Tayta Jesústa wiyacuj Timoteuwan tincuran. Timoteupa maman Israel warmi caran. Tayta Jesústapis manchapacuj. Papäninmi ichanga griego runa caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra marcaćhu irmänucunapis, Iconio marcaćhu irmänucunapis Timoteuta allipa ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Griego runapa wamran carmi ichanga, jïrucüni caran. Chaymi purïshinanta munar Israel-masincuna mana jamurpänanpaj Timoteuta Pablo jïrucachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Chaypita Pabluwan-ima marcan-marcan purir, willaparan: «Jerusalén marcaćhu Jesúspa caćhancunawan mayur irmänucuna parlanacushanta wiyacunquiman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chayta wiyar jutucaj irmänucuna sumaj shacyäcuran. Waquin runacunapis waranmaylla Tayta Jesúspa shiminta ćhasquicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Chaypita Asia quinranćhu Pablo willapäcunanta Espíritu Santu mićhaptin, Frigia quinranpa, Galacia quinranpa aywar, ");
INSERT INTO qxhNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia marcapa mujunninman ćhayaran. Bitinia marcaman aywayta munaran. Munaptinsi, Tayta Jesús caćhamushan Espíritu Santu mićharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Chaymi Misia uranpa yarpuran Tróade marcacaman. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chay marcaćhu puñuycaptin, Pabluta Tayta Diosninchi ricapacachiran. Macedonia marca runa mañacuycaran: «Yanapaycallämay. Macedonia marcaman shaycallämuy, ari» nir ");
INSERT INTO qxhNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ricapacuyninćhu shiminta willacunäpaj Tayta Diosninchi pushaycämashanta tantiyacärishcä. Chaymi Macedonia marcaman aywanäpaj juclla camaricärirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Chaura Tróade marcapita aywacur, Samotracia marcaman bütiwan ćhayashcä. Warannin Neápolis marcaman ćhayashcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chaypita Filipos marcamanna ćhayashcä. Filipos marca Macedonia quinranpa jatun marcan car, Roma runacunapa marcan caran. Chay marcaćhu juyapärishcäraj. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Diyawarda junaj captin, Tayta Diosninchita mañacunanpaj Israelcuna jutucänanta yarpar, mayu cantunman aywarä. Warmicunallata jutucashta tarir, Tayta Diosninchipa shiminta willaparä. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Chayćhu juturaycaran mama Lidiapis. Payga Tiatira marcapita caran. Achic-achicyaycaj rusïllaman tiñish bayïtacunata ranticuj. Manchapacuj warmi captin, Tayta Diosninchi shacyächiran Jesúspa shimin shungunman ćhayananpaj. Chaymi Pablo willapäcushanta cushish ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Chaymi llapan yawar-masintin ushyacuran. Jinarcur nimaran: «Tayta Jesústa llapan shungüwan wiyacushäta musyanqui. Wasïman aywashun. Pachächishayqui» nir imanaypapis wasinman pushamaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Juc junaj Tayta Diosninchita mañacuj aywarcaycashäćhu supay maquichacushan jipashwan tincurä. Supaypa maquinćhu purir, llapanta musyaj. Tucuyta musyapacur, mandajnincunata chay-chica jillayta gänachij. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chay jipash jipäta japaraycar puriran: «Paycuna Llapanta Camaj Tayta Diosninchipa maquinćhu cawan. Tayta Diosninchi jishpichishunayquipaj willacuycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Chaynuylla waran-waran umäta nanächiran. Alläpa umäta nanächiptin, ićhiycur, Pablo piñacuran: «Supay, cay jipashta caćhariy. Jesucristu nishannuylla jarguj» nir. Jarguptin, jipashta supay caćhariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Chaura jipashpa mandajnincuna mana gänarannachu. Jillay maquinman mana ćhayaptin Pablutawan Silasta charircur, auturdäpa dispächuman aparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Auturdäman ćhayarcachir, niran: «Caycuna Israel runa. Marca-masinchicuna ticrapanacunanpaj shimiyaycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yarpashanchita pampaman ćhurar, quiquin yarpashanta yaćhacunanchita munan. Munaptinpis, mana ćhasquishunpächu. Roma runa caycar, ¿imapätaj wiyaycäshunpis?» ");
INSERT INTO qxhNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Niptin, llapan runa Pablutawan Silasta chiquipacarcäriran. Ullgucaycäriran. Chaymi auturdäcunapa shiminta wiyaycur, jalapaćhaycur Pablutawan Silasta sumaj wascaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wascayta ushyariycur, carsilman wićhgaycuran. Carsil täpaj runapa maquinman ćhuraran: «Sumaj ricanqui. Jishpirunman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chaymi carsil täpaj Pablutawan Silasta sumaj rurimanraj wićhgaran. Ćhaquincunatapis jirucunawan amurcachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pullan-pagasna carsil junta Pabluwan Silas alabansacunata cantaycaran. Tayta Diosninchitapis mañacurcaycaran. Llapan wićhgarajcunapis wiyaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Niycaptillan, illajpita pacha sicsicyaran. Pacha sicsicyaptin, carsiltapis cuyurachiran. Llapan puncucunapis quićhacäcuran. Carsilćhu wićhgarajcunata watarächishan cadinacunapis pascacäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Carsil täpaj runa ricchapacurir, llapan puncu quićharaycajta ricaran. Chaymi wićhgarajcuna jishpicushanta yarpar, cuchilluwan tucsicuriyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wañuchicuyta munaycaptin, Pablo jayacuriran: «Ama tucsicuychu. Pipis mana jishpishachu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Niptin, täpaj-masincunata niran: «Achquita ratachimuy.» Achquita ratachipuptinga, sicsicyaycar juclla aywarcur, Pablupa Silaspa ñaupanman jungurpacuycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jinarcur, jucläman pusharcur tapuran: «Taytacuna, ¿imataraj ruräman Tayta Diosninchipa maquinćhu cawanäpaj?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paycuna niran: «Tayta Jesúspa shiminta ćhasquicuptiqui, Tayta Diosninchi jishpichishunquipaj. Llapan yawar-masintiqui Tayta Diosninchipa maquinćhu cawanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Chaynuy nir wasinpa carsil täpaj runata Tayta Diosninchipa shiminta willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Willapaptin, Pablupawan Silaspa janan raćhir ushyash captin, juclla jampipuran. Chay chacaylla wasinpa ushyacuranpis. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wasinman pusharcur jararan. Tayta Diosninchipa shiminta ćhasquicushanpita cushicuywan juc shungulla micupacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pacha wararcuptin, auturdäcuna carsilman murucucunata caćharan Pablutawan Silasta caćhariycunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Chaura carsil täpaj runa Silastawan Pabluta willaran: «Caćhariycunajpaj auturdäcuna willachimasha. Chaymi mana manchacullar llucshicuy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablum ichanga ćhayaj murucucunata niran: «Nuwacuna Roma runa caycä. Mana tapumällar, llapan runapa ricay ñawinćhu wascar ushyamasha. Wićhgachimasha. Jinarcur pacayllapa caćhariycamayta munaycäman, ¿au? Munaptinpis, mana llucshishächu. Wićhgachimashannuylla quiquincunaraj jurgamächun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Chaynuy niptin, cutircur auturdäcunata willaycuran. Roma runa cashanta mayar, auturdäcuna mancharicäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Chaymi Pablutawan Silasta carsilpita jurgurcur, niran: «Taytacuna, mana musyaynïwan llutanta rurashcä. Cananga cay marcapita aywacuy, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carsilpita llucshirir, mama Lidiapa wasinman ćhayaran. Llapan irmänucunata shacyächipärir, aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Aywacur, Pabluwan Silas Anfípolis marcaman, Apolonia marcaman ćhayaran. Chaypita Tesalónica marcaman ćhayaran. Chayćhu Israel runacunapa shuntacäna wasin caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yaćhacash car, shuntacäna wasiman Pablo aywaran. Quimsanin diyawarda junajcunaćhu Tayta Diosninchipa shiminta tantiyachicuran: ");
INSERT INTO qxhNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","«Washäcuj wañunanraj, cawarimunanraj caran» nir. Chaycunata sumaj tantiyachicur niran: «Jesúsmi Tayta Diosninchi caćhamushan Washäcuj caycan. Paypita willapashcaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sumaj willapaptin, waquin Israel runacuna Jesúspa shiminta ćhasquicuran. Pabluwanpis, Silaswanpis jutucaran. Paycunawan waquin mama-warmicunapis, achcaj jäpa runacunapis jutucaran. Jäpa runacuna Tayta Diosninchita manchapacuj. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Jesúspa shiminta mana ćhasquicuj mayur Israel runacunam ichanga chiquicuywan juyupa ullgucaycäriran. Chaymi jilla runacunatawan chiqui runacunata mincacuran: «Llapan runata shimiyay Pablupawan Silaspa cunćhan jatarinanpaj» nir. Mincacushan runacuna Jasónpa wasinman ćhayapuran. Pablutawan Silasta chariyta munaran ullgush caycaj runacunapa maquinman ćhurananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Chaura pacharashanćhu mana tarir, wasiyuj Jasóntawan waquin irmänucunallata janćharcur-janćharcur auturdäcunaman aparan. Ćhayaycächir, japariypa niran: «Cay runacuna marcan-marcan runacuna ticrapanacachiyllaćhu aruycan. Marcanchimanpis ćhayamushana. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","‹Jucshi mandamajninchi. Jesús nishanshi mandamajninchi› nircaycan. Roma mandamajninchipa shimintapis pampaman ćhurarcaycan. Chay ticrapanacachicujta cay Jasónraj pachächishapis.» ");
INSERT INTO qxhNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chaynuy niptin, mandajnintin llapan runa ticrapanacuran. Ullgucarcäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Chaymi jillayta jutupaycuptinraj, irmänucunatapis, Jasóntapis, auturdäcuna caćhariran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chaura chacarcuptillan, Berea marcaman irmänucuna Pablutawan Silasta caćharcuran. Berea marcaman ćhayar, Israelcunapa shuntacäna wasinman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tesalónica runacuna juyu captinsi, Berea runacuna alli shungu caran. Pablo willapäcushantapis cushish wiyaran. Ichanga waran-waran Tayta Diosninchipa shiminta liguiran tincuchinanpaj. Willapashan rasunpa cashantapis, mana rasunpa cashantapis sumaj tincuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Chay marcaćhu Israel runacunapis achcajmi Tayta Diosninchipa shiminta ćhasquicäriran. Jäpa mama-warmicunapis, jäpa mayur runacunapis ćhasquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Chaura Berea marcaćhu Pablo willacushanta mayar, Tesalónica marcapita mayur Israel runacuna aywapuran. Ćhayar, runacunata shimiyaran Pabluta ticrapunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","15","Chaymi irmänucuna Pabluta jishpirachiran lamarpa cantullanpa aywacunanpaj. Yanagajnincunapis Atenas marcacaman aywäshiran. Berea marcaćhümi ichanga Silaswan Timoteo juyapäriran. Chaymi Atenas marcapita cutircamur, Pablupa yanagajnincuna niran: «Silas, Timoteo, jucllash Atenas marcaman aywanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenas marcaćhu Silastawan Timoteuta shuyar, Pablo ricapacur puriycaran. Jircapa jaracunanta achcata ricar, juyupa llaquicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Chaymi shuntacäna wasićhu Israelcunawanpis, Tayta Diosninchita manchapacuj jäpa runacunawanpis tapunacuj. Läsaćhüpis waran-waran tincushan runata tantiyachij. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","«Epicúreos» nishan yaćhajcunawanpis, «Estoicos» nishan yaćhajcunawanpis tapunacuj. Chaura Tayta Jesúspita Pablo willapäcuptin, wañushcuna cawarinanta willapäcuptin, apaycaćhänacuran: «¿Imataraj cay runa rimacunsi?» nir. Waquinnam ichanga niran: «Mana ricsish jircacunapitaćhi willacucuycan.» ");
INSERT INTO qxhNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chaura «Areópago» nishan pachaćhu sisyunman pusharcur, tapuran: «¿Ima willapatataj puriycächinqui, unaypita-pachachu, jipatarächu? ");
INSERT INTO qxhNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Rimashayquita imaypis mana wiyarüchu. ¿Tantiyachimanquimanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Chay Atenas marcaćhu jinan runapis, jäpa runacunapis jipa willapäcunata ashillar cawaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Chaymi Areópago sisyunćhu llapanta tantiyachir Pablo niran: «Atenas taytacuna, mä, sumaj wiyaycallämay. Jamcuna jircacunata sumaj manchapacunqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Marcayquipa purir, jircapa jaracunantapis, capillancunatapis ricapashcä. Juctapis tarishcä. ‹Mana ricsishanchi Taytanchipa capillan› nir isquirbiraycan. Chaura pï cashantapis mana musyaycarsi, manchapacuycanqui. Cananga paypita willapäcuycä. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Cay pachatapis, llapan imacunatapis Tayta Diosninchi camaran. Paypa maquinćhümi janaj pachapis, cay pachapis caycan. Chaymi runa rurashan wasita mana wasichacunchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Runacuna yanapänanpaj imancunapis mana pishinchu. Quiquinmi cawachimajninchi. Paypita cawanchi. Alli cawananchipaj llapanta tarichimanchi. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","«Tayta Diosninchi juc runallapita chay-tucuyćhu marcayächisha. Mayćhu yurinanchipäpis, imaycaman cawananchipäpis camacächin. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Llapantapis camacächiran yarpaćhacurir-yarpaćhacurir pï cashantapis musyananchipaj. Yatayllapa ashishan-jina tantiyacuyta munar, rasunpa Tayta Diosninchi cashanta tantiyacushun. Payga ricaycämanchi. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Yurinanchipäpis, arunanchipäpis, cawananchipäpis, paymi camacächin. Chayćhi unay willapa rimajniquicunapis niran: ‹Chay taytallapita caycanchi.› ");
INSERT INTO qxhNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Rasunpa Tayta Diosninchipa wamran caycar, runa rurashancunata ama taytachacushunchu. Runacuna yarpaćhacurir-yarpaćhacurir jircapa wasintapis tucuy-nirajta ruran jurillapita, jillayllapita, rumillapita. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","«Ñaupata runacuna mana musyayninwan juchata ruraptinpis, Tayta Diosninchi mana rimacuranchu. Cananmi ichanga may-chayćhüpis runacuna jucha aparicushanpita wanacunanta, shiminta wiyacunanta munaycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Juc junaj llapan runapa juchanta Tayta Diosninchi jurgapanga. Juchanchita jurgapämänanchipaj shuyninpa Jesústa acracusha. Acracushanta musyananchipaj wañushanpita cawarachimusha.» ");
INSERT INTO qxhNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","«Wañushanpita cawarachimusha» niptin, waquin runa asipar ushyaran. Waquinna juc junaj wiyananpaj jitapuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","34","Waquin runacunam ichanga Pablo willapäcuptin, Tayta Jesúspa shiminta ćhasquicuran. Chaura Pablo sisyunpita llucshicuptin, aywäshiran yaćhaj Dionisiupis, mama Damarispis, waquin irmänucunapis. Dionisiuga «Areópago» nishan pachaćhu llapan runata tantiyachij. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chaura Atenas marcapita aywacur, Corinto marcaman Pablo ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Israel-masin Aquilawan tincuran. Aquilapa warmin caran Priscila. Aquilaga Ponto marcapita caran. Chaypis mandaj Claudio llapan Israel runacunata Italia quinran Roma marcapita jarguchiptin, aywacuran. Chayraj Corinto marcaman ćhayash caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Aquila purichina jiru ćhaqui wasi tulduta jiraj. Pablupis wasi tulduta jiraptin, iwal juyar Aquilawan yanapänacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Diyawardacunaćhüna Israelcunapa shuntacäna wasinman aywaycur, Tayta Jesúspa shiminta Pablo sumaj tantiyachiran. Israel runacunatapis, jäpa runacunatapis aunichiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia marcapita Silaswan Timoteo ćhayamuptin ima ruraynintapis caćhariycurna, Israel runacunata Pablo willaparan: «Jesúsga Tayta Diosninchi acracushan Washäcujninchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Willapaptinpis Israel runacuna wiyacuyta mana munar, Pabluta ashllir ushyaran. Ashllir ushyaptin, müdananta tapsir ushyashpan piñacuran. «Cananga quiquiquicunapita ñacaymanpis ćhayanquipaj. Imaman ćhayaptiquipis, ama jitapamanquichu. Cananpita jäpa runacunata Tayta Diosninchipa shiminta willapäshaj» nir aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Shuntacäna wasipita aywacur, Pablo ćhayaran Tito Justupa wasinman. Payga Tayta Diosninchita manchapacuj runa caran. Wasinpis shuntacäna wasi wajtallanćhu caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Chay shuntacäna wasipa mayur runa Crispupis wasinpa Tayta Jesúspa shiminta ćhasquicäriran. Waquin Corinto runacunapis Pabluta wiyar, Tayta Jesúspa shiminta ćhasquicäriran. Payman yupachicur, ushyacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Juc chacay ricapacuynillanćhu Pabluta Tayta Jesús niran: «Pablo, imatapis ama manchacuychu. Shimiquita ama amucurcuychu. Shimïta willapäcamuy. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Maquïćhu puriptiqui, pipis mana imanäshunquipächu. Cay marcaćhu acracushä runacuna achcajmi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Chaymi wata pullanninraj Corinto marcaćhu Pablo juyapäriran Tayta Diosninchipa shiminta tantiyachicur. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mandaj Galiónpa maquinćhu Acaya marcacuna caycashan wichan Israel runacuna Pabluta ticrapacurcuran. Charircur, Galiónpa dispächunman aparan: ");
INSERT INTO qxhNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Cay runa: ‹Tayta Diosninchita alliman ćhurashun› nirpis, mandajninchipa shiminta pampaman ćhuraycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Chaura Pablo chapacunanpaj caycaptin, Mandaj Galión niran: «Israel runacuna, cay runa llutanta rurash captin, wañuchicush-ima captin, shimiquita wiyäman. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ninshi-ninshi-jananmi ichanga, Moiséspa shimin-janan piñanacushayqui-jananmi ichanga, wiyaytapis mana munächu. Quiquiquicunalla ushyacächinquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Chaynuy nir dispächunpita llapanta jarguriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jarguriptin, dispächu puncullaćhu Sóstenesta magapäcuran. Payga shuntacäna wasićhu mayur runa caran. Chaypis mandaj Galión mana imasi jucuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Corinto marcaćhu unaylla Pablo juyapäriran. Chaypita llapan irmänucunata wamayaycur, Cencreas marcaman aywacuran. Cencreas marca lamar cantullanćhu caran. Aquilapis warmin Priscilawan aywäshiran. Siria quinranman mana llucshillar, Cencreas marcallaćhu Pablo ajchanta rutucuran: «Tayta Diosninchiwan parlanacushäta ćharcushcäna. Payga sumaj washämasha» nir. Chaynuy nir bütiman jigarcur, aywacäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Éfeso marcaman ćhayar, warmintinta Aquilata jaguiycuran. Chay marcaćhu shuntacäna wasićhu Israel runacunawan Pablo tapunacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Israel runacuna Pablo unaylla juyapärinanta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Munaptinsi, Pablo niran: «Juyayta mana camäpacüchu. Tayta Diosninchi camacächiptinmi ichanga, imayllapis cutimushaj.» Chaynuy nir Éfeso marcapita bütiwan aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea marcaman ćhayar, Jerusalén marcaman aywaran jutucaj irmänucunata wamayaj. Jinarcur Antioquía marcaman cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antioquía marcaćhu unaylla juyapäriran. Chaypita unay ćhayashan marcacunaman yapay watucuj Pablo cutiran. Galacia quinranmanpis, Frigia quinranmanpis cutiran. Marcan-marcan purir, llapan irmänucunata sumaj shacyächiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Chay wichan Alejandría marcapita Éfeso marcaman Apolo jutiyuj runa ćhayaran. Payga Israel runa caran. Rimaytapis sumaj yaćhaj. Tayta Diosninchipa shimintapis sumaj tantiyaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tayta Jesúspita sumaj yaćhacuran. Chaymi llapan shungunwan Jesús pï cashantapis tantiyachicuran. Ichanga Ushyachicuj Juanpa shimillantaraj Apolo musyaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Juc cuti shuntacäna wasićhu Apolo llapan shungunwan willapäcuycaran. Chayta wiyar, Aquila warmintin shuyninpa wasinman pusharan. Aquilapa warmin caran Priscila. Jinarcur mana musyashancunata sumaj tantiyachiran. Tayta Diosninchipa maquinćhu imanuy-imanuy cawananpäpis willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Chaypita Acaya quinranman Apolo aywacuyta munaptin, irmänucuna shacyächiran. Acaya quinranćhu irmänucunamanpis cartacuran: «Apolo Tayta Diosninchipa shiminta sumaj tantiyachicun. Llapan shunguyquiwan ćhasquicäriy, ari» nir. Allipaj chay marcaman Apolo ćhayaran. Tayta Diosninchi yanapaptin, irmänucunata sumaj shacyächiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Israel-masincunam ichanga tincuparan: «Jesús mana Washäcujninchichu» nir. Chaypis llapanpa ricay ñawinćhu Tayta Diosninchipa shiminta liguipar, Apolo tantiyachiran: «Jesúsga rasunpa Washäcujninchi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Chaura Corinto marcaćhu irmänu Apolo juyashan wichan Pablo puntan-puntan quinranpa aywar, Éfeso marcaman ćhayaran. Irmänucunawan tincur, tapuran: ");
INSERT INTO qxhNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Tayta Jesúspa shiminta ćhasquicuptiqui, ¿Espíritu Santu charicurcushcashunquichu?» nir. Chaura paycuna niran: «Espíritu Santu runacunata charishanta mana imaypis wiyarüchu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pabluna tapuran: «Chaura, ¿pipa shiminta wiyacushpayquitaj ushyacushcanqui?» nir. Paycuna niran: «Ushyachicuj Juanpa shiminta willapämaptillan, ushyacärishcä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Chaura Pablo niran: «Ushyachicuj Juan runacuna juchapita wanacuptinraj, ushyachiran. Ichanga quiquin Juan niran: ‹Mana Washäcujchu cä; payga jipätaraj shamunga. Paypa shiminta ćhasquicunquiman.› Chaynuy nir Tayta Jesús shamunanpaj rimaycaran.» ");
INSERT INTO qxhNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chaura Pablupa shiminta wiyacur, Tayta Jesús nishannuylla ushyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Jinarcur irmänucunapa umanman maquinta ćhuraycur, Tayta Diosninchita Pablo mañacuran. Mañacuptin, Espíritu Santu charicurcuran. Charicurcuptin, juc casta rimaycunata rimaran. Tayta Diosninchi yarpächishantapis musyachicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Runacunaga ćhunca ishcaywan-yupay (12) juturpaycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Chaura Éfeso marcaćhu juyar shuntacäna wasiman aywarcur-aywarcur, quimsa quillantin Pablo tantiyachicuran Tayta Diosninchipa maquinćhu cawananpaj. Mana manchacullar imanuypapis aunichiyta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tincupäcujcunam ichanga chapata rurar, llapan runata shimiyaran: «Chay mushuj willapawan pantachishunquipaj.» Chaynuy niptin llapan irmänucunata pushacurcur, «Tiranupa» nishan runapa shuntacäna wasinman Pablo witicuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ishcay watantin willapäcuptin, Asia quinran llapan Israel runacunapis, jäpa runacunapis Tayta Jesúspa shiminta wiyash caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tayta Diosninchi camacächiyninpa Pablo jishyaćhucunata allchacächiran. Supaycunatapis jarguran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Chaymi Pablupa müdananta imallantapis apacuran jishyaćhucunata allchacächinanpaj. Ćhayachiptin, jishyaćhucuna allchacäcuran. Supaycunapis caćhariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Chay wichan ishcaj-quimsaj Israelcuna supayta jargur puriran. Paycunapis Tayta Jesús nishannuylla supaycunata jarguyta munar, niran: «Pablo willacushan Tayta Jesúspa jutinwan jargushayqui. Cay runata caćhariy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Chayta ruraycaran cüra Escevaspa janćhis ullgu wamrancuna. Escevasga Israel runacunapa mayur cüran caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Juc junajmi ichanga Jesúspa shiminćhu jarguyta munaycaptin, supay niran: «Jesústa ricsï. Pablo pï cashantapis musyä. Jamcuna, ¿pitaj canqui jargumänayquipaj?» ");
INSERT INTO qxhNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chaynuy nir supay pucllacushan runa ullgucäcuran. Llapanta charircur, magar ushyaran. Chaura Escevaspa wamrancuna jalapaćhalla, yawarlla wasipita jishpicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Éfeso marcaćhu chaynuy cashanta mayar, Israel runacunapis, jäpa runacunapis llapallan manchariran. Tayta Jesús sumaj munayniyuj cashanta tantiyaycur, alliman ćhuraycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Chaymi waquin irmänucuna jucha aparicushanta mana chapacuranchu. Llapan wiyay willacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Musyapacujcunapis llapan runapa ricay ñawinćhu chapata ruracunan libruncunata rupachiypa ushyaran. Chay librucunapa ćhaninta yupaptin, pichga ćhunca waranga (50,000) junaj runa arushanpa ćhaninman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Chaynuypa Tayta Jesúspa shimin chay-tucuyćhu mayacaran. Munayniyuj cashantapis runacuna sumaj tantiyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chaypita Pablo yarpaćhacuran: «Macedonia quinranćhüpis, Acaya quinranćhüpis irmänucunata watucurishaj. Jinarcur Jerusalén marcaman cutishaj. Chaypita Roma marcaman aywayta camashaj» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Chaynuy yarpar, willacäshij-masin Timoteutawan Erastuta ñaupachiran Macedonia marcacunaman. Quiquin Pablum ichanga Asia marcacunallaćhüraj juyapäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chay wichan Jesúspa shimin-janan Éfeso runacuna apaycaćhänacur, ullgucaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ullgucarcärinanpaj jillay tacaj Demetrio juchayuj caran. Payga jillaypita tacaj acapalla Artemisapa capillanta-niraj. Tacapacujcuna jillayta sumaj tariran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Juc junaj arüshijnincunatawan llapan tacaj-masincunata shuntaycur, Demetrio niran: «Tacapacushanchi jillayllawan cawashanchita musyanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Canan ricay ñawiquićhu Pablo willapäcuycan: ‹Runa rurashan capillaga mana munayniyujchu› nir. Willapäcushanta cay Éfeso marcanchićhüpis, Asia marcacunaćhüpis mayna runacuna aunisha. Rurashanchi capillata mana manchapacunnachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Yargayman ćhayachimäshun. Acapalla capilla rurashanchicunata pipis mana rantinganachu. Mamanchi Artemisatapis, capillantapis runacuna mana manchapacunganachu. Payta llapan runa manchapacuj Asia marcanchicunaćhüpis, may-chayćhüpis.» ");
INSERT INTO qxhNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetrio chaynuy niptin, tacaj-masincuna juyupa ullgur japarpararan: «Mamanchi Artemisallata alliman ćhurashun. Payga munayniyujmi. Éfeso runacunapa mamanmi» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Japarpaptin, llapan runa ullgucaycäriran. Tincuypa-tincuycashanćhu Aristarcutawan Gayuta charircur, läsaman janćharan. Macedonia marcapita Aristarcuwan Gayo Pabluta yanagämuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Yanaguincunata charishanta mayar, nanachicunanpaj Pablupis aywayta munaran. Munaptinpis, purïshijnincuna mićharan. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia marcapa waquin mandajnincunapis Pabluwan yaćhänacur, imamanpis mana jaticänanpaj willachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Chaura läsaćhu waquin runa wichaypa-uraypa japarpaptin, marca runacuna imapita tincuypa-tincushantapis mana tantiyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Chaymi waquin mayur Israel runacuna Alejandro jutiyuj runata ñaupaman jayaycur, rimachiran. Chaura Alejandro llapan runata tantiyachinanpaj maquinwan upällachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Alejandro Israel runa cashanta musyar, ishcay üra-ima juc shimilla llapan Éfeso runacuna japarpararan: «Mamanchi Artemisallata alliman ćhuralläshun. Payga munayniyuj. Éfeso runacunapa maman» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Chaura Éfeso auturdäcunapa isquirbänun llapanta upällaraycachir, niran: «Marca-masïcuna, wiyaycallämay. Marcanchićhu Mamanchi Artemisa juyashanta llapan runa musyan. Capillantapis sumaj rican. Mamanchi-niraj janaj pachapita shicwamushantapis musyan. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Pipis mana wasguipanmanchu. Chaymi manacajllapäga ama tincupänacushunchu. Imata rurananchipäpis sumajraj yarpaćhacushun. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Janćhamushayqui runacuna Mamanchi Artemisapa capillanta mana suwashachu. Pampamanpis mana ćhurashachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetriuwan tacaj-masincuna piwanpis dimandanacuyta munar, auturdäcunaman aywachun. Quiquincuna nanachicuchun. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Manchäga shuyninpa auturdäcunata jayarcachir, imatapis parlanacärichun. ");
INSERT INTO qxhNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Canan tincuypa-tincushanchi mana allichu. Mayur mandajninchicuna mayar, ticrapanacushanchita yarpanga. Tapumaptinchi, imanuypa chapacuytapis mana camäpacushunpächu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Chaynuy piñacuriycur, llapan runata wasinman-caman cutircachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Chaura runacuna tincuypa-tincushan ćhawacäcuptin, llapan irmänucunata jayaycachir, Pablo anyaparan. Jinarcur: «Aywallä» nir Macedonia quinranman aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Aywacur, ćhayashan marcacunaćhu Tayta Jesústa wiyacuj irmänucunata sumaj shacyächiran. Chaypita Grecia quinranman ćhayaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Chay marcaćhu quimsa quilla juyapäriran. Chaypita Siria quinranman bütiwan aywacunanpaj caycashanćhu, mayur Israel runacuna wañuchinanpaj yarpapashanta mayaran. Chaymi ćhaquillapana Macedonia quinranpa Pablo cuticuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Cuticuptï, yanagämaran Sópatros, Aristarco, Segundo, Gayo, Timoteo, Trófimo, Tíquico. Sópatrosga Berea marcapita caran. Papäninpa jutin caran Pirro. Aristarcuwan Segundo, Tesalónica marcapita caran. Gayo, Derbe marcapita. Trófimuwan Tíquico, Asia quinranpita caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yanaguïcuna Tróade marcaman ñaupacuran. Chayllaćhu Pablutawan ishcanïta shuyarämaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Libadüraynaj tanta micuna fiesta ushyacäcuptinraj, Filipos marcapita bütiwan aywacärirä. Pichga junajllata yanaguïcunata tariparä. Tariparcur, Tróade marcaćhu juc simäna juyapärirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Chaura dumingu chacay irmänucunawan jutucarä micupacunäpaj, tantata paquipacur mallichinacärinäpaj. Warannin aywacunan captin, pullan-pagascaman Pablo willapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Juturashä wasiga ishcay altusyuj caran. Achquicunapis rataycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","«Eutico» nishan müsupis wasipa bintänanćhu jamaraycaran. Pablo pullan-pagascaman willapäcuptin, puñunaywan ñipchit-ñipchityaycaran. Puñucäcur, ishcay janay altuspita shicwacamuran. Jatarachij ćhayaptin, wañushana caycaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Chaura Pablo yarpuriycur, müsuta margacurcuran. Irmänucunatapis niran: «Ama llaquicuychu. Cawaycanmi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Jinarcur altusman jigarcur, Pablo tantata paquircur-paquircur mallichimaptin, llapanï micurä. Payga pacha warashancaman willapäcuran. Chaypita aywacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Waquin irmänucunana cawaycajta müsuta wasinman pushacuran. Chaypita llapan irmänucunapis jatunpa cushicäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Jinarcur bütiwan ñauparcur, Aso marcaćhu Pabluta shuyarparä. Payga yarpashanta ćharcur, ćhaquillapa shamuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso marcaćhu Pabluwan tincur, bütiwan llapanï Mitilene marcaman aywacärirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Warannin Quíos marca chimpanman ćhayarä. Chaypita büti ićhinan Samos marcaman ćhayarä. Waranin Trogilón marcaćhu ićhipärir, Mileto marcaman ćhayarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Asia quinranćhu Pablo juyapacayta mana munaptin, Éfeso marcaman mana ćhayallar, aywacärirä. Camäpacur, «Pentecostés» nishan fiestallapaj Jerusalén marcaman ćhayayta munaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Chaura Mileto marcallapita Éfeso marcaćhu mayur irmänucunata Pablo jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ćhayamuptin, niran: «Irmänucuna, ćhayamushäpita-pacha imanuy Asia quinranćhu cawashäta musyanqui. Ricay ñawiquićhu purishcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mana yaćhaj-tucullar Tayta Jesúspa mandunta rurashätapis musyanqui. Israel-masïcuna chiquipämaptinpis, ñacachimaptinpis, wagashalläwan ushyaräcun. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Jamcunata willapänajpaj yarpashäcunata mana imatapis pacashcächu. Manchäga wasin-wasin, llapan wiyay willapashcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Israel runacunatapis, jäpa runacunatapis jucha aparicushanpita wanacur Tayta Diosninchipa maquinćhu cawananpaj, Tayta Jesúspa shiminta ćhasquicunanpaj tantiyachishcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Cananga Espíritu Santu apamaptin, Jerusalén marcaman aywaycä. Imaman ćhayanätapis mana musyärächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Maypa puriptïpis, Espíritu Santu musyachiman ñacanalläta, carsilman ćhayanalläta. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ñacanäta musyarpis, mana llaquicüchu. Wañuyman ćhayarpis, Tayta Jesús nimashanta ćharcunä. Chaymi cawashäcaman Tayta Diosninchi llaquipäcuj cashanta pï-maytapis willapänä. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Marcayquicunapa purir, Tayta Diosninchipa maquinćhu cawanayquipaj willaparä. Cananpitam ichanga mana ricamanquipänachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Llapaniquita willapashcaj. Cananga quiquiquipitana imamanpis ćhayanquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tayta Diosninchi yarpashancunata llapanta willapashcaj. Imatapis mana pacashcächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Irmänucuna, quiquiquicunapis wiyacunquiman. Mayur irmänu captiqui, uyshata alli ricashan-jina jutucaj irmänucunatapis ricanquiman. Maquiquićhu cawan. Sumaj ricanayquipaj carguyquiman Espíritu Santu ćhurashcashunqui. Paycunata Tayta Diosninchi wamrachacusha Wawan Jesús wañuyman ćhayayninpa. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","«Aywacuptï, micucuj liyun-jina pantachicujcuna shamunga irmänucunata ñacachir ushyacächinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Waquin pantachicujcuna irmänu-masillayquipita jataringa. Maquillanćhu purichinanpaj: ‹Allita rimä› nir irmänucunata riguichinga. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Chaymi quiquiqui-pura sumaj michinacunqui. Quimsa watantin pagas-junajta wiguïpawan willapashäcunata jungarunquiman. Llapaniquita willapashcaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Irmänucuna, Tayta Diosninchipa maquinman ćhuraycaj. Paypa shiminta sumaj willapashcaj. Sumaj llaquipäcuj cashpan yanapamäshun shungun munashannuy cawananchipaj. Aunishan irinsata tarichimashpanchi ñaupallanćhu llapan wawancunata cawachimäshun. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«Nuwa mana pipa jillaynintapis, jurintapis, müdanantapis munapashcächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Manchäga quiquï arushcä. Chaymi yanaguïcunatapis, quiquïtapis mana imapis pishïmashachu. Llapantapis musyanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nuwa-jina arur, pishipacujcunatapis yanapänayquipaj willapashcaj. Quiquin Tayta Jesúspis tantiyachimashcanchi: ‹Mañapacur, llaquicunchi. Tarichicurmi ichanga, cushicunchi› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pablo rimayta ushyariycur, irmänucunawan jungurpacaycärir, Tayta Diosninchita mañacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","«Aywallä» niptin, llapan macallanacurcur-macallanacurcur wagapäcuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","«Cananpita mana ricamanquipänachu» nishanpita llapan llaquicuran. Llaquicursi, büti caycashan-cajcaman yanagaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Chaura irmänunchicunata: «Aywallä» nir bütiman jigarcur, aywacurä. Cos marcaman ćhayarä. Warannin junaj Rodas marcaman ćhayarä. Chaypita Pátara marcaman ćhayarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pátara marcapita Fenicia marcaman büti llucshiycajta tarir, jigacarcärirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Siria quinranman aywar, wac chimpanćhu Chipre marcata ricarä. Chaypitaraj Tiro marcaman ćhayarä. Chayćhu apashan jipicunata büti jaguiycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Irmänunchicunawan tincurmi ichanga, janćhis junaj juyapärishcä. Paycuna Espíritu Santu musyachiptin, Pabluta mićharan: «Jerusalén marcaman ama aywaychu, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Chaura juyanä junaj ćharcuptin, irmänunchicuna warmintin, wamrancunawan marcanpita lamar cantuncaman yanagämaran. Paycunawan jungurpacaycärir, Tayta Diosninchita mañacurä. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Jinarcur: «Aywallä» nir bütiman jigarä. Paycunam ichanga wasinman-caman cuticäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Chaypita Tiro marcapita aywacur, Tolemaida marcaman ćhayarä. Chaycamalla yacupa aywarä. Chay marcaćhu irmänunchicunawan wamayänacur, juc junaj juyapärishcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Warannin junaj aywacur, yanaguïcunawan Cesarea marcaman ćhayarä. Chay marcaman ćhayar, Jesúspita willacuj Felipipa wasinćhu pachacushcä. Paytapis Jerusalén marcaćhu janćhis irmänucunata acrar, acracurunaj micuyta aypucunanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipipa ćhuscuj jipashnincuna Tayta Diosninchipa willacujnin caran. Paycuna Tayta Diosninchipa shungun yarpashanta musyachicuj. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ishcay-quimsa junaj juyaycaptï, Judea quinranpita ćhayamuran Tayta Diosninchipa willacujnin Agabo. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Payga Pablupa sinturunninta pascapariran. Sinturunninwan maquin-ćhaquinta watacurcur, niran: «Espíritu Santu nin: ‹Sinturunyuj runata caynuy Jerusalén marcaćhu mayur Israel runacuna wancunga. Jinarcur, jäpa runacunapa maquinman ćhuranga›.» ");
INSERT INTO qxhNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chayta wiyar, llapan irmänunchicunawan mañacurä: «Pablo, Jerusalén marcaman ama aywaychu, ari» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pabluna nimaran: «¿Imanirtaj waganqui? Wagaptiqui, shungüpis ishquicäcun. Jerusalén marcaćhu wascamaptinsi, ćhasquicushaj. Tayta Jesús-janan wañuchimaptinsi, mana chapacushächu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Chaura imanaypapis chapayta mana camäpacur: «Tayta Diosninchi camacächishannuy caycullächun» nir imatapis mana rimaparänachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chaypita llapanta sumaj camaricuriycur, Jerusalén marcaman aywacärirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Aywacuptï, Cesarea marcapita waquin irmänunchicuna Jerusalén marcacaman yanagämaran. Ćhayaptï, Chipre runa Nasónpa wasinman pachächimaran. Nasónga unaypita-pacha Tayta Jesústa wiyacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Chaura Jerusalén marcaman ćhayaptï, cushi-cushilla irmänunchicuna ćhasquicamaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Warannin junaj Santiaguta watucuj Pablo aywaptin, nuwacunapis aywäshirä. Mayur irmänucunatawan tarirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paycunata wamayaycur, jäpa runacunapa marcanćhu purishanta, ima-imatapis rurashanta, Tayta Diosninchi imaćhüpis yanapashanta Pablo willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Llapallanta willaptin, Tayta Diosninchita alliman ćhuraran. Jinarcur niran: «Irmänu Pablo, Israelcuna achcajmi Jesúspa shiminta ćhasquicuycan. Chayta quiquiquipis musyanquina. Chaypis Moiséspa shiminta ćharcunanchitaraj munaycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Jäpa runapa marcancunaćhu tiyaj Israel runacuna sharcamurmi ichanga willacusha: ‹Moiséspa shiminta ćharcunanchitapis, iti ullgu wamranchicunata jïrunanchitapis, auquillunchicunapa shiminta ćharcunanchitapis Pablo mana munanchu› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Waquin Israel-masinchicuna llutanta yarpaptin, ¿imanaypataj chapacushun? Ćhayamushayquita mayanga. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«Chaymi llapan runapa ricay ñawinćhu alli llucshinayquipaj sumaj yarpaćhacushun. Cayćhu ćhuscuj runacuna Tayta Diosninchi aunishanta ćharcuycan. Ichicllana pishin. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Aunishanta ćharcushan musyacänanpaj ćhuscunwan ushyacamuy. Ajchantapis rutuchiy. Rutushayquipa ćhanintapis ćhuranqui. Chaynuy ruraptiqui, Israel-masinchicuna ninga: ‹Manacajllapita Pabluta tumpasha. Paypis Moiséspa shiminta llapanta ćharcuycan. Tayta Diosninchipis alli ñawinwan rican.› ");
INSERT INTO qxhNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«Sumaj yarpaćhacurir jäpa irmänucunata mayna cartacushcä: ‹Jircacunaman jarashanta ama micunquichu. Uyshata pishtarpis yawarninta shutuchinqui. Yawartapis ama micunquichu. Ricashayqui warmiwan, ricashayqui runawan ama cacunquichu› nir.» ");
INSERT INTO qxhNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Chaura warannin junaj Moiséspa shiminta ćharcur, änir ćhuscun runawan Pablo ushyacuran: «Tayta Diosninchi allina ricamäshun» nir. Jinarcur imay junaj ajchanpa ćhaninta ćhurananpäpis Tayta Diosninchipa wasinman willaj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Janćhis junajta aywaycaptin Tayta Diosninchipa wasinćhu Pabluta ricar, Asia quinranpita shamuj waquin Israel runacuna ullgucaycäriran. Tincuypa-tincur, Pabluta charicarcäriran: ");
INSERT INTO qxhNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Israel-masicuna, yanapaycallämay. Cay runacuna chay-tucuypa willapäcuycan marcanchita pampaman ćhurananpaj, Moiséspa shimintapis mana ćharcunanpaj. Tayta Diosninchipa wasintapis pampaman ćhurar, jäpa runacunata yaycuchisha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Paycuna Pabluta ricarunaj Éfeso runa Trófimuwan marcaćhu puriycajta. Chayćhi yarparan: «Tayta Diosninchipa wasinmanpis jäpa runata yaycuchisha» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Chaymi llapan runa tincuypa-tincuran. Shuntacaycur Pabluta charicarcärir, wajtaman janćharan. Nircur Tayta Diosninchipa wasin puncuntapis wićhgaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pabluta wañuchinanpaj caycaptin, Roma murucucunapa cumandantita willaran: «Israel runacuna tincuypa-tincurcaycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Chaura cumandanti capitancunatawan murucuncunata shuntariycur, runacunaman juclla aywaran. Paycunata ricar, magarcaycashanćhu Pabluta caćhariycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Caćhariycuptin, murucucunapa cumandantin Pabluta charicurcuran. Ishcay cadinawanraj watachiran. Jinarcur runacunata tapuran: «¿Pitaj cay runa? ¿Imatataj rurasha?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tapuptin, ima niytapis mana camäpacuranchu. Wichaypa-uraypa rimacäriran. Chaymi murucucunapa capitannin ima juchanta taripuyta mana camäpacur, cuartilman Pabluta apacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Apaycaptin runacuna magayta munaptin, wintucurcullar cuartilpa patac-patacninta jigachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Runacuna ullguyllawan japarpaycaran: «Pabluta wañurachiy» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Chaura cuartilman yaycuchinanpaj caycaptin, murucucunapa cumandantinta Pablo niran: «¿Ichicllatapis parlapärishuwanchu?» Chaynuy niptin, cumandanti niran: «¿Griego rimayta yaćhanquichuraj? ");
INSERT INTO qxhNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Egipto marcapita canqui, ¿au? Juc cuti auturdäninchita ticrapur, ćhuscu waranga (4,000) runacunata shuntaycur purishcanqui, ¿au? Wañuchicunayquipaj chunyaj pachaćhu purishcanqui, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pabluna niran: «Mana. Israel runa cä. Cilicia quinran jatun Tarso marcaćhu yurishcä. Cay ullguj marca-masïcunata tantiyaycachishaj, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Chaura cumandanti auniptin cuartilpa patacninćhu ićhicuycur, llapan runata upällachiran. Jinarcur llapan runa tantiyananpaj hebreo rimayninćhu niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Taytacuna, Israel marca mayur runacuna, chapacur rimashäta mä, wiyaycallämay.» ");
INSERT INTO qxhNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Chaura hebreo shimipa rimajta wiyar, llapan upällacaycäriran. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Upällacaycäriptin, Pablo niran: «Nuwapis Israel runa cä. Cilicia quinran jatun Tarso marcaćhu yurishcä. Cay Jerusalén marcaćhu wiñashcäpis. Unay auquillunchicuna-jina cawanäpaj yaćhaj-sapa Gamalielpa shiminpita imatapis yaćhacushcä. Jamcuna-jina Tayta Diosninchipa shiminta ćharcuycä. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Paypa shiminta ćharcur, Jesúspa shiminta ćhasquicuj irmänucunata wañuy-caway jaticaćhar ushyarä. Warmi ullgutapis watacurcur, carsilman apachirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Imata ruranäpäpis mayur cüra, mayur Israel runacuna sisyunćhu aunimasha. Paycuna llapanta musyan. Quiquincuna Damasco marcaćhu Israel mayur-masinchicunapaj urdinta jumaran. Chaywanraj Tayta Jesúspa shiminta wiyacuptin, pitapis charinä caran. Wascananpäpis Jerusalén marcaman apamunä caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Chaymi Damasco marcaman lasdüsi yaycupaycaptï, janaj pachapita achqui illajpita chillapyamuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Chaura pampaman tunicurä. Jitaraycashäćhu wiyarä: ‹Saulo, Saulo, ¿imanirtaj chiquimar jaticaćhaycämanqui?› nimujta. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nimuptin, tapurä: ‹¿Pitaj canqui, Tayta?› nir. Chaura nimuran: ‹Nazaret marca Jesúsmi cä. Chiquimar jaticaćhaycämanqui.› ");
INSERT INTO qxhNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","«Yanaguïcunapis achqui chillapyamujta ricaran. Parlapämashantam ichanga mana wiyaranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nuwana nirä: ‹¿Imataraj ruräman, Tayta?› Chaura nimaran: ‹Jatariy. Damasco marcaman ayway. Chayćhu imata ruranayquipäpis willashunquipaj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","«Achqui chillapyamashanpita japrayacäcurä. Puriytapis mana camäpacurächu. Chaymi maquilläpita yanaguïcuna Damasco marcacaman apamaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Chay marcaćhu Israel runa Ananías juyaran. Moiséspa shiminta wiyacur Tayta Diosninchita manchapacuj captin, jinanćhu tiyaj Israel-masincuna allipa ricaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Lädüman sharcamur, pay nimaran: ‹Irmänu Saulo, japrayash ñawiqui quićhacangana.› Chaymi ñawï quićhacäcuptin, Ananíasta ricarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Pay nimaran: ‹Manaräsi yuriptillayqui, unay auquillunchicuna manchapacushan Tayta Diosninchi acracushurayqui shungun munashanta ruranayquipäpis, Tayta Jesústa ricanayquipäpis, shiminta wiyanayquipäpis. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Chaymi ricashayquitapis, wiyashayquitapis chay-tucuyćhu willapäcunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Cananga Tayta Jesúspa shiminta ćhasquicuy. Ushyacuy. Tayta Diosninchitapis mañacuy jucha aparicushayquita jungacaycur mana yarparänanpaj.› ");
INSERT INTO qxhNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Chaypita Jerusalén marcaman cutimur, Tayta Diosninchipa wasinman aywarä. Tayta Diosninchita mañacuycashäćhu ricapacurä. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ricapacuynïćhu Tayta Jesús nimaran: ‹Jerusalén marcapita juclla jishpicuy. Shimïta willacuptiquisi, runacuna mana ćhasquishunquipächu.› ");
INSERT INTO qxhNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nuwana nirä: ‹Tayta, shimiquita ćhasquicujcunata ñacachishäta, shuntacäna wasicunapita jurgurcur-jurgurcur carsilman apashäta, magar ushyashäta musyan. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Willacujniqui Estebanta wañuycachiptinpis, aunirä. Wañuchicujcunapa müdanantapis ricapurä.› ");
INSERT INTO qxhNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Paymi ichanga nimaran: ‹Caypita aywacuy. Jäpa runacunata willapäcunayquipaj carupa caćhacushayqui.› » ");
INSERT INTO qxhNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Chaynuy niptin, runacuna ullgucarcäriran. Mana wiyarannachu. Manchäga japarparan: «Pabluta juclla wañurachishun. Ama cawachishunchu» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Chigaypa ullgur müdanancunatapis llushticuycaptillan, allpacunatapis aspircur-aspircur wicapaycaptillan, ");
INSERT INTO qxhNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","murucucunapa cumandantin niran: «Carsilman wićhgarcur, Pabluta sumaj wascay. Runacuna ullgünanpaj imallapis achäqui cangam. Juchanta pashtapacunanpaj wascay.» ");
INSERT INTO qxhNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Chaura wascananpaj wataraycächiptin, capitanta Pablo tapuran: «Juchayuj cashätapis, mana juchayuj cashätapis mana musyallar Roma runa caycaptï, ¿wascamänayqui camacanchu?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Niptin, cumandantinta willaran: «Cumandanti, cay runa Roma runash. ¿Canan imataraj ruranqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Chaura cumandanti aywarcur, Pabluta tapuran: «¿Rasunpachu Roma runa canqui? Mä, willamay» nir. Tapuptin niran: «Au. Rasunpa Roma runa cä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Cumandantina niran: «Chay-chica jillaywanraj Roma runa cayman ćhayashcä.» Pabluna niran: «Nuwam ichanga yuriynïpita-pacha Roma runa cä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Chaynuy niptin, Pabluta wascananpaj caycashanćhu witicäriran. Cumandantipis mancharicäcuran: «¿Roma runatarächu cadinawan wancushcanchi?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Warannin junaj cadinawan wataraycächishanćhu Pabluta pascaran. Mayur Israel runacuna imapita dimandashantapis sumaj musyayta munar, llapan mayur Israel runacunata, mayur cüracunata cumandanti jayachiran. Ćhayaptin, Pabluta carsilpita jurgurcur, tincuchiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Chaura Pablo mana chapacullar llapan mayur Israel runata ricärir niran: «Marca-masïcuna, canancaman Tayta Diosninchipa ricay ñawinćhu alli cawashcä. Chaymi allilla cawaycä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Chaynuy niptin, mayur cüra Ananías Pabluta shimićhu cutachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Chaura Pablo shiminta jugarir niran: «Ishcay cära runa, jamtapis Tayta Diosninchi cutashunquipaj. Moiséspa shiminman tupurraj juchayuj cashäta, mana cashätapis ashipämanquiman. Juchäta tarirraj wascamanquiman. Mayur Israel runa caycar juchäta mana tarillar cutachimarga, quiquiqui juchata aparicuycanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Chaynuy niptin, runacuna Pabluta ullgüparan: «Tayta Diosninchi acracushan mayur cürata ashllishcanqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pabluna niran: «Taytacuna, mayur cüra cashanta mana musyaynïwan rimarcushcä. Tayta Diosninchipa shiminpis nin: ‹Mayur runata ama ashlliychu.› » ");
INSERT INTO qxhNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Chaura Israel mayur runacuna ishcay yarpayyuj runacuna caran: fariseucunawan saduceucuna. Chayta musyar, Pablo wiyacächiypa niran: «Israel-masicuna, taytäpita-pacha fariseu runa cä. Chaymi wañushcuna cawarinanta yupachicushäpita mayur Israel runacunapa sisyunninman apaycamar dimandarcaycamanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wañushcuna cawarinanta rimaptin, fariseucunapa shungun Pabluman ticracurcuran. Chaymi fariseucunawan saduceucuna piñacuyta jallaycärisha. Quiquin-puralla mayur Israel runacuna ticrapanacuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceucunapa yarpashan fariseucunapa yarpashanwan mana tincuranchu. Saduceucuna yarpan: «Wañushallanchiwan ushyaräcunchi. Anjilpis, almapis mana canchu» nir. Fariseucunana yarpan: «Wañushanchipita cawarimushun. Anjilpis, almapis caycan» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Chaura wichaypa-uraypa jayapänacuycaptin, waquin Moiséspa shiminta yaćhaj fariseucuna niran: «Cay runa juchallicushanta mana tarinchichu. Almacunapis, anjilcunapis cay runata ricaripushaćhi.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Chaynuy niptinsi, runacunapa ullguynin mana jasacaranchu. Alläpa ullguptin, cumandanti manchariran: «Pabluta wañuchirunman» nir. Chaymi murucucunata niran: «Cuartilman jishpichiy.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chay pagas ricapacuyninćhu Pabluta Tayta Jesús niran: «Ama imatapis manchacunquichu. Cay marcaćhu shimïta willacushayquinuylla Roma marcaćhüpis willapäcunquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Chaura warannin junaj waquin Israel runacuna parlanacuran: «Pabluta mana wañuchishanchicaman micuytasi, yacutasi ama mallishunchu. Shiminchita mana ćharcuptinchi, Tayta Diosninchi ñacachimäshun» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Chaynuy parlanacuran ćhuscu ćhunca-yupay (40) runacuna. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Parlanacuriycur, mayur cüracunata, mayur runacunata willaj aywaran. Ćhayaycur, niran: «Nuwacuna parlanacushcä: ‹Pabluta mana wañuchishanchicaman micuytasi, yacutasi ama mallishunchu. Shiminchita mana ćharcuptinchi, Tayta Diosninchi ñacachimäshun› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Taytacuna, canan cumandantita mañacunqui: ‹Sumaj tapunäpaj Pabluta caćhamuy. Ima juchan cashantapis sumaj musyayta munä› nillar. Manaräsi ćhayamuptillan, nuwacuna wañuchinäpaj shuyaraycäshaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Chaynuy parlanacärishanta Pablupa paninpa wamranpis wiyaran. Wiyar cuartilman aywarcur, willaycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Chaura juc capitanta jayarcur, Pablo niran: «Cay müsuta cumandantiman pushay. Shungun musyashanta willamuchun.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Niptin, cumandantiman ćhayaycachir, niran: «Wićhgaraj Pablo jayarcachimar, cay müsuta pushamunäpaj mañacamasha. Shungun musyashantash willashunqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Niptin, yatalla pusharcur, cumandanti tapuran: «¿Imatataj musyaraycanqui?» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Chaura müsu willaran: «Waquin Israel runacunawan mayur runacuna parlanacärisha. Paycuna mañacushunquipaj: ‹Sumaj tapunäpaj sisyunnïman Pabluta caćhapaycallämay, ari› nillar. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Chaynuy nishuptiqui, ama auninquichu. Ćhuscu ćhunca-yupay (40) runacuna parlanacusha: ‹Pabluta mana wañuchishanchicaman micuytasi, yacutasi ama mallishunchu. Shiminchita mana ćharcuptinchi, Tayta Diosninchi ñacachimäshun› nir. Paycuna caćharcunallayquita shuyarpaycan.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Chaura cumandanti niran: «Shimiquita pashtapacurunquiman. Upällalla cuticunqui, ari.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Jinarcur cumandanti ishcaj capitanta jayarcachir niran: «Sumaj chacarcuptin, Cesarea marcaman Pabluta apanayquipaj camaricuy. Camaricuchun ishcay paćhac (200) murucucuna ćhaquipa aywananpaj, janćhis ćhunca (70) cawallun muntash aywananpaj, ishcay paćhac (200) tucsicunanwan-caman aywananpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pablo muntacunanpäpis cawalluta camariy. Cawaycajta mandaj Félixman ćhayachinayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pabluta apaj murucucunawan cartatapis apachiran. Cartaćhu niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Tayta Félix, nuwa mayur mincayniqui Claudio Lisias cartacallämü. ¿Allillachu juyapaycanqui? ");
INSERT INTO qxhNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Israel runacuna charircur, cay runata wañuchinanpaj caycaran. Chaymi Roma runa cashanta musyar, murucücunawan washashcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jinarcur imapitasi tincupänacushanta musyayta munar, mayur Israel runacuna sisyunta rurashanman aparä. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Chayćhu quiquincunapa yarpashan-janallan tincupänacushanta tantiyacurä. Wañuchicänanpäpis, carsilćhu wićhgaränanpäpis achäqui mana caranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Canan mayur Israel runacuna wañurachinanpaj parlanacushan rinrïman ćhayamuptin, apaycächimü. Chiquij runacunatapis ñaupayquićhu juchanta jurgapänanpaj nishcä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Chaura murucucuna capitanninta wiyacur, chay chacaylla Antípatris marcaman Pabluta ćhayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Warannin junaj ćhaquipa aywaj murucucuna cuartilninman cuticäriran. Cawalluwan aywajcunalla Cesarea marcaman ćhayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesarea marcaman ćhayar, cartatapis, Pablutapis mandaj Félixpa maquinman ćhuraran. ");
INSERT INTO qxhNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Chaura cartata liguircur, maypita cashantapis Pabluta tapuran. Cilicia marca runa cashanta willaptin, niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Chiquishujniqui runacuna ćhayamuptinraj, shimiquita wiyashaj.» Chaynuy nir wañucuj mandaj Herodespa wasillanćhu Pabluta täpachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Chaypita pichga junajta mayur cüra Ananíaswan waquin mayur Israel runacunapis, yaćhaj Tértuluta pushacurcur, Cesarea marcaman aywaran. Mandaj Félixman ćhayaran Pabluta ñauquinanpaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Mandaj Félixna Pabluta jayachiran. Dispächunman ćhayachiptin, yaćhaj Tértulo niran: «Mandaj Félix, ima allish allilla juyächimanqui. Tantiyay-sapa cayniquipa marcäcuna alli cawananpaj imatapis rurashcanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","«Tayta Félix, allilla cawachimashayquipita chay-tucuyćhu alli cawapäcurcaycä. Jatunpa cushicullä. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Alli shungu captiquipis, alläpa mana jamarächicümanchu. Chaymi juc-ishcayllatasi wiyaycallämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Cay runash aypäcuj jishya-yupay chay-tucuyćhu Israel runacunata ticrapanacaycächin. Payga Nazaret marca Jesústa ćhasquicujcunapa mayur runash. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Jerusalén marcaćhüpis Tayta Diosninchipa wasintash pampaman ćhurasha. Chaymi nuwacuna rïsu charirä. Quiquïcuna yarpashänuylla llapantapis ushyacächiyta munarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ichanga ushyacächinäpaj charirpaycaptï, cumandanti Claudio Lisias jaticämusha. Jićhuramasha. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jinarcur ñaupayquićhu ñauquinäpaj caćhamasha. Tayta Félix, quiquiquisi sumaj tapurga, rimashänuyllam juchanta taripanquipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tértulo rimashallanta waquin Israel runacunapis rimarcäriran: «Rasunpam» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Chaura: «Shimiquita wiyashun, Pablo» nir mandaj Félix rimachiran. Rimachiptin, Pablo niran: «Tayta, ima allish rimachicamanqui. Unaypita-pacha marcäcunata alli ricanqui. Chaynuypa manacajta jitapämashanpita chapacushaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Chayraj ćhunca ishcaywan (12) junaj Jerusalén marcaman Tayta Diosninchita alliman ćhuraj aywashäpis. Shimï rasunpa cashanta musyanayquipaj, pitapis tapunquiman. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mana piwanpis piñanacuycajtachu, pitapis piñanacaycächijtachu tarimasha. Tayta Diosninchipa wasinćhüsi, shuntacäna wasićhüsi, jinan marcaćhüsi mana pitapis ticrapanacachishcächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Manchäga cay runacuna tumpaycäman. Rasunpa juchallicush captï, jajlläćhu mä, nimächun. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«Jesúspa shiminta ćhasquicushäpita: ‹Pantacash› nimaptinsi, Tayta Diosninchipa maquinćhu cawaycä. Payllata manchapacü. Moiséspa shimin nishannuylla, unay willacujcunapa shimin nishannuylla, auquillunchicuna cawashannuylla cawaycä. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Israel-masïcuna wañushcunata Tayta Diosninchi cawarachinanta yupachicushan-jina nuwapis yupachicü. Payga shiminta wiyacujcunatapis, mana wiyacujcunatapis cawarachinga. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Chaymi jucha aparicuyta mana munächu Tayta Diosninchipa ricay ñawinćhüpis, runa-masïcunapa ricay ñawinćhüpis. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Unayga achca wata juclällaćhu juyar, pishipacujcunata yanapänäpaj cuyachicuynïcunatapis Tayta Diosninchipaj apar, Jerusalén marcäman cutirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Chaypita Tayta Diosninchipa wasinman ushyacuj aywarä. Ushyacurä Tayta Diosninchi alli ricamänanpaj. Jinarcur ruriman yaycurä. Juc-ishcaj runallawan Asia quinranpita shamuj Israel-masïcuna tarimasha. Piwanpis mana piñanacuycarächu. Paycunaraj shamunman ñauquimänanpaj. Llutanta ruraycajta tarimash carga, juchäta jurgapämänanpaj shamuchun. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Manchäga cay runacuna jajlläćhu nimächun. Jerusalén marcaćhu mayur Israel runacunapa sisyunninćhu ñauquimarpis, mana ima juchätapis tarishachu. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nuwapa juchä shimïta jugarishallä. Shimïta jugarir, nirä: ‹Wañushcuna cawarinanta yupachicü.› Chaypita ñauquircaycämanqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Chaynuy niptin, Tayta Jesúspita rimashanta sumaj musyar, juc junajpaj mandaj Félix jitaparan: «Cumandanti Lisias shamuptinraj, imapita ñauquinacushayquitapis sumaj tapucushayqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Jinarcur mandaj Félix täpaj murucunta niran: «Pabluta ama wićhgaychu. Manchäga täpaylla sumaj täpay. Ricsinacushancuna watucunantapis, imata apapämunantapis ama mićhanquichu.» ");
INSERT INTO qxhNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Warannincuna warmin Drusilawan ishcanin mandaj Félix ćhayamuran. Warmin Drusila Israel warmi caran. Ishcanin Pabluta jayarcachir, rimashanta wiyapararan: «Washäcuj Jesústa wiyacushun» nir willapaptin. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pablo willaparan: «Llapan runa allillata ruranman. Shungun munapashallanta ama ruranmanchu. Cay pacha ushyacaptin, Tayta Diosninchi llapan runapa juchanta jurgapanga» nir. Chayta willapaptin, mancharicäcur Félix niran: «Chayllapäna. Jäcur, yapay jayachishayqui.» ");
INSERT INTO qxhNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Chaynuypa parlaj tumpaylla achca cutipa Pabluta jayachiran: «Caćhariycunäpaj jillayta jutupämanga» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Jillayta mana jutupaptin, Pabluta mana caćhariranchu. Chaypita ishcay watata cargunpita mandaj Félix llucshicuran. Porcio Festuna cargunta ćhasquiran. Mandaj Félix mayur Israel runacunawan alli ricanacuyta munar, Pabluta wićhgaraycajllata jaguiycuran. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Chaura cargunta ćhasquircur, Cesarea marcaman mandaj Porcio Festo ćhayaran. Quimsa junajta Jerusalén marcaman aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ćhayaptin, mayur cüracunapis, mayur Israel runacunapis Pablupita willaparan. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Yaparir-yaparir mañacuran: «Tayta Festo, Israel runacunata llaquipar, Pabluta apachimuy, ari» nir. Rasunpa apachiptin caminućhüshi shuyaycur, wañurachinan caran. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Chaura mandaj Festo niran: «Cesarea marcaćhu murucucunawan Pabluta sumaj täpaycächï. Waracunallana aywashaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mayganiquipis jäcuptiqui, Cesarea marcaman aywashun. Chay runa llutanta rurash captinga, ñaupäćhu ñauquinquiman.» ");
INSERT INTO qxhNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pusaj junajlla-yupay Jerusalén marcaćhu juyapärir, Cesarea marcaman Mandaj Festo cuticuran. Warannin dispächunman Pabluta jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pabluta ćhayachipuptin, Jerusalén marcapita aywaj mayur Israel runacuna tucuyta jitaparan. Ichanga juchanta mana taripuranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Chaymi chapacur Pablo niran: «Imaćhüpis mana juchallicushcächu. Moiséspa shimintapis llapanta wiyacushcä. Tayta Diosninchipa wasintapis mana pampamanchu ćhurashcä. Roma marcaćhu mandaj Césarpa shimintapis ćharcushcä.» ");
INSERT INTO qxhNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Chaynuy niptin, mayur Israel runacunawan alli ricanacuyta munar, mandaj Festo Pabluta tapuran: «¿Jerusalén marcapa aywashuwanchu? Llapan jitapäshushayquipita quiquï ashipushayqui» nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pabluna niran: «Pï-maypa dimanduntapis ushyacächinayquipaj Roma marcaćhu mandajninchi César ćhurashcashunqui. Chaymi cay dispächullaćhu imapitasi ushyacächinquiman. Musyashayquinuypis Israelcuna chiquipämänanpaj mana ima achäquillatapis rurashcächu. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Juchallicush caycar wañuchimaptin, mana chapacümanchu. Mana imatapis rurash caycaptïmi ichanga, Israel runacunapa maquinman pipis mana ćhuramanmanchu. Mandaj Césarman apachimay.» ");
INSERT INTO qxhNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Chaura tantiyachijnincunawan parlanacuriycur, mandaj Festo niran: «Pablo, mandaj Césarpa maquinman ćhayayta munaptiqui, Roma marcaman apachishayqui. Payraj shimiquita wiyanman.» ");
INSERT INTO qxhNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Chaypita mana aycällatana mandaj Festo cargunta ćhasquishanpita Cesarea marcaman warmin Bereniciwan mandaj Agripa ishcanin wamayaj aywaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Achca junaj juyapacaptin Pabluta täpaycächishanta willar, mandaj Festo niran: «Tayta Agripa, mandaj Félix cargunpita llucshicur, juc rïsu runata mana caćhariranchu. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Chaymi Jerusalén marcaman aywaptï, mayur cüracunawan mayur Israel runacuna maquichacamayta camar mañacamasha. Juclla munasha: ‹Chay runa rasunpa wañunman juchanpita› ninäta. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Munaptinsi, nirä: ‹Roma runacuna mana sumaj tapucaćhällar, pitasi mana wañuchinchu. Chiquinacushanwan ñauquinacunantaraj shuyan.› ");
INSERT INTO qxhNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Chaymi Israel runacunawan shamur, warannin junajlla chay runata dispächüman jayachirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Rasunpa juchan cashanta yarpashcä. Ñauquijcunam ichanga yarpashänuychu mana ñauquisha. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Manchäga cawashan-janan, wañush Jesús-janan tincupänacuran. ‹Wañush› niptinsi, Pablo: ‹Jesús cawaycan› nin. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ima ruraytapis mana camäpacur, tapushcä: ‹¿Juchayquita sumaj ashinäpaj Jerusalén marcaman aywashunchu?› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Chay Pablum ichanga mana munashachu. Manchäga mañacamasha: ‹Roma marcaćhu mayur mandajninchi Augusto Césarraj juchäta ashipamächun› nir. Chaymi Roma marcaman apachinäcaman täpaycächï.» ");
INSERT INTO qxhNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Chaynuy niptin, mandaj Agripa niran: «Tayta Festo, chay runapa shiminta nuwapis wiyaycüman.» Festuna niran: «Yä. Wara jayachimushun shiminta wiyananchipaj.» ");
INSERT INTO qxhNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Warannin junaj dispächuman mandaj Agripa warmin Bereniciwan ćhayaran. Llapan cumandanticunapis, jinan marca auturdäcunapis aywäshiran. Achic-achicyaycaj müdanash aywaran. Llapan shuntacarcuptin, mandaj Festo Pabluta jayachiran. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ćhayachiptin, mandaj Festo niran: «Tayta Agripa, llapallayquita willashayqui. Israel runacuna Jerusalén marcaćhüpis, cayćhüpis cay runata wañuchinäta munan. Pabluta wañurachinäta munar ullgurcaycan. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Sumaj tapucaćharmi ichanga, juchallicushanta mana taripushcächu. Roma marcaćhu mandajninchi Augusto Césarman apachinäpaj quiquin mañacamaptin, aunishcä. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Taytacuna, llapaniqui yanapaycallämay. Cay runapa juchanta mana tarir, mandaj Césarman imata nir cartacuytapis mana camäpacüchu. Tayta Agripa, ¿imata nirtaj cartacüman? Tapüshimay ari, imata nir cartacunäpäpis. ");
INSERT INTO qxhNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Jucha aparicushanta mana tariycar apachiptï, pingaypaj canga, ¿au?» ");
INSERT INTO qxhNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Chaura mandaj Agripa Pabluta niran: «Mä, quiquiqui rimarcuy. Mä, willamay.» Chaynuy niptin, Pablo niran: ");
INSERT INTO qxhNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Tayta Agripa, ima allish wiyamanqui. Israel runacuna tucuyta jitapämashanpita shimïwan chapacushaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tayta, Israel runacuna yarpashantapis, imapita apaycaćhänacushantapis sumaj musyanqui. Chaymi mana yamacällar wiyaycallämay, ari. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Tacsha cashäpita-pacha marcäćhu juyashätapis, Jerusalén marcaćhu juyashätapis Israel-masïcuna musyan. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Tacshäpita-pacha fariseucuna yarpashanta ćharcushätapis musyan. Fariseucunalla Moiséspa shiminta llapanta sumaj ćharcun. Sumaj musyayta munar, maygantapis tapucunquiman. Munar, rasullanta willashunquipaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Cananga auquillücunata Tayta Diosninchi aunishanman yupachicushäpita auturdäcunaman ćhayachimasha. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tayta Diosninchi aunishan ćharcucänanta ćhunca ishcaywan castantï llapanï shuyarpaycä. Chaymi pagas-junajpis mana yamacällar Tayta Diosninchita alliman ćhurarcaycä. Shungun munashantapis llapanta rurarcaycä. Chaypis, Tayta Agripa, wañushcunata Tayta Diosninchi cawarachinanta mana ćhasquir, waquin mayur Israel-masïcuna tumparpaycäman. Tayta Diosninchi aunishanman nuwapis yupachicü. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Imanirtaj jamcunapis Tayta Diosninchi wañushcunata cawarachinanta mana ćhasquipäcunquichu? ");
INSERT INTO qxhNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Ñaupata quiquïpis, Nazaret marca Jesústa ćhasquicuj irmänucunata juyupa chiquiparä. ‹Allita ruraycä› nir wañuy-caway chiquipar jaticaćhar ushyarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Chaymi mayur cüra aunimaptin, irmänucunata Jerusalén marcaćhu charircur-charircur carsilachishcä. Wañuchiptinpis, aunirä. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Jesústa wasguipanan cashpan achca cuti shuntacäna wasiman yaycurir, irmänucunata ñacachir ushyashcä. Chigaypa ullgur juclä marcacunamanpis aywarcur, Jesústa wiyacuj irmänucunata jaticaćhar ushyarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Chaynuypa mayur cüracuna aunir urdinta jumaptin, Damasco marcamanpis aywaycarä. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Tayta Agripa, aywaycaptï, lasdüsi-ima janaj pachapita chillapyamuran. Chillapyamushanman intipis mana tincuranchu. Aywäshimajcunata llapanïta achicyäramaran. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Chaura llapanï pampaćhu jitaraycashäćhu hebreo rimayćhu jayacamujta wiyarä: ‹Saulo, Saulo, ¿imanirtaj chiquipämashpayqui jaticaćhaycämanqui? Picayujta jaytar, quiquillayqui nanächicunqui› nir. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Chaura nuwapis tapurishcä: ‹¿Pitaj canqui, Tayta?› nir. Tapuptï, quiquin nimaran: ‹Tayta Jesúsmi cä. Nuwallata chiquir jaticaćhaycämanqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Chaypis juclla jatariy. Caćhä canayquipaj ricaripushcaj. Chaymi shimïta willacur, canan ricashayquitapis, wara-warantin ricachinajtapis, llapanta willapäcunqui. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israel runacunapa maquinpitapis, jäpa runacunapa maquinpitapis washäshayqui. Paycunaman aywanayquipaj caćhaycaj. ");
INSERT INTO qxhNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Willapäcur tantiyachinqui jucha aparicuypita wanacunanpaj, mayur supaypa maquinpita Tayta Diosninchipa maquinman ashucunanpaj. Shimïta ćhasquicuptin, jucha aparicushantapis Tayta Diosninchi jun