﻿USE sofia;
DROP TABLE IF EXISTS sofia.qwhNT_vpl;
CREATE TABLE qwhNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qwhNT_vpl WRITE;
INSERT INTO qwhNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tëta Abrahampa y rey Davidpa mirenincunapitam Jesucristoqa yuricorqan. Y quecunam Jesucristupa awiluncuna cayan: ");
INSERT INTO qwhNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa tsurinmi carqan Isaac; Isaacpa tsurinnam Jacob; Jacobpa tsurinnam carqan Juda y wauqincuna; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaqa carqan Tamarpa qowanmi; wamrancunanam carqan Zera y Fares; Farespa tsurinnam carqan Esrom; Esrompa tsurinnam Aram; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa tsurinnam Aminadab; Aminadabpa tsurinnam Nason; Nasonpa tsurinnam Salmon; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonqa carqan Rabpa qowanmi; wamrancunanam carqan Boos; Boosqa carqan Rutpa qowanmi, y tsurinnam carqan Obed; Obedpa tsurinmi carqan Isai; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaipa tsurinnam carqan rey David. Rey Davidpa tsurinnam Salomon; Salomonpa mamannam carqan Uriaspa biudan; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa tsurinnam carqan Roboam; Roboampa tsurinnam Abias; Abiaspa tsurinnam Asa; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa tsurinnam Josafat; Josafatpa tsurinnam Joram; Jorampa tsurinnam Ozias; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziaspa tsurinnam Jotam; Jotampa tsurinnam Acas; Acaspa tsurinnam Ezequias; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa tsurinnam carqan Manases; Manasespa tsurinnam Amon; Amonpa tsurinnam Josias; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa tsurinnam carqan Jeconias y wauqincunapis; Jeconias rey quecanqan watachomi israel nunacunata Babilonia nunacuna presurcur apacuyarqan marcancunaman. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tse tiempuchonam Jeconiaspa tsurin Salatiel yuricorqan; Salatielpa tsurinnam carqan Zorobabel; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa tsurinnam Abiud; Abiudpa tsurinnam Eliaquim; Eliaquimpa tsurinnam Asor; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorpa tsurinnam Sadoc; Sadocpa tsurinnam Aquim; Aquimpa tsurinnam Eliud; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa tsurinnam Eleasar; Eleasarpa tsurinnam Matan; Matanpa tsurinnam Jacob; ");
INSERT INTO qwhNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa tsurinnam carqan Jose; Josenam Mariapa qowan carqan; y Mariapa wawannam carqan Dios Acrashqan Jesucristu. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tëta Abrahampita asta rey Davidyaq chunca chuscu (14) awilucunam cayarqan. Rey Davidpita asta Babiloniaman israel nunacunata presu apayanqanyaqpis jina chunca chuscu (14) awilucunam cayarqan. Tsenollam jina Babilonia marcacho israel nunacuna presu cayanqanpita asta Dios Acrashqan yuriconqanyaqpis chunca chuscu (14) awilucuna cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Quenomi carqan Jesucristupa yuriquinin: Jesucristupa maman Mariam, casacuyänanpaq Josewan parlayashqana cayarqan. Peru Josewan manaraq juntacarmi, Mariaqa Santu Espiritupa poderninwan qeshyaqyärerqan ");
INSERT INTO qwhNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseqa alli nuna carmi, tse nobian Maria qeshyaqyäquicuptin, mana desonrananrecur paquellapa jaqirita munarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tseno jaqiriquita pensarishqa quecaptinmi, Diospa anjelnin Joseta sueñinincho, queno nerqan: —Davidpa castan Jose, ama mantsaquïtsu Mariawan casaquita. Porqui Santu Espiritupa poderninwanmi pëqa qeshyaq tucushqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tsemi wamran yuririptin, jutin churanqui Jesusta. Porqui pemi peman marcäcoqcunataqa jutsancunapita salbanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Quecuna pasacushqa Diospa une profetan willaconqan cumplicänanpaqmi. Tse profetam queno nishqa carqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Juc shipashmi donsellallaraq quecar qeshyaq tuconqa y juc ollqu wamratam qeshpiconqa. Pepa jutinmi churayanqa ‘Emanuel’ ” nishpa. (Emanuel ninanqa “Noqantsicwanmi Dios quecan” ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josenam tsecunata sueñuquicur punonqanpita riyaramur, anjel nenqanta cäsucurnin, Mariata ellucurcorqan warminpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Peru Joseqa Mariawan manaran juntu punuyarqanraqtsu, manaraq wamaqshu wamranta qeshpicuptin. Wamra yuricuriptinnam, jutin churarqan Jesusta. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jerusalencho Herodis rey quecaptinmi, Jesucristu yuricorqan Judea probinsiacho quecaq Belen marcacho. Tsepinmi Jerusalenman chäyarqan qoyllurcuna estudiyaq allapa yachaq nunacuna. Pecunaqa shayämorqan inti yarqamunan ladu allapa caru marcapitam. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pecunam queno tapucuyarqan: —¿Mechotaq quecan israel nunacunapa reynin cananpaq yuricushqa wamra? Porqui marcäcunapitam ricayämorqö qoyllurninta. Tsemi shayämorqö adoraqnin —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tseta wiyecurnam, rey Herodisqa y Jerusalencho llapan täraqcunaqa allapa yarpäcachëcho ticracuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tsemi Herodisqa saserdoticunapa mandacoqnincunata y ley yachatsicoqcunata qayecatsir, queno taporqan: —¿Mechotan Dios Acrashqan yuricunan carqan? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tseno tapucuptinnam, niyarqan: —Judea probinsiacho quecaq Belen marcachomi. Tsepaqmi Diospa profetan queno escriberqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judea probinsiacho Belen marca, que marcacho presisaq marcacunapitapis manam qepachotsu quecanqui; Porqui qampitam yarqunqa juc rey y pemi üsha mitseq cuenta israel nunäcunata cuidanqa’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tseno niyaptinnam, rey Herodisqa tse yachaq nunacunata pacallapa qayatserqan, y tapuparqan imepita patsana tse qoyllurta ricayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Willariyaptinnam, queno nerqan: —Taqe washacho quecaq Belen marcaman ewar tse wamrata ashiyämï. Tarïcurnenqa, cutimur noqallätapis willarayämanqui ewar adoranäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Rey Herodis tseno niriptinnam, tse yachaq nunacuna ewacuyarqan. Ewecayaptinam, tse ricayanqan qoyllur jina puntancunata ewar qallecorqan. Wamra quecanqan wayi jananman chëcurnam, qoyllurqa tsellachona quedarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tsenam allapa cushiquicuyarqan qoyllur jinallancho quedareqta riquecur. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wayiman yecurirnam, llulluta maman Mariatawan quecayaqta taririyarqan. Tsenam nopanman qonqurïcur adorayarqan. Tsepitanam apayanqan qorita, insiensiuta y mirra nishqan perfumita quicharir qarayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sueñinincunacho Herodisman mana cutiyänanpaq Dios rebelecuptinnam, tse nunacuna juc ladu nänipa marcancunaman cuticuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tse yachaq nunacuna cuticuyanqanchonam, Diospa anjelnin Joseta sueñinincho queno nerqan: —¡Jina öra sharcur, ewaquï Egiptu nasionman llulluta y mamäninta pusharcur; porqui Herodismi ashitsenqa niñuta wanutsinanpaq. Tsellacho täcuyanqui yape willayanqaqyaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tsenam Joseqa tse öra shäricurcur, tse paqastä niñu Jesusta y mamäntinta pusharcur, Egiptuman ewacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tsechomi täcuyarqan Herodis wanonqanyaq. Tseqa pasacorqan profetantawan Teyta Dios queno willacatsenqan cumplicänanpaqmi: “Egiptu nasionpitam Tsurïta qayarqä” nenqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tse yachaq nunacuna “Cutimushaqmi” nicur mana cutiyaptinnam, rey Herodis allapa piñacurcurcorqan. Tsemi tse yachaq nunacuna tapucur puriyanqan tiempupita cuentata jorqurir, yuricuyashqanpita asta ishque watayoq ollqu wamracunata Belen marcacho y estansiancunacho wanutsiyänanpaq mandacurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tseno wamracunata wanuratsiyaptinmi, profeta Jeremias queno escribenqanwan pactarerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama marcachomi wiyayarqan qaparipa, qayaripa waqaquicunata. Wamrancunapaq llaquiquiwanmi Raquel allapa waqarqan. Shoqayaptinpis, manam shonqun pascacärerqantsu, wamrancuna ushacärishqa captin” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodis wanuriptinnam, Josetaqa Egiptucho quecaptin Diospa anjelnin sueñinincho rebelar queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—¡Jose, sharquï! Cananqa Niñu Jesusta wanutsita munaqcuna wanuriyashqanam. Tsemi Israel nasionman cutiquï, wamrata y mamanta pusharcur —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tsenam Joseqa sharcur, Niñuta y mamäninta pusharcur, Israel nasionman cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Judea probinsiachoqa Herodispa tsurin Arquelaunam rey quecarqan. Tseta musyecurmi, Jose allapa mantsarqan Judeaman chëta. Tsemi sueñinincho Dios notificar rebelashqa captin Galilea probinsiaman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tsechomi Nazaret marcacho täcorqan. Tsecuna pasacuptinmi, Diospa profetancuna “Nazaretpitam canqa” nir, escribiyanqancuna cumplirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tse watacunam bautisacoq Juan Judea probinsiapa tsunyaqnincunapa ewar nunacunata willaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tse willapäcurmi, queno nerqan: —Teyta Dios mandacoqniquicuna cananpaq tiempu chäramunnam. ¡Tsemi mana alli rureniquicunata jaqiriyë! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bautisacoq Juan tseno willapäcunanpaqmi profeta Isaias queno escribishqa carqan: “Tsunyaqchomi juc nuna qayaripa queno willaconqa: ‘Nänicunata derechar limpiaq cuenta prebinicuyë Teytata chasquinequipaq’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpa ropanqa carqan camellupa millwanpitam. Wachäcannam qarapita carqan. Micoqpis langosta curucunatam y tuna tumpushpa mishquincunatam. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Atsca nunacunam Juanman ewayarqan: Jerusalenpita, Judea probinsiapita y Jordan mayu cuchuncho marcacunapita. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jutsancunata willayaptinnam Jordan mayucho Juan bautisarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tseman atscaq fariseucuna y saduseucuna bautisacoq shayämoqta ricar, Juan queno pecunata piñapëcamorqan: —Ä, culebra cuenta nunacuna, ¿imanopataq allapa feyu castigupita salbacuyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jutsa rureniquicunata rasonpa jaqirïcur, allicunatana rurayë. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama pensayëtsu: ‘Abrahampa castan canqantsicrecurmi castigupita salbacushun’ nir. Porqui niyaqmi: Diosqa que rumicunatapis Abrahampa castanqa ticraratsinmanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Imanomi juc nuna jachanwan mana wayücoq montinta siquipita wallurir, ninacho ushacäratsin, tsenomi llapan mana alli ruraqcunapaqqa Dios listu quecan ushacäratsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Noqaqa Diosman cutiquicoq caqtaqa yacullawanmi bautisayashqequi. Peru qepäta shamoqmi siqa, ninano rupecaqwan bautisayäshurniqui, Santu Espiritunta qoyäshunqui. Pëqa allapa poderyoqmi. Tsemi noqaqa sirwïtsu llanqinta puritsinällapaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pëqa triguta wauyaq cuentam nunacunata acranqa. Trigutam wardacunanman wardanqa y pajatanam mana upeq ninacho cayeconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tse tiempum Galileapita Jesus ewarqan Juan quecanqan Jordan mayuman, petapis bautisananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanqa manam munarqantsu bautiseta. Antis quenomi nerqan: —¿Imanopam noqa qamta bautisallashqequi! ¡Antis qamchiri noqalläta bautisecamanquiman! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsenam Jesus nerqan: —Tseta ama yarpäcachëtsu, porqui presisanmi Diospaq alli caqta cumplinantsic —nir. Tseno niptinnam, “Mä ari” nir, bautisecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautisacurirnam, Jesus yacupita yarqaramorqan. Tse öram sielu quichacärerqan, y Jesusnam riquecorqan Diospa Espiritun imeca palumano jananman urärëcamoqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sielupitanam Dios queno nimorqan: —Quemi noqapa cuyë Tsurï. ¡Perecurmi noqa allapa cushicü! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsepitanam Santu Espiritu Jesusta tsunyaqman pushacorqan. Tsechonam diablu tenteta munarqan Jesusta. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tse tsunyaqchomi chuscu chunca (40) junaqninpi mana imatapis micurishpa cacorqan. Tsemi mallaqarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsenam diabloqa Jesusman checur, tenteta munar queno nerqan: —Diospa tsurin rasonpa carqa, mä, que rumicunata mandariquï tantaman ticrarinanpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesusnam nerqan: —Diospa palabranmi queno escribirëcan: ‘Manam tantata micurllatsu nunacuna cawayanqa; sinoqa Dios llapan nenqanta cäsucurninmi cawayanqa’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsepitanam diabloqa Jesusta pusharqan Jerusalen santu marcaman. Tsechonam templupa mas altun caqman lloqarcatsir, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Rasonpa Diospa tsurin carnenqa, mä, quepita jeqacorquï. Porqui Diospa palabranmi queno escribirëcan: ‘Anjelnincunatam Dios cachamonqa manaraq rumicunaman jeqaptiqui juclla tsaricuyäshunequipaq’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusnam nerqan: —Diospa palabranmi jina queno escribirëcan: ‘Ama Diosniquita probanquitsu’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tsepitanam juc jatun jircaman pushecur, jinantin munducho nasioncunata riquesancunatawan queno nishpa riquecatserqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Qonqurïcur adorecamaptiqueqa, que llapan riquecanqequitam qoycushqequi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tsenam Jesus nerqan: —¡Quepeq yarqï, diablu! Diospa palabranmi escribirëcan: ‘Diosllatam adoranequi y sirwinequi’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesus tseno nïcuptinnam, diablu ewacorqan; y anjelcunanam yurircur Jesusta sirwiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tsepitanam bautisacoq Juanta carselman llawïcuyanqanta musyarirnin, Galilea probinsiacho Nazaret marcaman Jesus eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Peru Nazaretchoqa manam tärarqantsu; sinoqa Capernaum marcata eucurmi, tsecho täcorqan. Capernaum marcaqa carqan Zabulon y Neftali probinsiacunapa linderunmanpam. Tseqa carqan Galilea Lamar cuchunchomi. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tsecuna pasacuptinmi, profeta Isaias queno escribenqanwan cumplirerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jordan mayupa wac tsimpan lamar cuchuncho quecaq Zabulon probinsiacho, Neftali probinsiacho, Galilea probisiacho täraq mana israel nunacuna, ");
INSERT INTO qwhNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","jutsata rurar cawacoqcunam alli willaquita wiyayanqa, y paqaschono wanita mantsacur cawacoqcunam ricayanqa Diospa actsinta” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tseman chanqanpita patsam Jesus queno nishpa yachatsicur qallecorqan: “Mana alli rureniquicunata jaqiricuyë. Porqui Dios mandacoqniquicuna cananpaq tiempu chäramunnam” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tsepitanam Jesus Galilea nishqan Lamar cuchunpa ewarëcarnin, ishcaq pescadorcuna atarayancunata yacuman jitecayaqta ricarerqan. Pecunaqa cayarqan wauqillantämi. Jucnin caqmi carqan Pedru niyashqan Simon, y juc caqnam carqan Andres. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tsepitanam pecunata Jesus queno nerqan: —¡Shayämï! Noqata qatiyämë. Cananpita witsepam pescaduta elluyanqequipa rantin nunacunatana noqaman elluyämunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tse öram atarayancunata jaqiricur, Jesusta qatircur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsepita pasarirnam, mas washänincho Jesus ricarerqan Santiaguta wauqin Juantawan. Pecunaqa cayarqan Zebedeupa tsurincunam. Pecunam tëtan Zebedeuwan atarayancunata lanchacho remendecayarqan. Pecunatapis Jesus qayarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tsemi tse öra papänin Zebedeuta lanchatawan jaqiricur, Jesusta qatircur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tsepitanam Galilea probinsiacho jinantin marcacunapa purirnin, ellucayänan wayicunacho Jesus yachatsicorqan Diospa Munenincho canapaq alli willaquicunata. Tuquilaya qeshyacunawan jipaquicaqcunatam cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jinantin Siria probinsiachomi musyariyarqan qeshyaqcunata Jesus cachacätsishqanta. Tsemi peman apayämorqan tuquilaya qeshyacunawan jipacoqcunata, supëyoq nunacunata, ataquiwan jipaqcunata, imbaliducunata. Tse llapantam Jesus cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Allapa atscaq nunacunam Galileapita, Decapolispita, Jerusalenpita, Judeapita y Jordan mayu wac tsimpancunapita ewar Jesusta qatiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tsechonam allapa atscaq nunacunata riquecurnin, Jesus juc jircaman witsarcur täcurerqan. Tsemannam disipuluncuna witiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesusnam queno yachatsicur qallecorqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushicuyanqam shonquncunacho llaquishqa caqcuna, porqui pecunapaqmi Diospa mandaquinenqa quecan. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Cushicuyanqam llaquir waqacoqcuna, porqui pecunaqa shoqashqam cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Cushicuyanqam qollmi shonquyoqcuna, porqui pecunapam que patsaqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Cushicuyanqam mallaqepanoraq y yacunëpanoraq alli rurellata tïraqcuna, porqui munayanqannomi ruracanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Cushicuyanqam ancupäcoqcuna, porqui pecunapis ancupashqam cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Cushicuyanqam limpiu shonquyoqcuna; porqui pecunaqa Diosta ricayanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Cushicuyanqam amishtatsicoqcuna; tseno ruraqcunaqa Diospa wamrancunam cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Cushicuyanqam allicunata rurayanqanpita chiquir ushashqa caqcuna; porqui pecunapaqmi Diospa mandaquinin quecan. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Cushicuyë noqarecur ashashqa caqcuna, chiquishqa caqcuna y tuquilaya uliquicunawan contrequicuna cacurcuyashqa cayaptinpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsenomi chiquir qaticachäyarqan, y tuquita rurayarqan profetacunatapis. Tsemi allapa cushicuyë, porqui sieluchomi Teyta Dios allapa shumaq premiuta qoyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Qamcunaqa que patsacho imeca cachi cuentam nunacunapaq quecayanqui; peru sitsun cachi qamläcurenqa, ¿imanepanaraq yape mishquinta cutitsinman? Tseno carqa, tse cachi mananam imapaqpis sirwinnatsu. Tsemi nänimanna jitarintsic jarucuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Qamcunaqa que patsacho imeca actsi cuentam nunacunapaq cayanqui. Juc jirca puntancho marca manam pacarantsu, sinoqa mas alerim ricacun. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nï lamparinta sendircur, manam manca rurinmantsu churecuntsic; sinoqa raramanmi churantsic llapan wayicho caqcunata actsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tse lamparin actsicoq cuenta qamcunapis allicunata rurar cawacuyë. Tseno alli ruraq cayanqequita ricarmi, nunacuna sielucho quecaq Dios Yayantsicta alabecuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama noqapaq pensayëtsu Moises escribishqan leycunata y profetacuna yachatsicuyanqanta ushacätseq shamonqäta. Antis noqaqa shamorqö tse leycuna willaconqanta cumplinäpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cananmi rasonpa caqta nïcuyaq. Sielupis patsapis quecanqanyaqqa tse leycuna llapanmi cumplicanqa; manam ni imallapis mana cumplicashpaqa quedanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pipis ley nishqanta mana cäsoqtaqa y waquin nunacunatapis mana cäsuyänanpaq yachatseqcunataqa, Diosmi mandaquinincho mana presisaqpaq churanqa. Peru leycunata cumpleqtaqa y cumpliyänanpaq yachatseqtaqa Diosmi mandaquinincho allapa presisaqpaq churanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Quetapis musyayë: Qamcunapis Diospa mandaquinincho queta munarnenqa, fariseucunapitapis y ley yachatsicoqcunapitapis mas allicunatam rurayänequi.” ");
INSERT INTO qwhNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tsepitanam Jesus queno nerqan: “Qamcuna musyayanquim une awilucuna queno yachatsicuyanqanta: ‘Ama nuna mayiquicunata wanutsiyanquitsu, porqui wanutsicoq nunaqa condenadum canqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Peru noqanam niyaq nuna mayincunata chiqueqcunallapis jusgashqam canqa; y ‘Locu’ nir ashaqllatapis autoridacunam condenanqa; y nuna mayinta ‘Upa’ nir ashaqcunanäqa infiernupitam peligrucho quecan. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tsemi Diospa altarninman ofrendata aparqa, puntata yarpäcurcuyë meqan nuna mayiquillatapis piñatsiyashqequita. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Piñatsishqa carqa, altar nopancho tse ofrendequita jaqirïcur, tse wauqiquiman ewë amishtaq. Tsepitana cuti ofrendequi churaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Sitsun pipis demandashurniqui juesman apatsiyäshunqui, manaraq juespa puncunman char aregleta tïrayë. Porqui juesqa capas pasaratsiyäshunqui wardiacunaman, y pecunanam carselman llawiriyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rasontam niyaq: Llapan jaqa queniquita manaraq pagacorqa, manam tse carselpita yarquyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Qamcuna, musyayanquim une awiliquicuna queno yachatsicuyanqanta, ‘Majayoq quecar ama jucwan jucwan pununacuyanquitsu’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Peru noqanam niyaq: Pipis juc warmita riquecur munapäreq caqqa, jucwan punanacureqnonam carishqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Tsemi niyaq: Sitsun nawiqui jutsa rureman ishquitsishiniquita munanqa, mejor jorqurinquimanpis; porqui qampaqqa mas allim canqa tse caq partiquillapis infiernupita salbacurinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sitsun maquiqui jutsa rureman ishquitsishiniquita munanqa, mejor roqurinquimanpis; porqui qampaqqa mas allim canqa tse caq partiquillapis infiernupita salbacurinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Moises escribishqanchomi queno willacun: ‘Pipis warminpita raquicacurita munarqa, diborsio papelnin firmecur raquicacuritsun’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Peru noqanam niyaq: Manam pipis raquiqueta puedintsu warmin mana jucwan cacurcuptenqa. Mana tseno quecaptin raquicarqa, tse warmin juc ollquwan cacuriptinpis, qowanmi warminta jutsaman ishquiratsin. Jina pipis tse qowanpita raquicashqa warmiwan majäcorqa, jutsamanmi ishquirin.” ");
INSERT INTO qwhNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tsepitanam Jesus nerqan: “Qamcuna musyayanquim une awilucunata queno yachatsiyanqanta: ‘Teyta Diosrecur juramentupa imatapis änicorqa, tse änicuyanqequita cumpliyanqui’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Peru noqanam niyaq: Ama imata änicurpis juramentuta rurayanquitsu. Ama sielutapis testigacuyanquitsu; porqui sieloqa Diospa tronunmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ama testigacuyanquitsu que patsacho imapis caqcunata; porqui que patsacho imapis caqcunaqa, Diospa muneninchomi quecayan. Ni ama testigacuyanquitsu Jerusalen marcata; porqui Jerusalen marcaqa allapa puedeq Diospa marcanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni ama jurar quiquiquicunapa puedeq queniquicunaman marcäcur jurayanquitsu; porqui manam quiquiquicunallaqa puediyanquitsu jucllellatapis aqtsequicunata yulaqyätsita, ni yanayätsita. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Antis ‘aumi’ niyanquilla, y mana cumpliyänequi captenqa ‘manam’ niyanqui. Porqui jurarqa, diablu munashqantam rurecayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Qamcuna musyayanquim une awiliquicuna queno yachatsicuyashqanta: ‘Pipis maqarnin nuna mayinpa nawinta pashtariptenqa, pepatapis pashtarayäputsun; o nuna mayinpa quirunta shicwarapuptenqa, pepatapis shicwarayäputsun’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Peru noqanam niyaq: Ama tseno lisucunata contistayanquitsu, antis juc ladu qaqllequicunacho laqyecuyäshuptiquipis, jucnin ladu qaqllequicunatapis camapicunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sitsun jaqa canqequipita demandashurniqui, camsequita qochiyäshunqui, ponchiquitapis qotupecuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sitsun pipis qepinta ishque quilometruyaq apayänequipaq mandayäshunqui, ishque quilometruyaqpis apecayäpï. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Imatapis mañayäshonqequita qoycuyanqui. Y prestadu mañacuyäshuptiquipis, ama ‘manam’ niyëtsu; qoycuyë. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Jina qamcuna wiyayashqanquim queno yachatsicuyanqanta: ‘Nuna mayiquicunata cuyayanqui, y chiquiyashoqniquicunata chiquiyanqui’ nenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Peru noqanam niyaq: Chiquiyäshoqniquicunata cuyayanqui, y mana allita rurayashoqniquicunapaq Teyta Diosta mañacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tseno rurarmi, sielucho quecaq Dios Yayapa wamrancunana cayanqui. Porqui pemi intinta intitsimun alli nunapaq y mana alli nunapaqpis. Y tamyantapis tamyatsimun llapanpaqmi: alli ruraqcunapaqpis y llutancunata ruraqcunapaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porqui sitsun qamcuna cuyayanqui cuyayäshoqniquicunallata, ¿ima premiutaraq Diospita chasquiyanqui! ¡Tsenollaqa impuestuta cobraqcunallapis portacuyantaq! ");
INSERT INTO qwhNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sitsun Diosman marcäcoq wauqiquicunallata tsaripar saludayanqui, ¿ima allitataq rurariyanqui! ¡Asta Teyta Diosta mana cäsucoqcunallapis tsenollaqa portacuyantaq! ");
INSERT INTO qwhNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imanomi sielucho quecaq Dios Yayantsic llapanta allita ruran, tsenolla qamcunapis allita rurayë. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“¡Paqtataq yo nunacuna ricayäshunequillapaq allicunata rurayanquiman! Tseno rurayaptiqueqa, sielucho quecaq Dios Yayapis manam premiyiquicuna qoyäshunquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Wactsacunata yanaparqa, ama tse alli tucoq nunacunanoqa cayëtsu. Pecunaqa ellucayänan wayicunachopis, y callicunachopis nunacuna alabayänanta munarmi, trompetata tocaräcur yanapacuyan. Rasontam niyaq: Tsellanam pecunapa premiuncuna. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tsemi qamcunaqa wactsacunata yanapayanqequita ni pitapis willayänequitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Antis mana pipis musyashqanlla wactsacunata yanapecuyanqui. Tseno pacallapa yanapayanquequita ricashoqniqui Dios Yayam, qamcunatapis mas allipa yanapecuyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Diosta mañacur, ama alli tucoq nunacunanoqa mañacuyanquitsu. Pecunaqa gustayan ellucayänan wayicunacho, y plasa isquinacunacho sharcur, nunacuna ricayänanpaq mañaquitam. Rasontam niyaq: Tsellanam pecunapa premiuncuna. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Peru qamcunaqa Dios Yayaman mañacurnin, wayiquicunaman yecurir puncuta wichqarcur mañacuyanqui. Y pacallapa mañaconqequita wiyaq Dios Yayam premiquicuna qoyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Jina Diosman mañacorqa, ama mañacuyanquitsu Diosta mana cäsucoq nunacunanoqa. Pecunaqa mañacurnin, juc parlayashqanllatam cutïcuryan ushepa ushar parlacuyan. Tsenoqa rurayan ‘Atsca cuti parlaptïqa, masllam Dios wiyamanqa’ nirmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ama pecunanoqa rurayanquitsu. Porqui manaraq mañacuyaptiquim, Dios Yayaqa musyanna imata wanayanqequitapis. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tsemi qamcunaqa queno mañacuyänequi: Sielucho quecaq Dios Yayalläcuna, jutillequi allapa respetuwan alabashqa catsun. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Llapan nunacuna mandadiquicho catsun. ¡Sielucho caqcuna qam mandaconqequita rurayanqannolla, que patsachopis nunacuna rurayätsun! ");
INSERT INTO qwhNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Miquilläcuna cada junaq qoycalläyämë. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noqacuna mana alli rurayämaqnïcunata perdonayanqänollä, jutsalläcunapita perdonecalläyämë. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jutsa rureman diablu ishquitsiyämeta munaptin ama jaqiralläyämëtsu; antis yanapecalläyämë jutsaman mana ishquilläyänäpaq. ˻¡Mandacoq queniqui, puedeq queniqui y shumaq queniqui wiñepa wiñenin catsun!˼ Tseno catsun, nir, mañacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Sitsun mana allita rurayäshoqniquicunata perdonecuyanqui, sielucho quecaq Dios Yayapis qamcunata perdonecuyäshunquim. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Peru sitsun qamcunapis nuna mayiquicunata perdonayanquitsu, Dios Yayapis manam jutsequicunapita perdonayäshunquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ayunayanqequi junaq ama alli tucoq nunacunanoqa llaquir ushashqa quecayanquitsu. Pecunaqa tseno cayan nunacuna alabayänanta munarmi. Rasontam niyaq: Tsellanam pecunapa premiuncunaqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Peru qamcunaqa ayunacur peqequicunata y qaqllequicunata paqacur shumaq naqtsacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tseno rurayaptiqueqa, manam nunacuna musyayanqatsu ayunecayanqequita; y mana ricanqequi Dios Yayallam musyanqa pacallapa ayunecayanqequita. Tsenam premiyiquicuna qoyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ama que patsacho ricuyeta tirar, imecata equecatapis elluyëtsu. Que patsacho caqtaqa imecatapis puyum ushan, ismunmi y suwapis yecurir apacunmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tsepa rantenqa yarpacachäyë Diospa caqcunata sielucho imequequipis cayäpushunequipaq. Tsechoqa manam ismuntsu ni puyupis cantsu; ni manam suwapis cantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porqui mechomi fortunequi canqa, tsellamanmi shonqiquipis yarparäquicanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nawiquicunam imeca chiuchino qamcunapaq. Tsemi nawiquicuna alli captenqa, actsichono cayanqui; ");
INSERT INTO qwhNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Peru nawintsic mana alli captenqa, paqaschonomi cayanqui. Y sitsun qamcunacho quecaq actsi paqasman ticranqa, ¡imalaya feyu tse paqas! ");
INSERT INTO qwhNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Manam pipis ishcaq patrontaqa sirwinmantsu. Tseno carqa, jucnin patronta cuyarninmi, jucnintaqa mana caqpaq churanqa; jucninta sirwirninmi, jucnintaqa mana cäsonqatsu. Tsemi Diosta cuyecarqa, ama riquesacunata cuyashuntsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tsemi qamcunata niyaq: Ama yarpacachäyëtsu, ‘¿Imataraq micushaq? ¿Imataraq upushaq? ¿Imataraq yacacushaq?’ nishpa. Porqui miquipitaqa caweniquicunam mas balin, y ropapitaqa qamcunam mas baleq cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Masqui cuentata qocuyë: Pishqucuna manam murucuyantsu, ni miquicunata ellupäcuyantsu, ni trojancunaman wardapäcuyantsu. Peru tseno quecaptinpis, sielucho Dios Yayam pacha juntata wätan, y pishqucunapitaqa qamcunam mas baleq cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Meqequicunataq tse yarpacachëniquicunawan juc junaqlla mas cawarcuyanquiman! ");
INSERT INTO qwhNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Imanirtaq jina ropacunallapaq yarpacachäcuyanqui! Masqui ricayë jircacunacho wetacuna imano winaqta. Pecuna manam uryayantsu ni putscayantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Peru tseno quecaptinpis, wetacunapa colorninwanqa manam puedeq rey Salomonpa chaniyoq ropanpis iwalarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Si ware waratin ninacho cayacar ushacäreqlla qoracunata Teyta Diosnintsic tseno shumaq bistitsin, qamcunatanäqa masran bistitsiyäshunqui. ¡Claru parlaquichoqa marcäquiniquicunam pishin! ");
INSERT INTO qwhNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tsemi ama yarpacachar llaquinashqa puriyanquitsu, ‘¿Imataraq micushun? ¿Imataraq upushun? ¿Imataraq yacacushun?’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tse cosascunapaqqa yarpacachäyan Diosta mana cäsucoq nunacunallam. Peru qamcunapa imequicunapis pishenqantaqa sielucho quecaq Dios Yayam musyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Peru qamcunaqa Diospa mandaquinincho cawaquillatana, y pe munashqanno allicunata rurellatana tirayë. Tseno cawacuyaptiqueqa, manam janapita, ni pachapita jipayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsemi ama warepaq caqtaqa yarpacachäyëtsu. Porqui warepis yarpacachecunaqa canqam, y cada junaqmi imallapaqpis yarpacachëqa carëcan. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ama nuna mayiquicunata jusgayëtsu, qamcunapis mana jusgashqa cayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porqui imanollam waquincunata condenayanqui, tsenollam condenashqa cayanqui; y imanollam qamcunapis nuna mayiquicunata tratayanqui, tsenollam qamcunatapis Dios tratayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Qamcunaqa nuna mayiquicunapa nawincho saqwata ricarëcaq cuentallam cayanqui; peru ¡manam cuentata qocuyanquitsu quiquiquicunapa nawiquicunacho troncu quecanqantaqa! ");
INSERT INTO qwhNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tseno quecaptin ¿imanopam nuna mayiquita ‘Nawiquicho saqwata jorqaramushaq’ ninquiman, quiquiquipa nawiquicho troncu quecaptin! ");
INSERT INTO qwhNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Alli tucoqcuna, puntataraq nawiquipita tse troncuta jorquyë! Tseran alli ricayanqui nuna mayiquicunapa nawincunacho saqwata jorqayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Diospa caqcunata allquta qoycoq cuenta ama cayanquitsu, ni allapa chaniyoq alajata cuchicunaman jitecapoq cuenta ama cayanquitsu. Tseno rurayaptiqueqa, contrequicuna sharirmi, baleq caqta despresyar mana caqpaq churariyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“¡Imatapis mañacuyaptiqueqa, Dios qoyäshunquim! ¡Asherqa, tariyanquim; puncuta tsactacuyaptiquipis, quichapäyäshunquim! ");
INSERT INTO qwhNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porqui mañacoq caqqa chasquinmi; asheq caqqa tarinmi; puncuta tacacoq caqtaqa quichapäyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Acasu meqequipis tsuriquicuna tantata mañayäshuptiqui, rumincu qoyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jina ¿acasu pescaduta mañayäshuptiqui, culebrancu qoycuyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Si qamcuna mana alli ruraq quecarpis tsuriquicunata allicunata qoyanqui, sielucho quecaq Dios Yayanäqa mas alli carmi, mas allicunata qoyäshunqui mañacuyaptiqueqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Imanomi munayanqui qamcunapaq nuna mayiquicuna allita rurayänanta, tsenolla qamcunapis pecunapaq rurayë. Tseno rurayänequipaqmi, Moises y profetacuna escribiyashqanchopis yachatsicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“¡Imeca quichqui puncupa yecoqno cayë! Porqui imeca jatun puncupa yecurir, anchu nänipa ewaqnomi infiernuman atscaq euquicayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Imeca quichqui puncupa yecurir, llanulla nänipa ewecaqnomi wiñe cawaquita tarintsic, y wallcaqllam tse nänipaqa ewayanpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cuidacuyë ulicurcur ‘Profetam cä’ nir, yachatsicoqcunapita. Pecunam manshu üshano qamcunaman shayämun, peru rurillantaqa imeca mallaqashqa pumanomi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imeca frutata acraqno tse nunacunata alcabayanqui. Porqui manam casha montipitatsu ubasta pallantsic; ni cardon cashacunapitatsu igusta pallantsic. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Alli caq monteqa alli frutallatam wayun; peru mana alli caq monteqa mana alli frutatam wayun. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Alli monteqa manam mana alli frutata wayunmantsu; ni mana alli monti alli frutata wayunmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mana alli wayoq monticunataqa muturirmi, ninacho cayecuntsic. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tsemi frutata acraqno pecuna imano cayanqanta musyariyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manam llapan ‘Teytallä, Teytallä’ nimaqnïtsu gloriaman yecuyanqa; sinoqa sielucho quecaq Dios Yayä munashqanno cawacoqcunallam. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juisiu junaqmi atscaq niyämanqa: ‘Teyta, Teyta, noqacunam jutiquicho yachatsicushqa cayä; jutiquichomi nunacunapita supëcunata qarquyarqä; y jutiquichomi atsca milagrucunatapis rurayarqä’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tseno niyämaptinnam nishaq: ‘¡Qamcunataqa manam reqiyaqtsu! ¡Llapequi mana alli ruraqcuna, nopapita witicuyë!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pipis que yachatsiconqäta wiyacur, cäsucoqcunaqa, imeca precabidu nuna wayinta shäritsinanpaq qaqa janancho simientuta patsätseqnomi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tseno qaqa janancho shäritsishqa wayitaqa manam melaya tamyapis ni lloqllapis ni bientupis juchurenqatsu alli firmi patsashqa captin. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Peru yachatsicushqäcunata wiyar, mana cäsucoq nunaqa imeca juc upa nuna aqusha jananllacho wayita shäritseqnomi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tseno aqusha jananllacho shäritsishqa wayitaqa tamyapis, lloqllapis, bientupis shamurmi, pasepa juchur ushacäratsenqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus tseno yachatsicur ushariptinnam, llapan nunacuna allapa espantacur mantsacäcuyarqan tse yachatsiquininpita. ");
INSERT INTO qwhNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porqui puedeq queninwanmi tsecunata yachatsicorqan y manam ley yachatsicoqcunanollatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tsepitanam jircapita Jesus urämuptin, atscaq nunacuna peta qatircur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eucurëcaptinnam, leprawan qeshyaquicaq nuna Jesuspa puntanman qonquriquicur, queno nerqan: —Tëte, munarnenqa, ¡cachaquecatsillämë! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsenam Jesus nunata yatecur queno nerqan: —Munämi, cachacänequita —nir. Tse öram tse lepra qeshyapita cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesusnam nerqan: —Ama ni pitapis willacunquitsu cachacätsenqaqta. Peru si, ewë saserdoti ricashunequipaq, Moises mandacushqanno Diospaq ofrendan aparcur cachacashqequita musyayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tsepitanam Jesus ewarqan Capernaum marcaman. Tsemannam Romanu soldaducunapa capitannin checur, Jesusta rogarnin, ");
INSERT INTO qwhNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","queno nerqan: —Tëte, wayïchomi juc watenï lastima qeshyecan. Chaquinta ni maquinta manam cuyutsita puedintsu, y allapam nanatsicun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tseno niptinnam, Jesus nerqan: —Ewashaqmi, y cachacätsishaqmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitannam nerqan: —Tëte, manam meresïtsu noqalläpa wayilläman ewar afanacullanequita. Tsechi quellapita mandecullanqui wätenï cachacärinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porqui noqapis mandamaqnïpa poderninchomi cä. Y noqapa podernïchomi soldaducunapis cayan. Jucninta ‘Ewë’ niptïqa, ewanmi; jucninta ‘Shamï’ niptïpis, shamunmi; sirwimaqnïta ‘Queta rurë’ niptïpis, ruranmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitan nenqanta wiyecurnam, Jesus espantacur, qatiraqnincunata queno nerqan: —Rasontam niyaq: Diosman que nuna marcäcoqtanoqa manam tarishqatsu cä que israel nunacunacho. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niyaqmi: Inti yarqamunanpitam y inti jeqanan caru nasioncunapitam, atscaq nunacuna juntacäyanqa Diospa mandaquinincho Abrahamwan, Isaacwan y Jacobwan juntu micuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Peru tsecho cayänanpaq caq israel nunacunanam jaq paqasman qarqushqa cayanqa. Tsechomi allapa llaquir waqayanqa quiruncunatapis ruchuchutsirraq. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsepitanam capitanta Jesus nerqan: —Wayiquiman cutiquï. Y marcäcur pensanqequinomi canqa. Tse öram capitanpa wätenin cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsepitanam Pedrupa wayinman Jesus ewarqan. Tsechomi Pedrupa suegran fiebriwan qeshyar cämarëcarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsenam Jesusqa qeshyaqpa maquinta yatecorqan, y tse öram fiebripita cachacärerqan. Tsenam sharcur pecunata sirwerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Patsa paqasyärëcaptinnam, Jesusman apayämorqan supëyoqcunata. Tsenam Jesusqa juc piñapëllacho supëcunata nunacunapita qarqorqan, y llapan qeshyaquicaqcunatam cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tseno ruraptinmi, cumplicärerqan profeta Isaias queno escribishqan: “Pe quiquinmi rantintsic qeshyacunata y nanatsiquicunata jipashqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Atscaq nunacuna Jesusman quichquinacur juntaquicuyaptinnam, disipuluncunata nerqan lamar wac tsimpanman eucuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tseno niptinnam, ley yachatsicoq nuna witïcur, queno nerqan: —Mayestru, meta tseta ewaptiquipis, noqaqa qatishqequim. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesusnam nerqan: —Atoqcunapa machenin canmi. Pishqucunapapis qeshun canmi. Peru Diospita Shamushqa Nunapaqa manam ni iman cantsu jamarinanllapaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsenam jucnin caq disipulun queno nerqan: —Teyta Jesus, qamwan eucunäpaq papänïtaraq pampamushaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tseno niptinnam, Jesus queno nerqan: —Qatirämeta munarqa jinallacho shamï. Wanushqano caqcuna wanushqacunataqa pampacuyätsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsepitanam Jesus lloqarerqan lanchaman disipuluncunawan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lamarpa eucurëcayaptinnam, llutepa bientur qallaquicorqan. Lamarnam laqcheqsarcuryan lanchatapis pasepa shucurerqan; peru Jesusqa punicarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsenam disipuluncunaqa Jesusman corir riyatsiyarqan, queno nishpa: —¡Teyta, Teyta, salbecalläyällamë! ¡Yacumannam tullpucäquicantsic! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesusnam nerqan: —¿Imanirtaq allapa mantsacäyanqui, Diosman mana marcäcoq nunacuna! Tseno nirirnam, sharcur bientuta mandarqan mana bientunanpaq yacuta mana laqcheqsänanpaq. Y llapanmi shumaq tranquilu ticrarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tseta riquecurnam, disipuluncunaqa allapa espantacur queno ninacuyarqan: —¡Queqa imano nunataq tselaya bientupis yacupis mandadunta cäsuyänanpaq! ");
INSERT INTO qwhNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lamar wac tsimpan Gadara nishqan estansiaman Jesus chäriptinnam, pantiuncunacho täcoq ishcaq nunacuna shayämorqan peta taripaq. Tse nunacunaqa shonquncunacho supë captinmi, allapa mantsepaq locuyashqa cayarqan. Tsemi pipis mana puriyaqtsu tse nänipa. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tse supëyoq nunacunanam qayaripa queno niyarqan: —Diospa tsurin Jesus, ¿Imatataq noqacunawan munanqui! ¿Manaraq tiempuchocu castigayämaqnï shamorqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tsepita mas washaninllachomi atsca cuchicunata mitsiquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsemi Jesusta tse nunacunacho supëcuna rogacur queno niyarqan: —¡Que nunacunapita qarqarayämarqa, cachecalläyämë taqe cuchicunallaman yecuquiculläyänäpaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tseno niyaptinnam, Jesus nerqan: —¡Eucuyë! —nir. Supëcunanam, nunacunapeq yarqurir, cuchicunaman yecuquicuyarqan. Tsenam coripa ewar cuchicunaqa jircapita qochaman jeqacurcuyarqan, y shenqacar, wanuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tseta riquecurnam, cuchi mitseqcunaqa coripa ewacuyarqan marcancunaman. Chëcurnam, llapan imapis pasaconqanta y tse supëyoq nunacunata Jesus cachacätsishqanta willacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsenam llapan nunacuna ewacuyarqan Jesus quecanqanman. Chärirnam Jesusta rogayarqan marcancunapita eucunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsepitanam lanchaman lloqarcur disipuluncunawan eucuyarqan lamarpa wac tsimpanman, y chäriyarqan Jesuspa marcanman. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsemannam apayarqan imbalidu nunata, quirmapa wanturishqa. Tsenam Jesusqa peman allapa marcäcuyashqanta musyarirnin, qeshyaqta nerqan: —Callpata tsarï, iju. Jutsequicunapitam perdonecoq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tseno nenqanta wiyecurnam, ley yachatsicoqcunapita waquin caqcuna shonquncunallacho yarpacachäyarqan “Que nunaqa Diospitam burlacun” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Peru Jesusqa tseno yarpacachäyanqanta musyarirmi, pecunata queno taporqan: —¿Imanirtaq qamcuna shonqiquicunacho llutanta pensayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Meqantaq mas alli ninäpaq canman: ‘Jutsequicunapita perdonashqanam canqui’ ninäcu, o ‘¡Sharquï! ¡Canan purï!’ ninäcu! ");
INSERT INTO qwhNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cananmi musyatsiyashqequi, Diospita Shamushqa Nuna, puedeq car que patsacho nunacunapa jutsancunata perdoneta puedenqanta. Tseno nirirnam, imbalidu nunatana nerqan: —¡Sharquï! Quirmequita aparcur, wayiquita euquï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsenam imbalidoqa tse öra sharcurnin, wayinman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tseta riquecurmi, nunacuna allapa espantacur Teyta Diosta alabayarqan, puedeq queninta pëcho ricayanqanpita. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsepita eucurninnam, Jesus ricarerqan Mateota Romapaq impuestucunata cobracuyänan wayicho cobracur tëcaqta. Petam Jesus nerqan: —¡Acu eucushun! —nir. Mateonam sharcur Jesuswan eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsepitanam Mateopa wayincho Jesus disipuluncunawan miquicayaptin Romapaq impuestuta cobracoqcuna y jutsasapacuna atscaq chärir Jesuswan juntu miquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tseta riquecurnam, fariseucuna Jesuspa disipuluncunata queno niyarqan: —¿Imanirtaq mayestriquicuna impuestu cobracoqcunawan y jutsasapacunawan juntacur micuyan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tseta wiyecurnam, Jesus nerqan: —Qeshyaqcunallam medicutaqa nesitayan; sanu caqcunaqa manam. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","¡Ëwar yachacuyë! ¿Ima ninantataq Diospa palabrancho escribirëcan queno nir, ‘Manam munätsu qareniquicunata; sinoqa munä ancupäcoq cayänequitam’ nir? Tsemi noqaqa que patsaman shamushqa cä alli ruraq nunacunamantsu, sinoqa jutsasapacunamanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tsepitanam bautisacoq Juanpa disipuluncuna Jesusman witïcur tapuyarqan queno: —Noqacunaqa y fariseucunaqa cadallam ayunayä. ¿Imanirtaq disipuliquicunaqa ayunayantsu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesusnam iwalatsiquipa queno nerqan: —Acasu casamientuman combidashqacuna nobiuwan juntu quecar, ¿ayunayancu! Peru chämonqanam nobiuta apacuyänan junaq. Tsenam si, ayunayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Manam pipis macwa ropata remendanmantsu mushoq telawan, porqui tse mushoq telaqa qenticarmi macwa ropata mas rachirenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tsenollam tseraq rurashqa binuta macwa qara bolsaman winantsictsu; porqui tseno rurashqaqa, binu poqurmi bolsata pashtaratsimunman, y binupis bolsapis ushacärinmanmi. Tsemi tseraq rurashqa binutaqa mushoq qara bolsaman winacuntsic. Tsenopaqa binupis y bolsapis manam ushacanqanatsu.” ");
INSERT INTO qwhNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus tseno willapäcur quecaptinnam, ellucayänan wayicho mandacoq Jairu chärir, Jesuspa nopanman qonquriquicur queno nerqan: —¡Warmi wamrallämi wanuquicushqa! ¡Acu, eweculläshun, yatecuptiqui cawarirallämunanpaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tseno niptinnam, Jesusqa sharcur disipuluncunawan Jairupa wayinman jeqariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tseno ewarëcayaptinnam, chunca ishque (12) watana yawar ewewan qeshyacoq warmi Jesuspa qepanman witïcur, mantunpa cuchunta yatecaporqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pëqa pensarqan: “Mantunta yatecurllam que qeshyäpita cachacärishaq” nirmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesusnam tumecur tse warmita ricarëcur, queno nerqan: —Warmi, balorta tsarï, noqaman marcäcurmi cachacärerqonqui. Tse öram tse warmipa yawar ewenin shupirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mandacoq Jairupa wayinman chärirnam, Jesus tarirerqan nunacuna qaparipa qayaripa waqar caquicayaqta, y flautacunallana waqaquicaqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tsenam pecunata nerqan: —Quepita yarquyë. Wamraqa punicanllam. Manam wanushqatsu —nir. Tseno niptinnam, nunacuna burlapaq churar asipäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nunacuna yarqarayämuptinnam, wamra sutarëcanqanman yecurerqan. Wamrata maquipita sutarcuptinnam, tse öra cawarir sharcaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tse llapan pasacushqancunatam tse marcacunacho musyariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsepita Jesus yarqur eucurëcaptinnam, ishcaq wiscucuna Jesuspa qepanta queno qayarir ewayarqan: —¡Rey Davidpa castan Jesus, ancupëcalläyämëri! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Juc wayiman Jesus yecuriptinnam, tse wiscucuna witiyarqan. Jesusnam pecunata taporqan queno: —¿Qamcuna rasonpacu marcäcuyanqui, cachacätsiyänaqpaq caqta? —nir. Pecunanam yasquiyarqan: —Aumi, Teyta —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsenam Jesusqa nawincunata yatecur, nerqan: —Qamcuna marcäcur mañacuyashqequino catsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tse öram pecuna ricachacuriyarqan; y Jesusnam notificar queno nerqan: —¡Ama pitapis willacuyanquitsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Peru, yarqurir öram willacur qallaquicuyarqan Jesus cachacätsiyanqanta, tse jinantin marcacunacho. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wiscucuna yarqurëcayaptinam, waquin nunacuna Jesusman apayämorqan supëyoq car muduyashqa nunata. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Supëta tse mudupita qarquriptinnam tse nuna parlar qallecorqan. Nunacunanam espantacur queno niyarqan: —¡Queno ruraqtaqa manam imepis ricashqatsu cantsic que Israel nasionnintsiccho! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Peru fariseucunanam queno niyarqan: —Diablucunapa mandacoqnin poderninwanmi nunacunapita supëcunata qarqun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tsepitanam Jesusqa marcan, marcan estansiacunapa purir, cada marcapa ellucayänan wayicunacho yachatsicorqan Diospa mandaquinincho cayänapaq alli willaquicunata. Y tuquilaya qeshyawan nanatsiquicaqcunatam cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tsecho atscaq nunacuna quecayaqta ricarnam, pecunata ancuparqan, porqui mitseqninnnaq üsha cuentam pantacashqa puriquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsenam disipuluncunata queno nerqan: —Cosecha poqicaqnomi nunacuna ellipaq quecayan. Tseno captinpis, wallcallam elloqcuna cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsemi Teyta Diosman mañacuyë elloqcuna mas atscaq cayänanpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tsepitanam Jesus chunca ishcaq (12) disipuluncunata qayarir, poderninta qorqan nunacunapita supëcunata qarquyänanpaq y tuquilaya qeshyapita y nanatsiquicunapita cachacätsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chunca ishcaq (12) apostolnincunapa jutincunam carqan: Simon (pepa jucnin jutinmi carqan Pedru), Simonpa wauqin Andres, Zebedeupa tsurincuna Santiagu y Juan. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipi, Bartolome, Tomas, impuestu cobracoq Mateo, Tadeo, Alfeupa tsurin Santiagu, ");
INSERT INTO qwhNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Cananista grupupita caq” Simon y Jesusta ranticoq Judas Iscariotim. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Que chunca ishque (12) apostolnincunatam Jesus cacharqan queno nishpa willapecurnin: “Samaria marcamanqa ni mana israel nunacunapa marcancunamanqa ama ewayanquitsu; ");
INSERT INTO qwhNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","peru Israel marcacho oqracashqa üsha cuenta caquicaqcunaman si, ewayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y ewarnin queno yachatsicuyanqui: ‘Diosnintsic mandacoq cananpaq tiempu chäramunnam’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Qeshyacoqcunata cachacätsiyanqui; wanushqacunatapis cawaritsiyanqui; lepra qeshyawan qeshyaqcunata cachacätsiyanqui; supëyoq nunacunapita supëcunata qarquyanqui. Tsecunata rurayänequipaq Diospa poderninta debaldillam chasquiyarqonqui, y paqtam qeshyaqcunata cachacäratsir cobrecayanquiman. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ama ewarnin qorita ni qelleta apayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ama mircapatapis, ni trocacuyänequipaq ropatapis, llanqitapis ni tucrutapis apayanquitsu; porqui uryaqtaqa combieninmi pachan qarayänan. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Me marcaman o estansiaman charninpis, juc alli cawacoq nunata ashiyanqui. Tse wayincho posadacur quedacuyanqui, tse marcapita eucuyanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tse wayiman yecur saludacuriyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sitsun tse wayicho yachaqcuna cushi cushi chasquiyäshunqui, Diospa bendisionninta mañacuyanqui; peru ajayecar chasquiyäshuptiqueqa, ama bendisionta mañacuyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y wayincunaman mana chasquiyäshuptiqueqa, y yachatsicuyanqequicunata mana wiyayäshuptiqueqa, tse wayipita y tse marcapita yarqur eucuyanqui chaquiquicunacho polbutapis tapsicurir. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rasontam niyaq: Sodoma y Gomorra marcacunacho mana alli cawacoq nunacuna castigashqa cayanqanpitapis, juisiu junaqmi tse marca mas feyupa castigashqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Qamcunatam cachayaq imeca achcas atoqcunapa chopinpa ewaq cuentatano. Tsemi culebrano mäcoq, mäcoq cayänequi, peru palumanopis manshulla. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tsemi qamcuna mäcoq mäcoq quecayänequi; porqui autoridacunamanmi apayäshunqui. Ellucayänan wayicunachomi astayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Noqarecurmi autoridacunaman y reycunaman apayäshurniqui, tuquita tapupäyäshunqui. Tse öra tse autoridacunacho y mana israel caqcunacho noqapaq willapäcur parlacuriyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Peru autoridacunaman apayäshuptiqui, ama yarpacachäyanquitsu, ‘¿Imataraq nishaq? ¿Imanoraq parlacurishaq?’ nirnin; porqui parlayänequi öram Dios yanapayäshunqui imata niyänequipaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Manam qamcunapa yarpeniquicunapitatsu parlayanqui, sinoqa Dios Yayapa Santu Espiritunmi qamcunata parlatsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tsenollam nunacuna wauqincunata chiquirnin, entregayanqa autoridacunaman wanutsiyänanpaq. Papänincunanam jina tsurincunata iwalitu rurayanqa. Y tsurincunapis papänincunapa mamänincunapa contran sharcurmi, entregayanqa wanuratsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Noqarecurmi llapan nunacuna chiquiyäshunqui. Tseno captinpis, wanonqanyaq noqacho tsaracoqmi salbaconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcacho wanutsiyäshiniquita munayaptenqa, juc ladu marcaman qeshpir ewacuyanqui. Rasontam niyaq, llapan Israel nasionta purir, manaraq ushayaptiquim, Diospita Shamushqa Nunaqa que patsaman yape cutimonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Manam ni meqan disipulupis mayestrunpita mas presisaqtsu, ni meqan sirwipacoqpis patronninpita mas presisaqqa canmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Antis juc disipuloqa mayestrunnollam canman, y juc sirwipacoqqa patronninnollam canman. Si papä cuenta quecaptï noqatapis ‘Beelzebu’ niyaman, qamcunatanäqa wamrä cuentalla quecayaptiqui, ¿imaraq niyäshunqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Peru tserecorqa ama mantsayëtsu nunacuna imatapis rurayäshunequipita. Porqui imapis pacallapa rurayanqan manam pacarëcarqa quedanqatsu; sinoqa llapanmi musyacashqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Paqaspa parlapäyanqaqtam junaqpana willacuyanqui. Rinriquicunallacho willayanqaqtam, wayicunapa jananman lloqarcur qayaripa willapäcuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama wanutsicoqcunata mantsayëtsu. Porqui wanuratsiyäshurniqui, manam almequicunataqa imaneta puediyanqatsu. Antis mantsayëqa Diosta. Pëqa almecuerpum infiernucho ushacätsiyäshiniquita puedin. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Masqui quetapis cäyiyë: Pishqoqa ishqueran juc sentabupis cuestan. Tseno baratulla quecaptinpis, Dios Yaya mana permitiptenqa manam jucllellapis wanuyanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y qamcunapatanäqa llapan aqtsequicunatapis jucllellapayan yupashqam quecatsin. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tseno quecaptenqa, ama imatapis mantsacuyëtsu. Porqui atsca pishqocunapitapis qamcunaqa masmi baliyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pipis nunacunapa nopancho noqapa fabornï willacuptenqa, noqapis pepa faborninmi willacushaq sielucho quecaq Yayäpa nopancho. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Peru nunacunapa nopancho negamaqtaqa, noqapis sielucho quecaq Dios Yayäpa nopancho negashaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ama pensayëtsu que patsaman alli cawaquillata apamonqäta. Manam tsenotsu; sinoqa noqarecurmi nunacuna chiquinaquillacho cacuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Noqaman marcäcuyanqanrecurmi papäninpa contran tsurin canqa, warmi wawanmi mamanpa contran y llumtsininnam suegranpa contran canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tseno chiquishqam cayanqui castequicunapita qallecur. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Pipis tëtanta mamanta noqapita mas cuyaq caqqa, manam noqapatsu; pipis wamrancunata noqapita mas cuyaq caqqa, manam noqapatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Noqarecorqa, wanunanpaq crus apaqnomi jiparninpis, qatirämänan. Mana tseno caqqa, manam noqapatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pipis quiquinllapeq salbaquita munaq caqqa manam salbadutsu canqa; peru pipis noqarecur asta wanonqanyaq tsaracoqqa salbaconqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Qamcunata chasquiyäshurniqueqa, noqatapis chasquiyämanmi; noqata pipis chasquimarqa, cachamaqnïtam chasquican. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Profetacunata chasqueqcunaqa gloriaman charmi, tse profetacuna premiuta chasquiyanqantanolla premiuta chasquiyanqa. Y alli ruraqcunata chasqueqcunapis gloriaman charmi, tse alli ruraq nuna premiuta chasquenqantanolla jina premiuta chasquiyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sitsun mana presisaqlla quecayaptiquipis, qatirämaqnïcuna cayanqequirecur pillapis juc tasa yacuta qarecuyäshunqui; rasontam niyaq: tse nunatam Dios paganqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tseno chunca ishque (12) disipuluncunata cösa notificarirnam, Jesus eucorqan Galilea probinsiacho quecaq marcacunapa alli willaquininta willapäcunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tsepinmi bautisacoq Juan carselcho llawirëcarqan. Tse carselcho quecarmi Jesucristu rurashqancunata musyarerqan. Tsemi cacharqan waquin disipuluncunata, ");
INSERT INTO qwhNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesusta queno tapuyänanpaq: —¿Qamcush shamunanpaq caq Dios Acrashqan callanqui, o juctacush shuyalläyäshaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tseno tapuyaptinnam, Jesusqa queno nerqan: —Ewë, Juanman cutir willayanqui llapan wiyecayanqequita y riquecayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jina willayanqui: wiscucuna ricayanqanta, cojucuna puriyanqanta, leprawan qeshyaqcuna cachacäyanqanta, sorducuna wiyayanqanta, wanushqacuna cawariyanqanta y wactsacuna Diospa alli willaquininta wiyaquicayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Y pi mepis cushicutsun mana ajayashpa noqaman marcäcoqcuna —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bautisacoq Juanpa disipuluncuna cuticuyaptinnam, tsecho ellucashqa nunacunata Jesus queno nir willaparqan Juanpaq: —Tsunyaqcho quecaptin, ¿Imaqtaq Juanman caruta ewayarqequi! ¿Bientuwan shoqush cuyoqllata ricaqcu! ");
INSERT INTO qwhNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¡Niyämë! ¿Imaqtaq ewayarqequi, alli shumaq ropan yacashqa nuna ricaraqcu! Musyayanqequinopis shumaq ropan yacashqa nunacunaqa reypa wayincunallachomi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¡Parlacuyëri! ¿Imaqtaq ewayarqequi! ¿Diospa profetanchi nircu? ¡Aumi! Pëqa tse profetacunapitapis mas presisaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanpaqmi Diospa palabran escribirëcan queno: ‘Puntequitam willacoqnïta cachashaq, nänita alistaq cuenta nunacunata willapänanpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rasontam niyaq: bautisacoq Juanno presisaq nunaqa manam imepis cashqaraqtsu. Tseno captinpis, Diospa mandaquinincho quecaq qollmi shonqucunam mas presisaqqa cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Bautisacoq Juan willapäcur qallanqanpita asta canancamayaqmi ima eca captinpis Diospa mandaquinin nunacunacho patsaquecan; y tse mandaduncho queta tïraqcunallam yecuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Profetacuna escribiyashqancunam y Moises escribishqancunam Diospaq musyatsimarqantsic asta Juan chäramonqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Creyiptiqui mana creyiptiquipis, Juanqa profeta Elias cuentam shamushqana. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Tsemi rinriyoq carqa, wiyacur cäsucuyë!” ");
INSERT INTO qwhNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Canan tiempu nunacunata imawanraq iwalaratsiman? Pecunaqa imeca plasacunacho wamracuna pucllacur, wamra mayincunawan qayaripa queno ninacoqnomi cayan: ");
INSERT INTO qwhNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Flautawan shumaq bersuta tocayaptïpis, manam qatswayanquitsu; ni llaquiquipaqta qotsuyaptïpis, manam waqayanquitsu’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Y tse cuentam bautisacoq Juan shamur, mana binuta upyaptin, y mana micuptin, niyanqui ‘Pëqa supëyoqmi’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y Diospita Shamushqa Nuna micoq upoq captinnam, qamcuna niyanqui: ‘Queqa allapa micoqmi y upyaqmi, impuestu cobraqcunapa y jutsasapacunapa amigunmi’ nishpa, cäsuyanquitsu. Peru Diospa acrashqancunaqa ricatsicuyan alli rurenincunawanmi Diospa yacheninta.” ");
INSERT INTO qwhNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tsepitanam Jesusqa piñapäcacharcorqan tse atsca milagrucunata ruranqan marcacunacho täraq nunacunata; porqui milagrucunata riquecarpis, jutsancunata manam jaqiyarqantsu. Tsemi queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Allau, Corasin marcacho y Betsaida marcacho täraq nunacuna! Sitsun marquequicunachono Tiro y Sidon marcacunacho milagrucunata ruräman carqan; menam tse nunacuna yana jacuncunata yacacurcur, uchpawan shüpacur, jutsancunata jaqirïcur Diosman cuticuyanman carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tsemi niyaq: juisiu junaqcho Tiro y Sidon marca nunacuna castigashqa cayanqanpitapis, mas feyupa castigashqa cayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y qamcuna, Capernaum marcacho täraq nunacuna, ‘Sielumanmi ewayäshaq’ ¿niyanquicu? ¡Manam, infiernuman qarpushqam cayanqui! Porqui sitsun marquequicunachono Sodoma marcacho milagrucunata rurayanman carqan, tse marca canancamayaqmi quecanman carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Peru niyaqmi: Juisiu junaqmi Sodoma marca nunacuna castigashqa cayanqanpitapis mas feyupa castigashqa cayanqui.” ");
INSERT INTO qwhNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tseno willapäcurëcarnam, Diosta alabarninna Jesus queno nerqan: “Sieluchopis, patsachopis mandacoq Dios, ¡qamtam alabecoq! Porqui yachaq tucoqcunataqa y musyaq tucoqcunataqa manam boluntaniquita cäyiratserqonquitsu; peru qollmi shonqu nunacunataqa cäyiratserqonquim. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aumi, Dios Yaya, tseno canantam munarqonqui” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nïcurnam, nunacunatana queno nerqan: “Dios Yayämi llapan imecacunachopis mandacunäpaq podernï qomashqa. Dios Yayallam noqata reqiman, y noqallam Dios Yayata reqï y noqa reqitsiptïllam waquincunapis Dios Yayata reqiyanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tsepitanam nerqan: “Llapequipis utishqa y llaquishqa carnenqa, noqaman shayämï. Shayämuptiqueqa, noqam jamaratsiyashqequi. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Imeca yugucho noqalla arsuta apaq cuentam qamcunawan purishun. Noqam qollmi shonqu car y umildi car, llapan nacaquiniquicunapita jamaratsiyashqequi. ");
INSERT INTO qwhNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noqapa yugoqa manam lasantsu. Yanapayäpteq ancashllam canqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tsepitanam jamacuyänan junaqcho Jesus disipuluncunawan trigu murushqa cuchunpa ewarëcayarqan. Disipulucunanam mallaqarnin, espigata quipchurir uchuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tseno rurayanqanta riquecurnam, fariseucuna Jesusta queno niyarqan: —¡Riquë disipuliquicunata! ¡Jamaqui junaq leynintsicpa contran rurayan! ");
INSERT INTO qwhNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tseno niyaptinnam, Jesusqa nerqan: —¿Qamcuna manacu Diospa palabranta leyishqa cayanqui, rey David yanaqincunawan mallaqar, rurayanqanta? ");
INSERT INTO qwhNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pemi Dios adorana wayiman yecurirnin, Diospaq churashqa tantata yanaqincunawan micucurcuyarqan, saserdoticunalla micuyänan quecaptinpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jina ¿manacu Moises escribishqan leyta leyiyarqonqui saserdoticuna jamaqui junaqchopis templucho uryayanqanta? ¿Tseno jamaqui junaqchopis templucho uryar acasu mana allitacu rurayarqan! ");
INSERT INTO qwhNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Alleq cäyiyämë. Canan quecho qamcunata parlapëcayäshoqniquim templupitapis mas presisaqqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jina Diospa palabranmi queno escribirëcan: ‘Qareniquicunapitapis noqaqa mas munä nuna mayiquicunata ancupäyänequitam’ nir. Tseta qamcuna manam cäyiyashqatsu cayanqui, sitsun cäyiyashqa cayanquiman, manam nuna mayiquicunata acusar ‘Mana allitam rurarin’ niyanquimantsu mana jutsayoqcunata. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tsemi Diospita Shamushqa Nunapa munenincho jamaqui junaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsepita eucurninnam, Jesus yecurerqan ellucayänan wayiman. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tsechomi tsaquishqa maquiyoq juc nuna quecarqan. Tsenam ley yachatsicoqcunaqa y fariseucunaqa, Jesusta acuseta munarnin queno tapuyarqan: —¿Leynintsic permitincu jamaqui junaqcho juc qeshyaqta cachacätsinapaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesusnam queno nerqan: —¿Manacu meqequipis jucllella ushequicuna jamaqui junaqcho posuman jeqacurcuptin jorquriyanquiman? ");
INSERT INTO qwhNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tse üshapitaqa juc nunam mas balin. Tsemi jamaqui junaqchopis imatapis alli caqtaqa ruranantsic —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tseno nirirnam, maquin wanushqa nunatana, “Maquiquita pallarï” nerqan. Y maquinta pallarconqan öram tse maquin alliyärerqan, y yame caq maquinno sanu ticrarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Peru fariseucunanam tse ellucayänan wayipita yarqurir, yachatsinacur parlayarqan Jesusta imanopapis wanicatsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tseno parlayanqanta musyarirnam, Jesus tsepita eucorqan. Eucuptinnam, atscaq nunacuna qatiyarqan, y llapan qeshyaqcunatam cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pecunatam nerqan: —Ama pitapis noqapaq willacuyanquitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tsenopam cumplicärerqan profeta Isaias queno escribenqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Caq quemi sirwimaqnï. Petam cuyarnin acrashqä, y pepitam allapa cushicü. Santu Espiritütam peta qoycushaq. Pemi llapan nasioncho nunacunata willapanqa alli cawaquipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Manam piwanpis liryaconqatsu, ni manam pitapis qayaripanqatsu. Manam pipis wiyanqatsu callicunacho llutanta parlar pureqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Laqtsiquicaq rämacunata salbecoq cuentam y upicaquicaq chiuchita yanapecoq cuentam, alli cawaquipaq llapan nunacunata musyatsenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y llapan nasion nunacunam shuyaräyanqa pe salbecuyänanta” nirmi, Isaias escriberqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsemannam apayämorqan juc nunata. Tse nunaqa supëpa muneninchomi cacorqan; manam ricarqantsu ni parlarqantsu. Jesus cachacäratsiptinnam, ricachacaramorqan y parlar qallecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tseta riquecurnam, llapan nunacuna espantacur, mantsacar quiquincuna pura queno ninacuyarqan: —¿Petsuraq canman Davidpa castanpita salbamänantsicpaq shuyaconqantsic nuna? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tseta cayïcurcurnam fariseucuna queno niyarqan: —Que nunaqa supëcunapa mandacoqnin Beelzebupa poderninwanmi nunacunapita supëcunata qarqun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tseno pensayanqanta musyarirnam, Jesus pecunata queno nerqan: “Sitsun juc nasioncho nunacuna quiquincuna pura chiquinacuyanqa, raquicarmi, ushacäriyanqa. Tsenollam jina juc marcacho o juc wayicho yachaqcuna quiquincuna pura chiquinacorqa, tse castacuna raquicarmi, ushacäriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tse cuentanollam nunacunapita supëcunata diablu qarqorqa, quiquinpa contran car mandaquininta ushacäratsinman. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Qamcuna pensayanqui ‘Beelzebupa poderninwanmi supëcunata qarqican’ nir. Tseno carqa, ¿Pipa poderninwantaq qampa disipuliquicunaqa supëcunata nunacunapita qarquyan? Pecunam musyatsiyäshunqui mana caqta parlayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Antis Santu Espiritu yanapamaptin supëcunata qarqunqäta ricarmi musyariyanqui Diospa mandaquinin qamcunaman chäramonqanta.” ");
INSERT INTO qwhNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","˻Beelzebupita mas puedeq canqanta cäyitsirmi˼ Jesus queno nerqan: “Juc callpayoq nuna wayinta täpecaptenqa, manam manaraq peta pancarqa pipis imantapis suwanmantsu. Pancarirran imecancunatapis apacunman. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Pipis noqapa mana fabornï carqa, noqapa conträmi quecan. Pipis noqawan mana elloq caqqa; peormi nunacunata witsicacharcun. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Tsemi que niyanqaqcunata shumaq cäyiyämë: Diosqa nunacunata imeca jutsancunatapis, y pepaq llapan mana allicunata parlayanqancunatapis perdoneconqam; peru Santu Espiritupa contran mana allicunata parlayaptenqa, manam perdonanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tsenollam Diospita Shamushqa Nunapaq, pipis contran mana allicunata parlaptenqa, Dios perdoneconqam; peru Santu Espiritupa contran mana allicunata parlayaptenqa, Dios manam perdonanqatsu, ni que bidacho ni wac bidachopis.” ");
INSERT INTO qwhNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tsepitanam Jesus queno yachatsicorqan: “Alli monteqa alli frutatam wayun, y mana alli monteqa mana alli frutatam wayun. Wayïnimpitam montitaqa imano canqantapis reqintsic. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Qamcunaqa imeca benenosu bibora cuentam cayanqui! ¿Imanopataq qamcuna allicunata parlayanquiman, shonqiquicunacho mana allita yarpëcarnin! Porqui nunaqa parlan shonquncho imatapis yarpanqantam. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tse cuentanollam alli caq nuna shonqun alli captin, allicunallata parlan; mana alli caq nunanam shonqun mana alli captin, mana allicunata parlecan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Masqui quetapis shumaq wiyaräyämë: Juisiu junaqmi Dios nunacunata jusganqa llapan mana combieneqcunata parlayanqancunapita. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porqui quiquiquicuna parlayashqequim musyatsiyäshunqui, jutsayoq o mana jutsayoq cayanqequitapis.” ");
INSERT INTO qwhNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tseno niptinnam, waquin fariseucuna y ley yachatsicoqcuna Jesusta niyarqan: —Mayestru, noqacuna imanomi munecuyä juc milagruta ruramunequita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesusnam nerqan: —¡Qamcunaqa Diosta mana cäsucurmi y llutanta rurar cawaquicarmi, juc milagru ruranätaraq munayanqui! Peru qamcuna munayanqequinoqa manam ima milagrutapis rurashaqtsu. Tsepa rantenqa Teyta Dios juc milagrutam ruranqa profeta Jonascho ruranqantano noqacho. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Imanomi Jonas quima junaq y quima paqas jatun pescadupa pachancho cacorqan, tsenollam quima junaq y quima paqas Diospita Shamushqa Nunapis, patsa rurincho pamparanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Que patsa ushacänan junaqmi Ninive marcacho täraq une nunacuna sharcayämonqa, canan tiempu nunacunata mana alli ruraq cayanqanta shimpiyänanpaq. Porqui pecunaqa Jonas willaconqanta wiyar cäsucurmi, jutsancunata jaqirïcur Diosman creyicuyarqan. Y Jonaspitaqa canan qamcunawan quecaqmi mas puedeq. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tsenollam juisiu junaqcho, Shebapita reinapis Diospa nopancho shimpir condenayäshunqui canan tiempu nunacunata. Porqui tse warmeqa Salomon allapa yacheninwan parlaqta wiyaqmi allapa caru marcapita shamorqan, y Salomonpitaqa canan qamcunawan quecho quecaqmi mas poderyoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tsepitanam quenona Jesus willapäcorqan: “Supëyoq nunapita supë yarqurirmi, tsunyaqcunapa ewar, mechopis jamacunanpaq ashirnin purican. Mana tarirninnam, queno nin: ");
INSERT INTO qwhNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Yarqamonqä nunamanmi cuticushaq täraq’ nir. Cutïcurnam, tse nunapa shonqunta tarin imeca shumaq pitsapäcushqa jayaquicaq wayitano. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsenam tse supë ewar pepitapis mas mana alli ruraq qanchis supëcunata mincaquicur cutïcun, y llapanmi yecuriyan nunapa shonqunman. Tsenam tse nuna nopa canqanpitapis mas peor ticracurin. Tsenomi pasaconqa que mana alli ruraq nunacunawan.” ");
INSERT INTO qwhNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus tseno yachatsicur quecaptinnam, pepa wauqincuna y mamanqa waqtacho shuyarëcayarqan, pewan parleta munarnin. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Juc nunanam Jesusta queno willarerqan: —Mamäniquim wauqiquicunawan shuyarëcayäshunqui waqtacho. Qamwanshi parleta munayan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tseno willariptinnam, Jesus nerqan: —¿Pitaq noqapa mamänï y wauqïcuna cayan! ");
INSERT INTO qwhNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tsenam disipuluncunata dedunwan apuntecur queno nerqan: —Quecho quecaqcunam mamänïcuna y wauqïcunaqa cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porqui pipis sielucho quecaq Dios Yayä mandacushqancunata wiyacoqcunam noqapa wauqïcunaqa panïcunaqa y mamänïqa cayan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tse junaqmi Jesus wayipita yarqur ewarnin, Galilea nishqan Lamar cuchuncho täcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tseman atscaq nunacuna elluquecuyaptinnam Jesusqa juc barcuman lloqarcur täcurerqan. Nunacunanam lamar cuchuncho quedariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsechonam iwalatsiquicunawan Jesus yachatsicur qallecorqan queno: “Juc nunam ewarqan chacranman murucoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Muruta maqtsiptinnam, waquin muru pintiyarqan näniman. Tsetanam pishqucuna ushpacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Y waquincunanam ranraman pintiyarqan. Y tsecho allpan uchuclla captinnam, tse murucuna ajalla jeqarayämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Y mana alli watsin captinnam, raslla tsaquiriyarqan inti achachaptin. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquinnam pintiyarqan cashacuna rurinman. Tse cashacunanam muru jeqamoqta tsapacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Peru waquin murunam ishquiyarqan alli allpaman. Tsecho jeqaramurnam poqurir, llutepa wayicorqan cada espigacho pachac granupayan (100), joqta chuncapayan (60) y quima chuncapayan (30). ");
INSERT INTO qwhNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Tsemi rinriyoq carqa, wiyacur cäsucuyë!” ");
INSERT INTO qwhNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsenam disipuluncunaqa Jesusman witïcur tapuyarqan queno: —Tëte, ¿Imanirtaq iwalatsiquicunawan tse nunacunata yachatserqonqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesusnam queno nerqan: “Qamcunataqa Diosmi cäyitsiyäshunqui mandaquinin imano canqanta; peru pecunataqa manam. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wiyacoq caqcunaqa mas allim cäyicuyanqa, peru mana wiyacoq caqcunaqa, ichiclla wiyayanqantapis qonqariyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsemi iwalatsiquicunawan yachatserqö. Porqui pecunaqa ruranqäcunata riquecarpis, mana ricaqnomi quecayan; parlanqäta wiyecarpis, mana wiyaqnomi quecayan, y manam cäyiyanpistsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pecuna tseno cayanqanmi canan tincurin profeta Isaias queno escribenqan: ‘Parlanqäta melaya wiyecarpis manam cäyicuyanqatsu. Rurashqancunata melaya riquecarpis manam creyicuyanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porqui que nunacunapa shonquncunaqa pasepa chucruyashqam. Rinrincunapis latucashqam, y nawincunapis wiscuyashqam. Tsemi wiyecarpis cäsucuyantsu, y riquecarpis marcäcuyantsu. Ni shonquncunacho cäyicuyantsu. Tseno carmi juclaya ticrayantsu, salbecunäpaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Peru qamcunaqa cushicuyë. Porqui ricarninmi, cuentata qocuyanqui; y wiyarninmi cäyicuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rasontam niyaq: Atscaq profetacunam y alli ruraq nunacunam que ricayanqequicunata riqueta munecarpis, manam ricayarqantsu; y canan wiyayanqequicunata wiyeta munecarpis, manam wiyayarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Canan cäyicuyë murucoqwan iwalatsicur willapäyanqaq ima ninan cashqanta: ");
INSERT INTO qwhNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Diospa mandaquinincho cayänanpaq alli willaquita wiyar mana cäyicoq nunacunam, näniman muru pintishqa cuentano cayan. Shonquncunaman alli willaqui chasquiyashqantam diablu pasepa qonqaratsin. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Waquin nunacunanam ranraman muru pinteq cuenta cayan. Pecunam alli willaquita wiyacur cushishqa chasquiriyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Peru imeca mana alli watsiyoq carmi, creyiquinincunacho mana alleqpa patsacashqa cayan. Tsemi alli willaquirecur tuqui sufrimientucunata pasarnin, y nuna mayincuna chiquiyaptin creyiquinincunata qonqariyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Waquincunanam cayan casha, casha rurinman muru pinteq cuenta. Pecunam alli willaquita wiyarirnin creyicuyan; peru que patsacho imapaqpis yarpacacharmi y capoqyoq quepaq locuyarmi, alli willaquita manana wiyacurnin, ni imata Diospaqqa rurayantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Peru waquin nunacunanam alli allpaman muru pintishqa cuenta cayan. Pecunam alli willaquita wiyar cäyicurnin, creyicuyan y allapa allicunatam Diospaq rurayan, pecunam cayan: pachacpayan, (100) joqta chuncapayan (60) y quima chunca (30) granupayan espiga wayïcoq cuenta.” ");
INSERT INTO qwhNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tsepitanam Jesus yape yachatsicorqan que iwalatsiquiwan queno nishpa: “Diospa mandaquinincho queqa quenomi: Juc nunam chacranman alli muruta murucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Peru muroqcuna punucuyanqanyaqnam, chiqueqnin nuna ewecur, tse murushqa jananman balliguta maqtsicur cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigu winar espigar qallecuptinnam, jina balligupis espigaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsenam uryaqnincunaqa patronnincunaman ewar, queno tapuyarqan: ‘Wiraqtsa, qamqa alli murutataq murutsiyämarqequi, peru ¿imanepataq balligoqa jeqamorqon?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tseno niyaptinnam, patronnincunaqa queno nerqan: ‘Tsetaqa chiquimaqnïmi maqtsicushqa’ nir. Uryaqnincunanam queno tapuyarqan: ‘¿Munanquicu ewar tse mana alli qorata llupicacharcuyänäta?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Peru patronnam nerqan: ‘Ama llupiyëtsu. Paqtam tseno rurayanqequita trigutawan llupicacharcuyanquiman. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejor triguwan iwal poqucuyätsun. Cosecha chäramuptinnam, segaqcunata nishaq tse balliguta watar, watar puntata ellurir cayecuyänanpaq. Tsepitana trigüta ellurir winanäman churayänanpaq’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tsepitanam Jesus, jina que iwalatsiquiwan yachatsicorqan, queno nishpa: “Diospa mandaquinincho caqcunaqa imeca juc nuna chacrancho mostasata muronqan cuentam. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anirpis mostasa muroqa waquin murucunapitapis mas uchucllallanllam; peru yuranqa, waquin plantacunapitapis mas winarmi juc montino ticrarin. Tsemannam pishqucunapis ewar rämancunacho qeshuncuna rurayan” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jina que iwalatsiquiwanpis Jesus yachatsicorqanmi queno nishpa: “Diospa mandaquinincho cawaqueqa imeca juc warmi quima tupu jarinaman ichiclla lebadurata winarcur pichuriptin masata poqucaratseqnomi.” ");
INSERT INTO qwhNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tsenomi tuqui iwalatsiquicunawan Jesus tsecho atsca nunacunata yachatserqan. Y mana iwalatsiquiwanqa manam imatapis yachatsicorqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tseno yachatsicuptinmi, profeta queno escribishqan cumplirerqan: “Imawanpis iwalatsiquiwanmi yachatsicushaq y que patsa camacashqanpita canancamayaq mana pipis musyayanqantam willacushaq”, nenqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsepitanam juntacashqa quecayaq nunacunata witsiratsir, Jesus yecurerqan wayiman. Disipuluncunanam Jesusman witïcur queno niyarqan: “Chacracho balliguwan iwalatsicur yachatsiconqequita cäyiratsiyämë, Teyta” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tseno niyaptinnam, Jesus queno nerqan: “Tse alli muruta muroq caqqa Diospita Shamushqa Nunam. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chacranam nunacuna cayan. Alli muruwannam Diospa mandaquinincho quecaq nunacuna iwalayan. Y tse balligu qorawannam diabluta sirwirnin, caquicaq nunacuna iwalayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tse chacrayoqta chiquir, trigu murucushqanman balliguta maqtsicoq caqnam, quiquin diabluwan iwalarin. Cosecha tiempunam que patsa ushacänan junaqwan iwalan. Cosecha elloqcunanam anjelcuna cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Imanomi mana alli qorata elluricur ninawan cayecuntsic. Tsenomi juisiu junaq canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Diospita Shamushqa Nunam, anjelnincunata cachamonqa mandaquinincho quecaq nunacunapita jutsaman ishquitsicoqcunata, y llutanta rurar caquicaqcunata ellunanpaq, ");
INSERT INTO qwhNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tsepitana jornuno rupaquicaq infiernuman jitecunanpaq. Tsechomi waqaquicuyanqa quiruncunatapis ruchuchutsirraq. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Peru Dios munashqanno cawacoqcunanam imeca intinoraq tillapyäcuyanqa, Dios Yayawan sielucho quecar. ¡Tsemi rinriyoq carqa, wiyacur cäsucuyë!” ");
INSERT INTO qwhNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Diospa mandaquinincho cawaqueqa quenomi: Juc nunam illaqpita tarïcunaq atsca qelle pamparaquicaqta. Tsepitana cashqanllaman pampecur sellama cushishqa wayinman cuticunaq, y imecancunatapis rantiquicur tse qelle pamparanqan chacrata ranticurcunaq.” ");
INSERT INTO qwhNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tsepitanam Jesus que iwalatsiquiwan queno nishpa yachatsicorqan: “Diospa mandaquinincho queta munaq nunacunaqa iwalayan imeca allapa chaniyoq perlas alajata juc negosianti nuna asheqwanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tse negosianti nunam allapa baloryoq alajata tarïcur, cuticur llapan imecancunatapis rantiquicunaq tse alajata ranticurcunanpaq.” ");
INSERT INTO qwhNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tsepitanam Jesus que iwalatsiquiwan queno nishpa yachatsicorqan: “Diospa mandaquinincho queqa imeca lamarman atarayata jitarcushqa tuquilaya pescaduta tsarïcamoqnomi. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ataraya juntariptinmi, pescadu tsareqcuna lamar cuchunman jorqariyan. Tsechonam pescaduta acrayan. Allin caqtam canastancunaman winayan, y mana allicunatanam jitacacharcuyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tsenollam juisiu junaqcho nunacunawan canqa: Anjelcunam jutsa sapacunata alli ruraq nunacunapita acranqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jutsasapacunatam rupaquicaq infiernuman jitarcuyanqa. Tsechomi jiparnin, waqayanqa asta quiruncunatapis ruchuchutsirraq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tseno willapäcurirnam, Jesus tapucorqan queno: —¿Que llapan willapäyanqaqta qamcuna cäyiyarqonquicu? —nir. Disipuluncunanam: —Aumi Teyta cäyiyarqömi —niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsenam Jesus nerqan: —Juc nunapam wayincho imecanpis capun ellushqancuna. Tse nunam shumaq inishita yachan punta wardacushqanta y qepa wardacushqantapis. Tse cuentam ley yachatsicoqcuna Diospa mandaquinincho canapaq caqta cäyir punta musyayanqancunapita y canancamayaq musyayanqancunata yachatsiyänan. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tseno tuquilaya iwalatsiquiwan yachatsicurirnam, Jesus tsepita eucur, ");
INSERT INTO qwhNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","marcanmanna chärerqan. Tsechonam ellucayänan wayicho yachatsicur qallecorqan. Tsenam nunacunaqa espantacur queno niyarqan: —¿Mechotaq quelayaqa yachaquecamorqon? ¿Imanopataq quelaya milagrucunata rurecun? ");
INSERT INTO qwhNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¡Que nunaqa carpinteru Josepa tsurintaq; mamanpis Mariataq, wauqincunapis Santiagutaq, Josetaq, Simontaq y Judastaq! ");
INSERT INTO qwhNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y panincunapis que marcantsiccho noqantsicwan juntutaq quecayan. ¿Pinaraq que nunataqa quelaya musyaq cananpaq yachecatserqon! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tseno nirninmi, piñarnin wiyetapis mana munayarqantsu. Peru Jesusnam nerqan: —Mechopis profetacunataqa respetayanmi, peru quiquinpa marcanchoqa y wayinchoqa manam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Marca mayincuna tseno peman mana creyicuyaptinmi, allapaqa milagrucunata Jesus tsecho rurarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tse tiempum Galilea marcacho rey Herodis mandacoq quecar wiyarerqan Jesuspaq nunacuna allapa parlayaqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsemi sirweqnincunata Herodis queno nerqan: —Tse nunaqa capas wanutsenqä bautisacoq Juan cawaricarcamushqa. Tsechi ya poderyoq car espantepaq milagrucunata rurecan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mas puntatam bautisacoq Juanta quiquin rey Herodis cadenarcatsir carselman llawicatsishqa carqan. Tsenoqa rurecorqan amigan Herodiaswan libri cacuyänanrecurmi. Herodiasqa carqan Felipipa warminmi, y Felipeqa carqan rey Herodispa wauqinmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tsenoqa llawicatserqan, “¡Wauquiquipa warminwan yachacurnin, Moises escribishqan leypa contranmi rurecanqui!” nishqa captinmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Carselman manaraq llawitsishpam Herodisqa Juanta wanuratsinan carqan; peru manam almiterqantsu nunacunata mantsarnin, porqui llapan nunacunam Juanpaqqa creyiyarqan profeta cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Peru Herodispa santunchonam tse amigan Herodiaspa wawan shipashqa shumaq tushuquicorqan, llapan combidashqacuna nopancho. Tseno tushonqanmi Herodista allapa gustecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tsenam Herodisqa llapan nunacunata testigaquicur, jurar queno nerqan: —¡Cananmi si niña, imecatapis mañamanqequitaqa qoycushqequi! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsenam shipashqa mamänin yacharatsiptin Herodista queno nerqan: —Bautisacoq Juanpa peqanta juc platucho qoycamë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Tsenam rey Herodis allapa llaquishqa ticrarerqan; peru combidashqancunapa nopancho jurar änishqa carnam, soldaduncunata mandarqan carselman ewecur bautisacoq Juanta roquliyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tsenam soldaducunaqa Juanpa peqanta aparnin, juc jatun platucho shipashta qoriyarqan, y shipashnam mamäninta qorerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juanpa disipuluncunanam checur, Juanpa ayanta apacurnin pampaquicuyarqan. Tsepitanam ewar Jesusta willayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juanta tseno rurayanqanta musyarirnam, lanchaman lloqarcur Jesus eucorqan juc tsunyaqman, tsecho japallan cacunanpaq. Peru nunacunanam tseta musyarirnin, tse marcacunapita lamar cuchunpa ewar Jesusta llalliriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesusnam chärir lanchapita yarpurir, tsecho atscaq nunacunata ricarerqan. Tsenam allapa ancuparnin, cachacätserqan tsecho llapan qeshyaqcunata. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Patsa tardiyäquicuptinnam, Jesusman witirirnin, queno niyarqan: —Tëte, tardiyäquicunnam. Que tsunyaqchoqa manam ni imapis cantsu. Que nunacunata witsiratsina pueblucunapa ewar miquinincuna rantiyänanpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesusnam nerqan: —Manam presisantsu ewacuyänan. Qamcunam pachanqa qarayänequi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Disipuluncunanam niyarqan: —Tëte, noqacunapapis quecayäpaman pitsqa tantawan ishque pescadullam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusnam nerqan: —Mä tsellatapis apayämï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Apariyaptinnam, tsecho nunacunata nerqan pampa tsampacunaman jamacuyänanpaq. Tsepitanam tse pitsqa tantata y ishque pescaduta tsarircur sieluman riquecur, Diosta “Grasias” nicurerqan. Tsepitanam tse tantata paquirir disipuluncunata qorqan nunacunata qarayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Llapancunam micuyarqan asta teqñayanqanyaq, y sobratapis elluriyarqan chunca ishque (12) canasta juntataran. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tse micoqcunaqa cayarqan ollqullam pitsqa waranqano (5,000), y manam warmicunatawan wamracunataqa yupayarqanpistsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsepitanam Jesus disipuluncunata mandarqan lanchaman lloqarcur lamarpa wac tsimpanman puntärëcayänanpaq. Penam tsecho nunacunata despidir quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nunacunata despidirirnam Jesusqa jircapa eucorqan, tsecho Diosman japallan mañacunanpaq. Paqasyanqanyaqmi tsecho japallan cacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tseyaqnam disipuluncunaqa lamar chopintana lanchawan euquicayarqan. Tseno euquicayaptinnam, shucuqui yurircur, mana allinman bientur, yacuta laqcheqsätsir, lanchatapis casi cusparerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Patsa warärëcaptinnam, Jesusqa yacu jananpa ewar disipuluncuna caqman yecurëcarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Disipuluncunanam yacu jananpa ewaqta riquecur, mana reqir, allapa mantsacar, queno qayarïcuyarqan: —¡Achachi! ¡Taqe almata! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tsenam Jesusqa queno nerqan: —Balorta tsariyë. Noqam cä. Ama mantsacäyëtsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsenam Pedru nerqan: —Teyta, rasonpa qam carqa, permitiquï noqapis yacu jananpa qam caqman shamunäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusnam “¡Shamï, ari!” nerqan. Tsenam Pedroqa lanchapita yarpurir, Jesus caqman yacu jananpa ewar qallecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Peru allapa bientuptinnam, mantsaquecorqan, y yacuman undicacurcoqno carnam, qayarïcorqan queno: —¡Wau! ¡Teyta, salbecallamë! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tsenam Jesusqa Pedruta maquinpita tsarircamorqan queno nishpa: —Pedru, ¿Imanirtaq noqaman ichiclla marcäcunqui! ¿Imanirtaq, ‘Mä rasonpacush’ nir, yarpacacharqonqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lanchaman lloqariyaptinnam, tselaya bientu pärarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tsenam barcucho quecaqcuna Jesuspa nopanman qonquriquicur queno niyarqan: —¡Rasonpam qamqa canqui Diospa tsurin! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tse lamarta tsimparirnam, chäriyarqan Genesaret nishqan marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tse marcacho täraq nunacunanam Jesus cashqanta reqïcur, wacpa quepa ewar willacuyarqan. Tsemi llapan qeshyaqnincunata peman apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chäratsirnam, rogayarqan qeshyaqnincuna mantunpa cuchunllatapis yatecuyänanpaq. Y yataq caqqa llapanmi cachacäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tsepitanam Jerusalenpita ewaq fariseucuna y ley yachatsicoqcuna Jesusman witïcur queno tapuyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Imanirtaq disipuliquicuna awiluntsiccunapa costumbrincunata cäsuyantsu! ¿Imanirtaq manaraq micur, maquincunata paqacuyantsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tseno niyaptinnam, Jesuspis queno taporqan: —¿Imanirtaq qamcunapis costumbriquicunata mas presisaqpaq churaricur Diospa mandaquininta mana cumpliyanquitsu! ");
INSERT INTO qwhNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porqui Diosmi queno nerqan: ‘Tëtequita, mamequita allipa ricanqui’ nir. ‘Y mamanpaq mana alli parlaq caqtaqa wanuratsiyätsun’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Peru qamcunanam yachatsicuyanqui, ‘Papä, mamä, yanapeniquita manam puedïtsu. Quecapamanpis Diosllapaqmi’ nishpa, niyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tseno yachatsirmi, mañecatsiyanqui, mamäninta papäninta mana yanapayänanpaq. Tseno yachatsicurmi, Dios mandacushqancunata juc cuchuman churarir, quiquiquicunapa costumbriquicunallata ruraquicayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ä, alli tucoq nunacuna! Rasontam profeta Isaiaspis qamcunapaq Dios nishqanta queno escriberqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Que nunacunaqa shimincunallanwanmi respetamaq tucuyan; Peru shonquncunachoqa manam yarpäyämanpistsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nunacunapa costumbrincunallata yachatsicuyaptinmi, adorayämanqanpis sirwintsu’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsepitanam tsecho quecaqcunata qayecur Jesus queno nerqan: —¡Canan shumaq wiyacurnin, cäyiyämë! ");
INSERT INTO qwhNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shimipa yecoq caqqa manam nunata melanepaqta ticratsintsu; yarqamoq caqmi nunataqa melanepaqta rurarin —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tsenam disipuluncuna Jesusman witïcur queno niyarqan: —¿Cuentata qocorqonquicu tseno nïcuptiqui, fariseucuna piñacurcuyanqanta? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Tsenam Jesus nerqan: —¡Ama pecunata cäsuyëtsu! Fariseucunaqa wiscu cuentam cayan, y tseno wiscu cuenta quecashpam nunacunata pushaquicayan. Tseno carmi, ¡ishcancuna sanjaman jeqacurcuyanqa! Sielucho quecaq Papänïpa mana cayaptinmi, imeca qorata sipinpita tirareq cuenta ushacäratsiyanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsenam Pedroqa Jesusta queno nerqan: —Tse tincutsiquita shumaq cäyicatsilläyämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesusnam nerqan: —¿Qamcunaqa upacu cayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manacu cuentata qocuyanqui llapan miconqantsiccunapis pachantsicllaman yeconqanta, y tsepitana pasaratsimonqantsicta! ");
INSERT INTO qwhNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Peru nunacunataqa shonqunpita mana allicunata parlanqanmi melanepaqta ticratsin. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsemi mana allicunata shonquncunacho yarpar quecunata rurayan: nunacuna wanutsinacuyan, majayoq quecarmi jucwan jucwan yachacuyan, mana majäcushpam jucwan jucwan puricuyan, suwacuyan, ulicuyan y ashanacuyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tseno rurarmi, nunacuna melanepaq ticrayan; peru maquincunata mana paqacushpa micuyanqanqa, manam nunacunata melanepaqtatsu ticratsin. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tsepita yarqurirnam, Tiro y Sidon nishqan marcacunapana Jesus eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tsecho quecaptinnam, juc warmi Canä marcapita shamur, Jesusman queno qayarir chäcurerqan: —Rey Davidpa castan Tëte, ¡ancupëcallämëri! Warmi wamrallämi allapa jipallan, pëcho supë captin —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Peru Jesusqa manam ni wiyaqpis tucorqantsu. Tsenam disipuluncunanaqa Jesusman witïcur queno rogayarqan: —Tëte, taqe warmita ‘Euquï’ nïquï, porqui qepantsictam qaparir, qayarir euquecämun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tseno niyaptinnam, Jesus queno nerqan: —Diosqa cachamashqa oqracashqa üsha cuenta caquicaq israel nunacunallamanmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tseta wiyecurnam, tse warmeqa Jesuspa nopanman witïcur queno nishpa qonquriquicorqan: —Tëte, ¡Yanapecallämë! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesusnam nerqan: —Sitsun qamta yanapecushqequi, ¡tseqa manam allitsu canman! Tseqa canqa imeca wamracuna tantata miquicayaptin qochirir, allqucunata qarecoq cuentam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tse warminam nerqan: —Rasontam ninqui, tëte. Peru imano captinpis, allqucunaqa siemprim micurilläyan dueñuncunapa mesanpita miqui shicwaqllatapis —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tseno nïcuptinnam, Jesus nerqan: —Au, warmi, ¡Allapa marcäquiyoqmi qam canqui! Mañacamanqequino catsun —nir. Tse öram warmipa wamran cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsepita eucurninam, Jesus chärerqan Galilea Lamar cuchunman. Tsechonam jircaman witsarcur täcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsemannam allapa atscaq nunacuna ellucayarqan. Cojucunatam, wiscucunatam, maqllucunatam, muducunatam y tuquilaya qeshyawan qeshyacoqcunatam Jesuspa nopanman apayarqan, y llapantam cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tsenam tsecho quecaq nunacuna espantacuyarqan, muducuna parlaqta wiyar, maqllucunata maquiyoqtana ricar, weqrucuna pureqta ricar y wiscucuna ricayaqta ricar. Tsemi nunacuna cushishqa alabayarqan israel nunacuna sirwiyanqan Diosta. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Disipuluncunata qayarirnam, Jesus queno nerqan: —Que nunacunata allapam ancupëcü. Quima junaqnam quecho noqawan quecayan; y manam ni imallapis micuyänanpaq cantsu. Manachi mallaqqa wayincunaman cuticuyanmantsu. Tseno mallaq eucorqa, nänichochi ishquiriyanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Disipuluncunanam queno niyarqan: —Peru quechoqa tsunyaqchomi quecantsic. ¿Mechoraq miquita tarishun quetsica nunacuna micuyänanpaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesusnam queno taporqan: —¿Ecallataq tantequicuna quecan? —nir. Pecunanam niyarqan: —Qanchis tantallam y juc ishque acapa pescadullam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsenam Jesusqa nunacunata nerqan pampaman täcuriyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Täcuriyaptinnam, qanchis tantata y pescaducunata tsarircur, Diosta “grasias” nicurir paquirerqan. Tsepitanam disipuluncunata qorerqan. Pecunanam nunacunata qarayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Llapan nunacunam micuyarqan asta teqñayanqanyaq. Tsepitapis qanchis canasta juntataran sobraqcunata elluriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tsecho micoqcunaqa cayarqan chuscu waranqam (4,000) ollqulla. Warmicunatawan wamracunataqa manam yupayarqanpistsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Micur ushariyaptinnam, nunacunapita despidiquicur, lanchaman lloqarcur Magdala marcaman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Juc cutinam fariseucunawan saduseucuna Jesusman ewayarqan, y mana alliman ishquitsita munarmi, queno niyarqan: —Mä, ima milagrullatapis Diospa poderninwan ruraramï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tseno niyaptinnam, Jesusqa queno nerqan: —Tardipa patsa pucäriptinmi, ‘Usyarillanqam’ niyanqui; ");
INSERT INTO qwhNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","qoyapa yana pucute sharcamoqta ricarnam ‘Cananqa tamyamonqam’ niyanqui. ¡Tsecunataqa buenum musyayanqui! ¡Peru manam musyayanquitsu que tiempucuna ima señal pasaquicanqanta! ");
INSERT INTO qwhNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Qamcunaqa Diosta mana cäsucurmi y llutanta rurar cawacurmi, juc milagru ruranätaraq munayanqui! Peru qamcuna munayanqequinoqa manam ima milagrutapis rurashaqtsu. Tsepa rantenqa Teyta Diosmi juc milagruta ruranqa profeta Jonascho ruranqantano noqacho. Tseno nirirmi, nunacunata tsecho jaqirir, Jesus eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tsepitanam Jesuspa disipuluncunaqa lamarpa wac tsimpanman ewayarqan; y tantata apetam qonqecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tsenam Jesus queno nerqan: —Cuidacuyë fariseucunapa y saduseucunapa lebadurancunapita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsenam disipuluncunaqa quiquincuna pura queno ninacuyarqan: —Tantata qonqecamushqa cashqam tseno nimantsic —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tseno ninacuyanqanta cäyicurcurnam, Jesus queno nerqan: —Ä, ichiclla marcäquiyoq nunacuna. ¿Imanirtaq tantequicuna mana canqanta yarpacachäyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manacu yarpäyanqui pitsqa tantallapita pitsqa waranqa (5,000) nunacunata micatsenqäta! Jina ¿manacu yarpäyanqui eca canasta juntata sobracunata elluyanqequita! ");
INSERT INTO qwhNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jina ¿manacu yarpäyanqui qanchis tantallapita chuscu waranqa (4,000) nunacunata micatsenqäta! Y ¿eca canasta juntatataq sobra tantacunata elluyarqequi! ");
INSERT INTO qwhNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tseno quecaptin, ¿imanirtaq qamcuna pensayanqui tantallapaq parlecanqäta! Noqaqa parlecä fariseucunapa y saduseucunapa lebadurancunapita cuidacuyänequipaq caqtam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tseno niptinran, disipuluncuna cäyicuriyarqan tanta rurana lebadurapaq mana parlecanqanta; sinoqa fariseucunapa y saduseucunapa mana alli yachatsiquinincunapita cuidacuyänanpaq parlecashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tsepitanam Cesarea Filipo nishqan caseriucunaman chärir, Jesus disipuluncunata queno taporqan: —Diospita Shamushqa Nunapaq, ¿pi canqantataq niyan? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pecunanam queno niyarqan: —Waquinmi niyan qamqa bautisacoq Juanshi canqui. Waquinnam niyan Diospa profetan Eliasshi qamqa canqui. Waquincunanam niyan ‘Jeremiaschi o profetacunachi meqan carpis’ niyanmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsenam Jesus nerqan: —Qamcunaqa, ¿imataq niyanqui? ¿Pitaq cä? ");
INSERT INTO qwhNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsenam Simon Pedroqa queno nerqan: —¡Qamqa Dios Acrashqanmi canqui, cawecaq Diospa tsurin! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesusnam nerqan: —Jonaspa tsurin Simon, ¡qamqa allapa cushiquiyoqmi canqui! Porqui manam ni meqan nunatsu tseno nimänequipaq yachatsishorqonqui; sinoqa sielucho quecaq Dios Yayämi cäyitsishorqonqui, ");
INSERT INTO qwhNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","y noqanam qamta neq: Pedrum canqui. Tsemi cananpita witsepa: Qaqa cuenta canqui, y noqaman creyicoqcunapaq alli simientu ruminomi canqui, y pecunata diablu manam ushacätsita puedenqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Qamtam qoycoq Dios mandaquicanqan puncupa llabinta tsararänequipaq. Qam que patsacho chasquinqequitam Diospis chasquenqa; y mana que patsacho chasquinqequitaqa manam Diospis chasquenqatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tseno nirirnam, disipuluncunata queno nerqan: —Dios Acrashqan canqäta ama pitapis willacuyanquitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tse junaqpitam Jesus disipuluncunata cäyitsirnin, queno willapar qallecorqan: —Jerusalenman ewanämi presisan. Tsechomi autoridacuna, saserdoticunapa mandacoqnincuna y ley yachatsicoqcuna allapa jipatsiyämar wanutsiyämanqa; peru quima junaqllatam cawarimushaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsenam Pedroqa juc laduman japallanta qayarir piñaparqan: —Tëte, ¿imatam parlanqui! ¡Tsecunaqa manam qamta pasashunquitsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Peru Jesusnam tumecur Pedruta queno nerqan: —¡Quepeq yarqï, diablu! ¡Ama atajämëtsu! ¡Qamqa manam Teyta Dios munashqannotsu yarpanqui; sinoqa nunacuna munashqannollam yarpanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tsepitanam disipuluncunata queno nerqan: —Pipis qatirämaqnï queta munarnenqa, quiquinpa muneninta jaqiricur, crus apaqno noqata qatimätsun. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pipis caweninllapaq yarparaq caqqa ushacanqam; peru noqarecur caweninta oqraq caqqa wiñe cawetam tarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Porqui ¿imapaqraq juc nunata sirwenqa jinantin mundupa dueñun canqanpis, wiñe caweta mana lobraptin! Y llutepa qelleyoq carpis, ¿acasu pagaquita puedincu almanta salbananpaq! ");
INSERT INTO qwhNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Que patsaman Dios Yayapa poderninwan y anjelnincunawan cutimurnin, Diospita Shamushqa Nunaqa, nunacunata premiun qonqa segun rurenincunamannomi. ");
INSERT INTO qwhNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Quetapis shumaq cäyirayämë: Canan quecho quecaqcunapitaqa waquinniquicuna manaran wanuyanquiraqtsu, asta Diospita Shamushqa Nuna cutimur mandacur qallarcoqta ricayanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tsepita joqta junaqtanam Jesusqa Pedruta, Santiaguta y Santiagupa wauqin Juanta pusharcur juc altu jircaman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tsechomi ricarëcayaptin, Jesus juclaya ticracurerqan. Qaqllanpis imeca intinoran chipapäcorqan. Ropannäqa imeca actsinoran chipapäcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tseno quecaptinnam, Moisesta y Eliasta Jesuswan parlecayaqta ricariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsenam Jesusta Pedru queno nerqan: —Teyta, ¡imalaya allim quecho quecantsic! Munaptiqueqa, quima tsucllata rurecayämushaq: jucta qampaq, jucta Moisespaq y juctana Eliaspaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedru tseno parlecaptinnam, chipapäquicaq pucute illaqpita yurircur pecunata tsaparerqan. Pucute rurinpitanam queno parlamoqta wiyayarqan: —Quemi cuyë tsurï. Pemi allapa cushitsiman. Peta cäsucuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tseta wiyecurnam, quiman disipuluncuna allapa mantsacar qonquriquicuyarqan qaqllancunapis patsaman chanqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tseno quecayaptinnam, pecunaman witïcur yatarirnin, Jesus queno nerqan: —Ama mantsacäyëtsu. Sharcuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Niptinnam, ñuquircur manana pitapis ricayarqanatsu. Jesusllatanam ricariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jircapita urärëcamurnam, Jesus pecunata queno nerqan: —Que ricayanqequita ama pitapis willayanquitsu asta Diospita Shamushqa Nuna wanurir cawarimonqanyaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsenam tse quiman disipuluncuna Jesusta queno tapuyarqan: —Teyta, ¿Imanirtaq ley yachatsicoqcunaqa niyan Diospa Acrashqan shamunanpaqqa puntataran profeta Elias shamonqa nishpa? ");
INSERT INTO qwhNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesusnam nerqan: —Aumi, pecuna niyashqannollam Eliasraq puntata shamunan carqan llapanta alistapäcoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Claru parlaquichoqa Eliasqa shamushqanam. Y nunacuna manam reqeqpis tucuyashqatsu, antis munayanqanta niräyanqantam peta ruracuyarqan. Tsenollam Diospita Shamushqa Nunatapis sufritsir jipatsiyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tsenam disipuluncuna cäyiriyarqan Eliaspa cuentan bautisacoq Juanpaq tseno parlecanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tsepitanam nunacuna purwacashqa quecayanqanman chärayämorqan. Tsechonam juc nuna Jesuspa nopanman qonquriquicur, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tëte, tsurilläta ancupëcullë; ataqui tsarirninmi, allapa jipatsin, öratanäqa yacumanpis o ninamampis seqirinmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Disipuliquicunamanpis apamorqömi, peru pecuna manam puediyashqatsu cachacätsimita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesusnam nerqan: —¡Allau, mana marcäcoq llutan ruraqcuna! ¡Imecamayaqraq qamcunawan quecashaq! ¡Imecamayaqraq awantashqequi! ¡Wamrata queman apayämï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Apariyaptinnam, tse wamracho quecaq supëta Jesus piñaparnin qarqorqan. Y tse öram tse wamra cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsepitanam disipuluncunaqa Jesusta japallanllatana queno tapuyarqan: —¿Imanirtaq noqacunaqa puediyarqötsu wamrapita supë qarqita? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesusnam queno nerqan: —Porqui qamcunaqa manam alleqllaqa marcäcuyanquiraqtsu noqaman. Rasontam niyaq: Sitsun marcäquiniquicuna canman mostasa muruno ichicllanllapis; que jircata “Juc laduman witicurï” niyaptiquipis, que jirca witicurinmanmi, y imapis ruracärinmanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","˻Quenolaya supëtaqa qarquntsic Diosman mañacurmi y ayunuta rurarmi.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea marcacho quecarnam, llapan disipuluncunata Jesus queno nerqan: —Diospita Shamushqa Nunatam chiqueqnincunapa maquinman entregayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pecunam wanutsiyanqa; peru quima junaqllatam, cawariramonqa —nir. Tseta wiyecurninmi, disipuluncuna allapa llaquishqa quedariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tsepitanam Capernaum marcaman disipuluncunawan chäriyarqan. Tsechomi templupaq impuestuta cobracoqcuna Pedruman witïcur queno niyarqan: —¿Imanirtaq mayestriquicunaqa impuestuta pagantsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedrunam queno nerqan: —Aumi, paganmi —nishpa. Pedru wayiman yecuriptinnam, Jesusqa puntata Pedruta queno nerqan: —Simon, ¿Imataq qam ninqui? ¿Que patsacho mandacoqcuna picunatataq impuestuta pagatsiyan? ¿Marca mayincunatacu o forasterucunatacu? ");
INSERT INTO qwhNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tsenam Pedru queno nerqan: —Forasteru caqcunatam —nir. Jesusnam nerqan: —Änirpis, manam marca mayincunataqa combienintsu pagatsiyänan. ");
INSERT INTO qwhNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Peru imano captinpis, paguecushun pecunata mana piñatsinapaq. Tsepaq lamarman ewar pescaduta tsariramï, y punta jorqamonqequi pescadupa shiminchomi tarinqui qelleta. Tse qelleta aparcur ewar paguecamï ishcantsicpita. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tsepinmi Jesusman witïcur disipuluncuna queno tapuyarqan: —¿Picunataq mas presisaq Diospa mandaquinincho cayanqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsenam Jesusqa juc wamrata qayarir, chopincunaman sharätsirnin, ");
INSERT INTO qwhNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","queno nerqan: —Masqui queta shumaq cäyirayämë: Que wamrano juclaya ticraqcunallam Diospa mandaquininman yecuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Porqui que wamrano qollmi shonqu caqcunallam, Diospa mandaquininchoqa presisaq cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Que wamrano caqcunata noqarecur chasqueq caqqa, noqatam chasquicaman —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jina quenopis Jesus nerqanmi: “Que wamracunano qollmi shonqunwan noqaman creyicamoqcunata pipis jutsaman ishquitseqcunataqa, mas allim canman cuncanman jatun mulinu rumin watarcur, lamarman jitarcuyänan. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Allau! ¡Que patsacho nuna mayinta jutsaman ishquitseqcuna! Siemprim cayanqa jutsallaquicuna; peru ¡Allau, tseno jutsallatsicoqcuna! ");
INSERT INTO qwhNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Tsemi, sitsun maquiqui o chaquiqui jutsa rureman ishquitsishiniquita munanqa, tse chaquiquita y maquiquita roqurir, weqapariqui mana ishcan chaquiquiwan y maquiquiwan mana ushacäcoq infiernuman yecunequipaq. Mas allim canqa wiñe caweman mancullapis y cojullapis yecunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y sitsun nawiqui jutsa rureman jitayäshunqui, oqtirir jitariquï, ishcan nawiquiwan infiernuman mana yecunequipaq; y mas allim canqa juc nawiyoqllapis wiñe caweman yecunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ama pitapis que wamrano umildicunata despresyayanquitsu. Noqam niyaq: Pecunata cuidaq anjelcunam sielucho Dios Yayäpa qaqllanta riquecayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","˻Porqui Diospita Shamushqa Nunaqa que patsaman shamushqa oqracashqa caqcunata salbananpaqmi.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Imataq niyanqui qamcuna? Masqui juc nunapa caputsun juc pachac (100) üshancuna. Y jucnin caqta oqrecutsun; ¿tranquilutsuraq cacunman? ¡Manam tranquilutsu caconqa! Antis isqon chunca isqon (99) üshanta mitsiconqancho jaqirïcurmi, tse oqracashqa üshan asheq ewanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tarïcorqa, tse mana oqracaq isqon chunca isqon (99) caq üshancunapaq cushiconqanpitapis masmi cushiconqa oqracashqa jucllella üshanta tarïcur. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tse cuentam sielucho quecaq Dios Yayapis munantsu ni juc qollmi shonqucunallapis oqracäyänanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Sitsun creyicoq mayiqui imatapis mana allita rurashunqui, japallanwan parlar, shumaq cäyipecatsï imacho ofendishonqequita. Wiyashuptiqueqa, pewan amishtë. Tseta rurarqa, yanapecorqonqui yape alli cawacunanpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana wiyashuptiqueqa, juc o ishcaq testigucunata pushecur, pecunawan willapëcuyë imacho ofendishonqequita cäyitsir. Tsemi tse pushanqequi nunacuna ishcaq car o quimaq carpis testigu cayanqa rasonpa ofendishonqequipita. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sitsun tse testigucunatapis wiyanqatsu, tse asuntuta llapan creyicoqcunata willequï; sitsun pecunatapis wiyanqatsu, tsepenqa Diosta mana cäsucoqcunatano o impuestu cobracoqcunatanona riquë. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Queta alleq musyayë: Qamcuna que patsacho watäyanqequim, Diospaqpis watashqa canqa; y que patsacho mana watäyanqequim Diospaqpis mana watashqatsu canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Jina quetapis niyashqequi: Sitsun que patsacho qamcunapita ishcaq juc yarpella car imatapis Dios Yayäta mañacuyanqui, tse mañacuyanqequita sielucho quecaq Dios Yayä wiyayäshunquim. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mechopis ishcaqllapis o quimaqllapis jutïcho juntarëcaqchoqa, pecunawanmi quecashaq.” ");
INSERT INTO qwhNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tseno niptinnam, Pedroqa Jesusman witïcur queno taporqan: —Teyta, ¿eca cutitaq ofendimaqcunata perdonashaq? ¿Qanchis cuticu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tseno niptinnam, Jesus nerqan: —Manam qanchis cutilla perdonanqui nicayaqtsu. Antis chuscu pachaq isqon chunca (490) cuti perdonanqui nicayaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Teyta Diospa mandaquinincho quetaqa iwalaratsishwan: Juc rey mayuralninta cuentata mañaqtawanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Juc reymi uryaqnincunata qayatserqan jaqancunata cobracunanpaq. Tsemanmi juc uryaqnin chärerqan. Pemi waranqa waranqa tse reypa jaqan carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tse nuna mana pagaquita puediptinnam, tse rey dispunirerqan, tse nunata esclabupaq, warminta, tsurincunata y llapan imecancunatapis rantiquicuyänanpaq, y tse qelleta jaqanpita tsarinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tsenam tse uryapaqnin nunaqa reypa nopanman qonquriquicur, maquinta choqpacurcur queno rogacorqan: ‘¡Wiraqtsa, amari tsetaqa rurecallämëtsu. Shuyecallämë, llapan jaqallequitam pagallashqequi!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tseno rogaptinnam, tse rey allapa ancupar llapan jaqanta perdonecur, eucunanpaq jaqirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Eucurëcarnam, tse jaqa wallqaqa toparcamorqan uryapucoq mayinwan. Tse nunam mä petapis debinaq, peru ichiclla. Petam cuncapita tsarircur, qapurita munar queno nerqan: ‘¡Canantä jaqäta pagamë!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsenam tse nunaqa, qonquriquicur rogacur nerqan, ‘¡Shuyecallämë, llapan jaqallequitam paguecullashqequi!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Peru wiyetapis manam munarqantsu; antis carselmanmi llawicatserqan asta llapan jaqanta paganqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tseta riquecurnam, waquin uryaq mayincunaqa allapa llaquicur espantacuyarqan. Tsemi tse reynincunaman ewar, llapan ruranqanta willayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tsenam reyqa tse uryaqninta qayecatsir, queno nerqan: ‘¡Ä, mana ancupäcoq malafe! Noqaqa rogamaptiqui, llapan jaqätam perdonecorqaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Imanirtaq qamqa tse nuna mayiquita noqa ancupanqaqno ancuparqonquitsu!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tseno nirirnam, tse reyqa allapa piñar, tse jaqa wallqata carselman llawiratsir castigatserqan, asta llapan jaqa queninta pagaconqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tsenollam sielucho quecaq Dios Yayäpis castigayäshunqui nuna mayiquicunata llapan shonqiquicunawan mana perdonayaptiqueqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tseno yachatsicurirnam, Jesus tse Galilea marcapita eucorqan y chärerqan Jordan mayupa wac tsimpan Judea probinsiaman. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsemanpis atscaq nunacunam qatiyarqan. Y tsechomi llapan qeshyaqcunata cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tsenam fariseucunaqa, Jesusman witïcur yachatsiquinincho pantatsita munar, queno tapuyarqan: —¿Leynintsiccho permitincu warminpita juc nuna diborsiacurinanpaq ima achäquillapis? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesusnam nerqan: —¿Manacu Diospa palabranta leyiyashqa cayanqui ‘que patsata camarnin, warmita ollquta camanqanta’? ");
INSERT INTO qwhNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jina nerqanmi: ‘Tsemi, ollqu jaqirenqa mamanta yayanta warmiwan juntacäyänanpaq. Y ishcancunapis jucnollanam cayanqa’ nenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsemi ishcaqnatsu cayan, sinoqa jucllellanam. Tseno captinmi, Dios juntashqantaqa mana pipis raquinmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tseno niptinnam, queno tapuyarqan: —Tsepenqa, ¿imanirtaq Moises queno mandacorqan: ‘Meqan nunapis warminpita raquiqueta munarqa, diborsio papelta firmecur raquicacuritsun?’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusnam nerqan: —Chucru shonqu cayaptiquim, Moises tseno escriberqan; peru Teyta Diosqa que munduta camarnin, manam tseno raquicayänanpaqtsu dispunerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Peru alleq cäyiyämë que niyanqaqta: Pipis warmin juc ollquwan mana yachecaptin jaqirir, juc warmiwan casacorqa jutsamanmi ishquirin. Tsenollam tse qowanpita raquicashqa warmiwan casacoq nunapis jutsaman jina ishquirin —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tseno niptinnam, disipuluncunaqa queno niyarqan: —Tseno captenqa, mejor ama casacuyätsuntsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesusnam queno nerqan: —Llapan nunacunatsu manam que nishqäta cäyiyan, sinoqa Teyta Dios permitenqan caqcunallam. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Änirpis waquin nunacunaqa warminäyantsu, yuriquininpita patsa tseno cayänanpaq Dios permitishqa captinmi. Peru waquincunatam capayan mana warminäyänanpaq. Y waquincunanam warmita munayantsu japallancunalla Teyta Diosta sirwicuyänanrecur. Que niyanqaqcunata wiyacur chasqueq caqcunaqa cäyicuyë. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsepitanam nunacuna ñushpi wamrancunata Jesusman apayarqan bendisirnin, Diosta mañacunanpaq; peru disipuluncunanam wamra apaqcunata piñapäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tsenam Jesus nerqan: —¡Noqaman wamracuna shayämutsun! ¡Ama michäyëtsu! Que wamracunano caqcunapaqmi Diospa mandaquinenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tseno nirirmi, pecunaman maquinta churar bendisirirnin, tsepita eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tsepitanam juc jobin Jesusman ewar, queno taporqan: —Yachatsicoq ˻alli nuna˼, ¿Wac bidacho wiñepa cawanäpaq ima allitataq rurashaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesusnam yasquerqan: —¿Imanirtaq alli nuna nimanqui! Jucllellam alleqa, y tseqa Diosllam. Wac bidacho wiñepa caweta munarqa, Dios mandacushqancunatam ruranequi. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tseno niptinnam, jobenqa queno taporqan: —Ari, ¿meqan caq mandamientutataq cumplishaq? —nir. Jesusnam nerqan: —‘Nuna mayiquita ama wanutsinquitsu. Majayoq quecar, ama jucwan jucwanqa yachacunquitsu. Ama suwacunquitsu. Ama nuna mayiquipaq ulicurcur mana caqta parlanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tëtequita, mamequita respetanqui. Nuna mayiquita cuyanqui quiquiquitano’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tseno niptinnam, tse jobin queno nerqan: —Tsecunataqa cumplicämi. ¿Masqa imatataq rurashaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tsenam Jesus queno nerqan: —Alli nuna queta munarnenqa, canan ewar llapan imequicunatapis rantiquicur, tse qelleta wactsacunata qoyquï. Tseno ruraptiquim, sielucho mana ushacäcoq fortunequi canqa. Tseno rurarïcur, noqata qatimë. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tseta wiyecurnam, tse jobenqa allapa llaquicur eucorqan; porqui allapa ricum carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsepitanam disipuluncunata Jesus queno nerqan: —Que niyanqaqta wiyacur shumaq cäyiyämë: Allapa sasam canqa juc capoqyoq nunapaq Diospa mandaquininman yecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tsemi yapepis niriyaq: ¡Mas alerim awjapa uchcunpa juc jatun animal camellu pasarinman, juc capoqyoq nuna Diospa mandaquininman yecunanpitaqa! ");
INSERT INTO qwhNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tseta wiyecurnäqa, disipuluncuna masran espantacuyarqan, y quenomi niyarqan: —Tseno captenqa, ¿pillanataq salbaconqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesusnam disipuluncunata alli ricarëcur nerqan: —Quiquincunallapitaqa manam pipis salbaquita puediyantsu; Teyta Diosllam nunacunataqa salban, porqui Diospaqqa manam imapis sasatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsenam Pedru queno nerqan: —Teyta, noqalläcunaqa llapantam jaqiriyarqö, qamta qatiyänaqpaq. Tsepita ¿Imatataq chasquillayäshaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusnam nerqan: —Rasontam niyaq: Que munducho imecapis mushoqman ticranan junaqmi, y Diospita Shamushqa Nuna poderninwan mandacur tacurinan junaqmi, qatirämaqcunaqa alli täcunacunaman tëcur, chunca ishque (12) israel casta nunacunata jusgayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y wayinta, wauqincunata, panincunata, tëtanta, mamanta, ˻warminta,˼ wamrancunata y chacrancunatapis noqarecur jaqireq caqcunaqa, chasquiyanqa pachac (100) cuti mastam, y wac bidachoqa wiñepam cawanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Peru canan tiempu presisaq caqcunam qepacho cayanqa, y mana presisaq caqcunanam puntacho cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Diospa mandaquinincho queqa quewanpis iwalanmi: Juc asendadum qoya qoyalla callicunapa ewarqan ubas chacrancho uryayänanpaq peyuncunata asheq. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Peyuncunata taririrnam, queno nerqan: ‘Jornal completutam pagayashqequi; ewayë chacräman uryaq’ nir. Tsenam uryaq jeqariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsepitanam patronqa las nuebinona yape ewarqan mercadupa y tsechonam tarirerqan uryapuquita asheq nunacunata tsecho täquicaqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pecunatam queno nerqan: ‘Qamcunapis ubas chacräman uryaq ewayë, derechiquitam pagayashqequi’ nir. Tsenam pecunapis jeqariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsepitanam pullan junaqpis y tardi las trespis yape tse patron ewarqan peyuncunata asheq. Taririrnam, pecunatapis jina chacranman cacharqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Inti jeqecaptinnam, yape tse patron plasata ewarqan. Tsechonam jina mas nunacunata taririr, jina queno taporqan: ‘¿Imanirtaq qamcunaqa osiosyäcur quecho qanyasyäriyanqui?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pecunanam queno niyarqan: ‘Pillapis manam mincallayämantsu uryayänäpaq’ nir. Tsenam pecunatapis jina queno nerqan: ‘Tsepenqa qamcunapis ewayë ubas chacräman uryaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Patsa paqasyärëcaptinnam, patronqa mayuralninta queno nerqan: ‘Uryaqcunata qayecur jornalnincunata paguecarï. Tardi yecoqcunata puntanqui, tsepitana qoyalla yecoqcunataqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tsenam tardiraq uryaq yecoqcunaqa chäriyarqan paguncuna chasqueq. Y cada unum chasquiriyarqan juc jornal completuta. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsepitanam qoya qoyalla uryaq yecoqcunanapis chäriyarqan paguncuna chasqueq. Pecunaqa pensayarqan, ‘Noqantsicqa masllatam chasquishun’ nishpam. Peru pecunapis chasquiyarqan parlayanqanno juc jornalllatam. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tsellata chasquïcurnam, piñarcur patronta reclamar, ");
INSERT INTO qwhNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","queno niyarqan: ‘Que qepa yecamoqcunaqa juc örallam uryayashqa. Peru pecunataqa, ¿imanirtaq paguecunqui noqacunatawan iwalta! Noqacunaqa qanyasninpim uryayarqö tselaya achachechopis’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tsenam tse reclamaq caqta queno nerqan: ‘Amigu, parlashqantsicnotaq juc jornal completuta paguecaq, o ¿ima mana allitam rurecä! ");
INSERT INTO qwhNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Upälla paguiquita chasquircur euquï y quiquï munarmi tardiraq yecamoqcunatapis qamcunatawan iwal pagacü. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Qellenïwanqa munanqätam ruracunä ¿imanirtaq alli canqäta waqapucuyanqui!’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tseno willapäcurirnam, Jesus queno nerqan: —Tsenomi canqa Diospa mandaquinincho. Canan presisaqcunam presisaqtsu cayanqa; y canan mana presisaqcunanam presisaq cayanqa, ˻porqui atscaq qayashqa quecarpis wallcaqllam acrashqaqa cayanqa˼ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tsepitanam Jerusalenman ewarëcarnin, Jesusqa chunca ishque (12) disipuluncunata juc laduman qayarir, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Musyayanqequinomi Jerusalenman ewecantsic. Tsechomi Diospita Shamushqa Nunata saserdoticunapa mandacoqnincunaman y ley yachatsicoqcunaman entregayanqa. Pecunanam wanutsiyänanpaq condenayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tsepitanam mana israel autoridacunaman apayanqa. Pecunam burlacur asicachar tuquita rurayanqa. Maqarninmi, crusificayanqa; peru quima junaqllatam cawarimonqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsepitanam Zebedeupa warmenqa ishcan wawancunawan Jesusman witïcur qonquriquicur, wawancunapaq juc faborta mañacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsenam Jesusqa queno taporqan: —¿Imatataq munayanqui? —nir. Warminam nerqan: —Ama acseqa callanquitsu. Munallä mandacur qallecullanqequi öra wawalläcuna jucnin derechu ladiquiman y jucninna itsoq caq ladiquiman tecur mandacuyänätam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesusnam nerqan: —Qamcunaqa manam musyayanquitsu imata mañacayämanqequitapis. ¿Qamcuna puediyanquimantsuraq noqa pasanäpaq caqcunata paseta? —nir. Pecunanam “Aumi, puedilläyämi” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesusnam nerqan: —Änirpis rasonpam noqa pasanqäno sasacunata pasayanqui; peru derechu laducho y itsoq laducho pipis täcamunanpaqqa manam noqatsu dispunï. Tsetaqa Papänïllam dispunishqana —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tseta wiyecurnam, chunca caq disipuluncunaqa tse ishcan wauqiwan piñacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tsenam llapan disipuluncunata qayarir queno nerqan: —Musyayanqequinomi Diosman mana marcäcoq mandacoqcunaqa nunacunata allqutsayan, y puedeq quenincunaman atenicurmi, nunacunata munashqanta rurayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Peru qamcunachoqa manam tsenotsu canqa. Meqequipis mandacoq queta munarqa, llapantam sirwiyänequi. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Meqequipis mayor queta munarqa, esclabu cuentam cayänequi. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsenollam Diospita Shamushqa Nunapis que patsaman shamushqa nunacunata sirwinanpaq, y manam nunacuna sirwiyänanpaqtsu, sinoqa yawarninwan nunacunata rescatananpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tsepitanam Jerico marcapita Jesus eucuptin atscaq nunacuna qatiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tseno eucurëcarnam, näni cuchuncho tariyarqan ishcaq wiscucuna tëcaqta. Tse wiscucunam Jesus tsepa pasarëcanqanta mäquicur queno qayarïcuyarqan: —¡Rey Davidpa castan Teyta, ancupëcalläyämëri! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tseno qayaripa niyaptinnam, Jesuswan ewaq nunacuna “¡Upalla cayë!” nir piñapäyarqan. Peru tseno michäyaptinpis, masran qayariyarqan: —¡Davidpa castan Teyta, ancupëcalläyämëri! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tseno qayacoqta wiyecurnam, Jesusqa shäcurerqan y wiscucunata qayecur, queno taporqan: —Qamcunapaq ¿ima ruranätataq munayanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wiscucunanam queno niyarqan: —Nawilläcuna ricanantam munalläyä, Teyta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tseno rogacuyaptinnam, Jesusqa allapa ancuparnin, nawincunata yatecaporqan. Tse öram nawincuna quichacäriptin, Jesusta qatircur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalenman yequicarnam, Olibus nishqan jircacho quecaq Betfage marcaman chäriyarqan. Tsepitam Jesus ishcaq disipuluncunata cacharqan ");
INSERT INTO qwhNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","queno nishpa: —Ewayë taqe ricaquecamoq marcaman. Tseman chärirmi, tariyanqui wawayoq ashnu watarëcaqta. Tse ashnucunata pascarir apayämunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sitsun pipis ‘¿Imapaqtaq ashnuta pascayanqui?’ niyäshunqui, ‘Teytam nesitan. Rasllam cutiratsiyämushaq’ niyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tsecunata ruraptinmi, profeta queno nishpa escribishqan cumplirerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalen marcacho täraqcunata willayë: ‘Ricayätsun reyniquicuna pollinu ashnun montacushqa lluta nunanolla pecunaman yequicaqta’ ” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Disipuluncunanam ewar rurayarqan Jesus nenqannolla. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ashnuta pascarirnam, wawantin apayarqan. Chäratsirnam, pollinu caq ashnuta aqshunancunawan carunayarqan Jesus montananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tseno montacushqa Jesus ewaptinam, tsecho atscaq nunacuna aqshunancunata qoturïcur näniman mashtayarqan; y waquincaqcunanam monticunapa rämanta paquirir qopiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y llapan nunacunam Jesuspa puntanta y qepanta ewaqcunaqa, cushicur qaparir qayarir queno niyarqan: —¡Alabashun rey Davidpa mirenin salbacoqnintsicta! ¡Alabashun Diospa shutincho shamoqta! ¡Alabecuyaqmi sielucho quecaq Dios! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalenman Jesus chäriptinnam, tsecho llapan nunacunaqa mantsacäcur espantacuyarqan, y jucnin jucnin queno tapunacuyarqan: —¿Imana caq nunataq queqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tseno niyaptinnam, waquin caq nunacunaqa queno niyarqan: —Pëqa Jesusmi y profetam. Galilea probinsiapa Nazaret caseriunpitam shamushqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tsepitanam Jesusqa templuman yequicur, patiucho qatucoqcunata y rantipäcoqcunata qarqacacharcamorqan. Tsenollam qelle trocaqcunapa mesancunatapis y paluma ranticoqcunapa täcuyänancunatapis jitacacharcamorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Y quenomi nerqan: —Diospa palabranchomi queno escribirëcan: ‘Wayïqa mañacuna wayim’ nir. Tseno quecaptin, ¿imanirtaq suwacunapa machenintano ticratsiyarqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsepitanam templucho quecaptin wiscucuna y cojucuna Jesusman witiyarqan, y llapantam cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Templuchonam wamracuna queno qapariyarqan qayariyarqan: —¡Alabecushun rey Davidpa castanta! —nir. Peru tseta wiyecurnam, y espantepaqcunata Jesus ruraqta riquecurnam, saserdoticunapa mandacoqnincuna y ley yachatsicoqcuna piñacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tsemi Jesusta queno niyarqan: —¡Wiyë wamracuna tseno alabayäshonqequita! —nir. Jesusnam nerqan: —Wiyecamï, ¿qamcuna manacu leyishqa cayanqui Diospa palabrancho: ‘Llullu wamracunam y chichicaq wamracunam musyatsicuyan Diosta imano alabanan canqantapis’ nenqanta! ");
INSERT INTO qwhNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tseno nïcurmi, pecunata tsecho jaqirir Betania marcaman eucorqan. Tsechomi tse paqas quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Waräninnam qoya, qoyalla Jerusalenman Jesus cuticaptin pachan waqacurcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsenam näni cuchuncho igus montita riquecur micurita munar ewarqan frutan asheq; peru manam ni jucllellatapis tarerqantsu. Raprantällam caquicarqan. Tsenam tse igus montita Jesus queno nïcorqan: —¡Amana mas frutequi catsuntsu! —nir. Y jina öram tse igus monti tsaquirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tseta riquecurnam, disipuluncunaqa espantacur Jesusta queno niyarqan: —Tëte, ¿Imanepataq juclla igus monti tsaquirishqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tseno niyaptinnam, Jesus queno nerqan: —Rasontam niyaq: Sitsun llapan shonqiquicunawan rasonpa marcäcuyanqui, que igusta tsaquiratsenqäpitapis mas espantepaqcunatam rurayanqui; asta que jircata ‘¡Quepita yarqur lamarman jeqacurquï!’ niyaptiquipis, ewar jeqacurconqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Llapan shonqiquicunawan marcäcur imatapis mañacorqa, chasquiyanquim. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tseno yachatsicurirnam, templuman Jesus yecurerqan. Tsecho yachatsiquicaptinnam, saserdoticunapa mandacoqnincuna y autoridacuna Jesusman witïcur queno niyarqan: —¿Ima puedeq queniquiwantaq quecunata rurarqonqui! ¿Tseno ruranequipaq pitaq mandashorqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tseno niyaptinnam, Jesus nerqan: —Noqapis qamcunata jucta tapuyäshqequi: Tapuyanqaqta yasquiyämaptiqueqa, noqapis willayäshqequim pipa poderninwan quecunata ruranqäta ");
INSERT INTO qwhNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pitaq cachamorqan bautisacoq Juanta nunacunata bautisananpaq, Dioscu o nunacunallacu? Tseno tapïcuptinnam, quiquincuna pura queno ninacuyarqan: —¿Imataq nishun? ‘Diosmi cachamushqa’ nishqaqa, tsepenqa ‘¿Imanirtaq peta creyiyarqequitsu!’ nimäshunmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sitsun nishun ‘Nunacunam’ nir, nunacunam piñacurcuyanqa. Porqui Juanpaqqa profeta canqantam creyiyan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsenam Jesusta queno niyarqan: —Manam musyayätsu —nir. Tseno niyaptinnam, Jesuspis nerqan: —Tsepenqa noqapis manam willayaqtsu quecunata ruranäpaq pi mandamanqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tsepitanam Jesusqa pecunata queno nerqan: —Juc nunapam caporqan ishcaq tsurincuna. Tse nunam juc caq tsurinta queno nerqan: ‘Iju, canan junaq ubas chacrantsicman uryaq ewarillë’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tse tsurinnam queno yasquerqan: ‘¡Manam eucütsu!’ nir. Peru alli pensacurcurnam, uryaq jeqarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tsepitanam nunaqa jina jucnin caq tsurintapis queno nerqan: ‘Iju, qampis ewarillë uryaq’ nir. Tsenam tse caq tsurenqa ‘Ewarishaqmi’ nir, änirerqan; peru tseno nicarpis, manam ewarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Canan qamcunata tapuyashqequi, ¿Meqan caq tsurintaq Tëtan mandashqanta rurarqan? Pecunanam —Punta mandanqan caqmi —niyarqan. Jesusnam queno nerqan: —Que niyanqaqta shumaq cäyicuyë: Roma nasionpaq impuestuta cobraq malafecunam y ollqun ollqun lluta pulicoq warmicunam qamcunapita mas puntata Diospa mandaquininman yecuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bautisacoq Juanmi shamorqan alli cawacuyänequipaq yachatsiyäshoqniqui, y manam peta creyiyarqonquitsu. Peru impuestu cobracoq malafecunam y ollqun ollqun puricoq warmicunam si creyicuyarqon. Tseta riquecarpis, manam qamcunaqa mana alli rureniquicunata jaqiyarqonquitsu, ni creyicuyarqonquipistsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Canan wiyariyë juc iwalatsiquiwan yachatsiquita: Juc nunam ubasta plantarqan chacranman, y jinantin cuchunpa perqatserqan. Nïcurmi, juc jatun posuta ruratserqan ubaspeq binuta jorquyänanpaq. Tsepitanam chacranta täpayänanpaqna juc jatun torita ruratserqan. Tsepitanam tse chacranta pullan pura muruyänanpaq nunacunata qoquicur, caru marcapa eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tsepitanam cosecha tiempu chäriptinna, chacrayoqqa sirweqnincunata cacharqan pullan pura muroqnincunaman pepa partinta raquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Peru tse pullan pura muroqcunanam patronpa sirweqnincuna chäriyaptin, tsarïcur maqaquicuyarqan, waquintanam tsampiquicuyarqan, waqincunatanam wanuratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsenam tse asendadu mas atscaqtana cacharqan; peru chacra tsaraq nunacunanam pecunatapis punta ewaqcunatanolla ruraquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Por ultimunam tse asendadu quiquinpa tsurintana cachecorqan queno pensarnin: ‘Tsurïtaqa respetayanqam’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Peru chacrayoqpa tsurin yecurëcaqta riquecurnam, chacra tsaraq nunacuna quiquincuna pura queno yachatsinacuriyarqan: ‘Queqa chacrayoqpa tsurinmi y erederum canqa; mejor wanicatsishun chacranwan quedacunantsicpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tseno yachatsinacurirmi, asendadupa tsurinta tsarïcur, chacranpita jaqman jorqurir wanuratsiyarqan.” ");
INSERT INTO qwhNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tseno nirirnam, Jesusqa queno tapucorqan: —Canan qamcuna niyämë: Tse ubas chacrayoq asendadu tse chacran tsaraqcunaman ewecur, ¿Imatataq ruranqa? ");
INSERT INTO qwhNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nunacunanam niyarqan: —Mana ancupashpachi tse mana alli ruraq nunacunata wanutsenqa. Y juccunatanachi chacranta qoyconqa, cosecha tiempu chäriptin tocanqan caqta örancho entregayänapaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tsenam Jesus queno nerqan: —¿Manacu Diospa palabranta queno escribirëcaqta leyishqa cayanqui? ‘Wayi perqaqcuna: “Que rumeqa manam allitsu” nir, jitariyanqanmi, cananqa mayestra rumi ticrarishqa. Diosmi dispunerqan tseno cananpaq. Tseqa noqantsiccunapaq allapa espantaquipaqmi’ ");
INSERT INTO qwhNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tseno Teyta Diospa palabran niptinmi niyaq: Mana cäsucuyanqequirecurmi, Diospa mandaquininman yecuyanquitsu; peru caru marca nunacunam siqa, cäsucuyänqanrecur tse mandadunman yecuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pipis tse rumiman ishqueq caqqa, allpa mancanomi ushacärenqa. Y tse rumi pimanpis jeqarqa, allpamanmi ticraratsenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Saserdoticunapa mandacoqnincunawan fariseucunanam cuentata qoquicuyarqan Jesus tseno willapäcur pecunata wiyapätsenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tsenam Jesusta presu tsaritsita munayarqan, peru mantsacuyarqanmi; porqui llapan nunacunam creyiyarqan Jesusqa profeta canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tsepitanam Jesus juc mas iwalatsiquiwan queno nishpa yachatsicorqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Diospa mandaquinincho queqa iwalan imeca juc rey tsurinta casatsir banquetita ruranqanwanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tse reymi sirweqnincunata cacharqan combidaduncunata qayayämunanpaq. Peru pecuna manam munayarqantsu tse banquetiman eweta. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mana ewayaptinnam, yapena waquin caq sirweqnincunatana cacharqan queno nishpa qayayämunanpaq: ‘Alli nobillucunatam y alli wira caq animalnincunatam pishtatishqa y miqui listunam callan. Tseshi shalläyämunquina casamientucho micupäcoq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Peru tse combidaducunaqa manam munayarqantsu. Mana wiyaqpis tucushpam juc caq eucorqan chacranman; jucnin caqnam eucorqan qatucoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquin caq combidaducunanam tse imbitacur ewaqcunata tsaricur, maqaquicuyarqan asta wanuratsiyänqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tsenam reyqa allapa piñarcur, mandarqan soldaduncunata tse wanutsicoq asesinucunata wanuratsiyänanpaq, y marcancunatapis cayecuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsepitanam reyqa sirweqnincunata queno nerqan: ‘Llapanpis listunam banquetipaq; y combidanqä nunacuna manam meresiyashqapistsu shamunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tsemi ewayë callicunapa y combidayämï llapan tariyanqequi nunacunata que casaqui banquetiman shayämunanpaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tsenam tse sirweqnincunaqa callicunapa ewar, pushecayämorqan llapan tariyanqan caqtaqa, alli nunacunatapis y mana alli nunacunatapis. Tsenopam wayin junta tse banqueticho nunacuna quecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tsepitanam reyqa combidaducuna ricaq yecurerqan. Tsechonam riquecorqan juc nunata raccha ratashllashqa trocacüni tëcaqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsenam tse nunata queno nerqan: ‘Amigu, ¿imanopataq queman yecamorqonqui mana ropequita trocacushpa! ¿Acasu casaqui fiestapaqnocu quecanqui!’ nir. Tseno niptin manam tse nuna ni ima nita puederqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsenam reyqa mesacho sirwicoqcunata mandarerqan queno nishpa: ‘Pancarcur, que nunata jitariyë waqtaman. Tse paqascho quiruntapis uchur waqatsun’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsepitanam Jesus queno cäyitsicorqan: —Tsenomi Dios atscaqta qayan. Peru wallcaqllam acrashqa cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsepitanam fariseucunaqa Jesus yachatsiquicanqanman ewayänanpaq queno cösa yachatsinacuyarqan: —Acu, shumaqllapa tapupar Jesusta llutanta parlecatsishun. Tsenam mana allita parlecuptenqa, tsewan acusashun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tseno parlarirnam, grupuncunapita y Herodispa grupunpitapis cachayarqan Jesusta queno niyänanpaq: —Mayestru, musyayämi rasonpa caqllata parlanqequita. Qamqa manam ni meqan nunaman qaqanquitsu. Rason caqllatam Dios munashqanno cawayänäpaq yachatsiyämanqui; ni manam meqan nunapa gustunta ruranquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tsemi mä nïcayämë, ¿Allicu Roma mandacoq cesarpaq impuestuta pagashwan o manacu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesusnam yachellapa mana allita parlatsiyänanpaq tapupäyanqanta cuentata qocurir queno nerqan: —Ä, alli tucoqcuna, ¿Imanirtaq mana alliman ishquitsimeta munayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä impuestuta pagacuyänequi qelleta ricatsiyämë —nir. Tsenam qoriyarqan juc qelleta. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesusnam tse qelleta ricarir, queno tapucorqan: —Que qellecho ¿pipa retratuntaq quecan? ¿Pipa jutintaq escribirëcan? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pecunanam niyarqan: —Mandacoq cesarpam —nir. Tsenam Jesus nerqan: —Tsepenqa mandacoq cesarpa caqtaqa mandacoq cesarta qoycuyë; y Diospa caqtaqa Diosta qoycuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesus tseno nenqanta wiyecurnam, mantsacar imano quetapis puediyarqantsu y jaqirïcurmi eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tse junaqmi saduseu nishqan grupupita Jesusman tapucoq ewayarqan. Tse saduseucunaqa manam creyiyantsu wanushqacuna cawariyämunanta. Tsemi cawarimi asuntu queno tapuyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mayestru, Moises escribishqan leychomi queno nican: ‘Sitsun juc nuna casadu quecar wanuconqa manaraq tsurin captin, wauqinlla tse llumtsinin biudanwan casacutsun; y tsurin yuririptinna, difuntupa tsurin cuenta catsun’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Masqui wiyarämë: Cayänaq qanchis wauqicunash. Mayor caqshi casacorqan juc warmiwan y manaraq tsurin captinshi, tse nuna wanuquicunaq. Tsepitanash jina qepa caq wauqinna tse llumtsinin biudawan casacurinaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tsenollash tse qepa caq wauqinpis wanuquicunaq manaraq tsurin captin. Tsenoshi jina mas qepan caq wauqincunapis qanchisninpi llumtsinincuna biudawan casacur casacur wanur ushacäriyänaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsepitanash warmipis wanuquicunaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mä, canan niyämë: Cawarimi junaqcho, que warmi qanchis wauqiwan casacushqa quecar, ¿Meqan caqpataq lejitimu warmin canqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tseno niyaptinnam, Jesusqa queno nerqan: —¡Qamcunaqa llutantam yarpäyanqui, porqui manam cäyiyanquitsu Diospa palabran escribirëcanqanta, ni Dios allapa poderyoq canqanta! ");
INSERT INTO qwhNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wanushqacuna cawariyämuptenqa, mananam warmipis ni ollqupis casacuyanqanatsu. Porqui sielucho quecaq anjelcunanollanam cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Qamcuna ¿manacu leyishqa cayanqui wanushqacuna cawarimunanpaq yachatsiquita quiquin Dios queno nenqanta! ");
INSERT INTO qwhNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Noqaqa une Abrahampa, Isaacpa y Jacobpa Diosninmi canan quecä. Tsemi Diosqa wanushqacunapa Diosnintsu; sinoqa cawecaqcunapam’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tseno yachatsiconqanta wiyecurnam, nunacuna allapa espantacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tsepitanam saduseucunata Jesus upalläratsenqanta musyarirnin, fariseucunaqa Jesus caqman ellucariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pecunachomi carqan ley yachatsicoq juc mayestru. Pemi Jesusta mana alliman ishquitsita munar queno taporqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mayestru, Diospa mandamientucho ¿Meqan caqtaq mas presisaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusnam nerqan: —‘Teyta Diosniquita cuyanqui llapan shonqiquiwan, llapan boluntaniquiwan y llapan yacheniquiwan.’ ");
INSERT INTO qwhNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Que mandamientum mas presisaq llapan mandamientupitapis. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tsenollam jucnin caq mandamientupis casi punta caqwan iwallla y quenomi nin: ‘Nuna mayiquita cuyanqui quiquiquitano.’ ");
INSERT INTO qwhNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Que ishcan mandamientullachomi Moises llapan escribishqancunapis y profetacuna yachatsiconqanpis patsacashqa quecan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseucuna tsellachoraq quecayaptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesus queno tapucorqan: —¿Imataq niyanqui Dios Acrashqanpaq? ¿Pipa mirenintaq pe canman? —nir. Pecunanam “Rey Davidpam” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tseno niyaptinnam, Jesus queno nerqan: —Tseno quecaptenqa, ¿Imanirtaq Santu Espiritu yanapaptin Davidqa Diospa Acrashqanpaq ‘Pëqa salbadornïmi’ nirnin, queno nerqan? ");
INSERT INTO qwhNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Diosmi nerqan Teyta Diosnïta: Que derechu ladüman täcamï asta llapan chiquiyäshoqniquicunata muneniquiman churamonqäyaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidpis ‘Teyta Diosnïmi’ nicaptenqa, ¿Imanopataq Cristoqa Davidpa mireninpitaraq canman! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesus tseno tapucuptin, manam meqanllapis ni ima nita puediyarqantsu. Y tse junaqpitaqa mananam ni meqanpis tapupeta almitiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tsepitanam tsecho quecaq nunacunata y disipuluncunata, Jesus queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ley yachatsicoqcunaqa y fariseucunaqa quiquin Moises cuentam, Teyta Diospa mandamientuncunata yachatsiyäshurniqui quecayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tsemi pecunata cäsucuyänequi y mandayäshonqequicunatapis rurayänequi. Peru ama rurenincunataqa qatiyanquitsu. Porqui pecunaqa manam yachatsicuyanqannotsu cawacuyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pecunaqa allapa sasacunatam, imeca lasaq qepita juytutseq cuenta ‘Quetaran wactaran rurayänequi’ nir, mandacuyan; peru tse mandacuyanqanta manam deduncunallawanpis yatariyantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Imecatapis ruraq tucuyan nunacuna alabayänanllapaqmi. Diospa palabrantanäqa urcuncunachopis y ricrancunachopis anchu sintacho escribïcur puricatsiyan. Y ‘Allapa relijiosum’ nir, nunacuna alabayänanpaqmi, tunicatanäqa shumaq flecuyoq jirecushqatam chaqui puntanyaq yacacushqa puricayan ");
INSERT INTO qwhNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Micupäquiman qayatsiyaptinpis, punta puntaman taquitam gustayan. Ellucayänan wayichopis mas presisaqcuna täcuyänanmanmi täquita munayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Callicunachonäqa allapa respetuwan ‘Mayestru’ nir, saludayänantam munayan. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Peru qamcunaqa ama ‘Mayestru’ niyäshuptiqui, cushiyanquitsu; porqui qamcunaqa llapequipis tse wauqillam cayanqui, y jucllellam yachatsicoq mayestriquicunaqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y ama que patsacho pitapis ‘Respetashqa teytallä’ nicayanquitsu; porqui jucllellam respetashqa Teytantsic, y pëqa sieluchomi quecan. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Y ama pipis ‘Alli yachatsicoq’ niyäshuptiqui cushiyanquitsu, porqui alli yachatsicoqqa jucllellam y tseqa Dios Acrashqanllam. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pipis qamcunacho mandacoqqa, qamcunatam sirwiyäshunequi. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porqui pipis quiquintä nuna tucoqqa penqacushqam canqa; y qollmi shonqu caqqa allapa presisaqmi canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Allau, alli tucoq ley yachatsicoqcuna y fariseucuna! Puncuta wichqaq cuentam Diospa mandaquininman yequita munaqcunata atajäyanqui. ¡Manataq Teyta Diosta cäsuyanquitsu y waquincuna cäsuquita munayaptinpis, atajaq cuentataq quecayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","˻¡Allau, alli tucoq ley yachatsicoqcuna y fariseucuna! Qamcunaqa biudacunapatam imancunatapis suwapäquicayanqui, y tseta cuentata mana qocuyänanpaqnam alli tucur unepa resacuyanqui. ¡Tseno rurayanqequipitam qamcuna mas castiguta chasquiyanqui!˼ ");
INSERT INTO qwhNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Allau, alli tucoq ley yachatsicoqcuna y fariseucuna! Qamcunam patsapapis, lamarpapis ewar, nunacunata grupiquicunaman yecayämunanpaq ashiyanqui, y jucllellatapis tarïcorqa yachatsiquiniquicunawanmi qamcunapitapis mas infiernucho castigashqa cananpaq causariyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Allau, wiscu cuentam qamcuna cayanqui! Tsemi queno yachatsicuyanqui: ‘Pipis templupa jutincho juramentuta ruraptenqa, manam presisantsu cumplinapaq’ nir. ‘Peru pipis templucho quecaq qori alajacunapa jutincho juramentuta rurarnenqa, cumplinanmi presisan’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ä, wiscu cuenta upa yachatsicoqcuna! ¿Meqantaq mas presisaq: Diospa templuncu, o tse templucho qoripita alajacunacu! Claru parlaquichoqa tse templu captinran, tse oru alajapis Diospaq nishqa quecan. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tsenollam Jina quenopis yachatsicuyanqui: ‘Altarpa jutincho juramentuta rurarir mana cumpliyaptiquipis, manam imanantsu’ nir, ‘peru sitsun altarman churashqa ofrendapa jutincho juramentuta rurayanqui, tsetam si, presisan cumpliyänequi’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ä, wiscu cuenta nunacuna! ¿Imataq mas presisaq? ¡Diosllapaq ofrendata churayänan altarmi, manam tse ofrendatsu! ");
INSERT INTO qwhNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Altarpa jutincho jurar imatapis änicoq caqqa, manam altarpa jutinllachotsu jurecan; sinoqa altarcho llapan churashqacunapa jutichopis jurecanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jina pipis templupa jutincho imatapis änicorqa, manam templupa jutinllachotsu äniquican; sinoqa templucho quecaq Teyta Diospa jutinchopis äniquicanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y pipis sielupa jutincho imatapis änicorqa, manam sielupa jutinllachotsu äniquican; sinoqa sielucho quecaq tronupa jutinchopis äniquicanmi. Tsenollam jina tse tronucho tëcaq Teyta Diospa jutinchopis änicurin. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Allau, alli tucoq ley yachatsicoqcuna y fariseucuna! Qamcunam mentallapitapis, anisllapitapis, cominusllapitapis chuncaman raquirir juc caqta Diosta qoypaq yarparäquicayanqui. Peru mas presisaq Moises escribishqancho alli rurecunapaq yachatsiquicunataqa, ancupäcoq quetaqa y Diosman marcäcoq quetaqa qonqaquicuyarqonquim. Tsecunatam mas rurayanquiman carqan, diesmu qoyta mana qonqashpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ä, wiscu cuenta yachatsicoqcuna! Tseno carmi, qamcuna imeca tushpicunata shüshurir yacuta upoq cuenta, allapa cuidacuyanqui, peru manam cuentata qocuyanquitsu imeca jatun camelluta ñoqtaquicaq cuenta caquicayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Allau, alli tucoq ley yachatsicoqcuna y fariseucuna! Qamcunaqa tasacunata, platucunata jananllata paqarishqa cuentam janallapa limpiu quecayanqui; peru tse tasacunapa y platucunapa rurin mana paqashqa cuentam suwaquiwanqa, y codisiosu quewanqa shonqiquicuna raccha püru caquican. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Wiscu cuenta mana cäyicoq fariseucuna, puntata tasapa, platupa rurinta paqaq cuenta shonqiquicunapa mana alli yarpeninta limpiayë! ¡Tsenoparan llapanchopis alli ruraq cayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Allau, alli tucoq ley yachatsicoqcuna y fariseucuna! Qamcunaqa sepultura janancho shumaq lapidawan adornashqa cuentam cayanqui. Jananllapaqa allapa shumaqmi tse sepultura ricacun, peru rurinchoqa ayapa tulluncunallam, ismucur melanepaq asyacur caquican. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tsenomi qamcunapis janallapaqa nunacuna ricayäshunequillapaq allita ruraq tucoq quecayanqui. Peru shonqiquicunachoqa melanepaq mana alli ruraqmi quecayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Allau qamcuna, alli tucoq ley yachatsicoqcuna y fariseucuna! Profetacuna pamparëcanqan sepulturancunatam shumaq rurecatsiyanqui. Tsenollam jina alli ruraq nunacuna pamparayanqancho lapidancuna shumaq rurecatsiyanqui; ");
INSERT INTO qwhNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","y quenoran niriyanqui: ‘Sitsun que pamparëcaq profetacunata awiluntsiccuna wanutsiyanqan tiempu quecashwanna carqan, manachi pecunata wanuratsiyänanta consientishwantsu carqan’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Y manam cuentata qocuyanquitsu tseno parlarnin, profetacunata wanutseq awiliquicunanolla qamcunapis quecayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Qamcunapis tse awiliquicunanolla quecarqa, jucllana pecuna rurayashqanta rurayë! ¿Imatanataq shuyaräyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Ä, bibora yupe mana alli ruraq nunacuna! ¿Tseno quecar, infiernu condenasionpita salbacuyanquitsuraq! ");
INSERT INTO qwhNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tsemi canan cachamushaq profetacunata, allapa yachaq nunacunata y mayestrucunata. Pecunatam canan waquincunata wanutsiyanqui, y waquintanam crusificayanqui. Waquincunatanam ellucayänan wayicunacho maqar ushayanqui, y marcan marcanmi chiquir qaticachäyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tseno rurarmi, culpayoq ticrariyanqui castigashqa cayänequipaq. Tse castigutaqa chasquiyanqui jutsannaq nunacunata awilitiquicuna wanutsiyanqanpitam, jutsannaq Abelta wanutsiyanqanpita qallecur, asta Berequiaspa tsurin, Zacariasta templupa altarnincho Diosta sirwicaptin wanutsiyanqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Shuyariyëllaqa, que llapan rurayanqequipitam qamcuna castiguta chasquiyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Ä, Jerusalen, Jerusalen nunacuna! ¡Qamcunam profetacunata wanutsiyanqui y Diospa cachan qamcunaman shamoqcunatam chiquirnin, rumiwan qompayanqui! Atsca cutim munarqä qamcunata imeca wallpa chipshancunata ripran rurinman elloqno elluyeniquita; ¡Peru manam munayarqonquitsu! ");
INSERT INTO qwhNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tsemi niyaq: Cananpita witsepam Templiquicunapis tsunyecar quedarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y niyaqmi: Cananpita witsepa mananam ricayämanquinatsu asta ‘¡Alabashqa catsun Diospa jutincho shamoq reynintsic!’ niyamanqequi tiempuyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Templupita yarqurir Jesus eucurëcaptinnam, disipuluncunaqa peman witïcur tse jatungare templuta ricatsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tsenam Jesusqa queno nerqan: —Masqui yarpäriyanqui, que riquecayanqequi templu pasepam ushacanqa, y manam ni juc rumillapis perqarëcarqa quedanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tsepitanam Olibus niyanqan jircacho Jesus tëcaptin, disipuluncuna witïcur, pacallapa queno tapuyarqan: —Mayestru, willarayämë, ¿Imetaq tsecuna pasaconqa? ¿Ima señata ricarnintaq musyariyäshaq cutimunequipaq y juisiu junaqpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesusnam nerqan: “¡Paqtataq pipis engañayäshunquiman! ");
INSERT INTO qwhNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Atscaq nunacunam ‘Noqam Dios Acrashqan cä’ nir, atscaq nunacunata engañar puriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gueracuna waccho quecho caquicaqtam wiyayanqui. Tsemi tseta wiyar ama mantsacäyanquitsu. Tsenomi susedicunan presisan, peru manaran que patsa ushacanqaraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Juc nasionmi juc nasionwan guerata rurayanqa. Y juc marca nunacunam juc marca nunacunawan wanutsinacuyanqa. Mechopis mallaqäqui watacunam canqa y patsam temblorwan allapa cuyonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tsecunaqa imeca juc warmi qeshpicunanpaq nanatsicushqannollaran canqa y sufrimientucunapa qallananllaran. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Qamcunatanäqa noqarecurmi llapan nunacuna chiquiyäshunqui; justisiacunaman entregayäshunqui. Tsechomi maqayäshurniqui wanutsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tse witsanmi noqaman creyicoqcuna noqaman manana marcäcur, quiquincuna pura chiquinacur, lebantanacur ticracuriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y uli profetacuna yuricaramurmi, mana alli yachatsiquinincunawan nunacunata engañayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Melanepaq mana allicunallata ruraqmi ticracuriyanqa. Tseta ricarmi, nunacunapa cuyaquinincunapis ushacäquiconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Peru tse sasa tiempucunacho wanonqanyaq noqacho tsaracoqmi salbaconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tsemi llapan nunacunata alli willaquinïta willayänequi presisan; tsenopa nunacuna Diospa mandaquininman yecuyänanpaq, y jinantin nasioncunacho tse alli willaquita musyariyaptinnam, que patsapa ushenin chäramonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Profeta Danielmi santu templuta desonrayänanpaq caqta musyarnin, queno escriberqan, ‘mana combieneq melanepaq sacrifisiuta rurecoqta.’ Queta leyeq caqqa shumaq cäyicuyätsun. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tseta riquecorqa, Judea marcacunacho täraqcuna qeshpir, ewacuyätsun jircacunapa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Altuscho quecaqcuna ama wayi ruriman yarpuyanqatsu imancunatapis jorqoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chacrancunacho quecaqcunapis ama cutiyanqatsu aqshunancuna jorqoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Allau, tse junaqcunacho qeshyaq tucushqa warmicuna y llulluta chichicaqcuna! ");
INSERT INTO qwhNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diosta mañacuyanqui sufrimientucunapita safacuyänequi öra mana jamaqui junaqcho, ni tamya tiempucho cananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porqui allapa jipaquimi canqa. Tseno jipaqueqa manam imepis cashqaraqtsu que patsa camacashqanpita; y mananam yapepis canqanatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Teyta Dios acrashqancunata cuyar tse sufrimientucunata mana ras pasaratsiptenqa, manachi pipis salbacunmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sitsun pipis niyäshunqui ‘Taqechomi quecan, o quechomi quecan Dios Acrashqan’ nir, ama creyiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porqui tse junaqcunam yuriyämonqa Dios Acrashqan tucoqcuna y profeta tucoqcuna. Pecunam espantepaq milagrucunata rurarnin, nunacunata engañayanqa, asta Dios acrashqancunatapis engañetam tïrayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Manaraq tsecuna pasacuptinmi, qamcunata willayaq pecunaman mana creyiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tsemi sitsun niyäshunqui ‘Taqe tsunyaqchomi Dios Acrashqan quecan’ nir, ama ewayanquitsu, o ‘Taqe washachomi ratarëcan’ niyäshuptiquipis, ama creyiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porqui imeca inti ullumunan ladupita asta inti jeqanan laduyaq relampagu tillapyaqnomi Diospita Shamushqa Nunaqa cutimonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Musyanqequinomi ‘Imapis wanushqa caqmanqa wiscurcuna ellucayan.’ ” ");
INSERT INTO qwhNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tsepitanam Jesus queno willapäcorqan: “Tse jipaquicuna pasariptinmi, inti ni quilla actsenqanatsu, qoyllurcunapis shicwayämonqam y llapan sielucho quecaqcunam cuyucurenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tse öram Diospita Shamushqa Nuna shamunanpaq sielucho señalta ricariyanqui. Tseta riquecurmi, que patsacho llapan nunacuna mantsaquewan mana imano quetapis puedir waqaquicuyanqa. Tseno waqaquicarmi, riquecuyanqa pucutecho puedeq queninwan chipapäquicar uraquecamoqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y anjelcunatam cachamonqa trompetata fuertipa toquecuyänanpaq. Tseno toquecuyaptinmi, mepita tsepitapis acrashqancuna ellucarayämonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Masqui igus montipa yuranpeq yachacuyë: Igus montim tseqllir qallecuptin raprancuna yurin. Tseta ricarmi, qamcuna musyariyanqui tamya tiempu qallarinanpaq canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tsenolla willayanqaqcuna susedicoqta ricar musyariyanqui que niyashqaqcuna cumplicänanpaq ichicllana pishicanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rasontam niyaq: Canan tiempu nunacuna manaraq wanuyaptinmi, llapan willaconqäcuna susediconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sielupis patsapis ushacäriyanqam, peru niyashqaq palabräqa manam ushacanqatsu; cumplicanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Que nishqäcuna ime öra o ime junaq cumplicänanpaq caqtaqa manam pipis musyayantsu, ni sielucho quecaq anjelcunapis, ni noqa Diospa tsurinpis, sinoqa quiquin Dios Yayallam musyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Imanomi Noepa tiempuncho nunacuna cawaquicayarqan; tsenomi Diospita Shamushqa Nuna cutimunan junaqcunapis cawaquicayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manaraq apäqui tamya captinmi, asta Noe barcuman yecurenqanyaq nunacuna micupäcur, upyacur, casacur caquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y manam cuentata qocuriyarqantsu apäqui tamya janancunachona quecanqantaqa, y llapancunam tse tamyawan ushacäyarqan. Tsenomi jina pasaconqa Diospita Shamushqa Nuna cutimunan junaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tse junaqmi ishcaq nunacuna chacracho juntu uryecayaptin, jucnin apacushqa canqa, y jucninnam jaqirishqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tsenollam ishcaq warmicuna juc marecho juntu aqaquicayaptin, jucnin apacushqa canqa, y jucninnam jaqirishqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“¡Tsemi mäcoq, mäcoq quecayänequi! Manam musyayanquitsu ime junaq ni ime öra Teyta Diosniquicuna cutimunantapis. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Masqui queta niriyashqequi: Sitsun wayiyoq nuna musyanman wayinman suwa ime öra ewananta, wayinta täpecarmi, warärinman y manam wayinman suwacoq yecuyänanta jaqirinmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tsemi qamcunapis mäcoq, mäcoq quecayänequi; porqui Diospita Shamushqa Nunaqa cutircamonqa qamcuna mana yarpäyanqequi öram.” ");
INSERT INTO qwhNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tsepitanam Jesus queno yachatsicorqan: “Pim mäcoq, mäcoq, cumplidu sirweqnin canqa petam patronnin confiacur churanqa wayinman, tsecho caqcunata miquinincuna örancho qarananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tseno ruraq sirwipacoqqa patronnin illanqanpita cutirir, llapan encarqashqanta rurecaqta taririptin allapa cushicutsun. ");
INSERT INTO qwhNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Masqui cäyiyë: Tseno cumplidu sirweqnintaqa ¿manatsuraq tse patronnin llapan imecancunamanpis confiacur mayuralnin cananpaq churecunman! ");
INSERT INTO qwhNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Peru sitsun tse sirwipacoq mana alli portacur ‘Patronnï manaran cutimonqaraqtsu’ nir, ");
INSERT INTO qwhNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sirwipacoq mayincunata maqar allqutsanqa, y borachucunawan micucur upyacur caconqa, ");
INSERT INTO qwhNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tseno caquicaptenqa, manaraq shuyacunanpaq alistacuptinmi, patronnin illaqpita chëcur, ");
INSERT INTO qwhNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tse mana alli ruraq sirweqninta feyupa castiganqa, alli tucoqcunatawan iwal. Tsechomi waqaquicuyanqa, quiruntapis uchurraq. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Diospa munenincho quecaq nunacunaman cutimuptïmi imeca, chunca shipashcuna nobiuta shuyacoqno shuyecayämanqa. Chunca shipashcunam chiuchincunawan yarquyarqan, nobiuta chasqueq. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tse shipashcunapitam pitsqan caq prebinida cayarqan. Y pitsqan caqnam dejada cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tse dejada caqcunam aseitincuna apayarqantsu chiuchincunacho ushacaptin yapayänanpaq ");
INSERT INTO qwhNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Peru prebinida caqcunam siqa chiuchincunachopis juntata apayarqan y pishiptin yapayänanpaqpis botellacunachoran apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y nobiu mana chaptinnam, shuyarëcayanqanta llapancunapis punucäriyarqan ");
INSERT INTO qwhNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tseno punucashqa caquicarnam, pullan paqas örana queno fuertipa qayacoqta wiyecuyarqan: ‘¡Nobium sharëcamun! ¡Yarqayämï chasqueqnin!’ neqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tseta wiyecurnam, pachaqsecamur llapan shipashcunaqa sharcur, chiuchincunata prebinipacur qallecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tsenam tse dejada caqcunaqa, tse prebinida caq shipashcunata queno niyarqan: ‘Chiuchilläcunam upirinna. Aseitilläcuna raquiralläyämë’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tseno mañacuyaptinnam, queno niyarqan: ‘Antis ewë rantirayämunqui. Raquicuyarniqueqa, noqacunanachi pishipäquicuyäshaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tsenam tse pitsqan dejada shipashcunaqa aseiti ranteq coricuyarqan. Peru tseyaqnam nobioqa chärerqan, y pitsqan caq prebinida shipashcunallam tse casacuyänan wayiman yecuriyarqan. Nïcurnam, puncuta llawirayämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cutirirnam, tse waquin shipashcunaqa puncuta tsactacuyarqan: ‘¡Tëte, Tëte, quicharalläyämë!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Peru wayi ruripitanam queno yasquimorqan: ‘¡Qamcunataqa manam reqiyaqtsu!’ nishpa.” ");
INSERT INTO qwhNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tse tincutsiquita willacurirnam, Jesus queno nerqan: —¡Mäcoq, mäcoq quecayë! Porqui manam musyayanquitsu ime öra cutimunäpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tsepitanam Jesus queno yachatsicorqan: “Diospa mandaduncho queqa, imeca juc patron caru marcapa eucunanpaq sirweqnincunata qayaratsir, negosiuta rurayänanpaq capital qellenincuna qonqanwanmi iwalarin. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tse patronmi jucnin caq sirweqninta qorqan pitsqa waranqata (5,000), jucnin caqtanam ishque waranqata (2,000) y juc caqtanam juc waranqallata (1,000). Tsenomi qorqan segun negosiu rureta yachayanqanmanno. Tseno qorirnam, caru marcata eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Euconqanyaqnam pitsqa waranqa chasqueq caq sirweqnenqa tse capitalwan negosiuta rurar, mas pitsqa waranqatana wacharatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tsenollam jina ishque waranqata chasqueq caqpis ishque waranqa masta wacharatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Peru juc waranqallata chasqueq caqnam patsata uchcurir, patronninpa qelleninta pampecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tsepita unetanam patronnincunaqa cutirir, sirweqnincunata qayecatsir, cuentata mañar qallecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsenam pitsqa waranqa chasqueq caq sirweqnenqa patronninta qorerqan pitsqa waranqa masta, queno nishpa: ‘Wiraqtsa, qelleniquita qollamarqequi pitsqa waranqatam, y pitsqa waranqa mastam wacharatserqö’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Patronnan nerqan: ‘Allitam rurarqonqui. ¡Qamqa alli sirwimaqnïmi canqui, y llapan nenqaqtam cumplerqonqui! Tsemi wallcallachopis onradu nuna canqequirecur, mas jatun carguiqui qoshqequi. Pasamï noqawan mesächo juntu cushicunantsicpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsepitanam ishque waranqa chasqueq caqpis jina queno nishpa chärerqan: ‘Wiraqtsa, ishque waranqatam qellellequita qoyämarqequi, y ishque waranqa mastam wacharatsillarqö’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsenam patronnenqa nerqan: ‘¡Qamqa alli sirwimaqnïmi canqui! Llapan nenqaqtam cumplerqonqui. Tsemi tse wallcalla qellewan alli negosiuta ruranqequirecur mas atscata qoshqequi. Pasamï noqawan mesacho juntu cushicunantsicpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Peru juc waranqallata chasqueq caq sirweqnin chärirnam, patronninta queno nerqan: ‘Wiraqtsa, musyämi qamqa acse nuna canqequita. Porqui qamqa mana churacushqequipitam, y mana murucushqequipitam ellunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsemi mantsarniqui, qelleniquita patsata uchcurir paquecorqä, caq quemi qellellequi’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Patronan queno nerqan: ‘Qamqa allapa qela mana alli ruraq nunam canqui. Mana muronqäpita y mana maqtsenqäpita elloq canqäta musyecarnenqa, ");
INSERT INTO qwhNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tse qellenïta bancuman churecunquiman carqan, cutimurnin wachenintawan ellunäpaq’ nir ");
INSERT INTO qwhNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tseno nirirnam, tsecho quecaq nunacunata nerqan, ‘Tse qelleta qochirïcur, chunca waranqa (10,000) qelleyoq caqta qoycuyë, ");
INSERT INTO qwhNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","porqui nenqäno ruraq caqcunaqa mastam chasquiyanqa asta sobranqanyaq; peru mandanqäta mana ruraq caqcunataqa, ichiclla cayäponqantapis qochiyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y que mana imapaqpis sirweq qela sirwimaqnïta waqtata qarcuriyë paqascho cananpaq. Tsecho allapa pësacur llaquicurnin, quiruntapis uchur waqananpaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Que patsaman Diospita Shamushqa Nuna cutimorqa, shamonqa puedeq queninwanmi, llapan anjelnincunawan. Tsepitanam tronuman tecur, nunacunata jusganqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tsenam jinanatin nasionpita nunacuna nopanman ellucayanqa. Y juc mitseq üshacunata chiwacunapita raqueqnomi nunacunata raquenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Üsha caqcunatam derechu laduman acranqa; y chiwa caqcunatanam itsoq caq laduman acranqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsepitanam derechu caq laduncho quecaqcunata reyqa queno nenqa: ‘Shayämï papänïpa bendisishqan caqcuna. Chasquiyë sielucho qamcunapaq erensia alistashqa quecaqta. Tsetaqa Papänïmi que patsata camarnin, alistarqan’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‘Porqui qamcunam mallaqecaptï, micunä qarecayämarqequi; yacunëcaptïpis, yacurcatsiyämarqequim; forasteru quecaptïpis, posadecatsiyämarqequim; ");
INSERT INTO qwhNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","janapita pishipëcaptïpis, yacarcatsiyämarqequim; qeshyecaptïpis, watucarayämarqequim; carselcho llawirëcaptïpis, watucarayämarqequim’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tsenam tse allita ruraqcunaqa queno niyanqa: ‘Teyta, ¿Imetaq mallaqecaqta ricarniqui, qarayarqaq? ¿Imetan yacunashqa quecaptiqui, yaquiqui macyayarqaq? ");
INSERT INTO qwhNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O ¿Imetan forasteru puricaptiqui, posadata qoyarqaq? ¿Imetan ropannaq quecaptiqui, yacarcatsiyarqaq? ");
INSERT INTO qwhNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Imetan qeshyecaptiqui, bisitayarqaq? O ¿Imetaq carselcho llawirëcaptiqui, watucayarqaq?’ ");
INSERT INTO qwhNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tsenam reyqa queno nenqa: ‘Masqui shumaq cäyirayämë. Noqata yanapamaq cuentam que pishipaq wauqintsiccunata yanapecuyarqequi’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tsepitanam itsoq caq laduncho quecaqcunatana queno nenqa: ‘Ä, maldision qoshqacuna, nopäpita witicuyë, y ewayë diablupa wayin mana ushacaq infiernuman tsecho supëcunawan juntu rupayänequipaq, ");
INSERT INTO qwhNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","porqui qamcunaqa mallaqecaptïpis, manam qarecayämarqequitsu; yacunëcaptïpis, manam yacurcatsiyämarqequitsu; ");
INSERT INTO qwhNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","forasteru puricaptïpis, manam posadaquecatsiyämarqequitsu; ropannaq quecaptïpis, manam roparcatsiyämarqequitsu; qeshyecaptïpis y carselcho llawirëcaptïpis, manam watuquecayämarqequitsu’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tseno niptinnam pecunana queno niyanqa: ‘Teyta, ¿Imetaq mallaqecaqta, yacunëcaqta, forasteruta, ropannaq puricaqta, qeshyecaqta y carselcho llawirëcaqta qamta ricayarqaq, mana yanapayänaqpaq?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tseno niyaptinnam, reyqa queno nenqa: ‘Rasontam niyaq: Wactsa nunacunata mana yanaparninmi, noqata mana yanapamaq cuenta cayarqonqui’ ” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tseno willapäcurirnam, Jesus queno nerqan: —Mana alli ruraq nunacunam infiernuman wiñepa, wiñenin jipacoq ewayanqa; peru alli ruraq caqcunanam wiñe cawaquiman ewayanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tseno willapäcur usharirnam, disipuluncunata Jesus queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Musyayanqequinomi Pascua fiestapaq ishque junaqllana pishican. Y tsechomi Diospita Shamushqa Nunata presu tsarirnin, entregayanqa cruscho wanutsiyänanpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tse junaqcunam saserdoticunapa mandacoqnincuna y llapan autoridacuna ellucayarqan Caifaspa palasiunman. Tse Caifasqa carqan saserdoticunapa mas mandacoqnin caqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tsechomi yachatsinacuyarqan Jesusta yachellapa tsarïcur wanuratsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Peru quenomi ninacuyarqan: —Pascua fiestachoqa ama tsarishuntsu. Tsecho tsarïcushqaqa nunacunam contrantsic bullacurcuyanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tsepinmi Betania marcacho Jesus quecarqan, leprosu niyashqan Simonpa wayincho. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tse wayicho micur tëcaptinmi, chärerqan juc warmi alabastrupita botellawan allapa chaniyoq y pucutaq perfumin aptarishqa. Tse warmim Jesuspa ladunman witïcur, tse pucutaq perfumita Jesuspa peqanman jicharqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tseta riquecurnam, disipuluncunaqa piñacur queno niyarqan: —¿Imapaqraq taqe warmi tse perfumita perditsir ujuratsin? ");
INSERT INTO qwhNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tse perfumitaqa chaniyoqchomi ranticushwan carqan wactsacunata tse qellewan yanapecunapaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tseno niyanqanta musyarirnam, disipuluncunata Jesus queno nerqan: —¿Imanirtan que warmi rurashqanta piñayanqui? Tseno ruramar noqapaqqa allapa allitam rurashqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Porqui wactsacunaqa imeyaqpis qamcunawanmi quecayanqa. Peru noqaqa mananam qamcunawan cashaqnatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Que warmeqa noqaman que pucutaq perfumita jichamurninmi, alistaramashqa pampacäcunäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rasontam niyaq: Mecho tsechopis alli willaquinïta willacoqcunam que warmi ruranqantapis willacuyanqa. Tsenopam que warmi rurashqanta yarpäriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesuspa chunca ishcaq (12) disipuluncunapitam jucnin caq disipulun Judas Iscariote carqan. Pemi ewarqan saserdoticunapa mandacoqnincunaman, ");
INSERT INTO qwhNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","queno nirnin: —¿Ecatataq pagayämanqui, Jesusta entreguecuyapteq? —nir. Tse mandacoqcunanam quima chunca (30) yulaq qelleta qoriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tse örapitam Judas shuyarëcarqan ime öra carpis Jesusta entreguecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lebadurannaq tantata micuyänan fiesta qallanan junaqmi disipuluncuna Jesusman witïcur queno tapuyarqan: —¿Mechotan alistayämushaq Pascua miquita micunantsicpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tseno tapuyaptinnam, Jesus queno nerqan: —Ewayë Jerusalenman. Chärirna, juc nunata queno niyanqui: ‘Mayestrum queno nillan: “Ichicllanan oräpaq pishin. Tsemi wayiquiman shamushaq Pascua miquita disipulücunawan micurinäpaq.” ’ ");
INSERT INTO qwhNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Disipuluncunanam Jesus mandayanqannolla ewayarqan. Y alistayarqan Pascua miquita micuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Patsa paqasyäriptinnam, Jesusqa chunca ishque (12) disipuluncunawan täcuriyarqan micuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Micurëcayaptinnam, Jesus nerqan: —Rasontam niyaq: Qamcunapita jucniquim ranticamanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tseno niptinnam, disipuluncunaqa llaquinashqa ticracuriyarqan, y jucnin jucninmi tapuyarqan: —¿Teyta, noqallätsuraq callä? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsenam Jesusqa queno nerqan: —Noqawan juntu juc platullacho tantanta tullpureq caqmi chiquimaqnïcunaman ranticamanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Diospa palabran nenqan cumplinanpaqmi Diospita Shamushqa Nunaqa wanonqa; peru ¡allau, tse entregamaqnï nuna! Mas allim yuricunmanpistsu carqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsenam tse traisionaqnin Judas queno taporqan: —¿Mayestru, tsepenqa noqallatsuraq? —nir. Tseno niptinmi, Jesus nerqan: —¡Quiquiquitaq nicanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tseno micurëcayaptinnam, tantata Jesus tsarircur Diosta “Grasias” nicurerqan. Tsepitanam tantata paquirir, disipuluncunata qorqan queno nishpa: —Que tantata micuyë. Queqa noqapa cuerpümi —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsepitanam binuyoq copata tsarircur, Diosta “Grasias” nicurir, disipuluncunata qorerqan queno nishpa: “Queta llapequi uputsinacuyë. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","—Queqa noqapa yawarnïmi. Que yawarnïwanmi mushoq contratu ruracärin. Noqam yawarnïta ramarnin, wanushaq atscaq nunacunapaq. Tsenopam jutsancuna perdonashqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Y niyaqmi: Bi nuta mananam yapeqa upushaqnatsu asta Papänïpa mandaquinincho qamcunawan juntu mushoq binuta uponqantsic junaqyaq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tsepitanam juc salmu cantuta cantacurir, Olibus niyanqan jircaman eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tsechonam Jesus nerqan: —Canan paqasmi llapequicuna jaqiricayämarnï, ewacuyanqui. Tseno captinmi, Diospa palabranwan paqtarenqa queno nenqan: ‘Mitseqnintam wanuratsiyanqa y üshancunam witsicar, eucuyanqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Peru cawarircamurmi, puntequicunata Galilea marcaman ewashaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tseno niptinnam, Pedru nerqan: —Waquincuna jaqiriyäshuptiquipis, noqaqa manam jaqishqequitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tsenam Jesus nerqan: —Pedru, rasontam neq: Canan paqasmi manaraq gallu cantaptin, quima cuti negamanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedrunam yape queno nerqan: —Qamtawan juntu wanutsiyämänan captinpis, manam negashqequitsu —nir. Y llapan disipuluncunapis tse shimillam cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsepitanam Getsemani nishqan wertaman disipuluncunawan ewayarqan. Tsechonam pecunata queno nerqan: —Diosman mas washallacho mañacamunqäyaq, qamcunaqa quellacho täcurëcayë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nirirmi, pusharqan Pedruta y Zebedeupa ishcan tsurincunata. Tsechomi Jesus shonquncho nanatsicur allapa llaquishqa ticracurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tsemi queno nerqan: —¡Llaquiquiwanmi shonqü imanaquicunchi! Quellacho riyaq riyaqlla quecayë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tseno nirirnam, mas washanincunaman witirir, urcunpis patsaman chanqanyaq puctïcur queno nishpa mañacorqan: —Dios Yayallä, qam munarnenqa que jipar nacanäpaq quecaqcunapita salbecamë; peru noqa munashqänoqa ama callätsuntsu, sinoqa qam munashqequino quecullätsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsepitanam cutirerqan disipuluncuna caqman, y tarirerqan punuquicayaqtam. Tsenam Pedruta nerqan: —¿Ä punï, ä punï, manacu juc örallapis pununeta awantariyanquiman! ");
INSERT INTO qwhNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Canan riyacur Diosman mañacuyë, diablu tenteta munayäshuptiqui, jutsaman mana ishquiyänequipaq. Boluntaniquicuna alli captinpis, sasam rurarcuyänequipaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tseno nirirnam, yape cutïcur Dios Yayaman queno mañacorqan: —Papällä, que jipar nacanäpaq quecaqcunapita, salbecamë. Peru ama noqa munashqänoqa catsuntsu; qam munashqequino quecullätsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Disipuluncuna caqman cutirirnam, pecunata yape tarerqan punuquicayaqta; punï allapa bensiyaptinmi, punuquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsenam mana imapis nishpa cuticorqan yape Diosman mañacoq. Tse ewanqanwanqa quima cutinam mañacoq ewarqan, y puntata mañaconqannollam jina mañacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsepitanam disipuluncunaman cutirir pecunata queno nerqan: —¿Jinallacu punuquicayanqui? Örä chäramushqanam jutsasapa nunacunaman Diospita Shamushqa Nunata entregayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sharcuyë. Acuna, eucushun. Traisionämaqnïqa yecarëcamunnam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus manaraq parlar ushaptinmi, chunca ishque (12) apostolnincunapita Judas caq apostolnin atscaq nunancuna pusharishqa chärerqan. Tse nunacunaqa ewayarqan espadancunawanmi y garutincunawanmi. Pecunataqa cachayarqan saserdoticunapa mandacoqnincunam, y autoridacunam. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Traisionero Judasqa nunacunata quenomi yachatsishqa carqan, “Noqa saludar mutsanqä caqmi canqa. Peta ras tsariyanqui presu” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y nishqannollam Judasqa shumaqlla Jesusman witïcur “¿Yamellacu? Mayestru” nishpa, mutsecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tsenam Jesus nerqan: —Amigu, ruranequipaq caqta jucllana rurë —nir. Tsellanam Judas pushanqan nunacuna coripäcur Jesusta presu tsarircur apacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tse öram Jesuswan quecaq jucnin caq disipulun espadanta jorquricurnin, mas mandacoq saserdotipa sirweqninpa rinrinta wallicorqan pintireqpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsenam Jesus queno nerqan: —Cutitsï espadequita wardananman; porqui pipis espadawan maqacoqqa, jina espadallawanmi wanonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Noqa munarqa, canan öram Dios Yayäta mañacurïman waranqa (1,000) waranqata anjelcunata washämänanpaq cachamunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tseno washäyämaptenqa, ¿Imanoparaq cumplicanman Diospa palabrancho wanunäpaq escribirëcanqan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tsepitanam tse presuyänanpaq ewashqa nunacunata Jesus queno taporqan: —¿Imanirtaq suwa captïno espadequicunawan y shucshiquicunawan tsariyämänequipaq shayämorqonqui! Waran waranmi qamcunawan carqö templucho yachatsicur. Tsechoqa ¿imanirtaq presuyämarqequitsu! ");
INSERT INTO qwhNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Peru que llapancuna pasaquican profetacuna Diospa palabrancho escribiyashqannomi —nir. Tse öram Jesusta japallanta jaqirïcurnin, llapan disipuluncuna qeshpir eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tsepitanam Jesusta presu apaqcuna chäratsiyarqan Caifaspa wayinman. Tse Caifasqa carqan saserdoticunapa mas mandacoqninmi. Tsechomi ley yachatsicoqcuna y llapan autoridacuna juntacashqa quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrunam caru qepancunallata qaterqan mas mandacoq saserdotipa patiunyaq. Tsechonam templupa wardiancunawan juntu täcurerqan, “Mä, imatash rurayanqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Saserdoticunapa mandacoqnincunam Sanhedrin nishqan corticho llapan autoridacunawan uli testigucunata ashiyarqan Jesusta mana caqpita shimpiyänanpaq, tsenopa peta wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Peru atscaq nunacuna ulicurcur contran acusecayaptinpis, manam ima jutsantapis tariyarqantsu wanutsiyänanpaq. Tsepitanam yurircuyarqan ishcaq ulicurcur acusaqnincuna. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Pecunam queno niyarqan: —Que nunam queno nishqa: ‘Diospa templunta juchurirmi, quima junaqllata sharcaratsishaq’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tseno acusayaptinnam, mas mandacoq saserdoteqa sharcur Jesusta queno taporqan: —¿Manacu imallatapis parlacurinqui, contrequi parlar acusecayäshuptiqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tseno niyaptinpis, Jesusqa upällallam cacorqan. Tsenam tse mas mandacoq saserdoteqa queno nerqan: —Cawecaq Diospa jutinchomi neq: Rasonpa caqta willayämë. ¿Qamcu canqui Diospa Acrashqan tsurin? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tsenam Jesus nerqan: —Qam nenqequinomi cä. Y niyaqmi: ime junaq carpis, Diospita Shamushqa Nunata ricariyanqui puedeq Diospa derechu laduncho tëcaqtam, y pucute rurincho sielupita shamicaqtam. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesus tseno nïcuptinnam, tse mas mandacoq saserdoteqa allapa piñar, sotanantapis rachiricorqan, y quenomi nerqan: —¡Que nunaqa tseno parlar Teyta Diosnintsictam ofendican! ¿Imapaqnataq mas testigucunatapis munantsic! Wiyayarqonquim Diospa contran parlanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Cananqa qamcuna ¿Imataq pepaq niyanqui? —nir Tsenam llapancuna queno niyarqan: —¡Wanuratsishun! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsenam qaqllacho toqapurnin y cutarnin, qallaquicuyarqan. Waquincunanam qaqllan qaqllan laqyayarqan, ");
INSERT INTO qwhNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","queno nishpa: —¿Rasonpa Dios Acrashqan carnenqa? Mä, adibinë, ¿pi laqyashonqequitapis? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jesusta tseno burlaquicayaptinnam, Pedroqa jaq patiucho tëcarqan. Tsenam tse wayicho empliadaqa Pedruman witïcur, queno nerqan: —Qampis taqe Galilea marcapita Jesuswan pureqmi canqui, ¿au? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peru Pedrunam negarnin, llapancuna nopancho queno nerqan: —Pipaqraq parlacunqui, manam reqïtsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsenam Pedroqa puncumanpana eucorqan. Tsecho quecaqta riquecurnam, jina jucna tsecho quecaqcunata queno nerqan: —Que nunapis Nazaret marcapita Jesuswanmi purishqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peru penam yape negarnin jurar queno nerqan: —¡Tse nunata manam reqïtsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tsepita mas ratutanam tsecho quecaq nunacuna queno niyarqan: —Qamqa rasonpam pewan purishqanqui. Parlaquiniquillachomi reqiriyaq pepa qatiraqnin canqequita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsenam Pedroqa allapa pësacur jurarnin queno nerqan: —¡Manam ari tse nunata reqïtsu! —nir. Tseno nicaptinllanam, gallu cantarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tseta wiyecurnam Pedroqa yarpäcurcorqan, “Manaraq gallu cantaptinmi, quima cuti negamanqui” nishpa, Jesus nenqanta. Tsenam tsepita yarqurïcur allapa pësacur, allapa llaquicur, waqaquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Patsa waräriptinnam, saserdoticunapa mandacoqnincuna y israel nunacunapa autoridanincuna acuerduta rurar, parlariyarqan imanopapis Jesusta wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tseno parlarirnam, maquinta pancarcur gobernador Pilatuman apar entregariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tsepitanam traisioneru Judasqa Jesusta wanutsiyänanpaq condenariyanqanta musyarerqan. Tsenam shonquncho allapa llaquicur tse quima chunca qelle qoyanqanta, saserdoticunapa mandacoqnincunata y autoridanincunata queno nishpa cutïcatserqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Mana jutsayoq nunata wanutsiyänequipaq entregayarniqui, allapa llutatam rurecorqö —nir. Tseno niptinnam, pecuna queno niyarqan: —¿Imataq qocayäman! ¡Qamna imanopis caquï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tseno nïcuyaptinnam, Judasqa templu ruriman qelleta wicapecur, yarqur eucorqan. Tsepitanam quiquin jurcacurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsenam saserdoticunapa mandacoqnincunaqa tse qelleta ellurir, queno niyarqan: —Yawarpa chanin canqanrecurmi leynintsic permitintsu que qelleta cajaman cutitsinantsicpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tseno nirirnam, tse qellewan manca ruraqcuna shashalnincuna jorqucuyänan chacrata rantiriyarqan. Tsemanmi forasterucunata wanuyaptin pampayaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tsemi canancamayaqpis tse chacrapa jutin Yawarpa Chanin Chacra. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tseno rurayaptinmi, tincurerqan profeta Jeremias escribishqanwan. Tse escribishqanchoqa quenomi nican: “Pepa presiun eca cananpaqpis israel nunacuna sitayanqannomi quima chunca (30) qelleta pagayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y tse qellewanmi rantiyanqa manca ruraqcuna shashalta jorqucuyänan chacrata, quiquin Teyta Dios nenqannolla” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gobernador Pilatumanmi Jesusta apayarqan. Penam queno taporqan: —¿Qamcu canqui israel nunacunapa reynin? —nir. Jesusnam yasquirerqan: —¡Nicanquinataq ari! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Saserdoticunapa mandacoqnincuna y israel nunacunapa autoridanincuna acusayaptinpis, Jesusqa manam ni imata nerqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tsenam Pilatu queno taporqan: —¿Imanirtaq upälla wiyaräcunqui quelaya contrequi parlecayaptin! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Peru tseno niptinpis, Jesusqa manam ni juc shimillapis yasquerqantsu. Tsenam gobernador Pilatoqa espantashqa quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cada watam Pascua fiestacho Pilatu nunacuna mañacuyanqan caq presuta cachareq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsepinmi Barrabas jutiyoq nuna llawirëcarqan. Tse presoqa allapa reqishqam carqan llapan nunacunapita. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsemi juc presuta cacharinan captin, tsecho juntacashqa quecaq nunacunata Pilatu queno taporqan: —¿Meqan presuta libri cacharinätataq munayanqui, Barrabastacu o Dios Acrashqan niyanqan Jesustacu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tsenoqa taporqan Jesusta chiquirnin, acusar peman entregayanqanta cuentata qocurninmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jesusta jusgar Pilatu tëcaptinnam, warmin queno willacaratserqan: —Manash meticunquitsu tse jutsannaq nunawan. Porqui canan waraq sueñininchoshi allapa mana allicunata sueñuquicushqa pepaq yarparar —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Peru saserdoticunapa mandacoqnincunanam y autoridacunanam tsecho quecaq nunacunata combensiratsiyarqan, “Barrabasta libri cacharïquï, y Jesustana wanuratsï” niyänanpaq ");
INSERT INTO qwhNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsenam gobernador Pilatoqa queno nishpa tapucorqan: —Que ishcan presupita, ¿meqan caqtataq cacharinäta munayanqui? —nir. Nunacunanam “¡Barrabasta! ¡Barrabasta!” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsenam Pilatu queno nerqan: —Tsepenqa ‘Dios Acrashqan niyanqan Jesustaqa, ¿Imatatan rurashaq?’ nir. Tsenam llapan nunacuna niyarqan: —¡Cruscho wanutsun! ¡Cruscho wanutsun! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tseno niyaptinnam, Pilatu queno nerqan: —¿Ima mana allitataq rurashqa? —nir. Peru nunacunanam “¡Cruscho wanutsun!” nishpa, qaparicachäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nunacuna tseno masraq qaparicurcuyaptinnam, Pilatu imanopis queta puederqantsu. Tsenam yacuta aparatsimur, maquinta paqacurerqan llapan nunacunapa nopancho, queno nishpa: “Noqa manam jutsayoqtsu cashaq que nunapa wanininpita. ¡Mä, qamcunana imanopis cacuyë!” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tseno niptinnam, tse nunacuna queno contistayarqan: —Noqacunam y wamräcunam culpayoq tse wanininpita cacuyäshaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tsenam Pilatoqa Barrabasta libri cacharerqan. Jesustanam alli buenu astaratsirnin, entregarerqan crusificayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsepitanam Pilatupa soldaduncunaqa Jesusta jeqaratsiyarqan tse palasiupa Pretorio nishqan sitiuman. Tsechonam llapan soldaducuna Jesusta jiruroq chopiriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Y ropanta qoturatsirnam, puca mantuta aqshuratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Peqanmannam yacatsiyarqan cashapita awashqa coronata, y derechu caq maquinmannam aptatsiyarqan juc shucshuta. Tsepitanam Jesuspa nopanman qonqurïcur burlacurnin, queno niyarqan: —¡Biba israel nunacunapa reynin! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nïcurnam, toqapur ushayarqan, y tse aptatsiyanqan shucshuwan peqan peqan wilur ushayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tseno allapa maltratarirnam, aqshutsiyanqan puca mantuta qoturatsir quiquinpa ropantana yacarcatsir, apayarqan crusificayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Crusman clabayänanpaq yarqurëcarnam, toparcayämorqan Simon jutiyoq nunawan. Pëqa carqan Cirene marcapitam. Tse nunatam Jesus apecanqan crusta malas catätsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tsenomi Golgota niyashqan sitiuman chäriyarqan (Golgotaqa “calabera” ninanmi). ");
INSERT INTO qwhNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tsechomi puchqoq binagrita asqaq qorantin tacurcur qoyarqan upunanpaq; peru Jesusqa llamirirnin, manam upita munarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Crusificarirnam soldaducuna Jesuspa ropanta apacuyänanpaq sortiyayarqan. ˻Tseno rurayaptinmi, cumplicärerqan profeta queno nenqancuna, “Ropäcunatam raquinacuyanqa, y ropäcunatapis sortiyäyanqam” nenqancuna.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nïcurmi, tsecho tecur Jesusta täparäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Imanir crusificayanqanta nunacuna musyayänanpaqmi, cruspa puntanman juc letreruta churayarqan, “Quemi israel nunacunapa reynin Jesus” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Petawan juntum jina ishcaq suwacunatapis crusificayarqan, jucta derechu ladunman, jucnintana itsoq ladunman. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tsepa pasaq nunacunanam peqancunata awir cushipäyarqan, ");
INSERT INTO qwhNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","queno nishpa: —¡Qamqa, ‘Diospa templunta juchurirmi, quima junaqllata sharcatsishaq’ nishpataq, nerqequi! ¡Diospa tsurin carqa, mä, salbacurirnin cruspita yarparamï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tsenollam jina saserdoticunapa mandacoqnincunapis, ley yachatsicoqcunapis y tse marcacho autoridacunapis burlacurnin, queno niyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Juccunataqa salbashqam; peru quiquenqa salbaquita ¡manataq puedintsu! Israel nunacunapa rasonpa reynin carnenqa, mä, canan cruspita yarpamutsun peman creyinantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¡Diosmantaq allapa marcäcorqon! ¡Mä, canan ari Dios salbecutsun rasonpa cuyarnenqa! ‘¡Diospa Tsurinmi cä’ nimarqantsictaq! ");
INSERT INTO qwhNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y laduncho crusificarëcaq suwacunapis tsenollam burlacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pullan junaqpita asta lastrescamayaqmi patsa pasepa paqasyäcurcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tse öram Jesus fuertipa queno nir qayarïcorqan: —Eloi, Eloi ¿lema sabactani? (Tse ninanqa carqan “Dios, Dios, ¿imanirtaq noqata jaqirïcamarqonqui?” ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tseta wiyarnam, tsecho quecaq waquin nunacuna queno niyarqan: —Une profeta Eliastam qayecan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tse öram jucnin soldadu coripa ewecur, esponjata puchqoq binuman tullpurcur, shoqushpa puntanman watarcur, Jesuspa shiminman churarqan shoqunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Peru waquincunanam queno niyarqan: —Ama imatapis rurayëtsu. ¿Mä, rasonpacush Elias shamonqa salbananpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tsellanam fuertipa yape qayaricur, Jesus wanurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tse öram templu rurincho tsaparaq cortina umapita urepa ishqueman qashqacärerqan. Patsanam feyupa cuyucurerqan. Qaqacunapis limpum qatsacäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sepulturacunacho ayacuna pamparäyanqanpis quichacäyarqanmi, y Diosman marcäquicar wanucushqacunapis atscaqmi cawariyämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pecunam pamparäyanqanpita yarqayämorqan, y Jesus cawariramuptinnam, yecuriyarqan santu Jerusalen marcaman. Tsechomi tse cawarimushqacunata atscaq nunacuna ricayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesusta täpecaq capitanpis y soldaduncunapis patsa cuyonqanta mäquicurmi, y llapan pasaconqanta riquecurmi, allapa mantsacäcur, “¡Que nunaqa rasonpa Diospa Tsurinmi cashqa!” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tsechomi carullapita ricarëcayarqan atscaq warmicuna. Tse warmicunam Galileapita patsa shayämushqa cayarqan Jesusta yanapar. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pecunam cayarqan Maria Magdalena, Santiagupa y Josepa maman Maria y Zebedeupa tsurincunapa mamanpis. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Patsa paqasyärëcaptinnam, Jose jutiyoq juc ricu nuna chärerqan. Pëqa carqan Arimatea marcapitam. Pepis Jesuspa qatiraqninmi canaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tse Josemi Pilatuman ewar, Jesuspa ayanta mañarqan pampecunanpaq. Pilatunam soldaduncunata mandarerqan entreguecuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Entregariyaptinnam, Joseqa linupita rurashqa limpiu sabanaswan piturcur apacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tsepitam qaqacho uchcushqa mushoq sepulturaman churecorqan. Tse uchcutaqa quiquin pampacäcunanpaqmi Jose uchcucushqa carqan. Tsepitanam juc jatun qaqawan tse uchcuta laticur, eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Peru Maria Magdalenawan jucnin caq Mariaqa manam eucuyarqantsu, sinoqa tse sepulturapa frentincho unchurëcarmi, quedacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Waränin sabadu junaqnam saserdoticunapa mandacoqnincuna y fariseucuna Pilatuman ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pecunam Pilatuta queno niyarqan: —Wiraqtsa, noqacuna yarpäyämi, tse ulicurcur parlaq nuna cawecarnin ‘Wanonqäpitam quima junaqllata cawarimushaq’ nenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsemi mañacuyaq quima junaq cumplenqanyaq pamparanqanta täpecatsillänequipaq. ¡Paqtataq disipuluncuna paqaspa ewecur ayanta suwacurcuyanman, y nunacunata ulicurcur creyitsiyanman ‘cawarimushqam’ nir! Tseno quecuptenqa, punta ulicuyanqanpitapis mas peormi qepa ulicuyanqan ticracurenqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatunam queno nerqan: —Tsechomi soldaducuna quecayan. Ewayätsun y alli buenu segurecur täpayätsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tseno niyaptinnam, pamparanqanman ewar, sepultura tsaparaq qaqata alli cösa taqrecatsiyarqan. Y soldaducunatam churayarqan mana jaqirita tapayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jamaqui junaq pasariptinnam, dominguman waraqna qoya qoyalla Maria Magdalena y juc caq Maria ewayarqan Jesus pamparanqanman. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsecho quecayaptinnam, allapa feyupa patsa cuyucurerqan. Tsenoqa cuyucurerqan, Dios cachamonqan anjel sielupita urämuptinmi. Anjelnam sepultura tsaparaq qaqata wititsir tse qaqa jananman täcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tse anjelqa imeca relampagupa actsinnoran tillapyäcorqan. Ropannäqa imeca rajunoran yulaqäcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tseta riquecurnam, soldaducunaqa mantsaquewan limpu carcaryäriyarqan, y wanushqano jitacäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anjelnam warmicunata queno nerqan: —Ama mantsacäyëtsu. Noqa musyämi cruscho wanutsiyanqan Jesusta ashicayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pëqa mananam quechonatsu. Quiquin nenqannollam cawarimushqa. Masqui shayämï, ricayë pamparanqantapis. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jinallacho ewayë disipuluncunaman y queno niyë: ‘Jesusqa cawarimushqanash. Qamcunapitapis mas puntatash ewan Galilea marcata. Tsechoshi ricayanqui’ —nir. Tseno nirirnam, tse anjel queno nerqa: —Tsellatam willariyaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tsenam warmicunaqa mantsaquecuyarqan. Peru imano captinpis, allapa cushishqam sepulturapita corillapa ewacuyarqan disipuluncunaman tse notisiata willacoq. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tseno ewarëcayaptinnam, Jesusqa pecunaman juclla yurircur, “Cushicuyë” nishpa, saludacurerqan. Warmicunanam Jesusman witïcur adorar chaquipita waqucurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesusnam queno nerqan: —Ama mantsacäyëtsu. Canan ewar wauqicunata, willayë Galilea marcaman ewayänanpaq; tsechomi ricayämanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tse warmicuna willacoq ewayanqanyaqnam, täpacoq waquin soldaducuna ewayarqan Jerusalen marcaman saserdoticunapa mandacoqnincunata, llapan pasacushqancunata willayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsenam tse mandacoqcunaqa ewayarqan tse marcacho autoridacunawan parlaq, y acuerdutam rurayarqan imano cayänanpaqpis. Cösa parlarirnam, soldaducunata queno nishpa atsca qelleta yacapuriyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Pitapis metapis willayanqui paqaspa punucäriyanqäyaqmi disipuluncuna shamicur Jesuspa ayanta suwapicayämashqa —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","—Tseno ulicuyashqequita musyecur imatapis Pilatu rurayäshiniquita munaptenqa, ama imapis qocuyäshunquitsu, porqui noqacunam pewan parlayäshaq, qamcunata mana imanayäshunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tseno niyaptinnam, soldaducunaqa tse qelleta cösa chasquïcurcushqa carnin, yachatsiyanqannolla rurayarqan. Tseno cashqantam canancamayaqpis jinantincho israel nunacunaqa willanacuyan. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesuspa chunca juc (11) disipuluncunaqa Galilea marcamanmi eucuyarqan Jesus nishqanno tse jircacho tincuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tsechonam Jesusta riquecurnin, adorecuyarqan; peru waquincaqcunaqa “¿Jesustsuraq canman?” niyarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tsenam quecayanqanman witïcur, queno nerqan: —Diosmi churamashqa, sieluchopis y que patsachopis mandacunäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsemi qamcunata cachayaq jinantin nasioncunapa ewar, noqaman creyicuyänanpaq nunacunata willapäyänequipaq, y creyicoq caqtana bautisayanqui Dios Yayapa, Tsurin Jesucristupa y Santu Espiritupa jutincho. ");
INSERT INTO qwhNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y qamcunata llapan yachatsiyashqaqcunata yachatsiyanqui pecunapis alli cäsucoq cayänanpaq. Noqaqa qamcunawanmi quecashaq imecamayaqpis, asta que patsapa usheninyaq. Tseno catsun.");
INSERT INTO qwhNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quenomi qallarin Diospa tsurin Jesucristupa alli willaquinin: ");
INSERT INTO qwhNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Diospa profetan Isaias escribishqanchomi ˻Dios˼ queno nerqan: “Puntequitam willacoqnïta cachashaq, nänita alistaq cuenta nunacunata willapänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tsunyaqchomi juc nuna qayaripa queno willaconqa: ‘Nänicunata derechar limpiaq cuenta prebinicuyë Teyta Diosnintsicta chasquiyänequipaq’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tse nenqannomi bautisacoq Juan tsunyaqnincunapa ewar nunacunata willaparqan jutsancunata jaqirir, bautisacuyänanpaq, y tsenopa perdonashqa cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsenam Jerusalenpita jinantin Judea probinsiapita Juanman llapan nunacuna ewayarqan. Jutsancunata willayaptinnam Jordan mayucho Juan bautisarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanpa ropanqa carqan camellupa millwanpitam. Wachäcannam qarapita carqan. Micoqpis langosta curucunatam y tuna tumpushpa mishquincunatam. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pemi nunacunata willarqan queno nir: —Qepätam shamun noqapitapis mas puedeq, y manam noqa ni pi carpis sirwïtsu qonqurïcur llanqinpa watunta pascarillatapis. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Noqaqa yacullawanmi bautisayarcoq, peru pëqa bautisayäshoqniqui cuentam Santu Espiritunta qoycuyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tse junaqcunanam Galileacho Nazaret marcapita Teyta Jesus shamorqan Juan bautisecanqan Jordan mayuman, y petapis tsechomi bautisarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus bautisacurir, yacupita yarqurëcarnam, riquecorqan sielu quicharëcaqta y Santu Espiritu palumano peman urecamoqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sielupeqnam Dios queno nimorqan: —Qammi cuyë tsurï canqui. Qamrecurmi allapa cushicü. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsepitanam Santu Espiritu Jesusta tsunyaqman pushacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tsechonam chuscu chunca (40) junaqninpi chucaru animalcunawan juntu päracorqan. Tsechomi diablu engañar tuquilayapa Jesusta jutsaman ishquitsita munarqan. Y anjelcunanam shamur Jesusta sirwiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bautisacoq Juan carselcho llawirëcaptinnam, Galilea marcacunaman ewar Diospa alli willaquininta Jesus yachatsicorqan ");
INSERT INTO qwhNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","queno nirnin: —Dios mandacoqniquicuna cananpaq tiempu chäramunnam. Tsemi mana alli rureniquicunata jaqirïcur, alli willaquininman creyicuyë. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesusmi Galilea nishqan Lamar cuchunpa ewarëcarnin, ricarerqan Simonta y wauqin Andresta. Pecunam pescador carnin, atarayancunata yacuman jitecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pecunatam Jesus queno nerqan: —Shayämï. Noqata qatiyämë. Cananpita witsepam pescaduta elluyanqequipa rantin nunacunatana noqaman elluyämunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tse öram atarayancunata jaqiricur, Jesusta qatircur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsepita pasarirnam, mas washänincho Jesus ricarerqan Santiaguta y Juanta lanchacho atarayancunata remendecayaqta. Pecunaqa cayarqan Zebedeupa tsurincunam. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsenam ishcan wauqita Jesus qayarqan. Pecunapis jina papänin Zebedeuta uryaqnincunatawan lanchacho jaqirïcurmi, Jesuspa qepanta eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tsepitanam Capernaum marcaman chäriyarqan. Tsechonam jamacuyänan junaq ellucayänan wayiman yecurir nunacunata Jesus yachatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Llapan nunacuna allapa espantacur mantsacäcuyarqan tse yachatsiquininpita, porqui puedeq queninwanmi tsecunata yachatsicorqan y manam ley yachatsicoqcunanollatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tse ellucayänan wayichomi quecarqan supëpa munenincho cacoq nuna. Tse öram nunapa shiminpa qayaripa supë ");
INSERT INTO qwhNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","queno nerqan: —Au, Jesus Nazaret marcapeq nuna ¿Imananquitaq noqacunawan? ¿Ushacätsiyämaqnïcu shamorqonqui? ¡Noqa reqeqmi, qam Dios Acrashqan canqequita! ");
INSERT INTO qwhNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusnam supëyoq nunata piñaparnin, nerqan: —¡Upälla que! ¡Canan que nunapita yarqï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Supënam nunata feyupa tapsicacharcur, qaparir yarqur eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tseta riquecurnam, llapan nunacuna mantsacäcur queno tapunacuyarqan: —¿Imanotaq que? Queno mushoq yachatsiquitaqa manam imepis wiyashqatsu cantsic. ¡Supëcunapis poderninwan mandaptintaq cäsuyan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tse junaqcunam jinantin Galilea probinsiacho Jesus rurashqanta llapan nunacuna ras musyariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tse ellucayänan wayipita yarqurirnam, Jesus ewarqan Simonpa y Andrespa wayinman, Juanta y Santiaguta pusharcur ");
INSERT INTO qwhNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tsechomi Simonpa suegran fiebriwan qeshyar cämarëcarqan. Jesus chäriptin öram willariyarqan tse warmi qeshyecanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tsenam Jesus witïcur maquinpita tsarircur sharcaratserqan. Tse öram fiebripita cachacärirnin, pecunata sirwerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Inti jeqecaptinnam, Jesusman apayämorqan tuquilaya qeshyawan qeshyaqcunata y supëyoqcunata. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tse marcapitam llapan nunacuna tse wayi puncuman elluquecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Atscaqtam tuquilaya qeshyawan qeshyaqcunata Jesus cachacätserqan, y supëpa munenincho caquicaq atscaq nunacunatam librarqan. Supëcunaqa reqiyarqanmi pi canqanta. Tsemi Jesus munarqantsu pepaq ni imata parlayänanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tsaqa tsaqalla shäricurirmi, tsunyaqman Jesus eucorqan Diosman mañacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simonnam yanaqincunawan Jesus asheq ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Taririrnam, queno niyarqan: —Tëte, llapan nunacunam ashicayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsenam Jesus nerqan: —Acu ewashun waquin caq amanulla marcacunamanraq. Tsecunachopis yachatsicushaqmi. Tsepaqmi que patsaman shamushqa cä. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsenam jinantin Galilea marcacunapa purir, ellucayänan wayicunacho yachatsicorqan, y supëpa munenincho caquicaq nunacunatam librarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tsechonam leprawan qeshyayoq nuna Jesusta rogarnin, qonquriquicur queno nerqan: —Tëte, munarnenqa, cachaquecatsillämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsenam Jesus ancuparnin, nunata yatecur queno nerqan: —Munämi, cachacänequita. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tse öram lepra qeshyapita cachacärir, sanu püru ticrarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tsenam Jesusqa tse nunata alli notificarnin, queno despidicorqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ama ni pitapis willacunquitsu cachacätsenqaqta. Peru si, ewë saserdoti bendisishunequipaq, Moises mandacushqanno Diospaq qarenin aparcur pecuna musyayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Peru tseno notifiquecaptinpis, tse nunaqa eucur llapan nunacunatam willar ushecorqan Jesus cachacätsishqanta. Tsemi tse marcacunaman Jesus manana yecorqantsu, y tsunyaqnin tsunyaqninllanam puricorqan. Peru tsemanpis jinantinpitam nunacuna ashirnin, ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsepita unetanam yape Capernaum marcaman Jesus cutiriptin nunacuna musyariyarqan cutirishqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tsenam quecanqan wayiman allapa nunacuna ellucar wayi junta puncuchopis quichqui cayarqan. Jesusnam yachatsiquicarqan Diospa willaquininta. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsemannam chuscoq nunacuna apayarqan juc imbaliduta wantucushqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nunacuna pasepa quichquishqa cayaptinmi, Jesuspa nopanman yecatsita puediyarqantsu. Tsemi wayi qataraqta quicharïcur tselläpa qeshyaq nunata quirmantin shumaqlla cacharpuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tsenam Jesusqa peman allapa marcäcuyashqanta musyarirnin, qeshyaqta nerqan: —Iju, jutsequicunapitam perdonecoq. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tsechonam tëcayarqan ley yachatsicoqcuna. Y waquincunam shonquncunacho queno yarpacachäyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Que nunaqa ¿imanirraq tseno parlan! Tseno parlarninmi, Diospita burlacun. Diosllam jutsantsicpitaqa perdonamantsic” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Peru Jesusqa tseno yarpacachäyanqanta musyarirmi, pecunata queno taporqan: —¿Imanirtaq shonqiquicunacho tseno yarpacachäyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Que qeshyaq nunapaq meqantaq mas alli ninäpaq canman: ‘Jutsequicunapita perdonashqanam canqui’ ninäcu, o ‘Sharquï, quirmequita aparcur euquï’ nïcümancu! ");
INSERT INTO qwhNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cananmi musyatsiyashqequi Diospita Shamushqa Nuna, puedeq car que patsacho nunacunapa jutsancunata perdoneta puedenqanta. Tseno nirirnam, imbalidu nunatana nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Qamtam neq: Sharcur quirmequita aparcur wayiquita euquï. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tse öram qeshyaq sharcur llapan ricarëcayaptin quirmanta ellurir catarcur eucorqan. Tseta ricarninnam, nunacuna cushicur queno alabayarqan: —¡Diosqa allapa puedeqmi! ¡Manam ni imepis que rurashqantanoqa ricashqatsu cantsic! ");
INSERT INTO qwhNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsepitanam yape lamar cuchunpa Jesus ewarëcarqan. Tseman atsca nunacuna ellucayaptinnam, pecunata yachatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pasarëcarnam ricarerqan Alfeupa tsurin Levita Romapaq impuestucunata cobracuyänan wayicho cobracur tëcaqta. Petam Jesus nerqan: —¡Acu eucushun! —nir. Levinam sharcur Jesuswan eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsepitanam Levipa wayincho Jesus disipuluncunawan miquicayaptin Romapaq impuestuta cobracoqcunapis y jutsasapacunapis Jesuswan juntu miquicayarqan, y atscaqmi tseno nunacuna peta qatiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jutsasapacunawan y impuestu cobraqcunawan micoqta riquecurnam, ley yachatsicoq fariseucuna Jesuspa disipuluncunata queno niyarqan: —¿Imanirtaq mayestriquicuna impuestu cobracoqcunawan y jutsasapacunawan juntacur micuyan! ");
INSERT INTO qwhNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesusnam tse niyanqanta wiyarirnin, nerqan: —Qeshyaqcunallam medicutaqa nesitayan; sanu caqcunaqa manam. Tseno caqmi noqaqa que patsaman shamushqa cä alli ruraq nunacunamantsu, sinoqa jutsasapacunamanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutinam bautisacoq Juanpa disipuluncuna y fariseucunapapis ayunucho quecayarqan. Nunacunanam Jesusman ewarnin, queno tapuyarqan: —Juanpa y fariseucunapa disipuluncunaqa ayunecayanmi, y qampa disipuliquicunaqa ¿imanirtaq ayunayantsu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesusnam iwalatsiquipa queno nerqan: —Acasu casamientuman combidashqacuna nobiuwan juntu quecar, ¿ayunayancu! ¡Manam! Pewan quecayanqanyaq ayunayantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Peru chämonqanam nobiuta apacuyänan junaq. Tsenam si, ayunayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Manam pipis macwa ropata remendanmantsu mushoq telawan, porqui tse mushoq telaqa qenticarmi macwa ropata mas rachirenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsenollam jina pipis macwa qara bolsachoqa llullullaraq binuta poqutsinmantsu. Tseno ruraptenqa, binu poqurmi, tse bolsata pashtaratsinman, y binupis bolsapis ushacärinmanmi. Antis, llullullaraq binutaqa mushoq bolsamanmi winanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jucpinnam jamacuyänan junaqcho disipuluncunawan Jesus ewecayarqan trigu murushqacuna cuchunpa. Disipuluncunanam espigata quipchurir uchuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsenam fariseucuna Jesusta queno niyarqan: —Riquë, ¿Imanirtaq jamaqui junaq leynintsicpa contran tseno rurayan? ");
INSERT INTO qwhNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tsenam Jesusqa nerqan: —Qamcuna ¿manacu Diospa palabranta leyishqa cayanqui, rey David yanaqincunawan mana mircapancuna captin mallaqar, rurayanqanta! ");
INSERT INTO qwhNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pemi Abiatar jutiyoq mas mandacoq caq saserdotipa tiempuncho Dios adorana wayiman yecurirnin, saserdoticunalla micuyänan Diospaq churashqa tantata yanaqincunawan micucurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tsepitanam Jesus queno nerqan: —Diosqa jamaqui junaqta churashqa nunacunapa bienninmi, y manam nunapa malnintsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tsemi Diospita Shamushqa Nunapa munenincho jamaqui junaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tsepeqnam ellucayänan wayiman Jesus yape yecorqan. Tsechomi tsaquishqa maquiyoq juc nuna quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tsenam tsecho quecaqcuna Jesusta acuseta munarnin, qawarëcayarqan. —Mä, ¿canan jamaqui junaqcho que nunata cachacätsenqacush? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsenam maquin tsaquishqa nunata Jesus queno nerqan: —Sharcur que chopiman shämï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tse qawaraqcunatanam Jesus queno taporqan: —¿Imanotaq leynintsic mandacun! ¿Jamaqui junaqcho allita rurashwancu o manacu! ¿Nunacunata salbecushwancu o wanuratsishwancu! Pecunanam upällalla cacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tsenam pecuna mana ancupäcoq cayanqanta cuentata qocurir, Jesus piñacur allapa llaquicorqan. Y nunatanam queno nerqan: —Maquiquita pallarï. Tsenam maquinta nuna pallarcuptin cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsenam ellucayänan wayipita yarqurirna, tse fariseucunaqa rey Herodispa qatiraqnincunawan yachatsinacur parlayarqan Jesusta imanopapis wanicatsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tsepita yarqurirnam, Jesusqa disipuluncunawan lamar cuchunman eucuyarqan. Tsemannam Galileapita, ");
INSERT INTO qwhNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judeapita, Jerusalenpita, Idumeapita, Jordan mayupa wac tsimpanpita, Tiropita y Sidonpita allapa atscaq nunacuna qatiyarqan. Y atsca milagrucunata ruranqanta wiyashqa carninmi, llutepa nunacuna peman ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsemi disipuluncunata Jesus nerqan juc lanchata listu quecatsiyänanpaq, tse atsca nunacunam mana quichquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Atscaq qeshyaqcunata cachacätsishqa captinmi, Jesusta yateta munarnin, tse qeshyaqcuna quichquinacur cumanacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Supëyoqcunapis Jesusta riquecurmi, pepa nopanman queno niräcur, qonquripa ishquiyarqan: —Qamqa Diospa tsurinmi canqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesusnam supëcunata piñapar queno nerqan: —¡Paqtam pitapis noqapaq willaquicayanquiman! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsepitanam jircaman Jesus witsärir qatiraqnincunapita shonqun tarenqancunata qayarqan. Ellucariyaptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","chunca ishcaqta acrarqan yanaqinpaq, y alli willaquita willapäcoq ewayänanpaq. Pecunam apostolnincuna cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pecunatam poderninta qorqan ˻qeshyaqcunata cachacätsiyänanpaq˼ y supëyoqcunapita supëcunata pepa jutincho qarquyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Quecunam cayan tse chunca ishque (12) acranqancuna: Simonmi (petaqa Jesusmi jutitserqan Pedru, nishpa); ");
INSERT INTO qwhNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeupa tsurincuna Santiagu y Juanmi (pecunatapis jutitserqan rayupa tsurincuna, nishpam) ");
INSERT INTO qwhNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andresmi; Felipim; Bartolomemi; Mateom; Tomasmi; Alfeupa tsurin Santiagum; Tadeom; Cananista nishqan Simonmi y ");
INSERT INTO qwhNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariotim. Pëqa carqan Jesusta ranticoqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsepitanam Jesus disipuluncunawan cuticur juc wayiman yecuriyarqan. Tsemannam jina yape atscaq nunacuna elluquecuyarqan. Tsemi miquitapis mana puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tseta musyarirninnam, Jesuspa castancuna wayincunaman pushacuyänanpaq ewayarqan. Porqui Jesuspaqqa “Locuyäcurishqam” nirmi, parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Peru Jerusalenpita uramushqa ley yachatsicoqcunanam queno niyarqan: —Que nunaqa supëcunapa mandacoqnin Beelzebupa poderninwanmi nunacunapita supëcunata qarqun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsenam Jesus pecunata qayarir iwalatsiquipa cäyitsirnin, queno nerqan: “¿Imanoparaq diablu pura qarqunacuyanman? ");
INSERT INTO qwhNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sitsun juc nasioncho nunacuna quiquincuna pura chiquinacuyanqa. Tseno carqa, ushacätsinacuyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sitsun juc wayicho yachaqcuna quiquincuna pura chiquinacuyanqa, tse castacuna raquicarmi, ushacäriyanman. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tse cuentanollam diablupis quiquinpa contran car mandaquininta ushacäratsinman. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Juc callpayoq nuna wayinta täpecaptenqa, manam manaraq peta pancarqa pipis imantapis suwanmantsu. Pancarirran imecancunatapis apacunman. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Rasontam niyaq: Diosqa nunacunata imeca jutsancunatapis, y pepaq llapan mana allicunata parlayanqancunatapis perdoneconqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Peru Santu Espiritupa contran pipis parlaptenqa, mananam imepis Diospa perdonninta tariyanqanatsu, sinoqa tse jutsanwanmi imeyaqpis condenadu cayanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Pëqa supëcunapa mandacoqninwanmi quecan” nir, ley yachatsicoqcuna niyashqa cayaptinmi, Jesus tseno nerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsemannam Jesuspa mamänin wauqincunawan chäriyarqan. Y waqtallapitam qayaratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsecho juntarëcaq nunacunanam Jesusta queno niyarqan: —Au, tëte, ashiyäshunquim waqtachomi quecayan mamäniqui, wauqiquicuna y paniquicuna. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesusnam queno nerqan: —¿Pitaq mamänï y wauqïcuna cayan? ");
INSERT INTO qwhNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsecho tëcaqcunata ricarëcurnam, queno nerqan: —Quecho quecaqcunam mamänïqa wauqïcunaqa y panïcunaqa cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Claru parlaquichoqa Dios mandacushqancunata wiyacoqcunam noqapa wauqïcunaqa panïcunaqa y mamänïqa cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yapenam Galilea Lamar cuchuncho Jesus yachatsiquicarqan. Tseman atscaq nunacuna elluquecuyaptinnam Jesusqa juc barcuman lloqarcur täcurerqan. Nunacunanam lamar cuchuncho quedariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsechonam iwalatsiquicunawan Jesus yachatsicur qallecorqan queno: ");
INSERT INTO qwhNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wiyayë que niyanqaqta: Juc nunam ewarqan chacranman murucoq. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Waquin murunam pintiyarqan ranraman. Tsecho ichiclla allpan captinnam, raslla jeqaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Y waquincunanam ranraman pintiyarqan. Y tsecho allpan uchuclla captinnam, tse murucuna ajalla jeqarayämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Y mana alli watsin captinnam, raslla tsaquiriyarqan inti achachaptin. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquinnam pintiyarqan cashacuna rurinman. Tse cashacunanam muru jeqamoqta tsapacurcuyarqan, y mana ni juc wayorqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Peru waquin murunam ishquiyarqan alli allpaman. Tsecho jeqaramurnam poqurir, llutepa wayicorqan cada espigacho quima chunca (30) granupayan, joqta chuncapayan (60) y pachacpayan (100). ");
INSERT INTO qwhNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“¡Tsemi rinriyoq carqa, wiyacur cäsucuyë!” ");
INSERT INTO qwhNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Llapan nunacuna eucuyaptinnam, Jesusta chunca ishque (12) disipuluncuna waquin qatiraqnincunawan tapuyarqan tse iwalatsiquipa yachatsiconqanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesusnam nerqan: —Qamcunataqa Diosmi cäyitsiyäshunqui mandaquinin imano canqanta. Peru waquincunataqa iwalatsiquicunawanmi yachatsinä. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“Tse nunacunaqa riquecarpis, manam cuentata qocuyantsu. Wiyecarninpis, manam cäyiyantsu. Tseno caquicar atscatam perdonta tarircuyanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jina quenopis nerqanmi: ¿Qamcunapis manacu iwalatsiquiwan yachatsiconqäta cäyiyanqui? Tsenoqa mascunata yachatsiyapteqpis, manachi cäyiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tseqa queno ninanmi: Imeca triguta muroqnomi alli willaquita willacuyan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Waquincunaqa näniman muru pintishqa cuentanomi cayan. Shonquncunaman alli willaqui chasquiyashqantam diablu pasepa qonqaratsin. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waquin nunacunanam ranraman muru pinteq cuenta cayan. Pecunam alli willaquita wiyacur cushishqa chasquiriyan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Peru imeca mana alli watsiyoq carmi, creyiquinincunacho mana alleqpa patsacashqa cayan. Tsemi alli willaquininrecur tuqui sufrimientucunata pasarnin, y nuna mayincuna chiquiyaptin creyiquinincunata qonqariyan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Waquincunanam cayan casha, casha rurinman muru pinteq cuenta. Pecunam alli willaquita wiyarirnin creyicuyan; ");
INSERT INTO qwhNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","peru que patsacho imapaqpis yarpacacharmi, y capoqyoq quepaq locuyarmi, imecapaqpis yarparäquicayan. Tsemi alli willaquita manana wiyacurnin, ni imata Diospaqqa rurayantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Peru waquin nunacunanam alli allpaman muru pintishqa cuenta cayan. Pecunam alli willaquita wiyar cäyicurnin, creyicuyan y allapa allicunatam Diospaq rurayan. Tseno carmi, imeca espigacho quima chunca (30) granucunapayan, joqta chuncapayan (60) y pachacpayan (100) wayïcoq cuentam cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tsepitanam nerqan, “¿Acasu lamparinta sendircur, manca rurinmancu o catripa rurinmancu churantsic? ¡Manam! Antis raramanmi churantsic alli actsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tse cuentam canan mana musyayanqancunata warecuna musyayanqa, y canan mana cäyiyanqancunatam, warecunana actsichonona cäyiriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wiyacoq caqqa cäyicuyë” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tsepitanam queno nerqan: “Jina quetapis shumaq cäyicuyë: imanollam qamcunapis nuna mayiquicunata tratayanqui, tsenollam qamcunatapis Dios tratayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsemi wiyacoq caqcunaqa mas alli cäyicuyanqa, peru mana wiyacoq caqcunaqa, ichiclla wiyayanqantapis qonqariyanqam” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tsepitanam nerqan: —Imeca chacracho juc nuna murucushqan cuentanomi Diospa mandaquinenqa. Juc nunam chacrancho murucun ");
INSERT INTO qwhNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","junaqpam, paqaspam; punurir, riyarir murushqanta mana yarpashpa cacun. Chacrancho muronqannam jeqaramur winan. Peru imano winanqantapis manam tse nuna musyantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mururishqaqa quiquinllanam jeqaramur winarirnin, espigarir poquramun. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tseno poquriptinnam, cosecha quillacho chacranman nuna ewarnin, segar ellupäcaramun. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tsepitanam jina nerqan: “Diospa mandaquininta ¿imawanraq iwalaratsishwan? Mä, que iwalatsiquillawan yacharatsiyashqequi: ");
INSERT INTO qwhNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Diospa mandaquinenqa imeca mostasapa murunnomi. Tse muroqa jinantin munducho murupitapis mas uchucllallanllam. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Peru mururishqaqa jeqaramur llapan qorapitapis mas jatunmi winarin. Tsenam pishqucunapis rämancunaman ratar qeshuncuna rurar cacuyan.” ");
INSERT INTO qwhNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tseno iwalatsiquicunawanmi nunacunata Jesus yachatserqan Diospa palabranta moduncunamannolla cäyiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nunacunata yachatserqa, imepis iwalatsiquicunawanran yachatseq. Disipuluncunatam siqa japallancunallatana iwalatsiquicunapa yachatsiconqanta mas claruna cäyitseq. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Patsa paqasyärëcaptinnam, disipuluncunata Jesus nerqan: —Acu lamarpa wac tsimpanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsenam tsecho nunacunata dejarïcur, Jesus yachatsicur lloqarëcanqan lanchallawan jeqariyarqan. Y tsecho quecaq lanchacunapis qepantam jeqariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tseno ewarëcayaptinnam, llutepa bientur qallaquicorqan, lamarta laqcheqsätsirnin. Lanchaman yacu winacaptinnam, undir qallaquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lanchapa qepanchonam Jesus jaunan churecur punuquicarqan. Y disipuluncunanam riyatsirnin, queno niyarqan: —¡Mayestru! ¿Manacu imapis qocushunqui que undiquecanqantsic! ");
INSERT INTO qwhNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsenam Jesus shärircur, queno mandarqan: —Amana bientïnatsu; ni yacu laqcheqsënatsu. Tsenam bientupis pararerqan, y llapanmi shumaq tranquilu ticrarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tsepitanam disipuluncunata queno nerqan: —¿Imanirtaq mantsacashqa cayanqui? ¿Manacu noqaman marcäcuyanqui? ");
INSERT INTO qwhNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsenam disipuluncuna quiquincuna pura mantsacäcur queno ninacuyarqan: —¿Queqa imano nunataq, tselaya bientupis y yacupis mandadunta cäsuyänanpaq! ");
INSERT INTO qwhNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lamarta tsimparirnam, Jesus disipuluncunawan chäriyarqan Gadara nishqan marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y lanchapeq yarpuriptinnam, juc supëyoq nuna Jesusman corillapa ewarqan. Tse nunaqa pantiunpitam shamicarqan; ");
INSERT INTO qwhNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","porqui pantiuncho päracoqmi carqan. Manam ni pipis tsareta puederqantsu, ni cadenawan watarninpis. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Atsca cutim cadenacunawan chaquinta y maquinta pancayarqan. Peru cadenacunatapis ichic ichicllam rachicacharcoq. Y manam ni pi domineta puederqantsu ");
INSERT INTO qwhNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tse nunam paqaspa junaqpa qaparir qayarir rumicunawan tsactacurnin, jircacunapa y pantiunpa puricorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Carupita Jesusta riquecurninnam, coripa ewar Jesuspa nopanman qonquriquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y qayaripa queno nerqan: —Puedeq Diospa tsurin Jesus, ¿imatataq noqacunawan munanqui! ¡Teyta Diosrecurmi qamta rogacoq ama imanecayämëtsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesus, “¡Que nunapeq yarqï supë!” nishqa captinmi, tse nunacho quecaq supë tseno nerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsenam supëta Jesus taporqan: —¿Imataq jutiqui? —nir. Tsenam nerqan: —Atscaq cayaptïmi, noqapa jutï “Juc Tropa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tsepitanam Jesusta allapa rogayarqan tse marcapeq mana qarqushqa cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tse quecayanqan ladun jircachomi atsca cuchicunata mitsiquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tsenam supëcuna mañepa, queno niyarqan: —¡Cachecalläyämë taqe cuchicunallaman yecuquiculläyänäpaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus äniriptinnam, nunapeq yarqurir, cuchicunaman yecuquicuyarqan. Cuchicunaqa ishque waranqanomi (2,000) cayarqan. Tsenam, coripa ewar cuchicunaqa jircapita qochaman jeqacurcuyarqan, y shenqacar, wanuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tse cuchi mitseqcunanam jinantin marcapa estansiancunapa coripa ewacuyarqan, ricayanqanta willacurnin. Y nunacunanam shayämorqan llapan pasacushqanta ricayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus quecanqanman chärirnam, ricariyarqan tse supëyoq nunata pasepa sanutana, roparishqana y juisiunchona tëcaqta. Tseta ricarnam mantsacäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y ricashqa caqcunanam tseman chaqcunata willayarqan tse supëyoq nunata y cuchicunata ima pasayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsenam Jesusta rogayarqan marcancunapita eucunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Y lanchaman Jesus lloqacurcuptinnam, supëpa munenincho cacushqa nunaqa rogarqan pewan eucunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Peru Jesus manam munarqantsu antis quenomi nerqan: —Wayiquiman cutïcur castequicunata willë qamta Dios ancupäshurniqui llapanta qampaq rurashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y cuticurnam, Decapolis nishqan marcacunapa purerqan Jesus pepaq llapanta rurashqanta willacurnin. Tsenam llapan nunacuna allapa mantsacäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsepita Jesus lanchawan cuticurnam, chärerqan lamarpa wac tsimpanman. Lamar cuchunllachoraq quecaptinnam, llutepa nunacuna ellucariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsemanmi jina ellucayänan wayicho mandacoq Jairupis chärerqan. Jesusta riquecurninnam, nopanman qonquriquicur, ");
INSERT INTO qwhNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","queno rogarqan: —Warmi tsurillämi wanurinna. Acu, eweculläshun. Yatarillaptiqueqa, cachacärirmi cawallanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tseno niptinnam, Jairuwan Jesus jeqariyarqan, y atsca nunacunam quichquinacur qepanta ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tse nunacuna rurinchomi juc warmi ewecarqan. Tse warmim chunca ishque (12) watana yawar ewewan qeshyacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tse qeshyawan jiparmi imecancunatapis ranticur usharqan doctorcunata pagananpaq, peru manam cachacätsiyaqtsu mas peormi antsäquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Y Jesus ruranqancunata musyarirnam, nunacuna rurinllapa Jesusman witïcur mantunta yatecorqan, ");
INSERT INTO qwhNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","shonqunllacho queno nirnin: —Mantunta yatecurllam que qeshyapita cachacärishaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yateconqan öram yawar ewenin paqwepa tsaquirerqan, y cachacärishqa canqantam mäcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsenam Jesus pepita poder yarqushqanta mäcurirnin, qepancho nunacunaman tumecur taporqan queno: —¿Pitaq yatamushqa ropäta? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Disipuluncunanam niyarqan: —¡Tëte, quelaya nunachoqa jucnin jucnintaq tanqayäshunqui! Y qamqa tapucunqui: ‘¿Pitaq ropäta yatamushqa?’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tseno niyaptinpis, Jesusqa jinantinpam ricachacorqan: —Mä, ¿Pish yatamashqa? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsenam warmeqa cachacärishqa canqanta mäcurir, Jesuspa nopanman allapa mantsacashqa qonquriquicur, llapanta willarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tsenam Jesus queno nerqan: —Ija, noqaman marcäcurmi cachacärerqonqui. Canan cushishqana euquï. Mananam mas jipanquinatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus tseno parlecaptinmi, ellucayänan wayicho mandacoq Jairupa wayinpita nunacuna shamur chäriyarqan queno nirnin: —Tëte Jairu, tsuriqueqa wanurishqanam. ¿Imapaqnatan Jesusta afananqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tse niyanqanta mana cäsushpam Jairuta Jesus queno nerqan: —Ama mantsaquëtsu. Noqallaman marcäquï. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsenam Jairupa wayinman Jesus jeqarerqan Pedruta, Santiaguta y Santiagupa wauqin Juanllata pusharcur. Waquincuna qatiyänantaqa manam munarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ellucayänan wayicho mandacoq Jairupa wayinman chärirnam, taririyarqan atscaq nunacuna qayaripa, qayaripa waqaquicayaqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wayiman yecurirnam, Jesus queno nerqan: —¿Imanirtaq quelayapa bullata rurar waqayanqui! Wamraqa punicanllam. Manam wanushqatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tseno niptinnam, nunacuna burlapaq churar asipäyarqan. Tsepitanam llapan nunacunata waqtaman Jesus qarqurirna, quiman disipuluncunawan y wamrapa papäninwan y mamäninwan yecuriyarqan wamra quecanqanman. ");
INSERT INTO qwhNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsechonam wamrapa maquinpita tsarircurnin, Jesus queno nerqan: —Talita cum —nishpa. (Tseqa: “Wamra, sharcamï” ninanmi). ");
INSERT INTO qwhNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Y wamranam jinallacho sharcamur purir qallecorqan. Tse wamraqa carqan chunca ishque (12) watayoqmi. Tseta ricarmi, nunacuna espantashqa quedariyarqan ");
INSERT INTO qwhNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesusnam nunacunata notificarqan pitapis tseta mana willacuyänanpaq, y mandarqan wamrata pachan qarayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tsepita eucurninnam, marcanman Jesus cuticorqan disipuluncunawan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jamaqui junaqchonam ellucayänan wayicho yachatsicur qallecorqan. Tse yachatsiconqanta wiyarninnam, nunacuna espantacur queno niyarqan: —¡Mechotaq quelayaqa yachaquecamorqon! Quelaya yachaq cananpaq ¿mechoraq yachacushqa! ¿Imanoparaq que llapan milagrucunata ruran! ");
INSERT INTO qwhNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manacu pëqa Mariapa wawan carpinterulla; wauqincunapis Santiagutaq, Josetaq, Simontaq y Judastaq! ¡Y panincunapis que marcantsiccho noqantsicwan juntutaq quecayan! —nir. Tseno nirninmi, piñarnin wiyetapis munayarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsenam Jesus queno nerqan: —Mechopis profetacunataqa respetayanmi, peru quiquinpa marcanchoqa, castanchoqa, y wayinchoqa manam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsemi marcanchoqa milagrucunatapis rurarqantsu. Antis juc ishque qeshyaqcunallatam yatar, yatar cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tseno mana creyicuyaptinmi, Jesus peqantapis tapsicurerqan. Tsepitanam Jesus marcan marcan nunacunata yachatsicur purerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsepitanam Jesus chunca ishque (12) disipuluncunata qayecur, ishquepayan me tsepapis cacharqan. Y podernintam qorqan nunacunacho supëcunata qarcuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y quenomi nerqan: —Ewarnin, ama ni imata apayanquitsu; sinoqa shucshullata apayanqui. Ama alporjata ni mircapata ni qelleta apayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yacaräyanqequi llanqiquicunallawan, y janequicunacho ratashniquicunallawan ewayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pipis wayinman posadatsiyäshuptiqui, tse wayillacho cacuyanqui tse marcapita eucuyanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sitsun me marcaman chäyaptiquipis nunacuna chasquiyäshunquitsu, ni wiyayäshunquitsu; tsepeq eucurnin, chaquiquicunacho polbutapis tapsicuriyanqui. Tseqa Diospa castigun janancunachona quecanqan señalmi canqa. ˻Rasontam niyaq: Juisiu junaqchomi Sodoma y Gomorra marca nunacunata castiganqanpeq mas feyupa Dios pecunata castiganqa˼. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsenam disipuluncuna jinantinpa ewar queno yachatsicuyarqan: —Mana alli rurenincunata wanacur, jutsata amana rurayënatsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Y atscaq nunacunapitam supëcunata qarquyarqan, y qeshyaqcunatam aseitiwan llushir, llushir ˻Teyta Diosman mañacur˼ cachacätsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tsenam alli rurenincunapeq Jesus allapa reqishqa ticracurerqan. Tsenam rey Herodis pepaq musyarerqan. Y nunacunanam queno niyarqan: —Bautisacoq Juantsunchi wanushqanpita cawarircamur, poderyoq car espantepaq milagrucunata rurecan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waquincunanam niyarqan: —Pëqa Eliasmi. Waquinnam niyarqan: —Pëqa Diospa une tiempu profetannomi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tseno niyanqanta Herodis musyarirninnam, nerqan: —Tse nunaqa peqanta roqutsir wanutsenqä bautisacoq Juanchi yä cawariramushqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Quenomi puntata pasacushqa carqan. Herodismi amigan Herodiasrecur Juanta cadenarcatsir carselman llawitsishqa carqan. Herodiastaqa wauqin Felipipa warmin quecaptinmi, wätaquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tsemi Herodista Juan queno piñaparqan: —¡Wauqiquipa warminwan wätanacurnin, Leypa contranmi rurecanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiasnam Juanta chiquir ime junaq carpis, wanutsinanpaq shuyaquicarqan. Peru manam puederqanraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Porqui wenan Herodismi imecanopapis Juanta tsaparqan pipis mana wanutsinanpaq. Jutsannaq alli ruraq nuna cashqanta musyarninmi, Juanta respetarqan. Tsemi yachatsicushqantaqa cushi, cushi wiyacurninpis, shonqunchoqa imano quetapis puederqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsepitanam shuyashqan junaq chärerqan. Y quenomi carqan: Herodismi cumpliañunman combidarqan amiguncunata, mandacoq autoridacunata, ofisialnincunata y Galileacho presisaq nunacunata wayincho micupäcuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tse miquicayanqanman yecurirmi, Herodiaspa shipashnin shumaq qatswaquicorqan. Tseta ricarmi, Herodis y tsecho llapan quecaqcuna allapa gustar cushicuyarqan. Tsemi tse shipashta Herodis queno nerqan: —Imecata mañamaptiquipis qoycushqequim. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mandacunqä marcapa pullanninta mañamaptiquipis, qoycushqequim. Y manam ulipashqequitsu; cumplishaqmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tseno niptinnam, shipashqa coricorqan mamäninta queno tapoq: —Mamä, ¿Imatatan mañaquicü? —nir. Mamäninnam nerqan: —Mañequï bautisacoq Juanpa peqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsenam shipashqa Herodisman cuticur nerqan: —Jinallacho bautisacoq Juanpa peqanta juc platucho qoycamë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tsenam rey Herodis allapa llaquishqa ticrarerqan; peru combidashqancunapa nopancho jurar änishqa carnam, negueta puederqantsu mañashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tsenam jinallacho juc soldaduta cacharqan Juanpa peqanta apamunanpaq. Soldadunam carselman ewar Juanpa cuncanta roqurïcur ");
INSERT INTO qwhNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","peqanta platucho aparcurnin, shipashta qoriyarqan, y shipashnam mamäninta qorerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanpa disipuluncunanam tseta musyarirnin, ewar ayanta apacurnin pampaquicuyarqan. ˻Tsenomi Juanwan pasacorqan.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesuspa apostolnincunanam cutirir, yachatsicuyanqancunata y rurayanqancunata Jesusta willayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Llutepa nunacuna elluquecuyaptinmi, pachata micuyänanllapaqpis tiempu carqantsu. Tsenam disipuluncunata nerqan: —Jamacurinapaq acu eucushun tsunyaqman —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsenam lanchaman lloqarcur, disipuluncunawan eucorqan tsunyaqman. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Peru mepa euconqantapis atscaq nunacunam ricayarqan y reqiriyarqan. Tsemi me tse marcapitapis llutepa nunacuna Jesus ewanqanman llallipa llallir, pepita mas puntata chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesusnam chärir lanchapita yarpurir, tsecho atscaq nunacunata ricarerqan. Tsenam allapa ancuparqan, porqui mitseqninnaq üsha cuentam puriquicayarqan. Tsemi tuquilayapa pecunata yachatserqan ");
INSERT INTO qwhNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tardiyäquicuptinnam, disipuluncuna Jesusman witirirnin, queno niyarqan: —Tëte, tardiyäquicunnam. Que tsunyaqchoqa manam ni imapis cantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Que nunacunata witsiratsina itsa ewayanqancho pueblucunam char, imallatapis rantirir micuriyanman. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesusnam nerqan: —Qamcunam pachanqa qarayänequi. Pecunanam niyarqan: —Que tsica nunapaqqa tinconqa qanchis quilla juc nuna uryapucur ganashqan qellewan tantata rantiyämuptï, ¡imaraqchi! ");
INSERT INTO qwhNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesusnam nerqan: —¿Eca tantataq cayäpushunqui? Mä, ewar aberwayämï. Aberwarirnam, niyarqan: —Pitsqa tantawan ishque pescadullam can —nishpa ");
INSERT INTO qwhNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsenam disipuluncunata Jesus nerqan tse quecayanqan tsampaman grupipayan nunacunata tätsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nunacunanam täcuriyarqan pitsqa chuncapayan (50), y pachacpayan (100). ");
INSERT INTO qwhNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesusnam tse pitsqa tantata y ishque pescaduta tsarircur sieluman riquecur, Diosta “Grasias” nicurerqan. Tsepitanam tse tantata paquirir disipuluncunata qorqan nunacunata qarayänanpaq. Y tsenollam tse ishque pescadutapis llapan nunacunata qararqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Llapancunam micuyarqan asta teqñayanqanyaq, ");
INSERT INTO qwhNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","y sobra tantata y pescaduta elluriyarqan chunca ishque (12) canasta juntataran. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tse micoqcunaqa llutepam quecuyarqan. Ollqucunallam cayarqan pitsqa waranqano. (5,000) ");
INSERT INTO qwhNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsepitanam Jesus disipuluncunata mandarqan lanchaman lloqarcur lamarpa wac tsimpan Betsaida marcaman puntärëcayänanpaq. Penam tsecho nunacunata despidir quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nunacunata despidirirnam jircapa eucorqan, tsecho Diosman japallan mañacunanpaq ");
INSERT INTO qwhNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lamar chopinta disipuluncuna lanchawan euquicayaptinnam, patsaqa paqasyärerqanna. Peru Jesusqa jircallachoran japallan caquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tse jircapitam ricarerqan bientu lanchata juc ladupa apacoqno captin disipuluncuna nacaquicayanqanta. Patsa warärëcaptinnam, disipuluncunaman Jesus ewar yacu jananpa purir laduncunapa pasacoqno carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Disipuluncunanam yacu jananpa ewaqta riquecur, alma cashqanta pensar mantsaquewan “¡Achachi!” nir, qayarïcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y llapancunam tseta ricar sellama mantsacäyarqan. Tsenam Jesusqa queno nerqan: —Balorta tsariyë. Noqam cä. Ama mantsacäyëtsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Tsepitanam lanchaman lloqariptin, tselaya bientu pärarerqan. Disipuluncunanam allapa espantashqa quedariyarqan. Tantapita milagru rurashqanta ricashqa quecarninpis, rumi shonqu carninmi cäyiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tse lamarta tsimparirnam, chäriyarqan Genesaret nishqan marcaman. Lancha mana eucunanpaqnam watariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lanchapita apenas yarpuriyanqan öram nunacuna Jesusta reqiriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tsenam tse particunapita ewar Jesus mecho canqantapis tapuquicuryan qeshyaqcunata quirmapa wanturishqa peman apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y me marcacunapapis, estansiacunapapis, caseriucunapapis Jesus ewanqanmanmi plasacunacho qeshyaqnincunata apar shuyecatsiyaq. Y rogayaq qeshyaqnincuna mantunpa cuchunllatapis yatecuyänanpaq. Y yataq caqqa llapanmi cachacäyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tsepitanam Jerusalenpita ewaq fariseucuna y ley yachatsicoqcuna Jesusman witiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pecunam Jesuspa disipuluncuna maquincunata mana paqacushpa miquicaqta ricarnin, “Diospa contranmi rurecuyan” nir, pensayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseucunaqa llapan israel nunacunawanmi manaraq micur maquincunata allipa paqacuyaq. Tseno rurayänanpaqmi une awilitucuna yachatsishqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tsemi callipeq cutirpis, manaraq maquincunata paqacorqa mana micuyaqtsu. Atscam costumbrincuna carqan. Tsemi asta tasancunatapis, platuncunatapis, fieru mancancunatapis, täcuyänancunatapis paqayaqraq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsenam Jesusta fariseucuna y ley yachatsicoqcuna queno tapuyarqan: —¿Imanirtaq disipuliquicuna awiluntsiccunapa costumbrincunata cäsuyantsu! ¿Imanirtaq Diospa contran maquincunata mana paqacushpa micuyan! ");
INSERT INTO qwhNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusnam nerqan: —¡Ä, alli tucoq nunacuna! Rasontam profeta Isaiaspis qamcunapaq Dios nishqanta queno escriberqan: ‘Que nunacunaqa shimincunallawanmi respetamaq tucuyan; Peru shonquncunachoqa manam yarpäyämanpistsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nunacunapa costumbrincunallata yachatsicuyaptinmi, adorayämanqanpis sirwintsu’, nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tsemi Teyta Dios mandacushqancunata jaqirïcur, nunacunapa costumbrincunallata ruracur y ˻mancacunata y tasacunata paqellapaq yarparäquicayanqui.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jina quenopis nerqam: —Imano shumaqmi Diospa mandaquininta juc cuchuman churaricur, costumbriquicunata ruraquicayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moises escribishqan leychomi queno nin: ‘Tëtequita, mamequita allipa ricanqui’ nir. ‘Y mamanpaq mana alli parlaqtaqa wanuratsiyätsun’, nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Peru qamcunanam yachatsicuyanqui, ‘Papä, mamä, yanapeniquita manam puedïtsu. Quecapamanpis Diosllapaqmi’ nishpa, niyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tseno yachatsirmi, mañecatsiyanqui, mamäninta papäninta mana yanapayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tsenomi Dios mandacushqancunata juc cuchuman churarir, une costumbriquicunallata juctapis wactapis yachatsir caquicayanqui.” ");
INSERT INTO qwhNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tsepitanam llapan tsecho quecaqcunata qayecur Jesus queno nerqan: —¡Canan shumaq wiyacurnin, llapequicuna cäyiyämë! ");
INSERT INTO qwhNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Manam jaqpita ruriman yecoqtsu nunataqa melanepaqta ticratsin, sinoqa ruri shonqupita jaqman yarqamoqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","˻Que niyanqaqta wiyacoq carqa cäyicuyë˼ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsepitanam tsecho nunacunata jaqirïcur, Jesusqa juc wayiman yecurerqan. Tsechonam disipuluncuna rogayarqan tse yachatsicushqancunata shumaq cäyïcatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesusnam nerqan: —¿Qamcunaqa upachi cayanqui! Manam imatapis micuyanqanpitatsu nunacunaqa melanepaq cayan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ima miquipis manam shonqumantsu yecun, sinoqa pachamanmi. Tsepitanam pasaratsimuntsic. (Tseno nirmi, Jesus yachatsicorqan llapan miquitapis micunapaq alli canqanta.) ");
INSERT INTO qwhNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tsepitanam nerqan: —Quiquin nunapa mana alli yarpeninmi melanepaqta ticratsin. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Tsemi mana allicunata shonquncunacho yarpar quecunata rurayan: majayoq quecarmi jucwan jucwan yachacuyan; y mana majäcushpam jucwan jucwan puricuyan. Nuna mayincunatam wanutsiyan; suwam y codisiosum cayan, nuna mayincunatam maldata rurayan, ulim cayan, gustayanqanta mana teqñapucäcoqmi cayan, embidiosum cayan, wasa rimam cayan, musyaq tucoqmi cayan y imatapis llutan camanllatam ruraquicayan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tse cosascunata shonquncunacho yarpacachar rurarmi, nunacunaqa melanepaq ticrariyan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsepita yarqurirnam, Tiro ˻y Sidon˼ nishqan marcacunapana Jesus eucorqan. Tsechona quecanqanta nunacuna musyayänanta mana munarnam, juc wayiman yecuquicorqan. Peru imanopapis nunacunaqa musyariyarqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tsecho quecanqantam supëyoq shipashpa mamänin musyarerqan. Tse warmim Jesuspa nopanman ewarnin, qonquriquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Y Jesusta rogacorqan wawanpita supëta qarqurinanpaq. Tse warmeqa Grecia nasionpitam carqan, Sirofenicia marcacho yuricoq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsenam Jesus nerqan: —Canan öram marca mayïcuna yanapepaq quecayan. Sitsun qamta yanapecushqequi, tseqa canqa imeca wamracunata tantata miquicayaptin qochirir, allqucunata qarecoq cuentachi. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Warminam nerqan: —Aumi ari, Tëte. Peru imano captinpis, siemprim wamracuna tantata micuyaptin mesapita shicwaqllatapis allqucuna micurilläyan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tsenam Jesus nerqan: —Tsetaqa allitam nirinqui. Canan cutiquï. Tseno parlanqequirecurmi, wawequipita supë eucushqana. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tseno niptinnam, wayinman cuticur shipashninta cämarëcaqta tarirerqan, y supëqa pepita yarqushqanam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro marcapita cuticurnam, Sidon marcapa y Decapolis marcacunapa pasar Galilea Lamarman Jesus chärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tsecho quecaptinmi, apayämorqan mana wiyaq gaguta. Chäratsirnam, Jesusta rogayarqan tse nunata cachaquecatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsenam Jesusqa, juc laduman japallanta pusharir, tse sordupa rinrinman dedunta yacarerqan. Tsepitanam dedunta toqapurir, gagupa qallunta yatarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tseno rurarirnam, sieluman ñuquircur llaquicurir, queno nerqan: —¡Efata! —nishpa. (Efataqa “Quichaquë” ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tse öram rinrin wiyarerqan, y qallun alliyäriptin claruna parlaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tse rurashqancunata mana pitapis willacuyänanpaqmi Jesus notificacorqan. Peru tselaya notificaquicaptinpis, masran nunacuna willacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tsemi espantacur, queno niyarqan: —¡Llapan rurashqancunapis allapa allim; asta sorducunatapis wiyatsinmi y muducunatapis parlatsinmi! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Juc cutinam Jesusman atscaq nunacuna yape ellucayashqa quecayarqan. Micuyänanpaq mana imapis captinnam, disipuluncunata Jesus qayarir queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Que nunacunata allapam ancupëcü. Quima junaqnam quecho noqawan quecayan; y manam ni imallapis micuyänanpaq cantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waquincunanäqa allapa carupitam shayämushqa, mallaqta wayincunaman cachecuptïqa, nänichochi mallaqewan ishquiriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Disipuluncunanam queno niyarqan: —Peru quechoqa tsunyaqchomi quecantsic. ¿Mechoraq miquita tarishun quetsica nunacuna micuyänanpaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesusnam queno taporqan: —¿Ecallataq tantequicuna quecan? —nir. Pecunanam yasquiyarqan: —Qanchisllam quecan, Tëte —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsenam Jesusqa nunacunata nerqan pampaman täcuriyänanpaq. Täcuriyaptinnam, qanchis tantata tsarircur, Diosta “grasias” nicurir paquirerqan. Tsepitanam disipuluncunata qorerqan. Pecunanam nunacunata qarayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jina cayäporqanmi juc ishque uchusaq pescaduncunapis. Tsetapis jina tsarircurmi, Diosta “Grasias” nïcorqan. Tsepitanam disipuluncunata nerqan nunacunata qarayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Llapan nunacunam micuyarqan asta teqñayanqanyaq. Tsepitapis qanchis canasta juntataran sobraqcunata elluriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsecho micoqcunaqa cayarqan chuscu waranqanomi (4,000). Micuriyaptinnam, nunacunata witsiratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsepitanam disipuluncunawan lanchaman lloqarcur Dalmanuta nishqan marcaman eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chäriyaptinnam, fariseucuna ewar Jesusta mana alliman ishquitsita munarnin, queno niyarqan: —Mä, ima milagrullatapis Diospa poderninwan ruraramï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tseno niyaptinnam, Jesus llaquicurir, queno nerqan: —¿Imanirraq que nunacuna tseno milagrutaraq munayan? Peru manam ricayanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tseno nirirninnam, pecunata jaqirïcur lanchaman lloqarcur lamarpa wac tsimpanman disipuluncunawan eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tse eucurninnam, disipuluncuna mircapa apeta qonqecuyarqan. Juc tantallam lanchacho quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tseno euquicarnam, Jesus pecunata queno notificarqan: —Cuidacuyë fariseucunapa y rey Herodispa lebadurancunapita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Disipuluncunanam mana cäyir, quiquincuna pura queno ninacuyarqan: —Tantata qonqecamushqa cashqam tseno nimantsic —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tseno ninacuyanqanta cäyicurcurnam, Jesus queno nerqan: —¿Imanirtaq tantequicuna mana canqanta yarpacachäyanqui? ¿Imalaya chucru shonqutaq cayanqui? ¿Manacu cäyiyanqui imapaq parlecanqäta? ");
INSERT INTO qwhNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Imanirtaq cullu rinri cayanqui! ¿Manacu riquecarpis cäyiyanquiraq! ¿Manacu yarpäyanqui ");
INSERT INTO qwhNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","pitsqa tantallapita pitsqa waranqa (5,000) nunacunata micuratsiptï eca canasta juntata sobracunata elluyanqequita! Pecunanam niyarqan: —Chunca ishquetam (12) —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jina qanchis tantallapita chuscu waranqa (4,000) nunacunata qarariptï, ¿eca canasta juntatataq sobrata elluriyarqequi? Pecunanam niyarqan: —Qanchistam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsenam Jesus nerqan: —Tseno quecaptinpis, ¿manacu cäyicuyanquiraq! ");
INSERT INTO qwhNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsepitanam Betsaida marcaman chäriyarqan. Tsecho quecayaptinnam, Jesusman juc wiscuta apayämorqan, y rogacuyarqan Jesus cachaquecatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tsenam wiscuta jancharcur tse marcapa washaninman apacorqan. Tsechonam wiscupa nawinman toqecur, yatecur taporqan: —¿Imallatapis ricanquinacu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tse wiscunam ricachacurir nerqan: —Aumi, Teyta. Monticunatano nunacunata pureqtam riquecä. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsenam nawinta yape Jesus yatecuptin, paqwena cachacärerqan, y allinam llapantapis ricarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsenam tse nunata Jesus queno nerqan: —Ama que marcaman yequïtsu ˻paqtam willaquicunquiman cachacätsenqaqta, antis wayiquiman ras cutiquï˼ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsepitanam disipuluncunawan Jesus ewarqan Cesarea Filipopa caseriuncunaman. Tseman ewarëcarnam, disipuluncunata queno taporqan: —¿Pi canqätataq nunacuna niyan noqapaq? ");
INSERT INTO qwhNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pecunanam queno niyarqan: —Waquinmi niyan qamqa bautisacoq Juanshi canqui. Waquinnam niyan Diospa profetan Eliasshi qamqa canqui. Waquincunanam niyan “Diospa une profetanchi” nir, niyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tsenam Jesus nerqan: —Qamcunaqa, ¿imataq niyanqui? ¿Pitaq cä? Tsenam Pedru queno nerqan: —Qamqa Dios Acrashqanmi canqui, Tëte —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tseno nïcuptinnam, Jesus nerqan: —Ama tsetaqa pitapis willacuyanquitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesusnam disipuluncunata quiquinpaq willapäcur nerqan Diospita Shamushqa Nunata jipatsiyänanpaq caqta, y autoridacuna, saserdoticunapa mandacoqnincuna y ley yachatsicoqcuna chiquir wanutsiyänanpaq caqta, y quima junaqllata cawariramunanpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tseno cananpaq cashqanta claru willaquicuptinnam, Jesusta Pedroqa juc laduman japallanta qayarir piñaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Peru Jesusnam tumecur disipuluncunata allipa ricarëcur, Pedruta queno nerqan: —¡Quepeq yarqï, diablu! Qamqa manam Teyta Dios munashqannotsu yarpanqui; sinoqa nunacuna munayashqannollam yarpanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tsenam nunacunata y disipuluncunata qayarir queno nerqan: —Pipis qatirämaqnï queta munarnenqa, quiquinpa muneninta jaqiricur, crus apaqno noqata qatimätsun. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pipis caweninllapaq yarparaq caqqa ushacanqam; peru noqarecur y alli willaquinïrecur caweninta oqraq caqqa wine cawetam tarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Porqui ¿imapaqraq juc nunata sirwenqa jinantin mundupa dueñun canqanpis, wiñe caweta mana lobraptin! ");
INSERT INTO qwhNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tsemi metsica imayoq carpis, ni pi caweninta rantita puedintsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sitsun noqaman mana marcäcoq jutsasapa nunacunapa nopancho pipis noqapita y alli willaquinïpita penqaconqa; tsenollam Diospita Shamushqa Nunapis pepita penqaconqa que patsaman Dios Yayapa poderninwan y santu anjelcunawan cutimur. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tseno nirirnam, nerqan: —Quetapis shumaq cäyirayämë: Canan quecho quecaqcunapitaqa waquinniquicuna manaran wanuyanquiraqtsu, asta puedeq Diospa mandaquinin chämushqanta ricayanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tsepita joqta junaqtanam jircaman Jesus ewarqan Pedruta, Santiaguta, y Juanllata pusharcur. Tsechomi ricarëcayaptin, Jesus juclaya ticracurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ropannäqa imano shumaqmi chipapecorqan. Tseno yulaqtaqa manam ni pi alli taqshaqpis yulaqätsinmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tseno quecaptinnam, Moisesta y Eliasta Jesuswan parlecayaqta ricariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsenam Jesusta Pedru queno nerqan: —Mayestru, ¡imalaya allim quecho quecantsic! ¡Quima tsucllata rurecushun: jucta qampaq, jucta Moisespaq y juctana Eliaspaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Allapam mantsaquecuyarqan. Mana imanopis queta puedirninmi, Pedru tseno nïcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tseno parlecayaptinmi, pucute limpu tsapärerqan. Y pucute rurinpitanam queno parlamoqta wiyayarqan: —Quemi cuyë tsurï. Pe yachatsiyäshunqequita wiyacuyë —neqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsepita yape ricarcuyänanpaqqa mananam pitapis pecunawan quecaqta ricayarqanatsu. Jesusllatanam ricariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jircapita urärëcamurnam, Jesus pecunata nerqan ricayanqancunata pitapis mana willacuyänanpaq asta Diospita Shamushqa Nuna wanurir cawarimonqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesus nenqannollam pitapis willacuyarqantsu. Peru quiquincuna purallam tapunacuyarqan, “¿Ima ninanraq wanushqacunapita cawarimiqa?” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsepitanam Jesusta queno tapuyarqan: —Teyta, ¿Imanirtaq ley yachatsicoqcunaqa niyan Dios Acrashqan shamunanpaqqa puntataran profeta Elias shamonqa nishpa? ");
INSERT INTO qwhNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tsenam Jesus nerqan: —Aumi, pecuna niyashqannollam Eliasraq puntata shamunan carqan llapanta alistapäcoq. Peru Diospa palabranchomi jina escribirëcan Diospita Shamushqa Nunata jipatsir allqutsayänanpaq caqtapis. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Claru parlaquichoqa Eliasqa shamushqanam y munayanqanta niräyanqantam peta ruracuyarqan. Tseno pasacunanpaq caqtaqa Diospa palabranchomi willacun. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Waquin caq disipuluncunaman cutiramurnam, tarirerqan ley yachatsicoqcunawan liryaquicayaqta. Y astcaq nunacunam jiruroq tsecho quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsenam Jesusta riquecurnin, allapa cushishqa nunacuna saludaq coripäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusnam disipuluncunata nerqan: —¿Imanirtaq pecunawan liryayanqui? ");
INSERT INTO qwhNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tseno tapucuptinnam, juc nuna queno nerqan: —Teyta, qammanmi supë muduyätsishqa tsurïllata apamorqö. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Petam mecho quecaptinpis, supë illaqpita seqicacharcun. Ataquino tsarirninmi, patsaman seqirir, quirunta ruchuchütsir, pushoquta cachutsin. Tsarenqan öranäqa garutinomi ticrarin. Disipuliquicunatam rogacullarqö supëta qarquyänanpaq, peru pecunaqa manam puediyashqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesusnam nerqan: —¡Allau, mana marcäcoqcuna! ¡Imecamayaqraq qamcunawan quecashaq! ¡Imecamayaqraq awantayashqequi! ¡Wamrata queman apayämï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamrata aparëcayaptinnam, Jesusta tse supë riquecur wamrata seqirir patsacho qarishpätsir tapsiquicorqan limpu pushoqutapis cachutsir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tsenam Jesusqa wamrapa papäninta queno taporqan: —¿Imepitataq que tsuriquita tseno pasan? —nir. Papäninnam nerqan: —Llullu queninpita patsam, Tëte. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Atsca cutinam ninamanpis, yacumanpis tse supë wanutsita munarnin jitar ushan. Imallatapis rureta puedirnenqa, canan ancupëcallämar yanapecalläyämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesusnam nerqan: —¿Puedirnenqa nimanquitsun? ¡Marcäcoqcunapaqqa imapis ruracanqam! ");
INSERT INTO qwhNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsenam tse wamrapa papänin qayarïcorqan: —Qamman marcäcullämi, Tëte, y mas marcäcallämunäpaq yanapecallämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsenam allapa atscaq nunacuna ellucayaqta ricarnin, demoniuta Jesus piñapar queno nerqan: —Sordu mudu ticratseq supë que wamrapita euquï, y cananpita witsepa ama que wamraman cutinquinatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tseno niptinnam, wamrata supë ataquino tsarircur, patsaman ishquiratsir, qayaritsir, tapsicacharcorqan. Eucuptinnam, wamra wanushqano ticrarerqan. Nunacunanam niyarqan: —Wamra wanurillan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Peru maquinpita tsarircur Jesus sutarcuptinnam, wamra sharcaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsepitanam juc wayiman Jesus yecuriptin disipuluncuna japallanllatana tapuyarqan queno nishpa: —¿Imanirtaq noqacuna puediyarqötsu wamrapita supë qarqita? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tsenam Jesus queno nerqan: —Quenolaya supëtaqa qarquntsic Diosman mañacurmi y ˻ayunuta rurarmi˼ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Quecayanqanpita eucurnam, Jesus disipuluncunawan pasacuyarqan Galilea probinsiacho marcacunapa. Disipuluncunata yachatsinan captinmi, waquin nunacuna tseman ewayänantaqa munarqantsu. Tsechomi disipuluncunata queno nerqan: —Diospita Shamushqa Nunatam chiqueqnincunapa maquinman entregayanqa. Pecunam wanutsiyanqa; peru quima junaqllatam cawarimonqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tseno willecaptinpis, disipuluncuna manam cäyiyarqantsu, peru tapiquitaqa mantsacuyarqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsepitanam Capernaum marcaman chärir juc wayiman yecurir disipuluncunata Jesus taporqan queno: —Sharëcamushqa ¿imatataq liryar tapunacuyarqonqui? ");
INSERT INTO qwhNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Disipuluncunaqa nänicho quiquincuna pura piñatsinacuyarqan, llapanpita mas presisaq queta munarninmi. Tsemi tseta willequita penqacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsenam Jesusqa täcurir, chunca ishque (12) disipuluncunata qayarir queno nerqan: —Meqequipis presisaq queta munarqa, waquincunapita mas qollmi shonqum cayänequi, y pi metapis sirwiyänequim. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tseno nirirnam, juc wamrata qayarir chopincunaman shäratserqan. Tsepitanam wamrata mellqarcur, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pipis queno wamrata jutïcho chasquerqa, noqatam chasquiman; y noqata chasquimarneqa, cachamaqnïtapis chasquenqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juannam queno nerqan: —Mayestru, noqacunam ricayarqö juc nunata supëyoq nunacunapita supëcunata jutiquicho qarqoqta. Peru mana noqantsicwan puriptinmi, michäyarqö. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsenam Jesus queno nerqan: —Ama michäyanquimantsu carqan. Pipis noqapa jutïta mentarir ima milagrutapis rurarqa ¿imanoparaq noqapa conträ canman? ");
INSERT INTO qwhNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pipis mana contrantsic carqa, noqantsicwanmi quecan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rasontam niyaq: Noqata qatiyämashqequirecur pipis juc tasa yacullatapis qarecuyäshuptiqueqa, tse nunatam Dios paganqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tsepitanam jina Jesus queno yachatsicorqan: “Que wamracunano qollmi shonqunwan noqaman creyicamoqcunata pipis jutsaman ishquitseqcunataqa; mas allim canman tse nunapa cuncanman jatun mulinu rumin watarcur lamarman jitarcuyänan. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tsemi willayaq: Maquiquitsun jutsa rureman ishquitsishiniquita munanqa, roquriquï. Mas allim canqa mancullapis wiñe caweman chäyänequi, ishcan maquiquiwan imepis mana upeq nina infiernuman ewanqequipitaqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","˻Tsechoqa curucuna manam imepis wanuyantsu. Ninapis manam upintsu.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tsenolla chaquiqui jutsa rureman apashuptiquipis roquriquï. Mas allim canqa tseno cutu chaquillapis wiñe cawaquiman chänequi ishcan chaquiquiwan imepis mana upeq infiernuman chanqequipitaqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","˻Tsechoqa curuncunapis manam wanuyantsu. Ninapis manam upintsu.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y sitsun nawiqui jutsa rureman ishquitsishunqui, oqtirir jitariquï. Mas allim canqa wiscullapis Diospa mandaquininman chänequipaq. Mana tseqa ishcan nawiquitawanmi infiernuman Dios jitarpushunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tsechoqa curucunapis manam wanuyantsu. Ninapis manam upintsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Y qamcunaqa imeca ninawan cachitashqa cuentam quecayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cacheqa miquicunata mishquitsinanpaqmi alli. Peru cachi qamläcurerqa, ¿imanepanaraq yape mishquinta cutitsinman? Tse alli cachi cuentanomi qamcuna cayanqui, jucniqui jucniquipis shumaq cawacorqa.” ");
INSERT INTO qwhNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaumpita Jesus eucurninnam, Judea probinsiaman chärir Jordan mayuta tsimparerqan. Tsemanpis allapa atsca nunacunam ellucayarqan, y imepis yachatsicushqannomi jina pecunatapis Jesus yachatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsenam fariseucunaqa, Jesusman witïcur yachatsiquinincho pantatsita munar, queno tapuyarqan: —¿Leynintsiccho permitincu warminpita juc nuna diborsiacurinanpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsenam Jesus nerqan: —Moises escribishqan leycho ¿imanotaq Dios mandacun? ");
INSERT INTO qwhNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pecunanam niyarqan: —Moises escribishqan leyqa quenomi mandacun: ‘Meqan nunapis warminpita raquiqueta munarqa, diborsio papelta firmecur raquicacuritsun’, ninmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tseno niyaptinnam, Jesus nerqan: —Rumi shonqu cayaptiquim, Moises tseno mandacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peru Teyta Diosqa, Que patsata camarnin, warmita ollqutam camarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tsemi, ollqu jaqirenqa mamanta yayanta warminwan juntacäyänanpaq, ");
INSERT INTO qwhNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Y ishcancunapis jucnollanam ticrariyanqa. Tsemi ishcaqnatsu cayan, sinoqa jucllellanam. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tseno captinmi, Dios juntashqantaqa mana pipis raquinmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsepitanam juc wayicho quecar, Jesusta disipuluncuna tapuyarqan tse asuntuta maslla cäyiparatsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesusnam queno nerqan: —Meqan nunapis warminpita diborsiacurir jucwan casacorqa, punta caq warminta jalucurmi jutsaman ishquirin; ");
INSERT INTO qwhNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","y meqan warmipis qowanpita diborsiacurir jucwan casacorqa, jina qowanta jalucurmi jutsaman jina ishquirin. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsepitanam nunacuna ñushpi wamrancunata Jesusman apayarqan yatar bendisinanpaq; peru disipuluncunanam wamra apaqcunata piñapäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tseta riquecurnam, Jesus piñacurcur disipuluncunata queno nerqan: —¡Noqaman wamracuna shayämutsun! ¡Ama michäyëtsu! Que wamracunano caqcunapaqmi Diospa mandaquinenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rasontam niyaq: Sitsun Diospa mandaquininta que wamracunano mana chasquiyanqui, manam tse mandaquiman yecuyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tseno nirnam, tsecho quecaq wamracunata mellqarcur, pecunaman maquinta churar bendisicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tsepita eucuyänanpaq Jesus yarqurëcaptinnam, juc nuna corillapa peman chärir qonquricur queno taporqan: —Alli mayestru, wac bidacho wiñepa cawanäpaq ¿imatataq rurashaq? ");
INSERT INTO qwhNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusnam yasquerqan: —¿Imanirtaq ‘Alli’ nimanqui? Jucllellam alleqa, y tseqa Diosllam. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dios mandacushqancunata qamqa musyanquim. Quenomi nin: ‘Nuna mayiquita ama wanutsinquitsu. Majayoq quecar, ama jucwan jucwanqa yachacunquitsu. Ama suwacunquitsu. Ama nuna mayiquipaq ulicurcur mana caqta parlanquitsu. Ama nuna mayiquita engañanquitsu. Tëtequita, mamequita respetanqui.’ ");
INSERT INTO qwhNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jesus tseno nïcuptinnam, tse nuna queno nerqan: —Wamra quenïpitam tsecunataqa llapanta cumplicä, tëte. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tseno niptinnam, nunata ricarärir ancupar nerqan: —Jucran ruranequi pishin. Canan ewar llapan imequicunatapis rantiquicur, tse qelleta wactsacunata qoyquï. Tseno ruraptiquim, sielucho mana ushacäcoq fortunequi canqa. Tseno rurarïcur, noqata qatimë. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tseno nïcuptinnam, allapa llaquicur y yarpacachar eucorqan, porqui allapa ricum carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tseno eucuptinnam, jinantinman riquecachärir disipuluncunata queno nerqan: —¡Allapa sasam Diospa mandaquininman capoqyoq nunacuna yecuyänan! ");
INSERT INTO qwhNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesus tseno nïcuptinnam, disipuluncunaqa mantsacashqa quedariyarqan. Tsenam Jesus yape queno nerqan: —Cuyë wamralläcuna, ricucunapaqqa allapa sasam Diospa mandaquininman yecuyänan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¡Porqui mas alerim awjapa uchcunpa juc camellu pasarinman, juc capoqyoq nuna Diospa mandaquininman yecunanpitaqa! ");
INSERT INTO qwhNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tseta wiyecurnäqa, masran espantacuyarqan. Y jucnin jucninmi queno tapunacuyarqan: —Tseno captenqa, ¿pillanataq salbaconqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesusnam disipuluncunata alli ricarëcur nerqan: —Quiquincunallapitaqa manam pipis salbaquita puediyantsu, Teyta Diosllam nunacunataqa salban, porqui Diospaqqa manam imapis sasatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsenam Pedru queno nerqan: —Tëte, noqalläcunaqa llapantam jaqiriyarqö, qamta qatiyänaqpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesusnam nerqan: —Rasontam niyaq: Diospa alli willaquininrecur y noqarecur pipis wayinta, wauqincunata, panincunata, tëtanta, mamanta, wamrancunata y chacrancunatapis jaqirerqa, ");
INSERT INTO qwhNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tse llapanta jaqirenqanpitam pachaq (100) cuti masta wayinta, wauqincunata, panincunata, tëtanta, mamanta, wamrancunata y chacrancunatapis que tiempucho chasquenqa y que patsacho nacar jiparninpis, wac bidachoqa wiñepanam cawanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Peru canan tiempu presisaq caqcunam qepacho cayanqa, y mana presisaq caqcunanam puntacho cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tsepitanam Jerusalenman ewarëcayaptin, disipuluncunapa puntancunata Jesus ewecarqan. Disipuluncunanam yarpacachar ewecayarqan. Y qepan ewaq nunacunapis llaquinar mantsacashqam ewecayarqan. Tsenam chunca ishque (12) disipuluncunata juc laduman qayarirnin, yape willarqan imapis pasananpaq caqta, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Musyayanqequinomi Jerusalenman ewecantsic. Tsechomi Diospita Shamushqa Nunata saserdoticunapa mandacoqnincunaman y ley yachatsicoqcunaman entregayanqa. Pecunanam wanutsiyänanpaq condenar mana israel nunacunaman entregayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tsechonam burlapar, toqapur feyupa astayanqa. Tsepitanam wanutsiyanqa; peru quima junaqllatam cawarimonqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsepitanam Zebedeupa tsurincuna Santiagu y Juan Jesusman witïcur queno niyarqan: —Mayestru, jucta rogaculläyashqequi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tseno niyaptinnam, Jesus nerqan: —¿Imallatataq munecayanqui? —nishpa ");
INSERT INTO qwhNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pecunanam niyarqan: —Änicalläyämë mandaquiniquicho quecaptiqui, jucnï derechu ladiquiman y jucnïna itsoq caq ladiquiman tecur mandacuyänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tseno niyaptinnam, Jesus nerqan: —Qamcunaqa manam musyayanquitsu imata mañacayämanqequitapis. ¿Qamcuna puediyanquimantsuraq noqa pasanäpaq caqcunata paseta? ");
INSERT INTO qwhNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pecunanam “Aumi, puedilläyämi” niyarqan. Jesusnam nerqan: —Änirpis rasonpam noqa pasanqäno sasacunata pasayanqui; ");
INSERT INTO qwhNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","peru derechu laducho y itsoq laducho pipis täcamunanpaqqa manam noqatsu dispunï. Tsetaqa Papänïllam dispunishqana. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tseta wiyecurnam, chunca caq disipuluncunaqa, Juanpita y Santiagupita piñacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsenam llapan disipuluncunata qayarir queno nerqan: —Musyayanqequinomi Diosman mana marcäcoq reqishqa mandacoqcunaqa nunacunata allqutsayan, y puedeq quenincunaman atenicurmi, nunacunata munashqanta rurayan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Peru qamcunachoqa manam tsenotsu canqa. Meqequipis mandacoq queta munarqa, llapantam sirwiyänequi. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Meqequipis mayor queta munarqa, llapanpa esclabun cuentam cayänequi. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tsenollam Diospita Shamushqa Nunapis que patsaman shamushqa nunacunata sirwinanpaq y yawarninwan rescatananpaq, y manam peta sirwiyänanpaqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsepitanam Jerico marcaman chäriyarqan. Tse marcapita disipuluncunawan y atscaq nunacunawan Jesus eucurëcarnam, näni cuchuncho tariyarqan juc wiscu nunata caridata mañacur tëcaqta. Tse wiscoqa carqan Timeupa tsurin Bartimeum. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tse wiscunam Jesus Nazaret nuna shamicaqta musyarir, qayaripa queno qayacorqan: —¡Davidpa castan Jesus, ancupëcallämëri! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tsenam nunacuna upällatsita munar wiscuta piñapäyarqan, peru wiscoqa masran queno nir, qayaricachäcorqan: —¡Davidpa castan Jesus, ancupëcallämëri! —nir ");
INSERT INTO qwhNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tseta wiyecurnam, shäcurir Jesus queno nerqan: —Taqe nunata qayayämï —nir. Wiscuman ewarninnam, queno niyarqan: —¡Balorta tsaricur, ras sharcamï! Jesusmi qayecashunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tsenam wiscoqa aqshunantapis jitarïcur juclla sharcur Jesusman ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesusnam taporqan: —¿Imata ruranätataq qampaq munanqui? Wiscunam nerqan: —¡Ricachaquitam munallä, Tëte! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tsenam Jesus nerqan: —Canan ewaquïna. Noqaman marcäcamurmi, cachacärerqonqui. Tse öram wiscu ricachacurerqan, y Jesuspa qepanta eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalenman yequicarnam, Olibus nishqan jircacho quecaq Betfage y Betania marcacunapa chäriyarqan. Tsepitam Jesus ishcaq disipuluncunata cacharqan, ");
INSERT INTO qwhNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","queno nishpa: —Ewayë taqe ricaquecamoq marcaman. Chärirnam, taririyanqui manaraq pipis montashqan pollinu ashnu watarëcaqta. Tse ashnuta pascarir apayämunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sitsun pipis niyäshunqui: ‘¿Imapaqtaq ashnuta pascayanqui?’ nishpa, ‘Teytam nesitan. Rasllam cutiratsiyämushaq’ niyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsenam ewarnin, taririyarqan wayi puncu nänicho ashnutaqa watarëcaqta. Tsenam pascayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tsecho quecaq nunacunanam queno tapuyarqan: —¿Imatataq rurayanqui? ¿Imapaqtaq que ashnuta pascayanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsenam Jesus nenqannolla niyaptin, dejariyarqan apayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tsenam ashnuta aparcur Jesus caqman cuticuyarqan. Chäratsirnam, aqshunancunata carunayarqan Jesus montananpaq. Montashqa ewarëcaptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","atscaq nunacuna aqshunancunata qoturïcur näniman mashtayarqan; y waquincunanam monticunapa rämanta paquirir qopiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Y llapan nunacunam Jesuspa puntanta y qepanta ewaqcunaqa, cushicur qaparir qayarir queno niyarqan: —¡Alabashun Diospa shutincho shamoqta! ");
INSERT INTO qwhNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cananqa mandaquinin bendisishqam canqa une papänintsic Davidpa mandaquininno! ¡Alabecuyaqmi sielucho quecaq Dios! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalenman chärirnam, Jesusqa templuman yecurerqan. Tsecho imecacunatapis cösa ricapäcurirnam, tardiyäquicuptinna, Betaniaman cuticorqan chunca ishque (12) apostolnincunawan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Waränin qoyanam Betaniapita eucurëcayaptin Jesuspa pachan waqacurcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tsenam atsca raprayoq igus montita ricarir ewarqan “¿Mä, frutan cancush?” nir. Peru manaraq igus tiempu captinmi, frutan carqanraqtsu. Rämanllaraq quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsenam igus montita Jesus queno nïcorqan: —Cananpita witsepa mananam pipis wayïniquicunata miconqanatsu. Tseno nenqantam disipuluncuna wiyayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalenman chärirnam, Jesusqa templuman yequicur, patiucho qatucoqcunata y rantipacoqcunata qarqacacharcamorqan. Tsenollam qelle trocaqcunapa mesancunatapis y paluma ranticoqcunapa täcuyänancunatapis jitacacharcamorqan; ");
INSERT INTO qwhNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","y templuman ni imata yecatsiyänanta manam consienterqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Y pecunatam queno piñapar willaparqan: —Diospa palabranchomi queno escribirëcan: ‘Wayïqa mañacuna wayim. Tsechomi jinantin nasioncunapita shamur nunacuna mañacuyanqa.’ Tseno quecaptin, ¿imanirtaq suwacunapa machenintano ticratsiyarqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tseno parlanqanta wiyecurmi, Jesusta mantsarnin saserdoticunapa mandacoqnincuna, ley yachatsicoqcuna “¿Imanotaq Jesusta wanicatsintsic?” ninacuyarqan, porqui Jesus yachatsiconqantaqa nunacuna allapam gustecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Peru paqasyäriptinnam, Jerusalenpita yarqurir eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Waränin qoya cutirëcarnam, igus montita taririyarqan watsinpita tsaquirishqatana. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsenam Jesus nenqanta yarparcurnin, Pedru queno nerqan: —¡Mayestru, riquë! Qanyan maldisiushqequi igus pasepa tsaquirishqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tsenam Jesus nerqan: —Diosman alli marcäcuyë. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rasontam niyaq. Pipis llapan shonqunwan rasonpa marcäcur taqe jircata ‘¡Quepita yarqur lamarman jeqacurquï!’ niyaptiquipis, ewar jeqacurconqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tsemi queno niyaq: Llapan shonqiquicunawan marcäcur imatapis mañacorqa, Diosman mañacuyaptiqui imecatapis qoyäshunquim. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y imatapis mañacuyanqequi öra, chiquiyäshoqniquicunata puntata perdonecuyë. Tseno rurayaptiqueqa, sielucho Dios Yayam qamcunatapis jutsequicunapita perdonayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","˻Peru sitsun qamcunapis nuna mayiquicunata perdonayanquitsu, sielucho quecaq Diospis manam jutsequicunapita perdonayäshunquitsu.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsepitanam Jerusalenman chäriyarqan disipuluncunawan. Templucho Jesus puricaptinnam, saserdoticunapa mandacoqnincuna, ley yachatsicoqcuna y autoridacuna Jesusman witïcur, ");
INSERT INTO qwhNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","queno tapuyarqan: —¿Ima puedeq queniquiwantaq quecunata rurarqonqui! Tseno ruranequipaq ¿pitaq mandashorqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tseno niyaptinnam, Jesus nerqan: —Noqapis qamcunata jucta tapuyashqequi: Tapuyanqaqta yasquiyämaptiqueqa, noqapis willayäshqequim pipa poderninwan quecunata ruranqäta. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Pitaq cachamorqan bautisacoq Juanta nunacunata bautisananpaq, Dioscu o nunacunallacu? ¡Mä, niyämë! ");
INSERT INTO qwhNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tseno tapïcuptinnam, quiquincuna pura queno ninacuyarqan: —¿Imataq nishun? ‘Diosmi cachamushqa’ nishqaqa, tsepenqa ‘¿Imanirtaq peman creyiyarqequitsu!’ nimäshunmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Nunacunallam cachayämushqa nïquitaqa manam puedintsictsu’ —nir. Tse autoridacunaqa mantsayarqanmi nunacunata, porqui Juanpaqqa profeta canqantam creyiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsenam Jesusta queno niyarqan: —Manam musyayätsu —nir. Tseno niyaptinnam, Jesuspis nerqan: —Tsepenqa noqapis manam willayaqtsu quecunata ruranäpaq pi mandamanqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsepitanam iwalatsiquiwan yachatsicurnin, Jesus queno nerqan: “Juc nunam ubasta plantarqan chacranman, y jinantin cuchunpa perqatserqan. Tsepitanam juc jatun posuta ruratserqan ubaspeq binuta rurayänanpaq. Tsepitanam chacranta täpayänanpaqna juc jatun torita ruratserqan. Tsepitanam tse chacranta pullan pura muruyänanpaq nunacunata qoquicur, caru marcapa eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsepitanam cosecha tiempu chäriptinna, chacrayoqqa juc sirweqninta cacharqan, pullan pura muroqnincunaman pepa partinta raquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chäriptinnam, tsaricur maqacacharcur jinallata qarquriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tsepitanam chacrayoqqa juc sirweqnintana cacharqan. Petanäqa peqantapis paquicacharcurmi, tuquita ashayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsepitanam jina juc mas sirweqnintana chacrayoq cacharqan. Petanam wanuratsiyarqan. Tsenollam jina cacharqan mas atscaq sirweqnincunatana. Pecunatapis waquintam maqacacharcuyarqan; y waquincunatanam wanuratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Jucllellanam cachananpaq quecarqan. Pëqa carqan cuyë tsurinmi. Petam llapanpa ultimunta cacharqan, ‘Tsurïtaqa respetayanqam’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Peru chacra tsaraq nunacunanam quiquincuna pura queno yachatsinacuriyarqan: ‘Queqa chacrayoqpa tsurinmi y erederum canqa; mejor wanicatsishun chacranwan quedacunantsicpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Niyanqannollam tsarïcur wanuratsirnin, ayantapis chacranpeq juc laduman apecur jitariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Cananqa ¿imatataq chacrayoq pecunata ruranqa? Ewarmi, chacran tsaraqcunata wanicatsir, juccunatana chacranta qoyconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Manacu Diospa palabranta queno escribirëcaqta leyishqa cayanqui? ‘Wayi perqaqcuna: “Que rumeqa manam allitsu” nir, jitariyanqanmi, cananqa mayestra rumi ticrarishqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Diosmi dispunerqan tseno cananpaq. Tseqa noqantsiccunapaq allapa espantaquipaqmi.’ ” ");
INSERT INTO qwhNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesus tseno yachatsicuptinmi, cuentata qocuriyarqan, tse yachatsiquicanqan pecunapa contrancuna cashqanta. Peru presu tsarita munecarpis, nunacunata mantsarninmi, mana imanashpa jaqirir eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsepitanam fariseucunata y rey Herodispa qatiraqnincunata tse autoridacuna Jesusman cachayarqan, tapucoqnolla Jesusta llutanta parlecatsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tse cachacunanam chärirnin niyarqan: —Mayestru, musyayämi rasonpa caqllata parlanqequita. Qamqa manam ni meqan nunaman qaqanquitsu, ni meqan nunapa gustunta ruranquitsu. Rason caqllatam Dios munashqanno cawayänäpaq yachatsiyämanqui. Tsemi tapucurilläyaq: ¿Allicu Roma mandacoq cesarpaq impuestuta pagashwan o manacu? ");
INSERT INTO qwhNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tsenam Jesusqa arde upa tucur tapupëcayanqanta cuentata qocurir queno nerqan: —¿Imanirtaq mana alliman ishquitsimeta munayanqui! Mä, apayämï tse qelleta ricanäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Qelleta qoriyaptinnam Jesus nerqan: —Que qellecho ¿pipa retratuntaq quecan? ¿Pipa jutintaq escribirëcan? Pecunanam niyarqan: —Mandacoq cesarpam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesusnam nerqan: —Tsepenqa mandacoq cesarpa caqtaqa mandacoq cesarta qoycuyë; y Diospa caqtaqa Diosta qoycuyë —nir. Tsenam pecuna mana ni ima nita puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsepitanam saduseu nishqan grupupita Jesusman tapucoq ewayarqan. Pecunaqa manam creyiyarqantsu wanushqacuna cawariyämunan cashqanta. Tsemi queno tapuyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mayestru, Moises escribishqan leychomi queno willacun: ‘Sitsun juc casädu nuna manaraq tsurin captin wanuconqa, tse biudanwan jucnin wauqin casacutsun. Tsenopam wamrancuna captin tse wanucushqa wauqinpa tsurin cuenta canqa’, nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Masqui jucta willariyashqequi: Cayänaq qanchis wauqicunash. Mayor caqshi casacunaq, y manaraq tsurin captinshi pe wanuquicunaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tseshi qepan caq wauqinna biudanwan casacunaq. Pepis jina manaraq tsurin captinshi wanuquicunaq. Tsenoshi mas qepan caq wauqinpis biudawan casacunaq, jina wanucunaq manaraq tsurin captin. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tsenollash qanchisninpi tse warmiwan casacur casacur manaraq tsurincuna captin wanucuyänaq. Tsepitanash warmipis wanuquicunaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mä, canan niyämë: Cawarimi junaqcho que warmi ¿meqan caqpataq lejitimu warmin canqa, qanchis wauqiwan casacushqa quecaptin! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tseno niyaptinnam, Jesusqa queno nerqan: —¡Qamcunaqa llutantam yarpäyanqui, porqui manam cäyiyanquitsu Diospa palabran escribirëcanqanta, ni Dios allapa poderyoq canqanta! ");
INSERT INTO qwhNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanushqacuna cawariyämuptenqa, mananam warmipis ni ollqupis casacuyanqanatsu. Porqui sielucho quecaq anjelcunanollanam cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Qamcuna ¿manacu leyishqa cayanqui wanushqacuna cawarimunanpaq yachatsiquita? Moises escribishqanchomi shira casha rupecaqpita Moisesta yuripur Dios queno nerqan: ‘Noqaqa Abrahampa, Isaacpa y Jacobpa Diosninmi cä’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tsemi Diosqa wanushqacunapa Diosnintsu; sinoqa cawecaqcunapam. ¡Qamcunaqa pantacushqam quecayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tseno liryarnin, Jesus allipa yasquir yachatsicushqanta wiyecurnam, ley yachatsicoq juc mayestru queno taporqan: —Tëte, Diospa mandamientucho ¿Meqan caqtaq mas presisaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tseno tapuptinnam, Jesus queno nerqan: —Mas presisaq mandamientucunaqa quenomi nican: ‘Israel nunacuna, camacoq Diosnintsicqa jucllellam. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tse camacoq Diosllata cuyanqui llapan shonqiquiwan, llapan boluntaniquiwan, llapan yacheniquiwan y llapan callpequiwan.’ ");
INSERT INTO qwhNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jucnin caqnam queno nin: ‘Nuna mayiquita cuyanqui quiquiquitano.’ Que ishcan mandamientucunapeq mas presisaqqa manam cantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesus tseno niptinnam, ley yachatsicoq queno nerqan: —Allitam nerqonqui, Mayestru. Qam nenqequinollam: Diosqa rasonpa jucllella. Y juc masqa manam cantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y llapan shonquntsicwan, yachenintsicwan, boluntanintsicwan, callpantsicwan Diosta cuyarnin, y nuna mayintsictapis quiquintsictano cuyarnenqa, allitam rurantsic. Tsemi mas alleqa, altarcho qarecunata y animalcunata pishtarir Diospaq cayanqantsicpitapis. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tse ley yachatsicoq alli yacheninwan niptinnam, Jesus queno nerqan: —Dios munashqanno cawaquiman naqanam chëcanqui —nir. Y mananam ni meqanpis tapupeta almitiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tsepitanam templucho yachatsiquicar Jesus queno nerqan: —Ley yachatsicoq mayestrucunam yachatsicuyan ‘Dios Acrashqanqa une rey Davidpa castanmi’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Peru Davidqa Santu Espiritu cäyitsiptintaq, queno nerqan: ‘Diosmi nerqan Teyta Diosnïta: Que derechu ladüman täcamï asta llapan chiquiyäshoqniquicunata muneniquiman churamonqäyaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tseno nicarqa, ¡imanoparaq castanllataqa ‘Teyta Diosnïmi’ ninman carqan! Jesus tseno yachatsicuptinmi, allapa gustar atscaq nunacuna wiyaräcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tseno yachatsiquicarnam, Jesus queno nerqan: —Cuidacuyë ley yachatsicoqcunapita, porqui pecunaqa chaqui puntanyaq shumaq ropancunata yacacurcurmi, callicunacho puriyan, nunacuna respetar saludayänanta munarnin. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ellucayänan wayichopis mas presisaqcuna täcuyänanmanmi täquita munayan. Micupäquiman qayatsiyaptinpis, punta puntaman taquitam gustayan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y biudacunatanäqa imecancunatapis ushapäyanmi. Y disimularllanam, alli tucushpa une resacuyan. Tseno cayanqanpitam pecunataqa Dios allapa feyupa castiganqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jucpinnam templucho ofrenda winacuyänan caja frentincho Jesus tëcar, ricarëcarqan nunacuna tse cajaman ofrendata winaqta. Atscaq ricu nunacunam atsca qelleta winayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsemannam chärerqan juc wactsa biudapis. Pëqa ishquella sentabuntam tse cajaman winarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tseta riquecurnam, disipuluncunata qayarir Jesus queno nerqan: —Rasontam niyaq: Llapancunapitapis taqe wactsa biudam masta cajaman winarcushqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Waquincunaqa winayan sobrapucuyanqanllatam; peru taqe warmeqa wactsa quecarpis cawarcunanpaq tsella quecaponqantam llapanta winarcushqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tsepitanam templupita Jesus yarqurëcaptin juc disipulun queno nerqan: —Mayestru riquequï que jatusaq wayicunata, imano shumaqmi jatusaq qaqacunawan perqecuyashqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tsenam Jesus nerqan: —Que riquecayanqequi jatusaq wayicunaqa pasepam ushacanqa, y manam ni juc rumillapis perqarëcarqa quedanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tsepitanam Jesus templupa tsimpan Olibus niyanqan jircacho tëcaptin, disipuluncuna Pedru, Santiagu, Juan y Andres pacallapa queno tapuyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Mayestru, willarayämë, ¿Imetaq tsecuna pasaconqa? ¿Ima señalta ricarnintaq musyariyäshaq nenqequi cumplicärenqanta? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusnam nerqan: “¡Paqtataq pipis engañayäshunquiman! ");
INSERT INTO qwhNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Atscaq nunacunam ‘Noqam Dios Acrashqan cä’ nir, shuyni nunacunata engañar puriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Gueracuna waccho quecho caquicaqtam wiyayanqui. Tsemi tseta wiyar ama mantsacäyanquitsu. Tsenomi susedicunan presisan, peru manaran que patsa ushacanqaraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Juc nasionmi juc nasionwan guerata rurayanqa. Y juc marca nunacunam juc marca nunacunawan wanutsinacuyanqa. Mechopis patsam temblorwan allapa cuyonqa. Mallaqäqui watacunam canqa. Tsecunaqa imeca juc warmi qeshpicunanpaq nanatsicushqannollaran y sufrimientucunapa qallananllaran. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Tsemi qamcuna mäcoq mäcoq quecayänequi; porqui autoridacunamanmi apayäshunqui. Ellucayänan wayicunachomi astayäshunqui. Noqarecurmi autoridacunaman y reycunaman apayäshurniqui, tuquita tapupäyäshunqui. Tsecunaqa pasayäshunqui noqapaq willacuyänequipaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y manaraq que patsa ushacaptinmi, alli willaquinïta jinantin nasioncunacho nunacunata willapäyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Peru autoridacunaman apayäshuptiqui, ama yarpacachäyanquitsu, ‘¿Imataraq nishaq? ¿Imanoraq parlacurishaq?’ nirnin; sinoqa parlacuriyanqui Teyta Dios cäyitsiyäshonqequillata. Porqui manam quiquiquicunapitatsu parlayanqui, sinoqa Santu Espiritum parlatsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tsenollam nunacuna wauqincunata chiquirnin, entregayanqa autoridacunaman wanutsiyänanpaq. Papänincunanam jina tsurincunata iwalitu rurayanqa. Y tsurincunapis papänincunapa mamänincunapa contran sharcurmi, entregayanqa wanuratsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Noqarecurmi llapan nunacuna chiquiyäshunqui. Tseno captinpis, wanonqanyaq noqacho tsaracoqmi salbaconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Teyta Diospa templuncho ‘mana combieneq melanepaq sacrifisiuta rurecoq’ riquecorqa, Judea marcacunacho täraqcuna qeshpir, ewacuyätsun jircacunapa. (Queta leyeq caqqa shumaq cäyicuyätsun.) ");
INSERT INTO qwhNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Altuscho quecaqcuna ama wayi ruriman yarpuyanqatsu imancunatapis jorqoq. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chacrancunacho quecaqcunapis ama cutiyanqatsu aqshunancuna jorqoq. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Allau, tse junaqcunacho qeshyaq tucushqa warmicuna y llulluta chichicaqcuna! ");
INSERT INTO qwhNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tse sufrimientucuna tamya tiempucho mana cananpaq Diosman mañacuyë. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tse junaqcuna allapa jipaquimi canqa. Tseno jipaqueqa manam imepis cashqaraqtsu que patsata Dios camashqanpita; y mananam yapepis canqanatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Teyta Dios tse sufrimientucunata acrashqancunata cuyar mana ras pasaratsiptenqa, manachi pipis salbacunmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sitsun pipis niyäshunqui ‘Taqechomi quecan, o quechomi quecan Dios Acrashqan’ nir, ama creyiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porqui tse junaqcunam yuriyämonqa Dios Acrashqan tucoqcuna y profeta tucoqcuna. Pecunam milagrucunata rurarnin, nunacunata engañayanqa, asta Dios acrashqancunatapis engañetam tïrayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tsemi manaraq tsecuna pasacuptin mäcoq mäcoq cayänequipaq willecayaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tse jipaquicuna pasariptinmi, inti ni quilla actsenqanatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Qoyllurcunapis shicwayämonqam y llapan sielucho quecaqcunam cuyucurenqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tse öram llapan nunacuna ricayanqa Diospita Shamushqa Nunata pucutecho intino chipapäquicar, llapan puedeq queninwan shamicaqta, ");
INSERT INTO qwhNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","y anjelnincunatam cachanqa jinantin mundupa ewar, mepita tsepitapis acrashqancunata elluyämunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Igus monti imano cashqanta shumaq tantiyayë: Qamcunam igus monti tseqllimoqta ricar musyayanqui achache tiempu chämunanpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tsenollam canan willayanqaqcuna susedicoqta ricarnin, musyayanquina Diospita Shamushqa Nunapa cutiminin janequicunachona quecanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rasontam niyaq: Canan tiempu nunacuna manaraq wanuyaptinmi, llapan willaconqäcuna susediconqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sielupis patsapis ushacäriyanqam, peru niyashqaq palabräqa manam ushacanqatsu; cumplicanqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Que nishqäcuna ime öra o ime junaq cumplicänanpaq caqtaqa manam pipis musyayantsu, ni sielucho quecaq anjelcunapis, ni noqa Diospa tsurinpis, sinoqa quiquin Dios Yayallam musyan. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tserecur mäcoq mäcoq quecayë. Porqui manam musyayanquitsu ime öra cutimunäpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tseqa canqa imeca juc nuna eucurnin, wayinta cuidayänanpaq sirweqnincunanta umpaquicur dejapashqannomi. Pecunatam imecata rurayänanpaq caqtapis cäyitsin. Y täpacoqtapis nin puncucho mäcoq mäcoq quecananpaq ");
INSERT INTO qwhNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tsemi mäcoq mäcoq quecayänequi, porqui tse täpacoq cuentam musyayanquitsu ime öra cutimunäta. ¿Patsa paqasyärëcaqtsuraq, pullan paqastsuraq, qoya gallu cantetsuraq o qoya patsa waretsuraq tse wayiyoq cutimonqa? ");
INSERT INTO qwhNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","¡Paqtaraq illaqpita cutimur punuquicaq cuentata tariyäshunquiman! ");
INSERT INTO qwhNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Qamcunatanollam waquincunatapis canan willarï ¡imepis mäcoq mäcoqlla quecayänanpaq!” ");
INSERT INTO qwhNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ishque junaqllanam pisherqan lebadurannaq tantata micur Pascua fiestata selebrayänanpaq. Saserdoticunapa mandacoqnincunanam y ley yachatsicoqcunam parlayarqan, nunacunata mana musyatsishllapa Jesusta tsarïcur wanuratsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Peru niyarqan: —Pascua fiestachoqa ama tsarishuntsu. Tsecho tsarïcushqaqa nunacunam contrantsic bullacurcuyanqa —nirmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsepinmi Betania marcacho Jesus quecarqan leprosu niyashqan Simonpa wayincho. Tsemannam mesacho micur tëcaptin chärerqan juc warmi alabastrupita botellawan allapa chaniyoq nardu püru pucutäcoq perfumin tsararishqa. Tse botellitata paquirirnam, perfumita Jesuspa peqanman jicharqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Waquin nunacunanam tseta ricar piñarnin, queno ninacuyarqan: —¿Imapaqraq taqe warmi tse perfumita perditsir ujuratsin! ");
INSERT INTO qwhNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tse perfumipa chanenqa casi juc wata juc nuna uryapucur ganashqannomi. ¿Manacu ranticushwan carqan tsellawanpis wactsacunata yanapanapaq! —nir. Tseno nirmi, warmita piñapar ushayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Peru Jesusnam queno nerqan: —¡Upälla cayë! ¡Ama piñapäyëtsu! Tseno ruramar noqapaqqa allapa allitam rurashqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Porqui wactsacunaqa imeyaqpis qamcunawanmi quecayanqa munayashqequi öra yanapayänequipaq, peru noqaqa mananam qamcunawan cashaqnatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Que warmeqa puedenqanmannomi noqapaq rurashqa. Que perfumita jichamonqanwanmi alistaramashqa pampacäcunäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rasontam niyaq: Mecho tsechopis alli willaquinïta willacoqcunam que warmi ruranqantapis willacuyanqa. Tsenopam que warmi rurashqanta yarpäriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesuspa chunca ishcaq (12) disipuluncunapitam jucnin caq disipulun Judas Iscariote carqan. Pemi ewarqan saserdoticunapa mandacoqnincunaman Jesusta entreguecunanpaq parlaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pecunanam allapa cushicur Judasta qellenin qoyänanpaq äniriyarqan. Tsenam Judas shuyarëcarqan ime öra carpis Jesusta entreguecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lebadurannaq tantata micuyänan Pascua fiesta qallanan junaqmi costumbrincunamanno wata wata israel nunacuna üshacunata pishtayaq. Tse junaqmi Jesusta disipuluncuna tapuyarqan: —¿Mechotan alistayämushaq Pascua miquita micunantsicpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsenam ishcaq disipuluncunata Jesus cacharqan queno nirnin: —Ewayë Jerusalenman. Tsechomi juc nunata cuntuwan yacu apecaqta tariyanqui. Tse nunapa qepanta qatircur ewayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yeconqan wayiman yecurirna, wayiyoqta queno niyanqui: ‘Mayestrücunam queno nin: ¿Meqan cuartiquichotaq Pascua miquita micushaq disipulücunawan?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wayiyoqnam ricatsiyäshunqui rara altuscho jatun cuartu alistashqata. Tsecho prebiniyanqui micunantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tseno niriptinnam, disipuluncuna jeqariyarqan. Jerusalenman chärirnam, Jesus nenqannolla tarirnin, alistayarqan Pascua miquita micuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Patsa paqasyäriptinnam, tseman Jesus chärerqan chunca ishque (12) disipuluncunawan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mesacho miquicayaptinnam, Jesus queno nerqan: —Rasontam niyaq: Que micur juntareqanqantsicpitam jucniqui ranticamanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tseno niptinnam, disipuluncunaqa llaquinashqa ticracuriyarqan, y jucnin jucninmi tapuyarqan: —Tseqa ¿noqallätsuraq cä, Teyta! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesusnam queno nerqan: —Chunca ishquepita (12) jucniqui caqmi, y noqawan juntu juc platullacho tantata tullpurcuryan miquicaq caqmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Diospa palabran nenqan cumplinanpaqmi Diospita Shamushqa Nunaqa wanonqa; peru ¡allau, tse entregamaqnï nuna! Mas allim yuricunmanpistsu carqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tseno micurëcayaptinnam, tantata Jesus tsarircur Diosta “Grasias” nicurerqan. Tsepitanam tantata paquirir, disipuluncunata qorqan queno nishpa: —Que tantata micuyë. Queqa noqapa cuerpümi —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsepitanam binuyoq copata tsarircur Diosta “Grasias” nicurir, disipuluncunata qorerqan, y llapancunam uputsinacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y quenomi nerqan: —Queqa noqapa yawarnïmi. Que yawarnïwanmi mushoq contratu ruracärin. Noqam yawarnïta ramarnin, wanushaq atscaq nunacunapaqrecur. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Y niyaqmi: Binuta mananam yapeqa upushaqnatsu asta Diospa mandaquinincho quecar mushoq binuta upunqäyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tsepitanam juc salmu cantuta cantacurir, Olibus niyanqan jircaman eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tsechonam Jesus queno nerqan: —˻Canan paqasmi˼ llapequicuna jaqiricayämarnï, ewacuyanqui. Tseno captinmi, Diospa palabranwan pactarenqa queno nenqan: ‘Mitseqnintam wanuratsiyanqa y üshancunam witsicar, eucuyanqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Peru cawarircamurmi, puntequicunata Galilea marcaman ewashaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesus tseno niptinnam, Pedru nerqan: —Waquincuna jaqiriyäshuptiquipis, noqaqa manam jaqishqequitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tsenam Jesus nerqan: —Pedru, rasontam neq: Canan paqasmi manaraq gallu ishque cuti cantaptin quima cuti negamanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tsenam Pedroqa tsaracorqan queno nir: —Qamtawan juntu wanutsiyämänan captinpis, manam negashqequitsu —nir. Y llapan disipuluncunapis tse shimillam cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsepitanam Getsemani nishqan wertaman disipuluncunawan ewayarqan. Tsechonam pecunata queno nerqan: —Diosman mañacamunqäyaq, qamcunaqa quellacho täcurëcayë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nirirmi, pusharqan Pedruta, Santiaguta y Juanta. Tsechomi Jesus shonquncho nanatsicur allapa llaquishqa ticracurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tsemi queno nerqan: —¡Llaquiquiwanmi shonqü imanaquicunchi! Quellacho riyaq riyaqlla quecayë. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tseno nirirnam, mas washanincunaman witirir, urcunpis patsaman chanqanyaq puctïcur, mana tse jipaqui öra chänanpaq queno nishpa mañacorqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Papällä, qampaqqa manam ni imapis sasatsu. Tselaya jipar nacanäpaq quecaqcunapita salbecamë; peru noqa munashqänoqa ama callätsuntsu, sinoqa qam munashqequino quecullätsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsepitanam cutirerqan disipuluncuna caqman, y tarirerqan punuquicayaqtam. Tsenam Pedruta nerqan: —Simon, ¡punuquicanquitsun! ¿Manacu juc örallapis pununeta awantariyanquiman! ");
INSERT INTO qwhNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Riyacur Diosman mañacuyë, diablu tenteta munayäshuptiqui, jutsaman mana ishquiyänequipaq. Boluntaniquicuna alli captinpis, sasam rurarcuyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tseno nirirnam, yape cutïcur puntata mañacushqannolla mañacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Disipuluncuna caqman cutirirnam, pecunata yape tarerqan punuquicayaqta; puni allapa bensiyaptinmi, punuquicayarqan, y penqacurmi Jesusta ni ima nita puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quima cuti cutenqanchonam disipuluncunata queno nerqan: —¿Jinallacu punuquicayanqui? ¡Ä, qamcuna! Örä chäramushqanam jutsasapa nunacunaman Diospita Shamushqa Nunata entregayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Sharcayämï! ¡Acuna eucushun! Entregamaqnï yecarëcamunnam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus manaraq parlar ushaptinmi, chunca ishque (12) apostolnincunapita Judas caq apostolnin atscaq nunancuna pusharishqa chärerqan. Tse nunacunaqa ewayarqan espadancunawanmi y garutincunawanmi. Pecunataqa cachayarqan saserdoticunapa mandacoqnincunam, ley yachatsicoqcunam, y autoridacunam. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Traisionero Judasqa nunacunata quenomi yachatsishqa carqan, “Noqa saludar mutsanqä caqmi canqa. Peta ras tsariyanqui, y mana cacheta apacuyanqui” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y nishqannollam Judasqa shumaqlla Jesusman witïcur “¡Mayestru!” nishpa, mutsecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsenam Jesusta presu tsarircur apacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsenam tsecho shëcaq nunaqa espadanta jorquricurnin, mas mandacoq saserdotipa sirweqninpa rinrinta wallicorqan pintireqpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tsepitanam tse presuyänanpaq ewashqa nunacunata Jesus queno taporqan: —¿Imanirtaq suwa captïno espadequicunawan y garutiquicunawan tsariyämänequipaq shayämorqonqui? ");
INSERT INTO qwhNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Noqaqa waran waranmi qamcunawan carqö templucho yachatsicur. Tsechoqa ¿imanirtaq presuyämarqonquitsu? Peru Diospa palabrancho escribirëcanqan cumplicärinanpaqmi, cananraq presu tsariyämanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tseno tsaricurcuyaptinmi, Jesusta japallanta jaqirïcurnin, llapan disipuluncuna qeshpir eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Peru juc jobinmi Jesusta qaterqan sabanasnin aqshucurcurlla. Petapis tsaripäcuyarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Peru aqshurashqan sabanaspita ullurirmi, qalapachu qeshpir coricorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsepitanam Jesusta saserdoticunapa mas mandacoqninman apacuyarqan. Tsemanmi ellucariyarqan saserdoticunapa mandacoqnincuna, autoridacuna y ley yachatsicoqcunapis ");
INSERT INTO qwhNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrunam caru qepancunallata qaterqan mas mandacoq saserdotipa patiun ruriyaq. Tsechonam templupa wardiancunawan juntu täcurir nina rupecaqcho qoñuquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Saserdoticunapa mandacoqnincunanam Sanhedrin nishqan corticho llapan autoridacunawan delitunta ashiyarqan Jesusta wanutsiyänanpaq, peru manam tariyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Peru Jesuspa contran ulicurcur atscaq nunacuna parlarninpis, manam jucllellataqa parlayarqantsu sinoqa jucninmi jucta, jucninmi jucta parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsenam waquin caqna sharcur Jesuspa contran ulicurcur queno niyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Noqacunam que nuna queno parlaqta wiyayarqö: ‘¡Nuna rurashqan que templuta ushacäratsirmi, quima junaqllata juctana sharcaratsishaq! Y tse temploqa manam nunacuna rurayashqannonatsu canqa’ neqtam wiyayarqö. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tseno tuquinopa shimpirpis, manam jucllellataqa parlayarqantsu acusayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tseno acusayaptinnam, mas mandacoq saserdoteqa chopincunaman sharcur Jesusta queno taporqan: —¿Manacu imallatapis parlacurinqui, contrequi parlar acusecayäshuptiqui! ");
INSERT INTO qwhNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tseno niyaptinpis, Jesusqa upällallam cacorqan; manam imatapis contistarqantsu. Tsenam mas mandacoq saserdoti yape queno taporqan: —¿Qamcu canqui bendito Diospa Acrashqan tsurin? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tsenam Jesus nerqan: —Aumi, noqam cä. Ime junaq carpis, Diospita Shamushqa Nunata ricariyanqui puedeq Diospa derechu laduncho tëcaqtam, y pucute rurincho sielupita shamicaqtam. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesus tseno nïcuptinnam, tse mas mandacoq saserdoteqa allapa piñar, sotanantapis rachiricorqan, y quenomi nerqan: —¿Imapaqnataq mas testigucunatapis munantsic! ");
INSERT INTO qwhNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Wiyayarqonquim Diospa contran parlanqanta! ¿Queta imanecuntsictaq! —nir. Tsenam llapancuna juc shimilla wanunanpaq condenariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tsenam waquin nunacuna qallecuyarqan toqapur. Waquinnam nawinta bendarcur maqar, y quenomi niyarqan: —Mä, adibinë, ¿pi laqyashonqequitapis! —nir. Tsenollam templu täpaqcunapis qaqllancho laqyayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ruri patiucho Pedru quecaptinnam, mas mandacoq saserdoticunapa empliadan chärerqan ");
INSERT INTO qwhNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedruta ninacho qoñücur tëcaqta cösa ricapëcurnam queno nerqan: —Qampis taqe Nazaret marcapita Jesuswan pureqmi canqui, ¿au? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peru Pedrunam negarnin nerqan: —¡Pipaqraq parlacunqui, manam reqïtsu! —nir, jaq puncumanpa eucorqan. Tsecho quecaptinnam, gallu cantarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Puncucho Pedruta shëcaqta riquecurninnam, jina tse empliada tsecho nunacunata queno nerqan: —Que nunapis Jesusta qatirashqam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedrunam jina yape negarerqan. Tsepita mas ratutanam tsecho quecaq nunacuna queno niyarqan: —Qamqa rasonpam pewan purishqanqui. Galilea nunam canqui, ˻y pecunanomi parlanquipis˼ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tsenam Pedroqa allapa pësacur jurarnin queno nerqan: —¡Manam ari tse nunata reqïtsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tseno nicaptinllanam, yape gallu cantarerqan. Pedroqa yarpäcurcorqan, “Manaraq gallu ishque cuti cantaptinmi, quima cuti negamanqui” nir, Jesus nenqantam. Tseta yarpäcurcurmi, Pedru allapa llaquicurnin waqaquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Patsa atsicyärëcaptinnam, Corti Supremacho caqcuna: saserdoticunapa mandacoqnincunaqa, respetashqa auquincunawan, ley yachatsicoqcunawan y llapan autoridacunawan sesiunarir, Jesuspa maquinta pancarcur gobernador Pilatuman apar entregariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chäratsiyaptinnam, Jesusta Pilatu queno taporqan: —¿Qamcu canqui israel nunacunapa reynin? —nir. Jesusnam yasquirerqan: —¡Nicanquinataq ari! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tsechomi saserdoticunapa mandacoqnincuna tuquilayapa lebantarnin Jesusta acusecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tsenam Pilatu yape queno nerqan: —¿Imanirtaq wiyaräcunqui tselaya acusecayäshuptiqui? ");
INSERT INTO qwhNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tseno niptinpis, Jesusqa upällam cacorqan. Tsemi Pilatu espantashqa quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada watam tse Pascua fiestacho nunacuna mañacuyaptin juc presuta libri cachariyaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tsepinmi Barrabas nishqan nuna yanaqincunawan carselcho llawirëcayarqan. Pecunam Roma gobiernupa contran carnin, nunacunata wanicatsishqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tsemi Pilatuman atscaq nunacuna ewecur, costumbrinmanno rurananpaq mañacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatunam taporqan queno nishpa: —¿Israel nunacunapa reynintacu cacharinäta munayanqui? ");
INSERT INTO qwhNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tseno nerqan Pilatu, tse saserdoticunapa mandacoqnincuna Jesusta chiquirnin, acusar peman entregayanqanta cuentata qocurninmi. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Peru saserdoticunapa mandacoqnincunam nunacunata yachatsiyarqan “Barrabasta cacharinequitam munayä” niyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tseno niyaptinnam, Pilatu queno nerqan: —Israel nunacunapa reynin niyanqequitaqa ¿imatataq rurashaq? ");
INSERT INTO qwhNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nunacunanam qayaripa niyarqan: —¡Petaqa cruscho wanutsï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tseno niyaptinnam, Pilatu queno nerqan: —¿Ima mana allitataq rurashqa? —nir. Peru nunacunanam “¡Cruscho wanutsun!” nishpa, qaparicachäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsenam israel nunacunawan alli quedeta munarnin, Barrabasta cacharerqan, y Jesustanam alli buenu astaratsirnin, entregarerqan crusificayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tsenam soldaducuna Jesusta jeqaratsiyarqan palasiupa “Pretorio” nishqan patiunman. Tsechonam llapan soldaducuna juntacariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesustanam puca mantuta aqshuratsiyarqan, y cashapita coronata awarir tsucuratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsepitanam burlacurnin, queno niyarqan: —¡Biba israel nunacunapa reynin! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tsepitanam shucshuwan peqan peqan wilur ushayarqan, toqapuyarqan y qonqurïcuryan adoraq tucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tseno allapa maltratarirnam, aqshutsiyanqan granati mantuta qoturatsir quiquinpa ropantana yacarcatsir, apayarqan crusificayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tseno aparëcarninnam, topariyarqan chacrapita shamicaq juc nunawan. Pepam shutin carqan Simon. Tse nunatam Jesus apecanqan crusta malas catätsiyarqan. Tse nunaqa Cirene marcacho yuricoqmi carqan, Alejandrupa y Rufupa papänin. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tsepitanam Golgota niyashqan sitiuman Jesusta chäratsiyarqan. (Golgotaqa calabera ninanmi). ");
INSERT INTO qwhNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tsechonam mirra nishqan jampita binuman awayarqan Jesusta uputsiyänanpaq, peru manam uporqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Crusman clabarirnam, soldaducuna Jesuspa ropanta apacuyänanpaq sortiyayarqan, “Mä, ¿meqantsictash tocamäshun?” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesusta crusman clabayanqan öraqa carqan qoya las nuebinonam. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Imanir crusificayanqanta nunacuna musyayänanpaqmi, cruspa puntanman juc letreruta churayarqan, “Quemi israel nunacunapa reynin” nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Petawan juntum ishcaq suwacunatapis crusificayarqan, jucta derechu ladunman, jucnintana itsoq ladunman. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","˻Tsenomi cumplicärerqan Diospa palabran queno escribirëcanqan: “Jutsasapacunatawan iwalmi Diospa tsurinta tratayanqa” nir.˼ ");
INSERT INTO qwhNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tsepa pasaq nunacunanam peqancunata awir cushipäyarqan, queno nishpa: “¡Qamqa, ‘Diospa templunta juchurirmi, quima junaqllata sharcatsishaq’ nishpataq, nerqequi! ");
INSERT INTO qwhNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tseno nicarqa, mä, salbacurirnin cruspita yarparamï.” ");
INSERT INTO qwhNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tsenollam jina saserdoticunapa mandacoqnincunapis y ley yachatsicoqcunapis Jesusta burlacurnin, queno niyarqan: —¡Juccunataqa salbashqam; peru quiquenqa salbaquita manataq puedintsu! ");
INSERT INTO qwhNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel nunacunapaq Dios Acrashqan rey carnenqa, cruspita yarpamï, tseta ricarnin creyiyänäpaq —nir. Y laduncho crusificarëcaqcunapis tsenollam burlacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tse öraqa pullan junaqnam carqan. Tse örapitam asta lastrescamayaqmi patsa pasepa paqasyäcurcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tse öram Jesus fuertipa queno nir qaparïcorqan: —Eloi, Eloi ¿lama sabactani? (Tse ninanqa carqan “Dios, Dios, ¿imanirtaq noqata jaqiramarqonqui?” ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tseta wiyarnam, tsecho quecaq waquin nunacuna queno niyarqan: —Une profeta Eliastam qayecan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Juc nunanam coripa ewar esponjata puchqoq binuman tullpurcur shoqushpa puntanman watarcur, Jesuspa shiminman churarqan shoqunanpaq queno nishpa: —Mä, ¿rasonpacush Elias shamonqa cruspita yarputsinanpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsellanam fuertipa qayaricur, Jesus wanurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tse öram templu rurincho tsaparaq cortina umapita urepa ishqueman qashqacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldaducunapa capitanninnam Jesuspa frentincho quecarqan. Tseno qayarir wanoqta riquecurnam, queno nerqan: —¡Que nunaqa rasonpam Diospa Tsurin cashqa! ");
INSERT INTO qwhNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waquin warmicunapis carullapitam ricarëcayarqan. Pecunawanmi quecayarqan Maria Magdalena y menor caq Santiagupa y Josepa maman Mariapis y Salomepis ");
INSERT INTO qwhNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tse warmicunam Jesusta qatimushqa cayarqan, y Galileachopis Jesusta pecunam yanapayarqan. Jina pecunawanmi atscaq warmicunapis Jerusalenman shayämushqa cayarqan Jesusta qatirnin. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tse tardeqa carqan jamacuyänan junaqpa dispirannam. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tse tardim Arimatea marcapita Jose jutiyoq autorida balorta tsarïcur Pilatuman ewarqan, Jesuspa ayanta mañananpaq. Pëqa Sanhedrin nisqhan corticho allapa presisaq autoridami carqan, y Diospa mandaquinintam shuyararqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatunam “¿Wanurishqanatsuraq?” nir, yarpacacharqan. Tsemi soldaducunapa capitanninta qayarir queno taporqan: —¿Wanurishqanacu tse nuna? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Capitan “Aumi” niptinnam, Jesuspa ayanta apacunanpaq Joseta änirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tse öram Jose linu sabanasta rantirir Jesuspa ayanta cruspita yarparatsirnin, tse sabanaswan pitorqan, y apacurnam pampecorqan qaqacho uchcushqa sepulturaman. Tsepitanam sepulturapa puncunta qaqawan alli buenu tsapecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meman pampayashqantapis Maria Magdalenam y Josepa maman Mariam ricarëcayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jamaqui junaq pasariptinnam, Maria Magdalena, Santiagupa maman Maria, y Salome nishqan warmi pucutaq perfumi ranteq ewayarqan Jesuspa ayanta llushiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingu qoyanam inti tseraq yarqarëcamuptin tse warmicuna ewayarqan Jesus pamparanqanman. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yecurëcarnam, queno ninacuyarqan: —¿Canan piraq wititsimonqa sepultura tsaparaq qaqata? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Peru chärirnam, taririyarqan qaqataqa juc laduchona quecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sepultura ruriman yecurirnam, riquecuyarqan chaquincamayaq yulaq püru bistishqa derechu laducho jobin tëcaqta. Tsenam allapa mantsaquecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jobinnam queno nerqan: —Ama mantsacäyëtsu. ¿Cruscho wanutsiyanqan Nazaretpita Jesustacu ashiyanqui? Pëqa cawarimushqanam; mananam quechonatsu. Masqui ricayë, churayashqancho mananam cannatsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Masbien canan ewarnin, Pedruta y waquin disipuluncunata willayë Jesus cawarenqanta; y qamcunapitapis mas puntatash ewan Galilea marcata. Tsechoshi ricayanqui. Tseno cananpaq caqtaqa pecunata willarqannam —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tseno nïcuptinnam, warmicunaqa sepulturapeq coripa yarcur ewacuyarqan. Tulluncunapis carcaryaquicarqam, y manam pitapis tse ricayanqanta willacuyarqantsu mantsacurnin. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","˻Tse cawarimonqan domingu qoyaqa puntata yuriporqan Maria Magdalenatam. Petam qanchis supëcunapa munenincho caquicaptin Jesus librashqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tse Mariam ewar Jesuspa qatiraqnincunata willarqan Jesus cawarishqanta. Pecunaqa llaquishqam waqaquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesus cawarishqanta ricashqanta Maria willacuptinpis, pecunaqa manam creyiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsepitanam ishcaq qatiraqnincunata chacraman euquicayaptin jalla tucurishqalla Jesus yuriporqan. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yuripicuptinnam, Jerusalenman cuticuyarqan waquincunatapis willayänanpaq, y manam pecunatapis creyiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsepitanam chunca juc (11) disipuluncunatana micur tëcayaptin Jesus yuriporqan, y piñapäcacharcorqan cawarimushqanta ricaqcuna cutïcuryan willecayaptinpis, rumi shonqu carnin mana creyiyanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tsepitanam queno nerqan: —Jinantin marcacunapa ewarnin, llapan nunacunata que alli willaquinïta willayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipis tseta creyirnin, bautisacorqa salbaconqam; mana creyicoq caqqa condenaconqam. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Noqaman creyicoqcunaqa que milagrucunatam rurayanqa: Podernïwanmi supëpa munenincho caquicaq nunacunata librayanqa, mana yachayanqan parlecunatam parlayanqa, ");
INSERT INTO qwhNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","biborapis tsariyaptin manam imanayanqatsu, y benenuta upurcatsiyaptinpis, manam wanuyanqatsu. Tsenollam qeshyaqcunaman maquincunata churarnin cachacäratsiyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Disipuluncunata tseno llapanta encargariptinnam, Teyta Jesusta sieluman Dios apacorqan. Tsepitanam tärätserqan derechu caq ladunman juntu mandacuyänapaq. ");
INSERT INTO qwhNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tsepitanam apostolcuna eucur mecho tsechopis alli willaquininta willapäcuyarqan. Pecuna willacuyaptinmi, Jesucristu yanaparqan milagrucunatapis rurayänanpaq. Tseta ricarmi, nunacuna cuentata qocuyarqan tse willacuyashqan Teyta Diospa rasonpa willaquinin cashqanta. Tseno catsun.˼");
INSERT INTO qwhNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Cuyë reqishqa Teofilo, Diosnintsic que tiempucho imapis rurashqancunatam atscaq nunacuna escribiyashqana cayänaq. Tse escribiyashqanqa Jesuspa disipuluncuna yachatsimashqantsicnollam. Pecunam Jesuswan qallanqanpita purir, wiyashqa y ricashqa car, rasonpa testigoqa cayan. Tsenollam noqapis yachatsicuyanqanta wiyarir y escribiyashqancunata leyirir, qallananpita llapanta alleq musyarir, qamman escribimü. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tsemi qampis queta leyirirnin, musyanqui yachaconqequi rasonpa canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea marcacho Herodis nishqan rey quecaptinmi, carqan juc saserdoti Zacarias jutiyoq; y warminnam carqan Isabel. Ishcanpis cayänaq Dios sirweq saserdoticunapa castan: Zacarias Abiaspa, Isabelnam Aaronpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ishcanpis Diospaq alli ruraqllam cayarqan, Dios mandacushqancunata imachopis cäsucurnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Manam wamrancuna carqantsu, Isabel qolloq car; mana wawata reqiptin, y tsatsayäcushqanam cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Juc cutinam Zacariasta saserdoti mayincunatawan tocayarqan Jerusalen templucho Diosta sirwiyänan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Costumbrincunamannomi saserdoticuna sortiyayarqan, y Zacariastam tocarerqan altarcho insiensiuta qoyätsinanpaq. Tsenam templu ruri sagradu cuartuman yecurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Insiensiuta qoyätsenqanyaqnam waqtacho atscaq nunacuna Diosman mañaquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tseno quecaptinnam, insiensiuta qoyätsiyänan altarpa derechu laduncho Dios cachamushqan anjel yuripïcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anjelta riquecurninnam, Zacarias allapa mantsacar, imano quetapis puederqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anjelnam queno nerqan: —Zacarias, ama mantsaquëtsu. Dios wiyashqam mañaconqequicunata; warmiqui Isabelchomi ollqu tsuriqui yurenqa. Pepa jutinmi churanqui “Juanta”. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pe yuririptinmi, allapa cushicunqui; y waquincunapis allapam cushicuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Diospa nopanchopis baleq nunam canqa. Manam imepis binuta ni washcucunata uponqatsu, manaraq yuricushqanpita Santu Espirituwan carnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Perecurmi Diosta atscaq israel nunacuna yape cäsucuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Teytallantsic shamunanpaqmi Santu Espiritupa poderninwan Eliasno yachatsiconqa. Tseno yachatsicuptinmi, papänincuna tsurincunawan amishtayanqa. Y puntata Diosta mana cäsucoqcunam cäsucuyanqa. Tsenam nunacuna listuna cayanqa Teytallantsicta chasquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacariasnam anjelta queno taporqan: —¿Imanotaq nimanqequeqa canqa? Noqaqa allapa auquinnam cä, y warmïpis tsatsanam. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tsenam anjel queno nerqan: —Noqaqa Gabrielmi cä, Diospa sirweqnin. Pemi cachamashqa que alli notisiata willanaqpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Willashqaqnollam pasaconqa, y mana creyimanqequirecurmi, pe yuriconqanyaq mudu ticrarinqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Anjel parlapanqanyaqnam, waqtacho nunacuna Zacariasta shuyaräyarqan, queno nishpa: —¿Imanirraq templupita yarqamuntsu? ");
INSERT INTO qwhNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarias yarqurirnam, parleta puederqantsu. Nunacunanam ninacuyarqan: —¡Ruri templuchochi Dios imatapis ricatsishqa! Zacariasnam muduyashqa carnin, señasllawan parlarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Templucho sirwir ushapäcurirnam, wayinman cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tsepitanam warmin Isabel qeshyaq tucurerqan. Pitsqa quillam wayinllacho cacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tsemi queno nerqan: —Dios yanapamaptinmi, queno quecä. Cananqa mananam nunacuna penqapäyämanqanatsu, “mana wachacoq warmi” nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel joqta quillayoqna qeshyaq quecaptinnam, anjel Gabrielta Dios cacharqan Galileacho Nazaret marcaman ");
INSERT INTO qwhNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Maria nishqan donsellaman. Tse warmeqa casacuyänanpaq parlashqanam cayarqan une rey Davidpa castan Jose jutiyoq nunawan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anjelnam Maria quecanqanman yurircur, nerqan: —¡Cushiquï, Maria! Dios acrashqanmi canqui. Pemi qamwan quecan. ˻Waquin warmicunapitam qamtaqa Dios acrashorqonqui.˼ ");
INSERT INTO qwhNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anjel tseno niptinnam, Maria mantsacar shonquncho, queno nerqan: —¡Imanirraq anjel tseno niman! ");
INSERT INTO qwhNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anjelnam nerqan: —Maria, ama mantsaquëtsu. Diosmi qamta acrashorqonqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tsemi qeshyaq tucunqui. Y ollqum wamrequi canqa. Yuricuriptinmi, jutin churanqui “Jesusta”. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pemi allapa puedeq canqa, y sielucho Diospa tsurin nishqam canqa. Pepa une awilitun Davidta mandacoq cananpaq churashqannollam, Jesusta Dios churanqa mandacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel nunacunapa mandacoqninmi canqa imecamayaqpis; y pepa mandaquinenqa manam ushacanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsenam anjelta Maria taporqan: —¿Imanotaq tse nimanqequi canqa? Noqaqa donsellam cacü. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anjelnam nerqan: —Santu Espiritu qamman shamurninmi, camanqa juc wamrata, sielucho quecaq Diospa poderninwan qeshyaq tucurinequipaq. Santu wawequinam Diospa tsurin canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Musyë, primequi Isabelpis tsatsa queninchomi “mana wachacoq” nicayaptinpis joqta quillayoqna qeshyaq quecan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porqui Diospaqqa manam imapis sasatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsenam Maria nerqan: —Noqaqa Diospa sirweqninmi cä. Qam nimanqequino callätsun. Tsenam anjel eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tsepeqnam Maria ajalla alistacurir, Judea marcapa jallqanman Isabel caqta eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacariaspa wayinman yecurirnam, Isabelta taririr, saludarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria tseno saludariptinnam, Isabelpa pachancho wamra cushicurnin cuyorqan. Isabelnam Santu Espiritupa poderninwan ");
INSERT INTO qwhNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","fuertipa queno nerqan: —Waquin warmicunapitapis qamtam Dios bendisishorqonqui, y wawequipis benditum. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitaq noqallä cä, Dioslläpa mamänin watuquecamänequipaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludamanqequita wiyariptïmi, pachächo wamra cushicurnin cuyushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios nishonqequi cumplicänanpaq caqta creyinqequirecurmi, bendisishqa canqui, nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsenam Maria queno nerqan: “Diostam noqa allapa alabecü. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Salbamaqnï Diospaqmi shonqullä allapa cushicun. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Qollmi shonqu sirweqnin canqätam, pe ricamashqa. Cananpita witsepanam llapan nunacuna willanacuyanqa Dios bendisimashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diosmi puedeq queninwan, noqapaq allicunata rurashqa. Pëqa santu carmi, allapa alli. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mandacushqancunata wiyacoqcunatam Dios ancupan; castancunatapis ancupanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Puedeq queninwanmi ima sasa caqcunatapis ruran. Alli tucoqcunatam mana baleqpaq churan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandacoqcunatam mandacuyanqanpita qarqurerqa, qollmi shonquyoqcunatanam mandacuyänanpaq churarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wactsacunatanam imecanpis qoycorqan. Ricucunapataqa llapannintam ushacäratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sirweqnin israel nunacunatam ancuparnin, ");
INSERT INTO qwhNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","une awiluntsic Abrahamta castancunatawan änerqan, imecamayaqpis ancupänanpaq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tsecho Maria Isabelwan quima quilla täcurirnam, wayinman cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabelpa quillan tincuriptinnam, qeshpicurerqan juc ollqu wamrata. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tseta besinuncuna castancunawan musyarirninnam, Isabelman ewar allapa cushicuyarqan, “Diosmi ancuparnin, wawan qoycushqa” nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wamra semanayoq quecaptinnam, shayämorqan señalatseq. Tsechonam papänin Zacariaspa jutinta chureta munayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Peru mamäninnam queno nerqan: —¡Ama! ¡Jutenqa Juanmi canqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nunacunanam niyarqan: —¿Imanir? ¡Castequicunacho manataq pipis cantsu Juan jutiyoq! ");
INSERT INTO qwhNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tseno nirninnam, Zacariasta señasllapa tapuyarqan: —Tsuriquipa jutin ¿imatataq churanqui? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tsenam ichic tablata mañacurir, escribirerqan queno: “Jutenqa Juanmi canqa” nishpa. Tseta leyirirnam, nunacuna mantsacashqa quedariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tsellanam Zacarias parlar qallecorqan, Diosta alabarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jinantin Judea jirca marcacunachomi nunacuna mantsacashqa willacuyarqan tse llapan pasacushqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tseta wiyarirnam, yarpacacharnin queno ninacuyarqan: —Tse wamraqa ¿imano caqraq canqa, Diospa muneninwan quecarnin? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Papänin Zacariasnam Santu Espiritupa poderninwan queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel marca mayicuna, llapantsic grasiasta qor, ¡alabashun Diosnintsicta! Pemi noqantsicta rescatamarnintsic, salbamäshun. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Salbamänantsicpaqmi Diospa sirweqnin une rey Davidpa castancho, juc puedeq salbador yuricunanpaq quecan. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Que salbador yuricunanpaqmi Diosnintsic änicurnin, une profetancunatawan willacatsimorqan, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Chiquiyäshoqniquicunapitam noqa jorquyashqequi y salbayashqequi’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Une castantsiccunata ancuparninmi, tse änenqanta Dios canan cumplenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Une awiluntsic Abrahamtam Dios änerqan ");
INSERT INTO qwhNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chiquimaqnintsiccunapita salbamänantsicpaq, y pellatana mana mantsacushpa sirwinantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tsemi pellapaqna car allicunata rurarnin, cawenintsiccho sirwishun. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y qam llullu wamra, sielucho quecaq Diospa profetanmi canqui. Diospa tsurin shamunanpaqmi puntata ewar, nunacunata willapanqui, ");
INSERT INTO qwhNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","queno nishpa: ‘Israel nunacuna jutsa rurayashqequicunapitam, Dios perdonayäshurniqui, salbayäshunqui’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diosmi allapa ancupämarnintsic, imeca inti qoyapa yarqamoqtano cachamonqa actsimänantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsemi paqascho cawaquicaqcunapaq, y wanita mantsaquicaqcunapaq actsin canqa. ¡Tsenam shumaq cawacushun Diospa cushiqui nänincho!” Quecunatam Zacarias willacorqan salbadorpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tsepitanam jentiyarnin, Juan allita ruraq carqan. Tsunyaqcunachomi täcorqan, manaraq israel nunacunata willapar. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tse junaqcunam, Augustu cesar mandacorqan jinantin munducho llapan nunacuna sensashqa cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Que sensutam rurayarqan Siria probinsiacho Sirenio nishqan gobernador quecaptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Llapan nunacunam ewayarqan une castancunapa marcancunaman sensashqa cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tsemi Galileacho Nazaret marcapita Josepis allapa caruta ewarqan, Judeacho Belen marcaman. Porqui une awilun rey Davidmi tsecho yuricushqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mariatapis pusharqanmi Belen marcaman sensacoq, casacuyänanpaq parlashqana carnin. Mariaqa qeshpicunanpaqnam quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tsecho quecayaptinnam, Mariapa qeshpicunan quilla tincuriptin, pachan tsaripïcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Posadacuyänanpaq wayita mana tarirninmi, animalcuna wataränan rämadallacho wamaqshu wawanta qeshpiquïcorqan. Ayurirnam, animalcunapa micucuyänanllaman iscaratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tse paqasmi Belen marcapa wac laduncho üshancunata mitseq nunacunapis täpaquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsemanmi illaqpita anjel yurircuptin, y Diospa poderninwan imeca relampaguno limpu actsïcuptin, täpacoqcuna mantsaquecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anjelnam queno nerqan: —Ama mantsacäyëtsu. Llapan nunacunawan cushicuyänequipaqmi, canan willayashqequi: ");
INSERT INTO qwhNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Une rey Davidpa marcan Belenchomi salbayäshoqniquicuna canan yuricurishqa. ¡Pëqa Teytantsic Dios Acrashqanmi! ");
INSERT INTO qwhNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Diospita rasonpa canqanta musyayänequipaqmi, canan ewar, llullu wamrata tariyanqui animalcunapa micucuyänancho ayuwan pitushqa iscarëcaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anjel tseno nicaptinnam, juclla atscaq anjelcuna yurircur, Diosta alabarnin, queno niyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Sielucho Dios, alabecuyaqmi! ¡Cananpitam que patsacho Dios cushitseqcuna alli pasaquichona cayanqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tseno nirirninnam, anjelcuna sieluman cuticuyarqan. Mitseqcunanam queno ninacuyarqan: —¡Dios willatsimanqantsicno acu jinallacho Belen marcaman ewar, ricamushun! ");
INSERT INTO qwhNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jicutellapa ewarnam, taririyarqan Joseta, Mariata y llullutanam animalcunapa micucuyänanllacho iscarëcaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tseta ricarirnam mitsicoqcuna willacuyarqan llullupaq anjel llapan nenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Niyanqanta wiyecurnam, nunacuna espantacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Peru Mariaqa shonqunllachomi tsecunapaq llapanta yarpacachar cacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mitseqcunanam anjel willaconqannolla llulluta ricarir, queno nishpa cushishqa cuticuyarqan: “¡Diosqa allapa allim! ¡Grasiastam qonantsic!” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wamra semanayoq quecaptinnam, papänin mamäninwan señalatsiyarqan. Jutinnam churayarqan Jesusta, manaraq qeshyaq captin anjel yuripur nenqannolla. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moises mandacushqan ley nenqanno limpiu cayänanpaq junaqcuna tincuriptinnam, Josewan Mariapis ewayarqan Jerusalencho templuman llullunta Diosman presentayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tseno rurayänanpaqqa Diospa palabranmi queno escribirëcan: “Wamaqshu ollqu tsuriqueqa Diosllapaqmi canqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dios mandacushqan leymi escribirëcan: “Ishque cullcuta o ishque llullu palumacunata qarayämanqui” nishpa. Que leytapis cumpleqmi Jose Mariawan ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalenchomi juc nuna tärarqan, Simeon jutiyoq, Diosta allapa cuyaq nuna. Pemi allillata rurar, shuyararqan Israel nasion librashqa cananta, y Teyta Diospa Santu Espiritunmi pewan carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tsemi Santu Espiritu jucpin musyatserqan: “Dios Acrashqanta ricarirninran, wanunqui” nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tsenam Santu Espiritu pushaptin, tse junaq templuman ewarqan. Tsemannam Jesusta chäratsiyarqan Jose Mariawan ley mandacushqanno rurayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Wamrata ricarirninnam, mellqarcur Diosta alabarnin, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Diosllä, noqa sirweqniquita änillämashqequitam canan cumplirillarqonqui. Canan si, cushishqana wanuculläshaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","¡Salbayämaqnïta ricarillätaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Qam nenqequinomi jinantincho nunacunata pe salbanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jinantin nasion nunacunapaqpis actsi cuentam canqa. Perecurmi, sirwishoqniqui israel nunacunapis allapa reqishqa cayanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Llullupaq Simeon nishqanta papänin mamäninwan wiyarninnam, espantacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tsenam pecunata Simeon nerqan: —Dios qamcunata bendisicuyäshi. Jesuspa mamänintanam nerqan: —Que wawequirecurmi, waquin israel nunacuna condenacuyanqa; waquin caqcunanam allicho yarquriyanqa. Pëcho Dios milagrunta ricatsiquicaptinpis, manam chasquiyanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tsenomi nunacuna musyatsicuyanqa shonquncunacho imanopis cayanqanta. Peru qamnam Maria, perecur jipanqui imeca cutsilluwan shonqiquita tucsicayämuptin nanatsicoqno. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tsechomi juc tsatsa warmipis carqan Diospa profetan, Ana. Pëqa carqan une awilun Aserpa willcanmi. Papäninnam carqan Fanuel. Shipashlla casaconqanpitam qanchis watalla qowanwan täräyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Qowan wanuriptinnam, japallan täcorqan y puwaq chunca chuscu (84) watayoqmi carqan. Templullachomi paqaspa junaqpa ayunar, Diosman mañacur cacoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tseman Ana chärirnam, wamrata ricarir, nerqan: —Dios, qamtam allapa agradisicoq que wamrapaq —nir. Nunacunatanam nerqan: —Que wamram noqantsic israel nunacuna unepita shuyaconqantsic, y pemi rescatamarnintsic salbamäshun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tsepitanam Dios mandacushqan leycunata Jose Mariawan rurar usharirnin, Galileacho Nazaret marcancunaman cuticuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wamranam winarnin, allapa yacheyoq carqan, y Diosmi imecachopis peta yanaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cada watam Jerusalenman Jose Mariawan ewayaq Pascua fiesta pasaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus chunca ishque (12) watayoq quecaptinnam, israel nunacunapa costumbrincunamanno Pascua fiestaman ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tse Pascua fiesta ushariptinnam, marcancunaman cuticuyarqan. Jesusnam Jerusalencho quedacushqa canaq, Jose y Maria mana mäcuyanqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pecuna pensayänaq: “Que atscaq nunacunawanchi shamican” nishpash. Qanyasninpi ewecarnam, pullan nänicho tardiyäquicuptinna, Jesusta ashiyarqan, castancunata y reqinacuyashqancunata tapucurnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tarirninnam, tsellapeq Jerusalenman cuticuyarqan ashirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quima junaq ashiyanqanchonam, Jesusta templucho taririyarqan, ley yachatsicoqcunapa chopincho pecunata wiyar, tapuparnin tëcaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesus alli yachaq car, tapuyanqancunata imano shumaq yasquiptinmi, wiyaqnin llapan nunacunapis espantacur, imano quetapis puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesusta ricarirnam, papänin y mamänin espantacuyarqan. Mamäninnam nerqan: —Ä, wawä, ¿imanirtaq queta rurayamanqui? Allapa llaquishqam papäniquiwan ashiyarqoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tsenam Jesus nerqan: —¿Imanirtaq ashiyämarqonqui? ¿Manacu musyayanqui Papänïpa munenincho quecanä presisanqanta? ");
INSERT INTO qwhNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tseno nenqanta pecuna manam ichicllapis cäyiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsepitanam pecunawan Nazaretman cuticorqan, mandayanqancunata rurarmi carqan. Mamäninnam shonqunllacho llapan pasanqancunata yarpacacharqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesusnam winar jentiyarnin, alli yachaq carqan. Diospaq y nunacunapaqpis allapa allim carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio jutiyoq cesar chunca pitsqa (15) watana Romacho mandacoq quecaptinmi, Poncio Pilatu Judea probinsiacho mandacoq quecarqan, Galilea probinsiachonam Herodis, Iturea y Traconite probinsiacunachonam Herodispa wauqin Felipi, Abilinia probinsiachonam Lisanias. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jerusalenchonam Anas y Caifas mas mandacoq saserdoticuna quecayarqan. Tsepinmi tsunyaqcho Zacariaspa tsurin Juan quecaptin Dios palabranta peta rebelar qallarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsemi Jordan mayu cuchun marcacunapa purirnin, nunacunata willaparqan jutsancunata jaqirir, bautisacuyänanpaq, y tsenopa perdonashqa cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tseno Juan willacunanpaqmi Diospa une profetan Isaias queno escribishqa carqan: “Tsunyaqchomi juc nuna qayaripa queno willaconqa: ‘Nänicunata derechar limpiaq cuenta prebinicuyë Teytata chasquiyänequipaq, ");
INSERT INTO qwhNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","feyu nänicunata parejaqno, jircacunata pampatsaqno, wicsu nänicunata derechaqno, rumi rumi nänicunata limpiaqno, prebinicuyë chasquiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jinantin marcacunachomi llapan nunacuna musyayanqa, Diospita salbasion chämushqanta.’ ” ");
INSERT INTO qwhNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tsenam bautisacuyänanpaq nunacuna Juanman ewayaptin, waquincunata nerqan: —Ä, bibora cuenta nunacuna, ¿imanopataq allapa feyu castigupita salbacuyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jutsa rureniquicunata rasonpa jaqirïcur, allicunatana rurayë. Ama nicachäyëtsu: ‘Abrahampa castan canqantsicrecurmi castigupita salbacushun’ nir. Porqui niyaqmi: Diosqa que rumicunatapis Abrahampa castanqa ticraratsinmanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Imanomi juc nuna jachanwan mana wayücoq montita siquipita wallurir, ninacho ushacäratsin, tsenomi llapan mana alli ruraqcunapaqqa Dios listu quecan ushacäratsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tseno niptinnam, nunacuna tapuyarqan: —Tseno captenqa, ¿imatataq rurayäshaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juannam nerqan: —Ishque camsequi cayäpushuptiqueqa, mana capoqta qoycuyë. Micunequicuna captinpis, mallaqecaqcunata qarecuyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Impuestu cobraqcunanam Juanman witiyarqan bautisacoq, queno tapurnin: —Mayestru, ¿imatataq noqacunaqa rurayäshaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tsenam Juan nerqan: —Contribusionllata cobrayanqui. Ama mastaqa cobracuyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tsenollam soldaducunapis ewar, tapuyarqan: —Noqacunaqa, ¿imatataq rurayäshaq? Pecunatanam nerqan: —Ama nunacunapa imancunatapis malas qochiyanquitsu, ni ulicurcur lebantacuyanquitsu. Pagayäshushqequiwan conformi cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tsenam nunacuna cushishqa quiquincunallacho queno niyarqan: —Shuyaconqantsic Dios Acrashqanchi pëqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tsenam, Juan queno nerqan: —Noqaqa yacullawanmi bautisayaq; peru jucmi shamun noqapita mas puedeq. Noqaqa manam sirwïtsu qonqurïcur pepa llanqinpa watunta pascarillatapis. Pëqa ninano rupecaqwan bautisayäshurniquim, Santu Espiritunta qoyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ichicllanam pishin, imeca eracho triguta wauyaqno nunacunata pe acrananpaq. Trigutam wardacunanman wardanqa y pajatanam mana upeq ninacho cayeconqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tseno nirninnam, tuquilayapa nunacunata yachatserqan Diospa alli willaquininta. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tsepitanam mandacoq Herodista llapan mana alli rurenincunapita Juan piñaparnin nerqan: —Ama wauqiquipa warmin Herodiaswan wätanaquïtsu. ¡Tseqa manam allitsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tseno niptinmi, mana alli ruranqancunapita mas mana allita rurar Herodis carselman Juanta llawiratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","˻Peru manaraq Juanta Herodis presu tsaritsiptinmi,˼ llapan nunacuna bautisacuyanqancho Jesuspis bautisacorqan. Tsechonam Diosman Jesus mañacuptin, sielupita ");
INSERT INTO qwhNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","imeca palumano Santu Espiritu urämur, Jesusman chämorqan. Sielupeqnam Dios queno nimorqan: —Qammi cuyë tsurï canqui. Qamrecurmi allapa cushicü —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus quima chunca (30) watayoq quecarninnam, pepa willaquinincunata nunacunata willapar qallecorqan. Tsenam parlayarqan queno: “Jesusqa Josepa tsurinmi.” Joseqa Elipa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eleqa Matatpa tsurinmi. Matatqa Levipa tsurinmi. Leveqa Melquipa tsurinmi. Melqueqa Janaipa tsurinmi. Janaeqa Josepa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseqa Matatiaspa tsurinmi. Matatiasqa Amospa tsurinmi. Amosqa Nahumpa tsurinmi. Nahumqa Eslipa tsurinmi. Esleqa Nagaipa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaeqa Mahatpa tsurinmi. Mahatqa Matatiaspa tsurinmi. Matatiasqa Semeipa tsurinmi. Semeeqa Josecpa tsurinmi. Josecqa Joiadapa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joiadaqa Joananpa tsurinmi. Joananqa Resapa tsurinmi. Resaqa Zorobabelpa tsurinmi. Zorobabelqa Salatielpa tsurinmi. Salatielqa Neripa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nereqa Melquipa tsurinmi. Melqueqa Adipa tsurinmi. Adeqa Cosampa tsurinmi. Cosamqa Elmadampa tsurinmi. Elmadamqa Erpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erqa Jesuspa tsurinmi. Jesusqa Eliezerpa tsurinmi. Eliezerqa Jorimpa tsurinmi. Jorimqa Matatpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatqa Levipa tsurinmi. Leveqa Simeonpa tsurinmi. Simeonqa Judapa tsurinmi. Judaqa Josepa tsurinmi. Joseqa Jonampa tsurinmi. Jonamqa Eliaquimpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimqa Meleapa tsurinmi. Meleaqa Menapa tsurinmi. Menaqa Matatapa tsurinmi. Matataqa Natanpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanqa Davidpa tsurinmi. Davidqa Jesepa tsurinmi. Isaeqa Obedpa tsurinmi. Obedqa Boozpa tsurinmi. Boozqa Selahpa tsurinmi. Selahqa Nahasonpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasonqa Aminadabpa tsurinmi. Aminadabqa Arampa tsurinmi. Aramqa Hesronpa tsurinmi. Hesronqa Farespa tsurinmi. Faresqa Judapa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaqa Jacobpa tsurinmi. Jacobqa Isaacpa tsurinmi. Isaacqa Abrahampa tsurinmi. Abrahamqa Terahpa tsurinmi. Terahqa Nahorpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahorqa Serugpa tsurinmi. Serugqa Ragaupa tsurinmi. Ragaoqa Pelegpa tsurinmi. Pelegqa Eberpa tsurinmi. Eberqa Selahpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selahqa Cainanpa tsurinmi. Cainanqa Arfaxadpa tsurinmi. Arfaxadqa Sempa tsurinmi. Semqa Noepa tsurinmi. Noeqa Lamecpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecqa Matusalenpa tsurinmi. Matusalenqa Henocpa tsurinmi. Henocqa Jeredpa tsurinmi. Jeredqa Mahalaleelpa tsurinmi. Mahalaleelqa Cainanpa tsurinmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanqa Enospa tsurinmi. Enosqa Setpa tsurinmi. Setqa Adanpa tsurinmi. Adanqa Dios camashqanmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bautisacurirnam Jesus Santu Espiritupa poderninwan Jordan mayupita cuticorqan. Tsenam Santu Espiritu pusharqan tsunyaq jircaman. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tsechonam diablu chuscu chunca (40) junaqninpi Jesusta tenteta munarqan. Tse junaqcuna mana imatapis micurninnam, mallaqarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tsenam diablu nerqan: —Diospa tsurin rasonpa carqa, mä que rumita mandariquï tantaman ticrarinanpaq, nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesusnam nerqan: —Diospa palabranmi queno escribirëcan: ‘Manam tantata micurllatsu nunacuna cawayanqa; ˻sinoqa Dios llapan nenqanta cäsucurninmi˼’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsepitanam rara jirca puntanman Jesusta pushar, juclla riquecatserqan jinantin munducho nasioncunata, ");
INSERT INTO qwhNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","queno nishpa: —Que llapan nasioncunaqa maquïchomi quecan. Munarqa pitapis qoycümanmi. Tsemi shumaq queninta ricacunequipaq y tsecho mandacoq canequipaq qoycushqequi. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Peru que llapanta qoycunaqpaqqa; puntäman qonqurïcur, adorecamë. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tsenam Jesus nerqan: ˻—¡Quepeq yarqï, diablu!˼ Diospa palabranmi escribirëcan: ‘Diosllatam adoranequeqa y sirwinequeqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tsepitanam diabloqa Jesusta pusharqan Jerusalen marcaman. Tsechonam templupa mas altun caqman lloqarcatsir, queno nerqan: —Rasonpa Diospa tsurin carnenqa, mä, quepita jeqacurquï. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porqui Diospa palabranmi queno escribirëcan: ‘Anjelnincunatam Dios cachamonqa cuidayäshunequipaq, ");
INSERT INTO qwhNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","manaraq rumicunaman jeqaptiqui juclla tsaricuyäshunequipaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesusnam nerqan: —Diospa palabranmi jina queno escribirëcan: ‘Ama Diosniquita probanquitsu’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tseno Jesusta tenteta mana puedirninnam, diablu eucorqan yape cutinanpaq caqta yarparar. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tsepitanam Santu Espiritupa poderninwan Jesus Galileaman cuticorqan. Tsenam nunacuna jinantincho musyariyarqan Jesuspa rurenincunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Llapan marca chanqanchomi ellucayänan wayicho Jesus yachatsicoq. Tsemi nunacuna alabayaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsenam winaconqan marcan Nazaretman Jesus cuticur, costumbrinmanno jamaqui junaq ellucayänan wayiman ewarqan. Tsechonam Diospa palabranta leyinanpaq sharcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsenam Diospa profetan Isaias escribishqan libruta qoriyarqan. Jesusnam libruta quicharir, queno escribirëcaqta taririr, leyerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Diospa Espiritunmi noqacho. Pemi acramashqa wactsacunata alli willaquita willapänäpaq, ˻llaquishqacunata cushitsinäpaq,˼ presu cuenta caquicaqcunata libranäpaq, wiscucunata cachacätsinäpaq, y ancupëpaq sirwipacoqcunata libranäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y tsenolla que tiempucho Diospa ancupäquininta willayänaqpaq.” ");
INSERT INTO qwhNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tseno leyirirnam, libruta wichqarcur, ellucayänan wayicho yanapacoq nunata cutiratsirnin, täcurerqan. Tsecho quecaqcunanam Jesusta ricaräyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesusnam nerqan: —Wiyecayanqequi öram cumplicärerqon librucho escribirëcanqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tsecho llapan nunacunanam cushicur, queno ninacuyarqan: —Jesusqa allapa allim. Peru, ¡imanoraq Josepa tsurinlla quecar, tselaya shumaqta parlan! —nishpa, espantacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsenam nunacunata Jesus nerqan: —Qamcuna capas que parlaquita niyämanqui: ‘Jampicoq carqa, quiquiquiraq jampicunquiman’ nir. ‘Cafarnaumchoqa qeshyaqcunata cachacätserqonquish. Mä, canan que marquequichopis tseno ruramï’ —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Rasonpam niyaq: Manam Diospa ni meqan profetantapis marcanchoqa cäsuyantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Masqui yarpäyë imano Eliaspa tiempuncho pasaconqanta. ¿Manacu quima wata y joqta quilla pasepa tamyarqantsu? Tsemi jinantin Israelcho nunacuna mallaqewan jipayarqan. Israelcho atsca biudacuna jipecayaptinpis, Eliastam Dios cacharqan caru Sidonpa ladun Sarepta marcacho täraq biudallaman. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jina yarpäyë imano profeta Eliseopa tiempuncho pasaconqanta. Tsepinmi Israel marcancho atscaq nunacuna leprawan qeshyayarqan. Peru tseno quecaptinpis Siria nasionpeq Naamanllatam Eliseo cachacätserqan, manam Israel marca mayincunatatsu.” ");
INSERT INTO qwhNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesus tseno niptinnam, ellucayänan wayicho llapan nunacuna allapa piñacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsenam llapancuna sharcur, Jesusta Nazaretpita cumar, cumar apacuyarqan tse marcapa feyu sanjanman cumarcuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Peru pëqa chopincunapitam ullurïcur, eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsepitanam Galileacho Capernaum marcaman eucorqan. Jamacuyänan junaqcunanam ellucayänan wayicho nunacunata yachatseq. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Llapan nunacunam allapa espantacur mantsacäcuyarqan tse yachatsiquininpita, porqui puedeq queninwanmi tsecunata yachatsicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tse ellucayänan wayichomi supëyoq nuna qayaripa queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Au, Jesus Nazaret marcapeq nuna! ¿Imananquitaq noqacunawan? ¿Ushacätsiyämaqnïcu shamorqonqui? ¡Noqa reqeqmi, qam Dios Acrashqan canqequita! ");
INSERT INTO qwhNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesusnam supëyoq nunata piñaparnin, nerqan: —¡Upälla quë! ¡Canan que nunapita yarqï! —nir. Niptinnam, nopancho patsaman nunata mana imanashpa seqirirnin, eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tseta riquecurnam, llapan nunacuna mantsacäcur queno ninacuyarqan: —¡Imano poderyoqtaq que parlanqan! ¡Mandariptinllataq, supëyoq nunacunapita supëcunapis yarquyan! ");
INSERT INTO qwhNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tsepitanam jinantin Galilea probinsiacho Jesus rurashqanta musyariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ellucayänan wayipita Jesus yarqurirnam, disipuluncunawan Simon Pedrupa wayinman ewayarqan. Simonpa suegranmi fiebriwan feyupa qeshyecarqan. Jesus chäriptinnam, rogayarqan: —¡Cachaquecatsillämï! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesusnam qeshyaqman cuquicur, queno nerqan: —Amana fiebrïnatsu. Jinallachomi fiebrenqanpita warmi cachacärerqan. Tse öram sharcur, pecunata sirwerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Inti jeqecaptinnam, tuquilaya qeshyaqcunata Jesusman apayämorqan. Jesusnam jucllellapayan pecunaman maquinta churar, llapanta cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Supëyoq nunacunapitam supëcuna yarquyarqan qayaripa, queno niräcur: —¡Qamqa Diospa tsurinmi canqui! Tseno niyaptinnam, Jesus nerqan: —¡Upälla cayë! Porqui manam munarqantsu Diospa Acrashqan canqanta musyatsicuyänanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Patsa atsicyäriptinnam, Jesus japallan eucorqan tsunyaqman. Tsenam atscaq nunacuna ashiyarqan. Taririrnam, munayarqantsu tsepeq eucunanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesusnam nerqan: —Jinantin marcacunachomi alli willaquita yachatsicunä presisan. Que patsamanmi Dios cachamashqa, pepa mandaquinincho nunacuna imano cayänanpaq canqanta willacunäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsepitanam Judea probinsiacho jinantinpa purir, ellucayänan wayicunaman ewar, yachatsicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Juc cutinam Genesaret nishqan Lamar cuchuncho quecar Diospa palabranta Jesus yachatsiquicarqan. Wiyeta munarninnam, atscaq nunacuna ellucarnin, quichquinacur Jesusta tanqayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tsenam yacucho ishque lancha tëcaqta ricarerqan. Pescadu tsareqcunanam lanchancunapita yarqurir, atarayancunata playacho paqecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsenam Simonpa lanchanman Jesus lloqarcur nerqan: —Simon, que yacu cuchunpita mas ruriman yecushun —nir. Yecuriyaptinnam, täcurir, nunacunata lanchapita yachatsicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachatsicur usharirnam, Simonta nerqan: —Canan mas ruriman yecuyë atarayequicunata jitaq, pescaduta tsariyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonnam nerqan: —Mayestru, waraqninpim noqacuna nacayarqö. Manam ni jucllellatapis tsariyarqötsu. Peru canan qam nimanqequirecurmi, atarayäta jitashaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jitarirnam, allapa atsca pescaduta tsaricuyarqan, casi atarayapis rachenqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsenam jucnin lanchacho yanaqincunata señaswan qayarqan yanapayänanpaq. Pecuna chäriyaptinnam, pescaduta ishcan lanchaman winayarqan. Tselaya atsca captinmi, ishcan lanchacunapis casi jundicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tseta Simon Pedru riquecurnam, Jesuspa nopanman qonqurïcur, nerqan: —Noqalläqa jutsasapa nunam callä, Tëte. Noqallapita witicurillë. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yanaqincunawan tselaya atsca pescaduta tsariyanqanpita mantsacashqa carninmi, Pedru tseno nerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeupa tsurincuna Santiagu y Juanmi Simonpa yanaqincuna cayarqan. Pecunapis mantsacäyarqanmi. Tsenam Pedruta Jesus nerqan: —Ama mantsaquëtsu. Cananpitam nunacunata noqapaq pescamunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pecunanam playaman lanchancunata jorqarïcur, tsecho llapanta jaqirir, Jesusta qatircur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Juc marcacho Jesus quecaptinnam, leprawan qeshyaq nuna chärerqan. Jesusta ricarirnam, patsaman urcunpis chanqanyaq qonquriquicur rogacur, queno nerqan: —Tëte, munarnenqa, cachaquecatsillämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsenam Jesus nunata yatecur queno nerqan: —Munämi, cachacänequita. Tseno niptinnam, jinallacho leprapita cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tsenam nunata Jesus nerqan: —Ama ni pitapis willacunquitsu cachacätsenqaqta. Peru si, ewë saserdoti bendisishunequipaq, Moises mandacushqanno Diospaq qarenin aparcur cachacashqequita musyayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tseno nicaptinpis, masran nunacuna musyariyarqan Jesus ruranqancunata. Tsenam atscaq elluquecuyarqan yachatsicushqancunata wiyayänanpaq, y qeshyaqcunatapis cachacätsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Peru Jesusqa imepis pecunapita raquicarmi, tsunyaqcunata ewar, Diosman mañacoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc junaq Jesus yachatsiquicaptinnam, fariseucuna y ley yachatsicoqcuna Galileacho jinantin marcacunapita, Judeapita y Jerusalenpita ewar, ellucarir tëcur, wiyayarqan. Diospa poderninmi Jesuscho carqan qeshyacoqcunata cachacätsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsemannam nunacuna apayarqan imbalidu nunata quirmapa wanturishqa. Chäratsirnam, ruri wayiman Jesuspa nopanman yecatsita munayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nunacuna pasepa quichquishqa cayaptinmi, yecatsita puediyarqantsu. Tsenam wayi jananman lloqarcur, tse wayi qataraqta quicharicur, qeshyaq nunata quirmantin shumaqlla cacharpuyarqan Jesuspa nopanman. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tseno rurayaptinnam, Jesusqa peman allapa marcäcuyashqanta musyarirnin, qeshyaqta nerqan: —Au, amigu, jutsequicunapitam perdonecoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsenam fariseucuna y ley yachatsicoqcuna quiquincunacho yarpacachäyarqan: “Que nunaqa ¡imanirraq Diospita burlacun! Diosllam jutsantsicpitaqa perdonamantsic” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Peru Jesusqa tseno yarpacachäyanqanta musyarirmi, pecunata queno taporqan: —¿Imanirtaq shonqiquicunacho tseno yarpacachäyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Meqantaq mas alli ninäpaq canman: ‘Jutsequicunapita perdonashqanam canqui’ ninäcu, o ‘¡Sharquï! ¡Canan purï!’ ninäcu! ");
INSERT INTO qwhNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cananmi musyatsiyashqequi Diospita Shamushqa Nuna, puedeq car que patsacho nunacunapa jutsancunata perdoneta puedenqanta. Tseno nirirnam, imbalidu nunatana nerqan: —Qamtam neq: Sharcur quirmequita aparcur wayiquita euquï. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tsenam jinallacho llapan ricarëcayaptin, sharcur, quirmanta ellurir aparcur, wayinman eucorqan, “Diosqa allapa allim” nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsenam nunacuna allapa espantacur y mantsacäcur, alabayarqan: —¡Diosqa allapa puedeqmi! ¡Manam ni imepis queno alli ruraqtaqa ricashqatsu cantsic! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsepita Jesus eucurninnam, ricarerqan Levi jutiyoq nunata Romapaq impuestucunata cobracuyänan wayicho cobracur tëcaqta. Petam Jesus nerqan: —¡Acu eucushun! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levinam sharcur, llapanta jaqirïcur, Jesuswan eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tsepitanam Jesuspaq Levi wayincho ruratserqan juc banquetita. Tsechonam impuestuta cobraqcuna atscaq y mas nunacunapis Jesuswan ellucarir, miquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tsenam, fariseucuna y ley yachatsicoqcuna Jesuspa disipuluncunata penqaparnin, niyarqan: —¿Imanirtaq impuestu cobracoqcunawan y que jutsasapacunawan qamcuna micuyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesusnam nerqan: —Qeshyaqcunallam medicutaqa nesitayan; sanu caqcunaqa manam. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tseno caqmi noqaqa que patsaman shamushqa cä alli ruraqcunamantsu, sinoqa jutsasapacunata Diosman cutitsinäpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nunacunanam Jesusta queno tapuyarqan: —Bautisacoq Juanpa y fariseucunapa disipuluncunaqa imepis ayunashpam Diosman mañacuyan; peru qampa disipuliquicunaqa ¡manataq ayunayantsu, antis imepis micucuyantaq y upucuyantaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesusnam iwalatsiquipa queno nerqan: —Acasu casamientuman combidashqacuna nobiuwan juntu quecar, ¿ayunayancu? ");
INSERT INTO qwhNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Peru chämonqanam nobiuta apacuyänan junaq. Tsenam si, ayunayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tseno nirirnam, iwalatsiquipa yachatsicorqan queno: —Mushoq ropapita ratashta capchurir, manam remendashwantsu macwa ropaman. Tseno rurarqa, mushoq ropatapis uchcurirmi perdiratsintsic, y macwa ropacho manam tse mushoq ratash tsaraconqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tsenollam jina pipis macwa qara bolsachoqa llullullaraq binuta poqutsinmantsu. Tseno ruraptenqa, binu poqurmi, tse bolsata pashtaratsinman, y binupis bolsapis ushacärinmanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tseraq rurashqa binutaqa mushoq qara bolsamanmi winantsic. ");
INSERT INTO qwhNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pipis poqushqa binuta upurerqa, tseraq rurashqa binuta manam upita munantsu, ‘Poqushqa caq binum mas alleqa’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jucpinnam jamacuyänan junaqcho disipuluncunawan Jesus ewecayarqan trigu murushqacuna cuchunpa. Disipuluncunanam espigata quipchurir, maquincunacho qaqurir, uchuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseucunanam tseta ricarnin, piñacur queno niyarqan: —¿Imanirtaq jamaqui junaqcho leynintsicpa contran tseno rurayanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesusnam nerqan: —¿Qamcuna manacu Diospa palabranta leyishqa cayanqui, rey David yanaqincunawan mallaqar, rurayanqanta? ");
INSERT INTO qwhNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pemi Dios adorana wayiman yecurirnin, Diospaq churashqa tantata yanaqincunawan micucurcuyarqan, saserdoticunalla tse tantata micuyänan quecaptinpis. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tsemi Diospita Shamushqa Nunapa munenincho jamaqui junaqpis quecan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tsepitanam jina jamaqui junaqcho ellucayänan wayiman Jesus ewar, yachatsiquicarqan. Tsechomi juc nuna quecarqan derechu caq maquin tsaquishqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseucunanam ley yachatsicoqcunawan Jesusta acuseta munarnin, qawarëcayarqan: —Mä, ¿canan jamaqui junaqcho que nunata cachacätsenqacush! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pecuna tseno niyanqanta Jesus musyarirninnam, tsaquishqa maquiyoq nunata nerqan: —Sharcur, que chopiman shamï. Niptinnam chopincunaman shacurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tsenam fariseucunata Jesus queno nerqan: —Jucta tapuyashqequi: ¿Imanotaq leynintsic mandacun? Jamaqui junaqcho ¿allita rurashwancu o manacu! ¿Nunacunata salbecushwancu o wanuratsishwancu! ");
INSERT INTO qwhNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tsenam llapancunata ricarir, tse nunata queno nerqan: —Maquiquita pallarï. Maquinta nuna pallarcuptinnam, cachacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Fariseucunanam piñacurcurnin, quiquincuna pura queno ninacuyarqan: —¿Imanecuntsictaq que Jesusta! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tsepitanam jircaman Jesus eucorqan, y waraqninpim tsecho Diosman mañacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Patsa waräriptinnam, disipuluncunata qayarqan, y chunca ishcaqtam (12) acrarqan apostolnin cayänanpaq. Pecunam cayarqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (petam Jesus jutitserqan “Pedru” nishpa), wauqin Andres, Santiagu, Juan, Felipi, Bartolome, ");
INSERT INTO qwhNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Alfeupa tsurin Santiagu, Seloti grupupita Simon, ");
INSERT INTO qwhNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa tsurin Judas, y Judas Iscariote. Pemi Jesusta ranticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pecunawan Jesus urämurnam, tarerqan pampacho atscaq qatiraqnincuna quecayaqta. Tsemanmi jinantin Judea probinsiacunapita, Jerusalenpita, lamar cuchuncho Tiro y Sidon marcacunapita atscaq nunacuna shamushqa cayarqan, ˻Jesus yachatsicushqanta wiyeta munar, y qeshyaqcunata cachacätsinanta munarnin˼. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Supëcunawan jipaqcunatam Jesus cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Llapan nunacunam Jesusta yateta munayarqan, puedeq queninwan llapan qeshyaqcunata cachacätsiptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsechonam disipuluncunata Jesus riquecur, iwalatsiquipa queno nerqan: “Cushicuyë, noqaman creyicoq waqtsacuna. Qamcunaqa Diospa Muneninchonam cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Cushicuyë, canan mallaqepano Diosta asheqcuna. Qamcunatam Diosqa pacha juntata wätayäshunqui. “Cushicuyë, canan waqacoqcuna. Porqui shoqashqanam cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Cushicuyë, nunacuna chiquiyäshuptiqui, qarquyäshuptiqui y allqutsayäshuptiqui, mana alli ruraqtano lebantayäshuptiqui, tseqa Diospita Shamushqa Nunaman creyicuyanqequirecurmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tseno rurayäshuptiqueqa allapa cushicuyanqui. Cushiquiwanpis pinticachäyanqui. Wac bidachomi Dios allapa shumaq premiuta qoyäshunqui. Tsenollam pecunapa une awiluncuna maltratayarqan Diospa profetancunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Peru ¡Allau, ricucuna! Que bidallachomi cushiquicho cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Allau, canan pacha junta quecaqcuna! ¡Chämonqam mallaqueniquicuna! “¡Allau, cushicur asicachäcoqcuna! ¡Chämonqanam waqaquiniquicuna! ");
INSERT INTO qwhNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Allau, llapan nunacunalla alabashqacuna! Tsenollam pecunapa awiluncunapis alabayarqan une tiempucho uli profeta tucoqcunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Canan llapequi wiyecamaqnïcunatam niyaq: Chiquiyäshoqniquicunata cuyayanqui. Melanäyäshoqniquicunata ancupar, yanapayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Llutan camanta niyäshoqniquitapis qamcunaqa allipa parlapäyë; allqutsayäshoqniquicunapaqpis, Diosman mañacuyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sitsun juc ladu qaqllequicunacho laqyecuyäshunqui, jucnin ladu qaqllequicunatapis camapïcuyanqui. Ponchiquitatsun qochiyäshunqui, camsequitapis qoycuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Imatapis mañayäshonqequita qoycuyanqui. Sitsun imequitapis qochiyäshunqui, ama ‘Cutitsimë’ niyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imanomi munayanqui qamcunapaq nuna mayiquicuna allita rurayänanta, tsenolla qamcunapis pecunapaq rurayë. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cuyayäshoqniquicunallata cuyarqa, manam allitatsu rurayanqui. ¡Jutsasapacunapis tsenollaqa rurayantaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Allipa ricayäshoqniquicunallapaq allita rurarqa, manam ima allitatsu rurayanqui. ¡Jutsasapacunapis tsenollaqa rurayantaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sitsun prestacuyanqui, ‘Pëqa imachopis paguta ruramanqam’ nishpa, ¿ima allitataq rurayanqui? Tsenollaqa jutsasapacunapis prestanacuyantaq, cutitsiyänanta shuyarar. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Antis chiquiyäshoqniquicunata allita rurar, cuyayanqui. Mana ni imata cutitsiyäshunequita shuyarashpa, imatapis qoycuyanqui. Tseno rurayaptiqueqa, Diosmi tsepita masta cutitsiyäshunqui. Pëqa mana agradesicoqcunata y jutsasapacunatapis ancupanmi. Qamcunapis tseno rurarnenqa, sielucho quecaq Diospa wamrancunanam cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tsemi Dios Yaya ancupäcoq canqannolla, qamcunapis ancupäcoq cayänequi. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ama nuna mayiquicunata jusgayëtsu, qamcunapis mana jusgashqa cayänequipaq. Ama lebantanacuyëtsu, qamcunapis mana lebantashqa cayänequipaq. Antis perdonanacuyë, qamcunatapis Dios perdonayäshunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nuna mayiquita qarecuyaptiqueqa, Diosmi qamcunatapis mas atscata qoycuyäshunqui, tupuman junta junta tapsïcur, rame rame qaracoq cuenta. Imanollam qamcunapis nuna mayiquicunata tratayanqui, tsenollam qamcunatapis Dios tratayäshunqui.” ");
INSERT INTO qwhNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tseno nirninnam, iwalatsiquïpa Jesus yachatsicorqan, queno nishpa: —¿Acasu juc wiscu nunata wiscu mayin pushanmancu! Tseno carqa, ¡ishcanchi sanjaman jeqacurcuyanman! ");
INSERT INTO qwhNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Manam ni meqan disipulupis mayestrunpita mas presisaqtsu. Tse yachacoqqa yachacur usharir, mayestrunnollam canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Qamcunaqa nuna mayiquicunapa nawincho saqwata ricarëcaq cuentallam cayanqui; ¡peru manam cuentata qocuyanquitsu quiquiquicunapa nawiquicunacho troncu quecanqantaqa! ");
INSERT INTO qwhNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tseno quecaptin ¿imanopam nuna mayiquita ‘Nawiquicho saqwata jorqaramushaq’ ninquiman, quiquiquipa nawiquicho troncu quecaptin! ¡Alli tucoqcuna, puntataraq nawiquipita tse troncuta jorquyë! Tseran alli ricayanqui nuna mayiquicunapa nawincunacho saqwata jorqayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Jina tsenomi alli monti, alli frutata wayun; y mana alli caq monteqa, mana alli frutatam wayun. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wayïninpitam reqintsic imano monti canqantapis. Manam casha montipitatsu igusta pallantsic. Y manam cashacunapitatsu ubasta pallantsic. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tse cuentanollam alli caq nuna shonqun alli captin, allicunallata parlan; mana alli caq nunanam shonqun mana alli captin, mana allicunata parlecan. Porqui nunaqa parlan shonquncho imatapis yarpanqantam. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtaq qamcuna niyämanqui ‘Teytallä, Teytallä’ nishpa, mandayashqaqta mana cäsuquicar? ");
INSERT INTO qwhNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cananmi iwalatsiquipa cäyitsiyashqequi: Pipis que yachatsiconqäta wiyacur, cäsucoqcunaqa, ");
INSERT INTO qwhNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","imeca juc nuna wayinta shäritsinanpaq alli jondu oqtirïcurnin, qaqa janancho simientuta patsätseqnomi. Tsenam atsca lloqlla tse wayita wacwarninpis, cuyutsintsu, alli rurashqa captin. ");
INSERT INTO qwhNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Peru yachatsicushqäcunata wiyar, mana cäsucoq nunaqa allpa jananllacho simientunnaq wayita sharcatseqnomi cayan. Tsenam atsca lloqlla tse wayita wacwar, juchur ushacäratsin.” ");
INSERT INTO qwhNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nunacunata yachatsir usharirnam, Capernaum marcaman Jesus ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tsechomi Roma capitanpa cuyë wätenin nuna lastima qeshyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tse capitannam Jesus rurashqancunata musyarirnin, israel nunacunapa autoridanincunata Jesusman cacharqan tse wäteninman ewar cachaquecatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pecunanam ewarnin, Jesusta queno niyarqan: —Tse capitan allapa alli canqanrecur, rogaquillanta rurecullë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Pëqa allapam cuyan nasionnintsicta, y pemi ruratsimushqa ellucanantsic wayitapis. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tseno rogayaptinnam, pecunawan Jesus ewarqan. Peru wayiman naqana chëcayaptinnam, amiguncunata capitan cacharqan Jesusta queno niyänanpaq: —Tëte, manash meresintsu wayinman ewar afanacullanequita. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Penqacurshi quiquenqa shallämorqontsu. Tseshi quellapita mandecullanqui wätenin cachacärinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porqui pepis mandaqninpa poderninchoshi quecan. Y pepa poderninchoshi soldaduncunapis quecayan. Jucninta ‘Ewë’ niptinshi, ewayan; jucninta ‘Shamï’ niptinpis, ewanshi; sirweqninta ‘Queta rurë’ niptinpis, ruranshi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Capitan tseno willacatsenqanta wiyecurnam, Jesus espantacur, qatiraqnincunata queno nerqan: —Rasontam niyaq: Diosman que nuna marcäcoqtanoqa manam tarishqatsu cä que israel nunacunacho. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Capitanpa wayinman cutirirnam, tse cachashqancuna wäteninta cachacärishqatana taririyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsepitanam Jesus ewarqan Nain nishqan marcaman. Disipuluncunanam atscaq nunacunawan qatiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tse marcaman yequicarnam, Jesus toparqan wanushqata pampaq apecaqcunawan. Tse wanushqaqa carqan biuda warmipa japallanlla ollqu wawanmi, y atscaq nunacunam pampacoq yanaqëcayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesusnam warmita ricarir ancuparnin, nerqan: —Ama waqallëtsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tseno nirirnam, ewar cajata yatarerqan, wantïcaqcunanam shäräriyarqan. Tsenam ayata Jesus queno nerqan: —Jobin, qamtam neq: Sharquï. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesus tseno niptinnam, cawarircur tarcamur, nunacunawan parlarqan, y biudatanam cawarishqatana wawanta qoycorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tsenam llapan nunacuna mantsacäyarqan, y Diosta alabayarqan queno: —Diosnintsicpa juc alli profetanmi yurimushqa noqantsicman, y allapa ancupämarnintsicmi, cananqa Diosnintsic yanapamäshun. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nunacunanam Judea probinsiacho jinantin marcacunapa ewar, willacuyarqan Jesus rurashqancunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bautisacoq Juanpa disipuluncunanam Jesus rurashqancunata Juanta willayarqan. Tsenam ishcaq disipuluncunata qayarir, ");
INSERT INTO qwhNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesusman cacharqan tapucoq, “¿Qamcush shamunanpaq caq salbadorlläcuna callanqui, o juctacush shuyalläyäshaq?” niyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesusman chärirnam, queno niyarqan: —Bautisacoq Juanmi cachayämarqon. ¿Qamcush shamunanpaq caq salbadorlläcuna callanqui, o juctacush shuyalläyäshaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tse öranam Jesusqa cachacätserqan, tuquilayawan qeshyacoqcunata, y supëyoq nunacunapita supëcunata qarqorqan; y wiscucunatapis cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsenam Juanpa disipuluncunata Jesus queno nerqan: —Canan cutirnin, bautisacoq Juanta quecho wiyayashqequita y ricayashqequita queno willayanqui: wiscucuna ricayanqanta, cojucuna puriyanqanta, leprawan qeshyaqcuna cachacäyanqanta, sorducuna wiyayanqanta, wanushqacuna cawariyanqanta y wactsacuna Diospa alli willaquininta wiyaquicayanqanta, nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y pi mepis cushicutsun mana ajayashpa noqaman marcäcoqcuna. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa disipuluncuna eucuyaptinnam, tsecho ellucashqa nunacunata Jesus willaparqan Juanpaq: —Tsunyaqcho quecaptin, ¿Imaqtaq Juanman caruta ewayarqequi! ¿Bientuwan shoqush cuyoqllata ricaqcu! ");
INSERT INTO qwhNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¡Niyämë! ¿Imaqtaq ewayarqequi, alli shumaq ropan yacashqa nuna ricaqcu! Musyayanqequinopis shumaq ropan yacashqa nunacunaqa micur, upur, tushur reypa wayincunallachomi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tsepenqa, ¿Imaqtaq ewayarqequi! ¿‘Diospa profetanchi’ nircu? ¡Claru parlaquichoqa! Pëqa tse profetacunapitapis mas presisaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpaqmi Diospa palabran escribirëcan queno: ‘Puntequitam willacoqnïta cachashaq, nänita alistaq cuenta nunacunata willapänanpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rasontam niyaq: Juanno presisaq nunaqa manam imepis cashqaraqtsu. Tseno captinpis, Diospa mandaquinincho quecaq qollmi shonqucunam mas presisaqqa cayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Llapan nunacunam Juan yachatsicushqanta wiyacoqcuna y impuestu cobraqcunapis, “¡Diosqa allapa allim!” nir, tse öra bautisacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peru fariseucunawan ley yachatsicoqcunaqa Dios munashqanta mana cäsurninmi, mana bautisacuyarqanpistsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tsepitanam nerqan: “¿Canan tiempu nunacunata imawanraq iwalaratsiman? ¿Imanotaq cayan? ");
INSERT INTO qwhNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pecunaqa imeca plasacunacho wamracuna pucllacur, wamra mayincunawan qayaripa queno ninacoqnomi cayan: ‘Flautawan shumaq bersuta tocayaptïpis, manam qatswayanquitsu; ni llaquiquipaqta qotsuyaptïpis, manam waqayanquitsu.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tsenomi bautisacoq Juan shamur, mana binuta upuptin, y tantata mana micuptin, niyanqui ‘Pëqa supëyoqmi’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Diospita Shamushqa Nuna micoq upoq captinnam, qamcuna niyanqui: ‘Queqa allapa micoqmi y upoqmi, impuestu cobraqcunapa y jutsasapacunapa amigunmi’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Peru Diospa acrashqancunaqa ricatsicuyan alli rurenincunawanmi Diospa yacheninta.” ");
INSERT INTO qwhNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsepitanam Simon fariseu wayinman Jesusta combidarqan pewan micuyänanpaq. Jesusnam wayiman yecurir, mesaman täcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tse marcachomi lluta pulicoq warmi tärarqan. Tse warmim fariseupa wayincho Jesus miquicanqanta musyarir, ewar juclla yecurerqan alabastrupita botellacho perfumin tsararishqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chärirnam, Jesuspa qepanpa chaquinyaq witïcur, waqarqan. Weqincunawannam chaquincunata paqaporqan, y aqtsanwan tsaquitsirnam, chaquinta mutsecuryan, perfumita jicharqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tseta riquecurnam, Jesusta combidaq Simon shonqunllacho queno nerqan: “Que nuna Diospa rasonpa profetan carnenqa, musyanmanmi que yataqnin warmi imano canqanta, y allapa mana alli ruraq canqanta.” ");
INSERT INTO qwhNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsenam Jesus nerqan: —Simon, jucta willashqequi —nir. Penam queno nerqan: —Mayestru, willecallämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tsenam Jesus nerqan: —Ishcaq nunacunam juc nunapa jaqan cayarqan. Jucninmi ishque quilla uryanan tincu, y jucninman ishque wata uryanan tincu. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ishcantapis mana pagaquita puediyaptinmi, tse nuna pecunata perdonecorqan. Mä, canan nimë, Simon, ¿meqan nunataq mas cuyanqa tse nunata? ");
INSERT INTO qwhNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tsenam Simon nerqan: —Mas atsca jaqanta perdonayanqan caqchi —nir. Tsenam Jesus nerqan: —Rasontam ninqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tseno nirninnam, warmita ricarëcur, Simonta nerqan: —¿Que warmi rurashqanta ricarqonquicu? Que wayiquiman chämuptï, qam manam saludamarnï, yacuta qomarqonquitsu chaquïta paqarinäpaq; peru que warmeqa chaquïcunata weqinwan paqamurmi, aqtsanwan tsaquitsimorqon. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Qam manam costumbrintsicmanno saludamarnï, mutsamarqonquitsu; peru pëqa wayiquiman yecamushqäpitam chaquïta mutsamushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Qamqa manam costumbrintsicmanno peqäman aseitita jichamorqonquitsu; pemi si, perfumita chaquïman jichamushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tsemi qamta neq: Que warmeqa llapan jutsanpita perdonecuptïmi, allapa cuyamarnï, queno ruramarqon; peru waquincunaqa ‘ichiclla jutsätam perdonamashqa’ nirmi, ichiclla cuyayäman. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Warmitanam Jesus nerqan: —Llapan jutsequicuna perdonashqanam. ");
INSERT INTO qwhNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tsecho quecaq combidashqacunanam quiquincuna pura ninacuyarqan: —¿Pitaq que nuna, jutsacunapita perdonacunanpaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Peru Jesusnam warmita nerqan: —Noqaman marcäcurninmi, condenasionpeq salbacorqonqui. Canan euquï shumaq cawacunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsepitanam chunca ishque (12) disipuluncunawan Jesus jinantinpa marcan, marcan estansiacunapa ewar, willacur yachatsicorqan Diospa mandaquinincho cayänapaq alli willaquicunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Qeshyayanqanpita y supëyoq cayanqanpita Jesus cachacätsishqan warmicunapis qatiyarqanmi. Jucninmi carqan Magdalena niyashqan Maria. Pepitam qanchis supëcunata Jesus qarqushqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Waquincunanam cayarqan: Susana y Herodispa mayuralnin Cusa jutiyoq nunapa warmin Juana y mas warmicuna. Pecunam cayäponqancunawan Jesusta y disipuluncunata yanapayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tsenam jinantinpita atscaq nunacuna peman elluquecuyaptin, iwalatsiquipa Jesus yachatsicorqan, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Juc nunam ewarqan chacranman murucoq. Muruta maqtsiptinnam, waquin muru pintiyarqan näniman. Tsetanam nunacuna jalucuyarqan, y pishqucunanam ushpacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquincunanam ranraman pintiyarqan. Tsecho mana allpan captinnam, jeqaramur tsaquiriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquinnam pintiyarqan cashacuna rurinman. Cashacunanam winar, pasepa tsapacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Peru waquin murunam alli allpaman ishquirnin, jeqaramur, winar cada espigacho jitecorqan asta pachaq granupayan. Tseno Jesus yachatsicur usharirnam, fuertipa queno nerqan: —¡Tsemi rinriyoq carqa, wiyacur cäsucuyë! ");
INSERT INTO qwhNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Disipuluncunanam tapuyarqan: —¿Ima ninantaq tse iwalatsiquipa yachatsicushqequi? ");
INSERT INTO qwhNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesusnam queno nerqan: —Qamcunataqa Diosmi cäyitsiyäshunqui mandaquinin imano canqanta; peru waquincunaqa manam musyayantsu. Tsemi pecunaqa iwalatsiquïpa yachatsicoqta riquecamarnï y wiyecamarnïpis, mana cäyiyantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tseqa queno ninanmi: muroqa Diospa alli willaquininmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Näni cuentam waquin nunacuna cayan. Shonquncunaman alli willaqui chasquiyashqantam diablu pasepa qonqaratsin mana creyicur salbacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Waquin nunacunanam ranraman muru pinteq cuenta cayan. Pecunam alli willaquita wiyacur cushishqa chasquiriyan. Peru mana alli watsiyoq plantano carninmi, desgrasiacuna pasayaptin, jaqiricuyan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Waquincunanam cayan casha, casha rurinman muru pinteq cuenta. Pecunam alli willaquita wiyarirnin creyicuyan. Peru tsepita unetanam capoqyoq quepaq yarpacacharnin, y cushiquillacho cawaquita munarnin, imeca wamracunanolla cacuyan ni imata Diospaqqa rurayantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Peru waquin nunacunanam alli allpaman muru pintishqa cuenta cayan. Allapa alli shonquncunawan alli willaquita wiyarmi, creyicuyan. Tseno carmi, imata sufrirninpis tsaracuyan, y allapa allicunata Diospaq rurayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Lamparinta sendircur, manam manca rurinmantsu ni catripa rurinmantsu churantsic; sinoqa raramanmi churantsic, wayiman yecoqcunata actsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tse cuentanollam Diospa palabran pacarëcaqcunata y mana musyayanqancunata imecarpis musyayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Tsemi canan alleq wiyayämë: Wiyacoq caqcunaqa mas allim cäyicuyanqa, peru mana wiyacoq caqcunaqa, ichiclla wiyayanqantapis qonqariyanqam.” ");
INSERT INTO qwhNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsemannam Jesuspa mamänin wauqincunawan ashirnin chäriyarqan. Atscaq nunacuna ellucayashqa cayaptinmi, Jesus canqanman yequita puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Juc nunanam Jesusta queno willarerqan: —Mamäniquim wauqiquicunawan shuyarëcayäshunqui waqtacho. Menistiyäshunquish —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Penam nerqan: —Dios palabranta wiyar cäsucoqmi, noqapa mamänïqa y wauqïcunaqa cayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Juc junaqnam disipuluncunawan lanchaman Jesus lloqarir, nerqan: —Acu lamarpa wac tsimpanman. Tseno niptinnam, eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ewarëcayaptinnam, Jesus punucärerqan. Tsemannam llutepa bientur qallaquicorqan lamarta laqcheqsätsirnin. Lanchancunaman yacu winacaptinnam undicäyänanpaqna quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tsenam Jesusta riyatsiyarqan, queno nishpa: —¡Mayestru, Mayestru, riyaquï! ¡Ushacärintsicnam! —nir. Tseno niyaptinnam, sharcur bientuta mandarqan mana bientunanpaq yacuta mana laqcheqsänanpaq. Y llapanmi shumaq tranquilu ticrarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tsenam disipuluncunata queno nerqan: —¿Imanirtaq noqaman marcäcuyarqonquitsu? Disipuluncunanam allapa mantsacashqa y espantashqa, quiquincuna pura queno ninacuyarqan: —¡Queqa imano nunataq, tselaya bientupis yacupis mandadunta cäsuyänanpaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilea probinsiapita eucurnam, lamarpa wac tsimpan Gadara nishqan marcaman chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lanchapita yarpurirnam, tarerqan tse marcapeq supëyoq juc nunata. Tse nunam unena qalapachu puricorqan. Y mana wayincho yachashpam, pantiuncunallacho paracorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesusta riquecurninnam, corillapa ewar, nopanman qoncuriquicorqan. Tsenam nunapa shiminpa supë qaparipa queno nerqan: —Puedeq Diospa tsurin Jesus, ¿imatataq noqacunawan munanqui! ¡Qamtam rogacoq ama imanecayämëtsu! ");
INSERT INTO qwhNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tseno supë nerqan, Jesus “¡Que nunapeq yarqï!” nishqa captinmi. Tse nunapa shonqunchomi unepita supë cacorqan. Cadenacunawan nunacuna tsareta munar, chaquinta, maquinta pancayaptinpis, rachicacharcurmi, supëpa muneninwan tsunyaqcunata eucoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tsenam supëta Jesus taporqan: —¿Imataq jutiqui? —nir. Tsenam nerqan: —Noqapa jutïqa juc tropam. Tseno nerqan, tse nunacho atscaq supëcuna carninmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jesustam supëcuna yapecuryan rogayarqan queno: —Ama infiernuman qarpulläyämëtsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tse jircachomi atsca cuchicunata mitsiquicayarqan. Tsenam supëcuna mañepa, queno niyarqan: —Cachecalläyämë taqe cuchicunallaman yecuquiculläyänäpaq —nir. Jesus “ewayë” niptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","nunapeq yarqurir, cuchicunaman yecuquicuyarqan. Tsenam, coripa ewar cuchicunaqa jircapita qochaman jeqacurcuyarqan, y shenqacar, wanuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tse cuchi mitseqcunanam tse llapan pasaconqancunata riquecur, jinantin marcapa estansiancunapa coripa ewacur, llapanta willacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsenam nunacuna shayämorqan, “Mä, ¿imash pasacushqa?” nirnin. Jesus quecanqanman chärirnam, taririyarqan supëyoq nunata pasepa sanutana, roparishqana y juisiunchona, Jesuspa laduncho tëcaqta. Tseta riquecurninmi, allapa mantsacäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y ricashqa caqcunanam tseman chaqcunata willayarqan imano tse supëyoq nunata Jesus cachacätsishqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsenam tse Gadarapita nunacuna allapa mantsacur, Jesusta rogayarqan: —Que marcalläcunapita eucullë —nishpa. Tsenam lanchaman Jesus disipuluncunawan lloqarcur, eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Supëpita libracushqa nunanam Jesusta rogarqan pewan eucunanpaq. Peru Jesusnam nunata despidirnin, nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Quedacur, wayiquiman cutiquï. Tsecho willacunqui Dios llapanta qampaq rurashqanta. Tsenam cutirnin, jinantinpa ewar, willacorqan Jesus pepaq llapanta rurashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Galilea marcaman cutiriyaptinnam, atscaq nunacuna shuyarëcayarqan, cushishqa chasquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tsemannam ellucayänan wayicho mandacoq Jairu jutiyoq nunapis chärerqan, y Jesuspa nopanman qonquriquicurnam, rogarqan: —Acu, wayïta eweculläshun —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tse nunapam jucllella chunca ishque (12) watayoq warmi tsurin, pasëpa lastima qeshyar, wanuquicarqan. Jesus ewarëcaptinnam, atsca nunacuna qatirnin quichquipa quichquiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chopincunachonam ewecarqan juc warmi, chunca ishque (12) watana yawar ewewan qeshyacoq. Tse warmim imecancunatapis pasepa ranticur, usharqan jampicunanpaq; peru meqan jampicoqpis manam cachacätserqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pemi Jesuspa qepanman witïcur, mantunpa cuchunta yatecaporqan. Yateconqan öram yawar ewenin paqwepa tsaquirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesusnam tapucorqan: —¿Pitaq ropäta yatamorqon? —nishpa. Llapan nunacuna “Manam noqatsu” niyaptinnam, Pedru waquin yanaqincunawan niyarqan: —¡Mayestru, quelaya nunachoqa jucnin jucnintaq tanqayäshunqui! ˻¿Tsecu qam ninqui, ‘Pitaq ropäta yatamorqon?˼’ ");
INSERT INTO qwhNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yapenam Jesus nerqan: —¡Pi carpis yatamashqam! Podernï yarqoqtam mäcorqö. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tseno yatashqanta mäcuriptinnam, mana imano queta puedir, tse warmi allapa mantsacushpa Jesuspa nopanman qonquriquïcorqan. Y willarqan llapan nunacuna wiyarëcayaptin, imanir yatashqanta y cachacärishqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tsenam Jesus queno nerqan: —Ija, noqaman marcäcurmi cachacärerqonqui. Canan cushishqana euquï. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus tseno parlecaptinmi, ellucayänan wayicho mandacoq Jairupa wayinpita nunacuna shamur chäriyarqan queno nirnin: —Tëte Jairu, ¡tsuriqueqa wanurishqanam! ¡Amana Jesusta afanënatsu! ");
INSERT INTO qwhNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesusnam tseta wiyarirnin, Jairuta nerqan: —Ama mantsaquëtsu. Noqallaman marcäquï; wamrequeqa cachacanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wayiman chärirnam, disipuluncuna Pedruta, Juanta, Santiaguta y wamrapa papäninta y mamäninllata ruriman yecatserqan. Manam waquincuna yecuyänantaqa munarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Waqtachonam nunacuna qaparipa qayaripa waqaquicayarqan, wamra wanushqa captin. Tsenam Jesus nerqan: —Ama waqayëtsu. Wamraqa punicanllam. Manam wanushqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wamra wanushqanta musyarninmi, Jesusta llapan nunacuna asipäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Peru Jesusnam maquinpita tsarircurnin, wamrata queno nerqan: —Wamra, sharcamï. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wamranam jänin cutiriptin, cawarir sharcaramorqan. Jesusnam nerqan: —Wamrata miquinin qarayë —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wamrapa papänin mamäninnam pasepa espantashqa cayarqan. Jesusnam nunacunata notificarqan pitapis tseta mana willacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tsenam chunca ishque (12) apostolnincunata Jesus qayarir, poderninta qorqan, supëyoq nunacunapita supëcunata qarquyänanpaq, y qeshyaqcunata cachacätsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pecunatam cacharqan Diospa mandaquinincho imano nunacuna cayänanpaq caqta willacuyänanpaq y qeshyaqcunata cachacätsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y nerqanmi: —Ewarnin, ama imatapis apayanquitsu: ni tucruta, ni alporjata, ni mircapata, ni qelleta, ni trocacuyänequipaq ropata. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Me wayichopis posadacurir, tsellacho cacuyanqui tse marcapita eucuyanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sitsun juc marcaman chäyaptiqui nunacuna chasquiyäshunquitsu, tsepita eucuyanqui. Yarqurirna, chaquiquicunacho polbutapis tapsicuriyanqui. Tseqa Diospa castigun janancunachona quecanqan señalmi canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsenam apostolnincunana jinantinpa marcan marcan ewar, mushoq alli willaquita yachatsicuyarqan, y qeshyaqcunatapis cachacätsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tse llapan rurayashqancunatam rey Herodis musyarerqan. Y manam imano quetapis puederqantsu, porqui waquin nunacunam Jesuspaq niyarqan “Bautisacoq Juanmi cawarimushqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Y waquin caqcunanam niyarqan: —Diospa une profetan Eliasmi yurimur purican —nir. Mas waquincunanam niyarqan: —Diospa une tiempu profetanchi meqan carpis cawarimushqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Peru Herodisnam nerqan: —Bautisacoq Juanpa peqantaqa quiquïmi roqutserqä. ¿Pipaqtaq wiyä quelaya imecacunatapis ruranqancunapaq? —nishpam, allapa Jesusta reqita munarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tsepitanam apostolnincuna puriyanqanpita cutirirnin, rurayashqancunata Jesusta willayarqan. Jesusnam pecunallata pusharcur, Betsaida marcapa eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nunacunanam tseta musyarirnin, qatiyarqan. Pecunata chasquirirnam, Diospa mandaquinincho imano cayänanpaq Jesus yachatsicorqan, y qeshyaqcunata cachacätserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tardiyäquicuptinnam, chunca ishque (12) apostolnincuna Jesusman witirirnin, queno niyarqan: —Tëte, tardiyäquicunnam. Que tsunyaqchoqa manam ni imapis cantsu. Que nunacunata witsiratsina tse ure marcacunapa y estansiacunapa ewcur, miquinincuna y posadancuna ashiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesusnam nerqan: —Qamcunam pachanqa qarayänequi. Apostolnincunanam niyarqan: —¡Pitsqa tantawan ishque pescadullam capamantsic! Que tsica nunacunapaqqa rantimur, ¿imaraqchi tincutsishwanpis! ");
INSERT INTO qwhNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsechomi pitsqa waranqano (5,000) nunacuna quecayarqan. Tsenam disipuluncunata nerqan nunacunata pitsqa chuncapayan patsaman tätsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesus nenqannomi pecuna llapan nunacunata tätsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesusnam tse pitsqa tantata y ishque pescaduta tsarircur sieluman riquecur, Diosta “Grasias” nicurerqan. Tsepitanam tse tantata paquirir disipuluncunata qorqan nunacunata qarayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Llapancunam micuyarqan asta teqñayanqanyaq, y sobratapis elluriyarqan chunca ishque (12) canasta juntataran. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc cutinam Jesus disipuluncunawan quecar, Diosman japallan mañacorqan. Tsepitanam disipuluncunata queno taporqan: —¿Pi canqätataq nunacuna niyan noqapaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pecunanam queno niyarqan: —Waquinmi niyan qamqa bautisacoq Juanshi canqui. Waquinnam niyan Diospa profetan Eliasshi qamqa canqui. Waquincunanam niyan Diospa une tiempu profetanshi cawarimushqa canqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tsenam Jesus nerqan: —Qamcunaqa, ¿imataq niyanqui? ¿Pitaq cä? Tsenam Pedru queno nerqan: —¡Qamqa Dios Acrashqanmi canqui! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Peru Jesusnam alli buenu notificarqan: —Ama tseta pitapis willacuyanquitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tsepitanam nerqan: —Presisanmi Diospita Shamushqa Nunata jipatsiyänan, autoridacuna, saserdoticunapa mandacoqnincuna y ley yachatsicoqcuna chiquir wanutsiyänan. Peru quima junaqllatam cawarimonqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tseno nirninnam, nunacunata yachatserqan queno: —Pipis qatirämaqnï queta munarnenqa, quiquinpa muneninta jaqiricur, crus apaqno noqata qatimätsun. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pipis caweninllapaq yarparaq caqqa ushacanqam; peru noqarecur caweninta oqraq caqqa wiñe cawetam tarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Porqui ¿imapaqraq juc nunata sirwenqa jinantin mundupa dueñun canqanpis, wiñe caweta mana lobraptin! ");
INSERT INTO qwhNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sitsun pipis noqapita y alli willaquinïpita penqaconqa, tsenollam Diospita Shamushqa Nunapis pepita penqaconqa, Dios Yayapa, y santu anjelnincunapa chipapëcaq poderninwan cutimurnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Quetapis shumaq cäyirayämë: Canan quecho quecaqcunapitaqa waquinniquicuna manaran wanuyanquiraqtsu, asta Diospa mandaquininta ricayanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tseno willapäcurirnam, puwaq junaqtana Pedruta, Juanta y Santiaguta pusharcur, Diosman mañacoq jircaman Jesus ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Diosman mañaquicaptinnam, Jesuspa qaqllan juclaya ticracurerqan, ropannäqa imeca relampagunoran tillapyäcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tse öram ishcaq nunacuna yurircur, pewan parlayarqan. Pecunam cayarqan Moises y Elias. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tselaya chipapäquicaqchomi Jesusta parlapar, queno niyarqan: —Dios une dispunishqannomi Jerusalen marcacho wanunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrunam ishcan yanaqincunawan pasepa pununewan quecarnin, punïsa punïsa ricarcuyarqan Jesus Diospa poderninwan chipapëcaqta y pewan ishcaq nuna quecayaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tse ishcaq nunacuna eucoqno cayaptinnam, Jesusta Pedru queno nerqan: —Mayestru, ¡imalaya allim quecho quecantsic! ¡Quima tsucllata rurecushun: jucta qampaq, jucta Moisespaq y juctana Eliaspaq! Mana imanopis queta puedirninmi, Pedru tseno nïcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tseno nicaptinnam, pucute yurircur, llapancunata tsaparerqan. Pucute rurincho quecarninnam, disipuluncuna mantsacäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pucute rurinpitanam queno parlamoqta wiyayarqan: —Queqa noqa acrashqä cuyë tsurïmi. Peta cäsucuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tseno parlar ushariptinnam, Jesusllatana disipuluncuna ricariyarqan. Peru manam ni pitapis willacuyarqantsu jircacho ricayashqancunata Jesus que patsachoraq quecaptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Waräninnam jircapita cutiriyänanpaq, atscaq nunacuna shuyarëcayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tse atscaq nuna rurinpitanam juc nuna qayaripa queno nerqan: —Mayestru, rogacullashqequi. Japallan tsurilläta riquecallämï. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Que tsurillämi supë tsarenqan öra jinanllacho qaparir ishquirin. Tsepitanam tapsicacharcun, shiminchopis pushoqata cachutsirnin. Imepis allapam maltratan, manam ajallaqa cacharintsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Disipuliquicunatam rogacullarqö supëta qarquyänanpaq, peru pecunaqa manam puediyashqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesusnam nerqan: —¡Allau, mana marcäcoq llutan ruraqcuna! ¡Imecamayaqraq qamcunawan quecashaq! ¡Imecamayaqraq awantayashqequi! ¡Wamrata queman apayämï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Papänin wamranta aparëcaptinnam, ataquino tsarircur, supëqa patsaman ishquiratsir, tapsicacharcorqan. Tsenam supëta Jesus nerqan: —Que wamrapita yarqï —nirnin. Tsepitanam wamrata cachacashqatana, papäninta qoycorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tseta ricarninnam, Diospa allapa puedeq queninta llapancuna espantacuyarqan. Jesus rurashqancunapita nunacuna espantashqa quecayaptinnam, disipuluncunata Jesus nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Canan willayashqaqta wiyar, alleq cäyiyämë. Diospita Shamushqa Nunatam chiqueqnincunapa maquinman entregayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Peru disipuluncunaqa Jesus nishqanta manam cäyiyarqantsu, cäyiquinincuna pishiptin. Y mantsacuyarqanmi tapiquita tse nenqam ima ninan canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsepitanam disipuluncuna quiquincuna pura piñatsinacuyarqan, llapanpita mas presisaq queta munarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Tseno pensayanqanta Jesus musyarirninnam, juc wamrata nopanman shäratsirnin, queno nerqan: —Pipis queno wamrata jutïcho chasquerqa, noqatam chasquiman. Y noqata chasquimarneqa, cachamaqnïtapis chasquenqam. Porqui qamcunacho mas qollmi shonqu caqmi, llapequipitapis mas presisaq canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juannam queno nerqan: —Mayestru, noqacunam ricayarqö juc nunata supëyoq nunacunapita supëcunata jutiquicho qarqoqta. Peru mana noqantsicwan puriptinmi, michäyarqö. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tsenam Jesus queno nerqan: —Ama michäyanquimantsu carqan. Pipis mana contrantsic carqa, noqantsicwanmi quecan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sieluman Jesus cuticunanpaq ichicllana pishicaptinnam, eucorqan balorta tsarïcur Jerusalen marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tsenam willacoqcunata cacharqan puntata ewayänanpaq. Pecunanam Samaria marcaman chäriyarqan, Jesuspaq posadata ashirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Peru Samaria nunacuna manam chasquiyarqantsu, Jerusalenman pe ewashqanta mäquicur. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tseta ricarninnam, disipuluncuna Santiagu y Juan queno niyarqan: —Teyta Jesus, ¿munanquicu sielupita nina shamur, que nunacunata ushacäratsinanpaq, Diosman mañaquicuyänäta? ");
INSERT INTO qwhNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tseno niyaptinnam, Jesus pecunaman tumecur piñaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsepitanam juc marca nänipa eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nänipa ewarëcayaptinnam, Jesusta juc nuna queno nerqan: —Mayestru, meta tseta ewaptiquipis, noqaqa qatishqequim. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesusnam nerqan: —Atoqcunapa machenin canmi. Pishqucunapapis qeshun canmi. Peru Diospita Shamushqa Nunapaqa manam ni iman cantsu jamarinanllapaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Juc nunatanam Jesus nerqan: —Noqata qatimë. Tse nunanam nerqan: —Teyta Jesus, qamwan eucunapaq papänïtaraq pampamushaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tsenam Jesus nerqan: —Wanushqano caqcuna wanushqacunataqa pampacuyätsun. Peru qamqa ewar, willaquï Diospa mandaquinincho imano canantsicpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Juc nunanam nerqan: —Teyta Jesus, noqaqa qatishqequim, peru ewä wayïcho caqcunataraq despidicaramushaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tsenam Jesus nerqan: —Pipis qepaman ricarëcar yapyaquicaqno caqqa manam sirwintsu Diospa mandaquinincho queta. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsepitanam Jesus, qanchis chunca ishque (72) nunacunata acrarirnin, ishquepayan cacharqan pepa puntanta me tse marcacunamanpis chänan caqmanqa ewayänanpaq, ");
INSERT INTO qwhNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","queno nishpa: —Cosecha poqicaqnomi nunacuna ellipaq quecayan. Tseno captinpis, wallcallam elloqcuna cayan. Tsemi Teyta Diosman mañacuyë elloqcuna mas atscaq cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Canan ewayë. Qamcunatam cachayaq imeca achcas atoqcunapa chopinpa ewaq cuentatano. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ewar ama qelleta ni mircapata ni trocacuyänequipaq llanqita apayanquitsu. Nänipa ewarnin, ama pitapis parlaparnin, shäcuyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Me marcaman charninpis, wayincunaman chasquiyäshuptiqui, napacuriyanqui, ‘Quecho quecaqcuna shumaq cawaquicho cacuyë’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tsecho juc nuna shumaq cawaquicho captenqa, willacuyanqequi bendisionmi pecunacho quedanqa. Mana tseno captenqa, qamcunawanmi tse bendision cuticonqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Posadacur, tse wayicho qarayäshonqequita micuyanqui upuyanqui, porqui uryaqtaqa combieninmi pachan qarayänan. Tsemi ama wayin wayin puriyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Me marcamanpis chäriyaptiqui, wayiyoq cushishqa chasquiyäshuptiqueqa, qarayäshonqequita micuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tse marcacho qeshyaqcunata cachacätsiyanqui. Y nunacunata willapäyanqui ‘Dios mandacoqniquicuna cananpaq tiempu chäramunnam’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sitsun juc marcaman chäyaptiqui, nunacuna chasquiyäshunquitsu, callincunapa ewar, queno niyanqui: ");
INSERT INTO qwhNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Quiquiquicuna culpayoq cayanqequita musyayänequipaqmi, marquequicunapa polbun llanqïcunacho laqacashqatapis tapsicuriyä. Peru musyayë: Dios mandacoqniquicuna cananpaq tiempu chäramunnam’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Niyaqmi, que mundu ushacänan junaqmi, Sodoma marca nunacuna castigashqa cayanqanpitapis mas feyupa pecuna castigashqa cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Allau, Corasin marcacho y Betsaida marcacho täraq nunacuna! Sitsun marquequicunachono Tiro y Sidon marcacho milagrucunata ruräman carqan; menam tse nunacuna yana jacuncunata yacacurcur, uchpawan pichucur, jutsancunata jaqirïcur Diosman cuticushqa cayanman carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tsemi juisiu junaqcho Tiro y Sidon marca nunacuna castigashqa cayanqanpitapis, mas feyupa castigashqa cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y qamcuna, Capernaum marcacho täraq nunacuna, ‘Sielumanmi ewayäshaq’ ¿niyanquicu? ¡Manam, infiernuman qarpushqam cayanqui!” ");
INSERT INTO qwhNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tsepitanam disipuluncunata nerqan: —Qamcunata pipis wiyayäshurniqueqa, noqatam wiyecayäman. Qamcunata mana cäsuyäshurniqueqa, noqatapis mana cäsumaq cuentam quecayan, y noqata mana cäsumaqcunaqa, cachamaqnïtapis mana cäsoq cuentam quecayan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsepitanam qanchis chunca ishque (72) ewaqcuna allapa cushishqa cutirirnin, Jesusta willayarqan: —Teyta Jesus, asta supëcunapis cäsuyämashqam jutiquicho mandayaptï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesusnam nerqan: —Aumi, imeca rayunoraq rara sielupita diablu jeqamoqtam ricarqö. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Noqam podernïta qoyarqoq diablupa llapan puedeq queninta bensiyänequipaq, tsenolla culebracunatapis, atoq curucunatapis jalucacharcuyänequipaq; y manam ni ima pasayäshunquitsu qamcunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Peru supëcuna tseno cäsuyäshonqequitaqa, ama cushiyëtsu; antis sielucho jutiquicuna apuntashqa canqanta masqa cushicuyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tse öranam Santu Espiritupa poderninwan shonqun allapa cushicuptin, Jesus queno nerqan: —Sieluchopis patsachopis mandacoq Dios Yaya, qamtam alabecoq. Porqui yachaq tucoqcunataqa y musyaq tucoqcunataqa manam boluntaniquita cäyiratserqonquitsu; peru qollmi shonqu nunacunataqa cäyiratserqonquim. Aumi, Dios Yaya, tseno canantam munarqonqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Dios Yayämi llapan imecacunachopis mandacunäpaq podernï qomashqa. Dios Yayallam noqata reqiman, y noqallam Dios Yayäta reqï y noqa reqitsiptïllam waquincunapis Dios Yayata reqiyanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsepitanam disipuluncunaman witïcur, pecunallata queno nerqan: —Cushicuyätsun qamcuna ricayanqequita ricaqcuna. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tsemi niyaq: Diospa une profetancuna y reycuna que ricayanqequicunata riqueta munecarpis, manam ricayarqantsu; y canan wiyayanqequicunata wiyeta munecarpis, manam wiyayarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsenam ley yachatsicoq juc mayestru yachecarnin, arde upa tucur, Jesusman chärir queno taporqan: —Mayestru, ¿imatataq rurashaq wac bidacho wiñepa cawanäpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesusnam nerqan: —¿Imanotaq Moises escribishqan ley yachatsicun? ¿Imatataq cäyinqui? ");
INSERT INTO qwhNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ley yachatsicoqnam nerqan: —Tsechoqa quenomi yachatsicun: ‘Teyta Diosniquita cuyanqui llapan shonqiquiwan, llapan boluntaniquiwan, llapan callpequiwan, y llapan yacheniquiwan. Y nuna mayiquita cuyanqui quiquiquitano’ ninmi, nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tsenam Jesus nerqan: —Nenqequeqa allim. Tsecunata rurarnenqa, wac bidachomi wiñepa cawanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ley yachatsicoq mayestrunam quiquincho alli tucur, taporqan queno: —¿Pitaq tse nuna mayïqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesusnam queno nerqan: —Juc nunam Jerusalenpita ewecarqan Jerico marcaman. Nänichonam suwacuna llapan apanqancunata asta ropancunatapis limpu qochir, allapa maqacacharcur, wanuquicaqta jaqirïcur, eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tse nänipam juc saserdoti pasarnin, tse nunata riquecarpis, juc ladupa pasacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tsenollam Levitapis nuna jitarëcaqta riquecur, jina juc ladupa pasacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Peru Samaria nuna tsepa euquicarnam, nunata taririr, allapa ancuparqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nopanman witicurnam, eridancunata aseitiwan y binuwan jampirir, shumaq wataraporqan. Tsepitanam ashnunman montarcatsir, juc posadaman apecur, tsecho täpararqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Waränin qoyanam ishque qelleta posadatsicoq nunata pagarqan, queno nishpa: ‘Que nunata shumaq jampipecullanqui. Masta gastaptiquipis, cutïcamurmi paguecullashqequi’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","‘Canan tapushqequi: Que quimanpeq ¿meqan caqtaq nuna mayintano tratarqan tse suwacuna golpiquicushqa nunata?’ ");
INSERT INTO qwhNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ley yachatsicoqnam nerqan: —Tse ancupaq caqchi —nir. Tsenam Jesus nerqan: —Canan qampis ewar, tsenolla ancupäcoq canqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tsepitanam Jesus disipuluncunawan eucurëcarnin, chärerqan juc marcaman. Tsechonam Marta niyashqan warmi combidarqan wayinman. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa nananmi carqan Maria. Pemi Jesus yachatsiconqancunata wiyacurnin, nopancho täquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Peru Martanam imecapis rurecunawan ocupadu carnin, Jesusman witicur nerqan: —Teyta Jesus, ¿manacu ancupämanqui quecho nanä täconqanyaq japallä imecatapis ruranqäta? ¡Nïquï yanapamänanpaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tsenam Jesus nerqan: —Ä Marta, Marta. Tuqui rurecunapaq yarpacacharmi, qam tranquilutsu canqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peru jucllellam can mas presisu rurayänequipaq. Tse alli caqtam nanequi Mariaqa acrashqa, y manam pipis tseta qochenqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Juc cutim Diosman Jesus mañaquicarqan. Mañacur ushariptinnam, jucnin caq disipulun queno nerqan: —Teyta Jesus, Diosman mañacuyänäpaq, noqacunatapis yachecatsiyämë, bautisacoq Juan disipuluncunata yachatsishqanno. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesusnam nerqan: —Mañacurnin queno niyanqui: ‘Sielucho quecaq Dios Yayalläcuna, jutillequi allapa respetuwan alabashqa catsun. Llapan nunacuna mandadiquicho catsun. ˻¡Sielucho caqcuna qam mandaconqequita rurayanqannolla, que patsachopis nunacuna rurayätsun!˼ ");
INSERT INTO qwhNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Miquilläcuna cada junaq qoycalläyämë. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mana alli rurayämaqnïcunata perdonayanqänollä, jutsalläcunapita perdonecalläyämë. Jutsa rureman diablu ishquitsiyämeta munaptin ama jaqiralläyämëtsu; ˻antis librecalläyämë jutsaman mana ishquilläyänäpaq.˼’ ");
INSERT INTO qwhNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tsepitanam Jesus queno yachatsicorqan: —Masqui, jucniquicunapa amiguiqui catsun, y pepa wayinman pullan paqas ewar, queno niyë: ‘Amigu, quima tantallä mañecamë. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc amigümi carupita chämushqa, y manam ni imällapis cantsu qararinäpaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Peru ruri wayinpitanam yasquiyäshunqui: ‘Que öraqa ¿imaqtaq shamunqui puninïtapis chawätsimarnï? Puncüpis trancashqanam. Wamräcunapis y noqapis punuquicayänam. Manam shärimunätsu mañamanqequita qonaqpaq’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Noqam niyaq: Manam chunca amiguiqui carpis, sharcamunmantsu mañaconqequita qoshunequipaq; peru sitsun seguidu tsactacuyanqui, sharcamurmi mañacuyanqequita qoycuyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tsemi noqa niyaq: ¡Imatapis mañacuyaptiqueqa, Dios qoyäshunquim! ¡Asherqa, tariyanquim; puncuta tsactacuyaptiquipis, quichapuyäshunquim! ");
INSERT INTO qwhNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porqui mañacoq caqqa chasquinmi; asheq caqqa tarinmi; puncuta tacacoq caqtaqa quichapuyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Acasu meqequipis tsuriquicuna ˻tantata mañayäshuptiqui, ¿rumincu qoyanqui?˼ Y pescaduta mañacuyäshuptiqui, ¿culebrancu qoycuyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jina ruruta mañayäshuptiqui, ¿atoq curuntsuraq qoycuyanquiman? ");
INSERT INTO qwhNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Si qamcuna mana alli ruraq quecarpis tsuriquicunata allicunata qoyanqui, sielucho quecaq Dios Yayanäqa mas alli carmi, mañacoqcunataqa Santu Espiritunta qoyconqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cutim Jesus mudu nunapita supëta qarqorqan. Tsenam supë yarquriptin, tse nuna parlar qallecorqan, y nunacunanam allapa espantashqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Peru waquinnam queno niyarqan: —Que nunaqa supëcunapa mandacoqnin Beelzebupa poderninwanmi nunacunapita supëcunata qarqun. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquincunanam Jesusta pantatsita munarnin, munayarqan Diospa poderninwan juc milagruta rurananta. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Penam tseno pensayanqanta musyarnin, queno nerqan: —Sitsun juc nasioncho nunacuna quiquincuna pura chiquinacuyanqa, raquicarmi, ushacäriyanqa. Jina juc wayicho yachaqcuna chiquinaquillacho cacorqa, tse wayicho ushacäriyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tse cuentanollam diablu quiquin pura contranacur, mandaquininta ushacäratsinman. Tseta niyaq ‘Beelzebupa poderninwanmi supëcunata qarqun’ niyämaptiquim. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tseno Beelzebupa poderninwan supëcunata qarquptïqa, ¿pipa poderninwannataq qamcunapa qatiräshoqniquicunaqa supëcunata qarquyan? Pecuna rurayashqancunam cäyitsiyäshunqui mana caqta parlayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Peru sitsun Diospa poderninwan supëcunata noqa qarqicä, musyariyanquim Diospa puedeq quenin qamcunaman chäramonqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Masqui juc nuna callpayoq car, wayinta garuntinwan täpatsun, manam ni pi imancunatapis suwayanmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Peru pepeq mas wapun caq nuna chärerqa, tse puedeq nunata maqacacharcurmi, garutinman marcäquicaptinpis qochirir, llapan imancunatapis apacurnin, munashqanta ruraconqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Pipis mana noqawan caqqa, noqapa conträmi quecan, y noqawan mana elloq caqqa, masmi nunacunata ramacacharcur ushacäratsin. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Supëyoq nunapita supë yarqurirmi, tsunyaqcunapa ewar, mechopis jamacunanpaq ashirnin purican. Mana tarirninnam, queno nin: ‘Yarqamonqä nunamanmi cuticushaq täraq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cutïcurnam, tse nunapa shonqunta tarin imeca shumaq pitsapäcushqa jayaquicaq wayitano. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsenam tse supë ewar pepitapis mas mana alli ruraq qanchis supëcunata mincaquicur cutïcun, y llapanmi yecuriyan nunapa shonqunman. Tsenam tse nuna nopa canqanpitapis mas peor ticracurin.” ");
INSERT INTO qwhNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus tseno yachatsiquicaptinnam, nunacunapa chopinpita juc warmi qayaripa queno nerqan: —¡Allapa cushiquiyoqchi wachashoqniqui y chichishoqniqui mamequi! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tsenam Jesus yasquerqan queno: —Antis Diospa palabranta wiyar cäsucoqcunam, mas cushishqaqa cayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Allapa atscaq nunacuna elluquecuyaptinnam, Jesus queno nerqan: —Que tiempu nunacunaqa allapa mana alli ruraqmi cayanqui. ¡Juc milagru ruranätaran munayanqui! Peru qamcuna munayanqequinoqa manam ima milagrutapis rurashaqtsu. Tsepa rantenqa Teyta Diosmi juc milagruta noqacho ruranqa profeta Jonascho ruranqantano. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Imanomi Jonascho Dios ricatsicorqan juc milagruta Ninive marcacho, tsenomi pe ricatsiconqa juc milagruta, Diospita Shamushqa Nunacho canan tiempu nunacuna ricayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Juisiu junaqchomi, Shebapita reinapis Diospa nopancho shimpir condenayäshunqui canan tiempu nunacunata. Porqui tse warmeqa Salomon allapa yacheninwan parlaqta wiyaqmi allapa caru marcapita shamorqan, y Salomonpitaqa canan qamcunawan quecho quecaqmi mas poderyoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tsenollam jina juisiu junaqcho que tiempu nunacunata Ninive marca nunacuna shimpiyäshunqui, porqui pecunaqa Jonas willaconqanta wiyar cäsucurmi, jutsancunata jaqiriyarqan, y Jonaspitaqa canan qamcunawan quecaqmi mas puedeq, peru manam cäsuyämanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Lamparinta sendircur, manam manca rurinmantsu, ni memanpis pacapamantsu churantsic; sinoqa raramanmi churantsic, wayiman yecoqcunata actsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nawiquicunam imeca chiuchino qamcunapaq. Tsemi nawiquicuna alli captenqa, actsicho cayanqui; peru mana alli captenqa, paqaschomi cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","¡Paqtaraq yö! Qamcunacho rasonpa caq quecaqta actsi upireqno ushacäratsiyanquiman. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sitsun qamcuna actsichono cawayanqui, y paqaschonotsu cawayanqui; llapantam alli cäyiriyanqui, imeca actsi llapanta actseqno.” ");
INSERT INTO qwhNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus yachatsicur ushariptinnam, juc fariseu wayinman pusharqan micuyänanpaq. Yecurirnam, Jesus täcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Peru costumbrincunamanno maquinta mana paqacurir, micuptinnam, tse fariseu allapa espantashqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Teyta Jesusnam nerqan: —Qamcuna fariseucuna, tasacunata, platucunata jananllata paqarishqa cuentam janallapa limpiu quecayanqui, peru shonqiquicunachoqa codisiosu y suwam quecayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Upa nunacuna, ¿manacu musyayanqui janequicunatapis ruraq Dioslla shonqiquicunatapis ruranqanta? ");
INSERT INTO qwhNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tsemi wactsacunata llapan shonqiquicunawan ancuparnin, imanllapis qarayë. Tsenopam janapapis y ruripapis limpiu cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Allau, fariseucuna! Qamcunam mentapita, rudapita y waquin qorapita diesmipaqtä yarparaquicayanqui, peru Diospaq alli cawaquitaqa y rasonpa cuyaquïnintaqa qonqaquicuyarqonquim. Tsecunatam mas rurayanquiman carqan, diesmu qoyta mana qonqashpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Allau, qamcuna fariseucuna! Ellucayänan wayichopis mas presisaqcuna täcuyänanmanmi täquita munayanqui. Callicunachopis puriyanqui, nunacuna respetar saludayäshunequita munarmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Allau, qamcuna! Mana ricacoq aya pamparaq cuentam cayanqui. Tse aya pamparaq jananpam nunacuna puriyan, rurincho ima canqantapis mana musyashpa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesus tseno niptinnam, ley yachatsicoq nuna queno nerqan: —Mayestru, tseno parlarnenqa, noqacunatapis ofendiyämanquim. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tsenam Jesus nerqan: —¡Allau, qamcunapis, ley yachatsicoqcuna! Allapa mana rurepaqtanomi mandacuyanqui nunacuna rurayänanpaq; peru tse mandacuyanqequita manam quiquiquicunaqa dediquicunallawanpis yatariyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Allau, qamcuna! Diospa profetancunatam awiliquicuna wanutsiyarqan, peru qamcunanam pamparëcanqan sepulturancunata shumaq rurecatsiyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tseno rurayanqequiwanmi testigu cuenta, une awiliquicuna rurayanqanwan acuerdu cayanqui. Porqui pecunam wanutsiyarqan; qamcunanam sepulturancunata shumaq rurecatsiyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tsemi Dios allapa yachaq carnin, queno nerqan: ‘Pecunamanmi cachashaq profetacunata y apostolcunata. Pecunapitam waquinta wanutsiyanqa, y waquincunatanam mana alli ruraqtano chiquir qaticachäyanqa.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Tsemi que patsa qallanqanpita Diospa profetancunata castancuna wanutsiyanqanta, canan tiempu nunacuna pagacuyanqa, ");
INSERT INTO qwhNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel wanushqanpita asta Zacarias wanushqancamayaq. Zacariastam wanutsiyarqan altarpa y santisimupa nopancho. Rasonpam niyaq: Pecunapa yawarnincunapitam canan tiempu nunacuna pagacuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Allau, ley yachatsicoqcuna! Nunacuna yachaquita munayaptinpis, manam yachatsiyanquitsu. ¡Manataq Teyta Diosta cäsuyanquitsu y waquincuna cäsuquita munayaptinpis, atajaq cuentataq quecayanqui!” ");
INSERT INTO qwhNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus eucuptinnam fariseucuna y ley yachatsicoqcuna allapa piñarcurnin, qatiyarqan tuquilayapa tapupar achäquita ashipäyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tsemi pantatsita munar, imatapis parlananta munayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tsenam allapa atscaq nunacuna waranqa waranqapayan ellucar, quiquincuna pura cumanacur jalunacuyarqan. Tsechonam disipuluncunallata puntata yachatsirnin, Jesus queno nerqan, “Alli tucoq fariseucunaqa imeca lebaduranomi cayan. Tsemi pecunapita cuidacuyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porqui imapis pacallapa rurayanqan manam pacarëcarqa quedanqatsu; sinoqa llapanmi musyacashqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Paqaspa parlayanqequitam junaqpana wiyayanqa; y paquellapa wayi rurincho parlayanqequitanam, wayicunapa jananman lloqarcur qayaripa willapäcuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amigücuna, qamcunatam niyaq: Ama wanutsicoqcunata mantsayëtsu, porqui wanuratsiyäshurniqui, mananam ni imata rurayäshunquinatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Peru noqam yachatsiyashqequi pita mantsayänequipaqpis: Mantsacuyëqa wanuratsiyäshurniqui, puedeq queninwan infiernuman qarpuyäshoqniquita. Tsemi willayaq pellatana mantsacuyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Manacu pitsqa pishqupa ishque sentabulla chanin! Tseno quecaptinpis, pecunapaqqa Dios imepis yarparëcanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y qamcunapatanäqa llapan aqtsequicunatapis jucllellapayan yupashqam quecatsin. Tseno quecaptenqa, ama imatapis mantsacuyëtsu. Porqui atsca pishqocunapitapis qamcunaqa masmi baliyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Noqam niyaq: Pipis nunacunapa nopancho noqapa fabornï willacuptenqa, Diospita Shamushqa Nunapis anjelcunapa nopanchomi pepa fabornin willaconqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Peru nunacunapa nopancho negamaqtaqa, noqapis negashaqmi Diospa anjelnincunapa nopancho. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Diospita Shamushqa Nunapaq, pipis contran mana allicunata parlaptenqa, Dios perdoneconqam; peru Santu Espiritupa contran mana allicunata parlayaptenqa, Dios manam perdonanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ellucayänan wayiman o juescunaman o meqan autoridacunaman demandayäshuptiqui, ama llaquinayanquitsu ‘¿Imanoraq parlashaq? ¿Imanoraq defendicunäpaq parlashaq?’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tse parlayänequi öram Santu Espiritu yachatsiyäshunqui imatapis niyänequipaq.” ");
INSERT INTO qwhNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nunacunapa chopinpitanam Jesusta juc nuna queno nerqan: —Mayestru, niquï wauqïta tocamanqan erensiata raquimänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tsenam Jesus nerqan: —Tëte, noqaqa manam juestsu cä tse erensiata raquiyänaqpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsepitanam llapan nunacunatana Jesus queno nerqan: —¡Paqtaraq yö! Mallaqäcoq cayanquiman, tsepita cuidacuyë. Nunacuna alli cawayänanpaqqa manam presisantsu capoqyoqraq cayänan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tseno nirirnam iwalatsiquiwan Jesus queno yachatsicorqan, “Juc ricu nunapam chacrancho allapa atsca cosechan carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tsenam yarpacachar, queno nerqan, ‘¿Imataraq rurashaq? ¿Memanraq cosechäcunata churashaq?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tseno pensarirnam ‘Quenomi rurashaq’ nerqan. ‘Churanäcunata shoqllirirninmi, mas jatusaqtana rurashaq. Tseman cosechäcunata y llapan capamaqnïta churanäpaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tsenam shonqücho nishaq, ‘Atsca watapaqmi capaman imecapis. Cananqa manam afanacushaqnatsu uryeta. Micucur upucur, cushishqanam cacushaq’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Peru Diosnam queno nerqan, ‘¡Qamqa upam canqui! ¡Canan paqastämi wanunqui! ¿Llapan churashqequicunapis pipaqraq canqa?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Tsenomi Diospaq mana yarpacachashpa imecatapis quiquinllapaq elloq nunataqa pasan.” ");
INSERT INTO qwhNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus tseno yachatsiquicarnam, disipuluncunata nerqan “Tsemi niyaq: Ama yarpacachäyëtsu, queno nirnin ‘¿Imataraq micurishaq? ¿Imataraq yacacushaq?’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Porqui miquipitaqa caweniquicunam mas balin, y ropapitaqa qamcunam mas baleq cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cuentata qocuyë. Pishqucuna manam murucuyantsu, ni miquicunata ellupäcuyantsu, ni churanancuna cayäpuntsu. Peru Diosmi pacha juntata wätan, y pishqucunapitaqa qamcunam mas baleq cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Meqequicunataq tse yarpacachëniquicunawan juc junaq maslla cawarcuyanquiman! ");
INSERT INTO qwhNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mana ni tse ichicllatapis rureta puedicar, ¿imapaqtaq que bidacho caqcunallapaq yarpacachäyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ricayë jircacunacho wetacuna imano winaqta. Pecuna manam uryayantsu ni putscayantsu. Peru tseno quecaptinpis, wetacunapa colorninwanqa manam puedeq rey Salomonpa chaniyoq ropanpis iwalarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Si ware waratin ninacho cayacar ushacäreqlla qoracunata Teyta Diosnintsic tseno shumaq bistitsin, qamcunatanäqa masran bistitsiyäshunqui. ¡Claru parlaquichoqa marcäquiniquicunam pishin! ");
INSERT INTO qwhNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tseno quecaptin, ama yarpacachar llaquinashqa puriyanquitsu ‘¡Imataraq upushun y micushun!’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porqui Diosman mana marcäcoq nunacunam tsecunallata yarpacachar, ashiyan. Peru Dios Yayaqa musyanmi qamcunapa imequicuna pishenqantapis. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tsemi qamcunaqa yarpacachar, ashiyänequi Diospa mandaquinincho cayänequipaq, y tsellamannam ima pishipuyäshonqequicunatapis chasquiyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Qatirämaqnïcuna, wallcalla carpis, ama mantsacuyëtsu, porqui Dios Yayam cushishqa qamcunata churayäshunqui pepa mandaquinincho cayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Imequicunatapis rantiquicur, wactsacunata qellenincuna raquicuyë. Mana ushacäcoq riquesata rurayë, y sielucho mana ushacaq fortunata ashiyë. Tsemanqa manam suwapis chantsu, ni tsechoqa puyupis ushantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porqui mechomi fortunequi canqa, tsellamanmi shonqiquipis niräquicanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Qamcuna tseqllequicunata alli watarcur, actsiquicunapis rupecaq cuenta listu quecayë. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imeca sirwipacoq nunacuna patronnin casaqui fiestapita cutirinanta shuyaraqno cayë. Pecunam patronnin chärir, puncuta tsactacuriptin, jinallacho quichariyan. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tseno sirwipacoqcuna allapa cushicuyätsun, patronnin chärir, shuyaquicaqta tarenqanrecur. Rasontam niyaq: Quiquin patronmi mandilnin churacurcur, tse sirweqnincunata tëcatsir, micunancuna qaranqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Capaschi pullan paqas o madrugadu patronnin chärenqa, y mäcoq mäcoq quecaqta tarenqa. Tseno captenqa, allapa cushicuyätsun. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Masqui queta cäyiyë: Ime öra suwa ewananta musyarqa, wayiyoq nuna manam wayinman suwacoq yecuyänanta jaqirinmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tsemi qamcunapis mäcoq, mäcoq quecayänequi; porqui Diospita Shamushqa Nunaqa cutircamonqa qamcuna mana yarpäyanqequi öram.” ");
INSERT INTO qwhNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesus tseno niptinnam, Pedru queno taporqan: —Teyta Jesus, ¿noqacunallatacu tse iwalatsiquiwan yachatsiyämanqui, o llapan nunacunatawancu? ");
INSERT INTO qwhNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesusnam nerqan: —Pim mäcoq, mäcoq, cumplidu mayural canqa, petam patronnin confiacur churanqa wayinman, tsecho caqcunata miquinincuna örancho qarananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tseno ruraq sirwipacoqqa patronnin illanqanpita cutirir, llapan encargashqanta rurecaqta taririptin allapa cushicutsun. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Masqui cäyiyë: Tseno cumplidu sirweqnintaqa ¿manatsuraq tse patronnin llapan imecancunamanpis confiadu cananpaq churecunman! ");
INSERT INTO qwhNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Peru sitsun tse sirwipacoq ‘Patronnï manaran cutimonqaraqtsu’ nir, sirwipacoq mayincunata warmitapis ollqutapis maqar allqutsanqa, y micucur upyacur machacur caconqa; ");
INSERT INTO qwhNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tseno caquicaptenqa, manaraq alistacur shuyaptinmi, patronnin illaqpita chëcur, tse mana alli ruraq sirweqninta feyupa castiganqa, mana cäsucoqcunatawan iwal. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Meqan sirwipacoqpis patronnin munashqanta musyecarnin, mana cäsuptenqa, y mana mäcoq mäcoq quecaptenqa, tse sirweqninta allapa maqarmi feyupa castiganqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Peru mandacushqancunata mana musyar mana allita ruraptenqa, ancupashllapam patronnin maqanqa. Tsemi pitapis atscata qoycorqa, atscatam cutitsinanta munanqa; y pitapis mas marcäcorqa, mastam pepeq munanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Noqa shamushqa cä que patsaman imeca nina rupecaqno mana allita ushacätsinäpaqmi. Ojala menapis cumplicärinman. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Peru noqa allapa jipaquicunata pasanäran presisan. Tsetam allapa llaquicur, shuyarä asta cumplicärenqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Qamcuna pensayanqui que patsaman alli cawaqui apamonqätacu? Manam tsenotsu. Noqarecurmi nunacuna quiquincuna pura raquicacuriyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpita witsepam juc wayicho pitsqaq quecar, raquicayanqa. Quimaq caqmi ishcaqpa contran cayanqa. Ishcaqnam tse quimanpa contran cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tsurinpa contranmi papänin canqa, papäninpa contrannam tsurin, warmi wawanpa contranmi mamänin, mamäninpa contrannam wawan, llumtsininpa contranmi suegran y suegranpa contranmi llumtsinin canqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Quetapis nunacunata Jesus nerqanmi: “Inti jeqanan laducho pucute shäreqta ricarninmi, niyanqui: ‘Tamyamonqanam’ nishpa. Tse niyanqequinollam tamyan. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wacpita bienturamuptinnam, niyanqui ‘Achachämonqam’ nishpa. Tse niyanqequinollam achachan. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Tsecunataqa allim musyayanqui, alli tucoqcuna! ¡Peru manam musyayanquitsu que tiempucuna ima señal pasaquicanqanta! ");
INSERT INTO qwhNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Imanirtaq quiquiquicuna yarpacachäyanquitsu allita o mana allita rurayanqequita! ");
INSERT INTO qwhNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sitsun pipis demandashurniqui, juesman apatsiyäshunqui, manaraq juespa puncunman char amishtaquita tïrayë. Porqui juesqa capas pasaratsiyäshunqui wardiacunaman, y pecunanam carselman llawiriyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Noqam niyaq: Llapan jaqa queniquita manaraq pagacorqa, manam tse carselpita yarquyanquitsu” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tsechonam waquin nunacuna Jesusta willayarqan Galilea nunacunata Pilatupa cachancuna wanutsiyanqanta. Wanutsiyänan örash tse nunacuna animalcunata wanutsir Diospaq presentecayänaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tseta willayaptinnam, Jesus nerqan, “Qamcunaqa pensayanqui tse wanoq nunacuna tseno sufrir wanuyanqanrecur, ¿waquin marca mayincunapitapis mas jutsayoq cayanqantacu? ");
INSERT INTO qwhNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Peru manam tsenotsu. Sitsun qamcunapis jutsequicunata jaqiyanquitsu, tse nunacuna ushacäyanqannollam, qamcunapis ushacäyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Puntatam Jerusalencho Siloe nishqan torri juchur, chunca puwaq (18) nunacunata wanutserqan. Qamcuna pensayanqui tseno wanuyanqanrecur, ¿marca mayincunapitapis mas jutsasapa cayanqantacu? ");
INSERT INTO qwhNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Peru manam tsenotsu. Sitsun qamcunapis jutsequicunata mana jaqiyanquitsu, pecuna ushacäyanqannollam, qamcunapis ushacäyanqui.” ");
INSERT INTO qwhNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tseno nirninnam, iwalatsiquipa Jesus yachatsicorqan queno: “Juc nunapam caporqan igus montin chacrancho. Juc cutinam tse nuna ewarqan ricaq ‘Mä, ¿igusnï wayuncush?’ nir, peru manam ni jucllellatapis tarerqantsu frutanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsenam chacra nunanta tse chacrayoq queno nerqan: ‘Quima watanam que montïman shamü frutan asheq, peru manam tarïtsu. Wallurïquï. ¡Imapaqmi mana wayïcar chacrächo canqa!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Peru nunanam queno nerqan: ‘Tëte mä, que watallana caritsun. Oqtipärirmi, wanun jicharishaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsenopa itsa que wata wayurinman. Mana wayuptinnachi, wallurishun’ nir.” Tseno nishpam, Jesus israel nunacunata igus montitawan iwalatsir, yachatsicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jamaqui sabadu junaqchonam, ellucayänan wayicho quecayaptin, Jesus yachatsiquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tsechomi juc warmi quecarqan chunca puwaq (18) watana qoruyashqa. Tse warmi manam derechaqueta puedeqtsu, supë peta jipatsiptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesusnam tse warmita ricarirnin, qayecur queno nerqan: —Mame, cachacashqanam canqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tseno nirninnam, warmiman maquinta churarqan. Tse öram warmi derechacärir, Diosta grasiasta qor alabarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tsenam tse ellucayänan wayicho mandacoq nuna piñacorqan, jamaqui sabadu junaqcho Jesus cachacätsishqa captin; y nunacunatanam nerqan: —Joqta junaqllam uryantsic. ¿Imanirtaq jamaqui sabadu junaqchoraq shayämunqui cachacätsiyäshunequipaq! ¿Manacu tse uryanantsic junaqcunacho shayämunquiman! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsenam Jesus nerqan: —¡Alli tucoqcuna! ¿Manacu meqequipis jamaqui junaqcho toriquicunata o ashniquicunata pascarir, yacutseq apayanqui! ");
INSERT INTO qwhNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Que warmeqa une Abrahampita castantsicmi. ¡Allau! Chunca puwaq (18) watam diablu qeshyatsir jipatsishqa. ¿Manacu jamaqui junaqchoqa qeshyëninpita cachacätsïman! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tseno niptinnam, Jesus chiqueqcuna penqacuyarqan. Peru waquin nunacunanam allapa cushicuyarqan, espantepaq rurashqancunata ricarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tsenam nunacunata Jesus nerqan, “Diospa mandaquinin, ¿imawanraq iwalanman? ¿Imatawanraq iwalatsïman? ");
INSERT INTO qwhNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tseqa imeca mostasa murunomi. Tse murutam juc nuna wertanman murun. Jeqaramurnam, winar jatun monti ticrarin. Tse montimannam pishqucuna shamur rämancunacho qeshuncuna rurayan.” ");
INSERT INTO qwhNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tseno nirirnam, queno nerqan: “Diospa mandaquinincho cawaquita ¿imawanraq iwalatsïman? ");
INSERT INTO qwhNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tseqa imeca juc warmi quima tupu jarinaman ichiclla lebadurata winarcur pichuriptin masata poqucaratseqnomi.” ");
INSERT INTO qwhNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsepitanam Jerusalenman Jesus ewar marcan marcan pasarnin, nunacunata yachatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tsechonam juc nuna taporqan queno nishpa: —Tëte, ¿wallcaqllacu nunacuna salbacuyanqa? Jesusnam yasquerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Callpata tsariyë. Imeca quichqui puncupa yecoqno imanopapis Diospa mandaquininman yequita tïrayë. Noqam niyaq: Atscaqmi ashiyanqa yequita munar, peru manam puediyanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wayiyoq nunam sharcur puncunta wichqarenqa. Jaqchonam qamcuna tsactacur rogacur queno niyanqui: ‘Tëte, quicharalläyämë.’ Ruripitanam wayiyoq queno niyäshunqui: ‘¡Qamcunataqa manam reqiyaqtsu! ¿Mëpitaraq cayanqui!’ ");
INSERT INTO qwhNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsenam qamcuna niyanqui: ‘Qamwanmi micuyashqa y upuyashqa cayä. Marcäcunachomi yachatsicorqequi.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Peru wayiyoqnam niyäshunqui: ‘Qamcuna me nuna cayanqequitapis manam reqiyaqtsu. ¡Llapequi mana alli ruraqcuna, nopäpita yarquyë!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tsenam tsecho allapa llaquicur waqaquicuyanqui quiriquicunatapis ruchuchutsirraq, Dios qarquyäshuptiqui, porqui Abrahamtam, Isaactam, Jacobtam, y Diospa une profetancunatam sielucho quecaqta riquecuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Diospa mandaquinincho quecaq nunacunam inti yarqamunanpita y inti jeqanan caru nasioncunapita shamurnin, Diospa mesancho micupäcuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tsemi qepacho waquin quecaqcuna puntacho cayanqa, y puntacho quecaqcunanam qepacho quedariyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tsechonam fariseucuna Jesusman chärir, niyarqan: —Rey Herodisshi wanutsishiniquita munan. Canan quepita euquï. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tsenam Jesus queno nerqan: —Qamcuna ewar, tse atoqno musyaq nunata queno willayë: ‘Canan y ware supëcunata qarqushaqran nunacunapita y qeshyaqcunatapis cachacätsishaqran. Warätinran llapan ruranäta cumplishaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Peru imano captinpis, siguishaqmi Jerusalenman ewarnin canan, ware, warätin; porqui Diospa une profetancunatanomi presisan noqatapis wanutsiyämänan. ");
INSERT INTO qwhNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Ä, Jerusalen, Jerusalen nunacuna! ¡Qamcunam profetacunata wanutsiyanqui y Diospa cachan qamcunaman shamoqcunatam chiquirnin, rumiwan qompayanqui! Atsca cutim munarqä qamcunata imeca wallpa chipshancunata ripran rurinman elloqno elluyeniquita; ¡Peru manam munayarqonquitsu! ");
INSERT INTO qwhNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tsemi niyaq: Cananpita witsepam Templiquicunapis tsunyecar quedarenqa. Y niyaqmi: Cananpita witsepa mananam ricayämanquinatsu asta ‘¡Alabashqa catsun Diospa jutincho shamoq reynintsic!’ niyamanqequi tiempuyaq.” ");
INSERT INTO qwhNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tsepitanam jamaqui junaqcho Jesus ewarqan mandacoq fariseupa wayinman micoq. Tsechonam waquin caqcunana Jesusta qawaräyarqan, “Mä, canan ¿imatash ruranqa?” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesuspa nopanchonam quecarqan pasepa jacapäquiwan qeshyaq nuna. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesusnam fariseucunata y ley yachatsicoqcunata queno taporqan: —Canan jamaqui junaqcho, ¿allicu qeshyaq nunata cachacätsïman, o manacu? Leynintsic, ¿imanotaq mandacun? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Peru pecunanam upällalla cacuyarqan. Tsenam qeshyaqta Jesus yatarirnin, cachacäratserqan, y nerqan eucunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tsepitanam fariseucunata y ley yachatsicoqcunata Jesus nerqan: —Sitsun jamaqui junaqcho tsuriquicuna o toriquicuna posuman jeqayanman, ¿manacu meqequicunapis tse öra jorquriyanquiman? ");
INSERT INTO qwhNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pecunanam mana ni ima nitapis puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tsenam combidaducuna alli silletacunata täcuyänanpaq acraqta riquecurnin, Jesus iwalatsiquipa yachatsicorqan queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Casaqui fiestaman combidayäshuptiqui, ama presisaqcunapa täcuyananman täcuyanquitsu. Talbesqa qamcunapita mas presisaq nunacunata combidashqa canman. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tseman täcuyaptiqueqa, wayiyoq nunam shamicur niyäshunqui, ‘Sharquï, que presisaq nuna tseman täcamunanpaq’ nir. Tsenam penqacushqa qepaman ewar täcuriyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tsemi combidayäshuptiqueqa, ewar qepallacho täcuyanqui. Tsenam wayiyoq nuna shamicur, queno niyäshunqui: ‘Amigu, eucamï que nopällaman’ nir. Tsenam combidashqa mayiquicuna musyayanqa alli presisaq nuna cayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porqui musyaq tucoqqa, penqacushqam canqa; y qollmi shonquqa, alli presisaqmi canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tsenam combidaqnin fariseutana Jesus queno nerqan: —Qampis, wayiquicho qaracurnenqa, ama presisaq amiguiquicunallataqa, wauqiquicunallataqa, castequicunallataqa o capoqyoq marca mayiquicunallataqa combidanquitsu. Pecunallata combidaptiqueqa, rantintanam qamtapis combidayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sinoqa wayiquicho qaracurnenqa, wactsacunata, imbaliducunata, cojucunata y wiscucunata qayatsinqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tsemi wactsacuna mana cutitsiyäshiniquita puediyaptinpis shonqiquicho cushishqa canqui. Porqui tseno ruranqequipitam Dios cutitsishunqui alli ruraq nunacuna cawariyänan junaqcho. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesus nishqanta wiyarirninnam, laduncho tëcaq nuna queno nerqan: —¡Diospa nopancho micoq caqqa allapa cushiquichochi canqa! ");
INSERT INTO qwhNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tsenam Jesus nerqan: —Juc nunam atsca nunacunata wayinman combidarqan alli miquicunata micuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Micuyänan öra chäriptinnam, sirweqninta cacharqan combidaduncunata qayamunanpaq: ‘Llapanpis listunam; jina öra eucalläyämïna’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Tse combidaducunanam llapanpis disculpata mañacuyarqan. Juc caqmi queno nerqan: ‘Manam puedillätsu shamita. Chacratam tseraq rantirerqö; cananmi ewä ricanäpaq. Perdonecallämë.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jucninnam queno nerqan: ‘Pitsqa par yuntatam tseraq rantirerqö; cananmi ewä mansaq. Tsemi puedillätsu shamita. Perdonecallämë.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Juc caqnam jina nerqan, ‘Tsellaran casacurerqö. Tsemi mana puedillätsu shamita.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sirweqnin cutirirnam, patronninta willarqan combidaduncuna tseno niyanqanta. Patronninnam allapa piñacurnin, sirweqninta nerqan, ‘Jinallacho callicunapa y plasacunapa ewar, wactsacunata, wiscucunata y cojucunata ajalla pushamï’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tsenam sirweqnenqa nishqanno rurarir nerqan, ‘Mandamashqequinomi rurarqö, peru jayëcanran wayi’ ");
INSERT INTO qwhNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tsenam sirweqninta patronnin nerqan, ‘Nänicunapa y estansiacunapa ewar, malaspis nunacunata pushamï wayïcho junta cayänanpaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rasonpam niyaq: Nopata imbitashqa caqcunaqa mananam wayïcho micuyanqanatsu.” ");
INSERT INTO qwhNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesus nänipa eucurëcaptinnam, atscaq nunacuna qatiyarqan. Pecunaman tumecurninnam, queno yachatsicorqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Pipis noqata qatirämeta munarnenqa, noqatam mas cuyamanman papäninta, mamäninta, warminta, tsurincunata, wauqincunata, panincunata y quiquinpa caweninta cuyanqanpeqpis. Mana tseno carqa, manam noqapa disipulütsu cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tsemi noqarecorqa, wanunanpaq crus apaqno jiparninpis, qatirämänan. Mana tseno caqqa, manam disipulütsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tsenollam meqequicunapis jatun wayita sharcatsita munarqa, manaraq qallarnin, tëcur llapan gastuta tantiyayanqui, ‘Mä, ¿qellenï tinconqacush ushatsinäpaq?’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tseno puntata mana tantiyarqa, simientullata rurarirmi, wayita ushatsita puediyanquitsu. Tsenam nunacuna asicurnin penqapäyäshunqui, ");
INSERT INTO qwhNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘¡Que nunaqa wayita qallecur, manam ushatsïta puedintsu!’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Masqui juc rey yarqutsun jucpa contran guerata rurananpaq. Manaraq ewarmi, tëcur tantiyanqa, ‘Noqapa soldadücuna chunca waranqallam (10,000), peru chiquimaqnïpaqa ishque chunca waranqam (20,000), y ¿noqa wallcaqlla soldadücunawan bensishaqtsuraq?’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana puedeqno carqa, jucnin rey carullachoraq quecaptinmi, juc willacoqta cachanqa manana pelyayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tsenollam meqequipis imequicunatapis mana baleqpaqno churarqa, noqapa disipulütsu cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Cacheqa miquicunata mishquitsinanpaqmi alli. Peru cachi qamläcurerqa, ¿imanepanaraq yape mishquinta cutitsinman! ");
INSERT INTO qwhNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tse cacheqa mananam sirwintsu ni allpapaq, ni wanupaqpis; jitarintsicllanam. ¡Tsemi rinriyoq carqa, wiyacur cäsucuyë!” ");
INSERT INTO qwhNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tsenam Jesus quecanqanman ellucayarqan impuestu cobraqcuna y jutsasapa nunacuna, peta wiyeta munarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tseta riquecurninnam, fariseucuna y ley yachatsicoqcuna penqapar queno niyarqan: —¡Que nunaqa jutsasapa nunacunatataq chasquin, y pecunawantaq micun! ");
INSERT INTO qwhNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsenam iwalatsiquipa Jesus willapäcorqan, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Masqui, meqequicunapapis juc pachaq (100) üshequicuna cayäpushï, y jucnin caq oqracäcuritsun, ¿manacu isqon chunca isqon (99) caqta mitsicuyanqequicho jaqirïcur, tse oqracashqa caqta asheqnin ewayanquiman tariyanqequiyaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Taririrninnam, allapa cushishqa catarcur apacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wayiquiman chäratsirnam, amiguiquicunata y besiniquicunata qayarir, queno niyanqui: ‘Llapantsic cushicushun, porqui oqracashqa üshätam tarïcorqö’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tsemi niyaq: Tse cuentanollam juc jutsasapa juclaya ticrariptenqa, sieluchopis masraq cushicuyan tse isqon chunca isqon (99) alli ruraq nunacunapaq cushicuyanqanpitapis. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Masqui, juc warmipa chunca baleq qellenin caputsun, y jucnin caqtana oqrecutsun. ¿Manacu chiuchita sendircur, wayinta pitsecuryan ashinman tarenqanyaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tarïcurnam, yanasancunata y besinuncunata qayarir, queno nenqa: ‘Noqawan cushicuyë; que oqrashqä qellenïtam tarïcorqö.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tse cuentanollam juc jutsasapa jutsancunata jaqiriptenqa, sielucho Diospa anjelnincunapis allapa cushicuyanqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jina quenopis Jesus willapäcorqanmi, “Juc nunapam caporqan ishque tsurincuna. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Qepa caqmi papäninta nerqan: ‘Papä, tocamanqan erensiäta qoycamë.’ Tsenam papänin ishcan tsurinta erensiancuna raquïcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Tse waränincunanam qepa caq tsurin llapan erensiancunata ellurcur, caru marcata eucorqan. Tseman chärirnam, llapan apanqanta pasëpa usharerqan, allapa mana allicunata rurarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tseno ushapucashqa quecaptinnam, tse marcacho allapa mallaqäqui wata carqan. Tsenam tse jobin mallaqewan allapa jiparqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Uryapuquita ashirninnam, chärerqan tse marcacho täraq nunaman. Penam churarerqan cuchincunata mitsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tsechonam allapa mallaqewan cuchipa micunanta miquita munaptinpis, ni tse miquillatapis qarecuyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tsenam cuentata qocurir, queno nerqan, ‘Papänïpa wayinchoqa canan örachi sirweqnincuna atscaq carpis, ¡pacha junta quecayan! ¡Peru noqaqa quecho mallaqewan wanurïna!’ ");
INSERT INTO qwhNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cananmi si, papänïman cutïcur, queno nishaq: ‘Papä, jutsatam rurarqö, Diospa contran y qampa contrequi. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Amana tsuriquitanoqa ricamëtsu; sinoqa juc sirweqniquitanollana chasquicallämë.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tseno yarpärirnam, tse jobin cuticorqan papäninpa wayinman. “Wayinpita carullachoraq quecaptinnam, papänin riquecur allapa ancuparqan. Tsenam coripa ewar, waqurcur mutsecur chasquirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tsurinnam nerqan, ‘Papä, allapa jutsatam rurecorqö, Diospa contran y qampa contrequi. Ama tsuriquitanoqa ricamënatsu’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Peru papänenqa sirweqnincunata quenomi nerqan: ‘Jinallacho alli caq ropan apamur, que tsurïta yacatsiyë; shumaq sortijata yacatsiyë; y mushoq llanqita llanqitsiyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Alli wira caq toruta apamur pishtayë, llapantsic cushishqa micunapaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porqui que tsurïqa wanushqa cuentam cacorqon; peru cananmi cutimur cawarishqa cuentano quecamun. Oqracashqam carqon, peru cananqa yurimorqonmi’ nir. Tsenomi fiestata rurar qallaquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Fiestacho tseno caquicayaptinnam, mayor caq tsurenqa chacracho quecarqan. Wayinman cuticarnam, naqana yequicar, tonadacho tushoqcunata wiyecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsenam juc sirweqninta qayecur, taporqan, ‘¿Imataq pasacun quecho?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sirweqninnam nerqan, ‘Wauqiquim cutimushqa yamella. Tse cushiquitam papäniqui pishtatsishqa alli wira caq toruta’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tseta wiyecurnam, mayor caq tsurenqa allapa piñacurcur, wayiman yequitapis munarqantsu. Tsenam papänin yarqurir, rogarqan wayiman yecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Penam papäninta nerqan, ‘¡Qam musyanquim atsca watana allapa uryarnin, qamta sirwirniqui, mandamashqequicunata ruranqäta! ¡Tseno quecaptïpis, manam ni juc chiwallatapis noqataqa qomashqatsu canqui amigücunawan micuriyänäpaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Peru taqe tsuriqueqa llapanniquitam chipyepa usharerqon, raccha warmicunawan puricurnin. Y cananqa pe cutiramuptin, ¡alli wira caq toruta pishtatserqonqui!’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tsenam papanin nerqan, ‘Iju, qamqa noqawan juntum quecanqui, y llapan imecacunapis qampam. ");
INSERT INTO qwhNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Peru que wauqillequi cutimonqantaqa presisanmi cushicunantsic; porqui wanushqa cuentanomi pëqa cacorqon, y cananqa cutimur cawarimushqa cuentam quecan. Oqracashqam carqon, y cananqa tarerqontsicmi’ nir.” ");
INSERT INTO qwhNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Quenopis jina Jesus willaparqanmi disipuluncunata, “Juc nunam carqan allapa ricu. Tse nunapam juc mayuralnin carqan. Tse mayuralpaqmi patronninta willayarqan llutanpa imecancunatapis ushaconqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsenam mayuralninta qayaratsir queno nerqan: ‘Nunacunam willayämashqa qam llutanta imecacunatapis ruraconqequita. Cananpita witsepanam mayuralnïnatsu canqui. Llapanta cuentata qomänequipaq prebiniquï.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mayuralnam shonqunllacho queno nerqan: ‘Cananqa ¿imataraq rurashaq? Patronnïmi qarqaman mayural quepita. Manam cantsu callpä chacracho uryanäpaq, y llimushnaquitaqa penqacümi. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ajä! ¡Quenomi rurashaq patronnï qarqaramaptin, wayincunaman nunacuna chasquiyämänanpaq!’ ");
INSERT INTO qwhNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tsenam patronninpa jaqan nunacunata jucllellapayan qayarqan. Punta caqtam nerqan: ‘Patronnïpa jaqan, ¿ecataq canqui?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tse nunanam nerqan: ‘Puwaq pachac (800) galon aseitim’ nir. Mayuralnam nerqan: ‘Queman tëcur, que resibucho churamï chuscu pachaq (400) galonllata paganequipaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jucnin caqtanam jina taporqan: ‘Qamqa, ¿ecataq jaqan canqui?’ nir. Tse nunanam nerqan: ‘Pachac chuscu chunca (140) sacu trigum’ nir. Tsenam mayural nerqan: ‘Que resibucho pachaq juc chunca (110) sacullapaq churamï’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tseno suwa mayural allapa musyaq cashqantam patronnin alabarqan. Porqui Diosta chasquishqa nunacunapitaqa, Diosta mana cäsoq nunacunam allapa musyaq cayan, quiquincuna pura negosiuta rurarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Noqam niyaq: Que patsacho ushacäreqlla qelleniquicunawan allita rurar, amishtata ashiyë. Tsemi tse qelleniquicuna ushacäriptinpis, wanucur sieluman chasquishqa cayanqui mana ushacäcoq wayicho cawayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Pipis ichicllacho onradu caqqa, tsenollam onradu canqa mas atscachopis; peru pipis ichicllacho suwacoqqa, tsenollam mas atscachopis suwaconqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sitsun que patsacho ushacäreqlla qelleniquitapis mana allicunata rurar gastanqui, ¿imanoparaq Diospis marcäcushunquiman rasonpa caqnincho? ");
INSERT INTO qwhNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jucpa imecantapis maquiquicho quecaqta ushacäratsiptiqui, ¿piraq qamman marcäcunman imatapis quiquiquipaq qoycushunequipaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Manam pipis ishcaq patrontaqa sirwinmantsu. Tseno carqa, jucnin patronta cuyarninmi, jucnintaqa mana caqpaq churanqa; jucninta sirwirninmi, jucnintaqa mana cäsonqatsu. Tsemi Diosta cuyarqa, ama riquesacunata cuyayanquitsu.” ");
INSERT INTO qwhNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tse llapan nenqanta wiyarninnam, fariseucuna qellepaq allapa erayashqa carnin, Jesusta asipäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tsenam pecunata Jesus nerqan, “Nunacunapa nopancunallachomi qamcuna alli tucoq cayanqui, peru Diosmi shonqiquicunata reqïcan. Nunacuna imatapis allapa baleqpaq que patsacho churayanqantam, Diosqa allapa melanan. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Diospa une profetancuna escribiyashqanqa y Moises escribishqan leyqa, asta bautisacoq Juan willacur qallanqanyaqmi, carqan. Peru cananqa noqanam Diospa mandaquinincho cayänanpaq alli willaquita willapäcü, y atscaqmi pepa mandaquininman imanopapis yequita munayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Tseno quecaptinpis, sieloqa, patsaqa mas alerim ushacärinman, peru tse leycunaqa llapanmi pasepa cumplirenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Meqan nunapis warminpita diborsiacurir jucwan casacorqa, punta caq warminta jalucurmi jutsaman ishquirin; y qowanpita raquicashqa warmiwan pipis casacorqa, jina jutsamanmi ishquirin.” ");
INSERT INTO qwhNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tsepitanam nerqan, “Juc nunam carqan allapa ricu. Pemi ropatapis allapa chaniyoq caqllata yacacoq. Waran waranmi micupäquillacho cacuyaq, imecanpis atsca capuptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tse capoqyoq nunapa puncunchonam juc wactsa nuna Lazaro imepis täcoq. Tse Lazarotam enteru cuerpunta qeri limpu usharishqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pemi mallaqarnin, tse capoqyoq nuna miconqanpita shicwapicunallatapis miquita munaq. Allqucunapis asta qerinta laqwayaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tseno quecarninnam, tse wactsa nuna wanuquicorqan. Almantanam anjelcuna apacuyarqan sielucho une Abrahampa nopanman. Tsenomi jina capoqyoq nunatapis wanuriptin, pampariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Tsenam infiernucho allapa jipecar, riquecorqan Abrahamta carucho quecaqta, y Lazarotapis Abrahampa nopancho quecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsenam qayaripa qayacorqan, ‘Tetä Abraham, ¡ancupëcallämëri! Queman Lazarota cachecallämï, dedunta yacucho tenqircatsir, qallulläta arwäratsimunanpaq. Que ninachomi allapa jipaquicällä’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Peru Abrahamnam yasquerqan, ‘Iju, yarpë qammi caweniquicho quecar, llapanniquiwan cushiquillacho cacorqequi; peru Lazaroqa wactsa carninmi, cawenincho allapa jipacorqan. Tsemi cananqa quecho cushishqa quecan, y qamnam tsecho jipecanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Masqui quetapis nishqequi: Noqacunapita qam quecanqequiman allapa feyu sanjam can. Tsemi quepita tsimpayämita puediyätsu. Ni pipis queman tsimpamita puediyantsu’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tsenam capoqyoq nuna nerqan, ‘Tetä Abraham, tseno captenqa, allapam rogallaq Lazarota papänïpa wayinman cachecullänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tsecho pitsqan wauqïcunata willecamutsun que jipaquiman pecuna mana shayämunanpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamnam yasquerqan: ‘Moisespa y Diospa une profetancuna escribishqancunata pecuna musyayanmi. Tseta cäsucuyätsun’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Capoqyoq nunanam yasquerqan: ‘Tëta Abraham, manam cäsucuyanqatsu; peru juc wanushqa nuna cawarircur, pecunaman cutïcur willacuptenqa, quisa jutsancunata jaqirïcuyanman’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamnam nerqan. ‘Moisespa leynincunata y Diospa une profetancuna escribiyashqancunata mana cäsucurnenqa, wanushqanpita nuna cawarircur willacuptinpis, manam cäsucuyanqatsu’ nir.” ");
INSERT INTO qwhNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tsepitanam disipuluncunata Jesus nerqan, “Nuna mayinta jutsaman ishquitseqcunaqa siemprim cayanqa. Peru ¡allau, tseno pitapis jutsaman ishquitseq nunacuna! ");
INSERT INTO qwhNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas allim canman tse nunapa cuncanman jatun mulinu rumin watarcur lamarman jitarcuyänan, nushpi wamrano qollmi shonqucunata manaraq jutsaman ishquitsiptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tsemi ¡qamcunaqa cuidacuyänequi! “Sitsun nuna mayiqui mana allita rurashunqui, tseno rurashonqequipita piñapequï. Y jutsanta yarparcur ‘Perdonecallämë’ nishuptiqueqa, perdonecunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sitsun juc junaqcho qanchis cuti contrequi mana allita rurecur, qanchis cuti ‘Mananam ruralläshaqnatsu; perdonecallämë’ nishpa shamonqa, jina perdonecunqui.” ");
INSERT INTO qwhNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tsenam apostolnincuna Teyta Jesusta queno mañacuyarqan: —Yanapecalläyämë mas marcäcalläyämunäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Teyta Jesusnam nerqan: —Sitsun marcäquiniquicuna canman mostasa muruno ichicllanllapis, que sicomoro nishqan montita ‘Quepita sipintin yarqur lamarpa chopinman jawicärï’ niyaptiquipis, tse monti cäsuyäshunquimanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Masqui, meqequicunapapis yapyapäcoq o mitsipäcoq sirwishoqniqui cayäpushï, chacrapita cutiramuptin, ¿acasu ‘Pasacaramï. Täcurïquï micurinequipaq’ niyanquicu! ");
INSERT INTO qwhNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sinoqa quenomi niyanqui: ‘Alistaqui miquinïraq arumunequipaq. Micur upur ushanqäyaq sirwimë; tsepeqnam qamqa micucunqui’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tseno mandashqequita rurariptinpis, ¿acasu tse sirwishoqniquita agradesicunquicu! ¡Manam! ");
INSERT INTO qwhNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tse cuentanollam qamcunapis Dios mandayäshonqequicunata rurar usharir niyanquiman, ‘Pishipaq sirwipacoqllam cantsic. Mandamashqantsiccunallatam rurashqa cantsic’ nir.” ");
INSERT INTO qwhNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalen marcaman Jesus disipuluncunawan euquicarnam, Galilea probinsiapa y Samaria probinsiapa linderun nänipa pasarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tsepitanam juc marcaman chäriptin, leprawan qeshyaq chuncaq nunacuna Jesusta taripaq ewayarqan. Peru Jesusman manaraq charninmi, carullacho shäcuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tse nunacunam qayaripa queno niyarqan: —Mayestru Jesus, ¡ancupëcalläyämeri! ");
INSERT INTO qwhNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pecunata riquecurnam, Jesus nerqan: —Saserdoticunaman ewayë cachacashqa cayanqequita ricayäshunequipaq —nir. Ewarëcarnam, pecuna cachacäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tsenam jucnin caqqa, cachacärishqa canqanta mäcurirnin, Jesusman cutiquicorqan qaparipa qayaripa Diosta alabarnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspa nopanman chärirnam, qonquriquicorqan urqunpis patsaman chanqanyaq “Grasiasllä” nicurnin. Pëqa Samaria marca nunam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsenam Jesus nerqan: —¿Manacu chuncanpi cachacäyarqonqui! ¿Waquincunaqa metaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Que caru marca nunallam cutimushqa, Diosta ‘Grasiasllä’ nicurnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tsepitanam nunata Jesus nerqan: —Canan sharcur euquï. Marcäquiniquirecurmi cachacärerqonqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseucunanam Jesusta tapuyarqan ime que patsacho Dios mandacur qallananpaq caqta. Jesusnam yasquerqan: —Dios mandacur qallanqantaqa manam ricayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manam nunacunaraqtsu niyäshunqui, ‘Quechonam’ o ‘Washachonam quecan’ nir. Diospa mandaquinenqa qamcunawannam quecan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Disipuluncunatanam nerqan: —Chämonqam junaqcuna Diospita Shamushqa Nuna cutimunanta ichic ratullapis riqueta munariyänequi; peru manam ricayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nunacunam niyäshunqui: ‘Washachomi quecan’ o ‘Quechomi quecan’ nishpa. Peru ama ricaq ewayanquitsu; ni pecunata qatiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porqui imeca rayu sielucho juc ladupita wac laduman tillapyecoqnomi Diospita Shamushqa Nunaqa que patsaman cutimonqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Peru tseno cananpaqqa puntataran que tiempu nunacuna chiquirnin allapa jipatsiyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Imanomi Noepa tiempuncho nunacuna cawaquicayarqan; tsenomi Diospita Shamushqa Nuna cutimunan junaqcunapis cawaquicayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Arca nishqan barcuman Noe yeconqan junaqyaqmi, nunacuna micupäcur, upyacur, casacur caquicayarqan. Tsemannam apäqui tamya chëcur, llapan nunacunata ushacäratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tsenollam jina une Lot nunapa tiempunchopis carqan. Nunacunam micupäcur, upyapäcur, imatapis rantirnin ranticur, murupäcur y wayincuna rurar caquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Peru Sodoma marcapita Lot yarquriptinnam, tse junaq sielupita asufri y nina runtu tamyamur, llapan nunacunata ushacäratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tsenomi jina pasaconqa Diospita Shamushqa Nuna cutimunan junaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tse junaqcho altuscho quecaqcuna ama wayi ruriman yarpuyanqatsu imancunatapis jorqoq. Ni chacrancunacho quecaqcunapis ama cutiyanqatsu wayincunaman. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yarpäyë Lotpa warminta ima pasanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jina pipis que bidallapaq yarpacachaqqa, cawenintam oqranqa. Peru pipis noqarecur asta wanonqanyaq tsaracoqqa salbaconqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Noqam niyaq: Tse paqasmi juc cämallacho ishcaq punuquicayaptin, jucnin apacushqa canqa, y jucninnam jaqirishqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishcaq warmicunam juntu aqaquicayanqa. Tsepitam jucnin apacushqa canqa, y jucninnam jaqirishqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","˻Chacrachomi ishcaq nunacuna uryecayanqa. Jucnin caqmi apacushqa canqa, y jucninnam jaqirishqa canqa˼” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsenam Jesusta tapuyarqan: —Tëte, ¿mechotaq tsenoqa canqa? Jesusnam yasquerqan: —Mecho imapis wanushqa jitarashqanmanmi wiscurcuna ellucayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tsepitanam Jesus yachatsicorqan iwalatsiquipa pecuna imepis, mana qelanashpa Diosman mañacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Quenomi nerqan: “Juc marcachomi juc jues carqan, Diosta mana cäsucoq, y nuna mayincunatapis mana respetaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jina tse marcachomi juc biuda warmi carqan. Pemi waran waran tse juesman cutiraq queno nishpa: ‘Demandamaqnïtawan justisiallequita rurecamï’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tseno cutilla cutiraptinpis, unenam tse biudata tse jues casorqantsu. Peru tsepitanam shonquncho queno nerqan: ‘Noqaqa manam Diosta cäsütsu, ni nunatapis quecho respetätsu; ");
INSERT INTO qwhNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","peru que biudataqa peqäta nanatsimonqanrecurmi, justisiata rurar atendicushaq, manana shonqüta puwatsir cutirämunanpaq.’ ” ");
INSERT INTO qwhNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tseno willapäcurirnam, Teyta Jesus nerqan: “¿Cäyiyarqonquicu tse mana alli jues nenqanta? ");
INSERT INTO qwhNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tseno quecaptin, ¿manatsuraq Dios justisiata ruranqa acrashqancunapaq, paqaspa junaqpa mañaquicayaptin! ¿Shuyarätsenqatsuraq mañacuyashqanta casicunanpaq? ");
INSERT INTO qwhNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Noqam niyaq: Diosqa mana shuyarätsicushpam, justisianta ruranqa pecunapaq. Peru Diospita Shamushqa Nuna que patsaman cutimur, ¿tarenqaraqtsuraq nunacunapa marcäquinincunata?” ");
INSERT INTO qwhNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jina que iwalatsiquiwanmi Jesus yachatsicorqan, quiquincunacho alli tucoq quecar, peru nuna mayincunataqa despresyaqcunapaq, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcaq nunacunam Diosman mañacoq ewayarqan jatun templuman: Jucmi carqan fariseu; jucninnam carqan Romapaq impuestu cobraq. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tse fariseu caqmi shëcar, shonquncho queno mañacorqan: ‘Dioslla, grasiastam qoq noqa mana waquin nunacunano canqäta. Waquincunaqa suwam, jutsasapam, jucwan jucwan yachacoqmi cayan. Ni manam taqe impuestu cobraqnotsu cä. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Noqaqa cada semanam ishque cuti ayunar micütsu; y llapan gananqätam chuncaman raquirir, juc caqta qoycoq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Peru impuestu cobraq caqnam carullacho shacur, peqantapis sieluman mana pallarerqantsu. Sinoqa allapa llaquicushpam pechuntapis cutar, nerqan: ‘Diosllä, ancupëcallämë. Noqalläqa allapa jutsasapa nunam callä’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tsemi noqa niyaq: Contribusion cobraq nunam wayinman cuticorqan jutsanpita perdonashqana; peru fariseoqa, manam. Porqui pipis alli tucoq caqqa, penqacushqan canqa; y qollmi shonqu caqqa, alli presisaqmi canqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsepitanam nunacuna ñushpi wamrancunata Jesusman apayarqan yatar bendisinanpaq. Peru tseta riquecurnam, disipuluncuna wamra apaqcunata piñapäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsenam wamracunata qayecur, Jesus nerqan: —¡Noqaman wamracuna shayämutsun! Ama michäyëtsu. Que wamracunano caqcunapaqmi Diospa mandaquinenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rasonpam niyaq: Sitsun Diospa mandaquininta que wamracunano mana chasquiyanquitsu, manam pepa mandaquininman yecuyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tsechonam Jesusta juc wiraqtsa queno taporqan: —Alli mayestru, wac bidacho wiñepa cawanäpaq, ¿imatataq rurashaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesusnam yasquerqan: —¿Imanirtaq ‘Alli nuna’ nimanqui? Jucllellam alleqa, y tseqa Diosllam. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dios mandacushqancunata qamqa musyanquim: ‘Majayoq quecar, ama jucwan jucwanqa yachacunquitsu; nuna mayiquita ama wanutsinquitsu; ama suwacunquitsu; ama nuna mayiquipaq ulicurcur mana caqta parlanquitsu; tëtequita, mamequita respetanqui’. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tsenam tse capoqyoq nuna nerqan: —Wamra quenïpitam tsecunataqa llapanta cumplicä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tseno niptinnam, Jesus queno nerqan: —Tseno captenqa, jucran pishin: Canan ewar llapan imequicunatapis rantiquicur, tse qelleta wactsacunata qoyquï. Tseno ruraptiquim, sielucho mana ushacäcoq fortunequi canqa. Tseno rurarïcur, cutimur qatimë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tseta wiyecurnam, tse presisaq nuna pasepa llaquicorqan, allapa ricu carnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesusnam tse nunata llaquishqata riquecur, queno nerqan: —¡Allapa sasam Diospa mandaquininman capoqyoq nunacuna yecuyänan! ");
INSERT INTO qwhNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","¡Porqui mas alerim awjapa uchcunpa juc camellu pasarinman, juc capoqyoq nuna Diospa mandaquininman yecunanpitaqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesus nishqanta wiyecurnam, nunacuna tapuyarqan: —Tseno captenqa, ¿pillanataq salbaconqa! —nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesusnam nerqan: —Nunacuna rureta mana puediyanqantam Diosqa ruran —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsenam Pedru nerqan: —Tëte, noqalläcunaqa llapantam jaqiriyarqö, qamta qatiyänaqpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesusnam pecunata nerqan: —Rasonpam niyaq: Pim jaqirenqa wayinta, warminta, wauqinta, papäninta, mamäninta, tsurincunata Diospa mandaquinincho cananrecur, ");
INSERT INTO qwhNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","que cawenincho jaqiriyanqanpita mas atscatam Dios qoyconqa; y wac bidachoqa wiñepam cawanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tsenam Jesus chunca ishque (12) disipuluncunallata juc laduman qayarir nerqan: —Cananmi Jerusalen marcaman ewantsic. Tsechomi llapan cumplicanqa Diospa profetancuna willacuyashqanno, Diospita Shamushqa Nunawan. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Diosman mana marcäcoq nunacunapa maquinmanmi marca mayincuna entregayanqa. Pecunanam toqapur tuquïta asharnin, burlacuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Allapa maqarninnam, wanutsiyanqa; peru quima junaqllatam cawarimonqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tseno niptinpis, disipuluncunaqa manam ni imata cäyiyarqantsu; ni musyayarqantsu imapaq Jesus parlashqanta “¿Imataraq queno parlar nimantsic?” nishpam, niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jerico marcaman Jesus disipuluncunawan yecurëcayaptinnam, näni cuchuncho juc wiscu llimushnata mañacur tëcarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Atsca nunacuna pasaqta mäcurirnam, tse wiscoqa tapucorqan: —¿Imataq pasacun? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nunacunanam willayarqan: —Jesus Nazaret marca nunam que nänipa sharëcamun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tsenam wiscoqa fuertipa qayaquicorqan queno nishpa: —¡Davidpa castan Jesus, ancupëcallämëri! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tsenam puntancunata ewaq nunacuna upällatsita munar wiscuta piñapäyarqan, peru wiscoqa masran queno nir, qayaricachäcorqan: —¡Davidpa castan Jesus, ancupëcallämëri! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesusnam tseta wiyecur, shäcurir, “Taqe nunata pushayämï” nerqan. Pushariyaptinnam, Jesus taporqan queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imata ruranätataq qampaq munanqui? —nir. Wiscunam nerqan: —¡Ricachaquitam munallä, Teyta! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesusnam nerqan: —Canan riquë. Noqaman marcäcamurmi, cachacärerqonqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tse öram wiscu ricachacurerqan, y Jesuspa qepanta eucorqan, Diosta alabarnin. Nunacunapis tseta riquecurninmi, Diosta alabayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jerico marcaman Jesus disipuluncunawan chärirnam, tse marcapa pasacurëcayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tse marcachomi Zaqueo jutiyoq nuna yacharqan. Pemi carqan capoqyoq y impuestu cobracoqcunapa mandacoqnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tse nunam Jesusta reqita munarqan. Peru ichicllanlla carninmi, riqueta puederqantsu, atscaq nunacuna tsapayaptin. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsenam corillapa puntärir, sicomoro nishqan montiman lloqacurcorqan Jesus pasaqta ricananpaq; porqui tsepam pasanan carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tse monti caqman Jesus chärirnam, ñuquircur nerqan: —Zaqueo, jinallacho yarpamï. Cananmi wayiquicho posadacushaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueonam jinallacho montipita yarparamur, allapa cushishqa wayinman Jesusta pusharqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tseta riquecurnam, nunacuna Jesusta penqapar, queno niyarqan: —¡Jutsasapa nunapa wayinmantaq posadacoq ewan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueonam sharcurir, Jesusta nerqan: —Tëte, llapan capamaqnïpa pullannintam wactsacunata qoycushaq. Y pitapis ulicurcur masta cobranqäpitam, chuscu cuti masta cutïcatsishaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesusnam queno nishpa yasquerqan: —Cananmi que wayicho yachaqcunaman salbasion chämushqa, pepis awilituntsic Abrahampa rasonpa castanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Porqui Diospita Shamushqa Nunam que patsaman chämushqa oqracashqacunata ashinanpaq y salbananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesus tseno parlanqanta wiyarirninnam, nunacuna shonquncunacho pensayarqan, “Canantächi Diospa mandaquinin qallanqa noqantsiccho” nishpa. Porqui Jerusalenmannam yecurëcayarqan. Tseta musyarirnam, iwalatsiquïpa Jesus yachatsicorqan ");
INSERT INTO qwhNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","queno nirnin: “Juc nunam carqan, allapa reqishqa nunapa tsurin. Tse nunam caru marcata eucorqan queno nirnin: ‘Juc marcatam eucü, y tse marcacho rey churarayämaptinmi, queman cutiramushaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tseno eucunanpaqnam chunca sirweqnincunata qayecatsir, qellenincuna qorqan: ‘Cutimonqäyaq que qellewan negosiarëcayë’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Peru tse marca nunacunanam chiquirnin, qepanta willacoq nunacunata cachayarqan queno niyänanpaq: ‘Manam munayätsu que nuna reynïcuna cananta’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Peru imano captinpis, petaqa rey cananpaqmi churariyarqan. Tsepita tse marcaman cutïcurnam, qelle chasqueq sirweqnincunata qayatsir, jucllellapayan cuentata mañarqan, ‘¿Ecatataq ganayarqonqui?’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tsenam punta caq chärir nerqan: ‘Tëte, qelleniquiwan chunca cuti mastam ganashqa cä.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tseno niptinnam, patronnin nerqan, ‘Allichomi. Qam alli sirwimaqnïmi canqui. Wallcallachopis onradu nuna canqequirecurmi, canan churaq chunca marcacho nunacunapa mandacoqnin canequipaq.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tsepeqnam jucnin caq sirweqnin chärir nerqan, ‘Wiraqtsa, qelleniqui pitsqa cuti mastam wachashqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Patronninnam petapis nerqan, ‘Qamtam churaq pitsqa marcacho nunacunapa mandacoqnin canequipaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Jucninnam chärir nerqan, ‘Tëte, quemi qelleniqui. Pañuwan piturcurmi, paquecorqö. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Porqui qamqa allapa acsemi canqui. Mana churashqequipitam y mana murushqequipitam ellunqui. Tsemi noqa mantsarqoq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Patronninnam nerqan: ‘¡Qamqa mana imapaqpis sirweqmi canqui! Quiquiqui parlashqequim condenashunqui. Nenqequinollam noqa acse cä, mana churashqäpita mana murushqäpita elloq. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tsepenqa ¿imanirtaq bancuman qellenïta churecorqequitsu, cutimur wachenintawan chasquinäpaq?’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tseno nirirninnam, tsecho quecaq nunacunata nerqan, ‘Tse qelleta qochirïcur, qoycuyë chunca cuti mas qellenï miratseq caqta’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pecunanam niyarqan, ‘Peru Tëte, pepaqa chuncanam capun qellenin’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Patronnam nerqan, ‘Niyaqmi: Nenqäno ruraq caqcunaqa mastam chasquiyanqa; peru mandanqäta mana ruraq caqcunataqa, ichiclla cayäponqantapis qochiyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chiquimaqnïcunam munayarqantsu mandacoqnincuna canäta. Canan pecunata apamur nopächo wanutsiyë’ nir.” ");
INSERT INTO qwhNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tseno yachatsïcurirnam, Jesus disipuluncunawan Jerusalen marcaman llapancunapa puntanta ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfage y Betania marcapa ewecarnam, Olibus jircapa chaquinman chäriyarqan. Tsepitanam ishcaq disipuluncunata cacharqan, ");
INSERT INTO qwhNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","queno nirnin: —Ewayë taqe ricaquecamoq marcaman. Chärirnam, tariyanqui manaraq pipis montashqan maltun ashnu watarëcaqta. Tse ashnuta pascarir apayämunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sitsun pipis niyäshunqui ‘¿Imapaqtaq ashnuta pascayanqui?’ nir, ‘Teytam nesitan’ niyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pecunanam ewar Jesus nishqannolla tariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ashnuta pascarëcayaptinnam, ashnuyoqcuna niyarqan: —¿Imapaqtaq ashnüta pascayanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pecunanam “Teytam nesitan” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tsenam ashnuta aparcur Jesus caqman cuticuyarqan. Chäratsirnam, aqshunancunata carunarcur Jesusta montatsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tseno ewaptinnam, atscaq nunacuna aqshunancunata qoturicur näniman mashtayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olibus jircapa urämur qallecurnam, llapan qatiraqnincunaqa Jesus llapan milagrucuna rurashqanta ricashqa carnin, allapa cushishqa qaparipa Diosta, queno nishpa alabayarqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Alabashqa catsun Teyta Dios cachamushqan reynintsic! ¡Cananqa Dioswan shumaq cawaquichonam cashun! ¡Sieluchopis alabashqa catsun! ");
INSERT INTO qwhNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsenam nunacunapa chopincho ewaq fariseucuna Jesusta niyarqan: —Mayestru, qatishoqniquicunata piñapë upälla cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesusnam nerqan: —Niyaqmi: Sitsun pecuna upällacuriyanqa, asta rumicunapis qapariyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalenman yecurëcarnam, tse marcata Jesus ricarir, ancuparnin waqarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Quenomi nerqan: —Jerusalencho täraqcuna, ¡imanomi munä canan junaqllapis Dioswan alli pasaqui canqanta cäyicuyänequita, peru tsetaqa manam cäyiyanquitsu! ");
INSERT INTO qwhNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Porqui chämonqam mana alli tiempucuna qamcunapaq. Tse junaqcunam chiquiyäshoqniquicuna shamicur, alli altu perqequicuna qepanpa allpawan pampatsärirnin, jinantin ladupa yecayämonqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Marquequicunatam pasepa ushacätsiyanqa, y tse perqequicuna rurincho yachaqcunatapis tsenollam ushacätsiyanqa. Manam ni juc rumillapis perqarëcarqa quedanqatsu. Tsenomi canqa, Diosniquicuna chämoqta mana chasquiyanqequirecur. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalenman Jesus chëcurnam, templuman yequicur, patiucho qatucoqcunata qarqacacharcamorqan, ");
INSERT INTO qwhNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","queno nishpa: —Escribishqam quecan ‘Wayïqa Diosman mañacunallapaqmi.’ Qamcunanam ticratsiyarqonqui suwacunapa machenintano. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tsepitanam waran waran Jesus yachatsicorqan tse templucho. Saserdoticunapa mandacoqnincunanam, ley yachatsicoqcunanam y puedeq nunacunanam munayarqan imanopapis Jesusta wanicatsita. ");
INSERT INTO qwhNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Peru Jesus yachatsicushqanta llapan nunacuna cushishqa wiyacuyaptinmi, ni imanopapis wanutsita puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Juc junaqmi Jerusalen templucho Jesus yachatsicur, shumaq alli willaquita willapäquicarqan. Tsemannam saserdoticunapa mandacoqnincuna, ley yachatsicoqcuna, autoridacunawan chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pecunam Jesusta niyarqan: —¿Ima puedeq queniquiwantaq quecunata rurarqonqui! ¿Pitaq cachamushorqonqui tseno ruranequipaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesusnam nerqan: —Noqapis qamcunata jucta tapuyashqequi. Mä, niyämë: ");
INSERT INTO qwhNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitaq cachamorqan bautisacoq Juanta nunacunata bautisananpaq, Dioscu o nunacunallacu? ");
INSERT INTO qwhNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tseno tapicuptinnam, quiquincuna pura queno ninacuyarqan: —¿Imataq nishun? ‘Diosmi cachamushqa’ nishqaqa, tsepenqa ‘¿Imanirtaq peman creyiyarqequitsu!’ nimäshunmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sitsun nishun ‘Nunacunam’ nir, tseqa nunacunanam tsampir wanutsimäshun, porqui Juanpaqqa profeta canqantam creyiyarqan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsenam Jesusta queno niyarqan: —Manam musyayätsu bautisananpaq ni pi cachamushqantapis —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tseno niyaptinnam, Jesuspis nerqan: —Tsepenqa noqapis manam willayaqtsu quecunata ruranäpaq pi mandamanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsepitanam nunacunata que iwalatsiquiwan Jesus yachatsicorqan, queno nishpa: “Juc nunam chacrancho ubasta plantarqan. Tsepitanam tse chacranta pullan pura muruyänanpaq nunacunata qoquicur, caru marcapa eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tsepitanam cosecha tiempu chäriptinna, chacrayoqqa juc sirweqninta cacharqan, pullan pura muroqnincunaman pepa partinta raquiyänanpaq. Peru chacran tsaraqcunanam maqacacharcur, jinallata qarquriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsenam jucnin sirweqnintana chacrayoq cacharqan. Jina petapis maqar allapa maltratarninmi, jinallata qarquriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tsepitanam chacrayoq juctana cacharqan. Jina petanäqa maqacacharcurmi, yawarllatana qarquriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tsenam chacrayoq nerqan, ‘Cananqa ¿imatataq rurashaq? Mejorqa allapa cuyë tsurïtachi cachashaq. Petaqa respetayanqam’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Peru peta ricarirnam, pullan pura chacra tsaraq nunacuna quiquincuna pura queno yachatsinacuriyarqan: ‘Queqa chacrayoqpa tsurinmi y erederum canqa; mejor wanicatsishun chacranwan quedacunantsicpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsenomi chacranpita jaqman jorqurir wanuratsiyarqan. “Cananqa ¿imatataq chacrayoq pecunata ruranqa? ");
INSERT INTO qwhNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ewarmi, chacran tsaraqcunata wanicatsir, juccunatana chacranta qoyconqa” nir. Tseta wiyecurnam, niyarqan: —¡Ama tsenoqa quecullanmantsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Peru Jesusnam pecunata alli ricarëcur nerqan: —Tseno cananpaqmi Diospa palabran noqapaq queno escribirëcan: ‘Wayi perqaqcuna: “Que rumeqa manam allitsu” nir, jitariyanqanmi, cananqa mayestra rumi ticrarishqa.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipis tse rumiman ishqueq caqqa, allpa mancanomi ushacärenqa. Jina tse rumi pimanpis jeqarqa, allpamanmi ticraratsenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tsenam ley yachatsicoqcuna y saserdoticunapa mandacoqnincuna pecunapa contrancuna que iwalatsiquiwan Jesus parlashqanta cäyicurcurnin, presu tsarïta munayarqan. Peru tsariyarqantsu, nunacunata mantsarmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tse mandacoqcunanam achäquita ashir, Jesusman musyapacoqcunata cachayarqan, alli tucushllapa ewarnin, tapur Jesusta mana allita parlatsiyänanpaq; y llutanta parlecuptenqa, acusarnin gobernadorman entreguecuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tsenam tse musyapacoqcuna tapuyarqan, queno nishpa: —Mayestru, musyayämi rasonpa caqllata parlar yachatsicunqequita; manam ni meqan nunapa gustunta ruranquitsu. Y rason caqllatam Dios munashqanno cawayänäpaq yachatsiyämanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Allicu Roma mandacoq cesarpaq impuestuta pagashwan o manacu? ");
INSERT INTO qwhNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesusnam yachellapa mana allita parlatsiyänanpaq tapupäyanqanta cuentata qocurir queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Mä, tse qelleta ricatsiyämë. Que qellecho ¿pipa retratuntaq quecan? ¿Pipa jutintaq escribirëcan? Pecunanam niyarqan: —Mandacoq cesarpam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tsenam Jesus nerqan: —Tsepenqa mandacoq cesarpa caqtaqa mandacoq cesarta qoycuyë; y Diospa caqtaqa Diosta qoycuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nunacunapa janancho Jesus tseno nïcuptinnam, tse musyachacuna ni imano pantatsïtapis puediyarqantsu, sinoqa mantsacashqam upällana quedariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsepitanam saduseu nishqan grupupita Jesusman tapucoq ewayarqan. Pecunaqa manam creyiyarqantsu wanushqacuna cawariyämunan cashqanta. Tsemi queno tapuyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Mayestru, Moises escribishqan leychomi queno willacun: ‘Sitsun juc casadu nuna manaraq tsurin captin wanuconqa, tse biudanwan jucnin wauqin casacutsun. Tsenopam wamrancuna captin tse wanucushqa wauqinpa tsurin cuenta canqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Masqui wiyarämë: Cayänaq qanchis wauqicunash. Mayor caqshi casacunaq, y manaraq tsurin captinshi pe wanuquicunaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tseshi qepan caq wauqinna biudawan casacunaq. Pepis jina tsurin manaraq captinshi, wanuquicunaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tsepitanash jucnin caqna jina biudawan casacunaq. Tsenoshi qanchisninpi casacur casacur, manaraq tsurincuna captin, llapanpis wanucuyänaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsepitanash warmipis wanuquicunaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mä, canan niyämë: Cawarimi junaqcho que warmi ¿meqan caqpataq lejitimu warmin canqa, qanchis wauqiwan casacushqa quecaptin! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesusnam nerqan: —Ollqupis warmipis que patsallachomi casacuyan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Peru wac bidaman chäyänanpaq acrashqa caqcunaqa cawarimur mananam casacuyanqanatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porqui tsechoqa anjelcunano carninmi, manana wanuyanqapistsu. Diospa wamrancunanam cayanqa, pe cawaritsishqa captin. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tsenomi Moisespis yachatsimantsic wanuyashqanpita nunacuna cawariyämunanta. Petam shira casha rupecaqcho yuripur, Dios queno nerqan: ‘Noqaqa Abrahampa, Isaacpa y Jacobpa Diosninmi cä’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tsemi Diosqa wanushqacunapa Diosnintsu; sinoqa cawecaqcunapam, porqui pepaqqa llapanpis cawecayanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tseno niptinnam, ley yachatsicoq waquin nunacuna queno niyarqan: —Mayestru, ¡allapa allitam niyämarqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y mananam ni meqanpis tapupeta almitiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tsepitanam nunacunatana queno nirnin, Jesus taporqan: —¿Imanirtan niyanqui, ‘Dios Acrashqanqa une rey Davidpa castanmi’ nishpa? ");
INSERT INTO qwhNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porqui quiquin Davidpis Salmu libruncho quenomi escribishqa: ‘Diosmi nerqan Teyta Diosnïta: Que derechu ladüman täcamï ");
INSERT INTO qwhNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","llapan chiquiyäshoqniquicunata muneniquiman churamonqäyaq’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidpis ‘Teyta Diosnïmi’ nicaptenqa, ¿Imanopataq Cristoqa Davidpa mireninpitaraq canman! ");
INSERT INTO qwhNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Llapan nunacuna wiyarëcayaptinnam, disipuluncunata Jesus queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cuidacuyë ley yachatsicoqcunapita, porqui pecunaqa chaqui puntanyaq shumaq ropancunata yacacurcurmi, callicunacho puriyan, nunacuna respetar saludayänanta munarnin. Ellucayänan wayichopis mas presisaqcuna täcuyänanmanmi täquita munayan. Micupäquiman qayatsiyaptinpis, punta puntaman täquitam gustayan. ");
INSERT INTO qwhNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Biudacunapatanäqa wayincunacho imancunapis caqtam qochipäyan. Nunacuna alli cayanqanta pensayänanpaqnam, alli tucushpa unepa Diosman mañacuyan. Tseno rurayanqanpitam waquincunapitapis allapa feyupa Dios castiganqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tse templuchonam Jesus ricarerqan qelle winana cajaman Diospaq qelleta capoqyoq nunacuna winayaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsechomi jina ricarerqan wactsa biudatapis ishquella sentabunta winareqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tseta ricarninnam, Jesus nerqan: —Rasontam niyaq: Llapancunapitapis taqe wactsa biudam masta winarcushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Waquincunaqa winayan sobrapucuyanqanllatam; peru taqe warmeqa wactsa quecarpis cawarcunanpaq tsella quecaponqantam llapanta qoycushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Disipuluncunanam parlecayarqan tse templu shumaq rumicunawan rurashqa canqanta, y Diospa qarenincunawan alajashqa canqanta. Tsenam Jesus nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Que riquecayanqequi ime junaq carpis pasepam ushacanqa, y manam ni juc rumillapis perqarëcarqa quedanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsenam disipuluncuna tapuyarqan: —Tëte, ¿imetaq nenqequinoqa canqa? ¿Ima señaltataq ricayäshaq que llapan nenqequi cumplicänanpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesusnam nerqan: —¡Paqtaraq pipis engañayäshunquiman! Atscaq nunacunam ‘¡Noqam Dios Acrashqan cä!’ y ‘¡Dispunishqa tiempu chämonqanam!’ nir, atscaq nunacunata engañar puriyanqa. Ama pecunata creyir, qatiräyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sitsun wiyayanqui juc marcacho quiquincuna pura maqanacoqpaq y gueracunapaq, ama mantsacäyanquitsu. Tsenomi susedicunan presisan. Tsecunaqa qallananllaran; manaran que patsa ushacanqaraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tsepitanam nerqan: —Juc nasionmi juc nasionwan guerata rurayanqa. Y juc marca nunacunam juc marca nunacunawan wanutsinacuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mecho tsechopis allapa feyupam temblorwan patsa cuyonqa; mallaqemi canqa; y pesti qeshyawanmi wanuyanqa. Sieluchopis espantepaq señalcunata ricarninmi, nunacuna allapa mantsacäyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Peru manaraq quecuna pasacuptinmi, qatïcachäyäshurniqui tsariyäshunqui. Ellucayänan wayicunamanmi apayäshunqui jusgayäshunequipaq. Tsepitanam pasatsiyäshunqui carselman. Puedeq reycunapa y autoridacunapa nopancunamanmi noqarecur apayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tsecunaqa pasayäshunqui noqapaq willacuyänequipaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tsemi shonqiquicunacho ama yarpacachäyëtsu imano defendicuyänequipaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porqui noqam alli yacheniquicuna qoyashqequi parlayänequi öra. Y chiquiyäshoqniquicunapis manam ni ima masta niyäshiniquita puediyanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Autoridacunamanmi quiquiquicunapa tëtequicuna, mamequicuna, wauqiquicuna, castequicuna, amiguiquicuna apayäshunqui; y waquinniquicunatanam wanutsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Noqarecurmi llapan nunacuna chiquiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Peru canqanllam quecayanqui, manam juc aqtsequicunallapis oqracanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tsemi alli firmi tsaracuyänequi almequicuna salbacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Imemi Jerusalen marcata soldaducuna rodearishqa täparaqta ricariyanqui, tsemi musyariyanqui Jerusalenpa ushaquenin junaq chämushqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tseta riquecorqa, Judea marcacunacho täraqcuna qeshpir, ewacuyätsun jircacunapa. Quiquin Jerusalencho yachaqcunapis tsepeq safacuyätsun, y chacracunapa yarqushqa caqcunaqa ama cutiyätsuntsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porqui Diospa palabran escribirëcanqan cumplicänanpaqmi, tse junaqcuna allapa castigu canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Allau, tse junaqcunacho qeshyaq tucushqa warmicuna y llulluta chichicaqcuna! Porqui allapa jipaquimi tse marcacho canqa, y allapa feyupam castigu canqa tse pueblupaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquincunatam wanutsiyanqa sabliwan; waquincunatanam presu apayanqa jinantin nasioncunaman. Diosman mana marcäcoq caru nunacunam Jerusalenta jalucuyanqa, asta Dios dispunishqan tiempucamayaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Señalcunam ricaconqa inticho, quillacho, qoyllurcunachopis. Lamar allapa feyupa qayarir cuyuptinmi, jinantin patsacho nunacuna mantsaquewan ni imano quetapis puediyanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tsenam nunacuna mantsaquewan desmayariyanqa que patsa ushacänanta pensarnin; porqui llapan sielucho quecaqcunam cuyucurenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tse öram llapan nunacuna ricayanqa Diospita Shamushqa Nunata pucutecho intino chipapäquicar, llapan puedeq queninwan shamicaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Que llapan niyashqaqcuna cumplicaptin, qamcuna balorta tsarir, cushishqa cayë; porqui librayänaqpaq ichicllanam pishenqa.” ");
INSERT INTO qwhNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tsenam Jesus monticunatawan iwalatsicur yachatsicorqan, queno nishpa: “Igus montipita o waquin monticunapita yachacuyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Qamcunam monticunapa rapran tseqllimoqta ricarnin, musyayanqui achache tiempu chämonqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tsenollam canan willayanqaqcuna susedicuptin, musyayanqui Diospa mandaquinin chämunanpaq ichicllana pishicanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Rasontam niyaq: Canan tiempu nunacuna manaraq wanuyaptinmi, llapan willaconqäcuna susediconqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sielupis patsapis ushacäriyanqam, peru niyashqaq palabräqa manam ushacanqatsu; cumplicanqam. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Cuidacuyë shonqiquicuna munanqan mana alli bisiucunapita, machaquicunapita, y que bidacho imecapaqpis yarpacachecunapita. Tseno quecayaptiqui, paqtataq tse junaqcuna ");
INSERT INTO qwhNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","imeca trampa animalta tsareqno tsapuyäshunquiman. Porqui tsenollam jinantin marcacho nunacunatapis tarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Peru qamcunaqa shuyaquïcäyë imepis Diosman mañacurnin, tse tiempucunacho alli tsaracuyänequipaq. Tsemi Diospita Shamushqa Nunapa nopanchopis mana mantsacushpana shëcäyanqui.” ");
INSERT INTO qwhNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tsenomi templucho junaqpa Jesus yachatsicoq, y paqaspanam Olibus nishqan jircaman eucoq tsecho warärinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y qoya qoyallanam jinantinpita templuman nunacuna ewayaq, Jesus yachatsicushqanta wiyacoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lebadurannaq tantata micuyänan Pascua fiestapaq ichicllanam pishicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Saserdoticunapa mandacoqnincunawan, ley yachatsicoqcunanam, “¿imanotaq Jesusta wanicatsintsic?” ninacuyarqan, porqui mantsayarqanmi nunacuna piñacurcuyänanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsenam Judas Iscariotipa shonqunman diablu yëcurerqan. Judasqa Jesuspa chunca ishque (12) caq disipuluncunapitam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pemi saserdoticunapa mandacoqnincunaman y templucho wardiacunapa mayornincunaman ewar, pecunawan parlarqan Jesusta imano entreguecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pecunanam allapa cushicur Judasta qellenin qoyänanpaq äniriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsenam Judaspis änirerqan, y asherqan mana nunacuna cayanqan öra Jesusta entreguecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lebadurannaq tantata micuyänan Pascua fiesta junaq chäriptinnam, costumbrincunamanno wata wata israel nunacuna üshacunata pishtayaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tsenam Pedruta y Juanta Jesus cacharqan, queno nishpa: —Qamcuna, ewayë Pascua miquita micunantsicpaq alistapäcoq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pecunanam tapuyarqan: —¿Mechotan alistayämushaq micunantsicpaq? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesusnam nerqan: —Jerusalenman chärirmi, juc nunata cuntuwan, yacuta apecaqta tariyanqui. Tse nunata qatiyanqui asta wayiman yeconqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tse wayiyoqta queno niyanqui: ‘Mayestrücunam queno nin: ¿Meqan cuartuchotaqshi Pascua miquita miconqa disipuluncunawan?’ ");
INSERT INTO qwhNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wayiyoqnam ricatsiyäshunqui rara altuscho jatun cuartu alistashqata. Tsecho micunantsicpaq alistayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pecunanam ewar Jesus nenqannolla tarirnin, alistayarqan Pascua miquita micuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Miqui öranam apostolnincunawan Jesus micuyänanpaq täcuriyarqan mesaman. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tsechonam Jesus nerqan: —Imanomi munarqö manaraq jiparnin que Pascua fiesta miquita qamcunawan micurinantsicta. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Niyaqmi: Mananam que miquita micushaqnatsu asta qamcunawan Diospa mandaquinincho micunäcama. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tseno nirninnam, copata tsarircur, Diosta, “Grasias” nicurir, disipuluncunata queno nerqan: —Queta llapequicuna uputsinacuyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porqui niyaqmi: Binuta mananam yapeqa upushaqnatsu asta Diospa mandaquinincho llapantsic canqantsicyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsepitanam tantata Jesus tsarircur Diosta “Grasias” nicurir tantata paquirir, disipuluncunata qorqan, queno nishpa: —Queqa noqapa cuerpümi. Qamcunapaqrecurmi entregashqa canqa. Tsemi queno imepis rurayanqui, noqata yarpäyämarnï. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tsenollam jina senacuriyaptin, binuwan quecaq copata tsarircur, queno nerqan: —Que copacho quecaq binoqa yawarnïmi; y tse yawarnïwanmi Dios mushoq contratuta patsacäratsin nunacunawan. Tsemi qamcunapaqrecur ramashqa canqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tseno quecaptinpis, que mesachomi quecan traisionamaqnï nuna. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Diospita Shamushqa Nunaqa wanonqa Dios dispunishqannomi; peru ¡allau, tse entregamaqnï nuna! ");
INSERT INTO qwhNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Disipuluncunanam quiquincuna pura tapunacuyarqan queno: —¿Meqantsicraq tse traisioneru cantsic? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsechonam disipuluncuna piñatsinacuyarqan: —¿Meqantsictaq noqantsiccho mandacoq canqa? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tsenam Jesus nerqan: “Diosman mana marcäcoq reqishqa mandacoqcunaqa nunacunatam allqutsayan; y quiquincunachoqa ‘Alli mandacoqmi cä’ niyanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Qamcunaqa manam pecunanotsu cayänequi. Antis meqequipis mayor mandacoq queta munarnenqa, qollmi shonqum cayänequi. Y mandacorqa, sirwicoqnomi cayänequi. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tsepenqa ¿meqantaq mas mayor mandacoq canman? ¿Mesacho tëcaq caqcu o miquinin sirweq caqcu? Qamcuna pensayanqequinomi tse sirwicoq nunapitaqa mesacho täraq caq mas mayor. Tseno quecaptinpis, noqaqa qamcunacho imeca sirwicoqnomi quecamü. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Qamcuna noqawanmi ima nacaquinïcunachopis cayarqonqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tsemi Papänï noqata mandacunäpaq churamanqannolla, qamcunatapis mandacuyänequipaq churayashqequi. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tsenam noqapa mandaquinïcho qamcuna micuyanqui upuyanqui mesächo. Tsechonam noqapa nopächo alli täcunacunaman tëcur, chunca ishque (12) israel casta nunacunata jusgayanqui.” ");
INSERT INTO qwhNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tseno nirirnam, nerqan: —Simon, Simon, diablum Diosta mañacushqa, qamcunapa marcäquiniquicunata imeca trigu wauyaqno probananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Peru qampaqmi Diosman mañacorqö mana qelanashpa noqaman marcäcamunequipaq. Tsenam noqaman yape marcäcamurnin, disipulu mayiquicunata yanapëcunqui noqaman marcäcur tsaracuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tsenam Pedru nerqan: —Tëte Jesus, presuyämaptinpis, wanutsiyämaptinpis, noqaqa qamwanmi ewashaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesusnam nerqan: —Pedru, willaqmi: Canantämi manaraq gallu cantaptin, reqimanqequita quima cuti negamanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsepitanam disipuluncunata Jesus taporqan: —Puntata qellennaqta, mircapannaqta, llanqinnaqta cachayanqaqcho, ¿imequicunataq pisherqan? —nir. Pecunanam niyarqan: —Manam imacunapis pisherqantsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesusnam nerqan: —Cananqa qelleniquicuna y alporjequicuna captenqa, apayë. Espadequicuna mana captenqa, ponchiquicunata rantiquicurpis, rantiyë. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Niyaqmi: Presisanmi Diospa palabran noqapaq escribirëcanqan cumplicanan, ‘Jutsasapatanomi ricayanqa.’ Tsemi noqapaq escribirëcaqcunaqa llapanpis cumpliquecan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tsenam disipuluncuna niyarqan: —Teyta Jesus, quecho ishque espadallam cayäpaman —nir. Jesusnam nerqan: —¡Tsellana! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsepita yarqurirnam, Jesus costumbrinmanno eucorqan Olibus nishqan jircaman. Disipuluncunanam qatiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tseman chärirnam, nerqan: —Qamcuna Diosman mañacuyë diablu tenteta munayäshuptiqui, jutsaman mana ishquiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tseno nirirnam, ichic mas washanincunaman ewecur, qonquriquicur, Diosman japallan mañacorqan queno nirnin: ");
INSERT INTO qwhNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Papällä, qam munarnenqa, que jipar nacanäpaq quecaqcunapita salbecamë; peru noqa munashqänoqa ama callätsuntsu, sinoqa qam munashqequino quecullätsun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsenam sielupita juc anjel yurircur, Jesusta baloratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsenam shonquncho tselayapa nanatsicurnin, masraq mañacorqan asta yawarnoraq sudorninpis patsaman shutonqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mañacurirnam cutirerqan disipuluncuna caqman, y tarirerqan punuquicayaqtam. Llaquishqa y utishqa cayaptinmi, puni limpu bensiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsenam Jesus nerqan: —¿Imanirtaq punucuyanqui? Riyacur Diosman mañacuyë diablu tenteta munayäshuptiqui, jutsaman mana ishquiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus manaraq parlar ushaptinmi, tseman disipulun Judas chärerqan atscaq nunacunata pusharishqa. Jesusman witicurnam, qaqllancho mutsecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesusnam nerqan: —Judas, ¿mutsequiwancu Diospita Shamushqa Nunata traisionarinqui? ");
INSERT INTO qwhNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tsecuna pasacoqta ricarninnam, disipuluncuna queno niyarqan: —Teyta Jesus, ¿que espadawan wallucacharcayämümancu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsenam jucnin caq disipulun mas mandacoq saserdotipa sirweqninpa derechu caq rinrinta wallicorqan pintireqpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesusnam nerqan: —¡Tsellana! ¡Ama imanayëtsu! Tsepitanam nunapa rinrinta cutircatsir, cachacäratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tsenam saserdoticunapa mandacoqnincunata, templucho wardiacunapa mayornincunata, y waquin autoridacuna Jesusta presu apayänanpaq ewashqacunata Jesus queno nerqan: —¿Imanirtaq suwa captïno espadequicunawan garutiquicunawan shayämorqonqui? ");
INSERT INTO qwhNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Noqaqa waran waranmi templucho qamcunawan quecarqä. Tsechoqa ¿imanirtaq tsariyämarqequitsu? Cananmi si, öra chäramushqa diablupa muneninta rurar, tsariyämänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsenam Jesusta presu tsarïcur, apayarqan mayor caq saserdotipa wayinman. Pedrunam carullapa qaterqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tse wayipa patiu chopinchonam quecayarqan nunacuna ninata sendircur qoñucurnin. Tsenam Pedrupis pecunaman witerqan tsecho qoñücoq. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ninapa actsinwannam saserdotipa sirweqnin warmi Pedruta riquecorqan. Tsenam alli ricapëcur nerqan: —Que nunapis taqe nunawanmi purishqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peru Pedrunam negarnin nerqan: —Warmi, manam peta reqicütsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tsepitanam jucna Pedruta ricarirnin nerqan: —Qampis taqe nunawanmi purishqanqui —nishpa. Pedrunam nerqan: —Manam, tëte. Manam pewan purishqätsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Juc öratanonam jina juc nunana nerqan: —Rasonpam que nunaqa qatirashqa. ¡Ari, pepis Galilea nunataq! ");
INSERT INTO qwhNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tsenam Pedru nerqan: —Qamqa, ¿imatachi parlanquipis? ¡Manam cäyïpistsu! Tseno manaraq parlar ushaptinmi, gallu cantarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tsenam Pedruman Jesus tumecur, ricarerqan. Pedrunam yarparcurcorqan Jesus queno nenqanta: “Manaraq gallu cantaptinmi, quima cuti negamanqui.” ");
INSERT INTO qwhNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsenam tsepita yarqurïcur allapa pësacur, llaquicur, waqaquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tsenam Jesusta presu apaq nunacuna burlacurnin, maqayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Y nawinta tsaparcurnam, tapuyarqan: —¿Mä, adibinë, pi laqyashonqequitapis! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tsenomi mas llutancunata nirnin, burlacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Patsa waräriptinnam, autoridacuna, mandacoq caq saserdoticuna y ley yachatsicoqcuna Corti Supremaman apayarqan. Pecunanam tsecho tapupäyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Mä, canan niyämë: ¿Dios Acrashqancu qam canqui? —nishpa. Tsenam Jesus nerqan: —Niyapteqpis, manam creyiyämanquitsu; ");
INSERT INTO qwhNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","qamcunata tapuyapteqpis, manam yasquiyämanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peru cananpita witsepam Diospita Shamushqa Nuna tëcurenqa puedeq Diospa derechu caq ladunman. ");
INSERT INTO qwhNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsenam llapan tsecho quecaqcuna tapucurcuyarqan: —Tsepenqa ¿rasonpacu Diospa tsurin canqui? —nir. Jesusnam yasquerqan: —¡Quiquiquicunam niyanqui noqa pe canqäta! ");
INSERT INTO qwhNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pecunanam niyarqan: —¿Imapaqnataq testigucunata munantsic? ¡Quiquintsicnataq wiyecantsic shiminwan nimanqantsicta! ");
INSERT INTO qwhNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsepitanam llapan autoridacuna gobernador Pilatuman Jesusta apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tsechonam Jesuspa contran parlar queno niyarqan: —Que nunatam tariyarqö marca mayintsiccunata queno llutanta willapäquicaqta: ‘Noqam Dios Acrashqan rey cä’ nishpam, michäcun mandacoq cesarta impuestucunata paganantsicta. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsenam, Jesusta Pilatu queno taporqan: —¿Qamcu canqui israel nunacunapa reynin? —nir. Jesusnam nerqan: —¡Qammi nicanqui! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsenam mandacoq caq saserdoticunata y llapan nunacunata Pilatu nerqan: —Manam ni ima jutsantapis tarïtsu que nunacho —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tseno niptinnam, jina masraq bullacurcuyarqan queno nishpa: —Yachatsicuptinmi, nunacuna piñarnin autoridacunapa contran shäricurcuyan. Jinantin Judea probinsiachomi tseno yachatsicorqon. Galileapitam qallamushqa, y canannam quecho siguerqon yachatsicur. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tseno niyaptinnam, Pilatu tapucorqan: —¿Queqa Galilea nunacu? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Aumi” niyaptinnam, Galileacho mandacoq Herodisman Jesusta apatserqan jusgananpaq. Tsepinmi Jerusalencho Herodis quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesusta chäratsiyaptinnam, Herodis allapa cushïcorqan. Unepitam Jesusta reqita munarqan, pepaq allapa parlaqta wiyashqa car. Porqui shuyecarqan nopancho ima milagrullatapis ruranqanta riquetam. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pemi imecacunatapis Jesusta tapupecorqan. Peru manam Jesus yasquerqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tsecho quecaq mandacoq caq saserdoticuna y ley yachatsicoqcunanam tuquilayapa Jesuspa contran parlar acusecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tsenam Herodis soldaduncunawan allqutsarnin burlacuyarqan. Tsepitanam chipapaq mantuta aqshurcatsir, gobernador Pilatuman cutiratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tse junaqmi Herodiswan Pilatu amishtayarqan. Puntataqa chiquinacuyarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tsepitanam mandacoq caq saserdoticunata, autoridacunata y nunacunata qayaratsirnin, ");
INSERT INTO qwhNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilatu queno nerqan: —Que nunatam qamcuna noqaman apayämorqonqui ‘Nunacunatam bullaman churecan’ nir. Peru nopequicunacho tapuparnin, manam ni ima jutsanta acusayanqequinoqa tarïtsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodispis jutsanta mana tarirmi, noqaman cutiratsimorqon. ¡Que nunaqa wanunanpaqno manam ni ima mana allita rurashqatsu! ");
INSERT INTO qwhNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tsemi canan astecatsirlla, cacharishaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","˻Pascua fiestachomi costumbrincunamanno cachariyänan caq juc presuta.˼ ");
INSERT INTO qwhNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tsechonam nunacuna juc shimilla qayaripa niyarqan: —¡Que nunaqa wanutsun! ¡Barrabasta cachariqueqa! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabastaqa gobiernupa contran nunacunata pelyatsiptinmi, y wanutsicushqa captinmi, llawirëcatsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tsenam Jesusta cacharita munarnin, nunacunata Pilatu yape parlaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Peru nunacunanam masraq qayaricurcuyarqan queno nishpa: —¡Cruscho wanutsun! ¡Cruscho wanutsun! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tsenam quima cutichona Pilatu queno nerqan: —¿Ima mana allitataq rurashqa? Wanunanpaqnoqa manam ni ima jutsantapis tarïtsu. Tsemi astacacharcatsirninlla cacharishaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Peru nunacunanam qayariparaq niyarqan cruscho wanutsinanpaq. Mandacoq caq saserdoticuna y nunacuna tseno bullacurcuyaptinnam, mañacuyanqanno Pilatu rurarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tsemi pelyatsiconqanpita, y wanutsiconqanpita llawirëcaq Barrabasta cacharerqan. Jesustanam pecunata qoycorqan munayanqanno wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusta crusificaq apecarninnam, toparcayämorqan chacrapita shamicaq Simon jutiyoq nunawan. Pëqa carqan Cirene marcapitam. Tse nunatam mandayarqan crusta catarcur, Jesuspa qepanta apananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Atscaq nunacunam Jesuspa qepanta ewayarqan. Warmicunanäqa allapa llaquiquiwan pepaq waqarninmi ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tsenam pecunaman tumecur Jesus nerqan: —Jerusalen marcapeq warmicuna, noqapaqqa ama waqayëtsu. Quiquiquicunapaq y wamrequicunapaq waqayëqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porqui chämonqam junaqcuna nunacuna queno niyänanpaq: ‘¡Cushiquicho cayätsun mana wachacoq qolloq warmicuna, y mana llullu chicheqcuna.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tsepinmi mantsaquewan jircacunata nunacuna niyanqa, ‘Juclla janäcunaman jeqamur niticarcalläyämë mana jipalläyänäpaq!’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Si noqa, cawecaq montino quecaptï, queno rurayäman; israel nunacunanäqa tsaquishqa montinolla quecar, ¿imanoraq jipayanqa? ");
INSERT INTO qwhNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesustawanmi llutan ruraq ishcaq nunacunatapis apayarqan crusificayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calabera niyashqan sitiuman chäratsirnam, Jesusta crusman clabayarqan, ishcan mana alli ruraqcunatapis tsenolla, jucta derechu ladunman, jucnintana itsoq ladunman. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","˻Jesusnam nerqan: —Papällä, que nunacunata perdonequï. Manam musyayantsu ima rurayanqantapis.˼ Tsepitanam soldaducuna Jesuspa ropanta apacuyänanpaq sortiyayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tsechonam nunacuna shëcar ricarëcayarqan. Y autoridacunanam Jesusta burlaparnin niyarqan: —Juccunataqa salbashqam. Mä rasonpa, Dios Acrashqan carnenqa, y pepita shamushqa carnenqa, canan quiquinpis salbacutsun. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldaducunapis witïcurmi, Jesusta burlapar puchqoq binuta uputsita munar, queno niyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—¡Israel nunacunapa reynin carnenqa, quiquiqui salbaquï! ");
INSERT INTO qwhNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cruspa puntanchomi juc letreru queno escribirëcarqan: “Quemi israel nunacunapa reynin” nishpa. ˻Griegupa, romanupa y hebreupa parleninchomi escribishqa carqan.˼ ");
INSERT INTO qwhNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tsenam tsecho clabarëcaq jucnin mana alli ruraq nunapis Jesuspita burlacurnin, queno nerqan: —Qamchi Dios Acrashqan canqui. Mä, tseno carqa, quiquiqui salbacurïcur noqacunatapis salbarayämë. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Peru jucnin caqnam mana alli ruraq mayinta piñaparnin, queno nerqan: —¿Manacu Diosta mantsacunqui condenashqa quecarninpis? ");
INSERT INTO qwhNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noqantsicqa mana alli rurenintsicpitam quecho jipecantsic. Peru que nunaqa manam ni ima mana allitapis rurashqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesustanam queno nerqan: —Tëtalla, noqalläta yarpecamanqui yö mandaquiniquicho quecar. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesusnam nerqan: —Rasontam neq: Canantämi noqawan canqui paraiso nishqan shumaq cawaqui marcacho. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tse öram pullan junaqpita asta lastrescamayaq patsa pasepa paqasyäcurcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Intipis manam atsicyarqantsu. Templu rurincho cortinapis tse öram ishqueman rachirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesusnam qayaricorqan queno nishpa: —¡Diosllä, qamtam almalläta qoycoq! Tseno nirirnam wanurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldaducunapa capitanninnam tsecuna pasacoqta riquecur Diosta alabarnin, queno nerqan: —Rasonpam que nunaqa alli ruraq cashqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tseman ellucashqa llapan nunacunanam tsecuna pasaconqanta riquecur, allapa llaquiquiwan pechuncunatapis cutarraq cuticuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesusta reqeq nunacunanam y Galileapita qatimushqa warmicunanam carullapita llapanta ricarar quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tsechomi carqan juc nuna Dios munashqanno cawaq, Jose jutiyoq. Pemi Judeacho quecaq Arimatea marcapita carqan. Pepis carqan israel nunacunapa autoridaninmi. Que nunam allapa alli carnin, allicunallata ruraq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Autorida mayincuna Jesusta wanutsiyänanpaq parlayaptinpis, pëqa manam munarqantsu. Tse nunaqa Teyta Diospa mandaquinintam shuyararqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pemi Pilatuman ewar, mañarqan Jesuspa ayanta pampecunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tsenam Jesuspa ayanta cruspita yarpäratsir, finu sabanaswan piturcur, aparqan qaqacho uchcushqa sepulturaman pampaq. Tsechoqa manaran pitapis pampayarqanraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tse junaqqa biernis dispira tardinam carqan, y qallecorqannam jamacuyänan junaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Jesusta qatir shamushqa warmicunanam ewayarqan Josepa qepanta. Pecunam ricayarqan Jesuspa sepulturanta y imano pampayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsepita wayincunaman cutirirnam, shumaq pucutaq perfumita prebiniyarqan Jesuspa ayanta llushiyänanpaq. Peru ley mandacushqanno, jamaqui junaq captinnam, jamacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingu qoyanam prebiniyanqan pucutaq perfumita aparcur, Jesus pamparanqanman ewayarqan. ˻Waquin warmicunanam yanaqäyarqan.˼ ");
INSERT INTO qwhNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chärirnam, taririyarqan tsaparaq qaqataqa juc laduchona quecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ruriman yecurirnam, Teyta Jesuspa ayantaqa tariyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tsenam imano quetapis puediyarqantsu. Tseno quecayaptinnam, ishcaq nunacuna chipapëcaq bestishqa juclla yuripicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tsenam mantsaquewan tse warmicuna qoncuriquicuyarqan urcuncunapis patsaman chanqanyaq. Tse nunacunanam niyarqan: —¿Imanirtaq cawecaq nunata ashiyanqui wanushqacuna pamparäyanqancho? ");
INSERT INTO qwhNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Manam quechonatsu; cawarimushqanam. ¿Manacu yarpäyanqui qamcunawan Galilea marcacho quecar, queno nishpa willayäshonqequita? ");
INSERT INTO qwhNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Presisanmi Diospita Shamushqa Nunata jutsasapacunaman entregayänan cruscho wanutsiyänanpaq. Y wanushqanpitam quima junaqllata cawarimonqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tseta wiyarirninnam, warmicuna yarpäriyarqan Jesus tseno willacushqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsepita cutirirnam, chunca juc (11) apostolcunata y tsecho llapan quecaqcunata willayarqan sepulturacho ricayanqanta y wiyayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tse apostolcunata willaqcunaqa cayarqan Maria Magdalenam, Juanam, Santiagupa mamänin Mariam y mas warmicunam. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Willacuyanqanta wiyarirninnam, apostolnincuna bufunadapaq churar creyiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Imano captinpis, Pedroqa sharcurmi coripa ewarqan Jesus pamparashqanman. Sepulturaman chärirnam, puctïcur qawecorqan y ricarerqan Jesus wancurashqan sabanasllatana. Tseta ricarirnam, yarpacachar wayiman mantsacashqa cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tse tardinam, ishcaq qatiraqnincuna euquicayarqan Emaus nishqan marcaman. Tse marcaqa Jerusalenpita pitsqa quilometruchomi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Euquicarninnam, Jerusalencho llapan pasacushqancunata parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tseno parlar cäyitsinacur ewecayaptinnam, Jesus yurircur pecunawan juntu ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Peru riquecarpis, manam reqiyarqantsu Jesus canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsenam Jesus taporqan: —¿Imata parlartaq euquicayanqui? —nir. Pecunanam llaquishqa shäcuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsenam Cleofas jutiyoq caqna nerqan: —Qamllachi Jerusalencho quecar, ¿que junaqcuna imapis pasaconqanta musyanquitsu? ");
INSERT INTO qwhNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesusnam nerqan: —¿Imataq pasacushqa? Pecunanam niyarqan: —Juc nunam carqan Nazaret marcapita Jesus jutiyoq. Pemi carqan Diosnintsicpa profetan. Rureninwanpis y parleninwanpis allapa puedeqmi carqan Diospa y nunacunapa nopancho. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Petam saserdoticunapa mandacoqnincuna y autoridacuna entregayarqan condenar cruscho wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Imanomi noqacuna peman marcäcuyarqä, ‘pechi israel nunacunata libramäshun’ nishpa. Peru tseno marcäquicayaptïpis, quima junaqnam peta wanutsiyanqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Manam tsepis tsellatsu. Noqacunawan pureq warmicunam canan qoya qoyalla Jesus pamparashqanman ewar, espantaquipaqta willacayämushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesuspa ayanta mana tarirninmi, wayiman cutiyämorqon. Y niyämarqon anjelcunash pecunata yuripur, ‘Jesusqa cawanmi’ niyarqonaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tseno willayämaptinnam, waquin yanaqicuna ewayarqon sepulturaman, y warmicuna willacuyanqannollash tariyarqonaq. Peru Jesustaqa manash ricayarqonaqtsu” nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tsenam Jesus nerqan: —¡Qamcunaqa imalaya upataq y rumi shonqutaq cayanqui Diospa profetancuna willacuyanqanta mana creyicuyänequipaq! ");
INSERT INTO qwhNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manacu Dios Acrashqan tseno sufrir jipanan presisarqan, manaraq glorianman cuticur! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tseno nirnam, pecunata cäyitserqan Diospa palabran escribirëcaq pepaq willaconqanta. Moises escribishqanpita qallecur, asta Diospa profetancuna escribiyashqanyaq quiquinpaq parlecanqanta cäyitsirnin. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaus marcaman yecurëcayaptinnam, Jesusqa nänipa pasacoqno carqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Peru pecunanam mañepa queno niyarqan: —Noqacunawan quedacushun. Allapa tardinam, patsapis paqasyärinnam. Tsenam Jesus pecunawan quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Micuyänanpaq mesaman täcuriyaptinnam, tantata Jesus tsarircur, Diosman mañacurir, paquirïcur pecunata qorerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tse öram nawincuna quichacäreq cuenta reqiriyarqan Jesus cashqanta. Tsenam juclla tsincarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pecunanam parlayarqan: —Jesus captinchi, nänichoqa shonquntsic allapa cushicorqon, Diospa palabranta willapar cäyitsimashqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tsenam jinallacho Jerusalenman cuticuyarqan. Chärirnam, taririyarqan chunca juc (11) apostolcunata y waquin qatiraqnincunatawan ellucashqa quecayaqta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tse ellucashqacunanam niyarqan: —Rasonpam Teyta Jesusqa cawarimushqa. Simontam yuripushqa. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tsenam Emauspita ishcan cuteqcunapis willacuyarqan nänicho ima pasayanqanta, y tantata paquenqan öra reqiriyanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tseno parlecayaptinmi, chopincunaman yurircur Jesus napacurerqan queno nishpa: —Alli pasaquicho cayë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tsenam limpu mantsaquecuyarqan “¡Queqa almatsun o imam!” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesusnam nerqan: —¿Imanirtaq mantsacäyanqui? ¿Imanirtaq mana creyiyanquitsu noqa canqäta? ");
INSERT INTO qwhNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Que maquïta, chaquïta ricayë. Yatayämë, noqa canqäta musyayänequipaq. Almapaqa manam etsan ni tullun cantsu. Ricayämanqequinomi noqapaqa can —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tseno nirmi, riquetsicorqan maquincunata y chaquincunata. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tsenam cushiquiwan y mantsaquewan creyiyarqanraqtsu pe cashqanta. Jesusnam nerqan: —¿Micurinäpaq imallapis cayäpushunquicu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tsenam pescadu cancashqata ˻y abejapa mishquinta˼ qoriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chasquirirninnam, nopancunacho micorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tsepitanam nerqan: —Queno pasamänantaqa, qamcunawan quecarmi, willayarqaq Diospa profetancuna, Moises escribishqan leycuna, y salmu libruchopis noqapaq escribirëcanqan cumplicänan cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsepitanam Diospa palabranta pecunata alli cäyitserqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tsemi nerqan: —Quenomi Diospa palabran noqapaq escribirëcan: ‘Dios Acrashqantam wanutsiyanqa. Y quima junaqllatam cawarimonqa.’ ");
INSERT INTO qwhNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Y noqapa jutïcho Jerusalenpita qallecur jinantin nasioncunapa ewar, nunacunata willapäyätsun jutsa rurayanqancunata jaqiriyaptin perdonashqa cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Qamcunam llapanta ricashqa carnin, testigoqa cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Qamcunamanmi cachamushaq Papänï änicushqan Santu Espirituta. Tsemi quecäyë Jerusalenllachoraq asta Diospa podernin chämoqta chasquiyanqequiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsepitanam disipuluncunata pusharqan Betania jircaman. Tsechonam maquinta raraman pallarcur, pecunata bendisicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tseno bendisicarninnam, pecunapita pallaricar, sieluman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pecunanam qonqurïcur adorarirnin, Jerusalenman allapa cushishqa cutïcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Imepis tse templullachomi Diosta alabarnin, cacuyarqan. ˻Tseno catsun.˼");
INSERT INTO qwhNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Manaraq imapis captinmi, willacamoqqa quecarqanna. Tse willacamoqqa Dioswanmi quecarqan, y Pëqa quiquin Diosmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pëqa imepitapis Dioswan juntum quecan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pewanmi Dios camarqan imecatapis, y mana pewan camaptenqa, manam ni imapis canmantsu carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pellachomi wiñe cawaqueqa. Pemi imeca actsino musyatsimantsic Diosnintsicwan alli cawacunapaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pëqa paqascho actsi cuentam quecan, y manam tse paqas actsita ushacätsita puedenqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Juc nunam carqan Juan jutiyoq; petam Dios cachamorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tse nunam shamorqan tse actsicoqpaq willacurnin, llapantsic pe willapäconqanman creyicunapaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanqa manam actsicoqtsu carqan, sinoqa tse actsimaqnintsicpaq willacoqmi shamorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesusllam rasonpa actsicoq cuenta carnin, que patsaman shamushqa llapan nunacunata cäyitsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pe que munduta camashqa quecaptinpis, que patsaman chämuptin, nunacuna manam consientiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Marca mayincunaman chëcamuptinpis, manam pecunallapis chasquiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peru peman marcäcur chasqueqcunataqa llapancunatam Diospa tsurincunana cayänanpaq ticraratsishqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pepa tsurin queqa manam nunacuna mirayashqannotsu, ni etsancunapa muneninta rurarir wamrata yuriratseqnotsu, ni nunacuna munashqannotsu, sinoqa Diospa poderninwanmi pepa tsurincunana ticrariyan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesusmi nunaman ticrarir, que patsacho noqacunawan tärarqan. Noqacunam ricayarqä pepa allapa alli queninta. Tseno alleqa carqan pella Dios Yayapa tsurin carmi. Pëqa allapa cuyacoqmi y yanapacoqmi carqan, y rasonpa caqllatam Diospaq parlarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pepaqmi Juan qayaripa queno willacorqan: “Pepaqmi puntata willayarqaq: ‘Qepätaraq yuricoqqa noqapitapis mas puedeqmi, porqui manaraq noqa captïmi pëqa imepitapis quecarqanna’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tsemi noqapis niyaq: Pëqa allapa alli queninwanmi imepis yanapecamantsic. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Une tiempum Dios mandanqan leyllata Moises yachatsicorqan. Peru cananqa Teyta Jesucristunam rasonpa caqta y alli queninta musyatsimashqantsic. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manam pipis ni ime Diosta ricashqatsu. Peru tsurin Jesucristullam Dios carnin, y Dios Yayawan jucnolla carnin, musyatsimantsic imano Dios canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juc junaqmi Jerusalen marcacho israel autoridacuna Juanman cachayarqan waquin saserdoticunata y yanapaqnin levitacunata “¿Qamqa, pitaq canqui?” nir, Juanta tapuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juannam rasonpa caqta willacur, mana mantsacushpa queno declarecorqan: —Noqaqa manam Dios Acrashqantsu cä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsenam yape tapuyarqan: —Tsepenqa ¿pitaq canqui? ¿Profeta Eliascu canqui? —nir. Juannam nerqan: —Manam Eliastsu cä —nir. Pecunanam jina queno tapuyarqan: —¿Tsepenqa shuyacuyanqä profetacu canqui? —nir. Juannam nerqan: —Manam tsepistsu cä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsenam pecuna niyarqan: —Sinoqa ¿pitaq canqui? Cachayämaqnïta willayänäpaq pi canqequitapis willecayämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juannam nerqan: —Profeta Isaiasmi queno escriberqan: ‘Tsunyaqchomi juc nuna qayaripa queno willaconqa, “Nänicunata derechar limpiaq cuenta prebinicuyë Teytantsicta chasquiyänequipaq” ’ —nir. Tse willacoqqa noqam cä. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tse tapucoq ewaqcunaqa fariseu grupupitam cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pecunam queno niyarqan: —Dios Acrashqan mana carqa, ni Elias mana carqa, ni shuyacuyanqä Profeta mana carqa, ¿Ima puedeq queniquiwantaq nunacunata qam bautisanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tsenam Juan queno nerqan: —Noqaqa yacullawanmi nunacunata bautisä, peru noqapita mas puedeqqa que marcantsicchonam quecan, y qamcuna manam peta reqiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pëqa shamicannam, y allapa puedeq captinmi, noqaqa sirwïtsu qonquricur pepa llanqinpa watunta pascarillatapis —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jordan mayupa wac tsimpan Betania marcacho nunacunata Juan bautisecaptinmi, tseno pasacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Waräninnam, Juanqa peman Jesus yecurëcaqta riquecur, queno nerqan: “¡Ricayë, taqemi Diospa achcasnin. Pemi jinantin munducho nunacunapa jutsancunarecur wanonqa! ");
INSERT INTO qwhNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Pepaqmi nopata willayarqaq queno: ‘Juc nunam qepätaraq shamonqa noqapita mas puedeq, porqui manaraq noqa yuricuptïmi, pëqa carqanna’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tsemi pi canqantapis manaraq musyashpa, qamcunata yacuwan bautisayarqaq llapantsic israel nunacuna peta reqinantsicpaq.” ");
INSERT INTO qwhNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tsepitanam jina quenopis nerqan: “Noqam ricarqä imeca palumano Santu Espiritu rara sielupita urämur peman tarpoqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Noqaqa pe cashqanta manam reqïmantsu carqan, peru yacuwan nunacunata bautisanäpaq cachamaqnï Diosmi queno nimashqa carqan: ‘Imemi Santu Espiritu rara sielupita urämurnin, juc nunaman tarpoqta ricanqui, pemi nunacunata Santu Espirituwan bautisanqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Noqam ricarqö, y rasonpa caqtam willayaq pëqa rasonpam Diospa tsurin.” ");
INSERT INTO qwhNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Waräninnam ishcaq disipulunwan Juan yape quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tsecho Jesus puricaqta riquecurninnam, Juan queno nerqan: —¡Ricayë! ¡Taqemi Dios acrashqan achcas! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tseta wiyecurnam, Juanta jaqiricur, ishcan disipuluncuna Jesusta qatircurna eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tsenam Jesus tumecur, qepanta ewayanqanta riquecurnin, queno nerqan: —¿Imatataq ashiyanqui? —nir. Pecunanam queno niyarqan: —Rabi, ¿mechotaq yachanqui? —nishpa. (Rabeqa “yachatsicoq” ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesusnam queno nerqan: —Acu, ewashun. Reqitsiyashqequim —nir. Tsenam ewar, reqiriyarqan mecho yachanqanta. Tardi lascuatrunona captinnam, tsecho pewan quedacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan nenqanta wiyarir, Jesusta qateqcunaqa cayarqan ishcaqmi; juc caqmi carqan Andres. Pëqa carqan Simon Pedrupa wauqinmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tse Andresnam wauqin Simon asheq eucorqan; taririrnam queno nerqan: —¡Mesiastam noqacuna taricuyarqö! —nishpa. (Mesiasqa Dios Acrashqan ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tsenam Andresqa wauqin Simonta Jesusman pusharqan. Chäriyaptinnam, Simonta riquecur, Jesus queno nerqan: —Qamqa Jonaspa tsurin Simonmi canqui. Cananpita witsepam jutiqui Cefas canqa (Cefasqa ‘Pedru’ ninanmi). ");
INSERT INTO qwhNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Waräninnam Galilea marcaman Jesus eweta munarqan. Felipiwan tarinacurirnam, queno nerqan: —Acu, eucushun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida marcacho yuricoqcunam Felipi, Andres y Simon Pedroqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesus tseno niptinnam, Felipi eucorqan Natanael asheq. Taririrnam, queno nerqan: —Moises escribishqanchomi y Profetacuna escribiyashqanchomi willacun juc nuna shamunanpaq caqta. ¡Petam taricuyarqö! Mä, Nazaretcho täraq Josepa tsurin Jesusmi carqonaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelnam nerqan: —¿Nazaretpita, Nazaret nunacunaqa imellaqa alli nuna cayashqataq! —nir. Felipinam nerqan: —¡Masqui acu reqinequipaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Peman yecurëcaqta riquecurnam, Natanaelpaq Jesus queno nerqan: —Que nunaqa allapa cabal carmi, rasonpa israel nunano manejacun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelnam queno nerqan: —¿Imanopataq noqata qam reqimanqui? —nir. Tsenam Jesus nerqan: —Manaraq Felipi qayashuptiquim, igus montipa chaquincho imano quecanqequitapis ricarqoq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsenam Natanael queno nerqan: —Mayestru, ¡cananmi si, musyarï Diospa tsurin rasonpa canqequita, y israel nunacunapa mandacoqnin canqequita! ");
INSERT INTO qwhNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusnam nerqan: —¿Igus montipa chaquinchomi ricarqö nipteqraqcu, qam creyinqui? Antis que ricanqequipitapis mas espantepaqcunataran ricanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tseno nirirnam queno nerqan: —Rasontam rasontam niyaq. Cananpita witsepam qamcuna ricayanqui sielu quicharëcaqta, y tsepitana Diospita Shamushqa Nunaman Diospa anjelnincuna witsärir urärir pureqta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tsepita quima junaqtanam Galilea probinsiacho quecaq Canä nishqan marcacho casaqui fiesta carqan. Y Jesuspa mamäninpis tsechomi quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jina Jesuspis disipuluncunawan combidadum cayarqan tse casaqui fiestaman. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tsecho binuncuna ushacäquicuptinnam, Jesusta mamänin queno nerqan: —Binuncunam ushacäcurishqa —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusnam nerqan: —Mamä, shuyarämë, ama tsepaq yarpacachëtsu. Manaran orä chämunraqtsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mamäninnam tse fiestacho yanapacoqcunata nerqan: —Pe mandayäshonqequita rurayë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tsechomi rumipita rurashqa chunca baldi cabeqyan yacu winaränan joqta botjacuna quecarqan. Tse yacutam israel nunacuna costumbrincunamanno Diospaq limpiu cayänanpaq imatapis paqar inishiyaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesusnam tse yanapacoqcunata queno nerqan: —Que botjacunaman yacuta winayë —nir. Pecunanam yacuta junta junta winariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesusnam nerqan: —Canan si chaqarcur, camachicu llaminanpaq apayë —nir. Tsenam apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Camachicunam llamirerqan yacupita binu ticrashqata, peru manam musyarqantsu mepita jorquyanqanta. (Yanapacoqcunallam musyayarqan mepita yacuta jorquyashqanta.) Camachicunam nobiuta qayarirnin, ");
INSERT INTO qwhNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","queno nerqan: —Queno fiestacunachoqa pipis alli caq binutam puntata qaracun. Teqñariyaptinnam, lluta caqtana qaracur qallan. ¡Peru qamqa que alli caq binutataq cananyaq churarätserqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galilea probinsiacho quecaq Canä marcacho que milagruta primera bes rurarirmi, puedeq queninta Jesus ricatsicorqan. Tsemi disipuluncuna pellamanna mas creyicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsepitanam Capernaum marcaman Jesus ewarqan mamäninwan, wauqincunawan, y disipuluncunawan. Tsechoqa manam quedayarqan unepatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel nunacunapa Pascua fiestancunapaq ichicllana pishicaptinmi, Jerusalenman Jesus witsarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tseman chärirnam, tarirerqan templupa patiuncho toritucunata, üshacunata, y palumacunata rantiquicayaqta. Waquincunanam qelleta trocarnin tëcayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tseta riquecurnam, wascapita chicotita alistaricur, templupita tse ranticoqcunata üshancunatawan toruncunatawan qarqorqan. Y trocapäcoqcunapa qellenincunatanam wictsicacharcur, mesancunatapis jitacacharcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Paluma ranticoqcunatanam nerqan: —¡Quepita llapanta jorquyë! ¡Ama nunca Papänïpa wayinta mercadutano inishiyanquitsu! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tseta ricarmi, disipuluncuna yarpäriyarqan Diospa palabrancho queno escribirëcanqanta: “Wanurpis wanurishaqmi Diosta adorayänan wayirecorqa” nenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tsenam israel autoridacuna queno niyarqan: —Mä, puedeq queniquita musyayänäpaq jucllana milagruta rurecamï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tsenam Jesus nerqan: —Masqui que templuta ushacäratsiyë quima junaqllata sharcaratsimunäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsenam tse autoridacuna queno niyarqan: —Que templutaqa chuscu chunca joqta (46) watachoran sharcatsiyashqa. ¿Tsetsuraq quima junaqllataqa sharcaratsimunqui? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Peru Jesusqa parlecarqan quiquinpa cuerpun tse templu cuenta canqantam. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tsemi wanushqanpita Jesus cawariramuptin, disipuluncuna yarpäriyarqan Jesus tseno nenqanta. Tsemi creyiriyarqan Diospa palabran pepaq escribirëcashqanta y Jesus parlanqancunata. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalenchomi Pascua fiestacho quecarnin, Jesus tuquilaya milagrucuna rurarqan. Tseta ricarninmi, atscaq nunacuna peman creyiquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Peru Jesusqa manam pecunaman marcäcorqantsu, porqui llapan nunacunatam reqerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pëqa manam pipis willaptinraqtsu, musyarqan nunacunapaq. Quiquinmi musyarqan nunacuna imanopis cayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Fariseucunapitam carqan juc reqishqa nuna Nicodemu jutiyoq. Pemi carqan israel nunacunapa autoridanin. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tse nunam paqasllapa Jesusman ewarnin, queno nerqan: —Mayestru, noqacunam musyayä Dios yachatsiyämänequipaq cachamushonqequita, porqui manam pipis qamnoqa milagrucunata ruranmantsu, Dios mana pewan captenqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tsenam Jesus nerqan: —Rasontam rasontam neq: Pipis yape mana yuricorqa, Diospa mandaquininman manam yeconqatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemunam nerqan: —Juc auquis nunaqa ¿imanopataq jucpita yuriconqa? ¡Acasu mamanpa pachanman cuticur yapecu yuriconqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tsenam Jesus queno nerqan: —Rasontam rasontam neq: Yacupita y Santu Espiritupita mana yuricorqa, manam meqan nunapis Diospa mandaquininman yeconqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mamanpita yuricoqcunaqa nunacunanollam cayan. Peru Santu Espiritupita yuricoqcunaqa, juclaya caweyoqnam cayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama mantsaquëtsu: ‘Presisanmi yape yuricuyänan’ nenqaqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bientoqa mepeqpis jepeqpis shamunmi, y wiyantsicmi shiushiuyaqta, peru manam musyantsictsu mepita shamonqanta ni meta ewanqanta. Tse cuentanollam Santu Espiritupita yuricoqcunaqa cayan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsenam Nicodemu nerqan: —Tëte, ¡Tsetaqa cäyilläpistsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesusnam nerqan: —Israel nunacunapa yachatseqnin mayestru quecarninpis, ¿manacu quecunata cäyinqui? ");
INSERT INTO qwhNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rasontam rasontam neq. Noqacunam ricayashqäcunata y musyayashqäcunata willayaq. Tseta nipteqpis, qam manam creyimanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Que fasillla caqcunata yachatsipteqpis, manataq creyimanquitsu; ¿tsetsuraq rara sielucho caqcunapaq yachatsipteqnäqa creyimanquiman? ");
INSERT INTO qwhNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Manam pipis sieluman ewashqatsu, sinoqa sielupita shamushqallam: tseqa Diospita Shamushqa Nunam. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Imanomi culebrapa imajinninta shucshupa puntanman warcurcur, tsunyaqcho Moises sharcatserqan. Tsenollam Diospita Shamushqa Nunatapis crusman clabarcurnin, sharcaratsiyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tsemi pipis peman marcäcoqqa wiñe caweyoq cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Porqui que patsacho nunacunata allapa cuyarninmi, Dios jucllella tsurinta cachamorqan, peman marcäcoqcuna mana condenashqa cayänanpaq sinoqa wiñepa cawayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Teyta Diosqa tsurin Jesucristuta que patsaman cachamorqan manam nunacunata condenananpaqtsu, sinoqa salbananpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pipis peman creyicurnenqa, manam condenadutsu. Peru mana creyicoqcunaqa condenadunam quecayan, Diospa jucllella tsurin Jesucristuman mana marcäcuyanqanrecur. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pëqa imeca actsi cuentam que patsaman shamorqan. Peru nunacunanam paqaschono mana alli ruraquillacho caquita munar, peta chasquiyarqantsu, porqui mana alli ruretam mas gustayarqan. Tsemi condenadu cayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Porqui mana alli ruraqcunaqa paqaschono mana allita rurarninmi actsita gustayantsu, tsemi actsiman shayämuntsu, mana alli rurenincuna mana musyacashqa cananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Peru alli cawacoqcunaqa, imeca alli ruraqcuna actsita gustaqnomi, Jesusman shayämun, y Dios yanapayashqanta musyayänanrecurmi alli rurenincunata ricatsicuyan. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsepitanam Jesus ewarqan disipuluncunawan Judea probinsiacho marcacunaman. Tsechonam pecunapis nunacunata bautisarnin cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Y Juanpis jina bautisecarqanmi, Enon nishqancho atsca yacu captin. Tseqa carqan Salim marcapa ladunllachomi. Tsemanpis atscaqmi nunacuna ewayarqan bautisacoq. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tsepin manaran Juanta carselman llawiyarqanraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tse junaqcunanam Juanpa disipuluncuna israel autoridawan liryacurcuyarqan bautismu asuntu. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tsenam Juanman ewarnin, disipuluncuna willayarqan queno nishpa: —Mayestru, Jordan mayupa wac tsimpancho nunacunata bautisecaptiquim, tseman juc nuna shamorqan. Pepaqmi qam willapäyämarqequi. Cananqa pepis nunacunata bautisecanshi, y llapan nunacunash bautisacoq ewarnin, petana qatiräcuyan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tsenam Juan queno nerqan: —Manam meqan nunapis tseno presisaq queta puedinmantsu, quiquin Dios mana yanapaptenqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Qamcuna wiyayarqequim: ‘Noqaqa manam Dios Acrashqantsu cä’ nenqäta. ‘Sinoqa pepaq willacunäpaqmi puntata Dios cachamarqon.’ ");
INSERT INTO qwhNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Casariptenqa nobiaqa nobiullapam. Y nobiupa amigunmi pecuna parlapänacoqta wiyar, sellama cushicun. Tse cuentanollam noqa allapa cushicü canan. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Porqui presisanmi noqapita pe mas presisaq canan. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Sielupita shamoqqa imecapitapis mas puedeqmi. Noqaqa que patsallapitam cä, y parläpis nuna quenïmannollam. Peru sielupita shamoqqa llapanpitapis mas puedeqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pëqa wiyanqantam y ricanqantam willapämantsic. Tseno captinpis, nunacuna manam chasquiyantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Peru waquincunaqa creyicurninmi, cuentata qocuriyan Dios rason caq parlanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Porqui Dios cachamushqanqa yachatsicun Dios parlashqancunatam. Petaqa Diosmi Santu Espiritunta paqwepa qoycushqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Yayaqa tsurin Jesucristuta cuyarmi, que munducho imecatapis pepa poderninman qoycushqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pipis Diospa tsurinman marcäcurnenqa wiñe cawayoqmi cayanqa. Peru peman mana marcäcurnenqa, wiñe caweta manam tarenqatsu antis pecunata Dios allapa feyupa castigananpaqmi quecan” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Juanpitapis mas atscaq Jesuspa disipuluncuna miracurcuyanqantam y atscaqta bautisayanqantam fariseucuna musyariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Quiquin Jesustsu manam bautisarqan sinoqa disipuluncunam.) ");
INSERT INTO qwhNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseucuna tseno musyayanqanta Jesus cuentata qocurirnam, Judea probinsiapita Galilea probinsiaman yape cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tseman chänanpaq presisarqan Samaria marcapa pasanan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Eucurninnam, Samaria probinsiapa Sicar nishqan marcanman chärerqan. Tse marcaqa carqan tsurin Joseta Jacob chacran qoshqan nopanchomi. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tsechomi Jacob posuta oqtishqa carqan yacupaq. Tse posupa nopanchomi utishqa carnin, Jesus jamacurerqan. Y pullan junaqnam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tse posuman Samaria warmi yacuta jorqunanpaq chäriptinnam, Jesus queno nerqan: —Yacullä qarecamë upurinäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Disipuluncunanam micuyänanpaq miqui ranteq callita ewayashqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tse Samaria warminam queno nerqan: —¿Imanopataq qam israel nuna quecar, noqata yacuta mañacamanqui? Noqaqa Samaria marcacho yuricoq warmim cä. Y israel nunacunaqa Samaria nunacunawan manataq parlapänacuntsictsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesusnam nerqan: —Sitsun qam cäyinquiman Diospa bendisionnin imano canqanta, y musyanquiman yacu mañacushoqniqui pi canqätapis; qammi mañaquecamanquiman, y noqaqa cawatsicoq yacutam qoycoqman —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Warminam nerqan: —Tëte, manataq chaqanequipaq imequipis capushunquitsu; ¡que posoqa ondutaq! ¿Mepitataq tse cawatsicoq yacutaqa apamunqui? ");
INSERT INTO qwhNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Une tëtantsic Jacobmi que posuta rurarqan. Quepeqmi yacuta upuyarqan tsurincuna y animalnincunapis. ¿Acasu pepita mas puedeqcu qam canqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesusnam nerqan: —Pipis que posupita yacuta upoq caqqa, yapemi yacunanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Peru pipis noqa qonqä yacu upoq caqqa, mananam imepis yacunanqanatsu. Antis imeca mana ushacaq pucyu cuentam wiñe caweyoq ticrarenqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tsenam tse warmi nerqan: —Tëte, mä tse yacullä qarecallämë manana imepis yacunänäpaq y manana ni imepis yacu chaqaq queman shamunäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesusnam queno nerqan: —Ewë qowequita qayamunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Warminam nerqan: —Qowäqa manam cantsu —nir Jesusnam nerqan: —Manam ulicorqonquitsu: ‘Qowä cantsu’ nimarnï. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porqui pitsqaqmi qowequi capushorqonqui, y canan yachecanqequiwanqa manam casadutsu cayanqui. Tsetaqa rasontam nimarqonqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Warminam nerqan: —Tëte, qamqa profetatsunchi canqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Une awilücunam taqe jircacho Diosta adorayarqan. Peru qamcunaqa niyanqui: ‘Jerusalenllachomi Diostaqa adoranantsic’ nishpataq. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesusnam nerqan: —Creyimë, mamite. Chäramunnam tiempu manam ni taqe jircallachotsu ni Jerusalenllachotsu Dios Yayata adorayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Diosta mana allipa reqirninmi, qamcuna mana allipa adorayanqui. Noqacunaqa Diosta reqirninmi, allipa adorayä, porqui nunacunata salbaqqa israel castapitam shamonqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Peru cananpita witsepanam nunacuna Dios Yayata adorayanqa juclaya shonquncunawan, porqui tseno adorayänantam Dios Yayaqa munan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosqa Espiritum, y mecho tsechopis quecanmi. Tsemi Diostaqa Santu Espiritu yanapamashqa rasonpa adoranantsic —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Warminam nerqan: —Noqa musyämi que patsaman Mesias shamunanta. (Pëqa Dios Acrashqanmi.) Pemi llapanta cäyitsimäshun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesusnam nerqan: —Noqam cä, canan qamwan parlecaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesus tseno nicaptinnam, disipuluncuna callipita chäriyarqan. Juc warmiwan parlecaqta tarïcurnam espantacuyarqan. Peru Jesustaqa manam ni meqanlla tapuyarqantsu “¿Imata tapicanqui?” y “¿Imapaq parlecayanqui?” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Warminam puyñunta jaqiricur, tse marcaman cuticur, nunacunata queno willarqan: ");
INSERT INTO qwhNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Coricayämï! ¡Taqecho quecaq nunata riquecuyë! ¡Pemi noqata nïcamashqa llapan rurashqäcunata! ¿Petsuraq Dios Acrashqan canman? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tsenam, Jesusman nunacuna coripa ewacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tseyaqnam Jesusta disipuluncuna queno rogayarqan: —Mayestru, micurillëri —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Peru Jesusnam nerqan: —Noqapa miquinïqa qamcuna mana musyayanqequim —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tseno niptinnam, quiquincuna puralla queno ninacuyarqan: —¿Pi carpis imallatapis qarayarqontsuraq? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesusnam nerqan: —Noqapa miquinïqa cachamaqnïpa munenincunata ruranämi y llapan mandamashqancunata cumplinämi. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Qamcunam niyanqui: ‘Chuscu quillaran pishin cosechapaq’ nir. Peru noqanam niyaq: Alleq cäyiyë. Chacracunacho miquicuna elluyänequipaq poqurishqa cuentam nunacuna quecayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Y cosechacho uryaqcuna pagunta chasquir, cushicoq cuentam wiñe cawepaq willapäcoqcunaqa cushicuyänanpaq quecayan. Tsenam murucoqcuna y cosechaqcuna cushicuyanqanno, pecunapis cushicuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tseno captinmi, rason caqllata quenopis parlayanqui: ‘Jucmi murun, jucnam cosechan’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tsemi qamcunatapis mana willapäcuyashqequiman cachayaq. Puntatam waquincuna murucoq cuenta Diospaq willapäcuyashqana cayarqan. Canannam listullamanna noqaman creyicuyänanpaq willapäcoq yecuriyanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tse warmim willacorqan queno: “Jesusmi nicamarqon imeca rurashqäcunatapis” nir. Tseta wiyarninmi, atscaq Samaria nunacuna Jesusman creyicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tsenam Samaria nunacuna Jesusman ewar queno rogayarqan: “Cananllapis quedacurilläshunraq” nishpa. Tseno niyaptinnam, ishque junaq pecunawan quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Quiquin Jesus parlanqanta wiyecurnäqa, mas atscaqran peman creyiquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tsenam warmita queno niyarqan: —Manam qam willayämashqequirecurllatsu cananqa creyiyä. Sinoqa pe yachatsicushqanta quiquïcuna wiyarmi, rasonpa musyayä llapan nunacunapa salbadornintsic Dios Acrashqan canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ishque junaq Samariacho carirnam, Galileaman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porqui quiquin Jesusmi puntata queno nishqa carqan: “Marcanchoqa profetacunata manam respetayantsu” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Peru Galilea nunacunam Pascua fiesta pasaq Jerusalenman ewashqa car, Jesus poderninwan llapan milagrucunata rurashqanta ricayashqa cayarqan. Tserecurllam Jesus marcanman chäriptin, cushishqa chasquiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yapemi Jesus Galilea probinsiacho Canä marcaman cuterqan. Tsechomi yacuta binuman ticratsishqa carqan. Capernaum marcachomi reypa ofisialnin nuna pärarqan. Pepa tsurinmi qeshyecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tse ofisialmi Judea probinsiapita Galilea probinsiaman Jesus chärishqanta musyarerqan. Pemi ewar Jesusta rogarqan wayinta ewarnin tsurinta cachaquecatsinanpaq, porqui tse tsurin wanichonam quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tsenam Jesus nerqan: —Señacunata y milagrucunata ruraqta mana ricamarqa, manam noqaman creyicuyanquimantsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tse reypa ofisialninnam nerqan: —Tëte, manaraq tsurïlla wanuptin, apurellapa eweculläshun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesusnam nerqan: —Wayiquita cutiquï. Tsuriqui manam wanonqatsu —nir. Tsenam Jesus nishqanta creyirnin, nuna cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wayinman cuticurëcaptinnam, sirweqnincuna taripaqnin ewayarqan. Toparirnam queno niyarqan: —Tëte, tsurillequeqa cachacärishqanam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tsenam sirweqnincunata taporqan ime öra tsurin cachacärishqanta. Sirweqnincunanam niyarqan: —Qanyan tardi launanomi fiebrin tsincarerqan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tseno niyaptinnam, tse wamrapa papänin yarpärerqan tse öra Jesus “Tsuriqui manam wanonqatsu” nishqanta. Tsenam wayincho llapan caqcunawan Jesusman creyicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea probinsiapita Galilea probinsiaman cutirirmi, yape que milagruta Jesus rurarqan. Y punta ruranqanwanqa ishque milagrunam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsepitanam israel nunacunapa fiestancuna chärerqan. Tse fiestamanmi Jesuspis Jerusalenta ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenchomi “üshacuna yecuyänan” nishqan puncu laduncho juc quita carqan, hebreu idiomacho Betzata nishqan. Tse quitaqa pitsqa alarpa chopinchomi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tse alarcunachomi atscaq qeshyaqcuna iscaräcuyaq: wiscucuna, cojucuna, inbaliducuna. ˻Pecunam tsecho shuyayaq yacu cuyurcamoqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porqui une unellatayanmi juc anjel sielupita urämur, yacuta cuyurcatseq. Tse öram punta yecoq caqqa ima qeshyapitapis cachacäreq.˼ ");
INSERT INTO qwhNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tsechomi juc nuna quecarqan quima chunca puwaq (38) watana qeshyacoq. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tsenam tse nuna jitarëcaqta Jesus riquecurnin, y atsca watana qeshyaconqanta musyarirnin, queno taporqan: —¿Cachaqueta munanquicu? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Qeshyaqnam nerqan: —Tëte, quitacho yacu cuyurcuptin, manam pinïpis cantsu tse öra yacuman yacarcamänanpaq. Nacaquicallaptïmi, jucna llalliraman —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesusnam nerqan: —Canan sharcur, qopiquita aparcur euquï —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tse öram nuna cachacärerqan, y qopinta aparcur, eucorqan. Tse junaqqa jamacuyänan junaqmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tsemi tse cachacashqa nunata israel autoridacuna queno niyarqan: —¡Au nuna! ¿Imanirtan canan jamaqui junaqcho qopiquita apanqui! Tseqa leynintsicpa contranmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Peru nunanam nerqan: —Cachacätsimaqnï nunam nimashqa: ‘Qopiquita aparcur euquï’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tseno niptinnam tapuyarqan: —¿Pitaq ‘Qopiquita aparcur euquï’ nishoqniqui nunaqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Peru cachacashqa nuna manam musyarqantsu ni pi cachacätsishqantapis, porqui tsetsica nunacuna tsecho captinmi, Jesus tsincarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsepitanam templuchona tse nunata Jesus taririrnin, queno nerqan: —¡Cananqa cachacashqanam canqui yo! Amana yape jutsata ruranquinatsu imapis mas peor mana pasashunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tsenam tse israel autoridacunaman ewar, willacorqan cachacätseqnin nuna Jesus canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tseta jamaqui junaqcho rurecuptinmi, israel autoridacuna Jesusta wanutsita munarnin chiquir qaticachäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Peru Jesusqa pecunata quenomi nerqan: —Papänïqa ime junaqpis uryecanmi. Tsemi cada junaq noqapis uryecä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesus tseno nicuptinnam, tse israel autoridacuna masraq wanutsita tïrayarqan, manam jamaqui junaqcho nunata cachacätsenqanrecurllatsu, sinoqa “Diosmi Papänï” nir, Dios tuconqanrecurmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tsenam Jesus queno nerqan: “Rasontam rasontam niyaq. Diospa Tsurin manam quiquin munashqantatsu ruran, sinoqa Papänin rurashqancunata ricanqantam ruran. Porqui Papänin llapan rurashqancunatam tsurinpis ruranqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Porqui Dios Yayaqa Tsurinta cuyarmi, quiquin llapan ruranqanta ricatsin. Y tsepeq mas alli caqcunataran ricatsenqa. Tseta riquecurmi, qamcuna allapa mantsacäcuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imanomi Dios Yaya wanushqacunata cawariratsir, wiñe cawenin qoycun, tsenollam Tsurinpis munanqan caqcunata wiñe cawenin qoycun. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Manam qamcuna pensayanqequinotsu quiquin Dios Yaya pitapis jusganqa, sinoqa Tsurintam poderta qoshqa nunacunata jusgananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tserecurmi llapan nunacuna Diospa Tsurintapis quiquin Dios Yayatano respetayanqa. Meqan nunapis Diospa Tsurinta mana respetarnenqa, cachamoqnin Dios Yayatapis manam respetayanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Rasontam rasontam niyaq. Pipis willacushqäta wiyacur, cachamaqnï Diosman marcäcorqa, wiñe caweyoqnam ticrarishqa, y manam condenasiunman ewanqanatsu. Pecunaqa imeca wanushqanpita cawarishqanonam quecayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rasontam rasontam niyaq. Chäramunnam tiempu y öranam Diospa tsurin parlashqanta wanushqacuna wiyayänan, y wiyacoqcunana wiñepa cawayänan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Imanomi Dios Yaya puedeq queninwan imatapis cawatsin, tsenollam dispunishqa Tsurinpis puedeq queninwan llapanta cawatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tsenollam podernin qoshqa llapan nunacunata jusgananpaq, porqui pëqa Diospita Shamushqa Nunam. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tse nishqäcunata ama espantacuyëtsu, porqui chämonqam junaqcuna parlashqäcunata wanushqacuna wiyarirnin, ");
INSERT INTO qwhNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","cawariyämunan. Tsenam que patsacho cawecar, alli ruraq caqcuna wiñepaq cawayanqa; peru mana alli ruraq caqcunanam, cawariyämonqa condenadu cayänanllapaqna. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Noqaqa manam quiquï munashqätatsu rurä. Dios Yayä nenqannollam jusgashaq. Tsemi noqaqa jusgashaq nunacunata rurenincunamanno, porqui cachamaqnï Dios Yaya munashqantam rurä, manam quiquïpa munenïtatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sitsun quiquïpa fabornïlla willacushaq, tse willaconqä manam ni imapaq sirwinmantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jucmi noqapa fabornïqa willacushqa, y noqa musyämi pe willacushqanqa noqapaq rasonpa cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Qamcunam nunacunata cachayarqequi Juanman tapucoq, y pepis rason caqllatam noqapaq niyäshorqequi. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tseno quecaptinpis, noqaqa manam wanä fabornï nunacuna willacuyänantaraqtsu. Tsetaqa yarparatsiyaq salbacuyänequipaq ˻Juanpis willayäshushqa cayäshuptiquim˼. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanqa imeca actsi rupecaq cuentam carqan, y willaconqanta wiyarirmi, juc ratulla shonqiquicuna atsicyärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Peru Juan willacushqanpitapis mas mejorcunaran can noqa pi canqätapis cäyitsiyäshoqniqui. Tseqa Dios Yaya mandamashqan milagrucunata ruranqämi. Tse milagrucunam musyatsiyäshunqui Dios Yaya rasonpa cachamashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y cachamaqnï Dios Yayapis noqapaqmi cäyitsiyäshunqui, peru pe cäyitsiyäshuptiquipis, manam cäsuyanquitsu, pe imano canqantapis mana musyarnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ni willaquinintapis manam wiyeta munayanquitsu, porqui manam creyiyämanquitsu Dios Yayä cachamanqanta ");
INSERT INTO qwhNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Qamcunam Diospa palabranta allapa leyiyanqui, ‘Tsenopam wiñe cawetaqa tarishun’ nishpa. Peru tsechoqa noqallapaqmi willacun. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Peru noqata qatimarnï wiñe caweyoq quetaqa, manam munayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nunacunapita alabashqa quetatsu manam noqaqa ashï. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Y musyämi Dios Yayäpa cuyaquinin qamcunacho mana canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dios Yayä cachamashqa quecaptinpis, qamcuna manam chasquiyämanquitsu. Peru sitsun pipis quiquinllapeq shamunman, tsetam si cushishqa chasquiriyanquiman. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Qamcunaqa quiquiquicuna purallam alabanaquita ashiyanqui, peru Diosllawan allicho quedetaqa manataq ashiyanquitsu. Tseno quecar, ¿Imanoparaq noqaman marcäcuyanquiman? ");
INSERT INTO qwhNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ama pensayëtsu Dios Yayapa nopancho noqa shimpiyänaqta. Jucmi can shimpiyäshoqniqueqa: tseqa Moisesmi, y pe escribishqan leyman marcäquicayanqequim. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sitsun Moises escribishqancunata cäyiyanquiman, noqamanmi marcäcuyanquiman, porqui pe escribishqancunachoqa noqapaqmi parlecan. ");
INSERT INTO qwhNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Peru Moises escribishqanman mana creyiquicar, ¿imanoparaq parlashqäcunaman creyicuyanquiman?” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsepitanam Galilea Lamarpa wac tsimpanman disipuluncunawan Jesus eucorqan. Tse lamarpa jucnin jutinmi carqan Tiberias. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Qeshyaq nunacunata cachacätsir milagru rurashqanta riquecurmi, atscaq nunacuna Jesusta qatiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tsenam Jesus juc jircaman witsarcur, disipuluncunawan tsecho täcurerqan yachatsicunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israel nunacunapa Pascua fiestancunapaq ichicllanam pishicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesusnam tseman atscaq nunacuna ewaqta riquecur, disipulun Felipita nerqan: —Que nunacuna micuyänanpaq ¿mepitaraq tantata rantishun? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Peru tsenoqa nerqan “Mä, ¿Imash nenqa?” nirmi, porqui Jesusqa musyarqannam imano ruranantapis. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipinam nerqan: —Juc nuna puwaq quilla uryapucur gananqan qellewan tantata rantirninpis, manachi tincutsishwantsu cada unu ichic ichic llamiriyänanllapaqpis —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsenam disipulun Andres, Simon Pedrupa wauqin, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Quechomi juc wamrapa capun pitsqa tantan sebadapeq y ishque ichic ichic pescadun; ¿Peru imatam que tsicaqpaq tinconqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tsenam disipuluncunata Jesus nerqan: —Que nunacunata tätsiyë —nir. Tse quecayanqanchoqa carqan atsca tsampam, tsemanmi jamacuriyarqan. Pitsqa waranqanomi (5,000) ollqucunalla cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesusnam tse tantata tsarircur, Diosta “Grasias” nicurir, disipuluncunata qorqan. Y pecunanam tse jamecaqcunata qarayarqan. Tsenollam pescadutapis qararqan. Teqñayanqanyaqmi micuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tecñaq micuriyaptinnam, disipuluncunata Jesus queno nerqan: —Catuyanqan paquipi tantacunata elluyë mana ujunanpaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pitsqa sebada tantallapitam tselaya miquicayaptinpis, paquipicunata elluriyarqan chunca ishque (12) canasta juntata. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nunacunanam Jesus tse milagru rurashqanta riquecur, queno niyarqan: —¡Que nunaqa rasonpam que patsaman shamunanpaq caq profeta! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesusqa musyarerqanmi nunacuna reynincuna cananpaq malas chureta munayanqanta. Tsemi jircacunapa yape cuticorqan japallan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tardiyäriptinnam, Jesuspa disipuluncuna lamarman uräyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lanchaman lloqacurcurnam, wac tsimpa Capernaum marcaman eucuyarqan. Tse öraqa paqasnam carqan, y Jesusqa manam pecunaman shamorqanraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tseno euquicayaptinmi, feyupa bientuptin, lamar laqcheqsar qallaquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pitsqa quilometrutano ewecarninnam, Jesusta riquecuyarqan yacu jananpa ewar pecunaman yecurëcaqta. Tsenam mana reqirnin, mantsaquecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesusnam nerqan: —¡Noqam cä. Ama mantsacäyëtsu! ");
INSERT INTO qwhNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsenam lanchaman cushishqa lloqaratsiyarqan; y rasmi ewecayanqanman chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Waräninnam, lamarpa wac tsimpancho dejayanqan nunacunaqa cuentata qocuriyarqan tse jucllella lanchawan disipuluncunalla eucuyanqanta, y Jesusqa tse lanchaman mana lloqanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tseno quecayaptinnam, Tiberias marcapita waquin lanchacunana chäriyarqan. Tsaq tsechomi Diosta grasias nicurir, nunacunata Teyta Jesus tantancuna qarashqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y tsecho Jesusta ni disipuluncunata mana tarirmi, tse lanchacunaman lloqarcur, nunacuna Capernaum marcaman eucuyarqan Jesusta asheq. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lamarpa wac tsimpanman chärirnam, Jesusta tsecho taririr, espantacur queno niyarqan: —Mayestru ¿Imetaq queman chämorqonqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tsenam Jesus nerqan: —Rasontam rasontam niyaq. Manam milagrucuna rurashqäta ricayanqequirecurtsu qatiräyämanqui; sinoqa pacha junta micutsiyanqaqrecurllam, canan ashiyämanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama yarpacachäyëtsu pacha miquillapaqqa. Tse miqueqa ushacaqllam. Antis, yarpacachäyë wiñe caweman chätsicoq caq miquipaq. Tsetam Diospita Shamushqa Nuna qoyäshunqui, peta Dios Yaya acrashqa captin —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nunacunanam niyarqan: —¿Imacunatataq tsepenqa Dios munan rurayänäta? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tsenam Jesus queno nerqan: —Diosqa munan cachamushqanman creyicuyänequitam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tseno niptinnam, nunacuna tapuyarqan: —¿Ima milagrutataq ruraramunqui tseta ricarnin noqacuna qamman creyicayämunäpaq? ¿Mä, Imallatapis ruraramï? ");
INSERT INTO qwhNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tsunyaqcho quecarmi, une castantsiccuna ‘Manä’ nishqan tantata micuyarqan. Tsemi Diospa palabran queno escribirëcan: ‘Sielupita tantatam nunacunata qararqan’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tsenam Jesus nerqan: —Rasontam rasontam niyaq: Manam Moisestsu sielupita tantata qoyäshorqequi, sinoqa Dios Yayämi rason caq tantataqa sielupita cachamun. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dios cachamushqan tantaqa sielupita shamushqa carmi, jinantin patsacho nunacunata cawatsenqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nunacunaman niyarqan: —Tëte, cananpita witsepana tse tantalläcuna qarecalläyämë —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesusnam nerqan: —Noqam tse cawatsicoq tantaqa cä. Noqaman shamoq caqqa manam imepis mallaqanqatsu, y noqaman marcäcoq caqqa manam ni imepis yacunanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Peru niyashqaqnollam rurashqäcunata riquecarninpis, noqaman creyiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dios Yaya qomashqancunaqa pi mepis noqamanmi shayämun y noqaman shamoqcunataqa manam qarqushaqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porqui noqaqa que patsaman shamushqa cä manam quiquï munashqäcunata ruranäpaqtsu, sinoqa cachamaq Papänïpa muneninta ruranäpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cachamaqnïqa manam munantsu qomashqan nunacuna ni jucllellapis infiernuman ewayänanta. Antis pëqa munan juisiu junaqcho llapan qomanqan caqcunata cawaritsimunätam. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Y Papänïqa munan tsurin canqäta cuentata qocur, noqaman marcäcur, wiñepa cawayänantam. Pecunatanam juisiu junaqcho cawariratsimushaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Noqaqa sielupita shamushqa tantam cä” nishqa, captinmi, Jesusta israel autoridacuna, pacallapa pepa contran parlar, ");
INSERT INTO qwhNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","queno niyarqan: —¡Que Jesusqa Josepa tsurintaq! ¡Papäninta mamäninta reqintsictaq! ¿Imanirmi ‘Sielupitam shamushqa cä’ nimantsic! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tseno niyaptinnam, Jesus nerqan: —Ama tseno niyanqaqrecur pacallapa conträ parlayëtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cachamaq Dios Yaya nunacunata shonquncunacho mana cäyitsiptenqa, manam ni pipis noqaman shamunmantsu; y noqam juisiu junaqcho pecunata cawaritsimushaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Une profetacunam queno escribiyarqan: ‘Diosmi llapancunata yachatsenqa’ nir. Tsemi pipis Dios Yaya parlashqanta wiyar yachacorqa, noqaman creyicuyan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Manam pipis Dios Yayata ricashqatsu, sinoqa Diospita Shamushqa Nunallam ricashqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rasontam rasontam niyaq. Noqaman marcäcoqcunaqa wiñe cawayoqmi quecayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Noqaqa cawatsicoq tantam cä. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Une castequicunam tsunyaqcho quecar, ‘Manä’ nishqan tantata micuyarqan. Tse tanta micurninpis, tse tsunyaqllachomi wanuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Peru cananqa sielupita shamoq tantapaqmi noqa willecayaq. Tse tanta micoq caqqa manam wiñepatsu wanonqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Noqam sielupita shamoq tse cawecaq tanta cä. Sitsun que tantata pipis miconqa, wiñepam cawanqa. Tse tantaqa quiquïpa etsämi. Y jinantin patsacho nunacuna wiñepa cawayänanpaqmi etsäta entregashaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesus tseno niptinnam, tse israel autoridacuna piñacurcur, quiquincuna pura queno ninacuyarqan: —¿Imanoraq que nuna etsanta micutsimäshun! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tsenam Jesus nerqan: —Cäyiyämë. Rasontam rasontam niyaq. Diospita Shamushqa Nunapa etsanta mana micorqa y yawarninta mana uporqa, manam wiñe caweta tariyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Etsä micoq caqqa y yawarnï upoq caqqa wiñepam cawanqa. Tse nunataqa juisiu junaqchomi cawaritsimushaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porqui noqapa etsämi rasonpa micunaqa, y yawarnïmi rasonpa upunaqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Noqapa etsä micoqqa y yawarnï upoqqa, noqawanmi jucnolla canqa y noqapis pewanmi jucnolla cashaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Noqaqa cawä wiñe caweyoq cachamaq Dios Yayarecurmi, tsenollam noqapa etsä micoq caqqa noqarecur cawayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Noqaqa sielupita shamoq rasonpa caq tantam cä. Une castequicunam ‘Manä’ nishqan tantata micur wanuyarqan, peru que tantata micoq caqqa wiñepam cawanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Quecunatam Jesus nerqan Capernaum marcapa ellucayänan wayincho yachatsicurnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesus tseno yachatsicushqanta wiyarirnam, tse atscaq qatiraqnincuna niyarqan: —Que yachatsiconqanqa allapa sasataq. ¿Piraq tseta wiyarpis cäyinman! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Qatiraqnincuna tseno nir piñashqano cayanqanta musyarirnam, Jesus nerqan: —¿Tseta niyanqaqrecurcu piñacurcuyanqui? ");
INSERT INTO qwhNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Y Diospita Shamushqa Nuna nopa canqanman cuticoqta ricarninnäqa, ¿imaraq niyanquiman? ");
INSERT INTO qwhNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diospa Espiritunmi nunataqa cawatsin. Etsanllapitaqa manam nuna cawantsu. Que nicayanqaqqa almequicunapaqmi y wiñe caweyoq cayänequipaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Peru waquinniquicunaqa que niyanqaqta manam creyiyämanquitsu —nir. Tseno nerqan Jesus qallananpita patsa waquin qatiraqnincuna peman mana creyicuyanqanta musyarninmi, y meqan caq traisionananta musyarninmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tsepitanam Jesus nerqan: —Tsemi waquinniqui mana creyiyämaptiqui, niyarqoq, ‘Manam pipis noqaman shamunmantsu, Dios Yaya shonquncunacho mana cäyitsiptenqa’ —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tse junaqpitam atscaq qatiraqnincuna Jesusta jaqiricur eucuyarqan. Pewan mananam puriyarqannatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tsenam tse chunca ishque (12) disipuluncunata Jesus nerqan: —¿Qamcunapis jaqirayämanquicu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tsenam Simon nishqan Pedru queno nerqan: —Teyta, ¿pimanraq ewallayäshaq? ¡Qamllataq parlanqui wiñe cawaquipaq! ");
INSERT INTO qwhNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noqalläcunaqa qamllamanmi marcäculläyä. Y musyayämi Dios Acrashqan canqequita —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesusnam nerqan: —Qamcunatam chunca ishcaqta (12) acrashqa cayaq disipulücuna cayänequipaq, y tsepita jucniquim quecan diablu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judaspaqmi Jesus tseno nerqan. Judasqa Simon Iscariotipa tsurinmi carqan. Pëqa chunca ishque (12) disipulunpita quecarninpis, traisionananpaqnam quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tsepitanam jinantin Galilea probinsiapa Jesus purerqan. Israel autoridacuna wanutsita munayaptinmi, Judea probinsiamanqa ewarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Israel nunacuna “rämada” niyashqan fiestancunata selebrayänanpaq ichicllana pishicaptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesusta wauqincuna queno niyarqan: —Quellachoqa ama caquïtsu. Judea probinsiamanpis ewecur milagruta rurë tsechopis qatiräshoqniquicuna ricayänanpaq; ");
INSERT INTO qwhNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","porqui pipis alli reqishqa queta munarqa, manam pacallapaqa imatapis rurantsu. Yäquinachi quecunata ruranqui; llapan nunacuna ricarëcayäshuptiqui jucllana rurequï —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tsenomi wauqincunapis niyarqan, Jesusman mana creyicur. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsenam Jesus nerqan: —Manaran tseman ewanäpaq öraraqtsu. Peru qamcuna ewayänequipaqqa ime örapis allim. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Qamcunataqa nunacuna manam chiquiyäshunquitsu, peru noqataqa chiquiyäman, mana alli ruraq cayanqanta niptïmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tse fiestaman qamcuna ewayë. Noqaqa manaran ewätsu, porqui manam orä chämunraqtsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tseno nirmi, Galileacho quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Peru wauqincuna tse fiestaman jeqariyaptinnam, mana pipis reqiyänanpaq, rataquillapa Jesuspis ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiestachonam tsecho autoridacuna Jesusta ashiyarqan: —¿Mechoraq tse nuna quecan? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y tsecho atscaq nunacunanam quiquincuna pura Jesuspaq parlarnin, queno niyarqan: “Pëqa alli nunam” nir. Peru waquincunanam niyarqan: “Manam allitsu. Nunacunatam ulipan” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tsecho autoridacunata mantsarninmi, nunacuna pacallapa tseno parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Selebrecayanqan fiesta pullancho quecaptinnam, templuman Jesus witsarqan nunacunata yachatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yachatsiconqanta wiyarninnam, tse autoridacuna espantacur queno niyarqan: —¿Imanoparaq quelaya yachecun, mana estudiashqa quecar? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tsenam Jesus nerqan: —Manam quiquï munanqäcunatatsu yachatsicü, sinoqa cachamaqnï parlashqancunatam. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Diospa boluntaninta rure munaq caqqa cuentatam qocurenqa yachatsicushqäcuna Diospita shamushqanta y mana quiquïllapita canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sitsun pipis quiquinpa muneninllata yachatsiconqa, tse nunaqa munanqa quiquinta alabayänantam. Peru cachaqninllata alabayänanta munaq caqqa rasonpa caqta parlaqmi, y manam pëchoqa ni ima uliqui cantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Qamcunatam Moises qoyäshorqequi leyta. Y tseno quecaptinpis, manam ni meqequi tse leyta cumpliyanquitsu. ¡Y jananmanpis, wanutsiyämetaran munayanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jesus tseno niptinnam, tse nunacuna queno niyarqan: —¿Pitaq wanutsishiniquita munan? Supëmi qamchoqa yachan —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusnam nerqan: —Claru parlaquichoqa, jucta rureconqämi qamcunata mantsacätsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Masqui yarpäyë: Moisesmi mandayäshorqequi señalacuyänequipaqqa y qamcunanam ollqu wamrata señalayanqui jamaqui junaq quecaptinpis. Tse costumbreqa une awiliquicunapita patsam, manam Moisespitaraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Si qamcuna, tse mandamientuta cumplita munarnin, jamaqui junaqchopis llullu wamrata señalayanqui, ¿imanirtaq noqapita piñacurcuyanqui, qeshyaq nunata jamaqui junaqcho cachacäratsiptï? ");
INSERT INTO qwhNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ama manaraq alli aberwashpa acusayämëtsu, antis alli cuentata qocuricur imatapis cabeqman jusgayë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tsenam Jerusalencho täraq waquin nunacuna tapunacur, queno ninacuyarqan: —¿Manacu que nunaqa wanutsiyänanpaq ashicayanqan nuna? ");
INSERT INTO qwhNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Cananqa mana mantsacushpataq llapan nunacunata yachatsin, y manataq ni pi ima nintsu! ¡Rasonpa Dios Acrashqan canqantatsuraq autoridanintsiccuna musyariyashqa! ");
INSERT INTO qwhNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Peru noqantsicqa que Jesus me marcapita canqantapis musyantsicmi. Rasonpa Dios Acrashqan captenqa, manam ni pi musyanmantsu mepita canqantapis —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tseta wiyecurnam, templucho yachatsiquicarnin fuertipa Jesus queno nïcorqan: —¡Tsepenqa qamcuna reqiyämanquichi, y me nuna cashqätapis musyayanquichi! Manam noqaqa quiquïpa munenïpitatsu que patsaman shamorqö, sinoqa rasonpa caqta parlacoq Diosmi noqataqa cachamashqa. Peru petaqa manam qamcuna reqiyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noqaqa peta reqïmi, pepita shamushqa car. Y pemi cachamashqa que patsaman shamunäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesus tseno niptinnam, munayarqan presu tsarita. Peru öran manaraq chaptinmi, mana ni pi almitiyarqantsu tsarita. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tsenam tsecho atscaq nunacuna Jesusman creyicur, queno niyarqan: —Dios Acrashqan shamorqa, ¡mananachi que nunapita mas milagrucunata ruranmannatsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nunacuna tseno niyashqanta fariseucuna wiyarirninnam, mandacoq caq saserdoticuna y fariseucuna templupa wardiancunata cachayarqan Jesusta presuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tsenam Jesus queno nerqan: —Ichicllanam qamcunawan carishaq. Tsepitanam cachamaqnïman cuticushaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ashiyämanquim, peru manam tariyämanquitsu; y noqa canqämanqa manam shamita puediyanquitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tseno niptinnam, tse autoridacuna tapunacur queno ninacuyarqan: —¿Metaraq ewanqa mana tarinantsicpaq? ¿Mana Israel caq marcancunacho täraq marca mayintsiccunamantsuraq ewanqa tse mana israel caqcunata yachatsinanpaq? ");
INSERT INTO qwhNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Ashiyämarninpis, manam tariyämanquitsu, y noqa canqämanqa manam chäyämunquitsu’ nintaq. ¿Ima ninantaraq tseno nimantsic? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tse fiestapa ushanan junaqmi mas somätsishqa carqan. Tse junaqchonam Jesus sharcur, fuertipa queno nerqan: —Pipis yacunarqa, noqaman shamutsun yacu upoq. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Diospa palabran nenqannomi, noqaman marcäcoq shonqunpitaqa, imeca mayunoraq cawatsicoq yacu yarqunqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tsetaqa Jesus nerqan Santu Espirituta peman creyicoqcuna chasquiyänanpaqmi, porqui sieluman Jesus manaraq cutirninmi, creyicoqcunaman Santu Espiritunta cachamorqanraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus tseno nenqanta wiyarirnam, nunacuna queno niyarqan: —¡Que nunaqa rasonpam shuyaconqantsic profeta! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquincunanam niyarqan: —Queqa Dios Acrashqanmi —nir. Peru waquincunanam niyarqan: —¡Galilea marcapitaqa manachi Dios Acrashqan canmantsu! ");
INSERT INTO qwhNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Manacu Diospa palabran escribirëcan Dios Acrashqanqa Davidpa castanmi canqa, y pepa marcan Belenpitam canqa! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Perecurmi nunacuna mana acuerdu carnin, ishqueman raquicacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tsemi waquincuna munayarqan presu apaquita, peru manam ni meqanpis almitiyarqantsu tsarita. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsepitanam templupa wardiancunaqa mandacoq caq saserdoticunaman y fariseucunaman cutiriyarqan. Pecunanam tapuyarqan: —¿Imanirtaq apayämorqonquitsu? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wardiacunanam niyarqan: —¡Manam pipis tse nuna parlanqannoqa parlantsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tsenam fariseucuna niyarqan: —¿Qamcunapis ulicushqanmancu creyicuriyarqonqui? ");
INSERT INTO qwhNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Acasu mandacoqcuna o fariseucuna peman creyiyancu! ");
INSERT INTO qwhNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Upacunallam, leynintsicta mana alli musyar, pemanqa creyir, maldisishqa quecayan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Puntata paqasllapa Jesusman ewaq Nicodemupis tsechomi quecarqan. Pemi queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Manataq Moises escribishqan leynintsiccho nimantsictsu juc nunapa rureninta y parleninta manaraq musyarqa condenanapaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tsenam nicurcuyarqan Nicodemuta: —¿Qampis Galileapeqchi canqui! Masqui Diospa palabranta alleq leyï. Profetaqa manam Galileapeqtsu canqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","˻Tseno nirirnam, cadaunu wayincunaman cuticuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Peru Jesusqa Olibus nishqan jircamanmi eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Waraninam qoya qoyallana cutirerqan templuman. Y tseman nunacuna ellucariyaptinnam, Jesusqa tecur yachatsicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tsemannam ley yachatsicoqcuna y fariseucuna ewayarqan, juc warmita aparcur. Tse warmitash tariyashqa cayänaq jucpa qowanwan punuquicaqta. Tsenam tse warmita chopincunaman shëcatsir, ");
INSERT INTO qwhNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusta niyarqan: —Mayestru, que warmitam tariyarqon jucpa qowanwan punuquicaqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moises escribishqan leychomi mandayäman tseno ruraqcunataqa tsampir wanutsiyänäpaq. Y qamqa ¿imataq ninqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tsenoqa tapuyarqan Jesusta pantatsita munarninmi, llutanta parlecuptenqa, tsepa acusayänanpaq. Peru Jesusqa puctïcurmi allpacho dedunwan escribicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y allapa tapupar acusecuyaptinnam, puctirëcanqanpita ñuquircur nerqan: —Meqequipis mana jutsayoq caq, que warmita puntata qompecuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tseno nirirnam, yape puctircur, allpacho jina escribicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Peru Jesus tseno nïcuptinnam, consensiancuna acusaptin, auquinpita qallecur jucllellapayan ullur ullur eucuyarqan. Eucuyaptinnam, chopincunaman shätsiyanqan warmillawanna Jesus quedarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tsenam Jesus sharcur warmita nerqan: —Mame, ¿metaq acusayäshoqniquicuna! ¿Manacu ni meqan condenayäshorqonqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Warminam nerqan: —Manam, Tëte —nir. Jesusnam nerqan: —Ni noqapis manam condenaqtsu. Canan eucur, amana yapeqa jutsata ruranquinatsu —nir.˼ ");
INSERT INTO qwhNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tsepitanam nunacunata Jesus yape yachatsirnin, nerqan: —Noqaqa actsi cuentam cä nunacunapaq. Noqata qatimaqcunaqa manam paqaschononatsu puriyanqa, sinoqa, actsicho pureqnomi cawayanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tsenam fariseucuna queno niyarqan: —Qamqa quiquiquipa faborniquillam parlanqui. Tsemi nenqequeqa mana ni imapaq balintsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesusnam nerqan: —Quiquïpa fabornïlla parlaptïpis, nishqäqa rason caqmi. Porqui noqa musyämi mepita shamonqäta y meman eucunäta. Peru qamcunaqa manam musyayanquitsu mepita shamushqäta ni meman eucunätapis. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Qamcunaqa quiquiquicunapa yarpeniquicunallapitam jusgayanqui. Noqaqa manam ni pitapis jusgätsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sitsun jusgacüman, noqaqa nunacunapa rureninmannomi jusgaman, porqui noqaqa manam japallätsu jusgä, sinoqa cachamaqnï Dios Yayawanmi jusgayä. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Leyniquicunachomi queno escribirëcan: “Ishcaq testigucuna jucllellata parlayaptenqa, tse parlayashqancuna rasonpa caqmi” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Noqaqa pi canqätapis rason caqllatam willayaq; y cachamaqnï Papänïpis pi canqätam rason caqllata musyatsiyäshunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tsenam niyarqan: —¿Mechotaq papäniqueqa quecan? —nir. Jesusnam nerqan: —Noqata manam reqiyämanquitsu, ni Papänïtapis manam reqiyanquitsu. Sitsun noqata reqiyämanquiman, Papänïtapis reqiyanquimanmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tseno nirmi, Jesus yachatsicorqan templucho, qelle winana cajapa laduncho quecar, y manam ni pi Jesusta presu tsariyarqantsu, öran manaraq chaptin. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tsepitanam Jesus yape queno nerqan: —Noqa eucushaqnam, y ashiyämanquim, peru jutsequicunacho wanucurmi condenadu cayanqui. Y eucushqämanqa manam shamita puediyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tsenam tse autoridacuna quiquincuna pura queno ninacuyarqan: —Eucushqanmanqa manash eweta puedishuntsu. ¿Quiquintsuraq wanutsiquiconqa! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesusnam nerqan: —Qamcuna que patsallapitam cayanqui. Noqaqa sielupitam cä. Qamcunaqa que patsacho caqllapaqmi yarpacachäyanqui, peru noqaqa rara sielupita caqcunapaqmi yarpacachä. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsemi niyarqoq, ‘Jutsequicunachomi wanuyanqui.’ Y rasonpam, Noqa Canqäta mana creyerqa, wanurnin condenadu cayanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsenam niyarqan: —¿Pi canqequitataq qamqa creyicunqui? —nir. Jesusnam nerqan: —Pi canqätapis niyarqoq qallanqäpita patsam. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Noqa jusgueta munayapteqqa atscam can niyänaqpaq. Peru manaran tseno rurashaqraqtsu. Unicoqa rasonpa caq Papänïpita wiyanqällatam nunacunata willarishaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Peru pecuna manam cäyiyarqantsu Dios Yayapaq Jesus tseno parlanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tsemi Jesus nerqan: —Diospita Shamushqa Nunata sharcaratsirran, cuentata qocuriyanqui noqa pi canqäta, y quiquïllapita imatapis mana rurashqäta, sinoqa Dios Yaya yachatsimashqanllata parlashqäta. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cachamaq Papänïqa noqawanmi quecan, y manam japalläta jaqimantsu, porqui pe gustanqantam noqaqa imatapis siempri rurä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesus tsecunata niptinnam, atscaq nunacuna peman creyicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tsenam peman creyicushqa caq autoridacunata Jesus queno nerqan: —Sitsun yachatsicushqäcunata cäsucur siempri cacuyanqui, rasonpa disipulücunam ticrariyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tsenam rason caqta musyariyaptiqui, tse rason caq librariyäshunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pecunanam queno niyarqan: —Noqacunaqa une Abrahampa castancunam cacuyä, y manam imepis ni pipa esclabuntsu cayashqä. ¿Imanirtaq qamqa niyämanqui ‘Librinam cayanqui?’ —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tsenam Jesus queno nerqan: —Rasonpam rasonpam niyaq: Jutsa ruraqcunaqa jutsapa esclabunmi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Papäninpa wayinchoqa tsurinmi mandacur imeyaqpis täran, esclaboqa eucoqllam. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tsemi Diospa Tsurin librayäshuptiqueqa, rasonpa librina ticrariyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Musyämi une Abrahampa castan qamcuna cayanqequita. Tseno quecarpis, yachatsicushqä mana qamcunapaqno captinmi, wanutsiyämeta munayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noqaqa Dios Yayapa nopancho yachacushqäcunatam willayaq. Tsenollam qamcunapis Tëtequicunapita wiyayashqequillata rurayanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jesus tseno niptinnam, pecuna niyarqan: —Une Abrahammi noqacunapa tetäcunaqa —nir. Jesusnam nerqan: —Abrahampa willcancuna carnenqa, pe portaconqannomi portacuyanquiman. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Peru qamcunaqa wanutsiyämetam munayanqui, Diospita wiyashqä rason caqta willayapteqpis. Abrahamqa manam imepis tseno mana allita rurarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tëtequicuna rurashqancunatam qamcunaqa rurayanqui —nir. Tsenam pecuna niyarqan: —Noqacunaqa manam jitapuqui wamracunanotsu cayä. Noqacunapa Tetäcunaqa japallan Diosmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tsenam Jesus nerqan: —Dios tëtequicuna captenqa, noqatam cuyayämanquiman; porqui noqaqa Diospita shamushqa carmi, que patsacho quecä. Manam quiquïpa munenïllapitatsu shamorqö, sinoqa Diosmi cachamashqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imanirtan parlashqäcunata cäyiyanquitsu? Cäyiyanquitsoqa, yachatsicushqäta mana wiyarmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Qamcunapa tëtequicunaqa diablum. Pepa carmi, gustunta ruraquicayanqui. Unepita patsam diabloqa asesinu carqan. Mana rasonpa caqcuna gustaptinmi, pëchoqa ni ima rasonpa caq cantsu. Uliquillata parlarmi, imeca badulaqui nunano quecan. Pëqa allapa ulim; tsemi nunacunatapis ulicatsin. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tsemi noqataqa rasonpa caqta parlaptïpis, creyiyämanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Meqequicunapis noqa jutsa ruraq canqäta, mä nïcayämë? Rasonpa caqta parlecaptï, ¿Imanirtaq creyiyämanquitsu? ");
INSERT INTO qwhNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diospa caqcunaqa wiyacuyan Dios parlashqantam; peru qamcunaqa manam wiyacuyanquitsu, porqui manam Diospatsu cayanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tsenam tse autoridacuna queno niyarqan: —Qamqa samaria nunam canqui. Rasontam supëmi qamchoqa yachan niyarqoq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusnam nerqan: —Manam supëyoqtsu cä. Antis noqaqa Papänïta respetarmi, presisaqpaq churä; peru qamcunaqa noqata manam respetayämanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Manam quiquïqa ashïtsu nunacuna alabayämänanta. Jucmi munan noqata alabayämänantaqa. Tseqa rasonpa caq jusgacoqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rasontam rasontam niyaq: Yachatsicushqäta wiyacur cäsucoq caqqa, mananam imepis wanonqatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tsenam tse autoridacuna queno niyarqan: —¡Ä ya, cananmi si cuentata qocuriyä supëyoq caquicanqequita! Tëta Abrahampis y une profetacunapis llapanmi wanuyarqan. ¿Imanopataq qamqa ninqui ‘Yachatsicushqäta wiyar cäsucoq caqqa, manam imepis wanonqatsu!’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Acasu une tëta Abrahampeq mas puedeqcu qam canqui! Pëqa wanushqam, y profetacunapis llapanmi wanuyashqa. ¿Qamqa pi canqequitataq creyicunqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesusnam nerqan: —Quiquilla puedeq cashqäta alabacuptïqa, manam ni imapaqpis balinmantsu. Noqapaqqa Papänïmi puedeq cashqäta musyatsicun. Pepaqmi qamcuna ‘Diosnïmi’ niyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Qamcunaqa manam peta reqiyanquitsu, peru noqaqa reqïmi. ‘Manam reqïtsu’ niyarniqueqa, qamcunano ulichi cäman; peru noqaqa reqïmi, y parlashqantam cäsucü. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Une tëtequicuna Abrahammi cushicorqan, que patsaman shamunäta musyarnin. Y shamuptïnäqa, masran cushicorqan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tsenam tse autoridacuna queno niyarqan: —Qamqa manaran pitsqa chunca (50) watayoqraqpistsu canqui. ¿Imanopataq tëta Abrahamta reqinquiman carqan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesusnam nerqan: —Rasontam rasontam niyaq: Noqaqa Abrahampis manaraq captinmi quecarqäna. ");
INSERT INTO qwhNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tseno nicuptinnam, piñacurcur Jesusta wanutsita munarnin, rumicunata tsariyarqan, peru Jesusqa tsincarerqanmi. Tsepitanam templupita yarqurir, eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Callipa pasarëcarnam, yuriquininpita wiscuta Jesus tarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tsenam Jesusta disipuluncuna tapuyarqan: —Mayestru, ¿imanirtan que nuna wiscu yuricushqa? ¿Tëtanpa, mamanpa jutsanrecurcu, o quiquinpa jutsanrecurcu? ");
INSERT INTO qwhNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesusnam nerqan: —Manam quiquinpa ni papäninpa ni mamäninpa jutsanrecurtsu que nuna wiscu yuricushqa, sinoqa Dios allapa puedeq canqanta que nunacho ricatsicunanpaqmi ");
INSERT INTO qwhNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Que patsacho canqäyaqqa junaq cuentachono carmi, cachamaqnïpa muneninta rurashaq. Paqas chäramuptinnam, pipis ima ruretapis puedenqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Que patsacho quecanqäyaqqa llapan nunacunapa actsin cuentam cä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tseno nirirnam, patsaman toqarir, toqaninwan mituta rurarir wiscupa nawinta laqarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tsepitanam nerqan: —Canan ewar Siloe nishqan quitacho paqacaramï —nir. (“Siloe” ninanqa “Cachamushqa” ninanmi.) Tseman ewar paqacurirnam, riquecarna cutirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Marca mayincunanam y wiscu canqanta reqeqnincunanam sanuna quecaqta ricarnin, queno niyarqan: —¿Manacu queqa llimushnata mañacur täcoq nuna? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquincunanam “Aumi, pemi” niyarqan. Juccunanam niyarqan: —Manam petsu. Peru pe ricoqllam —nir. Quiquin nunanam nerqan: —Aumi. Noqam cä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsenam queno tapuyarqan: —¿Imanopataq cananqa ricanquina? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Penam nerqan: —Jesus jutiyoq nunam mituta rurecur, nawïman laqecamorqan. Tsepitanam nimarqan, ‘Siloe quitaman ewecur, paqacuriquï’ nishpa. Ewar paqacuriptïnam, nawillä ricachacaramorqan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nunacunanam queno tapuyarqan: —¿Mechotan tse nunaqa quecan? —nir. Penam nerqan: —Manam musyätsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tsepitanam fariseucunaman tse cachacärishqa wiscuta apacuyarqan, ");
INSERT INTO qwhNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","porqui mituta rurecur wiscuta Jesus cachacätsishqan junaqqa jamaqui junaqmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tsenam fariseucuna yape tapuyarqan imanopa cachacashqa canqanta. Nunanam queno nerqan: —Jesusmi mituta nawiman laqecamorqan. Paqacuriptïnam, nawï ricachacaramorqan —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tsenam waquin fariseucuna niyarqan: —Tse cachacätsishoqniqui nunaqa manam Diospitatsu canman; porqui Diospita carnenqa, jamacunantsic junaqtam respetanman —nir. Peru waquincunanam queno niyarqan: —Jutsasapa nuna carnenqa, ¿imanopam tseno milagrucunata ruranman? —nir. Tseno ninacurmi, quiquincuna pura mana acuerdutsu cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Y yapenam tse nunata queno tapuyarqan: —Qamqa, ¿imataq ninqui nawiquita cachacätsimoqpaq? —nir. Nunanam nerqan: —Tse nunaqa profetam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tse autoridacuna manam creyiyarqantsu tse nuna wiscu cashqanta y cachacashqana canqanta asta tëtanta mamanta qayatsiyanqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chäriyaptinnam, queno tapuyarqan: —¿Que nuna wamrequicunacu? ¿Rasonpacu wiscu yuricorqan? ¿Y cananqa imanopataq rican? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tsenam tëtan y mamänin niyarqan: —Aumi. Noqacunapa wamräcunam. Wiscum yurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Peru cananqa ¿imanoparaq nawinlläcuna rican? Manam noqacunapis musyayätsu piraq cachacätsicushqa. Quiquinta tapulläyë; pëqa poqushqa nunanam. Quiquin willayäshï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tse autoridacunata mantsarninmi tsenolla niyarqan, porqui puntatam tse autoridacuna queno acuerduta rurashqa cayarqan “ ‘Jesusta Dios Acrashqanmi’ neqtaqa pitapis ellucanantsic wayipitam qarqurishun” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tseno captinmi, tse cachacashqa nunapa papänin mamänin queno niyashqa cayarqan, “Poqu nunanam; quiquinta tapulläyë” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tsenam tse wiscu queninpita cachacashqa nunata yape qayarir, queno niyarqan: —¡Diospaqrecur rason caqta willaquï! Noqacunam musyayä tse nunaqa jutsasapa canqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nunanam nerqan: —¿Jutsasapatsuraq o manatsuraq? Manam musyätsu, peru imallatam musyäqa wiscu quenïpita cachacätsimashqanllatam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tseno niptinnam, “¿Imatataq Jesus rurashorqonqui nawiqui cachacänanpaq?” nir, yape tapuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Penam queno nerqan: —Willayarqoqnam, peru manam cäsuyämarqonquitsu. ¿Imanirtaq yapecuryan tapupäyämanqui, o qamcunapis pepa disipuluncuna quetacu munayanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tseno niptinnam, fariseucuna insultar niyarqan: —¡Qamchi pepa disipulonqa canqui! ¡Noqacunaqa Moisespa disipuluncunam cacuyä! ");
INSERT INTO qwhNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Noqacunaqa musyayämi Moisesta Dios parlapashqanta. Tse nunaqa ¿piraq cacunpis? Manam musyayäpistsu mepita shamushqantapis —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tsenam queno nerqan: —Espantacullämi me nuna canqantapis mana musyayanqequita, peru noqallätaqa pemi ricachacaratsimarqon. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","¡Musyantsictaq jutsasapacunataqa Dios mana wiyanqanta! Mandacushqancunata ruraqcunallatam y cuyar adoraqnincunallatam Diosqa wiyan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manam ni imepis wiyashqatsu cantsic noqallätano wiscu yuricushqa nunata pipis cachacätsishqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Diospita shamushqa mana carqa, manam quecunata rureta puedinmantsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tse nishqanta wiyecurnam, queno nicurcuyarqan: —¡Qamqa yuriquiniquipita patsam jutsasapa canqui! Tseno quecar, ¿imanopam noqacunata yachatsiyämanqui! —nir. Tsenomi ellucayänan wayipita qarquriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tse nunata qarquyashqanta Jesus musyarerqanmi. Y pewan toparirmi, queno nerqan: —¿Diospita Shamushqa Nunaman marcäcunquicu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nunanam nerqan: —Tëte, ¿pitan tse nunaqa peman marcäcullänäpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusnam nerqan: —Peta ricashqanam canqui; noqam cä, canan qamwan parlecaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nunanam Jesuspa nopanman qonquriquicur, nerqan: —Teyta, qamman creyicüllämi —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesusnam nerqan: —Noqam que patsaman shamushqa cä nunacunata jusganäpaq. Noqarecurmi, wiscu cuenta quecaqcuna cäyicuyanqa, peru yachaq tucoqcunanam wiscu cuenta ticrariyanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tsecho pewan quecayaq fariseucunanam Jesus nishqanta wiyarir, queno niyarqan: —¿Qamqa pensanqui noqacuna wiscu cuenta cayanqätacu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesusnam nerqan: —Sitsun wiscu cuenta cayanquiman, manam jutsequicunapita culpayoqtsu cayanquiman; peru noqacunaqa manam wiscunotsu cayä niyanqequirecurmi, jutsequicunapita culpayoq caquicayanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Rasontam rasontam niyaq: Üshacunapa canchanman pipis puncunpa mana yecur, ladupa yecoqqa suwam y ranchadormi. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Peru puncunpa yecoqqa üshacunapa mitseqninmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mitseq yecunanpaqmi puncuta quichan täpacoq. Tse mitseqnin parlaptinmi, üshancunapis reqiyan; y üshancunata jucllellapayan jutinpa jutinpa qayarmi, canchanpita jorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Llapan üshancunata jorqurirnam, üshancunapa puntancunata ewan. Parlashqanta wiyarninmi, üshancuna qatiyan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Peru mana reqishqan nunataqa manam nunca qatiyantsu. Antis mantsacarmi, coricuyan; porqui manam reqiyantsu tse nunapa shiminta” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tseno nirmi, Jesus iwalatsiquipa yachatsicorqan. Peru pecuna manam cäyiyarqantsu tse yachatsicushqan ima ninan canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tsemi yape yachatsicurnin, Jesus nerqan: “Rasontam rasontam niyaq: Noqaqa üshacunapa canchanman yecuna puncu cuentam cä. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Manaraq noqa shamuptï punta shamoqcunaqa llapanpis suwan y ranchadormi cayarqan; y manam parlayashqantapis üshacuna wiyayarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Noqaqa imeca canchaman yecuna puncu cuentam cä; y pipis tse puncupa yecorqa salbaconqam. Y yecurnin yarqurirninpis, alli pastuta üshacuna tareq cuentam canqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Suwacoqqa shamurmi, üshacunata apacurnin wanutsir ushacäratsin; peru noqaqa shamushqä nunacunata wiñepa cawatseqmi. Tsemi imepis Diosta cäsucur, cushi cushina cawayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Alli caq mitseq cuentam noqaqa cä. Y alli mitseqqa üshancunarecorqa wanurpis wanurinmanmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Peru qellellapaq mitsipäcoqqa mana quiquinpa üshan captinmi, atoq shamoqta riquecurnin, üshacunata dejarïcur ewacun. Atoqnam üshacunaman chëcur tsarita munar, witsicacharcun. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tse nunaqa qellellapaq mitsipäcushqa carmi, üshacunapaq mana imapis qocushpa jaqiricur ewacun. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Alli mitseq cuentam noqaqa cä. Imanomi Papänï noqata reqiman y noqapis Papänïta reqï, tsenollam noqapis üshäcunata reqï; y pecunapis noqapa carmi, reqiyäman. Üshäcunarecurmi noqaqa wanushaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mas üshäcunapis capamanmi manaraq que canchaman ellucayämushqacuna; presisanmi pecunatapis pushamunä. Parlashqäcunata cäyiyanqam. Tsenam juc canchallachona cayanqa; noqallam mitseqnincuna cashaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nunacunapaqrecurmi noqa wanushaq y cawarimushaq. Tserecurmi Dios Yaya cuyaman. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Quiquï munaptïmi, wanutsiyämanqa, manam pecuna munarnintsu. Munarinällam wanïpis, y munarinällam cawarimipis. Tseno cananpaqmi Papänï mandamashqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesus tseno niptinnam, tse autoridacuna mana acuerdu carnin, yape quiquincuna pura ishqueman raquicacuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Atscaqmi queno niyarqan: —¿Imapaqnataq parlanqantapis wiyayanqui? Pëqa supëpa munenincho carmi, pasepa locuyäcurishqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waquincunanam niyarqan: —Supëyoq carqa, manam tseno yachatsicunmantsu. ¿Acasu wiscucunapa nawinta supë cachacätsinmancu? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalen marcachomi selebrecayarqan Templupa aniversariun fiestata. Tseqa tamya tiempuchomi quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tsechonam templupa Salomon nishqan coredornincho Jesus puricarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tsenam autoridacuna Jesusman jiruroq ellucarir, queno niyarqan: —¿Imecamayaqtaq que yarpacachëllacho catsiyämanqui? Qam Dios Acrashqan carnenqa, mä canan claru willecayämë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesusnam nerqan: —Willayashqanam cayaq, peru qamcuna manam creyiyämarqonquitsu. Papänïpa poderninwan milagrucunata ruranqämi musyatsiyäshunqui noqa pi canqäta. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Peru qamcunaqa manam creyiyämanquitsu, porqui manam üshäcunatsu cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Parlanqätam üshäcunaqa wiyayan. Pecunatam noqa reqï, y pecunam noqata qatiyäman. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Noqaqa wiñe cawaquitam qoshaq, y manam imepis jipaquiman ewayanqatsu, y manam ni pi podernïpita qochimanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nunacunata qomaq Papänïqa llapanpitapis mas puedeqmi. Y Papänïpa poderninpita manam ni pi qochita puedenqanatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Dios Yaya y noqa jucllellam cayä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tseno nicuptinnam, tse autoridacuna rumita yape tsariyarqan Jesusta qompar wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tsenam Jesus nerqan: —Papänïpa poderninwanmi nopequicunacho atsca shumaq milagrucunäta noqa rurashqa cä. ¿Meqan milagru ruranqäpitataq canan qamcuna qompayämanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pecunanam niyarqan: —Manam ni meqan shumaq milagru rurashqequipitatsu qompayashqequi; sinoqa Diospa contran parlaptiquim, porqui qamqa nunalla quecarmi, ¡Dios tucunqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesusnam nerqan: —Leyniquicunachomi queno escribirëcan: ‘Noqam nerqä qamcunaqa dioscunam cayanqui’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","(Diospa palabranqa rasonpa carmi siempri cumplicanqa.) Si tsepin palabranta chasquicoqcunata Dios nerqan ‘dioscunam cayanqui’ nishpa, ");
INSERT INTO qwhNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","qamcunaqa, ¿imanirtaq Dios acramar que patsaman cachamashqa quecaptin ‘Diospa tsurinmi cä’ niyapteq, ‘Diospa contranmi parlecan’ niyämanqui? ");
INSERT INTO qwhNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Papänï mandamashqancunata mana ruraptïqa, amapis creyiyämëtsu, ");
INSERT INTO qwhNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","peru pe mandamashqancunatam noqa rurecä. Tsemi noqata mana creyiyämarnïpis, milagrucunata rurashqärecur creyicuyë. Tseno creyicurmi, cäyiriyanqui noqacho Dios Yayä canqanta y pëcho noqa canqäta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesus tseno niptinnam, yape presu tsarita munayarqan, peru safarmi pecunapita eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tsepitanam yape Jordan mayupa wac tsimpanman eucorqan. Mas puntatam tsecho nunacunata Juan bautisarqan. Tseman chärirnam, tsecho quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tsemannam atscaq nunacuna ewayarqan, queno ninacur: —Bautisacoq Juanqa manam ni ima milagrucunata rurarqantsu. Peru Jesuspaqqa rasonpa caqtam willacushqa —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y atscaq nunacunam Jesusman creyicuyarqan tsecho. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania marcachomi Lazaru jutiyoq nuna qeshyecarqan. Tse marcachomi Maria y nanan Marta täräyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tse Mariaqa pucutaq perfumiwan Teyta Jesuspa chaquinta llushir aqtsanwan tsaquitseqmi carqan. Tse qeshyecaq Lazaroqa pepa turinmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tsenam tse panincuna juc nunata cachayarqan Jesusman, queno willacoq: —Tëte, cuyanqequi Lazarum lastima qeshyecan —ninanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tseta wiyarninnam, Jesus nerqan: —Tse qeshyawanqa manam wanushqa quedaconqantsu, sinoqa nunacunam Diospa puedeq queninta ricayanqa, y tserecurmi tsurinpa puedeq quenintapis ricayanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusqa allapam cuyarqan Martata, nanan Mariata y turin Lazaruta ");
INSERT INTO qwhNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazaru qeshyecanqanta willecayaptinpis, ishque junaqran tse quecanqancho quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsepitanam disipuluncunata queno nerqan: —Acu, yape cutishun Judea probinsiaman —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Disipuluncunanam niyarqan: —Mayestru, ¡tutellaran tsecho autoridacuna tsampir, wanutsiyäshiniquita munayarqon! ¿Tseno quecaptincu cutita munanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesusnam iwalatsicur nerqan: —¿Manacu juc junaqcho chunca ishque (12) öranpin actsicho cantsic? Y tse actsicho purerqa, manam ishquintsictsu; porqui atsicyaq munducho carmi, llapanta alli ricantsic. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Peru paqaschono pureqcunaqa ishquiyanqam, mana actsichono carnin —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tsecunata nirirnam, queno nerqan: —Amiguntsic Lazaroqa punicanllam, peru ewarmi riyaratsimushaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tsenam disipuluncuna niyarqan: —Punicarllaqa, cachacärenqachi, Tëte —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Peru Jesus nenqanqa Lazaru wanushqanam ninanmi carqan; y disipuluncunaqa Lazaru punur descansecanqanllatam pensayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tsenam alli cäyiyänanpaq Jesus nerqan: —Lazaroqa rasonpam wanushqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y qamcunarecurmi cushicü Lazarupa waninin öra tsecho mana quecanqäta. Cananmi si, noqaman mas marcäcuyanqui. Y canan acu ewashun Lazaru caqman —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tsenam disipulu mayincunata “Millish” niyanqan Tomas queno nerqan: —Acu noqantsicpis ewashun mayestruntsicwan; pewanmi mechopis ushacärishun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Disipulucunawan Jesus chärirnam, musyarerqan Lazaru chuscu junaqna sepulturacho pamparanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalenpita Betaniamanqa quima quilometrunollam. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tsemi Jerusalenpita autoridacuna atscaq ewar, Mariata y Martata turin wanushqanpita shoqar yanaqëcayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus yecurëcanqanta musyarirnam, Marta ewarqan taripaq, peru Mariaqa wayinchomi quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martanam Jesuspa nopanman chärir nerqan: —Teyta, sitsun qam quecho quecanquiman carqan, manam turillä wanunmantsu carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Peru noqa musyämi Diosman imatapis mañacuptiqueqa wiyashonqequita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusnam nerqan: —Turiqueqa cawarimonqam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martanam nerqan: —Aumi, musyämi. Llapan wanushqacuna cawarimunan junaqcho turillä cawarimunanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tsenam Jesus nerqan: —Noqaqa wanushqacunapa cawaritseqninmi cä, y wiñepa cawatsicoqmi cä. Noqaman marcäcoq caqqa wanurninpis, wiñe caweyoqmi canqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Meqan nunapis noqaman marcäquicar cawacorqa, manam wiñepatsu wanushqa quedaconqa. Marta, ¿creyinquicu tse nenqaqta? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martanam nerqan: —Aumi, Teyta, noqa creyïmi que patsaman shamunanpaq caq Dios Acrashqan tsurin canqequita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tseno nirirmi, eucorqan nanam Maria qayaq, y rinrinllachomi queno nerqan: —Mayestruntsicmi chämushqa. Qayashunquim —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tseno willariptinnam, Mariaqa jinallacho sharcur coripa ewarqan Jesusman. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesusqa Betaniaman manaraq yecur, Martawan topanqanllachoran quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tsenam Mariapa wayincho yanaqar quecaq autoridacunaqa, Maria ras sharcurcur eucoqta ricarnin qepanta ewayarqan “Turin pamparanqanmanchi yä ewan waqacoq” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Marianam Jesus quecanqanman chärir, ricarir, nopanman qonquriquicur nerqan: —Tëte, sitsun qam quecho quecanquiman carqan, turillä manam wanunmantsu carqan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tsenam Mariata y pewan ewaq reqishqa nunacunata waqaqta riquecur, Jesus allapa llaquir shonquncho nanatsicur, ");
INSERT INTO qwhNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","queno taporqan: —¿Memantaq pampayarqonqui? —nir. Pecunanam niyarqan: —Tëte, acu ricatsiyashqequi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesusnam waqarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tsenam tse reqishqa nunacuna niyarqan: —¡Ricayë, imalayaparaq Lazaruta cuyarqan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Y waquincunanam queno niyarqan: —Que nunam wiscuta cachacätserqan. ¿Manatsuraq imallatapis ruranman carqan Lazaru mana wanunanpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesusnam masraq shonquncho llaquir Lazaru pamparëcanqanman ewarqan. Tseqa juc machemi carqan. Y juc jatun rumim puncunta tsapararqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tsenam Jesus nerqan: —Tsaparaq rumita jorqayë —nir. Difuntupa panin Martanam queno nerqan: —Tëte, allapanachi yä asyan, porqui chuscu junaqnam wanonqan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesusnam queno nerqan: —¿Manacu nerqoq noqaman marcäcurnenqa, Diospa allapa puedeq quenintam ricanqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tse tsaparaq rumita jorquriyaptinnam, rara sieluman ricarcur Jesus queno mañacorqan: —Papällä, mañaconqaqta wiyamashqa captiquim allapa agradesicoq. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Musyämi qam imepis wiyamanqequita; peru tseta nireq quecho quecaq nunacuna que patsaman cachamashqequita creyiyänanpaqmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tseno mañacurirnam, fuertipa queno nerqan: —¡Lazaru, yarqamï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsenam cawarir yarqamorqan ratashcunawan chaquinpita maquinyaq limpu wancushqa y capirosashqa. Tsenam Jesus nerqan: —Canan purinanpaq pascariyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariata yanaqäyänanpaq ewaq atscaq autoridacunam Jesus ruranqanta riquecurnin, peman creyiquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peru waquin caqcunanam fariseucunaman ewar, willacuyarqan Jesus rurecushqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mandacoq caq saserdoticuna y fariseucuna tseta musyarirnam, waquin autoridacunata qayatsiyarqan Sanhedrin nishqan corticho sesionta rurayänanpaq. Ellucarirnam niyarqan: —¿Imatataq tse nunata rurecuntsic! ¡Atsca milagrucunatataq rurecun! ");
INSERT INTO qwhNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mana imanashqaqa, llapanpis pemanmi creyicurcuyanqa. Tsenam Romanucuna shamicur templuntsicta juchucacharcurnin, llapantsicta ushacätsimäshun —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tse watam mas mandacoq saserdoticuna quecarqan Caifas jutiyoq nuna. Pemi queno nerqan: —¡Qamcuna manam imatapis musyayanquitsu ");
INSERT INTO qwhNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni cäyiyanquitsu! Mejormi canqa llapantsic israel nunacunapa rantintsic juc nunalla wanunan llapantsic ushacänantsic cuenta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tseta manam quiquinllapitatsu parlarqan, antis, mas mandacoq caq saserdoti tse wata captinmi, Dios tseno parlecatserqan “Jesusllam israel nunacunapaqrecur wanonqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y manam israel nunacunallapaqtsu tsenoqa canan carqan, sinoqa enteru munducho ramacashqa Diospa wamrancunata ellunanpaqwanmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tse junaqpitam autoridacuna yachatsinacuyarqan Jesusta wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tsenam Jesus pecunapita rataquillapa purerqan. Y tsepitam eucorqan tsunyaqcho quecaq Efrain marcaman. Tsechomi disipuluncunawan quedacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israel nunacunapa Pascua fiestancunata selebrayänanpaq ichicllanam pishicarqan. Tsemi jinantinpita Jerusalenman atscaq nunacuna ewayarqan. Tsechonam tse Pascua fiestata shuyarnin, costumbrincunamanno limpiacur alistacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tsechonam Jesusta ashiyarqan. Mana tarirninnam, templucho quiquincuna pura tapunacur queno niyarqan: —¿Imataq qam ninqui? ¿Jesusqa que fiestaman shamonqatsuraq o manatsuraq? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mandacoq caq saserdoticuna y fariseucunam queno mandacushqa cayarqan: —Jesus mechopis canqanta musyarnenqa, willacayämutsun presu apatsiyämunäpaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiestapaq joqta junaqllana pishicaptinnam, Betania marcaman Jesus ewarqan. Tsechomi wanushqanpita cawaritsimonqan Lazaru yacharqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tsechomi miquita arucuyarqan Jesusta combidayänanpaq. Martanam mesaman sirwicorqan. Y Jesuswanmi Lazarupis mesacho miquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tsemanmi Maria chärerqan nardu püru nishqan allapa chaniyoq mediu litru perfuminwan. Tse perfumiwanmi Jesuspa chaquinta llushiporqan. Aqtsanwannam tsaquitsiporqan. Y wayi juntam tse perfumi shumaq pucutäcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tsemi Jesusta entregaq caq disipulun Judas Iscariote queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Imanirtaq tse perfumita ranticorqontsictsu, tse qellewan wactsacunata yanapanapaq! Que perfumipa chanenqa juc wäta uryapucur ganansianomi cashqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Peru Judasqa manam wactsacunata rasonpa ancupartsu tseno nerqan, sinoqa suwa tesoreru carmi, imepis qoyanqan qelleta pacaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tsenam Jesus nerqan: —Ama que warmi ruranqanta piñëtsu, queno ruramarnïmi alistaramashqa pampacäcunäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wactsacunaqa imeyaqpis qamcunawanmi quecayanqa yanapayänequipaq, peru noqaqa mananam qamcunawan cashaqnatsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Betaniacho quecanqanta musyarirnam, atscaq israel nunacuna ewayarqan Jesus ricaq. Y Lazarutapis riquetam munayarqan, wanushqanpita Jesus cawaritsimonqanta musyarnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tsemi mandacoq caq saserdoticuna yachatsinacuyarqan “Lazarutapis wanutsishunmi” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porqui Lazaruta cawaritsishqa captinmi, atscaq israel nunacuna pecunapita waqtsacäcurir, Jesusman marcäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Atscaq nunacunam ewashqa cayarqan Jerusalenman fiesta pasaq. Waräninnam musyariyarqan Jerusalenman Jesuspis yequicanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tsenam palmerapa raprancunawan Jesusta chasqueq yarquyarqan. Queno nishpam bibayarqan: “¡Alabashun Diospa shutincho shamoqta! ¡Alabecuyaqmi israel nunacunapa reynin!” ");
INSERT INTO qwhNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tsenam pollinu ashnuta taririr, Jesus montarqan. Tseno cananpaqmi Diospa palabran queno escribirëcan: ");
INSERT INTO qwhNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ama mantsacuyëtsu, Sion nishqan marcacho täraq nunacuna. Reyniquicunam pollinu, ashnun montashqa shamican” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Disipuluncuna manam tse öra cäyiyarqantsu Jesus rurashqancunata, peru wanonqanpita cawaririptinran, yarpäriyarqan peta tseno pasananpaq Diospa palabrancho escribirëcanqanta. Jina tse nenqannollam susedicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazaruta Jesus cawaritsenqanta ricaq nunacunanam mecho tsechopis willacuyarqan ricayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tsemi atscaq nunacuna Jesusta chasqueq ewayarqan porqui musyariyarqanmi tse milagruta rurashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tsenam fariseucuna quiquincuna pura queno ninacuyarqan: —¿Imanotaq cashun! ¡Llapannataq tse nunata qaticurcuyan! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tse fiesta selebrayanqanmanmi Grecia nasion nunacunapis ewayashqa cayarqan Diosta adoraq. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pecunam Galilea marcapa estansian Betsaidacho yuricoq Felipiman ewarnin, mañepa niyarqan: —Tëte, Jesuswanmi noqacunapis toparita munalläyä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tsenam Andresta willaq ewarqan Felipi. Y ishcancunam ewar, Jesusta willayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tsenam Jesus queno nerqan: —Canan si tincuramunna öra Diospita Shamushqa Nunapa alli queninta ricayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rasontam rasontam niyaq: Triguta mururishqaqa allpacho ushacärirmi, tse murupita jucna jeqaramur espigarir, mas atsca granutana jitecun; peru mana murushqaqa murullam quedarin. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pipis que patsallacho caweninta cuyaq caqqa, wac bidacho cawenintam oqranqa; peru que patsacho caweninta mana cuyaq caqqa, wac bidachomi wiñepa cawanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pipis sirwimë munaq caqqa noqata qatimätsun. Y mechomi noqa cashaq, tsechomi pepis quecanqa; y tseno sirwimaqtaqa Papänïpis cuyanqam. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“¡Shonqüchomi allapa llaquina! Peru tseno quecarpis, manam ‘Salbecamë’ nishaqtsu Papänïta, porqui tsepaqmi que patsaman shamushqa cä. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Antis quenomi nishaq: ‘Papä, ¡puedeq queniquita ricatsiquiquï!’ nir. Tsenam sielupita queno parlamoqta wiyayarqan: “¡Ricatsicushqanam cä! Y yapepis ricatsicushaqran” neqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tseta wiyecurnam, tsecho quecaq nunacuna niyarqan: —Rayum carqon —nishpa. Waquinnam niyarqan: —Juc anjelmi Jesusta parlapämorqon —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tsenam Jesus nerqan: —Manam noqarecurtsu tseno sielupita parlapämarqon, sinoqa qamcunarecurmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cananmi si que patsacho nunacuna jusgashqa cayanqa; y pecunacho mandacoq diablupis bensishqam canqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y sharcaratsiyämaptinmi, atscaq nunacuna noqaman creyicuyanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tseno nirnenqa, Jesus cäyitsicorqan imano wanutsiyänanpaq caqtam. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nishqanta wiyaqcunanam niyarqan: —Leynintsicmi queno musyatsimantsic: ‘Dios Acrashqanqa wiñepam cawanqa’ nir. Y qamnataq ninqui, ‘Diospita Shamushqa Nunataqa sharcatsiyanqam’ nir. ¿Pitaq tse Diospita Shamushqa Nunaqa? ");
INSERT INTO qwhNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tsenam Jesus nerqan: —Que patsacho canqäyaqqa actsiquicunam cä, peru ichicllanam pishican eucunäpaq. Tsemi actsiquicuna canqäyaq allita rurayë llutan rurecuna mana bensiyäshunequipaq. Porqui llutan ruraqcunaqa paqaschono carmi, musyayantsu imata rurayanqantapis. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Quecho canqäyaq marcäcuyë noqa actsiquicunaman, qamcunapis actsi cuenta cayänequipaq —nir. Tseno nirninnam, Jesus eucur pecunapita illaricurcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tsetsica milagrucunata ruranqanta riquecarpis, nunacuna manam Jesusman creyiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tsenomi cumplicärerqan profeta Isaias queno escribishqan: “Teyta, ¿picunaraq creyiyanqa willaconqantsicta? ¿Manacu llapan nunacuna ricayashqa puedeq queniquita, Teyta?” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tsemi nunacuna mana camapucäyarqantsu creyiquita. Jina quenopis Isaias escriberqanmi: ");
INSERT INTO qwhNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nunacunapa nawincunatam Dios wiscuyätsishqa, y shonquncunatanam rumiyätsishqa. Tseno carmi, nawincunapis ricanqatsu y shonquncunapis cäyenqatsu. Tseno carmi juclaya ticrayantsu salbacuyänanpaq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesuspa puedeq queninta Dios rebelashqa captinmi, Isaias Jesuspaq tseno willacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Imano captinpis, asta presisaq autoridacunapis atscaqmi Jesusman creyicuyarqan. Peru fariseucunata mantsarninmi, defrenteqa Jesusman creyicuyanqanta willacuyarqantsu, porqui mantsayarqanmi ellucayänan wayipita qarquyänanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pecunaqa ichicllam gustayaq Diospita alabashqa queta; masqa gustecuyaq nunacunapeq alabashqa quetam. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tsenam fuertipa Jesus nerqan: “Noqaman marcäcoq caqqa, cachamaqnï Dios Yayamanmi marcäcun; manam noqallamantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Noqata ricamaq caqqa, cachamaqnï Diostapis ricanmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Noqaqa actsi cuenta canäpaqmi nunacunaman shamushqa cä. Y pipis noqaman marcäcoq caqqa, mananam paqaschononatsu canqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Peru noqa yachatsicushqäcunata wiyecar, mana cäsucoqcunataqa manam noqatsu jusgashaq; porqui nunacunata salbanäpaqmi que patsaman shamushqa cä, manam castiganäpaqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Noqata chiquimarnï, parlashqäta mana wiyacoq caqtaqa, jucmi jusganqa. Y juisiu junaqchomi que parlashqäcunaqa jusganqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porqui manam quiquillapeqtsu yachatsicü, sinoqa cachamaqnï Dios Yayam mandamashqa nenqanllata yachatsicunäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y musyämi Papänïpa mandacushqancunaqa wiñe cawepaq cashqanta. Tsemi Dios Yaya nimashqannolla willapäcü” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ichicllanam pisherqan Pascua fiesta qallananpaq. Jesusqa musyarqanmi wanurir que patsapita eucur Dios Yayaman cuticunanta. Pëqa imepis que patsacho peman llapan creyicoqcunata cuyarqam y tsenollam imecamayaqpis cuyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tsechonam disipuluncunawan Jesus sena miquita miquicayarqan. Simonpa tsurin Judas Iscariotitam diablu pensatsishqana carqan Jesusta ranticunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusqa musyarqanmi Dios Yaya llapanta dispunir pepa maquinman churashqanta, y Diospita shamushqanta y peman cuticunanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tsemi senaquicanqanpita sharcurcur, mantunta qoturicur, towallata tseqllanman churacurcur, ");
INSERT INTO qwhNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","labatoriuman yacuta winaricur, disipuluncunapa chaquinta paqar qallecorqan, towallawan tsaquitsir tsaquitsir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Pedrupa nopanman chäriptinnam, Pedroqa queno nerqan: —Teyta, ¿noqapa chaquitacu qam paqamunqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesusnam nerqan: —Que rurecanqäta manaran qam canan cäyinquiraqtsu; peru imecarpis cäyirinquim —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedrunam nerqan: —¡Noqapa chaquïta manam nunca paqamunquitsu! —nir. Jesusnam nerqan: —Chaquiquita mana paqamupteqqa, manam noqapatsu canqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Pedrunam nerqan: —Tsepenqa Teyta, maquitapis peqätapis paqecallämï; ama chaquillällataqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesusnam nerqan: —Pipis bañacushqana carnenqa, chaquinllatanam paqacunan, limpiu car. Qamcunaqa bañacushqa cuentanomi limpiu shonquna cayanqui. Peru manam llapequicunatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Meqan caq ranticunanta musyarninmi, Jesus tseno nerqan: “Peru manam llapequitsu limpiu shonqu cayanqui” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Llapanpa chaquincunata paqar usharirninnam, mantunta yacacurcur, yape täcurir queno nerqan: —¿Cäyiyanquicu imanir qamcunata queno rurayanqaqta? ");
INSERT INTO qwhNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Qamcunam niyämanqui: ‘Mayestrullä y Teytallä’ nishpa. Tsenoqa niyämanqui rasontam, porqui niyämanqequinomi rasonpa cä. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Imanomi noqa mayestriquicuna y tëtequicuna quecarnin, chaquiquicunata paqamorqö, tsenolla qamcunapis jucniqui jucniqui chaquiquicunata paqapänacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Que ejempluwanmi yachatsiyarqoq qamcunapis, noqanolla sirwinacuyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rasontam rasontam niyaq: Patronninpitaqa sirweqnin manam mas presisaqtsu; mandaqninpitaqa manam mandadun ruraqtsu mas presisaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nishqäta cäyir rurarqa, allapa cushishqam cawacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Quetapis niriyashqequi; y manam llapequipaqtsu nimushaq, porqui qamcunata acrashqa cayarniquim noqa reqiyaq. Tsemi Diospa palabranpis cumplicärenqa: ‘Noqawan miquicaq nunam conträ shäricurconqa’ nenqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tsecuna manaraq pasacuptinmi, willayaq. Y susedicuriptinnam, creyiriyanqui noqa pi canqäta. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rasontam rasontam niyaq: Noqa cachashqäta pipis chasquerqa, noqatam chasquicaman. Noqata pipis chasquimarqa, cachamaqnïtam chasquican” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tseno nirirnam, shonquncho allapa llaquicurnin, Jesus claruna queno nïcorqan: —Rasontam rasontam niyaq: Qamcunapita jucniquim ranticamanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tsenam disipuluncuna jucnin jucnin yarpacachar ricaränacuyarqan, “¿meqantsicpaqraq Jesus tseno parlan?” nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mas cuyë caq disipulunmi Jesuspa laduncho micur quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Petanam Simon Pedru señasta rurarqan pipaq parlecanqata Jesusta tapunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tsenam pëqa mas witïcur, queno taporqan: —Teyta, ¿Pitaq canqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesusnam queno nerqan: —Tantata ushmaratsir, qonqä caqmi canqa —nishpa. Tseno nirninnam, tantata ushmaratsirnin, Simonpa tsurin Judas Iscariotita qorerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y tantata Judas chasquiriptinnam, peman diablu yecurerqan. Tsenam Jesus nerqan: —Ruranequita jinallacho rurë. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Peru tsecho miquicaqcuna manam ni meqanpis cäyiyarqantsu Jesus tseno nishqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Qelle tsaraq tesoreru captinmi, Judaspaq shonquncunacho queno pensayarqan: “Jesusqa nerqon Pascua fiestapaq imallatapis rantipäcamunanpaqchi” o “wactsacunata qaraq ewananpaqchi” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tsenam Jesus qarashqan tantata micurirnin, Judas jeqarerqan. Y paqasnam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas jeqariptinnam, Jesus nerqan: —Cananmi si Diospita Shamushqa Nuna puedeq canqanta ricayanqa. Jina Diospa puedeq queninta pëcho ricayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sitsun noqacho Diospa puedeq queninta ricayanqa, quiquin Diospis noqapa puedeq quenïtam ricatsiconqa. Y ichicllanam pishin tseta llapanpis ricayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cuyë wamralläcuna, ichicllanam pishin qamcunata jaqiriyänaqpaq. Tsenam ashiyämanqui peru tse autoridacunata nenqänollam qamcunatapis canan niyaq: Noqa ewanqämanqa manam qamcuna shayämita puediyanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cananmi si juc mushoq mandamientuta qoyaq: Llapequicuna jucniqui jucniqui cuyanacuyanqui. Qamcunata noqa imanomi cuyayarqoq, tsenolla jucniqui jucniqui cuyanacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sitsun qamcuna jucniqui jucniqui cuyanacuyanqui, llapan nunacunam musyariyanqa noqapa disipulücuna cayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pedrunam taporqan: —Teyta, ¿metataq ewanqui? —nishpa. Jesusnam nerqan: —Noqa eucunqämanqa canan manam qatimeta puedinquitsu; peru tsepitaran qatimarnï, shamunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedrunam nerqan: —Teyta, ¿manacu cananqa qamta qatita puedï? ¡Noqaqa qampaqrecurmi wanurishaqpis! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tsenam Jesus nerqan: —¿Rasonpatsuraq noqapaqrecur wanurinquiman? Rasontam rasontam neq: Manaraq gallu cantaptinmi, quima cuti negamanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Disipuluncunatanam Jesus nerqan: “Ama llaquicuyëtsu. Diosman y noqaman marcäcuyë. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Papänï yachanqanchomi atsca wayicuna can. Mana tseno captenqa, manachi willayaqmantsu. Y ewarmi, alistashaq qamcuna tsecho täräyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ewarir alistar usharirnam, cutimushaq pushacuyänaqpaq. Noqa canqächonam qamcunapis cayämunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Y musyayanquim meta ewanäta y mepa näni canqanta” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tsenam Tomas nerqan: —Tëte, ¡manam musyayätsu meman ewanequita! ¿Tsetsuraq musyayäman meqan näni canqantapis! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesusnam nerqan: —Noqam näni cuenta cä. Rason caqta willacoqmi cä. Jina caweniquicunapis noqam cä. Y noqaman marcäcurllam pipis Dios Yayaman chäyanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Noqata reqimarnïqa Papänïtapis reqiyanquim. Cananpitanam Diosta reqiyanqui, y riquecayanquinam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tsenam Felipi nerqan: —Tëte, riquecatsiyämë Dios Yayallatana. Tsellatanam munayä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusnam nerqan: —Felipi, unena qamcunawan quecaptïpis, ¿manacu reqiyämarqonqui? Pipis noqata ricamarnïqa Dios Yayatapis ricashqam. Tseno quecaptenqa, ¿imanirtaq nimanqui ‘Dios Yayata ricatsiyämë’ nirnin? ");
INSERT INTO qwhNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manacu nishqaqta creyinqui? Noqam Dios Yayawan jucllella cayä; pemi noqawan jucnolla. Manam quiquillapitatsu qamcunata parlapashqa cayaq. Dios Yaya noqawan jucnolla carninmi puedeq queninwan noqawan imatapis ruran. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Creyiyämë niyanqaqta noqam Dios Yayawan quecä, y pemi noqawan quecan. Peru niyashqaqta wiyecar mana creyirnenqa, milagrucuna rurashqäta ricashqa carninllapis creyicuyë. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Rasontam rasontam niyaq: Pipis noqaman marcäcorqa rurashqäcunatanomi ruranqa. Dios Yayaman cuticuptïpis, noqapita mas atsca milagrucunatam ruranqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Y qamcuna imatapis jutïcho mañacuyaptiqueqa, munayanqequicunata rurashaqmi. Tsenam noqarecur nunacuna Dios Yayata alabayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Imatapis jutïcho mañacayämaptiqueqa rurashaqmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Cuyamarnïqa mandacushqäcunatam cäsucuyänequi. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y noqanam Dios Yayata mañacamushaq yanapayäshoqniqui Espirituta cachamunanpaq. Pewannam imecamayaqpis cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pëqa rason caqta musyatsicoq Santu Espiritum. Diosman mana creyeqcunaqa tse Espirituta manam chasquita puediyantsu, porqui manam ricayantsu ni cäyiyantsu. Peru qamcunaqa reqiyanquim. Pëqa qamcunawanmi yachan. Y qamcunachomi quecanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Manam japallequicunallatatsu jaqiriyashqequi. Cutimushaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ichicllanam pishin eucunäpaq, y nunacuna mananam ricayämanqanatsu. Peru qamcunaqa cuentatam qocuyanqui noqa qamcunacho quecanqäta. Noqa wiñe caweyoq captïmi, qamcunapis wiñepa cawayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tsepinmi qamcuna musyariyanqui Papänïwan noqa canqäta, y noqawan qamcuna cayanqequita y qamcunacho noqa canqäta. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pipis mandacushqäcunata wiyar cäsucorqa noqatam cuyaman. Cuyamaqnïtaqa Papänï cuyanqam, y noqapis cuyashaqmi. Y cuyamaqnïtaqa mäcatsishaqmi pewan quecanqäta” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tsenam (mana Iscariote) caq Judas queno nerqan: —Tëte, ¿imanirtaq noqacunallataqa qampaq mäcatsiyämanqui y waquin nunacunataqa mana? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesusnam nerqan: —Pipis noqata cuyamar mandacushqäcunata wiyacuptenqa, Papänïmi tse nunata cuyanqa. Y noqacunam shamur pewan täcuyäshaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mana cuyamaq caqqa yachatsicushqäcunatapis manam cäsuconqatsu. Que wiyayanqequitaqa manam quiquïllapitatsu yachatsicü, sinoqa cachamaqnï Dios Yayapitam. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Llapantam willayarqoq qamcunawan quecarnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Peru noqapa rantïmi Dios Yaya cachamonqa yanapayäshoqniqui Santu Espiritunta. Pemi llapanta yachatsiyäshunqui. Y yachatsiyashqaqcunatapis yarpätsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Shumaq pasaquicho cacuyänequipaqmi yanapashqequi, y shumaq pasaquicho cawacuyänequipaq noqa yanapayanqaqnoqa manam pipis yanapayäshunquitsu. Ama llaquinayëtsu ni mantsacäyëtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Eucushaqnam y qamcunamanmi cutimushaq’ nishqäta wiyayarqonquim. Noqata cuyamarnïqa Dios Yayaman cuticunäta musyarninmi cushicuyanquiman, porqui noqa puedeq canqäpitaqa pemi mas puedeq. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Manaraq tseno pasamaptinmi llapanta willapäriyaq, niyashqaqno pasamaptin noqaman mas marcäcuyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ichicllanam pishin qamcunawan manana parlanäpaq. Chäramunnam mana alli ruraqcunapa mandacoqnin diablu. Peru pëqa noqata mandameta manam puedintsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dios Yayata cuyanqäta nunacuna musyayänanpaqmi mandamashqancunallata rurecä. “¡Ras shäriyë! ¡Quepita acuna eucushun!” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Noqaqa ubas plantapa alli troncu cuentam cä. Y Papänïmi cuidaman. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Noqapa rämäcuna mana wayuptenqa, Papänïmi limpu rämacacharcur jitarenqa. Wayoq caq rämacunataqa allapa atsca wayünanpaqmi shumaq rämapärenqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Qamcunaqa rämapärishqa cuentanomi limpiuna cayanqui noqa yachatsishqa cayapteq. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sitsun noqawan jucnolla cayanqui, noqapis qamcunawanmi jucnolla quecashaq. Imanomi troncunpita muturishqa räma frutacunnatsu, troncuncho manana carnin; tse cuentanollam qamcunapis noqawan mana juntu carqa, ni ima allita rurayanquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Noqaqa ubaspa troncun cuentam cä. Y qamcunanam ramäcunano cayanqui. Pipis noqawan jucnolla carnenqa, alli wayoq ubas plantanomi allapa allicunata ruranqa; peru noqapita raquicashqa carqa, manam ni ima allicunata ruranqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pipis noqawan jucnolla mana quecaqtaqa llümarir jitariyanqa, y tsaquiriptinnam, ellurir cayecuyanqa rupacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Sitsun noqawan qamcuna cayanqui y willaquinïta cäsucuyanqui, ima mañacuyanqequitapis qoyashqequim. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Allicunata rurayaptiqueqa, Papänïpa alli quenintam musyayanqui. Tseno carqa, rasonpa disipulücunam cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Noqaqa Dios Yaya cuyamashqannollam qamcunata cuyayarqoq. Y qamcunapis tseno cuyanacur cawacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Noqaqa Papänïta cuyarmi, mandacushqancunata cäsucü. Tsenollam noqata cuyamarqa, qamcunapis mandacushqäcunata cäsucuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Quecunata parlapëcayaq noqano qamcuna cushishqa cayänequipaqmi. Tsenopam sellama cushishqa cacuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Qamcunatam mandayaq: Noqa cuyayanqaqnolla qamcunapis jucniqui jucniquicuna cuyanacuyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Que cuyaquimi cuyaqueqa manam pipis wanurinmantsu amiguncunapaqrecur. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Noqa mandacushqäcunata rurarnenqa, amigücunam cayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mananam niyaqnatsu: ‘Sirwimaqnïcunam cayanqui’ nishpa. Sirwicoqcunaqa manam musyayantsu patronnin ruranqanta. Peru qamcunataqa amigücuna cayaptiquim, Papänï yachatsimashqancunata willayarqoq. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Manam qamcunatsu acrayämarqonqui, antis noqam qamcunata acrayarqoq. Tsemi mandayaq allicunata rurarlla cayänequipaq. Tseno imepis allicunallata rurar quecayaptiqueqa, imatapis jutïcho mañacuyanqequita Dios Yaya qamcunapaq ruranqam. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Qamcunatam mandayaq: Jucniqui jucniquicuna cuyanacuyanqui” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Sitsun noqaman mana creyeq nunacuna qamcunata chiquiyäshunqui; yarpäyë puntata noqata chiquiyämashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sitsun pecunano noqaman mana creyicoq cayanquiman, pecunam qamcunata cuyayäshunquiman. Peru qamcunaqa manam tsenotsu cayanqui, noqa acrashqa cayapteq. Tsemi pecuna chiquiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Niyashqaqta yarpäyë: ‘Patronninpitaqa sirweqnin manam mas puedeqtsu.’ Noqata chiquiyämarneqa, qamcunatapis chiquiyäshunquim. Peru palabräta cäsucurnenqa, qamcunatapis cäsuyäshunquim. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pecunaqa cachamaqnïtapis mana reqirmi, noqarecur chiquiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Sitsun noqa mana shamüman carqan y mana yachatsiyaqmantsu carqan, pecuna manam jutsayoqtsu cayanman carqan. Peru yachatsicushqa captïmi, cananqa jutsancunapita tsapäquita puediyannatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Noqata chiquimaqcunaqa Papänïtapis chiquiyanmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sitsun pipis mana ruranqan milagrucunatano ruräman carqan, manam jutsayoqtsu cayanman carqan. Peru tse rurashqäcunata riquecarninpis, noqata y Papänïta chiquiyämantaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Leynincuna escribirëcanqannomi pecuna chiquiyäman. Tsechomi queno escribirëcan: ‘Porgustum chiquiyäman’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Eucurmi, Dios Yayapita yanapayäshoqniqui rasonpa caq yachatsicoq Santu Espirituta qamcunaman cachamushaq. Pemi noqapaq nunacunata musyatsenqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jina qamcunapis qallanqäpita noqawan purishqa carmi, willapäyänequi llapan nunacunata. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Quecunatam willecayaq ima eca captinpis, alli tsaracur quecayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ellucayänan wayicunapitam chiquiyäshoqniquicuna qarquyäshunqui. Waquinniquicunatanam wanutsiyäshunqui ‘Queno rurarmi Diosta alli sirwï’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Y quecunata rurayanqa Dios Yayata y noqata mana reqiyämarnïmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Quecunatam willecayaq que niyashqaqno pasayäshuptiqui yarpäriyänequipaq. “Canancamayaq manaran quecunata willayarqoqraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cananqa cachamaqnïmanmi cuticü, peru manam ni meqequi tapuyämanquitsu ‘¿Memantaq eucunqui?’ nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","¡Antis tseno nicuyapteqtaq allapa llaquishqa ticracuriyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Rasontam niyaq: Qamcunapa bienniquicunam cuticü. Mana cutiptëqa, manam shamonqatsu yanapayäshoqniqui Santu Espiritu. Peru cutirnenqa, peta cachamushaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pe shamurninmi, nunacunata cäyitsenqa picuna jutsasapa cayanqanta, picuna alli ruraq cayanqanta, y picuna castigashqa cayänanpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jutsasapa cayanqantaqa cäyitsenqa, noqaman mana marcäcuyaptinmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Alli rurepaqqa cäyitsenqa Dios Yayaman cuticuptï, manana ricayämaptinmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y picuna castigashqa cayänanpaq caqtanam cäyitsenqa que patsacho mandacoq diablu condenacärishqana captin. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Willayänaqpaqqa atscaran can. Llapanta niyapteqqa, manam cäyiyämanquimantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Rason caqta yachatsicoq Santu Espiritu shamurninnam, llapan wiyashqancunata y rason caqllata cäyitsiyäshunqui, y manam quiquin parlashqancunatatsu. Tsenollam imapis susedicunanpaq caqcunata musyatsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pemi noqa puedeq canqäta y imano canqäta cäyitsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dios Yayapa llapan imecancunapis noqapam. Tsemi niyarqoq: ‘Santu Espiritum noqa parlashqäcunata musyarnin, qamcunata cäyitsiyäshunqui’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ichicllanam pishin eucunäpaq, y mananam ricayämanquinatsu. Peru tsepitanam jina yape ichiclla ricarayämanqui, ˻porqui Diosmanmi eucushaq˼” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tsenam disipuluncuna jucnin jucnin tapunacuyarqan queno: —¿Ima ninantaq que nenqan ‘Ichicllanam pishin eucunäpaq, y mananam ricayämanquinatsu. Peru tsepitanam jina yape ichiclla ricarayämanqui, porqui Dios Yayamanmi eucushaq’ nintaq? ");
INSERT INTO qwhNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ichicllaqa ¿ima ninanraq? Manam cäyintsictsu parlanqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tseta tapita munayashqanta cäyirirnam, Jesus nerqan: —Noqam niyarqoq: ‘Ichicllanam pishin manana ricayämänequipaq. Tsepita ichicllanam ricarayämanqui’ nir. ¿Tsetacu jucniqui jucniquicuna tapunaquicayanqui? ");
INSERT INTO qwhNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rasontam niyaq: Qamcuna allapa llaquicurnin waqaquicayaptiquim, noqaman mana creyicoqcunana cushiquicho quecayanqa. Tseno llaquicushqa quecayaptiquipis, llaquiquiniquicunam cushiquiman ticrarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Meqan warmipis qeshpicunan öra chäcuriptinmi, nanatsicur waqan. Wamran yuririptinnam, nanenintapis qonqecur cushicun. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tsenollam qamcunapis canan eucuptï llaquicuyanqui. Peru yape riquecuyapteqnam, allapa cushicuyanqui, y tse cushiquiniquicunaqa manam ushacanqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mananam tse junaq ni imatapis tapuyämanquinatsu. Rasontam rasontam niyaq: Noqaman marcäcur imatapis jutïcho mañacuyaptiqueqa, Dios Yaya qoyäshunquim. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Canancamayaqqa manam ni imatapis jutïcho mañacuyarqonquiraqtsu. Tsemi mañacuyë chasquïcur allapa cushishqa cayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Canancamayaqmi iwalatsiquillapa yachatsiyashqaq, peru tiempu chäramonqanam manana tseno yachatsiyänaqpaq. Sinoqa clarunam llapanta yachatsiyashqequi Dios Yayapaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tse junaqcunam noqapa jutillächona Dios Yayaman mañacuyanqui. Y manam presisanqaraqtsu quiquiraq qamcunapaq mañacamunä. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pe quiquinmi allapa cuyayäshunqui. Noqa pepita shamushqa canqäta creyirnin cuyayämaptiquim, qamcunatapis Dios Yaya cuyayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Noqam Dios Yayapa nopanpita yarqamurnin, que patsaman shamorqö. Cananqa quepita eucurmi, Dios Yayaman cuticü” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tseno niptinnam disipuluncuna queno niyarqan: —Alli cäyiyänäpaqmi cananqa claruna yachatsiyämarqonqui, mananam iwalatsiquillapanatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cananmi si rasonpa musyariyarqö qam imecatapis musyanqequita. Asta nunacuna tapuyäshunequipaq caqtapis musyanquim. Tsenopam creyiyä Diospita qam shamushqa canqequita —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusnam nerqan: —¿Cananraqchi noqaman rasonpa marcäcuyanqui! ");
INSERT INTO qwhNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Öraqa chäramunnam, llapequicuna witsicar wayiquicunaman eucur noqata japallällata jaqirayämänequipaq. Peru manam japallätsu cashaq. Dios Yayam noqawan quecanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Llapan quecunatam willayarqoq noqarecur shumaq pasaquicho cayänequipaq. Que patsachoqa qamcuna sufriyänequim. Peru balorta tsariyë; que patsacho llapan mana allicunata benserqönam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tseno nirirnam, sieluman ricarcur mañacorqan queno: “Papällä, ¡chäramuntaq öra! Canan qam puedeq Tsuriqui canqäta ricatsiquï, tsenolla Tsuriquipis qam puedeq canqequita ricatsicunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tsuriquitam churashqa canqui llapan nunacunapa mandacoqnin cananpaq. Tsemi qam qomanqequi caq nunacunata noqa qoshaq wiñe cawenincuna. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Qamllam Dios canqui. Noqa Jesucristutam que patsaman cachamarqequi. Y ishcantsicta reqimarnintsicmi, nunacuna wiñe caweyoqna cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Que patsacho quecarmi, mandamashqequicunata rurar usharirnin, qam allapa puedeq canqequita musyatsicorqö. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Papällä, manaraq que patsa captinmi, qamwan noqa jucnolla puedeq carqantsic. Cananpis nopequiman pushacamar puedeq canqäta ricatsiquiquï. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Llapan nunacunapitam waquin caqcunata acrarir, noqaman pushamorqequi. Tsemi imano canqequita pecunata musyatsishqa cä. Qampam pecuna cayan, y mandacushqequitam pecuna cäsucuyan. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cananqa musyayannam llapan musyatsimanqequi qampita shamonqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Willamashqequitam pecunata willarqö, y wiyacuyashqam. Musyayannam rasonpa qampita shamushqäta, y cachamashqequitapis creyiyashqam. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Pecunapaqmi mañaquicoq. Manam mañacoqtsu llutan ruraqcunapaqqa, sinoqa mañaquicoq qomashquequi caqcunapaqmi, porqui qampam cayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Noqapa caqqa llapanmi qampa. Qampa caqcunanam noqapa. Pecunachomi alli quenïta ricayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Que patsacho mananam cashaqnatsu. Qammannam eucamushaq. Peru noqaman creyeqcunaqa que patsacho quecayanqaran. Jutsannaq Papällä, qam qomanqequi caqcunata puedeq queniquiwan cuidequï noqantsic jucllella canqantsicnolla pecunapis jucllellano cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Que patsacho pecunawan quecarmi, qam qomashqa captiqui, mana alliman ishquiyänanta jutiquicho tsararqö, y llapantam cuidarqö. Manam ni meqan oqracashqatsu. Sinoqa palabrequicho escribishqannomi mana alli ruraq caqlla condenacärishqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Cananqa qammanmi cuticamü. Noqa cushishqa canqänolla pecunapis cushi cushi cayänanpaqmi que patsachoraq quecar willaparqö. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Willaquiniquitam pecunata yachatsishqa cä. Tsemi mana alli nunacuna noqatano pecunata chiquiyan, mana pecunano cayaptï. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Manam nunacunapita raquicacuriyänanpaqtsu mañacoq, sinoqa llutan rurecunapita wardecunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Noqaqa manam que patsa nunacunanotsu cä. Y pecunapis manam que patsa nunacunanotsu cayan. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Qamqa rason caqllatam willacunqui. Tseta cäsucur qamllapaqna pecuna cayätsun. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nunacunaman cachamanqequinollam noqapis pecunata cachä nunacunaman. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pecunarecurmi muneniquimanno cawecä. Tserecurmi pecunapis rasonpa caqta cäsucur, muneniquimanno cawayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manam pecunallapaqtsu mañacoq. Sinoqa pecuna yachatsicuyaptin wiyacur noqaman creyicoq caqcunapaqwanmi mañacoq. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Papällä, pecuna jucnolla cayätsun, noqawan qam jucnolla canqantsicno. Tsenolla pecunapis noqantsicwan jucnolla cayätsun. Tsenopam llapan nunacuna musyayanqa noqata que patsaman cachamashqequita. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jucllella canqantsicno pecunapis jucllellano cayänanpaqmi puedeq queniquita musyatserqö. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Qam y noqa jucllellam cantsic, y noqapis pecunawan jucnollam cä. Tserecurmi pecunapis jucllellano cayanqa. Tseno cayanqanta nunacuna ricarmi, musyariyanqa noqata cachamashqequita y noqata cuyamanqequinolla pecunatapis cuyanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Papällä, noqaman creyicoq caqcuna noqa canqächo cayänantam munä, y qomanqequi podernïta ricayänantam munä; porqui manaraq que patsata camarninmi, noqata cuyamarqequi. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Allilla ruraq Papällä, nunacuna qamta mana reqiyäshuptiquipis, noqaqa reqeqmi. Y quecho quecaqcunallaqa musyariyashqanam noqata que patsaman cachamashqequita. ");
INSERT INTO qwhNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pecunatam rasonpa qam Dios canqequita yachatsishqa cä, y yachatsishaqran. Tsemi noqata cuyamanqequi cuyaquiniqui pecunacho canqa, y noqapis pecunacho cashaq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tseno mañacur usharirnam, disipuluncunawan Jesus yarqur eucuyarqan Cedron nishqan uranpa wac tsimpanman. Tsechomi carqan juc werta. Tsemanmi yecuriyarqan disipuluncunawan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tse wertacho Jesus disipuluncunawan imepis ellucayanqantam ranticoqnin Judas Iscariote musyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tsemi Judas Iscariote tseman chärerqan mandacoq caq saserdoticunapa y fariseucunapa cachashqan templupa wardiancunawan y juc tropa soldaduncuna pusharishqa. Y actsincunawanmi, garutincunawanmi y sablincunawanmi cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesusqa musyarqannam llapan pasacunanpaq canqanta. Tsemi pecunaman witicur taporqan: —¿Pitataq ashiyanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pecunanam niyarqan: —Nazaretpita Jesustam —nir. Jesusnam nerqan: —Noqam cä —nir. Laduncunachomi quecarqan ranticoqnin Judas Iscariotipis. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Noqam cä” nishpa, Jesus nïcuptinnam, soldaducuna qepapa ishquiriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tsenam yape Jesus taporqan: —¿Pitataq ashiyanqui? —nir. Pecunanam niyarqan: —Nazaretpita Jesustam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tsenam Jesus nerqan: —Niyarqoqnam: Noqam cä. Noqallata imanecayämëpis, disipulucunataqa jaqiriyë eucuyänanpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tseno niptinmi, cumplicärerqan Diosta puntata Jesus queno nenqan: “Papä, qomanqequi nunacunaqa manam ni jucllellapis pishintsu” nenqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tsenam Simon Pedru sablinta jorquricurnin, mas mandacoq saserdotipa sirweqninpa derechu caq rinrinta wallicorqan pintireqpaq. Tse nunapa jutinmi carqan Malcu. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesusnam nerqan: —¡Pedru espadequita cutitsï wardananman! Dios Yaya noqapaq dispunishqancunata ¿manacu chasquïman! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tsenam soldaducuna israel autoridacunawan y mandacoq caq saserdoticunapa y fariseucunapa cachayashqan templupa wardiancunawan Jesusta presu tsarircur, maquinta watarcur, ");
INSERT INTO qwhNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","saserdoti Anas caqman apacuyarqan. Anasqa Caifaspa suegrunmi carqan. Tse watam mas mandacoq saserdoti Caifas quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifasmi tse autoridacunata queno nishqa carqan: “Llapantsicpa rantintsicmi presisan juc nunalla wanunan” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","˻Apacuyaptinnam˼ Simon Pedru y juc mas disipulun Jesusta qatiyarqan. Mas mandacoq caq saserdotiwan reqinacurninmi, tse jucnin caq disipuloqa ruri patiuyaq yecurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peru Pedroqa jaq puncullachomi quedacorqan. Tsenam mas mandacoq saserdotiwan reqinacoq caq disipuloqa yarqurir, puncucho täpacoq warmiwan parlarir, Pedrutapis ruriman yecaratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedru yecurëcaptinnam, puncucho tapacoq empleadaqa nerqan: —¿Manacu taqe nunapa disipulun qampis canqui? —nir. Pedrunam: —¡Manam! —nerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Alalaptinnam, ninata sendircur, mas mandacoq saserdotipa sirweqnincuna y templupa wardiancuna shëcar qoñuquicayarqan, y Pedrupis pecunawanmi sharëcarqan qoñucur. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tsenam Jesusta mas mandacoq saserdoti taporqan disipuluncunapaq y yachatsiconqancunapaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesusnam nerqan: —Llapan nunacunam wiyayashqa noqa parlanqäta. Imepis yachatsicorqö israel nunacuna ellucayänan wayicunachomi y templuchomi. Manam paquellapaqa imatapis parlashqätsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imanirtaq noqata tapumanqui? Yachatsicushqäta wiyaqcunam musyayan ima nishqätapis. ¡Pecunata tapï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tseno niptinmi templupa wardian Jesusta qaqllancho laqyecorqan, —¿Tsenocu contistanqui mas mandacoq saserdotintsicta! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesusnam nerqan: —Mana allita parlaptïqa, imacho mana alli nishqäta nimë. Nenqä alli captenqa, ¿imanirtaq laqyamanqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tsepitanam jina maquin watashqallata Anas apatserqan mas mandacoq saserdoti Caifasman. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedroqa nina ladunchomi jauca shëcarqan qoñucurnin. Tsenam tapuyarqan: —¿Manacu qampis taqe nunapa disipulun canqui? —nir. Pedrunam negarqan: —Manam —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tsechomi mayor caq saserdotipa sirweqnin nuna quecarqan. Pëqa wertacho Pedru rinrinta walluraponqan nunapa castanmi carqan. Tsenam Pedruta tse nuna nerqan: —¿Manacu wertacho qamta ricarqoq taqe nunatawan? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedru yape “Manam” nicaptinnam, gallu cantarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Patsa warärëcaptinnam, Caifaspa wayinpeq Jesusta autoridacuna apacuyarqan gobernadorpa despachunman. Chäratsirninnam, tse despachunmanqa yecuyarqantsu melanepaq mana ticrayänanpaq. Yecorqa, manam Pascua miquita micuyanmantsu carqan pecunawan juntacushqa car. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsenam Pilatoqa jaqcho quecayanqanman yarqurir, nerqan: —¿Ima mana allitataq que nuna rurashqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Autoridacunanam niyarqan: —Mana jutsata rurashqa captenqa, manam qamman apayämümantsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatunam nerqan: —Apacuyë. Mä qamcunana leyniquicuna nenqanmanno jusgayë —nir. Pecunanam niyarqan: —Manam quiquïcunallapitaqa nunata wanutsiyämantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tseno niyaptinnam, cumplicärerqan Jesus imano wanutsiyänanpaq caqta willaconqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tsenam ruri despachunman Pilatu cuticur Jesusta qayarirnin taporqan: —¿Qamcu canqui israel nunacunapa reynin? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusnam nerqan: —¿Quiquiquillapeqcu tseno tapumanqui, o pipis nishorqonquicu noqapaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatunam nerqan: —¿Acasu noqa israel nunacu cä! Qampa marca mayiquicunam y mandacoq caq saserdoticunam noqaman apayämushorqonqui. ¿Imatataq rurashqa canqui? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesusnam nerqan: —Noqapa mandaquinïqa manam que patsacho nunacunapa mandaquininnotsu. Que patsacho mandacoq captïqa, sirwimaqnïcunam pelyarnin, mana dejayämanmantsu israel autoridacunaman presu apayämänanta. Mandacoq quenïqa manam quechotsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tsenam Pilatu nerqan: —¿Tsepenqa reychi canqui? —nir. Jesusnam nerqan: —Quiquiquitaq nicanqui rey canqäta. Tsepaqmi yuricushqa cä. Rason caqta willacoqmi que patsaman shamushqa cä. Y rason caqta wiyaqui munaqcunaqa yachatsicushqäcunatam wiyacuyan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatunam taporqan: —¿Imataq tse rason caqqa! —nir. Tseno nirninnam, israel autoridacuna quecayanqanman yarqurir, Pilatu nerqan: —Manam que nunapa ni ima jutsanta tarïtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Costumbriquicunamannomi Pascua fiestacho juc presuta cacharinä. ¿Qamcuna munayanquicu que reyniquicunata cacharinäta? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsenam nunacunana qayaripa niyarqan: —¡Ama tse nunataqa cacharïtsu! ¡Barrabasta cachariqueqa! —nir. Tse Barrabasqa allapa mana baleq nunam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tsenam Jesusta Pilatu astaquecatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldaducunanam cashapita coronata awarir, Jesuspa peqanman yacarcur, granati capata aqshuratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Y nopanman witicurninnam, burlacurnin niyarqan: —¡Biba, israel nunacunapa reynin! —nir. Tseno nishpam qaqllancho laqyar ushayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tsepitanam pecunaman yape yarqurir, Pilatu nerqan: —Cananmi queman Jesusta jorqamushaq mana ni ima jutsanta tarenqäta cäyiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tsenam ruripita Jesus yarqaramorqan casha coronan yacashqa y granati capan aqshucushqa. Tsenam Pilatu nerqan: —Quemi que apayämonqequi nuna —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesusta ricarirninnam, mandacoq caq saserdoticuna y templupa wardiancuna qayaripa niyarqan: —¡Cruscho wanutsï! ¡Cruscho wanutsï! —nir. Pilatunam nerqan: —Noqaqa manam que nunacho ni ima jutsata tarïtsu. Mä qamcunana peta apacurnin, cruscho wanutsicuyë —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tsenam tse autoridacuna niyarqan: —Pemi nin, ‘Diospa tsurinmi cä’ nishpa. Leynïcunachomi nin tseno neqtaqa wanutsiyänapaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tseta wiyecurnäqa, Pilatu masran mantsaquecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tsenam despachunman cutiratsir yape Jesusta taporqan: —¿Mepitataq qam canqui? —nir. Peru Jesusqa upällam cacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tsenam Pilatu nerqan: —¿Imanirtaq mana yasquimanquitsu? ¿Manacu cuentata qocunqui noqallapita pendenqanta? Noqa munaptïmi, qamta cruscho wanutsiyäshunqui o cachariyäshunquipis —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesusnam nerqan: —Autorida canequipaqqa Diosmi churashushqa cashunqui. Mana tseqa manam puedinquimantsu ni imata rurameta. Tsemi qamman apamaqnïcuna qampitapis mas jutsayoq cayan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tsenam Pilatu imanollapapis munarqan cachariquita. Peru autoridacunanam cacharinanta mana munar, qaparipa niyarqan: —Jesusta cacharirnenqa, manam Roma mandacoq cesarta cäsunquitsu. Jesusqa rey tucurmi, cesarpa contran —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tseno niyaptinnam Pilatu Jesusta jaqman jorqaratsir, sentensiancunan tribunalman täcurerqan. Tse tribunal canqan sitioqa carqan rumicunawan shumaq enlosadum y tsetam niyarqan hebreu parlacho “Gabata” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tse junaqqa Pascua fiestapaq alistapäquinam carqan. Y pullan junaqnonam carqan. Tsenam israel nunacunata Pilatu nerqan: —Quemi que reyniquicuna. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tsenam nunacuna qaparipa niyarqan: —¡Tseta weqapalayämi! ¡Tseta weqapalayämi! ¡Cruscho wanutsun! —nir. Pilatunam nerqan: —¿Reyniquicunatacu cruscho wanutsishaq! —nir. Mandacoq caq saserdoticunanam niyarqan: —Noqacunapa reynïcunaqa cesarllam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tsenam pecunaman Jesusta Pilatu entregarerqan crusificayänanpaq. Tsenam tsarircur apacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tsepitanam Jesusta crusnin catarcatsir, jeqaratsiyarqan calabera niyashqan sitiuman. Tse sitiutam “Golgota” niyaq hebreu parlacho. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tseman chäratsirnam, Jesusta crusman clabayarqan. Petawanmi ishcaq nunacunata crusificayarqan jucnin caqta derechu ladunman jucnintana itsoq laduman y Jesustanam chopincunaman. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Juc letrerutam cruspa puntanman Pilatu queno escribishqata churatserqan: “Quemi Nazaretpita Jesus, israel nunacunapa reynin” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hebreu, latin y griegu idiomacunachomi tseno escribirarqan. Jesus clabarëcanqan sitiu amanulla captinmi, atscaq israel nunacuna ricarnin, tse letreruta leyiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Israel nunacunapa mandacoq caq saserdoticunanam Pilatuta niyarqan: —‘Israel nunacunapa reynincuna’ nerqa ama escribirätsuntsu. Sinoqa, ‘Quemi israel nunacunapa reynin tucoq’ nirlla, escribirätsonqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatunam nerqan: —Escribenqänomi quedanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tsenam Jesusta crusman clabarirnin, ropanta ellurir soldaducuna chuscuman raquinacuriyarqan juc juc cada unu. Tseno raquinacuriyaptinnam, Jesuspa tunicanraq quedarerqan. Tse tunicaqa costurannaq awashqam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tsenam soldaducuna parlariyarqan: —¡Ama quetaqa rachishuntsu! ¡Sortiyarishun! Mä, ¿meqantsictash tocamäshun? —nishpa. Tseta rurariyaptinmi, pactarerqan Diospa palabrancho queno escribirëcanqan: “Ratashnïtam raquinacuyarqan. Y tunicätam sortiyayarqan” nenqan. Tsenomi rurayarqan tse soldaducuna. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus clabarëcanqan cruspa ladunchomi mamänin, mamäninpa nanam, Cleofaspa warmin Maria y Maria Magdalena quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tsenam cuyanqan disipulun tsecho mamäninwan shëcayaqta riquecurnin, Jesus nerqan: —Mamä, cananqa penam wawequi cuenta canqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tsenollam jina tse disipuluntapis nerqan: —Pemi canapitaqa mamequi cuenta canqa —nir. Tsepita patsam tse disipulun peta apacorqan wayinman mamantano cuidananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesusqa musyarqanmi llapan cumplicärishqana canqanta. Y Diospa palabrancho escribirëcanqanmi pactarerqan “¡Yacunällämi!” nicuptin. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tsechomi puchqoq binagri jarupa quecarqan. Tsemanmi esponjata tullpurcur, isopupa puntanman watarcur, Jesuspa shiminman apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesusnam puchqoq binagrita shoqurirnin nerqan: —Llapannam cumplicärishqa —nir. Tseno nirninnam, peqanta puctircur wanurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jamaqui junaqcho Pascua fiesta ratecuptinmi, israel autoridacuna munayarqantsu wanoqcunapa ayancuna cruscho clabarëcananta. (Tsemi tse jamaqui junaqqa mas respetaduraq quecorqan.) Tsemi Pilatuman ewecurnin, rogayarqan cruscho clabarëcayaq nunacunapa chancancunata paquicacharcatsinanpaq y cruspita ayancunata jorqaricatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsenam soldaducuna ewecurnin, Jesuswan ishcaq clabarëcaqcunapa chancancunata paquicacharcuyarqan, puntata jucnin caqpata y tsenollam jucnin caqpatapis. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Peru Jesustaqa wanurishqatana tarirmi, chancanta manana paquiyarqannatsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tsenam Jesuspa qasqunta espadanwan juc soldadu tucsicorqan. Y yacum yawarnintin yarqaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Noqam llapanta ricarqä. Y ricashqätanollam willayaq willaquinïqa rason caqllam qamcuna creyiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tseno soldaducuna rurayaptinmi, pactarerqan Diospa palabran queno escribirëcanqan: “Manam ni meqan tullunta paquiyanqatsu” nenqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jina quenopis escribirëcanmi: “Tucsir ushashqatam ricayanqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Arimatea marcapeq Jose nishqan nunam israel autoridacunata mantsarnin, pacallapa Jesuspa qatiraqnin carqan. Tse nunam Pilatuman ewar, mañarqan Jesuspa ayanta pampecunanpaq. Pilatu “Apaquï” niptinnam, cuticur apacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tsemannam chärerqan paqasllapa Jesuswan parlananpaq ewaq Nicodemupis, quima arobatano montipa weqin mirra nishqan y aloes nishqan pucutaq perfuminwan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tse ishcan nunanam israel nunacunapa costumbrincunamanno pampayänanpaq tse pucutaq apayanqanta finu sabanasman jichecur, Jesuspa ayanta wancuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta crusificayanqan sitiuchomi carqan juc werta. Tsechomi juc mushoq sepultura carqan. Tsemanqa manaran pitapis pampayarqanraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Israel nunacunapa jamacuyänan junaqpa dispiranna tse tardi captinmi, y amanulla sepultura captinmi, jicutellapa Jesuspa ayanta tseman pampariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingu qoyanam paqasllaraq quecaptin, Jesus pamparëcanqanman Maria Magdalena ewarqan. Chärirnam sepultura tsaparaq jatun rumita ricarerqan juc laducho quecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsenam corillapa cuticur, Simon Pedruta y Jesuspa cuyë disipulunta queno willarqan: —Sepulturapitam Teytantsicpa ayanta apacuyashqa. Manam musyätsu meman churayashqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tsenam Pedru y jucnin disipulun ewacuyarqan Jesus pamparanqanman. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishcanmi coripa ewayarqan. Jucnin caqqa Pedrupita mas corirmi, puntata chärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chärirnam pucticur puncullapita riquecorqan finu sabanaslla churarëcaqta. Manam rurimanqa yecorqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pedrunan qepanta chärir, ruri sepulturaman yecurerqan. Pepis ricarerqan sabanasllana tsecho churarëcaqtam. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesuspa peqan wataraq ratashqa juc laduchomi shumaq ellushqa churarëcarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsenam puntata chaq caqpis ruriman yecurir, tsecunata ricarir pepis creyirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tseyaqqa manaran alleqllaqa cäyiyarqantsu Diospa palabrancho Jesus cawarimunanpaq willaconqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsepitanam ishcancuna wayincunaman cuticuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Magdalenanam sepulturapa puncuncho waqaquicarqan. Tseno waqaquicarnam ruriman cawecur, ");
INSERT INTO qwhNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","riquecorqan yulaq püru bistishqa ishcaq anjelcuna Jesuspa ayan churarashqancho tëcayaqta; jucninmi peqan canqancho, jucninnam chaquin canqancho. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Anjelcunanam niyarqan: —Mamite ¿imatataq waqanqui? —nir. Maria Magdalenanam nerqan: —Teyta Jesustam apacuyashqa. Manam musyätsu meman churayashqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tseno nirirnam tumecurnin riquecorqan Jesus tsecho shëcaqta. Peru Jesus canqantaqa manam musyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesusnam taporqan queno: —Mame ¿imanirtaq waqanqui? ¿Pitataq ashinqui? —nir. Maria Magdalenanam shonqunllacho “Werta täpaqchi queqa” nishpa pensarnin, queno nerqan: —Tëte, ¿qamchi yä memanpis ayanta apecorqonqui? Meman churashqequitapis willecallämë ewarnin apacullanäpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tsenam Jesus nïcorqan: —Maria —nir. Tsenam Maria tumecurnin: —¡Rabunï! —nïcorqan. (Rabuneqa, mayestrullä ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesusnam nerqan: —¡Ama tsaramëtsu! Manaran Papänïman ewäraqtsu. Antis ewë noqaman creyicoq wauqïcunata. Willanqui Papänïman eucunäpaq caqta; noqapa Papänïqa qamcunapapis Papäniquicunam, y Diosnïqa qamcunapapis Diosniquicunam —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tsenam disipuluncunaman Maria Magdalena ewecur, willacorqan Teyta Jesusta riqueconqanta, y willacorqan Jesus encarganqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tse domingu tardinam disipuluncuna wayi rurincho juntu quecayarqan. Israel autoridacunata mantsarninmi, puncuta alli buenu trancashqa quecayarqan. Chopincunaman yurircurnam Jesus napacurerqan queno nishpa: —¡Alli pasaquicho cayë! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tseno nirmi, ricatsicorqan maquincunata y pechunta. Tsenam disipuluncunaqa Teyta Jesusta riquecur, allapa cushicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesusnam yape nerqan: —¡Ama llaquiyëtsu, cushicuyë! Imanollam Dios Yaya noqata cachamarqon; tsenollam qamcunatapis nunacunaman cachayaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tseno nirirnam pecunaman püquecur: —Santu Espirituta chasquiyë —nerqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pitapis jutsancunata perdonayaptiqueqa perdonashqam cayanqa, y pitapis mana perdonayaptiqueqa manam perdonashqatsu cayanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tse wayicho juntu quecayanqanman Jesus chänan öra chunca ishque (12) disipulunpita Mellïshu niyanqan Tomas manam tsechotsu quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tsepitanam Tomasta willariyarqan: —Teyta Jesustam riquecuyarqö —nir. Tomasnam nerqan: —Jesuspa maquincho clabu uchcushqata mana ricarqa, y clabu uchcushqanman dedüta mana yacarqa, y qasqunman maquita mana yacarqa, manam creyishaqtsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Juc semanatanam disipuluncuna yape tse wayicho juntu quecayarqan. Y Tomaspis tsepenqa tsechomi quecarqan. Puncu llawishqa quecaptinpis, juclla chopincunaman yurircurmi, Jesus queno nerqan: —¡Cushi cushi cacuyë! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomastanam nerqan: —Tomas, riquë maquita, dediquita yaque. Y qasqümanpis maquiquita yaque. ¿Imanirtaq creyicunquitsu? ¡Cananpita creyicunqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tsenam Tomas nerqan: —¡Teytallämi y Diosllämi canqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusnam nerqan: —Tomas, ¿ricaramarraqchi creyirinqui! Cushicuyätsun mana ricamarpis creyicoqcuna —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Atsca milagrucunatam Jesus rurarqan disipuluncunapa nopancho. Tsecunaqa manam llapantsu escriberqan que librucho. ");
INSERT INTO qwhNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Quecunallata escribirninmi willayaq Dios Acrashqan tsurin Jesus canqanta creyiyänequipaq. Creyicorqa, perecur wiñe caweyoq cayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Quenomi disipuluncunata Jesus yape yuriporqan Tiberias nishqan Lamar cuchuncho. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tsechomi disipuluncuna Simon Pedru, mellïshu niyanqan Tomas, Canä de Galilea marcapeq Natanael, Zebedeupa ishcan tsurincuna y ishcaq mas disipulu mayincuna quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pedrunam nerqan: —Noqaqa pescaqmi eucü —nir. Waquincunanam niyarqan: —Acu, noqacunawanpis ewashun. Eucurninnam, lanchaman lloqarcur, jeqariyarqan. Tse paqas manam ni jucllellatapis tsariyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Patsa warärëcaptinnam, Jesus lamarpa cuchuncho shëcarqan. Jesus canqanta pecuna manam reqiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesusnam queno qayacorqan: —Wamralläcuna, ¿pescaduta tsariyarqonquicu? —nir. Pecunanam “Manam” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tsenam Jesus nerqan: —Lanchapa derechu caq ladunpa atarayata jitayë. Tsechomi tsariyanqui —nir. Nenqannonam atarayata yacuman jitarcur, atsca pescaduyoq captin, jorqetapis puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesuspa cuyë disipulunnam Pedruta nerqan: —¡Taqeqa Teyta Jesustaq! —nir. Teyta Jesus canqanta musyecurnam, Pedroqa qotuconqan ratashninta yacacurcur, yacuman pinticorqan Jesus canqanman apuradu chärinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquin disipulucunanam lanchachoraq ewayarqan atarayata pescaduntin qarachacushqa. Lamar cuchunman chäriyänanpaqqa manam allapa carunatsu carqan. Juc pachac (100) metrunollam pisherqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lamar cuchunman chärirnam, taririyarqan tantata y nina shancacho pescadu cancacar churarëcaqta. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesusnam nerqan: —Tsariyämonqequi pescaducunapita juc ishqueta apayämï —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tsenam Simon Pedru lanchaman lloqarcur, jorqorqan atarayata patsaman. Pachaq pitsqa chunca quima (153) jatusaq pescadiyoqmi carqan, y tselaya quecaptinpis, ataraya manam racherqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tsenam Jesus nerqan: —¡Shayämï micunapaq! —nir. Y manam ni meqan disipuluncunallapis balorayarqantsu “¿Pitaq canqui?” nir, tapiquita, porqui reqiyarqanmi Teyta Jesus canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesusnam pecunaman witicur, tantata tsarircur pescadullantin qararqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Que topayanqanwanqa quima cutinam cawarimushqanpita Jesus yuriporqan disipuluncunata. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micur ushariyaptinnam, Simon Pedruta Jesus nerqan: —Jonaspa tsurin Simon, ¿quecuna cuyayämanqanpeq mascu qam cuyamanqui? —nir. Pedrunam nerqan: —Aumi, Teyta. ¡Musyanquitaq noqa cuyanqaqta! —nir. Jesusnam nerqan: —Tsepenqa achcasnïcunata cuidanqui —nir ");
INSERT INTO qwhNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jina yapenam Jesus nerqan: —Jonaspa tsurin Simon, ¿cuyamanquicu? —nir. Pedrunam nerqan: —Aumi, Teyta. ¡Qam musyanquim cuyashqaqta! —nir. Jesusnam nerqan: —Tsepenqa üshäcunata cuidanqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yapenam Jesus nerqan: —Jonaspa tsurin Simon, ¿rasonpacu cuyamanqui? —nir. Quima cutina tseno “Cuyamanquicu” nirnin, Jesus tapuptinnam, Pedru llaquicur nerqan: —Teyta, qamqa llapantam musyanqui. ¡Tsemi allapa cuyashqaqtapis musyanqui! —nir. Tsenam Jesus nerqan: —Tsepenqa üshäcunata cuidanqui. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rasonpam neq: Mosuraq carnenqa, quiquiquim ropequicunata yacacurnin, munanqequiman ewarqequi. Peru auquin queniquichonam ricrequita mashtanqui; y jucnam ropequitapis yacatsishunqui; y mana munashqequimanmi apayäshunqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tseno nirninmi, Jesus cäyitserqan Pedru imano wanunanpaq canqanta, y tseno wanurnin, Diospa puedeq queninta nunacunata musyaratsinanpaq caqta. Tsepitanam nerqan: —Ruranqäcunata ruranqui —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tumecurnam, Pedru ricarerqan Jesuspa cuyë disipulun qepancunata ewarëcaqta. Tse disipuloqa senecayaptin Jesuspa laduncho quinquishecur, “Teyta, ¿pitaq qamta ranticushunqui?” nir, tapoq caqmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tseno ricarirnam, Jesusta Pedru nerqan: —Teyta, taqewanqa ¿imataq pasaconqa? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesusnam nerqan: —Que patsaman cutimonqäyaq pe cawananta munaptïpis ¿imata qocushunqui! ¡Qamqa, ruranqäcunata ruranqui! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tseta musyarirnam, Jesusman creyeqcuna queno niyarqan: “Pëqa manash wanonqatsu” nir. Peru Jesusqa manam tse ninantatsu nerqan, sinoqa quenomi nerqan: “Que patsaman noqa cutimonqäyaq pe cawananta munaptïpis, ¿qam imananquitaq!” nerqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Quecuna escribeq disipuloqa llapanta ricashqa carmi, caqllata willacun. Tsenopam musyantsic tse willaconqan rasonpa canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mas atscaran can Jesus rurashqancuna. Tsecunata llapanta jucllellapayan escribiyaptenqa, que patsa manam tincunmantsu tse librucunata churayänanpaqpis.");
INSERT INTO qwhNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Cuyë amigu Teofilo, punta caq librüchomi qamman escribimorqä Teyta Jesus que patsacho quecar asta sieluman cuticonqanyaq, llapan rurashqancunata y yachatsicushqancunata willaparniqui. Pemi manaraq sieluman cuticur, acrashqan apostolnincunata Santu Espiritupa muneninwan dispunerqan imano quecayänanpaqpis. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wanushqanpita cawariramurmi, pecunata yuripur chuscu chunca (40) junaqninpi tuquilayapa cäyitserqan rasonpa cawarimonqanta creyiyänanpaq. Y nunacuna Diospa mandaquinincho imano cayänanpaq caqtam willaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Teyta Jesusmi apostolnincunawan juntu quecarnin, queno mandarqan: —Puntata willayanqaqnomi äniyäshonqequita Papänï qamcunaman cachamonqa. Tsemi tseta manaraq chasquerqa, Jerusalenpita ama yarquyanquiraqtsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Claru parlaquichoqa bautisacoq Juanqa yacullawanmi bautisarqan; peru cananqa ichicllanam pishin Santu Espirituwan qamcuna bautisashqa cayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tsepitanam apostolnincuna juntacärir, Teyta Jesusta tapuyarqan queno: —Tëte, ¿cananqa qamnacu Israel nasionnintsicta punta canqantsicno librina canapaq rescatamunqui? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesusnam queno nerqan: —Ni ime öra ni ime junaq canqantapis qamcuna musyayänequeqa manam presisantsu. Dios Yayallam puedeq car tsetaqa dispunishqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Peru qamcunaqa Santu Espirituta chasquirirmi, poderyoq ticrariyanqui. Tsenam noqa rurashqäcunata willacurnin, puriyanqui Jerusalencho, Judeacho, Samaria marcacunacho; y jinantin munduyaqmi chäratsiyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tseno parlar usharirnam, pecuna ricarëcayaptin, pallaricar sieluman eucorqan; y pucute tsapäriptinnam, manana mas ricayarqannatsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sieluman tseno eucoqta ricarëcayaptinnam, ishcaq nunacuna yulaq bestishqa nopancunaman juclla yurircur, ");
INSERT INTO qwhNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","queno niyarqan: —Galilea nunacuna, ¿imanirtaq sieluta ricarar shäquicayanqui! Tse Jesus rara sieluman pallaricar eucoqta ricayanqequinollam, yape que patsaman cutimonqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olibus nishqan jircacho juntarëcayanqanpitanam, Jerusalenman tse apostolcuna cuticuyarqan. Tse jircapita Jerusalenyaqqa manam carutsu carqan, jamaqui junaqcho puriyänan distansiallam. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalenman chärirnam, posadacuyanqan wayipa altusninman lloqariyarqan. Pecunam cayarqan: Pedru, Juan, Santiagu, Andres, Felipi, Tomas, Bartolome, Mateo, Alfeupa tsurin Santiagu, Seloti grupupita Simon, y Santiagupa tsurin Judas. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pecunam llapancuna juntacar, juc shonqulla imepis Diosman mañacuyaq Jesuspa mamäninwan wauqincunawan y waquin warmicunawan. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tse junaqcunanam Teyta Jesusman pachac ishque chunca (120) creyicoqcuna ellucayashqa quecayarqan. Tsechonam apostol Pedru sharcurcur, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wauqicuna y panicuna, Judas Iscariotim Teyta Jesusta presu tsariyänanpaq nunacunata pushecorqan. Y tse Judaspaqmi Santu Espiritu cäyitsiptin, une rey David willacur escriberqan. Tse escribishqanmi canan cumplicärishqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasqa sirwicoq apostol cananpaq noqacunano acrashqam carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Peru eucurmi, tse pagayanqan qellewan chacrata ranterqan. Tsechonam ure senqapa jeqacurcorqan. Pachan pashtariptinnam aqishnincunapis ramacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Judas tseno wanushqanta musyarirninmi, Jerusalencho yachaq llapan nunacuna tse chacrata jutitsiyarqan ‘Haceldama’ nishpa. Haceldamaqa pecunapa idiomancunacho ‘yawarpa chanin chacra’ ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tsepaqmi Salmu nishqan librucho queno escribirëcan: ‘Täranqan wayim dejarishqa canqa; y manam ni pi täranqanatsu tse wayicho’, nir. Jina quenopis escribirëcanmi: ‘Tse nunapa cargunta jucna chasquitsun’, nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Quechomi quecayan Teyta Jesus que patsacho quecaptin, imepis peta qatirar, noqacunawan juntu pureq nunacuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Tsemi presisan pecunapita jucninta apostol cananpaq churanantsic, Teytantsic wanushqanpita cawarimonqanta noqacunawan willacuyänäpaq. Pecunam bautisacoq Juan bautisanqanpita patsa asta sieluman cuticonqanyaq Jesus rurashqancunata ricayarqan.” ");
INSERT INTO qwhNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tsemi tsecho ellucayashqacunapita acrariyarqan ishcaq nunata: Jose Barsabasta (tse Barsabaspa jucnin jutinmi carqan Justo), y jucnintanam Matias nishqan nunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tsepitanam Diosman mañacuriyarqan queno: —Teytalläcuna, qammi musyanqui llapä nunacuna imano cayanqätapis. Tsemi canan musyecatsiyämë, que ishcanpita meqanta acrarenqequitapis ");
INSERT INTO qwhNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judaspa rantin apostol cananpaq. Pëqa apostol queninta mana cumplirmi, jutsanrecur castiguman ishquishqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mañacur usharirninnam, sortiyariyarqan, y Matiaspaqmi suerti yarqurerqan. Tse örapitam pe yapacärerqan chunca juc (11) apostolcunaman chunca ishque (12) cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","“Pentecostes” nishqan fiesta junaqnam Teyta Jesusman creyicoqcunapis jucllacho ellucashqa quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tseno quecayaptinnam, derepentita sielupita wiyacorqan imeca shucuqui bientunoraq waqaq; y quecayanqan wayi juntam waquecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsellanam ricariyarqan imeca nina rupaqno qalluno qalluno cada nunaman urämoqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tse öram Santu Espiritupa poderninchona ticrariyarqan, y tuquilaya idiomata parlarmi qallecuyarqan segun Santu Espiritu parlatsenqanmanno. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tse junaqcunam jinantin nasioncunapita Jerusalenman ewayashqa quecayarqan Diosta mantsacoq israel nunacuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tseno bullata wiyecurnam, atscaq nunacuna ellucarir, allapa espantacuyarqan, porqui Jesusman creyicoqcunam tse ellucaq nunacunapa idiomancunacho parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tsenam mantsacäcur, quiquincuna pura queno ninacuyarqan: —¿Imanotaq que? ¡Que parlecaq nunacunaqa llapanpis Galilea marcapitataq cayan! ");
INSERT INTO qwhNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Peru ¿imanopataq cananqa cada unupa idiomantsiccho parlayaqta wiyecuntsic? ");
INSERT INTO qwhNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Quechoqa shamushqa quecantsic: Partia marcapita, Mediapita, Elampita, Mesopotamiapita, Judeapita, Capadociapita, Pontupita, Asiapita, ");
INSERT INTO qwhNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptupita, Cirene waq ladun Libia marcapita. Y waquinnintsicqa Romapita shamoqmi quecantsic. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Israelcunapis y mana israel cashpa, israel nunacunano Diosman creyicoqcunapis cayanmi. Creta islapitapis y Arabia nasionpitapis cayanmi. ¡Y llapantsictaq wiyecantsic cada unupa idiomantsiccho Diospa espantepaq rurenincunata parlapëcamanqantsicta! ");
INSERT INTO qwhNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Y llapan nunacunam limpu espantashqa allapa yarpacachar, quiquincuna pura queno tapunacuyarqan: —¿Imanirraq quecuna susedicun! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Peru waquincunanam burlacurnin, queno niyarqan: —¡Que nunacunaqa machashqa carmi tseno parlacuyan! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tseno niyaptinnam, chunca juc (11) apostol mayincunawan quecar, Pedru sharcur nunacunata fuertipa parlaparqan queno: “Tëtecuna, israel casta mayicuna y llapequi Jerusalencho täraqcuna, canan parlacaramonqäta shumaq wiyacur cäyiräyämë. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Noqacuna manam qamcuna pensayanqequino machashqatsu quecayä, porqui qoya las nuebillaraqtaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sinoqa que wiyecayanqequeqa cumplicärin, Diospa une profetan Joel escribishqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Pemi queno escriberqan: ‘Ninmi Dios: Ultimu tiempucunachomi queno pasaconqa: Santu Espiritutam noqa cachashaq llapan nunacunaman. Y qamcunapa tsuriquicunam, warmipis ollqupis, willacuyanqa noqapaq. Jobincunatam rebelashaq, y auquincunatanam sueñïnincunacho parlapäshaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jina warmiman ollqumanpis sirwimaqnïcunamanqa, Santu Espirituta cachashaqmi noqa nishqäta willacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sieluchomi espantaquipaqta ricatsiyashqequi. Y patsachopis tuqui señacunatam ricatsiyashqequi: yawarta, ninata y qoyepita pucuteta. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Intim actsenqanatsu, y quillanam yawarno puca püru ticrarenqa. Tsecuna canqa Teytapa espantaquipaq y presisaq dia del juisiun cananpaq, ichicllana pishicaptinmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pipis Teytaman marcäcur mañacuptenqa, salbashqam canqa’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Tsemi canan parlamonqäta, Israel marca mayicuna, shumaq cäyicayämë: Teyta Dios poderninwan yanapaptinmi, espantaquipaq tuqui señacunata y milagrucunata Jesus rurarqan. Tsenopam musyatsimarqantsic Nazaret marcapita Jesus poderyoq cashqanta. Tsetaqa qamcuna allim musyecayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tseno quecaptinpis, qamcunam entreguecuyarqequi mana alli ruraq nunacunaman, cruscho clabar wanutsiyänanpaq. Tsetaqa unepitana dispunishqa carmi, Diosnintsic musyarqanna. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Peru allapa jipar wanonqanpita libramurmi, Diosnintsic cawariratsimorqan, y manam wanushqallaqa quedacunmantsu carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Porqui tseno cananpaqmi rey Davidpis une tiempucho Jesuspaq queno escriberqan: ‘Musyämi Teytä noqawan imepis quecanqanta; pe yanapamaptinmi, imeca pasamaptinpis, pëcho tsaracü. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tsemi shonqullä allapa cushicun, y tseno cushicurmi alabecü. Jina peman marcäquicarmi, wanucushaqpis.’ ");
INSERT INTO qwhNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jina quenomi rey David escriberqan quiquin Jesus parlecaqno: ‘Porqui qamqa Diosllä manam wanushqacuna cayanqancho dejaramanquitsu, ni jutsannaq sirwishoqniquipa ayan ismunanta permitinquitsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sinoqa qammi wiñe caweman pushamanqui nopequicho cushishqana cacunäpaq’ nir.” ");
INSERT INTO qwhNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tse escritura nenqanta willacurirnam, Pedru queno nerqan: “Marca mayicuna, qamcuna alleqpam musyayanqui une castantsic rey David wanucuptin pampayanqanta. Y canancamayaqmi marcantsiccho riquecantsic sepulturanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Peru Diospa profetan carmi, David musyarqan pepa mireninpita juc yuricoq puedeq mandacoq cananpaq Dios cumplinanpaq änenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidta Diosnintsic rebelashqa captinmi, willacorqan Dios Acrashqan cawarimunanpaq canqanta, y wanushqacuna canqancho mana dejarishqa cananpaq cashqanta. Tsenolla ayanpis mana ismushqa cananpaq cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tse acrashqan Jesustam wanushqanpita Dios cawaritsimushqa. Pe cawarimushqantam noqacuna ricashqa cayä. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tsemi Teyta Jesusta Dios apacushqa pewan juntu mandacuyänanpaq. Y änenqan Santu Espiritutam Jesusta qoycorqan. Penam canan noqacunaman cachamushqa. Tsetam qamcuna riquecayanqui y wiyecayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porqui Davidtsu manam cawarircur sieluman ewarqan. Peru jinam pe escriberqan queno: ‘Diosmi nerqan Teytäta: Eucamï noqawan juntu mandacunapaq, ");
INSERT INTO qwhNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta llapan chiquishoqniquicunata muneniquiman churamonqäyaq’ nishpa.” Tsepitanam Pedru queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel casta mayïcuna, canan rasonpa caqta cäyicuyë: qamcuna tse Jesusta chiquirnin cruscho wanutsiyanqequitam, Dios churarishqa llapan nunacunapa mandacoqnin y Pepa Acrashqan cananpaq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedru tseno niriptinnam, tsecho juntarëcaq nunacuna shonquncunacho nanatsicur allapa llaquicurnin, Pedruta y waquin apostolcunata tapuyarqan queno: —Tëtecuna, tsepenqa ¿imatataq canan ruralläyäshaq? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tsenam Pedru queno yasquerqan: —Llapequicuna, mana alli rureniquicunata dejariyë, y bautisacuyë Jesucristurecur jutsequicunapita Dios perdonecuyäshunequipaq. Tsenam Santu Espirituta qamcunatapis qoycuyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Porqui Diosnintsic äniconqan Santu Espiritoqa llapan acrananpaq caqcunapaqmi: qamcunapaq, mireniquicunapaq y caru marcacunacho cawacoqcunapaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tsenomi Pedru tuquinopa Jesuspaq nunacunata willaparqan, y notificarqan queno: —¡Nunacuna, llutan rurenincunapita witicuriyë, castigashqa mana cayänequipaq! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tsenam Pedru willaconqanman creyicur, bautisaquicuyarqan. Tse junaqmi creyicoqcunaman yapaquecuyarqan quima waranqano (3,000) nunacuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Y apostolcuna yachatsicuyanqanta cäsucurmi, firmi cacuyarqan. Pecunam juntacarnin, juc shonqulla Santa Senata juntu micuyaq, y Diosman mañacur cacuyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tsenam apostolcuna Diospa poderninwan milagrucunata y señacunata rurayaptin, llapan nunacuna mantsacäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Teyta Jesusman llapan creyicoq nunacunam juc shonqunolla cawacuyarqan; y imancunatapis manam quiquincunallapaq canantaqa munayarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Capoqyoqcunam chacrancunata y imancunapis cayäponqanta ranticuyarqan. Tsepa chanintanam raquiyarqan wactsacunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cada junaqmi templuman juntacäyaq. Wayincunachonam imatapis qaranacur, Santa Senatapis rurar, cushishqa juc yarpellana juntu micuyaq, ");
INSERT INTO qwhNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diostam alabayaq; y llapan nunacunam pecunata respetayaq. Y Teytantsic permitiptinmi, Jesusman creyicurnin, salbacur waran waran yapacärëcayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc junaqmi las tres quecaptin Pedruwan Juan ewayarqan templuman. Tse öraqa carqan Diosman mañacuyänan öram. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tsechonam quecarqan yuriquininpita patsa juc coju nuna. Tse nunatam cada junaq apayaq templupa “Shumaqllan” nishqan puncuman. Tsechomi pëqa tse templuman yecoqcunata limushnata mañacoq. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedruta y Juanta templuman yecoqta riquecurninnam, tse nuna rogacur limushnata mañacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsenam pecuna tse cojuta ricaräyarqan. Pedrunam queno nerqan: —Au, nuna, ricayämë —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Cojunam pecunata ricararqan, imallatapis qarayänanta pensar. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peru Pedrunam tse nunata queno nerqan: —Qarayänaqpaqqa manam qellenïcuna ni imäcunapis cantsu. Peru Nazaretpita Jesucristupa poderninmi noqacho, tsetam qoshqequi. Tsemi pepa poderninwan cachacätsishqequi. ¡Canan sharcur purï! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tseno nirirnam, nunapa derechu caq maquinpita sutarcorqan. Tse öram cojupa chaqui moquncuna fuertina ticrarir, alliyärerqan; ");
INSERT INTO qwhNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","y sharcur, juclla saltecur, purir qallecorqan. Tsepitanam cachacashqanta cushicur: “¡Diosqa allapa allim!” nishpa, pintir saltar, pecunawan juntu templuman yecurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tse nuna Diosta alabaqta y sanuna pureqta riquecurninnam, nunacuna ");
INSERT INTO qwhNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","tse pasaquicuptin, espantacur mantsacashqa quedariyarqan. Porqui llapancunam musyayarqan tse nunaqa templupa “Shumaqllan” nishqan puncucho tecullar limushnata mañacoq canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tse cachacashqa nunanam Pedrutawan Juanta manana jaqerqantsu. Tsenam llapan nunacuna espantashqa coripäcuyarqan, pecuna quecayanqan templupa Salomon nishqan coredorman. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tseta riquecurninnam, Pedru queno nerqan: “Israel mayicuna, ¿imanirtaq mantsacashqa ricaräyämanqui, imeca quiquïcunapa podernïcunawan o alli ruraq cayanqärecur noqacuna que nunata cachacäratsiyaptïnopis? ¡Manam tsenotsu! ");
INSERT INTO qwhNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sinoqa une awiluntsic Abraham, Isaac y Jacob adorayanqan Diosnintsicmi permiterqan sirweqnin Jesusta nunacuna alabayänanpaq. Petam qamcuna mana reqeq tucushpa autorida Pilatuman entreguecuyarqequi. Cacharita munaptinpis, manam munayarqequitsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Y Dios mandacushqancunata ruraq y jutsannaq nuna quecaptinpis, pe libri cananpaqqa manam mañacuyarqequitsu; sinoqa mañacuyarqequi juc asesinuta libri cacharinanpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tsenomi wanutsiyarqequi wiñe cawatsicoq Jesusta. Peru Diosmi wanonqanpita cawaritsimushqa. Tsetaqa noqacunam ricashqa cayä. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Que riquecayanqequi y reqiyanqequi nunataqa Jesuspa poderninmi, peman marcäconqanrecur, cachacäratsishqa. Ricayanqequinomi Jesuspa podernin, peman marcäcuptin, pasepa cachacäratsishqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Marca mayicuna, noqa musyämi rurayanqequita. Jesuspaq cuentata mana alleq qocurishpam, qamcuna autoridaniquicunawan wanutsiyarqequi. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Peru tsenopam Dios cumplishqa une profetancunawan willacatsimonqanta. Tse profetacunam queno niyarqan: ‘Dios Acrashqan que patsaman shamurmi, allapa jipanqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tsemi cananqa mana alli rureniquicunata dejarir, Diosman cutiquicuyänequi. Tsenam pe jutsequicunata qonqecur, Teytantsic alli cawaquichona ime örapis catsiyäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Y Diosmi unepita patsa Pepa Acrashqan Jesucristuta que patsaman yape cachamonqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Peru canan presisanmi sielullachoraq Teyta Jesucristu quecanan, asta Dios llapan imecacunatapis alliyätsenqanyaq. Tseno cananpaqmi Dios une tiempucho acrashqan profetancunatawan willacatsimorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tsemi Moisespis une castantsiccunata willarnin, Jesuspaq queno nerqan: ‘Teyta Diosmi shamoq castantsiccunapita pepaq juc willacoqta churamonqa noqatano. Y tse profeta llapan yachatsicushqancunata wiyacur, cäsucuyanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pipis taqe profetata mana cäsucurnenqa, Diosman creyicoqcunapitam raquicar, condenaconqa’, nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tsenomi Diospaq llapan une profetacuna, Samuelpita qallecur, willacuyarqan Jesusta canan tiempucho llapan pasashqancunapaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Diosmi une castantsiccunata änirnin, Abrahamta queno nerqan: ‘Qampa mireniquicunarecurmi enteru munducho nunacuna bendisishqa cayanqa’ nishpa. Tsemi tse profetacuna willacuyanqan canan noqantsiccho cumplicärishqa Jesuswan. ");
INSERT INTO qwhNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Y Diosmi sirweqnin Jesucristuta wanushqanpita cawaritsimur, puntata qamcunaman cachamorqan yanapayäshuptiqui, mana alli rureniquicunata dejayänequipaq.” ");
INSERT INTO qwhNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedruwan Juan nunacunata manaraq parlapar ushayaptinmi, tseman chäquicuyarqan saserdoticuna, templucho wardiacunapa mandacoqnincuna y saduseu nishqan nunacuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedruwan Juanmi nunacunata yachatsiyarqan wanushqanpita Jesus cawarimushqanta. Tseno cawarimipaq yachatsicuyaptinmi, tse autoridacuna allapa ollqushqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tsenam Pedruta Juanta presu tsarircur, apacuyarqan. Peru tardinna captinnam, carselman llawiratsiyarqan waräninyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Peru imano captinpis, Pedru willacushqanta wiyaqcunapitaqa atscaqmi Teyta Jesusman creyiquicuyarqan. Y peman creyicoqcunaqa pitsqa waranqam (5,000) ollqucunalla yapaquecuyarqan, warmicunata ni wamracunata mana yupashpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Waränin junaqnam ellucariyarqan Jerusalencho judio nunacunapa mandacoqnincuna, autoridacuna y ley yachatsicoqcunapis. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tsechomi quecarqan mas mandacoq saserdoti; pepam jutin carqan Anas. Pewanmi jina quecarqan Caifas, Juan, Alejandru, y mas puedeq saserdotipa castancunapis. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsenam Pedrutawan Juanta quecayanqanman qayaratsirnin, queno tapuyarqan: —¿Pi autorisayäshuptiquitaq y pipa poderninwantaq que nunata cachacätsiyarqonqui! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tsenam Pedru Santu Espiritupa poderninwan carnin, queno yasquicamorqan: —Israel marca mayicunapa mandacoqnïcuna y autoridacuna, canan parlacaramonqäta cäyïcayämë. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Qamcunam tapuyämanqui qeshyaq nunapaq alli rurayanqäta y imanopa cachacanqanta musyeta munar. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Llapequicunatam canan willayaq, llapan Israel marca mayintsiccunawan musyayänequipaq. Nazaret marcapeq Jesucristutam qamcuna crusificarnin, wanutsiyarqequi. Petam wanushqanpita Dios cawaritsimushqa. Tse Jesuspa poderninwanmi que nunata cachacätsiyarqö. Ricayanqequinomi quecho shëcan sanuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Diospa palabranmi Jesuspaq iwalatsicur queno nin: Qamcuna wayi ruraqcunam juc rumita, “manam allitsu” nir, jitariyarqequi; peru cananqa tse rumim allapa presisaq mayestra rumi ticrarishqa quecan. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesuspita juc masqa manam pipis cantsu salbamaqnintsic. Porqui Diosmi pellata que patsaman cachamorqan poderninwan salbamänantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tsenam Pedruwan Juan mana educadu quecar ni mana presisaq quecar, mana ichicllapis mantsacurishpa parlayaptin, autoridacuna espantacuyarqan. Y musyariyarqan Jesuspa disipuluncuna cayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jina pecunapa laduncho cachacashqa nuna quecaptinmi, autoridacuna ni imanopa contrancuna queta puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tsemi apostolcunata Sanhedrin nishqan corticho quecayanqanpita waqtaman jorqaratsirnin, quiquincuna puralla parlayarqan ");
INSERT INTO qwhNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","queno: —¿Imatataq que nunacunata rurecuntsic? Jerusalencho llapan nunanam musyariyashqa tse allapa shumaq milagru rurayanqanta. Y noqantsic manam tseta negueta puedintsictsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Peru que pasaconqancunata nunacuna mana willanacur siguiyänanpaq, Pedruta Juanta notificashun cananpita witsepa Jesuspaq manana pitapis willapäyänanpaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsenam apostolcunata waqtapita qayaratsicurnin, queno notificayarqan: —¡Amana ni imata Jesuspaq yachatsicuyanquinatsu, ni willapäcuyanquinatsu! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peru Pedruwan Juannam yasquiyarqan queno: —Mä, qamcuna yarpäcurcuyë. ¿Acasu Diospaq allicu canman, peta mana cäsushpa, qamcuna mandayämanqequita cäsuyapteq! ");
INSERT INTO qwhNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Noqacuna manam upälläcuriyäshaqtsu, ricayanqäta y wiyayanqäta willacurnin —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tsemi tseno notificarirlla, cachariyarqan. Y manam autoridacuna castigayänanpaq ni imanopa acuseta puediyarqantsu. Porqui llapan nunacunam tse pasacushqancunapita Diosta alabayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Porqui Jesuspa poderninwan cachacashqa nunaqa chuscu chunca (40) watanam cojuyashqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedruwan Juannam presu cayanqanpita libri yarqurirnin, ewayarqan yanaqincuna quecayanqanman. Chärirnam, willacuyarqan saserdoticunapa mandacoqnincuna y autoridacuna llapan niyanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tseta willacuriyaptinnam, Diosman juc shonqulla llapan mañacuyarqan queno: —Dioslläcuna, qammi sieluta, patsata, lamar yacuta y tsecho imeca caqtapis camarqequi. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Santu Espiritu musyatsiptinmi, une sirwishoqniqui awilücuna rey David willacorqan queno: ‘¿Imanirtaq nunacuna wäpur sharcucurcuyan? ¿Imanirtaq mana imapaqpis sirweqta rureta munayan? ");
INSERT INTO qwhNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Que patsacho puedeq reycunam listu quecayan, mandacoqnincunawan juntacarcur, Teyta Diospa y Pepa Acrashqanpa contran shäricurcuyänanpaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tsenomi autoridacuna Herodis y Poncio Pilatu que Jerusalen marcacho ellucayarqan caru marca nunacunawan y israel nunacunawan, acranqequi jutsannaq sirwishoqniqui Jesuspa contran cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tsenoqa rurayarqan quiquiquipa muneniquiwan y poderniquiwan unepita patsa dispunishqequi cumplicänanpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Canan wiyequi, tëtalläcuna, autoridacuna mantsacätsipa niyämanqanta. Y callpäcuna sirwishoqniquicunata qoycäyämë, willaquiniquita mana mantsacushpa willacur siguiyänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Qam permitïquï allapa puedeq queniquiwan qeshyacoqcunata cachaquecatsiyänäpaq, y tuqui señacunata milagrucunata jutsannaq sirwishoqniqui Jesuspa poderninwan rurayänäpaq” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tseno mañacur ushariyaptinnam, quecayanqan wayi cuyucurerqan. Tsenam llapancuna Santu Espiritupa poderninwan quedariyarqan. Y mana mantsacushpanam Diospa willaquininta willacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Llapanpis Teyta Jesusman creyicoqcunaqa juc shonqullanam imapis yarpenincunacho cacuyarqan. Manam ni meqancunapis imallapis cayäponqancunata “quiquilläpaqmi” niyarqantsu; sinoqa carqan llapancunapam. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Teyta Jesus cawarimushqanta apostolcuna willacuyanqanqa allapa poderyoqmi carqan. Diosmi pecunata allapa alli queninwan shumaq cawaquicho cacuyänanpaq yanaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Pecunacho manam meqanpis pishipäcoq carqantsu. Porqui capoqyoqcunam, chacrancunata y wayincunata rantiquicur, tsepa chaninta ");
INSERT INTO qwhNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apayarqan apostolcunaman. Pecunanam tse qelleta raquiyarqan segun pishipäyanqanmanno. ");
INSERT INTO qwhNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tsenomi rurarqan Chipre islacho yuricoq Jose jutiyoq levita nunapis. Pepaqmi apostolcuna churayarqan jutin Bernabeta. (Tse juteqa “shoqacoq” ninanmi.) ");
INSERT INTO qwhNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Que nunapam chacran caporqan. Tseta rantiquicurmi, qelleta apostolcunaman entreguecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tsenollam carqan juc nuna Ananias jutiyoq; warminpanam jutin carqan Safira. Jina pecunapis chacrancunata rantiquicuyarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Peru warmi ollqu yachatsinacurirmi, waquin qelleta pacallapa quedatsicur, waquinllatana apostolcunaman apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tsenam Pedru queno nerqan: —Ananias, ¿imanirtaq diablu yecuquicorqon shonqiquiman, chacrequipa chänin qelleta waquinta pacacurcurnin, Santu Espirituta ulipänequipaq? ");
INSERT INTO qwhNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Chacrequi quiquiquipam cashqa. Canan ranticuriptiquipis, tse qelle quiquiquipam. ¿Imanirtaq rasonpa caqta parlacunquitsu! Manam nunacunallatatsu uliparqonqui; sinoqa Diosta uliparqonquim. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pedru tseno nenqanta wiyecurnam, Ananias tsecho ishquirir wanurerqan. Ananias wanushqanta musyarirninnam, llapan nunacuna allapa mantsacäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsenam jobincuna shamicur, Ananiaspa ayanta ratashwan wancurir, wanturcur pampaq apacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsepita quima öratanonam Ananiaspa warmin Safirana chärerqan, qowan wanushqanta mana musyashpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedrunam queno taporqan: —Mä nimë, ¿rasonpacu tse qoyämanqequi qellellacho chacrequicunata ranticuyarqonqui? —nishpa. Safiranam queno yasquerqan: —Aumi, tsellachomi rantiquicuyarqö —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tsenam Pedru queno nerqan: —¿Imanirtaq qowequiwan yachatsinacurir, Diospa Espiritunta ulipar burlacuyarqonqui! Puncuchomi quecayan jobincuna; pecunam cutirayämushqa qowequita pamparir; y cananqa qamtapis apayäshunquim. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tse öram Safirapis Pedrupa nopanman ishquirir, wanurerqan. Jobincuna yecurirnam, taririyarqan Safira wanushqatana. Tsenam ayanta apacuyarqan qowanpa ladunman pampayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tseno pasaquicuptinnam, tseta llapan wiyaqcuna y Jesusman creyicoqcuna allapa mantsacäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nunacuna ricarëcayaptinmi, apostolcuna Teyta Jesuspa poderninwan atsca señacunata y milagrucunata rurayarqan. Y juc shonqullam Jesusman llapan creyicoqcuna templupa Salomon nishqan coredorninman ellucayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Peru creyicoqcunapaq “allapa allim cayan” nicarninpis mantsacurnin, manam pecunaman ni pi juntaquita munayarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Peru imano captinpis, cada junaqmi mas atscaq nunacuna, warmipis ollqupis, Teyta Jesusman creyicur yapacärëcayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tsemi qeshyaqcunata qopincunatawan y cämancunatawan wayincunapita jorqayämoq näniman, tsepa Pedru pasaptin, sombranllapis waquin qeshyaqcunaman charnin, cachaquecatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tsenollam mepitapis tsepitapis llutepa nunacuna shayämorqan Jerusalenman, qeshyaqcunata y supëyoq nunacunata pusharcur; y llapancunam cachacäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tsenam saserdoticunapa mas mandacoqnin y pewan tsecho quecaq saduseu niyashqan nunacuna allapa chiquicurnin, apostolcunapa contran shäricurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tsemi presu tsarïcur carselman llawiratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Peru paqaspanam Diospa anjelnin carselpa puncunta quicharir, pecunata jaqman jorqarir, queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Canan templuman ewar, tsecho nunacunata willapäyë juclaya shumaq cawaquipaq alli willaquicunata.” ");
INSERT INTO qwhNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tsenam qoya qoyallana anjel niyashqanno templuman ewarnin, nunacunata yachatsiyarqan. Tseyaqnam saserdoticunapa mas mandacoqnin y pewan quecaqcuna qayatsiyarqan Israelcho respetashqa tëtacunata Sanhedrin niyashqan Corti Supremacho juc sesionta rurayänanpaq. Tsepitanam wardiacunata cachayarqan carselpita apostolcunata apayämunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pecunanam carselman chärir, apostolcunata manana tariyarqantsu. Tsenam cutirir, queno willacuyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Tëtacuna, carselta alli seguru wichcarëcaqtam y puncucho soldaducuna täpecaqtam tariyarqö. Peru quicharir, manam pitapis ruricho tariyarqötsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tseno willacuriyaptinnam, templucho wardiacunapa capitannin y saserdoticunapa mandacoqnincuna pecunapaq allapa yarpacachar, quiquincuna pura queno ninacuyarqan: —Cananqa, ¿masqui imatanachi rurecayämonqa! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tseno quecayaptinnam, juc nuna chärerqan queno willacur: —Au, tëtacuna, carselman llawitsiyanqequi nunacunaqa canan öram templuchona nunacunata yachatsiquicayan —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsenam templucho wardiacunapa capitannin tsecho wardiacunata pusharcur, jeqarerqan apostolcunata apayämunanpaq. Peru nunacuna qompayänanta mantsarninmi, mana maltratashllapa apayämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chäratsirnam, Sanhedrin nishqan corticho quecaq respetashqa tëtacunaman yecaratsiyarqan. Saserdoticunapa mas mandacoqninnam queno nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Noqacuna michäyarqaqmi tse Jesuspaq mana ni imata yachatsicuyänequipaq. Tseno quecaptinpis, qamcunam yachatsicuyarqonqui jinantin Jerusalen marcacho, asta tumpayämetam munayanqui, ‘Tse Jesusta wanutsiyarqonqui’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tsenam Pedru apostol mayincunawan queno niyarqan: —Nunacunata cäsuyanqäpitaqa, presisanmi puntata Diosta cäsucuyänä. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesustam crusificarnin, qamcuna wanutsiyarqequi. Peru une castantsiccuna adorayanqan Diosmi peta wanushqanpita cawaritsimushqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jesustam Dios churashqa pewan juntu mandacuyänanpaq y Salbadornintsic cananpaq. Israel nasion marca mayicuna, perecurmi jutsantsicta dejashqa, Dios noqantsictapis perdonamäshun. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noqacunam testigu cayä tsecunapita. Tsenollam cäsucoqnincunaman Dios cachamushqan Santu Espiritupis testigu. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tseta wiyecurninnam, autoridacuna feyupa piñarcur apostolcunata wanutsita munayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Peru Sanhedrin nishqan cortichomi leycuna yachatsicoq Gamaliel jutiyoq fariseu nunapis quecarqan. Petam nunacuna allapa respetayaq. Pemi sharcurcur, nerqan juc ratulla waqtaman apostolcunata jorqariyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jorqariyaptinnam, autorida mayincunata parlaparqan queno: —Israel mayïcuna, ¡paqtataq yo tse nunacunata imatapis rurecuyanquiman, mana alleq musyarishpa! ");
INSERT INTO qwhNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Canan yarpäyë: Puntatam juc nuna Teudas jutiyoq yurimorqan. Tse nunam alabacur ‘Puedeqmi cä’ niptin, chuscu pachaq nunacuna Teudas nenqanta creyir, qatiyarqan. Tsepitanam Teudasta wanïcatsiyaptin, qateqnincuna limpu witsicar eucuyarqan. Y tsellachomi ushacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsepitanam sensu canqan tiempucho Galilea marcacho yuricoq Judas jutiyoq nuna yurimorqan. Pepis parleninwanmi nunacunata creyitserqan qatiräyänanpaq. Peru petapis wanicatsiyarqanmi; y llapan qateqnincunam witsicariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tsemi canan willapäriyaq. Que nunacunataqa ama imatapis rurayëtsu. Pecunata dejariyë; porqui quiquincunapa muneninllata rurayaptenqa, yachatsicuyanqan ushacärenqam. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Peru sitsun Dios mandacushqancunata que nunacuna rurayanqa, manam ni imanopa ushacätsita puediyanquitsu. ¡Paqtataq, Diospa contran imatapis llutata rurecayanquiman! —nishpa. Gamaliel nenqanta pecuna cäsucuyarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tsepitanam apostolcunata waqtapita qayaratsirnin, alli buenu astacacharcatsir, notificayarqan Jesuspaq manana mas yachatsicuyänanpaq. Tsepitanam librina cachariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tsenam apostolcuna yarquriyarqan Sanhedrin nishqan cortipita. Peru allapam cushicuyarqan, Dios permitiptin Teyta Jesusrecur maqar ushashqa sufriyanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Y cada junaqmi templuchopis y wayin wayin purirpis, willacur yachatsicuyaq alli willaquita Teyta Jesus Dios Acrashqan canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tse junaqcunam Teyta Jesuspa qatiraqnincuna allapa miracurcuyarqan. Tsechonam griegu idioma parlaqcuna hebreu parlaqcunapita quejacuyarqan queno: —¿Imanirtaq cada junaq imapis raquinaquicho noqantsiccho biudacunata iwalqa atiendiyantsu? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tseno quejacuyaptinnam, chunca ishque (12) apostolcuna Jesusman llapan creyicoqcunata qayaratsir, queno niyarqan: —Wauqicuna, Diospa palabranta willacuyaptïmi, tiempücuna cantsu biudacunata quiquïcunaraq atiendiyänapaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tsemi cananqa qamcunapita acrayämunqui alli reqiyanqequi qanchis nunacunata. Tse nunacuna cayätsun Santu Espiritupa poderninwan alli cawacoq y alli cäyicoqcuna. Pecunatanam churashun tsecunata cuentatsacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noqacunanam Diosman mañacurnin y palabranta yachatsicurllana, siempri siguiyäshaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tsenam llapancuna “Allim canqa” nirnin, acrariyarqan Estebanta; pëqa llapan shonqunwan Teyta Jesusman creyicur, Santu Espiritu munashqanno cawacoq nunam carqan. Y tsenollam acrayarqan: Felipita, Procoruta, Nicanorta, Timonta, Parmenasta y Nicolasta. Nicolasqa Antioquia marcapeq nunam carqan. Pëqa mana israel nuna quecarninpis, puntatanam israel nunacunano Diosman creyicushqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tse qanchis nunacunata acrarïcurnam, apostolcunaman pushayarqan. Apostolcunanam tse nunacuna mandacuyänanpaq Diosman mañacurir, pecunaman maquincunata churarnin, bendisicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tsenam Diospa palabranta mas wiyacurnin, Teyta Jesusman creyicoqcuna allapa atscaq Jerusalencho miracäyarqan; asta saserdoticunapis atscaqmi Jesusman creyicur cäsucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanmi Diospa alli quenin y podernin pëcho captin, shumaq tuquilaya señacunata y milagrucunata nunacuna nopancho rurarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Y Jerusalenchomi carqan Libraducunapa niyashqan ellucayänan wayi. Tsechomi ellucayaq Cirenepita, Alejandriapita, Ciliciapita y Asia marcacunapita esclabu cayanqanpita libracur shamushqa nunacuna. Pecunapitam waquincuna Estebanman ewar, pewan liryacurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Peru yacheninwan y Santu Espiritupa poderninwan Esteban parlaptinmi, tse nunacuna mana ni imanopa contesteta puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsenam juc nunacunata paguecurnin, yachatsiyarqan Estebanpa contran ulicurcur, queno niyänanpaq: —Rasonpam noqacuna wiyayarqö mana allicunata Moises escribenqan leypa y Diospa contran que nuna parlaqta —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tseno nirnam, respetashqa tëtacunata, ley yachatsicoqcunata, llapan nunacunatawan llutepa piñarcatsiyaptin, Estebanta tsarïcur, apayarqan llapan autoridacuna ellucayänan Sanhedrin nishqan cortiman. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tsemannam apayarqan Estebanta ranticoq uli testigucunata pepa contran queno declarayänanpaq: —Que nunam sagradu templuntsicpaq y Moises escribishqan leynintsicpaq imepis llutacunata parlaquican. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jina quenopis parlaqtam wiyayarqö: Nazaret marcacho täraq Jesusshi que mas presisaq templuntsicta limpu juchurenqa; y Moises yachatsimashqantsic costumbrintsictash cambiarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tsenam Sanhedrin nishqan corticho Estebanta ricararnin, llapan quecaqcuna qaqllanta riquecuyarqan imeca anjelpatanoraq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tsenam saserdoticunapa mas mandacoqnin Estebanta taporqan: —¿Rasonpacu que nunacuna niyanqanno qam ruranqui? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estebannam queno yasquerqan: “Respetashqa tëtacuna y israel marca mayicuna, canan parlapäyanqaqta wiyaräyämë: Une castantsic Abrahamtam manaraq Haran nishqan marcaman ewar, Mesopotamia nishqan marcallachoraq quecaptin, allapa puedeq Diosnintsic yuripur, queno parlaparqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Abraham, que marcata y castequicunata jaqirïcur, ewaquï pushanqaq sitiuman’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tsenam Caldea nishqan marcapita Haran marcaman eucorqan. Tse marcacho yachecaptinnam, papänin wanuquicorqan. Tsepitanam Abrahamta Dios pushacamorqan que yachecanqantsic marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Peru tsepin Abrahamta Dios manaran chacran qorqanraqtsu, ni juc japarquillatapis. Peru änerqanmi peta y mirenincunata que marcacunata qonanpaq, manaraq tsurin quecaptinpis. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jina quenopis Dios nerqanmi: ‘Tse castequicunam forasteruno caru marcacho yachayanqa; chuscu pachaq watanpim melanashqa y allqutsashqa sirwipacoq esclabu cayanqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Peru noqam jusgar castigashaq tse allqutsaqnin nunacunata. Tsepitaran tse marcapita castequicuna librina shayämonqa que marcaman, y quechonam adorayämanqa’ nishpam. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Änishqanchomi Abrahamta Dios mandarqan, llapan ollqu wamra yuricoqcunata señalatsiyänanpaq. Tsemi Isaactapis yuriconqanpita puwaq junaqllata Abraham tseno señalarqan. Tsenollam Isaacpis rurarqan tsurin Jacobta; jina Jacobpis tsenomi rurarqan chunca ishque (12) tsurincunata. Pecuna cayarqan Israelcho chunca ishque (12) casta nunacunapa tëtancunam. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tse nunacunam wauqincuna Joseta chiquiyarqan. Tseno chiquir embidiosu carmi, esclabupaq rantiquicuyarqan Egiptu nasionman apacuyänanpaq. Peru Josetaqa Diosmi yanaparqan, ");
INSERT INTO qwhNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","imeca desgrasiacunacho jipaptinpis, librarqanmi. Y rey faraonpa nopancho allapa cäyicoq cananpaqmi, Dios yachenin qorqan. Tsemi rey faraon churarqan Egiptu nasioncho y palasiuchopis mandacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tsepinmi amruna jipaqui watacuna carqan Egiptucho y Canaan nishqan marcacunacho. Tsemi une castantsiccuna micurcuyänanpaq mana pasepa ni ima carqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Peru Egiptucho trigu canqanta musyarirninnam, Jacob cacharqan tsurincunata trigu ranteq. ˻Pecunam cayarqan castantsiccuna.˼ Tse ewayanqanqa primera besmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ishque cuti ewayanqanchonam pecunata Jose willarqan wauqincuna cashqanta. Y tsenopam rey faraon musyarerqan Josepa castancuna cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsepitanam Jose qayatserqan papänin Jacobta y llapan castancunata Egiptuman eucuyänanpaq. Tse ewaqcuna cayarqan qanchish chunca pitsqa (75) nunacunam. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tsemi Jacob llapan castancunawan Egiptuman täraq eucorqan. Tsechonam Jacob y castantsiccunapis wanucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wanucuyaptinnam, ayancunata apacuyarqan Siquem nishqan marcaman pampecuyänanpaq. Tse sepulturatam tëtantsic Abraham Hamor jutiyoq nunapa tsurincunapita chaniyoqcho rantishqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abrahamta Dios änishqanta cumplinanpaq ichicllana pishicaptinnam, Egiptu marcacho Israel casta nunacuna llutepa miracurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tsepinmi Egiptucho rey jucna quecarqan. Tse mandacoqqa manam reqerqantsu Joseta. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tse reymi engañuwan llapan castantsiccunata allapa allqutsarqan; y wamracuna wanuyänanpaqmi tseraq yureq llullu wamrancunata jaqiriyänanpaq mandacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tse tiempum Moises yuriquicorqan. Pëqa allapa shumaqllallanmi Diospaq carqan. Y quima quillallam mamänin wayincho caratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tsepitanam wamrata jaqiriyaptin, rey faraonpa warmi tsurin tariquicur, wayinman apacorqan quiquinpa wawantano wätacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsemi Moisesqa Egiptucho llapan imatapis yachatsiyanqancunata yachacorqan; y allapa reqishqa nunam carqan parleninrecur y rureninrecur. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chuscu chunca (40) watayoq quecarninnam, Moises munarqan Israel marca mayincuna watucaq eweta. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tsenam pecunaman ewarnin, riquecorqan marca mayin nunata juc Egiptu nuna maqaquicaqta. Tsenam marca mayinpa biennin yarqur tse Egiptu nunata maqarnin wanupuquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisesqa pensarqan marca mayincunata librananpaq Dios peta churashqanta cuentata qocuyänantam; peru pecuna manam ni ichicllapis cuentata qocuyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Waräninnam Moises ishcaq marca mayincunatana quiquincuna pura pelyaquicaqta tarïcorqan. Y tse nunacunata washeta munarninnam, nerqan: ‘Au, nunacuna, ¿imanirtaq tse castalla quecarnin, maltratanacur maqanacuyanqui?’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tsenam yanaqinta maqaquicaq nuna Moisesta juclla cumarirnin, nerqan: ‘¿Pitaq qamtaqa noqacunacho mandacoq y jues canequipaq churashorqonqui? ");
INSERT INTO qwhNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿O qanyan Egiptu nunatanocu noqatapis wanuratsimeta munanqui?’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tse nenqanta Moises wiyecurnam, Madian nishqan marcaman safar eucorqan. Tsechonam forasteruno täcorqan y ishque tsurincunam tse marcacho yuriquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Tsepita chuscu chunca (40) watatanam Sinai nishqan tsunyaq jircapa laduncho shira casha rupecaqcho Moisesta juc anjel yuripïcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tse nina rupecaqta riquecurnam, Moises espantacorqan. Y mas nopanman ricananpaq witïcuptinnam, Dios queno parlapëcorqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moises, noqaqa une castequicuna Abrahampa, Isaacpa y Jacobpa Diosninmi cä’ nishpa. Tseta wiyecurninnam, Moisesqa mantsaquewan catatarnin, ni balorninpis carqantsu ricananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tsenam Dios yape queno parlaparqan: ‘Llanqiquita qotuquï; porqui jaluranqequi patsaqa sagradum. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Alleqpam ricarqö sirwimaq israel nunacuna Egiptucho allapa allqutsashqa cayanqanta. Pecuna llaquishqa mañacayämonqantam wiyarqö. Tsemi pecunata libranäpaq shamorqö. Canan ewë, noqam Egiptu marcaman cachaq’, nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moisesta despresyarnin ‘¿Pitaq qamta churashorqonqui mandayämaqnïcuna y juesnïcuna canequipaq?’ nicayaptinpis, petam Dios shira casha rupecaqcho anjelninwan yuriputsir, cacharqan mandaqnincuna y libraqnincuna cananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jina pemi jorqamorqan Egiptupita une castantsiccunata, Diospa poderninwan tuquilaya señacunata y milagrucunata rurarnin. Tsenollam ‘Puca Lamar’ nishqanchopis, y tsunyaq jircacunacho chuscu chunca (40) watanpi quecayaptinpis rurarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jina quiquin Moisesmi Israel marca mayincunata queno nerqan: ‘Noqantsic castapitam Dios cachamonqa noqatano profetata; ˻petam cäsuyanqui˼’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisesmi jina quecarqan tsunyaqcho une castantsiccunawan juntu. Jina petam Sinai nishqan jircacho anjel parlaparqan. Y pemi chasquerqan alli cawacunapaq willaquicunata noqantsicta willamänantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Peru Moises willacushqanta une castantsiccuna manam cäsuyarqantsu. Y munayarqan Egiptu marcaman cutiquitam. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tsemi Aaronta niyarqan: ‘Diosnintsiccuna ruramï pushamänantsicpaq; porqui manam musyantsictsu Egiptu marcapita jorqamaqnintsic Moisesta ima pasashqantapis’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsenam tse junaqcuna orupita juc wishipa imajinta rurayarqan. Tsepitanam animalcunata pishtar, tse imajinpaq juc fiestata rurayarqan, tse quiquincuna rurayashqan imajinta sumätsirnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tsemi Dios pecunapita raquicacurerqan y dejarerqan, sielucho qollurcunata adorarnin cacuyänanpaq. Tsemi escribirëcan Diospaq une profetacunapa libruncho, queno: ‘Israel nunacuna, tsunyaq jircacunacho chuscu chunca (40) wata quecarnin, manam noqapaqtsu qareniquicunata apayämorqequi; ");
INSERT INTO qwhNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","sinoqa imajin Molocpaq wayin rurecurmi, puritsicuyarqequi. Tsenollam jina Refanpa estrellantapis rurecur, diostano adorar, tse imajincunata puritsicuyarqequi. Tsecunataqa quiquiquicunam adoracuyänequipaq rurayarqequi. Tserecurmi qarquriyashqequi Babilonia marcapa wac ladunman, tsecho forasteru cayänequipaq’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Une castantsiccunapam carpapita rurashqa Diospaq musyatsicoq inglisiancuna tsunyaqcho cayäporqan. Y imanopis rurananpaq Moisesta Dios ricatsishqannomi, tse inglisiata rurayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tse inglisiatam une awiluntsiccuna erensiatano chasquiyarqan. Y Dios yanapayaptinmi, tse marcacunacho täraq nunacunata qarqur shamurnin, Josuewan shamoq nunacuna unena tse inglisiata apayämorqan. Tsenopam tse marcacunacho dueñu ticrarir, carpallapita rurashqa inglisiata catsiyarqan, asta rey Davidpa tiempunyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Rey Davidtaqa Diosmi imecachopis yanaparqan. Tsemi munarqan Jacob adoranqan Diosnintsicpaq juc jatun templun rurecapita. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Peru Davidpa tsurin rey Salomonran tse templutaqa ruratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tseno quecaptinpis, sielucho quecaq Diosqa manam nunacuna rurayashqan templucunallachotsu täran. Tsemi Diosnintsicpa une profetanpis queno willacun: ");
INSERT INTO qwhNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Rara sielupitam mandaquicä; y patsacho llapan imapis caqcunaqa munenïllachomi quecayan. ¿Acasu nuna ruranqan inglisiallachocu noqa yachashaq! ¿Qamcuna pensayanqui tsellacho cacunätacu! ");
INSERT INTO qwhNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Manacu noqa llapan imecacunatapis camashqa cä!’ nishpam, nin Dios.” ");
INSERT INTO qwhNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tseno nirirnam, Esteban queno nerqan: “Peru qamcunaqa allapa torpi Diosta mana cäsoq nunacunanomi rumi shonqu cayanqui; y manam ni wiyaq tucuyanquipistsu. Tseno carmi, une castequicunano Santu Espiritupa contran caquicayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Acasu castequicuna Diospa une profetancunata jucllellatapis alli tratayarqancu! Antis Jutsannaq Shamoq nunapaq willacoqcunatapis wanutsiyarqanmi. Y qamcunanam tse quiquin Jutsannaq Shamoq nunata traisionar, wanuratsiyarquequi. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Y anjelnincunawan mandamientuncunata qamcunaman Dios apatsimushqa quecaptinpis, manam cäsucuyashqatsu cayanqui” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban tseno nenqanta wiyecurnam, autoridacuna quiruncunatapis uchurraq shonquncunacho mas feyupa coleracurcuyarqan Estebanpa contran. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Peru Estebanqa Santu Espiritupa poderninwan carmi, rara sieluman ñuquircur, riquecorqan chipapëcaq Diospa glorianta y Teyta Jesusta Dioswan juntu quecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tsenam Esteban queno nerqan: —Rara sielutam quicharëcaqta canan ricarëcä, y Diospita Shamushqa Nunanam Dioswan juntu quecan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Esteban tseno nïcuptinnam, parlanqanta mana wiyayänanpaq rinrincunatapis tsapacurcurnin, qaparir qayarir coripäcuyarqan Estebanta tsaricurcuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tsarircurnam, tse marcapa jacninman jorqurir tsampiquicuyarqan. Tse uli testigucunanam juc jobin Saulu jutiyoqta acshunancunata umpacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tsampiquicayaptinnam, Esteban queno mañacorqan: —Teyta Jesus, almalläta chasquiquï. ");
INSERT INTO qwhNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tseno nirirninnam, qonquriquicur, fuertipa queno nerqan: —¡Teytallä, ama que jutsa rurayanqanta cuentapaqpis churëtsu! Tseno nirirllänam, wanurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tse jobin Saulu acuerdum carqan Estebanta wanutsiyanqanwan. Tse junaqpitam Jerusalencho qallaquicuyarqan Teyta Jesusman creyicoqcunata, imanopapis ushacätsita munar. Tsenam llapan creyicoqcuna witsipa witsir, eucuyarqan enteru Judea y Samaria marcacunapa; peru apostolcunaqa Jerusalenchomi quedacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Diosnintsicta adoraq waquin nunacunanam Estebanta pampecuyarqan; y allapam llaquicur, waqayarqan Estebanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tseyaqnam Sauloqa creyicoqcunata ashir chiquir qaticacharqan, wayin wayin yequicuryanmi, warmitapis ollqutapis qaracharcuryan jorqamurnin, carselman llawiyänanpaq apatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Peru Jerusalenpita witsicar eucoqcunanam jinantinpa ewarnin, mecho tsechopis alli willaquicunata willapäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pecunachomi carqan Felipi jutiyoq nuna. Pemi Samaria marcaman ewarnin, nunacunata willaparqan Dios Acrashqan Jesucristupaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tsemi llapan nunacuna Felipi willapäconqancunata wiyar, y espantaquipaq milagrucunata ruraqta ricarnin, allapa shumaq wiyacur cäsucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Porqui supëyoq qeshyaquicaq atscaq nunacunapitam supëcuna qaparir qayarir yarquyarqan. Y atscaqmi chancancuna ricrancuna ellucashqa qeshyaquicaqcuna y cojucunapis cachacashqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tseta ricarninmi, tse marcacho nunacuna allapa cushicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Peru tse marcachomi carqan juc echiseru Simon jutiyoq nuna. Tse nuna unepita brujeriacunata ruraqta ricarninmi, enteru Samaria marcacho nunacuna espantacuyarqan. Y tsemi tse bruju nerqan: —Noqaqa allapa yachaq nunam cä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tse echiserutam llapan nunacuna ichicpis jatunpis shumaq wiyacuyaq; y quenomi niyarqan: —¡Caq quemi cananqa Diospa allapa puedeq quenin! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pe nishqantam allapa cäsucuyaq porqui unepita patsam, brujeriancunata ruraptin, nunacuna allapa espantacuyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Peru Diospa mandaquininpaq alli willaquicunata Felipi willacuptinmi, y Teyta Jesucristupaq willapäcuptinmi, tseta creyicurnin, nunacuna warmipis ollqupis bautisacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Asta tse bruju Simonpis Teyta Jesusman creyicurninmi, bautisacorqan. Tsepita patsam Felipita tse bruju qatiräcorqan. Tuquilaya señacunata y milagrucunata Diospa poderninwan ruraqta ricarninmi, limpu espantacushqa cacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria marcacho nunacuna Diospa alli willaquininman creyicuyashqanta musyarirninnam, Jerusalen marcacho quecaq apostolcuna Pedruta y Juanta tseman cachayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chärirnam, tse apostolcuna Diosman mañacuyarqan tse creyicoqcuna Santu Espirituta chasquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porqui manaran ni meqanman Santu Espiritu urämorqanraqtsu; sinoqa Teyta Jesusman creyicushqa carllam, bautisacushqa cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tsemi Pedruwan Juan tse creyicoqcunaman maquincunata churayaptin, Santu Espirituta chasquiriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Bruju Simonnam tse creyicoqcunaman apostolcuna maquincunata churayaptin, Santu Espirituyoq ticrareqta riquecur, qelleta pagueta munarqan apostolcunata, ");
INSERT INTO qwhNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","queno nishpa: —Tse poderta rantiquecalläyämë, noqapis maquïta pimanpis churaptï, tsenolla Santu Espirituyoq ticrariyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tsenam Pedru queno nerqan: —Diospa qarenin poderta rantita munanqequirecurmi, qelleniquiwan ishquequi infiernuman ewayanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Quecunaqa manam qampaqnotsu. Porqui shonqiquicho mana alli yarpanqequim, Diospaqqa melanepaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Antis tse mana alli yarpanqequita qonqequï; y Diosta rogacurnin, mañaquï itsapis perdonecushunquiman shonqiquicho tse mana alli pensanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porqui embidiosu car allapa colerawan bochornashqatam y mana allicunapa munenincho caquicaqtam cäyipëcaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tsenam bruju Simon queno nerqan: —Tsepenqa Diosman noqalläpaq mañaquecalläyämï, niyämanqequino mana imapis pasallämänanpaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedruwan Juan Diospaq tsecho willapäcur yachatsicurirnam, Jerusalenman cuticuyarqan. Tse cuticurnam Samaria marcacunapa pasarnin, Jesuspa alli willaquininta willacur willacur eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tsecuna pasacushqanchonam Dios cachashqan anjel Felipita queno nerqan: —Felipi, canan ewë sur ladupa, Jerusalenpita Gaza marcaman ewaq nänipa. Tse näneqa tsunyaqcunapam pasan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tse öram Felipi sharcur eucorqan; nänichonam taripärerqan Etiopia nasionpita nunata. Pëqa carqan tse nasioncho reina Candacepa presisaq tesorerunmi. Tse nunam Jerusalenman ewashqa carqan Dios adoraq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pemi Jerusalenpita marcanman cutiquicar caretancho tëcarnin, leyicarqan Diospa profetan Isaias escribishqan libruta. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Santu Espiritunam Felipita queno nerqan: —Felipi, taqe caretayoq nunaman witï, pewan juntu eucuyänequipaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tsenam Felipi tse Etiopia nasionpeq nunaman mas witïcur, wiyecorqan Diospa profetan Isaias escribishqan libruta leyicaqta. Tsenam queno taporqan: —Tëte, ¿tse leyenqequita cäyinquicu? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tsenam queno yasquerqan: —¿Imanoparaq cäyishaq, pipis mana cäyicatsimaptin! —nishpa. Nirirnam, Felipita rogarqan, caretanman lloqarcur, ladunman täcurinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tse nuna Diospa palabranta leyicanqanqa quenomi carqan: “Imeca üshata wanutsiyänanpaq, camalman apaqnomi apayarqan wanutsiyänanpaq. Rutuyaptin üsha mana waqaqnomi, upälla wiyaräcorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Allqutsashqam carqan; justisiapis pepaqqa manam carqantsu. Que patsacho caweninpitam wanuratsiyarqan; y mananam mireninpis carqannatsu.” ");
INSERT INTO qwhNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Leyir usharirnam, tse nuna taporqan Felipita queno: —Ama acseqa quëtsu, cäyicatsillämë. ¿Pipaqtaq Diospa une profetan tseno escriberqan? ¿Quiquinpaqcu, o juc nunapaqcu? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tsenam leyenqanpita qallecur tse Etiopia nunata Felipi shumaq cäyitserqan Teyta Jesuspaq alli willaquicunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tseno ewarëcarnam, chäriyarqan yacu canqan sitiuman. Tse Etiopia nunanam Felipita queno nerqan: —Quechomi yacu can. ¿Manacu canan juclla bautisecallämanquiman? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","˻Tsenam Felipi queno yasquerqan: —Teyta Jesucristuman rasonpa llapan shonqiquiwan creyicuptiqueqa, allim canqa —nir. Tse nunanam queno nerqan: —Aumi, noqa creyïmi Teyta Jesucristu Diospa tsurin cashqanta —nir.˼ ");
INSERT INTO qwhNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tseno nirirnam, tse nuna caretanta päraratsiptin, ishcan yarpuriyarqan yacu caqman. Tsechonam Felipi bautisarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yacupita yarquriyaptinnam, Diospa Santu Espiritun Felipita juclla apacorqan. Tsenam tse etiope nuna manana Felipita ricarqannatsu; peru allapa cushishqam eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipinam Azoto nishqan marcacho quecarna, mäcaramorqan. Tsechonam marcan marcan willacorqan Teyta Jesuspa alli willaquinincunata asta Cesarea marcaman chanqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tseyaqnam Sauloqa, “cananmi siqa musyayämanqa” nishpa, Teyta Jesusman creyicoqcunata wanutsita munar puriquicarqa. Tsemi saserdoticunapa mas mandacoqninman ewar, ");
INSERT INTO qwhNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ordenta mañacorqan Damasco marcapa ellucayänan wayicunacho mandacoqcuna permisuta qoyänanpaq. Tsenopa Teyta Jesusman creyicoqcunataqa tarir, warmitapis ollqutapis Jerusalenman presu apatsinanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Peru Damasco marcaman yecurëcaptinnam, derepentita rara sielupita actsicamorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsenam Saulu patsaman ishquirerqan. Jitarëcarninnam, wiyecorqan queno parlapaqta: —Saulu, Saulu, ¿imanirtaq jipatsimar, allqutsamanqui? ");
INSERT INTO qwhNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulunam queno taporqan: —¿Pitaq canqui, Teyta? —nishpa. Niptinnam, queno yasquerqan: —Allqutsanqequi Jesusmi noqaqa cä. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Peru canan sharcur ewecanqequi puebluman yequï. Tsechomi niyäshunqui imata ruranequipaqpis —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Y Sauluwan ewaq nunacunanam tseno parlamoqta wiyecur, mana pitapis ricar, mantsaquewan ni ima rureta puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulunam jitarëcanqanpita sharcurerqan; peru nawin quicharëcaptinpis, manam ni imata riqueta puederqantsu. Tsenam jancharishqallana Damasco marcaman chäratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tsechomi quima junaqninpi wiscuyashqa cacorqan. Manam pachatapis micorqantsu; ni yacutapis uporqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tse Damasco marcachomi Teyta Jesusman creyicoq Ananias jutiyoq nuna carqan. Petam Teyta Jesus rebelarnin, queno qayecorqan: —¡Ananias! —nishpa. Ananiasnam yasquerqan: —Wiyecaqmi, Teyta —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Teyta Jesusnam queno nerqan: —Canan ewë Derechu nishqan callipa, Judas jutiyoq nunapa wayinman. Chärirna tapucunqui Tarsu marcapita Saulu jutiyoq nunapaq; porqui tse nunam canan öra noqaman mañaquecamun. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Pemi rebelasionnincho ricashqa, qam ewecur maquiquita peman churaptiqui, podernïwan nawin sanu ticrarenqanta —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tseta wiyecurnam, Ananias queno nerqan: —Peru Teyta, tse nunapaqqa atscaq nunacunam willayämashqa, mana allita rurar qamman creyicamoqcunata Jerusalencho allapa allqutsanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","¡Y canannam queman chäramushqa saserdoticunapa mandacoqnincunapa ordenninwan qamman creyicoqcunata llapäta presutsiyämänanpaq! ");
INSERT INTO qwhNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Peru Teyta Jesusnam queno yasquerqan: —Canan ewë, porqui tse nunataqa noqam acrashqa cä. Jinantin nasioncunapa ewarnin, israel mayincunata y mana israel caqcunatapis puedeq autoridanincunatawan noqapaq willapänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Y noqam musyatsishaq imecatapis noqapaqrecur sufrinanpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsenam Ananiasqa Saulu quecanqan wayiman ewarqan. Yecurirnam, Sauluman maquinta churar, queno nerqan: —Wauqi Saulu, que marcaman shamïcaptiqui, nänicho yuripushoqniqui Teyta Jesusmi cachamarqon wiscu canqequipita poderninwan ricachacurinequipaq. Y cananpita witsepam Santu Espiritupa poderninchona ticrarinqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tse öram Saulupa nawinpita shicwarerqan imeca pescadupa escamannoraq; tsellanam ricachacurerqan. Tsepitanam sharcurirnin, bautisacurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pachan micuriptinnam, callpan yurirerqan. Tse junaqcunam Damasco marcacho täraq creyicoqcunawan Saulu quedecur, ");
INSERT INTO qwhNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","qallaquicorqan willacurnin Teyta Jesus Diospa tsurin cashqanta ellucayänan wayicunacho. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulu parlanqanta llapan wiyaqcunanam espantacur, queno ninacuyarqan: —¡Que nunam Jerusalencho Teyta Jesusman creyicoqcunata ushacätsita munarqan! ¡Jina canannam shamorqon que Damasco marcacho creyicoqcunatana Jerusalencho saserdoticunapa mandacoqnincunaman presu apananpaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Peru Sauloqa imano captinpis cada bes masmi poderyoq ticraquicarqan. Tsemi Teyta Jesus Dios Acrashqan cashqanta tuquinopa willapäcuptin, Damasco marcacho israel mayincunapis ni imano queta puediyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tse junaqcuna pasariptinnam, israel nunacuna yachatsinacuyarqan Sauluta wanicatsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Paqasta junaqtam shuyaräyarqan Damasco marcapa murallanpa puncuncunacho Sauluta wanutsiyänanpaq; peru Sauloqa tseta musyarerqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Y Teyta Jesusman creyicoqcunanam Saulutaqa canastaman winarcurnin, murallapa jaqninman cacharpayämorqan paqaspa. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jerusalenman chärirnam, Sauloqa imanopapis tïrarqan tsecho creyicoqcunawan juntaquëta. Peru llapancunam mantsayarqan, porqui manam creyiyarqantsu pepis Jesusman creyicoqna canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tseno quecaptinpis, Bernabemi Sauluta apostolcuna caqman pusharnin reqinacatserqan. Pecunatam Bernabe willarqan Sauluta, Damasco marcaman ewecaptin, Teyta Jesus yuripur parlapanqanta y riqueconqanta. Y tsenollam willacorqan Damasco marcacho quecarnin, Saulu mana mantsacushpana Teyta Jesuspaq willaconqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tsenopam Saulu quedacorqan pecunawan. Y mana imatapis mantsacushpam Jerusalencho jinantinpa purerqan, Teyta Jesuspaq willapäcurnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Y tsecho griegu idioma parlaq israel nunacunawanmi parlar discutir cayarqan. Peru pecunanam imanopapis Sauluta wanutsita munayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tseta musyarirninnam, Jesusman creyicoq wauqicuna Cesarea marcaman pushecur, despachecuyarqan Tarsu marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsepitaqa llapan Judea, Galilea y Samaria marcacunacho creyicoqcuna pipis mana ultrajashqanam cawacuyarqan. Y Santu Espiritupa poderninwan mas firmi cayaptinmi, Teyta Jesusman creyicur pecunaman mas yapaquecuyarqan, Diosnintsicta mantsacur. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Apostol Pedrunam Jesusman creyicoqcunata jinantincho watucar purirnin, Lida marcacho täraq creyicoqcunamanpis chärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tsechomi tarerqan Eneas jutiyoq nunata. Tse nunam puwaq watana qeshyar camaräcorqan, chancancuna ricrancuna mana fuegaptin. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tse nunatam apostol Pedru queno nerqan: —Eneas, Teyta Jesucristum cachacätsishunqui. Canan öra sharquï y camequita ellupäquï —nishpa. Tse öram Eneas sharcurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tsenam Lida y Saron marcacunacho llapan nunacuna tse nuna sanuyashqata riquecurnin, mana alli rurenincunata jaqirir, Teyta Jesusllamanna creyiquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope marcachonam Teyta Jesusman creyicoq Tabita jutiyoq juc warmi carqan. Tabitaqa griegu idiomacho Dorcas ninanmi. Tse warmim allapa allicunata ruraq, y wactsacunatapis puedenqanpam yanapaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tse junaqcunanam Dorcasqa qeshyacurcurnin wanuquicorqan. Tsenam ayanta shumaq bañaratsirnin, rara altus cuartuman patsäratsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope marcapita Lida marcamanqa amanullam carqan. Tsemi creyicoqcuna Lida marcacho Pedru quecanqanta musyarirnin, ishcaq nunacunata cachayarqan, rogacur queno niyänanpaq: —Jopechomi allapa nesitecuyaq. Jinallacho eweculläshun —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tsenam pecunawan Pedru ewarqan. Y Jopeman chäriptinnam, Dorcaspa ayan sutarëcanqan cuartuman pushayarqan. Tsemannam llapan biudacuna jiruroq ellucariyarqan waqallapa. Y Dorcas cawecarnin, bestiduncuna y aqshunancuna ruranqantam Pedruta ricatsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Apostol Pedrunam llapancunata waqtaman qarqurir qonqurïcurnin, Diosman mañacorqan. Mañacur usharirnam, Dorcaspa ayanta riquecur, queno nerqan: —¡Tabita, sharcamï! —nishpa. Tseno niptinnam, Dorcasqa cawarimur ricachacaramorqan. Y Pedruta riquecurnam, juclla tarcaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tsenam maquipita tsarircur, Dorcasta sharcaratsimorqan. Tsepitanam llapan creyicoqcunata y biudacunata qayaratsirnin, cawecaqtana pecunata entreguecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Que pasacushqancunatam enteru Jope marcacho nunacuna musyariyarqan. Tsemi Teyta Jesusman atscaq creyiquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tse Jope marcachomi suela ruraq Simonpa wayincho Pedru unepa quedacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea marcachomi carqan juc nuna Corneliu jutiyoq. Pëqa carqan Italia marca soldaduncunapa capitanninmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tse nunam wayincho llapan castancunawan Diosta respetarnin, adorayarqan. Pemi wactsa israel nunacunapaq atsca qelleta qaraq y Diosmanmi mana qonqeta mañacoq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Juc junaqnam tardipa lastresno quecaptin, Corneliuta Dios rebelecorqan. Alerim riquecorqan Diospa anjelnin pe quecanqanman yecureqta, y wiyecorqan “Corneliu” nishpa qayecoqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tsenam anjelta ricarëcar quedarerqan, y allapa mantsacushpam, queno taporqan: —¿Imallatataq, Teyta? —nishpa. Anjelnam nerqan: —Corneliu, mañaquiniquicunam y pishipäcoqcunapaq alli rureniquicunam Diospaq allapa alli quecushqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Canan cachë nunacunata Jope marcaman, tsecho Simon niyashqan Pedruta que wayiquiman pushayämunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tse Simon Pedrum posadacushqa quecan suela ruraq tocayun Simonpa wayincho. Pëqa yachan lamar cuchunllachomi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Parlapaqnin anjel eucuptinnam, Corneliu qayaratserqan Dios respetaq confiansa soldadunta y ishcaq sirweqnincunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tse quimancunatanam anjel llapan nenqanta willarirnin, Jope marcaman cacharqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Waräninnam tse cachacuna Jope marcaman yecurëcayaptinna, pullan junaq öranona quecaptin, Pedroqa wayipa jananman lloqarcur, Diosman mañaquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pachan allapa waqaptinnam, miquita munarqan. Peru miquinin tseraq aruyäponqanyaqnam, Pedruta Dios rebelecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tse rebelasionninchomi riquecorqan sielu quicharëcaqta, y tsepita imeca juc jatun jacuno chuscun cuchunpita watashqa patsaman uräquecamoqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tsechomi canaq lätepa pureq animalcuna, tuquilaya bolepa pureq pishqucuna, y tuquilaya chuscu chaquiyoq animalcunapis. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Y wiyarqan queno parlapaqnintam: —Pedru, sharquï, y que animalcunata pishtacacharcur miquï —neqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedrunam queno yasquerqan: —Teyta, ¡quecunataqa manam micushaqtsu; porqui manam ni imepis melanepaq raccha animalcunataqa micushqatsu cä! ");
INSERT INTO qwhNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tsenam yape parlaparnin, queno nerqan: —Dios bendisishqantaqa ama “Queqa melanepaqmi” ninquitsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Quima cuti tseno ricatsenqanchonam sieluman tse jatun qepinano llapan animalnintin juclla cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tsemi Pedru “¿Imapaqraq que llapanta riquecülla?” nir, yarpacachar quecaptinna, Corneliupa cachancuna qarapita suela ruraq Simonpaq tapucur tapucur wayinyaq chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Puncupitanam qayacuyarqan, queno nishpa: —¿Quechocu posadacushqa callan Simon niyashqan Pedru? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Rebelasion ricanqanpita Pedru yarpacachar caquicaptinnam, Santu Espiritu queno nerqan: —Pedru, canan öram quimaq nunacuna qamta ashicayäshunqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Canantä sharcur, yarpï. Pecunawan ewë; ama mantsaquïtsu; porqui noqam tse nunacunata cachamorqö —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tsenam rarapita yarparamurnin, nunacunata queno nerqan: —¿Imaqllataq shayämorqonqui? Ashiyanqequi nunaqa noqam cä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tse nunacunanam queno niyarqan: —Soldaducunapa capitannin Corneliu cachayämaptinmi shalläyämorqö. Pëqa allapa alli nunam y Dios respetaqmi. Tsemi llapan israel nunacunapis allapa respetayan. Diospa santu anjelninshi nishqa pepa wayinman qamta pushayänaqpaq y llapan nenqequita pe wiyananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsenam tse nunacunata chasquirir, Pedru posadacaratserqan. Waräninnam pecunawan jeqariyarqan; y Jope marcacho Jesusman waquin creyicoqcunapis Pedruta yanaqarninmi ewayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Waräninnam Cesarea marcaman chäriyarqan. Corneliunam combidashqa canaq castancunata y allapa cuyanacuyanqan amiguncunata Pedruta chasquiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wayinman chäriyaptinnam, Corneliu yarqaramorqan chasqueqnin; y qonquripa patsam ratecorqan Pedrupa nopanman, peta adorarnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peru Pedrunam sharcaratserqan, queno nirnin: —Sharquï; noqapis qamno nunallam cä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tsenomi Corneliuwan parlar parlar ruri wayiman Pedroqa yecurerqan; y atscaq nunacuna ellurëcayaqtam tarirerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pecunatanam queno nerqan: —Qamcuna musyayanquim noqa israel castacuna costumbrïcunamanno mana israel caqcunawanqa mana juntacuyanqäta, ni wayincunamanpis mana chäyanqäta. Peru tseno quecaptinpis, Diosmi rebelamar cäyitsimashqa, ‘mana alli nunam’ ni ‘raccha nunam’ nir, pitapis mana ninäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tsemi qayatsiyämanquequi öra, mana imata nirishpa shamorqö —nir. Tseno nirirnam, tapucorqan: —¿Imallapaqtaq qayatsiyämarqonqui? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Corneliunam queno yasquerqan: —Cananwanqa chuscu junaqnam, queno lastres quecaptin, wayïcho Diosman mañacurnin quecanqä. Tsemanmi chipapäquicaq besticushqa nuna juclla yurircamur, ");
INSERT INTO qwhNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","queno nimarqan: ‘Corneliu, mañaconqequita Dios wiyashqam, y wactsacunata yanapanqequita ricashqam. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Canantä nunacunata Jope marcaman cachë Simon niyanqan Pedruta wayiquiman pushayämunanpaq. Pemi posadacushqa quecan qarapita suela ruraq tocayun Simonpa wayincho. Pëqa yachan lamar cuchunllachomi,’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tsemi tse öra nunacunata qamman cachallämorqä. Allichomi shamicullarqonqui. Tsemi canan Diospa nopancho llapalläcuna ellucashqa quecalläyä Teytantsic llapan nishonqequita willapärayämänequipaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsepitanam Pedru parlar qallecorqan, queno nishpa: —Tëtecuna, cananqa allim noqa cäyicurerqö llapan nunatapis Dios iwallla ricamanqantsicta. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Porqui jinantin marcacho pipis allicunata rurar y Diosta respetar cacuyaptenqa, pëqa chasquinmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosmi Israel marca nunacunaman Jesucristuwan willacatsimorqan alli pasaquicho cawacuyänanpaq. Tse Jesucristoqa llapantsicpa Teytantsicmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Qamcuna musyecayanquim bautisacoq Juan bautisacur willaconqanpita patsa, Galilea marcapita qallecur, jinantin Judea marcacho llapan pasacushqancunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Y musyecayanquim Nazaretpeq Jesusta Santu Espirituta y poderninta Dios qoyconqanta. Jina musyecayanquim Teyta Jesus Dioswan carnin, allicunata ruranqanta y diablupa muneninwan llapan qeshyaquicaq nunacunata cachacätsenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Y noqacunam ricashqa cayä enteru Judea marcacho y Jerusalencho Teyta Jesus llapan rurashqancunata. Y petaqa crusificarninmi, wanutsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Peru wanushqanpita quima junaqllatam Dios cawariratsimur, permitïcorqan noqacuna ricayänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Manam llapan nunacunatsu cawarimushqanta ricayarqan, sinoqa pepaq willacuyänäpaq Dios acrashqancunallam. Pe cawariramuptinmi, pewan micuyarqä y upuyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesusmi noqacunata mandayämarqan, cawecaqcunapa y wanushqacunapa juesnin cananpaq Dios churashqanta nunacunata willapäyänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Diospa llapan une profetancunam willacuyarqanna Jesuspaq. Pecunam niyarqan pipis Jesusman creyicoqqa, perecurmi jutsancunapita perdonashqa cayanqa —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedru tseno yachatsiquicaptinnam, llapan wiyecaqcuna Santu Espiritupa podernincho juclla ticrariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tsemi Jope marcapita Pedruwan ewaq Jesusman creyicoq israel nunacunapis allapa espantacuyarqan, mana israel caqcunapis Santu Espiritupa poderninta chasquiriyaptin. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porqui tse nunacunatam tuquilaya idiomacho parlayaqta y Diosta alabayaqta wiyayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tsenam Pedru queno nerqan: —¿Acasu que nunacuna bautisacuyänanta michashwancu, pecuna Santu Espirituta noqantsicnolla chasquiyashqa quecayaptin? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tsenam Pedru mandarqan Jesucristupa shutincho bautisacuyänanpaq. Tsepitanam Pedruta rogayarqan mas unepa pecunawan quedacunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tsepitanam apostolcuna y llapan Judea marcacho Jesusman creyicoqcuna musyariyarqan mana israel caqcunapis, Diospa palabranta wiyarir, Jesusman marcäcoq ticrariyanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peru Pedru Jerusalenman cutiriptinnam, Jesusman creyicoq señalashqa caq waquin israel nunacuna penqapar, ");
INSERT INTO qwhNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","queno tapuyarqan: —¿Imarecurtaq sin señal mana israel caqcunaman watucaqnin ewarqonqui, y pecunawan micorqonqui? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tsenam Pedru willacorqan llapan pasaconqancunata, cuchunpita qallecur, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Juc cutim Jope marcacho, Diosman mañacur quecaptï, rebelasionnïcho Dios juc señata riquecatsimarqan. Tsechomi riquecorqä rara sielupita imeca jatun mantada chuscun cuchunpita watashqa urämurnin, nopäman chäramoqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Alli ricarëcurnam, tuquilaya chuscu chaquiyoq animalcunata, chucaru caqcunata, latepa pureq caqcunata y bolepa pureq pishqucunata riquecorqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tsepitanam wiyecorqä queno parlapämaqta: ‘Pedru, sharcur, que animalcunata pishtacacharcur, miquï’ nimaqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Peru noqanam queno yasquerqä: ‘Teyta, manam micushaqtsu; porqui manam ni imepis micushqatsu cä melanepaq raccha animalcunataqa’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tseno niptïnam, sielupita parlapëcamaqnï yape queno nimarqan: ‘Pedru, Dios bendisishqantaqa ama “Queqa melanepaqmi” ninquitsu’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Quima cuti tseno ricanqächonam tse mantada sieluman llapan animalnintin cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tse öranam posadacushqä wayiman quimaq nunacuna Cesarea marcapita cachayämonqan ashimarnï, chärayämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Santu Espiritunam cäyitsimarqan mana mantsacushpa pecunawan ewanäpa. Quecho quecamoq joqta nunacunawanpis Cesarea marcaman ewayarqämi; y qayatsiyämaqnï nunapa wayinmanmi yecuriyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tse nunanam willayämarqan wayincho juc anjelta ricanqanta; y tse anjelshi queno ninaq: ‘Canantä nunacunata cachë Jope marcacho quecaq Simon niyanqan Pedruta queman pushayämunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pemi qamta y wayiquicho caqcunata willayäshunqui imanopa salbacuyänequipaqpis’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pecunata Diospa palabranta willecaptïnam, tse nunacunapis Santu Espiritupa podernincho ticrariyarqan, noqantsic puntata Santu Espirituyoq ticrarenqantsicnolla. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsenam noqa yarpäcurcorqä Teyta Jesus queno nimanqanta: ‘Juanmi nunacunata yacuwan bautisarqan, peru qamcunaqa Santu Espiritupa poderninwanmi bautisashqa cayanqui’ nenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Canan shumaq cäyicuyë. Diosmi noqantsicta Santu Espirituta qomashqa cantsic, Teyta Jesusman creyicushqalla. Tsenollam pecunatapis qoshqa Santu Espiritunta. Y noqa manam pitsu cä Diosta michänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tsenam tsecunata wiyecur, tse piñapaqnin nunacuna upalläriyarqan, y Diosta alabayarqan, queno nishpa: —Tsepenqa mana israel caqcunatapis mana alli rurenincunata jaqiyaptin, Dios perdonanqam pecunapis wiñe caweyoqna cayänanpaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wanuratsirmi, Jesusman creyicoqcunata ushacätsita munayarqan. Tsemi witsipa witsir Fenicia marcacamayaq, Chipre islacamayaq y Antioquia marcacamayaq tse creyicoqcuna safacur chäriyarqan. Tse marcacunachomi Diospa willaquininta israel mayincunallata yachatsiyarqan; y manam waquin caqcunataqa yachatsiyarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Peru waquin creyicoqcunam siqa Chipre y Cirene marcacunapita Antioquia marcaman ewarnin, mana israel caqcunatapis Teyta Jesuspa alli willaquininta willapäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tsemi Diospa poderninwan willapäcuyaptin, atscaq nunacuna jutsancunata jaqirir, Diosta cäsucur peman marcäcoq ticrariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tsepitanam Jerusalencho Jesusman creyicoqcuna musyariyarqan mana israel caqcunapis marcäcuyanqanta. Tsemi Bernabeta Antioquia marcaman cachayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabenam, Antioquia marcaman chärirnin, ricarqan Dios imano allapa allicunata mana israel caqcunapaqpis rurashqanta. Tsenam allapa cushicurnin, tse creyicoq nunacunata willaparqan llapan shonquncunawan Teyta Jesusman marcäquinincunacho tsaracuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabeqa Diosman allapa marcäcurmi, Santu Espiritupa poderninwan alli ruraq carqan. Tsemi atscaq nunacuna Teyta Jesusman marcäcoq ticrariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsepitanam Bernabe Tarsu marcaman ewarqan Saulu asheqnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Taririrnam, Antioquia marcaman pusharqan. Tsechomi Saulu y Bernabe juc wata enteru Jesusman creyicoq nunacunawan cayarqan, atsca nunacunata Jesuspaq yachatsicurnin. Tse Antioquia marcachomi Jesusman creyicoqcunata “Cristianu” nishpa primera bes jutitsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tse junaqcunam Antioquia marcaman Jerusalenpita Diospa profetancuna chäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jucnin caqpam Agabu jutin carqan. Pemi Santu Espiritu cäyitsiptin, shacurir willacorqan jinantin marcacunacho allapa ambruna pasacunanpaq caqta. (Y rasonpam nenqannolla tse ambruna carqan Claudiu jutiyoq nuna mandacoq quecanqan tiempucho.) ");
INSERT INTO qwhNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tse ambruna quecanqanta musyarirnam, Jesusman creyicoqcuna shumaq parlariyarqan, cayäponqanmanno imatapis ellicurnin, Judea marcacho Jesusman creyicoqcunaman apatsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tsecunata ellurïcurninnam, Sauluta y Bernabeta apatsiyarqan Judea marcacho Jesusman creyicoqcunapa mayornincunaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tse tiempucunam rey Herodis, Jesusman waquin creyicoqcunata ushäcätsita munar, mandacorqan pecunata presu tsariyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tsemi Juanpa wauqin Santiagupaq mandacorqan espadawan wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Y Santiaguta wanutsenqanpita israel nunacuna allapa cushicuyanqanta rey Herodis musyarirmi, Pedrutapis presutsir tsaritserqan. Tseqa carqan lebadurannaq tantata micuyänan Pascua Fiesta semana quecaptinmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedruta carselman llawiratsirmi, rey Herodis chunca joqta (16) wardiacunata chuscoqpayan cambianaquita täparäyänanpaq mandarqan. Herodisqa munarqan, Pascua fiesta pasariptin, nunacuna nopancho jusgayänanpaq carselpita Pedruta jorqetam. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tsaq tseno Pedru llawirëcaptinnam, Teyta Jesusman creyicoqcuna Diosman Pedrupaq allapa mañaquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pedruta nunacuna nopancho jusgayänanpaq rey Herodis jorqamunanpaqqa juc junaqllanam pishicarqan. Tse paqasmi Pedroqa ishcaq soldaducunapa chopincho punicarqan, ishque cadenawan watashqa. Y waquin soldaducunanam puncuta täpecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tseno quecaptinnam, Diospa cachan anjel juclla carselman yurircorqan. Tsechonam limpu atsicyärerqan. Anjelnam Pedruta qasquncho yatecur riyarcatsir, “Pedru, jinallacho sharquï” nerqan. Tse öram maquincunapita cadenacuna juclla shicwarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Y anjelnam queno nerqan: —Ropequita y llanqiquita yacaqui —nishpa. Pedru tseno rurariptinnam, anjel queno nerqan: —Canan aqshunequita aqshucurcur qepata shamï —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tsenomi anjelta qatircur Pedru yarqurerqan. Peru manam alleqllaqa cäyerqantsu anjel rasonpa rurecanqanta; sinoqa “Sueñicächi” nishpam, pensarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Peru yarqurqa, pasariyarqannam punta caq wardiata y qepa caqtapis. Y fieru puncuman chäriyaptinnam, tse puncu porsilla quichacärerqan. Waqtaman yarqurir, juc callita ewarëcayaptinnam, Pedrullatana jaqirïcur, anjel juclla tsincarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tseran rasonpa cuentata qocurir, Pedru queno nerqan: —Cananmi rasonpa mäcurillä Dios anjelninwan carselpita jorqatsimar, Herodispa y israel nunacunapa maquincunapita libraramanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tse pasacushqancunata cäyicurcurnam, Marcos niyashqan Juanpa mamänin Mariapa wayinman eucorqan. Tse wayichomi Jesusman creyicoqcuna Diosman mañacurnin, atscaq ellucayashqa quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedru chärir, sawan puncuta tsactacuriptinnam, yanapacoq wamra Rode jutiyoq yarqaramorqan yasqueq. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedrupa bosninta reqirïcurninnam, Rodeqa allapa cushicurnin mana sawan puncutapis quichashpa, coripa ruriman cutiquicorqan, “¡Pedroqa waqta puncuchotaq quecan!” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tsenam wayi ruricho quecaqcuna queno niyarqan: —¿Imanopataq Pedroqa canqa! Locachi canqui, wamra —nishpa. Peru wamra cutïcuryan “rasonpam, rasonpam” niptinnam, pecuna niyarqan: —Manam petsu; almanmi —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tseyaqnam Pedroqa tsactacurnin jicutarqan. Tsenam puncuta quicharir Pedruta riquecurnin, allapa mantsacäcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedrunam upälla cayänanpaq maquinwan señasta rurarir, willacorqan imanopa carselpita Dios jorqamushqanta. Y willacur usharirninnam, queno nerqan: —Santiaguta y llapan creyicoqcunata quecunata willayë —nishpa. Tsepitanam yarqurir, eucorqan juc ladupa. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Patsa waräriptinnam carselcho wardiacunaqa imano quetapis puediyarqantsu; porqui manam musyayarqantsu Pedruwan ima pasacushqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tsenam rey Herodis Pedruta ashitserqan; peru mana tariyaptinnam, wardiacunata declaratsir pecunata wanutsiyänanpaq mandacorqan. Tsepitanam rey Herodis Judea marcapita Cesarea marcaman täraq eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tsecuna pasaconqan tiempucunachonam rey Herodis piñashqa quecarqan Tiro y Sidon marcacunacho täraq nunacunawan. Tsemi tse nunacuna shumaq parlariyarqan Herodista rogaq ewayänanpaq. Y Cesarea marcaman chärirnam, Herodispa confiansa sirweqnin Blastu jutiyoq nunata shumaq cäyitsiyarqan yanapayänanpaq. Pewanmi rey Herodisman yecuyarqan rogacoq shumaq pasaquichona cacuyänanpaq; porqui rey Herodispa marcanpita miquicunata rantirllam, tse nunacuna cawayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tsenam rey Herodisqa juc presisaq junaq alli caq ropanta yacacurcur, mandacur täcunanman tecur nunacuna nopancho shumaq parlaquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tseta wiyecurninnam, llapancuna fuertipa queno niyarqan: —¡Que parlecamoqqa juc diosmi; manam nunatsu! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tse öram Diospa anjelnin rey Herodista qeshyaratserqan, Diosta mana alabanqanrecur; y curupa micushqam wanurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tseyaqnam Diospa willaquinenqa jinantinman witsicar, miraquecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabenam Sauluwan rurayänanpaq caqcunata usharirnin, cuticuyarqan Jerusalenpita Marcos niyashqan Juanta pusharcur. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquia marcachonam Jesusman creyicoqcunacho Diospa profetancuna y yachatsicoqcuna cayarqan. Pecunam cayarqan Bernabe, “Nicshu” niyashqan Simon, Cirene marcacho yuricoq Luciu, Saulu y Menahem. Tse Menahemqa Galileacho mandacoq Herodiswan wayincho llullunpita winacoqmi carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Juc junaqnam ayunashpa Diosta alabecayaptin, pecunata Santu Espiritu queno nerqan: “Bernabetawan Sauluta acrayë; porqui pecunatam acrarqö noqapaq willapäcuyänanpaq” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tsenam ayunacurïcur Diosman mañacur usharirnin, Bernabeman y Sauluman maquincunata churar ˻bendisicur˼, despachecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tsemi pecuna Santu Espiritu pushayaptin, Seleucia nishqan puertuman eucuyarqan. Tsepitanam barcuman winacarcur, eucuyarqan Chipre islayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tseman chärirnam, Salamina nishqan puertucho Diospa alli willaquininta yachatsicuyarqan israel nunacunapa ellucayänan wayicunacho. Juan Marcospis pecunata yanaparninmi quecarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Diospa palabranta willacur enteru islapa ewarninnam, chäriyarqan Pafos nishqan puertuyaq. Tsechonam Diospa profetan tucoq brujo Barjesus jutiyoq israel nunata tariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tse nunam gobernador Sergiu Pauluta yanapar carqan. Y Sergiu Pauloqa allapa yachaq nunam carqan. Pemi Diospa palabranta wiyeta munarnin, Bernabetawan Sauluta qayatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Peru tse brujo Barjesusnam, Saulupa y Bernabepa contran sharcur, michäcorqan gobernador Sergiu Paulu Teyta Jesusman creyicunanta. Tse brujutam jina Elimas niyarqan, Elimasqa griegu idiomacho Barjesus ninanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tsenam Pablu niyashqan Sauloqa Santu Espiritupa poderninwan carnin, tse bruju Elimasta alli ricarëcur, ");
INSERT INTO qwhNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","queno nïcorqan: —Ä ¡supëpa wawan! Uli mana alli ruraq carmi, llapan alli rurecunapa contran caquicanqui. ¿Manacu jaqirinquiman Diospa rasonpa yachatsiquininpa contran ulipäquicunata! ");
INSERT INTO qwhNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tserecurmi Dios canan castigashunqui. Tsemi wiscu ticrarir, unepa intipa actsinta ricanquitsu —nishpa. Tse öram Elimas mana ricarqannatsu. Y wiscuyärishqa carmi, pillapis janchecunanpaq rogacurnin, jiruricachäquicarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tseta riquecurnam, tse gobernador Sergiu Paulu, Teyta Jesuspaq yachatsicuyashqanta espantacur, Jesusman allapa marcäquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tsepitanam Pablu yanaqincunawan barcuman lloqarcur, Pafos nishqan puertupita eucuyarqan Panfilia marcacho quecaq Perge marcaman. Peru Juan Marcosqa pecunapita raquicarirmi, Jerusalenman cuticorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pergepitanam pasacuyarqan Antioquia marcaman; tse marcaqa jina Pisidia probinisiallachomi. Tsechonam jamacuyänan sabadu junaq Pablu yanaqincunawan ellucayänan wayiman yecurir, täcuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tsenam Moises escribishqan leycunata y Diospa profetancuna escribishqancunata leyir usharirnin, ellucayänan wayicho mandacoqcuna Pabluta yanaqincunatawan qayaratsir, queno niyarqan: —Tëtecuna, meqequicunapis yachatsicarayämï, balorta qocur, quecho quecaqcuna allina cawacuyänanpaq —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsenam Pabloqa sharcurcur nunacuna wiyayänanpaq maquinwan señasta rurarnin, queno nerqan: —Israel mayïcuna, y mana israel caqpis Diosman creyicoq tëtecuna, canan parlacaramonqäta wiyaräyämë. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Une israel nunacuna alabayanqan Diosmi acrarqan castantsiccunata. Y pecunatam allapa miratserqan, Egiptu marcacho forasterulla quecayaptinpis. Tsepitanam Dios allapa puedeq queninwan Egiptu nasionpita pecunata jorqaramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tsunyaqcunacho chuscu chunca (40) wata puriquicar, mana allicunata ruraquicayaptinpis, Dios awantarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tsepitanam Canaan nishqan marcacho qanchis nasionninpi nunacunata ushacäratserqan tse marcacunata une castantsiccunata qoycunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tsecunaqa chuscu pachaq pitsqa chunca (450) watachomi pasacorqan. “Tsepitanam Dios churarqan pushaqnincuna asta Diospa profetan Samuel mandacoq yecurenqanyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tsenam Diosman mañacuyarqan une castantsiccuna juc reynincuna churecunanpaq; y Saultam churaraporqan reynincuna cananpaq. Tse Saulqa Benjaminpa mireninpita Quis jutiyoq nunapa tsurinmi carqan. Y chuscu chunca (40) watam mandacoqnincuna carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsepitanam Saulta rey queninpita Dios jorqarir, Davidtana churarerqan rey cananpaq, pepaq queno nirnin: ‘Jesepa tsurin Davidtam shonqü tarin, porqui pëqa mandanqäcunata rurananpaqpis listum quecan’, nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tsepitanam Dios änicushqanno rey Davidpa mireninpita Teyta Jesus yuricorqan. Y petam cachamorqan noqantsic israel nunacunata salbamänantsicpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Manaraq Jesus yuricuptinmi, bautisacoq Juan llapan israel nunacunata yachatserqan, mana alli rurenincunata dejarïcur bautisacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tsenam bautisacoq Juan rurananpaq caqta usharinanpaq ichicllana pishicaptin, Jesuspaq willacur, queno nerqan: ‘Manam qamcuna pensayanqequinotsu noqaqa cä; peru pensecayanqequeqa qepätaran shamun. Pepataqa noqa manam puedillätsu qonqurïcur llanqinpa watunta pascarïllatapis.’ ");
INSERT INTO qwhNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abrahampa mirenin marca mayicuna, y Dios cäsucoq caqqa mana israel caqcunapis, canan cäyirayämë. Dios salbamänantsicpaq willaqueqa llapantsicpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalencho täraqcuna y autoridacuna, cada jamaqui junaq Diospa une profetancuna escribiyashqancunata leyicarninpis, manam musyayarqantsu Jesus pi cashqanta. Peru peta condenar wanuratsiyaptinmi, cumplicärerqan tse willacoqcuna Jesuspaq escribiyashqancuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pe wanunanpaqno jutsan mana quecaptinpis, Poncio Pilatutam mañayarqan Jesusta wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Teyta Jesuspaq Diospa palabran nenqanno llapanta rurar usharirnam, cruspita yarparatsir sepulturaman pampariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Peru Diosmi wanushqanpita cawariratsimorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Y cawariramurnam, Galilea marcapita Jerusalenman pewan ewaqcunata atsca cuti yuriporqan. Tsemi canan tse testigucuna willacuyan llapan nunacunata Jesuspaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Tsemi noqacunapis que alli willaquicunata qamcunaman chëcatsiyämü. Une castantsiccunata Dios änishqanmi ");
INSERT INTO qwhNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","canan cumplicärishqa noqantsiccho, pecunapa mirenin cashqa. Tseta cumplishqa, Dios Acrashqanta cawaritsimurmi. Tsemi ishque caq Salmuchopis Teyta Dios Jesuspaq cäyitsiptin, escribeqcuna escribiyarqan queno: ‘Qammi tsurï canqui; noqam apamorqaq que bidaman’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Y Teyta Jesuspa ayan mana ismunanpaq caqqa y cawarimunanpaq caqqa, Diospa palabranchomi queno escribirëcan: ‘Noqa Diosmi Davidta änenqäta rasonpa alli bendisioncunawan bendisishaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jina juc laduchopis Diospa palabran quenomi escribirëcan: ‘Dios manam permitenqatsu jutsannaq tsurinpa ayan ismunanta’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Cäyiyë: Rey Davidqa Dios mandashqancunata ruraquicarllam wanurerqan. Y awiluncunatanollam pampecuyarqan; tsechonam ayan ismurnin ushacarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Peru Dios cawaritsimushqan Jesuspa ayanqa manam ismur ushacarqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Tsemi, wauqicuna panicuna, canan qamcunata alleq willayaq: Jesusrecurllana jutsantsiccunapita Diosnintsic perdonecamanqantsicta. Moises escribishqan leycunata cumplita tïrarqa, manam Dioswan allitsu quecarqontsic. Peru cananqa Jesusman creyicurllanam perdonashqa quecantsic. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tëtecuna, paqtataq Diospa une profetancuna parlayashqan qamcunacho pasacunman. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Pecunam queno escribiyarqan: ‘Ä, burlacoq nunacuna, canan mantsacäcur asta tsincariyëpis. Porqui pipis willayäshuptiqui, mana creyiyanqequitam rurashaq tse junaqcuna’ nir.” ");
INSERT INTO qwhNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tsepitanam parlar usharirnin, Pabloqa Bernabewan ellucayänan wayipita yarquriyarqan. Nunacunanam rogayarqan jucnin jamacuyänan sabadu junaqpis tsecunata willapäyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ellucayashqanpita nunacuna eucuyaptinnam, atscaq israel nunacuna y mana israel caqcunapis Dios cäsucoq caqqa qatiyarqan Pablutawan Bernabeta. Tsenam pecuna willapäyarqan Teyta Dios pecunatapis ancupäyanqanman creyicuyanqancho alli firmi quecayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tse sitayanqan sabadu chäriptinnam, tse marcacho casi llapan nunacuna elluquecuyarqan Diospa palabranta wiyacuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Peru waquin israel nunacunanam allapa nunacuna pecunaman juntacaqta riquecurnin, selosu carnin, Pablu yachatsiconqanpa contran shäricurcur, wasan rimayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsenam Pabluwan Bernabeqa mana ichicllapis mantsacurishpa, queno niyarqan: —Änirpis presisarqanmi qamcuna israel caqcunataraq Diospa palabranta puntata willayänaqpaq. Peru qamcuna mana cäsuquita munayanqequirecurmi, y wiñe cawepaq mana imatapis musyeta munayaptiquim, cananqa mana israel caq nunacunaman ewar willacuyäshaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porqui tseno rurayänäpaqmi Dios palabrancho mandayäman: ‘Qamtam churaq mana israel caq nunacunapaqpis actsin cuenta canequipaq. Tsenam salbasionpaq alli willaquita willacurnin, jinantin mundu cuchunyaq chäratsenqa’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pablu tseno niriptinnam, mana israel caq nunacuna allapa cushicurnin, “Diospa alli willaquinenqa allapa shumaqtaq” niyarqan. Tsemi Jesusman creyiquicuyarqan wiñe cawe munaq caqqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tsenomi jinantin marcacunacho atsca nunacuna Diospa alli willaquininta musyariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Peru tsepita yapenam israel nunacunana tse marcacho presisaq nunacunata y Diosta cäsucoq allapa reqishqa warmicunata Pablupa y Bernabepa contran willapëcuyarqan, tsenopa piñarcur, tse marcancunapita qarquyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsenam Pabluwan Bernabeqa, pecunapa contran señata rurar, chaquincunacho polbuta tapsicurir, Iconiu marcaman eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antioquia marcacho Jesusman creyicoqcunaqa allapam cushicuyarqan; y Santu Espiritupa poderninchomi quecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tsepitanam Pabluwan Bernabe Iconiu marcacho, israel nunacunapa ellucayänan wayiman ewayarqan. Tsecho pecuna allapa shumaq willapäquicuyaptinnam, atscaq nunacuna israel caqcuna y mana israel caqcunapis Jesusman creyiquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Peru waquin mana creyiquita munaq israel nunacunanam mana israel caqcunata willapëcuyarqan Jesusman creyicoq wauqicunapa y panicunapa contran llutanta sharicurcuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Y unepam Iconiu marcacho Pabluwan Bernabe quedacuyarqan. Y mana ichicllapis mantsacurishpam, Teyta Jesuspaq yachatsicuyarqan. Diosmi qoycorqan poderninta tuqui milagrucunata rurayänanpaq. Tsenopam quiquin Dios musyatserqan tse willacuyanqanqa rasonpa ancupäcoq Diospita canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tsemi tse marcacho nunacunaqa ishque grupuman raquicashqa caquicayarqan. Waquincunam Pabluwan Bernabe parlayashqanman creyicuyarqan. Waquincunanam mana creyirnin, israel nunacunaman qaqäcurcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tsenam israel caq y mana israel caq nunacuna autoridanincunawan yachatsinacuyarqan, Pablutawan Bernabeta maltratar qomparnin, wanutsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Peru tseta musyarirninnam, Pabluwan Bernabe safarnin eucuyarqan Licaonia nishqan marca ladupa, Derbepa, Listrapa y jinantin marcapam puriyarqan, Diospa alli willaquinincunata yachatsicurnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra marcachonam taririyarqan juc coju nuna tëcaqta. Tse nunam purita puederqantsu, yuriquininpita patsa coju carnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pemi quecarqan Pablu parlaqta wiyacurnin. Tsenam Pablu riquecorqan tse cojuta, y cuentata qoquicorqan cachacänanpaq marcäcur quecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tsenam fuertipa queno nerqan: —¡Sharquï! ¡Chaquiquipana purï! —nishpa. Tse öram tse nuna juclla pintircur, purir qallecorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablu rurashqanta riquecurnam, Licaonia nunacuna quiquincunapa idiomancunacho qayaripa queno niyarqan: —¡Quecunaqa sielupita urämushqa dioscunam cayan nuna tucushqa! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tsenam Bernabeta “dios Zeus” niyarqan; Pablutanam parlacoq canqanrecur, “pëqa dios Hermesmi” niyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tse marcaman yecuyänan puncu laduchomi carqan juc templu dios Zeusta adorayänan. Tsecho dios Zeus sirweq saserdotinam tsecho nunacunawan torucunata wetapita coronata wallqarcatsir, apayarqan. Tse animalcunatam pecunapaq pishteta munayarqan diostano qarayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Peru tseno rureta munayanqanta apostol Pabluwan Bernabe cuentata qocurirnam, llaquicur ropancunata rachirir, nunacuna quecayanqanman qayaripa ulluquicuyarqan, queno nishpa: ");
INSERT INTO qwhNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Peru tëtecuna, ¿imanirtaq quecunata rurayanqui? Noqacunapis qamcunano nunallam cayä. Unicoqa mana alli costumbriquicunata jaqirïcur, rasonpa cawaq Diosman creyicuyänequipaq alli willaquita yachatsiyaqniquicunallam marquequicunaman shayämorqö. Pellam sieluta, patsata, lamarta y llapan que munducho caqcunataqa rurarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Unepita patsam quiquin Dios permiterqan me tse marcachopis nunacuna quiquincunapa munayashqancunata ruracuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Peru Dios cashqantaqa imano ecanollapis musyatsiquicarqanmi. Tsemi nunacuna musyayänanpaq tamyatsimun; y tamya captinmi, cosechacunata alli ellutsimantsic; y cushi cushita wätamantsic —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Peru quecunata nicayaptinpis, allapa sasam carqan michäyänanpaq. Cäsillapam animalcunata pishtarir Diostano qarecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsepitanam israel nunacuna Iconiu y Antioquia marcacunapita chäriyarqan. Pecunam tse nunacunata willaparnin, jucnopa cäyitsiyarqan. Tsenam Pabluta sellama tsampiquicuyarqan. Y wanushqanta pensarninnam, qaracharcur tse marcapa jaqninman jitariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Peru tseman Jesusman jiruroq creyicoqcuna juntacäriyaptinnam, Pablu juclla sharcaramurnin, tse marcaman yape yecurerqan. Waräninnam Bernabewan eucuyarqan Derbe marcata. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Diospa alli willaquininta tse marcacho willacur atscaq nunacunata Jesusman creyicaratsirnam, cuticuyarqan shayamushqan Listra, Iconiu y Antioquia marcacunapa. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tse pueblucho creyicoqcunatam mas balorta qor marcäquinincunacho allipa tsaracuyänanpaq willapar queno niyarqan: —Diospa mandaquinincho canantsicpaqqa presisanmi tuqui sufrimientucunata pasanantsic —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Y cada marcacunachomi mandacoqcunata churayarqan Jesusman creyicoqcunata yanapayänanpaq. Tsenomi ayunarir Diosman mañacurir, tse mandacoqcunata creyicuyashqan Diospa boluntaninman entreguecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tsepitanam Pisidia probinsiapa pasarnin, Panfilia probinsiaman chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Diospa palabranta Perge marcacho willacurirnam, pasacuyarqan Atalia nishqan marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tsepitanam barcuman lloqarcur Antioquia marcaman cuticuyarqan. Tse marcapitam pecunata cachayashqa cayarqan Dios yanapaptin palabranta yachatsicuyänanpaq. Tse yachatsiquita willacur usharirmi cutiriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquia marcaman chärirnam, creyicoqcunata qayaratsir willayarqan pecunata Dios yanapaptin milagrucunata rurayanqanta. Tsenollam willayarqan mana israel caq nunacunapa shonqunta Dios yataptin Teyta Jesusman marcäcuyanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Y uneyaqmi tsecho Pabluwan Bernabe quedacuyarqan tse creyicoqcunawan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tse junaqcunam Judea marcapita Antioquia marcaman waquin nunacuna ewecur, Jesusman creyicoqcunata qallecuyarqan queno yachatsir: —Une Moises mandacushqanno mana señalacorqa, manam salbacuyanquitsu —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tsenam Pabluwan Bernabe tse yachatsicoqcunawan feyupa liryacurcuyarqan. Tsemi acuerduta rurarir, Pabluta Bernabeta waquin creyicoqcunatawan Jerusalenman cachayarqan tsecho apostolcunawan y mandacoqcunawan tse asuntuta areglayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tse creyicoqcuna despachecuyaptinnam, eucurnin Fenicia y Samaria marcacunapa pasayarqan. Tse marcacunachomi willacuyarqan mana israel caq nunacunapis Jesusman creyicoq caqqa juclayana cawacuyanqanta. Tseno willacuyaptinnam, llapan creyicoqcuna allapa cushicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pabluwan Bernabe Jerusalenman chäriyaptinnam, tsecho apostolcuna, mandacoqcuna y llapan creyicoqcuna cushishqa chasquiriyarqan. Tsenam Pabluwan Bernabe willacuyarqan puriyanqancunacho Dios imano yanapayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Peru fariseu grupupita caq creyicushqacunanam waquin caq sharcur queno niyarqan: —Mana israel caqcunaqa Jesusman creyicur presisanmi señalacuyänan y Moises mandacushqan leycunata cumpliyänan —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tsenam apostolcuna y mandacoqcuna ellucariyarqan tse asuntuta shumaq areglayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tsecho allapa liryacurcuyaptinnam, apostol Pedru sharcurcur queno nerqan: —Wauqicuna, musyayanquim unena mana israel caqcunatapis alli willaquita willapänäpaq qamcunapita noqata Dios acramashqanta, tsenopa pecunapis creyicuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Y imecatapis pensecanqantsicta musyaq Diosmi Santu Espiritunta pecunamanpis noqantsicmannolla cachamur, musyatsimarqantsic pecunatapis chasquenqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Diospaqqa iwalllam cantsic, israel caq y mana israel caqcunapis, porqui marcäquinincunarecurmi pecunatapis juclaya shonquyoqtana ticratsishqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tseno quecaptenqa, ¿Imanirtaq Diosta piñatsiyanqui, que creyicoqcuna Moisespa leynintaraq cumpliyänanpaq ecsijir? Tsecunataqa une castantsiccunapis ni noqantsicpis manataq cumplita puederqontsictsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","¡Mas bientaq marcäquicantsic Teyta Jesuslla alli queninwan pecunatanolla noqantsictapis salbecamanqantsicta! ");
INSERT INTO qwhNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tseno niptinnam, llapan juntarëcaqcuna upällällana quedariyarqan. Tsenam Bernabe Pabluwan willacuyarqan atsca milagrucunata Diospa poderninwan mana israel caqcunacho rurayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Parlar ushariyaptinnam, Santiaguna parlacurerqan queno nishpa: —Wauqicuna, wiyaräyämë. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pedrum willaramarqontsic mana israel caqcunatapis sirweqnincuna cayänanpaq acrarnin, Dios imano chasquir qallecanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Queqa Diospa une profetancuna escribiyanqantaq tincurin. Pecunam queno escribiyarqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Quecuna pasacuriptinmi cutimushaq, y rey Davidpa castancunatam yape sharcatsishaq; y imeca wayi juchurishqata perqaq cuentam yape altsashaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Tsenopam jinantin nasioncunapita noqapa caqqa mana israel caqcunapis noqaman shayamonqa. Unepita patsam quecunata musyatsicorqä, y dispunishqäcunatam canan cumplishaq’ ninmi Dios. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Tsemi noqa pensä queno: Mana israel caq nunacuna Diosman marcäcur qallayaptenqa, ama michäshuntsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Antis tse creyicoqcunaman cartaquicushun queno: ‘Ama imajincunaman ofresishqa etsacunata micuyëtsu; ama jucwan jucwan pununacuyëtsu; ama jurcaquëpa wanushqa animalcunapa etsancunata micuyëtsu ni yawarnintapis micuyëtsu’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porqui unepita patsam cada marcacunacho Moises escribishqan leycunata cada jamaqui junaqcuna ellucayänan wayicunacho leyir yachatsicuyan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tsenam apostolcuna, mandacoqcuna y llapan creyicoqcuna juc yarpella carnin, pecunapita ishcaq nunacunata acrayarqan Pabluwan y Bernabewan Antioquiaman ewayänanpaq. Tse acrayashqancunaqa cayarqan Silasmi y Judasmi. Tse Judastam jina Barsabas niyarqan. Pecunaqa cayarqan allapa presisaq nunacunam tse creyicoqcunacho. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Y pecunatawanmi juc cartata apatsiyarqan queno escribishqata: “Antioquia marcacho, Siria nasioncho y Cilicia probinsiacho mana israel caq cuyashqa wauqicuna: Apostolcunam, mandacoqcunam, llapan wauqiquicunawan saludayashniquipa cartacayämü. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Noqacunam musyariyarqö, waquin creyicoqcuna mana mandecayämuptï quepita shamicurnin, qamcunata pantatsiyäshïnïquita munar yachatsiquinincunawan tuquita pensacachätsiyäshonqequita. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tsemi allipa tantiyecurnin, acuerduta rurar noqacunapita ishcaq wauqintsiccunata acrayarqö cuyë wauqintsic Bernabewan y Pabluwan qamcunaman shayämunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bernabewan Pabloqa wanitapis mana mantsarishpam Teyta Jesus yachatsicushqancunata willacurnin puriyan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tsemi cachayämü Judasta y Silasta. Pecunam willayäshunqui llapan acuerdu rurayanqäta. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Porqui Santu Espiritum cäyitsiyämarqon y quiquïcunam pensayarqö ‘Costumbrïcunataraq cumplï’ nir, mana obligayänaqpaq, sinoqa mas presisu caqcunallata rurayänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tsemi ama micuyanquitsu imajincunata qarayashqan etsacunata, ni jurcaquëpa wanushqa animalcunapa etsancunata, ni yawarnintapis ama micuyanquitsu. Ama jucwan jucwan pununacuyanquitsu. Que niyanqaqcunata cumplirnenqa allitam rurayanqui. Dios bendisicuyäshï” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tsepitanam Pabluta, Bernabeta, Silasta y Judasta despachariyarqan. Pecunanam Antioquiaman chärir creyicoqcunata qayaratsirnin, cartata entregariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tse cartata leyirirnam, allapa cushicuyarqan pecunapaqno cashqanta musyarir. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judaswan Silasqa Diospa profetan carninmi, allapa shumaq willapäquicuyarqan. Tsemi tsecho creyicoqcuna allapa marcäquiyoq ticrariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tsecho pecunawan une täcuriyaptinnam, tse creyicoqcuna despachecuyarqan “grasias Diosnintsic bendisicuyäshunqui” nishpa, cachamoqnincunaman cuticuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","˻Peru Silasqa “noqaqa quedacüran” nirninmi, quedacorqan.˼ ");
INSERT INTO qwhNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pabluwan Bernabeqa quedacuyarqan Antioquia marcachomi, waquincunawan Teyta Jesuspa alli willaquininta yachatsicur y willacur tsecho cayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tsepita unetanam Pablu Bernabeta queno nerqan: —Acu yape watucaramushun Teyta Jesucristupa alli willaquininta jinantin marcacunacho willapanqantsic wauqintsiccunata, ¿mä imanoshi quecayan? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tsenam Bernabeqa Juan Marcosta pusheta munarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Peru Pabloqa pensarqan Juan Marcosta manana pushetam, porqui jucpinmi Marcosqa Panfilia marcacho quecayaptin pecunata dejarïcur cuticorqan, Diospa palabranta yachatsicur mana siguishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tsenam Pabluwan Bernabeqa liryacurcur raquicacuriyarqan. Bernabemi Marcosta pusharcur barcuwan Chipre islaman eucorqan, ");
INSERT INTO qwhNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Y Pablunam Silasta acrarqan yanaqinpaq, y tsecho creyicoqcuna Dios pecunata yanapecunanpaq mañacuriyaptinnam, jeqariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tsenomi Siria y Cilicia marcacunapa eucurnin, tsecho creyicoqcunata marcäquinincunacho mas y mas firmi cayänanpaq willapëcuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tsepitanam Derbe marcaman y Listra marcaman chäriyarqan. Listrachomi juc jobin Timoteu carqan. Pepa mamäninmi israel casta warmi carqan. Papänenqa manam; sinoqa carqan Grecia nishqan nasionpitam. Tse jobinmi y mamäninmi Teyta Jesusman creyicoq cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tse Timoteupaqmi Listracho y Iconiucho Jesusman creyicoqcuna queno niyarqan: “Pëqa allapa alli ruraq nunam” nirnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablunam Timoteuta apeta munarqan yanaqänanpaq. Peru apananpaqqa puntataran Timoteuta señalatserqan tse marcacunacho israel nunacuna mana piñayänanpaq, porqui musyayarqan Timoteupa papänin Grecia marcapita cashqantam. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Eucurninnam me tse marcaman chäyanqanchopis Teyta Jesusman creyicoqcunata willayarqan tse Jerusalencho apostolcuna y mandacoqcuna acuerdu rurayanqanta pecunapis cäsuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tsenopam tsecho creyicoqcuna Teyta Jesusman mas marcäquiyoq ticrariyarqan y waran waranmi mas miraquecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsepitanam Frigia y Galacia marcacunapa pasarnin eucuyarqan, porqui Santu Espiritu manam permiterqantsu Asia marcacunacho Diospa palabranta willacuyänanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia nishqan marcapa linderunman chëcarnam, munayarqan Bitinia nishqan marcaman eweta, peru Teyta Jesuspa Santu Espiritunmi mana permiterqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tsenam Misia marcapa pasarnin, Troas marcaman chäriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tsechomi Pabluta juc paqas Dios sueñinincho ricatserqan Macedonia marca nuna sharcur queno rogacoqta: “Macedoniaman shamicur yanapecalläyämë” neqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tsemi Pablu tse sueñininta willarayämanqan öra prebinicuyarqä Macedonia marcaman ewayänäpaq, porqui cuentatam qocuriyarqä alli willaquita willacuyänäpaq tse marcaman Dios cachayämanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tsenam barcuman lloqacurcur, Troaspita eucuyarqä Samotraciaman. Y waränin junaqnam chäriyarqä Neapolisman. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tsepitanam eucuyarqä Filiposman. Filiposqa Macedonia marcapa capitalninmi carqan. Tse marcachoqa Roma nunacuna llutepam quecuyarqan. Tse marcachomi tse junaqcuna quedacuriyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jamacuyänan sabadu junaqnam ewayarqä tse marcapa wac ladun mayu cuchuncunapa. Tsemanqa ewayarqä “¿Mä tsecho Diosman mañacuyänan sitiu cancush?” nishpam. Tsecho juntacashqa warmicunata taririrnam tecurnin, alli willaquita willapäyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jucnin caq warmipam jutin carqan Lidia. Pëqa Tiatira marcacho yuricoqmi carqan. Tse warmeqa purpurawan tiñishqa finu telacunata ranticoq negosiantim carqan. Tse warmeqa unepita Diosta adoraqmi carqan, y Diosmi shonqunta yatecorqan Pablu willapäcushqanta cäyiquicunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pemi bautisacorqan wayincho llapan castancunawan, Tsepitanam rogayämarqan queno: —Teyta Jesusman rasonpa marcäconqäta qamcuna creyirnenqa, canan acu shayämï wayïcho quedacuyänequipaq —nir. Tseno nishpam wayinman malas pushayämarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tsepitanam juc cuti Diosman mañacoq ewecarnin, supëpa poderninwan suertita cateq esclabu shipashwan toparcayämorqä. Tseno suertita qatirninmi, patronnincunata atsca qelleta ganecatseq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tse shipashmi Pabluta y noqacunata qaticarcayämarqan queno nishpa qayariräcur: —¡Que nunacunaqa puedeq Diospa sirweqnincunam cayan y qamcunatam Jesucristupaq willapäyäshunqui salbacuyänequipaq! —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Y cada junaqmi tse shipash tseno parlarnin qatiräcayämarqan. Tsenam Pabloqa piñarcurnin tse shipashcho supëta queno nerqan: —¡Teyta Jesucristupa jutinchomi, qam supëta mandaq jina öra que shipashpita yarqunequipaq! —nishpa. Tsenam jinallacho tse shipashpita supë yarqurerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Peru tse shipashpa patronnincunanam, “Cananqa mananachi qelleta ganatsimäshunnatsu” nishpa, Pablutawan Silasta presu tsarircur apacuyarqan plasa de armascho autoridacunaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Chäratsirnam shimpiparnin queno niyarqan: —Que israel nunacunam marcantsiccho nunacunata bullacarcatsiyan. Costumbrincunatam yachatsicuyan, y tseqa Roma leynintsicpa contranmi, nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tsenam llapan nunacuna Pablupa y Silaspa contran shäricurcuyarqan. Tsenam autoridacuna nunacunata mandayarqan, qalapachärir garutiwan wiluquicuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Alli buenu wilucachärcurnam apacuyarqan carselman llawiyänanpaq. Y chäratsirnam guardiata notificayarqan alli buenu segurayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tseno ordenayaptinnam tse carsel cuidaqqa Pabluta y Silasta mas ruricho calabosuman llawirerqan, y chaquincunatapis charaqmi segurayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Peru pullan paqasnonam Pabluwan Silasqa cantacur Diosta alabarnin mañaquicayarqan. Waquin presucunanam wiyaquicayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tseno quecayaptinnam, juclla patsa feyupa cuyucurerqan y carselpa simientuncunapis pasepa shoqllirerqan. Tse öram carselpa llapan puncuncuna juclla quichacäcurerqan y presucuna wataranqan cadenacunapis pascacärerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Carsel cuidaq guardianam punicanqanpita riyarcurnin riquecorqan carselpa puncuncuna quicharpäquicaqta. Tsenam “Presucunaqa safacuyashqachi” nirnin, espadanta sutarïcur quiquin wanutsiquita munarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Peru Pablunam fuertipa qayaquicorqan queno: —¡Ama wanutsiquiquïtsu! Quechomi llapäcunapis quecayä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tseta wiyecurnam, carsel cuidaqqa, “Actsita apayämï” nishpa, coripa ruriman jeqaquicorqan. Pablupa y Silaspa nopanman chëcurnam, mantsaquewan limpu tullunpis catatecar qonquriquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tsepitanam Pablutawan Silasta waqtaman jorqurir queno taporqan: —Tëtecuna, ¿Imatataq rurashaq Dios salbamänanpaq? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tsenam queno niyarqan: —Teyta Jesusman creyicuyë, qam y wayiquicho caqcunapis salbacuyänequipaq —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tsenomi Diospa palabranta yachatsicur willapäyarqan, carsel cuidaqta wayincho caqcunatawan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tse öram paqaspa Pablupa y Silaspa eridancunata carsel cuidaq shumaq jampiraporqan. Tsepitanam jina öra wayincho llapan caqcunawan bautisacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tsenam Pablutawan Silasta wayinman yecaratsir, miquinin qarayarqan. Y Diosman creyicushqa carninmi, carsel cuidaqqa wayincho llapan caqcunawan allapa cushicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Patsa waräriptinnam autoridacunaqa soldaducunata cachayarqan tse carsel cuidaqta queno niyänanpaq, “Pablutawan Silastash presu cayanqanpita cacharinqui” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Carsel cuidaqnam Pabluta queno nerqan: —Autoridacunam juc ordenta aparatsiyämushqa qamtawan Silasta librina cachariyänaqpaq. Cananqa tranquilu eucuyë —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Peru Pablunam pecunata queno nerqan: —Roma nasion nuna quecayaptïpis, llapan nunacunapa nopanchomi manaraq jusgayämashpa golpitsiyämarqon y llawiratsiyämashqa. ¿Canannacu paquellapa cacharayämeta munayan? ¡Manam, yarquyäshaqtsu! Quiquincuna shayämutsun jorqayämänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tse wardiacunanam cutïcurnin, autoridacunata Pablu nenqanta willariyarqan. Tsenam Pabluwan Silas roma nuna cayanqanta musyarirnin, allapa mantsacäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tsenam autoridacuna ewayarqan Pablutawan Silasta disculpata mañcuyänanpaq. Carselpita jorqurirninnam rogayarqan tse marcapita eucuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carselpita yarqurirnam Pabluwan Silas eucuyarqan Lidiapa wayinman. Tsecho Diosman creyicoqcunata yape willapärirnam, tse marcapita ewacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tseno eucurninnam, Pabluwan Silas Anfipolis y Apolonia nishqan marcacunapa pasarnin, Tesalonica marcaman chäriyarqan. Tsechomi israel nunacunapa ellucayänan wayincuna cayäporqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Pablunam costumbrinmanno ewarqan tse ellucayänan wayiman. Cada jamacuyänan junaqmi quima semananpi Diospa palabranta willapäcur, cäyitserqan Dios Acrashqan que patsaman shamur allapa sufrir wanurir cawarimunanpaq canqanta. Tseno nirirnam nerqan: —Tse willayanqaq Dios Acrashqanqa Jesusmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tseno cäyitsicuptinmi waquin israel nunacuna creyicurnin Pabluman y Silasman juntacacurcuyarqan. Y Dios cäsucoq griegu caq nunacunapis y allapa reqishqa warmicunapis atscaqmi creyicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Peru waquin israel nunacunanam chiquicurnin Pablupa y Silaspa contran tse pueblucho bullata rurayänanpaq, callicho pulicoq qela mana alli portacoq nunacunata inquitayarqan. Tsenam pecuna Jasonpa wayinmanpis ulluquicuyarqan, Pablutawan Silasta ashirnin, tarïcorqa nunacunaman entreguecuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Peru tsecho mana tarirninnam, Jasonta waquin creyicoqcunatawan qaracharcurnin, apayarqan autoridacunaman qaparipa qayaripa queno nishpa: —Que nunacunam willaquinincunawan jinantin marcacho nunacunata limpu locuyäratsiyanna y canannam que marcantsicmanna chäquecayämushqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Y que Jasonmi wayinman consientir posadacatsishqa. Tse nunacunawanmi Jasonpis reynintsic cesar mandacushqan leycunata cäsuyannatsu, y ‘juc reymi can’ niyanmi. Tse reypash Jesus jutin. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tseno niyanqanta wiyecurmi tsecho nunacuna y autoridacuna allapa yarpacachëman chäquicuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Peru garantiata pagariyaptinmi, Jasonta y waquin creyicoqcunata cachariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tse tardinam apenas paqasyärëcaptin Pabluta y Silasta Jesusman creyicoqcuna despachecuyarqan Berea marcaman eucuyänanpaq. Tse marcaman chärirnam ewayarqan israel nunacunapa ellucayänan wayincunaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tse israel nunacunaqa Tesalonica marcacho caq israel nunacunapitapis mas juclayam cayarqan. Porqui allapa cushicurmi chasquiyarqan tse alli willaquicunata. Y cada junaqmi estudiayarqan Diospa palabranta Pablu yachatsiconqan rasonpa canqanta musyayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tsenopam atscaq israel nunacuna Teyta Jesusman creyicuyarqan, y griegu caq mas presisaq warmicunapis ollqucunapis creyicuyarqanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Peru Tesalonica marcacho caq israel nunacunanam Bereachona Pablu Diospa palabranta willapäquicanqanta musyarirnin, tseman ewecur nunacunata achachapecatsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tsemi Jesusman tsecho creyicoqcuna Pabluta jinallacho pushacurcur eucuyarqan lamar cuchunyaq, y Silaswan Timoteoqa Berea marcachomi quedacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pabluta pushaqcunanam Atenas marcayaq yanaqar eucuyarqan. Tsepitanam cuticayämorqan Silastawan Timoteuta ajalla Pablu caqman despachecuyänanpaq. Tsenomi Pablu mandashqa carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenas marcacho Silasta y Timoteuta shuyecarninnam Pablu shonquncho allapa yarpacachar llaquicorqan tse marcacho nunacuna imajincunata adoracuyaptin. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tsemi ellucayänan wayicunaman ewecur, tsecho israel nunacunawan y Dios cäsucoq griegu nunacunawanpis cäyitsinacur willapänacuyarqan. Y cada junaqmi plasaman chaq caqtaqa nunacunata Diospa palabranta willaparqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tseno quecarninnam Epicureus y Estoicos nishqan estudiaq allapa yachaq nunacunata Pablu parlaparqan. Y waquin caqcunanam queno niyarqan: —Que badulaqueqa ¿imataraq parlacun? —nir. Y waquincunanam niyarqan: —Que nunaqa mana reqishqantsic diospaqtaq parlapämantsic —nishpa. Tsenoqa pecuna niyarqan Jesus wanurïcur cawarimushqanpaq alli willaquita Pablu willapäcuptinmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tsenam Pabluta apacuyarqan ellucayänan Aeropagu nishqan sitiuman. Tsechonam tapuyarqan: —¿Tse mushoq yachatsicuyashqequita musyeta puediyäcü? ");
INSERT INTO qwhNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Porqui tse yachatsicushqequitanoqa manam imepis wiyayashqatsu cayä. Tsemi imano canqanta musyeta munayä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tse Atenas marcachoqa llapan nunacunam, caru marcapita tsecho yachaqcunapis imapis mushoq nobedäcunallata musyapacur willanacur cacuyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tsenam Pabloqa ellucayashqan Aeropagu nishqan sitiucho quecar, chopincunaman shäcurir queno nerqan: “Atenas marca nunacuna, noqam cuentata qocü qamcuna allapa relijiosu cayanqequita. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Porqui purenqäcunachomi ricarqö, imajinniquicunata adorayänequipaq altarnincuna rurayanqequita. Tsechomi tarerqö queno escribirëcaqta: ‘Que altarqa mana reqishqa Diospaqmi’ neqta. Y tse Diosta mana reqishpa adorecayanqequipaqmi canan noqa parlapäyäshqequi. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Tse Diosmi rurashqa que patsata llapan caqnincunatawan. Pëqa rara sielucho y patsacho mandacoq Diosmi. Y manam nunacuna rurayanqan templuchoqa tärantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ni wanantsu manam nunacuna imatapis qarayänanta; antis pe imecatapis qomarnintsicmi yanapamantsic y cawenintsicpis qomantsic. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","27","“Diosmi juc nuna camanqanllapita miratserqan jinantin munducho tuquilaya nunacuna cawayänanpaq. Pemi dispunishqa ime tiempucamayaqpis cawayänanpaq y me laduchopis yachayänanpaq, y camacoq Diosta quiquincuna ashiyänanpaq. Capas imanollapapis taricuyanman. Imano carpis, Diosta reqinantsicpaqqa manam allapa sasatsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porqui Dios munaptinmi, yuricuntsic, cawantsic y imatapis rurantsic. Une luwa ruraq marca mayiquicunam escribirnin queno niyarqan: ‘Llapantsicpis Diospa castanllam cantsic’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Diospa castanlla quecarqa, manam creyinantsictsu nuna munanqanno orupita qellepita o rumipita rurashqa imajinno Diosnintsic canqanta. Tse imajincunataqa nunacunallam quiquincunapa yarpenincunamanno ruracuyashqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Une tiempum Dios tse nunacunapa mana alli yarpenincunapita pasensiacorqan; peru cananqa jinantin marcacho nunacunatam mandan pellatana cäsucuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porqui Diosmi sitashqa juc junaqta, enteru munducho nunacunata rurayanqanmanno acrashqan nunatawan jusgatsinanpaq. Y tseno canqanta musyanantsicpaqmi tse nunata wanushqanpita Dios cawariratsimorqan.” ");
INSERT INTO qwhNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wanurir cawarimipaq Pablu tseno parlecuptinnam, waquin nunacuna burlacurnin asipäyarqan. Y waquincunanam queno niyarqan: —Tsetaqa yapechonam parlapäyänanqui —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tseno niyaptinnam Pablu yarqur eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Peru waquincunaqa Pabluta qatiyarqanmi y Teyta Jesusman creyicuyarqanmi. Pecunachomi carqan Dionisiu jutiyoq nuna. Pemi carqan Areopagucho autorida. Y Damaris jutiyoq warmipis y waquin atscaq nunacunapis. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tsepitanam Pablu Atenaspita eucorqan Corinto marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tsechonam reqinacuriyarqan israel casta Aquila jutiyoq nunawan. Pe carqan Pontu marcacho yuricoqmi. Tse junaqcunallaran Aquilaqa warmin Priscilawan chärishqa cayarqan Corintoman, ˻Romapa˼ Italia marcanpita eucurnin. Porqui Roma marcacho mandacoq Claudium mandacorqan llapan israel casta nunacuna Roma marcapita eucuyänanpaq. Pablunam watucaqnincuna ewarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pecunaqa Pabluno qarapita carpa ruraqmi cayarqan, y tse ofisiuncuna iwallla captinmi, Pablupis pewan quedacorqan juntu uryayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Y cada jamacuyänan junaqmi ellucayänan wayiman ewar, Pablu israel caqcunata y mana israel caqcunatapis willaparnin, imecanopapis cäyitsita tïraq. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia marcapita Silaswan Timoteu chäriyaptinnam, Pabloqa cada junaq Diospa palabranta willapäcorqan. Y israel mayincunatam Jesus Dios Acrashqan cashqanta cäyitsita tïraq. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Peru israel nunacunanam Pabluta asharnin, contran cacurcuyarqan. Tsenam Pabloqa ropanta tapsicurir, queno nerqan: —Quiquiquicunam culpayoq cayanqui. Noqaqa willapäyarqoqnam, y manam culpayoqnatsu cashaq. Cananpita witsepam mana israel caq nunacunaman willapäcoq eucushaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tseno nirirninnam Pabloqa yarqurir eucorqan ellucayänan wayi ladunllacho yachaq Dios cäsucoq Titu Justo jutiyoq nunapa wayinman. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Y ellucayänan wayicho mandacoq Crispu jutiyoq nunaqa Teyta Jesusman creyicorqanmi wayincho llapan castancunawan. Tsenollam tse Corinto marcacho nunacunapis tse willaquita wiyacurnin, atscaq creyicurnin bautisacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Juc paqasnam apostol Pabluta Teyta Jesus rebelarqan queno nishpa: “Pablu, ama imatapis mantsaquïtsu, antis siguï willacur mana upallarishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Porqui noqam qamwan quecä. Manam ni pi imatapis rurayäshunquitsu. Que marcacho nunacuna atscaqmi noqaman creyicayämonqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tsemi Pablu quedacorqan tse Corinto marcacho juc wata y pullan Diospa palabranta yachatsicurnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tse tiempum Acaya marcacho Galion jutiyoq nuna mandacoq prefecto quecarqan. Tse autoridapa despachunmanmi llapan israel nunacuna yachatsinacurir, Pabluta apayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Y chäratsirnam, queno niyarqan: —Que nunam llapan nunacunata creyitsipäcun juclayapa Diosta adorayänanpaq. Y tseqa leynintsicpa contranmi —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablu parlacurinanpaq quecaptinnam tse autorida Galion israel nunacunata queno nerqan: —Que nuna ˻Roma˼ leypa contran imatapis rurashqa captenqa, ¡Imanirraq manaqa atendicuyaqmantsu israel nunacuna! ");
INSERT INTO qwhNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Peru qamcunapa creyensiequicunta, y juticunapaq parlaquicunataqa, y leyniquicunapaq liryaquicunataqa, quiquiquicuna imanopis areglacuyë. Manam quecunata areglayänaqpaq noqaqa meticamütsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tseno nishpam llapan israel nunacunata despachunpita qarqulerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tsenam ellucayänan wayicho mandacoq Sostenes jutiyoq nunatana tsarircur, tse despachupa waqtancho allibuenu maqaquicuyarqan. Y tseta ricarninpis, Galiontaqa manam imapis qocorqantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pabloqa alli uneran quedacorqan Corinto marcacho. Tsepitanam creyicoqcunapita despidiquicurnin, Pablu barcuwan eucorqan Aquilawan y Priscilawan Siria nishqan marcaman. Manaraq eucurninmi, Cencreacho Pablu aqtsanta ruturatserqan, Diosta änishqanta cumplirnin. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso marcaman chäriyaptinnam Pabloqa Priscilapita y Aquilapita raquicacurerqan. Y ellucayänan wayicunaman ewecurmi, tsecho israel mayincuna ellucashqacunawan parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tsenam rogayarqan Pablu unepa tsecho quedacunanpaq, peru Pablu manam munarqantsu, ");
INSERT INTO qwhNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Sinoqa pecunapita despidiquicurmi, “Dios munaptenqa qamcunaman yapechonam watucayaqniqui cutiramushaq” nishpa, barcuman lloqarcur Efesopita eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea marcaman chärirnam, Jerusalencho quecaq creyicoqcunaman watucaq ewarqan. Tsepitanam Antioquia marcaman pasacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antioquiacho alli une cacurirnam, Galacia y Frigia probinsiacunapa pasarqan y marcan marcan purirninmi, Jesusman llapan creyicoqcunata mas callpata qorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tse junaqcunam Efeso marcaman chärerqan Apolu jutiyoq nuna. Pëqa carqan Alejandria marcacho yuricoq israel nunam. Y tse Apolum Diospa palabranta alli buenu yachaq y cösa willapäcoq carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Pemi Teyta Jesus yachatsicushqancunata allipa musyarqan y shonquncho allapa cushishqam Teyta Jesuspaq rasonpa caqta yachatsicoq. Pëqa bautisacoq Juan yacuwan bautismupaq yachatsiconqanllatam musyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tse Apolum tsecho ellucayänan wayiman ewecur mana ichicllapis mantsacurishpa Teyta Jesuspaq yachatsicur qallaquicorqan. Peru Priscilawan Aquilanam parlashqanta wiyecur juc laduman pushecur mas allipa cäyitsiyarqan Diospa alli willaquininta. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tsepitanam Acaya marcapa Apolu eweta munaptin Efeso marcacho Jesusman creyicoqcuna peta mas baluratsir, Acaya marcacho Jesusman creyicoqcunaman cartacuyarqan Apoluta allipa chasquiyänanpaq. Acaya marcaman chärirnam, allipa yanaparqan Diospa cuyaquininrecur Teyta Jesusman creyicoqcunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Y llapan nunacunapa nopanchomi israel mayincunata Diospa palabran nenqanmanno tuquinopa cäyitserqan Jesusqa Dios Acrashqan cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Corinto marcaman Apolu euconqanchonam Pabloqa jirca caq nänipa eucurnin, Efeso marcaman chärerqan. Tsechonam Teyta Jesusman creyicoqcunata tarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tsenam pecunata queno taporqan: —Teyta Jesusman creyicurnin, ¿Santu Espirituta chasquiyarqonquicu? —nishpa. Tse creyicoqcunanam queno niyarqan: —Manam nunca wiyayashqatsu calläyä Santu Espiritu cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablunam yape taporqan: —¿Tsepenqa imanollataq bautisacuyarqonqui? —nishpa. Pecunanam queno yasquiyarqan: —Bautisacoq Juan yachatsiconqannollam bautisaculläyarqö —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tsenam Pablu nerqan: —Bautisacoq Juanqa nunacunata bautisarqan jutsancunata jaqirïcur Diosman cutiquicuyänanpaqmi. Peru willapäcorqan pepa qepanta shamoq Jesusman creyicuyänanpaqmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pablu tseno neqta wiyecurnam, Teyta Jesusman creyicurnin, tse creyicoqcuna bautisacuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablu maquinta pecunaman churar bendisiptinnam Santu Espirituta chasquiriyarqan. Tsenam juclaya idiomapa parlayarqan, y Dios parlamoqnomi parlarpis qallecuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pecunaqa chunca ishquenomi (12) cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tse marcacho ellucayänan wayicunaman ewarmi, quima quillanpi ichicllapis mana mantsacurishpa Diospa mandaquininpaq Pablu nunacunata willapar imanopapis cäyitsita tirarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Peru waquin nunacunanäqa rumi shonqu carmi, mana ichicllapis munayarqantsu creyita, sinoqa llapan nunacunapa nopanchomi tse mushoq yachatsiquicunapa contran parlayarqan. Tsenam Pabloqa pecunapita raquicacurir, creyicoq caqcunata pushacurcur eucorqan Tiranu niyanqanpa yachatsicuna wayinman. Y tsechomi cada junaq yachatsicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tseno yachatsicorqan ishque wata rurinmi. Tsemi enteru Asia marcacho israel caqcuna y mana israel caqcunapis Teyta Jesuspa alli willaquinincunata llapancuna musyariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Apostol Pablum Diospa poderninwan espantaquipaq milagrucunata rurarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pablupa pañunta o yacarashqan ropancunata prestacur aparmi, qeshyaqnincunata toparatsiyaq. Tsenopam qeshyaqnincuna cachacäriyaq, y supëyoq nunacunapita supëcunapis eucuyaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tse tiempum waquin israel nunacuna jinantinpa puriyarqan nunacunapita supëta qarqupacur. Y Jesuspa poderninwan cachacätsiquita munarninmi, pecunapis supëcunata queno niyarqan: “¡Pablu willacushqan Jesuspa poderninwanmi mandaq que nunapita yarqunequipaq!” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tseno ruraqcunaqa cayarqan saserdoticunapa mandacoqnin Esceva jutiyoq israel nunapa qanchis tsurincunam. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Peru nunacho quecaq supënam queno yasquicamorqan: “Jesustaqa reqïmi. Y apostol Pablu pi cashqantapis musyämi; peru qamcunaqa ¿pitaq cayanqui?” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tse öram tse supëyoq nuna pecunata tsarircur, allibuenu maqaquicorqan bensenqanyaq. Allapa maltratecuyaptinnam, tse nunacuna wayipita qalapachu yawarllana safacur coricuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Tseno pasacushqantam Efeso marcacho täraq israel caqcuna y mana israel nunacunapis musyariyarqan, y allapam mantsacäcuyarqan. Tsenopam llapan nunacuna alabayarqan Teyta Jesusta. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Y atscaqmi Teyta Jesusman creyicushqacunapis chäyarqan puntata mana alli rurayashqancunata llapan nunacuna nopancho willacur. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tsenollam brujeria ruraq brujucunapis majia libruncunata apecur, nunacunapa nopancho limpu cayecuyarqan. Tse librucunapa chanintam calculariyarqan pitsqa chunca waranqa (50,000) qellepa chaninta. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tsenopam Teyta Jesuspa alli willaquinin jinantinman chärerqan, y musyariyarqan allapa poderyoq cashqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tsecuna pasacushqanchonam Pablu pensarqan Macedonia marcata y Acaya marcata watucarir Jerusalencama eweta. Y nerqanmi, “Jerusalenpitaqa Roma marcamannam pasacushaq” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Y ishcaq yanapaqnincunatam Macedonia marcaman cacharqan, pecunam cayarqan Timoteu y Erastu. Peru Pabloqa ichic uneran quedacorqan Asia marcacho. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tse junaqcunam Efeso marcacho allapa liryacurcuyarqan, Teytantsicpaq Pablu willapäconqan asuntu. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Juc nunam carqan Demetriu jutiyoq. Pëqa qellepita adornucunata ruraqmi carqan. Y ruraq imajin Dianapa templutano medallitacunatam. Tsecunata ranticurmi, uryaq mayincunawan atsca qelleta ganayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tse Demetrium uryaq mayincunata y tseno ofisiuyoq nunacunata qayaratsirnin queno nerqan: “Tëtecuna, qamcuna musyayanquim que ofisiuntsic alli ganatsimanqantsicta” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Peru ricayanqequinomi y wiyayanqequinomi, tse Pablu jutiyoq nuna puriquican nunacunata queno willapar: ‘Nunacuna rurashqan imajincunaqa manam adoranantsicpaqtsu’ nishpa. Tseno nishpam atscaq nunacunata engañar creyitsipäcun. Manam que Efeso marcallachotsu tseno rurashqa; sinoqa jinantin Asia marcantsicchomi. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Queqa manam allinotsu. Y negosiuntsicllatatsu manam perdishun, sinoqa allapa reqishqa imajinnintsic Dianapa templuntapis manam respetayanqatsu. Tsenopaqa que Asia marcantsiccho y jinantin munducho adorashqantsic imajin Dianapis pasepa melanashqam ticrarenqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetriu tseno nenqanta wiyecurnam, nunacuna llutepa piñarcurnin qaparipa queno niyarqan: “¡Allapa puedeqmi mamällantsic Dianaqa que Efeso marcacho!” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tsenam tse marcacho mana imano quetapis puedir, Macedonia marcacho yuricoq Gayuta y Aristarcuta tsaricurcuyarqan. Y qaracharcurnin, llapancuna juclla apacuyarqan nunacuna ellucayänan jatun pampaman. Gayuwan Aristarcoqa Pablupa yanaqincunam cayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tseta musyecurnam apostol Pabloqa eweta munarqan, tse ellucayashqancho nunacunata parlapänanpaq, peru Jesusman creyicoqcunanam ˻ewananta mana munarnin˼ atajayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Tse Asia marcachomi waquin caq autoridacunaqa Pablupa amiguncuna cayarqan. Tsemi pecuna Pabluman willacaratsiyarqan ellucayashqa quecaq nunacunaman mana ewananpaq y mana meticunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tseyaqnam tse juntacäyanqancho nunacunaqa limpu qaparicachar jucta jucta parlar caquicayarqan, y manam imano queta puediyarqantsu. Y waquincunanäqa pasepa manam musyayarqantsu imapaq juntacäyashqantapis. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tsenam Alejandru jutiyoq nunata tse israel nunacuna llapan nunacunapa chopinpita jorqarïcurnin, parlacurinanpaq nopancunaman churariyarqan. Tsenam Alejandroqa maquinwan señasta rurarqan nunacuna upälla cayänanpaq. Y defendiquita munarninmi llapan wiyaqcunata cäyitsirnin parlapëta munarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Peru Alejandru, israel nuna canqanta cuentata qocurirnam, casi ishque örano juc shimilla qaparicachäcuyarqan queno: “¡Allapa puedeqmi Diana que Efeso marcacho!” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Porfinnam tse marcacho escribanu bullaquicaqcunata upällaratserqan. Tsepitanam queno nerqan: “Efeso marca nunacuna, enteru munducho nunacunam musyäyan allapa puedeq Dianapa templun que Efeso marcacho canqanta y sielupita jeqamushqa imajin quecho canqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tsecunataqa manam pipis negueta puedintsu. Tsemi shumaq pasiwaquicuyë. Ama mana alleq musyarishpaqa imatapis rurayëtsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Que ishcan nunacuna apayämonqequeqa, manam imajinnintsiccunapa templunta ni imanta yatayashqatsu ni manam contranpis parlayashqatsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sitsun Demetriu y uryaq mayincuna piwanpis liryashqa cayanqa, tsetaqa corticunacho juescuna demandacuyaptin areglayätsun. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Sitsun qamcunapa cayäpushunqui juclaya caq demandequicuna, tsetaqa autoridacuna shumaq areglayätsun. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Peru canan que asuntupitaqa, paqtataq mana alliman jeqacurcushqa lebantecamashwan, ‘Pecunam que bulla qallaq cayan’ nir. Porqui manam imanopa defendiquita puedishuntsu, que bullaquicunapaq autoridacuna tapumashqa” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tseno nirirnam, llapan nunacunata witsiratserqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tse bullaquicuna pasacurishqanchonam Pabloqa Teyta Jesusman llapan creyicoqcunata qayaratsir alli buenu willapëcorqan, y pecunapita despidiquicurnin, Macedonia marcaman eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Tse marcaman chärirnam, Jesusman creyicoqcunata callpata qornin marcan marcan watucar shumaq yachatsicur purerqan. Tsepitanam Grecia marcaman pasacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tsechomi quima quillanpi quedacorqan. Siria marcaman barcuwan eucunanpaq quecaptinnam, Pabloqa musyarerqan israel mayincuna wanutsiyänanpaq parlayanqanta. Tsemi jucnopana pensacurcur cuticorqan Macedonia marcacunapa. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pablupa yanaqincunaqa cayarqan: Sopatrum (pëqa carqan Pirrupa tsurinmi y Berea marcapitam carqan), Aristarcum y Segundum (pecunaqa cayarqan Tesalonica marcapitam), Gayum (pëqa carqan Derbe marcapitam), jina Timoteum, Tiquicun y Trofimum (pecunaqa cayarqan Asia marcapitam.) ");
INSERT INTO qwhNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pecunam Troas marcaman puntäcuyarqan y tsechomi shuyayämarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Lebadurannaq tanta miqui fiestata pasarirninnam, Filipos marcapita eucuyarqä barcuwan. Pitsqa junaqtanam puntaq yanaqïcunawan Troadecho juntacäriyarqä, y qanchis junaqmi tsecho quedacuyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Semana qallanan domingu junaqnam llapäcuna ellucayarqä santa senata juntu micuyänäpaq. Pablunam waränin junaq eucunan captin pullan paqasyaq willapäquicorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tse juntarëcayanqä wayipa rara caq cuartunchomi atsca chiuchicuna rupecayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Y juc jobin Euticu jutiyoqnam bentanacho punucarcuyan tëcarqan. Pablu allapa une willapäquicuptinnam, tse jobin punï bensiptin tse quima caq pisupita jeqacurcorqan; y pallarcuyarqan wanurishqatana. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablunam jina bajaramur jobinta juclla mellqarcamorqan. Y Jesusman creyicoqcunatanam nerqan: —Ama mantsacäyëtsu. Que jobenqa cawecanmi —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tsepitanam Pabloqa juntarëcayanqanman lloqarcur, santa senata selebrar usharirnin, micuyarqan. Tsepitanam patsa wareyaq willapäcurir, eucorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jesusman creyicoqcunanam tse jobinta cawecaqtana pusharcur, cushi cushi eucuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Noqacunaqa barcuman lloqarcurmi, puntäcuyarqä Aso nishqan puertuyaq, tsecho shuyanacuyänäpaqmi Pabluwan parlayarqä. Porqui Pabloqa chaquipa shamitam munarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso nishqan puertucho tincuriyaptïnam, barcuman lloqaramorqan, tsenam ewacuyarqä Mitilene marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tsepita eucurninnam, waränin junaq chäriyarqä Quio nishqan isla frentinman. Y waräninnam quedacuriyarqä Samos nishqan islacho. Tsepita eucurninnam, waränin junaq chäriyarqä Miletu marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Asia marcacho mana demoracuyänärecurmi Efeso marcamanqa Pablu yequita munarqantsu, porqui Jerusalen marcaman apuradu chëtam munarqan pentecostes fiestata tsecho pasananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletu marcacho quecayaptïnam, Efeso marcacho creyicoqcunapa mandacoqnincunata Pablu qayaratserqan Miletu marcaman shayämunanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pecuna chärayämuptinnam, queno parlaparqan: “Qamcuna allim musyayanqui Asia marquequicunaman chämushqäpita patsa imano portacushqäta. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Imepitapis qamcunawan juntum carqö qollmi shonquwan waqariryan Diosta sirwirnin, israel nunacuna chiquiyämarnï melanecayämaptinpis. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Peru manam jaqerqötsu bienniquicunapaq caqta willapäyarniqui, callicunachopis wayicunachopis llapantam willapäyashqa cayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Israel caqcunatapis y mana israel caqcunatapis cäyitsiyarqaqmi llapan jutsequicunata jaqirïcur Teyta Diosman cutiquicuyänequipaq y Teyta Jesucristumanna creyicuyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Y cananqa Santu Espiritum pasepa musyaratsimashqa Jerusalenman ewananäpaq. Y manam musyätsu tsecho ima pasamänantapis. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Peru musyämi cada marca chanqächo carselllanä sufrimientullana shuyamanqanta Santu Espiritu cäyitsimaptin. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Peru wanuratsiyämänan captinpis, noqataqa manam ni ima qocamantsu, antis Dios alli queninwan cuyamanqantsictam ushanqäyaq willacur siguishaq, porqui alli willaquininta willacunanpaqmi Teyta Jesus acramashqa. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Qamcunatam Diospa mandaquininpaq willapäyarqoq y mananam ni meqequi ricayämanquinatsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tsemi claru willecayaq, y mananam culpayoqnatsu cashaq mana creyicuyanqanrecur castigashqa cacuyaptiquipis. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Porqui Diosnintsic llapan nenqantam willayashqa cayaq jucllellatapis mana pantarishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tsemi alleq cuidacuyänequi yo, y llapan creyicoqcunatapis shumaqmi cuidayänequi. Tsepaqmi Santu Espiritu churayäshorqonqui üsha mitseq cuenta Teyta Jesusman creyicoqcunata cuidayänequipaq. Pecunaqa Jesucristupa yawarninpa chaninmi cayan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Noqa musyämi eucushqächo imeca mallaqashqa atoq üshacunata micoq cuenta, mana alli yachatiscoqcuna Teyta Jesusman creyicoqcunata ushacätsita munar shayämunanpaq caqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Qamcunapitam waquinniquicuna llutan camanta yachatsicur qallaquicuyanqa Jesusman creyicoqcuna qaticurcuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tsemi mäcoq mäcoq cayänequi; yarpäyë quima wata enteru paqasta junaqta waqariryan llapequicunata willapäyanqaqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Wauqicuna, panicuna, cananqa Diospa boluntaninllachonam y alli queninta cäyitsicoq willaquininllachonam jaqiriyaq. Tse willaquininmi cäsucuyaptiqueqa, marcäquiniquicunacho mas firmi tsarecuyäshunqui llapan acrashqan caqcunawan wiñe cawe erensianta chasquiyänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Noqa manam pipa qelleninta, orunta, ratashnincunata codisyashqatsu cä. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Qamcuna musyayanquim imapis faltäcunapaq quiquï uryapuconqäta; y ˻manam noqallapaqtsu uryapucorqa sinoqa˼ yanaqïcunapaqwanmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tuquinopam yachatsiyarqoq noqanolla uryacurnin cayänequipaq, y tsenopa pishipäcoq nunacunatapis yanapayänequipaq. Yarpäyë Teyta Jesus queno nenqanta: ‘Qaraquimi mas cushiqueqa chasquir cushiquipitapis’ ” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Tseno willapäcur usharirnam, Pabloqa llapancunawan qonquriquicurnin Diosman mañacorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tsepitanam llapancuna allapa llaquiquiwan waqaquicuyarqan, y Pablutanam waquparnin mutsayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Peru Pablu “Mananam mas ricayämanquinatsu” niptinmi, allapa llaquicuyarqan. Tsepitanam barcuyaq yanaqäyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pecunapita despidiquicurnam, barcuwan eucuyarqä defrenti Cos nishqan islaman. Y waräninnam pasacuyarqä Rodas nishqan islaman. Tsepita pasacurnam, chäriyarqä Patara nishqan puertuman. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tsechonam juc barcuta taririyarqä Fenicia marcaman yarqurëcaqta. Tseman lloqarcurnam, eucuyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Biyajecarnam, Chipre islata ricariyarqä itsoq laducunacho quecaqta. Defrenti pasacurnam, chäriyarqä Siria marcacho Tiro nishqan puertuman; porqui tsechomi apayanqancunata barcupita descargayänan carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tsecho Jesusman creyicoqcunawan tarinacurnam, juc semana pecunawan quedacuyarqä. Tse creyicoqcunam Santu Espiritu cäyitsiyaptin Pabluta niyarqan Jerusalenman mana ewananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tseno juc semana täcurirnam, ewacuyarqä. Jesusman creyicoqcunanam warmincunawan wamrancunawan tse marcapa jaqninyaq yanaqäyämarqan. Lamar cuchunman chëcurnam, qonqurïcur Diosman mañacuyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tsepitanam pecunapita despidiquicur barcuman lloqarcur eucuyarqä. Y pecunanam wayincunata cuticuyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiropitanam Tolemaida nishqan puertuman eucurnin, barcupita bajayarqä. Tsechonam Jesusman creyicoqcunata watucaqnin ewayarqä, y pecunawan quedacuyarqä juc junaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Waränin junaq eucurnam, chäriyarqä Cesarea marcaman. Y ewayarqä Diospa palabran yachatsicoq Felipipa wayinmanmi. Felipeqa tse qanchis acrayashqanpita diacono carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pepam caporqan chuscu donsella shipashnincuna; pecunam profetanno Diospaq parlayarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tsecho atsca junaqcuna quecayaptïnam, Diospa profetan Agabu jutiyoq nuna Judea marcapita chäramorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Noqacunaman witiramurnam, Pablupa wachucunwan quiquin Agabu maquinta chaquinta watäcurerqan queno nishpa: —Santu Espiritum nin, ‘Jerusalenman chäriptin que wachucupa dueñunta israel nunacuna queno watayänanpaq caqta y mana israel caqcunaman entregayaptin carselman llawitsiyänanpaq caqta.’ ");
INSERT INTO qwhNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tseta wiyecurnam, noqacuna y tse marca nunacuna allapa waqar rogayarqä Pabluta Jerusalenman mana ewananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Peru Pablunam queno niyämarqan: —¿Imanirtaq waqayanqui? Tseno carqa, shonqütapis llaquitsiyämunquim. Noqaqa manam watayämänanllapaqtsu listu quecä; sinoqa Teyta Jesusrecur Jerusalencho wanunapaqpis listum quecä —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Jarcäyänäpaq mana conbensitsita puedirninnam, jaqiriyarqä queno nishpa: “Dios munashqanno catsun” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tsepitanam alistapäcurirnin, Jerusalenman jeqariyarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Teyta Jesusman Cesarea marcacho waquin creyicoqcunam yanaqäyämarqan. Pecunam pushayämarqan Chipre islacho yuricoq Mnason jutiyoq nunapa wayinman. Pemi Teyta Jesusman unepitana creyicushqa carqan, y wayinchomi posadacuyäna carqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalenman chäriyaptïnam, tsecho creyicoq wauqicuna cushishqa chasquirayämarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Waränin junaqnam Pabluwan ewayarqä Santiagu watucaq. Tsemanmi jina mandacoqcunapis juntacäräyämorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablunam pecunata saludarnin, willacorqan Dios peta yanapaptin, mana israel caqcunacho llapan ruranqancunata. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tseta wiyecurnam, llapancuna Diosta alabarnin, queno niyarqan: —Wauqi Pablu, allipam musyanqui israel mayintsiccuna waranqapayan Teyta Jesusman creyiquicuyashqanta. Peru pecunaqa allapam munayan Moises mandacushqan leycunataraq cumplinantsicta. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Peru qampaqqa pecuna mäcuriyashqannam, mana israel nunacunacho täraq israel mayintsiccunata, Moisespa leyninta mana cäsushpa, wamrancunata mana señalatsiyänanpaq yachatsenqequita y costumbrintsiccunata mana cumpliyänanpaq yachatsiconqequita. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“¡Cananqa quechona quecanqequita musyariyanqachi! ¡Canan imanotaq carishun! ");
INSERT INTO qwhNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mejorqa queno rurequï: Quechomi chuscoq nunacuna quecayan Diosta sirwiyänanpaq comprometicushqacuna. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pecunata pusharcur costumbrintsicmanno ewë templuman limpiacoq, y pecuna aqtsancunata rututsir gastayanqanta paguequï. Tseno ruraptiquim, llapan nunacuna cuentata qocuriyanqa qampis Moises mandacushqan leycunata cumplir siguicanqequita y qampaq mana caqta parlayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Peru Teyta Jesusman creyicoq mana israel caqcunapaqqa acuerduta rurecurmi, quecunallapita cuidacuyänanpaq queno nishpa cartacuyarqä: ‘Imajincunata qarayashqan etsacunata ama micuyänquitsu, jurcaquëpa wanushqa animalcunapa yawarninta ni etsanta ama micuyanquitsu ni jucwan jucwan ama yachacuyanquitsu’ ” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Waräninnam Pabloqa chuscun nunacunata pusharcur jeqarerqan Moises mandacushqanno limpiu cayänanpaq caqta cumpleq. Tsepitanam templuman yecuriyarqan limpiuna cayanqanpita ime junaqpis Diospaq qarenin cada unu apayänanpaq caqta saserdotita willayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Peru tse qanchis junaq tincumunanpaq ichicllana pishicaptinnam, Asia marcapita shamoq israel nunacuna Pabluta templucho riquecur llapan nunacunata willapëcuyarqan Pablupa contran shäricurcuyänanpaq. Tsenam Pabluta tsaricurcur, ");
INSERT INTO qwhNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","queno qaparïcuyarqan: “Israel marca mayïcuna, yanapayämë. Que nunam jinantinpa purirnin, yachatsicun marcantsicpa contran, Moises mandacushqan leycunapa contran y que templuntsicpa contran. Manam tsepis tsellatsu, sagradu templuntsicmanmi desonrarnin, yecatsishqa mana israel caq nunacunata” nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Quenoqa niyarqan Efeso marcacho yuricoq Trofimuwan callicho juntu puriyaqta ricashqa carninmi, tsemi pensayarqan peta templuman yecatsishqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tsenam llapan nunacuna allapa piñarcurnin, templuman jeqaquicuyarqan. Pabluta tsarircurninnam qaracharcur waqtaman jorquriyarqan. Y puncucunatapis juclla wichariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pabluta wanuratsiyänanpaq quecayaptinnam, romanu soldaducunapa comandantinta willariyarqan Jerusalen marcacho nunacuna tse bullaquicho caquicayanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tsenam comandanteqa ofisialnincunata y soldaduncunata qayaratsir, coripa ewayarqan tse bullaquicayanqanman. Comandantita soldaducunatawan yecurëcaqta riquecurnam, tse bullaquicaqcuna Pabluta maqecayanqanta pärariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tsenam comandanteqa chëcur Pabluta juclla tsarircamorqan y soldaduncunata ordinarerqan ishque cadenawan watäyänanpaq. Tsepitanam nunacunata taporqan Pablu pi canqanta y imata rureconqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Peru atscaq nunacuna bullacur jucta jucta parlayaptinmi, cäyerqantsu imanir Pabluta maqayanqanta. Tsenam soldaduncunata mandarqan Pabluta cuartelman apayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Cuartelpa gradanman chäratsirnam, Pablutaqa soldaducuna wanturcurna, apacuyarqan tse piñashqa nunacuna maqeta munayaptin. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Y llapan nunacunam qatiyarqan qaparir “¡Tse nunaqa wanutsun! ¡Tse nunaqa wanutsun!” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Cuartelman llawiriyänanpaq quecayaptinnam, tse comandantita Pablu queno nerqan: —¿Imallatapis parlapärillaqmancu? —nishpa. Tse comandantinam nerqan: —¿Qam yachanquicu griegu idioma parleta? ");
INSERT INTO qwhNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tsepenqa ¿manachi qamtsu canqui chuscu waranqa (4,000) asesinucunata tsunyaqman pushecur cesarpa contran cayänanpaq yachatsicoq egipsiu nuna? ");
INSERT INTO qwhNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablunam nerqan: —Noqaqa israel nunam cä, Cilicia marcapa capitalnin Tarsu marcacho yuricoq. Rogacushqequi: Ama acseqa quëtsu que nunacunata parlapärishaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tse comandanti “Allim canqa, parlapäriquï” niptinnam, Pabloqa gradaman shacurir, maquinwan señasta rurarir nunacunata upälläratserqan. Upalläriyaptinnam hebreu idiomacho nunacunata parlaparqan queno: ");
INSERT INTO qwhNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Marca mayïcuna y tëtecuna, canan wiyecayämë que acusayämanqanpaq parlacaramonqäta —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pabluta hebreu idiomacho parlaqta wiyecurninnam, upällariyarqan. Tsenam Pablu nerqan: ");
INSERT INTO qwhNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Noqaqa israel nunam cä, Cilicia marcapa Tarsu puebluncho yuricoq. Peru que Jerusalenchomi llullunpita winacushqa cä, escuelachopis doctor Gamalielmi profesornïpis carqan. Pemi une castantsiccuna mandacushqan leycunata cumplinäpaq allapa alcabu yachatsimarqan. Tsemi imepis llapan shonqüwan Diosta sirwita tïrashqa cä, canan junaqcuna qamcuna sirwiyanqequino. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tsemi noqa mas puntata, Teyta Jesusman creyicoqcunata wanutsirnin, chiquir qaticacharqä; y warmitapis ollqutapis presu tsarircurmi, aparqä carselman llawiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Saserdoticunapa mayorninmi y llapan autoridacunam testigu cayan. Pecunam autorisasion cartata qoyämarqan Damasco marcacho israel mayintsiccunapaq. Tse cartawanmi ewarqä Jesusman creyicoqcunata tsarïcur que Jerusalenman apatsimur castigatsinäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Peru ewar Damasco marcaman naqana yecurëcaptïnam, pullan junaq quecaptin derepentita rara sielupita juclla noqaman actsi tillapyëcamorqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tsenam patsaman ishquirerqä, y jitarëcarnam wiyecorqä: ‘Saulu, Saulu ¿imanirtaq chiquir qaticachämanqui?’ nimaqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tsenam taporqä: ‘¿Pitaq canqui Teyta?’ nishpa. Niptïnam, queno yasquimarqan: ‘Noqaqa chiquir qaticachëcanqequi Nazaret marcapita Jesusmi cä’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Yanaqäyämaqnïcunapis tse atsicyëcamoqta ricayarqanmi, peru manam cäyiyarqantsu tseno parlapämanqanta. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tsenam noqa nerqä ‘Teyta, ¿imata ruranätataq munanqui?’ nishpa. Teyta Jesusnam queno nimarqan: ‘Sharcur Damasco marcaman juclla yequï. Tsechomi niyäshunqui imata ruranequipaqpis’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tse atsicyëmi wiscuyäratsimarqan. Tsemi yanaqecunallana janchashqa apayämarqan Damasco marcayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Tsechomi quecarqan Ananias jutiyoq nuna. Pemi Moises mandacushqan leycunata cäsucur cumpleq, y Damasco marcacho llapan täraq israel nunacunam pe alli ruraq canqanta parlayaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tse Ananiasmi nopäman witïcamur queno nimarqan: ‘Wauqi Saulu, sanunam canqui, ricachaquina, nishpa. Tse öram nawïlla cachacäriptin ricachacurerqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tsenam Ananias queno nimarqan: ‘Une awiluntsiccunapa Diosninmi acrashushqanqui pepa boluntaninta musyanequipaq, y quiquin Jutsannaqta riquecunequipaq, y parlapäshonqequita wiyecunequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Qammi pepa testigun car ricanqequita y wiyanqequita llapan nunacunata willanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tsemi sharcur canantä juclla bautisaquï, y Diosman mañaquï Jesucristurecur jutsequipita perdonecushunequipaq’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Tsenam Damasco marcapita Jerusalenman cutïcur ewarqä templuman Diosman mañacoq. Mañaquicaptïnam, Dios rebelecamarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Tse rebelasionchomi Teyta Jesusta riquecorqä, y quenomi nimarqan: ‘Que Jerusalenpita jinallacho euquï, porqui quechoqa nunacuna manam cäsucuyanqatsu noqapaq willacuptiqui.’ ");
INSERT INTO qwhNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Tsenam noqa nerqä: ‘Teyta, pecuna musyayanmi llapan ellucayänan wayicunaman ewar, qamman creyicoqcunata carselman apar maltratar allqutsanqäta.’ ");
INSERT INTO qwhNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Qampaq willacoq sirwishoqniqui Estebanta wanïcätsiyaptinpis, noqam ricarar shëcarqä, tse wanutseq nunacunapa aqshunancunata cuidar, ‘Bienecho’ nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Peru Teyta Jesusnam queno nimarqan: ‘Ewë, noqam qamta cachaq caru marcacunapa ewar mana israel caqcunata palabräta willapänequipaq’ ” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pablu tseno nïcuptinnam, manana wiyeta munar qayaripa queno niyarqan: —¡Tse nunata juclla wanuratsiyë! ¡Amana cawatsunnatsu! —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tseno qaparicachar aqshunancunatapis weqapar y allpata raraman jitar qallaquicuyaptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tse tropapä comandantenqa mandarerqan cuartelman Pabluta llawiyänanpaq. Y ordinarqan astayänanpaq tsenopa imanir nunacuna pepa contran qaparicachäyanqanta declarananpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Peru astar qallarcuyänanpaq watarishqa, chicotincunawan listu quecayaptinnam, laduncho shëcaq ofisialta Pablu queno nerqan: —¿Qamcunapa derechiquicuna cancu, manaraq ima rurashqätapis musyarishpa roma nasion nuna quecaptï astacayämänequipaq? ");
INSERT INTO qwhNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pablu tseno nenqanta tse ofisial wiyecurnam, comandantiman ewar queno willarerqan: —Señor comandanti, cuidädu llutanta rurecushwan, porqui que nunaqa roma nunash. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tsenam tse comandanteqa Pabluman ewar queno taporqan: —¿Rasonpacu romanu nuna canqui? —nishpa. Pablunam yasquerqan: —Aumi —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tsenam tse comandanti queno nerqan: —Noqa roma nasion nuna canäpaqqa allapa atsca qelletam gastarqö —nishpa. Y Pablunam nerqan: —Noqaqa yuricushqäpitam roma nasion nuna cä. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tseta musyarirnam, Pabluta astayänanpaq quecaq soldaducuna eucuyarqan, asta comandantipis Pablu romanu canqanta musyarirninmi mantsacarqan, ¿Imapaqraq presutsir cadenatsillarqö? —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Waränin junaqnam Pabluta imapita israel nunacuna acusayanqanta musyeta munar, cadenawan watarëcanqanpita tse comandanteqa pascaratserqan. Tsepitanam llapan autoridacunata y saserdoticunapa mandacoqnincunata qayaratsir, Pabluta pecunapa nopanman sharatserqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablunam autoridacunata alli buenu ricarecur queno nerqan: —Israel mayicuna, wamra canqäpita asta canancamayaqmi alli consensiawan noqaqa Diosta sirwicä —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tsenam mas mandacoq saserdoti Ananias, Pablupa laduncho quecaq nunata Pabluta shimicho laqyecunanpaq mandarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Peru Pablunam mana mantsacushpa queno nïcamorqan: —¡Diosmi qamtapis castigashunqui, qamqa imeca yesuwan perqa shumaq blanquiyashqanollam canqui! ¡Tsechoqa tëcanqui ley nenqanmanno jusgamanequipaqmi; peru “Que nunata laqyë” nirnenqa, manataq cäsuconquitsu leynintsicta! ");
INSERT INTO qwhNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Pablupa laduncho quecaqcunanam Pabluta queno piñapäyarqan: —¿Tseno ashepacu nïcunqui Dios sirweq mas mandacoq saserdotita? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablunam queno nerqan: —Marca mayïcuna, noqa manam musyarqötsu pe mas mandacoq saserdoti cashqanta; porqui Diospa palabranmi queno escribirëcan: ‘Marquequicho autoridaniquicunapaq ama mana allitaqa parlayëtsu’ nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tsenam juntarëcaq autoridacunacho waquin fariseucuna y waquin saduseucuna cayashqanta musyarnin, Pablu queno qayarïcorqan: —Marca mayicuna, noqaqa fariseu nunam cä. Papänïcunapis fariseum cayashqa. Tsemi wanushqantsicpita cawarimunantsicpaq caqta creyicuptï canan que nopequicunacho acusecayäman —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pablu tseno nïcuptinnam, fariseucuna y saduseucuna quiquincuna pura liryar ishqueman raquicacuriyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porqui fariseucunaqa creyiyan wanushqacuna cawariyämunantam. Anjelcuna y supëcuna canqantapis creyiyanmi, peru saduseucunaqa tse cosascunata manam creyiyantsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tsemi llapancuna bullacurcuyarqan, y ley yachatsicoq waquin fariseucunanam sharcurcur queno niyarqan: —Que nunaqa manam ni ima mana allita rurashqatsu, capaschi juc alma o anjel tseno cananpaq parlapashqa. Ama meticushuntsu —nir. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tse bulla mas feyupa cacurcuptinnam, tse comandanteqa mantsacarqan, Pabluta wacpa quepa rachir ushacäratsiyänanta pensar. Tsemi soldaducunata qayaratsimur, mandarerqan Pabluta sutarir cuartelman cutitsiyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tse paqasnam Pabluta Teyta Jesus yuripur queno nerqan: “Ama imatapis mantsaquïtsu. Imanollam Jerusalencho mana mantsacushpa noqapaq parlacorqonqui; tsenollam Romachopis noqapaq parlacunequi presisan” nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Waränin junaqnam tse israel nunacunana yachatsinacuriyarqan Pabluta wanutsiyänanpaq. Y juramentutam rurayarqan Pabluta manaraq wanutserqa mana ni imatapis micuyänanpaq ni yacutapis mana upuyänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Tseno juramentu ruraq nunacunaqa cayarqan chuscu chunca (40) masmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pecunam saserdoticunapa mandacoqnincunaman y autoridacunaman ewar queno niyarqan: —Noqacunam juramentuta rurar comprometicuyarqö manaraq Pabluta wanutserqa imatapis mana micuyänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tsemi canan qamcuna jinallacho llapan autoridacunawan parlarir comandantita mañayë qamcunaman Pabluta yape apatsimunanpaq. ‘Pabluta mas allipa declaratsita munayä’ nishllapa jorqecatsiyämï. Noqacunanam shuyarëcayäshaq manaraq chätsiyämuptin wanuratsiyänäpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Peru Pablupa paninpa ollqu wawanmi wiyarqan rataquicur wanutsiyänanpaq parlayashqanta. Tsenam cuartelman apuradu ewar Pabluta willarerqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pablunam juc ofisialta qayarirnin, queno nerqan: —Que jobinta comandantiman pushequï, porqui comandantitam imatachi willeta munan —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tsenam ofisialqa comandantiman tse jobinta pushecur queno nerqan: —Tse presurëcaq Pablum qayecamarnï, rogamarqon que jobinta qamman pushamunäpaq. Peshi imatachi willashiniquita munan —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Comandantinam jobinta maquipita jancharcur juc laduman witiratsir pacallapa taporqan: —¿Imatataq willamänequi? —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tsenam tse jobin queno willarqan: —Israel nunacunam yachatsinacuyashqa, ‘Pablupa asuntuntam tapupar juclla aregleta munayä’ nishllapa, autoridacuna ellucayanqanman Pabluta apatsinequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Peru ama creyinquitsu, porqui chuscu chunca (40) masmi nunacuna rataquicur shuyarëcayan Pabluta wanuratsiyänanpaq. Tse nunacunam juramentuta rurayashqa Pabluta manaraq wanutserqa imatapis mana micuyänanpaq ni yacutapis mana upuyänanpaq. Tsemi shuyarëcayan qam apatsinequillatana. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tsenam comandanteqa tse jobinta despachecorqan queno nirnin: —Ama pitapis willanquitsu que nimanqequita —nishpa. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tsepitanam tse comandanteqa ishcaq ofisialnincunata qayaratsirnin, mandarerqan queno nishpa: —Alistayë qanchis chunca (70) soldaducunata cawalluncunatawan, ishque pachac (200) soldaducunatana lansancunatawan y mas ishque pachac (200) soldaducunatapis jina. Pecunam canan paqas lasnuebi ewayanqa Cesarea marcaman. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Jina alistayë juc cawallutapis Pablu montananpaq. Tsenopam Gobernador Felixman safatsiyanqui yameta y cawecaqta. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pecunawanmi apatserqan juc cartata queno escribishqata: ");
INSERT INTO qwhNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Señor gobernador Felix, noqa comandanti Claudiu Lisiasmi allapa respetuwan saludashniquipa que cartata apatsimü. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Que apatsimonqä nunatam israel nunacuna tsarircur wanutsita munarnin maqaquicayarqan. Peru romanu nuna cashqanta musyarirmi, soldaducunawan ewar washarnin librarqö. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Imapita acusayanqantapis musyeta munarninmi, israel nunacunapa autoridanincuna juntayashqanman aparqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tsechomi cuentata qocurerqä quiquincunapa leynincunarecurlla acusayanqanta. Peru wanunanpaqnoqa ni llawirananpaqnoqa manam ni ima jutsanta tarerqötsu. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Tsemi wanutsiyänanpaq yachatsinacuyanqanta musyecurnin, canan qamman apatsimü. Tse acusaqnincunatam cäyitserqö qampa despachiquiman shamurnin, tse nunata imapita acusayanqanta aclarayänanpaq. Mana imatapis masta nishniquipam despidïcurï.” ");
INSERT INTO qwhNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tsenam comandanti ordenashqanno soldaducunaqa tse paqas Antipatrisyaq eucuyarqan Pabluta aparcur. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Waränin junaqnam chaquipa ewashqa caq soldaducuna cuartelnincunaman cuticuyarqan, y cawalluwan ewaqcunanam Cesarea marcayaq Pabluta chätsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesarea marcaman chärirnam gobernador Felixta tse cartata y Pabluta entregariyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gobernador Felixnam cartata leyirirnin Pabluta taporqan mepita canqanta. “Cilicia marcapitam callä” niptinnam, ");
INSERT INTO qwhNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tse gobernador Felix queno nerqan: —Acusayäshoqniquicuna chäyämuptinran, areglashun asuntiquita. Tsepitanam tse gobernador soldaducunata ordenarerqan Herodispa palasiuncho cuidayänanpaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pitsqa junaq pasarishqanchonam mas mandacoq saserdoti Ananias waquin caq autoridacunawan chäriyarqan Cesarea marcaman. Pecunam pushayarqan Tertulu jutiyoq juc abogaduta. Tse abogaduwanmi gobernadorpa despachuncho Pabluta acusatsiyarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tseman Pabluta chäratsiyaptin, tse Tertuloqa Pabluta acusar qallecorqan, gobernador Felixta queno nishpa: —Señor gobernador, qamrecurmi shumaq pasaquicho cawacushqa cayä. Y allapa yachaq queniquiwanmi marcalläcunata ichicllapa ichicllapa mejoraquicanqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tsemi jinantincho allapa agradesicullayan, allapa reqishqa Felix. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Peru tiempullequita mana allapa perditsillashniquipam rogacullaq juc ratitulla wiyaramänequipaq. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Que nunatam tariyarqö imeca qeshyano jinantinpa purirnin, israel nunacunata tuquita willapar liryatsiquicaqta. Pëqa Nazarenu nishqan grupupa dirijentinmi. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Y Diosnïcunaman mañacuyäna templuta desonrar quecaptinmi, presu tsarïcurnin leynïcunamanno justisiata rureta munayarqä. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","˻Peru comandanti Lisiasmi soldaduncunawan shamicurnin, maquïcunapita malaspa qochiyämarqan. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Tsepitanam niyämarqan qamraq areglayämänequipaq.˼ Masqui canan quiquiqui tapurpis, llapan acusayanqä rasonpa canqantam musyarinqui. ");
INSERT INTO qwhNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ts