﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvzNT_vpl;
CREATE TABLE qvzNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvzNT_vpl WRITE;
INSERT INTO qvzNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Caigunami Jesucristohua huañuc apayaya shutiguna, paiga Davidmandas ñaupa Abrahanmandahuas mirai ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahanba churi Isaac ara, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judága ishcai (2) churita charira Fares Zaro nishcaguna, chi churigunahua mama Tamar ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramba churi Aminadab, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon Rahabhuan Boozta charira, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíba churi mandac rey amu David, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonba churi Roboan, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asahua churi Josafat, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa churi Jotan, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa churi Manases, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa churi Jeconias paihua huauquigunandi, israel runaguna Babilonia nishca llactama apai tucuushca uras pagaric anaushca. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israelguna lugaryashcahuasha Jeconias shuc ");
INSERT INTO qvzNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelba churi Abiud, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorba churi Sadoc, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudba churi Eleazar, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobohua churi Jose, ");
INSERT INTO qvzNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chasna acpi Abrahanmanda Davidgama chunga chuscu (14) miraiguna anaura, chasnallata David mandashca urasmanda israelguna Babiloniama apaitucushca urascama chunga chuscu (14) miraiguna anaura. Chi apai tucushca urasmanda Cristo pagarishca urascama chunga chuscu (14) miraiguna anaushca. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo pagarishcaga casna mara: Paihua mama Mariaga Jose tapushca asha paihuan chara mana llutariushcallaita Diospa Samai ushaihuan huicsayara. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ñáa paihua cari tucuna Josega Diospacpi ali runa ara. Alita pactachic asha pai tapushca huarmi Maria huicsayuc tucushcata yachasha paita saquinata yuyarira. Chasna ashallata tucui runa ñaupacpi paita pingachinata mana munasha, chunllamanda saquinata yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chasna pai yuyariushcai shu tuta muscuibi Diospa angel ricurimusha paita nira, mandac rey amu Davidmanda mirai Jose, ama manzhaichu camba huarmi Mariata japingahua. Chi paihua huicsaibi tiyac huahuaga Diospa Samaimandami. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Paiga shuc cari huahuata pagarichingami. Chi huahuataga Jesus nishcata shutichingui, paihua runagunata juchamanda quishpichingaraushcamanda chasna shutichingui, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yaya Dios chasna yuyaita cucpi Dios rimashcata shuc pasachic runa ñaupallata caimandami quillcashca. Chimi cunanga ña pactamushca: ");
INSERT INTO qvzNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Shuc malta huarmi huicsayuc tucunga, cari huahuata pagarichinga. Chi huahuata Emanuel nisha rimangauna, nira. Runa shimibi Emanuel nisha nin Dios ñucanchihuanmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jose puñushcamanda niccharisha Diospa angel rimashcata pactachisha Mariata japira paihua huarmi tucuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Paihuan chara mana llutarishca agllaita Maria punda cari huahuata pagarichira, paitaga Jesus nishcata shutichira. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus Judea provincia Belen llactai pagarishca uras Herodes chibi mandac amu ara. Chi uras shuc punzha indi llucshina partimanda estrellasta ricuusha yachac runaguna Jerusalen llactama shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pactamusha tapunaura, Israelgunata mandac jatun amu cunanlla pagarishcaga maibitaun. Indi llucshina partibi paihua estrellasta ricushcanchi. Chimandami paita alabangahua shamunchi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes chita uyasha ashcata manzharira, Jerusalenbi tiyaucunahuas chasnallata manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chasna manzharisha Herodes tucui pagrita mandaccunatas israel mandashcagunata yachachiccunatahuas cayasha paigunata tapura, Quishpichic Cristo nishcaga maican llactai pagarina tan. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tapucpi cuintanaura, Judea provincia Belen llactaimi. Casnami Dios rimashcata shuc pasachic runa quillcara: ");
INSERT INTO qvzNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea provinciai Belen llacta, tucui llactagunamanda mana pishicchangui. Canmandami shuc jatun mandac runa llucshingarauc. Paimi ñuca israel runagunataga ali cuirac amu tucunga, nisha Dios paihua runata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chita uyasha Herodes yachaccunata pacalla cayasha, Ima urasmandata chi estrellas ricurimushcata ricuranguichi, nisha tapura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tapushcahuasha paigunata Belen llactama cachara chasna mandasha, Chi huahuata mascagrichi. Paita tupasha ucta cuintahuac shamunguichi ñucahuas paita alabagringahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pai rimacta uyasha chi yachaccuna rinaura. Paiguna ñaupa ricushca estrellasca cutillata ricurisha paigunata ñaupasha rira, huahua aushca huasi cuscai shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Paiguna estrellasta ricushami yapa cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chi huasi ucuma yaicusha huahuata mamandi tupanaura. Chi huahua ñaupacpi cungurisha paita alabanaura. Chihuasha bultsagunata pascasha paiguna apamushca curita, incienso nishca balic asnaccunatas, mirra nishca balic huiquitahuas paima cumbiranaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chihuasha paiguna muscushcai Dios rimara mandac Herodespagma ama bulltianguichichu nisha. Chasna nicpi shuc ñambita risha paiguna quiquin llactama bulltianaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chi yachaccuna llucshisha rishcahuasha Diospa angel, Jose muscushcai ricurimusha rimara, Uctalla jatari, camba huarmita paihua huahuandi apasha miticugri Egipto llactama. Chillai tiyaungui ñuca canda rimanagama. Herodesca caima mascac shamungaraun cai huahuata huanchisha nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chasna angel rimacpi Jose chi tutallata jatarisha paihua huarmita chi huahuatas apasha Egipto llactama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chibi mandac Herodes huañuna urascama causanaura. Chasna causaupi Dios rimashcata pasachic runa cuintashcaga pactarira: Egiptomandami ñuca churita cayarani nishca. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chi yachaccuna Jerusalenma mana bulltiamunaupi Herodes ashcata piñarira, ñucata umahuanaushca nisha. Chi yachac runaguna cuintashcata yuyarisha, chi huahua ima tupu jatun acta yachasha, tucui huahuagunata huanchingahua nisha cachara, Belen llactai tiyaccunata, chimanda mayan llactagunaibihuas. Tucui cari huahuagunata ishcai (2) huatayugmanda pishigunata tucuitami huanchigrichi nisha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chasnami Dios rimashcata pasachic runa Jeremias quillcashcaga pactarira pai rimashcashina casna: ");
INSERT INTO qvzNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá nishca llactaibi sinzhita caparishca uyarira, ashca turmintarishcamanda huacashca uyarishcami. Raquel paihua churigunamanda huacashca. Paiguna ña huañushcata yachasha, ama huacaichu nicpihuas mana uyanata munara. Chasnami ñaupa quillcashca. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mandac amu Herodes huañushcahuasha Jose Egipto llactai aushcai paihua muscuibi Diospa angel ricurimusha rimara, ");
INSERT INTO qvzNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Jatari, huahuata huanchishun niccuna ña huañushcaunami. Cunanga huahuata camba huarmindi pushasha israel llactamallata bulltiai nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chita uyasha Jose jatarisha huahuata pai huarmindi pushasha israel llactama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Randi Judea provinciaibi Herodespa churi Arquelao nishca paihua yaya randimanda mandac tucushca, chita Jose uyasha Judea provinciama rinata manzhara. Chiraicumanda Dios paita muscuibi rimashca acpi Galilea provinciama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chima risha Nazaret nishca llactama rira chibi causangahua. Chasnami Dios rimashcata pasachic runaguna rimashcaga pactarirami casna nisha: Paita Nazaretmanda runa man nisha rimashca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Shuc punzha Judea partima chaquishca pambai, Bautisac Juan shamusha camachiura casna nisha, Diosma bulltiangahuaca juchata saquisha ali rashcagunata rasha ricuchichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Diospa ali mandanaga ña pactamuunmi. Pai canguna juchagunata anchuchingahuaca canguna juchagunata rashcamanda llaquirisha saquichi, chihuasha bautisarichi, nisha camachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dios rimashcata ñaupa pasachic Isaiasca casnami Juanmanda nira: Chaquishca pambaibi shuc runa casna caparisha camachin: Dios cachashca quishpichic runaraicu shuc cusca ñambita rashcacuinta canguna causaita alichirichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanga chibi causausha chilicshina ricuriccunata micuc ara, sacha mishquitas upic ara. Camello nishca aicha huillmamanda rashca llachapata churaric ara, huagra carahuan anacuc ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pai chasna camachiushcai Jerusalen llactamanda, tucui Judea provinciamandas, chasnallata Jordan yacupatamandahuas ashca runa paihuagma shamunaura pai camachishcata uyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Uyasha paiguna jucha rashcagunata saquinimi nisha rimanaupi Jordan yacuibi Juan paigunata bautisara. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Chasnallata ashca fariseo muntunguna saduceo muntungunandi paihuagma bautisaringahua shamunaura, randi paigunata ricusha nira, Canguna palucuinta mana alita rac mirai partimanda anguichi. Pita cangunata rimaraya Dios taripasha libachinamanda quishpingahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cunanga juchata saquisha alita rashami causana anguichi canguna causai sirtu cambiarisha Diosma shamushcata ricuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama rimaringuichichu Abrahan ñucanchi apayaya ashcamandami quishpishca anchi nisha, chasna shungüibi yuyarishaga pandaunguichimi. Cangunata nini, Dios munashaga cai rumigunamandas Abrahanmanda miraigunata ranata ushanmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dios taripanaga shuc ruyata cuchuna hachacuinta cunan pactamushcami. Maican ruya mana ali muyuta aparicpi cuchushcahuasha ninaibi shitaitucun. Cangunaga mana alita rasha causashcamanda chi mana ali aparic ruyacuinta manguichi. Chimandami taripashca tucunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ñáucaga cangunata yacullahuan bautisauni maican canguna juchagunata rashcamanda llaquirisha saquisha niccunata. Randi ñucamandahuasha shamuc runaga Diospa Samaihuan ninahuanbas bautisanga. Paiga ñucamanda mas yali ushaiyuc man. Ñáuca paihua partita raulla mani, paihua zapatostas mana apanallahuas balicchani. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Shuc runa muyugunata pallasha caspihuan huactan muyu carata ishcurichun nisha, muyu carata jichungahua, tucui ali muyugunalla saquirichun nisha. Chi ali muyugunata paihua huasi ucuma huacaichin, chi jichushca caragunata ninai rupachin. Dios cachangaraushca ñucamandahuasha shamucca chicuinta rasha Diospacpi alita rac runagunata paihua huasima apangami, chi mana alita rac runagunata huiñaigama ninaibi rupachinga. Chasna nisha Bautisac Juan paigunata yachachishca. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Shuc punzha Jesus Galileamanda Jordan yacuma Juanbagma shamura bautisaringahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Astahuanbas Juan paita bautisanata mana munarachu. Canmi ñucata bautisana angui nira, imangahuata bautisahuai nihuangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mana munacpi Jesus nira, Ñáuca rimashcata railla, ñucanchi Dios munashcata pactachina manchi. Chita uyasha Jesusta bautisara Juan. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yacumanda pai llucshiushcai jahuapacha pascarira, chimanda Diospa Samai shuc palomacuinta uraicumucta ricura Jesuspa jahuaibi shayarisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chihuashalla shuc rimashca jahuapachamanda uyarira casna nisha, Caimi ñuca llaquishca churi, can quishpichic tucuchun nisha ñuca canda cushihuan japirani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesus bautisarishcahuasha Diospa Samaiga chaquishca partima paita apara supai paita camachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chuscu chunga (40) tuta punzhandi sasisha mana imatas micusha Jesus raicaihuan aura. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chasna aushcai supai pai juchata rachun nisha camangahua shamura, Can Diospa churi ashaga cai rumigunata panda rai nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Randi Jesus paita cutipara, Diospa shimi casnami nin: Runa mana micunahuanllachu causan, astahuanbas Yaya Dios tucui rimashcata uyashami causana man nin. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chasna rimacpi supai Jesusta Jerusalen llactama apasha Diosta alabana huasi jahuaibi shayachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chihuasha nira, Diospa shimibiga casna nisha quillcashcami tiyan: Diosca paihua angelgunata cachangami canda cuirangahua nisha. Paiguna maquihuan japisha canda marcanaunga can ima rumigunaibis tacarichun nisha nin. Chasna acpi can Diospa churi ashaga caimanda saltai nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chasna nicpi Jesus randi nira, Diospa shimi chasnallata nin: Canda mandac Diosta ama can munashcata mandasha camanguichu ninmi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Cutillata supai shuc jahua urcuma Jesusta apara. Chibi apasha ricuchira tucui cai pachai tiyac llactagunatas, chibi tiyac gustugunatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ricuchishcahuasha supai nira, Cai tucuita cushcanguimi can ñucahuacpi cungurisha alabahuacpiga. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chasna rimacpi Jesus paita cutipara, Ñáucamanda anchurisha ri supai. Diospa shimibi quillcashca ninmi: Canda mandac Diosta alabana angui, paillata cadsusha causana mangui, casnami Diospa shimiga nin nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chita uyasha supai Jesusta saquisha rira. Chihuashalla Diospa angelguna shamusha Jesusta caranaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Shuc punzha mandac Herodes bautisac Juanda carcelbi tapara. Jesus chita uyasha Judea provinciamanda llucshisha Galilea provinciama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret llactamanda llucshisha Capernaun nishca llactama rira chibi angahua. Capernaun llactaga jatun cucha pataibi tiyara, Zabulón Neptalí nishca provinciagunaibi. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chasna racpi Dios rimashcata pasachic ñaupa causauc Isaias nishca runa rimashcacuinta tucura casna nisha: ");
INSERT INTO qvzNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulónmanda Neptalímandas miraiguna, canguna allpaga Jordan yacuta chimbasha Galilea cucha mayanbi, lamarma rina ñambibi aun. Chi allpaiga mana-israelguna causanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chiguna Diosta mana ricsic asha ansaibicuinta causanaun. Randi pai quishpichic acta uyasha shuc bila punzhayachishcatacuinta ricunaunga. Juchaibi purishcamanda huañunata manzhaccuna shuc punzhayachicshina ali causaita cuc quishpichic shamungami, nishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chi urasmanda Jesus camachingahua callarira casna nisha, Diospa ali mandanaga ña pactarimunmi paihua runagunata japingarausha. Chasna acpi canguna causaita cambiarichi, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Shuc punzha Jesus Galilea cucha patata puriushcai tupara ishcai (2) huauquipurata. Shuca Pedro nishca Simon ara, shuca Andres ara, ishcandimi yacu aichata japiccuna anaura. Jesus pasaushcaibi paiguna licasha shayaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chi runagunata ricusha Jesus rimara, Ñáucata catihuaichi. Canguna imasna yacu aichata japishcanguichi chicuintallata cunanmanda ñaupagma runagunata japicshina tucunguichi ñucamanda yachachisha. Chasna cangunata rashami. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jesus chasna rimashca ratullai paiguna licagunata saquisha paihuan rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chinicshinai mas ishcai runagunata tupara, paigunas huauquipurami anaura Zebedeoba churiguna, shuca Santiago, shuca Juan ara. Paihua yayahuan canuaibi licagunata alichiunaura. Paigunatas Jesus nira, Ñáucata catihuaichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chi ratullai paiguna yayata canuatas saquisha Jesusta catisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus Galilea llactagunaibi puriusha israelguna tandarina huasigunai yaicusha yachachira Diospa ali mandanamanda cuintasha, paimi quishpichinata munan nisha rimasha ali shimita yachachira. Chasnallata caran tunu ungushcagunata tucuita alichira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tucui Siria nishca partigunaibi Jesusmanda rimashcata uyarira. Chasna acpi caran tunu ungushca runagunatas, sinzhi nanaihuan turmintarisha causaccunatahuas apamunaura pai janbichun nisha. Chasnallata supai yaicushca runagunatas, ataquiyuc tucusha causaccunatahuas, suchu runagunatas paihuagma apamunaura. Chi tucui chasna ungushcagunataga alichira. ");
INSERT INTO qvzNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ashca runagunami paita catinaura Galilea provinciamanda, Decapolis nishca llactagunamandas, Jerusalenmandas, Judea provinciamandas, Jordan yacu chimbamanda accunahuas paita catinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus ashca runaguna paita catiucta risha shuc urcuma pundayasha tiyaricpi pai yachachishcaguna caillayanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ñáa caillayanaupi paigunata yachachingahua callarira casna nisha: ");
INSERT INTO qvzNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Diospacta rangahua pugri mani nisha yuyariccunaga cushi runa anguichi, Diospa ali mandanaga cangunahuac ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jucha rashcagunata yuyarisha llaquiriccunaga cushi runa anguichi, Yaya Dios cangunata cushiyachingaraushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mansu shunguyuccunaga cushi runa anguichi, Yaya Dios pai rimashcashina cungaraushca mushuc allpata cangunama cui tucungaraushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Raicachishcashina upinayachishcashina Yaya Diospa munashcata pactachinata yapa munaccunaga cushi runa anguichi, pai munashcata rangahua pai cangunata yanapangaraushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Shuc runata yuyarisha yanapaccunaga cushi runa anguichi, Yaya Dios cangunatas chasnallata yuyarisha yanapangaraushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Canguna shungu ucui ima jiridsa yuyaitas mana chariccunaga cushi runa anguichi, Yaya Diosta canguna ricungaraushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Piñac runagunata alichiccunaga cushi runa anguichi, cangunata Yaya Dios ñuca huahuaguna manguichi nisha rimai tucungaraushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dios munashcashina causaushcamanda turmintachinaucpihuas cushi runa anguichi, Yaya Diospa ali mandanaga cangunahuac ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Chasnallata ñucamanda cangunata caminaupis, turmintachinaupis, ima mana alitas cangunamanda llullasha rimanaupihuas cushi runa anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ñáaupa uras Dios rimashcata pasachic runagunatahuas chasnallatami turmintachinaura. Cangunatas chasnallata raitucushahuas cushiyaichi. Chasna nisha Jesus paigunata yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesus shucta mas yachachira: Cai pachaibiga cachicuinta manguichi. Cachi huaglirisha chamuc tucushaga mana cutihuas ali tucunata ushanzhu. Chasna mana balicpi ñambibi jichuitucungami runaguna jaitasha puringahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Cai munduibiga punzhacuinta manguichi. Shuc urcu jahuaibi auc llacta mana pacarinata ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bilata mana japichinchichu manga ucuibi churangahua, randi jahuaibi churanchi tucui huasibi tiyaucunata ricuchichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chi bilacuinta cangunahuas runagunahuacpi canguna ali rashcagunata ricuchinguichi. Chasna rasha causaupimi shuccuna ricusha canguna jahuapachaibi tiyac Yayata balichinaungami, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Chasnallata Jesus nira, Ñáuca mana shamuranichu Moises mandashcagunata, ni Dios rimashcata pasachic runaguna quillcashcatahuas anchuchingahuaca. Astahuanbas cai quillcashcagunata cangunama pasacta intindichingahuami shamurani. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sirtutami cangunata nini, Diospa shimibi tucui quillcashcaga ña huin pactaringami, mana shuc shimillahuas ni shuc quillcashcahuallas jichuringachu. Jahuapacha cai pachahuas tucurinagama pai nishca shimiga illacta pactaringami. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chasna acpi maican runahuas Diospa shimibi shuc pactachibaclla mandashcahuatas mana pactachicpiga, chasnallata shuccunatas ama pactachichu nisha yachachicpiga Diospa ali mandanai mas pishi balichishca tucunga. Randi maican runahuas chigunata pactachicpi, chasnallata shuccunata pactachinata yachachicpiga, Diospa ali mandanaibi ashcata balichishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cangunata nini, chi Diospa shimita yachachic runagunamanda, fariseo runagunamandahuas canguna Dios munashcacuintata mana mas rashaga paihua ali mandanama mana yaicunguichichu, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesus yachachisha catiun, Canguna yachanguichi ñaupa uras casnami rimac anaura: Ama huanchinguichu, huanchic runaga taripaitucungami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Randi ñuca cangunata nini, pihuas paihua huauquita piñaushaga taripaitucungami. Maicanbas paihua huauquita piñasha mudu yuyai illac mangui nisha camicpi tucui taripaccuna paita taripanaunga. Maicanbas yapa jiridsa mangui nicca ucupacha ninama rinata manzhaibaclla tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Diospa huasibi can paima cumbiranata cungaraushcai can shuc runahuan mana alita rashcata yuyarisha, can cumbiranata chillai saquisha perdunahuai nisha tapugringui. Chihuasha can Diosma cungaraushcata cungailla cunata ushangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Jesus chasnallata nira, Shuc runa canda piñasha caudsayachisha shuc mandac amuma apaupi uctalla paihuan alichingui chara chi amuhuagma mana pactagllaita. Chita mana alichicpiga amu canda taripasha sundaluguna maquima saquinga, sundalugunaga carcelbi canda tapanaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sirtu chimanda mana llucshinata ushanguichu can camba dihuita illacta paganagama, nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesus mas yachachisha catira, Ñáaupaga rimac anaura ama ashiyanguichu nisha. Chitaga alita yachanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Randi ñuca cangunata nini, maicanbas shuc huarmita mana ali yuyaihuan ricusha camba shungüibi chi huarmihuan ña ashiyashcanguimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chiraicumanda camba ñahui canda juchata rachicpi chita surcusha jichungui. Camba intiru aicha ucupachama rina randimanda shuc partilla jichuricpi mas ali anma. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Camba maqui canda juchata rachicpi pitisha jichungui. Camba intiru aicha ucupachama rinarandimanda shuc partilla aichalla jichuricpi mas ali anma, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesus chasnallata nira, Ñáaupaga rimac anaura shuc runa paihua huarmita jichunata munashaga jichunacuna quillcata cushaga jichunalla man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Randi ñuca cangunata nini, maicanbas paihua huarmi mana ashiyagllaita yangamanda jichushaga, pai ashiyachun nisha saquin. Chasna rac runaga juchatami ran. Chasnallata jichushca huarmita japic runaga juchatami ran, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Chasnallata canguna callari apayayagunama rimashcata uyashcanguichi casna nisha: maicanbas Diospa shutita japisha pactachishami nic runaga pactachina manguichi nishca. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Randi ñucaga cangunata nini, ama ima uraspas yanga rimanguichichu jahuapachata cai pachatas nisha. Jahuapachaga Dios tiyarina man, cai pachaga pai jaitarisha tiyana man. Chasnallata Jerusalen llactahua shutitas ama japinguichichu, chiga jatun amuhua llacta man. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chasnallata ñuca mana sirtu rimacpi ñuca accha cambiarichun nisha ama rimanguichu. Camba acchata yanayachinata, chasallata ruyagyachinatas mana ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Canguna indá nisha rimaushaga indá nina manguichi, mana nisha rimaushaga mana nina manguichi. Canguna yapachisha rimaupiga supaimi rimachin nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesus shucta mas yachachira casna nisha, Cai ñaupa quillcashcata yachanguichimi, maicanbas camba ñahuita tugyachicpiga, cambas randi paihua ñahuita tugyachingui nishca. Chasnallata maicanbas camba quiruta paquicpiga, cambas randi paihua quiruta paquingui, nisha quillcashca tiyan. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ñáuca randi cangunata nini, mana ali runata ama jarcaichichu. Pai camba ñahuita sagmacpi ama paitas sagmanguichu astahuanbas shuc parti ñahui randi ricuchingui. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Canda caudsayachic runa amuhuagma apasha camba camidsata quichucpi camba capatahuas cungui. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Maicanbas canda chigamalla caita aparisha ri nisha mandacpi, chimandas mas carutas aparisha yanapangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maicanbas canda imatahuas tapucpi paima cunguilla, mañachihuai nisha rimacpihuas ama mitsasha mañachinguilla. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Chasnallata ñaupa rimashcata uyashcanguichi casna nisha, camba amigogunallata llaquina mangui, canda piñaccunataga piñana mangui nisha rimashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ñáuca randi cangunata nini, cangunata piñaccunatas llaquina manguichi, cangunata turmintachic runagunamandas Diosta mañaichi paigunata alita rachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chasna canguna rashaga jahuapachaibi auc Yayahua huahuaguna manguichi. Paiga ali runagunatas, mana ali runagunatas indita ricuchin chasnallata tamiatas cachan. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cangunata llaquiccunallata llaquisha causaupiga Yaya Dios cangunata mana imatas cungachu. Chi romano gubirnuraicu cullquita tandachic runagunahuas chasnallata paigunapuralla llaquinacusha causanaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Canguna aillugunallahuan saludanacushaga mana chicandachu ranguichi. Diosta mana quiric runagunahuas paigunapuralla saludanacunaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Canguna jahuapachaibi auc Yaya yapa ali ashcashina cangunahuas yapa ali aichi, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesus mas yachachira casna nisha, Dios mandashcata ama ranguichichu runaguna ricuhuanauchun nishalla. Chasna racpiga canguna jahuapachaibi auc Yaya cangunata mana imatas cuitucunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Can shuc runata yanapasha imatas cushaga ama alabarisha rimanguichichu ñuca rashcata ricuichi nisha. Chasna raucunaga mana shungumanda yuyarishachu ranaun. Paiguna israel tandarina huasigunaibi ñambigunaibihuas runaguna ali runa man nisha rimahuanauchun nishallami chasna ranaun. Sirtutami cangunata nini, maicanguna chasna rashaga cai pachallai alabashca tucunaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Canguna randi imatahuas shucta yanapasha cuushaga ama pihuas canguna rashcata yachanauchun nisha yuyarichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Canguna ali rashcaguna ama uyarinauchun. Chasna racpi canguna tucui rashcata ricuc Yayaga cangunata premiotashina alita cungami, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Diosta mañanamanda Jesus yachachira casna nisha, Canguna Yaya Diosta cuintana uras chi yanga llullasha raccunashina ama raichichu. Paiguna tucuiguna ñaupacpi, israel tandarina huasigunais ñambigunaibihuas shayarisha Diosta rimanaun runaguna ricuhuanauchun nishalla. Sirtutami cangunata nini, paiguna chasna rasha premiota japishcashina cai pachai alabashca tucunaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Canguna randi Dioshuan cuintasha nisha canguna huasi ucuma yaicusha punguta tapasha runagunas illashcai Yaya Dioshuan sapalla cuintasha mañanguichi. Chasna rasha cangunahua tucuita ricuc Yaya Dios pagllai premiota cushcashina cangunata balichingami tucui runaguna ricuushcai. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Canguna Dioshuan cuintausha ama chillatata cuti, cuti yangalla rimanguichichu Diosta mana quiric runagunacuinta. Paiguna ashcata rimasha mañacpi Dios cuhuangami nisha yuyarinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ama paigunashina ranguichichu. Dios cangunaraicu pishishcata ña yachanmi canguna chara mana tapugllaita. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","13","Astahuanbas canguna Yaya Dioshuan cuintausha casna yuyarina manguichi: Ñáucanchi jahuapachaibi tiyac Yaya, camba shuti balichishca achun. Camba ali mandanaga tucuibi mirarishca tucuchun. Jahuapachaibi can munashcata rashcacuinta cai pachaibihuas chasnallata rashca achun. Cunan punzha ñucanchi minishtishca micunataga cuhuai. Ñáucanchita mana alita raccunata perdunashcacuinta ñucanchitas mana alita rashcagunatas perdunai. Supai ñucanchita pandachisha nisha camacpi cuirahuai ñucanchi canda ama saquingahua. Huiñaigama canmi tucuigunata mandac angui, canmi ushaita charic angui, yapa sumac angui. Chasna achun. Casna nisha Yaya Dioshuan cuintana manguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Shuccuna mana alita cangunata rashcata canguna perdunacpiga jahuapachaibi tiyac Yayahuas cangunata perdunangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Randi canguna chigunata mana perdunacpiga canguna Yaya mana perdunangachu canguna juchagunata, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesus shucta mas yachachira casna nisha, Cangunaga sasiusha ama chi yanga llullasha raccunacuinta raichichu. Maican runaguna sasishcai llaquirishcashina ricurisha purinaun, runaguna paiguna sasiushcata ricuhuanauchun nishalla. Sirtutami cangunata rimani paiguna cai pachallaimi balichishca tucungauna shuc premiota japishcashina. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Canguna sasiushcata shuccuna ama yachanauchun nisha. Sasishcai canguna ñahuita sumac maillarina manguichi, ali asnac asaitihuan canguna acchata sumac armanguichi. Chasna racpi cangunahua mana pagllai ricuric Yaya Dioslla yachangami, pai tucuita ricuc asha cangunata tucuiguna ricushcai balichinga, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Cai pachaibi ama ashcata charinguichichu. Caibi charishcagunata ucucha micucpi tucuringaunami, chasnallata ismusha tucurinaungami. Chasnallata shuhuaitucunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas ali anga jahuapachai charic tucungahua, ali rashcagunamanda. Chibi ucucha mana micungachu, mana imas huaglingachu, mana shuhuaitucungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maibis canguna huacaichisha charishcagunata chibimi yapa yuyaringuichi, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesus chicuintallata yachachira, Camba ñahuiga intiru aichaibi bilacuinta man. Can bilahuan purishcacuinta ali yuyaihuan causashaga punzhashina alita causanguimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Randi can mana ali yuyaihuan causashaga camba causai ansa tutacuinta manga. Cunan camba yuyai punzhacuinta man. Camba yuyai bila illac tutacuinta ansayacpiga astahuanmi mas ansa tucunga, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mas chimanda Jesus yachachira casna nisha, Pihuas ishcai (2) amuta charinata mana ushanzhu. Ishcaita uyasha nishaga shucta llaquingami, shuctaga mana llaquinga, shuc amullata uyashami chi shuctaga mana uyanga. Chicuintallata cangunahuas cullquita llaquishaga Yaya Diostaga llaquinata mana ushanguichichu, nisha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Chimanda cangunata nini, ama nusparinguichichu imatata micushun, imatata churarishun nisha. Canguna causaiga micunamandas mas yali balin canguna aichaga churarinamandahuas yalita balin. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pishcugunamanda yuyarichi. Paiguna mana tarpunaunzhu, mana pallanaunzhu, mana shuc huasibi huacaichinaunzhu. Randi jahuapachaibi tiyac Yayami paigunataga caran. Cangunaga pishcugunamandas mas yali balic manguichi, chasna acpi Yaya Dios cangunata yapa alita cuirangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Maicanbas imata rashahuas paiguna causaita mana mas suniyachinata ushangaunachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Imangahuata canguna churarinamandalla yuyarisha causanguichi. Sacha sisagunata yuyarichi, paiguna mana tarabasha chasnallata mana ahuashahuas gustuta huiñanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sirtutami cangunata nini, Israel jatun amu Salomonga tucui tunu churarinagunata charishahuas mana cai gustu ricuric sisagunacuinta churaricchara. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yaya Diosca yanga quihuatahuas gustuta huiñachisha sisachin. Chasna gustu agllaita cayandiga runa pitisha ninaibi rupachinaunmi. Chi quihuamandas mas yali alitami Yaya Diosca cangunama churarinata cunga. Chita yachashallata imangahuata mana tucui shunguhuan quiringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chasna acpi ama nusparichichu imatata micushun, imatata upishun, imatata churarishun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cangunahua jahuapachaibi tiyac Yaya Diosca chi tucui canguna minishtiushcata yachanmi. Chi Diosta mana quiriccunaga chigunamandalla yuyarisha causanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Canguna randiga Diospa ali mandanata pai munashcatas mascasha causaichi. Chasna racpi canguna minishtiushcata cuitucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Caya punzhaga imasashi tucusha nishaga ama nusparinguichichu. Caran punzhami llaquigunaga tiyan, cayaga imata tucusha caicuintagunahuanga nisha ama yuyaringuichichu, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesus chasnallata nira, Shuccunata ama mana alita rimasha culpanguichichu Dios cangunata randi mana culpaitucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Canguna shuccunata culpashcacuintallata Diosca cangunatas culpangami. Shuccunata imatas can racpihuas Yaya Dios chasnallatata candas raitucunguimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chasna acpi imangahuata can mana alita rashallata camba huauquita culpangui. Camba quiquin ñahui ucuibi jatun caspishina acta mana anchuchirishallata imangahuata camba huauquihua ñahui ucuibi ichilla basurashina autaga ricungui. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Shuc jatun caspita camba ñahui ucui chariushallata, imangahuata camba huauquita ningui, huauqui ricui, ñapa chapai camba ñahuibi auc basurata ñuca surcunata munani nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Alita rauc runacuinta umasha puric anguichi. Ñáaupata camba ñahuibi auc caspita surcuringui, chihuasha alita ricunata ushangui camba huauquihua ñahuibi auc basurata surcungahua, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yaya Dios yapa ali yachachishcagunata allcushina piñarisiquigunamaga ama rimaichichu, nira. Chi runagunaga piñashami cangunata piti, piti rashcacuinta llaquichitucunguichima. Diosta piñac runagunama pai yapa ali yachachishcagunata ama camachichichu, perla nishca balic rumita cuchima shitacpi aitashcashina ama tucuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Chasnallata mas nira, Canguna Yaya Diosta tapucpi pai cungami, mascasha pai cungaraushcata tupanguichimi, huasi pungüi caparicpi cangunata yaicuchitucunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tucui tapuc runa cuitucungami, mascac runa tupangami, huasi pungüi caparic runa yaicuchitucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Maicanda rumita cunguichima canguna churi panda cuhuai nisha tapucpi. Mana pihuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yacu aichata cuhuai nisha tapucpi palutachu cunguichima. Mana. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Canguna juchayuc ashahuas canguna huahuagunama aligunata cunguichi. Chasna acpi manachu canguna jahuapachaibi tiyac Yayaga paita tapuc runagunama aligunata cunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Shuccuna cangunata alita ranauchun canguna nisha munashaga cangunami pundaga paigunata alita rana anguichi. Chitaga Moises mandasha saquira, chasnallata Dios rimashcata pasachic runagunahuas rimashcauna. Chasna nisha cuintac ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ichilla punguta yaicuichi. Jatun punguta yaicushaga chasnallata jatun ñambita rishaga ucupachamami ringuichi. Chita pasanalla ashcamanda chibi ashca runagunami purinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Randi jahuapacha causanama ringahuaca punguhuas ñambihuas ichilla man. Chitaga ashilla runagunami rinaun, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesus shucta mas yachachira, Umasha Yaya Diospa shimita rimanchi nic runagunata ama uyanguichichu. Paigunaga quiric acshina ashallata shungüibiga huaglichinallata yuyarinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Paiguna rashcata ricushami imasna actaga yachanguichi. Casha ruyamanda uhuillasta mana pallanchichu, chasnallata dundu ruyamanda japiyucta mana pallanchichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chasnallata ali ruyaguna ali muyuta aparinaun, mana ali ruyaguna mana ali muyuta aparinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ali ruyaga mana ali muyugunataga mana aparinata ushanzhu, chasnallata mana ali ruyaga ali muyugunataga mana aparinata ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mana ali muyugunata aparic ruyata cuchusha rupachinaunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chicuinta chi camachic runaguna rashcagunata ricusha paiguna imasna acta yachanguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesus mas nira, Mana tucuiguna ñucata señor, señor niccuna Diospa ali mandanama yaicunaungachu, jahuapachai auc ñuca Yaya munashcata pactachic runallami paihua ali mandanama yaicunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chi punzhaibi ashca runaguna ñucata rimahuangaunami casna nisha: manachu cambagmanda yachachiranchi señor, camba shutihuan supaigunatas anchuchiranchi, pihuas mana raushcagunatas camba shutihuan ashcata raranchi señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chasna ninaupi ñuca paigunata rimashami, mana ima uraspas cangunata ricsiranichu. Canguna mana alita rasha causaccunaga cunanga ñucamanda anchurichi, chasnami rimangarauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ñáuca cunan yachachishcagunata uyasha pactachiuc runaga yuyaiyuc runa man. Paiga paihua huasita sinzhi allpaibi shayachic runacuintami an. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chihuashaga ashcata tamiara, yacuhuas jundara, sinzhita huairara, huasitas cuyuchira. Chasna tucucpihuas chi huasi mana urmarachu sinzhi allpaibi shayachishca asha. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Astahuanbas ñuca yachachishcagunata uyashallata mana pactachic runaga yuyai illaccuinta runa man. Chiga pulayaibi huasita shayachic runacuinta an. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ñáa paihuagmas tamias shamura, yacuhuas jundara, sinzhi huairas shamusha paihua huasita cuyuchisha urmachira, mana sinzhi allpaibi shayachishcamanda. Chasna acpi chi huasiga chingarishca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus chasna cuintashcahuasha tucui runaguna pai chasna yachachishcata uyasha manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesusca mana chi Moises mandashcata yachachic runagunashinami yachachiurachu, astahuanbas pai ashca ushaita charishami ali yuyaihuanmi yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus urcumanda uraicusha riushcaibi ashca runaguna paita apanacusha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pai chasna riushcai shuc lepra nishca sinzhi carachayuc runahuas shamusha Jesuspa ñaupacpi cungurisha, Señor nira, can munashaga ñuca ungüita janbinata ushahuanguimachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chasna rugacpi Jesus paihua maquihuan chi runata llangasha nira, Munani, cunanga ali tucunguimi. Chi ratullai chi carachayuc runaga janbishca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chihuasha Jesus paita nira, Uyai, ama pitas rimanguichu, can amulla charingui. Astahuanbas israel pagrihuagma risha camba aichata ricuchigri. Chasnallata tucui runaguna chita yachanauchun nishaga huañuc Moises mandashcatacuinta rasha pagrima cugringui camba aicha janbirishcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus Capernaun nishca llacta ucuma yaicushcai shuc romano sundalugunata mandac runa shamusha Jesusta rugara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Señor ñucata cuirac runa sinzhi nanaihuanmi suchu tucusha ñuca huasibi siriun. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chasna pai rugacpi uyasha Jesus nira, Ñáuca paita janbic shamusha. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Sundalugunata mandacca chita uyasha pai nira, Ñáuca mana-israel runa asha mana balicchani can ñuca huasibi yaicungahua señor. Ñáucaga mandac runa mani, chasnallata ñuca randi shuccunatas mandac ani. Shucta ri nicpiga pai rinmi, shucta shamui nicpiga pai shamunmi, ñucata cuirac runata caita rai nicpiga pai ranmi. Cunan can rimashcallahuanmi ñucata cuirac runa aliyangami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chita uyasha Jesus cushihuan paita catic runagunata nira, Sirtupacha cangunata nini, cunangama tucui israel llactaibihuas cai runashina quiricta mana tupashcanichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chasnallata nini ashca runagunami tucui llactagunamanda shamusha israel callari apayayagunahuan Abrahan, Isaac, Jacobohuan Diospa ali mandanaibi mesai pariulla micungahua shamungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Astahuanbas Diospa ali mandanaibi yaicuna ac runagunarandiga canzhama shitashca tucunaunga ansa ucuibi. Chibiga huacangaunami chasnallata quirutas canirisha ashcata turmintaringaunami, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chihuasha Jesus chi sundalugunata mandacta casna nira, Camba huasillatama bulltiai, can quirishcacuinta tucuchun nini. Chasna nicpi chi ratullai chi ungushca runa ali tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chihuasha Jesus Pedrohua huasima rira. Chibi Pedrohuac huarmi mama ungushca siriura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus paihua maquihuan llangacpi chi huarmi ña janbirira. Chasna janbirisha jatarisha paigunata upichingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chi chishi, israel samana punzha indi ña yaicushcaibi, ashca supai yaicushca runagunata apamunaura Jesuspagma. Paiga shuc shimillahuanmi chi supaigunataga llucshichira, chi tucui ungushca runagunatas janbirami. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chasnami tucura Isaias nishca Dios rimashcata pasachic runa ñaupa uras rimashca shimi pactaringahua, casna nisha: Paiga ñucanchi ungüigunata nanaigunatas janbira. Pai chasna rimasha saquishca shimigunami cunanga Jesus janbiupi pactariun. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus, ashca runaguna paita liyú muyurishcata ricusha, Jacuichi chimba partima nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ñáa ringaraushcai shuc Diospa shimita yachachic runa shamusha Jesusta nira, Maita can riupihuas ñuca canda catisha rinata munani señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus randi paita rimara, Tucui aicha puñuna juctuta charinaunmi, pishcugunahuas huasita charinaunmi, randi ñucaga Runa Tucuc ashallata quiquin puñuna huasitaga mana charinichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Shuc runa Jesusta catic paita tapura, Pundaga lugarta cuhuai ñuca yaya huañushcata pambagringahua señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chasna nicpi Jesus paita nira, Chi huañushcashina ñucata mana quiric runagunaga paigunapura huañushcagunata yuyarisha pambanauchun. Ñáucata canga catihuailla. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chihuasha Jesus canuaibi yaicura pai japishca runagunandi. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chi uraspi paiguna chi cuchata riushcaibi sinzhi huaira shamura, yacu ulas jatarira, barcota ñalla tigrachiura. Chasna cuyuriugllaita Jesus chi canua ucuibi puñuura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pai japishca runagunaga manzharisha paita nicchachisha caparinaura, Señor tigraunchimi, ñucanchita quishpichi nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus niccharisha tapura, Imangahuata manzharinguichi, ashillata quiric manguichi nira. Chihuasha pai jatarisha yacutas huairatas shinzhita rimacpi tucui manzhanayacta auc huaira saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chita ricuc runaguna manzharisha ninaura, Manapacha, ima tunu runatanya paiga. Yacuhuas huairahuas pai mandacpiga uyanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chimbashcahuasha Jesus Gadara nishca partibi pactanaura. Chibi pactashcai ishcai (2) runaguna urcu partibi auc pantionmanda llucshisha Jesuspagma shamunaura. Chi runagunata ashca supai yaicushcamanda anaura, nuspa asha piña. Chiraicumi chi partita auc ñambita mana pihuas puric anaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Paiguna Jesusta ricusha casna caparinaura, Imangahuata ñucanchihuagma shamungui Diospa Churi ashaga. Taripana uras chara mana pactamugllaita ñucanchita turmintachisha nishachu shamungui nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chi urasllata ashca cuchiguna chi mayanllai micuusha shayanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chasna acpi Jesusta supaiguna casna nisha ruganaura, Cai runagunamanda ñucanchita llucshichishaga lugarta ñucanchita cui chi cuchiguna ucuibi yaicungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chasna supaiguna rugacpi Jesus alimi, yaicuichilla nira. Chasna Jesus nicpi tucui chi ashca supaiguna runagunamanda llucshisha cuchigunaibi yaicunaura. Yaicucpimi cuchiguna huaicuma callpashami tsan urcumanda yacui urmasha yacuta chucasha huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chita ricusha cuchita cuiraccunaga manzharisha callpasha rinaura. Chiguna llactama pactasha tucuita cuintanaura, cuchiguna chucashcamanda, supaiyuc runagunatas alichishcamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chita uyashami llactaibi auc runaguna Jesus aushcama shamunaura. Chibi pactasha Jesusta ruganaura, Ucta ñucanchi llactamanda llucshisha ri nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Paiguna chasna rimacpi Jesus cuti canuai yaicusha, cuchata chimbasha paihua quiquin llactamallata rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pai pactasha aushcai shuc suchu mana puric runata paihua baitaibi churasha Jesuspagma apanaura paimi alichinata ushan nisha. Chi quirishcata ricusha Jesus chi suchu runata nira, Cushiyangui, can jucha rashcagunaga ña illacta anchuchishcami tucungui. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pai chasna rimacpi, maican Moises mandashcata yachachic runaguna chasna rimacta uyasha paiguna shungu ucui yuyarinaura, Paiga Dioschan chasna rimangahuaca, pai Diostami camiun casna rimaushaga. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus paiguna shungüibi yuyariushcata ña yachasha paigunata tapura, ");
INSERT INTO qvzNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Imangahuata canguna shungu ucui chasna mana alita yuyariunguichi. Maicanda mas sinzhi ranallaga anma: camba juchaguna anchuchishcami saquirin nisha rimashcachu, u jatarisha camba huasima ri nisha rimashcachu. Maicanda mas sinzhi rana tan. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Astahuanbas ñuca Runa Tucuc asha cai pachaibi juchagunata anchuchina ushaita charic actaga cangunata ricuchingarauni. Chasna nisha suchu runata nira, Jatari, can siriushca baitata apasha camba huasita ri nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chasna rimacpimi chi suchu mana puric runaga jatarisha paihua huasimallata purisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chasna tucucpi chita ricuc runagunaga manzharisha Diosta alabangahua callarinaura chasna runagunama ima ungushcatas alichingahua ushaita cushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus chimanda riusha Mateo nishca runata tupara. Chi runaga gubirnuraicu cullquita tandauc ashami paihua tarabana huasibi aura. Paita ricusha Jesus nira, Ñáuca runa tucusha ñucata catihuai. Chasna rimacpi Mateo jatarisha Jesushuan puric runa tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chihuasha shuc punzha, Mateo huasibi Jesus aushcaibi ashca gubirnuraicu cullquita tandachic runaguna, juchayuc runagunahuas shamusha Jesushuan pariu micunaura pai japishca runagunandi. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseoguna chigunata ricusha, Jesus japishca runagunata tapunaura, Imangahuata cangunata yachachic runaga mana balishishca runagunahuan micuun chi gubirnuraicu cullquita tandachic runagunahuanbas, juchayuc runagunahuanbas. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chita uyasha Jesus chi fariseogunata rimara, Mana ungushca ali runagunaga doctorta mana minishtinaunzhu, randi ungushcagunallami doctortaga minishtinaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Risha yachagrichi Diospa shimi imasna nishcatahuas casna nisha: Ñáucata alabausha huagrata huanchina randimanda canguna shuccunata yuyarisha yanapasha causaichi nishami Yaya Diosca nin. Chasna acpimi cangunata rimani, Juchata rac ani nic runagunatami japisha Diospagma apangahuaca shamurani, chi ali manchi nisha yuyariccunataga japingahua mana shamuranichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Shuc punzha Bautisac Juan japishca runaguna Jesuspagma pactasha tapunaura chasna nisha, Fariseo runagunas ñucanchihuas ashca cutin sasisha mana micusha causanchi. Imangahuata can japishca runagunaga mana sasinaunya. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chasna tapucpi Jesus paigunata nira, Shuc cadsaranama cayashca runagunaga mana sasicchanaun japina cari paigunahuan tiyaupiga. Randi shuc punzha cuntar runaguna ñucata apashcaibimi ñuca amigoguna sasinaunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yuyarichi. Mana pihuas mauca llachapataga mushuc pitihuan rimindanzhu. Chasna racpiga chi mushuc llachapa tsinunyacpi mauca llachapaga mas liquirisha ringa. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chasnallata mana pihuas llullu vinota mauca puruibi churanzhu. Chasna churacpiga chi puru tugyangami, tugyacpi vino illacta taliringami, chasnallata chi puruhuas huaglinga. Chi randimanda llullu vinota mushuc puruibi churanami an tucui ali tucuchun nisha ima huaglingahua. Chicuintallata maucacuinta causaibiga ñuca yachachishca mushuc causaitaga mana chapunachan nisha Jesus paigunata chasna cutipasha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus chasna cuintaushcai shuc israel amu shamusha Jesuspa ñaupacpi cungurisha nira, Ñáuca ushushihuami ñacahua huañun. Chasna agllaita can shamusha camba maquihuan paihua jahuaibi llangacpiga causaripangllami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chasna rimacpi Jesus jatarisha pai japishca runagunandi chi runata catisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Paiguna riushcai shuc ungushca huarmi shamura, chunga ishcai (12) huatata rahuai talirisha causac ara. Jesus churariushca llachapa pundahuallai llangashcallahuanmi aliyashami nisha paihua shungüibi yuyarira. Chasna yuyarisha Jesuspa huashamanda caillayagrisha pai churariushca llachapa pundahuai llangara. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chasna llangacpi Jesus bulltiarisha, chi huarmita ricusha nira, Ama manzhaichu, can quirishcamandami janbirishca tucushcangui. Chi ratullai chi huarmiga aliyashca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesus chi amuhua huasima pactashcai chibi ashca runaguna tandarisha huacaucunatas, tucac runagunatas ricusha paigunata nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Cai ucumanda llucshisha richi, cai huahuaga mana huañushcachu, paiga puñuunmi nira. Chita uyasha chi runagunaga huahua huañushca agllaitami chasna niun nisha paita yapa asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chi runagunata llucshichishcahuasha chi huañuc huahua siriushca cuarto ucuma yaicusha paihua maquimanda japigllai chi huahua causarisha jatarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chita yachashami tucui chi partigunaibi tiyac runagunama cuintanaura. Chasna tucushcaga tucui chi mayanbi auc llactagunaibi sáa uyarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus chimanda llucshisha riushcai ishcai (2) puyuñahuiyuc runaguna paita catingahua callarinaura. Paigunaga capariunaura can mandac rey amu Davidmanda mirai runa ashami ñucanchita yuyarisha yanapai nishami capariunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus shuc huasi ucuma yaicusha, chi puyuñahui runaguna catisha paihua mayanbi pactasha caillayanaupi tapura, Ñáuca cangunata janbinata ushaita charic acta quiringuichichu tapucpi, indá señor ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chasna indá nicpi Jesus paiguna ñahuita llangasha, Canguna quirishcacuintami tucunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pai chasna rimashcallahuan paiguna ñahui ali tucunaura. Chihuasha Jesus paigunata ashcata cunara, Uyaichi, ima pitahuas ñuca cangunata casna janbishcata rimanguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Chasna nigllaita astahuanbas paiguna rishaga, Jesus paigunata janbishcataga tucui chi partibi tiyac runagunata cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesus chimanda riushcaibi maican runaguna shuc supai yaicushca runata Jesuspagma apamunaura. Supai chi runata yaicushcamandami paiga mudu tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus chi runamanda supaita llucshichishca ratullai chi runaga alita rimangahua callarira. Chita ricuc runagunaga manzharisha ninaura, Manapacha, ñucanchi israelguna ñucanchihuacpi caicuinta rashcata mana ima uraspas ricushcanchichu ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseoguna randiga, Cai runaga supaihua ushaihuanmi supaigunata llucshichishca nishami rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus tucui llactagunai puric ara jatun llactaibis ichilla llactagunaibias. Maibi purishas israelguna tandarina huasigunai yaicusha cushi shimita yachachic ara casna nisha cangunataga Diospa ali mandanamanda cuintasha paimi quishpichinata munan nishami camachic ara. Chasnallata tucui imasna ungüigunatas nanaigunatasmi janbic ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chi ashca runagunata ricusha paigunata llaquisha yanapashcanguichimi nira. Chi runagunaga turbarishcami tiyac anaura, paigunata cuirac runa mana pihuas tiyashcamandami jichushcacuinta anaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chita ricusha Jesus paita catic runagunata nira, Chagraibi ashca pallana tarabanami tiyan chasna agllaita chita tarabac runagunaga ansahuami anaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chasna acpi cangunaga chi chagrayuc amuta tapuna manguichi mas runata cachachun chi chagrata tarabangahua. Cangunaga Diospa shimita yachachiucuna ashicuami anguichi. Chasna ashicua ashcamandami Diosta tapunami anguichi paihua shimita mas yachachic runagunata cachachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Shuc punzha Jesus paihua chunga ishcai (12) japishca runagunata cayasha supaigunata llucshichina ushaita paigunama cura. Chasnallata tucui tunu ungüitas huañuigunatas janbina ushaita cura. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chi chunga ishcai japishca runagunaga casna shutiyugmi anaura: Ñáaupapunda Pedroga paillatata Simon nishca ara. Chimandahuasha paihua huauqui Andres, chasnallata Zebedeohua churiguna Santiago, paihua huauqui Juandi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Chasnallata Felipe, Bartolome, Tomas, gubirnuraicu cullquita tandac Mateo, chimanda rin, Santiago Alfeohua churi, Tadeo, ");
INSERT INTO qvzNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Cananeo muntunmanda Simon nishca, puchucaibi Judas Iscariote nishca Jesusta randichic runa. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus chi chunga ishcai (12) anllashca runagunata cachausha casna nira, Chi mana-israel llactagunama ama ringuichichu, chasnallata Samaria nishca llactagunamas ama yaicunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Astahuanbas israel muntunga shuc ovejacuinta chingarishca aushcamami cangunaga ringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Paiguna llactama pactasha casna nisha rimanguichi, Diospa ali mandanaga ña pactamunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ungusha tiyac runagunatas janbinguichi, huañushcagunatas causachinguichi, lepra nishca sinzhi carachahuan turmintaric runagunatas janbinguichi, supai yaicushca runagunatas supaita anchuchinguichi. Casna rana ushaita yanga cangunama cushcani chiraicumi paigunatas yanga janbinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Tarabac runaga pai tarabashcamandami cuitucuna causan. Chasna acpi cangunaga cullquihuan mana apanachanguichi, chasnallata botastas, can purina baratahuas mana apanachanguichichu, camidsata apaushaga shugllatami apanguichi. Chi tarabac runacuinta yanapashcamandami canguna yanapashca runagunaga cangunata caraitucunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ñáa can nishca llactama pactashaga, shuc ali shunguyuc runatami mascana anguichi. Chi llactamanda llucshinagama chi huasillai tiyanami anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chi huasibi yaicushaga, saludanami anguichi cangunahuacpi cungailla causana tiyachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chi huasiyuc amuguna cangunata cushihuan japinaupiga canguna saludashca shimiga paigunahuan saquiringami. Astahuanbas cangunata mana cushihuan japinaupiga canguna saludashcaga cangunamallata bulltiangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Maican huasibis maican llactagunaibis cangunata mana cushihuan japinaupiga, chasnallata canguna yachachishcata mana uyanata munacpi, chi huasimanda chi llactamanda llucshisha ringuichi. Llucshiusha canguna chaquimanda chi llacta allpa pulbuta sáa pichasha ringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sirtuta cangunata nini, Chasna mana uyasha chi runagunaga Sodoma Gomorra llactagunaibi turmintarishcamandas mas yali sinzhita cashtigashca tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Uyahuaichi, pumaguna chaupi ucuibi ovejaguna aushcashina cacharishcacuintami cangunata cachauni. Chiraicumanda cangunaga shuc sabiru palucuinta sabiruhuan purinami anguichi, chasnallata huiba pishcucuintami mansu ana anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yuyarisha causaichi. Maican runagunaga pumacuintami anaun. Chigunaga cangunata culpayachisha amugunahuagma apaitucunguichimi, israelguna tandarina huasigunaibimi taripasha cangunataga libachi tucunchimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ñáucata catic runa ashcamandami jatun amugunahua ñaupacpi apaitucunguichimi. Chasna racpi paigunama mana-israel runagunahuas ñucamanda rimac tucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cangunata taripangahua apashcai ama turbaringuichichu imasnata rimangarauni nisha. Chi uraspi Dios cangunataga yuyaita cuitucunguichimi canguna imasnas rimanatas. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chi uraspi mana canguna quiquin yuyaihuanzhu rimangaraunguichi, astahuanbas canguna Diospa Samai cangunama yuyaita cushca shimitami rimanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Chasnallata paigunata mas nira, Maicangunaga paiguna quiquin huauquigunatas mandac amuma japichinaungami huanchinauchun nisha ñucata quirishcamanda chasnallata yayagunahuas paiguna quiquin churigunata. Maican churigunahuas paiguna yayagunatas piñasha mandac amu maquima cunaungami paiguna huanchinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ñáucaraicuga tucui runagunami cangunataga piñaitucunguichi. Astahuanbas maican ñucata puchucai punzhagama catic runami quishpichishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Shuc llactaibi cangunata piñasha turmintachiunaupiga shuc llactama risha miticunguichi. Sirtumi cangunataga nini, ñuca Runa Tucuc asha shamunagama cangunaga tucui israel llactagunata purisha chara mana tucuchiugllaitachu shamungarauni. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yuyarichi. Shuc yachachiushca runaga paita yachachic runamanda mana mas yalichan. Chasnallata shuc mandaushca runaga paihua amumanda mana mas yalichan. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chasna acpi maican yachachiushca runaga paita yachachic runacuinta tucushaga cushimi tucunga. Chasnallata maican mandaushca runahuas paihua amucuinta tucushaga cushimi tucunga. Huasiyuc amutaga Beelzebú Supai mangui nisha camishaga amuhua runagunatas chasnallatami caminaunga nisha yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesus yachichisha catira, Cangunata chasna turmintachinaupihuas ama manzhanguichichu chi runagunataga. Paiguna tucui rashcagunaga huasha ricuringami. Ima cunan pacalla rashcagunahuas huasha punzhami ricuringallami, chasnallata ima pacalla rimashcagunahuas shuc punzhallaitami yacharingarauni. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ñáuca tuta cangunata cuintashca acpitaga punzha pagllai cuintanami anguichi, ñuca cangunata pacalla cuintashca acpiga chasnallata pagllaibi caparinami anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cangunata huanchishun nic runagunatas mana manzhana changuichichu paiguna canguna almataga mana huanchinata ushanaunzhu. Astahuanbas manzhaichi canguna almatas aichatahuas ucupachama cachasha chingachinata ushac Yaya Diosta. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Shuc ashicua cullquihuan ishcai (2) pishcuta randichinata ushanaunzhu. Chasna asha chi pishcu mana shugllahuas huañusha urmangachu canguna jahuapachai tiyac Yaya mana munacpiga. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Paiga canguna umaibi masna accha tiyactahuas yachanmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chi pishcugunamandahuas cangunaga mas ashca balic ashami Yaya Dios alita cuirashca saquiringuichi. Chasnamandami chi runagunataga mana manzhana changuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Maicanbas runaguna ñaupacpi ñucaga Jesuspac mani nisha rimacpiga ñucahuas jahuapachai tiyac Yaya ñaupacpimi paiga ñuca runa man nisha rimashami. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Randi maicanbas runaguna ñaupacpi rimausha mana Jesuspa runa chani nisha rimacpiga ñucahuas jahuapachai tiyac Yaya ñaupacpimi chi runaga mana ñucahuacchu nisha rimashami. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Chasnallata nira, Ñáuca shamushcamanda ganas causaita charingaraunchi nisha ama yuyarichichu. Mana canguna yuyarishcacuintachu tucungaraun. Ñáuca shamushcamandami tucui runagunaga pariumanda piñanacushami causangaraunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ñáuca shamushcamandami churigunaga paiguna yayahuan piñanacunaungami, ushushigunahuas paiguna mamahuan piñanacunaungami, chasnallata cachungunahuas paiguna cari mamata piñangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Canguna quiquin aillugunahuas cangunataga piñaitucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Maicanbas paihua yayata mamatas ñucamanda mas yalita llaquishaga ñucata mana catic runachan. Chasnallata maicanbas paihua churita ushushitas ñucamanda mas yalita llaquishaga ñucata mana catic runachan. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Maicanbas ñucata catingahua paihua quiquin crusta aparishcacuinta ima turmintarishcatas mana ahuantashaga ñucata catic runa tucunata mana ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pihuas paihua quiquin causaita llaquisha causaushaga huiñai chingarishcami tucunga. Astahuanbas maican runa ñucata catisha causaushcamanda huanchitucushahuas quishpirishca tucusha huiñai Yaya Dioshuan causangami. Chasna nisha Jesus paita catinamanda yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Maicanbas cangunata quirishaga ñucatahuas quirihuanmi. Chasnallata maicanbas ñucata quirishaga ñucata cachamushca Yaya Diostahuas quirinmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Maicanbas ñuca cachashca runata cushihuan uyashaga Diospa shimita camachic runa ashcamandallami, chi camachic runama cushca tuputaga cuitucungami. Chasnallata maicanbas Diospa ñaupacpi ali puric runata cushihuan yaicuchishaga pai ali puric ashcamandallami, chi ali runama cushca tuputaga cuitucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cangunata sirtuta nini, Pihuas ñucata catic runama ashilla yacutahuas upichicpiga Yaya Diosca chi runataga premiotacuinta sirtumi cunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus paihua chunga ishcai (12) runagunata chasna yachachishcahuasha chimanda llucshisha shuc mayan llactagunaibi yachachingahua rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juanga carcelbi tapashca tiyausha Jesucristo imasna runagunata janbisha puriucta uyara. Chasna uyasha pai yachachiushca runagunata cachara Jesusta casna nisha tapugrichi, ");
INSERT INTO qvzNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Canzhangui chi quishpichic Cristomi shamuna an nishca, u shuctachu chapana anchi nisha tapugrichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chasna risha tapucpi Jesus paigunata cutipara, Canguna tucui ricushcagunatas uyashcagunatahuas Juanda cuintagrichi casna nisha: ");
INSERT INTO qvzNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Puyuñahuiyuc runagunahuas cunanga alita ricugmi tucushcauna, ñaupa mana puriccunas cunanga alita purigmi anaun, lepra nishca sinzhi carachayuccunas cunanga caracha illac tucushcaunami, ñaupa mana uyaccunas cunanga uyagmi tucushcauna, huañushca runagunahuas causarishcaunami, chasnallata pugri runagunatahuas Diospa quishpina shimita camachiscataga uyashcaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ñáucata quiric runaga ñucamanda mana pingarisha saquicpiga cushiyashca tucungami. Tucui caitaga Bautisac Juanda rimagrichi nisha Jesus paigunata nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan yachachiushcaguna bulltiashcahuasha, Jesus paimanda cuintangahua callarira casna nisha, Canguna Juan camachiushcata uyashun nisha pi chi chaquishca pambama risha imata ricungahuata riranguichi. Huaira cuyuchiushca shinlutacuinta mana sinzhi quiric runata ricungahuachu riranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Manashaga sumac churarishca runata ricungahuachu riranguichi. Yachanguichimi sumac churarishca runagunaga jatun amuhua huasigunaibimi causanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chasna acpi imatata ricungahuaca riranguichi. Dios rimashcata pasachic runatachu ricungahuaca riranguichi. Indá. Juanga tucui Dios rimashcata pasachiccunamandahuas yalimi an. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Paimandaga Diospa shimibi quillcashcami tiyan casna nisha: Ricui, ñuca shimita rimac runatami ñaupata cachauni camba ñambita alichigriuchun nisha Dios nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sirtutami cangunata nini, Bautisac Juanga tucui camachic runagunamandas yalimi an, shugllas paicuintaga mana pihuas tiyarachu. Chasna agllaita cunanga Diospa ali mandanai maicanbas mana balichishca ac runaga Juanmanda mas yali balichishcami tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bautisac Juan camachingahua callarishca punzhamanda cunan urascamami Diospa ali mandanai yapa yaicunata ashca runaguna munanaushcami. Chasnamandami chi yaicunata munac runagunaga ashca munashcahuanmi yaicunaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan shamushca punzhagama tucui Dios rimashcata pasachic runagunaga chasnallata Moises quillcasha mandashcagunas Diospa partimandami shamungaraun nisha camachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Paigunaga Dios rimashcata pasachic Elias nishca runa shamungami nishami camachinaura. Juanga Eliascuintami puriun. Chita quirinata munashaga quirichilla. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uyana runa ashaga uyangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesus chimanda mas nira, Imasata cunan causac runagunamandaga yuyarishaya ñucaga, imasna ashcatas. Shuc pugllaisiqui huahuagunacuintachanaun. Canzhaibi tiyarisha huahuagunapura caparinacunaun casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Jistata rashcacuinta ulahuatuta tucaranchi randi cangunaga mana bailaranguichi. Llaquilla cantaranchi chasna cantacpis mana huacaranguichi, nishami cuintanacunaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chimanda cangunata nini, Bautisac Juan shamushaga mana yapa micusha upisha puric ara. Chasna agllaitami cangunaga supaita charinmi nisha rimanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Paimandahuasha ñuca Runa Tucuc asha shamusha, micusha upishami puriuni. Chasna puriupimi cangunaga randi micuisiqui, upisiqui man ninguinchi. Chasnallata mana alita rac runagunahuan, gubirnuraicu cullquita tandachiccunahuanbas amigo man nisha rimanguichi. Yuyarichi. Tucui Yaya Dios rashcagunaga ricuchinaunmi pai sirtu ali yuyaiyuc acta nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chasna rimashcahuashami Jesusca maican llactagunaibi pihuas mana rashcagunata ashcata rasha puriura. Chita ricushallata paigunaga mana juchata ranata saquinata munashami mana Diospagma bulltianaurachu. Chasnamandami Jesus paigunata piñasha casna shinzhita rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Chita yachasha paigunataga casna nisha rimara, Ai canmanda Corazín llactayuc runaguna, ai canmanda Betsaida llacta runaguna. Imachari tucunguichi. Ñáuca cangunahuacpi pihuas mana rashcagunataga rashcani. Ñáuca chi Sidón llactai, Tiro llactaibis chasna rashca acpiga chi llactai causac runagunaga unaimi juchata ranataga saquinaunma ara. Paiguna causaita ña cambiarishca ashaga tsuntsu llachapatami churarinaunma ara, ushpami umahuas tucushcami anaunma ara paiguna juchata rashcamanda llaquirisha aushcata ricuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Canguna causaita mana cambiashcamandami cangunataga casna nini, Taripana punzhaibimi Sidón llactayuccunamandas Tiro llactayuccunamandas cangunaga mas yali sinzhita libachishcami tucungaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaunmanda runaguna rimahuaichi, jahuapachama pactashcacuinta tucuimanda mas balichishcachu tucunguichi. Mana. Cangunaga ucupachama shitashcacuinta masmi taripaitucungaraunguichimi. Ñáuca cambacpi rashcagunata Sodoma llactaibi rashcacpiga chi llactaga cunan urascama tiyan mara. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chasna acpi canguna mana cambiashcamandami cangunataga casna nini, Taripana punzhaga Sodoma llactamanda canguna mas sinzhi libachitucunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chihuasha Jesus Yaya Diosta casna nisha alabara, Can jahuapachatas cai pachatahuas mandac mangui Yaya. Canga yapa yuyaiyuc runagunama, yachaushca runagunamas cai ñuca yachachishcagunataga pacashcacuinta mana ricuchiranguichu, astahuanbas paiguna mana balichishca huahuacuinta runagunamaga ricuchishcanguimi paiguna can rashcata yachanauchun nisha. Can casna racpi canda pagrachu nini Yaya. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sirtumi can chasna tucuchun nisha munashcangui Yaya. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yaya Diosta alabashcahuasha Jesus chigunata nira, Ñáuca Yaya tucuita ñuca maquibi saquihuashcami. Pihuas Diospa Churita mana yachanaunzhu, ñuca yayalla ñucataga yachahuanmi. Chasnallata ñuca yayataga mana pis yachanaunzhu, ñucalla paihua churi ashami sirtuta paita yachani. Chasna acpi maican runas ñuca ricsichisha nigllai ñuca yayataga sirtuta ricsingauna nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pihuas imatas aparishcacuinta sambayashca runagunaga tucui ñucama shamuichi. Ñáuca cangunata yanapasha samachishcanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ñáuca yachachinagunata catisha purichi. Ñáucallami mana piñaric mansu asha ali shungu mani. Chiraicu sambayashcacuinta ali causaitaga cangunata cushami. ");
INSERT INTO qvzNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ñáuca yachachinaguna pangallashina manaun aparibaglla nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chihuasha israelguna shuc samana punzhaibimi Jesus shuc chagra ucuta puriura. Pai japishca runaguna raicachisha chi trigo huangugunamanda aisasha muyugunata micusha nisha callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maican fariseo runaguna chita ricusha Jesusta ninaura, Ricui, ñucanchita mandashca shimibiga samana punzhai mana tarabanachanguichi nishca an. Chasna acpi imangahuata chasna raunguna samana punzhamanda quillcashcata mana cadsusha. Paiguna samana punzhataga mana balichinaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Rimacpi Jesus paigunata nira, Ñáaupa causac israel rey amu David paihuan puriucunandi yapa raicachishca uras rashcata manachu Diospa shimibi ricushcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pai Diosta alabana huasima risha Diosma cushca pangunata micura paihuan puriccunandi. Israel pagrigunalla micuna panda micushallata pai mana juchata rarachu. Chasnamandami paitaga mana culpayachinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moises quillcashcata manachu ricushcanguichi imasna Diosta alabana huasi ucui pagriguna samana punzhahuas tarabashallata juchata mana ranaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cangunataga casnami nini, Diosta alabana huasimandas yali ñuca mas balic mani. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Canguna Diospa shimita ricushallata mana intindiranguichichu casna nishcata, aichagunata cangunata rupachisha ñucama ricuchinatas mana munanichu. Chirandimanda canguna shuccunata yuyarisha yanapasha causanauchun nisha munani nira. Canguna chita yachashaga mana alita raccunata mana caudsayachinguichimachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ñáucaga Runa Tucuc ashami samana punzhahuas mandac ani. Chasna nisha Jesus rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chimanda Jesus risha paiguna tandarina huasibi yaicura. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chibi shuc maqui huaglishca runa tiyaura, ñañuyashca ara. Chi fariseoguna Jesus imasna rashcamanda paita caudsayachishun nisha tapunaura, Samana punzha shuc ungushca runatas janbinachan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tapucpi Jesus paigunata randi tapura, Shuc samana punzha can charishca oveja juctu ucui urmacpiga manachu llucshichinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Runaga ovejamanda yali balic man. Chasna acpi samana punzha alita rana balinmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chasna nisha Jesus chi maqui huaglishca runata nira, Camba maquita chutachi. Chutacpi huaglishca maqui chi shuc parti maquicuintallata ali tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Samana punzhai Jesus tarabashcacuinta janbishcata ricusha fariseoguna chimanda llucshisha, paigunapura cuintanacunaura imasna Jesusta huanchishun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chita yachasha Jesus chi llactamanda llucshisha rira. Ashca runaguna paita catinaura. Chi muntunbi ac ungushca runagunata tucuita janbira. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Alichishcahuasha paigunata nira, Ama pitahuas ñucamanda cuintanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chasna tucura Dios rimashcata pasachic runa Isaias nishca ñaupa uras quillcashca pactaringahua. Casnami quillcashca ara: ");
INSERT INTO qvzNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Caimi ñuca mandashcallata rauc runa, paitaga ñucami anllarani. Paitami yapa llaquiuni, paimanda yapa cushiyauni. Ñáuca samaitaga paimami cusha. Pai tucui partibi tiyac runagunata ali causanatas yachachingami. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pai piñarishca shimihuan mana rimangachu, mana caparingachu. Mansu ashcamandami ñambigunaibis runaguna paihua shimita mana uyangaunachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Paiga paquirinalla pangatashina mana paquingachu, huañuuc bilata mana huanchingachu, tucuita pai binsisha shamunagama alita rangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tucui runagunas pai chapangaunami quishpingahua. Isaias chasna unai ñaupa Jesusmanda chasna quillcara. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chihuashami shuc supai yaicushca runata Jesuspagma apamunaura. Chi runa mana ricuc, mana rimacchara. Jesus paita janbicpi chi runa ña ricungahua, cuintangahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chita ricusha tucui runaguna manzharisha, Cai runaga israel ñaupa rey amu Davidmanda miraichan nisha tapunacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Randi fariseoguna chita uyasha cuintanacunaura, Cai runaga Beelzebú nishca supaiguna amuhua shutihuanmi runagunamandas supaigunatas llucshichin. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus chasna paiguna yuyariushcata yachashami nira, Shuc llactaibi causaccuna piñanacusha chican chican muntunbi chaupiricpiga chi llacta tucuringami. Shuc huasibihuas tiyaccunahuas paigunapura piñanacusha tucuringaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chasnallata Satanas paihua supaigunatas jichushaga pai mandanaga chaupirishca tucungami. Chasna tucucpi paihua ushai tucuringami. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Canguna nihuanguichi, Can Beelzebú supaihua ushaihuanmi supaigunata anchuchingui nisha ñucata rimahuanguichi. Chasna acpiga canguna yachachishcata caticcunaga piguna ushaihuanda supaigunata jichunaun. Paiguna chasna rashcahuanmi canguna pandashcata ricuchinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Astahuanbas ñucaga Diospa Samai ushaihuanmi supaigunata anchuchiuni. Chasna rashami Diospa ali mandanaga cangunahuacpi ña pactamushcata ricuchini, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yuyarichi. Shuc runa shuc yapa sinzhi runahua huasima shuhuangahua yaicusha amuta chara mana huatashaga imasata shuhuanata ushanga. Huatashcahuashami illacta ringa. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Maicanbas ñucahuan mana aushami ñucahuan cuntar tucusha purinaun. Maicanbas ñucahuan mana tandachishaga sáata rashami saquinga. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chasnamandami cangunata nini, Runaguna tucui tunu jucha rashcagunamanda, tucui jiridsata rimashcagunamandas Dios perdunasha pichangami. Randi maicanbas Diospa Samaimanda jiridsa rimacpiga chi runata Dios mana perdungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chasnallata nini maican runa ñucamanda, ñuca Runa Tucuc ashcamanda, mana ali rimacpi perdunashca tucunga. Astahuanbas Diospa Samaimanda jiridsa rimac runataga mana perdunaitucungachu, mana cunanbas ni huashahuas perdunangachu, nisha Jesus rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Chimandaga Jesus casna rimara, Shuc ali ruya ali muyugunata aparin, chasnallata mana ali ruyaga mana ali muyugunata aparin. Ima ruyahuas paihua muyumanda yachaitucun. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Cangunaga palugunacuinta mana ali runaguna asha, alita rimanata mana ushanguichichu. Runaguna shungu ucuibi ashca yuyarishcatami pagllai rimarinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ali runaga alita riman paihua shungu ali ashcamanda. Mana ali runaga mana alita riman paihua shungu mana ali ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Dios taripana punzhaibi tucui runaguna ima yanga rimashcamanda taripaitucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Can quiquin rimashca shimigunamandami Dios canda taripanga. Chasnallata can alita rimac asha chi alita rimashcagunamanda Dios canda jucha illac mangui nisha rimangami, chasna nisha Jesus rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Shuc punzha maican fariseogunas, maican Moises mandashcata yachachiccunahuas Jesusta tapunaura, Pihuas mana raushcatas shucta railla señor ñucanchi ricungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Randi paigunata nira, Diosta mana munac asha ashiyac runagunacuinta anguichi pihuas mana rashcata shucta ricuchihuai nisha. Chasnagllaita shugllata ricuitucunguichimi casna, Dios rimashcata ñaupa timpu pasachic runa Jonas tucushcacuinta ricuringa. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonasca quimsa (3) tuta quimsa punzha shuc jatun yacu aicha ucuibi tiyashcacuinta Runa Tucuc chasnallata quimsa tuta punzhas allpa ucuibi tiyashami, nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive nishca llactaibi Jonas camachishcata uyasha paiguna causaita cambianaura Dios munashcata rangahua. Cunanga Jonasmanda yali camachic runami cangunahuacpiga auni. Chasna acpi Dios taripana punzhaibi paiguna shayarisha cangunata caudsayachinaungami ñucata mana uyashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chasnallata urai partimanda shuc huarmi mandac amuga yapa carumanda shamura israelgunata mandac rey amu Salomon yachashcagunata tapungahua. Cunan chi Salomonmanda shuc yali balic runami cangunahuacpiga auni. Chasna acpi Dios taripana punzhaibi chi jatun huarmi mandac amuga cangunata caudsayachingami ñucata mana uyashcamanda nisha Jesus rimasha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesus chimanda mas yachachira casna nisha, Supai shuc runa ucumanda llucshisha yacu illashca partigunai puriun mai runaibihuas yaicusha samangahua nisha. Randi mana tupasha chi supai yuyarin cutillata bulltiasha ñuca llucshishca runamallata cuti causangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Chima bulltiasha chi runahua shungu chushac huasicuinta pichashcata, tucuita alichishcata tupagrira. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chita ricusha paimanda mas jiridsa canzhis (7) supaigunataga apagringa chi runa ucuibi cuti yaicusha causangahua. Yaicucpi chi runa randi mas jiridsa saquiringa. Chasnallata cunan mana ali causaucunahuacpi chasnacuinta tucungaraun. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus chara rimaushcai paihua mama, paihua huauquigunandi shamunaura. Huasi canzhamanda shayasha paihuan cuintanacunata munanchi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chasna acpi shuc runa Jesusta nira, Uyai, camba mama camba huauquigunandi canzhaibi shayaunguna, canhuan cuintanata munaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chi rimacta uyasha Jesus nira, Pitan ñuca mama, pigunatanaun ñuca huauquiguna. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huasha paihua maquihuan pai japishca runagunata ricuchisha nira, Caigunami ñuca mama tucuc, ñuca huauquiguna tucuc. ");
INSERT INTO qvzNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ñáuca jahuapachaibi tiyac Yaya munashcata pactachic runaga ñuca huauqui tucuc man, ñuca pani tucuc man, ñuca mama tucuc man, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesus chi huasimanda llucshisha risha cucha patai tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ashca runaguna shamunaupi shuc canua ucuibi yaicusha tiyarira, runagunaga chi cucha patalla saquirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesus ashca cuintanagunata chi runagunata yachachira. Shuctaga casna nisha yachachira, Shuc runaga muyuta tarpungahua rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jichaupi maican muyuguna ñambibi urmanaura. Pishcuguna shamusha chi muyugunata micunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Maican muyuguna rumi jahuaibi urmanaura, mana ashca allpa tiyashcaibi. Huairashina pangamalla huiñanaura, allpa mana yapa tiyacpi. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ñáa indi llucshisha chi huiñauc pangagunata rupachira, angu illac ashcamanda chaquirisha huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Maican muyugunaga huita ucuibi urmanaura. Randi anguguna quipiricpi huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Maican muyugunaga ali allpaibi urmasha alita huiñasha, ashcata aparinaura. Chi ali allpai urmac muyugunamanda maicanguna shuc patsac (100) muyu aparira, shuccunamandaga sucta chunga (60) muyulla aparira, maicangunamandaga quimsa chunga (30) muyullata aparira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Rinriyuc runaga caita alita uyachun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chasna rimacpi pai japishca runagunaga Jesusta casna nisha tapunaura, Imangahuata runagunata chasna yachachina cuintanagunahuan yachachingui. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chasna tapucpi Jesus nira, Diosca paihua ali mandanamanda pacashcacuinta mana ñaupa yachachishcataga canguna cunan yachanauchun nisha ricuchiun, randi shuccunaga paita mana munasha mana intindinata ushanaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Charic runaga cuitucungami ashcata charingahua, randi mana charic runamanda pai ashilla charishcahuata quichuitucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chicuinta paiguna ricushahuas, mana ricushcacuinta saquirinaunmi, paiguna uyashahuas mana intindisha mana uyaccuintami saquirinaun. Chimandami paigunama cai yachana cuintanagunata rimani. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chasna acpi Dios rimashcata pasachic runa Isaias rimashcaga paigunahuacpi pactariun casna nishca: Paiguna Diospagmanda uyaushahuas mana alita intindinaungachu. Ricuushahuas mana asirtanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cai runaguna taparic rinriyuccuinta tucunaushca uyanata mana munasha, puyuñahuiyuccuinta tucunaushca ricunata mana munasha. Chasna acpi sinzhi yuyaiyugasha paigunata ñuca mana alichingahua ñucahuagma mana shamunauchun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Isaias quillcashcata rimashcahuasha Jesus catisha nira, Randi cangunaga cushi runa anguichi munaihuan uyashcamandas ricushcamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sirtumi cangunata nini, Dios rimashcata ñaupa pasachic ashca runagunas, ñaupa causac Diospacpi ali mangui nishca ashca runagunahuas canguna cunan ricushcata ricunata munashallata mana ricunaurachu, canguna cunan uyashcata uyanata munashallata mana uyanaurachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Huasha Jesus nira, Chi tarpuc runamanda yuyachishcataga uyahuaichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Maican runagunaga chi ñambibi urmashca muyucuinta anaun. Paiguna Diospa shimita uyaushallai mana intindisha yangalla uyac acpi Satanas shamusha chi shimita paiguna shungumanda quichusha chingachin paiguna uyashcata. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shuc runagunaga rumi pambaibi urmashca muyucuinta anaun. Chi Diospa quishpina shimita cushihuan uyanaun, quiringahua callarinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chasna agllaita ña ima camana llaqui turmintarinas shamucpi pai mana ashca anguyuccuinta asha urmashcacuinta Diospa shimita quirinata dsaslla saquinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Shuccunaga huita ucui urmac muyucuinta manaun nira. Paiguna Diospa shimita uyashcahuasha cai pachai imagunatas cushigunatas yapa yuyarin. Chigunaga Diospa ali shimita huaglichinaungami, chi ruya ali huiñashallata mana aparishcashinami chi runaga mana Dios munashcashina tucun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Astahuanbas shuc runagunaga ali allpai tarpushca muyucuinta anaun. Diospa shimita uyasha quirinaun. Chi shimiga paihua shungüi alita huiñan, Dios munashcata rasha gustuta aparishcacuinta tucun. Maican ruya shuc patsacta (100) aparin, maican ruya sucta chunga (60) muyuta aparin, maican ruya quimsa chunga (30) muyuta aparin. Chasna ricuchin Yaya Dios munashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus shuc yachachinata cuintara casna nisha, Diospa ali mandanaga shuc runa ali trigo muyuta paihua chagraibi tarpushcashinami. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Paihua runaguna puñuushcai shuc paita piñac runa shamusha trigocuinta ricuric mana ali quihuata tarpusha saquira chillai. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo ña huiñaupi chi mana balic quihuagunahuas huiñara. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chita ricusha chi tarabaccuna amuta cuintagrinaura, manachu ali muyutaga camba chagraibi tarpuchirangui señor. Imamandata chi mana ali quihuaga huiñaun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Amu nira, Ñáucata piñac runachari chasna rara. Chasna nicpi paihuacta tarabaucuna ninaura, Can munacpi chi yanga quihuata pitigrishun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Randi amu nira, Cunanllaga ama imatas raichichu. Chi mana ali muyuta pitiushaga chi ali trigotahuas pitinguichima. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Chasna acpi tucui muyu pucunagama saquichi. Huasha, pallana uraspi chi mana ali quihuata ñaupata pitinguichi rupachingahua. Chihuasha trigo nishca ali muyuta pallasha ñuca huasibi huacaichinguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus shuc yachachinatas cuintara casna nisha, Diospa ali mandanaga shuc mostaza nishca ichicua muyucuinta man. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tarpuushca uras tucui muyugunamanda yali ichilla man, randi huasha huiñasha tucui tarpushca quihuamandas yali jatun ruya tucun. Pishcugunas shamusha paihua ramagunaibi huasinaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Cai shuc yachachinatahuas cuintasha yachachira, Diospa ali mandanaga panda putasyachinacuinta man. Shuc huarmi putasyachinata ashillata japisha, quimsa (3) harina muntunhuan chapusha saquinmi tucui ali putasyarinagama nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Chasna chi tunu yachachina shimigunallahuan Jesus tucui runagunata yachachira, puru yachachisha cuintashcagunahuan yachachic ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dios rimashcata pasachic runa ñaupami rimashca pactaringahua chasna tucura. Casnami quillcashca ara: Yachachisha cuintanagunallahuan rimashami. Dios cai pachata rashca urasmanda pihuas mana yachashcagunata yachachishami, nishca quillcashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chi shimigunata cuintashcahuasha Jesus runagunata dispirisha shuc huasima yaicura. Chibi pai japishca runaguna paihuagma shamusha tapunaura, Chi mana balic quihuamanda can yachachisha cuintashcata ñucanchita yachachi. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chasna tapunaupi nira, Ñáuca Runa Tucuc asha muyuta tarpuc runacuinta mani. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chagraga cai pachacuintami. Ali muyuga Diospa runagunashina manaun. Chi mana balic quihuagunaga supaita caticcuna manaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chi mana balic quihuata tarpucca supaimi. Pallanacuinta man cai pacha tucurinaga, chi pallaccunaga Diospa angelguna man. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chi mana balic quihuata pitisha rupachishcacuinta chasnallatami tucunga cai pacha tucurina uraspi. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ñáuca Runa Tucuc asha, jahuapachamanda ñuca angelgunata cachangamirauni. Paiguna tucui shuccunata juchata rachic runagunatas mana alita rauc runagunatahuas ali mandanamanda tandachinaungami anchuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tandachisha jatun nina ucuibi paigunata shitaitucungaunami, chibi huacais tucui tunu nanaigunas tiyangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Randi Dios munashcata pactachiccunaga pai mandashcai cushi causausha llactai indi shitashcashina punzhaglla ricurinaungami. Rinrita charishaga uyangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus mas yachachira casna rimasha, Diospa ali mandanaga balic curita allpa ucuibi pacashcacuinta man. Chi pacashca curita tupac runaga chillaita pacangami huacaichingahua. Pai ashcata cushiyashcamanda tucui pai charishcagunatas illacta randichingami chi allpata randisha charingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Chasnallata yuyarichi. Diospa ali mandanaga shuc randic runacuinta man. Paiga yapa balic perla nishca rumigunata mascasha puriun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Shuc punzha shuc yapa balic perla rumita tupasha tucui pai charishcata illacta randichin chi perlata randisha charingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Shucta yuyarichi. Diospa ali mandanaga shuc licacuinta man. Yacu aichagunata japiccuna licata cuchaibi shitasha tucui tunu yacu aichagunatas japinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chi lica ña jundaricpi pulayagama aisanaun. Tiyarisha ali aichagunata ashangaibi churanaunmi randi mana baliccunataga jichunaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chasnami tucunga cai pacha chingarishcai. Diospa angelguna shamunaungami chi aligunahuagmanda tucui mana aligunata anchuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Anchuchisha chi mana aligunata nina ucuibi shitangaunami. Chibi jatun huacai tucui tunu nanaigunahuas tiyangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","52","Jesus chasna rimashcahuasha paigunata tapura, Cai tucuita intindiunguichichu nisha. Tapucpi indá ninaupi, Jesus paigunata cuti rimara, Diospa shimita yachachic runaga shuc huasiyuc amucuinta man. Chasna asha paihua huasi ucumanda llucshichinmi ali mushuccunatas ñaupa charishcagunatahuas. Chasna rimasha Jesus yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus chi cuintanagunata yachachishcahuasha chimanda llucshisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Risha paihua quiquin llactama pactasha chibi tiyac israel tandarina huasibi yachachingahua callarira. Yachachiupi paita uyaccuna manzharisha rimanacunaura, Pai yachachishcataga maimandata yacharaya. Pihuas mana rashcata rana ushaitaga maimandata yachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Chasnallata asisha rimanacunaura, Cai runaga manachu carpintero runahua churi anya, paihua mama manachu Maria anya. Manachu paihua huauquigunaga Santiago, Jose, Simon, Judaspas anaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Paihua panigunahuas manachu ñucanchihuan causaunguna. Chasna acpi, maimandata paiga tucuita chasnaga yachashca angaya ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chasna yuyarisha Jesusta mana uyanata munanaurachu. Chasna acpi Jesus paigunata nira, Tucui partibi Diosmanda rimactaga runaguna balichinaunmi randi paihua quiquin llactamanda accunas, paihua aillugunahuas paita mana balichinaunzhu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chasna acpi paihua llactaibiga paita mana quirishcamandami ashilla runagunata janbira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herodesca Galilea gubirnadur aushcaimi Jesus pihuas mana rashcagunata ashcata rashcamanda uyara runagunatas janbishcamandas. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chita uyasha paita cuirac runagunata rimara, Bautisac Juanmi causarishca, chasna causarisha ashca ushaihuanmi puriun nisha ashcata manzharira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ñáaupallata mandac amu Herodesga paihua cachunllatata japira paihua huauqui Felipeta quichusha. Chi huarmiga Herodías shutiyug mara. Chasna quichusha japishcamandami Herodestaga Juanga caran cutin camachic ara casna nisha, canga mana alitachu rashcangui camba huauquihua huarmita quichusha japishcamanda nisha. Chasna camachicpimi chi Herodesca paihua runagunataga mandara Juanda japisha huatasha carcelbi tapaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tucui runagunaga yuyarinaurami Juanga Dios rimashcata pasachic man nisha. Chasnamandami amu Herodesca Juanda huanchisha nisha yuyarishallata runagunata manzhasha mana imata rara. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chasna rashcahuashami amu Herodes pagarishca punzha pactacpi jistata ranaura. Chi jistaibimi paihua ushushi tucuc tucui cayashca runaguna ñaupacpi bailasha amu Herodesta ashcata cushiyachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chasna cushiyaushami, Can munashcata tapuhuai, ñucaga cushcanguillami nisha paita rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chasna nicpi chi ushushi tucuc amu Herodesta tapura paihua mama cunashcacuinta, Bautisac Juanba umata shuc pulatui cuhuangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Chasna tapushcata uyasha amu Herodes yapa llaquirira. Chasna agllaita chibi tiyaucuna ñaupacpi can munashcata cushcanguimi nishcamandami carcelbi Juan auta paihua umata pitigrichi nisha sundalugunata cachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huanchishcahuasha Juanba umata shuc pulatui churasha Herodíaspa ushushima cunaura. Chihuasha chi ushushi paihua mamata cura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chasna huanchishcata uyasha Juanda caticcuna paihua aichata apasha pambanaura. Chihuasha Jesusta cuintagrinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bautisac Juanda huanchishcata uyasha Jesus chi partimanda llucshishun runaguna illashca partima rishun nisha canuaibi yaicusha chimbanaura. Randi runaguna chita yachashaga llactagunamanda llucshisha mayanllata chaquihuanlla apanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus ña canuamanda llucshisha ashca runagunata ricusha llaquirisha yanapanata munara. Chasna acpi tucui chibi auc ungushcagunata janbira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chasna paiguna aushcai tutayaupi pai japishca runaguna paihuagma caillayasha ninaura, Ñáa tutayaunmi, cai mayanllaiga huasiguna illanmi, chasna acpi cai runagunata cachai, paiguna chi llacta mayangunai micunata randigrinauchun. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chasna nicpi Jesus paigunata randi nira, Mana minishtirinzhu paiguna chima ringahuaca, cangunallata caraichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chita uyasha rimanaura, Pichca (5) panllata chimanda ishcai (2) yacu aichallata charinchi. Chillami tiyan ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chasna ninaupi Jesus nira, Chillatas apamuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Apamunaupi runagunata quihua jahuai tiyarichi nira. Chihuasha chi pichca pandas ishcai yacu aichatas japisha, jahuama ricusha Diosta pagrachu nira. Chasna pagrachushcahuasha panda partisha pai japishca runagunama cura, paiguna randi tucui runagunama cunaura micunauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tucuigunami sacsacta micunaura. Micushcahuasha Jesus japishca runaguna puchucta tandasha chunga ishcai (12) ashangata jundachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chi micuc carigunallashi pichca huaranga (5.000) tupu anaushcaya, huarmigunatas huahuagunatas mana yupagllaita. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chihuasha Jesus pai japishca runagunata nira canguna canuai yaicusha chimbama ñaupasha richi runagunata ñuca dispirinagama. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pai dispirishcahuasha sapalla urcuma sicara Dioshuan cuintanacungahua. Ñáa tuta aushcai paillami chillaita chara aura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chi canuai riucunaga chaupi cuchata cahuirisha riushcai sinzhi huaira shamucpi canua cadsi tigrara. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ñáa punzhayana partibi Jesus paigunahuagma shamura yacu jahuata purisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chi canuai auc runaguna pai yacu jahuata purimucta ricusha yapa manzharinaura. Jesus acta mana yachasha ayachari an nisha manzharisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chasna caparinaupi Jesus uctalla paigunata, Ñáuca mani, ama manzharisha cushiyaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jesus rimashcata uyasha Pedroga nira, Can ashaga cambagma yacu jahuata shamui nisha rimahuai señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus shamui nicpi Pedro canuamanda llucshisha yacu jahuata purisha Jesuspagma riura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Randi yapa sinzhi huairaushcata ricusha manzhasha yacu ucuma pambaringahua callarira. Chasna tucusha, quishpichihuai señor nisha caparira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Caparicpi Jesus maquimanda japisha nira, Ashilla quiric mangui, imangahuata manzharingui. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ñáa paiguna canuaibi yaicushcallahuan huaira saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chi barcoi aucuna Jesuspa ñaupacpi cungurisha ninaura, Sirtupacha can Diospa churi mangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ñáa paiguna cuchata chimbasha Genesaret nishca partima pactasha llutarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chibi causauc runaguna Jesusta ricsisha tucui partigunama shimita cachanaura Jesus shamushcami nisha. Chita uyasha ungushcagunata paihuagma apamunaura janbipachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Paihuagma apamusha paita ruganaura, Ungushca runaguna can churariushca llachapa pundahuallatas llanganauchun nisha. Chasna acpi tucui llangac runaguna janbirinaurami. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Maican fariseoguna Jerusalenmanda shamushcauna Moises mandashcata yachachiccunandi Jesuspagma shamusha tapunaura, ");
INSERT INTO qvzNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Imamandata camba runaguna ñucanchi ñaupa yachachishcagunata mana pactachinaun. Camba runaguna micungaraushcai paiguna maquita mana maillarinaun ñucanchi huañuc apayayaguna tunu yachachishcacuintaga. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tapunaupi Jesus randi tapura, Cangunaga imaraicuta Dios mandashcata pactachinarandiga canguna apayayaguna tunu causanallata catinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosca casnami mandara: Camba yayatas camba mamatas cadsuna manguichi nishca. Maican runas paihua yayata, mamata camisha jiridsata rimashaga paillatami huañuchun, Dios nishami mandashca. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Randi canguna ninguichi, shuc runa paihua yayagunata rimasha tucui ñuca charishcata Diosma cumbirashcani, cangunata cunan yanapangahua mana imas tiyahuanzhu nisha rimashaga paigunata mana yanapanachan nisha rimanguichi. Chasna nisha canguna munashca causana tunuta catingahuaca Dios mandashcataga mana balichinguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Llullaisiquiguna manguichi. Alitami Dios rimashcata pasachic Isaias cangunamanda quillcara casna rimasha: ");
INSERT INTO qvzNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Cai runaguna paiguna shimillahuanmi ñucata llaquihuanaun randi paiguna shunguga ñucamanda caruibi maun. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ñáucata sirtu llaquiucuinta yanga alabahuanaun. Paiguna yachachishca shimiga runa yuyaimandalla mandashcaguna manaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chihuasha Jesus tucui chi runagunata mayanllayaichi nisha rimara, Ñáucata intindisha uyahuaichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shimibi yaicuc micunaga runata mana juchayachinzhu, randi runa shimimanda rimashcaga runata juchayachinmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jesus casna rimacpi pai japishca runaguna paita ninaura, Fariseogunaga can rimashcata uyasha yapa piñarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Rimanaupi pai nira, Shuc ruyata mana tarpushcata pilashcacuinta ñuca jahuapachai tiyac Yaya paiguna yachachishcata rangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Saquichilla paigunataga imasnas anauchun. Shuc puyuñahui runaga shuc puyuñahui runata pushaupi ishcandi (2) juctu ucui urmangauna. Chi fariseo runaguna chasnacuintallata manaun. Puyuñahui runagunacuinta ashallata puyuñahuicuinta ac runagunataga pushanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Casna Jesus rimacpi Pedro nira, Imatata chasna nishaga yachachingui. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tapucpi cutipasha nira, Cangunahuas chara manachu intindinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aichamanda manachu yachanguichi. Shimi ucuibi yaicucca huicsama pasan, chihuasha pagllama llucshin. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Randi shimimanda llucshic rimanaga shungumandami llucshin, chimi runataga jiridsayachin. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runa shungumandami llucshinaun mana ali yuyaigunaga, runata huanchina, shucpa huarmita quichusha japina, ashiyana, shuhuana, llullana, caminagunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chigunami runataga jiridsayachin, randi micungahua maquita mana maillashcaga runata mana juchayachinzhu, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus chasna runagunata yachachishcahuasha chimanda llucshisha Sidón, Tiro llactaguna partima rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canaan llactamanda shuc mana-israel huarmi Jesuspagma caparisha shamura, israelgunata mandac rey amu Davidmanda mirai angui señor, chasna asha ñucata yuyarisha yanapahuai. Ñáuca ushushita paihua aichai auc supai yapa turmintachipan. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Chasna caparigllaita Jesus mana imatas paita rimarachu. Pai chunga ishcai (12) japishca runagunaga paita ruganaura, Cai huarmi caparisha ñucanchita catimun, pai tapushcata cui uctalla pai chunllayachun. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus cutipasha nira, Ñáucaga chingarishca ovejagunacuinta israelmanda miraigunamalla cachashca mani. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Randi chi huarmi Jesuspagma shamusha paihua ñaupacpi cungurisha nira, Yanapahuai señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chasna nicpi Jesus paita nira, Israel runaguna Diospa huahuagunashina anaun. Huahuaguna micucta quichusha allcu huahuagunashina shuc runagunama cucpiga mana balinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Rimacpi chi huarmi randi nira, Sirtu chasna man señor, chasna acpihuas allcugunaga mesamanda jicharic acuhuataga micuc manaun. Chicuinta ashillata yanapahuai señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chita uyasha Jesus nira, Yapa alitami Diosta quiringui, chasnamandami can munashcacuinta tucuchun. Chi ratullai chi huarmihua ushushimanda supai llucshicpi ali tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus chimanda risha Galilea cucha mayanda pasaura. Chibi shuc urcuma sicasha tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ashca runaguna pai tiyaushcama shamunaura ima tunu unguyuccunatas apamusha, mana puric runaguna, puyuñahuiguna, mana rimaccuna, huaglishca maquiyuccuna, shuccunahuas. Paigunata Jesuspa ñaupacpi churacpi pai tucuigunata janbira. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Janbicpi chi mana rimaccunaga rimangahua callarinaura, huaglishca maquiguna alichishca tucunaura, mana puric runaguna alita puric tucunaura, puyuñahuiguna ña ricuc tucunaura. Tucui chi runaguna Jesus rashcagunata ricusha manzharisha israelgunahua Diosta alabangahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chihuasha Jesus pai japishca runagunata caima shamuichi nisha, cai runagunata ricusha llaquirini nira. Ricuichi ña quimsa (3) punzhata ñucahuan anaushca, cunan micunata mana charinaunzhu. Ñáucanchi paigunata mana carasha cachaupiga mana alitachu yachihuan, paiguna raicaihuan ñambita riusha sambayasha purinata mana ushanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nicpi pai japishca runaguna ninaura, Cai mayanllaiga huasiguna illanmi, chasna acpi maimandata paigunata carashunya cai tucui ashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chasna ninaupi Jesus paigunata tapura, Masna pandata charinguichi. Tapucpi cutipanaura, Canzhis (7) panda charinchi, ashicua yacu aichatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chita uyasha Jesus nira, Tucui runagunata allpaibi tiyarichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tiyarinaupi Jesus chi canzhis pangunata yacu aichagunatahuas japisha Yaya Diosta pagrachu nishcahuasha chi micunata paquisha pai japishca runagunama cura paiguna randi runagunata carangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tucuiguna sacsacta micunaura. Chihuasha pai japishca runagunaga chi micuna puchushcata tandasha canzhis ashangata jundachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Micuc carigunalla chuscu huaranga (4.000) tupushi anaura, huarmigunata huahuagunatahuas mana yupanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chihuasha Jesus runagunata dispirisha canuaibi yaicusha paihua runagunandi Magdala nishca partima rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseoguna saduceogunandi Jesuspagma shamunaura paita camangahua sirtuchu Diospagmanda shamuc an nisha. Camashun nisha paita tupanaura, Pihuas mana rashcata jahuapacha ushaihuan rai ñucanchi ricungahua ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Chasna tapunaupi paigunata Jesus nira, Chishibi canguna ninguichi cunan puyu illashcamanda cayaga ali punzha manga. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tutamanda ninguichi, cunan yapa ansa ricurishcamanda cunan punzhaga tamiyangaraun. Diosta mana yuyariccunachanguichi. Cielota ricusha ima tucungaraushcata yachanchimi ninguichi randi cunan ñuca raucta ricushahuas mana yachanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cai runagunaga, mana alita rac ashami, Diosta mana uyac ashami, pihuas mana rashcagunata rasha ricuchihuai nisha ruganaun. Randi shugllatas ricungaunami, Dios rimashcata pasachic runa Jonashuan tucushcata. Chillata rimasha Jesus paigunata saquisha chimbama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesus pai japishca runagunandi cucha chimba partima pactashcai paiguna panda apasha rinata cungarishcauna ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus paigunata cunara, Fariseogunahua, saduceogunahua panda putasyachinamanda cuirarichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nicta mana intindisha paigunapura rimanacura, Chitaga niunmi ñucanchi panda cungarisha mana apamushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chita yachasha paigunata nira, Imamandata panda mana charinchi nisha rimanacunguichi. Canguna ansallata quiriccuna manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Chara manachu intindinguichi. Ñáuca pichca huaranga (5.000) runagunataga pichca (5) panllahuan carashcaibi manachu ashca ashanga puchushcata japishcanguichi. Chasnallata ñuca chuscu huaranga (4.000) runagunataga canzhis (7) panllahuan carashcaibi ashca ashanga puchushcata manachu japishcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Chasna acpi manachu yachanguichi ñuca rimashcaga mana panmandachara. Cunan cangunata cuti rimani, fariseogunahua, saduceogunahua panda putasyachinataga yuyarisha cuiraringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chita uyasha ña alita intindinaura pai putasyachinamanda rimaushaga fariseoguna saduceoguna yachachina tunumandami rimaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus Filipo Cesarea nishca partima pactasha pai japishcagunata tapura, Runa Tucuc acpi ñucamanda runaguna imasata rimanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tapucpi ninaura, Maicanguna Bautisac Juan mangui nisha rimanaun, shuccunaga Dios rimashcata pasachic Elias mangui, shuccunaga pasachic Jeremias mangui, maicangunaga shuc pasachic runa mangui nisha rimanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus cutillata tapura, Cangunaga pi man nishata ñucataga yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pedro paita cutipasha, Canga quishpichic Cristo mangui, causac Diospa Churi mangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chasna rimacpi Jesus paita nira, Cushiyashca tucungui Jonaspa churi Simon. Can rimashca shimitaga mana pi runahuas canda yuyachirachu, randi ñuca jahuapachaibi auc Yayami chitaga canda rimachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ñáuca canda nini, Can Pedro nishca rumicuinta mangui. (Chitaga griego shimii Pedro nisha rumi nin.) Cai rumi jahuaibi huasita shayachishcacuinta ñucata quiriccunata mirachishami. Chasna acpi ucupachamanda supaigunaga ñuca runagunata mana binsinatas ushanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Diospa ali mandana llavigunatacuinta cushcangui. Cai pachai imata can huatacpis jahuapachaibi huatashca an. Cai pachai can imatas pascacpihuas jahuapachaibi pascarishcami saquirin. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chihuasha Jesus paigunata nira, Ñáuca Cristo ashcataga pitahuas ima cuintaichichu cunanga. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chihuasha pai japishca runagunata nira, Jerusalenma rina mani. Chibi israelgunata mandac rucugunas, pagriguna amugunas, Moises mandashcata yachachiccunahuas ñucata llaquichihuanaungami, ñucata huanchihuanaungami. Chasna acpihuas quimsa (3) punzhaibi causarishami. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chasna nicta uyasha Jesusta chinayama apasha, Pedro paita camachingahua callarira casna nisha, Chitaga Yaya Dios ima munachun, canhuan ima chasna tucuchun señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus bulltiarisha ricusha Pedrota nira, Can ñucata pandachisha nishcamanda anchuri supai. Dios munashcataga mana yachanguichu, randi runacuintami yuyariungui. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Huasha pai yachachiushcagunata nira, Maicanbas ñucata catinata munasha pai quiquin munaita saquisha, cruspi huanchitucungarauc runacuinta ñucahuan shamuchun. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maicanbas paihua causaillata llaquisha causashaga huiñai ucupachama chingaringami, astahuanbas ñucata catiushcamanda huanchitucushaga huiñai quishpishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Uyaichi maicanbas cai pachai tucui ima tiyaccunatas charic ashahuas pai huañushcai imasna paganata mana ushanzhu cuti causangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ñáuca Runa Tucuc asha shuc punzha mandac amu tucusha ñuca Yaya sumacshina shamushami paihua angelgunahuan pariu. Chi uraspi caran runata pagashcacuinta caran amu rashca tuputa cungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sirtumi cangunata nini, Ñáuca Runa Tucuc asha Diospa ali mandanai mandac amu tucusha bulltiamungarauni. Chitaga caibi aucunamanda maicanguna chara mana huañushallatami ñuca shamushcata ricunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chasna yachachisha Jesus sucta (6) punzhahuasha Pedrota, Santiagotas paihua huauqui Juandas shuc jahua urcuma paigunallata apara. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Paiguna chibi aushcai Jesus chuyajlla ricuric tucura, paihua ñahuiga punzhaglla indicuinta ricurira, paihua churarishca llachapahuas ruyaglla ricuric tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chibi ñaupa causaccuna Moisespas Eliaspas Jesushuan cuintanacucta Pedroguna ricurimunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro paigunata ricusha Jesusta nira, Ñáucanchi saquirisha caillai aucpi ali anma señor. Can munacpi ñuca quimsa (3) ranchuta rasha, cambac shuc, Moisespac shuc, Eliaspac shuc. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pai chasna rimaushcallai shuc punzhaglla ricuric puyu urmamusha paigunata catara. Chi puyu ucumanda shuc shimi uyarira casna nishca, Cai man ñuca llaquishca churi, paitami uyana anguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chi quimsa (3) Jesus japishca runaguna chita uyasha yapa manzharisha umata allpai tupachinagama cumurinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus caillayasha paigunata llangasha nira, Shayarichi, ama manzharichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pai rimacta uyashami Jesusllata ricunaura, chi shuccunaga ña illashcanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chihuasha urcumanda uraicuusha Jesus paigunata rimara, Ñáuca Runa Tucuc nishca asha hasta ñuca huañusha causarinagama canguna ricushcata ima pitahuas cuintanguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jesus chasna rimashcata uyasha chi quimsaguna paita tapunaura, Imamandata Diospa shimita yachachiccuna rimanaun ñaupa timpu causac Eliasca ñaupapunda shamuna man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tapucpi nira, Sirtu Elias ñaupata shamuna man, pai shamushami tucuita alichinga. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Cangunata nini, Eliasca ña shamui pasarami. Shamushca agllaita runaguna pai pi ashcatas mana ricsinaurachu, chasna asha paiguna munashcataga paita rasha huanchinaura. Paiguna chasnallata ñucatahuas turmintachisha huanchihuanaunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesus chasna rimashcata pai japishca runaguna uyasha Bautisac Juanmandami pai rimashcata intindinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Urcumanda uraicusha runaguna tiyashcama pactacpi shuc runa Jesuspagma caillayamusha cungurisha nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Señor, ñuca churihuamanda yuyarisha yanapahuai. Caran uras huañui japicpi yapa turmintarisha causapaun, ashca cutin ninaibis yacuibis urman. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Can japishca runagunama apamurani randi paigunaga alichinatas mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Rimacta uyasha tucui runagunama Jesus nira, Canguna ñucata mana quiric ashcamandami mana alita raucuna anguichi. Chasna acpi cangunahuan ima urascamata ahuantasha tiyasha. Chi musuta caima apamuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Apamucpi Jesus chi yaicushca supaita sinzhita rimashcamanda chi musumanda llucshichira. Chasna supaita llucshichicpi chi ratullai aliyara. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chihuasha pai japishca runaguna Jesushuan pacalla cuintanacusha tapunaura, Imangahuata ñucanchiga supaita chi runamanda llucshichinataga mana usharanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tapucpi nira, Canguna ansallahuas quirishaga shuc jatun ranataga ushanguichimi. Chiraicumi chi supaita llucshichinata mana usharanguichichu. Shuc mostaza nishca ichicua muyucuinta canguna ashilla quiricpihuas chi urcuta caimanda anchuri nisha canguna rimacpiga anchuringami. Canguna ñucata sinzhita quirishaga tucuita ushanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Chasna acpi mana micusha sasisha Yaya Diosta tapushallami cai tunu supaita anchuchinataga ushanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Galilea partibi puriushcai Jesus pai japishca runagunata nira, Ñáuca Runa Tucuc acta japisha huanchihuanaungami. Chasna ashahuas quimsa (3) punzhaibi cutillata causarishami nira. Pai chasna rimashcata uyasha paihua runaguna yapa llaquirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaun llactama pactaushcai Diosta alabana huasimanda pagana cullquita japiccuna Pedrohuacpi pactasha tapunaura, Cangunata yachachic runaga Diosta alabana huasimanda pagana cullquita pagacchan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tapunaupi cutipara, Indá, pagac man. Huasha, huasima pactacpi Jesus paita tapura, Simon, cai pacha amugunaga pigunamandata cullquita japinaun. Paihuac runagunamandachu, shuc partigunamandachu japinaun. Imasata yuyaringui. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tapucpi Pedro nira, Shuc partigunamanda. Pedro chasna cutipacpi Jesus paita nira, Chasna acpiga ñucanchi Diospa quiquin runaguna asha chi cullquitaga mana paganachanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Chasna acpihuas paiguna ima piñarinauchun nisha Galilea cuchama risha andsilugri. Punda yacu aichahua shimi ucuibi shuc cullquita tupangaraungui. Chi cullquiga pactangami canmandas ñucamandas pagangahua. Chi cullquitaga paigunama cugri nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chi urasllaita pai japishca runaguna Jesusta tapunaura, Diospa ali mandanaibi auc runagunamanda maican runata yali balicca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tapucpi Jesus shuc huahuata cayasha paiguna chaupibi shayachira, chihuasha paigunata nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sirtuta nini, canguna shuc huahuagunacuinta juchata mana yuyaric tucusha nisha, canguna yuyaita mana cambiashaga Diospa ali mandana muntunma mana yaicunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Maican runas cai huahuacuinta mana alabaric ashaga Diospa ali mandanaibi yali balic tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Maican runahuas ñucahuagraicu cai huahuatashina llaquishcahuan japishaga ñucatami japihuanga. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesus mas rimara, Maican runahuas cai huahuatacuinta ñucata quiric runagunata juchata rachicpiga paihua cungaibi shuc jatun rumita huataitucusha jatun cucha ucuma shitanaupi chucacpi ali anma. Pai sirtu mas ashca turmintachishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Cai pachai juchata rachic runaguna sirtu tiyangaunami. Chasna acpi paigunamanda cai pacha llaqui taripaitucungami. Chi tunu rac runagunaga llaquita turmintaringaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Chiraicu camba maqui, camba chaqui canda juchata rachicpiga chigunata pitisha caruma jichungui. Ishcai maquiyuc ishcai chaquiyuc ucupachama rinarandimanda pullu maquihuan pullu chaquihuan jahuapachama yaicunaga mas ali anga. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chasnallata camba ñahuiga juchata canda rachicpiga chita surcusha caruma jichungui. Ishcai ñahuiyuc ucupachama rinarandimanda shuc ñahuillahuan jahuapachama yaicunaga mas ali anga. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesus catisha rimara, Cai huahuagunamanda ama pitahuas ninguichichu mana balicchan nisha. Paigunahua jahuapacha angelgunaga tucui uras ñuca jahuapachai auc Yaya ñaupacpi tiyaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ñáuca Runa Tucuc asha chingarishcacuinta tucushca runagunataga quishpichingahua shamurani. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yuyarichi. Shuc runa patsac (100) ovejata charishcamanda shuc chingaricpiga manachu chi iscun chunga iscungunata (99) urcui saquinga chi chingarishcata mascagringahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sirtumi nini, Chi mana chingarishca ovejagunamanda chi chingarishcata tupashaga yapa cushiyangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chasnallata cangunahua jahuapachaibi auc Yayaga mana munanzhu cai ichillagunamanda mana shugllahuas chingarichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Camba quiric huauqui canda mana alita racpiga paihuan sapalla cuintagrisha alichingui. Canda uyacpi paita Diospacta cuti rangahua munachishcangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Canda mana uyacpi canhuan pariu shuc ali quiric runata u ishcaita paihuagma ña alichingahua apangui. Pai ima tucushcatas rimacpi uyasha chi ishcai (2) pura quimsa (3) pura alita yachasha alichinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Randi pai cangunata mana cadsucpiga quiriccuna tandarishcai tucuita cuintangui. Chasna racpi tucui quiriccunatas pai mana cadsucpiga paita romano cullquita tandac runacuintata u jiridsata rac nishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sirtuta nini, Cai pachaibi canguna huatashcacuinta maicandas mana alichan nicpiga jahuapachai Yaya Diospas mana alichaun ningami. Chasnallata cai pachaibi canguna imatas pascashcacuinta maicandahuas ali man nicpiga jahuapachaibis ali man ningami. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chasnallata cangunata nini, maicanbas cangunamanda ishcai runaguna shuc yuyaillahuan imatas Diosta mañasha tapucpi ñuca jahuapachai tiyac Yaya canguna tapushcata cungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maibi ishcai u quimsa runapura ñuca shutihuan tandaricpi paigunahuan ñuca tiyashami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesus chasna rimacpi Pedro paima caillayasha tapura, Shuc quiric huauqui ñucata mana alita racpi masna cutinda perdunana ani, canzhis (7) cutingamachu perdunana ani. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tapucpi Jesus cutipara, Canzhis cutingamalla mana ninichu, randi cadsi pichca patsac (500) mana yupaibaccama perdunana mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Uyaichi. Diospa ali mandana shuc cullquiyuc amucuinta man. Shuc punzha chi amu paihua runaguna dihuishcagunata pagahuaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chasna nicpi shamura shuc runa ashca huaranga (10.000) cullquita dihuic. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ima paganatas mana charicpi amu chi runata rimara camba dihui pagashca tucungahua camba huarmitas churigunatas tucui charishcagunatas candahuas randichishca tucungaraunguichi, pagashca saquirichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chita uyasha chi runaga amu ñaupacpi cungurisha rugara, Ama chasna rahuaichu señor nisha, chapahuangui, ñuca ansa ansa illacta pagashcanguimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chasna rugacpi amu chi runata llaquisha saquira, pai dihuigunata illacta perdunara. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Chi runa chimanda llucshisha pariu tarabauc runahuan paita shuc patsacllata (100) dihuic runahuan tupanacura. Paihua cungamanda japisha quihuira, Can ñucata dihuishcata cunan pagahuai nisha sinzhi shimihuan caparira. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chi runa cungurisha paita rugara, Ama chasna rahuaichu, ñapa chapapangui, tucuita pagashcanguimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Randi paiga mana uyasha mana perdunarachu. Chi dihuic runata japisha carcelbi tapara paihua dihuita paganagama. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chasna tucushcata shuccuna ricusha, yapa llaquirisha, chi amuhuagma cuintagrinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chi cuintaucunata uyasha amu chi runata cayasha nira, Mana ali runachangui. Can dihuishcagunata huinda perdunasha saquirani can llaquilla rugashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Cambas manachu canda dihuicta yuyarisha yanapana arangui ñuca canda yuyarisha yanapashcacuinta. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chasna nisha amu sinzhita piñasha cai runata cachara libachinauchun nisha paihua dihuita tucuita paganagama. ");
INSERT INTO qvzNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesus chasna cuintashcahuasha nira, Chasnallata shuccuna cangunata mana ali rashcata tucui shunguhuan canguna mana perdunasha cungaricpiga ñuca jahuapachai auc Yaya cangunatas chi amu rashcacuintallata rangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus chasna cuintashcahuasha Galileamanda llucshisha rira Jordan yacu chimba partita Judea provinciama pactangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ashca runa paita catinaura, chasna acpi ungushcagunata janbira. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chibi maican fariseoguna Jesuspagma shamusha paita camangahua tapunaura, Shuc runa paihua huarmita yangamanda jichucpi alichanma nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tapucpi paigunata nira, Manachu ricuranguichi ñaupapunda runagunata rac Diosca caritas huarmitas rashcami. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dios chasna rashcamandami shuc runa paihua yayatas mamatas saquisha paihua huarmihuan llutaringa, ishcandi shuc aichalla tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dios chasna nicpi chi cari chi huarmiga mana ishcaichu, randi shuc aichallami. Chasna acpi Dios llutachishcataga chi runa ama llushpirichun. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesus chasna rimacpi chi fariseoguna cutillata ninaura, Chasna acpiga imangahuata Moises rimaraya shuc runa paihua huarmita jichuna quillcata cushaga paita jichunata ushanmi, nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tapucpi Jesus paigunata nira, Canguna sinzhi shunguyuc runaguna ashcamanda Moises chitaga rimara, randi cai pacha callarishca uraspi mana chasnachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ñáucaga caita cangunata nini: maicanbas paihua quiquin huarmi mana ashiyagllaita yangamanda jichusha shucta japishaga ashiyashcatashina ran. Chasnallata chi jichushca huarmita japic runahuas ashiyashcashina juchata ranmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chita uyasha pai japishcaguna Jesusta rimanaura, Chasna causana acpiga huarmihuan japinacunaga manachari balinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Randi Jesus paigunata nira, Chasna acpi huarmi illac causanata tucuiguna mana ushanaunzhu, Dios yanapashcallahuanmi usharin. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maican runaguna mana ushanaunzhu huarmita japinata paiguna pagarishcamanda lulun huaglishca asha, maicanguna mana ushanaunzhu lulunda surcushca asha, randi shuccunaga huarmita japinata mana munanaunzhu Diosllata catingahua nisha. Chasna ranata ushashaga chasna rachun. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Shuc punzha runaguna paiguna huahuagunata Jesuspagma apamunaura, Camba maquita paiguna jahuaibi churasha paigunamanda Diosta mañapachun nisha. Chasna ranaupi pai japishca runaguna randi paigunata piñasha jarcanata munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Piñanaupi paigunata Jesus nira, Chi huahuagunata casilla ricuichi, ñucama shamuucunata ama jarcaichichu. Diospa ali mandanaga cai huahuagunacuinta accunahuac man. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chasna nisha huahuaguna jahuaibi paihua maquita churasha Diosta mañara. Chihuasha chimanda llucshisha shuc partima rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chasnallata shuc runa Jesuspagma shamusha tapura, Can ali yachachic asha rimahuai señor, ima alita ranatani huiñai causaita charingahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chasna tapucpi Jesus randi paita tapura, Imangahuata ñucataga ali mangui nisha rimahuangui. Shugllami aliga tiyan, chiga Diosmi. Can huiñai causaima yaicusha nishaga Dios mandashcagunataga pactachina mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Randi chi runa tapura, Maican mandashcagunataya. Jesus cutipara, Ama runata huanchinguichu, shucpa huarmita ama ashiyanguichu, ama shuhuanguichu, ama shuccunamanda yanga llullasha rimanguichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Camba yayatas, camba mamatas llaquina mangui, shuccunatahuas can quiquin aichatacuinta llaquina mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chita uyasha chi runa nira, Huahua urasmandapacha tucui chigunata pactachishcani. Cunanga imata pishihuan. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tapucpi Jesus paita nira, Can Dioshuan ali tucusha nishaga can charishcagunata randichisha pugri runagunama cugri. Chasna rashaga jahuapachaibi Dios cungaraushcata charic tucunguimi. Chihuasha ñucata catihuai. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chasna rimacta uyasha chi runa llaquirisha rira, yapa ashcata charic ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Paita riushcata ricusha Jesus pai japishca runagunata nira, Shuc charic runaga Diospa ali mandanai yaicunata sinzhi man, mana yapa munanaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Shuc camello nishca jatun aicha mana ushangachu shuc abuja juctuta pasanata. Chimanda yali sinzhi man shuc charic runaga Diospa ali mandanai yaicunata. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chita uyasha pai japishca runaguna yapa manzharisha tapunaura, Chasna acpiga pita quishpinataga ushangaya. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus paigunama ricusha nira, Runagunaga paigunallata quishpirinata mana ushanaunzhu, randi Yaya Diosca tucui ranatas ushanmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chita uyasha Pedro nira, Ñáucanchiga canda catingahuaca tucuitami saquiranchi señor. Chasna racpi imatata cuitucushun. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus paigunata casna rimara, Sirtupacha cangunata nini, Dios tucuita mushugyachishca punzhai ñuca amu tucushami jatun mandac amu tiyarinaibi tiyarishami mandangahua. Chi uras cangunahuas ñucata catishcamandami, chunga ishcai (12) tiyarinagunaibi tiyaringuichimi chi chunga ishcai israel runa muntungunata taripangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Maican runas ñucata catingahua tucuita saquishaga yapa ashcata charingamiraun. Imatas ñucaraicu saquisha, huasi acpis, huauquita panita acpis, yayata mamata acpis, churigunata acpis, allpagunata acpihuas canguna ñucata quirisha catishcamanda saquishaga tucui chigunamanda shuc patsac (100) yalita cuitucunguichimi, chasnallata huiñai causaitas charinguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cunan balichishca runagunaga huasha pishi tucungaunami. Randi cunan mana balichishca runagunaga huasha mas balichishca tucungaunami. Chasnallata huasha accunaga ñaupapunda tucunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Shuc punzha Jesus cai yachachinata cuintara, Diospa ali mandanaga shuc runa paihua allpata tarabachiccuinta man. Chi runa tutamandata tarabaccunata japingahua rira paihua chagrai tarabachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Shuc tarabanata mascauc runagunata tupasha paigunahuan casna nisha tapura, shuc punzha tarabacpi pagana tuputa pagashcanguichi, alichu. Paiguna indá nicpi paihua chagrama cachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ñáa jahua indibi chasnallata shuc muntun runagunata tupara tarabanata mascauc runa shayaucunata. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Paigunatas nira ñuca chagrama richi, ali tuputa pagashcanguichimi. Chasna rimacpi chagrama rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chaupi punzhaibihuas, mas chishibihuas, shuc runagunatahuas tupasha chasnallata rimasha paihua chagrama cachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chara punzha mana tutayaugllaita shuc muntun yanga shayaucunata tupasha paigunata tapura imangahuata cai intiru punzhata mana imatas tarabasha caibi tiyaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tapucpi cutipanaura mana pi runahuas ñucanchita tarabachiunzhu ninaura. Chasna nicpi pai nira ñuca chagrama richi tarabangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ñáa tutayashcaibi pagac runata chi amu mandara runagunata cayasha pagangui, huasha shamuc runagunamanda callarisha pagangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chishita tarabangahua yaicuccunata shuc punzha tarabashca tupu cullquitaga paigunama pagara. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tutamandata tarabangahua callariccunaga chita ricusha cushihuan yuyarinaura ñucanchita astahuan mas yalita pagangami nisha. Randi chi pagac runaga paigunatahuas shuc punzha tarabashca tupullatami pagara. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cullquita japisha piñarisha amuta rimangahua rinaura casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chishita shamuccunaga shuc ura tupullata tarabanaura. Ñáucanchiga intiru punzhatami tarabaranchiya, tucui indi rupaita ahuantauranchi. Chasna tarabashahuas paiguna japishca tupullata japishcanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chi amu paiguna piñashca shimita uyasha paiguna muntunmanda shucta rimara, Ima mana alitas canda raunichu amigo. Manachu can shuc punzha tarabashca tuputa japinatas alichishcanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cambahuactaga japisha rilla, huasha shamuccunama can tupullatata cunatas munani. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Manachu ñuca charishcahuan ñuca munashcata ranataga ushani. Ñáuca llaquishcamanda ashcata cucpichu piñaringui. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Casnami ñaupa anchi niccunaga huasha tucunaunga, huasha accunaga ñaupapunda tucunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Shuc punzha Jesus Jerusalen llactama riusha paihua chunga ishcai (12) japishca runagunata isquinama cayasha nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ñáa yachanguichi Jerusalenma riunchi. Chibi ñuca Runa Tucuc acta japishca tucungarauni. Chibi israel pagri amugunama, Moises mandashcagunata yachachiccunama cushca tucungarauni. Paiguna ñucata caudsayachihuanaunga huanchinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chasna rasha mana-israel runagunahua maquima cuhuanaunga paiguna ñucata taripangahua, asingahua, libachingahua, cruspi huanchingahuas. Chasna acpihuas quimsa (3) punzhaibi causarishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeohua huarmi paihua churigunahuan shamusha Jesuspa ñaupacpi tapungahua cungurira. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chasna racpi Jesus imatata munangui nisha tapucpi nira, Can mandac amu tucushcai ñuca ishcai (2) churigunata yuyaripangui. Paigunata balichisha shucta camba ali maqui partima, shuctaga camba lluqui maqui partima tiyachipangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chasna rimacta uyasha Jesus paigunata cutipara, Canguna mana intindishcamandami chasna tapunguichi. Ñáuca jayac yacuta upishcacuinta cangunahuas ñucashina turmintarinata ushanguichichu. Chasna nicpi cutipanaura ushanchimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chita uyasha Jesus nira, Sirtumi canguna turmintaringuichimi jayac yacuta upiccuinta, randi ñuca ali maqui partima, lluqui maqui partimahuas tiyachinata mana ushanichu. Ñáuca Yaya anllashcagunallata chibi tiyarinaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chi shuc chunga pai japishca runaguna chita uyasha chi ishcai huaquigunahuan piñarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chita yachasha Jesus paigunata caillayachisha uyaichi nira, Cai pachai tiyac amuguna rashcagunata yachanguichimi. Paigunahua runagunata llaquichinaunmi, alabarishcamanda sinzhita piñasha paigunata mandanaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Cangunapura randi mana chasnachu rana anguichi, astahuan maicanbas shuccunamanda yali tucunatas munac ashaga shuccunata yanapachun. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Canguna, cangunapuramandas mandac tucusha nishaga shuc mandashca runacuinta shuccunahuacta rasha yanapana manguichi nini. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ñáuca Runa Tucuc asha mana cuirahuanauchun nisha shuc jatun mandac tucungahua mana shamuranichu, astahuanbas shuccunata cuirasha yanapangahuami shamurani. Tucuigunahua dihuita pagashcacuinta ñuca huañungahua shamurani ashca runaguna juchamanda quishpichisha lugar causaita charinauchun nisha shamurani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jerico llactamanda llucshinaupi ashca runaguna Jesusta catisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ishcai puyuñahui runaguna chi ñambi mayanbi tiyaunaura. Jesus pasaushcata uyasha paiguna caparinaura, Señor, can israel rey amu Davidmanda mirai runa asha ñucanchita yuyarisha yanapai. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chasna capariunaupi runaguna paigunata piñanaura, Chunlla tiyaichi nisha. Astahuanbas paigunaga mas caparinaura chasnallata nisha, Can rey amu Davidmanda mirai runa asha ñucanchita yuyarisha yanapai señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus chasna capariucunata uyasha shayarisha chi puyuñahuigunata tapura, Ñáuca cangunata imasata rachun nishata munanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Cutipasha ninaura, Can ñucanchi ñahuitas alichinatas munanchimi señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus paigunata llaquisha ñahuibi llangara. Chi ratullai ricungahua callarinaura. Chasna ricuc tucusha Jesusta catisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalen mayanbi pactanaushcaibi Betfagé nishca ichilla llactama, Olivos nishca urcu mayanma, Jesus ishcai (2) japishcagunata cachara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Canguna chi ñahuipura tiyac ichilla llactama richi. Chima pactasha shuc burro huatashca tiyaucta paihua malta huahuandi tupanguichimi, chigunata pascasha caima apamunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pihuas cangunata tapucpi rimaichi ñucanchi amu cai burrogunata minishtinmi, chihuasha mana unai cutichingami, nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chasnami tucura ñaupa uras Dios rimashcata pasachic runa quillcashcaga pactaringahua. Casnami quillcashca ara: ");
INSERT INTO qvzNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sion llactai causaccunama casna cuintaichi, Ricuichi nisha, canguna jatun amu shamunmi, mansu shunguyuc man, shuc burroi tiyarisha shamun, malta burro jahuaibi. Chasna Dios rimashcata pasachic runa unai ñaupa quillcara. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chasna Jesus rimashcata uyasha chi ishcai japishca runaguna rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pai rimashcashina tupasha chi burrota huahuandi apamunaura. Chi burroguna jahuai paiguna churariushca llachapata mandashcai Jesus tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pai rina ñambibi ashca runaguna paita mandac amutashina rasha paiguna churariushca llachapata allpaibi mandanaura, maicangunaga ruya ramagunata pitisha ñambii shitanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pundai riucunahuas, huasha shamuccunahuas caparinaura casna nisha, Alabashca achun rey amu Davidmanda mirai runa, Dios cachashca shamuc ashami balichishca achun. Jahuapachai auc Dios alabashca achun. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus Jerusalenma yaicucpi chi llactai causaccuna manzharisha tapunacunaura, Pitanya caiga. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chasna tapucpi chi puriu runaguna cutipanaura, Caimi Dios rimashcata pasachic runa Jesusmi, pai Galilea Nazaret llactamanda man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chihuasha Jesus Diosta alabana huasima risha chibi randisha, randichisha tiyaucunata ricusha callpachisha pagllama llucshichira. Chasnallata cullquita cambiana mesagunatahuas tangasha bulltiachira, palomata randichiucunahua mesagunatahuas tangasha bulltiachisha casna nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Diospa shimibi quillcashca an: Ñáuca huasi Dioshuan cuintana huasi nishca man. Cangunaga shuhuana huasicuintata rashcanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pai Diosta alabana huasibi tiyaushcai maican puyuñahui runaguna, mana ali puriccunahuas Jesuspagma shamunaupi paigunata janbira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Israel pagri amugunas, Moises mandashcata yachachiccunahuas Jesus Diospa ushaihuan rashcagunata ricusha piñarinaura, chasnallata huahuaguna rey amu Davidmanda mirai runa alabashca achun nisha caparishcata uyanaura. Chita uyasha piñarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Piñasha chi amuguna Jesusta tapunaura, Chi huahuaguna capariushcata uyaunguichu. Indá, uyaunimi nira. Cangunaga Diospa shimibi casna nishcata manachu ricuranguichi casna nishca: Llullu huahuagunas, chara chuchuc huahuagunahuas ali gustu cantashcahuan ñucata alabangaunami, nin. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chihuasha paigunamanda llucshisha Betania llactama rira puñungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cayandi punzha tutamanda Jerusalenma bulltiashcai Jesusta raicai japira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ñáambi mayanbi shuc higo nishca ruyata ricusha chima rira muyuta pallangahua. Randi mana imatas tupasha, chi ruyaibi pangagunalla tiyacpi chi ruyata nira, Ima uraspas cai ruya muyuta mana mas aparichun nini. Pai rimashcahuan chi ruya chaquiringahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chita ricusha pai japishca runaguna manzharisha, páiii imaraicuta cai ruyaga huairashina chaquiriun nisha Jesusta tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tapucpi Jesus cutipara, Sirtu cangunata nini, canguna mana ishcai yuyai tucusha sinzhita quirishaga ñuca higo ruyata rashcacuinta ranguichimi. Mana chillata randi yalita ushanguichimi. Canguna cai urcuta anchuri caimanda, lamar yacuibi urmagri nisha rimacpiga chi urcu cangunata uyangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Canguna Dioshuan cuintausha sinzhita quirishcahuan imata tapucpihuas cuitucunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chihuasha Jesus Diospa huasima pactasha yachachiupi israel pagri amuguna, israel rucu amugunahuas paihuagma caillayasha tapunaura casna nisha, Ima ushaihuanda chigunata rangui. Pita canda chita rachun nishaga mandara. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tapucpi Jesus paigunata nira, Ñáucas cangunata shuc tapunata tapungarauni. Canguna rimahuacpi ñucas ima ushaihuan caigunata rashcata rimasha. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Caita cangunata tapuni: pita Juanda cachara bautisangahua, Dioschu paita cachara, runagunachu paita cachanaura. Chita rimahuaichi. Chasna tapucpi paigunapura rimanacungahua callarinaura. Ñáucanchi Dios Juanda cachashca mara nisha rimacpiga ñucanchita tapunga chasna acpi imangahuata Juanda mana quiriranguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Randi paita runa cachashca man ningahua manzhanchi ñucanchita runaguna imatas ranamanda. Tucui paiguna Juanga Dios rimashcata pasachic runa mara nisha quirinaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chasna cuintanacushcahuasha Jesusta rimanaura, Mana yachanchichu. Chasna nicpi Jesus paigunata nira, Canguna mana rimacpiga ñucahuas mana rimashcanguichichu ñuca pi mandashcahuan caigunata rauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chihuasha Jesus yachachisha casna rimasha yachachira: Shuc runa ishcai (2) churita charira. Punda churita mandara casna nisha, cunan punzha chagrama rina mangui churi. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Randi paihua churiga yayata mana munanichu nira. Chasna rimashallata huasha pai yuyarisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chi runa paihua quipa churitahuas chasnallata mandara. Chasna nicpi alimi yaya, cunanllata ringarauni nira. Chasna nishallata mana rirachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesus chita cuintashcahuasha chi uyauc runagunata tapura, Ñáa chi ishcai churimanda maicanda pai yaya munashcashina pactachira. Tapucpi cutipanaura, Punda churi nisha. Jesus paigunata nira, Sirtupacha cangunata nini, gubirnuraicu cullquita tandachiuc runagunas, ashiyachisha causac huarmigunahuas, cangunamanda ñaupaga Diospa ali mandanama yaicungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bautisac Juan cangunama shamusha Dios munashcacuinta causanata yachachigllaita canguna paita mana quiriranguichichu. Randi gubirnuraicu cullquita tandachiccunas, ashiyachisha causac huarmigunahuas paita quirinaurami. Canguna chita ricushahuas juchata rashcamanda mana llaquirisha canguna causaita mana cambiaranguichichu, mana quiriranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Chihuasha Jesus casna yachachisha cai cuintashcata uyaichi nira. Shuc runaga paihua allpai chagrata rasha uva nishca muyugunata tarpura. Tarpushcahuasha chi chagrata quinzhahuan tapara. Chasnallata allpaibi juctuta allara chi uva muyugunata chahuasha upinata rangahua. Chasnallata shuc jahua ricuna huasita shayachira. Chihuasha shuc runagunama chi chagrata saquira pallana uras chaupi, chaupi pallangahua nisha. Tucuita alichishcahuasha shuc llactama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ñáa muyuta pallana uras pactaricpi paihua runagunata cachara chagrata mañachishca runagunahuagma paihua partita japingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pactanaupi chi tarabaccuna japisha shucta macanaura, shucta huanchinaura, shucta rumihuan tucsinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chihuasha amu cutillata mas ashca runagunata cachara. Chigunatas pactacpi paigunatas chasnallata ranaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Puchucaibi paihua churita cachara, ñuca churita ricusha manzhangaunachari nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Chasna agllaita chi runaguna amuhua churita ricusha cuintanacunaura, Cai man chagra amuhua churi, yaya charishcata japina acca. Paita huanchishunchi, pai japingaraushcata ñucanchi amuyashunchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chasna nisha paita japisha chi chagra huashama apasha huanchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ñáa chagra amu shamusha imatata rangaraun chi runagunata. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesus tapucpi chi uyaucuna cutipasha ninaura, Chi piñac runagunata mana cáillata libachisha huanchingami, paihua chagratas shuc runagunama saquingami. Paigunaga pallana uraspi paita ashcata chaupita cungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chihuasha Jesus paigunata nira, Chasna acpi Diospa shimibi manachu ricuranguichi: Huasita shayachiccuna mana munasha jichushca rumiga shuc mas balic rumimi tucushca. Chitaga ñucanchi jatun Dios casna rara, pai chasna rashcata ricusha manzharinchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chimandaga cangunata nini, Diospa ali mandanamanda quichushcanguichimi, chitaga Diospa munaita rauc runagunamami cushca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chi rumi jahuaibi urmac runaga paquirishca tucunga, chasnallata runa jahuaibi chi rumi urmashaga paigunata chác chác nitingami. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chi israel pagri amugunas, fariseogunahuas Jesus rimashcata uyasha, paigunamandami pai rimashcataga intindinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chiraicumi paita japishun nisha yuyarinaura, randi runagunata manzhashcamanda mana ushanaurachu, yapa ashca runaguna Jesusca Dios rimashcata pasachic acta quirishcaraicu. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus shuc cuintanata yachachingahua casna nisha cuintara, ");
INSERT INTO qvzNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Diospa ali mandanaga shuc jatun mandac runa caicuinta ricuric man. Chi runaga paihua churi cadsarana jistata rara. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ñáa tucuita alichishcahuasha paihua runagunata cachara tucui cayashcagunata micuc shamunauchun nisha rimangahua. Randi chi cayashca runagunaga mana shamunata munanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Cutillata shuccunatas cachara casna nisha, Tucui cayashca runagunata rimagrichi, ña micunatas tucuita rashcami, huira huagratas ovejagunatas huanchirani, tucuitas huin yanushcata charini, cunan ñuca churi cadsarana jistama gustangahua shamuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Chasna rimagllaita chi cayashca runagunaga mana uyanaurachu. Maicangunaga chagrama rinaura, maicangunaga paiguna tarabanama rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Maicangunaga amu cachashca runagunata japisha paigunata piñasha sagmasha huanchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ñáa chita amu uyasha yapa mana cáillata piñarira, paihua sundalugunata cachara chi piñac runagunatas huanchigrichi, paiguna llactatas rupachigrichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chihuasha paihua runagunata nira, Cadsarana jista micuna ña yanushca man, randi chi cayashcaguna mana balicchanaun caibi angahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cunan ñambita richi, tucui chibi tupashca runagunata pushamuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chasna nishcata uyasha tucui tupashca runagunata apamunaura, ali runagunatas chasnallata mana ali runagunatahuas. Chasna apamucpi chi jista micuna huasi jundarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Chihuasha amu chi shamushcagunata saludangahua yaicusha, shuc runata ricura cadsarana jista churarina illac aucta. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ricusha paita tapura, Imangahuata cadsaranaraicu shuc cushca llachapata mana churarisha yaicurangui alá. Chasna tapucpi chunlla tucusha shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mana imatahuas rimanata ushacpi chi amu paihua runagunata mandara, Cai runata paihua chaquitas maquitas huatasha canzhama shitaichi mana cáilla ansa ucuma. Chibi huacanas tucui tunu sinzhi nanai tiyashcama tucsigrichi nisha mandara. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ashca runaguna cayashca manaun, astahuanbas ashilla runaguna anllashca tucunaunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesus chasna yachachiuta uyasha fariseoguna rinaura paigunapura cuintanacungahua imasna nishata Jesusta pandachishun japingahuaca nisha ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chasna yuyaricpi paiguna quiquin japishca runagunatas, mandac amu Herodespa runagunatahuas Jesuspagma cachanaura paita tapungahua casna nisha, Can sirtu rimac ashcata yachanchi señor. Pitas mana manzhasha Dios munashcashina causana partimanda yachachingui. Tucui runagunata pariu chi tupullata yuyaringui. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chasna acpi canda tapunchi, Ñáucanchita mandauc romano gubirnu mandashca cullquitaga paima paganata balinzhu, manachu balin. Imatata ningui. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chasna tapucpi Jesus paiguna mana ali yuyaihuan tapucta yachasha paigunata nira, Llullaccuna, imangahuata camasha ñucata pandachisha nihuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gubirnuma pagana cullquita ricuchihuaichi, nisha mandacpi shuc cullquita apamusha ricuchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chita apamucpi Jesus paigunata tapura, Pihuactan chibi auc ñahuiga, chibi quillcashca shutihuas pihuactan. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tapucpi cutipanaura, Romano jatun mandac amuhuac. Chasna nicpi Jesus nira, Amuhuacta amuma cuichi, Diospactaga Diosma cuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Paiguna Jesus chasna rimashcata uyasha manzharisha Jesusta saquisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chi punzhallaita israel muntunmanda maican saduceoguna Jesushuan cuintanacungahua shamunaura. Paigunaga huañushcahuasha cuti causarinaga mana tiyanzhu nic manaura. Chasna acpi Jesusta casna rimanaura, ");
INSERT INTO qvzNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Señor, Moisesmi ñaupa uras casna nira: Punda huauqui shuc huarmita japisha huahua illac huañucpi paimanda quipa huauquiga chi huaccha huarmihuan japinacunauchun nisha. Paiguna tupashca huahuata chi punda huañuc huauquihua allpa ima chingarichun nisha paihua shutita churanaunchun. Chasna Moises mandashcami. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Cunan ñucanchi cuintangaraushcata alita uyasha rimai. Ñáucanchihuacpi canzhis (7) huauquipura causanaura. Punda huauqui shuc huarmita japira, randi huasha, huahua illac huañura. Huahua illac huañucpi, paihua quipa huauqui chi huaccha huarmihuan japinacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ñáa paihuas huahua illac huañura. Tucui chi canzhis huauquipura chi huaccha huarmillata japishahuas huahuas illac huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chi tucuiguna huañushcahuasha huarmihuas huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ñáa causarina punzhaiga chi huarmiga pihua huarmitanga, canzhis huauquipura paihuan japishca acpi. Chasna tucucpimi huañushcaguna mana cuti causaringaraushcataga ricuchin ninaura. Chasna tapusha Jesusta pandachinata munasha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus chita uyasha casna cutipasha rimara, Canguna pandaunguichimi Moises quillcashcagunata mana alita yachasha, Diospa ushaitas mana ricsisha pandaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Huañushcaguna causarishcahuasha carigunas huarmigunas mana japinacunaungachu, jahuapachaibi tiyac angelguna caushcacuinta tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Huañushcaguna causarinamanda quiquin Dios rimashcataga manachu ricushcanguichi casna nishcata: ");
INSERT INTO qvzNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ñáuca Abrahanba, Isaacpa, Jacobopa Dios mani. Dios chasna nicpi pai mana huañushcagunahua Dioschan, astahuanbas causaccunahua Dios man. Chasna acpi Abrahan, Isaac, Jacobopas causaucuna ashcata ricuchinmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tucui runaguna Jesus chasna yachachishcata uyasha manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesus chasna yuyaihuan yachachicpi saduceoguna pingarisha chunlla tucunaura. Chasna tucushcata uyasha fariseoguna tandarisha, Jesuspagma shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Paigunamanda shucca Moises mandashcagunata yachachic acca Jesusta pandachisha nisha camasha tapura, ");
INSERT INTO qvzNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Dios mandashcagunamanda maicanda mas yali balic an señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tapucpi cutipara: Camba amu Diosta tucui camba shunguhuan, tucui camba almahuan, tucui camba yuyaihuan llaquina mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chimi punda mas balic mandashca shimi an. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chimandahuasha chi cuintallata man casna nisha: Camba quiquin aichata llaquishcacuintallata shuccunatahuas llaquina mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dios tucui mandashcagunai, tucui pai rimashcata pasachiccuna rimashcai chi ishcai shimimandami rimashca tiyan. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseoguna chara tandarishca anaupi Jesus paigunata tapura, ");
INSERT INTO qvzNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Imasata yuyaringuichi quishpichic Cristomanda. Pimanda mirai runatan. Tapucpi cutipanaura casna nisha, Israelgunata mandac rey amu Davidmanda mirai man. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Rimanaupi paigunata tapura, Imasata israelgunata mandac rey amu Davidga Diospa Samai paita yuyachicpi, quispichic Cristotaga ñucata mandac, señor mangui nisha rimara. Davidllatami casna quillcasha saquira: ");
INSERT INTO qvzNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jatun amu Diosca ñucata mandactami rimara casna nisha, Ñáuca ali maqui partima tiyari ñuca tucui canda piñaccunatas binsinagama. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Huañuc Davidllata Cristota amu nisha rimacpiga imasata Cristoga Davidba miraimanda churi angaya. ");
INSERT INTO qvzNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tapucpi pihuas paita cutipanata mana ushanaurachu. Chasna acpi chi punzhamandapacha Jesusta pandachingahua imatas tapunatas saquinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesus tucui pai japishca runagunata chibi auc runagunatas yachachisha casna nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Diospa shimita yachachiccunas fariseogunandi Moises mandashcagunata yachachiccuna anaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tucui paiguna yachachishcataga pactachichi, astahuanbas paiguna rashcacuinta ama raichichu. Paigunaga rimaisiqui maunguna, randi quiquin rimaushcatas mana pactachinaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paiguna yapa mandasha, mana marcaibaccunata runahua rigraibi churashcacuinta ranaun, randi paiguna shuc riruhuallanbas mana yanapanaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tucui runaguna ricuhuanauchun nishalla chasna rasha causanaun. Chasna yuyarisha Dios mandashca quillcata jurintibis maquibihuas churarisha puriunaun. Paiguna churarina capa pundagunatas anzhuyachinaun. Tucui chigunata ranaun runaguna paigunata balichihuanachun nishalla. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Paigunata micungahua cayanaupi punda mas balic tiyarinata mascanaun, chasnallata ranaun israel tandarina huasigunais. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Balichishca tucunatas munasha pagllai saludaitucunatas munanaun, chasnallata ali yachachic nishca tucunata munanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Canguna ama yachachic nishca tucuichichu, ñucallami cangunata yachachic amu ani, tucui cangunaga huauquipuralla manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cai pachai ama pitahuas cangunapura yaya nisha ninguichichu, jahuapachai auc Yaya Diosllami canguna Yayaga an. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chasnallata ama mandac amu nishca tucuichichu, ñucami Cristo nishca Dios anllashca runaga cangunahua amu ani. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Cangunapuramanda sirtu balic runaga tucui cangunata sirbic tucuna man. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Maicanbas paillata baliricpiga Diosca paita pishita rangami. Maicanbas quiquinllata pishiyachiricpiga Diosca paita balichingami. Jesus chasna paita caticcunata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Israel balichishca runagunata Jesus casna nisha rimara, Fariseogunas Diospa shimita yachachiccunas, canguna yapa llaquitucungaraunguichi. Llullaguna anguichi. Canguna shuc punguta tapashcacuinta shuccuna Diospa ali mandanama ama yaicunauchun nisha raunguichi. Cangunaga mana yaicunguichichu, chasnallata yaicushun niccunatas mana lugarta cunguichi paigunas yaicungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Fariseogunas Diospa shimita yachachiccunas, canguna yapa llaquitucungaraunguichi. Llullaguna anguichi. Runaguna balichihuanauchun nisha paigunahuacpi Diosta alabana huasibi yapa mañauc runa ashallata huaccha huarmigunata yanapasha nisha llullasha paigunahua allpata quichunguichi. Chasnamandami mas sinzhita taripashca tucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Fariseogunas Diospa shimita yachachiccunas, yapa llaquitucungaraunguichi. Llullaguna anguichi. Tucui partigunaibihuas puringuichi shuc runallatas canguna partita rangahua nisha. Pai canguna camachishcata quirishaga ucupachama cangunamandas mas taripashca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ai, yapa llaqui tucungaraunguichi. Canguna puyuñahuiyuc pushaccuinta anguichi. Canguna casna nisha yachachinguichi, maican runa Diospa huasita japisha rimashca shimita mana pactachicpiga mana imaschan, randi Diospa huasi ucuibi tiyac curi rimashca shimitaga pactachina man nisha yachachinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ima mudu cuintatanguichi, puyuñahuicuintachanguichi. Curiga Diospa huasitas mas yali balicchan. Mana. Chi curiga Diospa huasibi churashcamandami mas balic tucushca. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chasnallata ninguichi, maican runahuas aichata rupachina mesa nishcata rimasha paihua shimita mana pactachicpiga mana imaschan, randi jahuaibi churashca aichata rimashca shimitaga pactachina man ninguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ima mudutanguichi, puyuñahuishina changuichi. Aichaga chi rupachina mesatas mas yali balicchan. Mana. Chi aichaga rupachina mesai churashcamandami balic tucushca. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Rupachina mesa nishcata rimac runaga chi mesatas chasnallata tucui chi jahuaibi churashca tiyaccunatahuas riman. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Diospa huasi nishcata rimac runaga mana huasimandallachu riman, astahuanbas chi huasi ucuibi tiyauc Yaya Diospa shutitas japisha riman. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chasnallata jahuapacha nishcata rimac runaga Diospa tiyarinatas, chasnallatas quiquin Diospa shutitahuas riman. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Fariseogunas Moises mandashcata yachachiccunas, canguna yapa llaqui tucungaraunguichi. Llullaccuna anguichi. Canguna tucui charishcagunata chunga (10) partita chaupisha shuc partita Diosma cunguichi, menta nishca, anis nishca, comino nishca muyugunataga. Chasna agllaita Diospa shimibi mas balic mandashcagunataga mana cadsunguichichu. Chigunami anaun alita rasha causana, yuyarisha yanapana, Diospacta rasha causanas. Caigunatami sirtu pactachina anguichi, chi shuccunatas mana saquisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Puyuñahuiyuc pushaccuinta anguichi. Asuaibi auc ichilla basurataga anchuchinguichi, randi jatun basurataga nillpunguichillami. Ichilla juchata ranata mana munasha yapa ripararic anguichi, randi jatun juchataga rac aunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Fariseogunas Diospa shimita yachachiccunas, canguna yapa llaqui tucungaraunguichi. Llullaguna anguichi. Pulatu jahuallatas pillchi jahuallatas maillashcacuinta puriunguichi, randi ucuma chara turuyuccuinta anguichi, shuhuana yuyaihuan, charic tucuna yuyaitas charisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Puyuñahuiyuccuinta anguichi fariseoguna. Ñáaupapunda pulatu ucutas pillchi ucutas maillashcacuinta cangunahua shungutaga alichina manguichi. Chasna racpimi tucuilla maillashcacuinta saquiringa ucutas jahuatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Fariseogunas Diospa shimita yachachiccunas, canguna yapa llaqui tucungaraunguichi. Llullaguna anguichi. Huañushcata pambashcaguna jahuai ruyaglla armachicpi gustu ricurinmi astahuanbas ucuma huañucpa tullugunas tucui tunu ismushcagunas tiyan. Chasnacuinta manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cangunaga ruyagyachishcacuinta jahua caralla ali ricuringuichi. Runagunahuacpi Dios munashcata rac runacuinta purisha randi shungu ucuma ima llullanahuas juchata rana yuyaihuanbas jundashca anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Fariseogunas Diospa shimita yachachiccunahuas, yapa llaquitucungaraunguichi. Llullaguna anguichi. Alicuinta ricurisha nishalla Dios rimashcata pasachic runaguna huañushcata pambashcagunai huasigunata ranguichi, chasnallata Diospacpi ali puric runagunata pambashcagunai ima tunu gustugunatas churanguichi casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ñáucanchi apayayaguna causashca uras ñucanchi causashca ashaga paigunata mana yanapanchimachara chi Dios rimashcata pasachic runagunata huanchingahuaca, nisha rimanguichi fariseoguna. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chasna rimashcamandami cangunahuas chi Dios rimashcata pasachic runagunata huanchic runagunahua miraiguna aushcata ricuchinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chasna acpi canguna huañuc apayayaguna causashcashina raichilla. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Canguna huanchic palugunacuinta ashcamandami imasna rashata ucupacha rinata quishpinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chimandami cangunahuagma Dios rimashcata pasachic runagunata cachangarauni, Diospa yuyaita chariccunatas, Diospa shimita yachachiccunatas. Maicangunataga huanchingaraunguichi, maicangunata cruspi quilabasha huanchingaraunguichi. Maicangunata israel tandarina huasigunaibi libachingaraunguichi, shuc llactamanda shuc llactamas turmintachisha callpachingaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chasna rashcamandami Diospacpi ali puric runagunataga tucuita huanchishcamanda cangunallata caudsayuc tucunguichimi. Chi Diospacpi ali puric Abelta huanchishca urasmandapacha, Berequiaspa churi Zacariasta huanchishca urascama culpayuc anguichi. Chi Zacariasta Diospa huasi pungüibi tiyac aichata rupachina mesa mayanbi canguna apayayaguna huanchishcamanda cangunahuas caudsayuc anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sirtu cangunata nini, tucui cunan causaccuna chasna culpayachishca tucungaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Uyaichi Jerusalenbi causaccuna, Dios rimashcata pasachic runagunata huanchiranguichi, pai cachashca runagunatas rumihuan tucsiranguichi. Shuc atalla paihua huahuagunata paihua rigra ucuibi ugllashcacuinta ñuca cangunataga ashca cutin quishpichinata munashcani piru chasna agllaita mana munaranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chasna mana munashcamandami canguna huasi jichushcacuintami Dios cunan cangunata saquishca. Chasna acpimi canguna llacta jichushca saquiringa. ");
INSERT INTO qvzNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cangunata nini, Dios cachashca shamuc runaga balichishca man nishami canguna chasna rimana urascama ñucataga mana cuti ricuhuanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus Diosta alabana huasimanda llucshisha riushcai pai japishcaguna ninaura, Diosta alabana huasi pambai auc huasiguna yapa gustu acta ricunguichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chasna ninaupi paigunata randi nira, Cai tucuita canguna manzharishachu ricunguichi. Sirtuta cangunata nini, cai rumigunaga mana shuc rumihua jahuai saquiringachu. Illacta tularishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chasna rimashcahuasha Olivos nishca urcuma rinaura. Jesus chibi tiyaricpi pai japishcaguna paihuagma caillayasha paillata tapunaura, Ima urasta chiga tucunga can ñucanchita rimashcaga. Ima tunuta ricuringaraun cai pacha tucuriushcai, can shamuna uras pactariupiga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tapunaupi Jesus cutipara, Cuirarisha causaichi ima pihuas umachitucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ashca runaguna ñuca shutita japisha shamungaunami ñuca quishpichic Cristo mani nisha. Chasna ninaupi ashca runagunata umachishca tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Guerami tiyan nisha, shucpihuas tiyangami nishcahuas uyaringami. Chasna uyaricpihuas ima manzharinguichichu. Chiguna tucuna manaun nisha. Chasna agllaita tucurina urasca chara mana pactarimungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Shuc llacta shughuan piñanacungaunami, chasnallata shuc partimanda runaguna shuccunahuan macanacungaunami. Ashca partigunaibi llaqui ungüigunas, raicaigunas, allpa cuyunagunas tiyangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tucui chi turmintarinagunaga chara punda callarigllami anaunga, shuc huarmi pagarichingahua nanai callarishcacuintami anga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Turmintachinauchun nisha japitucunguichimi maicandas cangunamanda huanchingaunami, canguna ñucata quiric ashcamanda tucui runaguna cangunata piñanaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chi punzhagunaibiga ashca runaguna ñucata quirishcata saquingaunami, runapura piñanacungaunami, umachinacungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ashca llullaisiquiguna llucshiringaunami Diospa partimanda rimac anchi nisha. Chasna nisha ashca runagunatami pandachinaunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mana alita ranaguna chi uras tucucpiga ñaupashina llaquinacusha causanaga mana tiyangachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Chasna agllaita mana saquisha Diosta quirisha causac runagunaga quishpishca tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Diospa ali mandanamanda cuintasha paimi quishpichinata munan nishami tucui mundui chi cushi shimita camachishca tucungami tucui runaguna chita uyanauchun nisha, chihuasha cai pacha tucurina uras pactarimungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ñáaupa uras Dios rimashcata pasachic Daniel quillcashcata ricuccuna yuyarichi. Puchucai punzha shuc umasha pandachic runa Diosta alabana huasibi jiridsata ranga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chita ricusha Judeaibi auccunaga urcugunama miticunauchun. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huasi jahuaibi auccunaga ima uraicusha huasi ucuma yaicunauchun imatahuas apangahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chagraibi auccunaga huasima ima bulltianauchun churarinata apangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ai, pugri huicsayuc huarmigunas, chuchuchic huarmigunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diosta tapuichi chi miticuna urasca ima tamia punzha tucuchun, ima samana punzhas tucuchun nisha mañasha tapuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chi punzhagunaga yapa llaqui punzhagunami anaunga. Chicuinta llaquiga cai pacha callarishcamanda cunangama mana tiyarachu, mana ima uraspas chicuinta cuti tiyangachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dios chi punzhagunata mana pishiyachicpiga mana pihuas quishpishca tucunma. Astahuanbas Yaya Dios anllashca runagunata llaquishcamanda chi punzhagunata pishiyachingami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chi uras maican runahuas cangunata ningauna, ricuichi, caibimi quishpichic Cristo aun, shuccunaga Cristo chibi maun. Chasna nicpias paigunata ama quiringuichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi punzhagunaibiga Cristo mani nisha niucunahuas ricuringaunami, Dios rimashcata pasachic mani nic runagunahuas llullac tiyangunami. Pihuas mana raushcagunata rasha manzhanayactagunata ricuchingaunami. Chasna rasha Dios anllashca runataga umachishallata mana ushanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chi uras canguna ñucata ima saquichun nisha ñuca cangunata ñaupata cuintauni canguna yachangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chimanda paiguna cangunata ninaupihuas, jacuichi Cristota ricugrishunchi pai paglla pambai maun nisha nicpias ima chima ricugringuichichu. Chasnallata cai huasi ucuibi maun ninaupihuas, paigunata ima uyanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ñáuca shamunaga shuc rayu dilampashcacuinta angami. Chiga indi llucshina partimanda indi yaicuna partigama tucuibi punzhaglla ricuringami. Chicuintallatami ñuca shamuna tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ismushca aicha aushcaibi ullahuangaguna yachashami tandarinaunga. Ñáucata caticcuna ñuca shamunata chasnallatami yachanaunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Chi llaqui punzhaguna pasashcahuashalla indis quillahuas ansayanaungami, estrellasguna urmangaunami, intiru jahua cuyuchishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chasna tucucpimi Dios manzhanayacta jahuaibi ricuchingami tucui runaguna ñuca Runa Tucuc ña shamucta ricungaunami. Ñáuca puyu jahuaibi sumac asha sinzhi ushaihuan shamuuctaga ricuhuanaungami. Chita ricusha tucui mundui tiyaccuna manzharisha huacangahua callarinaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ñáuca angelgunata cachashami curmitata sinzhita tucashcahuan mundu pundamanda pundagama tucui partigunamanda ñuca anllashca runagunata tandachinguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Higo nishca ruya tucushcata yuyarichi, paihua pangaguna llulluyaupi verano uras pactarimunmi nisha ninguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chishinallata ñuca cunan cuintashca pactaricta ricusha, ña tucurina punzha pactarimucta yachanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sirtuta cangunata nini, Chita ricuc runaguna chara mana huañugllaita ñuca tucui chi llaquigunamanda rimashcaga pactaringami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cai munduhuas cielohuas tucuringami, randi ñuca rimashca shimiga mana ima uraspas chingaringachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ima punzhas ima uraspas chi tucunata mana pihuas yachanzhu, angelgunahuas mana yachanaunzhu, Diospa Churihuas mana yachanichu. Yaya Diosllami chitaga yachan. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yuyarichi. Ñáuca shamuna punzhaibi Noe causashca punzhacuinta tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chi punzhagunaibi ashca tamia urmashca punzhagama runaguna micuunaura, upiunaura, japinacunaura. Noe jatun barcoibi yaicuna punzhagamami chasna causanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Cungaimanda runaguna mana yachashcaibi ashca yacu shamusha tucuigunatas apara. Chicuintallata ñuca Runa Tucuc asha ñuca shamuna punzhaga cungaimanda tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chi punzhaibi ishcai (2) runa chagraibi ausha shucca apashca tucunga, shucca saquishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ishcai huarmi cutana rumihuan trigo muyugunata cutausha shucca apaitucunga, shucca saquishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chasna tucungaraupi cangunata mandac shamuna punzhata canguna mana yachashcamanda yuyarishalla causasha chapaichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Runa mana yachanzhu shuc shuhuac runa paihua huasima shamungarauta. Yachashca ashaga chi huasiyuc amu chapanmara chi shuhuac runa ima paihua huasima yaicuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chasna acpi cangunahuas chapaichi, ñuca Runa Tucucca shamungarauni canguna mana yachashca uras. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Shuc amuga shuc ali yuyaiyuc runata japisha churara tucui ñucata sirbiccunata alita carangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chi amu bulltiamushcai chi runa paihua amu munashcata pactachiushcata tupaitucushaga cushiyangami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sirtu cangunata nini, pai chasna pactachicpi chi amu tucui paihua charishcagunata chi runama saquingami chigunata cuirachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Randi chi runa mana ali runa ac ashaga, paihua shungu ucui ñuca amu unayangami nisha, chi shuc tarabac carigunatas huarmigunatahuas libachingahua callarira. Chasnallata micushalla, upiccunahuan machashalla causara. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ñáa pai mana yachashca punzhaibi, pai mana yuyariushca uraspi paihua amu shamusha pactamungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chasnai pactamusha chi mana alita rauc runata sinzhita libachinga, llulla runaguna llaqui aushcama cachanga. Chibiga tucui runaguna huacanaungami quirutas canirinaunga yapa nanarishcamanda nisha Jesus puchucai punzhagunamanda cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus casna yachachisha catira, Diospa ali mandanama yaicuna runaguna shuc cadsarana jistama rinacuinta manaun, casna. Chunga (10) sultira huarmiguna bilagunata apasha rinaura chi huarmita japiuc runata cumpañangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chi chunga huarmigunamanda pichcaga (5) yuyaiyuc manaura, chasnallata pichcagunaga yuyai illac manaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chi yuyai illaccunaga bilallata apanaura, sindina yacuta cungarisha saquishca anaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Randi chi yuyaiyuccunaga bila sindina yacutahuas apasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ñáa chi huarmita japiuc runa unayacpi tucui chi huarmiguna yapa puñunayacpi puñushca anaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chaupi tutaibi shuc ricuc runa sinzhita caparira, Huarmita japiuc runaga ña shamuunmi, paita tupasha cumpañangahua shamuichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chi shimita uyasha tucui chi huarmiguna niccharisha bilagunata japichingahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chi yuyai illac huarmigunaga chi shuccunata huacasha mañanaura, ñucanchi bilaguna huañunmi, ashilla bila yacuta ñucanchima cuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chasna mañacpi chi yuyaiyuc huarmiguna paigunata randi ninaura, ñucanchi apamushca bila yacuga mana pactangachu cangunaraicuhuas ñucanchiraicuhuas. Cangunaga tiendama randigrichi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Paiguna tiendama riushcai cadsarana runa pactamura. Chasna pai pactamucpi chi yuyaiyuc huarmiguna paihuan pariu huasima yaicunaura bura jistaibi micunata micungahua. Yaicushcahuasha amu punguta tapara. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ñáa chi yuyai illac huarmiguna chi jista huasima huasha pactamusha cayanaura, ña shamushcanchi, punguta pascaichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Capariunaupihuas chi runa paigunata cutipara, Cangunata mana ricsinichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesus chi yachachinata cuintashcahuasha tucui uyaucunata rimara, Chita yuyarisha causaichi. Ñáuca shamuna punzhata mana pihuas yachangachu. Chasna acpi ñucata chapasha causaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesus mas yachachira casna nisha, Diospa ali mandanaga amuyuc runagunacuinta an. Chi amu caruma ringarausha paihuacpi tarabaccunata cayasha, pai charishcagunata caranma saquira cuiranauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Shugma pichca huaranga (5.000) cullquita cura, shugma ishcai huaranga (2.000) cullquita, shugmaga shuc huarangallata (1.000). Caran runa ranata ushaibac tuputa cura, chasna cushcahuasha caru llactama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chi pichca huarangata japic runaga chi cullquihuan randichinata churara, chasna randichisha chunga huaranga (10.000) masta tupara. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chi ishcai huarangata japic runaga chasnallata rara, pai randichisha chuscu huarangata (4.000) masta ganara. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Randi shuc huarangata (1.000) japic runaga allpata allasha amu cushca cullquita pacara. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ñáa unaima chi amu bulltiamura. Bulltiamusha tucui chi paihuacpi tarabac runaguna chi pai cushca cullquita imasashi ranaura nisha yachangahua munara. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pichca huarangata (5.000) japic runaga punda shamusha pai mirachishca chunga huarangata ricuchisha casna nira, pichca huaranga cullquitaga cuhuarangui amu, chihuan shuc pichca huarangata ganarani. Caibi aun camba chunga huaranga (10.000) cullquiga. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nicpi paihua amu paita nira, alimi, can ali yuyaihuan rac angui. Ashillahuan alita rarangui, chimanda canda cunan ashcata cushcangui. Caibi ñucahuan saquiri cushiyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chihuasha chi ishcai huaranga (2.000) cullquita japic runaga shamusha nira, can ishcai huarangata cusha saquihuarangui amu, chihuan ña ishcai huaranga masta ganashcani. Caibi aun camba chuscu huaranga (4.000) cullqui. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nicpi amu paitas nira, alimi, cambas ali yuyaihuan rac angui. Ashillahuan alita rashcangui, chimanda candahuas ashcata cushcangui. Cunan caibi ñucahuan saquiri cushiyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Puchucaibi chi huarangallata (1.000) japic runa shamusha nira, can piña runa acta yacharani, can mana tarpushcata pallashcataga japisha ganangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chiraicumanda canda manzhasha allpata allasha juctu ucuibi can cushca cullquita pacarani. Caibi aun camba cullqui, amu. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pai chasna rimacpi chi amu nira, mana balic quilla runa mangui. Sirtupacha yachanguichu ñuca mana tarpushallata pallac actaga. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chasna yachashcamandami ñuca cullquitaga bancoibi churana arangui. Can chasna churashca acpiga ñuca shamushcaibi ñucata cuhuanguima ara chi cullqui bancoi ganashcandi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Rimashcahuasha chi amu shuccunatas mandara, cunanga chi cullquita paimanda quichusha chi chunga huarangata (10.000) chariu runama cuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Charic runagunaga mas ashcata charinaungami, randi mana charic runagunaga paiguna charishcatahuas quichuitucunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chi mana balic quilla runata japisha canzhama tucsichi ansa ucuma. Tucui chibimi yapa llaqui quiru canirinahuas tiyanga. Chasna cuintasha Jesus chi runagunata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus mas rimasha catira, Runa Tucuc jatun amu tucusha ñuca angelgunahuan pariu shamushami, ñuca gustu tiyarinaibi tiyarishami. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ñáuca ñaupacpi tucui runaguna tandaringaunami. Chasna tandaricpi tucuigunata chican chican rashami shuc ovejata cuirac runa paihua ovejagunataga chibogunamanda japishcacuinta. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chi ovejata cuirac runacuinta ñucahuan ali tucushca runagunata ñuca ali maqui partima churashami, randi ñucahuan mana ali tucushca runagunata ñuca lluqui maqui partima churashami. Ñáuca Runa Tucuc agasha tucui runagunata chasnallatami rasha. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chihuasha ñuca jatun amu asha ñuca ali maqui partibi tiyaccunata rimasha, ñuca Yaya llaquishcaguna anguichi, cunanga shamuichi, callari urasmandapacha ñuca llactata alichishca man canguna tiyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ñáuca raicasha aushcai carahuashcanguichi, ñuca upinayasha aushcai upichihuashcanguichi, ñuca huasi illac aushcaibi canguna huasibi puñuchihuashcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ñáuca churarina llachapa pishishcaibi cuhuashcanguichi, ñuca ungushca aushcaibi ricungahua shamuranguichi, ñuca carcelbi aushcaibi ñucata ricungahua shamuranguichi. Chasna rashcamandami cunan ñuca yayahuagma shamuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Chita uyasha chi ali runaguna cutipasha ninaunga, ima urasta can raicaushcata upinayaushcatas ricushaga canda cararanchi upichiranchi señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ima urasta can huasi illac aucta ricusha ñucanchi huasibi canda puñuchiranchi, can churarina pishicta ricusha churarinata canma curanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ima urasta cambagma shamuranchi can ungushcata ricungahua chasnallata can carcelbi auctas ricungahua señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tapucpi jatun amu paigunata cutipanga, cangunata sirtuta nini, canguna ñucata uyac runagunatas chasna alita rashaga ñucatami alita ranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chihuasha paihua lluqui maqui partibi tiyaccunata rimanga, mana alita rac runaguna manguichi, chasna acpi ñucamanda anchurichi. Supaihuan pariu, paihua angelgunandi mana ima uraspas tucuribac rashca ninama shitashca tucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ñáuca raicaushcaibi canguna mana carahuaranguichichu, ñuca upinayasha raushcaibihuas canguna mana upichihuaranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ñáuca huasi illac ashcaibihuas canguna huasibi mana puñuchihuaranguichichu, ñuca ungushca aushcaibihuas chasnallata carcelbi tiyashcaibihuas canguna ñucata mana ricuc shamuhuaranguichichu. Ñáuca churarina pishicpihuas churarinatas mana cuhuaranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Amu chasna nicpi paigunahuas paita tapunaunga casna nisha, Ima urasta ricushcanchi can raicaushcata, upinayaushcatas, churarina illac aushcatas. Ima urasta ricushcanchi can ungushcata, carcelbi tiyaushcata señor. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chi jatun amu paigunata cutipanga, sirtuta cangunata nini, Canguna ñuca runagunata mana chasna alita rasha yanapashaga ñucataga mana alita raranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chasna chi mana yanapaccunaga mana ima uras tucuribac ninaibi causanaungami. Astahuanbas chi alita rasha yanapauc runagunaga Diospacpi huiñai causaita charingaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus tucui chita rimashcahuasha paita catiu runagunata nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Pascua nishca jista punzha pactanata ishcai (2) punzhalla pishishcata yachanguichi. Chi uraspi japihuangaraunguna cruspi huanchingahua ñuca Runa Tucuc ashcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chi urasllai Caifas nishca israelgunahua pagri jatun amu huasibi pagrigunahuas israelgunata mandac rucugunahuas tandarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chasna tandarishcai cuintanacunaura imasna rashashi Jesusta umachisha huanchingahua japinchima nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Chasna yuyarishallata jista punzhagunai ama chasna rashunchichu ninaura, ñucanchita runaguna piñaitucunchima nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Shuc punzha Jesus Betania nishca llactai tiyaura, Simon nishca leprata janbishca runahua huasibi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chibi aushcai shuc huarmi shamura yapa balic gusto asnac yacu butita apamusha. Jesus micuusha tiyaushcai chi huarmi chi asnac yacuta Jesuspa umaibi talira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesus japishca runaguna chasna talicta ricusha piñarisha rimanacungahua callarinaura, Imahuata chasna yanga talin chi yapa balic asnac yacuta. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chitaga randichishca ashaga ashca cullquita llucshichinma ara pugri runagunata cusha yanapangahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Rimacta yachasha Jesus paigunata nira, Imamandata cai huarmita piñanguichi. Pai chasna rashcaga ñucaraicu ali man. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pugri runagunaga cangunahuan tucui uras tiyangaraunguna randi ñucaga mana unaita cangunahuan tiyashachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cai huarmiga ñuca aichai chi ali asnac yacuhuan talishcamanda ñuca pambarishca tucunata ricuchin. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sirtupacha cangunata nini, Tucui partibi Diospa quishpina shimita camachiusha cai huarmi rashcatas cuintacpi pai yuyarishca anga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chihuashami chi chunga ishcai (12) japishca runaguna shucca, Judas Iscariote nishca, israel pagri amugunahuagma risha rimara, ");
INSERT INTO qvzNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Masnatata cuhuanguichi ñuca Jesusta cangunama cucpiga. Chita uyasha, Quimsa chunga (30) cullquita canma cushun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chasna alichishcahuasha paiga ima uraspas ali anma Jesusta japicpiga nisha yuyariura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ñáa chi jista punzhagunai mana putasyachishca panda micuna punda punzhaiga Jesus japishca runaguna paihuagma risha tapunaura, Maibita pascua jista micunata munangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tapucpi cutipara Jerusalen llactama risha chibi shuc runahua huasima pactasha casna rimanguichi, ñucanchita yachachic casna ninmi ñuca huañuna uras ña pactauunmi, chasna acpi camba huasibi pascua nishcata yuyarisha micungarauni ñuca japishca runagunandi nisha rimagrichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chasna nicpi pai japishca runaguna Jesus rimashcata pactachisha chi pascua micunata alichingahua rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ñáa indi yaicushcai Jesus paihua chunga ishcai runandi micungahua shamura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Paiguna micuushcaibi paigunata nira, Sirtupacha cangunata nini shucca canguna muntunmandami japichihuangaraun. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chita uyasha yapa llaquirisha paita caran shuc tapungahua callarinaura, Ñáucachani nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tapucpi nira, Ñáuca pulatumanda micucca ñucata japichichihuangaraun. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dios cachashca Runa Tucuc acpi huanchitucuhuanga Diospa shimibi quillcashcacuinta. Ñáucata japichichic runaga ai tucunga, pai mana pagarishca ashaga paihuacpi ali chari anmara. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chasna rimacta uyasha Jesusta japichingarauc runa Judasca paita tapura, Ñáucachani señor. Jesus paita cutipara, Indá can nishcacuintami angaraun. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Paiguna micuushcai Jesus shuc panda japisha Diosta pagrachu nisha paquisha pai japishca runagunama cura, Micuichi nisha, caiga ñuca aicha man. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chihuasha shuc basuta japisha Diosta pagrachu nira. Chita pai japishca runagunama cushcai paigunata nira, ");
INSERT INTO qvzNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cai pillchimanda tucui canguna upichi. Caiga ñuca rahuaimi, Yaya Dios paihua runagunahuan mushuc pactachina shimita ricuchiu rahuaimi. Cai ñuca talingaraushca rahuaiga tucui runagunata perdunasha juchagunata anchuchingami. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cunan urasmandapacha vinota mana cuti upishachu ñuca Yaya ali mandanaibi cuti cangunahuan upina urascama nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Paiguna cantashcahuasha Olivos nishca urcuma rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chasna riunaupi Jesus paigunata nira, Cunan tuta tucui canguna manzharisha ñucata jichusha rihuangaraunguichi. Chimandaga Diospa shimibimi casna nisha quillcashca tiyan: Ovejata cuiractaga huanchishami, nin. Chasna huanchicpiga ovejagunaga sáa callpangaunami nishca. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ñáuca cuti causarishcahuasha cangunata ñaupasha punda Galileama rishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro chita uyasha paita nira, Tucuiguna canda jichunaupihuas ñucaga canmanda mana jichurishachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Randi Jesus paita nira, Sirtupacha canda nini, cunan tuta gallo chara mana cantagllaita, can quimsa (3) cutin ñucamanda llullangaraungui paita mana ricsinichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chasna nicpi Pedro rimara, Canhuan pariu huañuna ashahuas mana chasna llullashachu nira. Chi shuccunahuas tucuillami chasnallata rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chasna cuintanacushcahuasha Jesus pai japishcagunandi Getsemaní nishca pambama rinaura. Chibi pactasha paigunata nira, Ñáuca chinigma Yaya Diosta mañagrinagama cangunaga caillai tiyaichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedrotas Zebedeohua ishcai churigunatas apasha chinigma rira. Chasna riushami yapa ashcata llaquiringahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Turmintariusha nira, Ñáuca shungüibi llaquiriushalla huañungarauni, cangunaga ñucashina mana puñusha caillai chapaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mas chinigma risha pai tuhuama urmasha Diosta mañausha tapura casna nisha, Ñáuca Yayalla, usharicpi cai jayacta upinashina sinzhi turmintarinataga ñucamanda anchuchihuai, randi mana ñuca munashcacuinta tucuchun astahuanbas can munashcacuinta achun. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Diosta chasna tapushcahuasha pai japishca runaguna aushcama bulltiasha paiguna puñuucta tupagrira. Chasna tupasha Pedrota nira, Manachu shuc urallahuas ñucata cumpañanata usharanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Niccharishcashina Diosta mañasha causaichi juchatas ama rangahua, mana ali rana yuyai shamucpi ima tintais tucungahua. Canguna yuyai alita ranata munagllaita canguna aicha randi sambayashcashina mana ahuantacchan nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chita rimashcahuasha Dioshuan cutillata mañangahua rira. Yayalla, yapa jayacta upicshina ñuca cai jatun turmintaririnata apanapacha acpiga can munashcacuinta tucuchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chasna mañashcahuasha pai japishcaguna aushcama cutillata bulltiasha paiguna puñunayaihuan mana ushasha puñuucunata tupagrira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Paigunata chillai saquisha cutillata mañangahua rira. Pai ñaupa ishcai cutin rimashca shimillatata mañara. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chihuasha pai yachachishcaguna aushcama bulltiasha nira, Charachu puñunguichi, ñucata japina uras ña pactamunmi. Runa Tucucta chi shuc juchayuc runaguna japihuangaraunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cunan jatarisha jacuichi, ñucata japichingarauc runa ña shamuunmi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pai rimaushcai chi chunga ishcai (12) pai japishca runagunamanda shucca Judas Iscariotega pactamura ashca runagunandi. Paigunaga israel pagrigunata mandaucuna, israelgunata mandauc rucugunahuas cachashca anaura. Espada sauligunahuan, caspigunahuanbas Jesusta japingahua shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ñáa Judas paigunata ñaupata rimashca ara casna nisha, Ñáuca muctishca runaga paimi anga, chitaga japinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cuscaita Jesuspagma risha muctisha saludara, Alillachangui señor nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus randi paita nira, Can imata rangahua shamushca ashaga railla alá. Chi ratullai Judashuan shamuc runaguna Jesuspagma shamusha japinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chita ricusha Jesuspa runagunamanda shucca, paihua espada saulita japisha israel pagriguna amuta cuirac runahua rinrita chiú pitira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chasna racpi Jesus paita rimara, Chi saulita cara ucuibi cutillata churai. Saulillahuan huanchic runaga saulillahuan huanchimitucunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Manachu yachangui ñuca munashaga ñuca Yayata tapuima pai ashca huaranga angelgunata cachahuai nisha ñucata quishpichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Randi chasna ñucata caimanda quishpichicpiga imasata Diospa shimibiga pactarishca tucunma, chasna tucuna man nishcaga. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Huasha chi shamuc runagunata tapura, Shuhuac runata japingahua shamuccuintachu ñucata japingahuaca espada sauligunahuan caspigunahuan shamunguichi? Caran punzha Diosta alabana huasibi yachachisha tiyaupihuas chi uras mana japihuaranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Chasna tucunga nisha Dios rimashcata pasachic runaguna quillcashcaga cunan pactariunmi nira. Chasna tucucpi tucui pai japishcagunaga Jesusta jichusha miticusha callpanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta japisha chi pagriguna amu Caifaspagma apanaura. Chi huasi ucui Diospa shimita yachaccunahuas, israelgunata mandac rucugunandi tandarishca aunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedroga carumandalla chi amuhua huasi canzhagama catimura. Chibi auc sundalugunahuan tiyarira imasashi Jesusta rangaraunguna nisha ricungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pagri amuguna tucui israel taripac runagunandi Jesusta huanchishun nisha llulla shimigunata rimac runagunata mascaunaura Jesusta caudsayachingahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ashca llullasha rimaccuna shamunaucpihuas mana imahuas tuparirachu Jesusta alita caudsayachingahua. Ñáa puchucaibi ishcai (2) runaguna cuintac shamunaura casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Cai runaga ñucaga Diosta alabana huasita urmachisha quimsa (3) punzhaibi cutillatami jatachisha nishcata uyaranchi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chasna paiguna rimacpi Jesus mana imatas rimasha aucpi pagriguna jatun amu shayarisha paita tapura, Manachu imatahuas rimangui, imatata ningui caiguna canda caudsayachishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesus randi chunlla shayaura. Chasna acpi pagriguna jatun amu cutillata rimara, Causac Diospa shutihuan canda mandani rimahuai, israelgunata quishpichic Cristochangui, Diospa Churichangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tapucpi Jesus cutipara, Indá, can chasna nishcashina mani. Astahuanbas canda nini, shuc punzha tucuita ushac Diospa ali maqui partima ñuca tiyarishcata ricuhuangaraunguichi, puyu jahuaibi shamuctahuas ricuhuangaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chita uyasha pagriguna jatun amu piñarisha paihua quiquin llachapata liquisha nira, Paiga mana yapa alitachu rimashca. Cangunami pai rimashcataga uyashcanguichi, cunanga paita caudsayachingahua mas mana rimac minishtirin. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Imasnata yuyaringuichi paita rangahua. Chita uyasha tucuiguna caparinaura, Pai chasna nishcamanda huanchina manchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chihuasha Jesusta ñahuibi tiucanaura, sagmanaura, maqui palahuan paita huactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Huactasha tapunaura, Rimahuai quishpichic Cristo, pita canda huactaun nisha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ñáa chi uraspi Pedro canzhai tiyaushcai shuc cuirac huarmi paima caillayasha nira, Cambas Galilea llactamanda Jesushuan puriu arangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nicpi tucuiguna ñaupacpi rimara, Ñáuca mana yachanichu imandachari rimahuangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ñáa chasna punguma llucshingahua riupi shuc cuirac huarmi paita ricusha chibi tiyaucunata nira, Cai runaga Jesushuan maura. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nicpi Pedro sinzhi shimihuan rimara, Ñáuca chi runataga mana ricsinichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Unanicpi chibi tiyaucuna Pedrota ninaura, Sirtumi paita caticpura angui, can paigunashina rimacta uyasha yachanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro yapa jiridsa shimigunata rimangahua callarira, Chi runataga mana ricsinichu nisha. Pai chasna rimashca ratullai shuc gallo cantara. ");
INSERT INTO qvzNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chasnacpi Pedro Jesus rimashcata yuyarira casna nishcata gallo chara mana cantaullaita quimsa cutin paita mana ricsinichu nihuangaraungui nishcata yuyarisha Pedro chimanda llucshisha yapa ashcata huacasha nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cayandi punzhayaupi tucui israel pagri amuguna, rucu mandaccunahuan Jesusta huachinauchun nisha pariu yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chasna yuyarisha paihua maquita huatasha llactata mandac amu Pilatohuagma apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusta japichic Judasca paita huanchingaraushcata yachasha mana alita raushcani nisha yuyarisha chi quimsa chunga (30) cullquita israel pagrigunama, rucu mandaccunamas cutillata cutichigrira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cutichiusha casna nira, Yapa jatun juchatami rashcani, ali runatami cangunama cungahua japichishcani. Nicpi paiguna randi ninaura, Ñáucanchitaga mana imaschan. Canllami yachangui. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chasna rimacta uyasha Diosta alabana huasi ucuma chi cullquita sáa tucsisha llucshisha risha huascahuan huatarisha huañurira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chi amuguna Judas tucsishca cullquita japisha rimanacunaura, Cai cullquiga runata huanchinaunchun nisha pagashca mara, chiraicumi Diosta alabana huasibi churangahua nicpiga mana balinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Paigunapura cuintanacusha pariu yuyarinaura chi cullquihuan shuc mangata ahuac runahua allpata randisha chibi caru llactamanda shamuc runaguna pambanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chiraicumi chi pambaga Rahuai Pamba nishca an cunan urascama. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chasnamandami Dios rimashcata pasachic Jeremias ñaupa rimashcaga cunan pactarira: Quimsa chunga (30) cullquita japinaura, chi cullquiga israel runaguna rimashca tupulla mara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dios ñucata rimashcacuintami chi cullquihuan mangagunata ahuac runahua allpata randiranaura, nisha Jeremias ñaupa quillcara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus chi llactata mandac amu Pilatohua ñaupacpi shayaushcai amu paita tapura casna nisha, Can israelgunahua amuchangui. Tapucpi Jesus cutipasha nira, Indá, can nishcacuinta mani. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Israel pagri amugunas rucu israel mandaccunandi paita caudsayachiupihuas Jesusca mana imatahuas ainirachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chasna mana rimasha chunlla aucpi mandac amu Pilato paita tapura, Manachu uyangui paiguna rimaushcata. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus shuc shimillahuas mana rimarachu. Chasna tucucpi Pilato pitan cai runaga nisha yuyarisha yapa manzharira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Caran huata israelgunahua jatun jista punzhai mandac amu Pilato shuc carcelbi tapariauc runata cacharic ara israel runaguna munashcata. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chi uraspi tucuiguna ricsishca shuc yapa piñac runa carcelbi tapashca tiyaura Barabas nishca. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilato chibi auc ashca runa muntunda tapura, Maicandata ñuca cacharinata munanguichi. Barabastachu cacharisha, quishpichic Jesustachu cacharisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paiguna Jesusta piñashcamanda japisha apamushcataga Pilato ña alitami yachara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chasnallata Pilato taripangahua tiyarinai aushcai paihua huarmi shuc shimita cachara casna nisha, Chi ali runataga imatas ama ranguichu, paimanda yapa manzhanayactata muscurani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pagri amugunas, israelgunata rucu mandaccunahuas chi runagunata yuyachinaura casna rimanaunchun nisha, Barabasta cachari, Jesusta huanchi nisha caparingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chasna tucucpi Pilato cuti tapura, Cai ishcai (2) runamanda maicandata ñuca cacharinata munanguichi. Tapucpi runaguna caparinaura, Barabasta cachari. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato cutillata tapura, Cai Cristo nishca Jesustaga ñuca imasata rasha nisha tapucpi cruspi huanchigri nisha tucuiguna caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Chasna caparinaupi Pilato cuti tapura, Imatata pai mana alita rashcaya. Paiguna astahuan maspas caparinaura, Cruspi huanchishca achun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoga mana imatahuas ranata usharachu paiguna yapa caparicpi. Israelguna chasna lucucuinta caparishcata uyasha tucui runagunahua ñaupacpi paihua maquigunata maillarira ñuca mana culpayucchani nisha ricuchingahua. Chasna maillarisha paigunata nira, Cai ali runamanda mana culpayucchani, canguna ranata raichilla, nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chasna maillarisha rimacpi chi runaguna cutipanaura, Cai runata huanchishcamanda caudsayuc tucungaraunchi ñucanchihuas ñucanchimanda miraigunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chita uyasha mandac amu Pilato chi Barabasta cacharira. Jesustaga libachisha paigunama cura cruspi huanchishca tucuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mandacpa sundaluguna Jesusta japisha amu Pilato mandasha tiyana jatun huasi ucuma apanaura. Chibi tucui sundalugunata liyú paihuacpi tandarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chasna Jesusta asisha pugllangahuaca paihua llachapata surcusha shuc mandac amuhua puca churarina llachapata churachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chihuasha casha huascata ahuasha paihua umaibi gurachinaura, chasnallatas paihua maquibi barata churasha amu bara man nisha asinaura. Chasna amutacuinta rasha paihua ñaupacpi cungurisha ninaura, Canda balichinchi, can israelgunata jatun mandac amu mangui nisha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Paihua ñahuibi tiucasha chi barallahuanda umaibi tiyác, tiyác huactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ñáa paita pugllashcahuasha chi amuhua llachapata llatanachisha, paihua quiquin llachapata churachisha cruspi huanchingahua apasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Romano sundaluguna Jerusalen llactamanda llucshichisha risha, shuc Cirene llactamanda Simon nishca runata tupasha paitaga Jesuspa crusta marcachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Risha Gólgota nishca urcuma pactanaura. Chiga Umatullu nishca urcu mara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chibi pactasha jayac yacuhuan vinoibi chapusha ricuchinaura pai upichun nisha. Jesus randi chita camasha mana upirachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Paita cruspi quilabashcahuasha chi sundaluguna paihua llachapata japinaura, maicanshi surtita charinga nisha camanaura Jesuspa capata apangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chihuasha tiyarisha ricuusha pai imasnaishi huañunga nisha chapaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Crus pundaibi paita imaraicuta huanchishca acta shuc tablaibi casna quillcasha churanaura: CAIGA ISRAELGUNAHUA JATUN AMU JESUSMI nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Paihuan pariu ishcai (2) shuhuac runagunatas cruspi quilabashca aunaura, shucca Jesuspa ali maqui partima, shucca paihua lluqui maqui partima. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chi mayanda puriuc runaguna umata cuyuchisha Jesusta pugllasha asinaura ");
INSERT INTO qvzNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","casna nisha, Canga Diosta alabana huasita urmachisha quimsa (3) punzhaibi cuti shayachishallami nisha rimarangui. Can chasna ranata ushac ashaga cunan can quiquinllata quishpiri. Can Diospa churi ashaga crusmanda uraicui nisha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Israel pagri amugunahuas, israelgunata mandac rucugunandi fariseogunandi paita pugllasha asinaura casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pai shuccunatas quishpichira randi pai quiquinllata quishpirinataga mana ushanzhu. Israelgunahua amu ashaga chi crusmanda uraicuchun ñucanchi paita quiringahuaya nisha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Paiga Diospa churi mani nishami Diosta yuyarishalla puriura. Dios paita llaquishaga cunanllatami paitaga quishpichinma nisha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chi Jesushuan pariu cruspi auc shuhuac runagunahuas paita asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ñáa chaupi punzhamanda las trescama tucui partibi ansayara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chi uraspi Jesus sinzhi shimihuan caparira, Elí, Elí, lema sabactani. Chitaga runa shimibi, Ñáuca Dioslla, ñuca Dioslla, imangahuata ñucata jichuhuangui nin. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Maican chibi tiyaucuna chita uyasha, Dios rimashcata pasachic ñaupa causac Eliastachu cayaun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jesus chasna caparicta uyasha shuc sundalu putucuintata japisha jayac vino yacuibi barasha chuparicpi caspi pundaibi huatasha Jesusta upichishun nisha ricuchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shuccuna paita ninaura, Saqui, Elias paita quishpichingahua shamungarauta ricushun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chihuasha Jesus cuti sinzhita caparisha huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesus huañushca ratullai Diosta alabana huasibi huarcuriac llachapa chaupi chaupibi sháca liquirira jahuamanda allpama pasacta. Chasnallatas allpahuas cuyurira, rumigunahuas partirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huañushcata pambashca juctugunas pascarinaura. Chasna tucucpi ashca Diosta cadsuc huañushcaguna cuti causarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesus causarishcahuasha chi pambashca juctumanda llucshic runaguna Jerusalen llactama cuti yaicunaura. Paigunataga ashca runagunami ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Chi sundalugunata mandacca paihuan tiyaucunandi tucui tucushcata ricusha yapa manzharisha, Sirtupachami cai runaga Diospa Churimashca ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ashca huarmiguna carumanda tucuita ricuunaura. Paiguna Jesusta Galileamanda catimushca asha paita yanapanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Shucca Magdalenamanda Maria mara, shucca Jacobohua chanda Josehua mama Mariahuas, shucca Zebedeoba churigunahua mamahuas aushca ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mas chishiyaupi shuc cullquiyuc runa shamura Jose nishca, Arimateamanda runa mara, paihuas Jesusta catic runa mara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Paiga amu Pilatohuagma risha huañuc Jesuspa aichata tapura. Tapucpi amu Pilato Jose apachun nisha sundalugunata mandara. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Jose chita apasha mushuc llachapahuan pillusha paihua quiquin pambana juctu ucui churagrira. Chi pambana juctuga rumi ucuibi allashca mara mushuc juctu. Shuc jatun rumihuan chi juctuta tapashcahuasha huasita rira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chasnallata tiyanaura Magdalenamanda Maria, shuc Mariahuas chi pambashca juctu ñahuipura tiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cayandi punzha israel samana punzha tucucpi israel pagri amugunas fariseogunahuanbas mandac amu Pilatohuagma rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chima pactasha casna ninaura, Amu, cunan yuyarinchi chi umachic runa chara causaushallata nira, ñuca quimsa (3) punzhaibi causarishami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chasna acpi chi pambashca juctuta quimsa punzhagama cuirachingui, pai japishcaguna tuta shamusha paihua aichata ama shuhuanauchun. Paiguna shuhuashaga runagunata umangaunami Jesus ña huañushcamanda cuti causarishcami nisha. Paiguna chasna rimasha llullacpiga Jesus mas balirishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chasna ninaupi amu Pilato paigunata nira, Sundalugunata apaichi, chi pambashca juctuta alita cuiranauchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chita uyasha chi pambashcaibi risha, ama pihuas shuhuangahua pascachun nisha chi rumita alita huatanaura. Chasnallata maican sundalugunata saquichinaura chita alita cuiraichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Israel samana punzha pasashcahuasha Domingo punzha ña pagariupi, ishcai (2) huarmiguna Magdalenamanda Maria chi shuc Mariandi pambashcata ricungahua rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cungaimanda shuc angel uraicusha chi juctuta tapashca rumita anchuchisha chi jahuai tiyarira. Chasna racpi allpa sinzhita cuyurira. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chi angelga dilampashcacuinta punzhaglla ricurira, pai churariashca llachapaga puyucuinta ruyaglla ricuric ara. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chi juctuta cuirauc sundaluguna paita ricusha yapa manzharisha huañushcacuinta sirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Huarmigunataga chi angel nira, Ama manzhanguichichu, cruspi huanchishca Jesusta canguna mascaucta yachani. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pai nishcacuinta ña causarishcami, caibi illanmi. Ricuc shamuichi paita churashcatas. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ricushcahuasha uctalla ringuichi pai japishca runagunata cuintangahua pai causarishcami nisha. Paimi cangunata ñaupasha Galileama punda ringa, chibimi paitaga ricunguichi nisha cuintagrichi. Chita cuintangahuami shamurani nira chi angel. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chi huarmiguna chita uyasha manzharishca aushallata yapa cushiyasha huairashina callpasha rinaura Jesus japishca runagunata cuintangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chasna riushcai Jesusmi paigunata tupagrisha saludara. Paiguna Jesuspagma caillayasha chaquita japisha paita alabanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chasna racpi Jesus paigunata nira, Ama manzharichichu. Ñáuca huauquishina tucuc japishca runagunata cuintagrichi Galilea partima paiguna rinauchun, chibi ñucata tupahuanaungami. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Huarmiguna riunaupi chi juctuta cuirac sundaluguna llacta ucuma risha israel pagri amugunama tucui chibi pasashcata cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Israel pagri amuguna chasna rimashcata uyasha israel rucu mandaccunahuan imasnata rashun nisha cuintanacungahua rinaura. Cuintashcahuasha chi sundalugunama ashca cullquita cunaura casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Canguna casna ninguichi, tuta ñucanchi puñuushcaibimi pai japishca runaguna shamusha, paihua aichataga apashca anaura nisha pitahuas rimanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Amu Pilato chi shimitas uyasha cangunata piñacpiga ñucanchimi paihuan cuintasha alichishun. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chasna rimacta uyasha sundaluguna cullquita japisha paigunama rimashcashinallata cuintanaura. Chi llullashca shimitaga chara cunan angamami israelguna quirinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chihuasha chi chunga shuc (11) pai japishca runaguna Galilea partima rinaura Jesus ñaupa rimashca urcuma. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chibi paita ricusha alabanaura. Randi maicangunaga Jesus acta mana sirtuta quirinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus paigunahuagma caillayasha nira, Jahuapachai cai pachaibihuas tucuita mandana ushaitaga Yaya Diosmi ñucama cuhuashca. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chasnamandami tucui runaguna ñucata quirisha catic tucunauchun nisha yachachigringuichi, paigunata Yaya Diospa shutihuan, Diospa Churi shutihuan, Diospa Samai shutihuan bautisanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ñáuca cangunama tucui rimasha mandashcagunata ranauchun nisha yachachisha puringuichi. Sirtupachami tucui uras, hasta cai pacha tucurinagama, ñuca cangunahuan tiyashami nira.");
INSERT INTO qvzNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diospa churi Jesucristomanda quishpina shimiga casnami callarishca. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dios rimashcata ñaupa pasachic Isaias casnami quillcashca: Ñáuca shimita yachachic runata ñaupata cachauni can purina ñambita alichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Paiga chaquishca pambaibi casna caparisha camachin: Dios cachashca quishpichic runaraicu shuc cusca ñambita rashcacuinta canguna causaita alichirichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chasnacpi Juanga chaquishca pambai Dios rimashcata camachisha runagunata bautisara. Pai camachisha casna nira, Dios canguna juchagunata anchuchingahuaca canguna juchata rashcagunata llaquirisha saquichi, chihuasha bautisarichi nisha camachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea provinciamandas Jerusalen llactamandahuas tucui runaguna Juanbagma shamunaura pai camachishcata uyangahua. Chita uyasha ñuca jucha rashcagunata saquinimi nicpi Juan chi Jordan nishca yacuibi bautisara. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanga camello nishca carata churarisha huagra carahuan ananuc ara. Sacha mishquitas chilicshina ricuriccunatas micusha causac ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pai camachiusha casna rimara, Ñáucamanda huashalla shamungarauc runaga ñucamandas yali ushaiyuc man. Ñáucaga shuc mas pishi tarabac runacuinta mani. Chasna asha huascata pascangahuallas paihua zapatosta llucshichingahuas mana balicchani. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ñáuca cangunataga yacuhuanmi bautisauni, paiga cangunata Diospa Samaihuanmi bautisanga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chi punzhagunai Juan Jordan yacuibi bautisaura. Chasna aushcai Jesus Galilea provincia Nazaret llactamanda llucshisha shamushcai Juan paita bautisara. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus yacumanda llucshiushcai jahuapacha pascarishcata ricura, Diospa Samai paihua jahuaibi shuc paloma uraicumushcacuinta tiyaric shamura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chasnallata jahuapachamanda shuc shimi uyarira, Can ñuca llaquishca Churi mangui, can quishpichic tucuchun nisha ñuca canda cushihuan japirani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chihuasha Diospa Samaiga ruyaguna illac chaquishca partima Jesusta apara. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chi pambai chuscu chunga (40) punzha tuputa supai paita pandachinata munasha camaura. Chibimi piña sacha aichaguna tiyanaura. Chibi Diospa angelguna paita cuiranaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chihuasha Juanda carcelbi tapanaura. Chi uras Jesus Galilea provinciama risha Diospa ali mandanamanda cuintasha paimi quishpichinata munan nishami cushi shimita yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Casnami yachachira, Quishpina uras ña pactamushcami. Diospa ali mandanaga mayanyamushcami. Canguna juchata saquisha Dios quishpina shimita cadsusha causaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea cucha mayanda Jesus puriusha yacu aichagunata japic ishcai (2) runagunata ricura. Chigunaga arami Simon paihua huauqui Andreshuan licata yacui shitaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paigunata ricusha rimara, Jacu ñucahuan catihuaichi. Canguna imasna yacu aichata japishcanguichi chicuintallata cunanmanda ñaupagma runagunata japicshina tucunguichi ñucamanda yachachisha. Chasna cangunata rashami. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chasna nicta uyasha chi ratullata licata saquisha Jesusta caticcuna tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pai chinicshinai riushcai Zebedeoba churi Santiagota, paihua huauqui Juandi canuaibi licata alichiucunata ricura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Paigunata ricusha ñucahuan catihuaichi nisha rimaupi paiguna yayata tarabaccunatas canuaibi saquisha Jesusta caticcuna tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chihuasha Capernaun nishca llactama rinaura. Samana punzhaibi israelguna tandarina huasibi Jesus yaicusha runagunata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mana chi shuc Diospa shimita yachachiccunacuinta yachachirachu, randi Diospa Samai ushaihuanmi yachachiura. Pai rimashcata uyaucuna ashcata manzharinaura, maibita chi tucuita yachara, pai yachachinaga shuc tunu man nisha rimanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chi tandarina huasillaita tiyaura shuc supai yaicushca runa. Pai caparingahua callarira casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nazaretmanda Jesus, Ñáucanchimanda anchuri, ñucanchita ama quillachichu, ñucanchita huanchisha tucuchingahuachu shamurangui. Canda ricsinchimi, canga Dios anllasha cachashca ashami jucha illac runa angui nisha caparira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chasna nicpi Jesus chi supaita sinzhita rimasha mandara, Chunlla ai, cai runa ucumanda llucshisha ri nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesus mandashcata uyasha supai chi runata yapa cushpachisha, sinzhita caparisha, paimanda llucshisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chasna tucucpi chita ricuucuna yapa manzharisha paigunapura cuintanacunaura, Imasna ashata chasna riman. Jesusca shuc tunuta yachachic man, paihua shimiga ushayuc man, supaigunatas pai mandacpi paitaga cadsusha llucshinaunmi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chimanda intiru Galilea llactagunaibi Jesusmanda cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chi israel tandarina huasimanda llucshisha Jesus Santiagondi Juandi rira Simon, Andres tiyashca huasima. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonba huarmihua mama chibi ungushca siriura. Chasna acpi paimanda Jesusta cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus pai siriushcai risha paihua maquimanda japisha jatarichira. Chi ratullai aliyara. Aliyasha paigunata upichingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chi chishillaita israel samana punzha indi yaicuushcaibi tucui ungushcagunata, supai yaicushcagunatas Jesuspagma apamunaura janbichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chi llactamanda yapa ashca runaguna mana cáilla chi huasi pungüi tandarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus ima tunu ungushcagunatas alichira, chasnallata runaguna ucumanda supaita llucshichisha callpachira. Supaigunaga Jesusta ricsinaurami, chasna agllaita Jesusca mana munarachu paimanda rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cayandi gallo cantashcai Jesus jatarisha huasimanda llucshisha, runa illashca partima rira Yaya Dioshuan cuintangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ñáa pai illacpi Simon paihuan tiyaucunandi Jesusta mascangahua rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mascasha tupanaura, tupasha paita rimanaura, Ashcagunami canda mascaunguna nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chasna rimanaupi uyasha paigunata nira, Jacuichi shuc partima, mayanlla llactagunama. Ñáuca chi llactagunaibihuas yachachina mani. Chiraicumi cai pachama shamushcani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chasna acpi puriura tucui Galilea llactagunata. Chibi auc israel tandarina huasigunai camachisha, runaguna ucumanda supaita llucshichisha puriura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Shuc punzha shuc lepra nishca sinzhi carachayuc runa Jesuspagma shamura. Paihuacpi cungurisha paita rugara, Can munashaga ñucata janbinata ushahuangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus paita llaquisha paihua maquihuan chi runata llangasha rimara, Munani, janbishca tucunguimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pai rimashcahuan cungaimanda tucui lepra chingarira, chi runa janbishca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chihuasha Jesus paita cachaura casna cunasha, ");
INSERT INTO qvzNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ama pitas cuintanguichu, can amu yuyallai charingui. Randi israel pagrihuagma risha camba aichata ricuchigri nira. Chasnallata tucui runaguna chita yachanauchun nishaga huañuc Moises mandashcatacuinta rasha pagrima cugringui camba aicha janbirishcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Randi chi runa risha chunlla aunarandimandaga tucui runagunata chimanda cuintausha purira. Chiraicumanda Jesus llacta ucuma yaicunata mana usharachu, astahuanbas llacta canzhama huasi illashca partibi saquirira. Chasnacpi ashca runaguna tucui partimanda paihuagma rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ashilla punzhahuasha Jesus Capernaun llactama bulltiara. Bulltiacpi chi causauc runaguna uyanaura pai shuc huasibi aushcata. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chimanda yapa ashca runa paihua huasi punguta tapacta shamunaura. Paigunata ricusha Diospa quishpina shimita yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yachachiushcaibi chuscu (4) runaguna shuc suchu runata paihua baitaibi churasha apamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Randi Jesus aushcama pactanata mana ushasha, chi pala huasi jahuama apasha shuc juctuta rasha, Jesuspa ñaupacpi chi baitaibi churashca suchu runata uraicuchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Paiguna paita quirishcata ricusha chi suchu runata rimara, Camba jucha anchuchishcami tucungui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ñáa chibimi tiyaunaura Moises mandashcata yachachiccunas. Chasna Jesus rimashcata uyasha, paiguna shungu ucuibi yuyarinaura, ");
INSERT INTO qvzNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Imamandata pai casna riman. Dioscuinta rimasha jiridsata riman, Diosta camiunmi. Pita juchagunata anchuchinata ushanga, mana Dios ashaga ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesusca paiguna shungu ucui yuyariushcata yachasha tapura, Imangahuata chasna yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maicanda mas ali rimanalla cai suchu runata, camba juchagunata anchuchitucushca angui nisha rimacpi, u jatari camba baitata apasha ri nisha rimacpichu, maicanda mas sinzhi rana. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ñáuca Runa Tucuc asha cai pachaibi juchagunatas anchuchina ushaiyuc acta ricuchishcanguichi. Chasna rimashcahuasha suchu runata nira, ");
INSERT INTO qvzNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Jatari, camba baitata apasha huasita ri. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chi ratullai jatarisha paihua baitata japisha tucuiguna ricushcaibi chimanda llucshisha rira. Chita ricuccuna manzharinaura, Diosta alabasha, manapacha mana ima uraspas chasna acta ricushcanchichu nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus chimanda llucshisha cutillata cucha patama rira. Chibi aushcai ashca runaguna paihuagma shamunaupi paigunata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chihuasha Alfeohua churi Leví nishcata ricura. Paiga romano gubirnuraicu cullquita tandachic asha paihua tarabana huasibi aura. Jesus paita ricusha, Ñáuca runa tucusha ñucata catihuai nisha rimacta uyasha jatarisha Jesusta catisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chihuasha Jesus Levíhua huasibi micuura. Chasnallata ashca gubirnuraicu cullquita tandachiccuna, ashca juchayuccunahuas, Jesushuan pariu micunaurami pai japishca runagunandi. Tucui chillai pariulla micunauura ashca runaguna Jesusta catisha puriushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chasna paiguna micushcai fariseo nishca Dios mandashcata yachachiccunaga pagllamanda shayarisha, Jesus chi gubirnuraicu cullquita tandachiccunahuan juchayuccunahuanbas micucta ricusha, pai japishca runagunata tapunaura, Imangahuata cangunata yachachic runaga chi romano gubirnu cullquita tandachiccunahuan juchayuccunahuanbas micuun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chasna paiguna rimaushcata uyasha Jesus rimara, Mana ungushca ali runagunaga doctorta mana minishtinaunzhu, randi ungushcagunallami doctortaga minishtinaun. Ñáucaga mana shamuranichu ali mani nisha causaccunata mascangahuaca, randi juchata rauc runagunata mascasha japingahuami shamurani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Shuc punzha Bautisac Juan yachachishca runagunas, fariseoguna yachachishca runagunahuas mana micusha sasina punzha pactara. Paiguna mana micusha sasiunaupi shu runagunaga Jesuspagma rinaura paita tapungahua, Juan yachachishcagunahuas fariseogunahuas mana micusha sasiunguna, imangahuata canda caticcuna mana sasinaun nisha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tapucpi rimara, Cadsaraushcama cayashca runaguna mana sasicchanaun cadsarac runa paigunahuan tiyaupiga. Cadsarac runa paigunahuan tiyaupiga mana sasingaunachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Randi shuc punzha cuntar runaguna ñucata apashcaibimi ñuca amigoguna sasinaunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yuyarichi. Mana pi runahuas shuc mauca llachapataga mushuc pitihuan rimindanzhu. Chasna racpiga chi mushuc llachapa tsinunyacpi mauca llachapaga mas liquirisha ringa. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chasnallata mana pihuas llullu vinota mauca puruibi churanaunzhu. Churacpi llullu vinoga chi puruta pulunga, pulucpi vino taliringa. Chasna tucucpi ishcandi huaglinga. Randi mushuc rashca vinotaga mushuc puruibi churana manchi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Israelguna shuc samana punzhaibimi Jesus shuc chagra ucuta puriura. Pai japishca runaguna chita pasaushcai raicachicpi trigo muyu angugunata pitisha apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Maican fariseoguna chita ricusha piñasha Jesusta rimanaura, Ricui, ñucanchita mandashca shimibiga samana punzhai mana tarabana changuichi nishca an. Chasna acpi imangahuata chasna raunguna samana punzhamanda quillcashcata mana cadsusha. Paiguna samana punzhataga mana balichinaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jesus paigunata rimara, Yuyarichi, Abiatar nishca israel pagri amu causaushcai mandac rey amu Davidga micuna tucuricpi pai paihuan puriccunandi raicahuan ausha Diospa huasima rira micunata tapungahua. Tapucpi chi pagri amu Diosma ricuchishca pangunata Davidma cucpi japisha micura. Ñáa chi tunu panga pagrigunalla micuna ashca ara. Chasna agllaita chi panda micura, paihuan puriucunatas carara. Pai chasna rashcamanda Diospa shimibi quillcashcataga manachu ricushcanguichi. Pai chasna rashcamanda mana culpayachinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Chihuasha paigunata mas rimara, Samana punzhataga runaguna samachun nishami Yaya Diosca saquira. Runagunataga samana punzhallata yuyarisha causachun nisha mana rarachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chasna acpi ñucaga Runa Tucuc ashami samana punzhahuas mandac ani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Cutillata israel tandarina huasima Jesus yaicushcai shuc maqui huaglishca runa chibi tiyaura, ñañuyashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseoguna Jesusta caudsayachingahua nisha samana punzhaibi chi runata alichingachu imashi nisha yuyarisha chapanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chasna yuyarigllaita Jesus chi maqui huaglishca runata nira, Jatarisha runaguna chaupibi shayari. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Shayaricpi Jesus chibi tiyaucunata tapura, Dios mandashcagunata cadsusha samana punzhaiga imata rana tan. Alita ranaga balinzhu. Mana alita ranahuas balinzhu. Shuc runata huañunamanda quishpichicpihuas balinzhu. Huañuchun nisha saquicpichu balin. Imatata ninguichi canguna. Tapucpi randi paiguna chunlla shayaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus paigunata ricusha piñarira. Paiguna shungu sinzhi acta yachasha yapa llaquirira paiguna shucta mana llaquinata charishcamanda. Chasna llaquirishami chi runata camba maquita chutai nisha rimara. Pai chutachishcallai ali tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chi fariseogunaga chimanda llucshisha mandac apu Herodesta caticcunahuan cuintanacunaura imasna Jesusta huanchinamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus pai yachachishcagunandi chi llacta ucumanda llucshisha Galilea cucha mayanbi rinaura. Pai chima ricpi Galilea llactagunamanda ashca runaguna paita catisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pai ali raushcagunata ricusha ashca runaguna tucui llactagunamanda shamunaura, Judea llactagunamandas, Jerusalenmandas, Idumea partimandas, Jordan yacu chimba partimandas, Tiro Sidón nishca llactagunamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chasna yapa ashca runaguna shamushcata ricusha Jesus pai yachachishcagunata nira, Shuc canuata alichichi ama runagunahuan tapacta tucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pai chasna nira ashca ungushcagunata alichiushcata ricusha, shuc ungushcagunatahuas tangasha tangasha caillayanaura paita llangangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Supai yaicushca runagunaga paita ricusha cungurisha capariunaura, Canga Diospa Churi mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus randi chi supaigunata sinzhita, Ñáuca pi actas ama rimaichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chihuasha Jesus shuc urcuma sicasha tucui paita catiu runagunamanda pai munashca runagunata anllara ñucama shamuichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chunga ishcaillata (12) anllasha ñuca japishca runa nishca tucunguichi ñucahuan pariu tiyangahua, chasnallata Diospa quishpina shimita camachinauchun nisha cachangahua japira. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chasnallata ushaita paigunama cura supaigunata llucshichisha cachangahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Paigunahua shuti caigunami ara: Simon, paita Pedro nishcata shutichira, ");
INSERT INTO qvzNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeoba churiguna Santiago, paihua huauqui Juandi, paigunata Rayuhua churiguna nisha shutichira, ");
INSERT INTO qvzNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andres, Felipe, Bartolome, Mateo, Tomas, Alfeohua churi Santiago, Tadeo, cananeo muntunmanda Simon, ");
INSERT INTO qvzNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Chasnallata paita randichic Judas Iscariote. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chihuasha Jesus shuc huasima pactara. Ashca runaguna chibi tandarimunaupi micungahua lugarta mana charinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Paihua ailluguna chita uyasha, paimi nusparishcacuinta tarabaun nisha shamuunaura paita chimanda pushashun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moises mandashcagunata yachachiccuna Jerusalenmanda shamusha ninaura, Cai runaga Beelzebú nishca supaigunahua amutami charin, Beelzebú ushaihuanmi supaigunata chasna llucshichin nisha Jesusta caminaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chasna camicpi Jesus cayasha paigunata tapura, Imasna rashata supaiga supaillatataga llucshichinata ushan. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Shuc llactaibi causaccuna chican chican tucucpiga chi llacta chingaringami. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chasnallata shuc huasibi tiyauc aillupura macanacushaga paiguna tucuringaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanaspas pai mandashca supaigunahuan piñanacushaga mana unayasha tucuringami. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mana pihuas shuc sinzhi runahua huasima shuhuangahua yaicunata ushanzhu paita ñaupata mana huatasha churashaga. Paita huatasha churashcahuashallami shuhuanata ushanga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cangunata nini, Tucui tunu juchata rashcagunata, tucui jiridsa shimigunatahuas Dioslla anchuchinata ushan. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Randi shuc runa Diospa Samaita camishaga mana ima uraspas perdunaitucungachu, chasna camishcamanda huiñai juchayuc tucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus chasna yachachira paiguna supaita pai charinmi nisha rimashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus rimaushcai paihua mama, paihua huauquigunandi pactamusha canzhai shayarisha shuc runata cachanaura rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesuspa mayanbi liyú tiyaucuna paita rimanaura, Uyai, camba mama camba huauquigunandi canzhaibi tiyaunguna, canda mascaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Randi Jesus paigunata nira, Pitan ñuca mama, pigunatanaun ñuca huauquiguna. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Casna nisha paita liyú tiyaucunata ricusha nira, Caiguna man ñuca mama tucuc, ñuca huauquiguna tucuc. ");
INSERT INTO qvzNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maicanbas Dios munashcata pactachic runami ñuca huauqui, ñuca pani, ñuca mama anaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Shuc punzha Jesus cucha mayanbi risha runagunata yachachingahua callarira. Ashca runaguna chibi tandarinaupi shuc canua ucuma yaicusha tiyarira. Runagunaga yacu patalla saquirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus paigunata ashca yachachina shimigunata cuintasha yachachira. Shucta casna nisha cuintara, ");
INSERT INTO qvzNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Uyaichi nira. Shuc runaga muyuta tarpungahua rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jichaupi maican muyugunaga ñambibi urmanaura. Chigunata pishcuguna shamusha micunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Shuc muyugunaga rumi pambaibi urmanaura. Chiguna mana ashca allpa tiyashcamanda huairashina huiñanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Randi indi llucshimucpi chi muyu anguguna illac asha chaquirisha huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Shuc muyugunaga huita ucui urmanaura. Huita huiñasha muyuta nitira, chimanda chi ali muyuguna mana aparinata ushanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Chasnallata shuc muyugunaga ali allpai urmanaura. Chigunaga alita huiñasha ashcata aparinaura. Maican ruyamanda quimsa chunga (30) muyu llucshira, maicanmanda sucta chunga (60) muyu, maicanmanda shuc patsac (100) muyu llucshira nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Huasha paigunata nira, Rinriyuc runaguna ashaga caita alita yuyarichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus paita catic runagunahuan pai chunga ishcai (12) japishcagunandi sapalla saquiricpi paiguna tapunaura, Can casna cuintashcaga imatata yachachin. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Paiguna chasna tapucpi nira, Diosca paihua ali mandanamanda pacashcacuinta mana ñaupa yachachishcataga cunan canguna yachanauchun nisha ricuchiun, Randi chi shuccunaga Diospa ali mandanai yaicunata mana munaccunaga mana intindisha saquirinaun, chiraicu yachachina shimigunallahuan paigunata yachachini. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chimandami Diospa shimi nin: Paiguna ricushahuas mana asirtanaungachu, rinrihuan uyashahuas mana intindinaungachu. Chasna acpimi paiguna causaita mana cambiarishaga quishpina illac tucunaunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus paigunata tapura, Cai yachachina shimitaga manachu intindinguichi, huashaga ñuca shuc yachachina shimigunatas cuintacpi imasata intindingaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cai yachachishcaga casnami nira, tarpuc runaga Diospa shimitami tarpun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maican runagunaga chi ñambibi urmashca muyucuinta anaun. Paiguna Diospa shimita ali uyaushcai Satanas shamusha chi shimita paiguna yuyaimanda chingachin. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Shuc runagunaga rumi pambaibi urmashca muyucuinta anaun. Paiguna Diospa shimita yapa cushihuan uyasha quirishca runatami ricuchin. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Chasna ashallata ucu anguta mana charishcacuinta asha mana sinzhiyanaun. Chi shimita quirishcamanda paihuacpi llaqui shamucpi, turmintachishca tucushas dsaslla saquinaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Shuc runagunaga huita ucuibi urmashca muyucuinta anaun. Diospa shimita uyanaun, ");
INSERT INTO qvzNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","randi paiguna causanallata yapa yuyarinaun, paigunallata umachirinaun chi charishcagunata munasha, chasnallata cai mundui ashca cushita charinatas munanaun. Shuc ruyata angu ugllaricpi muyuta aparinata mana ushashcacuinta Dios munashcata mana ranata ushanaun. Diospa shimita uyashahuas mana uyaccuinta tucusha causanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Astahuanbas shuc runagunaga ali allpai tarpushca muyucuinta anaun. Diospa shimita uyasha, catisha gustu muyuta aparishcacuinta tucunaun. Maicanguna quimsa chunga (30) tupu, maicanguna sucta chunga (60) tupu, maicanguna shuc patsac (100) tupu muyuta aparishcacuinta tucunaun. Chasna ricuchin Yaya Dios munashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Shuc yachachina shimita Jesus cuintara casna nisha, Canguna bilata sindichisha cajun ucuibichu churanguichi, cayutu ucuibichu churanguichi. Mana. Randi jahuaibi churanchi bila alita ricuchichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chi bila ricuchishcacuinta tucui pacalla rashcagunaga huasha pagllai ricuringaraun. Tucui itsanlla rimashcagunaga huasha pagllai yacharingami. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yuyaiyuc runa chita yuyarichun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Shuc yachachina shimitahuas cuintara, Canguna ima tupuhuan shuc runata taripashaga chi tupuhuallanda cangunatas taripaitucungaraunguichi, chasnallata mas yalitas taripashca tucungaraunguichi. Chiraicumi canguna uyaushcamanda yuyarina anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Charic runaga mas cuitucunga. Mana charic runaga pai charishcata quichushca tucunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Shuc yachachinatahuas cuintara imasna Diospa ali mandana runaguna mirarinaun casna nisha, Shuc tarpuc runa jichashca muyugunacuinta anaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chi runa tuta puñun, punzha taraban. Punzhahuas tutahuas pasanaun, chi muyuga ña anguyan, llucshin, huiñan. Chi muyu imasna huiñaushcatas runa mana yachaullaita huiñaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Allpaga pai munailla apachiun. Ñáaupata panga llucshin, huasha aparin, huasha tuctun, chihuasha muyu tucun. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Muyu ña pucucpi amu pallanmi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus shuc yachachina shimitas cuintara imasna Diospa ali mandanai auc runaguna mirarinaun, casna yachachisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Shuc mostaza nishca ichicua muyucuinta man. Tucui tarpuna muyugunamandas mas ichillahua man. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Huasha huiñasha tucui ichilla ruyagunamandas mas yali jatun tucun. Jatun ramayuc tucushcahuasha pishcugunas chi ramagunaibi huasinaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chi tunu shimigunahuan Jesus paigunata yachachiura paiguna intindina tupullata. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yachachina shimigunallahuan tucui runagunata yachachira. Randi pai japishca runagunallahuan tiyausha tucuita pasacta intindichira. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chi punzha ña ansayaushcai Jesus pai japishca runagunata nira, Jacuichi chimbashunchi. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chasna nicpi runagunata saquisha Jesusta pushanaura pai tiyaushca canuallaita. Shuccuna shuc canuagunaibi pariu rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ñáa chimbaushcai sinzhi huaira jatarira. Chasna tucucpi ashca ulascuna sáusáuc canuama yaicusha ñalla tigrachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusca canua siquibi shuc saunai puñuura. Chi runaguna manzharisha paita nicchachinaura nisha, Tigraunchimi señor, ñucanchi tigrautas manachu yuyaringui. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pai jatarisha huairata yacutas sinzhita rimara. Pai rimashcahuan huairahuas yacuhuas saquirisha tucui mansu tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chihuasha paigunata nira, Imahuata manzharinguichi. Chara manachu ñucata alita quirihuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paigunapura manzharisha cuintanacunaura casna nisha, Manapacha, pitan cai runa. Huairahuas yacuhuas paita uyashcauna ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cuchata chimbasha Gadara nishca partibi pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus canuamanda llucshishcai supai yaicushca runaga paihuagma callpamura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chi runa huañushcata pambashca urcu juctugunaibi causac ara. Mana pihuas paita charinata ushanaurachu, cadenagunahuan huatashahuas mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ashca cutin chi runaga maquitas chaquitahuas cadenahuan huataushca ara. Chasna agllaita tucuitami pitira. Paita llachapata churachinata mana pihuas ushacchanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tutandi punzhandi huañushcata pambashca juctugunaibi, urcugunaibihuas caparisha puric ara. Rumigunahuan amullata huactaric ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Carumanda Jesusta ricusha huairashina callpamusha paihuacpi cungurira. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Pactamucpi Jesus chi supaita mandara, Cai runamanda llucshi can mana balic supai. Chasna mandacpi supai sinzhita caparira, Can jahuapachai tiyauc jatun Diospa Churi mangui Jesus, imatata munangui ñucahuan, imata rasha nishata yapa quillachingui. Diosmanda nini ama ñucata turmintachihuaichu. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chasna supai rimacpi Jesus paita, Ima shutitangui nisha tapura. Tapucpi nira, Ñáuca shutiga Huaranga Huaranga supailla Atirishca niushca mani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Paiga Jesusta ashca cutin rugaura, Cai pambamanda ama callpachihuaichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chi urasllata chi urcuibi ashca cuchiguna micusha shayanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chi supaiguna Jesusta ruganaura, Cuchigunahua ucuibi ñucanchita yaicuchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus alimi nicpi supaiguna chi runamanda llucshisha cuchiguna ucuibi yaicunaura. Chi cuchigunaga ishcai huaranga (2.000) tupu anaura. Ñáa supaiguna yaicucpimi cuchiguna huaicuma callpashami tsan urcumanda yacuibi urmasha yacuta chucasha huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chita ricushami cuchita cuiraccuna miticunaura. Tucui partibis cuintasha purinaura, caran huasigunaibi pagllagunaibihuas imasna tucushcata cuintasha purinaura. Uyaccunaga imasna tucushcamandas yapa ricunata munasha shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesuspagma pactasha chi supaiguna ñaupa japishca runata ricunaura. Pai casilla tiyaushcata, llachapatas ali churarishcata, ña ali yuyaiyuc tucushca auta ricusha yapa manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chi tucushcata ricuc runaguna supai yaicushca runa imasna tucushcata, chasnallata cuchiguna imasnata tucushcamandas cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chi runaguna manzharisha Jesusta rugangahua callarinaura, Cai llactamanda llucshisha ri. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chasna ruganaupi Jesus canuama yaicungahua riupi chi supai yaicushca ac runa paita rugara, Canhuan pushahuai nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Randi Jesus mana munarachu, astahuanbas paita nira, Camba huasima ri, camba aillugunata Dios canda llaquishcamanda tucuita canda rashcata cuintagri nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chasna nishcata uyasha chi runa Decapolis nishca llactagunaibi Jesus paita alichishcamanda cuintara. Cuintacpi tucui uyaccuna manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus chimba partima bulltiamucpi ashca runaguna paihuacpi tác tandarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pai chara cucha mayanbi aullaita shuc israelguna tandarina huasibi cuirac amu Jairo nishca shamura. Jesusta ricusha paihua chaqui mayanbi cungurisha rugara, ");
INSERT INTO qvzNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ñáuca ushushimi huañupaun nisha, ricupacshamui, camba maquita paihua jahuaibi churacpiga janbiringami. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jairo chasna rugacpi Jesus riura, runagunas paita catisha riusha tangasha tangasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chasna riushcaibi chi runa muntunbi shuc ungushca huarmi tiyaura, chunga ishcai (12) huatata rahuai talirisha causac ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ashca doctorgunahuacpi janbirisha nishahuas mana ushasha turmintarisha causara. Chasna asha tucui paihua cullquita yanga pirdisha causara mana janbirishallata mas tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Chi huarmi Jesusmanda uyasha, paihua llachapata llangashaga janbirishami nisha yuyarira. Chasna yuyarisha chi ashca runaguna chaupita riullaita Jesuspa huashamanda pactamusha paihua llachapata llangara. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Llangashcahuan paihua rahuai taliriuc saquirira, ña paihua aicha turmintariushcamanda alita yachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chi ratullaita Jesus paihuagmanda ushai llucshishcata sintirisha, huashama bulltiarisha ricusha tapura, Pita ñuca llachapata llangara. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tapucpi paihua runaguna ninaura, Manachu ricungui cai tucui runaguna cambacpi llutacta tacarinaun. Imaraicuta pita llangahuara nisha tapungui. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Randi Jesus caranma caranma ricuura paita llangacta tupangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chasna ricuupi chi huarmi paihua aichai tucushcata asirtasha manzharishcahuan Jesuspa ñaupacpi cungurisha tucuita cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Cuintacpi Jesus paita nira, Ama manzharichu. Can quirishcamandami ali tucushcangui, cunanga cungailla ri. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus chara chi huarmihuan rimaupi Jairohua huasimanda runaguna shamusha paita ninaura, Camba ushushi ña huañushcami, imaraicuta Señor Jesusta mas quillachingui. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus paiguna rimashcata uyasha Jairota rimara, Ama manzharichu, quirilla nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chimanda Jesus mana munarachu pitahuas paihuan ringahua. Pedrota, Santiagotas paihua huauqui Juandas paigunallata pushara. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ñáa Jairohua huasima pactaushcaibi mana cáilla huacasha, caparisha caparisha huacaushcata uyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Huasima yaicusha paigunata tapura, Imata tucunguichi. Huahua mana huañushcachan, puñuunllami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chasna nicpi chi runagunaga paita asinaura. Randi Jesus tucuigunata llucshichira. Chihuasha huañushca huahua siriushcama yaicura pai apashca quimsagunatas, chi huahuahua mamatas yayatas apasha. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Huahuata maquimanda japisha israel runaguna shimibi paita rimara, Talita cumi nishca, chiga runa shimibi, Candami nini jatari mamacu nin. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chasna rimashca ratullaita chi huahua shayarisha puringahua callarira. Chi huahuaga ña chunga ishcai (12) huatayuc mara. Tucui chi huahua puriuta ricusha yapa manzharishahuas cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Chihuasha Jesus paigunata rimara, Ama pitahuas cai tucushcata cuintanguichichu. Cunanga camba huahuata carangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus pai japishca runagunandi chimanda llucshisha paihua quiquin llacta Nazaret nishcama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samana punzha chi israel tandarina huasibi yaicusha yachachira. Paita uyaccunaga manzharisha cuintanacunaura, Imaita chi tucuita yachara paiga. Chi pihuas mana rashcagunatas rangahuaca maimandatachari chi tucui ushaita tupara. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sirtu paiga tucui runaguna ricsishca carpintero runa man. Mariahua churi man, chasna ashami cai llactai huiñac ara. Paihua huauquigunas caibi aunguna Santiago, Jose, Judas, Simon. Paihua panigunahuas ñucanchihuan aunguna ninaura. Chasna yuyarisha paita mana balichinaurachu yapa ricsishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chasna acpi Jesus paigunata rimara, Shuc llactagunaibiga Dios rimashcata pasachictaga llaquinaunmi. Astahuanbas paihua quiquin llactamanda runagunaga, paihua aillugunahuas paita mana llaquinaunzhu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chasnamandami chi llactaibiga mana ima ranatas rarachu. Ansalla ungushca runagunata alichira paihua maquita umaibi churasha. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus chi runaguna paita mana quirishcamanda manzharira. Chasna acpi chimanda llucshisha mayanlla llactagunama yachachisha puriura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chihuasha chi chunga ishcai (12) anllashca runagunata cayasha ishcai ishcailla cachara. Chasna cachausha runa ucumanda supaita llucshichina ushaita paigunama cura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ñáa cachausha paigunata rimara, Ama apanguichichu cullquitas shigratas micunatahuas, randi canguna barallata apanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Can charishca botasllata churaringuichi, ishcai churarinatas ama apanguichichu astahuan churarishcallahuan richi. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chasnallata rimara, Maican llactai puñungahua yaicushas shuc huasillata mascanguichi. Chi huasillai tiyanguichi chi llactamanda llucshinagama. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maican llactai cangunata mana uyanata munanaupiga chimanda llucshiushaga canguna chaquimanda chi llacta allpa pulbuta sáa picharinguichi paiguna mana ali rashcata ricuchingahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pai chasna rimashcahuasha pai japishca runaguna camachingahua rinaura. Camachiusha canguna juchata saquisha causaita cambiasha Diosta catichi nisha camachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chasnallata ashca supai yaicushca runagunamanda llucshichisha callpachinaura. Ungushcagunatahuas huirahuan uma jahuai talisha janbinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chi uras tucui partibi Jesus rashcagunamanda rimanaupi mandac amu Herodespaccama uyarira. Shuc runaguna rimanaura, Chi runa Bautisac Juan huañushcamanda causaric man nisha, chimandami pihuas mana rashcagunata ranatas Jesusca ushan ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Shuccuna randi rimaunaura, Cai runaga Dios rimashcata pasachic Eliasmi nisha. Shuccunaga rimaunaura, Callari uras Dios rimashcata pasachiccunacuintalla man paiga. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mandac apu Herodes tucui paiguna rimashcagunata uyasha rimara, Ñáuca ricucpi cai runaga Juandashinami yachihuan. Ñáucami paihua umata pitigri nisha mandarani. Cunanga causarishcami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chasna tucura. Amu Herodesmi Juanda japichingahua mandashca ara. Paita cadenahuan huatasha carcelbi tapashca ara Herodías nishca amuhua huarmi chasna munashcamanda. Chi huarmiga amuhua huauqui Felipehua huarmi mara. Chasna agllaita Herodes pai huauquita quichura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanga caran uras amu Herodestaga camachiura, Camba huauquihua huarmita can japishcaga mana alichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chiraicumanda chi huarmiga Juanda yapa piñara, huanchinata munashallata mana usharachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Amu Herodesca Juanda manzharami, pai ali runa man nisha, Diospacta rauc runa man nisha. Paihua huarmi huanchinamanda Juanda quishpichinata munasha carcelbi tapasha saquira. Pai camachishcata munaihuan uyara manzhashallata. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ñáa shuc punzha mandac amu Herodes pai pagarishca punzha pactaricpi shuc jatun jistata raura. Paihua gubirnu mandac amugunatas, sundaluta mandaucunatas, Galileamanda balic runagunatas cayara pariu micungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Micusha tiyaushcaibi Herodíaspa ushushi bailara. Pai bailashcata amu Herodes paihuan tiyaucunandi yapa gustanaura. Chasna gustashcamanda amu Herodes paita rimara, Can imatahuas mañacpi cushcanguimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Shuc pactachina shimita paita rimara, Ñáuca charishcagunata chaupi chaupita mañacpihuas cushcanguimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nicpi uyasha chimanda llucshisha paihua mamahuagma risha tapura, Imatata mañasha. Tapucpi paihua mama, Bautisac Juanba umata mañagri nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pai uctalla apuhuagma bulltiasha rimara, Cunanllata Bautisac Juanba umata shuc pulatui cuhuai, chillata munani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Amu Herodes chita uyasha yapa llaquirira. Astahuanbas chibi tiyaucuna ñaupacpi chi pactachina shimita rimashca asha mitsanata mana usharachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chi ratullata shuc sundaluta cachara Juanba umata apagri nisha. Paiga carcelma yaicusha Juanba cungata pitisha, ");
INSERT INTO qvzNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","shuc pulatui Herodíaspa ushushihuagma apara. Ushushi paihua mamama randi cura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanda catic runagunaga chita yachasha paihua aichata apagrisha pambanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chi Jesus chunga ishcai (12) camachingahua cachashca runaguna bulltiamusha paiguna tucui rashcagunata yachachishcagunatahuas paita cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chi uras ashca runaguna chibi shamunaupi micuna lugarbas mana tiyarachu. Chasna acpi Jesus pai japishca runagunata rimara, Jacuichi chaquishca pambama shugratu samangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chasna rimasha shuc canuaibi yaicusha chimbanaura runa illashca partima. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Astahuanbas runaguna paiguna maibi rishcata ricusha, piguna maibi anautas yachasha tucui llactagunamanda ñambita callpasha risha Jesusmandas ñaupa pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus canuamanda llucshisha ashca runagunata ricusha paigunata llaquira. Paigunaga ovejagunata cuirac illashcacuinta anaura. Chimanda paigunata ashca yuyaigunata unaita yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñáa chishiyaupi pai yachachishcaguna paita rimanaura, Ñáa chishi man, cai mayanllaiga huasiguna illanmi. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chasna acpi runagunata cachangui paiguna mayan huasigunaibi llactagunaibis micunata randigrinauchun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus randi paigunata rimara, Cangunallata caraichi. Chasna rimacpi ninaura, Manapacha, cai tucui runagunata carangahua nicpi pusac (8) quilla ganashcahuan pactanma. Yapa ashca patsac (100) cullqui tupu gastana tucushun tucui caigunata panda carangahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus tapura, Masna pandata charinguichi. Ricugrichi. Ricunaupi tiyara pichca (5) pan ishcai (2) challuahuas ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chita uyasha Jesus nira, Runagunata rimaichi allpai tiyarinauchun. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rimacpi runaguna chi quihua jahuai tiyarinaura, shuc muntunbiga patsac (100) tucusha, shuc muntun pichca chunga (50). ");
INSERT INTO qvzNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chihuasha Jesus chi pichca pangunata ishcai challuagunatas japisha, jahuama ricusha, Diosta pagrachu nira. Chi pangunata paquisha paihua japishca runagunama cura tucui chi runagunata randi carangahua. Chasnallata chi ishcai challuamandahuas tucuigunata caranaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tucui runaguna sacsacta micunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Micushcahuasha puchucta japisha ricunaura chunga ishcai (12) ashangata jundachinaura paigunas micuna tuputa. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chi micuccuna anaura carimuilla pichca huaranga (5.000) tupu. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chihuashalla Jesus pai japishca runagunata rimara, Ñáuca cai runagunamanda dispirinagama ñucamandas ñaupa canuahuan chimbaichi Betsaida llactama. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chi runagunata dispirishcahuasha Jesus shuc urcuma rira Dioshuan cuintanacungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Chaupi tutaibi canuai riucuna chara chaupi cuchaibi aunaura. Jesus chara allpaibi sapalla saquirishca ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Paiguna riushcai ñahuipuramanda sinzhi huaira shamucpi sinzhita cahuingahua callarinaura. Punzhayanata paiguna chasna sinzhi cahuiushcata ricusha Jesus yacu jahuata purisha paigunahuagma pactaura. Pactaushallata mas caruma riucuinta tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Paiguna randi yacu jahuata puriuta ricusha manzharisha ayami nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tucuiguna paita ricusha manzharinaura. Chasna manzhariunaupi uctalla rimara paigunata, Ñáuca mani, ama manzhaichichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pai canua ucuma yaicushcahuan huaira saquirira. Chita ricusha manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pai panda chasna mirachishcamanda chara mana intindinaura. Paiguna yuyaibi mana yachashcacuinta aunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ñáa paiguna cuchata chimbasha Genesaret nishca partima pactasha llutarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Canuamanda llucshishcaibi runaguna Jesus auta yachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chasna yachasha tucui partima rinaura Jesus shamushcami nisha rimangahua. Chasna rimanaupi ungushcagunata pai aushcama apasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus maita purishcais llacta ucugunais, llacta mayanllais pai pasana ñambibi ungushcagunata apamusha churac anaura. Ungushcaguna nic anaura, Camba llachapa pundahuallatas llanganata lugarta cuhuai nisha ruganaura. Chasna tucui paita llangaccuna aliyachishca tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chi uras fariseoguna, Moises mandashcagunata yachachic runagunandi Jerusalenmanda shamusha Jesuspagma pactamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesus japishca runaguna ñaupa apayayaguna yachachishca tunuta mana maquita maillarisha micunaura. Fariseoguna chita ricusha piñanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chi fariseogunaga tucui israelgunandi ñaupa apayayaguna yachachishca tunuta mana maquita maillarishaga mana micucchanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chasnallata randigrishcahuasha huasima cuti bulltiamusha, paiguna yachai tunuta maillarisha micuc anaura. Huañuc apayayaguna ashca yachachishcagunata catisha casna raunguna: pillchigunata paigunacuintallata maillasha, mangagunatas jirmangagunatas maillaccuna aganaushca paiguna apayaya yachachishcacuintallata rasha. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chasna acpi fariseoguna chi Moises mandashcagunata yachachiccunandi Jesusta tapunaura, Imangahuata can japishca runaguna callari apayayaguna yachachishcacuintataga mana ranaun. Chasna rana randimanda maquitas mana paigunacuinta maillashachu micunaun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Paiguna chasna tapucpi Jesus rimara, Yanga llullasha puriccuna anguichi. Dios rimashcata pasachic ñaupa causac Isaias cangunamanda sirtuta rimara casna quillcasha, Diosmi nira, Cai runaguna paiguna shimillahuanmi ñucata llaquihuanaun, randi paiguna shunguga ñucamanda caruibi maun. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñáucata llaquiucuinta yanga alabahuanaun. Ñáuca mandashcacuinta paiguna yachachishca shimiga runa yuyaimandallami shamun. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Cangunahuas Dios mandashcagunata jichushami runa yuyaigunallata catiunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maspas paigunata rimara, Randiga canguna Dios mandashcata mana balichinguichichu canguna quiquin yuyaita catisha nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Huañuc Moises casnami rimara: Camba yayatas, camba mamatas uyana mangui. Chasnallata rimara: Maican runas paihua yayata paihua mamata camisha jiridsata nisha rimashaga paiga huiñai huañunama ringa nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Canguna randi rimanguichimi, shuc runa paihua yayatas mamatas ñuca charishcataga Diosma ña cushcanimi, cunanga cangunata yanapangahuaca mana imahuas tiyahuanzhu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chi runa chasna rimasha paihua yayagunata mana yanapanachan nishami yachachinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Canguna chasna rashaga Diospa shimita mana balichinguichichu canguna apayayagunahua yuyaita pactachiusha. Ashcagunata chicuintallatami ranguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chihuasha Jesus tucui runagunata mayanllayaichi nisha rimara, Ñáuca rimashcata uyaichi tucuiguna. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pagllamanda runa ucuma yaicuc micunaga runata mana juchayachinzhu. Astahuanbas runahua yuyaimanda llucshiccunami runata juchayachin. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yuyaiyuc runa ashaga chita yuyarichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chasna nisha Jesus runagunata pagllai saquishcahuasha huasi ucuma yaicura. Yaicucpi pai japishca runaguna paita tapunaura, Can chasna rimashaga imatata yachachishcangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tapucpi rimara, Cangunahuas manachu yachanguichi. Pagllamanda runa ucuma yaicuccunaga pitas mana jiridsayachingachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pagllamanda yaicuccunaga mana shunguma yaicunzhu, astahuanbas huicsama yaicusha, chihuasha ishpacpiga llucshinalla. Jesus chasna rimasha nira ima tunu micunas ali micunalla man nisha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chihuasha nira, Runa shungu ucumanda llucshica runata jiridsayachingami. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Runa shungu ucumanda mana ali yuyarina llucshinmi. Chasnallata llucshinaun jiridsa ranaguna, shucpa huarmita munana, shuhuana, runata huanchina, ashiyana, amullata yuyarina, piñasha ranaguna, llullana, umana, mana pingarisha causana, tumbaisiqui causana, camina, alabarina, nuspacuinta causana. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tucui caiguna runa shungu ucumanda llucshiccunami runata jiridsagunata yuyarichinga. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chimanda llucshisha Jesus Tiro llactamanda isquinama rira. Pactasha shuc huasima yaicura ama pihuas ñuca caibi auta yachanauchun nisha. Astahuanbas musianaura chibi auta, pacarinata mana usharachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Shuc huarmi Jesus ña shamushcata yachasha paihuagma shamura. Cai huarmiga mana israelmanda huarmi chara, randi Sirofenicia nishca llactamanda huarmi ara. Paihua ushushita supai yaicushca acpi Jesuspagma shamura chita llucshichipachun nisha rugangahua. Pactasha cungurisha rugara, Supaita ñuca ushushimanda llucshichipai nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Rugagllaita Jesus paita rimara, Ñáucaga israelgunata ñaupata yanapana ani. Paigunami Diospa huahuagunashina anaun. Canda ñaupata yanapacpiga huahuaguna micunata quichusha allcugunama cushcashina tucunga. Chasna racpiga mana balinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Rimacpi huarmi nira, Sirtu chasna man señor. Chasna ashahuas mesa ucui allcuguna sirisha huahuaguna jichachishcata micunaun. Chasna jichachishcata micushcacuintallahuanbas yanapahuai señor. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Huarmi rimashcata uyasha Jesusca, Rilla nira, can chasna rimashcamanda camba ushushihua ucumanda supai ña llucshishcami. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chi huarmi huasima pactasha paihua ushushi cayutuibi ali siriuta tupara. Supai paimanda sirtu llucshishca mara. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro llactamanda Jesus llucshisha Sidón llactata pasasha Galilea cuchama risha Decapolis nishca llactagunama pactara. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chibi shuc mudu rinri upa callu runata Jesuspagma apamunaura, Camba maquita paihua jahuaibi churapai nisha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus paita isquinama pushasha paihua maqui riruta chi runahua rinri juctuma barara, chihuasha tiuca yacuhuan chi runahua calluta cacura. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chihuasha jahuama ricusha ai nisha, llaquirisha efata nisha rimara. Chasna nishaga runa shimibiga pascari nishami nin. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesus rimashcahuan chi runahua rinri pascarirami, paihua callu aliyasha alita rimangahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chasna janbiricpi Jesus chi ricuccunata mandara, Ama caimanda pitahuas rimanguichichu nisha. Paiguna randi tucuigunama cuintagrinaura, Jesus ama pitahuas cuintanguichichu nishca agllaita. ");
INSERT INTO qvzNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chi ricuccuna yapa manzharisha cuintanacunaura, Tucuitami alita rashca, mudu rinrigunatas uyachin, upa callu runagunatas rimachin nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Shuc punzha ashca runa tandarisha Jesusta catiushcai illara micuna. Illacpi Jesus pai japishca runagunata cayasha rimara, ");
INSERT INTO qvzNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Cai runagunata ricucpi yapa llaquinayahuan nira. Ñáa quimsa (3) punzhata ñucahuan tiyaushcamanda cunan micunatas mana charinaunzhu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Paigunata mana carasha huasima cachacpiga, bulltiausha sambayasha huañunaungami. Maicanguna carumandami shamushcauna nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Randi pai japishca runaguna paita rimanaura, Cai pambaga huasi mana tiyaushca pambachan. Imasata caibi ali tupu micunata tupangaraunchi cai tucui runagunata carangahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tapunaupi randi Jesus tapura, Masna pandata charinguichi. Canzhislla (7) maun nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chi rimashcata uyasha tucui runagunata tiyarichi nira. Chihuasha chi canzhis (7) panda japisha Diosta pagrachu nira. Chihuasha pangunata paquisha pai japishca runagunama cura paiguna randi runagunata caranauchun nisha. Chasnami ranaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chasnallata ashilla yacu aichatahuas charinaura. Chimandahuas Diosta pagrachu nisha pai japishca runagunama cura runagunata caranguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tucui chi runaguna sacsacta micunaura. Chihuasha pai japishca runaguna puchushcata tandachicpi canzhis (7) ashangaibi jundachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chi micuc runagunaga chuscu huaranga (4.000) tupu anaura. Ñáa micushcahuasha Jesus paiguna huasima cachara. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chihuasha pai japishca runagunandi canuaibi yaicusha Dalmanuta nishca pambama chimbanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseoguna Jesusta piñasha camangahua nisha pactamunaura. Paita camausha mandanaura, Can sirtu jahuapacha ushaita charic ashaga pihuas mana raushcata rasha ricuchihuai ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Paiguna mandanaupi Jesus jahuama ricusha, llaquirisha rimara, Imamandata cai runaguna pihuas mana rashcataga ñuca rachun nisha nihuanaun. Mana ima uraspas chasna ricuchinataga rashachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chasna nishami fariseogunata chillai saquisha cutillata canuaibi yaicusha chimba partima chimbara. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesus japishca runaguna panda apanata cungarinaushca ara, shuc panllata canuaibi charinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ñáa chimbama riusha paigunata nira, Ali yuyarisha causaichi. Fariseogunahua panda putasyachinamanda Herodespacta putasyachinamandahuas yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chasna nicpi paigunapura cuintanacunaura, Pai chita ninmi ñucanchi panda mana apamushcata ricusha. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chita uyasha Jesus nira, Imamandata rimanacunguichi panda mana charinchichu nisha. Chara manachu yachanguichi, ñuca yachachiushcata manachu intindinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ñáahuiyuc ashallata manachu ricusha yuyaringuichi. Rinriyuc ashallata manachu uyasha yuyaringuichi. Yuyai illacchanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pichca (5) panmandallahuan pichca huaranga (5.000) runagunata carashca uras, masna ashanga puchushcatata tandaranguichi. Tapucpi chunga ishcai (12) ashangata nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Cutillata tapura, Huasha chi canzhis (7) panmandallahuan chuscu huaranga (4.000) runagunata carashcaibi, masna puchushcatata tandaranguichi. Tapucpi canzhis ashangata nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chasna ninaupi tapura, Chara manachu intindinguichi. Mana micuna panmandachu rimani astahuan yachachinamandami rimani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus pai japishca runagunandi Betsaida nishca llactama pactaushcaibi shuc puyuñahui runata Jesuspagma apamunaura, paita llangapai nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus chi runata maquimanda japisha llactamanda pagllama apara. Paihua ñahuigunata tiuca yacuhuan jucuchisha, paihua jahuai maquita churasha tapura, ");
INSERT INTO qvzNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Imatahuas ricunguichu nisha. Puyuñahui runa ashillahuata ricungahua callarisha nira, Runagunata ruya puriuctashina ricuuni. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chasna nicpi Jesus cutillata paihua maquita chi runahua ñahuibi churara. Chasna cuti rashcahuan chi puyuñahui runa ña alita ricura, paihua ñahui aliyashca tucura ña carumanda tucuita alita ricura. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chasna tucucpi Jesus paita huasima cachara, Ama chi llacta ucumaga yaicunguichu nisha, ama pitahuas rimanguichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chimanda llucshisha Jesus pai japishca runagunandi Filipo Cesarea nishca partibi auc llactagunama rira. Ñáambita riusha paigunata tapura, Imasata ñucamanda runaguna rimaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tapucpi rimanaura, Shuc runaguna Bautisac Juan man nishami rimaunguna, shuccunaga Dios cuti cachangaraushca ñaupa causac Elias man nishami rimanaun. Shuccunaga Dios rimashcata shuc pasachic man nishami rimanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chasna ninaupi tapura, Cangunaga pi man nishata ñucataga yuyaringuichi. Pedro, Can quishpichic Cristo mangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chasna nicpi Jesus paigunata mandara, Cunanga chitaga ama pitahuas rimanguichichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chihuasha paigunata yachachingahua callarira chasna nisha, Ñáuca Runa Tucuc asha, turmintarishca tucuna mani. Ñáucanchi israelgunata mandac rucugunas, pagri amugunas, Moises mandashcata yachachiccunahuas ñucata mana balichisha huanchihuanaungami. Chasna ragllaita quimsa (3) punzhaibi causarishami. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chasna tucungaraushcamanda pasacta rimara. Pedro chita uyasha Jesusta chinayama apasha paita sinzhita rimara chiga imata tucushun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus bulltiarisha tucui japishca runagunama ricusha, Pedrota randi mandara, Ñáucamanda anchuri supai. Camba yuyaiga mana Diospagmandachu, runa yuyaimanda man nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chihuasha tucui chibi tiyauc runagunata, pai japishca runagunatahuas cayasha Jesus rimara, Pihuas ñucata catinata munasha amuhua munaigunata saquichun, paihua crusta aparishcacuinta ñucata catichun. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pihuas ñucamandas, ñuca quishpina shimimandahuas paihua quiquin causaita chingarichun nishaga, paihua causaita quishpichishca tucungami. Randi pihuas paihua quiquin causaita quishpichisha nishaga paita chingachishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Shuc runa cai pachaibi ashcata ganasha paihua quiquin causaita huiñai chingachishaga imangahuata balin. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Shuc runa paihua causai randimanda imatata cunga. ");
INSERT INTO qvzNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pihuas cunan uras juchayuc runagunahua ñaupacpi ñucamandas ñuca shimimandahuas pingaricpiga ñuca Runa Tucuc asha ñuca sumac angelgunahuan shamuna punzhaibi ñuca yayahuacpi chi runamanda pingarishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Caibi tiyaucunamanda maican canguna chara mana huañushallata, Diospa ali mandanaga jatun ushaihuan shamushcata ricunguichimi nisha paigunata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chasna yachachisha Jesus sucta (6) punzhahuasha Pedrota, Jacobota, Juanda apasha paigunallahuan shuc jahua urcuta sicara. Chibi paiguna ricuushcai shuc tunu tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Paihua llachapa chuyaclla ricurisha, ruyaglla tucura. Cai pachai mana pihuas chasna yapa ruyagyachinata ushan. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chillaita ñaupa causaccuna Moises Eliasndi Jesushuan cuintanacuuta ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro chita ricusha nira, Caillaita saquirishaga ali anchima señor. Quimsa (3) ranchugunata rashun, cambacta shuc, Moisespacta shuc, Eliaspacta shuc. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro chasna yapa manzharisha imata rimanatas mana yuyarirachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Cungaimanda shuc puyu uraicusha paigunata catara. Chi puyumanda shuc shimi uyarira, Caimi ñuca llaquishca churi, paitami uyana anguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huasha, caran partima ricucpias Jesus sapalla shayaura, chi shuccunaga illanaurami. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Urcumanda uraicushcai Jesus paigunata nira, Cunan canguna ricushcata pitahuas ima rimanguichichu ñuca huañushcahuasha causarinagama. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chi shimita yuyariushallata mana pimahuas rimanaurachu. Paigunapura randi tapunacunaura, Huañushcahuasha causarina nishcaga imatanya pai chasna nishca. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Paiguna uraicuushcai Jesusta tapunaura, Imangahuata Diospa shimita yachachic runagunaga Eliasca ñaupa shamuna man nishaga rimaganaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tapucpi Jesus rimara, Elias sirtu ñaupa shamuna man, shamushami tucuita alichinga. Diospa shimita quillcaccuna Runa Tucucmanda imatata ninaura. Casnami, Runa Tucuc nishcaga yapa turmintarishca piñaitucushca manga nisha quillcanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Cangunata nini, Elias ña shamui pasarami. Paitaga amuguna paiguna munashcata rasha huanchinaura Diospa shimibi ñaupa quillcashcashinami tucushca nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ñáa chi saquishca pai japishca runagunahuagma pactamushcai yapa ashca runaguna paigunahuan anaura. Moises mandashcata yachachic runaguna paigunahuan piñarishcashina rimanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesusta ricusha chi runaguna manzharisha saludangahua callpanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Paigunata tapura, Imatata rimanacuranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Tapucpi chi muntunmanda shuc runa nira, Supai ñuca churita yaicushcamanda mana rimacta saquin. Chi supai paita allpama urmachin, shimimanda putscutas llucshichin, quiruta tái canichin, pai huañushcashina tucun. Chiraicu cambagma ñuca churita apamurani señor. Can illacpi can japishca runagunata rugarani supaita llucshichipaichi nisha, randi mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rimacpi Jesus nira, Cangunaga ñucata chara mana quiric runa anguichi. Ima urascamata cangunahuan tiyausha ahuantasha. Chi musutaga apamuichi, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chasna nicpi apamuushcai supaiga Jesusta ricusha chi musuta ataquita rasha sinzhita cushpachisha allpama urmachira. Chasna racpi chi musu runa allpai siriura cushparisha, paihua shimimanda putscu llucshisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Musuhua yayata Jesus tapura, Ima urasmandata chasna tucura. Tapucpi nira, Huahua urasmandami casna tucupara. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Imasnaiga nina ucuibihuas urmachin, yacuibihuas, paita huanchisha nisha. Can ushashaga ñucanchita llaquisha yanapahuai. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Rimacpi Jesus nira, Imaraicuta can ushashaga nisha ningui. Quiric runaga tucuitami ushan. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chita uyasha chi runa caparira, Quirinimi, ñuca quirishcata sinzhiyachipai, mas yuyaita cuhuai. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus ashca runa tandarimuushcata ricusha supaita mandara, Mudu rinri supai canda nini, cai musumanda llucshisha ama cuti yaicunguichu. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mandacpi supai chi musuta sinzhita cushpachisha caparisha llucshira. Chi musu huañushcashina siririra. Shuccuna chita ricusha huañushcami nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Randi Jesus paita maquimanda japisha aisacpi shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chihuasha Jesus pai japishcagunandi huasima pactacpi paita pacalla tapunaura, Imangahuata ñucanchiga supaita llucshichinata mana usharanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tapupi rimara, Chi tunu supaigunata sasishcahuan Diosta tapushcallahuanmi llucshichinata ushanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Chimanda llucshisha Galilea partita purinaura, paglla partillai purinaura pai japishca runagunata pai huañunamanda yachachisha nisha. Chi llactagunai aucuna pai chibi auta musiasha ñucanchita ama quillachinauchun nisha llactagunaibi mana yaicusha pasasha riunaura. Chasna puriupi paihua runagunallata pai huañunamanda yachachira casna nisha, Ñáucata piñac runaguna maquibi japitucungarauni. Paiguna huanchihuanaungami. Chasna ashahuas huanchishcahuashaga quimsa (3) punzhaibimi causarisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Paigunaga pai rimashcata uyashallata mana intindinaurachu. Mana intindishahuas paitaga tapunata manzhanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ñáa Capernaun llactama pactausha huasi ucui yaicusha Jesus tapura, Imamandata ñambibi cuintanacumuranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tapucpi chunlla anaura. Shamuushcai paigunapura maican mas balic agmanda cuintanacunaura. Chiraicu Jesus tapucpi pingarisha chunlla anaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chasna acpi Jesus tiyarisha pai chunga ishcai (12) japishca runagunata caillayachisha rimara, Mas balic tucusha nic runaga tucui runagunamanda mas pishitucuchun, tucuigunataga yanapac achun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chihuasha paiguna ñaupacpi shuc huahuata cayasha marcasha paigunata rimara, ");
INSERT INTO qvzNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Maican runaga ñucata llaquishcamanda cai huahuatashina llaquisha japishaga ñucatas japihuaunguimi. Pihuas ñucata japishaga ñucata cachac Diostahuas japingami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chimanda Juanmi Jesusta rimara, Shuc runata tuparanchi señor, camba shutihuan supaigunata llucshichic acta. Randi pai mana ñucanchi muntunmanda acpi ama chasna raichu nisha rimaranchi. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Randi Jesus paigunata nira, Ama paita jarcaichichu. Ñáuca shutita japisha pihuas mana rashcagunata ñuca ushaihuan rauc runaga ñucata mana piñahuangachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pihuas ñucanchita mana cuntar ashaga ñucanchipurallatashina man. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pihuas canguna ñuca Cristo nishca shutita quirisha catic ashcamanda cangunata shuc pillchi yacullahuas cucpiga ali pagashcacuinta tucunga, Yaya Dios sirtu paita alita cungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Huasha Jesus nira, Maican runahuas cai huahuatacuinta ñucata quiric runagunata pandachisha juchama apasha juchata rachicpiga paihua cungaibi shuc jatun rumita huataitucusha chaupi cuchaibi tucsinaupi chucacpi mas alichari anma. Pai sirtu mas ashca turmintachishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","47","Camba maquiga canda juchama urmachinata callaricpi chi maquita piti. Ishcai maquiyuc ucupachama rina randimanda, jahuapachama pullu maqui yaicunaga mas ali anga. Ninaga chibi mana tucurinzhu. Camba chaquiga canda juchama urmachinata callaricpi chitas piti. Jahuapachama pullu chaqui yaicunaga mas ali anga ishcai chaquiyuc ucupachama rinamanda. Camba ñahui canda juchama urmachinata callaricpi chita llucshichi. Ishcai ñahuihuan ucupachama rina randimanda jahuapachama shuc ñahuillahuan rinaga mas ali anga. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chibiga nina mana tucuringachu chasnallata runa aichata micuc curu mana huañungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tucuigunami curishina ninai pichashca tucun. Chasnallata cachihuan salarishcashina ali tucun. ");
INSERT INTO qvzNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cachi ali man randi chamuc tucucpi imamandata cuti alichinga. Ali cachishina aichi. Cangunapura cungailla causaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaun llactamanda llucshisha Jesus Judea provinciama pactara, Jordan yacu chimbama. Ashca runa cuti tandarinaupi cutillata yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Maican fariseoguna Jesusta pandachishun nisha camangahua tapunaura, Shuc runa paihua huarmita jichucpi alichan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus randi paigunatas tapura, Huañuc Moises cangunata imasata mandara. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rimanaura, Shuc runa jichuna quillcata huarmima cushaga jichunata ushanmi nishami huañuc Moises quillcara. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chasna rimanaupi Jesus nira, Canguna mana ali ashcamanda Moises chita nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Randi cai pacha callarishca urasmanda Dios caritas huarmitahuas rara. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Chiraicumandami huarmita japisha paihua mamatas yayatas saquisha paihua huarmihuan llutarisha ishcandi shuc aichalla tucungami. Ñáa mana ishcaichanaun, shugllami tucunaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chasna acpi Dios canma huarmita cushcata ama jichunguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ñáa huasima pactasha pai japishca runaguna pai rimashcamanda tapunaura imasata yachachingui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus paigunata nira, Maicanbas quiquin huarmita jichusha shughuan llutarishaga ashiyanmi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chasnallata huarmihuas quiquin carita jichusha shughuan llutarishaga ashiyachinmi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chihuasha huahuagunata Jesuspagma apamunaura, Camba maquita ñucanchi huahuaguna jahuai churasha Diosta tapupai ali anauchun nisha. Randi chi huahuagunata apamuc runagunataga Jesus japishca runaguna piñasha jarcanata munanaura ama paita quillachichichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chita uyasha Jesus piñarisha huahuagunata ñucahuagma shamunata ama jarcaichichu, casilla ricuichi nira. Diospa ali mandanaibi auc runaguna cai huahuagunashina manaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cangunata caita sirtu nini: Maican runa shuc huahuacuinta Diospa ali mandanata mana munacpiga mana ima uraspas chibi yaicungachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chihuasha Jesus huahuagunata cayasha paiguna jahuaibi paihua maquita churasha, Dios yanapasha paigunata alita rachun nisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chi huasimanda llucshiushcai shuc runa Jesuspagma callpamura. Jesuspa ñaupacpi cungurisha tapura, Señor ali yachachic, imatata rasha huiñai causaita charisha nishaga. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tapucpi Jesus rimara, Imangahuata ñucataga ali nisha rimahuangui. Shugllami ali tiyan, paiga Diosmi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Canga Dios mandashcagunata ña yachanguimi: Ama runata huanchinguichu, shucpa huarmita ama ashiyanguichu, ama shuhuanguichu, ama shuccunamanda llullasha rimanguichu, ama shuccunata umanguichu, camba mamatas yayatahuas llaquina mangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nicpi uyasha chi runa nira, Chi tucuigunata huahua urasmanda pactachishcanimi señor. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chasna rimacpi Jesus paita llaquishcahuan ricusha rimara, Chara canda shucpas pishinmi, tucui can charishcagunata randichisha pugri runagunama cugri. Can chasna rashaga jahuapachaibi Dios cungaraushcata charic tucunguimi. Chasna raipasasha ñucata catisha purihuangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chi runa Jesus rimashcata uyasha, yapa ashcata charic ashcamanda llaquirisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pai riupi Jesus pai japishcagunata ricusha rimara, Charic runaguna Diospa ali mandanai yaicungahua nicpiga sinzhi man. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chita uyasha pai japishcaguna yapa manzharinaura. Jesus cutillata nira, Cullquita llaquisha causaucunaga Diospa ali mandanai yaicunata mana ushangaunachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Shuc camello nishca jatun aichaga abuja juctui yaicunata mana ushanzhu. Chimanda yali sinzhi man shuc cullquita llaquic runa Diospa ali mandanai yaicungahua nicpi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Paiguna chita uyasha astahuan manzharisha tapunacunaura, Charic runaguna mana ushacpiga pita quishpinataga ushangaya. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tapunacucpi Jesus paigunata ricusha rimara, Runa quishpinata mana ushaibacchan randi Yaya Diosmi tucuita ranatas ushan. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro paita rimara, Canda catingahua nisha ñucanchi tucui charishcagunata saquishcanchimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Chasna rimacpi Jesus nira, Sirtu cangunata nini, maican runahuas ñucaraicumanda, Dios quishpichina shimiraicumandahuas paihua quiquin huasita, huauquigunatas, panigunatas, mamatas, yayatas, churigunatas, allpatas saquishaga, pai tucuita saquishcamanda cai pachallaita shuc patsacta (100) yali cushca tucunga caigunata: huasiguna, huauquigunas, panigunas, yayagunas, mamagunas, churigunas, allpatahuas cuitucunga. Chasnallata cunan uras ashca turmintachishca tucunga, huasha mushuc munduibiga chi runa huiñai causaita charingami. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cunan uras chi balichishca aucunaga huasha mana balichishcachu tucungauna. Chasnallata cunan uras mana balichishca aucunaga huasha balichishca tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalenma riusha Jesus pai japishcagunata ñaupasha riura. Paigunas, paihuan pariu shamuccunahuas, yapa manzharisha catiunaura. Jesus pai japishca chunga ishcaita (12) isquinama apasha paita rangaraushcata cuintara chasna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Uyahuaichi. Jerusalen llactamami riunchi. Chibi ñuca Runa Tucuc acta japishca tucungarauni. Chibi pagri amugunama, Moises mandashcagunata yachachiccunama cushca tucungarauni. Paiguna ñucata caudsayachisha mana-israelgunama apahuanaungami paita huanchichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ñáucata asisha tiucasha libachisha huanchihuangaraunguna. Chasna huanchicpihuas quimsa (3) punzhaibi causarishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeoba ishcai (2) churiguna, Santiago Juandi Jesusta tapunaura, Ñáucanchi mañangaraushcata rapangui señor. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tapunaupi paigunata tapura, Imatata munanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tapucpi ninaura, Can jahuapachai mandaushcaibi ñucanchita camba mayanbi tiyachihuangui. Shucta camba ali maqui partima, shuctaga camba lluqui maqui partima tiyarichipangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chasna rimanaupi nira, Canguna tapuhuashcatas mana intindinguichichu. Ñáuca jayac yacuta upishcacuinta cangunahuas ñucashina turmintarinata ushanguichichu, ñuca huañungaraushcacuinta huañunatas munanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ushanchimi ninaura. Chita uyasha Jesus rimara, Sirtupacha ñuca turmintarinacuinta turmintaringuichimi, ñucatashina huanchitucungaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Randi ñuca ali maqui partima, lluqui maqui partimas tiyachinata mana ushanichu, ñuca Yayallami pai anllashcagunataga chibi tiyachingami, nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Shuccuna chi tapushcata uyasha Santiagotas Juandas piñanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus tucuigunata paihuagma mayanllachisha yachachira, Cai pacha amuguna paiguna runagunata turmintachiunguna, gubirnuguna paigunata sinzhita mandaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Cangunapura randi mana chasnachu rana anguichi, astahuanbas maicanbas shuccunamanda yali tucunatas munac ashaga shuccunata yanapachun. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chasnallata cangunapuramanda mas balic nishca tucusha nisha, tucui chi shuccunata shuc mandashcacuinta yanapana manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ñáuca Runa Tucuc asha mana cuirahuanauchun nisha shuc jatun mandac tucungahua mana shamuranichu, astahuanbas shuccunata cuirasha yanapangahuami shamurani. Tucuigunahua dihuita pagashcacuinta ñuca huañungahua shamurani ashca runaguna juchamanda quishpichisha lugar causaita charinauchun nisha shamurani nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chimanda risha Jerico llactama pactanaura. Jesus pai japishca runagunandi, yapa ashca paita catiugunandi chi llactamanda llucshisha shuc puyuñahui runata tupanaura Timeohua churi Bartimeo nishcata. Chi runaga puyuñahui runa ashcamanda cullquita tapusha tiyaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chi puyuñahui runa Jesus shamuucta uyasha caparira, Jesus, can israel rey amu Davidmanda mirai ashcamanda ñucata yanapahuai. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Shuccuna, Chunlla ai, ama caparichu nisha piñanaura. Randi paiga mas sinzhita capariura, Israel rey amu Davidmanda mirai ashami ñucata yuyarisha yanapahuai. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Caparishcata uyasha Jesus shayarisha rimara, Chi puyuñahui runata apagrichi nisha. Rimacpi paita cayanaura, Cunanga cushiyasha jatari, Jesus candaga cayaunmi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chi puyuñahui runa chita uyasha paihua rigrai auc llachapata chillai shitasha Jesuspagma caillayara. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Caillayacpi Jesus paita tapura, Ñáuca imata rahuachun nishata munangui. Chi puyuñahui runa rimara, Ricunata munani, ñuca ñahuita alichihuai señor. ");
INSERT INTO qvzNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chasna nicpi Jesus paita nira, Rilla, can quirihuashcamanda ali tucunguimi nira. Jesus chasna rimashca ratullai ricunata ushara. Chasna alichicpi Jesusta catic tucura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalen llactama riushcai Olivos urcuibi tiyauc Betfagé Betania llactagunai caillayasha Jesus ishcai (2) japishcagunata cachara chasna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Canguna ñaupacpi auc ichilla llactama ringuichi. Chi llactai yaicusha shuc malta burro huatashca shayauta tupanguichimi. Paihua huashaibi pihuas chara mana tiyariushca achun. Chita pascasha apamunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maican runas cangunata imangahuata chasna ranguichi nisha tapunaupiga rimanguichi, ñucanchi amumi munan, mana unayachishachu cutichingami. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Paiguna risha burro ñambibi shuc pungu mayanbi huatashcata tupasha pascanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pascaupi chibi tiyauc runaguna tapunaura, Imangahuata chi burrota pascaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chi japishcaguna Jesus nishcashinata cuintacpi apailla ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chasna rasha Jesuspagma chi malta burrota apanaura. Paigunaga llachapagunata burro huashaibi mandasha Jesusta tiyachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Maican runaguna paita mandac amutashina rasha pai purina ñambibi llachapagunata mandanaura, shuccunaga ruya pangayuc pallcagunata chagragunai pitisha ñambibi shitanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ñáaupapunda riucunahuas, huasha puriucunahuas Jesusta catisha riusha caparinaura casna nisha, Dios cachashca shamuc ashami balichishca achun. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ñáucanchi huañuc apayayagunata mandac rey amu David mandashcashina pactamushcami canga mandangamiraungui. Jahuapachai auc Dios alabashca achun nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus Jerusalenma pactasha Diosta alabana huasima rira. Tucuita ricushcahuasha ña chishiyaupi pai japishca runagunandi Betania nishca llactama rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cayandi Betaniamanda llucshisha Jerusalenma riushcai paita raicachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Carumanda shuc pangayuc higo nishca ruyata ricusha chima rira muyuyucchari an nisha. Chara mana muyu aparina uras agllaita pangamuilla tiyaushcata ricusha caillayara ricungahua randi pangagunallata tupara. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chasna acpi Jesus chi ruyata nira, Mana ima uraspas cuti aparicchu tucungui runa micungahua. Chi japishcagunaga pai rimashcata uyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalenma pactasha Jesus Diosta alabana huasima rira. Chibi randichiucunata randiucunatas chimanda callpachingahua callarira. Chasnallata pai urmachira cullquita cambiachina mesagunatas, randichina palomagunata churashca taulagunatas. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tucui randichiucunatas jarcara Diosta alabana huasi partima yaicungahua nicpi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chasna rashcahuasha paigunata rimara, Manachu quillcashca tiyan, Ñáuca huasiga tucui runa muntun shamusha Dioshuan cuintana huasi nishca manga. Randi canguna shuhuana huasita rashcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesus rimashcata uyasha israel pagrigunahua amuguna, Moises mandashcagunata yachaucunandi tapunacunaura, Imasna rashata paita huanchishunchi nisha mascaunaura. Randi tucui runaguna pai yachachishcata cushihuan uyaunaupi paita manzhanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ñáa tutayaupi Jesus pai japishcagunandi llactamanda llucshisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cayandi tutamanda ñambita riusha chi higo ruyata chaquirishcata ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro chita ricusha nira, Ricui señor, can piñasha rimashca ruya chaquirishcami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chasna nicpi Jesus rimara, Yaya Diostaga quirichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Maican runahuas cai urcuta, can tiyaushcamanda anchurisha lamarma urmagri nisha rimacpi ringami. Chi runa paihua shungu ucuibi chasna tucuchun nisha quiricpi pai quirishcacuinta tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sirtupacha cangunata nini, Canguna imatahuas Yaya Diosta shunguhuan tapucpi ña japishcanimi nisha quirishaga cuitucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Canguna Yaya Diosta tapushcai shuc runa canda piñashcata yuyarisha, ñaupallata paita perdunasha cungaringui camba Yaya Dios canda perdunasha cungarichun. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Randi canguna shucta mana perdunasha cungaricpi canguna jahuapachaibi auc Yaya canguna juchagunatahuas mana perdunasha cungaringachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalenbi ña pactanaura. Jesus Diosta alabana huasi partibi puriupi pagri amugunas, Moises mandashcagunata yachaccunahuas, israelgunata mandac rucugunahuas paihuagma shamusha tapunaura, ");
INSERT INTO qvzNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ima ushaihuanda chigunata rangui. Pita canda chita rachun nishaga mandara. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus casna nira, Ñáucahuas cangunata shuc tapunata tapungarauni cutipahuaichi. Canguna cutipacpi ñucahuas pi ushaihuan caigunata ñuca raushcata cangunata rimashcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Rimahuaichi, pita Juandaga cachara bautisachun nisha. Dioschu paita cachara, runagunachu paita cachara. Chita rimahuaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chasna tapucpi paigunapura rimanacunaura, Diosmi paita cachara nisha rimacpiga pai ñucanchita rimanma imangahuata Juanda mana quiriranguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Randi runaguna paita cachanaura nisha rimacpiga imasata ninga, nisha cuintanacunaura. Ñáa tucui runaguna Juanga Dios rimashcata pasachic runa mara nisha yuyarishcaunami. Runaguna chasna yuyaricpi chi amuguna manzhasha cutipanata mana munanaurachu, runaguna ñucanchita piñanaunga nisha manzhashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chasna acpi Jesusta rimanaura, Mana yachanchichu. Chasna rimanaupi Jesus randi paigunata nira, Canguna mana rimacpiga ñucahuas mana rimashcanguichichu ñuca pi mandashcahuan caita rauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chihuasha Jesus shuc yachachina shimita cuintangahua callarira casna nisha, Shuc runaga uvas nishca chagrata rasha quinzhara. Chasnallata chi uvas muyugunata chahuasha upinata rangahua shuc juctuta allara. Chasnallata shuc huasita jahuata shayachira shuhuangahua shamuc runagunata ricungahua. Ñáa tucuita alichishcahuasha shuc mañachishca runagunama paihua chagrata saquira pallana uras chaupi chaupita ñucama cachahuanauchun nisha. Chihuasha pasiangahua caruma rira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pallana uras pactaricpi chagra amu chi mañachishca runagunahuagma shuc cuirac runata cachara ñucahuacta apapagri nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Paiguna randi chi cuirac runata apangahua shamucta japisha libachisha imas illacta cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chihuasha shuc cuiractahuas cachara. Paitaga umai huactasha nanachisha piñasha jiridsagunata rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Shuctahuas cachara. Chitaga huanchinaurami. Chihuashas mas ashca runagunata cachara. Chigunatahuas chasnallata libachinaura, shuccunata huactanaura, shuccunata huanchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Chara shuc runa puchura, chiga paihua churi mara. Paitahuas cachara, paitaga mana imatas ranaungachu nisha ñuca llaquishca churi ashcamanda paitaga uyanaungami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Astahuanbas chi churi pactacpi chi runaguna paigunapura cuintanacunaura, Caimi amuhua churi nisha, paimi amuyangaraun. Paita huanchishun chi pai japingaraushcagunata ñucanchillata amuyangahua nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chasna cuintasha paita japisha huanchisha paihua aichata pagllama shitanaura. Jesus chasna cuintasha yachachira. Cunan rimahuaichi nira, ");
INSERT INTO qvzNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Imasnata ranga chi amuga. Pai shamusha chi tarabaccunataga huinda huanchinga. Paihua chagrata shuccunama randi cunga. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Manachu Diospa Shimita ricushcanguichi. Casnami nin: Huasita shayachic runaguna mana balichisha jichushca istandiga punda shayachishcacuinta tucurami. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chitaga Dios rashcami. Chita ricusha ñucanchi cushi maunchi nin. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chi israel amuguna Jesus rimashcata uyasha ñucanchita uyachishami chasna riman nisha yuyarinaura. Chasna yuyarisha piñasha paita japinata munanaura huanchishun nisha, randi runagunata manzhasha huanchinata mana ushanaurachu. Chasna asha Jesusta saquisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chihuasha chi amugunaga shuc fariseogunatas, mandac amu Herodesta caticcunandi Jesuspagma cachanaura paita ima shimigunatas tapusha pandachingahua nisha. Pai pandacpi caudsayachishun nisha cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Paiguna Jesuspagma pactamusha rimanaura, Señor can mana llullashachu sirtuta rimasha yachachic aucta yachanchi. Mana pitas manzhasha pariulla chi tupullata ricungui. Runaguna Dios munashcashina causachun nisha sirtuta yachachingui. Chasna asha cunan rimahuai, ñucanchita mandauc romano gubirnu mandashca cullquitaga paima paganaga balinzhu, manachu balin. Paganachu, manachu pagana. Imata ningui can nisha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesusca paiguna paita pandachingahua nisha raushcata yachasha nira, Imangahuata ñucata camashun nisha shamunguichi. Shuc cullquita ricuchihuaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ricuchicpi paigunata tapura, Pihuactan cai cullquibi auc ñahui. Pihua shutitan caibi tiyauc. Tapucpi rimanaura, Romano amuhuac man. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chasna rimacpi Jesus nira, Amuhuacta amuma cuichi, Diospactaga Diosma cuichi nira. Pai rimashcata manzharishami uyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Israel muntunmanda maican saduceo nishca runagunaga Jesusta tapungahua shamunaura. Paiguna nic anaura huañushcahuasha cuti causarinaga mana tiyanzhu nisha. Chasna acpi shuc saduceoguna Jesusta tapunaura, ");
INSERT INTO qvzNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Señor, huañuc Moises quillcasha mandaitucushcanchi casna: punda huauqui shuc huahua illac huañucpiga paimanda quipa huauqui randi chi huaccha huarmita japina man paihua huañushca huauquihua allpa ama chingarichun nisha paihua shutita churanauchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cunanga imata ranatan. Canzhis (7) huauquipura anaura. Punda huauquiga shuc huarmita japisha randi mana churita tupashallata huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Paihua quipa huauqui chi huarmita japira, randi chasnallata churi illac huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tucui chi canzhis huauquiguna chi huarmillata japisha huañunaura. Ni shucpas mana huahuata tupanaurachu, churi illac huañunaura huinguna. Puchucaibi huarmihuas huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ñáa causarina punzhai chi huarmiga pihuactanga chi tucui canzhis paita japishca acpi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chasna cuintashcata uyasha Jesus paigunata rimara, Diospa shimita mana yachashcamanda pandaunguichi, Diospa ushaitas mana ricsinguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Huañushcaguna cuti causarishcahuasha carigunas huarmigunas mana japinacunaungachu, jahuapachaibi tiyac angelgunacuinta tucungaunami huarmi illac. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chi huañusha causarinamandaga huañuc Moises quillcashcata manachu ricushcanguichi. Chi sindiu ruyamanda Moisesta Dios rimara casna nisha, Ñáuca Abrahanba Isaacpa Jacobopa Dios mani. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pai chasna rimasha paiga mana huañushca runagunahua Dioschan. Astahuanbas chi quimsa (3) rucuguna huañushca ashahuas chara causanaunmi. Moises rimashcamanda yachanchi Yaya Diosca causaucunahua Dios man. Cangunaga chimanda pandaunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moises mandashca shimigunata yachachic runaga chi saduceogunata uyasha Jesus ali cutipashcata ricsisha Jesusta tapura, Tucui mandashca shimigunamanda maicanda mas yali ali balic an nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tapucpi Jesus nira, Mas balic mandashcaga caimi: Uyaichi israel runaguna, ñucanchi jatun Dios shuglla Diosmi. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Camba Diosta tucui camba shunguhuan, tucui camba almahuan, tucui camba yuyaihuan, tucui camba ushaihuanbas llaquina mangui. Caiga yali balic shimi man. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chimandahuashaga shuca casna nin: Camba quiquin aichata llaquishcacuintallata shuccunatahuas llaquina mangui. Chi ishcai (2) mandashcagunamanda shuc yalicta mandanaga mana tiyanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chi runa Jesus rimashcata uyasha nira, Alimi señor, sirtuta rimangui shuc Dios tiyan, paimanda shuca mas mana tiyanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Paita tucui shunguhuan, tucui yuyaihuan, tucui munaihuan, tucui ushaihuan llaquina mangui, shuccunata quiquin amu aichatacuinta llaquinami. Casna aichata rupachisha Diosma ricuchina randimanda, chasnallata Diosma imatas cuna randimanda, cai ishcai mandashca shimigunata pactachinaga yapa mas yali balin nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chi Moises mandashcata yachac runa ali yuyaihuan rimacpi Jesus paita rimara, Diospa ali mandanamanda mana caruichaungui. Chihuasha tucuiguna manzharisha mana pihuas Jesusta mas tapunata munanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus Diosta alabana huasibi yachachisha chibi auc runagunata tapura, Moises mandashca shimita yachachiccuna Cristoga rey amu Davidba churi ashcata imasna nishata ninaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidllata Diospa Samai paita casna yuyachicpi nira: Jatun amu Diosca ñucata mandactami casna nisha rimara: Ñáuca ali maqui partima tiyari ñuca tucui canda piñaccunata binsinagama tiyari nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Huañuc Davidllata Cristota amu nisha rimacpiga imasnata Cristoga Davidba miraimanda churi angaya, nisha Jesus paigunata tapura. Jesus chasna yachachicpi runagunaga cushihuan paita uyaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Huasha Jesus yachachiusha rimara, Moises mandashca shimigunata yachachic runagunamanda cuiraringuichi. Paiguna mas balic tucusha nisha suni llachapata churarinaun. Pulasaibi saludaitucunatas munanaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Balichishca tucunatas munasha israel tandarina huasigunaibis punda tiyarinata mascanaun. Chasnallata jista micunaibi punda mesaibi tiyarinata munanauna. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chasna agllaita huaccha huarmiguna allpatas huasitas quichunaun. Diosta yapa unaita mañanaun runaguna balichihuanauchun nisha. Chimandami paiguna mas ashcata taripashca tucunaunga nisha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Shuc punzha Jesus Diosta alabana huasibi tiyaura Diosma cumbirana cullquita tandachina cajun mayanbi runaguna shitashcata ricusha. Chibi tiyasha yapa charic runaguna chi cajunbi ashca cullquita churaushcata ricuura. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chasnallata shuc pugri huaccha huarmi shamusha mana ashcata charic ashallata mana balichishca cullqui ishcaillata (2) churara. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chita ricusha Jesus pai japishcagunata caillayaichi nisha paigunata rimara, Cangunata sirtuta nini, tucui cullquita churaccunamanda cai huaccha huarmi tucuimanda yalictami churara. ");
INSERT INTO qvzNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi cullquiyuccuna tucui munashcata randishcahuasha puchushca cullquitaga churac shamunaura nira. Randi cai huaccha huarmiga pai micuna randina cullquita tucui pai charishcatami illacta churara nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus Diosta alabana huasimanda llucshishcai shuc pai japishca runa nira, Ricui señor, jatun rumigunahuanmi huasishcauna, ali ricuric huasiguna manaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus randi paita rimara, Cunan jatun ali ricuric huasigunata ricunguichi, huashaga cai huasita tulacpi ni shuc rumihuas mana saquiringachu, illacta urmachishca anga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Paiguna puriusha Diosta alabana huasi ñahuipura tiyac Olivos nishca urcuma pactasha Jesus chibi tiyarira. Pedro, Jacobo, Juan, Andres paihuagma caillayasha pacalla tapunaura, Imasaita chasna tucunga. Ima tunu tucucpita ña pactautaga yachashun. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tapucpi rimara, Cuirarus purina manguichi ama umaitucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ashca runaguna ñuca shutita japisha shamungaunami ñucaga Cristo mani tucuita quishpichic mani nisha. Casna nisha ashcagunata umangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ama manzharinguichichu caibi guera tiyaunmi nisha uyaricpihuas, shuc guera carugunai uyaricpihuas. Chara agllaitami uyariungauna chigunaga. Chasna uyarigllaita tucurina uras chara mana pactarimungachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Shuc llacta shuc llactahuan guerata ranaunga. Shuc muntun runaguna shuc muntun runagunahuan huanchinacungaunami. Shuc llactagunaibihuas allpa cuyungaunami. Yapa raicaihuas tiyangami. Chasna turmintarinagunaga punda callarimunlla manga, pactarisha riunlla. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Chasna chi turmintarinaguna uyariupi puruntusha cuirarus causanguichi, cuiraringuichi, alichirisha aichi. Piñaccuna cangunata japisha apugunahuacpi apaitucunguichimi, israel tandarina huasibihuas libachitucunguichimi. Ñáucata catic ashcamanda jatun apuguna ñaupacpihuas apaitucunguichimi. Paiguna ñaupacpihuas ñucamanda rimanata ushanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mana chasna turmintarina pactariullaita tucui llactagunaibi Diospa quishpina shimita yachachina man. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cangunata apugunahuagma apanaupi chi ratullaita Dios cangunata yuyachishcata rimanguichimi, chiraicu canguna rimangaraushcata ama ñaupata yuyaringuichichu. Mana canguna yuyaimandallachu rimanguichi astahuanbas Diospa Samaimi rimachinga. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Shuc runa paihua huauquita apu huanchichun nisha cungami, chasnallata shuc yaya paihua churitahuas cungami. Chasnallata churiguna paiguna mamata yayatas piñasha huanchinauchun nisha cungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tucui runaguna ñucamanda piñaitucunguichi. Chasna agllaita pihuas ñucata sinzhita quirisha catisha mana saquishaga quishpingami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yuyarichi, cai quillcata ricuc runaga alita yuyarisha yachashca achun nini. Chi pandachisha nisha huaglichicca mana pai anaibi aupiga uctalla miticunguichi. Chi tucuna punzha Judea auccuna urcugunama miticunauchun. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Huasi jahuai tiyaucuna uctalla uraicusha richun chimandalla, ama huasi ucuma yaicunauchun imatahuas apangahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chagraibi tiyaucuna huasima ama bulltiamunauchun llachapagunata apangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ai, pugri huicsayuc huarmigunas, llulluhuayuc huarmigunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Diosta tapuichi chi miticuna uras ama tamia punzha achun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi punzhaguna yapa llaqui punzhaguna angami. Cai pacha callarishcamanda casna turmintus mana tiyashcachu, chasnallata mana ima uraspas chicuinta cuti tiyangachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dios chi punzhagunata mana pishiyachicpiga mana pihuas quishpishcachu tucunaunma. Chasna ashahuas Yaya Dios pai anllashca runagunata llaquishcamanda chi punzhagunata pishiyachingami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chi uras pihuas cangunata rimasha, ricui Cristo caibi maun nicpi, Cristo chibi maun nicpihuas paita ama uyanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cristo rimashcacuinta umaccuna ricurimungaunami, Dios rimashcata pasachisha camachic runa mani nisha llullasha rimaccunahuas puringaunami, pihuas mana raushcagunatas rasha runagunata umachingaunami. Chasna rasha Dios anllashca runagunatahuas ushaibaglla acpiga urmachisha nisha quillachingaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Canguna chita yachasha cuirarus causana manguichi. Ñáaupata canguna yachangahua cuintashcanimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chi llaqui pasashcahuasha indi ansa tucungami, quillahuas ansayanga. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Estrellascuna urmanaunga. Cielo cuyuringami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chi urasmi ñucaga Runa Tucuc asha puyu ucuibi shamucta tucuiguna ricuhuangaunami. Ñáucami ashca ushaihuan, sumac ricuric shamushami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ñáuca angelgunata cachashami tucui partimanda ñuca anllashca runagunata tandachigrichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Higo nishca ruya tucushcata yuyarichi. Llullu panga huiñacpi verano uras pactamuunmi nisha yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chasnallata canguna ñuca cunan rimashca shimi tucunata ricusha ña ñuca pactamunata yachanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sirtumi cangunata nini, Chita ricuc runaguna chara mana huañugllaita ñuca tucui chi llaquigunamanda rimashcaga pactaringami. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cai munduhuas cielohuas tucurisha chingaringami. Randi ñuca rimashca shimigunaga mana tucuringachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Chasna ashahuas ima punzhas, ima uraspas chasna tucunata mana pihuas yachanzhu. Angelgunahuas Diospa Churihuas mana yachanchichu, Yaya Diosllami yachan. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cangunaga puchucai punzha shamunata mana yachashcamanda cuirarus causana manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chi tucunaga shuc caruma riu runacuinta tucunga. Chi runa paihua huasita cuiraccunata ricupanguichi nisha saquin. Caranma quiquin pai tarabata cusha saquin. Pungüibi cuiracta saquisha alita ricusha causai nisha mandan. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chasnallata huasiyuc amu pactana uras mana yachashcacuinta cangunahuas chapasha tiyana manguichi. Chishita pactamungachari, chaupi tutachari, gallo cantashcaichari pactamunga, tutamandachari, ima uraspihuas. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yuyarisha causana manguichi ñuca cungaimanda shamushcaibi canguna ama puñushcacuinta ñuca tupangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ñáucata chapasha yuyarisha causaichi nishaga mana cangunallatachu rimauni astahuan tucuigunamami rimani. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua nishca chi mana putasyachishca panda micuna jista pactarinagama ishcai (2) punzha pishira. Ñáa pagri amugunahuan Dios mandashcagunata yachachic runagunahuan cuintanacunaura imasna rashata Jesusta pacalla japishun huanchingahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Shuccuna rimanaura, Jista punzhaibi japina mana balinzhu, runaguna ñucanchita piñangaunami ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Shuc punzha Betania llactai lepramanda janbishca Simon nishca runahua huasibi Jesus micuura. Micuupi shuc huarmi shamura yapa ali balic asnac yacu butita apamusha. Jesus tiyashcama pactasha chi butita pascasha Jesuspa uma jahuaibi talira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Shuccuna chita ricusha piñarisha paigunapura rimanacunaura, Imangahuata chi yapa balic yacuta chasna yanga talin. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chita randichishca acpiga shuc huata tarabashca cullquita yali llucshinmi pugri runagunata cumbirangahuaca. Chasna rimanacusha chi huarmita piñanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chasna rimaunaupi Jesus chi runagunata rimara, Chi huarmita ama piñaichichu, chasnalla saquichi. Pai rashcataga ñucaraicu alitami raun. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pugri runagunaga tucui uras cangunahuan tiyaungunami, canguna munashcai paigunatas yanapanata ushanguichimi. Ñáucaga randi mana unaita cangunahuan tiyashachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cai huarmiga pai ushashca tuputa rashcami. Ñáuca huañusha pambaitucunata yuyarishami chi yacuta ñuca aichai ñaupata talingahua shamuhuashca. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sirtumi cangunata rimani, tucui partibi Diospa quishpina shimita camachiusha pai rashcatas cuintacpi pai yuyarishca anga nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chi chunga ishcai (12) japishca runaguna shucca Judas Iscariotega, israel pagrigunata mandaccunahuagma rira paigunahuan cuintasha imasna Jesusta japichisha paigunama cungahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pai rimashcata uyasha pagri amuguna cushiyasha cullquita cushcangui ninaura. Chi urasmanda imasna rashata japichinata ushasha Judasca yuyarisha puriura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Israelguna mana putasyachishca panda micuna jista punzhagunai, ña ovejata huanchina punzha pactashcai, Jesus japishca runaguna paita tapunaura, Maibita munangui pascua jistata ñucanchi micungahua alichigrinata. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tapunaupi Jesus pai japishcapuramanda ishcaita cachara casna nisha, Llactama riusha shuc yacu mangata apauc runata tupangaraunguichi. Paitaga catinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pai yaicushca huasiyuc amuta rimanguichi, Ñáucanchita yachachic ninmi, maibitan pasiana cuarto ñuca japishcagunandi pascuata yuyarisha micungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Paiga jahua pataibi shuc jatun cuartota ricuchingami tucui ñucanchi minishtishcagunatas. Chibi micunata alichichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Rimacpi chi ishcai runaguna risha llactama pactasha Jesus rimashcacuinta tupanaura. Chasna acpi pascua micunata chillai alichinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ñáa indi yaicushcai Jesus pai chunga ishcai (12) japishcagunandi shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Paiguna micuushcai rimara, Sirtumi cangunata nini, cangunamanda shucca ñucahuan pariu micuucca ñucata japichihuangaraun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chita uyasha huinguna yapa llaquirinaura. Caran shuc shuc tapunaura, Ñáucachani, ñucachu candaga japichina ani nicpi. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Paigunata nira, Canguna chunga ishcaipuramanda shucca cai pulatullaita ñucahuan pariu paihua panda satiu. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dios ñucamanda quillcachishcacuintallata mana saquirisha ringarauni. Ai, chi ñucata japichiu runalla. Mana pagarishca ashaga ali anmara nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Paiguna micuunaupi Jesus panda japisha Diosta pagrachu nisha paquisha paigunama cuusha rimara, Japichi, caiga ñuca aicha man nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Huasha shuc vino yacuta jundachishca pillchita japisha Diosta pagrachu nisha paigunama pasachira tucuiguna upinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chasna rasha paigunata rimara, Caiga ñuca rahuaimi, Yaya Dios paihua runagunahuan mushuc pactachina shimita ricuchiu rahuaimi. Cai ñuca rahuai tucui runagunamanda talishca anga. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sirtumi cangunata nini, vino yacuta mana cuti upishachu ñuca Yaya ali mandanai shuc mushuc vinota upinagama nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ñáa paiguna micusha upishcahuasha Yaya Diosta alabasha cantanaura. Chihuasha Olivos nishca urcuma rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Riushcai paigunata nira, Cunan tuta tucui canguna ñucamanda anchuringaraunguichi. Diospa shimibi casnami nin: Cuiracta huanchicpiga ovejaguna sáa tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Chasna agllaita ñuca causarishami. Causarishcahuasha cangunata ñaupasha Galileama punda pactashami. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro chita uyasha, Tucuiguna canmanda anchurinaupihuas ñucaga canda catishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Rimacpi Jesus nira, Pedro candaga sirtumi rimani, cunan tuta gallo chara mana ishcai (2) cutin cantagllaita can quimsa (3) cutin ñucamanda llullangaraungui paita mana ricsinichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro randi, Canhuan pariu huañuna ashahuas canmanda mana chasna llullashachu nisha sinzhita rimara. Tucui chi shuccunahuas chasnallata rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chasna cuintanacushcahuasha Getsemaní nishca pambama rinaura. Chibi pactasha Jesus pai yachachiushcagunata nira, Caillai saquirichi, ñuca mas chinicshinai riuni Yaya Dioshuan cuintangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chasna nisha Pedrota, Santiagotas, Juandas mas chinicshinama pushasha rira. Chasna riushami pai yapa turbarisha llaquiricallarira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chasna tucusha paigunata nira, Ñáuca shungu ucuibi yapa llaquirishcamanda huañuunimi. Caillai saquirisha astallata chapahuaichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Rimasha mas chinigma risha tuhuama urmasha Yaya Diosta mañausha tapura cai tutaibi tucungaraushcata ñucamanda anchuchihuai nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chasnallata casnami Yaya Diosta tapura, Ñáuca Yaya, can tucuitami ushangui. Cunan cai jayacta upinashina sinzhi turmintarinata ñucamanda anchuchihuai Yaya. Randi ama ñuca munashcacuinta achun astahuanbas can munashcacuinta tucuchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Diosta tapusha bulltiamusha chi quimsandi puñuucunata tupara. Chasnata tupasha Pedrota nira, Puñuunguichu Simon. Shuc ura tupullatas nicchariashami chapanata manachu usharangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niccharishcashina yuyarichi. Dioshuan cuintasha causaichi ima jucha yuyai shamucpihuas chita ama rangahua, mana ali rana yuyai shamucpi ima tintais tucungahua. Canguna yuyai alita ranata munagllaita canguna aicha randi sambayashcashina mana ahuantacchan nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chasna rimasha cutillata Yaya Diosta tapungahua rira. Pai ñaupa tapushca shimigunallata mañara. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chiguna tiyaushcama cuti bulltiamusha ricucpi yapa puñunayauta tupara. Chasna asha ima rimanatas mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quimsa (3) cutin bulltiamusha paigunata nira, Charachu puñuunguichi. Basta puñushcanguichi. Cunanga juchayuc runaguna maquibi japitucuni. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jatarisha jacuichi. Ñáucata japichingarauc runa caibimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus rimaushcai Judas pactamura. Paiga Jesus chunga ishcai (12) japishca muntunmanda mara. Paihuan ashca runa shamunaura caspigunahuan espada sauligunahuan. Israel pagri amugunas, Moises mandashcagunata yachachiccunas, israelgunata mandaucunahuas chi runa muntunda cachashcauna ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas paigunata rimashca ara, Ñáuca muctishca runa paimi nisha, paita japisha sinzhita huatasha apanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chasna acpi Jesuspagma Judas caillayasha paita, Ñáuca yachachic, nisha muctira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mucticpi chi shuccuna Jesusta japisha huatanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesushuan tiyaucunamanda shucca espada saulita japisha pagriguna amuta cuirac runahua rinrita chiú pitira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus chi shamuc muntungunata nira, Shuhuac runachani canguna caspigunahuan sauligunahuan ñucata japingahuaca shamunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Caran punzha Diosta alabana huasibimi cangunahuan tiyaurani cangunata yachachisha. Chasna agllaita mana japihuaranguichichu. Chasna tucuunmi Diospa shimi pactaringahuaca nishami rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ñáa Jesusta japinaupi paihuan tiyaccuna manzharisha paita saquisha miticunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesusta catiu shuc musuga toallahuan pillurishca autas japinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Randi paihua toallata saquisha lluchu llushpirisha mutyu balunllahuan callpara. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesusta pagriguna amuhuagma pushanaura. Chibimi ashca pagri amuguna, israelgunata mandac rucugunahuas, Moises mandashcata yachachiccunahuas tandarishca anaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro carullai catisha rira huasi canzhagama. Chibi auc sundalugunahuan pariu nina cuchui tiyarira cunungahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chi pagri amuguna tucui taripaccunandi Jesusta huanchinata munasha shuc paita caudsayachingahua rimacta mascanaura. Randi mana tupanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ashca runaguna Jesusmanda llullasha rimaushahuas paiguna rimashcaga caran tunu mara. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Puchucaibi ishcai (2) runaguna llullasha casna rimanaura, Ñáucanchi pai rimashcata uyaranchi casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ñáuca cai Diosta alabana huasita runa rashcata tulashami, quimsa (3) punzhaibi shucta mana runa rashcatashina shayachishami nishami nira ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chasna rimagllaita mana shuc yuyaillahuanzhu anaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chasna rimaunaupi pagri jatun amu tucuiguna ñaupacpi shayarisha Jesusta tapura, Paiguna rimashcamanda imatata ningui can. Imangahuata cai tucuita canmanda rimagllaita mana rimangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesusca chunlla aura mana imatas rimasha. Chasna chunlla acpi pagri jatun amu cutillata tapura, Sirtu Quishpichic Cristochangui, balic Diospa Churichangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chita tapucpi Jesus rimara, Indá, chi mani. Shuc punzha ricuhuangaraunguichi ushac Dioshuan pariu ñuca tiyaushcata ñuca puyuguna jahuai shamuuctas ricuhuangaraunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chita uyasha pagri amu piñarisha paihua quiquin llachapata liquisha rimara, Imangahuata shuc rimacta munanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Cangunallata pai jiridsa shimita rimashcata uyashcanguichi, cunanga imatata ninguichi. Tucuiguna shugllashina caudsayachisha rimanaura, Paiga huañuna man. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Shuccuna tiyaucuna paita tiucangahua callarinaura. Paihua ñahuita tapasha huactasha paita tapunaura, Rimai, pita canda huactara. Chihuasha chi sundalugunahuas paita ucuma apasha paihua ñahuibi huactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Chasna Jesus huasi ucui aupi Pedro canzhai tiyaura. Shuc huarmi pagriguna jatun amuhuacpi tarabac huarmi shamusha Pedrota nina cuchui tiyauta ricusha nira, Cambas Nazaretmanda Jesushuan puric arangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro randi, Chi runata mana ricsinichu nira, can rimashcata mana intindinichu. Chasna rimasha llucshina pungu mayanbi riushcai gallo cantara. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chi tarabac huarmi Pedrota chibi ricusha chi shuc tiyaucunata nira, Chi runa Jesuspa muntunmandami. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro cutillata rimara, Mana paihua muntunmandachani. Unanigllai chibi tiyaucuna Pedrota rimanaura, Sirtumi can Jesuspa muntunmanda angui, Galilea llacta rimacshina mangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro piñarisha jiridsata rimangahua callarira, Canguna rimaushca runataga mana ricsinichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chi ratullai gallo cutillata cantara. Pedro chita uyasha Jesus rimashcata yuyarira, gallo chara mana ishcai (2) cutin cantagllaita can quimsa (3) cutin paita mana ricsinichu nisha ñucamanda rimanguimi, nisha rimashcata yuyarisha yapa ashcata huacangahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ñáa punzhayaushcai pagri amuguna, israel rucu mandaccunandi, Diospa shimita yachachiccunandi, israel taripaccunandi Jesusta imasna ranata cuintanacunaura. Chihuasha Jesusta huatasha chi llactata mandac romano apu Pilatohuagma apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Apasha pactanaupi apu Pilato Jesusta tapura, Can israelgunata mandac amuchangui nisha. Tapucpi rimara, Indá, can rimashcacuinta mani. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Pagri amuguna ashcata caudsayachicpi apu Pilato cutillata Jesusta tapura, Manachu imatahuas paigunatas rimangui. Uyai, ashcagunatami canda caudsayachiunguna nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus randi shuc shimillatahuas mana rimarachu. Chasna mana rimacpi apu Pilato manzharira. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chi jista punzhagunaibi mandac amu Pilato shuc carcelbi tapariauc runata cacharic ara israelguna munashca runata. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chi uras shuc Barabas nishca runa tapashca ara. Paiga shuc runagunahuan gubirnuta piñasha tulashun nisha raushcai shuc runatas huanchishcamanda tapaitucura paihuan puriccunandi. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chi jista punzhai israel runaguna apu Pilatohuagma rinaura paihua tunu ranata rasha shuc runata cacharichun nisha rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ñáa Pilato yacharami chi pagri amuguna Jesusta piñashcamanda paihuagma pushamushcata. Chasna acpi pactamunaupi Pilato paigunataga tapura, Canguna israelgunata mandac amutaga ñuca cacharichun nishachu munanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Randi pagri amugunaga runagunata rimanaura Barabasta cachari nisha caparichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chasna caparinaupi Pilato cuti paigunata tapura, Imatata rasha israelgunahua rey amu canguna nishcataga. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tapucpi caparinaura, Paita cruspi quilabasha huanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chasna caparinaupi tapura, Ima mana alitata rara. Paiguna astahuanbas sinzhita caparinaura, Paita cruspi huanchi. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chasna caparinaupi Pilato chi israelgunata cushiyachinata munasha Barabasta cacharira. Astahuanbas Jesusta randiga ashcata libachishcahuasha sundalugunama cura paita cruspi huanchigrichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sundaluguna Jesusta japisha mandacpa huasi ucuma apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tucui sundaluguna tandarisha apu churarina llachapata Jesusta churachinaura. Casha huascatas ahuasha paihua umaibi churachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Huasha shu aputa cushiyachishcacuinta camisha rimanaura, Israelgunahua amumi cunanga jatun mandac tucungui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Paihua ñaupacpi cungurisha aputa balichishcacuinta ranaura. Chasna pugllasha camisha paihua umai caspihuan huactaunaura, paihua aichaibihuas tiucanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Asishcahuasha llatanachisha paihua quiquin llachapata churachinaura. Chihuasha paita cruspi huanchingahua apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Paita apanaupi shuc Cirene llactamanda Simon nishca runata tupanaura. Chi runaga Alejandrohua, Rufohua yaya mara. Pai chagramanda shamucta Jesuspa crusta marcachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ñáa Gólgota nishca urcuma Jesusta apanaura huanchingahua. Runa shimibi Gólgota nisha Umatullu urcu ninmi. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chi sundaluguna vinota mirra nishca rimidiuhuan chapushcata Jesusta upi nisha ricuchinaura. Ricuchigllaita Jesus mana upirachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chasna Jesusta cruspi huanchinaura. Chi sundalugunaga Jesuspa llachapata japisha maicanshi surtita charisha japinga nisha camanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ñáa paita cruspi huanchishca urasca tutamanda ara, las nueve tupu. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Crus jahuai shuc quillcashcata churanaura imamanda huanchitucun nisha. Casna paihua crus jahuai ISRAELGUNAHUA AMUMI nisha quillcashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Paihuan pariu ishcai (2) shuhuaccunatas quilabashca anaura, shuca paihua ali maqui partima, shuca paihua lluqui maqui partima. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chasna ranaupi Diospa shimibi ñaupa quillcashcacuinta tucura: Paita juchayuccuintata ranaura nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ñáa chi ñambita pasaucunahuas Jesusta mana balichisha camisha asinaura. Umata cuyuchisha caparinaura, Can Diosta alabana huasita tulasha quimsa (3) punzhaibi shayachishami nisha rimarangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Cunanga can quiquin quishpiri uraicui nisha asisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pagri amuguna chi Diospa shimita yachachiccunandi Jesusta asisha paigunapura rimanaura, Shuccunata quishpichira astahuanbas paillata quishpirinata mana ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chasna asisha rimanacunaura, Pai Cristo ashaga, israelguna amu ashaga cunanllata crusmanda uraicuchun, chita ricusha quirinchimami. Jesushuan pariu cruspi quilabashca runagunahuas paita asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ñáa chaupi punzhamanda las trescama tucui partibi ansayara. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Las tres tupui Jesus sinzhita caparira, Eloi, Eloi, lema sabactani. Runa shimibi chita nin, Ñáuca Dioslla, ñuca Dioslla, imangahuata ñucata jichuhuangui. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chita uyasha shuc chibi tiyaucuna rimanaura, Dios rimashcata pasachic ñaupa causac Eliastami cayaun. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Shuc runa callpasha risha pututa jayac vinoibi chupachisha caspi pundai huatasha Jesusta upichiunimi nisha rimara, Cunan ricushun Elias shamusha uraicuchichun chimanda. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesusca sinzhita caparisha huañura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chi ratullaita Diosta alabana huasi ucuibi huarcuriac llachapa chaupi chaupibi sháca jahuamanda allpama pasacta liquirira. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chi crus ñaupacpi shayauc sundalugunata mandacca Jesus huañushcata ricusha, Sirtupachami cai runa Diospa churi ashca nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Shuc huarmiguna carumanda tucuita ricuunaura. Shucca Maria Magdalena ara, quipa Jacobohua Josehua mama Mariahuas aura, shucca Salome ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Paiguna Jesusta Galileamanda catisha cuirac anaura. Chi huarmigunahuan shuccunahuas tiyanaura Jesushuan pariu Jerusalenma shamuucunas. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Cayandi samana punzha ashcamanda ña chishiyaupi shuc runa mana manzhasha amu Pilatohuagma risha Jesuspa aichata cuhuai ñuca apasha pambangahua nisha tapugrira. Chi runa Arimatea llactamanda Jose nishca ara, israel amuguna muntunmanda mara. Paihuas Diospa ali mandanata ricuchinaga caillayamuunmi nisha chapauc ara. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Apu Pilato Jesus ña huañushcata uyasha manzharira. Chita mana quirisha chi sundalugunata mandacta cayasha tapura, Jesusca huañushcachu. Pai indá nisha cutipacpi apu Pilato Joseta, Paihua aichata apailla nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jose chimanda llucshisha ruyac llachapata randira. Huasha, Jesuspa aichata crusmanda uraicuchisha chi llachapahuan pillusha pambana juctui churanaura. Chi juctuga urcu sapibi allashca ara. Chihuasha juctu punguta jatun rumihuan tapanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Chasna racpi Maria Magdalena Josehua mama Mariahuan maibi paiguna churaushcata ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Israel samana punzha pasashcahuasha Maria Magdalena, Santiagohua mama Mariandi, Salomendi ali asnaccunata randinaura Jesuspa aichaibi churangahua. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chi domingo punzhai, tutamandata indi llucshiushcai, aya pambashcama rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Riusha cuintanacunaura, Huañushcata pambashca juctumanda pita rumitaga anchuchingaya nisha. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Paiguna pactasha ricucpi chi rumiga jatun ashahuas quinraima anchuchishca mara. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aya juctuma yaicusha ali maqui partima shuc musuta ricunaura, ruyac llachapata churarishca mara. Paita ricusha manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chi musu paigunata rimara, Ama manzharichichu. Nazaretmanda Jesusta cruspi huanchishcatami mascaunguichi. Cunanga caibimi illanmi. Chasna huanchinaupihuas causarishcami. Ricuichi, caibimi paitaga churanaura. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cunanga Pedrota chi shuc yachachiushcagunata cuintagrichi casna nisha, Jesus cangunata ñaupasha Galileama pactangaraun pai rimashcashina. Chibimi paita ricungaraunguichi nisha cuintagrichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chita uyasha huarmiguna aya pambashca juctumanda llucshisha callpasha rinaura. Manzharishcahuan chucchurisha mana pitahuas cuintanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chi domingo punzha pagariushcai Jesus causarira. Causarisha ñaupapunda Maria Magdalenahuacpi ricurira. Chi huarmiga canzhis (7) supaigunata Jesus llucshichishca mara. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesushuan puriccunaga pai huañushcamanda llaquirisha huacaunaura. Chasna aushcai chi huarmi pactagrisha Jesusta ricushcanimi nisha cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesus causaunmi, ñuca paita ricushcanimi nisha rimagllaita chi runaguna mana quirinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chihuasha Jesus shuc tunu tucusha pai ishcai (2) yachachishca runaguna ñaupacpi ricurira paiguna Jerusalenmanda huasima riushcai. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chasna ricusha Jerusalenmallata chi shuccunama cuintangahua bulltianaura. Cuintagllaita chi shuccuna mana quirinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Puchucaibi Jesus chunga shuc (11) pai japishca runaguna ñaupacpi ricurira paiguna micuushcai. Paiguna pai causarishcata ricuccuna rimashcatas mana quirishcamanda Jesus paigunata sinzhita rimara. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Huasha paigunata rimara, Tucui partima richi nisha, Diospa quishpina shimita tucui runagunata cuintagrichi. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Canguna cuintashcata quirisha bautisariccunataga Yaya Diosca quishpichingami. Astahuanbas mana quirinata munac runagunata caudsayachishca tucungauna. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Quiriccunaga Jesus rashca tunutas ranata ushangaunami. Ñáuca shutihuan supaigunata llucshichingaunami. Mana ñaupa rimaushca shimigunatas rimangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Palugunata maquihuan japishallata, huañuna janbitas upishallata, mana imas tucunaungachu. Huañuccunahua jahuaibi maquita churanaupi ali tucunaungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pai japishca runagunama chasna rimashcahuasha Señor Jesucristo jahuapachama apaitucura. Chibi tucuita mandac amu tucusha Diospa ali maqui partima tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chi runagunaga tucui partita puriusha Dios quishpichina shimita yachachinaura. Paiguna yachachiushcaibi Jesuspa ushai paigunahuan aushcamanda pai tunu rashcagunata ranaura. Chimandami paiguna sirtu shimita rimashcatas ricuchira, chiraicu yachachicpi ashca runaguna quirinaura. Chasna achun.");
INSERT INTO qvzNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ñáuca llaquishca Teófilo, Ashca runaguna Jesus ñucanchihuacpi rashcagunamanda yachachishcagunamandahuas quillcanaushcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesushuan ñaupapunda purisha yachachiucunata uyasha quillcanaushcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Chasna acpi ñucahuas quillcasha nini. Jesusta ricuc runagunahuan ñuca alita tapusha pundamanda yachangahua nisha munashcani. Yachasha pai callarishcamanda tucurinagama canda cunan quillcauni llaquishca Teófilo. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Canda ñaupa yachachishcaguna sirtu ashcata can yachachun quillcauni. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ñáaupa uras Herodes nishca amu Judea llactata mandashca uraspi shuc israel pagri Zacarias causac ara. Paiga tucui pagri muntunmanda Abías nishca muntun mara. Paihua huarmihuas Isabel nishca chasnallata huañuc apayaya Aaronmanda mirai huarmi ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paiguna ishcandi Diospacpi ali sumac causaccuna ashcauna. Ishcandi tucui Dios mandashcagunata uyasha, Dios munashcata pactachisha causaccuna ashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Randi huarmi mana huahuayagashcamanda huahua illac causac anaura. Paiguna ishcandi ña yapa rucuyashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Shuc punzha Zacariaspa muntunguna Diosta alabana huasibi tarabanata raushcaibi Zacariasrandita tucucpi Diospa huasi ucuma yaicura ali asnac pulbuta Diospacpi rupachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chi pulbuta rupachiushcai ashca israel runaguna canzhaibi ausha Diosta alabasha mañanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chasna acpi Zacariaspa ñaupacpi Diospa angel ricurira, chi pulbuta rupachina jahua cajun mayanbi shayarisha, paihua ali maqui partima. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarias angelta ricusha ashcata manzharira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chi angel randi paita cuintara, Zacarias nisha, ama manzharinguichu. Dios can paita tapuushcata uyasha rangami, camba huarmi Isabel shuc cari huahuata huahuayangami nira. Huahuayacpi Juan nishcata shutichingui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chi huahuata huahuayacpi cushiyanguimi, chasnallata camba churimanda ashca runagunahuas cushiyangaunami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Diospacpi yapa balic runa tucungami. Paiga vinotas ima machachina yacutahuas mana upingachu. Astahuanbas pai pagarishca urasmanda Diospa Samai yuyaita cushcami anga. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pai chasna asha israel runagunata yachachicpi ashcaguna jatun Diosta cuti catingaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dios cachamungaraushca runa shamunagama camba churi runagunata yachachiungami. Camba churi ñaupa causac Eliascuinta Diospa yuyaihuan ushaihuanbas puringami. Chasna purisha yachachisha yayagunahuan churigunahuan alichingami, mana uyac runaguna uyac tucungahua pai camachingami. Chasna camachisha tucui runagunata yachachingami Dios cachamungaraushca runata catinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angel chasna rimacpi Zacarias tapura, Can sirtupacha rimashcata imasata yachasha. Ñáuca yapa rucu mani, ñuca huarmihuas huahuata mana tupaibac, paihuas yapa rucu man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chasna nicpi angel rimara, Ñáuca Gabriel mani, Diospacpi shayac mani nira. Pai ñucata cachahuarami cai cushi shimitaga canda rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ñáuca rimashca shimiga sirtu pactaringami. Cunanga ñuca rimashca shimita can mana quirishcamanda shuc shimitas mana rimac tucungui, ñuca rimashcashina camba churi pacarinagama mudu tucungui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Angel Zacariashuan rimaushcai tucui canzhaibi auc runaguna pai imamanda Diosta alabana huasi ucuibi unaita tiyaushcata mana yachanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarias ña llucshisha rimanata mana usharachu. Mudu mana rimac tucusha maquillahuan ricuchira. Chasna racpi runaguna asirtanaura pai Diosta alabana huasi ucuibi tiyausha muscuibicuinta ricushcata. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Diosta alabana huasibi tarabashcahuasha Zacarias paihua quiquin huasima rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mana unayasha paihua huarmi huicsayara. Chasna huicsayasha paihua huarmi pichca (5) quillagama huasimanda mana canzhama llucshira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Chasna huicsayashami Dios cunan ñucahuacpi yapa alita rashcami nisha rimara, ñuca llaquirishcata pai pasachishcami huahuata mana tupac ashcamanda runaguna ama mas asihuanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sucta (6) quillahuasha Dios paihua angel Gabrielta provincia Galileama cachara Nazaret nishca llactama. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Paita cachara shuc Maria nishca malta huarmihuagma. Chi huarmiga ñaupa causac israelgunata mandac rey amu Davidmanda mirai mara, Jose nishca runa tapushca mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel shamusha Mariata rimara, Cambagma shamuni canda rimangahua. Diosca cambacpi tiyaun. Tucui huarmigunamanda balichishca tucunguimi can. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chasna rimacpi Maria yapa manzharisha, Imangahuata chasna rimahuan nisha yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pai chasna yuyariucpi angel nira, Ama manzharichu Maria. Diospacpi balichishca mangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Huahuata huahuayanguimi, carihuahuata. Paita Jesus nishcata shutichingui. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pai yapa ali mandac amu tucungami. Jahuapachai Diospa Churi nishcami anga. Camba churi paihua huañuc apayaya rey amu Davidcuintallata mandac tucunga jatun Dios munashcaraicumi. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chasna rasha tucui israel runagunata huiñai mandagmi tucunga. Pai mandanaga ima uraspas mana tucuringachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chita uyasha Maria angelta rimashca, Cari illac mani. Imasata ñucaga huahuayasha cari illacca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel randi paita rimashca, Diospa Samai cambagmami shamunga. Jatun Diospa ushaihuanmi puyucuinta cataitucungui. Chimanda can huahuayangaraushca churiga jucha illac manga, Diospa Churi man nishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Chasnallata canda nini camba aillu Isabel ña apa aushcai huahuayasha shuc churita charingami. Mana huahuayagashallata cunanga sucta (6) quilla tuputa charishca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios tucuitaga ushac man nisha angel rimashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tucuita uyashcahuasha Maria rimashca, Jatun Diosta cadsuc mani, chasna tucuchun can rimashcacuinta. Chasna rimashcahuasha paihuagmanda angel llucshisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Angel cuintashcahuasha mana unayasha Maria Judea provinciama shuc llactai rira urcu partita. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chima pactasha Zacariaspa huasima yaicusha Isabelta saludara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Saludashcata Isabel uyacpi paihua huicsa ucuibi auc huahua cushparira. Isabel Diospa Samaihuan yaicushca asha cushihuan rimashca, ");
INSERT INTO qvzNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tucui huarmigunamanda Dios canda mas yali balichishca mangui nira. Camba huahuas Diospacpi balichishcami saquiringa. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mana balicchani ñuca jatun amuhua mama ñucama shamungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ñáucata can saludacpimi ñuca huicsa ucui tiyauc huahuaga cushihuan cushparihuara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios canda rimashca shimi pactaringaraushcata can quirishcamandami cushi mangui nisha Isabel rimashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Isabel rimashcahuasha Mariaga casna nisha Diosta alabara, Ñáuca shungu ucui jatun Diosta yapa balichiuni. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pai quishpichic ashcamanda ñuca tucui shunguhuan cushiyani. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ñáuca Diosta cadsuc, pugri agllaita ñucata yuyarihuashcami. Cunanmanda tucui runaguna ñucamanda Dios paita balichishcami nishami cuintangaraunguna. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tucuita rac Dios jatun rashcataga ñucahuacpi rashcami. Paiga jucha illac sumac man. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pundamanda huiñaigama tucui paita manzhac runagunata yuyarisha yanapashami cuiran. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pai rashcagunamanda ushaita ricuchishcami. Balic mani nisha alabariccunata anchuchishcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandac runagunataga paiguna mandanamanda Dios llucshichishcami, randi mana balichishca runagunataga mandac tucushun nisha churashcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Raicasha tiyaucunama ashca aligunata cushcami. Chariccunata randi imas illacta callpachishcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Paihuacta rasha causac israelgunata Dios yanapashcami. Ñáucanchi callari apayaya Abrahandas paimanda miraigunatas Dios rimashcami tucui uras cangunata yuyarisha yanapashami nisha. Pai rimashcata mana cungarisha israelgunata yuyarisha yanapaunmi. Chasna nisha Maria Diosta alabara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pai ñalla quimsa (3) quillata Isabelhuan pasiara. Chihuasha paihua quiquin huasima bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chihuasha Isabel ña cari huahuata huahuayashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Paihua ailluguna, mayanbi causaccunahuas Dios paita rimashcashina cari huahuata huahuayashcata uyasha paigunahuas cushiyashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chasna acpi huahua pusac (8) punzha charishcai Moises mandashcacuinta pitina uraspi chi ailluguna paihua yaya Zacarias nishca shutillatata shutichinguichi nisha rimashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Randi paihua mama rimara, Mana chasna shutichan, paihua shutiga Juan man. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nicpi rimashcauna, Randi camba aillugunahuacpi chi shutiga mana tiyanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chasna paiguna rimanacusha maquita cuyuchisha Zacariasta tapushcauna paihua churihua shutita. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tapucpi Zacarias chasnallata maquita cuyuchisha quillcata tapusha quillcara, Paihua shutiga Juanmi. Quillcacpi tucui ailluguna ricusha imasna rashata chi shutitaga shutichira nisha manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacariasca chi urasllata paihua shimihuan rimanata ushashca, ushashami Diosta alabangahua callarishca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chasna tucucpi tucui runaguna manzharinaushca. Chasnallata tucui Judea provincia urcu llactagunaibi tiyac runagunas tucuibi chimanda cuintanacushcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tucui paigunata uyaccuna yuyarishcauna imasata chi huahuaga tucunga nisha. Diosca paihua ushaita chi huahuama sirtu cungaraushca mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chi huahuahua yaya Zacariasca Diospa Samai jundacta yaicushca asha Dios yuyachishca shimigunata rimashca casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israelba jatun Diosta alabashca achun paihua runagunata yuyarisha pai quishpichingahua shamushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Diosta sirbic rey amu Davidmanda miraitami shuc yapa ushaita charic quishpichictaga cachamushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Ñáaupa urasmanda Dios rimashcata pasachic paihuacpi ali causac runagunata yuyachisha nira, Ñáucanchita piñaccunamandahuas tucui ñucanchita mana llaquiccunamandahuas Dios ñucanchita quishpichishcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ñáucanchi huañuc apayayagunata yuyarisha yanapashami Dios paigunata mana paquibac rimashca ali shimita mana cungarishcachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ñáucanchi huañuc apayaya Abrahanma Dios ñaupa rimashcata chara yuyarisha cunan pactachishcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Chasna yuyarisha ñucanchita piñaucunamanda quishpichinmi ñucanchi paihuacta mana manzhaihuan rangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Chasnallata tucui ñucanchi causanagama jucha illac sumac causasha paihuacta rana manchi. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Chasnallata canga jatun Dios rimashcata pasachic runa tucungui churi. Quishpichic runa shamunagama paihua runagunata Diospa quishpina shimita yachachingui ñucanchi juchagunata pai anchuchingami nishca shimita yachachisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ñáucanchi Dios yapa llaquisha yanapashcamandami jahuapachamanda ñucanchima pai cachamushca runaga ñucanchita punzhayachishcacuinta quishpichingami. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Chi ansaibicuinta juchata rasha puriu runagunata huañuimanda llushpichisha quishpichingami. Dios cachamungaraushca runaga ñucanchita paihua ñambita ricuchingami Dioshuan cushi causanauchun nisha. Chasna nisha Zacarias Diosta alabashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Paihua churi Juan nishca, huiñasha ali yuyaiyuc tucura. Chaquishca pambaibi causaura israel runagunata camachina urascama. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chi huatagunaibi romano jatun amu Cesar Augusto nishcaga tucui runagunata mandashcami gubirnu quillcaibi shutigunata apuntachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chiga ñaupa asinsu yupashca ara, Siria llactaibi Sirino nishca amu mandashca uraspi. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chi amu chasna mandacpi tucui runaguna paiguna huañuc apayayahua llactama rina ashcauna quillcachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josega israel huañuc rey amu Davidmanda mirai asha Davidba llacta Belen nishcama rina ashca. Chasna asha provincia Galileamanda, paihua quiquin Nazaret nishca llactamanda llucshisha provincia Judeama, Belen llactama rishca. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Chima rishcami shutita churachingahua pai tapushca huarmita pushasha. Mariaga huahuayangamiraushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Paiguna Belen llactaibi tiyaushcai huahuayana uras pactara. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chasna acpi Maria huahuayara cari huahuata paihua punda huahuata. Jatun puñuna huasibi tapacta ashcamandami huagra huasibi huahuayara. Huahuayasha paihua churi huahuata pindulihuan pillusha huagra micuna batiaibi churara. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chi tutallata Belen llacta mayanbi ovejata cuiraccuna chushac pambaibi paiguna ovejagunata cuirasha tiyashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Cungaimanda paigunahuacpi Diospa angel ricurimushca. Ricurimucpi Diospa sumacca chi runagunahuacpi muyucta punzhán ricurishca. Chasna tucucpi yapa manzharishcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Randi chi angel paigunata rimashca, Ama manzharinguichichu. Uyaichi. Ali cushi shimita cangunata cuintangahuami shamuni, tucui runagunata cushiyachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cunan tuta Davidba llactaibi cangunata quishpichic pagarishcami. Paiga Cristo nishca jatun amumi. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chasna acpi casna ricusha yachanguichimi, chi huahuaga huagra batiaibi pillushca siriutami tupanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Cungaimanda chi angelhuan yapa ashca angelguna ricurimushcauna. Ricurisha Diosta alabasha rimashcauna: ");
INSERT INTO qvzNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Tucui jahuapachai auccuna Diosta alabashca achun. Cai pachaiga tucui Diosta cushiyachic runaguna cungailla causanauchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelguna chasna rimasha jahuapachama bulltiashcahuasha chi ovejata cuiraccunapura cuintanacushcauna, Jacuichi Belen llactama ricungahua Dios ñucanchima rimashcata. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chasna cuintasha huairashina risha pactasha Joseta Mariatahuas tupanaurami. Chasnallata chi huahuata huagra batiaibi siriucta ricunaurami. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chita ricusha risha angelguna huahuamanda rimashca shimigunata tucui runagunama cuintashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Paiguna chasna cuintacpi tucui runaguna uyasha imata tucungaraun nisha manzharishcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaga tucuita paihua shungu ucuibi huacaichisha yuyarisha causaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chi ovejata cuiraccunaga tucui paiguna ricushcatas uyashcatahuas yuyarisha Diosta alabasha balichishcauna. Chi angel rimashcacuinta tupagrishcamanda Diosta alabasha balichisha paiguna ovejagunama cuti bulltiashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesus pai pagarishcamanda pusac (8) punzha aushcaibi huañuc Moises mandashcacuinta israel runa tucungahua ullucarapundata pititucushca tucuchun nisha apanaura. Chasnallata chi uraspi shutichinaura Jesus nishcata, Maria chara mana huicsayuc agllaita Jesus nishcata shutichingui nisha angel rimashcaraicu. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jesus shuc quillata chariushcai Moises mandashcashina María armara. Chita pactachishcahuasha Jerusalen llactama Diospa jatun huasima Jesusta apanaura Diosma ricuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dios mandashca shimi casna nin: Ñáaupapunda cari huahuata ñucama ricuchina manguichi ñucahuac tucuchun nisha. Joseguna chasna ranaura Dios rimashca shimita pactachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Paiguna chasnallata Dios mandashca shimita pactachisha, pishcugunata israel pagrima cunaura pai rupachisha Diosma ricuchichun nisha. Chi mandashca shimi nin: Cugrichi ishcai (2) palomagunata carindi huarmindi Diosma ricuchingahua. Paloma mana tiyacpiga ishcai palomacuinta huahuagunata cugrichi nin. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chi uraspi shuc rucu runa Simeon nishca Jerusalen llactaibi causauc ara. Diosta manzhac asha runagunahuacpi yapa ali puric, Dios paihua israel runagunata quishpichingami nisha chapasha causaura. Diospa Samai paihuanmi tiyaushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chasna asha Diospa Samai Simeonda ñaupata rimashca ara, Can mana huañusha causaungaraungui Dios cachamungaraushca Cristo nishca quishpichicta ricunagama nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Shuc punzha Simeon Diosta alabana huasima yaicura Diospa Samai paita chima ringui nishcamanda. Chibi tiyaushcai Jesuspa yayaguna huahuata apamunaushca Dios mandashca shimita caran huahuamanda pactachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Chasna apamucpi rucu Simeon chi huahuata marcasha Diosta alabasha casna nira, ");
INSERT INTO qvzNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Jatun Dios, can ñucata rimashcacuinta ña pactarishcami. Ñáuca quiquin ñahuihuan can cachamushca quishpichicta ricunimi. Cunan ñuca huañucpi mana imaschan, ali manga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Cai quishpichicta tucui runagunaraicu can cachamushca angui. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Paiga camba israel runagunata balichingami. Chi shuc mana-israel runagunama bilatacuinta ali causaita cungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon huahuamanda chasna rimacpi uyasha Jesuspa mama yayahuas manzharisha cushihuan uyashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Chasnallata Simeon, Dios cangunata alita yanapachun nisha bindisiara. Chihuasha Mariata rimara, Yaya Dios cai huahuata cachamushcami maican israel runaguna Dioshuan alichishca tucungahua, shuccunaga Diospa ñaupacpi mana balichishca tucungahua. Paiga chi runaguna Dios mana munasha yuyarishcagunata ricuchingami. Chasna racpi ashca runaguna paita camisha mana gustanaungachu. Jesus yachachingaraushca shimita mana alita rimanaungami. Canga Maria, camba shungu ucuibi lansahuan tucsishcacuinta llaquiringuimi nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chi uras shuc rucu huarmi chasnallata Diosta alabana huasibi aushca, Dios rimashcata pasachic huarmi Ana nishcami. Paiga Aser muntunmanda mirai Fanuel nishca runahua ushushi mashca. Chi huarmi malta uraspi cadsarasha canzhis (7) huatai paihua cari huañura. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cari huañushcahuasha pusac chunga chuscu (84) huatagama huaccha causauc ashca. Diosta alabana huasibi causasha mana llucshisha tutandi punzhandi Diosta alabasha causac ashca. Dioshuan cuintasha ashca cutin mana micusha sasisha Diosta alabasha causashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon rimaushcai Ana pactasha Diosta pagrachu ningahua callarishca. Chasnallata Ana huahua Jesusmanda cuintara tucui Jerusalenbi quishpichiuta chapauc runagunama. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jose huarmindi huahuandi tucui Dios mandashca shimigunata pactachishcahuasha Galilea provinciama, paihua quiquin Nazaret llactama bulltiashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chibi causausha Jesus sinzhi tucura, alita yachasha yuyaiyuc tucusha huiñara. Chasnallata Dios paita yapa llaquisha yanapara. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Caran huatata Jesuspa yayaguna Jerusalenma rishcauna pascua nishca israel jistata rangahua. Jesus ña chunga ishcai (12) huatata chariushcai paita pushanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chi jista tucuricpi paiguna bulltiausha mana yachanaurachu pai Jerusalen llactallaita saquirishcata. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","45","Mana yachasha Jesusca chi riu runagunahuan shamuunmi nisha yuyarinaura. Chasna yuyariusha shuc punzhata rinaura. Randi Jesus chara mana ricuricpi tucui aillugunahuacpi amigogunahuacpis mascashahuas mana tupasha Jerusalen llactamallata cuti bulltianaura paita mascangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chibi mascasha mascasha quimsa (3) punzhahuasha Diosta alabana huasibi pai tiyauta tupashcauna. Jesusca chibi yachachiccunahuan tiyarisha paigunata uyasha tapusha tiyaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chasna acpi tucui paita uyaccuna pai yachashcata pai rimashcatas uyasha yapa yuyarishcauna imasata cai huahuaga rucucuinta yachan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Paihua yayaguna chita ricusha imata tucun nisha yuyarinaura. Chasna yuyarisha paihua mama tapura, Imangahuata saquirisha ñucanchita llaquichirangui churi. Camba yaya ñucahuas llaquirisha canda mascauranchi quimsa (3) punzhata. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tapucpi pai cutipara, Imangahuata mascahuaranguichi. Manachu yachanguichi ñuca Yayahua huasibi tiyana acta. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Chasna nicpi paiguna Jesus rimashcata uyashallata mana sirtu intindinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chihuasha Jerusalenmanda llucshisha Jesus paigunahuan Nazaretma bulltiara. Bulltiasha paigunata cadsusha causac ara. Tucui rimashcatas, pasashcagunatahuas paihua mamaga shungu ucui huacachisha causac ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Chasna Jesus ali aichayuc ali yuyaihuan huiñaura, Diospacpihuas runagunaibihuas alita tucusha huiñara. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chi uras romano llactagunata jatun mandac Tiberio Cesar ña chunga pichca (15) huatata romano llactagunata jatun mandac amu tiyashcaibi cai gubirnadurguna anaura: Judea provinciai Poncio Pilato ara, Galilea provinciai Herodesmi ara, Iturea y Traconite provinciagunai Herodespa huauqui Felipe ara, Abilinia provinciai Luciano ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chasnallata israel pagrigunata mandaccuna Anaspas, Caifaspas anaura. Chi uras Zacariaspa churi Juanga runaguna mana causaushca pambai aushcai Yaya Dios paita mandara ñuca rimashca shimita camachigri nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chasna mandacpi Juan tucui Jordan yacu mayanda puriusha casna nisha camachira, Dios canguna juchagunata anchuchingahuaca canguna juchagunata rashcamanda llaquirisha saquichi, chihuasha bautisarichi nisha camachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dios rimashcata ñaupa pasachic Isaiasca Juanmandami casna quillcashca. Pai quillcashcacuinta ña cunan pactarishcami. Chi shimiga casna mashca: Chaquishca pambaibi shuc runa casna caparisha camachin: Dios cachashca quishpichic runaraicu shuc cusca ñambita rashcacuinta canguna causaita alichirichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tucui huaicugunahuas taparinaungami, tucui urcugunahuas pambayanaungami. Arcu ñambigunahuas tsigllayanaungami, mana pariullagunahuas pariyashca tucunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tucui runaguna Dios shuc quishpichicta cachamungaraushcata ricungaunami. Dios chasna rimachishcacuinta Isaias ñaupata quillcashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chi shimi pactaricpi Juan tucui pai bautisarinata munac runagunama casna rimara, Canguna palucuinta mana alita rac mirai partimanda anguichi. Pita cangunata rimaraya Dios taripasha libachinamanda quishpingahuaca. Canguna chasna causausha Dios taripana punzha pactamucpi mana quishpinata ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cunanga juchata saquisha alita rasha causana manguichi canguna causai sirtu cambiarisha Diosma shamushcata ricuchingahua. Ama rimaringuichichu ñucanchi apayaya Abrahanmanda miraiguna ñucanchi ashcamandami quishpishca anchi nisha. Cangunata nini, Dios munashaga cai rumigunamandas ushanmi Abrahanmanda miraigunata rangahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios taripanaga shuc ruyata cuchuna hachacuinta cunan pactamushcami. Maican ruya mana ali muyuta aparicpi cuchushcahuasha ninaibi shitaitucun. Cangunaga mana alita rasha causashcamanda chi mana ali aparic ruyacuinta manguichi. Chimandami taripashca tucunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juan chasna camachicpi uyasha tapushcauna, Ñáucanchiga imatata rana anchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tapucpi rimara, Maican runa ishcai (2) camidsata charisha mana charic runata shucta cunami. Micunata charisha chasnallata cunami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chi uras gubirnuraicu cullquita tandachiccuna Juanbagma shamusha bautisaringahua paita tapushcauna, Ñáucanchiga imasnata rashun señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tapucpi nira, Gubirnu rimashca tupullata tapuichi cullquita, ama yalicta tapunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sundalugunahuas paita tapunaura, Ñáucanchiga imatata rashun. Paigunata nira, Pimandahuas cullquita ama imatas yanga apaichichu. Ama umasha shuhuanguichichu pihuactahuas. Canguna ganashca cullqui tupullahuan causaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dios cachangaraushca quishpichic shamunata chapaucuna Juanda ricusha yuyarinaura, Caichu quishpichic Cristoga an nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan randi paigunata nira, Ñáuca cangunata yacullahuanmi bautisauni. Ñáucahuasha shamungami ñucamanda mas yali ushaiyuc runa. Shuc mas pishi tarabac runacuinta huascallatas pascasha paihua zapatosta llucshichingahuas mana balicchani. Paiga maican runagunata Diospa Samaihuan ninahuanbas bautisangami. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Shuc runa muyugunata pallasha caspihuan huactan muyu carata ishcurichun nisha, muyu carata jichusha ninai rupachingahua, tucui ali muyugunalla saquirichun nisha paihua huasi ucuma huacaichingahua. Dios cachangaraushca ñucamandahuasha shamuc runaga chicuinta rasha Diospacpi alita rac runagunata paihua huasima apangami, chi mana alita rac runagunata huiñaigama ninaibi rupachinga. Chasna nisha Bautisac Juan paigunata yachachishca. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juan chasnallata mas chicuintallata runagunata yachachisha quishpinamanda Diospa ali shimita cuintaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juanga mandac amu Herodesta canga mana alitachu rasha causaungui nisha rimara. Shuctas mas rimara camba huauquihua huarmi Herodías nishcata quichusha mana alitachu rangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chasna nisha rimacpi Herodes piñasha mas mana alita rasha Juanda carcelbi tapara. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tucui runaguna bautisarishcai Jesuspas bautisarishcami. Pai Diosta mañaushcai jahuapacha pascarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pascaricpi Diospa Samai shuc palomacuinta ricurisha paihua jahuai shamura. Chasnallata jahuamanda shuc shimi uyarira, Canga ñuca yapa llaquishca churi mangui, can quishpichic tucuchun nisha ñuca canda cushihuan japirani. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus ña quimsa chunga (30) huatayuc aushcai pai yachachingahua, pihuas mana rashcagunatas rangahua callarira. Runaguna Jesuspa yayaga Jose man nisha yuyarishcauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Josehua yaya Elí nishca ara, Elíba yaya Matat, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josehua yaya Matatias, Matatiaspa yaya Amos, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiba yaya Maat ara, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judáhua yaya Joano ara, Joanohua yaya Ireso, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerihua yaya Melqui ara, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erba yaya Josue, Josueba yaya Eliezer, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatpa yaya Leví ara, Levíhua yaya Simeon, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquínba yaya Meleo ara, Meleohua yaya Mainán, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánba yaya David, Davidba yaya Isaí, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasónba yaya Aminadab, Aminadabba yaya Arni ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judáhua yaya Jacobo, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorba yaya Seruc ara, Serugpa yaya Ragau, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salóhua yaya Cainan, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecpa yaya Matusalen ara, Matusalenba yaya Enoc, ");
INSERT INTO qvzNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanba yaya Enos, ");
INSERT INTO qvzNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus bautisarishcahuasha Diospa Samai jundaricpi Jordan yacumanda llucshira. Llucshicpi Diospa Samai paita pushara chaquishca partima. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chuscu chunga (40) punzhata chibi tiyaura. Chibi tiyaushcai supai paita pandachinata munara. Tucui chi punzhagunaibi Jesus imatahuas mana micushachu tiyaura. Chasna ausha yapa raicashca mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chasna raicacpi supai paita casna nisha camara, Can Diospa churi asha cai rumita panda rasha micui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chasna supai nicpi Jesus rimara, Diospa shimi ninmi: Runa mana micushallachu causacchan, astahuanbas Yaya Dios tucui rimashcata cadsusha causana manchi. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chihuasha supai paita urcuma apasha chimanda tucui llactagunata chi ratuhuallai ricuchira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ricuchisha, Cai tucui gustu llactagunaga ñucahuagmi nira. Ñáuca pitas cunata ushanimi. Chasna asha can mandac tucuchun nisha tucui cai gustu ricuric llactagunata canda cusha nini can chigunata mandangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Diostacuinta ñucata cungurisha alabasha balichicpiga canda cushcanguimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus randi rimara, Diospa shimibi quillcashca tiyaunmi: Canda mandac Diosta alabana angui, paillata cadsusha causana mangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chihuashaga supai paita Jerusalenma apasha Diosta alabana huasi jahuaibi shayachisha rimara, Can Diospa churi asha caimanda allpama saltai nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Supaihuas Diospa shimita japisha rimara, Diospa shimibi quillcashca tiyanmi nisha Dios paihua angelgunata cachangami canda japisha cuirangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Chasnallata quillcashcami, paiguna maquigunahuan canda marcangaunami camba chaqui ama rumibi tacarichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus randi paita rimara, Chasnallatami Diospa shimi nin: Can munashcata rachun nisha canda mandac Diostaga ama mandasha camanguichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Supai tucui ima tunuis camasha juchai urmachinata mana ushashami Jesusmanda anchurisha rira, huasha ima uraspas tupasha urmachishami nisha yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chihuasha Jesus Diospa Samai ushaihuan jundashca asha Galilea provinciama bulltiara. Chasna acpi tucui chi partibi tiyaucuna Jesusmanda cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Chibi auc israel tandarina huasigunai Jesus yachachicpi tucui runaguna paiga yapa alita yachachin nisha rimanaushcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chasna Jesus pai huiñashca Nazaret llactama bulltiara. Pactasha israelguna samana punzhai paihua yachai chasna acpi paiguna tandarina huasima rira. Chima risha Diospa shimita ricungahua shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Shayaricpi Diospa huasita cuirac runa quillcata paima cura ricuchun nisha. Cusha Dios rimashcata ñaupa uras pasachic runa Isaias quillcashcata ricuchun nira. Jesus quillcata pascasha casna quillcashcata tupasha ricura: ");
INSERT INTO qvzNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Diospa Samai ñucahuacpi tiyaun. Pai ñucata japihuara pugrigunama Diospa ali quishpina shimita yachachingahua, caudsayachishca runagunama llushpirina shimita rimangahua, puyuñahui runagunata alichisha ricuchingahua, huatashcacuinta causac runagunata lugaryachingahua, ");
INSERT INTO qvzNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yaya Diospa quishpina punzhaguna pactamushcami nishami yachachichun nisha ñucata japihuara. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","21","Jesus chita ricushcahuasha quillcata tapasha cuirac runama cusha tiyarira yachachingahua. Chasna acpi tucui chibi tiyauc runaguna paita ricuucpi Jesus rimangahua callarira, Cai canguna uyaushca quillcashca shimiga cunan punzha pactarishcami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesus rimashcata uyasha tucui runaguna paiga yapa ali shimigunata yachachiunmi, chasna ashahuas manachu Josehua churi anya nisha rimanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chasna yuyarisha rimanacucpi Jesus paigunata nira, Ñáucamanda shuc shimita rimaunguichichari can amullata aliyai doctor. Can Capernaun llactaibi rashcata uyashcanchi, caibi camba quiquin llactaibihuas chasnallata rai. Chita rimahuanguichima. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cangunata sirtuta nini tucui Dios rimashcata pasachic runagunata paiguna quiquin llactai mana balichishcachu tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yuyarichi. Dios rimashcata pasachic runa Elias causaushca uras quimsa huata chaupita (3 ½) mana tamiarachu. Mana tamiashcamanda tucui llactagunai yapa sinzhi raicaitucurami. Chi uras israel llactai ashca huaccha huarmiguna tiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Chasna tiyaugllaita Dios mana paigunahuagmachu Eliasta cachara, astahuanbas Sidón mayanbi Sarepta nishca mana-israel llactai tiyauc shuc huaccha huarmihuacta cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chasnallata Dios rimashcata shuc pasachic runa ara huañuc Eliseo nishca. Pai camachiushca uras israel llactai ashca lepra nishca sinzhi carachayuc runaguna tiyanaura. Chasna tiyaugllaita Siria nishca mana-israel llactamanda Naaman nishca runalla alichishca tucura nisha Jesus rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pai chasna mana-israel runagunamanda rimacpi tucui chi tandarina huasibi tiyauc runaguna uyasha yapa piñarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Piñarisha huanchishun nisha jatarisha Jesusta canzhama apanaura urcu pundamanda huaicuma tangashun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Randi Jesus paiguna chaupi ucullatata pasasha shuc partima rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesus chimanda llucshisha chi Galilea provinciallaita Capernaun nishca llactama rira. Chibi shuc samana punzha, israel tandarina huasibi yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pai yapa ushaihuan yachachiupi tucui uyac runaguna imasna ashata alitaga yachachinya nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ñáa chi israel tandarina huasibi supai yaicushca runa ausha yapa sinzhita caparira, ");
INSERT INTO qvzNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nazaretmanda Jesus ñucanchimanda anchuri, ñucanchita ama quillachichu, ñucanchita huanchisha tucuchingahuachu shamurangui. Canda ricsinchimi, canga Dios anllasha cachashca ashami jucha illac runa mangui nisha sinzhita caparira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chasna nicpi Jesus chi supaita sinzhita rimasha mandara, Chunlla ai, chi runa ucumanda llucshisha ri nira. Jesus chasna mandashcata supai uyasha tucui runaguna ricuushcai chi runata urmachisha llucshira, randi mana imatahuas huaglichishachu rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tucui chita ricuc runaguna manzharisha paigunapura cuintanacunaura, Imasna ashata chasna riman, pai mandacpi supaigunas paitaga cadsusha llucshinaunmi nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chasna tucucpi tucui chi llactagunai paimanda cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus chi tandarina huasimanda llucshisha Simonba huasima yaicura. Chi uras Simonba huarmi mama sinzhi ungushca siriura. Chasna tucucpi Jesusta tapunaura paita alichichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chasna tapucpi Jesus paihuagma risha ungüita anchuri nisha rimara. Pai chasna rimashcallai ungüi anchurirami. Chi urasllata chi huarmi jatarisha paigunata upichingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chi israel samana punzha indi yaicuushcai tucui tunu ungushcagunata Jesuspagma apamunaura. Apamucpi Jesus caran runata llangasha janbira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Alichiupi supaiguna ashca runagunamanda llucshisha riusha caparinaura, Can Diospa churi mangui nisha. Chi supaigunaga Jesusca Dios cachashca quishpichic Cristo acta yachanaurami. Yachagllaita Jesus sinzhita mandasha paigunataga lugarta mana curachu paimanda rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cayandi punzha pagariupi Jesus chi llactamanda llucshisha, chaquishca partima rira. Pai illacpi runaguna paita mascanaura. Mascasha tupasha jarcanaura caillai saquiri nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesus randi paigunata rimara, Diospa ali mandanamanda yachachiuni imasna paimi quishpichinata munan. Shuc llactagunais cai ali shimillata yachachina mani, chasna yachachingahuaca Dios cachamuhuara nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chasna asha Galilea provinciai auc llactagunai purisha tucui chibi auc israel tandarina huasigunai camachisha puriura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Shuc punzha Jesus Genesaret partibi Galilea cucha patai tiyaushcai ashca runaguna tandarisha paihuagma tapacta shamunaura Diospa shimita uyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chibi Jesus ricura ishcai (2) canuata chushac acta. Amuguna pulayama llucshisha paiguna licagunata maillasha tiyaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Runaguna tapacta caillayamucpi Jesus Simonba canuaibi yaicusha paita cuchanayagama tangari nira. Chasna tangaricpi tiyarisha canuamanda runagunata yachachingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachachishcahuasha Simonda rimara, Chaupi cucha partima cahuiri, camba licata shitai nira yacu aichagunata japingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon randi rimara, Tuta pagaricta licashahuas pagarishcanchi, mana imatas japiranchichu señor, mana shugllahuas. Randi can rimashcamanda cunan cuti shitasha camangarauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Shitasha yapa ashcata japinaura. Chasna aicha jundaricpi lica liquiringahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chasna tucucpi paigunahuan pariu tarabaucunata maquita ricuchisha cayanaura canguna canuata apamuichi nisha. Chi canua pactamucpi ishcandi canua tapacta jundarira. Jundaricpi canuaguna tigrana tunuta callariura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pedro chita ricusha Jesuspacpi cungurisha, Ñáucamanda anchurihuai señor, ñuca yapa juchayuc ashcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pai ashca manzharishcamanda chasna rimara, tucui paihuan canuai tiyaucunahuas manzharishcauna yacu aichata yapa ashcata japishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Paihuan tarabaccuna Zebedeoba churiguna Santiago, Juan nishcaguna chasnallata manzharinaura. Jesus randi Simonda rimara, Ama manzharichu nisha, cai yacu aichata japiccuinta cunanmanda ñaupagma runagunata tandachisha yachachic tucunguichimi paiguna ñucata catinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chita uyasha canuagunata pulayama sicachisha tucuita saquisha Jesusta catisha purinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus shuc llactai aushcai shuc ashca lepra nishca sinzhi carachayuc runa paita ricusha cungurisha allpama cumurira. Chasna rasha rugara, Can munashaga ñucata alichinata ushahuangui señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chasna nicpi Jesus paihua maquihuan llangasha, Munani, alichishca mangui. Chasna rimacpi chi urasllata tucui paihua ismurishca aicha illacta aliyarami. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chihuasha Jesus paita rimara, Ama pitahuas cuintanguichu astahuan israel pagrihuagma risha camba aichata ricuchigri. Chasnallata tucui runaguna can aliyashcata yachanauchun nishaga huañuc Moises mandashcatacuinta rasha pagrima cugringui camba aicha janbirishcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Randi tucui llactaibi Jesusmanda mas cuintashcaunami, chasna acpi ashca runaguna tandarinaura paita uyangahua. Chasnallata paihuagma ungüiguna shamunaura janbihuachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Chasna acpi Jesus randi runa illashca partima rira Dioshuan sapalla cuintanacungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Shuc punzha Jesus shuc huasibi yachachiushcai fariseogunas Moises mandashcata yachachiccunahuas chillai tiyarishca anaura paita uyasha. Paigunaga Galilea provinciamandas, tucui Judea provincia llactagunamandas, chasnallata Jerusalen llactamandahuas shamushca anaura. Chi uras Diospa ushai Jesuspacpi aura ungushca runagunata alichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pai yachachiushcai shuc runaguna shuc suchu runata paihua baitaibi apamunaura Jesus alichichun nisha. Chasna yuyarisha chi huasi ucuma yaicuchinata munanaura Jesuspagma ricuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chasna munagllaita yapa ashca runa tapacta tiyashcamanda mana ushanaurachu paita yaicuchinata. Chasna acpi jahuata sicasha, chi pala huasita juctusha chi baitaibi churashca runata jahuamanda tucui runagunahua chaupi shungüi urmachinaura Jesuspa ñaupacpi. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chasna ranaupi Jesus paiguna quirishcata ricusha chi runama rimara, Camba juchagunata anchuchishca tucunguimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pai chasna nicpi chibi auc Moises mandashcata yachachiccuna, fariseogunahuas shungu ucui yuyarinaura, Diosllami juchata anchuchic an. Pitan cai runa. Pai Dioscuinta tucusha rimacpi mana balinzhu, Diosta camishcacuinta riman nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Paiguna yuyariushcata yachashami Jesus paigunata rimara, Imangahuata canguna shungu ucui chasna yuyariunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Maican ranata mas yali sinzhi rana an, camba juchagunata anchuchishca nishachu mas raibaglla, jatari puri nisha rimanachu mas raibaglla, maicandan. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ñáucaga Runa Tucuc asha ima juchatas anchuchinata ushaiyuc auta canguna yachangahua cai suchu runata rimani, jatari camba baitata apasha huasita ri nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chi ratullata paiguna ricuushcai chi suchu runa jatarirami. Paihua baitata apasha paihua huasima Diosta alabausha bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chita ricusha tucui runaguna Diosta alabanaura. Yapa manzharisha casna rashcata ima uraspas mana ricushcanchichu ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesus chimanda llucshisha gubirnuraicu cullquita japic runa Leví nishcata tupara. Chi runa tarabauta ricusha rimara, Ñáuca runa tucushami catimuhuai. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chasna rimacpi jatarisha tucuita saquisha Jesusta catisha puringahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chihuasha Levíga Jesusraicu jatun jistata rara paihua huasibi. Chasnallata ashca gubirnuraicu cullquita tandachic runagunatas shuccunatahuas cayacpi tucui pariu Jesushuan mesai tiyarinaura micungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chi tunu runagunahuan Jesus tiyaricpi fariseoguna, Moises mandashcata yachachiccunahuas camisha mana alita rimanaura Jesus anllashca chunga ishcai (12) runagunata casna tapusha, Imangahuata canguna gubirnuraicu cullquita tandachic runagunahuan, juchayuc runagunahuanbas micusha upisha tiyanguichi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tapucpi Jesus paigunata rimara, Mana ungushca ali runagunaga doctorta mana minishtinaunzhu, randi ungushcagunallami doctortaga minishtinaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chasna acpi jucha illac mani nic runagunata mana japingahua shamuranichu. Randi juchayuc runagunata ñuca japingahuami shamurani paiguna juchagunata rashcamanda llaquirisha saquinauchun nisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chihuasha paiguna Jesusta tapunaura, Bautisac Juanhuan puriucunas, fariseogunahuan puriu runagunahuas ashca cutin Diosta mañasha mana micusha sasisha causanaun. Imangahuata canhuan puriucunaga micusha upisha causanaun mana sasisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tapunaupi Jesus randi paigunata tapura, Cadsarana cari tiyacpiga cayashca runaguna mana sasinaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Chi japic runacuinta ñuca ñucahuan puriucunahuan aupi paiguna mana cunan sasinaunzhu. Randi shuc punzha cuntar runaguna ñucata apashcaibimi ñuca amigoguna sasinaunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chasna rimasha cai yachachina shimita Jesus paigunata cuintara, Camba yachaiga rucucuinta asha mushughuan mana chapuibacchu nira. Mushuc churarinata pitinguichichu mauca churarinai rimindanguichu. Mana pihuas chasna ranzhu. Chasna racpiga chi mushuc churarinaga huaglichishca tucungami chasnallata chi mushuc pitiga maucaibi mana alitachu ricuringa. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chasnallata mauca tinajaibi mishqui asuata churacpi mana balinzhu. Churacpi tinaja paquiringa, asuas taliringa, tucui huaglingami. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Randi mishqui asuata ali tinajaibi churana man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chasnallata paigunata nira, Ali jurti asuata upishcahuasha chamucta mana munangachu, jurti asuata alimi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Israelguna shuc samana punzhaibimi Jesus shuc chagra ucuta pasaura. Pai japishca chunga ishcai (12) runaguna raicachicpi trigo muyugunata japisha carata lluchusha micusha riunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chasna raucta ricusha maican fariseoguna Jesusta ninaura, Ñáucanchita mandashca shimibiga samana punzhai mana tarabana changuichi nishca an. Chasna acpi imangahuata chasna raunguna samana punzhamanda quillcashcata mana cadsusha. Paiguna samana punzhataga mana balichinaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Chasna tapucpi Jesus rimara, Ñáaupa causac israel rey amu Davidmanda Diospa shimibi quillcashcata manachu ricushcanguichi. Paiga paihuan puriucunandi raicachicpi Diospa huasima rira micunata tapungahua. Chibi chi israel pagri amu Diosma ricuchishca panda cucpi David japisha micura. Chi panga israel pagrigunalla micuna pan mara, chasna agllaita David micura chasnallata paihuan puric runagunatas cura micuichi nisha. David chasna rashcamanda mana culpayachinguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ñáucaga Runa Tucuc ashami samana punzhahuas mandac ani nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Shuc samana punzhai Jesus shuc israel tandarina huasibi yaicusha yachachiushcai shuc huaglishca maquiyuc runa chibi aura, paihua ali maqui ñañuyashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chasna acpi Diospa shimita pasachic runaguna, fariseogunahuas yuyarinaura casna Jesus samana punzhaiga cai ungushca runata alichingachuraun, u chasnallachu saquingaraun nisha yuyarisha ricuunaura. Alichicpiga paita caudsayachishun ninaura samana punzha acpi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus randi paiguna yuyarishcata yachasha ñañu maquiyuc runata mandara, Jatarisha caima shayaric shamui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chasna shamusha shayaricpi Jesus chi caudsayachishun nisha yuyariucunata tapura, Cangunata tapuni, mandashca shimiga imasna tan. Samana punzhaga imata ranatan. Alichanma samana punzha ungushcagunata alichingahua, u manachu ali. Causaitachu cushun, huañungahuachu saquishun nisha tapura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tapucpi paiguna mana cutipacpi tucui runagunata ricusha Jesus chi runata nira, Camba maquita chutachi. Pai nishcata uyasha maquita chutachishcallai ali tucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Fariseogunaga Jesus rashcata ricusha yapa piñarinaura. Paigunapura cuintanacunaura imasna rashata Jesusta saquichishun nisha rimanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chi punzhagunai Jesus urcuma rira Dioshuan cuintanacungahua. Chasna rasha tutapagaricta Dioshuan cuintanacusha tiyaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cayandi punzha tucui paihuan puriucunata cayara. Pactamunaupi chi muntunmanda chunga ishcaita (12) anllara, ñuca japishca runaguna nishca tucusha ñuca shimita apasha puric runaguna tucunauchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Paiguna shutiguna anaura: Simon acta Jesus shutichira Pedro nisha. Chasnallata ara Simonba huauqui Andres, maspas Santiago, Juan, Felipe, Bartolome, Mateo, Tomas, Alfeohua churi Santiago, cananeo muntunmanda Simon, shuc Santiagohua churi Judas, chasnallata Judas Iscariote pai Jesusta japichingarauc runa. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus urcumanda uraicusha shuc pambai pactasha, ashca paihuan puriucunahuan tiyarisha yachachiura. Chasnallata tiyaushcauna ashca runaguna Judea llactagunamanda, Jerusalenmandahuas. Chasnallata Tiro, Sidón nishca llactagunamandahuas shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesus yachachishcata uyangahua, chasnallata paiguna ungushcagunata alichichun nisha shamunaura. Supai yaicushca runagunatahuas alichishca tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Diospa ushai Jesusmanda llucshicpi tucui runaguna paita llangasha ali tucunaura. Chimandami tucui runaguna paita llanganata munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chihuasha Jesus paihuan puriucunata ricusha yachachingahua callarira casna nisha, Canguna pugri ashallata Diospa ali mandana cangunahuac ashcamanda cushi manguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Cunanbas raicachiushallata cushi manguichi nira, huashaga sacsanguichimi nira. Cunan llaquiriushallata cushi manguichi, huashaga asingaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ñáucata Runa Tucuc nishcata canguna catishcamanda cangunata piñaitucunguichi, paigunahuagmanda cangunata anchuchingaunami, cangunamanda mana alita rimangaunami. Chasna racpi cushi anguichi ñucahuan puriushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Paiguna apayayagunaga chasnallata mana alita ranaurami Dios rimashcata pasachic runagunata. Paiguna cangunataga chasna ranaupiga cushiyaichi ashcata. Manachu yachanguichi jahuapachai auc Yaya Dios cangunata ashcata cungamiraun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jesus mas yachachira casna nisha, Astahuanbas charic runagunaga, llaquirishca tucunguichi, cunan urasllata cushiyaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Cunan pactacta auc runagunaga, llaquirishca tucunguichimi, huashaga raicaitucungaraunguichi. Cunan asiuc runagunaga huasha llaquirisha huacanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tucui runaguna cangunamanda ali shimita rimacpiga manzhaibac an. Paiguna huañuc apayayagunaga chasnallata chi Diosmanda rimaunchi nisha llullaucunamanda ali shimita rimanaura nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesus chi runagunata mas rimara casna nisha, Tucui ñucata uyaccuna cangunata nini, cangunata piñauc runagunatas llaquina manguichi, paigunata alita raichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cangunamanda mana alita raucunamandaga Dios alita paigunata yanapachun nisha yuyarina manguichi. Cangunamanda mana alita rimasha camiucunata Diosta tapuichi paigunata yanapachun nisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Shuc runa canda huactacpi canda huactachunlla, can randi ama huactaichu, astahuanbas ali yuyaihuanmi causaichi. Maican runa camba camidsata apacpi ama mitsasha shuctahuas cui. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tucui canda tapuc runagunama cuichi nira. Maican runahuas can charishcagunata apacpi ama cuti cuhuai nichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imasna shuc runa ñucata alita rahuachun nisha, chasnallata cangunas paigunata alita rashami causaichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mana alita rauc runagunaga paigunapurallata llaquinacunaunmi. Paigunacuinta cangunata llaquiucunallata llaquishaga Diospacpi alitachu raunguichi. Pishita ranguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mana alita rauc runagunaga paigunapurallata alita rananacunmi. Canguna chasna raushaga Diospacpi alitachuraunguichi. Pishita raunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mana alita rauc runagunaga cullquita mañachinacunaunmi paigunata cutichic runagunallata. Canguna chasna raushaga Diospacpi alitachuraunguichi. Pishita raunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Randi ñuca nini, cangunata piñaucunata llaquichi, paigunata alita raichi. Paiguna mañachishaga cutichihuangachuraun nisha ama yuyarishachu mañachilla. Chasna shuccunata alita racpi Yaya Dios cangunata ashcata cungami. Chasnallata jatun Diospa huahuaguna nishca manguichi. Diosca tucuitami llaquin, mana pagrachu nic runagunatahuas llaquinmi, chasnallata mana alita raucunatahuas llaquinmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yaya Dios cangunata llaquisha yanapashcacuinta cangunahuas shuccunata alita llaquisha yanapana manguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Shuccunata ama culpasha mana alita rimanguichichu. Canguna mana culpacpiga Dios cangunata randi mana culpaitucunguichi. Chasnallata shuccunatas ama yanga caudsachinguichichu. Canguna shuccunata caudsayachicpiga Dios cangunatas caudsachishca tucunguichimi nira. Shuccunata perdunasha cungarichi. Can chasna perdunacpiga cangunatas perdunaitucunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yanga cumbirasha cuichi. Canguna yanga cucpiga Dios cangunata alita cungami. Shuc bultsata cuyuchisha, cuyuchisha jundacta jundachishcacuinta cangunatahuas chasnallata cushca tucunguimi. Ima tuputa canguna cucpihuas chi tupullatata cangunatas cuitucungaraunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chihuasha Jesus cai yachachina shimimanda paigunata tapura, Shuc puyuñahui runaga shuc puyuñahuiyucta pushanata ushanzhu. Manachu ishcandi (2) juctui urmangauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Shu catiu runa paita yachachiuc runamanda mana chicanda tucunzhu, randi alita yachachishca runa paita yachachiucuinta tucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Caspigunamanda yuyarichi. Camba quiric huauquihua ñahuibi shuc ichilla caspicuintata ricunimi nishallata, shuc jatun caspicuintata camba quiquin ñahui auctas ricunata mana ushangui. Chi caspigunaga juchacuinta man. Diospacpi can mas yapa juchayuc ashallata juchata mana charinichu nisha rimaunguichi. Can jatun jucha rashcata mana yuyarishallata camba quiric huauqui ichilla juchamanda yapa rimaungui. Chasna niusha mana alitachu raungui. Ñáaupa camba quiquin juchata saquisha, chihuasha camba huauquihua juchata saquichingahua yanapanata ushangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ali ruyai ali muyugunata aparinaun. Mana ali ruyaibiga mana ali muyugunatachu aparinaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Caran ruya paihua tunu muyuta aparinmi. Casha ruyamanda higo nishca micuna muyuta mana pallanguichichu, chinimanda uhuillas muyugunata mana pallanata ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chasnallata ali runaga alita yuyarishcamanda alitami riman. Mana ali runaga pai mana alita yuyarishcamanda mana alitachu riman. Caran amu paihua shungumanda yuyarishcata rimanmi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesus paigunata tapura, Imangahuata ñucataga señor nihuanguichi ñuca shimita mana pactachiushallataga. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ñáuca yachachishcata pactachimuc runaga casna man: ");
INSERT INTO qvzNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Shuc runa paihua huasita shayachiusha, yapa ucuta rumigama allashami istandita shayachira. Chasna rashcahuasha yacu mana cáilla jundashahuas yacu mana tulanata usharachu sinzhi allpaibi shayachishcamanda. Ñáucata pactachic runa chicuinta man. ");
INSERT INTO qvzNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Randi rinrihuan ñucata uyasha mana pactachic runaga casnami: shuc runa paihua huasita pulayaibi shayachira. Yacu mana cáilla jundasha cungaimanda chi huasita tulasha illacta apara. Ñáucata rimashcata rinrillahuan uyasha mana pactachiu runa chasnacuinta man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus chi runagunata ashcata yachachishcahuasha Capernaun llactama bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chibi shuc romano sundalugunata mandac amu tiyaura. Pai yapa llaquishca paita cuirac runa chi uras huañunalla tucusha siriura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chi sundalu mandacca Jesusmanda cuintauta uyashami maican israelgunata mandac rucu runagunata Jesuspagma cachara pai shamuchun nisha ñuca runa huañucta alichipac shamuchun nisha shimita cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Cachacpi paiguna Jesuspagma pactasha ashca cutin ruganaura casna nisha, Cai sundalugunata mandacca ñucanchi llactata llaquigmi, caibi ñucanchi tandarina huasita cushcami. Chimandaga can pai llaquishca runata alichicpiga ali manga ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chasna nishcata uyasha Jesus paigunahuan rira. Riusha sundaluta mandacpa huasi mayanbi pactaupi chi mandacca cutillata paihua amigogunata Jesuspagma shimita cachara, Señor nisha, ama tarabusta shamunguichu. Mana balicchani canga ñuca huasibi yaicungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ñáuca mana balic ashcamandami ñuca mana cambagma shamurani. Chasna acpi can shimillahuanbas rimapai ñuca runa ali tucupachun. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ñáucaga sundalu asha mandashcagunata uyac mani, chasnallata sundalugunataga mandac ani. Shuc sundaluta ri nisha rimacpi rin, shucta shamui nisha rimacpi shamun. Ñáucata yanapac runata caita rai nisha mandacpi ran. Cunanga chimandalla rimai, can rimashcashina ña tucungami. Chasna nisha chi sundaluta mandacca chi shimita Jesusma cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus chi mandac runa cachashca shimita uyasha cushiyara. Paita catic runagunata rimara, Cai tunu sinzhi quirinata mana maibihuas tupashcanichu, ni israel runagunahuacpihuas mana tupashcanichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chihuasha chi cachashca runaguna mandacpa huasima bulltiasha chi ungushca runa ña ali tucushca acta ricugrinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mana unai punzhahuasha Nain nishca llactama Jesus pai japishca chunga ishcai (12) runagunandi riushcai yapa ashca paita caticcunahuas paihuan rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chi llactama pactaushcai shuc huañushca musu runata pambangahua apaucunata tupanaura. Chi huañucpa mamaga huaccha huarmi mara, chi huañuc churillata charishca ara. Chi llactamanda ashca runaguna paita pambanata yanapangahua cumpañasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus chi huaccha huarmita ricusha llaquisha, Ama huacaichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chasna nishcahuasha aya cajunda llangangahua rira. Llangacpi apaucuna shayarinaura, shayarinaupi chi huañushcata jatari nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chasna nigllai chi huañushca musu runa causarisha jatarira, cuintangahua callarira. Chasna racpi Jesus chi huaccha huarmita camba churita apasha ri nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tucui runaguna chita ricusha manzharisha Diosta alabanaura casna nisha, Ñáucanchi paihua runaguna ashcamanda cunan ñucanchita yuyarishcami yanapangahua. Pai rimashcata shuc balic pasachic runa paihuagmanda ñucanchihuacpi pactamushcami ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesus chasna rashcagunamanda tucui Judea provinciaibis, tucui shuc llactagunaibihuas cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanhuan puric runaguna tucui Jesus rashcagunamanda paita cuintagrinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Cuintacpi Juan paihuan puriccunata ishcaita (2) Jesuspagma cachara, Canzhangui Dios cachashca runa, shuctachu chapashun nisha tapungahua cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cachacpi Jesuspagma pactasha rimanaura, Bautisac Juan ñucanchita canmami cachaitucuranchi canda tapungahua canzhangui Dios cachashca runa, shuctachu chapashun nisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Paiguna pactamushca uras Jesus ashca ungushca runagunata alichiura, supaitahuas runagunamanda llucshichira. Chasnallata ashca puyuñahui runagunatas janbira, paiguna cutillata alita ricungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus chasna rashcahuasha chi Juan cachashca runagunata rimara, Canguna tucui ricushcagunatas uyashcagunatahuas Juanda rimagrichi. Puyuñahui runagunaga cunan ricunaunmi. Ñáaupa mana puric runagunahuas cunan alita purinaunmi. Lepra nishca sinzhi carachayuc runagunahuas janbishca tucunaunmi. Mudu rinriyuc runaguna cunan alita uyanaunmi. Huañushca runagunahuas cuti causarishcaunami. Pugri runagunaga Diospa quishpina shimitas uyanaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Maican ñucata quirisha mana saquic runaga yapa cushi causangami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan cachashca runaguna bulltiashcahuasha, Jesus chibi tiyac runagunata Juanmanda rimara, Canguna Juan camachiushcata uyashun nisha chi pi chaquishca pambama risha imata ricungahuata riranguichi. Huaira cuyuchiushca shinlutacuinta mana sinzhi quiric runata ricungahuachu riranguichi. Mana. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Manáshaga imata yuyarisha riranguichi, sumac churarishca runata ricungahuachu riranguichi. Yachanguichimi sumac churarishca runagunaga jatun amuhua huasigunaibimi cungailla causaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chasna acpi Juanbagma risha imata ricungahua yuyarishata riranguichi. Canguna Dios rimashcata pasachic runatachu ricungahua riranguichi. Indá. Chasnallata cangunata nini, tucui Dios rimashcata pasachic runagunamanda Juanga mas balic ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dios paihua shimibi Juanmanda rimasha casna quillcachira: Ricui, ñuca shimita rimac runatami ñaupata cachauni paiga camba ñambita alichigriuchun nisha Dios nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sirtutami cangunata nini, Cai pachai tucui runagunamanda Bautisac Juanmanda yali mana pihuas tiyarachu. Astahuanbas Diospa ali mandana muntunbi maican mana balic niushca ashallata Juanmanda mas yali balichiushca manga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesus cuintashcata uyasha tucui runaguna, gubirnuraicu cullquita tandachiccunahuas, Juan bautisashca runaguna ashcamanda Diosca Juanda cachashcamanda alita rashcami nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Randi fariseogunaga, Moises mandashcagunata yachachiccunahuas mana Juan bautisashca runaguna ashcamanda Dios paigunata alita rachun nigllaita mana munanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chasna mana munacpi Jesus paigunata rimara, Cunan causac runaguna imashinata causaunguna, imasnata yuyariunguna nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pugllac huahuagunacuinta asha yangamanda piñanaun. Huahuaguna shu jistata pugllasha piñanaun casna caparisha, ñucanchi ulahuatuta tucacpi canguna mana bailaranguichichu ninaun. Cuti chihuasha ayata bilashcatacuinta pugllasha piñanaun casna caparisha, ñucanchi llaquilla huacacpihuas mana huacaranguichichu nisha cuintanacunaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Cunan uyaichi, canguna ñucata piñaccuna asha chi pugllac huahuagunacuinta manguichi. Bautisac Juan shamusha ali micunata mana micusha asuacuintata mana upishahuas puriura. Chasna causaupi canguna rimaranguichi paiga supai man. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ñáuca randi Runa Tucuc asha, jistama risha micusha upisha raucta ricusha canguna rimahuaranguichi ñucata jillu mangui nisha, machaisiqui runa mangui nisha rimahuanguichi. Gubirnuraicu cullquita tandachic runagunahuan, juchayuc runagunahuanbas amigota raungui nisha ñucata piñasha rimahuanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yuyarichi. Tucui Yaya Dios rashcagunaga ricuchinaunmi pai sirtu yuyaiyuc acta nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chihuasha shuc fariseo runa Jesusta cayara paihua huasima micuc shamuchun nisha. Chasna cayacpi Jesus pai japishca runagunandi chi fariseo huasima risha mesaibi tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Ñáa pai tiyauta yachasha chi llactai ashiyachisha causac huarmi balic asnac yacuta apamusha Jesuspagma shamusha paihua chaqui mayanbi shayarira. Huacasha paihua ñahui yacu Jesuspa chaquita jucuchira. Paihua acchahuan Jesuspa chaquita chaquichisha muctisha chi balic asnac yacuta talira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chi cayamuc fariseo runa chita ricusha yuyarira, cai runa Dios rimashcata sirtu pasachic runa ashaga chi llangac huarmi ashiyachisiqui actaga yachanmami nisha yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chasna yuyaricpi Jesus paita nira, Shuc rimanata charini canda cuintanata, Simon. Chasna nicpi, Rimahuailla señor nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nicpi Jesus cai yachachina shimita casna nisha cuintara, Shuc runa cullquita mañachira ishcai runama. Shuc runata pichca chunga (50) cullquita mañachishca ara, shuctaga pichca patsacta (500) cullquita mañachishca ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Paiguna mañashca cullquita mana charisha chi mañachic runama cutichinata mana ushanaurachu. Mana paganata ushanaupi ishcandita paiguna dihuita huiñai pasachira. Ñáuca canda tapuni Simon, chi ishcai runamanda maicanda chi mañachic runataga mas llaquinga. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tapucpi Simon cutipara, Chi mas ashca dihuita huiñai pasachitucushca runami ñuca ricucpi mas llaquinga. Nicpi, Chasna man can rimashcashina, Jesus nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chasna nisha yuyachishcahuasha chi huarmita ricusha Simonda cuti rimara, Cai huarmita ricunguichu. Ñáuca camba huasibi yaicushcai yacullahuas mana cuhuaranguichu ñuca chaquita maillaringahua. Cai huarmi randi paihua ñahui yacuhuan ñuca chaquita maillasha paihua acchahuan chaquichihuashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Can ñucata saludangallahuas mana caillahuaranguichu. Pai randi ñuca caibi yaicushca urasmanda ñuca chaquita muctinata mana saquihuanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñáuca umaibi gustu asnac yacullahuas can mana talihuaranguichu. Pai randi ñuca chaquibi gustu asnac yacuta talihuashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Canda nini, Simon cai huarmi yapa ashca juchamanda anchuchi tucushcamandami yapa llaquihuan. Randi maican runa ashilla juchamanda anchuchitucushca ashami ashillata llaquihuan nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Huasha chi huarmita nira, Can jucha rashcaguna huin anchuchishca mangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chasna rimacpi mesai tiyauc runaguna yuyarinaura, Pitan cai runaga, juchata anchuchishca mangui nisha rimacca. ");
INSERT INTO qvzNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Paiguna casna yuyarinaupi Jesus chi huarmita rimara, Ñáucata quirishcamanda canga quishpichishca tucungui. Cushiyasha ri. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chihuashalla Jesus tucuita purisha yachachiura jatun llactagunaibis, ichilla llactagunaibihuas. Diospa ali mandanamanda cuintasha yachachisha purira. Pai japishca chunga ishcai (12) runaguna paihuan puriunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chasnallata aunaura ungüigunamanda alichishca huarmigunas, supaita llucshichishca huarmigunahuas. Shucca, Magdalena nishca llactamanda Mariata canzhis (7) supaita llucshichishca mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chasnallata Juana, Susana, mas shuc huarmigunahuas aunaura. Juanahua cari Chuza nishcaga mandac amu Herodespacpi tarabac runagunata mandac mara. Tucui chi huarmiguna paiguna cullquitas micunatas cusha Jesustas paihuan puriu runagunatas cuiranaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Chasna puricpi ashca runaguna caran llactamanda shamusha tandarimucpi Jesus cai yachachina shimita paigunata cuintara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Shuc tarpuc runa paihua muyuta tarpungahua rira. Jichaupi maican muyugunaga ñambibi urmanaura. Chasna urmacpi runa chibi purisha jaitacpi allpa ucuma taparinaura. Chasnallata maican muyugunata pishcu micunaura nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Shuc muyugunaga ashca rumi aushcai urmanaura. Allpa illashcamanda chaquirisha huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Shuc muyugunaga huita ucui urmanaura. Chasna tucucpi sacha quihuaguna huiñasha chi muyugunata tapara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Shuc muyugunaga ali allpai urmanaura. Chibi urmasha huiñasha yapa alita aparinaura. Caran shuc muyumanda patsac (100) muyuta aparirami nira. Jesus chi yachachina shimita tucuchishcahuasha mas sinzhita rimara, Rinriyuc runaguna ashaga ñuca rimashcata alita yuyarichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cuintashcahuasha paihuan puriccuna paita tapunaura, Can rimashca shimiga imamandata yachachin. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tapunaupi Jesus nira, Diospa ali mandanamanda ñaupa mana pagllai yachachishcachara. Randi cunanga canguna yachanauchun nisha cangunata yachachini. Chi shuc runagunaga ñuca rimashcata uyasha mana munaihuanzhu uyaunguna. Ñáuca rashcata ricushahuas mana yachashachu ricunaun, ñuca yachachishcata uyashahuas mana yuyarinaunzhu. Chiraicu cuintana shimigunallahuan paigunata rimani nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cai yachachina shimiga casna nin, chi muyuga Diospa shimicuinta man. Allpagunaga pai quishpina shimita uyac runagunacuinta manaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Maican runaguna Diospa shimita uyashallata chi ñambibi urmacta pishcu micushca muyugunacuinta manaun. Uyagllaita supai shamusha paiguna uyashcata shungumanda quichun paiguna ama quirisha quishpinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Shuccunaga ashca rumi tiyaushcai urmac muyucuinta manaun. Munaihuan Diospa quishpina shimita uyasha cushihuan uyanaun, quiringahua callarinaun. Chasna agllaita camana llaquiguna shamucpi angu illac ruya urmashcacuinta quirinata saquinaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Shuccunaga huita ucui urmac muyucuinta manaun nira. Diospa quishpina shimita uyasha quirinaun, randi paiguna quiquin causaita yuyarisha imatas rasha nisha turbarinaun. Chasnallata mas charic tucungahua paiguna quiquin causaita cushiyachingahua yuyarisha causanaun. Chasna causasha Diospa munaita mana rashaga Dios munashcacuinta tucunata mana ushanaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Randi shuc runagunaga ali allpai urmasha huiñac muyucuinta manaun. Diospa quishpina shimita tucui shunguhuan uyasha cadsushami mana ansas saquingachu. Chasna asha chi ashca aparic muyugunacuinta Dios munashcashina ashca aligunata ranaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pihuas bilata japichisha mangahuan mana tapanaunzhu, mana cayutu ucui churanaunzhu. Randi jahuaibi churanaun tucui yaicuc runaguna alita ricungahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chi bila ricuchishcacuinta tucui pacalla rashcagunaga huasha pagllai ricuringaraun. Tucui itsanlla rimashcagunaga huasha pagllai uyaringami. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chasna acpi ali yuyaihuan uyaichi. Maican ali yuyaita charic runa paima mas yuyaita cushca tucungami. Randi mana yuyarisha uyac runaga pai uyashcagunata quichuitucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chihuasha Jesuspa mama paihua huauquigunas paihuagma caillayanata munanaura randi ashca runa taparishcamanda mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chasna acpi shuc runa Jesusta nira, Camba mama, camba huauquigunahuas canda ricushun nisha canzhaibi shayaunguna nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Paiguna ñuca quiquin mama ñuca huauquiguna ashahuas mana paigunallachu ñuca aillu anaun nini, astahuanbas pihuas Diospa shimita uyasha pactachicpi ñuca mama, ñuca huauquigunas nishca tucunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Shuc punzha pai japishca runagunandi canuaibi yaicusha Jesus paigunata nira, Jacuichi chimbashun cucha chimba partima. Chasna nicpi chimbangahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chimbaushcai Jesus puñuura. Pai puñuushcai ashca huaira shamusha sinzhita huairara. Ulas canuama yapa jundarisha ña pambaringa callarira. Manzhanayacta cadsi tigrara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chasna tucucpi Jesusta puñuucta nicchachinaura, Tigraunchimi, huañungaraunchi señor nisha caparinaura. Jesus niccharisha sinzhi shimihuan huairatas yacutahuas saqui nisha rimara. Chasna rimacpi huaira saquirira, ulaspas saquirisha mansu tucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chasna rashcahuasha paihuan puriucunata tapura, Maitan canguna sirtu quirishcaga. Manzharisha paigunapura pariu cuintanacunaura, Huairata yacuta rimacpi pasarira, chasna acpi ima runatan paiga nisha paihuan puriucuna manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chihuasha cuchata chimbasha Gadara nishca partima pactanaura. Chi allpaga Galilea provinciata chimbashcai ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Jesus canuamanda llucshiushcai chi llactamanda supai yaicushca runa Jesusta tupac shamura. Chi runaga unai supai yaicushca tiyac asha lluchu puric ara, huasibi tiyana randimanda huañushcata pambashca urcu juctugunaibi causac ara. Runaguna paillata ama picarichun nisha ashca cutin cadenagunahuan maquitas chaquitas huatacpihuas supai ushaihuan chi cadenagunata pitisha runa illashca partima callpausha rira chi supaiguna paita apashcamanda. Chasna rasha chi supaiguna chi runata yapa binsishca ara. Chi runa Jesusta ricusha paihua chaqui mayanbi cungurisha urmagrira. Chasna acpi Jesus chi supaigunata mandara cai runa ucumanda llucshisha ri nisha. Mandacpi supaiguna sinzhita caparira, Can jahuapachai tiyauc jatun Diospa Churi mangui Jesus. Imangahuata ñucata quillachihuangui. Canda rugani ñucata ama turmintachihuaichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chasna caparicpi supaita Jesus tapura, Ima shutitangui. Tapucpi, supailla Atirishca nishca mani nira. Chasna shutichishca ara yapa ashca supaiguna huaranga huaranga paihuacpi tiyaushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chi runa ucui tiyauc supaiguna Jesusta yapa ruganaura ñucanchita ama ucupachama cachahuanguichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ñáa chi urasllata chi urcuibi ashca cuchiguna micusha shayaunaura. Chasna tiyacpi supaiguna Jesusta ruganaura cuchigunai yaicuchihuai nisha. Chasna rugacpi Jesus paigunata yaicuichilla nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nicpi supaiguna chi runa ucumanda llucshisha cuchiguna ucui yaicunaura. Yaicucpimi chi cuchigunaga huaicuma callpashami tsan urcumanda yacui urmasha yacuta chucasha huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chasna yacui huañunaupi cuchi cuirac runagunaga chita ricusha llactama callpasha tucui tupariccunata cuintagrinaura llacta ucuibis maibihuas. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Runaguna chita uyasha paiguna quiquin ñahuihuan ricushun nisha rinaura. Jesuspagma pactasha supaita callpachishca runatas ricugrinaura. Chi runa ali yuyaihuan acta tupagrinaura, churarisha auta, Jesuspa chaqui mayanbi chunlla tiyauta ricunaura. Chita ricusha manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chibi ausha ricuc runaguna chi shamuc runagunata supaiyuc runata Jesus alichishcata tucuita cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chasna tucucpi tucui Gadara partibi tiyac runaguna yapa manzharisha Jesusta ruganaura ñucanchi llactamanda llucshisha ripailla nisha. Chasna nicpi Jesus canuai cuti yaicusha chimbamallata bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Chara mana rigllaita chi supaita llucshichishca runa paita rimara ñucatas pushahuai. Randi Jesus paita cachara, Camba quiquin huasima bulltiai Dios tucui canda rashcata cuintagri nisha. Chasna nishcata uyasha chi runa paihua llactama risha Jesus paita alichishcata tucuima rimasha purira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus cuti chimbama bulltiamucpi tucui runaguna paita chapasha tiyashcamanda ricusha cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pai bulltiamushcata yachasha israel tandarina huasita cuirac amu Jairo nishca, Jesuspa chaqui mayanbi cungurisha rugara, Ñáuca huasibi ñuca ushushita alichic shamui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chi runa shuc ushushillata charic arami, chi ushushiga chunga ishcai (12) huatayuc mara. Ñáa chi uras huañungaraura. Jairo rugashcata Jesus uyasha riupi ashca runaguna paita catisha tángai tángai rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chi muntunbi shuc ungushca huarmi riura, chunga ishcai (12) huatata rahuai urmauglla huarmi ara. Paihua cullquita doctorgunai llambu tucuchira janbirisha nisha, randi pihuas janbinata mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chasna acpi chi huarmi Jesuspa huashamanda shamusha caillayasha paihua llachapa pundata llangacpi cungaimanda rahuai saquirira, pai aliyashca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chasna tucucpi Jesus tapura, Pita ñucata llangahuara nisha. Pai tapucpi tucui runaguna rimanaura ñucanchi candaga mana llangaranchichu nisha. Pedrohuas nira, Ashca runagunami cambacpi caillayasha tacarinaun señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Randi Jesus nira, Shuc runa ñucata llangahuara. Diospa ushaiga ñucamanda llucshishami runata alichishcata yachanimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chasna nicpi chi llangac huarmi miticunata mana ushasha, manzharisha Jesuspa chaqui mayanbi cungurira. Tucui runaguna ricushcai pai imangahua llangashcata cuintara, chasnallata llangashcallaiga alimi tucushcani nisha cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Cuintashcahuasha Jesus paita nira, Ñáucata quirishcamandami can alichishca tucungui, cunanga cushihuan ri nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus chara cuintaushcai Jairohua huasimanda shamuc runa pactamusha, Camba ushushi ña huañui pasanmi, cunan Señor Jesusta ima quillachichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus chita uyasha Jairota nira, Ama llaquirichu, can ñucata quiricpi camba ushushiga aliyasha causaringami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ñáa huasima pactasha ricura tandarisha huacasha aucunata. Chita uyasha paigunata nira, Ima yanga huacaichichu, pai mana huañushcachan, puñuunmi nira. Chita uyasha runaguna huahua huañushcata yachasha Jesusta asinaurami. Jesus ña tucui chi runagunata canzhamalla saquichisha, Pedrota, Juanda, Santiagota, chi huañucpa yayata, mamatahuas huasi ucuma paigunallata pushara. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ucuma yaicusha huahua maquita japisha, Jatari mamacu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pai rimashcallai chi huahua causarisha cungaimanda jatarira. Jataricpi Jesus paihua mamata rimara micunata cuichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Paihua mamas yayahuas ñucanchi huahua causarinmi nisha cushiyagllaita Jesus randi paigunata, Ñáuca casna causachishcataga ima pitas cuintanguichichu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus pai japishca chunga ishcai (12) runagunata paihuagma cayasha ushaita cura tucui supaigunata mandasha llucshichisha cachachun nisha, chasnallata ungüihuan causaccunata alichichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ushaita cusha cachara Diospa ali mandana runa imasna tucunamanda yachachigrichi nisha, chasnallata ungushca runagunata alichigrichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Cachausha paigunata rimara, Canguna chasna rasha puringahua riushaga ama imatas apanguichichu. Shigrata, barata, micunata, cullquitas ima apanguichichu. Ishcai churarinatas ima apanguichichu, canguna churarishcallahuan richi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Llactai pactashcai maican huasibi yaicuchicpiga chillai tiyangui chi shuc llactama rinagama. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Randi maican llactaibi cangunata mana uyanata munacpiga chi llactamanda llucshinguichilla. Llucshiusha canguna chaquimanda chi llacta allpa pulbuta sáa picharinguichi paiguna mana ali rashcata ricuchingahua, nisha Jesus paigunata cunara. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesus cachacpi chi chunga ishcai (12) runaguna llucshisha tucui llactagunama risha Jesusca quishpichic man nisha camachiusha purinaura. Chasnallata tucui chibi tiyac ungushca runagunata alichinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mandac amu Herodesca tucui Jesus rashcagunata uyasha chiga pitan nisha manzharira. Maican runagunaga, Bautisac Juan huañushcamanda cuti causarisha chasna rasha puriun nisha cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Shuccunaga Dios rimashcata ñaupa pasachic Elias nishca runa cuti ricuriun nisha cuintanaura. Shuccunaga Dios rimashcata ñaupa pasachic runami causarisha puriun nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes randi paigunata rimara, Ñáucallatami mandarani Juanba cungata pitigrichi nisha. Cunanga maicandaya cai runaga. Pai ashcata alichishcagunata uyashcani nira. Chasna nisha Jesusta ricunata yapa munara. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chi Jesus chunga ishcai (12) camachingahua cachashca runaguna cuti bulltiamusha tucui paiguna rashcagunata Jesusta cuintanaura. Chihuasha Jesus paigunata pushara Betsaida nishca llacta mayanbi paigunapuralla tiyagringahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Randi runaguna Jesus chima ricta yachasha paita catinaura. Catisha risha paiguna pactanaupi Jesus paigunata cushihuan ricusha shamuichilla nisha Diospa ali mandanamanda yachachira imasna Diospa runa tucunata, chasnallata ungushcagunatas alichirami. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chasna raupi chishiyaura. Chishiyaushcata ricusha paihua chunga ishcai runaguna Jesusta ninaura, Tutayaunchimi, tucui runagunata cachai maican huasibihuas micugrinauchun, puñunauchun, caibiga huasi micunahuas illanmi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus randi paigunata nira, Cangunallata paigunata micunata caraichi. Rimacpi ninaura, Micuna illanmi. Pichca (5) pan, ishcai (2) yacu aichallata charinchi, caillata. Ñáucanchi tucui cai runagunata carangahuaca llactama rinachu tucunchi micunata randingahua nisha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chi muntunbi pichca huaranga (5.000) tupushi cariguna anaura. Chasna acpi Jesus pai anllashca runagunata mandara, Canguna cai runagunata rimaichi caran pichca chunga, pichca chunga (50) runa tucusha tiyarinauchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesus rimashcata uyasha tucui runagunata pai nishcashina tiyachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Paiguna tiyarishcahuasha Jesus chi pichca panda, ishcai yacu aichatas japisha, jahuama ricusha Diosta pagrachu nira. Pagrachu nishcahuasha micunata paquisha paihua runagunama cura paiguna randi tucui runagunata cunauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chasna cucpi runaguna sacsacta micunaura. Tucui micushcahuasha paquishca puchugunata tandanaura, chunga ishcai (12) ashanga tuputaga. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesus shuc punzha sapalla Yaya Dioshuan cuintanacunasha mañaura. Pai japishca chunga ishcai (12) runaguna paihuan aushcai Jesus paigunata tapura, Runaguna ñucamanda rimasha pitan nishata niunguna. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tapucpi rimanaura, Maican runagunaga can Bautisac Juan man nishami rimanaun. Shuccunaga Dios cuti cachangaraushca ñaupa causac Elias man nishami rimanaun. Shuccunaga can shuc Dios rimashcata ñaupa pasachic runa causarishcami nisha rimaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chasna rimanaupi paigunata tapura, Cangunaga pi man nishata ñucata niunguichi. Chasna tapucpi Pedro rimara, Canga Dios cachamushca quishpichic Cristo mangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chasna nicpi Jesus paigunata mandara ama pitahuas cunan rimanguichichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chasnallata nira, Ñáuca Runa Tucuc asha yapa turmintachishca tucunami ani. Israelgunata mandac rucuguna, pagri amugunas, Moises mandashcata yachachiccunahuas ñucata mana balichisha huanchihuanaunga. Chasna huanchicpihuas quimsa (3) punzhaibi cuti causarishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesus tucui chigunata rimara, Maican runa ñucahuan catinata munasha paihua quiquin munaita saquichun. Chasna saquisha shuc cruspi huanchitucungaraushca runacuinta ñucallata yuyarisha catihuai. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pihuas paihua quiquin causaita llaquisha causaushaga huiñai chingarishcami tucunga. Astahuanbas maican runa ñucata catisha causaushcamanda huanchitucushahuas quishpishca tucusha Yaya Dioshuan huiñai causangami. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Shuc runa tucuita cai pachai ima tiyactas charic ashahuas pai huañushcai mana imatas charingachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Maican runa ñucamandas, ñuca shimimandahuas pingasha shuc runagunama cunan mana rimacpiga ñucahuas jahuapachai paimanda pingarishami. Ñáuca jatun mandac amu tucusha ñucahua Yaya ushaihuan, paihua angelgunahuanbas shamushcai chi ñucamanda pingaric runata mana balichishachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cangunata sirtuta nini, maican caillai shayarisha uyaucuna chara mana huañushallata Diospa ali mandana ashcata ricungaraunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chasna Jesus yachachisha shuc semana tupui Pedrota, Juandas, Santiagotas urcuma pushasha rira Dioshuan cuintangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dioshuan cuintaushcai Jesuspa ñahui shuc tunu ricuric tucura, paihua llachapahuas ruyac chiujlla ricuric tucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chi urcui ishcai (2) runaguna Jesushuan ricurinaura unai ñaupa causaucuna, shucca Moises, shucca Elias manaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Paigunahuas chasnallata punzhaglla ruyac ricuric manaura. Jesushuan cuintanacusha can Jerusalenbi Dios munashcata pactachisha huañugringaraungui nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Chasna tucuushcai Pedro paihuan ishcai aucunandi yapa puñunayaunaura. Randi ñahuita picharisha ricucpi Jesus chiujlla ricuriucta ricunaura, chasnallata paihuan ishcai shayaucunatas ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chi ishcai runaguna Jesusmanda anchurisha riushcai Jesusta Pedro nira, Ima gustutanma ñucanchi caibi saquiringahua señor. Quimsa (3) ranchugunata rashun, canraicu shucta, Moisesraicu shucta, Eliasraicuhuas shucta nira. Pai chasna rimashcaga paillata mana alita yuyarishallata chasna rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pai chasna rimaushcai shuc puyu shamusha paigunata catara. Chasna tucucpi Pedroguna yapa manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chi puyu ucumanda shuc shimi uyarira, Caiga ñuca churi man, paita cachasha nisha anllashcani, paitami uyana anguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chi shimi uyarishcahuasha Jesuslla shayaucta ricunaura. Pedroguna tucuita chasna ricushallata chi punzhagunaibi mana pitahuas cuintanaurachu, paiguna yuyaillai charinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cayandi paiguna chi urcumanda uraicumushcai ashca runaguna Jesusta tupangahua riunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chi muntunmanda shuc runa caparira, Señor ñuca churita alichipai, ñuca shuglla churi casna tucupan señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paita supai yaicucpi cungaimanda sinzhita yapa caparin. Shimimandas puscu llucshinagamami supai paita chucchuchisha huanchiun. Paihuagmanda mana anchurinzhu chiraicu huañun. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chasna acpi can japishca runagunata rugarani supaita llucshichipai ñuca churimanda nisha randi mana ushanaurachu nira chi runa. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus chita uyasha rimara, Cangunaga ñucata mana quirishami, ñuca yachachishcatas mana uyanata munanguichichu. Ima urascamata cangunahuan tiyanata ahuantasha. Camba churita caima apamui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chi musu runa Jesuspagma caillayaushcai supai paita macashcacuinta shinzhita allpai urmachisha ataquihuanshina chucchuchira. Astahuanbas Jesus supaita ama chasna raichu nisha rimashami chi musu runamanda llucshichisha alichishami paihua yayama cura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tucuiguna chasna alichicta ricushami Yaya Diosca ashca ushaiyuc man nisha manzharinaura. Runaguna Jesus tucui rashcagunata ricusha manzharinaupi paihuan puriu runagunata rimara, ");
INSERT INTO qvzNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ñáuca rimangaraushca shimita alita uyasha ama cungaringuichichu. Ñáuca Runa Tucuc asha runaguna maquibi japichishca tucungaraunimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Chasna rimacpi chi rimashcatas mana intindinaurachu Yaya Dios paigunata chara mana pagllai yachachishcamanda. Chasna acpi manzharinaura paita chimanda tapungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesus japishca chunga ishcai (12) runaguna cuintanacunaura pita ñucanchimanda yali balic tucungaraunchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Paiguna shungu ucuibi yuyariushcata yachasha Jesus shuc huahuata cayasha paihuan mayanbi shayachira, chihuasha rimara, ");
INSERT INTO qvzNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Maican runaga ñucata llaquishcamanda cai huahuata llaquisha japishaga ñucatas japihuaunguimi. Pihuas ñucata japishaga ñucata cachac Diostahuas japingami. Tucui cangunamanda pihuas mana alabarisha tiyac paimi tucuimanda yali balic tucunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chasna cuintacpi Juan nira, Shuc runa camba shutihuan supaita runamanda llucshichiucta tuparanchi señor. Paiga mana ñucanchihuan puriu runachara, chiraicumanda ama Jesuspa shutita japinguichu nisha saquichiranchi. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Juan rimacpi Jesus nira, Imangahuata paita saquichiranguichi. Pihuas canda mana piñaushaga paimi canda yanapac an nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jahuapachama Jesus rina punzha pactaupi tucui munaihuan Jerusalenma rina ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Chasna riushami maican rimac runagunata ñaupata cachara. Cachacpi risha shu Samaria llactaibi yaicunaura Jesusraicu ñaupata alichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Randi chi llactai auc runagunaga Jesus Jerusalenma riucta yachashami huasita mana cunaurachu chibi pai puñungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chasna mana cucpi Santiago Juandi chita yachasha Jesusta rimanaura, Ñáucanchi Eliascuinta jahuapachamanda ninata cayasha urmachinata munanguichu señor, paigunata illacta rupachingahua ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Paiguna chasna yuyaricpi Jesus paigunata sinzhita rimara, Canguna rimashcatas mana intindishachu rimanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ñáuca Runa Tucuc asha mana runagunata huanchingahuachu shamurani astahuanbas quishpichingahuami shamurani. Chasna nishcahuasha Samariamanda llucshisha shuc llactama rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Paiguna Jerusalenma rina ñambita riushcai shuc runa Jesusta rimara, Can maitas riupihuas ñuca canda catishcanguimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Randi Jesus paita nira, Aichaguna puñuna juctuta charinaunmi, pishcugunahuas huasita charinaun. Randi ñucaga Runa Tucuc ashallata ima huasitas mana charinichu ñuca samasha siringahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Shuc runata Jesus nira, Ñáucata catihuai. Randi chi runa paita cutipara, Ñáaupapundaga ñuca yaya huañushcata pambagringahua lugarta cuhuai señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chasna nicpi Jesus paita rimara, Chiguna huañushca runagunacuinta anaun. Chasna asha paigunapura pambanauchun. Can randiga Diospa ali mandanamanda yachachigri nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Shuc runaga rimara, Canda catinata munani señor, randi ñaupapunda lugarta cuhuai ñuca aillugunata riunimi nisha rimagringahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chasna nicpi Jesus rimara, Maican runahuas tarabangahua callarishcahuasha huashama bulltiarisha ricushcacuinta mana ushanzhu Diospa ali mandana runa tucunata. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chihuasha Jesus canzhis chunga (70) paita catiucunata cayasha ishcaipura ishcaipura ñaupata cachara pai rina llactagunama. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Cachausha rimara, Runagunaga pucushca muyugunacuinta manaun. Cangunaga tarabaccuinta manguichi nira. Ashca pallana muyuguna tiyanmi randi tarabaccunaga ashilla maunguna. Chasna acpi Diosta mañasha tapuichi runagunata cachachun paihuacpi tarabangahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Canguna oveja huahuacuinta manguichi, chasna agllaita pumacuinta piña runagunahuagma cangunata cachauni. Cunan richilla nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Riusha cullquita shigratas, canguna butastas ama apanguichichu, chasnalla richi. Ñáambita canguna riusha ama pihuanbas cuintanguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maican huasibi yaicusha ñaupata saludangui casna nisha, Yaya Dios cangunama cushi causaita cuchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chi huasibi ali shungu runa aupiga canguna nishcashina alitami causangauna. Astahuanbas mana ali runa chibi aupiga canguna rimashca shimiga cangunahuagllaita saquiringa. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","Maican llactai yaicusha ama ashca huasigunai tiyagringuichichu randi shuc huasillai tiyanguichi. Imatas paiguna caracpi micuichi upichi. Shuc tarabac runa pai tarpushca muyuta micushcacuinta paiguna cangunata yaicuchisha imatas caracpi micunguichilla. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chibi ungushca runaguna tiyaupi alichichi. Alichisha paigunata rimaichi, Diospa ali mandanaga ña pactarimuunmi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Randi canguna shuc llactama pactacpi, paiguna cangunata uyanata mana munanaupiga chi llacta ucui shayarisha caparichi casna nisha, Canguna llacta allpa pulbutahuas ñucanchi chaquimanda picharisha saquinchi canguna ñucanchita mana munashcamanda. Ama cungaringuichichu Diospa runa tucunata yachachingahuami shamuranchi astahuanbas Diospa ali mandanata mana munaranguichichu nisha rimanguichi. Chasna Jesus pai cachaushca runagunata nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cangunata casna nini, Taripana punzha chi llactata Sodoma llactamanda yali taripashca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Corazínmanda Betsaidamanda runagunahuas uyaichi, ai, canguna turmintachishca tucunguichimi. Ñáuca cangunahuacpi pihuas mana rashcagunata Tiro llactai Sidón llactaibis rashca acpiga paiguna unaimi ña jucha ranagunata saquisha quirinaunmara. Paiguna juchata rashcamanda llaquirisha tsuntsu llachapata churarinaunmara, ushpa pulbutas umaibi shitarinaunmara juchata rashcamanda llaquirishcata ricuchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Taripana punzhaibimi cangunaga Tiro Sidón llactagunamanda mas yali sinzhita libachishcami tucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaun runaguna, canguna jahuapachama pactangaraunchi nisha yuyariunguichimi. Cangunaga ucupachama shitashca tucungaraunguichi. Chasna nisha Jesus tucui runagunata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Paihuan puriucunata cuti rimara, Maican runa canda uyasha ñucatahuas uyanmi. Pihuas cangunata mana uyasha ñucatas mana uyanzhu. Chasnallata ñucata mana uyac runaga ñucata cachamuc Yaya Diostas mana uyanzhu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chi canzhis chunga (70) cachashca runaguna yapa cushihuan bulltiamusha Jesusta cuintanaura, Ñáucanchi camba shutihuan rimashcallai supaigunahuas runagunamanda llucshisha rinaura señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chasna rimacpi Jesus paigunata nira, Ñáucaga supai amu Satanasta jahuamanda dilampashcacuinta shitashca urmamuutami ricurani. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Uyaichi. Cangunama ushaita cuni, palugunata uputindigunatas canguna jaitasha mana imas tucunguichichu. Ushaita cuni tucui supaigunata binsingahua, supai cangunata imasna rashahuas mana binsingachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Chasna acpis supaiguna cangunata uyashcamanda ama cushiyanguichichu, randi canguna shutita jahuapachai quillcashca ashcamanda cushiyaichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chi urasllai Jesusta Diospa Samai yapa cushiyachira. Cushiyachicpi rimara, Can jahuapachata cai pachatahuas mandac mangui Yaya. Canga yapa yuyaiyuc runagunama, yapa yachaushca runagunamas can rashcagunata pacashcacuinta mana ricuchirangui, randi paiguna mana balichishca huahuacuinta runagunama ricuchishcangui paiguna can rashcata yachanauchun nisha. Chimandami canda pagrachu nini. Sirtumi Yaya, can munashcashina rashcangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Diosta pagrachu nishcahuasha paihuan puriucunata rimara, Ñáuca Yayami tucuita ñuca maquibi saquihuashcami. Runagunaga ñuca pihua churi actahuas mana yachahuanaunzhu. Yaya Diosllami ñucata yachahuan. Mana pihuas Yaya Diostaga yachanaunzhu, ñucallami paihua churi asha yachani. Chasnallata ñuca Yayata ñuca ricsichinata munashca runagunatas ricsichinimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Chihuasha paihuan puriu runagunallata cuintara, Cangunata nini, ashca mandac amugunas, Dios rimashcata pasachic runagunahuas canguna ricuushcata ricunata munashahuas mana ushanaurachu. Canguna uyaushcata uyanata munahuashahuas mana ushanaurachu. Cangunaga ñuca raushcagunata ricushcamandami cushi aunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chihuasha Moises mandashcagunata shuc yachachic runa shayarisha Jesusta camasha nisha tapura, Imatata rasha huiñai causaita charingahua señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus randi paita tapura, Diospa shimibi imasnata quillcashca tiyan. Can chi quillcashcata ricusha imatata yuyaringui. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tapucpi chi runa rimara, Camba jatun Diosta llaquina mangui tucui camba shunguhuan, tucui camba almahuan, tucui camba jursahuan, tucui camba yuyaihuan. Chasnallata amullata llaquishcacuinta shuccunata llaquina manguichi nishca an nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Rimacpi Jesus nira, Alita cutipashcangui. Chita pactachisha causangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chi runa ama yanga tapuccuinta tucungahua cutillata tapura, Shuccunaga pitanaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tapucpi Jesus shuc yachachina shimita rimara casna nisha, Shuc runa Jerusalenmanda Jerico llactama riushcai shuhuac runaguna paita japisha macanaura, paihua churarinata quichusha illacta apanaura. Llatanda saquinaura, ñalla paita huanchisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chi uras shuc israel pagri chi ñambita riusha chi macaitucushca siriu runata tupara. Tupasha ricusha ñambihuashata muyurisha pasara. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chasnallata shuc runa Diosta alabana huasita cuirac Leví muntunmanda chi ñambillatata riusha paihuas chi siriu runata tupara. Paita ricusha chasnallata chillai saquisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chihuasha shuc mana balichishca Samaria llactamanda runa chi ñambillatata riusha chi macaitucushca runa siriushcai pactara. Chi runata ricusha llaquisha yanapasha nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Llaquisha yanapangahua caillayara. Chi runa pitirishcagunai huira rimidiuta vinotahuas talisha llutachira. Chihuasha paihua quiquin burro jahuai churasha shuc puñuna huasima apasha paita cuirara. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cayandi ishcai (2) tarabashca tupu cullquita bultsamanda llucshichisha huasiyuc amuta pagasha rimara, Cai runata cuirapangui. Imata tapucpihuas cungui. Ñáuca shamusha pagashcanguimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chi yachachinata cuintashcahuasha paita chi tapuc runata Jesus tapura, Ñáa imasata yuyaringui. Tucui chi quimsa (3) pasac runagunamanda maican runata chi shuhuaitucushca runata llaquira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tapucpi Dios mandashca shimita yachachic runa nira, Huasha pasac, chi runata yuyarisha yanapac runami. Chasna nicpi Jesus paita rimara, Cambas chasnallata shuccunata yuyarisha yanapasha causana mangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chihuasha Jesus pai yachachishcagunandi mas purisha pactanaura shuc llactama. Chibi pactacpi shuc huarmi Marta nishca paihua huasima Jesusta paihuan puriucunandi yaicuchira carangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta shuc ñañata charira Maria nishcata. Paiga Jesuspa chaqui mayanbi tiyarisha pai yachachiushcata uyaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta randi yapa tarabanata yuyarisha Jesusta rimagrira, Manachu ricungui señor, ñuca ñaña mana yanapasha tucui tarabanata saquishca ñuca sapalla tarabauni. Paita mandai ñucata yanapahuachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chasna rimacpi Jesus paita rimara, Can yapa tarabanata munasha yuyarishami yapa turbaringui Marta. ");
INSERT INTO qvzNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mana ashca minishtirinzhu, shugllata rana angui. Mariaga astahuan alita yuyarishami ñuca yachachiushcata uyaun. Chasna acpi paihuagmanda mana pihuas quichuitucungachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Shuc punzha Jesus Dioshuan cuintasha tiyaura. Cuintashcahuasha shuc catiu runa paita rimara, Bautisac Juanmi paihuan puriu runagunata Yaya Dioshuan cuintanata yachachira, ñucanchitas chasnallata yachachi señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chasna nicpi Jesus paigunata rimara, Canguna Dioshuan cuintausha casna rimaichi, Jahuapachai tiyac Yaya, camba shuti balichishca achun. Camba ali mandanaga tucugunaibi mirarishca tucuchun. Camba munaiga jahuapachai ashcacuinta cai pachaibis chasnallata achun. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Caran punzha ñucanchi minishtishca micunata cuhuai. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ñáucanchita mana alita rauc runagunata perdunasha alichishcamanda chicuintallata ñucanchi juchagunatas perdunasha anchuchingui. Supai ñucanchita camasha pandachisha nicpi cuirahuai ñucanchi canda ama saquingahua. Casna nisha Jesus yachachira paita caticcuna Dioshuan cuintanata. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Chihuasha paigunata casna mas yachachira, Yuyarichi. Shuc runa chaupi tuta shamucpi cambacpi micuna illacpiga imasata rangui. Can chasna tucucpi can shuc amigohuagma risha tapugringui, micunata cuhuai, ");
INSERT INTO qvzNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","shuc amigo carumanda ñuca huasibi shamushcami randi paita carangahua mana charinichu, chiraicu tapungahua shamuni nin. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chasna tapucpihuas chi huasiyuc runa randi ucumanda rimanma, ama quillachihuaichu ñucata nisha, pungu ña tapashca man. Tucui ñuca huahuaguna ñucahuan ña puñuungunami, mana ushanichu jatarinata canda cungahua, nisha rimanma. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cangunata nini, chi runa huasha jataringami. Mana amigo ashcamandachu astahuan chi tapuuc runa yapa tapusha quillachiupi jataringami chi tapushcata cungahua nisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Canguna Yaya Diosta tapucpi cuitucunguichimi. Canguna mascacpi pai cungaraushcata tupanguichimi, huasi pungüi cayacpi cangunata yaicuchitucunguichimi. Chimanda ñuca cangunata nini, Diosta tapuichi, tapucpi cuitucunguichimi. Mascaichi, mascasha tupanguichimi. Chasnallata cayaichi, cayacpi pungu pascaitucungami. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yayaguna, canguna churi micunata tapucpi rumitachu cungui. Mana. Yacu aichata tapucpi palutachu cungui. Mana. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Lulunda cuhuai nicpi uputinditachu cungui. Mana. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Canguna juchayuc ashahuas camba huahuagunama aligunata cunguichi. Manachu yachanguichi camba jahuapachai tiyac Yayaga maican runa Diospa Samaita cuhuai nisha tapucpiga sirtu cungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Shuc punzha Jesus shuc runamanda supaita llucshichira. Chi supai tiyashcamanda chi runa mana rimacchara. Astahuanbas supaita llucshichicpi chi runa rimangahua callarira. Chita ricusha runaguna manzharisha Jesusca Diosmanda ushaiyuc man nisha ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Randi maicangunaga rimanaura, Cai runaga supaigunahua amu Beelzebú nishca ushaihuanmi ima supaigunatas jichunata ushan. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Maican runaguna randi paita camasha nisha, Shuc ricuchinata Diosmanda ushaihuan ricuchihuai ñucanchita. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus paiguna yuyarishcata yachasha rimara, Shuc llactai auc runagunapurallata piñanacushaga chi llacta tucuringami. Chasnallata shuc huasibi causaucuna piñanacushaga paigunapurallata jichunacushca tucunaunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chasnallata Beelzebú nishca supai amu tucui supaigunata anchuchishaga paihua quiquin tarabanata huaglichingami. Pai chasna rashaga pigunata mandangaraun. Canguna yuyaringuichi ñucaga supai amu ushaihuanmi shuc supaigunata anchuchinmi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chi supai amuhua ushaihuan ñuca supaigunatas anchuchicpiga canguna yachachishcata catiucuna piguna ushaihuanda anchuchinaun. Paiguna ñuca rashcacuinta supaita anchuchishcamandami canguna pandashca yuyaigunata ricuchinaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Astahuanbas Diospa ushaihuan supaigunata ñuca anchuchicpiga canguna yachanguichimi Diospa ali mandanaga sirtu cunan cangunahuacpi aun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Shuc yapa sinzhi runa imahuanbas paihua quiquin huasita ali cuiraupi paihua charishcaguna chasnalla aunaunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Supaiga sinzhi runacuinta ashallata randi shuc mas yali sinzhi jursayucca shamusha binsishaga tucui paihua ali charishcagunatahuas illacta quichusha apasha ringami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Maican runahuas mana ñucahuan purishaga ñucata piñasha cuntar puringuichimi. Pihuas mana ñuca munashcata raushaga ñuca raushcata sáa saquichihuangami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesus shuc yachachina shimita casna rimara, Ima uras supai shuc runamanda llucshishaga yacu illashca partima puriun mai runaibihuas yaicusha samangahua nisha. Mascasha mana tupashaga yuyarin cutillata bulltiasha ñuca llucshishca runamallata cuti causangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chasna nisha bulltiamusha chi runahua shunguta shuc huasita pichashcatacuinta chushacta tupagrira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chasna tupasha paimanda mas jiridsa supaigunata canzhis (7) tuputa apamura chi runahua aicha ucui yaicusha causangahua callarinaura. Chasna causaupi chi runa ñaupa aushcamandas mas yalicta huaglishca tucurami. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus chasna rimaupi chi runa muntunmanda shuc huarmi sinzhita caparira, Camba mama cushiyachun canda pagarichishcamanda chuchuchishcamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus randi rimara, Maican runaga Diospa shimita uyasha pactachiccunaga ñuca mamamanda mas yali cushi manaunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ashca runaguna mas tandaricpi Jesus rimangahua callarira, Cunan causauc runaguna yapa juchayuc manaun. Ñáuca ushaihuan ranata ricuchihuai nisha rimahuanaun. Chasna rimagllaita shugllata ricuchishca anaunga, Jonas tucushcacuintallata ricuringami. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yachanguichi Ninive nishca llactai causauc runagunahuacpi Jonasca ricuchinacuinta mara. Ñáucaga jahuapachamanda ashallata Runa Tucuc asha Jonascuintallata caibi tiyac runagunahuacpi ricuchinacuinta mani Diosta cuti catinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Ninive runagunaga Jonas camachishcata uyasha juchata saquisha Diosta catingahua callarinaura. Cunanga Jonasmanda yali camachic runami cangunahuacpiga auni. Chimandami taripana punzha Ninive llacta runagunaga cangunata caudsayachingaunami canguna ñucata mana quirishcamanda. Chasnallata urai partimanda Saba nishca llactamanda huarmi jatun amuga israelgunata mandac jatun amu Salomon yachashcagunata tapusha nisha yapa carumanda shamura. Cunan ñucaga chi Salomonmanda mas yali yuyaita charic cangunahuacpiga auni. Chiraicumi Dios taripana punzhaibi chi huarmiga cangunata caudsayachingami canguna ñucata mana uyashcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Shuc bilata japichisha mana pihuas pacasha nisha manga ucui churanzhu, randi pagllai churan tucui runaguna alita ricuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Camba ñahuiga intiru aichaibi bilacuinta man. Can bilahuan purishcacuinta ali yuyaihuan causashaga punzhashina alita causanguimi. Randi can mana ali yuyaihuan causashaga camba causai ansa tutacuinta manga. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Alita yuyarichi. Cunan camba yuyai punzhacuinta man. Camba yuyai ama ansa tutacuinta achun nishaga alita yuyarisha causaichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Camba causai shuc bila punzhaglla shitashcacuinta aupi ima llanduhuas illacpi, alita ricuchishcacuintami causanguichi nisha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pai yachachishcahuasha shuc fariseo runa Jesusta rimagri ñuca paihua huasibi micuc shamuichi nisha. Chasna nicpi Jesus yaicusha mesai tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pai chara mana micuushallata mana fariseoguna rashca tunuta maquita maillarirachu. Chita ricusha chi fariseo runa imangahuata ñucanchicuinta mana maillarin nisha yuyarisha Jesusta mana balichira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chasna yuyariupi Jesus randi paita rimara, Fariseoguna, canguna pillchitas pulatutas maillasha, huasha partillata maillanguichi, astahuanbas ucuta mana maillasha puchuc micunata saquinguichi. Canguna causaiga chasnallata man. Canguna alitami raunchi nisha yuyarisha causaushahuas yapa shuhuanguichimi, yapa juchata rasha causaunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yuyai illac anguichi. Manachu Dios runata rausha jahua aichatas ucu aichatahuas rara. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Canguna shunguta canguna yuyaitahuas alichirichi, canguna charishcata pugrigunama cuichi. Chasna racpi tucui camba causai ali tucunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fariseoguna, yapa manzhanayacta tucungaraun cangunahuacpi. Camba tucui micuna muyutas, tucui micuna pangatas chungamanda (10) chaupichisha shuc muntunda rasha Diosma cusha causaunguichi. Chasna racpi ali man. Randi cungarishcanguichi alita causanata Diosta llaquinatas. Diosta llaquina manguichi, alita causana manguichi. Chasnallata tarpushca micuna muyugunatas pangagunatas caran chungamanda shucta Diosma cunatas ama saquinguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Fariseoguna, yapa manzhanayacta tucungaraun cangunahuacpi. Runaguna ñucanchita balichihuanauchun nisha israel tandarina huasigunai chi mas balic tiyarinagunaibi tiyarinata mascanguichimi. Chasnallata pagllaibi puriusha runaguna cangunata ali yuyaihuan saludahuanauchun nisha yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yapa manzhanayacta tucungaraun cangunahuacpi. Maicanbas runagunata pambashca allpa jahuai puriusha ucui ismushcata mana asirtasha chillai purinaun. Canguna causaiga chicuinta anaun, pagllai alita ricuriugllaita ucumaga ismushcacuinta manguichi, chita runaguna mana asirtanaunzhu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesus chasna rimacpi shuc Moises mandashcata yachachic runa paita rimara, Can chasna fariseogunata rimasha ñucanchitahuas caudsayachinguimi señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chasna nicpi Jesus paita rimara indá. Canguna Moises mandashcata yachachiccuna ashallata cangunahuacpis yapa manzhanayacta tucungaraun. Mana ushaibaccunata yapa mandaunguichi llashacta apachishcatacuinta. Astahuanbas cangunaga shuc maquillahuanbas runagunata mana yanapanguichichu ni imallahuas. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yapa manzhanayacta tucungaraun cangunahuacpi. Canguna huañuc apayayagunaga Dios rimashcata pasachiccunata huanchinaura. Cunan chigunata mana balichishallata huanchisha pambashcagunai cangunahuas huasihuata cutillata shayachinguichi paigunata balichishcacuinta rasha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Canguna apayayaguna huanchinaura, cangunaga chillaita cuti huasinguichi. Chasna rashami canguna apayayaguna huanchishcagunaga ali mashca nisha ricuchinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chaimandami paihua yuyaimanda Dios rimara: Ñáuca rimashcata pasachic runagunata cachashami, chasnallata ñuca shimita apasha ric runagunatas. Ñáuca cachacpihuas maicangunataga huanchingaraungunami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cangunata nini, mundu callarishcamanda tucui Dios rimashcata pasachiccunata huanchishcamanda canguna caudsayachishca tucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelta huanchishca urasmanda Zacariasta Diosta alabana huasi pungüibi auc aichata rupachina mesa mayanbi huanchishcagama canguna caudsayuc anguichi. Cangunata cuti rimani, tucui Dios rimashcata pasachiccunata huanchishcamanda caudsayuc manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Canguna Moises mandashcata yachachic runaguna yapa manzhanayacta tucungaraun cangunahuacpi. Cangunallata mana munaranguichichu Dios quishpichinmi nishcata uyanata. Chasnallata shuc llavita quichushcacuinta Diospa shimita yachanata munac runagunatas jarcasha saquichishcanguichi ama yachanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus chimanda llucshiupi Diospa shimita yachachiccunas, fariseogunahuas yapa piñasha ashcata tapunaura paita pandachishun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pai pandacpi caudsayachishun nisha rimanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Paiguna llucshisha riushcai ashca huaranga runaguna tandarisha tác tucusha chaquibis jaitanacucta rinaura. Chasna acpi paihuan puriu runagunallata Jesus yachachingahua callarira casna nisha, Cuirarichi, fariseoguna yanga llullasha purinaun. Cangunaga ama chasna rasha causanguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yuyarichi. Paiguna tucui rashcagunaga huasha ricuringami. Ima cunan pacalla rashcagunahuas huasha punzhami ricuringallami, chasnallata ima pacalla rimashcagunahuas chi punzhallaitami yacharingaraunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Canguna tuta imata rimacpihuas punzha pagllai uyaringami. Cangunapura huasi ucui imatahuas pacalla rimacpihuas tucui runa ñaupacpi pagllai caparisha rimaitucushca anga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Llaquishca amigoguna, canguna aichata huanchinata munac runagunata ima manzhanguichichu. Huanchishcahuasha canda mana ushanzhu imatas ranata. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Astahuanbas ñuca cangunata yachachini pitata mas manzhana anguichi. Can huañushcahuasha ucupachama cachana ushaita charic Diostaga manzhana manguichi. Ñáuca cangunata nini, paillata manzhana anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pichca (5) ichilla pishcugunata randichicpi manachu ishcai (2) cullquihualla llucshin. Ashillahua llucshigllaita Diospacpi ni shucpas mana cungarishcachaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dios tucuita yachac ashami canguna accha tuputahuas yachanmi. Chi pishcugunamandahuas cangunaga mas ashca balic ashami Yaya Dios alita cuirashca saquiringuichimi. Chasnamandami chi runagunataga mana manzhana changuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesus paigunata casna nisha mas yachachisha catira. Cangunata nini, maicanbas runaguna ñaupacpi ñucaga Jesuspac mani nisha rimacpiga, ñucahuas Runa Tucuc asha Diospa angelguna ñaupacpi chi chasna rimac runamanda ñucahuac runa man nisha rimashami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Randi pihuas runagunahuacpi ñuca mana Jesuspa runachani nicpiga Diospa angelguna ñaupacpi ñuca rimashami paiga mana ñuca runachan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Maican runa ñucata Runa Tucuc acta piñasha rimacpiga Yaya Dios perdunasha chi rimashca juchata anchuchingami. Randi pihuas Diospa Samaimanda mana ali rimacpiga Yaya Dios paita mana perdunangachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Ñáucata quirishcamanda cangunata israel tandarina huasigunaibi caudsayachingahua apacpiga amugunahuacpis mandac runagunahuacpihuas apaushcai Diospa Samai chi uraspi cangunata alita yuyachingami canguna imatas rimangahua. Chasnamanda ama ñaupata yuyarisha turbarichichu imasnata rimasha nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jesus chasna rimacpi chi runagunamanda shucca rimara, Ñáuca huauquita rimai señor, ñucanchi yaya ñucaraicu saquishcata ñucama cuhuachun nisha rimapai nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chasna rimacpi Jesus randi paita rimara, Pita ñucata churahuara amu tucusha cangunata alichingahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chihuasha tucui runagunata rimara, Canguna yuyarichi. Ama yapa munasha causaichichu. Runa ashcata charishahuas mana mas cushi causanata tupangachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chasna nisha paigunata cai yachachina shimita cuintara casna nisha, Shuc yapa charic runaga ashca allpata charira. Muyuta tarpucpi yapa ashcata aparira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chasna yapa aparicpi chi runa yuyarira, ñuca pallashca muyugunata mana imaibihuas huacaichinata charinichu nisha. Cunanga maibita huacaichisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Casnami rangarauni. Ñáuca muyu huacaichina huasigunata mas jatunda rangarauni. Tucui muyugunatas, ñuca ali charishcagunatahuas chibi churasha alita huacaichishami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chasna ñuca ashcata charishcamanda unai huatagama pactangami, mana ima uraspas pishihuangachu. Mana mas tarabasha jumbiushachu cunanmanda. Micusha upisha cunanga lugar causangarauni nisha yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chasna yuyariupi Dios randi chi runata nira, Yuyai illac runa mangui. Cunan tutami huañungaraungui. Chasna tucucpi tucui can huacaichisha charishcagunataga pichari japingaraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesus chita cuintashcahuasha rimara, Yuyarichi nisha. Maican runahuas chicuintallata pai charishcagunata yuyariushalla causac ashaga, randi Diospacpi mana charishaga chi runacuintami tucunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus paita catic runagunata rimara, Cangunata nini imatas tucungaraushcata ima yapa yuyaringuichichu imatata micungaraunchi nisha, chasnallata imatatas churarishallami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Micunamanda canguna causaiga mas yali balic man, churarinagunamandas canguna aichaga mas yali balic man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pishcugunata yuyarichi. Paiguna mana tarpunaunzhu, mana pallanaunzhu, muyu huacaichina huasitahuas mana charinaunzhu, randi Dios paiguna micunata cusha cuiran. Ñáa pishcugunamanda mas yali balic manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Canguna munaimandami mas unaita causanata ushanguichichu. Mana. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chasna mana ushashaga imangahuata micunallata churarinallatas yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sisagunatas yuyarichi. Paiguna causasha mana tarabanaunzhu, mana ahuanaunzhu, randi cangunata nini, israel ñaupa jatun rey amu Salomon churarishcamandahuas paiguna mas yali gustu ricuriccuna anaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Quihuagunatas yuyarichi. Cunan punzha huiñanaun, cayandi rupachishca tucunaun. Chasna tucugllaita chi yanga quihuagunata Dios gustu sisayucta ran. Chasna rasha Dios manachu cangunatahuas churarinagunata cunga. Indá, cungami. Yaya Dios cangunata cuirauta mana yuyarishami ansalla quiriccuna anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dios cuhuangachu nisha ama yuyarisha causaichichu. Ama upinallata ama micunallata yuyariusha causaichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Diosta mana quiric runagunami chigunataga yapa yuyarisha causanaun. Canguna jahuapachai auc Yayami canguna minishtishcataga alita yachaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chasna acpi cangunaga Diospa ali mandanata yuyarisha causaichi. Chasna causashaga tucui can minishtishcagunata cuitucunguichimi nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ñáuca llaquishca huibagunacuinta manguichi, canguna ashilla ashahuas ama manzharinguichichu. Dios llaquic ashcamanda pai mandashca runaguna muntunda canguna mandachun nishami cusha niun. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Canguna charishcagunata randichisha pugri runagunama cumbiraichi. Chasna rashami jahuapachaibi ali baliccunata charingaraunguichi. Mana huaglibac bultsata japishcacuinta charichi jahuapachai mana tucurina ali baliccunata huacaichingahua. Shuhuaccunaga canguna chibi huacaichishcagunata mana shuhuanaungachu ni ucuchahuas mana mucungachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yuyarichi. Maibis canguna huacaichisha charishcagunata chibimi yapa yuyaringuichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yuyarisha causaichi. Shuc cadsaraushca jistamanda shuc amu bulltiamusha cayacpi paita cuirac runaguna alichirishca asha punguta uctalla pascasha yaicuchingaunami. Chi runaguna churarishcashina chapasha, bilatas japichisha chapashcashina cangunahuas ñuca shamunagama sumac alichirisha chapausha causaichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sirtuta nini, amu pactamushcai chi alichirisha chapauc runagunallatami tiyachisha caranga. Chasna racpi chi cuirac runaguna amuta chapasha tiyaushcamanda yapa cushiyangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chi amu ima uraspas shamucpi, chaupi tuta acpihuas punzhayaushcai ashahuas, chi alichirisha chapauc runaguna cushiyangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chasnallata caita yachaichi, pihuas shuc shuhuac runa shamunata yachashca ashaga niccharisha chapanmara paihua huasibi ama shuhuaitucungahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Canguna chasnallata niccharisha chapauccuinta alichirisha chapahuaichi. Runa Tucuc nishaga cuti shamushami. Canguna mana yachaushcallaita pactamushami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chasna nicpi Pedro Jesusta tapura, Can chasna nisha tucui runagunatachu rimaungui señor, ñucanchillatachu rimaungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tapucpi Jesus cutipara, Yuyarichi canguna alita yachangahua. Ñáuca shuc amucuinta asha alita pactachic runagunata mascauni. Shuc punzha shuc amu paita pactachic ashca yuyaiyuc cadsuc runata japisha churara tucui paihua runagunata tucui uras paiguna micuna tuputa carachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amu shuc llactama risha bulltiamushcai chi saquishca runa amu mandashcata pactachisha tiyaushaga chi runaga cushi tiyaungami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sirtuta cangunata nini, chi amu tucui pai charishcagunata chi pactachic runama saquingami cuirachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Astahuanbas chi tarabac runa ñuca amu mana ucta shamungachu nisha yuyarishaga mana alita rai callarin. Chi shuc tarabac carigunatas huarmigunatahuas libachingahua callarin, chasnallata yapa micushas, machanagama upisha causan. Chasna causashaga imasata tucungaraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ima punzha ima uras paihua amu shamunatas mana yachashcai pactasha chi mana cadsuc runata sinzhita libachingami. Tucui chi shuc mana pactachic runaguna tiyashcama turmintarichun nisha cachanga. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Maican runa paihua amu munashcata yachashallata mana pactachishaga alichirishca ashaga sinzhita libachishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Astahuanbas mana yachachishca runaga mana alita raupi ansallata libachishcami tucunga pai mana yachashcamanda. Maican runataga Yaya Dios ashcata cushca ashaga ashcata cutichishcacuinta rana man. Chasnallata maican runa alita yachachishca ashaga alita yachachina man. Chasna nisha Jesus paigunata yachachirami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Chihuasha Jesus rimara, Cai pachai ninata japichingahua shamurani. Cunan japirishca aushaga ali anma. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yapa turmintarina mani. Ñáuca ashca nanai pasanagamami rina ani. Chasna tucunagama chillata yuyarisha purini. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ñáuca cai pachai tiyac runagunama cunan shuc yuyaillata cungailla causanata cungahua shamushcata yuyaringuichichu. Mana chasnachan. Cangunata nini, ñuca shamushcamandami runaguna chaupi chaupi tucusha chaupiguna ñucata yuyaringaunami, chaupi runaguna ñucata piñangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cunan urasmanda ñaupagma pichca (5) runa shuc huasibi causausha ñucamanda chaupi chaupi tucungaunami, quimsa (3) runa piñanaun ishcaigunata (2), ishcai randi quimsagunata. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yayata churi piñanga, churita yaya piñanga. Mamata ushushi piñanga, ushushita mama piñanga. Carimama piñanga cachunda, cachun piñanga carimamata. Chasna nisha Jesus paita quirishcamanda imasna tucungaraushcata cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chihuasha chi ashca runagunata Jesus rimara, Yana puyu indi yaicunamanda ricuricpi tamiangaraun ninguichi. Canguna nishcashina tucusha tamian. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Uraimanda rupac huaira shamucpi indingamiraun ninguichi. Canguna nishcashinami indi punzha tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chasna yachashallata yuyai illaccuinta anguichi. Jahuama ricusha ima tucungaraushcatas yachanguichimi, randi cunan uras ñuca raushcatas ricuushallata mana yachashallatachu puriunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Canguna quiquin yuyaihuan imangahuata alita rasha causanata mana munanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chi canda caudsayachic runa canda taripangahua apaushcai uctalla paihuan alichichi amuhuagma mana chara pactaushallata. Chima pactacpiga chi taripacca paihua sundaluhua maquibi canda saquingami carcelbi tapachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cangunata sirtuta nini, chasna tucucpiga tucuita paganagamami mana llucshinatas ushanguichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chi uras shuc runaguna Jesuspagma shamusha casna nisha rimanaura, Shuc punzha maican Galilea runagunaga Diosta alabana jatun huasibi tiyausha ovejata huanchishcauna Diosma ricuchingahua. Chasna raushcata uyasha mandac amu Pilato piñarisha paigunata huanchicpi chi runaguna rahuaihuan oveja rahuaihuan chapushca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chi runaguna rimaucta uyasha Jesus paigunata tapura, Tucui Galilea runagunamandas chi runaguna chasna huanchitucushcamanda mas yali juchayuc anaun nishachu yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mana chasnachan. Randi canguna jucha ranata mana saquishaga tucui cangunahuas huañunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chasnallata chi Siloe nishca llactai tiyac jahua huasiga chunga pusac (18) runa jahuaibi urmasha huanchira. Chasna acpi tucui Jerusalenbi tiyac runagunamandas chi huañushca runaguna mas caudsayuc anaura nishachu yuyariranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mana chasnachan. Randi canguna jucha ranata mana saquishaga tucui cangunahuas huañunguichimi nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chihuasha Jesus cai yachachina shimita cuintara casna nisha, Shuc runa paihua chagrai higo nishca ali micuna muyuta aparic ruyata tarpura. Ñáa pucui uras chi runa muyuta pallangahua rira, pai pactasha ricucpi muyu illara, ni shuc muyullahuas mana aparishcachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chasna acpi paihuacpi tarabauc runata nira, Ricui, aparingachari nisha chaparani quimsa (3) huatata, randi cunanbas mana aparishcachu. Chasna acpi chi ruyata cuchui shuc ruyata chibi tarpungahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amu rimacpi chi tarabauc runa paita nira, Ama cuchushun señor, shuc huatallata chapashun nira. Ruya sapimanda allpata allasha apiyachisha huagra ismata churangarauni pai alita huiñachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chasna racpi shuc huataibi muyuta aparishaga ali anga nira, mana aparicpiga chibiga cuchui nisha rimahuangui. Jesus yachachishcata uyauc runagunata rimasha, Chasnallata, Diospa munai canguna causaibi mana ricuricpi pai mana mas ahuantasha chi mana aparic ruyata cuchushcacuinta tucunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Israelguna samana punzha paiguna tandarina huasibi Jesus yachachisha aura. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chi uras shuc ungushca huarmi tiyaura. Chunga pusac (18) tupu huatayuc ara supai paita yaicushcamanda cusca shayarinata mana ushasha cumu puriglla tucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus paita ricusha, Camba ungüi anchurishca achun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chasna nisha paihua maquihuan llangacpi aliyara. Pai llangashcai chi huarmi alita shayaric tucusha Yaya Diosta alabangahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chi tandarina huasita cuirac amuga Jesus samana punzha alichishcata yachasha piñasha runagunata rimara, Sucta (6) punzha tiyanmi runa tarabangahua. Chi punzhaguna shamuichi aliyachishca tucungahua. Samana punzha ashcaraicu mana shamuna changuichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Rimacpi Jesus nira, Yuyai illaccuinta anguichi. Manachu samana punzhaga camba huatashca huagrata, caballotahuas pascanguichi yacuta upichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cai Abrahanmanda mirai huarmiga chunga pusac huatata supai Satanas huatashca mara. Samana punzhaiga paitahuas pascangahuaca manachu ali an nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesus chasna tapucpi tucui paita piñaucuna pingarinaurami. Randi chi shuc runagunaga yapa cushiyanaura Jesus ashca aligunata rashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chimanda Jesus cuintara, Diospa ali mandanamandaga imasna rashata intindibacta ñuca yachachishca anguichi. Ima shimihuanda yachachisha ñuca canguna mas alita yachanauchun nisha. Ñáa casnami: ");
INSERT INTO qvzNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Diospa runaguna mostaza nishca shuc ichilla muyuhuashina yapa ashilla manguichi. Chi ichilla muyuta chagrai tarpucpi huiñasha ruya tucunmi. Chasna huiñaupi pishcuguna chi ramagunai yapa huasita ranaunga nira. Diospa runaguna chaishina ashca tucunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Paigunata cuti rimara, Diospa ali mandanamandaga ima shimihuanda yachachisha ñuca. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Panda putasyachina muyucuinta man. Shuc huarmi putasyachinata ashillata japisha, quimsa (3) tupu harina muntunhuan chapusha saquinmi tucui ali putasyarinagama, nisha Jesus casna yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus Jerusalenma purisha riusha jatun llactagunais ichilla llactagunaibihuas yaicusha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Shuc llactaibi pai riushcai shuc runa paita tapura, Señor ashillachangaraunguna quishpichishca tucungarauc runagunaga. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tapucpi rimara, Diospagma yaicuna punguga ichilla man, chibi yaicungahuaca tucui canguna munaihuan rana manguichi. Cangunata nini, ashca runa yaicunata munaushahuas mana ushangaunachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amu paihua punguta tapashcahuasha cangunaga canzhaibi shayaungaraunguichi. Pungu mayanbi shausha caparingaraunguichi, Señor señor pascapai ñucanchi yaicungahua nisha. Pai randiga cangunata rimangami, maimandachari anguichi, cangunataga mana ricsinichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Amu chasna rimacta uyasha rimanguichi, canhuanmi micuranchi upiranchi, chasnallata ñucanchi llactaibihuas can yachachirangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Rimanaupi chi amu rimanga, Cangunata basta rimani mana ricsinichu, maimandachari anguichi. Cangunaga mana alita rasha causac runaguna manguichi, ñucamanda anchurisha richi nishami rimanga. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abrahandas, Isaactas, Jacobotas, tucui Dios rimashcata pasachic runagunatahuas paihua ali mandanai tiyaucunataga ricungaraunguichimi. Cangunaga randi pagllai aushami piñasha huacangaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ashca runaguna indi llucshina partimanda, indi yaicuna partimandas, quinraipuramandahuas shamusha Diospa ali mandanai paihuan pariu tiyarisha micungaraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yuyarichi. Maicanbas cai pachai mana balichiushca runagunaga Diospacpi ashca balichishca tucungaunami. Chasnallata maicanbas cai pachai balichiushca runagunaga Diospacpi mana balichishcachu tucungauna nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chi uraspi maican fariseoguna Jesusma shamusha paita rimanaura, Mandac amu Herodes canda huanchinata munan, chiraicu caimanda miticusha ri ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus randi paigunata nira, Herodes yapa llulla runa man. Paita rimagrichi casna nisha, cunan punzhas, cayahuas supaigunata llucshichinimi, ungushcagunatas alichinimi. Cayahuasha ñuca tarabanata tucuchishami nisha rimagri. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chasna ashahuas cunan, caya, cayahuashahuas Jerusalengama rina mani. Tucui Dios rimashcata pasachic runagunataga Jerusalen llactallai huanchitucuna manaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Uyaichi Jerusalenbi causaccuna, Dios rimashcata pasachic runagunata huanchiranguichi, pai cachashca runagunatahuas rumihuan tucsiranguichi. Shuc atalla paihua huahuagunata paihua rigra ucui ugllashcacuinta cangunatas ashca cutin quishpichinata munashcanimi, randi canguna mana munaranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chasna mana munashcamandami canguna huasi jichushcacuinta Dios cunan cangunata saquishca. Cangunata nini, Dios cachashca shamuc runaga balichishca man nishami canguna rimana urascama ñucataga mana cuti ricuhuanguichichu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Israel shuc samana punzhai fariseogunata mandac runahua huasima Jesus rira micungahua. Chi pai aushcai paihua ñaupacpi shuc yapa punguirisha ungusha causac runa shayaric shamura. Chasna acpi tucui fariseoguna Jesusllata ricuusha cunan samana punzhata imasashi rangaraun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chasna paiguna yuyarinaupi Jesus chi Moises mandashcata yachachic runagunatas fariseogunatas tapura, Diospa shimiga imasata nin, samana punzhai ungushca runata alichingahuaca alichan, manachu ali an, nisha painata tapura. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tapucpi paiguna chunlla tiyarinaura. Chasna acpi Jesus maquimanda japisha chi ungushca acta alichishcahuasha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chihuasha paigunatas cuti tapura, Maicanda camba burro, camba huagra juctu ucui urmacpiga manachu uctalla surcunguichima samana punzha agllaita. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jesus tapushcata uyasha mana imatas rimanatas ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cayashca runaguna chi huasima yaicumusha balichihuanauchun nisha mas tiyarinatas munanaura. Chita ricusha Jesus shuc yachachina shimita paigunamas rimara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Cadsarana jistama cangunata cayacpi rishaga mas ali bancuiga tiyarinataga ama yuyaringuichichu nira. Mas yali balic nishca runatachari pai amu chibiga tiyarichinga. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chasna tucucpi jista amu cambagma shamusha anchuri caimanda, caibi shuc runa tiyarina man nisha rimacpi can pingarisha jatarisha chi shuc yanga pasiaccuna tiyaushcama tiyarigringui. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Randi canda ima uras jistama cayacpi rishaga yanga pasiaccuna tiyaushca taulai tiyarigringui. Chasna tiyaricpi jista amu cambagma shamusha mas ali bancuma tiyaric shamui nisha rimangami. Chasna canda rimacpi tucui runa ñaupacpi can balichishca saquiringui. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maican alabaric runaga mana balichishca saquiringami. Chasnallata mana balicchani nisha yuyaric runaga balichishcami saquiringa nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus paita cayac runata rimara, Ima uras can jistata raushaga camba amigogunata, camba huauquigunatas, aillugunatahuas, shuc charic runagunatahuas ama cayanguichu. Can chasna cayacpiga paihuas cayaitucunguichimi paihua huasima micungahua. Can chasna racpimi canda pagashcacuinta saquiringui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Can jistata raushaga casna runagunata cayangui pugrigunata, huaglishca arcu maquiyuccunatahuas, janga janga puric runagunatahuas, puyuñahuiyuccunatahuas chigunata cayangui can. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paiguna randiga jistata ranata mana ushanaunzhu. Can chasna paigunata cayashaga canda pagaitucushcashina cushi tucunguimi. Chasnallata puchucai punzhaibi, alita rac runagunata huañushca acta causachishca uraspi Dios canda pagangami nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ñáa chi jistai shuc cayashca runa Jesus cuintaucta uyasha rimara, Maican Diospa ali mandanai micuc runaga cushi mangaraun nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chasna chi rimaucta uyasha Jesus shuc yachachina shimita cuintara casna nisha, Shuc runa jatun jistata rasha ashca runagunata cayara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Micuna uras pactacpi paihua runata rimangahua cachashca, Micuc shamuichi nisha, tucui micuna ña churashca man. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Shamuichi nicpi tucui cayashca runaguna mana rishunzhu ninaura. Punda cayashca runa nishca, Perdunahuai, jistama rinata mana ushanichu, ñuca randishca allpataga ricugrina mani nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Shucca nishca, Randirani chunga (10) torogunata. Paigunata chagrai tarabachisha camagrina mani. Perdunahuangui jistama mana shamushcamanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Shucca rimashca, Cunanlla huarmita japishcani, chiraicu llucshinata mana ushanichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tucui cayashca runagunata rimashcahuasha chi cachashca runa paihua amuhuagma bulltiasha tucuita cuintagrishca. Chita uyasha chi jista amu piñarisha paihua runata mandara, Llacta ñambigunata risha pugri runagunata apagri huaglishca arcu maquiyuccunatas, puyuñahuiyuccunatas, janga janga puric runagunatahuas tupasha uctalla apamungui nisha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Risha chigunata apagrishcahuasha chi runa paihua amuta rimashca, Can mandashca shimita pactachishcanimi señor, chasna acpihuas chara chushac man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chasna nicpi amu uyasha paihua runata cuti mandara, Llactamandahuashama auc ñambigunaibi jatunbis ichillagunaibihuas mascagri, tucui partima risha maican runagunatas tupasha apagri ñuca huasi tapacta jundarinauchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cangunata nini, ñaupa cayashca runagunaga ñuca micunata mana imatahuas micungachu raunguna nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chi uras yapa ashca runaguna Jesushuan puriucunata rimara, ");
INSERT INTO qvzNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Maican ñucama shamunata munac runaga paihua aillugunamanda yalita ñucata llaquishami ñucata catic runa tucunata ushanga. Randi paihua yayatas mamatas, paihua huarmitas huahuagunatas, paihua huauquitas panitas, chasnallata paihua quiquin causaitas ñucamanda yalita llaquishaga mana ñucata catic runa tucunata ushangachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Maican runahuas cruspi huañungarauccuinta tucui pai quiquin munashcata saquisha ñucallahuan purina man. Mana chasna ranata munashaga mana ima uraspas ñucahuan puric tucunguichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Canguna shuc jatun huasita shayachinata munashaga ñaupapundaga alita yuyarichi chi huasita tucuchinata ushashachu imachari nisha yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mana chasna yuyarishaga, callarishcahuasha cullqui mana pactacpiga chaupillai saquina tucunga. Can chasna racpi tucui runaguna canda asinaunga casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Cai runa sirtushina huasita rangahua callarirami randi tucuchinata mana ushashcachuya nisha asinaunga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chasnallata shuc mandac amu, shugmanda amuhuan guerata ranata munasha manachu ñaupallata alita yuyaringa, ñuca chunga huaranga (10.000) sundalugunallahuan chi shugmanda amuhua ishcai chunga huaranga (20.000) shamuc sundalugunataga binsinata ushashachu nisha yuyaringa. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana ushashachu nisha guera chara mana tucugllaita, chi shuc amu chara caruma aullaita, shuc runata cachangaraun guerata saquishun nisha rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chasnallata maican runa ñucata catinata munasha ñaupata alita yuyarina man casna nisha, tucui ñuca charishcagunata saquinata ushanichu nisha amullata yuyarina man. Mana chasna yuyarishaga ñucata catic runa tucunata mana ushanzhu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Cachiga ali man. Astahuanbas chamuc tucucpiga alichinata ushanchichu. Mana. Mana ushanchichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chasnallata chi chamuc cachi mana balinzhu allpaicuinta tarpungahuas, ruya huiñachun nisha imabis churangahuapas mana balinzhu. Jichunalla man. Ñáuca shimita canguna rinrihuan uyashaga alita yuyarichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Juchayuc runagunas, gubirnuraicu cullquita tandachiucunahuas Jesuspagma caillayamunaura pai yachachiushcata uyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseogunaga Diospa shimita pasachic runagunandi chi mana balichishca runagunata ricusha piñangahua callarinaura. Piñasha paigunapura rimanacunaura cai Jesusca juchayuc runagunahuan puriun, chasnallata paigunahuan micunmi nisha rimashca anaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chasna rimanacucpi Jesus paigunata shuc yachachina shimita cuintara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Canguna patsac (100) ovejata charisha shuc oveja chingaricpiga manachu tucuita pagllai saquisha chi chingarishcata mascangahua ringuichima. Manachu chi tucui iscun chunga iscungunata (99) saquisha chi shugllata tupanagama mascangahua ringuichima. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mascasha tupasha camba rigrai churasha cushihuan apamungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ñáa huasima pactasha tucui camba aillugunatas mayanllai tiyaccunatahuas cayagringui ñuca oveja chingarishcata tuparanimi nisha. Ñáuca tupashcamanda cangunahuas ñucashinallata cushiyaichi ninguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chasnamandami cangunata nini, Tucui ali mani nisha rimac runagunarandimanda, chi shuc runa juchata saquisha Dios munashcata racpi jahuapachai angelguna cushi tucungaraunguna nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Chasnallata nira, Shuc huarmimi chunga (10) balic cullquiguna charisha shuc chingaricpiga manachu mascanga. Paiga bilata japichisha chihuasha huasita pichasha chi cullquita tupanagama mascangaraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pai tupasha paihua aillugunatas mayanbi tiyaccunatahuas rimagringa, ñuca cullqui chingachishcata tupashcamanda cangunahuas ñucashinallata cushiyaichi ningami. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cangunata nini, shuc juchayuc runa paihua juchata saquisha Diospa causaita tupashcamanda Diospa angelgunahuas chasnallata cushiyangaunami, nisha paigunata nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus shuc yachachina shimita chasnallata cuintara casna nisha, Shuc runa ishcai (2) churita charira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Quipa churi paihua yayata rimara, Can charishcamanda ñuca japina partita cunan ratu cuhuai yaya. Chasna rimacpi paihua yaya tucui pai charishcagunata chaupisha ishcandi (2) churigunama cura. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mana yapa unaihuasha chi quipa churiga pai tucui charishcagunata tandachisha paihua yaya huasimanda llucshisha rira caru llactama puringahua. Pai chima risha jiridsata rasha causasha paihua cullquitas pai charishcagunatahuas huin tucuchira illacta tucuchisha llaqui saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Asnaibi pai tucui charishcata gastashcahuasha, tucui llactagunai yapa raicaitucura intiru llacta. Chasna tucushcai chi runaga raicaihuan huañungahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chasnaibi tarabanata mascangahua callarira tarabanata tupacpi paihua amu cachara cuchigunata carasha cuirangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pai chasna raicaihuan huañucpihuas pihuas mana nigunata caranaushcachu imahuahuallas. Chasna ashcata raicacpi cuchiguna micunatas micungahua yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chasna tucusha paihua shungüi casna yuyaringahua callarira, Ñáuca yaya tarabachiushca runagunaga yapa ashca micunata charinaunmi yalicta asta puchunmi. Ñáuca randi caibi raicaihuan huañuc tiyauni. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cunan caimanda llucshisha rishami ñuca yayahuacta. Pactasha casna paita rimasha, Dios ñaupacpis camba ñaupacpias juchata rashcani yaya. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mana balicchashcani camba churi nishca tucungahua. Chasna acpi can tarabachiushca runatashina japihuai canda sirbic tucusha nisha paita rimashami. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chasna yuyarisha paihua yayahuagma rira. Yayaga randi paihua churi chara carullaita shamuuta ricusha llaquisha callpara paihua churihuagma. Pactasha cushihuan ugllarisha ashca cutin paihua churita muctira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chasna acpi chi churi paihua yayata rimara, Diospacpis camba ñaupacpihuas juchata rasha causaushcani yaya. Mana balicchani camba churi nishca tucungahua nisha paihua yayata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Paihua yaya randi pai tarabachishca runagunata casna nisha mandara, Uctalla ali llachapata apamusha churachichi. Paihua maqui riruibi anillutas satichi, paihua chaquibihuas zapatosta churachichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chasnallata chi huirayachiushca huagra huahuata uctalla huanchichi. Alita micusha jistata rashunchi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cai ñuca churi huañushcachari nisha yuyaric arani randi pai causaushcami. Chingarishcachari nisha yuyarani randi causapaushcami cunan tupani nisha rimara. Chimanda jistata rashunchi cushiyangahua nisha rimara paihua yaya. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Paiguna chasna raushcaibi rucu churiga chagraibi aura. Huasima caillayamusha uyara cajasha bailaucunatas, pijuanu tucaushcatahuas uyara. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chita uyasha shuc tarabac runata cayasha tapura, Imatata raunguna nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tapucpi rimara, Camba huauquiga pactamushcami. Pai alilla pactamucpimi camba yaya jistata raun, chi malta huagra huirayachishca shayactami huanchishami caraun paihua churita. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chita uyasha chi rucu churiga yapa piñarisha huasi ucuma yaicunata mana munarachu. Chasna pai mana yaicucpi paihua yaya canzhama risha cuti cuti rugangahua rira, Huasi ucuma yaicui churi jistata gustangahua nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Randi rucu churi piñarisha paihua yayata rimara, Ñáucaga unai unai huatata canda yanapashcani. Can mandashcata tucui uras ñuca pactachishcani. Chasna acpihuas ñuca amigogunahuan ni shuc chibo huahuallahuas mana cuhuashcanguichu jistata rangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Astahuanbas cai camba churiga, mana ali huarmigunahuan causasha, can cushca cullquita tucuchisha shamucpi, pairaicu chi malta huagra huirayachiushca shayauctaga huanchishcangui paita carangahua nisha piñasha paihua yayata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Rimacpi yaya paita nira, Tucui uras can ñucahuan tiyaushcangui churi. Tucui ñuca ali charishcagunaga cambaglla man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Camba huauquiga huañushcashina illan ac cunan pactamushca. Chingarishcachari nisha yuyariushcai causagllata shamushca. Chiraicumi jistata cushi rana anchi nishami yaya rimara paihua punda churita. Chasna rimasha Jesus chi israelgunata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus paita caticcunata cai yachachina shimita cuintara casna nisha, Shuc cullquiyuc runa paihua capataz runama tucuita cuirachun nira. Chihuasha paimanda shuc shimi llucshirira ñucanchi amuhua cullquita huinda apaun nishca. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chita uyasha paihua amu chi capataz runata cayara cuintanacungahua. Pai pactamucpi can ñuca cullquita apaunmi nishcata uyashcani, can chimanda imasata ningui nira. Cunanga llucshina mangui, cunanmandaga ñucahuacpi mana tarabanguichu. Tucui runagunahua dihuigunata apuntashca quillcata apamui ñuca ricungahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chita uyasha chi capataz runaga yuyarira cunanga imasnata rasha nisha. Amu ñuca tarabanamanda llucshichicpiga imasna rashata causasha, imaita tarabanata tupasha. Chagrata tarabana jursata mana charinichu. Cullquita tapunatas pinganimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tarabana illacpi imasata causasha. Casnami rasha nira, tucui dihuigunata pishiyachishami runaguna ñucata llaquisha paiguna huasima apanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Capataz runaga chasna yuyarisha caran dihuiyuc runagunata cayara. Ñáaupapunda shamuc runata tapura, ñuca amuta masnatata dihuingui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tapucpi rimara, shuc patsac (100) asaititami butigunata dihuini. Chasna rimacpi mandara, uctalla camba quillcata apagri, cunanga chita pishiyachisha pichca chungallata (50) quillcai. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Shuctahuas tapura, canga masnatata dihuingui ñuca amuta. Tapucpi rimara, shuc patsac (100) trigo custalgunata dihuini. Chasna nicpi paita mandara, camba quillcaibi pishiyachisha pusac chungallata (80) churai nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chi amuga paihua capataz runa mana alita ragashallata pai imasna huasha causanata yuyarishcata yachasha paiga yuyaiyuc runa man nira. Chihuasha Jesus paita uyaucunata nira, Diosta caticcunaga jahuapachai ganangahuaca ashillata yuyarinaun, randi Diosta mana caticcunaga cai munduibi ganangahua mas yalita yuyariunaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Canguna cullquihuan Diospacta rasha ali yuyaihuan shuccunatas yanapasha puringuichi. Canguna huañushca punzhai cai jucha mundumanda cullqui illangami. Cunanga canguna cullquihuan ali yuyaihuan raichi chi tucurina punzhai Dios cangunata paihua huiñai tiyac llactama yaicuchingahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Maican runa ashilla rashcagunata pactachishaga huasha balic ranagunatahuas pactachingami. Pihuas ichilla rashcagunamanda llullashaga huasha jatun ranagunatahuas yanga llullanga. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chasna acpi canguna cai pachaibi charishcagunahuan mana aligunata racpiga jahuapachaibiga balic charinagunatas mana cuitucunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chasnallata canguna shuccuna charishcagunata mana alita cuiracpiga pihuas canda mana cungachu camba quiquinbacta charingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pihuas ishcai (2) amuta charinata mana ushanzhu. Ishcaita uyasha nishaga shucta llaquingami shuctaga mana llaquinga, shuc amullata uyasha chi shuctaga mana uyanga. Chicuintallata cangunahuas cullquita llaquishaga Yaya Diostaga llaquinata mana ushanguichichu nisha yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chi cullquita llaquic fariseoguna pai rimashcata uyasha paita piñasha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chasna piñasha asicpi Jesus paigunata rimara, Cangunaga runagunahuacpi alita rac manchi nisha yuyaringuichi, astahuanbas Diosca canguna caran shungutas yachanmi. Runaguna yapa balichishcataga Yaya Diosca mana balichinzhu nisha nira. Jesus paigunata mas yachachisha catiun casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ñáaupamanda Bautisac Juan camachishca urascama runaguna yachanaushcami imasna rasha Diospacpi quishpinata. Moises mandashca quillcagunatas, chasnallata Dios rimashcata pasachic runaguna quillcashcagunatas charishcauna. Ñáa Bautisac Juan camachishca urasmanda ñaupagma ñuca Diospa ali mandanamanda yachachisha cushi shimita rimauni imasna runa quishpitucunga. Chi shimita uyac runaguna Diospagma yaicunata ashcaguna yapa munanaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Diospa shimiga mana ima uraspas tucuringachu. Jahuapachas cai pachahuas tucuringaunami, astahuanbas Diospa shimiga mana tucuringachu, nisha Jesucristo cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Chasnallata nira, maican runa paihua huarmita jichusha shucta japishaga ashiyanmi. Chasnallata maican runa shuc jichushca huarmita japishaga chasnallata ashiyasha juchata ran nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus paigunata rimara, Shuc runa ashca cullquiyuc tiyara, yapa ali balic llachapata churaric ara. Chasnallata caran punzha paiga jistaicuinta micusha upisha causac ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Paihua huasi pungüibi shuc Lazaro nishca pugri runata saquishca aura, pitas cullquita tapusha tiyauc ara. Paiga ashca lepra nishca sinzhi carachayuc ashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Chasna acpi allcuguna paihua carachagunatas llaucanaura. Lazaro yapa pugri asha chi cullquiyuc runa micushcai allpai jicharicta yapa micusha nigara. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Shuc punzha chi pugri Lazaro huañura. Pai huañushcai angelguna paihua causaita jahuapachama apanaura. Chibi ñaupa causac Abrahan nishca israel runaguna apayayahuan causac ara. Chasnallata chi cullquiyuc runa huañucpi pambanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Paiga huañushcaguna aushcai yapa turmintarisha tiyaura. Chimanda jahuama ricusha Abrahan Lazarondi pariu jahuaibi tiyauta ricura carumanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ricusha caparira, Apayaya Abrahan ñucatas yuyarihuai. Lazarota caima cachai, paihua riru pundata yacuibi satisha ñuca callui churasha chiriyachihuac shamuchun nira. Cai ninaibi yapactami rupasha turmintariuni nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahan randi rimara, Yuyari, can causaushcaibiga yapa aligunata charishcangui, Lazaro randiga yapa llaquilla causagara. Cunan pai caibiga cushi maun. Can randiga yapa turmintariungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chasna acpi ñucanchi cambagma mana shamunata ushanchichu yapa jatun huaicu ashcamanda. Pihuas munashallata caimanda chima rinata mana ushanzhu. Chasnallata chimanda caimas mana shamuibacchan. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chi rimashcata uyasha ucupachamanda rimara, Chasna acpiga apayaya, canda rugauni ñuca yayahua huasima Lazarota cachai. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ñáuca charini pichca (5) huauquigunata. Lazaro paigunata camachigrichun paigunahuas cai ñuca turmintariushcama ima shamunauchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Astahuanbas Abrahan paita rimara, Moises quillcashca shimigunata basta charinaunmi, chasnallata Dios rimashcata pasachic runaguna quillcashcagunatas chariungunami. Paiguna chi quillcashcata ricusha yachanauchun chima ama ringahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nicpi rimara, Mana, apayaya Abrahan, paiguna chita ricushallata mana uyanaungachu. Astahuanbas huañushcamanda causaric runa camachigricpiga paiguna chita uyasha juchata saquisha Dios munashcata rasha catingaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nicpi Abrahan paita rimara, Moises quillcashcata paiguna mana uyashaga, Dios rimashcata pasachic runaguna quillcashcatas mana uyashaga, shuc huañushcamanda causaric runa rimacpihuas mana quiringaunachu. Chi fariseogunata Jesus chasna cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus paihuan puriucunata rimara, Sirtupacha cai mundui juchata rana yuyai tiyangami. Chasnagllaita juchata rai nisha pandachic runaga yalicta cashtigashca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Shuc huahuatashina ñucata quiriccunata maican pandachic runata jatun cutana rumita paihua cungaibi huatasha mar cuchai tucsinaupi chucacpiga ali chari anma. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chasnamandami canguna alita yuyarisha causaichi nira. Camba quiric huauqui juchata racpiga ali shimita cuintasha alichinata yuyachi. Pai mana alita rashcamanda llaquirisha perdunahuai nisha tapucpi can paita perdunasha huiñai saquina mangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Shuc punzhalla pai canzhis (7) cutin canda mana alita rashcahuasha perdunahuai nisha tapucshamucpiga, caran cutin paita perdunasha cungarina angui nisha Jesus yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Señor Jesus japishca chunga ishcai (12) runaguna paita tapunaura, Ñáucanchima mas quirina yuyaita cui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chasna tapucpi rimara, Canguna shuc ichicua mostaza nishca muyuhuatacuinta ashilla quirina yuyaita charishahuas, cai ruyata rimanata ushanguichimi, ruya angundi caimanda llucshisha cuchaibi shayarigri nisha. Chasna nicpi chi ruya can rimashcashina tucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesus paita caticcunama rimara, Shuc runa chagraibi tarabac asha, huagrata cuirac ashahuas pai tarabanamanda shamucpi paihua amu, uctalla caibi micungahua tiyaricshamui nisha rimangachu. Mana. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Astahuanbas amu ñaupa mandangaraun ñuca micunata yanusha carahuai. Pundaga ñuca micusha upishcahuasha canga huasha micungui upingui nisha rimanga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tarabac runa paihua amu mandashcata pactachicpihuas amu paita pagrachu ningachuya. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chasnallata cangunata Dios mandashcagunata pactachisha rimaichi, Alita rashahuas can mandashcata pactachisha tarabac runalla anchi, can mandashcataga pactachiglla anchi nisha rimana manguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus Jerusalenma riusha Galilea provinciahuan Samaria provinciahuan chaupita puriura. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Chibi shuc llactama chara mana pactaullaita chunga (10) lepra nishca sinzhi carachayuc runaguna paita tupangahua shamunaura. Paiguna carumanda shayarisha, Señor Jesus ñucanchita llaquisha yanapai nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus paigunata ricusha rimara, Israel pagrigunama canguna carata ricuchigrichi. Pai rimashcata uyasha riushcai chi lepraguna janbirira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chasna tucucpi chi muntunmanda shuglla chasna janbirishcata ricurisha cuti Jesuspagma bulltiamura. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pai bulltiamusha sinzhi shimihuan Diosta alabasha shamura. Pactasha Jesuspa chaqui mayanbi allpaibi tuparinagama cungurisha ashca cushihuan Jesusta pagrachu nisha rimara. Chi runaga israelguna mana balichiushca Samaria llactamanda runa mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Shugllata ricusha Jesus tapura, Manachu chunga (10) aranguichi janbirishcagunaga. Chi iscun (9) runagunaga maibitanaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cai runaga mana-israel runa ashallatachu bulltiamushca Diosta pagrachu nisha alabangahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chasna nisha paita rimara, Jatarisha rilla. Can ñucata quirishcamandami quishpichishca tucungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Maican fariseo runaguna Jesusta tapunaura, Ima urasta Diospa ali mandana shamunga, cai pachaibi ima urasta Dios mandangaraun nisha. Tapucpi rimara, Pai mana chasna ricurictachu mandanga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chiraicumandami mana casna rimanachan Diospa ali mandana caibi maun, ricui chibimi aun nisha. Randi runa shungu ucuibi yuyaibihuas Dios mandac man nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Paihuan puriucunata rimara, Ñáuca Runa Tucuc asha, huasha mana ricurishachu. Canguna ñucata shuc punzhata ricunata yapa munangaraunguichi, chasna ashallata mana ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Maican runaguna cangunata rimangauna, ricui paiga caibi maun u chibi maun nisha. Chasna nisha rimacpihuas ima uyaichichu, ima paigunata catinguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Uyahuaichi. Runa Tucuc asha, ñuca shamuna punzhaga dilampashcacuinta manga. Dilampashcaga shuc pundamanda shuc pundagama liúc liúc ricurinmi. Ñáuca shamunaga chasnami huairashina ricuringamirauni. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Astahuanbas ñucataga ñaupata ashcata turmintachihuanaungami, cunan causac runaguna ñucata mana uyasha ñucata mana balichihuanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ñáuca bulltiamuna urasca Noe causashca urascuintami tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pai barcoma yaicuna punzhagamami chi runagunaga micusha upisha cadsarasha causanaushca. Chasna paiguna mana yuyarisha causaushca urasllaita yacu ashcata jundasha paigunata illacta huanchira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chasnallata Abrahanba sobrino Lot causaushca uras, runaguna micusha upisha, randichisha randisha, tarpusha, huasigunata rasha causanaushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Chasna causaushcai Sodoma nishca llactamanda Lot llucshishcahuashai jahuapachamanda sinzhi ninas asnac cushnihuas urmasha tucuita rupachisha huinda huanchishca. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ñáuca shamuna punzhaga chasnallatami tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Chi punzha pactamushcaibi maican runa camba huasi jahuai tiyausha uctalla uraicusha miticui, ama huasi ucuma yaicuichu can charishcagunata apangahua. Chasnallata maican runahuas chagraibi tarabaushaga ama huasima bulltiaichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotpa huarmi tucushcata yuyarichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Paicuinta pihuas cai mundui paihua causaita yalicta llaquishaga Diospacpi tucuita chingarisha illac tucungami. Astahuanbas pihuas paihua quiquin causaita mana yalicta yuyarishaga paiga Diospacpi tucuita charingami, nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Cangunata nini, Tuta ishcai (2) runa shuc cayutullai puñungaunami. Yaya Dios shucta apangami, shucca saquirishca anga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishcai (2) huarmiguna pariu tarabaushcai shucta apashca anga, shucca saquirishca anga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishcai cariguna chagrai tarabaushcaibi shucta apashca anga, shucca saquirishca anga. ");
INSERT INTO qvzNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesus chasna rimashcata uyasha paita caticcuna tapunaura, Señor casnaga maibita tucunga nisha. Tapucpi paiguna shuc shimita rimara, Ullahuangagunaga huañushcaibi tandaringaunami. Ñáuca rimashcacuinta ricuricpi yachanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Paiguna tucui uras Yaya Diosta mañasha tapunata ama saquisha causanauchun nisha Jesus cai yachachina shimitas yachachiura, ");
INSERT INTO qvzNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Shuc llactaibi shuc taripac runaga tiyashca. Diosta mana manzhacchashca, runatahuas mana llaquicchashca. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chasnallata chi llactaibi shuc huaccha huarmi tiyashca. Pai ashca cutin chi taripac runama tapungahua rigashca casna nisha, ñucata yanapahuai chi ñucata piñac runa ñuca charishcagunata ima yanga apachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tapuugllaita chi runaga yanapanata mana munashcachu. Unaima yuyarira, Ñáucaga Diosta mana manzhanichu, runatahuas mana llaquinichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Chasnagllaita cai huaccha huarmi caran punzha ñucata tapusha quillachishcamanda paita yanapasha, paimanda quichuc runata rimasha alichigrisha. Cunan paita mana yanapacpiga ñuca huañunagamami tapusha causahuangaraun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Señor Jesus chi yachachina shimita rimashcahuasha paigunata rimara, Chi Diosta mana manzhasha taripac runa rimashcata yuyarisha yachaichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yaya Diosca ali ac asha paihua quiquin runaguna tutahuas punzhahuas paita tapucpi yapa alita paigunata yanapangami. Paigunata yanapanata mana unayangachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cangunata nini pai mana unayashachu yanapangami. Chasna agllaita Runa Tucucca ñuca jahuapachamanda shamushcai chi tapuc huarmicuinta runaguna sinzhita quiriccunata tupashachu imachari. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Maican runaguna Diospacpi ali mauni nishallata shuccunata mana llaquinaunzhu. Chasna acpi chicuinta yuyaric runagunata Jesus cai yachachina shimita cuintara, ");
INSERT INTO qvzNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ishcai (2) runa Diosta alabana huasima rinaura Dioshuan rimangahua. Shucca fariseo runa mara, shucca romano gubirnuraicu cullquita tandachic asha, mana balichiushca runachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo runa shayarisha paihua munaimandalla Diosta rimara casna nisha, Ñáuca mana shuccunashina chashcamanda canda pagrachu nini Yaya Dios. Mana shuc shuhuac runachani, mana jiridsata racchani, mana ashiyacchani, maspas mana chi romano gubirnuraicu cullquita tandachic runashinachani. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ñáucaga ishcai (2) cutin caran semana mana micusha sasini can ñucata balichichun nisha. Tucui ñuca charishcagunata chunga (10) partimanda shuc partita canma cusha causac ani nisha chi fariseo runa Diosta rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Chi shuc runaga, gubirnuraicu cullquita tandachic runaga caruma shayarisha jahuapachama ricunata pingarisha, paihua juchata yuyarisha llaquirisha pichuta huactarisha rimara, Ñáuca juchayuc runa mani Dios. Ñáucata yuyarisha yanapahuai nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chi yachachina shimita cuintashcahuasha Jesus paita uyaccunata rimara, Cangunataga casnami nini, chi yapa ali mauni nisha rimac runata Dios mana japirachu. Randi chi juchamanda llaquiric runataga Dios perdunashcamanda Dioshuan ali tucusha paihua huasima bulltiara. Cangunata nini, maican runahuas yapa ali mani nishaga Diospacpi mana balichishcachu tucunga, astahuanbas shungumanda Diospacpi mana balicchani nisha rimac runaga Diospacpi balichishca tucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chi uras ichilla huahuagunatas Jesusma apanaura paigunata llangasha Diosta mañapangui paiguna ali anauchun nisha. Jesushuan puriucuna chita ricusha ama quillachichun nisha jarcanata munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesus randi huahuagunata shamuichi nisha cayasha, paihuan puriucunata nira, Huahuaguna ñucama shamunauchun, ama jarcanguichichu. Diospa ali mandana runagunaga cai huahuagunacuinta maunguna. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñáuca rimashcata cunan uyaichi. Cai huahuaguna ñucata alita uyasha cadsunaunmi. Pihuas Diospa munaita mana huahuacuinta catishaga Diospa ali mandanama yaicunata mana ushanzhu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Shuc israel amu Jesusta tapura, Can Dios mandashcashina causac asha ali mangui señor. Chasna asha rimahuai, ñuca huiñai causaita charingahuaca imasata rana ani. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tapucpi rimara, Imangahuata ali mangui nisha ñucata rimahuangui. Mana shuc runahuas ali tiyanzhu, Dioslla ali an. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Can Dios mandashcagunata yachanguimi: Ama ashiyanguichu, runata ama huanchinguichu, ama shuhuanguichu, shuccunamanda ama llullanguichu, camba yayatas camba mamatas llaquina mangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rimacpi nira, Chigunataga ñuca huahua urasmandallatami tucuita pactachishcanimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chasna nicpi Jesus rimara, Cambacpi chara shucca pishinmi. Tucui can charishcagunata randichisha pugri runagunama cullquita cungui. Chasna cugrisha jahuapachai Dios cungaraushcata ashcata charingui. Chasna rashcahuasha ñucataga catihuanguilla nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chi runa yapa ashcata charic ashami Jesus randichigri nishcata uyasha yapa llaquirira. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chi runa llaquirishcata ricusha Jesus rimara, Charic runaguna Diospa ali mandanai yaicunata sinzhi man paiguna amuyuc tucunata mana munasha. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Shuc camello nishca jatun aichaga abuja ichicu juctui yaicunatas mana ushanzhu. Chicuinta shuc cullquiyuc runa Diospa ali mandanama yaicungahua nicpiga mas mana yaicuibacchan nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesus chasna rimashcata uyasha chibi aucuna tapunaura, Chasna acpiga pita quishpinataga ushangaya. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tapucpi rimara, Yaya Diosca runa mana ushashcatas ushanmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jesus rimacpi Pedro nira, Ñáucanchi saquishcanchi tucui charishcagunata canhuan catingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Chasna nicpi Jesus tucui paigunata nira, Cangunata sirtuta nini, pihuas Diospa ali mandanaraicu tucuita saquisha, paihua huasitas, aillutas, huarmitas, huauquigunatas, yayatas mamatas, huahuagunatas saquisha Diospacta rangahua, chi runa cai pachaibi yali ashcata cuitucungami. Chasnallata Diospa jahuapachaibis huiñai causaita charingami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus pai japishca chunga ishcai (12) runagunallata tandachisha rimara, Ñáucata ali uyaichi. Cunanga Jerusalen llactama riunchi. Runa Tucuc ashcamanda tucui Dios rimashcata ñaupa pasachiccuna ñucamanda quillcashca shimiga tucuimi pactaringaraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi llactaibi mana-israel runaguna maquima cuitucungarauni. Paiguna ñucata pugllasha asihuangaraunguna, chasnallata ñucata camisha mana alitachu rahuangaranaun, ñucata tiucahuangaranaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Piñahuasha huascahuan libachihuanaunga, puchucaibi huanchihuangaraungunami. Paina huanchicpihuas quimsa (3) punzhaibi cuti causarishami nisha paigunata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesus chimanda rimautahuas mana imatahuas intindinaurachu. Pai yachachiushcaga mana yachaibaccuinta acpimi pai imamanda chasna rimauctas mana yachanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus paihua runagunandi Jerusalenma mas riusha Jerico nishca llactama caillayanaura. Chibi shuc puyuñahuiyuc runa ñambi mayanbi tiyarisha tucui pasauc runagunata cullquita tapuura. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chi punzhai ashca runaguna shamuucta uyasha tapura imashashca, imashi tucun. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tapucpi rimanaura Nazaret Jesusmi shamuun. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chita uyasha chi runa caparira, Jesus can israel rey amu David mirai ashcamanda cunan ñucata yuyarisha yanapahuai. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chasna caparicpi ñaupa riu runaguna piñasha paita rimanaura chunlla tiyai nisha. Chasna nigllaita pai mas sinzhita caparira, Jesus can israel rey amu Davidmanda mirai runa ashami ñucata yuyarisha yanapahuai. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chasna caparicpi Jesus shayarisha chi runata ñucama apamuichi nira. Apamunaupi Jesus paita tapura, ");
INSERT INTO qvzNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Imatata munangui ñuca canda rangahua. Tapucpi nira, Ñáuca ñahuita alichihuai, yapa ricunata munani señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nicpi Jesus nira, Alimi, cunan ricuitucungui. Can ñucata quirishcamandami ali tucungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesus chasna rimashca ratullai chi runa ricuc tucura. Chasna tucusha Diosta alabasha Jesushuan puringahua callarira. Tucui runagunahuas chita ricusha chasnallata Diosta alabanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus Jerico llacta ucuma yaicusha ña pasaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pai pasaushcai shuc runa aura Zaqueo nishca. Paiga tucui gubirnuraicu cullquita tandachic runagunahua amu mara, yapa ashca cullquiyuc runa mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pai Jesusta ricunata munara randi pai yapa ichilla runa ashcamanda chasnallata yapa ashca runaguna aushcamanda mana ricunata usharachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chasna ashami ñaupagma callpasha rira shuc sicomoro nishca ruyata sicangahua, chimanda Jesus riuta ricungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus ña chi ruyama pactasha jahuama ricusha nira, Uctalla uraicui Zaqueo. Cunan punzha camba huasibi pasiasha nisha riurani. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chita uyasha Zaqueo huairashina uraicusha yapa cushihuan paihua huasima Jesusta apasha rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tucui runaguna randi chita ricusha piñasha paigunapura cuintanacunaura, Cunanga Jesus pasiangahua riushcami yapa juchayuc runa huasima nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueoga chillai shayarishami Señor Jesusta rimara, Ricui señor, cunan ñuca charishcagunamanda chaupita pugri runagunama cungarauni. Maican runatas ñuca cullquita yalichisha cubrashca ashami chuscu (4) cutin yalictami caran runama cungarauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chasna rimacpi Jesus paita nira, Canga ñucanchi huañuc apayaya Abrahan quirishcashina quiringui. Chiraicumi cunan punzha quishpishca tucungui camba huasibi aucunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ñáuca Runa Tucuc asha shamushcani chingarisha causaccuinta runagunata mascasha quishpichingahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pai Jerusalenma pactangaraushcai runaguna yuyarinaura Diospa ali mandanaga cunan uras pactamunmi, Jesus cai llactai amu tucungami nisha yuyarinaura. Chi runaguna Jesus rimashcagunata yuyaricpi pai shuc yachachina shimita cuintara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Balichiushca runagunamanda shucca caru llactama ringaraura jatun mandac tucuna ushaita japingahua, japishcahuasha bulltiamungahuami rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chara mana llucshiushallata paihuacpi chunga (10) tarabac runagunata cayasha ashca cullquita caran shucta chi tupullata cusha mandara, ñuca bulltiamunagama cai cullquihuan canguna tarabausha mirachinguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pai rishcahuashalla paihua llactaibi tiyac runaguna randi paita mana gustasha shuc shimita gubirnuma cachanaura, chi runa ñucanchita mandanata mana munanchichu nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Paiguna chasna niupihuas chi runaga amu tucusha paihua llactama bulltiamushcahuasha chi cullquita cushca runagunata paihuagma cayara, canguna chi cullquihuan masnata ganasha tarabaushcata yachanata munani nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ñáaupa shamuc runa paita nira, camba cullquita chunga (10) cutin mas yalita mirachishcani señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chasna nicta uyasha amu paita nira, Yapa alimi, can ali tarabac runa mangui. Chi ashilla cullquihuan can alita tarabashcamanda cunan ñuca mandaushca llactagunamanda can chunga (10) llactata mandac tucungui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chihuasha shuc runa amuhuagma shamusha nira, camba cullquita pichca (5) cutin mas yalita mirachishcani señor nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chasna nicpi amu paita nira, Cunan ñuca mandaushca llactagunamanda can pichca (5) llactata mandac tucungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chihuasha shuc runa randi shamusha amuta rimara, caibi man camba cullquiga señor, llachapahuan pillusha huacaichirani. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Can yapa mandaisiqui runa ashcamanda canda manzharani. Shuccuna tarpushcata canga pallashcata ganac mangui, shuccuna tarabashcamanda japisha ganaglla tiyangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chita uyasha amu paita rimara, mana balic runachangui. Can quiquin rimashcallahuandami taripaitucungui. Ñáuca mandaisiqui runa actaga sirtuchu yacharangui. Ñáuca mana tarpushallata pallac runa acta mana tarabashcamanda japisha ganac runa acta sirtuchu yacharangui. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chasna acta yachashaga imangahuata chi cullquita mana bancui churarangui mirarichun nisha. Can chasna churashca acpiga ñuca bulltiamunagama chi cullqui ansallahuas mirarishcandi japima arani. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chasna rimasha amu chibi shayauc runagunata mandara, chi cullquita paimanda quichusha chi chunga (10) cutin cullquita mirachic runama cuichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Randi señor, paiga ashcatami charin ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chasna nicpi rimara, cangunata nini, maicanbas yali charicca mas charic tucunga, astahuanbas mana charic runaga tucui pai charishcatahuas quichuitucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Cunan tucui chi ñuca mandac amu tucunata mana munac runagunataga apamusha ñuca ñaupacpi huanchichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chi yachachinata cuintashcahuasha Jesus Jerusalenma pactangahua chimanda cuti riura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olivos nishca urcui Betfagé y Betania nishca llactaguna mayanma pactasha ishcai (2) paihuan puric runagunata cachara casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Chi ricuriuc llactama richi. Chi llactaibi yaicusha shuc mana pihuas tiyariushca malta burrota huatashca aucta tupangaraunguichi. Chita pascasha apamunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Maican runa canda imangahuata pascaunguichi nisha tapunaupiga ñucanchi amumi paita munan nisha rimanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chasna nicpi chi cachashca runaguna risha Jesus rimashcashinallata tupanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burrota pascaupi amuguna paigunata ricusha tapunaura, Imaraicuta chita pascaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tapucpi ñucanchi amumi paita munan nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Burrohua amu mana mitsanaupi Jesuspagma apasha paiguna llachapagunata burro jahuaibi Jesus tiyaringahua nisha mandanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pai tiyarisha riupi runaguna paita mandac amutashina rasha paiguna llachapagunata ñambibi mandaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos urcumanda uraicusha Jerusalen llacta mayanma pactaupi tucui paita ashca catic runaguna yapa cushihuan Diosta alabangahua callarinaura. Paiguna Jesus tucui ushaihuan ali rashcagunata ricuc asha Diosta alabanaura casna caparisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dios cachashca shamuc ashami balichishca achun. Cieloi aucunahuas cushi anauchun, jahuapachai tiyauc Diostahuas yapa balichishca tucuchun nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chi muntunmanda fariseogunaga chi runaguna caparishcata uyasha Jesusta rimanaura, Chi capariu camba runagunata chunllayachi señor, paiguna ama chasna caparinauchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Rimacpi Jesus nira, Cangunata nini, paiguna chunllayacpiga astahuan cai rumigunami Yaya Diosta alabasha caparinaungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalenma caillayasha chi llactata ricusha llaquirisha huacara. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ai ima llaquita tucushcanguichi Jerusalen runaguna. Cunan punzhallahuas canguna Yaya Dioshuan alichitucungahua cushi causaita cucta yachashca ashaga alichari anguichima. Cunanga randi canguna ñahuita tapashcacuinta ashami mana asirtanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cangunahuacpi jatun llaqui pactamungamiraun nira. Cangunata piñauc runaguna cai llactata muyurisha quinzhata shayachinaungami canguna ama maitas llucshichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Huinda binsingaunami. Chasna binsisha cangunatas camba huahuagunatas huanchinaunga allpai tucsisha. Cai llactata tulaushcai mana ni shuc rumihuas jahuaibi saquiringachu, huin tulangaunmi. Yaya Dios cangunata quishpichingahua shamugllaita canguna mana munashcamandami llaquichitucungaraunguichi nishami Jesus Jerusalenda ricusha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chihuasha Diosta alabana huasima Jesus yaicusha chibi randichiu runagunata ricusha piñasha pagllama llucshichisha callpachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Chasna callpachiushami paigunata rimara, Diospa shimibi casna quillcashcami tiyan: Ñáuca huasiga ñucahuan cuintana huasi an. Astahuanbas cangunaga shuhuana huasicuintatami shina rashcanguichi nisha Jesus rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Caran punzha Diosta alabana huasibi Jesus yaicusha yachachiura. Chasna agllaita israel pagri amuguna, Diospa shimita yachachic runagunas, llactai balichiushca runagunahuas, Jesusta huanchingahuaca imasna rashata japishunchi nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amuguna chasna yuyarigllaita tucui runagunaga pai yachachiushcagunata yapa cushihuan uyaupimi chi amuguna mana imatahuas ranata ushanaurachu Jesusta. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Shuc punzha Jesus Diosta alabana huasi partibi tandariu runagunata Diospa quishpina shimita yachachiura. Pai yachachiushcai israel pagriguna, Diospa shimita yachachiccunandi, israelgunata mandac rucugunandi paihuagma shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pactamusha tapunaura, Ñáucanchita rimai, canga ima ushaihuanda chigunata rangui. Pita canda chita rachun nishaga mandara. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tapucpi Jesus randi rimara, Ñáucahuas cangunata shuc tapunata tapushcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Cunan rimahuaichi, pita Juandaga cachara bautisachun nisha. Dioschu cachashca ara, runagunachu cachashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tapucpi paigunapura cuintanacunaura, Imasata nishunchi. Diosmi Juanda cachara nisha ñucanchi rimacpiga, pai randiga imangahuata paita mana quiriranguichi nishami ñucanchita tapunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Astahuanbas paiga runa cachashca man nisha rimacpiga tucui runaguna ñucanchita piñasha rumihuan tucsiushallata huanchitucushunchimi. Paigunaga Bautisac Juan Dios rimashcata pasachic runa mara nisha yuyarinaunmi nisha manzharisha cuintanacunaura painapura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chasna runagunata manzhasha Jesusta rimanaura, Mana yachanchichu pi paita cachacta ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus randi paigunata nira, Canguna mana rimacpiga ñucahuas mana rimashcanguichichu ñuca pi mandashcahuan caita rauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesus chihuasha shuc yachachina shimita cuintangahua callarira casna nisha, Shuc runa chagrata rasha ashca uvas muyugunata tarpura. Chi tarpushca chagra pucucpi chaupinacushunchimi nisha paihua allpata shuc runagunama saquisha shuc caru llactama unaita tiyangahua rira. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ñáa pallana uras pactacpi chi amu shuc tarabac runata chi saquishca runagunahuagma cachara ñucaraicu pallashcachaupita apagringahua nisha. Randi chi tarabac runa pactacpi allpata cuiraccuna paita macasha maquimuillahuan cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chasna acpi chi amu cuti shuc runata cachara. Paitahuas macasha mana alita rasha imahuas illacta cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ishcaita (2) cachashcahuasha shucta cachacpi paitahuas macasha rahuailla cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Chasna ranaupi chi amu chihuasha yuyarira, Cunanga imasata rasha. Ñáuca llaquishca churita cachangarauni. Ñáuca churita ricushaga paita manzhanaungami nisha yuyarisha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Astahuanbas chi churi shamuucta ricusha chi saquishca runagunapura cuintanacunaura, Caimi cai allpa amu tucungarauca. Paita huanchishunchi ñucanchi randi amu tucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chasna nisha amuhua churita chagramanda pagllama apasha huanchinaura. Paiguna chasna huanchicpi chi allpayuc amuga imatashi paigunata rangaraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chi amuga shamushami paigunata illacta huanchisha chi allpata shuc runagunama cungamiraun, nisha Jesus yachachisha cuintara. Jesus chasna cuintauta uyasha runaguna rimanaura, Ai ama chasna tucuchun. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Randi Jesus paigunama ricusha tapura, Manachu yachanguichi Diospa shimibi ñucamanda casna quillcashca tiyan: Huasita rauc runaguna chi mana munasha jichushca rumillatami mas yali balic tucushca an nin. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Maican chi rumibi urmac runaga paquirishca tucungami. Chasnallata chi rumi urmaitucuc runaga pulbu tucungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesus chi yachachina shimita cuintashcata uyasha Diospa shimita yachachic runagunas, israel pagri amugunahuas piñanaura ñucanchimandami rimaun nisha. Chasna piñashami paita japinata yapa munanaura. Chasna japinata munashallata runagunata yapa manzhasha mana ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chasna ashami imasna rashata paita japishun nisha mascanaura. Chimanda Jesus rimashcata uyasha puriucuintata cachanaura Jesus yachachishcata uyanauchun nisha. Pai shuc shimillatahuas pandacta rimashcata uyashaga paita japisha apanata munanaura amu paita taripachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chi cachashca runaguna risha Jesusta rimanaura, Can ali sirtu shimita rimac mangui can, ali sumac yachachic actas yachanchimi señor. Tucui runagunata chi tupullata llaquisha mana shuctahuas mas yalita balichinguichu, astahuanbas Dios munashcallata rachun nisha yachachiunguimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chasna ashaga ñucanchi tapushcata rimai, jatun romano amu mandacpi ñucanchi cullquita pagashunzhu, manachu pagashun. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Paigunaga paita pandachingahua nisha tapucta yachasha Jesus randi paigunata rimara, ");
INSERT INTO qvzNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Shuc cullquita ricuchihuaichi. Pihuactan cai cullquibi tiyauc shuti ñahuihuas nisha tapura. Tapucpi ninaura, Romano jatun amuhuac man. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chasna nicpi paigunata rimara, Chasna amuhuacta amuma cuichi, Diospactaga Diosma cuichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesus chasna tucui runagunahua ñaupacpi alita rimacpi ima pandashca shimita rimashcatahuas mana tupanaurachu. Astahuanbas pai ali yuyarisha cutipacpi yapa ali man nisha chunlla tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chihuasha israel muntunmanda maican saduceo runaguna Jesuspagma shamunaura tapungahua. Paigunaga runa huañushcahuasha cuti causarinaga mana tiyanzhu nic manaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Chasna asha Jesusta camasha rimanaura, Señor, huañuc Moises quillcasha mandaitucushcanchi punda huauqui shuc huahua illac huañucpiga paihua quipa huauqui randi chi huaccha huarmita japina man paihua huauquihua allpa ama chingarichun nisha paihua shutita churanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ñáa shuc uras canzhis (7) huauquiguna tiyanaushca. Punda huauquiga shuc huarmita japisha huahua illac huañushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Paimanda quipa huauqui randi paihua huañuc huauquihua huarmita japishca. Paihuas chasnallata huahuata mana tupashallata huañushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chihuasha mas quipa huauquiguna paihua huañuc punda huauquihua huarmita caran shuc japishahuas mana ni shuc huahuatas tupashallata huañunaushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chihuasha huarmihuas huañushca. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chasna huañucpi runaguna huañushcamanda cuti causarina acpiga chi huaccha huarmiga tucui chi canzhis huauquigunahuan causacca pihua huarmita tucungaya. Paiguna chasna tapunaura huañushcaguna mana cuti causarinaungachu nigasha. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tapucpi Jesus paigunata rimara, Cunan cai pachaibimi runaguna huarmita japisha causaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Randi jahuapachaibiga mana chasnachan. Maican caritahuas huarmitahuas Dios ali mangui nicpiga huañushcamanda causarishami jahuapachaibiga causanaunga. Chi runagunaga jahuapachaibiga mana japinacushachu causanaunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Chibi causashaga angelcuinta mana huañunaungachu. Paiguna causarishcamanda Diospa churiguna tucungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Chi huañuc Moisesca runa huañusha cuti causarinamandami yachachira. Chi sindiu ruyamanda Dios paita cuintashcata quillcasha casna nira, Huañuc apayayaguna Abrahanba, Isaacpa, Jacobopa Dios mangui nishami rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chimandami yachanchi Diosca mana huañushca runagunahua Dioschan, astahuanbas causac runagunahua Dios man. Tucui runaguna huañushca ashallata Dios ricucpiga causac manaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jesus chasna rimacta uyasha maican Diospa shimita yachachiccuna rimanaura, Paigunata yapa alita rimashcangui señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chihuasha mana pihuas paita cuti tapunata munanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chihuasha Jesus chi Diospa shimita yachachiccunataga tapura, Imamandata yachachinaun: Dios cachamushca quishpichic Cristo nishca runaga israelgunata mandac ñaupa causac rey amu Davidmanda mirai runa man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Davidga Salmos libroi casna nisha quillcara: Jatun amu Diosca ñucata mandactami rimara casna nisha, Ñáuca ali maqui partima tiyari ñuca tucui canda piñaccunatas binsinagama nisha quillcashcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Huañuc Davidllata Cristota amu nisha rimacpiga imasata Cristoga Davidba miraimanda churi angaya nisha Jesus painata tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tucui runaguna uyaushcaibi Jesus paihuan puriucunata rimara, ");
INSERT INTO qvzNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Yuyarichi, Diospa shimita yachachic runamanda cuirarichi. Paiguna balic manchi nisha ali ricuric suni llachapata churariunguna runaguna paigunata balichihuanauchun nishalla. Runaguna tiyaushcai purisha tucuiguna paita alita saludahuanauchun nisha munanaunmi. Israel tandarina huasigunais jistagunaibihuas balichishca tiyarinagunaibi tiyarinata mascanaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Runaguna balichihuanauchun nishalla paigunahuacpi Diosta alabana huasibi yapa unaita mañaunguichi. Chasna ragllaita randi, paigunaga huaccha huarmiguna chagratas charishcagunatahuas quichunaunmi. Paiguna chasna causashcamanda tucuimandas yalita taripaitucungaraunguna nisha Jesus yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Shuc punzha Jesus ricuura yapa ashca cullquiyuc runaguna Diosta alabana huasibi Diosma cumbirana cullquita tandachina cajunbi churaushcata. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chasnallata shuc pugri huaccha huarmi mana balichishca ac cullquita ishcaillata (2) churashcata Jesus ricura. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chita ricusha Jesus rimara, Sirtuta cangunata nini, cai pugri huaccha huarmiga ashillahuata churacpihuas ashcata churashcashina ara illacta churashcamanda. Chasna rasha tucui chi cullquiyuc runagunamanda mas yalicta Diosma cushcami nini. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Paiguna tucui munashcata randishcahuasha puchushca cullquita churac shamunaura nira. Randi cai pugri huaccha huarmiga pai causangahua charishca cullquita illacta churashcami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Maicanguna Diosta alabana huasita gustu ricuric rumihuan rashcata cuintanaura, chasnallata chi huasibi runaguna Diosma balicta cushcagunamanda cuintaunaura. Chasna cuintanaupi Jesus paigunata rimara, ");
INSERT INTO qvzNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tucui canguna ricushcagunaga shuc punzhaga illacta urmashca tucungaunami. Tucui chi rumiguna mana ni shucpas shayaringachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chasna nicpi paita tapunaura, Ima urasta chasna tucungaraun señor. Chi llaqui shamungaraushcata imasata yachashun. Chasna can rimashcacuinta pactamungaraushcaibiga imagunata ricuringaraun nisha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tapucpi Jesus rimara, Alita yuyarisha cuiraichi. Ashca llullasha rimac runaguna shamungaunami ñucaga Dios cachamushca quishpichic Cristo mani nisha. Chasnallata ñuca mandana uras cunan pactamunmi nisha rimac shamunaungami. Ama chi llullashca shimihuan umachishca tucunguichichu, ima paigunata catinguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Canguna gueragunata uyasha, gubirnuta llucshichi caparishcatas uyasha ima manzharinguichichu. Tucui chigunaga ñaupata tucuna manaun. Chasna agllaita tucurina punzhaguna mana ucta pactamungachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chihuasha Jesus paigunata mas rimara, Llactapura macanacunaungami, mandac amupura piñarisha gueranacungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ashca cutin allpa sinzhita cuyungami. Maican llactagunaibi ashca raicai tiyangami, ungüigunahuas llucshinaungami. Chasnallata cieloibihuas ima tunu manzharinagunas ricurimunaungami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Randi tucui chi llaquiguna chara mana ricurigllaita maican runaguna ñucata quirishcamandami cangunata japisha turmintachingaunami. Israelguna tandarina huasigunama apasha cangunata taripangaunami, carcelbi tapangaunami. Canguna ñucata catishcamandami jatun amugunahuacpihuas, gubirnugunahuacpihuas apanaungami cangunata caudsayachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chasna ranaupihuas chi uras paigunamas ñucamanda rimanata ushanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Canguna huasha rimangaraushcata ima cunanllata yuyaringuichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi urasca ñucallatami cangunama ali yuyaitas cushami canguna rimangahua nira. Chi shimita canguna rimacpi piña runagunahuas cangunata binsinatas mana ushanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cangunahua yayagunas huauquigunahuas, aillugunahuas amigogunahuas cangunamanda llullasha amugunahuagma apangaunami caudsachishun nisha. Chasnallata canguna quiric muntunmanda maicandas huanchitucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tucui runaguna cangunata piñangaunami ñucata caticcuna ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Paiguna chasna cangunata rashallata canguna causaitaga imatahuas ranata mana ushangaunachu, canguna acchahuas mana chingaringachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Canguna ahuantasha ñucata catinata mana saquishaga quishpinguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesus rimara maspas, Sundaluguna Jerusalen llactata liyú jarcashcata ricusha yachanguichimi cai llactata binsina uras ña pactamunmi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Chi punzhagunaibiga Yaya Diosmi yapa libachinga. Tucui Dios rimashcata pasachic runaguna quillcachishca shimiguna ña pactanaungami. Chasna tucushcai canguna Judea llactagunai auccunaga urcugunama callpasha miticugrichi, chasnallata Jerusalen llacta ucui tiyaushaga pagllama uctalla llucshisha ringuichi. Canguna chagraibi tiyaushaga llacta ucuma ima cuti yaicunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Cai israel runagunata Dios yapa piñasha libachingami. Chasna tucucpi cai allpaibi yapa llaqui tiyangami. Ai, pugri huicsayuc huarmigunas, huahuata chuchuchic huarmigunahuas, chi urasca yapa turmintaringaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Piñaucuna guerasha maican israelgunata huanchingaunami, maicangunata japisha caru llactagunama apangaunami. Shuc mana-israel runaguna Jerusalen llactata binsisha paiguna mandana uras tucurinagama sinzhita jaitashcacuinta Jerusalenda yapa huaglichingaunami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesus rimasha catiura, Indibis quillaibihuas estrellagunaibihuas manzhanayacta ricuringami. Lamar yacu ulascuna jataricpi manzhanaita ricuringami. Chasna tucucpi tucui llactaguna ashcata manzharinaungami imasata causashun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Cieloibi ricuriccunata cuyuchishcacuintami tucunaunga. Chasna tucucpi cai munduma yapa llaqui shamungaraushcata uyasha runaguna manzharisha dismayanaungami. Sirtupacha manzharisha chucchuringaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chihuashallami ñucaga Runa Tucuc asha puyui shamuucta ricuhuangaunami. Ñáuca ushaihuan mandangaraushcata ricungaunami, ñuca tucuimandas mas yali ali sumac ashcata ricungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chasna acpi tucui chi llaquiguna pactamuna callaricpi canguna quishpina uras ña pactaringamiraun. Chimandami ahuantaichi, cushiyasha tiyaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus chimanda shuc yachachina shimita cuintara casna nisha, Higo nishca ruyahuata yuyarichi shuc ruyagunatas. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Paigunahuacpi pangaguna ashca tucucpi verano uras pactanmi nisha rimanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chicuintami canguna tucui ñuca rimashcashina cai pachai callarishcata ricushaga yachanguichimi Diospa ali mandana ña pactamungaraushcata nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cangunata sirtutami nini, Chita ricuc runaguna chara mana huañugllaita ñuca tucui chi llaquigunamanda rimashcaga pactaringami. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cai munduhuas cielohuas tucuringaunami, randi ñuca rimashca shimigunaga mana chingarisha pactaringami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Chasna acpi canguna alita yuyarisha cuirarisha causaichi. Chi punzha mana yachashca uraspi tucui cai pachaibi causac runagunahuacpi pactarimungami. Chimanda cangunaga ima camba yuyaita huaglichichichu yapacta micusha, yapacta upisha machasha, camba causaita yapacta yuyarishahuas. Can chasna causashaga chi punzha shuc tugllai japirishcacuinta tucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Canguna ima chasna tucungahua yuyarishalla chapaichi. Tucui uras Diosta mañasha causana manguichi tucui cai pactamuc turmintarinamandas quishpishca tucungahua nisha, Runa Tucuc ñuca ñaupacpi ima manzhanahuas illac shayaringahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesusca caran punzhaibimi Diosta alabana huasibi yachachiura. Caran chishi Olivos nishca urcuma rira tuta chibi tiyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tucui runaguna tutamandata Diosta alabana huasima shamunaura paita uyashun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ñáa pascua nishca israel jista punzha pactamuushcami. Dios paihua runagunata Egipto llactamanda pushamushcata yuyarisha israelguna caran huatata jatun jistata ragashcauna. Chi jistai mana putasyachishca panda micuganaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chi uras israel pagrigunahua amuguna, Diospa shimita yachachic runagunandi Jesusta huanchinata munasha imasna rashata paita pacalla japishun nisha ninaura. Chasna nishallata manzhanaura tucui runagunata, Jesusta paiguna tucui shunguhuan uyaccuna anaupi. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chi uras Satanas supaiga Judas Iscariote shungu ucuibi yaicura. Judasca chi chunga ishcai (12) muntunmanda Jesus japishca runa mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Supai yaicucpi israel pagri amugunahuagma, Diosta alabana huasita cuiraccunahuagmas itsalla risha Judas paigunahuan cuintanacura imasna Jesusta japichisha paigunama cunata. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Judas chasna nicpi israel amuguna ashcata cushiyanaura, can chasna racpiga canda pagashunmi nisha paita ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Paiguna chasna rimacpimi pai ali man nisha chimanda llucshisha rira. Chihuasha runaguna mana yachasha illaushcai Jesusta japichisha amugunama cusha nisha yuyarisha puriura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mana putasyachishca panda micuna jista punzha ña pactarira. Chi punzhaibiga oveja huahuata huanchina manaura israelguna Egiptomanda llucshishca uraspi ovejata huanchisha micushcata yuyaringahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chasna acpi Pedrotas Juandas Jesus cachara, Ñáucanchi pascua jistai micunata alichigrichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nicpi tapunaura, Maibita munangui ñucanchi chita rangahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tapunaupi Jesus nira, Uyaichi. Chi llactaibi canguna yaicushcai tupanguichimi shuc runata puruibi yacuta apaucta. Chi runataga pai yaicushca huasigama catisha ringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chi huasiyuc amuta rimanguichi, ñucanchita yachachic casna canda tapun maibitan chushac cuartoga ñuca japishca runagunahuan pascuata yuyarisha micungahua nisha tapunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Canguna chasna tapucpi pai ricuchingami jahuai shuc jatun cuartota, tucui ñucanchi minishtishcagunatas. Chibi micunata alichinguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesus rimashcahuasha Pedroga Juandi llucshisha rinaura, chibi pactasha pai rimashcacuintami tupanaura. Chasna tupasha pascua jista micunata yanunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","15","Pedroguna chasna tucuita alichishcahuasha micuna uras ña pactacpi Jesus pai japishca chunga ishcai (12) runagunandi pariu mesai tiyarisha paigunata rimara, Ñáuca chara mana turmintarina uras pactamugllaita cangunahuan cai jistataga yapa micunata munashcani. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cangunata nini cai jistaga ñuca runagunamanda huañunata Dios rauctami ricuchin. Paihua ali mandana punzha pactarinagamami cai jista micunataga ñuca mana cuti micushachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chasna nishcahuasha pillchita japisha Yaya Diosta pagrachu nisha rimara, Caita japisha caran shuc upichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cangunata nini, cunanmanda ñaupagma Diospa ali mandana punzhaguna pactarinagama cuti cai vinota cangunahuan mana upishachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chihuasha panda japisha Yaya Diosta pagrachu nira. Chi panda paquisha paigunama cusha rimara, Caiga ñuca aicha man, cangunamanda huañungaraushca aicha. Ñáucata yuyaringahua casnallata rasha causanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ñáa micushcahuasha pillchita japisha rimara, Caiga cangunamanda ñuca talina rahuai man, Dios paihua runagunahuan mushuc pactachina shimi man. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chasnagllaita ñucata japichihuangarauc runaga caillaitami tiyaun ñucahuan pariu micusha. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ñáuca Runa Tucuc acta Yaya Dios ñaupa rimashcacuintami huanchihuangauna, astahuanbas chi japichihuangarauc runaga yapa manzhanaita, ai imachari tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chasna rimacpi paigunapura pitan chi chasna rangarauc runaga nisha tapunacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chi uras Jesus japishca chunga ishcai (12) runaguna paigunapura piñanacusha cuintanacunaura pita mas yali balic an nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chita uyasha Jesus paigunata rimara, Cai pachai jatun mandaccunaga paigunahua llactagunai causaucunata sinzhita mandaisiqui manaun. Chasnallata chi mandaisiquigunaga ashcata yanapaccuna manchi nishca anaun. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Astahuanbas cangunaga mana chasna causanachanguichi nini. Cangunapura maicanbas mas yali balic ashaga shuc pishi runacuinta causaichi. Chasnallata pihuas mandac ashaga shuc yanapasha cuirac runashina yuyaihuan causaichi nini. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Rimahuai, maicanda mas balic ricurin: micungahua mesai tiyaric runachu, paita cuirac runachu. Manachu tiyaric runa mas yali balic an. Indá, paimi yali balic an. Chasnagllaita ñucaga cangunata cuiracshinalla tiyauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Cangunami runaguna ñucata piñaushcaibi ñucahuan tiyasha mana saquiranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chasnamandami ñuca Yaya ñucama mandana amu ushaita cushcashina ñucahuas cangunataga mandana ushaitas cushami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chi urasca lugarta cushami ñuca mandaushcai canguna ñucahuan pariu micungahua upingahuas. Chasnallata chi uras cangunata amu tiyarinagunaibi tiyachishami canguna Israelmanda chunga ishcai (12) mirai muntungunata mandangahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chihuasha Jesus Pedrota nira, Uyahuai Simon, cunanga Satanas supaimi Diosta rugara muyugunata shushusha chucchuchishcacuinta cangunata camasha ñucata jichuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Chasna agllaita ñuca canmanda Yaya Diosta tapushcani, can ñucata quirisha ama jichurichun nisha Simon. Can ñucata cuti catisha camba quiric huauquigunata ahuantachisha sinzhiyachingui. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chasna nicpi Pedro Jesusta rimara, Canda carcelbi tapanaupiga ñucahuas canhuan pariu taparisha señor. Canda huanchicpiga ñucahuas canhuan pariu huañugrishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chasna rimacpi Jesus nira, Canda rimani Pedro, cunan tutami gallo chara mana cantagllaita can quimsa (3) cutin ñucamanda llullangamiraungui paita mana ricsinichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chihuasha Jesus paigunata tapura, Ñáuca cangunata cullqui illac, shigra illac, shuc botas illac cachashca uras imahuas canguna pishirachu. Tapucpi ninaura, Mana imahuas pishirachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chasna rimacpi Jesus nira, Cunanga maicanguna cullquita charishaga apaichi, shigratas apaichi. Maicanbas espada saulita mana charishaga camba churarinata randichigri shucta randingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cangunata rimani Diospa shimita quillcashcashina ñucahuacpi pactarina man casnami nisha: Juchayuc runagunahuan churashca ara. Cunanga ñucamanda quillcashcacuinta pactarinmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chasna rimacpi paita rimanaura, Ricui señor, caibimi ishcai (2) espada sauliguna anaun. Rimacpi chasnalla saquichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chimanda llucshisha risha paihua causana tunu chasna acpi Olivos nishca urcuma rira pai japishcagunandi. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chibi pactasha paigunata rimara, Canguna Dioshuan cuintasha causaichi jucha shamucpi ima binsitucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chihuasha chinigma, rumita tucsina tupugama, paigunamanda anchurisha cungurisha Diosta mañausha tapura casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Can munashaga cai jayacta upinashina sinzhi turmintarinata ñucamanda anchuchihuai Yaya. Astahuanbas ama ñuca munashcata rashca achun randi can munashcashinata rai nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chasna rimacpi jahuapachamanda shuc angel shamusha paita yanapasha sinzhiyachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus yapa turmintariusha tucui shunguhuan mas sinzhita mañara. Chasna mañaupi paihua jumbi rahuaishina allpama ashcata talirira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chasna mañashcahuasha jatarisha pai japishcagunahuagma bulltiasha paigunata ricura llaquirisha puñuucunata. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ricusha tapura, Imangahuata puñuunguichi. Niccharicshina Dioshuan cuintasha causaichi juchata rana yuyai shamucpi ima tintaitucungahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus rimaushcai pai japishca chunga ishcai (12) runamanda shucca Judas Iscariote, ashca runagunata apamusha pactamunaura. Judas caillayamusha Jesusta saludasha muctira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chasna racpi Jesus paita tapura, Runa Tucuc acta shuc muctishcahuanzhu ñucata japichihuangui Judas. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chasna tucucpi Jesushuan puriucuna paita imata rangaraushcata yachasha tapunaura, Ñáucanchi picashunzhu señor. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chasna nishallami paigunapuramanda shucca israel pagriguna amuta cuirac runata picasha paihua ali parti rinrita chiú pitira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus chita ricusha, Saquichi, ima picanguichichu nira. Chihuasha chi picashca cuscaibi llangasha alichira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chi shamuccunaga israel pagri amugunas, Diosta alabana huasita cuiraccunas, israelgunata mandauc runagunahuas Jesusta japingahua shamunaura. Shamusha pactacpi Jesus paigunata tapura, Shuhuac runachani canguna cuchillugunahuan caspigunahuanbas ñucata japingahua shamungahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ñáuca caran punzhami Diosta alabana huasibi cangunahuan pariu tiyauranimi, chi uras mana japihuaranguichichu. Astahuanbas ansaibishina mandauc Satanaspa munaiga cunan pactarinmi, chimanda canguna cunanga casna japic shamushcanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chasna rimashcahuasha Jesusta japisha israel pagrigunata mandac amuhua huasima apanaura. Apacpi Pedroga paiguna huashalla carumanda catiura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chi huasi canzhaibi maican runagunaga ninata japichisha tiyarinaupi Pedrohuas paigunahuan pariu tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pai nina mayanbi tiyautami shuc chibi tarabac huarmi paita ricusha rimara, Cai runahuas chasnallata Jesushuan puriuc mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Randi, Paita mana ricsinichu nisha chi huarmita cutipara. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Unanighuallai shucca paita ricusha nira, Cambas paihuan pariu puriuc marangui. Rimacpi Pedro randi piñarisha rimara, Mana. Mana ñucachani nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ñáalla shuc ura pasashcahuasha shuc runahuas rimara, Sirtumi cai runaga Galileamanda asha Jesushuan puric ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro randi paita rimara, Can rimashcataga mana yachanichu, llulla man. Pedro chara rimaushcai cungaimanda shuc gallo cantara. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chi ratullai Señor Jesus huashama bulltiarisha Pedrota ricura. Ricucpi paita rimashcata yuyarira imasna acpita, cunan tuta gallo chara mana cantagllaitachu can quimsa (3) cutin ñucata mana ricsinichu nisha llullangaraungui nisha Jesus rimashcata yuyarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chita yuyarisha Pedro chimanda canzhama llucshisha risha yapa sinzhita huacara. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesusta japic runaguna paita pugllasha asishami macanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Paihua ñahuita llachapahuan huatasha paita macasha tapunaura, Pita canda macaun, can yachashaga rimai ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chasnallata yapa jiridsata camisha mana ali shimigunatas rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ñáa punzhayaupimi israelgunata mandac rucu runagunas, chi israel pagrigunata mandaccunas, Diospa shimita yachachiccunahuas tandarimunaura. Chi mandacpuralla ñaupagma Jesustaga apanaupi tapunaura, ");
INSERT INTO qvzNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Canga Dios cachamushca quishpichic Cristo nishca runa ashaga ñucanchita rimai. Mandacpi Jesus paigunata nira, Ñáuca cangunata rimacpihuas mana quirihuanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ñáuca cangunata tapucpiga mana rimahuanguichichu, mana cacharihuanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ñáucaga Runa Tucuc ashcamandami cunanmanda ñaupagma jatun ushaiyuc Diospa ali maqui partibi tiyarisha mandangarauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesus chasna rimacpi paiguna tapunaura, Chasna acpi sirtuchu Diospa churi angui. Paiguna tapucpi, Indá nira, canguna rimashcashina mani nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chita uyasha rimanaura, Shuc rimac runata mana minishtinchichu tapungahua. Ñáucanchillata quiquin rinrihuan basta uyaranchimi pai rimashcataga. Ñáa pai quiquin shimimandallata caudsayachishca tucunga nisha rimanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chasna nishami tucui chi israelgunata mandac runagunandi jatarishaga romano llactata mandac amu Pilatohuagma Jesusta apasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chibi pactasha Jesusta caudsayachingahua callarinaura casna nisha, Ñáucanchi llactata cai runaga llullasha huaglichiuctami tuparanchi. Chasnallata gubirnuma pagana cullquita mana paganachan nisha runagunata yachachiuctas tuparanchi. Chasnallata jatun amu quishpichic Cristo mani nisha puriun. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chita uyasha Pilato tapura, Israel runagunata mandac amuchangui. Tapucpi Jesus rimara, Indá, can chasna rimashcashina mani. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chasna nicpi israel pagrigunata mandaucunatas, chibi tiyau runagunatas Pilato rimara, Cai runa ima mana ali rashcatas mana tupanichu paita huanchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Paiguna randi piñasha sinzhita rimanaura, Paimi tucui israel llactagunaibi chasna yachachiusha runagunata turbachisha puriun. Galilea provinciai callarira, chimanda yachachisha yachachisha cai llactagama ña pactamushca nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Galilea nishcata uyasha amu Pilato paigunata tapura, Paiga Galileamanda runachan. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paiguna indá nishcata uyasha Jesusta cachara Herodespagma pai Galilea gubirnadur ashcamanda. Chi jista uraspi Herodes Jerusalenbi tiyaushca ara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pai unaimanda Jesusta ricunata munara. Paimanda ashca shimita uyashca asha Jesus shuc jatun ushaihuan pihuas mana raushcata ricunata munara. Chimandami Jesusta cunan ricusha yapa cushiyara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","10","Chasna ashami Jesusta apamucpi ashca cutin tapuura. Chasnallata apau runaguna, chi israel pagrigunata mandaccunas, Diospa shimita yachachiccunahuas, Jesus mana alita rasha puriu mashca nisha yapa rimasha caudsayachinaura. Chasna agllaita Jesusca mana shuc shimillas rimarachu, chunlla uyasha shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chasna acpi amu Herodes, paihua sundalugunandi Jesusta asisha yapa mana alita rimangahua callarinaura. Paita pugllangahua amucuinta ricuringahua balic llachapatas churachisha mandac amu Pilatohuagma cuti cachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodeshuan Pilatohuan amupura ñaupa piñanacusha causaccuna anaura. Randi chi punzha paigunapura amigo tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesusta cuti apamucpi Pilato cayara tucui israel pagrigunata mandaucunatas, chi shuc mandaucunatas, tucui runagunatahuas paihuacpi tandaringahua cayara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tandarimucpi paigunata rimara, Cai runa tucui canguna llactagunata huaglichisha puriunmi nisha ñucahuagma apamuranguichi. Canguna ñaupacpi tucui canguna rimashcamanda paita ñaupa alita tapushcani. Astahuanbas paita caudsayachingahuaca mana imatahuas tuparanichu. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes chasnallata mana imatas tupasha ñucamallata cuti tigrachimura nira. Ricuichi. Cai runaga huanchitucungahuaca imatas mana alita rashcachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chasna acpi cunanga paita libachishalla cacharisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ñáa caran huatai cai jista uras chi israel runaguna paita llaquihuanauchun nishalla Pilato shuc taripashca runata cacharigara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jesusta cacharishami nicpi tucui runaguna shuc shimillahuan caparingahua callarinaura, Cai runata jichui, Barabasta cachari. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ñáa Barabas nishca runaga chi llacta gubirnuta callpachishun nisha guera aushcaibi shuc runata huanchishcamanda carcelbi tapashca aura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Amu Pilatoga Jesusta cacharinata munashami shuc cutin mas chi runagunata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Astahuanbas paiguna mas sinzhita caparinaura, Paitaga cruspi huanchi, cruspi huanchi nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ñáa quimsa (3) cutin Pilato paigunata tapura, Cai runa imatata rashcaya. Ñáuca paihuacpi imatahuas mana tuparanichu paita huanchingahuaca, chasna acpi paita libachishalla cacharingarauni nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Chasna rimacpi paiguna, Cruspi paita huanchi nisha mas sinzhita caparinaura. Puchucaibi runaguna binsinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chasna tucucpi Pilato paiguna munashcashina Jesusta huanchinauchun nisha saquira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chasnallata paiguna munashca runata, gubirnuta anchuchishun nisha huanchic Barabas nishcataga llucshichingahua cacharira. Jesusta randi paiguna munashcata rangahua paigunama cusha saquira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chasna tucucpi Jesusta huanchingahua apasha riushcaibi Cirene llactamanda Simon nishca runa chagramanda shamuucta sundaluguna japisha Jesuspa crusta marcachinaura huashamanda apanacusha richun nisha mandanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Chasnallata yapa ashca runagunas Jesusta catinaura, llaquirisha huacau huarmigunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus huashama ricusha paigunata rimara, Jerusalen huarmiguna, ñucamanda ima huacaichichu nira, astahuanbas canguna quiquin turmintarinamandas, canguna huahuaguna turmintarinamandahuas huacana anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chihuasha yapa llaqui shamungami. Chi llaqui pactamuna uraspi runaguna rimanaungami casna nisha, huahuata mana tupac huarmiguna cushi anaunmi, ima uras mana huicsayac huarmigunas, mana chuchuchic huarmigunahuas cushi anaunmi nisha rimangauna. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chi sinzhi llaqui aupi runaguna urcuma caparingauna, jatun urcuguna ñucanchi jahuaibi urmaichi, ichilla urcuguna ñucanchita tapacta urmaichi nisha caparinaunga. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cangunata nini, Yuyarichi. Chara huiñau ruyatacuinta ñuca mana juchayuc runa acta casna rahuashaga mas llaquichinaungami chaquishca ruyacuinta yapa juchayuccunataga nisha Jesus paigunata rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Romano sundaluguna ishcai (2) yapa mana alita rauc caudsayachishca runagunata apanaura Jesushuan pariu cruspi huanchingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Umatullu nishca urcuma pactasha Jesusta cruspi quilabanaura huanchingahua, chasnallata chi ishcai juchayuc runagunata, shucta Jesuspa ali maqui partima, shucta paihua lluqui maqui partima quilabanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chasna racpi Jesusca crus jahuaibi ausha casna nira, Cai runaguna mana yachashcamandami casna ranaun, paigunatas perdunapangui Yaya nira. Chi sundalugunaga Jesuspa churarina llachapagunata chaupichinaura, chasnallata pishi paihua capata apangaraun nisha surtita rashami camanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tucui runaguna chibi shayarisha ricuunaura. Israelgunata mandaucuna randi Jesusta mana balichisha casna paimanda rimanacunaura, Pai runagunata quishpichic mani nisha rimagara. Chasna acpi paiga Dios cachashca quishpichic Cristo nishca runa sirtu ashaga amullata quishpiri nisha caparisha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sundalugunahuas paita asisha pugllanaura. Caillayamusha jayac upinata ricuchisha rimanaura, ");
INSERT INTO qvzNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Can israelgunata jatun mandac amu ashaga canllata quishpiri nisha pugllasha asinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chi crus jahuaibi quimsa (3) tunu shimita quillcashca ara, griego shimibi, latin shimibis, israelguna rimashca hebreo shimibihuas quillcashca ara CAIGA ISRAELGUNAHUA AMU MAN nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jesushuan pariu cruspi quilabashca ishcai (2) mana alita rac runagunamanda shucca Jesusta mana balichisha pugllasha tapura, Manachu Dios cachashca runa angui. Sirtu chasna ashaga canllata quishpiri, ñucanchitahuas quishpichi nisha asira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chi shucca randi paita sinzhita rimara, Can paicuintallata huañuusha llaquichitucushcamanda manachu Diosta manzhaungui. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ñáucanchiga mana ali rashcamanda taripaitucushcanchi. Pai randiga mana ima jiridsatahuas rashcachu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chihuasha Jesusta rimara, Can amu tucushcai ñucamanda yuyarihuangui Jesus. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chasna rimacpi Jesus paita nira, Sirtuta canda nini cunan punzhallata jahuaibi ñucahuan pariumi cushi tiyangui nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ñáa dudsimanda indi ansayacpi tucui allpa ansa tucura quimsa urascama. Chi uraspi Diosta alabana huasi ucui huarcushca llachapa chaupi chaupibi sháca liquirira jahuamanda allpama pasacta liquirira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesusca sinzhi shimihuan caparira, Yaya ñuca almataga camba maquibi saquini. Chasna nishalla samai pitirisha huañura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chi romano sundalugunata mandac runaga tucuita ricusha Diosta alabangahua callarira, Sirtumi cai runaga ima mana alitas rac ashca nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tucui Jesusta ricungahua shamuc runaguna ricushcahuasha yapa llaquirisha pichuta huactarisha huasima bulltianaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Paita alita ricsic runagunaga, Galileamanda paita yanapasha catiu huarmigunahuas carumanda shayarisha tucuita ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Chasnallata chibi tiyaura Jose nishca runa, Judea provincia Arimatea nishca llactamanda ara. Paiga Diosta cadsugasha alita puric runa mara. Chasnallata israelgunata mandaucunamanda mara. Chasna agllaita chi muntunguna Jesusta huanchingahua nisha munagllaita Josega mana munarachu. Paiga Diospa ali mandana shamungaraushcata chapauc runa mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chasna asha amu Pilatohuagma risha Jesuspa aichata pambangahua tapura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","54","Chi punzha jatun jistata alichina punzha ara, indi yaicuna uras israelguna samana punzha tucuna mara. Chasna acpi Jose crusmanda Jesuspa aichata uraicuchisha ali llachapahuan pillusha shuc urcu juctu ucuibi pambara. Chi juctuibi mana pitahuas pambashcachara. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chi Galileamanda Jesusta yanapasha catiu huarmiguna Joseta catisha risha Jesuspa aichata churashcata ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ricusha chimanda huasima bulltiamusha, paiguna yachaita rasha asnac muyugunatas, asnac asaitigunatahuas alichinaura Jesuspa aichaibi churangahua nisha. Chihuasha samana punzha acpi paiguna samanaura Dios mandashcashina. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo punzha tutapagaricta chi huarmigunaga alichishca asnaccunata apasha pambashca juctuma rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chibi pactasha juctu pungüi tapashca jatun rumita anchuchishcata ricunaura, ");
INSERT INTO qvzNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","astahuanbas juctu ucuma yaicusha Jesuspa aichata mana tupanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chita mana tupasha imata tucushca nisha manzharisha shayaushcai cungaimanda paiguna mayanbi ishcai (2) runa shayaric shamunaura. Chigunaga yapa ruyac chiujlla churarishca manaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chi huarmiguna paigunata ricusha yapa manzharisha allpama cumuricpi chi cariguna rimanaura, Imangahuata causauctaga pambashcaibi mascangahua shamunguichi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Paiga ña causarishca, caibi illanmi. Chara Galilea llactai aushallata ima tucungaraushcata cangunata yachachishcataga cungariranguichichu. Yuyarichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pai cangunata yachachiusha rimara, ñucata juchayuc runagunahua maquibi cuitucungarauni, chasnallata cruspi quilabasha huanchihuangaraunguna. Chasnallata cangunatas yachachira quimsa (3) punzhaibi huañushcamanda cuti causaringarauni nishami rimara. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Paiguna chasna nicpi huarmiguna cuti yuyarinaura Jesus chasna rimashcata. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chasna cuti yuyarisha paita pambashca juctumanda bulltiasha Jesus japishca chunga shuc (11) runagunamas shuccunamas tucui chibi pasashcata cuintangahua rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chi rimac huarmiguna anaura Maria Magdalena, Juana, Santiagohua mama Maria, chi shuc paigunahuan auc huarmigunahuas chimandas cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chasna cuintagrinaupi Jesus japishca runaguna yangami ninguichi nisha mana quirinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Chi rimashcata mana quirishallata Pedro jatarisha Jesusta pambashca juctuma callpara ricungahua. Pactasha cumurisha ucuma ricugrisha pillushca llachapalla siriucta ricura. Chillata ricusha imata tucura nisha huasima bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chi punzhallata Jesusta quiriccunamanda ishcaipura (2) Emaus nishca llactama rinaura. Emaus llactaga Jerusalenmanda chaupi punzha purina tupu mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","Paiguna riusha chi punzhagunai ima tucushcata cuintausha rinaura. Puriushcai Jesusllata paigunama caillayamusha paigunahuan pariu puringahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Astahuanbas paigunahua ñahuigunaga puyushina tucucpi pai pi actas mana ricsinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chasna acpi Jesus paigunata tapura, Cangunapura casna puriusha imamandata cuintanacunguichi. Tapucpi paiguna shayarinaura yapa llaquirisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Shucca Cleofas nishca ac rimara, Cai punzhagunaibi Jerusalen llactai tucui imasna pasashcata canga manachu uyaranguiya. Carumanda shamuc asha chariya canlla mana yachangui nirami. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ima llaquitara nisha tapura. Tapucpi paiguna ninaura, Nazaret llactamanda Jesusca Dios rimashcata pasachic runa mashca. Paiga Diospa ñaupacpi tucui runaguna ñaupacpias yapa ushaihuan aligunata rashcami, yapa yuyaihuan yachachishcami. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Paiga tucui ñucanchi israel llactata lugaryachingahua shamushca mara nisha yuyariranchi. Chasnagllaita ñucanchi pagrigunahua amuguna, ñucanchita mandaccunahuas paita japisha romanogunama cunaura cruspi huanchinauchun nisha. Chasna cucpi paita cruspi quilabasha huanchinaura. Ñáa cunan punzhahuan quimsa (3) punzha pactariunmi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Chasnallata cunanga ñucanchi muntunmanda maican huarmiguna ñucanchita manzhachinaura. Paiguna cunan tutapagaricta Jesusta pambashca juctuma rinaushca ");
INSERT INTO qvzNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","randi Jesuspa aichata mana tupanaushcachu. Chimanda bulltiasha rimanaura angelgunata ricuranchi nisha, chi angelgunaga Jesus causaunmi nisha rimac shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chasna nishcata uyasha maican ñucanchihuan tiyac runaguna chi pambashca juctuma risha huarmiguna rimashcacuintallata tupanaushca. Astahuanbas Jesus quiquinda mana tupanaurachu nisha chiguna cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chi ishcai (2) runa cuintashcata uyasha Jesus paigunata nira, Canguna yuyai illacshina manguichi. Dios rimashcata ñaupa pasachiccuna quillcasha tucui yachachishcagunata imahuata mana tucui shunguhuan uctalla quirishcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Quishpichic Cristo chara jatun mandac amu tucungahua manachu ñaupata turmintarina ara nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesus chasnallata Diospa shimibi tucui Cristomanda quillcashcagunata rimasha chi ishcai runata yachachira. Paimanda Moises quillcashcatas, tucui Dios rimashcata ñaupa pasachiccuna quillcashcagunatahuas chi ishcai runata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yachachisha puricpi paiguna riushca llactama pactanaura. Pactasha Jesusca mas caruma ringaraucshina rara. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chasna riupi paiguna paita saquichingahua munasha ninaura, Ñáucanchihuan randi saquiri, ricui cunan yapa tutayaunmi nisha jarcanaura. Chasna nicpi huasi ucuma yaicusha paigunahuan saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Paiguna ña mesai tiyariushcai Jesus panda japisha Diosta pagrachu nisha, paquisha paigunatas cura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chi urasllaita paiguna ñahui pascarishcacuinta tucucpi Jesus acta ricsinaura. Chasna acpi paiguna ñaupagmandallata cungaimanda chingarira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chasna tucucpi paigunapura cuintanacungahua callarinaura, Ñáambibi shamushcai pai ñucanchita cuintausha Diospa shimita yachachiushcai manachu ñucanchi shungu ucuibi yapa ashcata cushiyaranchi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chasna rimanacusha chi urasllata jatarisha Jerusalenmallata bulltianaura. Chi Jesus japishca chunga shuc (11) runaguna, maican Jesushuan puriucunandi pariulla tandarisha tiyaushcama pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pactacpi chibi tiyaucuna rimanaura, Señor Jesus sirtu causarishcami, Simon Pedromasmi ricurishca mara. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chasna rimacpi chi ishcai pactamuc runaguna Jesus ñambibi tucui cuintashcata chasnallata pai panda paquiushcai ricsiranchi nisha cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Paiguna chita cuintanacushcaibi Jesusca paiguna ñaupacpi cungaimanda ricurimura. Saludasha rimara, Cushi ganas causanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rimacpi paigunaga shuc aya man nisha yapa manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Astahuanbas Jesus tapura, Imangahuata manzharinguichi, imaraicuta ñucata aya man nisha yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñáuca maquigunatas chaquigunatas ricuichi. Ñáucallata mani. Sirtu ñuca mana aya ashcata yachangahuaca ñucata llangasha camahuaichi. Ayaga mana charinzhu aichata tullutas ñuca charishcacuintaga nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chasna nisha paihua maquigunatas chaquigunatas paigunama ricuchira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Chasna ricuchicpihuas paigunaga yapa cushiyashallata chara manzharisha mana quirinaurachu. Chasna acpi Jesus tapura, Ima micunas caibi tiyanzhu ñuca micungahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tapucpi yacu aicha chaquichishcata paima cunaura, ansa sacha mishquitahuas. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Paita cucpi japisha paiguna ñaupacpi micura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Micushcahuasha paigunata rimara, Ñáuca cangunahuan tiyausha chara mana huañushcallaita cangunata rimarani, tucui Diospa shimibi ñucamanda quillcashcaguna pactarina mara nisha. Moises quillcashcaibi, Dios rimashcata ñaupa pasachiccuna quillcashca shimigunaibis, Salmos nishca libroibihuas, tucui ñucamanda quillcashcagunaga pactarina mara. Tucui Diospa shimibi rimashcashinalla ña pactarishcami nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chasna nishami paigunama yuyaita cura paiguna Diospa shimita alita yuyarisha intindingahua. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Chihuasha paigunata yachachisha nira, Diospa shimibi casna ñaupa quillcashca sirin, Quishpichic Cristoga turmintachisha huanchitucuna man, chasna agllaita quimsa (3) punzhaibi huañushcamanda causaringamiraun. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Chihuashaga Jerusalen llactamanda callarisha tucui llactagunama yachachiccunata cachangami casna nisha rimagrichun: Juchata rashcamanda llaquirisha saquisha nisha Yaya Diospagma shamuichi. Chasna racpiga Yaya Diosmi cangunahua juchagunataga anchuchingaraun nisha rimagrichun. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Chitaga canguna tucui ñucamanda Diospa shimibi pactarishcagunata ricushca ashami rimagriccuna anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ricuichi, ñuca Yayaga cangunama ashca ushaita cushami nishcataga jahuapachamanda ñuca cangunama cachamushami canguna ali sinzhi tucungahua. Canguna chi ushaita charinagama Jerusalen llactallaita tiyanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chihuashami Jerusalenmanda Betania llacta mayanbi Jesus paigunata pushara. Chibi pactasha paihua maquigunata jahuama rasha paigunamanda Yaya Diosta tapura paigunata bindisiasha cuirasha yanapachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tapuushcaibi paigunamanda anchurisha jahuapachama apaitucura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Paiguna Jesusta alabashcahuashami yapa cushiyasha Jerusalenma bulltianaura. ");
INSERT INTO qvzNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chi llactaibi tiyausha Diosta alabana huasibi tucui uras Yaya Diosta alabasha tiyac anaura.");
INSERT INTO qvzNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Callari uras imahuas chara mana tiyashcallaita, Jesucristoga Causac Shimi nishca tiyagashca. Ñáa Causac Shimi Dioshuan pariu causac ashca, paillatami Dios ashca. Paillatami Diospa Shimi nishcahuas an Yaya Dios imasna acta ñucanchita ricuchishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Chasna callari uras imatahuas chara mana rashcallaitami ña paihua yayahuan pariu tiyac aushca. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paimandami tucui tiyangaraushcaguna callarishcauna Yaya Dios rashcagunaga anaushca. Cai Shimi illashca acpiga mana imas raitucunmachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tucui rashcagunaga cai Shimimandami causaita charinaura, pai quiquin causaimi punzhashina runagunataga Yaya Dios imasna acta ricuchira. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cai punzhami ansa ucuibi punzhayachishcashina juchaibi causac runagunataga tucuita pagllai ricuchiun. Chi ansa tutaicuinta puriu runagunaga mana punzhata munashallata binsinata mana ushashcaunachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Shuc punzha Juan nishca runataga Dios cachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Paiga cai punzhayachigmanda sirtuta rimac shamura. Cai mundui auc runagunata yachachiura tucui runaguna pai rimashcata uyasha Jesucristo punzha acta quirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanga mana chi punzhayachicchashca, randi cai punzhayachigmandami yachachingahua cachashca runa mara. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ñáa Causac Shimi nishcaga cai pachama shamura punzhayachishcashina tucui runaguna Diosta yuyarisha quirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cai Diospa Shimi agmi munduibi aura. Yaya Dios cai munduta paihuanllatami pariu rashca agllaitami, cai mundui auc runagunaga mana ricsinaushcachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Paihua quiquin runagunama shamugllaita mana llaquinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Randi paita llaquisha quiriccunataga ushaita cura quiquin Diospa runaguna nishca tucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Paigunaga mana runa miraimandachu, mana runa munaimandachushina tucunaun, randi Diospa ushaimandallami paihua runaguna tucunaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cai Causac Shimiga aichayuc tucuc shamusha ñucanchihuan pariu causaura. Paiga yapa llaquic, sirtutas rimac ara. Diospa shuglla churi actas, paishinallata ushaiyuc sumac actahuas ricushcanchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paimanda Juanga rimara casna, Paiga ñuca cangunata rimashca man. Ñáucahuasha shamucca ñucamandas mas yali balic man ñaupamandapacha causac ashcaraicu nishcani. Chasna nisha paimandami cangunataga cuintac arani. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tucui imatas pai charishami ñucanchita yapa llaquishami imatas cun. Chasna acpimi tucui tunu aligunata catin catin ashcata japiunchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yaya Diosca pai mandashcagunata ñaupa causac Moisesma cucpi ñucanchima pasachira. Randi Dios ñucanchita llaquiushcataga chasnallata sirtu shimitahuas Jesucristo ricuchun nisha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana pihuas Yaya Diostaga ima uraspas ricushcachu, randi paihuan pariu causac sapalla churillata ñucanchitaga ricsichishcami. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ñáa shuc punzha Juanda can pitangui nisha tapugringahua, israel amugunaga cachanaura maican israel pagrigunatas, chasnallata paigunata yanapac Leví muntunmanda runagunatas Jerusalenmanda Juanbagma cachanaura tapunauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tapucpi Juan pagllai rimara, Ñáucaga mana quishpichic Cristochani. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Cutillata tapunaura, Mana chasna ashaga pitangui, Dios rimashcata pasachic ñaupa causac Elias nishca runachangui nicpi Juan cutipara mana paichani. Mas tapusha ninaura, Dios cachangaraushca pai rimashcata pasachic runa changui nisha tapucpi mana paihuaschani nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nicpi cuti tapunaura, Chasna ashaga pitanguiya. Imatata nigrishun ñucanchitas cachac fariseogunamaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chasna nicpi Juanga Dios rimashcata pasachic runa Isaias rimashca shimitacuintallata paigunata nira: Ñáucaga chaquishca pambaibi casna caparisha camachini: Dios cachashca quishpichic runaraicu shuc cusca ñambita rashcacuinta canguna causaita alichirichi nisha rimac runa ani. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ñáa maican tapuccunaga fariseo cachashca runaguna manaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Paigunaga cutillata tapunaura, Can mana quishpichic Cristo ashaga, mana ñaupa causac Elias ashaga, mana Dios rimashcata pasachic runa ashaga, imahuata bautisaungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan randi cutipara, Yacullahuanmi ñucaga bautisauni, randi canguna ucullaitami aun shuc canguna mana ricsishca runa. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Paiga ñucahuasha shamuc ashallatami mas balicchani tucunga. Ñáucaga astahuan paihua zapatosta pascangallahuas mas ucui rauc runa ani nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ñáa chasna tapuc shamunaura Jordan yacu chimbai, Betania nishca llactai Juan bautisaushca partibi. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cayandi punzha Juanbagma Jesus caillayamuuta ricusha ricuichi nira, Caimi Dios ovejatashina cachashca runa an, paimi tucui juchagunatas pichac an. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paimandami cangunata cuintasha casna nirani, Ñáucahuasha shamucca ñucamandas mas balic man pai ñaupamandapacha causac ashcaraicu. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ñáucahuas mana yacharanichu maican actahuas, chasna agllaita yacuhuan bautisashalla purini israel runaguna paita ricsinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan chasnallata rimarami, Ricushcanimi Diospa Samaita jahuapachamanda shuc palomashina uraicumusha paihua jahuai tiyaricta. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ñáuca chara mana yacharanichu maican actas. Randi yacuhuan bautisachun nisha ñucata cachac Diosmi ñaupata paimanda nihuara, ñuca Samai uraicusha shuc runa jahuaibi tiyaricta ricunguimi, paimanga runagunata ñuca Samaihuan bautisangarauc runaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ñáucami chitaga ña ricushcani, chiraicumi cangunata nini, paimi sirtupacha Diospa churi an nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cayandi punzha Juan chillaita aura ishcai (2) paita catiu runagunahuan. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus pasauta ricusha paigunata nira, Ricuichi, paimi Dios cachamushca quishpichiccuna an. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chasna chi ishcandi Juanda catic runagunami pai rimashcata uyasha Jesusta catinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chasna catisha rinaupi Jesus bulltiarisha ricusha tapura, Imatata mascaunguichi nicpi paiguna ninaura, Maibita causangui rabí. (Hebreo shimibi “rabí” nishaga runa shimibi yachachic ninmi). ");
INSERT INTO qvzNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus cutipasha ricucshamuichi nicpi risha pai tiyashcata ricusha chi punzha paihuan cainanaura, las cuatro tupugama. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chi ishcandimi Jesusmanda Juan rimashcata uyasha Jesusta caticpuramanda shucca arami Simon Pedrohua huauqui Andres nishca. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andresca chara mana imatas rashallata paihua huauqui Simonda mascasha tupashcaibi nira, Mesiasta, Dios cachashca quishpichic Cristotami tupashcanchi. (Paiguna shimibi “Mesias” nisha Cristo ninmi). ");
INSERT INTO qvzNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chihuasha Andres paihua huauqui Simonda Jesuspagma apara. Pactacpi Jesus Simonda ricusha nira, Canga Juanba churi Simon mangui, randi cunanga camba shuti angami Cefas nishca, (“Cefas” nisha griego shimibi Pedro nin, chitaga runa shimibi rumi nin). ");
INSERT INTO qvzNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ñáa cayandi punzha Jesus Galilea nishca partima rinata yuyarira. Risha Felipeta tupasha paita, ñucata catihuai nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Cai Felipega Betsaida nishca llactamanda mara, chasnallata Andrespas, Pedrondi chimandallata manaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipega Natanaelta mascasha tupagrisha casnami cuintara, Uyai, Moises mandashca shimibi quillcashca runataga tuparanchimi, Dios rimashcata pasachic runagunahuas paimandami rimanaushca. Paiga Nazaret llactamanda Josehua churi Jesus man. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Caita uyasha Natanael nira, Imasata Nazaretmandaga angaya. Nazaretmanda imallahuas ali llucshimucca mana tiyanzhu nicpi Felipe paita cutipara, Canllata ricucshamui nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael caillayamuuta ricusha Jesus paimanda rimara, Caibimi shamuun shuc sirtupacha israel runa, paiga mana llullac runachan. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jesus chasna nicpi Natanael tapura, Imasata can ñucata ricsihuangui. Tapucpi Jesus cutipara, Felipe chara mana cuintagllaita candaga ricurani, can higo nishca ruya sapibi aushcaibi. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chita uyasha Natanael cutipasha nira, Sirtupacha canmi Diospa churiga angui señor, canmi israel llactata mandac gubirnuga angui. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus randi paita nira, Higo ruya sapibi shayaushcallaitami canda ricuranimi nicpichu quirihuangui. Caimandahuas mas jatun rashcagunatahuasmi ricungaraungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chasnallata Jesus nirami, Sirtupacha cangunata nini ricunguichimi jahuapacha pascarishcata, Diospa angelgunatahuas Runa Tucucpa jahuaibi sicasha uraicusha raucunata ricuhuangaraunguichimi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ishcai (2) punzha pasashcahuasha shuc cadsarana jista tiyara Galilea partibi Caná nishca llactaibi. Jesuspa mamahuas chi jistaibi aura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chasnallata Jesustahuas pai japishca runagunandi cayashca asha chi cadsarana jistamaga rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ñáa paiguna chi jistaibi upiushca vino tucurishcata ricusha Jesuspa mama paita rimagrira, Cadsaraushcai upiushca vino tucurishcami. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nicpi rimara, Imahuata caitaga rimahuangui mama. Ñáuca Yaya mandashcagunata tarabangahua callarina uras chara mana pactarishcachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chasna rimagllaita Jesuspa mama chi jistaibi yanapaucunata runagunata nira, Tucui Jesus rimashcata pactachichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ñáa chi huasibi charinaura sucta (6) rumimanda rashca jatun tinajagunata. Chi tinajagunaibi yacuta charic anaura israelguna maillaringahua Diospa ñaupacpi caudsa illac ricuringahua nisha. Caran tinajaibi ishcai, quimsa chunga (20 u 30) galón tupu pactac ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ñáa Jesus chi jistaibi yanapauc runagunata nira, Yacuta jundachichi cai tinajagunaibi. Nicpi chi runaguna shimigama jundactami yacuta jundachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chihuasha Jesus paigunata nira, Cunanga ashillata huishisha cai cadsarachiu amuma apaichi nicpi chi runaguna apasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Apacpi chi yanga yacumanda rashca vinota amu camara, randi mana yacharachu maimanda apamushcata, randi chi yanapauc runagunallami yachanaura paigunallata tinajagunaibi yacuta jundachishcaraicu. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Chita camashcahuasha chi amuga cadsarauc runata cayasha tapusha nira, Tucui jistaibimi pundaga mas ali vinota upichic anaun, ña runaguna ashcata upishcaibi puchucaimami chamuctaga upichic anaun. Imashina rashata cunangama alitaga huacaichisha charishcangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Caimi Galilea partibi ac Caná nishca llactaibi Jesus pihuas mana raushcata rasha punda ricuchishcaga ara Yaya Diospa ushaita charishcata ricuchingahua. Chita ricushami pai japishca runagunaga paita mas quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chasna pasashcahuasha Jesus rira Capernaun nishca llactama, paihua mamandi, paihua huauquigunandi, chasnallata pai japishca runagunandi pariu. Chi llactai saquirinaura shuc semana tuputa. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua nishca israel runagunahua jista ña pactarimuupi Jesus Jerusalenma rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Diosta alabana huasi canzhallai pactasha muyucta aucunata tupara huagratas ovejatas palumagunatas randichic runagunatas, chasnallata cullquita cambiausha mesagunai tiyarisha tarabaucunatas ricura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chita ricusha Jesus shuc huascata mascasha asutinata rasha tucui chibi randichiu runagunata Diosta alabana huasi pungumanda callpachira paiguna huagragunandi ovejagunandi. Cullquigunatas sáa, sáa tucsisha mesagunatahuas tangasha urmachira. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Palomata randichiucunataga nirami, Canguna randichiushcata anchuchichi caimanda. Shuc randichina huasitacuinta ama raichichu ñuca Yayahua huasitaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesus chasna rashcata ricusha pai japishca runagunaga huasha yuyarinaura Diospa shimibi casna quillcashca tiyacta: Paiguna camba huasita yanga huasitacuinta rashcata ricusha yapa piñarinayahuan. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesus chasna callpachicpi israelgunahua amuguna paitaga tapunaura, Yachanatami munanchi canga pitangui caita casna rangahuaca. Pihua urdindata charingui caigunata casna rangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus paigunata cutipara, Cai Diosta alabana huasita urmachichi, quimsa (3) punzhaibiga ñuca cuti jatachishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chi israelguna randi ninaura, chuscu chunga sucta (46) huatatami tarabashcanchi cai huasita rangahuaca, chasnatachu canga quimsa punzhallaibiga jatarichingui. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Randi Jesusca mana rimaurachu runa rashca Diosta alabana huasimanda, astahuanbas paihua quiquin aichamandami rimaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chiraicumi Jesus huañusha causarishcahuashaga, pai japishca runagunaga pai casna rimashcata yuyarisha Diospa shimibi quillcashca tiyactas, pai rimashcatahuas quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus chara Jerusalen llactai pascua nishca jista uras aushcallaita pai pihuas mana raushcagunata rashcata ashca runaguna ricusha paita quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Paiguna quirinchimi nicpihuas Jesusca mana munarachu runaguna munashcata rangahua, tucui runaguna imasna yuyarishcatas yachashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesus mana minishtirachu pihuas runagunahua yuyaimanda rimanata, paillatami tucui runagunahua shungu ucuibi yuyarishcata yachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Chi uras Nicodemo nishca shuc fariseo runa tiyara, israel runagunahua amuguna mandac muntunmanda ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cai Nicodemo shuc tuta Jesushuan cuintanacungahua rira. Pactasha paita nira, Yaya Dios ñucanchita yachachingahua canda cachashcataga yachanchimi señor. Can rashcagunata pi runahuas ranata mana ushanzhu Yaya Dios chi runahuan mana aupiga. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nicpi Jesusca casna nira, Sirtupacha canda nini pihuas mana llullucucuinta cutillata pagarishaga Diospa ali mandanama yaicunatas mana ushangachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Casna Jesus nicpi Nicodemo tapura, Imasata shuc runa ña rucu asha cutillata pagarinataga ushan. Ushanzhu cuti paihua mamahua huicsa ucuibi yaicunata cutillata pagaringahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tapucpi Jesus cutipara, Sirtupacha canda nini, pihuas yacumandas, chasnallata Diospa Samaimandas mana pagarishaga Diospa ali mandanama yaicunataga mana ushangachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Runa mamamanda pagaricca runallata man, randi Diospa Samaimanda pagaricca Diospa Samaitami charin. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tucuimi cutillata pagarina anaun ñuca chasna nicpi ama manzharinguichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Huairaga maican partimahuas huairanllami. Randi huairashcata uyashahuas maimanda shamuctas, maita riutas mana yachaibacchan. Chasnallatami Diospa Samaimanda cuti pagariccunataga mana asirtanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chasna nicpi Nicodemo cutillata tapura, Imasata casnaga angaya. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tapucpi Jesus cutipara, Canga israelgunata Diospa shimita yachachic runa ashallata caigunataga manachu yachangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sirtupacha canda nini, ñucanchi yachashcatami rimanchi, chasnallata ñucanchi quiquin ricushcatahuas cuintanchi. Chasna acpihuas ñucanchi cuintashcata quirinatas mana munanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cai pachaibi tiyaccunamanda ñucanchi cangunata cuintacpi mana quirishcanguichi. Chasna acpi ñuca jahuapachamanda cuintacpiga imasata quiringuichiya. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mana pihuas jahuapachamaga sicashcachu, randi ñuca Runa Tucuc nishcallami chimandallata uraicumuc ashami ushani. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ñáaupa uras huañuc Moisesca chi chaquishca pambai shuc paelamanda palutashina rasha, shuc suni caspi jahuaibi huarcushca. Chasnallatami ñuca Runa Tucuc ashami huarcuitucuna ani. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chasna tucuna ani tucui ñucata quiric runaguna huiñai causaita charinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yaya Diosca cai pachai causac runagunata yapa llaquishcamandami paihua sapalla churita caima cachamushca tucui paita quiric runaguna ama ucupachama chingarinauchun, astahuanbas huiñai causaita charinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaya Dios mana runagunata caudsayachingahuachu paihua churita cachara, randi quishpichichun nishami cachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tucui Diospa churita quiric runaguna huañushcahuashaga ña mana caudsayachishca tucungauna, randi mana quiric runagunaga ña caudsayuc manaun Diospa sapalla churita mana quirishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Caimandami chi mana quiric runaguna caudsayachishca aunguna, paiguna mana ali rashcamanda. Diospagmanda shamusha ac punzha nishcaga cai pachama shamugllaita, runagunaga chi punzharandimanda tutai purishcashina juchaibi causanata mas yali munanaura. Chimandami caudsayachishca aungunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tucui mana alita rasha causac runagunaga Diosmanda shamuc punzhataga mana llaquinaunzhu, chasnallata chi punzhama mana caillayanaunzhu paiguna mana alita rashcaguna ama pagllai ricurichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Randi Dios sirtu rimashcata caticcunaga punzhayachigma caillayanaunmi paiguna Dios munashcatashina rashcagunaga pagllai alita ricuringahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chihuasha Jesus pai japishca runagunandi cutillata Judea nishca partima rira, chibi unainicta saquirira paigunahuan bautisasha. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chasnallata Juanbas Enón nishca partibi Salem mayanbi bautisaura chibi ashca yacu tiyashcaraicu. Chasna acpi runaguna chima bautisaringahua rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tucui chasna tucunaura chara mana Juanda carcelma apaullaita. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Shuc punzha Juanda catic runaguna shuc israel runahuan sinzhita rimanacunaura Diospa ñaupacpi ali tucungahua nisha maillarina partimanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juanba runaguna paihuagma risha ninaura, Ricui Juan, Jordan yacu chimbaibi canhuan aushca runa, can ñucanchita cuintashca runaga, cunanga paihuas bautisaunmi. Ñáa tucui runaguna paitaga catiungunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Rimanaupi Juan casna cutipara, Mana Dios ushaita cucpiga pihuas mana imatahuas charinata ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cangunallatata ña pagllai rimarani ñucaga mana quishpichic Cristochani nisha, randi ñucaga punda paihua ñaupacpi Diosmanda runagunata yuyachingahuaca cachashcallami arani. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Shuc cadsarana jistaibiga chi cadsarauc huarmita charigmi cadsarauc runaga an, randi chi cadsarauc runahuan pariu tiyauc amigoga pai rimashcata uyasha cushiyanmi. Chasnallatami chi cadsarauc runahua amigocuintallatami ñuca cunanga pactacta cushiyani. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Paiga caran urasmi mas balic tucusha ringaraun, randi ñucaga ucui saquiringarauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jahuamanda shamucca tucuigunamandahuas mas yali balic maun. Randi allpamanda acca allpamandalla man, chasnallata allpai tiyaccunamandallami riman. Randi jahuapachamanda shamucca tucui tiyaucunata mandaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pai imatas ricushcatas, uyashcagunatahuas sirtupacha rimagllaitami pihuas mana quirinata munanzhu pai rimashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Randi maicanbas quiricpiga ricuchinmi Yaya Dios sirtuta rimac acta. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yaya Diosca pai cachamushca runamami paihua Samaitaga mana mitsasha cushca. Chasna ashami Diospa sirtu shimillata cuintan. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jahuapachai tiyac Yayaga paihua churita yapa llaquishami ushaita cushca tucuita mandachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Diospa churita quiricca huiñai causaitami charin. Randi mana Diospa churita quirinata munacca mana charingachu chi causaitaga, randi Yaya Dios manzhanayacta cashtiganga nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chi uras fariseo nishca israel amuguna uyashcauna yapa ashca runaguna Jesusta catiushcatas, chasnallata Juanmandas yalita bautisauta nisha cuintaushcatas uyashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ñáa Jesus quiquinllataga mana bautisacchara, randi pai japishca runagunallami bautisac ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesusca chi fariseoguna chasna uyashcata yachasha, Judea partimanda llucshisha Galilea partima bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galileama pai riushcaibi Samaria partita pasana ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chita riushcai Sicar nishca llactama pactara. Chi llacta mayanbi callari apayaya Jacobo paihua churi Josema cushca allpa ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chibimi Jacobo allashca yacu pugru tiyara. Jesus ña chibi pactasha yapa sambayashca asha chi pugru mayanbi tiyarira, chi uras cadsi chaupi punhzaibi mara. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chasna acpimi Jesus japishca puriu runagunaga llacta ucuma rishca anaura micunata randingahua. Chasnaibimi, chi pugrumanda yacuta huishingahua chi llactamanda shuc samaria huarmi shamura. Chi huarmita Jesus nira, Ashilla yacuta cuhuai. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ñáa israel runagunaga samariamandagunata mana balichishcamandami mana caillayac anaura. Chiraicumi chi huarmiga Jesus yacuta tapucpiga nira, Canga israel runa ashallata imahuata yacuta tapuhuangui samariamanda huarmi agllaita. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus paita cutipara, Dios imata cuitucunata can yachashaga, chasnallata canda pi yacuta tapuuta yachashaga, ñucata tapuhuanguimami. Tapucpiga causaita cuc yacutami cuitucunguima. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nicpi chi samaria huarmi casna cutipara, Mana imahuanbas yacuta cai pugrumanda huishingahuaca charishallatachu, causac yacutami cushcangui nishaga rimahuangui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ñáucanchi apayaya Jacobomi cai yacu pugrutaga saquitucuranchi. Paihuas, paihua churigunas, chasnallata paihua huibagunahuas caimandallatami upic anaura. Canga paimandas yalichangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Randi Jesus paita nira, Tucui cai pugrumanda yacuta upiccunaga cutillatami upinayachingauna. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Astahuanbas ñuca cushca yacuta upicca mana ima uraspas upinayachingachu. Ñáuca cushami nishca huiñai causaita cuc yacuga chi upic runahua shungu ucumanda mana tucuric yacuhuahuashina llucshiungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chita uyasha chi huarmi cutipara, Chi yacuta upichihuai señor, ñuca mana cuti upinayangahua, chasnallata cai pugruma ama ima uraspas cuti shamungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus nira, Camba carita pushagri. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chasna nicta uyasha chi huarmi nira, Cari illac mani. Jesus randi paita nira, Sirtutami ningui cari illac mani nishaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pichca (5) runatami charishcangui, chasnallata cunan can charishcahuas mana camba carichan. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jesus rimashcata uyasha chi huarmi nira, Ñáuca ricucpiga canga Dios rimashcata pasachic runa mangui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ñáucanchi huañuc samaria apayayagunaga cai urcuibimi Diosta alabac anaura, astahuanbas canguna israel runagunaga Jerusalen llactallaimi Diosta alabana an nisha rimanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus cutipasha nira, Ñáuca rimashcata uyahuai, sirtupachami canda nini, shuc punzha pactariunmi mana cai urcuma shamushallata, mana Jerusalenma rishallatas Yaya Diosta canguna alabanguichi. Chi punzhaga ña pactarimunmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Cangunaga mana yachanguichichu pita alabaushcatahuas, randi ñucanchi israelgunaga yachanchimi pita alabaushcatahuas, chiraicumi quishpinaga israelgunamandami shamun. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Chi alabana urasca cunanllatami pactariunmi Yaya Diosta alabac runaguna sirtupachata alabangaraunguna Diospa Samai yachachishcashina. Chi punzhaga shamungami, ña pactamushcami. Jahuapachai tiyac Yayaga paita llaquiccunaga casna alabanatami munan. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosca samai man, chiraicumi paita alabac runagunaga sirtupachata Diospa Samai yuyachishcacuintalla alabana anaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jesus chasna rimacpi chi samaria huarmi randi nira, Yachanimi Mesias nishca quishpichic Cristo shamunataga, pai shamushcaibimi tucuitaga yachachitucushun. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus randi nira, Chi Cristo nishca runaga ñucami ani, cunan canhuan cuintauc. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chasnai Jesus japishca runaguna bulltiamushcai manzharinaura Jesus shuc huarmihuan cuintaushcata ricusha. Chasna agllaita mana pihuas tapurachu imatata chi huarmi munara, imamandata cuintanacuura nishaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chi huarmiga chi llactai tiyac runagunata rimangahua paihua jirmangata chillaita saquisha llactama callpasha rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Pactasha nira, Ricucshamuichi caibi shuc runata, tucui ñuca rashcagunatami rimahuashca. Caiga manachu Cristo nishca quishpichic runa an imachari. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chi rimashcata uyasha llactamanda ashca runaguna rinaura Jesus aushcama. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Paiguna chara mana pactamushcallaita Jesuspa runaguna paita rugaunaura nisha, Ashillata micui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rugacpi Jesus nira, Ñáucaga canguna mana yachashca micunatachu charini. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Paihua runaguna randi, Pishi micunata apamuraya pai micuchun nishaga paigunapura tapunacuicallarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Randi Jesus paigunata nira, Ñáuca micunaga ñucata cachamuc Yaya munashcata rasha pactachina mani, pai callarishcata tucuchina mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Canguna ninguichimi, tarpushcagunata pallangahuaca chara chuscu (4) quillami pishin nisha, randi ñuca cangunata nini, ricuichi chagrai tarpushca muyugunata ña pallanalla an nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pallanai tarabac runa gananmi pai tarabashcamandaga. Chi runa pallashcaga huiñai causairaicu man. Chasnallata tarpuc runahuas chi pallac runandi pariu cushiyaungunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cai rimashcaga sirtu man, Shugmi tarpun, shugmi pallan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ñáuca cangunata cacharani pallangahua canguna mana tarabashcallaita, chasnami shuccuna sinzhita tarabashcamanda canguna alita saquirishcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ñáa chi ric huarmiga tucui ñuca rashcagunatami shuc shamuc runa rimahuashca nishami chi llactai cuintaura. Pai chasna rimashcamanda ashca chi Samaria llacta runagunami Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chiraicumi chi llactai causauc runaguna Jesuspagma shamusha paita ruganaura paigunahuan saquiri nisha. Rugacpi paigunahuan ishcai (2) punhzata chi llactai saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chasnallatami mas runaguna quirinaura Jesus quiquin rimashcata uyasha. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Casnami chi huarmita ninaura, Cunanga mana can rimashcamandallachu quirinchi, randi ñucanchi quiquinmi uyashcanchi, chiraicumi yachanchi pai sirtupacha tucui runagunataga quishpichingahua shamuc runa ashcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Casna ishcai punhzata cainashcahuasha, Jesus Samariamanda llucshira Galileama ringahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesusllata shuc rimanata rimara casna nisha, Dios rimashcata pasachic runataga paihua quiquin llactaibi mana llaquinaunzhu nisha rimashca. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chasna acpihuas pai Galileaibi pactashcai chibi causac runagunaga paita ricusha yapa cushiyanaura. Paiga Jerusalenbi pascua nishca jista punzhagunai ima ali rashcagunatas rashcami. Paigunahuas chibi ausha chigunata ricushca asha cunan paita ricusha yapa cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chihuasha Jesus bulltiara Galilea llactallai Caná nishca llactama, yacumanda vinota rashca llactamallata. Capernaun llactaibimi shuc mandac runahua churiga ungushca sirira. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judeamanda Galileama Jesus pactamushcata uyashami chi runa Jesuspagma rugangahua shamura, Ñáuca churi huañuu siriun nisha, paita alichingahua ñuca huasima shamupai. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Rugacpi Jesus paita nira, Cangunaga pihuas mana raushcagunata ñuca rashcata mana ricushaga mana quiringuichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Randi chi runa cuti nira, Uctalla shamupai ñuca churi chara mana huañugllaita. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Pai chasna rugacpihuas Jesus paita nira, Camba huasima bulltiailla, camba churiga causaunmi. Chi runaga Jesus rimashcata quirisha huasima bulltiarallami. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Riusha chara paihua huasima mana pactagllaita, paihua huasibi tarabac runaguna tupagrisha ninaura, Camba churiga causaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Paigunata tapura, Imasnaita causaringahua callarira ñuca churi. Tapucpi, Caina la una tupui ungüiga ña pasarira ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chibimi chi sundalu mandacca asirtara chi urasllaitami Jesus paita rimashca ara camba churiga causanmi nishaga. Chasnamandami chi runa tucui paihua huasibi causaccunandi tucuilla Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Caitaga Jesus Judeamanda Galileama bulltiasha ña pihuas mana raushcata ishcai (2) cutin rarami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chimandahuasha israel runaguna Diosta yuyarina shuc jistata raunaura, chiraicumi Jesusca Jerusalenma bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chi llactaibi Ovejagunahua Pungu nishca mayanbi tiyan shuc allashca ichilla cucha pugru, hebreo shimibi Betsata nishca. Chi allashca ichilla cucha mayanbi pichca (5) chushac huasi tiyara. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chi luntuccunaibi tiyac anaura ashca ungushcaguna, mana ricuccuna, janga chaquiguna, suchugunas sirinaura allpaibi. (Paigunaga chi yacu cuyurinata chapaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Maican uras shuc angel shamusha chi yacuta cuyuchira. Chi yacu cuyurishcai punda yacuma yaicuc runa ima ungüimandas aliyashca saquiri anaura). ");
INSERT INTO qvzNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chi ungushca runaguna muntunbi tiyara shuc runa quimsa chunga pusac (38) huatata ungushca causac. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus chi runata siriuta ricusha, chasna yapa unaita ungusha causashcata yachasha chi runata tapura, Janbirinata munanguichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tapucpi chi ungushca runa nira, Mana pitahuas charinichu señor cai yacu cuyurishcaibi ñucata yacui churangahua. Caran cuyurishcaibimi shucca ñucata binsisha ñaupasha rihuan. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus randi paita nira, Jatari, can puñunata apasha purisha rilla. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chi ratullaitami chi ungushca runa janbirira, pai puñunata apasha puricallarira. Ñáa chi punzhaga israel samana punzha arami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chiraicu israel amuguna chi janbiric runata ninaura, Cunanga samana punhza man. Can puñunata casna apariushaga mandashca shimitaga mana cadsungui ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chasna nicpi chi janbiric runa cutipara, Ñáucata janbic runami camba puñunata apasha purisha ri nisha nihuara. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nicta uyasha amuguna cuti tapunaura, Maicandan canda casna nic runaga camba puñunata apasha purisha ri nishaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Randi chi runa mana yacharachu pi paita janbishcata, Jesus ña anchurishca ara chi auc runa muntun ucuibi. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chihuasha Jesus pai janbishca runata Diosta alabana huasibi tupasha paita nira, Ricui, cunanga ña janbirishca angui, ama cuti juchata rasha causanguichu caimandas yali jatun nanai canma ama shamuchun. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chasna nicpi chi runaga risha israel amugunata cuintara, Jesusmi ñucataga janbihuashca ara nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chiraicumi israelgunaga Jesusta piñasha catita callarinaura samana punhza janbishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Randi Jesus paigunata nira, Ñáuca Yayaga tucui uras tarabauc man, chiraicumi ñucahuas tarabauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pai casna rimashcamandami israelgunaga astahuan mas huanchinata munanaura, pai samana punhzata mana balichishcamanda, chasnallata paiga ñuca quiquin Yayaga Dios man nisha Dioscuinta tucushcamanda. Chasnamandami paita yapa piñanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus paigunata casna rimara, Sirtu cangunata nini, Diospa Churi ashahuas ñuca munaiga mana imatas rai ushanichu. Ñáuca Yaya imata rauctas ricuunimi, paihua churi ashami ñucahuas paicuintallata imatas rauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jahuapachai tiyac Yayaga paihua churita llaquishami tucui pai rashcagunataga ricuchihuan, chasnallata mas jatun rashcagunatahuas ricuchingami. Chigunata ricusha cangunaga manzharinguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yaya Diosca huañushcagunatas causachic an. Ñáucahuas paihua churi ashami chasnallata huiñai causaita cuni maican ñuca munashca runagunataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Yayaga mana pitahuas taripanzhu, astahuanbas paihua churi acpimi cuhuashca tucui taripana ushaita tucui runaguna balichihuanauchun nisha Yaya Diosta balichishcashinallata. Maican churita mana balichicca, churita cachamuc Yayatahuas mana balichinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sirtupacha cangunata nini, maicanbas ñuca rimashca shimigunata uyasha, ñucata cachamuctahuas quirishaga huiñai causaitami charin. Chi runa mana caudsayachishca taripaitucungachu, astahuanbas huañuimanda causaima ña pasashcami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sirtupacha cangunata nini, Diospa Churi rimashca shimita huañushca runagunahuas uyangaraunguna, maican chi shimita uyasha cadsuccunaga causangaunami. Chasna tucuna urasca ña pactamushcami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ñáuca yayallami causaita cungahuaca ushaita charin. Chasna asha paihua churi acpimi pitas causaita cuchun nisha ñucama ushaita cuhuara. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chasnallatami ushaita cuhuashca tucuita taripangahua ñucaga Runa Tucuc ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ama manzharinguichichu ñuca casna rimashcata uyasha, astahuanbas tucui huañushca runaguna ñuca rimashca shimitaga uyana uras pactarimungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chita uyasha pambashcagunamanda llucshingaunami. Alita raccunaga causaringauna huiñai causaita charingahua, randi mana alita raccunaga causaringauna caudsayachishca ucupachama ringahua nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ñáucaga mana imatahuas ranata ushanichu ñuca quiquin yuyaimandallaga. Ñáuca Yaya mandashcashinallami taripani. Ñáuca munashcata ranataga mana munanichu, randi ñucata cachamuc Yaya munashcashinallatami rani. Chiraicu ñuca taripanaga cusca man. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ñáuca ñucallata balichiringahua rimacpiga ñuca rimashcaga mana imaraicuhuas balinmachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Randi cunanga aunmi shuc ñucata balichisha rimac. Paiga ñucamanda rimashca shimiga sirtu ashcata yachani. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Cangunaga tapunauchun nisha maican runagunata Bautisac Juanbagma cacharanguichi. Ñáa pai ñucamanda rimashcaga sirtu mara. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Randi ñucaga mana runaguna rimashcamandachu balic ani, astahuanbas caitaga Bautisac Juanmanda rimani canguna quishpirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Bautisac Juan yachachisha shuc sindishca bilacuinta mara. Cangunaga pai punzhayachicshina yachachishcata shuc ratullatami munaranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Randi Juan rimashcamandahuas ñuca partimanda shuc mas balic rimacta charini. Ñáuca Yaya rai nisha mandashcata pactachiuni. Imata rashahuas ñuca Yaya cachamuhuashcataga ricuchiuni. Chasna acpi ñuca rashcagunaga Bautisac Juan rimashcatahuas mas yalita ñuca pi actas richinaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chasnallata ñucata cachamuc Yayallatami ñuca partimanda sirtuta riman. Canguna ima uraspas pai rimashcata mana uyashcanguichichu, paitas mana ricushcanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yaya Dios cachamushca runata canguna mana quirishcamandami paihua shimihuas canguna shungüibiga mana tiyanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Cangunaga Diospa shimita ashcata ricunguichi chibi huiñai causaita tupashun nisha. Chasna agllaita chi shimigunaga ñucamandami rimanaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chasna rimaupihuas cangunaga ricusha yachashallatas ñucama shamunata mana munanguichichu chi huiñai causaita charingahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ñáucaga mana munanichu runaguna ñucata balichishca tucungahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chasnallata canguna imata rimaupihuas yuyarishcatas ñuca yachani Yaya Diosta canguna shungu ucui mana llaquishcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ñáucaga ñuca Yayahua shutibimi shamushcani, chasna agllaita cangunaga mana llaquihuanguichichu. Randi shuc runa paihua quiquin shutibi shamucpiga chitaga llaquinguichimami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cangunapuralla alabanacusha causanguichi, astahuanbas quiquin Diospagmanda alabaitucunata mana munanguichichu. Chasna ashaga imasata ñucata quirinata ushanguichiya. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Diospacpi ñuca cangunata culpayachingaraushcata ama yuyaringuichichu. Cangunata caudsayachicca canguna llaquishca Moisesllata manga, pai mandashcagunata canguna mana cadsushcamanda culpayachitucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesca ñuca partimandallatami quillcara. Pai rimashcata canguna sirtu quirishca ashaga ñucatahuas quirihuanguichimami. ");
INSERT INTO qvzNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Randi canguna pai quillcashcataga mana quirishaga imasata ñuca rimashcataga quiringuichiya. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chimandahuasha Jesus rira Galilea cucha chimba partima, chi cuchallatami Tiberias nishca an. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ashca runagunami Jesus ungushca runagunata janbishcata ricushca asha pai Diospagmanda ac runa man nisha paita catinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus ña chimbama pactasha shuc urcuma pai japishca runagunandi sicasha tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chi uras israelgunahua jista Jerusalenbi ñallami callaringaraura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus ashca runaguna paita catiuta ricusha Felipeta tapura, Cai tucui runagunata carangahuaca maibita randigrishun. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesus casna nira imasashi Felipe nigashca nishalla, randi Jesusca yacharami pai imata rangaraushcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tapucpi Felipe nira, Tucuigunama ashilla ashilla carangahuaca ishcai patsac (200) punzhata tarabashca cullquihuan micunata randicpihuas mana pactangachu yachin nira. (200 punzha nisha ñalla 7 quilla tucunma ara). ");
INSERT INTO qvzNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Randi Jesus shuc japishca runa Simon Pedrohua huauqui Andresca nira, ");
INSERT INTO qvzNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Caibimi shuc huahuaga pichca (5) cebadamanda rashca panda chariun, chasnallata ishcai (2) yacu aichatas, randi cai tucui runaraicuga mana pactangachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chita uyasha Jesus pai japishca runagunama nira, Quihuai tiyarichi nisha tucui runagunata rimaichi. Chibimi carigunaga pichca huaranga (5.000) runa tupu manaura. Ñáa chi lugarbi ashca quihua tiyashca jahuai tiyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Paiguna tiyarishcahuasha Jesus chi pangunata paihua maquihuan japisha, Yaya Diosta pagrachushcahuasha, tucui chibi auc runagunama pasachira. Chasnallatami rara yacu aichatahuas, carandami paiguna munashca tuputa carara. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ñáa tucui runaguna sacsacta micushcahuasha Jesus pai japishca runagunata nira, Micushca puchugunata sumac tandaichi ama imas jichurichun. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chasna nicpi chi pichca (5) pangunamanda carashca puchuta tandasha jundachinaura chunga ishcai (12) ashangata. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesus chasna gustu mirachicta ricusha runaguna ninaura, Sirtupachami cai runaga Dios rimashcata pasachic paihuagmanda cai pachama shamuna nishca ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Randi Jesus chi runaguna paita jursamanda ñucanchi mandac amuta rangahua llactata mandachun churashunchi nishcata yachasha, paigunata llucshisha cutillata urcuta bulltiara sapalla aungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñáa tutayaupi Jesus japishca runaguna chi urcumanda Galilea cuchama uraicunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Shuc canuaibi yaicusha chi cuchata chimbaicallarinaura Capernaun llactama pactangahua. Ñáa ali ansayashca agllaitami Jesusca chara chi urcumandaga mana uraicumushca ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chasna paiguna chimbaushcai shuc sinzhi huaira shamusha cuchata mana cáillata ulasyachicallarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ñáa sucta (6) kilometro tuputa paiguna chimbaushcai Jesus yacu jahuata purisha paigunama caillayamushcata ricunaura. Chita ricusha yapa manhzarishca anaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chasna manzharicpi Jesus paigunata nira, Ñáuca mani, ama manzhanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Paita uyasha cushihuan canuai yaicuchinaura. Yaicuchishcai huairashina paiguna riushca llacta allpama pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cayandi punhza chi cucha chimba partima saquirishca runagunaga musianaura Jesuspa runaguna chi auc shuc canuallai chimbashcata, randi Jesus chi canuai paigunahuan pariu mana riucta ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Runaguna chita yuyarisha tiyaupi chi tutamandallata Tiberias nishca llactamanda ashca canuaguna pactamunaura Jesus Diosta pagrachu nisha panda carashca pamba mayanbi. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesuspas chasnallata paihua runagunahuas mana chibi aucunata ricusha, chi canuagunaibi tucui runaguna yaicusha Capernaun llactama rinaura Jesusta mascangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chimbama pactashcaibi Jesusta tupasha tapunaura, Imasnaita caimaga shamurangui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tapunaupi Jesus paigunata nira, Sirtutami cangunata nini, canguna mana mascahuaunguichichu ñuca Diospa ushaihuan rashcata ricushcamanda, randi yanga micunata nishalla, sacsacta micushcamandami mascahuaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tucuric micunata munashalla ama puringuichichu, randi mana tucuric huiñai causana micunata mascasha purina manguichi. Cai huiñai causana micunataga Runa Tucuc asha cangunata ñucallami cusha. Jahuapachai tiyac Yayaga ñucama paihua ushaita cuhuashcami casna rangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Caita uyasha paita tapunaura, Dios munashcata pactachingahuaca imatata rana anchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tapucpi Jesus nira, Yaya Diosmi ñucataga cachamuhuara cangunaga ñucata quirihuanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nicpi paita cutillata tapunaura, Imatata pihuas mana raushcata rasha ricuchingui canda ñucanchi quiringahuaca, imagunallatata rangaraungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Diospa shimibi quillcashca tiyac an: Diosmi paihua runagunata jahuapachamanda micunata caraura. Chi rimashcacuintallata ñucanchi huañuc apayayagunaga chi “Maná” nishca micunatami chaquishca pambai micunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chasna nicpi Jesus paigunata nira, Sirtupachami cangunata nini, mana Moiseschu cangunataga jahuamanda micunataga carara, astahuanbas ñuca Yayami jahuapachamanda quiquin micunata cuc an. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yaya Dios cushca quiquin micunaga jahuapachamanda shamusha cai mundui auc runagunata causaita cuc mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Caita uyasha paiguna tapunaura, Tucui uras chi tunu micunata ñucanchima cui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus randi nira, Ñáucami huiñai causaita cuc micunaga ani. Maicanbas ñucama shamucca mana ima uraspas raicachingachu, chasnallata ñucata quiricca mana ima uraspas upinayachingachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Randi ñuca cangunata rimashcashina cangunaga mana quiringuichichu ñuca quiquinda ricushca ashahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tucui ñuca Yaya ñucama cushca runagunaga tucuilla ñucama shamungaunami. Chi ñucama shamuccunataga mana callpachishachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ñáucaga jahuapachamanda shamushcanimi, mana ñuca quiquin munashcata rangahua astahuanbas ñucata cachamuc Yaya munashcallata rangahua shamushcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ñáucata cachamuc munashcaga cai man: Tucui pai ñucama cushca runagunata tucurina punzhai causachishami, mana shucpas chingarishca tucungachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Caimi ñuca Yaya munashcaga an: Tucui paihua Churita ricusha quiriccunaga huiñai causaita charinauchun nin. Chasna acpi ñucami tucurina punhzaibi paigunataga causachisha. Chasna paita quirinamanda yachachiura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Casna Jesus ñucami jahuapachamanda uraicuc quiquin micunacuinta ani nisha rimashcamandami israel amugunaga paita piñasha rimangahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Casna piñasha rimanacunaura, Manachu caiga Josehua churi Jesus an. Paihua yayatas mamatas ricsinchimi. Imasata cunanga jahuapachamandami shamushcani nishaga riman. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus caita uyasha paigunata nira, Chasna rimanacunata saquichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mana pihuas ñucama shamunataga ushanzhu, ñucata cachamuc Yaya paita ñucama mana apamucpiga, randi chi runataga tucurina punhzaibi ñuca causachishami. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios rimashcata pasachic runaguna quillcashcaibi nin: Diosmi tucuigunata yachachinga. Chasna acpiga tucui ñuca Yaya rimashcata uyasha yachagllami ñucama shamunga. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yaya Diostaga mana pihuas ricushcachu, randi ñucallami paimanda shamuc asha paitaga ricushcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sirtupacha cangunata nini, Maicanbas ñucata quiricca huiñai causaita charinmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ñáucaga huiñai causaita cuc micunacuinta mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Canguna apayayagunaga chaquishca pambaibi chi “Maná” nishca micunata micushca ashallatami huañunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Randi jahuapachamanda uraicumuc micunamandami rimauni. Maicanbas chi micunata micucca mana huañusha huiñaita causanga. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ñáucami chi jahuapachamanda shamuc causai micunaga ani. Maicanbas cai micunata micucca huiñaigama causanga. Cai micunaga ñuca quiquin aicha man. Chitaga runaguna huiñai causanauchun nishami ñucallatami cungarauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Israel runaguna rimarinacuicallarinaura, Imasata cai runaga paihua quiquin aichataga caraitucushun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus randi nira, Sirtupacha cangunata nini, Ñáuca Runa Tucuc ashcamandami ñuca aichata mana micushaga, ñuca rahuaitas mana upishaga, Diospa causaitaga mana charinguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Randi maicanbas ñuca aichata micucca, ñuca rahuaitas upicca, huiñai causaitami charin. Chasna charicpi ñucallatami tucurina punhzaibi paigunataga causachisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ñáuca aichaga sirtupacha causaita cuc micuna man, ñuca rahuaiga sirtupacha causaita cuc upina man. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Maicanbas ñuca aichata micucca, ñuca rahuaita upicca, ñucahuan shuglla tucusha pariu causan. Chasnallata ñucahuas paihuan pariumi causani. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ñáucata cachac Yayami causaita charin, chiraicumanda ñucaga paihua ushaihuan causauni. Chasnallatami maicanbas ñucamanda micuc runaga ñuca ushaita charingami causangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jahuapachamanda uraicumuc micunamandami cuintauni. Cai micunaga mana canguna huañuc apayayaguna micushca “Maná” nishcacuinta anzhu. Chi micunata micushahuas huañunaurami, randi cai micunata micucca huiñaigama causangami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tucui chi shimigunata Jesus yachachira Capernaun llactaibi ac israel tandarina huasi ucuibi. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Casna Jesus yachachishcagunata uyasha ashca paita catic runaguna rimariuraguna, Tucui pai rimashcagunaga mana catibac, yapa sinzhi man, pita chitaga catinga, mana ushaibacchan nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus chi runaguna rimariushcata yachasha paigunata tapura, Cai ñuca rimashca shimiga cangunata piñachinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chasna ashaga imashi tucunma Runa Tucuc ac ñuca ñaupa tiyashcamallata sicauta canguna ricucpiga. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diospa Samaimi huiñai causaita cucmi an. Chita japingahuaca runa aichaga mana imaschu. Ñáuca cangunama rimashca shimigunaga Diospa Samaimanda ashami causaita cun. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Chasna agllaitami cangunamanda maicangunaga chara mana quirihuanguichichu nira. Ñáa Jesus pundamandapacha maicanguna mana quiringaraucunata yachasha, chasnallata pi paita japichingarautas yachashami chasna rimara. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Paigunata mas rimara, Chiraicumi mana pihuas ñucama shamunataga ushanzhu ñuca Yaya mana apamucpiga nisha rimashcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chi urasmanda ashca caticcuna paita saquisha rinaura, ña paihuan mana mas puricchanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chita ricusha Jesus paihua chunga ishcai (12) japishca runagunata tapura, Chi shuccunashinallata cangunahuas rinata munanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tapucpi Simon Pedro cutipasha nira, Pihuagmata rishun señor. Can rimashca shimigunaga huiñai causana shimiguna manaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Chigunata ñucanchimi quirishcanchi, chiraicumi yachanchi can Dios anllasha jucha illac ashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pedro casna rimacpi Jesus nira, Manachu ñuca canguna chunga ishcaitaga (12) cayarani, chasna agllaita tucui cangunamanda shucca supaiyuc an. ");
INSERT INTO qvzNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesus casna nishaga Simon Iscariote nishcahua churi Judasmandami rimaura. Pai Jesus japishca runa ashallata paita japichingarauc runa ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chihuasha Jesus Galilea partita puric ara. Israel amuguna paita huanchishun nishcata yachasha Judea partibi rinata mana munarachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chi urasca israelgunahua huañuc apayayaguna carpa huasigunai causaushcata yuyarishami Jerusalenbi jistata rana punzhaguna ña pactamushcami. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chasnamandami Jesuspa huauquiguna paita ninaura, Ama caillaiga saquirichu, Judea partima ri, chibi tiyac canda catic runaguna can rashcagunataga ricunauchun. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maican runa ricsitucunata munashaga mana pacallaibiga racchan. Can caibi rashca samigunataga tucui runaguna ñaupacpihuas rana mangui paigunas ricunauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesustaga paihua quiquin huauquigunahuas mana quirishami casnaga ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus randi paigunata nira, Chara ñuca rina uras mana pactarishcachu, randi canguna rinaga ima uraspas ali an. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cai mundumanda ac runaguna cangunataga mana piñanaunzhu, randi ñucataga piñahuanaunmi ñuca paiguna rashcaguna mana ali ashcata pagllaibi rimashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cangunalla chi jistamaga richi, ñucaga mana riunichu ñuca rina punzha chara mana pactarishca acpi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Casna paigunata nisha Galilea partibi saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Paihua huauquiguna jistama rishcahuasha Jesuspas Jerusalenma rira, miticushcacuinta runaguna mana ricuushcaibi sapalla purisha riura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israel amuguna chi jistaibi Jesusta mascausha ninaura, Maibishi chi runaga aun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Runagunapurallata caran tunutami jalijali Jesusmandaga cuintanacunaura. Maicangunaga ninaura, Paiga shuc ali runa man nisha. Randi shuccunaga, Mana ali runachan, yapa runagunata umachic man ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Chasna agllaita mana pihuas Jesusmanda pagllaibiga rimacchan aura israel amugunata manhzasha. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ñáa chaupi jista aushcai Jesusca Diosta alabana huasi canzha partibi yaicusha yachachingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Paita uyasha manhzarishcahuan israel amuguna ninaura, Imasata cai tucuita cai runaga yachan mana estudiashca ashallata. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus paiguna cuintanacushcata yachasha nira, Ñáuca yachachishcaga mana ñuca yuyaimandallachu, randi ñucata cachamuc Yaya yachachishcatami yachachiuni. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ñáuca yachachina shimiga ñuca quiquin yuyaimandalla shamuc actas Diosmanda shamucta actas Yaya Dios munashcata ranata munac runallami yachanga. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pihuas quiquin yuyaimandalla rimac runaga, shuccuna balichihuanauchun nishalla ranaun. Randi pihuas paita cachamucta balichinata munashaga chi runa sirtu shimita rimac man. Paihuacpi ima llullanas mana tiyanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Manachu sirtu an Moises cangunata mandashca shimigunata cushcaga. Chasna agllaita cangunaga pihuas mana tucui chigunata cadsunzhu, chasna acpi imaraicuta ñucataga huanchinata munanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Caita uyasha runaguna ninaura, Chupayuc supai angui, pita canda huanchinataga niun. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chasna rimanaupi Jesus paigunata nira, Ñáuca chasna samana punzhaibiga shuc runata alichirani. Chasna pihuas mana ranata ushashcata ñuca rashcamandami tucui canguna manzhariranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yuyarichi. Cangunas samana punzha acpihuas chi huañuc Moises mandashcata pactachinguichimi carihuahua ullucarapundata pitisha. Chita ranaga mana paimanda punda callarirachu, astahuanbas cangunahua callari apayagunami chita rangahuaca callarinaura. Chasna acpi canguna chita ranguichimi samana punzha acpihuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Alimi, cunanga cangunahuas Moises mandashcata pactachingahuaca samana punzha acpihuas canguna cari huahuagunahua aicha pundahuallatas pitinguichillami. Chasna ashallata imahuacta ñucahuanga piñarihuanguichi ñuca shuc ungushca runata paihua intiru aichata samana punhzaibi janbishcamandaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ricurishcamandalla ama yanga yuyarisha caudsaichichu, astahuanbas imasna sirtu actahuas alita ricushcahuashami caudsayachinata ushanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Maican Jerusalenbi causac runaguna tapuicallarinaura, Manachu caiga amuguna huanchingahua mascasha puriushca runaga an. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chibi aungaya cuti runaguna ñaupacpi rimaugllaita mana pis paita imatas nin. Chasna ashaga amugunahuas cai runaga Dios cachashca quishpichic Cristo agmi nishachu quirinaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Randi cai runa Nazaretmanda shamushcataga yachanchimi, astahuanbas quishpichic Cristo shamushcai mana pihuas yachangachu maimanda pai shamushcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus Diosta alabana huasibi camachiushcai chi runaguna casna rimaushcata uyasha, sinzhita rimara, Indá canguna ricsihuashcanguichimi, ñuca maibi huiñashcatahuas yachashcanguichimi. Randi mana ñuca munaimandallaga shamushcanichu. Astahuanbas ñuca tucuita pactachic Yaya cachahuacpimi shamushcani. Cangunaga paita mana ricsishami causanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Paimi cachamuhuashca. Chasna ñuca paimanda shamuc ashami paitaga ricsini nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chasna Jesus rimacpiga israel amuguna paita caudsayachingahua japinata munanaura, Munagllaita pai huañuna uras chara mana pactarishca acpi mana pihuas japinata ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Chasna chi amuguna piñagllaita ashca runagunami paita quirinaura. Chi quiriccunapura cuintanacunaura, Cai Jesusca Dios cachangaraushca quishpichic Cristochan. Cristo shamushaga cai runamandas mas yali jatun ushaihuan ranagunatachu rangaraun imachari nisha ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Runaguna pacalla Jesusmanda chasna rimaucunata fariseogunaga uyasha piñarisha, pagrigunahuan pariu tucusha, Diosta alabana huasita cuirac sundalugunata cachanaura Jesusta japisha apagringahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chi sundaluguna paihuacpi pactaushcai Jesus runagunata nira, Ñáa mana yapa unaitachu cangunahuan aungarauni, chihuashaga ñucata cachamucpamallatami bulltiangarauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Canguna mascashahuas mana tupahuanguichichu, canguna pactanata mana ushanguichichu ñuca aushcama. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chita uyasha israelgunapura tapunacuicallarinaura, Maitashi cai runaga ringaraun ñucanchi mana tupanata ushaibagmaga. Caru llactagunama israelguna causaushcai rishachu chi mana-israel runagunama camachigringaraun. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Imasna nishata casnaga mascashahuas mana tupahuanguichichu nin, chasnallata ñuca aushcama canguna mana shamunata ushashcamanda nishaga imatata nin nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chi puchucai jista punhzami mas balic punzhaga ara. Chi punhzaibi Jesus shayarisha sinzhita caparisha rimara, Maicanbas upinayashaga ñucahuagma shamuichi upingahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Diospa shimibi rimashcashinallatami, ñucata quiric runahua shungumandaga causaita cuc yacuguna llucshingauna nin. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Casna nishaga Jesus Diospa Samaimanda rimara, Maicanbas paita quiric runaga Diospa Samaitami cuitucunga. Pai casna rimara chara jahuapachama mana bulltiashca asha Diospa Samai chara mana shamushca acpi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus casna rimashcata uyasha maican runaguna ninaura, Sirtupachami cai runaga Dios rimashcata pasachic shamungarauc runa an. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Shuccunas ninaura, Paiga Quishpichic Cristo man ninaura. Randi shuccunaga ninaura, Mana. Quishpichic Cristoga mana Galileamandachanga. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diospa shimibi quillcashca tiyacca ninmi: Quishpichic Cristoga israelgunata mandac rey amu Davidmanda mirai runa ana man, chasna acpimi amu David causaushca Belen llactaibi pagarina manga. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chasna Jesusmanda chicanda yuyarisha chi runaguna ishcai (2) muntun tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Maicangunaga Jesusta japisha caudsayachingahua apanata munanaura, chasna agllaita mana pihuas imatahuas rarachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jesusta japingahua cachashca sundaluguna bulltiacpi, paigunata cachac fariseogunas chasnallata pagri amugunas tapunaura, Imahuata chi runata mana apamuranguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tapucpi cutipanaura, Ima uras pihuas mana chi runa rimashcashinaga rimashcachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Casna paiguna rimacpi fariseoguna caminaura, Cangunahuaschu umachitucushcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ñáucanchi amugunamandas, chasnallata fariseogunamandas paitaga maicanda quirishca. Mana shucpas. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Randi cai paita uyac runagunaga Moises mandashca shimigunata mana yachashami caudsayachitucushca anaun, nisha chi amuguna piñasha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chasna rimanaupi shuc fariseo runa Nicodemo nishca chi fariseo muntunmanda ara. Paimi shuc uras tuta Jesushuan cuintangahua ric runa ara. Chi shuc fariseoguna chasna Jesusmanda rimanaupi pai randi nira, ");
INSERT INTO qvzNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ñáucanchi mandashcagunaibiga ninmi: Mana pitas caudsayachinata ushanchichu pai rimashcata ñaupa mana uyashallaga, imata pai rashcata yachangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nicodemo chasna rimacpi paigunarandi ninaura, Cambas Galilea partimandachangui. Ñáaupa Diospa shimita ricusha yachai, chibimi ricungui mana maican Dios rimashcata pasachic runahuas Galileamandaga shamushcachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chasna cuintashcahuasha caran runa paihua huasima rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Caran paiguna quiquin huasita rinaupi Jesusca randi Olivos nishca urcuta rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cayandi punzhayamuushcaibi Diosta alabana huasimallata bulltiara. Runaguna paita ricusha caillayacpi Jesus canzhai tiyarisha yachachicallarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chasna yachachiushcai Diospa shimita yachachic runaguna, chasnallata fariseogunahuas Jesusma apamunaura shuc huarmita pai ashiyachiushcai tupasha. Apamusha tucui runagunahua ñaupacpi shayachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Chasna rashcahuasha Jesusta ninaura, Tupashcanchimi cai huarmita pai ashiyachiushcai señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Huañuc Moises ñucanchima mandasha saquishcaga casna mara: Cai tunu huarmigunataga rumihuan tucsisha huanchina man nisha. Canga imasata ningui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chi runaguna Jesusta casna tapunaura paita camashun nishalla, pai imatas rimacpi caudsayachishun nisha. Randi Jesusca cumurisha paihua riruhuan allpaibi quillcaicallarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Chihuasha chara paiguna cutin cutin tapuupi, Jesus shayarisha paigunata nira, Maicanbas cangunamanda jucha illac ashaga punda rumita tucsichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chasna nishcahuasha cumurisha cutillata allpaibi quillcaicallarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Casna Jesus rimashcata uyasha shuc shuc ricallarinaura, pundaga chi mas rucugunami ringahua callarinaura. Tucuilla llucshishcahuasha Jesus chibi auc huarmihuan sapalla saquirishcara. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Shayarisha chi huarmita tapura, Maibitaunguna canda caudsayachiccuna, manachu pihuas caudsayachisha huanchitucushcangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tapucpi, Mana pihuas señor nira. Chasna nicpi Jesus paita nira, Ñáucahuas mana caudsayachishcanguichu. Cunanga rilla, randi ama cuti juchata ranguichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chihuasha Jesus cuti runagunata yachachisha nira, Ñáucaga shuc bilacuinta mani cai mundui causac runagunahuacpi punzhayachic. Maicanbas ñucata catic runaga ñucashinallatami punzhaicuinta puringa, chimanda ñaupagma mana ansaibicuinta puringachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chasna yachachicpi fariseoguna piñasha paita ninaura, Canga quiquinmandallata rimaungui. Canmandallata chasna rimaushcacpi mana imaschan. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus randi cutipara, Ñáuca rimashcaga balinmi ñuca quiquinmandallata rimashallata. Ñáucaga yachanimi maimanda shamushcata, maita riushcatahuas, randi cangunaga mana chita yachanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Cangunaga runa yachaimandalla caudsayachinguichi, randi ñucaga mana pitahuas caudsayachinichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ima uras ñuca caudsayachisha taripashaga cuscatami taripanima. Chasnallata mana ñucallaga taripanichu, randi ñucata cachamuc Yayami ñucahuan pariu taripan. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Cangunata mandashca shimigunai casna nisha quillcashcami tiyan: Ima uras ishcai (2) runaguna pariu chasnallata rimacpiga, paiguna rimashcaga baligmi nishca. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chasna acpiga ñucallatami shuc rimac ani ñucaraicullata, chasnallata ñucata cachamuc Yayahuas ñucamandaga rimaun nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chasna nicta uyasha chi runaguna cutillata tapunaura, Maibitaun camba yayaga. Tapucpi Jesus paigunata cutipara, Canguna ñucataga mana ricsihuanguichichu, chasnallata ñuca Yayatahuas mana ricsinguichichu. Astahuanbas canguna ñucata ricsishaga ñuca Yayatahuas ricsinguichimami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus tucui caigunata yachachira Diosma cushca cullquita churana cajunguna ashca aushcai. Chasna yachachishcamanda israel amuguna paita piñagllaita mana pihuas paita japisha caudsayachingahua aparachu pai huañuna uras chara mana pactaushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus cutillata israel amugunata rimasha casna nira, Ñáucaga ña caimanda ringamirauni, Cangunaga mascahuangamiraunguichi, randi cangunaga canguna juchallaita huañunguichi. Chasna ashami ñuca riushcama cangunaga mana shamunata ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nicta uyasha israel amugunapura rimanacunaura, Imasata ninya ñuca riushcama cangunaga mana shamunata ushanguichichu ninmi. Pai quiquinllatachu huañurinata munan nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus mas rimara, Cangunaga cai mundumandami anguichi, ñuca randiga mana cai mundumandachani, astahuanbas jahuapachamanda mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ñáuca acta canguna mana quirishcamandami canguna juchaibi huañunguichi nishaga rimarani. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chasna nicpi chiguna tapunaura, Canga pitanguiya. Tapucpi randi nira, Imahuata cangunataga cuintasha. Ñáuca pi actas ña pundamandapacha cangunata yachachishcashina ani. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Cangunata caudsayachinatas ashca cuintanatas ushani, randi chasna agllaita ñucata cachamuc rimashcallata uyasha rimani tucui runagunata. Paiga sirtuta rimac man. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nicta uyashallata chi runagunaga mana intindinaurachu Jesus paihua Yayamanda cuintaushcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chiraicumi Jesus casna rimara, Runa Tucuc nishcata canguna crus jahuaibi huarcushcaibimi asirtanguichi ñuca pi actaga. Chasnallata ñuca quiquin munaimandalla mana ractas, randi ñuca Yaya yachachishcallatami ñuca rimautas yachanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ñáucata cachamucca ñucahuan maun, ñuca Yayaga ima uraspas mana sapallaga saquihuashcachu pai munashcallata ñuca rac ashcaraicu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesus casna rimashcata uyasha ashca runaguna paita quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Paita quiric israel runagunata Jesus casna nira, Canguna ñuca rimashca shimigunata cadsusha causashaga sirtupacha ñucahua quiquin runaguna manguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chasna asha sirtu shimitahuas yachanguichimi. Chi sirtu shimimi cangunataga lugaryachinga nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Runagunarandi ninaura, Ñáucanchiga huañuc apayaya Abrahanmanda miraiguna manchi. Chasna ashami mana ima uraspas pi mandashcais huatashcacuinta causaccharanchi. Imasata ningui lugaryachishca manguichi nishaga rimangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus randi nira, Sirtupacha cangunata nini, tucui juchata rac runagunaga huatashcacuinta jucha mandashcai puriunguna. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Shuc mandashcai causac runaga mana huiñai pai amuhua huasibiga causangachu, randi churiga huiñaimi paihua yayahuan causanga. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chasna ashaga chi amuhua churi cangunata lugaryachicpimi sirtupacha lugarta charinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ñáa yachanimi canguna Abrahanmanda mirai ashcataga. Chasna ashahuas cangunaga ñuca rimashca shimigunata mana uyanata munashami huanchinata munahuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ñáucaga ñuca Yayahuan aushcai ricushcallatami rimauni. Randi cangunaga, canguna yaya mandashcatami ranguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nicpi uyasha ninaura, Abrahanmi ñucanchi yayaga ara. Randi Jesusca nirami, Canguna sirtupacha Abrahanmanda mirai ashaga pai rashcallatatami ranguichima. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Chasna agllaita Dios sirtuta yachachihuashcata ñuca cangunata rimaushcamandami huanchinata munahuanguichi. Abrahanga ima uraspas mana cangunashina rarachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Cangunaga cangunahua yaya rashcashinallatami ranguichi. Caita uyasha paiguna ninaura, Ñáucanchiga mana huairahuahuachanchi, shuc yayallatami charinchi Diosta. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus randi cutipara, Diosmanda shamushami caibi auni. Mana ñuca yuyaimandallachu shamushcani, astahuanbas Diosmi cachamuhuashca. Chasna acpi canguna sirtupacha Diospa churiguna ashaga llaquihuanguichimami. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Imahuata ñuca yachachishcataga mana intindinata munanguichi. Ñáuca rimashca shimigunata mana uyanata munashallami mana intindinguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Supaimi canguna yayaga an, cangunaga paihuac manguichi, chiraicumi pai munashcata ranata munanguichi. Supaiga callarimandapachami runata huanchic ashca. Paihuacpi sirtu shimita mana tiyashcamandami mana sirtutaga rimacchan. Paimandami llullaga callarira, cunangama paiga llulla man. Chiraicu pai llullagunata rimausha pai quiquin llulla aushcallata ricuchin. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Randi ñucaga sirtuta rimacpimi canguna mana quirihuanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Maican cangunamanda ushahuanguichichu maibi ñuca juchayashcataga ricuchingahua. Randi ñuca sirtuta rimacpihuas imahuacta mana quirihuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diosmanda ac runaga Diospa shimigunata uyac man. Randi cangunaga mana Diospa runaguna ashami paihua shimita rimauctaga uyanatas mana munanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chasna rimacpi israel amuguna Jesusta piñasha ninaura, Canga mana balic samaria runa mangui, chasnallata shuc chupayuc supaimi angui nishaga sirtutami rimanchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus cutipara, Mana ima supaitahuas charinichu. Chi ñuca Yayata balichinami ñuca ranaga an, cangunaga randi mana balichihuanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ñáuca ñucallatas balichirinataga mana munanichu, chasna agllaita ñuca Yayaga munanmi canguna ñucata balichihuanauchun nisha. Paiga canguna rashcagunata taripac man. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sirtupachami cangunata nini maicanbas ñuca rimashca shimigunata cadsucca mana huañungachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Israel amuguna cutipanaura, Cunanga ña yachanchimi can chupayuc supai ashcataga. Abrahanbas chasnallata tucui Dios rimashcata pasachiccunahuas tucuilla huañushcaunami. Chasna agllaitachu canga, maicanbas ñuca rimashca shimigunata cadsucca mana huañungachu nishaga rimaungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Canga ñucanchi huañuc apayaya Abrahanmanda mas yali balicchangui. Paihuas huañurami, chasnallata Dios rimashcata pasachiccunahuas huañunaurami. Pi mani nishata chasnaga rimangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tapucpi Jesus cutipara, Ñáucallata balichiricpi ñuca balichirishca shimiga mana imais balinzhu, yanga tucunya. Randi ñucata balichicca ñuca Yaya man, paimi cangunaga ñucanchi Dios man nisha niushcallata an. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Chasna nishahuas cangunaga paita mana ricsinguichichu, randi ñucaga ricsinimi. Ñáuca mana ricsinichu nisha rimashaga cangunashinallata llullaisiquimaima. Randi sirtupacha ñucaga Yaya Diosta ricsinimi, chiraicumi pai rimashca shimigunataga cadsuni. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Canguna apayaya Abrahanga cushiyarami ñuca cai pachama shamungaraushca punzhata yachasha. Ñáa ñuca shamucta ricushami yapa cushiyara. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chasna nicpi israel amuguna Jesusta asisha ninaura, Chara mana pichca chunga (50) huatallatahuas charishallatachu Abrahanda ricushcanimi nishaga rimangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus paigunata cutipara, Sirtupacha cangunata nini, ñucaga Abrahan chara mana pagarishcallaitachu causauc arani. ");
INSERT INTO qvzNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chasna nicta uyasha rumigunata japinaura paita tucsisha huanchingahua, randi Jesus miticusha Diosta alabana huasimanda llucshira. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chihuasha chimanda llucshisha riushcai Jesus ricura shuc puyuñahui pagaric runata. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Paihua runaguna Jesusta tapunaura, Imahuata cai runaga puyuñahui pagarira señor, pihua juchamandata. Paihua yayaguna juchata rashcamandachu chasna saquirira, mana ashaga paihua quiquin juchamandachu chasna pagarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chasna nisha tapucpi Jesus paigunata cutipara, Cai runas ni paihua yayagunas mana juchata rashcamandachu casna tucura, randi Yaya Dios paihua ushaita cai runaibi ricuchingahuami casna tucura. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chasna acpiga chara punzha agllaitami tucui ñucata cachamuc Yaya ranagunatami rana anchi. Ñáa tuta shamuunmi mana pihuas tarabaibacchu tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ñáuca chara cai pachai aushcaiga runagunata punzhayachic bilacuinta mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesus casna rimashcahuasha tiucasha, allpata turuyachisha llutara chi puyuñahui runahua ñahuibi. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chasna llutashcahuasha chi runata nira, Risha maillarigri Siloe nishca yacu pugruibi nira. (“Siloe” nishaga paiguna shimibi Dios Cachamushca nin). Chi runa risha maillarishcahuasha ña ricuc tucusha cutillata shamura. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ñáa paihua huasi mayanbi causac runaguna, chasnallata cullquita pai tapusha puric acta ricuc runagunas paigunapura cuintanacuunaura, Caiga manachu an chi cullquita tapusha tiyac runaga nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Shuccuna ninaura, Indá chi runallatami an. Randi shuccunaga ninaura, Mana, chi runashinallata ricuric ashallata mana paichan. Randi chi janbiric runaga nira, Indá ñucallata mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chasna pai amullata nicpi tapunaura, Imasata cunanga ña ricuc angui. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chi runa casna cuintara, Chi Jesus nishca runami ansa turuta rasha ñuca ñahuibi llutashami nihuara Siloe nishca yacu pugruma risha maillarigri. Ñáuca risha maillarishcai ña ricuc tucurani. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chasna cuintacpimi tapunaura, Cunanga maibitaun chi runaga. Pairandi, Mana yachanichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesus chi puyuñahui runata turuhuan llutasha pai janbishca punzhaga israel samana punzha mara. Chiraicumi chi runagunaga chi janbiric runataga fariseogunahua ñaupacpi apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseoguna paita tapunaura, Imasata cunanga ña ricunata ushangui. Chi janbiric runa cutipara, Paimi turuta ñuca ñahuibi llutahuara, chihuasha ñuca ñahuita maillarirani, ña cunanga ricuni. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Maican fariseoguna ninaura, Caita rac runaga samana punzhata mana balichisha tarabashcamandami mana Diosmanda runachan. Randi shuccunaga ninaura, Pai juchayuc runa ashaga imasata casna Diospa ushaihuan ranataga ushanga. Chasna nishami paigunapurallata ishcai yuyaita surcunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Cutillata tapunaura chi puyuñahui janbiric runata, Canda casna janbic runamanda canga imasata ningui. Pai randi cutipara, Dios rimashcata pasachic runa man ninimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Israel amugunaga chi runa ñaupa puyuñahui ac cunan ña janbirisha ali ñahuiyuc ashcataga mana quirinata munanaurachu. Chiraicumi paihua yayagunata cayachisha ");
INSERT INTO qvzNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","paigunata tapunaura, Caiga canguna churichan, sirtuchu puyuñahui pagaric ara, chasna ashaga imasata cunanga ña ricunata ushan. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chi janbiricpa runahua yayaguna cutipanaura, Sirtu yachanchimi cai ñucanchi churi puyuñahui pagaric ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Randi mana yachanchichu imasata cunanga ricuc tucushcata, pi paita janbishcatahuas mana yachanchichu. Paillatata tapuichi ña rucu man, paillatami imasna actahuas cuintanga. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chi janbiric runahua yayagunaga manzharishallami chasna ninaura. Israel amugunaga paigunapuralla yuyarishca anaura casna nisha, maican runatas Jesusca Dios cachashca Cristo nishca quishpichic man nisha rimac runataga ñucanchi tandarina huasimanda llucshichisha cachangahua nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chasna manzharishcamandami paihua yayaguna ninaura paillatata tapuichi ña rucu man nishaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fariseoguna chi runata cutillata cayasha ninaura, Cunanga Diospa ñaupacpi sirtuta ñucanchita cuintai. Ñáucanchiga yachanchimi chi runa juchayuc runa ashcataga. Imata ningui can. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Rimacpi chi janbiric runa cutipara, Chi runataga mana yachanichu pai juchayuc actas, mana juchayuc actas. Ñáuca yachanimi ñaupaga puyuñahui ashcata cunanga ricuc ani. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Cutillata tapunaura, Imatata raitucurangui, imasata rara camba ñahuita janbingahuaca. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chi runa cutipasha nira, Ñáa cangunata ñaupata rimaranimi randi mana uyahuaranguichichu, imahuata cuti cuti rimanataga munanguichi. Cangunahuaschu paita catishun ninguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Casna chi runa nicpi fariseoguna piñasha camisha ninaura, Canga chi runatami catic angui, randi ñucanchiga Moises mandashcagunatami caticcuna anchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dios Moisesta rimashcataga yachanchimi, randi chi runa maimanda pai shamushcatahuas mana yachanchichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chi janbiric runa cutipara, Sirtupacha caiga manzhanayacta man, canguna pai maimanda shamucta mana yachagllaita randi ñucataga janbisha ricucta rahuashca. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sirtutami yachanchi Diosca juchayuc runagunataga mana uyacchan, randi paita alabasha pai munashcata raccunallatami uyan. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mana ima uraspas uyashcanchichu maicanbas shuc puyuñahui pagaric runata janbishcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cai runa mana Diosmanda shamushca ashaga mana imatahuas ranata ushanmachara nisha chi janbiric runa nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chi fariseoguna randi ninaura, Can juchasapa runa pagaric ashallatachu ñucanchitaga yachachinata munanguiya. Chasna nishcahuasha chi israel tandarina huasimanda chi runata llucshichisha callpachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chi janbiric runata fariseoguna callpachishcata Jesus yachasha, paita tupagrishcai tapura, Quiringuichu canga Runa Tucuctaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chi runa cutipara, Cuintahuai señor, pi tan chi runaga ñuca paita quiringahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nicpi Jesus nira, Ñáa paita ricushcanguimi, ñuca mani canhuan cunan cuintanacuc. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Caita uyasha chi runa Jesuspa ñaupacpi cungurisha nira, Quirinimi señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chihuasha Jesus nira, Ñáucaga runaguna imasna causashcatas ricuchingahuami cai pachama shamushcani. Chasna acpimi mana ricuccuinta ani niccunaga ricungaunami, randi ricuc ani niccunaga puyuñahuicuinta tucungaunami. Chiraicumi shamurani. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesus ña casna rimaushcata maican auc fariseoguna uyasha paita tapunaura, Ñáucanchihuas puyuñahui chanchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus cutipasha nira, Puyuñahui canguna ashaga canguna juchagunamandaga mana culpata charinguichimachu. Randi canguna ricuc manchi nishcamandami culpayuc anguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Chihuasha Jesus rimasha nira, Sirtupacha cangunata nini, maicanbas pungumanda oveja cularbi mana yaicusha shuc partimanda sicashaga shuhuaccuna man. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Randi pungumanda yaicuc runaga ovejata cuirac runa an. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Punguta cuirac runa pascacpi ovejagunata cuirac runaga caran ovejata paiguna quiquin shutibi cayacpi paihuan cularmanda llucshinaun. Amu rimacpi ovejaguna paihua shimita asirtanaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ñáa tucui paihua ovejaguna cularmanda llucshishcai amuga ovejagunahua ñaupacpimi riun, ovejagunaga amu rimashcata asirtashcamanda paita catinaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Randi shuc mana ricsiushcataga mana catinaunzhu. Paita uyasha miticunaunmi paihua shimita mana asirtashcamanda, nisha Jesus cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus casna pai pi ashcatas asirtachingahua casna cuintaura, randi chi uyaccunaga mana intindinaurachu imata pai yachachishcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus cutillata rimasha nira, Caitaga sirtupachami cangunata rimani, ñucami ovejaguna yaicuna pungucuinta ani. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tucui ñucamanda ñaupata shamuc runaga shuhuasha huaglichic accuna manaura, randi ñuca ovejagunaga paigunata mana cadsunaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ñáucami pungucuinta ani. Ñáucamanda yaicugllami quishpiringauna anga. Chasna asha paiguna yaicuusha llucshiusha ali micunata tupaccuinta angauna. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Shuhuac runaga shamunmi shuhuangalla, huanchingalla, huaglichingalla. Randi ñucaga shamushcanimi ovejaguna ali causaita jundacta charinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ñáucaga ovejagunata alita cuiraccuinta ani. Alita cuirac amuga ovejagunamanda paihua quiquin huañunatas mana manzhan. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Randi cullquita nishalla tarabac runaga chi ovejagunahua mana quiquin amu asha mana alita cuiracchan. Shuc puma shamuuta ricusha ovejagunataga saquishami miticun. Chasna acpi chi puma micungahua shamusha tucui sáa sáa callpachic shamunga. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chi runaga cullquita nishalla tarabac ashami ovejagunata mana llaquishami miticusha jichusha rinlla. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ñáucaga ovejagunata alita cuiracshina mani. Ñáuca Yaya ñucata ricsishcacuintami ñucahuas paitaga ricsini. Chicuintallatami ñuca ovejagunatas ricsini, chasnallata paigunahuas ñucatas ricsihuanaunmi. Ñáucaga ñuca quiquin huañunatas mana manzhanichu paigunata quishpichingahua huañushami. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chasnallata shuc ovejagunatacuinta charinimi, mana cai cularmanda accunata, paigunatahuas caimallata apamuna ani. Paigunahuas ñuca shimita uyahuangaunami. Chasna tucusha shuc muntunlla anga, chasnallata shuc amullahuan anaunga. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ñáuca quiquin causaitas paigunaraicu cusha huañushcamandami ñuca Yayaga llaquihuan. Ñáuca huañushahuas cuti causarishami. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mana pihuas ñucata huanchinataga ushahuangachu, randi ñucallatami japitucusha huañusha. Ushaitaga charini huanchitucungahuas, chasnallata cuti causaringahuas. Chasna tucuchun nisha ñuca Yaya mandahuara. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Casna Jesus rimashcata uyasha israel amuguna rimanacusha cutillata ishcai (2) muntun tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ashca runaguna casna ninaura, Cai runaga supaita charisha nuspa actaga imangahuata uyaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Randi shuccunaga ninaura, Mana pihuas supaita charic runaga mana casnaga rimanata ushanmachu. Puyuñahuiyucta janbinata supaiga mana ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tamia uraspi Jerusalen llactaibiga Diosta alabana jatun huasita paiguna rashcata yuyarisha jistaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chi uras Diosta alabana huasi partibi Salomon rashca pambai Jesus puriura. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chasnaibi israel amuguna caillayamusha tapunaura, Ima urascamata casna can pi ashcata mana pagllai rimasha ñucanchitaga catingaraungui. Sirtu can Quishpichic Cristo ashaga shurai pagllai rimai. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chasna nicpi Jesus paigunata cutipasha nira, Ñáa cangunata rimagllaitami mana quirihuaranguichi. Ñáuca Yayahua ushaihuan ñuca rashcagunami pi ñuca ashcataga pagllaibi ricuchinaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Randi canguna mana ñuca ovejacuinta muntunmanda asha mana quirihuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ñáuca ovejacuinta runagunaga ñuca rimashca shimita uyaungunami. Ñáucahuas paigunata ricsini, chiraicumi paigunaga catihuanaunlla. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ñáucami huiñai causaita paigunataga cuni, chasnamandami mana ima uraspas huañungaunachu. Chasnallata ñuca maquimanda mana pihuas paigunataga quichuhuangachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Paigunata ñucama cuc Yaya tucuimanda yalimi an, chasna acpi mana pihuas paimandaga quichunata ushanzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ñáuca Yayahuan ñucahuanga shuglla manchi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Israel amuguna caita uyasha cutillata rumigunata japinaura paita tucsisha huanchingahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Japicpi Jesus randi tapura, Ñáuca Yayahua ushaimandami canguna ñaupacpi ashca ali ranagunata rashcani. Maican ñuca rashcagunamandata rumigunahuanga tucsishun ninguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tapucpi amuguna cutipanaura, Mana chi ali rashcagunamandachu candaga tucsinchi. Randi can rimashca shimigunamandami tucsingamiraunchi. Canga yanga runa ashallatami canllata Dios tucuungui, chasna acpi paita camishcamandami canda tucsina anchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Cutillata Jesus nira, Canguna charishca Moises mandashca shimibi manachu casna nisha quillcashca tiyaun casna Dios nishcata: Canguna dioscuna nishca manguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Diospa shimibi quillcashca tiyaccunataga mana balinzhu nisha rimanataga mana ushanchichu. Ñáa Diosllami paihua shimita rimaitucushca runagunataga dioscuna manguichi nishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Diosmi ñucataga japisha cai pachama cachamuhuara, chasna ashami Diospa Churi mani niuni. Ñáuca chasna nicpi imangahuata Diostaga camingui nisha nihuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ñáuca Yaya rashcagunatacuinta ñuca mana racpiga ama quirihuaichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Randi ñuca Yaya rashcagunata ñuca racpiga, ñuca quiquinda mana quirishahuas ñuca rashcagunata ricusha quirina anguichi. Chita quirishaga ñuca Yaya ñucahuan causauta, ñucahuas ñuca Yayahuan causautami alita yachanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesus chasna rimacta uyasha cutillata japisha apanata munanaura, randi Jesus paiguna maquimanda quishpisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chimanda llucshisha Jordan yacu chimbamallata bulltiasha chibi saquirira, Juan ñaupa bautisaushca lugarbi. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ashca runaguna Jesusta pai aushcaibi ricugrisha rimanacunaura, Sirtupacha Bautisac Juan pihuas mana raushcagunata rac ashahuas, tucui cai runamanda pai rimashcaga sirtu mashca. ");
INSERT INTO qvzNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chi lugarbi ashca runaguna Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chi uras tiyara shuc ungushca runa Lazaro nishca. Paimi paihua panigunandi, shucca Maria shucca Marta, Betania nishca llactaibi causauc anaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Cai huañuu Lazarohua pani Mariami Señor Jesuspa chaquibi asnarina yacuta churasha paihua acchahuan chaquichicca ashca. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Turi ungucpi chi paniguna casna nisha rimangahua cachanaura, Can llaquishca amigoga ungushca maun señor nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus casna rimacachashcata uyasha nira, Cai ungüiga mana paita huanchingachu, randi casnamandami Diosta yapa balichishca tucungamiraun paihua ushaita ricuchishcamanda, chasnallatami cai runa ungüimanda Diospa churihua ushaita ricuchicpi balichishcami tucuhuanga nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martatas, paihua ñañatas, chasnallata Lazarotahuas Jesus yapa llaquic ashallatami ");
INSERT INTO qvzNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","chara ishcai (2) punzhata saquirira pai aushca lugarllai, Lazaromi ungushca an nisha cuintacshamucpihuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chihuasha paihua runagunata nira, Jacuichi cutillata Judea partima. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Paihua runagunarandi ninaura, Cunanlla chi partibi israel amugunaga cadsi rumihuan tucsisha huanchitucurangui señor. Cutillatachu chima rinata munangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tapucpi paigunata nira, Manachu shuc punzha chunga ishcai (12) urata charin. Chasna acpi punzhai puric runaga mana mictiashachu purin punzha acpi. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Randi shuc runa tuta purishaga mictianmi mana punzhashinacpi. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chihuasha chasnallata rimara nisha, Ñáucanchi llaquishca amigo Lazaroga puñuushcami, randi cunanga ñuca nicchachingahuami riuni. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chasna nishcata uyasha paihua runaguna ninaura, Pai puñushca ashaga ña aliyasha causaringami señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Randi Jesus paigunata nishcaga arami Lazaroga huañushca man. Chi runaguna yuyanaurami Lazaro puñushcatachari niun nisha, randi Lazaroga ña huañushcami nisha Jesusca chasna nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chiraicumi chihuasha Jesus paiguna yachachun nisha pasacta rimara, Lazaroga huañushca man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Chibi ñuca mana aushcamanda cushiyanimi, casnami mas ali an canguna mas ñucata alita quiringahua. Cunanga jacuichi ricugrishunchi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pai shuc japishca runa Tomasca, chasnallata Culluru nishca shutichishca ara ishcai (2) huahua pariu llucshic ashcamanda. Paiga Jesus chasna rimashcata uyasha chi shuccunataga nira, Ñáucanchihuas jacuichi Jesushuan pariu huañungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus Betania llactaibi pactashcai Lazaroga ña chuscu (4) punzha pambashca ashcara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Chi Betania nishca llactaga Jerusalen larulla mayanlla ara quimsa (3) kilometro tupulla. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chasna acpi ashca israelgunami Jerusalen llactamanda llucshisha rishca anaura Martata, Mariatas cumpañangahua paiguna turi huañushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus chi llactama pactashcata uyasha Marta paita tupangahua rira, randi Mariaga huasillai saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesusta tupasha Marta paita nira, Ai señor, can cai aushca acpiga ñuca turiga mana huañupanmachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Chasna agllaita ñuca yachanimi cunanga can tucui Diosta tapushcatami cuitucungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chasna nicpi Jesus nira, Camba turi causaringami. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta randi nira, Sirtu man tucurishca punzhai tucui huañushcaguna causarinaupi paihuas causaringaraushcata yachanimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus randi cutipara, Ñáucaga causachic ani, causaitas cuc ani. Maicanbas ñucata quiricca huañushahuas cuti causarinaungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tucui ñucata quirisha causaucuna ima uraspas mana huañungachu. Caitaga quiringuichu Marta. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tapucpi Marta randi paita cutipara, Indá, chasna man señor. Canga cai munduma shamuna Quishpichic Cristo nishca Diospa churi ashcataga quirinimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chasna rimashcahuasha Marta paihua ñaña Mariata cayagrira itsalla rimagrisha, Señorga caibi maun, candami cayaun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chita uyashca ratullaita Maria uctalla jatarisha Jesusta tupanacungahua llucshisha rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus chara chi llactama mana yaicumushcachu, Marta paita tupagrishcallaitami chara aushca ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ñáa Maria huairashina jatarisha llucshishcata ricusha chi cumpañangahua shamuc israel runagunaga pambashcai huacangahua riun nisha yuyarishami paita catisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariaga Jesus aushcama pactasha paihua chaqui mayanbi cungurisha nira, Can caibi aushca acpiga ñuca turiga mana huañunmachara señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus Maria huacashcata ricusha, chasnallata Mariata catisha shamuc israelgunahuas huacashcata ricusha, paihua shungu ucui ashcata sintirisha llaquirira. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chasna acpi paigunata tapura, Maibita pambaranguichi. Tapucpi, Ricucshamui señor ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ricugrisha Jesus huacara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jesus huacashcata ricusha israel runaguna ninaura, Ricuichi, manapacha paiga Lazarota yapatami llaquic ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Randi shuccuna cuintanacunaura, Cai runaga puyuñahui runatahuas janbic ara, manachu imatahuas ranata ushara Lazaro ama huañuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lazaro pambashcama Jesuscuna risha pai cutillata ashcata llaquirisha caillayara. Shuc urcui allashca juctu mara, chi juctu pungutaga shuc jatun rumihuan tapashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus paihuan riccunata mandasha nira, Chi rumita anchuchichi. Chi huañucpa pani Marta nira, Chuscu (4) punzha man pai huañushcaga, ña jiridsa asnac anga señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nicta Jesus rimara, Manachu canda nirani, can quirishaga Diospa ushaita ricunguimi nisha rimarani. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jesus mandashcata pactachisha chi rumita anchuchinaura. Chihuashami Jesus jahuama ricusha nira, Canda pagrachu nini Yaya, ñuca tapushcata can uyashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tucui uras ñuca tapushcagunata can uyashcata yachanimi, randi caibi auc runagunaraicu caitaga ninimi, can ñucata cachamushcata paiguna quirinauchun nisha canda rimarani. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Casna rimashcahuasha pai sinzhita caparira, Lazaro chimanda llucshi. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chi ratullatami chi huañushca runaga llucshira. Paihua maquindi chaquindi chara llachapa pitigunahuan pillushca ara, paihua umais shuc linsu llachapahuan pillushca ara. Llucshimucta ricusha Jesus nira, Pascaichi pai purichun. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesus chasna Lazarota causachishcata ricushami Mariata cumpañasha ric israelgunaga ashcaguna Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Randi shuccunaga fariseogunahuagma risha paigunata cuintanaura Jesus imasna rashcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chita uyasha fariseoguna, pagrihua amugunandi tucui mandac amugunata tandachisha ninaura, Cunan imatata rashunchi. Cai runaga pihuas mana rashcagunata rasha ashca ushaita ricuchisha purin. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ñáucanchi mana imatas rasha saquicpiga tucuimi paita quirisha nisha catingaraunguna. Chasna tucucpiga mandac Roma llactamanda sundaluguna shamusha ñucanchi Diosta alabana huasita huaglichingaunami, ñucanchitahuas huanchisha tucuchingaunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chasna manzharisha ninaupi paigunamanda shucca rimara. Paiga Caifas nishca ara, chi huataibi israel pagrigunahua jatun amu ac ara. Casna paigunata nira, Imatas mana yachacchanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ñáucanchi cai llactai causaccuna ama tucuilla huanchitucungahuaca shuc runalla huañuchun nira. Chasna tucucpi mas ali anga. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifasca chitaga mana paihua quiquin yuyaimandallachu rimara, astahuanbas pai chi huatai pagrigunahua jatun amu ashami Dios paita yuyachishcatami rimara imasna tucui israel runaguna randimanda Jesus huañungamiraun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chasnallata mana-israel llactai causaccunamandalla huañunachara, astahuanbas intiru mundui aucuna maibi causaccunahuas Diospa churiguna tucusha tucui shuglla tucuchun nisha paiga huañuna ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Casnami chi punzhamandapacha israel amugunaga Jesusta huanchishun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chiraicumi Jesusca ña mana mas pagllai puric ara, randi Judea partimanda llucshisha chaquishca pamba mayanma Efrain nishca llactama rira. Chibimi saquirira pai japishca runagunahuan. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israelguna pascua nishca jistata rana punzha pactaringahua ña ashilla pishishcai, ashca runaguna caran llactamanda Jerusalenma ñaupata shamunaura mandashcagunata pactachingahua, Diospa ñaupacpi ali tucushun nisha jista chara mana callarigllaita. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Paiguna Jesusta mascasha puriusha, Diosta alabana huasi pagllai pariu ausha, paigunapura itsanlla tapunacuunaura casna nisha, Imasata cangunaga ninguichi, pai jistamaga shamungachu u manachu shamunga. Imatata ninguichiya. ");
INSERT INTO qvzNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseoguna, pagrihua amugunandi urdinda cushca anaura casna nisha, Maican runahuas maibi Jesus auta yachashaga rimanauchun ñucanchi paita japisha caudsachingahua nisha mandanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua nishca israel jista chara sucta (6) punzha pishicpimi Jesus rira Betania llactama, chibi pai causachishca Lazaro causaushca llactama. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chi huasibi Jesusta yapa llaquishcamanda shuc micunata ranaura. Martaga micunata caraura, randi Lazaroga Jesushuan pariu mesaibi tiyarisha micuura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chasnaibi Maria apamura shuc chaupi litro tuputa nardo nishca yapa balic asnarina yacuta, caihuan Jesuspa chaquita armachisha paihua acchallahuanda chaquichira. Chasna racpi chi huasi intiru gustu asnac tucura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chasna tucucpi Jesus japishca runapuramanda paita huasha japichingarauc Judas Iscariotega Maria rashcata ricusha nira, ");
INSERT INTO qvzNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Imahuata cai asnarina yacuta mana randichinauraya ashca cullquihuan pugrigunata yanapangahuaca. Caiga ña shuc huata intiruta tarabasha ganashca tupu cullqui balinmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas casna rimasha mana pugrigunata llaquishcamandachu nira, randi pai shuhua ashami chasnaga nira. Pai cullqui bultsata apasha puric ashami runaguna yanapashun nisha cushca cullquita japisha shuhuagara. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus randi paita nira, Saqui ama chasna rimaichu. Mariaga cai gustu asnarina yacutaga huacaichiura ñuca huañusha pambarina punzharaicu. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pugrigunataga tucui urasmi canguna charinguichi, randi ñucataga mana unaitachu charihuangaraunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ashca israel runaguna Jesus Betaniaibi aushcata yachasha chima rinaura, mana Jesusllata ricungahua, randi Jesus causachishca Lazarotas ricushun nisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lazarota causachicpi ashca israel runaguna Jesusta quirinaura, israel pagrigunatas saquisha paiguna Jesusta catic tucunaura. Chasna tucucpi chi israel pagri amuguna Lazarotahuas huanchishun ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ashca runagunami rishca anaura Jerusalenma pascua jistaraicu. Cayandi punzha yachanaura Jesus Jerusalenma shamusha pactamungarauta. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chiraicumi runagunaga paita mandac amutashina rasha pangayuc ramagunata pitisha Jesusta tupagringahua rinaura casna caparisha, Yaya Dios yapa ali anmi. Dios cachashca shamuc ashami balichishca achun Israel llactata mandac amuga. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus ña shuc malta burrota tupasha jahuai tiyarira Diospa shimibi quillcashca tiyaccuintallata: ");
INSERT INTO qvzNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sion nishca Jerusalen llactai causaccuna ama manzhaichichu. Ricuichi, canguna amumi shamuun, shuc malta burro jahuai tiyarisha shamuun, nishca. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pundallaga Jesus japishca runagunaga mana intindinaurachu caigunata ricushahuas. Randi Yaya Dios jahuapachama Jesusta apasha sumagyachishcahuashami yuyarinaura tucui cai Jesus pasashcagunaga paimanda casna quillcashca tiyac ashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazarota pambashcamanda Jesus cayasha causachishcai auc runaguna cuintasha puriunaura tucui paiguna ricushcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chiraicumi ashca runagunaga Jesus chi pihuas mana raushcata jatun rashcamanda cuintashcata uyasha paita ñambii tupangahuaca Jerusalenmanda llucshinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Randi fariseogunaga paigunapura cuintanacunaura, Ñáa ricunguichichu, tucui runagunami paihuan rinaun, casnaga mana imatahuas ranata ushangachu raunchi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chi jista uraspi Diosta alabangahua Jerusalen llactama ashca runaguna rinaura. Chi muntunmanda maicangunaga mana-israel griegoguna manaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cai runagunaga Felipema caillayasha ruganaura pai Galilea partimanda Betsaida nishca llactamanda acpi, Jesustami ricunata munanchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chita uyasha Felipe risha Andresta rimara, chihuasha ishcandi Jesusta cuintagrinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chiguna rugashcata rimacpi Jesus paigunata nira, Ñáuca Runa Tucuc asha huañushcahuasha jahuapachama sumacta raitucuna uras ña pactariunmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sirtupacha cangunata nini, Shuc trigo muyu mana allpa ucui urmasha chingarishaga, mana mirarinzhu, chara pailla tiyan. Randi chingarishaga ashcata miraringami. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chasnallata maicanbas paihua quiquin causaita cai munduibi mana llaquishaga, quishpisha huiñai causaita charingami. Randi cai mundu causanallata llaquiushaga huiñai chingarishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maicanbas ñuca mandashcata ranata munac runaga catihuanalla manguichi. Chasnallata ñuca maibi aupihuas chibi paihuas angami. Chasnallata ñuca Yaya paitaga llaquingami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesus mas rimasha catira, Ñáuca shungu ucuibi yapa ashca llaquirishcata sintini. Chasna acpihuas imatata nisha. Cai llaquirinamanda quishpichihuai Yaya nishachu rimasha. Mana, mana chasna rimashachu. Chasna tucungahuami shamushcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cunanga can yali ushaiyuc ashcata ricuchipai Yaya. Casna Jesus rimashca ratullai jahuapachamanda shuc shimi uyarira, Ñáucaga ña ñuca ushaita ricuchishcani, chasna ashahuas cutillata ricuchingarauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chibi auc runaguna uyasha ninaura, Rayu man nisha. Randi shuccunaga ninaura, Shuc angelmi Jesusta rimaitucun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Randi Jesus nira, mana cai rimashca shimiga ñucaraicuchu uyarira, astahuanbas canguna yachangahuami mara. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mundui ac runagunata taripana punzhaga ña pactarimuunmi. Cunan urasllai cai munduta mandactaga binsishca tucungamiraun. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Randi ñucaga huarcushca asha tucuigunatami ñucahuagmallata apamushami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Casna rimashami imashina pai huañungaraushcata rimaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chita uyasha runaguna cutipanaura, Diospa shimibi quillcashcata uyasha yachanchi Quishpichic Cristoga huiñaitami causanga. Chasna acpi imasata canga Runa Tucucca jahuai huarcuitucusha huañunga nishaga rimangui. Pitan chi Runa Tucucca. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus randi paigunata nira, Punzhayachic bilacuinta cangunahuanga mana unaitachu aungarauni. Chasna acpi canguna chi bila punzhaglla aushcai purichi tutai cangunata ama cungaimanda japingahua. Chi ansa tuta puriushcaishina juchai puric runaga mana yachanzhu maita pai riushcatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chi punzhacuinta ñuca cangunahuan caibi augllaita ucta quirihuaichi nira. Chasna quirishami punzhaicuinta cangunas causanguichi nira. Tucui caita rimashcahuasha Jesus paigunamanda llucshisha pacashcacuinta rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus chasna pihuas mana rashcagunata yapa ushaihuan paiguna ñaupacpi rashca agllaitami paita mana quiric anaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chasna paiguna mana quiricpi Dios rimashcata pasachic runa Isaias nishca quillcashcaga pactarina mara casna nisha: Ñáucanchi camachishcata mana pihuas quirinatas munanzhu señor. Dios yapa ushaita charictaga ricuchishallata pihuas mana ricunata munanzhu nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chasna acpimi mana quirinata ushanaura. Chimanda Isaias chasnallata shucpi quillcara: ");
INSERT INTO qvzNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diosmi paiguna ñahuigunata puyuyachira ama ricunauchun nisha, paiguna yuyaitahuas sinzhiyachira ama intindinauchun nisha. Chasna rashcani paiguna ñucama ama bulltiamunauachun nisha ñuca paigunata ama janbingahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaias chasna Jesusta sumagyachishcata ricushcamandami paimanda chasna cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chasna agllaitami ashca israel runaguna Jesusta quirinaura, maicangunaga mandac runaguna manaura. Chasna ashallatami mana pagllai rimac anaura fariseogunata manzhasha, israel tandarina huasigunamanda ama callpachishca tucungahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Cai runagunaga Yaya Dios balichishcata munanarandimandami runaguna balichihuachun nisha mas munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chihuasha Jesus sinzhi shimihuan rimara, Maicanbas ñucata quiric runaga mana ñucallatachu quirin, astahuanbas ñucata cachamuc Yayatahuas quirinmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maicanbas ñucata ricuc runaga ñucata cachamuctahuas ña ricunmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ñáucami punzhayachiccuinta ani. Cai munduma shamushcani maicanbas ñucata quiric runaga ama ansaibicuinta saquirichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Randi ñuca rimashca shimigunata uyashallata mana cadsuc runataga taripaitucushcai, mana ñucaga taripashachu. Ñáucaga mana taripasha cashtigangahuachu cai pachama shamurani, astahuanbas quishpichingahuami shamurani. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Maicanbas ñucata mana gustasha, ñuca rimashca shimigunatas mana cadsuc runaga ña taripanata charin. Ñáuca rimashca shimigunami puchucai punzhaibiga paita taripasha cashtigangauna. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ñáucaga mana ñuca quiquin yuyaimandallachu rimani. Ñáucata cachamuc Yayami mandahuara tucui ñuca rimasha yachachichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ñáucaga yachanimi ñuca Yaya mandashca shimigunaga huiñai causaima apan. Chiraicumi ñuca rimashaga ñuca Yaya mandahuashcatatami rimani nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua nishca jista punzha cayandillata ashcaibi Jesus pai ña cai pachata saquisha paihua Yayahuan cutillata tiyangahua rina uras ña pactarishcata yachashca. Paiga paihuaccunataga tucui urasmi llaquishca ara, chasnallatami huañuna punzhagamami llaquira. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chi uras Jesus paihua runagunandi micusha tiyanaura. Supaiga ña Simon Iscariotehua churi Judaspa yuyaibi Jesusta japichina yuyaitaga churashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusca ña yacharami pai Diosmanda shamushcataga, pai Diosmallata bulltiangaraushcata, chasnallata paihua Yaya tucui ushaita cushcatahuas tucuilla mandachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chiraicumi paiguna micuushca mesamanda jatarisha paihua capata llatanasha shuc llachapa pitita huicsaibi anacurira. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chihuasha yacuta shuc lavacarashinai churasha, pai japishca runagunahua chaquita maillangahua callarira, pai huicsai anacurishca llachapa pitihuan chaquichira. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Pedrohua chaquita maillangaraushcaibi pai Jesusta nira, Canzhu ñuca chaquitaga maillahuangaraungui señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nicpi Jesus nira, Cunanga can mana yachanguichu ñuca raushcataga, randi huashaga yachanguimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro nira, Mana ima uraspas ñuca chaquitaga maillachishcanguichu. Jesus randi nira, Ñáuca camba chaquita mana maillapiga ñucahuac anata mana ushanguichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chasna nicpi Pedro nira, Chasna ashaga ama ñuca chaquigunallataga maillahuaichu astahuan maillahuai ñuca maquigunallatas ñuca umatahuas señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus randi paita nira, Armashca auc runaga mana minishtinzhu tucuita maillarinataga, chaquillatami maillarina an. Cangunaga cunanlla armashcashinami ña chiujlla anguichi, randi mana tucuiga. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pi paita japichingaraushcata pai yachashcamandami mana tucuiga armashcashina chiujllachanguichi nishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesus paiguna chaquita maillashcahuasha paihua capata churarisha cutillata mesai tiyarisha nira, Yachanguichichu imasna ñuca cangunata rashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Cangunaga yachachic amu, chasnallata señor nisha nihuanguichi. Chasna nisha sirtutami ninguichi, ñucaga cangunata yachachic amu mani, cangunata mandac señor mani. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ñáuca chasna ashallata canguna chaquitas maillashcani, chiraicumi cangunapurahuas maillarinacuna anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ñáuca caitaga ricuchishcanimi cangunahuas ñuca cangunata rashcashinallata ranauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sirtupacha cangunata nini maican yanapac runahuas paihua amuta yaliga mana anzhu, chasnallata maican cachamushca runahuas paita cachamucta yaliga mana anzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Caigunata canguna yachasha pactachishaga cushimi causanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mana tucui cangunamandachu rimauni. Ñáucaga yachanimi pigunallata ñuca anllashcataga. Chasnahuas Diospa shimibi quillcashcaga pactarina man casna nisha: Ñáucahuan pariu micugmi ñucahuan cuntar tucushca. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chi chara mana pactarishcallaita cangunata ñaupallata rimani, ñuca rimashcaguna pactarishcaibiga ñuca pi acta canguna quirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sirtupacha cangunata nini, maicanbas ñuca cachashca runa rimashcata uyasha quirishaga, ñucallatatami quirihuanga. Ñáucata quiric runaga ñucata cachamuc Yayatami quirin. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chita rimashcahuasha Jesus yapa ashcata llaquirisha, pagllaibi rimasha nira, Sirtupachami nini shuc runami canguna ucumandallata ac japichihuangaraun. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chasna nicpi pai japishca runaguna manzharisha paigunapura ricunacuicallarinaura pimanda rimaushcata mana yachasha. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Paigunamanda Jesus shuc yapa llaquishca runa paihua mayanbi tiyaric arani. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chasna acpi Simon Pedro maquita ñucata ricuchisha paita tapui pimandata rimaun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ñáuca mas Jesusma caillayasha tapurani, Canda japichingarauca pi tan señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tapucpi Jesus nihuara, Cai pan paquitami caldui jucuchingarauni, chita ñuca cushca runa manga. Chasna nisha chi pan paquita jucuchisha Simonba churi Judas Iscarioteta cura. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas chi pan paquita japishcai paihua shungu ucuibi supaiga yaicura. Chasna tucucpi Jesus nira, Can rangaraushcataga uctalla rai. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nicta uyasha randi chi mesaibi micuucunaga mana pihuas musianauranchichu Jesus imahua Judasta casna rimashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Randi yuyariranchimi Judas cullqui bultsata charic acpichari, imatahuas jistaraicu randichun nisha nin, mana ashaga pugrigunata ansa cullquita cuchun ima nishachari nin nishami yuyariranchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasca chi pan paquita japishca ratullaitami paigunahuagmanda llucshisha rirallami. Ñáa chi uras tuta mara. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas llucshisha rishcahuasha Jesus nira, Cunanmi ñuca Runa Tucuc ashami balichishca tucungarauni, chasnallata Yaya Diospas ñucamanda balichishca tucungaraun. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yaya Diosca ñucamanda yapa balichishca tucushami ñucatahuas paiga yapa balichihuangami. Cunanlla chitaga ricuchinga. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ñáuca llaquishca huauquiguna, ña mana yapa unaitachu cangunahuanga aungarauni. Canguna mascahuanguichimi, randi israel amugunata ñuca rimashcashina chasnallatami cunan cangunatas rimani, ñuca riushcamaga mana shamunata ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cai mushuc mandashcatami cangunata cuni: Tucui cangunapura llaquinacuichi. Ñáuca cangunata llaquishcacuintallata, chasnallatami cangunahuas tucui cangunapura llaquinacuna anguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Casna tucui cangunapura llaquinacusha causaupiga tucui mundui ac runagunami cangunata ricushaga asirtangauna canguna ñuca japishca ñucata catic runaguna ashcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pedro Jesusta tapura, Maitata ringaraungui señor. Tapucpi Jesus nira, Ñáuca riushca llactama cunanga catisha rinata mana ushanguichu, astahuanbas huashami catimuhuangaraungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nicpi Pedro cuti tapura, Imahuata cunanga canda catinata mana ushani. Canhuan pariu huañunatahuas mana manzhanichu señor, huañuna acpihuas canhuan pariu huañushami. ");
INSERT INTO qvzNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus paita cutipara, Sirtuchu ñucahuan pariu huañusha ningui. Sirtutami canda nini gallo chara mana cantagllaitami can quimsa (3) cutin ñucamanda llullangaraungui paita mana ricsinichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Huasha Jesus cuintangahua callarira casna nisha, Ama manzharisha turbaringuichichu. Diosta yuyarisha quirichi, chasnallata ñucatahuas yuyarisha quirichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ñáuca Yayahua huasibiga ashca lugarguna tiyanmi causangahuaca, mana chasna acpiga mana cangunata rimaimachu arani, shuc lugartami cangunaraicu puruntungahua riuni nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ñáuca risha chi lugarta cangunaraicu puruntushcahuasha, cutillata shamungarauni cangunata ñucahuan pushangahua, ñuca aungaraushca lugarllaita cangunahuas aungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Cangunaga ña yachanguichimi ñuca rinama ric ñambitaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jesus chasna rimacpi Tomas paita nira, Mana yachanchichu can maitas riushcata señor, chasna asha imasata ñambitahuas yachashun. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus cutipasha nira, Ñáuca ñambi ani, sirtutas rimac ani, causaita cucpas ani. Mana pis ñuca Yayahuagma rinataga ushanzhu mana ñucahuan rishaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Canguna ñucata ricsishaga, ñuca Yayatahuas ricsinguichi mara. Cunanmandapachami paitaga ricsinguichi, paita cai tucui timputami ricuushcanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chita uyasha Felipe nira, Camba Yayata ñucanchita ricuchi señor, chihuan ña basta manga. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus randi cutipara, Unaitami cangunahuan aushcani, chasna agllaitachu chara mana ricsihuangui Felipe. Maican ñucata ricucca Yayatahuas ricushcami. Imahuata ñucanchita camba Yayata ricuchi nishaga tapuhuangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Manachu quiringui ñuca Yayaibi ñuca acta, chasnallata ñuca Yaya ñucaibi autaga. Cangunata rimashcagunataga mana ñuca yuyaimandallachu rimani, astahuanbas ñucaibi causauc Yaya imata rachun nisha ushaita cuhuan pai ranagunatahuas rangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ñáuca Yaya ñucaibi aushcatas ñuca Yayaibi ñuca aushcatas nisha ñuca chasna rimashcataga quirichi. Mana ñuca rimashcata quirishaga ñuca rashcagunamandallahuas quirihuaichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sirtupacha cangunata nini, ñuca Yaya aushcama ñuca riushcamandami, maicanbas ñucata quiricca ñuca rashcagunallatatami ranga. Chigunamanda astahuanbas mas jatun ranagunatahuas rangami. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chasnallata tucui imatahuas canguna ñuca shutihuan tapushcagunata ñuca cushcanguichi. Chasna Churi asha ñuca Yayata balichishca tucungahuaca cushami. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ñáuca pactachishami canguna imatahuas ñuca shutibi ñucata tapucpiga. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Canguna ñucata llaquishaga ñuca mandashcagunata cadsunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chasna canguna racpi ñucaga ñuca Yayata tapushami cangunama shuc yanapacta cuchun nisha cangunahuan tucui uras aungahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Paimi mana llullasha sirtuta rimac Samai nishca man. Mundumanda ac runagunaga mana chi Diospa Samaitaga charinata ushanaunzhu paita mana ricusha ricsishcaraicu. Randi cangunaga ricsinguichimi pai cangunahuan aushcamanda, chasnallata tucui uras cangunahuan aungamiraun. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Cangunataga mana huaccha huahuatacuinta jichushachu saquingarauni, astahuanbas bulltiashami cangunahuan aungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ashilla timpuhuasha mundumanda ac runagunaga ña mana ricuhuangaunachu. Randi cangunaga ricuhuanguichimi, chasnallata ñuca causaushcamandami cangunahuas causanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chi punzha pactarishcai cangunaga yachanguichimi ñuca Yayaibi ñuca aushcata, canguna ñucaibi aushcatas, chasnallata ñuca cangunaibi aushcatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ñáuca mandashcagunata uyasha cadsuc runaga chihuanmi ricuchinmi pai ñucata llaquishcataga. Ñáucata llaquictaga ñuca Yaya llaquingami, chasnallata ñucahuas paita llaquishami paima ricurishami. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chasna nicpi shuc Judasca (mana Iscariote acca) Jesusta tapura, Imahuata ñucanchimallaga ricuringaraungui señor, randi mundui auc runagunama mana ricuringui. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus cutipasha nira, Maicanbas ñucata llaquicca ñuca rimashca shimigunata cadsungami. Chi cadsucta ñuca Yaya llaquingami. Chasnallata ñuca Yayandi ñucanchi shamushunmi paihuan causangahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Randi ñucata mana llaquiccunaga ñuca rimashca shimigunata mana cadsunzhu. Cai canguna uyaushca shimigunaga mana ñucahuacchanaun astahuan ñucata cachamuc Yayahuac shimi man. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cangunahuan aushallatami tucui caigunata cangunama rimauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Randi ñuca shutibi ñuca Yaya cachangaraushca Samaiga yanapac asha, tucuita cangunata yachachingami, tucui ñuca rimashcagunata cangunata yuyachingami. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Riushami cangunata ñuca quiquin cushita saquini. Randi mana cunichu mundumanda ac runaguna cushcashinaga. Chasna acpi ama yapata turbarisha manzharichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ñáa uyahuaranguichimi riunimi nisha ñuca nishcata, chasnallata ñuca cuti bulltiamushami cangunahuan aungahua nishcatahuas. Canguna ñucata sirtu llaquishaga cushiyanguichimami. Ñáuca Yayahuacta riushcata yachashaga cushiyanguichimami pai ñucamandahuas mas jatun ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Caita ñaupallata cangunata rimani, chi tucuna punzha pactarishcaibiga canguna quirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ñáa mana yapa unaita ausha cangunahuan rimashachu, cai munduibi mandacca ña shamuunmi. Shamuupimi randi ñucataga mana imamanda mandanata ushangachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chasna tucuna anmi ñuca Yayata ñuca llaquishcamandami tucui pai mandashcagunata pactachic ashcataga cai mundu auc runaguna ricunauchun nisha. Cunanga jatarisha jacuichi caimanda nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus casna rimara, Ñáucami uva nishca ruyacuintaga sirtu ani, ñuca Yayami alichisha cuirasha chariccuinta an. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Maican ñucaibi auc ramacuinta muyuta mana aparicpiga pitinmi, randi aparic ramai imas llutariapiga sumac anchuchishami cuirasha charin mas ashcata aparichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Cangunaga ña sumac alichishca ramagunacuinta manguichi ñuca cangunata rimashca shimigunamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ñáucaibi llutariashcacuinta aucunaga catihuachilla, imasna ñuca cangunama llutariuni. Shuc rama paihua ruyama mana llutariaushaga paillata mana aparinata ushanzhu. Chasnallatami cangunahuas mana muyutashina aparinata ushanguichi ñucaibi mana aushaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ñáucami quiquin ruyacuintaga ani, cangunaga ramagunacuinta anguichi. Shuc rama paihua ruyama llutariaushcallai aparic tucushcashina maicanbas ñucahuan auca ñucas paillaita aupiga, ashca muyutacuinta aparingami ñucacuinta tucusha. Randi ñuca illacca canguna ñuca munashcata ranatas mana ushanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mana ñucama llutariashca autaga anchuchishca ramacuinta pagllama jichushcami tucunga. Chi jichushca ramaga chibimi chaquiringa. Chihuashaga tandasha ninaibi rupachishca tucunga. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Canguna ñucama llutariaushaga, chasnallata tucui ñuca mandashcagunata canguna pactachisha catiushaga, canguna tucui munashcata tapuichilla, tapucpi cuitucunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Canguna ñucacuinta causashami ashca muyuta aparishcacuinta tucunguichi. Chasna tucusha canguna sirtupacha ñucata catic runaguna aushcata ricuchinguichi. Chasna ricuchicpimi ñuca Yayata balichishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ñáuca cangunata llaquinimi ñuca Yaya ñucata llaquishcacuintallata. Chasna acpi ñuca llaquishcallai catisha causaichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ñáucaga ñuca Yaya mandashcagunata cadsushami pai llaquishcallaibi causashcacuinta canguna chasnallata ñuca mandashcagunata cadsusha ñuca llaquishcai causanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Cangunata casna rimashcani canguna ñucahuan pariu cushiyangahua, chasnallata canguna cushihuas pactacta angahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cai man ñuca mandashcaga: Ñáuca cangunata llaquishcacuintallata tucui cangunapura chasnallatas llaquinacusha causaichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ricuichi shuc runa paihua amigoguna randimanda huañusha pai yapa llaquishcata ricuchin. Mas jatun llaquinaga illanmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Cangunaga ñuca amigoguna manguichi ñuca mandashcagunata rashaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Chasnamandami cangunata mana mas ninichu ñuca muchachoguna nishca anguichi nisha. Shuc muchacho runaga pai amu rangaraushcata mana yachanzhu, randi cangunata tucui ñuca Yaya rimahuashcataga cuintasha yachachishcami. Chasna acpi ñuca amigoguna manguichi nishami cangunata nini. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Cangunaga ñucata mana anllahuaranguichichu, randi ñucami cangunataga anllarani. Anllasha mandashcanimi ashca muyutacuinta aparigrichi nisha, chasnallata canguna aparishca muyuga huiñaigama tiyachun nisha. Casna canguna racpimi ñuca Yayaga canguna tucui ñuca shutibi tapushcagunatahuas cungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Caitami cangunata mandani: tucui cangunapura llaquinacusha causaichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mana quiric runaguna cangunata mana gustasha piñacpiga yachaichi ñucatami pundaga mana gustasha piñahuanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Canguna paiguna partimanda ashca acpiga paigunaga llaquitucunguichima mara paigunapura llaquinacushcashinallata. Randi paigunamanda ñuca cangunata cayashcani, canguna ña mana chi partimandachanguichi, chiraicumi paiguna cangunata mana gustasha piñaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yuyarichi ñuca cangunata ñaupa casna rimashcataga: Maican muchacho runahuas mana paihua amuta yali balicca anzhu. Chicuintallata mana quiriccuna ñucata piñashaga cangunatahuas catingaraunguna. Randi maicanbas ñuca rimashca shimigunata cadsucca canguna rimashca shimigunatahuas cadsungaunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tucui caitami raitucungaraunguichi ñucata catic ashcamanda, paiguna ñucata cachamucta mana ricsishcamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ñáuca paigunata mana rimac shamushca acpiga mana ima culpatahuas charinaunmachara. Randi cunanga paiguna ñucata mana uyasha piñashca juchamandaga mana culpa illacca saquirinaunzhu. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ñáucata mana gustasha piñaccunaga ñuca Yayatahuas piñanaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ñáuca paiguna ñaupacpi pihuas chi jatun rashcagunata ñuca mana rashca acpiga mana ima culpatahuas charinaunmachu. Randi cunanga ñuca rashcagunata ricushca ashallatami ñucataga mana gustasha piñahuanaun, ñuca Yayatahuas mana gustasha piñanaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tucui caigunaga tucushcami paigunata mandashca shimibi quillcashca tiyac shimi pactaringahua casna nisha: Yangamandami ñucata piñahuanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Randi ñuca Yayahuagmanda Yanapactaga cangunama cachangarauni. Paiga sirtuta rimac Diospa Samai man. Ñáa pai shamushami ñucamandaga rimangamiraun. ");
INSERT INTO qvzNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Cangunahuas pundamandapacha ñucahuan aushcamanda ñucamanda rimac runaguna angamiraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Caigunata cangunama rimashcani canguna ñucata quirishcata ama saquingahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Israel tandarina huasigunamandahuas cangunata callpachingaunami, maspas pactaringami shuc punzha cangunata huanchisha yuyaringaunami. Paiguna chasna rashami Dios munashcatashina raunchi nisha yuyaringauna. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Paiguna caitaga casna rangaunami ñucatas ñuca Yayatas mana ricsishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pundamandata caita cangunata mana rimaranichi ñucallata cangunahuan aushcaraicu. Cunanga caigunata rimani, chi punzhaguna pactarimushcai canguna yuyarinauchun nisha ñuca ña cangunata ñaupallata rimashcata casnami pasanga nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ñáa cunanga riunimi ñucata cachamughuan tiyangahua. Chasna agllaita mana pihuas cangunamanda tapuhuanguichichu maitata riungui nishallahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Randi ñuca caigunata rimashcamanda ashca llaquirisha saquiringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Chasna agllaita sirtutami rimauni: Ñáuca rinaga astahuan cangunaraicu mas ali achun nisha riuni. Ñáuca mana ricpiga chi cangunata Yanapacca mana shamungachu cangunahuan angahua, randi ñuca rishaga paita cachamushami. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pai shamushcaibi mana quiric runaguna juchata rashcagunata pagllai ricuchinga. Yaya Dios munashcatashina causanatas ricuchinga. Chasnallata paigunata taripangaraushcatas ricuchinga. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Chi runaguna ñucata mana quirishcamandami juchayuc aushcata ricuchingami. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ñáuca Yayahuagma rishcamanda ñuca jucha illac acta ricuchingami. Chasna ricpimi ña cuti mana ricuhuanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Cai munduta mandactaga Dios ña binsisha caudsayachisha taripashcami. Chasna acpimi juchayuc runagunataga taripaitucunata yachangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Chara cangunama ashca rimanatami charini, randi cai ratuibi rimacpiga yapa sinzhi tucunga canguna intindingahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Astahuanbas sirtu shimita rimac Samai shamushcai cangunata paimi tucui ali ranagunatas ricuchinga. Paiga mana paihua quiquin yuyaimandallachu rimanga, randi tucui pai uyashcallatami rimanga, chasnallata ima huasha pasangaraucunatahuas cangunata yachachingami. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Paiga ñuca charishcagunamanda japisha cangunata yachachingamiraun. Chasna rashami ñucataga balichihuanga. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tucui ñuca Yaya charishcaga ñucahuacpas man. Chiraicumi Diospa Samaiga ñuca charishcagunamanda japishami cangunata yachachinga nisha rimauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ñáa ashilla timpuhuasha mana ricuhuanguichichu, astahuanbas mas ashilla timpuhuasha cutillata ricuhuangaraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesus chasna rimashcata uyashami maican pai japishca runagunaga paigunapura tapunacunaura, Imasna nishata casnaga nin ansalla timpuhuasha mana ricuhuanguichichu, mas timpuhuasha cutillata ricuhuanguichimi nisha, chasnallata paihua Yayahuagma ringarauni nishaga, ima nishashi chasnaga niun. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pai ashilla timpuhuasha nishcataga mana intindinchichu imamanda pai casna rimaushcatas nisha ninacura. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus paita tapunata munaucunata yachasha nira, Ñáuca cangunata nishcanimi ashilla timpuhuasha ña mana ricuhuanguichichu, chasnallata mas ashilla timpuhuasha cutillatami ricuhuanguichi nisha, caitachu cangunapuraga tapunacuunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sirtupacha nini, cangunaga shuc punzha llaquirisha huacangaraunguichi. randi mana quiric runagunaga cushiyangaraunguna. Chasna agllaita canguna ashilla timpu llaquirishca ashahuas chihuashalla cushiyangamiraunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Caicuinta an, shuc huarmi paihua huahuata pagarichina punzha pactaushcai yapatami turmintan. Randi huashaga pai turmintashcata cungarinmi paihua huahua pagarishcamanda cushiyasha. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chasnallatami cangunahuas cunanga llaquirisha turmintariunguichi. Randi ñuca cangunata cuti ricucshamushcai yapa cushiyanguichi. Chasna tucucpi mana pihuas canguna cushitaga quichunata ushanaungachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chi punzhaibiga ña mana imatahuas tapuhuanguichichu. Sirtupacha cangunata nini ñuca Yayallatami tucui canguna ñuca shutibi tapushcataga cunga. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cunangamaga chara mana imatahuas ñuca shutibiga tapushcanguichichu. Cunanga tapuichi, cuitucunguichimi canguna cushi pactacta tucungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tucui cai cangunata cuintasha yachachina shimigunahuanmi cunangama rimashcanimi. Randi shuc punzha pactamungami chi chasna cuintanagunahuan mana yachachingarauni, randi chi punzhaibiga ñuca Yayamandaga paglla pambaimi yachachingarauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chi punzhaibiga cangunallata Yayahuan cuintanata ushanguichi, mana ninichu ñucallami paita cangunamanda tapusha nishaga. Chi punzhai ñuca shutihuan Yayataga imatahuas tapunguichilla. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ñáuca Yaya quiquinllatami cangunataga llaquiunmi canguna ñucata llaquic ashcamanda, chasnallata ñuca paihuagmanda shamushcatas canguna quirishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ñáuca Yayahuagmanda llucshisha cai pachama shamushcani, cunanga cai pachata saquisha ñuca Yayahuagma bulltiauni nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Caita uyasha paihua runaguna ninaura, Ñáa cunanga mana yachachina shimigunataga rimaungui astahuan paglla pambaibimi rimaungui. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cunanmi can tucuita yachac ashcataga musianchi, pihuas chara mana tapugllaita canga tucuita yachanguimi. Chiraicu can Yaya Diospagmanda shamushcataga quirinchimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chasna rimacpi Jesus cutipasha nira, Chasna ashaga cunanllachu quiringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ñáa shuc uras pactamuunmi, chi urasca ña cunanllata man, imasa caimas chimas tucui cangunata callpachishca tucunguichi. Miticusha canguna quiquin huasima risha ñucata sapalla saquihuangaraunguichi. Randi mana sapallaga aunichu, ñuca Yayami ñucahuanga aun. ");
INSERT INTO qvzNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ñáa tucui caita cangunata rimashcani, canguna ñucahuan shuglla ashcamanda mana manzhasha cushi causaita charichun nisha. Cai pachaibi llaquichitucungaraunguichi. Chasna agllaita ahuantaichi, ñucallami cai mundutaga binsishcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tucui caigunata rimashcahuasha Jesus jahuapachama ricusha nira, Ñáuca huañuna uras ña pactarishcami Yaya. Ñáuca camba churi ashcamanda balichihuai ñuca candas balichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Canmi tucui runagunata mandana ushaita cuhuashcangui tucui can ñucama cushca runagunata huiñai causaita cungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chi huiñai causanaga casnami: Can sirtu quiquin Yaya Dios actas ricsisha quirina man, chasnallata can cachamushca Jesucristotahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Can ñucata imatas rangui nisha rimashcataga tucuitami pactachishcani. Chasna rashami cai pachaibi canda balichishcanimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ñáuca chara cai pachata rashcallaitami camba mayanbi yapa ali balichishca aurani. Cunanga chi balinallatata cuti cuhuai Yayalla. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Can cai pachamanda ñucama cuhuashca runagunataga yachachishcanimi pi can ashcata. Chiguna cambac manaura, canmi ñucamaga cuhuashcangui, paigunaga can rimashca shimigunataga cadsushcaunami. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cunan paigunaga ña yachanaunmi tucui can ñucata cushcagunaga canmanda shamushcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Can ñucata rimashca shimigunata paigunama rimashcanimi, paigunaga quirishcaunami sirtu man nisha. Can ñucata cachamushcata quirisha ñuca cambagmanda shamushcatas sirtupacha yachanaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Paigunamandami canda rugauni, cai mundumanda accunamandaga mana ruganichu. Astahuan can ñucata cushcagunamandami rugani paigunaga cambac ac ashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tucui ñuca charishcagunaga cambacpas man, chasnallata tucui can charishcaga ñucahuagmi an. Chiraicumi ñuca ushaiga paigunahuacpi ricurishcamanda mas balichishca tucushcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ñáuca cunanga cambagma bulltiamungamirauni, ña mana cai pachaibiga aungachu rauni. Randi paigunaga cai pachaillatami aungaraunguna. Jucha illac sumac Yayalla, can ñucama cushca shutimanda ushaihuan paigunatas cuirapai. Ñáucanchi shuglla ashcacuintami paigunas shuglla anauchun nisha camba ushaihuanmi cuirapai. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ñáuca cai pachai paigunahuan aushcaibiga can ñucata cushca shutimanda ushaihuanmi cuirasha imamandahuas quishpichisha charic arani, chiraicumi mana pihuas paigunamanda pirdirira. Randi camba shimibi quillcashca tiyac pactaringahuami chi ñaupamandata chingaringahua tucushca runallami chingarishca. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Cunanga can aushcamami shamungarauni, randi cai shimigunata canda rimauni cai pachai aushallata paigunahuas ñuca charishcashinallata pactacta cushita charingahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Camba shimitaga paigunata rimashcanimi. Chasnamanda cunan ñuca mana mundupartimanda ashcashina paigunas mana mundupartimanda anaun. Chimandami mana quiric runagunaga paigunata piñaunguna. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cai pachamanda paigunata llucshichi nishaga mana canda tapunichu, astahuanbas paigunata supaimanda quishpichipai nishami rugani. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ñáuca mana mundumanda ashcashinallata paigunahuas mana chimandachanaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Camba shimiga sirtu man Yaya. Paiguna camba sirtu shimita catishami cambaglla causanauchun nini. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Can ñucata mana quiriccunama cachahuashcashina ñucahuas chasnallata paigunataga mana quiriccunama cachashcani. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chiraicumi ñucaga paigunaraicu ñuca quiquin causaiga cambaglla achun nini paiguna causai chasnallata cambaglla angahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Chasnallata mana caigunamandallachu canda tapuni Yaya, randi huasha paiguna camachishcata uyasha ñucata quiringaraucunamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Canda ruganimi tucui paigunapura alipacha shugllacuinta anauchun nisha, paiguna ñucanchihuan pariu shuglla angahua. Can ñucaibi aushcacuinta, ñucas canbi aushcacuinta, paigunaga ñucanchibi shuglla anauchun nisha rugani. Paiguna shugllaibi causanauchun Sumac Yayalla cai mundui auc runaguna can ñucata cachamuhuashcata quiringahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Can ñucata cushca ushaillatatami paigunatahuas cushcani paigunapurahuas shuglla anaunchun nisha, imasna ñuca canhuan shuglla ashcacuintallata. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ñáuca paigunaibi aupi cambas ñucaibi aungui paiguna alipacha shuglla tucungahua. Chasna tucuchun mana quiriccuna chita ricusha yachanauchun nisha can ñucata cachamushcata, chasnallata can paigunatas ashcata llaquishcata ñucata llaquishcacuintallata yachanauchun. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Can chara cai pachata mana rashcallaita ñucata llaquishcamandami yapa sumacta cuhuashcangui Yaya. Ñáa cai ñucama cushca runagunaga ñucahuan pariu aunata munani, chasnallata paiguna ñuca sumac actas ricunauchun nini. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Canga tucuita alita rac angui Yaya. Mana quiriccuna canda mana ricsinaunzhu, randi ñucaga canda ricsinimi, chasnallata caigunahuas yachanaunmi can ñucata cachamushcataga. ");
INSERT INTO qvzNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Paigunataga yachachishcanimi pi can ashcata, maspas paigunata chara ricsichingamirauni can ñucata llaquishcaga paigunaibias aungahua, chasnallata ñuca quiquinbas paigunaibi aungahua. Jesus chasna nisha Yaya Diosta cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Caigunata rimashcahuasha Jesus pai japishca runagunahuan llucshisha rira Cedron nishca yacuhuahua chimbama. Chibimi ashca ruya tiyashca ucutaga gustu paglla tiyara, chibimi Jesusca paihua runagunandi yaicura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesus tucui uras pai japishca runagunahuan chibi tandaric ashcamanda paita japichingarauc Judaspas chi lugartaga alitami ricsic ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chasna acpi Judas ashca sundalugunata, chasnallata Diosta alabana huasita cuiraccunatas chima pushamura. Chi Diospa huasita cuirac runagunataga israel pagrihua amuguna, fariseogunandi mandasha cachashca anaura. Tucui paigunaga shamunaura espada sauligunahuan, caspigunahuan, bilagunatas sindishca tsindsacagunatahuas japichisha shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Randi Jesus tucui paita rangarauta yachashami llucshirisha paigunata tapura, Pitata mascaunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nazaretmanda Jesusta mascaunchi ninaura. Paiguna chasna nicpi Jesus nira ñuca mani. Ñáa Jesusta japichiu Judaspas chibi paigunahuanllatami aura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesus ñuca mani nisha rimashcata uyasha tucui chiguna huashama risha allpai urmanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus cutillata tapucpi, Pitata mascaunguichi, cutillata paiguna ninaura Nazaretmanda ac Jesusta. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nicpi pai cutillata nira, Ñáa cangunata nishcanimi ñuca mani nisha. Ñáucata mascaushaga cai ñuca runagunataga saquichi paiguna rinauchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tucui cai pasarami Jesus rimashca shimillata pactaringahua casna nisha: Yaya can ñucata cushca runagunamandaga mana shugllatahuas chingachiranichu nishami. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chasnaibi Simon Pedroga shuc espada saulita charisha llucshichisha Malco nishca runahua ali parti rinrita huactasha chiú pitira. Cai Malcoga pagrigunahua amuta cuirac runa ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pedro chasna racpi Jesus paita nira, Chi saulita pai aushca cara ucullaita churai. Ñáuca cai jayacta upicshina achun ñuca Yaya nishcataga pactachishami nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sundaluguna paigunata mandac amundi, chasnallata Diosta alabana huasita cuirac sundalugunandi Jesusta japisha huatasha apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pundaga Anaspa huasimami apanaura, paiga Caifaspa huarmi yaya ashcamanda. Chi huatai Caifasca israel pagrigunahua jatun amu ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cai Caifasllata israel amugunata huin israelguna huañuna randimanda ali an shuc runalla huañuchun nisha nigara. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pedro ñucahuan Jesusta huashalla catiranchi. Ñáucaga chi pagrigunahua amu ricsishca asha Jesushuan pariu chi huasi partibiga yaicurani. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Randi Pedroga pagllamallatami saquirira punguhuashai. Chiraicumi ñuca chi pagrigunahua amu ricsishca ashami punguta cuirac huarmita cuintasha Pedrotaga yaicuchi nirani. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedro yaicucpi chi punguta cuirac huarmiga paita tapura, Manachu chi runata catic angui cambas. Nicpi Pedro cutipara, Mana anichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chi tuta yapa chiri acpimi chi pagri amuta cuirac runagunas sundalugunandi ninata pagllai japichisha chibi cunuunaura. Pedrohuas paigunahuan pariullatami chi ninai cunuura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pagrigunahua jatun amuga Jesusta tapuicallarira paita catic runagunamanda, chasnallata paigunata yachachiushca partimanda tapura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus cutipasha nira, Ñáucaga pagllapambaibimi tucui runagunahua ñaupacpi rimashcani. Tucui urasmi israelguna tandarina huasigunaibi chasnallata Diosta alabana huasibimi yachachishcani tucui israel runaguna tandarishcaibi. Chasna acpiga mana imatahuas pacalla rimashcanichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Imasata ñucata tapuhuangui. Ñáuca rimashcata uyac runagunataga tapui, paiguna yachanaunmi imamanda ñuca rimashcatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus casna rimacpi Diosta alabana huasita shuc cuirac sundalu Jesusta maqui palahuan huactasha rimara, Imahuata pagrigunahua amutaga casna rimangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus cutipara, Imamandahuas ñuca mana alita rimashca acpiga rimahuai, randi ñuca rimashcaga ali acpiga imahuata huactahuangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Caihuasha Anasca Jesusta cachara chara huatashcallata pagrigunahua jatun amu Caifaspagma. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedroga chara chi ninallaitami cunuura. Chasnaimi cuti tapunaura, Manachu canga chi runahua muntunmanda angui nicpi Pedro umara mana anichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chihuasha pagrigunahua jatun amuta cuiracpuramanda shucca Pedro rinrita pitishca runahua aillu mara. Paiga Pedrota tapura, Canga manachu chi ruya paglla pambaibi paihuan auta ricurani. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro cutillata umara, Mana ñucacharani nisha. Chi ratullaitami gallo cantara. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chihuasha ña punzhayaushcai Jesusta apanaura Caifaspa huasimanda llactata mandac romano gubirnu Pilato huasima. Caya pascua micuna punzha ashcamanda chi apauc israelgunaga gubirnuhua huasi ucuta yaicunata mana munanaurachu pai mana-israel runa acpi. Paiguna Moises mandashcata pactachisha ama mana-israelpa huasibi yaicunachu jiridsashina tucungahua nisha mana yaicunaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chiraicumi mandac Pilatoga pagllama llucshira paigunata tapungahua, Imangata cai runataga caudsayachiunguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Paiguna cutipanaura, Cai runa mana caudsayuc acpiga mana canma apamunchimachara nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato randi nira, Cangunallata apasha quiquin mandashcagunahuan taripaichi. Paiguna randi, Ñáucanchiga mana ushaita charinchichu runata huanchingahuaca ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Casnami pactarira Jesus rimashcaga ima tunuhuan pai huañunata. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato cutillata paihua huasi ucuibi yaicusha Jesusta cayasha tapura, Canzhu israel runagunata mandac amu angui. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus paita randi tapura, Caitaga camba quiquin yuyaimandachu tapuhuangui, mana ashaga shuccuna ñucamanda canda cuintashcatachu rimangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato cutipara, Ñáucaga mana israel runachani. Camba llactamandallata runagunami, pagrigunahua amugunahuas pariumi candaga ñucama apamushcaunami. Imatata raranguiya can. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus paita cutipara, Ñáuca mandanaga mana cai pachamandachan. Cai pachamanda acpiga ashca ñucata catic runagunami macanacunaunma israelguna ñucata ama japinauchun nisha. Randi ñuca mandanaga mana cai pachamandachan, shugmandami an. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jesus chasna nicpi Pilato tapura, Canga mandacchangui. Jesus nira, Can rimashcacuinta mandac mani. Chiraicumi pagarirani, chimandami cai pachama shamurani sirtu shimita rimangahua. Sirtuta rimac runa ñuca shimita uyaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nicpi Pilato tapura, Imatanya sirtu shimiga. Casna tapushcahuasha Pilato cutillata pagllama llucshisha israelgunata nira, Cai runahuacpi ñucaga mana ima caudsatahuas tupanichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Randi cangunaga caran pascua jista uraspi munac anguichi ñuca shuc caudsayachishca runata cacharichun nisha. Cai cangunata mandactaga ñuca cacharinata munanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chasna tapucpi tucui israelguna pariu caparinaura, Cai runataga ama cacharichu, astahuanbas Barabasta cachari nisha. Ñáa chi Barabasca yapa shuhua runa ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chasna israelguna caparicpi Pilato paihua sundaluguna Jesusta libachichun nisha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Paigunaga Jesusta pugllasha shuc casha gurata ahuasha paihua umai gurachisha, shuc mandac amuhua puca capatas churachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chihuasha paima caillayasha asisha ninaura, Israelguna amu balichishca achun. Chasna nishami ñahuibi huactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato cutillata Jesusta llucshisha israelgunata nira, Ricuichi, cai runa ima mana alita rashcatas ñuca mana tuparanichu. Chita canguna yachachun nisha paita cuti cangunahuagma llucshichimuni nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chasna nicpi Jesus llucshira shuc amuhua puca capata churachitucushca, paihua umaibi casha gura ahuashcatas. Chasna acpi paigunata Pilato nira, Caibimi charinguichi cai runata. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesus pagllama llucshimucta ricusha pagrihua amuguna, Diosta alabana huasita cuirac sundalugunahuas caparic callarinaura, Cruspi quilabasha huanchi, cruspi huanchi nisha. Chita uyasha amu Pilato nira, Chasna ashaga cangunallata apasha huanchichi, ñucaga paihuacpi ima caudsatas mana tupashcanichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Israelguna paita cutipanaura, Ñáucanchiga pitas huanchinata mana ushaita charinchichu, randi ñucanchita mandashca quillcaga ninmi pai huañuna man pai Diospa churi mani nisha rimashcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Casna paiguna rimashcata uyashami Pilatoga mas manzharira. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Cutillata paihua huasi ucuibi yaicusha Jesusta tapura, Maimandatanguiya. Randi Jesusca mana cutiparachu ansallahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Casna Jesus mana imatahuas rimacpi Pilato nira, Manachu ñucata rimahuangui. Manachu yachangui ñuca ushaita charishcata canda cruspi huanchingahua mandanata, lugar cacharina ushaitahuas charini. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus cutipasha nira, Dios canda chasna mandana ushaita mana cushca acpiga ima ushaitahuas mana charinguimachu ñucata caudsayachingahua. Chiraicumi ñucata japisha canma cachamuc runaga canmanda mas yali juchata rashcami. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chita uyashcamandami Pilatoga Jesusta cacharinata yapa munara. Chasna agllaita israelguna caparinaura, Yachanguimi maicanbas paillata amu tucucca romano llactagunata jatun mandac amuhua cuntarmi tucun. Chasna acpi can paita cacharishaga mana romano llactai jatun mandac amuhua amigochangui. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paiguna casna caparishcata uyasha, Jesusta cuti canzhama llucshichichi nisha mandara taripangahua. Chihuasha Pilato pai taripana bancui tiyarira, chiga hebreo shimibiga Gabata nishca, runa shimibiga Rumi Pamba nishca man. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ñáa chaupi punzha ara, cayandi pascua jistata alichina mara. Chasna acpi chi punzhallata Pilato israelgunata nira, caibimi charinguichi canguna amuta. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Randi paiguna caparinaura, Paita huanchi huanchi, cruspi chacatachigri. Caita uyasha Pilato nira, Imasata canguna rey amutaga chacatasha. Pagrigunahua amuguna randi ninaura, Romano llactagunata mandagllami ñucanchi amu an. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chasna nicpi Pilato paigunallata Jesusta cruspi chacatanauchun nisha cura, cucpi paigunami apasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesus crusta apachishca llucshira Umatullu nishca lugarma ringahua. (Chi lugarga hebreo shimibi Gólgota nishca an). ");
INSERT INTO qvzNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chibimi Jesusta chacatasha huanchinaura. Chasnallata ishcaigunatas (2) paihuan pariu chacatanaura, shucta caran partima. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato Jesuspa crus jahuaibi churangahua cachara shuc quillcashca taula palata, CAIGA NAZARET LLACTAMANDA ISRAELGUNAHUA JATUN AMU JESUSMI nishcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chi palaga quillcashca mara hebreo shimibi, latin shimibis, griego shimibihuas. Chi chacatashca pistuga Jerusalen llacta mayanbi ashcaraicu ashca pasauc israel runagunami chi quillcashcataga ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chiraicumi israel pagrigunahua amugunaga Pilatota rimagrinaura, Israelgunahua amu nisha quillcashcata anchuchi, chita randimanda ñucaga israelgunahua amu mani nisha rimaric nishcataga quillcagri. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chasna rimasha tapugllaita Pilato nira, Ñáuca quillcashcaga quillcashcami saquirinlla. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ñáa sundaluguna Jesusta cruspi quilabashcahuasha paihua llachapata japisha chuscu (4) partibi chaupichinaura, caran sundaluraicu. Chasnallata paihua capata japisha, sirashca illac, jahuamanda allpagama shuc pitilla ahuashcata ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chasna ricusha chi sundaluguna paigunapura rimanacunaura, ama liquishunchi astahuan surtiyashun pita apanga nisha. Chasnami Diospa shimibi casna quillcashcaga pactarira: Ñáuca llachapata paigunapura chaupi chaupi chaupinacunaushca, ñuca capataga surtinaushca. Casnami sundalugunaga ranaura Diospa shimi ñaupata rimashcashina. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chi crus sapibi aunaura paihua mama, pai mamahua ñaña Cleofaspa huarmi Maria, Maria Magdalenahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus paihua mamatas ñuca mayanbi shayautas ricusha paihua mamata nira, Chibimi charingui camba churita. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chihuasha ñucata, Chibimi camba mamata charingui nira. Chi ratumandami paihua mamataga ñuca huasima aparani causachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chihuasha ña tucui paihua Yaya rimashcata Jesus pactachishcata yachashami, Diospa shimibi quillcashca pactarichun nisha rimara, Upinayahuanmi. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chibimi tiyara shuc puru jundacta jayac vino yacu. Chasna acpi sundaluguna chi jayac yacuibi pututa chupachisha shuc isopo nishca caspi pundai huatasha Jesuspa shimibi tupachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus chi jayac yacuta upisha nira, Tucuitami ña pactachishcani. Chihuasha umata patarichisha huañura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua jista alichina punzha ashcaraicumi israel amuguna mana munanaurachu paiguna balichishca punzhaibiga chi chacatashca aichaguna pagllai saquirinata. Chiraicumi Pilatota tapunaura chi chacatashca runagunahua changagunata paquisha mas uctalla huañunauchun chihuasha crusmanda anchuchinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Amu mandacpi sundaluguna risha Jesuspa mayanbi ishcai (2) aucunahua chaquigunata paquinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusma randi caillayasha ricucpiga ña huañushca ara, chiraicumi paihua chaquitaga mana paquinaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Chasna agllaitami shuc sundaluga paihua lansahuan Jesuspa cushtillaspi tucsira, chasna tucsishcai rahuaihuan yacuhuan chapu llucshira. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tucui chasna tucushcata ñuca quiquin ñahuihuan ricushca ashami mana llullasha rimauni chasnami tucura nisha. Tucui caigunataga sirtutami rimani cangunas quirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Diospa shimibi quillcashca aura: Shuc tullullahuas mana paquiringachu. Chasna quillcashcaga pactarira. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chasnallata shuc partibi Diospa shimibiga ninmi: Paita tucsic runagunaga paita ricunaungami. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chihuasha Arimatea llactamanda Jose shamusha Pilatota tapura Jesuspa aichata cuhuai nisha apangahua. Josega Jesusta catic runa mara, randi israel amugunata manzhashcamanda pacalla catic mara. Chasna pai tapucpi Pilato Joseta apai nicpi Jose risha Jesuspa aichata uraicuchisha apara. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chasnallata Nicodemohuasmi cumpañara. Paimi shuc uras Jesushuan tuta cuintag runa ara. Cai runa apamura shuc quintal tupu pambanaraicu gustu asnarinagunata, mirra, aloe nishca chapushcagunata. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Casnami Josega Nicodemohuan Jesuspa aichata japisha llachapa pitigunata pillunaura chi gustu asnarinagunahuan. Casnami israelguna huañushcagunata pambana tunu ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta cruspi huanchishca mayanllai tarpushca ruya pamba aura. Chi pambaibi tiyara shuc mushuc juctu, mana pihuas chi juctu ucui pambariushcachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chibimi Jesuspa aichataga churanaura chi juctu mayanlla ashcamanda, chasnallata israelgunahua samana punzha ña callaringaraupi uctalla pambangahua apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo punzha Maria Magdalenaga rira Jesusta pambashca juctuma tutamandalla chara ansa ucullaita. Juctuibi pactasha ricucpi juctu punguta tapashca rumi anchuchishca ashcara. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chita ricusha callpasha rira Simon Pedrotas, chi Jesus yapa llaquisha japishca runatahuas rimangahua. Ñáucanchihuacpi pactasha nira, Ñáucanchi Señorta chi pambashca juctumandaga apashcaunami, mana yachanchichu maibis paiguna churashcataga nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ñucahuan llucshisha riranchi pambashca juctuta ricungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishcandimi pariu callpasha riuranchi, chasna agllaitami ñucaga Pedromandahuas mas sinzhita callpasha pambashca juctuma punda pactarani. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cumurisha ucuma ricusha Jesusta pillushca llachapa pitigunata ricurani, randi mana yaicuranichu. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Pedro huashalla pactasha yaicura ucuma, paihuas chasnallatami ricura Jesusta pillushca llachapa pitiguna chi aucunata. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chasnallata ricurami Jesuspa umata pillushca llachapa pitiga mana aurachu chi shuc pitigunahuan pariuga, randi shuc partillama churashca ashcara. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chihuasha ñucaga ñaupa juctuma pactac ashahuas huasha ucuma yaicurani. Ñáucahuas chi llachapa pitiguna chasna churashca aucunata ricusha quirirani. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chigamaga chara mana intindishcacharanchi Diospa shimibi quillcashca tiyactaga causaringami nishca. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chihuasha ishcandi huasima bulltiaranchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Astahuanbas Mariaga saquirira canzhamallata pambasha juctu mayanbi huacasha. Chasna huacasha aushami cumurira juctu ucuma ricungahua. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chasnaibimi chi Jesuspa aichata churashcaibiga ishcai (2) angelguna tiyaucunata ricura ruyac llachapahuan churarishcaguna auta. Shucca uma partima, shucca chaqui partima tiyaririshca anaura, randi Jesuspa aichaga mana tiyarachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chi angelguna Mariata tapunaura, Imahuata huacaungui nisha. Pairandi nira, Ñáuca Señorba aichata apashcamandami huacauni, mana yachanichuya maibi paiguna churashcatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chasna rimashcahuasha cuti bulltiarisha, Jesus quiquinda ricura chibi auta, randi Mariaga mana asirtarachu Jesus actaga. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus paita tapura, Canga imahuata huacaungui, pitata mascangui nisha. Mariaga randi chi ruya pambata cuirac runachari an nisha yuyarishami nira, Can apashca ashaga rimahuai ñuca ricungahua maibi churashcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus randi nira, Maria. Chasna Jesus paihua shutita rimacpi bulltiarisha hebreo shimibi rabuni nira. (Hebreo shimibi “rabuni” nisha runa shimibi yachachic amu nin). ");
INSERT INTO qvzNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus paita nira, Cacharihuai, chara ñuca Yayahuan tupanacungahua mana rishcanichu. Randi cunan can risha ñuca huauquigunata rimagri, ñuca Yayaga chasnallata cangunahua Yaya man, ñuca Diosca chasnallata cangunahua Dios man nisha rimagri. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chasnami Maria Magdalenaga risha cuintagrira Jesus japishca runagunataga Jesusta ricushcata, chasnallata tucui Jesus rimashcagunatas cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chi domingo punzhallata ña tutayaushcai, Jesus japishca runagunaga shuc huasibi tandarishca anaura, israel amugunata manzhasha pungugunatahuas alita tapasha. Chasna chi tucui pungugunata tapashca agllaita, Jesus cungaimanda pai japishca runagunahua chaupi chaupibi shayarira. Cangunahuacpi cushi ganas causai achun nisha saludara. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Casna saludashcahuasha paigunata paihua maquigunata ricuchira, paihua cushtillastas. Paigunaga chasna Señor Jesusta ricusha ashcatami cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chihuasha Jesus cutillata paigunata nira, Cushi cangunahuan achun. Ñáuca Yaya ñucata caima cachamushcacuinta, cangunatahuas cachanimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chasna nishallami paiguna jahuaibi pucusha nira, Diospa Samaitami cangunama cuni, ña cunan japichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Canguna shucpa juchagunatas perdunacpiga chi runa perdunashca saquiringa. Chasnallata canguna mana perdunacpiga, mana perdunashcachu saquiringa nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesus punda ricurishcaibiga chi Culluru nishca japishca runa Tomasca mana paiguna pariu aurachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Huashami chi shuc japishca runagunaga Tomasta ninaura, Señor Jesustami ricushcanchi nisha. Randi Tomas nira, Mana paihua maquibi quilabus juctugunata ricushaga pai sirtu causarishcata mana quirinata ushanichu, chasnallata ñuca riruta chi juctugunai mana satishaga, ñuca maquita paihua cushtillaspi mana satishaga mana quirishachu nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ñáa pusac (8) punzhahuasha Jesus japishca runagunaga cutillata chi huasibi tandarishca anaura Tomaspas paiguna pariu. Pungugunatas cuti tapashca agllaitami Jesus yaicura. Paiguna chaupi chaupibi shayarisha paigunata saludara, Cushi ganas causai cangunahuan achun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chihuasha nira, Ñáuca maquigunatas ricui Tomas, camba riruta caillai sati, camba maquita ñuca cushtillaspis saticshamui. Mana quiricca ama aichu, randi alita quirihuai nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas randi ainira, Ñáuca Señormi angui canga, ñuca Diosmi angui canga. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nicpi Jesus paita nira, Can ñucata ricushcahuashami quiringui Tomas. Chi ñucata mana ricushahuas quiriccunaga yapa cushi mangauna nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusca paita catic runaguna ñaupacpi Diospa ushaihuan pihuas mana rashcagunata mas ashcata rara. Tucui chigunaga cai libroibiga mana quillcashcachanaun. ");
INSERT INTO qvzNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Randi caigunaga quillcashca manaun paiga Yaya Dios cachashca quishpichic ashcata canguna quirinauchun nisha, Diospa churi ashcatahuas. Canguna paita quirisha huiñai causaita charinguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chihuasha Jesus cutillata ricurira pai japishca runagunahuacpi Tiberias nishca cucha linduspi. Casnami ricurira. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Aunaura pariu Simon Pedro, Culluru nishca Tomaspas, Galileamanda ac Caná llactamanda Natanaelbas, ñucanchi Zebedeoba churigunas auranchi, chasnallata ishcai (2) mas Jesus japishca runagunandi. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pedro paigunata nira licangahuami riuni nisha. Paigunahuas ninaura, Ñáucanchihuas canhuan pariumi shamunchi. Chasna nisha shuc barcoma yaicusha licangahua pariu rinaura, randi chi tutaga mana imatas japinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ñáa punzhayangaraushcaibi Jesus ricurimura chi cucha linduspi. Chasna agllaitami paiguna mana asirtanaurachu pai Jesus ashcata. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chasna allpamanda Jesus paigunata caparisha, Huauquiguna manachu japinguichi. Tapucpi ninaura, Mana imatas. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesus randi nira, Canguna licata barcomanda ali maqui partima shitasha japinguichimi. Pai nishcashina shitasha licata mana aisanata ushanaurachu, mana cáilla ashca aicha jundarishca acpi. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chasnaibimi Simon Pedrota nirani, Ñáucanchi Señormi an. Chasna Señormi nisha rimashcata uyashca ratuibi pai llucshichishca llachapata churarisha yacuma saltasha huaitasha mayanma rira. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chi shuccunaga barcohuan pulayama shamuranchi ashca aicha jundarishca licata aisasha. Pulayamanda mana caruibi chanaura, patsac (100) metros tupulla ara. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pulayama pactamusha ricuranchi ninata japichishcata, chi ninaibi shuc yacu aichas chasnallata panhuas tiyashcata ricuranchi. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pactacpi Jesus ñucanchita nira, Canguna japishcamanda ansa aichata apamuichi. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nicta uyasha Simon Pedro barcoma sicasha licata aisamura. Chibi ashca jatun yacu aichaguna jundarishca ara, patsac pichca chunga quimsa (153) jatun yacu aichami. Chasna agllaitami chi licaga mana ansallas liquirishcachara. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chimandahuasha Jesus ñucanchita micucshamuichi nira. Ñáucanchi Señor Jesus acta ña ricsishami mana pihuas tapuranchichu pitangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chihuasha Jesus ñucanchima caillayasha panda yacu aichandi cura micuichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus causarishcahuasha pai japishca runagunahuacpi ña cunan quimsa (3) cutinmi ricurira. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micushcahuasha Jesus Simon Pedrota tapura, Jonaspa churi Simon, caigunamanda yalitachu llaquihuangui. Pedro nira, Indá señor, ña yachanguimi ñuca canda llaquishcata. Nicpi Jesus paita nira, Ñáuca oveja huahuagunacuinta acta cuirai. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chihuasha Jesus cutillata tapura, Juanba churi Simon, ñucata llaquihuanguichu nicpi Pedro ainira, Indá señor, ña yachanguimi ñuca canda llaquishcataga. Nicpi Jesus randi nira, Ovejagunata carashcacuinta ñuca runagunata cuirai. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Quimsa (3) cutin tapusha nira, Juanba churi Simon ñucata llaquihuaunguichu. Ñáa quimsa cutin Jesus llaquihuanguichu nisha tapucpi Pedroga llaquirishca ainira, Canmi tucuita yachangui señor, ña yachanguimi ñuca canda llaquishcataga. Jesus randi nira, Ñáuca ovejagunata micunata carashcacuinta ñuca runagunata cuirai. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sirtupacha canda nini can malta ashcaibi canllata churaric arangui can munashcama ringahua. Randi can rucuyashami camba ishcai maquigunata chutachicpi shuc runaga camba llachapata churachisha apaitucungui can mana munashcama. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus casna rimashaga niurami Pedro imasna huañungaraushcata, chasna huañusha Diosta balichingaraushcatas. Chihuasha Jesus paita catihuai nira. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro bulltiarisha paigunahuashai ñuca shamucta ricuhuara, Jesus yapa llaquishca runata. Ñáucanchi puchucai tuta micuushcaibi Jesushuan pariu tiyausha pi tan canda japichingarauca señor nisha tapurani. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro ñucataga ricusha Jesusta tapura, Cai runaga imasata tucungaraun señor. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus paita cutipara, Canga imahuata yachanata munangui. Ñáuca cuti shamunagama pai causanata ñuca munacpihuas cambacpi mana imaschu. Canga ñucata catihuailla. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chasna Jesus rimashcamandami paigunapura chi runaga mana huañungachu nisha yuyaric anaura. Randi Jesusca mana nirachu mana huañungachu raun astahuan paimi nira ñuca shamunagama pai causanata ñuca munacpihuas canda mana imananzhu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ñáuca Jesus japishca Juanllatami imata ricushcatas uyashcatahuas caibiga quillcauni. ");
INSERT INTO qvzNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesusca caigunamandas mas ashca rashcagunatami rara. Chi tucuigunata quillcacpiga mundu intiruibi tiyac quillcagunaibi quillcacpihuas manachari pactanmachu.");
INSERT INTO qvzNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ñáuca llaquishca Teófilo, canda ñaupa quillcasha tucui Jesus rashcagunatas pai yachachishcagunatas quillcashcani. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jesus purishca urasmanda jahuama apaitucuna urasgama pai rashcamanda canda quillcashcani. Paiga chunga ishcai (12) runagunata japira paihua shimita apasha cuintangahua. Diospa Samai yuyaihuanmi Jesusca pai japishca runagunama cuintasha paiguna imata rangaraushcata yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Huañushcahuasha cuti causarisha paigunahuacpi ricurirami. Chasna ricurisha chuscu chunga (40) punzha tuputa ashcata rasha ricuchira pai sirtu causarishcata. Chasnallata Diospa ali mandanamanda paigunahuan cuintasha purira. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pai japishca runagunahuan tiyaushcaibi Jesus paigunata rimara, Jerusalenmanda ama llucshinguichichu, Yaya Dios rimashca shimi pactarinagama chillai chapaichi. Ñáuca ñaupa cangunata chi rimashcataga yachanguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Huañuc Bautisac Juan yacuibi bautisara. Chasnallatami ashilla punzhahuasha Diospa Samai bautisashca tucunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chasna paiguna Jesushuan tandarisha tiyaushcaibi tapunaura, Cunan uraschu israel llactata lugaryachingui señor paigunallata mandangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tapucpi rimara, Canguna mana minishtinguichichu yachanata. Yaya Diosllami yachan pai munashca ushaihuan rangaraushcata, chasnallata ima punzha rangaraushcatas yachan. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Chasna acpi cangunahuacpi Diospa Samai yaicucpi canguna ushaiyuc tucungaraunguichi. Chasna tucusha tucui partita ñucamanda rimac runa tucunguichimi. Jerusalen llactaibi, tucui Judea Samaria provinciagunaibi risha rimanguichimi, chasnallata tucui mundu llactagunatas ñucamanda rimagringuichimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chasna rimashcahuasha paiguna ricuusha shayaushcai Jesus ña jahuapachama apaitucungahua callarira. Shuc puyu paita catacpi mana mas ricunata ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chara paiguna jahuama ricuusha shayaushcai cungaimanda ishcai (2) runa ruyac churarishca paiguna mayanbi shayaucta ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Chi jahuama ricuusha shayaucunata tapunaura, Galileamanda runaguna, imaraicuta jahuamalla ricusha shayaunguichi. Cai cangunahuan auc Jesusca jahuapachama rishcacuintallata cuti cai pachama shamungami ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Angelguna chasna rimasha rishcahuasha Jesuspa runaguna Olivos nishca urcumanda Jerusalen llactamallata bulltiamunaura. Chi urcuga Jerusalen mayanllaibi mashca, mana yapa caru, ñalla shuc kilometro tupui man. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalen llactama shamusha paiguna tiyana jahua cuartoma yaicunaura. Chibi tandarigrinaura Pedro, Santiago, Juan, Andres, Felipe, Tomas, Bartolome, Mateo, Alfeohua churi Jacobo, cananeo muntunmanda Simon, chasnallata shuc Jacobohua huauqui Judas. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Paiguna shuc yuyaillahuan Diosta mañangahua tandarigrishcauna. Chasnallata paigunahuan tandarinaura Jesuspa huauquigunahuas, paihua mama Mariandi, shuc huarmigunandi. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Shuc patsac ishcai chunga (120) runa tupuchari anaura, Yaya Diosta mañangahua tandarisha causaunaura. Pedroga shuc punzha tucui chi quiriccuna ñaupacpi rimangahua shayarira. Casna nisha camachira, ");
INSERT INTO qvzNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","Uyaichi huauquiguna panigunas. Diospa Samai rimashcaga pactarina mara. Diospa Samai unai ñaupa israelgunata mandac rey amu Davidta quillcachira Judas Iscariotemanda. Judasca ñucanchihuan pariu yanapasha puric ashallata runagunata pushara Jesusta apangahua japisha huanchinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Paiga Jesusta japichingahua apashcamanda pagashca cullquihuan allpata randira. Chihuasha huañushcahuasha huicsa putasyasha partiricpi chunzhuli llucshira. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chasna acpi Jerusalen runaguna chita yachasha chi allpata shutichishcauna Rahuai Allpa nisha, paiguna shimibi Aceldama nin. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ñáaupa urasmi Judasmanda Salmos nishca libroibi israelgunata mandac rey amu David quillcara casna nisha: Paihua huasi jichurichun, ama pihuas chibi causachun. Shuc runa randi yaicuchun paihua tarabanaibi, nisha quillcashca ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Pedro mas paigunama cuintara, Cai quiric muntunmanda shuc runa Judas randimanda yaicuna man. Chi runaga Jesus caibi causaushcaibi ñucanchihuan pariu puric runa achun. Juan Jesusta bautisashca punzhamanda Jesus jahuapachama rina urascama ñucanchihuan pariu puric runa achun. Jesus causaricta ricuc asha, ñucanchishina yachachic runa achun. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro chasna rimacpi tucui runagunamanda ishcai (2) shutita anllanaura maicandata japishun nisha. Shuc runa Jose Barsabas, paihua shuc shutiga Justo nishca mara. Chi shuca Matiasmi. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Chi shutigunata tupashcahuasha Diosta casna mañanaura, Yaya Dios can tucui shungugunata yachangui. Cunanga ñucanchima ricuchingui cai ishcai (2) runamanda cai tarabanaibi Judas randimanda maicandas can anllangui Jesuspa shimita apasha puric runa tucuchun nisha. Judas paihua jucha rashcamanda paihua tarabanata saquira, huañusha turmintaringahua rishca, nisha mañanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mañasha tucuchishcahuasha maicanshi surtita charin nisha camangahua callarinaura. Chasna racpi Matiasta japisha yaicuchinaura. Chi anllashca punzhamanda chi Jesuspa shimita apasha puric chunga shuc (11) runagunahuan Matias yanapangahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chihuasha Pentecostes nishca israel jista punzha pactashcai tucui quiriccuna tandarisha pariu tiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Cungaimanda paiguna tiyaushca huasibi shuc sinzhi huairacuinta cielomanda uyarimura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chasnallata nina sindirishcacuinta caran runa jahuai urmamura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chasna asha Diospa Samai caran runa ucui jundacta yaicura. Pai yaicusha yuyachicpi caran tunu shimita cuintangahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chi jista punzhagunai israel runaguna Dios mandashcata pactachic asha caran llactamanda shamusha Jerusalenbi tiyaunaurami. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chi sinzhi huaira uyarimushcata uyasha tucui runaguna uctalla tandarimunaura. Pactasha caran runa paiguna quiquin shimigunai Jesuspa runaguna rimaushcata uyasha yapa manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Paigunapura manzharisha tapunacunaura, Manachu Galileamanda cai rimau runaguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Chasna agllaita imasnata tucui ñucanchi huahuamanda huiñashca shimigunata cunan uyanchi nisha tapunacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tucui llactamandami caibi aunchi. Maicanguna Partia llactamanda, maicanguna Midiamandas, Elanmandas, Mesopotamiamandas, Judeamandas, Capadociamandas, Pontomandas, chasnallata provincia Asiamandahuas aungunami ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Shuccuna Frigia llactamanda, Panfiliamandas, Egiptomandas, Cirene llacta mayan Libiamandahuas, chasnallata Roma llactamanda runaguna caibi aungunami. Chaupi runagunaga israelgunami, chaupigunaga israel yachaita mandashcagunatas caticcunami. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Chasnallata Creta islamandahuas caibi tiyaunguna, chasnallata Arabia partimanda runagunas tiyaunguna. Chasna acpi ñucanchi quiquin shimigunata alita rimaungunami. Paiguna tucui Dios ali rashcagunamanda cuintashcata uyanchimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chasna cuintasha tucuilla manzharisha ima yuyarinatahuas mana ushanaurachu. Paiguna imasna rashata ñucanchi shimita yachanaura nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Randi shuccuna asisha ninaura, Yapa machashca aunguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chasna ninaupi Pedro chi chunga shuc (11) Jesuspa shimita apau runagunandi shayarisha sinzhita camachira, casna nisha, Israel runagunas, tucui Jerusalenbi tiyaccunahuas uyaichi. Casna tucushcamanda ñuca rimangaraushcata alita uyaichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Canguna ñucanchita machashcami nisha rimanaupis mana sirtuchu, chara tutamandami, las nueve tupullami, mana machana uraschu. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Callari uras Joel nishca runaga Dios rimashcata pasachic ara huasha imasna tucungaraushcata rimasha. Pai rimaushcaga ña pactarishcami casna nisha: Dios casna rimara: Puchucai punzhagunaibi ñuca ushaiyuc Samaita cachashami tucui tunu runagunahuagma. Chasna racpi camba churigunas camba ushushigunahuas Diospa Samai rimachishcata cuintanaungami. Cangunahua musu runagunaga ñuca ricuchishcata muscunaungami. Chasnallata cangunahua rucu runagunatas puñushcaibi ñuca paigunata cuintashami, nisha huañuc Joelta Dios yuyachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chi punzhagunaibiga ñucata catic runagunama ñuca Samaita cachashami, carigunamas, huarmigunamas. Chasna tucucpi paiguna ñucamanda cuintanaungami, chasnami Dios nishca. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Manzhanayactagunatas cieloibi ricuchishami. Chasnallata cai allpaibiga rahuaihuanbas ninahuanbas cushnihuanbas manzhanayactagunatas rashami ñuca ushaiyuc acta ricuchishami canguna ñaupacpi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Diospa jatun taripana punzha mana pactamugllaita indi ansayangami, quilla pucayangami rahuaicuinta. Chi punzha tucui runaguna ñaupacpi manzhanayacta punzha angami. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Chasna acpi tucui Diospa shutihuan mañaccuna quishpishca tucungaunami. Dios chasna rimashcata Joel quillcashcami. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Chimandami Pedro mas rimasha catira, Uyaichi ñuca cuintangaraushcata israel runaguna. Dios paihua ushac yuyaita cura Nazaretmanda Jesusta. Chasna cucpi Jesusca cangunahuacpi ashca mana pihuas rashcagunata Diospa ushaihuan rasha janbira. Tucuimi chigunataga ricusha pai Diospagmanda shamushcata alita yachanguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Chasna agllaita Dios munashcamandami Jesusta canguna maquibi saquishca tucura. Dios ñaupata yachashcamanda canguna mana ali runaguna yanapashcahuan paita huanchiranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Canguna huanchigllaita Dios cuti causachira. Huañuiga mana usharachu Jesusta binsinata, chiraicu pai cuti causarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ñáa israelgunata mandac amu David chasna Jesus cuti causarina ashcamanda unai ñaupata quillcara casna nisha: Tucui uras Yaya Dios ñucahuan tiyaunmi ñucata yanapangahua. Paiga ñuca ali maqui partima tiyaunmi ama ñuca imatahuas manzhachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chasna acpi ñuca yapa ashcata cushiyarani. Ñáuca cushi shimihuan rimarani. Ñáuca aicha huañucpihuas Dios ñucata cuti causaringaraushcata yuyarisha cushiyani. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Can ñuca causaita mana saquisha cambagma apangaraungui. Cambac ashcamanda ñuca aichata mana saquingachuraungui ismuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Canhuan causanata yachachihuashcangui. Can ñucahuan aushcamandami cushiyachihuangaraungui. Chasnami David quillcara Jesucristo causarinamanda. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro mas cuintara, Sirtumi rimani huauquiguna. Ñáucanchi huañuc apayayagunata mandac rey amu David huañushcai pambanaura. Paita pambashca juctu chara aunmi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David ñaupa uraspi Dios rimashcata pasachic runa ara imasna huasha tucungaraushcata yachasha. Pai Dios sirtu rimashcata yachasha paihua miraimandallata shuc jatun paicuinta mandac shamunata yachara. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David chita yachashami Jesus cuti causarinata ricushcacuinta rimara quishpichighua causai mana huiñai huañushca saquiringachu, chasnallata paihua aicha mana ismungachu nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Diosca cai Jesusta huañuimanda causachirami. Chita ricusha ñucanchi paimanda rimaccuna anchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios Jesusta tucuigunamanda mas yalita balichira. Chasnallata Diospa Samaitas paima cura pai ñaupa rimashcacuinta. Pai randi ñucanchima cucpi cunan canguna tucui ricushcatas uyashcatahuas Jesusmi rara. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Mana Davidchu jahuapachama chasna tucusha rira. Chasna asha paillata nira: Jatun Dios ñucata mandacta rimara, Ñáuca ali maqui partibi tiyarilla canda piñaccunata binsinagama nisha nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tucui israelguna sirtu yachana manguichi canguna cruspi huanchishca Jesusllatata Yaya Dios japisha jatun mandac amu tucuchun nisha, quishpichic tucuchun nisha Cristota churara. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedro chasna rimashcata uyasha paiguna shungu ucui chucchurinaura. Chasna acpi Pedrotas chasnallata chi chunga shuc (11) Jesus japishca runagunatas chi uyaccuna tapunaura, Cunan imasata rashunchi huauquiguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tapunaupi Pedro nira, Caran shuc canguna jucha rashcagunata llaquirisha saquichi, Diosma shamuichi. Jesusca ñuca amu man nisha bautisarichi. Chasna racpi Dios canguna juchata maillangami, paihua Samaita cangunama cungami. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Diosca munanmi paihua Samaita cangunama cunata chasnallata camba miraigunamas, caruma causac runagunamas, tucui pai cayashca runagunamas. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Cai shimitas mas ashca shimigunatahuas Pedro paigunama cuintara. Chasnallata cunara, Anchurichi mana ali causac runagunamanda nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tucui Pedro rimashcata cadsuc runagunaga bautisarinaura. Chi punzhallata quimsa huaranga (3.000) tupu runaguna Jesusta quirisha ashcayanaura chi quiric runagunandi. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tucui chiguna Jesus japishca runaguna yachachishcata uyasha pactachisha causanaura. Paiguna pariumanda shuc yuyallahuan causanaura. Chasnallata tandarinaura Diosta mañangahua, chasnallata Jesus huañushcata yuyarisha panda paquisha pariu micunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Chasna acpi Jesus japishca runaguna pihuas mana raushcagunata Diospa ushaihuan ali rashcagunata ricusha tucui runaguna Diosta manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tucui quiriccuna pariu shuc yuyaillahuan causauc anaura. Chasnallata paigunapura tucui charishcata pariumanda chariu anaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Paiguna charishca baligunata randichisha paigunapura minishtishca tuputa caran amuma cumbiranaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Caran punzha Diosta alabana huasibi pariu tandarinaura. Chasnallata tandarinaura caran huasigunaibi Jesusmanda yuyarisha panda paquisha micungahua. Chasna pariu micusha cushi mansu shunguhuan tiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diosta alabasha causanaura. Chasna acpi tucui runagunaga Jesusta caticcunata llaquinaura. Chasnallata Dios caran punzha quiric muntunma yapachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro Juandi shuc chishibi Diosta alabana huasima rinaura las tres tuputa Diosta mañana uras acpi. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chibi shuc mana puric runata Diosta alabana huasi pungüibi apasha risha churagrishca anaura. Chi runaga pagarishcamandapacha mana puric runamagara. Caran punzha Gustu Pungu nishcaibi churashca tiyagara. Chi runa pungüibi tiyarisha tucui shamuc runagunata cullquita tapusha tiyaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro Juandi Diosta alabana huasi pungüi shamucpi chi mana puric runa paigunatas cullquita tapura. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chasna chi runa tapucpi Pedro Juandi paita ricusha rimanaura, Ñáucanchita ricui. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chasna rimacpi chi mana puric runa paigunata ricusha yuyarira, Imatashi cuhuangaraunguna nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Chasna pai yuyarisha tiyashcai Pedro rimara, Mana ima cullquitas charinichu. Chasna ashahuas canda yanapashcanguimi. Nazaretmanda Jesucristo shutihuan rimani jatarisha puri. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chasna nisha chi mana puric runahua ali maquimanda japisha jatarichira. Pedro rimasha japishca ratullai chi runahua chaqui mucuguna sinzhi tucucpi jatarisha shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chasna tucushami puringahua callarira. Saltasha Diosta cushihuan alabasha paigunahuan pariu Diosta alabana huasima yaicura. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ñáa tucui runaguna chi runa Diosta alabasha puriucta ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Chi runa chasna ali tucusha puriuta ricusha yapa manzharinaura, Manachu mana puric runa agara caiga, manachu Diosta alabana huasi pungüibi cullquita tapusha tiyagara cai rucuga, nisha tapunacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chi runaga Pedrogunamanda mana jichurirachu. Chasna puriuta ricusha tucui runaguna manzharisha Pedrogunahuagma callpamunaura Salomon nishca partima. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Shamunaupi Pedro chi runagunata camachingahua callarira casna nisha, Israel runaguna, canguna caita manzharisha ricusha imangahuata ñucanchima manzharishcahuan ricunguichi. Mana ñucanchi yuyaimandachu cai runa ña puric tucushca, mana ñucanchi ushaimandachu cunanga puriun. Astahuanbas Dios paita alichicpimi puriun. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñáucanchi huañuc apayayaguna Abrahanba, Isaacpa, Jacobohua Diosca pai munashcata rac Jesusta balichishcata ricuchingahuaca casna rashca. Chi Jesustaga cangunami amugunahuagma aparanguichi huanchinauchun nisha. Pilatoga Jesusta cacharingahua nicpihuas canguna mana munaranguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesusca Dios cachamushca runa ara, jucha illac ali causac runa mara. Chasna agllaita canguna mana munaranguichichu paita cacharinata. Randi shuc huanchic runataga cachari nisha rimaranguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chi causaita cuc runataga huanchinauchun nisha saquiranguichi. Chasna acpihuas pai huañushcamandahuas Dios causachira. Chitaga ricuranchimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesuspa shutiga balic man. Ñáucanchi Jesusta quirisha paihua shutita rimashcamandami cai canguna ricsishca runaga aliyashca. Paihua shutimanda paita quirishcamandahuas Jesus cai runata alichira cangunahuacpi. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Cangunata mandaucunandi Jesusta huanchisha canguna raushcata mana yachashami huanchiranguichi huauquiguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dios tucui pai ñaupa rimashcata pasachic runagunata chasna rimachira quishpichic Cristoga huañunallata man nisha. Ñáa chi shimiga pactarishcami Dios rimashcashina. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chasna acpi cuti yuyarichi. Cunanga canguna jucha rashcata llaquirisha saquichi, Diospagma bulltiaichi canguna juchata anchuchitucungahua. Canguna chasna racpi Dios cungailla cushi causaita cangunama cunga. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Diosma bulltiacpi pai cangunahuagma cuti Jesusta cachangami. Jesucristo quishpichic tucuchun nisha paita cachara cangunata quishpichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesus jahuapachaibi tiyangamiraun hasta Yaya Dios tucuita alichinagama, pai rimashcata pasachic sumagyachishca runagunama rimachishcashina. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ñáaupa causac Moisesca ñucanchi huañuc apayayagunama casna nisha rimara: Jatun Diosca ñucata cangunama cachashcacuinta pai shuc rimashcata pasachic runataga ñucanchi muntunmandallata huasha cachangami nira. Pai rimashca shimitaga tucuita alita uyasha pactachina manguichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chasna acpi maican runahuas cai runata mana uyashaga huanchitucungaraun, nisha rimara Moisesca. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Chi Samuel urasmanda cunangama Dios rimashcata pasachic runaguna Jesusmanda rimaushcaunami. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Paiguna rimashca ali shimigunaga cangunaraicu quillcashca anaun. Cangunaga Dios rimashcata pasachic runagunamanda miraiguna acpimi Dios pactachina shimiga cangunahuagmas pactamushca. Chimanda Dios ñucanchi huañuc apayaya Abrahanda casna nira: Cambagmanda mirai runagunaga tucui llactaibi tiyac runagunata yanapanaungami. ");
INSERT INTO qvzNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chasna nisha Dios paihua churitaga cangunahuagma ñaupata cachara canguna jucha rashcagunata saquichingahua. Pedro casna nisha runagunata camachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro Juanbas chara runagunata camachiullaita israel pagriguna, Diosta alabana huasita cuiraccunata mandac runandi shamunaura. Chasnallata shamunaura mana cuti causarinamanda yuyaric saduceo nishca israelgunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro Juandi runagunata ña yachachiunaura Jesus cuti causarishcami nisha, chasnallata tucui huañushca runagunahuas cuti causarinaungami nisha. Chasna yachachiupi chi amuguna yapa piñarisha shamunaura Pedrogunahuagma. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Caudsayachishun nisha Pedrogunata japinaura. Ñáa chishi acpi carcelbi tapanaura cayagama aunauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Chasna agllaita Pedroguna camachishcata uyasha ashca runaguna quirishcauna. Puru carigunallata yupacpi cadsi pichca huaranga (5.000) tupu mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Cayandi punzha Jerusalen llactaibi tandarimunaura israel pagri amugunas, israel rucu mandac runagunahuas, chasnallata Moises quillcashcata yachachiccunahuas tandarimunaura Pedrogunata taripangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chasnallata aunaura israelguna jatun pagri Anas nishca, Caifaspas, shuc Juanbas, Alejandrohuas, tucui Anaspa aillugunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chasna tandarimusha Pedrota Juandas carcelmanda apagrichi nisha cachanaura. Ñáa paiguna ñaupacpi apagrisha shayachicpi tapunaura, pi mandacpita casna ranguichi, pihua ushaihuanda chi mana puric runata alichishcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Chasna paigunata tapucpi Diospa Samai Pedrohuacpi jundashca asha yuyaita cucpi paigunata nira, Israel amugunas, mandac rucugunahuas, cai ali rashcamanda imasna rashata cai mana puric runa aliyashca tucura nishachu tapuhuanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Canguna, tucui israel runagunahuas, ñuca rimangaraushcata uyaichi. Nazaret llactamanda Jesucristomi caibi shayau runata alichira. Canguna Jesusta huanchiranguichi, chasna racpihuas Dios paita cuti causachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yuyarichi. Jesusca shuc rumicuinta man. Cangunaga huasita raucunacuinta manguichi. Cai rumicuinta ac Jesusta canguna mana balinzhu nisha jichuranguichi. Randi Dios paihua huasita rangahua tucui shuc rumigunamanda chi canguna jichushca rumitaga mas yalita balichisha apara. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesusllami ñucanchita quishpichic an. Pihuas paita mana quirisha mana quishpingachu. Cai munduibi pihuas mana tiyanzhu juchayuc runagunata quishpichicca. Randi Jesusllami ushan nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chi israel pagri amugunaga Pedro Juanbas mana manzhasha rimaucta uyasha, chasnallata paiguna mana yapa quillcata ricucta asirtasha manzharinaura imamandata cai tucuita yachanaun nisha. Chasnallata Pedroguna Jesushuan pariu puric acta asirtanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chasnallata chi mana puric acta alichishca runa Pedrogunahuan pariu shayauta ricunaura. Chita ricusha mana imasahuas ushanaurachu paigunata rimanata piñaushallata. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chasna acpi amuguna Pedrogunata mandanaura chi tandarina muntunmanda llucshinauchun nisha amupuralla cuintanacungahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chasna llucshichishcahuasha paigunapura cuintanacunaura, Cunan imatata rashunchi. Cai runaguna mana pihuas raushcataga tucui Jerusalenbi causaucuna yachanaunmi. Chasna acpi ñucanchiga mana imatahuas ranata ushanchichu. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Randi ña cai shimi ama mas mirarisha richun nisha paigunata sinzhita urdinashunchi ima uraspas cunanmanda ñaupagma ama pitahuas casna Jesusmanda rimaichichu nisha rimashunchi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chasna yuyarisha Pedrogunata cuti cayasha mandanaura, Ama ima uraspas yachachinguichichu Jesus huañushcamanda cuti causarishcami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Chasna ninaupi Pedro Juandi amugunata rimanaura, Cangunallata yuyarichi, alichan cangunata uyangahua Diosta uyana randimanda. Diospacpiga maicanda ali anga. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ñáucanchi ricushcatahuas uyashcatahuas ñucanchiga rimaunchi, chiraicumi mana ushanchi ñucanchi chasna rimaushcatas saquinata, nisha amugunata rimanaura Pedroguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Chi alichishca runaga chuscu chunga (40) yali huatayuc mara. Chasnallata pai aliyashcamanda tucui runaguna Diosta alabashcauna. Chi amuguna ña mana imamandahuas libachinata tupasha Pedrogunata manzhachingahuaca piñashca shimillahuan rimasha cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro Juandi lugaryashcahuasha paiguna amigoguna aushcama risha israel pagri amuguna rucugunahuas rimashcata cuintagrinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chasna cuintacta uyasha tucuilla Diosta mañasha tapunaura casna nisha, Tucuita mandac Yaya Dios, canmi cai allpatas, cielotas, lamartas, tucui chibi tiyaccunatas rac jatun Dios angui. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Canda sirbic ñucanchi huañuc apayaya Davidta Diospa Samai rimachishca casna nisha: Imaraicuta chi mana-israel runagunaga piñarisha purinaura. Imaraicuta Diosta cuntar tucushun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cai mundui mandaucunahuas, tucui amugunahuas pariu tandarinaura jatun Diosta pai cachashca quishpichictahuas piñasha anchuchishunchi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sirtumi cunan cai Jerusalen llactai mandac amuguna Herodes, Pilatohuas tandarinaura mana-israel runagunahuan, israel runagunandi camba jucha illac churi Jesusta piñashcamanda. Can paita anllashca runa agllaita paiguna huanchinata munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chasna asha paiguna tucuita ranaura can ñaupa rimashcacuinta. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Chasna acpi paiguna ñucanchita mana ali rimashcagunatas yuyaringui Yaya. Ñáucanchi canda sirbiccuna acpi cunanga ñucanchima jursata cungui ñucanchi camba shimita mana manzhasha rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chasnallata Yaya, camba jucha illac churi Jesuspa ushaiyuc shutihuanmi ungushca runagunata alichingui, chasnallata pihuas mana raushcagunata rasha camba ushaita ricuchingui, nisha Yaya Diosta mañasha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chasna nisha mañashcahuasha chi intiru huasi cuyurira. Tucui paigunaibi Diospa Samai jundacta yaicushca asha Diospa shimita mana manzhasha rimasha purinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Chasnallata Diosta quiric runaguna pariulla shuc yuyaillahuan causaushcauna. Mana pihuas rimanaurachu ñuca charishcaga ñucahuagmi nisha, randi ñucanchi charishcagunaga tucuibac man nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesus japishca runagunaga Jesus causarishcamanda yachachisha Diospa sinzhi ushaihuan ashcata rashcaunami. Yaya Dios tucui quiriccunata yapa llaquisha ashcata yanapara. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Shuc yuyaillata charishcamanda paigunapura mana imahuas pishirachu. Maicanbas allpata huasitas charisha, randichisha chi cullquita apamunaura Jesuspa shimita apaucunama cungahua. Cucpi japisha caran pishic runama minishtishca tuputa cumbiranaura. Chasna cucpi mana pihuas pishitucusha causanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Shuc quiric runa Chipre nishca islamanda Josega paigunahuan causac ara. Paiga israel pagrigunata yanapac levita nishca muntunmanda ara. Chi runa alita yanapac runa acpi Jesus japishca runaguna shuc shutita churanaura Bernabe achun nisha. Chiga Ali Yanapac ninmi. ");
INSERT INTO qvzNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Chi runaga pai charishca allpata randichisha Jesus japishca runagunama cullquita cura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chasna acpi shuc Ananias nishca runa paihua huarmi Safirandi chasnallata randichinaura paiguna allpata. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pai randichishca cullquita chaupita mitsasha saquira paihuacta rangahua. Chasna rashcata paihua huarmi ricusha yachara. Chasna chaupi cullquitaga Jesus japishca runagunama Ananias cura ñucanchi allpata randichishcamanda cullquimi nishcashina. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chasna racpi Pedro asirtasha rimara, Ananias imangahuata supai amu Satanasta can lugarta curangui casna Diospa Samaita llullangahuaca, camba chaupi cullquitaga saquishcangui cambacta rangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Chi allpata mana chara randichishallata manachu cambac ara. Randichishcahuasha chi cullqui manachu cambac ara. Imasna yuyarishata casnaga rarangui. Mana runatachu llullashcangui astahuanbas Diostami llullashcangui. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pedro chasna rimashcata uyasha Ananias huañusha urmara. Tucui runaguna Ananias huañushcata uyasha yapa manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ñáa Ananias huañucpi musu runaguna llachapahuan pillusha pambangahua apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cadsi quimsa (3) uras tupu paihua huarmi Safira randi yaicumura ima tucushcatas mana yachasha. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chasna acpi Pedro paitahuas tapura, Rimahuai, canguna allpata cai tupullaichu randichiranguichi. Tapucpi chi huarmi cutipara, Indá, chi tupullaimi randichiranchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Indá nisha cutipacpi Pedro nira, Imangahuata canguna ishcandiguna Diospa Samaita llullanguichi. Uyai, chi canzhaibi shamuunguna camba carita pambangahua ric runaguna. Chasnallata candahuas pambangahua apangaraunguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pedro rimashca ratullai chi huarmi huañusha urmara Pedrohua chaqui mayanbi. Chi musu runaguna yaicusha pai huañushcata tupasha paihua aichata apanaura paihua cari mayanbi pambangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chasna tucucpi tucui quiric runagunas, chasna tucushcata uyaccunahuas ashcata manzharinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","15","Tucui uras quiric runaguna huin tandarinaura Diosta alabana huasi pungüi Salomon nishca partibi. Tucui mana quiric runaguna Jesusta quiric runagunata yapa balichinaura, chasna ashallata maicanguna mandauc amuta manzhasha paigunahuan pariu purinata mana munanaurachu. Chasna agllaita ashcaguna Jesusta quirisha chi quiriccuna partima yaparinaura carigunas huarmigunahuas. Chi uras Jesus japishca runagunaga pihuas mana rashcagunata rasha runagunata Jesuspa ushaita ricuchinaura. Chasna acpi ashca ungushcagunata huasimanda llucshichisha ñambi mayanbi churanaura Pedro chita pasausha paihua alma maican runagunallaibias llanduyachisha janbichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Chasnallata mayan llactagunamandas ashca runaguna Jerusalenma shamunaura ungushcagunata apasha, chasnallata supai yaicushca runagunatas apasha. Tucuiguna alichisha saquirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chasna acpi israel pagrigunahua amu, huañusha mana cuti causarinachun nisha rimac saduceogunahuas yapa piñanaura Jesus anllashca chunga ishcai (12) apauc runagunata. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chasna piñasha Pedrogunata caudsayachisha carcelbi tapangahua apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Chi tutallata Diospa angel carcel punguta pascasha Pedrogunata llucshichisha casna nisha cachara, ");
INSERT INTO qvzNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Richi Diosta alabana huasima. Chibi tiyauc runagunata Jesus mushuc causaita cuc man nisha tucuita yachachigrichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Angel chasna rimacpi Pedroguna carcelmanda llucshisha cayandi tutamanda Diosta alabana huasibi yaicusha yachachingahua callarinaura. Israel pagrigunahua amu tucui paihuan tiyaucunandi tandachinaura israel llactaibi taripac rucugunata. Paiguna tandarishcahuasha Pedrogunata carcelmanda apangahua cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cachacpi sundaluguna chibi pactasha Pedrogunata carcelbi mana tiyacta ricusha amugunata cuintangahua bulltianaura casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ñáucanchi carcelbi pactasha ricucpi caran pungüi shayau sundalugunata ricuranchi. Punguta ricucpihuas tác tapashca mara, pascasha ricucpi mana pihuas ucuibi tiyarachu, nisha cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Diosta alabana huasita cuiraucunata mandaucpas, israel pagrigunata mandauc amugunahuas chasna nishcata uyasha tucui paigunapura cuintanacunaura, Maitashi rinaura, imashi tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Paiguna chasna cuintaushcai shuc runa pactagrisha rimara, Canguna carcelbi tapashca runagunaga Diosta alabana huasibimi tucui runagunata yachachiunguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chasna rimacpi chi sundaluta mandac runa paihua sundalugunandi Diospa huasimanda Pedrogunata apangahua rinaura. Randi runaguna ñucanchita rumihuan tucsitucushunmi nisha manzhasha Pedrogunata mana tangashcata japisha apanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ñáa Pedrogunata apasha amuguna tiyana cuartoma yaicuchinaura. Paiguna ñaupacpi pactachicpi israel pagrigunahua amu tapura, ");
INSERT INTO qvzNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Manachu ñucanchiga ñaupata cangunata mandaranchi ama Jesusmanda yachachinguichichu nisha. Canguna yachachishca shimiga intiru Jerusalendami uyarishcaya. Chasnallata paigunata yachachiushaga Jesustaga paigunami huanchinaura nisha ñucanchima juchachisha purishcanguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chasna chi amu ninaupi Pedro chi shuccunandi rimanaura, Ñáucanchiga runata uyanarandimanda Diostami uyana anchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Cangunami Jesusta cruspi churasha huanchiranguichi, astahuanbas ñucanchi huañuc apayayagunahua Diosca Jesusta causachirami. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chasna causachishami Diosca Jesusta balichisha paihua ali maqui partima churara quishpichic jatun mandac amu tucuchun nisha. Israelguna juchata rashcamanda llaquirisha Yaya Diospagma bulltianaupi paiguna juchagunata pai anchuchisha quishpichingahuami chasnaga churara. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Chigunata ñucanchiga ricusha rimaccuna manchi. Dios paita uyaccunama cushca Samaiga chasnallatami asirtachin. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pedroguna chasna rimashcata uyasha chi amuguna paigunata yapa piñasha huanchinata munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Randi chi israel amuguna muntunbi shuc runa Gamaliel nishca tiyara. Chi runaga Moises mandashcagunata yachachic acpimi tucui runaguna paita yapa uyaganaura. Chi runa shayarisha Pedrogunata shuc ratu canzhama cachangahua mandara amugunapuralla cuintanacungahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Paigunata canzhama cachashcahuasha Gamaliel chi shuc amugunata rimara, Israel runaguna uyahuaichi. Cai Jesusmanda rimac runagunahuan imata ranata munashaga ñaupata alita yuyaringuichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yuyarichi imasna ñaupa uras shuc Teudas nishca runaga ñuca amu mani nicpi cadsi chuscu patsac (400) runa tupu paita catic anaura. Chihuasha Teudasta huanchishca tucucpi tucui paita catiucuna sáa tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chihuasha randi, runagunata yupana uras, shuc Galileamanda Judas nishca runa shamucpi ashca runaguna paihuan catic anaura. Paitas huanchicpi paita caticcunahuas chasnallata sáa tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chasna acpi cangunata rimani, cunanga cai Jesusmanda rimaccunata saquichi. Paiguna rashcahuas yachachishcahuas runa yuyaimanda ashaga tucurinmami. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Randi Diosmanda acpiga canguna mana ushanguichichu tucuchinata. Tucuchishun nisha yuyarishahuas Dioshuan macanacunguichimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel chasna rimashcata uyasha amuguna cuti cayanaura Pedrogunata. Paigunata libachishcahuasha cuti mandanaura, Ama mas Jesusmanda rimanguichichu nisha. Chasna mandashcahuasha cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Chi libachishca runaguna amugunahuagmanda llucshisha riusha Dios ñucanchita lugarta cushcami ñucanchi Jesusta quirishcamanda turmintachishca tucungahua nisha cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chasna libachishca acpihuas caran punzha Diosta alabana huasibi chasnallata caran huasigunaibihuas mana saquinaurachu Jesucristomanda ali shimita yachachinata. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chi uras Jesusta quirisha yaparisha yaparisha rinaura. Chasna ashcai griego shimita rimac israelgunaga piñangahua callarinaura hebreo shimita rimac israelgunata. Piñasha ninaura, Caran punzha micunata chaupichisha ñucanchi muntunmanda huaccha huarmigunata mitsanguichi, randi canguna muntunmanda huaccha huarmigunata ashcata cunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chasna piñanaupi chi chunga ishcai (12) Jesus japishca runaguna tucui quiriccunata tandachinaura rimangahua, Ñáucanchiga Diospa shimita yachachina manchi, chiraicumanda cunanga micunata caranma cunata saquinchi mas Diospa shimita yachachisha catingahua. Ñáucanchiga Diospa shimita yachachinata saquisha micunata cunataga mana balinzhu. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chasna acpi huauquiguna, cangunapuramandallata canzhis (7) runagunata anllaichi chi huaccha huarmigunata micunatas caranma cungahua. Canguna ricsishca runagunaga anauchun ali causaccuna, yuyaiyuccuna, chasnallata Diospa Samai jundashca runaguna anauchun. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ñáucanchiga Dioshuan cuintasha chasnallata paihua shimita yachachisha catingaraunchi nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chasna nishcata uyasha tucuilla ali man nisha cushiyanaura. Mascasha japinaura Estebanda, sinzhi quiric, Diospa Samai jundashca acta. Chasnallata japinaura Felipe, Prócoro, Nicanor, Timon, Parmenas, Antioquia llactamanda Nicolastas. Cai Nicolasca shuc muntunmanda asha israel yachachishcata uyac runa ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chi canzhis runagunata japishcahuasha apanaura Jesus japishca runagunahuagma. Apacpi chi canzhis runaguna uma jahuai maquita churasha Diosta mañanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chi uras Diospa shimi Jerusalenbi mirarisha riupi yapa ashca runaguna quirinaura, ashca israel pagrigunahuas Jesusmanda yachachishcata uyasha quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanda Dios yapa llaquisha ashca ushaita yuyaitas cushca ara. Chasna asha chi Diospa ushaihuanmi runagunahuacpi mana pihuas raushcagunata manzhanayacta rara. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pai yachachiushcata uyasha carumanda shamuc mana quiric israel runaguna paita piñanaura. Chi runaguna anaura Cirene llactamanda, shuccuna Alejandria llactamanda, Cilicia, Asia provinciagunamandas anaura. Paigunaga israelguna tandarina huasi Dihuimanda Llushpirishcaguna nishca huasibi tandaric anaura. Chiguna tandariusha pariumanda Estebanhuan rimanacungahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Esteban Diospa Samaihuan, ali yachashcahuanbas yachachira. Chasna acpi chi runaguna paita binsinatas mana ushasha piñanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Piñasha shuc runagunama pacalla paganaura Estebanmanda llullanauchun nisha. Pagausha casna rimanguichi, cai Estebanga Moises mandashcagunata Diosta mana balichinzhu nishcata uyashcanchi, camisha rimashcatahuas uyashcanchi nisha rimaichi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chi llullaguna chasna rimasha tucui runagunata, israel rucu amugunatas, Diospa shimita yachachiccunatahuas turbachinaura. Chasna rasha Estebanda japisha aisasha israel taripaccunahuagma apanaura caudsayachingahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chasnallata chi yanga llulla runagunatas apanaura ñucanchi rimashcata cuintaichi nisha. Taripaccunahuacpi chi llullaguna casna rimanaura, Cai runaga Diosta alabana huasimanda chasnallata Moises mandashcagunamandahuas yapa mana alita rimasha puriun nisha llullanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nazaretmanda Jesusca Diospa huasita tulangamiraun nisha camachishcata uyashcanchi. Chasnallata Moises ñucanchima yachachishcacuinta causanata Jesus tucuita cambiangami nishcata uyaranchi, nisha chi llullaguna israel taripac runagunahuacpi rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chasna paiguna nicpimi tucui chibi auc amuguna Estebanda ricunaura. Paihua ñahuiga angelba ñahuicuinta ricuricta ricunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chi runaguna llullanaupi israel pagriguna amuga Estebanda tapura, Canmanda rimashca shimi sirtuchan. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Chasna tapucpi Esteban paigunata rimara, Huauquiguna, apayayagunahuas uyaichi. Ñáucanchi gustu punzhaglla ricuric Diosca ñucanchihua huañuc apayaya Abrahanbacpi ricurira. Abrahan Haran nishca llactama mana rigllaita, chi Mesopotamia partibi chara aushcallaita Dios paihuacpi ricurira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ricurisha paita nira: Camba aillugunatas camba allpatas saquisha llucshisha ri ñuca canda ricuchingaraushca allpama. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dios chasna rimacpi Abrahan chi Caldeo nishca partimanda llucshisha rirami Haran llactama causangahua. Chi llactaibi causaushcai paihua yaya huañura. Chasna huañushcahuasha Dios chi llactamanda Abrahanda llucshichisha pushamura cai ñucanchi causaushca allpama. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chi uras Dios cai allpata paima ansahuallas mana curachu. Chasna ashallata shuc pactachina shimita Abrahanda cuintara casna nisha: Can huañucpi cai allpaga camba churigunahuac saquiringami nira. Ñáa Dios chasna rimashca urasca Abrahan chara shuc huahuallahuas mana charirachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chasna acpihuas Dios cuintara Abrahanda: Canmanda miraiguna shuccunahua allpaibi causangaunami shuc caru llactamanda ric runacuinta. Chi llactaibi causaccunaga canmanda miraigunata chuscu patsac (400) huatata caudsayuctacuinta turmintachinaunga. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Paigunata mandausha turmintachishcamanda chi llactagunata ñuca taripashami. Chihuashaga chi llactamanda llucshinaungami. Llucshinaupiga ñuca cai canma cushca allpaibi ñucata alabanaungami nishcami. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Diosca Abrahanda cai pactachina shimita cusha rimara ullucarapundata pitina mangui israel runa tucungahua nisha. Chita uyasha Abrahan ña Dios rimashcata pactachingahua paihua churi Isaac pusac (8) punzhata charicpi churihua ullucarapundata pitira. Isaacpa churiga Jacobo mashca, Jacoboga ña chunga ishcai (12) churigunata charishca. Paigunaga ñucanchi apayayagunami ashcauna. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Esteban mas cuintara casna nisha, Chi Jacobohua churiguna paiguna quipa huauqui Joseta piñasha shuc runagunama randichinaura. Randichicpiga Joseta huatashca runatacuinta Egipto llactama causachun nisha apanaura. Chasna shuc llactama apanaupis Diosca Josehuanmi ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Paihuan asha yanapasha chi tucuita turmintarishcamanda lugaryachira. Chi Egipto llactaibi Faraon nishca jatun mandac amuhua shungüibi Dios Joseta llaquinata yuyachira. Chasnallata Faraonba ñaupacpi Joseta ali yuyaita cura. Chasna racpi Faraonga Joseta tucui Egipto llactata mandac amuta churara. Chasnallata Faraonba huasibihuas Jose mandac amu tucura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Chi uraspi ashca raicai tucui Egipto llactaibi tucura, chasnallata Canaan nishca llactaibis ashca raicai shamura. Ñáucanchi huañuc apayayagunaga ima micunatahuas mana charinaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egipto llactai micuna muyu tiyanmi nishcata uyasha Jacobo paihua churigunata chi llactama cachara micunata randisha apamungahua. Chibimi punda cachacpi rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chihuasha cuti cachashca pactashcaibi Jose paihua huauquigunata rimara ñuca camba huauqui Jose mani. Nisha rimacpi paiguna ña ricsinaura pai pi ashcata. Chasna racpi Faraon yachara ima tunu aillumanda Jose ashcata. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chihuasha Jose paihua yaya Jacobota tucui paihua aillugunandi huin pushamungahua cachara. Llambuguna anaura canzhis chunga pichca (75) runaguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chasna paihua churi Jose cayacpi Jacobo Egiptoma causangahua rira. Chi llactaibi Jacobo huañura, chasnallata chillaita huañunaura ñucanchi apayayagunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chasna huañunaupi huasha paiguna tullugunata Siquem nishca llactama apanaushca pambangahua. Chi llactaibi Abrahan ñaupa uras Siquem llactamanda Hamorba churigunahua allpata randishcami paihua huarmi huañushcata pambangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Dios Abrahanma pactachishami nisha rimashca shimi ña pactariupi Jacobomanda miraiguna Egipto llactaibi yapa miraunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chihuasha shuc jatun mandac amu randi cambiarira Egipto llactata mandangahua. Chi mushuc amuga Jose ali rashcagunata mana yachacchara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chi amuga ñucanchi aillugunata yapa turmintachira. Chasnallata tucurinauchun nisha chi amu mandara canguna mushuc pagaric huahuagunata huanchichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chi mandauc amu chasna rimaushca uraspi Moisesmi pagarira. Chi huahuataga Dios gustara. Chi huahuaga paihua yayahua huasibi quimsa (3) quillata cuirashca mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chihuasha huasimanda jichushcacuinta tucucpi, amuhua ushushiga chi huahuata apasha paihua quiquin churitacuinta huiñachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chasna apasha huiñachicpi egipto runagunahua yuyaita Moises tucuita yachasha huiñara. Pai yapa alita rimac, ali yuyaiyuc runa tucura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moises ña chuscu chunga (40) huatata chariusha paihua aillu israelgunata pasiagrinata munara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chasna munasha puriushcai shuc Egipto runa shuc israel runata piñasha libachisha macauta Moises ricura. Chi israel runata quishpichinata munashaga chi macauc Egipto runata Moises huactasha huanchira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moises yuyarira Dios paigunata ñuca yanapahuashcanga lugaryachingaraushcata yachangaunami nisha. Randi paiguna mana chasnamanda musianaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ñáa cayandi punzha Moises chillaita puriusha ishcai (2) israel runapura piñanacusha macanacucta ricura. Pai jarcasha alichinata munasha rimara, Canguna aillupura ashallata imahuata macanacunguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Chasna rimacpi chi mana alita rauc runa paita piñarisha tangara pita canda churara ñucanchita taripac amu tucungahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ñáucatahuas huanchisha ninguichu chi Egipto runata can caina huanchishcacuinta piñarisha tapura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chasna tapushcata uyasha Moises manzharisha caruta miticusha rira. Madian nishca allpama risha yanga puriccuinta causaura. Chibi causaushcaibi pai cadsarasha ishcai (2) churita charira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Chuscu chunga (40) huatahuashai Sinaí nishca urcu sapibi chaquishca pambaibi Moises puriushcaibi shuc ruya japiriushcai Diospa angel ricurira paihua ñaupacpi. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moises chita ricusha manzharira. Manzhaushallata alita ricunata munasha caillayasha Dios rimauta uyara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Dios paita rimara, Ñáucaga camba huañuc apayaya Abrahanba, Isaacpa, Jacobohua Dios mani nisha. Chasna rimacta uyasha Moises manzharisha chucchurira, ricunatas mana munarachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chihuasha Dios cuti paita rimara, Camba chaquimanda sandallatas llucshichi. Can shayaushca pambaga ñucahua sumac allpami nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Sirtumi ñucahua runaguna Egipto llactaibi turmintariushcata ñuca ricusha, paiguna huacashcatas uyasha, ña paigunata lugaryachingahua uraicumuni. Chasna rasha ñuca cunan candaga cachangarauni Egipto llactama nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Chi israelguna ñaupa Moisesta piñasha rimanaura pita candaga churara ñucanchita mandauc amu tucungahua nisha. Chasna nigllaita randi Dios Moisesta cachara mandac tucusha paigunata quishpichingahua nisha. Paitaga cachara chi ninayuc ruyai ricuric angel yanapashcahuan. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Chasna rasha Moisesca chi israel runagunata Egipto llactamanda llucshichira jatun manzhanayaccunata rasha Dios ushaiyuc ashcata ricuchira. Egipto llactaibi, chasnallata Puca Lamar nishcaibis, chasnallata chaquishca pambai paiguna chuscu chunga (40) huatata purishcaibihuas pihuas mana raushcagunata manzhanayacta ricuchira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisesca israel runagunata rimara, Canguna muntunmandallata Dios pai rimashcata shuc pasachic runata cachangami ñucacuinta cangunama paihua shimita rimachun nisha. Paitaga uyana manguichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ñáucanchi huañuc apayayaguna paiguna chaquishca pambaibi tiyaushcai chi Sinaí nishca urcuibi Moiseshuan chi angel cuintara. Moises randiga ñucanchi huañuc apayayagunama pasachira. Paigunahuas chi shimillata ñucanchima yachachisha saquinaura. Chi shimigunaga ñucanchi ali causanauchun nisha rimashca mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Chasna Moises pasachishca acpihuas ñucanchi huañuc apayayaguna mana uyanata munasha paita mana balichinaurachu. Chasna rasha paiguna shungüibi Egipto llactama bulltiashun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chi urcuibi Moises yapa unayacpi israel runaguna paihua huauqui Aaronda ninaura, Mana yachanchichu chi Egipto llactamanda ñucanchita llucshichimuc Moises ima tucushcatas. Cunanga shuc dioscunata rasha cuhuai paiguna randi ñucanchita pushangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chi runaguna chasna rimasha Moises illashca uraspi shuc curimanda huagratacuinta ranaura. Chasna rasha aichagunata huanchisha rahuaita ricuchisha chi curimanda rashca yanga diosta alabanaura. Paiguna quiquin maquihuan rashca diosta ricusha cushiyasha balichinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Paiguna chasna raucta ricusha causac Diosca paigunahuagmanda anchurira. Paiguna ima tunus cieloibi tiyaucunata alabasha sirbinauchun nisha paigunata saquira. Chasna Dios rimashcata pasachiccuna ñaupaga quillcanaura: Israel runaguna, canguna chaquishca pambaibi chuscu chunga (40) huatata puriusha aichagunata huanchisha ñucamallatachu ricuchisha alabasha puriranguichi. Manapacha. Astahuanbas shuc tunuta yuyarishami puriranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Moloc nishca yanga diospa huasitas balichisha apasha puringuichimi, Renfán nishca yanga diospa estrellastas balichishcanguichimi. Chasnallata paigunacuinta ricuriccunata rasha balichisha causashcanguichimi. Chi yanga diosta alabashcamandami ñuca cangunata caudsayachisha ñuca cushca llactamanda caru Babilonia nishca llacta huashama cachashcanguichimi, nisha Dios rimara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Chi chaquishca pambaibi causaushca uras ñucanchi huañuc apayayagunaga Dios paigunahuan tiyana carpa huasita charishcauna. Chi huasiga Dios Moisesta ricuchishca tunuta rashca mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Moises huañushcahuashaga Josue ñucanchi huañuc apayayagunata mandac ara. Chi chaquishca pambamanda paiguna llucshisha riusha Diospa huasita apasha rishcauna Dios cushami nishca allpama. Chibi ricpi chi allpaibi causac runagunata Dios callpachira ñucanchi apayayaguna ñaupagmanda. Chi urasmanda David israelgunata mandac amu tucuna urascama ñucanchi huañuc apayayaguna chi allpai causausha chi carpa huasita charishcaunami. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios yapa llaquishca Davidga Diospa ali huasita shayachinata munara, ñucanchi huañuc apayaya Jacobo balichishca Diosca chi mushuc huasibi causachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Chasna nishahuas David chita mana shayachirachu. Randi paihua churi Salomonmi chi huasita shayachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Chasna acpis tucuimanda yali ushac Diosca runa rashca huasigunai mana causacchan. Pai rimashcata ñaupa pasachic runa caigunamanda quillcashca: ");
INSERT INTO qvzNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Dios casnami nin, jahuapachaga ñuca mandangahua tiyarina man, cai pachaga ñuca chaqui jaitarina man. Chasna nicpi ima huasitata ñucahuacta rasha ninguichi ñuca causangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Manachu ñuca maquihuan tucuita rashcani, nisha tapura Dios. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban paigunata mas cuintara casna nisha, Canguna sinzhi shunguyuc manguichi. Diospa shimita mana uyasha muducuinta, yuyai illac yanga runacuinta manguichi. Diospa Samaita mana ima uras uyanguichichu. Canguna apayayaguna rashcacuintallatami cangunahuas raunguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Paigunaga pai rimashcata pasachiccunata huanchinaurami. Jucha illac runa shamungamiraun nisha rimaucunatas huanchinaurami. Cangunami cunan cai jucha illac shamuc Jesustaga mana balichisha huanchiranguichi. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Cangunaga Dios mandashca shimigunata angelgunamanda japishallata mana pactachiranguichichu nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban chasna rimashcata uyasha paiguna shungu ucui yapa piñarisha puca tucusha huanchinata munanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Randi Estebanga Diospa Samai jundacta asha jahuama ricusha jahuapachaibi Diospa sumac chuyacta ricura. Chasnallata Diospa ali maqui partima Jesus shayauta ricura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chasna ricusha rimara, Ricuichi, jahuapacha pungu pascariuta ricunimi. Chasnallata Runa Tucuc Jesucristoga Diospa ali maqui partima shayauta ricuni. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Esteban chasna rimacpi uyasha chi amuguna rinrigunata taparisha sinzhita caparisha huin callpanaura paita japingahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Japisha llactamanda paita pagllama apanaura rumihuan tucsisha huanchingahua. Tucsiucuna paiguna jahua llachapata llatanasha Saulo nishca runa chaqui mayanbi saquinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Rumihuan tucsicpi Esteban huañuusha mañara, Mandac Jesus ñuca causaita apahuai. ");
INSERT INTO qvzNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chasna nisha cungurisha sinzhita Yaya Diosta caparira, Paiguna juchata casna mana ali rauctaga ama caudsachinguichu señor. Chasna rimasha huañura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauloga Esteban huañushcata ricusha alimi nira. Chi punzhamanda Saulo Jerusalen llactai tiyac quiriccunata ashcata turmintachingahua callarira. Chasna raupi chi quiriccuna illacta caruma miticunaura tucui provincia Judea partimas, tucui provincia Samaria partimahuas. Randi chi chunga ishcai (12) Jesus japishca runagunalla Jerusalenbi saquirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Diosta sinzhi quiric runaguna Estebanba aichata pambangahua apausha yapa llaquirisha huacasha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauloga Jesusta quirinata saquichichun nisha turmintachira. Chasna turmintachisha caran huasibi yaicusha japisha apara carcelbi tapangahua, carigunatas huarmigunatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Saulo chasna turmintachiupi quiriccuna Jerusalenmanda sáa tucusha tucui partita Jesucristo quishpichic man nishami yachachisha puriunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipega Jerusalenmanda llucshisha Samaria llactama risha Cristo quishpichic man nisha camachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chi llactai camachicpi tucui runaguna pai Diospa ushaihuan ali rashcagunata ricusha, pai rimashcatas ali yuyaihuan uyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pai ashca runaguna ucumanda supaita llucshichicpi chi supaiguna sinzhita caparisha callpanaura. Ashca janga changayuccunas suchu runagunahuas ali puric tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chasna ali tucushcagunata ricusha chi intiru llactai yapa cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ñáaupa uras chi Samaria llactai shuc Simon nishca runa tiyara, jatun bancu mara. Ñáuca sinzhi yachac mani nisha tucui chi llactagunaibi tiyac runagunata manzhachisha causac ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Amugunahuas tucui runagunahuas paita yapa manzhac anaura. Paimanda rimanaura, Diosmi jatun ushaita paita cushca nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Unaimanda chasna buruju yachaihuan umasha manzhachicpi paita yapa balichisha causac anaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Cunanga randi paiguna Felipe Diospa ali mandanamanda, chasnallata Jesucristo quishpichic ashcamanda camachishcata uyasha quirisha bautisarinaura ashca carigunas huarmigunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chasnallata chi bancu Simonbas quirisha bautisarira. Chihuasha Felipehuan puriura. Felipe Diospa ushaihuan jatun rashcagunata ricusha Simon manzharira. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chasna tucucpi Jerusalenbi tiyauc Jesus japishca runagunaga samaria runaguna Diospa shimita uyaungunami nishcata uyasha Jerusalenmanda Samaria llactama Pedrota Juandas cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paiguna risha pactasha chi samaria quiriccunamanda Diosta mañasha tapunaura Diospa Samai paiguna ucuibi yaicuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Chi llactai auc quiriccuna Jesuspa runaguna tucushcata ricuchingahua Jesuspa shutihuan bautisarishca anaura. Chasna agllaita Diospa Samai chara paigunahuacpi mana yaicushca ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chasna acpi Pedro Juandi paiguna maquita chi runagunahua umai churasha Diosta mañasha tapucpi Diospa Samai paiguna ucui yaicura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pedroguna chasna paiguna maquihuan umaibi japicpi Diospa Samai yaicucta ricusha, Simonbas chasna paiguna rashcata yapa munara. Chasna munasha cullquita ricuchisha nira, ");
INSERT INTO qvzNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ñáucama chi ushaita randichihuaichi, ñucahuas maican runahuacpis maquita churacpi Diospa Samai chi runata yaicuchun nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pai chasna nicpi Pedro nira, Dios cushca ushaita cullquihuan randichihuai nishcamanda can huañusha cambas camba cullquindi chingaringui. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Canga Diospa ushaita charinata mana ushanguichu camba causaita Diospa ñaupacpi mana alichishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Can cai mana ali rashcamanda llaquirisha juchata saqui. Chasna rasha Diosta rugai can perdunashcachari tucuchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Can mana ali yuyaihuan jundarishca autas, can juchahuan pillurishcashina autas ricunimi. Jatun Diosta sinzhita mañai, camba shungüi can chasna yuyarishcata pai perdunangachari. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pedro chasna rimacpi Simon rugara, Canguna jatun Diosta ñucamanda mañapaichi, can rimashcashina imahuas ama tucuchun ñucahuacpi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chihuasha Pedro Juanbas Diospa shimita camachisha chasnallata Jesusmanda alita rimashcahuasha Jerusalenma bulltianaura. Riusha chi provincia Samaria llactagunaibi Diospa shimita camachisha camachisha rinaura Jerusalenma pactanagama. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chihuasha Diospa angel Felipeta rimara, Jerusalenmanda Gaza nishca llactama ric ñambita ringui nisha. Chi ñambiga chaquishca pambai an nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Angel rimashcata uyasha Felipe chi partima rira. Chi ñambibi tupara Etiopia nishca llactamanda runata. Chi runaga jatun mandac amu Candace nishca huarmihuacpi tarabac mara. Tucui chi amuhua huasibi aucunata mandac mara, chasnallata paihua cullquita huacaichic runa mara. Chi runami Jerusalenma Diosta alabangahua rishcahuasha bulltiaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Bulltiausha paihua caballo aisana autui tiyarisha riusha Diospa shimita ricusha riura. Chi quillcaga Dios rimashcata ñaupa pasachic runa Isaias quillcashca mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chasna tucucpi Diospa Samai Felipeta rimara, Ri, caillayagri chi autuma. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chasna rimacta uyasha Felipe chi autuma caillayasha, Isaias quillcashcata ricucta uyasha tapura, Can ricushcata alitachu yachangui nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tapucpi chi Etiopiamanda runa nira, Pihuas yanapahuapita yachasha. Chasna rimausha Felipeta paihua autu ucuma sicachira paihuan pariu tiyarichun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Chi runa ricushca partibi casna nira: Ovejatashina huanchingahua apanaura. Huillmata pitic runa ñaupacpi oveja huahua chunlla ashcashina paihuas chunlla ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Paita mana balichisha amuguna Dios mandashcashinata mana ranaurachu. Cai pachaibi paihua causai tucurishcami. Chasna acpi paimanda miraigunamanda rimanata pita ushan. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chasna ricusha chi Etiopia runa Felipeta tapura, Rimahuai, cai quillcac runa imamandata cuintan. Pai quiquinmandachu cuintan, shuc runamandachu cuintan. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tapucpi Felipe chi quillcashca partimanda callarisha Jesucristo quishpichic man nisha alita yachachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chasna paiguna ñambita riushcai shuc yacuma pactanaura. Pactasha chi Etiopia runa nira, Caibi shuc yacu aun, manachu bautisarinata ushani tapura. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tapucpi Felipe nira, Can tucui camba yuyaihuan shunguhuanbas Jesucristota quirishaga bautisarinata ushanguimi. Chi runa nira, Jesucristoga Diospa quiquin churi acta quirinimi. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chasna nisha pai caballota shayachingahua mandara. Felipe chi runandi yacuma yaicusha chi Etiopia runata bautisara. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Chasna rashcahuasha paiguna ishcandi yacumanda sicamuushcai cungaimanda Diospa Samai Felipeta shuc partima apara. Etiopia runa Felipeta mana mas ricurachu, chasnagllaita pai riushca ñambita cushiyasha rira. ");
INSERT INTO qvzNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipega Azoto nishca llactaibi ricurira. Chibi camachisha camachisha rira Cesarea nishca llactama pactanagama. Canguna maicanbas Jesusta quirishaga quishpichishca tucunguichimi nisha camachisha riura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Chi uras Sauloga Jesusta quiriccunata piñasha huanchinata munasha israel pagrigunahua jatun amuhuagma rira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Chi amuguna mandashca quillcata tapugrira Damasco llactaibi tiyac israel tandarina huasigunaibi yaicusha quiriccunata tupashaga japishun nisha. Chibi maican runas Jesus causana tunuibi puriuta tupasha japisha, caudsayachisha carigunatas huarmigunatas, ñuca huatasha Jerusalenma apasha risha nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pai chasna rangahua riushcaibi Damasco llacta mayanbi tiyaushcai, cungaimanda paihuacpi jahuapachamanda shuc rayu dilampashcacuinta ricurishca. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Chasna ricuricpi Saulo allpama urmara. Shuc shimi paita rimaushcata uyara, Saulo imangahuacta ñucata piñangui. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Chasna nishcata uyasha Saulo tapura, Pitangui señor. Chi jahuapachamanda rimauc, Can piñaushca Jesus mani nira. Can ñucata piñausha can quiquinllata turmintaringui. Shuc huagra piñarisha paihua amu churashca caspita tacarisha paillata turmintarin. Chishinallatami ñucata piñasha canllata turmintariungui nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chita uyasha Saulo manzharisha chucchurisha nira, Imatata munangui ñuca ranata señor. Tapucpi Señor Jesus nira, Jatarisha Damasco llacta ucuma yaicugri. Can imata ranatas chibi rimangaunami nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Chi uraspi Saulohuan auc runagunaga chi rimashca shimita uyashallata, randi mana pitas ricushaga manzharisha chunlla shayarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chihuasha Saulo jatarisha ñahuita pascasha ricusha nisha paihua ñahui dsirmachishcamanda ansallas ricunata mana usharachu. Chasna tucucpi paihua cumpañaccuna maquimanda aisasha pushanaura Damasco llactama. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chasna tucushcamanda quimsa (3) punzhata mana ansallahuas ricunata usharachu. Chasnallata chi punzha imatahuas mana micurachu, mana upirachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Chi uraspi Damasco llactai Jesusta quiric runa Ananias nishca tiyaura. Muscuibicuinta ricurishcai Señor Jesus paita rimara, Ananias nisha. Nicpi uyasha Ananias tapura, Imahuata nihuangui. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesus paita rimara, Jatarisha ri Cusca nishca ñambita. Chibimi Judas nishca runahua huasibi shuc Tarso llactamanda Saulo nishca runata mascasha tupagri. Cunan ratu Yaya Dioshuan cuintaunmi. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Pai muscushcaicuinta paita ricuchirani can paihuagma shamungaraushcata. Paita ricuchirani can chima pactasha camba maquita paihua uma jahuai churacpi paihua ñahui pascaringaraushcata ricuchirani. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jesus chasna rimacpi Ananias nira, Señor Jesus cai Sauloga Jerusalenbi canda quiric runagunata yapa turmintachisha causauc ashcata ashca runaguna ñucata cuintahuanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cunanga caima randi shamushcami israel pagriguna quillcashcahuan tucui camba shutihuan mañac runagunata caudsayachisha apangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananias chasna nicpi Señor Jesus paita rimara, Rilla. Ñáuca chi Saulotaga anllasha japishcanimi ñucamanda rimac tucuchun nisha israel runagunatas, chasnallata mana-israel runagunatahuas, paiguna mandac amugunatahuas rimac tucuchun nisha cachashami. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Chasnallatami ñucata quirishcamandami pai ashcata turmintachitucungaraushcata paita ricuchingarauni. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Señor Jesus chasna nishcata uyasha Ananias rirami Saulo tiyaushca huasima. Pactasha yaicusha paihua maquita Saulo uma jahuaibi churara nisha, Huauqui Saulo, can shamushca ñambibi ricuric Señor Jesusca ñucata cachahuara camba ñahui pascasha cuti ricuchun nisha, chasnallata camba causaibi Diospa Samai jundachun nisha cachahuara. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Cungaimanda yacu aicha carashina Saulohua ñahuimanda urmara. Chasna tucucpi ña ali ricunata ushara. Chihuasha Saulo jatarisha rira bautisaringahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chihuasha micusha jursata japira. Chi Damasco llactaibi tiyac Jesusta catiu runagunahuan ashca punzhata tiyaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulo chasna quiric tucusha israel tandarina huasibi yaicusha Jesusmanda camachingahua callarira Jesusca Diospa churi man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Chasna camachishcata uyasha tucui uyaucuna manzharisha rimanaura, Manachu cai runaga Jerusalenbi Jesusta quiriccunata turmintachisha puric ara. Chasnallata manachu caimas pactamugashca quiriccunata japisha israel pagri amugunahuagma apangahua nisha cuintanacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Chasna cuintanacucpis Sauloga Diospa shimita mas ali yuyaihuan camachisha yachachira, Cai Jesusca Cristo nishca jatun mandac amu man nisha. Chasna camachicpi Damasco llactaibi causac israelguna cuintanacunaura, Caichu ali an nisha mana yachanchichu. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ashca punzha ña pasashcahuasha mana quiric israel runaguna Saulota huanchishun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Chi runaguna tutandi punzhandi llacta quinzhashca pungüibi chapaunaura Saulota japisha huanchingahua nisha. Ñáa chi israelguna chasna yuyarishcata Saulo musiara. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Musiacpi shuc tuta quiriccuna Saulota ashanga ucuibi jundachisha llacta quinzhahuashama pasachinaura, jahuamanda allpama uraicuchisha pagllama llucshichisha cachanaura. Chasna rasha chi israelgunahua maquimanda Saulota quishpichinaura llucshichisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Chasna Damasco llactamanda llucshisha risha Jerusalenma pactasha quiriccunahuan purinata munara. Randi tucui quiriccuna paita manzhanaura pai sirtu quiric ashcata mana yachasha. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabe randi Saulota amigota rasha Jesus japishca runagunahuagma pushara cuintangahua imasna Damasco ñambibi Señor Jesusta Saulo ricushcata, chasnallata imasta Jesus paita cuintara. Chasnallata Damasco llactaibi Saulo mana manzhasha Jesusmanda camachiurami nisha rimara. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bernabe chasna rimacpi quiriccuna Saulota japinaura paigunahuan pariu Jerusalenbi puringahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saulo chasna quiriccunahuan purisha Jesusmanda mana manzhasha cuintara. Chasnallata griego shimita rimac israelgunahuan cuintasha camachira. Pai camachishcamanda chiguna Saulota japisha huanchingahua nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chasna ranata yachasha quiric huauquiguna Saulota Cesarea nishca llactama pushasha rinaura chimanda quiquin Tarso nishca llactama cachangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Saulo ña quiric tucucpi tucui Judea, Galilea, Samaria provinciagunaibi Jesusta quiric muntun turmintarisha causashcamanda lugaryasha ganaslla causashcauna. Chi uras yapa mas quiric runa mirarisha tucunaura. Señor Jesus munashcallata rasha causaccuna anaura, chasnallata Diospa Samaimi paigunata sinzhiyachisha yanapaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chi uras Pedro caran partima quiric huauquigunata ricungahua rira. Chasna risha Lida nishca llactaibi tiyac quiriccunahuagmas pactara. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chi llactai shuc Eneas nishca runata tupara. Chi runaga pusac (8) huatata mana jatarinata ushasha paihua cayutuibi sirigara paihua aicha api tucushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro chi runata ricusha nira, Eneas Jesucristo canda alichinmi. Jatari, camba puñunata apai nira. Pedro rimashcallai Eneas jatarisha shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tucui Lida llactaibi Sarón nishca llactaibis tiyaucuna paita ricusha paiguna ñaupa yanga quirinata saquisha Jesusta catingahua callarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chi uras Jope nishca llactai shuc Jesusta quiric huarmi tiyara. Paihua shuti Tabita ara, chasnallata griego shimibi nin Dorcas. Chi huarmiga alita rauc huarmi ara, pugri runagunata yanapasha causac ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pedro Lida llactai tiyaushcaibi Dorcas ungusha huañura. Huañucpi paita llaquiccuna pillusha jahua pataibi churanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ñáa Lida llactaga Jope llacta mayanbi mara. Quiriccuna Pedro chi Lida llactaibi auta yachasha ishcai (2) runata cachanaura casna nisha, Jope llactama uctalla shamuchun nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Chasna rimacpi Pedro jatarisha paigunahuan pariu rira. Jope llactaibi pactacpi chi huañushca huarmita churashca patama sicachinaura. Chibi Pedro yaicucpi huaccha huarmiguna huacasha paita ricuchinaura Dorcas sirasha paigunama cushca batagunata churarinagunatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chasna ricuchishcahuasha chi cuartomanda Pedro tucuita canzhama cachara. Pailla saquirisha cungurisha Dioshuan mañasha tapura. Chihuasha chi huañushca huarmita ricusha nira, Jatari Tabita. Pai rimashcallai chi huañushca huarmi paihua ñahuita pascasha Pedrota ricusha tiyarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tiyaricpi Pedro paihua maquimanda japisha shayachira. Chihuasha quiric huauquigunata huaccha huarmigunatahuas cayasha causaricta ricuchira. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Chasna tucucpi tucui Jope llactaibi tiyaucuna chasna rashcata yachasha ashcaguna Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Chihuasha Pedro chi Jope llactaibi ashca punzhagunata saquirira, shuc aicha carata chaquichic Simon nishca runahua huasibi causasha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Chi uraspi Cesarea nishca llactaibi shuc Cornelio nishca runa tiyara. Paiga italiano nishca sundalugunata mandac mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Diosta alita uyac runa mara, chasnallata tucui paihua huasibi tiyaccunandi Diosta manzhac manaura. Pugri israelgunata yanapasha ashca cullquita cumbirac ara. Chasnallata tucui uras Dioshuan cuintasha causac mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chasna asha shuc chishi, las tres tupui, muscushcashina Diospa angelta paglla ricura. Chi angelga Cornelio tiyaushcama yaicusha cayara, Cornelio nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cayacpi Cornelio yapa manzharishcahuan angelta ricusha tapura, Imatata ningui señor. Tapucpi angel nira, Can Dioshuan cuintashcagunata uyashcamanda, can cumbirashcagunamandahuas Dios canda yuyarishcami. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cunanga Jope llactama runagunata cachai shuc Simon Pedro nishcata caima pushamunauchun. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Chi runaga aicha carata chaquichic Simon nishca runahua huasibimi pasiaun. Chi huasiga lamar yacupataibi man. Chi Pedroga can imata ranatas rimangami nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Paihuan rimauc angel rishcahuasha Cornelio tucui paita yanapac runagunamanda ishcai (2) tarabaccunatas Diosta ali uyac sundalundi cayasha caima shamuichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Caillayanaupi tucui pai ricushcatas uyashcatahuas paigunata cuintara. Chihuasha cachara Jope llactama. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Cayandi punzha paiguna riusha Jope llactama pactaushcai, chaupi punzhai Pedro chi huasi jahua patama Dioshuan cuintangahua sicara. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yapa raicachisha ima micunatas munara. Chasna munacpi shuccuna micunata yanuushcai Pedro puñusha muscushcashina ricura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Chi muscushcai jahuapacha pascarishcata ricura chasnallata shuc anchu aparina llachapatacuinta chuscundi pundamanda huatasha uraicuchiucta ricura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chi llachapa ucuibi ricurira israelguna mana micuna tucui tunu aichagunas, palugunas, pishcugunahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chasnallata chimanda shuc shimi uyarira, Jatari Pedro, japisha huanchisha micui. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Chasna nishcata uyasha Pedro nira, Mana, señor, ima uraspas chi tunu mana ali micunataga mana micucchani. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pedro chasna nicpi rimauc shimi cuti rimara, Dios nisha ima micuna ali man nicpiga ama yanga rimanguichu chiga mana ali micunachan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chi tunulla quimsa (3) cutinda ricurira. Chihuashaga chi llachapata jahuapachamallata apashca tucura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Chasna acpi Pedro chi ricurishcata mana yachasha tiyaushcai Cornelio cachashca runaguna Simonba huasita mascasha tapusha tapusha pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Huasima pactasha cayasha tapunaura, Simon Pedro caibichaun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro chara pai ricushcata yuyarisha tiyaushcai Diospa Samai paita rimara, Quimsa (3) runa canda mascaunguna nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Jatarisha caimanda uraicui. Ñáucami paigunata cambagma cachashcamanda mana manzhasha paigunahuan ringui. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Angel chasna rimacpi Pedro uraicusha Cornelio cachashca runagunata rimara, Ñáuca mani canguna mascaushca Simon Pedro. Imangahuacta shamuranguichi, imatata munanguichi nisha tapura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tapucpi chi runaguna cutipanaura, Ñáucanchita mandac Cornelio nishca cachacpimi shamuranchi nisha. Paiga ali causac, Diosta manzhac man, chasnallata tucui israelguna llaquishca runami. Diospa angel paita rimara, Pedrota camba huasima pushamungahua cachai nisha, pai canda rimashcata uyangahua. Chi angel chasna rimacpi Cornelio ñucanchita cambagma cachara canda pushangahua, chimandami shamuranchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Paiguna chasna rimacpi Pedro paigunata huasi ucuma yaicuchisha micunata carara, chillaitami puñuchira. Cayandi punzha jatarisha Pedro chi runagunahuan rira. Chasnallata maican Jope llactaibi tiyac quiric huauquigunahuas Pedrota cumpañasha paihuan rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Cayandi punzha Cesarea llactama pactanaura. Cornelioga paihua aillugunata, ali amigogunatas tandachisha paihua huasibi chapaunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro chi huasima pactagricpi Cornelio tiyaushcamanda jatarisha rira tupangahua. Tupagrisha Pedrohuacpi cungurira alabasha nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Astahuanbas Pedro Corneliota maquimanda aisasha jatarichira nisha, Jatari, ñucahuas cancuinta runallata mani nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Chihuasha Corneliohuan cuintanacusha Pedro huasi ucuma yaicusha ashca tandarishca runagunata ricura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro chi runagunata ricusha rimara, Canguna basta yachanguichimi israel yachaita shuc mana-israel llactamanda runagunahuan mana imatas ranachu, huasibihuas mana yaicunachu. Chasna agllaita Dios ñucata ricuchihuashcami ima tunu runatas yanga mana alichangui nisha mana rimanachan. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chiraicumanda can ñucata cayacpi mana quillasha, mana imatahuas nishachu shamurani. Chasna acpi canda tapuni, imangahuata cayahuarangui. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tapucpi Cornelio rimara, Quimsa (3) punzhami cai tupu urasllaita, mana micusha sasisha Diosta mañasha ñuca huasibi tiyaurani. Cungaimanda shuc sumac punzhaglla churarishca runa ñuca ñaupacpi shayarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Chi runa rimahuara, Can mañaushcagunata Dios uyashcami Cornelio. Chasnallata pugri runagunama can cullquita cumbirashcata Dios yachanmi. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cunanga Jope llactama runagunata cachai Simon Pedrota caima apamungahua. Paiga aicha carata chaquichic Simon nishca runahua huasibimi pasiaun, chi huasiga lamar yacu pataibi man nira. Chibi tiyauc Pedro shamusha canhuan cuintangami imatahuas nishami rimahuara. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chi angel rimashcata uyasha huairashina canda pushangahua cacharani. Alitami shamushcangui ñucanchihuagma. Cunanga tucuilla Diospa ñaupacpi tiyaunchi, uyanata munanchi tucui Dios canda rimashcata nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Cornelio rimashcahuasha Pedro camachingahua callarira casna nisha, Cunanga alita yachani Dios mana ñucanchi israelgunallatachu mas llaquin astahuanbas pai tucuita pariuta llaquin. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Maican llactamandahuas paita manzhac alita rac runatas sirtu llaquisha japinmi, israel runa actas, shuc runa actahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosca Jesucristomanda ganas cushi shimita israel runagunama cura. Cai Jesusca tucuigunata mandac amu man. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Canguna alita yachanguichimi imasna Juan camachisha, bautisashcahuasha, Jesus alita rangahua callarira Galilea provinciaibi, chihuasha tucui Judea provinciaibis purisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yachanguichimi imasna Diosca Nazaret Jesusma paihua Samai yuyaitas ushaitahuas cura. Chiraicu maitas Jesus purisha Dios paihuan pariu ashcamanda yapa aligunata rara, chasnallata supai yaicushca runagunamanda supaita llucshichisha cachara. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jesus Jerusalen llactaibi tucui Judea partibihuas pai ali rashcagunata ricusha ñucanchi sirtu rimaucuna manchi. Chasnallata ricushcanchi paitaga amuguna cruspi quilabasha huanchinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Chasna huanchigllaita Dios quimsa (3) punzhaibi causachirami. Causachisha ñucanchihuacpi ricuchira. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jesus mana tucui runagunahuacpichu ricurira randi ñucanchigllai ricurira. Dios ñucanchita ñaupa anllashca maranchi Jesus cuti causarishcata rimac tucungahua. Chasnallata pai causarishcahuasha paihuan pariu upiranchi micuranchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Paimi ñucanchita mandara, tucui runagunata camachichi nisha, Diosmi tucui huañushcagunata causaccunatahuas Jesusta taripac amuta churara, nisha rimaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Chasnallata tucui Dios rimashcata pasachiccunaga cai Jesusmanda camachisha rimanaushca. Maicanbas paita quiricpi Dios tucui paiguna jucha rashcagunata anchuchingami nisha camachishcauna. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro chara chasna camachiushcaibi Diospa Samai tucui uyaucunahuacpi yaicura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Cornelioguna mana yachashca shimigunata rimangahua callarinaura, chasnallata Diosta alabasha rimanaura. Chasna tucucpi Pedrohuan shamuc quiric israel runaguna chita uyasha manzharisha ninaura, Diospa Samaimi cai mana-israel runagunaibihuas yaicushcami nishami rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pedro chita uyasha paihuan shamuccunata rimara, Diospa Samaiga ñucanchishina paigunahuacpihuas yaicushcami, chasna acpi manachu ali an cai runaguna yacuhuan bautisaringahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Chasna nisha Pedro mandara Jesucristohua shutibi bautisarichi nisha. Chihuasha paiguna Pedrota tapunaura, Quimsa (3) punzhallahuas ñucanchihuan cumpañasha tiyai nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Chihuasha Jesus japishca runaguna, Judea provinciaibi quiric huauquigunandi uyanaura chi mana-israel runagunahuas cunan Diospa shimita japinaurami nisha cuintashcata. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chasna acpi Pedro Capernaun llactamanda llucshisha Jerusalenbi pactamucpi quiric israelguna paita piñasha rimanaura, ");
INSERT INTO qvzNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Imangahuata rirangui yanga runagunahuagma pasiangahua nisha. Imangahuata paigunahuan pariu micurangui nisha piñasha tapunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tapunaupi Pedro ñaupapundamanda tucuita paihuan pasashcamandapacha cuintangahua callarira, ");
INSERT INTO qvzNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ñáuca Jope llactaibi Dioshuan cuintasha tiyaushcai muscuibicuinta ricurani shuc llachapa piticuintata. Chi llachapa pitita caran pundamanda huatashcata jahuapachamanda ñuca tiyaushcai uraicumuucta ricurani. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chi llachapa piti ucui ricurani tucui cai pachai tiyac ima tunu aichagunatas piña aichagunatas, palugunatas, pishcugunatahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Chimanda shuc shimi rimashca uyarira, Pedro jatari, chi aichagunata japisha huanchisha micui nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nicpi cutiparani, Mana señor, ima uraspas chi tunu israelguna mana micuna aichagunata mana micushcanichu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ñáuca chasna nicpi Dios jahuapachamanda cuti rimahuara, imatahuas ñuca alichiranimi nicpi yanga man nisha ama yuyaichu nihuara. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ñáa quimsa (3) cutin ricuchisha rimashcahuasha tucuita jahuapachama apaitucura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Chi urasllata Cesareamanda quimsa (3) ñucahuagma cachamushca runa ñuca tiyaushca huasima pactamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chasna acpi Diospa Samai rimahuara, ama imatas manzhasha rilla paigunahuan nisha nihuara. Caibi tiyauc ñucahuan puric sucta (6) quiric huauquigunandi risha chi Cesarea runahua huasibi yaicuranchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ñáucanchi yaicugripi chi Cornelio nishca runa casna cuintara, shuc angel paihua huasibi shamusha shayauta ricurani nisha. Chasnallata chi angel rimashca, Jope llactama runagunata cachai ñucata pushangahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paiga canda camba huasibi tiyaccunandi Diospa quishpina shimita rimangami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chi runa chasna cuintashcahuasha ñuca rimangahua callarishcallai callari uras Diospa Samai ñucanchima shamushcacuintallata paigunahuacpihuas shamura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chasna tucucpi Señor Jesus causaushca uras ñucanchima rimashcata yuyarirani imasna nira, Juan runagunata yacui bautisara, cangunata randi Dios chicanda cungami. Paihua Samaita cangunata bautisashca tucunguichimi nisha Jesus ñucanchima cuintara. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Chasna acpi ñucanchi Jesusta quiricpi Dios paihua Samaita ñucanchima cura. Chasnallata Dios paigunamahuas cucpi ñucaga Diosta mana jarcanata ushanichu. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pedro chasna rimashcata uyasha Jerusalenbi tiyac quiric israelguna mana mas rimanaurachu. Astahuanbas Diosta alabasha rimanaura, Sirtumi tucui mana-israel runaguna actahuas Dios lugarta cushcami paiguna juchata rashcamanda llaquirisha saquisha huiñai causaita charinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ñáaupa uras chi Estebanda huanchishca uraspi, tucui Jesusta quiriccunata turmintachishca tucunaura. Chasna turmintarina shamucpi quiriccuna miticusha shuc llactagunama rinaura, Fenicia partima, Chipre nishca islamahuas, Antioquia nishca llactamahuas rinaura. Chita puriusha Jesus quishpichina shimita camachinaura israel runagunamalla. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Randi maican Chipre Cirene partigunamanda auc quiriccunaga Antioquia llactaibi pactasha Señor Jesucristo quishpichishcamanda camachinaura tucui runagunata, israelgunatahuas, griego shimita rimaccunatahuas camachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Paiguna Señor Jesuspa yuyaita charinaura. Chasna asha camachinaupi ashca runaguna uyasha paiguna ñaupa yanga quirinagunata saquisha Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Antioquia llactaibi chasna tucushcata uyasha Jerusalenbi tiyac quiriccuna Bernabeta Antioquia nishca llactama cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabe Antioquia llactama pactasha Dios paigunata ashcata yanapashcata ricusha yapa cushiyara. Paigunata camachisha, Jesusta sinzhita quirichi ama sambayasha catichichu nisha cushiyachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabega shuc ali shungu runa mara, Diospa Samai jundashca alita quiric ara. Pai chasna camachicpi ashca runaguna Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chihuasha Bernabe Tarso nishca llactama rira Saulota mascangahua. Paita tupasha Antioquiama pushamura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Paiguna shuc huata intiru chi Antioquia llactai causanaura. Chibi tiyac quiriccunahuan tandarisha ashca runagunata Diospa shimita yachachinaura. Ñáaupallata Antioquia llactaibi Jesucristota quiriccunata shutichishca anaura Cristianos nishca. Chita nin Cristota caticcuna. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bernabeguna Antioquia camachina uraspi maican Dios rimashcata pasachiccuna Jerusalenmanda Antioquiama shamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Shuc cuti quiriccuna tandariushcai paiguna muntunmanda shuca Agabo nishca runa Diospa Samai rimashcacuinta, huasha imasna tucungaraushcata cuintara. Pai shayarisha, Cai pachaibi ashca raicai tucungaraun rimara. Chasna chi raicai uraspi Claudio nishca romano jatun amu mandasha tiyaushcaimi tucura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pai chasna rimacpi uyasha Antioquiaibi causauc quiriccuna yanapashun nisha caran amu ushashca tuputa Judea provinciaibi tiyauc quiric huauquigunama yanapasha cachashun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Paiguna chasna yuyarishcashinami ranaura. Chi cullquita Judeaibi tiyasha quiriccunata cuirauc rucu nishcagunahua maquibi cungahua Bernabehuan Saulohuanbas cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chi uras mandac amu Herodes nishcaga quiriccunata turmintachingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Chasna rasha Juanba huauqui Santiagota cuchilluhuan picasha huanchichi nisha mandara. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chasna huanchicpi israelguna ali man nishcata uyasha amu Herodesca Pedrotas caudsayachisha japira. Chi punzha israelguna mana putasyachishca panda micuna jista punzha mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedrota caudsayachisha carcelbi tapara. Pedro ama llucshisha quishpichun nisha Herodes chunga sucta (16) sundalugunata churara carcelbi Pedrota cuirangahua. Chuscu (4) sundaluguna caran uras cuiranaura. Amuga chi pascua nishca jista pasashcahuasha Pedrota carcelmanda llucshichisha nisha yuyarira israel runaguna ñaupacpi taripanghua. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Chasna acpi Pedro tapashca tiyaura sundaluguna maquibi. Chasna agllaita tucui quiriccuna Diosta sinzhita mañaunaurami Pedromanda. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ñáa Herodes cayandi punzha llucshichingaraushca chi tuta Pedro puñuusha siriura chuscu sundaluguna, caranma ishcai ishcai (2) chaupi shungüi cadenahuan huatashca. Chasnallata chaupi sundalugunaga carcel pungüi cuiraunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pedro pai puñusha siriushcai cungaimanda Diospa angel shamura, carcelbi punzhajlla ricurira. Chi angelga Pedrohua cushtillaspi tacasha rimara, Pedro uctalla nicchari. Chi angel chasna rimashcallai cadenaguna Pedrohua maquimanda pitirisha urmanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Chihuasha angel, Jatarisha camba llachapatas zapatostas churari nira. Chasna nicpi churarira. Angel cuti rimara, Camba capata japisha jacu nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Chasna nicpi llucshisha angelta catisha rira. Riusha yuyarira, Muscuunichu u sirtuchan nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Chasna risha punguta cuirauc sundaluguna mayanda pasanaura, mas chinicshinai cuirauc sundalugunatahuas pasanaura. Chihuasha canzhama llucshina jirumanda pungüi pactanaura. Chi punguga pai munailla pascarira. Chasna tucucpi paiguna carcelmanda llucshisha llacta ucuta ric ñambita riushcai angel cungaimanda chingarira, Pedro pai sapalla saquirira. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Chasna tucucpi Pedro yuyarira, Cunan yachanimi sirtupacha jatun Yaya Dios paihua angelta cachashcami ñucata quishpichingahua Herodespa maquimanda, chasnallata israelguna paiguna munashcata ranamandahuas. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chasna tucushcata yuyarishcahuasha Pedro rira Juan Marcospa mama Mariahua huasima. Chibi ashca runaguna Diosta mañangahua tandarishca anaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro chima pactasha llactama llucshina punguta tacacpi shuc sirbic huarmihuahua Rodé nishca huasi ucumanda llucshisha rira pishan nisha yachangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Chi huarmihuahua Pedrohua shimita uyasha cushiyasha mana pascashachu huasi ucumallata callpara Pedromi pungüi shayaun nisha rimangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Chasna nicpi paita rimanaura, Nuspachangui, yanga mana rimanachu nisha. Randi Rodé yapa cutipara, Sirtutami rimani. Chasna nicpi, Mana Pedrochanga, paihua ayachari an ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Paiguna chasna rimanaupis Pedroga punguta mas tacaura. Chasna tacaupi paiguna quiquin risha punguta pascasha Pedrota ricusha manzharisha cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro huasi ucuma yaicusha maquihuan ricuchisha chunllaichi nira. Paiguna chunlla tucucpi rimara, Diospa Samaimi carcelmanda llucshichihuara nisha. Tucuita cuintashcahuasha painata nira, Caita rimagrichi Santiagota chasnallata tucui quiric huauquigunatahuas. Chihuasha pai llucshisha shuc partima rira. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Chi cayandi tutamanda Pedro illacta ricusha sundaluguna yapa manzharinaura. Paigunapura cuintanacunaura, Imata tucuraya Pedrohuan, imasata llucshisha rishca anga nisha tapunacunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodesca Pedro illashcata uyasha Pedrota mascangahua mandara randi mascashahuas mana maibis tupanata ushanaurachu. Mana tupacpi Herodes chi Pedrota cuirauc sundalugunata cayasha Pedroga imata tucura nisha piñasha tapura. Randi mana imatas cutipanaupi amu Herodes shuc sundalugunata mandara, Chi Pedrota cuirac sundalugunata huanchichichi nisha. Chihuasha mandac amu Herodes provincia Judeamanda Cesarea nishca llactama causangahua rira. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Chi uraspi Tiro Sidón nishca llactagunata amu Herodes yapa piña ara. Paigunaga Herodespa llactamanda micuna muyugunata micuccuna anaura. Chasna asha paiguna amu micuna muyuta cuti cachachun nisha, Herodes piñarishcata alichigrishunchi nisha paihuacpi risha rimanata munanaura. Tucui huin shamusha paita mas llaquishca yanapac Blasto nishca runahuan cuintanaura paiguna yuyarishcata yuyachingahua nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chasna acpi Herodes pai rimashca punzhai paiguna shamunauchun nisha cachara. Chi rimashca punzha pactaricpi Herodes jatun mandac amu churarishcata churarisha, amu tiyarinai tiyarisha paigunata camachingahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Herodes chasna camachiupi chi auc runaguna caparinaura, Caiga diosmi, mana yanga runachu nisha caparinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chi urasllaita Diospa angel amu Herodesta unguchira pai mana Diosta alabashcamanda. Chasna unguchicpi paita curu micucpi turmintarisha huañura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Chi uras Jesusta quiriccuna tucui partibi Diospa shimita rimasha purira. Chasna acpi ashca runaguna uyasha quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Chasna aushcai chi Antioquia llactai tiyac Jesusta quiriccuna tandachishca cullquita Bernabendi Saulondi, Jerusalenbi tiyac rucu quiriccunama cushcahuasha Jerusalenmanda llucshinaura. Llucshisha Juan Marcosta pushasha Antioquiama bulltiamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquia llactai quiric muntunbi maicanga Dios rimashcata pasachic runaguna, maicanga yachachiccunahuas tiyanaura. Chiguna anaura: Bernabe, negro Simeon, Cirenemanda Lucio, mandac amu Herodeshuan pariu huiñac Manaén, Saulohuas paigunahuan ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Chasna acpi shuc punzha tucui quiriccuna mana micusha sasisha Señor Jesusta alabaushcai Diospa Samai rimara, Ñáucami Bernabeta Saulondi paigunata anllarani. Cunanga lugarta cuichi paiguna shuc partibis ñucamanda cuintagrinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chasna nishcata uyasha, sasisha Diosta mañashcahuasha, paiguna maquita chi ishcai (2) runagunahua uma jahuaibi churasha paigunamanda Diosta tapunaura. Chihuasha paigunata dispirisha cachanaura Diospa shimita cuintagrichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bernabega Saulondi Diospa Samai rimashcashina rinaura Seleucia nishca llactama. Chihuasha mar yacuta barcoibi chimbasha Chipre nishca islai pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chibi pactasha Salamina nishca llactama rinaura. Chibi israelguna tandarina huasibi camachinaura Diospa shimita. Juan Marcos chasnallata cumpañasha rira paigunata yanapangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tucui Chipre islaibi purisha risha Pafos nishca llactagama pactanaura. Chibi tupanaura shuc Barjesus nishca israel runata. Paiga buruju ashallata Dios rimashcata pasachic runa mani nisha llulla ara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Chi runaga Chipre islai tiyac Sergio Pablo nishca amuhuacpi tarabac mara. Chi amuga yapa yuyaiyuc runa mara. Paiga Diospa shimita uyasha nisha Bernabeta Saulotas apangahua cachara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Chi burujuga randi, amu ama Jesucristota quirichun nisha Bernabegunata jarcasha munara. Pai buruju ashcamanda Elimas nishca ara, chiga jatun buruju bancu nishca mara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulo nishcaga griego shimibi Pablo mara. Paiga Diospa Samai jundacta asha chi burujuta ricusha rimara, ");
INSERT INTO qvzNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Supaicuinta puric mangui, tucui ali ranagunatahuas huaglichic mangui, yapa llullasha umachisiqui mangui. Ima urastas saquingui Diosta catisha nic runagunata jarcanata llulla shimi man nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Cunanga Dios canda libachingami. Camba ñahui puyuyacpi mana unaita punzhata ricungachu raungui. Chasna nishcallai cungaimanda paihua ñahui puyu tucura ansa tutacuinta. Chasna tutayacpi shuc runata mascara maquimanda aisasha rihuachun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pablo chasna rashcata ricusha Jesusmanda camachishcatas uyasha manzhasha chi amu Sergio uctalla quirira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chihuasha Pablo paita cumpañasha puriucunandi barcoibi yaicusha Pafos nishcama rinaura Perge nishca llacta Panfilia provincia partima. Chimandalla Juan Marcosca paigunata saquisha paihua huasima Jerusalenmallata bulltiara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Chimanda Pablo Bernabendi Perge llactata pasasha shuc Antioquia llactai Pisidia provinciama pactanaura. Chibi pactasha samana punzha israel tandarina huasibi yaicusha tiyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Shuc runa huañuc Moises mandashca shimigunata chasnallata Dios rimashcata pasachic runaguna quillcashcagunata ricura. Diospa shimita ricushcahuasha chi Diospa huasita cuiraccuna Pablogunama shuc shimita cachanaura nisha, Huauquiguna, canguna cai runagunata shuc ahuantachingahua yachachina shimita charishaga cunanllata rimaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Chasna nicpi Pablo jatarisha maquihuan ricuchisha chunllayachishcahuasha rimangahua callarira, Israel runagunas, Diosta manzhac runagunahuas cunan uyaichi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelguna alabashca Diosca ñucanchi huañuc apayayagunatami anllara. Paigunamanda miraccuna Egipto llactaibi aushcai Dios paigunata yapa ashcata mirachira. Chasnallata paihua sinzhi ushaihuanmi chi allpamanda paigunata llucshichira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Chuscu chunga (40) huatata chaquishca pambai purisha causanaura. Paiguna piñariugllaita Dios ahuantasha cuiraura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Chihuasha paiguna Canaan nishca pambai pactacpi chibi tiyac canzhis (7) llacta muntungunata Dios binsira. Chihuasha chi allpata ñucanchi huañuc apayayagunama cura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Chi cushca allpai Dios maican mandaccunata churara israelgunata yanapanauchun nisha. Chasna chuscu patsac pichca chunga (450) huata pasarami Dios rimashcata pasachic Samuel nishca shamunagama. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chihuasha ñucanchi apayayaguna Diosta ruganaura shuc jatun mandac amuta cui ñucanchita mandachun nisha. Chasna ruganaupi Israelba churi Benjamin muntunmanda mirac Cis nishcahua churi Saulota Dios churara israelgunata mandachun nisha. Pai mandac amu tucusha chuscu chunga (40) huatata mandasha causara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chihuashami Saulo mandac ashcamanda paita Dios llucshichira. Pai randimanda Isaíba churi Davidta anllasha churara mandac rey amu tucuchun nisha. Diosca Davidmanda rimasha casna nira: Davidga ñucashina yuyaric runa acta tupashcani. Paimi tucui ñuca munashcata rauc runa an. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Chi rey amu Davidba miraimandallatami Dios rimashcacuinta Jesusta cachara israel runagunata quishpichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Chasna acpi Jesus chara mana yachachisha puriugllaita, Bautisac Juan ñaupata israel runagunata camachiura, Canguna juchata rashcamanda llaquirisha saquisha bautisarichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Bautisac Juan ña pai huañuna punzha pactariupi chi uyauc runagunata tapura, Pi man nishata yuyarihuanguichi. Ñáucaga mana Dios cachangaraushca quishpichic runachani, astahuanbas ñucamandahuasha shuc quishpichic shamungaraun. Paihuacpi imaraicuhuas mana balicchani nisha, paihua zapatos surcungahuaca mana balicchani nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pablo mas cuintasha nira, Abrahanmanda mirai huauquigunas, Diosta manzhac runagunahuas, tucui cangunahuacpi cai Diospa quishpina shimi pactamushcami. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalenbi causaccuna paigunata mandaccunandi cai Jesus Dios cachamushca quishpichic acta mana yachanaurachu. Israelguna caran samana punzhaibi Diospa shimita uyashallata, ñaupa uras Dios rimashcata pasachiccuna Jesusmanda quillcashcagunata uyashallata, Jesusca Dios anllashca runa ashcata mana yachanaurachu. Paiguna Jesus Diospa churi acta mana yachashami Jesusta caudsayachicpi tucui imasna tucungaraun nishcata pactachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesuspacpi ima caudsas illac agllaita mandac amu Pilatota huanchingahua nisha ruganaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chasna rasha tucui Jesusmanda quillcashca shimita pactachinaura. Pactachishcahuasha paihua amigogunata Jesusta crusmanda uraicuchisha urcu juctu ucui pambanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Chasna agllaita Dios paita huañushcamanda causachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesus causarishcahuasha chi Galileamanda Jerusalenma paihuan puric runagunahuagllai ashca cutin ricurira. Cunanga paiguna tucui runagunama cuintanaura Jesus causarishcami nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ñáucanchihuas cai ali shimita cangunama cuintac shamushcanchi. Dios rangaraushcata ñucanchi huañuc apayayagunama ñaupa rimashcata ñucanchi cunan cangunama rimaunchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ñáucanchi paigunamanda miraccuna ashcaraicu Dios paigunama rimashca shimi ñucanchihuacpi cunan pactamunmi Jesusta causachisha. Pai Salmos nishca quillcai capítulo dospi rimashcacuinta casna nin: Can ñuca churi mangui. Cunan ñuca camba yaya ashcata runagunama ricuchirani. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Chasnallata Dios casna nisha quillcachira: Israel rey amu Davidma ñuca ali sumaccunata cushami nishcataga cangunamas cushcanguichimi nisha, Jesuspa aicha ama ismuchun nisha paita huañushcamanda cuti causachingaraushcata Dios charagllaita rimara. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Chimandami rey amu David chasnallata quillcara: Can anllasha cachashca runahua aicha mana ismungaraucta yachanimi, nisha quillcashca. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pablo mas camachisha rira, Alita yachanguichi David pai causashca uraspi Dios munashcata rashcahuasha huañura. Huañushcahuasha pambacpi paihua aicha ismura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Randi Jesuspa aicha mana ismurachu Dios paita causachishcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ñáucanchi rimashcata uyaichi llaquishca huauquiguna, canguna alita yachangahua. Jesusmanda camachishcata quiricpiga Yaya Dios canguna juchagunata anchuchingami. Chitami rimaunchi cangunata. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moises mandashcagunaga quishpichinata mana ushanaunzhu, randi maicanbas Jesusta quirisha quishpichishca tucungami. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Chasna tucucpi alita yuyarisha causanguichi Dios rimashcata pasachic runa rimashcacuinta ama cangunallata chasna tucungahua. Dios paigunata casna yuyachira: ");
INSERT INTO qvzNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ñáucata mana balichiccuna uyaichi, manzharisha ricusha huañuchun. Canguna causaushcai shuc jatun ranata rashami. Maicanbas chita rimacpi yangami riman nisha mana quiringuichichu. Chasna acpi huañunguichi, nisha rimara Dios. Pablo chi runagunama casna rimasha camachira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo camachishcahuasha paihuan puric runagunandi chi israelguna tandarina huasimanda llucshiupi maican runaguna, Shuc samana punzhai cuti shamunguichi cai shimita mas yachachingahua nisha ruganaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chasna tandarishcahuasha ashca runaguna, israelgunahuas, paiguna tunu causanata caticcunahuas, Jesusta quirisha Pablohuan Bernabehuan catisha rinaura. Chasna rinaupi paiguna mas camachinaura casna nisha, Dios llaquiucta yuyarisha ama sambayanguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chasna acpi shuc samana punzhaibi cadsi huin chi llactai causaccuna tandarinaura Diospa shimimanda Pablo camachishcata uyangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Chasna ashcaguna tandarishcata ricusha israel runaguna piñarinaura. Pablo Jesusmanda cuintashcaga llulla man ninaura, chasnallata Pablota jiridsata rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chasna agllaita Pablo Bernabendi mana manzhasha chi israelgunama rimanaura, Cangunama ñaupapunda yachachina maranchi. Astahuanbas canguna cai shimita mana balichisha huiñai causaita mana munaranguichichu. Canguna mana uyasha quirishcaraicu cunanga canguna mana balichishca mana-israel runagunahuagma riunchimi cuintangahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Chasnami Dios ñucanchi israel runaguna agma mandara: Tucui llactai canda shuc bilata sindichishcacuinta anllashcanimi can tucui munduibi tiyac runagunama cai Diospa quishpina shimita rimagringahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chi mana-israel runagunaga Pablo chasna rimashcata uyasha ashcata cushiyanaura, Diospa shimi yapa ali man nisha. Maicangunaga Dios huiñai causaita cungahua anllashcagunaga quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chasna tucucpi tucui chi partibi Jesus quishpichic man nisha rimashca shimi mirarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Chasna miraricpi ricusha chi mana quiric israelgunaga, chi llacta amugunatas maican balichishca huarmigunatahuas Pablota piñanauchun nisha rimanaura. Paiguna Pablota Bernabendi turmintachisha chi partimanda callpachinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chasna ranaupi Pabloguna chi llactata saquisha riusha paiguna chaquimanda pulbuta picharinaura chi llactata culpayachisha saquingahua nisha. Chasna nicpi paiguna rinaura Iconio nishca llactama. ");
INSERT INTO qvzNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Chi Antioquiaibi tiyac quiriccunaga yapa cushiyasha saquirinaura Diospa Samai jundacta asha. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo Bernabendi Iconio llactai pactasha israel tandarina huasibi yaicunaura. Chibi Diospa shimita sinzhita camachinaupi ashca israelgunas mana-israelgunahuas Jesusta quirinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Chasna tucucpi chi mana quiric israelguna rimanaura, Cai camachiccuna ñucanchita llullasha mana ali yuyaita cusha purinaun. Chasna nisha chi quiric huauquigunata yapa piñachichinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chimanda Pabloguna chi llactaibi unaita saquirinaura Señor Jesusmanda yachachingahua mana manzhasha. Dios paigunama ushaita cura pis mana rashcagunata rangahua ricuccuna Yaya Diosta manzhasha quirinauchun nisha. Chi rashcagunata canguna ricusha Dios cangunata llaquiunmi nisha ñucanchi camachishcata sirtu mashca nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Chasna acpi runaguna ishcai (2) muntun tucunaura, chaupi runaguna israelgunahuan tucunaura, chaupi runagunaga Pablogunahuan tucunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chasna tucucpi mana quiriccunaca, israelgunas mana-israelgunahuas, paigunata mandac amugunandi shucta yuyarisha mana alita rangahua rumihuan tucsishun nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablogunaga chi mana quiric israelguna yuyariushcata yachashami Liconio nishca partima miticusha rinaura, Listra nishca llactamas, Derbe nishca llactamahuas, tucui chi mayanbi ac llactagunamahuas rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chi llactagunaibi Jesusmanda camachisha purinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Chasna puriushcai chi Listra nishca llactaibi shuc suchu runa tiyaura pai pagarishcamanda mana puric. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Paiga Pablo camachishcata uyasha Jesus alichihuangami nisha quirira. Chasna acpi chi runa quirishcata yachasha Pablo paita ricusha ");
INSERT INTO qvzNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","pai caparisha rimara, Jatarisha shayari nisha. Chasna nicpi chi runa saltasha jatarira, puringahua callarira. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tucui chi runaguna Pablo rashcata ricusha paiguna quiquin Liconio shimihuan sinzhita caparinaura, Cunanga runacuinta ricuric dioscunami ñucanchihuagma jahuamanda shamunaushca nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Cai Bernabega Jupiter nishca ñucanchi dios man nisha rimanaura, chasnallata Pablo rimauc runa acpi ñucanchi Mercurio diosmi nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ñáa chiguna llactama yaicuna pungu mayanbi charinaura Jupiter nishca diosta alabana huasita. Chasna acpi Jupiterta alabac pagriguna chi runagunandi Pablogunata paiguna diostacuinta alabangahua huagragunatas gustu ricuric sisagunatahuas chima apamunaura rupachishun nisha yuyarinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Chasna apasha shamuucunata ricusha Pablo Bernabendi paigunata alabangaraucta ña yachanaura. Chasna yachasha llaquirisha paiguna quiquin camidsata líqui líqui rasha caparisha callpanaura runaguna chaupi shunguma casna nisha, ");
INSERT INTO qvzNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Liconio runaguna, imatata raunguichi, ñucanchi cangunacuintallata runa manchi, mana dioscunachanchi ninaura. Ali cushi shimitaga cangunama cuintangahua shamuranchi, canguna cai yanga dios randimanda astahuan causac Diosta quirinauchun nisha cuintangahua shamuranchi. Paimi jahuapachata, cai pachatas, lamar yacutahuas, tucui chi ucuibi tiyaccunatas rara. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ñáaupa causaccunataga paiguna quiquin munashcata rangahua lugarta cura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Chasna agllaitami ushac Dios tucui runagunama pai llaquishcata caran uras ricuchin. Tamiatas micuna muyutas alita cuun. Chasnallata micunatas cushitahuas ñucanchima ashcata cuun. Chasna nisha Pabloguna paigunata rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chasna rimashallata chi runaguna paiguna huagrata huanchisha alabangaraushcata cadsi mana jarcanata ushanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chihuashallai Antioquiamanda Iconiomandahuas mana quiric israelguna Listrama shamunaura runaguna yuyaita cambiachisha ama Pablogunata catinauchun nisha. Chasna racpi Listra runaguna Pablota rumihuan tucsinaura. Tucsishcahuasha ña huañushcami nisha paihua aichata llacta ucumanda canzhama aisasha shitanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Chasna tucushcata yachasha quiric runaguna Pablo siriushcama shamusha muyucta tandarinaupi Pablo jatarisha cutillata chi llactamallata yaicura. Cayandi punzha Bernabehuan Derbe nishca llactama rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chi Derbe llactaibihuas Jesus canguna jucha rashcagunamanda quishpichic man nisha camachicpi ashca runaguna Jesusta quirinaura. Chihuasha bulltianaura Listra, Iconio, Antioquia llactagunamallata. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tucui chi partigunaibi tiyac quiriccunata cushiyachisha ahuantanaura casna camachisha, Ama saquinguichichu canguna quirishca causanataga. Diospa ali mandanama yaicuitucungahuaca ashcata turmintarisha tucuna manchi ninaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chasnallata caran quiric muntunbi Pabloguna shuc rucugunata anllanaura quiriccunata cuiranauchun nisha, chihuasha mana micusha sasisha Diosta tapusha paiguna quiriushca Jesuspa maquibi achun nisha saquisha rinaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chimanda llucshisha Pisidia provincia nishcata pasasha Panfilia provincia nishcama pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Chasna pactasha Perge nishca llactai Jesusmanda camachishcahuasha Atalia nishca llactama pactanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chimanda barcoibi yaicusha lamar yacuta chimbanaura Antioquiama ringahua. Chi Antioquia llactamanda chara mana rigllaita Pablogunamanda Diosta tapunaura paigunata Dios llaquishcahuan pai munashcasamita ranauchun nisha, paigunahua causaita Diospa maquibi saquishca anaura. Ñáa chasna tucuita pactachishcahuasha chimallata bulltiamunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabloguna Antioquiama pactasha chibi tiyac quiriccunata tandachisha cuintanaura imasna Dios paigunata tucuibi yanapashcata. Chasna Dios yanapashcamanda chi mana-israel runagunahuas Jesusta quirishcaunami nisha cuintanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chihuasha Pablo Bernabendi chi llactaibi unaita tiyanaura Jesusta quiriccunahuan pariu. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chi uraspi provincia Judeamanda Antioquia llactama maican shamuc runaguna quiriccunata yachachinaura casna nisha, Canguna Moises yachachishcacuinta mana catishaga mana quishpishca tucunguichichu. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chasna yachachinaupi Pablo Bernabendi mana chasna rarachu nisha chi shamuccunata sinzhita rimanaura, randi alichinata mana ushanaurachu. Chasna asha Pablota Bernabetas maican quiriccunandi Jerusalenma cachashun nisha yuyarinaura. Chibi tiyac Jesus japishca chunga ishcai (12) runagunahuan, quiriccunata cuirauc rucu nishcagunahuanbas cai shimita cuintasha alichinauchun nisha yuyarisha cachanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antioquia llactai tiyac quiriccuna Pablogunata cachacpi paiguna provincia Feniciata, provincia Samariatahuas pasiasha riusha cuintanaura imasna mana-israel runagunahuas paiguna ñaupa yanga quirinata saquisha cunan causac Diosta quiriungunami nisha cuintanaura. Chasna cuintashcata uyasha tucui chi llactaibi tiyac quiriccuna yapa cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chasnallata Pabloguna Jerusalenma pactanaupi tucui quiriccuna, chi rucugunahuas, Jesus japishca runagunahuas yapa ashca cushihuan paigunata saludanaura. Chasna racpi Pabloguna cuintanaura imasna Dios ñucanchita ashcata yanapaitucushcamanda. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Chasna cuintacpi maican fariseo quiriccuna chara Moises mandashcagunata catiu ashami shayarisha rimanaura, Chi mana-israel runaguna Jesusta quirishallata Moises rimashcacuinta ullucarapundata pititucunauchun, chasnallata sirtu quishpishca tucungahua Moises mandashcagunata pactachina manaun nisha rimanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Chasna rimanaupi Jesus japishca runaguna, cuirauc rucu quiriccunandi tandarinaura cai shimimanda alichingahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Chi shimimanda ashcata cuintanacushcahuasha Pedro shayarisha rimara, Uyaichi llaquishca huauquiguna. Canguna alita yachanguichi imasna ñaupa uras Dios cai ñucanchi muntunmandallata ñucataga japihuara chi mana-israel runagunama Jesus quishpichic man nishca shimita yachachichun nisha. Paigunaga ñuca yachachishcata uyasha quirinaurami. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Paiguna mana-israel runaguna agllaita tucui shungugunata yachac Diosca paiguna ali quirishcata ricusha paihua Samaita paigunamas cura ñucanchima cushcacuintallata. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ñáucanchitahuas paigunatahuas mana chicanyachirachu randi paiguna quirishcamandami paiguna juchata anchuchira. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Chasna acpiga Dios rashcata manachu gustanguichi. Ñáucanchi huañuc apayayagunaga Moises mandashcagunata pactachinata mana ushashcaunachu, ñucanchihuas mana ushashcanchichu. Ñáucanchi mana ushashcataga shuccunataga ama mandashunchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Moises mandashcagunata pactachisha quishpinchichu. Mana. Sirtu yachanchimi ñucanchihuas paigunacuintallata Señor Jesus ñucanchita llaquishcamandami quishpichishca anchi. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pedro chasna rimaushcai chibi aucuna chunlla uyanaura. Paiguna chunlla tucunaupi Pablondi Bernabendi randi cuintanaura imasna mana-israel llactagunaibi puriusha Yaya Dios ñucanchima ushaita cura pis mana rashcagunata rangahua runaguna ricusha manzharisha Jesusta quirinauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pabloguna rimashcahuasha Santiago randi rimara, Uyaichi llaquishca huauquiguna. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pedro ña cuintashcami mana-israel runagunatahuas Yaya Dios anllashcami paita alabasha sirbingahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Chasna Dios rimashcata pasachiccuna runaguna quillcashcacuinta cunan tucunmi casna nisha: ");
INSERT INTO qvzNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Huasha bulltiamushami, rey amu Davidmanda miraigunata cuti yuyarichishami paiguna ñaupacuintallata ñucata sirbingahua. Shuc huasi urmashcata jatarichisha mushucta rashcacuinta ñuca chasnallata cai runagunata alichisha mushugyachishami. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chasna racpi tucui runaguna, mana-israelgunahuas, ñuca anllashca runaguna tucusha ñucata alabahuangaunami. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Callari uras Dios yuyarishcata rimauc runaguna tucui cai shimigunata ñaupa urasmandapacha quillcanaura tucui runaguna yachanauchun nishami Diosmi nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Santiago rimasha catira casna nisha, Chasna rimashcacuintami chi mana-israel runaguna paiguna ñaupa yanga quirishcata saquisha Diosta catiunguna. Chiraicumanda casna nini chi quiriu mana-israel runagunata ama turmintachishunchi ñucanchi mandashcagunata cadsuichi nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","Ñáaupa urasmandami caran samana punzhata tucui llactagunai israelguna yachana huasigunaibi huañuc Moises mandashca shimita ricusha camachishcauna. Chasna acpi cunan chi quiric mana-israelgunama casna nisha quillcashun: Canguna yanga dioscunama ricuchishca aichata ama micunguichichu. Chasnallata ama shuccunahuan tacaringuichichu, maspas sipisha huanchishcata chasnallata rahuaitas ama micunguichichu. Chillata quillcashun nira. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Santiago rimashcata uyasha Jesus japishca, yanapac rucugunahuas, tucui quiriccunandi arí ninaura. Cunanga ñucanchi muntunmanda runagunata anllashun Pablohuan Bernabehuan Antioquia llactama cachangahua. Chasna nisha anllanaura ishcaita (2), Barsabasta nitucushca Judasta, chasnallata Silastas. Chigunaga tucui quiric huauquigunamanda mas yali yuyaiyuc manaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Anllasha cachausha shuc cartata quillcasha cachanaura casna nisha: ");
INSERT INTO qvzNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Uyaranchi mana ñucanchi cachashca runagunaga cai muntunmanda cangunahuagma turbachisha shamushcata. Quishpishca tucungahuaca israelcuinta tucuna manguichi nishami rimashcauna chiguna. Ñáucanchiga mana ima uraspas chi tunu yachachiucunata cacharanchichu cangunahuagma. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chasna tucucpimi ñucanchi tandarisha anllashcanchi cai ishcai (2) runagunata ñucanchi llaquishca Bernabehuan Pablohuan pariu cangunahuagma cachangahua cangunata yanapanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paigunaga Señor Jesucristomanda camachiushcai huanchitucunata mana ansas manzhanaurachu. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Chasnallata Judasta Silastas cachaunchi paiguna cangunahuan pariu cuintasha cai shimita canguna alita yachanauchun nisha. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Diospa Samai ñucanchita yuyarichicpi, chasnata ranata yuyariranchi, cangunata ama yapa turmintachingahua caillata mandanchi: ");
INSERT INTO qvzNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ama micunguichichu yanga dioscunata ricuchishca aichagunata, chasnallata sipisha huanchishcatas, rahuaitahuas. Chasnallata ama shuccunahuan tacaringuichichu. Tucui caigunata pactachishaga ali causanguichimi. Cai shimigunallahuan cangunamanda dispirinchi, nisha quillcanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chasna quillcasha cachacpi chi runaguna Antioquiama risha pactasha tucui quiriccunata tandachisha chi cartata paigunama cunaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chi ahuantachina quillcashcata ricusha yapa cushiyanaura. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Chasna acpi Judaspas Silaspas, Dios rimashcata pasachiccuna asha, chi quiric huauquigunata ashcata yachachisha sinzhiyachinaura Jesusta alita catingahua. ");
INSERT INTO qvzNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Unait