﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvwNT_vpl;
CREATE TABLE qvwNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvwNT_vpl WRITE;
INSERT INTO qvwNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Salbacü Jesus Abrahampïtawan Davidpa milayninpïmi śhamun. Paypa awquilluncuna caycunam cala: ");
INSERT INTO qvwNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa chulinmi Isaac. Isaacpa chulinñatacmi Jacob. Jacobpa chulincunañatacmi Judäwan śhullcancuna. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judäpa chulincunañatacmi Tamarćhu Fareswan, Zara. Farespa chulinñatacmi Esrom. Esrompa chulinñatacmi Aram. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa chulinñatacmi Aminadab. Aminadabpa chulinñatacmi Naason. Naasonpa chulinñatacmi Salmon. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa walmin Rahabćhümi Booz chulin cala; Boozpañatacmi walmin Rutćhu Obed chulin. Obedpa chulinñatacmi Isaí. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaïpa chulinñatacmi Israelpa puydï mandänin David. Mandacü Davidpa chulinñatacmi Salomon. Paypa mamanmi cañä Uriaspa walmin. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa chulinñatacmi Roboam. Roboampa chulinñatacmi Abias. Abiaspa chulinñatacmi Asa. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asap chulinñatacmi Josafat. Josafatpa chulinñatacmi Joram. Jorampa chulinñatacmi Uzias. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa chulinñatacmi Jotam. Jotampa chulinñatacmi Acaz. Acazpa chulinñatacmi Ezequias. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa chulinñatacmi Manases. Manasespa chulinñatacmi Amon. Amonpa chulinñatacmi Josias. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa chulincunañatacmi Jeconiaswan lluy śhullcancuna. Chayćhümi Israel caśhtacunäta Babilonia malca prïsucta puśhaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chayćhüñam Jeconiaspa chulin Salatiel cala. Salatielpa chulinñatacmi Zorobabel. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa chulinñatacmi Abiud. Abiudpa chulinñatacmi Eliaquim. Eliaquimpa chulinñatacmi Azor. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa chulinñatacmi Sadoc. Sadocpa chulinñatacmi Aquim. Aquimpa chulinñatacmi Eliud. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa chulinñatacmi Eleazar. Eleazarpa chulinñatacmi Matan. Matanpa chulinñatacmi Jacob. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa chulinñatacmi José, Mariap wayapan. Mariap wawinñatacmi Caćhaśhan Salbacüca nipäcuśhan Jesus. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chayurá Abrahampïta aśhta mandacü Davidcamam pasala ćhunca tawayu awquillucuna. Chaynütacmi mandacü Davidpïta aśhta Israelta Babilonia apacuśhancama ćhunca tawayu awquilluncunatac pasala. Chaynütacmi chay apaśhancäpi aśhta Caćhaśhan Salbacü Jesus näsinancamapis ćhunca tawayu awquillucunatac pasala. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Caćhaśha Salbacü Jesuspa näsishan caynümi cala: Mariam limaśha cala Joséwan cuscapäcunanpä. Manaläpis cuscayaptinmi Chuya Ispiritup munayninwan Maria patayüña licalila. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jinaptinmi José alli nuna cayninwan, Mariacta mana pin'ayman juluyta munal “Mana tantiachillal caćhaycüśhä” nil pinsayäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chaynüta pinsaśhtin chay tuta puñuyaptinmi Diospa caćhan anjilnin suyñuyninćhu licalilcamul nila: “Davidpa caśhtan José, limay-masiqui Mariawan cuscayta ama ishcayyaychu. Pay'a Chuya Ispiritup munayninwanmi patayu licalïsha cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Chay ishyacuśhan walaśhcätá ‘Jesusta’ śhutichanqui, nunacunäta juchanpi julüca captinmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lluy caycuna pasala Diospa unay willacünin nishannümi: ");
INSERT INTO qvwNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Manalä wayapacta lisï wamla patayu licalilculmi walaśhta ishyacun'a. Paytam ‘Emanuel’ nipäcun'a”. Cay ninan “Dios ya'anchicwanmi cayan” ninanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ñä chay puñuśhancäpi José lichcälulmi Diospa anjilnin nishannuy Mariacta walminpä puśhacula. ");
INSERT INTO qvwNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Caynu puśhaculpis manam cuscachu puñula, aśhta ishyacunancama. Ishyacüluptinñatacmi “Jesuswan” śhutichäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Chay timpu Judeap Belen malcanta Herodes gubirnayaptinmi Jesus näsimula. Chaymi chay Jerusalen malcaman śhapämula sïlućhu uyllurcunäta lical tantiä nunacuna, inti yalamunan-lädu calu malcäpi. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ćhaycälimulmi tapula: “¿Mayćhümi cacullan Israel malcap mandänin näsï iñachaca? Juc lusirum camalaycachimun cay-lädućhu näsishanta. Chayta licälälimulmi śhapämulá un'ulacuycul alawapäcunäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chay nïta uyalïlulmi Herodes jucmanyacüśha śhun'unpis timpucuyaptin mana limaliyta nïtac imanayta atipalachu. Jinaptinmi Jerusalenćhu llapan nunacunaca jucmanyacüśha cacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Caynu cayalmi Herodes chay üralla puydï sasirdüticunätawan camachicuyta yaćhachicünincunacta ayalcachil tapula: “Salbacüca ¿mayćhütan näsinan cañä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Niptinmi: “ ‘Judeap Belen malcanćhümi’ niyan. Chaynümi Diospa unay willacüninpa isquirbishanćhu nin: ");
INSERT INTO qvwNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Am Belen malca, masqui Judäpa malcancunapi mas tacsalla cayaptiquipis, Israelpa puydï mandacünin ampïtam yalamun'a’ nilmi niyan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chay niyta uyalilculmi Herodes pacallap ayachimula chay uyllurwan tantiäcunäta imay chay lusiruca licalimuśhantapis tuquicta yaćhalpunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Willaycuptinñatacmi Herodes Belen malcäman caćhala: “Canan ashipämuy chay walaśhchäta mayćhu caśhantapis, willaycälimaptiqui ya'apis alawä linäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Chaynu nilcuptinmi liculcäla. Chay licapäcuśhan lusirümi lila paycunap ñawpäninta aśhta chay iñachaca caśhancäcama. Chay caśhancäpa altunćhu śhaycüta licälälilmi alli-allicta cushicälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chay wasiman yaycunanpämi chayćhu cayäñä walaśhchaca maman Mariawan. Chayćhümi iñachap puntanman un'ulacaycälil alawapäcula. Jinalculmi babulchancunaćhu apapäcuśhan sumä ćhaniyu üructa, insinsiucta mirra nishanta upäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaypïta Dios suyñuyninćhu “Yan'al-lätac Herodesninpa cutiyalcanquiman” niptinmi juc caminupña malcanta cuticulcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chaynu cuticulcaptinmi Josëta suyñuyninćhu Diospa caćha anjilnin nila: “Herodesmi walaśhchäta wañuchinanpä ashichinan cayan. Chayurá canallan śhalcuculcul mamantinta Egiptoman ayichiy. Chayćhümi willanaccama camunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chaymi chay tuta üra, José śhalcuculcul walaśhchätawan mamantinta puśhaculcul Egipto malcäta liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chayćhümi yaćhapäcula Herodes wañunancama. Lluy caycuna caynu lulacacüla Diospa unay willacünin “Egipto malcapïtam chulïta ayacamú” nil nishancänümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chay uyllurwan tantiäcunaca upanta lulaśhanta Herodes tantiacülulmi alli-allicta rabyala. Chaymi ishcay wataña tantiäcunäman lusiruca licalïmuśha captin, Belenćhüpis muyülïninćhüpis ishcay watapi ulayman walaśhcunäta lluy wañuchinanpä caćhala. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lluy caycunam pasala Diospa unay willacünin Jeremias nishannuy: ");
INSERT INTO qvwNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama malcaćhümi wa'acuyta, awćhuyta uyalí. Chayćhu llapa wawincuna manaña captinmi Raquel mamay-taytayta awćhucuñä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Chay Egipto malcaćhu José yaćhayällaptinlämi Herodes wañucula. Jinaptinmi Josëta suyñuyninćhu Diospa caćha anjilnin nila: ");
INSERT INTO qvwNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Canan śhalcul, walaśhchäta, mamantawan puśhaculcul Israel malcayquita cutiy. Chay wañuchiyta munäcunaca ñam wañucunña” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chay niycullaptinmi walaśhcäta mamantinta puśhaculcul cuticamula Israel malcanman. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chay Judea malca Herodespa chulin Arquelaop maquinćhu caśhanta yaćhälulmi José manchacula chayman ćhayta. Jinaptinmi suyñuyninćhu willaptin Galileap malcancunaman licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chayman ćhälulmi Nazaret malcaman pasacula chayćhu yaćhananpä. Caycuna lulacacüla Diospa unay willacünincuna Jesusta “Nazaret malcayu nuna nipäcun'am” nil nishancänümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chay timpum Judeap chunyäninman Bawtisä Juan ćhämula caynüta willacuśhtin: ");
INSERT INTO qvwNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Diosninchicpa gubirnunćhu canapä timpu jananchicćhüñamari cayan. ¡Chayurá juchayquipi wanaculcul payman cutipämuy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Paypïmi Diospa unay willacünin Isaias isquirbishanćhu niyan: “Chunyäninćhu ayaycaćhäcäta uyalipäcuy: ‘Taytanchic ćhämunanpä sumäta allichaculcay. Ñatac paypa pulinanta tuquicta lulapäcuy’ ” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Chay Bawtisä Juan'a camïllu uywap millwanpïta luläśha müdanawanmi müdacula; utapi luläśha waćhacuwanmi ćhulaculapis. Langusta culucunallacta urunwaycunap mishquincunallactam miculapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Chay caśhancämanmi achca nunacuna limaśhanta uyalï śhapämula intirupïta: Jerusalenpïta, jinantin Judeap malcancunapïtapis, aśhta Jordan mayup lädunćhu lluy malcacunapïtapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chayćhu juchancunacta lluy willapacücunätam chay Jordan mayućhu bawtisala. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Chayman achca fariseo caśhtacuna, saduseo caśhtacuna bawtisachicü śhapämuptinmi Juan nila: “¡Pasaypi culibray caśhtacuna! ¿pitá nishulanqui ‘¡Diospa castigun janayquićhüñam cayan ayicunayquipä!’ nil? ");
INSERT INTO qvwNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Juchayquicunapi wanaculcäśhayquitari camalachipäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘Abrahampa ayllun caynïwanmi Diosninchicpa allinña cá’ ¿niyanquichun, imam? Dios munal'a cay lumicunapïtapis Abrampa ayllunman muyuchinmanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Canan'a jaćhacunäta sapipi cuchunanpá paypa ächan listuñam cayan. Mana alli wayuyniyu jaćhactamari wicapalcachil cañan'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ya'a rasunpa juchayqui wanacücunätam yacullawan bawtisapäcuc. Ipäta śhamücämi ichá ya'apïta mas munayniyu captin nï śhucuyninta apaycunalläpäpis cächu. Paymari Chuya Ispirituwanpis ninawanpis bawtisapäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ñatac trïgucta waywachï nunanümari pay'a śhayämun, lluy nunacunäta cäraycunanpämi. Waywalcachilmi trïgucta pilwanman ćhulaycun'a; amuntañatacmi wiñay simpri nina waläcäman jitaycun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ñatac Jesusmi Galileapïta śhamula Juan bawtisaśhan Jordan mayüćhu bawtisachicunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Chayćhümi Juan mana munalachu “¿Imanuypatan bawtisacman aśhwanpa amlä bawtisamänayqui cayaptin?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Niptinmi Jesus: “Cananpá chaynu caycunan. Dios mandamäśhanchicta lulaycunanchicmi cayan” nin. Niptinmi Juan bawtisala. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chay yacupi Jesus yalayämuśhanćhümi, janay pachaca quićhacacüluptin, Diospa Chuya Ispiritun juc palumanu janäninman lataycayämüta licälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chaypïtam Tayta Dios nilpamula: “Pay cuyay chulïpïta ¡maynu cushisham cayá!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaypïtam Chuya Ispiritu chunyäninman Jesusta puśhala, chayćhu Satanaśh mana allinman palpuyta ñacachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chayćhu Jesus tawa ćhunca muyun, tawa ćhunca tuta ayunayaptinmi micanäcuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaynu cayaptinmi Satanaśh Jesusta nila: “Diospa Chulin rasunpa cayal'a, cay lumicunäta tantaman muyuchiy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Niptinmi: “Isquirbisham cayan: ‘Manam tantallawanchu nunaca cawsanchic. Aśhwan Diospa lluy nimäśhanchiccämi cawsachimanchic’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jinaptinmi Satanaśhca puśhala Jerusalenćhu Diospa chuya wasinpa chupquinman. Chayman ćhaycachilmi nila: ");
INSERT INTO qvwNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Diospa Chulin cayal'a, má, caypïta palpuy luliman. ¿Manachun Diospa isquirbishanćhu: ‘Diosmi anjilnincunacta anman caćhamun'a. Jinaptinmi maquinwan chalapäcuśhunqui, chay lumicunäman nï ćhaquiquipis jaluycunanpä’ nil niyan-ari?” ");
INSERT INTO qvwNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chaynu niptinmi: “Chaynütacmi Diospa isquirbishanćhüpis niyan: ‘Tayta Diosniquita munayniquiman'a ama jicutaychu’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaypïtam Satanaśh jatun ulup uma chupquinman puśhalcul jinantin malcacunäta lluy cänintinta licachila. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jinalculmi nila: “Lluy cay licaśhayquitam uycülucman, puntäman un'ulacuycul alawamaptiqui'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Niptinmi: “¡Wayra licuy Satanaśh! Diospa isquirbishanćhümi niyan: ‘Tayta Diosllayquita alaway; payllactatac sirbiy’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niycüluptinmi Satanaśhca caćhaycüla. Jinaptinmi Diospa anjilnincuna Jesusta yanapä śhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ñatac “Bawtisä Juantam carsilcäman wićhälälin” nïta Jesus uyalïlulmi Galilea-läduman cutila. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Chaymi Nazaretman ćhaycul ućhap manyan Capernaum malcaćhu yaćhamü licula. Chay cala Zabulonpa Neftalïpa caśhtancunap culindanćhümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Cay lulacäla Diospa willacünin Isaias unay isquirbishannümi: ");
INSERT INTO qvwNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Zabulon caśhtap, Neftalí caśhtap malcancunaćhu yaćhäcuna, ućhap manyanćhu yaćhäcuna, Jordan mayup wic-lädu chimpa patanćhu yaćhäcuna, cay Galilea yanawyayä tutapäćhu Diosta mana lisïcunämi, sumä acchïta licälälin. Cay wañuycäpa jananćhüña yaćhäcunämanmi cawsayca ćhämun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chayman ćhäśhanpïtam Jesus willacula: “Juchayquipi wanaculcay. Diospa gubirnun janayquićhüñamari cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chay Galilea ućhap manyanpa liyalmi Jesus licälun wawi-caśha Simon Pedroctawan Andresta, challwa chalä-cama capäcul chalacunwan challwacta chalayalcäta. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chayćhümi nila: “Acuchun ya'awan lishun. Cananpïtá yaćhachishayqui cay challwa juntupäcuśhayquinu nunacunäta Diospä juntupämunayquipämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nilcuptin-pachallam challwa chalacuncunactapis caćhaycul Jesuswan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chaypi liyalcalmi juc barcućhu Zebedeoctapis chulin Jacoboctawan Juantapis barcunćhu challwa chalacunta allichayalcäta licälul ayälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chaynu ayäluptin-pachamari barcuntapis, taytantapis caćhaycul Jesuswan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesusmi jinantin Galileap malcancunaćhu pulila, juntunaculcänan wasicunaćhu yaćhachishtin, Diospa gubirnunpa allin willacuyninta willacuśhtin, llapa ishyäcunactapis lluy sänachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Caynu lluy lulaśhancunämi intiru Siriap calu malcancunamanpis miläla. Chaymi imaymana ishyaywan ishyä nunacunactapis, Satanaśhpa gänaśha nunacunactapis, wañupaywan cäcunactapis, latacunactapis apapämuptin Jesus lluyta sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymi jinantin Galilea malcacunäpi, Decapolis malcacunapïpis, Jerusalen malcapïpis, Judeap malcancunapïpis, aśhta Jordan mayup wic-lädu chimpanćhu cä malcacunapïpis achca nunacuna Jesusman śhapämul aticulcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus caynu achca nunacuna atishanta licalmi uluncascaman ishpila. Chayćhu täcuyaptinmi llapa yaćhapacünincuna aśhuycälila muyülïninman. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chayćhümi yaćhachiyta allaycula cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushiculcächun śhun'unćhu waccha cäcunaca. Paycunapämi Diospa lluy cänin unanchäśha cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Cushiculcächun wa'acücunaca. Diosmi paycunacta cunsuylan'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Cushiculcächun allin śhun'uyücuna. Jinantin pachätam ćhasquiycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Cushiculcächun mayanpis micanäśhanu yacunäśhanu Diospa munaśhanta lulay munäcuna. Paycunactam Dios maćhaycachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Cushiculcächun nuna-masinta llaquipaycücunaca. Paycunactam Dios llaquipaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Cushiculcächun chuya śhun'uyücunaca. Paycunam quiquin Dioswan tincun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Cushiculcächun jawca cawsayta talichïcunaca. Paycuná ‘Diospa chulin’ nipäcuśham can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Cushiculcächun allincäta lulaśhan-laycu ñacäcunaca. Paycunapämi Diospa gubirnun. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Cushiculcay ya'a-laycu palapäcuśhuptiqui, aticaćhapäcuśhuptiqui, imaymana artiwan ruydupapäcuśhuptiquipis. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chaynütacmi unaypis Diospa unay willacünincunacta lulapäcula. Chayurá allicta cushiculcay. Paycunanüpis amcuna janay pachäćhu sumä jatun primiuctam ćhasquipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ñatac caćhinuymi capäcunqui cay pachäćhu. Chay caćhica amyäśha cayal'a, ¿imanuypatá caśhan allin caćhiman muyunman? Caynu amyälul'a manañamá imapäpis bälinñachu. Jinaptinmi waśhaman wicapäluptin, jalutacüśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ñatac amcuna capäcunqui juc acchinümi cay pachäpä. Má, nimay, ulup jananćhu cä malca ¿imanuypatan pacäśha canman? ");
INSERT INTO qvwNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ñatac manamá juc acchicta walaycachinchic mancawan pacaycunapächu. Aśhwanpa altu ćhulacunmanmi ćhulcunchic lluyta acchimunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chaynütac-ari amcunapis acchinuy capäcuy nunacunäpä, cay allin lulayniquita lical janay pachäćhu Diosninchicta altuman julapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama nipämaychu ‘Pay'a Moisespa camachicuynintawan Diospa unay willacünincuna nishanta chincächïćha śhamula’ nil. Chaypächu manam śhamulá, aśhwanpa chaycunacta lluy ishpilpachinäpämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rasunpa, sïluca allpaca caśhancamá, camachicuycäpi manam juc litrallapis, nï uchuc unanchaycuśhallapis chincachishachu can'a aśhta lluyta lulaycunäcama. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mayanpis cay camachicuyta mana cäsucuycul juccunätapis mana cäsucuyta yaćhachïcätá, Diospa gubirnunćhümi mana cäpa licaśha can'a. Ñatac mayanpis cäsucul, juccunactapis yaćhachïcunätam ichá Diospa gubirnunćhu altuman juluycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Rasunpa, chay fariseocunäpïtawan, camachicuyta yaćhachicücunäpïta, mas allinninpälämi Tayta Dios licaycuśhunayqui cayan. Chaynu mana cayal'a paypa gubirnunman manam imaypis yaycapäcunquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Uyalipäculanquim unay awilunchiccunacta ‘Amam nunacta wañuchinquichu; pipis wañuchïcá cäraycuśham can'a’ nishanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ya'añatacmi ichá niycälic, pipis nuna-masinpä piñacücäpis, cäraycuśhatacmá can'a. Mayanpis nuna-masinta ‘mana bälï’ nïcätapis Cunsïjup Awturidänincunam cäraycun'a. Ñatac nuna-masinta paläcätapis wiñay simpri nina waläcämi alcayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Chayurá Diospa ima unayquitapis apayäśhayquićhu nuna-masiquita jucnüpa licaśhayquita yalpälul'a, masqui quiquin uycunayquićhülä cayalpis, ");
INSERT INTO qvwNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","chayllaćhu caćhaycul pampachaśhunayquipä mañacü cutiy. Jinalcul-lämi cutimunqui Diosman uycunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Chayurá ćhïnishüniquiwanpis pampachachicuy manaläpis mismishancama masqui fisman liyalcalpis. Chayman ćhächishuptiquim ichá fisca wardiacunap maquinman ćhulaycul carsilman jitaycachishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rasunpa chaypi manamá imaypis yalamunquichu mänu cayniquita limpiu pägamunayquicama. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Uyalipäculanquitacmi ‘Amam mansibaculcanquichu’ nishanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ya'añatacmi ichá niycälic, mayanpis walmicta licälul ‘Wicwan puñuycüman’ nishallanwanpis ñam śhun'unćhu mansibacülunña. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chayurá allï ñawiqui juchaman jitaycuy munaśhuptiqui'a, jululcul wicapäluy. Mas allinmi canman churchu cawsaypis, nina waläcäman jinantin cuirpuyquita jitaycuśhunayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ñatac allï maquiqui juchaman jitaycuy munaśhuptiqui'a, cuchulcul wicapäluy. Mas allinmi canman cutu maqui cawsaypis, nina waläcäman jinantin cuirpuyquita jitaycachicuśhayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Chaynütacmi uyalipäculanqui: ‘Mayanpis walminpi laquicuyta munäca, laquicuchun papilta lulanacuycul camachicuy mañaśhanmannuy’ nishanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ya'añatacmi ichá niycälic, walmin mana mansibacuyaptin yan'alpi laquicücá, jinaśhanwan mansibädumanñam walminta muyüchin. Chaynütacmi chay walmiwan cuscäcäpis mansibädumanña muyun. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","36","“Chaynütacmi uyalipäculanqui awilunchiccunacta: ‘Diosninchicpa śhutinta tistigupä śhaycaycachil limalicuśhallanchictam lulananchic prisïsan’ nishanta. ¿Icha juccunacta ćhulaycul Diospa śhutinta manachun tistigupä ćhulayanqui, imatá? Janay pachäta śhaycaycachilpis manamá ayinquichu Tayta Dios chayćhu cayaptin'a. Cay pachällacta śhaycaycachiptiquipis cayćhüpis Dios ćhaquinta ćhulaycunanmi. Jerusalenllacta ćhulaycuptiquipis chaypis malcantacmá. Masqui quiquiquip umallayquita tistigupänu śhaycaycachiptiquipis ima munayniyümi canqui imallactapis tacyalpachinayquipä; manamá ächallayquita yuläman nï yanaman muyuchinallayquipäpis munayniqui canchu. Tayta Diosllamari imactapis atipäcá. Chayurá ima nicuptiquipis Tayta Diosmi tistigu cayan. Chayurá manam imallactapis limalicuyniquićhu tistigupä śhaycaycachiyta ashinquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aśhwanpa juc pasä limälla capäcunquiman ‘aw’ ütac ‘manam’ nillal. Limalicuyniquiman masta yapacuycá achatupïmi śhamun. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Amcuna unay uyalipäculanquim: ‘Imactapis lulamäśhanman tincüta cutiycachisha cachun: ñawipis licalcuśhanmannuy, quilupis quichquilcuśhanmannuy’ nïta. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ya'añatacmi ichá niycälic: mana allinta lulaśhüniquicunacta ama cutichicuychu. Aśhwanpa cäraćhu lapyaśhuptiqui, juc-lädu cärayquitapis camaycuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mayanpis quijalcul camisayquitapis waycayta munaśhuptiqui'a, uycüluy punchuyquitapis apacunanpälä. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mayanpis juc kilumitrucama, alafirsa carganta apachipäcuśhuptiqui'a, apapuy ishcay kilumitrucamalä. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mayanpis pishipacü ‘uycamay’ nishuptiqui'a uycuytac. Mayanpis mañaculcäśhuptiqui'a amatac mićha caychu. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Unay uyalipäculanquitacmi: ‘Nuna-masiquita cuyacuywan licaycuy. Ćhïnishüniquitañatac ćhïniy’ nishanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ya'añatacmi ichá niycälic: Cuyapäcuy ćhïnishüniquicunäta. Amcunapi mana allin limäcunäpäpis ‘Allinca anwan caycuchun’ niycäliy. Ćhïnicüniquicunapäpis allinta lulaycälipuy. Tumpäniquicunapäpis wañuchishunayquipä aticaćhäniquicunapäpis mañaculcay-ari. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chayta lulalmi janay pacha Diospa chulincuna caśhayquita camalächipäcunqui. Paymi intïta tamyäta allin mana allin nunapäpis uycamanchic. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sïchuśh sintinaculcäśhallayquiwan cuyanaculcaptiqui'a ¿ima allintatan lulaycuyanqui? Piyurnin jucha-sapacunäpis lulawshï-masincunacta cuyanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Apanaculcäśhallayquiwan limaycanacul ‘mas allinninlämi cayá’ ¿niyanquichun imatá? Chaynüllá lulapäcunmi Diosta mana lisïcunäpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tayta Diosniqui tucuy śhun'unwan cuyaycuśhannuy amcunapis caycäliy. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ama allin lulaycunacta lulayalcaychu nunacunaca lical alawaśhunallayquipä. Chaynüta lulaptiqui'a altu sïlućhu cä Diosninchic manam primiucta uśhunquiñachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Chaymi pishipacücunäta imallacta uyculpis ama llamadayänayquichu chay ishcay cära nunacunänu juntunaculcänan wasicunaćhüpis, läsacunaćhüpis lluypa ñawquin allinpa licachicuyllawan lulaśhancänu'a. Rasunpa, chay lulaśhanwan'a lluy alawaycuśha cananta ćhasquiycunñamari. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amcunaćhüñatacmi ichá, Tayta Diosllap ñawquillan yanapaycunayqui; ichü maquiqui uycuśhantapis allï maquillayquipis manam yaćhananchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chay pacaläśhacta licä Tayta Diosmi lluypa ñawquin allinpa licaycuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ñatac Dioswan amam aläjapa limanquichu chay ishcay cära nunacunänu'a. Maynümi nunacunäwan allinpa licachicuyninwan juntunaculcänan wasicunaćhüpis läsacunaćhüpis śhaycapacuycul mañacuypi wañupaculcan. Rasunpa, chay lulaśhanwan'a lluy alawaycuśha cananta ćhasquiycunñam. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amcunaćhüñatacmi ichá, mañacul'a wasiquita wićhacalcamul śhun'uyquićhu lluy pacaläśhancunäta lisï Taytallayquita mañacunqui. Chay pacaläśhancäta licä Tayta Diosmi lluypa ñawquin allinpa licaycuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ñatac Diosta mañacul'a ama limaychu yan'al cutipalcul cutipalcul limaśhallayquitá, Diosta mana lisï nunacunanu'a. Chaycuna chaynu mañaculcan ‘Achcacta limaptí Dios uyaliman'am’ nïcänuymi. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amam paycunanu'a lulapäcunquichu. Manaläpis mañacuptiquim Dios'a yaćhanña ima pishipaculcäśhayquitapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Chayurá mañaculcanquiman caynümi: Janay pachäćhu cä Tayta Diosnillá, amllamá altuman juluśha canqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gubirnuyqui śhaycamuchun. Janay pachäćhu lulaśhayquinu, cay pachäćhüpis munayniqui lulaśha cachun. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Canan muyunpä micuyta uycälillämay. Ama-ari pishiycachillämaychu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mana allin lulamänïcunäta pampachäśhämannu juchäcunacta pampachaycälillämay. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mana allin lulaycunaman palpapäcunäpä ama-ari caćhaycälillämaychu. Aśhwanpa chaypi licaycälillämay. ˻Ñatac jinantin pachäpis maquillayquićhümi cayan. Amllam cayanqui sumä munayniyücäpis. Amllatacmi wiñay simpripä altuman juluycuśhapis cayanqui. Chaynu callächun˼ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Chayurá mana allin lulaśhüniquicunacta pampachaycäliptiquim janay pachäćhu cä Taytayqui Diospis pampachaycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mana pampachapäcuptiquim ichá mana pampachapäcuśhunquitacchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ñatac ayunal ama lawtïtuculcaychu chay ishcay cära nunacunänu'a. Paycuna micuypi wañüśhanuy taplaycaćhapäcun nunacunawan licachiculcänallanpämi. Rasunpa allinpa licaycuśha canallantá ćhasquiycälinñam. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amcunaćhüñatacmi ichá umayquicunacta ñächapacalcäliy cärayquicunactapis pa'apacalcäliy ");
INSERT INTO qvwNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ayunaśhayquita nunacunäman mana tantiachipäcunayquipä. Chaymi ima pacaläśhantapis licä Taytayqui lluypa ñawquin allinpa licaycuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Amatacmi lägaculcanquichu cay pachäćhu cäcunallactá. Chaycunacta puyucunallam ismuycunallam camacan. Suwacunallam yaycul suwapäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aśhwanpari janay pachäpä lägaculcay. Chayćhu'a manam imaypis puyun'achu, nï ismun'achu, nï suwapis yaycun'achu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mayćhümi cäniqui cayan, chayćhümá pinsayniquipis muspayniquipis cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Juc acchi-yupaymi ñawinchic imactapis licachimanchic, tantiachimanchic. Ñawiyu cayal'a, rasunpa allincäta tantiapäcunquimanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mana ñawiyu cayalćha ichá, mana tantiapäcunquimanchu tutapäćhu cayä-yupaypis. Chaynu tutapäćhu cayal'a ¡maynu maynu yanawyayä tutapäñaćhari cayan! ");
INSERT INTO qvwNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Manam mayanpis ishcay patruntá sirbinmanchu. Juccätam ćhïninman, juccätam cuyanman; juccätam jamuyanman, juccätam wätanman. Chaynütacmi amcunapis nï Diostawan cäniquita jucllaćhu sirbinquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Chayurá niycälic: Ama ‘¿Imactalä micuśhä, imactalä upyaśhä, imawanlä müdacuśhä?’ nil llaquicuyalcaychu. Bïdayquim mas bälin cay micuycäpïtá; aychayquim mas bälin cay müdanapïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Má, pinsaycäliy imaymana pishucunäman. Paycunap manam talpuynin nï cusichan nï pilwan nï imanpis canchu. Jinaptinpis janay pachaćhu cä Taytanchicmi paycunactá micachin. ¿Manachun mas ćhaniyu cay pishucunapïta capäcunqui imatá? ");
INSERT INTO qvwNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Maynu wañupacuyalpis ¿mayantá juc üra masllactapis cawsayninta aśhuycachinman? ");
INSERT INTO qvwNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Müdanayquicunapïtapis ¿imapïtan llaquicuyalcanqui? Má, licapäcuy imaymana waytacunäta. Manam puchcacunchu nï awacunchu. Ñatac Diosninchicmi tuqui-tuquicta waytachin. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Rasunpa, unay puydï mandacü Salomonpis manam mayannin waytanüpis llipyayä müdanawan calachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Waytacunacá wala śhalun chaquillam, ñatac chaynütapis Diosninchicmi tuquicta müdachin. ¿Chaychun ampá amcunacta mana müdachipäcuśhunquimanchu, mana chalapacuyniyu nunacuna? ");
INSERT INTO qvwNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Chayurá ama ‘¿Imactalä micuśhä, imactalä upyaśhä, imawanlä müdacuśhä?’ nil llaquicuyalcaychu. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diosman mana chalapacücunallam chaynu wañupaculcan. Amcunapñatacmi ichá janay pachäćhu cä Tayta Diosniqui ima pishipacuśhayquitapis yaćhayanña. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aśhwanpa wañupaculcay paypa gubirnullanćhu canayquipä, jinaman munayninćhu cawsapäcunayquipäpis. Jinaptiqui'a lluy pishipaculcäśhayquitapis uycälishunquim. ");
INSERT INTO qvwNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chayurá amatac ‘¿Wälaman imalä ćhäman'a?’ nil llaquicuyalcaychu. Chay wala muyuncuna quiquillanmá imanuy canantapis licacuycun'a. Chayćhu imaymana sasachacuyniyü-cama ćhämumaptinchicmi licaycunapä can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ama nuna-masiquicunacta cäraycäliychu Dios mana cäraycälishunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nuna-masiquicunacta cäraycälishayquimannümi cäraycuśhunqui. Chayman tincütatacmi licaycälishunquipis. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“¿Imanuypatan nuna-masiquip ñawinćhu uchuy anlallanta licaypi wañupacuyalcanquiman ñawiquićhu jatun iluyqui cayaptin? ");
INSERT INTO qvwNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Imanuypatan ‘Jay, ñawiquićhu anlayquita juluśhayqui’ niyanquiman jatun iluyqui ñawiquićhu chacalayaptin? ");
INSERT INTO qvwNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ishcay cära nunacuna! Ñawiquipïtalä chay iluyquita juluy. Chaynalculćha ichá juccäpa anlanta julunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ñatac Diospa ima lluy ćhaniyünincunacta ama alaycäliychu allucunäman cuchicunäman. Chay allucunämi quiquiquiman ticlälälimunman. Cuchicunäñatacmi mana ćhaniyütanu jalutaculcanman. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ñatac Diosta mañacuy; uśhunquim. Payta ashipäcuy; talinquim. Puirtacta tucaycuy; quićhaycun'am. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pipis mañacücá ćhasquinmi; ashïcá talinmi; puirtacta tucaycücätá quićhanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Mayanniquitan chuliquicuna tantacta mañacuśhuptiqui lumicta uycälälinquiman? ");
INSERT INTO qvwNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Challwacta mañacuśhuptiquipis, culibrayta uycälälinquiman? ");
INSERT INTO qvwNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","¡Maynu juyu cayalpis chuliquicunacta allincäta uyalcaptiquichun ampá janay pachaćhu cä Taytayqui, allincäta mana uycälishunquimanchu! ");
INSERT INTO qvwNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Chaynütac-ari nuna-masiquicuna allinpa licapäcuśhunayquita munaśhayquinu paycunactapis tuquip licaycäliy. Cay nishäcá Moisespa camachicuyninwan Diospa willacünincuna isquirbishanpapis tullunmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Cay cawsayninchicćhu jatun jawca linä caminupmi alli-alli nuna liyalcan. Puncunpa yaycuyculñatacmi ichá ñacayćhu camacaycäman ćhaycälin. Aśhwanpa quićhqui puncupari yaycaycapäcuy. Chay allin cawsaycäman ćhaycachï caminuca sasa quićhqui captinmi ashlla talipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Chayurá cuydaculcay Diospa willacünintucul ćhämücunapïta. Shimillan'a tuqui jawca uwishpa-yupaymi. Śhun'unñatacmi ichá atü-yupay. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Chay wayuyninpa lisishanchicnümi lisiycälinqui. ¿Imaytá caśhacunapi übacta pallachwan? ¿Ütac ćhïćhicunapi ïgusta pallachwan? ");
INSERT INTO qvwNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Allin lantacunaca allincätam wayun. Mana bälï lantacunacá mana allintatacmi wayun. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Allin lantacá manam mana allincunactá wayunmanchu. Nïtacmi mana allin lantäpis allincunactá wayunmantacchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mana allin wayuyniyücunätam cuchulcul cañanchic. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chayurá lantacunätanuymi wayuyninpa lisipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manamá Diospa gubirnunman ćhaycamun'achu ‘Duyñullämi, Taytallämi am canqui’ nïcunallá, aśhwanpa janay pachäćhu cä Taytäpa munayninta luläcunämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ñatac chay cäraycunan muyuncäćhu achcam nipäman'a: ‘Duyñulláy, Taytalláy, ¿manachun ampïta willaculcälá? ¿Manachun pudirniquiwan Satanaśhpa maquinpïta caćhaycachipäculá? ¿Manachun imaymana milagrucunactapis lulapäculá ampa śhutiquićhu?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nipämaptinpis: ‘¡Manam lisicchu. Ñawïpïpis chincapäcuy, mana allin cawsayniyücuna!’ nilmi nishä. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Cay yaćhachishäta uyalicul cäsucücunämi juc allin pinsayniyu nuna a'ap jananćhu wasinta śhalcachïcänuy cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chaymi lücu tamya paćhyamuptinpis, yacu pallalcuptinpis, alli-alli waywa talcamuptinpis, mana ćhaćhachilachu a'ap jananćhu masïsu taycachisha captin. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ñatac cay yaćhachishäta uyalicul mana cäsucücunämi ichá luclu nuna a'up janallanćhu wasinta śhalcachïcänuy cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chaymi tamyamuptin, yacuca pallalcuptin, waywaca talcamuptin lluy lluy maśhtacacülun” nin. Cay nilmi Jesus camacälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jinaptinmi uyalï llapan nunacunaca sumä licapayllaman camälälil nipäcula: ");
INSERT INTO qvwNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Sumä pudirwanmá pay yaćhachin; manam camachicuycäta yaćhachicücunanüllachu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chay ulupi Jesus ji'alpayämuptinmi achca-achca nunacuna atipämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chayćhümi lipra ishyaywan nuna aśhuycamul Jesuspa ñawpäninman un'ulacuycul nila: “Taytáy, munal'a allinyaycachillämanquimanmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Niptinmi maquinwan yataycul nila: “Aw, allin chuya canayquitam muná” nil. Chay nilcul yataycuptin-pachallam lipra ishyaynin lluy śhuśhüluptin sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chayćhümi Jesus nila: “Amam cay allinyachishacpi pictapis willapacunquichu. Aśhwanpa sasirdütiman lil, anradisicuypi apay Moises nimäśhanchicnuy, rasunpa cay ishyaypi allinyäśhayquita licaśhunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Chaypïtam Jesus Capernaum malcäman ćhäluptin Roma cachacucunap capitannin aśhuycamul ruygacula: ");
INSERT INTO qvwNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Taytay, sirbï walaśhllämi wasïćhu ćhänacacüśha alli-alli nanayta apayällan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Niptinmi: “Lishun-ari sänachipunacpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitancäñatacmi: “Taytay, wasïman yaycaycamunallayquipäpis manamá bälillächu. Aśhwanpa cayllapi niycullaśhayquiwan sänachinayquita yaćhayämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ya'apis yaćhämi cäsucuytapis mandacuytapis. Chaynütacmi maquïćhu cä cachacucunäpis ‘wicta liy’, ‘cayman śhamuy’ niptí cäsuman. Chaynütacmi uywaynïcunapis ‘cayta lulay’ niptí lulapäcun” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chayta Jesus uyalilmi admiracüśha atïnincunacta nila: “¡Rasunpa, cay jinantin Israel malca-masïcunaćhüpis caynu chalapacuyniyütá manam talïchu! ");
INSERT INTO qvwNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rasunpa achca mana-Israel nunacunam intirupïta śhapämun'a, Diospa gubirnunćhu Abrahamwan, Isaacwan, Jacobwan cumbidunćhu caycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Chayćhu capäcunanpä unanchaycuśhancunañatacmi ichá tutapäcäman wicapäśha capäcul apalcaćhapäcun'a, quiluntapis lawćhićhicyachipäcun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nilculmi chay capitancäta: “Chalapacuśhayquinu-ari lulaśha cachun; wasiquita cuticuyña” nila. Ñatac chay ürallam sirbïnin walaśhca sänäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chaypi Pedrop wasinman Jesus linanpämi Pedrop suyran sumä calur ishyaywan jitalayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chayćhu ishyäcäpa maquinta yataycuptinmi calur ishyaynin chincacula. Jinaptinmi chay üralla walmica śhalcuculcul paycunacta atindiycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ñä tutacalpuyaptinmi Satanaśhpa gänaśha achca nunacunacta Jesusman ćhächipämuptin chaypa maquinpi juc limayllawan caćhaycachila. Chayćhümi llapa ishyäcunactapis sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lluy caycunacta lulala Diospa unay willacünin Isaias isquirbishanca lulaśha cananpä: “Quiquinmi mana callpayu cayninchictapis julaycamälanchic. Ishyayninchictapis apaculam” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ñatac achca nunacuna cunćhalayaptinmi Jesus yaćhapacünincunacta: “Acuchun cay ućhap chimpanman” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chay niyällaptinmi camachicuyta yaćhachicü ćhaycamul: “Yaćhachicü taytay, mayta liptiquipis atishayquim” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Niptinmi Jesus: “Atücunäpäpis maćhaynin canmi. Pishucunäpapis ishnan cantacmi. Rasun Nunap Chulincäpañatacmi ichá mana mayman umalläta ćhulaycunalläpäpis canchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ñatac chayćhümi jucnin yaćhapacünin: “Taytáy, papänïmi maquïćhülä cayan. Pampälulñaćh ichá aticman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Niptinmi: “Jina wañuśhacunaca wañünincunacta pampaculcächun. Am'a atimay jinalla” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chaypïtam Jesus yaćhapacünincunawan barcuman ishpicalcälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chayćhu liyalcaptinmi nisyu-nisyu bintu talcämul yacüta altuman ulunpalcachil ulunpalcachil barcuman winacacacuyan. Chay pasaśhan üra Jesus'a puñuyälam. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chaymi yaćhapacünincuna lichcachicuyalcan: “¡Taytay salbaycälillämay! ¡Wañuypa patanćhüñamari cacuyanchic!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Niptinmi: “Mana chalapacuyniyücuna, ¿imapïtan chucchucuyalcanqui?” nila. Chaypi śhalcalcamulmi “¡Waywa, yacu, śhaycuyña!” nillaptin tuqui-tuqui śhaycülun. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chayta licalmi yaćhapacünincuna sumä licapayllaman camäśha: “¿Ima nunatan pay, waywäpis yacüpis cäsunanpä?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chaypi ućhap chimpanćhu Gadara-läduman ćhäläliptinmi, Satanaśhpa maquinćhu ishcay lücu nuna pantiuncäpi śhacayämuñä. Chay sumä-sumä atipacacayämuptinmi chayninpa nï jucpis pasalachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chaycunam apalcaćhaypa: “Diospa Chulin Jesus, ¡¿imactatá ya'acunawan munacuyanqui?! ¿Manaläpis üra ćhayämuptinchun śhamulanqui ya'acunacta mućhuchipämänayquipä?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wicniscaćhüñatacmi achca-achca cuchicuna lancalayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñatac achatucunaca Jesusta nila: “Aluyämalñá, wic cuchicunäman liculcänapäri awniycälillämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chayćhu Jesus: “Liculcayñari” nillaptinmi chay nunäta caćhaycul cuchicunäman yaycälälila. Caynu lluy pudiracuycuptinmi llapan cuchicunaca ućhap patanman cürritityalcul lluy ji'acalpälil anuälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chaynu pasäluptinmi chay cuchi michïcunaca mana-mana malcanta pasaculcan. Ćhayculñatacmi willapacucuyalcan chay lücu nunacunäwan ima pasaśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chaymi lluy paćhcälälimun Jesus caśhancäman. Ćhaycälimulmi: “Ama chaynu caychu. Juc-lädu malcaman licullay” nil nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Niptinmi Jesus barcuman ishpilcul wic-lädu chimpa yaćhaśhan malcanman licun. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chayman ćhäläliptinmi ćhänacacüśha nunacta chacanawan wantupämuñä. Paycunap chalapacuyninta Jesus tantialmi chay ishyä nunäta: “Callpanchacuy, walaśhní, juchayqui lluy pampachäśhañam” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niycüluptinmi camachicuyta waquin yaćhachicücunaca śhun'unćhu: “¡Cay nunalla cayal caynu pampachätucuśhanwan'a Diosta jalutacuyanmá!” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Chaynu pinsalcäśhanta Jesus yaćhalñatacmi nila: “¿Imapïtamá caynu mana allincällacta pinsapäcunqui? ");
INSERT INTO qvwNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Imaniytan mas fäsil: ‘Juchayquicunacta pampachaycucñam’ nïchun icha ‘Śhalcuculcul licuyña’ nïchun? ");
INSERT INTO qvwNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cananmi yaćhanqui cay Rasun Nunap Chulinca, cay pachäćhu juchacunacta pampachänäpä munayniyu caśhäta” nil. Nilculmi chay ishyä nunäta: “Canan ¡śhalcuy-ari! ¡Wantumuśhuśhayquita apaculcul wasiquita licuy!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nilcullaptinmi rasunpa śhalcuculcul wasinta licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chaynu jatun munayninta camalaycachishanta licalmi chayćhu cä nunacunaca sumä licapayllaman camäśha Tayta Diosta altuman julaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaypi Jesus pasaśhanćhümi licälun Mateo śhutiyu nuna Roma gubirnupä alcabälacta mañananćhu täcuyäta. Chaymi Jesus: “Acuchun ya'awan, atimay” nin. Niptin-pacham śhalcuculcul paywan licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chay Mateop wasinćhu Jesus yaćhapacünincunawan micuyalcaptinñatacmi alcabäla mañäcücunäwan, mana allin cawsayniyu nunacunäpis ćhaycamul paycunawan taycacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta licalmi fariseocunaca Jesuspa yaćhapacünincunacta: “¡¿Ima-nilä nunatan yaćhachicüniqui wic-nilä nunacunawanlä micunanpä?!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nipäcuśhanta Jesus uyalïlulmi nila: “Sänu nunacunacá manam jampicüta munanchu, sinu'a ishyäcunallam. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ñatac sumäta tantiaycäliy cay nishanta: ‘Śhun'üta suwaycamänayquipä uycamäśhayquinu'a, cuyacuyniyu capäcunayquitam muná’ nil. Ya'a manam śhamulá santutucücunacta ayächu, sinu'a jucha-sapacunaca wanaculcänanpämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chayćhümi Bawtisä Juanpa puliwshïnincuna Jesusman aśhuycälimul tapupäcula: “¿Imanaltan Bawtisä Juanpa puliwshï-masincunapis, fariseop atïnincunapis rätu-rätu ayunalcan, ampa atïniquicuná mana imactapis uculcanchu isisí?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nipäcuptinmi nin: “¿Casaracüca cayaptin'a ayachishacunaca ayunapäcunmanchun ampá? Manaćhá jinapäcunmanchu paycunawanlä cayaptin'a. Ñatac chay casaracüca waycaśha canan timpu ćhämun'am. Jinaptinmi ichá micuytapis caćhaycapäcun'a. Chaynümari yaćhapacünïcunawanpis can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Má, chay custumriquicunapïtá, mayanpis mawca müdanaman manamá muśhü lataśhta la'anmanchu. Jinaptin'a chay muśhü lataśhcäćha aśhwanpa shipulcachil masta laćhyächinman. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chaynütacmi chayllalä luläśha aswactapis nï winanchicchu lälaśha mawca wacuyman'a. Chaynu lulal'a aswäćha wacuycäta paquïchinman; jinaptinćha lluy aswapis wacuypis yan'al pampapä canman. Chaymi chayllalä luläśha aswactá muśhü allin wacuyman winanchic pulanpis tuqui caycälinanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chaynu limayällaptinmi juntunaculcänan wasip puydïnin ćhaycamul Jesuspa ñawpäninman un'ulacuycul nila: “¡Taytay, wamlallämi chayllalä wañucun! ¡Acuchun-ari, yataycullaptiquićh śhalcämun'a!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chaymi Jesus yaćhapacünincunawan wañüśhäman pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Chaynu liyalcaptinmi ćhunca ishcayniyu wata yawarpa janallanćhu cä walmi, “Müdanallanta yataycullalpis sänäśhämi” nil Jesuspa ipanpa aśhuycul yataycula müdananpa manyanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesusñatacmi muyulcul walmïta licälul: “Callpanchacuy wamlallá; chalapacamäśhayquipam sänälunqui” nin. Chay nilcuśhan-pachallapïtam yawarnin lluy śhaycämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaypi chay juntunaculcänan wasip puydïninpa wasinman ćhäpäcunanpämi cayalcäñä wañü taquicta quïna tucäcunäpis. Nunacunapis wasi junta wa'ayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chaymi Jesus nila: “Waśhaman yalupäcuy. Wamlaca puñuyan jinallam; manam wañüśhachu” nil. Niptinmi nunacunaca “¿Ima?” nil asipälälinlä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Paycunacta alalcamulmi wamla chutaläśhancäman Jesus yaycuycul maquinta chalaycuptin, śhalcämun. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chay lulaśhancäpïmi intiru-intiru malcacunaćhu limay muyucula. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chaypi Jesus pasayaptinmi ishcay aplacuna ayaycaćhaśhtin aticuyalcäla: “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacü, Taytalláy! ¡Llaquipaycälillämay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ñatac Jesus juc wasiman yaycüluptinmi aplacunaca aśhuycälila. Chayćhümi Jesus tapula: “¿Rasunpa chalapacamanquichun ya'a sänachinacpä?” nil. Niptinmi: “Aw, taytay lulälunquimanmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nipäcuptinmi ñawincunacta yataycul: “Chalapacuśhayquimannuy lulacäśha cachun” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Niycullaptinmi ñawincuna lluy quićhacacülun. Jesusñatacmi ćhuncay-ćhuncayta: “Amam pictapis willapacunquichu cay licachishacpi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Niyaptinpis yalülul-pachallam jinantin malcacunäćhu Jesus ñawinta licachishanpi lluy willapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chay aplacunaca liculcaptin-pachallam ćhächimun supaypa upächisha pasaypi mana limäta. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Chay supaypa maquinpi upäta Jesus caćhaycächiptinmi, tuquiman limämula. Chaymi llapa nunacunaca licapayllaman camaśha-cama: “¡Caynu lulätá, manam imaypis licalanchicchu cay jinantin Israel malcanchicćhu!” ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Chayćhu fariseocunäñatacmi ichá: “¡Caytá achatucunap quiquin puydïninpa munayninwanmá aluyan!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chaypïtam Jesus intiru jatun malcacunäćhu tacsa malcacunap juntunaculcänan wasicunaćhüpis Diospa allin gubirnunpïta yaćhachishtin pulila, imaymana nanaycunawan ishyäcunätapis sänaycachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ñatac chayćhu achca nunacunäta licalmi sumä llaquipaycula pintïsha uwishnüpis mana michïniyü-yupay cayalcaptin. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaymi yaćhapacünincunacta: “Cusichananchic alli-allimari cacuyan; apaycücunäñatacmi ichá ashlla. ");
INSERT INTO qvwNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chaymi Duyñunta mañaculcänayqui cusichäcunacta caćhaycamunanpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaypïtam Jesus ćhunca ishcayniyu yaćhapacünincunacta ayalcul nila: “Quiquïpa munaynïtam upäcuśhayqui nunacunäta supaypa maquinpi julaycälinayquipä, imawan ishyäcunätapis nanaynincunactapis lluy sänachipäcunayquipäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chay ćhunca ishcaynin puydï caćhaśhancuna caycunam: “Pedro” nishan Simon, paypa śhullcan Andres, Zebedeop chulincuna Jacobowan Juan. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jinaman Felipe, Bartolomé, Tomas, alcabäla mañä Mateo, Alfeop chulin Jacobo, Tadeop lisishan Lebeo, ");
INSERT INTO qvwNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","malcanpi śhalcü Simon, ñatac Jesusta wañuchipäcunanpä chalaycachï Judas Iscariotipis. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Lluy paycunactam Jesus caćhala: “Amam yaycapäcunquichu Samariaćhu malcacunäman nïtac mana-Israelcunämanpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sinu'a uwish-yupaypis pintïsha cä Israelcunällaman lipäculmi ");
INSERT INTO qvwNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‘Diosninchicpa gubirnunćhu canapä timpu jananchicćhüñam cayan’ nipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ñatac lluy ishyäcunactapis, liprayücunactapis sänaycachipäcunquim. Wañüśhacunactapis śhalcachipäcunquim. Achatucunap maquincunapïtapis caćhaycachipäcunquim. Cay munaynïta dinbaldilla ćhasquiycuyal'a dinbaldillatacmi sänaycachinquipis. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lipäcul amatacmi apapäcunquichu illaytapis, üructapis, ");
INSERT INTO qvwNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","luncuyquitapis nï cambiacunayquipä müdanactapis nï śhucuyllayquitapis, nïtac garutillayquitapis. Lulapacücá lulaśhanpi ćhasquiycunanmari. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ñatac may malcamanpis ćhal, allin nunactam ashipäcunqui juc malcaman pasapäcunayquicama jamachipäcuśhunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Paycunap wasinman yaycul'a ‘Diosninchic jawcallacta caycachishunqui’ nipäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chay wasiyu allinpa ćhasquiycuśhuptiqui'a chaynu lulacachun. Mana ćhasquiycuśhuptiqui'a ama lulacachunchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ñatac pï nunapis, may malcapis mana ćhasquil nï licaytapis munapäcuśhuptiqui'a aśhta ćhaquiquicunaćhu pulbu la'aśhuśhallayquitapis lluy tapsilcul pasaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rasunpa, chaynu nunacuná, malcacuná cäraycunan muyuncäćhümi Sodoma, Gomorra malcacunapïtapis mas mastalä mućhuycachisha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Má, amcunacta caćhayalcac atücunap ćhawpinman uwishta-yupaymi. Chayurá culibraynüpis sumä-sumä fisyu-sapa caycäliy. Paluma-yupayñatac mansulla capäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Chaymi nunacunäpi sumäta cuydaculcänayqui. Malcap puydïninpa maquincunaman ćhulapäcuśhuptiquim juntunaculcänan wasicunäćhu lawćhaycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ya'a-laycum malcacunap mas puydïninmanlä ćhächipäcuśhunqui, chayćhu puydïcunätawan mana-Israelcunätapis ya'api willaycälinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jinapäcuśhuptiquipis ama llaquiculcaychu ‘canan ¿imactatan limalishä?’ nil. Chay üram Dios umacta uśhunqui, imacta ninayquipäpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chayćhu amcunachu manam limanqui, sinu'a Tayta Diosniquip Ispiritunmi amcunapi liman'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ñatac wawi-caśhacunam wañuyman ćhulaycanacun'a. Taytacunapis chulincunactam. Chulicunapis taytancunap cuntran ticlaculculmi wañuchipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya'a-laycutacmi lluy ćhïnipäcuśhunqui. Ñatac camacaycäcama tacyaycücämi salbacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ñatac juc malcaćhu wañuchipäcuśhunayquipä aticaćhapäcuśhuptiqui'a, juc malcaman ayiculcay. Rasunpa, Nunap Chulinca cutimuśhä Israelpa malcancunaman manaläpis ćhayalcaptiquim. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ñatac pï yaćhapacüpis yaćhachïninpïta masnin'a manam canchu, nïtac mayan uywaypis patrunninpïta masnin'a canchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yaćhapacücätapis yaćhachicünintanümi alcayan. Uywaycätapis patrunnintanümi alcayantac. Ñatac ya'a puydïcätalä ‘achatucunap puydïnin Beelzebú’ niyämaptin'a ¿imactañaćh lulaycälishunqui llapa caśhtäcunallactá? ");
INSERT INTO qvwNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Chayurá ama paycunactapis manchaculcaychu. Ima pacaläcäpis camalaycun'am. Pacaśhacunaca lluymi licaycachisha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chayurá cay pacallap nishäcäta lluyćhu camalaycachiy. Ñatac linlillayquićhu niycälishäcäta wasi jananpi ayaycaćhäcänuy llapa nunacunäman willaycäliy. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama-ari aychallayquita wañuchïcäta manchaculcaychu. Aśhwanpa nina waläcäman cuirpuy-alma lluy jitaycunanpä munayniyu Tayta Diostari manchaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“¿Manachun ishcay pishucunacta ashllay ćhaniyüllawan lantichwan? Chaynu cayaptinpis Tayta Dios munaptinlämi jucllayllapis anćhanpayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Chaymi aśhta ächayquipis yaćhaśha cayan ayca caśhanpis. ¿Chaychun amcunacta un'älälishunquiman, imamá? Chayurá manam imapi manchaculcänayqui canchu. Pishucunapïtapis mas ćhaniyülämá cayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ñatac mayanpis: ‘Pay caśhtam cá’ nil nunacunäćhu nimäcätá, ya'apis janay pacha Taytäpa ñawpäninćhümi ‘Ya'a caśhtam pay'a’ nishätac. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ñatac ‘Manam lisïchu’ nimäcätam ichá, ya'apis Taytäpa ñawpäninćhu ‘Paytá manam lisïchu’ nishätac. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Amatac ‘jawca cawsaytaćh uycamäśhun’ niyalcämaychu; aśhwanpam iwinacuyta apayämú. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chulin taytanpa cuntran cananpämari śhalcachishä, wamla wawintapis mamanpa cuntran, llumchuynintañatac suyranpa cuntran. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chayurá cuntrayquicuna ayllullayquicunalämi can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ñatac ya'api masta mamanta taytanta cuyäcá manam nuná cananpä mirisinchu. Chaynütacmi chulincunacta ya'apïta masta cuyäcäpis manam nuná cananpä mirisinchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jinamanñatacmi ima-ayca pasaptinpis wañuycäcama laśhćhüman mana jalumücá nï nuná cananpä mirisinchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ñatac cawsayninta ama-pacha nïcá cawsaynintamari apacun'a. Ya'a-laycu bïdantapis uycücämi ichá cawsaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ñatac caćhacuśhäta ćhasquïcá quiquïtam ćhasquiyäman; ya'acta ćhasquiycamäcäñatacmi ichá caćhamäní Taytätapis ćhasquiyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Chayurá willacüninta Diospi śhamuśhan-laycu ćhasquiycücätam Tayta Dios allinpa ćhasquiycun'a. Chaynütacmi nunacta allin caśhan-laycu ćhasquiycücätapis Tayta Dios allin nunätanüpis ćhasquiycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chaynütacmi mayanpis ima-nilä atïlläta masqui täsa alalä yacullacta uycücätapis Tayta Dios allincätalä uycun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chaynu Jesus ćhunca ishcayniyu yaćhapacünincunacta imacta lulapäcunanpäpis lluy limapaycäliptinmi, chay malcacunäman willacü liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ñatac Bawtisä Juan carsilćhu cayalmi Jesus lluy lulaśhancunacta yaćhälul ishcay puliwshïnincunacta payman caćhala. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ćhälulmi tapupäcula: “¿Amchun cayanqui rasunpa Dios Caćhamuśhan nishanca ichá juctalächun alcapäcuśhä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusñatacmi: “Canan Juanman cutiycul willaycäliy cay uyalipäcuśhayquitawan, licapäcuśhayquita: ");
INSERT INTO qvwNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","aplacunapis licaśhanta, latacunapis pulishanta, liprayücunapis tuqui sänaśhanta, upäśha linliyücunapapis quićhacacuśhanta, wañuśhacunapis śhalcamuśhanta, wacchacunämanpis allin willacuy ćhäśhantalä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jinaman'a niycäliy: ‘Ya'apïta mana ishcayyäcá cushisha caycuchun’ ” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Paycuna cuticuptinñam Jesus tapula chayćhu cä nunacunäta Juanpïta: “¿Ima-nilä nunacta licätan chay chunyäninman lipäculanqui? ¿Śhu'uśhta waywa apaycaćhäta licächun ichá imam? ");
INSERT INTO qvwNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Icha juc rïcu nunacta ćhaquinpi umancama chipyayä müdacuśhacta licächun? Chaynu nunacuná puydï mandacücunap wasinćhümá cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chayurá ¿ima licätan amcuna lipäculanqui? ¿Icha Diospa willacünin nunacta licächun? Rasunpa chaynu nunactamá licapäculanqui. Ñatac lluypïpis pay'a sumäninlämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Diospa isquirbishanmannuy Salbacücäpa puntanta Juan śhamuśhanpïmi niyan: ‘Ampa ñawpäniquitam juc willacünïta caćhamüśhä, ćhänayquipä alistamunanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Rasunpa cay Bawtisä Juanpïta mas lisimäcá manamá canchu jinantin pachäćhu. Chaynu captinpis Diospa gubirnunćhu'a ashllacta lisimäcäpis Juanpïta maslämi lisiman'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ñatac Juan willacuyta allaycuśhanpi caycamallam Diospa gubirnunpa cuntran śhalcacalcälil pasaypi lijïru nunacuna mana caśhanman cutichiyta jicutayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Licay, Diospa llapa unay willacünincunapis ñatac camachicuycunapis Diospa Caćhamuśhan Salbacüca śhamunantam willaculcäla Juan licalimunancama. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Amcunap tantiayniqui captin'a, paymi ‘Elias śhamun'am’ nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Linliyu cal'a, uyaliculcay-ari. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Imanuytá amcuna cayalcanqui? Achca walaśh wamlachacuna läsaćhu ayaycaćhaypa awsäcänümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Chaymi casamintu fistacta awsal quïnanta parti tucalcaptinpis, manatac parti'a tuśhüshipäcunchu. Chaynütac wañupacuy awsayta awsayalcal wa'ay wa'ay taquicta taquiyalcaptinpis manatac wa'awshipäcunchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chaynümi Juan śhamul aybistá micuyta caćhaycul mana uchuclla upyacuptinpis, ‘Satanaśhpa nunan’ nil nipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ñatac ya'a Rasun Nunap Chulinca micuptïmi, upyaptïmi ichá, ‘micuypä camäśha, upyaypä camäśha, jucha-sapa nunacunap, alcabäla mañäcunap cunchawänin’ nil jamuyapämanqui. Ñatac Diospa yaćhaynin rasun caśhanta wayuyninpam nunacunaca tantiapäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ñatac milagrucuna lulaśhanta maynüpaña licayalcalpis mana wanaculcä malcacta yalpälulmi Jesus nila: ");
INSERT INTO qvwNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Imanuylä capäcunqui Corazin malca! ¡Imanuylä capäcunqui Betsaida malca! Amcunaćhu milagru lulaśhäta Tirowan Sidon licapäcunman cala. Chayürallaćh juchanpi wanaculcal sumä pin'acuywan llaquicuywan Diospa ñawpäninćhu uyshuläpacunman cala. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chayurá rasunpa cäraycunan muyuncäćhu'a Tirowan Sidon amcunapïta mïnus mućhuycachishalämi capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ñatac amcunapis Capernaum malca ‘Altuman juluśhaćh capäcuśhä’ ¿niyalcanquićh? Aśhwanpa allpäpa lulïninmanlämi wicapäśha capäcunquipis. Cay milagru amcunaćhu lulaśhäcunäta Sodoma malca licapäcul'a, cay muyuncäcamaćh cayalcanman cala. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chaymi cäraycunan muyuncäćhu Sodoma malcapïpis mas mastalä mućhuycachisha capäcunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chaypïtam nilatac: “Alawaycucmi Janay pachäćhu cay pachäćhu cä Tayta Diosní, lluy yaćhayniyu, umayu nunacunäpi caycuna pacaycuśhayquitam tantiaycachinqui mana cäpa licaśha nunacunäman. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aw, Taytay, caynu canantam munalanqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chaypïtam nila: “Taytämi ya'ap maquïman cay lluy munaytapis yaćhaytapis ćhulamula. Taytallämá yaćhan paypi śhamüśha caśhäta. Chaynütacmi ya'alla yaćhá pay mayan caśhantapis. Chaymi mayantapis lisiycachishäcälla Taytäta lisipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chayurá ya'aman śhapämuy pishipäśha, llaquisha, llasä ipiwan ñitichicuśhanuy cäcuna. Śhamücunätá ya'ami yanapal, jawca jamayćhu jamachishayqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Yügüman yaycapämuy llampu śhun'u allin śhun'u caśhäta lisipämänayquipä. Chayćha jawca cawsayta taliycälinqui. Ñatac cay uśhá yügüman matapämunayquipä maynu jacyallam cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juc warda muyunćhümi Jesus yaćhapacünincunawan pasayalcäla trïgu-trïgup manyanpa. Chay yaćhapacünincunañatacmi micanäśha cayalcal pallalcälila micalcälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chayta fariseocunaca licälulmi Jesusta nila: “¡Jay! Wic-ari yaćhapacüniquicuna warda muyuncäćhülä tiquilcuśhanwan jalutacuyalcan camachicuyta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Niptinmi: “¿Manachun lïgipäculanqui David micanäśha cayal puliwshï-masincunawan imacta lulapäcuśhantapis? ");
INSERT INTO qvwNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","¿Manachun David, chay Diosta alawana carpanman yaycaycälil Diosllapä laquïsha tantäta micälälila masqui paycunapä mana cunsintiycuśha captinpis? Chay sasirdüticunallapä captinpis manamari jamuyäśhachu capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chaynütac ¿manachun camachicuycäćhu lïgipäculanqui sasirdüticunacá warda muyuncunaćhüpis Diospa chuya wasinćhu lulatityapäcuśhanta? Jinayalcaptinpis manatacmá jamuyäśhachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Rasunpa Diospa chuya wasinpïpis masninlämi cayćhu cäca cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ñatac Diospa shiminćhu: ‘Śhun'üta suwaycälimänayquipä uycamäśhayquinu'a, cuyacuyniyu capäcunayquitam muná’ nishancäta sumäta tantiayalcal'a, cay mana juchayücunäta manaćh jamuyalcanquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Canan tantiapäcuy-ari: ya'a Rasun Nunap maquilläćhümi cay warda muyuncäpis cayan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaypïta Jesus pasalmi juntunaculcänan wasiman yaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chayćhümi mana cuyulï chaquïsha maquiyu nuna cayäñä. Chay fariseocunäñatacmi Jesusta achäqui ashiyninwan: “Má, ¿warda muyunćhülä sänachichwanchun?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Niptinmi: “¿Mayanllayquitan uwishniqui juc ućhcuman śhaticacüluptin, warda muyunćhüpis mana julaycälinquimanchu? ");
INSERT INTO qvwNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Chaychun nunaca mana ćhaniyu cayanman uwishcäpïpis ampá? Chaymari masqui warda muyuncäćhüpis camachicuyca allincäta lulaycachimanchic” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nilculmi chay maquin chaquïsha nunäta: “Chacchapacuy” nila. Chaynu chacchapacuptinmi jucca maquinnuy tuqui sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jinaptinmi chay fariseocuna yalälälimul, Jesusta imanuypa wañuchipäcunanpäpis lluy limanacuyta allaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chayta Jesus tantiälulmi juc-läduman licula. Chayćhu achca nunacuna atipäcuptinmi llapa ishyäcunactapis sänalcachil: ");
INSERT INTO qvwNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“Ya'apïta amam äśhacüśha mismilcachinquichu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Caynüpam Diospa willacünin Isaias unay isquirbishanca lulacacüla. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Chayćhümi niyan: “Paymi sirbïnïpa aclacuśhäca cayan. Pay śhun'üćhu caycuśhanpïmi cushisha cayá. Ispiritú callpanchaycun'a jinantin pachäćhu allincäta tincüninman licaycunanpämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Manam äśhaycaćhayan'achu, nïtac apalcaćhayan'achu. Manatacmi shimintapis cällicunallaćhu uyalipäcun'achu. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ñatac paquilpuyä cäñanuy cäcätapis tuquipmi licaycun. Wañulpuyä michïrunu cäcätapis manam wañulpächinchu. Caynu caycun'a allinca camalaycunanpä unanchaycuśhäman ćhänancamam. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chayćha jinantin pachäćhu nunacunaca payman chalapacullal alcayalcan'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaymi chay üra mana limä apla Satanaśhpa gänäśha nunacta Jesusman puśhapäcula. Jinaptinmi Jesus tuqui limä uyalï nunaman sänächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chaymi chayćhu cäcunaca licapayllaman camäśha ninaculcäla: “¿Caychućh rasunpa canman Davidpa caśhtanpi, Dios caćhamuśhancá?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cay nishancunacta fariseocunaca uyalïlulmari śhun'ullanćhu: “¡Caytá achatucunap quiquin puydï Beelzebüpa munayninwanmá aluyan!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Caynu pinsaśhanta Jesus yaćhalmi nila: “¿Imanuypatá chaynu cälunman? Juc nasyunćhu quiquin-pula pilyapäcul'a lluyćha chincachinacunman. Chaynütacćha juc wasillaćhu pilyapäculpis pampaman muyuchinacunman. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chaynümari Satanaśhpis quiquin-pula cuntra cayal'a laquinacüśha cayan. Chaynu captin'a ¿imanuypatá mandacuynin tacyaycunman? ");
INSERT INTO qvwNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ñatac ya'a, Satanaśhpa pudirninwan lulapti'a amcunap atïniquicuná ¿pip pudirninwantan-nila satanaśhcunap gänäśhacta caćhaycachipäcun? Chay luläcuna-ari, má, niycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Canan Diospa Ispiritunwan achatucunacta caćhaycachiptïmi ichá, tantiapäcunayqui quiquin Diospa gubirnun ćhämuśhuśhayquita. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Má, sumä armädu nunacta manalä ćhänaycul'a manamá imantapis waycäluchwanchu. Chaynaycul-lämi ichá apacuchwan. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Chayurá mana lulawshimal'a, lulaynïta chincayächinquim. Ya'ap faburní mana śhalcul'a, cunträmi cayanqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tuquicta uyalipämay: Tayta Diosmi pampachanman llapa nunap ima jucha lulaśhantapis ima limaywan jalutacuśhantapis. Ñatac Diospa lulaynincunacta ‘Satanaśhpam chay'a’ nil Chuya Ispiritucta jalutacücätam ichá nï imaypis pampachan'achu. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aw-ari, masqui Rasun Nunap Chulincäta jalutacamaptiquipis Tayta Dios pampachaycuśhunquimanmi. Chuya Ispiritucta chaynu jalutacuptiquim ichá cay cawsaycäćhüpis nï juc cawsaycäćhüpis pampachaycuśhunquimanñachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ñatac lantacunäta wayuyninpam lisinchic: Allin lantäpá allinmi wayuyninpis, mana allin lantäpá mana allintacmi wayuyninpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Pasaypi culibraypa milaynincuna! Śhun'uyquićhu mana allincälla winalayaptin ¿imanuypatá allincälä yalämunman? Shiminchic liman śhun'unchicćhu imapis cäcätam. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Allin nunäpá śhun'unćhu sumä cuyay ćhaniyu ćhulacuśhancäpïmi shiminpapis yalamun. Chaynütac mana allin nunäpapis sumä ćhaniyüpa mana allincunallacta ćhulaycuśhancäpïmi shiminpapis yalamun. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Uyalipämay: Cäraycunan muyuncäćhu'a shimiqui chalaśhan ima limaśhayquitapis niycunayquim can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chaymi quiquiquicunap limaśhayquimannuy allinpa licaycuśhapis ütac cäraycuśhapis capäcunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ñatac chayćhu waquinnin fariseocunawan, camachicuyta yaćhachicücunämi Jesusta nila: “Yaćhachicü, má, ima siñalllactapis licaycälichipämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Niptinmi: “Cay Diosta ipanchä pasaypi cullu linlicuna, ¿imallactapis licaycuypïchun wañupacuyalcanquiman? Canan'á Diospa willacünin Jonaspa siñal pasaśhallantam licaycälinqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Paymi sumä jatun challwap patanćhu winalälä quimsa muyun quimsa tuta; chaynümi ya'a Rasun Nunap Chulincäpis quimsa muyun, quimsa tuta allpäpa śhun'unćhu caśhä. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Má, Ninive nunacunäta Jonas willaptinmi juchancunacta wanaculcul Diosman cutipämula. Chaymi canan amcunaćhu Jonaspïpis sumä munayniyücätalä ipanchapäcuśhayquipi mućhuycachinan muyuncäćhu Ninivecunaca śhalcatityamun'a cäraycälishunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Chaynütacmi unay Sheba malcanpa mandä walmipis ‘Puydï Salomonpa yaćhayninta maynümi uyaliycuyta muná’ nil calu-calupïlä śhamula. Chaymi canan amcunaćhu Salomonpïpis mas puydïcätalä mana uyaliculcäśhayquipi mućhuycachinan muyuncäćhu chay walmipis śhalcamun'a cäraycälishunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Amcunacta Satanaśhpa gänaśha cayäcätanümi pasaśhunqui. Chay achatümari juc nunacta caćhaycul pulimun chunyä lanla-lanla ulucunäćhu, jamananpäpis ashishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Chaynu mana talilmi ‘Jamá, cutiycuśhä punta yaćhaśhäcäman’ nil caśhan cutimun. Chaynu cutilmi chay nunäta talin tuqui allichäśha jäcuyä wasi-yupaytapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chayćhümi cutiycun pasaypi anćhish masannincunacta inquitacuycul. Chaynu cutiycul yaćhapäcuptinmi, chay nunaca puntapïpis piyurlä cawsaynin” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Chaynu Jesus limayaptinmi mamanwan śhullcancuna ćhälälimul waśhallaćhu alcayalcäla limaycapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chayćhümi jucnin: “Mamayquiwan śhullcayquicunam ashiyalcäśhunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Niptinmi: “¿Mayantan ya'ap mamá? ¿Pïcunatan ya'ap śhullcäcuna?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nilculmi yaćhapacünincunacta maquinwan unanchaycul nila: “Paycunam mamá. Paycunatacmi śhullcäcunapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mayanpis janay pachäćhu Taytäpa munaśhanta luläcunämá, mamá, śhullcá, panïcunäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chaypïtam Jesus chay wasipïta yalulcul ućha manyanman lil taycucuycula yaćhachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chayćhümi achca nunacuna lluy juntanacälälimuptin chayćhu cä barcuman ishpilcul taycucuycula. Nunacunañatacmi ućhap manyallanćhu capäcuptin ");
INSERT INTO qvwNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tincuchiypa achcacta yaćhachila. Chayćhümi nila: “Juc nunash talpucü liñä. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wacaptinshi waquinnin mujucuna caminucunäman paćhcälun. Jinaptinshi pishucuna śhalcamul lluy pallälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waquin mujucunañatacshi pasaypi ćhäla-ćhälaman paćhcälun. Chaynu janällaćhu calshi apuraypa wiñätucämun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Inti allicta lupämuptinñatacshi ichá lluy chaquïlälin, sapichacunanpä undu allpa mana captin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin mujucunañatacshi ula-ula, caśha-caśhacunäman paćhcälälin. Chay caśhacuna wiñalcamulshi lluy alwächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Juc mujucunañatacshi allin undu allpaman ćhäpäcun. Chaycunash ichá allicta wayupäcun. Jucllay mujullapïshi quimsa ćhunca-cama, süta ćhunca-cama, paćhac wayuyniyü-camalä capäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Linliyu cal'a, uyaliculcay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chaynu niptinmi yaćhapacünincuna Jesusman aśhuycälil tapula: “¿Imapïtam caynu tincuchiyllap yaćhachinqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Niptinmi: “Amcunactá Tayta Diosmi gubirnunćhu pacacuynincunactapis tantiaycachipäcuśhunqui. Juccunätañatacmi ichá mana. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tantiäcunätá mas tantiayta uśhalämi can'apis. Mana tantiäcunätam ichá aśhwanpalä chincalpachisha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chaymi caynu tincuchiyllap yaćhaycachí. Maynüpa licayalcalpis manamá licapäcunchu; maynüpa uyaliyalcalpis manamá uyalipäcunchu nï tantialpapäcunpischu. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Paycunawan lulacacuyan Diospa unay willacünin Isaias isquirbishancämari. Chayćhümi nin: ‘Maynu uyaliyalpis manam intindinchu. Maynu licayalpis manam tantianchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cay nunacunap śhun'un pasaypi lumiyäśham cayan. Linlincunapis wićhacäcüśham cayan. Ñawincunapis apläśham cayalcan. Chaymi mana licapäcun'achu, uyalipäcun'achu, tantiapäcun'achu, nïtac cutipämun'achu sänaycachinäpäpis’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ñatac amcuná cushisha capäcuy, licapäcuśhayquipïta, tantiapäcuśhayquipïta. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rasunpa achca unay allin nunacunäwan, Diospa willacünincunam ichá maynu wañupacuyalcalpis caycunacta mana licaycälilachu nï uyaliycälilapischu. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Chayurá tantiapäcuy-ari cay muju wacäwan tincuchishäcäta. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chay caminüman paćhcä mujunümi cayan Diospa gubirnunpi willacuyninta uyalityayalpis mana tantiäca. Chaymi allin willacuy śhun'unman ćhäśhancätapis Satanaśh śhalcamul waycalpülun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chay ćhäla-ćhälaman ćhäcänümi cayan Diospa allin willacuyninta uyalil-pacha cushisha ćhasquicüca. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chaynu ćhasquishan-laycu imaymana ñacaycunapis, llaquicuycunapis licalimuptinmi mana sapichacüśha lantanuy manaña tacyaycul chaycunaman palpülun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chay caśha-caśhaman muju paćhcäcänümi cayan. Diospa willacuyninta ćhasquilpis cay pachäćhu illaycunallawan, cänincunallawan, cawsaycäćhu lluy munayllancunawan shipuchicüśha cayalmari wayuynin mana canchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ñatac jundu allin allpaman ćhäcänuymi cayan allin willacuyta uyalicul cäsucüca. Chaymi allincunällacta wayuycun jucllay mujullapi quimsa ćhunca, süta ćhunca, paćhac wayuyniyü-camalä canpis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chaypïtam jucman tinculcachil nila: “Diospa gubirnun tuqui acläśha trïgu mujucta nuna talpücänümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ñatac chay tuta puñuyalcaptinmi, ćhïnipänin śhalcamul talpucuśhanpa janäninman gamärracta talpüña. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ñä trïguca wiñalcamul lluy ispijayta allaycuptinmi, chay gamärrapis ispijayta allacuycun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaynüta licälälilmi piyunnincuna mana-mana lilcul: ‘Taytay, tuqui aclaśha mujunllanllanwan talpuchiptinchicpis, ¿maypïtá gamärracuna yalamula?’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Niptinmi duyñuca: ‘Jucnin ćhïnimäninchicmi cayta lulämanchic’ nila. Piyunnincunañatacmi: ‘¿Lluy ulälälimuśhächun?’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Niptinmi: ‘Ama. Yan'almi trïguctapis wayancälächinquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jina cusca wiñachun cusichacama. Cusichananchic muyuncäćhümi piyunnïcunäwan gamärracunäta puntacta apti-apticta watachishä cañaycachinäpä. Trïgucunätañatacmi ichá pilwäman ćhulaycachishä can'a’ nin” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nilculmi yapañatac yaćhachila jucman tinculcächil: “Diospa gubirnun shita mujucta ćhaclaman talpuśhancänümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chay mujuca lluy lluypïpis ñawi chincaycuyllam. Wiñamulñatacmi ichá juc lantacunapïpis mas jatunninlä cacuyan. Chaymi pishucunäpis pallaynincunaćhu lluy ishnachaculcan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nilcul yapañatac tincuchiypa yaćhachila: “Diospa gubirnun'a libadüranüllam cayan. Juc walmi ash libadürallacta quimsa quintal arinamanlä jitaycüluptinpis jinantintam punquichimun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus nunacunäta caynu imamanpis tincuchiyllapmi yaćhachila. Manam imaypis yaćhachilachu mana tincuchiypá. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Caynüpam Diospa unay willacünin nishanca lluy lulacacüla. Chayćhümi niyan: “Tincuchiyllap willapalmi yaćhaycachishä. Ñatac cay pacha camaśhanpi lluy pacaläśhancunätam tantiaycachishä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chaypïtam Jesus llapa nunacunäta wasinta liculcänanpä lluy dispidiculcul yaycula juc wasiman. Chayćhümi yaćhapacünincuna aśhuycul tapupäcula chay gamärraman tincuchil willaśhanca ima ninantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Niptinmi nila: “Chay trïgu talpuchïcá Rasun Nunap Chulincämi cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ćhaclañatacmi cay pachaca. Chay aclaśhan tuqui mujuñatacmi Diospa gubirnunćhu cawsäcunaca. Chay gamärracunañatacmi Satanaśhpa nunancuna. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chay ćhïnicü gamärra talpuchïcämi quiquin Satanaśhca. Cusicha muyuncäñatacmi cäraycunan muyunca. Cusichäcunanñatacmi anjilcunaca. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chay gamärra uläta japächalcul, cañaśhancänümi pasan'a cäraycunan muyuncäćhüpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","“Ya'a Rasun Nunap Chulincämi caćha anjilnïcunacta caćhaycamuśhä mandä nunäcunapi chay allincäpa cuntran śhalcuculcul juccunactapis palpachiyta jicutäcunäta ulaycachinäpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Chaynu juluyculmi nina waläcäman jitaycuśha can'a. Chayćhümi awćhupäcun'a; quiluncunactapis lawćhićhicyachipäcun'alä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ñatac Diospa śhun'unpänuy cawsacunämi ichá intïnuypis chipipicyapäcun'a Taytanchicpa mandacuyninćhu. Linliyu cal'a sumäta uyaliculcay. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Chaynütacmi Diospa gubirnun juc ćhaclaćhu tapäda pampaläcänuy. Chay tapädäta juc nuna talilcul caśhallanman pampalculmi wasinta cushisha cutilcul, llapa imantapis lluy lanticülun chay ćhaclacta lantinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Chaynütacmi Diospa gubirnun cayan, juc nuna tuqui fïnucama aläja lantiyta pulïcänu. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chaymi sumä fïnunnin alli ćhaniyu aläjacta talïlul, cushisha cutilcul lluy imantapis lanticulcul lantïlun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Chaynütacmi Diospa gubirnun challwa chaläcänu cayan. Chay chalacunta lamarcäman jitaycuptinmi allin, mana allin challwactapis chalamun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Juntäluptinñatacmi yacu patanman julalcamul aclaycun. Allinnintam canaśhtanman winaycun, mana allinnintañatacmi ichá wicapälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chaynümi cäraycunan muyuncäćhüpis can'a. Anjilcuna śhamulmi allincunäta, japächan'a mana allincunapïta. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chay mana allincunätam nina waläcäman lluy jitaycapäcun'a. Chayćhümi awćhupäcun'a, quiluncunactapis lawćhićhicyachipäcun'alä canpis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chaynu nilculmi llapa yaćhapacünincunacta Jesus tapula: “Cay nishäcunäta ¿llapantachun tantiälälinqui?” nil. Niptinmi: “Aw, taytay” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Niptinmi: “Chayurá camachicuyta yaćhachicüca jinaman Diospa gubirnunta ćhasquiycücá ishcay tapädayünümi cayan. Chaymari unay camachicuyta yaćhaśhancäpïtawan, canan ya'a muśhü yaćhachicuynïpïta allincäta julaycamunman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chaynu lluy yaćhaycachilmi licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Unay yaćhaśhan Nazaret malcanman ćhayculñatacmi juntunaculcänan wasićhu yaćhachila. Payta uyalilmi malca-masincuna sumä jucmanyacüśha: “¿Mayćhütá caynu yaćhätucämun? ¿Imanuypatá caynu milagrucunactapis lulacuyanman? ");
INSERT INTO qvwNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","¿Manachun carpintïru Josëpa chulillan Mariap wawillan imamá? ¿Manachun cananpis ya'anchicwan cusca yaćhayalcan śhullcan Josëpis, Jacobopis, Judaspis, Simonpis panincunapis, imamá? Chayurá ¿mayćhütá caynüpa yaćhämunman?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chaymi licaytapis mana munapäculachu. Chaymi Jesus nila: “Manam quiquinpa malcallanćhu'a ayllullanćhu'a wasillanćhu'a Diospa willacünincunacta allinpa ćhasquipäcunmanchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chaynu mana chalapaculcaptinmi chay malcaćhu milagrucunacta mana anchá lulayculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay timpu Jesus sumächisha captinmi nasyunpa mandänin Herodespis uyalïlul ");
INSERT INTO qvwNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yanapänincunacta nila: “Bawtisä Juanćha śhalcämun; chayćhá milagrucunacta lulayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Caynüpam Juan wañula. Mandacü Herodesshi walmin Herodiaspa janan carsilman chay Bawtisä Juanta wićhächila maquincunacta cadinawan ćhänalcachil. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chaynu jinala Herodes irmänun Felipip walmin Herodiaswan tincucüluptinshi chay Herodesta: “Caynu cuscacuycuśhayquicá manamá allinchu” nil Juan piñapaptin. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Maynu wañuchiyta munalpis lluy nunacunaca Diospa willacünin Juan caśhanta lisipäcuptinshi lisiräla. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chaypïtash Herodespa santun ćhämuptin Herodiaspa wawin wamlaca llapa ayachishancunap ñawpäninćhu sumä-sumä tuśhuyninwan Herodespa śhun'unta suwaycülun. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayshi wamläta limalicüla: “Imacta mañamaptiquipis uycuśhayquim” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chay niptinshi maman yaćhachishancäta mañala: “Bawtisä Juanpa umanta juc ćhanćhaman uycamänayquitam muná” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Niptinshi mandacü Herodes llaquicüluptinpis llapa ayachimuśhan nunacunap ñawquin limalicuyal'a mana imapis ninan calañachu. Chayshi “Mañaśhanta uycäliy-ari” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jinalshi carsilcäman caćhala mu'uchinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jinalculshi umanta ćhanćhaman ćhulaycul chay wamläta uycula. Chayñatacshi mamanman uycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ñatac ayäpa puliwshïnincunañatacshi ćhaycamul pampapämü apaculcan. Jinalcälilshi Jesusman willaycälï liculcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chayta Jesus uyalïlulmi juc barcuwan chunyäninman japallan licula. Chay-läduman licuśhanta yaćhatityälälilmi chay malcacunapi nisyu-nisyu nunacuna ćhaquillawan lipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chayćhu Jesus barcupi ji'alpunanpä achca-achca alcayalcäta licälulmi śhun'unpis alalaycuptin llapa ishyänin apaśhancunäta sänachipula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chayćhu inti patacña cacuyaptinmi yaćhapacünincuna aśhuycul: “Ñä tardiña cacuyaptin cay chunyäcäćhu micuypïpis wañülälin'aćh. May malcallamanpis micuy ashï lipäcuchunñari” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Niptinmi: “¿Imapälämá lipäcun'a? Amcunari micachipäcuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Niptinmi: “¿Imactamá? Cayćhu picha tantawan ishcay challwallam cayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Niptinmi: “Chayta, má, apamuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nilcul “Llapan nunäta champäman taycachipämuy” nila. Nilculmi picha tantätawan, ishcay challwäta apticulcul sïlüta licalcul Diosta sulpayta ucula. Jinalculmi yaćhapacünincunacta ula manyapi aypumunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chayćhümi llapanpis micapäcula maćhaycälinancama. Jinaman'a puchünincunacta juntapäcuptinmi ćhunca ishcayniyu canaśhta juntalä cacuñä. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chay micücunaca lluy capäcula picha walanganuy wayapanllanlämi. Jinaman walmicunäwan walaśhchacunäwan'a mas masñam capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jinalcul-pacham Jesus nunacunäta jamallá nishancama yaćhapacünincunacta barcuwan puntächila ućhap chimpanman. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Chaynu lluy dispidilculmi ulunpalcüninman Dioswan limananpä japallan ishpila. Chayćhu japallan aspilpuyaptinmi yaćhapacünincunañatac ćhawpichayalcälaña. Chayćhümi alli-alli waywaca punta-lädupi talcämul wicman cayman barcunta apaycaćhacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wallpa wa'ay üranüñatacmi Jesus yacu jananpa pulishtin paycunaman lila. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chayta licälälilmi yaćhapacünincuna manchacuypi: “¡Aćhaćhay! ¡¿Cundinäduchun imam?!” nil apalcaćhacuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chaynacuyalcaptin-pacham Jesus ayaycaćhaypa: “¡Jawcapäcuyña! ¡Ama manchaculcaychu! ¡Ya'ami cayá!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Niptinmi Pedro: “Rasunpa Taytá cal'a ya'apis yacu jananpa talipaycamunacpä niycamay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Niptinmi “Má, śhamuy-ari” nin. Chayćhümi Pedro barcupi ji'alpuycul lićhacula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Chayćhu waywa sumä-sumä caśhancäta manchalicüluptinmi millpucalpuyta allacuycun. Chaymi: “¡Taytay, chutaycallämay!” nil apalcaćhälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nillaptinmi maquipi chutalcul nila: “¡Mana chalapacuyniyu nuna! ¿Imapïtan ishcayyanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chay barcuman pulan ishpïläliptinñatacmi waywaca lluy śhaycüla. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaymi llapanpis Jesuspa puntanman un'ulacaycälil: “Am'a rasunpa canqui Diospa Chulinmi” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chay ućhäta pasälälilmi ćhälälin Genesaret malcäman. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chayćhu nunacunämi Jesus caśhanta tantiälälil juc malcacunamanpis lluy milälälichila. Jinaptinmi lluy ishyänincunacta payman puśhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chayćhümi ruygapäcula müdananpa manyallanta yataycälinallanpäpis. Chaymi mayanpis yataycücá ishyaynincunapi lluy sänapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jesus caśhancämanñatacmi Jerusalenpïta camachicuyta yaćhachicücunäwan fariseocunaca ćhälälimul Jesusta tapupäcula: ");
INSERT INTO qvwNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imapïtatan awquillunchiccunap custumrinta jalutacuyalcan ampa yaćhapacüniquicuna micapäcunanpä maquinta mana pa'acuyninwan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Niptinmi Jesus: “¿Imapïtatan amcuná Diospa camachicuyninta jalutacul, mastá nunap yaćhachishallantatac lulayta jicutayalcanqui? ");
INSERT INTO qvwNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diospa camachicuyninćhu: ‘Taytayquita, mamayquita tuqui allinpa licapäcuy; mayanpis taytanta, mamanta jalutacücá wañuchun’ niyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","¿Chaychun amcuna taytayquicuna ‘yanapaycamay’ nipäcuśhuptiqui ‘Manam capamanchu; Diosmanñam lluy uycülú’ nil niyalcanquiman? Chay jinaśhayquiwanmi yaćhayalcächinqui mana yanapapäcunanpä. Chaynu awiluyquicunap custumrinta yaćhayalcächilmi Diospa Shimintá mana cäman muyulcächinqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Am ishcay cära nunacunapïtamari Diospa unay willacünin Isaias rasunpa nila: ");
INSERT INTO qvwNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay nunacunacá janä shimillanwanmi alawapäman. Śhun'unñatacmi ichá calućhu cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yan'almi alawaycaćhapäman, nunacunallap yaćhachicuyllanta yaćhachiy jicutayalcal'a’ nil” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nilculmi chayćhu cä nunacunäta aśhutyalcachimul nila: “Llapayquipis sumäta uyalimal, umayquiman ćhulapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shiminpa yaycücächu manam nunäta Diospi laquiycachin. Sinu'a shiminpi yalamücämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chayćhu yaćhapacünincunañatacmi masta aśhutyaycul nipäcula: “Cay nishayquim fariseocunäta lluy nanächin” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Niptinmi Jesus: “Janay pachäćhu cä quiquin Taytämi mana lantacuśhancunätá sapipi lluy wicapälun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chayurá paycunacta caćhaycäliy. Apla-pula puśhaycaćhanacücänümi cayalcan. Chaymi cuscan ima ućhcumanpis palpapäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Niptinmi Pedro: “Ña'ay nishayquiwan ¿ima ninayquitan niyalcämanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Niptinmi Jesus: “Quiquïpa yaćhapacünïcunapis ¿pasaypi tullu umachun cayalcanqui, imamá? ");
INSERT INTO qvwNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manachun yaćhapäcunqui, imapis shiminchicpa yaycuśhanca patanchicpi pasaśhanta, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Shiminchicpa yalamücäñatacmi ichá śhun'unchicpi. Caymi ichá Diospi laquichimanchic. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chay śhun'unchicpïmi yalamun mana allin pinsaycuna, wañuchiy munaycuna, mansibacuycuna, imapis anla lulaycuna, suwacuycuna, articuycuna, jamuyacuycunapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lluy caycunam nunäta Diospïta laquiyächin; manamá custumrinmannuy maquinta mana pa'acul micuśhanchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chaypïtam Jesus licula Tirop, Sidonpa malcancunaman. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chay malcaćhu Cananea caśhta walmim Jesusta atila ayaycaćhaśhtin: “¡Davidpa caśhtan Taytay Salbacüní! ¡Llaquipaycallämay-ari! Wamlallätam Satanaśh gänälul sumä-sumä ñacayächillan. ¡Sänaycachipällämay-ari!” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Niptinmi Jesus'a mana jamalilapischu. Chaymi yaćhapacünincuna aśhuycälil Jesusta nipäcula: “Chay walmïta ‘wayra upälla liy’ niy; aläjapämi ayaycaćhaśhtin atiyämanchic” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Niptinmi Jesus: “Chayurá uwishnüpis pintïsha Israelcunallamanćhari Dios'a caćhayäman” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chay walmiñatacmi alcansaycamul Jesuspa ñawpäninman un'ulacuycula: “¡Taytay ama chaynu caychu; yanapaycallämay-ari!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Niptinmi Jesus: “Manash chulinchiccunap shiminpïtalä waycaycul allucunallaman alaycüluchwanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chayćhu walmiñatacmi: “Masqui chaynu captinpis, taytáy, ayllucunaca usuchishallantapis mallilcälinmá allucunäpis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Niptinmi: “Walmi, ampam ichá sumä-sumä chalapacuyniqui. Chaymannu-ari caycuchun” nila. Chay niycullaptinmi wamlan tuqui sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chaypi pasaculmi Jesus ćhäla Galilea ućhap manyanman. Chaypïtam juc uluman ishpilcul chayćhu taycucuycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chaymanmi nunacuna lluy juntunacälälimun imaymana ishyänincuna puśhacälälisha: wishtuśhacunacta, aplacunacta, walla maquicunacta, mana limä upacunactapis. Jesusman ćhächipäcuptinñatacmi lluy sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chaynu mana limä upapis limäluptinmi, walla maquicunapis allin maquiyu chacchaycaćhacuyalcaptinmi, wishtucunapis tuqui pulicuyalcaptinmi, aplacunapis licaycaćhacuyalcaptinmi llapa nunacuna sumä licapayllaman camälälila. Chaymari cushicuypi Tayta Diosta alawapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesusmi yaćhapacünincunacta ayalcul nila: “Cay nunacunäpïmi llaquicú. Micuypïñaćh cayalcällan quimsa muyunña ya'anchicwan cusca cayalcal'a. Chaynu liculcal'a yan'alćha chay lipäcuśhanćhu lawtïlälinman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Niptinmi yaćhapacünincuna: “Cay-chica nunacta micachinapä ¿maypïtan cay chunyä ulüćhu imactapis talishun?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Niptinmi Jesus: “¿Ayca tantallactá uywayalcanquim?” nin. Niptinmi: “Anćhish tantallactawan, ishcay quimsa challwallactam” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Niptinmi llapan nunacunäta pampäman “taycapäcuy” nilcul ");
INSERT INTO qvwNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","chay anćhish tantätawan challwäta apticulcul Diosta sulpayta ucula. Chaynalculmi partilcul uycula yaćhapacünincuna manyapi aypumunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chaymi llapan nunäpis maćhaycälinancama micapäcula. Puchünintañatacmi anćhish canaśhta juntactalä juntupäcula canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chay lluy micücunaca capäcula tawa walanganuy wayapanllanlämi. Jinaman walmicunäwan uchuchäcunäwan'a mas masñam capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chaypïmi Jesus tincunanchiccama nilcul barcuman ishpiculcul Magdala-läduman licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chaymanmi fariseocunäwan saduseocunaca ćhaycälimul yaćhapänan-laycu Jesusta: “Má, altu sïlupi ima siñalllactapis licaycälichipämay” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Niptinmi Jesus: “Siñal siñal niyämanquim. Inti ji'alpunan üra antawchä siñal captinmi usyamunanta tantiapäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ñatac wälanpa pucutay yanalpamuy siñal captin'a tamyamunantam tantiapäcunqui. ¡Ishcay cära nunacuna! ¡Janay pachäćhu siñalcunäta tantiayalcal-lächun canpis, quiquiquicunallaćhu ima pasaśhan siñaltapis mana tantiapäcunquimanchu! ");
INSERT INTO qvwNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tayta Diosta ipanchä pasaypi cullu linlicuna, ¿imallactapis licaycuypïchun wañupacuyalcanquiman? Canan'a Diospa willacünin Jonaspa siñal pasaśhallantam licaycälinqui” nin. Nilculmi chayćhu lluy caćhaycul licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chaypïtam Jesuspa yaćhapacünincuna chay ućhap chimpanman ćhälälil tantacta un'älälimuśhanta yalpäläliña. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chayürallatacmi Jesus nila: “¡Yan'al-lätac fariseocunap, saduseocunap libadüra imanta ćhasquïlälinquiman!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Niptinmi quiquin-pula: “Caynu niyämanchic tantanchicta un'amuptinchicćhá” ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chay ninaculcäśhanta Jesus tantialmi: “¿Imapïtá micuyllapi llaquicuyal piñanacuyalcanqui? ¡Ima-nilä mana chalapacuyniyütan capäcunqui! ");
INSERT INTO qvwNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Chaycunallapïtá ¿manachun yalpapäcunqui picha walanga wayapacunacta picha tantallawan camachiptí, ayca canaśhta junta puchuśhantapis? ");
INSERT INTO qvwNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Un'älälinquiñatacchun anćhish tantallapi tawa walanga nunacunaman aypuchiptí ayca canaśhta junta puchüninta juntupäcuśhayquitapis? ");
INSERT INTO qvwNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chaychun patallanchicman winaycuypi mana limaśhäta nï tantiapäcunquimanchu ampá? Aśhwanpa chay fariseocuna saduseocuna umayquiman winaycälichishuśhayquipïtamá niyá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Niptinlämi micuna tantallapi mana limaśhanta tantiälälila sinu'a fariseocunap saduseocunap yaćhachicuyninpi anyaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chaypi Cesarea Filipos-läducunaman ćhälälilmi Jesus yaćhapacünincunacta tapula: “Juccunaca ya'a Rasun Nunap Chulinta ¿mayan nipämantan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Niptinmi: “Waquinnincuná: ‘Bawtisä Juanćha śhalcämun’; waquinnincunañatac: ‘Diospa unay willacünin Eliasćha cutïmun’; juccunañatac: ‘Jeremiasćha ütac Diospa jucnin unay willacüninpisćha cawsämun’ niyalcäśhunquim” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesusñatacmi: “Amcunapïtá ¿pitan chayurá ya'a cayá?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Niptinmi Simon Pedro nila: “Am'a cayanqui Caćhamuśhan Salbacüca, Cawsä Diospa Chulinmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Niptinmi: “¡Am Jonaspa chulin Simontañatacmi Dios allinpa licaycuśhunqui! Caynu niycachishunqui janay pachäćhu quiquin Taytämi; manamá aychayu tulluyu nunallapïchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amtacmi Pedro canqui. (‘Pedro’ ninan'a ‘wanca’ ninanmi.) Chayurá cay lumïwanmi atïnïcunacta śhalcachishä, ñatac paycunawan infirnup munaynin manam tacyaycälin'achu. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ñatac janay pacha gubirnüćhu anmanmi pudirnïta uycuśhayqui. Chaymi cay pachäćhu awnishayquitapis mana awnishayquitapis janay pachäćhu quiquin Tayta Dios awnilpun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nilculmi yaćhapacünincunacta: “Mayan caśhätapis amam mayanćhüpis limalcälinquichu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chay-pachapïmi yaćhapacünincunacta Jesus willapäla: “Jerusalenta linämi. Chayćhu prinsipal yaśhacunam, puydï sasirdüticunam, llapa camachicuyta yaćhachicücunam ya'acta sumä-sumä ñacachipämal wañuchipäman'a. Jinaptinpis quimsa muyunpïtam caśhan śhalcamuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Niptinmi Pedro japächalcul Jesusta awnichiyninwan piñapäcuyan: “¡Taytay, Dios ama munachunchu chaynu pasananta! ¡Amtá manam imapis pasaśhunayquichu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Niptinmi Jesus muyulcul'a nin: “¡Ñawïpïta chincay, Satanaśh! ¡Iridaycaćhamanquim! ¡Ampa umayqui'a nunap lulayllanćhümi cayan, manam Diospa lulaynincunaćhüchu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nilculmi Jesus llapa yaćhapacünincunacta nila: “Rasunpa mayanpis ya'ap laśhćhüman jalumuyta munäcá quiquinta un'acuycul jalumuchun ima pasaptinpis wañunancama. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ñatac cawsayninta ama-pacha nïcá cawsaynintam apacun'a. Ya'a-laycu bïdantapis uycücämi ichá cawsaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Imapäćha bälinman jinantin pachäta uywayalcaptiquipis, wiñay cawsayniqui chincäluptin'a? ¡¿Almayquipïtá imalämá mas ćhaniyu canmanpis?! ");
INSERT INTO qvwNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yaćhapäcuy; Taytäpa pudirninwan llapa anjilnincunawan juc-pun ya'a Rasun Nunap Chulinca śhamulmi lluy nunacta lulaśhanman tincüta licaycuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rasunpa, waquinniquicuná manalämi wañupäcunquilächu gubirnanäpä śhamuśhäta manalä licaycälil'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Süta muyunpïtañatacmi Pedrocta, Jacobocta, śhullcantin Juantawan puśhaculcul Jesus chunyä ulup puntanman lipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chay ñawpäninćhümi Jesus jucnüman lluy muyülun cäranpis müdananpis intïnu sumä-sumä chipipicyayämüman. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jinamanmi Moiseswan Diospa unay willacünin Eliaswan limaśhtin licalïlun. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaymi Pedro Jesusta: “Yaćhachicü taytáy, allinpämá śhapämuñá. Canan-ari quimsayquipä jucnincä-cama chucllacta lulälälipuśhayqui, ampä, Moisespä, Eliaspä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chaynu niyällaptinmi sumä-sumä chipyayä pucutaynu lluy ñiticalpula. Chay pucutay śhun'unpïmi ayalpämun: “Pay cuyay chulïwanmi cushisha cayá. Paytari uyaliculcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chay nïta uyalïlälilmi yaćhapacünincuna manchacuypïta umantapis pampaman ñaćhaña śhatïlälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jinaptinmi Jesus aśhuycul yataycula: “Ama manchaculcaychu. Śhalcapäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Chay niptin licalcälinanpämi Jesusllaña chayćhu cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ñatac chay ulupi cutiyalcämuptinmi Jesus nila: “Cay licapäcuśhayquipïta amam pictapis willapäcunquichu, ya'a Rasun Nunap Chulincäta wañuchipämaptin caśhan śhalcamunäcama” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Niptinmi yaćhapacünincuna tapupäcula: “¿Imapïtan camachicuyta yaćhachicücunaca niyalcan ‘Diospa willacünin Eliaslämi Salbacücäpa puntanta śhamun'a’ nil?” ");
INSERT INTO qvwNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Niptinmi nila: “Aw chaynümi. Rasunpa Eliaslämi puntacta śhamun'a lluyta tincüninmancama allichaycachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ñatac Elias śhamulañam. Śhamuptinpis nunacunaca pay caśhanta manam lisipäculachu. Aśhwanpam munapäcuśhanmannuy pasachipäcula. Chaynümi Rasun Nunap Chulincätapis pasachipäman'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niptinmi yaćhapacünincuna tantiälälila Bawtisä Juanpi, Eliasman tinculcachil limaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chay ji'alpapämulmi achca nunacuna caśhancäman ćhäläliptin juc nuna Jesusman aśhuycamul puntanman un'ulacuycul nila: ");
INSERT INTO qvwNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Taytay, chulillätari llaquipaycullay. Paytam uman alli-allicta lücuman muyuchillan. Chay chaläluptin'a yacumanpis ninamanpis cućhpälunmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chaymari yaćhapacüniquicunaman puśhamuptí nï tumpallapis sänaycachipällämanchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Niptinmi: “¡Ay, mana chalapacuyniyu pasaypi tullu umacuna! ¿Imaycamatan amcunacta awantaśhtin cayäśhä? Má, cayman-ari puśhamuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chayćhu achatucta piñapalcul maquinpïta caćhaycachiptin-pacham walaśhca tuqui sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaypïtam quiquin-pulallaña yaćhapacünincuna Jesusta nipäcun: “¿Imapïtan ya'acuna caćhaycachiyta mana atipapäcüchu?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Niptinmi: “Pishi chalapacuyniyu capäcuśhayquipamá. Sïchuśh shitap mujunnüllapis chalapacuyniqui captin'a, wic ulüta juc-läduman ‘aśhuy’ niptiqui'a, aśhülunmanmi. Rasunpa imapis manam sasachu canman. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","˻Chaynu captinpis caynücunäta caćhaycachinchic ayunal Tayta Diosta mañacuyllanchicwanmá˼” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Chaypi Galileap malcancunaćhu cayalmi Jesus yaćhapacünincunacta: “Ya'a Rasun Nunap Chulincäta puydï nunacunap maquinman ćhulaycamaptinmi wañuchipäman'a. Jinapämaptinpis quimsa muyunpïtam caśhan śhalcamuśhä” nin. Niptinmi yaćhapacünincuna alli-allicta llaquicälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chaypi Jesus yaćhapacünincunawan Capernaum malcäman ćhäläliptinmi juntunacuna wasipä alcabäla mañäcunaca Pedroman śhalcamul tapula: “Yaćhachicüniqui alcabälacta ¿päganchun icha manachun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Niptinmi: “Aw, päganmi” nin. Nilculmi Jesus caśhanman yaycucuycula chaypi niycunanpä. Manaläpis limalcuptinmi Jesus: “Simon, má, nimay. Cay puydï mandacücunaca alcabälacta ¿mayantatan pägachin? ¿Aylluntachun icha juccunactachun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Niptinmi: “Juccunactamari” nin. Niptinmi Jesus: “Chayurá aylluncuná manamá uycälinanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jinalpis mañäcunaca mana piñacuyalcänanpä canan ućhaman lil challwacta chalamuy. Chay punta challwa chalamuśhayquip shiminćhümi juc illayta talinqui. Chaymi caman'a ishcayninchicpi pägaycunayquipä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chaypïtam yaćhapacünincuna Jesusman aśhuycul tapupäcula: “Diospa gubirnunćhu ¿mayanćha mas puydïnin caycun'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Niptinmi Jesus juc walaśhchacta ćhawpinman śhaycacaycachil: ");
INSERT INTO qvwNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Rasunpa, mana wanacul nï cay walaśhchämannuy mana muyupäcul'a, Diospa gubirnunman nï yaycapäcunquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chayurá cay walaśhchänüpis mana nunatucücällam gubirnunćhu puydïninpa ćhulaycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jinaman mayanpis caynu walaśhchäta ćhasquiycücá, ya'apa caśhan-laycum quiquïtatac ćhasquiyäman. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yan'al-lätac cay uchuchäcunanülla cä chalapacamänïta mayanpis juchaman palpuyächinman. Mas allinćha canman cuncanman wanca lumicta watacuycul lamarcäman ji'acalpuptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Imañam cay pachaca juchallamanña pictapis aysaycuyänanpä! Caycuná jinamá timpuycun'a. Ñatac nuna-masinta mana allincäman aysaycücäpá ¡ay imalä bïdan can'a! ");
INSERT INTO qvwNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Chayurá ćhaquiquipis maquiquipis juchaman jitaycuy munaśhuptiqui'a, cutulcul wicapäläliy. Mas allinmi canman cutu maqui cutu ćhaqui cawsaycäman yaycuy, mana camacaycü nina waläcäman jinantin cuirpuyquita wicapachicuśhayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Masqui ñawiquilä juchaman jitaycuy munaśhuptiquipis, jululcul wicapäläliy. Mas allinmi canman cawsaycäman churchu yaycuypis, pulan ñawiyu nina lupäcäman jitaycuśhunayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Chayurá caynu uchuchäcunäta ama mana cäpa licapäcuychu. Paycunap anjil täpänincuna cayan janay pacha Taytäpa ñawpäninćhümi. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ñatac ya'a Rasun Nunap Chulinca śhamulá, chincaśhacunäta ashilcul Taytäman caśhan cutichinäpämi.˼ ");
INSERT INTO qvwNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Má, nipämay: Juc nuna paćhac uwishninpi jucninta jitapacülul ¿imanantan? ¿Manachun isun ćhunca isunniyu uwishnincunacta lancaycachil chincäcäta ashï intiru ulucta pasacun? ");
INSERT INTO qvwNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Talimul'a rasunpa chay mana chincaśhancäpïtapis mas mastalämi talimuśhancäpi cushicun. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chaynümi janay pachäćhu Taytayquipis mana munanchu nï jucllay uchuchäcunalla chincaycunantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Chaymi chalapacü-masiqui mana allinta lulaśhuptiqui'a, payman lilcul-ari quiquiqui-pulallaćhu tantiaycachimuy. Chayćhu uyalicul tantiacuptin'a, paywan allintam lulälunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana uyalïtucuśhuptiquim ichá, ninacuśhayquita licaycäliwshishunayquipä juc-ishcay chalapacü-masiquiwan cutiycuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Paycunactapis mana quirïtucuptin'a llapa chalapacü-masiquimanña ćhulaycunqui. Lluy paycunactaläpis mana cäsütucuptinñam ichá mana chalapacü ipanchä jalutacücätanüñari licaycäliy. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Rasunpa cay pachäćhu awnishayquitapis mana awnishayquitapis janay pachäćhu quiquin Tayta Diosmi awnilpun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yapa niycälic: caycunapïta ishcayniqui awninacalcälil mañacuśhayquita Tayta Diospis tacyalpachin'am. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Masqui ishcay-quimsalla ya'ap śhutïćhu juntunaculcaptiqui'a, ćhawpiquićhümi caycuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Niptinmi Pedro Jesusman aśhuycul tapula: “Taytay, chalapacü-masí mana allinta lulaycamaptin, ¿ayca cutim pampachäman? ¿Anćhish cuticamalächun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Niptinmi: “Manam. Anćhish ćhunca anćhishniyu cuticamapis maycamapis pampachaycunquim. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Caynümari Tayta Dios gubirnunćhu caycälinanpä pampachaycun. Má, uyalimay. Caynümi cayan: Juc alli cäniyu mandacüshi yanapänincuna mänutacuśhanta mañala. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chayshi imanaculpis mana pägayta atipanan sumä shipuchicüśha mänuyücäta ćhächimun. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chay pägananpä mana illaynin captinshi, mandacüca: ‘Chayurá quiquintañari, walmintinta, chulintinta, lluy cänintinta ima lanticüluy’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Niptinshi mänuyüca puntanman un'ulacuycul: ‘¡Taytay, ama chaynu callaychu! ¡Alcaycallämay-ari! ¡Imanuypapis lluytaćh pägalläśhayqui!’ nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Niptinshi mandacüca llaquipaycul: ‘Jinaña lluy cachun. Jawcallaña licuy’ nil pampachaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Chaypi yalulcul-pachash paytapis yanapä-masin ashllaylla mänucuśhancäwan tincülun. Paytash cuncapi chalaculcul: ‘¡Apuray, canallan illaynïta cutiycachimay!’ nil aysacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jinacuyaptinshi puntanman un'ulacuycul: ‘¡Ama chaynu caychu! ¡Alcaycallämay-ari! ¡Imanuypapis lluytaćh cutiycachilläśhayqui!’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Niptinpis pay'a mana uyalïtucuyculshi päganancama carsilcäman apaycächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cay pasaśhanta licä yanapä-masincunash allicta rabyälälil mandacücäman pasaculcäla willaycälimü. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chayshi mandacüca ayalcachimul nila: ‘¡Sumä pasaypi uywaytan caculläñanqui! Am ruygacamaptiquiñatacmi mänuyquita pampachayculac. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chaychun ampis yanapä-masiquita mana pampachaycunquimanchu cala’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chayćhu alli-allicta piñacüśha cayalshi mućhuchïcunäpa maquinman jitaycula lluy mänunta cutiycachinancama. ");
INSERT INTO qvwNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chaynümi janay pachäćhu cä Taytá amcunawanpis lulan'a chalapacü-masiquicunacta llapan śhun'uyquiwan mana pampachapäcuptiqui'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chaycunacta niyculmi Jesus Galileapïta Jordan mayup chimpanćhu pasalcuyä Judea-läduman licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chayman alli-alli nuna atïcunäćhu ishyäcunätam Jesus lluy sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ñatac chayćhu ishcay-quimsa fariseocunam Jesusta quiquinpa limayllanwan palpachinanpä tapupäcula: “¿Juc nuna walminwan imallapïtapis laquinacunanpä cäsu canchun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nipäcuptinmi Jesus: “¿Manachun lïgipäculanqui Diospa isquirbishanćhu ‘Allaycuycäćhu Tayta Dios walmi carilla cananpämá lulala’ nil nishanta? ");
INSERT INTO qvwNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jinaman jucćhüpis niyantacmi: ‘Chaymi mamanta, taytanta caćhaycul walminwan jucllaña capäcun'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chayurá manañam ishcaychu, sinu'a jucllayllañam. Chaynu quiquin Dios jucllachäśhancäta nunacunaca manam laquinanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Niptinmi fariseocunaca: “Chayurá ¿imapïtan-nila Moisespa camachicuyninćhu ‘Laquinacuchun juc papilta lulanacuycul’ niyan?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Niptinmi: “Awquilluyquicunapïpis pasaypi nuna-cama capäcuptiquim Moises chaynüta isquirbila, masqui allaycuyninćhu chaynu mana captinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya'añatacmi ichá nipäcuc: walmin mana mansibacuyaptin yan'alpi laquiculcul cuscäcá mansibädumanñamari muyülun. ˻Chaynütac chay jitaśha walmiwan cuscäcäpis mansibädumanñatacmi muyun˼” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chayćhu yaćhapacünincunañatacmi nila: “Chaynu captin'a ¿imapätan chayurá casaracuchwan? Chaynu lulanantá aśhwanpaćh mana casaraculcanmanchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Niptinmi: “Cay yaćhachicuy manam lluypächu, sinu'a quiquin Tayta Dios unanchaycuśhancunallapämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Chaymi imaymanap mana casaraculcanchu. Waquinnincunam nasïdunpïña unanchaśha mana casaraculcänanpä. Waquinnincunam capachicälälisha capäcun. Waquincunañatacmi Diosllacta sirbiy munayninwan mana imaypis casaraculcanchu. Caynu cawsayta munäcá chaynu-ari sumäpa cawsapäcuchun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chaypïtam Jesusman puśhapämula uchuchä chulincunacta, umanman maquinta ćhulaycul Diosta mañacapunanpä “allin cawsayniyu cachun” nil. Yaćhapacünincunañatacmi ichá mićhacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chaymi Jesus: “Ama mićhacuychu; jina śhapämuchun. Cay uchuchäcunanuy cäcunapämi Diospa gubirnun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nilculmi uchuchäcunap umanta yataycul Diosta mañacuycul licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chaypïtam Jesusman juc aśhuycamul nin: “Allin yaćhachicü Taytay, ¿imactatan lulalläman wiñay simpri cawsaycäman yaycunäpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Niptinmi Jesus: “¿Imapïmi ‘allin’ nimanqui yaćhachicülla cayapti'a? Allincá Diosllam. Ñatac chay wiñay simpri cawsaycäman ćhayta munal'a camachicuymannuy cawsaycuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Niptinmi müsuca: “¿Mayannincunamannuy?” nin. Niptinmi: “ ‘Amam nunacta wañuchinquichu, mansibacunquichu, suwacunquichu, casquicunquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jinaman taytayquita mamayquita tuqui allinpa licay, nuna-masiquitapis quiquiquitanuy cuyacuywan licaycuytac’ nil nishancunämannuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Niptinmi müsuca: “Caycunallamannu'a uchucllapïmi cawsayculá. ¿Imallá lulaycuná cayanlätan?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Niptinmi Jesus nila: “Sumä allin cayta munal'a, lluy ima cäniquitapis lanticulcul llapa wacchacunaman aypuycamuy. Chayta lulal'a janay pachäćhu sumä cäniyümi canqui. Chaylämi śhamul atimanquiman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ñatac chay müsu alli cäniyu calmi nishanta uyalïlul sumä llaquisha licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chaymi Jesus yaćhapacünincunacta nila: “Rasunpa, sumä cäniyu rïcu nuna Diospa gubirnunman yaycunanpä sasa-sasam. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rasunpa Diospa gubirnunman cäniyu nuna yaycunantá aśhwanpa juc camïllu uywapis awjap linlinpa pasälunmanlämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Niptinmi yaćhapacünincuna licapayllaman camäśha: “Chaynu captin'a ¿mayantá salbacunman?” ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nipäcuptinmi Jesus licapaycul: “Nunacunapá caycuna mana atipänam. Diospämi ichá imapis atipäna” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Niptinmi Pedro: “Taytay, Ya'acunam ichá lluy imallätapis caćhaycul atiyalcac. Chayurá ¿imactatan ćhasquiycapäcuśhä?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusñatacmi: “Rasunpa, juc-pun lluy imapis muśhüman ticlacanancäćhu, ya'a Rasun Nunap Chulinca llapa munaynïwan mandacunäpä taycuptïmi, am atimänïcunapis taycaycälinqui Israelpa ćhunca ishcayniyu aylluncunacta licaycälinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chaymi wasintapis, irmänuncunactapis, panincunactapis, mamantapis taytantapis, chulincunactapis, ütac ćhaclancunactapis ya'a-laycu caćhaycul atimäcunacá, paćhac cuti mastalämi ćhasquipäcun'a. Jinaman wiñay cawsaymanpis yaycun'alätacmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Canan puntanninćhu cäcunämi ipaćhu licalipäcun'a; ñatac ipaćhu licaśhacunämi puntanninćhu caycälin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ñatac Diospa gubirnun caynümi: jatun ćhaclayu nunash wäla wälalla piyun mincacü lin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chayshi muyuncäćhu aycacta gänanancäta awninaculcul caćhälun ćhaclanman. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Altu inti yapa yaluśhanćhüñatacshi läsaćhu talïlun mana lulayniyu nunacunacta. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Chayshi nila: ‘Amcunapis lipäcuy-ari ćhacläćhu lulapämü. Tincüniquimanćha pägapäcuśhayqui’ nil caćhälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chaypïta ćhawpi muyunnuy jinaman yunda pasquicuy üranuy yapa yalul talishancunawanpis chaynüshi lulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chaypi inti ji'alpunayaptin caśhan yalul imapis mana lulayniyu nunacunacta talilculshi nila: ‘Amcuna tucuy anyaśh ¿imapïtan cayćhu tardilpuyalcanqui mana imallactapis lulal?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Niptinshi: ‘Manam mayanllanpis mincaycälimanchu’ nipäcun. Chayshi: ‘Chayurá amcunapis ćhaclätari lipäcuy’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ñä tutalpuptinshi, duyñuca yanapäninta nin: ‘Llapan luläcunäta ayalcul pägay. Ipa yaycamücunäpi allayculmi wälalla yaycamücunaćhu camacanqui’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chayshi picha tardi üra yaycücunaca puntacta śhapämuptin tucuy anyaśh muyun lulapäcuśhantanuy ćhasquiycälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chayshi wälalla yaycücunäñatac ‘Chayurá ya'anchictá mastaläćha pägamäśhun’ nil pinsacuyalcan. Ñatac chaynu tucuy anyaśh lulaśhallanpïshi ćhasquiycälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chayshi duyñüta jucmanyälälisha nicuyalcan: ");
INSERT INTO qvwNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Cay tardillaña yaycamul juc üranuylla lulaycaćhaśhanpïchun pasanquiman ya'acunactawan iwalta. Ya'acunanüchun ampá tucuy anyaśh süday-süday lupayta pasaśhtin trabajayan imamá’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Niptinshi duyñuca jucninta nila: ‘Śhay, ya'a manamari ingañayacchu. Limalanchic anyaśh muyun lulaptiqui, ya'apis chaynüta unacpämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chayurá päguyquita ćhasquil jawcallaña licuy. Cay tardillaña yaycamücunätapis amcunactawan iwalta pägaytam muná. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Illaynïwan munaśhäta manachun luläman? ¿Icha ćhïnipapämanqui allin nuna caśhäpïchun?’ nilshi nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Rasunpam nic: puntanninćhu cäcunämi ipaćhu licalipäcun'a; ñatac ipaćhu licaśhacunämi puntanninćhu caycälin'a. ˻Rasunpa achca ayaśhäcunaca cayaptinpis ashllatacmi aclaśhäcunacá cayan˼” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ñatac Jesus Jerusalenman liyalmi ćhunca ishcayniyu yaćhapacünincunallacta juc-läduman aśhutyalcachil nila: ");
INSERT INTO qvwNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yaćhayalcanquimá canan Jerusalenta lishanchicta. Chayćhümi puydï sasirdüticunämanwan, camachicuyta yaćhachicücunäpa maquinman jitaycälimaptin, ya'a Rasun Nunap Chulincäta wañuyman ćhulaycäliman'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Paycunam mana-Israelcunap maquinman ćhulaycälimaptin, burlapäman'a asutipäman'a, jinalcul curuśhman chacatal wañuchipäman'apis. Chaynu jinapämaptinpis quimsa muyunpïtam ichá caśhan śhalcamuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chayćhümi Zebedeop walmin chay wawin Jacoboctawan Juanta puśhaculcul Jesusman aśhuycul puntanman un'ulacuycula “Piñachïniquim śhamulá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jinaptinmi Jesus: “¿Imactam munanqui?” nin. Niptinmi: “Cay ishcaynin wawilläta, gubirnuyquićhu allinninćhülä taycaycachipallämay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Niptinmi walmip wawincunacta Jesus nila: “Manamá yaćhapäcunquichu ima mañaculcäśhayquitapis. ¿Ya'anuy jucchun llaquicunacta ñacaycunacta pasapäcunquiman ampá?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Niptinmi: “Aw, pasapäcümanmi” nipäcula. Niptinmi: “Aw, rasunpa ya'anümá amcunapis pasaytá pasapäcunqui. Ñatac ya'awan cusca täcunanchicpä manam maquïćhüchu. Quiquin Taytá unanchacuśhancunapämi chay'a cayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chay ćhunca yaćhapacü-masincunañatacmi cay mañacuyninta uyalïlälil chay ishcaycäpä piñacälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chaymi llapanta ayalcul Jesus nila: “Yaćhapäcuśhayquinüpis juc nasyuncunaćhu puydï mandacücunaca payllaña sumä yaćhätucüśha nunatucüśham munaśhanta lulachipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amcunaćhu'a chaynu manam canmanchu. Aśhwanpam pipis puydï cayta munäcá śhullcänuy lluyta sirbiycunman. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chaynütacmi puntaćhu cayta munäcäpis lluypa uywaynin caycunman. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chaypämari ya'a Rasun Nunap Chulinca śhamulá: manam sirbichicunäpächu, sinu'a sirbiycul bïdätapis jinantin nunacunäpi uycul salbaycunäpämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chay Jericó malcäpi Jesus yalapäcuptinmi achca nunacuna atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chay caminu patanćhüñatacmi ishcay aplacuna täcuyalcäñä. Chaymi Jesus pasaśhanta tantiälälil ayaycaćhapäcula: “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacü, Taytalláy! ¡Llaquipaycälillämay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nunacunañatacmi: “¡Upälla capäcuy!” nil piñapäcuyalcan. Chaynu niptinpis aśhwanpalämi masta ayaycaćhacayalcämun: “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacü, Taytalláy! ¡Llaquipaycälillämay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chaymi Jesus śhaycuycul aplacunäta ayalcul tapula: “¿Imallactam nipäculanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Niptinmi aplacunaca: “Taytay, ñawilläta quićhaycälillämänayquitam muná” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chaymi Jesus llaquipaycul ñawincunacta yataycula. Yataycullaptin-pachalla ñawincuna quićhacacüluptinmi Jesusta atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Chaypïtam Jerusalenman Jesus ñaćhapaycuyalcälaña. Chaymi Ulibus ulüćhu Betfage malcap sircascanman ćhaycälil, ishcay yaćhapacünincunacta caćhala cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Cay chimpa malcallaman lipäcuy. Chayćhümi juc aśhnu wawintin watalayäta talipämunqui. Chayta pasquilcul caymanmi puśhapämunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pipis imactapis nipäcuśhuptiqui'a: ‘Duyñümi munan. Ña'ascallamanmi cutichipämuśhä’ nil nipäcunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Caynu lulala willacü Isaias unay isquirbishanca lulacacünanpämi. Chayćhümi nin: ");
INSERT INTO qvwNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalenćhu chulilläcunacta willaycäliy: ‘Licapäcuy, Mandäniqui mana nunatucüśhallam juc malta aśhnullaman sillacuśha śhayämun’ ” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chaymi chay yaćhapacünincuna pay mandaśhantanülla lulapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chaymi malta aśhnuchäta mamantinta puśhalcul müdanancunawan carunalcäliptin Jesus sillacula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chay achca-achca nunacuna atipäcuśhancunapïmi waquinnincuná catacunta lluśhtilcälil lishan caminuman alawayninwan maśhtapäcula. Waquinnincunañatacmi palmïra jaćhap pallaynincunacta cuchulcul maśhtapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chay ipanta puntanta lï nunacunämi bïbaśhtin alawapäcula: “¡Cawsachun Davidpa caśhtan śhamüca! ¡Cawsachun Diosninchicpa pudirninca! ¡Cawsachun imaycamapis!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Chaynu jinaśhtin Jerusalenman yaycüluptinmi llapa nunacunaca tapunacücuyalcan: “¿Pitan cay nunaca?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nipäcuptinmi: “¡Jesusmari! ¡Galileap Nazaret malcanpi Diospa willacünincämá!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chaypïmi Jesus Diospa chuya wasinpa patyunman yaycul lantinacuyalcäcunacta talïlun. Chaymi illaywan cambiäcunap mïsancunactapis paluma lanticücunap täcunancunactapis ticlaypa-pawalcul waśhaman lluyta alapacämun. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jinalculmi nila: “Diospa shiminćhümi ‘Ya'ap wasí can'a ya'allawan limana wasim’ nil niyan. ¡Chaychun amcuna suwacunap maćhayninman muyülälichinquiman!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chayćhümi aplacuna wishtucuna Jesusman aśhuycäliptin lluy sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Chay patyućhu lluy walaśhchacunapis ayaycaćhaypanuy “Mandacü Davidpa chulin altuman juluśha cachun” nipäcula. Ñatac puydï sasirdüticunäwan, camachicuyta yaćhachicücunaca caycunacta uyalilmi, jinaman ishyäcunätapis sänachishanta licalmi śhun'unpis sumä-sumäta timpucuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Chaymi Jesusta nipäcula: “Uchuchäcunaca äśhaycaćhapäcuśhanta ¿manachun uyalinqui imatá?” nil. Niptinmi: “Aw, uyaliyämari. ¿Manachun caycuna pasananpïta lïgipäculanqui Diospa shiminćhu ima nishantapis? Chayćhümi: ‘Am'a alawäśha canqui ñuñuyä uchuchäcunap shiminwanmi’ nilmi niyan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nilculmi chay nunacunäta caćhaycul Betania malcäta licula chay tuta quïdacunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chay wäla aspi-aspilla Jerusalenman cutiyämuptinmi Jesusta micanälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chaymi caminu-lädunćhu ïgus lantacta licälul aśhuycuptin nï licachipäpis ćhulañächu. Chaymi chay ïgusta nila: “Cananpïtá pasaypi manañam wayunquichu” nil. Nilcuptin-pachallam chay lantaca lluy chaquïla. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chaynu lulacäśhanta licalculmi yaćhapacünincuna licapayllaman camäśha Jesusta tapupäcula: “¿Imapïtan cay lantaca juclla chaquïlun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Niptinmi nila: “Rasunpa mana ishcayyällal Diosman chalapaculcaptiqui'a, manam cay lantawan lulaśhäcunällachu lulaśha canman. Sinu'a cay ulüta ‘Caypi aśhucuy lamar ćhawpiman’ nipäcuptiquipis, nishayquimannümi lulaśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chaynümi Diosman sumäpa chalapacul mañacul'a, llapa mañacuśhayquita ćhasquipäcunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chaypi Diospa chuya wasinman ćhaycul Jesus yaćhayächiptinmi, puydï sasirdüticunäwan, prinsipal yaśhacuna aśhuycälil nipäcula: “¡¿Mayantucultá cayćhu lulaycaćhayanqui?! ¡¿Mayantá cayta lulanayquipä ćhulaśhulanqui?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Niptinmi nila: “Má, ya'actapis nipämay: Juan bawtisananpä ¿pitan caćhamula? ¿Dioschun icha nunacunällachun? Niycälimaptiqui'a ya'apis nishayquim mayanpa mandacuyninwan cayta lulaśhätapis” nil. Chaynu niptinmi quiquin-pula ninacücuyalcan: “ ‘Diosmi caćhamula’ niptinchic'a ‘¿Imapïtan-nila mana chalapaculcälanquichu?’ nilćha nimäśhun. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Nunallam’ niptinchic'a, cayćhu cä nunacunäćha sumä imactapis lulämachwan Juanta Diospa willacüninpälä licayalcal'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaynu ninaculculmi: “Manam yaćhapäcüchu, taytay” nin. Niptinmi Jesuspis: “Chayurá ya'apis manam mayan caćhamäśhantapis willapäcuśhayquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Má ¿imanipäcunquitan? Juc nunash ishcay chuliyu cala. Chay jucnin chulinta ayalculshi ‘Canan'a ćhaclanchictari liy lulamunayquipä’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Niptinshi chulin: ‘Ya'a manam lïmanchu’ nila. Nilcuśhanpïshi allinta tantiapaculcul awnil licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chaynütacshi chay juc chulintapis nimula linanpä. Chayñatacshi: ‘Ari papay, canallanmi lishä’ nila. Chaynu nilculpis manash liñächu. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chayurá taytan munaśhantanuy ¿mayannintan lulala?” nin. Niptinmi sasirdüticunaca: “Punta nishan chulinmi” nipäcula. Niptinmi Jesus: “Rasunpa, chay ipanchä alcabäla mañäcunäwan jucnin jucnin umricunawan cacü walmicunämi Diospa gubirnunman amcunapïpis puntacta yaycapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chay Bawtisä Juan śhamulmi yaćhachipäcuśhulanqui Diospa munaśhanmannuy imanuypa cawsapäcunayquipäpis. Chaynu willayalcäśhuptiquipis amcuna manam chalapaculcälanquichu. Chay alcabäla mañäcunäwan, chaynu anla walmicunämi ichá chalapaculcäla. Amcunañatac masqui caycunacta ñawiquiwan licayalcalpis mana chalapaculcälanquichu, nïtac lulayniquicunapïpis wanaculcälanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Uyalipämay caytapis: Juc alli cäniyu nunash cala jatun ćhaclayu. Paymi chay ćhaclanćhu übacta plantalcul manyanta lluy inćhäla. Chayshi übacta apchichinanpä juc püsucta lulala, chaynütac täpachinanpäpis chucllachäla. Caynu lluy listucta lulalculshi nunacunaman partïda uycul calu malcacta licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ñä cusicha timpu ćhämuptinshi, nunancunacta caćhamula partinta cusichananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ćhäläliptinñatacshi chay nunacunaca lluy chalalcälil, waquintá ma'alälila, waquintá wañülächila, waquinnintañatac lumiwan tamshälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaynu jinämuptinshi chay duyñuca mas achcactaña caćhala. Jinaptinpis chay nunancunaca chaynüllash paycunactapis lulälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chayshi ‘Chulïtañari caćhaśhä; paytá allinpaćh licapäcun'a’ nil caćhala. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Chay ćhämuptinshi, partïdaśhan nunacunaca limanacucuyalcan: ‘Cay chulinpäćhá caycuna quïdan'a. Wañüchishun cay tücänin ya'anchicwan quïdananpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chayshi duyñup chulinta chalalcälil, ćhaclanpi waśhaman aysalcälil chayćhu wañuchipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jinäläliptin ¿má, imanan'atan chay ćhaclap duyñun?” nil tapula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Niptinmi: “Mana uchucllapis llaquipayculćha chay pasaypi nunacunäta lluy wañüchin'a. Jinalculćha juc allinnin nunaman uycun'a, pay imaypis partinta uycunanpä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nipäcuptinmi Jesus: “Amcuna ¿manachun uchucllapis lïgipäculanqui Diospa limayninćhu limaśhanta: ‘Wasi luläcuna jalutacuśhan lumim mas allin puydï chaläninmanlä muyüla. Chay quiquin Tayta Dios lulaśhanpïmi licapayllaman camaśha cayalcá’ nil? ");
INSERT INTO qvwNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Chaymi Tayta Dios gubirnunćhu caycälinayquita amcunapi ućhilcul juc allin milachïcunäman uycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ñatac pipis chay lumiman ćhäcá, quićhacacülun'am. Ñatac chay lumica mayanpa janäninmanpis ćhaptin'a lluymi ñutucacülun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ñatac chay puydï sasirdüticunawan fariseocunämi tantiälälila Jesus chayman tinculcachil paycunapi limaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaymi chalachiyta munapäculpis nunacunaca Diospa willacüninpä licayalcaptin manchaculcal mana imanaytapis atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesusmi yapañatac chayćhu tincuchiyllap yaćhachila cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Diospa gubirnun'a caynümi. Juc jatun mandacüshi chulin casaracuptin cumbiducta lulala. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chayshi sirbïnin nunancunawan llapa willachimuśhancunacta ayachimula śhapämunanpä. Jinaptinpis manash nï mayanllanpis śhapämuñächu. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Chaynu mana śhapämuptinshi yapañatac caćhala juc nunancunacta: ‘¡Ñam micuypis imapis listuña alcayäśhunqui! Wira türucunactapis juc wirannin uywacunactapis ćhipïlunñam; casamintupis listuñam cayan. ¡Apurayllash lishun!’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Chaynu ayachiptinpis manash mayanllantapis imapis uculachu. Waquinninshi ćhaclanta liculcäla, waquinnincunañatacshi nigusyunwan pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquinnincunañatacshi chay caćhacuśhan nunäta ma'alcul wañülächila. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jinaptinshi mandacüca allicta rabyalcul, llapa cachacuncunacta caćhäla chay wañuchicücunäta wañuchipäcunanpä, jinaman malcantapis cañaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Jinalculshi nunancunacta nila: ‘Ñam lluy imapis listuña cumbidupä cayan. Chay punta ayaśhayquicuna mana mirisiptinmi ");
INSERT INTO qvwNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","canan lipäcunqui chay malcap jatun cällincunaman läsancunaman lluy talipämuśhayquicunäta puśhapämunayquipä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Niptinshi chay nunancuna liculcäla. Jinalculshi lluy tincuśhancäta allin, mana allin nunacunactapis puśhälälimuñä. Jinaptinshi chay cumbidućhu junta-junta capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Chaynu junta-juntaman mandacüca yaycunanpäshi juc nuna cayäñä chay cumbidupänuy mana tuqui müdanawan müdacuśha. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chaytash nila: ‘Śhay, caynu müdanayu ¿imanuypatá cay cumbiduman yaycamulanqui?’ nil. Niptinshi chay nunaca mana imaniytapis atipal upälla cacuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Chaynaptinshi mandacüca alacamünincunacta nila: ‘Cay nunäta maquinta ćhaquinta lluy ćhänaycul waśha tutapäcäman jitaycälälimuy, chayćhu wa'aśhtin quiluctapis lawćhićhicyachinanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Rasunpa achca ayachimuśhacuna cayaptinpis aclacuśhacunacá ashllam cayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chay nishanta uyalishanpïmi fariseocunaca aśhucalcälil limanaculcäla imanuypapis quiquin Jesuspa shimillan cunca cuchuynin cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chaynu limanacalcälilmi puliwshïnincunacta Herodes partipi śhalcünincunactawan caćhapäcula Jesusman cay nichï: “Yaćhachicü taytáy, tantiapäcümi rasuncälla amćhu caśhanta. Nunacuna limaśhanwan manamá iwichicunquichu nïtacmá pimanpis śhalcuyanquichu. Aśhwanpa Diosninchic munaśhannu rasuncällactam yaćhachinqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chayurá má, niycälillämay ¿Roma gubirnuman alcabälacta uycunapä Tayta Dios awninchun icha manachun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chay mana allin pinsayninta tantialmi Jesus nila: “Pasaypi ishcay cära nunacuna ¿imapïtan imamanpis palpuchiyta munapämanqui? ");
INSERT INTO qvwNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Má, alcabäla pägapäcunayqui illaycäta licachimay” nil. Niptinmi juc dinariu nishan illayta upäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jinaptinmi tapula: “Cay illaycäćhu ¿pitá cayan? ¿Pip śhutintatacmi apan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Niptinmi: “Romap Puydï Mandänin Cesarpam” nipäcula. Niptinmi Jesus: “Chayurá Cesarpa cäcätá, payman-ari uycäliy. Diospa cäcätá Diosmantac-ari uycäliy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Niptinmi licapayllaman camälälil, Jesusta caćhaycul cuticulcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay muyuntacmi wañücuna śhalcamunanman mana quiripäcü saduseocunaca śhapämula. Paycunam Jesusta nipäcula: ");
INSERT INTO qvwNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yaćhachicü taytay, Moises camachicuyninćhümi niñä: ‘Juc wayapa mana chuliyu ima wañucuptin'a, cäsu canmi wanücäpa śhullcanwan biudaca casaraculcul punta wayapanpa milayninta śhalcachinanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chayurá ¿imaninquitan? Ya'acunaćhüshi capäcula anćhish wawi-caśha. Chayshi mayurca walmiculcul mana chuliyu ima wañucula. Jinaptinshi chay biudaca casaracula chay umrip śhullcanwan. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chaynüllatacshi chaypa atimünincäta jinaman lluy atimünincunätapis pasälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chaynu anćhishnintin wañuculcaptinshi chay walmipis wañucun. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chayurá má, śhalcamunan muyunćhu ¿mayanninpa walmintá can'a, anćhishnintinwan casaracuśha cayaptin'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nipäcuptinmi Jesus nila: “¡Maynu pantaśham cayalcanqui Diospa limaynintapis munaynintapis mana tantiapäcuśhayquipi! ");
INSERT INTO qvwNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chay śhalcamuycäćhu umripäpis walmipäpis manañam casaracuycuna can'achu. Sinu'a janay pachäćhu anjilcunanümi capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chay wañücuna śhalcamunanpïtá ¿manachun lïgipäculanqui quiquin Dios nishanta: ");
INSERT INTO qvwNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Wañuśha cayalcaptinpis nila: ‘Ya'am cayá Abrahampa, Isaacpa, Jacobpa alawayalcäśhan Diosnin’ nil? Chayurá Diospá manam chincacü wañücuna canchu; sinu'a cawsä nunallamari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chaynüta uyalipäculmi llapa nunacunaca licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chaynu saduseocunäta upällachishanta yaćhälälilmi fariseocunaca palpuchinanpä limanaculcul ");
INSERT INTO qvwNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","jucnin allin yaćhachicüninta Jesusman caćhala tapü: ");
INSERT INTO qvwNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yaćhachicü taytay, Diospa camachicuynincunapi ¿mayannintan mas puydïninca?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Niptinmi: “ ‘Tayta Diosllayquiman tucuy śhun'uyquitapis, llapan pinsayniquitapis, lluy callpayquitapis ćhulaycuy’ nil nishancämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Caymari lluy mandamäśhanchiccunapïpis mas punta puydïninca. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ñatac cayman atïcäpis chay-yupayllatacmi: ‘Nuna-masiquita tucuy śhun'uyquiwan quiquiquitanuy cuyal licaycuy’ nil nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cay ishcayninmi lluy camachicuypïpis, Diospa willacünin lluy yaćhachishancunapïpis sumä puydïninca cayan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Canan chayćhu lluy juntula quiquin fariseocunätañatacmi Jesus tapula: ");
INSERT INTO qvwNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“¿Imanipäcunquitan Dios Caćhamunan Salbacücäpi? Má, ¿amcunapïtá mayanpa caśhtantá canman?” nil. Niptinmi nipäcula: “Unay Mandacü Davidpïmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Niptinmi nila: “Chaynu milayllan cayaptin'a ¿imapïtan David Chuya Ispiritu Salmos librunćhu limachiptin ‘Duyñümi’ ninman Diostanülä canpis? ");
INSERT INTO qvwNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Chayćhümi ‘Diosninchicmi munayniyu Duyñüta nin: “Cay-lädulläman taycaycamuy ćhïnishüniquicunäta maquiquiman ćhulaycamunäcama wiñay simpri uyshuycälishunayquipä” ’ niyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Chayurá ¿imanuypatan Salbacüca Davidpa milaynillan canman quiquin David ‘Duyñú’ Diostanülä niyaptin'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niptinmi uchucllapis nï mayanninpis ima limalcuytapis atipapäculachu. Chaymi chay muyunpi Jesusta manaña tapućhaculcälañachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaypïtam Jesus nila yaćhapacünincunactawan chayćhu cä nunacunäta: ");
INSERT INTO qvwNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yaćhachicücunäwan, fariseocunämi cayalcan Moisespa camachicuyninta yaćhachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chaymi amcuna uyalicul yaćhachicuynintapis lulapäcunquiman. Lulaynincunactañatacmi ichá ama atichipäcuychu; yaćhachishancäpïta jucwätatacmari lulayta jicutayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paycunap yaćhachicuynin sumä mana atipanan llasä-cama ipictanuy amcunaman ćhulcuyalcäśhannümari. Paycunañatacmi ichá juc dïdullawanpis mana yanapaycälinchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Lulapäcun nunacunaca allinpa licanallanpämi. Chaymi aläjapa Moisespa camachicuyninta jatun lataśhcunawanlä ulcunman, liclancunaman watacuśha pulipäcun. Chaynütacmi Diosllapäña maynu capäcuśhanta licachiculcänallanpä müdananćhüpis aläjapälä jatućhaćhä shalshipnin walcacälälisha pulipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Ima fistaćhüpis juntunaculcänan wasincunaćhüpis allin nunacunap täcunallanmanmi wañupaculcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Läsacunäćhüpis lluy nuna ‘sumä yaćhachicü taytay’ nipäcul allinpa licapäcunallanpïtacmi wañupacun. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Amcunam ichá nunacunäwan yaćhachicüpa licachicuyta ama ashipäcunquichu. Lluypis amcuná wawi-caśhallam cayalcanqui; rasun yaćhachicüniqui ya'allamá cayá. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cay pachäćhu amatacmi pictapis ‘sumä taytay’ nipäcunquimanchu. Sumä taytayqui'a janay pachäćhu cäcällam. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Amatacmi yaćhachicücunäpa puydïnin cayta ashipäcunquichu. Juc yaćhachicüllayquim cayan: ya'a Caćhamuśhan Salbacücämá. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Amcunaćhu mas jatun puydïninca, juccunäpa uywaynin cachun. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ñatac mayanpis nunatucüśha cäcunacá uyshulächisham can'a. Mana nunatucullal cäcunämi ichá altuman juluycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Amcunam Diosman aśhuycälimunanpä mićhacuyalcanqui. Chaymi Diospa gubirnunman mana yaycapämunquichu, nï yaycachipämunquitacpischu. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Amcuna japanyäśha walmicunap wasincunacta waycayalcalpis cärayqui cañälämi allinpa licachiculcänallayquiwan mana camacaycütalä Tayta Diosta mañacuyalcänayquipä canpis. Caycunapïmá mas mas mućhuycachisha capäcunqui.˼ ");
INSERT INTO qvwNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Amcunam ulayta wichayta sïlup sapincamapis cürricaćhapäcunqui ima-nilä atïniquicunactapis ashipäcunayquipä. Chay talishayquicunäta amcunapïpis sumä mas fïnunnin Satanaśhpa chulinmanlämi muyuchipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Puśhaycaćhä aplacuna ¡imalä bïdayqui can'a! Amcuna nipäcunqui: ‘Diospa chuya wasinwan tacyalpachil limalicuśhanchiccá manam lulaycunanchic prisïsanchu. Ñatac Diospa chuya wasinćhu cä ürunwan tacyalpachil limalicuśhanchiccämi ichá lulaycunanchic’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana yaćhayniyu pasaypi tullu umacuna! ¿Mayannintan mas puydïca? ¿Üruchun icha üructapis chuyaman muyuchï Diospa wasinchun? ");
INSERT INTO qvwNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chaynütacmi nipäcunqui: ‘Diospä uycunanwan tacyalpachil limalicuśhanchiccá yan'allam. Ñatac quiquin uycuśhanchicwan tacyalpachil limalicuśhanchiccämi ichá lulaycunanchic’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pasaypi mana umayu aplacuna. ¿Mayannintan mas puydïca? ¿Uycuśhanchiccächun icha Diospä uycunan uycuśhanchiccätapis chuyaman muyuchïcächun? ");
INSERT INTO qvwNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Diospä uycunanwan tacyalpachïcá chayćhu lluy cänintinwantacmari tacyalpayächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chaynütacmi Diospa chuya wasinwan tacyalpachïcäpis chayćhu yaćhä Diosninchicwantac-ari tacyalpayächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chaynütacmi janay pachäwan tacyalpachïcäpis chayćhu mandananpä taycunantinwan quiquin mandä Tayta Dioswantac tacyalpayächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Mastá wañupaculcanqui ‘Diospä ima mintacunapïpis, aniscunapïpis cuminucunapïpis japächaśhun’ nishallanman. Ñatac Diosman chalapacullal, llaquipaywan cuyacuywan tincüninman licaycuy nishuśhayquitam ichá ipanchayalcanqui. Chaymi chullanllanta lulaśhayquinu'a pulantapis lulanquiman cala. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Puśhaycaćhä aplacuna, chuspichacunäta altayalcalpis, jatun camïllucunätam ichá pasalpayalcächinqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Amcunam plätu, bäsu janallan pa'aśhanüpis cayalcanqui. Ñatac śhun'uyquiwan pinsayniqui'a imapis suwacuśhayquip, waycacuśhayquip juntäśham cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Apla fariseocuna. Śhun'uyquitaläri bäsup lulïninta pa'acä-yupaypis pa'aculcay. Chayćha lluy cayniquipis tuqui chuya caycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Amcuna tuqui allichäśha nïchunümi cayalcanqui. Janallayqui'a maynu sumä tuqui cayaptinpis lulïniquićhu'a aśhnayä junta tullucunallawan anlacunallam winalayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chaynümi amcunapis capäcunqui. Cärallayqui'a maypis ‘allin nuna’ ninam. Śhun'uyquim ichá pasaypi imapïpis wañuyä, mana allin lulaycunallacta pinsayä. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ishcay cära fariseocuna, pasaypi yaćhachicücuna, ¡imalä bïdayqui can'a! Diospa unay willacünincunap nïchunta sumätalä śhalcayächinquipis. Chaynütacmi allin nunacunäpa nïchunta tuqui-tuquimanlä impidrayalcanquipis. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jinacalcälilmi: ‘Awquillunchiccunap timpunćhu ya'anchic cawsal'a, manaćh wañuchiyta yanapayachwanchu cala’ nipäcunquilä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Caynu nishayquiwanmá quiquillayquicuna chay wañuchïcunäpa caśhtan capäcuśhayquita willacuyalcanqui. Chayurá paycunanüllamá capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Canan-ari unay awquilluyquicuna Diospa willacünincunacta wañuchiy allaycuśhanta apuraypa camacalpäliy. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Satanaśhpa milaynincuna, ¿imanuypatá amcuna nina waläcäpi lluptïlälinquiman? ");
INSERT INTO qvwNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Diospa willacünincunacta, allin umayücunacta yaćhachicücunactawan caćhamuptïpis waquintá wañuchipäcunquim. Waquintañatacćha chacatapäcunqui. Juccunactañatacćha juntunaculcänayqui wasicunaćhu supay-apachipäcul malcan-malcan aticaćhapäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chaynu allin nuna wañuyninpi mućhuycachisha capäcunayquipä janayquićhüñam cacuyan. Am quiquiqui wañuchipäcuśhayquinümi cayan allin nuna Abelpïta aśhta Diospa wasinćhu uycunancäpa chimpanćhu Berequiaspa chulin Zacariasta wañuchishancama. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rasunpa lluy cay lulaśhancunapïta canan timpu nunacunämi mućhuyta apapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Ay, Jerusalen nunacuna! ¡Ay, imananquilä Dios caćhamuptin willacünincunacta lumi tamshaywan wañuchïcuna! Juc wallpa chipchincunacta juntuycücänümi achca cuti llapayquitapis jucllaman juntuycuyta munalá. Jinaptïpis amcuna manamá munapäculanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Canan licapäcuy; amcunap malcayqui lluy pulumäśhañam licalin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rasunpa cananpi-pacham manaña nï uchucllapis licapämanquiñachu aśhta ‘¡Altuman juluśha cachun Diospa Pudirnin Śhamüca!’ nil nipämänayquicama” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Diospa chuya wasinpi Jesus yalalcamul liyta allaycuyaptinmi, yaćhapacünincuna aśhuycälil nipäcula “Licay, cay wasi maynu sumä-sumämi caculläñä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Niptinmi: “Cayta licayalcanquimá. Rasunpa cay caśhancäćhu licachillapäpis manamá juc lumillapis caycun'achu. Lluymi pampaman muyun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ñä Ulibus ulüman ćhaycälil Jesus täcuyaptinmi, yaćhapacünincuna aśhuycälil nipäcula: “Niycälimay-ari ¿imaymi chay lulacacun'a? Cutimunayquipä ñatac cay timpup camacaynin ji'acaycayämuptin ¿ima siñalcunam śhamun'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Niptinmi Jesus nila: “Yan'al-lätac pipis ingañapäcuśhunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ya'atucul achca śhapämulmi ‘Ya'am Caćhaśhan Salbacüca cayá’ nil achca nunacunacta pantachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ñatac wicćhüpis cayćhüpis gïrrash nïcunacta uyalipäcul ama manchaculcaychu. Chaycuna pasananmi yaćhacun masqui manalä camacayca cayaptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chaynütacmi chaypá nasyuncunapis malcacunapis gïrranaculcan'a. Chaynütacmi mayćhu chayćhüpis micuy wanacunapis ishyaycunapis śhaśhaycunapis cacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lluy caycuna ñacaycunap allaycuyllanlämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Chayćhu ya'a-laycumá supay-apachipäcuśhunayquipä ćhïnipapäcuśhunayquipä wañuchipäcuśhunayquipäpis ćhulaycapäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chay timpućhümi achca ipanchapäman'a. Chaymi quiquin-pulacuna ćhïninaculcan'a, jitaycanaculcan'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yan'al willacütucücuna licalilcamulmi achca nunacta pantachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ancha-anchap mana allin lulaycunallaña timpuyaptinmi, lluy nunacunapapis śhun'un lumiyalpuyan'aña. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wañuycäcama tacyaycücämi ichá salbacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Caypa allin willacuyninmi jinantin pachäman willaycuśha can'a lluy nunacuna lisipäcunanpä. Chaylämi cäraycunan muyunca śhamun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“¿Manachun willacünin Daniel isquirbila chay Sumä Millachicüman Muyuchïcäpi? Chayurá cayta lïgïcunaca, sumäta tantiapäcuy. Chay Millachicüca Diospa chuya wasinćhu licalimuptinmi, Judea-lädućhu yaćhäcunaca juclla ayipäcunan ulucunäman. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Chaynütac wasinpa altuśhninćhu cäcunaca imallanta juluycunallanpäpis timpu manañam can'añachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ćhaclanćhu cäcunäpis müdanallanta juntulcü cutipämunallanpäpis timpu manañatacmi can'añachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Maynu llaquićh can'a patayu walmicunäpä, chaynütac wawinta ñuñücunäpä! ");
INSERT INTO qvwNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chaycuna tamya timpućhu nï ima warda muyunćhüpis pasananpä Diosta ruygaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cay sumä ñacaycunänu'a cay pachap allaycuyninpïpis manam pasalachu, nïtacmi can'atacchu. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chay timpucta Tayta Dios mana mirmachiptin'a manaćh mayanpis salbaculcanmanchu; ñatac japächacuśhancuna-laycum mirmaycachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Chay timpu mayanpis ‘¡Licay! ¡Diospa Salbacüca cayäñä wicćhümi, cayćhümi!’ nil nipäcuśhuptiquilätac, quiriyalcanquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rasunpa salbacütucücuna willacütucücuna śhalcapämulmi imaymana milagrucunacta lulapäcul Diospa aclacuśhancunätapis atipayänülä pantachiyta jicutapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ñam yaćhaycachishaña cayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Chaymi masqui ‘Salbacüca wic ulućhümi cayan’ nipäcuśhuptiquipis ama lipäcuychu. ‘Cayćhümi pacalayan’ nil nipäcuśhuptiquipis ama quiripäcuychu. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aśhwanpa ya'a Rasun Nunap Chulinca cutimuptí inti yalamunanpi aśhta inti ji'alpunancama, sumä wacli uyaypa camalämuśhancänümá can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maynümi aycha captin uyaypa wisculcuna muyupäcun; chaynümi amcunapäpis uyaypatac can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Chay sumä ñacay timpuca pasalcullaptinmi intica wañun'a; quillapis manañam acchin'achu; uyllurcunapis lluyñam palpatityamun'a; janay pachäćhu lluy cäcunäpis śhaśhalin'am. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Chayćhümi ya'a Rasun Nunap Chulinca janay pachäćhu camalacamuśhä. Jinaptïmi intiru malcacuna pucutay jananćhu altuman juluycuśha sumä munayniyu ya'acta cutiyämüta licapämal awćhuyllaman camapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jinaptinmi anjilnïcunacta caćhamuśha juc curnitilla sumä-sumä tucalpamuyćhu jinantin pachäpi llapa aclaśha nunäcunacta juntuchimunäpä aśhta sïlup sapinćhu cäcunätapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yaćhapäcuy-ari lanta tantiachimäśhallanchictapis. Pallaynincunaćhu chillquilimuptinmi tamya timpumanña ćhaycuśhanchicta tantianchic. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chaynu-ari lluy caycuna pasaśhanta licapäcul'a janayquićhüña timpuca caśhanta yaćhapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rasunpa lluy caycuna pasan'a manaläpis cay timpu nunacunaca camacaptinlämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cay pachäwan janay pachäćhu licaśhallanchiccuna camacällam. Ya'ap nishäcunañatacmi ichá wiñay simpripä caycü. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ñatac chay śhamuná ürätam ichá nï pipis yaćhanchu. Manam quiquïpis nïtac anjilcunapis sinu'a Taytallämi yaćhan. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ya'a Rasun Nunap Chulincäpa cutimuyní can'a Noé timpućhu pasaśhannümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manaläpis chay tamya fisyu ćhämuptinlämi llapa nunapis upyayllacta, casaracuycunallacta, fistacunallacta jawca lulaculcäla aśhta Noé barcunman yaycunancama. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chaynu mana imallactapis tantiaculcaptinmi tamya fisyu chalälun. Chaynümi ya'a Rasun Nunap Chulinca cutimuptïpis pasan'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chaypun masqui ishcay nuna ćhaclaćhu cayalcaptinpis jucninmi puśhacuśha can'a, jucninñatacmi caćhaycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chaynütacmi ishcay walmicuna a'ayalcaptinpis jucnin puśhacuśha can'a, juccäñatacmi caćhaycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Chayurá musyat-musyatlla capäcuy; manamá imay üra cutimunäta yaćhapäcunquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Maynümi wasiyüca suwanan üräta yaćhayalñá, mana jawcachu puñucun, aśhwanpam listuña täpayan mana suwachicunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chaynümá licchat-licchat capäcunayqui. Ya'a Rasun Nunap Chulinca mana imapis ucuśhayqui üram śhamuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Chayurá capäcuy chalapacuna yaćhay-sapa tantiayniyu uyway nunanuy. Caynu nunactamá ‘cay wasïpi incargacuy’ nil maquinman ćhulaycunman lluy nunantapis ürallanćhu micachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cushisha cachun imam chalapacuśhanmannuy lulayäta talïluptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Paytamá duyñun lluy cänintapis licaycunanpä maquinman ćhulaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Yan'al-lätac chaynu mana allin śhun'uyu nunan ‘canan imayläćha cutimun'a’ nilcul uyway-masincunacta ñacachiyta allacuycunman. Jinal munaśhanta lulal upyacunman micucunman wasictapis lluy un'aycul ima. ");
INSERT INTO qvwNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Rasunpa duyñun un'aypi mana pinsaśhan üra ćhämul, ¿imanälun'aćh? ");
INSERT INTO qvwNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sumä lawćhayculćhá ishcay cära mana chalapacücunap laśhćhunman ćhaycälichin'a. Chayćhüćha awćhupäcul quiluctapis lawćhićhicyachipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Chay muyuncunaćhu Diosninchicpa gubirnun'a can'a ćhunca wamlacuna acchin apticüśha casamintuman linanpä casaracücäta alcäcänümi. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chay picha wamlacunämi lucla-cama capäcula; chay juc picha wamlacunäñatacmi tantiayniyü-cama capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay luclacunämi ash asaytillantawan michïrunta apapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Chay tantiayniyu wamlacunäñatacmi ichá juntay-juntay asaytiyüta michïrunta apapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chay casaracüca manalä ćhäcälimuptinmi puñuy aysäläliptin puñülälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chaynu puñulcaptinmi ćhawpi tutanuy ayaycaćhacayämun ‘¡Casaracüca śhacayämunñam! ¡Yalapämuy ćhasquipäcunayquipä!’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Niptin-pacham śhalcacalcälil acchincunacta lluy allichäcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chaymi chay lucla wamlacunaca nipäcula juccunäta: ‘Asaytiquicta laquipaycälillämay; michïrümi wañucalpuyällanña’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Niptinmi: ‘Manam camamachwanchu ampäwan'a. Aśhwanpa lantimü licäläliy’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Chaynu lantï liculcäśhancamam casaracüca ćhämuptin chay picha tantiay-sapacunaca lluy cumpañänincunactawan liwshil yaycacaycälilaña casamintüman. Jinaptinmi puncüpis lluyña wićhacämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chaynüman chay picha ćhälälimulmi ‘¡Taytay Taytay, quićhallämay-ari!’ nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Niptinmi ‘Rasunpa ¿mayanćha caculcanquipis? Manam ya'a lisicchu’ nimula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chaynümi amcunapis musyat-musyat capäcunayqui. Manamá amcuna yaćhapäcunquichu imay muyun, nï imay üra cutimunätapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Chaynütac Diospa gubirnun'a juc nuna juc-lädu nasyunta licunanpä llapa nunancunacta ayalcachil lluy illayninta licaycunanpä aypuycücänümi cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Má, unayshi tincüninman-cama uycula jucninta picha walanga illayta, jucnintañatac ishcay walangacta, jucnintañatac walangallacta. Jinalculshi biäjicta licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chay picha walangacta ćhasquï nunäshi chay illaywan nigusyal, chaynu picha walanga mastalä milächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chaynütacshi chay ishcay walangacta ćhasquïcäpis, ishcay walangamantac milächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Chay walangallacta ćhasquïcäñatacshi ichá illay uśhancäta juc ućhcucta lulaycul pampälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Chaypïtash chay patrunnin una-unaypïtalä cutïmul nunancunacta watucula illayninta licaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chayshi picha walangacta ćhasquï nunan picha walanga milayniyüta apapacüśha śhalcamul: ‘Taytay, picha walanga umäśhayquita picha walanga masmanmi milachillá. Cayllá’ nil uycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Niptinshi: ‘¡Allinmi! Am'a allin chalapacuna nunamá cañanqui. Ash uśhäcällactapis tincüninman licaycuśhayquipam canan achcactalä maquiquiman ćhulaycamuśhä. ¡Canan yaycamuy ya'awan cusca cushisha canayquipä!’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Jina ipanmanñatacshi ishcay walanga ćhasquïcäpis ćhaycamul: ‘Taytay, ishcay walanga umäśhayquita ishcay walangamantacmi milachillá. Cayllá’ nil uycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Niptinshi: ‘¡Añalláw! Am'a allin chalapacuna nunamá cañanqui. Ash uśhalläcätapis tincüninman licaycuśhayquipam canan achcactalä maquiquiman ćhulaycamuśhä. ¡Canan yaycamuy ya'awan cusca cushisha canayquipä!’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Jinamanshi walangallacta ćhasquïca ćhaycamul: ‘Taytay, chalat-chalatyayä nunamá am cañanqui. Mana talpucuśhayquipïmá cusichacunqui. Mana wacacuśhayquipïmá pallacunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chaymi manchacuypïta illay umäśhayquita pampäman lluy pacälá. Cay-ari cay illayniqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Niptinshi: ‘¡Ima-nilä pasaypi illa nunam cañanqui! Mana talpuśhäpi cusichaśhäta yaćhayal'a, mana wacacuśhäpi pallaśhäta yaćhayal'a ");
INSERT INTO qvwNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿manachun cay illaynïta bancuman ćhulaycämunquiman cala cutimul milayniyüta ćhasquinäpä?’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nilculshi chayćhu cäcunäta nila: ‘Cay walanga uywaśhan illaycäta quitalcul, chay ćhunca walangayücäman uycuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Caynu achca cäniyücunämanćha masta uycuśha can'a. Ash cäniyücunallactañatacćha ichá ash cällantapis quitalpuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cay mana bälï nunätá waśha tutapäcäman-ari wicapäluy. Chayćhüćha awćhun'a quiluctapis lawćhićhicyachishtin’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","32","“Chaynütac ya'a Rasun Nunap Chulinca lluy anjilnïcunap ćhawpinćhümi sumä munayniyu cutimuśhä. Jinalculmi mandanäpä täcunäcäman taycuycuśhä jinantin pachäpi nunacunäta juntuycamunäpä. Chayćhümi uwish michï capishcunäta japä laquïcänuy, ya'apis nunacunäta laquishä. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uwishcunätam allïnï-läduman; capishcunätañatacmi ichünï-läduman. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jinalculmi sumä mandacüca caynïwan allïnïćhu cäcunäta nishä: ‘Taytäpa śhun'unpa cäcuna, śhapämuy. Cay pacha allaycuśhanpi unanchaycapäcuśhuśhayqui mandacuynïman yaycapämuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Micuypi cayaptïpis uycälimälanquim. Yacupi puliyaptïpis chacchaycälimälanquim. Pulicü nunanuy puliyaptïpis jamaycälichimälanquim. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Müdanapi palpüśha cayaptïpis müdalcachipämälanquim. Ishyayaptïpis watucaycälimälanquim. Carsilćhu wićhalayaptïpis licaycüní śhapämulanquim’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Niptïmi chay allïnïćhu cäcunaca nipäman'a: ‘Taytay, ¿imaytan micuypi cayaptiqui uycälilac, yacupi cayaptiqui chacchaycälilac? ");
INSERT INTO qvwNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Imaytan pulicü nunactanuy lical, jamaycälichilac? Müdanapi yalüśha cayaptiqui ¿imaytan uycälilac? ");
INSERT INTO qvwNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Imaytan ishyäta ütac carsilćhu wićhalayäta lical śhapämulac?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nipämaptinmi nishä: ‘Rasunpa mayanllan nunalläta masqui licaytapis mana munaśhacunällacta uyculpis, ya'a quiquïtamá uycälimälanqui’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ñatac chay ichünïćhu cäcunätañatacmi nishä: ‘¡Pasaypi nunacuna, ñawïpïta chincapäcuyña Satanaśhpäwan atïnincunapä lulaśha mana camacaycü nina waläcäman! ");
INSERT INTO qvwNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Micuypi cayaptïmi mana uycälimälanquichu. Yacupi cayaptïmi mana chacchaycälimälanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pulicü nunanuy puliyaptïmi mana jamaycälichimälanquichu. Müdanapi palpüśha cayaptïmi, mana müdalcachipämälanquichu. Ishyayaptïpis, carsilćhu wićhalayaptïpis licaycüllapis śhapämulanquichu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Niptïmi nipäman'a: ‘Taytay, ¿imaytan micanäśhacta, yacunäśhacta, pulicü nunanuy puliyäta licapäculac mana uycälinacpä? ¿Imaytan müdanannäta, ishyayäta ütac carsilćhu wićhalayäta licapäculac mana yanapaycälinacpä?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nipämaptinmi nisha: ‘Rasunpa mayanllan nunäta masqui un'aśhacunallacta mana uyculpis, ya'a quiquïtam mana uycälimälanquichu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chayćhümi chay nunacunaca wiñay simpri mućhuycachishancäman lipäcun'a. Cay allin luläcunañatacmi ichá wiñay simpri allin cawsaycäman lipäcun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chaynu lluy nilculmi Jesus yaćhapacünincunacta: ");
INSERT INTO qvwNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yaćhapäcuśhayquinüpis ishcay muyunllañam Egiptopi Libracuśhanchic fistapä cacuyan. Chayćhümi Rasun Nunap Chulincäta puydïcunap maquinman ćhulaycamaptin chacatapäman'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ñatac chay muyuncunapä puydï sasirdüticunawan, yaćhachicücunawan prinsipal yaśhacuna juntunaculcäla sasirdüticunap sumä puydïnin Caifaspa canancäman. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chayćhümi limanaculcäla Jesusta artiwan chalalcälil wañuchipäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ñatac: “Fista muyuncäćhu'a manam lulachwanchu; yan'almi nunacunaca lluy chäcunacälälinman” ninaculcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ñatac Betania malcäćhu “lipra-sapa” nipäcuśhan Simonpa wasinćhümi Jesus micuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chaymanmi juc walmi śhamuñä caćhi lumipïtanuy uchuy butïllachaćhu sumä ćhaniyu pirfümicta apacuśha. Chaytam Jesuspa umanman jillpuycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chayta licälälilmi yaćhapacünincuna rabyälälil: “¿Imapätan cay-chica ćhaniyüta yan'al pampapä jinayanqui? ");
INSERT INTO qvwNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aśhwanpam allinćhu lanticulcul lluy wacchacunacta aypuycuchwan cala” nil ñaćha millpälälinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chaynu nipäcuśhanta tantiälulmi Jesus: “¿Imapïtan cay walmïta rabyachipäcunqui? Cay lulaycuśhanwan allincätam lulaycun. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wacchacunacá imaypis amcunawanläćha capäcun'a. Ya'am ichá ash muyuncunallaña amcunawan caycuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cay jillpuycamäśhanwan pampacuynïpäñam alistayäman. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rasunpa, allin willacuyta jinantin may pachäćhu willacuśhancunaćhüpis, cay walmi lulaśhanpïpis yalpaśham can'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chay ćhunca ishcayniyu yaćhapacünincunapïta Judas Iscariotiñatacmi puydï sasirdüticunäman cürrilcul: ");
INSERT INTO qvwNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“¿Aycactam uycälimanquiman Jesusta maquiquiman ćhulaycamuptí?” nila. Niptinmi paycuna quimsa ćhunca illayta unanpä limalicälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chay-pachapïmi Judas ashila maycäćhu imanuypa chalaycachiytapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chay Mana Libadürayu Tanta Fistap allaycuyninćhümi yaćhapacünincuna Jesusman aśhuycälil: “¿Mayćhümi alistapamuśhä cumbiducta micunanchicpä?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Niptinmi: “Cay malcaćhu nunaman lil: ‘Yaćhachicücämi: “Üräćhüñam cacuyá. Wasiquićhu cay fistap cumbidunta yaćhapacünïcunawan lulapäcuśhä” ’ nil nimuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Niptinmi yaćhapacünincuna nishantanülla lulaycälil cumbidupä alistapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tuta ćhämuptinñatacmi Jesus ćhunca ishcayniyu yaćhapacünincunawan mïsaćhu micapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chayćhümi: “Rasunpa jucniquim ipanchapämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Niptinmi sumä llaquicälälisha tapucuyalcan: “Taytay, ¿ya'achun icha cayällá?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesusñatacmi: “Ya'awan cusca micücälämá ipanchaman'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nishanpïmi: “Ya'a Rasun Nunap Chulincäpi isquirbishancämi lulacacun'a. Ñatac ¡imanuylä can'a chay ipanchamäcá! Aśhwanpaćh mana näsimuptinpis mas allin canman cala” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ñatac ipanchananpä cä Judaspis: “Yaćhachicü taytay, ¿ya'achun icha calläman?” nin. Niptinmi: “Quiquiquimari nicuyanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chay micapäcuśhanćhümi Jesus tantäta apticulcul Diosta sulpayta ucula. Chaypïta partilcul yaćhapacünincunaman uycula: “Caymi aychá; micapäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaynütacmi bïnüta apticulcul Diosta anradisiculcul, paycunaman uycula: “Caypi lluypis upyapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay jićhaśha yawarnïwanmá muśhü limalicuśhäta tacyalpachishä llapa juchacuna pampachäśha cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ñatac cay bïnucta manañamá mallilcuśhächu Taytäpa gubirnunćhu amcunawan cusca muśhü bïnucta upyananchiccama” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chaypïtam taquicunawan alawapäcuśhanpi Ulibus nishan ulüta liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chayćhümi Jesus: “Cay tuta japalläta caćhayculmi lluy jitälälimanqui isquirbïshaćhu nishanmannuy: ‘Uwish michïninta wañüchiptïmi uwishcunaca lluy chi'ilun'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ñatac śhalcämulmi amcunapïpis puntactalä Galileaman lishä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Niptin Pedroñatacmi: “¡Masqui lluy jitälälishuptiquipis ya'a manamá imaypis caćhaycuśhayquichu!” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Niptinmi Jesus: “Rasunpa cay tuta manaläpis wallpa wa'amuptinmi quimsactaña am ipanchämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Niptinmi: “¡Masqui anwan cusca wañuná captinpis manam ipanchaśhayquichu!” nicuyan. Chaynütam llapan yaćhapacünincunapis nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaypïtam Getsemaní nishanman lipäcula. Chayćhümi Jesus yaćhapacünincunacta nila: “Taytäwan limaśhäcama cayllaćhu-ari täcaycälichcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chayman Pedroctawan, Zebedeop ishcaynin chulinta puśhayaptinmi sumä llaqui chalälun: ");
INSERT INTO qvwNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Wañucüpä śhun'unnümi śhun'ú llaquicüśhaña cacuyan. Cayllaćhu-ari lichcat-lichcat capäcuchcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chaypïta mas puntascaman lilculmi lawacaculcul ruygacula: “Taytay, cay sumä ćhacćhä-yupay ñacaycunäpi munal'a julaycallämay. Amatac-ari ya'a munaśhänu'a lulacächunchu, sinu'a ampïtaćh imanuypis can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chaypïta caśhan cutimunanpämi yaćhapacünincuna puñuywan aysachicüśha cayalcäñä. Jinalmi Pedrocta: “¿Manachun juc ürallapis ya'awan cusca licchat-licchat cayta atipälanqui imamá? ");
INSERT INTO qvwNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Licchat-licchatllari Diosninchicta ruygaculcay cay śhamü llaquicuycunäćhu callpawan śhaycapäcunayquipä. Śhun'uyqui allin lulayta wañupacuyaptinpis aychayquimá mana callpayu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chaypi yapa cutilculmi mañacula: “Taytay, cay pasanäcäpa pasanä captin'a jinari lulaśha cachun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yapa cutimulpis caśhan puñuywan aysachicüśha aywićhyayalcätam talïlun. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chaynu quimsa cutićhu cutilculmi Diosta mañacun punta nishancänülla. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaypi yaćhapacünincunaman cutimulmi: “¿Jinallachun puñuycällaćhu cayalcanquiman, imatá? Rasun Nunap Chulincäta jucha-sapap maquincunaman ćhulaycamänan üraca ćhämunñamá. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Śhalcapäcuyñari; ji'acaycayämunñam ipanchamänïca!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chaynu limayällaptinlämi yaćhapacünin Judas puydï sasirdüticunap, prinsipal yaśhacunap caćhaśhan achca nunancuna caśhpicunawan, ispädacunawan sumä armädu-cama ćhälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ipanchä Judasñatacmi yaćhachilaña “Muchaycuywan limaycuśhäcäta chalalcul aysapäcunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chaymi ćhämul-pacha Jesusman aśhuycul: “Taytalláy” nil muchaycul limaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesusñatacmi: “Lulanayquipä śhamuśhayquita lulaycuy-ari” nin. Nillaptinmi juccunaca lluy chalälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jinaptinmi Jesuspa jucnin atïnin ispädanta jululcul puydï sasirdütip uyway nunanpa linlinta pasächin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jinaptinmi Jesus: “Chay ispädayquita ćhulalänanman cutiycachiy. Mayanpis ispädawan pilyäcá chaywantacmi wañun'apis. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manachun tantianqui Taytäta mañacuptí canan-pacha anjilnincunacta walangantin walangantin mastalä licaycamänanpä caćhamunanta? ");
INSERT INTO qvwNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jinaptin'a, ¿imanuypatá isquirbishacunäćhu lluy pasananpä cäca lulacacunman?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nilculmi chay juc nunacunäta: “¿Ya'a suwachun imam calá caynu caśhpiqui ispädayqui aysacälälisha puśhapämänayquipä? Walan-walan Diospa chuya wasinćhu yaćhayächiptïpis manatac chalapämälanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ñatac canan'a Diospa unay willacünincunap isquirbishanćhu nishanmannuy lulacacunanmi” nila. Niyällaptinmi japallanta caćhaycul llapa yaćhapacünincuna ayiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chay puśhäcunämi puydï sasirdüti Caifaspa canancäman Jesusta ćhälächin. Chayćhümi camachicuyta yaćhachicücunaca, prinsipal yaśhacuna juntunacüśha cayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedroñatacmi calullapi atila puydï sasirdütip canancäpa patyuncama. Chayman yaycucuyculmi täpä wardiacuna canancäćhu taycucuycul “¿Imanälälin'aćh?” nil licapäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wasi lulićhüñatacmi sasirdüticunäwan lluy Cunsïjup puydïnincuna ima mana allintapis ashiycälila Jesus wañuchisha cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jinaman juc nunacuna tumpacuyalcaptinpis manam imactapis talipäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Chaypïtam ishcay nuna ćhaycamul: “Cay nunam nin ‘Diospa chuya wasinta tunilcul quimsa muyunllactam śhalcächimümanpis’ nil limañä canpis” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chaylämi puydï sasirdütica śhalcuculcul Jesusta: “¿Manachun limalinqui, caynu cäraycuyäśhuptiquipis?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Niptinpis Jesus'a manam imactapis limalilachu. Chaymi puydï sasirdütica: “Cawsä Diosninchicpa puntanćhu rasuncäta niycamay. ¿Amchun Diospa Caćhaśhan Chulin Salbacüca cayanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusñatacmi: “Aw, nishayquinümi. Jinamanmi Sumä Munayniyu Diosninchicpa munayninwan mandayätapis, chaynütac janay pachäpi pucutaypa ćhawpinćhu Rasun Nunap Chulinca śhayämütapis licapämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Niptinmi puydï sasirdütip śhun'un sumä-sumä timpucuyaptin müdananta laćhyacuyan: “¡Cay nishancäwan Diosninchictam jalutacuyan! ¿Ima mastañam pï niycamänanchictapis munaśhun? Uyaliyalcanquiñamari quiquin shiminwan jalutacuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Imanipäcunquimá?” nil. Paycunañatacmi: “Aw, juchayümi. Wañuchisha cachun” nil nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chayćhümi cärancunaman tuwapapäcula, tacaypa camacapäcula. Waquinnincunañatacmi burlapaśhtin cäraćhü-cama lapyapäcula: ");
INSERT INTO qvwNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Chayurá Salbacü, má, niycälimay, mayannïshi tacapäcuñac” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chaynu lluy pasayaptinmi Pedroñatac chay patyullaćhu täcuyaptin juc uyway walmi aśhuycul: “Galilea-lädu Jesuswan pulï-ari ampis cayanqui ¿aw?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Niptinmi lluypa puntanćhu: “¿Mayanpïćha limacunquipis?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nilculmi puncu-läduman liyaptin juc walmipis licalcul lluyta nicuyan: “Caypis Nazaret-lädu Jesuswan pulï-ari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chayćhüpis yapam: “¡Dios'a yaćhayanmi chay nunäta mana lisishäta!” nil nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chay unascapïtá waquincuna Pedroman aśhuycul: “Am'a rasunpa jucnin puliwshï-masinćha canqui. Galilea nunäpanüllam limacuyniquipis cañä” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Niptinmi Pedro janay pachätapis ñaćhaña ishpicuyan: “¡Manam chay nunacta lisïchu! ¿Pićh cacunpis?” nil. Chaynu niyällaptinmi wallpa wa'amun. ");
INSERT INTO qvwNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chayćhümi Pedro yalpälun Jesus: “Quimsa cutictañam ipanchämanqui wallpa wa'amunanpá” nil nishanta. Chaymi chaypi yalulcul llaqui-llaquicta wa'acuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chay wälam llapa puydï sasirdüticunawan, prinsipal yaśhacuna limanacälälin Jesusta imanuypa wañuchipäcunanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chayćhümi maquinta ćhänaycul puśhapäcula Roma nasyunta mandawshï Poncio Pilatop maquinman ćhulaycamü. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ñatac ipanchä Judas, Jesus wañuchisha cananpä yaćhälulmi śhun'unpis cuchillu tucsïshanüña cacuyan. Chaymi quimsa ćhunca illay ćhasquishancätapis prinsipal yaśhacunaman, puydï sasirdüticunaman cutiycachila: ");
INSERT INTO qvwNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Mana juchayu nunacta chalaycachishäwan juchactam lulälú” nil. Niptinmi “Chay'a ¿imam ucalcäman ya'acunactá? Am chayta licacuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Niptinmi Diospa chuya wasinpa lulïninman illaycäta chapiycul pasacun cuncapi walcaculcul si'icäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chayćhu puydï sasirdüticunam chay illaycäta pallalcälila: “Camachicuyca manañam cunsintimanchicchu yawar jićhachiypa illaynin Diospa wasinpa caycunanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chaymi limanaculcul “Wacuy luläcäpa” nishan ćhacläta chay illaywan lantïlälila pulicücunaca pampaculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chaymi chay ćhacla canancamapis “Yawar Ćhacla” nisha. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Caynu lluy lulacacüla Diospa unay willacünin Jeremias: “Israelcunäpi quimsa ćhunca illayman payta ćhaninchaycuśhanwanmi ");
INSERT INTO qvwNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","‘wacuy luläcäpa ćhaclan’ nishanta lantïlälin, quiquin Dios nimäśhanmannuy” nil nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ñatac Jesusta chay mandä Pilatoman ćhächiptinmi: “¿Chayurá amlächun Israelcunäpa sumä mandänincälä cacuyanquimanpis?” nin. Niptinmi: “Anmá niyanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chayćhu puydï sasirdüticuna, prinsipal yaśhacuna Jesusta juchachäcuyalcaptinpis, pay'a manam imallactapis limalilachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chaymi Pilato: “¿Manachun caynu juchachaycälishuśhayquita uyalinqui, imamá?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Niptinpis manam imallactapis limalilachu. Chaymi Pilatopis licapayllaman camälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ñatac watan-watan cay fistaćhu'a wićhaläcäpi nunacunaca jucnin aclaycuśhancätam mandäca caćhaycunan cala. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ñatac chayćhümi wićhalayäla sumä lisisha lisisha Barrabas nuna. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaymi nunacunaca juntunacälälimuptin Pilato tapula: “¿Mayannintatá caćhaycüśhä? ¿Barrabastachun icha ‘Salbacüca’ nipäcuśhan Jesustachun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chay Pilato tantiälañamari yan'al ćhïnicuypïta maquinman ćhulaycamuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jinaman'a chay cäraycunanćhu täcuyaptinmi walminpis jucwan willaycachimun: “Chay allin nunawan ama miticuychu. Cay tutam paypa janan juyucunacta suyñülüpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ñatac chay puydï sasirdüticunawanmi, prinsipal yaśhacuna chayćhu lluy cäcunäta awnïlächin Barrabas caćhaycuśha cananpä, Jesusñatac wañuchisha cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatoñatacmi yapa tapun: “¿Ishcayninpïta mayannintatan caćhaycüśhä?” nil. Niptinmi yapañatac: “¡Barrabasta!” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chayćhu Pilato: “Chayurá ¿imanäśhätan ‘Salbacüca’ nishan Jesuswan'a?” nin. Niptinmi lluypis: “¡Chacatäluy!” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Niptinmi Pilato: “¿Ima juchactatan cay lulälun?” nin. Niptinpis mas mastalämi jicutäcuyalcan: “¡Chacatäluy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chaynu imaniptinpis mas-masta jicutäcuyalcaptinmi yacucta apalcachimul llapanpa ñawquinćhu: “Cay nunap wañuyninpi amcunaćh imanuypis caculcanqui; manam ya'a anlatacüchu” nil maquinta pa'acülun. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Niptinmi llapa nunacunaca: “Aw, ya'acunam llapa chulintin imanuypis caculcäśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaymi Pilato Barrabasta caćhaycächila; Jesustañatacmi ichá asutiwan camacaycachil ćhulaycula chacatäśha cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jinaptinmi cachacucunaca cuartilman puśhäluptin chayćhu llapan cunćhacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chayćhümi Jesuspa müdananta lluy uśhtilcul jatun yana-nilä puca catacunwan ćhulälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jinalculmi caśhapi curunacta lulalcälil umanman ćhulapäcula. Allï maquinmanpis bäractalämi chalälächinpis. Jinacalcälilmi puntanman un'ulacaycälil burlapapäcula: “¡Wiñaypä cawsachun Israelcunap mandacünin!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chaynütacmi tuwapapäculapis, chay quiquin bärawantacmi umaćhü-cama wipyapäculapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chay lluy imaymanacta burlacalcälilmi chay catacunta lluśhtilcälil caśhan müdananwan müdachipäcula. Jinalcälilmi waśhamanña julapämula chacatä puśhapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chaynu yalacayächilmi tincülälin Cirene malcapi Simon nishan nunawan. Paytam munäta mana munäta Jesuspa curuśhninta śhawachipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chay Golgota nishanman ćhälulmi (Golgota ninan'a “uma tullu canan” ninanmi) ");
INSERT INTO qvwNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","bïnucta jayapnin-yupaywan tallüśhacta uycälälin. Ñatac Jesus mallilcul manam upyayta munalachu. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ñä chacatäśha cayaptinmi cachacucunaca chüsanaculcäla Jesuspa müdananta aypunaculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jinalculmi taycacaycälila täpapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Chay curuśhninpa umanmanñatacmi ćhuläla imapi wañuchisha caśhantapis cay niyäta: “Cay Jesusmi Israelcunäpa Mandäninca” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jinamanmi wicninman cayninman ishcay suwacunacta chacatälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chayninpa pasäcunäpis ñuquicaćhaśhtinlämi: ");
INSERT INTO qvwNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Am Diospa wasintapis tunilcul quimsa muyunllacta śhalcachïca cacuyal'a, quiquiquitari má salbacuy. Rasunpa Diospa Chulin cal'a má chaypi ji'alpamuy-ari” nil burlapapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chaynütacmi puydï sasirdüticunäpis, camachicuyta yaćhachicücunäpis, fariseocunäpis, prinsipal yaśhacunäpis burlapapäcula: ");
INSERT INTO qvwNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Juccunactá salbätucul-ari, canan maytá quiquin atipanchu. Rasunpa Israel malcanchicpa mandäninchic-ari, má, ji'alpamuchun-ari quirinanchicpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‘Diosman chalapacümi’ nin-ari; má canan-ari salbaycuchun rasunpa chalapacuptin'a. ¿Manachun ‘Diospa Chulinmi cá’ nil-ari niyämanchicpis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chaynütacmi lädunćhu chacatäśha suwacunäpis ruydupapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ñatac jinantin pachaca ćhawpi muyunpi aśhta tardi mishquipay üracama lluy tutapälun. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chay ürallatacmi sumä callpawan Jesus: “¡Elí, Elí, lama sabactani!” nila. (Cay ninan'a “Dioslláy, Dioslláy ¿imapïmi caćhaycamanqui?” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chay uyalïcunämi waquinnin'a nipäcula: “Diospa unay willacünin Eliastaćh ayayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chayürallatacmi waquinnin pasacun millwacta wilu caśhpiman wataycul ćhacćhä bïnuwan chapuycamul śhu'uycachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waquinnincunañatacmi: “Jina cachun. Má, Elias śhamun'achuśh salbaycunanpä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chayćhu Jesus callpa-callpawan yapa apalcaćhalculmi pasacalpula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pasacalpullaptinmi Diospa chuya wasinćhu sumä chuya cäcäpa lacta-lacta curtïnan quiquin ćhawpipi laćhyälun. Jinantin pachäpis śhaśhälunmi, wancacunapis wäćhälunmi. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nïchucunäpis lluymi quićhacacülun; Diospa wañüśha willacünincunapis achcam śhalcatityämun. ( ");
INSERT INTO qvwNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chay Jesuspa śhalcamuśhanpa ipanta Jerusalenman yaycapäcuptinmi achca-achca nunacuna licaycälila.) ");
INSERT INTO qvwNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ñatac Jesusta täpäcunäwan puydïnin lluy pachacuycunawan ima pasaśhantapis licapäculmi sumä-sumä manchalicälälisha: “Rasunpamá Diospa Chulin pay'a cañä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ñatac Jesusta Galileapi yanapaśhtin puliwshïnin walmicunäpis calullapïmi licapapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paycunaćhu cayalcäla: Magdala malcapi Maria, Jacobopwan Josëpa maman Mariapis, Zebedeocunäpa mamanpis. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ñä aspicalpuyaptinñam Arimatea-lädupi sumä cäniyu José nishan ćhämun. Paypis Jesuspa atïninmi cala. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Paymi Pilatoman mañacamü lila “Taytay, cay ayäta pampalpamulläśhä” nil. Chayćhu Pilato awnilcuptinmi ");
INSERT INTO qvwNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","sumä ćhaniyu lïnu nishan puchcapi lulaśhan chuya säbanawan ayäta pitwilcul ");
INSERT INTO qvwNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","quiquinpa a'aćhu ućhcuchishan muśhü maćhayman chutaycula. Chaypïtam jatun palta uylu lumicta cućhpaycachil wićhaycachila. Jinalculmi licula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ñatac Magdalapi Mariawan juc Mariam ichá chay maćhaypa chimpallanćhu täcapayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chay walantin, warda muyuncäćhu, puydï sasirdüticunäwan fariseocunämi Pilatoman lipäcula: ");
INSERT INTO qvwNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Taytay, cay artishca cawsayal-lämi ‘Quimsa muyunpïtam śhalcamuśhä’ nishanta yalpayanchic. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chaymi sumäta täpachimunayqui chay quimsa muyunca. Yan'al-lätac yaćhapacünincuna tutap chincalcachil, nunacunäta ‘Śhalcämunmi’ nil niyalcä imanman. Chaynu captin'a punta artinpïpis sumä piyurninlä cay cälunman” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Niptinmi Pilato: “Allinmi. Cachacucunäwan-ari lipäcuy. Callpayquiman tincüta sumäta wićhaycälimul, täpaycälimuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chaypïmi lilcälil la'ay-la'aypa wićhaycälil lluy unanchälälin. Jinalculmi chay cachacucunäta täpapäcunanpä caćhaycälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chay warda muyun pasäluptinmi, simänap allaycuynin muyun wälalla Magdalapi Mariawan juc Mariaca pampaläśhancäman lipäcula licaycamü. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","3","Chayćhu cayalcaptinmi Diosninchicpi juc anjil janay pachäpi ji'alpalcamul chay wićhaläśhan lumïta quićhaycüluptin cay pachäpis sumä śhaśhälun. Walmicunäñatacmi chay lumïćhu täcuyäta licälälin sumä räyunu chipyayäta müdananpis sumä laśhta-yupay yulä-yulä cayäta. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chayta licälulmi täpä cachacucunäpis sumä chucchucuyalcal wañuśha-yupay cućhpälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Walmicunätañatacmi anjilca: “Ama manchacalcämaychu. Chacatäśha Jesusta ashiyalcäśhayquita yaćhayämi. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pay'a manañam cayćhüñachu. Nipäcuśhuśhayquinümá śhalcämuśhaña. Chutaläśhancäman-ari licaycü śhapämuy. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Canan yaćhapacünincunaman wayra lil: ‘¡Śhalcamuñämi! Tincuycälimunayquipämi Galileacta amcunapïpis puntacta lin'a’ ninqui. Caytam niycälinac cala” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chaynu niptinmi manchapacüśha cayalpis, cushicüśhatac walmicunaca pasaculcan yaćhapacünincunacta willaycamü. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chaynu liyällaptinlämi Jesus: “¿Imanuyllam cayalcanqui mamacuna?” nil limaycun. Niptinmi walmicunaca ćhaquinta macallacaycälil alawapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Payñatacmi: “Ama manchaculcaychu. Cuyaśhá yaćhapacünïcunacta willaycälimuy Galileaman śhapämul licaycälimänanpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chay walmicunaca liyalcällaptinlämi, waquinnin täpä cachacucunaca malcaman cutiycul puydï sasirdüticunacta willaycälin lluy ima pasaśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaymi sasirdüticunaca prinsipal yaśhacunäman lila imacta lulapäcunanpäpis limanacamü. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Chayćhümi chay täpä cachacucunäta alli-alli illayta uycälälin: “ ‘Tutap puñuyalcaptïmi yaćhapacünincuna śhalcamul suwälälimäñä’ nilmi nipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ñatac mandacüca tantiäluptin'a ya'acunam imanuypapis awnichipäcuśhä mana imallactapis niycälishunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niptinmi cachacucunaca illaycäta ćhasquiycälil, yaćhachishantanülla nipäcula. Ñatac cay casqui limaymi jinantin Israelcunäćhu canancamapis muyuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chaymi ćhunca jucniyu yaćhapacünincuna Galileaćhu cä ulüman lipäcula Jesus nishannülla. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chayćhu payta licälälilmi alawapäcula; waquinnincunañatacmi ishcayyäśha cayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Paycunaman aśhuyculmi Jesus nila: “Tayta Diosmi maquïman ćhulaycamun cay pachäćhu janay pachäćhu ima cäcunätapis. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Canan jinantin pachäćhu cä malcacunäman lil lluypis yaćhapacünïcuna capäcunanpä caminaycälimuy. Jinalcul bawtisaycäliy Tayta Diospa, Chulinpa, Chuya Ispiritup pudirnin cayniquiwan. ");
INSERT INTO qvwNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jinaman'a lluy yaćhaycälichishacta amcunapis yaćhaycälichiy cäsuculcänanpä. Ya'añatacmi ichá imaycamapis walan-walan amcunawan caycuśhä cay pacha camacänancama” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tayta Diospa Chulin Salbacüninchic Jesuspa allin willacuyninpa allaycuynin caynümi. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Diospa unay willacünin Isaias isquirbishanćhümi niñä: “Ampa ñawpäniquitam juc willacünïta caćhamüśhä, ćhänayquipä alistamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chunyäninćhu ayaycaćhäcäta uyalipäcuy: ‘Taytanchic ćhämunanpä sumäta allichaculcay. Ñatac paypa pulinanta tuquicta lulapäcuy’ ” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Cay nishancänümi chunyänincunaćhu Bawtisä Juan licalilcamul llapan nunäta: “Juchayquicunapi wanacul bawtisaculcay pampachäśha capäcunayquipä” nil willacula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chaymi Jerusalenpïta Judeap intirun malcancunapïtapis nunacunaca śhapämula uyalipäcunanpä. Chayćhu juchancunacta lluy willapacücunätam chay Jordan mayućhu bawtisala. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Paymi camïllu uywap millwanpïta luläśha müdanawan müdacula; utapi luläśha waćhacuwanmi ćhulaculapis. Langusta culucunallacta urunwaycunap mishquincunallactam miculapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Paymi willacula: “Ya'ap ipäta śhamücämi ya'apïtapis mas munayniyüca cayan. Ya'a manam bälïchu nï camächu śhucuyninpa watullanta pasquiycunalläpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya'a bawtisapäcuc yacullawanmi. Chay śhamücämi ichá Chuya Ispirituwan bawtisapäcuśhunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay muyuncunam Galileaćhu cä Nazaret malcanpïta Jesus śhamula Juan bawtisaśhan Jordan mayüćhu bawtisachicunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chay bawtisachiculcul yacüpi yalayämulmi licäla janay pachaca quićhacacüluptin Diospa Chuya Ispiritun palumanuy paypa janäninman ji'alpayämüta. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Janay pachäpïtatacmi nilpämula: “¡Maynu cushisham cayá ampïta, cuyay chulí!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chayürallam Diospa Ispiritun chunyäninman Jesusta puśhala. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chay tawa ćhunca muyuncunaćhümi Jesusta Satanaśh juchacta lulachiyta jicutäla. Anjilcunañatacmi Jesusta yanapäla. Chayćhütacmi chucaru uywacunapis cala. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ñatac Bawtisä Juanta carsilman wićhälächiptinmi, Jesus lila Galilea-läducta Diospa allin willacuyninpi willacuśhtin: ");
INSERT INTO qvwNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“¡Diospa gubirnun janayquićhüñam cayan! ¡Cay allin willacuyman chalapacul juchayquicunapi wanaculcayñari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chay Galilea ućhap manyanpa liyalmi Jesus licälun wawi-caśha Simontawan Andresta, challwa chalä-cama capäcul chalacunwan challwacta chalalcäta. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chayćhümi nila: “Acuchun ya'awan lishun. Cananpïtá yaćhachishayqui cay challwa juntupäcuśhayquinu nunacunäta Diospä juntupämunayquipämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nilcuptin-pachallam challwa chalacuncunactapis caćhaycul Jesuswan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chaypi wicniscanćhütacmi Zebedeop chulin Jacoboctawan Juanta barcunćhu challwa chalacunta allichayalcäta licälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Chayćhu licälul-pacha ayäluptinmari taytan Zebedeocta mincaynincunactawan barcunćhu caćhaycul Jesuswan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaypïtam Capernaum malcaman ćhälälila. Warda muyun ćhämuptinñatacmi yaćhachinanpä juntunaculcänan wasiman Jesus yaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Uyalï nunacunäñatacmi sumä licapayllaman camälälil: “Sumä pudirwanmá pay'a yaćhachin; manam camachicuycäta yaćhachicücunanüllachu” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chayćhu Satanaśhpa gänaśha juc nunäñatacmi apalcaćhaypa nicuyan: ");
INSERT INTO qvwNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¡Nazaret malcayu, Jesus! ¿Imactatá ya'acunawan munacuyanqui? ¿Mana cäman muyuchipämänayquipächun śhamulanqui, imatá? Yaćhämari Diospi Śhamü Chuyaca caśhayquita” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nicuyaptinmi Jesus piñapäla: “¡Cay nunäpi upälla liculcay!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Niptinmi achatuca chay nunäta chucchulcachil apalcaćhaśhtin yalülun. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chayćhümi lluy nunapis licapänacuyllaman camäśha ninaculcäla: “¡Imatan cay'a! ¡Juc licchä yaćhachicuymá! ¡Maynu sumä munayniyu nunatan, achatupis cäsucul licunanpä!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cay lulaśhancunactamari jinantin Galileap malcancunaćhüpis lluy yaćhatityälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Juntunaculcänan wasipïta yalälälimul-pacham Simonpa Andrespa wasinta Jesus lipäcula Juanwan, Jacobowan. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ćhäläliptinmi willaycälila Simonpa suyran calur ishyaywan cämanćhu ishyaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jinaptinmi ishyäcäman Jesus aśhuycul maquinpi śhalcalcachiptin chay calur ishyaynin juclla chincacula. Jinaptin-pachallam walmica paycunacta atindiycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aspicalpuyaptinñatacmi Jesusman puśhapämula imaymanawan ishyänincunacta, chaynütac Satanaśhpa gänaśhacunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jinalmi wasi puncunman jinantin nunacuna-yupayña nisyu-nisyu juntunacälälimula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chayćhümi Jesus lluy sänachila imaymanawan ishyä nunacunätapis, Satanaśhpa gänaśhacunätapis chay maquinpi caćhaycachila. Chayćhu achatucunaca mayan caśhantapis lisiptinmi, Jesus mićhacula paypi limalcunanta. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chay wälam Jesus tutay-tutaylla śhalcuculcul Dioswan limananpä chay wasipïta chunyäninman licula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jinaptinmi Simon puliwshï-masincunawan cusca ashipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Chayćhu talïlälilmi nipäcula: “Llapan nunacunam ashiyalcäśhunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nipäcuptinmi Jesus nila: “Acuchun. Juc malcacunaman lishun; paycunactapis Diospa willacuyninta willanäpämari śhamulá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chaymi jinantin Galilea-lädućhu pulila juntunacuna wasicunaćhu yaćhachishtin ishyäcunactapis achatucunap maquinpi caćhaycachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Chaypi lipra ishyaypa camacäśha juc nuna Jesusman ćhaycamulmi ñawpäninman un'ulacuycul ruygacula: “Taytáy munal'a allinyaycachillämanquimanmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Niptinmi sumä llaquipaycul maquinwan yataycul nila: “Aw, allin chuya canayquitam muná” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chay nilcul yataycuptin-pachallam lipra ishyaynin lluy śhuśhüluptin sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chayćhümi Jesus ćhuncay-ćhuncayta nila: ");
INSERT INTO qvwNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Amam cay allinyachishacpi pictapis willapacunquichu. Aśhwanpa sasirdütiman lil, anradisicuypi apay Moises nimäśhanchicnuy, rasunpa cay ishyaypi allinyäśhayquita licaśhunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ñatac niyaptinpis, chaypi yalülul'a lluy tincuśhantapis willapacucuyälam Jesus lulaśhanpi. Chaynüpam intiru malcacunaman lluy miläla. Jinaptinmi Jesus manaña yaycuyta atipalañachu nunacunap ñawquin'a, sinu'a chunyäcunallaćhüñam cacula. Chaynu malcapi calućhu cayaptinpis lluy malcacunapïtam payman śhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Chay ishcay quimsa muyunpïtam Jesus yapañatac cutila Capernaum malcaman. Chayćhu ćhämuśha caśhanta yaćhälälilmi achca-achca juntunacämuptin puncuncunaćhüpis manaña jäculañachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pay willacuyaptinmi chayman ćhänacacüśha nunacta tawa wantucuśha chacanawan apapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chaynu manaña maypapis yaycunanpä captinmari, chay wasi altunman ishpilcul, Jesus caśhan chayniscacta alipäcula. Jinalculmi Jesuspa ñawpäninman chay nunäta chacanantinta watuwan caćhalpapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chay chalapacuynincunacta Jesus yaćhalmi, chay ishyäcäta nila: “Walaśh, juchayqui lluy pampachäśhañam” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Chay nishanta uyalïlälilmi chayćhu Moisespa camachicuyninta yaćhachicü täcücunaca śhun'ullanćhu nipäcula: “¡Wá! ¡Imanuypatan cay nunaca chaynüta limanman! ¡Diostamá jalutacuyan! ¡Diosllamá nunacunap juchanta pampachäcá!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chaynu pinsapäcuśhanta Jesus śhun'unćhu yaćhalmi nila: “¿Imapïtamá caynu pinsapäcunqui? ");
INSERT INTO qvwNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Imaniytan mas fäsil: ‘Juchayquicunacta pampachaycucñam’ nïchun icha ‘Śhalcuculcul, puñunayquita apaculcul licuyña’ nïchun? ");
INSERT INTO qvwNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cananmi yaćhanqui cay Rasun Nunap Chulincá, cay pachäćhu juchacunacta pampachänäpä munayniyu caśhäta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nilculmi chay ishyä nunäta: “Canan ¡śhalcuy-ari! Wantumuśhuśhayquita apaculcul wasiquita licuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nillaptinmi chay nunaca śhalcuculcul wantumuśhanta apaculcul lluy nunacunap ñawpäninpi yalumula. Chaymi paycuna licapayllaman camäśha Tayta Diosta alawayta allacaycälin: “¡Caytanu'a manamá imaypis licalanchicchu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaypïtam Jesus yapañatac chay Galilea ućhap manyanman cutila. Chayman nisyu-nisyu nunacuna juntunacämuptinmi Jesus yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaypi pasayäśhanćhümi licälun Alfeop chulin Leví śhutiyu nuna Roma gubirnupä alcabälacta mañanancäćhu täcuyäta. Chaymi Jesus: “Acuchun ya'awan, atimay” nin. Niptin-pachallam śhalcuculcul paywan licula. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chay Levïpa wasinćhu Jesus yaćhapacünincunawan micuyalcaptinmi alcabäla mañäcücunäwan, mana allin cawsayniyu nunacunäpis ćhaycamul paycunawan taycacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chaynu nunacunawan cusca micuyalcäta licälulmi fariseo caśhtacunäwan Moisespa camachicuyninta yaćhachicücunaca Jesuspa yaćhapacünincunacta jamuyapäcula: “¡¿Ima-nilä nunatan yaćhachicüniqui wic-nilä nunacunawanlä micunanpä?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chay nishanta uyalïlulmi Jesus nila: “Sänu nunacunacá manam jampicüta munanchu, sinu'a ishyäcunallam. Ya'a manam śhamulá santutucücunacta ayächu, sinu'a jucha-sapacunätam” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutićhümi fariseocunäpa, Bawtisä Juanpa puliwshï-masincuna ayunayalcäla. Chayta licalmi Jesusman aśhuycul nila: “¿Imanaltan Bawtisä Juanpa puliwshïnincunapis, fariseop atïnincunapis ayunapäcun, ampa atïniquicuná mana imactapis uculcanchu isisí?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Niptinmi Jesus nin: “¿Casaracüca cayaptin'a ayachishacunaca ayunapäcunmanchun ampá? Manaćhá jinapäcunmanchu paycunawanlä cayaptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ñatac chay casaracüca waycaśha canan timpu ćhämun'am. Jinaptinmi ichá ayunapäcun'a. Chaynümari yaćhapacünïcunawanpis can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Manatacmi mayanpis mawca müdanaman muśhü lataśhta la'anmanchu. Jinaptin'a chay muśhü lataśhcäćha aśhwanpa shipulcachil masta laćhyächinman. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chaynütacmi chayllalä luläśha aswactapis nï winanchicchu läläśha mawca wacuyman'a. Chaynu lulal'a aswäćha wacuycäta paquïchinman; jinaptinćha lluy aswapis wacuypis yan'al pampapä canman. Chaymi chayllalä luläśha aswactá muśhü allin wacuyman winanchic” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juc warda muyunćhümi Jesus yaćhapacünincunawan pasayalcäla trïgu-trïgup manyanpa. Chay yaćhapacünincunañatacmi pallalcälila micalcälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chayta licälälilmi fariseocunaca Jesusta nipäcula: “Licay-ari. ¡¿Imapïtatá warda muyunćhu camachicuy mana pirmitishanta yaćhapacüniquicunañatac lulayalcan?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nipäcuptinmi Jesusñatac: “¿Manachun lïgipäculanqui David micanäśha pishipacüśha cayal puliwshï-masincunawan imacta lulapäcuśhantapis? ");
INSERT INTO qvwNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar sumä puydï sasirdüti cayaptin ¿manachun alawana carpanman yaycuycul Diospä japächäśhan tantäta, sasirdüticunälla micunanpä cä tantätalä David micüla? Jinaman ¿manachun puliwshï-masincunactapis uycuñälä canpis? ");
INSERT INTO qvwNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Warda muyunca manamari camaśha cala nunacunäta maquinćhu cachinanpächu, sinu'a nunacunäpa maquinćhu cananpämi. ");
INSERT INTO qvwNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chayurá ya'a Rasun Nunap maquilläćhümi cay warda muyuncäpis cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesusmi yapañatac juntunaculcänan wasiman yaycula. Chayćhümi mana cuyulï chaquïsha maquiyu nuna cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseocunäñatacmi imallawanpis tumpapäcunanpä Jesusta awaytapäcula: “Má, canan warda muyuncäćhu sänachin'achuśh” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chayćhümi chay mana cuyulï maquiyu nunäta Jesus: “¡Śhalcuy, cay ñawpäman pasaycamuy!” nil pasaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jinalculmi chayćhu nunacunäta: “¿Cay warda muyunca allincätachun icha mana allincätachun lulachimanchic? ¿Cawsayninta salbaycachimanchicchun icha wañulpachimanchicchun?” nin. Ñatac paycuná mana limalil upällallam cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chaynu chay nunäpi imactapis mana uculcäśhanpïmi Jesus piñäśha llaquïsha licapaycula. Jinamanmi chay nunäta: “Chacchapacuy” nila. Chaynu chacchapacüluptinmi sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jinaptinmi chay fariseocuna yalälälimul, Jesusta imanuypa wañuchipäcunanpäpis mandacü Herodes partipi śhalcünincunawan limanacuyta allaycaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesusmi yaćhapacünincunawan ućhap manyanman aśhuculcäla. Jinaptinpis Galilea-lädupïta achca-achcam atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Maynu sumäcunacta lulaśhanta uyalipäculmari Judea-lädupïtapis, Jerusalenpïtapis, Idumea-lädupïtapis, Jordan mayup chimpancunapïtapis, Tirowan Sidonpa lluy muyülïnincunapïtapis payman śhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Chayćhu achca ishyäcunacta lluy sänachiptinmi, juc ishyäcunapis Jesuspa müdanallantapis yataycälinanpä ñiti-ñiti aśhuycälimula. Jinaptinmi yaćhapacünincunacta nila: “Büticta alistapamay chaypi yaćhachinäpä. Caynüpa nunacunacá lluyćha ñitïmäśhun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jinaman'a Satanaśhpa gänaśha nunacunäćhu achatupis Jesusta licälulmi ñawpäninman un'ulacuycul ayaycaćhaypanuy: “Am'a Diospi śhamü Chulinmi canqui” nil nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Niptinmi chaycunacta Jesus ćhuncay-ćhuncay nila pï caśhantapis mana camalachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaynalculmi Jesus juc uluman ishpila. Chayman munaśhan nunäta ayalcachilmi ");
INSERT INTO qvwNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","aclala ćhunca ishcayniyu nunacta: “Puydï caćhaśhäcunam capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Satanaśhcunap maquinpi pudirwan caćhaycachipäcul willaculcänayquipämi caćhapäcuc” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay ćhunca ishcayninmi caycuna: “Pedro” nishan Simon. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Chaynütac Zebedeop chulincuna Jacobowan, Juan. Paycunactam Boanerges niycula. (Cay ninan'a “Räyup jiniyunnuy jiniyuyu nunacuna” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chaynütac Andres, Felipe, Bartolomé, Mateo, Tomas, Alfeop chulin Jacobo, Tadeo, malcanpi śhalcü Simonpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Chaynütacmi wañuchipäcunanpä chalaycachïca Judas Iscariotipis. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaypïtam Jesus yaćhapacünincunawan liculcäla juc wasiman. Chayman achca-achca nunacuna juntunacälälimuptinmi manaña micapäculañapischu. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jinaśhanta yaćhälälilmi aylluncuna “¿Lücülunchun imam?” nil Jesusman yalacalcämula puśhapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ñatac Jerusalenpïta ćhäpämü Moisespa camachicuyninta yaćhachicücunämi Jesusta jamuyapäcula: “¡Cay'a quiquin achatucunap mandä Beelzebüpa maquinćhümari cayan! ¡Chay puydïllanpa munayllanwanmá aluyta jicutayan!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Niptinmi Jesus ayalcul tincuchiypa limapäla: “¡¿Imanuypatá Satanaśhca quiquin Satanaśhta alucunman?! ");
INSERT INTO qvwNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Juc nasyunćhu quiquin-pula pilyapäcul'a lluyćha chincachinacunman. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chaynütacćha juc wasillaćhu pilyapäculpis pampaman muyuchinacunman. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","¿Chaychun ampá Satanaśhpis quiquin-pula cuntra cayal laquinacüśha cayal tacyaycunmanlä canpis? Aśhwanpa quiquillanćhá camacacunman. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Má, sumä armädu nunacta manalä puntacta ćhänal'a manamari pipis waycayta atipanmanchu. Payta ćhänälulćha ichá lluy imallantapis apacunman. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Uyalipämay: Tayta Diosmi pampachanman llapa nunap ima jucha lulaśhantapis ima limaywan jalutacuśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ñatac Diospa lulaynincunacta ‘Satanaśhpam chay'a’ nil Chuya Ispiritucta jalutacücätam ichá nï imaypis pampachan'achu. Jinaptinmi wiñay-wiñaypä juchan ipicuśha can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Caycunacta Jesus nila “Satanaśhpa maquinćhümi cayan” nipäcuptinmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chaynu Jesus niyällaptinmi mamanwan śhullcancuna ćhälälimun. Chayćhümi waśhallapïta Jesusta ayachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jinaptinmi muyülïninćhu täcücunaca: “Mamayquiwan śhullcayquicunam ashiyalcäśhunqui” nil willaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Niptinmi: “¿Mayantan ya'ap mamá? ¿Pïcunatan ya'ap śhullcäcuna?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nilcul muyülïninćhu täcücunäta licalculmi nila: “Paycunamá mamäpis śhullcäcunapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mayanpis janay pachäćhu Taytäpa munaśhanta luläcunämari, mamäpis, śhullcäpis, panïcunäpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chay ućhap manyanćhümi yapañatac Jesus yaćhachila. Chayman achca-achca nunacuna juntunacälälimuptinmi, chayćhu barcuman ishpilcul taycucuycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nunacunañatacmi ućhap manyallanćhu capäcuptin achcacta tincuchiypa yaćhachila cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sumäta uyaliy. Juc nunash talpucü liñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wacaptinshi waquinnin mujucunaca caminucunäman paćhcälun. Jinaptinshi pishucuna śhalcamul lluy pallälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquin mujucunañatacshi pasaypi ćhäla-ćhälaman paćhcälun. Chaynu janällaćhu calshi apuraypa wiñätucämun. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Inti allicta lupämuptinñatacshi ichá lluy chaquïlälin, sapichacunanpä undu allpa mana captin. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin mujucunañatacshi ula-ula, caśha-caśhacunäman paćhcälälin. Chay caśhacuna wiñalcamul lluy alwächiptinshi nï wayulachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Juc mujucunañatacshi allin jundu allpaman ćhäpäcun. Chaycunash ichá allicta wayupäcun. Jucllay mujullapïshi quimsa ćhunca-cama, süta ćhunca-cama, paćhac wayuyniyü-camalä capäcun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nilculmi lluy nunacunäta: “¡Linliyu cal'a, uyaliculcay-ari!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chayćhu Jesusllaña cayaptinmi, yaćhapacünincunawan juc nunacunallaña tapupäcula tincuchiycunap imacta yaćhachishantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chaymi Jesus nila: “Amcunactá Tayta Diosmi tantiaycachipäcuśhunqui gubirnunćhu pacacuynincunactapis. Ñatac juccunätá caynu tincuchiyllaplämi yaćhaycachiná. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chaymi Diospa shiminćhu niyan: ‘Maynüpa licayalcalpis manam tantiapäcunchu; maynüpa uyaliyalcalpis manam intindipäcunchu; wanaculcaptin'a juchancunam pampachäśha cälunman’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nilculmi llapanta nila: “Cay tincuchiypa yaćhachishäta mana tantiayalcal'a, ¿imanuypaćh tantiapäcunquiman juc tincuchiycunactapis? ");
INSERT INTO qvwNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chay muju wacäca Diospa allin willacuyninta willacücämi. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Chay caminucunäman paćhcä mujucunanümi waquin nunacunap śhun'unman Diospa willacuynin ćhäpäcun. Uyalïläliptin-pacham Satanaśh śhalcamul waycalpülun. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Chaynütacmi chay ćhäla-ćhälaman ćhäcänuy waquin nunacunaman ćhäpäcun. Paycunam rätucamallá Diospa allin willacuyninta cushisha ćhasquipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Chaynu ćhasquishan-laycu imaymana ñacaycunapis, llaquicuycunapis licalimuptinmi mana sapichacüśha lanta-yupaypis manaña mastá tacyaycälil chaycunaman rätulla palpülun. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Waquin nunacunamanñatacmi chay caśha-caśhaman muju paćhcäcänuy Diospa willacuynin ćhäpäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ñatac cay pachäćhu illaycunäwan, cänincunallawan, cawsaycäćhu lluy munayllancunawan shipuchicüluptinmi mana wayuynin canchu. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ñatac jundu allin allpaman ćhäcänuy capäcun allin willacuyta uyalicul cäsucücunämi. Chaymi allincunällacta wayuycun jucllay mujullapi quimsa ćhunca, süta ćhunca, paćhac wayuyniyü-camalä canpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nilculmi nilatac: “¿Acchicta walaycachinchic mancawan pacaycunapächun ütac cawitup lulinman ćhulaycunapächun, imatá? ¿Manachun altu ćhulacunman ćhulaycunchic lluyta acchimunanpä? ");
INSERT INTO qvwNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ima pacaläcäpis camalaycun'amari. Pacäśhacunaca lluymi licaycachisha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Linliyu cal'a cayta uyaliculcay-ari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nilatacmi: “Uyalipäcuśhayquiman sumäta uyalipäcuy, cäsuculcay. Chay uyaliycälishayquiman tincüta mastalämi canpis tantiaycälichishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tantiäcunätá mas tantiayta uśhalämi can'apis. Mana tantiäcunätam ichá aśhwanpalä chincalpachisha can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Cay nilculmi yapañatac Jesus nila: “Diospa gubirnun juc nuna allpaman muju wacaśhancänümi cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pay mana yaćhaśhancamam masqui licchayaptinpis puñuyaptinpis tutay-walächi pasalcamul mujuca wiñayämun. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Allpaca quiquillanpïmi wayuchimun: puntallactá wiñamunmi, jinaman'a ispijämunmi, jinalcul'a lluy alwämunmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ñä alwäśha cayaptin'a cusicha timpu ćhämuptinñamari cüśhawan lutunchic” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Chaypïtam Jesus nila: “¿Imanuyćha Diospa gubirnun? ¿Imawanćha tincuycachichwan? ");
INSERT INTO qvwNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Shitap mujunnüllamari. Llapa muju talpuśhacunäpïtapis ñawi chincaycuy mujullamá. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wiñalcamulñatacmi ichá lluy ulacunapïpis mas jatunninlä. Chaymi pallaynincunaćhüpis pishucunapis yaćhapäcunlä canpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus chaynu tincuchiycunallapmi llapan nunacunäpa tantiayninmannülla yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Manam imaypis yaćhachilachu mana tincuchiypá. Yaćhapacünincunactam ichá lluyta japä tantialpachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay muyunca aspicalpuyaptinñam Jesus yaćhapacünincunacta: “Acuchun, cay ućhap chimpanman” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nilculmi lluy nunacunäta caćhaycul chay barcu caśhancäwan yaćhapacünincunawan liculcäla. Chayćhu juc barcucunapis lipäculatacmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chaypi lamarcäta ćhawpichaycuyalcaptinmi alli-alli waywa talcämula. Jinalmi chay yacüta nisyu-nisyuctaña ulunacalcachil barcuman winacächicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusñatacmi barcup isquinanćhu pishipäśha puñuyäla. Jinaptinmi yaćhapacünincuna licchachipäcula: “¡Yaćhachicü taytáy ¿manachun imapis ucuśhunqui wañuypa patanćhüña cacuyaptinchicpis?!” nilcul. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Niptinmi Jesus śhalcalcamul: “¡Waywa, yacu, śhaycuyña!” nïlun. Nillaptin-pacham tuqui-tuqui jawcayäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jinalculmi Jesus yaćhapacünincunacta nila: “¿Imapïtan caynüpaña manchalicucuyalcanqui? ¿Canancama manalächun ya'aman chalapacalcämanqui, imatá?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Niptinmi yaćhapacünincuna licapayllaman camäśha ninaculcäla: “¿Ima nunatan pay, waywäpis yacüpis cäsunanpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chaypi wic-lädu chimpa Gadara-lädumanmi chimpälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Chayćhu barcupïta Jesus bäjalpuyaptinmi achatup maquinćhu lücu nuna pantiuncäpi yalalcamul śhacayämun. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay nuna pantiuncunallaćhümi yaćhala. Manamá mayanpis chalayta atipapäculachu, nï cadinacunawanpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Achca cutish maquincunapïpis, ćhaquincunapïpis cadinacunawanpis watapäcula. Jinaptinpis uchuc-uchucllaman lluy laćhuy pawalculshi licula. Chaynu callpayu captinshi manaña mayanpis sujitayta atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chay nunash tutay-muyun ulucunallaćhu, pantiuncunällaćhu pulicula apalcaćhaśhtin. Yan'alshi quiquillan däñacula lumicunawan tacacuśhtin ima. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ñä Jesusta calupïtalä licalculmi cürri-cürriwan śhalcamul ñawpäninman un'ulacuycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Chayćhümi Jesus: “Cay nunäta caćhaycul licuy” nila. Niptinmi: “Jatun Munayniyu Diospi Śhamü Chulin Jesus, ¿imactatá ya'awan munacuyanqui? Dios-laycu ruygacuc, amaläri ñacachimaychu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Niptinmi: “¿Imam śhutiqui?” nin. Niptinmi: “Batallunmi, nisyu-nisyuña capäcuptïmari” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nilculmi ćhuncay-ćhuncay ruygaculcäla “¡Cay-lädupïta amalä alupämaylächu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chayćhütacmi ulup siquincascaćhu achca-achca cuchicuna lancalayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chaymi achatucunaca ruygacula Jesusta: “Wic cuchicunäman yaycapäcunäpä awniycälillämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Niptin awniycuptinmi cuchicunäman uśhtüla. Jinaptinmi chay ishcay walanganu cä cuchicunaca lücuyalcul ućhap patanman cürritityalcul lluy ji'acalpälil anuälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chaymi chay cuchi michïcunaca mana-mana pasaculcan malcäcama tincuśhancunäta ćhaclacunäćhu lluy nunacta willacuśhtin. Jinaptinmi nunacunaca śhapämula ima pasaśhantapis licä. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chay ćhäpäcunanpä achatup maquinćhu cacü nunaca Jesuspa lädunćhu, allin müdacuśha, sänu allin fisyunćhu täcuyaptinmi manchapacälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chayćhümi licäcunaca willapäcula, chay nunätawan cuchicunäta ima pasaśhancunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jinaptinmi nunacunaca Jesusta ruygacuyalcan chay malcapi licunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nipäcuptin Jesus barcuman ishpiyaptinmi chay sänaśha nunaca ruygacula: “Ya'actapis puśhacallämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusñatacmi mana awnilachu, sinu'a: “Wasiquita lil aylluyquicunacta aśhwanpa willapacamuy Tayta Diosniqui amta llaquipaycul amćhu lulaycuśhuśhayquipi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Niptin Decapolis-lädu lluy malcacunäćhu Jesus maynu maynu jatun lulaycunacta paywan lulaycuśhantapis willapacuptinmi lluy uyalïcunaca licapayllaman camapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaypïta Jesus yapa chimpäläliptinñatacmi achca-achca nunacuna juntunacälälimula chay ućhap manyanman. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chaymantacmi juntunaculcänan wasip puydïnin Jairo śhutiyu nuna ćhämun. Paymi Jesusta licälul puntanman un'ulacuycul alli-allicta ruygacücuyan: ");
INSERT INTO qvwNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Taytay, wamla chulillämi wañucalpuyanña. Acuchun-ari yataycuptiqui sänälul cawsalinanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Niptinmi Jesus paywan lila. Chaynu liyalcaptinmi alli-alli nunacuna ipanta ñiti-ñiti atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay nisyu-nisyu nunacunap ćhawpinćhüñatacmi ćhunca ishcayniyu wata yawarpa janallanćhu cä ishyä walmi liñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cay walmish sasa-sasa una-unayña juc-jucwan jampichicuyalpis aśhwanpa mastaña piyurtal illayllantapis lluy pawapacüla. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Chaynu cayalshi Jesuspi limäta uyalilcul nunacunap ćhawpinpa pasaycula “Müdanallanta yataycullalpis sänaśhämi” nil pinsaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chaynu Jesuspa ipanpa aśhuycul müdananta yataycuptinshi chay yawar ishyaynin chincälun. Jinaptinshi lluy aychan sänuña licalïshanta tantiacula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chayćhu juc nunacta munayninwan sänachishanta Jesus tantialculmi liyäśhanpi śhaycuycul ipanta licalcul: “¿Mayantan müdanäta yataycäman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Niptinmi yaćhapacünincuna: “Cay-chica nunacunawan tan'a-tan'a liyäśhanchicta licayalchun ‘¿Mayantan yataycäman?’ niyanquiman” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ñatac Jesus'a jinallam ipan-läducta licapayäla pï yataycuśhantapis lisinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jinaptinmi chay walmica, sänachishanta yaćhacul, Jesuspa ñawpäninman manchapacüśha chucchuśhtin aśhuycamula. Jinalculmi un'ulacuycul lluy lluyta willacula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chaymi Jesus nila: “Wamlallá, rasunpa chalapacamäśhayquipam sänälunqui. Canan'a jawcallañari licuy. Ishyayniquipi allinyälunquiñamari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Chay niyällaptinmi Jairop nunancuna ćhälälimul payta nin: “Wamlayqui wañucunñam. Amañash yaćhachicücäta yan'al puśhanquiñachu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Niptinmi Jesus Jairocta nin: “Ama llaquicuychu, aśhwanpa chalapacamay jinalla” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nilculmi mana mayan liwshinantapis munal Pedrocta, wawi-caśha Jacobocta, Juanta puśhaculcullal liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chay puydïcäpa wasinman ćhäpäcunanpäñatacmi apalcaćhaypa-cama llaqui-llaquicta wa'ayalcäñä sumä wasi junta. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chaymi yaycuycul Jesus: “¿Imapïtatan caynüpaña lüyayalcanqui? Wamlaca puñuyan jinallam; manam wañuśhachu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Niptinmi chayćhu cä nunacunaca asipälälinlä canpis. Ñatac Jesus llapanta yalalcachimulmi chay liwshï yaćhapacünincunallawan jinaman chay wamlap taytanta mamanta puśhaculcullal chay chutaläśhancäman yaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chayćhümi wamlap maquinta chalaycul: “Talita cum” nila. (Arameo limayćhu'a “Wamlacha, śhalcuy” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Niptin-pacham chay ćhunca ishcayniyu watanta lï wamlaca śhalcalcamul pulila. Jinaptinmi nunacunaca licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Chaypïñatacmi Jesus mana pictapis caypi willalcälinanpä ćhuncay-ćhuncay nila: “Wamlayquita alaycapäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaypïtam Jesus llapa yaćhapacünincunawan unay yaćhaśhan Nazaret malcanta licula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Warda muyun ćhämuptinmi juntunaculcänan wasićhu yaćhachila. Chay yaćhachishanta uyalilmi jucmanyacüśha: “¿Maypïtatá caycunacta apämun? ¿Mayćhütá caynu yaćhätucämun? ¿Imanuypatá caynu milagrucunactapis lulacuyanman? ");
INSERT INTO qvwNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Cay'a Mariap wawin carpintïrullari. ¿Manachun cananpis ya'anchicwan cusca yaćhayalcan śhullcan Josëpis, Jacobopis, Judaspis, Simonpis panincunapis, imamá?” nil nipäcula. Chaymi mana licaytapis munapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chaymi Jesus nila: “Manam quiquinpa malcallanćhu'a ayllullanćhu'a wasillanćhu'a Diospa willacünincunacta allinpa ćhasquipäcunmanchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chaymari chayćhu ima milagrucunactapis Jesus mana lulalachu; juc ishcay ishyäcunallactam maquinwan yataycul allinyachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ñatac chay malca-masincunap mana chalapacuynincunapïmi sumä licapayllaman camäśha cayäla. Chaypïtam muyülïnin malcancunamanña yaćhachï licula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chayćhu ćhunca ishcayniyu yaćhapacünincunacta juntuyculmi supaypa maquinpi julamunanpä munayninta uycul lluy malcacunäman ishcay-ishcayta caćhala, cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Amam caminuyquipä luncuyquitapis, nï milcapayquitapis nï illayniquitapis apapäcunquichu, aśhwanpa garutillayquitam. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Śhucuyllayquiwan janä müdanallayquiwanmi lipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mayanpa wasinmanpis ćhäpäcul'a chayllaćhu capäcuy juc malcaman pasapäcunayquicama. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sïchuśh mayćhüpis mana allinpa ćhasquipäcuśhuptiqui'a ütac mana uyalïtuculcaptin'a ćhaquiquiman la'aśha pulbüllactapis tapsilcul pasaculcay chay malcäta ima pasanantapis tantiapäcunanpä. ˻Rasunpa cäraycunan muyuncäćhu'a Sodoma Gomorra malcacunapïtapis mas mastalämi mućhuycachisha capäcun'a˼” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chaymi yaćhapacünincuna intiru malcacunäman lipäcul nunacunäta willaculcäla: “Juchayquipi wanaculcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chaynütacmi Satanaśhpa gänäśhacunactapis achcacta caćhaycachipäcula; achca ishyäcunactapis ulibu nishan jaćhap asaytinwan llusiycul allinyachipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chay timpu Jesus sumachisha captinmi nasyunpa mandänin Herodespis yaćhälul nila: “Bawtisä Juanćha śhalcämun; chayćha milagrucunacta lulayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waquin nunacunañatacmi: “Diospa willacünin Eliaschućh jinam licalïmun” nipäcula. Waquinnincunañatacmi: “Pay'a Diospa unay willacünin-yupayćha” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Caynu Jesuspi limäta uyalilculmi Herodes nila: “Mu'uchishá Bawtisä Juanćha sigürupis cawsämun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Caynümi wañuynin cala: Mandacü Herodesshi walmin Herodiaspa janan carsilman chay Bawtisä Juanta wićhachila maquincunacta cadinawan ćhänalcachil. Chaynu jinala Herodes irmänun Felipip walmin Herodiaswan tincucüśhanpïshari. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chayshi Juan chay Herodesta: “Caynu cuscacuycuśhayquicá manam allinchu” nil piñapäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Caynu nishanpïtash chay walmica nanay ñawinwan lical wañuchiyta munapäla. Jinalpis quiquin Herodes mana munaptinshi nï atipälachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes'a manchacuywan allinpash licaycula mana juchayu allin nuna Juan caśhanta yaćhal. Ñatac Juanpa limaśhantá gustaculash masqui rasunpa mana sumäta tantialpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ñatac Herodias wañupacuśhancäta lulaycunanpä ćhämunshari. Chay Herodespa santun ćhämuptinshi quiquin ayachimula llapa puydïcunacta, wardiacunap mandänincunactapis, Galileap prinsipalnincunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chaymanshi Herodiaspa wawin wamlaca yaycaycamul sumä-sumä tuśhuyninwan Herodespawan juccunäpa śhun'untapis suwaycülun. Chayshi Herodes wamläta nicuyan: “Imacta mañamaptiquipis uycuśhayquim” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Limalicucuyanläshi canpis: “¡Masqui cay mandaśhá nasyuncätapis ćhawpipi uycuśhayquimari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Niptinshi mamanman apuraypa yalulcul: “Mamay, ¿imactatan mañäman?” nila. Niptinshi: “ ‘Bawtisä Juanpa umanta’ niy-ari” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaynu niycuptinshi mandacü Herodesman apuraypa cutiycamul mañala: “Juanpa umanta ćhanćhaman uycamänayquitam muná” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Niptinshi mandacü Herodes llaquicülun. Jinalpis manash ninan'a calañachu llapa ayachimuśhan nunacunap ñawquin limalicuyal'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chayshi chay üralla juc wardiacta caćhala carsilcäman Juanpa umanta cuchulcul apamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chaynu mu'ulculshi ćhanćhaćhu wamläman uycula. Chay wamlañatacshi mamanman pasaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaynu wañülächishanta yaćhälälilshi, Juanpa puliwshïnincuna śhalcämul pampapämunanpä apaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaypïta Jesuspa caćhaśhancuna cutïlälimulmi ima lulapäcuśhantapis yaćhachipäcuśhantapis willaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ñatac nunacunaca achca-achca cutiticlaylla śhapämuptinmi micapäcunanpäpis manaña timpu calachu. Chaymi Jesus: “Acuchun lishun chunyäniscanman, jamapaycälinayquipä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nilculmi barcuwan chunyäninman paycunalla liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ñatac yalapäcuśhanta licäcunaca may linantapis yaćhälälilmi intiru malcapi yalalcamul wayra-wayra ćhaquiwan liculcäla. Jinalmi paycunapïtapis puntactalä ćhälälil juntulayalcälaña. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus barcupi ji'alpamunanpä achca-achca nunacuna alcayalcäśhanta licalculmi sumä-sumä llaquipaycula, mana michïniyu uwish-yupay cayalcaptin. Chaymi achcacta yaćhachiyta allaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chayćhu ñä tardicalpuyaptinmi yaćhapacünincuna aśhuycälil: “Taytáy, tardiña cacuyaptin cay chunyäcäćhu micuypïpis wañülälin'aćh. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","May malcallamanpis micuy ashï lipäcuchunñari” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nipäcuptinmi Jesus: “Amcunari micachipäcuy” nila. Niptinmi yaćhapacünincuna: “¿Ishcay paćhac muyunpa ćhanin illaywanlächun lantï lipäcuśhä imatá?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nipäcuptinmi: “¿Ayca tantactam uywayalcanqui? Má, licaycapämuy” nila. Chay talïlälimulñatacmi: “Picha tantawan ishcay challwallam cañä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Niptinmi yaćhapacünincunacta nila birdi pastuman lluy taycachipämunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chaymi paćhacninpi-cama, picha ćhuncanpi-cama taycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jinaptinmi Jesus chay picha tantätawan ishcay challwäta apticulcul, sïlüta licalayal Tayta Diosta sulpayta ucula. Jinalculmi tantäta challwäta partilcul, yaćhapacünincunacta manyapi aypupämunanpä uycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chayćhümi llapa nunapis maćhaycälinancama micacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jinaptinpis ćhunca ishcayniyu canaśhta juntactalämi puchüninta juntupäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cay micücunämi wayapanllanlä picha walanga capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaypïtam Jesus nunacunäta jamallá nishancama yaćhapacünincunacta barcuwan puntachila ućhap chimpan Betsaida malcaman. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chayćhu jamallá nilcul ulumanlämi Dioswan limananpä ishpila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ñä tutacalpuyaptin yaćhapacünincuna ućhäta ćhawpichayalcälañam. Jesusñatacmi ichá chay ulullaćhülä cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chay ćhawpichayalcaptinmi alli-alli waywa punta-lädupi licalïmuptin wañuy cawsayña pishipäśha barcunta liyalcächila. Chaynu liyäśhanta yaćhayal wallpa wa'ay üranülämi Jesus lila yacu jananpa yaćhapacünincunaman. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Chaynu yacu janallanpa pulishtin pasacuyäta licälälilmi apalcaćhacuyalcan: “¡Aćhaćhay! ¡¿Cundinäduchun imam?!” nil. Jinaptin-pacham Jesus nila: “¡Ama manchaculcaychu! ¡Jawcayapäcuy! ¡Ya'am cayá!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Nilcul chay barcuman ishpïluptinmi waywapis lluy śhaycülun. Chaymi yaćhapacünincuna licapänacuyllaman camälälila tanta camachishanćhu sumä munaynin camalachicuśhanta mana tantiapäcul. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chay ućhäta pasälälimulmi Genesaret malcaman ćhälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chayćhu barcunta wataycul bäjalpuyaptinmi lluy nunacunapis lisïlälilaña. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jinalmi Jesus ćhämuśhanta willaculcä intiru Genesaretcunaman pasaculcäla. Jinaptinmi imaymanawan ishyänincunacta chacanacunawan wantucuśha apapämula sänachipunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jatun malcacunaman, tacsa malcacunaman, istansiacunaman yaycuptinmi, llapa ishyäta julapämula chay pasanan caminucunäman. Chaypa pasaptinñatacmi llapa ishyäcuna ruygaculcäla Jesuspa müdananpa manyallanta yataycapäcunallanpäpis. Chayćhu yataycücunaca sänum licalipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jesus caśhancämanmi Jerusalenpïta camachicuyta yaćhachicücunäwan fariseocunaca ćhälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jinalmi Jesuspa yaćhapacünincuna mana maquinta chuyanchacul micapäcuśhanta licalcälil juchachapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Cay fariseocunawan lluy Israelcunämi awiluncunap custumrinta atichipäcul mana maquinta pa'acul'a imallactapis nï uchucllapis mallilcälïlapischu. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pläsäpi cutimulpis maquincunactalämi pa'aculcäla imallacta micapäcunallanpäpis. Caynu custumrincunacta lulä calmi, llapa imapis cusinanćhu sirbichicuśhancunactapis, cämancunactapis chuyanchapäcula.) ");
INSERT INTO qvwNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chaymari fariseocunäwan camachicuyta yaćhachicücunaca Jesusta tapupäcula: “¿Imapïtatan awquillunchiccunap custumrinta jalutacuyalcan ampa yaćhapacüniquicuna chuya caycälinanpä maquinta mana pa'acul micapäcuśhanwan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nipäcuptinmi Jesus nila: “Am ishcay cära nunacunapïtamari Diospa unay willacünin Isaias rasunpa isquirbila: ‘Cay nunacunacá janä shimillanwanmi alawapäman. Śhun'unñatacmi ichá calućhu cayan. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yan'almi alawaycaćhapäman, nunacunallap yaćhachicuyllanta yaćhachiy jicutayalcal'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Amcuna Diospa nishanta juc-läduman caćhayculmi nunacunap yaćhachicuyllanta ama-pacha niyalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","¡Maynu tuquictaćh lulayalcanqui Diospa camachicuyninta jalutaculcul quiquillayquipa custumriquita atichishayquiwan! ");
INSERT INTO qvwNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Diosmari Moiseswan camachila: ‘Taytayquita, mamayquita tuqui allinpa licapäcuy; mayanpis taytanta, mamanta jalutacücá wañuchun’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Chaychun amcuna taytayquicuna ‘yanapaycamay’ nipäcuśhuptiqui ‘Manam capamanchu; Diosmanñam lluy uycülú’ nil niyalcanquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chay jinaśhayquiwanmi yaćhayalcächinqui mana yanapapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chaynu awiluyquicunap custumrinta yaćhayalcächilmi Diospa Shimintá mana cäman muyulcächinqui. Caytanuy imaymana lulaytamari lulayalcanqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nilculmi llapan nunäta juntuycul Jesus nila: “Llapayquipis sumäta uyalimal, umayquiman ćhulapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Cay shiminchicpa yaycücächu manamá juchacachimanchic sinu'a śhun'unchicpi yalamücämari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chayćhu lluy nunacunäta caćhaycul jamacuśhan wasiman yaycüluptinmi, chay yaćhachishancäpïta yaćhapacünincuna tapupäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jinaptinmi nila: “¿Amcunapis tullu umalächun cayalcanqui, imatá? ¿Manachun tantiapäcunqui shimillanchicpa yaycücá nunacunäta Diospïta mana laquichimäśhanchicta, imam? ");
INSERT INTO qvwNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chaycuna manamari śhun'unchicmanchu yaycun, sinu'a patallanchicman yayculmi pasacun” nila. (Caywan'a lluy ima micunapä cäcäpis “chuyam” nilam.) ");
INSERT INTO qvwNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nilculmi nila: “Nunap śhun'unpïtam ichá juchacachïcälä yalamun: ");
INSERT INTO qvwNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","mana allin pinsaycunam, mansibacuycunam, imapis anla lulaycunam, wañuchiy munaycunam, ");
INSERT INTO qvwNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","suwacuycunam, jucpa imanpïtapis wañuyaycunam, juyu lulaycunam, casquicuycunam, imapis millachicuy anla pinsaycunam, ambisyacuycunam, tumpacuycunam, nunatucuycunam, mana tantiayninwan imacta lulaycunapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lluy cay mana allincunämari śhun'unpi yalul Diospïta laquiyächin” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaypïtam Jesus licula Tirop, Sidonpa malcancunaman. Chayćhümi juc wasićhu jamapacunanpä pictapis mana musyachillal yaycula. Chaynu captinpis lluy lluymi musyatityälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chayćhümi juc walmip wamla wawin Satanaśhpa gänäśha cañä. Chay walmim uyalïlul-pacha Jesusman śhamul un'ulacuycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pay manam Israel caśhtachu cala, sinu'a Sirofenicia nishan malcäpïtam. Paymi Jesusta ruygacula wamlanta sänaycachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jinaptinmi Jesus nila: “Manash chulinchiccunap shiminpïtalä waycaycul allucunallaman alaycüluchwanchu. Puntactá ayllucunalä micuchun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Niptinmi: “Masqui chaynu captinpis, taytáy, ayllucunaca usuchishallantapis allucunäpis mallilcälinmá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Niptinmi: “Cay nishayquipamari wawiquita Satanaśh caćhaycülunña. Canan wasiquita jawcallaña cuticuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chaynu wasinta cutinanpämi wawin tuqui allinyäśhaña cämanćhu jitalayäñä. Rasunpa chay Satanaśhca caćhaycuñämi. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chay Tiro-lädupi Jesus yalulmi Sidon-lädup pasal Galilea ućhaman Decapoliscama ćhälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chayman juc pasaypi mana limä, nï uyalï upacta ćhaycachilmi: “Taytáy, maquiquiwan yataycullay sänananpä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Niptinmi Jesus juc-läduscaman japächalcul, ishyäcäpa ishcaynin linlinman dïdunwan yataycula. Chay dïdunman tuwaycultacmi shimintapis yataycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jinalculmi sïlüta licalcul sumä jamalcul upäta: “Efata” nila. (“Efata” ninan'a “quićhacacuy” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nilcullaptinshi linlinpis quićhacalcul uyalïñä, shiminpis tuqui tuquictaña paćhyämuñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Chaynu sänalcachilmi Jesus nila: “Caypïta amam mayantapis willapaculcanquichu” nil. Chaynu llapanta ćhuncay-ćhuncay niyalcaptinpis mastalämi willapaculcäla. Licapayllaman camäśhalämi: “¡Lluy lluytapis allintamá lulaycun! ¡Mana uyalï linlictapis uyalichinmá! ¡Mana limä upacunactapis limalichinmá!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chay muyuncunaćhümi Jesus caśhancäman achca nunacuna juntunacälälimula. Paycunap mana imapis micapäcunanpä captinmi Jesus yaćhapacünincunacta ayalcul nila: ");
INSERT INTO qvwNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cay nunacunäpïmi llaquicú. Micuypïñaćh cayalcällan quimsa muyunña ya'anchicwan cusca cayalcal'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Chaynu liculcal'a waquincuna calu-calucunapïlä śhayämul'a yan'alćha chay lipäcuśhanćhu lawtïlälinman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Niptinmi yaćhapacünincuna: “Taytáy, maypïtá cay-chica nunacta micachinapä cay chunyä ulüćhu talipämuśhä” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Niptinmi Jesus tapula: “¿Ayca tantallactá uywayalcanquim?” nil. Niptinmi: “Anćhish tantallactam” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","7","Niptinmari llapan nunacunäta pampäman “taycapäcuy” nilcul chay anćhish tantäta apticulcul Diosta sulpayta ucul yaćhapacünincunacta uycula manyapi aypumunanpä. Chaynütacmi ashchaylla uywapäcuśhan challwacunäwanpis lulala. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jinaptinmi llapan nunacunäpis maćhaycälinancama micapäcula. Puchünintañatacmi anćhish canaśhta juntactalä juntupäcula canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chay micücunaca tawa walangapi (4000) maslämi capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chaypïta tincunanchiccama nilculmi Dalmanuta-läduman Jesus yaćhapacünintin barcuwan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chay Jesus caśhanmanmi fariseocunaca śhapämula paywan tapunaculcänanpä. Chayćhümi yaćhapänan-laycu: “Má, altu sïlupi ima siñalllactapis licaycälichipämay” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nipäcuptinmi Jesus śhun'unćhu allicta llaquiculcul nila: “¡¿Imapïtan cay nunacuna siñalllapïta wañupacuyalcan?! ¡Rasunpa manam ima siñaltapis licaycachishächu!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nilculmi yaćhapacünincunawan barcuman ishpilcul ućhap juc-lädu manyanman chimpapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chayćhu yaćhapacünincuna milcapanta apayta un'älälilmi chay barcućhu jucllay tantallacta apañä. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chayćhümi Jesus: “¡Yan'al-lätac mandacü Herodespawan, fariseocunap libadüra imanta ćhasquïlälinquiman!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Niptinmi quiquin-pula: “Caynu niyämanchic tantanchicta un'amuptinchicćhá” ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chayta yaćhalmi Jesus nila: “¿Imapïtá micuyllapi llaquicuyal piñanacuyalcanqui? ¿Manalächun tantiapäcunquipis licapäcunquipis? ¿Śhun'uyqui pasaypi lumiyäśhachun cayan, imamá? ");
INSERT INTO qvwNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ñawiqui cayaptinpis lulaśhäcunactapis manachun licapäculanqui? ¿Linliqui cayaptinpis limaśhäcunacta manachun uyalipäculanqui? ¿Icha manachun yalpapäcunqui, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Picha tantallacta picha walanga wayapacunaman camachiptí ¿ayca canaśhta juntactalämi puchüninta juntupämulanqui?” nil. Niptinmi yaćhapacünincuna: “Ćhunca ishcayniyu canaśhta juntactam” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Niptinmi: “Tawa walanga nunacunäman anćhish tantallacta aypuchiptí, ¿ayca canaśhta juntactalämi puchüninta juntupämulanqui?” nin. Niptinmi: “Anćhish canaśhta juntactam” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Niptinmi: “¿Chaychun tanta pishipacuyllapi mana limaśhäta nï tantiapäcunquimanchu?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaypi Betsaida malcaman Jesus ćhäluptinmi juc apla nunacta puśhapämul: “Maquiquiwan yataycullay sänananpä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nipäcuptinmi Jesus chay malcap manyancama apla nunäta chancuyllap puśhäla. Chayćhümi Jesus tuwayninwan aplap ñawinman llushiycul “¿Imallactapis licayanquichun?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Niptinmi aplaca intiru muyülïninta licaycaćhalcul: “Aw, canan'a jaćha-yupay nunacunaca puliyalcäta aspa-aspallactá licayämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chayćhu ñawinta Jesus yapa yataycuptinmi tuqui quićhacacüluptin lluy imacunactapis tuquictaña licäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chayćhümi Jesus ćhuncay-ćhuncay nila: “Malcaman mana yaycullal wayralla wasiquita licuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaypïtam Jesus yaćhapacünincunawan Cesarea Filipos-läducunaman liculcäla. Chay liyalcalmi yaćhapacünincunacta tapula: “¿Ya'acta mayan nipämantan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Niptinmi: “Waquinnincuná: ‘Bawtisä Juanćha śhalcämun’; waquinnincunañatac: ‘Diospa unay willacünin Eliasćha cutïmun’; juccunañatac: ‘Diospa jucnin unay willacüninpisćha cawsämun’ niyalcäśhunquim” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nipäcuptinmi Jesus: “Amcunapïtá ¿pitan chayurá ya'a cayá?” nila. Niptinmi Pedro: “Am'a canqui Diospa Caćhamuśhan Salbacücämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Niptinmi Jesus: “Mayan caśhätapis amam mayanćhüpis limalcälinquichu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaypïtam wañunanpi yaćhachiyta allaycula: “Ya'a Rasun Nunap Chulintam prinsipal yaśhacuna, puydï sasirdüticuna, llapa yaćhachicücuna sumä-sumä ñacachipämal wañuchipäman'a. Jinamaptinpis quimsa muyunpïtam caśhan śhalcamuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chaynu tantiapaśhta Jesus niptinmi Pedro japächalcul Jesusta awnichiyninwan piñapaycaćhacuyan: “¡Caynu pasananta Dios amaćh munanmanchu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Niptinmi Jesus llapa yaćhapacünincunaman muyulcul Pedrocta piñapäla: “¡Ñawïpïta chincay, Satanaśh! ¡Ampa umayqui'a nunap lulayllanćhümi cayan, manam Diospa lulaynincunaćhüchu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jinalculmi llapa nunacunätawan yaćhapacünincunacta juntuycul nila: “Rasunpa mayanpis ya'ap laśhćhüman jalumuyta munäcá quiquinta un'acuycul jalumuchun ima pasaptinpis wañunancama. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ñatac cawsayninta ama-pacha nïcá cawsaynintam apacun'a. Ya'a-laycu, allin willacuy-laycu bïdantapis uycücämi ichá cawsaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Imapämi bälinman jinantin pachaca maquinchicćhu cayaptinpis wiñay cawsayninchic chincäluptin'a? ");
INSERT INTO qvwNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¡¿Almayquipïtá imalämá mas ćhaniyu canmanpis?! ");
INSERT INTO qvwNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chayurá Diosta ipanchä pasaypi nunacunäćhu mayanpis ya'apïta ütac yaćhachicuynïpïta pin'acamäcätá ya'a Rasun Nunap Chulinpis Taytäpa munayninćhu chuya anjilcunawan cutimuynïćhu paycunapïpis pin'acuśhämi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chaynütacmi nila: “Rasunpa waquinniquicuná manalä wañupäculmi Diospa gubirnun munayninwan ćhämüta licaycälinqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chay süta muyunpïtañatacmi Pedrocta, Jacobocta, Juantawan puśhaculcul Jesus chunyä ulup puntanman lipäcula. Chayćhümi Jesus jucnüman lluy muyülun. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Müdananpis sumä-sumä chipipicyayä laśhtanu yulämanmi licalïlun. Cay jinantin pachächu manam mayanpis chaynu yulätá licalichinmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chayćhümi Diospa unay willacünin Eliaswan Moiseswan limaśhtin licalïlun. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Paycunactawan licälälilmi Pedro nicuyan: “Yaćhachicü taytáy, allinpämá śhapämuñá. Canan-ari quimsayquipä jucnincä-cama chucllacta lulälälipuśhayqui, ampä, Moisespä, Eliaspä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Cay niyllamanmi shimin paćhyala manchalicüśha lluy cacuyalcaptin. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jinamanmi pucutay ji'alpalcamul ñiticalpula. Chaypa śhun'unpïtam ayalpämun: “Paymi cuyay chulí. Payllactari uyaliculcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chay niptin licalcälinanpämi Jesusllaña chayćhu cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ñatac chay ulupi cutiyalcämuptinmi Jesus nila: “Cay licapäcuśhayquipïta amam pictapis willapäcunquichu Rasun Nunap Chulincäta wañuchipämaptin caśhan śhalcamunäcama” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chaynu niptinmi quiquin-pulacuna cay “cawsamuśhämi” nishancäpi tapunacuśhtin śhun'ullanćhu uywapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ñatac chayćhümi Jesusta tapupäcula: “¿Imapïtam Moisespa camachicuyninta yaćhachicücunaca nipäcun: ‘Diospa unay willacünin Eliaslämi puntacta śhamun'a Diospa Salbacücäpïtá’ niyalcan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Niptinmi Jesus nila: “Aw, rasunpam Elias puntacta śhamun'a lluyta tincüninmancama allichaycachinanpä. Ñatac Diospa shiminćhüpis niyantacmi: ‘Rasun Nunap Chulincätá lluy ćhïnilmi ñacachipäcun'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Rasunpa Elias śhamulañam. Jinaptinmari lluy nunapis munapäcuśhanmannuy pasachipäcula Diospa shiminćhu nishan-yupaypis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chay parti yaćhapacünincuna caśhancäman ćhälälimunanpämi achca-achca nunacunawan cayalcäñä, camachicuyta yaćhachïcücunäwan tapunacuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chayćhu nunacunaca Jesusta licälälilmi “¡Pay śhamüñämá!” nil limaycälï aśhuycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusñatacmi nila: “¿Imactam paycunawan tapunaculcälanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nilcuyaptinmi jucnin nuna limalïmun: “Taytáy, chulillätam puśhamulá achatu lluy upaman muyüchiptin. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Paytam mayćhüpis lluy pampaman cućhpächin-cućhpächin pushumayta ätumunancama. Jinalcuptinmi quilunta lawćhićhicyalcachil pasatyalpul isacacun. Yaćhapacüniquicunacta sänachipamänanpä mincacuptïmi mana atipapäcunchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Niptinmi Jesus nila: “¡Ay, mana chalapacuyniyu nunacuna! ¿Imaycamatan amcunacta awantaśhtin cayäśhä? Má, cayman-ari puśhamuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chayćhu puśhaycuyaptinmi Jesusta licalcul achatuca walaśhcäta tapsicuyaptin pampäman cućhpälul anćhaycaćhacuyan shiminpïpis pushumayta ätuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jinaptinmi Jesus tapula walaśhcäpa taytanta: “¿Imaypïtam caynu cayan?” nil. Niptinmi: “Uchuyllanpïtam. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Caycamá ayca cutiñaćhá jitaycülun jitaycülun ninamanpis yacumanpis wañuy ñacachinanpä. Chaynu caśhanta yaćhayalñá llaquipaycuy-ari. Ichaćh am'a sänachipallämanquimanpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Niptinmi nila: “¿Imanimänayquitam cay ‘ichaćh’ nimäśhayquiwan nimanqui? Pipis chalapacücäpá lluymi imapis lulaśha can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Niptinmi chay walaśhcäpa taytan apalcaćhaypanuy nila: “Ya'a rasunpa chalapacümi; aśhwanpa yanapaycallämay masta chalapacunäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ñatac achca nunacuna juntunacacayämuptinmi Jesus: “Anla achatu, canallan caćhaycul licuy. Yan'al-lätac cananpi cutiycayämunquiman” nil alapacüla. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jinaptinmi sumä-sumä yapa tapsilcul wañüśhactanuy caćhaycul apalcaćhaśhtin licula. Chaynu pasatyalpüluptinmi chayćhu cäcunaca: “Wañucun-ari” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ñatac Jesus'a maquipi śhalcalcächiptinmi sänuña śhalcüla. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaypïta juc wasiman Jesus yaycüluptinmi yaćhapacünincuna tapupäcula japallanta: “¿Imapïtan ya'acuna caćhaycachiyta mana atipapäcüchu?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Niptinmi Jesus nila: “Caynücunätá caćhaycachinchic ˻ayunal˼ Tayta Diosta mañacuyllanchicwanmá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chaypi lipäcuśhanćhu yaćhapacünincunacta yaćhachinan-laycum nunacunaca mana musyapäcunanpä Galileanpa pasapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chayćhümi nila: “Ya'a Rasun Nunap Chulincäta puydï nunacunap maquinman ćhulaycamaptinmi wañuchipäman'a. Jinapämaptinpis quimsa muyunpïtam caśhan śhalcamuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Niptinmi mana tantiapäculachu imaninantapis, manchäśha cayalcaltac nï tapuycälïlachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum malcaman ćhaycul, juc wasićhu cayalcaptinmi Jesus yaćhapacünincunacta tapula: “¿Śhamuśhanchicćhu imapïtan pilyap-pilyapäculanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Niptinmi chay caminućhu “¿Mayanninchicćha mas puydïnin caśhun?” nil ninaculcäśhanpi mana limalil uyaläcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaymi Jesus lädunman yaćhapacünincunacta lluy juntuycul nila: “Mayanpis puydï cayta munäcá, mana cäpa licaśhanninmi canan; jinaman llapantapis sirbiycuchun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nilcuśhanpïmi juc walaśhchacta ñawpäninman puśhaycachila. Chayta malaculculmi: ");
INSERT INTO qvwNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mayanpis caynu walaśhchäta ćhasquïcá ya'apa caśhan-laycum ya'acta ćhasquiyäman. Jinaman manam ya'allactachu, sinu'a caćhamänïtapis ćhasquiyantacmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chaypïtam Juan nila: “Yaćhachicü taytáy, juc nunactam licälälí ampa pudirniquiwan Satanaśhpa gänaśhacunacta sänayächishanta. Chaymi ya'anchic caśhtapi mana captin lluy mićhacälälilá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Niptinmi Jesus nila: “¿Imapämi mićhaculcanqui? Mayanpis pudirnïwan milagructa lulayal'a chaypïta manamá mana allinta ya'api limanmanchu. Mayanpis ya'anchicpa cuntranchic mana cäcá ya'anchicmanmi śhalcapäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rasu-rasunpa, mayanpis atïnï-laycu caśhayquipi masqui täsa yacullacta uycücätapis Tayta Dios allincätalämi uycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yan'al-lätac cay uchuchäcunanülla cä chalapacamänïta mayanpis juchaman palpuyächinman. Mas allinćha canman cuncanman wanca lumicta watacuycul lamarcäman ji'acalpuptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Sïchuśh maquiqui juchaman jitaycuy munaśhuptiqui'a cuchulcul wicapäluy. Allinläćhá cutu maqui cayal Dioswan cawsaptiquipis canman ishcaynin maquiquiwan mana imaypis camacä nina waläcäćhu ñacanayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Chaynütac ćhaquiqui juchaman jitaycuy munaśhuptiqui'a cuchulcul wicapäluy. Allinläćhá canman cutu ćhaqui Diosman yaycuptiquipis, sänu cayal nina lupäcäman jitaycachicunayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Chaynütac ñawiqui juchaman jitaycuy munaśhuptiquipis altäluy. Diospa gubirnunman churchüśha yaycuptiquipis allinläćhá canman, sänu cayal mana imaypis wañucälï ninaćhu nï ismuypis imaypis camacäcäćhu canayquipïtá. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Lluymari ninawan camacäśha capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Chayurá chuyanchacunanchic allinmi. Ñatac chay chincäluptin'a ¿imanuypatá cutichimunquiman? Amcuna chuya capäculari lluywanpis jawcalla cawsapäcuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chaypïtam Jesus Jordan mayup chimpanman, Judeap malcancunaman licula. Chayman achca nunacuna juntunacälälimuptinmi yaćhacäśha cayninwan chayćhu yapañatac yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chayman fariseocuna ćhälälimulmi Jesusta quiquinpa limayllanwan palpachinanpä tapupäcula: “¿Juc nuna walminwan imallapïtapis laquinacunanpä cäsu canchun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Niptinmi Jesus quiquincunacta tapula: “¿Imanipäcuśhunquimari Moisespa camachicuyninćhu?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Niptinmi: “Awquillücunactá papilta lulanacuycul laquinaculcänapämi Moises cunsintipämäla” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Niptinmi: “Chayta cunsintipäcuśhulanqui pasaypi nunacuna capäcuśhayquipam. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ñatac cay pachäpa allaycuyninćhu'a walmi carilla cananpämá Dios lulala. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Chaymi mamanta, taytanta caćhaycul walminwan jucllaña capäcun'a. Chayurá manañam ishcaychu sinu'a jucllayllañam. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chaynu quiquin Dios jucllachäśhancäta nunacunacá manam laquinanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Juc wasićhüña Jesuswan cayalcalmi cay limaśhancäpi yaćhapacünincuna tapuculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Chaymi Jesus: “Pipis walminwan laquinaculcul jucwan cuscäcá, mansibacuyanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chaynütac walmipis wayapanpi laquiculcul jucwan cuscäcá, mansibacuyantacmi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chaypïtam Jesusman achca nunacuna puśhapämuñä uchuchä chulincunacta “Allin cawsayniyu cachun” nil Diosta mañacapunanpä. Yaćhapacünincunañatacmi ichá lluy mićhacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chaynayalcaptinmi Jesus piñacülul: “Ama mićhaculcaychu; jina śhapämuchun. Cay uchuchäcunanuy cäcunapämari Diospa gubirnun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rasu-rasunpa, mayanpis uchuchäcunanülla mana ćhasquïcá, chayman manam yaycun'achu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nilculmi uchuchäcunäta malaculcul, paycunapä Tayta Diosta mañacapula. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chaypi pasaśhä niyaptinmi juc nuna cürri-cürriwan ćhaycamul Jesuspa puntanman un'ulacuycul: “Allin yaćhachicü Taytay, ¿imactatan lulalläman wiñay simpri cawsaycäman yaycunäpä?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Niptinmi Jesus: “¿Imapïmi ‘allin’ nimanqui yaćhachicülla cayapti'a? Allincá Diosllam” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nilculmi: “Yaćhanquimari camachicuyćhu: ‘Amam nunacta wañuchinquichu; mansibacunquichu; suwacunquichu; casquicunquichu; yan'al ingañacuyanquichu; jinaman taytayquita mamayquita tuqui allinpam licanqui’ nil nishancunacta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Niptinmi: “Yaćhachicü, caycunallamannu'a uchucllapïmi cawsayculá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Niptinmi Jesus llaquipaywan licapaycul: “Jucmi lulanayqui cayanlä: lluy cäniquita lanticulcul llapa wacchacunaman aypuycamuy. Jinalmi janay pachäćhu alli sumä cäniyu caycunqui. Jinalcul wañunayquicama laśhćhüman jalumul atimay” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Niptinmi chay müsu alli cäniyu cayal nishanta uyalïlul sumä llaquisha licula. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chaymi Jesus lluy muyülïninta licalcul yaćhapacünincunacta nila: “Sumä cäniyu nunacuná Diospa gubirnunman yaycunanpä, sasa-sasam” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cay nishanta uyalïlälilmi yaćhapacünincuna licapayllaman camälälila. Jesusñatacmi yapa nin: “Walaśhnïcuna, rasunpa sasam Diospa gubirnunman cäniyücunaca yaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chayman cäniyu nuna yaycunantá aśhwanpa juc camïllu uywapis awjap linlinpa pasälunmanlämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Niptinmi yaćhapacünincuna mastalä licapayllaman camäśha cacuyal ninacücuyalcan: “Chaynu captin'a ¿mayantá salbacunman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaymi Jesus licapaycul: “Caycuna nunacunapá mana atipänam. Diospämi ichá imapis atipäna” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chayćhümi Pedro: “Ya'acunam ichá lluy imallätapis caćhaycul atiyalcac” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Niptinmi Jesus: “Rasu-rasunpa, mayanpis ya'a-laycu, jinaman allin willacuy-laycu, wasintapis, irmänuntapis, panintapis, mamantapis, taytantapis, chulintapis, chaynütac ćhaclancunactapis caćhaycücá cay pachäćhu ćhasquin'a paćhac cuti mastalämi, wasinćhu, irmänunćhu, paninćhu, mamanćhu, chulinćhu ćhaclacunaćhüpis, jinaman ñacaycunactalämi canpis. Jinaman śhamücäćhu'a wiñay cawsaytalämi ćhasquipäcun'apis. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Rasunpa canan puntanninćhu cäcunämari ipaćhu licalipäcun'a; ñatac ipaćhu licaśhacunämi puntanninćhu caycälin'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chaypi Jerusalenman ishpipäculmi Jesus yaćhapacünincunap ñawpäninta lila. Yaćhapacünincunawan juccunäñatacmi pinsatïbu-cama manchacäśha-cama atiyalcäla. Jinaptinmi chay ćhunca ishcayniyu yaćhapacünincunacta japächalcul willapäla imacuna quiquinta pasanantapis cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Canan yaćhayalcanquimá Jerusalenman lishanchicta. Chayćhümi puydï sasirdüticunäpa, camachicuyta yaćhachicücunäpa maquinman jitaycälimaptin, ya'a Rasun Nunap Chulincäta wañuyman ćhulaycäliman'a. Chaycunam mana-Israelcunäpa maquinman jitaycälimaptin ");
INSERT INTO qvwNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","burlapapäman'a, lawćhapäman'a, tuwapäman'a, wañuchipäman'apis. Jinapämaptinpis quimsa muyunpïtam ichá cawsamuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chayćhümi Zebedeop chulin Jacobowan Juan, Jesusman ñawpatyalcul nipäcula: “Yaćhachicü taytay, ama chaynu caychu, mañacuylläta awniycälillämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Niptinmi Jesus: “¿Imactatan munapäcunqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Niptinmi: “Jatun gubirnuyquićhu allinninman taycaycälichimänayquitam munapäcullá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Niptinmi: “Manamá yaćhapäcunquichu ima mañaculcäśhayquitapis. ¿Ya'anuy jucchun llaquicunacta ñacaycunacta pasapäcunquiman ampá?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Niptinmi: “Aw, pasapäcümanmi” nipäcula. Niptinmi: “Aw, rasunpa ya'anümá amcunapis pasaytá pasapäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ñatac ya'awan cusca täcunanchicpá manam maquïćhüchu. Quiquin Taytá unanchacuśhancunapämi chay'a cayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chay nipäcuśhancunacta uyalilcälilmi yaćhapacü-masincuna Jacobopäwan Juanpä piñacälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chaymi Jesus llapanta juntuycul nila: “Yaćhapäcuśhayquinüpis juc nasyuncunaćhu puydï mandacücunaca payllaña sumä yaćhätucüśha nunatucüśham munaśhanta lulachipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amcunaćhu'a chaynu manam canmanchu. Aśhwanpam pipis puydï cayta munäcá śhullcänuy lluyta sirbiycunman. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chaynütacmi puntaćhu cayta munäcäpis lluypa uywaynin caycunman. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chaypämari ya'a Rasun Nunap Chulinca śhamulá: manam sirbichicunäpächu, sinu'a sirbiycul bïdätapis jinantin nunacunäpi uycul salbaycunäpämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chay Jericó malcaman ćhaycul pasayalcaptinmi achca nunacunaca atipäcula. Chay yalamunan caminućhümi Timeop chulin Bartimeo śhutiyu apla mañapacuśhtin täcuyäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Paymi Nazaret-lädu Jesus caśhanta tantiälul: “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacü, Jesuslláy! ¡Llaquipaycallämay-ari!” nil ayaycaćhacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chay nunacunäñatacmi: “¡Upällalla cay!” nil mićhaculcäla. Jinaptinpis aśhwanpa mastalämi ayaycaćhacuyan “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacüní! ¡Llaquipaycallämay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaymi Jesus śhaycuycul puśhachimula. Jinaptinmi apläta: “¡Cushicul śhalcuy! Ayayäśhunquim” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Niptinmi cataläśhantapis jitaycul juclla śhalcuculcul śhamula. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ćhämuptinmi Jesus: “¿Imallactam nilanqui?” nin. Niptinmi aplaca: “Taytalláy, licaytam munallá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Niptinmi: “Chalapacamäśhayquipam allinyälunqui; licunquimanñam” nin. Niptin-pachalla apläpa ñawin licäluptinmi Jesusta atila. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chaypïta Jerusalenman ñaćhapaycuyalcal, Ulibus nishan ulućhu Betfageman Betania malcaman ćhälälilmi ishcaynin yaćhapacüninta caćhäla: ");
INSERT INTO qvwNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Cay chimpa malcaman yaycapäculmi mana mayanpis sillaśhan malta aśhnu watalayäta talipäcunqui. Chayta pasquilcul aysapämuy. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mayanpis ‘¿imapämi pasquiyanqui?’ nipäcuśhuptiqui'a ‘Duyñümi munan; ña'ascallamanmi cutichimuśhä’ nipäcunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chaynu lipäculshi nishantanülla wasip puncun caminućhu watalayäta talïlälin. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chayćhu pasquiyalcaptinshi licä nunacunaca: “¿Imapätan pasquiyalcanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chaymi Jesus nishantanülla nipäcuptin awnil pasquichipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chaypi puśhalcamul müdanancunawan carunäläliptinmi Jesus sillacula. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Chay caminu lishancämanmi achca nunacuna alawayninwan catacuncunacta maśhtapäcula. Juccunañatacmi palmïra jaćhap pallaynincunacta cuchulcul caminuman maśhtapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chay ipanta puntanta lï nunacunämi bïbaśhtin alawapäcula: “¡Cawsachun Diosninchicpa pudirninca! ");
INSERT INTO qvwNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡David timpumannuy malcanchicta śhalcachïca alawaśha cachun! ¡Cawsachun imaycamapis!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ñä Jerusalenman Jesus ćhälulmi Diospa chuya wasinman watucuycü yaycula. Aspicalpuyaptinñatacmi yaćhapäcünincunawan Betania malcaman cuticulcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chay walantin Betania malcapi cutiyämuptinmi Jesusta micanälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chay caluscaćhülä juc ïgus lanta tutap-tutal birdiyäta licälulmi “wayuyanñapisćha” nil liptin licachipäpis nï wayuñächu. Manalämari timpunćhüchu cañä. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chaymi lantäta: “¡Cananpïtá manaña wayuptiquim mayanpis nï micalcälin'añachu!” nin. Chay nishantam yaćhapacünincuna uyalïlälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chaypi Jerusalenta ćhälulmi, Jesus Diospa chuya wasinpa patyunman yaycul lantinacuyalcäcunacta talïlun. Chaymi illaywan cambiäcunap mïsancunactapis paluma lanticücunap täcunancunactapis ticlaypa-pawalcul waśhaman lluyta alapacämun. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jinalculmi manaña cunsintilañachu lanticuynincunawan pasaycaćhapäcunallantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chayćhümi yaćhachila: “¿Manachun Diospa shiminćhu ‘Ya'ap wasí jinantin nunacuna ya'allawan limanan wasim can'a’ nil niyan? ¡Chaychun amcuna suwacunap maćhayninman muyulächinquiman!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chay yaćhachishanpi nunacunaca mishqui-mishquictam uyalipäcula. Puydï sasirdüticunäwan camachicuyta yaćhachicücunäñatacmi ichá manchalipäcula. Chaymi imanuypa wañuchiytapis ashipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ñatac tutalpüluptinmi chay malcapïta Jesus yaćhapacünincunawan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chay walantin chaypa caśhan pasapäcunanpämi ïgus lanta sapipi lluy chaquisha cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chayta licälulmi Pedro yalpalcul Jesusta nila: “¡Yaćhachicü taytáy, licay, cay piñapäśhayqui ïguscá lluy chaquïñä!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Niptinmi: “Tayta Diosman chalapacuy jinalla. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mana ishcayyällal śhun'uyquićhu ‘Lulacaśham can'a’ nil chalapacuptiqui'a rasunpa lulaśham can'a; aśhta ulüta ‘Caypi aśhucuy lamar ćhawpiman’ niptiquipis aśhunmanmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chaymi rasunpa sumäpa chalapacul mañacuptiqui'a chaymannuy ćhasquiycunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jinaman'a chay mañacuśhayquićhu pampachaycunayqui captin'a pampachaycuy, janay pachäćhu cä Taytayqui amcunactapis pampachaycälishunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mana pampachapäcuptiqui'a manatacmari pampachapäcuśhunquitacchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chaypi Jerusalenman ćhälälimulmi Diospa chuya wasinpa patyunćhu Jesus puliyäla. Jinaptinmi puydï sasirdüticunäwan, camachicuyta yaćhachicücunaca, prinsipal yaśhacunawan aśhuycälimula. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chayćhümi: “¡¿Mayantucultá cayćhu lulaycaćhayanqui? ¿Mayantá cayta lulanayquipä ćhulaśhulanqui?!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Niptinmi Jesus: “Má, ya'actapis nipämay: Juan bawtisananpä ¿pitan caćhamula? ¿Dioschun icha nunacunällachun? Niycälimaptiqui'a ya'apis nishayquim mayanpa mandacuyninwan cayta lulaśhätapis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Niptinmi quiquin-pula ninacücuyalcan: “ ‘Dios caćhamula’ niptinchic'a ‘¿Imapïtan-nila mana chalapaculcälanquichu?’ nilćha nimäśhun. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Nunallam’ niptinchic'a cay nunacunaca imanämachwanćha, Bawtisä Juanta Diospa rasun willacüninpa licayalcal'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chaynu ninaculculmi: “Manam yaćhapäcüchu, taytay” nin. Niptinmi Jesuspis: “Chayurá ya'apis manam mayan caćhamäśhantapis willapäcuśhayquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nilculmi tincuchiypa yaćhachila cay nil: “Juc nunash cala jatun ćhaclayu. Paymi chay ćhaclanćhu übacta plantalcul manyanta lluy inćhäla. Chayshi übacta apchichinanpä juc püsucta lulala, chaynütac täpachinanpäpis chucllachäla. Caynu lluy listucta lulalculshi nunacunaman partïda uycul calu malcacta licula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chaypi cusicha timpu ćhämuptinshi caćhamula juc nunanta partinta cusichalcul apamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chay nunantash partïdaśhancunaca chalalcälil lluy ma'alcälil jinanllacta cutichipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chay jinapäcuptinpis ćhaclayücá juccunactash caćhamula. Chaynüshi chaytapis palalcälil umallantapis lluy paquï-pawalcul gulpïlälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chaynälälimuptinpis juctapis caćhamulash. Chaytapis lluyshi wañülächila. Juccunacta caćhamuptinpis waquintá ma'apäculash, waquincunactá wañuchipäculash. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Chayshi jucllayllaña caćhamunanpä captin japallan cuyay chulillantaña ‘chulïtá allinpaćh lican'a’ nil caćhamula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chay ćhämuptinshi, partïdaśhan nunacunaca limanacucuyalcan: ‘Cay chulinpäćha caycuna quïdan'a. Wañüchishun cay tücänin ya'anchicwan quïdananpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chayshi lluy chalalcälil wañülächila. Jinalculshi ćhaclanpi aysalcul wicapälälimula” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nilculmi Jesus nila: “¿Chaynu luläläliptin'a chay ćhaclayüca ćhämul ‘allinmi’ nin'achun ampá? Aśhwanpa lilculmá chay nunacunäta wañulcachil juccunaman ćhaclanta uycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Manachun isquirbishancunaćhüpis lïgipäculanqui? Chayćhümi niyan: ‘Wasi luläcuna jalutacuśhan lumim mas allin puydï chaläninmanlä muyüla. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chay quiquin Tayta Dios lulaśhanpïmi licapayllaman camäśha cayalcá’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chaynu niptin puydïcunaca paypi nishanta lluy tantiacalcälilmi Jesusta chalachiyta munapäculpis achca-achca nunacunäta manchalil caćhaycul liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaypïtam fariseocunaca, Herodes partiwan limanacälälin Jesusta tapupäcul quiquinpa limayllanwan palpuchinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaymi ćhaycamul: “Yaćhachicü taytáy, tantiapäcümi rasuncälla amćhu caśhanta. Nunacuna limaśhanwan manamá iwiycaćhachicunquichu nïtacmá pimanpis śhalcuyanquichu. Aśhwanpa Diosninchic munaśhannu rasuncällactam yaćhachinqui. Chayurá má, niycälillämay ¿Roma gubirnuman alcabälacta uycunapä Tayta Dios awninchun icha manachun? Cananpi ¿pägapäcümanlächun icha manañachun?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ñatac ishcay cära capäcuśhanta yaćhalmi Jesus nila: “¿Imapïtan imamanpis palpuchiyta munapämanqui? Apamuy juc illayta licaycunäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chay uycüluptinñatacmi Jesus: “Cay illaycäćhu ¿pitan cayan? ¿Pip śhutintan limayan?” nila. Niptinmi: “Romap Puydï Mandänin Cesarpam” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nipäcuptinmi: “Chayurá Cesarpa cäcätá payman-ari uycäliy. Diospa cäcätá Diosmantac-ari uycäliy” nila. Niptinmi licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jinamanñatacmi wañücuna śhalcamunanman mana quiripäcü saduseo caśhtacunaca śhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Chaymi tapupäcula Jesusta: “Yaćhachicü taytay, Moisespa camachicuyninćhümi niñä: ‘Juc wayapa mana chuliyu ima wañucuptin'a, cäsu canmi wanücäpa śhullcanwan biudaca casaracul punta wayapanpa milayninta śhalcachinanpä’ nil. Chaynu captin'a, má, ¿imaninquitan? ");
INSERT INTO qvwNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Unayshi capäcula anćhish wawi-caśha. Chayshi mayurca walmiculcul mana chuliyu ima wañucula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jinaptinshi atïnin śhullcan chay japanyäśhäwan yapacüla. Jinalculshi chaypis mana chuliyu ima wañucuntac. Jinaptinshi chay atïnin śhullcanwanpis chaynülla pasälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chaynu lluy anćhishnintinwan pasäluptinshi chay walmipis wañucuntac. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chayurá má, śhalcamunan muyuncäćhu chay walmica ¿mayanninpa walmintan can'a anćhishnintinwan casaracüśha cayal'a?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Niptinmi Jesus: “¡Maynu pantäśham cayalcanqui Diospa limaynintapis munaynintapis mana tantiapäcuśhayquipi! ");
INSERT INTO qvwNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chay śhalcamuycäćhu umripäpis walmipäpis manañam casaracuycuna can'achu. Sinu'a janay pachäćhu anjilcunanümi capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ñatac chay wañücuna śhalcamunanpïtá ¿manachun lïgipäculanqui Diosninchic nina malluyä jaćhapi Moisesta limapämuśhanta? Wañüśhaña cayalcaptinpis ¿manachun Dios nila: ‘Ya'am cayá Abrahampa, Isaacpa, Jacobpa alawayalcäśhan Diosnin’ nil? ");
INSERT INTO qvwNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chayurá Diospá manam chincacü wañucücuna canchu; sinu'a cawsä nunallamari. Amcuna sumä pantäśhamari cayalcanqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chayćhümi Moisespa camachicuyninta jucnin yaćhachicü aśhuycamul tapunacuyäta uyalila. Chaynu allincäwan lluy cuntistaptinmi nin: “Lluypïpis mas puydïninca ¿mayannin camachicuytan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Niptinmi Jesus: “Lluy camachicuycäpïpis caymi mas puydïca: ‘Uyaliy, Israelcuna, Tayta Diosninchic jucllam. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tayta Diosllayquiman tucuy śhun'uyquitapis, llapan pinsayniquitapis, lluy callpayquitapis ćhulaycuy’ nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Juccäpis caymi: ‘Nuna-masiquita tucuy śhun'uyquiwan quiquiquitanuy cuyal licaycuy’. Cay camachicuycunäpi mas puydïnin'a manam juc canchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Niptinmi chay nunaca: “Allintam niycamanqui, yaćhachicü taytáy, rasunpa jucllayllam Diosninchic'a. Paypïta manam juc canchu. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nishayquinüpis llapan śhun'unchicta almanchicta pinsayninchicta callpanchicta payman ćhulaycuśhanchic'a, jinaman nuna-masinchicwan cuyanacuśhanchic'a mas allinmi Diosta alawayninchicwan uywacunap yawarninta uycuśhanchiccäpïtá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chaynu allin tantiayninwan nïluptinmi: “Tayta Diospa gubirnunpïta manamá calućhüchu cayanqui” nila. Chaypïta manamá mayanninpis mastá tapućhaculcälañachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","36","Chaypi Diospa chuya wasinpa patyunćhu Jesus yaćhayächilmi llapanta tapula: “Moisespa camachicuyninta yaćhachicücunaca, ¿imapïtam ‘Salbacüca unay Mandacü Davidpa milayninpïmi’ nil nipäcun? Chaynu milayllan cayaptin ¿imapïtan David Chuya Ispiritu Salmos librunćhu limachiptin ‘Duyñümi’ ninman Diostanülä canpis? Chayćhümi: ‘Diosninchicmi munayniyu Duyñüta nin: “Cay-lädulläman taycaycamuy ćhïnishüniquicunäta maquiquiman ćhulaycamunäcama wiñay simpri uyshuycälishunayquipä” ’ niyan. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Chayurá ¿imanuypatan Salbacüca Davidpa milaynillan canman quiquin David ‘Duyñú’ Diostanülä niyaptin'a?” nin. Chayćhu nunacunäñatacmi mishqui mishquicta uyalipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ñatac chayćhümi Jesus nila: “Yan'al-lätac amcunapis cay yaćhachicücunäta atiyalcächinquiman. Paycunamá allinnin müdanacunawan müdaculcan läsacunäćhu nunacuna rispitänan-layculla. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jinalmi aśhta juntunacuna wasicunaćhüpis fistacunaćhüpis allinninpa täcunancunamanlä täcuytapis wañupacun. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jinaman japanyäśha walmicunap ima cällantapis wasintintacamalämi lacsapäcunpis. Jinaman'a licapäcunan-laycullam una-unaylä Diosta mañätuculcanpis. Caycuna sumä mućhuchishalämi capäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ñatac Diospa chuya wasinćhu illay juntucup chimpanćhu Jesus taycucuyculmi lluy nunacuna illayninta jitaycuyalcäta licapayäla. Waquin cäniyücunam achcacta jitaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chayman juc japanyäśha waccha walmi ćhaycamul ash ćhaniyu ishcay illaychallantam ćhulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chayta licalmi Jesus llapa yaćhapacünincunacta ayalcul nila: “Rasunpa cay waccha walmim lluypïpis masta uycülun. ");
INSERT INTO qvwNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Juccunacá puchüllantam uycapäcun. Cay walmim ichá cawsananpä capuśhancätalä lluyta uycülun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chay Diospa chuya wasinpi Jesus yalayämuptinmi jucnin yaćhapacünin nila: “Yaćhachicü taytáy, ¡licay, maynu sumä wasim caculläñä; jatućhaćhä lumicunawanlämi cacullañäpis!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Niptinmi Jesus: “Cayta licayalcanquimá. Rasunpa cay caśhancäćhu licachillapäpis manamá juc lumillapis caycun'achu. Lluymi pampaman muyun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaypi chay chuya wasip chimpan Ulibus ulućhu Jesus täcuyaptinmi Pedro, Jacobo, Juan, Andreswan japälla tapuculcäla: ");
INSERT INTO qvwNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Niycälimay-ari ¿imaymi chay lulacacun'a? Chay timpu ji'acaycayämuptin ¿ima siñalcunam śhamun'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Niptinmi Jesus: “Yan'al-lätac pipis ingañapäcuśhunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ya'atucul achca śhapämulmi ‘Ya'am Diospi Caćhaśhan Salbacüca cayá’ nil achca nunacunacta pantachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ñatac wicćhüpis cayćhüpis gïrrash nïcunacta uyalipäcul ama manchaculcaychu. Chaycuna pasananmi yaćhacun masqui manalä camacayca cayaptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Rasunpa chaypá nasyuncunapis malcacunapis gïrranaculcan'am. Chaynütacmi mayćhu chayćhüpis śhaśhaycunapis micuy wanacunapis jicutacücunapis cacun'a. Lluy caycuna ñacaycunap allaycuyllanlämi can'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Sumäta cuydaculcay: Malcap puydïninpa maquincunaman ćhulapäcuśhuptiquim juntunaculcänan wasicunäćhu lawćhaycälishunqui. Ya'a-laycum malcacunap puydïninmanlä ćhächipäcuśhunqui, chayćhu paycunacta ya'api willaycälinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mastá puydiyan jinantin pachäćhu allin willacuy willacuśha cananmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chaynu mandacücunap maquinman aysapäcuśhuptiqui ama llaquiculcaychu ‘Canan ¿imactatá limalicuśhä?’ nil. Chayüram Diospa Ispiritun amcunap liman'a. Ninallayquita niycäliy. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ñatac wawi-caśhacunam wañuyman ćhulaycanacun'a. Taytacunapis chulincunactam. Chulicunapis taytancunap cuntran śhalcuculculmi wañuchipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ya'a-laycutacmi lluy ćhïnipäcuśhunqui. Wañuycäcama tacyaycücäñatacmi ichá salbacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“¿Manachun willacünin Daniel isquirbila chay Sumä Millachicüman Muyuchïcäpi? Chayurá cayta lïgïcunaca, sumäta tantiapäcuy. Chay Millachicüca Diospa chuya wasinćhu licalimuptinmi, Judea-lädućhu yaćhäcunaca juclla ayipäcunan ulucunäman. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chaynütac wasinpa altuśhninćhu cäcunaca imallanta juluycunallanpäpis timpu manañam can'añachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ćhaclanćhu cäcunäpis müdanallanta juntulcü cutipämunallanpäpis timpu manañatacmi can'añachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Maynu llaquićh can'a patayu walmicunäpä, chaynütac wawinta ñuñücunäpä! ");
INSERT INTO qvwNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Caycuna tamya timpućhu mana pasananpäri Diosta ruygaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cay sumä ñacaycunanu'a cay pachap allaycuyninpïpis manam pasalachu, nïtacmi can'atacchu. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chay timpucta Tayta Dios mana mirmachiptin'a manaćh mayanpis salbaculcanmanchu; ñatac japächacuśhancuna-laycum mirmaycachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chay timpu mayanpis ‘¡Licay! ¡Diospa Salbacüca cayäñä wicćhümi, cayćhümi!’ nil nipäcuśhuptiquilätac quiriyalcanquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rasunpa salbacütucücuna willacütucücuna śhalcapämulmi imaymana milagrucunacta lulapäcul Diospa aclacuśhancunätapis atipayänülä pantachiyta jicutapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chaymi manalä imapis pasaśhancama amcunacta canan willayalcac lichcat-lichcat capäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Chay sumä ñacay timpuca pasalcullaptinmi intica wañun'a; quilläpis manañam acchin'achu; ");
INSERT INTO qvwNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","uyllurcunäpis lluyñam palpatityamun'a; janay pachäćhu lluy cäcunäpis śhaśhalin'am. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chayćhümi Rasun Nunap Chulincäta jinantin pachäćhu cä nunacunaca licapäman'a, pucutay śhun'unćhu sumä munaynïwan śhayämüta. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chayćhümi anjilnïcunacta caćhamuśhä wicpi caypi jinantin pachäpi aśhta sïlup sapinpi-camapis aclaśhäcunacta juntuchimunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Yaćhapäcuy-ari lanta tantiachimäśhallanchictapis. Pallaynincunaćhu chillquilimuptinmi tamya timpumanña ćhaycuśhanchicta tantianchic. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chaynu-ari lluy caycuna pasaśhanta licapäcul'a yaćhapäcuy janayquićhüña timpuca caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rasunpa caycuna pasan'a manaläpis cay nunacunaca camacaptinlämi. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cay allpäpis sïlupis camacällamari. Ñatac cay nishäcá manam imaypis chincan'achu; lluymi lulacacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ñatac chay śhamuná ürätam ichá nï pipis yaćhanchu. Manam quiquïpis nïtac anjilcunäpis sinu'a Taytallämi yaćhan. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","¡Lichcat-lichcat capäcuy! ¡Licaculcay! Chay muyun imay ćhämunätapis manamá yaćhapäcunquichu. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maynümari mayanpis calucta lil nunancunacta lulayniyü-camacta wasinćhu caćhaycun, jinaman täpänintapis musyat-musyat caycunanpämá. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Chayurá amcunapis musyat-musyatlla capäcuy; manamá yaćhapäcunquichu wasiyüca tardiscaman, ćhawpi tuta, wallpa wa'ay üra ütac aspi-aspiy cutimunantapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Un'aypi śhamul yan'al-lätac puñuyä imacta talïlälishunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cay nishäcá lluypämi: ¡Musyat-musyat capäcuy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ñatac ishcay muyunllañam cacuyäla Libraculcäśhan Fistaćhu Mana Libadürayu Tanta Fistapä. Chayćhümi puydï sasirdüticunäwan, yaćhachicücunaca limanaculcäla artillawan Jesusta chalalcachil wañuchipäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Waquinnincunañatacmi: “Cay fistäćhu amalä chalachishunchu; caynüpa nunacunacá yan'alćha chäcunacülunman” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ñatac Jesus Betania malcäćhu “lipra-sapa” nipäcuśhan Simonpa wasinćhümi micuyalcäla. Chaymanmi juc walmi śhamuñä caćhi lumipïtanuy uchuy butïllachaćhu sumä ćhaniyu nardo nishan pirfümicta apacuśha. Chayta paquilculmi Jesuspa umanman jillpuycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chayta licälälilmi waquincuna piñacälälil: “¿Imapätan cay-chica ćhaniyüta yan'al pampapä jinayanqui? ");
INSERT INTO qvwNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aśhwanpam juc wata trabajup ćhaninman lanticulcul lluy wacchacunacta aypuycuchwan cala” nil ñaćhaña millpälälinpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chaymi Jesus: “¿Imapïtan ancha rabyachipäcunqui? Jina chaynu cachun. Cay lulamäśhancá allinmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wacchacunawan'a imaypis cuscaćh capäcunqui munaśhayquićhu yanapaycälinayquipä. Ya'am ichá pasaypichu mana cayćhu caśhä. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay walmica puydishallanwan'a allintam lulaycaman; cay aychá pampaśha cananpämari puntaycayächin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rasunpa, allin willacuyta jinantin pachäćhu willacuśhancunaćhüpis, cay walmi lulaśhanpïpis yalpaśham can'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chaypïtam jucnin yaćhapacünin Judas Iscarioti pasacula puydï sasirdüticunäman Jesusta chalaycachinanpä limalicamü. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chayćhüshi chay puydïcunaca sumä cushicälälil illayta unanpä limalicälälin. Jinaptinmi imanuypa imay maquinman chalaycachinanpäpis Judas ashila. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ñä Mana Libadürayu Tanta Fistap allaycuyninćhümi juc malta uwishta Diospa wañuchipäcunan cala. Chay üra ćhämuptinmi yaćhapacünincuna Jesusta tapula: “¿Mayćhütan alistapämuśhä ya'anchicpis sinayta micunanchicpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niptinmi ishcay yaćhapacünincunacta Jesus nila: “Canan Jerusalenta cutipäcul yacun ipicüśha liyä wayapawan tincunqui. Paytam may lishantapis atipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wasinman ćhaycul ji'acuycuptinmi wasiyüninta nipäcunqui: ‘Yaćhachicünïmi tapucamuśhunqui: “¿Mayannin cuartuyquim yaćhapacünïcunawan cay fistaćhu micapäcunäpä cayällan?” ’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nipäcuptiquim altuśhninćhu licachipäcuśhunqui juc jatun cuartunta tuqui allichäśhacta. Chayćhu lulapämuy” nil caćhala. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Niptinmi yaćhapacünincuna malcaman ñawpapäcula. Chayćhüshi nishantanülla rasunpa lluy talilcälil alistapämula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aspicalpuyaptinñam yaćhapacünincunawan Jesus ćhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chay micuyalcäśhanćhümi Jesus nila: “Rasunpa, canan cayćhu micuśhanchiccäpïmi jucniqui ipanchäman'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Niptinmi llapanpis llaquicälälisha-cama: “¿Ya'achun icha calläman?” nil nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Niptinmi Jesus: “Aw, ćhunca ishcayniquipïtamari jucniqui. Ya'awan cusca micücälämá ipanchaman'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nishanpïmi: “Ya'a Rasun Nunap Chulincäpi isquirbishancämi lulacacun'a. Ñatac ¡imanuylä can'a chay ipanchamäca! Aśhwanpaćh mana näsimuptinpis mas allin canman cala” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chay micapäcuśhanćhümi juc tantacta apticulcul Diosta sulpäta ucula. Chaypïtam partilcul aypula: “Caymi aychá. Micapäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaynütacmi bïnüta apticulcul Diosta anradisiculcul, paycunaman uycula llapan upyapäcunanpä. Chayćhümi: ");
INSERT INTO qvwNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Cay jićhaśha yawarnïwanmá lluy-laycu muśhü limalicuśhäta tacyalpachishä. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ñatac cay bïnucta manañamá mallilcuśhächu Diospa gubirnunćhu amcunawan cusca muśhü bïnucta upyananchiccama” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chaypïtam taquicunawan alawapäcuśhanpi Ulibus nishan ulüta liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chayćhümi Jesus: “Cay tuta japalläta caćhayculmi lluy jitälälimanqui isquirbïshaćhu nishanmannuy: ‘Uwish michïninta wañüchiptïmi uwishcunaca lluy chi'ilun'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ñatac śhalcämulmi amcunapïpis puntactalä Galileaman lishä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Niptinmi Pedroñatac: “¡Masqui lluy jitälälishuptiquipis ya'a manamá imaypis caćhaycuśhayquichu!” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Niptinmi Jesus: “Rasunpa canan tutallam manaläpis ishcayta wallpa wa'amuptin quimsactaña ipanchämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Niptinmi Pedro sumälä nicuyan: “¡Masqui anwan cusca wañuná captinpis manam ipanchaśhayquichu!” nil. Chaynütam llapan yaćhapacünincunapis nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaypïtam Getsemaní nishanman lipäcula. Chayćhümi Jesus yaćhapacünincunacta nila: “Taytäwan limaśhäcama cayllaćhu-ari täcapäcuchcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nilcul mas puntascaman Pedroctawan, Jacobocta, Juanta puśhaptinmi chayćhu sumä llaqui chalälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chayćhümi: “Wañucüpä śhun'unnümi śhun'ú llaquicüśhaña cacuyan. Cayllaćhu-ari lichcat-lichcat capäcuchcay” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nilcul chay wicniscaman liculmi pampäman lawacaculcul mañacula chay śhamü ñacaycunaca mana ćhaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chayćhümi nila: “Papáy, imapis ampá manam sasachu. Munal'a śhamü ćhacćhä-yupay ñacaycunäpi julaycallämay-ari. Amatac ya'a munaśhänu'a cachunchu sinu'a ampïtaćh imanuypis can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nilcuśhanpi caśhan cutimunanpämi yaćhapacünincuna puñuywan aysachicüśha cayalcäñä. Chaymi Pedrocta nila: “¿¡Puñuyanquichun, Simon!? ¿Manachun juc ürallapis ya'awan cusca lichcat-lichcat cayta atipälanqui imamá? ");
INSERT INTO qvwNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Licchat-licchatllari Diosninchicta ruygaculcay cay śhamü llaquicuycunäćhu callpawan śhaycapäcunayquipä. Śhun'uyqui allin lulayta wañupacuyaptinpis aychayquimá mana callpayu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nilcuśhanpi yapa mañacü cutilpis chaynüllactam mañacula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yapa cutimulpis caśhan puñuywan aysachicüśha aywićhyayalcätam talïlun. Chaymi imaniytapis atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Chaypi Jesus yapa mañacuśhanpi quimsacta cutilcamul yaćhapacünincunacta nila: “¿Jinallachun puñuycällaćhu cayalcanquiman, imatá? Rasun Nunap Chulincäta jucha-sapap maquincunaman ćhulaycamänan üraca ćhämunñamá. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Śhalcapäcuy! ¡Licuśhun! ¡Ipanchamänïca cayta ji'acaycayämunñam!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Chaynu limayällaptinlämi yaćhapacünin Judas nishan puydï sasirdüticunap, camachicuyta yaćhachicücunap, Israel prinsipal yaśhacunap caćhaśhan achca nunacuna caśhpicunawan, ispädacunawan sumä armädu-cama ćhälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ipanchä Judasñatacmi yaćhachilaña “Muchaycuywan limaycuśhäcäta sigüructa chalalcul aysapäcunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chaymi ćhämul-pacha Jesusman aśhuycul: “Taytalláy” nil muchaycul limaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jinaptinmi puśhamuśhan nunacunaca Jesusta lluy chalacälälila puśhapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ñatac chayćhu jucnin yaćhapacüninmi ispädanta jululcul puydï sasirdütip uyway nunanpa linlinta pasächin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chayćhu Jesusmi nila: “¿Ya'a suwachun imam calá caynu caśhpiqui ispädayqui aysacälälisha puśhapämänayquipä? ");
INSERT INTO qvwNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Walan-walan Diospa chuya wasinćhu yaćhayächiptïpis manatac chalapämälanquichu. Ñatac isquirbishaćhu nishanmannuy lulacacunanmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Niyällaptinmi japallanta caćhaycul llapa yaćhapacünincuna ayiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Juc walaśhllañam atila calullapi säbanaśhllan catacüśha. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Payta chaläläliptinmi säbanaśhllantapis caćhaycul calanllan ayicula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesustañatacmi sasirdüticunap mas puydïninman puśhaculcäla. Chayćhümi puydï sasirdüticunäpis, prinsipal yaśhacunäpis, camachicuyta yaćhachicücunäpis lluy juntunacälälimula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedroñatacmi calullapi atila puydï sasirdütip canancäpa patyuncama. Chayćhümi täpä wardiacunawan cusca unupacuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wasi lulićhüñatacmi sasirdüticunäwan Cunsïjup puydïnincuna ima mana allintapis ashiycälila Jesus wañuchisha cananpä. Jinalpis manam talipäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Masqui yan'al tumpayninwan achca nipäculpis quiquincunap limaynincunam juc-jucman iwinaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Chayćhu waquinnincunam: “Cay nunam yaćhachiñä: ‘Nunacunallap lulaśhan Diospa chuya wasinta tunilculmi quimsa muyunllacta jucta śhalcächishä mana nunacunallap lulaśhantanüchu’ nil” nicuyalcanlä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Masqui chaynu nipäculpis juc-jucmanmi limaynincuna iwinaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chayćhümi chay puydï sasirdütica śhalcalcamul Jesusta nila: “¿Manachun limalinqui, caynu cäraycuyäśhuptiquipis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Niptinpis Jesus'a manam imactapis limalilachu. Chaymi puydï sasirdütica: “Rasuncäta niycamay. ¿Amchun Diospa Caćhaśhan Salbacü Chulinca cayanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesusñatacmi: “Aw, nishayquinümi. Jinamanmi Sumä Munayniyu Diosninchicpa munayninwan mandayätapis, chaynütac janay pachäpi pucutaypa ćhawpinćhu Rasun Nunap Chulinca śhayämütapis licapämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nïluptinmi puydï sasirdütica müdananta laćhyalcul ñaćhaña imanacülunpis: ");
INSERT INTO qvwNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Quiquinchic linlinchicwan uyaliyalñá, ¿ima mastañam munaśhun? Canan lluypis uyalinchicmi quiquinpa shiminwan Diosninchicta jalutacuśhanta. ¿Canan'a imanipäcunquimá, taytacuna?” nin. Niptinmi lluypis: “¡Chay'a wañuchisha cachun!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Waquinnincunañatac ñawinta bindacaycälil ima tuwapäcuyalcan: “Yaćhätucü, má, ¿mayannïshi tacapäcuñac?” nilcul nilcul tacaypa camacapäcula. Wardiacunäpis cäraćhü-camam lapyapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ñatac patyu lulićhu Pedro cayaptinmi, puydï sasirdütip sirbïnin walmi ćhämun. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Paymi Pedro unupacuyaptin alli-allicta licapaycuśhanpïta nin: “Nazaret-lädu Jesuswan pulï-ari ampis cayanqui ¿aw?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Niptinmi Pedro: “¿Mayanpïćha limacunquipis? ¡Manam ya'a lisïchu!” nicuyan. Nilcul waśha puncuman yalayämuptinmi wallpa wa'amun. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ñatac chayćhu cayäśhanta licalculñatacmi chay walmica yapa juccunätapis nicuyan: “Cay nunäpis Jesuswan pulï-ari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Niptinmi Pedro yapañatac: “Manam lisïchu” nin. Unascapïta yapañatac lädunćhu cä nunacunaca: “Am'a rasunpa jucnin puliwshï-masinćha canqui. Galilea nunäpanüllam limacuyniquipis cañä” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nipäcuptinmi Pedro janay pachätapis ñaćhaña ishpicuyan: “¡Manam chay nunacta lisïchu! ¿Pićh cacunpis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nilpuyällaptinmi wallpa yapa wa'amun. Jinayällaptinmi yalpaćhacülun: “Quimsa cutictañam ipanchämanqui wallpa ishcayta wa'amunanpá” nil nishancäta. Jinalmi llaqui-llaquicta wa'acula. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chay achicyalpuyaptinñam puydï sasirdüticunäwan, prinsipal yaśhacunäwan, camachicuyta yaćhachicücunäwan Cunsïjup puydïnincuna awninacälälila. Jinalmi maquinta ćhänaycul Jesusta puśhapäcula puydï mandacü Pilatop maquinman ćhulaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ćhächiptinmi Pilato tapula Jesusta: “¿Chayurá amlächun Israelcunäpa sumä mandänincälä cacuyanquimanpis?” nil. Niptinmi: “Anmá niyanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Niptinmi puydï sasirdüticunaca imaymanapi lluy juchachäcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chaymi Pilato yapañatac tapula: “Licay-ari, imaymanacta niyalcäśhuptiquipis ¿manachun limalinqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Niptinpis Jesus manam imallactapis nilachu. Jinaptinmi Pilato licapayllaman camäśha cacuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ñatac chay fistaćhu'a watan-watanmi wićhaläcäpi jucnin aclaycapäcuśhancäta caćhaycapäcunan cala. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chaypunmi Barrabas śhutiyu nuna masannincunawan Romap puydïninpa cuntran śhalcapäcuśhanćhu nunacta wañuchishanpi carsilcäćhu wićhalayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaymi Pilatocta llapa nunacunaca mañapäcula custumrinmannuy jucninta caćhaycachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nipäcuptinmi Pilato: “Am ¿Israelcunap mandäniquitachun caćhaycunäta munapäcunqui?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Caynu nila yan'al ćhïnicuypi maquinman puydï sasirdüticuna ćhulaycamuśhanta tantialmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chay niyaptinpis chayćhu cä puydï sasirdüticunämi lluy nunacunäta jicutäcuyäla Barrabasta caćhaycachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jinaptinmi Pilato: “Chayurá ¿imanäśhätan Israelpa puydï mandacünin nipäcuśhayquiwan?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Niptinmi lluy nunacunaca lüyatityacuyalcan: “¡Chacatäluy! ¡Chacatäluy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Niptinmi Pilato: “¿Ima juchactatan luläla wañuchisha cananpä?” nila. Niptinpis mas mastañam lüyatityacuyalcan: “¡Chacatäluy! ¡Chacatäluy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jinaptinmi Pilato nunacunäwan allinpa licachicuyninwan Barrabasta caćhaycächila; Jesustañatacmi ichá asutiwan camacaycachil chacatäśha cananpä ćhulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jinaptinmi cachacucunaca cuartilman puśhäluptin chayćhu llapan cunćhacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chayćhümi jatun yana-nilä puca catacunwan müdälächin; caśhapi curunacta shimpalcälil umanmanpis ćhulälälin. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jinacalcälilmi asipapäcunan-laycu: “¡Wiñaypä cawsachun Israelcunap puydï mandacünin!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nilcul nilculmi, Jesusta caśhpiwan umaćhü-cama wipyapäcula, tuwapapäcula, ñawpäninmanpis un'ulätucuycul “alawäśhun” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chay lluy imaymanacta burlacalcälilmi chay catacunta uśhtilcälil caśhan müdananwan müdachipäcula. Jinalcälilmi waśhamanña julapämula chacatä puśhapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","22","Chay yalayalcächilmi Cirene malcapi Simon ćhaclanpi cutiyämüwan tincülun. (Paymi Alejandrop Rufop taytan cala.) Paytam munäta mana munäta Jesuspa curuśhninta śhawalcachil Golgota nishanman ćhälälin. (Golgota ninan'a uma tullu canan ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chayćhümi bïnuctawan mirra nishanta tallulcälil Jesusta uycuptin pay'a mana munalachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jinaptinmi chacataycul Jesuspa müdananta aypunaculcänanpä cachacucunaca chüsanaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chay chacatäśhan üra altu intiñam cala. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ñatac imapi wañuśhanpis isquirbisham cala: “Israelcunäpa Mandäninca” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jinamanmi wicninman cayninman ishcay suwacunacta chacatälälila. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Caywanmi Diospa shiminćhu “Suwacunawan tincuchisham can'a” nishanca lulacäla.˼ ");
INSERT INTO qvwNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chayninpa pasäcunäpis ñuquicaćhaśhtinlämi: “Am Diospa wasintapis tunilcul quimsa muyunllacta śhalcachïca, ");
INSERT INTO qvwNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","má, chaypi ji'alpamul quiquiquitari salbacuy” nil burlapapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chaynütacmi puydï sasirdüticunäpis, camachicuyta yaćhachicücunäwan lluy burlapapäcula: “Juccunactam ichá salbätucuyan; quiquintañatac mana atipanchu. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chaynu Diospa Salbacüninca cacuyal'a, Israelpa puydïnin cacuyal'a, má, ji'alpamuchun-ari quirinanchicpä” nishtin. Chay-lädunćhu chacataläcunäpis ruydupapäculatacmi. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chayćhümi jinantin pachaca ćhawpi muyunpi aśhta tardi mishquipay üracama lluy tutapälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chay ürallatacmi sumä callpawan Jesus: “¡Eloi, Eloi, lama sabactani!” nila. (Cay ninan'a “Dioslláy, Dioslláy ¿imapïmi caćhaycämanqui?” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chay uyalïcunämi waquinnin'a nipäcula: “Diospa unay willacünin Eliastaćh ayayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chayürallatacmi waquinnin pasacun millwacta wilu caśhpiman wataycul ćhacćhä bïnuwan chapuycamul śhu'uycachinanpä. Chayćhümi jucnin “Jina cachun. Má, Elias śhamun'achuśh ji'alpachinanpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesusñatacmi apalcaćhalcul pasacalpula. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pasacalpullaptinmi Diospa chuya wasinćhu sumä chuya cäcäpa lacta-lacta curtïnan quiquin ćhawpipi laćhyälun. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ñatac chay Jesuspa chimpanćhu cä puydï täpäca apalcaćhaśhanta uyalil imanuypa wañuśhantapis licalmi: “Rasunpamá Diospa Chulin pay cañä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cay pasaśhanta ishcay quimsa walmicunallam calullapi licapapäcula. Paycunaćhümi Magdala malcapi Maria, Josëpa Jacobop maman Maria, Salomëpis cala. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Paycunamari Jesusta unay sirbipäcula Galilea-lädućhu. Jinaman chaypi Jerusalenman śhamü juc walmicunapis paycunawan cuscatacmari licapayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chay fistanpa alistacunan tardi wispiran allaycunanpämi ji'acaycayämulaña. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ñatac Arimatea-lädu Josë'a quijacunapi jucnin licäninmi cañä. Paymi alcayäñä Diospa gubirnun Israelman ćhämunanta. Jinalmi alli balurwan Pilatoman lila Jesuspa cuirpunta mañä. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chayćhu mañaptinmi Pilato licapayllaman camäla rätulla wañuśhanpïta. Jinalmi cachacucta ayalcachimul rasunpa wañüśhaña caśhantapis licachimula. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chaynu caśhanta willaycuptinmi Josëman ayäta uycachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaymi José curuśhcäpi ji'alpalcachimul, lantishan fïnunnin säbanaśhwan pitwilcul a'aćhu ućhcüśha maćhayman chutaycula. Jinalculmi jatun palta uylu lumicta cućhpaycachil wićhaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ñatac chayman chutaycuśhanta Magdalapi Mariawan, Josëpa maman Maria licapayalcälam. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chay warda muyun pasäluptinmi Magdalapi Mariawan, Jacobop maman Maria, Salomëwan liculcäla pirfümicta lantipacamü Jesuspa cuirpunta llusilpamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Jinalculmi chay wäla simänap allaycuynin muyuncäćhu intica chipchilcayämuptin Jesus pampaläśhancäman liculcäla “¿Chay jatun lumïta pićh aśhüchipamäśhun?” ninacuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Chay ćhälälinanpämi jatun lumica juc-läduman aśhüchisha cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chayćhu yaycunanpämi chay chutaläśhancäpa allïnin-lädućhu täcuyäñä juc müsu yulä-yulä müdanayu. Chayta licälulshi manchalicucuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jinaptinmi chay müsuca nin: “Ama manchacalcämaychu. Nazaret-lädu chacatäśha Jesusta ashiyalcäśhayquita yaćhayämi. Pay'a manam cayćhüñachu, cawsämuśhañam. Licaycäliy-ari chutaläśhancätapis. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Canan-ari wayra lil willapämuy yaćhapacünincunacta Pedrontinta: ‘Jesusshi Galileacta amcunapi puntactalä lin'a. Chayćhüshi pay nishanmannuy tincuycälinqui’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Niptinmi mana imanaytapis atipal chucchuśhtin manchapacüśha mana pictapis willapacul wayra-wayra ayiculcan. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chay simänap allaycuynin dumingu muyun śhalcamuśhan wälam Jesus licalimula puntallactá anćhish Satanaśhpa maquinćhu cayaptin sänachishan Magdalapi Mariaman. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Paymi licälul-pacha Jesuspa yaćhapacünincunaman willacü pasacamula, paycunapis wa'aśha llaquisha Jesuspi cayalcaptin. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ćhaycul “¡Cawsämuśha caśhanta licälümi!” niptin manam quiripäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chay muyun ishcay yaćhapacünincuna malcapi caluscacta liyalcaptinmi paycunap ñawpäninćhüpis Jesus jucmannuy muyulcul licalïlun. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lisïlälil-pacha juccunäman willaycü cutipämuptinmi paycunapis mana quiripäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chay tardillatacmi ćhunca jucnintin yaćhapacünincuna mïsanćhu miculcaptin Jesus yapañatac licalïmula. Chayćhümi lluy millapäla, licäcunaca maynu willaptinpis mana quiripäcuśhanpi. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nilculmi Jesus: “Lipäcuy jinantin pachäćhu cä nunacunäman cay muśhü allin willacuycäta willaculcä. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipis chalapacamal bawtisachicücá salbaśham can'a. Mana chalapacamäcunäñatacmi ichá cäraycüśha capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Rasun ya'aman chalapacamäcunacá uyaypam: achatup maquinćhu cäcunätapis caćhaycachipäcun'a, juc limaycunaćhüpis limapäcun'a, ");
INSERT INTO qvwNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","culibraycunacta aptiptinpis, bininucta upyaptinpis manam imanan'apischu, ishyäcunactapis yatayculmi sänachipäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chaypïtam Jesusninchic janay pachäta cuticul Diospa allïninman taycula sumä mandacü cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chaypïtam yaćhapacünincuna intiru malcaman willacü yaluyta allaycapäcula. Quiquin Jesusninchicñatacmi willacuynin rasunpa caśhanta camalaycachinanpä imaymana milagrucunawan lulachila.˼ ");
INSERT INTO qvwNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Imam unay licäcunaca willaśhantanümi yaćhachishantanümi achca nunacuna manyallapi isquirbiycaćhapäcula ya'anchicwan pasaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Chaynümi ya'apis allinpa lical Jesuspi isquirbimuc, cuyaśhá Teofilo. Chaymi yaćhä nunacunacta imanuy caśhantapis tapucul, lulayämú tuquicta allaycuyninpïta yaćhachishuśhayquica rasunpa caśhanta yaćhalpunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judeacta Herodes mandaśhan timpućhümi, juc nuna Zacarias śhutiyu cala. Paymi sasirdüti caśhta Abiaspa ayllun cala. Chaynütac walmin Elisabetpis sasirdüti Aaronpa caśhtanpa ayllun cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ishcayninmi Diospa ñawpäninćhu alli-cama capäcula, Diospa camachicuyninta cäsucul lulä-cama. Chaymi lluy nunapapis allinpa licaśha cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ñatac paycunam mana chuliyu awquishyapäcula, walmin mana waćhacuptin. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Chaypïtam juc muyunćhu'a Diospa wasinćhu sasirdüti cayninćhu lulaycuna Zacarias particunacta tücälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chay jinaptinmi paycunap custumrinmannuy tücachinacuptin Zacariasta tücäla Diospa wasinćhu insinsiucta mismichimunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pay chay lulićhu insinsiucta mismichimuśhan üram llapa nunacunaca waśhallaćhu Diosta mañacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chay insinsiu mismichipäcunan allïnin-lädućhümi juc anjil śhäcuyäñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chayta licälulmi Zacarias manchalicucuyal mana imanaytapis atipälachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jinaptinmi anjilca: “Ama manchacamaychu, Zacarias. Diosmi mañacuyniquita ćhasquishunqui. Chaymi walmiqui juc walaśhta waćhacun'a. Paypa śhutintam Juanta ćhulanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pay näsimuptinmi ampis nunacunapis cushiculcan'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jatunyälulñatacmi Diospa ñawpäninćhu allin nuna caycun'a. Manam imaypis upyaycunactá uchucllapis pulicun'achu, ñatac mamanpa patanpi-pacham Chuya Ispiritup munayninćhu can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Chaymi llapa Israel malca-masiquicunacta Diosninchicman cutichimun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cay chuliqui Juanmari lin'a Diospa munayninwan Eliasnüpis alli jiniyuwan Diospi willacuśhtin. Chayćhümi amistachin'a chulintawan taytanta. Diosta mana cäsucücunätapis cäsucümanmá muyuchin'a. Chaynüpamari caminucta allichayä-yupaypis nunäta allichacachin'a quiquin Duyñunchic ćhämuptin ćhasquiculcänanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Niptinmi Zacarias anjilcäta nila: “¿Ima? ¿Imanuypatan cay lulacacunman, cuscäpïpis awquishña cayalcaptí? ¿Chaychun canan chulí licalinman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Niptinmi: “Gabrielmi ya'a cá; Diospa ñawpäninćhu cayäcämi. Chaymi ya'acta caćhamäla chuliqui cananpä willaycachimä. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Caynu mana quirimaptiqui'a cananpi shimiqui wićhacacuchun aśhta chuliqui näsimunancama” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chay waśhaćhu cä nunacunäñatacmi: “¿Imañatan pasämun cay üracama mana yalamunanpä?” nishtin alcapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chaynu alcayalcaptinmi unascactá Zacarias yalämun shimin wićhacäśha siñaśhchayllap limaśhtin. Chaynüta licälälilmi llapanpis tantiälälin suyñuyninćhünu Dios limapämuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chaynu chayćhu lulanancunacta lluy camacalculmi ishcay quimsa muyuncunapïtá wasinta licula. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaypïtam walmin Elisabet rasunpa patantin licalïla. Chaymi picha quilla mana maytapis wasinpi yalupacul sumä cushisha cacula: ");
INSERT INTO qvwNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Diosmi wawicta talichiman mana mayan nunapis jamuyämänanpä” nil pinsaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet ñä süta quillantaña patanwan liyaptinmi Dios caćhamula anjil Gabrielta Galileaćhu Nazaret malcäman. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chay malcaćhümi yaćhala manalä wayapa lisï lasac wamla Maria śhutiyu. Paymi casaracunanpä limaśha cala Israel malcap unay mandänin Davidpa caśhtanpa ayllun Josëwan. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chayćhümi Mariacta anjilca nila: “Cushicuy, Maria. Diosmi anwan cayan. Anmi lluy walmicunapïpis Diospä sumä allin licaśha canqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Niptinmi Maria pinsatïbu cayäla “¿Imactatan caywan niyäman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chaymi anjilca: “Maria, ama manchacuychu. Diospa llaquipayninćhümi cayanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chaymi patayu licalil walaśhta waćhacunqui. Jinalmi Jesusta śhutichanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Sumä cayninpïtamari ‘Sumä Munayniyu Diospa Chulin’ nipäcun'a. Jinamanmi quiquin Dios unay mandacü Davidpa pudirnin ćhulaycun'a cay Israel malcäćhu mandacuynin mana imaypis camacänanpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Niptinmi Maria: “¿Chay'a imanuypam canman manaläpis wayapacta lisiyaptí?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niptinmi nila: “Maria, Diospa Ispiritun śhamulmi, Sumä Munayniyu Diospa munaynin llantuycuy-yupay yan'anülla patayüta licalichishunqui. Chaymi chay chuya iñachayquita quiquin Diospa Caćhamuśhan Chulin nipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mana quirimaptiqui'a ‘machüra walmi’ nilcul jamuyapäcuśhan caśhtayqui Elisabetpis süta quillantañam patanwan liyan masqui chacwaśhña cayalpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diospá rasunpa, manamá sasachu ima lulaypis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Niptinmi Maria: “Paypa uyway nunanmi cayá. Nimäśhayquinu Dios lulachun ya'awan” nila. Caynu nilcuptinmi anjilca liculaña. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay ishcay quimsa muyuncunapïtam Maria lila wayra wayra Elisabet yaćhaśhan Judea ulucunäćhu cä malcaman. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","41","Ñä Zacariaspa wasinman ćhälul: “allinllachun” niycuyaptinmi Elisabetpa patan jucnüpa cuyülun. Chayćhu Chuya Ispiritu limachiptinmi Elisabet Mariacta nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Llapan walmicunapïtapis mas allinninpa licaśham canqui patayquićhu wawintinpis Diosninchicpá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nishanpïmi: “¿Pitan cá ya'a Taytanchicpa maman ćhaycamumänanpä? ");
INSERT INTO qvwNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Shimiquita musyälul-pacham cushicuypïta patäćhu wawïpis jucnüpa cuyülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cushicuy Diosninchic nichishuśhayquita quiricuśhayquipi, willaycachishuśhayquinu amćhu lulacächun” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Niptinmi Maria nila: “¡Lluy śhun'üwanmi Diosnïta alawá jatun cayninpi! ¡Cushicümi Salbamäninchic Diosninchicpïta! ");
INSERT INTO qvwNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","¡Maynu allinpa licaśham ya'a cá Diospa uyway nunan cayalpis! Cananpïtá ‘Diospa allinpa licaśham canqui’ nilćha nipäman'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pay imapäpis aycapäpis puydï Diosnïmi ya'awan caynu lulaycun. Manam paynu'a juc Dios canchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chaymi nishantanülla lulä nunacunäpä imaypis llaquipayniyu cayan aśhta imaycamapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Paypá munalinallanmi ima lulaycunapis. Nunatucücunap imapis lulay pinsaśhancunacta lluy pirdichïcämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Maynu yaćhayniyu jatun mandacücunactapis lluy julalcachil mana sumä yaćhayniyu nunacunacta mas puydïninpa muyuchïcämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mana micuyniyu nunacunactapis rïcuyächïcämi. Maynu cäniyütapis pasaypiman wacchayächïcämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aclacuśhan Israel malcanta mana imaypis un'aycul llaquipaywan licaycücämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chaynu cananpämi unay awilunchic Abrahamta lluy milayninpa wiñay simpripä limalicamälanchic. Chaymi rasu-rasunpapis ya'anchicwan canan lulacayan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Chayćhu chaynu Elisabetwan quimsa quillanuy caycuśhanpïtam Maria wasinta cuticula. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chaypïtam Elisabetpa quillan ćhämuptin ishyacula walaśhta. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chayćhümi Dios juc wawicta uycuśhanta yaćhälälil śhapämula llapa aylluncunapis malca-masincunapis Elisabetwan cusca cushiculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ñä wawin simänaycuyaptinmi apapäcula unanchaycachï custumrinmannuy. Chayćhümi lluypis munapäcula iñachap śhutin Zacarias cananta. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Elisabetñatacmi: “¡Manam! Imanicuptiquipis Juanmi śhutin callan'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Niptinmi nunacunaca nipäcula: “Chaynüta śhutichayänayquipä ¿pï aylluyquitan Juan śhutiyu cayan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nipäcuptinmi Zacariasta tapupäcula, ima śhutin canantapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chaymi uchuc tablallaćhu siñaśhchayllap mañalcul “Juanmi can'a” niyäta isquirbila. Chaynu luläluptinmi: “¿Imactaćhá caywan lulacunpis?” nil licapayllaman camälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chay ürallam Zacariaspa shimin paćhyalcamuptin Diosta alawäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Caycuna pasacuyaptinmi llapa malca-masincunapis: “¿Imatan cay?” nil turbäśha quïdälälin. Caycunapïmi intiru Judea altu malcacunaćhüpis limaylla cacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chaymi llapan nunacunäpis śhun'unćhu niculcäla: “¿Imalä chay walaśhca can'a? Diospa maquinćhümi sigürupis cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacariasñatacmi Chuya Ispiritup munayninćhu cayal shimin paćhyäluptin nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","70","“¡Maynu tuqui allinmi Israel malcap Diosnin'a malcantinta salbaycamänanchicpä! Sirbïnin mandacü Davidpa caśhtanpïtam salbaycüninchicta caćhamumanchic. Unay aclacuśhan willacüninwan willacachimuśhannüllam caycuna ñawinchicćhu lulacayanña. Caynu lulacananpämari limalicamälanchic. Chaymi nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","72","‘Amcunactam imaypis llaquipaycuśhayqui. Chaynütacmi llapa ćhïnishüniquicunap maquinpïtapis juluśhayqui. Cay limalicuśhäta manam imaypis un'aśhächu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Cay nishannütacmi unay awilunchic Abrahamtapis: ");
INSERT INTO qvwNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Ya'am cuntra partiquipi juluśhayqui, mana pictapis manchalil sirbimänayquipä. Chayćha ñawpänïćhu walan-walanpis tuqui cawsayniyu canqui’ nil” nila. Chayta nilculmi chulin Juanta nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Anmi Taytanchicpa puntanta linqui, ïju, malcanta allichayä-yupaypis. Chaymi amta ‘Jatun Diospa willacünin’ nil nipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Paypa malcantam ‘Diosniqui juchayquita pampachayculmi salbaycuśhunqui’ nil willaycüca canqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","¡Ima sumä jatun llaquipayniyümi Diosninchic'a! ");
INSERT INTO qvwNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yanawyayä juchap jananćhu muyuyaptinchicpis juc acchiwannümi caminunchicta licachimanchic tuqui cawsayniyu pulinanchicpä” nilculmi niyta camacäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chayćhütacmi Juanpis wiñala Diospa munayninćhu. Jinalculmi chunyänincunaćhu yaćhamula Israel malca-masincunawan lisichicunancama. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chay timpum Cesar Augusto śhutiyu nuna llapan nasyuncunäćhu mandä cayal nila: “Llapan nunacunaca lluy sinsuchiculcächun” nil. ( ");
INSERT INTO qvwNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cay sinsum wamä lulacala, Cerenio śhutiyu nuna Siria nasyuncäćhu mandacü cayaptin.) ");
INSERT INTO qvwNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chaymi sinsuchiculcänanpä unay caśhtanpa malcanta lluypis lipäcunan cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chaynu Davidpa caśhtan calmi, Josëpis Galileaćhu cä Nazaret malcapïta lila Davidpa näsishan Judeaćhu cä Belen malcaman. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Chaymi José lila casaracunanpä limaśhan Mariawan. Paymi patantinña chaypun'a cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jinaptinmi Belen malcäta ćhäluptin Mariacta dulurnin chalälun. Chayćhümi ishyacunanpä mana mayca wasipis jäculachu. Chaymi uywacunap watalänallanćhu wamä wawinta ishyacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chaynu ishpiculculmi uywacunap mućhcanman iñachanta lluy illpulcul ćhaćhaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chaypinshi chay tuta Belen malcap wicniscanćhu uwish michïcuna uwishnincunacta täpalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jinalcaptinshi paycunap ñawpäninćhu juc anjil licalïlun. Chay muyülïninćhüpis Diosninchicpa sumä cayninshi chipyayäñä. Chayta licälälilshi alli-allicta manchalicucuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Chaynacuyalcaptinshi anjilca nila: “Ama manchaliculcaychu. Ya'am apayämú amcunapä juc muśhü willacuyta jinantin nunacunäwan sumä cushiculcänayquipä. Canan'a amcuna-laycu ñam näsïlunña Belen malcäćhu Diospa Salbacünin Duyñuyqui. Cay willacuywan'a llapan nunacunäćha lluy cushiculcan'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Canan lilmi uywacunap mućhcanćhu juc iñachacta, illpüśha jitalayäta talipäcunqui. Chaypam tantiapäcunqui pay Salbacüca caśhanta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chaynu limayällaptinlämi altu sïlupi juc anjilcunapis licalilcamul Diosta alawäcuyalcan: ");
INSERT INTO qvwNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Altu sïlućhu Diosninchic alawaśha cachun jatun cayninpi! ¡Chaynütac cay allpäćhu mayantapis allinpa Dios licaśhancunawan jawca cawsay cachun!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","16","Chay ñä anjilcunaca altu sïlüta cuticulcaptinmi chay uwish täpäcunaca: “¡Má, acuchun, apuray Belenta lishun! ¡Licamuśhun Dios willachimäśhanchiccäta!” limanaculcul mana-mana liculcäla. Chaynu ćhälälilshi talïlälin Mariactawan, Josëta, chaynütac iñachätapis uywa watalänanćhu illpuśha jitalayäta. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jinalshi chayćhu willapacula anjilca nishancunacta. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chaynu willapacuptinmi chayćhu llapan uyalïcunaca licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lluy caycunacta mana un'al Maria śhun'ullanćhu uywayalmi aybistá chayman pinsalayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chay anjilca imam willaśhantanuy talilcälilñatacmi uwish michïcunaca cuticulcäla Diosta alawaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chaypi iñachaca ñä simänaycuyaptinmi custumrinmannuy unanchachï apala. Chayćhümi śhutinta ćhulapäcula “Jesusta” anjil Gabriel puntacta nishantanuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ñatac Moisespa camachicuyninćhümi nila: “Mayan walmipis waćhacul'a tawa ćhunca muyunmi Diosta yapa sirbï allaycunanpä alcanman” nil. Chaynütacmi nila: “Wamä wawin walaśh näsimücá Tayta Diospämi lluypäpis can'a” nil. Chaymi Mariap muyunnin cumplimuptin Jesusta apapäcula Jerusalen malcäta Moises camachishannuy “Diosní, cay wawí ampämi can'a” nil uycü. Chaymi Moises camachishannüpis Maria Diosta caśhan sirbï allaycunanpä ishcay palumacta Diospa cañaycapunanpä apala. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chaypunmi chay Jerusalenćhu juc awquish Simeon śhutiyu cayäla. Paymi Diosta sumä manchacü allin nuna Chuya Ispiritup munayninćhu cayäla Israelpa Salbacünin śhamunanta alcaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Payta Chuya Ispiritum musyachiñä manaläpis wañul Diospa Caćhaśhan Salbacüninta ñawinwan licananpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chaynu cayaptinmi Chuya Ispiritu puśhala Diospa chuya wasinta. Chayćhu Jesusta taytancuna camachicuymannuy Diospä unanchayächishanta licalculmi ");
INSERT INTO qvwNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","iñachäta malaculcul Simeon nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Canan'a, Dios Taytalláy, jawcañaćh wañucuśhäpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nimäśhayqui salbänïta ñawïwan ñam licaycüña. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Anmi caćhamulanqui llapan nunacunaca lisiycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Chaynütacmi mana-Israelcunapäpis pay'á juc acchinu bïdanćhu acchin'a. Paypam Israel malcayquipis sumä rispitaśha can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chay Simeon wawinta alawaptinmi, Josëwan Maria licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chayćhu Simeon paycunapä Diosta mañaculculmi Mariacta nila: “Sumä uyaliy cay nishäta. Cay walaśhmi waquin Israelcunapá cawsaypä can'a, juccunapañatacmi wañuypä can'a. Pay Diospa pudirnin caśhanpïtam waquinnincuná cuntran śhalcapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chaynapäcuptinmi śhun'unćhu ima pinsaśhanpis lluy camaläcamun'a llapan nunapapis. Lluy caycunam jïru-caśhawan tucsiyäśha-yupaypis śhun'uyquita nanachishunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Chay Diospa chuya wasinćhümi cayälatac Diospi willacü Ana śhutiyu chacwaśhpis. Paymi Fanuelpa chulin Ashirpa ayllunpïta milamü cala. Pusä ćhunca tawa watayu walmi anćhish wata cuscaśhanpïshi japan quïdäla. Chayshi Diosllactaña sirbïcü cala. Chaymi walan-walan Diospa chuya wasinta lil mañaculapis ayunalapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chayćhümi Simeon śhamuśhan üra paypis ćhämula Diospa chuya wasinman anradisicunanpä. Chayćhu iñachäta licälulmi willapacula paynüpis Israel malcanta salbananpä alcäcunäta. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chaypïta Mariawan José, Dios camachicuynincunaćhu nishanta lulalcälilmi cuticulcälaña Galileaćhu Nazaret malcanman. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chayćhümi walaśhca jatunyayäla cuncu-cuncu, callpa-sapa mas fisyunllan. Imacunaćhüpis Diosmi lluy yanapäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Josëwan Mariam watan-watan lipäcula Jerusalenta Egiptopi Libraculcäśhan fistanman. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus ñä ćhunca ishcayniyu watacta liyalmi, chay fistaman taytanta atila. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chayćhu ñä fista camacäluptinmi Nazaretta cuticalcämula. Jesusñatacmi taytan maman mana tantiaptin Jerusalenćhu quïdacamuñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chayćhu mana captinmi aylluncunacta tapucul, lisinacuśhancunaćhu payta ashila. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Manaña chayćhu talilmi Jerusalenta ashishtin cutipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ćhaycul quimsa muyunña ashilcaptinmi Jesus'a Diospa chuya wasinpa patyuncunaćhu, Moises isquirbishanpi yaćhachicücunawan tapunacuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chay yaćhachicücunam sumä admiracüśha capäcula Jesuspa yaćhayninpïta llapan tapuśhancunacta allin yaćhaywan cuntistaśhanpi. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chaynu jawca tapunacuyäta talïlälilmi Maria nila: “¿Imanayanquitan cayćhu taytayquiwan pulá caynu llaquisha ashiyalcaptí?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Niptinmi Jesus: “¿Imapïtan wictapis caytapis yaycul ashilcämanqui? ¿Manachun Taytäpa wasinćhu ucupädu canäta yaćhapäcunqui?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","51","Chay niptinpis paycuná manash tantiapäculachu ima nishantapis. Lluy caycunactam maman śhun'unman ćhulal uywala. Jinalcul Jesuswan cuscan Nazaretta cutipämuptinñam chayćhu taytancunapäpis cäsucü cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Cuncu-cuncum wiñalapis fisyunllan ima. Jinalmi Diospäpis nunapäpis maypis alawana allin cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chay muyuncunaćhu'a Tiberio nishan nunam ćhunca pichayu wataña cay jinantin nasyuncäta mandä cala. Poncio Pilatoñatacmi Judea malcap mandänin. Herodesñatacmi Galilea malcap. Chaynütacmi cay Herodespa irmänun Felipipis Ituria malcapwan Traconite malcacunap. Lisiniasñatacmi Abilinia malcap mandänin cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jinamanñatacmi Anaswan Caifas Israel caśhtacunap sumä puydï sasirdütin capäcula. Chay timpumá chunyäninćhu Zacariaspa chulin Juanta Diosninchic limapäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chaymi Juan pulila willacuśhtin Jordan mayup patanćhu malcacunäta: “Juchayquicunapi wanacul bawtisaculcay pampachäśha capäcunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chaynüpam lluy lulacala Diospa unay willacünin Isaias isquirbishancunänu. Chayćhümi nila: “Chunyäninćhu ayaycaćhäcäta uyalipäcuy: ‘Taytanchic ćhämunanpä sumäta allichaculcay. Ñatac paypa pulinanta tuquicta lulapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ulucunäta, wayucunäta, ućhcucunätapis lluyta pampatapäcuy; caminucunäta tuquiman dirichapäcuy Taytanchicta ćhasquiculcänayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jinaptinmi cay pachäćhu llapan nunaca lican'a Dios Caćhamuśhan Salbacücäta’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chay muyuncuna Juan caśhancäman achca nunacuna bawtisachicunanpä intirupïta lipäcuptinmi nila: “Pasaypi culibray caśhtacuna, ¿pitá nishulanqui ‘¡Diospa castigun janayquićhüñam cayan ayicunayquipä!’ nil? ");
INSERT INTO qvwNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Juchayquicunapi wanaculcäśhayquitari camalachipäcuy. Icha ‘Abrahampa ayllun caynïwanmi Diosninchicpa allinña cayá’ ¿niyanquichun, imam? Dios munal'a cay lumicunapïtapis Abrampa ayllunman muyuchinmanmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jinaman paypa ächan listuñam cayan jaćhacunäta sapipi cuchünanpä. Chay mana alli wayuyniyu jaćhactamá wicapalcachil cañan'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Niptinmi nunacunaca tapupäcula: “Chayurá ¿imactatan lulapäcüman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nipäcuptinmi: “Mayanpis ishcay müdanayücá jucnin müdananta uchun mana müdanayücunäman. Chaynütac lulaycäliy micuypi pulïcunawanpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chaynütacmi Roma gubirnupä alcabäla mañawshïnin nunapis bawtisachicuyta munal Juanman lilcul: “Taytay, ya'acuna ¿imactatan lulapäcüman?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Niptinmi: “Mañapäcuy nishuśhallayquita” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaynütac cachacucunapis tapuculcäla: “Taytay, ya'acuna, ¿imactatan lulapäcüman?” nil. Niptinmi: “Ama pictapis aminasacuyniquiwan'a nïtac yan'al imamanpis artilcul'a alafirsa quitacuychu. Cay lulaśhayquinu'a päguyquiwan-ari cuntintaculcay” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Caynu allinta limaśhanpïmi llapan nunacunäpis: “¿Paypisćha Diospa Caćhamuśhan Salbacüca?” nil pinsapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chaymi Juan llapanta: “Ya'a yacullawanmi bawtisapäcuc. Ya'ap ipäta śhamücämi ichá Chuya Ispirituwan ninawanpis bawtisapäcuśhunqui. Pay'a ya'apïtapis mas munayniyu captinmi ya'a mana bälïchu nï camächu śhucuyninpa watullanta pasquiycunalläpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ñatac trïgucta waywachï nunanümi pay'a śhayämun, lluy nunacunäta cäraycunanpä. Waywalcachilmi trïgucta pilwanman ćhulaycun'a; amuntañatacmi wiñay simpri nina waläcäman jitaycun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chaynu imaymanawan anyapalmi allin willacuyta willala. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jinamanmi mandä Herodesta imaypis piñapäla: “Irmänuyqui Felipip walmin Herodiaswan caynu cuscacuycuśhayqui manamá allinchu” nil. Jinamanmi juc mana allin lulaynincunapïtapis piñapäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jinaman Juanta carsilcämanlämi wićhaycächilapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Caynu carsilman manalä wićhächiptinlämi Juan chaypun nunacunäta bawtisayäla. Chayćhümi Jesus ćhaycamul bawtisachicula. Jinalcul Diosta mañacuyaptinmi ");
INSERT INTO qvwNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","janay pachaca quićhacacüluptin Diospa Chuya Ispiritun paypa janäninman ji'alpamula juc palumanuy. Jinamanmi altu sïlupi: “¡Maynu cushisham cayá ampïta, cuyay chulí!” nil nilpamula. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chaypïtam Jesus llapan nunäta yaćhachiyta allaycula quimsa ćhunca watantanuy liyal. Paypïmi lluy nunacunapis Josëpa chulin caśhanta pinsapäcula. Ñatac Josëpa awquilluncuna caycunam cala: Josëmi Elïpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elïñatacmi Matatpa chulin. Matatñatacmi Levïpa chulin. Levïñatacmi Melquip chulin. Melquiñatacmi Janap chulin. Janañatacmi Josëpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josëñatacmi Matatiaspa chulin. Matatiasñatacmi Amospa chulin. Amosñatacmi Nahumpa chulin. Nahumñatacmi Eslip chulin. Esliñatacmi Nagaïpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaïñatacmi Maatpa chulin. Maatñatacmi Matatiaspa chulin. Matatiasñatacmi Semeïpa chulin. Semeïñatacmi Josëpa chulin. Josëñatacmi Judäpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judäñatacmi Joananpa chulin. Joananñatacmi Resäpa chulin. Resäñatacmi Zorobabelpa chulin. Zorobabelñatacmi Salatielpa chulin. Salatielñatacmi Nerïpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerïñatacmi Melquip chulin. Melquiñatacmi Adïpa chulin. Adïñatacmi Cosampa chulin. Cosamñatacmi Elmodanpa chulin. Elmodanñatacmi Erpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erñatacmi Josuëpa chulin. Josuëñatacmi Elieserpa chulin. Elieserñatacmi Jorinpa chulin. Jorinñatacmi Matatpa chulin. Matatñatacmi Levïpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levïñatacmi Simeonpa chulin. Simeonñatacmi Judäpa chulin. Judäñatacmi Josëpa chulin. Josëñatacmi Jonampa chulin. Jonamñatacmi Eliaquimpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimñatacmi Meleap chulin. Meleañatacmi Mainanpa chulin. Mainanñatacmi Matatap chulin. Matatañatacmi Natanpa chulin. Natanñatacmi Davidpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidñatacmi Isaïpa chulin. Isaïñatacmi Obedpa chulin. Obedñatacmi Boozpa chulin. Boozñatacmi Salap chulin. Salañatacmi Naasonpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonñatacmi Aminadabpa chulin. Aminadabñatacmi Adminpa chulin. Adminñatacmi Esrompa chulin. Esromñatacmi Farespa chulin. Faresñatacmi Judäpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judäñatacmi Jacobpa chulin. Jacobñatacmi Isaacpa chulin. Isaacñatacmi Abrahampa chulin. Abrahamñatacmi Tarëpa chulin. Tarëñatacmi Nacorpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorñatacmi Serugpa chulin. Serugñatacmi Regaurpa chulin. Regaurñatacmi Pelegpa chulin. Pelegñatacmi Heberpa chulin. Heberñatacmi Salap chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salañatacmi Cainanpa chulin. Cainanñatacmi Arfaxadpa chulin. Arfaxadñatacmi Sempa chulin. Semñatacmi Noëpa chulin. Noëñatacmi Lamecpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecñatacmi Matusalenpa chulin. Matusalenñatacmi Enocpa chulin. Enocñatacmi Jaredpa chulin. Jaredñatacmi Mahalalelpa chulin. Mahalalelñatacmi Cainanpa chulin. ");
INSERT INTO qvwNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanñatacmi Enospa chulin. Enosñatacmi Setpa chulin. Setñatacmi Adanpa chulin. Adanñatacmi quiquin Dios licalichicuśhanca cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ñä Jesus Chuya Ispiritup munayninćhu cayalmi Jordan mayupi cutila. Chayćhümi Chuya Ispiritu chunyäninman payta puśhala mana allinman Satanaśh palpuyta ñacachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chayćhu tawa ćhunca muyun, tawa ćhunca tuta ayunaptinmi micanäcuyanña. Jinaptinmi Satanaśh: ");
INSERT INTO qvwNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","“Am'a quiquin Diospa Chulin rasunpa cayal'a cay lumïta tantaman muyuchiy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Niptinmi: “Isquirbisham cayan: ‘Manam tantallawanchu nunaca cawsanchic’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaypïmi Satanaśh puśhala altu uluman. Chayćhümi juclla licächin cay pachäta lluy imapis cänintinta. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Chayćhümi Jesusta nila: “Cay licaśhayqui lluy sumä caynintin ya'ap maquïćhümi cayan mayanmanpis uycunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Canan un'ulacuycul alawamaptiqui'a maquiquimanmi lluy ćhulaycuśhayqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Niptinmi Jesus: “Diospa shiminćhümi niyantac: ‘Tayta Diosllayquitam imaypis alawanqui; payllactatacmi sirbinqui’ nilmi niyan” niycülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaynütacmi Jesusta puśhala Jerusalenta. Chayćhu Diospa chuya wasinpa mas altunninman ishpilcachilmi nila: “Rasunpa quiquin Diospi śhamü Chulinca cal'a caypi, má, paćhcalpüluy. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","“¿Manachun Diospa shiminćhüpis: ‘Anjilnïcunactam caćhamuśhä paycuna maquinwan chalapäcuśhuptiqui lumiman mana uchucllapis tupacunayquipä’ niyan-ari?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Niptinmi: “Diospa shiminćhüpis niyantacmi: ‘Tayta Diosniquita munayniquiman'a ama jicutaychu’ nil” niycülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chayćhu munaśhantanu mana lulachiyta atipaculculmi Satanaśhca juc-puncama caćhaycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chaypïtam Chuya Ispiritup munayninwan Galileap malcancunaman Jesus cutila. Jinaptinmi paypïta limapäcula intiru Galileaćhu. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Chay juntunaculcänan wasincunäćhu Jesus yaćhayächiptinñatacmi llapan nunacunaca alawapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chaypïtam unay yaćhaśhan Nazaret malcanta Jesus cuticula. Warda muyunćhüñatacmi custumrinmannuy juntunaculcänan wasiman yaycuycul Diospa shiminta lïginanpä śhalcućhacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chaymi Diospa unay willacünin Isaias isquirbishan librüta julalcamul uycula. Chayćhümi quićhaycul lïgila: ");
INSERT INTO qvwNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Diospa Ispiritunmi ya'aćhu cayan. Pay quiquinmi śhuñacamäla wacchacunäman allin willacuyta willacunäpä. Llapa prïsuśha cäcunaman lil caćhaycachimunäpämi caćhamuśha cá. Jinaman aplacunacta licachinäpämi. Jucpa maquincunaćhu ñacäcunäta julunäpämari śhamulá. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Cayćhu cayá Tayta Diosninchicpa salbanan timpüta willanäpämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cayta lïgilculmi caśhallan pitwilcul cutiycachil taycucuycula. Chayćhümi llapanpis payllactaña licapäcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jinaptinmi Jesus nila: “Cay lïgimuśhäcäta uyalipäcuśhayquinümi canan ñawpäniquićhu lluy lulacacuyan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Niptinmi lluy nunapis licapayllaman camäśha “Paymi ichá allinta liman” nipäcula. Parti awniyalcaptinpis: “¿Manachun cay'a Josëpa chulillan, imatá?” nilmi nipäculatac. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chaynu nipäcuptinmi Jesus nila: “Juc limayćhu nipäcuśhannüpis: ‘Quiquiquitalä jampicüluy’ nipämanquićh. Ñatac ‘Capernaum malcaćhu lulaśhayquitanuy cayćhüpis lulal licachipämay’ nipämanquićh. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Chaymi ya'a nipäcuc: Diospi willacücunacá manamá mayanpis quiquinpa malcanćhu allinpa ćhasquishachu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jinamanñatacmi nila: “Rasunpa, Elias Diospi willacuśhtin pulinan unay timpućhümi micuy wana cacula quimsa wata partin mana nï chican tamyapis tamyamuptin. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Chaypun Israel malcanchicćhu maynu japanyäśhacuna micuypi cayalcaptinpis Dios manam willacünin Eliasta caćhamulachu. Sinu'a caćhala Sidonćhu cä Sarepta juc-lädu malcäćhu japanyäśha walmïta yanapaycachïmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chaynütacmi Diospa unay willacünin Eliseo timpućhüpis Israel malcanchicćhu achca-achca ishyayalcäla lipra ishyaywan. Manamá nï jucllantapis sänaycachilachu. Sinu'a Siria juc-lädu malcayu Naaman nunallactamari” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chay niyta uyalïlälilmi llapanpis piñacälälil: “¡Cärayqui cañächun ya'a Israelcuna cayalcaptí caynu nipämänayquipä!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nilculmi Jesusta lluy-lluy aysacuyalcan chay malcap fiyu shiwyayä a'anpi jitalpamü. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jinayalcaptinpis Jesus'a ćhawpinpa pasalculmi licula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chaypïtam Jesus licula Nazaretpïta Galileap Capernaum malcanman. Chayćhümi warda muyuncunaćhu yaćhachï cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chay yaćhachicuyninta uyalilmi sumä licapayllaman camälälil: “Sumä pudirwanmá pay yaćhachin” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chayćhüñatacmi Satanaśhpa gänaśha juc nuna cañä. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Chaymi apalcaćhaypa nicuyan: “¡Nazaret malcayu, Jesus! ¡Caćhaycälimay! ¿Imactatá ya'acunawan munacuyanqui? ¿Mana cäman muyuchipämänayquipächun śhamulanqui, imatá? Yaćhämari Diospi Śhamü Chuya caśhayquita” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Niptinmi Jesus piñapäla: “¡Cay nunäpi upälla liculcay!” nil. Niptinmi pampäman sätalcul mana uchucllapis däñaycullal chay nunäpi yalapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chayćhümi lluy nunapis licapänacuyllaman camäśha ninaculcäla: “¡Imatan cay'a! ¡Juc licchä yaćhachicuymá! ¡Maynu sumä munayniyu nunatan achatupis cäsucul licunanpä!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jinaptinmi chay lulaśhanta lluy malcacunaca yaćhatityälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chay juntunaculcänan wasipi yalulculmi Jesus lila Simonpa wasinta. Ćhänanpämi Simonpa suyran calur ishyaywan śhüśhuwaśhtin jitalayäña. Jinaptinmi Jesusta ruygacula sänachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chaymi ishyäcäman aśhuycul “Ishyay, cay walmipi yaluy” nil nillaptin ishyaynin juclla chincacula. Jinaptinmi śhalculcul atindiycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ñä aspicalpuyaptinmi payman imaymana ishyaywan ishyänincunacta ćhächipämula. Jinaptinmi lluytapis yataycullal sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Waquincunactañatacmi achatup maquinpi caćhaycachila. Jinaptinmi apalcaćhaypa achatucunaca: “¡Am'a canqui quiqui-quiquin Diospa Chulincämi!” nila. Quiquin Diospa Caćhaśhan Salbacüca caśhanta yaćhapäcuptinñatacmi piñapalcul manaña limalcachilachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chay achicäluptin chunyäninman Jesus licuptinmi lluy nunacunaca talipäcunancama ashipäcula. Chayćhu talilcälilñatacmi juc malcacunaman linanta nï munapäculañachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Niptinmi: “Manam. Juc malcacunamanpis linämi, Diospa gubirnunpi paycunactapis willaycunäpä. Chaypämi Diosninchic ya'acta caćhamäla” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nilmi Galilea-lädućhu juntunaculcänan wasicunaćhu yaćhachishtin pulila. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","3","Juc-punmi Genesaret ućhap manyanćhu Jesus licälun ishcay barcu jinanllan watalayalcäta. Chay jucninshi Simonpa cala. Chaymi Simon parti chalawshï-masincuna challwa chalacunta pa'alcäñä. Chaymanmi achca-achca nunacuna Diospa limayninta uyalipäcunanpä ćhäpämuptin Jesus Simonpa barcunman ishpiculcul nila: “Wicniscaman puśhay barcuyquita” nil. Chayniscaman puśhaptinmi chay śhamücunäta chaypi yaćhachimula. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chayćhu ñä yaćhachiyta camacalculmi Simonta nila: “Cay barcuyquita wicnisca unduscanman puśhal challwa chalacuyquita caćhalpuy chalanayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Niptinmi Simon: “Taytáy, tutay-walächi maynu ashiyalcalpis, manam nï juctapis talipäcüchu. Má, canan am mandamaptiqui'a jitaycuśhäri” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nilcul jitaycuptinmi achca-achca challwacuna winacämuñä mana chutaypis atipanancama. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chaynu llasaycäwan laćhyat-laćhyatyäcuyaptinmi parti chalawshï-masincuna yanapänanpä ayaycaćhacuyan. Jinaptin ishcaynin barcun juntacta winäläliptinmi llasaycäwan ñaćhaña ji'acalpuyanpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Caycuna lulacacüluptinmi Simon Pedro Jesuspa ñawpäninman un'ulacuycul nila: “Ya'a jucha-sapa nunapïta aśhucullay, taytáy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ñatac llapanpis lluy manchalicuśhanümi cacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Chaynütac Simonpa partil lulawshïnin Zebedeop chulin Juanpis, Jacobopis lluy jucnawyäcuyllaman camälälila. Jinaptinmi Simonta Jesus nila: “Ama manchacuychu. Cananpïtá challwa juntupäcuśhayquinümi nunacunactapis Diospä juntupämunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Niptinmi chay ućhap manyanman barcuncunacta caćhaycul jinanllan Jesuswan liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Juc malcaćhüña Jesus cayaptinmi, juc nuna ćhämun ćhaquinpïta umancama lipra ishyaywan. Chayćhu Jesusta licälul-pacham, un'ulacuycul cäranpis pampäcama uyshucuycul ruygacula: “Taytáy, munal'a allinyaycachillämanquimanmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Niptinmi maquinwan yataycul: “Aw, allin chuya canayquitam muná” nila. Nilcullaptinmi lipra ishyaynin lluy śhuśhüluptin sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaymi Jesus nila: “Amam cay allinyachishacpïta pictapis willapacunquichu. Aśhwanpa sasirdütiman lil anradisicuypi apay Moises nimäśhanchicnuy rasunpa cay ishyaypi allinyäśhayquita licaśhunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Masqui chaynu niptinpis Jesuspa lulaśhan'a intirumanmi miläla. Chaymi achca nunacunapis śhapämula Jesuspa yaćhachishanta uyalï, chaynütac ishyänincunacta sänachipunanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jinaptinpis chunyänincunamanmi Diosta mañacunanpä Jesus licü cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc-pun Jesus achca nunacunacta yaćhayächiptinmi, chayćhu cayalcäla fariseo caśhtacunapi, Moisespa camachicuyninpi yaćhachicücunäpis, intiru Galileap malcancunapi, chaynütac Judeapïpis, Jerusalenpïpis. Chayćhümi Jesus llapa ishyäcunacta quiquin Diospa munayninwan sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jinaptinmi juc pasaypi ćhänacacüśha nunacta chacanawan apapämula. Chay apamücunaca Jesuspa ñawpäninman ishyäcäta pasaycachiyta munaptinpis, nunacuna quićhqui-quićhqui captinmi mana atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chay mana atipaculculmi, wasip altunman ćhulculcul tïchunta alilcul Jesuspa ñawpäninman watuwan caćhalpapämula. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Caćhalpamü nunacunap chalapacuyninta tantialmi chay ishyäcäta Jesus nila: “Wayapa, juchayqui lluy pampachäśhañam” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niptinmi chay yaćhachicücunawan fariseocunañatac pinsapäcula: “¿Pitan cay'a caynüta limal Diosninchicta jalutacunanpä? Diosllanchicmá juchacunacta pampachäca” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chaynu pinsalcäśhanta yaćhalmi Jesus nila: “¿Imapïtamá caynu pinsapäcunqui? ");
INSERT INTO qvwNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Imaniytan mas fäsil: ‘Juchayquicunacta pampachaycucñam’ nïchun icha ‘Śhalcuculcul licuyña’ nïchun? ");
INSERT INTO qvwNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cananmi yaćhanqui cay Rasun Nunap Chulincá, cay pachäćhu juchacunacta pampachänäpä munayniyu caśhäta” nil. Nilculmi chay ishyä nunäta: “Canan ¡śhalcuy-ari! Wantumuśhuśhayquita apaculcul wasiquita licuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chay niptin-pachallam llapanpa ñawquin śhalcuculcul wantumuśhanta apaculcul wasinta licun cushicuypi Diosta alawaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jinaptinmi llapan nunäpis licapayllaman camäśha Diosta altuman julaycälila: “¡Caytanu'a manamá imaypis licalanchicchu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaypi Jesus yaluculcul pasaśhanćhümi licälun Leví śhutiyu nuna Roma gubirnupä alcabälacta mañanancäćhu täcuyäta. Chaymi Jesus: “Acuchun ya'awan, atimay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Niptin-pacham lluyta caćhaycul paywan licula. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chaypi Levïmi wasinćhu juc cumbiducta yanuchila Jesuswan micapäcunanpä. Chay mïsa micapäcuśhanćhütacmi alcabäla mañawshï-masincunapis, juc nunacunapis capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chayćhu juc ishcay fariseocunäwan camachicuypi yaćhachicücunaca licalïlälimulmi Jesuspa yaćhapacünincunacta jamuyapäcula: “¡¿Ima-nilä nunatan capäcunqui wic-nilä suwacunawan jucha-sapacunawanlä upyapäcunayquipä micapäcunayquipä?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Niptinmi Jesus nila: “Sänu nunacunacá manam jampicüta munanchu, sinu'a ishyäcunallam. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ya'a manam śhamulá santutucücunacta ayächu, sinu'a jucha-sapacunaca wanaculcänanpämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ñatac paycunam tapupäcula Jesusta: “¿Imanaltan Bawtisä Juanpa puliwshïnincunapis fariseop atïnincunapis rätu-rätu ayunal Diosta mañacuyalcan, ampañatac mastá micucuylla upyacuylla isisí?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nipäcuptinmi: “¿Casaracüca cayaptin'a ayachishacunaca ayunapäcunmanchun ampá? Manaćhá jinapäcunmanchu paycunawanlä cayaptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ñatac chay casaracüca waycäśha canan timpu ćhämun'am. Jinaptinmi ichá ayunapäcun'a. Chaynümari yaćhapacünïcunawanpis can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nilculmi jucman tinculcachil yapa nila: “Manam mayanpis muśhü müdanacta laćhyalcul, lataśh müdanaman la'anmanchu. Chaynu la'äluptin'a muśhü müdanam yan'alpä canman. Manamá tincunmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Chaynütacmi chayllalä luläśha aswactapis mana winanchicchu lälaśha mawca wacuyman'a. Chaynu lulal'a aswäćha wacuycäta paquïchinman; jinaptinćha lluy aswapis wacuypis yan'al pampapä canman. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chaymi chayllalä luläśha aswactá muśhü allin wacuyman winanchic pulanpis tuqui caycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mayanpis pu'uśha aswacta upyacücá chayllalä luläśhätá manamá ‘¡Añawjá!’ nin'achu. ‘Pu'uśham sumä mishquicullan’ nin'amá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juc warda muyunćhümi Jesus yaćhapacünincunawan pasayalcäla trïgu-trïgup manyanpa. Chay yaćhapacünincunañatacmi pallalcälil cupaycula micalcälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chayćhu fariseocuna chaynayäta licälälilmi Jesusta nipäcula: “¡¿Imapïtatá warda muyunćhu camachicuy mana pirmitishanta lulayalcanquiman?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Niptinmi Jesus: “¿Manachun lïgipäculanqui David micanäśha cayal puliwshï-masincunawan imacta lulapäcuśhantapis? ");
INSERT INTO qvwNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","¿Manachun Diosta alawana carpanman yaycucuycul Diospä japächäśhan tantäta, sasirdüticunälla micunanpä cä tantätalä micüla? Jinaman ¿manachun puliwshï-masincunactapis uycuñälä canpis?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nishanpïmi: “Ya'a Rasun Nunap maquilläćhümi cay warda muyuncäpis cayan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chaynütacmi juc warda muyunćhüpis juntunaculcänan wasiman yaycul Jesus yaćhachila. Chayćhümi juc nunap allï maquin mana cuyulï chaquïsha cañä. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chayćhümi camachicuyta yaćhachicücunawan fariseocuna awaytapäcula: “Má, canan warda muyuncäćhu sänachin'achuśh” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Chaynu pinsapäcuśhanta Jesus tantiälulmi chay mana cuyulï maquiyu nunäta nila: “¡Śhalcuy, cay ñawpäman pasaycamuy!” nil. Niptinmi pasaycamul śhäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chayćhümi nunacunäta Jesus nila: “¿Cay warda muyunca allincätachun icha mana allincätachun lulachimanchic? ¿Cawsayninta salbaycachimanchicchun icha wañulpachimanchicchun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nilculmi lluy chayćhu cä nunacunäta licalcul mana cuyulï maquiyu nunäta: “¡Chacchapacuy!” nila. Chaynu chacchapacüluptinmi sänu licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chaynu luläluptinmi ñaćhaña imanacälälilapis “¡¿Imactatá luläśhun?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay muyuncunam juc chunyä uluncascaman Jesus licula. Chayćhümi tutay-walächi Diosta mañacamula. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chay achicäluptinmi llapa yaćhapacünincunacta lluy ayalcul, “Puydï caćhaśhäcuna capäcunqui” nil ćhunca ishcayllacta aclala. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paycunam cala: “Pedro” nishan Simon, paypa śhullcan Andrespis. Jinaman Jacobowan śhullcan Juanpis. Jinamanñatacmi Felipiwan, Bartolomé. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Jinaman'a Mateowan, Tomas. Chaynütac Alfeop chulin Jacobopis, ñatac malcanpi nanachicü Simonpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Chaynütac Jacobop śhullcan Judaspis. Jinaman'a Jesusta ipanchä Judas Iscariotipis. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Paycunallawan chay ulüpi cutilpayalcämuptinmi chay pampaćhu nisyu-nisyu nunacuna alcayalcäñä jinantin Judea malcacunapïtawan, Jerusalenpïtapis, chaynütac lamar-lädunćhu Tirowan Sidon malcacunapïtapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Chaynu śhapämula Jesuspa yaćhachicuyninta uyalipäcunanpämi, ishyänincunacta lluy sänaycachipunanpäpis. Chayćhümi Jesus rasunpa lluy ishyänincunactapis Satanaśhpa gänaśhacunactapis sänachipula. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chaymi llapan nunacunapis Jesusta yataycuyllactapis munapäcula ima ishyayninpïpis lluy sänachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chaynu jinalculmi yaćhapacünincunaman licalcul nila: “Cushiculcay waccha cäcunaca. Amcunapämi Diospa gubirnun unanchäśha cayan. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Cushiculcay micanäśha cäcuna. Amcunactam Dios maćhaycachishunqui. Cushiculcay canan wa'acücuna; ¡maynu cushicuśham canqui! ");
INSERT INTO qvwNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Cushiculcay ya'a Rasun Nunap Chulin-laycu ćhïnipäcuśhuptiquipis, alupäcuśhuptiquipis, ruydupapäcuśhuptiquipis, mana allinpa licapäcuśhuptiquipis. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Caytanümi Diospa willacünincunactapis lulala unay awiluyquicuna. Chayurá chaypun cushiculcay, jinal mastalä cushiculcaypis. Paycunanüpis amcuna janay pachäćhu sumä jatun primiuctam ćhasquipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Am rïcucunäpam ichá ñä capuśhunquiña imayquipis cushiculcänayquipä. ¿Ñatac imanuytá capäcunqui Diospá? ");
INSERT INTO qvwNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Imanuylä capäcunqui canan patayqui junta cäcuna! Amcuna juc-punmi micuypi wañupäcunqui. ¡Imanuylä capäcunqui canan allinmi cä nil cushisha cäcuna! Amcunam mamay-taytayta awćhupäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Imanuylä capäcunqui canan llapan nunacunäwan alawachicücuna! Canannümi awiluyqui timpucunaćhüpis alawapäcula Diospa willacünintucuycul yan'al willapäcuptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Cananñatacmi ya'a niycälic, cuyapäcuy ćhïnishüniquicunäta. Ćhïnicüniqui nunacunapäpis allintatac lulaycälipuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Amcunapi mana allin limäcunäpäpis ‘Allinca anwan caycuchun’ niycäliy. Tumpäśhüniquicunapäpis mañaculcaytac. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ñatac cäraćhu lapyaśhuptiquipis, juc-lädu cärayquitapis camaycuy. Pipis punchuyquita waycaśhuptiqui'a, camisayquitapis uśhtipaycuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mayanpis mañaculcäśhuptiqui'a uycäliy. Mayanpis pishipacü ‘uycamay’ nishuptiqui'a uycul amaña ‘cutiycachimay’ niyaychu. Apacuchunñari. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chaynütac-ari nuna-masiquicuna allinpa licapäcuśhunayquita munaśhayquinu paycunactapis tuquip licaycäliy. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sïchuśh sintinaculcäśhallayquiwan cuyanaculcaptiqui'a ¿ima allintatan lulaycuyanqui? ¿Manachun piyurnin jucha-sapacunäpis lulawshï-masincunawan chaynu cuyanacun? ");
INSERT INTO qvwNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Allinta lulaśhüniquicunallapä chaynu lulaycuyal'a ‘mas allinninlämi cayá’ ¿niyanquichun imatá? Chaynüllá Diosta mana lisïcunapis lulapäcunmá. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‘Ya'apis mañaycuśhä aynipä’ nil lulaycuśhayqui ¿ima allintá? Chaynu aynillapá jucha-sapacunäpis mañanaculcanmá. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Chayta lulaśhayquinu'a ćhïnicüniquicunätapis amcuná cuyaycäliy. Jinal allinta lulaycapul mañaycuy, amatac uyayllapá. Chay jinaśhayquiwanmi cayćhüpis janay pachäćhüpis allin cawsayta pasapäcunqui. Caycunacta lulalmi Sumä Munayniyu Diospa nunan caśhayquita camalachipäcunqui. Ñatac juyupäpis pasaypi nunapäpis pay'a allinmá. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Paynuy llaquipayniyü-cama amcunapis capäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ama nuna-masiquicunacta cäraycäliychu Dios mana cäraycälishunayquipä. Amatac pictapis juchachaycäliychu, amcunapis mana juchachaycuśha canayquipä. Pampachaycäliy, amcunapis pampachaycuśha capäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Uycälil'a amcunapis mana camaytapis atipänayquicamam ćhasquipäcunqui. Uycälishayqui tincütam uycälishunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nilculmi Jesus tincuchila cay nil: “¿Juc apla puśhanmanchun juc apla-masinta? ¿Manachućh may ućhcumanpis palpälälinman? ");
INSERT INTO qvwNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Chaynümi mayanpis yaćhachïninpi mas'a manalä canmanlächu. Lluy yaćhachishancunacta ishpïlulmi ichá paypis allin yaćhachicü can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Imapïtan nuna-masiquip ñawinćhu uchuy anlallanta licaypi wañupacuyalcanquiman ñawiquićhu jatun iluyqui cayaptin? ");
INSERT INTO qvwNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Imanuypatan ‘Jay, ñawiquićhu anlallayquita julüśhayqui’ niyanquiman jatun iluyqui ñawiquićhu chacalayaptin? ¡Ishcay cära nunacuna! Ñawiquipïtalä juluy chay iluyquita. Jinalculćha ichá juccunäpa anlanta julunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Allin lantacá manam ćhulanchu pasaypi mana bälïcunactá, nïtac pasaypi mana bälï lantapis ćhulantacchu tuqui tuquictá. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ñatac lluy lantactapis lisinchic ćhulayninpam. Manam ïgusta ćhulanmanchu caśhacunaca. Nïtac übactapis ćhulälunmanchu tantal caśhacá. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chaynümi allin nunäpá śhun'unćhu sumä cuyay ćhaniyu ćhulacuśhancäpi shiminpapis yalamun. Chaynütac mana allin nunäpapis sumä ćhaniyüpa mana allincunallacta ćhulaycuśhancäpïmi shiminpapis yalamun. Rasunpa shimin liman imanuypis śhun'un caśhanpam. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Má, ‘Duyñullämi, Taytallämi am canqui’ niltac nipämanqui, chaypïtá manatac ya'a nishätá cäsupämanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cay nishäta uyalil cäsumäcunaca caynümi: ");
INSERT INTO qvwNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","masïsu a'a jananćhu wasinta śhalcachïcänümari. Mayuca maynu wiñämulpis, manamá cućhpachin'achu, masïsu taycachisha captin. ");
INSERT INTO qvwNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ñatac mana cäsucücá mana sumä simintaycul allpa janallanćhu wasinta luläcänümi. Pu'uy tamya timpućhu mayuca lluy wiñalcamulñatacmi juclla apacun'a. Jinalculmi may caśhanćhu nï camalan'achu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nunacunäta limapayta lluy camacalculmi Jesus yaćhapacünincunawan Capernaum malcäman liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chayćhümi Roma cachacucunap capitannin yaćhañä. Paypa uyway nunanmi ishyayal lluyña wañucalpuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chaymi capitanca chayćhu Jesuspi limapäcuśhanta uyalilcul chay prinsipal yaśhacunacta caćhamula: “Taytáy, ama chaynu callaychu. Uyway nunalläta sänaycachipallämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Niptinshi paycuna lilcul Jesusta rasunpa ruygaculcäla nishantanuy. Jinalculshi paycuna partipïpis nipäcula: “Yanapaycullay. Pay'a allin nuna cayninwan mirisinmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Rasunpa malcanchicta cuyanmi. Chaymi juntunacuna wasinchictapis śhalcälächipäman alawapäcunäpäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Niptinmi Jesus paycunawan lipäcula. Chayćhu wasinta sircacuycuyaptinmi capitanca talipachimula lisinacuśhancunacta. Chayshi paycuna: “Taytáy, amash piñacunquichu. Wasinman yaycaycamunallayquipäpis manash bälillanchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chayshi mana nï quiquinchu śhamuśhulanquipis. Aśhwanpa cayllapi niycullaśhayquiwan sänachinayquita yaćhayanshi. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pay quiquinshi yaćhan cäsucuytapis mandacuytapis. Chaynütacshi maquinćhu cä cachacucunäpis ‘wicta liy’, ‘cayman śhamuy’ niptin'a cäsupäcun. Chaynütacshi uywaynincunapis ‘cayta lulay’ niptin'a lulapäcun” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cay nichimuśhanpi admiracuculmi Jesus atïnincunäta licalcul nila: “¡Cay jinantin Israel malca-masïcunaćhüpis caynu chalapacuyniyütá manam talïchu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Niptin cuticulcalmi tuqui sänaśhactaña talïlälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaypïta Jesus yaćhapacünincunawan Nain śhutiyu malcäta licuptinmi achca nunacuna liwshipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ñatac chay malcäćhümi juc biuda japallan wawintin yaćhala. Paymi Jesus ćhänanpä wawillanta wañupacülul pampa apayalcäla, achca malca-masincunawan cumpañachicüśha sumä-sumä wa'aśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chaynüta licälulmi Jesus llaquipaycul “Tiyay, amaña wa'acuychu” nil cunsuylaycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nilculmi apaśhancäman aśhuycul chacanäta chalaycula. Jinaptinmi apäcunaca śhaycuycuptin chay almäta nila: “Walaśh ¡śhalcuyñari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nilcul nillaptinmi wañüśhaca cawsalcamul, taycucuycul limayta allaycula. Chaynu cawsalcachilmi mamanman Jesus intirgaycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cayta licälälilmi: “¿Imactatan licayanchic?” nil Diospi limapäcula: “Dioslláy, ya'acunap ćhawpïćhümi licalïlun ampa jatun willacüniqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jinamanmi nipäculatac: “Ya'anchicman Diosmi yanapaycü śhamumanchic” nil. Chaymi cay lluy lulaśhancunäta Judea jinantin malcacunäpis lluy yaćhälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Chaymi Bawtisä Juanpis carsilćhu cayal caycunapi yaćhäla puliwshï-masincuna willaycuptin. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Chaymi ishcayta ayaycula: “Jesusman lil ‘¿Amchun cayanqui rasunpa Dios caćhamuśhan nishanca ichá juctalächun alcapäcuśhä?’ nilmi tapumunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Chaynu ćhäpäcunanpämi Jesus achca ishyä nunacunacta, imawanpis mana allin cäcunacta, Satanaśhpa maquinćhu cäcunätapis caćhaycayächiñä. Chaynütacmi aplacunactapis licayächiñä. Chayćhümi Jesusta tapupäcula: “Bawtisä Juanmi caćhapämäla ‘¿Amchuśh cayanqui Dios caćhamuśha nishanca icha juctalächuśh alcapäcuśha?’ ” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Niptinmi: “Canan cutil Juanta willamuy cay licapäcuśhayquicunätapis, uyalipäcuśhayquicunätapis: aplacunapis licaśhanta, latacunapis pulishanta, lipra ishyayniyücunapis tuqui sänaśhanta, upäśha linliyücunapapis quićhacacüśhanta, wañüśhacunapis śhalcamuśhanta, wacchacunämanpis allin willacuy ćhäśhantalä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ñatac niycäliy: ‘Ya'apïta mana ishcayyäcá cushisha caycuchun’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chay caćhamuśhancuna cuticulcaptinmi Jesus chayćhu llapan nunacunäta tapula: “Juc-pun chunyäninćhu Juanta lical ‘¿Imacta licayá’ nipäculanquitan? ¿Śhu'uśhta waywa apaycaćhäta licächun ichá imam? ");
INSERT INTO qvwNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Icha juc rïcu nunacta ćhaquinpi umancama chipyayä müdacuśhacta licächun? Chaynu bïdacta pasä nunacuná puydï mandacücunap wasinćhümá cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Chayurá ima licätan amcuna lipäculanqui? ¿Icha Diospa willacünin nunacta licächun? Rasunpa chaynu nunactamá licapäculanqui. Ñatac pay'a lluypïpis sumäninlämá. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chaymi Diospa shiminćhüpis paypi limayan: ‘Ampa ñawpäniquitam juc willacünïta caćhamüśhä, ćhänayquipä alistamunanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Rasunpa cay Bawtisä Juanpïta mas lisimäcá manamá canchu jinantin pachäćhu. Chaynu captinpis Diospa gubirnunćhu'a ashllacta lisimäcäpis Juanpïta maslämi lisiman'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Rasunpa chaypuncuná Juanta uyalilmi, aśhta Roma gubirnüpa alcabälan mañänincunapis aśhwanpalä yacuwan bawtisachiculcäla: “Ya'ap lulaśhá manamá allinchu Diospá” nilcul. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseocunäwan yaćhachicücunäñatacmi ichá mana intindïtuculachu. Chay mana ćhasquiyninwanmi Diosninchic “llaquipaycuśhayquim” niyaptinpis jamuyapäcula.) ");
INSERT INTO qvwNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yapañatacmi Jesus nila: “¿Imanuytá amcuna cayalcanqui? ¿Imamantan tincuchichwan? ");
INSERT INTO qvwNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Achca walaśh wamlachacuna läsaćhu ayaycaćhaypa awsäcunänümi. Chaymi casamintu fistacta awsal quïnanta parti tucalcaptinpis, manatac parti'a tuśhüshipäcunchu. Chaynütac wañupacuy awsayta awsayalcal wa'ay wa'ay taquicta taquiyalcaptinpis manatac wa'awshipäcunchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chaynümi Bawtisä Juanpis tantacta mana micuptinpis, mana nï uchucllapis bïnucta upyacuptinpis ‘Satanaśhpa nunan’ nipäculanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ñatac ya'a Rasun Nunap Chulinca micuptïmi, upyaptïmi ichá, ‘micuypä camäśha, upyaypä camäśha, jucha-sapa nunacunap, alcabäla mañäcunap cunchawänin’ nil jamuyapämanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ñatac Diospa yaćhaynin rasun caśhanta wayuyninpam nunacunaca tantiapäcun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chaypïmi Simon śhutiyu juc fariseo puśhala wasinta cumbidal Jesuswan micapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chayćhu täcuyaptinmi juc-juc wayapacunawan bïdan pasacü walmi ćhäla caćhi lumipïtanuy uchuy butïllachaćhu sumä ćhaniyu pirfümicta apacuśha. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ćhayculmi Jesuspa lädunman aśhuycul, alli-allicta wa'acul wi'inwan ćhaquinta lluy bäñäla. Jinalculmi ächanwan pichäla. Chaynalculmi sumä rispitayninwan ćhaquinta muchaycul chay apaśhan pirfümiwan lluy pasala. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cay lulaśhanta licalculmi Simon pinsälun: “Cay nunaca manam Diospa willacüninchu canman. Rasunpa cayal'a, ¿imanuypatan caynu bïdayu jucha-sapa walmiwan yataycachicuyanman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chaymi Jesus: “Simon, willaśhayqui” nila. Niptinmi: “¿Imacta?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Niptinmi: “Juc umrictash ishcay nuna dïbicuñä. Jucninshi ishcay wata trabajup ćhaninta; juccäñatacshi ishcay quilla trabajup ćhanillanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Chayćhu pulanpis mana pägayta atipaptinshi, chay nunaca lluy rigalaycüla. Canan, má, nimay. ¿Mayannintan mastá cuyaycun'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Niptinmi: “Ya'apïtá achca dïbicücäpisćha” nin. Niptinmi: “Aw, allintam ninqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nilculmi walmïta licalcul Simonta nila: “¿Licanquichun cay walmicta? Wasiquita yaycamuptí, am'a puliycaćhacuyanquitac. Manatac nï yacullayquitapis uycamanquichu ćhaquilläta pa'acunalläpäpis. Cay walmim ichá wi'inwan ćhaquïta pasaycamal ächanwan pichaycalläman. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yaycamuptí shimi puntallayquipmi ćhasquimälanqui. Cay walmim ichá yaycamuśhä-pachapi rispïtunwan maquillayqui niyänuy ćhaquïta muchayämanlä. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Manamá am'a nï śhutuy asaytiquitapis uycamälanquichu ächäman ćhulaycunalläpäpis chaynu custumrinchic cayaptinpis. Cay walmim ichá pirfümiwan ćhaquilläta bäñaycalläman. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chaymi ya'a nic, cay walmip maynu juchanpis lluy pampachäśhaña captinmi jatun śhun'unwan lulaycaman. Amnu śhun'uyu nunacuná juchanćhu chapunacüśham cayalcanlä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nilculmi walmïta nila: “Lluy imanuy bïdayquipis pampachäśhañam cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Niptinmi chayćhu juc ayachishan nunacunaca quiquin-pula ninaculcäla: “¿Pitan cay nunaca juchacunacta pampachätucunanpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Niptinmi Jesus chay walmïta: “Ya'aman chalapacalcamäśhayquipam salbaśhaña cayanqui. Jawcallañari canan licuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Caypïta pasalmi intiru jatun malcacunäćhu tacsa malcacunaćhüpis Jesus pulila Diospa allin gubirnunpïta yaćhachishtin. Ćhunca ishcayniyu yaćhapacünincunañatacmi puliwshipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chaynütacmi inchäśhapi sänachishan walmicunapïwan, ima ishyaynincunapïpis sänachishan walmicunapïpis, waquinnin'a paycunacta liwshipäcula. Paycunam capäcula Magdala malcapi Maria, anćhish achatu gänalcuptin mana nunapïña sänachishan walmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chaynütacmi Herodespa yanapänin Cuzpa walmin Juanapis, ñatac Susanapis. Chaynütacmi juc walmicunapis liwshipäcula. Paycunam cay pulïcunäta ima pishiptinpis yanapaycälila. Caynu lulaycula alli cäniyu capäculmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Chayćhu puliyaptin intiru malcacunäpi lluy juntunacälälimuptinmi tincuchiypa willala cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc nunash talpucü liñä. Wacaptinshi waquinnin mujucuna caminucunäman paćhcälun. Chayćhu jalutacüśha cayaptinshi pishucuna śhalcamul lluy pallälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Juc mujucunañatacshi ćhäla-ćhälaman paćhcälun. Chayćhu wiñalcamulshi lluy chaquïla mana jundu allpa captin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquin mujucunañatacshi ula-ula, caśha caśhacunäman paćhcälälin. Chay caśhacunäwan cusca wiñalcamuptinshi caśhacuna lluy alwächin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ñatac juc mujucunañatacshi allin jundu allpaman ćhäpäcun. Chaycunash ichá allicta wayupäcul paćhac wayuyniyü-camalä capäcun” nil. Nilculmi callpawan: “¡Linliyu cal'a uyaliculcay-ari!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chaynu niptinmi yaćhapacünincuna: “Tapuculläśhayqui, taytáy. Cay tincuchishayquiwan ¿imaninayquitam niyalcämanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Niptinmi: “Amcunactá Tayta Diosmi tantiaycachipäcuśhunqui gubirnunćhu pacacuynincunactapis. Ñatac juccunätá caynu tincuchiyllaplämi, Diospa shiminćhu cay nishan-yupaypis: ‘Maynüpa licayalcalpis mana licapäcunanpä; maynüpa uyaliyalcalpis mana uyalipäcunanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Cay tincuchishäca caynümi: Chay mujum cayan Diospa limaynin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Caminuman ćhäcänümi Diospa willacuynin waquin nunacunaman'a ćhan. Chaynu uyaliyaptinpis Satanaśh śhalcamulmi śhun'unman ćhäśhancäta waycalpülun mana chalapaculcänanpä nï salbaculcänanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Chaynütacshi ćhäla-ćhälaman ćhäcänüpis Diospa willacuynin ćhan waquinnincunaman'a. Paycunam tuqui gänaśhwan uyaliyalcalpis mana sapichacüśha lanta-yupay cayalcal chalapacuynin mana tacyanchu. Chaymi uchuc sasachacuycunallawan'a Diosninchicta un'älun. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Waquin nunacunamanñatacmi chay caśha-caśhaman muju paćhcäcänuy Diospa willacuynin ćhäpäcun. Ñatac imaymana munaynincunawan cänincunawan aychanpa munaynincunawanpis shipuchicüluptinmi mana wayuynin canchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ñatac jundu allin allpaman ćhäcänuy capäcun allin willacuyta llapan śhun'unwan tuquip ćhasquïcunämi. Jinalmi śhun'unman tuquicta ćhulaycul, masïsu śhaycul sumä wayuyniyü-camalä capäcun. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“¿Imapïmi caynu tincuchiyllap willapäcuc? Manamá juc acchicta walaycachinchic mancawan pacaycunapächu, nïtac cawitup lulinman ćhulaycunapächu. Aśhwanpa altu ćhulacunmanmi ćhulcunchic yaycamücunaca sumä ima caśhantapis licananpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chaynümi cay tincuchiyllap willaśhaccäpis pictapis lluy tantiapacachin'a. Manam canan imapis pacalanñachu, sinu'a willaśhañam. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chayurá sumäta uyalipäcuy. Tantiäcunätá mas tantiayta uśhalämi can'apis. Mana tantiäcunätam ichá uywätucuśhantapis aśhwanpalä chincalpächisha can'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chaynu Jesus yaćhayächiptinmi mamanwan śhullcancuna ćhälälimul ñiti-ñiti nunacunaca cayaptin mana yaycuyta atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaynu cayaptinmi Jesusta jucnin willaycula: “Mamayquiwan śhullcayquicunam ashiyalcäśhunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Niptinmi: “Taytäpa shiminta uyalicul cäsucücunämá mamá, śhullcá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Juc muyunmi Jesus yaćhapacünincunawan barcuman ishpipäcula. Jinalculmi Jesus: “Acuchun cay ućhap chimpanman” nilcul liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chaynu liyalcaptinmi Jesusta puñuy aysälun. Chayćhümi alli-alli waywa juclla licalïmun. Jinalculmi yacüta manchanaśhpä śhalcachicuyal barcumanpis wañuypänüña winacächicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaynu jinacuyaptinmi: “¡Taytallay taytay, wañuypa patanćhüñam cacuyanchic!” nishtin Jesusta licchachipäcula. Jinaptinmi śhalcalcamul: “¡Waywa, yacu, śhaycuyña!” nila. Nilcullaptinmi tuqui-tuqui jawcayälun. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jinaptinmi yaćhapacünincunacta: “¿Imapïtá amcuna mana chalapacalcämanquilächu?” nila. Niptinmi paycuna manchapacüśhanuy: “¿Ima nunatan pay, waywäpis yacüpis cäsunanpä?” nil licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chaypïtam Galileap chimpanćhu Gadara-läduman ćhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ćhäläliptinmi chay-lädu nuna yalämun Satanaśhpa maquinćhu lücuyäśha. Cay nunash unayña mana müdacüśha pasaypa calanllan pulila. Pantiuncunallaćhüshi cawsaculapis, manash wasićhüchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Chayshi chay nunäta ćhaquipi maquipi tita cadinacunawan watapäcuptinpis mana quirilachu. Jinalculshi may chunyä ulucunämanpis pasacula Satanaśhca puśhaycaćhayaptin. Cay nuna Jesusta licälul-pacha apalcaćhaypa ñawpäninman un'ulacuyculmi nila: “¡¿Imactatá ya'awan munacuyanqui, Jatun Munayniyu Diospi Śhamü Chulin Jesus?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Niptinmi: “¿Imam śhutiqui?” nila. Niptinmi: “Batallunmi” nila. Cayta nila nisyu-nisyu achatucuna capäculmi. Caynu niptinmi: “¡Cay nunäta caćhaycul liculcay!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Niptinmi ćhuncay-ćhuncay ruygaculcäla: “¡Chay mana camacaycü luli-luli wayüman amalä alupämaylächu!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ñatac chay ulucunaćhümi achca-achca cuchicuna lancalayalcäla. Chaymi satanaśhcunaca ruygaculcäla: “¡Wic cuchicunäman liculcänapä awniycälillämay!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chaynu awniycuptinmi chay nunäta caćhaycul liculcäla. Jinaptinmi lluy cuchicunaca juclla lücuyalcul ućhap patanman cürritityalcul lluy ji'acalpälil anuälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chay pasaśhanta licalculmi cuchi michïcunaca mana-mana pasaculcan malcäcama tincuśhancunäta ćhaclacunäćhu lluy nunacta willacuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chaymi nunacunaca ima pasaśhantapis licä śhapämula. Chaynu ćhäpämunanpämi Jesuspa ñawpäninćhu chay lücu nunaca tuqui müdacuśha, sänu fisyunćhu täcuyäñä. Chaynüta licälälilmi lluypis manchapacälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chayćhu licäcunaca willapäcula chay nunacta imanuypa caćhaycachishantapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chayta uyalïlälilmi jinantin Gadara malcaca Jesusta ruygapäcula juc-lädu malcaman pasacunanpä. Chaymi Jesus barcunman ishpilcul yalucuyaptin ");
INSERT INTO qvwNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","chay sänachishan nunaca ruygala: “Ya'actapis puśhacallämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Niptinmi: “Ya'awan linayquitá aśhwanpa wasiquita licuy. Jinal willapacamuy maynu-maynu lulaycunawan amćhu Dios lulaycuśhantapis” nila. Chaypïmi may malcaman ćhalpis Jesus sänaycachishanta willacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus yaćhapacünincunawan wic-lädu chimpacta cutinanpämi llapa nunacunapis cushisha alcayalcäñä ćhasquinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chayćhu Jesus ćhämuptinmi juntunaculcänan wasip puydïnin Jairo śhutiyu wayapa ćhämul Jesuspa ñawpäninman un'ulacuycul ruygacula: “Japallan cuyay wamlallämi wañucalpuyanña. Acuchun, wasïta lïlläśhun, taytay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Caynu ruygacula ćhunca ishcay watayu malta lasac wamlan wañucalpuyaptinshi. Chaypi Jesus liyaptinmi lluy nunapis sumä ñiti-ñiti atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Paycunap ćhawpinćhümi liyäñä ćhunca ishcayniyu wata yawarpa janallanćhu cayä walmi. Paymi mïdicuncunäćhu jampichicuyta puliyal imallantapis illayllapäña aśhtayal lluy camacacüñä. Jinalpis manatacshi uchucllapis carililachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chay walmim ipanpa aśhuycul Jesuspa müdananpa manyanta tupaycula. Jinaptinmi chayüralla yawarnin lluy śhaycämula. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chayćhümi Jesus tapula: “¿Mayantan yataycäman?” nil. Niptin mana mayanpis limaliptinmi Pedropis paywan cäcunapis nila: “Yaćhachicü taytáy, cay-chica nunawan'a quićhqui-quićhqui liyaptinchic ‘¿Mayantan yataycäman?’ niyanquiman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Niptinmi nila: “Ya'a tantiacuyämari juc nuna yataycamaptin munaynïwan sänachishäta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chaynu niyaptinmi walmica “Canan'a tantiaman-ari” nil chucchuśhtin aśhuycamula. Jinalculmi Jesuspa ñawpäninman un'ulacuycul llapan nunapis uyaliyaptin willala imacta pinsal chalaycul-pacha sänaśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Niptinmi Jesus nila: “Wamlallá, chay chalapacamäśhayquipam sänälunqui. Amaña llaquicuyñachu. Canan jawcallañari licuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chaynu niyaptinmi Jairop nunan ćhämul payta nin: “Wamlayqui wañucunñam. Amañash yaćhachicücäta yan'al puśhanquiñachu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chay nishanta uyalïlulmi Jesus nila: “Jairo, ama llaquicuychu. Wamlayqui'a cawsämun'am. Chalapacamay jinalla” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chaypi ñä wasinta ćhälulmi yaycula, Pedrowan, Jacobowan, Juanwan ñatac wañü wamlap maman taytancunallawan. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Chay yaycunanpämi wañü wamlap lädunćhu achca awćhuyalcäñä. Jinaptinmi Jesus nila: “Amaña caynüpa wa'apäcuyñachu. Wamlaca puñuyan jinallam; manam wañuśhachu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Niptinmi lluypis: “Cay-ari wamlaca wañüśhaña cayan” nil asipälälinlä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chay nipäcuptinmi wamläta maquipi chalaycul: “¡Wamla, śhalcuy!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Niptinmi cawsämula. Jinaptinmi Jesus: “Imallayquitapis uycäliy micunanpä” nil uycachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lluy caycunapi chay wamlap taytancunam cushisha: “¡Manamá caynüta imaypis licalanchicchu!” ninaculcäla. Ñatac chayćhümi Jesus nila: “Caycunapi amam mayanćhüpis limalcälinquichu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Chaypïtam Jesus ćhunca ishcaynin yaćhapacünincunacta juntuycul nila: “Quiquïpa munaynïtam upäcuśhayqui nunacunäta supaypa maquinpi julaycälinayquipä, imawan ishyäcunätapis nanaynincunactapis lluy sänachipäcunayquipäpis. Diospa gubirnunpi willacü lipäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nilculmi: “Caminuyquipä amam imactapis apapäcunquichu, nï garutiquita, luncuyquita, milcapayquita, nï illayniquitapis. Sinu'a janä müdanallayquiwanmi lipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","May wasimanpis ćhal'a chayllaćhümi quïdaculcanqui chay malcapi juc-läduman pasapäcunayquicama. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","May malcaćhüpis mana ćhasquiy munapäcuśhuptiqui'a chaypi pasaculcay ćhaquiquićhu la'aśha pulbüllactapis lluy tapsilcälil chay malcäta ima pasanantapis tantiapäcunanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chaynu incaraycäliptinmi paycuna liculcäla intiru malcacunamanpis Diospi willacuśhtin, ñatac imaymanawan ishyäcunactapis sänachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Chayćhümi Mandacü Herodes uyalïla Jesus caynu imapis lulaśhancunapi. Chayćhüshi waquin nunacuná nipäcula: “Bawtisä Juan-ari śhalcämuñä”; juccunañatacshi “Diospa willacünin Eliaschućh jinam licalïmun”; waquinnincunañatacshi “Diospa unay willacüninćha mayanninpis śhalcämun” nil. Chaynu nipäcuptinmi imaman pinsaytapis mana atipal: ");
INSERT INTO qvwNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","“Ya'a quiquïmari Juanta mu'uchimulá. Chayurá ¿mayanpïtan canan uyalïyá?” nila. Nilculmi Herodes alli-allicta Jesusta lisiycuyta munala. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ñatac caćhaśhancuna intiru malcaćhu pulimuśhanpi cutïlälimulmi Jesusta willapäculcäla imacta lulapämuśhantapis. Chaypïtam Jesus puśhacula llapantapis Betsaida malcap chunyäninman. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chay-läduman lishanta yaćhälälilmi llapa nunacunapis lipäcula. Chaynu ćhäläliptinñatacmi Jesus ćhasquiycul Diospa gubirnunpi willala, ishyäcunactapis sänaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chayćhu intïpis ulup patallanćhüña cacuyaptinmi ćhunca ishcaynin yaćhapacünincuna Jesusta nipäcula: “Ñä tardiña cacuyaptin cay chunyäcäćhu micuypïpis wañülälin'aćh. May malcallamanpis micuy ashï jamapacüpis lipäcuchunñari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Niptinmi: “Amcunari micachipäcuy” nila. Niptinmi: “Cay picha tantallá, ishcay challwallá jucchá imanmanpis camanman. Camayta lantimuptinchicpisćha ichá camachichwanpis” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cayta nipäcula picha walanga wayapanllanlä capäcuptinmi. Chayćhümi yaćhapacünincunacta: “Picha ćhunca-camacta lluy taycachipämuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Niptinmi yaćhapacünincuna llapa nunactapis taycachimula. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jinaptinmi Jesus chay picha tantäta, ishcay challwäta apticulcul, sïlüta licalcul Diosta anradisicula. Jinalculmi lluyta partilcul yaćhapacünincunacta uycula manyapi llapantapis aypumunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jinaycuptinmi llapa nunapis chayćhu micapäcula maćhaycälinancama. Chayćhu puchünincunacta juntuchimuptinmi ćhunca ishcayniyu canaśhta juntalä cacuñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc-punmi Jesus llapa yaćhapacünincunawan japächacalcälil Diosta mañacula. Chaynu mañacuyta camacalculmi yaćhapacünincunacta tapula: “Ya'acta ¿mayan nipämantan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Niptinmi: “Waquinnincuná: ‘Bawtisä Juanćha śhalcämun’; waquinnincunañatacmi: ‘Diospa unay willacünin Eliasćha cutïmun’; juccunañatacmi: ‘Diospa jucnin unay willacüninpisćha cawsämun’ niyalcäśhunquim” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nipäcuptinmi: “Amcunapïtá ¿pitan chayurá ya'a cayá?” nila. Niptinmi Pedro nila: “Am'a canqui Diospa Caćhamuśhan Salbacücämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Caynu niptinmi ćhuncay-ćhuncayta: “Mayan caśhätapis amam mayanćhüpis limalcälinquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nishanpïmi: “Jerusalenta linämi. Chayćhu ya'a Rasun Nunap Chulintam prinsipal yaśhacuna, puydï sasirdüticuna, llapa yaćhachicünincuna sumä-sumä ñacachipämal wañuchipäman'a. Jinaptinpis quimsa muyunpïtam ichá caśhan śhalcamuśhä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cayta nilculmi llapanta nila: “Rasunpa mayanpis ya'ap laśhćhüman jalumuyta munäcá quiquinta un'acuycul muyun-muyun jalumuchun ima pasaptinpis wañunancama. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ñatac cawsayninta ama-pacha nïcá cawsaynintam apacun'a. Ya'a-laycu bïdantapis uycücämi ichá cawsaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Chaynu quiquillan almanta mana salbaptin'a ¿imapätan bälinman masqui jinantin pachäta gänäluptinpis? ");
INSERT INTO qvwNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chayurá mayanpis ya'apïta ütac yaćhachicuynïpïta pin'acamäcätá ya'a Rasun Nunap Chulinpis sumä munaynïćhu, Taytäpa munayninćhüpis, chuya anjilcunawan cutimuynïćhu paycunapïpis pin'acuśhämari. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Rasu-rasunpa waquinniquicuná manalämi wañupäcunquilächu Diospa gubirnunta manalä licaycälil'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pusä muyunnuy cay nishancunaca pasäluptinmi Pedrocta, Jacobocta, Juantawan puśhaculcul Jesus chunyä ulup puntanman ishpila Diosta mañacü. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Chayćhu mañacuyaptinmi cäranpis müdananpis sumä-sumä chipyayä yuläman muyülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Jinaptin paypa lädunćhu Moiseswan Diospa unay willacünin Eliasmi sumä cayninćhu licalïlälin paywan limaśhtin. Chayćhümi limapäcula Jerusalenćhu Jesuspa ñacayninpïtawan wañuyninpïta. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Chayćhu Pedroctawan juccunäta maynu puñuy aysacuyaptinpis callpawan licchapäcula. Chayćhümi Jesustawan chay umrïcunäta sumä-sumä intïnu chipipicyayalcäta licälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chaymi cay ishcaynin umrïcunaca licuśha nicuyaptin Pedro nila: “Yaćhachicü taytáy, allinpächućh jinam śhapämuñá. Canan-ari quimsayquipä jucnincä-cama chucllacta lulälälipuśhayqui, ampä, Moisespä, Eliaspä” nil. Cay niyllamanmi shimin paćhyala. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Caynu niyällaptin pucutay ji'alpalcamul ñiticalpuptinmi manchalicälälisha cacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chaypa śhun'unpïtam ayalpämun: “Paymi cuyay chulí. Payllactari uyaliculcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chaynu nilpämuptin-pachallam Jesus japallanña licalïlun. Lluy cay pasaśhancunätam śhun'unćhu uywapäcula imaypis cay licänin yaćhapacünincuna mana pictapis willallal. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chay wäla ulüpi cutilpayämuptinmi achca nunacuna talipapämula. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chay nunacunap ćhawpinćhümi juc nuna ayaycaćhaypa nïmun: “Taytáy, ama chaynu callaychu. Llaquipaycapallämay. Japallanmi chulillá capalläman. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paytam wañupaynu chalallan. Jinaptinmi pushumayta ätumun. Ima anlalä chaynu lulachipallämanpis. Jinalcul jinalculmi lluy ñacachipalläman; chay ishyaynin manam caćhaycälinchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chaymi yaćhapacüniquicunacta sänaycachipallämänanpä ruygacullälá. Ñatac manamá atipapäcullanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Niptinmi: “¡Ay, mana chalapacuyniyu pasaypi ćhanćha umacuna! ¿Imaycamatan amcunacta awantaśhtin cayäśhä? Má, cayman-ari puśhamuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chay walaśhta puśhaycayämuptinmi achatu yapa tapsilcul cućhpächinñatac. Jinaptinmi Jesus chay achatüta: “¡Cay walaśhta caćhaycuy!” nil alüla. Chaynu sänalcachilmi: “Cay walaśhniqui” nil taytanman uycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jinaptinmi chayćhu nunacunaca: “Diosninchic cay lulaśhantanu'a manamá pipis lulanchu maynu pudirniyu calpis” nil licapayllaman camälälila. Chaynu niyalcäśhancamam yaćhapacünincunacta Jesus nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Cay nishäta sumä uyalipämay, ama un'apäcuychu. Ya'a Rasun Nunap Chulinca puydï nunacunap maquinman ćhulaycuśham caśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Niptinmi cay nishancäta mana tantiapäculachu mayanninpis mana tantiapaśh captin. Ñatac tapuycuytá manchaculcälatacmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chaypïñatacmi yaćhapacünincuna: “¿Mayanninchicćha mas puydïnin caśhun?” nil rabyatyachinacücuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Caynu imaymanacta pinsal ninacuyaptinmi Jesus tantialcul juc walaśhchacta lädunman taycacaycachil nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Cay walaśhchäta ćhasquïcá ya'apa caśhan-laycum ya'acta ćhasquiyäman. Chaynütacmi ya'acta ćhasquimäcá quiquin caćhamänïtapis ćhasquiyantac. Jinaman amcunaćhu mana cäpä licaśhanchiccämá mas puydïpä licaśhatac cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Niptinmi Juan: “Yaćhachicü taytáy, juc nunactam licälälí ampa pudirniquiwan Satanaśhpa gänaśhacunacta sänayächishanta. Chaymi ya'anchic caśhtapi mana captin lluy mićhacälälilá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Niptinmi: “¿Imapämi mićhaculcanqui? Mayanpis ya'anchicpa cuntranchic mana cäcá ya'anchicmanmi śhalcapäcun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chaypïñatacmi wañunanpä sircacaycayämuptin, Jerusalenta linanpä allicta balurchacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Chaymi Samaria malcap pasanan captin jamapaculcänanpä juc wasicta ashichimü ñawpachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chaynu ñawpalcul ashipämuptinmi mana mayanpis awnipäculachu Jerusalen malcäta lishanta tantialcälil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaynu mana pipis awniptinmi, Jesus ćhämuptin Juanwan, Jacobo nila: “Taytáy, unay Eliasnu ¿manachun cay malcäta janay pachäpi ninacta ji'alpächimul camacaycälächïman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chaynu niptinmi piñapäla: ˻“Cay nunaca manam śhamula nunacta wañuchicüchu, sinu'a salbaycüninmi”.˼ ");
INSERT INTO qvwNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nilculmi juc-lädu malcaman pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chaypi liyalcaptinmi juc wayapa Jesusta nila: “Taytáy, mayta liptiquipis atishayquim” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Niptinmi: “Atücunäpäpis maćhaynin canmi. Pishucunäpapis ishnan cantacmi. Rasun Nunap Chulincäpañatacmi ichá mana mayman umalläta ćhulaycunalläpäpis canchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nilculmi juctañatac: “Acuchun, yaćhapacüní canayquipä” nila. Niptinmi: “Taytáy, papänïmi maquïćhülä cayan. Pampälulñaćh ichá aticman” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Niptinmi: “Jina wañuśhacunaca wañünincunacta pampaculcächun. Am'a Diospa gubirnunpi willacamuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chayćhümi jucñatac: “Taytáy, anwan linäpä listum ya'a cayá. Ñatac jamá, wasïćhu cäcunäpïlä dispidicamuśhä.” Nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Niptinmi: “Mayanpis ärayta allaycul'a, manamá ipanta licaśhtinchu äran. Chaynümi unay cawsayninman cutiyta munäcá Diospa gubirnunćhu sirbinanpäpis nï bälinchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaypïta Jesus anćhish ćhunca ishcayniyüta aclalculmi ishcay-ishcay puntachila linancunäman. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chayćhümi nila: “Cusichananchic alli-allimari cacuyan; apaycücunäñatacmi ichá ashlla. Chaymi Duyñunta mañaculcänayqui cusichäcunacta caćhaycamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Má, Canan amcunacta caćhalcac atücunap ćhawpinmanmi uwishta-yupaypis. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lipäcul yan'al-lätac luncuyquita, illayniquita, cambiacunayquipä śhucuyniquitapis apayalcanquiman. Wayrallam lipäcunqui. Caminu pulï nunacunawan tincul yan'al-lätac gänaśh limacunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mayanpa wasinmanpis ćhal'a ‘Diosninchic jawcallacta caycachishunqui’ nilmi duyñunta saludaycälinqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chay wasiyu allin nuna-cama captin'a cay niycuśhayquinümi lulacacun'a. Shimi puntallanpa ćhasquishuptiqui'a Diospa yanapaynin amllawanmi caycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","“May malcamanpis lipäcuptiqui allinpa ćhasquiycälishuptiqui'a chay yaycuycuśhayqui wasillaćhümi quïdapäcunqui. Amam wasin-wasin yan'al pulipäcunquichu. Imallactapis uycuśhuśhayquitá mana pin'acullal awnilmi micacalpälinqui, upyacalpälinqui. Lulapacücá lulaśhanpi ćhasquiycunanmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Chaynütacmi ishyänincunactapis sänaycachipunqui. Ñatac paycunactam: ‘Diospa gubirnun'a janayquićhüñam cayan’ nil niycälinqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Sïchuśh chay malcäćhu mana ćhasquipäcuśhuptiqui'a chayurá cälliman yalalcamul: ‘Cunca cuchuyniquiñaćh can'a. Ćhaquïman la'amä pulbullayquitapis manamá apayächu. Tuquicta yaćhapäcuy: ¡Diospa gubirnun'a janayquićhüñamari cayan!’ nil tapsiculcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rasunpa, cäraycunan muyuncäćhu'a Sodoma malcapïtapis mas mućhuycachishalämi chay malcacá can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Imanuylä capäcunqui Corazin malca! ¡Imanuylä capäcunqui Betsaida malca! Amcunaćhu milagru lulaśhäta Tirowan Sidon licapäcunman cala. Chayürallaćh juchanpi wanaculcal sumä pin'acuywan llaquicuywan Diospa ñawpäninćhu uyshuläpacunman cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chayurá rasunpa cäraycunan muyuncäćhu'a Tirowan Sidon amcunapïta mïnus mućhuycachishalämi capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ñatac amcunapis Capernaum malca ‘Altuman juluśhaćh capäcuśhä’ niyalcanquićh. Aśhwanpa allpäpa lulïninmanlämi wicapäśha capäcunquipis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nilculmi yaćhapacünincunacta: “Cay nishäta uyalipämay. Willaśhayquita ćhasquïcunacá, ya'actam uyaliyalcäman. Chaynütac mana ćhasquishüniquicunacá ya'actamari mana ćhasquipämanchu. Chaynu ya'acta mana ćhasquimäcunacá caćhamäní Taytätapis manatacmi ćhasquinchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chay nilcuptinmi chay anćhish ćhunca caćhaśhancunaca liculcal cutïlälimula unaypïtá sumä cushisha-cama. Chayćhümi nipäcula: “Taytay, aśhta achatucunapis lluymi cäsüläliman ampa śhutiquita limapäcupti'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nipäcuptinmi nila: “Aw, Satanaśhpa tucuy gubirnun waclinuy juclla chincacuśhantam ya'a licalá. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rasunpa, chaypämi ya'a pudirnïta upäculac. Chaymi aśhta culibraycunapis, ćhupa apaläcucunapis jalupäcuptiquipis mana imanapäcuśhunquipischu. Chaynütacmi imaymana Satanaśhpa pudirnintapis mana cäman muyuchipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Chay satanaśhcunaca cäsupäcuśhuśhayquipïta cushiculcänayquitá aśhwanpa cushiculcay altu sïlućhu śhutiquicuna ñä asintäśha caśhanpïta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chayćhümi Jesus Chuya Ispirituwan sumä cushisha nila: “Alawaycucmi janay pachäćhu cay pachäćhu cä Tayta Diosní. Lluy yaćhayniyu, umayu nunacunäpi caycuna pacaycuśhayquitam tantiaycachinqui mana cäpa licaśha nunacunäman. Aw, Taytay, caynu canantam munalanqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Chaypïtam nunacunäta nila: “Taytämi ya'ap maquïman ćhulaycamula cay lluy munaytapis yaćhaytapis. Taytallämá yaćhan paypi śhamüśha caśhäta. Chaynütacmi ya'alla yaćhá pay mayan caśhantapis. Chaymi mayantapis lisiycachishäcälla Taytäta lisipäcun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chay nilculmi yaćhapacünincunallacta japä nila: “Cay licaśhayquipi cushisha capäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Rasunpa achca unay mandacücunäwan Diospa willacünincunam ichá maynu wañupacuyalcalpis caycunacta mana licaycälilachu nï uyaliycälilapischu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chaypïmi camachicuyta yaćhachicüca yaćhapänan-laycu Jesusta tapula: “Yaćhachicü taytay, ¿imactatan lulaycüman wiñay simpri cawsanäpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Niptinmi quiquinta tapula: “¿Imanintan Moisespa camachicuyninćhu lïgiptiqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Niptinmi: “ ‘Tayta Diosllayquiman tucuy śhun'uyquitapis, llapan pinsayniquitapis, lluy callpayquitapis ćhulaycuy. Ñatac nuna-masiquita tucuy śhun'uyquiwan quiquiquitanuy cuyacuywan licaycuy’ niyanmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Niptinmi: “Allintam niyanqui. Chaycunacta lulal'a wiñay simpripämi cawsanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Niptinmi “¿Caychun upällächimanman?” niycänu tapulañatac: “Nimay rasuncäta. ¿Ima nunapïtan niyanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Niptinmi nila: “Má, canan uyalimay. Juc nunash Jerusalenpïta Jericó malcaman liñä. Chay liyaptinshi caminućhu suwacuna lluy ma'alcul calapatäla. Jinalculshi pasaypictaña jitalayäta caćhaycul liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chaypi unascactash licalïmun juc allin rispitaśha sasirdüti. Jinalshi chay jitalayä nunäta licalcullal pasacun mana llaquipaycul ima. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chay unay ipantañatacshi sasirdütip yanapänin Leví caśhta nunapis licalïmun. Chaypis chaynütacshi pasacun licalcul licalcul juc-lädunpa. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chay jina ipanmanñatacshi licalïmun jamuyäcuśhan Samaria-lädu nuna. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Payshi chay nunäta licälul-pacha śhun'unpis alalaycuptin yanapaycü cürriycula. Jinalculshi lluy dañäduncunacta asaytinwan bïnu rimidyunwan jampiycula. Jinayculshi intiru dañädunta lataśhwan wataycul uywanman sillacalcachil apala juc wasiman chayćhu cuydaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chay walantinñatacshi licunanpä chay wasiyücäta illayta pägaycul nila: ‘Cay nunäta cuydaycul ima nisidällantapis alcansaycapällämanqui. Maychica gastaptiquipis cutimulmi ya'a cutiycachishayqui’ ” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cayta nilculmi Jesus tapula: “Má nimay, cay quimsanpïta ¿mayannintan chay nunäta cuyala?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Niptinmi tapucü nunaca nila: “Llaquipaycul lluy dañäduncunacta jampiycücäćhari” nil. Niptinmi: “Chayurá ampis paynu-ari lulamuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chaypïtam Jesus llapa yaćhapacünincunawan Jerusalenman pasayal juc tacsa malcallaman ćhälälin. Chayćhümi Marta śhutiyu walmi jamachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Chayćhu Jesus yaćhachiptinmi ñañan Maria ima lulaynintapis caćhaycul Jesuspa ñawpäninman taycucuycul gänaśhwan uyalila. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martañatacmi ichá lulayninćhu mastá afanädu-afanädu cacuyan. Chaymi Jesusta nila: “Taytay, ¿ampá allinchun cay ñañá mana imallactapis yanapämal yan'al cayäśhan? Niycullay-ari yanapämänanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Niptinmi Jesus: “Marta, Marta, cay-chica lulayniquiwan sumä-sumä afanädum cayanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jucllamanmi afanaculcanquiman. Chay sumä ćhaniyücätam canan ñañayqui aclaycula; chaypi ya'a manam mićhacümanchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Juc-punćhümi Jesus limala Dioswan. Chay limayta camacäluptinmi jucnin yaćhapacünin nila: “Taytay, Dioswan limayta yaćhachipämay Bawtisä Juan yaćhapacünincunacta yaćhachishannüpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Niptinmi Jesus nila: “Caynümi ninqui: ‘Janay pachäćhu cä Tayta Diosnillá, amllamá altuman juluśha canqui. Gubirnuyqui śhaycamuchun. Janay pachäćhu lulaśhayquinu, cay pachäćhüpis munayniqui lulaśha cachun. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Canan muyunpä micuyta uycälillämay. Ama-ari pishiycachillämaychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mana allin lulamänïcunäta pampachäśhämannu juchäcunacta pampachaycälillämay. Mana allin lulaycunaman palpupäcunäpä ama-ari caćhaycälillämaychu. Aśhwanpa chaypi licaycälillämay’ nil.” ");
INSERT INTO qvwNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nilculmi: “Ñatac jicutayllawan-ari imaypis mañaculcay. Canan má, amcunapis jucniqui lipäcunquiman ćhawpi tuta cuyanacuśhayqui nunap wasinta. Ćhaycul nipäcunquiman: ‘Ama chaynüchu cay. Quimsa tantallayquita mañaycallämay. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Calu lisinacuśhämi mana imayüta talilläman’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Niptiqui: ‘Lluy siguraculcul cämäćhüñam cayalcá. Manam pipis quićhäśhunayquipä canchu’ nil nimuśhunquiman. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chaynu nishuptiquipis ‘uycamächun’ nïcänuy masta tücapäcuyanquiman. Chaynu jinacuyaptiqui ‘mayñaćh cacunpis’ nil śhalcalcamul uycuśhunquiman mañacuśhayquita. Chayta uycuśhunquiman manaćh apanacuśhayquipachu sinu'a manaña yalucälil tücapäcuyäśhayquipaćh. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chaymi ya'a nipäcuc: Diosta mañacuy; uśhunquim. Payta ashipäcuy; talinquim. Puirtacta tucaycuy; quićhaśhunquim. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pipis mañacücá ćhasquinmi; ashïcá talinmi; puirtanta tucaycücätá quićhanmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Mayanniquitan chuliquicuna tantacta mañacuśhuptiqui lumicta uycälälinquiman? ¿Challwacta mañacuśhuptiquipis, culibrayta uycälälinquiman? ");
INSERT INTO qvwNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ütac luntucta mañacuptin ćhupa apaläcucta? ");
INSERT INTO qvwNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","¡Maynu juyu cayalpis chuliquicunacta allincäta uyalcaptiquichun ampá janay pachaćhu cä Taytayqui, Chuya Ispirituntalä mana uycälishunquimanchu!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc-punćhümi achatup maquinpïta juc upächisha nunacta Jesus caćhaycachila. Chayćhu shimin tuqui-tuqui paćhyäluptinmi llapanpis “¿Imactatan licayällá?” nil licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Chayćhu waquinnincunañatacmi: “¡Caytá achatucunap quiquin puydï Beelzebüpa munayninwanmá aluyta jicutayan!” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquinnincunañatacmi yaćhapänan-laycu: “Má, altu sïlupi ima siñalllactapis licaycälichipämay” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chaynu pinsaśhancunacta tantialmi Jesus nila: “¿Imanuypatá chaynu cälunman? Juc nasyunćhu quiquin-pula pilyapäcul'a lluyćha chincachinacunman. Chaynütacćha juc wasillaćhu pilyapäculpis pampaman muyuchinacunman. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","19","Chaynümi Satanaśhpis quiquin-pula cuntra cayal'a laquinacüśha cayan. Chaynu captin'a ¿imanuypatá mandacuynin tacyaycunman? ‘Beelzebüpa munayninwanmi cay'a aluyan’ nil pinsapäcuptiqui'a amcunap atïniquicuná ¿mayanpa munayninwantan-nila lulayalcan? Tapupäcuy-ari. Má, mayanpa munayninwan lulayá nilshi nipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ya'a Diospa maquinwan achatucunacta caćhaycachiptïmi ichá, tantiapäcunayqui quiquin Diospa gubirnun ćhämuśhuśhayquita. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Má, juc nuna sumä armädu wasinta täpayaptin'a ¿mayantá ampá imantapis suwälunman? ");
INSERT INTO qvwNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Paypïta mas allin armädu juclla licalilcamulćha ichá chalapacuśhan armantapis waycalcul apacunman lluy imallantapis. Jinalculmi lluy munaśhanta lulal pimanpis aypunman. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Chayurá ya'a partïpi mana cayäcá, ya'ap cunträmi licaliyan; juntuyta mana yanapämäcá chi'iyächinmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Má, chay achatümari juc nunacta caćhaycul pulimun chunyä lanla-lanla ulucunäćhu jamananpäpis ashishtin. Chaynu mana talilmi ‘Jamá, cutiycuśhä punta yaćhaśhäcäman’ nil caśhan cutimun. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jinalñatacmi chay nunäta talin tuqui allichäśha wasi-yupaytapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chayćhümi cutiycun pasaypi anćhish masannincunacta inquitacuycul. Chaynu cutiycul yaćhapäcuptinmi chay nunaca puntapïpis piyurlä cawsaynin” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chaynüta niyaptinmi, chay achca nunacunap ćhawpinpïta ayaycaćhaypanuy limämula juc walmi: “¡Maynu cushishalä cayan waćhaśhüniqui, ñuñuśhüniqui walmica!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Niptinmi Jesus: “Aśhwanpa Dios nishanta uyalil cäsucücunaca cushisha capäcuchun paypïpis mastá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Niyaptinmi mas achca nunacuna juntunacämuptin willala: “Canan timpu pasaypi-cama nunacunaca siñalta licaycuylläpi wañupacuyalcan. Canan'a willacü Jonaspa siñal pasaśhallantam licaycälinqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Paymi juc siñal cala chay timpu Ninive malca nunacunäpä. Chaynümi ya'a Rasun Nunap Chulinpis caśhä juc siñal cay timpu nunacunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Chaynütacmi unay Sheba malcanpa mandä walmipis ‘Puydï Salomonpa yaćhayninta maynümi uyaliycuyta muná’ nil calu-calupïlä śhamula. Chaymi canan amcunaćhu Salomonpïpis mas puydïcätalä mana uyaliculcäśhayquipi mućhuycachinan muyuncäćhu chay walmipis śhalcamun'a cäraycälishunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chaynütac Ninive nunacunäta Jonas willaptinmi juchancunacta wanaculcul Diosman cutipämula. Chaymi canan amcunaćhu Jonaspïpis sumä munayniyücätalä ipanchapäcuśhayquipi mućhuycachinan muyuncäćhu Ninivecunaca śhalcatityamun'a cäraycälishunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Manamá juc michïructa latalcachil pacaycunchichu. Nïtac mancamanpis winälunchichu. Aśhwanpam ćhulanchic altuscanman lluyta acchiptin yaycamücunäca sumä ima caśhantapis licananpä. Chaynümi ya'apis mana pacacüchu mayan caśhätapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Má, canan sumäta pinsaycäliy. Juc acchi-yupaymi ñawinchic imactapis licachimanchic, tantiachimanchic. Ñawiyu cal'a, rasunpa tantiapäcunquimanmi mayan caśhätapis. Mana ñawiyu calćha ichá, nï tantiapäcunquimanchu juc yanawyayä tutapäćhu cayä-yupaypis. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Yan'al-lätac ‘Allintam lisí’ nicuśhayquita mana lisinquimanchu. Rasunpa tuquicta lisimal'a, mana pantaycullalćha, lluyta tantialpunqui. Chayćhüćha fisyuyqui licalilpun'a acchiman-yupaypis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus chayćhu limayta camacalpuyaptinmi juc fariseo puśhala wasinman micapäcunanpä. Jinaptinmi wasinman yaycul maquinta mana pa'acul mïsanćhu täcuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Chaymi chay puśhä fariseoca jamuyäcuyäla “¡¿Imaca nunatan cay mana lulayninwan Diosta piñachinanpä?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Niptinmi Jesus nila: “Am fariseocuna janällanta pa'aśha täsacunaca plätucunanümi cayalcanqui. Ñatac śhun'uyquiwan pinsayniqui'a imapis suwacuśhayquip waycacuśhayquip juntäśham cayan. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana tantiayniyu nunacuna! Cay janäninchictawan lulïninchicta Dios lulamäśhallanchictapis ¿manachun tantiapäcunqui? ");
INSERT INTO qvwNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Capuśhuśhayquipïta lluy buluntäniquiwan uycäliy-ari. Chayurá janäpis lulïpis tuqui allinćha caycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ñatac canan ¡amcunap bïdayqui imanuylä can'a! Mastá wañupacuyalcanqui ‘Ima jaćhacunapïpis, rüdacunapïpis Diospä japächaśhun’ nishallanmanmi. Ñatac Diospa cuyacuyninpi tincüninman licaycuy nishuśhayquitam ichá ipanchayalcanqui. Chaymi chullanllanta lulaśhayquinu'a pulantapis lulaycunquiman cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Fariseocuna, ¡bïdayqui imanuylä can'a! Amcuna juntunaculcänan wasicunaćhüpis allinnincunap täcunanmanlämi wañupaculcanqui. Läsacunäćhüpis allinpa licapäcuśhunallayquipïmi wañupacuyalcanquitac. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ishcay cära fariseocuna, ¡imanuylä bïdayqui can'a! Quićhäśha nïchu pacaläcänümi cayalcanqui. Chaymi pipis jalücunacá ima pasanantapis mana yaćhapäcunchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chaynüta niptinmi camachicuyta jucnin yaćhachicü nila: “¡Cay nishayquiwan'a ya'acunactachućh jinam ruydupayalcämanqui!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Niptinmi: “Am yaćhachicücäpa bïdayqui ¡imanuylä can'a! Amcuná nuna-masiquicunaman täwayalcanqui imaymana camachicuyta mana apay atipayaptinpis. Jinaman'a llasä ipinmannuy mastalä ćhulculcalpis amcunañatacmi ichá nï uchucllapis unculcälinquipischu. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Amcunap bïdayqui imanuylä can'a! Amcuna manam mayta chayta lipäcunquichu Diospi willacücunäta wañuchï unay awiluyquicunapi. Jucllapi luläcänümi paycuna wañüchiptin amcuná pampaläśhancäta impidrayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cay jinaśhayquiwanmi awquilluyquicuna lulaśhancunaman śhalcuyalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Lluy caycunacta Dios yaćhalañam. Chaymi nila ‘Puydï caćhäcunactapis willacünïcunactapis caćhamuśhämi. Waquinnincunactá wañuchipäcun'am. Waquinnincunactañatacmi ñacachipäcun'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chaynu lulapäcuśhayquipïmi cay pacha allaycuyninpi Diospa willacünincunacta lluy wañuchipäcuśhancunapïtapis juchachaycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Caynu juchachapäcuśhunqui Abelpïta aśhta Diospa chuya wasinćhu wañuchisha Zacariascamam. Chayćhu yawarninta jićhaśhanpam amcuna juchachäśha capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Camachicuyta yaćhachicücuna, ¡imanuylä bïdayqui can'a! Diospa yaćhachicuyninta iridacaycälinquimá. Jinalcul'a manatac juccunactá cunsintipäcunquichu Diospi yaćhanallantapis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Niptinmi camachicuyta yaćhachicücunäwan fariseocuna sumä-sumäta rabyälälila. Jinalculmi Jesusta imaymanacta tapućhaculcäla quiquinpa limayllanwan palpachipäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chaypïtam nisyu-nisyu nunacuna juntunacälälimula aśhta quiquin-pula jalutanaculcänancama. Chayćhümi yaćhapacünincunacta Jesus nila: “¡Yan'al-lätac chay ishcay cära fariseocunäpa libadüra imanpïta! ");
INSERT INTO qvwNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ima pacaläcäpis camalaycun'amari. Pacaśhacunaca lluymi licaycachisha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chaynütacmi amcuna pacallap ima nishayquicunapis lluy camalaśha can'a. Ñatac linlillayquićhu uyalishayquipis wasi jananpi ayaycaćhayänümi willacuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Chayurá cuyaśhäcuna, cay janä aychallanchicta wañuchïcätá ama manchaculcaychu; wañulcachil mastá maytañam wañuchinman. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aśhwanpa Diosllanchicta manchaculcay. Payllamá wañulcachil almayquita nina waläcäman jitaycunanpä munayniyüca. Rasunpa, pay puydïcällactam manchaculcanquiman'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Manachun picha pishucunacta ashllay ćhaniyüllawan lantinchic? Chaynu cayaptinpis manamari jucllayllanpis Tayta Diospá un'aycuśhachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Chaymi aśhta ächayquipis yaćhaśha cayan ayca caśhanpis. ¿Chaychun amcunacta un'älälishunquiman, imamá? Chayurá manam imapi manchaculcänayqui canchu. Pishucunapïtapis mas ćhaniyülämá cayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Chaymari cayćhu ‘Pay caśhtam cá’ nil nunacunäćhu nimäcätá, janay pachäćhu Diospa anjilnincunap ñawpäninćhu ya'a Rasun Nunap Chulincäpis ‘Ya'a caśhtam pay'a’ nishä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ñatac ‘Manam lisïchu’ nimäcätam ichá, ya'apis Tayta Diospa anjilnincunap ñawpäninćhu ‘Paytá manam lisïchu’ nishä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Masqui Rasun Nunap Chulincäta jalutacamaptiquipis Tayta Dios pampachaycuśhunquimanmi. Chuya Ispiritucta chaynu jalutacuptiquim ichá nï pampachaycuśhunquimanñachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ñatac amcunacta malcacunap gubirnäcunap juntunacücunap puydïninpa maquinman ćhächipäcuśhuptiqui, ama llaquiculcaychu ‘canan ¿imactatan limalicuśhä?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chay üram Diospa Ispiritun yaćhayta uśhunqui, imacta limalicunayquipäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chay achca nunacunapïtam juc nuna Jesusta nïmula: “Taytay, mayurnïtari papänïpa tücäninta partiycamänanpä niycapämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Niptinmi: “Caynu nimänayquipä ¿pitan ya'acta albasyayquipä ćhulacamäla?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chaynu nilculmi llapantapis nila: “Imapïpis wañuyäcuna, yan'al-lätac cay munaśhayquiwan gänachicuyalcanquiman. Masqui maynuy imayqui calpis manam tuqui cawsayta uśhunquichu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chay nilculmi juc nunawan tinculcachil nila: “Má, juc nunapshi talpucuynin sumä-sumä ishpïñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chayshi pinsäla: ‘Canan ¿imanäśhätan caynüpa micuyní ishpïluptin? Manam mayman pilwaycunäpäpis jäcunñachu’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nilculshi pinsälun: ‘Mïjur-ari, rüjïcunacta jatunyächishä chayman lluy pilwacunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chayćha jitalällal micucunäpä upyacunäpä capaman'a. Ya'ap bïdanu'a pip bïdantá canman’ nilshi micuyninman atinïdu alawacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chayshi Dios nila: ‘Luclu nuna, canan tutam wañunqui. Chayurá ¿mayanpäćha chay imayquipis quïdan'a?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chaynümi pasan'a quiquillanpä imapis ambisyacü nunacunäwan, maynu rïcu cayalpis Diospa ñawpäninćhu'a pasaypi wacchacunawan'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaypïtam Jesus yaćhapacünincunacta nila: “Ama ‘¿Imactalä micuśhä; imawanlä müdacuśhä?’ nil llaquicuyalcaychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bïdayquim mas bälin cay micuycäpïtá; aychayquim mas bälin cay müdanapïtá. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Má, pinsaycäliy imaymana pishucunäman. Paycunap manam talpuynin nï cusichan nï rüjin nï iman canchu. Jinaptinpis janay pachäćhu cä Taytanchicmi paycunactá micachin. ¿Manachun mas ćhaniyu cay pishucunapïta capäcunqui imatá? ");
INSERT INTO qvwNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Maynu wañupacuyalpis ¿mayantá juc üra masllactapis cawsayninta aśhuycächinman? ");
INSERT INTO qvwNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Cay uchuc lulayllactapis mana atipayal'a ¿imapïtam priucupaculcanqui juccunaman? ");
INSERT INTO qvwNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Licapäcuy imaymana waytacunätapis. Manam puchcacunchu nï awacunchu. Ñatac Diosninchicmi tuqui-tuquicta waytachin. Rasunpa, unay puydï mandacü Salomonpis manam mayannin waytanüpis llipyayä müdanawan calachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Waytacunacá wala śhalun chaquillam, ñatac chaynütapis Diosninchicmi tuquicta müdachin. ¿Chaychun ampá amcunacta mana müdachipäcuśhunquimanchu, mana chalapacuyniyu nunacuna? ");
INSERT INTO qvwNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Chayurá ama ‘¿Imactalä micüśhä, imactalä upyäśhä, imawanlä müdacüśhä?’ nil wañuy-wañuy llaquicuyalcaychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Diosman mana chalapacücunallamari chaynu wañupaculcan. Amcunapñatacmi ichá Tayta Diosniqui ima pishipacuśhayquitapis yaćhayanña. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chayurá wañupaculcay paypa gubirnullanćhu canayquipä. Jinaptiqui'a lluy pishipaculcäśhayquitapis uycälishunquim. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Cuyaśhá uwishnïcuna, ama manchaculcaychu. Tayta Diosninchicmari: ‘Cushicümi ya'ap imapis cäní amcunaman uycunacpä’ nil unanchaycuyanña. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chayurá lluy imayquitapis lanticulcul mana cäniyücunäman aypuycäliy. Chayta lulal'a janay pachäćhümi alli-allicta pilwacuyalcanqui mana imaypis camacäta. Chayćhümi nï imaypis puyun'achu nï pipis suwaśhunquichu. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mayćhümi cäniqui cayan; chayćhümá pinsayniquipis muspayniquipis cayan” nila. Nilculmi nilatac: ");
INSERT INTO qvwNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Amcuna listuña musyat-musyat capäcuy cutimuynïpa. Maynümi wasinta täpachicuptin wasi täpäca alcayan michïrun walachicuśhallaña listu wasiyünin tacaycamuptin-pacha quićhaycunanpä, chaynümi amcunapis licchat-licchat capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Maynu allinpa licaśham can'a mayantapis wasiyüca caynu licchayäta talishancá. Rasunpa chay wasiyüćha allichaculcul mïsanman sirbiycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Rasunpa ćhawpi tutapis ütac imay ürapis ćhämul licchayäta talïluptin'a maynu cushicuylä paycunapä can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Yaćhapäcuśhayquinüpis, wasiyüca suwanan üräta yaćhayalñá manam jawcachu puñucun, aśhwanpam mana suwachicunanpä listuña täpayan. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chaynu-ari amcunapis musyat-musyat capäcuy; manamá yaćhapäcunquichu imay üra ya'a Rasun Nunap Chulinca ćhämunätapis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chaynu niptinmi Pedro tapula: “Taytay, ¿cayta niyalcämanqui ya'acunallactachun icha juccunactawanchun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Niptinmi nila: “Ima chalapacuna yaćhay-sapa tantiayniyu uyway nunactapis niyämá. Caynu nunactamá ‘cay wasïpi incargacuy’ nil maquinman ćhulaycunman lluy nunancunactapis ürallanćhu micachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cushisha cachun imam chalapacuśhanmannuy lulayäta talïluptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Paytamá duyñun lluy cänintapis licaycunanpä maquinman ćhulaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Yan'al-lätac chaynu chalapacuśhan nunan ‘¿Imayläćha canan cutimun'a?’ nilcul uyway-masincunacta ñacachiyta allacuycunman. Jinal munaśhanta lulal upyacunman micucunman wasictapis lluy un'aycul. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Rasunpa duyñun un'aypi mana pinsaśhan üra ćhämul ¿imanälun'aćh? Sumä lawćhayculćhá mana chalapacücunap laśhćhunman ćhaycälichin'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wasiyünin imanuy lulanantapis allinta yaćhapayal, ardïdi mana luläcätá piyurtalämi mućhuchin'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ñatac imanuy lulanantapis mana rasunpa yaćhayal, mana allinta luläcätá manaćh juccätanüchu mućhuchin'a. Chay lulananman chalapacul maquinman ćhulaycul'a gänaśhwanćha alcan'a chay lulaynincunacta. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ya'a śhamulá llapa nunätapis nina-yupay lluy imanuy caśhantapis camalächinäpämi. ¡Mayñapis canallan caycuna lulacacanmanña! ");
INSERT INTO qvwNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Caycuna pasananpämi ichá jatun allin ñacaycunalä alcacayäman. ¡Maylä ñacaśha caycuna pasanancamá! ");
INSERT INTO qvwNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“¿Amcuna ‘Jawca cawsaytaćh pay umäśhun’ nilchun niyalcämanqui? Manamari. Sinu'a iwinacuytam ya'a apayämú. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpïmari ya'a-laycu juc wasillaćhu picha cäcunaca iwinaculcan'a quimsawan chay ishcaycunaca. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taytanpa cuntranmi śhalcun'a cari chulinpis, taytanpis chulinpa. Mamanpa cuntran walmi wawinpis; mamanpis wawinpa. Chaynütacmi suyranpa cuntran llumchuyninpis, suyranpis llumchuyninpa” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nilcuśhanpïmi llapan nunacunäta Jesus nilañatac: “Pucutay yanalpamuptinmi, ‘tamyamun'am’ nipäcunqui. Rasunpa nishayquinüllam tamyamun. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Waywa talcamuptinmi ‘usyämun'am’ nipäcunqui. Rasunpa chaynümi pasan. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ishcay cära nunacuna! ¡Janay pachäćhu cay pachäćhu siñalcunäta tantiayalcal-lächun canpis, quiquiquicunallaćhu ima pasaśhan siñaltapis mana tantiapäcunquimanchu! ");
INSERT INTO qvwNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Canan-ari śhun'uyquita tapucuy allincäta lulalpälinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chayurá manaläpis mismishancama masqui fisman liyalcalpis ćhïnishüniquiwanpis pampachachicuy. Chayman ćhächishuptiquim ichá fisca wardiacunap maquinman ćhulaycul carsilman jitaycachishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chaypi manamá imaypis yalamunquichu mänu cayniquita limpiu pägamunayquicama” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay achca nunacunapïmi: “Taytáy ¿yalpanquichun chay Galilea nunacunäta Pilato wañulcachil yawarnintapis Diospa cañaycapuśhan uywap yawarninwan talluśhanta? ¿Chaynüpa wañunanpä Diosninchicpa castigunchun paycunaman ćhäla ichá imanuymi?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Niptinmi: “¿Ima amcuná pinsayalcanqui ‘Chay nunacunäta caynüpa wañülächila malca-masincunapïtapis mas jucha-sapa captinćha’ nilchun? ");
INSERT INTO qvwNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Manamá chaynüchu. Juchayquipi mana wanaculcal'a amcunapis chaynümi wañupäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Icha Siloé malcaćhu türriwan ñitichiculcul wañü nunacunäpïtapis ichaćh pinsayalcanquipis ‘Paycuná Jerusalen malca-masincunapïta mas juchayüćhá cala’ nilpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Manam chaynüchu. Mana wanaculcal'a amcunapis chaynüpam wañupäcunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chay nilculmi sumä tantiachinanpä juc ïgus plantayu nunaman tinculcachilñatac Jesus nila: “Juc nunash ćhaclan juntacta plantacuñä ïgusta. Chay wiñäpuptinshi ‘Canan'a ćhulayanñaćhá’ nil pallä lila. Jinaptinshi mana nï juctapis ćhulañächu. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chayshi täpächicuśhan nunanta nila: ‘Caynu śhamú śhamú quimsa watañam “Ćhulayanñapisćha” nil ñatac manam imaypis ćhulaśhanta licächu. Yan'añam chay'a iridal amyayächin ćhaclätapis; má, cuchüluy’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chaynu niptinshi täpänin nunaca: ‘Taytay, cay watallá jinala caycuchun. Icha muyülïninta aśhpiycul wanuchaycuptí ćhulälunmanläpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Caypïtá manaña ćhulaptinćha ichá cuchüśhunña’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juc warda muyunćhümi juntunaculcänan wasićhu Jesus yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chayćhümi cañä juc walmi ćhunca pusäniyu wataña pasaypi curcüśha Satanaśh ishyachiptin. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Chaynüta licälulmi ayalcul: “Mamay, cay ishyayniqui ñam alüśhaña” nilcul maquinwan yataycul chay üralla sänachila. Chaymi waśhan tuqui sänu dirichacäluptin chay walmica Diosta alawäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chaynu warda muyuncäćhu sänachiptinmi, juntunaculcänan wasip puydïnin sumä-sumä rabyaśha nunacunäta nicuyan: “Süta muyunmi imactapis lulanayquipä cayan. Chayćhümi sänachicuyta munal'a śhapämunquiman, manam cay warda muyuncunaćhülächu cürriyalcämunquiman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Niptinmi Jesus nila: “¡Ishcay cära nunacuna! Amcuna ¿manachun cay warda muyuncäćhu uywayquicunacta pasquipäcunqui yacuman micuyman atipäcunayquipä? ");
INSERT INTO qvwNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chayurá ¿imapïtan-nila cay Abrahampi caśhtayqui walmïta mana libraycuchwanchu Satanaśhpa maquinćhu cay-chica wataña cayaptin'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chaynüta Jesus niycüluptinmi llapa cuntrapänincuna pin'acüśha quïdälälila. Llapan nunacunäñatacmi cushiculcäla cay lulaśhancunapi limaśhancunapïpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Chaypïmi Jesus nila: “¿Imanuyćha Diospa gubirnun? ¿Imawanćha tincuycachichwan? Shita mujucta ćhaclaman talpuśhancänümari. Wiñämulmi sumä jatunninlä cacuyan. Chaymi pishucunäpis pallaynincunaćhu lluy ishnachaculcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","“Diospa gubirnunta libadüramantacmi tincuycachichwan. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Juc walmi ash libadürallacta quimsa quintal arinamanlä jitaycüluptinpis jinantintam punquichimun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","23","Chaynu Jerusalenman yaćhachishtin malcan-malcan liyaptinmi, chayćhu Jesusta juc nuna tapula: “Taytay, ¿rasunpachun Diospa lädunman ashchaylla yaycun'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Niptinmi Jesus nila: “Callpanchaculcay masqui may sasa yaycunapä quićhqui puncu captinpis. Chay puncup may-chicaćh yaycuy munapäcun'a, ñatac manamá atipapäcun'achu. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Chayćhu Dios puncunta wićhacämuptinćha ‘¡Quićhallämay, quićhallämay!’ nilcul ayaycaćhapäcunqui. “Chaynu niptiquićhá ‘Manam lisicchu’ nil nipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nipäcuśhuptiquićh ‘Anwan lisinacunchicmi, mayćhüpis miculanchicmi, malcäcunaćhüpis yaćhachilanquitacmi’ nil nipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Niptiquipis: ‘¿May-lädulä cacunquipis? Ya'a manam lisicchu. ¡Ñawïpïpis chincapäcuy, mana allin cawsayniyücuna!’ nilćha nipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Chayćhüćha awquilluyqui Abrahamta, Isaacta, Jacobta, ñatac llapa Diospi willacünincunactapis Diospa gubirnunćhu cayäta licapäcunqui. Amcunañatacćha waśhaćhu quïdälälil wa'apäcunqui quiluctapis lawćhićhicyachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jinamanmi achca mana-Israel nunacuna intirupïta śhapämun'a Diospa gubirnunćhu cumbidunman yaycapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Rasunpa chay timpućhu'a puntanninćhu cäcunämi ipaćhu licalipäcun'a; ñatac ipaćhu licaśhacunämi puntanninćhu caycälin'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cay niyaptinmi fariseocuna ćhälälimul Jesusta nipäcula: “Caypïta licuy. Herodesmi ‘wañuchishä’ niyäśhunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Niptinmi Jesus: “Chay atücäta niycamuy ‘Canan muyuncuná Satanaśhpa maquinćhu cäcunactalämi sänachishä. Wala muyuncunañatacmi ishyäcunacta sänachishä’ nil. Cay lulaśhäta manam pipis mićhacamänan yaćhacunchu. Camacalpunäcamam lulaśhä. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chaymi canan muyuncunapis, wala muyuncunapis, Jerusalenta lishä ćhänäcama. Chayćhümá Diospa willacünincunacta wañuchipäcun; manamá juc-lädućhüchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nilculmi: “¡Ay, Jerusalenćhu nunacuna! ¡Ay, imananquilä Dios caćhamuptin willacünincunacta lumi tamshaywan wañuchïcuna! Juc wallpa chipchincunacta juntuycücänümi achca cuti llapayquitapis jucllaman juntuycuyta munalá. Jinaptïpis amcuna manamá munapäculanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Canan licapäcuy; amcunap malcayqui lluy pulumäśhañam licalin'a. Rasunpa cananpi-pacham manaña nï uchucllapis licapämanquiñachu aśhta ‘¡Altuman juluśha cachun Diospa Pudirnin Śhamüca!’ nil nipämänayquicama” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juc warda muyunćhümi Jesusta puśhala fariseocunap jucnin mandänin wasinćhu cumbidananpä. Chaynu puśhaptinmi: “Má, cay muyuncäćhu ¿imactash lulälun'a?” nil parti fariseo-masincuna Jesusta awaytapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jinayaptinmi chayćhu cayäñä juc nuna intirun llimpuy-llimpuy sacsapacuy ishyaywan. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chayta licalculmi Jesus llapa fariseocunätawan camachicuyta yaćhachïcücunäta tapula: “¿Camachicuyca cay warda muyuncäćhu juc ishyäta sänaycachinäpä cunsintimanchicchun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Niptinmi “Má, cay ¿imanin'ash?” nil lluypis uyaracaycälila. Jinaptinmi, chay ishyä nunäta chalaycullal Jesus sänächila. Jinalculmi “Canan wasiquita licuyña” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nilculmi fariseocunäta: “¿Pimá cay warda muyuncunäćhu aśhnun icha wäcan yacuman śhaticacüluptin mana julunmanchu?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Niptinmi mana nï mayanllanpis imaniytapis atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chayćhümi ayachimuśhan nunacunaca quitanacuylla allin puydïnin nunacunap täcunanman täcuy munayalcäta licälun. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Chaynayäta licalculmi Jesus nila: “Mayanpis juc jatun cumbiduman ayaycachishuptiqui'a ama-ari puydï nunacunap mïsanman täcuyta ućhinacuyalcaychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ichaćh juc mas puydïnin nuna ćhämuptin'a puydïnu täcucuyaptiquipis ayachishüniquica ‘Manamá ampächu cala. Ipaman aśhucullay’ nil nishunqui. Jinaptinćha pin'acüśha aśhupäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Aśhwanpari mayanpis ayachishuptiqui'a ipa-ipallaman taycuculcay. Chay ayachishüniqui ćhämul ‘¿Imactatan cayćhu täcuyanqui? Acuchun, taycawshimay’ nilćha pasaycachishunqui. Chayćha lluy nunacunäpis paywan cuscacta allinpa licapäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Uyalipämay, mayanpis juccunapïtapis masta nunatucücá pin'ayman juluśham can'a. Ñatac mana nunatucullal cäcunämi ichá rasunpalä altuman juluśha can'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaynütacmi cumbidacü nunätapis nila: “Cumbidacul'a ama ayayächimuychu lisinacuśhayqui nunacunallactá, nï aylluyquicunallactá, nïtac imapis cäniyücunallactá. Paycunam amcunactapis cumbidaycul ‘Canan'a uyayninchicta cutiycachinchicñam’ nil nipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Caynu cumbidacul'a aśhwanpari ayaycachimuy wacchacunacta, latacunacta, aplacunacta, ishyäcunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Caynu lulaptiqui'a ampá jatun cushicuyćha can'a. Paycunapá imanwan cutiycachishunayquipäpis manamá capunchu. Ñatac caycunapïta cutiycachishunqui quiquin Diosninchicmi allin luläcunacta śhalcachimunan muyuncäćhu'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chay nïta uyalïlälilmi jucnin nuna nila: “¡Ima cushishalä janay pachäćhu Diospa cumbidunta micücunacá can'a!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Niptinmi Jesus: “Má, juc nunash jatun cumbiducta lulalcachil achca nunacunacta ayachimula. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jinaptinshi micapäcunan ürapá juc nunanwan juntuchimula ‘Canallanshi lilläśhun. Ñam sirbïshaña cayan’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chayćhu mana śhamuyninwanshi jucnin nila: ‘Ćhaclactam chayllalä lantillá. Chaymanmi licä liyá. Ama sinticallämächunchu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Juccäñatacshi: ‘Picha yundactam lantïlú. Chaycunactalämi chalamulläśhä niyá. Ama sinticallämächunchu’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chaynütacshi juccäpis nila: ‘Risin casädullalämi cacú. Manam lïmanchu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Lluypis chaynüta nilcamuptinshi: ‘Manam mayanninpis śhamuyta munapäcunchu’ lulaynincunash puydin nil patrunninta niycula. Chayshi sumä-sumä rabyalcul: ‘Jina cacuchun, chaynu captin'a. Aśhwanpa cürriy lil, puśhamuy intiru pläsacunäćhu, cällicunäćhu cä wacchacunacta, wallä maquicunacta, wishtucunacta, aplacunactapis’ nilcul juntuchimü caćhäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chaynu juntuchimuśhancunaca mana juntaptinshi patrunninta nila: ‘Taytay, juccunapäpis jäcuyanlämi. Manam juntanlächu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","24","“Niptinshi caćhäla: ‘Chayurá cürriy-ari. Masqui alafirsapis juntumuy mayan talishayquitapis intiru caminupi, intiru ćhaclapi, juc malcacunapïpis. Chay punta ayachimuśhäcunacá jina cacuchun’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chayćhümi achca-achca nunacuna Jesusta atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Chayćhümi Jesus nila: “Mayanpis rasunpa atimayta munäcá, lluymi pictapis caćhaycunman, aśhta mamantapis, taytantapis, walmintapis, chulincunactapis, irmänuncunactapis, panincunactapis. Jinaman'a aśhta quiquin istimäcuynintapis un'aycul atimanman. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ima-ayca pasaptinpis wañuycäcama laśhćhüman mana jalumücá nuná cananpä nï mirisinchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Má, mayanpis juc jatu-jatun wasicta lulayta munal'a yaćhaśhanchicnüpis illaynintam puntactá lican camanan ütac mana camananpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sinu'a allaycuycaćhalcul caćhaycüluptinmi juccunaca asipäculcanman ");
INSERT INTO qvwNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Mana ishpichinanpä luclu nunaca imapäshi allaycütucülun’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Chaynütacmi juc puydï mandacü gïrranacuyta mañaptin puntactá sumätalä śhun'unta tapucun chay ishcay ćhunca walanga (20.000) cachacuyücäta ćhunca walanga (10.000) cachacullanwan yaycunanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chaynu mana atipänanta śhun'unćhu yaćhacul'a manaläpis chay juc puydïnin sircayämuptinmi juc willacüninta amistachimunanpä caćhan. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chaynümi amcunapis mana lluy imayquitapis caćhaycul'a nï sumätalä śhun'uyquita tapucul'a manalä atïní canquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Chaynütacmi caćhipis llallayninwan lisichicun caćhi caśhanta. Chay llallaynin chincäluptin'a ¿imawanćha caćhichacuchwan? Manañaćhari wanupäpis nï imapäpis bälinmanñachu. Jinaptinćha wicapäśha jitaycaćhacun'a. “Linliyu cal'a cay nishäta uyalicalcämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Chayćhu Roma gubirnupä alcabäla mañäcunawan mana allin lulayniyu nunacunam Jesus yaćhachishanta uyaliyta munal payman aśhuycälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chaynu Jesusta uyaliyaptinmi fariseocunäwan camachicuyta yaćhachicücunaca jamuyäcuyalcan: “Cay nunacá imaymana nunacunactam cunsintin lädunman. ¡Jinaman'a chaycunawan cuscalämi micuyanpis!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Niptinmi Jesus uwish michïman tinculcachil nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Má, nipämay: Mayanpis paćhac uwishninpi jucninta jitapacülul ¿imanantan? ¿Manachun isun ćhunca isunniyu uwishnincunacta chayllaman lancaycachil chincäcäta ashï pasacun? ");
INSERT INTO qvwNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Chayćhu talilcamulmari cushisha śhawamun. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wasinćhüñatacmi lisinacuśhancunacta bisinuncunacta ayalcamul ‘¡Talimullämi!’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chaynümi mas alli-alli cushicuy cayan janay pachäćhüpis, juc mana allin lulayniyu nuna Diosman filtamuptin'a, chay isun ćhunca isunniyücunaca ‘Ya'a imapïmá wanacuśhä Dioswan allinña cayal'a’ nil nïcunapïtá. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Chaynütac má, juc walmip ćhunca illaynin cachun. Jinaptin jucninta chincapacüchun. Jinal michïrunta acchiculculmi intiru wasinta lluy taclalacyaylla tacwayan talinancama. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chayćhu talïlulmi cushisha willaycun lisinacuśhanta, bisinuncunacta ‘¡Cushicuśhun-ari! ¡Chincapacuśha illaylläta talïlümá!’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chaynümi janay pachäćhu anjilcunäpis cushiculcan juc nuna ‘Diospäñam canan caśhä’ nil payman filtamuptin'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Chaynütacmi Jesus nila: “Juc nunapshi ishcay chulin cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chay śhullca chulinshi papäninta nila: ‘Papay, ya'ap tücamänïtá umayñari’ nil. Niptinshi taytan, pulan chulintapis tücäninta-cama partiycülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Chayshi śhullca chulin'a lluy illaychalcul juc-lädu calu jamuyäśhan malcactalä licunpis ‘¡Chayćhümá bïdallá!’ nil. Chay malcäman ćhayculshi illayniyütucüśha mana allincunallaćhu pulishtin pasyaśhtin lluy camacaycülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chaynu jinayaptinshi chay malcäćhu micuy wanañatac licalïlun. Chayshi ‘¿Imawanćha cawsaśhä?’ nil, lulapacuycunacta ashila. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jinalshi chayćhu talïlun juc nunaćhu cuchi michipacuyllacta. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Chayćhüshi patan quiwquiwyayaptin aśhta cuchip micuśhancunapis shimićhü-cama cacuyäla. Jinaptinpis manash pipis alcansayculachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Chayćhüshi pinsaynin ćhämuptin yalpaćhacülun taytanman. Jinalshi: ‘Papänïpa piyunnincuná manaćh ya'anüchu cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Imanimänan captinpis cuticuśhäri. Chaynu ćhayculćhari nishä: “Papay, cay lulaynïwan Diostapis amtapis piñachicmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Manam nï chulí nimänayquipäpis canan bälïñachu. Ćhasquiycallämay-ari masqui uywayllayquipis caśhäćhá” nil’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chay nilculshi filtaćhacamun taytanpa wasinta. “Papäninñatacshi caluctalä chulin śhayämüta licälul-pacha śhun'unpis alalaycuptin mana-mana talipalcul macallacuycul muchacuycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Jinaptinshi chulin: ‘Papay, cay lulaynïwan Diostapis amtapis piñächicmi. Manam nï chulí nimänayquipäpis canan bälïñachu’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Niyaptinshi papänin'a nunancunacta nila: ‘¡Apuray! Sumä fïnunnin müdanacunacta aclalcamul müdachipäcuy. Puydïca cananpä surtijachipäcuy. Manam uyway nunallachu pay'a; sapatuchipäcuy-ari. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jinalcul'a wirannin wäcacta ćhipipäcuy chulí cutimuśhanpi jatun fistacta lulanapä. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Wañuśhanpi cutimünümi cayan! ¡Chincacuśhanpi licalïmuśham cayan!’ Nilculshi jatun fistacta fistachaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mayur chulinñatacshi ćhaclanpi cutiyämul wasinćhu fista lüyayämüta uyalïlun. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chayshi jucnin nunanta ayaycul: ‘¿Imapïmi fistachacuyan?’ nil tapula. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Niptinshi: ‘Śhullcayquim cutïmuñä. Chaymi papäniqui fistachacuyan allinnin wira wäcacta ćhipicaycachil chulin sänu cutimuśhanpi’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nishanta uyalilculshi rabyälul mana yaycuytapis munanchu. Jinaptinshi papänin yalalcamul yaycunanpä ruygala. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jinaptinshi nila: ‘Papay, ya'añatac watan-watan maquiquićhu cayal sirbiyac imapis mandaśhayquita cäsucul. Jinaptïpis amigücunawan fistachacuycunalläpäpis manatac ya'actá nï jucllay capishllayquitapis uycamälanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","¡Ñatac cay imaymana walmićhu illaynin camacamü chuliquipämi ichá wirannin wäcacta ćhipiycachil'a fistachacayäpunquipis!’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Niptinshi nila: ‘Uyalimay ïju, am imaypis ya'awan caśhayquipam llapa cänïpis ampa maquiquićhu cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cay śhullcayquiñatacmi ichá wañuśhanpi cutïmuñä. Chincacul licalimuśhanpïmi cushicuypi caynu fistachacayäpunchic’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Chaynütacmi Jesus tincuchiypa willala jucta: “Juc alli cäniyu nunapshi juc sumä cunfiansa nunan cala. Payshi lluy cänincunapi incargädu cala. Chaynu cayalshi pay munaśhanta lulacuñä. Jinaptinshi nunacunaca: ‘Cay cunfiansa nunayqui munaśhanta lulaśhuśhayquitapis manamá yaćhanquichu’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Nipäcuptinshi ayalcul: ‘¿Imapïtan lluypis caynu niyalcäśhunquiman? Má, cananmi lluy papilcäta licachimänayquita muná. Canan'a cay lulayniquipi yalunquiñam’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Niptinshi chay nunaca pinsan: ‘¿Canan imactaćh lulaśhä caynu patrunní wicapämaptin? Ćhaclaćhu lulapacunäpá manam callpäpis canñachu; limuśhnacuytá pin'acullätacmi’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nilculshi pinsälun: ‘Ä, caytari luläśhä caypi alümaptin lisinacuśhäcuna wasinćhu uywaycamänanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nilculshi patrunninta mänucüśhan nunacunäta ayächin. Punta ćhämücätash tapula: ‘¿Aycactatan patrunnïta mänutacüśha cayanqui?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Niptinshi: ‘Paćhac barril asaytictam dïbiyällá’ nin. Niptinshi: ‘Ama llaquicuychu. Canan chay punta papilta laćhyalcul apuraypa juc muśhü papilta luläśhun picha ćhunca dïbishallayquipïña’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Chayta lulalculshi chay ipa ćhämücätapis tapula: ‘¿Am'a aycactam mänutacüśha cayanqui?’ nil. “Niptinshi: ‘Ishcay paćhac tirsu trïguctam dïbicuyällá’ nila. “Niptinshi paytapis lulächin paćhac ćhawpin tirsucunallapäña. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Chaynu nunan lulaśhanta yaćhälulshi patrunca nila: ‘Cay nunap uman cacullanmi chayta lulananpä’ nil. “Aw, rasunpa cay pachäpä nunacunaca mas fisyunllanmi cacullan acchïćhu cä nunacunapïtá. Chaymi paycuna mastá śhamü bïdancunaćhu cawsapäcunanpä siguracuyta yaćhapäcun. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Chaynu-ari amcunapis fisyunllan nuna capäcuy. Jinal cay cawsayniquićhu afanaculcay imallayquiwanpis janay pachäpä sirbishunayquipä. Masqui cay pachäćhu mana cäman muyuchipuśhuptiquipis wicćhu'a tuquip ćhasquisham canqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Rasunpa, caynu ashcunallaćhu chalapacuna nunacá achcaćhüpis chalapacunam can'a. Cay ashllaćhüpis mana chalapacunacá piyurćha canman achcawan'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cay pachäćhu cäcällamanpis mana chalapacuna cayalcaptiqui'a ¿pitan cunfiacuśhunquiman sumä imapis cäcätá? ");
INSERT INTO qvwNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mana caynu nunap imallantapis mana sumä cuydayalcaptiqui'a ¿pitan ampá cunfiansanwan uycuśhunquiman tücäniquitapis? ");
INSERT INTO qvwNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Chayurá śhun'uyquita tapucuy mayanninta atinayquipäpis. Manam pï sirbipacüpis ishcay patruntá sirbinmanchu. Juccätam ćhïninman, juccätam cuyanman; juccätam jamuyanman, juccätam wätanman. Chaynütacmi amcunapis nï Diostawan cäniquitá jucllaćhu sirbinquimanchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Cay nishanta fariseocunaca uyalipäculmi illayta lägacuyalpis Jesusta asipapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chaymi Jesus: “Amcuna allin nunanülämá pasachiculcäñanqui caycunacta lulayalcalpis. Masqui chaynu jinapäcuptiquipis Dios'a yaćhanmi śhun'uyquićhu imacta pinsaśhayquitapis. Nunacunaca ama-pacha nipäcuśhantamari Dios'a millachicuypä lican. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Canan, má, Moiseswan, Diospa willacünincuna yaćhachishanca alli callpayümi cala Bawtisä Juan Diosman filtananpä willacuśhancäcamá. Chay pachapïmi lluy nunapis imanuypañapis Diospa gubirnunman yaycuyta munayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Masqui chaynu captinpis manam ‘Camachicuypa yaćhachicuynin mïnusyälunñam’ niyächu. Aśhwanpa, sïluca allpaca caśhancamá, camachicuycäpi manam juc litrallapis, nï uchuc unanchaycuśhallapis chincachishachu can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Chayurá walminwan laquinaculcul jucwan cuscäcá mansibacuyanmi. Chay jitaśha walmiwan cuscäcäpis mansibacuyantacmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nilculmi juctapis willala cay nil: “Juc nunash cäniyu cäniyu rïcu cacula. Chayshi sumä allica fïnunnin müdanacunallawan müdacula. Chaynu cayalshi muyun-muyunpis allicá cumbidullacta lulachil micucula. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ñatac chayćhüshi intiru aychanpïpis matiryälla wi'imuśhtin Lazaro śhutiyu nuna cala. Payshi walan-walan chay rïcup wasinpa puncullanćhu jitaläcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Chayćhüshi allucunäpis lläwala. Chaynu jitalayalshi munapäla: ‘Cay rïcup mïsanpi usücällapis imanuypalä shimïćhu licalinman’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Chaypïtash juc-punćhu'a wañucullan. Chayshi Diospa anjilnincuna paypa almanta puśhacula luryaman unay awilunchic Abrahamwan cusca cananpä. Chay jinamanshi rïcupis wañucuntac. Jinaptinshi lluy pampälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chay rïcu nunaca nina waläcäćhu ñacayalshi altucta licalcuśhanćhu Lazarocta licälun Abrahampa millayninćhu cayäta. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chayćhu licalculshi ayaycaćhacuyan: ‘¡Tayta Abraham, llaquipaycallämay-ari! Caćhamullay Lazarocta-ari dïdu puntallanwanpis yacullacta śhutuycachimumänanpä. ¡Ay, cay acachäcuy imañaćh cacullanpis isisí!’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Niptinshi Abraham nimula: ‘Yalpaćhacuy ïju, cawsayniquićhu imapïpis altullamá caculanqui imayquipis junta. Lazaro'a manam chaynüchu cala. Canan paymi cayćhu juc allin bïdacta talin. Amñatacmi mana allin bïdacta pasayanqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jinaman'a maynu munalpis chay caśhayquiman'a manam mayanpis chimpamunmanchu, sumä-sumä wayu japächayämaptinchic'a. Chaynütacmi nï chaypïpis cayman pasamunmantacchu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Niptinshi: ‘Chayurá tayta Abraham, Lazarocta caćhallay papänïpa wasinta linanpä chayćhu picha irmänücunacta cay ñacaynïpi willaycunanpä. Paycuna cay ya'a ñacaśhäcäman śhamunanta manam munächu’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Niptinshi: ‘Moiseswan willacünincuna isquirbishancuna maquinćhu cayanmi. Chayćhu limaśhantari lluy cäsucul lulachun’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Niptinshi nila: ‘Manam, tayta Abraham, pïllapis wañuśhanpi cawsalcul liptinlämi sigürupis mana allin lulaynincunacta caćhaycunman. Jinallá manam cäsuculcanmanchu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Niptinshi: ‘¿Paycunactapis mana cäsucuyal-lächun-ari ampá wañücuna śhalcul liptinpis quiriycuyalcanman?’ nin” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Chaynütacmi juc-punćhüpis Jesus yaćhapacünincunacta nila: “Mana allincunacá imaypis mayćhüpis waywa-yupaypis talicunmi. Ñatac mayanpis nuna-masinta chayman tan'alpücá ¡imanuylä can'a! ");
INSERT INTO qvwNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yan'al-lätac cay uchuchäcunanülla cä chalapacamänïta mayanpis juchaman palpuyächinman. Mas allinćha canman cuncanman wanca lumicta watacuycul lamarcäman ji'acalpuptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amcunawanpis yan'al-lätac chaynu pasayanman. Allicta cuydaculcay. “Nuna-masiqui mana allincunacta lulaptin'a anyaycäliy. Chaywan wanacuptin'a pampachaycäliy. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masqui anćhish cuti juc muyunllaćhu cuntrayqui lulal, ‘Manam cananpi lulalläśhäñachu’ nil chaynu anćhish cuti cutimuśhuptiqui'a pampachaycäliy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Niptinmi nipäcula: “Taytáy, yanapaycälillämay-ari Diosman chalapacuynïcuna wiñananpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Niptinmi: “Masqui shitap mujunnüllapis chalapacuyniqui captin'a cay jatun jaćhäta ‘¡Caypi lamarcäman wicapacuy!’ nil niptiqui cäsupäcuśhunquimanmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Chayćhüñatacmi nila: “Juc nunap gañannin ñatac uwish michïnin cachun. ¿Paycuna chay tardi ćhächimuptin patrunnin: ‘Cayman pasaycamul micucuchcay’ ninchun? ");
INSERT INTO qvwNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Manamá. Aśhwanpalämi: ‘Micuyta lulalcul sirbimay. Amcuná micuculcanquićhá’ nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chaynu sirbichiculculpis manalätac anradisicuynin canchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Cay lulapacü nunacunanüćha amcunapis Diospa mandäśhuśhayqui lulayta camacalcul'a: ‘Uywayllamá canchic. Ya'anchic'a lulanallanchiccätam lulayculanchic. ¿Ima mastamá alcachwan?’ nil nipäcunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalenta lilmi Jesus pasala Samariap malcancunap, Galileap malcancunap. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Chayćhu tacsa malcallaman ćhäluptinmi chaypi yalälälimun ćhunca millachicuy lipra ishyaywan ismuyä nunacuna. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chaycunam calullapi śhaycucuycul ayaycaćhapämula: “Llaquipayniyu taytáy, llaquipaycälillämay-ari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Niptinmi paycunacta licalcul nila: “Canan sasirdütiman sänu capäcuśhayquita licapäcuśhunayquipä cutipäcuy” nil. Nilcuptin liculcalshi lishanpa sänayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chayćhu jucnin sänaśhanta tantiaculculshi Jesusman cutimula Diosta alli callpawan alawaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chayćhümi Jesuspa puntanman un'ulacuycul umanta pampäcama ćhulaycul: “Sulpá callächun caypïta” nil anradisicula. (Cay nunam ćhïninacuśhan Samaria-lädupïta cala.) ");
INSERT INTO qvwNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chayćhümi Jesus nila: “¿Ćhunca nunachućhari cay ishyayninpi sänu liyalcäla? ¿Maytan-nila isun nunaca? ");
INSERT INTO qvwNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Cay Samaria-lädu nuna japallanchućh cutïmuñä Diosta alawänanpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nilculmi chay nunäta nila: “Śhalcul licuy, Diosman chalapacuśhayquipam sänaśha canqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Juc-punmi fariseocuna Jesusta tapula: “¿Imayćha Diospa gubirnun allaycun'a?” nil. Niptinmi: “Manam aläjapachu ćhämun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mayanpis manam ‘¡Cayćhümi, wicćhümi licalïñä!’ ninan canchu, Diospa gubirnun amcunap ćhawpiquićhu cayaptinñá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chay nilcuśhanpïmi unascactá yaćhapacünincunacta willala caypi cay nil: “Amcuna ya'awan uchucllactapis cayta munapäcunayqui üraca ćhämun'añaćh. Masqui maynu munapaptiquipis manam caśhächu. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Rasunpam limaycuna ćhämuśhunqui: ‘¡Cayćhümi cayäñä; wicćhümi cayäñä!’ ütac ‘Cutimuñämi’ nil. Chayta quiril ama ashipämaychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aśhwanpa ya'a Rasun Nunap Chulinca cutimuptí inti yalamunanpi aśhta inti ji'alpunancama, sumä wacli uyaypa camalämuśhancänümá can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ñatac puntactá cay wiñay nunacunap jamuyal ñacachishalämi caśhä. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ya'a Rasun Nunap Chulincäpa cutimuyní Noé timpućhu pasaśhannümi can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Manaläpis chay tamya fisyu ćhämuptinlämi llapa nunacunäpis upyayllacta, casaracuycunallacta, fistacunallacta jawca lulacuyalcäla aśhta Noé barcunman yaycunancama. Chayćhu Noëllam salbacula; juccunacá mayćhu caśhanpis manam camalalachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chaynütacmi Lot timpupis pasala. Nunacunaca micuyalcäla, upyayalcäla, imactapis lantinacuyalcäla, wasichacuyalcälapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Chaynu jawca cayaptinpis Lot chay Sodoma malcäpi yalamuptin-pacham Dios nina fisyucta caćhalpaycamul lluy camacaycüla. Jinaptinmi chay malcantin nunacunaca ućhpaman muyüla. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Chaynümi ya'ap cutimuynïćhüpis can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mayanpis wasinpa altuśhninćhu cäcunaca imallanta juluycunallanpäpis timpu manañam can'añachu. Ćhaclanćhu cäcunäpis müdanallanta juntulcü cutipämunallanpäpis timpu manañam can'añachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yalpaćhaculcay Lotpa walminta ima pasaśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cawsayninta ama-pacha nïcá cawsaynintamari apacun'a. Ya'a-laycu bïdantapis uycücämi ichá cawsaycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Chay tuta masqui ishcay puñuyalcaptinpis jucninmi puśhacuśha can'a, jucninñatacmi caćhaycüśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chaynütacmi ishcay walmicuna a'ayalcaptinpis jucnin puśhacuśha can'a, jucninñatacmi caćhaycüśha can'a. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chaynütacmi ishcay nunacuna ćhaclaćhu talpuyalcaptinpis jucnin'a chincacun'a, jucnin'a quïdälun'a˼” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chayćhümi yaćhapacünincuna tapula: “¿Mayćhütan? ¿Imaytan?” nil. Niptinmi: “Aycha captin'a uyaypam wisculcuna muyupäcun. Amcunapäpis uyaypatacmi can'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chaypïtam Jesus willala tincuchiypa Diosta imaypis mañacunanpä: ");
INSERT INTO qvwNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Juc malcaćhüshi juc juyu fis Diostapis mana manchacü nunätapis mana llaquipä cañä. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay malcaćhüshi cañätac juc japanyäśha walmi. Payshi chay fisman liñä: ‘Taytáy, quijanacuśhá nunäwan arrinlaycallämay’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Chay niptinshi fisca mana atindïtucul unayña cayächin. Chaynaptinpis pasaypish rabyapayächï cala. Chaynapaptinshi fisca pinsälun: ‘Diospis nunapis mana ima ucayämaptinpis, cay walmïta arrinläśhäri manaña umäta nanayächimänanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Chay walmip rabyachïninmi maynu juyu fistapis awnicalpachin. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Chaychun ampá Dios mana atindiycälishunquimanchu tutay-muyun ruygacücunäta? ¿Alcayalcächishunquiman munaśhan üracamachućh? Manamá. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pay'a chay-pachallam atindiycun'a. Ñatac cay pachäman ya'a Rasun Nunap Chulinca cutimul ¿talïmanchućh caynu jicutaycü chalapacuyniyu nunacunacta?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Chaypïtam chayćhu Jesus juctañatac willala mayanpis “Diospa ñawpäninćhu allinmi cacú” nil jamuyäcücunäpä cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcay nunash liñä Diospa chuya wasiman payta mañacü. Chay jucninshi fariseo cañä. Juccäñatacshi Roma gubirnupä alcabäla mañawshï malca-masin cañä. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chayćhüshi fariseoca aläjapa śhaycapacuycul Diostapis mañacücuyan: ‘Sulpá cachun Dios taytáy, mana juc nunacunänuy suwa caśhäpi, jucha-sapa caśhäpi, mansibädu caśhäpïtapis. Anradisicucmi wic alcabäla mañä nunänuy mana caśhäpïta. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Simänäćhu ishcay cutictalämi ayuná. Jinaman'a lluy gänaśhäcunapïtapis ćhuncapïta jucta-camalämi uycucpis’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Chay alcabäla mañä nunäñatacshi ipallaćhu un'ulacuycul, maquillantapis tällalcul-tällalcul uyshucuśhalla nila: ‘Dios taytáy, jucha-sapam callá. Llaquipaycallämay-ari’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chaymi rasunpa nipäcuc, wasinta cutinanpä ñam cay illay mañä nunaca ima juchanpïpis pampachäśhaña cayäla. Chay juccäñatacmi ichá jina juchayüllalä cayäla. Rasunpa mayanpis ‘Ya'a Diospä cumplïdum cacullá’ nïcá pin'acüśham quïdan'a. Mana alawacücunañatacmi ichá aśhwanpa altuman juluśha can'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chayćhüñatacmi iñachacunacta achca apapämula Jesusman umanta yataycul Diosta mañacapunanpä. Yaćhapacünincunañatacmi ichá lluy mićhacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jinaptinmi Jesus nila: “Ama mićhacuychu; jina śhapämuchun. Cay uchuchäcunänuy cäcunapämi Diospa gubirnun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rasunpa mayanpis paycunanuy Diospa gubirnunta mana ćhasquïcá, chayman manamá yaycun'achu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chayćhümi juc puydï nuna Jesusta tapula: “Allin yaćhachicü Taytay, ¿imactatan lulalläman wiñay simpri cawsaycäman yaycunäpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Niptinmi: “¿Imapïmi ‘allin’ nimanqui yaćhachicülla cayapti'a? Allincá Diosllam. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Am yaćhayanquimari Diospa camachicuyninćhu: ‘Amam nunacta wañuchinquichu; mansibacunquichu; suwacunquichu; casquicunquichu; jinaman taytayquita mamayquita tuqui allinpam licanqui’ nil nishancunacta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Niptinmi: “Caycunallamannu'a uchucllapïmi cawsayculá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Niptinmi: “Jucmi lulanayqui cayanlä: lluy cäniquita lanticulcul llapa wacchacunaman aypuycamuy. Jinalmi janay pachäćhu alli sumä cäniyu caycunqui. Jinalcul atimay” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Niptinmi alli cäniyu cal nishanta uyalïlul sumä llaquisha licula. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chaynu wällïshacta licalculmi Jesus: “Sumä cäniyu rïcu nuna Diospa gubirnunman yaycunanpä sasa-sasam. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Rasunpa Diospa gubirnunman cäniyu nuna yaycunantá aśhwanpam juc camïllu uywapis awjap linlinpa pasälunmanlä canpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Niptinmi chayćhu uyalïcunaca nipäcula: “Chaynu captin'a ¿mayantá salbacunman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Niptinmi: “Nunaca mana atipäśhancunacá, Diospá imallamá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niptinmi Pedro: “Taytáy, ya'acunam ichá lluy imallätapis caćhaycul atiyalcac” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Niptinmi: “Rasunpa ya'a nipäcuc, pipis Diospa gubirnun-laycu wasinta, walminta, irmänuncunacta, chulincunacta, mamancunacta caćhaycücá paypïmá masta ćhasquin'a cay cawsayninćhüpis. Jinaman'a juc bïdaćhüpis wiñay cawsaytalämi ćhasquin'apis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chaypïtam ćhunca ishcayniyu yaćhapacünincunacta Jesus japächalcul nila: “Canan'a ñam Jerusalenman liyanchicña. Chayćhümi lluy lulacacun'a Diospa unay willacünincuna ya'a Rasun Nunap Chulincäpi isquirbishanca. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chayćhu mana-Israelcunap maquinman ćhulaycamaptinmi burlapapäman'a, palapäman'a, tuwapapäman'a ima. Chayćhu lawćhapämal wañuchipäman'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jinapämaptinpis quimsa muyunpïtam ichá śhalcamuśhä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cay nishantam nï imapi nishantapis mayanllanpis intindipäculachu mana tantiapaśh captin. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ñä Jericó malcäta Jesus ji'aycuyalcaptinmi juc apla caminu patanćhu limuśhnacuyäñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chay achca nunacunaca śhacayämüta uyalilculmi tapucula: “¿Imam śhacayämullan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Niptinmi: “Nazaret-lädu Jesusmi pasayan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Uyalilcul-pacham ayaycaćhacuyan: “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacü, Jesuslláy! ¡Llaquipaycallämay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chaynu ayaycaćhacayämuptinmi waquin puntanpa pasäcunaca: “¡Upälla!” nil mićhacapäcula. Jinaptinpis mastalämi ayaycaćhacayämun: “¡Mandacü Davidpa Caśhtan Caćhamuśhan Salbacüní! ¡Llaquipaycallämay-ari!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chaynu ayamuśhanta uyalilculmi Jesus śhaycuycul puśhachimula. Lädunman ćhächimuptinmi Jesus tapula: ");
INSERT INTO qvwNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Imallactam nilanqui?” nil. Niptinmi: “Taytáy, licaytam munallá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Niptinmi: “Licay-ari. Caynu chalapacamäśhayquipam allinyälunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chay niycullaptin ñawin quićhacacüluptinmi Diosta alawaśhtin Jesusta atila. Chayćhümi lluy nunacunäpis chayta lical Diosta alawapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericó malcäman ćhälulmi Jesus chay ćhawpinpa pasayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ñatac chay malcaćhümi yaćhañä juc alli cäniyu nuna Zaqueo śhutiyu. Paymi Roma gubirnupä alcabäla mañäcunap jucnin prinsipal puydïnin cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Paymi Jesusta alli-allicta licäluyta munala lisinanpä. Chayćhu Jesus nisyu-nisyu nunacunäwan liyalcaptinmi Zaqueo tacsa cayninwan imactapis licanchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chayćhümi mana licayta atipaculcul cürriwan ñawpalcul juc altu jaćhaman ishpiculcula chaypi Jesusta licamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus chayninpa pasayalmi chay jaćha jananpi anśhalayämüta licälun. Jinaptinmi nila: “Zaqueo, ¡chaypïta apuray bäjamuy! Canan wasiquićhümi jamacuyta muná” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Niptinmi mana-mana bäjalpaycamul sumä cushisha wasinta puśhala. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayćhu Zaqueop wasinta liyäta licälulmi, llapa nunacunapis “¡Ima nunatan cay jucha-sapap wasincunacta awnil liyänanpä!” nil jamuyapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chaynu jamuyapäcuptinmi śhaycucuycul Jesuspa puntanćhu Zaqueo nila: “Taytay, imapis cänïpïtam canan ćhawpipi llapa wacchacunäman uycuśhä. Ñatac ingañacuśhätapis tawa mastalämi cutiycachishä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Niptinmi Jesus: “Awilunchic Abrahamnuy Diosman chalapacuśhayquipam wasintinpis canan salbaśhaña canqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Caynu Diospi calućhu pintïshanuy cäcunäta ashil caśhan payman cutichinäpämi ya'a Rasun Nunap Chulinca śhamulá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesuspa yaćhachicuyninta caynu uyalipäculmi llapa nunacunapis pinsapäcula: “Canan Jerusalen malcap sircanćhu cayalñá ćhäluptinchicćhá Diospa gubirnun allacuycun'a” nil. Chaymi Jesus willala juc allica nunaman tinculcachil cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Juc allica rïcu nunash cala. Payshi calućhu nasyunman lila mandacüninpä ćhulachiculcul, caśhan cutimunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chayshi ćhuncantin nunanta ayalcul achca illayta llapantapis partïlun: ‘Cay illaycäta milachipäcuchcay cutimunäcama’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nilcul licuptinshi chay ipanta caćhala juc cumisyunta malca-masincuna ćhïnicuypi cay nilcachil: ‘Cay nunäta manam munapäcüchu mandäninchic cananpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Masqui chaynu nipäcuptinpis mandäninpäñam ćhulachicüla. Chaypïtash caśhan cuticamulaña. Chay ćhaycamulshi llapa illay partishan nunancunacta aycaman milachipäcuśhantapis yaćhananpä ayachin. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Chayćhu punta ćhämücäshi: ‘Taytáy, illay umäśhayquica ćhunca mastalämi miläpuśhunqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Niptinshi: ‘Allinmi. Allin lulacü nunam cañanqui. Caynu ashllaćhüpis chalapacuna caśhayquipam canan ćhulaśha canqui ćhunca malcap mandäninpä’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Chaypïtash jina ipanman juccäpis ćhaycamul: ‘Taytáy, umäśhayqui illayniqui picha mastam miläpuśhunqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Niptinshi: ‘Ampis allin lulacü caśhayquipam picha malcap mandäninpä ćhulaśha canqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Chaypïtañatacshi jucpis ćhaycamul nin: ‘Taytáy, cay illayllayqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Caynu illayniqui chalat-chalatyayä nuna cayal imallapïtapis milayniyüta ćhasquishayquita tantialmi lisiräculac. Chaymi ya'a cay juc pañuylullaćhu illayniquita ipichalächipulac’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Niptinshi: ‘¡Mana imapäpis bälï nuna! Shimillayquim juchachäśhunqui. Chaynu chalat-chalatyayä niyämal'a, illaynïta milaynintinta mañacuśhäta yaćhayal'a ");
INSERT INTO qvwNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿imapïtan-nila manatac bancumanpis ćhulaycämulanquichu? Ichaćh ash-ash milayniyüllactapis ćhasquïman cala’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nilculshi chayćhu cäcunäta: ‘Chay illaycäta quitalcul ćhunca mas milachïcäman uycuy’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Niptinshi nipäcula: ‘Taytáy, paypá ćhunca masñam cayäpun’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Niptinshi: ‘Uywäcunätá mas uśhalämi can'apis. Mana uywäcunätam ichá aśhwanpalä chincalpachisha can'apis. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jinamanñatacmi mandänin canäpä mana munal cuntramänïcunätapis cayman aysalcamul ñawpänïćhu lluy mu'upäcuy’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chaynu nilculmi Jerusalenmanña Jesus pasayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chayman ñaćhapaycuyalcal, Ulibus nishan ulućhu Betfageman Betania malcaman ćhälälilmi ishcaynin yaćhapacüninta caćhäla: ");
INSERT INTO qvwNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Cay chimpa malcaćhümi talipäcunqui manalä carga apä malta aśhnu watalayäta. Chayta pasquilculmi aysapämunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Chayćhu mayanpis ‘¿Imapämi pasquiyanqui?’ nipäcuśhuptiqui'a ‘Duyñümi munan’ nipäcunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","33","Nilcuptinmi yaćhapacünincuna liculcäla. Chayćhüshi rasunpa Jesus nishantanuy watalayäta talilcul pasquićhacalcämuptin aśhnup nunancuna: “¿Imapämi aśhnüta pasquiyanqui?” nil nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Niptinshi: “Duyñümi munan” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nilcälilmi chay malta aśhnüta puśhacalcämula. Chaynu ćhaycachimulmi müdanancunawan carunalcälil Jesusta sillachipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chaynu puśhayalcämuptinmi nunacunäpis catacuncunacta alawayninwan maśhtapäcula pasanancäman. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chayćhu ñä Ulibus ulupi bäjayalcalmi llapa yaćhapacünincuna sumä jatun lulaycunacta lulaśhanta licaśhanpi bïbaśhtin alawapäcula: ");
INSERT INTO qvwNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“¡Cawsachun Diospa pudirnin Mandacüca! ¡Cawsachun imaycamapis!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chay niyta uyalilcälilmi chayćhu cä Fariseocunaca nipäcula: “Yaćhachicü taytay, ¡upällachiy cay llapa atïniquicunacta! ¿Imactam caynu äśhaycaćhapäcun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Niptinmi: “Masqui rasunpalä paycunacta upällachiptïpis cay a'acunäćha lüyatityanman cushicuypi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chayćhu ñä Jerusalenta ćhaycuyalmi Jesus wa'acula chay malcäpi cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“¡Ay Jerusalen! Maquiquićhünüñamá jawca cawsayca cayäla. Chaynu cayaptinpis caycunacta licanayquipä manamá tantiayniqui cañächu. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Canan llapa ćhïnïniquicuna ćhaycamulmi lluy intuycälil chalapäcuśhunqui, mana jucpis ayipäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lluy nunay-tuducta camacalculmi pampaman muyuchishunqui. Chayćhümi nï juc lumipis śhäcuyal quïdan'achu. Lluy caycuna pasaśhunqui canan muyun Diosniqui watucayämuśhuptiquipis mana lisipäcuśhayquipam” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Nilcuśhanpi ćhayculmi Diospa chuya wasip patyunman yaycula. Chayćhümi achca-achca imaymanacta lantinacuyalcäcunacta talïlun. Jinalmi lluy alapacämula: “Diospa shiminćhümi: ‘Ya'ap wasí ya'allawan limanan wasim can'a’ niyan. ¡Chaychun amcuna suwacunap maćhayninman muyülächinquiman!” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ñatac chayćhümi walan-walanpis Jesus yaćhachila. Chaymi puydï sasirdüticunaca, camachicuyta yaćhachicücunaca, prinsipal yaśhacunäwan ashipäcula payta imanuypapis chincachipäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Masqui maynu munalpis llapa uyalïcunäta manchaculmi ninaculcäla: “Wicnuy mishquicta atindiyalcal'a yan'alćha imanämachwanpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Chaynu jinaculculmi allin willacuyta yaćhayächila chay Diospa chuya wasip patyunćhu. Chaymanmi puydï sasirdüticuna, camachicuyta yaćhachicücunaca, prinsipal yaśhacunäwan ćhälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ćhayculmi Jesusta nicuyalcan: “¡¿Mayantucultá cayćhu lulayanqui?! ¡¿Mayantá cayta lulanayquipä ćhulaśhulanqui?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Niptinmi: “Má, ya'actapis nipämay. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juan bawtisananpä ¿pitan caćhamula? ¿Dioschun icha nunacunällachun?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Niptinmi quiquin-pula ninacücuyalcan: “ ‘Diosmi caćhamula’ niptinchic'a, ‘Chayurá ¿imapïtan-nila mana chalapaculanquichu?’ nilćha nimäśhun. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ñatac ‘Nunallam’ niptinchic'a yan'aćh cay nunacunaca lluy tamshällamachwanpis Diospa willacüninpa licayalcal'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chaynu ninaculculmi: “Manamá yaćhapäcüchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Niptinmi Jesuspis: “Chayurá ya'apis manam mayan caćhamäśhantapis willapäcuśhayquichu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nilculmi tincuchiypa willala cay nil: “Juc nunash ćhaclan juntacta plantacula übacta. Jinalculshi juc nunacunaman partïda uycul calu malcacta achca quillacuna licula. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chaypi cusicha timpu ćhämuptinshi juc nunanta partinta apamunanpä caćhamula. Chay nunantash partïdaśhancunaca chalalcälil lluy ma'alcälil jinanllacta cutichipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jinaptinshi juc nunantañatac yapa caćhamun. Chaytapis chaynütacshi palalcälil lluy ma'alcälil mana ima wälactapis umul alälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chaypïtapis yapaläshi juc nunantapis caćhamun. Chaytapis chaynütacshi ma'alcälil lulälälin. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Chayshi duyñun pinsan: ‘¿Imanäśhätan? Mïjur-ari japallan cuyay chulïta caćhäśhä. Paytá allinpaćh lican'a’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Chaynu chulin ćhämuptinshi partïdaśhan nunacunaca limanacucuyalcan: ‘Cay chulinpäćhá caycuna quïdan'a. Cay tücänin ya'anchicwan quïdananpä wañüchishun’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chayshi ćhaclanpi aysalcul wañülächin. Má ¿chaynu luläläliptin'a chay ćhaclayüca ćhämul ‘allinmi’ nin'achun ampá? ");
INSERT INTO qvwNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aśhwanpa lilculmá chay nunacunäta wañulcachil juccunaman ćhaclanta uycun'a” nila. Chay nishanta uyalilcälilmi: “¡Imaypis manaćh chay'a pasanmanchu!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Niptinmi allinta licapaycul nila: “¿Diospa shiminćhu nishancäta manachun tantiapäcunqui, imatá? Chayćhümari niyan: ‘Wasi luläcuna jalutacuśhan lumim mas allin puydï chaläninmanlä muyüñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jinaman pipis chay lumiman ćhäcá, quićhacacülun'am. Ñatac chay lumica mayanpa janäninmanpis ćhaptin'a lluymi ñutucacülun'a’ nil” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Niptinmi puydï sasirdüticunäwan yaćhachicücunaca paypi nishanta lluy tantiacalcälil Jesusta chalachiyta munapäculpis achca-achca nunäta manchalil liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chaynu mana atipacalcälilmi caynüta ninaculcäla: “Mïjur-ari allin nunaman muyütuculcul jucnin nunanchic quiquinpa limayllanwan palpuchinanpä lichun. Jinaptinćha Roma puydïninpa maquinman ćhulaycuśhun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chaymi lïcunaca ćhaycul: “Yaćhachicü taytáy, tantiapäcümi rasuncälla amćhu caśhanta. Manamá pimanpis śhalcuyanquichu. Aśhwanpa Diosninchic munaśhannu rasuncällactam yaćhachinqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chayurá má, niycälillämay ¿Roma gubirnuman alcabälacta unapä Tayta Dios awninchun icha manachun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Niptinmi Jesus achäqui ashiyninwan caśhanta yaćhalcul nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“¿Imapïtan imamanpis palpuchiyta munapämanqui? Má, licachimay juc illayniquita” nil. Chaynu uycuptinmi tapula: “¿Pitan cay illaycäćhu cayan? ¿Pip śhutintan cayćhu limayan?” nil. Niptinmi: “Romap Puydï Mandacünin Cesarpam” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Niptinmi: “Chayurá Cesarpa cäcätá payman-ari uycäliy. Diospa cäcätá Diosmantac-ari uycäliy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chaynu nunacunap ñawpäninćhu mana imamanpis palpuchiyta atipalmi licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaypïtam wañücuna śhalcamunanman mana quiripäcü saduseocunaca śhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Paycunam Jesusta: “Yaćhachicü taytay, Moisespa camachicuyninćhümi niñä: ‘Juc wayapa mana chuliyu ima wañucuptin'a cäsu canmi wanücäpa śhullcanwan biudaca casaracul punta wayapanpa milayninta śhalcachinanpä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Chaynu captin'a, ¿imanuytan chayurá cay canman? Unayshi anćhish wawi-caśha capäcula. Chayshi mayurca walmiculcul mana chuliyu ima wañucula. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jinaptinshi śhullcanwan yapacüla chay japanyäśhaca. Chaypïtash chaypis chaynütac wañucun mana chuliyu. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jinaptinshi chay ipa atïninwan yapacüluptin chaypis mana chuliyütac wañucun. Chaynüllash cay anćhishnintin wawi-caśha chay walmillawan cuscälälil mana chuliyu llapanpis wañuculcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jinaman'a chay walmipis wañucuntac. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Canan nipämay: Śhalcamunan muyuncäćhu ¿mayanninpa walmintá can'a anćhishnintinwan casaracuśha cayaptin'a?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Niptinmi Jesus nila: “Chaynu walmichacuycuná cay allpällaćhu cawsäcunapämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Ñatac Diospa lädunman ayaśhancunacá manañam chaycunacta lisin'achu. Nïtac anjilcunanüpis imaypis wañun'añachu. Paycuná cawsä bïdaman pasaśhanpïmi Diospa chulinña cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Ñatac chay wañücuna śhalcamunanpïtá Moisespis tantiachilamari. ¿Manachun yalpanqui jaćhäćhu nina waläcäpi Diosninchic Moisesta ayalcul imanishantapis? Chayćhümi niyan: ‘Ya'am Abrahampa, Isaacpa, Jacobpa alawayalcäśhan Diosnin cayá’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chayurá Diospá manam chincacü wañucücuna canchu; sinu'a cawsä nunallamari” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Niptinmi camachicuyta waquin yaćhachicücunaca nipäcula: “Taytáy, allintam chaytá nïlunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaynu Jesus niptinmi manaña mayanpis mastá tapućhaculcälañachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chaypïtam Jesus nila: “¿Imapïtatan ‘Salbacücá Mandacü Davidpa milayninmi cayan’ nil niyalcan? ");
INSERT INTO qvwNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","44","Milayllan cayaptin'a, ¿imanuypatan quiquin David ‘Duyñú’ niyanman Diostanuylä canpis chay Salmos librunćhu? Chayćhümi ‘Diosninchicmi munayniyu Duyñüta nin: “Cay-lädulläman taycaycamuy ćhïnishüniquicunäta maquiquiman ćhulaycamunäcama wiñay simpri uyshuycälishunayquipä” niyan.’ “Chayurá ¿imanuypatan milaynillan canman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chay nishanta llapa nunapis uyaliyalcaptinmi yaćhapacünincunacta nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Yan'al-lätac amcunapis cay yaćhachicücunäta atiyalcächinquiman. Paycunamá allinnin müdanacunawan müdaculcan läsacunäćhu nunacuna rispitänan-layculla. Jinalmi aśhta juntunacuna wasicunaćhüpis fistacunaćhüpis allinninpa täcunancunamanlä täcuytapis wañupaculcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Japanyäśha walmicunap wasincunacta waycayalcalpis cäran cañälämi allinpa licachiculcänallanwan mana camacaycütalä Tayta Diosta mañacuyalcänanpä canpis. Caycunapïmá mas mas mućhuycachisha capäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chaypïtam illay juntucunaman llapa cäniyücunapis illaynin jitaycuyäta Jesus licälun ");
INSERT INTO qvwNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","jinaman juc japanyäśha waccha walmi ishcay illaychallanta jitaycuyätapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chayćhümi Jesus nila: “Cay japanyäśha walmim rasunpa lluypïpis masta jitaycülun. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chay juccunacá illayninpa puchüllantam uycälin. Cay japanyäśhañatacmi ichá cawsananpä capuśhallanta lluyta uycülun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chaynu nilcuptinmi waquin yaćhapacünincunañatac chay wasïta licalcul nicuyalcan: “¡Diospa wasin'a sumä-cama lumiwan jinaman paypä uycapäcuśhancunawan maynu sumä tuqui-camamá caculläñä!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Niptinmi Jesus: “Lluy caycunapä camacaynin ćhämun'am. Manamá nï juc lumipis täcuśhanćhu täcun'achu. Lluymari pampaman muyun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Niptinmi yaćhapacünincuna nila: “Yaćhachicüní, ¿imaymi chay lulacacun'a? ¿Ima siñalcunam chay timpupä pasan'a?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Niptinmi Jesus nila: “Yan'al-lätac pipis ingañapäcuśhunquiman. Ya'atuculmi achca ‘Ya'am Diospi Caćhaśhan Salbacüca cayá’ nil śhapämun'a. Jinamanmi ‘Cay timpu camacaynin jananchicćhüñam’ nipäcun'apis. Chaynu nishuptiqui ama änil paycunacta atipäcuychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ñatac imaymana gïrracuna jinantin pachäćhu talcuśhanta uyalilpis amatac manchaculcaychu. Chaycuna pasananmi yaćhacun masqui manalä camacayca cayaptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rasunpa chaypá nasyuncunapis malcacunapis gïrranaculcan'am. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chaynütacmi mayćhu chayćhüpis micuy wanacunapis ishyaycunapis śhaśhaycunapis cacun'a. Chaynütacmi manchanaśh siñalcunapis sïlućhu pasan'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Manaläpis cay timpucuna allaycuptinlämi ya'a-laycu chalapäcuśhunqui, aticaćhapäcuśhunqui. Juntunaculcänan wasicunap puydïninmanpis ćhulapäcuśhunquim. Carsilmanpis wićhachipäcuśhunquim. Jinamanñatacmi imaymana puydï mandacücunap maquinman alaśhćhapäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Caycunaćhümari ya'api willacunayquipä caycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Chayćhu umayquiman-ari sumäta ćhulacuy ‘¿Imactatá canan limalicuśhä?’ nil mana llaquicuyalcänayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chay ürañatacmi ichá ya'a quiquí juc sumä yaćhayta upäcuśhayqui chay tumpaśhüniquicuna mana ima limayninwanpis gänapäcuśhunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Jinaman'a quiquiquicunap ayllullayquim taytayquipis irmänuyquipis llapa lisinacuśhayquicunapis jatun awturidäcunap maquinman ćhulaycälishunqui. Jinaptinmi waquinniquicunactá wañuchipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lluy lluymá ya'a-laycu ćhïnipäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Masqui caynu lulapäcuśhuptiquipis, manamá umayquipi nï juc ächallayquipis chincan'achu. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Canan ya'aman imacunaćhüpis masïsu chalapacayalcämal'a salbacunquim. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Má, Jerusalen malcäta ćhïnïnincuna intunanpa lluy cunćhacaycäliptin'a yaćhapäcunquiñam mana cäman muyuchinan timpun jananćhüña caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Cay'a Diospa unay willacünincunap nipäcuśhan castigunmi can'a. Chayurá Judea malcacunäćhu yaćhäcuna, ulucunäman pacacamü ayipäcuy. Jerusalenćhu yaćhäcunäpis mana cutiycamüña ayiculcay. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Maynu llaquićh patayu walmicunäpä, wawinta ñuñücunäpäpis can'a! Nana nanay ñacaycunaćh cay jinantin pachäćhu cacun'a Diospa piñacuynin cay Israel malcaman ćhämuptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquinninmi ispädacunawan wañun'a. Waquinnincunañatacmi juc-lädu nasyuncunaman prïsu apaśha can'a. Chaynütacmi juc-lädu nunacuna jalutaculcan'a Jerusalenta aśhta Dios üranta unanchaycunancama. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“Ñatac siñalcuna intïćhu quilläćhu uyllurcunaćhüpis cayaptin'a jinaman lamarcäpis altu altuman ticlaśhtinnu wicapacacayämuptinmi intiru nasyuncunaćhu nunacunaca ‘¿Imam caynüpa pasacuyan?’ nil chucchulipäcun'a. Ñatac lluy sïlućhu cäcuna śhaśhäluptinmi ‘¡Cay pachaca lluyćha chincacun'a!’ nil wañütuculcan'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lluy caycuna pasayaptinmi ya'a Rasun Nunap Chulincäta jinantin pachäćhu cä nunacunaca licapäman'a pucutay śhun'unćhu sumä munaynïwan śhayämüta. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Caycuna lluy allaycuptin callpanchaculcay. Cay ñacaycunäpi julapäcuśhunayquipä Diosninchic janayquićhüñamari cayan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chaynütacmi jucman tinculcachil willala: “Licapäcuy ïgus jaćhäman ütac juc lantacunamanpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chaycunam timpun ćhämuptin'a chillquilimun. Chaynu captin ¿manachun ‘Tamya timpu sircañamá’ ninchic? ");
INSERT INTO qvwNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chaynu-ari lluy caycuna pasaśhanta licapäcul'a yaćhapäcuy Diospa gubirnun janayquićhüña caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Rasunpa caycuna pasan'a manaläpis cay timpu nunacunaca camacaptinlämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sïlüpis allpäpis camacällam, ñatac cay nishäcá wiñay simpripä cawsämi. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Imaypis licchat-licchat capäcuy chaypun trampa-yupaypis mana juclla chalapäcuśhunayquipä. Rasunpa chay muyun jinantin pachantinpämi ćhämun'a. Yan'al-lätac śhun'uyquita lumiyächicuyanquiman mana allin lulaycunawan, shincacuycunallawan ñatac cay cawsayniquićhu imapïpis wañuyäśhayquiwan. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aśhwanpa Diosta mañaculcay cay jananchicćhüña cä timpucunäpi ayil ya'a Rasun Nunap Chulincäpa lädüman ćhäpämunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Ñatac muyun-muyunmi wäla-wälapïta nunacunaca Jesusta uyalipäcü śhapämula chay chuya wasiman. Chayćhümi tucuy anyaśh Jesus yaćhachila. Tutapñatacmi Ulibus nishan ulüćhu quïdacü cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ñam sircayämulaña Egiptopi Libraculcäśhan Fistaćhu Mana Libadürayu Tanta Fistaca. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chayćhümi puydï sasirdüticunäwan yaćhachicücunaca malcäta lisirapäcul artillawan Jesusta chalalcachil wañuchipäcunanpä ashipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chayćhümi Jesuspa jucnin yaćhapacünin Judas Iscarioti nishanman Satanaśh uśhtüña. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jinaptinmi puydï sasirdüticunäman, Diospa chuya wasip täpänincunämanpis Judas lila “¿Imanuypam Jesusta maquiquiman ćhulaycämucman?” nil niycü. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Niptinmi sumä cushisha: “Luläluptiqui'a pägaśhayquim” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Niptinmi Judas awnilcul Jesus ash nunallawan cananta imanuypapis chalaycachinanpä licapayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jinayaptinmi Mana Libadürayu Tanta Fista ćhämun. Chaypämi juc malta uwishta wañuchipäcunan cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chayćhümi Jesus Pedroctawan Juanta caćhala: “Alistapämuy-ari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Niptinmi: “¿Mayćhümi?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Niptinmi: “Canan Jerusalenta cutipäcul tincunqui yacun ipicüśha liyä wayapawan. Paytam may lishantapis atipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wasinman ćhaycul ji'acuycuptinmi wasiyüninta nipäcunqui: ‘Yaćhachicünïmi nishunqui “¿Mayannin cuartuyquim yaćhapacünïcunawan cay fistaćhu micapäcunäpä cayan?” ’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nipäcuptiquim juc jatun cuartunta tuqui allichäśhacta altuśhninćhu licachipäcuśhunqui. Chayćhu lulapämuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Niptinmi yaćhapacünincuna malcaman ñawpapäcula. Chayćhüshi nishantanülla rasunpa lluy talilcälil alistapämula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chaypïtam Jesus parti yaćhapacünincunäwan ćhaycamul mïsaćhu micunanpä cayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chayćhümi Jesus nila: “Caynu amcunawan sinaycuyta mayćhá munalá cay cawsaynïćhu. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Rasunpa manaćh imaypis caynu'a micuśhächu aśhta Diospa gubirnunćhu cay lulaśhäcuna lluy tantiacacunancama” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nilculmi bïnuntin cüpacta apticulcul Diosta anradisicula. Jinalculmi yaćhapacünincunacta nila: “Caypi llapayquipis pasachinacul upyapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Caypi'a manañam mallilcuśhächu Diospa gubirnun ćhämunancama” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nilculmi Diosta anradisiculcul aptiläśhan tantäta partila cay nishtin: “Cay tantämi aychá. Amcuna-laycum cay aychäta wañuyman uycú. Caypi puntaman lulaśhäta yalpayniquiwan micapäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chaynütacmi sinayta camacalculpis juc cüpa bïnucta apticulcul nila: “Cay cüpa muśhü limalicuy amcuna-laycu jićhaśhá yawarnïwan tacyalpachishäcämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chaynu nilculmi: “Canan ipanchamäca ya'anchicwan cuscam micuyan. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ya'a Rasun Nunap Chulincäpi isquirbishancämi lulacacun'a. Ñatac ¡chay ipanchamäca imanuylä can'a!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Niptinmi yaćhapacünincuna quiquin-pula tapunacucuyan: “¡¿Imatan?! ¡¿Mayanninchictan chaynu cayanchic?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chayćhümi llapa yaćhapacünincuna pilyap-pilyacuyalcan mayannin puydï cananpïtapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jinayalcaptinmi Jesus nila: “Juc-lädu nasyuncunap puydïnincuna jinantin nunantam alafirsa duminalcul llaqui bïdacta pasachin. Jinalculmi ‘Allintam lulayá nunäcunapä’ nil'a alawacunpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amcunaćhu'a ama chaynu cachunchu. Aśhwanpam amcunaćhu allin puydïninpa licaśha can'a śhullcanuy llapanta sirbïca. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Chay juc nunacunacá ¿mayannintatan mas puydïpa licapäcun? ¿Mïsaćhu täcücätachun icha sirbïcätachun? ¿Manachun paycuna mïsaćhu täcücäta puydïpa licapäcun? Ñatac licapämäśhayquinüpis ya'a amcunacta sirbicmi. Chaynu captin'a amcuna ¿imanuytan capäcunqui? ");
INSERT INTO qvwNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","30","“Cananmi Taytá maquïman ćhulaycamun lluy gubirnunta. Caynu canancama ima ñacaycunacta pasaptïpis mana caćhaycälimäśhayquipïmi canan partiycälishayqui cay imapis lluy cänïta. Jinamanmi ćhunca ishcayniyu caśhta Israel malcäta cäraycälinayquipä ćhulaycälishayqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nilculmi Pedrocta nila: “Ay, Simon, Simon. Trïgu wipyaylla amcunacta camacaycüśhunayquipämi Satanaśh alli-allicta wañupacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pedro, masqui chaynu captinpis chalapacamayniqui mana lluy chincalpunanpämi ya'a mañacuyá. Ñatac caśhan ya'aman licaćhacamulćha aśhwanpa chalapacü-masiquicunactapis am callpanchaycunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Niptinmi Pedro: “¡Taytáy, masqui ima cacuptinpis anwanmi carsilmanpis yaycuśhä! ¡Wañuycäcamapis atishayquim!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Niptinmi: “Rasunpa canan tuta wallpa wa'amunanpá ñam quimsa cutictaña ‘¡Caytá manam lisïchu!’ nil nimanqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaypïmi Jesus tapula: “Unay mana alpurjayüta, mana illayniyüta, cala ćhaquillacta caćhäläliptí ¿imapïpis lluychun palpucälälimulanqui?” nil. Niptinmi: “Manam imapis faltapämälachu” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Niptinmi: “Chaypun cushishamá chalapacalcämälanqui, ñatac canan'a ¿imanuyćha can'a? Canan imayquipis faltaśhuptiqui'a quiquiquicunañari licaculcay ima pishishuśhayquitapis. Apay-ari canan'a illayniquitapis, alpurjayquitapis. Ñatac ispädayqui mana capuśhuptiquipis, müdanayquita lanticulcul lantipäcuy-ari. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Diospa willacünin ya'api nila: ‘Jucha-sapapä licaśham can'a’ nilmi. Chay nishan üraca ñamá jananchicćhüña. Cay imam nishannümi ya'awan lluy lulacacun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Niptinmi nipäcula: “Taytáy, cayćhu ishcay ispädallanchic'a cayäñämi” nil. Niptinmi: “¡Basta, camacächunña!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chaypïmi custumrinmannuy Ulibus ulüta licuptin yaćhapacünincuna atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chay ulüman ćhälulmi Jesus nila: “Diosta ruygaculcay cay śhamü llaquicuycunäćhu callpawan śhaycapäcunayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nilculmi chaypi caluscaman licula. Chayćhümi un'ulacuycul Diosta ruygacula: ");
INSERT INTO qvwNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taytáy, munal'a cay ćhacćhä-yupay ñacaycunäpi julaycallämay. Ñatac amatac-ari ya'a munaśhänu'a cachunchu, sinu'a ampïtaćh imanuypis can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Niyaptinmi juc anjil sïlupi licalilcamul callpanchäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Chaymi chay sumä llaquicuyninćhu mas callpawan ruygacula. Jinaptinmi yawarnu südayninpis pampäman ćhalćhala. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chay ruygacuśhanpi cutimulmi yaćhapacünincunacta llaquicuypi puñuywan aysachicüśhacta talïlun. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jinaptinmi nila: “¿Puñuyalcanquilächun imamá? Śhalcuy-ari. Cay śhamü llaquicuycunäćhu callpawan śhaycapäcunayquipä Diosta ruygaculcay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chaynu niyällaptinlämi achca nunacunacta puśhapacüśha jucnin yaćhapacünin Judas ćhämun. Chayćhümi Jesusman aśhuycul custumrinmannuy muchaycul saludaycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jinaptinmi Jesus nila: “Judas ¿caynu muchaycuyllayquiwanchun ya'a Rasun Nunap Chulincäta caynu ipanchämanquiman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Niptinmi parti yaćhapacünincuna imapis mana allin pasananta tantialcul: “Taytay, cay ispädawan-ari ya'acunapis difindiculcäśhä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nilculmi jucnin puydï sasirdütip uyway nunanpa allï linlinta pasächin. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jinäluptinmi Jesus: “¡Basta! ¡Chaytá ama lulaychu!” nila. Nilculmi chay nunap linlinta yataycul sänachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chayćhu puydï sasirdüticunaca, Diospa chuya wasip täpänincunaca, prinsipal yaśhacuna puśhananpä lluy śhäcucuyalcaptinmi: “¿Ya'a suwachun imam calá caynu caśhpiqui ispädayqui aysacälälisha puśhapämänayquipä? ");
INSERT INTO qvwNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Walan-walan Diospa chuya wasinćhu yaćhayächiptïpis manatac chalapämälanquichu. Ñatac canan'a callpayu mala-üraćhünümi cacuyanchic. Chaymi canan amcunactá caycunacta lulapäcunayquipä tücälälishunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nilcuptinmi Jesusta chalalcul puydï sasirdütip wasinman puśhaculcäla. Pedroñatacmi calullapi atila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chayćhümi chay wasiyüpa uywaynincuna ninacta walacalcachil muyülïninman cunćhacaycälil patyu ćhawpićhu unupacuyalcäla. Chaymi Pedropis ćhaycul-pacha unupacü aśhuycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaynayaptinmi jucnin walmi alli-allicta licapaycul: “Cay nunäpis wic nunäwanchućhari cayäla” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Niptinmi Pedro: “Walmi, ¿mayanpïćha limacunquipis?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chaynu nilcul cayaptinmi unascapïtá jucninpis licalcul nintac: “Ampis wic nunacunäpa caśhta-masin-ari cayanqui, ¿aw?” nil. Niptinmi: “Manam lisïchu. ¿Mayanćha cacunpis?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chaypïtam juc ürapïtanu'a jucpis nicuyan: “Caypis wic nunäwan pulï-ari. Galilea nunäpanüllam limacuyninpis cañä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Niptinmi: “Wayapa ¿imapïćha chayta limacunquipis? ¡Manam yaćhächu!” Caynu niyällaptinlämi wallpa wa'amun. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jinaptin Pedrocta Jesus licalcämuptinmi yalpaćhacülun “Wallpa wa'amunanpá quimsa cutictañam ipanchämanqui” nil nishanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jinalculmi chaypi yalalcamul llaqui-llaquicta wa'acuyan. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ñatac chayćhu chay täpänin nunacunämi burlapalcul burlapalcul Jesusta lluy ma'apäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jinalmi payta bindacaycälil: “Yaćhätucü, má niycälimay ¿mayannïshi tacapäcuñac?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nilcul nilculmi imaymanacta insultapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chayćhu achicäluptinmi prinsipal yaśhacuna, puydï sasirdüticuna, camachicuyta yaćhachicücunaca juntunacälälila. Jinalculmi Israel malcap quija arrinlänincunaman Jesusta puśhala. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Chayćhümi tapupäcula: “Má, canan, nipämay ¿amchun Caćhamuśhan Salbacüca cayanqui?” nil. Niptinmi Jesus: “ ‘Aw’ nipti'a manaćh quiripämanquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ñatac chaycunapi limal'a, yan'añaćh limachwanpis. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ñatac cayta yaćhapäcuy: cananpi-pacham cay ñawpäniquićhu Rasun Nunäta Tayta Dios prinsipal mandacüninpä lädunman taycaycachiman'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Niptinmi llapanpis nicuyalcan: “¿Chayurá ‘Diospa Chulinmi cayá’ niyanquichun?” nil. Niptinmi: “Aw, amcuna nimäśhayquinümi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Niptinmi ninacücuyalcan: “Canan quiquinpa shiminpi caynu uyaliyal'a ¿ima mastañam pï niycamänanchictapis munaśhun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chayćhu lluy śhalcatityalcälilmi Roma nasyunta mandawshïnin Pilatoman Jesusta pasachiculcan. Paymi chay timpu Israel nasyuncäta gubirnäca cala. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ćhaycälichilmi ñawpäninćhu nipäcula: “Cay nunam malcanchicta umacta uyäñä. Cay nunapïtá manash Puydïniqui Cesarman alcabälanchicta pägachwanchu. Jinaman malcanchicpa rasun Salbacü Mandacünincäläshi cacuyanpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Niptinmi Pilato Jesusta tapula: “¿Chayurá amlächun Israelcunäpa sumä mandänincälä cacuyanquimanpis?” nil. Niptinmi: “Anmá niyanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chaynu niptinmi chayćhu puydï sasirdüticunätawan lluy nunacunäta Pilato nila: “Cay nunällaćhu'a manamá ima faltactapis talïchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Niptinmi mas-masta wañupacucuyalcan imapis lulananpi. Jinaśhtinmi: “Cay niyninwanmi llapa malcacunätapis umanta muyuyächin Galileacunapïta cay Judeacamalä” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chaynu nipäcuptinmi Pilato tapula: “¿Chayurá cay wayapaca Galilea nunachun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Niptinmi: “Aw-ari” nipäcula. Chaynu nïläliptinmi Galilea jatun malcap gubirnänin Herodesman chay üra puśhachila. Paymi chay muyuncuna Jerusalenćhütac cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Chayćhu Jesusta licalculmi Herodes alli-allicta cushicula: “Cay umrïtamá lisiyta munalá. Paypïtari llapa nunapis imacunacta lulaśhanpïpis limapäcun. Puntäćhüćha ima milagrullactapis lulaycachishä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaynu pinsaśhtin Jesusta imaymanacta tapuptinmi pay'a mana nï imactapis cuntistalachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chayćhütacmi llapa puydï sasirdüticunäpis, camachicuyta yaćhachicücunäpis śhun'unpis timpucuyaptin cuntranpi limacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jinaptinmi Herodespis cachacucunäpis lluy burlapayninwan müdälächin mandacüpa müdanancunawan. Jinalculmi Pilatomanñatac cutïchimun. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Caynu pasachinacul pasachinacul caśhanpam chaypun Pilatowan Herodes allinpanacälälin puntactá ichanllanpalä licanacuyäśhanpi. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chaypïtam Pilato puydï sasirdüticunacta, jinantin malcap puydïnincunacta, ñatac jinantin malcäta juntüchimun. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jinalculmi chayćhu nila: “Amcunam cay wayapacta ya'aman puśhapämulanqui ‘Cay malcanchictam jucnüta limapayäñä’ nilcul. Chaymari amcunap ñawquiqui tapulpis cay nipämäśhayquitanu'a mana talïchu. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chaynütacćhá Herodespis mana ima juchactapis talil cutichimula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Caynu mana imapis lulaśhan cayaptin'a allicta lawćhalcachil-ari caćhaycüśhä” nin. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chaynu nila fistaćhu juc prïsucta caćhaycunanpä custumri captinmi.˼ ");
INSERT INTO qvwNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ñatac nunacunacá juc-yupayllam apalcaćhacuyalcan: “¡Chaytá wañuchipäcuy! ¡Barrabasta caćhaycuy!” nil. ( ");
INSERT INTO qvwNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Cay Barrabas gubirnup cuntran śhalcuculcul nunacta wañuchishanpïmi carsilćhu wićhaläla.) ");
INSERT INTO qvwNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatoñatacmi Jesusta caćhaycuyta munala. Chaymi llapa nunacunäta yapapis caćhaycunanpä nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nilcullaptinmi mas-masta lüyatityal apalcaćhacuyalcan: “¡Chacatäluy! ¡Chacatäluy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chaymi yapañatac Pilato nila: “Ñatac nipäcunayquipá ¿ima juchactatan cay nunaca luläla? Caynu curuśhćhu wañunanpänu'a manamá ima juchantapis talïchu. Chaymi ‘Alli-allicta waśhapis matäpä lawćhalcachil caćhaycuśhä’ niyá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Niptinmi llapa nunapis sumä-sumäña jicutäcuyalcan: “¡Chacatäluy!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chaymi nunacunaca nishanta Pilato awnïlun. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jinalmi chay gubirnup cuntran śhalcünin Barrabasta carsilcäpi wicapalcamul nunacuna munaśhanmannuy Pilato Jesusta ćhulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chay chacatananpä yalacayächilmi Cirene malcayu Simonwan tincülun. Paymi cay Jerusalenman cutiycayämula. Chayćhümi cachacucunaca payta chalalcul munäta mana munäta śhawachipäcula Jesuspa apaśhan curuśhninta ipanta apananpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Chayćhümi nisyu-nisyu nunacunäwan lï walmicunäpis maquillantapis tällalcul-tällalcul Jesuspi wa'apäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Chaynaptinmi Jesus paycunacta nin: “Jerusalen walmicuna, ama ya'api wa'apäcuychu; aśhwanpa quiquiquicunapi wawiquicunapi wa'aculcay. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Caypi śhamü timpucunaćhümi sumä-sumä llaqui ñacaycuna cacun'a. Chayćhümi mana wawiyücunaca ‘ima cushicuymi mana wawiyu cacuy’ nil nipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chay muyuncunaćhümi manchacuypi ulucunätapis a'acunätapis ‘¡Pacaycallämay! ¡Ñitilpallämayñapis!’ nil nipäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Canan caynu ya'a mana juchayu nunawanpis caynüta lulayalcal'a, amcunactá ¿imactaćh lulapäcuśhunqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chayćhu puśhayälatacmi ishcay suwacunacta Jesuswan cuscacta curuśhman chacatananpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chay “Uma Tullu” nishanman ćhaycachilmi Jesusta lluy chacatälälin curuśhninman. Wicninman cayninmanñatacmi ishcay suwacunacta chacatälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chayćhümi Jesus nila: “Taytay, caycunapi pampachaycuy. Manamá yaćhanchu ima lulapäcuśhantapis” nil. Jinamanmi Jesuspa müdanancunacta aypunaculcänanpä lluy cachacucunaca chüsanaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chayćhu lluy nunacunaca anśhalayalcaptinmi puydïcunacá burlapapäcula: “Jucta salbätucunallanpächun bälin. Má, canan Aclaśhan Salbacüca rasunpa cayal'a quiquintari salbacuchun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Chaynütacmi cachacucunäpis burlapäcuyalcan ćhacćhä bïnucta upyachiyninwan. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jinalmi nicuyalcan: “Am Israel nunacunap mandänin cayal'a, má, salbacuy-ari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chaynu jinalculmi Israelcunap, Romacunap, Griegocunap limaynincunaćhu curuśhcäpa umanman cläbala “Caymi Israelcunäpa Mandäninca” nil niyäta. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ñatac chay-lädunćhu jucnin suwañatacmi Jesusta ruydupayta allacuycun: “¡Am Diospi Salbacüca cayal'a, salbacuy-ari ya'acunactapis salbaycapämänayquipä!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Niptinmi juc suwäñatac piñapälun: “Wañuyca janayquićhüña cayaptinpis ¿manalächun Diosta manchacunqui? ");
INSERT INTO qvwNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ya'anchic'a juchanchicpïmi caynu lulaśha cayanchic. Ñatac cay nunacá mana imapis lulaśhanpïmá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nilculmi Jesusta nila: “Taytay, mandacü yaycul yalpalcallämanquimá. Amamá un'aycallämanquichu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Niptinmi: “Aw, canan-pacham am ya'awan cusca Diospa sumä-sumä caśhancäćhu canqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Chayćhu intica wañüluptinmi jinantin pachaca ćhawpi muyunpi aśhta tardi mishquipay üracama lluy tutapälun. Chayüratacmi Diospa chuya wasip jatun curtïnanpis ćhawpipi laćhyäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chayürallatacmi Jesuspis ayaycaćhaypa: “Taytay, cay almalläta maquiquimanmi ćhulaycamú” nila. Nilculmi pasacalpula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lluy caycuna pasäluptinmi täpäninca Diosta alawal: “Cay nunaca manaćhá juchayüchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chayćhüñatacmi llapa äśhalä nunacunaca sumä llaquisha-cama malcanta cutipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesusta lisïcunawan Galilea-lädupi liwshïnin walmicunäñatacmi ichá calullapi licapapäcula ima pasaśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ñatac chayćhümi Judeap Arimatea malcanpi José śhutiyu wayapa cañä. Paymi Diospa nunannuy tuqui allin cawsayniyu Diospa gubirnun ćhämunanta alcaśhtin cala. Pay Cunsïjup jucnin puydïnin cayalpis manam awnilachu parti-masincuna lulaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chaymi chayüra Pilatoman pasacula aya Jesusta curuśhcäpi julamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chaynu julalcachimulmi juc fïnunnin säbanaśh-niläcunawan ayäta lluy pitwïla. Jinalculmi a'aćhu muśhü ućhcüśha maćhayman chutaycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Caynu apura-apuraypa pasachila chay warda muyunpä alistaculcänanpä ji'acaycayämuptinmi. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chay Galileapi liwshïnin walmicunañatacmi maycäćhu chutaläśhantapis licapapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chayćhu licalcamulmi wasinta cuticalcämula: “Acuchun, pirfümicunacta lluy alistamuśhun ayäta pasaycunanchicpä” nil. Chaynu nilculmi Moisespa camachicuyninćhu nishan-yupaypis warda muyunćhu jamaculcäla walantincama. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chay walantin simänap allaycuyninćhümi wäla-wälalla chay walmicunaca juc walmicunallawan liculcäla chay lluy alistapäcuśhan pirfümicunäta apaculcul. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chayman ćhäpäcunanpämi chay maćhayta wićhaśhan lumica aśhüchisha cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chayman yaycapäcunanpämi ayaca manaña cañächu. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jinaptinmi “¿Imanäluntan?” nil śhäcuyllaman camäśha cayalcaptin ishcay wayapacuna chipipicyayä müdanayü-cama lädunćhu licalïlun. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chaymi walmicunaca manchalicucuyalcal pampäcama cärantapis ćhulälälila. Chay nunacunäñatacmi: “¿Cawsayäcätachun cay wañücunap canancäćhu ashiyalcanquiman? ");
INSERT INTO qvwNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Manam cayćhüchu, sinu'a cawsayanmi. Yalpapäcuy Galilea malcäćhu cayal: ");
INSERT INTO qvwNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Juyu nunacunap maquinman ćhaycachimaptinmi chacatal wañuchipäman'a. Chaynapämaptinpis quimsa muyunpïtá caśhanmi cawsamuśhä’ nil nishancäta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Niptinmi paycuna chaypun nishanta yalpaćhacälälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jinalculmi cuticalcämula Jesuspa ćhunca jucniyu yaćhapacünincunactawan chayćhu cä juccunätapis caycunapi willaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Cay willacü walmicunämi capäcula Magdalapi Maria, Juana, Jacobop maman Mariapis. Chaynütacmi juc liwshï walmicunäpis chay willacuyta willaycula.) ");
INSERT INTO qvwNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chaynu willapäcuptinmi “Muspayalcanćha” nil mana quirïtuculcälachu. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Chaynu nilculmi Jesus chutaläśhancäman Pedro wayra-wayra pasacula. Ćhaycul licaycunanpämi pitwishan säbanacunallanña lawalayäñä. Chayćhümi licapayllaman camäśha wasinta cuticamun. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay muyunñatacmi ishcay yaćhapacünincuna Emaus malcäta liyalcäla. (Cay malca Jerusalenpïta ćhawpi muyun lina caminućhülämi cala.) ");
INSERT INTO qvwNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chaynu liyalcalmi chayćhu imapis pasaśhanpi limaśhtin liyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chayćhümi Jesus lädunćhu licalilcul paycunawan lila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Chaynu lädunta liyaptinpis chay ishcay nunacá manam lisipäculachu Jesus caśhanta juctanu ñawin licaptin. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chayćhümi tapula: “¿Imapïtam sumayalcächinqui?” nil. Niptinmi sumä llaquisha-cama śhaycacaycälil ");
INSERT INTO qvwNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleopas nishan nila: “Jerusalenpi śhayämul ¿imanuypatan ampá mana yaćhanquimanchu cay muyuncunaćhu ima pasaśhantapis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niptinmi: “¿Imatan pasälun?” nila. Niptinmi nipäcula: “Nazaret malcäpi Jesuspi-ari. Pay'a Diospi willacünin calmi tumshumanpis yaycüta yaćhachicula. Paytam Diospis ñatac lluy nunacunapis allinpa licapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Chaymi ya'acuna paypi niyalcälá: ‘Paymi rasunpapis cay Israel nasyunninchicta Salbacüca can'a’ nil. Chaynu cayaptinpis puydï sasirdüticunäwan puydïninchiccunam lluy chacatal wañuchipäcunanpä ćhulaycülun. Chay pasaśhancuna quimsa muyunñam cayan. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ñatac ya'acunawan cä walmicunämi canan willaycäliman mana quirinaśhta. Cay wälalla paycunash Jesus chutaläśhancäman lipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Chayćhu yaycunanpäshi ayaca mana cañächu. Jinaptinshi chay-lädunćhu anjilcuna licalilcul ‘Jesus cawsayanmi’ nin. Lluy caycunapi willacuśhtinmi ya'acunamanpis ćhälälimun. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chaynu willaycälimaptinmi ya'awan cäcunäpi waquinnin'a licamü lipäcula. Chayshi paycunapis walmicunaca nishantanuy talïlälin. Jesus'a rasunpa manash cañächu” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Niptinmi Jesus nila: “Caycunapi ¿imaycamaćh mana tantiapäcunquichu? ¿Imayñaćh amcuna chalapaculcanquiman Diospi willacünincuna caycunapi nishanta? ");
INSERT INTO qvwNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","27","Caćhamuśhan Salbacüca altuman juluśha cananpä lluy caycunalämi puntacta pasanan cala. Chaynütam niyan Diospa limayninćhüpis” nila. Nilculmi Moises isquirbishanpa allaycuyninpïta aśhta Diospa willacünincuna isquirbishanpa camacaynincama manyapi paypi lluy willapäla. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chay Emaus lishan malcäta ćhaycuyaptinmi Jesus ñawpacun pasacünu. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Jinaptinmi aspicalpuyaptin: “Anchap tardiñam cacuyan. Cayllaćhüña quïdacuśhun” nipäcula. Chayćhümi Jesuswan quimsan jamapacü juc wasiyüman yaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chayćhümi sinapäcunanpä mïsaćhu cayalcäla. Jinaptinmi chayćhu tantäta Jesus apticulcul Diosta anradisicuycul partilcul paycunacta uycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chay uycuśhan ürallam paycunap ñawincuna juclla quićhacacünuy cälun. Jinaptinmi Jesus caśhanta lisïlälin, ñatac Jesus'a jucllash chincacuñä. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chayćhümi pulan ninaculcäla: “Paypa shimin calćhá śhun'ulläta achicyalcachimäla chay caminüćhu paypi willamaptinchic” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chay ninaculculmi caśhan chay üralla Jerusalenta cuticalcämula. Chayćhümi talïlälin ćhunca jucniyu Jesuspa yaćhapacünincunactawan juccunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chay ćhäläliptinmi chayćhu cäcunäpis: “Aw, rasunpa Jesusninchic cawsayanmi. Simonpis licälunshi” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niptinmi paycunapis chay caminućhu ima pasaśhantapis, ñatac Jesus tantacta partïluptin lisïlälishantapis willapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lluy caycunapi limay-limay cayalcaptinmi Jesus paycunap ćhawpinćhu licalïlun: “¿Allinllachun? Jawcaña capäcuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nilcul licalïluptinmi chucchucuyalcan “¡Almamá!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Niptinmi Jesus: “¿Imactamá manchacalcämanqui? Manam almachu cá. Ama ishcayyapäcuychu. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Licay ćhaquïta maquïta. Ya'a quiquïmi cayá. Canan aśhuycamul licaycul chalaycälimay tulluyu aychayu caśhäta yaćhalpälinayquipä. Almacuná manamá aychayüchu nï tulluyüchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cay nilculmi maquinta ćhaquinta licachila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Niptinmi llapanpis muspayninćhünu licalilcul cushishanuy cayalcalpis manam “Aw, paymá” nil nipäculachu. Chaynu cayalcaptinmi “¿Manachun imallayquipis can micunäpä?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chay mañaptinmi partin challwa ancayta uycälila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jinaptinmi ćhasquilcul paycunap ñawquin micula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chayćhümi nila: “¿Manachun amcunawan cayal cayta nipäculac jinantin Diospa shiminćhu ya'api limaśhanca lluy lulacacunanta?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nilcul lluyta tantialcachilmi nila: ");
INSERT INTO qvwNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","48","“Diospa shiminmi willamanchic Salbacücäta wañulcachiptin quimsa muyunpïtá caśhan śhalcamunanta. Chay nishannuy lluy pasaśhantam amcuna ñawiquiwan licapäculanqui. Chayurá canan amcuna willaculcänayquim Jerusalen malcäpi allacuycul aśhta maycamapis: ‘Diosman cuticamuy. Juchayquicunacta Jesusmi pampachaśhunqui’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ñatac chaypá Taytá limalicuśhan Chuya Ispirituntalämi amcunaman caćhamuśhä. Chaypämi altu sïlupi juc jatun munay ćhämuśhunayquicama cay Jerusalenćhu capäcuchcanqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaycunacta lluy limapalculmi juc-punćhu'a Betania malcäman llapantapis puśhala. Chayćhümi paycuna allin capäcunanpä Taytanta ruygacula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chaynu ruygacuyalmi quiquillan pallacaculcul sïlüman chincacuycula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chayćhu alawapäcuśhanpïñatacmi cushisha-camaña Jerusalenta cuticalcämula. ");
INSERT INTO qvwNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jinalmi muyun-muyunpis Diospa chuya wasinćhu payta alawapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mana imapis cayaptinlämi Diospa Limaynin ñä cayälaña. Paymi Dioswan cala; paytacmi quiquin Dios cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Manaläpis ima ayca cayaptinlämi Tayta Dioswan cayälaña. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paywanmi Tayta Dios lluy lluy imacunactapis camala. Manamá ima aycallapis paywan mana camaśhan'a canchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","5","Pay quiquintacmi cawsachicüca. Chay cawsayninmi juc acchinuy sumä yanawyayä tutapäćhünuy lluy nunacunäta acchin. Ñatac tutawyayca imanaculpis acchïta manamá llallinmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chaypämi juc nuna Juan śhutiyu Diospi caćhamuśhan cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Paymi llapa nuna chalapaculcänanpä acchïpi willaycul tantiaycachï śhamula. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan'a manam quiquin acchïchu, sinu'a willacüllam puntamula. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Rasun acchicá llapan nunacunäta acchinanpämi cay pachäman ñaćhapaycayämula. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pay'a cay pachäćhu ñam cayälaña. Masqui paywan cay pachäta Dios camayaptinpis, nunacunaca manam lisïtuculcälachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Caśhta-masinman śhamuptinpis, paycuná manam ćhasquipäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ñatac ćhasquiycul chalapacücunätam ichá, quiquinpa chulinpälä Diosninchic licaycun. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Paycuna manam nunap chulinnüllachu, nï aychap munaśhallanmannu näsïpischu, sinu'a Diospa munayninmannümi. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ñatac Limayca nunaman muyulculmi ya'anchicwan cusca cay pachäćhu yaćhala. Rasunpa licapäculá, tantiapäculá Tayta Diospa japallan chulin maynu sumä caśhantam. Paymi sumä-sumä llaquipaynintawan rasuncällacta lisiycachimanchic. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypïmi Bawtisä Juanpis willacula: “Paypïtamari nipäculac: ‘Ipäta śhamücá ya'apïta mas puydïmi; manalä cayaptí pay puntapi cayälañamá’ nil” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chay sumä-sumä cuyacuyninpïtam yapalcul yapalcul llaquipaycamanchic. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ñatac Moisespïmi camachicuycätá ćhasquiycunchic; llaquipäcuycätawan rasuncätam ichá Salbacüninchic Jesuspi ćhasquiycunchic. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Imaypis pipis Tayta Diosta manam licalachu; sinu'a Chulin quiquin Dioswan cusca cawsäcällam paypïta camalachimälanchic. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Má, caynümi pasala Juanwan: Jerusalen malcäćhu cä Israel puydïcunämi sasirdüticunätawan yanapä Levïcunäta Juanman tapuchï caćhala “¿Pitá cayanqui?” nil. Niptinmi Juan rasuncällacta nila: ");
INSERT INTO qvwNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“Diospa Caćhamuśhan Salbacücächu manam cayá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Niptinmi: “¿Chayurá pitan cayanqui? ¿Willacü Eliaschun?” nin. Niptinmi: “Manam” nin. Niptinmi: “Chayurá ¿Diospa willacünin caćhamunancächun?” nin. Nipäcuptinmi: “Manatacmi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Niptinmi: “Chayurá ¿mayanmá cayanqui? Caćhamänïtam niycälinä cayan. ¿Mayan cayá nicuyanquitan?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nipäcuptinmi Diospa willacünin Isaiaspa limaśhanwan Juan nin: “Chunyäninćhu ayaycaćhäcämi ‘Taytanchic ćhämunanpä sumäta allichaculcay’ nishanca cayá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Niptinmi chay caćhapämuśhan fariseo caśhtacunaca nin: ");
INSERT INTO qvwNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Mana Diospa Caćhamuśhan Salbacücäpis, nï Eliaspis, nï Diospa Willacüninpis cayal'a ¿imapïtan-nila bawtisayanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Nipäcuptinmi: “Ya'a yacullawan bawtisäcällam cayá. Ñatac amcunap ćhawpiquićhu cäcätam ichá mana lisipäcunquilächu. Ipäta śhayämuptinpis uywayninnu śhucuyninpa watullanta pasquiycunäpäpis manam bälïchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lluy caycunam Juan bawtisaśhan Jordan mayup chimpan Betania malcaćhu pasala. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chay walantinmi Bawtisä Juan Jesusta śhayämüta licälul: “¡Licapäcuy licapäcuy! ¡Paymá Tayta Diospa Śhuñaynin cayan jinantin nunacunäpa juchanchicta apananpä! ");
INSERT INTO qvwNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paymari: ‘Ipäta śhamüca ya'apïta mas munayniyümi; manalä näsiptïpis pay'a cayälañamari’ nipäcuśhacca. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Rasunpa ya'a manalä lisilpis, Israel caśhtacuna lisilpunanpämi yacuwan bawtisanä cala” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nishanpïtam: “Quiquïmi licalá Diospa Chuya Ispiritun janay pachäpi palumanuy ji'alpalcamul paypa jananćhu quïdacuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Manam ya'apis pay caśhanta lisilächu. Yacuwan bawtisanäpä nimäcämi ichá: ‘Chuya Ispiritu uyaypa mayanmanpis ji'alpamul caśhancämi Chuya Ispirituwan bawtisäca can'a’ nimäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chaymi canan ñawïwan lical Tayta Diospa Chulin rasunpa caśhanta yaćhayá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chay walantinpis yapa chayćhümi Juan cayalcäla ishcay yaćhapacünincunawan. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chayninpa Jesus pasayaptinmi Juan licälul: “¡Licapäcuy, licapäcuy! ¡Diospa uwishninmá!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chay nïta uyalïlälilmi ishcay yaćhapacünincuna, Jesusta aticuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesusñatacmi muyulcamul atipäcuśhanta licälul “¿Imactam munapäcunqui?” nin. Niptinmi: “¿Yaćhachicü taytay, mayćhütan yaćhanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Niptinmi: “Lishun-ari licapäcunayquipä” nilcul puśhala. Chay licapäcuśhanćhümi inti patacña cacuyaptin Jesuswan chayćhu quïdaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chay Juanta uyalil ishcaynin aticäpïmi Simon Pedrop śhullcan Andres jucnin cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andresñatacmi mayurnin Simonman pasacun. Talilculmi: “Diospa Caćhamuśhan Salbacücätam talïlälimú” nin. (Cay griego limayćhu'a “Cristo” nipäcunmi.) ");
INSERT INTO qvwNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nilculmi Jesusman puśhacun. Jesusñatacmi Simonta licälul: “Jonaspa chulin Simonmi am canqui. Cananpi'a Cefasñam śhutiqui can'a” nin. (Cefas'a griego limayćhu'a “Pedro” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chay walantin Galilea-läducta Jesus lishä niyaptinmi Felipiwan tincülul: “Acuchun, lishun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Cay Felipipis chaynütac Andreswan, Pedropis Betsaida malcayümi capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Cay Felipim Natanaelta talilcul: “Moisespa camachicuyninćhüpis, Diospa willacünincunapis willaculcäśhan nunätam talïlälí. Pay Josëpa chulin Nazaret-lädu Jesusmi cañä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Niptinmi Natanael: “¡Imaytá ampá chay Nazaret malcapïlä allin yalämunman!” nin. Felipiñatacmi: “Manpis, quiquiqui ñawiquiwan licämunayquipä lishun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chaynu ji'aycuyalcaptinmi Natanaelta licalcul Jesus nin: “Cay śhamücá sumä Israel caśhtalämi; payćhu'a casquicuycunacta manam talinchicchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Niptinmi Natanael: “¿Imanuypatan lisimanqui imanuy caśhätapis?” nin. Niptinmi: “Manaläpis Felipe willaycuyäśhuptiquilämi, ïgus jaćhap llantuyninćhu cayäśhayquita licalacña” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Niptinmi: “Yaćhachicü taytáy ¡Diospa Chulinmi am canqui! ¡Israelcunap puydï mandäninchicmá rasunpa canqui!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Niptinmi: “ ‘¿Ïgus jaćhap llantuyninćhu cayaptiquim lisilac’ nillaptïchun chalapacayämanquiman? Cayllapïtá sumä jatun lulaycunactalämi licaycunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nilculmi: “Rasunpam, janay pachaca quićhalayaptin Diospa caćha anjilnincuna cutiticlaylla Rasun Nunap Chulincäman śhayämüta licapämanqui” nilatac. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chay quimsa muyunpïtam Galileap Caná malcanćhu juc casaracuy cala. Chaymanmi Jesuspa maman ayachisha cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chaynütacmi Jesuspis llapa yaćhapacünincunapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chayćhu bïnu pishïluptinmi Jesuspa maman payta: “Bïnum lluy pishïlun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Niptinmi: “Mamay chay ya'anchictá ¿imam ucamanchic? Manalämi ürá ćhämunlächu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nilcuptinmi bïnu muyuchïcunäta: “Pay nishanta imactapis lulaycäliy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chayćhüñatacmi paycunap custumrinmannuy Diospa chuyanchaculcänanpä süta jatućhaćhä lumipïta luläśha yacu winacucuna cala. (Chaycunam pusä ćhuncapïta aśhta paćhac litru yacu yaycü-cama cala.) ");
INSERT INTO qvwNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesusñatacmi chay bïnu muyuchïcunäta: “Cay winacücunaman yacucta winapäcuy” nila. Niptinmi llapanman juntay-juntay-camacta winapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jinäluptinmi: “Canan ćhacalcul apapäcuy dispinsïräman” niptin apapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chaymi pay mallilcuptin ¡yacuca rasunpa bïnüman muyüñä! Ñatac maypi apamuśha caśhantapis mana yaćhayaptinpis chay apamücunacá yaćhapäculam. Chaymi dispinsïraca casaracücäta ayaycul: ");
INSERT INTO qvwNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Lluy nunapis allinnin bïnuctam puntacta upäcun; umachäśhaña cayalcaptinñari juccunäta julapämun. Chaynu cayaptinpis ¡añalláw, caynu allinnintalämá ipa-ipapa am'a ćhulañanquipis!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cay wamä milagructa Galileap Caná malcanćhümi Jesus lulala. Cay jatun lulayninpa sumä cayninta tantiachicuptinmi, yaćhapacünincuna chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaypïtam Jesus, mamanwan, śhullcancunawan, yaćhapacünincuna Capernaum malcaman liculcäla. Chayćhümi ishcay quimsa muyuncunanülla caycälila. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ñatac Israelcunaca Egiptopi Libraculcäśhan Fistaca ji'acaycayämuptinmi Jerusalen malcaman Jesus lila. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chay Diospa chuya wasin patyunman yayculmi imaymana lanticuyäcunacta talïlun: wäcacunacta, uwishcunacta, ulpaycunacta, chaynütac taycapacaycälil illayta cambianacuyäcunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaymi watu-niläpi sumbacta shimpalcul, lluy wäcantinta, uwishnintinta alapacülun. Illay cambiäcunätapis lluy mïsancunacta ticlalcul ticlaculmi illaynincunactapis wichiy-pawälun. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ulpaycuna lanticücunätapis: “¡Caycunacta wicapapäcuy! ¡Cärayqui cañächun taytäpa wasinta caynu läsamannuy muyulächinayquipä!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cayta licalmi yaćhapacünincuna yalpälälila Diospa unay willacünincuna isquirbishanćhu: “Taytäpa wasinpïta sumämi imanacuśhäñapis” nishanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Israelcunañatacmi: “¿Mayanpa caćhaśhatá caynu lulacuyanqui? Rasunpa Diospa pudirnin cayal'a, má, imallactapis licaycälichipämay” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Niptinmi: “Má, cay Diospa chuya wasinta mana caśhanman muyülächiy-ari. Ya'a quimsa muyunllactamá śhalcachimuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Niycüluptinmi: “Cay'a tawa ćhunca sütayu watactalämi ishpichisha cala. ¿Chaychun amlätac quimsa muyunllacta muśhüpi śhalcächinquiman ampá?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ñatac Diospa yaćhananman tincuchiypa Jesus'a quiquinpa aychanpïmi limala. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaypi Jesus wañucuśhanpïta śhalcämuptinñam yaćhapacünincuna yalpälälila caypi limaśhancäta. Jinalmi isquirbishancunämanpis quiquin Jesus limaśhancämanpis chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Chay fistaćhu Jesus milagrucunacta lulaśhanta licapäculmi chay Jerusalenćhu achca nunacuna payman chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Chaynu captinpis nunacuna imanuy caśhantapis tuquicta yaćhalmi paycunaman'a Jesus mana chalapaculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Paytá imanuy nunacunaca caśhantapis manam willaycunanlächu quiquin lluy nunacunäpa śhun'unta tuquicta yaćhayaptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ñatac Nicodemo śhutiyu nuna fariseocunap jucnin puydïninmi Israelcunäćhu cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi tutallanpa Jesusman śhamul nin: “Yaćhachicü taytay, tantiapäcümi yaćhachipämänayquipä Dios caćhamuśhuśhayquita. Paywan mana cayal'a cay sumä jatun lulaśhayquitanu'a manaćh pipis lulaycunmanchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Niptinmi Jesus: “Rasunpa mayanpis muśhüpi mana näsimücá, manam Diospa gubirnunćhu cawsanmanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niptinmi: “¿Imanuypatan caśhan näsichwan awquishña cayal'a? ¿Icha mamanchicpa patanman yapalächun cutilcuchwan?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Niptinmi: “Rasu-rasunpa yacupïtawan Chuya Ispiritupïta mana näsïcá, Diospa gubirnunman manam mayanpis yaycunmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Imapis cäninman-camallam näsichimun: nunapis caśhanmannüllam; Ispiritupis caśhanmannüllatacmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama licapayllaman camaychu ‘Muśhüpïmi näsinayqui’ nishäcällawan'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Chuya Ispiritup lulaynin waywa-yupaymi: waywacá may munaśhanpapis linmi. Suynayninta uyaliptinchicpis, maypi śhamuśhanta nï mayman lishantapis manam licanchicchu. Chaynümi Chuya Ispiritupis lulan muśhü cawsayta uycuśhan nunacunäwan'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niptinmi: “¿Chay'a imanuytá?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Niptïmi: “Israelcunäpa puydï yaćhachicünin cayal-lächun mana tantianquimanpischu. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rasunpa yaćhaśhäta licaśhäta willaptïpis, amcuná manam pasapämanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ñatac cay pachäćhu cäcunällapïta niyaptïpis mana tantiayalchun, janay pachäćhu cäcunäpïta willaptïlä quirimanquiman ampá. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Caycunapi yaćhaycunanpä manam mayanpis janay pachäman ishpilachu, sinu'a ya'a Rasun Nunap Chulincällam. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Ñatac maynümi Moises chunyäninćhu brunsipi culibrayta śhalcachila, chaynümi Rasun Nunap Chulinca śhalcachisha caśhä, ya'aman chalapacamäcunäta wiñay simpri cawsayta uycunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tayta Diosñatacmari jinantin pachäćhu lluy nunacta sumä-sumä cuyal, japallan cuyay chulinta caćhamula payman chalapacücunaca juchanćhu manaña wañunanpä, aśhwanpa wiña-wiñaypä allin cawsaycäćhüña cawsananpämá. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tayta Dios cay pachäman chulinta caćhamula manam nunacunäta cäraycunanpächu, sinu'a chay mana allincäpa maquinpi julunanpämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Chaymi payman chalapacücunaca juchanpi manaña cäraycuśhañachu can'a. Mana chalapacücunämi ichá cäraycüśhaña cayan, Diospa japallan chulinman mana chalapacuśhanpa. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cay rasuncäpamá: juc acchinuypis cay pachäman pay śhamula. Jinaptinpis nunacunaca chay mana allin anla lulaynincunaćhu cayalcäśhanpam tutawyäcallacta ama-pacha nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mayanpis mana allinta luläcunacá chay acchïta ćhïnipalmi chayman mana aśhuycunchu lulaynincuna mana camalaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ñatac rasuncämannuy cawsäcämi ichá, acchïman aśhuycamun, lluy lulaynincuna Diospa munaśhanmannuy caśhan camalaycunanpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaypïtam Jesus yaćhapacünincunawan Judeap muyülïnincunaman lil, chayćhu achcasca muyuncuna bawtisaśhtin capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chaynütacmi Juanpis bawtisayäla Salin malcap achca yacu caśhan Enonćhu. Chaymanmi mana camacaycüña nunacunaca bawtisachicü śhayämula. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Caycuna pasala Bawtisä Juan carsilman manalä wićhaśha cayaptinlämi.) ");
INSERT INTO qvwNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ñatac Bawtisä Juanpa atïnincunam jucnin Israelwan tapunacuyta allacaycälila, Diospa ñawpäninćhu chuya caycunanpä pa'acuypïta. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chaypïtam Juanman ćhaycälil: “Yaćhachicü taytay, chay Jordan mayup chimpanćhu limapämäśhayquipi nunämi bawtisayäñä. ¡Payman'a achca-achcamari licuyalcan!” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Niptinmi Juan: “Janay pachäćhu Tayta Dios unanchaycamäśhanchicmannuymi lluypis awniycunanchic. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amcuna tuquictam yaćhayalcanqui ‘Diospa Caćhamuśhan Salbacücächu manam cayá’ nishäta. Aśhwanpa willacünin puntamücämi cayá. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chaynümi casaracuyćhüpis. Walaśhca limay-masinwan cuscananpämi casaracun. Chaymi amigun licat-licat yanapänanpä cayal ima nishallantapis uyalil sumä cushicun. Chaynümari ya'apis sumä-sumä cushicú pay lulaśhanpïta. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cananpi'a paytam masta-masta allinninpa licapäcun'a; ya'actañatacmi ichá masta-masta mana cäpäña licapämänan. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Chay janay pachäpi śhamücá lluypïpis mas munayniyümi. Cay pachällapi ya'a cayalmá caycunallapïta yaćhaynïpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pay janay pachäpi sumäninca cayalñatacmi ichá licaśhanpïta uyalishanpïta willan. Jinaptinpis manamá mayanpis uyaliculcanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Chaynu captinpis willacuyninta mayanpis ćhasquicücämi ichá, tantiälälin Diospa nishan rasunca caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tayta Diospa caćhamuśhanca quiquin caćhamüninpa limayllanta limayan, paywan Chuya Ispiritu mana camacaycü cayaptinmá. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tayta Dios chulinta cuyalmi lluy imacunactapis maquinman ćhulaycun. ");
INSERT INTO qvwNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chaymi payman chalapacücá wiñay simpri cawsayta ćhasquiycun'a. Mana chalapacücunañatacmi ichá cawsaycäta manaña licaycälin'añachu, Tayta Diospa piñacuyninćhu cayalcal'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chaypuncunaćhu fariseocunaca “Jesus Juanpïta mas mastash bawtisäcuyan. Atïnincunapis mas masläshi cacuyanpis” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Manamá quiquin Jesuschu, sinu'a yaćhapacünincunam bawtisala.) Cay lulaśhancuna fariseocunäman ćhäśhanta yaćhälulñatacmi ");
INSERT INTO qvwNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesus “Galileacta cuticuśhä” nil chay Judeap malcancunapïta yapa pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chayman lipäcunanpäñatacmi, Samariap malcancuna ćhawpinpa pasapäcunan cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chaypa pasalmi Sicar nishan malcaćhu Jacob chulin Josëta ćhacla uśhancäman ji'aycuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chayćhümi “Jacobpa püsun” nishanca cala. Chayman ćhawpi muyunnuy Jesus pishipäśha ćhälul patanćhu jamapayaptinmi ");
INSERT INTO qvwNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","yaćhapacünincunañatac micuy lantï quiquin malcätalä liculcäla. Chayman Samaria-lädu walmi yacu julü ćhämuptinmi Jesus nila: “Mamay, yacullayquita mañacuśhayqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Niptinmi licapayllaman camala Samaria-läducunäwan Israelcunaca mana allinpa apanaculcaptin. Chaymi: “Israel-lä cayal ¿imapïtam Samaria nunacta mañacamanquiman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Niptinmi Jesus: “Sïchuśh Tayta Diospa uycunantawan, yacucta mañacuśhüniquita lisil'a, paytaćh mañacunquiman. Paymi ichá wiñay simpri cawsachï yacucta uycuśhunquiman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Niptinmi: “Taytay, mana imayquipis cayaptin ¿imanuypatan luli-luli püsupi ampá julalcamul chay cawsachï yacuctalä uycämanquiman? ");
INSERT INTO qvwNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Icha ¿cay püsu umäní awquillú Jacobpïta maslächun cälunquiman imatá? ¿Imanuypatá pay quiquin, lluy chulintin uywantin, upyanan püsupïta mas allinnintalä uycämanquiman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Niptinmi: “Caypi upyäcunätá yacunan'a jinallam. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ñatac yacu uśhäta upyäcunätá, manam imaypis yacunan'añachu. Jinaman pucyup ñawinpïnülämi wiñay simpri cawsay yalamun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niptinmi: “Taytay, chayurá chay yacütari uycallämay manaña yacunäśha cay püsuman cutiticlaylla śhayämunäpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Niptinmi: “Wayra wayapayquita puśhaculcul cutimunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Niptinmi: “Manam wayapäyüchu cayá” nin. Niptinmi: “Rasunpa chaytá allintam niyämanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Chay picha wayapawan caśhayquipis canan juc wayapawan uywanacuśhayquipis manam rasunpa wayapayquichu. Chayurá rasuncätam niyämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Niycüluptinmi: “Taytay, Diospa willacüninpisćha cayanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pay cüsacunapi yaćhayal'a, má, ¿imanimanquimá? Samaria-läducunacá awquillücunapïpis cay ulućhümi Diosta alawapäcú. Am Israelcunäñatac ‘Jerusalenćhümi alawänanchic’ niyalcanquiman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Niptinmi: “Uyalimay walmi, manaña cay uluman nï Jerusalenmanpis lillalña, Tayta Diosta alawanayqui timpu ñam jananchicćhüña. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","Payta manam mayćhu alawaycälinantapis ucunchu, sinu'a nunacuna Ispiritullawan rasuncäćhu alawaycälinantam munan. Dios Ispiritu captinmá alawaycunanchicpä Chuya Ispiritunta munanchic. Chaynu alawaycücämá paypa śhun'unpä. Ñatac am Samaria-läducuna mayanta alawapäcuśhayquitapis manam yaćhapäcunquichu. Ya'a Israelcunañatacmi ichá tuquicta yaćhapäcú, ya'acunapi Salbacüca śhayämuptinmá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Niptinmi: “Aw yaćhayämi Diospa Caćhamuśhan Salbacüca śhamunanta. Pay ćhämulćha lluy lluyta willaycamäśhun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Niptinmi: “Limapäśhüniquimá, chay nishayquica cayá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chay niyällaptinmi yaćhapacünincuna ćhälälimula. Jinalmi walmiwan limapäcuśhanta licälälil licapayllaman camälälil nï mayanninpis tapuycälilachu chay walmiwan imapi, nï imapä limaśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chay walmiñatacmi wacuynintapis caćhaycul malcäman pasacun. Ćhayculmi: ");
INSERT INTO qvwNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“¡Śhapämuy! ¡Juc wayapam llapa bïdäta niycäman! ¿Paypisćha Caćhamuśhan Salbacüca?” nil ayaycaćhacuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chaymi llapa nunacunaca Jesus caśhancäman paćhcatityämula. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chay śhamuśhancamam yaćhapacünincunañatac: “Yaćhachicü taytay, micucuycuy-ari” nil nipayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nipäcuptinmi: “Mana lisipäcuśhayqui micuymi micuná cayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Niptinmi yaćhapacünincuna quiquin-pula: “¿Mayanćha apäpamunman micunanpä cala?” ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chaymi Jesus nila: “Micuná Caćhamänïcäpa munayninta camacänäcama lulaymi. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Amcuna ‘Tawa quillalämi cayan cusichayta allaycunapä’ niyalcanquimanchun? Ya'añatacmi niycälic: Talpuśhacunäman ñawiquita má pallalcäliy-ari. Ñam nunacunaca cusichaycuypäña alwäśha cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cusichäcunaca wiñay simpri allincäman nunacunäta pilwaycuptinmi Tayta Dios sumä alli-allintalä uycun'a. ¡Cay maynu sumä cushicuymi talpücunäpapis, cusichäcunäpapis! ");
INSERT INTO qvwNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Chayurá ‘Juctacmi talpucun; jucñatacmi cusichan’ nishanchicnüpis rasunpam caćhapäculac mana lulaculcäśhayquiman. Juccuna ñacaculcäśhallantamá amcuna cusichaycälinqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ñatac Samaria-lädu walmica “Llapan bïdätam niycäman” nishallanpam achca malca-masincuna Jesusman lluy chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chayćhu Jesusman ćhälälimulñatacmi “Taytay ya'acunaćhu quïdaycäliyari” niptin ishcay muyun paycunawan caycälila. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chayćhu quiquin Jesuspa shiminta uyalilmi achca-achca chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chaymi chay walmïta nipäcula: “Canan manam willacuśhallayquipñachu chalapaculcá, sinu'a quiquinpa shiminta uyaliycälilmi jinantin nunacunäpa Salbaycüninchic caśhanta yaćhaycälí” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chay ishcay muyunpïtañatacmi Samariapi pasala Galileap malcancunaman. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Ñatac quiquin Jesusmi unay nila: “Diospi willacücuná manamá mayanpis quiquinpa malcanćhu'a allinpa ćhasquishachu” nil.) ");
INSERT INTO qvwNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chaynu captinpis Jerusalenćhu Jesus jatun munayninwan chay Libraculcäśhan Fistaćhu lluy lulaśhanta licapäculmi Galileap malcanman ćhäluptin'a allinpa ćhasquipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chaypïtañatacmi yacupïta, bïnuman muyuchishan Galileap Caná malcanman Jesus cutila. Ñatac Capernaum malcäćhümi sumä puydïnin mandacücäta yanapäninpa chulin ishyayäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cay ishyapacüca Judeapi Galileaman Jesus ćhämuśha caśhanta uyalïlul-pacham tincuycü pasacun. Chayćhümi “Taytay, chulillämi wañucalpuyällanña. ¡Ama chaynu callaychu! ¡Lilläśhun sänaycachipamänayquipä!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Niptinmi Jesus: “Amcuna jatun tantiachicuycunacta milagrucunacta lulaśhäta mana licapäcul'a manam chalapacamanquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Niptinmi: “Taytay, manaläpis chulillá wañuśhancama lilläśhun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Niptinmi: “Cutiy jinalla. Chuliqui allinpacuyanñam” nin. Niptinmi Jesuspa nishanman chalapacul cuticun. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ñatac manaläpis wasinta ćhaycuyaptinlämi, uyway nunancuna talipapämula: “Chuliqui allinyayanñam” niycälï. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Niptinmi talipäcunäta: “¿Imayüram sintïmullan?” nicuyan. Niptinmi: “Anyan ćhawpi muyunpïñam calur ishyayca caćhaycülunña” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Niptinmi yalpaćhacüla anyan muyuncäćhu chayüranuy Jesus: “Chuliqui allinyayanñam” nishancäta. Chaymi lluy wasintin Jesusman chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chayurá cay Judeapi Galileaman cutiyninwan'a ishcay milagructam Jesus lulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaypïtam Jerusalenćhu Israelcunap fistaman Jesus lila. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chay Jerusalenpa “Uwishcunap Puncun” nipäcuśhan sawanpa läduscanćhümi Israel limayćhu'a Betesda nipäcuśhan istanqui cala. Cay'a jatu-jatun mućhcanuy muyülïninćhu picha ramädayümi cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chayćhümi achca aplacuna, walla maquicuna, latacuna, pasaypi ćhänacäśhacunapis yacuca cuyulinanta alcayalcäla. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chay yacuman anjilshi unaypi unaypi ji'alpaycamul sumä-sumä cuyuchila. Chayman puntacta paćhcalpücäshi, imawan ishyayalpis sänaśha cala.˼ ");
INSERT INTO qvwNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chay ishyäcunäćhümi quimsa ćhunca pusäniyu wata ishyayä nuna jitalayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chayta licälul, chay-chica wataña ishyayäśhanta Jesus tantialmi: “¿Sänayta munanquichun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Niptinmi: “Taytay, manam pïlläpis canchu cuyuchishan üra yacuman apaycamäní. Jućhuycaćhacuśhäcamam juccuná apuraypa llallilläman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Niptinmi: “¡Śhalcuy-ari! Wantumuśhuśhayquita apaculcul licuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chayüralla sänälulmi wantumuśhanta apaculcul licun. Ñatac warda muyun captinñatacmi ");
INSERT INTO qvwNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","waquin puydï Israelcuna sänäśha nunäta: “¡Caynu warda muyunćhu camachicuy mana pirmitiyächimaptinchicchun puliyanquimanlä ipicuśha!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Niptinmi “Sänachimäcämi, ‘Wantumuśhuśhayquita apaculcul licuy’ nimäla” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Niptinmi: “¿Mayan nunatan chaynu niyäśhunayquipä?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ñatac chay achca-achca nunacunäpi Jesus licuptinmi mana mayan sänachishantapis yaćhalachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaypïtam Diospa chuya wasinćhu sänachishan nunäta Jesus talïlun. Chayćhümi: “Canan sänaśhaña cayal'a amam juchacta lulanquiñachu mas piyurlä mana pasaśhunayquipä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chaypïtam chay nuna Israelcunäman lil, sänachishanca Jesus caśhanta willaycamula. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chayurá caynu warda muyunćhu sänachishan-laycum puydï Israelcunaca Jesusta aticaćhala. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesusñatacmi: “Taytá canancamapis jinalla lulaycuyaptin'a ¿imapïtatá ya'apis mana lulämanchu?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nïluptinmi, Israelcunaca wañuchiyta sumä-sumä munapapäcula. Manam warda muyuncäta jalutacuśhallanpïchu, sinu'a Diosta Taytanpälä ćhulaycul Diostucuśhanpam. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chaymi Jesus: “Rasunpa, quiquilläpa munayllätá ya'a Chulin manam lulämanchu, sinu'a Taytäpa licaśha lluy lulaynincunallactam canan ya'apis lulaycuyá. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","“Taytá cuyamalmi lluy lulaynincunacta yaćhaycachiman. Jinaman'a mas sumätalä yaćhaycachimäśhanta licalmi amcuna licapayllaman camapäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maynümi Taytá wañuśhacunacta śhalcalcachimul cawsayta uycun, chaynümi ya'a Chulinpis munaśhäcunäman'a cawsayta uycú. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chaynütacmi Taytá pictapis mana cäraycun'achu, aśhwanpa ya'a Chulin captïmi lluy cäraycunäpäpis maquïman ćhulaycaman. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Caynu lulaycula Taytäta licapäcuśhannuy Chulintapis licaycälimänanpämi. Sïchuśh caćhamuśhan Chulinta mana allinpa licaycamäcá, caćhamäní Taytätapis mana allinpatacmi licayan. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sumäta uyalipämay: shimïta uyalicul caćhamänïman chalapacücá wiñay simpri cawsayniyüñam cayan. Manañaćh mućhuycäćhu can'añachu. Aśhwanpam wañuycäpi cawsayman juluycuśhaña cayan. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rasunpa, Diospa caćhamuśhan ya'a Chulinpa shimïta wañüśhacuna uyalipäcunan muyunca jananchicćhüñam cayan. Chayćhümari uyalicücunaca cawsapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Maynümi taytäpa munayllanćhu cawsayca cayan, chaynümi ya'a Chulinpa munaylläćhüpis cawsayca cananpä uycamäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chaynütac Rasun Nunap Chulinca captïmi Taytá maquïman cäraycunäpäpis ćhulaycamäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Caycunapi ama licapayllaman camapäcuychu: llapa wañüśhacuna shimïta uyalil śhalcapämunan muyunca ćhämun'añam. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chayćhümi allin luläcunacá wiñay cawsaypä śhalcamun'a; mana allincäćhu cäcunañatacmi ichá cäraycunäpä śhalcamun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Cay'a manam quiquilläpïtachu, sinu'a Taytá nimäśhanmannümi licaycú. Ñatac munaynïta caćhaycul Taytäpa munayllanta lulayta jicutayaptïmi cäraycuyni'a cäninmancamalla. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Quiquilläpi willacuyapti'a, manam chay willacuyní rasun bälinmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Juc ya'apïta willacü nishancämi ichá rasunpa bälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Quiquiquicuna Juanman tapuchï caćhapäcuptiqui, rasuncätam willapäcuśhulanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Pay rasuncäta tantiaycälichishunayquipä acchiycamuptin sumä cushisha rätullapämi ćhasquiycälilanqui. Ñatac manam nunacunällap niycunallantá munächu. Caycunactam ichá niyalcac salbaycälisha caycälinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Rasunpa Juanpïpis sumäninlämi pï caśhäta willacücá: Taytá lulalpunäpä quiquin umäśhanta lulaśhäcunämi Taytá caćhamäśhanta willacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jinaman quiquin caćhamäní Taytäpis ya'api willacula. Amcunañatacmi ichá shiminta mana uyaliculcälanquichu, nï imanuy caśhantapis licapäculanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ñatac uyaypa willacuynincunamanpis mana chalapaculcäśhayqui cayan caćhamüninta mana ćhasquipäcuśhayquipam. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wiñay cawsayta talinayquipä isquirbishacunacta maynüñam ancuyalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ñatac chaycuna ya'apïta willacuyaptinpis manamá ya'aman śhapämunquichu wiñay cawsayta ćhasquipäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Manam nunacunaca alawaycälimänantachu ashiyá. Chay'a manamá imapis ucamanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ya'a lisipäcucmá Tayta Diosta mana cuyapäcuśhayquita. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Chaymari canan Taytäpi camalachishtin śhamuptïpis manatac ćhasquipämanquichu. Ñatac juc quiquillanpi alawacuśhtin śhamuptinñatacmi ichá cushishalä ćhasquïlälinquimanpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Dioswan licachicuyta mana imactapis ucul, quiquillayqui-pula allinpa licachicuypi wañupacuyalcal'a, ¿imanuypatan payman chalapaculcanquiman? ");
INSERT INTO qvwNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ñatac Taytäpa ñawpäninćhu ‘Payćha juchachaycamäśhun’ nil niyalcämaychu. Chayćhu quiquin alcaycälishayqui Moisesmá juchachaycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sïchuśh payman rasunpa chalapaculcal'a ya'amanpis chalapacalcämanquimanćha, pay ya'apïta isquirbiyaptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ñatac pay isquirbishanmanpis mana chalapacuyalcal-lächun willacuynïman chalapacälälinquiman ampá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chaypïtam chay Galilea ućhap chimpanman barcuwan licula. (Chay ućhacta Tiberiaspa nipäculatacmi.) ");
INSERT INTO qvwNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ñatac Jesus sumä ishyäcunacta sänachishanta licalmi achca-achca nunacuna atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesusñatacmi yaćhapacünincunawan uluman ishpil, chayćhu taycacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ñatac Libraculcäśhan Fista ji'acaycayämulañam. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chayman achca-achca nunacuna ishpilcämuśhanta Jesus licalculmi, Felipicta nin: “¿Paycunapä maypïćha micuyta lantishun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Caynu nila Felipicta yaćhapänan-laycullam. Pay'a imanuypa camachinanpäpis yaćhalañam. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Niptinmi Felipe: “Juc nunap ishcay paćhac (200) muyun trabajunpis manaćh camanmanchu uchuyllanca uycunapäpis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ñatac Simon Pedrop śhullcan Andres yaćhapacüninñatacmi: ");
INSERT INTO qvwNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Cayćhu juc walaśhmi picha siwa tantactawan, ishcay challwacta uywayan. Ñatac chayllá ¿cay-chica nunapá imanpäpis ampá canmanchu?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ñatac chay capäcuśhancäćhu tuqui pastulla cayaptinmi Jesus yaćhapacünincunacta: “Lluyta taycachipäcuy” nin. Chayćhu picha walanganuy wayapanllanlämi caculapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesusñatacmi chay tantätawan challwäta apticulcul Diosta sulpayta ucula. Jinalculmi yaćhapacünincunacta uycula aypupämunanpä. Chayćhu lluypis munaśhancamam aypuchiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ñä maćhacaycäliptinñam Jesus yaćhapacünincunacta: “Yan'almi puchünincuna usuycaćhacunman; lluyta juntupämuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Niptinmi chay ishcay tantällapi puchüninta juntülälin, ćhunca ishcayniyu canaśhta juntactalä. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chaynu Jesus lulaśhanta nunacuna licälälilmi: “¡Cayćhá Diospa Willacünin Śhamüca cacuyan!” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesusñatacmi mandacünin cananpä firsapi ćhulay munapäcuśhanta tantiaculcul uluman japallan yapa licula. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñä aspilpuyaptinñam Jesuspa yaćhapacünincuna ućhäman ji'alpapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tutalpüśha cayaptinpis Jesus'a manalä cutimuptinmari juc barcuman ishpicalcälil Capernaum-läduman chimpapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chaynu liyalcaptinñatacmi alli-alli waywa talcämul yacüta altu-altuman manchanaśhpa mächicächicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ñä picha kilumitructanüña barcuwan liyalcalmi Jesus yacu jananpa pulishtin paycunaman śhayämüta licälälil sumä chucchucuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesusñatacmi: “¡Ya'amari cayá! ¡Ama manchacalcämaychu!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chaymi barcuman cushisha ishpilcayächimullaptin lipäcuśhanman juclla ćhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Chay walantinmi ućhap manyanćhu quïdä nunacunaca tantiälälin Jesuspis nï yaćhapacünincunapis mana chayćhu capäcuśhanta. Chaymi yalpälälin jucllay barcu caśhancällawan yaćhapacünincunalla Jesusta caćhaycul liculcäśhanta. Ñatac Tiberias malcapi barcucuna ćhälälimun Jesus tantacta camachishancascaman. Chaymi chay barcucunäman ishpicalcälil Capernaum malcaman Jesusta ashï liculcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chay ućhap chimpanćhu Jesusta talïlälilmi: “Yaćhachicü taytay ¿imanuypam cayman ćhämulanqui?” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Niptinmi: “Rasunpa, manam ashiyalcämanqui siñalcunäta licalchu, sinu'a maćhaycälinayquicama micapäcuśhayquipam. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama-ari ashipäcuychu camacä micuycätá, aśhwanpa mana camacä wiñay simpri cawsachï micuycätari. Caytam Tayta Dios śhuñacuśhan Rasun Nunaca upäcuśhayqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Israelcunañatacmi: “¿Ima lulapäcunätatan Tayta Dios munan?” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Niptinmi Jesus: “Caćhamuśhancäman chalapaculcänayquitamari” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Niptinmi: “Nishayquica rasunpa caśhanta tantianäpä ¿ima milagructamá lulaycunquiman? ");
INSERT INTO qvwNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay awquillunchiccunapis chunyäninćhu cayalcal Maná nishan tantactam micapäcula, Moisespa isquirbishanmannuy: ‘Janay pachäpi tantactalämi micaycachila’ nil. Má, ¿am'a?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Niptinmi Jesus: “Rasunpa manam Moiseschu janay pacha tantäta ula sinu'a quiquin Taytämi janay pacha rasun tantäta uycücá. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chay Tayta Dios tanta uśhancá jinantin nunacunäta cawsayta uycunanpä janay pachäpi śhamücämi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niptinmi nipäcula: “Taytay, chay tantätari mana pishiycachillal imaypis uycälimay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesusñatacmi: “Chay cawsachicü tantaca ya'am cayá. Chaymi ya'aman chalapacamäcätá mana imaypis micanan'achu, nïtac imaypis yacunan'achu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amcunam ichá, nishac-yupaypis, licayalcämalpis mana chalapacalcämanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Chaynu captinpis, Taytäpa umäśhancunämi ya'aman lluy śhapämun'a. Ñatac paycunacta manam imaypis alapacuśhächu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ñatac janay pachäpi quiquilläpa munaśhalläta lulanäpächu manam śhamulá, sinu'a caćhamänïpa munayninta lulämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Caćhamänïpa munaynin caymi: lluy umäśhancäta mana chincaycachillal muyuncunap camacaynincäćhu lluyta śhalcachimunämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Caypis Taytäpa munayninmi: chulinta lluypis uyalil chalapaculcaptin wiñay cawsayniyu caycälinanmi. Paycunactá unanchaycuśha muyuncäćhümi śhalcachimuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chaynu “Ya'am cayá janay pachäpi śhamü rasun tantaca” nïluptinmi chayćhu cä Israelcuna jamuyäcuyalcan: ");
INSERT INTO qvwNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Cay Jesus Josëpa chulillan caśhanta ¿manachun lisinchic, imamá? Mamantapis, taytantapis lluymi lisinchic. ¿Imanuypatá canan ‘janay pachapïmi śhamulá’ niyämachwanlä canpis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ninacuyalcaptinmi Jesus: “Ama jamuyayalcaychu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ya'aman manam mayanpis śhamunmanchu caćhamäní Taytá mana puśhaycamuptin'a. Paycunactañatacmi unanchaycuśhan muyuncäćhu quiquí lluy śhalcachishä. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Diospa willacünincunap isquirbishanćhüpis ‘Tayta Diosninchicmi yaćhaycachin'a lluy nunacta’ niyanmi. Sumäpa taytäta uyalil tuquicta lisïcunämi ya'aman śhamun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ya'allamari quiquinpi śhamuśha cayal taytäta lisiycú; manam juc mayanllapis licäca canchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rasunpa chalapacücämi wiñay cawsayta ćhasquiycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Ya'am cawsay tantaca cayá. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ñatac awquillunchiccuna chay chunyäninćhu Maná nishan tantacta micuyalcalpis lluymi wañuculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ya'añatacmi ichá limapayalcac janay pachäpi śhamü tantapi. Chayta micücá manam imaypis wañun'achu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Chay janay pachäpi śhamü cawsachicü tantacá ya'am cayá. Cay tantacta micücunacá wiñay simpripämi cawsan'a. Chay uycuná tantaca quiquïpa aychämi. Jinantin nunacunaca cawsanan-laycumari uycuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Niptinmi Israelcunaca quiquin-pula “¿Imanuypatá aychanta micächimachwan?” ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chaymi Jesus: “Rasunpa ya'a Nunap Chulincäpa aychäta mana micapäcul'a, yawarnïta mana upyapäcul'a, manam wiñay simpri cawsayniyüchu capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chayurá ya'ap aychäta micücá yawarnïta upyäcá wiñay cawsayćhümi cawsan'a. Quiquïtacmi unanchaycuśhá muyuncäćhüpis śhalcachimuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chaymi cay aychá rasun micuyca. Chaynütacmi yawarnïpis rasun upyayca. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mayanpis aychäta micücá, yawarnïta upyäcá ya'aćhüñam cayan. Ya'apis payćhütacmi cayá. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Maynümi caćhamäní cawsä Taytäpa cawsayninwan ya'a cawsayá, chaynümi ya'api micücunäpis ya'api cawsan'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya'am janay pachäpi śhamü tantaca cayá. Chaymi cay tantapïta micücunacá wiñay simpripä cawsan'a. Manam chay awquillunchiccuna Maná tantacta micuyalcalpis wañuśhannüchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Caycunactam Capernaumpa juntunaculcänan wasinćhu Jesus yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Caynu yaćhachishanta uyalïlälilmi atïcunäpi śhun'ullanćhu achca “Cay'a anchap sasam. ¿Pitá caycunacta tantianman?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesusñatacmi jamuyapäcuśhanta tantial: “¿Cay nishäca jucmanyalächishunquichun? ");
INSERT INTO qvwNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Imanipäcunquimantá Rasun Nunap Chulinca caśhan cutilcuyäta licapämal'a? ");
INSERT INTO qvwNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Cawsayta uycücá Tayta Diospa Ispiritunmi; ñatac aychallap munaynin'a manam imactapis ucunchu. Chaynütacmi cay limaśhäcunacá cawsä ispirituctawan wiñay simpri cawsayta uycun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Chayćhu Jesus mayan mana chalapaculcäśhantapis, mayan ipanchanantapis yaćhalmi: “Waquinniquicuna manalämi chalapaculcanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nishac-yupaypis quiquin Taytá mana puśhapämuśhuptiqui'a manam śhapämunquimanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chaypunpïmi achca atïnincuna caćhaycälälil manaña atipäculañachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jinaptinmi Jesus ćhunca ishcayniyu yaćhapacünincunacta: “¿Amcunapis liculcaytachun munayalcanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Niptinmi Simon Pedro: “¿Taytay, pimanćhá lipäcüman? Yaćhayalcäñam yaćhachicuyniqui wiñay cawsaypä caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cawsä Diospa Chuya chulinca, Caćhamuśhan Salbacüca caśhayquita rasunpa yaćhayalmari chalapaculcac” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesusñatacmi: “Ćhunca ishcayniquita quiquïmi aclaculac. Jinaptïpis jucniqui'a supaymá cayanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chaynüta nila Simonpa chulin Judas Iscariotipïmi. Paymi ćhunca ishcayniyu yaćhapacünin cayalpis Jesuspa ćhïnipänincunap maquinman ćhulaycunan cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaypïtam Jesus chay Judea malcäćhu Israelcunaca wañuchiyta munapäcuptin, chayman mana ćhaycul Galileap malcancunallaćhu pulila. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ñatac Israelcuna Chucllallaćhu Alawana Fista ćhayämulañam. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chaymi Jesuspa śhullcancuna nipäcula: “Má, Judea malcäman liy-ari chayćhu yaćhapacüniquicunapis lulaśhayquicunacta licapäcuśhunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Manamá pipis camalachicuyta munäcá pacallap lulaycaćhayanmanchu. Caynu lulätucuyalñá, jinantin nunacunap ñawpäninćhu-ari, má, camalachicuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chayćhu chay śhullcancunapis manam chalapaculcälachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","7","Chaymi Jesus: “Amcunapá imayürapis nunacunaćhu licachicunayquipä allinmari cay pachäćhu nunacunaca mana ćhïniyalcäśhuptiqui'a; ya'apäñatacmi ichá chaypä manalä üra ćhämunlächu. Chay mana allin lulayninta licachiptïmari paycuna ya'acta ćhïnipapäman. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Chay fistaman liyta munal'a lipäcuy-ari. Ya'apá manalämi üra ćhämunlächu linäpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chayta nilculmi Galilea-lädućhu capaycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chay śhullcancuna fistaman Jerusalenta licuyalcaptinmi, Jesuspis lila mana uyaypälächu, sinu'a pacallapam. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chay fistaćhu Israelcunäñatacmi “¿Mayćhütan chay nunaca cayan?” nil ashipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chayćhümi Jesuspïta limay cacula. Achcam: “Pay'a allin nunam” nipäcula. Waquinnincunañatacmi pacallapnu: “Chay'a llapa nunactam ingañayan” nil ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Chaynu mayanpis mana uyaypa limalcälilachu Israelcunap puydïninta manchacuyninwanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chay fista ćhawpichayaptinñam Diospa chuya wasinman yaycuycul Jesus yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chayćhümi Israelcunap llapa puydïninpis lluy nunacunäpis licapayllaman camälälila “¿Imanuypatá mana istudiuyu cayal sumä yaćhayniyu cacuyanman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Niptinmi Jesus nila: “Ya'a manam quiquïpïtachu yaćhayalcächic, sinu'a caćhamänïpa yaćhachicuynintam. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mayanpis Tayta Dios munaśhantanuy lulay munäcunacá tantiaycunmanmi paypi yaćhachishäta, ütac tantiaylläpi yaćhachishätapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Quiquillanpi tantialcul yaćhachïcunacá nunacunäwan alawachicuycunallactam ashipäcun. Ñatac caćhamänïpa alawaycuśha cananpä ashïcämi ichá rasuncäta liman. Chaymi pï imaniycunanpis mana canchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Amcunacta Moisesmi camachicuyta upäcuśhulanqui Diospa munayninmannuy cawsaycälinayquipä. Jinaptinpis ya'acta wañuchimayta munapäcuyniquiwanmi mana mayanllayquipis cäsuculcanquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Niptinmi nunacunaca: “¿Achatup lücuchishachun cayanqui imatá? ¿Mayantan amta wañuchiyta munayäśhunqui?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Niptinmi: “Warda muyuncäćhu milagructa lulaycüluptïchun nicayalcämanquiman. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","¿Manachun amcuna warda muyunman ćhäluptinpis umri cayninćhu siñalachipäcunqui Moises nishanmannuy? (Ñatac manamá paychu nila, sinu'a unay awquilluyquicunalämari.) ");
INSERT INTO qvwNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jinayalcanqui warda muyunman siñalachinayqui ćhäluptinpis camachicuyca mana jalutacüśha cananpämi. ¿Chaychun warda muyuncäćhu ishyä nunacta tuqui nunaman muyuyächiptí piñäśha cacuyalcanquiman? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Janallanta licalcullal'a ama niyalcaychu. Sinu'a rasun caśhanmannuy sumäpa licaycälil niycunayquim” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ñatac chay Jerusalenćhu waquin yaćhäcunämi ninaculcan: “¿Wañuchinanpä ashishan nunachućh cayćhu cayäñä? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Lluy nunap ñawpäninćhu yaćhayächiptinpis, maytá pipis imactapis niyanchu! ¿Puydïninchiccuna ‘Caćhamuśhan Salbacüninchicmi’ niyalcanpisćhá? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ñatac caytá lisinchicmi maypi śhamuśhantapis. Chay Salbacücätam ichá maypi śhamunantapis mana yaćhaśhunchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jinaptinmi Jesus chuya wasin yaćhachishancäćhu callpawan: “Chayurá amcuna yaćhacuyalcanquichun pï caśhätapis, maypi śhamuśhätapis. Ñatac ya'a manam quiquilläpïchu śhamulá, sinu'a sumä chalapacuna cäcäpa caćhaśham. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amcuna manam lisipäcunquichu; ya'añatacmi ichá, paypi śhamul, paypa caćhaśha cayal tuquicta lisí” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niptin wićhachiyta munapäculpis, üran manalä ćhämuptinmi mana mayanllanpis chalayta atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Waquinnincunañatacmi ichá chalapaculcal: “Salbacüninchic śhamulpis ¿caypïta mastá lulayanmanchun ampá?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chay nipäcuśhantam fariseocunaca uyalïlälin. Chaymi puydï sasirdüticunäwan limanacalcälil Diospa chuya wasinpa täpänincunacta Jesusta chalachimunanpä caćhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chaymi Jesus nila: “Amcunawan ash muyuncunallam caycuśhä. Chaypïta cuticuśhä caśhan caćhamänïmanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chayćhu maynu ashipämalpis manam talipämanquichu. Chay caśhäcäman'a manam ćhäpämunquimanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Niptinmi llapa Israelcunaca quiquin-pula: “Mana talinanchicpä ¿maytaćh cay pinsayan liyta? ¿Icha calu-calućhu chi'isha malca-masinchiccunaman lilchun mana-Israelcunäta yaćhachin'a, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Imacäta pinsaltan cay niyämanchic: ‘Ashilpis manam talimanquichu’ ñatac ‘Ya'a caśhäcäman'a manam ćhäpämunquimanchu’ niyanman” nil nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chay fistap camacalpuynin mas puydï muyuncäćhümi Jesus śhalculcul lluy nunacunäta sumäpa nila: “Mayanpis yacunäśha cäcunacá, ya'aman śhapämul upyapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ya'aman chalapacamäcunäpá, isquirbishanćhu nishannüpis cawsachicü yacum śhun'unpïta sumä mayunu lin'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Caynu Jesus nila Chuya Ispiritunta chalapacünincuna ćhasquipäcunanpïtam. Chaypun Jesus wañuśhanpi śhalcalcamul janay pachäman manalä cutiptinmi Chuya Ispiritun nï caćhamuśhalächu cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Waquinnin uyalïcunämi: “Cay nunäćhá Diospa śhamunan Willacüninca” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Juccunañatacmi: “Caćhamunan Salbaycamäninchiccäćha” nipäcula. Waquinnincunañatacmi “¿Galileapïta yalämunman Salbacüca ampá? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diospa shiminćhu ¿manachun: ‘Salbacüca Davidpa milayninpïmi śhamun'a; paypa Belen malcanpïtacmi yalamun'a’ niyan-ari?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chaynu Jesuspïta limayninwanmi ishcayman lluy iwinacälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Chaymi waquinnincuna Jesusta wićhachiyta munapäculpis mayanllanpis mana atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ñatac Diospa chuya wasinpa chay täpänincunam caćhaśhan fariseocunämanwan puydï sasirdüticunaman jinanllan cutipäcula. Jinaptinmi: “¿Maymi? ¿Imanaltan mana puśhapämunquichu?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Niptinmi: “Pay limaśhantanu'a manam imaypis, nï mayanpis limalachu” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Niptinmi fariseocunaca: “¿Ima? ¿Amcunactapis limayninwanchun awnïlächishunqui, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Payman chalapacuyalcanchun jucllay puydïcällapis imamá, nïtac fariseocunäpïpis jucllanchicpis? ");
INSERT INTO qvwNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Chay camachicuyta mana yaćhäcunam, nï Diospäpis mana bälï pasaypi luclucunam!” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ñatac fariseocunäpi Nicodemo puntacta Jesusman tutallap śhamücämi: ");
INSERT INTO qvwNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“¿Manaläpis tuquicta yaćhaycul juchachayänapächun camachicuyca niyämanchic, imatá?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Niptinmi nipäcula: “¿Ampis Galilea-lädu-tucülunquichun, imatá? Camachicuyta sumäta licaycuy Galileapi Diospa willacüninca mana yalamuśhanta yaćhanayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chaypïtam wasinman-cama lluy liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesusñatacmi Ulibus nishan ulüta licula. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chay walantinmi wäla wälalla Diospa chuya wasinman cutimula. Chayćhümi nunacunaca juntunacälälimuptin taycucuycul Jesus yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaymanmi camachicuyta yaćhachicücunäwan fariseocunaca juc walmicta mansibacuyäta talilcälil puśhapämula. Chayćhu lluy nunacunap ñawpäninman śhaycacaycachilmi ");
INSERT INTO qvwNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusta nipäcula: “Yaćhachicü taytay, cay walmictam mansibacuyäta talïlälí. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisespa camachicuyninćhu'a caynuy walmicunacta lumi tamshaypa wañuchinapämi cayan. ¿Am'a imaninquitan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cayta nipäcula Jesuspa limayllan cunca cuchuynin cananpämi. Jesusñatacmi ichá pampäman uyshucalpul dïdunwan allpäćhu isquirbiyäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Chayćhu jinalla tapucuyalcaptinmi Jesus śhalculcul nila: “Mayanniquipis mana juchayücá, má, allaycuchun tamshayta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nilculmi caśhan uyshucalpul pampäćhu dïdunwan isquirbiyäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chaynüta niycüluptinmi puśhamücunaca juchayu capäcuśhanta lluy tantiacalcälil awquishnincunapi allacaycälil jucllap jucllap chincaculcäla. Jinaptinmi Jesuswan chay walmïllaña quïdäläliña. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chayćhümi Jesus śhalculcul tapula: “Walmi, ¿mayćhütan cayalcan? ¿manachun jucllanpis juchachaycälishunqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Niptinmi: “Taytay, manamá mayanllanpis” nin. Niptinmi: “Chayurá ya'apis manam juchachacchu. Jawcallañari licuy. Cananpi'a amañamá juchacta lulanquiñachu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chaypïta achca nunacunäta yapa yaćhachilmi nin: “Cay pachäćhu llapa nunacunäpa acchinmi cayá. Ya'acta atimäcá manañam tutapäcäćhu cawsan'achu, sinu'a sumä cawsayta uycuśha acchićhümi cacun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Niptinmi fariseocunaca: “Ä, canan caynu quiquillayquipi willacuśhayquiwan'a limayniqui manamá bälinchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Niptinmi: “Maypi śhamuśhätapis yaćhayapti'a masqui ya'alla willacuyaptïpis, willacuśhäca rasuncämi. Amcunam ichá mana yaćhapäcunquichu maypi śhamuśhätapis nï mayta linätapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nunacunallap tantiayllanmannümi cäraycälinquipis. Ya'añatacmi ichá mayantapis mana cäraycüchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ñatac cärayculpis caćhamänïwan cayaptïmi tincüninman cäraycuyni'a. Manam japallächu licaycú, sinu'a paywanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Amcunap camachicuyniquićhümi ‘Ishcay nuna willaycü captin'a tacyalpachishañam’ niyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chayurá ya'a quiquïmi jucnin willaycüca cayá; juccäñatacmi caćhamäní Taytá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Niptinmi: “¿Mayćhütan chay taytayqui cayan?” nipäcula. Jesusñatacmi: “Mayan rasunpa caśhätapis mana lisiyämal'a ¿imanuypatan taytätalä lisïlälinquiman? Manamá mayannïtapis lisipämanquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Caycunacta nila Diospa chuya wasinćhu illay apapämunan ćhulacunpa läduscanćhu yaćhayächishanćhümi. Chayćhu manalä üran captinmi mana pipis prïsunanpä chalapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chaypïtam Jesus yapa nila: “Ya'a licuśhäñam; ashiyalcämalpis manam ćhäpämunquimanchu; aśhwanpa juchayquićhu cayalcalmá wañupäcunquipis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Niptinmi Israelcunaca: “ ‘Ya'a caśhäcäman'a manam ćhäpämunquimanchu’ ninanpä ¿‘supay-apäśhä’ nicuyanchun, imamá?” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesusñatacmi nin: “Amcuna cayllapïmi capäcunqui; ya'añatacmi ichá janaypi. Amcuna cay pachällapïmi capäcunqui, ya'añatacmi ichá mana cayllapïchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pï caśhätapis nishacmannuy mana chalapaculcal'a juchayquićhümi wañupäcunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Niptinmi: “Am ¿pï tucunquitan?” nipäcun. Niptinmi: “Allaycuśhäpïta mayan caśhätapis nishäcämari. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jinaman amcunapïtapis sumä achcam limapaycälinac cäraycälinac cayan. Caycuna cay pachächu sumä tincüllanman cayan rasuncällacta niycü caćhamänïpïta uyalishäta willaycuptïmi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ñatac manam tantiapäculachu, taytanpïta limaśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chaymi Jesus nila: “Altuman śhalcachisha captïlämi Nunap Chulinca rasunpa ya'a caśhäta, chaynütac quiquilläpi imactapis mana limal, caćhamäní yaćhachimäśhanmannülla limaśhäta tantiapäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chayurá caćhamäní ya'awanmi cayan. Imaypis paypa munaśhanta lulaptïmi mana japallätachu caćhaycaman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Caynu Jesus niptinmi achca chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chay chalapacü Israelcunätam Jesus: “Amcuna willacuynïćhu masïsu tacyapäcul'a rasunpa yaćhapacünïcunam cayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jinalmi Diospi rasun allincäta lisipäcunqui. Chay rasuncäñatacmi ćhänalächipäcuśhuśhayquipi julapäcuśhunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Niptinmi: “Ya'acuná Abrahampa milayninmi capäcú; imaypis manamá mayanpa uywayllanpis capäculächu. ¿Chaychun ‘Amñatac juluycuśham capäcunqui’ niyalcämanquiman?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Niptinmi Jesus: “Rasunpa mayanpis juchaćhu cawsäcunacá juchap uywayninmi cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Uywayca chay ayllućhu manam pasaypipächu caycun. Ñatac chulinmi ichá pasaypipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chayurá Chulica julaycälishuptiqui'a pasaypipä libriñam capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yaćhämari Abrahampa milaynin capäcuśhayquita. ¿Chaynu cayalcalchun yaćhachicuyní śhun'uyquipänuy mana captin wañuchiyta munayalcämanqui? ");
INSERT INTO qvwNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ñatac quiquin Taytäpa lädunćhu cayal licaśhäcätam ya'a limá; amcunapis taytayqui limapapäcuśhuśhayquitam lulapäcunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Niptinmi nipäcula: “Ya'acunap taytá Abrahammari” nil. Jesusñatacmi: “Abrahampa rasun chulin capäcul'a, paynüćha lulaycälinquiman. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Manaćh wañuchiyta munayalcämanquimanchu quiquin Diospi uyalisha rasun allincäta willaycuyapti'a. Caynüchu Abraham'a manamá lulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amcuná taytayquip lulaynintam lulaycuyalcanqui” nin. Niptinmi paycuna: “Ya'acuna manam ishu chulipacuychu capäcú. Tayta Diosllam ya'acunap taytá” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesusñatacmi: “Rasunpa Dios taytayqui captin'a paypi śhayämupti'a cuyapämanquimanćha. Paypa caćhaśham śhayämüpis, manamá munaylläpïchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Chayurá ¿imapïtan-nila yaćhachicuynïta mana tantiapäcunquimanchu? Mana ćhasquiculcänayquimari. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aśhwanpa amcuná taytayqui Satanaśhpa munaśhanta lulayta jicutayä nunanmi capäcunqui. Pay'a cay pachap allaycuyninpïta nuna wañuchicümi. Manamari imaypis rasun allincäta niyculachu nï cayculapischu. Artishca cayalmi jinaman chay articunap quiquin taytan cayalmi articta limal'a tincüninman liman. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Chaymari ya'a rasun allincäta willaycupti'a mana chalapacalcämanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Má ¿mayanllayqui'a juchayu caśhäta licapämälanquitan? Chayurá rasuncäta yaćhayächiptí ¿imapïtan mana ćhasquiculcanquichu? ");
INSERT INTO qvwNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Rasunpa, Diospa cäcunacá shiminta uyaliculcanmi. Paypa mana capäculmi amcuna mana uyalïtuculcanquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Niptinmi Israelcunaca: “Allintam niyalcac ¡anla Samaria-lädu nuna Satanaśhpa gänaśham canqui!” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Niptinmi Jesus: “Manam Satanaśhpa gänaśhachu cayá. Aśhwanpam Taytäta altuman juluycú; amcunañatacmi ichá pin'ayman julaycälimanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Manamá quiquillächu alawacuyta ashiyá; aśhwanpa jucmi alawaycuśha canäpä ucupacuyan. Pay'a amcunactapis lluyta cäraycücämi cayan. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chaymi rasunpa willacuynïta chalapacücá wañuyta mana lisipäcun'achu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Niptinmi Israelcunaca: “Cananmi ichá Satanaśh gänaśhuśhayquita rasunpa yaćhalpälí. ¡¿Imanuypatan ‘Shimïman chalapacücunacá manam wañuyta lisin'achu’ niyanman, aśhta quiquin Abrahampis Diospa willacünincunapis wañuyalcaptin?! ");
INSERT INTO qvwNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tayta Abrahampïpis mas puydïlächun cayanquiman, imatá? Paypis Diospa willacünincunapis wañuculcälam. ¿Am'a pï tucunquitan?” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Niptinmi Jesus: “Quiquilläpi alawacuptí manam uchucllapis pasanmanchu. Aśhwanpa amcuna ‘Diosnïmi’ nipäcuśhayqui quiquin Taytämi altuman julaycaman. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Niyalcalpis amcunañatacmi ichá mana lisipäcunquichu. Ya'ami ichá tuquicta lisiycú. ‘Manam lisïchu’ nipti'a amcunanüpis casquicüćha cäman. Ya'ami ichá lisiyal shiminmannuy cawsaycú. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ñatac taytayqui Abrahampis cay śhamuná timpucta licaycuypi cushiculam. Chaymi licämal'a sumä-sumälä cushicula” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Niptinmi: “Picha ćhunca watallayquipis mana cayaptin ¡Abrahamta licälunquiman ampá!” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Niptinmi Jesus: “Rasunpa, manaläpis Abraham captinmi ya'a cayäläña” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chaynu nïluptinmi lumicta apticälälin tamshälälinanpä. Jesusñatacmi chay-chica nunacunäpi pantalcachil Diospa chuya wasinpïta licula. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Liyäśhanćhümi nasïdunpi apla nunacta Jesus licälun. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chayćhümi yaćhapacünincuna: “Yaćhachicü taytay, caynu apla näsïmula ¿quiquinpa juchanpïchun icha taytancunap juchanpïchun?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Niptinmi: “Manam quiquinpa nï taytanpa juchanpïchu, sinu'a Diospa munaynin payćhu camalaycunanpämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chaymi caćhamäní lulananchicpä nimäśhancäta wañuy-wañuylla lulaycunanchic muyunca caśhancama. Mayanpis lulayta mana atipänan tutaca ñam ji'acaycayämunña. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ñatac cayćhu caśhäcamá, cay pachäćhu nunacunäpa acchinmi cayá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nilculmi pampäman tuwaycul dïdunwan mitucta lulaycul chay apläpa ñawinta llusiycul nila: ");
INSERT INTO qvwNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Siloé nishan istanquićhu pa'acamuy” nil. (Siloé ninan'a “Caćhaśhanca” ninanmi.) Niptinmi chay apla lilcul pa'acamul licaśhtinña cutïmun. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chaymi malca-masincunapis, mañapacuyäta licäcunäpis: “¿Manachun wicćhu täcuylla täcul mañapacü aplaca?” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquinninmi “Paymari” nipäcula. Juccunañatacmi “Manam. Jucmi paynü-nilälla” nipäcula. Apläñatacmi: “Quiquïmari cayá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Niptinmi tapupäcula: “¿Imanuypatan-nila ñawiqui quićhacacülun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Niptinmi: “Chay Jesus nishan nunam mitucta lulaycul ñawïman llusiycäman. Jinalculmi ‘Siloé istanquiman lil pa'acamuy’ niman. Chayćhu pa'acullal-pacham licälú” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Niptinmi: “¿Mayćhütan chay nunaca cayan?” nipäcula. Niptinmi: “Äli, manam yaćhächu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ñatac Jesus mitucta lulaycul apläpa ñawinta quićhacachishanca warda muyunćhümi cala. Chaymi fariseocunäman chay apla sänäśhäta puśhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ćhächiptinmi tapupäcula imanuypa ñawin quićhacacüśhantapis. Niptinmi: “Mituwan ñawïman llusiycamaptin pa'acullalmi licälú” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chayćhu waquinnin fariseocunämi: “Chay nuna Diospïchu manam canman. ¿Imanuypatá cay lulayninwan warda muyuncäta jalutacuyanman?” nipäcula. Juccunañatacmi: “Jucha-sapa nuna cayal'a, ¿imanuypatá caynücunactalä lulayanman?” nipäcun. Chaymi quiquin-pula iwinacälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chaymi yapa tapucuyalcan: “Am'a ¿imaninquimá, ñawiquita licachishüniqui nunapïta?” nil. Niptinmi: “Diospa willacüninmari” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ñatac fariseocunaca aplapi sänaśha caśhanta manam awnïtuculcälachu, aśhta chay apläpa mamanta taytanta ayachipämunancama. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chaymi mamanta taytanta ayalcachimul: “¿Cay chuliquichun? ¿Rasunpachun nasïdunpi apla? Chayurá ¿canan imanuypatan licälun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Taytancunañatacmi: “Aw, pay'a chulïmi; jina nasïdunpi aplam cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ñatac imanuypa ñawin licaśhantam ichá ya'acunapis mana yaćhapäcüchu nï mayan quićhacachishantapis. Quiquintari tapupäcuy; ñam yayniyüña” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chaynu nipäcula Israelcunap puydïnincunaca mayanpis “Jesus'a Caćhamuśhan Salbacücämi” nil limalcücäta juntunacuynincunapi alapacüśha cananpä limanacüśha captinmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chaymi taytancuna “Quiquinta tapuy; ñam yayniyüña” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaymi aplapi sänäśhäta caśhan ayalcachimul: “Diospa ñawpäninćhu rasuncäta niycälimay. Ya'acunam tuquicta yaćhapäcú chay nunaca jucha-sapa caśhanta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Niptinmi: “Manamari yaćhächu jucha-sapa mana jucha-sapa caśhantapis. Śhun'ućhu yaćhacú aplapïta canan licaśhallätam” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Niptinpis mastam tapupäcula: “¿Imactam luläśhulanqui? ¿Imanuypatan ñawiquita quićhacächishulanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Niptinmi: “Niyalcacñamari; willayaptïpis manatacmi quiripämanquichu. ¿Icha yapa tapupayalcämanqui amcunapis atïnin cayta munapäculchun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Niptinmi fariseocunaca: “¡Ima! ¡Amćhá chay-nilä nunäpa atïnin cayanqui; ya'acuná Moisespa atïninmi capäcú! ");
INSERT INTO qvwNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yaćhanchictacmi quiquin Dios Moiseswan limaśhantapis. Ñatac chay nunäpïtá manam yaćhanchicchu maypi yalämuśha caśhantapis” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Niptinmi aplapi sänäśha nunaca: “¡¿Imanuypatá caynu ñawïtapis licachimä nunactalä maypi śhamuśhantapis yaćhapäcunquimanchu canpis?! ");
INSERT INTO qvwNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tuquictam yaćhanchic Tayta Dios jucha-sapacunäta mana uyalil manchacuywan cäsucünincunallacta uyalishanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manatacmi imaypis uyalilanchicchu nasïdunpi aplacta licächishantá. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Rasunpa Diospi mana śhamul'a manaćh caynüta lulälunmanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chaynu niptinmi: “¡Cärayqui cañächun am juchallaćhu chapunacüśha näsïcälä ya'acunacta yaćhachïtucupämänayquipä!” nicuyalcan. Nilculmi lluy alülälila. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jinaptinmi Jesus yaćhälun chay apla sänäśhanca alüśha caśhanta. Chaymi tincülul: “¿Rasun Nunap Chulinman chalapacunquichun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Niptinmi: “Taytay ¿chay mayantan cayällan? Niycallämay chalapacunäpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Niptinmi: “Licayanquiñamari; anwan limäcämi cayá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Niptinmi puntanman un'ulacuycul: “Aw, chalapacullämi” nil altuman juluycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Niptinmi Jesus: “Cay pachäman śhamulá imanuy nunacuna caśhantapis camalaycachïmi, aplacunäta licaycachï, licätucücunätañatac rasunpa mana licapäcuśhanta tantiaycachï” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Niyta uyalïlälilmi chayćhu cä fariseocunaca: “¿Ima, ya'acunapis aplachun cayalcá imatá?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Niptinmi Jesus: “Aplapa-yupay tantiayniqui cayaptin'a nishayqui pampachaycuśham canman. Ñatac licätucuśhayquipam juchallayquićhülä cayalcanqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Chaypïtam: “Sumäta uyalipämay: mayanpis uwish canćhaman puncunpa mana yaycul juc-lädunpa yaycücá cullu cära suwam. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ñatac quiquin michïcá canćhap puncunpam yaycun. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Paytam puncu quićhäcäpis quićhaycun. Uwishnincunapis uyat-uyatllañam cayalcan. Chaymi ayayllawan canćhanpïta yalachimun. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chaynu lluyta yalalcachimul puntanta ñawpaptinmi uwishcunäñatac shiminta lisipäcul atipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ñatac juc nunactá manam atinchu. Aśhwanpa michïninpa shimin mana caśhanta yaćhalmi buryaylla ayiculcan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Caynu tincuchiywan Jesus yaćhachiptinpis imapi limaśhantapis manam tantiapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chaymi nila: “Rasunpa ya'am uwishcunäpa yaycunan puncuca cayá. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ñatac puntäta śhamücunacá pasaypi suwacunam. Ñatac uwishnïcuná manam cäsupäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sumäta uyalipämay: ya'allam rasun puncuca cayá. Chaymi mayanpis ya'ap yaycücá salbaśha can'a. Jinaptinmi uwish cutiticlaylla llullu pastucunalläćhu jawca puliycänuy capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ñatac suwacá suwacüllam wañuchïllam camacällam śhamun. Ya'añatacmi ichá llapanta sumä-sumä allin jawca mana camacaycü cawsayta unäpä śhamulá. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Chaynütacmi ya'a allin michïca cayá. Allin michïcá uwishnin-laycum bïdantapis uycun. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ñatac michipacücunacá atü śhayämüta licälul'a quiquinpa uwishca mana captinmi lluy caćhaycul ayicun. Jinaptinmi atüca paćhcaycul lluy pintïchin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay nunacá uwishcunäpi mana imapis ucunchu michipacülla calmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ya'am ichá quiquin allin michïca cayá. Maynümi Taytäwan lisinacú, chaynümi uwishnïcunawanpis lisinacú. Chay uwishnï-laycumari bïdätapis uycú. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jinaman cay canćhäćhu mana cä uwishnïcunactapis atimunämi cayan. Paycunapis shimïta uyalipäman'am. Chayćhümi juc canćhallaña juc michïllaña can'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ñatac Taytá cuyaman quiquí cawsaynïta uycul caśhan cawsanäpä captïmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Manam mayanpis bïdäta apaman'achu; quiquilläpïmi uycuśhä. Maquilläćhümari unäpäpis, śhalcamunäpäpis cayan. Caynu lulayní cananpä Taytäpïmi ćhasquiyculá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chayta uyalipäculmi Israelcunaca ishcayman iwinacälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Waquinnincunam nipäcula: “Cay'a Satanaśhpa gänaśha lücuśhäta ¿imapämá uyalipäcunqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Juccunañatacmi: “Satanaśhpa gänäśha cayal'a caynu allin yaćhachicuyta manam limayanmanchu, nï nasïdunpi aplactapis licayächinmanchu” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ñatac Jerusalenćhümi Diospa Wasinta Chuyanchaśhan Yalpanan Fista tamya timpućhu cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chayćhümi chay wasip “Salomonpa Patyun” nishanćhu Jesus puliyäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chaymi Israelcunäpa puydïnincuna cunćhacaycälil: “¿Imaycamatan umäta nanachipämanqui? Dios Caćhamuśhan Salbacüca rasunpa cayal'a, ¡sumätañari niycälimay!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Niptinmi Jesus: “Niyaptïpis amcuna manamá chalapaculcanquichu. Jinaman Taytäpa munayninwan imaymana milagru lulaśhäcunam pï caśhätapis tantialcächishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jinaptinpis ya'ap uwishní mana capäculmi shimïta nï chalapacamanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ñatac ya'a uwishnïcunawan lisinacümi. Chaymi shimïta uyalil atipäman. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Paycunactam mana imaypis chincapäcunanpä wiñay cawsayta uycú. Taytá uycayämaptinmari mana mayanpis maquïpïta ućhiman'achu. Pay lluypïtapis sumä munayniyu cayaptinmi maquinpïta mana mayanpis ućhipäcunmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ya'a Taytäwan jucllamari capäcú” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chayćhümi Israelcunaca lumicta yapa apticälälin Jesusta tamshälälinanpä ");
INSERT INTO qvwNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jinaptinmi: “Taytäpïmi imaymana milagrucunacta amcunaćhu lulalá. ¿Mayanninpïtatá tamshayta munacayalcämanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Niptinmi: “¡Allin lulaśhayquipïchu manamá, sinu'a Tayta Diosta jalutacuśhayquipïtamari! ¡Am nunalla cayal Diostucuśhayquipïtamá!” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesusñatacmi: “Quiquin Diosninchic isquirbishancäćhümi ‘Amcuna dioscunam capäcunqui’ nunacunallacta nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Yaćhaśhanchicnüpis camachicuy rasunca cayal'a, manam articunchu. Chayurá chaynu nunacunäman shiminta uycuśhancunällacta ‘dioscuna’ niyal'a, maynülämi cay pachäman quiquin Śhuñaycuśhan Caćhamuśhancätá ninmanpis. Chayurá ‘Paypa chulinmi cá’ nishalläpi ¿imapïtan-nila Tayta Diosta jalutacüpa licapämanqui? ");
INSERT INTO qvwNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taytá nimäśhancunacta mana lulapti'a ama chalapacalcämaychu. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nimäśhanta lulaptïñatacmi ichá, masqui ya'acta mana ćhasquipämalpis lulaśhäcäman-ari chalapaculcay Tayta Dios ya'aćhu caśhanta, chaynütac ya'apis Taytäćhu caśhäta tantiapäcunayquipä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chaymi yapa wićhachinanpä chalayta munacuyalcaptin chaypi chincacula. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chaypïmi Jordan mayüćhu Bawtisä Juan unay bawtisaśhancäman Jesus yapa chimpala chayćhu caycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Chayman achca nunacuna licä lïcunämi: “Bawtisä Juan masqui ima milagructa mana lulayalpis, śhamü nunapi willamäśhanchiccänüllamá rasunpa canan pasacuyan” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chayćhüñatacmi Jesusman achca chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ñatac Betania malcayu Martapwan Mariap tulin Lazarom chayćhu ishyayäña. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Cay Lazarop panin Mariam pirfümiwan Jesuspa ćhaquinman jillpuycul ächanwan chaquichïca cala.) ");
INSERT INTO qvwNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chaymi Lazarop panincuna Jesusman caćhapäcula: “Taytay, cuyaśhayqui Lazarom pasaypiña ishyayällan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cayta Jesus uyalïlulmi: “Chay ishyaycá wañuycällaćhüchu manam camacan'a. Aśhwanpa caypam Tayta Dios altuman juluycuśha can'a jinaman caćhamuśhan chulin munayniyu caśhantapis camalachin'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Ñatac chaynu ishyaśhanta uyalilpis Jesus chay Lazaroctapis, Mariactapis, Martactapis allicta cuyayalpis ishcay muyunlämi chay caśhancächu caycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaypïlämi Jesus yaćhapacünincunacta: “Acuchun cutishun Judea-läducta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Niptinmi: “Yaćhachicü taytay, anyan śhaluyllalä chay malcäćhu tamshayta ñacayalcäśhuptiquichun ¿canan cutiyta munayanquiman?” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Niptinmi yaćhapacünincunacta: “¿Manachun muyuncäćhu ćhunca ishcayniyu üra cayan? Cay pachäpa acchin acchiptinmi muyunpa pulïcá mana imamanpis mitcacacunchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ñatac tutapäcäćhu pulïcämi ichá, acchi mana captin mitcacacülun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nishanpïtam: “Amigunchic Lazarom puñüśha cayan. Chaymi licchachï lishä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yaćhapacünincunañatacmi: “Taytay, puñuyalñá allinpacayämunñaćhá” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ñatac Jesus chaynüllap niyäla: “Lazaro wañüśham cayan” ninantam. Yaćhapacünincunañatacmi puñuyllaman pinsapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaymi Jesus tantiapaśhta nin: “Lazaro wañüśham cayan. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Chayćhu mana caśhäca amcunap allinniquipä captinmi cushicú. Cananpi'a chalapacuyniqui masïsum tacyalpun'a. Acuchun, payman lishun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Niptinmi “Awacha” nipäcuśhan Tomas yaćhapacü-masincunacta: “Acuchun paywan lishun ya'anchicpis, wañulpis wañuśhun paywanćha” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ñatac Jesus Betania malcäta ćhänanpämi Lazaro tawa muyunña pampäśha cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Chay Betania malca Jerusalenpïta ćhawpi üranuy puliycuylla captinmi Jerusalenpïta achca Israelcuna Mariactawan Martacta tulin wañuśhanpi watucuycü lipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ñatac Jesus ñaćhapaycayämuśhanta Marta musyälulmi ćhasquïnin talipäla; ñañan Mariañatacmi wasinćhu quïdälun. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chayćhu Jesuswan tincülulmi: “Taytay, cayćhu am cayaptiqui'a manaćh tulí wañunmanchu cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Chaynu captinpis yaćhayämi Tayta Diosta mañacuptiqui mañacuyniquimannuy imacta uśhunayquitapis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Niptinmi Jesus: “Tuliqui'a śhalcämun'am” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martañatacmi: “Aw, tantiayämi llapa wañücuna śhalcamunan muyuncäćhu śhalcamunanta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Niptinmi Jesus: “Ya'am śhalcachimüca cawsachïca cayá. Ya'aman chalapacamäcá wañulpis cawsan'am. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ñatac chalapacamal cawsäcá manam wiñay simpri wañuyta lisin'achu. ¿Cay nishäman chalapacamanquichun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Niptinmi Marta: “Aw taytay, chalapacümi Dios Caćhamuśhan Chulin Salbacüca, cay pachäman śhamüca caśhayquita” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nilculmi ñañan Mariaman cutilcul japächalcul linlillanćhu: “Cayćhüñam yaćhachicüca cacuyan. Ayayäśhunquim” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Niycüluptin-pacham mana-mana śhalcuculcul Jesusman pasacun. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ñatac Mariap, Martap malcanman Jesus manalämi ćhämulachu. Chay Marta talipäśhanćhu tincuśhancällaćhülämi cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chaymi chay wañupacücäta cumpañä Israelcunaca Maria wayra-wayra pasacuśhanta licälälil “Pantiuncäćhu tulinta wa'apäćha liyan” nil ipanta atipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chay Jesus caśhancäman ćhälulmi puntanman un'ulacuycul nila: “Taytay, am cayćhu cayaptiqui'a tulí manaćh wañunmanchu cala” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chayćhu Mariawan cusca liwshïnincunapis wa'acuptinmi, Jesuspa śhun'unpis alalaycuptin nila: ");
INSERT INTO qvwNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“¿Maymantan pampälälinqui?” nil. Niptinmi: “Taytay, acuchun licaycamulläśhun” nil puśhapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chayćhümi Jesuspis wa'acula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chayta licalmi Israelcunaca: “Licay-ari, ¡maynu cuyayninmi cañä!” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waquinnincunañatacmi: “Cay aplactapis licayächil'a Lazaro mana wañunanpä ¿manachun imallactapis lulanman cala?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ñatac chay Lazaro pampaläśhancämi juc maćhaynuy ućhcüśha jatun palta lumiwan wićhäśha cala. Chayman aśhuyculmi Jesus śhun'unpis alaläśha nila: ");
INSERT INTO qvwNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Cay lumïta aśhuchipäcuy” nil. Niptinmi wañücäpa panin Marta: “Taytay, tawa muyun wañucuśhan cayaptin'a aśhnaliyanñaćh” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Niptinmi Jesus: “¿Manachun nilac ‘Chalapacamal'a Diospa sumä cayninta licanquim?’ nil” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chaynu chay lumïta aśhülächiptinñatacmi Jesus janay pachäta licalcul sulpayta ucula: “Sulpá cachun taytay, mañacuylläta uyalimäśhayquipi. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Rasunpa am imaypis uyalimäśhayquita yaćhayalpis, cayta niyá cay muyülïnïcunaćhu cäcunaca ampi caćhamuśha caśhäta tantiapäcunanpämi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nilculmi ayaycaćhaypanuy “¡Lazaro, yalamuy!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chayćhümi wañüca umanpi ćhaquincama illpüśha, cäranpis juc lataśhwan śhucupäśha yalämun. Chaymi Jesus: “Pasquipäcuy pulinanpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Cayta licälälilmi Mariaman watucü lï Israelcunaca Jesusman achca chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquinnincunañatacmi ichá Jesus lulaśhanta fariseocunäman willaycü pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaymi puydï sasirdüticunäwan fariseocunaca Cunsïjup puydïnincunaćhu juntunacalcälil: “¿Imanäśhuntá cay nunäwan? Ancha anchap milagrucunactañam lulacuyällan. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jinacta licapayäśhá, paytaćh jinantin nunäpis chalapacalcälil aticulcan'a. Jinaptinćha Roma malcap cachacuncuna śhalcälimul llapa llapa ima cäninchictapis, quiquinchictapis chincächimachwan” ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chayćhümi chay watapä puydïnin sasirdüti cä Caifas limalïla: “Amcuna manamá imactapis yaćhapäcunquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Malcantin wañunanchicpïtá aśhwanpa lluypïta jucllay nunalla wañüchun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ñatac Caifas manam quiquillanpïtachu nila. Sinu'a chay wataćhu sasirdüticunap puydïnin captinmi quiquin Tayta Dios limachila “Jesusmi wañun'a jinantin Israelcunä-laycu” ninanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ñatac manam cay malcallapächu sinu'a jinantin pachäćhu Diospa Chulin chi'ishacunäta jucllachamunanpämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chay muyunpïtam Israelcunap puydïnincuna Jesusta wañuchinanpä limanacälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chaymi Israelcunäpa ñawquin'a Jesus manaña pulilañachu. Aśhwanpam Judeap malcancunapïta, chunyäninpa läduscanćhu Efrain nishan malcaman licula yaćhapacünincunawan caycälï. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ñatac Libraculcäśhan Fista ñam ji'acaycayämulaña. Chaymi manaläpis allaycuptin custumrinmannuy yacuwan chuyanchaculcänanpä juc-läducunaćhu yaćhä Israelcunäpis Jerusalenman puntapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chayćhümi Jesusta ashipäcul Diospa chuya wasinćhu: “¿Imanipäcunquim? ¿Cay fistaman śhamun'achućh manachućh?” ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ñatac puydï sasirdüticunäwan fariseocunämi camachila “Jesusta mayćhüpis licälälil'a willapämay chalachipäcunäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ñatac süta muyunlä Libraculcäśhan Fistapä faltayaptinmi, Jesus ćhäla Lazarocta śhalcachimuśhan Betania malcaman. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chayćhümi Jesus-laycu cumbiducta lulaycapäcula. Martañatacmi ćhacacamula. Lazaroñatacmi Jesuswan cusca micapäcunanpä täcuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chayćhu Mariañatacmi butïllaćhu sumä-sumä ćhaniyu nardo śhutiyu pirfümiwan Jesuspa ćhaquinman jillpuycul ächanwan pichaycula. Chayćhümi chay pirfümip mishqui aśhnaynin wasinman lluy juntäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ñatac Jesusta ipanchananpä cä Simonpa chulin Judas Iscarioti yaćhapacüninmi: ");
INSERT INTO qvwNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¡¿Imanuypatan quimsa paćhac (300) muyun trabajup ćhaniyüta pampaman muyuyächinman?! Aśhwanpaćh lanticulcul wacchacunäta yanapaycunman cal'a” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Cayta nila manam rasunpa wacchacunäta llaquipayninwanchu, sinu'a suwacunan-laycum. Paypa maquinćhu illay captinmi munalishanmannuy chalala. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chaymi Jesus: “Jina lulachun. Caycunactá ćhulalächila wañuptí pampacunäpä alistaycamayninwanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wacchacunacá imaypis amcunawanläćha capäcun'a. Ya'am ichá pasaypipächu cayćhu mana caśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ñatac achca-achca Israelcunam yaćhälälila Jesus chayćhu caśhanta. Chaymi payta chaynütac Lazaro wañuśhanpïta śhalcamuśhantawan licä pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Chaymi puydï sasirdüticunaca Lazaroctapis wañuchipäcunanpä limanacälälila: “Cay Lazarop jananmi achca-achca Jesusman chalapacalcälil ya'anchicpïta japächacücuyalcan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ñatac chay walantin muyun chay fistaman ćhämü nunacunämi yaćhälälin Jerusalenman Jesus ćhämunanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chaymi talipapäcula palmïra jaćhap lapinta apticälälisha-cama bïbaśhtin: “¡Cawsachun Diosninchicpa pudirninca! ¡Cawsachun Israelcunap Mandäninca!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesusñatacmi malta aśhnucta talilcul sillacuśha Jerusalenman yaycula Diospa shiminćhu nishanmannuy. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Chayćhümi: “Ama manchacuychu, Jerusalenćhu chulilläcuna. Juc malta aśhnuman sillacüśham Mandacüniqui śhayämun” niyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Caycuna pasayaptinmi cay nishanca lulacäśhanta yaćhapacünincuna mana tantiapäculachu. Janay pachäta Jesus cuticuptinlämi paypi cay isquirbishancunaca lulacäśhanta tantiapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazarocta śhalcachimuśhanta licä nunacunäñatacmi chay pasaśhanta jinalla lluy willapacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaymi chaynu milagructa lulaśhanta uyalil achca nunacuna Jesusta ćhasquipäcü yalatityapämula. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chayta licalmi fariseocunäñatac: “¡Licay-ari! Jinantin nunacunäña aticuyalcan. Imactapis manam julucunchicchu” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chay fistaćhu Diosta alawaycälinanpä lïcunaćhümi mana-Israelcunäpis capäcuñä. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paycunam Galileap Betsaida malcayu Felipiman aśhuycälil: “Taytay, Jesuswanmi tincuycuyta munapäcú” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Niptinmi Felipe Andresman lilcul willaycula. Chaypïtam pulanña Jesusman niycü lipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chaynu mana-Israelcuna ashiyalcaptinmi Jesus nila: “Canan ürá ćhämunñam ya'a Nunap Chulinca rasunpa maynu sumä caśhätapis tantiapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sumäta uyalipämay: juc trïgu muju allpäman ćhal mana wañuptin'a, jina jucllay mujullam. Wañülulmi ichá achcaman milälunlä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chaymi cawsayninta ama-pacha nïcá cawsayninta apacun'a. Cay pachäćhu cawsaynintapis imapis mana ucücäñatacmi ichá wiñay simpripä ćhulan'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mayanpis sirbïmänïcunacá atimänanmi cayan; chay sirbïnïcunawanmi ya'a caśhäcäćhu cusca capäcuśhä. Jinaman'a Taytäpis altumanmi ćhulaycun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nishanpïtam Jesus: “Canan bïdäćhüchu manañam cacuyá. ¿Chaychun ‘Taytay cay śhamücäćhu pasamänancunapïta julaycamay’ nishä? Manamá; cay lulanäpämari śhamulá. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chayurá, Taytay, am altuman julucuycuy” nin. Niptinmi janay pachäpi ayalpämula: “Ñam ya'a altuman juluycuśhaña cayá; yapañatacmi altuman juluycuśha caśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chayćhu nunacunäñatacmi chay ayalpämuśhanta uyalïlälil: “Räyuchućh paćhyälun” nipäcun. Waquinnincunañatacmi “Anjilchućh limapälun” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chayćhümi Jesus: “Limamuśhanca manam ya'a-laycuchu, sinu'a amcuna-laycum” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nilculmi: “Cananmi cay pachäćhu jinantin nunacunaca cäraycuśha can'a. Chaynütacmi cay pachäta duyñuchacüśha cä Satanaśhpis alupacüśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ñatac śhalcachisha captïmi llapa nuna ya'aman śhapämun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cay nishanwanmi tantiachila curuśhcäćhu imanuypa wañunanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chay nunacunäñatacmi: “Camachicuypam yaćhanchic Diospa Caćhamuśhan Salbacüca pasaypipä cawsananta. ¿Chaychun amñatac ‘Rasun Nunap Chulincá wañun'am’ niyanquiman? Chayurá ¿mayanpïtá limayanqui?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Niptinmi Jesus: “Amcunawan uchucllactañam caycuśhä acchiycälinacpä. Chaymi acchi caśhancama puliycälinayqui. Tutapäca chaläśhuptiquim ichá mana maypa linayquitapis yaćhapäcunquiñachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chaymi caśhäcamá acchïman chalapaculcay, acchïćhu cawsapäcunayquipä” nin. Caycunacta limayta camacalculmi Israelcunäwan mana licachicullal licula. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chaynu Jesus milagru lulaśhancunacta Israelcunaca may-maytaña licayalcalpis manam chalapaculcälachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Caynüpam Diospa unay willacünin Isaias nishanca lulacacula. Chayćhümi niyan: “Tayta Dios ¿mayanllá willacuśhanchicta ćhasquiyculatan? ¿Mayanllá Tayta Diospa munayninta tantiayculatan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Caynu mana chalapaculcälachu Isaias isquirbishanćhu caynu niyaptintacmi: ");
INSERT INTO qvwNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ñawincunacta aplälun, śhun'untapis lumiyächin. Chaymi mana licapäcun'achu, uyalipäcun'achu, tantiapäcun'achu, nïtac cutipämun'achu sänaycachinäpäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaias lluy caycunacta willala Jesuspa sumä cayninta licalmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Masqui achca mana chalapacuyalcaptinpis Jesusman achcatacmi chalapaculcäla aśhta Israelpa puydïnincunapis. Ñatac fariseocunaca juntunacuynincunapi alülälinanpïta manchaculmi lluypa ñawquin'a chalapaculcäśhanta mana camalachipäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Paycuna Dioswan allinpa licachicunantá, nunacunäwan allinpa licachicuyllactam wañupaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesusmi chayćhu callapawan nila: “Ya'aman chalapacücá manam ya'allamanchu, sinu'a caćhamänïmanpis chalapacuyanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ya'acta licamäcá caćhamänïtawanmi licayan. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cay pachäman acchinümi śhamulá chalapacamäcunaca yanawyayä tutapäcäćhu manaña cayänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ñatac willacuynïta uyaliyal mana cäsucücunätá manam ya'achu cäraycuśhä. Cay pachäman chaypächu manamari śhamulá, sinu'a salbaycunäpämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ñatac mayanpis jamuyal willacuynïta mana cäsucücunätá cäraycul mućhuycachinanpä cayanñam. Chay quiquin willacuyllämi unanchaycuśhan muyuncäćhu mućhuycachin'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ya'a quiquilläpïtachu manam limayá. Aśhwanpa quiquin caćhamäní Taytämi camachimäla imanuypa yaćhachinäpäpis limanäpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yaćhämi paypa limaynin wiñay simpripä cawsachishanta. Chaymi Taytá nimäśhantanülla willacuyá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Chay Libraculcäśhan Fistapä juc muyunllañam cayäla. Jesusñatacmi cay pachäpïta Taytan caśhancäman cuticunan üra ćhämuśhanta yaćhalaña. Pay cay pachäćhu nunancunactam cuyala. Chaymi maynu-maynu cuyaśhantapis camalaycachinanpä cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Ñatac supayca Simon Iscariotip chulin Judaspa śhun'unmanmi ćhuläla Jesusta ipanchananpä. Jesusñatacmi quiquin Tayta Diospi śhamuśhantapis payman cutinantapis, jinaman maquinman lluy imacta Taytan ćhulaycuśhantapis tuquicta yaćhala. Chay sinayalcäśhanćhümi Jesus śhalcuculcul janä müdananta lluśhticulcul tuallacta wi'awninman watacülun. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jinalculmi labaturiuman yacucta ćhulaycul yaćhapacünincunap ćhaquinta pa'alcul wi'awninćhu tualläwanñatac pichala. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ñatac Simon Pedroman pa'ananpä ćhäluptinmi: “Taytay ¿amlächun ćhaquïta pa'ayämanquiman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Niptinmi: “Caycunacta manalämi canan tantianquimanlächu. Chaypïtam ichá tantiapäcunquiman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Niptinmi Pedro: “Manam imaypis ćhaquïtá pa'acamanquimanchu” nil mićhacula. Niptinmi: “Mana pa'apti'a, manam ya'apä canquimanchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Niptinmi: “Taytay, chaynu captin'a, maquïtawan umätawan-ari pa'aycallämay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Niptinmi: “Mayanpis almacuśhacá lluy chuyañam cayan; ćhaquillantañam pa'acunan. Amcuna chuyañam cayalcanqui, masqui lluy mana capäculpis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Caynu Jesus nila “Manam lluychu chuya cayalcanqui” nil pï ipanchanantapis yaćhalmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ñatac lluy yaćhapacünincunap ćhaquinta pa'ayta camacalpulmi, caśhan müdaculcul taycucuycul nila: “¿Tantiapäcunquichun imapi caynu lulaśhäta? ");
INSERT INTO qvwNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Amcuna ‘Yaćhachicü taytay’ nipämanquim. Rasunpa nimäśhayquinümi cayá. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ya'a yaćhachicü taytayquilä uyway nunanu ćhaquiquicunacta pa'ayapti'a, amcunapis quiquiqui-pula pa'anaculcänayquim. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","16","Rasunpa juc uyway manam patrunninpïta maslächu, nïtac juc caćhaśha nunapis caćhäninpïta maslächu. Chaymi caynu lulaynïwan yaćhaycälichic amcunapis lulaycälinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Canan caycunacta uyalicul lulapäcul'a cushisham capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ñatac manam llapayquipïchu limayá. Mayanniquicuna aclaśha capäcuśhayquitapis yaćhämari. Rasunpa isquirbishancunaćhu ‘Cusca micuśhäcämi ipanchäní licalïlun’ nishancämi canan lulacacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cananpïmi cay pasanantapis willayalcac lluy lulacaptin rasunpa pï caśhäta tantiapäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sumäta uyalipäcuy: caćhacuśhäta ćhasquïcá quiquïtam ćhasquiyäman; ya'acta ćhasquiycamäcá caćhamäní Taytätapis ćhasquiyanmi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Caycunacta nilculmi Jesus sumä-sumäta llaquisha cayal: “Rasunpa jucniquim ipanchapämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Niptinmi yaćhapacünincuna licapänacuyllaman camälälila, “¿Mayannïćha cayalcá?” nicuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ñatac cuyaśhan yaćhapacüninmi Jesuspa lädunćhu cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Paytam Simon Pedro siñaśhchayllap “¿Mayanshi chay cayan?” nil tantiachila tapunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Niptinmi masta jućhutyalcul: “Taytay, ¿mayannïtan chay ipanchäniqui cayalcá?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Niptinmi Jesus: “Tantacta puśhtalcachil uśhäcämi cayan” nin. Nilculmi tantacta puśhtalcachil Simon Iscariotip chulin Judasman uycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chayćhu ćhasquïllaptin-pacham Judas Satanaśhpa maquinćhu cananpä llallichicüla. Chaymi Jesus: “Lulanayquita apuraypa lulay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Niptinmi chayćhu lluy micücunaca imapi chaynüta nishantapis mana tantiapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ñatac Judas illay uywäca captinmi “ ‘Fistäpä lluy lantipacamuy’ niyanćha, ütac ‘Wacchacunaman uycamuy’ niyanćha” nil nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ñatac chay tanta uśhancäta Judas micacalpulmi tutapäśhaña pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chaynu pasacuptinmi Jesus: “Canan ürá ćhämunñam. Ya'a Rasun Nunap Chulinca maynu sumä caycuśhäta ñam camalachicuśhäña. Ñatac ya'a lulaśhäwanmi Tayta Dios altuman juluycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jinaycuptí ya'actapis altuman julaycamänan cayllaćhüñamá cacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Cuyaśhäcuna, ash timpullañam amcunawan caycuśhä. Chayćhu ashipämalpis Israelcunäta nishänüpis manam lishäman'a lipäcunquimanlächu. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cananmi muśhü camachicuyta niycälic: quiquiqui-pula cuyanaculcay. Maynümi cuyapäculac chaynu-ari cuyanaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chaynu cuyanaculcaptiquim yaćhapacünïcuna caśhayquita lluypis tantiapäcun'a” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Niptinmi Simon Pedro: “Taytay, ¿maytatan licunqui?” nin. Niptinmi: “Lishäcäman canan manam atimanquimanlächu. Chaypïtaćh ichá śhamunquiman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Niptinmi Pedro: “¿Taytay, imapïtan canan mana aticmanlächu? Am-laycu bïdätapis uśhämi” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesusñatacmi: “¿Rasunpachun bïdayquitapis uycunquiman? Rasunpa manaläpis wallpa wa'amuptinmi, quimsa cutictaña ‘Manam lisïchu’ nil nimanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nishanpïmi: “Amañari anchap jucmanyäśha cayalcaychu. Aśhwanpa Tayta Diosmanpis, ya'amanpis chalapacalcämay. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Taytá caśhancäćhümi yaćhanapä achca jäcuyalcan. Chaymi ćhäpämunayquipä allichamü liyá. Chaynu allichalcamulmi puśhäniqui cutimuśhä, ya'a caśhäcäćhu amcunapis capäcunayquipä. Sïchuśh chaynu mana captin'a manaćh ‘Allichä-ari lishä’ niyalcacmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ñatac mayta linätapis, maycäpa caminu lishantapis yaćhapäcunquiñam” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Niptinmi Tomas: “Taytay, manatac mayta linayquitapis yaćhapäcüchu. ¿Imanuypatá chay caminütälä lisïlälïman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Niptinmi Jesus nin: “Ya'am caminuca, rasun allinca, cawsayta uycücäpis cayá. Ya'allapamari Taytäman ćhanman. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Amcuna ya'acta lisipämal'a Taytätapis lisipäcunquim. Cananpïtá lisïlälinquiñam. Jinaman'a licälälinquiñam canpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Niptinmi yaćhapacünin Felipe: “Taytay, Tayta Diosta licaycachimänallayquipämi capäcuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusñatacmi: “Felipe, ¿cay-chica timpu cayaptinchicchun manalä lisimanquimanchu? Ya'acta licamäcá, Taytätapis licaycunñam. ¿Chaychun canan ‘licachimay’ niyämanquimanlä canpis? ");
INSERT INTO qvwNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Icha ¿manachun Taytäćhu ya'a caśhäta chaynütac Taytäpis ya'aćhu caśhanta chalapacunqui? Imanishacpis manam quiquilläpïchu, sinu'a ya'aćhu cä Taytämi lulaycuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chalapacamay-ari Taytäwan juclla capäcuśhäta masqui milagrucunacta lulaśhalläpapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Rasunpa, ya'aman chalapacamäcunacá ya'a lulaśhäcunactam lulapäcun'a. Taytäman cutiptïmi ichá sumä mascunactalä lulapäcun'apis. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ñatac ya'ap pudirní cayal Taytäta imactapis mañaculcaptiqui'a uycuśhämi, Taytá maynu munayniyu caśhanta ya'awan camalaycachinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chayurá ya'ap śhutïćhu mañacalcämuptiqui'a imactapis ćhasquiycälinquim. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ñatac rasunpa cuyapämal'a, yaćhachicuynïmannümi cawsaycälinqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Chaynütacmi Taytäta mañacuśhä juc Caminaycüniquita caćhamunanpä. Chay rasuncäta camalachï Ispiritunmari amcunawan imaycamapis caycun'a. Mana chalapacücunacá payta mana licalmi lisilmi nï ćhasquïpäcunmanchu. Amcunam ichá cusca cayalcal lisipäcunqui. Jinamanñatacmi amcunaćhu caycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Manatacmi caćhaycälishayquichu, sinu'a amcunaman cutimuśhämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ñatac ishcay quimsa muyuncunapïtanuy caypi licuptïmi manaña licapäman'añachu. Amcunam ichá caśhan cawsamuptí licapämanqui. Chaymari amcunapis cawsapäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chay muyuncunaćhümi tantiapäcunqui Taytäćhu caśhäta, chaynütac amcunapis ya'aćhu capäcuśhayquita, jinaman'a ya'apis amcunaćhu caśhäta. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mayanpis shimïta uyalicul lulaycücá llapan śhun'unwanmi cuyaman. Cuyamäcunätá Taytäpis cuyan'am. Ya'añatacmi sumäta camalaycachicuśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chayćhümi juc Judas — cay'a manamá Judas Iscariotichu — nin: “Taytay, ¿imapïtan ya'acunallaćhu camalaycachicunqui, jinantin nunacunaćhu'a manatac?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Niptinmi: “Cuyamäcá camachicuynïmannümi cawsaycun'a ñatac Taytäpis cuyan'am. Taytäwan cutipämulmi cuyamänïcunawanpis yaćhapäcuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mana cuyamäcunacá camachicuynïmannüchu manam cawsapäcun'a. Cay nishäcunaca manam quiquilläpïchu sinu'a caćhamäní Taytäpïmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cayćhu caśhäcamam caycunacta yaćhayalcächic. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Śhamü muyuncunaćhüñatacmi ichá Taytá Caminaycüniquipä caćhamuśhan Chuya Ispiritu yaćhachipäcuśhunqui. Cay yaćhachishäcunätapis yalpachipäcuśhunquim. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Canan'a ya'a-laycum jawca caycälinqui. Jawca caynïtam uycälicña. Cay jawca cayta uśhac'a manam cay pachäćhu nunacuna uśhancänüllachu. Chayurá ama jucmanyapäcunquichu, nï manchaliculcanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Uyalipäculanquiñam ‘Licuśhämi; chaypi caśhanmi amcunaman cutimuśhä’ nishäta. Rasunpa cuyapämal'a ya'apïpis mas munayniyu Taytäwan cusca canäpä liyapti'a cushiculcanquimanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lluy caycunacta willayalcac manaläpis pasayaptinlämi, cay nishänülla pasaptin chalapacalcämänayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Canan'a cay pachäta duyñuchacüśhaca ji'acaycayämuptinñam manaña timpu cacuyanñachu limananchicpä. Manamá ya'apïta mas munayniyu captinchu, ");
INSERT INTO qvwNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","sinu'a cananpïta jinantin nunacunaca yaćhapäcunanmi Taytäta cuyal nimäśhallanmannuy lulaycuśhäta. ¡Śhalcapäcuy, caypi licuśhun!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nilculmi Jesus nilatac: “Ya'am rasun üba plantaca cayá; Taytäñatacmi lulaycüca. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chaymi jucnin pallayní mana wayuyniyu captin'a lluy cuchülun. Ñatac wayuyniyu captinmi ichá püdapayan mas wayuy-sapa cananpälä. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Chaynümi amcunapis shimïta uyalil ćhasquimäcunacá, püdaśhanuy allin chuyaña cayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chayurá ya'aćhu tacyaycäliy amcunaćhu ya'a caycuśhänuy. Juc pallay quiquillanpïta manamá wayunmanchu. Chay yulaćhümi caycunan. Chaynümi amcunapis ya'aćhu mana capäcul'a mana wayupäcunquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ya'ami üba plantaca cayá; amcunañatacmi pallaynïcuna. Chaymi ya'aćhu tacyaycüca, chaynütac ya'apis paywan caycupti'a sumä wayuyniyu caycun'a. Ñatac quiquillayquicuná manam imallactapis lulayta atipapäcunquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Chaynütacmi ya'aćhu mana caycücá chaquinanpä wicapäśha pallaycänuy cayan. Chaycuna chaquïluptinmi juntulcul nina walaśhancäćhu cañaśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ñatac ya'aćhu masïsu tacyaycul, shimïtapis śhun'unćhu uywaycücätá munaśhayquitam mañacuśhayquimannuy uycuśha capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Caynu sumä wayuyniquiwan maynu sumä yaćhapacünïcuna caśhayquita camalaycachipäcuśhayquipam Taytá altuman juluycuśha can'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Taytá cuyamäśhannümi amcunactapis cuyapäcuc. Cay cuyacuynïćhu-ari tacyapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Maynümi ya'a Taytäpa camachimäśhanta uyalicul, paypa cuyayninćhu tacyaycú, chaynümi lluy camachicuynïta uyalicul'a amcunapis cuyaynïćhu tacyaycunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Caycunacta niycälic amcunaćhu cushicuyní caycuptin maćhaycälälinayquicama cushiculcänayquipämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Caymi camachicuyní amcunapä: Ya'a cuyapäcuśhacnuy quiquiqui-pulapis cuyanaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sumä-sumänin cuyaycücá quiquinpa bïdanta amigunpi uycücämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amcuna camachicuynïta cäsuculcal'a amigüñam capäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Manañam ‘uywayní’ niyalcacchu. Uywaycá patrunnin ima lulaśhancunactapis manam yaćhanchu. Amcunactam ichá Taytá lluy nimäśhanta yaćhaycälichicña. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ñatac amcunachu manam ya'acta aclapämälanqui, aśhwanpa ya'ami aclapäculac mana camacaycü sumä wayupäcunayquipä. Chayurá pudirní cayalcaptiqui'a ima mañaculcäśhayquitapis Taytá uycälishunquim. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yapa nishayqui cay camachicuynïta: quiquiqui-pula cuyanaculcay. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Cay pachäćhu nunacunaca ćhïnipäcuśhuptiqui'a ya'acta puntacta ćhïnipämäśhanta yalpapäcuy. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sïchuśh cay pachäpä capäcuptiqui'a nunacunaca quiquintanümi cuyapäcuśhunquiman. Canan chay mana allin lulayniyücunäpi julapämuśhacpam, jinaman'a chay lulayninta manaña atichipäcuptiquim ćhïnipapäcuśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chaynütac yalpapäcuy ‘Juc uyway manam patrunninpïta maslächu’ nipäcuśhacta. Chayurá ya'actapis aticaćhayalcämal'a, amcunactapis aticaćhapäcuśhunquim. Willacuynïta ćhasquiyalcämal'a amcunactapis ćhasquipäcuśhunquim. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lluy caynu lulapäcuśhunqui caćhamänïta mana lisil ya'a-laycum. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Rasunpa willaycunäpä mana śhamupti'a manam pï juchachaycunan canmanchu cala. Cananmi ichá juchanpi mana ima ninan canñachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ya'acta ćhïnimäcá Taytätapis ćhïniyantacmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Munaynïwan milagrucunacta paycunaćhu mana lulapti'a mana juchachäśham capäcunman. Cananmi ichá masqui cay lulaśhäcunacta licayalcalpis ćhïnipapämäśhanwan Taytätapis ćhïniyalcantac. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Caycunawanmari lulacacun camachicuyćhu ‘Yan'alpïmi ćhïnipapäman’ nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ñatac Taytäpi caćhamuná Caminaycuśhüniqui, rasuncäta camalachï Ispiritum ya'api liman'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chaynütacmi amcunapis limapäcunqui yaćhachiyta allaycuśhäpi ya'awan cayalcalñá. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Lluy caycunacta nipäcuc ya'apïta mana laquiculcänayquipämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chay juntunacuynincunapïta alupäcuśhunquim. Chay wañuchipäcuśhüniquicunam: ‘Diosta caynüpamari sirbinchic’ nipäcun'alä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Caynu lulapäcun'a ya'actapis caćhamäní Taytätapis mana imaypis lisipämalmá. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Caycunacta willayalcac chay ćhämuptin cay nishäcunäta yalpapäcunayquipämi. Ñatac puntapi caycunacta mana nipäculacchu ya'awan cayalcaptiquilämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cananmi ichá caćhamäní caśhancäman cutiyaptïpis mana mayanllayquipis mayta linätapis tapupämanquichu. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aśhwanpam cay nishäcunäwan sumä-sumä llaquicälälinqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Masqui chaynu captinpis, cutishäca amcunap allinniquipämari. Mana cutipti'a chay Caminaycuśhüniqui manam śhamunmanchu. Aśhwanpa cutilmi caćhamuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pay śhamulmi jinantin nunacunäta tantiachin'a jucha-sapa capäcuśhanta, ya'apa allin caśhätapis, ñatac juchancunapi mućhuycachisha canantapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tantiachin'a jucha-sapa capäcuśhanta ya'aman mana chalapaculcämäśhanpïtam. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tantiachin'atac allin caśhäta Taytäman cutilcul amcunawan manaña caśhäpïtam. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jinaman tantiachin'atac mućhuycachinäta cay pachäta duyñuchacüśhaca cäraycuśhaña cayaptinmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“May-mayćha amcunacta niná cayan. Canan'a anchapmari canman. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Chuya Ispiritu śhamulñam ichá rasun allincäta yaćhaycälichipäcuśhunqui. Pay'a manam quiquillanpïtachu yaćhachipäcuśhunqui, sinu'a lluy uyalishancätam. Jinaman'a śhamü muyuncunäćhu ima pasanancunactapis willaycälishunquim. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Caynu ya'api ćhasquishallanta amcunaman willaycuśhanwanmi altumanpis julaycaman'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ñatac Taytäpa lluy cänincunapis ya'apam. Chaymi ‘Ya'api ćhasquishantam Chuya Ispiritu amcunaman willaycuśhunqui’ niyalcac” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nilculmi: “Ishcay quimsa muyuncunapïtanuy'a manam licapämanquiñachu. Chaypïtalämi caśhantac licapämanqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Niptinmi waquin yaćhapacünincuna quiquin-pula: “¿Imaninantan ‘Ishcay quimsa muyuncunapïta manam licapämanquiñachu. Chaypïtalämi caśhan licapämanqui’ niyämanchic? ¿Imanuytacmi ‘Taytá caśhanman lishä’ nishancäpis? ");
INSERT INTO qvwNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Chay ‘Ishcay quimsa muyunpïtanu'a’ nishantapis manam imapi limaśhantapis tantianchicchu” ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ninacuptinmi Jesus tantiälun tapucuyta munapäcuśhanta. Chaymi: “¿Amcuna tapunacuyalcanqui ‘Cananpi ishcay quimsa muyuncunapïta manam licapämanquiñachu. Chaypïtalämi caśhan licapamanqui’ nishäcäpïchun? ");
INSERT INTO qvwNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Canan sumäta uyalipämay: cay pachäćhu nunacunaca cushicuyćhu cayalcaptin amcunañatacmi wa'acuyćhu llaquicuyćhu capäcunqui. Masqui chaynu llaquicuyniqui captinpis sumä cushicuymanmi muyun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Maynümi juc walmip waćhay dulurnin chaläluptin dulurninta llaquisha apan. Näsichicülulmi ichá chay wawinpïta cushicul nanay apaśhantapis manaña yalpanñapischu. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chaynümi amcunapis canan sumä llaquichisha capäcunqui. Caśhan cutimuptí tincuptinchicmi ichá sumä-sumäta cushiculcanqui. Chay cushicuyniquitá manamá pipis ućhishunquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chay muyuncunaćhu'a, manañam mañacalcämänayquipä can'añachu. Rasunpa pudirní cayalcal Taytäta mañaculcäśhayquitam lluy uycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Canancama manalämi imallactapis pudirnïnuy mañaculcanquilächu. Mañaculcal'a ćhasquipäcunquim sumä cushicuywan maćhaycuśha capäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Canancama caynu tincuchiyllapmi yaćhaycälichilac. Ñatac Taytäpïta tincuchiycunap mana yaćhaycachil cällanman camalaycachiná üra jananchicćhüñam. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay muyunpi pudirní cayalmi Taytäta mañaculcanqui. Manañam mañacapuná can'añachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aśhwanpa quiquin Taytämi cuyapäcul uyalipäcuśhunqui. Ñatac caynu cuyapäcuśhunqui cuyapämäśhayquipam, jinaman paypi śhamuśhäta tantiapäcuśhayquipam. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Rasunpa Taytá caśhancäpïtam cay pachäman śhamulá. Cananñatacmi cay pachäta caćhaycul Taytá caśhanman cutishä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Niptinmi yaćhapacünincuna: “Canan'a mana tincuchillalñam tuqui tantiapaśhllacta willaycälimanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cananmi ichá tantiaycälí lluy imactapis yaćhaśhayquita aśhta ima tapucuyní cäcunactapis. Chaymi Diospi śhamuśhayquita chalapaculcá” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nipäcuptinmi Jesus: “Chayurá chalapacayalcämanquićhá ¿aw? ");
INSERT INTO qvwNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Japalläta caćhaycälälimal wicta cayta chi'ipäcunayqui üraca jananchicćhüñam. Ñatac japallächu manam cayá; Taytämari ya'awan cusca cayan. ");
INSERT INTO qvwNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Caycunacta niyalcac ya'aćhu jawca caycälinayquipämi. Cay pachäćhu'a ima sasachacuycunactapis pasapäcunquim. Ñatac chaycunaćhu callpanchaculcay; ya'a quiquïmari lluyta cay pachäćhu llalliytá llallïlüña” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nilculmi Jesus janay pachäta licalcul: “Taytay, ürá ćhämunñam. Mayan caśhätapis nunacunäman camalaycachiy ya'apis ampïta camalaycachinäpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ya'amanmi munayniquita uycamälanqui lluy nunacunaca maquilläćhu cananpä, chaynütac lluy unanchaycuśhayquicunäta wiñay simpripä cawsachinäpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Paycuna am rasun Tayta Diosllätawan ya'a caćhamuśhayqui cäcäta lisiycuyllanwanmi wiñay cawsaycäta ćhasquipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Taytay, sumä caśhayquitapis cay pachäćhu camalaycachïmi nimäśhayquicunäta lluy camacaycuśhäwan. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chayurá, canan-ari ñawpäniquićhu caśhan altuman julaycamay cay pacha allaycuptin anwan cusca julaycamäśhayquinu. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ñatac cay pachäćhu cäcunäpi unanchaycul uycamäśhayquicunällactam mayan caśhayquitapis lisiycachilá. Ampa cäcunätamari uycamälanqui. Ñatac shimiquita uyalilmi cäsuculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chaymi canan yaćhapäcunña lluy umäśhayquicunaca amllapi śhamuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nimäśhayquicunäta lluy willacuptí ćhasquicalcämäla rasunpa am caćhamäśhayquipi śhamuśhäta tantialmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Chaymi mañacuc paycunapä. Manam cay pachäćhu nunacunäpächu, sinu'a ampa cäcunapïtam, umäśhayquicunapïtam. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Cay lluy nuna ya'apa cäcunäpis ampam. Chaynütacmi ampa cäcunapis ya'apatac. Paycunapñatacmi maynu sumä caśhätapis camalaycachilanqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Canan'a cay pachäta caćhaycuśhäñam anwan cananchicpä. Paycunañatacmi ichá cay pachäćhu caycälin'alä. Chayurá Sumä Taytay, lluy umäśhayquicunäta ñawillayquićhu caycachiy-ari ya'anchicnuy jucllaylla paycunapis caycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cay pachäćhu paycunawan caśhäcamá, lluy umäśhayquicunäta munayniquiwanmi ñawilläćhu uywalá. Manamá jucllanpis chincalachu sinu'a chay shimiquićhu nishannuy lulacacunanpä camacäśha cananpä unanchäśhancällamari. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Canan cusca cananchicpämi cutiyämú. Cay pachäćhu caśhäcamam ichá caycunacta mañacamú cushicuynïwan sumä maćhaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Paycunacta willacuyniquita willaptïmá cay pachäćhu nunacunaca ćhïnipapäcula. Chay uyalicücunäpis nï ya'apis manam cay pachäpächu capäcú. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Chaynu captinpis, manam cay pachäpi julunayquipächu mañacuc, sinu'a cay mana allincäpi licaycunayquipämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rasunpa, manam paycunapis nï ya'apis cay pachäpächu capäcú. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chayurá rasun allin shimiquiwan amllapäña chuya-camacta lulaycuy. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Maynütacmi cay pachäpa ćhawpinman caćhamälanqui, chaynümi ya'apis cay pachäpa ćhawpinman caćhayá. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Paycuna-laycumari amllapäña calá paycunapis amllapäña sumä capäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Paycunallapïchu manamá mañacuc, sinu'a paycunap willacuyninpa śhamü chalapacamäcunäpäwanmi. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Taytay, lluy paycunari jucllaylla imaćhüpis capäcuchun. Maynümi ya'anchic juclla cayanchic, chaynu-ari paycunapis ya'anchicwan jucllaylla capäcuchun, caćhamäśhayquita lluy nunacunaca yaćhapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ñatac sumä caynïta umäśhayquitapis paycunactam uyculá ya'anchicnu jucllaylla capäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ya'a paycunaćhu caśhänuy ñatac am ya'aćhu caśhayquinu-ari sumä jucllaylla caycuchun. Chayćha jinantin nunacunaca ya'acta cuyamäśhayquinuy paycunactapis maynu cuyaśhayquita tantiapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taytay, cay uycamäśhayquicunaca ya'awan capäcuchun. Chayćha cay pachäta manalä camal sumä altuman julaycamäśhayquitawan maynu cuyamäśhayquita licapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Sumä Chuya Allin Taytáy, cay pachällapa cäcunacá manam lisipäcuśhulanquichu. Ya'ami ichá lisic. Nunäcunapis caćhamäśhayquita yaćhapäcunñam. ");
INSERT INTO qvwNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Chaynütacmi ampi camalaycachilá; jinallam camalaycachishäpis cuyamäśhayqui cuyacuyniqui ñatac ya'a quiquïpis paycunaćhu caycunanpä” nil mañacula. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Lluy caycunacta Jesus niyculmi yaćhapacünincunawan Cedron śhutiyu wayup wic-lädu chimpanman lipäcula. Chayćhu juc wirta caśhancämanmi yaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chay wirtaćhu achca cuti Jesus yaćhapacünincunawan juntunaculcaptinmi ipanchä Judaspis lisila. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaymanmi Judas ćhälun fariseocunaca puydï sasirdüticunaca caćhaśhan chuya wasip waquin täpänincunactawan achca cachacucunacta sumä armädu-cama michïrayüta lintirnayüta puśhapacüśha. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ñatac Jesus caycuna pasananta yaćhalñam yalulcul “¿Mayantatan ashiyalcanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Niptinmi: “Nazaret-lädu Jesustam” nipäcun. Niptinmi: “Ya'am cayá” nin. Paycunawanmi ipanchä Judaspis cayäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Chaynu Jesus “Ya'am cayá” nïluptinmi ipaman cutityalcälishanćhu cućhpatityälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesusñatacmi yapa: “¿Mayantamari ashiyalcanqui?” nin. Niptinmi: “Nazaret-lädu Jesustam” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Niptinmi: “Ya'am cayá niyalcacñari. Ya'acta ashiyalcämaptiqui'a paycuná jina liculcächun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Caynüpam lulacacula quiquin Jesus: “Taytay umäśhayquicunapïta jucllantapis manam jitaycüchu” nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pedroñatacmi ispäda uywaśhanta jululcul sumä puydï sasirdütip uywaynin Malcup allï linlinta juclla pasächin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jinaptinmi Jesusñatac Pedrocta nin: “Chay ispädayquita ćhulalänanman cutiycachiy. ¿Manachun Taytá caćhamuśhan sumä ñacaycäta ñacäman, imatá?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Niyällaptinmi Diospa chuya wasinpa täpänincuna, cachacucunaca jinaman puydïnincäpis Jesusman lluy shipucälälil ćhänälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jinalculmi chay watapä ćhuläśha sumä puydï sasirdüti Caifaspa suyrun Anasman puśhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cay Caifasmi Israelcunäta “Malcantin wañunanchicpïtá allinmi canman juc nunalla lluypi wañuptin'a” nïca cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ñatac Simon Pedrowan jucnin yaćhapacüninmi Jesusta atipäcula. Chay jucninmi sumä puydï sasirdütip lisisha cayal Jesuswan cusca luli patyuman yaycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroñatacmi patyup puncullanćhu quïdälun. Jinaptin chay puydï sasirdütiwan lisinacuśhan yaćhapacücämi puncu quićhänin walmicta limapaycuptin Pedrocta pasaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chayćhümi chay walmica Pedrocta: “Cay nunap yaćhapacünin-ari ampis cayanqui ¿aw?” nin. Niptinmi Pedro: “¡Manam, manam!” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ñatac sumä alaläcayämuptinmi chay täpänincunawan uyway nunacunaca ninacta walacaycachil muyülïninćhu śhaycacaycälil unupacuyalcäla. Paycunawan cuscamari Pedropis unupacuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jinaśhancamañatacmi chay puydï sasirdütica Jesusta tapula yaćhachishanpïtawan, yaćhapacünincunapïta. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chaymi Jesus: “Ya'a llapa nunap ñawquinmi yaćhachilá. Juntunacuna wasicunaćhüpis, Diospa chuya wasinćhüpis, mayćhüpis mayanćhüpis manam pacallap imactapis yaćhachilächu. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chayurá imapälätá ya'acta tapumanqui? Chay uyalïcunätari tapumuy. Paycunam tuquicta yaćhapäcun imapi yaćhachishätapis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nïluptinmi chayćhu jucnin täpäca cäraćhu lapyälun “¿Caynüpachun puydï sasirdütïtalä ninquimanpis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jinaptinmi: “Mana allinta limälupti'a, má, nimay-ari. Ñatac rasuncällacta niyapti'a ¿imapïtan lapyacamanquiman?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jinaptinmi Anas ćhänacüśhacta sasirdüticunap sumä puydïnin Caifasman puśhachila. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ñatac Pedro chay nina walaśhancäćhu jinalla unupacuyaptinmi “Cay nunap yaćhapacüninchućh ampis canqui, ¿aw?” nipäcun. Niptinmi: “Chayta manamari ya'a lisïpischu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chaypïtam puydï sasirdüticunap uywaynin chay Pedro linlinta cuchuśhan nunap ayllunpis: “¡Amta, ya'a licalac chay wirtaćhu Jesuswan cusca cayätachućh jinam!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Niptinmi Pedro: “¡Manam lisïchu!” niyällaptin wallpa wa'amun. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chay Israelcunämi aspi-aspiy Jesusta puśhapäcula Caifaspa wasinpïta Roma nasyuncäpa cuartilninman. Chayman manam yaycapäculachu “Anlacüluchwanmi Libracuśhanchic Fistaćhu canapä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chayćhümi Pilato yalalcamul: “Má, ¿imapïtam puśhayalcämunqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Niptinmi: “Cay nuna ancha anchapña mana lulaptin'a, manaćh anmanlächu puśhayalcämüman cala” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatoñatacmi: “Amcunapïtañamá. Quiquiquip camachicuyniquimannuy imactapis lulapämuy” nin. Niptinmi: “Ya'acuna manam pictapis chacataywan wañuchipäcümanchu” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Caynu Jesus nila imanuypa wañuchisha cananpä nishanca lluy lulacacunanpämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chaypïta Pilato cuartilman caśhan cutiycul Jesusta ayalculmi: “¿Chayurá amlächun Israelcunäpa sumä mandänincälä cacuyanquimanpis?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Niptinmi: “¿Caynu niyämanqui quiquillayquipïtachun ichá juccunapi uyalishayquitachun?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatoñatacmi: “¿Israel caśhtachun cayá, imatá? Malca-masiquicunari, puydï sasirdütiquicunäwan maquïman ćhulaycayämuśhunqui. Am ¿imactamá lulalanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Niptinmi Jesus: “Ya'apa gubirnú manam cay pachäćhüchu. Caypa capti'a nunäcunaćh Israelcunäpa maquinman mana ćhulaycuśha canäpä tincupäcunman cala. Gubirnu'a manam caypïchu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Niptinmi: “Chayurá ¿mandänincälächun cacuyanqui?” nin. Niptinmi: “Am nishayquinümá. Chaymi cay pachäman näsil śhamulá rasun allincäta yaćhaycachinäpä. Cay allincäta lisiyta munäcunäñatacmi cäsupäman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Niptinmi Pilato: “¿Rasuncá imatá?” nin. Nilculmi chay puśhamü Israelcunäman yapa yalulcul: “Cay nunäćhu ya'a manam imactapis juchachaycunäpä talïchu. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ñatac cay Libraculcäśhayqui Fistaćhu custumriquimannuy watan-watanmi carsilćhu wićhaläcunäpi jucninta caćhaycunanchic. Chayurá ¿Israelcunap Mandäniquitachun caćhaycuśhä?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Niptinmi Israelcunaca ayaycaćhaypa: “¡Chaytá wañuchipäcuy! ¡Barrabasta caćhaycuy!” nicuyalcan. Cay Barrabasmi fïnunnin suwa cacula. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chaymi Pilato asutiwan Jesusta camacaycächila. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cachacucunäñatacmi caśhapi curunacta lulalcälil Jesuspa umanman ćhulapäcula. Jinalcul mandacüpa jatun yana-nilä puca catacunwan ćhulälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jinayculmi jucnin jucnin aśhuycälil “¡Wiñaypä cawsachun Israelcunap mandacünin!” nil cäraćhü-cama tacapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chaypïtam Pilato yapa yalalcamul Israelcunäta: “Cananmi ñawpäniquiman julamuśhä wañuchisha cananpä mana talishäta tantiaycälinayquipä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chayćhu Jesusta caśha curunawan curunapacüśhacta, mandäpa müdananwan müdapacüśhacta julalcachimul Pilato: “Cay-ari. Amcunaćh nipäcunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chaynüta licälulmi puydï sasirdüticunäwan täpäcunaca ayaycaćhaypa-cama: “¡Chacatäluy! ¡Chacatäluy!” nicuyalcan. Chaymi Pilato: “Payćhu manamari ima juchactapis talïchu wañuchisha cananpä. Chayurá amcunari chacatalpis wañuchicalcämuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Niptinmi Israelcunaca: “¡‘Quiquin Tayta Diospa Caćhaśhan Chulinmi cayá’ ninmari! ¡Ya'acunap camachicuynïmannu wañuchisha cachun!” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cayta uyalïlulmi Pilato masta manchapacüla. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chaymi caśhan luliman cutiycälil Jesusta tapula: “¿Maypïmi canqui?” nil. Niptinmi Jesus imactapis mana limalilachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chaymi Pilato: “¿Ya'apächun mana limalinquimanchu? ¿Manachun maquïćhu cayan caćhaycachinacpäpis chacatächinacpäpis?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Niptinmi Jesus: “Imanamänayquipäpis manam ima munayniquipis canmanchu, janay pachäćhu Tayta Dios mana uycuśhuptiqui'a. Chaymi maquiquiman ćhulaycamänïcá, ampïtapis mas juchayüña cayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chay niptin-pacham Pilato imanuypapis Jesusta caćhaycachiyta munala. Jinaptinpis Israelcunäñatacmi ayaycaćhaypa: “Caćhaycülul'a Romap Puydï Mandäcäpa śhalcünin manañam canquichu. Pipis mandätucücá puydï mandäninchicpa cuntranmi śhalcuyan” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chaynüta Pilato uyalilculmi Jesusta julalcachimul Impidraśha nishan patyućhu cäraycunancäman taycucuycula. (“Impidraśha” Israel limayćhüñatacmi Gabata nipäcula.) ");
INSERT INTO qvwNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ñä chay fistapä juc muyun cacuyaptinmi ćhawpi muyun Pilato Israelcunäta: “Cay-ari Mandäniqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Paycunañatacmi jicutäcuyalcan: “¡Wañuchun! ¡Wañuchun! ¡Chacatäluy!” nil. Pilatoñatacmi: “¿Mandänïquitalächun chacatälüman?” nin. Niptinmi puydï sasirdüticuna “Sumä munayniyu Romaćhu mandä Cesarllam mandacüní. Manam juc canchu” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chaymi paycunap maquinman Jesusta ćhulaycuptin chay üra pasachiculcan mañacuśhanmannuy chacatapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jinaptinmi Jesusta curuśhnin umrucuśhacta cachacucunaca Uma Tullu nishanman puśhapäcula. (Cayta Israel limayćhüñatacmi Golgota nipäcula.) ");
INSERT INTO qvwNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chayćhümi paytawan cuscacta wicninman cayninman ishcay nunactapis chacatälälila Jesusñatac ćhawpićhu. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatoñatacmi curuśhcäpa umanman ćhulächila “Cay Nazaret-lädu Jesusmi Israelcunäpa Mandäninca” niyäta. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chay chacatäśhanca malcap läduscallanćhu captinmi achca Israelcuna lïgipäcula. Chay curuśhcäpa umanćhu'a quimsa limayćhümi isquirbisha cala: Israelcunäpaćhu, Romacunäpaćhu, Griegocunäpaćhüpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaymi puydï sasirdüticuna Pilatocta: “Ama ćhulaychu ‘Israelcunap Mandäninmi’ nïtá, sinu'a caynüta ‘Israelcunap Mandänincämi cacuyá’ nïta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Niptinmi Pilato: “Imam lulaśhäcá jina lulaśhänüllaña cacuchun” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ñä chacatälälilmi cachacucunaca Jesuspa müdananta jucnincä-cama tawan aypunacälälin. Juc jatun müdanan janaypi ulaycama jucllaćhu awäśhäpis cacuyälalämi. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chaymi “Caytá ama laćhyaśhunchu. Aśhwanpa chüsanacüśhun, mayanninchicpäshi, má can'a” ninaculcäla. Cay lulapäcuśhanwanmi isquirbishancunaćhu: “Quiquin-pulam waquinnin müdanäta aypunacülun, jucninpañatacmi chüsanacälälin” nishanca lulacacüla. Caynümi cachacucunaca lulälälila. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ñatac Jesus chacataläśhancäpa lädunćhümi cayäla mamanpis, mamanpa ñañanpis, Cleofaspa walmin Mariapis, chaynütac Magdala malcayu Mariapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chaymi chay mamanpa lädunćhu cuyaśhan yaćhapacünin śhäcuyäta licälul mamanta: “Mamay, payñam wawiqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chaynütac cuyaśhan yaćhapacünintapis: “Payñam mamayqui” nin. Chay-pachapïmi yaćhapacünin wasinćhu ćhasquila. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ñatac Jesus llapa lulayninta camacalpuśhanta yaćhaculñam “Yacunayämanmi” nila. Caywanmi Diospa limayninćhu nishanca lulacacüla. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chayćhütacmi juc wacuyćhu ćhacćhä bïnu winacuśha cañä. Chaymi caśhpip puntanman millwacta aytiycul bïnuwan puśhtaycachil śhu'uchinanpä chacchalcapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jinaptinmi chay bïnüta mallilcul: “Canan'a lluy cabalalpüśhañam” nil uyshucalpul pasacalpula. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ñatac chay fistapä juc muyunllaña cacuyaptinmi allichacuyćhu Israelcunaca capäcula. Jinaman chay warda muyunćhüpis sumä manchacuywan caycuna captinmi mana munalachu curuśhcäćhu chacatäśha capäcunanta. Chaymi caćhpancunacta paquilcachil wañulpüluptin julüśha capäcunanpä Pilatocta mañapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chaymi cachacucunaca Jesuspa lädunćhu ishcay chacataläcunäman aśhuycälil caćhpanta paquïlälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusman aśhuycälilñatacmi pasäśha cayäta licälälil manaña caćhpanta paquipäculañachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jucnin cachacuñatacmi ichá ispäda-niläwan Jesuspa wätanta tucsïlun. Jinaptinmi yawarwan yacu yalämun. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lluy caycunacta ya'ami ñawïwan licälá. Cay lluy willaśhäcunaca rasuncällam. Chaymi willaycälic amcuna masïsu chalapaculcänayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Caynu pasaśhanwantacmi Diospa shiminćhu “Jucllay tullullantapis manam paquiycun'achu” nishancäpis jinaman'a “Tucsishancäta licapäcun'am” nishancäpis lulacacüla. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaypïtam Jesuspa cuirpunta aśhuchinanpä Arimatea-lädu José Pilatocta mañacula. (Pay Jesuspa atïnin caśhanta Israelcunäta manchacuypïmi mana camalachiculachu.) ");
INSERT INTO qvwNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pilato awnïluptinmi Nicodemo apawshila. (Cay Nicodemom Jesusman tutallap śhamul tapüca cala.) Paymi quimsa ćhunca kïluctanuy mirrawan aloe nishan pulbucunacta apamuñä pampapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chay apamuśhancunäwanmi Jesuspa jinantin cuirpunta fïnunnin säbanaśhwan pitwïlälila, Israelcunap pampanaculcäśhanmannuy. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ñatac Jesusta chacatapäcuśhancäpa wicniscallanćhümi juc wirta cala. Chayćhümi mana mayanllapis pampacuśhan muśhü ućhcu pampananpä cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chay fistap muyunnin allaycunanpä cacuyaptinñatacmi chayman Jesuspa cuirpunta ćhulälälila. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ñatac simänap allaycuyninćhu aspi-aspilla Magdala malcayu Maria Jesus pampaläśhancäman linanpämi jatun lumi wićhaśhanca aśhüchisha cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chaymi Jesuspa cuyaśhan yaćhapacüninwan Simon Pedro caśhancäman wayra-wayra pasacamun. Ćhayculmi: “¡Taytanchic Jesusta pampaläśhancäpïtam juläläliñä! ¡Mayman apälälishantapis manam yaćhapäcüchu!” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Niptinmi Pedrowan chay juc yaćhapacü-masin mana-mana cürrilla chutaläśhancäman pasaculcan. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chaymi Pedropïta chay juc yaćhapacü-masin llallilcul puntacta ćhaycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chayćhu ancuycul chay pitwishan säbanaśhcunällacta licayalpis manam yayculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Chay ipanta Simon Pedro ćhayculñatacmi yaycuycul chay säbanaśhcunällacta paypis licälun chaynütac Jesuspa umanta wataśhan llapsha lataśhtapis tuqui pataläśha juc-lädućhu ćhulalayäta. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chaynu Pedro maćhayman yaycüluptinlämi juccäpis yaycula. Chayćhu tuquicta licaycul-lämi quirila ");
INSERT INTO qvwNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","masqui isquirbishancunapïta Jesus śhalcamunanta manalä tantialpulpis. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaypïtam capäcunancäman cuticalcämula. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariañatacmi pampaläśhancäpa puncunćhu wa'ayäla. Chaynu wa'ayalmi lulicta ancuycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Licalpuśhanćhümi ishcay yulä-cama müdanayu anjilcuna aya ćhulaläśhancäpa saytanćhu umanćhu täcuyalcäta licälun. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chay anjilcunämi: “Mamay, ¿imapïtan wa'ayanqui?” nin. Niptinmi Maria: “Taytäta chincalächishanpïtamari. Manam yaćhallächu mayman apälälishantapis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nilpuyal muyulcuśhanćhümi Jesusta śhäcuyäta licälun. Jinalpis Jesus caśhanta manam lisilachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chayćhu Jesusñatacmi: “Mamay, ¿imapïtan wa'ayanqui? ¿Mayantam ashiyanqui?” nin. Niptinmi Mariañatac “Wirta täpäcäćhá tapuyäman” nil “Am aśhuchil'a niycallämay, taytay, mayman aśhuchishayquitapis apacunäpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Niptinmi Jesus: “Maria” nin. Śhutinta limalïluptinmi muyulcul “¡Yaćhachicü taytalláy!” nin. (Israel limayninćhu'a “Rabuni” nilam.) ");
INSERT INTO qvwNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesusñatacmi: “Caćhaycamaylä; Taytäman manalämi cutïchu. Aśhwanpa irmänücunaman cutilcul: ‘Cutiyäñam amcunapapis ya'apapis Taytanchicman, amcunapapis ya'apapis Diosninchicman’ nil willaycamuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nïluptinmi Magdalapi Maria pasacun Jesuspa yaćhapacünincunaman, quiquin licaśhancätawan, pay nishancunäta willaycü. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay simänap allaycuynin muyuncälläćhütacmi aspilpuyña yaćhapacünincuna juntunacälälisha cayalcäla wasictapis sumä wićhacälälisha Israelcunäta manchacuypi. Chaynu cayaptinmi paycunap ćhawpinćhu Jesus licalilcul “¿Allinllachun? Jawcalla capäcuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nilculmi maquintawan wätanta licachila. Yaćhapacünincunañatacmi Jesusta licälälil sumä-sumäta cushicälälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chayćhu Jesusñatacmi yapa: “Jawcalla capäcuy. Maynümi Taytá ya'acta caćhamäla, chaynümi amcunactapis caćhapäcuc” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nilculmi paycunaman jäcaycula: “Chuya Ispirituctam ćhasquipäcunqui. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ñatac mayantapis pampachaycuśhayquicá pampachaycuśhañam can'a; mana pampachaycuśhayquiñatacmi ichá mana pampachaycuśhachu can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ñatac Jesus ćhämunanpä chay ćhunca ishcayniyu yaćhapacü-masincunapïta “Awachap” lisipäcuśhan Tomas'a, manam calachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chaymi yaćhapacü-masincuna: “Jesusninchicta licälälïmi” nipäcuptin Tomas: “Maquinćhu läbu ućhcuśhancätawan, wätanćhu ućhcuśhanta ñawïwan licaycul dïdüta maquïta śhatiyculmi ichá quirïman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chay pusä muyunpïtañatacmi yaćhapacünincuna yapa juntunacälälisha chay wasićhu cayalcäla. Chayćhümi ichá Tomaspis cayäla. Chaynu puncu sumä wićhalayaptinpis Jesus'a paycunap ćhawpinćhu licalilculmi: “¿Allinllachun? Jawcalla capäcuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nilculmi Tomasta: “Śhamuy cay maquïta licaycuy-ari; cay wätämanpis maquiquita śhatiycuy. ¡Amaña ishcayyaychu! ¡Chalapacuy-ari!” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Niptinmi Tomas: “¡Aw Taytallämi Diosnillämi rasunpa callanqui!” nïlun. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Niptinmi Jesus: “Canan licämalmi chalapacamanqui. Ñatac maynu sumä cushicuymi mana licallalpis chalapacücunäpá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ñatac Jesus yaćhapacünincunap ñawquin achca milagrucunactam lulala. Chaycuna cay librućhu manam isquirbishachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Caycunactam ichá isquirbilá Diospa Caćhamuśhan Salbacüca, Caćhamuśhan Chulinca Jesusninchic caśhanta tantianayquipä, jinal ćhasquicücunaca wiñay cawsayniyu capäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaypïtam Tiberias ućhap patanćhu yaćhapacünincuna cayaptin Jesus licalïla. Caynümi pasala. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chayćhu cayalcäla Simon Pedro, “Awachap” lisipäcuśhan Tomas, Galileap Caná malcanpi Natanael, Zebedeop chulincuna, jinaman Jesuspa ishcay yaćhapacünincunapis. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Chayćhümi Simon Pedro: “Má, challwa chalä lishä” nin. Niptinmi llapanpis: “Ya'acunawanpis lishun-ari” nicuyalcan. Chaymi juc barcuman lluy ishpipäcula. Chayćhümi chay jinantin tuta mana ima challwallactapis chalapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ñä achicalpuyaptinñam ućha patanćhu Jesus licalïlun. Yaćhapacünincunañatacmi ichá pay caśhanta mana yaćhapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chayćhümi Jesus: “Walaśhcuna ¿manachun imallactapis chalapäcunqui?” nin. Niptinmi: “Manamari” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Niptinmi: “Barcup allïnin-läduman challwa chalacuyquita jitayculmi chalapäcunqui” nin. Chaynu jitalpäläliptinmi challwa chalacunman laćhyay-laćhyay juntälun chutaytapis mana atipapäcunancama. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chaymi Jesuspa cuyaśhan yaćhapacünin Pedrocta nin: “¡Jesusninchicmari!” nil. Chayta uyalïlul-pachallam Pedro lluśhticüśhan müdananta caśhan ćhulaculcul ućhäman ji'acalpun. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chay juc yaćhapacü-masincunañatacmi challwa chalacun ćhipuy-ćhipuy challwan aysacälälisha barcuwan ućhap patanman ćhälälimun. Chaypi paćhac mitru-yupaylämi patanman yalapämunanpä cala. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chayman ćhaycamul ji'alpapämulmi nina walayäpa jananćhu challwa cancaywan, tanta cayäta talïlälin. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jinaptinmi Jesus: “Challwa chalapämuśhayquipi juc ishcayta apapämuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Niptinmi Simon Pedroñatac barcuman lilcul challwa chalaśhancäta ućhap patanman aysämun. Chayćhu paćhac picha ćhunca quimsayu (153) jatućhaćhä-camallam cacuñä. Chaynu achca-achca cayaptinpis challwa chalacun manam laćhyalachu. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chayćhu Jesusñatacmi: “Śhapämuy micapäcunayquipä” nin. Chayćhu quiquin Jesus caśhanta tantiapäculmi mayanninpis mana tapućhaculcälachu “¿Pim cayanqui?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chaypïtam Jesus challwätawan tantäta paycunaman aypuycula. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Caywanmari śhalcamuśhanpïta Jesus quimsa cutiña yaćhapacünincunaman licalïla. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Chay micuyta camacalculmi Jesus nin: “Jonaspa chulin Simon, ¿lluypïtapis mastalächun cuyamanqui?” nil. Niptinmi: “Taytay, am yaćhanquim maynu cuyaśhacta” nin. Niptinmi: “Chayurá uwishnïcunactari michiy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chaypïta yapa tapun: “Jonaspa chulin Simon, ¿rasunpachun cuyamanqui?” nil. Niptinmi Pedro: “Taytay, am yaćhanquim maynu cuyaśhacta” nin. Niptinmi: “Chayurá uwishnïcunactari licaycuy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Chaypi quimsa cutictaña tapun: “¿Jonaspa chulin Simon, cuyamanquichun?” nil. Chaynu quimsa cutictaña tapuptinmi Pedro llaquisha: “Am taytay, lluytamari yaćhanqui; cuyaśhätapis yaćhanquim” nin. Niptinmi Jesus: “Chayurá uwishnïtari michiy. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","19","Rasunpa, müsu cayal'a tuquiy-tuquiymi müdapaculanqui mayta linayquipäpis. Ñatac awquishña cayal'a liclayquita chacchalcuptiquim, juccuna ćhänaśhunqui. Jinalculmi mana liyta munaśhayquicunäman puśhaśhunqui” nin. Cay nishanwan tantiachila Pedro imanuypa wañuśha cananpä, chaynütac wañuyninwan Diosta altuman juluycuśha cananpämi. Chaypïtam “Chayurá canan, má, atimay-ari” nin ");
INSERT INTO qvwNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ñatac Pedro muyulcuśhanćhümi licälun Jesuspa cuyaśhan yaćhapacüninpis atiyämüta. (Pay'a sinaycälishanćhu Jesuspa matällanćhu cayal “¿Pitan ipanchäśhunqui?” nïcämi.) ");
INSERT INTO qvwNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Payta licälulmi Pedro: “Taytay, caytá ¿imam pasälun'a?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Niptinmi Jesus: “Ya'a munapti'a cutimuynïcamapis cawsanmanmi. Chaycuna ¿imam ucuśhunqui? Am atimay jinalla” nin. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chaymi jinantin chalapacücunäman “Imaycamapis cawsan'am” nï limay ćhäla. Ñatac Jesus'a manam “Imaycamapis cawsan'am” nilachu, sinu'a “Cutimunäcamapis munapti'a cawsanmanmi. Chaycuna ¿imam ucuśhunqui?” nilam. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Cay quiquin cuyaśhan ya'a yaćhapacüninmi, ñawïwan licaśhäta, uyalishäta rasunpa caśhanta tuquicta yaćhal isquirbiycamú. ");
INSERT INTO qvwNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ñatac Jesus'a may-chicactaćh allincäta lulaycula. Manyapi isquirbipti'a manaćh jinantin pachäćhu papilcunäpis camanmanchu. Chaynu cachun. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Cuyaśhá Teofilo, ¿manachun puntacta isquirbimul Jesus lulaśhanta yaćhachishanta manyallapi willalac allaycuyninpi janay pachäta cuticunancama? Chayćhu Chuya Ispiritup munayninwan puydï yaćhapacünincunacta imaymanacta lulapäcunanpä nilculmi janay pachäta cuticula nishac-yupaypis. ˻Cananmi masta willaycuśhayqui.˼ ");
INSERT INTO qvwNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Paymi wañuśhanpi śhalcamul aclaśhan yaćhapacünincunawan cayal rasunpa pay cawsamüśhanta imaymanap tantialpachila. Chayćhümi tawa ćhunca muyuncuna Diospa gubirnunpïtapis yaćhachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cusca cayalcalñatacmi “Cay Jerusalenpïta amalämi yalapäcunquichu aśhta Taytá limalicuśhan Chuya Ispiritunta caćhamunancama nishac-yupaypis. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yaćhaśhanchicnüpis Juan'a yacullawanmi bawtisala. Ñatac Taytämi ichá cay muyuncunäćhu quiquinpa Chuya Ispiritunwan bawtisapäcuśhunqui duyñuchacuycuśhunayquipä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Niptinmi tapupäcula: “Taytay, ¿Roma nasyunpa maquinpi julalcälimaptiqui quiquillanchic Israelcunällaña mandanacunapä ürañachun ćhämun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Niptinmi: “Chay unanchaśhan timpucunacá Taytalläpa maquillanćhümi cayan. Amcuná manam yaćhaycälinayquichu. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aśhwanpa cayta umayquiman ćhulapäcuy: amcunacta Chuya Ispiritu bawtisapäcuśhuptiquim duyñuchacuycul munayninta upäcuśhunqui willacüní capäcunayquipä cay Jerusalen malcäćhu, Judeap, Samariap malcancunaćhüpis aśhta sïlup sapinćhu cä malcacunämanpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lluy caycunacta nilcuptinmi paycunap ñawquin altu sïlüta puśhacuptin pucutay śhun'unman chincacuycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chayta licapayalcaptinmi paycunap lädunćhu ishcay umri yulä-cama müdanayu licalïlun. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jinalculmi nipäcula: “Galilea nunacuna, ¿sïlüta imapïtan caynüpa anśhalayalcanqui? Cay licaśhayquinümi juc-pun cay pachäman Jesus caśhan cutimun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chay nilcuptinmi yaćhapacünincunaca cuticalcämula Ulibus ulüpi Jerusalenman. (Chay ulüpi Jerusalencama custumrinmannuy warda muyunćhu pirmitisha puliycuyllam cala.) ");
INSERT INTO qvwNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chaypi ćhaycamulmi jamaculcäśhan wasi altuśhman ishpipäcula. Paycunam capäcula Pedro, Jacobo, Juan, Andres, Felipe, Tomas, Bartolomé, Mateo, Alfeop chulin Jacobo, malcanpi limatälï Simon, Jacobop chulin Judas. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Paycunawan cuscam Jesuspa maman Mariapis, śhullcancunapis, ñatac Jesusta cumpañamü walmicunäwanpis juntunaculcäla Diosta imaypis ruygaculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay muyuncunaćhümi paćhac ishcay ćhunca chalapacücuna juntunaculcäla. Chayćhümi ćhawpiman śhaycucuycul Pedro nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“Tayta mamacuna, yaćhaśhanchicnüpis Judas'a cala ya'anchicwan pulïmi. Jinalmi imapis lulayninchicćhu lulawshimälanchic. Jinayalpis Jesustam chalaycachila chay ćhïnïnin nunacunäman. Ñatac caycuna pasananta unaypïñam Chuya Ispiritu willamälanchic. Chaymi David Salmos librunćhu caynu nila Judaspi: ‘Chay nunap wasinta quiquin Dios mana cäman muyuchichun. Jinaptin imaycamapis pulumächun’ nil. “Cay nishannümi rasunpa lulaśha cala” nila. (Chayshi Jesusta chalachishan illaycäwan juc ćhaclacta lantisha cala. Jinalculshi quiquin ćhacläćhu Judas umanpa palpülun alashquinpis lluy lawacacunancama. Cayta yaćhälälilshi canan Jerusalen nunacunaca chay ćhaclacta “Asildama” nil nipäcun. “Asildama” ninan'a “yawarpa ćhanin ćhacla” ninanmi.) Pedroñatacmi nila: “Chay isquirbishanćhüpis: ‘Chay nunap pudirnin juc yaycuchun’ niyanmi. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Chayurá chaynu niyaptin'a canan-ari aclaśhun Judaspa pudirnin mayan cananpäpis. Chaypá canman imaypis Jesuswan cusca puliwshï-masinchiccunam. Aclaśhun mayantapis Jesus bawtisachiculcul pulï allaycuśhanpi canan sïlüman cuticunancama ya'anchicwan cusca cäcunäpi. Chayćha ya'anchicwan cusca ‘Jesus cawsamütam licalá’ nil willacuyta apaycaćhan'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nilculmi ishcay nunacunacta unanchapäcula Matiastawan, José Barsabas nishan Justucta. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Jinalculmi Diosta ruygaculcäla: “Taytay, anmi llapäpa śhun'ulläcunactapis lisinqui. Judas'a cay lulayniquita ipanchalcul juchacta lulaśhanwanmi alcaśhan wañuycäman quiquillan palpülun. Canan anmá yaćhanqui paypa pudirninta aclaycunayquitapis ya'acunawan cusca lulapäcunäpä. Canan-ari cay ishcayninpi mayannin canantapis yaćhaycälichimay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nilcul mayannin cananpäpis chüsanacuptinmi Matiasman tücälun. Chay ürapïmi chay ćhunca jucniyu puydï yaćhapacünincunap masanninña cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ñä chay Cusicha Fista ćhämunanpämi aycam Jesusman chalapacücuna jucllaćhu lluy juntulayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chaynu cayalcaptinmi altu sïlüpi un'aypi ji'alpämun manchachicuy bintup sumbayninnu bululunyaśhtin. Chayćhümi juntuläśhan wasïta bululunyayca ñiticalpula. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jinaptinmi ninap sumbayninnu licalilcamul wichicacüla aycam chayćhu cäcäpa janäninman. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jinaptinmi Chuya Ispiritu duyñuchacüluptin mana lisishan limaycunacta shimin paćhyachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ñatac chay fistamanmi may nasyuncunapïpis ćhämuśha cayalcäla custumrincunacta cumplï Israel nunacunaca. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chayćhu chay bululunyaycäta uyalïlälilmi chay wasiman lluypis paćhcatityälälimula “¿Imatá cay?” nil. Chayćhümi chay śhamü nunacunap limaynincunäćhü-cama limayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Chaymi licapayllaman camäśha ninacücuyalcan: “¡¿Ima?! Caycuna Galilea nunacuna cayalcal ¿imanuypatan llapanchicpa limayninchicćhu limacuyalcanman? ");
INSERT INTO qvwNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Cayćhu cayanchic intiru-intiru nasyuncunapïmari: Parto-lädu nunacuna, Medo-läducuna, Elamcuna, Mesopotamiacuna, Judeacuna, Capadociacuna, Pontocuna, Asia-lädu nasyunpa malcancuna, ");
INSERT INTO qvwNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Frigiacuna, Panfiliacuna, Egiptocuna, Cirene-lädunćhu cä Libya malcancunäpis. Chaynütac cayalcan Romapïpis, Cretapïpis, aśhta Arabiapi śhamücunapis. Chaynütacmi cayalcan custumrinchicta atichimänanchicpä yaycamü juc-lädu nunacunapis. ¡Cay limayninchicćhü-cama canan mishqui-mishquicta Diosninchic lulaśhancunäpi lluymi uyaliyanchic!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nilcälilmi sumä licapayllaman camäśha: “¡¿Imatan cay?!” nïllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Waquincunañatacmi: “Caycuná shincalculćhari jäjayalcan” nil asipapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chaynu jinayalcaptinmi ćhunca yaćhapacü-masincunawan śhalcuculcul Pedro nila: “Llapallayquipis Israel-masïcuna, ñatac cay Jerusalenćhu yaćhäcuna, canan cay nishäta uyalil tuquicta intindipämay. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","‘Shincäśham’ niyalcaptiquipis manam chaynüchu. ¿Maynüpam ampá uywa alucuy ürallalä shincaśha cayalcan'a? ");
INSERT INTO qvwNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Aśhwanpa caycuna pasayan Diospa unay willacünin Joel ‘Diospa Ispiritunmi śhamun'a’ nil nishannümi. Paymi caynüta nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tayta Diosninchicmi caynüta nin: “Camacä timpucunaćhu Ispiritütam caćhalpämuśhä jinantin allpäćhu cä nunacunäman. Jinaycuptïmi amcunap wawiquicuna chuliquicuna ya'a partipi liman'a. Llapa müsucunäñatacmi licchayal ya'a cüsapïta lican'a. Awquishcunäñatacmi suyñuynincunaćhu ya'api yaćhapäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chay muyuncunaćhümi llapa uyway nunäcunamanpis, ya'apïta limapäcunanpä Ispiritüta uycuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Taytayqui manaläpis cutilmi chay jatun llaquicuy muyunćhu altu sïlućhu imacunactapis ya'a licachishayqui. Chayćhümi intïpis wañun'a. Quilläpis yawarmannuy muyun'a. Cay allpäćhüñatacmi yawarlla, ninalla, pucutaynu untaylla cacun'a. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ñatac ya'acta lluy ayacamäcunämi salbaycuśha capäcun'a” ’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel malca-masïcuna, sumäta uyalipämay. Diosmi rasunpa tantiachimanchic amcunaćhu yaćhä Nazaret Jesus allin nuna caśhanta sumä-cama lulaynincunawan. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jinaman'a unaypïñam quiquin Diosninchic caycuna juccuna pasananpäpis lluy pinsaśha cala. Chaymari amcunacta caćhaycapäcuśhulanqui chalalcul aysapäcunayquipä, jinalcul chay juchanllan nunacunaca curuśhman chacatal wañuchipäcunanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jinäläliptinpis quiquin Diosmi chay ñacaynincunapi wañuycäpïpis laquil śhalcachimula. Payta wañuycäpis manamá chalalanmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Unay mandäninchic David paypïta limala cay nil: ‘Ya'a imaypis Duyñüta licayá ñawpänïćhümi. Manam imapis śhun'üta cuyulichiman'achu pay lädüćhu cayaptin'a. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chaymi śhun'ullá cushicun; shimillá paypi taquin. Cawsacuśhä payman chalapacullalćha. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Am'a cay aychäta manamá allpa śhun'unćhüchu caćhaycamanqui. Nïtac Chuya Aclacuśhayqui nunayquip aychá ismuycunantá cunsintinquichu. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Anmi lisichimälanqui cawsay caminucta. Chayćha ampa ñawpäniquićhu sumä cushishalla cacuśhä’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Malca-masïcuna, yaćhaśhanchicnüpis unay awilunchic David wañuculam. Jinaptinmi imam pampacuśhanchicćhu jinalla canancamapis pampalayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ñatac willacünin cayalmá, Diosninchicpa limalicuśhanta yaćhala ‘Ampa caśhtayquipïmi malcap mas puydï mandäninpä ćhulaycuśhä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“Chaynu Diospa willacünin cayalmi Caćhaśhan Salbacüpa śhalcamunanta licayä-yupay limala ‘Aychanta manamá allpa śhun'unćhüchu caćhaycunqui. Nïtac aychan allpaman muyun'achu’ nil. Cay nishanwan David'a rasunpa limayäla Jesuspïmi. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Canan'a quiquin Diosninchic śhalcachishanta lluypapis ñawinchic licalam. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","35","Jinamanmi Diospa lädunman ishpil canan alawäśha rispitäśha pay cayan. “David'a manamá Diospi Salbacücächu cala cuirpuntin sïlüta ishpinanpä. Sinu'a Jesuspïmi aśhwanpa nin: ‘Diosninchicmi munayniyu Duyñüta nin: “Cay-lädulläman taycaycamuy ćhïnishüniquicunäta maquiquiman ćhulaycamunäcama wiñay simpri uyshuycälishunayquipä” ’ nil. “Canan'a Tayta Diosmi Ispiritunta caćhamunanpä limalicuśhannuy Jesuswan caćhächimun. Cay nishancätam ñawpäniquićhu canan amcuna licayalcanqui uyaliyalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Canan llapa Israelcuna umayquiman sumäta ćhulapäcuy: Quiquin Diosninchicmi wañuchipäcuśhayqui Jesuspi ‘Paymi sumä Tayta Taytaca ñatac Salbacüniqui cayan’ nil niycälishunqui” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cay shiminpi yalamuśhan limayca chayćhu llapa juntuläcunäpa śhun'untapis tipship-tipshiycachiptinmi Pedroctawan masannintinta tapucula: “Taytacuna, ¿imactatan lulapäcüman?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Niptinmi Pedro: “Mana allin lulayniquicunapi wanacul ‘Juchäcunacta pampachaycallämay. Cananpïtá Salbacü Jesuspa uywayninñam caśhä’ nilcul bawtisachiculcay. Jinaptiquim Diosninchic quiquinpa Chuya Ispiritunta uycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Cay limalicuśhanca amcunapä, chuliquicunapä, mayćhu chayćhüpis lluy ayacuśhancunapäwantacmari cayan” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Caycunactawan juc limaycunacta limalculmi anyanacula: “Cay mana allin timpućhu lulaycunäpi japächaculcayña” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Chay niptinmi mayanpis uyalicücá chayćhu bawtisachicula. Chaymi paycunaman quimsa walanga nunacuna chaypun yaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chaypïtañatacmi puydï yaćhapacücunäpa yaćhachishanta masïsu chalalal atichipäcula. Chaynütacmi juc-yupaylla cawsapäcula, wäćhanaculcälapis, jinaman Diosta mañacümi capäculapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Chay muyuncunaćhüpis puydï yaćhapacünincuna imaymana milagrucunactam lulayalcäla. Chay lluy imapis lulapäcuśhanta chalapacücuna licalculmi: “¡Manamari caynütá imaypis licalanchicchu!” nil ninaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Chayćhümi ima cänincunactapis llapallan camachinaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jinamanmi cänincunacta lanticulcul pishipacünincunawan'a camachinacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Chaynüpam juc-yupaylla capäcula. Chaymi llapanpis muyun-muyun Diospa chuya wasinpa patyuncunaćhu juntunaculcäla Diosta alawaculcänanpä. Chaynütacmi wasincunaćhüpis cumbidanacul lluypis cushisha-cama Diosta anradisicul micapäcula. Lluy caycunacta lulapäcuśhanpam malcantin nunacunäpis alawapäcula. Chayćhümi muyun muyunpis Tayta Dios munacuśhanmannuy chalapacünincunacta milachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc muyun Pedrowan Juanmi liyalcäla Diospa chuya wasinta tardi mishquipay üranuy Diosta mañaculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chayćhümi nasïdunpi juc wishtu nuna limuśhnacta mañapacuyäñä. Chay umrish Diospa chuya wasinpa Tuquish Sawan nishan puncunman muyun-muyunpis apaśha cala. Chayćhu täcuyalshi llapa yaycücunacta mañapacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chayćhümi Pedrowan Juan allin yaycuycuyaptin “Limuśhnallayqui taytay” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Niptinmi paycuna allicta licapaycälil: “¡Taytay!” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Niptinmi chay nunaca “¿Imallactaćhá uycalläman'a?” niycänuy anśhaläcuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jinaptinmi: “Manam illayniyüchu nï üruyüchu capäcú uycälinacpä. Sinu'a cay nishälläwan yanapaycuśhayqui: Nazaret Jesus Salbacücäpa pudirnin caynïwan, śhalcul puliy-ari” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nilculmi allï maquipi aysalcuptin intiru ćhaqui tulluncuna masïsu tacyañä. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jinaptinmi chay üra paćhcalcünuy śhalculcul puliyta allaycula. Chaymi paycunacta chalacuśhanuy ji'acuycula chay wasi luliman Diosta cushicuypi alawaśhtin dansaycaćhaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Chaynu jinayäta licälälilmi Tuquish Sawan nisha puncunćhu mañapacü nunaca caśhanta lisïlälil “¿Imactatan licayanchic?” nil licapayllaman lluypis camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chay sänaśha wishtu Pedroctawan Juanta macallaycaćhaśhtin cushisha mana caćhaycul licuyaptinmi lluy nunacunäpis paćhcatityälälimun chay chuya wasićhu Salomonpa Patyun caśhancäman “¿Imam pasacuyan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chaynacuyalcaptinmi Pedro: “Israel-masïcuna ¿imapïmi caynüpa licapayllaman camäśha cacuyalcanqui? ‘Caycuna ichaćh quiquillanpa munayninwanpis ütac allin cayninwanćha wishtüta pulïchin’ niyalcanquipis. Manam chaynüchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","Sinu'a awquillunchiccunap Abrahampa, Isaacpa, Jacobpa ya'anchicpa Diosninchicmari uywaynin nunan Jesusta altuman juluyan. Cay mana juchayu nuna Diosninchicpa puntanćhüpis allin lulayniyu nuna captinpis amcunam muyucalcälilanqui. Jinalculmi Pilatop maquinman ćhulaycälilanqui. Pay caćhaycuyta munaptinpis amcunam mana munätuculcul aśhwanpa nuna wañuchicücäta caćhaycachipäculanqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Caynu jinalcälilmi quiquin cawsayta uycämäninchiccäta wañuchipäculanqui. Diosninchicñatacmi ichá chay wañuycäpïta śhalcachimula. Rasunpa caycunapïta ya'acunam licäca yaćhäca cayalcá. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Canan cayta yaćhapäcuy: Cay lluypis lisipäcuśhayqui wishtu umrica Jesusman chalapacuyninwanmi caynu śhalcüśha puliyan. Rasunpa chalapacuyninwanmari amcunap ñawpäniquićhu caynu tuqui sänu cayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Canan malca-masïcuna, rasunpa mayan caśhantapis mana tantialmi llapayquipis śhalcunacul llapa puydïniquicunawan wañuchipäculanqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ñatac cay lulayniquiwanmi lulacacüla Dios unay willacünincunawan cay: ‘Diospa Caćhamuśhan Salbacüca wañuchisham can'a’ nil nishanca. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Chaymi mana allin lulayniquicunapi wanaculcul Diosmanña filtacalcämuy juchayquicunacta pampachaycälishunayquipä. Jinaman Salbacü Jesusninchic cutimul śhun'uyquitapis quićhaycälishunayquipämi cay pachäpa allaycuyninpi śhuñacuśha cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ñatac canan'a janay pachäćhülämi cayan, Dios unay aclacuśhan willacünincunawan nichimuśhancänuy lluy lulaśha canancama. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","¿Manachun yalpapäcunqui Moises awquillunchiccunacta: ‘Tayta Diosninchicmi amcunapi juc willacüninta ya'actanüpis śhalcachimun'a. Payta juc shimilla cäsupäcuy ima nipäcuśhuśhayquitapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mayanpis mana cäsucücätá lluymi chincachisha can'a’ nil nishanta? Chaymi wanaculcänayqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ñatac Moisespis lluy Diospa willacünincunapis Samuelpïta allaycul puntamanmi limapäcula caynu lluy pasanancunapïta. ");
INSERT INTO qvwNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chaynütac Dios lluy willacünincunawan limalicuśhancunaca amcunapäwantacmi cayan. ¿Manachun yalpapäcunqui awquillunchiccunaćhu Abrahamta Dios limalicuśhanta: ‘Ampa milayniquiwanmi allincäta lulaśhä jinantin pachäćhu’ nil? ");
INSERT INTO qvwNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chaymi Dios chulinta wañuycäpi śhalcalcachil puntacta amcunaman caćhamula, allinpa licapäcuśhunayquipä, ñatac mana allin lulayniquicunacta caćhaycul payman filtapämunayquipäpis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Chaynu Pedrowan Juan llapa nunacunäta “Jesus wañuśhanpi śhalcämuśhañam” niyaptinmi sasirdüticunaca, Diospa chuya wasinpa täpänincunap puydïnincunaca, saduseo caśhtacunaca sumä rabyaśha-cama paćhcälälimula. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jinalculmi pasachiculcäla carsilman. Tardi cayaptinñatacmi chay wälacama wićhaycullalña caćhaycälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Chay uyalïcunäpïñatacmi ichá Jesusman achca chalapaculcäla. Chaymi chay chalapacücunäwan'a picha walangamanña wayapanllanlä milälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chay wälam lluy juntunacälälin chay Jerusalenćhu cä llapa puydïnincuna, prinsipal yaśhacuna, Moisespa camachicuyninta yaćhachicücunapis, ");
INSERT INTO qvwNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","sasirdüticunap mas puydïnin Anaspis, Caifaspis, Juanpis, Alejandropis, chaynütac chay caśhtancunäpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chaynu llapan juntunacuyculmi Pedroctawan Juanta puśhachimula. Jinalculmi llapanpa ñawpäninman śhaycacaycachil tapucuyalcan: “¿Ima pudirwanmá? ¿Mayantá caćhamuśhulanqui caynu lulaycaćhacuyalcänayquipä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Niptinmi Pedro Diospa Ispiritunpa lluy munayninćhu cayal: “Malcap puydïnin taytacuna, Israelpa prinsipal yaśhancuna: ");
INSERT INTO qvwNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Imapïtá amcuna tapucayalcämanqui cay wishtu nunawan allinta lulaycuptí mana allin lulayä-yupayta? ");
INSERT INTO qvwNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Rasunpa imanuypa sänaśhanta yaćhayta munal'a yaćhapäcuy llapayquipis, jinantin Israelcunäpis cayta: Nazaret Jesus Salbacücäpa munayninwanmá cay wishtuca lluypa ñawinchicćhu śhalcula. Cay chacatapäcuśhayqui Jesustam quiquin Dios śhalcachimula. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Paypïmi Salmos librućhüpis limayan: ‘Wasi luläcuna, jalutacuśhayqui lumim mas allin puydï chaläninmanlä muyüñä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Salbamäninchic'a manamá juc canchu. Manam Tayta Diosninchic'a juctá ćhulalachu cay jinantin allpäman salbamänanchicpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chayćhu Pedrowan Juan cay-nilälla calpis cäninman-cama mana manchalil limayninwanmi, chay puydï nunacunäta upällachila. Jinaptinmi lluypis licapayllaman camälälisha: “Caycuná Jesuswanmi rasunpa capäcula” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chayćhu imacta ninanpä chay sänachishan nunapis cayaptinmi mana imamanpis artiyta atipapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mana atipaculculñatacmi Pedroctawan Juanta waśhaman yalalcachil, quiquin-pulalla ninaculcäla: ");
INSERT INTO qvwNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Cay umricunäta ¿imanäśhunmi cay jinantin Jerusalen malcaca sumä jatun lulaśhanta licayalcaptin'a? ");
INSERT INTO qvwNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Caycunacta manaña cürricaćhayächinanpä lluy aminasaśhun Jesuspi uchucllapis cananpi manaña limalcapäcunanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ninacalcälilmi caśhan ayaycul: “¡Yan'al-lätac chay Jesuspïta cananpi limalcuyalcanquiman yaćhayalcächinquiman!” nil aminasälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Niptinmi Pedrowan Juan nila: “Má, canan nipämay. Amcunapïtá mayannintatan Diosninchic'a munanman: ¿amcunacta cäsunätachun ichá payta cäsunätachun? ");
INSERT INTO qvwNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ya'acuná cay ñawïwan licapäcuśhäcätá, linlïwan uyalipäcuśhäcäpi'a manam shimí wićhacacüśha quïdanmanchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Niptinmi: “¿Imanäśhunmá? Cay-chica nuna ñawinchicćhu cay tawa ćhunca watayu wishtu nunäta sänachishanpi lluypis Diosta alawaśhtin bïbayalcanmari” ninaculcul mastalä aminasälälin. Jinalcul mana imanaytapis atipacalcälilmi caćhaycälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chaynu caćhaycüluptin Pedrowan Juan chalapacü-masincunaman ćhaycälilmi chay prinsipal yaśhacunaca imacta nishantapis willapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chayta uyalïlälilmi Diosta llapallan ruygaculcäla cay nil: “Sumä Munayniyu Taytay, anmi lluyta camalanqui, sïlüta allpäta lamarcäta llapa imapis cänintinta. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ñatac sirbïniqui unay awilú Davidpa shiminpam Chuya Ispirituyqui limamula: ‘¿Ima cäñatan llapa malcapis cuntrayqui śhalcapämunanpä? ¿Imañatan mana rasunninwan pinsaycul cuntrayqui yan'alpä lulapäcun? ");
INSERT INTO qvwNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jinalcul llapa puydï mandacücuna, jinantin nasyuncunap mandacünincuna jucllachanacaycälil amtawan Śhuñacuśhayquitam cuntrapäcuśhunqui’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Rasunpa cay malcäćhu Herodeswan Poncio Pilatowan Israelcunaca mana-Israelcunäwan jucllachanacaycälilmi Śhuñacuśhayqui Chuya Chuliqui Jesuspa cuntran śhalcapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Rasunpa cay lulaśhanwan'a unaypïña caycuna pasananpä nichishayquitamá lluy lulälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Canan-ari Tayta Diosní, uyaliycuy aminasacuyninta. Jinal ya'a sirbïniquicunacta yanapaycälimay mana manchalil ampïta willaculcänäpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jinaman'a Chuya Chuliqui Jesuspa pudirnin cayalcapti'a, munayta uycälimay ishyäcunacta sänaycälichinäpä, ñatac milagrucunacta lulaycälinäpäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chaynu ruygaculcaptinmi chay juntuläśhan wasica śhaśhälun. Jinaptin chayćhu cäcunaca Chuya Ispiritup lluy munayninćhu licalïlälilmi cullucuycul Diospïta willaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Chayćhu puydï yaćhapacücunaca “Jesusmi rasunpa cawsamun” nil willaculcäla mana imactapis manchalillal. Lluy chalapacücunäñatacmi juc pinsaylla, lulaylla cawsapäcuptin llapa nunacunäpis istimapäcul, rispitapäcul allinpa licapäcula. Chalapacücunaca quiquillanpä mana chalat-chalatyayä capäculmi ima cänintapis lluy camachinacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Chay chalapacücuna-pulamari wasinta ütac ćhaclanta lanticulculpis illaycäta uycula puydï yaćhapacücunäman nisitäśhanpa lluymanpis camaycachinanpä. Jinaptinmi paycunaćhu nï juc wacchapis calachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chaynütam lulala José śhutiyu nunapis. Paymi lamar ćhawpićhu Chipre malcapi, Levïpa ayllun cala. Paytam puydï yaćhapacücunaca Bernabëwan śhutichapäcula. (Bernabé ninan'a “llaquipayniyu nuna” ninanmi.) ");
INSERT INTO qvwNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Paymi ćhaclanta lanticulcul lluy ćhaninta puydï yaćhapacücunäman uycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chaynütacmi Ananiaspis walmin Safirawan ćhaclanta lanticälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Chaynu lanticulculmi pulanpïpis yaćhachinacaycälil parti illayta quïdacaycälichin. Jinalculmi puydï yaćhapacücunäman partillactaña Ananias apamuñä “Cayllaćhümi lanticälälí” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chayćhümi Pedro nila: “Ananias, ¿imatá pasäśhunqui, Satanaśhwan gänachiculcul, parti illayta quïdacaycachil Chuya Ispiritucta artipänayquipä? ");
INSERT INTO qvwNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Chay ćhacla ampaćh cala. Chay lanticuśhayqui illaycäpis ampatacćha cala. Chaynu cayaptinchun ¿chayta lulanquiman? Manam nunactachu casquipälunqui sinu'a quiquin Diostam” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chay niptinmi Ananias juclla pampäman wañüśha ćhaćhälun. Chaycuna lluy pasäluptinmi mayanpis yaćhäcunaca manchaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chaynu chayćhu jitalayaptinmi müsucuna śhalcamul ayäta pitwilcul pampamü apaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chaynu pasäśha cayaptinmi quimsa ürapïtanuy'a walmin Safirapis lluy chaycunacta mana yaćhal yaycämun. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chayćhümi Pedro tapula: “Safira, má nimay ¿chayllaćhüchun rasunpa lanticulcälanqui?” nil. Niptinmi: “Aw, chayllaćhümari lanticälälilá” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Niptinmi: “¿Imapïtan pulayqui yaćhachinacuycul ‘Dios'a, má, ¿imanämäśhunshi?’ nilcul cayta lulapäcunqui? Licay wayapayquita pampäcunaca caytaña cutiyalcämun, amtapis pampapämuśhunayquipä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chaynu niyällaptinmi Pedrop ćhaquinman Safirapis wañüśha ćhaćhälun. Chayćhu wañüśhacta chay müsucunaca talilculmi pasachiculcäla wayapanpa lädunman pampaycälimü. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Cay pasaśhancunacta lluy mayanpis uyalïcunämi ñatac Jesusman chalapacücunämi chay pasaśhancunapi manchaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chay muyuncunaćhümi puydï yaćhapacücuna milagrucunacta, allin lulaycunacta lulapäcula. Diospa chuya wasinćhu Salomonpa patyun nishanćhümi chalapacücunaca imaypis juntunaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mana chalapacücunañatacmi ichá chayćhu mana paycunawan capäculpis allin rispïtuwan licapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chaymi chalapacücunaca muyun-muyun achcaman umripis walmipis milapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jinaman'a lluy nunacunaca ishyänincunacta chacanaćhu ütac cämantintapis julapämula “Icha Pedrop llantuyllanpis ćhaptin sänälunman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Chaynütacmi juc malcacunapïpis Jerusalenman ishyänincunacta, Satanaśhpa turmintäśha nunacunactapis apapämuptin lluy sänäśha cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Chaynu achcaña cacuyäśhanta licalcul puydï sasirdütiwan saduseocuna masannincunawan śhun'unćhu imbidicuylla timpucuyaptinmi puydï yaćhapacücunäta carsilman apaycälächin. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Masqui chaynu wićhächiptinpis chay tutam Diospa anjilnin śhalcamul carsilta quićhaycul julüla. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Chaynayculmi nila: “Canan Diospa chuya wasinman lil Jesus muśhü cawsayta uycuśhanpi willamuy” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chaynu niptinmi anjil nishannuy chay wäla-wälalla lilcul willacamula. Chaynu cayaptinmi chay puydï sasirdütica puydï-masincunawan Cunsïju puydïnincunacta juntunacaycachil carsilcäta caćhala puśhachimunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Chay puśhamücunaca ćhänanpäshi carsilćhu nï wälañächu. Jinaptinshi cutilcamul-pacha nipäcun: ");
INSERT INTO qvwNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Imam caćhaycamuśhayquinümi wardiacunapis täpalcäña. Jina lläbiycachishallayquinümi masïsu lläbilayäñä. Ñatac lulicta yaycapäcunäpämi nï mayanpis cañächu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Niptinmi puydï sasirdüticunäwan täpäcunäpa puydïninca “¿Imamanćha ćhälun'apis?” ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chaynu ninacuyalcaptinmi ćhämun juc nuna: “Carsilman wićhachishayquicá chuya wasip puncunćhu-ari jinantin nunäta willapayan” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Niptin-pacha puydï wardiacuna puśhamü pasaculcalmi talïlälil “Tupaycuśhá yan'almi cay-chica nuná tamshämachwanpis” nil tuquillap puśhapämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chay Cunsïjup ñawpäninman ćhächiptinñatacmi puydï sasirdütica nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ćhuncay-ćhuncay ‘Amam cananpi chay Jesuspi limalcälinquipischu’ niyalcaptïpis ¿canan imactatá lulayalcanqui? Caynu ardïdi äśhaycaćhayalcanqui jinantin Jerusalen nunacunaca chay nunap wañuyninpi juchachapämänanpämá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Niptinmi Pedropis masannincunapis nipäcula: “¿Diosnïta ipanchalcul nunätalächun ampá cäsucuyalcäman, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","Amcunamari Jesusta chacataycul wañuyalcächinqui. Jinaptiquipis unay awilunchiccunap Diosninmi caśhan śhalcachimula. Jinalculmi lädunman taycaycachin sumä Puydïpä sumä Salbacüpä, Israel malcaca Diosman licaćhacuptin, juchancunapis pampachäśha cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ya'acunam caycunapi ñawïwan licäca cayalcá Chuya Ispiritu yaćhaśhan-yupaypis. Ñatac Dios'a Ispiritunta uycun mayanpis cäsüninmanmi. Chaymi nipämäśhan-yupaypis lulayalcá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Niptinmi chayćhu sumä-sumä rabyäśha wañuchiyta munacuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ñatac paycunap cumpañäninmi cañä juc Gamaliel śhutiyu fariseo caśhta nuna. Paymi camachicuyta yaćhachï, malcap rispitäśha cala. Pay śhalculculmi waśhaman nunacunäta yalalcachil nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“Israel-masïcuna, sumäta pinsaycäliy cay nunacunäwan imacta lulay pinsapäcuśhayquitapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Yalpapäcunquichun ‘Ya'am puydïninca cacuyá’ nil Teudas nunaca unay śhalcuśhanta? Chaynu śhalcuptin ¿manachun tawa paćhac nunacunaña śhalcünin cacuyan? Jinaptin chay Teudasta wañüchiptin ¿manachun chay nunancuna chi'icalcul chincaculcan? Licay chayćhümari yaćhaśhanchicnüpis camacäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chaypïtá ¿manachun Galilea malcäpi Judaspis chaynütac sinsu timpućhu śhalcätucämun? Chaytapis ¿manachun achca nunacuna śhalcucuyalcan; chaypi Judasta wañüchiptin'a llapa nunanpis chincayman ćhulaculcul chincaculcan? ");
INSERT INTO qvwNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chayta yalpaćhaculmi ya'a canan nipäcuc, ama yan'al chay nunacunäta turmintapayaychu; jawcallacta caćhaycapäcuy. Nuna cüsalla cal'a chay juccunänüpis chincan'aćh. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ñatac Diospi rasunpa captin'a maynu imanaculpis chincachiyta manaćh atipapäcunquichu. Yan'al-lätac ichá Diosta turyapayalcanquiman” nin. Chay niptinmi awnipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jinalculmi puydï yaćhapacücunäta cutiycachimul asutichipäcula: “Cananpi yan'al-lätac Jesus nunäpi limalcanquiman” nil. Chaynu asutilcachilmi libricta caćhaycälälimula. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jinaptinpis yaćhapacücunaca “Jesusninchicpi willaśhanchic-laycu caynu asutimäśhanchic'a Diosninchic allincäpi waytachimäśhanchicnümi” nil cushisha yalapämula chay Cunsïjup puydïnincunäpi. ");
INSERT INTO qvwNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chaypïtam muyun-muyunpis Jesus Salbacü caśhanpi Diospa chuya wasinćhu, may wasicunaćhüpis willacuyta jicutapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chayćhu Jesusman chalapacücuna achcaman miläläliptinmi waquinnincuná juccunäpïta limacuyalcäla. Chay griego limäcunämi quijaculcäla: “Micuy upämäśhayquićhümi ya'acunap biudäcunacta ash-ashllacta wishlapayalcanqui. Israel limä caśhta llapa biudayquicunactañatacmi ichá imanuypapis uyalcanqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chaynu niptinmi chay ćhunca ishcaynintin puydï yaćhapacücunaca: “Ya'acuna cay lulayta lulal'a Diospa willacuynintam caćhaycapäcüman. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aśhwanpa, anćhish nunayquita aclapäcuy cay lulayta lulapäcunanpä. Ashipäcuy allin cawsayniyu nunacunacta, allin umayüta, Chuya Ispiritup lulayninćhu cäcunacta. Paycunap maquinman cay lulayta ćhulayculćha ");
INSERT INTO qvwNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ya'acuná Diospa willacuyninta willaculcäśhä chaynütac imaypis ruygaculcäśhä” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Niptinmi “Allinmi chay'a can'a” nilcälil aclälälin Chuya Ispiritup munaśhanta lulä, masïsu chalapacü Estebanta, Felipicta, Procorocta, Nicanorta, Timonta, Parmenasta, Antioquia malcäpi Nicolastapis. (Paymi mana-Israel caśhta calpis unaypïña Moisespa camachicuyninman chalapacuyäla.) ");
INSERT INTO qvwNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jinalcälil puydï yaćhapacücunäman ćhälächiptinmi paycuna umanman maquinta ćhulaycul Dios yanapänanpä mañaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jinalcuptinmi Diospa willacuynin intiru malcacunäman milala. Chaynüpam Jerusalenćhu chalapacücunäpis achcamanña muyupäcula. Jinamanmi aśhta achca sasirdüticunapis cäsucul chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Cay Estebanta Diosninchic allinpa licalmi, imacta lulananpäpis jatun pudirta uycuptin milagrucunactapis chay malcäćhu lulala. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chaynu lulayaptinmi juc cutićhu “Uywaypi Juluśha” nishan Israel caśhtacuna, waquin Cirenecunapi, Alejandriapi, Ciliciacunapi, chaynütac Asia nishan malcacunäpi caśhta-masincunawan jucllachanacuycul Estebanwan tapunacuyta allacaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Chayćhümi Chuya Ispiritu Estebanta umacta uptin mana imanmanpis iwalapäculachu, maynu upällachiyta munapäculpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chaynu mana atipacalcälilmi juc nunacunacta mincacälälila: “ ‘Cay Estebanmi Diosninchictapis, Moisestapis jalutacuñä’ nil niycälipamay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Niptin rasunpa nicuyalcaptinmi, jinantin malcaca, ñatac prinsipal yaśhacuna, camachicuyta yaćhachicücunaca piñacälälin. Chaymi Estebanta chalalcälil Cunsïjup puydïnincunäman pasachiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chayćhümi chay niycünin nunacunaca äśhaycaćhacuyalcan: “Taytacuna, cay nunam Diosninchicpa canancätawan Moisespa camachicuynincunactapis jamuyal jalutacuñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chay Nazaretpi Jesusninshi cay Diosninchicpa wasinta lluy pampatalcul Moises yaćhachimäśhanchic custumrinchictapis jucman muyüchinman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Niptinmi chay Cunsïjup lluy puydïnincunapis Estebanta licalcuśhanćhu, paypa cäranta anjilpa cärantanuy licälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chayćhümi puydï sasirdütica Estebanta tapula: “¿Imaninquim nishuśhayquicunapi?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Niptinmi nila: “Malca-masí taytacuna, Moisespa camachicuyninta manchacuywanmi licá. Chaynütacmi Diosninchictapis cäsucú. Pay'a manamá nunap lulaśhan wasicunallaćhüchu yaćhayan. Tantiaycäliy-ari. Awilunchic Abraham Haram nishan calu malcaćhu cayaptinmi Sumä Diosninchic ćhaycul limapäla: ‘Cay malcayquita, caśhtayquita caćhaycul maytapis nishac malcaman licuy’ nil. Chayta nila Mesopotamia juc-lädu calu malcäćhu cayaptinlämi, manaläpis Haramćhu yaćhayaptinlämi. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chaynu niptinmi Abraham yalucula Caldea malcanpi Haram malcäman chayćhu yaćhamü. Chayćhu taytan wañucuptinlämi Diosninchic puśhamula cay caśhanchic malcanchicman. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ñatac maycäćhu yaćhananpäpis nï taycuycunallanpäpis uchucllapis unanchaycapuśha allpan capulalächu. Ñatac chayćhu manalä chulinpis cayaptinlämi Diosninchic: ‘Cay jinantin malcaca ampäwan chuliquipämi can'a’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nilculmi: ‘Llapa caśhtayquim jucpa malcanćhu allpanćhu sirbipaculcan'a tawa paćhac wata ma'alcuśhapis, imanalcuśhapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Chay sirbichicüniqui malcätamari ya'a llaqui bïdacta apachishä. Jinalcuptïmi chaypi yalamul cayćhu sirbipämanqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Chayćhütacmi nila: ‘Abraham ya'apa nuná canayquipä umri cayniquićhu siñalacul unanchachicuy’ nil. Chaymi chulin Isaac näsïluptin simänaycuyällacta unanchachila. Chaynütacmi Isaacpis lulala chulin Jacobwan. Chaynütac Jacobpis llapa chulincunawan lulala. Yaćhaśhanchicnüpis paypa ćhunca ishcayniyu chulincunam cay Israel nasyunninchicpa puydïnincuna capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ñatac cay Jacobpa chulincuna, ya'anchicpa awilunchiccuna, quiquin-pula ćhïninaculcul śhullcan Josëta lanticälälin Egipto nasyuncäćhu sirbipacamunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Masqui jinaptinpis Diosmi Josëta mana caćhaycul ima ñacaśhanpïpis julula. Jinayculmi allin umacta uycul, Egiptop mandänin Faraonwan allinpa apanacachila. Chaymi pay jinantin Egiptop mandawshïninpä ćhulaycula jinaman wasinćhüpis yanapänanpälä. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Jinamanmi llaqui micuy wana ćhäla Egiptopïta aśhta Canaan malcanchiccama. Jinaptinmi llapa awilunchiccunap ima aycallapis micalcälinanpä calachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chaynu cayalcäśhanćhümi Jacob yaćhälun Egipto nasyunćhu trïgu lantiypä caśhanta. Chaymi chulincunacta lantichimü caćhala. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chaypi yapa lantï cutïläliptinmi śhullcan José lisichicula mayurnincunawan. Chaynüpam Faraon yaćhala José may-lädu, ima caśhta caśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chaymi José papänin Jacobta puśhachila lädunman anćhish ćhunca pichayu lluy caśhtantinta. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chaynüpa Jacob Egipto malcäta ćhalmi chayćhu wañucamula llapa chulincunapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chaymi Siquem malcaman ayäcunäta apapämula Hamorpa chulincunapi taytan Abraham lantishan nïchuncunaman pampapämü. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Chaynu achca watacunaña pasayaptinmi ji'aycayämulaña Abrahamta Dios limalicuśhan timpuca. Yaćhaśhanchicnüpis unay awilunchiccuna achca-achcamanmá milälälila chay nasyuncäćhu. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Cay-chica timpuña José wañucuśhanpi cayaptinmi juc juyu puydï mandacü chay Egipto nasyuncäta mandayäla. Paytá manamá imapis uculachu Jacobpa caśhtacunapi. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chaymi malcanchicta lluy ingañalcul munaśhanta lulachila, ñacachila, aśhta näsimü iñachancunactapis wañunanpä firsapi jitachipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chaynu timpup ćhawpinćhümi Moises näsimuptin taytancuna quimsa quillalä wasinćhu uywapäcula. Paytamari Dios allinpa licala. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chayćhu jitäśha niyaptinmi chay Faraonpa wamla chulin apacul ishpichicula quiquinpa wawintanuy. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chaynüpa chay nasyunpa yaćhachicuynin junta Moises ishpilmi yaćhayninman tincüta imactapis limala, lulala. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chaypi tawa ćhunca watanta liyalmi, Moises watucü lila Israel malca-masincunaman. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chaynu lishanćhu juc Egipto nuna Israel malca-masinta camacayäta talïlulmi caśhtanta amachayninwan chay nunäta wañuchila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Jinalculmi: ‘Cay lulaśhäwan cay llapa caśhta-masïcuna tantiapäcun'aćh Diosninchic ya'awan librananta’ nicula. Ñatac chaytá caśhtancuna manam uchucllapis pinsalcälilachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Aśhwanpa chay wäla quiquin-pulacta ma'anacuyäta talilcul: ‘¿Maynüpam wawi-caśha ma'anacuyalcanquiman?’ nil japächaptinpis ");
INSERT INTO qvwNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","chay ma'acüca Moisesta tan'alcul ‘¿Miticamunayquipä pitá mandänïpä, fisnïpä amta ćhulaśhulanqui? ");
INSERT INTO qvwNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Anyan cay Egipto nunactanüchun imam ya'actapis wañuchiyta munamanqui?’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Chaynu niptinmi, Moises Madian malcäta ayicula. Jinalculmi chayćhu yaćhala juc-lädu allpaćhu mana lisisha. Chayćhu walmiculculmi ishcay chuliyu cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Chaypi tawa ćhunca watapïmi Sinai ulup chunyäninćhu licalïlun juc anjil sumbaypa-sumbal juc jaćhacta lupayä ninap śhun'unćhu. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chaynu walayaptinmi Moises aśhuycula ‘¿Má, imash cañä?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Chaymi chay ninap śhun'unpi limalïmun Tayta Diosninchic: ‘Ya'am cayá unay awiluyquicuna Abrahampa, Isaacpa, Jacobpa alawayalcäśhan Diosnin’ nil. Niyta uyalil Moises manchalicucuyalmi, nï licalcunñapischu. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Diosñatacmi: ‘Śhucuyniquita julucuy. Ya'a cayćhu caśhä-laycum cay jaluśhayqui allpaca chuya. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egipto nasyuncäćhu malcá ñacaśhantam ñawí lican. Chayćhu ñacaśhanpi quijacamäśhanta uyalilmi canan bäjamulá julamunäpä. Chaymi Egipto nasyuncäta linayquipä amta caćhaśhayqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Canan má, taytacuna, chay nina waläcäćhu juc anjil licalichimuśhancäwanmi Diosninchic caćhala Moisesta caśhtanpa puydïninpä, libräninpä. Masqui juc-pun ‘¿Pim amta puydïnïpä, fisnïpä ćhulaśhulanqui?’ niyalcaptinpis ");
INSERT INTO qvwNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","cay Moisesmi Egipto nasyuncäpi unay awilunchiccunacta libramüca. Paymari chay malcäćhu, Puca Lamarcäćhu, chunyänincunäćhu ima milagrucunactapis, siñalcunactapis tawa ćhunca wata intiru luläca. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","38","“Masqui may-chica nuna chay chunyänincunäćhu cayalpis ¿pitan Dioswan limala ampá? Sinu'a cay Moisesllapmi imactapis jinantin caśhtanchic yaćhapäcula Sinai ulućhu limalimü anjilca ima nishantapis. Paytamari Diosninchic shiminta ula tuqui cawsananchicpä. Masqui chaynu puydï calpis cay quiquin Moisesmi malcäta nila: ‘Amcunapïtam Dios juc willacüninta ya'actanüpis śhalcachin'a. Payta cäsupäcuy’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ñatac yaćhaśhanchicnüpis unay awilunchiccuna Moisesta mana cäsupäculmi munay-sapacalcälil caśhan Egipto nasyunta cutićhaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jinalmi Aarontapis: ‘Juc dioscunacta lulaycälipamay puśhapämänanpä. Manam yaćhanchicchu Egiptopi julamäní Moisesta ima pasaśhantapis’ nil nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chaynu nilculmi taytachacta rasunpa lulacälälin uña ñatuctanuy. Jinalculmi ‘¡Caymi diosní!’ nil maquinwan lulacuśhan taytachanpä jatun fistacta lulapul uywacunap yawarninta uycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chay lulaśhanpi Diosninchic caćhaycüluptinmi intïta, quilläta, lusirucunäta dioschaculcul alawapäcula. Chaynütam unay willacünincunap isquirbishan librucunäćhu limayan: ‘Israel caśhtacuna, tawa ćhunca wata chay arinal ulucunäćhu “Diosnïpä” nil yawarta uycuśhayquica ütac imapis lulapäcuśhayquica ¿ya'apächun cala, imamá? ");
INSERT INTO qvwNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aśhwanpam cay alawanan wasïta śhalcachipäculanqui chay Moloc taytachayquipä. Jinalculmi chayćhu Refan taytachayquip lusirunman uyshuycälilanqui lulacuśhayquita alawanayquipä. Chay lulapäcuśhayquipïmari Babilonia nasyunpa mas wic-lädun nasyuncunamanlä aysachishayqui, apachishayqui’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Canan'a, taytacuna, sumäta yalpalcäliy: Diosmi Moisesta nila: ‘Carpacta śhalcachipamay nunacunäta ya'apïta yalpachinäpä’ nil. Niptinmi Dios imam nishantanülla nunacunaca śhalcachila Moisespa camachicuyninta ćhulapäcunanpä. Ñatac chayta śhalcachila manam cayćhüchu sinu'a chay chunyäninćhümi. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chayćhümi uywapäcula. Cayman apachimula Diosninchic cay malcapi lluy nunacunäta Josuëwan alulcachil-lämi, ñatac unay awilunchiccuna lluy taycuptinlämi. Chayćhülämi chay carpap intiru muyülïninman cunćhacaycälil Diosninchicta alawapäcula aśhta unay mandäninchic David timpucama. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Paymi Diosninchicwan allinpa apanacul: ‘Dios Taytáy, Jacobpa Diosnin, cunsintiycamay juc wasicta śhalcachipunacpä’ nila. Ñatac manam paychu śhalcachila ");
INSERT INTO qvwNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","sinu'a chulin Salomonmi śhalcachipula. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Chaynu captinpis, taytacuna, altu sïlućhu cacü Diosninchic'a manam nunap lulaśhan wasicunallaćhüchu täcuyan nï wićhalayan, Diospa unay willacünin nishan-yupaypis. Paymari nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Sïlümi dispächu'a, allpäcá pulinallämi. Chaynu captin'a ¿ima wasictatan yaćhanäpä amcuna lulaycapamanquiman? ¿Maycätan jamaycuná canman, ya'a quiquí lluy imactapis lulayaptí?’ ninmi Taytanchic” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Chaynu nilculmi Esteban chayćhu llapa puydïcunacta: “Amcuna artictam pasaypi cullu linli capäcunqui. Diosta mana lisï nunacunänuy mana linliyu, juc-läducta śhun'uyqui pinsayä nuna capäcunqui. Jinal imaypis Chuya Ispiritup cuntran cayalcanqui. Cay lulayniquiwan manam mayta-chayta lipäcunquichu unay awquilluyquicunapïta. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Canan'a ¿niycälimanquimanchun Diospa willacünincunacta mana mayanllantapis awiluyquicuna aticaćhaśhanta? ¿Mayanllantá manatan wañuchilachu? Paycuná Mana Juchayücäpi limalcücätá wañuchipäculam. Pay quiquin ćhämuptinñatacmi, amcunapis cuntran śhalcalcälil wañülächinqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Amcuna Diospa camachicuyninta anjilpi ćhasquïcunalä cayalcalpis manatac cäsuculcä-camachu capäcunquipis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chaynu niycüluptinmi alli-allicta nanachiculcul quiluctapis lawćhićhicyachicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebanñatacmi ichá Chuya Ispiritup munayninćhu cayal altu sïlućhu Diosninchicpa sumä cayninta, ñatac Jesuspis Tayta Diospa lädunćhu śhäcuyäta licäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chaymi chayćhu nila: “¡Licay! Quiquin sïlum quićhacacuyan. Chayćhu Rasun Nunap Chulin Jesustam Diospa lädunćhu cayäta licayá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Niptinpis cullu linlicaycälilmi Estebanman lluypis shipucälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jinalcul chay malcapi aysacalcälimulmi chay casquinwan limäcunälä müdanantapis Saulo śhutiyu müsup puntanman wicapaycälil Estebanta tamshayta allacaycälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Chayćhu tamshayalcaptinmi Esteban ruygacula: “Taytalláy Jesus, almalläta ćhasquiycullay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nilcuśhanpïmi un'ulacuycul ayaycaćhaypanuy: “Taytay, cay lulaśhanpi ama juchachaycuychu” nil pasacalpula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Chayćhümi Saulo nila: “Allinmi caynu wañunan” nil. Jinalcäliptinmi llaquipayniyu nunacuna śhalcamul alli-allicta wa'acuśhtin Estebanta pampamü apaculcäla. Chay-pachapïmi cay Jerusalenćhu Jesusman chalapacücunäta lluy chincachï talcula. Chayćhu Saulo llapantapis llaqui bïdacta pasachiptin, jinaman wasin wasin yaycuycul walmictapis umrictapis alluctanuy alaśhćhalcamul carsilman jitaycayächiptinmi lluypis wicta cayta chi'iculcul ayiculcäla Judeap Samariap malcancunaman. Ñatac puydï yaćhapacücunällañam chayćhu quïdälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chay Jerusalenpi ayicücunämi may malcaman ćhäpäculpis allin willacuypi willaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Chaymi Samaria malcäman Felipe ćhälulpis Salbacü Jesuspi willacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Chayćhümi latacunactapis, wishtucunactapis, Satanaśhpa gänaśha nunacunactapis Satanaśhninta apalcaćhayäta alulcul sänachila. Caynu milagrucunacta lulaśhanpam, llapa nunapis juntunacamul Felipip yaćhachishanta mishquicta uyalipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sumä cushicuyllamari chay malcäćhu cacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chayćhütacmi Simon śhutiyu juc nuna chay-chica unay timpuña rüja cayninwan chay malcäta ingañäcuñä. Puydï nunap pasachiculcul-lämi llapa nunawanpis rispitachicuñälä. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Chaymi sumä mana sumä nunapis “Pay'a Diospa sumä pudirninwanmi cayan” nil sumä manchacuywan cäsupäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","13","Ñatac Felipe chayćhu Diospa gubirnunpi, jinaman Jesuspi willaptinmi walmipis umripis chalapaculcul bawtisachiculcäla. Jinaman Simonpis chalapacuycaćhalcul bawtisachicülun. Jinalculmi Felipicta puliwshicuyan “¡Maynu milagrucunactam lulaculläñä!” nilcul. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ñatac Jerusalenćhu puydï yaćhapacücunaca Samariaćhu Diospa shiminta ćhasquipäcuśhanta yaćhälälilmi Pedroctawan Juanta caćhapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Chaypá manalätacmi Chuya Ispiritu Samariaćhu chalapacü nunacunäman śhamulalächu. Sinu'a “Jesuspa uywayninmi callá” nilcul bawtisachicuśhallalämi cayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chaymi Pedrowan Juan ćhaycamul, paycunacta yataycul Diosta ruygacula “Ispirituyquita uycullay” nil. Chaynüpam Jesusman chalapacü Samaria nunacunäpis Chuya Ispiritucta ćhasquipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Cay Simon llapa yataycuśhan nunacunäman Chuya Ispiritu sïlupi uyaypa śhayämüta licalculmi, ");
INSERT INTO qvwNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Pedroctawan Juanta nila: “Chay pudirniquita lanticämay, ya'apis amcunanuy munaśhä nunacta yataycul Chuya Ispiritucta unäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Niptinmi: “Chay illayniqui üllacüśha infirnüta licuy. ¿Imanuypatan Dios cüsacta illaywan lantiyta pinsälunquiman? ");
INSERT INTO qvwNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Caynu mana allin śhun'uyu'a caycunaćhu manamá canquimanchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Inbidicuycunalla amćhu winalayaptinmi munayninćhu ćhänalayächishunqui. Chaypi wanacul Diosta ruygacuptiqui ichaläpis pampachaycuśhunquiman” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Niptinmi Simon: “Cay nimäśhayquicunaca mana pasallämänanpä mañacaycapallämay-ari” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jinaptin chayćhu Jesuspi willaculculmi Pedrowan Juan Jerusalenta cutipäcula Samariap intiru malcancunap willacuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chaypïtam juc anjil Felipicta nila: “Wayra liy, Jerusalenpi Gazaman lï arinal caminüman” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Niptin-pacha lishanćhümi Etiopia-lädu nunawan tincülun. Paymi Etiopia nasyun Candace puydï mandacüninpa ministrun cala illay cüsapi licänin. Pay malcanpi śhamula Jerusalenta Diosta alawämi. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jinalculmi carritanpa jananćhu Diospa unay willacünin Isaias isquirbishanta lïgishtin nasyunninta cutiyäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chaynu pasayaptinmi Diospa Ispiritun: “Felipe, aśhuycuy wic nunäman” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","33","Niptin Felipe cürriycul aśhuycunanpämi lïgiyäta uyalïla cay niyäta: “Ćhipinanman uwishta apaycuyä-yupaymi apälälin. Millwanta lutuptin upälla quïdacänümi, mana imactapis limalculachu. Pin'aypä uyshulächipäcul nï mayanpis tincüninman licayculachu. Chayurá milaynincunapi ¿mayanllá limaycälinmantá? Cay allpäćhu cawsaynin chincayaptin'a manamá jucpis canchu” nil. Chaynu uyalilculmi Felipe tapula: “Taytay, cay lïgishayquita ¿tantiayanquichun?” nil. Niptinmi chay nunaca: “¿Imanuypatan ya'a intindïlüman mana pipis tantiaycayächimaptin?” nin. Nilculmi: “Taytay, cay-läduman ishpimuy” nil carritanman ishpichila. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chayćhümi chay puydï nunaca Felipicta tapula: “Canan niycallämay ¿cayćhu willacüca quiquinpïchun icha jucpïchun limayan?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Niptinmi: “Cay lïgishayquica Jesuspïmi limayan” nilcul Jesuspi willapalcul lluyta tantialpachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chaynu limaśhtin liyalcäśhanćhu yacuman ćhälälilmi chay puydï nunaca: “Cay-ari cayćhu yacu cayäñä; ¿Bawtisallämanquimanchun?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","˻Niptinmi: “Rasunpa chalapacuptiqui'a, bawtisaśhayquićh” nin. Niptinmi: “Aw, chalapacümi Jesus Diospa Chulin caśhanta” nila.˼ ");
INSERT INTO qvwNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nilculmi carritanta śhaycächin. Jinalculmi pulan bäjaycul, yacuman liptin chayćhu Felipe bawtisala. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jinalcul yacüpi yalayämuptinmi Diospa Ispiritun Felipicta chincachicula. Jinaptinmi chay Etiopia nunaca payta manaña masta licalpis malcanta cushisha pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ñatac Felipe Azoto malcaćhu licalïlulmi allin willacuyta malcan-malcan willapacuśhtin Cesarea malcäcama ćhäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauloñatacmi chalapacücunäta wañuchïpi lücuyal sumä-sumäta ñaćhaña imanacuyälapis. Chaynu pinsamintunwan lilculmi chay puydï sasirdüticunäta nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Juc papilta umay Damascoćhu juntunacuna wasip puydïnincunapä. Chayćha Muśhü Caminuman chalapacücunäta umripis walmipis cacuchun lluyta cay Jerusalenman aysalcamul carsilćhu chaquiyächishä” nil. Chayćhu uycuptinmi pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasco malcäman sircaycuyaptinñatacmi, juc acchi sïlupi ji'alpaycamul Saulop muyülïninta acchiycuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jinaptin Saulo pampäman cućhpälulmi chayćhu uyalïlun: “Saulo, Saulo ¿imapïtan wañuchiyta llallächacul aticaćhamanqui?” nil nilpamüta. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Niptinmi: “¿Pim canqui, taytay?” nïllaman Saulop shimin paćhyälun. Niptinmi: “Ya'a cayá aticaćhaśhayqui quiquin Jesusmi. ˻Cay lulayniqui cunca cuchuyniquipämi garuchap puntanta saytäcä-yupaypis cayan” nin. Niptinmi chucchuśhtin: “Chayurá ¿imacta lulanätam munanqui, taytay?” nicuyan.˼ ");
INSERT INTO qvwNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Niptinmi: “Śhalcul, wayra yaycuy cay malcaman. Chayćhümi imacta lulanayquipäpis nishunqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Chay nishanta uyalïlälil imactapis mana licalmi lluy liwshïnincunapis licapayllaman camälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Niptin Saulo pampäpi śhalcüluptinmi ñawinñatac aplacacüñä. Chaymi Damasco malcäman chancuyllap ćhächipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jinalmi quimsa muyun chaynu aplaśha, mana micuśha nï yacuctapis upyaśha cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ñatac chay Damascoćhümi juc nuna Ananias śhutiyu Jesusman chalapacütac yaćhala. Paytam Jesusninchic juc suyñuyninćhünuy licalilcamul “Ananias” nila. Niptinmi: “¿Imactam niyanqui taytay?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Niptinmi: “Canan Dirichulla nishan cällïman Judas śhutiyu nunap wasinta lil tapucuy Tarso-lädu Saulo nunapi. Pay Diosta ruygacuyaptinmi ");
INSERT INTO qvwNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","suyñuyninćhünuy, am tupaycuptiqui ñawin quićhacananta licayan” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Niptinmi nila: “Taytay, chay nunaca chalapacüniquicunacta intiru Jerusalencunaćhu imaymana mana allinta pasachishantamari ya'a uyaliyá. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Chaymi caytapis cürrïtucämun puydï sasirdüticunap awniycuśha anman chalapacücunäta carsilman aysapämänanpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Niptinmi: “Liy jinalla. Chay nunacta ya'a quiquïmi aclacú mana-Israelcunäman lil ya'api willacunanpä, chayćhu gubirnänincunactapis mayćhu cä malca-masiquicunactapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Chaycunaćhu ya'a-laycu ima ñacaycuna alcaśhantapis yaćhaycachishämá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Niptinmi Ananias licula Saulo caśhan wasiman. Chayćhu yaycuyculmi Saulocta yataycul: “Cuyaśhá Saulo, yaćhämi caminuyquićhu Jesusninchic licalishuśhayquita. Paymi canan caćhamäla caśhan ñawiqui quićhacacunanpä, ñatac Chuya Ispiritup munayninćhu canayquipä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nilcullaptinmi challwap utan-yupaynuy śhupucäluptin ñawin licälun. Jinalcuptinmi chaypi śhalcul bawtisacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jinalculmi cayćhu micul caśhan allinpacula. Chaynüpam achca muyuncuna chay Damasco malcäćhu chalapacücunäwan cusca capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chayćhümi juntunaculcänan wasicunaćhüpis Diospa Chulin Jesus caśhanta willacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Chaymi lluy nunacunäpis licapayllaman camäśha: “Cay nunaca Jerusalenćhu Jesusman chalapacücunäta imactapis luläcächućh-ari. ¿Manachun cay puydï sasirdüticunap maquinman aysananpä śhamü quiquin nunaca?” nil ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nipäcuptinpis Saulo'a mas-mastalämi mana imactapis manchacul Jesuspi callpawan limala. Chaynu Jesus quiquin Diospi Caćhamuśhan Salbacüca caśhanta willaptinmi llapa chay Damascoćhu yaćhä Israelcunäta jucmanyächila. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Chaymi achca muyuncunapïtá chay nunacunaca “Cay Saulocta wañüchishun” nil yaćhachinacücuyalcan. Ninaculcul malcap yalunancunaćhu tutay-muyun wañuchinanpä alcayalcäśhanta Saulo yaćhälañam. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Chaymi chay tuta śhalcünincuna jatun canaśhtaman winaycul, chay malcap sircunpa caćhalpäläliptin chaycunap maquinpi lluptïla. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jinalculmi chaypi Jerusalenman ćhäla. Chayćhu chalapacücunäwan jucllachanacuyta munaptinmi waquinnincuná manchaculcäla “Jesusman chalapacunchu-ari cay ampá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabëñatacmi ichá puydï yaćhapacücunäman puśhalcul: “Damascocta liyaptinshi caminućhu Jesusninchic licalilcul imaymanacta nila. Chayshi imactapis mana manchalil Damascoćhu Jesuspi callpawan willacula” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Niptinlämi llapanpis awnil ćhasquipäcula. Chaynüpa Saulo Jerusalenćhu paycunawan quïdal cusca maytapis lilmi pictapis mana manchalil Jesuspi willacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jinaptin griego limä Israelcunäwan piñanaculcaptinmi chaycuna wañuchiyta munapäcuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chaynu jinaśhanta chalapacücunaca tantialcälil Cesarea malcaman ayichiculcalmi Tarso calu malcäman caćhälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chaypïtam Judeaćhu, Samariaćhu, Galileaćhu cä chalapacücunäman tuqui bïda ćhälun. Chayćhümi Chuya Ispiritu chalapacuyninta masïsu tacyalpachiptin Diosninchicta manchacuywan cawsapäcula. Jinaman'a achcamantacmi milapäculapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedroñatacmi chalapacücunäman watucuyta lluy malcan-malcan pulila. Jinalmi Lida malcäman ćhäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chayćhu Eneas nunacta pusä wata latäśhactam talïlun. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Paytam: “Eneas, Salbacü Jesusmi sänachishunqui. Canan śhalcul cämayquita juntuy” nin. Nilcullaptinmi Eneas chay üra rasunpa sänu śhalcülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chaynu tuqui sänu puliyäta, Lida malcäćhu, Saron intiru malcacunäćhu licälulmi, Jesusninchicman masïsu chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Cay malcap sircan Jope malcaćhüñatacmi Jesusman chalapacü Tabita walmi yaćhala. (Griego limayćhu'a Dorcas nipäculam). Paymi imallawanpis llapa wacchacunacta imaypis yanapayä cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chaynu cayäśhanćhümi chay muyuncuna ishyalcul wañucun. Jinaptinmi cuirpunta lluy pa'aycul, altuśhninman chutaycälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Chaynayculmi bisinun Lida malcaćhu Pedro caśhanta yaćhälälil ishcay umricta caćhapäcula. Paycuna: “Canallanshi lilläśhun Jopecta” niptin-pachallam Pedro paycunawan licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ćhäluptinmi chay aya chutaläśhancäman puśhaycälälin. Chaymanmi juntälälimun llapa biudacuna wa'aśhtin, chay wañü walmi cawsayal müdana lulaśhancunacta licachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jinaptinmi Pedro lluyta waśhaman yalalcachimul, chay ayap lädunman un'ulacuycul Diosta mañacula. Jinalculmi “Tabita, ¡śhalcuy!” nila. Niptinmi pay licaćhacalcamul, Pedrocta licälul taycuycülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jinaptinmi Pedro maquipi śhalcalcachil chayćhu cäcunätawan chay biudacunäta ayalcul: “¡Licay! ¡Pay cawsayanmari!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Chay nutisyam intiru Jope malcacunaman rätulla ćhäla. Jinaptinmi Jesusman achca chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Chay malcaćhu Simon śhutiyu uta chaquichï nunap wasinćhümi achca muyuncuna Pedro caycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ñä Cesarea-lädu calu malcaćhümi yaćhala juc mana-Israel caśhta nuna Cornelio śhutiyu. Paymi chay malcaćhu Italia nishan batallunpa mandänin cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Pay Diosta manchacü nuna calmi lluy wasintin imaypis payta mañacula, alawala. Chaynütacmi achca illaynincunawanpis llapa wacchacunactapis yanapaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chaypïmi juc muyunćhu yunda pasquicuy üranuy suyñuyninćhünu tuquicta licälun juc anjil yaycaycamul “Cornelio” niycuyäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jinaptinshi manchäśha licapäśhanpïta: “¿Imallactam niyanqui, taytay?” nin. Niptinshi anjilca: “Diosmi mana un'alachu mañacuśhayquitapis llapa wacchacta yanapaycuśhayquitapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Canan caćhamuy Jope malcäta Pedrop lisipäcuśhan Simonman. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pay cayan uta chaquichï Simonpa wasinćhümi, chay lamar patanćhu. ˻Ima nishuśhayquitapis uyaliy” nin.˼ ");
INSERT INTO qvwNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nilcul anjilca licuptinshi Cornelio ayälun ishcay nunantawan juc paynüpis Diosta manchacü cunfiansa cachacunta. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jinalculmi licaśhancäta lluy willaycul Jope malcäta caćhäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chay wälam chay caćhaśhan nunacunaca allin mirinday üra ćhaycuyalcälaña Jope malcäta. Pedroñatac Diosta mañacü wasip altuśhninman ishpila. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Chayćhu micanäśha mañacuyaptinmi, chay wasiyu mirindacta yanuśhancama suyñuyninćhünu Pedro licälun sïluca quićhacacalcuptin chaypi juc jatun baytanuy tawan puntanpi watacuśha bäjayämüta. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chay bäjamü baytaćhüshi śhamuñä mana micuna imaymana anla uywacuna, culibraycuna, pishucuna. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chaypïshi altupi: “Pedro śhalcuy; wañulcachil micuy” nïmun. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Niptinshi: “Taytay, caynu mana pirmitisha anla uywacunactá ya'a manam imaypis micullalächu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Niptinshi yapañatac: “Dios allinpa licaśhancätá, ama anlapä licayaychu” nïmun. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chaynu quimsa cuticta licalïmuśhanpïshi chay bayta altu sïlüta caśhan cuticulcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lluy chaynu pasäluptinmi Pedro pinsatïbu quïdälun “¿Ima ninantaćh caywan willayächiman?” nil. Niyaptinmi Cornelio caćhacamuśhan nunancuna tapupacu-tapupacul Pedro caśhan wasiman ćhälälilaña. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chayćhu talilcul “Wasillayqui taytay. ¿Cayćhüchun Pedro nishan Simon cacullan?” nil callpawan ayacuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Jinaptin chayćhu Pedro licaśhancäman pinsayaptinmi Chuya Ispiritu nin: “Pedro, licay, quimsa umrim ashiyäśhunqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Canan bäjal, mana illacullal paycunawan liy-ari. Ya'amá caćhamulá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Niptinmi Pedro bäjalpul: “Ya'am cayá chay ashishayqui nuna. ¿Imallactam niyanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Niptin willapäcun: “Ya'acuna śhapämulá cachacup puydïnin tayta Cornelio caćhapämaptinmi. Pay'a Dios munaśhannuy cawsä nunam, Diosta alawämi. Paytá llapa Israelcunam allinpa licapäcun, cuyapäcun. Chaynütacshi Diospi caćha juc anjil nila am wasinta lil limapaycunayquipä. Chaymi caćhapämäla, taytay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chaynu niptinmi chay tuta Pedro puñuchin chay wasinćhu. Chay wälañatacmi śhamücunäwan Jope malcapi ishcay quimsa chalapacücunawanpis Pedro yaluculcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jinal chay walantin'a Cesarea malcätam llapan ćhälälin. Chayćhümi Cornelio alcayäla, llapa aylluncunawan, lluy lisinacuśhancunawan wasi junta. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chay wasinman ćhäläliptinmi Cornelio ćhasquiycul un'ulacuycula Pedrocta alawayninwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jinaptinmi Pedro: “Śhalcuy Cornelio, ya'apis amnuy nunallamá cayá” nil śhalcächin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nilcul yaycunanpämi wasi junta nuna cayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Chayćhümi Pedro: “Taytacuna mamacuna, yaćhapäcuśhayquinüpis Moisespa camachicuyninmi yaćhachipäman ya'a Israelcunaca, juc-lädu nunacunawan mana uchucllapis limaycälinäta, nï wasinman yaycaycälinäta. Ñatac quiquin Tayta Diosmi ya'acta yaćhachiman pay allinpa licaśhancäta, ya'a pictapis anlapä mana licanäpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chaymi canan willaycamaptin-pacha śhamulá mana imapis nillal. Canan ¿imallapäćha ayachipämälanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Niptinmi Cornelio willan: “Tawa punñam cay tardi üranuy, cay wasïćhu ayunal Diosta mañacuyälá, custumrinchicmannuy. Chayćhümi juc umri licalïmun chipyayä müdanayu. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jinalculmi pay niman: ‘Cornelio, mañacuśhayquitapis ñatac llapa wacchacunacta yanapaycuśhayquitapis Diosmi mana un'alachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Chayurá Jope malcäta caćhay Pedro nipäcuśhan Simonman pay śhamuśhunayquipä. Pay cayan uta chaquichï Simonpa wasinćhümi, chay lamar patanćhu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chaynu nimaptin-pacham ashichimüniqui caćhamulá. Sulpäta ucümi ćhämumäśhayquipïta. Canan cayćhu llapallämi gänaśhwan uyaliycälinäpä alcayalcac, Diosninchic niycälimänayquipä incaramuśhuśhayquita” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Chayćhümi Pedro nila: “Canan tantiämi Dios mana jucllanman śhalcuśhanta, ");
INSERT INTO qvwNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sinu'a may-lädu nunapis payta cäsucul allinta luläcätá awnil ćhasquishanta. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yaćhapäcuśhayquinüpis Israelcunätam Dios willachimula Caćhamuśhan Salbacünin Jesus lluy nunacunap duyñunca, jinaman jawca cawsayta uycamänanchic caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Yaćhapäcunquitac, Juan willacuśhanpïta Galileapi allacuycul Judeacama ima pasaśhantapis. Yaćhapäcunquim pay Nazaret Jesusta bawtisaptin, Tayta Dios Chuya Ispiritunta uśhanta. Chaynu allin munayniyüman muyuchiptinmi allincäta lulaśhtin, ñatac satanaśhcunap maquinćhu cä ishyäcunactapis sänachishtin pulila. Lluy caycunacta lulala Diosninchic paywan cayaptinmari. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Lluy caycunapi jinantin Israel malcacunäćhu, ñatac quiquin Jerusalenćhu imacta lulaśhantapis rasunpa ya'acunam ñawïwan licäca capäcú. Chayćhütacmi curuśhman chacatal wañuchipäculapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Masqui chaynu jinapäcuptinpis quiquin Dios quimsa muyunpïta śhalcachimulmi ya'acunawan tincuycälichimäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Manam jinantin malca-masïcunachu licala, sinu'a unaypïña caycuna willaculcänäpä aclapämäśhancällam. Chay śhalcämuptinmari micapäculá, upyapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ñatac chayćhümi caćhapämäla: ‘ “Diosmi Jesusta ćhulaycun wañücunap cawsäcunap cäraycüninpä” nil willacamuy’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Paypïmi Diospa unay llapan willacünincunapis limañä: ‘Salbacücäman chalapacücätam Dios'a ima juchancunactapis lluy pampachan'a’ nil” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","46","Niyaptinmi Chuya Ispiritu chayćhu uyalïnincunaman ji'alpämun. Chayćhu Diospa Ispiritun llapanta duyñuchacuycul imaymana mana uyalipaśh limaycunacta limayächiptinmi, ñatac Diosta alawayaptinmi, Pedrocta liwshï Israel chalapacü-masincunañatac: “¿Diosninchic Chuya Ispiritunta mana-Israelcunactapis uñächun?” nil licapäcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chaynalcaptinmi Pedro nila: “Ya'anchicnüpis Chuya Ispiritucta ćhasquiyalcaptin'a ¿imam atajanman paycunapis bawtisacüśha cananpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nilculmi chayćhu: “Bawtisaculcay ‘Cananpi'a Salbacü Jesuspa nunanmi caśhä’ nil” nin. Jinalcälilmi Pedrocta ruygaycälil ishcay quimsa muyuncuna paycunawan quïdachipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Chaynu mana-Israelcunamanmi Diospa limayninta ćhasquïlälishanta puydï yaćhapacücunäwan Judeaćhu chalapacücunaca yaćhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chaymi Jerusalenta Pedro cutiycüluptin, Moisespa camachicuyninta rispitachï malca-masincunañatac jamuyäcuyalcan: ");
INSERT INTO qvwNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“¿Ima-nilämi canqui juc caśhtacunaćhu micamunayquipälä canpis?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Niptinmi Pedro imanuy caśhantapis manyapi willala ");
INSERT INTO qvwNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","cay nil: “Jope malcaćhu cayalmi Diosta mañacuyälá. Chayćhümi suyñuynïćhünuy altu sïlupi bäjämun juc baytanuy tawan puntanpi watacuśhanuy puntäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chayta licaycunäpämi mana micuna imaymana anla uywacuna cayäñä, jatun uywacuna, munti uywacuna, pälï uywacuna, imaymana culucunapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Chaypïtam ayalpämun: ‘Pedro śhalcuy, wañulcachil, micuy’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Nimaptinmi: ‘Taytalláy, anlapä licaśhacunacá ya'ap shimïman manam imapis nï imaypis tupaycunmanchu’ niycuyá. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Niptïmi nilpämunñatac: ‘Dios allinpa licaśhancätá ama anlapä licayaychu’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","11","“Chaynu quimsa cuti lulacalcuśhanpi altu sïlüta chay baytaca caśhan cuticulcuptin-pacham quimsa nunacuna Cesarea malcäpi ashimaśhtin ćhämun. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jinaptinmi Chuya Ispirituñatac ‘Mana ishcayyällal paycunawan liy-ari’ niman. Chaymi cay süta chalapacü-masinchiccunawanpis Cesarea malcäman lipäcul chay nunap wasinman yaycälälí. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jinaptïmi chayćhu willaman juc anjil wasinćhu licalilcul caynu nishanta: ‘Canan caćhay Jope malcäta Pedrop lisipäcuśhan Simonman. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Amta, llapa wasintinta imanuypa salbaculcänayquipäpis niycälishunquim’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chaymari chayćhu Jesuspi willapayaptí Chuya Ispiritu juclla paycunamanpis ji'alpämun, ya'anchiccunaman puntacta ji'alpamuśhancänüpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chaymi yalpaćhacülú Jesus cay nishanta: ‘Bawtisä Juan'a yacullawanmi bawtisala. Amcunañatacmi ichá Chuya Ispirituwan bawtisaśha capäcunqui’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Chayćhu ya'anchicnüpis chalapacuyalcaptin paycunactapis quiquin Diosninchic Ispiritunta uyaptin ¿pitá ya'a cayá ‘¿Imapïtan cayta lulanqui?’ ninäpä?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Niptinmi chayćhu cäcunaca jawcayalpülul Diosta alawapäcula cushisha: “Canan chayurá mana-Israelcunäpis juchanpi wanaculcal'a Dioswanmi wiñaypä cawsapäcun'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Canan, má, nishac-yupaypis Estebanta wañulcachil Jesusman chalapacücunäta lluy aticaćhayta allacaycälila. Jinaptinmi Israel caśhta-masincunallacta intiru Feniciaman lamar ćhawpićhu Chipreman Antioquia malcacunäman willacuśhtin ćhäpäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Paycunallacta willayaptinpis Chiprepi, Cirenepi juc chalapacücuna Antioquiaman ćhayculmi mana-Israelcunactapis Jesuspi willala. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Paycuna Diosninchicpa munayninwan cayalcaptinmi uyaliculcal unay chalapacuynincunacta caćhaycul Jesusman chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","24","Caycunacta Jerusalenćhu chalapacücunaca yaćhälälilmi: “Antioquiaman Bernabëta caćhaśhun. Pay'a masïsu chalapacümi, jinaman Chuya Ispiritup munayninćhümi cayan” nil caćhälälila. Ćhälul paycunacta imaćhüpis Dios yanapäśhanta licayculmi allicta cushicülul callpanchäla chalapacuyninćhu masïsu tacyaycälinanpä. Chayćhümari achca nunacuna Jesusman chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chaypïta Bernabé Tarso malcäta Saulocta ashï liculmi ");
INSERT INTO qvwNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Antioquiaman pulanña cutipämula. Chayćhümi chalapacücunäwan yaćhapäcul achca achca nunacunätapis wata intiru yaćhachila. (Chay Antioquiaćhümi wamäta “cristianu” nil śhutichälälila chalapacücunäta.) ");
INSERT INTO qvwNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chay timpućhüñatacmi Jerusalenpïta Diospi willacücuna Antioquiaman ćhälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Jinalmi chayćhu Agabo śhutiyu nuna llapa chalapacücunap puntanman pasaycul Chuya Ispiritu limachiptin: “Cay jinantin allpäćhu micuy wanamá cacun'a” nila. Chaymi llapa yaćhapacücunaca capuśhanpa purätaycul Judeaćhu prinsipal caminaycücunäman Bernabëwan Saulowan apachipäcula chalapacücunäman aypunanpä. (Chay micuy wana rasunpam pasäla Roma nasyunta Claudio gubirnaśhan timpućhu.) ");
INSERT INTO qvwNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chay timpućhümi mandacü Herodes Jerusalenćhu waquinnin chalapacücunäta, wañuchiyninwan allacuycun aticaćhayta. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Puntallactá Juanpa mayurnin Jacobocta ispädawan tucsilcachil wañüchin. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chay lulachishanca Israelcunap śhun'unpä captinmi Pedroctapis wañuchiyta pinsalcul chay Mana Libadürayu Tanta Fista muyuncunäćhu chalachimü caćhälun. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Chayćhu chalälälimuptinmi carsilman wićhächin: “Fista pasalcuptinćha jinantin nunap ñawpäninćhu cäraycuśhä” nil. Jinalculmi ćhunca sütayu cachacuncunawan tawa-tawanca chullächinacuypa täpayächin. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Chalapacücunäñatacmi chaynu wićhächisha cayaptin tutay-walächi Diosta ruygacuy-ruygacuy cayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Niycunan wälapäñatacmi Pedrocta ćhawpiman cadinacaycälil ishcay cachacucuna lädunćhu puñupayalcan payman cadinacälälisha-cama. Chay waquin cachacucunañatacmi waśha puncucunäta lluy täpayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chay un'aypi Diospa anjilnin licalimuptinñatacmi carsil lulićhu acchïmun. Chayćhümi Pedrocta wätanćhu yataycul licchachila: “¡Pedro, śhalcuyña!” nil. Niptillanmi cadinancunapis maquinpi lluy pasquicälun. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jinaptinmi anjilca: “Müdaculcul śhucuyniquitapis ćhulacuy” nin. Chaynu lluy müdacüluptinmi: “¡Acuchun, catacuy!” nil yalaćhacalcämun. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Chaynu chay anjilpa ipanta śhayämulmi: “¿Rasunpachun cay icha suyñuyächun?” nil nicula. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Chaypi juc täpäcäta pasälälimunña, jinaman chay juccätapis pasämunña. Chay caminu yalamuna jïrru puncüman ćhämuptin'a, chay quiquillan quićhacacülun. Chaynu yalalcälimul wicniscamannuy cumpañayculmi anjilca japallantaña caćhaycülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Chayćhu rasunpa lulacäśhanta Pedro tantiaculculmi: “Canan'a tantiämi Duyñunchic anjilninta caćhamul, Herodespa ñatac llapa malca-masïcunap maquinpi imactapis lulapämänanpi salbamäśhanta” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chaypïtam Juan nipäcuśhan Marcospa maman Mariap wasinta licula. Chayćhümi Diosta ruygacuśhtin chay tuta achca juntulayalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ćhaycul puncunta tacaycuptinmi juc uyway wamla Rode śhutiyu yalämula: “¿Mayanmi?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Chayshi Pedrop shiminta lisïlul mana quićhal cushicuypi cürri-cürriywan cuticuycun: “¡Pedrom tucayämuñä!” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Niptinmi: “¿Ima? ¿Lücälunquichun imam, wamla?” nicuyalcan. Nipäcuptinpis: “¡Rasunpa paymari!” nicuyan. Niptinmi: “Ampá, pay cälun'a. Alma imantaćh licälunqui” nipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro jinalla tacapayämuptinñatacmi quićhäläliptin rasunpa pay cañä. Chayćhümi licapayllaman camälälisha: “¿Ima? ¿Suyñuyällachun icha licayällachun?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Chaymi Pedro siñaśhchala upällapäcunanpä. Jinalculmi Jesusninchic imanuypa chay carsilcäpi lluy julamuśhantapis willaycula. Jinaman: “Lluy caycunacta llapallan chalapacü-masinchiccunactapis willaycäliy, ñatac mastá Jacobocta” nila. Nilculmi chaypi juc-lädu malcacta licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Chay wäla carsilcäćhu Pedrocta watucälälil mana mayannin cachacu nï pï imanuypa chincaśhanta yaćhapäcuptinmi umapis muyüśha cacuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jinaptinmi Herodes ashichimul mana talipämuptin täpäcunäta imanuy caśhantapis lluy tapulcul: “Am täpä wardiacunam juchayu capäcunqui. ¡Bïdayquiwan canan pägapämay!” nil wañüchila. Jinalculmi cay Judea malcäpi Herodes licula Cesarea malcäta chayćhu unay capaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ñatac Herodes chay Tiro, Sidon pulan malcäpä sumä piñacüluptinmi chay-lädu nunacunaca: “Ya'anchic'a Herodespïmi mantinicunchic ima micuypïpis. Canan paywan allinpanacunapä imactapis lulaśhun, jinal paywan juntunacuśhun chaycunapi limananchicpä” nil limanaculcan. Chaymi cumisyunta caćhala Herodespa chalapacuśhan Blasto śhutiyu nunanman: “Malcäta faburta lulaycallämay caycunapi” nil. Niptinmi Blasto awnilcul limanacalcämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chay muyunca ćhämuptinmi Herodes mandacü müdananwan müdapacüśha täcunanman ji'aculcul chay jinantin malcäpa limamula. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jinaptinmi lluy nunaca ayaycaćhaypa alawäcuyalcan: “Cay nuná tuquictam limañä juc dios-yupaypis; manam nunanüllachu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chayćhu Herodes'a “Dioswan iwalmá cacuyá” nil alawachicücuyaptinmi chay üra Diosninchicpa juc anjilnin śhalcamul ishyayta uycülun. Jinaptinmi culup śhülïsha wañula. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ñatac Diospa willacuynin'a mas callpawanmi intiru malcacunäman milala. ");
INSERT INTO qvwNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Chay Bernabëwan, Saulo chay Jerusalenćhu ima lulaynintapis lluy camacalcälilñatacmi, Juanpa lisipäcuśhan Marcosta puśhacalcälil Antioquia malcäta caśhan cutipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Chay Antioquia malca chalapacücunäćhümi capäcula willacücunäpis, yaćhachicücunäpis. Paycunam capäcula, Bernabé, “Yana” nipäcuśhan Simon, Cirene malcapi Lucio, Galileap mandänin Herodeswan cusca ishpï Manaen, jinaman'a Saulo. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Chayćhu juc cuti llapan paycuna ayunaśhtin Diosta alawal juntulayalcaptinmi Chuya Ispiritu nïmun: “Lulaynïta lulananpä Bernabëtawan, Saulocta laquiycapamay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Niptinmi ayunaycul Diosta ruygacuyta camacalcälil pulanmanpis umanman maquinta ćhulaycul caćhälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jinaptinmi Chuya Ispiritu puśhala Bernabëtawan Saulocta lamar patanćhu Seleucia malcäman. Chaypïmi barcuwan liculcäla lamar ćhawpićhu Chipre malcäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chaypi Salamina lamar patanćhu malcäman ćhaycälilmi Israel malca-masincunap juntunaculcänan wasicunaćhu Diospi willaculcäla. Chayćhümi Juanpis paycunawan lila yanapaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","Chaynu jinantin malcäta muyulcäśhanćhümi Pafos nishan malcäman ćhälälin. Chaypa puydïninmi Sergio Paulo śhutiyu, allin umayu tantiay-sapa nuna cañä. Pay Diospa willacuyninta uyalïninwan Bernabëtawan Saulocta ayachiptinmi puydïcäwan cusca cayäñä Diospa willacünin pasachicü pasaypi läya Israel nuna Barjesus śhutiyu. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Griego limayćhu'a cay rüjätam Elimaspa lisipäcula. Paymi chay puydïnin mana chalapacunanpä mićhacuypa mićhacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jinaptinmi Saulop lisipäcuśhan Pablo, Chuya Ispiritup munayninćhu cayal piñäśhanu licapaycul chay rüjäta nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“¡Casquish, mana pin'acü pasaypi nuna, Satanaśhpa cumpinchin! ¡¿Imaycamatan Diospa allin yaćhachicuyninta juc-läduman iwiyanqui?! ");
INSERT INTO qvwNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chaynu caśhayquipïmi canan Diosninchicpa maquin ćhäśhunqui aśhta imaycamapis ñawiqui apläśha tutapällaćhu cawsanayquipä” nin. Nilcullaptinmi Elimas aplälul juc nunacta chancuycaćhananpä ayacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chaynu pasaśhanta licalculmi chay puydïca Jesusman chalapacula “Manamá imaypis licalächu caynu lulätá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chaypïtam Pablo, Bernabëwan, Juanwan pasaculcan Pafospïta, Panfilia-lädu Perga malcäman. Chaypïtam Juan cuticamun caśhan Jerusalenman ishcayllantaña caćhaycul. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jinaptinmi paycunapis pasaculcan Pisidia-lädu malcap sircan Antioquia malcäman. Chayćhu juc warda muyunćhu juntunaculcänan wasiman yaycaycälilmi täcuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jinaptinmi camachicuytawan unay willacünincunap librunta lïgiy camacalcälil chay juntunacüpa puydïnincuna: “Taytacuna, ichapisćha ima niycälimänayquipis cayan callpanchaycälimänayquipä. Má, niycälimay” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Niptinmi Pablo śhalculcul, siñaśhchala upälla capäcunanpä limayta allaycunanpä. Jinalculmi nila: “Llapallayquipis malca-masïcuna, ñatac Diosta manchacü mana-Israelcuna, uyalipämay. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yaćhaśhanchicnüpis unay awilunchiccunacta Diosninchic nunanpä aclaculculmi, jatun nasyunman milachila Egipto nasyuncäćhu cayalcaptinlä. Jinaman chaypi pudirninwan julalcamul, ");
INSERT INTO qvwNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","chunyä ulucunaćhu tawa ćhunca wata intiru awantaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Chay Canaan-lädućhüpis anćhish jatućhä malcacunacta lluy alulculmi chayman unay awilunchiccunacta pasaypipa taycaycachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Jinalculmi chay malcanta tawa paćhac picha ćhunca (450) wata gubirnachila fiscunacta ćhulaycul aśhta Diospi willacünin Samuelcama. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chaynu allin cayäśhanpïmi llapa awquillunchic mañacula Diosta: ‘Juc puydï mandacüta śhaycaycälichipämay’ nil. Niptinmi śhaycachila Benjamin caśhtapi Cispa chulin Saulta. Paymi gubirnala tawa ćhunca wata intiru. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ñatac manaläpis unaytam Saulta jululcul, Davidta pudirnin gubirnananpä ćhulaycula. Paypïtam nila: ‘Isaïpa chulin David śhun'üpänümi, cäsucümi, imapis munaśhäta lulämi cayan’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Chaymi canan cay ya'anchic timpućhu, Diosninchic caćhamula unay gubirnäninchic quiquin Davidpa caśhtanpi Jesusta, jinantin Israel malcäta imam limalicuśhannuy salbananpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pay manalä lisichicuyaptinlämi jinantin Israel malcäta willala Juan: ‘Juchayquipi wanacul, Diosninchicman cuticalcamul, bawtisaculcay’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ñä cay pachäćhu manaña canan üraca sircayämuptinmi nila: ‘Ya'a manam chay pinsapäcuśhayqui nunächu cayá. Pay'a ipalläćhüñamari cayan. Payman'a manam imanmanpis iwalächu nï camächu uyway nunannuy śhucuyninta pichaycunalläpäpis’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Llapallayquipis Abrahampi caśhta-masïcuna, ñatac Diosta licaćhacü mana-Israelcuna, cay salbamäninchicpä willacuyca llapanchicpämá. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalenćhu llapa gubirnäcunawan nunacunämi Jesusta mana lisipäculachu, masqui simäna-simäna juntunacunan wasicunäćhu Diospa willacünincunap librun paypi limayäta lïgiyalcalpis. Jinaman chaynu wañuchipäcuśhanwanmi paypi limaśhanca lluy lulacacülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Chayćhu Jesus mana juchayu cayaptinpis Pilatoctam llapa nunapis wañuchinanpä ruygala. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chay librucunäćhu nishantanuy lluy lulalcälilmi, chay curuśhcäpi bäjalcachimul pampapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jinaptinpis Dios caśhan śhalcachimuptinmi ");
INSERT INTO qvwNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galileapi Jerusalenman cumpañänincunamanpis achca cuticuna licalimula. Paycunamá canan lluy malca-masinchiccunacta Jesuspi willaycüca cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Chayurá cay muśhü willacuyta sumäta uyaliculcay: Unay awquillunchiccunacta juc salbäninta unanpä Diosninchic limalicuśhancämi canan ya'anchic milayninćhu Jesusta śhalcachishanwan lluy lulacacülun. Paypïmi limayan Salmos libru allaycuyninpa atïninćhu: ‘Anmi chulí canqui; canan-pachapïmi ya'a taytayqui caśhä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Quiquin Diosninchictacmi aychan mana ismunanpä, śhalcachinanpäpis limalicula, caynu nil: ‘Davidta quiquí shimïwan limalicuśhäcätá aclacuśhäćhümi lulaśha’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ñatac David tantiaśhantam willamanchic jucwä Salmos librunćhu: ‘Manam cunsintinquichu Chuya Aclacuśhayqui nunayquip aychan ismuycunantá’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Cay nil David manam quiquinpïchu limayan. Yaćhaśhanchicnüpis David chay timpućhu'a Diosta sirbilam, ñatac chaypïtá wañuculam. Jinaptinmi pampaycuptin cuirpun lluy allpayäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Chayurá quiquin Diosninchic śhalcächimuptin mana uchucllapis cuirpun ismuycuśhancäpïmari limayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Taytacuna, sumäta uyalipämay. Cay Jesusllam ima juchactapis lluy pampachämachwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Payman chalapacullalmi ima juchanpïpis libri caycunman. Cay lulaytá Moisespa camachicuyninpis manamá imaypis lulanmanchu; juchacunacta pampachänanpäpis manamá callpan canchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","“Chayurá yan'al-lätac Diospa unay willacünincuna nishanca amcunactapis ćhayalcäśhunquiman. Yalpapäcuy chay nishanta: ‘Licay, am allincäta jamuyäcuna. Mana pinsapäcuśhayquitam nï willaśhuptiquipis quiripäcuśhayquitam ñawpäniquićhu lulaśhä. Jinaptïćha licapayllaman camäśha mana tantiayniyu wañuculcanqui’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Chaypi Pablowan Bernabé chay juntunacunan wasipi yalälälimuptinmi, llapa nunapis nipäcula: “Canannütapis cay willapämäśhayquipi masta willaycälillämay” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Juntunacuynin camacäluptinñatacmi, achca Israelcunaca Moisespa camachicuyninta atichï munäcunaca Pabloctawan Bernabëta atipäcula. Jinaptinmi paycuna nila: “Diosninchicman masïsu chalapaculcay paypa llaquipayninta jatun cuyacuyninta yaćhayalcalñá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chaypïtam canannu muyuntá malcantin nuna juntunacälälimun Diospa limayninta uyalï. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Chaynu nisyu-nisyu nunacta juntunacunan wasićhu licalculmi Israelcunaca nanachicucuyalcal ñaćhaña imanacücuyalcanpis. Jinalculmi Pabloctawan Bernabëta insultäcuyalcal ñaćhaña millpälälinpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jinacuyalcaptinpis paycuna mana imactapis manchalilmi nipäcula: “Cay Diospa willacuyninta am Israel-masïcunamanmi puntacta willaycunac cala. Ñatac caynu mana ćhasquïniquiwan'a wiñay cawsay imapis mana ucuśhuśhayquita tantiachimanqui. Chaynu captin'a mana-Israelcunapäćha ćhächishä. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Chaynütam Diosninchic nipämäla: ‘Juc acchictanümi amcunacta cay jinantin pachäćhu nunacunäpä ćhulayalcac. Chaymi masqui sïlüpa sapinćhu cä malcacunäpis ya'a salbaśhäta yaćhapäcun'a’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chay niptinmi mana-Israelcunaca alli-allicta cushiculcäla “Maynu tuquim Diospa willacuynin'a” nil. Chayćhümi lluy paypä cäcunaca wiñay simpri cawsay bïdacta ćhasquipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chaynüpam Taytanchicpa willacuynin chay intiru-intiru malcacunäman ćhäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ñatac Israelcunam ichá Diosman chalapacü allin cäniyu walmicunäta, malcap prinsipalnincunäta lluy umachäla. Chaymi Pablop, Bernabëpa cuntran śhalcacalcälil chay malcapi alülälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chaynäluptinmi paycunañatac ćhaquinman la'aśhan pulbüllactapis tapsilcul “Cunca cuchuyniquitam ashicuyalcanqui” nil Iconio malcäman liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Chalapacücunäñatacmi Antioquiaćhu lluypis cushisha-cama Chuya Ispiritup munayninćhu quïdapämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio malcäman ćhälulmi Pablowan Bernabé yaćhacäśha cayninwan malca-masincunap juntunaculcänan wasiman yaćhachï yaycapäcula. Chayćhu tumshumanpis yaycüta yaćhachiptinmi Israel mana-Israelcunäpis achca-achca chalapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mana chalapacü Israelcunäñatacmi paycunap cuntran limapapäcula mana-Israelcunaca ćhïnipäcunancama. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chaynu jinaptinpis Pablowan Bernabë'a mana imactapis manchalil unaylämi chay malcäćhu Jesuspi willacuśhtin capaycula. Diosñatacmi llaquipaynin sumä rasun caśhanta tantiaycachinanpä pudirta uycula milagrucunacta lulaycunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nunacunacá ishcayman laquinacüśhatacmi capäcula: parti'a Pablop Bernabëpa śhalcünin, partiñatac chay mana chalapacü Israelcunäman śhalcapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chay Israelcunaca mana-Israelcunäwan jucllachanacuycul limanacälälin mandänincunawan Pablocta Bernabëta lluy tamshaypa camacapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Chayta Pablowan Bernabé yaćhälälilmi Licaoniaćhu Listra, Derbe malcacunäman ayiculcäla muyülïninćhu malcacunämanpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chayćhüpis allin willacuypi jinallam willaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Cay Listraćhümi nasïdunpi mana imaypis pulilï wishtu nuna cañä. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Pay yaćhachishanta täcuyal uyaliyaptinmi pulilinanpä chalapacuynin caśhanta tantiaycul callpawan Pablo nila: “¡Juclla śhalcuy!” nil. Niptinmi paćhcalcünuy juclla śhalcüluptin ćhaquin pulilïlun. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Chaynu Pablo lulaśhanta llapa nunacunaca licälulmi ayaycaćhacuyalcan Licaonia limayninćhu: “¡Dioscuna nunaman muyuculculmi ćhämumanchic!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nilculmi Bernabëta śhutichälälin diosnin Zeuspa śhutinwan, Pabloctañatacmi yaćhachicü captin diosnin Hermespa śhutinwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jinaptinmi Zeus diosninpa atindïnin sasirdütipis ćhäcayalcämun chay malcap yaycunanćhu capillap waytan apacüśha, türun aticüśha taytachanpänuy ćhipiycapul llapa nunacunäwan Pabloctawan Bernabëta alawaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Chaynu alawapäcunanta tantiacälälilmi Pablowan Bernabé “¡¿Ima?!” nil müdanantapis laćhyacücuyan. Jinaśhtinmi llapa nunap ćhawpinman uśhtucaycälila, cay nishtin: ");
INSERT INTO qvwNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Taytacuna ¡¿imactatá lulayalcämanqui?! Ya'acuna manam dioschu capäcú; amcunanuy wañü nunallamá. Cay yan'al diosniquicunacta caćhaycul quiquin cawsä Diosman licaćhaculcänayquipämi willaycüniqui śhapämulá. Paymi sïlüta, allpäta, lamarcäta lluy imapis cänintinta lulacüca. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aw, unay timpu'a cunsintilam uman chalaśhanta nunaca imactapis lulananpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ñatac masqui jinalpis manamá imaypis pacaculachu. Aśhwanpam cay allin lulayninwan mayan caśhantapis licachicun. Paymari amcunaman tamyacta caćhalpamüca, micuypi mana capäcunayquipä, allin cusichacta uycuśhüniquipis, cushichishüniquipis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chaynu niptinpis chay-chica nunacta türun ćhipiycul paycunacta alawananpi mićhacuy sasa-sasam cacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chaypïtam Antioquiapi, Iconiopi juc Israelcuna ćhälälimun. Jinalculmi llapa nunap pinsamintunta juc-läduman iwilcul, chay nunacunäwan Pablocta tamshachicuyan. Pampäman wañüśhanuy ćhaćhäluptinñatacmi “Wañüchinchic-ari” nil malcap yaycamunan waśhaman aysälälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Chayćhu chalapacücunäñatacmi muyülïninćhu cunćhalayalcaptin Pablo śhalculcul chay malcäman caśhan cutiycula. Chay wälañatacmi Derbe malcäta Bernabëwan pulan pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chayćhüpis Jesuspi willapäcuptin achca chalapaculcaptinmi Listraman, Iconioman, Antioquiaman cutipämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chay malcacunäćhu chalapacücunäta watucuśhtin cutimulmi lluytapis callpanchäla: “Amamá Jesusta imaypis ipanchapäcunquichu. Paypa gubirnunman ćhänanchicpá caynu llaquicuycunactam pasananchic” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chay malcaćhü-cama juc puydï nunacta caminaycunanpä ćhulayculmi ayunal paycunapä Diosta mañacula. Jinalculmi chalapacuśhan quiquin Diosninchicpa maquinman ćhulaycul chaypi liculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chaypi Pisidia malcacunap chimpämulmi Panfilia malcacunäman ćhämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Chay Perga malcäćhu Diospi willacaycälishanpïmi Atalia malcäman pasacalcämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lulayninta camacalculñatacmi barcuwan cuticulcäla allaycälinanpä Diospa maquinman ćhulaycälishan Antioquia malcaman. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Chayman ćhaycul-pachañatacmi llapa chalapacü-masincunacta lluy juntuycachimul willala imacta Diosninchic paycunawan lulaśhanta, jinaman'a mana-Israelcunactapis quiquin Diosninchic payman licaćhacunanpä cunsintiycuśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chayćhümi chalapacücunäwan Pablowan Bernabé unaylä yaćhapaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chay timpućhu Judeapi nunacuna Antioquia malcäman ćhälälimulmi chalapacücunäta yaćhachicuyan: “Manamá salbaśhachu capäcunqui Moisespa camachicuyninćhu nishannuy mana siñalachicul'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chaymi Pablowan Bernabé chay yaćhachicücunäwan ruyducuyalcan. Chaymi chay malcäćhu chalapacücunaca ćhulälälin Pabloctawan Bernabëta juc cumpañänincunactawan Jerusalenta lil, chayćhu puydï yaćhapacücunätawan caminaycücunäta chay yaćhachicuycunapi limanaculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chaynalculmi paycunacta Jerusalenman caćhapäcula. Chaynu liyalcalmi Fenicia malcacunap, Samaria malcacunap pasal Israel-masincunacta willala: “Mana-Israelcunapis Diosninchictam canan'a sirbiyalcan” nil. Chayta uyalilmi allicta llapanpis cushiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chaypi Jerusalenta ćhäläliptinmi, lluy chalapacücuna, puydï yaćhapacücunaca, caminaycücunäpis allinpa ćhasquipäcula. Chayćhümi Pablowan Bernabé Diosninchic imacta paycunawan lulaśhantapis willala. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Chayćhu waquinnin fariseocunäpi chalapacücunañatacmi śhalcuculcul: “Chay mana-Israel chalapacücunaca ya'anchicnuy siñalachiculcächun. Jinalcul Moises camachimäśhanchicta lluy lulaycuchun” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nipäcuptinmi puydï yaćhapacücunäwan, caminaycücunaca chay cüsacunacta sumäta licaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Chayćhu llapanpis millpap-millpanacalcäliptinmi Pedro śhalcuculcul nila: “Cuyaśhá chalapacü-masïcuna, yaćhapäcuśhayquinüpis unaypïmi quiquin Diosninchic ya'acta aclamäla chay mana-Israelcunäta willaptí paycunapis salbaśha capäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mayanpa śhun'untapis lisï quiquin Diosninchic paycunactapis Chuya Ispiritunta uyaptin'a ya'anchictanüpis ćhasquishantam tantiaycachin. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pay'a juc-jucpächu mana licalmi paycunactawan ya'anchicta chalapacuśhallanchicpa chuyanchaycamanchic. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Chaynu cayaptin'a ¿imapïtan Diosninchicta ruydupayä-yupaypis, Moisespa camachicuyninta uyniquiwan ñitiyächinqui? Awilunchicpis nï ya'anchicpis cumpliy manamá atipälanchicchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Aśhwanpam paycunanüpis chalapacunchic Jesuspa llaquipacuyllanpa salbaycuśha caśhanchicta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chaynu niptinmi llapanpis upällälälila uyalipäcunanpä. Jinaptinmi Pablowan Bernabëpis willala quiquin Diosninchic mana-Israelcunäćhu maynu sumä allincunacta milagrucunactapis lulachishanta. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Chay nïta camacäluptinmi Jacobo nin: “Chalapacü-masïcuna, uyalipämay. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Canan Simonpi uyalishanchicnüpis quiquin Diosninchic chay mana-Israelcunäpïtapis wamäta japächacula nunancuna capäcunanpämi. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Cay nishan limayan unay willacünin isquirbishanćhümi. Chayćhümi niyan: ");
INSERT INTO qvwNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ “Chaypïta cutimulmi Davidpa ayllunta śhalcalcachil tacyachishä wasi tunïsha-yupay cäcäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Jinaptïmi Adanpi śhamü jinantin caśhtacunäpi nunacunaca ya'ap cäcá ashipäman'a” nil. Cay nilmari chay unay timpupi lluy willacachimula quiquin Diosninchic’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Chaymi ya'a ní: juchanpi wanaculcul Diosninchicman chalapacuyalcaptin'a ¿imapäñam juc sasachacuycunawan mana-Israelcunäta mastá ñitichichwan? ");
INSERT INTO qvwNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Chay lulananchictá aśhwanpa juc papilta apachishun: ‘Amaña pinsalcäliychu chay unay taytachayquicunap custumrinman'a, nï anla juchacuycunaman'a. Ñatac ama yawarnin pasäśha aychactapis micapäcuychu, nïtac yawarcunactapis’ nil niyäta. Chayllapämari capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ama pinsatïbu cayalcaychu; unay timpupïpis Moisespa camachicuyninpïta warda muyuncunäćhü-camam may juntunacuna wasićhüpis lïgil yaćhayalcächinlä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Chaypïtam puydï yaćhapacücunaca, caminaycücunaca, lluy chalapacü-masincunawan pinsälälin juc cumisyun numrayta Bernabëtawan Pablocta Antioquia malcäman liwshinanpä. Chaymi chalapacücunäćhu allinpa-cama licaśha Barsabas nipäcuśhan Judastawan, Silasta aclälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawanmi apachipäcula caynu limayä papilta: “Jesuspa puydï yaćhapacünincunäwan, caminaycücunäwan, chalapacücunäpis limaycälimuc Antioquia-lädućhu, Siriawan Cilicia-lädućhu chalapacücunäta. Mana-Israel caśhta cayalcaptiquipis Jesusninchic jucllachaycamäśhanchicpam cay papilta apayächimú. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Yaćhälälïmi cay malcäpi mana ya'acunap shimï-cama śhalcamul, imaymanacta limapalcul, lluy ishcay śhun'uchipäcuśhuśhayquita. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Chaymi amcunaman caśhan cutilcächimú Bernabëtawan Pablocta. Jinaman Judastawan Silasta Jesusninchicpa ñacäcuna capäcul llapanchicpïpis cuyaśha captinmi paycunawan cusca śhamunanpä ćhulapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Paycunapis cayćhu nipäcuśhactanüllaćh shiminwanpis niycälishunqui tacyalpälichishunquipis. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ya'acunapis ñatac Chuya Ispiritupis mana anchap uyalcänacpämi caycunallacta niycälic: ");
INSERT INTO qvwNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Taytachancunapä ćhipiycapuśhan uywacunacta ama micapäcuychu, nïtac yawarnin pasäśha aychactapis nï yawarnincunactapis. Jinaman'a ima anla juchacuycunapïpis japächaculcay. Cay nishäcunätanuy lulapäcuptiqui'a, cawsayniqui allinmi can'a. Jamallá” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chaynu Antioquia malcäman ćhälälil-pacham chalapacücunäta juntuycul apachishan papilcäta uycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chayćhu lïgilcälilmi llapanpis cushiculcäla chay papil balurchaycuśhanpi. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jinaman Judaswan Silaspis, Diospi willacücuna capäculmi shiminwan callpanchaycälila, masïsu chalapaculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chaypïta chayćhu unay caycuyaptinmi chay cumisyuncäta caćhälälila malcanta jawcallaña cuticalcämunanpä. ˻ ");
INSERT INTO qvwNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Jinaptinpis Silas yaćhacaypanuy yaćhacälulmi mana cutiyta munalachu.˼ ");
INSERT INTO qvwNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Jinaman Pablowan Bernabëpis Antioquiaćhu quïdacalcämulatacmi chalapacücunawan Jesuspi willacuśhtin yaćhachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chayćhu allin unayña cayalcäśhanpïmi Pablo Bernabëta nila: “Acuchun, intirućhu Jesuspi willaśhanchic chalapacü-masinchiccunäman lishun imanuy caśhantapis watucamü” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Niptinmi Juanpa lisipäcuśhan Marcostapis puśhayta Bernabé munala. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pabloñatacmi ichá mana munätuculachu, chay puntacta puśhaptin Marcos caćhaycul Panfilia malcällapi cuticamuśhanpi. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Chaynu mana munaptinmi allicta piñanaculcul, sintichinaculcul wicta cayta liculcäla. Chaymi Bernabé Marcosta puśhaculcul Chipre malcäta pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pabloñatacmi ichá cumpañäninpä Silasta ashicülun. Jinaptinmi chayćhu llapa chalapacücunaca Dios yanapänanpä maquinman ćhulaycuptin liculcäla chay malcapi juc-lädu malcacunaman. ");
INSERT INTO qvwNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jinalmi Siriap, Ciliciap malcancunaman ćhäla, chayćhu chalapacücunäta tacyalpachishtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Derbe malcäpi Pablo pasalmi Listra malcäćhu talïlun chalapacü nunacta Timoteo śhutiyüta. Paymi Israel caśhta chalapacü mamayu, taytanpïñatac mana-Israel caśhta cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Paypïtam cay Listraćhu, Iconioćhu cä chalapacücunaca allinta limapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Chaymi Pablo cumpañïrunpä “puśhacuśhä” nila. Ñatac taytanpi mana-Israel caśhta caśhanta llapanpis yaćhapäcuptinmi Pablo: “Timoteocta ya'acunactanümi siñalachishä malca-masïcuna yan'al mana jucnüpa licapämänanpä” nil siñalachila custumrinmannuy. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Chaypïtam intiru malcacunap pasapäcula Jerusalenćhu puydï yaćhapacücunaca, caminaycücunaca limanaculcäśhanta “cäsuculcay” nil willacuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chaynu uyalichiptinmi llapa chalapacücunäpis mas masïsucta chalapaculcäla. Jinaman muyun-muyun mas achcamantac milapäculapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Chaypi Asia-lädu malcacunäćhu willacuyta munaptinpis chay-läduman linanta Chuya Ispiritum mana cunsintilachu. Jinaptinmi Frigiap, Galaciap malcancunap pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Chaynu liyäśhanćhu Misia-läducunap lindanman ćhälul Bitinia malcacunäman yaycuyta munaptinpis Chuya Ispiritum yaycunanpä mićhacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Chaynu dirichucta pasaśhanćhümi lamar patanćhu Troas malcäman ćhälun. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chayćhümi chay tuta Pablop suyñuyninćhu juc Macedonia-lädu nuna puntanćhu śhäcuyal ruygacuyäñä “Macedoniacta śhamuy, yanapaycamänayquipä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Chaynüta suyñülul-pacham “Caycunawan'a Diosninchicmi tantiachimanchic willananchicpä” nila. Niptinmi Macedoniacta pasapäcunäpä alistaculcälá. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jinalcul lamar patanćhu Troas malcäpi barcuwan pasapäcuśhäćhümi ćhälälí chay lamar ćhawpićhu Samotracia malcäman. Chaypi chay wäla pasapäcuśhäćhülämi Macedoniap Neapolis malcanman ćhälälí. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chaypïtam Roma nasyun tacyachishan Filipos malcaman liculcälá. Cay malcam Macedoniap mas prinsipal malcan cala. Chayćhümi unaylä capäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Chaypïtam chay warda muyuncäćhu malcäpi yaluculcul lipäculá mayu-läducta “Cay cayćhu cayanpisćha Diosta mañacunapä sityup” nil. Chayman ćhaycul taycacaycälilmi chayćhu juntula walmicunäta Jesuspi willapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Chayćhu jucnin walmim Tiatira malcapi cañä Lidia śhutiyu. Paymi sumä fïnu-fïnu-cama tïla nigusyuyu cacuñä. Pay'a Diosta imaypis pinsalaśhtinshi Jesusta mana lisiyalpis cala. Chaymi Pablo Jesuspi willaptin Diosninchic gänaśhwan uyaliycachiptin chalapacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Chaymi wasintin lluy bawtisachicälälil wasinćhu quïdachipämänanpä ruygacayalcäman: “Rasunpa Jesusman chalapacuśhäta tantiapämaptiqui'a, acuchun, wasïćhu jamaculcay” nil. Nilculmi quïdälächiman wasinćhu. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Chaypi juc-pun mañacunan sityüta yapa cutilcäśhäćhümi talïlälí Satanaśhpa maquinwan licacuyta yaćhä wamlacta. Chay wamla uyway calmi puydïnincunacta licacuyninwan illaypi'a altullaćhu cachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chay wamlam ya'acunap ipäta śhacayämun apalcaćhaypanuy: “Cay wayapacuná Sumä Munayniyu Diosta sirbïcunam. Chaymi amcunacta willalcäśhunqui imanuypa salbaśha capäcunayquipäpis” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Caynu achca muyuncunaña nïlla niyaptinmi Pablo rabyalcul chay wamlaćhu cä achatüta: “¡Salbacü Jesuspa pudirnin caynïwan cay wamläta caćhaycuy!” niycülun. Niycüluptin-pacham achatun caćhaycüluptin licacuynintapis wamlaca lluy pantälun. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Chaynu illay ünin jinäluptinmi nunancuna rabyälul Pabloctawan Silasta chalalcul aysacuyalcan chay malcap prinsipal pläsanćhu cä puydï awturidänincunäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Chayćhu paycunaman ćhaycachilmi: “Cay Israelcunämi malcanchicta pilyuman ćhulayan cuntranchic mala-mäña custumricunacta yaćhachishtin. Caycunacta ya'anchic Roma-lädu cayal'a manam awnil ćhasquiyänanchicchu” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Niptinmi nunacunäpis Pablop Silaspa cuntran śhalcucuyalcan. Jinaptinmi fispis: “Müdananta lluy uśhtilcälil calallacta wiryap wiryaycäläliy” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Chaynu lluy camacalcuptinmi carsilcäman pasachila. Chayćhümi chay carsil täpäcäta sumäta täpananpä ćhuncay-ćhuncay nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jinaptin carsil mas tunäman apaycachilmi cadinawan ćhaquincunacta pampäman cadinaycul cachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Jinaptinmi chay ćhawpi tutani'a Pablowan Silas Diosta mañacuyalcan, taquiyalcan. Chayćhümi juc prïsu-masincunapis uyaliyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chayćhümi un'aypi juc jatun śhaśhay pasal chay carsilpa simintuntapis śhaśhalcachil llapa puirtancunactapis manyapi quićhacacächin. Ñatac llapa prïsup cadinancunapis lluy shacllallacyayllam pasquicacülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Chay jinaman carsil täpäca licaćhacämulmi, llapa puirtactapis quićhalayäta licälun. Jinalculmi “Taytallay-taytay, canan'a juc prïsupis canmanchu-ari” nil ispädanta julalcamul “tucsicüśhä” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Jinacuyaptinmi chay lulipi Pablo ayaycaćhämun: “¡Ama wañuchicuychu! ¡Llapämi cayćhu cayalcá!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Niptinmi täpäca “¡Acchicta apamuy!” nil chay lulicta licä cürri-cürriwan ji'acuycun. Jinalculmi manchapacüśha chucchuśhtin Pablop Silaspa ñawpäninman un'ulacuycul: ");
INSERT INTO qvwNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","“Taytacuna, ¿imactalä lulalläman salbacunäpä?” nicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","34","Niptinmi: “Jesusman chalapacuy; salbaśham canqui ampis aylluyquipis” nipäcula. Niptinmi chay nunaca waśhaman julalcamul chayćhu pa'aycul llapa dañäduncunacta jampiycula. Jinalculmi wasinta puśhaculcul micuytapis micachimula. Chayćhümi chay wasićhu aycam cäcäta Pablowan Silas Jesuspi willala. Jesusman chayćhu chalapaculculmi chay nunaca lluy wasintin chay üra bawtisachiculcäla. Jinalculmi wasinćhu aycam cäcunaca cushisha capäcula Jesusman chalapaculcäśhanpi. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chay wälam fiscunaca chay carsil täpä nunäman cumisyunta caćhälun: “Pabloctawan Silasta caćhaycuchun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Niptinmi chay carsil täpäca Pablocta nila: “Fiscuna partipïmi cumisyun ćhämuman ‘Pabloctawan Silastash caćhaycunqui’ nil; chayurá, taytacuna, jawcalla liculcänayquipä yalupäcuy-ari” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Niptinmi Pablo: “¿Ima? Roma-lädu nuna cayalcaptïpis mana sumä yaćhacuycultac llapa nunap puntanćhu upaminti caynüpa lawćhayalcächiman. Jinalcultac cay carsilcämanmi wićhaycayalcächiman. Chaynu jinalcälilchun canan pictapis mana yaćhachï-tumpalla caćhaycälichimayta munan. Juluyta munapämal'a quiquin fiscunaca śhamumächun, llapanpa ñawpäninćhu ‘Mana juchayümi canqui’ nil tantiachinanpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Niptin imam nishantanuy wardiacunaca chay fiscunäta willapäcuptin Roma caśhta capäcuśhanta uyalïlälilmi alli-allicta manchapacälälisha muyuycaćhacuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Chaymi uchuc shimillanwan ćhäpäcula Pabloman, Silasman “Cay lulaśhacpi pampachaycälillämay, taytacuna” nil. Chaynu julalcälimulmi chay malcapi liculcänanpä alli-allicta ruygapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jinaptinmi chay carsilpi yalalcälimul pasacalcämula Lidiap wasinta. Chayćhu llapa chalapacücunäwan tincuyculmi, callpanchaculcänanpä lluy limapaycälishanpi chay malcäpi pasaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Chay Anfipolis malcap, Apolonia malcap pasälälilmi Tesalonica malcäman ćhälälin. Chayćhümi Israel malca-masincunap juntunaculcänan wasi cañä. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Chayman yaćhacäśha cayninwanmi quimsa warda muyuncunäćhu Pablo lila. Chayćhümi tantiapaśhta: “Diospa Caćhaśhan Salbacücäta wañulcachiptinpis caśhan cawsamunanpämi isquirbishancunaćhu limayan. Chaymi cay willacuśhä Jesus'a quiquin Diospa Salbacüca” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Niptinmi waquin malca-masincunapis achca mana-Israel allinnin walmicunapis, umricunapis Diosta manchacücá Jesusman chalapaculcul, Pablowan Silaswan jucllachanaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mana chalapacü Israelcunäñatacmi ichá sumä nanachicalcälil llapa suwa juyu nunacunacta mincacaycälil Pablop Silaspa cuntran lüyacuyalcan malcaca paypa janan śhalcunanpä. Jinalculmi Jasonpa wasinmanpis yaycucuyalcan Pabloctawan Silasta aysalcamul malcäpa maquinman ćhulaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Chayćhu mana talilcälilmi Jasontawan juc ishcay chalapacücunätaña aysacuśha ji'acaycälin jatun awturidäninman. Ćhaycachilmi: “Cay Pablowan Silas, jinantin pachäćhu llapa nunacta turbachïcächun, canan cay malcanchicmanpis ćhämunman. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Chaycunactalächun Jason'a wasinćhu ćhasquiñäpis. Jinaman'a Romap Puydï Mandacüninchicta ipanchaycul-lätac ‘Jesusmi rasunpa gubirnamäninchic'a’ nil nipäcuñä canpis” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Niptinmi awturidäcunaca “Imapis talcülun'aćh” nil manchapacüśha cacuyalcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Chaymi Jasonpa illayninta chalalcul “Anmi imanuypis cacunqui” nil Jasontapis paywan cäcunätapis caćhaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chay tutalpüluptinñatacmi chalapacücunaca Pabloctawan Silasta Berea malcäman dispachälälila. Chayman ćhälälilmi, malca-masincuna juntunaculcänan wasiman Jesuspi willacü lipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Chay Berea nunacunam Tesalonicaćhu nunacunäpïtá mas intirisniyu capäcuñä. Chaymi muyun-muyunpis isquirbishacunacta licapäcula “Pablo nishancuna rasunpachućh” nil tincuchiyninwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nishannuy captinñatacmi Jesusman achca Israelcuna chalapaculcäla jinaman allin cäniyu mana-Israel walmicunapis umricunapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Chay Bereaćhüpis Pablo Diospa willacuyninta yaćhachishanta Tesalonica malcaćhu mana chalapacü Israelcuna yaćhälälilñatacmi cürrïlälimun. Chayćhümi Pablop cuntran limacuyalcan llapa nunamanpis mismichiyninwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jinapacüśhan-pachallam chalapacücunaca Pablocta lamar-läduman ayichiculcäla. Silaswan Timoteoñatacmi ichá chayllaćhu quïdaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Chay Atenas malcäcama Pablocta cumpañalcälilmi cutïlälimun “Silaswan Timoteo canan-pacha linanta Pablom munan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ñä Pablo Atenas malcäćhu Silasta Timoteocta alcayal chay malcaca imaymana diosninwan shipuchicüśha caśhanta licalculmi śhun'unpis tipship-tipshicuyäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Chaymi chay juntunaculcänan wasićhu Israel-masincunawan ñatac Diosta manchacü mana-Israelcunäwanpis impïñuwan limapäcula. Jinaman pläsaćhu cä pï nunacunawanñapis muyun-muyunmi limayäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jinayaptinmi Epicuriu caśhta llaqui yaćhay-sapacunawan, ñatac Estoico caśhtapi umanllancunaca Pablocta tapuyta allacaycälila imapi limaśhantapis. Chayćhümi waquincuna: “¿Ima limaywanćha shiminta mishquichicuyan?” nipäcula. Juccunäñatacmi: “Juc-lädu malcap diosnincunap willacuyninta muyuchicüpisćhá” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chay nilcälilmi Areopago nishan nunacunap juntunaculcänanman puśhalcälil tapupäcula: “¿Willaycälimanquimanchun cay yaćhachicuyniquiwan imacta niycälimäśhayquitapis? ");
INSERT INTO qvwNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mana imaypis uyalipäcuśhätachućh jinam uyaliyalcächimanqui. Má, willaycälimay ya'acunapis yaćhapäcunäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Cay Atenas malcayücunacá ima muśhü willacuycunactapis uyalilcul, willanacuyllaćhümi ucupaculcäla.) ");
INSERT INTO qvwNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pabloñatacmi paycunap ćhawpinman śhaycucuycul: “Cay Atenas malcayu taytacuna, cay ñawïwan licaśhäcunam willaman amcuna diosniquicunaman chalapaculcäśhayquita. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Cay malcayquiman yaycul ‘Má, imactash mayćhüshi alawapäcuñä’ nil pulishäćhümi licälú juc uycunaćhu ‘Cay patac uycunacá unanchäśha cayan Mana Lisishanchic Diospämi’ nil wätanćhu isquirbïshacta. Canan chay ‘Mana Lisisha Dios’ alawapäcuśhayquipïmi willaycälishayqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Cay allpa sïlu licalichï Diosmi cay allpäpa sïlüpa Taytan. Chaymi pay'a mana nï nunacunap lulaśhan wasicunallaćhu canan canchu, ");
INSERT INTO qvwNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nïtac mayantapis nisitanchu imacta lulapunanpäpis. Aśhwanpa paymi llapanchictapis cawsayta, lluy imactapis uycamäninchic. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Pay'a jucllay nunallapïmi imaymana caśhtaman milachila, cay jinantin allpäćhu cawsapäcunanpä. Unanchaycapulatacmi timpucunätapis ñatac mayćhu yaćhapäcunanpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Lluy caycunacta lulala llapa nunapis payta ashil masqui yataycuyllapapis talipäcunanpämi. Rasunpa llapanchicpïpis pay'a manam calućhüchu nï mana talinaćhüchu cayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Aśhwanpa payćhümi cayanchic, puliyanchic, cawsayanchicpis. Quiquiquicunap waquinnin libru isquirbïniquicunapis cayta musyal ¿manachun ‘Diosninchicpa milayninmi ya'anchic canchic’ nil isquirbipäcula? ");
INSERT INTO qvwNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“¿Chaynu rasunpa Diospa milaynin cayalchun, pinsayachwan nunacunca uman chalaśhan ürupi illaypi lumipïpis aläjacunacta lulaculcul ‘Caymi dios’ nimäśhanchicman? ");
INSERT INTO qvwNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ñatac unay timpućhu'a caynu upa lulaycunacta nunaca lulayaptinpis Dios'a manam imanilapischu. Cananñatacmi ichá mayćhüpis juchanpi wanaculcul cuticalcämunanpä lluyta ayayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Cay jinantin pachäta aclacuśhan nunanwan cäraycachinanpämari juc muyun unanchäśha cayan. Cay rasunpa pasananta wañuśhanpi śhalcachimuśhanwanmi llapanchicta tantiachimanchic” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Cay “Wañücuna śhalcamunmi” nishanta uyalïlälilmi waquinnincuná asipapäcula. Waquinnincunañatacmi: “Juc muyunñamá masta uyaliycuśhayqui” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Chayćhümi Pablo licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Waquinnincunañatacmi ichá willaśhanman chalapaculcäla. Paycunam capäcula Dionisio śhutiyu wayapa chay Areopago nunacuna partipi, ñatac Damaris śhutiyu walmipis, jinaman juccunapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Cay Atenaspïmi, Corinto malcäman Pablo licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","Chayćhümi lisinacülun Ponto-lädu Aquila śhutiyu nunawan. Paymi walmin Priscilawan chayllalä Roma malcäpi ćhämuśha capäcula Romap Mandänin Claudio: “Aycam cayćhu yaćhä Israelcunaca caypi liculcächun” niptin. Chayćhu paynu Aquilapis utapi carpacunacta lulä caśhanta yaćhälulmi paycunawan cuscan lulapäcunanpä Pablo lila wasinćhu quïdacü. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Warda muyuncunaćhüñatacmi juntunaculcänan wasiman Pablo lil Israel mana-Israelcunätapis Jesusman chalapaculcänanpä jicutaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Chay malcaćhu cayaptinmi Macedoniapi ćhälälimun Silaswan Timoteopis. Chaymi Jesusllapïña Israel-masincunacta Pablo mastá willacula “Jesus'a Salbamäninchicmi” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Niptin chay mana chalapacü malca-masincuna Pablop cuntran śhalcul imaymanacta palapäcuptinmi müdananta tapsicuyan: “Cunca cuchuyniquita quiquillayqui ashiyalcaptiqui'a ya'a manam juchayüñachu cayá. Cananpi'a, mana-Israelcunämanñam willacü licuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Chay juntunaculcänan wasipi yalalcamulmi Diosta manchacü Ticio Justup wasinman licula. Chay juntunaculcänan wasip läduscallanćhümari cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ñatac chay juntunaculcänan wasip puydïnin Crispo nishanpis llapa aylluntinmi Jesusman chalapaculcäla. Chaynütacmi achca Corinto malca-masincunapis uyalipäcul chalapacalcälil bawtisachiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Chayćhu cayaptinlämi juc tuta Pablocta suyñuyninćhu Diosninchic nila: “Pablo, ama manchaliychu; mana upällallal, willacuy jinalla. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Anwanmi ya'a cayá; manam pipis tupaycuśhunquichu. Cay malcaćhu achcalämari nunäcuna cayalcan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Niptinmi cay Corinto malcäćhu wata partinlä Pablo yaćhala Diospa willacuyninta lluyta willacuśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","13","Chayćhu cayaptinlämi, Galion śhutiyu nuna Acayap malcancunap puydïnin cayaptin llapa Israel-masincuna Pablop cuntran śhalcälälila. Jinalculmi chay puydïman puśhapäcula: “Cay wayapam camachicuynïcunacta iwilcul llapa nunactapis limapäñä Diosta alawananpä” nil tumpaśhtin. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Niptin chayćhu Pablo “limalcuśhä” niyaptinmi chay puśhä Israelcunäta Galion nila: “Sumäta uyalipämay. Ya'a uyalicmanmi nuna wañuchiypi, ütac imapis chaynu cüsapi captin'a. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ñatac chalapacuyniquicunapïtá, camachicuyniquicunapïtá, śhuticunapïtá, ima captinpis manam imapis ucamanchu. Quiquiquicuna chaytá arrinläculcay; ya'a manam imapi miticamuná canchu” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nilculmi chay dispächunpi lluy alämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jinaptinmi juntunaculcänan wasip puydïnin Sostenes nishan umricta chalalcälil, Galionpa puntanćhu lluy camacäcuyalcan. Jinacuyalcaptinpis Galiontá manamá imallapis uculachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Chaypïtapis cay Corinto malcäćhümi unaylä Pablo capaycula. Chaypïtam chalapacücunäpi dispidiculcul Siriacta cutipämunanpä barcuman ishpipäcula Priscilawan Aquilawan cumpañachiculcul. Manaläpis yalulmi Cencrea malcäćhu umanta lutuchicula, Diospa imacta limalicul lluy cumplinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jinalculmi Efeso malcäman pasacalcämul juntunacunan wasiman Pablo yaycul Israel malca-masincunawan piñanaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Priscilawan Aquilañatac “capaycuśhunlä” niptinpis manam munalachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Chayćhu caćhaycul: “Dios munaptin'a, yapaćhüñaćh cutimuśhä watucamüniqui” nilmi chay Efeso malcäpi barcuwan licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Chaypi Cesarea malcäman ćhayculmi chalapacücunäta limaycü Jerusalenta pasacula. Chay-pachallatacmi Antioquiacta licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chayćhu caycuśhanpïtá yapa Galacia, Frigia-lädu malcacunäpa pasalñatacmi manyapi lluy callpanchaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","25","Ñatac chay timpupämi Efeso malcäman Apolos śhutiyu Israel nuna ćhämun. Paymi Alejandria malcayu Egipto nasyuncäpi, achca nunap ñawpäninćhu limaypa yaćhacäśha, ñatac Diospa libruntapis allicta lisï cacuyäla. Jinaman Bawtisä Juan, Jesuspi limaśhallanta uyaliyalpis Jesuspïta sumä tincüninman allintam yaćhachiñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Chaynu juntunaculcänan wasićhu imactapis mana manchalil chaynu willacuśhanta uyalïlälilmi Priscilawan Aquila wasinta puśhalcul Jesuspïta masta willapaycälila. ");
INSERT INTO qvwNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","28","Ñatac Apolos: “Acaya-läductam lishä” niptinmi chalapacücunaca callpanchapäcula, yanapapäcula. Chaymi chayćhu cä chalapacü-masincunapä papiltapis lulälälin “Apolosta allinpa ćhasquiycäliy” nil. Chaypi Acayaman ćhälulñatacmi mana chalapacü Israelcunäwan chalanaculcul Diospa shiminpïta tuquicta tantialpachila Jesus caćhamuśhan Salbacüca caśhanta. Chaynüpam Diospa llaquipayninćhu cä chalapacü-masincunacta sumä callpanchäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ñä Corinto malcäćhu Apolos cayaptinmi, Pablo'a Efeso malcäta cutinanpä chayćhu cä malcacunap ipanpa dirichäla. Efesoman ćhaycul achcasca chalapacücunacta talilculmi ");
INSERT INTO qvwNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","tapula: “¿Chalapaculcäśhayqui üra, Chuya Ispiritu pudiracuycuśhulanquichun?” nil. Niptinmi: “Manam imaypis Chuya Ispiritupi'a uyalipäculächu” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Niptinmi: “Chaynu captin'a bawtisacuśhayqui üra ¿‘piman chalapacú’ niltan bawtisaculcälanqui?” nin. Niptinmi: “Bawtisä Juan limapapämäśhanman chalapaculmi” nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Niptinmi: “Rasunpa Juan'a bawtisala Diosman cuticamücunätam. Ñatac ¿yalpanquichun ‘Ya'ap ipäta śhamücämanmi chalapaculcanqui’ nipäcuśhuśhayquita? Chay Jesuspïmari cala” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nishanta uyalïlälilmi: “Cananpi'a Jesuspäñam caśhä” nil bawtisachiculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Chayćhu Pablo maquinwan yataycuptinmi Diospa Ispiritun paycunapi pudiracuycula. Jinaptinmi mana yaćhaśhan limaycunaćhu Dios cüsapi limacuyalcan willacuynintapis willacücuyalcantac. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Chay lulä nunacunaca ćhunca ishcayniyu umricunam capäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Chay malcap juntunaculcänan wasiman Pablo lilmi quimsa quilla chayćhu imactapis mana manchalil Diospa gubirnunta ćhasquipäcunanpä jicutäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ñatac waquinnin cullucuycul mana chalapacuyta munapäculmi llapa nunap ñawpäninćhu chay Muśhü Caminupi mana allinta limapäcula. Chaymi Pablo yaćhachishanta aycam ćhasquïcunäwan japächaculcul Tirano nishan limanacuna wasiman aśhuculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Chayćhu ishcay wata intiru muyun-muyun Jesuspi yaćhachiptinmi jinantin Asia-lädu malcacunäćhüpis Israel mana-Israelcunaca Diospa yaćhachicuyninta lluy uyalipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chayćhu Pablopmi Dios imaymana milagrucunacta lulala. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Chaymi pañuylunpis, ütac ćhulaculcuśhan müdananpis ishyäcunäman apaśha captin'a imawan ishyäcunapis, ñatac achatucunap maquinćhu cäcunapis lluy allinyapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Chaynütacmi paycunanüpis waquin Israelcuna Jesuspa śhutinta limal achatucta aluyta jicutaycaćhapäcula “Pablo willacuśhan Jesuspa munayninpamá, cay nunäta caćhaycuy nic” nil. Paycunaćhümi Israelcunap jucnin puydï sasirdüti Escevap anćhish chulincunapis cala. Paycuna juc-punćhu'a chaynu lulayalcaptinmi achatu nila: ");
INSERT INTO qvwNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","“Jesusta lisïmi, ñatac Pablo mayan caśhantapis yaćhätacmi. Ñatac amcuná ¿imallatá capäcunqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nilcul-pacha chay achatuyu nunaca callpa-callpawan walcacacälulmi llapantapis duminalcul supayninta apächin. Jinaptinmi chay wasipi pasaypi ma'aśha calanllan ayiculcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Chayta yaćhälälilmi Efesoćhu cä Israel mana-Israelcunäpis Jesuspa śhutinta manchacuywan licapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Waquinnin chalapacücunäpis ima mana allin lulapäcuśhantapis llapa nunap ñawpäninćhu willapaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Waquin rüjacunapis llapa rüja libruncunacta apalcälimulmi “Wanacuśhunña caycunapi” nil cañaycälälila. Chay cañaśhancuna ćhaninchaptin'a paćhac picha ćhunca (150) wata trabajup ćhaninmanmi ćhäñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Cay lulaśhancuna intiruman ćhaptinmi llapa nunapis Diospa willacuynin callpayu caśhanta tantiapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chaypïtam Pablo pinsälun: “Jerusalenta lil, Macedonianta, Acayanta pasäśhä. Jerusalenpïñatac Romacta pasacuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Chaymi Macedoniaman ishcay yanapäninta Timoteoctawan, Erastocta puntalcachil Asia-lädu malcäćhu pay quïdapaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chay muyuncunäćhu Efesoćhu Muśhü Caminupi imaymana limaywanmi śhalcatityälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Caynüpam talcula: chay malcäćhu juc nunam Demetrio śhutiyu cala. Paymi yanapänincunawan achca illayta licapäcula chay mamachan Artemisap capillantanu uchuchä capillachancunacta illaypi lulal lanticuyninwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Chaymi lluy lulä-masincunacta juntucuycul umacta ula cay nil: “Taytacuna, yaćhaśhanchicnüpis ya'anchic'a cay lulayllanchicwanmi llapanchicpis cawsanchic. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ñatac amcuna uyalipäcunquićh, yaćhapäcunquićh chay Pablo nishan nunaca: ‘Nunap lulaśhan dioscuná manam rasunpa dioschu’ nishtin pulishanta. Nilcul llapa nunactapis awniyächilmi nï cayllaćhüchu sinu'a cay intiru Asia-lädup malcancunaćhüñam willämunpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Chay lulaśhan nigusyunchictam llapanchicpactapis mana caśhanman muyuyächin. Jinaman'a cay Asia-lädu malcacunäpis ñatac jinantin juc malcacunäpis mamachanchic Artemisacta lläwaypa-lläwayaptinchicñapis alawäśha capillantaćh lluy pin'ayman julälälinman. Jinalćha llapa nunapis jamuyacuypi waśhanta limapäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Niptinmi nunacunaca rabyälälil lüyatityacuyalcan: “¡Efesop mamachan Artemisa, altuman juluśha cachun!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jinacuyalcaptinmi jinantin malcäña lüyatityayta allacaycälin. Jinamanmi Pablop puliwshïnin Macedonia-lädu Gayoctawan, Aristarcocta un'aypi chalälälil istadiu ćhawpiman alaśhćhäcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Chayta yaćhalcul chay nunacunäwan limananpä Pablo śhamuyta munaptinpis chalapacücunämi mićhacalcämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Jinamanmi Asia-lädu lisinacuśhan awturidäcunapis “Yan'almi imapis pasaśhunquiman. ¡Ama liychu!” nichila. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ñatac istadiućhu nunacunacá uman muyüśha imaymanacta lüyayalcalmi wicta cayta äśhaycaćhacuyalcäla. Lluy-yupaymi imapi juntunaculcäśhantapis mana sumä yaćhapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Chayćhu Alejandro nishan nunacta licälälilmi Israel-masincuna llapa nunap ñawpäninman tan'aycälälin: “¡Imallactapis nimuy upällapäcunanpä!” nil. Jinaptinmi Alejandro maquinwan siñaśhchala llapa nunapis upällaptin, limananpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Chayćhu manaläpis limaliyaptin Israel caśhta caśhanta tantiälälilñatacmi ishcay üranuy piyur lüyacuyalcan: “¡Efesop mamachan Artemisa altuman juluśha cachun!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jinacuyalcaptinmi llapa nunactapis chay malcap sicritariun lluy upällächin. Jinalculmi nila: “Efeso taytacuna mamacuna, jinantin malcacunämi yaćhapäcun cay mamachanchic Artemisa altu sïlüpi ji'alpamuśhantapis, ñatac paypa capillan ya'anchicpi caśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Lluymi yaćhapäcun; manam articta upatuculcänanchu. Pasinsiaculcayña; ama mana sumäta pinsaycul'a caynu lulapäcuychu. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Cay alaśhćhapämuśhayqui nunacunaca manachućh jinamá mamachanchicpa imantapis suwalachu, nïtac waśhantapis limalachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Cay Demetrio masannincunawan pictapis quijanan captin'a, quijachun. Chaypämi fiscuna, jatun awturidäcuna imapis munaśhanmannuy arrinlananpä cayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mas imactapis lulayta pinsal'a, chay awturidäcunap maquinćhu imactapis lulanacamuchun. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Cay pasaśhan manamá allinchu. Canan ‘Cay nunacunaca gubirnup cuntran śhalcuculculmi llapa nunactapis umachäcuyan’ nilpis nicalcamachwanmi. Ñatac ‘¿Imapïmi cay lüyay cala?’ nimaptinchic'a ¿imanichwantan? Manam imanil limalicunanchicpä cäsu canchu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nilculmi llapantapis lluy dispidïla. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Chay lüyatityay camacäluptinmi chalapacücunäta Pablo ayachila chayćhu ima captinpis masïsu capäcunanpä limapaycü. Jinalculmi paycunapi dispidiculcul Macedoniacta licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Chayćhu lluy malcacunäman ćhal chalapacücunäta callpanchayculmi Greciap malcancunaman pasacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Chayćhümi quimsa quilla capäcula. Chaypïñatacmi Siriacta allin pasacuśhä niyal, tantiälun malca-masincuna achäquiwan payta wañuchinanpä alcaśhanta. Chaymi caśhan Macedoniactañatac ćhaquiwan cuticuyta pinsälun. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Jinaptinmi cumpañapäcula Berea malcäpi Pirrop chulin Sopater, Tesalonicapi Aristarcowan Segundo, Derbepi Gayo, Timoteo, Asia-lädu malcacunäpïñatac Tiquicowan Trofimopis. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Paycunam llapan ñawpaculcäla Troas malcäćhu alcapämänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ya'acunañatacmi Macedoniaćhu quïdapaycälilá Mana Libadürayu Tanta Fistap camacaynincama. Chaypi Filipos malcäpi barcuwan lipäculmi picha muyuntalä Troas malcäman'a ćhaycamul alcamänïcunäwanpis tincülälí. Chayćhu llapallämi juc simänalä capäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Chaypïtam simäna allaycuynin muyunćhu'a lluy juntunaculcälá Jesuspa wañuyninta yalpay micuyćhu. Chay walantin Pablowan pasacalcämuná captinmi ćhawpi tutacama willapayäla yaćhayächila. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Chay wasip quimsa altuśhninćhümi lluy juntunacüśha capäculá, achca michïrawan acchicüśha. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Chayćhu Pablo chay üracama willay-willay cayaptinmi Eutico śhutiyu müsu bintanäćhu täcücäta puñuy aysälun. Chaynu chayćhu allin puñuyäśhanpi juclla pampäćhu licalïluptinmi pallalcälinanpä wañüśhaña cayäñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Jinaptin Pablo bäjalpaycamul-pacha macallayculmi nila: “Ama llaquiculcaychu. ¡Cawsayanmi!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Jinalcul Pablo caśhan cuticulculmi jatun micuyta camacalculpis, aśhta aspi-aspicamalä llapantapis limapäla. Jinalculmi licula. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Chay palpü müsuctañatacmi mana imapis pasaśhactanu tuqui sänucta lluypis cunsuylälälisha wasinta puśhapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Jinaptinmi Pablo: “Aso malcäta ćhaquillawanmi lishä. Puntapäcuchcay; chayćhüña pallalcapämanqui” nin. Chaymi puntaculcälá barcuwan. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso malcäćhu tincülulmi, pallalcälil pasaculcá Mitilene malcäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","16","Chay wäla Quio malcap chimpanpä pasayalcalmi walantintá Samos malcäman ćhälälí. Chayćhu Pablo: “Jerusalenćhu Cusicha Fistäman ćhänämi puydin. Yan'aćh Efesocta yaycuycul'a cay Asia-lädullaćhu dimuräcüman” niptinmi chay walantinnin dirichälälí Mileto malcäman, manaña Efesoman yaycul. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ñatac chaynu niyalpis cay Miletopïtam Efesoćhu caminaycücunäta ayächila. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chayćhu ćhälälimuptinmi nila: “Amcuna yaćhapäcunquim cay Asia-lädu malcacunäman jaluycamuśhä muyunpi imanuy caśhätapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yaćhapäcuśhayquinüpis masqui malca-masïcuna wa'achipämaptinpis, ñacachipämaptinpis Taytanchicta sirbiyá mana nunatucullalmi. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","21","Jinaman'a ya'a mana uyalacuyculmi amcunap allinniquicunapä cäcunäta imay ürapis mayćhüpis willaycapäculac. Llapanpa puntanćhüpis, Israel mana-Israelcunactapis, wasiquicunaćhüpis rasuncäta limapapäculac: ‘Diosninchicman cutimul-ari, Duyñunchic Jesusman chalapaculcay’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Canan'a Diospa Ispiritun puśhamaptinmi Jerusalenta liyá. Chayćhu ima alcamäśhantapis manam yaćhächu. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Diospa Ispiritullanmi may malcäman ćhaptïpis: ‘Carsillam, ñacayllam chayćhu alcäśhunqui’ niyäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ñatac cay cawsayní manaćh imapäpis bälinmanchu Duyñunchic Jesuspa llaquipayninpi willacunäcäta mana willacupti'a. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ñatac śhun'üćhu yaćhacümi cananpi'a Diospa gubirnunpi lluy willacuśhäcunawan manaña tincunanchicta. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Canan amcunapïta manam imapi juchayu canäñachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Śhun'üćhu yaćhacümari Diospa willacuyninta mana imactapis pacaycullal nï imaypis uyalacuycul lluyman willaycälishacta. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Chayurá amcunapïtañam chalapacücunäta uwishta-yupaypis licaycul caminaycälinayqui. Yalpapäcuy-ari Dios quiquinpa yawarninwan lantishan nunanta michinayquipä Chuya Ispiritu ćhulaśhuśhayquita. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Canan ya'a licupti'a rasunpa mayćhá atü-yupaypis licalipämun'a Diospa uwishnincunacta lluy chincachipäcuśhunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ñatac quiquiquicunapïpis śhalcapäcun'atacmi juc licchä yaćhachicuycunawan lluy chalapacücunäta pantalcachil inquitananpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","¡Chayurá alli cuydädu capäcuy! Jinaman'a yalpapäcuy quimsa wata intiru tutay-muyun wa'aynïpawan jucniquita-jucniquita ćhuncay-ćhuncay anyaycälishactapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Cananmi Diospa maquinćhu caćhaycälishayqui. Yalpapäcuy cuyay willacuynin śhun'unchicta callpanchamäśhanchicta, chaynütac llapa limalicuśhanta lluy japächäśhancunätawan unacaycachishunayquitapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ya'a manam illaypi wañuyälächu, nï pip müdanantapis waycaculächu. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Aśhwanpam yaćhapäcuśhayquinüpis cay maquïwan quiquïpa ñatac ya'awan cäcunapäpis lulalá. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ñatac Jesusninchic: ‘Uycämi allinpa licachicun ćhasquïcäpïtá’ nishannuy, imaypis yaćhachipäculac caynu lulaynïwan llapa wacchacunactapis yanapaycälinayquipä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nilcuśhanpïmi llapanwan un'ulacuycul Diosta mañaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Chayćhu “Manam licamanquiñachu cananpi'a” niptinmi sumä llaquisha-cama muchaycul macallaycul wa'aculcäla. Chaypïtam barcücama cumpañapämula. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jinaptin ya'acunapis caćhayculmi barcuwan liculcá dirichu lamar ćhawpićhu Cos malcäman; chay walantinñatacmi lamar ćhawpićhu Rodas malcäman; chaypïñatacmi Patara malcäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pataraćhu juc barcu Fenicia malcäman liyäta talilñatacmi, chaywan liculcá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chay liyalcäśhäćhümi ichünïćhu lamar ćhawpićhu Chipre malcäta licalcälil, Siriap malcancunäman dirichu pasaculcá. Chay Tiro malcäćhu cargacta caćhaycunan captinmi yaycapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Chayćhu chalapacücunäta ashil talilcälilmi paycunawan anćhish muyun caycälí. Chayćhümi paycuna Chuya Ispiritup nichila Jerusalenta Pablo mana linanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Chaynu nipäcuptinpis anćhish muyunpïta pasaculcaptïmi lluypis walmintin chulintin cumpañapämäla lamar patancama. Chayćhümi lluypis un'ulacuycul Diosta mañaculcäśhäpi ");
INSERT INTO qvwNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","“Jamallá, lipäcuśhäña” nil barcüman ishpicalcälilá. Paycunañatacmi wasinta cuticulcäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Cay Tiro malcäpïta Tolemayda malcäman pasaculcalmi chayćhu chalapacücunäta saludaycul juc muyun paycunawan caycälilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","9","Chay walantin liculcal Cesarea malcäman ćhälälilmi lipäculá Felipe “Diospi willacüca” nishanpa wasinman paywan quïdaycapäcunäpä. (Chay Felipe prinsipal chalapacücunap anćhish yanapänincunap aclaśhanmi cala. Tawa wamla chulinñatacmi Diospi willacücuna capäcula.) ");
INSERT INTO qvwNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Chayćhu unay cayalcaptïmi Judeapi ćhämun Diospa willacünin Agabo śhutiyu wayapa. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ćhaycamul-pacham Pablop waćhacunta chalalcul ćhaquinta maquinta ćhänacülun. Jinaculculmi: “Chuya Ispiritum caynu nin: ‘Jerusalenćhümi llapa Israelcuna cay waćhacup nunanta ćhänalcul juc caśhta nunacunap puydïnincunap maquinman ćhulaycun'a’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chayta uyalilculmi llapan chalapacücunäwan Jerusalenta mana linanpä ruygapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pabloñatacmi ichá: “¿Imapïmi wa'ayalcanqui? ¿Jinayniquiwan wañüpa śhun'unpänuy llaquiyalcächimanqui? Ya'a listum cayá imapäpis; manam ćhänapämänallanpächu, sinu'a Jesus-laycu Jerusalenćhu wañunäpäpis” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Chayćhu ruygal imanipäcuptïpis manaña awniptinmi: “Dios munaśhannu lluy lulaśha cachun” nilcälil awnipäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chaypïñatacmi lluy alistacalcälil Jerusalenta liculcá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Chayćhümi Cesareapi waquinnin chalapacücuna cumpañapämal puśhapämäla jucnin puntannin chalapacü Chipre-lädu Mnason śhutiyu nunap wasinta. Chayćhümi jamapaculcälá. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ñä Jerusalenta ćhäläliptïmi chalapacücunaca sumä-sumä cushisha ćhasquipämäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chay walantinñatacmi Jacobocta watucü Pablowan lipäculá. Chayćhütacmi chalapacücunap caminaycünincunäpis cayalcäñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ćhaycul lluytapis limayculmi Pablo willala manyapi Diosninchic paywan mana-Israelcunäćhu allin lulaycuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Chayta uyalilculmi lluypis Diosta alawäcuyalcan. Chaypïñatacmi Pablocta nipäcula: “Licay, yaćhaśhayquinüpis, Israelcunäpi sumä achca-achcañam Jesusman chalapacälälin. Lluypis camachicuy prisïsaśhantam ama-pacha niyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ñatac uyalipäcula ‘Cay Pablosh mana-Israelcunäćhu yaćhä caśhta-masinchiccunäta “Moisespa camachicuyninta custumrinchiccunactapis un'aycul, amaña chuliquicunacta siñalaychu” nilshi yaćhayächin’ niyäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Imanäśhunmi? Canan nunacunaca ćhämuśhayquita musyäläliptin'a imapis pasanmanmi. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Aśhwanpa cayta lulalmi allin canqui: Ya'acunaćhu tawa umri cayan Diosninchicpa limalicuśhanta lulapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Paycunacta Diospa chuya wasiman puśhal, chuyanchaculcay custumrinchicmannu lluy gastuncunacta pägaycul. Jinaman paycunanuy umayquita lutucuy. Caynu lulaptiquićh llapanpis yaćhapäcun'a ampa cuntrayqui limay yan'al caśhanta, jinaman Moisespa camachicuyninta cäsucuśhayquitapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Chay mana-Israel chalapacücunaman'a, apachipäculäñam manaña anla juchacuycunacta lulananpä, nï yawarnin pasäśha uywacunacta, nï taytachancunaman uywa uśhancunacta mana micapäcunanpäpis” nil nipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Chay nipäcuśhanta awnilculmi chay walantinña chay tawa umrïta puśhaculcul Diospa chuya wasinman licula. Chayćhu mana juchayu capäcunanpä lulapäcula custumrinmannuy. Jinalculmi sasirdütïman yaycula “Limaliculcäśhäta ñä simänaćhu camacäläliptïmi juc-juclla llapäpä cañaycunqui” nil niycü. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ñä anćhish muyun camacalpuyaptinmi Asia-lädupi ćhämü Israelcuna Pablocta chuya wasïćhu cayäta licälul lüyatityacuyalcan nunacunäćhu. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Chayćhümi Pablocta chalacälälil: “¡Israel-masïcuna yanapapämay! ¡Cay umrïmi intirućhu malcanchicpïpis, Moisespa camachicuyninpïpis ñatac cay chuya juntunacunanchic wasinchicpïpis cuntran yaćhachïca! ¡Jinaman'a cay Diosllanchicpa caśhanta mana allinman julul jalutacuyan mana Israelcunacta yaycachiyninwan!” niycuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Caynu nipäcula Efeso-lädu Trofimo śhutiyüwan pulishanta licapäculmi: “Cay Pablo sigürupis chuya wasimanpis puśhaycülunćha” nilcul. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Chayćhu malcantin lüyaśhtin mana-mana paćhcatityälälimulmi Pablocta waśhaman aysalcamul juntunacuna chuya wasictapis wićhapacalcälil supayninta apachicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Chayćhu Pablocta wañulpayalcächiptinñam juc willacü ćhäla Roma-lädu cachacucunap puydïninman “Jinantin malcaćhümi lluy-lluy lücutucucuyalcan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Chay ürallam lluy cachacucunactapis puydïnincunactapis juntuycul chay pasaśhancäman llapanpis wayra-wayra liculcan. Chayćhu cä nunacunaca cachacucuna puydïnintin śhacayämüta licälälil-lämi Pablocta caćhaycälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Chay cachacucunap puydïnin ćhayculmi Pablocta ishcay cadinawan ćhänächila. Jinalculmi tapula “¿Pim cay nunaca? ¿Imactam lulälun?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Chayćhu nunacunaca juc-jucta lüyatityacuyaptinmi cachacup puydïnin imapi chay pasaśhanta mana yaćhayta atipal cuartilman puśhachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Ñatac nunacunaca sumä rabyaśha lücutucucuyal “¡Wañuchishun wañuchishun!” nil apalcaćhaśhtin ipanta lipäcula cuartilpa yaycunanman ćhaycachinancama. Chaymi nunacunaca ticshïnanpi cachacucunaca Pablocta altuman pallacalcälil pasaycachipäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ñä cuartilcäman puśhaycunan cayaptinmi, Pablo cachacucunäpa puydïninta tapula: “¿Manachun limaycuchwan rätulla?” nil. Niptinmi: “¿Chayurá griego limayta yaćhanquichun? ");
INSERT INTO qvwNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ya'a pinsalá: ‘Cay'a malcäpa cuntran śhalcuculcul tawa walanga wañuchicücunacta puśhaculcul chunyänincunaćhu pulï Egipto nunäćha’ nilmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Niptinmi: “Manamari. Israel caśhtam ya'a cayá, Ciliciap Tarso puydï malcanpïmi. Ñatac ama chaynu callaychu; rätulla nunacunäta niyculläśhä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Chayćhümi cachacucunap puydïnin awnïluptin, Pablo cuartilpa puncunćhu śhalcuculcul maquinwan siñaśhchaycul nunacunäta upällachila. Upälläluptinñatacmi Israel limayninćhu limayta allaycula: ");
INSERT INTO qvwNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Taytacuna, malca-masïcuna, uyalipämay. Canan ya'a limaśhä cay imanuy caśhantapis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Caynu Israel limayninćhu uyalilcälilmi sumätalä uyaliycuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Chayćhümi Pablo: “Israel malca-masiquim cayá. Ciliciap Tarso malcanćhu näsilpis, cay Jerusalenćhümi Gamalielpa yaćhachicuyninćhu ishpilá. Paymi yaćhachimäla imaypis awquillunchiccunap camachicuyninta callpanchacul lluy manyapi lulanäpä. Ñatac canan amcuna lulapäcuśhayquinümi tucuy śhun'üwan lluy lulaynïćhu Diosta manchaculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jinalmi unay aticaćhalá wañuy-wañuy cay Muśhü Caminuman chalapacücunäta. Umripis walmipis cacuchun lluyta puśhalcamulmi wañuchiynïwan wićhalá. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Caycunapi yaćhapäcunmi puydï sasirdüticunäpis, lluy prinsipal yaśhacunäpis. Aśhta paycunapi papilta mañaculculmi ya'a lilá Damascoćhu cä Israel-masinchiccunap puydïnincunaman, lluy chayćhu cä chalapacücunäta cay Jerusalenman puśhalcamul ñacachinäpälä canpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Chaynu liyäśhäćhu ñä ćhawpi muyunniscaña Damascoman ñaćhapaycuyaptïmi, altupïta juclla licalïmun acchi räyu wacliyämünu. Chay intiru muyülïnïman chipipicyämuptin ");
INSERT INTO qvwNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","pampäman cućhpälulmi uyalïlú: ‘Saulo, Saulo ¿imapïtan wañuchiyta llallächacul aticaćhamanqui?’ niyta. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Nimaptinmi nilá: ‘¿Pitan canqui, Taytay?’ nil. “Niptïmi: ‘Am aticaćhaśhayqui Nazaret Jesusmi ya'a cayá’ niman. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Chay ya'awan lïcunämi acchicta licälälil chucchucuyalcan. Chay limapamäśhancätañatacmi ichá tantiayta nï atipapäcunchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Chayćhümi tapuculá: ‘¿Taytay, imactam luläman?’ nil. “Niptïmi: ‘Śhalcuculcul Damascoman ćhaycuy. Chayćhümi imacta lulanayquipäpis alcayäśhunqui’ niman. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ñatac chay acchi aplächimaptinmi liwshimänïcunaca Damasco malcäman chancuypa puśhapämäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Chay malcäćhümi cañä juc wayapa lluy Israel-masinchiccunapäpis allinpa licaśha Ananias śhutiyu. Paymi sumä manchacuyniyu Tayta Diospa, Moisespa camachicuyninta cäsucü cañä. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Paymari ya'aman aśhuycamul: ‘Cuyaśhá Saulo, ñawiqui quićhacacuśha cachun’ nimäla. Nimaptin-pachalla ñawí quićhacacüluptinmi licälú. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Jinalculmi niman: ‘Awquillunchiccunapi cä Tayta Diosninchicmi aclacuśhulanqui paypa munaśhanta lisinayquipä, quiquin Allin Tincüninman Cäraycücäta lisinayquipä, jinaman shiminpi yaćhachicuyninta uyalinayquipäpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Rasunpa paypa pudirnin anmi canqui licaśhayquita uyalishayquita lluy nunacunäta willacunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Chayurá ¿imactañam alcayanqui? Canallan Duyñunchic Jesusta: “Pampachaycamay cay juchalläta” nil bawtisacuy’ niman. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","“Chayćhu bawtisaculcul Jerusalenta cuticul Diospa chuya wasinćhu mañacuyaptïmi suyñuynïćhünu Tayta Diosta licälú: ‘¡Apurayllaña; cay Jerusalenpïta licuy! Ya'api willacuśhayquita manam uyalïtuculcan'achu’ niyämäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nimaptinmi: ‘Taytay, paycuná yaćhapäcunmi anman chalapacücunäta juntunacuna wasicunaćhu ashilcul supayninta apalcachil carsilman wićhaśhäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Jinaman'a ampi willacü Estebanta wañuchipäcuśhanćhüpis “Allin wañuchishun chaytá” nilá. Jinaman wañuchïcunäpa müdanancunactapis täpälämi canpis.’ ");
INSERT INTO qvwNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Niptïpis: ‘Liy-ari. Mana-Israelcunämanmi caćhayac’ nimälam” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","23","Ñatac allin uyaliyalcal Pablo “mana-Israelcunaman lishä” nilcüluptin-pacham lluy lüyatityacuyalcan: “¡Caynu nunactá manañam cawsachiypächu! ¡Chincachiypäñam!” nishtin rabyacuyninwan allpactapis altuman mächicuyalcan, tamshaywan wañuchipäcunanpä müdanantapis lluy julucücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Chaynu jinayalcaptinmi cachacucunap puydïninca cachacuncunacta nila: “Cuartilman puśhaycul lawćhaycäliy-ari imapi nunacunaca jinaśhantapis yaćhalpunäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Chaynu cachacucuna lawćhananpä walcalayalcächiptinmi Pablo: “¿Amcuna Roma-lädu nunacunacta caynu lawćhanquimanchun manalä ima juchanpis cäraycuśha cayaptin'a?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Cayta uyalilcul-pacham puydïninman cutiycul: “¿Sumäta yaćhacuyculchun cayta lulayanqui? Cay umri Romapïmi cañä” nil willaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Niptin-pacham Pabloman cürrilcamul: “¿Rasunpachun am Roma-lädupi canqui?” nin. Niptinmi: “Aw” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Puydïcäñatacmi: “Alli-alli illaypa ćhaninwanmi ya'a Roma-läduman muyulá” nin. Niptinmi Pablo: “Ya'ami ichá taytäcunapïlä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Chaynu niptinmi Pablocta limalichisha nïcunaca caćhaycul aśhuculcan. Aśhta puydïcäpis sumä manchapacülun Roma-lädu nunacta ćhänachishanpïta. ");
INSERT INTO qvwNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Chay walantinñatac puydïca imapi Israelcunaca juchachaycälishantapis yaćhaycunanpä Pablocta pasquiycachilmi puydï sasirdüticunacta, jinantin Cunsïjup puydïnincunactapis juntuchimula. Jinalculmi lluypa puntanman Pablocta puśhaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Chayćhümi lluy puydï juntuläcunäta Pablo licapaycul: “Cuyaśhá taytacuna, mana quiripämaptiquipis, manchacuywanmi Diospa puntanćhu ya'a cawsayá canancama” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Niptinmi puydï sasirdüti Ananias Pablop lädunćhu cäcunäta: “Chayta shimićhu lapyäluy” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Jinaptinmi Pablo: “¡Ishcay cära nuna, amtapis Diosmi lapyaśhunqui! Am chayćhu täcuyanqui malcanchicpa camachicuyninmannuy cäraycunayquipä. ¿Chayurá imapïtan-nila ima juchactapis mana talil ya'acta lapyachimayniquiwan jalutacuyanqui?” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Chayćhu cäcunañatacmi: “¿Cärayquipis cañälächun Diospa puydï sasirdütinta caynüpa cutipacunayquipä?” nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Niptinmi Pablo: “Taytacuna, manam yaćhalächu Diospa puydï sasirdütin caśhanta. Aw, camachicuyćhüpis ‘Ama palaychu malcayquip puydïninta’ niyanmi” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ñatac chay puydï juntuläcunäćhu juc parti saduseocuna, juccunañatac fariseo capäcuśhanta Pablo tantialmi nila: “Israel-masïcuna, awquillücunapïpis ya'a fariseo caśhtam cayá. Cayćhu cäraycamayta munapäcun wañücuna śhalcamunanman chalapacuśhäpïchun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","8","(Má, chay saduseocunacá manam quiripäcunchu wañücuna śhalcamunanman, nï anjilcunamanpis, nïtac ispiritucunamanpis. Fariseocunañatacmi ichá lluy caycunaman quiripäcun.) Chaymi Pablo limalcüluptin-pachalla chayćhu fariseocunawan saduseocunaca pilyap-pilyacuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Chaynu juntunacuy ishcayman muyuchinaculcul ruyducuyalmi camachicuyta yaćhachï fariseocuna paćhcalcälïmul: “¡Cay nunäćhu manam ima juchactapis talipäcüchu! ¡Ichaćh juc anjilpis ütac ispiritupis limapala chay Damascocta lishan caminüćhu!” nil nicuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Chaynu mas-mastaña millpanacücuyalcaptinmi cachacucunap puydïninca manchalicucuyan Pablocta lluy ticshinacälälinanpïta. Jinalmi cuartilman cutiycachila. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ñatac chay tutam Taytanchic licalïlun Pablop lädunćhu: “Callpanchacuy Pablo. Maynümi cay Jerusalenćhu ya'apïta willalanqui, chaynütacmi Romaćhüpis willaycunqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Chay walantinñatacmi tawa ćhunca Israelcuna Pablocta wañuchipäcunanpä limalicälälin: “Sïchuśh Pablocta manaläpis wañuchil micuytapis micülupti'a yacullactapis upyalcülupti'a, Diosninchic ya'acta wañuchimächun” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ninacalcälil puydï sasirdüticunäman, prinsipal yaśhacunämanpis lilmi nipäcula: “Ya'acuna limalicälälí Pablocta wañuchipäcunäcama micuytapis mana micapäcunäpä nï yacullactapis upyapäcunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Canan amcunawan Cunsïjup puydïnincuna chay cachacucunap puydïninman lil: ‘Ya'acuna sumäta yaćhalpapäcuśhä Pablop ima juchan caśhantapis’ niycullal puśhachipämuy. Ya'acunañatac pacalapäcuśhä ćhawpi caminućhu manaläpis cayman ćhämüta wañülächinäpä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Chayćhümi Pablop paninpa wawin, tiyunta wañuchinanpä limanaculcäśhanta uyalïlul-pacha tiyun Pablocta willaycamü cuartilman pasacun. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Chaymi Pablo cachacup puydïninta ayalcul: “Cay walaśhca sumä willacuytam apamuñä. Puydïniquiman willaycunanpä puśhay” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Niptin puydïninman puśhaculculmi nin: “Wićhalä Pablo ayalcamalmi nimäla cay walaśhshi willaśhunqui sumä willacuyta” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Chaymi chay puydïca juc läduscaman puśhalcul: “Má ïju, ¿imallactam niycamanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Chayćhümi walaśhca willan: “Cunsïjup puydïnincunam limanacälälin wala muyun Pablop juchanta licaycälï tumpalla puśhachinayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Chayurá ama cäsuychu. Tawa ćhunca masniyu wayapacunamari Pablocta wañuchipäcunancama mana micuytapis nï yacullactapis upyaycälinanpä limalicalcälil ćhawpi caminućhu pacacälälisha alcayalcan. Cananmi listu alcayalcan am awniycunallayquita” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Niptinmi puydïca: “Licuy-ari. Cay willamäśhayquita amam mayantapis willanquichu” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Chaypïtam cachacucunap mas puydïnin ishcay yanapäninta ayalcul: “Aspilpuyña Cesarea malcätam lipäcunqui. Alistapämuy ishcay paćhac (200) cachacucuna llasä armayü-camacta, chaynütac anćhish ćhunca cawallucuśha-camacta, ishcay paćhac (200) lansayü-camactapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Jinaman'a Pablopä juc cawallucta ashipämuy malcap gubirnänin Felixman mana imapis pasäśhacta ćhächipäcunayquipä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Chay lïcunawantacmi apachila juc papilta caynu niyäta: ");
INSERT INTO qvwNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Am malcap gubirnänin sumä cuyaśhá Felixta, ya'a Claudio Lisiasmi limaycamuc. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Cay umricta Israelcunämi chalalcälil wañulpayalcächiñä. Chaynu Roma-lädu nunacta jinalcäśhanta uyalïlul-pacham cachacücunawan lilcul libraycälilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ñatac imapi juchachaycälishantapis yaćhaycunäpämi Cunsïjup puydïnincunäman puśhalá. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Chayćhümi tumpapäcuñä paycunap camachicuynin cüsacunallapïta. Ñatac chaycunallapïtá manam cäsu canchu wañuchinapä nï carsilman wićhanallapäpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Chay Israelcunaca wañuchinanpä limalicälälishanta yaćhälulmi, anman caćhayämú. Tumpänincunätapis ‘Felixpa puntanćhu cäraycamuy ima juchan caśhantapis’ nilmi nilá” niyäta isquirbila. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Chay tutam cachacucunaca puydïnin mandaśhannu Antipatris malcäman Pablocta puśhaculcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Chay walantinñatacmi cawallucuśhacunällaña Pablocta pasachiculcan. Juccunäñatacmi cuartilman cuticulcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Chay Cesarea malcäman ćhälächilmi apachishan papilta uycula malcap gubirnäninman, Pabloctapis paypa maquinman ćhulaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Niptinmi puydï Felix lïgiycul tapula: “¿May malcapïmi canqui?” nil. Niptinmi Pablo: “Ciliciap Tarso malcanpïmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Niptinmi: “Chayurá, tumpäniquicuna ćhämuptinñam uyalishayqui” nila. Nilculmi cachacucunäta: “Herodespa wasinćhu täpapämuy” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Chaypi picha muyuntam Cesareaman ćhälälimun puydï sasirdüti Ananias, Israelpa waquinnin prinsipal yaśhacunawan juc tintirillu Tertulo śhutiyüta puśhapacälälisha. Paycunam puydï Felixpa dispächunman yaycapäcula Pablocta acusaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Chayćhu Pablocta ćhächimuptinmi Tertulo paypa cuntran limayta allacuycun: “Sulpá cachun amta Tayta Felix. Cay jinantin malcäćhu sumä yaćhayniquiwan allinta lulaycuśhayquipam jawca cawsayta uycälimanqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Rasunpa, Sumä Puydïní Taytay, imaypis intirućhüpis lluypis ćhasquiycälí sumä anradisicuywanmi. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Canan'a Taytay, mana ancha piñachinacpä, rätullam limalculläśhä. Uyaliycallämay. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Cay umrica sumä ishyaynümi cacullan. Chay mana allinman iwichï Nazaret Jesuspa atïnincunap puydïninmi. Chaymi Israelcunäta ishcay śhun'ulcachil ćhïninacachiyta jinantin pachäćhüpis puliyämun. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Jinaman'a juntunacuna chuya wasictapis jalutacunan cayaptinmi ya'acuna chalälälilá. ˻Jinalcul malcap limanacuśhanchicmannuy mućhuchisha niyalcaptïmi ");
INSERT INTO qvwNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","cachacucunap puydïnin Lisias ćhaycamul waycäläliman. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jinalculmi: ‘Mayanpis cäraycuyta munäcunacá tayta Felixman lichun’ nipäman.˼ Canan am quiquiqui Pablocta tapuyculćha tuquicta yaćhanqui nishacnüpis ima juchan caśhantapis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ñatac Israelcunäpis: “¡Aw, rasunpa chaynümi!” nilmi intucalpuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Chayćhümi gubirnä Felix siñaśhchälun Pablocta limananpä. Chaymi Pabloñatac: “Tayta Felix, am una-unaypïña cay Israel malcäćhu juchacunacta tuquicta arrinlaycuśhayquïtam yaćhá. Chaymi anman chalapacul cay juchachaycamäśhancunapïta limalcuśhä. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","“Ya'a Jerusalenman alawaycunäpä chayllalämi ćhunca ishcayniyu muyun ćhämuśha cayälá. Cay sumä tantiapaśhllamari cayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Chay Diospa chuya wasinćhu manam piñanacuyätachu nï pilyachinacuyätachu ya'acta talipämäla, nïtac chayćhu, nï juc juntunaculcänan wasicunaćhüpis, nïtac maycunaćhüpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ñatac cay juchachaycamä nunacunäpa manamá licänin canchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ñatac chay awquillücunap Diosninman chalapacul cay ‘Muśhü Caminuman’ ya'a atishäta manamá nïgacüchu. Masqui iwichicücuna caśhtapa licapämaptinpis, rasunpa lluy Moisespa camachicuyninmanpis Diospa willacünincuna lluy isquirbishanmanpis chalapacümi. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Jinaman paycuna chalapacuśhan Diosmanmi ya'apis chalapacú juc-pun juchayu mana juchayüpis wañücunapis śhalcamunancäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Chaymi imaypis Diospa puntanćhu chaynütac nunacunäpa puntanćhüpis mana juchayu canäpä callpanchacú. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ñatac intiru malcacunäćhu achca wata pulimuśhäpïmi cutilá Jerusalenman malca-masïcunacta yanapaycunäpäwan custumrinchicmannuy Diosninchicta uycunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Chayćhümi Diospa puydï wasinćhu chuya cayäta ishcay quimsa nunallaćhu ruyducunacta ashiyätachu mana talipämäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Chay waquin Asia-lädupi Israelcuna ‘licalämi’ nïcunam cayćhu capäcunman cäraycälimänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Chaynu mana captin'a cay nunacuna-ari niycuśhunqui chay Cunsïjup puydïnincunaćhu cayaptí ima juchayüta talipämäśhantapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Icha chayćhu cayal callpawan ‘Wañücuna śhalcamunanmanmi chalapacú’ nishäpïchun cäraycayalcäman” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Niptin Felix cay Muśhü Caminupi tuquicta yaćhalñatacmi juc muyunpäña caćhaycülun: “Puydï Lisias ćhämuptinmi cayta arrinlalpuśhä” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nilculmi jucnin cachacucta: “Cutiycachil tuquipmi licaycunqui. Ñatac watucünincuna śhamuptin pasaycachinqui licaycapäcunanpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Chaypïta ishcay quimsa muyuncunapïtanümi Felix walmintin Israel caśhta Drusilawan ćhaycamul ayächin Pablocta chalapacuśhanpïta uyalinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Chayćhu Pabloñatac sumä allin cawsaypi, quiquinchicta sujitacuypi, śhamuna muyuncäćhu Dios cäraycamänanchicpïtapis willaycula. Chayta uyalilculmi Felix manchalcul: “Canan jinalla cachun. Juc-pun timpú captinña ayachishayqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ñatac Felixmi “Illayta umanman caćhaycunäpä” nil ayapayächillal ishcay watacuycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Jinayällal Felix malcap puydïnin cayta camacäluptinmi pudirnin yaycula Porcio Festo nishan. Chayćhu Felixmi Israelcunäwan allinpa licachicuyninwan Pablocta wićhalayäta caćhaycüla. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Chay Cesarea malcap puydïnin cayta allaycunanpä Festo ćhayculmi quimsa muyun caycuśhanpïta Jerusalenta lila. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ćhämuśhanta yaćhälälilmi puydï sasirdüticunäwan Israel prinsipal yaśhacunäpis payman lilcälil yapañatac Pablocta quijayta allaycapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Chayćhümi chay śhamuśhan caminućhu wañuchinan-laycu uchuc shimillanwan ruygätuculcäla Jerusalenman Pablocta puśhachimunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Chaymi Festo: “Pay'a Cesarea malcäćhümi wićhalayan. Cay śhamü muyuncunäćhümi quiquí lishä. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Puydïniquicuna ya'awan cusca lichun, rasunpa ima juchanpis captin'a chayćhu cäraycälinanpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Chay Jerusalenćhu isun muyunnu caycuśhanpïmi Cesarea malcäta cutila. Chay walantinñatacmi dispächunćhu juntunacuycul Pablocta puśhachimula. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ćhächimuptinñatacmi Jerusalenpi ćhämü Israelcunaca juntunacaycälil sumäcunactalä juchachäcuyalcan. Jinayalcaptinpis licänincuna manamá calachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pabloñatacmi: “Ya'a manam imaypis mana allintá lulalächu, nï Israelpa camachicuyninta nï juntunacuna chuya wasictapis nïtac Roma nasyunpa puydïnintapis jalutaculächu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Niptinmi Festo Israelcunäwan allinpa licachicuyta munal Pablocta tapula: “¿Jerusalenta liyta munanquichun chayćhu quiquí arrinlaycamunacpä?” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Niptinmi: “Am Roma nasyunpa puydïninpa pudirnin cayal'a cayllaćhümi arrinlaycamänayqui. Tuquictamá yaćhayanqui Israel malca-masïpä cuntran mana imallactapis lulaśhäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Sïchuśh rasunpa jatun juchá captin'a juchämannuy wañülächimay. Manamá ya'a nïgacüchu wañuyta. Mana juchayu captïmi ichá mana pipis yan'al juchachämänïcunap maquinman ćhulaycamanmanchu wañuchipämänanpä. ¡Chaymi ya'a mañacú Romap sumä puydïnin Cesar quiquin arrinlaycamänanpä!” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Chaymi Festo yanapänincunawan limanacuycul Pablocta: “Chaynu munal'a paymanćhá linqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ñatac śhamü muyuncunäćhu puydï Agripawan Berenice walmi lipäcula Cesarea malcäta Festocta watucuycü. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Chayćhu unay capaycäliptinmi Festo willapäla Pablocta juchachapäcuśhanpïta: “Cayćhümi Felix juc umricta wićhalayäta caćhaycüśhan cayan. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Chaymi Jerusalenćhu cayaptí puydï sasirdüticunaca, Israelpa prinsipal yaśhancunäpis quijacalcämäla chay umri wañuchisha cananpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nimaptinmi: ‘Roma malcap custumrin'a juchayücäta quijacücunäpä puntanćhu manaläpis difindicuyaptin'a manam wañuchichwanchu’ nilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Chaymi cayman paycuna ćhälälimuptin walantin-pacha dispächüman taycuycul Pablocta ayachimulá. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Chayćhümi juchachaycücunaca ya'a pinsaśhä juchapïtá nï uchucllapis limalcälinpischu. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Mastá chalapacuyninpïta wañucü Jesus śhutiyu ‘cawsayanmi’ nil Pablo nishancunapïtam juchachäcuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Chaymi chaycunapi mana sumäta yaćhal Pablocta nilá: ‘¿Jerusalenta liyta munanquichun chayćhu arrinlaycunacpä?’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Niptïmi Romap quiquin Puydïnin Cesar arrinlaycunanpä mañamaptin jina wićhalayällacta caćhayculá puśhachinäcama” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Niptinmi Agripa tayta Festocta nila: “Chay umricta ya'apis uyaliycuytam muná” nil. Niptinmi: “Chayurá wala-pacham uyalinqui” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Chay walantinmi Agripawan Berenice sumä balaquïru yaycapäcula arrinlanan dispächuman cachacucunap puydïnincunawan, prinsipal yaśhacunawanpis cusca. Chayćhu tayta Festo Pablocta ćhächimulmi: ");
INSERT INTO qvwNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","“Tayta Agripa, chaynütac llapallayquipis cayćhu ya'anchicunawan cä taytacuna, cay juchachäśha umrim puntayquićhu cayan. Lluy Israelcunam cay umri juchayu caśhanta quijaculcan Jerusalenćhüpis cay Cesareaćhüpis. Jinaman wañuchisha cananpämi mañacayalcäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ya'a manamá ima juchactapis talïchu wañuchisha cananpä. Ñatac quiquin Puydï Cesarca arrinlaycunanpä mañamaptinmi, ya'a payman caćhanäpä awnilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","27","Chaymi nï imanil isquirbilcul Puydï Cesarman puśhachinäpäpis canchu. ¿Imanuypatá ima juchan caśhantapis mana yaćhaycul puśhachichwan? Chaymari amcunap ñawpäniquiman ćhulaycamú, mastá anman tayta Agripa. Canan sumäta tapuycuptiqui ichaćh ya'a imallactapis talïman isquirbiycunäpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Chaymi chayćhu Pablocta Agripa nila: “Canan limaliy juchachapäcuśhuśhayquipïta” nil. Niptinmi Pablo maquinta chacchalcul limayta allaycula: ");
INSERT INTO qvwNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Tayta Agripa, ya'a cushisham cayá ampa ñawpäniquićhu, cay Israel-masïcuna juchachapämäśhanpïta difindicunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Am rasunpa cay Israel custumrïcunacta, lluy cay cüsacunapïta sumätam yaćhanqui. Chaymi Taytay mana piñacullal uyaliycamänayquipä mañacullac. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Llapan Israel-masïcunam tuquicta yaćhapäcun näsishá malcaćhu müsu caśhäpïta aśhta Jerusalenman ćhaycul paycunawan cusca yaćhanäcama imanuy cawsaśhätapis. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Cay malcanchicćhu lluy chalapacuycunapïta mas sasannin cäcätam, chay fariseo custumrictamá tucuy śhun'üwan atilá. Paycuna munal'a rasunpa caśhanta niycälishunqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Paycunanu wañücuna śhalcamunanpä awquillunchiccunaman Dios limalicuśhanman chalapacuptïchun juchachayalcämanman. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ñatac jinantin malcäpa ćhunca ishcayniyu milaynincunapis cayta ćhasquipäcunanpämi tutay-walächi Diosninchicta alawapäcul alcayalcan. Canan, Tayta Agripa, paycunanu chalapacuśhäpïmi cayman quijäläliman. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Icha ¿‘Diosninchic ¡¿imanuypatá wañücunacta śhalcachimunman?!’ niyalcanquichun imatá? ");
INSERT INTO qvwNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Cananmá willaśhayqui. Unay cawsaynïćhu Diosninchicta masta sirbiynïwanmi Nazaret Jesusman chalapacücunäta imaymanap chincachiyta ya'apis pinsalá. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Rasunpa chaynütam lulalá. Puydï sasirdüticuna awniycamaptinmari Jerusalenćhu wićhalá. Jinaman ‘Wañuchishä’ nipäcuptinpis cushisham ya'apis awnilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Jinamanñatacmi juntunaculcänan wasicunamanpis yaycuycul supayninta apachilá Diosta jalutaculcänanpä. Ya'apa śhun'üpis timpuyaptinmi aśhta juc-lädu calu malcacunaćhüpis aticaćhalá. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Chay intinsiunwanmi puydï sasirdüticunäpa pudirnin Damasco malcäta lilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Chayćhu liyaptïmari, Tayta Agripa, chay ćhawpi muyunnu altu sïlupi intïpïtapis mas-maslä muyülïnïman liwshimänïcunamanpis acchilpämun. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Jinaptin lluy cućhpäläliptïmi Israel limayćhu: ‘Saulo, Saulo, ¿imapïtan wañuchiyta llallächacul aticaćhamanqui? Cay lulayniqui cunca cuchuyniquipämi garuchap puntanta saytäcä-yupaypis’ nilpämun. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Chayćhümi: ‘¿Pim cayanqui taytay?’ nilá. “Niptïmi: ‘Quiquin aticaćhaśhayqui Jesusmi ya'a cayá. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Canan śhalcuy-ari. Anwan lisichiculá nuná canayquipämi, canan licaśhayquita śhamü muyuncunäćhu licachinaccätapis willacunayquipämi. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","Ñatac quiquïmi licaycuśhayqui malca-masiqui Israelpïwan mana-Israelcunapïpis. Chay mana-Israelcunamanmi canan caćhac mana tantiayniyücunäta tantiaycachinayquipä, tutapä cawsayninpi acchïman julaycamunayquipä, chaynütac Satanaśhpa maquinpïpis Diosman julaycamunayquipäpis. Ya'aman chalapacamäcätá Diosmi juchancunacta pampachaycul jucllachan'a chuya chalapacücunäwan cuscacta wiñay cawsayta ćhasquipäcunanpä’ niman. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","20","“Chaynu nimaptinmi, Tayta Agripa, chay caćhamäśhanta, mana upatucullal willacuyta allayculá Damascoćhu, Jerusalenćhüpis intiru Judeap malcancunaćhüpis. Malca-masí, mana malca-masí captinpis, llapantapis ćhuncay-ćhuncay anyanaculá: ‘Juchayquipi wanaculcul Diosman filtacalcämul cawsayniquićhu wanacuśhayquita camalachipäcuy’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Chaymi juntunacunan chuya wasićhu Israel-masïcuna chalalcälimal wañuchiyta munapämäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Jinapämaptinpis Tayta Diospa yanapayninwanmi canancama masïsu chalapacul sumä mana sumä nunamanpis jinalla willacuyá. Paycunactanümari amcunactapis willaycälic Moiseswan Diospa willacünincuna willacuśhallanta: ");
INSERT INTO qvwNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","‘Caćhamuśhan Salbacücätam ñacalcachil wañuchipäcun'a. Jinapäcuptinpis paymi puntacta śhalcamun'a wañücunäpi Israel mana-Israelcunactapis wiñay cawsayta unanpä’ nil” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Chaynu Pablo limayaptinmi tayta Festo juclla nïlun: “Pablo, alli-alli yaćhayniqui ¡¿lücuchishunquichun imam?!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Niptinmi: “Tayta Festo, manam lücüśhachu cayällá. Cay nishäca tincüninman rasuncällamari. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Tayta Agripa lluy caycunapi tuquicta yaćhayaptinmi paypa puntanćhu mana manchalillal limayá. Sigürupis caycunapi tuquictam yaćhan. Manamá pacallap lulaśhactachu limayá. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Tayta Agripa, ¿Diospa willacünincunap isquirbishanman am chalapacunquichun? Aw-ari, chalapacuyanquimá” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Chayćhu Agripañatac: “¿‘Rätullam caytá awnichishä chalapacüman’ nilchun imam niyämanqui?” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Niptinmi: “Ñacayta ütac rätulla captinpis, mana cadinayülla ya'anu canayquipä Dios munachun, mana amllactachu, sinu'a lluy cayćhu uyalimäcunätapis” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","31","Nïluptinmi chayćhu tayta Agripa, Festo, Berenice ñatac lluy puydïcunäpis śhalcutityalcul liculcan juc-lädućhu limanacamü. Chayćhümi quiquin-pula ninaculcan: “Cay umri manam ima juchacta lulaśhanpis camalanchu wañuchisha cananpä nï wićhalänallanpäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Chayćhu tayta Agripañatac Festocta nin: “Cay umri caćhaycuśham canman cala quiquillan Cesarca Romaćhu arrinlananpä mana mañacuptin'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ñä Italiaćhu Romaman caćhananpä Pabloctawan juc prïsucunäta cachacucunap puydïnin Julio nishanpa maquinmanmi ćhulaycula. Paymi quiquin Romaćhu puydïcäpa cachacuncunacta mandänin cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Chayćhümi yaluculcá lamar patanćhu cä Adramitio malcäpi juc barcu Asia-lädućhu malcacunaman yalücäwan. Chayćhütacmi ya'acunawan cayäla Macedoniap Tesalonica malcanpi Aristarco nuna. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Chay walantinñatacmi lamar patanćhu Sidonman ćhälälí. Chayćhu Pablo lisinaculcäśhanman watucü linanpämi Julio cuyaywan awniycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Chay Sidonpïta pasapäcuptí waywaca puntapi sumbaypa-sumbal waywacayämuptinmi Chipre malcap allïninpa lipäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Chaynu liyalcá Cilicia malcap, Panfilia malcap chimpancunapmi aśhta Liciap Mira malcanman ćhäpäcunäcama. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Chay Mira malcäćhümi cachacucunap puydïninca talïlun Alejandriapi juc barcu Italiaman liyäta. Chaymanmi ishpïlächiman biäjicta pasapäcunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ñatac achca muyunña allillapi liyalcalmari sumä ñacapäcuśhäta Gnidup chimpallanman wañuy cawsay ćhälälí. Chayćhu waywaca jinalla sumä-sumä cayaptinmi Salmun malcap chimpanpa muyulcul Cretap ichünin lädup lamar patanllanpa pasapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Chaynu ñacapäcuśhätam ćhälälí lamar patanćhu Buenos Puertos malcäman, Lasea malcap sircallanman. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Chaynu alli-allictaña dimuräläliptïmi tamyamunan quillaca allacaycamuptin calu biäjicunacta linapä manaña bälilachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Chaymi Pablo: “Taytacuna, cay lishanchic manam allinchu canman. Manam barcütawan apaśhanchiccunällactachu chincapacüluchwan, sinu'a aśhta bïdanchictapis apäluchwanmi” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Chayćhu Pablop nishanta uyaliycunantá aśhwanpam Julio chay barcup nunanwan puśhänin nunaca limapäśhanta mastá cäsülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ñatac chay lamar patanćhu jamapapäcuśhan tamya quillaćhu quïdapäcunanpä manam allinchu cala. Chaymi lluy-yupay nicuyalcan: “Cayćhu manam allinchu cachwan. Aśhwanpa Fenice malcäćhu tamya quilläta pasanapä imanuypapis ćhäśhun” nil. (Cay Fenice cala Cretap malcanmi mana ulapïpis janapïpis waywa ćhänan.) ");
INSERT INTO qvwNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","14","Chaypïta chayćhu linanpä tuqui waywa ipan lädupi allaycämuptinmi cushisha: “Canan allinćha can'a” nil allacaycälin. Chaynu Cretap chimpallanpa liyalcaptinmi unascapïtá allïnin lädupi Noreste nishan sumä-sumä waywa talcämul barcüta apacuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Chaynu puntaman mana liyta atipalmi, jinaña waywäwan apachiculcälá. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Chaynu apayalcämaptinmi ćhälälí Cawda malcap ipanćhu mana ancha waywa caśhanman. Chayćhümi ñaca-ñacayta pallalcälälí barcu apaśhan bütichacta. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Chayćhümi barcuca mana wichicacunanpä watucunawan lulipi pasalcachil sumä masïsälälin. Ñatac chay Sirte nishanćhu arrinilläman mana śhaticacunanpämi barcup waywa puśhanan tuldïrantanuy cäcäta julälälin. Jinayculmi waywäwan jinaña apachiculcälá. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Chay walantin jinalla waywaca sumä-sumä captinmi barcüćhu apapäcuśhan ipincunactapis yacüman jitalpuyta lluy allacaycälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Chay śhamü muyuncäćhüñatacmi jinalla waywaca cacuyaptin barcup mana bälityänintá quiquincuna maquincunawan yacüman lluyña jitalpücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Chaynu waywalla pucutaylla sumä-sumä cacuptinmi unayña intïtapis uyllurtapis mana lical: “Canan manañaćh cawsachwanchu” nipäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Canan achca muyunña micuypi cayalcaptinmi Pablo śhalcuculcul: “Taytacuna, ya'acta uyalicalcämal'a Cretapi manaćh yalamuchwanchu cala. Chayurá manaćh caynu ñacayachwanchu, nï imactapis mana caśhanman cutichichwanchu cala. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Canan'a ama-ari manchäśha jucmanyäśha cayalcaychu. Manam jucllayquipis wañupäcunquichu barcüta yacuca lluy millpüluptinpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Canan tutam alawaśhá sirbishá Diosnïpa anjilnin suyñuynïćhu niman: ");
INSERT INTO qvwNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Ama manchacuychu Pablo, Romaćhu Cesarman prisïsanmi ćhänayqui. Chaymi am-laycu lluy barcüćhu cäcunäta wañuypi juluycuśhä’ nil. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","26","Ñatac cay lamar ćhawpipi allpäman wicapäśham caśhun. Chaynu captinpis ama wällisha cayalcaychu. Aśhwanpa callpanchaculcay. Rasunpa anjil nimäśhantanümi Diosninchic lulaycun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ñatac ishcay simänaña waywaca wicman cayman apaycaćhayalcämaptinmi Adriatico lamarcäćhüña cayalcäñá. Chayćhu ñä ćhawpi tutañam barcüta puśhäcunaca tantiälälin allpamanña ñaćhapaycuyalcäśhäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Chayćhümi yacuca “Jundulächućh pachallañachućh cayan” nil tupuptin quimsa ćhunca sütayu mitru cañä. Puntascaćhu yapaptin'a ishcay ćhunca anćhishniyu mitrullaña cacuyaptinmi sumä manchalicälälisha: ");
INSERT INTO qvwNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","“Wancamanćha tupacacüśhun” nil tawa tita watu llasä jïrruyü-camacta barcup ipanman jitalpapäcula chalalänanpä. Jinalculmi “Wälälunmanñapis” nilcul Diosman ñaćhaña ishpicuyalcanpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ñatac waquinnin barcüta puśhäcunämi manchalicuypïta “Ayicuśhun” nilcälil uchuy bütichallacta bäjacuyalcan barcup puntanćhu watüta jitalpuycul “masïsämuśhä” nïnülla. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Chayćhümi Pabloñatac cachacucunätawan puydïnincunacta: “Sïchuśh paycuna ayiyculcaptin'a amcuna manam salbacuyta atipapäcunquichu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Niptin-pacham cachacucunaca chay bütichäta chalalä watucunäta cuchulcul lamarcäman caćhalpaycälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ñatac wäläluptinmi Pablo callpanchäla lluy chayćhu cäcunäta: “Ishcay simänañam mana micuśha nï puñuśha cayalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Chaymi canan salbacuyta munapäcul'a imallactapis micaycälinayqui prisïsan. Manam mayanniquipapis jucllay ächallayquipis chincan'achu” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nilculmi lluypa puntanćhu juc tantacta apticulcul Diosta sulpäta ucula. Jinalculmi partiycul micuyta allaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Jinaptinmi lluypis balurchacalcälil micapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(Chay barcućhu ishcay paćhac anćhish ćhunca sütayu (276) nunam capäcula.) ");
INSERT INTO qvwNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Chayćhu lluy maćhacaycälilmi barcuca jacyalpunanpä quïdaśhan trïgucunäta lamarcäman lluy jitalpälälin. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Chayćhu ñä achicäluptinñam barcüta puśhäcunaca mana may allpa caśhantapis lisipäculachu. Chayćhu tantiapaculcänanpämi juc ućhanu lamar patanćhu arrinillayu jawca yacucta licälälil limanacucuyalcan chayman barcüta imanuypapis ćhächipäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Chaynu nilculmi watü chalaläśhancunäta cuchuycul lamarcäćhu caćhaycälälin. Barcup puśhanan wataläcätapis wayaycälälinmi. Chaynütac barcup puntanćhu lataśhcätapis waywäman pallalcäläliptinmi barcuca allpa-läduman liyta allacuycun. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Chaynu allin liyäśhanćhümi wicpi caypi yacu tupacacäśhanćhu arrinilla uluchacäśhäman barcup puntan śhaticacüluptin mana cuyulil quïdälun. Ipantañatacmi alli-alli yacu wicapacamüca lluy wichicächicuyan. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Chaynu jinacuyaptinmi cachacucunaca: “Prïsu puśhaśhanchicunäta lluy wañuchishun mana nädaśhtin ayiyculcänanpä” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Niptinmi cachacup puydïnin Pablocta cawsayäta ćhächiyta munal aśhwanpa: “Nädayta yaćhäcunacá yacüman ji'alcalpul puntapäcuy allpäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Juccunäñatacćha ima tablachacunactapis chalalcul janäninman ishpilcul yalapäcunqui” nila. Chaynüpam cawsayal allpäman lluypis allin ćhälälí. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Chayćhu lluypis salbacälälishaña cayalcalmi yaćhälälí chay lamar ćhawpićhu malca Malta śhutiyu caśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Chay malcayücunaca lluytapis cuyaywanmi atindiycäliman. Chayćhu sumä ucapäśha tamyaćhu cayalcaptïmi ninacta lataycachil “Unupaculcay” nipäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Chayćhu Pablo chaqui yamtacta ashilcamul ninäman jitaycuyaptinñatacmi juc culibray ninaca lupänanpïta ayimuśhanćhu Pablop maquinman alwicalcul caćhülun. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Chaynu Pablop maquinćhu walcaläcuyaptinmi chay malcayücunaca quiquin-pula: “Cay umri sigürupis nuna wañuchicüćha cayan. Chayćhá cay lamarca millpunanpi salbacüluptinpis diosninchiccuná cawsananta mana munanchu” ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ñatac chayćhu Pablo maquinta tapsïluptinmi culibray ninäman palpüluptin uchuyllapis imanpis imanalapischu. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Chay malcayücunañatacmi licapacuyalcan: “Sacsapacülun'aćh ütac imayürapis wañülun'aćh” nil. Chaynu unayña licapayalcaptin mana imapis pasaptinmi: “Cay'a juc diosćha sigürupis” nil ninacücuyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ñatac wic-läduscallaćhümi chay malcap puydïnin Publiop ćhaclancuna cañä. Paymi ćhasquiycälimal sumä cuyacuywan quimsa muyun atindiycälimäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Paypa taytanmi calur ishyaywan ićha ishyaywan cämaćhu jitalayäñä. Chayta yaćhälul Pablo payman watucü lilmi Diosta mañacuycul maquinwan yataycul allinyächila. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Chay allinyächishanta yaćhälälilmi juc ishyäcunäpis śhapämul lluypis tuqui sänu quïdapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ñatac imaymana rigälucunactam uycäläliman. Manam chaycunallactachu sinu'a chaypïta yapa pasapäcuná cayaptinmi uycäliman mana pishipaculcänäpäpis. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Chaynu quimsa quilla masña chayćhu caycälishäpïmi juc barcu tamya quilläćhu jamapacücäwan pasaculcá. Chay Alejandriapi barcu taytachan Casturtawan Poluxta la'apacüśham cacuñä. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Chay lamar patanćhu Siracusa malcaman ćhaycälilñatacmi quimsa muyun caycälilá. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Chaypïta lamar patancascap yapa pasapäculmi Regio malcäman ćhälälí. Chay walantinñatacmi lipäcuná läduman waywa talcämuptin lipäcul juc muyunlä ćhälälí lamar patanćhu Puteoli malcäman. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Chay malcaćhu chalapacücunacta talïläliptïmi “Simänallapis caycuśhunlä” nil ruygapämaptin quïdapäculá. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Chaypïmi Romaman ćhaquillawan lipäculá. Chay Romaćhu chalapacücunañatacmi yaćhapäcuñä ćhäpäcunäta. Chaymi Quimsa Jamachicuna nishancama Apiop pläsaman alcapämä śhapämuñä. Chayćhu Pablo paycunacta licälulmi Diosta anradisicuycul masta callpanchacula. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Chaynu Romaman ćhäläliptïmi ˻cachacucunap puydïnin prïsucunäta wardiap puydïninpa maquinman ćhulaycula. Pabloctañatacmi ichá˼ cachacup ñawillanćhu juc wasićhu japallan yaćhamunanpä caćhaycula. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Chaynu Pablo quimsa muyun caycuśhanpïmi Romaćhu puydï Israelcunäta ayachimula. Chayćhu juntunacämuptinmi: “Israel-masïcuna, cayćhu imapi caśhäta willaycälishayqui. Manam uchucllapis malcanchicta nï camachicuyninchictapis jalutaculächu. Jinayaptïpis Jerusalenćhu chalalcälimalmi Romap puydïnincunap maquinman ćhulaycachimäla. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Paycuna ima juchallactapis wañuchipämänanpä ya'aćhu mana talipäculmi caćhaycapämayta munapäcula. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Chayćhu malca-masinchiccuna mana munätuculcaptinmi ya'a mañaculá quiquin Romap Puydï Cesarca arrinlaycamänanpä. Chay mañacuśha-laycullam cayćhu cayá. Manam malca-masïcunacta imapïpis juchachä śhamüchu. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Aśhwanpam cayćhu caynu cadinawan watäśha cayá Diosninchic limalicamäśhanchicman chalapacuśhäpa. Cay-laycum amcunacta ayaycälilac lisiycul, limapaycälinacpä” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Niptinmi nipäcula: “Ampïta manam ya'acunaman ćhämulachu ima papilllapis Judea-lädupi nïtac chaypi śhamücunäpis ampa waśhayquita limapäculachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Chaymi chalapacuśhayquipïpis canan niycälimänayquita ya'acuna munapäcú. Ñatac intirućhümi ‘Yan'almi cay muśhü willacuy’ nil limapäcüta uyalipäcú” nin. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Chayćhu Pablo juc muyunpä jitanacapäcuśhanmanmi alli-alli nunacuna śhapämuñä. Chayćhümi achicyalcuypïta aśhta aspilpunancama Diospa gubirnunpïta limapäla. Chayćhu lluytapis Jesuspi awnichiyta munalmi willapäla Moisespa camachicuyninpïta, Diospa willacünincuna isquirbishancunäpïtawan. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ñatac chayćhu waquinninmi Pablo willaśhanta ćhasquiculcäla. Waquinnincunañatacmi ichá mana ćhasquïtuculcälachu. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Chayćhu quiquin-pula iwinacucuyalmi licuyta lluy allacaycälin. Chaymi Pablo nila: “Amcuna awquilluyquicunanümi cayalcanqui. Allintam limachila Chuya Ispiritu awquilluyquicunacta Diospa willacünin Isaiaswan cay nil: ");
INSERT INTO qvwNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Lil niycamuy cay nunacunäta: “Maynüpa uyaliyalcalpis manam yaćhapäcunquichu, maynüpa licayalcalpis manam licapäcunquichu” niyäta. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Cay nunacunap tantiaynin lumiyäśham cayan, linlipis quillpacüśham, ñawinpis aplacüśham cayan, mana licapäcunanpä nï uyalipäcunanpä, nï ima caśhanta yaćhalpapäcunanpäpis. Artictam ya'aman mana filtapämunchu ya'a sänachinäpä’ nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“¡Yaćhapäcuy amcuna! Cananpi puntaman'a Diosninchicpa salbacuynintam willaśha can'a mana-Israelcunäman. Paycunam ichá sumä cushicuywan ćhasquipäcun'a” nila. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","˻Cay niyta camacäluptinmi Israelcunaca quiquin-pula iwinacüśha licula.˼ ");
INSERT INTO qvwNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ñatac Pablo chay lïtaśhan wasićhümi ishcay wata intiru quïdacula. Chayćhümi watucünin lïcunätapis ćhasquila. ");
INSERT INTO qvwNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ñatac chayćhümi Diospa gubirnunpïtawan Salbacü Jesusninchicpïta willacula mana pictapis manchacullal nï mayanpapis imactapis niycuśhalla. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ya'a Pablo Salbacü Jesuspa nunanmi isquirbiycamuc. Tayta Diosmi jucnin puydï caćhanpä japächaycamal allin willacuyninta willacunäpä caćhamäla. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Cay allin willacuyca Tayta Dios unay willacünincunawan limalicamäśhanchic shiminćhu cäyäcämari. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Chay willacuy Chulinpïmari. Pay nuna cayninpïtá puydï mandacü Davidpa milayninpi śhamulmi ya'anchicnuy nuna cala. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ñatac Tayta Diospa Rasun Chulin caśhantá Chuya Ispiritunpa munayninwan wañuycäpi śhalcachimuśhanwanmi camalachila. Pay Duyñunchic Salbacü Jesusmá. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Paypamari llaquipäcuyninćhu Tayta Dios willacüninpälä ćhulaycaman jinantin pachäćhu mana-Israel nunacunäta payman chalapacachiptí cäsuculcänanpä. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Aw-ari, paymi am Roma malcaćhu cäcunätapis ayaycuśhunqui Jesusninchicpa nunan capäcunayquipä. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Chaymi am Romaćhu cäcunäman, Tayta Dios cuyaśhancunäman, Jesusninchic nunan canayquipä ayaycuśhancunäman isquirbiycälimuc. Quiquin Tayta Diosninchicwan Duyñunchic Jesuspa llaquipayninpïta jawca cawsay amcunaćhu caycuchun. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Puntactá, jinantin malcacunäćhu allin chalapacuyniquipi limapäcuśhanta uyalilmi Tayta Diosninchicta sulpäta ucú Jesusninchicpa. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Paytam llapan śhun'üwan cay Chulin Jesuspi allin willacuyta willacuśhtin sirbí. Diosninchicmari tuquicta yaćhan mana pishipällal amcunapi mañacuśhäta. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Chaynütacmi mañacuyá, Tayta Dios munaptin'a amcunaman ćhämunäpäña. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Rasunpa śhamuyta wañupacuyá Chuya Ispirituwan chalapacuyniquićhu callpanchaycälinacpämi. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Aw-ari, ampis ya'apis Jesusninchicćhu chalapacuyninchicpam yanapänacuycunchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Chalapacü-masïcuna, canancamapis mayćha amcunaman śhamuyta munalá. Ñatac imaymana sasachacuycunam licalicämun licalicämun. Yaćhaycälinayquitamari muná mana-Israelcunäćhu lulaśhänuy amcunaćhüpis Tayta Diospä achca-achcacta juntuycuyta munaynïwan śhamuyta atipacamuśhäta. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Cay allin willacuyta willacunäpä lluy-lluyman mänum cayá: sumänin nunacunämanpis, mana cäpä licaśha nunacunämanpis, chaynütac yaćhayniyücunämanpis mana yaćhayniyücunämanpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Chaymi am Romaćhu cäcunämanpis willaycuypi sumä wañupacuyá. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Aw-ari, cay Jesuspa allin willacuyninta willacuypi mayantapis manam ya'a pin'acüchu. Cayman chalapacücäta Tayta Dios salbaycunanpä sumä munaynin cayanmá, manyallapi Israel caśhtacunapïpis jinaman juccunamanpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Cay allin willacuymi tantiaycachimanchic, Tayta Dios imanuypa nunacunäta allinpa licaycamäśhanchicta: chalapacuyllanchicpamari allaycunchicpis, chalapacuyllanchicpatacmi camacanchicpis. Chaymi niyan unay isquirbishanćhüpis: “Chalapacuyllanpa allinpa Tayta Dios licaycuśhancällamá rasun allin cawsayniyu can'a” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Chaynütacmi Tayta Dios piñacuynintapis camalaycachimanchic chay sumä mana allin lulayninwan rasuncäta lisinanpä atajäcunäpä. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Paycunapá Tayta Dios piñacun uyaypa camalaycachicuptinpis ipanchapäcuśhanpam. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Masqui quiquin Tayta Diosta mana licayalpis, cay pachäta camaśhanpi lluy lulaśhanta licaśhanchicwanmi ichá yaćhanchic Tayta Dios rasun caśhanta, jinaman wiñay munayniyu caśhantapis. Chayurá manam mayanpis imapi limalcälinan canñachu. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Chaynu Tayta Diosta lisiyalcalpis nunacunaca manam Tayta Diostanüchu altuman julaycälila nïtac sulpätapis uculcälachu. Aśhwanpam uman chalaśhan yan'alcunaman tantiayalcan, śhun'unpis pasaypimanñamari muyülun. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Chaynu yaćhayniyütucüśha cayalcalpis pasaypi luclumanmi muyülälin. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Wiñay simpri cawsä Tayta Diosta alawapäcunantá, chincacü nunactanuy luläśha taytachacunacta, pishucunacta, culucunacta, imaymana licchä uywacunactam cuyacalcälin. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Chaymi chay anla śhun'uncunap munayninman Tayta Dios caćhaycüla. Jinaptinmi quiquin-pulacuna pin'ay anla lulaycunaman ćhächinaculcäla. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Rasuncäpïtá aśhwanpam artiman muyucalcälila. Chaynüpam quiquin Camacücäta alawapäcunantá chay camaśhancunällacta alawapäcula, sirbipäcula. ¡Ñatac Diosllari imaycamapis alawäśha cachun! ¡Chaynu cachun! ");
INSERT INTO qvwNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Chaynu quiquinpa munayninta lulayalcaptinmi, Tayta Dios caćhaycüla chay pin'ay anla lulay munaśhancunäman. Chaymi walmicunäpis wayapancunacta caćhaycul walmi-masincunawan anla juchapacuycunaman muyucalcälila. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Chaynütacmi wayapacunäpis, walminwan tuqui cacunantá, quiquin-pulacuna wañuy-wañuyta munapanacücuyalcäla. Chaymi wayapa-pulacuna pin'ay anla lulaycunacta lulayalcäla. Caynu iwïsha lulaynincunapïmi mućhuyninta ćhasquipäcun. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Chaynu śhun'unpi Tayta Diosta alupäcuptinmi pasaypi śhun'unpä munayninmanña caćhaycüla imaymana mana lulanacunacta lulapäcunanpä. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Chaymi imaymana mana allincunallawan tawacüśha cayalcan: imaymana anla lulaycunawan, lägacuycunawan. Chaynütac inbidiacuycunawan, wañuchicuycunawan, ma'anacuyllacta ashiycunawan, mana allin iwïsha limaycunallawan, waśha limaycunallawan. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Chaynütacmi tumpapäcun, Diosta ćhïnipäcun, mana allinta pinsapäcun, nunatuculcan, munay-sapa capäcun, taytancunapä shimi-sapa capäcunpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Paycuná mana uyalïtucücunam, limayninman mana chalapacunacunam, mana śhun'uyu nunacunam, mana pampachaycuyta yaćhäcunam, mana llaquipayniyücuna imam. ");
INSERT INTO qvwNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ñatac caynu luläcunäta Tayta Dios wiña-wiñaypä mućhuchinan caśhanta yaćhayalcalpis manamari lulayllachu lulapäcun, sinu'a juccuna lulaptinpis bïbapäcunlämi canpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","¿Icha nipäcunqui “Ima cá nunacunatan” nilchun? ¿Nipäcunayquipä mayan tucuyalcanquitan? Paycunacta cäraycuyal'a quiquillayquim cäraycucuyalcanqui. Amcunapis chaynu cayalcal'a, manam imapi imaninayquipis canñachu. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Canan yaćhanchicñam caynu cawsäcunäta Tayta Dios rasun allincämannuy cäraycunanta. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Chay juchachaycälishayquinuy amcunapis lulayalcal'a ¿imanuypatá Tayta Diospa cäraycuyninpi ayïlälinquiman? ");
INSERT INTO qvwNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Icha ¿llaquipaynintawan pasinsiaynintachun jalutacuyalcanqui? ¿Icha manachun tantiapäcunqui juchayquipi wanacunayquipä allin pasinsiayniyu llaquipayniyu pay caśhanta, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Chaynu mana uyalicul śhun'uyqui munaśhanta lulayal'a Tayta Dios tincüninman cäraycunancäpä piñacuyninta mas mastalämi tawacuyalcanqui. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Chay muyunmi “Lluy nunacta lulaśhanman tincüta Dios uycun'a” ");
INSERT INTO qvwNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Allincäćhu tacyaycul Tayta Dioslla altuman juluycunanta, allinpa licaycunanta, wiñay cawsayta uycunanpä ashiycunätá pay quiquinmi uycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ñatac chay allincäta ipanchaycul pasaypi cullucuycul mana allincällacta ashïcunätam ichá, Tayta Dios sumä piñacuyninta caćhaycülun'a. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Caynu nunacunapämi wa'acuy llaquicuy, ñacaycuna cacun'a, masqui Israel mana-Israel caśhta captinpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Allin luläcunapäñatacmi ichá jawca cayllaćhu altuman juluycuśha allinpa licaycuśha imalä capäcun'apis masqui Israel mana-Israel caśhtapis. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Tayta Dios'a chaycuscactam llapa nunactapis licaycamanchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ñatac camachicuyniyu cä juchayu Israel caśhtactapis, ütac mana camachicuyniyu cä juchayu juc caśhtactapis Tayta Diosmi chaymannuy cäraycun'a. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Camachicuyta uyalishallayquipachu manamari Tayta Dios juchannäta lican'a, sinu'a cäsucücunätamá. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","¿Manachun licanchic chay mana camachicuyniyu caśhtacunaca quiquillanpi tantial camachicuy nishanta lulapäcuśhanta, imamá? Caymari tantiachimanchic paycuna imacta lulapäcunantapis mana lulapäcunantapis tuquicta yaćhapäcuśhanta, masqui isquirbishaćhu mana uywayalcalpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Lulaynincunamari camachicuyca śhun'unćhu caśhanta camalachin. Quiquinpa śhun'unmari lulaynincuna allin mana allin caśhantapis niycun. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Cäraycunan muyuncäćhüñatacmi Tayta Dios niycuptin llapa nunap śhun'unćhu pacacuynincunacta Jesus cäraycun'a. Cay can'a allin willacuyta willacuśhämannümari. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ñatac “Israel caśhtam cayá” nil ¿mayan tucunquitan? Camachicuyman chalapacuyanquitac, jinaman Tayta Diosta lisishayquipïtá nunatucunquitac. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","“Tayta Dios ya'acunapi imacta munaśhantapis yaćhayämi” nil niyanqui. “Camachicuypatacmi allincäta aclaycunapäpis yaćhayá” niyanquitacmi. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Chalapacuy cüsacunaćhu aplacunäpa puśhaycünin tucuyalcanquimá. Jinaman tutapäćhu pulïcunäpä acchi-yupay puśhänin-tucuyanquitacmá. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Mana tantiayniyücunäpäpis müsucunäpäpis yaćhachicünin-tucunquimá. Lluy caycunawan “Camachicuymi llapa yaćhaytapis, rasuncätapis uycaman” nilmi niyanquipis. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","¿Chaynu nuna-masiquicunacta yaćhayächilchun, quiquiquiñatac yaćhachishayquimannüchu mana lulanquiman? “Manam suwacunachu” nil yaćhayächilpis, ¿manachun quiquiqui suwacuyanqui? ");
INSERT INTO qvwNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","“Manam mansibacunachu” nil yaćhayächilpis, ¿manachun quiquiqui mansibacuyalcanqui? “Taytachacunacta ćhïnïmi” niyalpis ¿manachun chay taytachacunap imapis cänincunacta wañupacuyniquiwan suwacuyalcanqui? ");
INSERT INTO qvwNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Chaynu Diospa camachicuyninpi nuna-nunaycuśha yaćhätucuyalcalpis, ¿manachun mana cäsucuyniquiwan'a camachicuyta jalutacuyanquitac? ");
INSERT INTO qvwNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Chaymari Tayta Diospa unay willacüninpis niyan: “Amcunap janayquimá llapa mana-Israelcunapis Tayta Diosninchicta jamuyan” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Rasunpa, mayanniquipis umri cayniquićhu Tayta Diospä siñalachicuśhanca allinmi camachicuyta cäsucuptiqui'a. Mana cäsucuptiquiñatacmi ichá mana siñalachicuśha-yupay cayanqui. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ñatac mana siñalachicuśha mana-Israelcunaca, camachicuymannuy cawsaycuptin'a, ¿manachun siñalachicuśhactanuy Dios licaycun'a, masqui mana cayaptinpis? ");
INSERT INTO qvwNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Amcuna camachicuyta mana cäsucuptiqui'a, juc caśhta mana siñalachicüśha camachicuyta cäsucücunämi amta cäraycälishunqui, masqui siñalachicüśha jinaman camachicuyta uywayalcaptiquipis. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Israel caśhta cay, manam janällanchicćhu lulaycaćhaśhallanchicpachu; nïtac aychallanchicćhu siñalachicüśhanchicpachu. ");
INSERT INTO qvwNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Rasunpa Israel caśhta cay'a lulïninchicpïmá; siñalachicuycäpis śhun'unchicpïmá. Caynu śhun'u manamari isquirbisha camachicuypïchu śhamun, sinu'a Ispiritup wayuyninpïmi. Caynu nunacta manam nuna-masillanchu allinpa licaycun'a sinu'a quiquin Tayta Diosmari. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Chaynu captin'a ¿Israel caśhta cay ima allinmá? ¿Siñalachicüśha caśhanchicpis ima allinmá? ");
INSERT INTO qvwNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Allintá allinmá Israel caśhta cay: paycunaman quiquin Tayta Dios limayninta ćhulaycula licaycälinanpä. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Rasunpa waquinnincuná manam chalapaculcälachu. Ñatac ¿chaynu mana chalapaculcäśhanpachun Tayta Dios mana chalapacuna cälun'a, imamá? ");
INSERT INTO qvwNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Manamari! Masqui lluy mana allin artillacta niyalcaptinpis, pay'a rasuncällactam nin'a. Chaymi Diospa shiminćhüpis niyan: “Limaptiqui'a rasuncäćhu caśhayquita lluyćha yaćhapäcun'a; chaymi cärayculpis llallinqui” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ichaćh waquinnincuna: “Juchanchiccunam Tayta Dios maynu sumä caśhanta camalaycayächin; chayurá mućhuycachimänanchicwan'a allin cayninmannüchu manaćh lulaycun” niyalcan. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Chay manam chaynüchu! Tayta Dios tincüninman mana licaycü cayal'a, manaćh imaypis cay pachäta cäraycuyanmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Waquincunañatacćha nin'a: “Articuynïwan Tayta Diospa rasun caynin mas-mas altuman juluycuśha cayaptin'a, ¿imapïtan-nila jucha-sapapa cäraycayämanman? ");
INSERT INTO qvwNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Chayurá mana allincällacta lulaycuśhun allinca śhaycamunanpä” nil. “Caynümi yaćhayächin” nil tumpapämanlä canpis. Paycunacta Tayta Diospa mućhuycachiyninmi tincüninmannuy alcaycuyan. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Chayurá ¿Israelcunaca mas allinchun cacuyanchic? ¡Manamari! Tantiaycälichicñam Israel mana-Israel caśhtapis juchap maquillanćhu caśhanchicta. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Chaymi Diospa shiminćhüpis cayta niyan: “¡Manam mayan nunallapis mana juchayu canchu! ¡Jucllayllapis manam canchu! ");
INSERT INTO qvwNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","¡Manam mayanpis Tayta Diosman licaćhacü canchu! ¡Jucllayllapis ashiycü manam canchu! ");
INSERT INTO qvwNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Lluypis pintïlälinmi; lluy lluymi pampaman muyülälin. ¡Manam mayanllapis allincäta lulaycü canchu; manam jucllayllapis canchu! ");
INSERT INTO qvwNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Tuncurincunapis nïchu quićhalayäcänümi cayan; alluncunapïpis articunallam yalayämun; shimincunaćhüpis culibraypa bininuncunallam winalayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Shiminpi piñacuycunallawan mana allin juyu cananpä limaycunallam juntäśha cayan. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ćhaquinpis nuna-masinta wañuchinanpämi pinquiylla pinquiyan. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Chaymi pulishancunaćhu mana allinllacta, llaqui pulumäśhacta caćhaycamun. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Jawca cawsayćhu yaćhayta manam lisipäcunchu. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Umanćhu manam caycunchu Tayta Diosta manchacuywan licaycälinanpäpis” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Canan yaćhanchicmi camachicuyca maquinćhu cäcunällapä caśhanta. Chay jinantin pachäćhu cäcunaca imaniculcäśhantapis upällachil Tayta Diospa cäraycuyninman puśhamunanpämari. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ñatac camachicuyta lulaśhanchicpachu manam Tayta Dios allinpa licaycamanchic. Aśhwanpa camachicuycá tantiaycachimanchic jucha-sapa caśhallanchictam. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Cananñatacmi ichá Tayta Dios camalaycachimanchic nunacunaca imanuypa paywan allinpa licachicunapäpis. Cay manam camachicuypïchu śhamun. Ñatac cay rasun caśhanta camachicuywan Diospa willacünincuna isquirbishanćhümi niyan. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Tayta Dios juchannäta licamanchic Jesusman chalapacücunätam, masqui mayan cacuptinchicpis. Pay mana juc-jucpächu licamanchic ");
INSERT INTO qvwNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","jinantin pachäćhu cä llapa nuna juchallaćhu cayaptinchicmi, Tayta Diospa sumä chuya cayninpi japächäśha cayaptinchicmi. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Chaynu cayaptinchicpis Tayta Dios'a Jesusman chalapacuśhallanchicpam juchannäta licaycamanchic. Paymari dinbaldilla llaquipayninwan juchanchiccunacta pampachaycamanchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Tayta Diosmi unanchaycula juchanchic-laycu wañunanpä. Chay uycuśhan yawarninman chalapacuptinchicmi paywan allinpa licaycamanchic. Maynu sumä allinllanman cäraycü caśhanta caycunapam tantiaycachimanchic: puntactá, llaquipayninćhu unay nunacunap juchancunapi manalä mućhuycachishanwan, chaynütac cananpis Jesusman lluy chalapacücunäta juchannäpäña licaycuśhanwanpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Chayurá ¿mayantá juchannä caśhanchicpi alawacuchwan? ¡Manamari mayanninchicpis! ¿Imapi? Manamá camachicuyta cäsucuśhanchicpachu, sinu'a Jesusman chalapacuśhallanchicpam. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Chayurá caymanmi chumacacun: nunaca juchannä licaycuśha chalapacuyllanpam, manam camachicuyca nishanta lulaśhanpachu. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Tayta Dios ¿Israelcunällap Diosllanchun? ¿Manachun mana-Israelcunapá? Aw, mana-Israelcunäpäpis Tayta Diosninmi. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Jucllayllam Tayta Dios. Payllamari siñalachicüśha mana siñalachicüśha cäcunätapis chalapacuyllanchicpa juchannäta licaycamanchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","¿Chayurá chalapacuycäwan camachicuyta mana ćhaniyümanñachun muyuchinchic? ¡Manamá! Aśhwanpam tacyalpachinchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ñatac lluy caycunapi ¿imanichwanmi awquillunchic tayta Abrahampi? ");
INSERT INTO qvwNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Sïchuśh Abraham lulayninpa Tayta Dioswan allinpa caycuptin'a, alawacunanpä canmanćhá cala. Ñatac Tayta Diosćhu'a manamari. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Chaymi Diospa limayninćhu niyan: “Tayta Diosman chalapacuśhallanpam Abraham allinpäña ćhasquiycuśha cala” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Canan má, lulachicuśhanchic nunap pägunta manam rigalayänüchu uyanchic, sinu'a lulaśhanpi tincüninmanmi unchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ñatac mayanpis quiquillan lulananpïtá, jucha-sapacta juchannäman muyuchï Tayta Diosman chalapacullalmi ichá, allin chuya nunapäña licaycuśha cayan. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Caynu nunacunäpa lulayninta mana licallal juchannäta Tayta Dios licaycuśhanta, puydï mandacü Davidpis tantialam. Paycunapïtamari isquirbishanćhüpis “sumä cushishacuna” niyan: ");
INSERT INTO qvwNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“¡Paycunapá maynu cushicuymi juchanta pampachaycuśhanpi, mana allinnincunacta chincaycachishanpi! ");
INSERT INTO qvwNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","¡Maynu cushicuymi juchancunacta manaña imaypis Taytanchic yalpalcuśhancunäpá!” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿Cay cushicuy Israel siñalachicüśha caśhtacunallapächun icha juc-lädu mana siñalachicüśhacunäpäwanchun? Nilanchicmari chalapacuyllanpa Abrahamta allinpäña Tayta Dios ćhasquiycuśhanta. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Chaynu captin'a ¿imaytá allinpa ćhasquiycula, siñalachicüluptinñachun icha puntactalächun? ¡Manaläpis siñalachicuptinmá! ");
INSERT INTO qvwNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Chaypïlämi siñalachicula. Chay Tayta Dios mana juchayütaña chalapacuyllanpa ćhasquiycuśhanta camalachinallanpämi cala. Ñatac payman chalapacula manaläpis siñalachicüśha cayalmi. Chaymi Tayta Diosman chalapaculcal'a lluy mana siñalachicüśhacunäpis Abrahampa ayllunña cayalcan. Chaymi paynüpis mana juchayüña licaycuśha cayalcan. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Chaynütacmi siñaläśhacunäpis milaynincuna cayalcan. Manam siñaläśha cayllanpachu, sinu'a manaläpis Abraham siñaläśha cayal chalapacuyninpa laśhćhunman jaluycuśhanpawanmi. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Tayta Dios limalicula Abraham lluy milaynintin jinantin pachäta ćhasquiycunanpä manam camachicuyta lulaycuśhanpachu, sinu'a Tayta Diosman chalapacuśhallanpam. Chaymi mana juchayütaña Dios licaycula. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Chayurá “Tayta Diospa limalicuśhanca camachicuyta cäsucücunapämi cayan” niyaptinchic'a, Tayta Diosman chalapacuypis yan'almá, limalicuśhanpis, pampapämá. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","¿Imactamá camachicuyca limalicun? Mana cäsucünincunacta mućhuycachiyllactamá. Ñatac camachicuy mana cayaptin'a jalutacuy manamá canmanchu. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Chaymi limalicuyca chalapacuyllanchicpa śhamun Tayta Diospa llaquipayllanpa caśhanta camalaycachimänanchicpä. Caynüpamari Abrahamman limalicuśhanta tacyalpachin llapa milaynincunapäpis. Yapa niycuśhayqui: Manam camachicuyta lulay jicutänallapächu, sinu'a Abraham chalapacuśhannuy Tayta Diosman chalapacuśhanchiccunäpäwanmi. Paymari chalapacuy cüsacunaćhu lluypa awquillunchic, Diospa shiminćhu nishannüpis: ");
INSERT INTO qvwNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","“Lluy nasyuncunap awquillunmi canqui” nil. Abraham chalapacuśhan Tayta Dios caymari: wañuśhacunactapis cawsayta uycücämi, limayninwan mana cäpïpis licalichïcämi. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Masqui lluy mana lulacacünuy captinpis Tayta Diospa limalicuśhanmanmi Abraham chalapacula. Chaynu jinaśhanpamari achca nasyuncunap taytan licalïla, limalicuyćhu: “Achcam milayniquicuna can'a” nishanmannuy. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Chaynu aychan wañuypa patanćhü-yupayña cayaptinpis, paćhac watayü-yupayña cayalpis, jinaman walmin Sara mana waćhacü chacwaśhyayaptinpis, Diosman chalapacuynin'a manam mirmalachu. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","21","Manatacmi ishcayyayälachu “Limalicamäśhanca rasunpachućh icha yan'alchućh” nil. Aśhwanpa chalapacuyninpam callpanchaculapis; Tayta Diostapis altuman juluycul sulpäta ucula “Taytá limalicamäśhancäta lulaycun'amari” nil. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Chaymi Diospa shiminćhüpis, “Chaynu chalapacuyllanpam Tayta Dios allinpäña ćhasquiycula” niyan. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","24","Caynu “Tayta Dios chalapacuyllanpam juchannäta ćhasquiycula” nishanca manam payllactachu niyan sinu'a ya'anchictapis niyämanchicmi. Ya'anchictapis mana juchayüta licaycamanchic, Duyñunchic Jesusta wañuycäpi śhalcachimücäman chalapacuśhallanchicpam. ");
INSERT INTO qvwNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Aw, juchanchic-laycum Tayta Dios wañuycäman Jesusta ćhulaycula. Jinaman juchannätaña licaycamänanchicpämi śhalcachimula. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Chayurá Duyñunchic Jesus lulaśhanman chalapacuśhallanchicpam, Tayta Dios “Juchannämi canqui” nimanchic. Chaymi paywan jawca cawsayćhu caycunchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Chalapacuyninchicpam Tayta Diosman Jesus puśhaycamanchic llaquipayninćhu cawsaycunapä. Chayurá sumämi cushicunchic pay sumä alli-alli ćhaniyünincunactalä ya'anchicwan wäćhanacuycunanta yaćhayal'a. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Jinaman'a cushisha cayanchic masqui ima ñacay, llaqui intumaptinchicpis caycunawan tacyaycachimänanchicta yaćhayalmi. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","5","Tacyaycuptinchic'a Tayta Dios allin pasäpäñam licaycamanchic. Caymari payman masta chalapacachimanchic. Manatacmá llaquishachu cayäna, Tayta Dios sumä cuyacuyninta Chuya Ispiritunwan alli-allicta uycayämaptinchic'a. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Caynümi cuyacuynin: Mana cäña imanuypapis salbacuyta mana atipaptinchicmi, llapa nunap juchanchicpïta Salbacü Jesus wañula. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Mayanpis allin nunap janan cawsayninta manaćh uycülunmanchu. Ichapisćha waquinllá lulälunmanpis. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ñatac ya'anchic jucha-sapanninlä cayaptinchicmi Jesus ya'anchic-laycu wañula. Chaynüpam Tayta Dios camalaycachimanchic maynu-maynu cuyamäśhanchictapis. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ñä, yawarninpa “mana juchayüñam canqui” niyämaptinchic'a ¡maynüñaćh piñacuyninpïtá Tayta Dios salbaycamäśhun! ");
INSERT INTO qvwNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Chaynütac Diospa ćhïnicünin cayaptinchicpis chulinpa wañuyninwan caśhan jucllachayämaptinchicñá ¡maynüñaćhari cawsayninwan'a salbaycamäśhun! ");
INSERT INTO qvwNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ñatac manam cayllachu, sinu'a allinpa licaycachimäninchic Jesusninchicpam quiquin Taytanchicćhu sumä-sumä cushicunchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Má, uyalipäcuy cayta: Wamä nuna Adan juchacta lulälulmi cay pachäman wañuyta ćhächimula. Cay juchanpïmi jinantin pachäman wañuyca miläla, lluy-lluypis juchacta luläluptinchicmari. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ñatac Tayta Dios camachicuyninta manalä camalaycachiptinpis nunacunaca juchacta lulapäculañam. Aw-ari, mana camachicuy cayaptin'a manatacmi may-chicacta jalutacuśhanchic tawacäśhantapis yaćhaśhachu. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Chaynu captinpis Adan timpupi aśhta Moisescamam lluy wañupäcula, masqui quiquin Adannuy mana cäsucuyninwan Tayta Diospa camachicuyninta nï jalutacuyalcaptinpis. Má ¡cay Adanwan ima juc-jucmi chay śhamüca! ");
INSERT INTO qvwNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mana tincuycachinamari chay juchawan Tayta Dios dinbaldilla uycamäśhanchic'a. Aw, rasunpa jucllay Adan nunallap juchanpïtam achca-achcaman wañuyca miläla. Ñatac jucllay nunallapmi, Salbacü Jesusllapmá, achca-achcactatac pampachaycamanchicpis. Caynüpam Tayta Dios sumä jatun cuyacuyniyu llaquipayniyu caśhanta camalaycachimanchic. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Chaynütac cay Tayta Dios dinbaldilla uycamäśhanchicpa camacaynin manam chay nunap juchanpa camacayninnüchu. Jucllay nunallapmari “Juchayquipi cäraycuśham canqui” nisha calanchic. Ñatac Tayta Diospa uycamäśhanchic'a juchacunapïtalämi śhamula, “Juchannäñam canqui” nishtin. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Chay Adanpa juchanmi ichá llapa nuna wañuycäpa maquinćhu cananchicpä cala. Ñatac Tayta Dios'a sumä llaquipayninćhu julaycamanchic Salbacü Jesuspam “Mana juchayüñam canqui” niycamänanchicpä. Cayta ćhasquicücunacá paywan wañuycäta llallïcunam capäcun'a. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Chayurá jucllay nunap juchallanpïmi jinantin nunacunaca cäraycuśha mućhuycachisha canapä cälun. Ñatac jucllay allin nunap lulayllanpatacmi jinantin nunacunäpis Tayta Diospa puntanćhu mana juchayüña cawsaycuchwan. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Maynümi jucllay nuna mana cäsucuśhallanpa lluypis jucha-sapaman licalïlunchic, chaynütacmi jucllay nunap cäsucuyllanpa lluypis juchannäña licaycuśha caycuchwan. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Tayta Dios camachicuyta uycamälanchic mana allin lulayniyu maycama caśhanchicta licaycachimänanchicpämi. Ñatac maynu jatun jucha captinpis Tayta Diospa llaquipaynin'a maynu sumä-sumä jatunlämi. ");
INSERT INTO qvwNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Unay'a juchap munayninćhu cayalmi maquinćhu lluypis wañunanchic cala. Ñatac canan'a Tayta Diospa maquinćhüñam cayanchic; llaquipayninpam “juchannäta” licaycamanchic Duyñunchic Salbacü Jesuspa wiñay cawsayta uycamänanchicpälä. ");
INSERT INTO qvwNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Chayurá ima? ¿“Jina juchallacta lulaycuyäśhun Tayta Diospa llaquipaynin masta-masta camalaycunanpä” niyäśhunchun, imatá? ");
INSERT INTO qvwNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","¡Chaynu manamá canmanchu! Cay juchäpá lluy wañüśhañam cayanchic. Chaynu cayaptin'a ¿lulayta jicutayachwanlächun? ");
INSERT INTO qvwNT_vpl VALUES ("RM6_3","0