﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvsNT_vpl;
CREATE TABLE qvsNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvsNT_vpl WRITE;
INSERT INTO qvsNT_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ñukanchikuna mana sakra runakuna willawananchikunata kasushpanchikuna kushikushpa kawsanchisapa. Mana uchallikuk runakunashina kawsashpa mana uchata rurashpa kawsashpanchikuna kushikushpa kawsanchisapa. Mana Tata Diosta asichik runakunapa yuyanankunata rurashpanchikuna kushikushpa kawsanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Tata Diospa rimananta kuyashpanchikuna tutapi diyapi chay rimananpi yuyaykushpa kushikushpa kawsanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Chashna Tata Diospa rimananta kuyashpanchikuna yaku mañanpi tarpudu kaspishina allimata wiñanchisapa. Wayuchakunan tiempu aypata wayuchakuk kaspishina kanchisapa. Aypa allima pankayuk kaspishina kanchisapa. Chayrayku tukuy ima rurananchikunata allita ruranchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Chay mana alli rurak runakuna mana chashnachu kawsansapa. Paykunaka wayra pushanan kutadu murupa karapanshina kunanlla anchunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Chayrayku chay mana alli rurak runakuna Tata Diospa kastigunmanta mana kishpinkasapachu. Paykunaka Tata Diosta kasushpa kawsak runakunawan mana tantanakunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Tata Dios alli rurak runakunata kuydansapa alli ñanta purikshina allita rurashpa kawsanankunapa. Tukuy uchallikushpa kawsak runakunata Tata Dios sukaman kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Sukaman yuyani: ¿Imapatí Tata Diosta mana kasuk runakuna turbakunsapa? ¿Imapatí mana valekkunata yuyaykunsapa rurayta? ");
INSERT INTO qvsNT_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Tukuy allpapi sinchi kamachikukkuna awtoridarkuna Tata Diosta mana kasunayansapachu. Chashna mana kasunayashpankuna Tata Dios akllashkan sinchi kamachikukwan makanakuk tantanakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Tantanakushpa kaparishpa rimansapa: “Akuychi Tata Dios akllashkan kamachikuk runawan makanakuk. Akuychi paymanta kishpichinakuk amana kamachiwananchikunapana.” ");
INSERT INTO qvsNT_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Chashna rimaptinkuna sielupi kawsak Tata Dios paykunata asichinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Chaymanta Tata Dios rabyakushpa manchachinsapa. Sinchita piñakushpa willansapa: ");
INSERT INTO qvsNT_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Ñukami akllashkayni Sion urkupi sinchi kamachikukta churashkani tukuy layata kamachinanpa.” ");
INSERT INTO qvsNT_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kunanka ñuka willaykichi Tata Dios munananta. Payka willawashka: “Kanka wambraynimi kanki. Kantami churashkayki sinchi kamachikuk kanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Chayrayku tukuy llaktakunata mañaway. Ñukami allpa kuchun mañanta kushkayki chaypi kamachikunaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Sinchi kamachikuk kashpayki suk runakuna mana kasushunayaptinkuna kastigankisapa. Yerumanta ruradu varawan metomanta ruradu ollata pakikshina paykunata kastigankisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Chashna Tata Dios wambranta willaptin Kankuna sinchi kamachikukkuna, awtoridarkuna, willanaynita allita entiendiychi. Yachachinaynita yachakuychi. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Tata Diosta manchashpa sirviychi. Kushikushpa payta kuyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Tata Dios kunanllami sinchita rabyakun. Chayrayku chukchukushpa ñawpakninpi kumurayaychi ama Tata Dios rabyashpa mana allita rurashkaykichirayku wañuchishunaykichipa. Tata Dios amachawananchikunata yachashpanchikuna kushikushpa kawsanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","A, Tata Dios, aypa chikniwak runakunami tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Chikniwashpa ñukawan makanakunayansapa. Chay runakuna ñukapa rimansapa: “Tata Dios manami yanapankachu.” ");
INSERT INTO qvsNT_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Chashna rimaptinkunapish, Tata Dios, kanmi arkanashina arkawanki. Kanmi kuyawashpa yanapawashpa animuchiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ñuka Tata Diosta sinchita roygaptini payka sielupi kawsananmanta yanapawan. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Sirishpayni kunanlla puñuni. Puñushkaynimanta kashkan rikchamuni Tata Dios yanapawaptin. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Aypa chikniwak runakuna tukuy maypi wañuchiwanayaptinkunapish Tata Dios yanapawaptin mana manchakunichu. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","A, Tata Dios, yanapawashpayki favorninipi atarimuy. Chikniwak runakunamanta salvaway. Kanmi chikniwak runakunata makashkankisapa. Tukuy mana alli rurak runakunapa armankunata wakllichishkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Kanmi, Tata Dios, ñukaykunata salvawankisapa. Chayrayku kanta kuyaptinikuna yanapawaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","A, Tata Dios, kanmi allita amachawanki. Chayrayku kanta roygaptini yanapaway. Sukaman llakiptini kanmi kushichiwanki. Chayrayku roygaptini llakichiwashpa uyariway. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Kankuna, chikniwak runakuna, ¿aykapikamantí llullakushpa chatawankichi? ¿Aykapikamantí mana kuskata yuyashpa llullakuyllata munankichi? ");
INSERT INTO qvsNT_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Allita yachaychi Tata Dios payllata kasushpa kawsak runakunallata yanapananta. Allita yuyaychi ñuka Tata Diosta roygaptini yanapawananta. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Chayta yachashpa manchakushpa chukchukuychi amana ashwanta uchallikunaykichipa. Sirishpaykichi kasillayashpa mana alli rurashkaykichita yuyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Chayta yuyashpa tukuy shunku Tata Diosta kuyashpa animalkunata altarpi wañuchiychi. Allita yachaychi amachashunaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Aypa runakuna rimansapa: Manami ni pi ñukanchikunata kushichiwanayanchisapachu. Chashna rimaptinkunapish kan, Tata Dios, ñukaykunata llakichiwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Aypa mikunayuk aypa upyanayuk runakuna sukaman kushikunsapa. Kan, Tata Dios, paykunamanta ashwanta kushichiwashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Kan kuydawaptiki mana manchakushpa sirishpayni kunanlla gustu puñuni. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","2","Kamachiwak Tatayni Dios, parlachiptini uyariway. Llakishpa roygaptini yanapaway. A, Tata Dios, kantami tukuy ima yuyanaynita parlachiyki. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","A, Tata Dios, unay unay parlachiptini uyariwanki. Pakarinanta ima munanaynita willayki. Chaymanta yanapawanaykipa shuyani. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","A, Tata Dios, runakuna mana allita ruraptinkuna sukaman piñakunki. Chayrayku mana alli rurak runakuna mana ñawpaknikipi kawsankasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Kikinkunalla kreyinakuk runakuna mana ñawpaknikipi kawsankasapachu. Mana alli rurak runakunata sukaman chikninkisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Llullakuk runakunata kulluchinkisapa. Allipi tukushpa chiknikuk runakunata wañuchikunayak runakunata chikninkisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","A, Tata Dios, kuyawashpa llakichiwaptiki ñuka atipani wasikipi yaykushpa tukuy shunku kuyaynikita. Akllashkayki wasikita yuyashpayni kuyayki. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","A, Tata Dios, alli rurak kashpayki yachachiway allita rurashpa kawsanaynipa ama chikniwak runakuna chatawanankunapa. Yanapaway allita rurashpa alli ñanta purikshina kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Chay chikniwak runakuna tukuy tiempu llullata rimansapa. Tukuy shunku mana allita yuyashpalla kawsansapa. Chashna sukaman uchasapa kashpankuna kicharidu asnak sepulturashinami. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","A, Tata Dios, chay runakunata kastigaysapa tukuy mana alli yuyanankuna nimapi tukunankunapa. Uchasapa kashpankuna mana kasushunayashkankunarayku ñawpaknikimanta paykunata karkuysapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ñukaykuna amachawanaykipasapa munashpaynikuna kushikunisapa. Kushikushpa kantanisapa kan, Tata Dios, amachawaptikisapa. Kanta kuyashpaynikuna kushikunisapa kan yanapawaptikisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Allita rurashpa kawsaptinikuna kan, Tata Dios, yanapawankisapa. Yanapawashpaykisapa suk arkanashina amachawankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","A, Tata Dios, ama rabyakushpa piñayawaychu. Ama rabyakushpa kastigawaychu. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","A, Tata Dios, mana fersasyukmi mallinakuni. Chayrayku llakichiway. Tukuy kuerpuynimi chukchukun. Chayrayku alliyachiway. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Manchakushpayni chukchukuni. A, Tata Dios, sukaman munani yanapawanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","A, Tata Dios, shamuy yanapawak. Kuyawashpayki wañuymanta salvaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Wañushpayni manana kay allpapi yuyashkaykinachu. Pampadu kashpayni manana atipashanachu alabaynikita. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Chayta yuyashpa sukaman wakakushpa shaykuni. Tukuy tuta sukaman wakakuptini almadayni ñawini illiwan ñuyun. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Chikniwak runakuna sufrichiwaptinkuna wakakuptini ñawini shaykushpa puyuyashka. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Kankuna, mana alli rurak runakuna, ñukamanta anchuychi. Sukaman llakiptini ñami Tata Dios uyariwashkana. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Oraptini Tata Dios uyariwashkana. Tukuy mañashkaynita ñami Tata Dios almitiwashkana. ");
INSERT INTO qvsNT_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Chayrayku chikniwak runakuna pinkakushpa turbakunkasapa. Tata Dios yanapawaptin pinkakuywan raslla kallpankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","2","A, Señor Tatayni Dios, kantami maskayki amachawanaykipa. Sufrichiwak runakunamanta salvaway. Paykunamanta kishpichichiway. Mana amachawaptikika llullakushpa chatawashpa pumashina wakllichiwanmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","A, Tata Dios, ¿ima mana allita rurashpatí uchallikushkani? ");
INSERT INTO qvsNT_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Purikmasini allita rurawaptin manami chiknishkanichu. Chikniwak runata mana nimanachiwaykaptin manami payta sufrichishkanichu. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Payta sufrichishka kaptinika ñukatapish sufrichiwachun. Payta chiknishka kaptinika ñukatapish mana nimatashina kawawachun. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","A, Tata Dios, piñakushpa atariy. Favorninipi chikniwak runakunata tinkuysapa. Kanmi rimashkanki mana alli rurak runakunata kastiganaykipa. Chayrayku favorninipi llukshiy. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Tukuy llaktakunata tantanachishpayki paykunata kamachiysapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","A, Tata Dios, kanmi tukuy llaktakunapi kawsak runakunata willanki allitachu mana allitachu rurashkasapa nishpa. Chayrayku allita rurashpa kawsashkaynirayku willaway allita rurashkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","A, Tata Dios, kanmi allillata rurak kanki. Tukuy runakunapa yuyayninta riksinki. Chayrayku tukuy mana alli rurak runakunata kulluchiy. Ñukaykuna alli rurak runakuna kaptinikuna sinchichiwashpa yanapawaysapa ama uchallikunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Altu sielupi kawsak Tata Dios tukuy alli shunkuyuk runakunata amachan. Chayrayku ñukata amachawan. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Tata Dios kuskanpi kastigakun. Tukuy tiempu tukuy mana alli rurak runakunata kastigansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Tata Dios alli rurak kaptin payta alabasha. Altu sielupi kamachikuk Tata Diosta yuyashpa payta kuyashpa himnokunata kantasha. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","A, Tata Dios, ashwan sinchi kamachiwakninikunami kanki. Kanmi tukuy allpapi kamachikunki. Sieluta kawashpaynikuna yachanisapa sukaman tukuy laya atipak kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Taksha wambrakuna ñuñukuk wambrakuna alabashuptinkuna riksichinakunki tukuy laya atipak kanaykita. Chaymanta chiknishuk runakunata mana kasushunayak runakunata upallayachinki. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Rurashkayki sieluta kawashpayni chaypi churashkayki killata luserukunata kawashpayni ");
INSERT INTO qvsNT_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","yuyani rurashkayki runakuna mana nima kanankunata. Chashna mana nima kaptinikuna ¿imapatí yuyawashpa llakichiwankisapa? ");
INSERT INTO qvsNT_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Ñukaykunata rurawashkankisapa yaka angelkunashina yachakta. Angelkunamanta ashwanta kuyawankisapa kushichiwankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Alli yachakta rurawashpaykisapa willawashkankisapa rurashkaykikunata kamachinaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Ovejakunata torokunata sachapi mana wiwa animalkunata kuwashkankisapa ñukaykunapa kanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Sielupi pawak animalkunata yakupi kawsak challwakunata tukuy ima yakupi tiyakta churashkankisapa kamachinaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","A, Tata Dios, ashwan sinchi kamachikukninikunami kanki. Tukuy allpapi kamachikunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","A, Tata Dios, mallinakuni karuyawashkaykita. Llakiptini mallinakuni mana yanapawanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Mana alli rurak runakuna sukaman kikinkunalla kreyinakushpankuna rabyakushpa alli rurak runakunata sufrichinsapa. Chashna kreyinakushpankunapish kikinkuna churashkankuna trampallapi urmankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Mana alli rurak runakuna kikinkunapa munanankunallata rurashpa kawsansapa. Tukuy layata kikinkunallapa munashpa Tata Diosta maldisishpa washanchansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Chashna washanchashpa kikinkunalla kreyinakushpa rimansapa: “Manami Tata Dios tiyanchu. Manami ni pi ruranaynikunata tapuwankasapachu.” ");
INSERT INTO qvsNT_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","A, Tata Dios, chay runakuna sukaman mana allita rurashpa chashnalla tukuy tiempu kawsansapa. Kanpa, Tata Dios, kamachikunaykita mana nimatashina kawansapa. Chikninakukmasinkunata mana kreyishpankuna rabyachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Yuyansapa mana ni pi atipananta chashna kawsanankunamanta michayta. Rimansapa mana nimapi sufrinankunata. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Chaykunata rimashpa sukaman maldisikunsapa llullakunsapa llullachikunsapa. Runamasinkunata rabyachishpa sufrichinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Llaktankuna washapi mana nimanachik runata chapashpa pakallalla wañuchinsapa. Mana amachanakuy atipak runakunata kawashpa shuyansapa wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Chay mana alli rurak runakuna pumakunashina machayninpi pakakudunkunamanta mana amachanakuy atipak runakunata chapansapa. Chapashpa shuyansapa imay orami apinkasapa nishpa. Chashna apishpa munashkankuna layata paykunata ruransapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Pumakunashina pakchanakushpa takshayansapa mana amachanakuy atipak runakunata apinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","A, Tata Dios, chay runakuna yuyansapa kan mana alli ruranankunata kunkanaykita. Yuyansapa uyaykita wichkashpa mana kawanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","A, Tata Dios, atarimuy. Yanapawaysapa. Ama sufrik runakunata kunkaychu. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","A, Tatayni Dios ¿imapatí mana alli rurak runakuna burlata rurashunkisapa? Paykunaka yuyansapa kan mana kastigakunaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","A, Tata Dios, kikiki kawashkanki sakra mana allikunata ruraptinkuna. Chayrayku paykunata kastiganayki tiyan. Chashna kastigakuk kaptiki mana amachanakuy atipak runakuna kanta maskashunkisapa amachakunaykipa. Kanmi tukuy wakcha runakunata yanapankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","A, Tata Dios, chay mana alli rurak runakunata kastigaysapa amana sufrichikushpa kawsanankunapa. Tukuy paykunata kastigaysapa kullunankunakaman. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Kanmi, Tata Dios, mana tukuyniyukta kamachikunki. Mana kreyishuk runakunata llaktankunamanta wishchunkisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","A, Tata Dios, mana kikinlla kreyinakushpa kuyashuk runakuna roygashuptinkuna uyarinkisapa. Paykunata animuchishpa yanapankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","A, Tata Dios, tukuy wakchakunata sufrik runakunata yanapaysapa wañuy yachak runakuna amana runamasinkunata sufrichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Ñukaka Tata Diostami shuyani amachawananpa. Yankamantami chikniwak runakuna willawansapa: “Pawak animalkuna urkukunaman manchakushpa nitikukshina nitikuy.” ");
INSERT INTO qvsNT_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Paykunaka willawansapa: “Mana alli rurak runakunata kawaychi. Paykunaka wachinkunata balista waskapi churashpa balistankunata pataransapa. Pakakudunkunamanta alli rurak runakunata shitansapa.” ");
INSERT INTO qvsNT_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Willawansapa: “Mana awtoridarkuna tiyaptin ¿imatatí alli rurak runakuna rurankasapa?” ");
INSERT INTO qvsNT_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Chashna willawaptinkunapish ñuka yachani Tata Dios wasinpi kawsananta. Sielupi tiyananmanta tukuy runakunata allita kawaykan. ");
INSERT INTO qvsNT_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Tata Dios alli mana alli rurak runakunata kawan. Wañuchikunayashpalla kawsak runakunata Tata Dios tukuy shunkunmanta sukaman chikninsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Tata Dios mana alli rurak runakunapa sawanpi asufriwan rawraykak ninata tamyachinka. Wayrawan chay ninata rawrachinka chay sakra runakunata rupachinankunapa. Chashna rupachishpa kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Tata Dios alli rurakmi. Ñukanchikuna allita rurashpa kawsaptinchikuna kuyawanchisapa. Tata Diosta tukuy shunku kuyashpanchikuna payta uya uya kawashunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Kawananchi sielu yachachiwanchisapa Tata Dios tukuy laya atipak kananta. Sieluta kawashpanchikuna yachanchisapa Tata Dios tukuy layata rurashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Diyan diyan sieluka yachachiwanchisapa Tata Dioslla tukuy layata rurashkanta. Tutapipish sieluka yachachiwanchisapa Tata Dios alli yachak kananta. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Sielu mana rimakuptin uyarishpanchikunapish allita yachanchisapa Tata Dios tukuy layata rurashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Tukuy allpa kuchun mañanpi kawsak runakuna sieluta kawashpa yachanchisapa Tata Dios tukuy layata rurashkanta. Payka intita sielupi wasinpishina churashka. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Intika suk novioshina kasaranan diya kushikushpa wasinmanta kallpan. Premyunta chaskinanpa kallpak runashina kushikushpa llukshin. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Intika llukshimunan ladumanta yaykunan ladukaman purin. Mana ni pi rupayninmanta kishpinchu. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Tata Diospa kamachikunankuna sukaman allimami. Sampayaptinchi animuchiwanchi. Paypa rimananka mana llullachiwanchisapachu. Mana yachaptinchikuna yachachiwanchisapa alli yachak kananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Tata Diospa rimanan allima kashpa kushichiwanchisapa. Paypa kamachikunankuna sukaman allima kashpa lampara llipyakshina lusichiwanchi yachananchikunapa allita rurashpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Tata Diosta kuyashpanchikuna mana tukuyniyukta allita rurashpa kawsanchisapa. Tata Dios kuskanpi mana llullakushpa kamachiwanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Paypa rimananka kurimanta ashwan allimami. Amu mishkinta munananchikunamanta Tata Diospa rimananta ashwanta munanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","A, Tata Dios, kamachikunaykikuna yachachiwan ama uchallikushpa kawsanaynipa. Chaykunata kasuptini sukaman yanapawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Mana ni pi kikinmanta yachanchu uchallikushkanta. A, Tata Dios, mana yuyashpa uchallikuptini perdonaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Yanapaway ama kikinilla kreyinakunaynipa. Ama munaychu kreyinakushpa kawsanaynipa. Yanapawaptiki mana uchayuk runa kasha amana uchallikunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","A, Tata Dios, kanmi amachawashpa uchaynimanta salvawanki. Chayrayku munani tukuy rimanayni tukuy yuyanayni kushichishunaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Tata Dios ovejakuna kuydakshina kuydawan. Chayrayku mana nima illawanchu. ");
INSERT INTO qvsNT_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Chashna kuydawashpa allima pastukunapi samachiwan. Chuya likidu ñukñuk yakukunaman pushawan. ");
INSERT INTO qvsNT_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Chashna kuydawashpa animuchiwan. Kuska ñankunata pushawan riksinaynipa alli kuydakuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Kan, Tata Dios, kuydawaptiki tuta likidu urku sikinkunata puriptinipish mana wañuyta manchakunichu. Kan, Tata Dios, ñukawan kaptiki varaykiwan bastonnikiwan kuydawaptiki kushikushpalla kawsasha. ");
INSERT INTO qvsNT_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Chikniwak runakuna tiyaptinpish aypa allima mikunata rurapashkanki. Kuyawashpa mishkilla asnak wirata umaynipi tallishkanki sukaman kushichiwanaykipa. Chaymanta upyakunayni kopata untachikshina sukaman yanapawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","A, Tata Dios, wañunayni diyakaman sukaman kuyawashpa llakichiwanki. Chayrayku wasikipi mana tukuyniyukta kawsasha. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Tata Dios lusninishina kashpa chikniwak runakunamanta salvawan. Chashna salvawaptin mana ni pita manchanichu. Tata Dios amachawaptin mana ni pita manchashachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Chay chikniwak mana alli rurak runakuna tantanakunsapa makawashpa wañuchiwanankunapa. Chashna wañuchiwayta yuyashpankunapish mana atipansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Chay aypa chikniwak runakuna wañuchiwanayashpa chawpichawaptinkunapish mana paykunata manchanichu. Sukaman makawanayaptinkunapish mana turbakunichu. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ñuka Tata Diosta suk imallata mañashkani. Sukaman munani tukuy diya paypa wasinpi yaykuyta payta kuyanaynipa. Chaypi sukaman munani kuyawananta yuyayta. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Sukaman sufrishpa kawsaptini Tata Dios amachawashpa yanapawanka. Chikniwak runakunamanta wasinpi pakawanka. Manllayba rumi sawanpishina churawanka ama ni pi wakllichiwananpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Chashna Tata Dios salvawaptin atipani chikniwak runakunata kallpachiyta. Chaypina payta agradesishpayni paypa wasinpi ofrendakunata kusha kuyanaynipa. Kushikushpa himnokunata Tata Diosta kantasha. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","A, Tata Dios, kanta roygaptini uyariway. Llakichiwashpa yanapaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Kikini yuyanakushpa rimani: “Tata Diosta roygasha yanapawananpa.” Chayrayku, Tata Dios, roygayki yanapawanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","A, Tata Dios, yanapaway. Ama piñakushpa karkuwaychu. Kanlla atipanki salvawayta. Ama sapallaynita sakiwaychu. Kanmi kanki salvawak Tatayni Dios. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Tatayni mamayni sakiwaptinkunapish kan, Tata Dios, mana sakiwashpa yanapawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","A, Tata Dios, chikniwak runakuna makawanayaptinkuna yanapaway allita rurashpa alli ñanpi purikshina kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Chay sakra runakuna llullakushpa chatawansapa mana alli rurak kanaynita. Chayrayku ama munaychu munashkankunata rurawanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Chashna chatawaptinkunapish ñuka allita yachani tukuy diya kan, Tata Dios, kuyawashpayki yanapawanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Chayrayku akuychi Tata Dios yanapawananchikunata shuyaypachi. Valorchinakushpa ama sampayaypachichu. Ariya, Tata Dios yanapawananchikunata shuyaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Tukuy oras ñuka Tata Diosta willasha alli rurak kananta. Mana shaykushpa Tata Diosta alabasha. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Tata Dios yanapawaptin sukaman kushikuni. Kankuna, alli modoyuk runakuna, chayta yachashpa kushikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Tata Dios sukaman tukuy laya atipak kaptin akuychi tantalla payllata alabaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Tata Diosta yanapawananpa mañaptini payka uyariwashka. Uyariwashpa yanapawashka amana manchakunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Tata Diosta shuyashpanchikuna yanapawananchikunapa sukaman kushikunchisapa. Tata Dios yanapawaptinchikuna mana pinkakunchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Ñuka sukaman sufrishpayni Tata Dios yanapawananpa roygaptini uyariwashka. Yanapawashpa llakidu kashkaynimanta kushichiwashka. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Tata Diospa angelninkuna tukuy Tata Diosta kasuk runakunata amachansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Kankuna mishkik mikunata mallikshina Tata Diosta kuyaychi yachanaykichipa alli rurak kananta. Tata Dios yanapashunaykichita yachashpaykichi sukaman kushikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Kankuna, Tata Diosta kasuk runakuna, payta kuyaychi. Chashna kuyaptikichi manami nima illapushunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Pumakuna sinchi kashpankunapish yarkansapa. Chashnapish kaptin ñukanchikuna Tata Diosta kasuptinchikuna aypa allikunata kuwanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Wambraynikuna, shamuychi uyariwak. Kunanka yachachiykichi imashnami Tata Diosta kuyankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Kunanka tapuykichi: ¿Munankichichu unayta kawsayta? ¿Munankichichu kushikushpalla kawsayta? ");
INSERT INTO qvsNT_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Chashna kawsanayashpaykichika ama munaychichu mana allikunata rimayta nima llullakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Mana alli ruranaykichita sakishpa allikunallata ruraychi. Tukuy piwan allillapi kushikushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Allita rurashpa kawsaptikichi Tata Dios kuydashunkichi. Roygaptikichi yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Chaymanta Tata Dios tukuy mana alli rurak runakunata chikninsapa. Paykunata kulluchinkasapa amana ni pi paykunata yuyanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Allita rurashpa kawsaptinchikuna Tata Diosta roygaptinchikuna payka yanapawanchisapa. Llakishpa sufrishpa kawsaptinchikuna payka yanapawashpanchikuna kushichiwanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Tukuy uchanchikunata wananayashpa llakiptinchikuna Tata Dios llakichiwashpanchikuna perdonawashpanchikuna kushichiwanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Allita rurashpa kawsashpanchikunapish sukaman padesinchisapa. Chashna padesiptinchikunapish Tata Dios yanapawanchisapa kushikushpalla kawsananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Tata Dios yanapawashpanchikuna amachawanchisapa ama chikniwakninchi runakuna tullunchikunata polvonankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Chaymanta sakra runakuna runamasinkunata wañuchinayashpa kikinkunalla wañuyta maskaykansapa. Tata Dios tukuy alli rurakta chiknik runakunata kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Chaymanta Tata Diosta kasushpa kawsaptinchikuna payka llakichiwashpanchikuna salvawanchisapa. Tata Dios amachawananchikunata munaptinchikuna payka mana kastigawanchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Runakuna mana allita ruraptinkunapish ama turbakuychu. Chay mana alli rurak runakunata kawashpa ama paykunashina kawsanayaychu. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Chay runakunata Tata Dioska utka kastigankasapa. Kastigaptinkuna tipidu kiwashina tukunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Tata Dios yanapashunaykita yachashpa allita rurashpalla kawsay. Kay allpapi kawsashpaykira Tata Diosllata allita kasushpa kawsay. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Payta tukuy shunku kuyashpa kawsay. Chashna payta kuyaptiki alli munanaykita almitishunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Tata Diosta kuyashpa payta willay munananta ruranayanaykita. Chashna payta willaptiki yanapashunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Tata Dios yanapashuptiki tukuy runakuna alli ruranaykita lustashina kawankasapa. Alli ruranaykita ruraptiki inti llipyanantashina kawankasapa paykunapish yachanankunapa allita rurashpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Allita rurashpa mana turbakushpa Tata Dios yanapashunanta shuyay. Suk runakuna tukuy imayuk kaptinkuna ama llakishpa rabyakuychu. Mana allita yuyaykuptinkuna ama rabyakuychu. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ama rabyakushpa piñakuychu. Ama munaychu turbakushpa mana allita rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Tata Dios tukuy mana allita rurak runakunata kastigankasapa. Chaymanta Tata Dios yanapashunanta shuyaptiki payka yanapashunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Tata Dios tukuy runakunata yachachiwanchisapa. Yanapawanchisapa paypa munananta rurananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Mana allita ruraptinchikuna Tata Dios makinchikunamanta apiwakninchishina yanapawanchisapa ama uchallikushpa kawsananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Wayna kashkaynimanta ñami viejuyashkanina. Manami kawashkanichu Tata Dios alli rurak runakunata sakiptin. Paykunapa wambrankunapish mana nimata mañakushpachu kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Alli rurak runakuna kashpanchikuna tukuy oras llakichikushpa runamasinchikunata yanapanchisapa. Chay runakunapa wambrankunaka tukuy pita sukaman kushichinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Chayrayku mana alli rurashkaykimanta wanashpa allikunallata rurashpa kawsay. Chashnarami Tata Dios mana tukuyniyukta yanapashunki allita rurashpa kawsanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Tata Dios alli rurak runakunata kuyansapa. Payta kasushpa kawsaptinchikuna mana sakiwanchisapachu. Chaymanta mana alli rurak runakunata kulluchin. Tukuy wambrankunatapish kulluchin. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Tata Dios animuchiwanchisapa. Chikniwakninchi runakunamanta amachawanchisapa. Llakishpa sufriptinchikuna yanapawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Chashna Tata Dios amachawaptinchikuna allpa chukchukushpa waklliptinpish mana manchakushunchisapachu. Urkukuna manllayba kochapi sumiptinkunapish mana manchakushunchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Yakukuna olasyashpa kaparikuptinpish urkukuna chukchukuptinkunapish mana manchakushunchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Suk yaku kallpashpa kushichiwanchisapa Tata Dios chay yakushina yanapawashpanchikuna kushichiwanchisapa. Kamachiwakninchikuna Tata Dios ñukanchikunapi kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Chashna Tata Dios ñukanchikunapi kawsashpa sufriptinchikunapish tukuy diya yanapawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Chayta kawashpa mana Tata Diosta kasuk runakuna manchakushpa kaparinkasapa. Sinchi kamachikukkuna sukwan sukwan makanakushpa kawsansapa. Tata Dios rimakuptin tukuy llaktakuna wakllichinakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Tukuy laya atipak Tata Dios ñukanchikunawanmi kawsan. Jakobopa Tata Diosninmi amachawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Payka almirana milagrukunatami rurashka. Shamuychi kawak kay allpapi rurashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Kuchun mañan allpapi kamachikushka amana makanakunankunapa. Ñami balistankunata pakishkana. Makanakunankuna lansankunata ñami paki pakina rurashka. Makanakunankuna karrunkunata ñami rupachishkana. ");
INSERT INTO qvsNT_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Chayrayku Tata Dios willawanchisapa: “Kasillayaychi. Riksiwaychi sinchi kamachikuk Tata Dios kanaynita. Yachaychi tukuy allpapi tukuy llaktakunata sinchita kamachinaynita.” ");
INSERT INTO qvsNT_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Tukuy laya atipak Tata Dios ñukanchikunawanmi kawsan. Jakobopa Tata Diosninmi amachawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","A, Tata Dios, kuyawashpayki llakichiway. Llakichiwashpayki uchallikushkaynimanta perdonaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Kuyawashpayki mana alli rurashkaynimanta perdonawashpa mayllaway. Tukuy uchaynikunamanta pichaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Allita yachani kanta mana kasunayashpayni uchallikushkaynita. Uchallikushkaynita mana atipanichu kunkayta. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","A, Tata Dios, uchallikushpayni mana allikunata rurashpayni kanta mana kasunayashkaykichu. Chashna mana kasunayashpayni rabyachishkayki. Uchallikushkaynirayku kastigawanayki tiyan. Kan kastigawashpayki allininpi kastigawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Nasishkaynimantapacha mana alli rurakmi kani. Mamaynipa wiksan ukumantapacha uchasapami kani. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","A, Tata Dios, kanka alli shunkuyuk runata kuyanki. Shunkuynipi allita yachachiwashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Uchaynikunamanta pichaway ñawpaknikipi chuya chuya rikurinaynipa. Mana alli rurashkaynimanta mayllaway. Chashna mayllawaptiki yurak puyushina kiparisha allita rurashpa kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","A, Tata Dios, kushichiway. Kastigawashkaykimanta kashkan kushichiway. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Amana uchaynita yuyaynachu. Mana alli rurashkaynita kunkay. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","A, Tata Dios, uchasapa yuyayninita pichay. Yanapaway kanta kuyashpa allita rurashpa kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","A, Tata Dios, ama ñawpaknikimanta karkuwaychu. Ama Espirituykita kichuwaychu. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Perdonawashpa kashkan kushichiway. Chashna kushichiwashpayki yanapaway allita rurashpa kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Chashna yanapawaptiki mana kasushunayak runakunata rimanaykita yachachisha munanaykita rurashpa kawsanankunapa. Chashna yachachikuptini uchasapa runakuna uchankunata wanashpa kasushushpa kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Mana alli yuyayuk runakuna yuyansapa Tata Dios mana tiyananta. Chashna yuyashpa uchallikushpa wakllichinakushkasapa. Uchallikushpa kawsashpankuna manana allikunata rurayta atipansapanachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Anak sielumantapacha Tata Dios tukuy runakunata kawamunsapa ichará maykan alli yuyayuk payta kasunayan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Chashna Tata Dios alli rurak runakunata maskashpapish mana niman suk alli rurak runata tarinchu. Tukuy runakuna uchallikushpa wakllichinakushkasapa. Mana ni pi alli rurak tiyanchu. Manami niman suk tiyanchu. ");
INSERT INTO qvsNT_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Chay mana alli rurak runakuna mana allikunata yuyaykunsapa. Tata Diosta mana kasunayashpankuna payta kuyakmasinikunata chiknishpa sufrichinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Chayrayku mana manchakuna oras kaptinpish chay mana alli rurak runakuna manchakushpa chukchukunkasapa. Tata Dios kastigashpa karkuptinkuna sukaman pinkakunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Sukaman munani Tata Dios tukuy israel runakunata kuyawashpanchikuna chikniwakninchi runakunamanta salvawananchikunapa. Tata Dios llakichiwaptinchikuna tukuy Jakobopa mirakninkuna israel runakuna kushikushunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","A, Tatayni Dios, roygaptini uyariway. Ama nimatashina royganaynita uyariychu. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","3","A, Tata Dios, uyariwashpa yanapaway. Llakishpayni roygayki. Chikniwak runakuna rimakuptinkuna mana alli rurak runakuna kaparikuptinkuna uyarishpa sukaman manchakuni. Paykunaka chikniwashpa sufrichiwansapa. Sukaman piñakushpa makawanayansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Chayta kawashpa manchakuptini shunkuyni sinchita waktanakun. Wañuchiwanankunata yuyashpa sukaman manchakuni. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Chashna sukaman manchakushpayni chukchukuykani. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Chayta yuyashpa rimani: ¿Imapatí mana urpayshina rikrayuk kani? Rikrayuk kashpaynika nitikushpa pawayman samak rinaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Pawashpayni karuta riyman. Chakidu pampapi kipariyman chaypi kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Chikniwak runakuna sinchita sufrichiwaptinkuna Tata Diosta sukaman mañasha sinchi wayramantashina amachawananpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Manami chikniwak runachu sufrichiwashka. Chikniwak runa sufrichiwaptinka mana nimachu kanman. Sufrichiwak runamanta ñukaka pakakuyman. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Chay sufrichiwak runaka kuyanakushpa purikmasinimi kashka. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Paywanmi Tata Diospa wasinpi yaykushpaynikuna parlak kanisapa. Paywanmi kushikushpa aypa runakunapa chawpinkunapi purik kanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Tukuy chikniwak runakuna mana yuyashkankuna oras wañuchunsapa. Mana alli rurak kashpankuna raslla wañuchunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Ñuka sufrishpayni Tata Diostami roygasha. Roygaptini yanapawanka. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Pakarinanta chishita tutata wakaptini Tata Dios llakichiwashpa yanapawanka. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Chikniwak runakunawan makanakuptini ama wañuchiwanankunapa Tata Dios yanapawanka. Paykuna aypa kaptinkunapish yanapawanka. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Paykuna mana Tata Diosta manchashpa mana allikunallata rurashpa kawsansapa. Chayrayku mana tukuyniyukta sinchi kamachikuk Tata Dios chikniwak runakunata kastigashpa upallayachinka. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Paykunaka kuyanakukmasinkunawan makanakunsapa. Allimata kawsanankunapa parlashkankunawasha kunkashpa chikninakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Mishki shimi tukushpa parlansapa. Chashna parlashpankunapish makanakuyllata yuyansapa. Mishki shimi tukushpa parlashpankunapish chikninakushpalla kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Akuychi tukuy yuyananchikunata Tata Diosta willaypachi. Chashna willaptinchikuna payka yanapawashunchisapa allillata rurashpa kawsananchikunapa. Tata Diosta kasuptinchikuna payka yanapawanchisapa ama uchallikunanchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","A, Tata Diosnini, wañuchikuk llullakuk runakuna mana unaytachu kawsankasapa. Paykunata kulluchinkisapa. Chashnapish kaptin ñukaka yachani yanapawanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","A, Tata Dios, sukaman llakishpayni kaparikuptini uyariway. Roygaptini uyariwashpa yanapaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Kay allpapi kuchun mañanpi kashpaynipish manana yachashpa imatami rurasha nishpa kanta roygayki. Roygaptini manllayba rumi sawanpishina churawashpayki chikniwak runakunamanta salvaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","A, Tata Dios, kanmi amachawanki. Amachawashpayki allima pirkashina chay chikniwak runakunamanta arkawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Tukuy tiempu wasikipi kawsanayani wallpa wawankunata rikran sikipi amachakshina kuydawanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","A, Tata Dios, kanmi tukuy promesakushkaynita uyarishkanki. Chayrayku yanapawashkanki. Kanka tukuy kuyashushpa kawsak runakunata yanapankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","A, Tata Dios, kamachikuk kaptini yanapaway sukaman unayta kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Yanapaway allita kamachikunaynipa. Kuyawashpayki ama shaykushpa kuydaway. ");
INSERT INTO qvsNT_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Chashna yanapawaptiki tukuy tiempu kanllata alabashpayni kawsasha. Tukuy diya promesakushkaynita rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Tata Dios tukuy israel runakunata kuyashpa yanapansapa. Tukuy shunku allita yuyashpa kawsak runakunata yanapansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Chashna Tata Dios yanapakuk kaptinpish yaka yaka mana allita rurashpa mitkakukshina urmanayarkani. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Kikinkunalla kreyinakuk tukuy imayuk mana allita rurashpa kawsak runakunata kawarkani. Ñukapish paykunashina kanayashpayni yakallapa uchallikurkani. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Paykunaka wañuyta mana manchansapachu. Mana ni unkushpa shaykunsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Mana yachansapachu imami llakina nishpa. Mana runamasinkunashinachu sufrishpa kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Sukaman kikinkunalla kreyinakushpankuna sufrichikushpalla kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Tukuy layayuk kashpankuna tukuy mana alli munanankunallata ruransapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Tukuy pita mana nimatashina kawansapa. Mana pinkakushpa kikinkunalla alabanakunsapa. Tukuy pita jorachinsapa mana allita ruranankunapa sufrichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Sukaman mana allita rurashpankuna willansapa Tata Diosta mana kasunayanankunata. Runakunatapish washanchansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Chayrayku runamasinkuna paykunata alabansapa. Paykunata sukaman kreyinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Rimansapa: “Tata Dios mana alli rurananchikunata mana yachankachu. Sielupi kawsak Tata Dios mana nimata yachanchu.” ");
INSERT INTO qvsNT_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Chay mana alli rurak runakuna mana nimapi sufrishpankuna kullkiyansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Chayta kawashpa yuyarkani: “Llullakushpa alli shunkuyuk runa kawsaykani. Llullakushpa allillata rurashpa kawsaykani. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Tukuy oras sufrini. Tukuy diya Tata Dios kastigawan.” ");
INSERT INTO qvsNT_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","A, Tata Dios, chay mana alli rurak runakunashina chayta rimashpaynika kreyishukmasinikunata llullachiymansapa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Chayta yuyashpayni mana atiparkanichu entiendiyta imapami Tata Dios mana uchankunarayku kastigansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Tata Diospa wasinpi yaykushpaynira allita yacharkani Tata Dios chay mana alli rurak runakunata kastiganankunata. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","A, Tata Dios, kanmi chay mana alli rurak runakunata churashkanki llukchak ñanpishina uchallikuptinkuna kulluchinaykipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Raslla paykunata kastigankisapa. Paykunaka manchakuywan wañunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Paykuna llullachinakuptinkunapish kan, Tata Dios, kastigakunayki diya chayamuptin tukuy mana alli rurashkankunata tukuy runakunata kawachinkisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Chay mana alli rurak runakunata kawashpa sukaman turbakurkani. Turbakushpa sukaman llakirkani. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","A, Tata Dios, mana nima yachak kashpayni ñawpaknikipi suk animalshina karkani. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Chashna mana entiendiptinipish kanka kuyawashpa mana sakiwashkankichu. Makinimanta apiwashpa purichiwakshina yanapawashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Yachachiwashpa yanapawashkanki allita rurashpa kawsanaynipa. Chaymanta kawsanaykipi kushikushpa chaskiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Kanlla sielumanta yanapawanki. Kanwan kawsashpayni mana nima ashwanta munanichu. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Sukaman sampayaptinipish, kan tata Dios, mana tukuyniyukta kuyawashpa yanapawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","A, Tata Dios, mana kasushunayak runakuna wañunkasapa. Kanmi mana kreyishuk runakunata kulluchinkisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Paykuna mana kreyishuptinkunapish ñukaka kanwan tantalla kawsanayani. Kanmi, Tata Dios, amachawanki. Chayrayku runamasinikunata willashasapa alli rurak kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Tukuy allpapi kawsak runakuna, Tata Diosta kushichishpa kantaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Kushikushpa Tata Diosta kuyaypachi. Kushikuywan kaparikushpa ñawpakninman shamuypachi. ");
INSERT INTO qvsNT_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Tata Diosta riksiypachi sinchi kamachikuk kananta. Pay rurawashkanchikunarayku paypa wambrankunami kanchisapa. Paypa pastunpi ovejankunashina kanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Chayrayku Tata Diospa wasinman shamuypachi. Kushikushpa payta alabashpa kantukunata kantashpa punkunta yaykuypachi. Tata Dios sukaman yanapawaptinchikuna kushichishpa kuyaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Tata Dios alli rurak kaptin mana tukuyniyukta kuyakuk kaptin kushikushpa payta kuyaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Tata Diosta tukuy shunku kushichishpa alabasha. A, Tatayni Dios, ashwan sinchi kamachikukmi kanki. Tukuy laya atipak kashpayki sukaman allimami kanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Luswan sawa llachapawanshina wankunakushkanki. Sieluta warkudu llachapatashina churashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Kan tukuy layata kamachishpa sielupi wasikipa orkonninkunatashina manllayba kochapi sinchichishkanki. Puyukunata rurashkanki purinayki karrukunashina kanankunapa. Wayrashina maytapish rinayashpa rinki. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Sinchi wayra yachachiwanchisapa sukaman atipak kanaykita. Rawraykak ninakunapish kanllapami. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","A, Tata Dios, allpata allimata sinchichirkanki. ama churashkaykimanta kuyunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Yakukuna suk llachapashina allpata kirparkan. Yakukuna tukuy urkukunata kirparkan. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Kan, Tata Dios, yakukunata willaptiki kallparkansapa. Troynoshina rimakuptiki yakukuna uyarishpa nitikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Urkukunata llukashpa bajadakunata urayashpa rirkansapa maypicha willashkaykipi kanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Willarkankisapa amana chaymanta llukshinankunapa ama kashkan allpata kirpanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Chaymanta yaku pachyamunankunamanta urkukunata pasashpa yakuta kallpachishkanki atun yakukunaman rinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Chay yakukunamanta tukuy sachakunapi kawsak animalkuna yakukunsapa. Chayta upyashpa sachapi kawsak burrukuna yakunayayninta samachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Pawak animalkuna yaku mañankunapi wasichakunsapa. Kaspikuna ramanpi kantansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","A, Tata Dios, kanmi anak sielupi wasikimantapacha yakuta tamyachishpa sachakunata ñuyuchinki. Altumanta urmamuk yakuwan allpata saksachinki. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Chay yakuwan pastukunata wiñachinki animalkuna mikunankunapa. Runakuna tarpunan murukunata wiñachinki wayuchakuptin mikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Chay wayukunata mikunsapa fersasyuk kanankunapa. Vinuta upyansapa kushikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Kan, Tata Dios, chay yakullawan kaspikunata saksachinki. Libano partipi tarpushkayki sedrukunatapish saksachinkisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Chay kaspikunapi taksha pishkillukuna wasichakunsapa. Pino kaspikunapi garsakuna kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Altu urkukunata kabrakunapa rurashkanki. Rumikuna sikinpi achunikuna pakakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Killata rurashkanki yachanaynikunapa ima laya tiempumi nishpa. Intipish yachan imay orasmi urkukunapi chinkanka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Chaymanta yana llachapatashina mantanki tutayananpa. Tutayaptin sachapi animalkuna llukshinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Pumakuna mana mikunankunata tarishpa kaparinsapa. Tata Diosta mañansapa mikunankunata kunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Inti kashkan llukshimuptin machayninkunapi sirik kutinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Chashna diyayaptin ullkukuna trabajunkunaman rinsapa. Tutayanankaman trabajansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","A, Tata Dios, rikchak layata rurashkanki. Kay allpaka tukuy rurashkaykiwan untami. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Allpapi tiyan manllayba kocha. Chay kochapi mana yupaypa atun animalkuna taksha animalkuna tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Chay manllayba kochapi barkukuna purinsapa. Yaku ukupi manllayba manchanapa animal kawsan chaypi pukllananpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","A, Tata Dios, tukuy chay animalkuna kanta shuyashunkisapa mikunankunata munashkankuna oras kunaykipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Kan, Tata Dios, mikunankunata kunkisapa. Chashna kuptiki chay animalkuna apinsapa. Paykunata kuptiki munashkankunawan saksansapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Chay animalkunata manana yanapaptiki manchakunsapa. Manana kawsanankunapa samayta kuptiki wañunsapa. Usushpa polvo tukunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Munashpayki kashkan kawsachinkisapa. Chashna kawsachikushpa allichanki allpa kashkan allima rikurinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Mash uyariwaychi. Tata Dios mana tukuyniyukta kamachikun. Tukuy rurashkanta kawashpa sukaman kushikun. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Tata Dios munaptin allpa chukchukun. Tata Dios urkukunata llankaptin kusninsapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ñuka chaykunata kawashpa wañunayni diyakaman kantukunata kantashpa Tata Diosta kushichisha. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Allita yuyashpayni munani Tata Diosta kushichiyta. Paymi ñukata kushichiwan. ");
INSERT INTO qvsNT_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Kushikushpa rimani: Allpamanta tukuy ucha rurak runakuna chinkachunsapa. Mana alli rurak runakuna amana kawsachunsapanachu. Ñukaka Tata Diosta tukuy shunku kuyashpa alabani. Munani tukuy runakuna Tata Diosta alabanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","A, Tata Dios ¿imashnatí wayna runa atipanman mana uchallikushpa kawsayta? Waynaka rimanaykita kasushpa mana uchallikushpa kawsanka. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ñuka tukuy shunku yanapawanaykipa munani. Yanapaway kamachikunaykikunata kasushpa kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Tukuy rimanaykitami tukuy shunku allita kasushkani ama uchallikushpa kanta rabyachinaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","A, Tata Dios, kanta sukaman alabayki. Kamachikunaykikunata yachachiway. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Tukuy yachachiwanaykita ñukapish runamasinikunata parlachisha. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Aypa imakuna tiyapaptin kushikunaynimanta rimanaykita kasushpayni ashwanta kushikusha. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Tukuy rimanaykita yuyashpa kawsasha. Chayta yuyashpa allita rurashpa kawsashpayni ñannikipi purisha. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Rimanaykita yachashpayni sukaman kushikusha. Mana kutin kunkashachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","A, Tata Dios, sukaman yachachiwashkaykita kuyani. Tukuy diya chayta yuyashpa chishyani. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Tukuy kamachikunaykikunata ñami yachanina. Rimanaykika chikniwak runakunamanta ashwan alli yachaktami rurawashka. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Kamachikunaykikunata yuyashpa kawsashpayni rimanaykita yachachiwak runakunamanta ashwan allita entiendini. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Rimanaykita kasushpa kawsashpayni kamachikuk ansianukunamanta ashwan allita entiendini. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Tukuy mana alli ruranakunatami sakishkani rimanaykita kasushpa kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Rimanaykita kan yachachiwaptiki mana chaykunata sakishkanichu. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Rimanaykipi willawanki yanapawanaykipa. Rimanayki ñukñushina allimami. Chayrayku ñukñumanta ashwanta rimanaykita munani. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Rimanaykimi tukuy alli ruranakunata yachachiwashka. Chayrayku chay mana alli ruranakunata manana munaninachu rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Rimanaykika allima lamparashinami purinayni ñanpi allima lusshina. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Urkukunata kawashpayni tapunakuni: ¿Pití ñukata yanapawanman? ");
INSERT INTO qvsNT_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Tukuy kay allpata sieluta rurak Tata Diosmi yanapawanka. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Tata Diosmi kantapish yanapashunki ama uchata rurashpa urmanaykipa. Kuydashuk Tata Dios manami puñunchu. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Israel runakunata kuydak Tata Dios manami shaykunchu nima puñunchu. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Tata Diosmi allita kuydashunki. Tata Diosmi amachashunki. Laduykillapi kashpa yanapashunka. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Chashna Tata Dios amachashuptin mana diyapi rupay nima tutapi killa wakllichishunkachu. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Tata Dios yanapashunka ama nima wakllichishunanpa. Payka sukaman allita amachashunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Maymanpish riptiki tukuy tiempu Tata Dios yanapashunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Mash allita yuyaychi. Sukaman allimami wawkinchikunawan paninchikunawan kushikushpa kuyanakushpa kawsananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Tata Dios Aronta akllaptin saserdote kananpa wawkin Moiseska umanpi mishkilla wirata tallirkan. Chashna talliptin Aronka runamasinkunata yachachirkansapa sukwan sukwan kuyanakushpa kawsanankunapa. Chay wira tukuy saserdotekunapa barbankunata surushpa tukuy llachapankunata ñuyuchin. Chashnashina Tata Dios ñukanchikunatapish yachachiwanchisapa sukwan sukwan kuyanakushpa kawsananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Chashna kuyanakushpa kawsashpanchikuna Hermon urkupi serenushina kanchisapa. Sion urkuta ñuyuchik serenushina kanchisapa. Chashna kuyanakushpa kawsaptinchikuna Tata Dios kushikushpa sukaman yanapawanchisapa mana tukuyniyukta paywan tantalla kawsananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","A, Tata Dios, sukaman allita kawawashkanki yachanaykipa allitachu manachu ruraykani nishpa. Sukaman allita riksiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Kan yachanki tukuy ima ruranaynita. Kanmanta karupi kaptinipish tukuy yuyanaynita yachanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Maymanpish riptini maypipish samaptini tukuy ruranaynita yachanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Manara nimata rimaptinira kan yachanki imatami rimanayani nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Allita chawpichawashpa kuydawanki. Makikita ñukapi churanki yanapawanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Chaykunata yachashpayni sukaman almirani. Mana atipanichu entiendiyta imashnami chashna kuydawanki nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Chashna sukaman kuydawaptiki mana atipanichu Espirituykimanta pakakuyta. Ñawpaknikimanta mana atipanichu pakakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Sieluman riptinipish chaypimi kawawanki. Wañudukuna rinankunaman riptinipish chaypimi kawawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Inti llukshimunan partiman riptinipish inti yaykunan partipi manllayba kochaman riptinipish chaypipish kawawanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","Tukuy maymanpish riptini tariwanki. Alli ladu makikiwan apiwashpa purichiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Yuyaptini tutami pakawanka nishpa chaypipish tariwanki. Diya tutayaptinpish chaypimi tariwanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Sukaman tutayaptinpish mana kanmanta atipanichu pakakuyta. Tuta kaptinpish diyapishina kawakunki. Tutapi diyapi chashnallami kawakunki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Kanmi mamaynipa wiksanpi rurawashkanki. Tukuy kuerpuynita rurashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Chaykunata yachashpa almirashpa alabayki. Sukaman almirana layakunata rurashkanki. Allita yachani tukuy layata rurashkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Mamaynipa wiksanpi kuerpuyni wiñaptin mana ni pi kawawaptinpish kanmi kawawashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Kuerpuyni wiñaykaptin kawawashkanki. Libruykipi tukuy chaykunata killkashkanki. Manara kawsaptinira yachashkanki mashna diyakunatami kawsasha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","A, Tata Dios, favorninipa allimata yuyaykanki. Yuyanaykikunaka sukaman mana yupaypa layami. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Rurashkaykita yupanayashpayni playatashina mana atipanichu yupayta. Puñushkaynimanta atarishpayni kanllawan kani. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","A, Tata Dios, tukuy sakra mana alli rurak runakunata kastigaysapa. Chay wañuchiwanayak runakunata ñukamanta anchuchiysapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Washanchashuk runakunata yankamanta chiknishuk runakunata kastigaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","A, Tata Dios, chiknishuk runakunata chiknini. Mana kasushunayak runakunata mana nimatashina kawanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Tukuy shunku paykunata chikninisapa. Chay chiknishuk runakunata yuyani chikniwak runakuna kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","A, Tata Dios, allita kawaway yachanaykipa allitachu manachu kuyayki nishpa. Riksiway allitachu manachu yuyaykuni nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Kawaway ichará mana allikunata ruraykani nishpa. Chashna mana allita ruraptini yanapaway allita rurashpa alli ñannikita katinaynipa.");
INSERT INTO qvsNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ñawpa tiempu Jesukristu nasirkan alli kamachikuk Davidpa ñawpa awilunchi Abrahampa ayllunkunamanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamka karkan Isakpa tatan. Isakka karkan Jakobopa tatan. Jakoboka karkan Judapa wawkinkunapa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaka karkan Farespa Sarapa tatan. Farespa Sarapa maman karkan Tamar. Fareska karkan Esrompa tatan. Esromka karkan Arampa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramka karkan Aminadabpa tatan. Payka karkan Naasonpa tatan. Naasonka karkan Salmonpa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonka karkan Boospa tatan. Boospa maman karkan Rahab. Booska karkan Obedpa tatan. Paypa mamanka karkan Ruti. Obedka karkan Isayipa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isayika karkan alli kamachikuk Davidpa tatan. Davidka karkan Salomonpa tatan. Salomonpa maman manara Davidpa warmin kashpa Uriyaspa warmin karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonka karkan Roboampa tatan. Roboamka karkan Abiyaspa tatan. Payka karkan Asapa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaka karkanna Josafatpa tatan. Josafatka karkan Jorampa tatan. Joramka karkanna Usiyaspa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiyaska karkan Jotampa tatan. Jotamka karkan Akaspa tatan. Akaska karkan Esekiyaspa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyaska karkan Manasespa tatan. Manaseska karkan Amonpa tatan. Amonka karkan Josiyaspa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiyaska karkan Jekoniyaspa wawkinkunapa tatan. Chay pachana Babilonia llaktamanta runakuna israel runakunataka apishpana pusharkansapa llaktanman chaypi paykunapa munanankunata rurashpa kawsanankunapana. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chaymanta Babilonia llaktamanta kutimuptinkuna Jekoniyaska karkan Salatielpa tatan. Salatielka karkan Sorobabelpa tatan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabelka karkan Abiyupa tatan. Abiyuka Eliakimpa tatan karkan. Eliakimka Asorpa tatan karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorka Sadokpa tatan karkan. Sadokka karkan Akimpa tatan. Akimka Eliyupa tatan karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuka karkan Eleasarpa tatan. Eleasarka Matanpa tatan karkan. Matanka Jakobopa tatan karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakoboka Josepa tatan karkan. Joseka Mariyapa kusan karkan. Mariyaka karkan Jesuspa maman. Tata Dios Jesustaka kachamurkan kay allpaman runakunata uchankunamanta salvanankunapa. Chayrayku Jesuspa suk shutin karkan Kristu. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ñawpa awilunchi Abrahammantapacha kamachikuk Davidkaman chunka chusku kuti chay runakuna mirarkansapa. Chaymanta Davidmantapacha Babilonia llaktaman israel runakunata pushashkankuna pachakaman chunka chusku kuti chay runakuna mirarkansapa. Babiloniaman pushashkankunamantapacha Tata Diosmanta salvakuk runa nasishkan tiempukaman chunka chusku kuti chay runakuna mirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesukristu kashna nasirkan. Tiyarkan suk shipash Mariya. Chay shipash mañaduna karkan kasarakunanpa Josewan. Manara Josewan tantanakushpara Mariyaka okupadana karkan Tata Diospa Espiritunpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseka novian Mariya okupada kananta yachashpa manana munarkannachu paywan kasarayta. Alli rurak runa kashpa mana munarkanchu demandayta ama llaktamasinkunapi pinkachinanpa. Yuyaykurkan upallalla sakiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sakinanpa yuyaykuykaptinna suk tuta muskuyninpi Tata Diospa angelnin willarkan: “Kanmi ñawpa Davidpa miraknin kanki. Chayrayku Tata Dios munan noviayki Mariyawan kasaranaykipa. Chay wawanka Tata Diospa Espiritunpami. Manami ullkupachu. Ama pinkakuychu noviayki Mariyawan kasarayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariyaka suk ullku wambrata wawayanka. Chay wambra llaktamasinkunata kastigumanta salvankasapa. Chayrayku chay wambrata shutiyachinki Jesus.” Chayta willashpa chay angelka Josetaka sakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ñawpa pacha Tata Dioska suk yachachikuk runata willarkan: “Suk sensilla shipashmi ullku wambrata wawayanka. Payta shutiyachinkichi Emanuel.” Emanuel riman “Tata Dios ñukanchikunawan.” Chay killkadun rimashkanshina Mariyaka wawayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseka puñuymanta rikchashpa Tata Diospa angelnin willashkanta kasushpa Mariyawan kasararkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kasarashkankunawasha Mariyaka wawayanankaman manami Josewanka puñurkanrachu. Mariyapa wawan nasiptin Joseka shutiyachirkan Jesus. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sinchi kamachikuk Herodes chay llaktakunapi kamachikushkan tiempu Belen llaktapi Jesuska nasirkan. Chay Belen llaktaka Judea partipi karkan. Jesus nasiptinna inti llukshimunan partimanta luserukunata yachakuk yachaysapa runakuna shamurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalen llaktapi chayashpankuna chaypi kawsak runakunata willarkansapa: —Chay karu llaktaynikunapi suk llipyak luseruta kawashkanisapa. Chay luseruta kawashpaynikuna yachanisapa suk wambra nasishkanta kankuna judiyu runakunata kamachishunaykichipa. Chayrayku shamushkanisapa payta kuyanaynikunapa. ¿Maypiti nasishka? ");
INSERT INTO qvsNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chayta uyarishpa kamachikuk Herodeska sukaman turbakurkan. Sukaman manchakurkan. Jerusalen llaktapi kawsak runakunapish turbakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaypina Herodeska tukuy saserdotekunapa kamachikukninkunata Moisespa killkadunta yachachikkunata kayachishpa tapurkansapa: —Kankunaka Tata Diospa rimananta yachashpaykichi willawaychi ¿maypiti nasinka Tata Diosmanta shamuk salvakuk runa? ");
INSERT INTO qvsNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chaypina chay runakuna aynirkansapa: —Kay Judea partipi Belen llaktapi nasinka. Ñawpa yachachikuk runa Tata Dios rimashkanta killkarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Judea partipi aypa atun llaktakuna tiyaptinpish taksha Belen llaktapi suk wambra nasinka alli kamachikuk kananpa. Paymi israel wambraynikunata allita yachachinkasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chayta uyarishpa Herodeska chay alli yachak runakunata pakallalla kayachirkan. Paykunata tapurkansapa: —¿Aykapiti rikurimushka chay alli llipyak luseruka? ");
INSERT INTO qvsNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Paykuna willaptinkuna Herodeska willarkansapa: —Rillaychi Belen llaktaman. Chaypi chay nasidu wambrata allita maskamuychi. Payta tarishpaykichi shamuychi willawak ñukapish rinaynipa payta kuyak. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chashna Herodes willaptinkuna Belen llaktaman chay yachaysapa runakunaka rirkansapa. Riykashpankuna llaktankunapi kawashkankuna luseruta kashkan kawarkansapa. Chay luseruka ñawpakninkunata rishpa shayarirkan maypicha Jesus kananpi. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Paykunaka chay luseruta kawashpankuna sukaman kushikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chaymanta chay wasipi yaykushpankuna mamanwan wambra Jesusta kawarkansapa. Chaypina paykunaka kunkurikushpankuna chay wambrataka kuyarkansapa. Chaypina apamushkan kajonninkunamanta surkurkansapa kurita, kaspi wikin mishkiklla asnakta, ampinakuna kaspi wikinta. Chay kimsa layakunata wambra Jesusta kuyashpa kurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaymanta Tata Dioska paykunata muskuyninkunapi willarkansapa amana Herodesman rinankunapa. Chayrayku Tata Diosta allita kasushpa suk chikan ñanta llaktankunaman kutirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chaypina chay yachaysapa runakuna llaktankunaman rishkankunawasha Tata Diospa angelnin Josetaka muskuyninpi rikurishpa willarkan: —Herodeska kay wambra Jesustaka maskachinka wañuchichinanpa. Chayrayku utkana atarishpayki wambrata mamanwan tantallata pushay Egipto llaktaman. Chaypi kipariychi ñuka willanaynikaman kutimunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chashna chay angel willaptin Joseka atarimushpa chay tutalla wambra Jesusta mamanwan tantallata pusharkan Egipto llaktaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ñawpa yachachikuk runa Tata Diospa rimashkanta killkarkan: “Egipto llaktamanta wambraynita kayarkani.” Tata Dios killkadunpi rimashkanshina paykunaka Egipto llaktapi kawsarkansapa Herodes wañunankaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chaypina kamachikuk Herodeska yacharkan yachaysapa runakuna llullachishpa chikan ñanta llaktankunaman kutishkankunata. Chayrayku sukaman piñakurkan. Jerusalenpi kashpankuna chay yachaysapa runakunaka payta willarkansapa aykapimi chay luseruka rikurimushka nishpa. Chayta willaptinkuna Herodeska yacharkan mashna watayukna Jesus kananta. Chaypina Jesusta wañuchinayashpa Belen llaktaman soldadunkunata kacharkan. Paykunaka Belenpi tukuy ladunpi tiyak llaktillukunapipish tukuy manara ishkay watayuk wambrillukunata wañuchirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ñawpa yachachikuk Jeremiyas killkarkan: “Rama llaktapi tukuy warmikuna ñawpa Rakelshina sukaman llakishpa kaparishpa wakakurkansapa wawankunata wañuchiptinkuna. Mana munarkansapachu ni pi kushichinankunapa wawankuna wañushka kaptinkuna.” Chay killkadunpi rimashkanshina llullukunata wañuchirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Chaymanta Herodes wañuptin Egipto llaktapi Jose puñuykaptin Tata Diospa angelnin willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Atariyna. Chay wambrata mamanwan tantallata pushashpayki kutiy Israel llaktaykichiman. Chay wambra wañuchinayak runakunaka ñami wañushkasapana.” ");
INSERT INTO qvsNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chaypina Joseka angelta kasushpana wambrataka mamanwan pusharkan Israel llaktaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chayashpankuna Joseka yacharkan Herodespa wambran Arkelao Judea partipi kamachikuk kananta. Chayrayku manchakurkan Judeaman riyta. Tata Dios muskuyninpi willaptin Galilea partiman rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ñawpa yachachikuk runakuna rimarkansapa: “Nasaret llaktapi kawsaptin Tata Diosmanta shamudu runata shutiyachinkasapa Nasareno.” Chayrayku Jose Galilea partipi chayashpa Nasaret llaktapi rirkansapa kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chaymanta aypa watakuna washan Judea partiman suk runa Juan rirkan chunlla chakidu pampapi yachachikuk. Aypa runakunata Juan bawtisaptinkuna payta shutiyachirkansapa Juan Bawtista. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Chaypina Juanka willarkansapa: —Tata Dios sukaman munan mandunpi yaykunaykichipa. Chayrayku tukuy mana alli rurashkaykichimanta wanaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ñawpa alli yachachikuk Isaiyas killkarkan: “Chunlla chakidu pampapi suk runa sinchita yachachikuykan: ‘Señorninchipa suk ñanta allichaychi. Suk ñanta kuskachaychi chayta purinanpa.’ ” Chashna killkashpa Isaiyaska Juanpami killkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpa llachapan kamellu millwanmanta awadu karkan. Karapamanta ruradu chumbiwan sinturanta watak. Atun marukunata sacha amukunapa mishkinta mikuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Chaypina aypa runakuna Jerusalen llaktamanta Judea partimanta Jordan yaku ladun llaktakunamanta llukshiksapa Juanta uyarinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chaypina chay runakuna Juanta uchankunata willarkansapa. Chashna uchankunata willaptinkuna Jordan yakupi Juanka bawtisarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Chaymanta Fariseo runakunawan Saduseo runakuna rirkansapa Juanta willak bawtisanankunapa. Chaypina Juanka paykunata willarkansapa: —Kankuna sukaman llullachikushpaykichi machakuyshina kankichi. Tata Dios kankunata utkana sukaman kastigashunkichi. ¿Pití willashushkankichi kastiguykichimanta kishpinaykichipa? ");
INSERT INTO qvsNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Manara bawtisakushpaykichira allita rurashpa kawsaychi tukuy runakuna yachanankunapa wanashkaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Amana yuyanakuychinachu: “Ñukaykuna ñawpa awilunchi Abrahampa miraknin kaptinikuna Tata Dios mana kastigawankasapachu.” Ñuka willaykichi: Tata Dios kay rumikunamanta atipanman Abrahampa mirakninta rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Suk kaspi mana allita wayuchakuptinka doyñun sapinpi achawan kuchushpa rupachin. Chashnami Tata Dios kankunata mana alli rurashkaykichirayku utkana kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Chaymanta Juanka willarkansapa: —Ñukaka yakullawan bawtisaykichi mana alli rurashkaykichimanta wananaykichipa. Chaymanta washaynita ñukamanta ashwan alli yachachikuk runa shamun. Payka Tata Diospa Espiritunwan ninawanshina bawtisashunkichi uchaykichimanta pichashunaykichipa. Chay yachachikuk runa ñukamanta ashwan tukuy laya atipakmi. Chayrayku mana animukunichu ushutanta apayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Triguta waktashpa murunkunata surkunchi. Chaypina murukunata wakaychanchi. Trigupa tullunkunata rupachinchi. Chay ñukamanta ashwan yachaysapa runaka chay trigu murunkuna surkuk runashinami. Paymi tukuy kreyikukkunata allita kuydan. Mana kreyikukkunata churankasapa mana tukuyniyuk ninapi. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chaymanta Jesuska Galilea partimanta llukshirkan Jordan yakuman rinanpa. Jordan yakupi Juanka aypa runakunata bawtisaykarkan. Chaypina Jesuska Juantaka willarkan bawtisananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Chashna willaptinna Juan mana bawtisanayashpa Jesusta willarkan: —Ashwan alli kanman ñukata bawtisawanaykipa. ¿Imapati ñukata shamunki willawak bawtisanaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chaypina Jesuska willarkan: —Tata Dios kamachiwashkanchikunata kasunanchikuna tiyan. Chayrayku bawtisaway. Chashna willaptin Juanka payta bawtisarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chaymanta bawtisakushkanwasha Jesuska yakumanta llukshirkan. Chaypina sielu kicharikuptin Jesuska kawarkan Tata Diospa Espiritunta suk urpaytashina paypa sawanman urayamuptin. ");
INSERT INTO qvsNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chaypina sielumanta Tata Dioska willarkan: —Kay Jesuska sukaman munanayni wambraynimi. Paymi sukaman kushichiwan. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaymanta Jesus bawtisakushkanwasha Tata Diospa Espiritun suk chunlla chakidu pampaman pusharkan. Chaypi supay munarkan Jesusta mana allikunata rurachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chay chunlla pampapi kashpa Jesus chusku chunka diyata chusku chunka tutata mana nimata mikurkanchu. Chaypina sukaman yarkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Supay llullachinayashpa rirkan Jesustaka willak: —Tata Diospa wambran kashpaykika kay rumikunata willay pankuna tukunanpa chaykunata mikunaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chaypina Jesuska aynirkan: —Tata Diospa killkadunpi willawanchi: “Runakuna Tata Diospa rimananta kasushpa kawsanankuna tiyan. Manami panta mikushpallachu kawsankasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaymanta supayka Jesustaka pusharkan Tata Dios akllashkan Jerusalen llaktaman. Chaypi Tata Diospa manllayba altu wasin sawaman pusharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chaypina Jesusta willarkan: —Tata Diospa wambran kashpaykika kay altumanta allpaman wishchunakuy. Tata Dios killkadunpi willawanchi: “Tata Dioska angelninkunata kachanka amachashunaykipa. Paykuna makinkunawan chaskishunkisapa ama rumikunapi mitkakunaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chaypina Jesuska aynirkan: —Chaymantapish Tata Diospa killkadunpi willawanchi: “Ama nimata yankamanta ruraychichu yachanayashpa Tata Dios yanapawankachu manachu nishpa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chashna willaptin supayka Jesustaka pusharkan manllayba altu urkuman. Chay altumanta tukuy kay allpapi llaktakunata tukuy chaykunapi alli tiyakkunata kawachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Willarkan: —Kan kunkurikushpa ñukata kuyawaptikika tukuy kay kawashkaykitami kushkayki. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chaypina Jesuska willarkan: —Ñukamanta ashuy, Satanas. Tata Diospa killkadunpi willawanchi: “Señorniki Tata Diosllata kuyay. Payllata sirvishpa kawsay.” ");
INSERT INTO qvsNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chashna Jesus sinchita willaptin supayka ashurkan. Chaypina Tata Diospa angelninkuna Jesustaka laduncharkansapa yanapak. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chaymanta kamachikuk Herodeska yachachikuk Juanta karselpi churarkan. Jesuska chayta yachashpa Galilea partiman rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Galileapi kashpa manana Nasaret llaktapi kawsarkannachu. Rirkan kawsak Kapernaum llaktapi. Chay llaktaka karkan Sabulon Neptali partipi Galilea kocha ladunpi. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ñawpa tiempu Tata Dios rimashkanta yachachikuk Isaiyas killkarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sabulon partipi Neptali partipi Galilea kocha ladunpi Jordan yaku ladunpi chay mana judiyu runakuna kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chay partikunapi kawsak runakuna mana allita rurashpa tutapishina kawsarkansapa. Paykunaka sukaman llipyak lusta kawarkansapa. Chay runakuna wañunankunata manchashpa kawsarkansapa. Paykunapa allima lus llipyamurkan.” Chayta killkarkan Isaiyaska. Chaypina chay killkadunpi rimashkanshina Jesus allita yachachikushpa lusshina karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chaymanta Jesus chay Kapernaum llaktapi kawsashpana kallarirkan yachachikuyta: —Tata Dios sukaman munan mandunpi kawsanaykichipa. Chayrayku tukuy mana alli ruranaykichimanta wanaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chaymanta Galilea kocha mañanpi puriykashpa Jesuska ishkay runakunata kawarkan. Paykunaka atun redninkunawan challwakuykarkansapa. Suk karkan Andres. Suk karkan wawkin Simon. Paypa suk shutin karkan Pedru. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chaypina Jesuska paykunata willarkansapa: —Kankuna allita yachankichi challwakunata apiyta. Kunanmantapacha ñukata katiwaychi. Katiwaptikichi ñuka allita yachachishkaykichi runakunata yachachinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chay ratulla chay challwakuk runakunaka redninkunata sakishpankuna Jesusta katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chaymanta chay kocha mañanta riykashpankuna Jesuska Santiagota wawkin Juanwan tantallata kawarkan. Chay ishkay runakuna Sebedeopa wambrankuna karkansapa. Suk kanowapi chay ishkay runakuna tatanwan redninkunata allichaykarkansapa. Chaypina Jesuska chay ishkay runakunata kayarkansapa paywan tantalla purinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chay ratulla paykunaka kanowanpi tatanta sakishpa Jesuswan rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chaymanta Galilea partipi tukuy llaktakunaman rishpa Jesuska yachachikurkan. Judiyu runakunapa tantanakunankuna wasinkunapi yachachikurkan. Chay runakunata willarkansapa: —Tata Diosmi munan mandunpi kawsanaykichipa. Chashna willashpa Jesuska runakunata tukuy laya unkuyninkunamanta nanayninkunamanta alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chaymanta Siria partipi sukaman famakurkansapa Jesus unkudukunata alliyachiykananta. Chayrayku Siriapi kawsak runakuna Jesusman pusharkansapa rikchak laya unkuyniyuk runakunata, nanayuk runakunata, supayuk runakunata. Chaymanta pusharkansapa manchariyuk runakunata, kaspirayadu runakunata. Chaypina Jesuska tukuy chay unkudu runakunata alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymanta Jesusman rirkansapa aypa runakuna Galilea partimanta, Dekapolis partimanta, Jerusalen llaktamanta, Judea partimanta, Jordan yaku suk ladunmanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chaymanta Jesuska chay aypa runakunata kawashpa suk taksha urku sawanman rirkan. Chaypi tiyariptin disipulunkuna laduncharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chaypina Jesus kallarirkan yachachiysapata. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Willarkansapa: —Kankuna kikikichi mana kreyinakushpaykichi Tata Dios yanapashunaykichita yuyashpa kushikuypuru kawsankichi. Chashna kawsashpaykichi Tata Diospa mandunpi kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Llakidu kashpaykichipish kushikuypuru kankichi. Kankunata Tata Dios kuyashushpaykichi kushichishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kankuna kikikichi mana alabanakushpaykichi runamasikichiwan mana piñanakushpaykichi kushikuypuru kankichi. Tukuy allpapi maypipish kaptikichi Tata Dios yanapashunkichi kushichishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kankuna yakuta munakshina mikuyta munakshina Tata Diospa munananta ruranayashpaykichi kushikuypuru kankichi. Tata Dios kankunata kushichishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kankuna runamasikichita llakichishpa yanapashpaykichi kushikuypuru kankichi. Tata Dios kankunatapish llakichishushpaykichi yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tukuy shunku Tata Diosllata kuyashpaykichi kushikuypuru kankichi. Kankunaka Tata Diostami kawankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kankuna runamasikichita yanapashpaykichi kuyanakushpa kawsanankunapa kushikuypuru kankichi. Tata Dios kankunata willashunkichi wambrankuna kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tata Diospa munananta rurashkaykichirayku runakuna chiknishuptikichi kushikuypuru kankichi. Tata Diospa mandunpi kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ñukata kreyiwashkaykichirayku runamasikichi piñayashuptikichi makashuptikichi llullakushpa yuyashuptikichi kushikuypuru kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kankunatashina ñawpa yachachikukkunatapish chiknishpankuna sufrichirkansapa. Tata Dios kankunata sielupi premyuykichita kushunkichi. Chayrayku sukaman kushikuychi. Kushikushpalla kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kankuna runamasikichita yachachishpa yanapashpaykichi alli kachishinami kankichi. Allpayadu kachi mananami nima layapi kachiyamunkanachu. Chashna mana alli kaptin wishchunchi tukuy pi sarunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Chaymanta suk alkusata apichishpanchikuna churanchisapa altupi tukuy wasita lusichinanpa. Chay apichidu alkusata mana churanchichu kajon ukupi. Kankunaka iden chay apichidu alkusashinami kankichi. Chaymanta suk llakta urku sawanpi kaptin mana atipanchu pakakuyta. Tukuy pi chay llaktata allimata kawan. Iden chay llaktatashina kankunatapish runamasikichi kawashunaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chayrayku allillata rurashpa kawsaychi. Tukuy runamasikichita yanapaychi paykunapish sielupi kawsak Tata Diosnikichita kuyashpa alabanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ñawpa tiempu Tata Dioska awilunchikunata yachachirkansapa kamachikunankunata kasushpa kawsanankunapa. Tukuy chayta alli yachachikuk runakuna killkarkansapa. Ñukaka shamushkani tukuy chay killkadunkunapi rimashkanta rurak. Manami shamushkanichu willaknikichi amana chay killkadunkunata kasunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mash allita uyariwaychi. Tata Dios tukuy rimashkanta ruranan tiyan. Allpa sielu kullunan diyakaman mana ni pi Tata Diospa rimashkanta chinkachinkachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chaymanta ichara kankuna Tata Dios kamachikushkanta mana kasunkichimanchu chayka manami kasunapachu nishpa. Chaymanta ichara runamasikichitapish yachachinkichiman ama kasunankunapa. Chashna mana kasuptikichi Tata Dios willashunkichi mandunpi mana alli sirvikuk kanaykichita. Chaymanta ichara kankuna Tata Dios kamachikushkanta allita kasushpa kawsankichiman. Chaymanta ichara runamasikichitapish yachachinkichiman allita kasunankunapa. Chashna kasuptikichi Tata Dios willashunkichi mandunpi ashwan alli sirvikuk kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Allita willaykichi. Moisespa killkadunta yachachikuk runakunawan fariseo runakuna rimansapa Tata Dios kamachikushkankunata kasuykanankunata. Chashna rimashpapish manami allitachu kasuykansapa. Kankuna paykunamanta ashwan allita kasunaykichi tiyan. Mana paykunamanta ashwan allita kasushpaykichika manami Tata Diospa mandunpichu kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kankuna yachashkankichi Moises awilunchikunata willashkankunata: “Ama runamasikichita wañuchiychichu. Wañuchiptikichika llakta kamachikuk runa kankunatapish kastigashunaykichi tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Chayta yachaptikichipish ñukami willaykichi: Kankuna runamasikichita chikniptikichika llakta kamachikuk runa kastigachishunaykichi tiyan. Chaymanta kankuna runamasikichita mana allita willashpa piñachiptikichika chay ashwan sinchi awtoridarkuna kastigachishunaykichi tiyan. Chaymanta runamasikichita maldisiptikichika Tata Dios mana tukuyniyuk ninapi kastigashunaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tata Diospa wasinman ofrendata apashpayki ichara yuyankiman suk runata sientichishkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Chayta yuyashpayki manarapish ofrenda churanapi ofrendaykita churashpara rillay chay sientichishkayki runawan perdonanakuk. Chashna perdonanakushpana kutiy ofrendaykita Tata Diospa churak. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ichara suk runata debiptiki payka awtoridarpi mañakukushunkiman. Manarapish awtoridarpi chayashpaykichira paywan allita parlashpa allichay amana awtoridarpi yaykuchishunaykipa. Awtoridarpi chatashuptikika guardiyata willanka karselpi churashunaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Allita willayki: Tukuy debinaykita kutichinaykikaman karselmanta mana llukshinkimanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Chaymanta kankuna yachashkankichi Moises awilunchikunata willashkanta: “Ama chikan warmiwan uchallikushpa kawsaychichu.” ");
INSERT INTO qvsNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Chayta yachaptikichipish ñukami willaykichi: Suk warmiwan puñuyta munashpaykichika ñami yuyaynikichipi uchallikushkankichina. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chayrayku ñawiki uchallichishuptikika surkushpa wishchuy ama kashkan uchallichishunanpa. Ashwan alli kanman suk ñawikillawan kawsanaykipa ama chay mana tukuyniyuk ninaman rinaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chaymanta ichara makikiwan sukaman mana allita rurayta munankiman. Chay makikita tipiy amana nima mana allita ruranaykipana. Ashwan alli kanman suk makikillawan kawsanaykipa ama tukuy kuerpuykiwan mana tukuyniyuk ninaman rinaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Chaymanta ñawpa awilunchikuna rimarkansapa: Warmikichita wishchunayashpaykichika rillaychi awtoridarpi killkachinakuk: “Kay warmitaka mananami munaninachu.” ");
INSERT INTO qvsNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Chashna awilunchikuna rimaptinkunapish ñukami willaykichi: Warmikichi mana chikan ullkuwan uchallikuptinka ama wishchuychichu. Mana uchallikuk warmikita wishchushpaykichika kachaykankichi chikan ullkuwan uchallikunanpa. Wishchudu warmiwan kasarak ullkupish uchallikunmi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Chaymanta Jesuska willarkansapa: —Kankuna yachashkankichi Moises awilunchikunata willashkankunata: “Tata Diosta jurashpa suk imata ruranaykichipa willashpaykichika chay willashkaykichita ruranaykichi tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Chayta yachaptikichipish ñukami willaykichi: Suk imata ruranaykichipa rimashpaykichika mana jurashpalla ruraychi. Tata Dios sielumanta kamachikuykan. Chayrayku suk imata ruranaykichipa ama sielupa shutinpi juraychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kay allpapipish Tata Dios kamachikuykan. Chayrayku suk imata ruranaykichipa rimashpaykichika ama allpapa shutinpi juraychichu. Jerusalen llakta sukaman sinchi kamachikuk Tata Diospa llaktanmi. Chayrayku ama Jerusalenpa shutinpi juraychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chaymanta mana chukchaykichita atipankichichu yanayachiyta nima yurakyachiyta. Chayrayku ama kikikichipa shutikichipi juraychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kankuna willashpaykichika ariya rurasha nishpa ruranaykichi tiyan. Willashpaykichika manami rurashachu nishpa ama ruraychichu. Ashwanta rimashpaykichika mana allitachu rimaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ñawpa awilunchikuna yachachikurkansapa: “Makanakushpa suk runa llaktamasinpa ñawinta surkupuptinka kirunta polvoptinka paypapish awtoridar ñawinta surkuchipunan tiyan kirunta polvochipunan tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Chayta yachachiptinkunapish willaykichi: Suk sakra runa imatapish kaptin rurashuptikichi ama kutipaychichu. Suk ladu uyaykichipi sakmashuptikichika suk ladutapish kuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chaymanta suk runa mañakukushuptikichi kamisaykichita kichushunaykichipa ama michaychichu apananpa. Sakuykichitapish kuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chaymanta ichara suk kamachikuk runa mana pagarashushpaykichi suk kargata aparichishunkichiman suk kilometruta. Chay kargata ishkay kilometruta apapuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chaymanta llaktamasikichi ima tiyashuknikichita mañashuptikichi kuychilla. Suk imata mañashuptikichi suknin diya kutichishunaykichipa mana michashpa kuychilla. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Chaymanta Jesuska willarkansapa: —Ñawpa awilunchikuna yachachikurkansapa: “Yanapanakukmasikichita kuyaychi. Chiknishuknikichita chikniychi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Chashna yachachiptinkunapish ñukami willaykichi: Kankuna chiknishuk runakunatapish kuyaychilla. Maldisishuptikichika Tata Diosta roygaychi yanapanankunapa. Chiknishuptikichika allita yanapaychi. Sufrichishuptikichika paykunapa oraychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kankunaka allita rurashpa kawsashpaykichi sielupi kawsak Tata Diospa wambrankuna kankichi. Paymi intita llukshichimun alli rurak runakunapa mana alli rurak runakunapapish. Tata Dios tamyachimun tukuy alli rurak runakunapa tukuy mana alli rurak runakunapapish. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chay romano awtoridarpa kobrakuk runakuna mana alli rurak kashpankunapish yanapanakukmasinkunallawan kuyanakunsapa. Kankuna kuyanakukmasikichillata kuyashpaykichika paykunamanta mana ashwan allitachu ruraykankichi. Tata Dioska mana nima premyuta kushunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kankuna ayllupuralla rimachinakushpaykichika Tata Diosta mana riksik runakunamanta mana ashwan allitachu ruraykankichi. Paykunapish kuyanakukmasinkunallata rimachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kankunaka sielupi kawsak Tata Diosnikichishina tukuy runakunata kuyashpa kawsanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Chaymanta ama ni pita yanapaychichu runakuna alabashunankunallapa. Alabashunankunallapa yanapaptikichi sielupi kawsak Tata Dioska manami nima premyuta kushunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chayrayku mana nimayuk runakunata yanapashpaykichi ama ni pita willaychichu. Llullachikuk runakuna kallikunapi tantanakunankuna wasikunapi tukuy pita willansapa mana nimayukkunata yanapashkankunata. Munansapa tukuy runakuna rimanankunapa alli rurak kanankunata. Ñuka willaykichi chay alabanakunankunalla premyunkuna kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kankuna mana nimayuk runata yanapashpaykichi ama ni pita nima kuyadu amiguykichita willaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pakallalla yanapaptikichi Tata Dioska tukuy alli rurashkaykichita yachashpa premyuykichita kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Chaymanta Jesuska willarkansapa: —Allipi tukushpa llullachikuk runakuna tantanakunankuna wasikunapi plasakunapi shayarinsapa oranankunapa. Chayta ruransapa runamasinkuna kawashpa rimanankunapa alli rurak kanankunata. Chashna runamasinkuna alabashpankuna premyuntashina kunsapa. Tata Dios mana nimata kunkasapachu. Kankuna ama paykunashina ruraychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kankuna orashpaykichi wasikichi ukupi yaykuychi. Punkuta wichkashpa sapallaykichilla Tata Diosnikichiwan parlaychi. Pakallalla oraptikichi payka uyarishpa premyuykichita kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ama oraychichu chay mana judiyu runakunashina. Paykunaka amañansapa Tata Diosta mañayta kuti kuti chayllata rimashpa. Yuyansapa kuti kuti chayllata mañashpa Tata Dios ashwan allita uyarinankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kankuna orashpaykichi ama paykunashina mañaychichu. Manara mañaptikichira Tataykichi Dios tukuy munanaykichita yachan. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chayrayku kashna oraychi: “A Tata Dios, kanmi kanki altu sielupi kawsak Tataynikuna. Munanisapa tukuy runakuna rimanankunapa kan sukaman alli rurak kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Munanisapa tukuy runakunata kamachinaykipa. Roygaykisapa sielupi kawsakkuna munanaykita ruranankunashina kay allpapipish tukuy runakuna munanaykita ruranankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tukuy diya mikunaynikunata kuwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Runamasinikuna mana allita rurawaptinkuna ñukaykuna perdonanisapa. Chashna perdonashkaynikunashina kanpish uchaynikunamanta perdonawaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Supaymanta amachawaysapa. Yanapawaysapa ama supay llullachiwashpankuna mana allita rurachiwanankunapa. Kanmi mana tukuyniyukta tukuy laya atipak alli kamachikuk kuyakuk kanki. Chashna kachun.” ");
INSERT INTO qvsNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Chaymanta willaykichi: Runamasikichi mana allita rurashuptikichika perdonanaykichi tiyan. Kankuna perdonaptikichika sielupi kawsak Tata Dios kankunatapish mana alli rurashkaykichimanta perdonashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mana alli rurashuknikichita mana perdonaptikichika Tata Diospish manami kankunataka perdonashunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Allipi tukushpa llullachikuk runakuna churadu diyakunapi mikunata sasinsapa Tata Diosta kushichinankunapa. Paykuna sukaman munansapa tukuy pi yachanankunapa sasiykanankunata. Llakidu uyayuk tukunsapa tukuy pi kawashpa llakichinankunapa. Chashna runamasinkuna alabashpankuna premyuntashina kunsapa. Tata Dios manami nimata kunkasapanachu. Kankunaka mikunata sasishpaykichika ama paykunashina ruraychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tata Diosta kushichinaykichipa mikunata sasishpaykichika chuya chuyata uyaykichita mayllaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Allita allichanakuychi ama ni pi yachanankunapa sasiykanaykichita. Tataykichi Diosllami mikunata sasinaykichita yachashpa premyuykichita kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ama kay allpapi rikchak layaykichita mirachishpa kawsaychichu. Tukuy laya kay allpapi kuruyan ismayan. Chaymanta suwa runakuna yaykushpankuna chay tiyakkunata apansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kankuna Tata Diosta allita kasushpa kawsaptikichi sielupi tiyapushunaykichi aypayaykan. Chaypi suwakuna manana yaykunkasapanachu apanankunapa. Chaypi mana nima laya kuruyanchu nima ismayanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sielupi tiyapushunaykichita tukuy shunku munashpaykichi chayllata yuyashpa kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ñawinchikuna kuerpunchikunapa lusninshina. Yuyayninchikuna shunkunchikunapa lusninshina. Kankuna allikunata yuyashpaykichi allita rurashpa kawsankichi. Allita rurashpa kawsashpaykichi luspishina kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Chaymanta ñawikichi mana allita kawakuptinkuna tutapishina kawsankichi. Kankuna mana allikunata yuyashpaykichi mana allita rurashpa tutapishina kawsankichi. Chaymanta mana allikunata yuyashpaykichika allita rurashpa kawsashkaykichimanta Tata Diosmanta ashushpaykichi sukaman ashwan tuta likidupishina kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Suk runa mana atipanchu chay ratulla ishkay patronpi trabajayta. Sukllallata kasunan tiyan. Suk patronninta kasushpa sukta manana kasunnachu. Kankuna chay trabajador runashina kankichi. Kullkiyayta munashpalla kawsashpaykichika manana atipankichinachu Tata Diosta kasushpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Chayrayku allita willaykichi: Ama turbachinakushpa yuyaychichu imatami mikusha upyasha imatami llachapakusha nishpa. Tata Dios nasishkanchikuna diyamanta wiwawanchisapa. ¿Manachu mikunanchikunatapish llachapanchikunatapish kuwanchisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mash kawaychi imashnami pishkillukuna pawashpa kawsansapa nishpa. Paykunaka mana nima murukunata tarpunsapachu. Paykunapa nima muru wakaychana wasinkuna tiyapunsapachu. Mana nima murukunata tarpuptinkunapish sielupi kawsak Tata Diosnikichi aypa mikunankunata kunsapa. Tata Dioska pishkillukunamanta kankunata ashwan allita kuyashunkichi. Chayrayku rikchak layata kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kankunaka sukaman turbachinakushpa ¿atipankichimanchu ashwanta kawsayta? ");
INSERT INTO qvsNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mana ni chayta atipashpaykichika ¿imapatí llachapaykichillapi yuyashpa turbakunkichi? Mash kawaychi chay allima sisakunata. Chaykunaka mana nima trabajansapachu nima puchkakunsapachu. Mana trabajashpankunapish sukaman allima rikurinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ñawpa kamachikuk Salomonpa llachapankuna sukaman allima rikurirkan. Kay sisakuna paypa llachapanmanta ashwan allimata rikurinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tata Dios kiwakunata wiñachin sisanankunapa. Chay sisakuna suk diyallapa allimata rikurinsapa. Chaymanta ñukanchikuna rupachinchisapa. ¿Imapatí mana kreyikunkichi Tata Dios chay sisakunamanta kankunata ashwan allimata mudachishunaykichita? ");
INSERT INTO qvsNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chayrayku ama sukaman turbachinakuychichu yuyaykushpa imatami mikusha imatami upyasha imatami mudakusha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tata Diosta mana kasushpa kawsak runakuna chaykunallata yuyaykushpalla kawsansapa. Ama paykunashina kawsaychichu. Kankunapaka tiyanmi alli kuydakuk yanapakuk Tata Diosnikichi. Paymi allita yachan imakunami illashunkichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kankunapa kuydakuk Tata Diosnikichi tiyaptin ashwanta munaychi paypa mandunpi kawsayta. Paypa munashkankunata rurashpa kawsaptikichi paymi tukuy layata kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tukuy diya Tata Dios rikchak layata kushuptikichi ama turbakushpa rimaychichu: “Kaya ¿imatatí mikuni imatatí llachapakuni?” nishpa. Kayantinpish Tata Dioska kuyashushpaykichi yanapashunkichi. Chayrayku kayapa kaya washanpa ama sukaman turbachinakushpa llakiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Chaymanta Jesuska willarkansapa: —Ama ni pita washanchashpa yuyaychichu ama Tata Dios kankunatapish willashunaykichipa mana alli rurak kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kankuna imashnacha runamasikichita washanchanaykichishina chashnallami Tata Diospish kankunata willashunkichi mana alli rurak kanaykichita. Runamasikichita rurashkaykichishinalla Tata Dioska kankunatapish rurashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kankuna uchaykichita mana riksinayaptikichi ñawikichipi kaspishina tiyan. Ñawikichipi kaspi tiyaykaptin munankichi wawkikichipa ñawinmanta takshasillu susyata surkuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kankunapa ñawikichipi kaspishina tiyaykaptin ¿imashnatí animukunkichi wawkikichita willayta: “Ñuka ñawikimanta chay susilluta surkunayani” nishpa? ");
INSERT INTO qvsNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Chayta rimashpaykichi allipi tukushpa mana allikunata ruraykankichi. Chayrayku willaykichi: Kikikichipa ñawikichimanta chay kaspitashina surkuychi. Chaypira atipankichi wawkikichipa ñawinmanta chay taksha susillutashina surkupuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Chaymanta Tata Diospa rimananta sinchi shunkuyuk mana kasunayak runakunata ama yachachiychichu. Chay laya runakunata yachachiptikichika iden piña allkushina chiknishushpaykichi makashunkichiman. Paykunata yachachishpaykichika kuchikunapa alli perlaskunatashina wishchuykankichi. Chay laya runakuna Tata Diospa rimananta mana nimatashina kawansapa. Chayrayku ama paykunata yachachiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Chaymanta munanaykichita Tata Diosta mañaychi. Chashna mañaptikichi payka kushunkichi. Munanaykichita maskaychi. Maskashpaykichi tarinkichi. Tata Dios yanapashunaykichipa munashpaykichi payta roygaychi. Chashna roygaptikichi payka punkuta kicharikshina yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tata Diosta mañashpaykichi chaskinkichi. Tata Diosta maskashpaykichi tarinkichi. Tata Diosta roygaptikichi payka punkuta kicharikshina yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kankunapa wambraykichi panta mañashuptikichi ¿ariya rumitachu kunkichiman? ");
INSERT INTO qvsNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Challwata mañashuptikichi ¿ariya machakuytachu kunkichiman? ");
INSERT INTO qvsNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kankuna mana alli rurak kaykashpaykichipish wambraykichita allikunata kunkichi. Sielupi kawsak Tata Diosnikichita mañaptikichi payka ashwan allimakunata kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kankuna munankichi runamasikichi kuyashushpaykichi allita yanapashunaykichipa. Chashnashina kankunapish runamasikichita allita yanapaychi. Moises kamachikunankunapi ñawpa yachachikuk runakuna killkadunpi chayllata yachachikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kankuna llañu punkutashina yaykuychi. Aypa runakuna kikinkunapa munanankunallata rurashpa kawsansapa. Paykunaka iden anchu punkutashina yaykushpa alli kicharidu ñantashina puriykansapa. Chay alli kicharidu ñantashina purishpankuna mana tukuyniyuk ninapi chayankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chaymanta mana aypa runakunachu Tata Diospa munananllata rurashpa kawsansapa. Paykunaka iden llañu punkutashina yaykushpa llañu ñantashina padesishpa purinsapa. Chay llañu ñantashina purishpankuna sielupi chayankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Llulla yachachikuk runakuna rimansapa Tata Diospa rimananta allita yachachikuykanankunata. Kankunaka paykunamanta allita kuydanakuychi ama llullachishunaykichipa. Paykunaka iden ovejashina alli modoyuk tukunsapa. Chaykamanka manchanapa pumashina llullachikushpa wakllichishunayankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Llullachikuk runakunata kawsanankunamanta riksinkichi. Mash yuyaychi. Kashayuk kaspi mana uvakunatachu wayuchakun. Nima chupukasha wayuchakunchu igo wayuta. Chashnashinami chay llulla yachachikuk runakunapish Tata Diospa rimananta mana kuskatachu yachachikunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Suk alli kaspi alli wayukunata wayuchakun. Mana alli kaspi mana alli wayukunata wayuchakun. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Suk alli kaspika manami wayuchakunchu mana alli wayukunata. Mana alli kaspika manami wayuchakunchu alli wayukunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ñukanchi mana alli wayuyuk kaspikunata kuchushpa rupachinchi. Chashnashina llulla yachachikukkunata Tata Dios churanka mana tukuyniyuk ninapi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kankuna chay mana alli yachachikukkunata mana alli ruranankunamanta riksinkichi llulla yachachikukkuna kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tatayni Diospa munananta rurak runakunalla paypa mandunpi yaykunkasapa. Chay llullakuk runakuna: “Señor, Señor” willawashpankunapish mana allita rurashpa kawsansapa. Chayrayku paykunaka manami Tata Diospa mandunpi yaykunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ñuka kashkan shamuptini chay llullachikuk runakuna willawankasapa: “Señor, ñukaykuna shutikita rimashpa yachachikurkanisapa. Shutikita rimashpa runakunamanta supaykunata llukshichirkanisapa. Shutikita rimashpa aypa milagrukunata rurarkanisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chashna willawaptinkunapish willashasapa: “Kankunataka manami riksiykichichu. Mana allita rurashpa kawsashkaykichirayku ñukamanta ashuychi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Chayrayku willaykichi: Kankuna yachachikushkaynita uyarishpa chayta kasunaykichi tiyan. Chashna kasushpa kawsashpaykichi yachaysapa runa kankichi. Suk yachaysapa runa wasinta rurashpa sinchi allpapi uku ukuta aspishpa ruran. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chaymanta sukaman tamyaptin yaku llokllashpa wasita kirpaptin sinchita wayraptin chay alli ruradu wasika mana urmankachu. Kankuna allita kasuwashpa kawsashpaykichika sinchi allpapi wasinta rurak runakunashinami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Chaymanta kankuna yachachikunaynita uyarishpalla mana kasuwashpaykichika suk mana alli yuyaykuk runashina kankichi. Suk mana alli yuyaykuk runa wasinta rurashpa ñupu likidu allpapi ruran. Chay laya ruradu wasika mana sinchikunchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sukaman tamyaptin yaku llokllaptin sinchita wayraptin chay mana alli yuyaykuk runapa wasin kunanlla urmapun. Sukaman allita wakllin. Kankunaka yachachikunaynita mana kasushpaykichika wakllichinakunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Chaymanta Jesus yachachikuyta tukuchaptin chay runakunaka almirashpankuna parlarkansapa: —Kay Jesuska kamachikuk runashina yachachiwanchisapa. Mana Moisespa killkadunta yachachikuk runakunashinachu yachachiwanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chaymanta Jesus chay urkumanta urayamuptin aypa runakuna katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chaypina suk lasaruyak runa Jesusta ladunchashpa ñawpakninpi kunkurikushpa willarkan: —Señor, munashpaykika kay unkuyninimanta alliyachiway. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chashna willaptin Jesuska chay runataka llankashpa willarkan: —Ariya, munani alliyachiynikita. Ñami alliyaduna kanki. Chayta willaptinlla chay runapa tukuy kirinkuna chinkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chaypina Jesuska willarkan: —Amara ni pita willayrachu alliyachishkaynita. Saserdoteman rillay kawashunanpa alliyaduna kanaykita. Chaymanta ñawpa Moises killkashkanpi kamachikunanta allita kasushpa suk ofrendata apay. Chayta apaptiki tukuy runakuna yachankasapa unkuynikimanta sanuyashkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Chaymanta Kapernaum llaktapi chayaptin suk runa Jesusta laduncharkan. Payka Roma llaktamanta soldadukunapa kapitannin karkan. Jesusta sukaman roygashpa willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Señor, suk wiwachuyni wasinipi sukaman unkudulla kawsan. Manana nima kuyuyta atipannachu. Mana muchunapa laya nanaywan sukaman sufriykan. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chashna willaptin Jesuska chay kapitanta willarkan: —Wasikiman risha payta alliyachinaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chaypina chay kapitanka willarkan: —Señor, ñuka mana nimachu kani wasinipi yaykunaykipa. Kayllamanta atipanki wiwachuynita alliyachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tata Diosmi kamachishunki. Chayrayku sinchi kamachikuk kanki. Ñukapapish tiyan kamachiwakninikuna. Paykuna kamachiwaptinkuna kasunayni tiyan. Chaymanta ñuka soldadukunata kamachiptini paykunapish kasuwansapa. Suk soldaduta suk mayman rinanpa willaptini rin. Sukta shamunanpa willaptini shamun. Suk wiwachuyni imatapish rurananpa willaptini ruran. Chayrayku sinchi kamachikuk kashpayki karullamanta wiwachuynita alliyachipay. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chashna chay kapitan willaptin Jesuska sukaman almirarkan. Chaypina tukuy chay katik runakunata willarkansapa: —Allita willaykichi. Tukuy judiyumasinikunamanta mana niman suk runa kay romano kapitanshina ñukata kreyiwashkachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chayrayku willaykichi: Inti llukshimunanmanta inti yaykunanmanta tukuy kreyiwakkuna Tata Diospa mandunpi yaykunkasapa. Chaypina tiyarinkasapa ñawpa awilunchi Abrahamwan Isakwan Jakobowan tantalla mikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Chaykamanka kankuna Tata Diospa mandunpi yaykunaykichi kaykaptin mana ñukata kreyiwashkaykichirayku mana yaykunkichichu. Tata Dioska tukuy mana kreyiwakkunata sielu washaman tutayaduman churankasapa. Chaypina paykunaka llakishpankuna kirunkunata mukushpankuna sukaman wakankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chayta willashkanwashana Jesuska chay kapitanta willarkan: —Rillayna wasikiman. Tukuy shunku kreyiwashkaykiraykumi wiwachuykitaka alliyachishkani. Jesus willashkan oraslla chay unkudu wiwachunka wasinllapi alliyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chaymanta Jesuska disipulunkunawan rirkansapa Pedrupa wasinman. Chaypi yaykushpa Jesuska Pedrupa suedranta tarirkan unkuduta. Chay warmika kawitunpi kalentorawan siridu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chaypina Jesuska chay unkudu warmipa makinta llankaptin kalentoranka chiriyapurkan. Chashna alliyashpa atarimushpa kallarirkan Jesusta disipulunkunata karaysapata. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chaymanta amusayaykaptinna Jesusman supayadu runakunata pushamurkansapa. Jesuska rimashpalla chay supaykunata llukshichirkansapa. Tukuy unkudukunatapish alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chayta Jesus rurarkan Tata Dios willashkanta rurananpa. Chay ñawpa yachachikuk Isaiyas killkarkan: “Payka rikchak laya unkuyninchikunamanta alliyachiwashkanchisapa. Tukuy laya nanayninchikunata kichuwarkanchisapa.” Chay killkadunpi rimashkanshina Jesus unkudukunata alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Chaymanta aypa runakuna Jesuspa ladunpi tantanakurkansapa. Jesuska chay runakunata kawashpa disipulunkunata willarkansapa: —Akuychi kay kochata chimbaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Manara kanowapi yaykuptinkunara Moisespa killkadunta yachachikuk runa Jesusta ladunchashpa willarkan: —Maestru, maytapish riptiki chaytami katishkayki. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Chaypina Jesuska willarkan: —Atukkunapa machaykunapi wasinkuna tiyan. Pishkillukunapapish wasinkuna tiyan. Ñuka sielumanta shamudu runa kashpaynipish mana nima wasiyukchu kani chaypi samanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chaypina Jesusta katik runa willarkan: —Señor, tatayni wañuptin pampashpaynira katishkayki. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chashna willaptin Jesus willarkan: —Kunanlla aku ñukawan. Tata Diosta mana kasunayak runakunaka paykunapura pampanakuchunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chashna parlashkankunawasha Jesuska disipulunkunawan suk kanowapi yaykurkansapa kochata chimbanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chimbaykaptinkuna kallarirkan sukaman wayrayta. Chay wayrawan yakuka sukaman olasyarkan yakallapa kanowata untachinankaman. Chay yaku wayrawan kuyuykaptinpish Jesuska kanowapi puñuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chaypina disipulunkunaka rirkansapa rikchachik. Sukaman manchakushpankuna willarkansapa: —¡Señor, salvawaysapa! Ñami suminayaykanchisapana. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesuska willarkansapa: —¿Imapatí sukaman manchakunkichi? ¿Manachu allitara kreyiwankichira? Chashna willashpa Jesuska atarishpa wayrata yakuta sinchita willarkan sampayananpa. Willaptinlla sampayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chayta kawashpankuna disipulunkunaka sukaman almirashpa tapunakurkansapa: —¿Pití kay runaka? Rimashpalla wayrata yakuta kasillayachin. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chaymanta chay kochata chimbashpankuna Gadara llaktapi Jesuska disipulunkunawan chayarkansapa. Chaypi ishkay supayadu ullkukuna tiyarkan. Paykuna sukaman supayadu karkansapa. Chay ishkay runakunaka wañudukunata pampashkankunapi kawsarkansapa. Paykuna sukaman sakra likidu kaptinkuna mana ni pi atiparkansapachu chay ñanta puriyta. Chaypina chay ishkay runakunaka Jesusta kawashpankuna laduncharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sinchita rimashpa willarkansapa: —Tata Diospa wambran Jesus ¿manara kastigawanaykipasapa tiempu chayamuptinra shamushkankichu kastigawaksapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chay supayadu runakunamanta mana karupichu aypa kuchikuna mikukuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chaypina chay runakunapi kawsak supaykunaka Jesustaka willarkansapa: —Kay runakunamanta llukshichiwashpaykisapa almitiwaysapa chay kuchikunapi yaykunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chashna willaptinkuna Jesus almitishpa willarkansapa: —¡Rillaychi! Jesus willaptinkunana chay supaykuna chay ishkay runakunamanta llukshirkansapa. Rirkansapa kuchikunapi yaykuk. Chaypina kuchikunaka kallpashpankuna urkumanta sinkushpa yakupi sipikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chayta kawashpankuna kuchikuna kuydak runakuna manchakuywan llaktankunaman kallparkansapa. Chaypi chayashpankuna tukuy llaktamasinkunata willarkansapa Jesus chay supayadu runakunata alliyachishkanta. Kuchikuna yakupi sipikushkankunata parlachikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chayta uyarishpankuna tukuy chay llaktapi kawsak runakuna rirkansapa Jesusta tarik. Jesusta kawashpankuna roygarkansapa llaktankunamanta llukshinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaymanta suk atun kanowapi yaykushpa Jesuska chimbarkan chay kochata. Chimbashpa kawsanan Nasaret llaktapi chayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaypina runakuna suk mana kuyuy atipak runata kamillapi payman pusharkansapa. Chay unkuduta pushamuk runakuna tukuy shunku kreyirkansapa Jesus alliyachinanta. Jesus kreyikushkankunata yachashpa chay unkuduta willarkan: —Wambrayni, ama manchakuychu. Tukuy uchaykikunamanta perdonayki. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chashna chay unkuduta willaptin Moisespa killkashkankunata yachachikuk runakuna piñakushpankuna yuyayninkunapi rimarkansapa: “Kay runaka Tata Diostami sukaman piñachiykan. Payka iden Tata Diosshina tukushpa kay unkuduta willashka tukuy uchankunamanta perdonananta.” ");
INSERT INTO qvsNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus chay runakunapa yuyayninkunata yachashpa willarkansapa: —¿Imapatí washanchawaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kay unkuduta ishkay layata atipayman willayta. Munashpayni willayman: “Uchaykikunamanta perdonayki.” Munashpayni willayman: “Atarimushpa rillay.” ");
INSERT INTO qvsNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kunanlla kay unkuduta alliyachisha. Alliyachiptini yachankichi ñuka sielumanta shamudu runa kanaynita. Yachankichi tukuy runakunapa uchankunata perdonayta atipanaynita. Chashna willashpa Jesuska chay mana kuyuy atipak runata willarkan: —¡Atarimuy! Kamillaykita apishpa wasikiman rillay. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chashna Jesus willaptinna chay unkudu runaka alliyaduna atarimushpa wasinman kutirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chayta kawashpankuna chay runakuna sukaman manchakurkansapa. Chaymanta Jesus runakunata alliyachishkanrayku Tata Diosta alabarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaymanta Jesus pasaykashpa ñuka Mateota kawawarkan. Maypicha romano awtoridarkunapa kullkita chaskikunaynipi tiyaridu karkani. Chaypina Jesuska kawawashpa willawarkan: —Shamuy ñukawan. Chashna willawaptin atarishpa Jesusta katirkani. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chaymanta disipulunkunawan Jesusta pusharkani wasinipi mikuk. Chaypina kullki chaskikukmasinikunawan mana alli rurak runakuna shamurkansapa tiyarik Jesuswan disipulunkunawan tantalla mikunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chaypina fariseo runakuna chayta kawashpankuna ñukaykunata willawarkansapa: —¿Imapatí maestruykichi Jesus kullki chaskikukkunawan uchasapa runakunawan tantalla mikuykan? ");
INSERT INTO qvsNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chaypina Jesus yuyaykanankunata uyarishpa suk ejempluwan yachachirkansapa: —Unkudu runa ampik runata sukaman maskan alliyachinanpa. Sanu runa mana nima ampik runata maskanchu sanu kashpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Rillaychi allita yachakumuychi imatami Tata Dios rimananpi yachachiwanchisapa nishpa. Paymi willawanchisapa: “Animalkunata kuyawashpa wañuchinaykichimanta ashwanta munani runamasikichita llakichishpa yanapanaykichipa.” Chayrayku ñuka shamushkani uchasapakunata uchankunamanta salvanaynipa. Manami shamushkanichu mana uchayuk yuyanakuk runakunata salvanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chaymanta Juan Bawtistapa disipulunkuna ladunchashpankuna Jesusta tapurkansapa: —Ñukaykunawan fariseo runakuna Tata Diosta kuyashpaynikuna churadu diyakuna amañanisapa mana nimata mikuyta. ¿Imapatí disipuluykikuna mana ñukaykunashina amañansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chayta tapuptinkuna Jesuska aynirkansapa: —Suk funsiapi invitadu runakuna noviowan tantalla kashpankuna mana llakinsapachu. Funsia washa novio sakiptinkuna chaypira churadu diyakuna mikunata mana mikunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Chaymanta Jesus ashwanta entiendichinayashpa willarkansapa: —Mana ni pi mawka llachapata tipi mushuk telawan remiendanmanchu. Chay llachapata takshaptin mushuk tela kintikushpa mawka llachapata ashwanta llikichin. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chaymanta mana ni pi llullu vinuta churanmanchu vinu churana mawka kapachupi. Chaypi churaptin llullu vinuka timbushpa mawka kapachuta pachyachinman. Kapachu llikikuptin vinuka usunman. Chay llikikudu kapachupish wakllidu kiparin. Chayrayku llullu vinuta mushuk kapachupi churansapa ama vinu ichakunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus chay runakunata yachachiykaptin suk runa laduncharkan. Payka tantanakunankuna wasipi kamachikuk runa karkan. Jesuspa ñawpakninpi kunkurikushpa willarkan: —Chaylla shipashnini chayrak wañushka. Aku wasiniman. Llankaptiki shipashnini kashkan kawsamunka. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chashna willaptin disipulunkunawan tantalla Jesuska chay kamachikuk runata katirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jesus riykaptin suk warmi katishpa laduncharkan. Payka yawar unkuywan chunka ishkay watata kawsarkan. Chay warmi washanmanta Jesuspa llachapan mañanta llankarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yuyarkan: “Jesuspa llachapanta llankashpaynilla alliyasha.” ");
INSERT INTO qvsNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chashna llankaptin Jesus washanta chapashpa chay warmita kawarkan. Chaypina llakichishpa willarkan: —Wambrayni, kushikuyna. Tukuy shunku kreyiwashkaykirayku sanuyachiyki. Chayta willaptin alliyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaymanta chay kamachikuk runapa wasinpi Jesuska chayarkan. Chaypi aypa runakuna sukaman kaparikushpa wakakuykarkansapa. Kena pukuk runakunapish listuna karkansapa chay wañuduta pampak pushanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Paykunata kawashpa Jesuska willarkansapa: —Kaymanta llukshiychi. Kay shipashka puñuykanmi. Manami wañuduchu. Puñuykananta willaptinkuna chay runakuna Jesusta sukaman asichirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chaypina Jesuska tukuyta washaman llukshichirkansapa. Chaymanta yaykushpa chay shipashta makinmanta apiptin kawsamushpa atarimurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chaymanta tukuy llaktakunapi sukaman famakurkansapa Jesus chay shipashta kawsachimushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chaymanta riykaptinna ishkay mana kawakuk runakuna sinchita kaparishpa Jesustaka katirkansapa. Willarkansapa: —¡Davidpa miraknin Jesus, ñukaykunatapish llakichiwaysapa! ");
INSERT INTO qvsNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus suk wasipi yaykuptin chay ishkay biskukunapish yaykushpa laduncharkansapa. Jesuska paykunata tapurkansapa: —¿Ariya kreyiwankichichu atipanaynita alliyachiynikichita? Paykunaka aynirkansapa: —Ariya, Señor, kreyiykisapami. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chaypina Jesuska ñawinkunata llankashpa willarkansapa: —Tukuy shunku kreyiwashkaykichirayku alliyachiykichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chashna willaptinna chay ishkay runakunaka allitana kawakurkansapa. Chaypina Jesuska paykunata sinchita willarkansapa: —Ama ni pita willaychichu ñuka alliyachishkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Chashna willaptinpish paykunaka tukuy chay llaktakunapi kawsak runakunata parlachirkansapa Jesus alliyachishkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chay ishkay runakuna llukshiykaptinkuna sukkuna Jesusman pushamurkansapa suk mana rimakuk runata. Chay runaka supayadu kashpa mana rimakuyta atiparkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesuska chay runamanta supayta llukshichirkan. Chaypina chay runaka atiparkan rimakuyta. Chayta kawashpankuna chay runakuna sukaman almirashpankuna willanakurkansapa: —Mana niman suk kuti kay Israel llaktapi kay laya alliyachikuk runata kawashkanchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Chaypina fariseokuna Jesusta sukaman washanchashpankuna willanakurkansapa: —Supaykunapa kamachikuknin kay runata yanapaptin supaykunata atipan llukshichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chaymanta Jesuska llaktan llaktan alliyachikuypi purirkan. Rikchak laya unkuywan nanaywan runakunata alliyachirkansapa. Tukuy llaktakunapi chayashpa tantanakunankuna wasikunapi yaykurkan yachachikunanpa. Yachachikushpa willarkansapa Tata Diospa mandunpi yaykunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesuska chay aypa runakunata kawashpa llakichirkansapa iden llakidu wishchudu ovejakunashina kaptinkuna ni pi kuydaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaypina Jesuska ñukaykunata willawarkansapa: —Chay aypa runakunaka iden pallanapa wayukunashinami. Tata Diospa rimananta yachachikuk runakunaka iden pallak peonkunashinami. Yachachikuk runakuna pishinsapa kay aypa runakunata yachachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chayrayku Tata Diosta roygaychi aypa yachachikukkunata kachanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaymanta Jesuska ñukaykunata chunka ishkay disipulunkunata kayawashpankuna willawarkansapa: —Kunanmantapacha ñuka yanapaptini kankuna atipankichi runakunamanta supaykunata llukshichiyta. Chaymanta atipankichi tukuy laya unkuyninkunamanta nanayninkunamanta alliyachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesuspa chunka ishkay disipulunkunapa shutinikuna kaykunami: Primeru karkan Simon. Paypa suk shutin karkan Pedru. Chaymanta Pedrupa wawkin Andres, Sebedeopa ishkay wambrankuna Santiagowan Juan karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Chaymanta Felipi, Bartolome, Tomas, Mateo karkanisapa. Ñuka Mateo romano awtoridarkunapa kullki chaskikuk karkani. Chaymanta Alfeopa wambran Santiagowan Tadeo karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Chaymanta suk karkan Simon. Payka romano gobiernuta mana kasunayak runa karkan. Chaymanta Judas Iskariote karkan. Payka Jesusta apichichirkan wañuchichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesuska ñukaykunata ishkay chunka disipulunkunata kachawashpankuna willawarkansapa: —Rillaychi judiyu runakunapa llaktankunallaman. Ama rillaychichu mana judiyukunapa llaktankunaman. Ama Samaria parti llaktakunapi yaykuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rillaychi israelmasikichillata yachachik. Paykunaka iden chinkadu ovejakunashina kawsaykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Rishpaykichi paykunata willaychi: “Tata Diosmi munan mandunpi kawsanaykichipa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chashna yachachikushpa lasaruyak runakunata alliyachiychi. Rikchak laya unkuyuk runakunatapish alliyachiychi. Wañudukunata kawsachimuychi. Supayadu runakunamanta supaykunata llukshichiychi. Tata Dios yanapashuptikichi tukuy chaykunata atipankichi rurayta. Payka mana chaninpachu sukaman yanapashunkichi. Chayrayku kankunapish mana kobrakushpalla tukuy kay willashkaynita ruraychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Rishpaykichi ama nima kullkita apaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ama nima pikshaykichita nima ushutaykichita nima bastonnikichita apaychichu. Rillaychi mudakushkaykichi llachapallawan. Chay runakunata yachachiptikichi paykuna karashunaykichi tiyan. Chayrayku ama nimata apaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Maykan llaktapi chayashpaykichi alli chaskikuk runata maskaychi. Paypa wasinpi kipariychi suk llaktaman rinaykichi diyakaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chay runapa wasinpi chayashpaykichi tukuy chaypi kawsakkunata allimata rimachiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Paykuna allita chaskishuptikichika Tata Diosta roygaychi kushichinankunapa. Mana allita chaskishuptikichika Tata Dios mana kushichinkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chay runakuna wasinkunapi mana chaskishunayaptikichika mana uyarishunayaptikichika wasinkunamanta llaktankunamanta chakikichi susyanta urmachishpa llukshiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Allita willaykichi: Tata Dios kastigakunan diya chay ñawpa Sodoma Gomorra llaktakunapi kawsak runakunata kastigankasapa. Chaymanta chay mana uyarishunayak runakunata ashwan sinchita kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Manara riptinikuna Jesuska yachachiwaysapallapi katirkan: —Mash allita uyariwaychi. Kankunata ovejatashina kachaykichi sakra likidu pumashina runakunata yachachinaykichipa. Chayrayku machakuyshina yachaysapa likidu kaychi. Yachaysapa kashpaykichi urpayshina alli modoyuk kuskata rurashpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sakra runakunamanta kuydanakushpa kawsaychi. Chiknishuk runakuna awtoridarkunapi chatashunkichi. Chaymanta tantanakunankuna wasikunapi makashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chashna rimanaynita yachachikuptikichi chay chiknishuk runakuna awtoridarkunaman ashwan sinchi kamachikukkunaman pushashunkichi. Tukuy paykunata mana judiyukunatapish atipankichi yachachiysapata. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Awtoridarkunaman pushashuptikichi ama manchakushpa yuyaychichu imatami willankichi nishpa. Chashna oras Tata Diosmi yachachishunkichi imatami rimankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tata Diospa Espiritun yanapashuptikichi atipankichi awtoridarkunata allita ayniyta. Manami kikikichipa yuyaynikichitachu rimankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Chaymanta chay chiknikuk runakuna wawkinkunata awtoridarkunapi chatankasapa wañuchichinankunapa. Chiknikuk tatakuna wambrankunata awtoridarkunapi chatankasapa. Chiknikuk wambrakuna tatankunata mamankunata awtoridarkunapi chatankasapa wañuchichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tukuy runakuna ñukata kreyiwashpa kawsashkaykichirayku kankunata chiknishunkichi. Chiknishuptikichipish wañunaykichi diyakaman ñukata mana shaykushpa kreyiwashpa kawsanaykichi tiyan. Chashna kreyiwashpa kawsaptikichi Tata Diosmi sieluman pushashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Suk llaktapi kawsak runakuna wañuchishunayaptikichika chikan llaktaman nitikuychi. Allita willaykichi: Manara kankuna tukuy Israel llaktakunapi yachachikuptikichira ñuka sielumanta shamudu runa kashkan shamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mana niman suk disipulu maestrunmanta ashwanta yachanchu. Mana niman suk peon patronninmanta ashwanta kamachikunchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Suk disipulu maestrunshina yachachikushpa kushikun. Chaymanta suk peon patronninshina kamachikushpa kushikun. Ñuka maestruykichi kaykaptini runakuna chikniwashpankuna rimansapa Satanas kanaynita. Chashna ñukapa rimashpankuna kankunapapish idenllata rimankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ama chiknishuk runakunata manchaychichu. Tata Diosmi paykunapa upallalla rimashkankunata pakallalla rurashkankunata yachashpa tukuy runakunapi rikurichinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ñuka kankunata pakallalla yachachishkaynita tukuy runakunata ama pakakushpa parlachiychi. Chaymanta upallalla willashkaynikunata tukuy runakunata sukaman yachachiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Runakuna wañuchishunayaptikichi ama manchaychichu. Paykunaka wañuchishushpaykichipish mana atipansapachu mana tukuyniyuk ninaman churashuynikichita. Tata Diosllami tukuy uchasapa runakunata mana tukuyniyuk ninapi churankasapa. Chayrayku payllata manchashpa kasushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Manachu ishkay pishkillukunata rantinsapa suk kullkillawan? Chay pishkillukuna mana ashwan chaniyuk kashpankunapish Tata Dios mana munaptin mana niman suk wañunmanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Tata Dioska tukuy kankunatapish allita kuydashunkichi. Pishkillukunamanta kankunata ashwanta kuyashunkichi. Sukaman kuyashushpaykichi allita yachan mashnami chukchaykichi tiyan nishpa. Chayrayku ama ni pita manchaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesus yachachiwaysapallapi katirkan: —Kankuna mana pinkakushpa runamasikichita willanaykichi tiyan kreyiwak runakuna kanaykichita. Chashna rimaptikichi ñukapish sielupi kawsak Tatayni Diosta willasha kankuna kreyiwak kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Chaymanta ichara runamasikichita pinkakushpa mana munankichimanchu rimayta ñukata kreyiwanaykichita. Chashna mana kreyiwanaykichita rimaptikichi ñukapish sielupi kawsak Tataynita willasha kankunata mana riksinaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesuska ñukaykuna disipulunkunata willawarkansapa: —Ñuka kay allpaman shamushkaynirayku aypa runakuna makanakunkasapa. Ama yuyaychichu ñuka shamushkaynirayku tukuy runakuna manana makanakushpana kawsanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ñuka shamushkaynirayku mana kreyiwak runakuna kreyiwak runakunata sukaman chikninkasapa. Ñukarayku suk wambra tatanta, suk shipash mamanta, suk nuera suedranta chiknishpa kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ñukata kreyiwashpa kawsaptikichi kikin familyaykichi chiknishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Chaymanta tataykichimanta mamaykichimanta wambraykichimanta ñukata ashwan allita kuyawanaykichi tiyan. Ñukata mana ashwan allita kuyawashpaykichika mana ñukapa disipuluynikunachu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Runakuna chiknishushpaykichi padesichishuptikichipish ñukallata allita kasuwashpa katiwanaykichi tiyan. Mana katiwashpaykichika mana ñukapa disipuluynikunachu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kankuna wañuymanta kishpinayashpa sakiwashpaykichika mana tukuyniyuk ninamanta mana kishpinkichichu. Chaymanta ñukata kreyiwashkaykichirayku runakuna padesichishushpaykichi wañuchishuptikichika Tata Dioswan mana tukuyniyukta kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kankuna rimanaynita yachachikuk riptikichi suk runakuna chaskishushpaykichi ñukatapish chaskiwaykansapa. Ñukata chaskiwashpankuna kachamuwak Tatayni Diostapish chaskiykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kankuna rimanaynita yachachikuk riptikichi sukkuna chaskishunkichi. Tata Dioska paykunata kankunatashina premyunta kunkasapa. Chaymanta alli rurak runakuna kaptikichi sukkuna chaskishunkichi. Paykunatapish kankunatashina Tata Dios premyunta kunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ñukata katiwashkaykichirayku ichara suk runa suk tipi chirik yakuta kushunkichiman. Tata Dios chay upyachishuk runata premyunta kunka. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesuska chunka ishkay ñukaykuna disipulunkunata yachachiwashkankunawasha rirkan Galilea parti llaktakunapi yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chay tiempu Juan Bawtista karselpi karkan. Chaypi kashpa yacharkan Jesus rikchak almirana ruranakunata rurashkanta. Chaypina Juanka ishkay disipulunkunata kacharkansapa Jesusta tapuk: ");
INSERT INTO qvsNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Deveraschu Tata Diosmanta shamudu runa kanki? ¿Suktachu shuyashasapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chashna tapuptinkuna Jesuska aynirkansapa: —Rillaychi Juanta willak uyarishkaykichita kawashkaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Juanta willaychi ñuka alliyachiptini mana kawakukkuna kawakuykanankunata kojokuna puriykanankunata upakuna uyariykanankunata. Willaychi lasaruyak runakunatapish alliyachishkaynita. Willaychi wañudu runakunata kawsachimushkaynita. Chaymanta tukuy mana nimayuk runakunata yachachiykanisapa Tata Dios salvakuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chaymanta Juanta willaychi tukuy runakuna mana pinkakushpa ñukata allita kreyiwashpa kushikuypurulla kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chaymanta Juanpa disipulunkuna kutiptinkuna Jesuska chay aypa runakunata willarkansapa: —¿Imatatí rishkankichi kawak chunlla pampapi? ¿Rishkankichichu kawak pintuta wayra kuyuchiptin? ");
INSERT INTO qvsNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mana chayta kawak rishpaykichika ¿imatatí kawak rishkankichi? ¿Allima llachapayuk runatachu? Kankunaka allita yachankichi allima llachapayuk runakuna kamachikuk runakunapa wasinkunallapi kawsanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ariya ¿imatatí rishkankichi kawak? ¿Alli yachachikuk runatachu? Ariya deverasmi rishkankichi alli yachachikuk runata kawak. Payka tukuy alli yachachikukkunamanta ashwan alli yachachikukmi. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ñawpa tiempu Tata Dioska killkadunpi Juanpa rimarkan: “Ñukaka suk alli yachachikukta kachasha tukuy runakunata willanankunapa kachamushkayni runata allita chaskinankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mash allita uyariwaychi. Chay yachachikuk Juanka tukuy runakunamanta ashwan alli yachachikukmi karkan. Chashna kaptinpish Tata Diospa mandunpi tukuy mana kreyinakuk runakuna Juanmanta ashwan yachaysapakunami kankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan Bawtista shamushkanmantapacha kunankaman aypa runakuna Tata Diospa mandunpi sukaman sinchikushpa yaykunsapa. Paykunaka sukaman sufrishpankunapish mana manchakushpa sukaman munashpa yaykunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Manarapish Juan Bawtista shamuptinra Moiseswan ñawpa yachachikuk runakuna yachachikurkansapa Tata Dios tukuy maypi kamachikunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chaymanta Tata Dios killkadunpi willawanchisapa: “Suk alli yachachikukta ñawpa Eliyastashina kachasha.” Chay Eliyasshina alli yachachikuk runaka Juanmi. Munashpaykichika kay yachachishkaynita kasuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tukuy kay yachachikushkaynita allita rinrillikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Imashna kanaykichita willaykichiman? ¿Ima ejempluwantí yachachiykichiman? Kankunaka plasapi tiyarishpa pukllak wambrakunashinami kankichi. Chay wambrakuna pukllak wambramasinkunata kaparishpa willansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ñukaykuna kenata pukuptinikuna kankuna mana tushushkankichichu. Llakinapa laya kantukunata kantaptinikuna mana wakashkankichichu.” ");
INSERT INTO qvsNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kankuna chay pukllak wambrakunashina mana nimawan agradakunkichichu. Juanka Tata Diosta kuyashpa aypa diyakunata mana nimata mikushpa nimata upyashpa kawsarkan. Chashna Juan amañaptin kankuna rimankichi supayadu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ñuka sielumanta shamudu runa mikuptini upyaptini rimankichi illu likidu kanaynita. Chaymanta rimankichi uchasapa runakunawan romano awtoridarkunapa kullki chaskikukkunapa purikmasinkuna kanaynita. Chashna rimaptikichipish willaykichi: Tukuy pi allita rurashpa kawsashpa runamasinkunata kawachinsapa yachaysapa kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chaymanta Jesuska suk llaktakunapi kawsak runakunata kallarirkan piñayaysapata. Chay llaktakunapi aypa almirana milagrukunata rurashka kaptinpish chay runakuna mana uchankunamanta wanarkansapachu. Jesus piñakushpa sinchita willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Alaw! Korasinpi Betsaidapi kawsak runakunata llakichini. Chay ishkay llaktakunapi kashpayni aypa almirana milagrukunata rurashkani. Chaykunata kawashpankunapish uchankunamanta mana nima wananayansapachu. Chayrayku Tata Dioska paykunata sukaman kastigankasapa. Tiro llaktapi Sidon llaktapi almirana milagrukunata rurashka kaptini chaypi kawsakkuna uchankunamanta wananmansapa karkan Tata Diosta kreyinankunapa. Llakina llachapakunata churakushpankuna uchpata umankunapi churanmansapa karkan llakinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chayrayku kastigakunan diya Tata Dioska chay Tiropi Sidonpi kawsak runakunamanta Korasinpi Betsaidapi kawsak runakunata ashwanta kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chaymanta Kapernaumpi kawsak runakuna yuyansapa sieluman riyta Tata Dioswan kawsak. Chashna yuyashpankunapish Tata Dios manami sielumanka pushankasapachu. Mana ñukata kreyiwashkankunarayku manllayba tuta likidu uchkuman kachankasapa. Chay ñawpa Sodoma llaktapi almirana milagrukunata rurashka kaptinika chay llaktapi kawsak runakuna kreyiwanmansapa karkan. Kreyiwashpankuna chay llakta kunankaman tiyanmanlla karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chayrayku willaykichi: Tata Dios kastigakunan diya ñawpa Sodoma llaktapi kawsak runakunamanta ashwan sinchita Kapernaumpi kawsak runakunata kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesus chay runakunata yachachishkankunawasha Tatan Diosta willarkan: —Tatayni, kay allpapi chay sielupi allima kamachikukmi kanki. Kanka tukuy mana kreyinakuk runakunallata allita yachachinki. Chaymanta kikinkunallamanta yachak runakunata mana nimata yachachishkankichu. Chayrayku, Tatayni, sukaman alabayki. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ariya, Tatayni, kushikushpa chashna munashkanki rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesus Tatanwan parlashkanwasha chay runakunata yachachirkansapa: —Tataynika willawarkan ñukalla tukuy layata kamachikunaynipa. Payllami ñukata allita riksiwan. Kankunaka manami allitachu riksiwankichi. Tata Diospa wambran kashpayni ñukallami payta allita riksini. Ñuka munashkayni runakunata riksichiptini paykunalla Tataynita riksinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kankuna llakidu shaykudu kashpaykichika ñukaman shamuychi. Shamuptikichi tukuy llakinaykichimanta samachishkaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ñuka yachachikunaynika iden animal aysanan timonshinami. Yachachikunaynita kasushpaykichi timonta aysakshina kankichi. Chayrayku ñukamanta yachakuychi. Ñukaka mana piñakushpa allillapi yachachiykichi. Ñukaman shamushpaykichi ñukata kasuwashpaykichi kushikuypuru kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Atipanaykichi layallata yachachiykichi ruranaykichipa. Ñuka yanapaptini atipankichi kasuwashpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chaymanta suk samana diya Jesuska ñukaykunawan suk trigu chakra chawpinta pasarkanisapa. Chaypina yarkashpaynikuna triguta tipirkanisapa mikunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mikuykaptinikuna fariseo runakuna kawawarkansapa. Chashna kawawashpankuna Jesusta willarkansapa: —Mash kaway. Disipuluykikuna samana diya kaykaptin triguta tipishpa Moisespa kamachikunankunata mana kasuykansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Chashna willaptinkuna Jesuska aynirkansapa: —Ariya, kawaykani imatami ruraykansapa nishpa. Samana diya pallashpankunapish manami uchallikuykansapachu. ¿Manachu leyishkankichi ñawpa kamachikuk David rurashkanta? Suk kuti payka purikmasinkunawan sukaman purishpankuna yarkarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yarkaymanta kashpa Tata Diospa wasinpi yaykurkansapa. Chaypi Davidka Tata Diospa churadu pankunata mikurkan. Purikmasinkunatapish kararkan. Chay laya pankunaka saserdotekunallapa karkan. Chayta mikushpankunapish mana uchallikurkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Manachu leyishkankichi ñawpa Moisespa killkadunpi rimashkankunata? Chaypi willawanchisapa saserdotekuna Tata Diospa wasinpi tukuy diya trabajanankunata. Paykuna samana diyakuna mana samashpapish manami uchallikunsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mash uyariwaychi. Chay Tata Diospa wasinpi trabajak saserdotekunamanta ñukami ashwan kamachikuk kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tata Dioska rimananpi willawanchisapa: “Kankuna wiwa animalnikichita wañuchishpa rupachinaykichi tiyan ñukata kuyawanaykichipa. Chay animalnikichita rupachishkaykichimanta ashwanta munani runamasikichita llakichishpa yanapanaykichipa.” Chashna Tata Dios rimaptinpish kankunaka mana entiendishkankichichu. Allita entiendishpaykichika kay disipuluynikunata mana willankichimanchu karkan samana diya tipi triguta tipishpa uchallikuykanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ñuka sielumanta shamudu runa kashpayni ashwan alli kamachikuk kani willanaynipa imakunatami samana diya rurankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chay chakramanta llukshishpa Jesuska suk tantanakunankuna wasipi yaykurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypi suk kaspirayadu makiyuk runa karkan. Chaypina fariseo runakuna Jesusta chiknishpa chapaykarkansapa chatanankunapa. Pantachinayashpankuna Jesusta tapurkansapa: —¿Ariya Moisespa killkadun willawanchichu samana diya suk unkuduta alliyachinanchikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chaypina Jesuska aynirkan: —Samana diya suk ovejaykichi uchkupi urmaptin ¿manachu surkunkichiman? ");
INSERT INTO qvsNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ñukanchikuna ovejanchimanta ashwan allita runamasinchikunata kuyanchisapa. Chayrayku alli kanman samana diya runamasinchikunata yanapananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chashna paykunata willashpa Jesuska chay kaspirayadu makiyuk runata willarkan: —¡Makikita chutachiy! Chaypina chay runaka Jesusta kasushpa kaspirayadu makinta chutachiptin iden suk ladu makinshina alliyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Samana diya Jesus chay runata alliyachiptin fariseo runakuna chay tantanakunankuna wasimanta llukshishpankuna kallarirkansapa yuyaykuyta Jesusta wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus fariseo runakuna wañuchinayanankunata yachashpa chay llaktamanta llukshirkan. Llukshiptin aypa runakuna katirkansapa. Chaypina tukuy unkudukunata alliyachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chaymanta chay alliyachishkan runakunata willarkansapa: —Amara famakunkichirachu alliyachishkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesus chayta rurashpa chay ñawpa yachachikuk Isaiyas rimashkantashina ruraykarkan. Kashna Tata Dios rimashkanta Isaiyas killkarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kaypimi sirviwaknini. Ñukami paytaka kuyashpa akllarkani. Paymi ñukata kushichiwan. Paytami Espirituynita kusha. Payka tukuy allpapi kawsak runakunata yachachinkasapa ñuka alli rurak kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Payka manami ni pita piñayankachu ni pita kaparichinkachu. Kallikunapi mana ni piwan ayninakuptin uyarinkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Payka pataranakuk pintuta mana pakinkachu. Wañunayak alkusata mana wañuchinkachu. Tukuy llakishpa shaykushpa kawsak runakunata mana washanchashpa llakichishpa yanapankasapa. Sukaman allita kamachikunka tukuy runakuna yachanankunapa allillata rurashpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chaypina aypa llaktakunapi kawsak runakuna payta shuyankasapa salvanankunapa.” Ñawpa yachachikuk Isaiyaska chayta killkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaymanta Jesusman supayadu runata pushamurkansapa. Chay runaka supayadu kashpa mana nima kawakuyta nima rimakuyta atiparkanchu. Jesus payta alliyachiptin atiparkanna kawakuyta rimakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chayta kawashpankuna tukuy runakuna sukaman almirashpankuna tapunakurkansapa: —¿Kay runachu shuyaykananchi ñawpa kamachikuk Davidpa miraknin? ");
INSERT INTO qvsNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chashna chay runakuna tapunakuptinkuna fariseo runakuna Jesusta mana kreyishpankuna rimarkansapa: —Kay Jesuska atipan runakunamanta supaykunata llukshichiyta supaykunapa kamachikuknin Belsebu yanapaptin. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Chay fariseo runakuna yuyashkankunata yachashpa Jesuska willarkansapa: —Suk llaktapi kawsak runakuna chikninakushpa makanakushpankuna kikinkunapura kulluchinakunsapa. Chaymanta suk wasipi kawsak runakuna chikninakushpa makanakushpankuna chayta chayta anchunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chashnallami supaykunapish kikinkunapura karkunakushpankuna wakllichinakunsapa. Kikinkunalla kulluchinakunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kankunaka rimankichi supaykunapa kamachikuknin Belsebu yanapawaptin supaykunata llukshichinaynita. Chashna rimashpaykichi mana kuskatachu rimaykankichi. Belsebu yanapawaptinka ¿pití kankunapa disipuluykikunata yanapan supaykunata llukshichinankunapa? Allita yachankichi Tata Dios yanapanankunata. Chayrayku ñukata yuyawashpaykichi sukaman llullachinakuykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tata Diospa Espiritun yanapawaptin supaykunata atipani llukshichiyta. Chayrayku allita yachanaykichi tiyan Tata Dios ñukata kachamuwashkanta. Ñuka yachachiykichi Tata Dios kankunata kamachishunaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mana ni pi suk sinchi runapa wasinmanta atipanmanchu nimata apayta manara payta allita watashpara. Chay sinchi runata watashpara tukuy laya tiyapunankunata atipanman kichuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kankuna mana kreyiwashpaykichi chikniwankichi. Mana yanapawashpaykichi sukkunata ñukamanta ashuchiykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mash allita uyariwaychi. Tata Dioska runakunata tukuy uchankunamanta tukuy mana alli rimashkankunamantapish perdonankasapa. Chaymanta mana kutin perdonankachu Tata Diospa Espiritunta washanchashpa sakra mana alli kananta rimaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ñukaka sielumanta shamudu runami kani. Chashna kaptinpish suk runa mana alli kanaynita rimaptinpish Tata Dioska payta perdonanka. Chaymanta suk runa Tata Diospa Espiritunta washanchashpa chiknishpa sakra mana alli kananta rimaptin Tata Dioska manami paytaka perdonankachu. Nima kunan kay tiempu nima wañushkanwasha perdonankachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Chaymanta Jesuska yachachikuyllapi katirkan: —Kankuna alli wayuchakuk kaspita kuydashpaykichi alli wayukunata pallankichi. Mana allita kuydaptikichi mana allitachu wayuchakun. Kaspikunapa wayunkunata kawashpaykichira riksinkichi chay kaspi allichu manachu nishpa. Allita rurashpa kawsaptini riksiwankichi alli wayuchakuk kaspishina kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kankuna fariseokuna sukaman llullachikushpaykichi machakuyshina kankichi. Mana alli rurak runakuna kashpaykichi mana atipankichichu allikunata rimayta. Tukuy runa shunkunpi yuyananllata riman. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tukuy alli yuyayuk runa allikunallata rimashpa kawsan. Tukuy mana alli yuyayuk runa mana allikunata rimashpa kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mash allita uyariwaychi. Kastigakunan diya Tata Dioska tukuy mana alli rimashkankunarayku runakunata kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tata Dioska willashunkichi rimashkaykichi allichu manachu nishpa. Chaypina rimashkaykichi alli kaptinka payka mana kastigashunkichichu. Rimashkaykichi mana alli kaptinka sukaman kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jesus yachachikuykaptin fariseo runakuna Moisespa killkadunta yachachikuk runakuna uyarirkansapa. Chaypina willarkansapa: —Maestru, yachanayanisapa deveraschu manachu Tata Diosmanta shamudu runa kanaykita. Chayrayku munanisapa kawayta almirana milagrukunata ruraptiki. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chaypina Jesuska willarkansapa: —Kankuna Tata Diosta mana kreyishpa mana alli rurak runakuna kashpaykichi mañawankichi almirana milagruta ruranaynipa. Kankunapaka manami rurashachu chay laya milagruta. Tata Dios ñawpa yachachikuk Jonaspa suk milagruta rurarkan. Ñukapapish chay layallata ruranka. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Suk atun challwa Jonasta millpurkan. Chaypina chay challwa wiksanpi kimsa diyata kimsa tutata payka karkan. Chay kimsa diya paktaptinna chay challwaka Jonasta kipnamurkan. Ñuka sielumanta shamudu runa iden Jonasshina kimsa diyata kimsa tutata allpa ukupi kashkaynimanta atarimusha. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chay ñawpa Ninive llaktapi kawsak runakuna sukaman mana allikunata rurashpankuna kawsarkansapa. Chaymanta chay yachachikuk Jonas yachachikuptin paykunaka uchankunamanta wanarkansapa Tata Diosta allita kasushpa kawsanankunapa. Chay kastigakunan diya chay ñawpa Ninivemanta runakuna kankunata chatashunkichi mana kreyiwashkaykichirayku. Ñuka Jonasmanta ashwan alli yachachikuk kaptinipish mana kreyiwanayankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chaymanta ñawpa tiempu suk karu llaktamanta suk kamachikuk warmi shamurkan yachaysapa Salomonta uyarik. Ñuka Salomonmanta ashwan alli yachaysapa kaptinipish kankunaka mana kreyiwanayankichichu. Chayrayku Tata Dios kastigakunan diya chay kamachikuk warmi kankunata chatashunkichi mana kreyiwashkaykichirayku. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Chaymanta Jesuska willarkansapa: —Suk runamanta supay llukshishpa chakidu chunlla allpapi purin samanayashpa. Mana ni maypi samananta tarishpa yuyaykushpa riman: ");
INSERT INTO qvsNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Shu kutishalla chay llukshimushkayni runallaman.” Chay runaman kutishpa tarin iden suk chunlla wasi chuya chuya pichadutashina. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaypina kanchis ashwan mana alli rurak supaymasinkunata rin kayak. Tukuy paykuna rinsapa chay runapi kawsak. Chashna modomanta chay runaka ashwan mana allikunata rurashpana kawsan. Kankuna sukaman mana alli rurak kashpaykichi iden chay aypa supayuk runashinami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus chay runakunata yachachiykaptin paypa mamanwan wawkinkuna chay wasiman rirkansapa. Paykunaka Jesuswan parlanayashpankuna wasi washallamanta kayachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chaypina suk runa Jesusta willarkan: —Mamaykiwan wawkikikuna parlachishunayankisapa. Washapi shuyashuykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chaypina Jesuska chay runataka willarkan: —¿Pití mamaynika? ¿Pití wawkinikunaka? ");
INSERT INTO qvsNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chaymanta disipulunkunata makinwan apuntashpa tukuy runakunata willarkansapa: —Kaykunami mamayni. Kaykunami wawkinikuna. ");
INSERT INTO qvsNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kankuna paykunashina sielupi kawsak Tatayni Diospa munananta rurashpa kawsashpaykichi ñukapa wawkinikuna paninikuna mamaynikuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay diyalla Jesuska chay wasimanta llukshishpa rirkan kocha mañanpi tiyarik. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chaypi tiyariptin aypa runakuna laduncharkansapa. Chaypina suk kanowapi Jesuska yaykurkan tiyarik chay kanowamanta yachachikunanpa. Yachachikuptin tukuy chay runakuna kocha mañanmanta uyarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaypina Jesuska chay aypa runakunata rikchak laya ejemplukunata parlachishpa yachachirkansapa. Willarkansapa: —Mash uyariwaychi. Suk runa rirkan murukunata chakranpi tarpuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chaypina murukunata shikwashpa tarpuptin sukkuna ñanpi urmarkansapa. Pishkillukuna chay ñanpi urmadu murukunata mikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Suk murukuna urmarkansapa rumisapa allpapi. Chay murukuna allpa sawallapi kashpa utka shurayarkansapa allpa mana rakta kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Chay allpa rumisapa kaptin chay murukuna mana atiparkansapachu sapichakuyta. Chayrayku rupay nanaptin chakirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Chaymanta suk murukuna urmarkansapa kashasapa allpapi. Chaypina kashakuna ashwanta wiñashpa chay wiñaykak murukunata makarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Suk murukuna urmarkansapa allima allpapi. Chaypina wiñashpankuna sukaman allita wayuchakurkansapa. Suk murukuna mirarkansapa pachak murukunata. Sukkuna mirarkansapa sokta chunka murukunata. Sukkuna mirarkansapa kimsa chunka murukunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kankuna uyariwashpaykichika allita rinrillikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chaymanta ñukaykuna disipulunkuna Jesusta ladunchashpaynikuna tapurkanisapa: —¿Imaraykuti chay runakunata ejemplukunata parlachishpa yachachinkisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chaypina Jesuska ayniwarkansapa: —Tata Dios kankunallata yachachishuykankichi paypa mandunpi yaykunaykichipa. Manara kutin yachachishushkaykichita kunanka yachachishuykankichi. Suk runakuna mana kasunayaptinkuna Tata Dios mana kankunatashinachu yachachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tata Dioska tukuy kreyikukkunata sukaman yanapanka ashwanta entiendinankunapa. Chaypina ashwanta kreyikunkasapa. Mana kreyikukkunata tipi yachashkankunatapish kunkachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chay runakunata yachachiptinipish mana entiendinsapachu. Tukuy alli rurashkaynikunata kawashpapish mana yachansapachu imaraykumi chaykunata rurashkani nishpa. Chayrayku ejemplukunallawan paykunata yachachini. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ñawpa tiempu alli yachachikuk Isaiyas kay mana uyarinayak runakunapa killkarkan: “Kay runakuna alli yachachikunaynita uyarishpapish mana nima entiendinkasapachu. Alli rurashkaynita kawashpankunapish mana entiendinkasapachu imaraykumi rurashkani nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay runakunapa shunkunkuna sinchi likidumi. Rinrinkunata wichkansapa ama uyariwanankunapa. Ñawinkunatapish wichkansapa alli rurashkaynita ama kawanankunapa. Mana munansapachu rimashkaynita entiendiyta. Mana munansapachu ñukaman shamuyta sanuyachinaynipasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Chaymanta Jesuska ñukaykunallata willawarkansapa: —Kankuna sukaman kushikuypuru kankichi rurashkaynita kawashpaykichi. Sukaman kushikuypuru kankichi yachachikuptini uyarishpaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Allita willaykichi. Ñawpa yachachikuk runakuna alli rurak runakunapish sukaman munarkansapa kawanaykichita kawayta. Munarkansapa uyarinaykichita uyariyta. Chashna munashpankunapish mana kawarkansapachu nima uyarirkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mash uyariwaychi. Yachachiykichi chay muru tarpukuk runapa ejemplun imatami riman nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aypa runakuna sinchi shunkuyuk kashpa iden ñanpi chakidu sarudu allpashina. Chay laya runakuna Tata Diospa rimananta uyarishpankunapish mana entiendinsapachu. Chaypina chay pishkillukuna ñanpi urmadu murukunata mikukshina supay shamun Tata Diospa rimananta kunkachinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chaymanta suk runakuna Tata Diospa rimananta kushikushpa uyarinsapa. Chay laya runakuna iden rumisapa allpapi wiñak murukunashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mana ukupi sapiyukshina kashpankuna suk tiempullata kushikushpa Tata Diosta katinsapa. Paykuna kreyikushkankunarayku sufrishpankuna nanayta llakita mallishpankuna manana munansapanachu Tata Diosta katiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chaymanta suk runakuna Tata Diospa rimananta uyarishkankunamanta munanankunallata rurashpa kawsansapa. Sukaman kullkiyayta munashpalla kawsansapa. Chay laya runakunaka iden kashasapa allpapi wiñak murukunashinami. Mana nima wayuchakunsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Chaymanta suk runakuna Tata Diospa rimananta uyarishpa tukuy shunku kreyishpa entiendinsapa. Chay laya runakuna iden chay alli allpapi wayuchakuk murukunashinami. Sukkunaka pachak murukunata wayuchakukshinami. Sukkunaka sokta chunka murukunata wayuchakukshinami. Sukkunaka kimsa chunka murukunata wayuchakukshinami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chaymanta Jesuska yachachikushpa chay aypa runakunata willarkansapa: —Mash uyariwaychi. Tata Dios mandunpi kamachikushpa iden suk runa chakranpi alli trigu murukunata tarpukshinami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Chaymanta suk tuta tukuy pi puñuykaptinkuna chakrayukta chiknik runa chay trigu tarpudu chakraman rishpa mana alli kiwa murukunata tarpurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chaymanta trigu wiñaykaptin chay mana alli kiwapish sukaman wiñarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaypina trabajadorkuna chakrayuk runata willarkansapa: “Señor, kan alli murukunata tarpuchiptiki ¿imapati mana alli kiwakuna wiñaykansapa?” ");
INSERT INTO qvsNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chay chakrayuk runa aynirkansapa: “Suk chikniwak runami mana alli kiwa murukunata tarpushka.” Chashna willaptin trabajadorkuna tapurkansapa: “¿Munankichu rinaynikunapa chay mana alli kiwakunata tipik?” ");
INSERT INTO qvsNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chaypina chakrayuk runaka willarkansapa: “Amara tipiychirachu. Mana alli kiwakunata tipishpaykichika ichara trigukunatapish tipinkichiman. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tantalla wiñachunsapa trigu pallananchi diyakaman. Alli trigu pukuptinra pallak runakunata willasha tukuy mana alli kiwakunata tipishpa tantanachinankunapa. Chay mana alli kiwata wata wata rurashpa rupachinkasapa. Chaymanta alli triguta pallashpa wakaychankasapa murukuna churana wasinipi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Chaymanta Jesuska chay runakunata suk ejempluta yachachirkansapa: —Kunan yachachiykichi imashnami Tata Diospa mandunpi kawsankichi nishpa. Mostasa murillun tukuy laya murukunamanta ashwan kishnisillu. Suk runa chakranpi tarpuptin chay murilluka allita wiñan. Kishnisillu kashpapish chay muruka tukuy kiwakunamanta ashwan atunta wiñan. Iden kaspishina sukaman ramachakun. Chay ramankunapi aypa pishkillukuna wasinkunata ruransapa. Kankuna chay kishnisillu murukunashinami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Chaymanta Jesuska kashkan yachachikushpa chay runakunata willarkansapa: —Yachachiykichi imashnami Tata Diospa mandunpi kawsankichi nishpa. Suk warmi panta rurashpa kimsa pati trigupa machkanta yakuwan chakrun. Chaymanta tipi levaduratapish churan chay chapuduta allita punkichinanpa. Kankuna Tata Diospa mandunpi kawsashpaykichi chay alli levadurashina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesuska rikchak laya ejemplukunawan parlachikushpa chay runakunata yachachirkansapa. Mana ejempluta parlachikushpa mana yachachikukchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ñawpa tiempu suk yachachikuk runa killkashpa rimarkan Jesus ejemplukunata parlachikushpa yachachikunanta. Chay killkadunpi riman: “Ñuka rikchak laya ejemplukunata parlachishpayni runakunata yachachisha. Tata Dios kay allpata rurashkanmantapacha mana ni pi yachashkanta yachachikusha.” ");
INSERT INTO qvsNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chaymanta Jesus chay aypa runakunata wasinkunaman kutinankunapa willashpa suk wasipi yaykurkan. Chaypi ñukaykuna ladunchashpaynikuna willarkanisapa: —Chay mana alli kiwakunapa ejemplunta parlachiwashpaykisapa ¿imatati yachachiwashkankisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chaypina Jesuska ayniwarkansapa: —Ñuka sielumanta shamudu runa kashpayni alli murukunata tarpukuk runashinami kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kay allpapi kawsak runakuna iden chakrashinami. Tata Diosta kasushpa kawsak runakunaka iden chay alli murukunashinami. Supaypa mandunpi kawsakkunaka iden chay mana alli kiwakunashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Supayka iden chay chakrapi mana alli murukunata tarpuk runashinami. Kay allpa tukunan diya iden chay trigu pallana diyashinami. Chaymanta angelkuna iden triguta pallak trabajadorkunashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kay allpa tukunan diya Tata Dioska tukuy uchasapa runakunata kastigankasapa. Payka iden chay mana alli kiwakunata shuntushpa rupachik runashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ñuka sielumanta shamudu runa kashpayni angelninikunata kachamusha tukuy maymanta mana alli rurak runakunata tantachinankunapa. Chaymanta runamasinkunata uchallichikuk runakunatapish tantachishasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Chaypina mana tukuyniyuk ninaman paykunata wishchushasapa. Chaypi chay runakuna nanayta mana muchushpankuna kirunkunata mukushpankuna sukaman wakankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chaymanta Tata Diospa munananta rurak runakuna Tatankunapa mandunpi yaykushpa iden intishina llipyankasapa. Kankuna rinriyuk kashpaykichi allita uyariwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Chaymanta kashkan yachachikushpa Jesuska willarkansapa: —Tata Diospa mandunka iden aypa chaniyuk kurishinami. Suk runa chikanpa chakranpi pakadu kurita tarirkan. Chayta tarishpa kashkan chayllapi pakarkan. Kushikuypuru chay kuriyuk chakrata rantinanpa tukuy tiyapushkankunata rantikurkan. Chaypina chay kuriyuk chakrata rantirkan. Chashnashina kankuna sukaman munanaykichi tiyan Tata Diospa mandunpi kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Chaymanta chikan ejempluta willaykichi. Tata Diospa mandunka iden aypa chaniyuk perlasshinami. Suk rantikuk runa allima yurak perlaskunata maskashpa purirkan rantinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sukaman maskashpa suk aypa chaniyuk ashwan allima perlasta tarirkan. Chaypina tukuy tiyapushkankunata rantikurkan chaypa chaninwan chay ashwan allima perlasta rantinanpa. Chashnashina kankuna sukaman munanaykichi tiyan Tata Diospa mandunpi kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Chaymanta Jesuska kashkan yachachikushpa willarkansapa: —Kunan yachachiykichi imashnami Tata Diospa mandunpi yaykunkichi nishpa. Aypa runakuna atun redninwan rikchak laya challwakunata apinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chaymanta aypa challwakuna redninwan wichkashpa chay runakuna kocha mañanman aysansapa. Chaypi tiyarishpa challwakunata akllansapa. Alli challwakunata sestunkunapi churansapa. Mana alli challwakunata wishchunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chaymanta kay allpa tukunan diyapish iden chay challwakunata apik runakunashina angelkuna runakunata akllankasapa. Tata Diosta kuyashpa kawsak runakunamanta mana alli rurak runakunata suchuchinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chaymanta tukuy mana alli rurak runakunata wishchunkasapa mana tukuyniyuk ninaman. Chaypi nanayta mana muchushpankuna kirunkunata mukushpankuna sukaman wakankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chaymanta Jesuska ñukaykuna disipulunkunata tapuwarkansapa: —¿Entiendinkichichu tukuy chay yachachishkaynikunata? Chaypina aynirkanisapa: —Ariya entiendinisapami. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chaypina Jesuska willawarkansapa: —Suk wasiyuk runa wasinpi aypa mushuk aypa mawka wakaychadu tiyapunankunata surkumun suk runata kawachinanpa. Chay kawachikuk runaka Tata Diospa killkadunta yachachikuk runakunashinami. Paykunaka Tata Diospa mandunpi yaykushpa yachansapa mushuk layata ñawpa yachashkankunata yachachikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chaymanta tukuy chay ejemplukunawan yachachikushkanwasha chay llaktamanta Jesuska llukshirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chaypina kikinpa llaktanpi chayashpa tantanakunankuna wasipi Tata Diospa rimananta yachachikurkan. Chaypina tukuy chay runakuna sukaman almirashpankuna rimarkansapa: —¿Maypití kay runaka tukuy layata yachakushka? ¿Imashnatí atipan almirana milagrukunata rurayta? ");
INSERT INTO qvsNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu kay runaka karpinterupa wambran? ¿Manachu paypa maman Mariya? ¿Manachu wawkinkuna Jakobo, Jose, Simon, Judas? ");
INSERT INTO qvsNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Manachu paninkuna llaktamasinchikunalla? ¿Pití payta yachachishka chay layata yachananpa? ");
INSERT INTO qvsNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chay runakuna Jesus llaktamasinkuna kaptinkunapish mana nima kasunayarkansapachu. Chaypina Jesuska willarkansapa: —Suk runa Tata Diospa rimananta yachachikuptin llaktamasinkuna familyankuna mana kreyinsapachu. Chikan llaktakunapi yachachikuptin chaypira sukaman allita uyarinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chashna llaktamasinkuna mana kreyinayaptinkuna Jesuska llaktanpi mana aypa almirana milagrukunata rurarkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay tiempu Galilea partipi sinchi kamachikuk Herodes uyarirkan Jesus aypa almirana milagrukunata rurashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chaypina Herodeska sirvikninkunata willarkansapa: —Ichará chay Jesuska wañuchichishkayni Juan. Ichará Juan Bawtista wañushkanmanta kawsamushka. Chayrayku atipan almirana milagrukunata rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodeska tukuy chayta rimarkan Juanta wañuchichishkanta yuyashpa. Ñawpana Juanta kadenakunawan watachishpa karselpi wichkachirkan. Chayta rurarkan warmin Herodiyas munaptin. Chay warmin Herodiyaska ñawpa Herodespa wawkin Felipipa warmin karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kuñadanwan kawsaptin Juanka Herodesta willarkan: —Kuñadaykiwan uchallikushpa kawsashpayki mana allitachu ruraykanki. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chayta willashkanrayku Herodes Juantaka wañuchichinayarkan. Wañuchichinayaptinpish tukuy runakuna yuyarkansapa Juan Tata Diospa rimananta yachachikuk kananta. Chayrayku chay runakunata manchashpa mana animukurkanchu wañuchichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chaymanta Herodeska watan paktashkanrayku suk fiestata rurarkan. Chay fiestapi warmin Herodiyaspa shipashnin tushurkan tukuy konvidadukunapa ñawpakninkunapi. Chashna tushushpa Herodestaka sukaman kushichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayrayku Herodes chay shipashtaka jurashpa prometirkan: “Imatapish mañawaptiki kushkayki.” ");
INSERT INTO qvsNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chashna Herodes willaptin chay shipashka mamanta tapurkan imatami mañanka nishpa. Chaypina mamanka yachachirkan mañananpa Juan Bawtistapa umanta suk kallanapi churashpa kunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chashna mañaptin Herodeska sukaman llakirkan. Llakishpapish konvidadukuna prometinakushkanta uyarishkankunarayku mana atiparkanchu llullachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chayrayku Herodeska soldadunkunata willarkansapa karselman rishpankuna Juanpa umanta tipinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chaymanta soldadukuna Herodes willashkankunata rurarkansapa. Juanpa umanta tipishpankuna suk atun kallanapi churashpa aparkansapa chay shipashta chaskichik. Chaypina payka mamanta kurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chaymanta Juanpa disipulunkuna rirkansapa kuerpunta pampak. Pampashkankunawasha rirkansapa Jesusta willak. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan Bawtistata wañuchishkankunata yachashpa Jesuska sapallan suk kanowapi chay kochata chimbarkan chunlla likidu pampaman rinanpa. Jesus rishkanta yachashpankuna chay llaktakunamanta aypa runakuna kocha mañanta purishpankuna katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chay kanowamanta llukshishpa Jesuska chay aypa katik runakunata kawarkan. Paykunata kawashpa sukaman llakichirkansapa. Chaypina tukuy chay pushadu unkudukunata alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chaymanta amusayaptin ñukaykuna Jesusta ladunchashpaynikuna willarkanisapa: —Ñami amusayaykanna. Manami ni pi kaypika kawsanchu. Chayrayku tukuy kay runakunata willay chay llaktakunaman utka rinankunapa mikunankunata rantik. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chaypina Jesuska ñukaykunataka willawarkansapa: —Mana munanichu rinankunapa. Kankunalla karaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chashna Jesus willawaptinkuna willarkanisapa: —Manami aypachu mikunaynikuna. Pichka pan ishkay challwallami tiyawansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chaypina Jesuska willawarkansapa: —Apamuychi chay mikunaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Apamuptinikuna Jesuska tukuy chay runakunata willarkansapa uksha sawanpi tiyarinankunapa. Chaymanta chay pichka panta chay ishkay challwata apishpa sieluta chapashpa Tata Diosta agradesirkan. Agradesishkanwasha chay pankunata paki paki rurashpa ñukaykunata kuwarkansapa. Chaypina ñukaykuna runakunata charichirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chay aypa runakuna mikurkansapa saksanankunakaman. Chaymanta mikushkankunawasha ñukaykuna puchukunata tantachirkanisapa chunka ishkay sestu untata. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chay mikuk ullkukunaka pichka waranka karkansapa. Aypa warmikuna wambrakunapish mikurkansapa. Paykunata mana yuparkanisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaymanta Jesuska ñukaykunata willawarkansapa: —Ñukaka tukuy kay runakunata willasha wasinkunaman kutinankunapa. Willanaynikaman kankuna kay kanowapi kochata chimbaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chay runakuna rishkankunawasha Jesuska sapallan suk urkuman rirkan chaypi Tatan Dioswan parlananpa. Tutayanankaman chaypi sapallan karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jesus chay urkupi kaptin ñukaykuna kanowapi chawpi kochata riykarkanisapa. Chimbaykaptinikuna sinchita wayraptin olaskuna kanowaynikunata sukaman kuyuchirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Chaymanta pakariykaptin Jesuska yaku sawanta purishpa ladunchawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ñukaykuna Jesusta mana riksishpaynikuna sukaman manchakurkanisapa. Manchakuywan sinchita rimarkanisapa: —¡Supaychi imachami shamuykan! ");
INSERT INTO qvsNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chashna kapariptinikuna Jesuska willawarkansapa: —¡Ama manchawaychichu! Ñukami kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chaypina Pedru aynirkan: —Kan Señornini kashpaykika willaway yaku sawanta purishpa laduykiman rinaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chaypina Jesuska willarkan: —Ariya shamuy. Rinanpa willaptinna Pedruka kanowamanta llukshishpa yaku sawanta purirkan Jesuspa ladunman rinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Riykashpana chay sinchi wayrata mallishpa sukaman manchakurkan. Kallarishpa sumiyta sinchita rimashpa willarkan: —¡Salvaway, Señor! ");
INSERT INTO qvsNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chashna Pedru willaptin Jesuska makinmanta apishpa willarkan: —¿Imapatí mana tukuy shunku ñukata kreyiwanki yanapanaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chaymanta Jesuswan Pedru kanowapi yaykuptinkuna chay sinchi wayraka kasillayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaypina tukuy ñukaykuna kanowa ukupi Jesuspa ñawpakninpi kunkurikushpa willarkanisapa: —Deverasmi Tata Diospa wambran kanki. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chaymanta Jesuswan tantalla chay kochata chimbashpaynikuna Genesaret partipi chayarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chaypi kawsak runakuna Jesusta riksishpankuna chayta chayta rishpankuna famakurkansapa Jesus llaktankunapi kananta. Chaypina Jesusman tukuy laya unkuyuk runakunata pusharkansapa alliyachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chay unkudukuna alliyayta munashpankuna Jesusta roygarkansapa: —Llachapaykipa mañanta llankanayanisapa alliyanaynikunapa. Chaypina llachapanpa mañanta llankakkuna unkuyninkunamanta alliyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chaymanta fariseo runakunawan Moisespa killkadunta yachachikukkuna Jerusalen llaktamanta rishpankuna Jesusta tapurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Imapatí disipuluykikuna mana ruransapa ñawpa awilunchikunapa amañashkankunata? ¿Imapatí paykunaka makinkunata mana allita mayllashpankuna mikunsapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chaypina Jesuska tapurkansapa: —¿Imapatí kankuna Tata Diospa munananta mana rurashpa ñawpa awiluykichipa amañashkankunallata rurankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tata Diosmi rimarkan: “Tataykita mamaykita allita kuyashpa kawsaychi.” Chaymanta rimarkan: “Ichara suk runa tatanta mamanta sukaman chiknishpa maldisinman. Chay maldisikuk runataka awtoridarkuna wañuchichinankuna tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Chashna Tata Dios rimaptinpish kankuna chikan layatana yachachikuykankichi. Yachachikunkichi atipanaykichita mamaykichita tataykichita willayta: “Kankunata yanapanayni kullkita Tata Diostami kushkani. Chayrayku manana tiyawannachu kankunata yanapanaynipa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chashna rimashpaykichika rimaykankichi tataykichita mamaykichita mana yanapaptikichipish mana nimananchu. Yachachikuykankichi Tata Dios kamachikushkan mana alli kananta. Tata Diosta mana kasushpaykichi ñawpa awiluykichi amañashkankunallata ruraykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Chaymanta Jesuska chay fariseokunata willarkansapa: —Tukuy kankuna allipi tukushpa llulla likidu kankichi. Kankunapa ñawpa yachachikuk Isaiyas killkarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Kay runakuna mishkik shimi tukushpa kuyawansapa. Mana tukuy shunkuchu kuyawansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Runakunapa yachachikunanllata yachachikunsapa. Llullakushpa kuyawakshina tantanakushpankunapish mana kushichiwansapachu.” ");
INSERT INTO qvsNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chashna willashpa Jesuska tukuy chay runakunata ladunman kayashpankuna willarkansapa: —Mash uyariwaychi allita entiendinaykichipa: ");
INSERT INTO qvsNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Imatapish kaptin mikushpaykichi mana uchallikunkichichu. Mana allita rimashpaykichi chaypimi esika uchallikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chaypina ñukaykuna Jesusta ladunchashpaynikuna willarkanisapa: —¿Yachankichu fariseo runakuna chay yachachikushkaykita uyarishpankuna sukaman piñakushkankunata? ");
INSERT INTO qvsNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Chaypina Jesuska ayniwarkansapa: —Chay fariseo runakuna Tata Diospa rimananta yachachikuykashpa aypa amañashkankunatapish yachachikunsapa. Sielupi kawsak Tataynika mana alli kiwata sapintinta tirakshina chay runakunapa mana alli yachachikushkanta kulluchinan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ama llakiychichu chay fariseokuna piñakuptinkuna. Paykunaka Tata Diospa kamachikunankunata mana allita entiendishpankuna mana yachak runakunata pantachichinsapa. Paykunaka mana kawakuk runakunashina kashpankuna mana kawakukmasinkunata pushashpa ishkantin uchkupi urmanmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaymanta Pedruka Jesusta willarkan: —Chay yachachiwashkaykisapata ashwan allita entiendichiwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chaypina Jesuska willarkan: —¿Ariya kankunapish manarachu entiendinkichira? ");
INSERT INTO qvsNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tukuy laya mikuna shiminchita yaykushpa wiksanchiman rin. Chaymanta letrinaman rin. Imatapish kaptin mikushpa manami uchallikunchichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tukuy runa mana allita yuyaykushpa mana allita rimashpa uchallikun. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tukuy runa shunkunpi mana allita yuyaykushpa chayta ruran. Chayta yuyashpa runamasinta wañuchin, chikan warmiwan uchallikun. Suk wayna suk shipashwan manara kasarashpara uchallikunsapa. Chaymanta suwakun, llullachikun, runamasinta chiknishpa piñachin. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Suk runa chay mana allikunata rurashpa uchallikun. Mana makinta mayllashpa mikushpa manami uchallikunchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesuska chay llaktamanta rirkan Tiro llaktaman Sidon llaktaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chaypina suk warmi payta laduncharkan. Chay warmika kananea kashpa mana judiyachu karkan. Payka sinchita rimashpa Jesusta roygarkan: —Señor, ñawpa kamachikuk Davidpa mirakninmi kanki. Llakichiwashpa shipashninita alliyachipay. Shipashninita supay sukaman turbachishpa unkuchin. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Chashna chay warmi sukaman willaptinpish Jesuska mana nimata aynirkanchu. Chaypina ñukaykuna Jesusta ladunchashpaynikuna roygarkanisapa: —Señor, kay warmita ashuchiy. Payka sukaman kaparikushpa katiwaykanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chaypina Jesuska chay warmita willarkan: —Tata Dioska kachamuwashka israel llaktamasinikunallata yanapanaynipasapa. Paykunaka iden chinkadu ovejakunashina kawsaykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chayta uyarishpa chay warmika Jesuspa ñawpakninpi kunkurikushpa willarkan: —Señor, yanapaway. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chashna chay warmi willaptin Jesuska willarkan: —Manarapish ni pita chikan llaktakunamanta alliyachishpaynira judiyumasinikunatara yanapanayni tiyan. Mana allichu suk runa wambrankunata panta kichushpa allkukunata karananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chashna Jesus willaptin chay warmika willarkan: —Ariya Señor, wambrakuna mesapi mikuptinkuna mesamanta puchudukuna urmaptin allkukunapish mikunsapa. Ñuka allkushina kaptinipish yanapaway. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chaypina Jesuska willarkan: —Tukuy shunku kreyiwashkaykirayku shipashnikita alliyachini. Chay oramantapacha shipashnin sanuna karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chaymanta chay llaktakunamanta llukshishpa Jesuska ñukaykunawan rirkan Galilea kocha mañanman. Chaypina suk urku sawanman rishpa tiyarirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chay urkupi kaptinikuna aypa runakuna tukuy laya unkuyuk runakunata pushashpankuna shamurkansapa. Jesuspa ñawpakninpi churarkansapa mana puriy atipakkunata, mana kawakukkunata, mana rimakuy atipakkunata, wakllidu makiyukkunata, rikchak laya unkuyukkunata. Chaypina Jesuska tukuy chay unkudu runakunata alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chashna alliyachiptinkuna mana rimakuy atipakkuna allitana rimakurkansapa. Wakllidu makiyukkuna alliyarkansapa. Mana puriy atipakkuna allitana purirkansapa. Mana kawakukkuna allitana kawakurkansapa. Jesus tukuy paykunata alliyachishkanta kawashpankuna chay runakuna israel runakunapa Tata Diosninta sukaman alabarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chaymanta Jesus ñukaykunata kayawashpankuna willawarkansapa: —Sukaman kay runakunata llakichinisapa. Ñami kimsa diyatana ñukawan kashpankuna tukuy mikunankunata tukuchashkasapa. Mana willanayanichu wasinkunaman kutinankunapa. Ichará mana mikushpa rishpankuna ñanpi shaykunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chaypina ñukaykunaka Jesusta willarkanisapa: —Kaypika manami niman suk runa kawsanchu. Manami kay chunllapika nima mikunata tarishunchisapachu kay aypa runakunata karananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chashna willaptinikuna Jesuska tapuwarkansapa: —¿Mashna pannikichití tiyan? Ñukaykuna aynirkanisapa: —Kanchis pan challwillukunapish tiyawansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chaypina Jesuska tukuy chay runakunata willarkansapa allpapi tiyarinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tiyariptinkuna chay kanchis pankunata chay challwillukunata apishpa Tata Diosta agradesirkan. Chaymanta chay pankunata chay challwillukunata ñukaykunata kuwarkansapa. Ñukaykuna chay runakunata kararkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Karaptinikuna mikurkansapa saksanankunakaman. Chaymanta puchushkankunata kanchis sestu untata tantachirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chay mikuk ullkukuna chusku waranka karkansapa. Warmikunata wambrakunata mana yuparkanisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chaymanta mikushkankunawasha Jesuska tukuy runakunata willarkansapa wasinkunaman kutinankunapa. Riptinkuna Jesuska ñukaykunawan rirkan suk kanowapi Magadan partiman. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chaymanta fariseo runakunawan saduseo runakuna Jesustaka laduncharkansapa. Jesusta pantachichinayashpa willarkansapa: —Tata Diosmanta shamudu runa kashpaykika suk almirana milagruta ruray kanta kreyinaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Chashna willaptinkuna Jesuska willarkansapa: —Inti puka likidu yaykuptin kankuna rimankichi allima diya pakarinanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chaymanta chikan diya puka likidu puyu wichkanakuptin rimankichi diya wakllinanta. Kankuna sielupi puyukunata kawashpa yachankichi ima laya diyami kanka nishpa. Tukuy chayta allita yachashpaykichipish ñuka rurashkaynikunata kawashpaykichi mana entiendinkichichu Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kankuna Tata Diosta mana kasushpa mana alli rurak kaykashpaykichi willawankichi almirana milagruta ruranaynipa. Ñukaka manami nimata rurashachu kawanaykichillapa. Tata Dios ñawpa yachachikuk Jonaspa suk almirana milagruta rurarkan. Chay layallata ruranka kawanaykichipa. Jesus chashna willashpa paykunata sakishpa chikanman rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chaymanta chay kocha chimbapi chayashpaynikuna yuyarkanisapa panninikunata kunkashkaynikunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chaypina Jesuska willawarkansapa: —Mash allita uyariwaychi. Ama munaychichu fariseokunapa nima saduseokunapa levadurawan ruradu panninkunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chashna Jesus willawaptinkuna mana entiendishpaynikuna willanakurkanisapa: —Pankunata mana apamushkanchikunarayku chayta willawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Willanakushkaynikunata yachashpa Jesuska willawarkansapa: —¿Imapatí chashnaka willanakunkichi? Mana chaytaka willashkaykichichu pannikichita kunkashkaykichirayku. Kankunaka manara allitarachu kreyiwaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manarachu entiendinkichira? ¿Ñachu kunkashkankichina pichka pankunawan pichka waranka runakunata paktachishpa karashkaynita? ¿Manachu yuyankichi mashna sestutami mikuna puchuduta tantachishkaykichita? ");
INSERT INTO qvsNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chaymanta ¿manachu yuyankichi chusku waranka runakunata kanchis pankunawan karashkaynita? ¿Manachu yuyankichi mashna sestutami puchudu pankunata tantachishkaykichita? ");
INSERT INTO qvsNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imapatí kankunaka mana allita entiendiwashkankichi? Manami fariseokunapa saduseokunapa panninkunapachu willashkaykichi. Kashkan willaykichi: Ama munaychichu chay runakunapa levadurawan ruradu panninkunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chaypina ñukaykuna chayrak allita entiendirkanisapa Jesus rimashkanta fariseokunapa saduseokunapa mana alli yachachikunankunamanta kuydanakunaynikunapa. Mana willawarkansapachu paykunapa levadurawan ruradu panninkunamanta kuydakunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chaymanta Sesarea Filipo partipi chayaptinikuna Jesus ñukaykunata tapuwarkansapa: —Runakuna parlashpankuna ¿pi kanaynitatí rimansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ñukaykuna aynirkanisapa: —Sukkuna rimansapa Juan Bawtista kanaykita. Sukkuna rimansapa ñawpa yachachikuk Eliyas kanaykita. Sukkuna rimansapa ñawpa yachachikuk Jeremiyas kanaykita. Sukkuna rimansapa Tata Diospa rimananta yachachikuk kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chaypina Jesuska tapuwarkansapa: —Kankunaka ¿pi kanaynitatí yuyankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chashna tapuwaptinkuna Simon Pedruka aynirkan: —Kanka mana tukuyniyuk kawsak Tata Diospa wambranmi kanki. Paymi kachamushushka salvakuk kanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chaypina Jesuska Pedruta willarkan: —Jonaspa wambran Simon, sielupi kawsak Tataynimi yachachishushka chayta willawanaykipa. Mana niman suk runachu chaytaka yachachishushka. Chayrayku Tata Dios kushichishunki. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mash allita uyariway. Kanka Pedrumi kanki. Sinchita kreyiwashkaykirayku sinchi rumishina kanki. Aypa runakuna kanshina sinchita kreyiwankasapa. Tukuy kreyiwakkuna ñukapa wasinishina kankasapa. Ñukaka sinchi rumi sawanpi wasinita rurasha. Tukuy kreyiwak runakuna wañushpankunapish manana wañudukuna churanankunaman rinkasapachu. Mana ni pi atipankachu kreyiwakkunata kulluchiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ñukaka Tata Diospa mandunpi yaykuna llavita kushkayki. Chay llavika yachachikunaynishinami. Kan yachachikuptiki suk runakuna kreyikuptinkuna willankisapa uchankunamanta kacharidu kanankunata. Sielupi kawsak Tata Diospish willankasapa kacharidu kanankunata. Chaymanta yachachikuptiki sukkuna mana kreyikuptinkuna willankisapa watadushinalla kiparinankunapa. Chashnalla sielupi kawsak Tata Diospish willankasapa watadutashinalla kiparinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chayta Pedruta willashkanwashana Jesuska tukuy ñukaykunata willawarkansapa: —Amara ni pita willankichirachu ñuka sielumanta shamudu salvakuk runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaymanta Jesuska ñukaykunata allita entiendichiwashpankuna willawarkansapa: —Ñukaka Jerusalenman rinayni tiyan. Chaypi ansianukunawan, saserdotekunapa kamachikukninkunawan, Moisespa killkadunta yachachikuk runakuna sukaman sufrichiwashpa wañuchiwankasapa. Chaymanta wañushkaynimanta kimsa diya ukun kawsamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chashna wañuchinankunata willawaptinkuna Pedruka suk chikanman Jesusta pushashpa willarkan: —Señor, ama chaytaka yuyaychu. Tata Dioska manami munankachu wañuchishunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chashna willaptin Jesuska Pedruta chapashpa willarkan: —Ñukamanta ashuy, Satanas. Llullachiwanayanki ama Tata Diosta kasunaynipa. Manami Tata Diospa munanantachu willawaykanki. Runakunapa munananllata yuyashpa willawaykanki ama wañunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chaymanta Jesuska tukuy ñukaykunata willawarkansapa: —Kankuna ñukapa disipuluynikuna kanayashpaykichika amana kikikichipa munanaykichita ruraychinachu. Chiknishuk runakuna ñukarayku wañuchishunayaptikichipish ñukallata kreyiwashpa katiwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kankuna wañuymanta kishpinayashpa sakiwashpaykichika mana tukuyniyuk ninamanta mana kishpinkichichu. Chaymanta kreyiwashkaykichirayku runakuna wañuchishuptikichipish sieluman rinkichi Tata Dioswan mana tukuyniyukta kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Suk runa rikchak laya tiyapuptinpish mana sielupi yaykushpaka yankamanta tukuy layayuk kawsashka. Aypa kullkiyuk kashpapish mana atipanchu chaninta paktachiyta sielupi kawsananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ñuka sielumanta shamudu runa Tataynipa llipyayninpi angelninkunawan tantalla kashkan shamusha. Shamushpayni tukuy runakunata pagarashasapa allita mana allita rurashkankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mash allita uyariwaychi. Ñuka sielumanta shamudu runa kashpayni tukuy runakunata kamachishasapa. Suk kankuna manara wañushpaykichira kawawankichi sinchita kamachikuptini. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaymanta sokta diya washan Jesus rirkan suk atun urkuman Pedruta, Jakobota, Jakobopa wawkin Juanta pushashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chay urkupi kashpankuna chay kimsa disipulunkuna kawaptinkuna Jesuska chikan laya tukurkan. Uyan intishina llipyarkan. Llachapanpish yurak lusshina llipyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chay kimsa disipulunkuna kawarkansapa ñawpa tiempu kawsashka Eliyasta Moisesta Jesuswan parlaykaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chayta kawashpa Pedruka Jesusta willarkan: —Señor, allipaka kanwan tantalla kanisapa. Munaptikika rurashasapa kimsa ranchukunata, sukta kanpa, sukta Moisespa, sukta Eliyaspa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chashna Pedru rimaykaptin suk yurak likidu puyu sirishpa paykunata wichkamurkansapa. Chay puyu ukumanta uyarirkansapa Tata Dios rimakuptin: —Kay Jesuska munanayni wambraynimi. Paytami akllashkani. Chayrayku kankuna payta allita uyariychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chay kimsa disipulunkuna chayta uyarishpa sukaman manchakushpankuna allpapi pakchanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaypina Jesus ladunchashpa paykunata llankashpankuna willarkansapa: —Atarimuychi. Ama manchakuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paykuna atarimushpa Jesusta chapashpankuna sapallantana kawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chaymanta chay urkumanta urayamuykashpankuna Jesuska willarkansapa: —Amara ni pita kay urkupi kawashkaykichita parlachiychirachu. Ñuka sielumanta shamudu runa kashpayni wañushkaynimanta kawsamuptinira chayta parlachikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaypina chay kimsa disipulunkuna Jesusta tapurkansapa: —¿Imapatí Moisespa killkadunta yachachikuk runakuna rimansapa manara Tata Diosmanta runa shamuptin ñawpa yachachikuk Eliyas shamunanta? ");
INSERT INTO qvsNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chaypina Jesuska willarkansapa: —Deverasmi Moiseska rimarkan Eliyas shamunanta runakunata willak Tata Dios kachamushkan runata shuyanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Allita willaykichi. Eliyaska ñami shamushkana. Fariseo runakuna mana riksirkansapachu Eliyas kananta. Mana riksishpankuna chiknishpa sufrichirkansapa. Sielumanta shamudu runa kaykaptini ñukatapish chikniwashpankuna sufrichiwankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chaypina chay disipulunkunaka allita entiendishpankuna willanakurkansapa: —Deverasmi willawaykanchisapa Juan Bawtista Eliyasshina kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chay urkumanta kutimushpankuna Jesuska chay kimsa disipulunkunawan aypa tantanakudu runakunapi chayarkansapa. Chaypina suk runa Jesusta ladunchashpa ñawpakninpi kunkurikushpa willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, wambraynita llakichishpa alliyachipay. Payka gota unkuywan sukaman sufrishpa kawsan. Kuti kuti chay unkuynin apiptin ninapi yakupi urman. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kay disipuluykikunaman pushamuptini mana atipashkasapachu alliyachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chaypina Jesuska chay runakunata aynirkansapa: —Kankuna mana kuska yuyayyuk kankichi. Tata Diosta mana kreyinayankichichu. ¿Aykapikamantí kankunawan kanayni tiyan? ¿Aykapikamantí amichiwankichi? Kayman chay unkudu wambrata pushamuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chay wambrata pushamuptinkuna Jesuska unkuchik supayta sinchita willarkan chay wambramanta llukshinanpa. Supayta llukshichiptin chay wambra sanuna kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaymanta chikanman rishpaynikuna ñukaykuna Jesusta tapurkanisapa: —¿Imapati ñukaykuna chay unkuchik supayta mana atipashkanisapa chay wambramanta llukshichiyta? ");
INSERT INTO qvsNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chaypina Jesuska willawarkansapa: —Kankunaka mana atipashkankichichu chay wambrata alliyachiyta mana Tata Diosta tukuy shunku kreyishpaykichi. Allitami willaykichi. Mostasa murushina tipisitullatapish Tata Diosta kreyishpaykichika kay urkuta willankichiman kaymanta suchunanpa. Chashna willaptikichika kay urkuka suchunka. Tata Dios yanapashuptikichi rikchak layata atipankichi rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mana nimata mikushpaykichira tukuy shunku Tata Diosta roygashpaykichira chay laya supayta atipankichi llukshichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chaymanta Galilea partipi ñukaykunawan puriykashpa Jesuska willawarkansapa: —Chikniwak runakuna ñuka sielumanta shamudu runata awtoridarkunaman pushawankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Paykunaka wañuchiwankasapa. Wañushkaynimanta kimsaynin diyapi kashkan kawsamusha. Chashna willawaptinkuna ñukaykuna sukaman llakirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chaymanta Jesuska ñukaykunawan Kapernaum llaktapi chayaptinikuna suk runakuna ladunchawarkansapa. Paykunaka Tata Diospa wasinpa kullkita kobrakuk kashpankuna Pedruta tapurkansapa: —¿Manachu maestruykichi Tata Diospa wasinpa pagarakun? ");
INSERT INTO qvsNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chashna tapuptinkuna Pedruka aynirkansapa: —Ariya payka pagarakunmi. Chaypina Pedru chay wasipi yaykushpa manara nimata willaptinra Jesuska tapurkan: —Simon, willaway ¿imatati yuyanki? Kamachikuk runakuna ¿pikunatati rikchak layapa pagarachinsapa? ¿Kikinkunapa kastankunatachu? ¿Chikan llaktakunamanta runakunatachu? ");
INSERT INTO qvsNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chaypina Pedruka aynirkan: —Chay chikan llaktamanta runakunallata pagarachinsapa. Chaymanta Jesuska willarkan: —Chayrayku kikin kastankunaka mana nimata pagarakunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ñuka Tata Diospa wambran kashpayni paypa wasinpa mana pagarakuymanchu. Chashna kaptinpish ama ni pita piñachinanchipa aku pagarakuypa. Rillay kochapi ansuelakuk. Chay kallarinan challwa apinaykita surkushpayki shiminpi suk kullkita tarinki. Chayta apashpayki kanpa ñukapa pagarakunki. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chaypina ñukaykuna Jesusta ladunchashpaynikuna tapurkanisapa: —Señor, Tata Diospa mandunpi ¿maykan ñukaykunati ashwan alli kamachikuk kaymansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chashna tapuptinikuna Jesuska suk taksha wambrilluta kayashpa chawpinikunapi shayachirkan. Payta kawachiwashpankuna yachachiwarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Mash allita uyariwaychi. Tata Diospa mandunpi yaykunayashpaykichika ama munaychichu ashwan sinchi kamachikuk kayta. Mana kay wambrillushina alli kasukuk kashpaykichika manami Tata Diospa mandunpika yaykunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tata Diospa mandunpi ashwan alli kamachikuk kashpaykichi kay wambrillushina allillapi mana kreyinakushpa kawsanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chaymanta ñukata kuyawashpa kay laya wambrata chaskishpaykichika ñukatapish chaskiwaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Chaymanta Jesuska ñukaykunata willawarkansapa: —Suk runa ñukata kreyiwak wambrilluta uchallichiptin Tata Dios sukaman kastiganka. Ashwan alli kanman payta atun rumi makita kunkanpi watashpa atun yakupi wishchukunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sukaman llakini kay allpapi rikchak laya uchallichikuk runakuna tiyaptin. Chay laya runakuna aypami tiyanka. Ñuka sukaman llakini uchallichikuk runakuna tiyaptin. Tata Dios paykunata sukaman kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Chayrayku willaykichi: Ichara makikichiwan chakikichiwan sukaman uchallikuyta munankichiman. Ama uchallikunaykichipa makikichita chakikichita tipishpa chikanman wishchukuychi. Chayta ruraychi ama ishkantin chakikichiwan ishkantin makikichiwan mana tukuyniyuk ninaman rinaykichipa. Ashwan alli kanman suk makikichillawan suk chakikichillawan sieluman rinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chaymanta ichara ñawikichiwan ima mana allita kawashpa munashpa uchallikunkichiman. Chay uchallichishuk ñawikichita surkushpa wishchukuychi. Chayta ruraychi ama ishkantin ñawikichiwan mana tukuyniyuk ninaman rinaykichipa. Ashwan alli kanman suk ñawikichillawan sielupi yaykunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Chaymanta Jesuska ñukaykunata willawarkansapa: —Chayrayku ama niman suk kreyiwak runakunata mana nimatashina kawaychichu. Tatayni Dios tukuy mana kreyinakushpa ñukata kreyiwak runakunata kuyansapa. Tukuy tiempu sielupi paykunata kuydak angelkuna paypa ñawpakninpi kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ñuka Tata Diosmanta shamushkani paymanta ashudu runakunata kastigumanta salvanaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Chayrayku ama ni pita ignoraychichu. ¿Imatati yuyankichi? Ichara suk runapa tiyanman pachak ovejankuna. Chay pachakmanta sukllalla chinkaptin ¿imatati ruranka? ¿Manachu tukuy ovejankunata urkupi sakishpa rinka chay chinkaduta maskak? ");
INSERT INTO qvsNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chay chinkadu ovejanta tarishpa sukaman kushikunka. Allita willaykichi. Chay aypa mana chinkadu ovejakunarayku kushikun. Chaymanta chay chinkadu ovejanta tarishkanrayku ashwanta kushikun. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chay ovejanta tarik runashina sielupi kawsak Tataykichika tukuy runakunata sukaman kuyan. Payka manami munanchu niman suk runa paymanta ashushpa mana tukuyniyuk ninaman rinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Chaymanta Jesuska yachachiwaysapallapi katirkan: —Ichara Tata Diosta kreyikmasikichi rabyachishunkichiman. Chashna rabyachishuptikichi rillaychi sapallaykichi mana alli rurashkanta willak. Pay kasushuptikichi perdonaychi. Chashna perdonashpaykichi chay kreyikukmasikichita yanapashkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Chaymanta chay runa mana kasushuptikichi ishkay kimsa runakunata payman pushaychi. Chay ishkay kimsa runakuna uyariptinkuna chay mana alli rurak runata mana alli rurashkanta willaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chay runa chay pushashkaykichi runakunata mana kasunayaptinka tantanakuk Tata Diosta kreyikmasikichita willaychi. Chay runa paykunata mana kasunayaptinka mana Tata Diosta kreyik runatashinana kawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Allita willaykichi: Kankuna kay allpapi chay mana kasushuk runata mana Tata Diosta kreyik runatashina kawaptikichika watadushina kiparinka. Chaypina sielupi kawsak Tata Diospish watadutashina kawanka. Chaymanta chay runa kasushuptikichi perdonaychi. Chashna perdonaptikichika kacharidushina kanka. Tata Diospish kacharidutashina kawanka. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Allita willaykichi: Kankuna ishkaymanta idenllata yuyaykushpa sielupi kawsak Tatayni Diosta suk imata roygaptikichika payka uyarishushpaykichi yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kankuna ñukata kreyiwashpa ishkaymanta kimsamanta tantanakuptikichi chaypi kankunawan tantalla kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaypina Pedru ladunchashpa tapurkan: —Señor, suk runamasini kuti kuti rabyachiwaptinka ¿mashna kutitiya perdonasha? ¿Kanchis kutichu perdonasha? ");
INSERT INTO qvsNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesuska aynirkan: —Manami willaykichu kanchis kutilla perdonanaykipa. Willaykimi kuti kuti mana nima yupashpa perdonanaykipa. Kanchis kuti kanchis chunkakaman perdonanayki tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Chaymanta Jesuska ñukaykunata willawarkansapa: —Mash uyariwaychi suk ejempluta parlachiptini. Tata Diospa mandunpi kawsashpaykichi perdonanakunaykichi tiyan. Suk sinchi kamachikuk runa tukuy trabajadorninkunata kayachirkan willanankunapa mashnatami payta debinsapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kobrakuyta kallariykaptin suk runata pushamurkansapa. Payka chay alli kamachikuk runata sukaman aypa waranka kullkita debirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chay debikuk runaka mana nima kullkiyukchu karkan kutichikunanpa. Chayrayku chay kamachikukka trabajadornin runakunata willarkan: “Mana kutichiwayta atipaptin kay runata warmintinta tukuy wambrankunatapish rantikuychi. Rikchak laya tiyapushkankunatapish rantikuychi. Chay rantikushkaykichi chaninta ñukata kuwaychi debiwashkanta pagarawananpa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chashna willaptin chay debikuk runaka kamachikukninpa ñawpakninpi kunkurikushpa roygarkan: “Señor, mana piñakushpa shuyaway. Tukuy debishkaynita kutichishkayki.” ");
INSERT INTO qvsNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chashna sukaman roygaptin chay sinchi kamachikuk runaka llakichishpa debishkanta perdonarkan wasinman kutinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Chashna debishkanta perdonaptin chay runa llukshishpa suk trabajadormasinwan tinkunakurkan. Chay tinkushkan runaka suk tipi kullkita payta debirkan. Chaypina chay perdonadu runaka sukaman piñakushpa chay tipisitu debiknin runata kunkanmanta apishpa sipinayarkan. Chaypina willarkan: “Kunanlla pagaraway tukuy debiwashkaykita.” ");
INSERT INTO qvsNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chashna willaptin chay debikninka ñawpakninpi kunkurikushpa roygarkan: “Mana piñakushpa shuyaway. Ñukaka tukuy debishkaynitami kutichishkayki.” ");
INSERT INTO qvsNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Chashna roygaptinpish chay sipinayak runaka mana nima uyariyta munarkanchu. Pusharkan karselpi wichkachik tukuy debishkanta kutichinankaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Karselpi wichkachiptin kawashpankuna trabajadormasinkuna llakichishpa rirkansapa chay sinchi kamachikukpi chatakuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chaypina payka chay perdonashkan trabajadorninta kayachishpa willarkan: “Kanka sukaman sakra mana alli runami kanki. Sukaman roygawaptiki ñuka llakichishpayni chay aypa waranka kullki debiwashkaykimanta perdonashkayki. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kanta perdonashkaynishina kanpish chay debishuknikita llakichinkiman karkan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chaypina chay kamachikuk runaka sukaman piñakushpa willarkan chay perdonashkan runata karselpi wichkanankunapa tukuy debikushkanta pagarakunankaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chay debikuk runapa ejemplunta Jesuska allita entiendichiwashpankuna willawarkansapa: —Suk runamasikichi mana allikunata rurashuptikichika tukuy shunku perdonanaykichi tiyan. Mana perdonaptikichika sielupi kawsak Tatayni Dioska kankunatapish mana perdonashpa sukaman kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tukuy chaykunata yachachiwashkankunawasha Jesus Galilea partimanta llukshishpa rirkan ura Judea partiman. Chaymanta rirkan Jordan yaku chimbaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jesus Judea partiman riptin aypa runakuna katirkansapa. Chaypina aypa unkudukunata alliyachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chaymanta fariseo runakuna Jesusta ladunchashpankuna sukaman pantachichinayashpankuna tapurkansapa: —¿Ariya Tata Diospa rimananpi almitiwansapachu imapapish kaptin warminikunata wishchunaynikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chashna tapuptinkuna Jesus aynirkansapa: —¿Manachu Tata Diospa killkadunpi leyishkankichi kallarinan tiempu ullkuta warmita rurashkanta? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tata Dios warmita ullkuta rurashpa willarkansapa: “Tukuy ullku tatanta mamanta sakinka warminwan tantanakushpa kawsananpa. Chashna warminwan tantanakushpa sukllallashina kawsankasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chayrayku suk ullku warminwan tantalla sukllallashina kawsashpankuna manana ishkaynachu. Chayrayku mana allichu niman suk runa warminta wishchunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chashna Jesus yachachikuptin chay fariseokuna tapurkansapa: —Chashna kaptinka ¿imapatí Moises yachachikurkan suk runa warminta wishchunayashpa awtoridarpi killkaduta payta kushpa atipananta wishchuyta? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chaypina Jesuska willarkansapa: —Sinchi shunkuyuk kaptikichi Moiseska kankunata almitishurkankichi warmikichita killkaduta kushpa wishchunaykichipa. Kallarinanmantapacha Tata Dioska manami munarkanchu wishchunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Allita willaykichi: Warmikichi chikan ullkuwan mana uchallikuptinka ama wishchuychichu. Payta wishchushpaykichi chikan warmiwan kasarashpaykichika uchallikuykankichi. Chay wishchudu warmiwan kasarak runapish uchallikuykan. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chaypina ñukaykunaka Jesusta willarkanisapa: —Tata Dios mana munaptin warminikunata wishchunaynikunapa ashwan alli kanman ama kasaranaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chashna willaptinikuna Jesuska willawarkansapa: —Aypa runakuna kay willashkaynita mana atipansapachu entiendiyta. Tata Dios yanapashuptikichira entiendinkichiman. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wakin ullkukuna nasirkansapa mana kasarayta atipanankunapa. Chikan ullkukuna mana kasaransapachu runamasinkuna kapashka kaptinkuna. Sukkuna mana kasaranayansapachu ashwan allita Tata Diosta sirvinankunapa. Kankuna kay yachachishkaynita atipashpaykichi chaskiyta chaskiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chaymanta Jesusman wambrakunata pushamurkansapa llankashpa paykunapa Tata Diosta orananpa. Ñukaykuna wambrakunata pushamuk runakunata michashpa willarkanisapa: —Ama Jesusman chay wambrillukunata pushamuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chashna michaptinikuna Jesuska ñukaykunata willawarkansapa: —Ama michaychichu ñukaman chay wambrakunata pushamuptinkuna. Wambrakuna mana kreyinakushpa tatankunapa munayninpi kawsansapa. Kankunapish wambrakunashina kawsaptikichira Tata Diospa mandunpi yaykunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chashna willawashpankuna Jesuska tukuy chay wambrakunata kuyashpa llankarkansapa. Chaymanta rirkan chikan llaktakunapi yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chaymanta suk runa Jesusta ladunchashpa tapurkan: —Alli maestru ¿imata rurashpati mana tukuyniyukta Tata Dioswan kawsayman? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chashna tapuptin Jesuska aynirkan: —¿Imapati alli kanaynita willawanki? Tata Diosllami alli rurak. Paywan kawsak rinayashpaykika tukuy kamachikushkanta allita kasushpa kawsay. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chaypina chay runaka tapurkan: —Tata Dios kamachikunankunamanta ¿maykantati rurasha? Chashna tapuptin Jesuska willarkan: —“Ama runamasikita wañuchiychu. Ama chikan warmiwan uchallikuychu. Ama suwakuychu. Ama ni pita llullakushpa tumbaychu. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tataykita mamaykita kuyashpa kawsay. Chaymanta kikiki kuyanakukshina tukuy runamasikikunata kuyay.” ");
INSERT INTO qvsNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chaypina chay runaka willarkan: —Ñukaka tukuy chaykunata kasushpa kawsaykani. ¿Ima ashwantati rurasha? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chaypina Jesuska aynirkan: —Tata Diospa munananta allita ruranayashpaykika rillay tukuy laya tiyapushunaykita rantikumuy. Chaypa chaninta mana nimayuk runakunata kuysapa. Chayta rurashpa sielupi tukuy layayuk kanki. Chaymanta shamuy ñukata katiwak. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chayta uyarishpa chay runaka sukaman llakishpa wasinman kutirkan rikchak layayuk kashpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chay runa llakishpa riptinna Jesuska ñukaykunata willawarkansapa: —Allita yachachiykichi. Chay laya kullkinllapi kreyinakuk runakuna mana atipankasapachu Tata Diospa mandunpi yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kashkan willaykichi: Suk kamellu animal suk aguja uchkunta mana atipanmanchu pasayta. Chashnami kullki likidu runa kullkinta ashwanta munashpa mana atipankachu Tata Diospa mandunpi yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chayta uyarishpa ñukaykuna sukaman almirashpaynikuna tapunakurkanisapa: —Chashna kaptinka ¿pikunati Tata Diospa mandunpi yaykunka? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chaypina Jesuska ñukaykunata chapawashpankuna willawarkansapa: —Manami niman suk runa atipanchu kikinllamanta Tata Diospa mandunpi yaykuyta. Tata Diosllami atipan runakunata mandunpi yaykuchiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chaypina Pedruka willarkan: —Ñukaykuna tukuy tiyapakninikunata sakimushpaynikuna kanta katimuykaykisapa. ¿Imatati ñukaykunata kuwankisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuska willawarkansapa: —Allita willaykichi. Tata Dios kay allpapi tukuy layata mushukta ruraptin ñukaka sielumanta shamudu runa tiyarisha allima llipyak tiyarinaynipi. Ñuka kamachikuk kaptini kankunapish tiyarinkichi chunka ishkay allima tiyarinaykichipi. Chaypina chunka ishkay israel aylluykikunata kamachishpa willankichi allitachu manachu rurashkasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kankuna ñukata katiwanaykichirayku wasikichita, wawkikichita, mamaykichita, tataykichita, wambraykichita, terrenuykichita sakiptikichi Tata Diosmi sakishkaykichimanta ashwan aypata kushunkichi. Chaymanta wañushpaykichi mana tukuyniyukta Tata Dioswan sielupi kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kunan kay tiempu aypa runakuna kikinkuna yuyanakunsapa ashwan alli kanankunata. Paykuna Tata Diospa mandunpi washeru kankasapa. Chaymanta kankuna mana munadu kashpaykichipish Tata Diospa mandunpi primeru kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Chaymanta Jesuska chay runakunata yachachirkansapa: —Akuychi yuyaypachi imashnami Tata Dios mandunpi kamachikun nishpa. Suk patronpa atun uva chakran tiyarkan. Suk diya tuta tutalla payka llukshirkan peonkunata maskak chakranpi trabajanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Trabajadorkunata tarishpa willarkansapa: “Diya entero chakraynipi trabajaptikichi paktadutami pagarashkaykichi.” Chayta willashpa kacharkansapa trabajanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chaymanta inti altupina kaptin chay patronka kashkan llukshirkan ashwan peonkunata maskak. Plasapi aypa mana trabajuyuk runakunata tarirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Paykunata willarkansapa: “Kankunapish rillaychi uva chakraynipi trabajak. Trabajashkaykichipa pagarashkaykichi.” Chashna willaptinkuna paykunapish rirkansapa trabajak. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chawpi diyata chaymanta tarditapish chay chakrayuk runaka kashkan rirkan peonkunata maskak. Paykunatapish kacharkansapa chakranpi trabajanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chaymanta tardiyaykaptin chay patronka kashkan rirkan peonkunata maskak. Plasapika kashkan mana trabajuyuk runakunata tarirkansapa. Paykunata willarkansapa: “¿Imapati diya entero kaypi kankichi mana nimata rurashpa?” ");
INSERT INTO qvsNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chashna tapuptin willarkansapa: “Mana ni pi maskawashkasapachu trabajachiwanankunapa.” Chaypina chay patronka willarkansapa: “Kankunapish rillaychi uva chakraynipi trabajak.” ");
INSERT INTO qvsNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chaymanta chishyaptinna chay patronka kapatasta willarkan: “Tukuy trabajadorkunata kayay pagaranaykipasapa. Chay washa shamudu trabajadorkunata kallariy pagaraysapata.” Chay diya entero trabajashkakunata washata pagaraysapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chaypina suk oralla trabajashka runakunata pagararkansapa diya entero trabajaktashina. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chayta kawashpa tuta pachamanta trabajakkuna rimarkansapa: “Ñukaykunata diya entero trabajashkaynikunarayku ashwan aypata pagarawankasapa.” Chashna yuyashpankunapish suk diya trabajashkankunallapa chaskirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chayrayku piñakushpankuna patronta yuyarkansapa mana alli pagarakuk patron kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Willarkansapa: “¿Imapatí ñukaykunata kay washa trabajak shamuk runakunawan idenllata pagarawankisapa? Paykunaka suk orallata trabajashkasapa. Ñukaykuna diya entero rupayta muchushpa trabajashkaynikunarayku ashwan aypata pagarawankimansapa karkan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chashna piñakushpa willaptinkuna chay patronka sukta willarkan: “Amigu, ñukaka manami llullachiykichu. ¿Manachu parlashkanchi suk diya entero trabajashkaykipa pagaranaynipa? Paktaduta pagaraptini ¿ima ashwantatí munanki? ");
INSERT INTO qvsNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chay chaskishkayki kullkikita apashpana rillay. Ñuka kankunawan paktallata chay washa shamushkakunata munani pagarayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ñuka kullkiniwan munashkaynita rurani. ¿Imapata piñakushpa envidianki chay trabajadormasikita kantashina idenllata pagaraptini?” ");
INSERT INTO qvsNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chay ejempluta yachachikushkanwasha Jesuska willarkansapa: —Kay allpapi mana kreyinakuk runakuna Tata Diospa mandunpi primeru kankasapa. Chaymanta alli munadu yuyanakuk runakuna Tata Diospa mandunpi washeru kankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chaypina Jesus Jerusalen llaktaman riykashpa ñukaykunallata chikan partiman pushawashpankuna willawarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Allita yachankichi Jerusalen llaktaman riykananchikunata. Chaypi suk runa saserdotekunapa kamachikukninkunaman Moisespa killkadunta yachachikuk runakunaman ñukata pushawanka rantikuwak. Chaypina ñuka sielumanta shamudu runa kaptinipish paykunaka yuyankasapa wañuchiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chaypina romano runakunapa makinpi kukuwankasapa. Chay romano runakuna sukaman asichiwashpankuna makawankasapa. Chakatawashpankuna wañuchiwankasapa. Chaymanta wañushkaynimanta kimsaynin diya kashkan kawsamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chaymanta Sebedeopa warmin ishkay wawankunawan Jesusta laduncharkansapa. Sebedeopa wambrankuna Jakobowan Juan karkansapa. Paykunapa maman Jesuspa ñawpakninpi kunkurikushpa suk favorta mañarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chaypina Jesuska payta tapurkan: —¿Imatati munanki? Payka aynirkan: —Kan allimata kamachikuykaptiki kay ishkay wawaynikunata tiyachipay kada laduykipi paykunapish kamachikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chaypina Jesuska willarkan: —Kankunaka mana yachankichichu imatami mañawaykankichi nishpa. Ñukami tukuy layata sukaman sufrinayni tiyan wañunaynikaman. Chashna sufrishpa iden suk ayak likiduta upyakshina kasha. Kankunaka manami atipankichimanchu ñukashina nanaykunata muchuyta. Chashna willaptinkuna paykunaka aynirkansapa: —Ariya, atipashasapa muchuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chaypina Jesuska aynirkansapa: —Ariya kankunapish ñukashina sukaman sufrinaykichi tiyan. Ñukaka manami ni pita willashachu laduynipi tiyarishpa kamachikunaykichipa. Tatayni Diosmi akllanka pikunami laduynipi tiyarinkasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chashna chay warmi ishkay wawankunapa mañaptin ñukaykunaka uyarishpa sukaman piñakurkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Piñakushkaynikunata uyarishpa Jesuska tukuy ñukaykunata kayawashpankuna willawarkansapa: —Kankuna allita yachankichi tukuy llaktakunapi sinchi kamachikuk runakuna sukaman sinchita kamachikunankunata. Paykunaka mandunpi kawsak runakunata sukaman sufrichinsapa kasunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kankunaka ama chay sinchi kamachikuk runakunashina kanayaychichu. Alli kamachikuk kanayashpaykichika tukuy runamasikichita allita yanapaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chaymanta tukuy runakunamanta ashwan sinchi kamachikuk kanayashpaykichika iden rantidu runakunashina pitapish kaptin yanapanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ñukapish sielumanta kay allpaman shamushkani tukuy runakunata yanapanaynipasapa. Mana shamushkanichu sukkuna sirviwanankunapa. Shamushkanimi wañushpa aypa runakunata kastigumanta salvanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chaymanta Jesus Jeriko llaktamanta llukshiykaptin aypa runakuna katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chaypina ishkay mana kawakuk runakuna ñan ladunpi tiyaridu karkansapa. Paykuna Jesus pasaykananta uyarishpa sinchita kayashpa willarkansapa: —¡Señor, ñawpa Davidpa miraknin, llakichiwashpa yanapawaysapa! ");
INSERT INTO qvsNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chashna sinchita kayaptinkuna Jesuswan rik runakuna micharkansapa ama kaparinankunapa. Chaypina paykunaka ashwan sinchita kaparikushpa willarkansapa: —¡Señor, ñawpa Davidpa miraknin, llakichiwashpa yanapawaysapa! ");
INSERT INTO qvsNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chaypina Jesus riykashkanmanta shayarishpa chay ishkay runakunata kayashpa tapurkansapa: —¿Imatati munankichi ruranaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chaypina paykunaka willarkansapa: —¡Señor, munanisapa kawakuyta! ");
INSERT INTO qvsNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chayta willaptinkuna Jesuska llakichishpankuna ishkantinpa ñawinkunata llankapurkansapa. Chay oralla kawakurkansapa. Paykunaka kawakushpankunana Jesusta katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalen llaktaman ñukaykuna Jesuswan tantalla rishpaynikuna chayarkanisapa Betfage llaktapi. Chay llaktillu Olivos urku ladunpi karkan. Chaypi chayashpaynikuna Jesus ishkay disipulunkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Rillaychi chay kawananchi llaktaman. Chaypi chayashpaykichi tarinkichi suk wawayuk watadu burrata. Chayta paskashpaykichi wawantinta ñukaman pushamuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ichara suk runa tapushunkichiman: “¿Imapatí kay burrata paskankichi?” Chashna tapushuptikichi willaychi: “Señornini munan montananpa. Suk ratukaman kutichimushkaykisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chayta rurashpa ñawpa yachachikuk runa killkashkantashina ruraykarkan. Kashna killkarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sion llaktapi kawsak runakunata willaychi: ‘Mash kawaychi. Kankunapa sinchi kamachikuknikichi ñami shamuykanna. Mana alabanakuk runa kashpa shamuykanna suk taksha burrupa sawanpi. Suk burra wawanpa sawanpi shamuykan.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chashna burruta pushamunankunapa willaptinkuna chay ishkay disipulunkuna rirkansapa willashkanta rurak. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chaypina Jesusman burrata wawantinta pushamuptinkuna ñukaykuna burritupa sawanpi llachapaynikunata churarkanisapa. Chaypina Jesuska chay burrituta montarkan Jerusalen llaktapi yaykunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jesus riykaptinna aypa runakuna kuyashpankuna katirkansapa. Sukkuna sawa llachapankunata surkukushpankuna Jesuspa rinan ñanpi mantarkansapa. Sukkuna pankayuk ramakunata ñanpi mantarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chaypina Jesuspa ñawpakninta rik runakuna washanta katik runakunapish sukaman kushikushpankuna sinchita willarkansapa: —¡Akuychi kuyaypachi Jesusta ñawpa alli kamachikuk Davidpa miraknin kaptin! Tata Dioska payta kachamushka kamachiwananchikunapa. ¡Akuychi altu sielupi kawsak Tata Diosta sukaman kuyaypachi! ");
INSERT INTO qvsNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus Jerusalenpi yaykuptin chaypi kawsak runakuna sukaman turbakushpankuna tapukurkansapa: —¿Pití kay runaka? ");
INSERT INTO qvsNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesusta katik runakuna willarkansapa: —Kay runaka Tata Diospa rimananta alli yachachikuk Jesusmi. Payka Galilea partipi Nasaret llaktamanta shamushka. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jerusalen llaktapi kashpana Jesuska Tata Diospa wasinpi yaykurkan. Chay wasi pampapi aypa runakuna rantikuykarkansapa rantiykarkansapa. Tukuy chayta kawashpa Jesuska sukaman piñakushpa chay rantikuykak runakunata rantik runakunatapish karkurkansapa. Chaymanta kullkita kambiakuk runakunapa urpayta rantikuk runakunapa mesankunata tikrachipurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Paykunata willarkansapa: —Tata Dios killkadunpi willawanchisapa: “Tukuy runakuna rimankasapa wasini oranankuna wasi kananta.” Tata Dios chayta willawaptinchikunapish kankuna paypa wasinta ruraykankichi suwakunaykichi wasita. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chaymanta mana kawakuk runakuna kojo runakuna Jesusta laduncharkansapa. Paykunata llakichishpankuna alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Chaypina kamachikuk saserdotekunawan Moisespa killkadunta yachachikuk runakuna chay milagruta kawashpankuna sukaman piñakurkansapa. Chaymanta uyarirkansapa Tata Diospa wasinpi wambrakuna kaparikushpa rimaptinkuna: —¡Akuychi kuyaypachi ñawpa alli kamachikuk Davidpa miraknin Jesusta! Chayta uyarishpa saserdotekuna sukaman piñakushpa Jesusta willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—¿Manachu uyarinki chay wambrakuna kuyashushpa willashuykanankunata? Chaypina Jesuska willarkansapa: —Ariya uyarinimi. ¿Manachu kankuna leyishkankichi Tata Diospa killkadunta? Kashna riman: “Kanmi, Tata Dios, sukaman yanapankisapa taksha wambrakunata ñuñukuk wambrakunata kuyashushpa allimata kantanankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chayta willashpana Jesuska chay runakunata sakirkan. Jerusalenmanta Betania llaktaman rirkan chay tuta samananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chaymanta tutapacha Betaniamanta Jerusalen llaktaman kutishpa Jesuska sukaman yarkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chay riykanan ñan ladunpi suk igo kaspita kawarkan. Chayta laduncharkan wayunta mikunayashpa. Wayunta maskashpa mana niman sukta tarirkanchu. Pankankunallata tarirkan. Chaypina chay igo kaspita willarkan: —Kunanmantapacha manana kutin wayuchakunkinachu. Chashna willaptinlla chay igo kaspika chakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ñukaykuna chayta kawashpaynikuna sukaman almirashpa Jesusta tapurkanisapa: —¿Imashnatí kay igo kaspi willashkayki ratulla chakishka? ");
INSERT INTO qvsNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chaypina Jesuska ayniwarkansapa: —Allitami willaykichi. Kankunapish tukuy shunku Tata Diosta kreyishpa atipankichiman ñukashina rurayta. Mana suk igo kaspillatachu atipankichiman chakichiyta. Kay urkutapish willankichiman: “Kaymanta suchushpayki rillay atun yakupi sumik.” Tukuy shunku Tata Diosta kreyishpa willaptikichika kay urkuka suchunka. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tukuy shunku Tata Diosta kreyishpa mañaptikichi payka tukuy mañashkaykichita kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chayta yachachikushkanwasha Jesuska Jerusalen llaktapi chayashpa Tata Diospa wasinpi yaykurkan. Chaypi yachachikuykaptin saserdotekunapa kamachikukninkunawan judiyu awtoridarkuna Jesusta ladunchashpankuna tapurkansapa: —¿Pití kanki chashna yachachikunaykipa? ¿Pití kachamushushka kaykunata yachachikunaykipa? ");
INSERT INTO qvsNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Chashna tapuptinkuna Jesuska willarkansapa: —Ñukapish kankunata tapuykichi. Ayniwaptikichika willashkaykichi pimi kachamuwashka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","May willawaychi. ¿Pití Juanta kachamurkan runakunata bawtisanankunapa? ¿Tata Dioschu suk runachu kachamurkan? Chashna Jesus tapuptinkuna chay runakuna sukwan sukwan willanakurkansapa: —Ayniptinchikuna Tata Dios Juanta kachamushkanta payka willawashunchisapa: “Tata Dios kachamushka kaptin ¿imapatí mana kasushkankichi?” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chaymanta ayniptinchikuna runakuna kachamushkanta tukuy kay runakuna sukaman piñayawashunchisapa. Paykunaka kreyinsapa Tata Dios kachamuptin yachachikushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chashna willanakushpankuna chay runakunaka Jesusta willarkansapa: —Mana yachanisapachu pimi Juanta kachamushka nishpa. Chaypina Jesuska willarkansapa: —Ñukapish manami willaykichichu pimi kachamuwashka tukuy chaykunata ruranaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chaymanta Jesuska chay runakunata willarkansapa: —Mash allita uyariwaychi kay ejempluta parlachiptini: Suk runapa tiyarkan ishkay ullku wambrankuna. Suk diya suk wambranta willarkan: “Kunan rillay uva chakraynipi trabajak.” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chashna tatan willaptin chay wambraka aynirkan: “Mana rinayanichu.” Chaymanta suk ratukaman allita yuyaykushpa rirkan trabajak. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chaymanta chay runaka suknin wambranta willarkan uva chakranpi trabajak rinanpa. Payna almitishpa willarkan: “Ariya, kunanlla rini.” Chashna rimashpapish mana rirkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kunanka willawaychi. ¿Chay ishkay wambrankunamanta maykanti tatanpa munananta rurarkan? Chashna tapuptin paykunaka willarkansapa: —Chay trabajak rik wambra tatanpa munananta rurarkan. Chaypina Jesuska willarkansapa: —Allitami ayniwashkankichi. Kankuna yuyankichi chay romano awtoridarkunapa kobrakukninkuna waynandera warmikuna mana alli rurak kanankunata. Ñukaka willaykichi. Paykuna kankunamanta ñawpakta Tata Diospa mandunpi yaykunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bawtista shamushka yachachishuknikichi allita rurashpa kawsanaykichipa. Kankunaka mana nima kreyishkankichichu. Chaykamanka waynandera warmikuna romanokunapa kobrakukninkuna Tata Diospa rimananta allita kreyishpana kawsarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Chaymanta Jesuska chay runakunata kashkan willarkansapa: —Kunanka yachachiykichi chikan ejempluta. Tiyarkan suk chakrayuk runa. Chay runaka chakranpi uvakunata tarpuchishkanwasha wertata rurachirkan. Chaymanta churarkan suk manllayba batanta chaypi uva wayukunata sarushpankuna illinta kapinankunapa. Chaymanta suk manllayba altu wasita rurachirkan altuyninmanta suk runa kuydananpa. Tukuy chaykunata rurashpana suk runakunawan paktanakurkansapa uvakunata pallashpa paywan patumanakunankunapa. Chashna paktanakushpankuna chay runaka rirkan suk karu llaktaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chaymanta pallana tiempu chayamuptinna chay runaka wiwachunkunata kacharkansapa patuma palladu uvata chaskik. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chaypina chay chakrata kuydak runakuna patron kachashkan wiwachunkunata apishpankuna sukkunata makarkansapa, sukkunata wañuchirkansapa, sukkunata rumincharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaypina chay chakrayuk runaka kashkan ashwan aypa wiwachunkunata kacharkansapa. Paykunatapish chay trabajadorninkuna idenllata rurarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chaymanta patronka kacharkan chaylla wambranta. Yuyarkan: “Kay wambraynita manchashpankuna kasunkasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Chaypina chay trabajadorkuna patronpa wambranta kawashpankuna willanakurkansapa: “Mash kawaychi. Chay shamuykak runa chakrayuk runapa wambranmi. Tatan wañuptin kay chakraka paypa kiparinan tiyan. Kunanlla akuychi wañuchiypachi ñukanchikunapa tukuy kay uva chakra kiparinanpa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chashna willanakushpankuna chay runapa wambranta apirkansapa. Uva chakra washaman pushashpankuna wañuchirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesus chayta yachachikushkanwasha chiknik runakunata tapurkansapa: —¿Imatati yuyankichi? Chay chakrayuk runa kutimushpa ¿imatati ruranka chay mana alli rurak trabajadorninkunata? ");
INSERT INTO qvsNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Paykunaka aynirkansapa: —Chay runaka mana nima llakichishpa tukuy chay mana alli rurak runakunata wañuchinkasapa. Chaymanta chikan trabajadorkunata chakranta kunkasapa kuydanankunapa. Chaypina uva pallana tiempu kaptin paykuna tukuy pallashkankuna uvata patumata kunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chashna willaptinkuna Jesuska willarkansapa: —Kankunaka ¿manachu Tata Diospa killkadunta leyishkankichi? Chay killkadunpi Tata Dioska riman: “Suk runa wasinta rumimanta ruraptin trabajadorninkuna suk alli sinchi rumita wishchurkansapa mana alli nishpa. Chay wasichakuk runaka chay wishchudu rumita wasi kallarinanpi churarkan. Chashna Tata Dios ruraptin sukaman almiranchisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chashna Tata Dios killkadunpi rimaptin ñukaka willaykichi: Payka mananami kankunata munashunkichinachu mandunpi kawsanaykichipa. Suk chikan llaktamanta runakunatami kayanka. Paykunami Tata Diosta kushichishpa kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pipish kashpa mitkakushpa chay sinchi rumipi urmashpa paki paki tukunka. Chaymanta chay wishchudu rumi urmashpa pitapish kaptin apyachishpa wañuchinka. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chaypina kamachikuk saserdotekunawan fariseo runakunaka Jesus yachachikushkanta uyarishpa willanakurkansapa: —Payka willawaykanchisapa iden chay mana alli rurak trabajadorkunashina kananchikunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chashna willanakushpankuna sukaman piñakushpa Jesusta apinayarkansapa wañuchinankunapa. Chashna munashpankunapish mancharkansapa apiyta tukuy runakuna kreyiptinkuna Jesus Tata Dios rimashkanta yachachikuk runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chaymanta Jesus kashkan suk ejempluta rimashpa chay runakunata yachachirkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Yachachiykichi imashnami Tata Diospa mandunpi yaykunkichi nishpa. Suk alli kamachikuk runa wambranpa funsiata rurarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Payka wiwachunkunata kacharkan tukuy konvidadukunata kayanankunapa. Kayaptinkunapish chay konvidadukunaka mana rinayarkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mana rinayaptinkuna chay alli kamachikuk runaka chikan wiwachunkunata kayashpa willarkansapa: “Rillaychi tukuy konvidadukunata willak: ‘Patronninikunaka vakankunata raku animalninkunata ñami wañuchichishkana. Mikunaka ñami ruraduna. Chayrayku chay funsiapi rinkichishi mikuk.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Chashna chay wiwachunkuna willaptinkuna chay konvidadukunaka mana rinayarkansapachu. Sukkunaka chakrankunaman rirkansapa. Sukkunaka rirkansapa negosyunkunata rurak. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sukkunaka chay kayak rikkunata apishpa makarkansapa wañuchinankunakaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chaypina chay alli kamachikukka sukaman piñakushpa soldadunkunata kacharkansapa chay wañuchikuk runakunata wañuchinankunapa. Willarkansapa llaktankunatapish rupachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chaymanta wiwachunkunata willarkansapa: “Funsiapa mikuna ñami ruraduna. Chay konvidashkayni runakuna mana alli rurak kashpankuna manami wasinipi yaykunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chayrayku rillaychi kallikunapi kawanaykichi runakunata kayak funsiaman shamunankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chashna willaptinkuna chay wiwachunkunaka rirkansapa kallikunapi purik runakunata konvidak funsiaman rinankunapa. Alli rurak mana alli rurak runakunata konvidaptinkuna chay manllayba wasinpi aypa runakuna tantanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Chaypina chay alli kamachikuk runaka konvidadukunata kawak yaykurkan. Chaypi sukta kawarkan mana funsiapi yaykunapa laya llachapayukta. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Payta kawashpa willarkan: “Amigu ¿imapati yaykumushkanki mana funsiapi yaykunapa laya llachapayuk?” Chashna tapuptin chay runaka mana nima ayniyta atiparkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chaypina chay alli kamachikuk runaka mesaman mikuna apak runakunata willarkan: “Kay runata chakinta makinta watashpa wishchukuychi wasi washa tutayaduman. Chaypi kastigunta mana muchushpa sukaman kirunkunata mukushpa wakanka.” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chashna Jesus yachachikushpa willarkansapa: —Tata Dioska aypa runakunata kayansapa mandunpi yaykunankunapa. Chashna kayaptinkunapish sukkunalla aklladu kashpa yaykunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesus yachachikushkanwasha fariseo runakuna chikanpi tantanakushpankuna willanakurkansapa: —Akuychi Jesusta pantachichiypachi mana allita rimananpa. Mana kuskanpi rimaptin awtoridarkunapi chatakushunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chayta ruranayashpankuna fariseokunaka kikinkunapa disipulunkunawan Herodespa partidunta katikkunata kacharkansapa Jesusta tapuk: —Maestru, ñukaykuna yachanisapa mana llullakushpa allimallata yachachikunaykita. Tukuy runakunata yachachinki Tata Diospa munananta rurashpa kawsanankunapa. Kanmi tukuy laya runakunapa yuyayninkunata allimata riksinki. Chayrayku ni pita manchashpa yachachikunki. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kunanka willawaysapa: Chay romano sinchi kamachikuk kullkinikunata mañawaptinkuna ¿allichu manachu pagarakunaynikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chashna tapuptinkuna Jesuska yacharkan pantachichinayashpa tapushkankunata. Chaypina willarkansapa: —Kankunaka allipi tukushpa llullachiwanayaykankichi. ¿Imapatí chashna tapuwashpa pantachichiwanayankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mash chay pagarakunaykichi kullkita kawachiwaychi. Chayta mañaptinkuna suk kullkita kurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus chay kullkita kawashpana tapurkansapa: —¿Pipa uyantí pipa shutintí killkadu kay kullkipika? ");
INSERT INTO qvsNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Chaypina paykunaka aynirkansapa: —Romano ashwan sinchi kamachikuk Sesarpa. Chashna ayniptinkuna Jesuska willarkansapa: —Chay kamachikuk Sesarpa kaktaka payta kuychi. Tata Diospa kaktaka payta kuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chayta willaptinkuna chay pantachichinayak runakunaka sukaman almirashpankuna upallalla Jesusmanta anchurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chaymanta chay diyalla saduseo runakuna rirkansapa Jesuswan parlak. Saduseokunaka yachachikunsapa mana ni pi wañushkanmanta kawsamunanta. Chayrayku paykunaka Jesusta willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestru, ñawpa yachachikuk Moises kashna yachachikurkan: “Suk kasadu ullku manara ni suk wambrayuk kashpa wañuptin wawkin chay viyudawan kasaranan tiyan. Chaypina ullku wambrata wawayaptin wañudupa wambranshina kanan tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kunanka willayki. Kay llaktaynikunapi kanchis wawkipura tiyarkan. Chaypina mayor wawki kasararkan. Chay ullku manara niman suk wambrayuk kashpa wañurkan. Chay mayor wañuptin wawkin viyuda kuñadanwan kasararkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Paypish wañurkan niman suk wambrayuk kashpa. Chaypina chay viyudaka kashkan kasararkan ishkaynin mashanwan. Paypish mana niman suk wambrayuk kashpa wañurkan. Chashna kusankuna wañuptin wañuptinlla chay warmika tukuy mashankunawan kasararkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tukuy kusankuna wañuptinkuna chay warmipish wañurkanna. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kunanka willawaysapa. Tukuy chay runakuna chay viyudawan kasararkan. Wañudu runakuna kawsamushpankuna chay kanchis wawkipuramanta ¿maykan kakpatí kanman warminka? ");
INSERT INTO qvsNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chashna tapuptinkuna Jesuska aynirkansapa: —Kankunaka Tata Diospa killkadunta mana entiendishpa kikikichilla llullachinakuykankichi. Manami yachankichichu Tata Dios sukaman atipak kashpa wañudukunata kawsachimunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tata Dios wañudu runakunata kawsachimushkanwasha mana niman suk ullku niman suk warmi kasarankasapanachu. Sielupi kawsak angelkunashina kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Manachu leyishkankichi Tata Diospa killkadunta? Chaypi riman wañudukuna kawsamunankunata. Tata Dios kashna riman: ");
INSERT INTO qvsNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ñuka Abrahampa Isakpa Jakobopa Tata Diosninmi kani.” Chashna Tata Dios rimaptin yachanchisapa chay ñawpa awilunchikuna wañushkankunamanta kawsamushkankunata. Tata Dios kawsak runakunallapa Diosninmi. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chayta uyarishpankuna chay runakuna sukaman almirarkansapa Jesus allimata yachachikuptin. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chaymanta fariseo runakuna yachashpa Jesus saduseokunata upallayachishkankunata tantanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Suk fariseoka ñawpa Moisespa killkashkanta yachachikuk runa karkan. Payka Jesusta pantachichinayashpa tapurkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestru, Tata Diospa tukuy kamachikunankunamanta ¿maykanti ashwan alli kasunaynikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Chayta tapuptin Jesuska willarkansapa: —Tukuy kamachikunankunamanta kaymi ashwan alli: “Kamachikuk Tata Diosnikita tukuy shunku kuyanayki tiyan. Payta sukaman munashpa allita yuyaykushpa kawsanayki tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chaymanta chay ishkaynin kamachikunanka chay layallami: “Kikiki kuyanakukshina tukuy runamasikikunata kuyashpa kawsay.” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kay ishkay kamachikunankuna tukuy Moisespa kamachikunankuna tukuy ñawpa alli yachachikukkunapa killkashkankuna orkonkunashina sinchichin. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chayllapi tantanakudu kaptinkuna Jesuska fariseokunata tapurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Kankunaka ¿imatati yuyankichi sielumanta shamuk salvakuk runapa? ¿Maykan runapa mirakninti? Chashna tapuptinkuna fariseokunaka aynirkansapa: —Payka ñawpa awilunchi Davidpa mirakninmi. ");
INSERT INTO qvsNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chaypina Jesuska willarkansapa: —Davidpa miraknin kaptinka ¿imapatí Tata Diospa Espiritun yanapaptin Davidka rimarkan paypa kamachikuknin kananta? Davidka kashna killkakurkan: ");
INSERT INTO qvsNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Tata Dioska kamachiwak runata willarkan: ‘Kay alli laduynipi tiyariy ñukawan kamachikunaykipa ñuka tukuy chiknishuk runakunata saru saru ruranaynikaman kanta kasushunankunapa.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chay killkadu rimananpi Davidka willarkan sielumanta shamuk salvakuk runa paypa sinchi kamachikuknin kananta. Davidpa kamachikuknin kaykaptinka ¿imashnatí paypa miraknin kanman? ");
INSERT INTO qvsNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chashna Jesus yachachikuptin chay fariseokuna mana nima ayniyta atiparkansapanachu. Chay tiempumantapacha niman suk runa animukurkannachu Jesusta nimata tapuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaymanta Jesus chay fariseo runakunata yachachishkankunawasha chay tantanakudu runakunawan ñukaykunata yachachiwarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisespa killkadunkunata yachachikuk runakunawan fariseo runakuna tantanakunankuna wasipi tiyarinsapa chay killkadukunata yachachikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Paykunapa yachachikunankunata kasuychi. Tukuy willashushkaykichita ruraychi. Chayta rurashpaykichi ama paykuna ruranankunatashina ruraychichu. Paykuna sukaman allita yachachishushpaykichipish kikinkuna mana yachachishunaykichita ruransapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paykunaka tukuy runakunata sukaman kamachinsapa. Chay rikchak laya yachachikunankunata willashpankuna paykunaka mana atipana laya sukaman llashak kargata aparichikshinami. Chaypina kikinkuna yachachikushkankunata mana niman suk tipisituta ruranayansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Paykunaka tukuy layata ruransapa runamasinkuna kawanankunallapa. Tata Diospa rimananta tipi llañu karapakunapi killkansapa. Chaykunata urkunkunapi brasunkunapi watashpankuna purinsapa. Chaymanta llachapankuna mañanpi sumachishpankuna mudakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fiestakuna tiyaptin ashwan allima tiyarinakunapi munansapa tiyariyta. Tantanakunankuna wasikunapi ashwan allima bankukunapi tiyarinayansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kallikunapi purishpankuna sukaman munansapa tukuy runakuna kuyashpa “maestru” nishpa rimachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kankuna ama paykunashina munaychichu “maestruynikuna” nishpa willashunaykichita. Kankunaka wawkipurallami kankichi. Ñukallami maestruykichi kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chaymanta kay allpapi kawsak runakunata ama niman sukta Tata Diostashina “Tatayni” nishpa willaychichu. Tata Diosnikichika sukllallami. Payka sielupimi kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chaymanta ama nima munaychichu runamasikichi willashunaykichipa “kanmi kanki kamachiwakninikuna” nishpa. Ñukallami kamachikuknikichi kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Chaymanta kankuna ashwan alli kamachikuk kanayashpaykichi tukuy runamasikichita sukaman yanapanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kankuna kikikichilla kreyinakushpa kawsaptikichi Tata Dios sukaman pinkachishunkichi. Chaymanta allillapi mana kreyinakushpa runamasikichita kuyashpa yanapaptikichi Tata Dios sukaman kushikushpa yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Chaypina Jesuska willarkansapa: —Alaw, kankuna fariseokunata Moisespa killkadunta yachachikuk runakunata sukaman llakichiykichi. Kankunaka allipi tukushpa llullakuykankichi. Tata Diosta mana nima kasunayashpa kawsankichi. Chaymanta chay kasunayak runakunata sukaman michashpa pantachichinkichi ama Tata Diospa mandunpi yaykunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Alaw, kankuna fariseokunata Moisespa killkadunta yachachikuk runakunata sukaman llakichiykichi. Kankunaka allipi tukushpa llullakuykankichi. Viyuda warmikunata mana nima llakichishpaykichi wasinkunata doyñuyapunkichi. Chayta rurashpaykichipish allipi tukushpa Tata Diosta unayta orankichi. Chayrayku Tata Dios sukkunamanta ashwanta kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Alaw, kankuna fariseokunata Moisespa killkadunta yachachikukkunata sukaman llakichiykichi. Kankuna allipi tukushpa llullakuykankichi. Ariya yakuta allpata purinkichi suk runata yachachinaykichipa kankunashina kawsananpa. Chaymanta chay runata sukaman pantachichiptikichi payka kankunamanta ashwanta uchallikun. Chayrayku Tata Dios mana tukuyniyuk ninapi kankunamanta paykunata ashwanta kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Alaw, kankunata llakichiykichi. Kankuna iden mana kawakukshina kaykashpaykichipish sukkunata ñanta riksichinayankichi. Llullakushpa yachachinkichi: “Suk runa Tata Diospa wasinpa jurashpaka mana ruraptinpish mana nimananchu. Chaymanta Tata Diospa wasinpi tiyak kuripa jurashpa tukuy jurashkanta ruranan tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Chashna yachachikushpaykichi mana alli yuyaykuk mana nima entiendik runakuna kankichi. ¿Maykantí ashwan alli? ¿Tata Diospa wasinchu? ¿chay wasipi kurichu? Chay kuri Tata Diospa wasinpi churadu kashpara paypa kiparin. Chayrayku Tata Diospa wasinka chay churadu kurimanta ashwan allimami. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chaymanta kankuna llullakushpa yachachikunkichi: “Suk runa altarpa jurashpa mana ruraptinpish mana nimananchu. Chaymanta altarpi ofrendapa jurashpa tukuy rimashkanta ruranan tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Chayta yachachikushpaykichi mana nima entiendik runakuna kankichi. ¿Maykantí ashwan alli? ¿Altarchu? ¿chay altarpi churadu ofrendachu? Chay ofrenda altarpi churadu kashpara Tata Diospa kiparin. Chayrayku ofrendakunamanta altar ashwan alli. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Suk runa altarpa jurashpa mana altarllapachu juran. Tukuy chay altar sawanpi churadukunapapish juran. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chaymanta suk runa Tata Diospa wasinpa jurashpaka mana wasinllapachu juran. Tata Dios chay wasinpi kawsaptin chay runaka kikin Tata Diospa shutinpi juraykan. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sielupi Tata Dioska allima tiyarinanpi tiyaridumi. Chayrayku suk runa sielupa jurashpa mana sielullapachu juraykan. Kikin Tata Diospa shutinpi tiyarinanpapish juraykan. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Chaymanta Jesuska willarkansapa: —Alaw, kankuna Moisespa killkadunta yachachikuk runakunata fariseo runakunata sukaman llakichiykichi. Kankuna allipi tukushpa llullakuykankichi. Mentapa kominospa anispa chunkamanta sukta suchuchinkichi Tata Diosta kunaykichipa. Chaykamanka ashwan kasunaykichipa kamachikunankunata mana kasunkichichu. Tata Dios willawanchisapa allillata rurashpa runamasinchikunata llakichishpa kawsananchikunapa. Chaymanta rimashkanchikunata rurananchikuna tiyan. Chay kamachikunankunata alli kanman ruranaykichipa. Chaymanta chunka tiyapushunaykichimantapish sukta Tata Diosta kuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kankunaka mana allita entiendishpaykichi iden mana kawakuk runakunashina kaykashpaykichi suk runakunata munankichi ñanta riksichiyta. Chaymanta suk kishnisillu moskitu yakuykichipi sipikuptin shushunkichi ama millpunaykichipa. Chaykamanka mana nimatashina yuyankichi suk manllayba kamellu animalta millpunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Chaymanta Jesuska willarkansapa: —Alaw, kankuna Moisespa killkadunta yachachikuk runakunata fariseo runakunata sukaman llakichiykichi. Kankuna allipi tukushpa llullakuykankichi. Suk vasu suk kallana washanlla maylladushina kankichi. Kankuna alli rurak runa tukushpaykichi tukuy layakunata kikikichillapa munankichi. Tukuy layakunata munankichi suwayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kankuna fariseo runakuna mana nima entiendik kashpaykichi iden mana kawakuk runakunashina kankichi. Suk susya vasupa ukunta mayllaychi washantapish chuya chuya kiparinanpa. Tata Diosta roygaychi tukuy uchaykichimanta perdonashunaykichipa. Chaypirami allita rurashpa kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Alaw, kankuna fariseo runakunata Moisespa killkadunta yachachikuk runakunata sukaman llakichiykichi. Kankunaka allipi tukushpa llullakuykankichi. Iden yurakyachidu bovedashinami kankichi. Chay boveda allimata rikurishpapish ukunpi millanapa laya wañudupa tullunkuna kiparinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chay bovedashina kankuna allimata rikurinkichi. Alli rurakshina tukunkichi runakuna kreyishunankunapa. Kankunapa tukuy yuyaynikichi sukaman mana alli kashpa mana alli rurak runakuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Alaw, kankuna Moisespa killkadunta yachachikuk runakunata fariseo runakunata sukaman llakichiykichi. Kankunaka allipi tukushpa llullakuykankichi. Ñawpa yachachikuk runakunapa allima bovedankunata rurankichi ama paykunata kunkanaykichipa. Chaymanta ñawpa alli rurak runakunata yuyashpa monumentunkunata sumachinkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chayta rurashpa rimankichi: “Ñawpa awilunchikuna yachachikuk runakunata wañuchirkansapa. Ñukanchikuna ñawpa tiempu kawsashpanchikunaka manami wañuchiyta yanapanchimansapachu karkan.” ");
INSERT INTO qvsNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chashna rimashpaykichi yuyanakuykankichi iden chay wañuchikuk awiluykichishina kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Paykunamanta ashwan sakra wañuchikuk runakuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kankunaka iden machakuykunashina sakra likidumi kankichi. ¿Imashnatí chay mana tukuyniyuk nina kastigumanta kishpinkichiman? ");
INSERT INTO qvsNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chayrayku ñukaka Tata Dios rimashkanta yachachikuk runakunata kachashasapa yachachishunaykichipa. Yachaysapa runakunatapish kachashasapa. Kankuna sakra mana allita rurakkuna kashpaykichi sukkunata wañuchinkichi. Sukkunata chakatashpa wañuchinkichi. Sukkunata chiknishpa tantanakunankuna wasikunapi makankichi. Chaymanta llaktan llaktanpi sukkunata chiknishpa padesichiypi katinkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chay mana alli rurashkaykichirayku Tata Dioska kastigashunaykichi tiyan. Kayin chay ñawpa alli rurak wawkin Abelta wañuchirkan. Chay tiempumantapacha chiknikuk runakuna allita rurashpa kawsak runakunata wañuchirkansapa. Tata Diospa wasin altarpa ladunpi kankunapish Berekiyaspa wambran Sakariyasta wañuchirkankichi. Tukuy chay wañuchidu runakunarayku Tata Dioska kankunata sukaman kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Allita willaykichi: Aypa runakuna runamasinkunata wañuchishkankunarayku Tata Dioska kay tiempupi kawsak runakunata kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Chaymanta Jesuska Jerusalen llaktapi kawsak runakunata sukaman llakichishpankuna willarkansapa: —Sukaman kankunata llakichiykichi. Tata Dios rimashkanta yachachikukkunata wañuchinkichi. Tata Dios kachashkan yachachikuk runakunatapish ruminchashpa wañuchinkichi. Ñuka aypa kuti kankunata amachanayashkaykichi iden suk wallpa wawankunata rikran sikipi tantanachishpa amachakshina. Sukaman kankunata amachanayaptinipish mana nima layapi munankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mash uyariwaychi. Mana munawashkaykichirayku llaktaykichi chunlla likidu kiparinka. ");
INSERT INTO qvsNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chaymanta willaykichi. Suknin diya kankunaka willawanaykichi tiyan: “Kanka sukaman allima kanki Tata Diosmanta shamudu runa kashpayki.” Chashna willawanaykichi diyakaman mananami kawawankichinachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chayta yachachikushkanwasha Jesuska Tata Diospa wasinmanta llukshirkan. Riykaptin ñukaykuna ladunchashpa willarkanisapa: —Mash kaway kay allima ruradu Tata Diospa wasinta. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chashna kawachiptinikuna Jesuska willawarkansapa: —Kunan kawachiwaykankichi kay allima ruradu wasita. Mash allita uyariwaychi. Shamunkasapa chiknishuk runakuna tukuy kay kawashkaykichi allima pirkakunata urmachik. Urmachiptinkuna mana niman suk rumi sawapura kiparinkanachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chaymanta Jesus Olivos urkuman rirkan. Chaypi tiyariptin ñukaykunalla ladunchashpaynikuna tapurkanisapa: —¿Aykapiti Tata Diospa wasinta urmachinkasapa? ¿Imata kawashpati yachaymansapa kutimunayki tiempu kananta? ¿Imashnati yachaymansapa kay allpa kullunan tiempu kananta? ");
INSERT INTO qvsNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chaypina Jesuska willawarkansapa: —Allita kuydanakuychi ama ni pi llullachishunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Manara kutimuptinira aypa runakuna shamunkasapa ñukapi tukushpa willashuknikichi: “Ñukami kani Tata Diosmanta shamudu salvakuk runa.” Chashna rimashpankuna aypa runakunata llullachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kankuna uyarinkichi runakuna chikninakushpankuna kaypi chaypi makanakushpa wañuchinakunankunata. Chayta uyarishpaykichi ama manchakuychichu. Chashna makanakushpa wañuchinakushpalla kawsanankuna tiyan. Chashna kaptinpish manara tukunan tiempurachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Suk partipi kawsak runakuna chikan llaktapi kawsakkunawan sukaman chikninakushpankuna makanakushpa wañuchinakunkasapa. Chaymanta aypa llaktakunapi sinchi yarkay tiyanka. Aypa llaktakunapi allpa sinchita kuyunka. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Chashna runakuna chaykunawan sukaman sufrishpankuna ashwantara sufrinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Chaypina chiknishuk runakuna awtoridarkunapi chatashunkichi sufrichishunaykichipa. Ñukata kreyiwashpa kawsashkaykichirayku tukuy llaktakunapi aypa runakuna chiknishushpaykichi wañuchishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chay tiempu runakuna manana munankasapanachu kreyiwashpa kawsayta. Chaymanta sukwan sukwan chikninakushpankuna awtoridarkunapi chatanakushpa kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aypa llullachikuk runakuna rimankasapa Tata Dios rimashkanta yachachikuykanankunata. Chashna yachachikushpa aypa runakunata llullachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aypa runakuna sukaman ashwan ashwanta uchallikushpalla kawsaptinkuna aypa ñukata kreyiwakkunapish manana kuyanakushpanachu kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kankuna wañunaykichi diyakaman allita ñukallata kreyiwashpa kawsaptikichi Tata Dioska salvashunkichi rinaykichipa sielupi kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chayrayku tukuy kay allpapi kawsak runakunata yachachinaykichi tiyan ñukata kreyiwashpa Tata Diospa mandunpi yaykunankunapa. Chaymanta tukuy llaktakunapi rimanaynita uyariptinkunara kay allpa tukunan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Chaymanta Jesuska ñukaykunata willawarkansapa: —Ñawpa yachachikuk Daniel Tata Dios rimashkanta killkarkan: “Tata Diospa wasinpi suk chiknikuk runa sukaman sakra millanapa layata ruranka.” Chaymanta Tata Diospa wasinpi chay runa yaykuptin chay Daniel killkashkanta leyishpaykichi allita yuyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chashna Tata Diospa wasinpi chay millanapa layata ruraptin kawashpaykichi Judeapi kawsakkuna urkukunaman nitikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasi altuyninpi kashpaykichika chayllamanta nitikuychi. Amana wasikichipi yaykuychinachu nima tiyapushunaykichita surkuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chakraykichipi trabajaykashpaykichika chayllamanta nitikuychi. Ama wasikichiman kutiychichu alli llachapaykichita surkuk. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chay sinchi llakina tiempu okupada warmikuna ñuñuchikuk warmikuna sukaman sufrinkasapa. Chayrayku paykunata sukaman llakichini. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kankuna Tata Diosta roygaychi ama tamya tiempu nima samana diya nitikunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay sinchi llakina tiempu tukuy runakuna sukaman sufrinkasapa. Tata Dios kay allpata rurashkanmantapacha manara chay laya llakina tiempu tiyarkanrachu. Nima chay tiempu washan chay laya llakina tiyankachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tata Dioska tukuy akllashkan runakunata kuyashkanrayku chay llakina tiemputa tukuchanka. Mana utka tukuchaptinka tukuy runakuna wañunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chaymanta Jesuska ñukaykunata yachachiwaysapallapi katirkan: —Chay tiempu ichara suk runakuna willashunkichiman: “Mash kawaychi. Kaypinami chaypinami Tata Diosmanta shamudu salvakuk runa.” Chashna willashuptinkuna ama kreyiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chay tiempu aypa runakuna llullachikushpa rimankasapa Tata Diosmanta shamudu salvakuk runakuna kanankunata. Sukkuna llullachikushpa rimankasapa Tata Dios kachamushkanta yachachikunanpa. Paykunaka rikchak laya almirana milagrukunata rurankasapa. Chayta rurashpankuna munankasapa Tata Dios akllashkan runakunatapish llullachiysapata. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ñami yachachishkaykichina ama chay llullachikuk runakunata kreyinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sukkuna willashunkichiman: “Rillaychi payta kawak chunlla chakidu pampapi.” Chashna willashuptikichika ama rillaychichu. Sukkuna willashunkichiman: “Mash shamuychi kay wasi ukupimi pakakudu.” Chashna willashuptikichika ama kreyiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ñuka sielumanta shamudu runa kashkan shamuptini tukuy runakuna kawawankasapa. Imashnacha puyukunapi llipyak suk ladumanta chikan laduta raslla llipyan chashnami ñukapish shamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wañudukuna kananpi siyukakuna tantanakunsapa. Ñukapish tukuy mana alli rurak runakunata tantanachishasapa kastiganaynipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Chaymanta Jesuska ñukaykunallata yachachiwashpa willawarkansapa: —Chay sinchi llakina tiempu tukuptinna inti tutayanka. Killa manana lusichikunkanachu. Luserukuna sielumanta urmamunkasapa. Sielupi llipyakkuna kuyunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaypina ñuka sielumanta shamudu runa manarapish kutimuptinira suk señalta sielupi rikurichisha. Chayta kawashpa tukuy kay allpapi kawsak runakuna sukaman manchakushpankuna sinchita wakankasapa. Puyukuna ukunpi llipyashpa sielumanta kutimuptini tukuy pi kawawashpankuna yachankasapa tukuy laya atipak kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chaypina angelninikunata kay allpaman kachamushasapa trompetata sinchita pukunankunapa. Pukushpankuna kay allpapi tukuy kuchun mañankunamanta tukuy aklladuynikunata tantanachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mash uyariwaychi. Suk igo tronkota kawashpa yachakuychi. Igo ramankuna velachakushpa aypata pankayaptin yachankichi veranu tiempu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chashnashina tukuy kay willashkaynita kawashpaykichi yachankichi ñuka utka shamunaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Allita willaykichi: Kunan kay tiempupi kawsakkuna manarapish wañushpankunara tukuy kay willashkaynita kawankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tukuy kay allpaka sielukunapish kullunankuna tiyan. Chashna kulluptinpish ñuka tukuy rimashkaynita rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tata Diosllami yachan imay diyami imay orami ñuka kutimusha nishpa. Mana ni suk runa nima sielupi kawsak angelkuna yachansapachu. Nima ñuka Tata Diospa wambran kaykashpaynipish mana yachanichu aykapimi kutimusha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noepa tiempunpi runakuna Tata Diosta mana nima yuyashpa kawsarkansapa. Chashnami ñuka sielumanta shamudu runa kashkan kutimuptini runakuna Tata Diosta mana nima yuyashpa kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chay tiempu manara Tata Dios allpata yakuwan untachiptinra tukuy runakuna mikushpankunalla upyashpankunalla kasarakushpankunalla kawsarkansapa. Noe manllayba barkupi yaykunan diyakaman chashnalla kawsarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chay runakuna mana nima yuyashkankuna oras Tata Dios allpata yakuwan untachiptin tukuy sipikurkansapa. Ñuka sielumanta shamudu runa kutimuptini mana nima yuyashkankuna oras runakuna kullunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chay oras ishkay runakuna chakranpi tantalla trabajaptinkuna sukta pushasha sukta sakisha. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ishkay warmi suk batanllapi kutakuykaptinkuna sukta pushasha sukta sakisha. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kankunaka mana yachankichichu ñuka kamachiknikichi imay orami kashkan shamusha nishpa. Chayrayku shamunaynita yuyashpalla kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mash allita uyariwaychi. Suk runa yachashpa imay oratami tutapi suwa shamunman nishpa mana puñushpa uyari uyari shuyanman. Chashna shuyaptin chay suwa runa mana wasinpi yaykunmanchu suwakunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chayrayku kankunapish prontanakushpa shuyawaychi. Mana yuyashkaykichi oras ñuka sielumanta shamudu runa kutimusha. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chaymanta Jesuska ñukaykunallata yachachiwaysapallapi katirkan: —Suk patron chikan llaktaman rinanpa suk alli rurak yachaysapa wiwachunta willan tukuy wiwachumasinkunata trabajachinankunapa. Chaymanta willan oranpi karanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chay wiwachu kushikunka patronnin willashkanta allita rurashkanta tarimuptin. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Alli kasukuk runa kaptin patronninka tukuy laya tiyapunanta kuydapunanpa sakinka. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Chaymanta ichara chay wiwachun yuyanman patronnin mana utka kutimunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chayta yuyashpa kallarinman wiwachumasinkunata makashpa sufrichiyta. Chaymanta machadu runakunawan tantanakushpa mikunman upyanman. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mana allita rurashpa kawsaykaptin mana yuyashkan oras patronninka kutimushpa sukaman kastiganka. ");
INSERT INTO qvsNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mana nima llakichishpa tukuy llullachikuk runakunawan tantallata kastiganka. Chaypina chay mana alli rurak runa kastigunta mana muchushpa kirunta mukushpa sukaman wakanka. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chaymanta Jesuska ñukaykunata yachachiwaysapallapi katirkan: —Kunan parlachiykichi chunka shipashkunapa ejemplunta yachanaykichipa imashnami ñukata shuyawankichi Tata Diospa mandunpi yaykunaykichipa. Chunka shipashkuna alkusankunata apashpankuna rirkansapa noviota tinkuk paywan tantalla funsia wasiman rinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chay chunka shipashkunamanta pichka yachaysapakuna karkansapa. Pichka mana yachaysapakuna karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay pichka mana yachaysapakuna alkusankunata apashpa mana wirata aparkansapachu kashkan wirachanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Chay pichka yachaysapa shipashkunaka alkusankunata apashpa botellankunapi wirata aparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chaypina novio mana utka chayaptin puñunayashpankuna chunkantin shipashkuna puñurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yaka chawpi tutata sunipi uyarirkansapa suk runa kayakuptin: “Ñami novioka shamuykanna. Llukshimuychina tinkuk.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chaypina chay shipashkunaka utka atarishpankuna alkusankunata kallarirkansapa allichayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chay pichka mana yachaysapa shipashkunaka chay pichka shuyakmasinkunata willarkansapa: “Alkusaynikunapa wiranka ñami tukushkana. Suk tipi wiraykichita kuwaysapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chashna mañaptinkuna chay pichka yachaysapa shipashkunaka willarkansapa: “Wirata munashpaykichika rillaychi rantik. Wirata kuptinikunaka ñukaykunapapish pishinman.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mana kunayaptinkuna chay pichka mana yachaysapa shipashkunaka rirkansapa wirata rantik. Rinankunakaman novioka chayarkan. Chaypina paywan tantalla chay pichka yachaysapa shipashkunaka funsia wasipi yaykurkansapa. Tukuy yaykuptinkunana novioka wasi punkuta wichkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chaymanta chay pichka mana yachaysapa shipashkunaka chayarkansapa. Punkuta takashpankuna noviota kayarkansapa: “¡Señor, Señor, kichariy ñukaykunapish yaykunaynikunapa!” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Chaypina payka ukumanta willarkansapa: “¡Manami kankunata riksiykichichu!” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chay ejempluta willashkanwasha Jesuska ñukaykunata willawarkansapa: —Kankuna mana yachankichichu imay orami imay diyami ñuka kutimusha nishpa. Chayrayku allita prontanakushpa mana shaykushpa shuyawanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Chaymanta Jesuska ñukaykunallata yachachiwaysapallapi katirkan: —Suk ejemplunta parlachiykichi yachanaykichipa imata rurashpami Tata Diospa mandunpi kawsankichi nishpa. Suk patron karu llaktaman rinanpa trabajadorninkunata kayashpa kullkinta kurkansapa mirachipunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Chay patronka suk trabajadorninta pichka waranka kullkita kurkan. Sukta ishkay waranka kullkita kurkan. Sukta suk waranka kullkita kurkan. Kimsantin trabajadorninta kullkita kurkan mirachiyta atipananta riksishpa. Ashwan alli trabajak runata ashwan aypa kullkita kurkan. Chay kullkita kushpana suk karu llaktaman rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chaypina chay pichka warankata chaskishka runaka chay kullkiwan negosyunta rurashpa suk pichka warankata mirachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chashnashina chay ishkay warankata chaskishka runapish negosyunta rurashpa suk ishkay warankata mirachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Chaymanta chay suk warankata chaskishka runaka mana chay kullkiwan trabajanayashpa allpapi pamparkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chaymanta unay tiempumanta chay patronka kutimurkan. Chaypina kullki chaskishka runakunata tapurkansapa mashnatami mirachishkasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chaypina pichka waranka kullkita chaskishka runaka chunka warankata apamushpa patronninta willarkan: “Señor, kutichiyki kay pichka waranka kuwashkayki kullkikita. Chaymanta kuyki kay pichka waranka mirachishkayni kullkitapish.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chay mirachidu kullkita kuptinna patronka willarkan: “Allitami rurashkanki. Kanmi alli kasuwak alli rurak runa kashkanki. Kay tipi kushkayni kullkiwan allita trabajashkanki. Chayrayku ashwanta kushkayki chaywan ashwanta trabajanaykipa. Kunanka ñukawan tantalla wasinipi yaykumuy kushikunaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chaypina chay ishkay waranka kullkita chaskik runaka patronninta ladunchashpa willarkan: “Señor, ñukata kuwashkanki ishkay warankata trabajachinaynipa. Kunanka chaytami kutichiyki. Chaymanta kay mirachishkayni ishkay warankatapish kuyki.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chashna chusku waranka kullkita kuptinna patronka willarkan: “Allitami rurashkanki. Kanmi alli kasuwak alli rurak runa kashkanki. Kay tipi kushkayni kullkiwan allita trabajashkanki. Chayrayku ashwanta kushkayki chaywan ashwanta trabajanaykipa. Kunanka ñukawan tantalla wasinipi yaykumuy kushikunaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chaymanta suk waranka kullkita chaskik runaka patronninta ladunchashpa willarkan: “Señor, ñuka allita riksiyki sukaman trabajachikuk sinchi patron kanaykita. Kanka chikan runapa tarpushkankunata pallanki. Chikan runapa mirachishkanta apinki. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sakra kanaykita yachashpayni manchakushkani. Chayrayku kuwashkayki kullkita allpapi pampashkani. Kay waranka kullki kuwashkaykillata kutichiyki.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Chashna kuptinna patronninka willarkan: “Kanka mana kasuwak sukaman killa likidu runa kashkanki. Yachashkanki ñuka chikan runapa trabajashkankunata pallanaynita chikan runapa mirachishkanta apinaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chayta yachaykashpayki ¿imapatí kullkinita mana suk banku ofisinapi churarkanki chaypi mirachipanankunapa? Ñuka kutimuptini kullki miraduta surkunkiman karkan kuwanaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chayta willashpa patronka chaypi kak runakunata willarkansapa: “Kay runata chay waranka kushkayni kullkita kichuychi chay chunka waranka mirachik runata kunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tata Dios allita rurayta yachak runata ashwanta kunka puchunankaman tiyapunanpa. Mana allita rurak runapa tipi tiyapushkanta kichunka. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chayrayku tutayadu washaman kay killa likidu mana kasuwak runata wishchuychi. Chaypina kastigunta mana muchushpa kirunta mukushpa sukaman wakanka.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Chaymanta Jesuska ñukaykunallata yachachiwaysapallapi katirkan: —Ñuka sielumanta shamudu runa tukuy angelninikunawan tantalla kutimusha. Chaypina llipyak likidu allima tiyarinaynipi tiyarisha kamachikunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chaypi tiyariptini tukuy llaktakunamanta runakuna ñawpakninipi tantanakunkasapa. Iden suk runa chivunkunamanta ovejankunata ashuchikshina ñukapish mana alli rurak runakunamanta alli rurak runakunata ashuchisha. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ñukata kasuwak runakunata ovejakunatashina alli laduynipi churashasapa. Mana kasuwak runakunata chivukunatashina lluki laduynipi churashasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chaypina ñuka sinchi kamachikuk kashpayni alli laduynipi churashkayni runakunata willashasapa: “Tatayni kankunata kushichishuptikichi shamuychi ñukawan tantalla kamachikunaykichipa. Tata Dios kay allpata rurashkanmantapacha kankunapa llaktaykichita rurarkan chaypi kamachikunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ñuka yarkaptini kankuna karawarkankichi. Yakunayaptini yakuchiwarkankichi. Karu llaktamanta llaktaykichipi chayaptini wasikichipi chaskiwashpa samachiwarkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Llachapayni mana tiyawaptin kankunaka kuwarkankichi mudakunaynipa. Unkudu kaptini chapawak rirkankichi. Karselpi kaptini chapawak rirkankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Chashna willaptini chay alli rurak runakuna tapuwankasapa: “Señor ¿aykapiti yarkaymanta kaptiki karashkaykisapa? ¿Aykapiti yakunayaptiki yakuchishkaykisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Aykapiti karumanta llaktaynikunapi chayamuptiki wasinikunapi chaskishpa samachishkaykisapa? ¿Aykapiti llachapayki pishiptin llachapata kushkaykisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Aykapiti unkudu kaptiki karselpi kaptiki chapashkaykisapa?” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chashna tapuwaptinkuna ñuka alli kamachikuk kashpayni willashasapa: “Kankunaka sufrikmasinikunata yanapashpaykichi ñukatami yanapawashkankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chaymanta lluki laduynipi churashkayni runakunata willashasapa: “Ñukamanta anchuychi Tata Dios kastigashunaykichipa. Rillaychi mana tukuyniyuk ninaman. Tata Dios chay ninata rurashka tukuy supaykunata paykunapa kamachikukninta kastiganankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ñuka yarkaptini mana karawarkankichichu. Yakunayaptini mana yakuchiwarkankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Llaktaykichipi chayaptini mana wasikichipi chaskiwarkankichichu samanaynipa. Llachapayni mana tiyaptin mana nimata kuwarkankichichu mudakunaynipa. Unkudu kaptini karselpi kaptini mana nima chapawarkankichichu.” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chashna willaptini tapuwankasapa: “Señor ¿aykapiti yarkaymanta kaptiki mana kararkaykisapa? ¿Aykapiti yakumanta kaptiki mana yakuta kurkaykisapa? ¿Aykapiti llaktaynikunapi chayaptiki wasinikunapi mana yaykuchirkaykisapa? ¿Aykapiti llachapayki mana tiyaptin llachapata mana kurkaykisapa? ¿Aykapiti unkudu kaptiki karselpi kaptiki mana yanaparkaykisapa?” ");
INSERT INTO qvsNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chashna tapuwaptinkuna ñuka sinchi kamachikuk kashpayni willashasapa: “Sufrikmasinikunata mana yanapashpaykichi ñukatapish mana yanapawarkankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chayrayku kankuna rinaykichi tiyan mana tukuyniyuk ninaman. Tata Diosta kasushpa kawsak runakuna rinankuna tiyan mana tukuyniyukta sielupi kawsak.” ");
INSERT INTO qvsNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chaymanta chaykunata ñukaykunata yachachiwashkankunawasha Jesuska willawarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Kankuna yachankichi Paskua fiestapa ishkay diyallana illananta. Chay fiesta ukun chikniwak runakuna ñuka sielumanta shamudu runata awtoridarkunaman pushawankasapa paykuna chakatawashpa wañuchiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesus chayta willawashkankuna diyalla Kayfaspa wasinpi kamachikuk saserdotekunawan judiyukunapa ansianunkuna tantanakurkansapa. Kayfaska saserdotekunapa ashwan sinchi kamachikuknin karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Paykuna yuyarkansapa Jesusta pantachichishpa apichiyta wañuchichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Willanakurkansapa: —Ama Paskua fiesta ukunka wañuchichiypachichu fiestaman shamudu runakuna ama turbakushpa piñayawananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania llaktapi lasaru unkuymanta alliyadu runa Simon kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesus Simonpa wasinpi mikuykaptin suk warmi yaykurkan. Chay warmika apamurkan yurak rumimanta ruradu botellapi aypa chaniyuk mishkiklla asnak wirata. Chay warmika Jesusta ladunchashpa umanpi chay mishkiklla asnak wirata icharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chayta kawashpa ñukaykuna piñakushpaynikuna willanakurkanisapa: —¿Imapatí chay warmi chay mishkiklla asnak wirataka usuchiykan? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ashwan alli kanman karkan aypa kullkipi rantikushpa chaypa chaninta mana nimayuk runakunata kunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus chayta uyarishpa willawarkansapa: —¿Imapatí piñakushpa kay warmita washanchankichi? Kay wirata umaynipi ichashpa allitami rurashka. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mana nimayuk runakunata tukuy maytapish rishpa tarinkichi. Ñukataka manami tukuy tiempunachu kawawankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kay warmika kay mishkiklla asnak wirawanka armachiwashkana wañuptini pampawanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Allita willaykichi: Kankuna tukuy maypi yachachikushpa ñuka salvakuk kanaynita kay warmi rurashkantapish parlachikunkichi. Chashnamanta tukuy pi paytaka allita yuyankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesuspa chunka ishkay disipulunkunamanta suk karkan Judas Iskariote. Payka Jesusta rantikunayashpa rirkan kamachikuk saserdotekunawan parlak. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Paykunata willarkansapa: —Ñuka willaptini imashnami Jesusta apinkichiman nishpa ¿mashnatati pagarawankichiman? Chashna Judas willaptinkuna paykuna willarkansapa kimsa chunka kullkita kunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chay kullkita chaskishkan oramantapacha Judaska sukaman Jesusta chaparkan apichichinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chay Paskua fiesta kallarinan diyapi tukuy judiyu runakuna amañak kanisapa mana levadurayuk panta mikuyta. Chay diya Jesusta ladunchashpaynikuna tapurkanisapa: —¿Maypiti munanki Paskua fiesta mikunata rinaynikunapa rurak? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chashna tapuptinikuna Jesuska willawarkansapa: —Rillaychi Jerusalen llaktaman. Suk runapa wasinpi chayashpa willaychi: “Maestruynikuna willachimushunki ñashi wañunan diya chayamuykanna. Chayrayku wasikimanshi disipulunkunawan shamunayan Paskua fiesta mikunata mikuk.” ");
INSERT INTO qvsNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chaypina rirkanisapa Paskua fiesta mikunata rurak. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tutayaptinna Jesuswan ñukaykuna suk mesapi mikuykarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chaypina Jesuska willawarkansapa: —Allita willaykichi. Chikniwak runakuna apiwankasapa wañuchiwanankunapa. Kankunamanta sukmi paykunapi apichichiwanka wañuchichiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chashna willawaptinkuna sukaman llakishpaynikuna sukmanta sukmanta payta tapurkanisapa: —Señor ¿ariya ñukachu kani? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chaypina Jesuska willawarkansapa: —Ñukawan tantalla kay kallanapi panninta ñuyuchik runami apichichiwanka. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tata Diospa killkadunpi riman runakuna wañuchiwanankunata. Chayrayku ñukaka sielumanta shamudu runa kashpayni wañusha. Wañunaynipa kaptinpish chay apichichiwak runataka sukaman llakichini. Ashwan alli kanman karkan ama nasinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chaypina chay apichichinayak Judaska Jesusta tapurkan: —Maestru ¿ariya ñukachu kani? Chashna tapuptin Jesuska aynirkan: —Ariya kanmi kanki. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chaymanta mikuykaptinikuna Jesus suk panta apishpa Tata Diosta agradesirkan. Chay panta pakishpa ñukaykunata kuwarkansapa. Chaskichiwashpankuna willawarkansapa: —Kay panta mikuychi. Kay panka kuerpuynimi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaymanta Jesuska suk vasu vinuta apishpa Tatan Diosta agradesirkan. Chay vasu vinuta kuwashpankuna willawarkansapa: —Tukuy kankuna kay vinuta upyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kay vinuka yawarninimi. Yawarniniwan mushuk paktuta rurasha. Wañuptini yawarnini ichakuptin Tata Dios aypa runakunata uchankunamanta perdonankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Allitami willaykichi. Uvamanta vinuta mana kutin upyashanachu Tatayni Diospa mandunpi kankunawan tantalla kashpa mushuk vinuta upyanaynikaman. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chaymanta salmo kantukunata kantashkaynikunawasha rirkanisapa Olivos urkuman. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chaypina Jesuska willawarkansapa: —Tata Dios rimananpi willawanchisapa: “Ovejakuna kuydak runata wañuchiptini tukuy ovejankuna chayta chayta kallpankasapa.” Tata Dios rimashkanshina kunan tuta tukuy kankuna ñukarayku manchakushpa sakiwankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Chaymanta ñuka wañushkaynimanta kashkan kawsamushpayni Galilea partiman kankunamanta ñawpakta risha. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chaypina Pedruka Jesusta willarkan: —Tukuy katishukmasinikuna turbakushpa sakishuptinkunapish ñukaka manami nima layapi sakishkaykichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chashna Pedru willaptin Jesuska willarkan: —Allitami willayki. Kay tuta manarapish gallo kantaptin kimsa kuti rimanki mana riksiwanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chaypina Pedruka willarkan: —Kanwan tantalla wañunayni kaptinpish manami nima layapi rimashachu kanta mana riksinaynita. Chashna Pedru willaptin tukuy ñukaykuna idenllata willarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaymanta Getsemani wertaman Jesuswan tantalla rirkanisapa. Chaypi chayaptinikuna Jesuska willawarkansapa: —Tatayni Dioswan parlak rinaynikaman kaypi tiyarishpa shuyawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chashna willawashpankuna suk chikan laduman Jesuska Pedruta Sebedeopa ishkay wambrankunata pusharkansapa. Chaypina Jesuska sukaman turbakushpa llakishpa paykunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Sukaman llakishpayni wañukshina mallinakuni. Kankuna mana nima puñushpa kayllapi kiparishpaykichi Tata Diosta roygaychi yanapawananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chashna willashpankuna Jesuska urasituman rirkan. Chaypi kumurayarkan allpapi urkun takakunankaman. Tatan Diosta willarkan: —A, Tatayni, munashpaykika salvaway ama sukaman sufrinaynipa. Chaymanta sufrishpaynipish munani kanpa munanaykillata rurayta. Manami munanichu ñukapa munanaynita rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chayta Tata Diosta willashkanwasha Jesuska chay kimsa disipulunkunapa ladunman kutirkan. Puñuykaptinkuna tarishpankuna Pedruta willarkan: —¿Manachu niman suk orata mana puñushpa atipankichi ñukawan pakta Tata Dioswan parlayta? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mana nima puñushpa Tata Diosta roygaychi supay ama uchallichishunaykichipa. Kankunaka sukaman munankichi Tata Dioswan parlayta. Chaykamanka kunanlla shaykunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chashna willashpankuna Jesuska kashkan rirkan Tatan Diosta roygak. Chaypina willarkan: —A, Tatayni, sufrinaynimanta mana amachawayta munashpaykika munanaykillata ruray. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tatan Diosta roygashkanwasha Jesuska kashkan kutishpa chay kimsa disipulunkunata tarirkansapa sukaman puñuykaptinkuna. Puñuylla vensirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Puñuykaptinkuna sakishpankuna Jesuska kimsaynin kuti rirkan Tatan Diosta idenllata willak. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaypina disipulunkunaman kutishpa willarkansapa: —¿Ariya puñushpallachu samaykankichi? Ñami orana suk runa ñukata uchasapa runakunapi rantikuwananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Atarimuychina! Akuychina. Ñami shamuykanna chay rantikuwak runaka. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus chayta willaykaptinkuna disipulun Judaska aypa runakunata pushamushpa chayarkan. Chay runakuna kaspikunata ishkantin ladupi filuyuk machetikunata apashpankuna rirkansapa Jesusta apik. Rirkansapa kamachikuk saserdotekunawan judiyukunapa ansianunkuna kachaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas manara chay runakunata Jesusman pushashpa allita yachachirkansapa: “Suk runata muchaptini yachankichi pay kananta. Paytami apishpa pushankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chaypina Jesusta ladunchashpana willarkan: —Buenas nochis, maestru. Chashna rimachishpa mucharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Muchaptinna Jesuska willarkan: —Amigu, rurak shamushkaykita rurayna. Chaypina chay runakuna Jesusta apirkansapa pushanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chayta kawashpa Jesuswan tantalla purik runa machetinta apirkan. Chaywan sinchi kamachikuk saserdotepa wiwachunpa suk ladu rinrinta tipipurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chashna tipipuptin Jesuska willarkan: —Chay machetikitaka macheti churanaykipi kashkan churay. Machetiwan makanakuk runakuna machetillawan wañuchinakunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manachu yachanki Tatayni Diosta roygaptinika kunanlla kanchis chunka waranka angelninkunata kachamunman amachawanankunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tata Dioska killkadunpi riman ñuka wañunaynita. Mana wañushpaynika mana Tata Diospa rimashkanta ruraymanchu karkan. Chayrayku Tata Diosta mana roygashachu wañuymanta amachawananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chayta willashpa Jesuska chay pushanayak runakunata willarkansapa: —¿Imapatí kaspikunata machetikunata apamushkankichi apiwanaykichipa? ¿Ariya suwa wañuchikuk runachu kani? Tukuy diya Tata Diospa wasinpi yachachikuptini ¿imapatí mana chaypi apiwashkankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ñawpa yachachikukkuna Tata Dios rimashkanta killkarkansapa kashna apiwanaykichipa. Chay killkadunpi rimashkanshina kunan kankuna apiwaykankichi wañuchichiwanaykichipa. Chashna oras ñukaykuna disipulunkuna manchakushpaynikuna Jesusta sapallanta sakishpaynikuna nitikurkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chay aypa runakuna Jesusta apishpa Kayfaspa wasinman pusharkansapa. Kayfaska ashwan sinchi kamachikuk saserdote karkan. Paypa wasinpi Moisespa killkadunta yachachikukkunawan judiyukunapa ansianunkuna tantanakudu shuyaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesusta pushaptinkuna Pedruka washallata katishpa chay wasi pampapi yaykurkan. Tata Diospa wasinta kuydak runakunapish chay pampapi tiyaridu karkansapa. Pedruka paykunapa ladunkunapi rirkan tiyarik kawanayashpa imatami Jesusta rurankasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chay wasi ukupi tukuy awtoridarkuna tantanakushpankuna chiknik runakunata maskarkansapa llullakushpa Jesusta chatanankunapa. Sukaman munarkansapa Jesusta wañuchichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Chaypina aypa runakuna llullakushpa Jesusta chatashpankunapish mana nima wañuchinankuna layatachu chatarkansapa. Aypa runakuna chatakushkankunawasha ishkay chatakukkuna chayashpankuna willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Kay Jesuska rimarkan: “Ñuka atipani Tata Diospa manllayba wasinta urmachiyta. Chayta urmachishkayniwasha kimsa diya ukun tukuchasha kashkan rurayta.” ");
INSERT INTO qvsNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chashna rimaptinkuna Kayfaska shayarishpa Jesusta tapurkan: —¿Chashna chatashuptinkuna manachu aynikunki? ¿Imatati chatashuykansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Chaypina Jesuska upallalla uyarirkan. Mana nimata ayniptin chay sinchi kamachikuk saserdote kashkan willarkan: —Sielupi kawsak Tata Diospa shutinpi willayki: Mana llullakushpa willawaysapa ¿kanchu kanki shuyanaynikuna salvakuk Tata Diospa wambran? ");
INSERT INTO qvsNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chaypina Jesuska willarkan: —Ariya, ñukami kani. Kunan willaykichi: Kankunaka ñuka sielumanta shamudu runata kawawankichi tukuy laya atipak Tatayni Diospa ladunpi tiyariptini. Kawawankichi puyukuna ukunpi kashkan shamuptini. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chashna Jesus willaptin chay sinchi kamachikuk Kayfaska sukaman piñakushpa churakunan sawa llachapanta llikirkan. Chayta rurarkan tukuy chay runakuna yachanankunapa sukaman piñakunanta. Chaymanta chay kamachikukmasinkunata willarkansapa: —Kay runaka chashna rimashpa Tata Diostami sukaman piñachiykan. Ama ashwan chatakuk runakunata maskaypachinachu. Tukuy kankuna Tata Diosta piñachinan laya rimashkanta uyarishkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Imatati yuyankichi? Chashna Kayfas willaptin paykunaka aynirkansapa: —Uchanpi kashpa wañunan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chaypina Jesusta uyanpi tukaychashpankuna kaspiwan waktarkansapa. Sukkuna uyanpi lapyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Asichishpankuna willarkansapa: —Salvakuk runa kashpaykika willawaysapa pimi lapyashuykan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chay wasi ukupi Jesusta asichiykaptinkuna Pedruka pampapi tiyaridu karkan. Chaypi kaptin chay wasipi sirvikuk warmi ladunchashpa willarkan: —Kanpish Galileamanta runa Jesuswan tantalla purishkanki. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Chashna willaptin Pedruka tukuy chay runakuna uyariptinkuna aynirkan: —Manami yachanichu pipami willawaykanki. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chaymanta Pedruka chay wasi punkuman rirkan. Chaypina suk sirvikuk warmi payta kawashpa sukkunata willarkansapa: —Kay runaka Nasaretmanta runa Jesuswan tantalla purishka. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chaypina Pedruka jurashpa kashkan willarkansapa: —Ñuka manami chay runata riksinichu. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chaymanta chaypi kak runakuna Pedruta ladunchashpankuna willarkansapa: —Deverasmi kanpish chay runapa purikmasin kanki. Rimanaykimanta riksiykisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chashna willaptinkuna Pedruka jurashpa maldisishpa willarkansapa: —Manami chay runata riksinichu. Pedru chayta rimaykaptinlla suk gallo kantarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chayta uyarishpana Pedruka yuyarkan Jesus willashkanta: “Manarapish gallo kantaptin kimsa kuti rimanki mana riksiwanaykita.” Chayta yuyashpana Pedruka washaman llukshishpa sukaman llakishpa mana upallayak layata wakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chaymanta pakariykaptin tukuy kamachikuk saserdotekunawan tukuy judiyukunapa ansianunkuna parlashpankuna yuyarkansapa Jesusta wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chaypina Jesusta watashpankuna pusharkansapa kamachikuk Pilatoman. Pilatoka karkan romano gobernador. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Chaypina Jesusta Pilatoman wañuchichinankunapa pushaptinkuna Judaska kawarkan. Jesusta apichichishkanrayku sukaman turbakushpa rirkan rantikushkan chanin kullkita kutichikuk. Chay kamachikuk saserdotekunapi judiyukunapa ansianunkunapi chayashpa willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Chay mana nima uchayuk runata wañuchinaykichipa rantikushpayni uchallikushkani. Chaypina paykunaka willarkansapa: —Chayka kanpa uchaykimi. Ñukaykunapa mana nimachu. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chashna willaptinkuna Judaska chay kullkita Tata Diospa wasinpi wishchukurkan. Chaymanta llukshishpa waskawan sipinakushpa wañuchinakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chaypina chay kamachikuk saserdotekuna chay wishchudu kullkita apishpankuna willanakurkansapa: —Kay kullkika wañuchinanchikuna runapa chaninmi. Chayrayku mana allichu churananchikunapa ofrenda churana kajapi. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ashwan alli kanman kay kullkiwan suk terrenuta rantinanchikunapa chikan llaktamanta runakuna wañuptinkuna chaypi pampanankunapa. Chashna parlanakushpankuna puyñukuna rurak runapa terrenunta rantirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chay kullkiwan rantishkankunarayku kunankaman chay pampapa shutin kiparishka Yawar Pampa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chayta rurarkansapa chay ñawpa yachachikuk Jeremiyas rimashkanshina: “Israel runakuna kimsa chunka kullkillata chanicharkansapa chay alli rurak runapa pagarakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chay kullkiwan puyñukuna rurak runapa terrenunta rantirkansapa Tata Dios rimashkanshina.” ");
INSERT INTO qvsNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chaymanta Jesusta pusharkansapa gobernador Pilatopi chatakuk. Chaypi Pilatoka Jesusta tapurkan: —¿Kanchu kanki judiyu runakunapa ashwan sinchi kamachikukninkuna? Chashna tapuptin Jesuska aynirkan: —Ariya ñukami kani. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chaypina kamachikuk saserdotekunawan judiyukunapa ansianunkuna Jesusta sukaman chataykaptinkuna Jesuska mana aynikushpa upallalla uyarirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chayrayku Pilato Jesusta tapurkan: —¿Manachu uyarinki tukuy kay runakuna chatashuptinkuna? ");
INSERT INTO qvsNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Chashna tapuptin Jesuska mana nimata aynirkanchu. Chayrayku Pilatoka sukaman almirarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tukuy wata Paskua fiesta ukun Pilato amañarkan karselmanta suk runata kacharichiyta. Runakunata willaksapa akllanankunapa maykan runatami kacharinka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay tiempu karselpi karkan suk runa Barrabas. Tukuy pi yacharkansapa Barrabas sukaman mana alli rurak runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaypina Pilatoka chay aypa tantanakudu runakunata tapurkansapa: —¿Maykan runatatí munankichi kacharinaynipa? ¿Barrabastachu kacharisha? ¿Kay Tata Diosmanta shamudu rimanankunatachu kacharisha? ");
INSERT INTO qvsNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato chayta tapurkansapa allita yachashpa Jesusta chiknishpankuna chatakushkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chaymanta kamachikunan tiyarinanpi Pilato tiyaridu kaptin warmin willachirkan: “Ama nimanachiychu chay mana nima uchayuk runata. Kayna tutapi payrayku manchanapa layata muskukushkani.” ");
INSERT INTO qvsNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Chaypina chay kamachikuk saserdotekunaka chay aypa tantanakudu runakunata sinchita willarkansapa: —Pilatota willaychi Barrabasta kacharinanpa Jesusta wañuchichinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chaypina Pilato kashkan tapurkansapa: —¿Pitati munankichi kacharinaynipa? Chaypina chay tantanakudu runakunaka willarkansapa: —¡Barrabasta kachariy! ");
INSERT INTO qvsNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatoka tapurkansapa: —¿Imatatí rurasha kay rimanankuna Tata Diosmanta shamudu Jesusta? Chashna tapukuptinkuna tukuy runakuna aynirkansapa: —¡Kruspi chakatachiy! ");
INSERT INTO qvsNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatoka willarkansapa: —¿Ima mana allitatí rurashka? Paykunaka ashwan sukaman sinchita rimashpankuna kashkan willarkansapa: —¡Kruspi chakatachiy! ");
INSERT INTO qvsNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chay runakuna sukaman piñakushpa kapariptinkuna Pilatoka mana nima layapi upallayachiyta atipashpana yakuta apachimurkan. Chaywan makinkunata mayllarkan tukuy runakuna kawanankunapa. Chaypina willarkansapa: —Ñukaka makinita mayllani yachanaykichipa kay runa wañuptin mana nima uchayuk kanaynita. Wañuptinka kankunami uchayuk kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chashna willaptinkuna tukuy chay runakuna willarkansapa: —Chay runa wañuptinka ñukaykuna tukuy wambraynikunawan uchayuk kanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaypina Pilatoka Barrabasta kacharishkanwasha Jesusta suk karawaskawan asutichirkan. Chaymanta kukurkan suk kruspi chakatashpa wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chaypina Pilatopa soldadunkuna Jesusta pusharkansapa paypa wasinman. Chaypi chayashpankuna aypa soldadumasinkunata tantanachirkansapa Jesusta asichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesuspa sawa llachapanta llatanachishpa kamachikukpa puka llachapanta churachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Umanpi kashayuk waskamanta awadu koronata churapurkansapa. Chaymanta alli ladu makinpi suk varata churapurkansapa kamachikunan vara nishpa. Sukaman asichishpankuna ñawpakninpi kunkurikurkansapa. Kuyak tukushpankuna willarkansapa: —¡Kanmi judiyu runakunapa ashwan sinchi kamachikuknin kanki! ");
INSERT INTO qvsNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chaypina tukaycharkansapa. Chay varallawan umanpi waktarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sukaman asichishkankunawasha kashkan kikinpa llachapanta churachirkansapa. Chaymanta pusharkansapa suk kruspi chakatak. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesusta chakatak pushashpankuna suk runa Simonta tinkurkansapa. Chay Simon Sirene llaktamanta karkan. Soldadukunaka payta apishpankuna Jesuspa krusninta aparichirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rishpankuna suk taksha urku Golgotapi chayarkansapa. Chay Golgota shuti judiyukuna rimanaynikunapi riman Uma Poto. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypina soldadukuna Jesusta upyachinayarkansapa ayakwan chakrudu vinuta. Jesuska chayta mallishpa mana upyanayarkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chaypina soldadukuna Jesusta kruspi chakatarkansapa. Chaymanta Jesuspa llachapanta pukllashpa patumanakurkansapa yachanankunapa pimi apanka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chay washa chayllapi tiyarirkansapa Jesusta allita kuydanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesuspa uman kuskapi churarkansapa suk killkaduta tukuy runakuna yachanankunapa imapami wañuchishkasapa nishpa. Chay killkadupi rimarkan: “Kay Jesuska judiyu runakunapa ashwan sinchi kamachikukninmi.” ");
INSERT INTO qvsNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesuspa ishkantin ladunpi ishkay suwa runakunatapish chakatarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aypa runakuna rirkansapa Jesusta kawak. Paykunaka chikallayachishpankuna willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Kanmi rimashkanki Tata Diospa manllayba wasinta urmachishpayki kimsa diya ukunlla kashkan ruranaykita. Kunanka kikikilla salvanakuy. Tata Diospa wambran kashpaykika chay krusmanta urayamuy. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chashnalla kamachikuk saserdotekunawan Moisespa killkadunta yachachikuk runakunawan judiyukunapa ansianunkuna Jesusta asichirkansapa. Paykuna Jesusta pinkachishpankuna willanakurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Payka aypa runakunata unkuyninkunamanta supaykunamanta salvashkasapa. Kunanka kikin mana atipanchu wañuymanta salvanakuyta. Israel llaktanchikunapa sinchi kamachikuknin kashpaka kay krusmanta urayamuchun. Chaypira kreyishunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Payka rimarkan Tata Diospa wambran kananta. Rimarkan Tata Dios tukuy layapi yanapananta. Tata Dios deverasta kuyashpanka kunanlla chay krusmanta urayachimuchun. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chashna asichiptinkuna chay ishkay ladunpi chakatadu suwakunapish Jesusta asichirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesus kruspi chakatadu kaptin chawpi diyamantapacha las tres de la tardikaman sukaman tuta likidu tukurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chay oraslla Jesuska sinchita rimarkan: “Eli, Eli ¿lama sabaktani?” Chay rimakushkan judiyu rimanaynikunapi riman: “Tata Diosnini, Tata Diosnini ¿imapati sakiwashkanki?” ");
INSERT INTO qvsNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chay rimashkanta uyarishpana chay runakunaka willanakurkansapa: —Kay runaka ñawpa yachachikuk Eliyastami kayaykan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chaypina suk runa kallpashpa pintupa puntanta chiktarkan utkuta churananpa. Chayta ayak likidu vinupi sumichishpa Jesuspa shiminpi churarkan shukunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Chayta kawashpa sukkuna willarkansapa: —¡Ama upyachiychu! Akuychi kawaypachi Eliyas shamunkachu salvak manachu nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chaypina Jesuska kashkan sinchita kaparikurkan. Chashna kaparikushpa wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesus wañushkan oraslla Tata Diospa wasinpi warkudu arkana llachapa llikikurkan. Anakninmanta urayninkaman llikikurkan chay alli arkadu kuartu rikurinanpa. Chaypina allpa sukaman kuyurkan. Atun urkukunapish chiktakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Chaymanta panteyunpi sepulturakuna kicharinakurkansapa. Tata Diosta kreyik wañudu runakuna aypa kawsamurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chaymanta Jesus kawsamushkanwasha chay kawsamuk runakuna Jerusalen llaktapi yaykurkansapa. Chaypi yaykuptinkuna aypa runakuna kawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Allpa sukaman kuyuptin Jesusta kuydak soldadukunawan kapitanninkuna tukuy chay almirana layakunata kawashpankuna sukaman manchakurkansapa. Chaypina paykunaka rimarkansapa: —Deverasmi kay runaka Tata Diospa wambran kashka. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jesus chakatadu kaptin Galileamanta katishpa yanapak warmikuna chikanmanta kawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chay kawak warmikuna aypa karkansapa. Paykunamanta suk karkan Mariya Magdalena. Suk karkan Jakobopa Josepa maman. Suk karkan Sebedeopa warmin. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chaymanta amusayaykaptinna Jesus wañushkanpi Jose chayamurkan. Chay Joseka Arimatea llaktamanta aypa kullkiyuk runa karkan. Jesusta kreyik karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joseka rirkan Pilatota mañak Jesuspa kuerpunta pampachinanpa. Chashna mañaptin Pilatoka soldadunkunata willarkansapa kunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chaypina Joseka Jesuspa kuerpunta suk allima mushuk sabanaswan wankurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Allita wankushpa pusharkansapa atun rumipi chayrak aspidu machay ukunpi churak. Chay rumi machayta Joseka kikinpa terrenunpi rurachirkan. Jesuspa kuerpunta chay ukupi churashkankunawasha manllayba rumiwan allita wichkarkan. Chaymanta sakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chay machay ladunpi Mariya Magdalena suknin Mariyawan tiyarishpa kawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jesusta wañuchishkankuna kayantin judiyu runakunapa samanankuna diya karkan. Chay diyaka kamachikuk saserdotekuna fariseo runakunawan tantalla rirkansapa Pilatota kawak. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chaypina willarkansapa: —Señor, ñukaykuna yuyanisapa chay llullachikuk runa rimashkanta. Payka kawsashpara rimarkan wañushkanmanta kimsa diya ukun kashkan kawsamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayrayku roygaykisapa kimsa diyata soldadukunawan Jesuspa sepulturanta kuydachinaykipa ama tutapi disipulunkuna kuerpunta suwanankunapa. Chashna suwashpankuna rimanmansapa Jesuska kawsamushkanta. Chashna llullakushpa kashkan tukuy runakunata ashwanta llullachinmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chaypina Pilatoka willarkansapa: —Aypa soldadukunata pushaychi. Chay machayta atipanaykichi layata kuydaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chaypina chay kamachikuk runakuna rirkansapa machaypa punkunta selluchak ama ni pi chay wichkanan rumita suchuchinankunapa. Chaymanta chay soldadukunata sakirkansapa allita kuydanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chaymanta samana diya kayantin pakariykaptin Mariya Magdalena suknin Mariyawan rirkansapa chay machayta kawak. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chay warmikuna chayaptinkuna allpa sukaman kuyurkan. Tata Diospa angelnin sielumanta urayamushpa chay machaypa wichkanan rumita suchuchirkan. Ashuchishpana sawanpi tiyarirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chay angelka sukaman llipyak likidu karkan. Tukuy llachapan nieveshina yurak likidu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chay angelta kawashpankuna chay kuydakuk soldadukuna manchakuywan chukchukushpankuna wañudushina urmarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chaypina chay angelka chay ishkantin warmikunata willarkansapa: —Ama manchakuychichu. Ñuka yachani chakatadu kashka Jesusta maskaykanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Payka mananami kaypinachu. Rimashkanshina ñami kawsamushkana. Mash shamuychi kawak maypicha churashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chaymanta utkakushpaykichi rillaychi kawsamushkanta disipulunkunata willak. Galilea partiman manara riptikichira payka rinka. Kankunapish rillaychi chaypi kawanaykichipa. Chayllatami willashkaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chaypina chay ishkay warmikunaka manchakushpapish sukaman kushikurkansapa. Kushikushpa kallparkansapa Jesuspa disipulunkunata willak. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chashna riykaptinkunana Jesuska chay warmikunapi rikurishpa rimachirkansapa. Chaypina paykunaka Jesusta ladunchashpa kumurayashpankuna chakinta abrasashpa sukaman kuyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chaypina Jesuska willarkansapa: —¡Ama manchakuychichu! Kunanlla rillaychi wawkinikunata willak Galilea partiman rinankunapa. Chaypimi kawawankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chaymanta chay warmikuna Jerusalen llaktaman riykaptinkuna chay kuydak soldadukunapish chaypi chayarkansapa. Paykunaka kamachikuk saserdotekunata willarkansapa tukuy kawashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaypina chay kamachikukkuna rirkansapa judiyukunapa ansianunkunawan parlanankunapa imatami rurankasapa nishpa. Parlashkankunawasha chay soldadukunata aypa kullkita pagararkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pagarashpa willarkansapa: —Kankuna tukuy pita willanaykichi tiyan tutapi puñuykaptikichi Jesuspa disipulunkuna kuerpunta suwashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chashna rimaptikichi ichará Pilato rimashkaykichita yachanka. Chaypina kastigashunayaptikichi ñukaykuna willashasapa ama nimata rurashunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Llullakuyta almitishpankuna chay soldadukunaka aypa kullkita chaskirkansapa. Chaymanta chay parlashkankunata famakurkansapa. Chayrayku kunankaman judiyu runakuna rimansapa disipulunkuna Jesuspa kuerpunta suwashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chaymanta ñukaykuna chunka suk disipulunkuna Galilea partiman Jesus rimashkan urkuman rirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chaypi chayashpaynikuna Jesusta kawarkanisapa. Payta kawashpa kuyarkanisapa. Sukkuna yuyayninikunapi rimarkanisapa: “Ichará mana paychu” nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Chaypina Jesuska ladunchawashpankuna willawarkansapa: —Tata Dioska churawashka sielupi allpapi kamachikunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chayrayku rillaychi tukuy allpapi kawsak runakunata yachachik paykunapish disipuluynikuna kanankunapa. Chaymanta ñukata kreyiwak runakunata bawtisaychi Tata Diospa shutinpi ñukapa shutinipi Tata Diospa Espiritunpa shutinpi. ");
INSERT INTO qvsNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chay kreyiwak runakunata tukuy yachachishkaynikunata yachachiychi paykunapish allita kasuwanankunapa. Ñuka tukuy diya kankunawan kasha kay allpa kullunan diyakaman.");
INSERT INTO qvsNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesukristu Tata Diospa wambran kay allpaman shamurkan kastigumanta salvawananchikunapa. Kunanka chay allima rimanata yachachiykichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ñawpa alli yachachikuk Isaiyas Tata Dios Juanpa willash-kanta killkarkan: “Ñuka suk alli yachachikukta kachasha tukuy runakunata willanankunapa kachamushkayni runata allita chaskinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chunlla chakidu pampapi suk runa sinchita yachachikuykan: ‘Señorninchipa suk ñanta allichaychi. Suk ñanta kuskachaychi chayta purinanpa.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chay Isaiyas rimashkanshina suk diya Juanka chunlla pampapi kallarirkan runakunata bawtisayta. Willarkansapa tukuy uchankunata wanashpankuna Tata Diosta kasushpa kawsanankunapa. Willarkansapa bawtisakunankunapa tukuy mana alli rurashkankunamanta Tata Dios perdonanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chashna Juan yachachikuptin Judea partimanta Jerusalen llaktamanta aypa runakuna rirkansapa uyarik. Chaypina Juanta willarkansapa uchasapa kanankunata. Chashna willaptinkuna Jordan yakupi Juanka bawtisarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanpa llachapan kamellu millwanmanta awadu karkan. Chaymanta sinturan watana karapamanta karkan. Atun marukunata mikurkan. Sachamanta amukunapa mishkinta upyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juanka yachachikushpa willarkansapa: —Ñukamanta ashwan alli yachachikuk runa washata shamun. Payka ñukamanta tukuy laya ashwan alli yachakmi. Chayrayku mana payshina kashpayni mana animukunichu ni ushutanta kumurayashpa paskapuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ñukaka yakullawanmi bawtisashkaykichi. Paymi Tata Diospa Espiritunwan bawtisashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay tiempu Jesuska Galilea partipi Nasaret llaktamanta llukshirkan Jordan yakuman rinanpa. Chaypi Juanka Jesusta bawtisarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus yakumanta llukshiykashpa kawarkan sieluta kicharinakuptin. Chaypina kawarkan Tata Diospa Espiritun iden suk urpaytashina payman urayamuptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chashna orana sielumanta Tatan Dios Jesusta willarkan: —Kanmi kuyanayni wambrayni kanki. Kanmi sukaman kushichiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bawtisakushkanwasha suk chunlla chakidu allpaman Tata Diospa Espiritun Jesusta pusharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chay chunlla chakidu allpapi manchanapa laya animalkuna tiyarkan. Chaypina chusku chunka diyata Jesus chaypi kaptin supay ladunchashpa llullachinayarkan. Mana nima layapi supayta kasuptin angelkuna Jesusta yanaparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chaymanta kamachikuk Herodes Juanta karselpi churarkan. Chay washa Jesuska Galilea partiman rirkan Tata Diospa alli rimananta yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Willarkansapa: —Chay ñawpa yachachikuk runakuna rimashkanshina ñami shamushkanina. Tata Dios sukaman munan kunanmantapacha mandunpina kawsanaykichipa. Chayrayku tukuy mana alli ruranaykichimanta wanaychi. Tata Dios tukuy willashushkaykichita tukuy shunku kreyiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chaymanta Galilea kocha mañanpi puriykashpa Jesuska Pedruta wawkin Andresta kawarkansapa. Paykunaka atun redninkunawan challwakuykarkansapa challwa apik runakuna kashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chaypina Jesuska paykunata willarkansapa: —Kankuna allita yachankichi challwakunata apiyta. Kunanmantapacha ñukata katiwaychi. Katiwaptikichi ñuka allita yachachishkaykichi runakunata yachachinaykichipa paykunapish ñukata kreyiwashpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chashna willaptinkuna chay ratulla chay challwakuk runakuna redninkunata sakishpankuna Jesusta katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chaymanta chay kocha mañanta puriykashpankuna Jesuska Santiagota wawkin Juanwan tantallata kawarkansapa. Chay ishkay runakuna Sebedeopa wambrankuna karkansapa. Suk kanowapi chay ishkay runakuna redninkunata allichaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Chaypina Jesuska chay ishkay runakunataka kayarkansapa paywan tantalla purinankunapa. Paykunapish tatanta trabajadorninkunata kanowapi sakishpankuna Jesuswan rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaymanta Kapernaum llaktapi Jesus disipulunkunawan chayarkansapa. Chayashpankuna samana diya kaptin tantanakunankuna wasipi Jesuska yaykurkan. Chaypi yaykushpa runakunata yachachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chay runakuna sukaman almirarkansapa allita kuskanpi sinchi kamachikukshina yachachikuptin. Mana yachachikurkanchu Moisespa killkadunta yachachikuk runakunashina. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay tantanakunankuna wasipi tiyarkan suk supayadu runa. Jesus yachachikuptin uyarishpana supay sinchita rimakushpa Jesusta willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Nasaret llaktamanta Jesus! ¿Imapatí ñukaykunaman shamushkanki? ¡Sakiwaysapa! ¿Mana tukuyniyuk ninamanchu kachawanayaykankisapa? Ñuka yachani Tata Diosmanta shamudu runa kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chashna chay supay willaptin Jesuska piñayashpa willarkan: —¡Upallay! ¡Kunanlla kay runamanta llukshiy! ");
INSERT INTO qvsNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chashna Jesus willaptinna chay supayka chay supayadu runata sukaman chukchuchishpa manllaybata kaparikushpa paymanta llukshirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chayta kawashpa chay runakuna sukaman manchakushpankuna willanakurkansapa: —¿Ima laya mushuk yachanatatí yachachiwaykanchisapa? Kay Jesuska sinchita kamachikushpa atipan supaykunatapish llukshichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaypina chay runakuna tukuy llaktakunapi famakurkansapa Jesus sinchita willashpa supayta runamanta llukshichishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chaymanta tantanakunankuna wasimanta llukshishpa Jesuska Santiagowan Juanwan rirkansapa yaykuk Simonpa Andrespa wasinpi. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chaypi Simonpa suedran kalentorawan unkudu karkan. Chay warmipa familyankuna Jesusta willarkansapa unkudu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chashna willaptinkuna Jesuska unkuduta ladunchashpa makinmanta apishpa atarichirkan. Chay ratulla kalentoranka chiriyapurkan. Chaypina chay warmi atarishpa mikunankunata rurashpa kararkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chaymanta amusayaykaptin inti yaykuptin Jesusman aypa runakuna unkudu familyankunata pusharkansapa. Paykuna rikchak laya unkuyuk karkansapa. Sukkuna supayadu karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chay wasi punkupi chay llaktapi kawsak runakuna tukuy tantanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chaypina Jesuska aypa unkudukunata alliyachirkansapa. Supaykunata aypa runakunamanta llukshichipurkansapa. Chay supaykuna yacharkansapa Jesus Tata Diosmanta shamudu runa kananta. Chayrayku Jesus mana munarkanchu nimata willanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chaymanta pakariptinna chay llaktamanta Jesuska llukshirkan suk chunlla likidu pampapi Tata Dioswan parlak. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Chayman riptin Simonka purikmasinkunawan rirkansapa Jesusta maskak. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tarishpa willarkansapa: —Tukuy runakuna maskashuykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chaypina Jesuska willarkansapa: —Akuychi chikan llaktakunaman chaypipish kay alli kushichina rimanata yachachikunaynipa. Ñuka shamushkani aypa runakunata yachachiksapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chashna Jesus willashpankuna Galilea partipi tukuy llaktakunapi yachachikuypi purirkan. Tukuy llaktapi tantanakunankuna wasikunapi yachachikurkan. Chaymanta aypa runakunamanta supaykunata llukshichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Suk diya lasaruyak runa Jesusta laduncharkan. Ñawpakninpi kumurayashpa willarkan: —Maestru, munashpaykika kay unkuyninimanta alliyachiway. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chashna willaptin Jesuska chay runata llakichirkan. Llankashpa willarkan: —Ariya, munani alliyachiynikita. Ñami sanuna kanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chayta willashkan oralla chay runapa tukuy kirinkuna alliyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chaypina Jesus despidishpa sinchita allita willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Amara ni pita parlachinkirachu ñuka alliyachishkaynita. Rillay saserdoteman pay allita kawashunanpa yachananpa alliyadunachu manachu kanki nishpa. Alliyaduta kawashuptinna Moises killkashkanpi kamachikushkanta allita kasushpa suk ofrendata apay. Chayta apaptiki tukuy runakuna yachankasapa unkuynikimanta alliyashkaykitana. ");
INSERT INTO qvsNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesus ama ni pita parlachinanpa willaptinpish chay runaka tukuy pita parlachirkan Jesus alliyachishkanta. Chayrayku Jesuska mana atiparkanchu ni maykan llaktapi yaykuyta. Llakta washankunallapi mana ni pi kawsananpi kiparik. Tukuy maymanta aypa runakuna riksapa Jesusta kawak. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chaymanta suk diyakuna washan Kapernaum llaktaman Jesuska kashkan rirkan. Suk wasipi kaptin aypa runakuna yachashpankuna rirkansapa kawak. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sukaman aypa runakuna niti niti tantanakuptinkuna mana ni pi punkuta yaykuyta atiparkannachu. Chaypina Jesus chay runakunata yachachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chashna yachachikuykaptin chusku runakuna suk mana kuyuy atipak runata kamillapi pushamurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chay wasipi aypa runakuna tiyaptin paykunaka mana yaykuyta atiparkansapachu. Chayrayku wasi sawaman chay unkuduta kamillanpi pusharkansapa. Chaypina tejakunata Jesuspa kuskanpi surkushpankuna chay uchkuta chay unkuduta kamillanpi urayachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chay yanapak runakuna allita tukuy shunku kreyirkansapa Jesus alliyachinanta. Jesus kreyinankunata yachashpa chay unkuduta willarkan: —Wambrayni, uchaykikunamanta perdonayki. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chaypina Moisespa killkadunkunata yachachikuk runakuna chaypi tiyaridu kashpankuna shunkunkunallapi rimarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Imapatí kay runaka chayta riman? Kay unkuduta willashpa uchankunata perdonananpa Tata Diosta piñachiykan iden Tata Diosshina kanayashpa. Tata Diosllami atipan runakunapa uchankunata perdonayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuska chay ratulla yacharkan shunkunkunapi yuyashpa washanchaykanankunata. Chayrayku tapurkansapa: —¿Imapatí kankuna washanchawaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ñuka kay unkuduta ishkay layata atipayman willayta. Munashpayni willayman: “Uchaykikunamanta perdonayki.” Chaymanta willayman: “Atarishpa kamillaykita apashpa rillay.” ");
INSERT INTO qvsNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kunanlla kay unkuduta alliyachisha yachanaykichipa sielumanta shamudu runa kanaynita. Alliyachiptini yachankichi atipanaynita tukuy runakunapa uchankunata perdonayta. Chashna rimashpa Jesuska chay mana kuyuy atipak runata willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Kanta willayki, atarimuy. Kamillaykita apashpa wasikiman rillay. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chashna Jesus willaptin chay unkudu runaka atarimurkan. Chay aypa runakuna kawaykaptinkuna kamillanta apishpa wasinman rirkan. Chayta kawashpa tukuy runakuna sukaman almirashpankuna Tata Diosta alabarkansapa. Willarkansapa: —¡Manami niman suk kuti kay laya almirana ruranata kawashkanchisapachu! ");
INSERT INTO qvsNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaymanta manllayba kocha mañanman Jesuska kashkan rirkan. Chaypi aypa runakuna ladunchaptinkuna yachachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaymanta puriykashpa Alfeopa wambran Levita kawarkan. Levika romano awtoridarkunapa kullki kobrakuk runa kashpa tiyaridu karkan maypicha kullkita kobrakuksapa. Jesuska payta kawashpa willarkan: —Ñukata katiway. Chashna willaptin Levika atarishpa Jesusta katirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Suknin diya Levipa wasinpi Jesuska mikuykarkan. Aypa runakuna payta katishpankuna chaypi karkansapa. Levipa kobrakukmasinkunawan mana alli rurak runakuna chay mesallapi Jesuswan disipulunkunawan tantalla mikuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chaypina fariseo runakuna kawarkansapa Jesusta mana alli rurak runakunawan kullki kobrakukkunawan tantalla mikuykaptin. Chayta kawashpankuna disipulunkunata willarkansapa: —¿Imapatí yachachishuknikichi Jesuska kullki chaskikukkunawan uchasapa runakunawan tantalla mikuykan? ");
INSERT INTO qvsNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesuska chayta uyarishpa willarkansapa: —Mash uyariwaychi. Unkudu runa ampikninta sukaman maskan alliyachinanpa. Sanu runa mana nima ampikninta maskanchu sanu likidu kashpa. Ñukaka shamushkanimi uchasapa runakunata kayak uchankunata sakishpa katiwanankunapa. Manami shamushkanichu alli yuyanakuk runakunata kayak. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Chaymanta Juan Bawtistapa disipulunkuna fariseokunapa disipulunkunawan amañaksapa churadu diyakuna mana nimata mikuyta nimata upyayta. Suk diya mana mikuptinkuna kawashpankuna suk runakuna Jesusta tapurkansapa: —¿Imapatí disipuluykikuna mana mikunata sasinsapa? Juanpa disipulunkunawan fariseokunapa disipulunkuna amañansapa churadu diyakuna mana nimata mikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chashna tapuptinkuna Jesuska aynirkansapa: —Funsiapi invitadu runakuna noviowan tantalla kashpankuna mana llakinsapachu. Novio paykunawan kaptin rikchak layata mikunsapa upyansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Funsia washanna novio sakiptinkunana chaypira llakishpa churadu diyakuna mana mikunkasapanachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Chaymanta Jesus ashwanta entiendichinayashpa willarkansapa: —Manami ni pi mawka llachapata tipi mushuk telawan remiendanmanchu. Chay llachapata takshaptin mushuk tela kintikushpa mawka llachapata ashwanta llikichin. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chaymanta mana ni pi mawka kapachupi llullu vinuta churanmanchu. Chaypi churaptin llullu vinu timbushpa mawka kapachuta pachyachin. Kapachu llikikuptin vinupish ichakun. Llikikudu kapachupish mana nimapa allinachu. Chayrayku llullu vinuta mushuk kapachupi churansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chaymanta suk samana diya Jesuska disipulunkunawan suk chakra chawpinta pasarkansapa. Chayta rishpankuna disipulunkunaka tipi triguta pallarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chaypina fariseo runakuna Jesusta willarkansapa: —Mash kaway. ¿Imapatí samana diya kaykaptin disipuluykikuna triguta tipiykansapa? Moisespa killkadunpi willawanchisapa samana diya mana nimata pallananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chashna willaptinkuna Jesuska aynirkansapa: —¿Manachu kankuna leyishkankichi ñawpa awilunchikuna David rurashkanta? Payka purikmasinkunawan purishpankuna sukaman yarkarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar kamachikuk saserdote kaptin payka yaykurkan maypicha tantanakuksapa Tata Diosta kuyanankunapa. Chaypi Davidka Tata Diosllapa churadu pankunata mikurkan. Chaymanta purikmasinkunatapish chay pankunata kararkansapa. Chay laya pankuna saserdotekunallapa karkan. Chay laya panta David mikushpapish mana uchallikurkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Chaymanta Jesuska willarkansapa: —Mash uyariwaychi. Tata Dioska samana diyata rurarkan runakuna samanankunapa. Mana runakunatachu rurarkan samana diya tiyashkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ñuka sielumanta shamudu runa willaykichi samana diya imakunami alli ruranaykichipa imakunami mana allichu ruranaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Chaymanta samana diya kaptin Jesuska kashkan yaykurkan tantanakunankuna wasipi. Chaypi tiyarkan suk kaspirayadu makiyuk runa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chaypina Jesusta chiknik runakuna chapaykarkansapa chatanankunapa. Kawanayarkansapa samana diya kaptin chay runata alliyachinkachu manachu nishpa. Paykunaka awtoridarkunapi Jesusta sukaman chatanayarkansapa samana diya unkuduta alliyachiptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chaypina Jesuska chay kaspirayadu makiyuk runata willarkan: —Rillay chay runakunapa chawpinkunapi shayarik. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chay runa chawpinkunapi shayariptinna Jesuska chay chatanayak runakunata willarkansapa: —Moisespa killkadunpi ¿imatatí willawanchisapa? ¿Willawanchisapachu samana diya allita mana allita rurananchikunapa? ¿Samana diya suk runata alliyachinchimanchu? ¿Suk runata kawapayanchimanchu wañunanpa? ");
INSERT INTO qvsNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chashna tapuptinkuna chay runakuna mana nimata aynirkansapachu. Mana nimata ayniptinkuna Jesuska sukaman piñakushpa tukuyta chaparkansapa. Sukaman llakirkan sinchi shunku kaptinkuna. Chaypina chay kaspirayadu makiyuk runata willarkan: —¡Makikita chutachiy! Chay runaka Jesusta kasushpa kaspirayadu makinta chutachiptin alliyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jesus chay runata alliyachishkanrayku fariseo runakuna piñakushpa chay tantanakunankuna wasimanta llukshirkansapa. Paykunaka rirkansapa Herodespa partidun runakunawan parlak Jesusta wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chaymanta Jesuska disipulunkunawan rirkan kocha mañanman. Galilea partimanta aypa runakuna Jesusta katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Chaypina Jesus almirana milagrukunata rurashkankunata yachashpankuna aypa runakuna rirkansapa kawak. Judea partimanta, Jerusalen llaktamanta, Idumea partimanta, Jordan yaku chimbamanta, Tiro llaktamanta, Sidon llaktamanta rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aypa runakuna katiptinkuna Jesuska disipulunkunata willarkansapa suk kanowata prontapunankunapa ama payta nitinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aypa runakunata alliyachishkanrayku rikchak laya unkuyuk runakuna alliyanayashpa Jesusta nitirkansapa llankanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Supayadu runakuna Jesusta kawashpankuna ñawpakninpi kunkurikushpankuna sinchita rimashpa willaksapa: —Kanmi kanki Tata Diospa chaylla wambran. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Chashna willaptinkuna Jesuska sinchita willarkansapa ama ni pita willanankunapa Tata Diospa wambran kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaymanta Jesus suk urkuman rishpa suk runakunata willarkansapa paywan tantalla rinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Paykunamanta chunka ishkayta akllarkan paywan tantalla purinankunapa. Paykunata akllarkansapa rinankunapa yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chaypina willarkansapa Tata Dios yanapaptinkuna runakunamanta supaykunata llukshichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay chunka ishkay aklladukunapa shutinkuna kaykunami: Sukka karkan Simon. Paytaka Jesus shutiyachirkan Pedru. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Chaymanta Sebedeopa ishkay wambrankuna Jakobowan Juan karkansapa. Paykunata Jesus shutiyachirkansapa Boanerges. Chay shutika riman “Troynoshina Sinchi Rimakuk.” ");
INSERT INTO qvsNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Suk aklladukuna karkansapa Andres, Felipi, Bartolome, Mateo, Tomas, Alfeopa wambran Santiago, Tadeo, Simon. Chay Simonka romano gobiernuta mana kasunayak runa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Chaymanta karkan Judas Iskariote. Payka suk tiempu washa Jesusta rantikurkan wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaymanta Jesuska suk wasipi yaykuptin kashkan aypa runakuna katirkansapa. Sukaman tantanakuptinkuna mana nima Jesus nima disipulunkuna atiparkansapachu mikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chayta yachashpankuna Jesuspa ayllunkuna rirkansapa pushamuk. Pushanayarkansapa runakuna rimaptinkuna Jesus dementuyashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalen llaktamanta Moisespa killkadunta yachachikuk runakunapish Jesusman riykarkansapa. Paykunaka Jesusta yuyashpa rimarkansapa: —Supaykunapa kamachikuknin Belsebu kay runata yanapaptin atipan runakunamanta supaykunata llukshichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chashna yuyak runakunata kayashpankuna Jesuska suk ejempluta rimashpa yachachirkansapa: —Mash uyariwaychi. Satanas mana atipanchu kikinlla llukshichinakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Suk llaktapi kawsak runakuna chikninakushpa makanakushpankuna kikinkunapura kulluchinakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chaymanta suk wasillapi kawsak runakuna chikninakushpa makanakushpankuna chayta chayta anchunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chashnami supaykunapish kikinkunapura karkunakushpankuna wakllichinakunsapa. Kikinkunalla kulluchinakunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mash uyariwaychi. Mana ni pi suk sinchi runapa wasinmanta nimata apayta atipanmanchu manara payta allita watashpara. Chay sinchi runata watashpara tukuy laya tiyapunankunata atipanman kichuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mash allita uyariwaychi. Tata Dioska runakunata tukuy uchankunamanta perdonankasapa. Tata Diosta piñachishpa mana alli rimashkankunatapish perdonankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Chaymanta Tata Dios mana kutin perdonankachu paypa Espiritunta washanchashpa sakra mana alli kananta rimaptinkuna. Chay laya runakunata Tata Dios mana kutin perdonankasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus chayta willarkansapa chay runakuna llullakushpa rimaptinkuna supayadu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus chay runakunata yachachiykaptin paypa mamanwan wawkinkuna chay wasiman rirkansapa. Paykunaka Jesuswan parlanayashpankuna wasi washallamanta kayachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chaypina ladunpi tiyarik runakuna Jesusta willarkansapa: —Mamayki wawkikikunawan washapi maskamushuykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chaypina Jesuska willarkansapa: —¿Pití mamaynika? ¿Pikunatí wawkinikunaka? ");
INSERT INTO qvsNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chaymanta ladunpi tiyarik runakunata kawashpa willarkansapa: —Kaykunami mamayni. Kaykunami wawkinikuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kankuna Tata Diospa munananta rurashpa kawsashpaykichi ñukapa wawkinikuna, paninikuna, mamaynikuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chaymanta suknin diya Jesuska kashkan rirkan kocha mañanpi yachachikuk. Aypa runakuna chaypi tantanakuptinkuna Jesuska suk kanowapi yaykurkan tiyarik. Tukuy chay runakuna kocha mañanmanta uyarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Paykunata rikchak laya ejemplukunata parlachishpa yachachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Willarkansapa: —Mash uyariwaychi. Suk runa rirkan murukunata tarpuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chaypina murukunata shikwashpa tarpuptin sukkuna ñanpi urmarkansapa. Pishkillukuna chay ñanpi urmadu murukunata mikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Suk murukuna rumisapa allpapi urmarkansapa. Chay murukuna allpa sawallapi kashpa utka shurayarkansapa allpa mana rakta kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Chay allpa rumisapa kaptin chay murukuna mana atiparkansapachu sapichakuyta. Chayrayku rupay nanaptin chakirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Chaymanta suk murukuna kashasapa allpapi urmarkansapa. Chaypina kashakuna alli murukunamanta ashwanta wiñashpa chay wiñaykak murukunata makarkansapa. Chayrayku mana nimata wayuchakurkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Chaymanta suk murukuna allima allpapi urmarkansapa. Chaypina wiñashpankuna sukaman aypata wayuchakurkansapa. Suk murukuna kimsa chunkata mirarkansapa. Sukkuna sokta chunkata mirarkansapa. Sukkuna pachakta mirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chay ejempluta parlachikushkanwasha Jesuska willarkansapa: —Kankuna kay yachachishkaynita uyarishpaykichika allita rinrillikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chaymanta aypa runakuna Jesusta sakiptinkuna ladunpi kak runakuna chay chunka ishkay disipulunkunawan tapurkansapa: —Chay ejempluta yachachiwashpaykisapa ¿imatatí yachachiwankisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chaypina Jesus aynirkansapa: —Kankunallata Tata Dios yachachishunkichi paypa mandunpi yaykunaykichipa. Manara yachachishushkaykichita kunan sukaman allitana yachachishuykankichi. Chay mana kreyiwak runakunata Tata Dios ejemplukunallawan yachachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ejemplukunallata yachachishpa paykunata yachachinsapa kawashpapish mana kawakuk runakunashina kiparinankunapa. Uyarishpapish mana entiendinsapachu. Mana uchankunata wananayaptinkuna Tata Dioska manami perdonankasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesuska willarkansapa: —Mana kay ejempluta entiendishpaykichika ¿imashnatí entiendinkichi chikan ejemplukunata? ");
INSERT INTO qvsNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mash uyariwaychi. Tata Diospa rimananta yachachikuk runaka iden chay murukunata tarpukuk runashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Suk runakuna sinchi shunkuyuk kashpa iden ñanpi chakidu sarudu allpashinami. Chay laya runakuna Tata Diospa rimananta uyariptinkuna supay shamushpa chay uyarishkankuna rimanata kunkachin. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Chaymanta suk runakuna Tata Diospa rimananta kushikushpa uyarinsapa. Chay laya runakunaka iden rumisapa allpashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Rumisapa allpapi urmadu murukuna mana allita sapichakuyta atipansapachu rumi sawanpi kashpankuna. Chay laya runakuna nanayta llakita mallishpankuna mana unaypichu Tata Diospa rimananta sakinsapa. Runamasinkuna chiknishpa asichiptinkuna manana kreyikunsapanachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Chaymanta suk runakuna Tata Diospa rimananta uyarishpa kunanlla chaskinsapa. Chay laya runakunaka iden kashasapa allpashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Paykunaka Tata Diospa rimananta allita yachashpapish ashwanta kullkiyayta munansapa. Sukaman munashpankuna tukuy layayuk kayta manana munansapanachu Tata Diospa rimananta uyariyta. Chayrayku mana nimata wayuchakunsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Chaymanta suk runakuna Tata Diospa rimananta uyarishpa tukuy shunku kreyikunsapa. Paykunaka Tata Diosta kuyashpa kawsansapa. Chay laya runakunaka iden chay alli allpapi wayuchakuk murukunashinami. Sukkunaka kimsa chunka murukunata wayuchakukshinami. Sukkunaka sokta chunka murukunata wayuchakukshinami. Sukkunaka pachak murukunata wayuchakukshinami. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesuska ejemplukunawan yachachikuyllapi katirkan: —Suk alkusata apichishpa mana ni pi suk kajonwan wichkashpa nima kawitu sikinpi churashpachu pakanchiman. Apichidu alkusata altupi churanchi tukuyta lusichinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chashnashina Tata Dios tukuy runakuna upallalla rimashkankunata pakallalla rurashkankunata yachan. Chayta tukuy runakunata riksichinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kay yachachishkaynita uyarishpaykichika allita rinrillikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chaymanta Jesus willarkansapa: —Kay yachachishkaynikunata allita kasushpa kawsaychi. Kankuna allita mana allita runamasikichita rurashkaykichishinalla Tata Dios kankunatapish rurashunkichi. Kankuna runamasikichita ima tiyapushuknikichita kuptikichi Tata Dios ashwanta kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kankuna allita Tata Diospa rimananta chaskiptikichi payka yanapashunkichi ashwan allita entiendinaykichipa. Mana allita Tata Diospa rimananta chaskiptikichi payka chay tipi yachashkaykichita kichushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesuska yachachikuyllapi katishpa willarkansapa: —Kay ejempluta parlachiykichi yachanaykichipa imashnami Tata Diospa mandunpi kawsankichi nishpa. Suk runa murukunata tarpuk rin. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chay runaka mana yachanchu imashnami wiñan nishpa. Puñuykaptin rikchadu kaptinpish diyapi tutapi chay murukunaka wiñaykan. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chay murukuna allpapi kashpa kikinllamanta wiñan. Kallarin shurayamushpa wiñayta. Atunyashpa masetayan. Chaymanta murukuna pukunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Allita pukuptinkuna pallana tiempu chayamuptin chay runaka pallan. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Chaymanta Jesuska chay runakunata kashkan yachachirkansapa: —Suk ejempluta parlachiykichi yachanaykichipa imashnami Tata Diospa mandunpi kawsankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kankuna Tata Diospa mandunpi kawsashpaykichi takshasillu mostasa murillukunashina kankichi. Chay mostasa murillukuna rikchak laya murukunamanta ashwan kishnisillu. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Suk runa chakranpi tarpuptin chay murilluka allita wiñan. Kishnisillu kashpapish chay murillu tukuy kiwakunamanta ashwan atunta wiñan. Iden suk atun kaspishina sukaman ramachakun. Chay ramankunapi pishkillukuna wasinkunata ruransapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus rikchak laya ejemplukunawan parlachikushpa chay runakunata yachachirkansapa. Paykuna entiendinankuna layallata yachachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mana ejempluwanka mana yachachikukchu. Disipulunkunallata tukuy yachachikunanta allita entiendichirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay diyalla amusayaykaptin Jesuska disipulunkunata willarkansapa: —Akuychi chimbaypachi kay kochata. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chashna willaptinkuna disipulunkunaka tukuy chay runakunata sakishpankuna chay tiyarishkan kanowallapi Jesusta pusharkansapa. Suk runakuna chikan kanowakunapi katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chashna chimbaykaptinkuna kallarirkan sukaman wayrayta. Chay wayrawan yakuka sukaman olasyashpa yakallapa kanowataka untachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Chay yaku wayrawan kuyuykaptinpish Jesuska kanowa popa partipi sawananta churashpa puñuykarkan. Chaypina disipulunkunaka rirkansapa rikchachik. Sukaman manchakushpankuna willarkansapa: —Maestru ¿imapatí mana yanapawankisapa? ¡Ñami sipikunchisapana! ");
INSERT INTO qvsNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chaypina Jesus atarimushpa wayrata yakuta sinchita willarkan: —¡Sampayay! ¡Amana wayraynachu! Chayta willaptin wayra sampayarkan. Yaku kasillayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesuska sinchi wayrata sampayachishkanwasha disipulunkunata willarkansapa: —¿Imapatí sukaman manchakunkichi? ¿Ariya manarachu allita kreyiwankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chaypina disipulunkuna sukaman manchakushpankuna tapunakurkansapa: —¿Ima laya runatiya kayka? Rimashpalla wayrata yakuta kasillayachin. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chaymanta chay manllayba kochata chimbashpankuna Gadara llaktapi Jesus disipulunkunawan chayarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus kanowamanta llukshiykaptin suk supayadu runa tinkurkan. Chay runaka machaykunapi maypicha wañudukunata pampashkankunapi kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Supayadu kaptin mana ni pi atipaksapachu nima kadenawan watayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aypa kuti llaktamasinkuna makinta chakinta kadenawan watarkansapa. Chaykunata mana nimatashinalla tipik. Mana ni pi chay supayadu runata atipakchu sinchichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Diyapi tutapi chay runaka urkukunapi wañudukuna pampanankuna machaykunapi kaparikushpa purik. Kikinlla rumikunawan ñutuchinakushpa purik. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chaypina chay runa Jesusta kawashpa kallparkan tinkuk. Ñawpakninpi kunkurikushpa sinchita rimashpa willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","—¡Kanka sielupi kawsak Tata Diospa wambran kashpayki ama ñukata amichiwaychu! ¡Tata Diospa shutinpi roygayki ama padesichiwanaykipa! ");
INSERT INTO qvsNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chay runa chayta willarkan yachashpa Jesus supaykunata llukshichinayananta. Chashna chay runa willaptin Jesuska tapurkan: ");
INSERT INTO qvsNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Ima shutití kanki? Chaypina payka aynirkan: —Aypa supaykuna kanisapa chayrayku shutinika Legion. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chaypina chay supaykunaka Jesusta sukaman roygarkansapa ama chay llaktamanta ashwan karuman kachanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mana karupichu chay urku ladunllapi aypa kuchikuna mikukuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chaypina chay runapi kawsak supaykuna Jesusta roygarkansapa: —Kachawaysapa rinaynikunapa chay kuchikunapi yaykuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chaypina Jesus rinankunapa almitiptin paykunaka chay runamanta llukshishpankuna rirkansapa chay yaka ishkay waranka kuchikunapi yaykuk. Chaypina chay kuchikuna kallpashpankuna urkumanta sinkushpankuna yakupi sipikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chay kuchikuna kuydak runakuna chayta kawashpa sukaman manchakurkansapa. Kallparkansapa llaktapi chakrakunapi kawsak runakunata tukuy kawashkankunata parlachikuk. Chayta uyarishpankuna tukuy runakuna rirkansapa chay willashkankunata kawak. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chayashpana tarirkansapa Jesuspa ladunpi chay aypa supayuk kashka runata tiyariduta. Payka alli llachapakudu sanuyaduna karkan. Payta kawashpankuna sukaman manchakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chaypina Jesus rurashkanta kawak chay chayrak shamushka runakunata tukuy kawashkankunata parlachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chayta uyarishpankuna Gadara partipi kawsak runakuna Jesusta roygarkansapa chayllamanta kutinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chaypina Jesus kanowaman riykaptin chay sanuyadu runaka roygarkan pushananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Chashna roygaptin Jesus mana pushanayashpa willarkan: —Kutiy wasikiman tukuy aylluykikunata parlachinaykipa Tata Dios llakichishushpa sanuyachishushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chashna Jesus willaptinna chay runaka kushikuypuru Dekapolis partipi tukuy llaktakunapi parlachikuypi purirkan. Willarkansapa Jesus sanuyachishkanta. Chayta uyarishpankuna tukuy runakuna sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaymanta Jesus kanowapi kochata chimbaptin aypa runakuna tantanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jesus kocha mañanllapi kaptin suk runa Jairo laduncharkan. Jairoka tantanakunankuna wasipi kamachikuk runa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Payka Jesuspa ñawpakninpi kunkurikushpa sukaman roygarkan: —Chaylla shipashnini wañunayaykan. Aku wasiniman. Kan llankaptiki shipashninika alliyashpa kawsanka. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chashna willaptin Jesuska chay kamachikuk runata katirkan. Sukaman aypa runakunapish niti niti katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay aypa nitik runakunapa chawpinkunapi suk unkudu warmi karkan. Chay warmika chunka ishkay watatana yawar unkuywan kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tukuy kullkintana tukucharkan doktorkunata katishpa. Mana ni pi alliyachiyta atipaptin ashwanta anchayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chay unkudu warmika uyarirkan Jesus unkudukunata alliyachiykananta. Chayrayku washanmanta ladunchashpa llachapan mañanta llankarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Payka yuyarkan: “Llachapanllatapish llankaptini alliyachiwanka.” ");
INSERT INTO qvsNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chashna llankashkan ratulla yawarnin tipikuptin alliyaduna mallinakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Suk unkuduta alliyachishkananta mallishpa Jesus washanta chapashpa tapukurkan: —¿Pití llachapaynita llankashkankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chashna tapukuptin disipulunkuna willarkansapa: —Aypa runakuna laduykipi sukaman nitishushpa kayta chayta tankanakushpankuna llankashuykansapa. ¿Imapatí tapuwankisapa “piti llankawashka” nishpa? ");
INSERT INTO qvsNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Chashna willaptinkunapish Jesuska sukta sukta chaparkansapa yachanayashpa maykanmi alliyanayashpa llankashka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chaypina chay warmika yachashpana sanuyadu kananta sukaman manchakuywan chukchukushpa rirkan Jesuspa ñawpakninpi kunkurikuk. Chaypina Jesusta willarkan alliyashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chashna chay warmi willaptinna Jesuska willarkan: —Wambrayni, allita ñukata kreyiwashkaykirayku alliyachishkayki. Kunanka kushikushpa wasikiman alliyaduna kutiy. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus chay warmiwan parlaykaptinllara Jairopa wasinmanta suk runakuna chayarkansapa willak: —Wambraykika ñami wañushkana. ¿Imapanatí wasikiman Jesusta pushanki? ");
INSERT INTO qvsNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chayta uyarishpapish Jesuska Jairota willarkan: —Ama manchakuychu. Tukuy shunku ñukata kreyiway. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesuska mana munarkanchu katiykak runakuna paywan rinankunapa. Pedruwan Santiago paypa wakin Juanllata pusharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chaypina Jairopa wasinpi chayashpa uyarirkan sukaman turbakushpankuna aypa runakuna kaparishpa wakakuykaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wasipi yaykushpa paykunata willarkansapa: —¿Imapatí sukaman turbakushpa sinchita wakakuykankichi? Kay shipashka puñuykanmi. Manami wañuduchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chashna willaptinkuna chay wakakuk runakuna Jesusta mana kreyishpankuna asichirkansapa. Jesuska tukuy paykunata llukshichishpankuna pushashkan disipulunkunallawan shipashpa tatan mamanwan yaykurkan chay kuartupi. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chaypina wañuduta makinmanta apishpa willarkan: —Talita kumi. Chay rimanapi riman: “Wambrayni, atarimuy.” ");
INSERT INTO qvsNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chashna Jesus willaptinna chay chunka ishkay watayuk shipashka atarimushpa purirkan. Chay runakuna kawsamuduta kawashpankuna sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Chaypina Jesuska paykunata sukaman willarkansapa ama ni pita parlachinankunapa chay shipashta wañushkanmanta kawsachimushkanta. Chaymanta willarkansapa chay shipashta karanankunapana. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaymanta Jesuska chay llaktamanta llukshishpa kikinpa llaktanpi chayarkan. Disipulunkuna paywan tantalla rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chaypina samana diya kaptin Jesuska rirkan tantanakunankuna wasipi yachachikuk. Allita yachachikuptin tukuy runakuna sukaman almirashpankuna tapunakurkansapa: —¿Maypití kay runaka tukuy layata yachakushka? ¿Pití yachachishka chay layata yachananpa? ¿Imashnatí yachan almirana milagrukunata rurayta? ");
INSERT INTO qvsNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manachu kay runaka karpinterupa wambran? Paypa mamanka Mariyami. Chaymanta wawkinkuna Jakobo, Jose, Judas, Simon. ¿Manachu paninkunapish llaktamasinchikunalla? Llaktamasinkuna kaptin Jesusta mana kreyinayarkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chaypina Jesuska willarkansapa: —Tata Diospa rimananta yachachikuk runa chikan llaktakunapi yachachikuptin sukaman allita uyarinsapa. Kikinpa llaktanpi yachachikuptin mana nima llaktamasinkuna nima ayllunkuna kreyinsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mana kreyishkankunarayku kikin llaktanpi Jesuska mana aypa almirana milagrukunata rurarkanchu. Suk runakunallata alliyachirkan llankashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sukaman almirarkan llaktamasinkuna mana kreyiptinkuna. Chaymanta Jesuska tukuy llaktan ladupi llaktillukunapi yachachikuypi purirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Suknin diya chunka ishkay disipulunkunata tantanachishpa ishkaymanta ishkaymanta kacharkansapa. Atipachirkansapa tukuy laya supaykunata runakunamanta llukshichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paykunata willarkansapa ama nimata apashpa rinankunapa. Willarkansapa ama nima pikshata nima mirkapankunata nima kullkita apanankunapa. Willarkansapa suk bastonninllata apanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Willarkansapa ushutanllawan sawankunapi llachapallawan rinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chaymanta willarkansapa: —Maykan llaktapi chayashpaykichi suk runapa wasinpi kipariychi chikan llaktaman rinaykichi diyakaman. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ichara chayashkaykichi llaktapi kawsak runakuna wasinkunapi mana chaskishunayankichimanchu. Paykuna mana chaskishuptikichi mana uyarishuptikichi chakikichi susyata tapsishpa chay llaktamanta llukshiychi. Chayta rurashpa willaykankichi paykunallapi uchankuna kiparinanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chashna Jesus kachaptinkunana disipulunkunaka llaktan llaktan yachachikuypi purirkansapa. Yachachikurkansapa uchankunata wanashpa Tata Diosta kasushpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chaymanta runakunamanta aypa supaykunata llukshichirkansapa. Rikchak laya unkuyuk runakunata alliyachirkansapa tipi wirawan tupashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chay tiempu aypa runakuna sukaman famakurkansapa Jesus aypa almirana milagrukunata rurashkanta. Chay kamachikuk Herodes chayta uyarishpa rimarkan: —Ichará chay Jesuska wañuchichishkayni Juan. Paychá wañushkanmanta kawsamushka. Chayrayku atipan almirana milagrukunata rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Suk runakuna rimarkansapa: —Kay runaka ñawpa alli yachachikuk Eliyasmi. Sukkuna rimarkansapa: —Kay runaka ñawpa yachachikuk runakunashinami. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chayta uyarishpa Herodeska rimarkan: —Kay runaka Juanmi. Ñuka payta wañuchichishkani umanta tipichipushpa. Kunanka wañushkanmanta kawsamushkana. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes chayta rimarkan Juanta wañuchichishkanta yuyashpa. Ñawpaka Juanta kadenakunawan watachishpa karselpi wichkachirkan. Chayta rurarkan warmin Herodiyas munaptin. Herodiyaska ñawpaka wawkin Felipipa warmin karkan. Herodeska chay kuñadantaka warminpa apirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chayrayku Juanka Herodesta willarkan: —Mana allitachu ruraykanki wawkikipa warminwan uchallikushpa kawsashpayki. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chashna willashkanrayku chay warmi Herodiyaska Juanta sukaman chiknishpa wañuchinayarkan. Mana wañuchiyta atiparkanchu Herodes michaptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodeska Juanta mancharkan Tata Diosta kuyak alli rurak runa kananta yachashpa. Juan yachachikushkanta uyarishpa Herodeska mana yacharkanchu imatami ruranka nishpa. Mana allita entiendishpapish munarkanlla uyariyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Chaymanta suk diya Herodiyaska munashkan layata rurarkan. Herodeska fiestakurkan watan paktashkanrayku. Fiestaman invitarkan soldadukunapa kapitanninkunata Galileapi ashwan sinchi awtoridarkunata. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chay fiestapi warmin Herodiyaspa shipashnin tushurkan tukuy invitadukunapa ñawpakninkunapi. Tushushkanta kawashpa Herodeswan tukuy invitadunkuna sukaman kushikurkansapa. Chayrayku Herodeska chay shipashtaka willarkan: —Imatapish kaptin mañaway. Mañawashkaykita kushkayki. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sukaman jurashpa kuti kuti willarkan mañashkanta kunanpa. Chay kamachikunan llaktata patumata mañaptinpish willarkan kunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chashna Herodes willaptin chay shipashka llukshishpa mamanta tapurkan: —¿Imatatí mañasha? Chaypina mamanka willarkan: —Juan Bawtistapa umanta mañay. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chashna maman yachachiptin chay shipashka utkakushpa Herodesman rishpa willarkan: —Kunanlla munani Juan Bawtistapa umanta suk kallanapi kuwanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Chayta mañaptin Herodeska sukaman llakirkan. Llakishpapish mana llullachiyta atiparkanchu invitadunkuna ñawpakninpi jurashpa willashkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chayrayku Herodeska suk soldadunta willarkan Juanpa umanta tipishpa apamunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chay soldaduka Herodes willashkanta rurarkan. Karselman rishpa Juanpa umanta tipishpa suk kallanapi churashpa aparkan. Herodeska chay shipashta chaskichiptin payka mamanta kurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaypina Juanpa katikninkuna wañuchishkanta yachashpankuna rirkansapa kuerpunta apak pampanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaymanta chunka ishkay disipulunkuna Jesusman kutishpankuna parlachirkansapa runakunata yachachishkankunata alliyachishkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chaypina Jesuska willarkansapa: —Akuychi ñukanchikunalla suk chunllapi samak. Jesus chayta willarkansapa sukaman aypa runakuna sukpish sukpish shamuptinkuna riptinkuna. Chayrayku disipulunkuna mana atiparkansapachu mikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chaypina Jesuska disipulunkunawan suk kanowapi rirkansapa suk chunllapi samak. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Chayman riykaptinkuna aypa runakuna kawarkansapa. Paykunaka Jesusta disipulunkunata riksishpankuna yacharkansapa maytami riykansapa nishpa. Tukuy chay llaktakunamanta kallparkansapa Jesusta tinkuk. Paykunaka ñawpakta chay chunllapi chayarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesuska kanowamanta llukshishpa paykunata kawashpa sukaman llakichirkansapa. Paykuna iden mana doyñuyuk ovejakunashina karkansapa mana ni pi kuydaptin. Chaypina Jesuska rikchak layata yachachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chaymanta amusayaptin disipulunkuna Jesusta ladunchashpankuna willarkansapa: —Ñami amusayaykanna. Manami ni pi kaypika kawsanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chayrayku tukuy kay runakunata willay chayllapi tiyak llaktillukunaman chakrakunaman rinankunapa mikunankunata rantik. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Chaypina Jesuska willarkansapa: —Kankuna karaychi. Chashna Jesus willaptinkuna tapurkansapa: —¿Munankichu ishkay pachak kullkiwan panta rantinaynikunapa tukuy paykunata karananchikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chaypina Jesuska willarkansapa: —¿Mashna pannikichití tiyan? Rillaychi kawak. Tapushkankunawasha willarkansapa: —Pichka pan ishkay challwillukuna tiyawansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaypina Jesuska tukuy chay runakunata willarkansapa uksha sawanpi tiyarinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tukuy chay aypa runakuna manada manada tiyarirkansapa. Sukkunaka pichka chunkamanta sukkunaka pachakmanta tiyarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chaymanta Jesuska chay pichka panta chay ishkay challwata apishpa sieluta chapashpa Tata Diosta agradesirkan. Chaymanta chay challwakunata chay pankunata paki paki rurashpa disipulunkunata kurkansapa runakunata charichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tukuy runakuna mikurkansapa saksanankunakaman. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chaymanta mikushkankunawasha puchushkan panta challwata tantachirkansapa chunka ishkay sestu untata. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chay mikuk ullkukuna pichka waranka karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaymanta Jesuska disipulunkunata willarkansapa kanowapi kochata chimbanankunapa. Willarkansapa Betsaida llaktaman ñawpanankunapa pay runakunata willanankaman wasinkunaman kutinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chay runakunata despidishkankunawasha Jesuska sapallan suk urkuman rirkan chaypi Tatan Dioswan parlananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tutayaptinna disipulunkuna kanowapi chawpi kochata riykarkansapa. Jesuska chay urkupi kashpa disipulunkunata kawarkan mana atipanankunata chimbayta sinchi wayra chikanman pushanayaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chaymanta pakariykaptinna Jesuska yaku sawanta purishpa paykunaman rirkan ladunta pasaykakshinalla. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesus yaku sawanta puriptin disipulunkuna kawashpankuna yuyarkansapa supay kananta. Chayrayku sukaman kaparirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tukuy paykuna Jesusta kawashpankuna sukaman manchakurkansapa. Manchakuywan kapariptinkuna Jesuska willarkansapa: —¡Ama manchakuychichu! ¡Ñukami kani! ");
INSERT INTO qvsNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesus kanowapi yaykuptinna chay sinchi wayraka kasillayarkan. Chayta kawashpankuna sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paykuna Jesus pankunata mirachishkanta kawashpapish manara entiendirkansaparachu sinchi yachak kananta. Chayrayku mana atiparkansapachu payta kreyiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chay sinchi wayrata kasillayachiptinna Jesuswan tantalla chay kochata chimbashpa Genesaret partipi chayarkansapa. Chay kocha mañanpi kanowata watarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesus kanowamanta llukshiykaptin chaypi kawsak runakuna riksirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kayta chayta kallpashpankuna famakurkansapa Jesus llaktankunapi kananta. Chaypina Jesusman tukuy laya unkudu runakunata kamillakunapi pusharkansapa alliyachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tukuy atun taksha llaktapipish chakrakunapipish Jesus chayaptin unkudukunata ñankunapi churaksapa. Sukaman Jesusta roygaksapa llachapanllatapish llankanankunapa. Chashna llankashpankuna alliyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chaymanta fariseo runakunawan Moisespa killkadunta yachachikukkuna Jerusalen llaktamanta rishpankuna Jesusta laduncharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Paykunaka kawarkansapa Jesuspa disipulunkunata manara amañashkankunashina makinkunata mayllashpankunara mikuykaptinkuna. Chayrayku paykunata washancharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chay fariseokunawan tukuy judiyu runakuna Tata Diospi chuya chuya rikurinankunapa amañaksapa sukaman allita makinkunata mayllayta. Manara makinkunata mayllashpa mana mikuksapachu. Ñawpa awilunkunapa tiempunmantapacha chayta amañaksapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Merkadumanta kutishpankuna manara makinkunata mayllashpara mana mikuksapachu. Chashnalla mayllaksapa puyñunkunata, kallanankunata, patinkunata, katanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tukuy chayta amañashkankunarayku fariseokunawan Moisespa killkadunta yachachikuk runakuna Jesusta tapurkansapa: —¿Imapatí disipuluykikuna mana ñawpa awilunchikunapa amañashkankunata ruransapa? ¿Imapatí paykunaka makinkunata mana mayllashpankuna mikunsapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chaypina Jesuska willarkansapa: —Kankunaka allipi tukushpa llulla likidu kankichi. Kankunapa ñawpa yachachikuk Isaiyas killkarkan: “Kay runakuna mishki shimi tukushpa kuyawansapa. Mana tukuy shunkuchu kuyawansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Runakunapa yachachikunankunallata yachachikunsapa. Kuyawakshina tantanakushpankunapish mana kushichiwansapachu.” ");
INSERT INTO qvsNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kankuna Tata Diospa munananta mana rurashpaykichi ñawpa awiluykichipa amañashkankunallata rurankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Chaymanta Jesuska willarkansapa: —Kankunaka Tata Diospa kamachikunankunata mana nimatashina kawankichi amañashkaykichillata ruranaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiseska killkarkan: “Tataykita mamaykita allita kuyashpa kawsay.” Chaymanta killkarkan: “Suk runa tatanta mamanta maldisiptin wañuchichinaykichi tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Chashna Moises killkaptinpish kankunaka chikan layata yachachiykankichi. Runakunata yachachinkichi: “Tataykichita mamaykichita mana yanapanayashpaykichi paykunata willankichi: ‘Kankunata yanapanayni kullkita Tata Diostanami kushkani. Chayrayku manana tiyawannachu kankunata yanapanaynipa.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chashna yachachikushpaykichi chay runakunata willaykankichi ama tatanta mamanta yanapanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chashna yachachikushpaykichi Tata Dios kamachikushkankunata mana nimatashina kawaykankichi. Tata Diosta mana kasunayashpaykichi ñawpa awiluykichipa amañashkankunallata ruraykankichi. Chaymanta chayta yachachikushpaykichi chashnalla aypa layakunallata yachachikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chashna willashpa Jesuska tukuy chay runakunata ladunman kayashpankuna willarkansapa: —Mash allita uyariwaychi entiendinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Imatapish kaptin mikushpaykichi mana uchallikunkichichu. Mana alli yuyanaykichita rurashpaykichi chaypi esika uchallikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Allita uyariwashpaykichi allita rinrillikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chaymanta Jesuska chay runakunata sakishpa wasipi yaykurkan. Chaypina disipulunkunaka roygarkansapa chay yachachikushkanta entiendichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesuska willarkansapa: —¿Ariya kankunapish manarachu entiendinkichira? Mana uchallikunchichu nima laya mikunata mikushpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mikunanchi wiksanchillaman rin. Chaymanta llukshin. Mana yuyayninchipi yaykunchu. Chayta rimashpa Jesuska yachachikurkan tukuy laya mikuna alli kananta. Chayrayku imatapish mikuptinchikuna manami uchallikunchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chaymanta willarkansapa: —Suk runa mana allita yuyashpa mana allita rimashpa esika uchallikun. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Manara uchallikushpa shunkunpi yuyan imatami ruranka nishpa. Chaykunata yuyashpara manara kasarashpara warmiwan uchallikun. Chaymanta kasaradu kashpapish chikan warmiwan uchallikun, suwakun, runamasinta wañuchin. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Chikanpa tiyapunankunata kichunayan, sakra likidu tukun, llullachikun, mana allikunata rurashpa kawsan, sukpa tiyapunanta kawashpa munashpa llakin, tukuy pita yuyaypi purin, kikinlla kreyinakun, mana alli yuyayuk tukun. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Suk runa tukuy chay mana allikunata shunkunpi yuyashpa chaykunata ruran. Tukuy chaykunata rurashpa uchallikun. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaymanta Tiro partiman Jesuska rirkan. Jesus suk wasipi yaykurkan ama ni pi yachananpa chaypi kananta. Chashna munashpapish mana pakakuyta atiparkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chay wasipi chayaptinlla suk warmi kunanlla yacharkan Jesus chaypi kananta. Paypa shipashnin supayadu karkan. Chay warmika Jesuspa ñawpakninpi rirkan kunkurikuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Payka Sirofenisia partimanta kashpa mana judiyu kastachu karkan. Jesuspa ñawpakninpi kunkurikushpa sukaman roygarkan shipashninmanta supayta llukshichinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chaypina Jesuska willarkan: —Manarapish ni pita chikan llaktakunamanta alliyachishpaynira judiyumasinikunatara yanapanayni tiyan. Mana allichu wambrakunata pankunata kichushpa allkukunata karanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chashna Jesus willaptin chay warmika willarkan: —Ariya Señor, wambrakuna mesapi churaduta mikuptinkuna mesamanta puchudukuna urmaptin allkukunapish mikunsapa. Ñuka allkushina kaptinipish yanapaway. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chaypina Jesuska willarkan: —Tukuy shunku kreyiwashkaykirayku shipashnikimanta supayta ñami llukshichishkanina. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chaymanta chay warmi wasinpi chayashpa shipashninta tarirkan kawitunpi siriduta supay llukshidutana. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro partimanta Jesus llukshishpa Sidon partita Dekapolis partipi llaktakunata pasashpa Galilea kochapi chayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chaypina runakuna payman pushamurkansapa suk mana uyarik mana rimakuy atipak runata. Jesusta roygarkansapa llankashpa alliyachinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chaypina Jesuska chay runata suk laduman pushashpa rinrinkunapi dedunkunata satirkan. Tukayninwan kallunta tupapurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chayta rurashpa Jesuska sieluta chapashpa samayninta surkurkan. Chaymanta chay runata willarkan: —¡Efata! Chay rimana riman: “Kicharinakuy.” ");
INSERT INTO qvsNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chayta Jesus willaptinlla atiparkan uyarikuyta. Kallunpish alliyaptin allitana rimakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chaymanta Jesuska tukuy runakunata sukaman willarkansapa ama ni pita parlachinankunapa chay runata alliyachishkanta. Sukaman willaptinkunapish paykunaka ashwanllata parlachikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Paykuna sukaman almirashpankuna rimarkansapa: —Jesuska tukuy layata allita ruran. Payka upa runakunatapish alliyachin uyarinankunapa. Mana rimakukkunatapish alliyachin rimakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chaymanta suknin diya kashkan aypa runakuna tantanakurkansapa Jesus yachachikuptin uyarinankunapa. Paykunapa mana nima mikunankuna tiyaptin Jesuska disipulunkunata kayashpankuna willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Sukaman kay runakunata llakichinisapa. Ñami kimsa diyatana ñukawan kashpankuna tukuy mikunankunata tukuchashkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sukkuna sukaman karu llaktakunamanta shamushkasapa. Chayrayku mana willanayanisapachu wasinkunaman kutinankunapa mana nimata karashpayni. Ichará mana mikushpa rishpankuna ñanpi shaykunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chayta willaptinkuna disipulunkunaka Jesusta willarkansapa: —Kaypika manami niman suk runa kawsanchu. ¿Imashnatí kay chunllapi kay aypa runakunata karanchimansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chaypina Jesuska tapurkansapa: —¿Mashna pannikichití tiyan? Paykunaka aynirkansapa: —Kanchislla tiyawansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chaypina Jesuska tukuy chay runakunata willarkansapa allpapi tiyarinankunapa. Tiyariptinkuna chay kanchis pankunata apishpa Tata Diosta agradesirkan. Chaymanta chay pankunata paki paki rurashpa disipulunkunata kurkansapa runakunata charichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chaymanta paykunapa tiyapurkansapa challwillunkuna. Jesus chaytapish apishpa Tata Diosta agradesirkan. Chaypina disipulunkunata willarkansapa chaytapish karanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tukuy chay runakuna mikurkansapa saksanankunakaman. Chaymanta mikushkankuna puchushkata kanchis sestu untata tantachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chay mikuk ullkukuna yaka chusku waranka karkansapa. Chaymanta mikushkankunawasha Jesuska willarkansapa wasinkunaman kutinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Rishkankunawasha Jesuska disipulunkunawan suk kanowapi Dalmanuta partiman rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chaymanta fariseo runakuna Jesusta laduncharkansapa. Paykunaka Jesusta llullachinayashpa kallarirkansapa sukaman tapuyta. Roygarkansapa suk almirana milagruta rurananpa yachanankunapa Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chaypina Jesuska llakishpa sinchita samaykushpa willarkansapa: —¿Imapatí roygawankichi suk almirana milagruta ruranaynipa? Kankuna roygawaptikichipish mana nimata rurashachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chaymanta Jesuska paykunata sakirkansapa. Shamushkan kanowapi yaykushpa chay kochata chimbarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Manara chay kanowapi chimbashpankuna disipulunkuna kunkarkansapa mirkapankunata apayta. Kanowapika suk pansillulla tiyapurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chashna riykashpankuna Jesuska willarkansapa: —Mash allita uyariwaychi. Ama munaychichu fariseokunapa nima Herodespa levadurawan ruradu pankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chashna Jesus willaptinkuna mana entiendishpankuna willanakurkansapa: —Pankunata mana apamushkanchikunaraykumi chaytaka willawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chay rimashkankunata yachashpa Jesuska willarkansapa: —¿Imapatí rimankichi mana nima pan tiyashunaykichita? Mana pannikichi illashkanraykuchu chayta willashkaykichi. ¿Ariya manarachu entiendinkichira? ¿Manarachu allitara riksiwankichi? ¿Imapatí sukaman sinchi shunku kankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ñawiyuk kashpaykichi ¿manachu rurashkaynita kawashkankichi? Rinriyuk kashpaykichi ¿manachu yachachikushkaynita uyarishkankichi? ¿Manachu yuyankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pichka pankunawan pichka waranka runakunata karaptini ¿mashna sestutatí mikuna puchuduta tantachirkankichi? Chaypina paykuna aynirkansapa: —Chunka ishkay sestuta. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chaypina Jesuska kashkan tapurkansapa: —Chaymanta chusku waranka runakunata kanchis panta mirachishpa karaptini ¿mashna sestu untatatí puchudu pankunata tantachirkankichi? Chashna tapuptinkuna disipulunkunaka aynirkansapa: —Kanchis sestuta. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chaypina Jesuska willarkansapa: —¿Manarachu allitara entiendiwankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaymanta Betsaida llaktapi Jesuska disipulunkunawan chayarkansapa. Chaypina Jesusman suk mana kawakuk runata pushamurkansapa. Roygarkansapa llankashpa alliyachinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesuska chay mana kawakuk runata makinmanta apishpa pusharkan llakta washaman. Chaypina tukayninwan ñawinkunata ñuyuchishpa umanpi makinta churashpa tapurkan: —¿Atipankichu kawakuyta? ");
INSERT INTO qvsNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chay mana kawakuk runaka suk tipisituta kawakushpana willarkan: —Kawani runakunata kaspikuna puriktashina. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesuska kashkan ñawinta llankapuptin chay runaka alliyashpana tukuy layata sukaman allitana kawarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chaypina Jesuska willarkan: —Kuskalla wasikiman rillay. Amana llaktaman kutiynachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaymanta Sesarea Filipo partipi llaktakunaman Jesuska disipulunkunawan rirkansapa. Ñanta riykashpankuna Jesuska tapurkansapa: —Runakuna parlashpankuna ¿pi kanaynitatí rimaykansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chaypina paykunaka aynirkansapa: —Sukkuna rimansapa Juan Bawtista kanaykita. Sukkuna rimansapa ñawpa yachachikuk Eliyas kanaykita. Sukkuna rimansapa Tata Diospa rimananta yachachikuk runa kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chaypina Jesuska tapurkansapa: —Kankunaka ¿pi kanaynitatí yuyankichi? Chashna tapuptinkuna Pedruka aynirkan: —Kanka Tata Diosmanta shamudu salvakuk runami kanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chaypina Jesuska willarkansapa amara ni pita willanankunapa Tata Diosmanta shamudu salvakuk runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaymanta Jesus allita entiendichishpankuna willarkansapa sielumanta shamudu runa kashpa sukaman padesinanta. Willarkansapa ansianukunawan saserdotekunapa kamachikukninkunawan Moisespa killkadunta yachachikuk runakuna sukaman chiknishpankuna padesichinankunata. Willarkansapa paykuna chiknishpankuna wañuchinankunatapish. Chaymanta willarkansapa wañuchiptinkuna kimsa diyapi kawsamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tukuy chayta kuskata yachachirkansapa. Chaypina Pedruka suk chikanman Jesusta pushashpa willarkan: —Señor, ama chaytaka yuyaychu. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Chashna willaptin Jesuska disipulunkunata chapashpa Pedruta piñayashpa willarkan: —Ñukamanta anchuy, Satanas. Runakunapa munananllata yuyashpa willawaykanki ama wañunaynipa. Manami Tata Diospa munanantachu willawaykanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chaymanta Jesuska tukuy disipulunkunata chaypi tiyak runakunatapish kayashpankuna willarkansapa: —Kankuna disipuluynikuna kanayashpaykichika amana kikikichipa munanaykichita rurashpanachu kawsaychi. Chiknishuk runakuna ñukarayku wañuchishunayaptikichipish ñukallata kreyiwashpa katiwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kankuna wañuymanta kishpinayashpa sakiwashpaykichika mana tukuyniyuk ninamanta mana kishpinkichichu. Chaymanta kreyiwashkaykichirayku runakuna wañuchishuptikichipish sieluman rinkichi Tata Dioswan mana tukuyniyukta kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Suk runa rikchak laya tiyapuptin mana sielupi yaykushpaka yankamanta kay allpapi tukuy layayuk kashka. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tukuy tiyapukninkuna mana nimapi yanapankachu ninamanta kishpinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Suk runakuna mana alli rurak mana kreyiwak runakunapa ñawpakninkunapi ñukata pinkakuwansapa. Rimanaynitapish mana munansapachu. Chashna pinkakuwaptinkuna kay allpaman kashkan shamuptini ñukapish chay pinkakuwak runakunata willashasapa mana ñukapa kanankunata. Chay diyaka Tatayni Diospa llipyayninpi yanapawak angelkunawan tantalla kashkan shamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chaymanta Jesuska willarkansapa: —Mash allita uyariwaychi. Suk kankuna manara wañushpaykichira kawankichi Tata Diospa mandunpi ñuka sinchita kamachikuptini. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chaymanta sokta diya yachachikushkanwasha Jesuska rirkan suk atun urkuman Pedruta Jakobota Juanta pushashpankuna. Chaypi paykunalla kawaptinkuna Jesuska chikan laya tukurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Llachapan yurak likidu tukushpa sukaman llipyarkan. Mana ni pi nima sukaman takshashpa chay laya yurakta ruranmanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chaypina chay kimsa disipulunkunaka chapashpankuna kawarkansapa Eliyasta Moisesta Jesuswan parlaykaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Paykunata kawashpa Pedruka Jesusta willarkan: —Maestru, allipaka kanwan tantalla shamushkanisapa. Munaptiki kimsa ranchituta rurashasapa, sukta kanpa, sukta Moisespa, sukta Eliyaspa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chay kimsa disipulunkunaka sukaman manchakurkansapa. Chayrayku Pedruka chayta rimarkan mana yuyashpa imatami riman nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaypina puyu sirishpa paykunata wichkamurkansapa. Chay puyu ukunmanta uyarirkansapa Tata Dios willaptin: —Kay Jesuska munanayni wambraynimi. Chayrayku payta allita uyariychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chayta uyarishkankunawasha disipulunkuna tukuy mayta chapashpankuna Jesusta sapallanta kawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chaymanta chay urkumanta urayaykashpankuna Jesuska willarkansapa amara ni pita parlachinankunapa chay urkupi kawashkankunata. Willarkansapa sielumanta shamudu runa wañushkanmanta kawsamuptinra parlachikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chayta willashkankunarayku paykunaka mana ni pita parlachirkansaparachu. Mana entiendishpankuna tapunakurkansapa imapati Jesuska rimashka wañushkanmanta kawsamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chaypina Jesusta tapurkansapa: —¿Imapatí Moisespa killkadunta yachachikuk runakuna rimansapa manara Tata Diosmanta shamuk runa shamuptin Eliyas shamunanta? ");
INSERT INTO qvsNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chashna tapuptinkuna Jesuska willarkansapa: —Deverasmi Moiseska rimarkan Eliyas shamunanta runakunata willak sielumanta shamuk runata shuyanankunapa. Tata Diospa killkadunpi riman runakuna ñuka sielumanta shamudu runata mana munawashpa padesichiwanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mash uyariwaychi. Eliyaska ñami shamushkana. Runakuna mana riksishpankuna chiknishpa padesichirkansapa wañuchinankunakaman. Tata Diospa killkadunpi rimarkan chashna padesichishpankuna wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chaymanta Jesuska chay kimsa disipulunkunawan urkumanta kutimushpankuna chayarkansapa maypicha suk disipulunkuna karkansapa. Paykuna aypa tantanakudu runakunapa chawpinkunapi Moisespa killkadunta yachachikuk runakunawan ayninakuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesusta kawashpankuna tukuy runakuna almirashpankuna kallparkansapa rimachik. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chaypina Jesuska tapurkansapa: —¿Imaraykutí ayninakuykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chaypina suk runa Jesusta aynirkan: —Maestru, kanman pushamushkani wambraynita. Payka supayadu kashpa mana nima rimakuyta atipanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maypipish kaptin supay apishpa waktakun. Shiminmanta sukaman pusuk llukshin. Kirunta mukushpa soynachin. Chaymanta kaspirayadu tukun. Disipuluykikunata roygashkanina supayta llukshichinankunapa. Chashna roygaptini mana atipashkasapachu llukshichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chaypina Jesuska willarkansapa: —Sakra mana kreyikuk runakuna kankichi. ¿Aykapikamantí kankunawan kanayni tiyan? ¿Aykapikamantí amichiwankichi? Kayman pushamuychi chay unkudu wambrata. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chashna pushamuptinkuna supayka Jesusta kawashpa chay wambrata kashkan unkuchishpa allpapi urmachirkan. Chaypi chay wambrapa shimin pusukyarkan. Sukaman kuchpakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chaypina Jesuska wambrapa tatanta tapurkan: —¿Mashna tiemputanatí chashna kawsan? Payka aynirkan: —Takshillunmantapacha unkudu kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Chay supayka wambraynita wañuchinayashpa yakupi ninapi urmachin. Chayrayku roygayki llakichiwaysapa. Atipashpaykika yanapawaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuska chay runata willarkan: —¿Manarachu kreyiwanki atipanaynita alliyachiyta? Ñukata tukuy shunku kreyiwaptiki rikchak layata rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chayta willaptin chay wambrapa tatanka sinchita willarkan: —Kreyini yanapawanaykita. Yanapaway tukuy shunku ashwanta kreyinaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chaypina Jesuska kawarkan ashwan aypa runakuna shamuykanankunata. Chayta kawashpa supayta sinchita willarkan: —Kan kay wambrata unkuchishkanki mana rimakunanpa nima uyarikunanpa. Kunanka willayki: ¡Kay wambramanta llukshiy! ¡Amana kutin paypika yaykuynachu! ");
INSERT INTO qvsNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chashna Jesus willaptin chay supayka sukaman kaparishpa kashkan chay wambrata chukchuchirkan. Paymanta llukshishpa iden wañudutashina sakirkan. Chayta kawashpa chay runakuna rimarkansapa wañushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Chaypina Jesuska makinmanta apishpa chay wambrata sanutana atarichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaymanta suk wasiman Jesus yaykuptin disipulunkuna sapallanta tapurkansapa: —¿Imapatí ñukaykuna chay supayta mana atipashkanisapa llukshichiyta? ");
INSERT INTO qvsNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chaypina Jesuska willarkansapa: —Chay laya supayta atipanchisapa llukshichiyta mana nimata mikushpa tukuy shunku Tata Diosta roygashpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chay llaktamanta rishpankuna Galilea partipi puriykarkansapa. Jesuska mana munarkanchu ni pi yachananpa chaypi kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chashna riykashpankuna disipulunkunata yachachirkansapa: —Chikniwak runakuna ñuka sielumanta shamudu runata awtoridarkunapi kukuwankasapa. Paykuna wañuchiwankasapa. Chaymanta kimsa diyapi kashkan kawsamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chaypina disipulunkuna chay yachachikunanta mana nima entiendishpankunapish manchakurkansapa tapuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chaymanta Jesuska disipulunkunawan Kapernaum llaktapi chayarkansapa. Chaypina wasipi kashpankuna Jesuska disipulunkunata tapurkansapa: —Ñanpi shamuykaptinchikuna ¿imatatí ayninakuykashkankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Paykunaka pinkakushpankuna mana nimata aynirkansapachu. Ñanpika sukaman ayninakushkasapa tukuy paykunamanta maykanmi ashwan alli kamachikuk kanka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaypina Jesuska tiyarishpa tukuy chunka ishkay disipulunkunata ladunman kayarkansapa. Paykunata willarkansapa: —Kankuna ashwan alli kamachikuk kanayashpaykichi mana kreyinakushpa sukkunata sirvinaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chashna willashpankuna Jesuska suk taksha wambrilluta kayashpa chawpinkunapi shayachirkan. Chaymanta payta markashpa willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Kankuna ñukata kuyawashpa suk wambrata chaskishpaykichi ñukatami chaskiwaykankichi. Ñukata chaskiwashpaykichi mana ñukallatachu chaskiwaykankichi. Kachamuwak Tatayni Diostapish chaskiykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chaymanta disipulun Juan Jesusta willarkan: —Maestru, suk runata kawashkanisapa kanpa shutikita rimashpa runakunamanta supaykunata llukshichiptin. Ñukaykuna payta michashkanisapa mana ñukanchikunawan tantalla puriptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chaypina Jesuska willarkansapa: —Ama michaychichu. Suk runa shutinita rimashpa suk almirana milagruta rurashpa mana washanchawankachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Suk runa mana chikniwashpanchikunaka yanapawaykanchisapami. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ñukata katiwashkaykichirayku ichara suk runa suk tipi chirik yakuta kushunkichiman. Allita willaykichi. Tata Dios chay upyachishuk runata suk premyunta kunka. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Chaymanta Jesuska willarkansapa: —Maykan runa ñukata kreyiwak mana alabanakuk runata uchallichiptin Tata Dioska sukaman kastiganka. Ashwan alli kanman payta atun rumi makita kunkanpi watashpa atun yakupi wishchukunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Chayrayku willaykichi: Ichara makikichiwan mana allita rurankichiman. Chay uchallichishuk makikita tipiychi ama ishkantin makikichiwan mana tukuyniyuk ninaman rinaykichipa. Ashwan alli kanman suk makikichillawan sieluman rinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ichara chakikichi pushashunkichiman mana allita ruranaykichipa. Chay uchallichishuk chakikichita tipiychi ama ishkantin chakikichiwan mana tukuyniyuk ninaman rinaykichipa. Ashwan alli kanman suk chakikichillawan sieluman rinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chaymanta ichara ñawikichiwan imatapish kaptin kawashpa uchallikunkichiman. Chay uchallichishuk ñawikichita surkuychi ama ishkantin ñawikichiwan mana tukuyniyuk ninaman rinaykichipa. Ashwan alli kanman suk ñawikichillawan sielupi yaykunaykichipa Tata Dioswan kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chay ninapi kurukuna mana wañunchu. Chay nina mana wañunchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chaypina yachachikuyllapi Jesuska katirkan: —Tukuy ñukata kreyiwak runakuna iden ninapishina sufrinankuna tiyan ama uchallikushpa kawsanankunapa. Tata Diosta rupachinan ofrendata kuptinchikuna alli kachichadu kanan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Alli kachika tukuy layapa alli. Allpayuk kachi manami kashkan kachi tukunkanachu. Kankuna alli kachishina kashpaykichi kushikuypuru sukwan sukwan yanapanakushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tukuy chaykunata yachachikushkankunawasha Kapernaum llaktamanta Judea partiman Jesus rirkan. Chaymanta Jordan yaku chimbaman rirkan. Chaypi aypa runakuna tantanakuptinkuna payka amañashkanshina yachachikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chaypina fariseo runakuna Jesusta sukaman pantachichinayarkansapa. Paykunaka ladunchashpankuna tapurkansapa: —¿Moisespa killkadunka rimanchu suk runa mana warminta munashpa wishchunanpa? ");
INSERT INTO qvsNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chaypina Jesuspish tapurkansapa: —¿Imatatí Moises killkadunpi willashunkichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Paykunaka aynirkansapa: —Moiseska willawarkanchisapa maykan runapish warminta wishchunayashpa awtoridarpi killkadu papelta chaskichishpa atipananta wishchuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chaypina Jesuska willarkansapa: —Kankuna sinchi shunku kaptikichi Moiseska almitishurkankichi warmikichita wishchunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tata Dios kay allpata rurashkanwasha warmita ullkuta rurarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chayrayku willarkan: “Tukuy ullku tatanta mamanta sakinka warminwan tantanakushpa kawsananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chashna tantanakushpankuna sukllallashina kankasapa.” Chashna Tata Dios willaptin suk ullku warminwan tantalla kawsashpankuna sukllallashina kawsankasapa. Manana ishkaynachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tata Dios chayta rimashkanrayku mana allichu niman suk runa warminta wishchunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chayta Jesus yachachikushkanwasha wasipi yaykushpankuna disipulunkunaka Jesusta yachachikushkanta kashkan tapurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Chaypina Jesuska paykunata willarkansapa: —Suk ullku warminta wishchushpa chikan warmiwan kasarashpa uchallikushpa kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Warmipish kusanta sakishpa chikan ullkuwan kasarashpa uchallikushpa kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chaymanta Jesusman aypa runakuna wambrankunata pushamurkansapa llankanankunapa. Chaypina Jesuspa disipulunkuna piñayashpa micharkansapa ama pushamunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chayta kawashpa Jesuska piñakushpa willarkansapa: —Ama chay wambrakunata michaychichu ñukaman shamunankunapa. Wambrakuna mana kreyinakushpa tatanpa munayninpi kawsansapa. Kankunapish wambrakunashina kawsashpaykichira Tata Diospa mandunpi yaykunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mash allita uyariwaychi. Kay wambrakunashina kankunapish Tata Diospa munananta ruranaykichi tiyan. Mana paypa munananta rurashpaykichika mana mandunpika yaykunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chashna Jesus willashpankuna tukuy chay wambrakunata markarkansapa. Chaymanta umankunapi llankashpa Tata Diosta roygarkan yanapanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chaymanta Jesus riykaptin suk runa kallpashpa laduncharkan. Ñawpakninpi kunkuriykushpa tapurkan: —Alli maestru ¿imata rurashpatí Tata Dioswan mana tukuyniyukta kawsayman? ");
INSERT INTO qvsNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chashna tapuptin Jesuska willarkan: —¿Imapatí alli kanaynita willawanki? Tata Diosllami alli. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tata Diospa kamachikunankunata allita yachanki. Kashna willawanchisapa: “Ama runamasikichita wañuchiychu. Ama chikan warmiwan uchallikushpa kawsaychu. Ama nimata suwaychu. Ama ni pita llullakushpa tumbaychu. Ama ni pita llullachiychu. Tataykita mamaykita kuyashpa kawsay.” ");
INSERT INTO qvsNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chashna Jesus willaptinna chay runaka willarkan: —Maestru, ñuka wayna kashkaynimantapachami chaykunata allita kasushpa kawsaykani. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaypina Jesuska kuyashpa kawarkan. Willarkan: —Sukllallanami illashunki ruranaykipa. Rillay tukuy laya tiyapushuknikita rantikumuy. Chay rantikushkayki chaninta mana nimayuk runakunata kuysapa. Chaypira sielupi tukuy layayuk kanki. Chaymanta shamuy ñukata katiway. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chayta uyarishpa chay runaka sukaman llakishpa wasinman kutirkan sukaman rikchak layayuk kashpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chay runa llakishpa riptinna Jesuska tukuy chay runakunata kawashpa disipulunkunata willarkansapa: —Chay laya kullkinllapi kreyinakuk runakuna mana atipankasapachu Tata Diospa mandunpi yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chayta uyarishpankuna disipulunkunaka sukaman almirarkansapa. Chaypina Jesuska kashkan willarkansapa: —Wambraynikuna, suk runa kullkinllapi kreyinakushpa mana atipanchu Tata Diospa mandunpi yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Suk kamellu animal suk aguja uchkunta mana atipanmanchu pasayta. Chashnami kullki likidu runa kullkinta ashwanta munashpa mana atipankachu Tata Diospa mandunpi yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chayta uyarishpa disipulunkuna ashwanta almirashpankuna tapunakurkansapa: —Chashna kaptinka ¿pikunatí atipanka Tata Diospa mandunpi yaykuyta? ");
INSERT INTO qvsNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaypina Jesuska chapashpankuna willarkansapa: —Manami ni suk runa atipanmanchu kikinllamanta yaykuyta. Tata Diosllami atipan runakunata mandunpi yaykuchiyta. Paymi tukuyta atipan rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chaypina Pedru willarkan: —Ñukaykuna tukuy tiyawakninikunata sakimushpaynikuna kanta katiykaykisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesuska willarkan: —Allita willaykichi. Kankuna katiwashpa ñuka salvakuk kanaynita yachachikushpa wasikichita, wawkikichita, panikichita, mamaykichita, tataykichita, wambraykichita, terrenuykichita sakishkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Chashna sakiptikichi Tata Diosmi kushunkichi sakishkaykichimanta ashwan aypa wasikichita, wawkikichita, panikichita, mamaykichita, wambraykichita, terrenuykichita. Kay allpapi sufrishpaykichipish wañushkaykichiwasha mana tukuyniyukta Tata Dioswan sielupi kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kunan kay tiempu aypa runakuna yuyanakunsapa ashwan alli kanankunata. Paykuna Tata Diospa mandunpi washeru kankasapa. Chaymanta kankuna mana munadu kashpaykichipish Tata Diospa mandunpi kamachikukkuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chaymanta Jerusalen llaktaman riykaptinkuna Jesuska disipulunkunamanta ñawpakta riykarkan. Paykunaka sukaman almirarkansapa Jesus Jerusalenman riptin. Manchakuypuru Jesusta katiykarkansapa. Chaypina Jesuska chunka ishkay disipulunkunallata chikanman pushashpankuna kashkan willarkansapa wañunanta: ");
INSERT INTO qvsNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Allita yachankichi Jerusalen llaktaman riykananchikunata. Chaypi suk runakuna saserdotekunapa kamachikukninkunaman Moisespa killkadunta yachachikuk runakunaman pushawankasapa rantikuwak. Chaypina ñuka sielumanta shamudu runa kaptinipish paykunaka tantanakushpa yuyankasapa wañuchiwanankunapa. Chaypina romano runakunapa makinpi kukuwankasapa wañuchiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Paykunaka sukaman asichiwashpankuna tukaychawankasapa makawankasapa wañuchiwankasapa. Chaymanta wañuchiwashkankunamanta kimsa diya ukun kashkan kawsamusha. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chaymanta Sebedeopa wambrankuna Santiagowan Juan Jesusta ladunchashpa willarkansapa: —Maestru, munanisapa mañanaynikunata rurapanaykipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Payka tapurkan: —¿Imatatí munankichi kankunapa ruranaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paykunaka willarkansapa: —Kan allimata tukuy layata kamachikushpayki tiyachiwaysapa sukta alli laduykipi sukta lluki laduykipi ñukaykunapish kamachikunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chaypina Jesuska aynirkansapa: —Kankunaka mana yachankichichu imatami mañawaykankichi nishpa. Ñukami tukuy layata sukaman padesinayni tiyan wañunaynikaman. Chashna padesishpa iden suk ayak likidutashina upyasha. Kankunaka manami atipankichimanchu ñukashina nanaykunata muchuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chashna willaptinkuna paykunaka aynirkansapa: —Ariya, atipashasapa muchuyta. Chaypina Jesuska willarkansapa: —Deverasmi ñukatashina kankunatapish sukaman padesichishunkichi. Ñukatashina chiknishushpaykichi wañuchishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tatayni Diosmi akllanka pikunami laduynipi tiyarinkasapa nishpa. Ñukaka manami ni pita willashachu laduynipi tiyarishpa kamachikunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chayta willaptinkuna chay chunka disipulunkuna uyarishpankuna Santiagota Juanta sukaman piñayarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chaypina piñayashkankunata kawashpa Jesuska kayashpankuna willarkansapa: —Kankunaka allita yachankichi tukuy llaktakunapi kamachikuk runakuna sukaman sinchita kamachikunankunata. Paykunaka mandunpi kawsak runakunata sukaman padesichinsapa kasunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kankunaka ama chay sinchi kamachikuk runakunashina kanayaychichu. Alli kamachikuk kanayashpaykichika tukuy runamasikichita sirvinaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chaymanta tukuy runakunamanta ashwan kamachikuk kanayashpaykichika iden rantidu runakunashina tukuyta yanapanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ñukapish sielumanta kay allpaman shamushkani tukuy runakunata sirvinaynipasapa. Mana shamushkanichu sirviwanankunapa. Shamushkani wañushpa aypa runakunata kastigumanta salvanaynipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chaymanta Jesus disipulunkunawan Jeriko llaktapi chayarkansapa. Chaymanta chay llaktamanta disipulunkunawan llukshiptinkuna aypa runakuna Jesusta katirkansapa. Chay ñanpi suk mana kawakuk runa Timeopa wambran Bartimeo tiyarishpa kullkita mañakuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chaypina chay runaka Nasaretmanta Jesus pasaykananta uyarishpa sinchita rimashpa Jesusta willarkan: —¡Jesus, ñawpa Davidpa miraknin, ñukatapish llakichiway! ");
INSERT INTO qvsNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chayta uyarishpankuna chay aypa runakuna michashpankuna willarkansapa upallayananpa. Chaypina ashwan sinchita willarkan: —¡Jesus, ñawpa Davidpa miraknin, ñukatapish llakichiway! ");
INSERT INTO qvsNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaypina Jesuska riykashkanmanta shayarishpa willarkansapa: —Chay runata kayaychi. Chashna willaptin chay mana kawakuk runata kayashpankuna willarkansapa: —Ama llakiychu. Atarimuy. Jesus kayashunki. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chayta uyarishpa chay mana kawakuk runaka kapanta wishchukushpa brinkashpa Jesusta laduncharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chaypina Jesuska tapurkan: —¿Imapití munanki yanapanaynipa? Chaypina chay runaka willarkan: —Maestru, ñawinita alliyachipay kashkan kawakunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chaypina Jesuska chay runata willarkan: —Kan allita kreyiwashkaykirayku alliyachiyki. Allita kawakushpana rillay. Jesus chayta willaptinlla chay runaka kashkan kawakurkan. Chay ratumantapacha Jesusta katirkan chay ñanta riptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalen llaktaman Jesus riykashpa Olivos urkupi chayarkan. Chay urku karkan Betfage Betania llaktakunapa ladunkunapi. Chaypi chayaptinkuna Jesuska ishkay disipulunkunata kacharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kachashpankuna willarkansapa: —Rillaychi chay kawananchi llaktaman. Chaypi chayashpaykichi suk watadu burruta tarinkichi. Chay burrutaka manara ni pi montanrachu. Chayta paskashpaykichi pushamuychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maykan tapushuptikichi: Imapati paskankichi nishpa willaychi: “Señornini munan montananpa. Suk ratukaman kutichimushkaykisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chaypina disipulunkuna rishpankuna suk kallipi suk punku ladunpi watadu burruta tarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chay burruta paskaykaptinkuna kawashpa suk runakuna tapurkansapa: —¿Imatatí ruraykankichi? ¿Imapatí chay burruta paskaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Paykunaka Jesus willashkantashina aynirkansapa. Chaypina almitirkansapa pushanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chaypina Jesusman disipulukuna chay burruta pusharkansapa. Burrupa sawanpi llachapankunata churarkansapa Jesus montananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Chaymanta Jesus chay burrupi Jerusalenman riykaptin aypa runakuna chay rinan ñanpi sawa llachapankunata mantarkansapa. Sukkuna chakrankunamanta aypa pankayuk ramakunata apamushpankuna ñanpi mantarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chaypina Jesuspa ñawpakninta rik runakuna washanta katik runakunapish sukaman kushikushpankuna sinchita willarkansapa: —¡Akuychi kuyaypachi Tata Diospa shutinpi shamuk runata! ");
INSERT INTO qvsNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kushikuypachi Jesus ñawpa alli kamachikuk Davidshina sinchi kamachikuk kaptin. ¡Akuychi altu sielupi kawsak Tata Diosta sukaman kuyaypachi! ");
INSERT INTO qvsNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chaymanta Jerusalenpi yaykushpa Jesuska Tata Diospa wasinman rirkan. Chaypi tukuy layata kawashpa disipulunkunawan rirkan Betania llaktaman tardina kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chaymanta kayantin Betaniamanta Jerusalen llaktaman kutishpa Jesuska sukaman yarkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chaypina karullamanta pankasapa igo kaspita kawarkan. Chayta laduncharkan kawak wayuyukchu manachu nishpa. Chay kaspita tarirkan pankasapallata mana niman suk wayuyukta manara wayuchakunan tiempu kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chaypina Jesuska chay igo kaspita willarkan: —Kunanmantapacha manana kutin ni pi wayuykita mikunkanachu. Chayta willaptin tukuy disipulunkunaka uyarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalenpi chayashpankuna Tata Diospa wasinpi Jesuska yaykurkan. Chaypi kawarkan rantiykak rantikuykak runakunata. Tukuy paykunata karkurkansapa. Chaymanta kullkita kambiakuk runakunapa mesankunata tikrachipurkansapa. Urpaykuna rantikuk runakunapa bankunkunata tikrachipurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mana munarkanchu Tata Diospa wasinpi ni pi imatapish apashpa purinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chaypina tukuy chay runakunata yachachishpa willarkansapa: —Tata Dioska killkadunpi willawanchi: “Tukuy llaktakunamanta runakuna shamushpankuna rimankasapa kay wasini oranankuna wasi kananta.” Tata Dios chayta willawaptinchikunapish kankuna paypa wasinta ruraykankichi suwakunaykichi wasita. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chayta uyarishpankuna saserdotekunapa kamachikukninkunawan Moisespa killkadunta yachachikukkuna kallarirkansapa yuyaykuyta imashnami Jesusta wañuchinkasapa nishpa. Chashna wañuchinayashpankunapish manchakurkansapa apiyta tukuy runakuna Jesuspa yachachikunanta sukaman almiraptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Chaymanta tutayaptinna Jesuska disipulunkunawan Jerusalenmanta llukshirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kayantin tutapacha Jesuska disipulunkunawan chay igo kaspi ladunta pasashpankuna kawarkansapa sapintinta chakidutana. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chayta kawashpa Pedru yuyarkan Jesus mana wayunta tarishpa rimashkanta. Chayrayku willarkan: —Maestru, kayna willashkanki kay igo kaspita amana kutin wayuchakunanpa. Mash kaway. Ñami chakishkana. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesuska willarkansapa: —Tukuy shunku Tata Diosta kreyiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Allita willaykichi. Kankunapish Tata Diosta allita kreyishpa atipankichiman iden ñukashina rurayta. Kay urkuta willankichiman: “Kaymanta suchushpayki rillay atun yakupi sumik.” Tukuy shunku Tata Diosta kreyishpa chayta willaptikichi kay urku suchunman. Ama shunkuykichipi yuyaychichu suchunkachu manachu nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tukuy shunku kreyikushpa Tata Diosta mañashpaykichi allita kreyiychi chaskinaykichita. Chaypira Tata Dioska tukuy mañashkaykichita kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chaymanta Tata Dioswan parlaykashpaykichi runamasikichi rabyachishushkaykichita yuyashpa perdonaychi sielupi kawsak Tataykichi kankunatapish uchaykichimanta perdonashunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kankuna mana perdonaptikichika Tata Diospish manami perdonashunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chayta yachachikushkanwasha Jerusalen llaktaman Jesuska disipulunkunawan kutirkan. Chaypina Tata Diospa wasinpi puriykaptin saserdotekunapa kamachikukninkunawan Moisespa killkadunta yachachikukkunawan judiyukunapa ansianunkuna laduncharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chaypina Jesusta tapurkansapa: —¿Pití kanki chashna yachachikunaykipa? ¿Pití kachamushushka Tata Diospa wasinmanta chay rantikuk runakunata karkunaykipa? ");
INSERT INTO qvsNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Chashna tapuptinkuna Jesuska willarkansapa: —Ñukapish kankunata tapuykichi. Ayniwaptikichika willashkaykichi pimi kachamuwashka nishpa. May willawaychi ¿pití Juantaka kachamurkan runakunata bawtisanankunapa? ¿Tata Dioschu kachamurkan? ¿Suk runachu kachamurkan? May ayniwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chashna Jesus tapuptinkuna chay runakunaka sukwan sukwan ayninakushpa willanakurkansapa: —Ayniptinchikuna Tata Dios Juanta kachamushkanta payka willawashunchisapa: “Tata Dios kachamushka kaptin ¿imapatí mana payta kasushkankichi?” ");
INSERT INTO qvsNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Chaymanta ayniptinchikuna runakuna kachamushkanta tukuy kay runakuna sukaman piñayawashunchisapa. Paykunaka kreyinsapa Tata Dios kachamuptin yachachikushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chashna willanakushpankuna Jesusta willarkansapa: —Mana yachanisapachu pimi Juantaka kachamushka nishpa. Chaypina Jesuska willarkansapa: —Ñukapish manami willaykichichu pimi kachamuwashka tukuy kaykunata ruranaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chaymanta Jesuska kallarirkan ejemplukunata parlachikushpa yachachikuyta. Willarkansapa: —Suk runa chakranpi uvakunata tarpuchishkanwasha wertanta rurachirkan. Chaymanta suk manllayba atun batanta churarkan chaypi uva wayukunapa illinta kapinankunapa. Chaymanta suk manllayba altu wasita rurachirkan altuyninmanta suk runa kuydananpa. Tukuy chaykunata rurashpana suk runakunawan paktanakurkansapa uvata pallashpankuna paywan patumanakunankunapa. Chashna paktanakushpankuna chay runaka rirkan suk karu llaktaman. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chaymanta pallana tiempu chayamuptin chay runaka suk wiwachunta kacharkan patuma palladu uvata chaskik. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Paykunaka chay wiwachuta apishpankuna makarkansapa. Mana nimata kushpankuna kacharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chaypina chay chakrayuk runaka suk wiwachunta kacharkan. Chaypina chay trabajadorkuna rabyakushpa umanpi waktashpa llikipurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chaypina chay chakrayuk runa kashkan suk wiwachunta kachaptin paytaka wañuchirkansapa. Chaymanta aypa wiwachunkunata kacharkan. Sukkunata makarkansapa sukkunata wañuchirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Chay chakrayuk runapa tiyarkanlla suk runa kachananpa. Paymi karkan sukaman kuyashkan wambran. Paytana kachashpa yuyarkan: “Kay wambraynita manchashpankuna kasunkasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chaypina chay chakra kuydak runakuna patronpa wambranta kawashpankuna willanakurkansapa: “Mash kawaychi. Chay shamuykak runaka chakrayuk runapa wambranmi. Tatan wañuptin kay chakra paypa kiparinan tiyan. Kunanlla akuychi wañuchiypachi kay uva chakra ñukanchikunapa kiparinanpa.” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chashna willanakushpankuna chay runapa wambranta apirkansapa. Chaymanta wañuchishpankuna uva chakra washaman wishchurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chaypina Jesuska tapurkansapa: —¿Imatatí yuyankichi? Chay chakrayuk runaka ¿imatatí ruranka? Chay chakranman rishpa tukuy kuydak runakunata wañuchinka. Chaymanta chikan runakunata chakranta kunan tiyan kuydanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kankuna ¿manachu Tata Diospa killkadunta leyishkankichi? Chay killkadunpi riman: “Suk runa wasinta rumimanta ruraptin trabajadorninkuna suk alli sinchi rumita wishchurkansapa mana alli nishpa. Chashna wishchukuptinkunapish chay wasichakuk runaka chay wishchudu rumita wasi kallarinanpi churarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chashna Tata Dios ruraptin sukaman almiranchisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chashna Jesus rimaptin chay chiknik runakuna allita entiendirkansapa paykunapa rimashpa chay ejempluta yachachikushkanta. Chayrayku apinayarkansapa. Apiyta munashpapish mana apirkansapachu runakunata manchashpankuna. Chayrayku Jesusta sakishpankuna kutirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaypina chay chiknik runakunaka sukaman Jesusta chatayta munashpankuna suk fariseokunawan Herodespa partidaryunkunata kacharkansapa pantachichik mana allita rimananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaypina chay kachadu runakunaka allipi tukushpankuna Jesusta willarkansapa: —Maestru, ñukaykuna yachanisapa mana llullakushpa allimallata yachachikunaykita. Tukuy runakunata yachachinki Tata Diospa munananta rurashpa kawsanankunapa. Kanmi tukuy runakunapa yuyayninkunata allita riksinki. Chayrayku ni pita manchashpa yachachikunki. Kunanka willawaysapa: Roma llaktapi sinchi kamachikuk kullkinikunata mañawaptinkuna ¿allichu manachu pagarakunaynikunapa? ¿Pagarakushasapachu manachu? ");
INSERT INTO qvsNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Chashna tapuptinkuna Jesuska allita yacharkan allipi tukushpankuna pantachichinayanankunata. Chaypina willarkansapa: —¿Imapatí pantachichiwanayaykankichi? Apamuychi suk kullkita kawanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chay runakuna kullkita kawachiptinkuna Jesuska tapurkansapa: —¿Pipa uyantatí pipa shutintatí killkaduta kawankichi? Paykunaka aynirkansapa: —Roma llaktapi kamachikuk Sesarpa uyanta shutinta kawanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chashna ayniptinkuna Jesuska willarkansapa: —Chay kamachikuk Sesarpa kaktaka payta kuychi. Chaymanta tukuy laya Tata Diospa kaktaka Tata Diosllata kuychi. Jesus allimata ayniptinkuna chay pantachichinayak runakunaka sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaymanta saduseo runakuna rirkansapa Jesuswan parlak. Saduseokunaka yachachikuksapa mana ni pi wañushkanmanta kawsamunanta. Chayrayku paykunaka Jesusta willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestru, ñawpa yachachikuk Moiseska yachachikurkan: “Suk kasadu ullku manara ni suk wambrayuk kashpa wañuptin wawkin viyuda kuñadawan kasaranan tiyan. Chaypina chay warmi ullku wambrata wawayaptin wañudupa wambranshina kanan tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mash uyariway. Tiyarkan kanchis wawkipura. Chaypina mayor wawkin kasararkan. Chay ullku manara niman suk wambrayuk kashpa wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chaymanta chay ishkaynin wawkin viyuda kuñadanwan kasararkan. Paypish wañurkan mana niman suk wambrayuk kashpa. Chaypina chay kimsaynin wawkin viyuda kuñadanwan kasararkan. Paypish wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tukuy chay wawkinkuna sukmanta sukmanta chay viyuda kuñadanllawan kasararkansapa. Kanchisnintin mana niman suk wambrayuklla wañurkansapa. Chaymanta chay warmipish wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kunanka willawaysapa. Wañudu runakuna kawsamuptinkuna chay kanchis kusanmanta ¿maykan kakpati kanman warminka? Tukuy paykuna chay warmiwan kasaradu karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chashna tapuptinkuna Jesuska willarkansapa: —Kankunaka Tata Diospa killkadunta mana entiendishpa kikikichilla llullachinakunkichi. Manami yachankichichu Tata Dios sukaman atipak kashpa wañudukunata kawsachimunanta. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tata Dios wañudu runakunata kawsachimushkanwasha mana niman suk ullku niman suk warmi kasarankasapanachu. Sielupi kawsak angelkunashina kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Manachu leyishkankichi Tata Diospa killkadunta? Chaypi riman wañudukuna kawsamunankunata. Chay ramasapa taksha kaspi rawraykak ukumanta Tata Dios Moisesta willarkan: “Ñuka Abrahampa Isakpa Jakobopa Tata Diosninmi kani.” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chashna Tata Dios rimaptin yachanchisapa chay ñawpa awilunchikuna wañushkankunamanta kawsamushpankuna Tata Dioswan kawsaykanankunata. Tata Dioska kawsak runakunallapa Diosninmi. Chayrayku kankunaka sukaman pantakudu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chaymanta Moisespa killkadunta yachachikuk runa Jesus saduseokunata allita aynishkanta uyarishpa tapurkan: —Maestru, Tata Diospa kamachikunankunamanta ¿maykantí ashwan alli kasunaynikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chayta tapuptin Jesuska willarkan: —Tata Diospa kamachikunankunamanta ashwan alli kamachikunan riman: “Israel runakuna, uyariychi: Kamachiwakninchi Tata Dios sukllallami. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tukuy shunku kamachikuk Tata Diosnikita kuyay. Tukuy layata allita rurashpa sukaman munashpa allita yuyaykushpa payta kuyanayki tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chaymanta chay ishkaynin kamachikunan riman: “Kikiki kuyanakukshina tukuy runamasikita kuyashpa kawsay.” Kay ishkay kamachikunankuna tukuy kamachikunankunamanta ashwan allima. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chashna willaptin chay yachachikuk runaka willarkan: —Maestru, allitami rimashkanki. Mana llullakushpa rimanki sukllalla Tata Dios tiyananta. Manami paymanta chikan dios tiyanchu. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tata Diosta kuyashpa animalkunata wañuchishpa altarpi rupachishpa payta kushichinchisapa. Chaymanta ashwan allita Tata Diosta kushichinchisapa tukuy shunku payta kuyashpa sukaman munashpa tukuy layata allita rurashpa allita yuyaykushpa. Tata Diosta ashwanta kushichinchisapa kikinchi kuyanakukshina runamasinchikunata kuyashpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chay yachachikuk runa allita kuskanpi aynishkanta uyarishpa Jesuska willarkan: —Tipillami illashunki Tata Diospa mandunpi yaykunaykipa. Chashna Jesus willaptin manana ni pi animukurkannachu nimata tapuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chaymanta Jesuska Tata Diospa wasinpi yachachikuykashpa tapurkansapa: —¿Imapatí Tata Diospa rimananta yachachikuk runakuna rimansapa Tata Diosmanta shamuk salvakuk runa Davidpa miraknin kananta? ");
INSERT INTO qvsNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tata Diospa Espiritun yanapaptin David rimarkan: “Tata Dioska kamachiwak runata willarkan: ‘Alli laduynipi ñukawan tantalla tiyariy kamachikunaykipa tukuy chiknishuk runakunata saru saru ruranaynikaman kanta kasushunankunapa.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Chay killkadu rimananpi Davidka rimarkan Tata Diosmanta shamuk salvakuk runa paypa sinchi kamachikuknin kananta. Kikin Davidpa kamachikuknin kaptinka ¿imashnatí paypa miraknin kanman? Chashna Jesus yachachikuptin aypa runakuna sukaman kushikushpa uyarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus yachachikuykashpa willarkansapa: —Ama munaychichu Moisespa killkadunta yachachikuk runakunata uyariyta. Paykunaka suni llachapankunata churakushpankuna plasakunapi purinsapa. Sukaman munansapa tukuy runakuna manchashpankuna rimachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chaymanta tantanakunankuna wasikunapi ashwan alli bankukunapi tiyarinsapa. Suk fiestaman rishpankuna ashwan alli bankukunapi tiyarishpankuna mikunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Paykunaka alli rurakshina yuyanakushpankunapish viyuda warmikunapa wasinkunata kichunsapa. Chay mana allita ruraykashpa sukaman sunita Tata Dioswan parlansapa runakuna rimanankunapa alli rurak kanankunata. Llullachikuk kaptinkuna Tata Dioska paykunata ashwan sinchita kastiganankuna tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Chaymanta suk diya Tata Diospa wasinpi ofrendata churanankuna kajon ladunpi Jesus tiyaridu karkan. Chaypi kawarkan aypa runakuna ofrendankunata churaykaptinkuna. Aypa tukuy layayuk runakunapish aypa kullkita churaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chaypina mana nimayuk viyuda warmi chayarkan. Payka ishkay kullkisillunkunata mana yaka chaniyukta churarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chayta kawashpa Jesuska disipulunkunata kayashpa willarkansapa: —Ñuka allita willaykichi. Kay viyuda warmika mana nimayuk kaykashpa chay aypa kullkiyuk runakunamanta ashwan alli ofrendata kukushka. ");
INSERT INTO qvsNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chay aypa kullkiyuk runakunaka puchushkan kullkinta Tata Diosta kunsapa. Chay mana nimayuk warmika tukuy tiyapushkanta Tata Diosta kuyashpa kushka. Chayrayku payka Tata Diosta ashwanta kushichin. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesuska Tata Diospa wasinmanta llukshiykaptin suk disipulun willarkan: —Maestru, mash kaway kay allima rumikunawan ruradu Tata Diospa wasinta. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chashna kawachiptin Jesuska aynirkan: —¿Allitachu kawaykanki kay allima ruradu manllayba wasita? Suk tiempukaman chiknik runakuna tukuy kay rumimanta ruradu wasita urmachinkasapa. Mana niman suk rumi sawapura kiparinkanachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaymanta Olivos urkuman rishpankuna Jesuska chaypi tiyarirkan. Chay urkuka Tata Diospa wasinmanta kuskanpi karkan. Chaypina Pedruwan Jakobowan Juanwan Andres chikanman rishpa Jesusta tapurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Aykapití Tata Diospa wasinta urmachinkasapa? ¿Imakunata kawashpatí yachaymansapa chay rimashkaykita ruranankunata? ");
INSERT INTO qvsNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chaypina Jesuska aynirkansapa: —Kuydanakuychi ama ni pi llullachishunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Manara kutimuptinira aypa runakuna shamunkasapa ñukapi tukushpa willashuknikichi: “Ñukami Tata Diosmanta shamudu salvakuk runa kani.” Chashna rimashpankuna aypa runakunata llullachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Runakuna chikninakushpankuna kaypi chaypi makanakushpa wañuchinakunkasapa. Chayta yachashpaykichi ama manchakuychichu. Wañuchinakushpa kawsaptinkunapish manara tukunan tiempurachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Suk partipi kawsak runakuna chikan llaktapi kawsakkunawan sukaman chikninakushpa makanakushpa wañuchinakunkasapa. Aypa llaktakunapi allpa sinchita kuyunka. Chaymanta kaypi chaypi sinchi yarkay tiyanka. Chashna runakuna chaykunawan sukaman sufrishpankuna ashwantara sufrinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kikikichi kuydanakuychi. Chay tiempu chiknishuk runakuna awtoridarkunapi chatashunkichi. Tantanakunankuna wasikunapi makashunkichi. Ñukata kreyiwashpa kawsashkaykichirayku awtoridarkunapi llaktakunapa ashwan sinchi kamachikukkunapi chatashuk pushashunkichi. Chaypina chay awtoridarkunata atipankichi willayta ñuka salvakuk kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manara kay allpa kulluptin tukuy llaktakunapi yachachikunaykichi tiyan ñuka salvakuk kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chay runakuna awtoridarkunaman chatashuk pushashuptikichi ama manchakushpa yuyaychichu imatami willankichi nishpa. Chashna oras Tata Dios yanapashunkichi kuskata rimanaykichipa. Manami kikikichimantachu rimankichi. Tata Diospa Espiritun yanapashunkichi allita rimanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Chaymanta chay tiempu chay runakuna wawkinkunata chiknishpa awtoridarkunapi chatankasapa wañuchinankunapa. Suk runakuna wambrankunata chiknishpankuna chatankasapa. Sukkuna tatanta mamanta chiknishpankuna wañuchinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tukuy pi kankunatapish chiknishunkichi ñukata kreyiwashkaykichirayku. Kankuna wañunaykichi diyakaman allita kreyiwashpa kawsaptikichi Tata Dioska kastigumanta salvashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Chaymanta Jesuska willarkansapa: —Tata Diospa wasinpi suk runa sukaman millanapa layata ruranka. Chayta ruraptin kawashpaykichi Judeapi kawsashpaykichi urkukunaman nitikuychi. Kayta leyishpa allita entiendiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasikichi altuyninpi kashpaykichika chayllamanta nitikuychi. Ama wasikichipi yaykuychichu nima tiyapushuknikichita surkuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chashna oras chakraykichipi trabajaykashpaykichika chayllamanta nitikuychi. Ama wasikichiman kutiychichu nima llachapaykichita surkuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chay sinchi llakina tiempu okupada warmikuna ñuñuchikuk warmikuna sukaman padesinkasapa. Chayrayku paykunata sukaman llakichini. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kankunaka Tata Diosta roygaychi ama tamya tiempu nima samana diya nitikunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay tiempu sinchi llakina tiyaptin tukuy runakuna sukaman padesinkasapa. Tata Dios kay allpata rurashkanmantapacha manara chay laya llakina tiempu tiyashkanrachu. Nima chay tiempu washan chay laya llakina tiyankachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tata Dioska tukuy akllashkan runakunata kuyashkanrayku chay llakina tiemputa tukuchanka. Mana utka tukuchaptinka tukuy runakuna wañunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chaymanta Jesuska yachachikuyllapi katirkan: —Chay tiempu ichara suk runakuna willashunkichiman: “Mash kawaychi. Kaypinami chaypinami Tata Diosmanta shamudu salvakuk runa.” Chashna willashuptinkuna ama kreyiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aypa runakuna llullachikushpa rimankasapa Tata Diosmanta shamudu salvakuk runakuna kanankunata. Sukkuna llullachikushpa rimankasapa Tata Dios kachamushkanta yachachikunankunapa. Paykunaka rikchak laya almirana milagrukunata rurankasapa. Chayta rurashpankuna Tata Dios akllashkankunatapish llullachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chay runakuna manara shamuptinkunara ñami willashkaykichina ama paykunata kreyinaykichipa. Chayrayku kuydanakushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesuska yachachikuyllapi katirkan: —Chay sinchi sufrina tiempu tukuptinna inti tutayanka. Killa manana lusichikunkanachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Luserukuna sielumanta urmamunkasapa. Sielupi llipyakkuna kuyunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaypina tukuy pi ñukata sielumanta shamudu runata kawawankasapa puyukuna ukunpi shamuptini. Sukaman llipyashpa shamuptini kawawashpankuna yachankasapa tukuy layata rurayta atipak kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chaymanta angelninikunata kachashasapa allpapi sielupi kuchun mañankunamanta tukuy aklladuynikunata tantanachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Suk igo kaspita kawashpa yachakuychi. Igo ramankuna velachakushpa aypata pankayaptin yachankichi veranu tiempu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chashnashina tukuy kay willashkaynita kawashpaykichi yachankichi ñuka utka kutimunaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Allita willaykichi: Manarapish kunan kawsak runakuna wañushpankunara tukuy kay willashkaynita kawankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tukuy kay allpa sielukunapish kullunankuna tiyan. Kulluptinkunapish rimashkayni manami tukunkachu. Tukuy rimashkaynita rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tata Diosllami yachan imay diyami imay orami kutimusha nishpa. Mana ni suk runa nima sielupi kawsak angelkuna yachansapachu. Ñuka Tata Diospa wambran kashpaynipish mana yachanichu aykapimi kutimusha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kankuna mana yachankichichu imay orami shamusha nishpa. Chayrayku allita yuyaykushpa prontanakushpa shuyawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Suk runapa ejemplunta uyariychi. Chay runaka karu llaktaman rinanpa wiwachunkunata kayashpa willan wasinta allita kuydapunankunapa. Sukta sukta willan imatami rurankasapa nishpa. Chaymanta sukta willan punkuta allita kuydananpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ñuka iden chay wasiyuk runa kashpayni kankunata sakiykichi. Chayrayku uyari uyari shuyawaychi. Mana yachankichichu imay diyami kutimusha nishpa. Ichara tutayaykaptin shamusha. Ichara chawpi tutata ichara gallo kantanan oras ichara diyapina kutimusha. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tukuy kayta willaykichi shamushpayni ama tarimunaynipa mana allita ruraykaptikichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kankunata willanaynita tukuy kreyiwak runakunatapish willaykani: Tukuy tiempu alli prontanakudu shuyawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chay tiempu Paskua fiestapa ishkay diyallana illarkan. Tukuy wata Paskua fiesta ukunpi judiyu runakuna amañaksapa mana levadurayuk pankunata mikuyta. Chaypina saserdotekunapa kamachikukninkunawan Moisespa killkadunta yachachikukkuna yuyaykurkansapa llullachishpa Jesusta apishpa wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sukkuna rimarkansapa: —Ama Paskua fiesta ukun wañuchichiypachichu fiestaman shamudu runakuna ama turbakushpa piñayawananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesuska Betania llaktaman rishpa suk runa Simonpa wasinpi yaykurkan. Simonka lasaru unkuymanta alliyadu karkan. Chaypina Jesus mesapi mikuykaptin suk warmi yaykurkan. Chay warmika apamurkan yurak rumimanta ruradu botellapi aypa chaniyuk mishkilla asnak wirata. Chay wira nardo shuti kaspimanta ruradu karkan. Chay warmika chay botellata pakishpa chay mishkilla asnak wirata Jesuspa umanpi icharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chayta kawashpa chaypi kak runakunamanta sukkuna piñakushpankuna willanakurkansapa: —¿Imapatí chay mishkilla asnak wirata usuchishka? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ashwan alli kanman karkan kimsa pachak kullkipi rantikushpa chay chaninta mana nimayuk runakunata kunanpa. Chashna rimashpa chay warmitaka washancharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus washanchashkankunata uyarishpa Jesus willarkansapa: —¿Imapatí piñayashpa kay warmitaka michankichi? Kay wirata umaynipi ichashpa allitami rurashka. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mana nimayuk runakunata tukuy maytapish rishpa tarinkichi munashkaykichi ora yanapanaykichipa. Ñukataka manami tukuy tiempunachu kawawankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kay warmika atipashkanta rurashka. Kay mishkilla asnak wirawanka ñami armachiwashkana wañuptini pampawanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Allita willaykichi: Tukuy maypi runakuna ñuka salvakuk kanaynita yachachikushpankuna kay warmi kuyawashpa rurashkantapish parlachikunkasapa. Chashna modomanta tukuy pi paytaka yuyankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesuspa chunka ishkay disipulunkunamanta suk karkan Judas Iskariote. Payka Jesusta rantikunayashpa rirkan saserdote awtoridarkunawan parlak. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Paykunaka Judas rantikunayananta yachashpankuna sukaman kushikushpa willarkansapa kullkita kunankunapa. Chay oramantapacha Judaska sukaman Jesusta apichichinayarkan. Maskarkan maypimi apichichinka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chay Paskua fiesta kallarinan diya tukuy judiyu runakuna amañanisapa mana nima levadurayuk pankunata mikuyta. Chaymanta Tata Diosta kuyashpaynikuna amañanisapa oveja wawanta wañuchiyta. Chay diyana disipulunkuna Jesusta tapurkansapa: —¿Maypití munanki rinaynikunapa Paskua fiesta mikunanchikunata rurak? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chashna tapuptinkuna Jesuska ishkay disipulunkunata willarkansapa: —Rillaychi llaktaman. Chaypi tinkunakunkichi yaku puyñuta apaykak ullkuwan. Payta katiychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chay runa suk wasipi yaykuptin chay wasiyuk runata willaychi: “Maestruynikuna yachanayan maypishi kay Paskua fiesta disipulunkunawan mikunkasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chashna chay wasiyuk runata willaptikichi payka wasi altuyninpi allichadu kuartuta kawachishunkichi. Chaypi mikunanchikunata ruraychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chashna Jesus willaptinkuna paykunaka llaktaman rirkansapa. Chaypina Jesus willashkankunatashina tukuyta tarishpankuna Paskua fiesta mikunata rurarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chaymanta tutayaptinna Jesuska chunka ishkay disipulunkunawan chaypi chayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chay mesapi tantalla mikuykashpankuna Jesus willarkansapa: —Allita willaykichi. Ñukawan tantalla mikuykankichi. Kankunamanta sukmi chikniwak runakunapi rantikuwanka. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chashna willaptinkuna chay disipulunkuna sukaman llakishpankuna sukmanta sukmanta Jesusta tapurkansapa: —¿Ñukachu rantikushkayki? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chaypina Jesuska aynirkansapa: —Chunka ishkay kankunamanta ñukawan tantalla kay kallanapi panninta ñuyuchik runami rantikuwanka. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tata Diospa killkadunpi riman runakuna wañuchiwanankunata. Chayrayku ñuka sielumanta shamudu runa kashpayni wañusha. Wañunaynipa kaptinpish chay rantikuwak runata sukaman llakichini. Ashwan alli kanman karkan ama nasinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chaymanta mikuykashpankuna Jesuska suk panta apishpa Tata Diosta agradesirkan. Chay panta pakishpa disipulunkunata kushpankuna willarkansapa: —Kay panta mikuychi. Kay panka kuerpuynimi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaymanta Jesus suk vasu vinuta apishpa Tata Diosta agradesirkan. Chayta chaskichiptinkuna disipulunkuna upyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chaypina Jesuska willarkansapa: —Kaymi yawarnini. Kaywanmi mushuk paktuta rurani. Wañushpayni yawarnini ichakuptin Tata Dioska aypa runakunata uchankunamanta perdonankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Allita willaykichi. Uvamanta ruradu vinuta mana kutin upyashanachu Tatayni Diospa mandunpi kankunawan tantalla mushuk vinuta upyanaynikaman. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chaymanta Tata Diosta kuyashpankuna salmo kantukunata kantarkansapa. Kantashkankunawasha rirkansapa Olivo urkuman. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chaypina Jesuska disipulunkunata willarkansapa: —Tata Diospa rimananpi willawanchisapa: “Ovejakuna kuydak runata wañuchisha. Chayrayku tukuy ovejankuna chayta chayta kallpankasapa.” Chay killkadupi rimashkanshina kunan tuta tukuy kankuna mana kreyiwakshina tukushpa sakiwankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Chaymanta ñuka wañushkaynimanta kashkan kawsamushpayni Galilea partiman kankunamanta ñawpakta risha. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chaypina Pedruka Jesusta willarkan: —Tukuy katishukmasinikuna turbakushpa sakishuptinkunapish ñuka mana nima layapi sakishkaykichu. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chashna Pedru willaptinna Jesuska willarkan: —Allita willayki. Kunan tutami manarapish gallo ishkay kuti kantaptin kimsa kuti rimanki mana riksiwanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Chaypina Pedruka sinchita willarkan: —Kanwan tantalla wañunaynipish kaptin manami nima layapi rimashachu mana kanta riksinaynita. Chashna Pedru willaptin tukuy disipulunkunapish idenllata rimarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaymanta Getsemani wertaman rirkansapa. Chaypi chayashpankuna Jesuska disipulunkunata willarkansapa: —Tatayni Dioswan parlak rinaynikaman kaypi tiyarishpa shuyawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chashna willashpa suk chikan laduman Pedruwan Santiagowan Juanta pusharkansapa. Chaypina sukaman turbakushpa sinchita llakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Paykunata willarkansapa: —Sukaman llakishpayni wañukshina mallinakuni. Kankuna kayllapi kiparishpa rikchadulla shuyawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chaypina urasilluman Jesuska rirkan. Chaypi kumurayarkan urkun allpapi takakunankaman. Tatan Diosta roygarkan pay munaptin ama chay sinchi nanayta mallinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tatan Diosta roygarkan: —A, Tatayni, kan tukuy layata atipanki rurayta. Munashpaykika salvaway ama sukaman padesinaynipa. Padesishpaynipish munani kanpa munanaykillata rurayta. Manami munanichu ñukapa munanaynita rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chayta Tata Diosta willashkanwasha Jesuska chay kimsa disipulunkunapa ladunman kutirkan. Puñuykaptinkuna tarishpankuna Pedruta willarkan: —Simon, ¿puñuykankichu? ¿Manachu niman suk orata mana puñushpa atipashkanki Tata Dioswan parlayta? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mana nima puñushpa Tata Diosta mañaychi supay ama uchallichishunaykichipa. Kankunaka sukaman munankichi Tata Diosta mañayta. Chaykamanka utka shaykunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chashna willashpankuna Jesuska kashkan rirkan Tatan Diosta roygashkan layallata roygak. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chaymanta chay kimsa disipulunkunaman kutishpa kashkan tarirkansapa sukaman puñuykaptinkuna. Paykunaka puñuyta mana muchurkansapachu. Chayrayku mana yacharkansapachu imatami ayninkasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Chaymanta Jesus kimsaynin kuti puñuduta tarishpankuna willarkansapa: —¿Kunankamanchu puñuykashpa samaykankichi? Chaylla kachun. Ñami orayni chayamushkana ñukata sielumanta shamudu runata uchasapa runakunapi apichichiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Atarimuychi. Akuychina. Ñami shamuykanna chay rantikuwak runaka. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus chayta rimaykaptinllara disipulun Judaska aypa runakunata pushashpankuna chayarkan. Paykuna kaspikunawan ishkantin ladupi filuyuk machetikunata apashpa rirkansapa Jesusta pushak. Rirkansapa kamachikuk saserdotekunawan Moisespa kamachikunankunata yachachikuk runakunawan judiyukunapa ansianunkuna kachaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judaska pusharkan chay runakunata allita yachachishpankuna: “Suk runata muchaptini yachankichi pay kananta. Paytami allita apishpa pushankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chashna Judas paykunata yachachishpa Jesusta ladunchashpa willarkan: —¡Maestru! Chashna willashpa mucharkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chaypina chay runakuna Jesustaka apirkansapa pushanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Chayta kawashpa Jesuswan purik runa machetinta apishpa suk runapa rinrinta tipipurkan. Chay runa karkan sinchi kamachikuk saserdotepa wiwachun. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chaypina Jesuska chay pushanayak runakunata tapurkansapa: —¿Imapatí kaspikunata machetikunata apamushkankichi apiwanaykichipa? ¿Ariya ñukachu suwa wañuchikuk runa kani? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tukuy diya Tata Diospa wasinpi yachachikuykaptini mana chaypi apiwashkankichichu. Ñawpa yachachikukkuna Tata Dios rimashkanta killkarkansapa kashna apiwanaykichipa. Chay killkashkankunashina kunan apiwaykankichi wañuchiwanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tukuy disipulunkuna Jesusta apishkankunata kawashpankuna sapallanta sakishpankuna nitikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Suk wayna sabanasllanwan wankunakushpa katiykarkan. Chay Jesusta pushak runakuna payta apirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chashna apiptinkuna chay sabanasninta sakishpa llatanlla nitikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chay aypa runakuna Jesusta apishpa pusharkansapa ashwan sinchi kamachikuk saserdotepa wasinman. Chaypi saserdotekunapa kamachikukkunawan Moisespa killkadunta yachachikuk runakunawan judiyukunapa ansianunkuna tantanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesusta pushaptinkuna Pedruka karumanta katishpa kamachikuk saserdotepa wasin pampapi yaykurkan. Tata Diospa wasinta kuydak runakuna chay pampapi tiyaridu ninapi mashakuykarkansapa. Pedrupish paykunapa ladunkunapi rirkan tiyarik mashakunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chay wasi ukupi saserdotekunapa kamachikukninkunawan tukuy awtoridarkuna tantanakurkansapa. Chaypina tapunakurkansapa imashnami Jesusta chatankasapa wañuchinankunapa. Chashna tapunakushpankunapish mana nima uchanta tarirkansapachu chatanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aypa runakuna llullakushpa Jesusta chataptinkunapish sukpish sukpish chikan layata rimarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chaypina suk runakuna shayarishpa llullakushpa Jesusta chatarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ñukaykuna uyarishkanisapa kay Jesus rimashkanta: “Ñukami runakuna rurashkankuna Tata Diospa manllayba wasinta urmachisha. Chayta urmachishkayniwasha kimsa diya ukun tukuchasha kashkan rurayta. Mana runakuna rurashkan layatachu rurasha.” ");
INSERT INTO qvsNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chashna chatashpankunapish mana atiparkansapachu chay layallata chatayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chaypina saserdotekunapa ashwan sinchi kamachikukninkuna chawpinkunapi shayarishpa Jesusta tapurkan: —¿Manachu nimata aynikunki? ¿Imatatí chatashuykankisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Chaypina Jesuska upallalla uyarirkan. Mana nimata ayniptin chay sinchi kamachikuk saserdoteka kashkan tapurkan: —¿Ariya kanchu kanki shuyaykanaynikuna salvakuk kuyanaynikuna Tata Diospa wambran? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chashna tapuptin Jesuska aynirkan: —Ariya, ñukami kani. Kankuna ñukata sielumanta shamudu runata kawawankichi tukuy laya atipak Tatayni Diospa ladunpi tiyariptini. Kawawankichi puyukuna ukunpi kashkan shamuptini. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chashna Jesus willaptin chay sinchi kamachikuk saserdoteka sukaman piñakushpa sawa llachapanta llikirkan. Chayta rurarkan tukuy chay runakuna yachanankunapa sukaman piñakunanta. Chaymanta chay kamachikukmasinkunata willarkansapa: —¿Imapatí ashwan chatakuk runakunata maskashunchisapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kankunami rimashkanta allita uyarishkankichi. Kay runaka chashna rimashpa Tata Diostami sukaman piñachishka. ¿Imatatí yuyankichi? Chashna tapuptinkuna paykunaka suk layallata aynirkansapa: —¡Payka uchayukmi chayrayku wañunan tiyan! ");
INSERT INTO qvsNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chaypina sukkuna Jesustaka tukaycharkansapa. Sukkuna ñawinta arkapushpankuna makashpa willarkansapa: —May willawaysapa pimi waktashuykan. Tata Diospa wasinta kuydak runakunapish Jesusta uyanpi lapyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chay wasi altuyninpi Jesusta asichiykaptinkuna Pedruka uray pampapi karkan. Chaypina chay sinchi kamachikuk saserdotepa shipash wiwachan shamurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedru ninapi mashakuykaptin chay warmika kawashpa willarkan: —Nasaretmanta runa Jesuswan kanpish tantalla purishkanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Chashna willaptin Pedruka llullakushpa willarkan: —Mana riksinichu. Nima yachanichu pipami willawaykanki nishpa. Chayta rimashpa chay wasi punkuman llukshirkan. Chaypi kaptin suk gallo kantarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chaymanta chay shipash Pedruta kashkan kawashpa chay runakunata willarkansapa: —Kay runapish Jesuspa purikmasinmi. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedru kashkan llullakushpa rimarkan mana riksinanta. Chay washan chaypi runakuna Pedrutaka kashkan willarkansapa: —Deverasmi kanpish kanki Jesuspa purikmasin. Galileamanta runami kanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaypina Pedruka jurashpa rimarkan: —Ñukaka manami riksinichu chay willawaykanaykichi runata. ");
INSERT INTO qvsNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedruka chayta rimaykaptinlla kashkan gallo kantarkan. Chayta uyarishpana Pedruka yuyarkan Jesus willashkanta: “Manarapish gallo ishkay kuti kantaptin kimsa kuti rimanki mana riksiwanaykita.” Chayta yuyashpa sukaman llakishpa wakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chaymanta pakariykaptinna kamachikuk saserdotekunawan judiyu ansianukunawan Moisespa killkadunkunata yachachikukkuna tantanakurkansapa. Paykunaka Jesusta watashpa pusharkansapa gobernador Pilatoman. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chaypina Pilatoka Jesusta tapurkan: —¿Kanchu judiyu runakunapa ashwan sinchi kamachikuknin runa kanki? Chashna tapuptin Jesuska aynirkan: —Ariya, ñukami kani. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chaypina kamachikuk saserdotekunawan judiyu ansianukuna Jesusta sukaman chatarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chashna chataptinkuna Pilatoka Jesusta kashkan tapurkan: —¿Imapatí chatashuk runakunata mana ayninki? Mash uyariy. Kay runakunaka rikchak layata chatashuykankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pilato tapuptinpish Jesuska mana nimata aynirkanchu. Chayrayku Pilatoka sukaman almirarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tukuy wata Paskua fiesta ukun Pilato amañarkan karselmanta suk runata kachariyta. Runakunata tapuksapa maykan runatami kacharinka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay tiempu karselpi aypa wichkadu runakunawan suk runa Barrabas karkan. Chay runakuna romano gobiernuta mana kasunayashpankuna soldadunkunawan makanakurkansapa. Chay makanakuypi soldadukunata wañuchirkansapa. Chayrayku karselpi wichkadu karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaypina aypa runakuna tantanakushpankuna Pilatota roygarkansapa amañashkantashina suk runata karselmanta kacharinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Chayta roygaptinkuna Pilatoka tapurkansapa: —¿Munankichichu kay sinchi kamachishuknikichita kacharinaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatoka allita yacharkan kamachikuk saserdotekuna Jesusta chiknishpankuna chatashkankunata. Chayrayku chayta tapurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chaypina kamachikuk saserdotekunaka chay aypa tantanakudu runakunata sukaman willarkansapa Pilatota royganankunapa Barrabasta kacharinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Barrabasta kacharinanpa roygaptinkuna Pilatoka kashkan tapurkansapa: —¿Imatatí kay Jesusta rurasha? Paypa rimankichi sinchi kamachishuknikichi kananta. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chashna tapuptinkuna kashkan sinchita rimashpa willarkansapa: —¡Kruspi chakatachiy! ");
INSERT INTO qvsNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chaypina Pilatoka tapurkansapa: —¿Ima mana allitatí rurashka wañuchichinaynipa? Chaypina chay runakuna ashwan sukaman sinchita rimashpankuna kashkan willarkansapa: —¡Kruspi chakatachiy! ");
INSERT INTO qvsNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chay runakuna sukaman piñakushpa kapariptinkuna Pilatoka paykunata kushichinayashpa Barrabasta kacharirkan. Chaymanta Jesusta suk karawaskawan asutichishkanwasha soldadukunata willarkan suk kruspi chakatashpa wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chaypina soldadukuna Pilatopa wasin pampanman Jesusta pusharkansapa. Chaypi aypa soldadumasinkunata tantanachirkansapa Jesusta asichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kamachikukkunapa puka llachapata mudachishpankuna umanpi kashayuk waskamanta awadu koronata churapurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sukaman asichishpankuna ñawpakninpi kunkurikushpa willarkansapa: —Kanmi judiyu runakunapa ashwan sinchi kamachikuknin kanki. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chaypina soldadukuna Jesusta tukaycharkansapa. Suk pintuwan umanpi waktarkansapa. Kuyak tukushpankuna ñawpakninpi kunkurikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sukaman asichishkankunawasha chay puka llachapata surkupushpankuna kashkan kikinpa llachapanta mudachirkansapa. Chaymanta pusharkansapa suk kruspi chakatak. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chaymanta Sirene llaktamanta runa Simon chakranmanta kutiykarkan. Jesusta kruspi chakatak pushaykaptinkuna Simonka chayta riykarkan. Paypa wambrankuna Alejandrowan Rufo karkansapa. Chay soldadukuna Simonta apishpankuna Jesuspa krusninta wantuchirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesusta pusharkansapa suk taksha urku Golgotaman. Chay Golgota shuti judiyu rimananpi riman Uma Poto. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chaypina ayakwan chakrudu vinuta Jesusta upyachinayarkansapa susuchinanpa. Upyachinayaptinkunapish Jesuska mana munarkanchu upyayta. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chaypina soldadukunaka Jesusta kruspi chakatarkansapa. Paypa llachapankunata patumanakunankunapa pukllarkansapa yachanankunapa pipami kiparinka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve oras kaptin Jesusta chakatarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesuspa uman kuskapi churarkansapa suk killkaduta tukuy runakuna yachanankunapa imapami wañuchishkasapa nishpa. Chay killkadupi rimarkan: “Kay runaka judiyu runakunapa ashwan sinchi kamachikukninmi.” ");
INSERT INTO qvsNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuspa ishkantin ladunpi ishkay suwa runakunatapish chakatarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tata Diospa rimananpi killkadu karkan: “Mana alli rurak runakunawan tantallata wañuchinkasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aypa runakuna rirkansapa Jesusta kawak. Paykunaka umankunata kuyuchishpankuna Jesusta asichishpankuna willarkansapa: —¡Ja, mash kaway! Kanmi rimashkanki Tata Diospa manllayba wasinta urmachishpayki kimsa diya ukunlla kashkan ruranaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kunanka kikikilla chay krusmanta urayamushpa salvanakuy. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chashnalla kamachikuk saserdotekunawan Moisespa killkadunta yachachikuk runakunaka Jesusta asichishpa willarkansapa: —Payka aypa runakunata salvashkasapa. Kunanka kikin mana atipanchu salvanakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Shuyananchikuna salvakuk runa kashpaka krusmanta urayamuchun. Urayamushkanta kawashpanchikunara kreyishunchisapa sinchi kamachiwakninchikuna kananta. Chaypina chay ishkay ladunpi chakatadu suwakunapish Jesusta asichirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesus kruspi chakataduna kaptin chawpi diyamantapacha las tres de la tardikaman sukaman tuta likidu tukurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chay oraslla Jesuska sinchita rimarkan: “Eloi, Eloi ¿lama sabaktani?” Chay rimakushkan judiyu rimananpi riman: “Tata Diosnini, Tata Diosnini ¿imapatí sakiwashkanki?” ");
INSERT INTO qvsNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chay rimashkanta uyarishpana chay runakuna willanakurkansapa: —Uyariychi, kay runaka ñawpa yachachikuk Eliyastami kayaykan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chaypina suk runa kallpashpa pintupa puntanta chiktarkan utkuta churananpa. Chayta ayak likidu vinupi sumichishpa Jesuspa shiminpi churarkan shukunanpa. Chayta rurashpa sukkunata willarkansapa: —¡Upallayaychi! Akuychi kawaypachi Eliyas shamunkachu manachu krusmanta urayachik. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chaypina Jesuska sinchita kaparikushpa wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesus wañushkan oralla Tata Diospa wasinpi warkudu arkana llachapa llikikurkan. Anakninmanta urayninkaman llikikurkan chay alli arkadu kuartu rikurinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldadukunapa kapitanninkuna Jesuspa ñawpakninpi shayaridu karkan. Jesus wañuptin kawashpa rimarkan: —¡Deverasmi kay runaka Tata Diospa wambran kashka! ");
INSERT INTO qvsNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aypa warmikunapish karullamanta Jesus wañushkanta kawarkansapa. Chay kawak warmikunamanta Mariya Magdalenawan chay wayna Santiagopa Josepa mamankuna Mariyawan Salome karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesus Galileapi yachachikuykaptin tukuy chay warmikuna payta katishpankuna sukaman sirvirkansapa. Chaymanta Jesus Jerusalenman riptin aypa warmikuna katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Manara samana diya kallariptin chay fiestapa prontanakunankuna diya amusayaykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Chaypi tiyarkan Arimatea llaktamanta Jose. Chay Jose judiyukunapa sinchi kamachikukninkuna karkan. Paypish shuyaykarkan Tata Diosmanta sinchi kamachikuk runa shamunanta. Chay Joseka Pilatoman rirkan Jesuspa kuerpunta mañakuk. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chayta mañaptin Pilatoka Jesus utka wañushkanta yachashpa sukaman almirarkan. Chaypina allita yachanayashpa soldadunkunapa kapitanninkunata kayachirkan tapunanpa deveraschu Jesus wañushkana nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chay kapitan deveras wañushkanta willaptin Pilatoka willarkan Jesuspa kuerpunta Joseta kunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaypina Joseka suk allima yurak sabanasta rantirkan. Chaywan Jesuspa kuerpunta krusmanta urayachimushpa wankurkan. Allita wankushpa pusharkan atun rumipi aspidu machaypi churak. Chaypi churashkanwasha punkunta manllayba rumiwan allita wichkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magdalenawan Josepa maman Mariya chaypi churashkanta kawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chaymanta samana diya washan Mariya Magdalena Santiagopa maman Mariyawan Salomewan rirkansapa mishkilla asnak wirata rantik Jesuspa kuerpunta tupapunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chaypina semana kallarinan diya pakariykaptin inti chayrak llukshimuykaptin Jesusta pampashkankunaman rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Paykunaka riykashpankuna willanakurkansapa: —¿Pití machaypa punkunmanta chay manllayba rumita ashuchipanchimansapa? ");
INSERT INTO qvsNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Chaypi chayashpankuna kawarkansapa chay punku wichkana manllayba rumita ña ashuchidutana. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chay machay ukuman yaykushpankuna alli ladunpi suk wayna tiyariduta kawarkansapa. Payka suni yurak llachapayuk karkan. Chay warmikuna payta kawashpankuna sukaman manchakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chaypina chay waynaka willarkansapa: —¡Ama manchakuychichu! Ñuka yachani shamushkaykichita Nasaretmanta Jesusta kruspi chakatadu kashkata kawak. ¡Ñami payka kawsamushkana! Mananami kaypinachu. Mash kawaychi maypicha churashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kunanka disipulunkunata Pedrutapish rillaychi willak Jesus Galileaman kankunamanta ñawpakta rinanta. Chaypi willashushkaykichishina payta kawankichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chayta willaptinkuna chay warmikunaka chay machaymanta llukshishpa kallparkansapa. Manchakuyninkunawan sukaman chukchukushpankuna manara ni pita kawashkankunata parlachirkansaparachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chaymanta semana kallarinan diya Jesus kawsamushkanwasha tutapachalla Mariya Magdalenapi rikurirkan. Chay Mariyamanta ñawpa tiempu Jesus kanchis supaykunata llukshichipurkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chaypina Mariyaka Jesuspa purikmasinkunata rirkan willak paypi Jesus rikurishkanta. Paykuna manara kawsamushkanta yachashpara llakishpa wakaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mariya Jesusta kawsamuduta kawashkanta willaptinkunapish mana kreyirkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaymanta ishkay purikmasinkunapi Jesuska rikurirkan. Paykunaka chakraman riykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jesus paykunapi rikuriptin kutirkansapa purikmasinkunata willak Jesusta kawashkankunata. Chashna willaptinkunapish mana nima kreyirkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chay washa chunka suk disipulunkuna mesapi mikuykaptinkuna paykunapi Jesuska rikurirkan. Paykunata piñayarkansapa mana kreyikuk sinchi shunku kashpa kawsamushkanta kawashka runakunata mana kreyiptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chaypina willarkansapa: —Rillaychi tukuy allpapi kawsak runakunata willak ñukata kreyiwak runakunata kastigumanta salvanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Suk runakuna kreyiwashpa bawtisakuptinkuna uchankunamanta salvasha. Suk runakuna mana kreyiwaptinkuna kastigasha. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ñukata kreyiwashpa kawsashpaykichi atipankichi shutinipi supaykunata runakunamanta llukshichiyta. Mana yachashkaykichi laya rimanakunapi rimakunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Machakuykuna mana nimanachishunkichichu. Ima venenotapish upyachishuptikichi mana nimanachishunkichichu. Chaymanta unkudukunapa umankunapi makikichita churaptikichi alliyankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus tukuy chayta disipulunkunata willashkankunawasha Tata Dioska sieluman pusharkan. Chaypi alli ladunpi tiyachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chaymanta Jesus willashkankunashina disipulunkuna tukuy mayta rirkansapa yachachikuk. Jesus yanaparkansapa milagrukunata ruranankunapa runakuna yachachikushkankunata kreyinankunapa. Chayllami kashka.");
INSERT INTO qvsNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Munanayni Teofilo, ñuka Lukas kayta killkaykayki allita yachanaykipa Jesus tukuy rurashkankunata yachachikushkankunatapish. Aypa runakuna Jesus kallarinanmantapacha rurashkankunata kawarkansapa. Paykunaka ñukaykunata allita yachachiwarkansapa. Chaymanta paykuna Jesus rurashkankunata allita yachachikushpa killkarkansapa. Chashna yachachikuptinkuna kanpish uyarishkanki. Ñawpamantapacha ñukapish Jesus tukuy rurashkankunata allita yachanayashpa chay kawashka runakunata tapushkani. Paykuna willawaptinkuna allita killkashkani. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kunanka kay killkaduynita kachaykayki kanpish allita yachanaykipa chay runakuna kuskata yachachishushkankuna deveras kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ñawpa tiempu Judea partipi sinchi kamachikuk Herodes kamachikuykaptin suk saserdote tiyarkan. Paypa shutin karkan Sakariyas. Sakariyaspa ayllunpa shutin karkan Abiyas. Warmin karkan Isabel. Isabelka ñawpa tiempu saserdote Aronmanta mirashkan ayllun karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakariyaska warmintin Tata Diosta allita kasushpankuna kawsaksapa. Chayrayku mana ni pi paykunata chatayta atiparkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Paykunaka mana niman suk wambrayukchu karkansapa. Isabelka mana ni suk kuti wawayarkanchu. Paykunaka mana ni suk wambrayukna viejuyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tata Diospa manllayba wasinpi saserdotekuna sukmanta sukmanta akllanakushpa suk semanata trabajaksapa. Chaypina suk diya Sakariyaska ayllunkunawan tantalla rirkansapa Tata Diospa wasinpi trabajak. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chay saserdotekunapura akllanakuksapa yachanankunapa ima laya trabajutami rurankasapa nishpa. Chashna akllanakushpankuna Sakariyasta akllarkansapa ashwan ukuman Tata Diospa wasinpi yaykunanpa. Akllarkansapa taksha altarpi mishkilla asnak wikita rupachinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakariyas wikita rupachiykaptin Tata Diospa wasin pampapi aypa runakuna oraykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chaypina Sakariyaspi rikurirkan Tata Diospa angelnin. Chay angelka shayarirkan altarpa alli ladunpi. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Payta kawashpana Sakariyaska almirashpa sukaman manchakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chashna manchakuptin angelka willarkan: —Sakariyas, ama manchakuychu. Kanka sukaman Tata Diosta mañashkanki suk wambraykita kushunanpa. Chashna mañaptiki Tata Dioska ñami uyarishushkana. Warmiki Isabelka ullku wambratami wawayanka. Paypa shutinka Juanmi kanka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wambrayki nasiptin sukamanmi kushikunki. Aypa runakunapish kawashpankuna kushikunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wambraykika alli yachaysapami kanka. Manarapish nasiptin Tata Diospa Espiritun paypi kawsanka. Niman suk kuti payka nima vinuta nima traguta upyankachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wambraykika wiñashpana aypa israelmasinkunata yanapankasapa mana kasushkankunamanta Tata Diosta allita kasushpana kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tata Dios sukaman yanapaptin wambraykika ñawpa alli yachachikuk Eliyasshina sukaman yachaysapa runa kanka. Tata Diosta mana kasuk runakunata kuskata yachachinkasapa payta kasushpa kawsanankunapa. Tatakunata yachachinkasapa wambrankunawan mana kuyanakushkankunamanta allita kuyanakushpa kawsanankunapa. Manarapish Tata Dios kachamushkan wambran yachachikuptinra wambraykika runakunata yachachinkasapa pay chayamuptin allita chaskinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chashna willaptin Sakariyaska angelta willarkan: —Ñukaka warminiwan viejuna kanisapa. ¿Imashnati allita yachayman wambrayuk kanaynikunata? ");
INSERT INTO qvsNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chashna Sakariyas tapuptin angelka willarkan: —Ñukami kani Tata Diospa sirviknin Gabriel. Payka kachamuwashka kanta willanaynipa wambrayki tiyananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mana kreyiwashkaykirayku kunanmantapacha wambrayki nasinan diyakaman mana rimakuy atipak kiparinki. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chashna angel parlachiykaptin aypa runakuna Sakariyas llukshimunanta shuyaykarkansapa. Paykunaka tapunakurkansapa: —¿Imapati sukamanka unayan? ");
INSERT INTO qvsNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chaypina Sakariyaska llukshimurkan mana rimakuy atipakna. Chayrayku makinwan umanwan chay runakunataka entiendichirkansapa angelwan parlashkanta. Chaymanta Sakariyaska mana rimakuy atipak karkan chay wambran nasinan diyakaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Payka Tata Diospa wasinpi trabajunta paktachishpa wasinman kutirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wasinman kutishkanwasha warmin Isabelka okupadana kiparirkan. Chashna okupada kashpa pichka killata wasinmanta mana nima llukshirkannachu. Wasinpi kiparishpa yuyanakurkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Tata Diosmi yanapawashka wawayanaynipa ama runakuna pinkachiwanankunapa mana wawayuk kaptini. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Galilea partipi Nasaret llaktapi tiyarkan suk sensilla shipash. Shutin karkan Mariya. Payka suk runa Josewan kasarananpa mañadu karkan. Joseka karkan ñawpa kamachikuk Davidmanta mirashkan runa. Chaypina Isabel sokta killa okupada kaptin Tata Dioska kacharkan angel Gabrielta chay shipash Mariyawan parlak. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chay angelka Mariyapi rikurishpa willarkan: —Tata Diospa shutinpi rimachiyki. Tata Diosmi sukaman kuyashushpayki yanapashunki. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chashna angel willaptin Mariyaka sukaman manchakurkan. Shunkunpi yuyaykushpa rimarkan: “¿Imapati kay angelka chashna willawan?” ");
INSERT INTO qvsNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chaypina angelka willarkan: —Mariya, ama manchakuychu. Tata Dios kuyashushpa akllashushka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kunanmantapacha okupada kiparinki. Suk ullku wambrata wawayanki. Chay wawaykita shutiyachinki Jesus. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payka alli yachaysapa runami kanka. Runakuna payta riksinkasapa tukuy laya atipak Tata Diospa wambran kananta. Tata Dios paytaka churanka sinchi kamachikuk kananpa. Iden ñawpa tiempu awiluyki Davidshina sukaman allita kamachikunka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Payka israelmasinkunata mana tukuyniyukta kamachinka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chashna angel willaptin Mariyaka willarkan: —¿Imashnatiya wawayasha manara nima ullkuwan tantanakushpaynira? ");
INSERT INTO qvsNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chashna Mariya tapuptin angelka willarkan: —Tata Diospa Espiritunmi tukuy laya atipak kashpa puyushina kuskalla kanman urayamunka. Chashnamanta okupada kiparinki. Chayrayku wawaykika Tata Diospa kachamushkan wambran kanka. Payka Tata Diospa munananllata ruranka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Chaymanta aylluyki Isabelpish sokta killa okupadana. Payka mana nima wawayukchu kashka. Kunan viejana kaykashpapish ullku wambratami wawayanka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tata Dios tukuy layatami atipan rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chashna angel willaptin Mariyaka willarkan: —Ñuka Tata Dios willawananta tukuyta almitikuni. Tukuy willawashkaykitashina ñukapi payka rurachun. Chashna Mariya almitiptin angelka sakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay angel sakishkanwasha Mariyaka utkakushpa rirkan chay ayllun Isabelta pasyak. Isabelka kusan Sakariyaswan kawsarkan suk llaktapi chay Judea partipi urkukunapa chawpinpi. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakariyaspa wasinpi chayashpa Mariyaka Isabeltaka rimachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chashna Mariya rimachiptinna Isabelpa wawanka wiksan ukupi kaykashpa kushikuyninwan sukaman kuyurkan. Chashna oras Tata Diospa Espiritun Isabelta sukaman kushichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chaypina Isabelka Mariyataka sinchita rimashpa willarkan: —Tata Dioska tukuy warmikunamanta kantami ashwan allita kushichishushka. Wawaykitapish sukaman allita kushichishka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kanka kamachiwak Señorninipa mamanmi kanki. Chayrayku ñuka mana igualmasikichu kani shamunaykipa pasyawak. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rimachiwashkaykita uyariptinilla wawaynika kushikushpa wiksayni ukupi sukaman kuyushka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kanka tukuy Tata Dios willashushkanta allita kreyishpa almitishkanki. Chayrayku Tata Dioska sukaman kushichishunki. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chashna Isabel willaptin Mariyaka willarkan: Sukaman kushikushpa rimani Tata Dios tukuy laya atipak kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Tata Dios sukaman alli salvawaknini kashpa ñukataka munawashka tukuy willawashkanta almitiptini. Chashna Tata Dios munawaptin sukaman kushikuni. Tata Dios sukaman tukuy laya alli yachak kashpa ñukataka akllawashka paypa wambranta wawayanaynipa. Chayrayku kunanmantapacha tukuy runakuna rimankasapa Tata Dios ñukata sukaman kushichiwashkanta. Payka sukaman allimami. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tukuy tiempu Tata Dios tukuy kuyak runakunata llakichishpa yanapansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tata Dios rikchak laya yachak kashpa sukaman almiranakunata rurashka. Chaymanta tukuy kikinlla yuyanakuk runakunapa yuyayninkunata wakllichipushka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tata Dioska sinchi kamachikuk runakunata kamachikunankunamanta sampayachishkasapa. Chaymanta alli modoyuk runakunata kushichishkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tata Dioska chay yarkashpa kawsak runakunata tukuy layapi yanapashkasapa. Chaymanta tukuy laya tiyapuk runakunata mana nimayukta karkushkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Payta sirvik israel runakunata sukaman yanapashkasapa. Mana kunkashkachu llakichishpa yanapayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ñawpa tiempu Tata Dios awilunchi Abrahamta willarkan tukuy paypa mirakninkunata kuyashpa yanapanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Chashna rimashpa Mariya Tata Diosta alabarkan. Chaypina kimsa killata Isabelwan kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chaymanta wawayanan tiempu paktaptin Isabelka ullku wambrata wawayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wawayashkanta yachashpankuna ayllunkuna llaktamasinkunawan rirkansapa kushikushpa wawanta kawak. Willarkansapa Tata Dios Isabelta kuyashpa sukaman yanapashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chaymanta chay wambra pusak diyayuk kaptin tantanakurkansapa pishkitunta señalapunankunapa. Chaypina tukuy ayllunkuna munarkansapa tatanpa shutin kananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Chaypina maman willarkansapa: —Manami tatanpa shutinchu kanka. Shutinka Juan kanan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chashna Isabel willaptinkuna ayllunkunaka willarkansapa: —¿Imapati Juan shutita munanki? Mana ni pi Juan shutiyuk aylluykichi tiyanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chaypina paykuna Sakariyasta makinkunawan tapurkansapa ima shutitami munan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chashna tapuptinkuna suk tablata mañarkan wambranpa shutinta killkananpa. Chaypina killkakurkan: “Kay wambraynipa shutinka Juanmi.” Chayta killkakuptin tukuy ayllunkunaka sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakariyas killkakushkanwasha mana rimakuyta atipashkanmanta kashkan rimakurkan. Chaypina kushikuypuru Tata Diosta alabashpa willarkan: —Kanka, Tata Dios, tukuy laya yachakmi kanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chashna Sakariyas rimakuptin uyarishpana tukuy llaktamasinkuna sukaman almirarkansapa. Paykuna tukuy chay urku llaktakunapi kawsak runakunata parlachirkansapa imashnami chay wambra nasishka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chayta uyarik runakuna sukwan sukwan parlarkansapa: —Tata Dioska chay wambrataka sukaman kuyashpa almirana layata rurashpa yanapashka. Payka wiñashpaka rikchak laya yachakmi kanka. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tata Diospa Espiritun yachachiptin chay wambrapa tatan Sakariyaska llaktamasinkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israel runakuna kaptinchikuna Tata Diosninchika ñami shamushkana salvawananchikunapana. Chashna shamuptinna akuychi alabaypachi. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tata Dios sirvik Davidmanta mirashkan runata kachamushka. Payka tukuy laya atipak salvawakninchi runami. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ñawpa tiempu alli yachachikuk runakuna yachachikurkansapa Tata Dios suk alli salvakuk runata kachamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Paykuna killkarkansapa chikniwakninchi runakunamanta salvawananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chaymanta yachachirkansapa Tata Dios awilunchikunata kuyashpa yanapanankunata. Tata Dioska rurashkan paktuta mana kunkashpa ruranan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tata Dios jurashpa Abramwan paktuta rurarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Chay paktuta rurashkanrayku chikniwakninchi runakunamanta salvawanchisapa. Chayrayku kushikushpa mana ni pita manchashpa Tata Diospa munananta rurashpa kawsashunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wañunanchi diyakaman Tata Diospa ñawpakninpi allillata rurashpa payllata kasushpa kawsashunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chaymanta munanayni wambrayni, rikchak laya yachak Tata Dioska kanta kachashunki rimananta yachachikunaykipa. Manarapish Tata Dios kachamushkan runa shamuptin kanka allita yachachikunki runakuna payta chaskinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Israelmasinchikunata yachachinki Tata Dios uchankunata perdonashpa salvanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tata Diosninchi sukaman kuyawashpanchikuna kanta kachamushushka yachachikunaykipa sielumanta chaylla wambranta kachamushkanta. Payka yachachiwashpanchikuna inti llipyakshina lusichiwashunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Paymi lusichiwashpanchikuna mana alli rurashkanchikunata riksichiwashunchisapa. Yachachiwashunchisapa amana yana likidu tutapishina purinanchikunapa. Yachachiwashunchisapa sukaman allita kushikushpa kawsananchikunapa. Chayta Sakariyas kushikushpa rimarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chaymanta wambran Juan Tata Diosta allita riksishpa wiñarkan. Payka israelmasinkunata yachachinan diyakaman chunlla chakidu allpapi kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chay tiempu Sesar Augusto tukuy kamachikukkunamanta ashwan sinchi kamachikuk karkan. Payka kamachikurkan tukuy runakuna kikinkunapa llaktankunapi shutinkunata killkachinakunankunapa. Sesar Augusto yachanayarkan mashna runakunami tiyansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chashna Sesar kallarinan kuti tukuy runakunata yupachiptin Siria partipi Sirenio kamachikuk runa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sesar Augustoka kamachikurkan tukuy runakuna kikinkunapa llaktankunaman rinankunapa shutinkunata killkachinakuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chay pacha Joseka Galilea partipi Nasaret llaktapi kawsaykarkan. Paymi karkan ñawpa kamachikuk Davidmanta mirashkan runa. Chay ñawpa kamachikuk Davidka Judea partipi Belen llaktamanta karkan. Chayrayku Nasaret llaktamanta Joseka rirkan chay ñawpa awilun Davidpa Belen llaktanman. Chaypi rirkan shutinta killkachinakuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Chay tiempu Joseka Mariyawan kasaranankunapa mañaduna karkan. Mariya okupada kashpa Josewan tantallana rirkan shutinkunata killkachinakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Belen llaktapi chayashpankuna mana niman suk wasita tarirkansapachu chaypi chayanankunapa. Chashna mana nima wasita tarishpankuna ovejakuna wasinpi chayarkansapa. Chaypi kaptinkuna Mariyapa paktamurkan wawayanan tiempu. Wawayarkan piwi wawanta. Mariyaka wawantaka pintunankunawan wankushpa ovejakuna wasinpi sirichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belen llakta ladunpi Jesus nasinan tuta suk pastupi runakuna ovejankunata kuydaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chay runakunapi Tata Diospa angelnin raslla rikurimuptin sukaman allimata llipyarkan. Chayta kawashpa ovejakuna kuydak runakunaka sukaman manchakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Paykunata angelka willarkansapa: —Tata Diosmantami suk alli rimanata willaykichi. Kayta uyarishpa tukuy runakuna kushikunkichi. Chayrayku ama manchakuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kunan tuta ñawpa kamachikuk Davidpa Belen llaktanpi salvashuknikichi ñami nasishkana. Payka Tata Dios kachamushkan sinchi kamachikukmi. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Rillaychi chay wambrata riksik. Paytaka tarinkichimi pintunanwan wankuduta ovejakuna wasinpi siriduta. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chashna angel willaykaptin sielumanta aypa angelkuna rikurimurkansapa. Tukuy paykuna sukaman Tata Diosta kushichishpankuna willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Altu sielupi kawsak Tata Diosta kuyashpa alabaypachi. Tata Dios allpapi kawsak runakunata kuyansapa. Chayrayku payka kushichishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chay angelkuna kantashkankunawasha sieluman kutirkansapa. Chaypina chay runakuna sukwan sukwan parlanakurkansapa: —Akuychina Belen llaktaman chay angel willawashkanchikunata kawak. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chay runakuna utkakushpa rishpankuna tarirkansapa chay wambrata oveja wasinpi sirichiduta Mariya Jose kuydaykaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chay runakuna wambrata kawashpankuna tukuy pita parlachirkansapa angel willashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chayta uyarishpankuna tukuy runakuna sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","Chaypina chay ovejakuna kuydak runakuna Tata Diosta sukaman kuyashpa alabarkansapa. Paykunaka sukaman almirarkansapa chay angel willashkankunatashina kawashpankuna. Kushikushpa chay ovejankuna kuydanankunaman kutirkansapa. Paykuna kutiptinkuna Mariya tukuy willashkankunata shunkullikushpa kuti kuti allita yuyaykurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chaymanta chay wambra pusak diyayuk kaptinna pishkitun punta karapanta tipichipurkansapa señaladu kananpa. Chaypina shutiyachirkansapa Jesus shutin kananpa. Manarapish Mariya okupada kaptin chay angel willarkan wawanpa shutin Jesus kananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wambran nasishkan diyamanta chusku chunka diyata wasinmanta Mariyaka mana llukshirkanchu. Chay diyakuna paktaptinna ñawpa Moisespa killkadunpi willashkanta kasushpa allita armakurkan. Armakushkanwasha Mariyaka Josewan wambrata Jerusalenman pusharkansapa Tata Diosta kuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tata Dios ñawpa killkadunpi rimarkan: “Tukuy piwi wambra ullku nasiptin ñukapami kanan tiyan.” Chayta Tata Dios rimashkanrayku Mariyaka Josewan chay wambrata pusharkansapa Tata Diosta kukna. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chaymanta Tata Diospa killkadunpi riman mana ishkay rimarikuykunata apashpa ishkay urpaykunata apanankunapa Tata Diosta kuyashpa kunankunapa. Chayrayku Mariya Josewan wambra Jesusta pushashpa ishkay urpayta aparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chay pacha Jerusalenpi kawsarkan suk runa Simeon. Tata Diospa Espiritun yanapaptin payka alli rurak runa karkan. Tata Diosta sukaman kuyashpa kawsak. Payka israelmasinkunapa salvakukninkuna runata sukaman shuyaykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chayrayku Tata Diospa Espiritun Simeontaka willarkan: “Manara wañushpaykira Tata Diospa kachamushkan salvakuk runata kawanki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mariyaka Josewan wambra Jesusta pusharkansapa Tata Diospa wasinman. Chayman pusharkansapa Tata Diospa killkadunpi willashkankunata kasushpankuna. Chaypina Tata Diospa Espiritun Simeonta willarkan Tata Diospa wasinman rinanpa chay wambrata riksik. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Chaypi chayashpa Simeonka chay wambrata markarkan. Payta markashpa Tata Diosta sukaman kuyashpa willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","A Tata Dios, kanka willawashkanki manara wañushpaynira kachamushkayki wambraykita kawanaynipa. Kunanka kushikushpana wañusha. Ñami paytaka kawashkanina. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ñami kawashkanina kay salvakuk kachamushkayki wambraykitaka. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tukuy llaktakunamanta aypa runakuna yachankasapa salvakuk runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Payka alli lusshina tukuy runakunata yachachinkasapa kanta kuyashushpa kawsanankunapa. Chaypina runakuna yachankasapa israel runakunamanta salvakuk runa shamushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chashna Simeon willaptin uyarishpana Mariya Josewan sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chaypina Simeonka Tata Diosta roygarkan paykunata yanapanankunapa. Chaymanta Jesuspa mamantaka willarkan: —Israel llaktamanta aypa runakuna wawaykita chiknishpa rimankasapa mana alli kananta. Tukuy paykunata Tata Dioska kastigankasapa. Chaymanta wawaykita kreyik runakunata Tata Dios perdonankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Wawaykika tukuy runakunata riksichinkasapa ima layami yuyayninkuna nishpa. Aypa runakuna wawaykita mana kreyishpa chikniptinkuna kanka sukaman llakishpa turbakunki. Chashna Simeonka Mariyataka willarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaymanta Tata Diospa wasinpi tiyarkan suk alli yachachikuk warmi. Paypa shutin karkan Ana. Tatanka karkan Fanuel. Ñawpa awilun karkan Aser. Payka shipashlla kashpa kasararkan. Chaymanta kanchis wata kasarashkanwasha kusan wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chay warmika pusak chunka chusku watata viyudana karkan. Payka Tata Diospa wasinmanta mana llukshishpa suk diyakuna mana mikushpa kawsarkan. Diyapi tutapi Tata Diosta orashpa sirvirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chay yachachikuk Ana tarirkan Simeonta Mariyawan Josewan parlaykaptin. Paykunata tarishpa wambra Jesusta kawashpa Tata Diosta sukaman agradesirkan. Chaypi tiyarkan Jerusalen llaktata salvak runata shuyak runakuna. Tukuy paykunata Ana willarkansapa chay wambra Jesus shuyashkankuna salvakuk runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chaymanta Tata Diospa killkadunpi willashkanta rurashpankuna Nasaret llaktanman Mariyawan Jose Jesusta pushashpa kutirkansapa. Chay Nasaret llakta Galilea partipi karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chaypi kawsaptinkuna Jesuska allita wiñarkan. Tata Dios payta sukaman yanapaptin sukaman yuyaylla untadu yachaysapa likidu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada wata Jerusalenman Mariyaka kusanwan riksapa Paskua fiestata pasak. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chaymanta Jesus chunka ishkay watayuk kaptinna maman tatan payta pusharkansapa Jerusalenpi fiestakuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chay fiesta tukuptinna wasinkunaman tukuy runakuna kutiptinkuna wayna Jesuska Jerusalenpi kiparirkan. Chashna kipariptin Mariya kusanwan yuyarkansapa washankunata katiykananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mariya kusanwan llaktamasinkunawan puriykananta yuyashpa mana watukushpankuna suk diyata purirkansapa. Amusayaykaptinna Jesusta chayrak watukushpana llaktamasinkunapi ayllunkunapi ñanllapi maskarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sukaman maskashpa mana tarirkansapachu. Mana tarishpa kutirkansapa Jerusalenpi maskak. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chaypina kimsa diyata maskashpana Tata Diospa wasinpi Jesustaka tarirkansapa. Payka Tatan Diospa rimananta yachachikuk runakunapa chawpinkunapi tiyaridu karkan. Chaypi yachachikuptinkuna Jesuska paykunata uyariykarkansapa tapuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chashna Jesus paykunawan parlaptinkuna chay yachachikuk runakunaka sukaman almirarkansapa alli yachaysapa kaptin. Almirarkansapa Tata Diospa rimananta sukaman allita yachaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chashna chay runakunawan tantalla sukaman parlaykaptinkuna tarishpa mamanka kusanwan sukaman almirarkansapa. Chaypina mamanka willarkan: —Wawituyni ¿imapati washaynikunamanta kiparishkanki? Ñukaykuna sukaman llakishpaynikuna maskamuykaykisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chashna willaptinna Jesus willarkan: —¿Imapati maskawashkankichi? Ñuka Tatayni willawashkanta ruranayni tiyan. ¿Manachu chayta yachankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Chashna willaptinna paykuna mana entiendirkansapachu imapami chashnaka willansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaypina Jesuska paykunawan Nasaret llaktaman kutirkan. Chaypina paykunata tukuy layapi kasushpa kawsarkan. Mariyaka wawan willashkanta tukuyta shunkunpi wakaycharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesuska ashwan yuyaylla untadu wiñarkan Tata Dios yanapaptin. Chashna alli yuyayuk kaptin tukuy runakuna payta munarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jesus atun runa kaptinna tukuy kamachikuk runakunamanta Tiberio ashwan sinchi kamachikuk karkan. Chay Tiberioka chunka pichka watatana kamachikuk karkan. Chay tiempu Judea partipi Ponsio Pilato kamachikuk karkan. Galilea partipi Herodes kamachikuk karkan. Iturea partipi Trakonite partipi Herodespa wawkin Felipi kamachikuk karkan. Abilinia partipi Lisanias kamachikuk karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chaymanta Anas Kayfaswan tukuy saserdotekunapa ashwan sinchi kamachikukninkuna karkansapa. Chaymanta Sakariyaspa wambran Juan chunlla chakidu allpapi kawsarkan. Chaypi kawsaptinna Tata Dioska willarkan yachachikuk rinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chashna Tata Dios willaptinna chay Jordan yaku mañanpi tiyak llaktakunapi yachachikuypi purirkan. Chay llaktakunapi kawsak runakunata yachachirkansapa tukuy mana alli rurashkankunamanta wananankunapa. Yachachirkansapa tukuy uchankunata Tata Dios perdonaptinkuna bawtisakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ñawpa tiempu yachachikuk Isaiyas Tata Diospa rimananta killkarkan: “Chunlla chakidu allpapi suk runa sinchita rimashpa kashna yachachikunka: ‘Tata Dios kachamushkan runa yachachikuyta kallarinanpa kankuna suk kuska ñanta kichariychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tukuy ñannikichipa rarkanta allpachaychi. Tukuy ñannikichipa urkukunata pampayachiychi. Tukuy wiksu wiksu ñannikichita kuskachaychi. Kankuna uchallikushpa kawsashpaykichi mana alli ñanshina kankichi. Amana ñawpashina uchallikushpa kawsaychinachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kankuna allita kawsaptikichi tukuy runakuna Tata Dios kachamushkan salvakuk runata riksinkasapa.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chashna Juan yachachikuptin aypa runakuna laduncharkansapa munashpa bawtisanankunapa. Juanka paykunata willarkansapa: —Kankuna llulla likidu kankichi. Tata Dios tukuy mana alli rurak runakunata sukaman kastiganan tiyan. Kankunaka manami bawtisakushpallachu kishpinkichi Tata Diospa kastigunmanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Allita rurashpa kawsanaykichi tiyan tukuy kawashuknikichi yachanankunapa Tata Diosta kreyishpana kawsaykanaykichita. Ama kikikichilla llullachinakushpa rimaychichu: Ñukaykuna ñawpa tiempu awiluynikuna Abrahammanta miradu kaptinikuna Tata Dios kastiguynikunamanta salvawankasapa nishpa. Allita willaykichi Tata Dios kay rumikunamantapish atipanman Abrahampa mirakninta rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Suk kaspi mana allita wayuchakuptinka doyñun sapinpi achawan kuchushpa rupachin. Chashnami Tata Dioska kankunata mana alli rurashkaykichirayku utkana kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chashna Juan yachachikuptin chay runakuna tapurkansapa: —¿Imatatí rurashasapa Tata Dios kastigumanta salvawanankunapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chaypina Juanka willarkansapa: —Ishkay llachapayuk kashpaykichi mana llachapayuk runata suk llachapaykichita kuychi. Chaymanta mikunaykichi tiyaptin mana mikunayuk runata karaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chaymanta romano gobiernupa kullki chaskikuk runakuna Juanta laduncharkansapa bawtisakuyta munashpankuna. Paykuna Juanta willarkansapa: —Maestru ¿imatatí rurashasapa Tata Dios kastigumanta salvawanankunapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chaypina Juan willarkansapa: —Romano gobiernu willashushkaykichillata kobrakuychi. Ama kankunapawanka kobrakuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaymanta soldadukuna ladunchashpankuna Juanta tapurkansapa: —Ñukaykunapish ¿imatatí rurashasapa Tata Dios kastigumanta salvawanankunapa? Chashna tapuptinkuna Juanka willarkansapa: —Ama ni pita ima tiyapukninta kichuychichu. Ama ni pita llullakushpa chatashpa nimata kichuychichu. Chaymanta kamachishuknikichi pagarashushkaykichillawan kushikushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aypa runakuna Tata Dios kachamushkan salvakuk runata shuyashpa kawsaykarkansapa. Paykuna tapunakurkansapa: —Ichará kay Juanka Tata Dios kachamushkan runa. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chayta uyarishpa Juan willarkansapa: —Ñukaka yakullawanmi bawtisaykichi. Chaymanta washaynita shamun ñukamanta ashwan alli yachachikuk runa. Payka Tata Diospa Espiritunwan bawtisashunkichi. Chay Espiritunka rawraykak ninawanshina bawtisashunkichi uchaykichimanta pichashunaykichipa. Chay yachachikuk runaka ñukamanta tukuy laya ashwan alli yachachikukmi. Ñukaka mana animukunichu ushutan waskanta paskayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Triguta waktashpa murukunata surkunchi. Chaypina murukunata wakaychanchi. Trigupa tullunkunata wishchushpa rupachinchi. Chay ñukamanta ashwan yachaysapa runaka trigu murukunata surkuk runashinami. Paymi tukuy kreyik runakunata allita kuydan. Mana kreyik runakunata churankasapa mana tukuyniyuk ninapi. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chashna aypata yachachikushpa Juan chay runakunata willarkansapa Tata Dios kachamushkan runa shamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chaymanta Juanka chay sinchi kamachikuk Herodesta piñayarkan wawkin Felipipa warmin Herodiyaswan uchallikushpa kawsaykaptin. Chaymanta piñayarkan aypa mana allikunata rurashpa kawsaykaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chashna piñayaptinpish Herodeska mana allita rurayllapi katirkan. Mana alli rurak kashpa karselpi Juantaka wichkachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Manarapish Herodes karselpi Juanta wichkachiptin aypa runakunata bawtisayllapi katirkan. Jesuspish rirkan Juan bawtisananpa. Jesus bawtisakushkanwasha Tatan Dioswan parlarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chaypina sielu kicharinakuptin Tata Diospa Espiritun iden urpayshina urayamurkan Jesuspi tiyarik. Chashna orana sielumanta Tatan Dios Jesusta willarkan: —Kanka kuyanayni wambraynimi kanki. Sukamanmi kushichiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuska kimsa chunka watayuk kashpa kallarirkan yachachikuyta. Tukuy runakuna yuyarkansapa Josepa wambran kananta. Joseka karkan Elipa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elika karkan Matatpa wambran. Matatka karkan Levipa wambran. Levika karkan Melkipa wambran. Melkika karkan Janapa wambran. Janaka karkan Josepa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Chaymanta Joseka karkan Matatiyaspa wambran. Matatiyaska karkan Amospa wambran. Amoska karkan Nahunpa wambran. Nahunka karkan Eslipa wambran. Eslika karkan Nagaypa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayka karkan Maatpa wambran. Maatka karkan Matatiyaspa wambran. Matatiyaska karkan Semeypa wambran. Semeyka karkan Josekpa wambran. Josekka karkan Judapa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Chay Judaka karkan Joananpa wambran. Joananka karkan Resapa wambran. Resaka karkan Sorobabelpa wambran. Sorobabelka karkan Salatielpa wambran. Salatielka karkan Neripa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerika karkan Melkipa wambran. Melkika karkan Adipa wambran. Adika karkan Kosampa wambran. Kosamka karkan Elmadampa wambran. Elmadamka karkan Erpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erka karkan Josuepa wambran. Josueka karkan Elieserpa wambran. Elieserka karkan Jorimpa wambran. Jorimka karkan Matatpa wambran. Matatka karkan Levipa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levika karkan Simeonpa wambran. Simeonka karkan Judapa wambran. Judaka karkan Josepa wambran. Joseka karkan Jonampa wambran. Jonamka karkan Eliakimpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimka karkan Meleapa wambran. Meleaka karkan Menapa wambran. Menaka karkan Matatapa wambran. Matataka karkan Natanpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanka karkan Davidpa wambran. Davidka karkan Isayipa wambran. Isayika karkan Obedpa wambran. Obedka karkan Boospa wambran. Booska karkan Salapa wambran. Salaka karkan Naasonpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonka karkan Aminadabpa wambran. Aminadabka karkan Adminpa wambran. Adminka karkan Arnipa wambran. Arnika karkan Esrompa wambran. Esromka karkan Farespa wambran. Fareska karkan Judapa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaka karkan Jakobopa wambran. Jakoboka karkan Isakpa wambran. Isakka karkan Abrahampa wambran. Abrahamka karkan Tarepa wambran. Tareka karkan Nakorpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakorka karkan Serukpa wambran. Serukka karkan Ragawpa wambran. Ragawka karkan Pelekpa wambran. Pelekka karkan Heberpa wambran. Heberka karkan Salapa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaka karkan Kaynanpa wambran. Kaynanka karkan Arfakapa wambran. Arfakaka karkan Sempa wambran. Semka karkan Noepa wambran. Noeka karkan Lamekpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekka karkan Matusalenpa wambran. Matusalenka karkan Enokpa wambran. Enokka karkan Jaredpa wambran. Jaredka karkan Mahalalelpa wambran. Mahalalelka karkan Kaynanpa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynanka karkan Enospa wambran. Enoska karkan Setpa wambran. Setka karkan Adanpa wambran. Adanka karkan Tata Diospa wambran. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus bawtisakushkanwasha Tata Diospa Espiritun atipachiptin Jordan yakumanta kutirkan. Chaypina chunlla chakidu allpaman Tata Diospa Espiritunka pusharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypi kashpana chusku chunka diyata Jesuska mana nimata mikurkanchu. Supay tukuy chay diyakunata Jesusta mana allikunata rurachinayarkan. Chaypina Jesus sukaman yarkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sukaman yarkaptinna supayka willarkan: —Kanka Tata Diospa wambran kashpaykika kay rumita willay pan tukunanpa chayta mikunaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chashna supay willaptinna Jesuska mana nima kreyishpa willarkan: —Tata Diospa killkadunpi willawanchi: “Tukuy runakuna Tata Diospa rimananta kasushpa kawsanankuna tiyan. Manami panta mikushpallachu kawsankasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaypina supayka Jesustaka suk urku sawanman pusharkan. Chay urkumanta tukuy allpapi llaktakunata raslla kawachirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Chayta kawachishpana willarkan: —Tukuy kay allima kawanayki llaktakuna tukuy chaypi tiyakkuna ñukata kuwashka kaptin kuyki. Ñuka munashkayni runatami kusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kanka kunkurikushpa ñukata kuyaway. Chashna kuyawaptikika tukuy chay llaktakunata kanta kushkayki chaypi kamachikuk kanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chashna supay willaptinna Jesuska mana kasushpa willarkan: —Tata Diospa killkadunpi willawanchi: “Señorniki Tata Diosllata kuyay. Payllata sirvishpa kawsay.” ");
INSERT INTO qvsNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chashna Jesus willaptinna Jerusalen llaktaman supayka pusharkan. Chaypina Tata Diospa manllayba altu wasin sawanman pushashpa willarkan: —Tata Diospa wambran kashpaykika kay altumanta allpaman wishchunakuy. Urmashpaka manami nimanachinakunkichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tata Diospa killkadunpi willawanchi: “Tata Dioska angelninkunata willankasapa kanta amachashushpa kuydashunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Urmanayaptikika paykuna makinkunawan chaskishunkisapa ama rumikunapi mitkakunaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chaypina Jesuska supayta willarkan: —Chaymantapish Tata Diospa killkadunpi willawanchi: “Ama nimata yankamanta ruraychichu yachanayashpa Tata Dios yanapawankachu manachu nishpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chashna Jesus mana kasunayaptin supayka manana yacharkannachu imashnami llullachinka nishpa. Chayrayku suk tiemputa Jesusmanta ashurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Chaymanta chay chunlla chakidu allpamanta Jesus kutirkan Galilea partiman. Tata Diospa Espiritun sukaman yanapaptin rikchak laya yachak karkan. Tukuy llaktakunapi tantanakunankuna wasikunapi Jesuska yachachikurkan. Chashna yachachikuptin tukuy runakuna alabarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chashna llaktan llaktan yachachikuypi purishpa Jesuska wiñashkan Nasaret llaktanman kutirkan. Chaypi kashpa amañananshina samana diya tantanakunankuna wasiman rirkan. Chay wasipi kashpa shayarirkan Tata Diospa killkadunta leyinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chay wasi kuydak runa Jesusta suk libruta kurkan. Chay libruka karkan ñawpa yachachikuk Isaiyaspa killkashkan. Jesuska chay libruta kicharishpa kay killkaduta tarishpa leyirkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tata Diospa Espiritunka ñukatami akllawashka. Willawashka tukuy mana nimayuk llakishpa kawsak runakunata yachachinaynipa. Churawashka paykunata yachachinaynipa kushikushpa kawsanankunapa. Chaymanta kachamuwashka tukuy supaypa makinpi kawsak runakunata salvanaynipasapa. Kachamuwashka mana kawakuk runakunata kawachichinaynipa. Chaymanta kachamuwashka padesik runakunata padesichinankunamanta kichukunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tata Dios kachamuwashka runakunata willanaynipa sukaman kuyashpa yanapanankunata.” ");
INSERT INTO qvsNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus chay killkaduta leyishkanwasha chay libruta kurkan wasi kuydak runata. Chashna kushpana tiyarirkan. Tiyariptinna tukuy pi paytaka chaparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaypina willarkansapa: —Kay leyishkayni killkaduka ñukapami rimashka. Ñukaka Tata Dios kachamuwashkan runami kani. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chashna Jesus yachachikuptin tukuy runakuna almirashpankuna tapunakurkansapa: —¿Manachu kay runaka Josepa wambran? ");
INSERT INTO qvsNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chashna tapunakuptinkuna Jesuska willarkansapa: —Ariya kankunaka mana kreyiwashpa willawaykankichi: “Kanka ampikuk runa kashpaykika kikikilla ampinakuy. Kanka Kapernaum llaktapi milagruta rurashkaykita kay llaktanchipipish ruray yachanaynikunapa Tata Diosmanta shamudu runa kanaykita.” ");
INSERT INTO qvsNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kunan allita willaykichi. Tata Diospa rimananta yachachikuk runa kikin llaktanpi yachachikuptin llaktamasinkuna mana kreyinsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Ñawpa alli yachachikuk Eliyas yachachikushkan tiempu kimsa wata sokta killata mana nima tamyarkanchu. Chashna mana tamyaptin tukuy Israel llaktapi sinchi yarkay tiempu karkan. Chay yarkay tiempupi Tata Dios Eliyasta kacharkan Sidon llakta ladunpi. Eliyasta kacharkan chay Sareta llaktapi kawsak viyuda warmiman payna Eliyasta karananpa. Deverasmi kikin Israel llaktanpi aypa viyudakuna tiyarkan. Mana paykunamanchu Tata Dios Eliyasta kacharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chaymanta ñawpa alli yachachikuk Eliseopa tiempunpi Siria partipi kawsarkan suk sinchi kamachikuk runa. Paypa shutin karkan Naaman. Chay kamachikuk runa lasaru unkuyuk karkan. Chaypina yachachikuk Eliseoka paytaka alliyachirkan. Deverasmi llaktankunapi aypa runakuna chay unkuywan karkansapa. Eliseoka mana paykunataka alliyachirkansapachu mana Tata Diosta kreyiptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chashna Jesus yachachikuptin uyarishpana chay wasipi tantanakudu runakuna sukaman piñakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Paykunaka llaktankunamanta Jesusta pusharkansapa suk manllayba waykuman. Chay waykuka karkan chay llakta washanman. Chayman pushashpankuna wañuchinayarkansapa altumanta tankakushpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Chaypina Jesuska chay aypa runakunapa chawpinkunata pasashpa rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chaymanta Jesuska Nasaret llaktamanta llukshishpa rirkan Galilea parti llakta Kapernaumman. Chaypina samana diya kaptin tantanakunankuna wasipi yachachikuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chaypi allita yachachikuptin runakuna sukaman almirarkansapa sinchi kamachikuk runashina yachachikuptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chaypi tiyarkan suk unkudu runa. Payka supayuk karkan. Jesus yachachikuptin uyarishpana chay supay sinchita rimakushpa Jesusta willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Imapatí ñukaykunamanka shamushkanki, Nasaretmanta Jesus? ¡Sakiwaysapa! ¿Mana tukuyniyuk ninamanchu kachawanayaykankisapa? Ñukaka yachani Tata Diosmanta shamudu runa kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chashna chay supay willaptin Jesuska piñayashpa willarkan: —¡Upallayayna! ¡Kunanlla kay runamanta llukshiy! Chashna Jesus willaptinna tukuy pi kawaykaptinkuna supayka chay unkudutaka waktakurkan. Chaypina mana nimanachishpanachu paymanta llukshirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chayta kawashpa runakunaka sukaman manchakurkansapa. Chaypina willanakurkansapa: —Kay Jesuska sinchi kamachikuk kashpa atipan supaykunatapish llukshichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chaymanta chay runakuna famakurkansapa tukuy llaktakunapi Jesus supayta sinchita willashpa runamanta llukshichishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chaymanta Jesuska chay tantanakunankuna wasimanta llukshishpa rirkan yaykuk Simon Pedrupa wasinpi. Chaypi Simonpa suedran kalentorawan unkudu karkan. Pay unkudu kaptinna familyankuna Jesusta willarkansapa kalentoranta chiriyachipunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chashna willaptinkunana Jesuska chay unkudu warmipa ladunpi shayarishpa kumurayarkan. Kumurayashpa sinchita willarkan kalentoran chiriyananpa. Chaypina kalentoranka raslla chiriyarkan. Chay warmika atarishpa paykunapa mikunankunata rurashpa kararkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chaymanta inti yaykuptin Jesusman aypa runakuna unkudu familyankunata pusharkansapa. Paykuna rikchak laya unkuyuk karkansapa. Chaypina Jesuska chay unkudukunapa umankunapi makinta churashpa tukuyta alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chaymanta aypa runakunamanta Jesuska supaykunata llukshichirkan. Chay supaykuna llukshishpankuna kaparishpa rimarkansapa: —¡Kanka Tata Diospa wambranmi kanki! Chashna willaptinkuna Jesuska piñayashpa willarkansapa: —¡Upallaychi! Jesus mana munarkanchu supaykuna nimata willanankunapa. Paykunaka yacharkansapa Jesus Tata Diosmanta shamudu salvakuk runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chaymanta pakariykaptin Jesus chay llaktamanta llukshishpa rirkan suk chunlla likidu pampaman. Chayman riptin aypa runakuna maskarkansapa. Sukaman maskashpana tarirkansapa. Willarkansapa ama ni mayta suchushpa llaktankunallapi kiparinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chaypina Jesuska willarkansapa: —Chikan llaktakunapipish kay alli kushichina rimanata yachachikunayni tiyan. Tata Dioska kachamuwashkami tukuy runakunata yachachinaynipa alli kamachikuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chashna willashpankuna Jesuska tukuy judiyu runakunapa llaktankunapi yachachikuypi purirkan. Tantanakunankuna wasikunapi yachachikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Suk diya Genesaret kocha mañanpi Jesuska Tata Diospa rimananta yachachikuykarkan. Chaypina aypa runakuna uyarinayashpankuna tankanakushpa Jesusta nitirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chashna niti niti kaptinkuna chay kocha mañanpi Jesus kawarkan ishkay atun kanowakunata. Chay kanowakunapika mana nima tiyarkanchu. Challwa apik runakuna kanowankunata sakishpankuna atun redninkunata takshaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Suk kanowaka Simonpa karkan. Chay Simonpa kanowanpina Jesuska yaykurkan. Yaykushpana Simontaka willarkan: —Suk tipita chawpiyachipay. Tankapuptinna Jesus chaypi tiyarirkan. Chay kanowamanta Jesuska chay runakunata yachachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chay aypa runakunata yachachishkanwashana Simontaka willarkan: —Kay kanowaykita ashwanta chawpiyachiy. Chaypi chay rednikikunata sirichiychi challwata apinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chaypina Simonka willarkan: —Maestru, tuta entero manami niman suk challwata apishkanisapachu. Mana nimata tuta entero apishpaynikunapish willawaptikisapa kashkan sirichishasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Paykunaka Jesusta uyarishpa redninkunata sirichirkansapa. Chaypina aypa challwakunata apirkansapa chay redninkuna llikikunayanankaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Simonka makinwan kayarkansapa challwa apikmasinkunata chikan kanowankunata apashpa yanapak rinankunapa. Chay aypa challwakunawan ishkantin kanowankunata untachirkansapa yaka suminayanankaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Jesusta kasushkanrayku aypa challwata apirkansapa. Tukuy chayta kawashpa Pedruka tukuy challwa apikmasinkunawan sukaman manchakurkansapa. Chaypina manchakushpa Pedruka Jesuspa ñawpakninpi kunkurikushpa willarkan: —Maestru, ñukaka uchasapami kani. Chayrayku pinkakuni kanwan tantalla puriyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedeopa wambrankuna Jakobowan Juan Simonpa challwa apikmasinkuna karkansapa. Chashna tukuy paykuna sukaman manchakuptinkuna Jesus Simonta willarkan: —Ama manchakuychu. Kunanmantapacha aypa runakunata Tata Diospa rimananta yachachishpa kawsanki. Yachachinkisapa paykunapish Tata Diosta kreyishpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chashna Jesus willaptinkuna chay runakunaka chawpi yakumanta kanowankunata mañayachirkansapa. Chaypina tukuyta sakishpankuna chay oramantapacha Jesusta katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Suk diya Jesus suk llaktapi chayarkan. Chaypina suk lasaruyak runa Jesusta kawashpa ñawpakninpi kumurayashpa willarkan: —Maestru, munashpaykika atipanki kay unkuyninimanta alliyachiwayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chashna willaptinna Jesuska makinwan llankashpa willarkan: —Ariya, munani alliyachiynikita. Kunanmantapacha alliyaduna kiparinki. Chashna willaptinna chay runapa kirinka raslla alliyapurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaypina Jesuska willarkan: —Amara ni pita willayrachu alliyachishkaynita. Ñawpa yachachikuk Moises killkadunpi willashunkichi lasaru unkuynikichimanta alliyashpaykichi saserdoteman rinaykichi tiyan ofrendaykita apashpa. Sanuna kanaykita kawashuptin chay ofrendaykita Tata Diosta kunayki tiyan uchaykita perdonananpa. Chaypina tukuy runakuna yachankasapa sanu kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Chashna Jesus chay alliyachishkan runata ama ni pita parlachinanpa willaykaptinpish aypa runakunata parlachirkan. Chaymanta chay aypa runakunapish famakurkansapa alliyadu kananta. Chay almirana rurashkanta yachashpankuna aypa runakuna rirkansapa Jesusta uyarinayashpankuna. Paykunapish munarkansapa unkuyninkunamanta alliyachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Chashna aypa runakuna payman riptinkuna chunllaman Jesuska rirkan chaypi Tata Dioswan parlak. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Chaymanta suk diya suk wasipi Jesus yachachikuykarkan. Chaypina fariseo runakuna Tata Diospa rimananta yachachikuk runakunapish chayarkansapa. Paykunaka shamurkansapa tukuy Galilea parti Judea parti llaktakunamanta. Jerusalen llaktamantapish shamurkansapa. Chaykunamanta shamushpa Jesusta laduncharkansapa. Payka aypa unkudukunata alliyachirkan Tata Dios sukaman yanapaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chay diya Jesusman suk mana nima kuyuy atipak unkuduta kamillapi pusharkansapa. Chay pushak runakuna munarkansapa Jesuspa ñawpakninpi churayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chay wasipi aypa runakuna tiyaptin paykunaka mana yaykuyta atiparkansapachu. Chayrayku wasi sawanman chay unkudutaka kamillanpi pusharkansapa. Chaypina chay tejakunata surkushpa uchkurkansapa. Chaytana unkuduta kamillanpi urayachirkansapa Jesuspa ñawpakninpi churak. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chay yanapak runakunaka allita tukuy shunku kreyirkansapa Jesus alliyachinanta. Jesuska kreyinankunata yachashpa chay unkudutaka willarkan: —Wambrayni, tukuy uchaykikunamanta perdonayki. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chashna Jesus willaptin Moisespa killkadunkunata yachachikuk runakunaka fariseo runakunawan yuyayninkunapi rimarkansapa: “Kay runaka Tata Diosta piñachiykan. Iden Tata Diosshina kanayashpa kay unkuduta willashka tukuy uchankunamanta perdonananta. Tata Diosllami atipan uchakunata perdonayta.” ");
INSERT INTO qvsNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chashna yuyayninkunapi rimaptinkuna Jesuska chayta yacharkan. Chayrayku willarkansapa: —¿Imapatí washanchawaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ñuka kay unkuduta ishkay layata atipayman willayta. Munashpayni willayman: “Uchaykikunamanta perdonayki.” Chaymanta willayman: “Atarimushpa puriy.” Allita puriptin kawashpa yachankichi alliyachishkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kunanlla kay unkuduta alliyachisha. Alliyachiptini yachankichi ñuka sielumanta shamudu runa kanaynita. Yachankichi kay allpapi tukuy runakunapa uchankunata perdonayta atipanaynita. Chayta rimashkanwasha Jesuska chay mana kuyuy atipak runata willarkan: —¡Atarimuy! Kamillaykita apashpa wasikiman rillay. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chashna Jesus willaptinna chay unkudu runaka utkakushpa alliyaduna atarimurkan chay aypa runakuna kawaykaptinkuna. Atarimushpa chay sirishkan kamillanta apishpa wasinman rirkan. Sukaman kushikushpa rirkan Tata Diosta alabaypi. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chashna chay unkudu runa alliyaptinna tukuy kawak runakuna sukaman almirashpankuna Tata Diosta sukaman alabarkansapa. Chaypina manchakushpankuna willanakurkansapa: —Kunanka almirana layakunata kawashkanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chay unkudu runata alliyachishkanwasha suk llaktaman Jesus rirkan. Chaypi chayashpa suk kullki kobrakuk runawan kawanakurkan. Chay runaka romano gobiernupa kullkita kobrakuykarkan. Paypa shutin karkan Levi. Levika kullki chaskikunan mesa ladunpi tiyaridu karkan. Payta kawashpana Jesuska willarkan: —Shamuy, ñukata katiway. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chashna Jesus willaptinna Levika tiyaridu kashkanmanta atarirkan. Payka tukuy chay kullki kobrakushkanta sakishpa Jesuswan tantalla purirkan disipulun kananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Suknin diya Jesusta sukaman kuyashpa Levika suk fiestata rurarkan wasinpi. Chay fiestata rurashpa Levika kullki kobrakukmasinkunata llaktamasinkunatapish konvidarkansapa. Jesuska disipulunkunawan chay runakunawan tantalla suk mesallapi mikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chaypina fariseo runakuna Tata Diospa rimananta yachachikuk runakunawan Jesusta kawarkansapa. Paykunaka Jesuspa disipulunkunata kallarirkansapa yuyayta. Willarkansapa: —¿Imapatí kankunaka kobrakuk runakunawan uchasapa runakunawan tantalla mikuykankichi upyaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chashna disipulunkunata willaptinkuna Jesuska willarkansapa: —Sanu runa mana ampik runata maskanchu mana unkudu kashpa. Unkudu runa ampik runata maskan alliyayta munashpa. Kankuna mana alli rurak runakuna kashpaykichi unkudu runakunashina kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ñuka shamushkani tukuy uchasapakunata kayak. Manami shamushkanichu mana uchayuk yuyanakuk runakunata kayak. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chashna Jesus yachachikuptin runakuna piñakushpa willarkansapa: —Juanpa disipulunkuna chaymanta fariseokunapa disipulunkuna churadu diyakunapi Tata Diosta kuyanankunarayku mana nimata mikunsapachu. Sukaman orashpankuna kawsansapa. Kanpa disipuluykikunaka tukuy layata mikushpa upyashpankuna kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chashna willaptinkuna Jesus kay ejempluta willarkansapa: —Suk funsiata rurashpaykichi noviowan tantalla kashpaykichi kushikushpa mikunkichi. Mana kasaranan diyachu konvidadukunaka sasinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Funsia tukuptinna novio sakiptinkuna chaypira churadu diyakunata mikunata mana mikunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chashna Jesus yachachikushpa chikan ejemplutapish willarkansapa: —Mana ni pi mushuk llachapata tipishpa mawka llachapapi apichinmanchu. Chashna mushuk llachapata tipiptin wakllidu kiparin. Chaymanta mawka llachapapika mushuk retaso mana allichu rikurin. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mana ni pi churanmanchu llullu vinuta mawka vinu churana kapachupi. Chaypi churaptin llullu vinu timbushpa mawka kapachuta pachyachinman. Kapachu llikikuptin vinuka usunman. Chay llikikudu kapachupish wakllidu kiparin. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chayrayku llullu vinuta mushuk vinu churana kapachupi churansapa ama vinu usunanpa. Ñukapa yachachikunaynika mushuk vinushinami. Kankunapa yachachikunaykichika mawka kapachushinami. Chayrayku yachachikuptini mana munankichichu kasuwayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chaymanta yachachikunaykichi mawka vinushina kaptin chayllata munankichi. Chayrayku mana munankichichu ñukapa yachachikunaynita mushuk vinushina kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Chaymanta suk samana diya Jesus disipulunkunawan suk llaktaman rirkansapa. Rishpankuna trigu chakra chawpinta purirkansapa. Chaypina Jesuspa disipulunkuna triguta tipishpankuna makinkunapi ishkushpa mikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chayta kawashpankuna fariseokuna willarkansapa: —¿Imapatí disipuluykikuna samana diya kaykaptin triguta pallaykansapa? Chayta rurashpa Moisespa kamachikunankunata mana kasuykansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chashna fariseokuna willaptinkuna Jesuska willarkansapa: —¿Manachu leyishkankichi ñawpa kamachikuk David rurashkanta? Suk diya payka purikmasinkunawan sukaman purishpankuna yarkarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yarkaymanta kashpa Tata Diospa wasinpi yaykurkansapa. Chaypi Davidka mikurkan Tata Diospa churadu pankunata. Purikmasinkunatapish kararkan. Chay laya pankunaka saserdotekunallapa karkan. Chayta mikushpankunapish mana uchallikurkansapachu. Chashnashina disipuluynikunata ama willaychichu uchallikuykanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ñuka sielumanta shamudu runa kashpayni allita yachachiykichi samana diya imakunami alli ruranaykichipa imakunami mana allichu ruranaykichipa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chaymanta suknin samana diya Jesus tantanakunankuna wasipi yaykurkan. Chaypina kashkan kallarirkan yachachikuyta. Chay wasipika suk kaspirayadu alli ladu makiyuk runa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chaypina Moisespa killkadunta yachachikuk runakuna fariseokunawan sukaman Jesusta chapapayarkansapa. Kawanayarkansapa samana diya chay runata alliyachinkachu manachu nishpa. Paykunaka awtoridarkunapi Jesusta sukaman chatanayarkansapa samana diya unkuduta alliyachiptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuska yacharkan chatanayaykanankunata. Chaypina paykunata mana manchashpa chay kaspirayadu makiyuk runataka willarkan: —Rillay chay runakunapa chawpinkunapi shayarik. Chashna Jesus willaptin payka shayarik rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chawpinkunapi shayariptinna Jesuska chay chatanayak runakunata willarkansapa: —Ñuka kankunata tapuykichi: Moisespa killkadunpi ¿imatatí willawanchisapa? ¿Willawanchisapachu samana diya allita mana allita rurananchikunapa? ¿Samana diya suk runata alliyachinchimanchu? ¿Suk runata kawapayanchimanchu wañunanpa? ");
INSERT INTO qvsNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mana nimata ayniptinkuna Jesuska tukuy chay chatanayak runakunata sukta sukta kawarkansapa. Chaypina chay kaspirayadu makiyuk runataka willarkan: —Makikita chutachiy. Chay runa Jesusta kasushpa makinta chutachishkan oras alliyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jesus chay runata alliyachiptin chay chatakunayak runakuna kawashpankuna sukaman piñakurkansapa. Chaypina sukwan sukwan willanakurkansapa: —¿Imatatí rurashunchisapa kay runataka? ");
INSERT INTO qvsNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chaymanta suk diya Jesus suk urkuman rirkan orak. Chay urkupi tuta entero Tata Dioswan parlarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chaymanta punchawyaptin ladunman tukuy disipulunkunata kayarkansapa. Tukuy paykunamanta chunka ishkayta akllarkan paywan tantalla purinankunapa. Chay aklladu disipulunkunataka willarkansapa paykunapish yachachikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Suk aklladu disipulun karkan Simon. Jesuska paytaka shutiyachirkan Pedru kananpa. Chaymanta karkansapa Simonpa wawkin Andres, Santiago, Juan, Felipi, Bartolome, ");
INSERT INTO qvsNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas. Chaymanta suk karkan Alfeopa wambran Santiago. Chaymanta suk karkan Simon. Payka romano gobiernuta mana munarkanchu nima kasuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Chaymanta suk disipulun karkan Santiagopa wawkin Judas. Suk karkan Judas Iskariote. Payka suk tiempu washan Jesusta rantikurkan wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chay chunka ishkay disipulunkunata akllashkanwasha chay urkumanta suk pampayninman Jesuska paykunawan tantalla urayamurkan. Chay pampapi aypa runakuna Judea partimanta Jerusalen llaktamanta atun kocha ladunpi Tiro Sidon llaktakunamantapish tantanakurkansapa. Chay aypa runakuna rirkansapa Jesusta uyarinankunapa. Aypa unkudukunapish rirkansapa Jesus alliyachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","19","Chaypina kikin atipashpa Jesuska aypa unkudu runakunata alliyachirkansapa. Supaykuna unkuchishkan runakunatapish alliyachirkansapa. Aypa runakuna Jesusta llankanayarkansapa unkuyninkunamanta alliyayta munashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chaymanta tukuy chay aypa runakunata alliyachishkanwasha Jesuska disipulunkunata chapashpa willarkansapa: —Mana nimayuk kashpaykichipish kushikuypuru kankichi. Kankunami Tata Diospa mandunpi kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kunan tiempu yarkashpa kawsashpaykichipish kushikuypuru kankichi. Tata Dios kankunata saksachishunkichi. Kunan tiempu wakashpa kawsashpaykichi kushikuypuru kankichi. Tata Dios kushichishuptikichi asikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ñuka sielumanta shamudu runami kani. Runamasikichi kankunata sukaman ñukarayku chiknishuptinkuna Tata Dios kushichishunkichi. Paykuna washanchashushpaykichi tantanakunankunamanta karkushuptikichi Tata Dios kushichishunkichi. Ñukarayku runakuna mana alli kanaykichita rimaptinkunapish Tata Dios kushichishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chashna chiknishuptikichipish sukamanlla kushikuychi. Yachankichi sielupi premyuykichita chaskinaykichita. Chay chiknishuknikichipa ñawpa awilunkunapish idenllata Tata Diospa rimananta yachachikuk runakunata chiknirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kankuna tukuy layayuk kaptikichi llakichiykichi. Kay tiempullapa tiyapushunaykichillawan kushikuykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kay tiempulla saksadu kawsaptikichi llakichiykichi. Suk tiempukaman yarkankichi. Kay tiempulla asikushpa kawsaptikichi llakichiykichi. Suk tiempukaman llakishpa kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tukuy runakuna kankunata sukaman alabashuptikichi llakichiykichi. Paykunapa ñawpa awilunkuna idenllata alabarkansapa llulla yachachikuk runakunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesuska yachachikuypi katishpa willarkansapa: —Kankuna kreyiwak runakuna kaptikichi allita yachachiykichi. Tukuy chiknishuknikichi runakunata kuyaychi. Paykunata yanapashpalla kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tukuy mana alli yuyashuknikichi runakunata allillata kuyashpa yanapaychi. Tukuy piñachishuknikichi runakunapa Tata Diosta roygaychi yanapanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Suk runa chiknishushpa uyaykipi sakmashuptinka ama kutipaychu. Suk ladu uyaykitapish kuy sakmashunanpa. Suk runa sakuykita kichushuptikika ama michaychu kamisaykitapish apananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pipish kashpa suk imata mañashuptiki ama michashpalla kuy. Chaymanta suk runa imaykita kichushuptikika ama kutin mañaynachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kankuna munankichi runamasikichi kuyashushpaykichi allita rurashunaykichipa. Chashnashina kankunapish runamasikichita allita rurashpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kankunaka kuyashuknikichi runakunallata kuyashpaykichika Tata Diosta mana kushichiykankichichu. Tukuy uchasapa runakunapish kuyak runakunallata kuyansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kuyanakukmasikichillawan yanapanakushpaykichika iden uchasapakunashinalla kawsankichi. Chashna kawsashpaykichi Tata Diosta mana kushichinkichichu. Kankunaka chiknishuknikichitapish kuyanaykichilla tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chaymanta kankuna kullkikichita kutichikuk runakunallata prestadu kushpaykichika Tata Diosta mana kushichiykankichichu. Tukuy uchasapa runakuna sukwan sukwan prestanakunsapa ashwan aypata chaskiyta munashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Chayrayku kankunaka chiknishuknikichitapish kuyanaykichilla tiyan. Tukuy runakunata yanapanaykichi tiyan. Pipish kaptin suk imata mañashuptikichika kuychilla ama kutichishunanta yuyashpa. Kankuna tukuy pi kuyashpa kawsaptikichi Tata Dios sukaman yanapashunkichi kushichishunkichi. Paymi sukaman yachaysapa kashpa tukuy mana alli rurak runakunata tukuy mana kuyakuk runakunata kuyashpalla yanapan. Chashna kankuna Tata Diosshina kuyashpa yanapashpa kawsashpaykichika paypa wambrankuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tata Diosnikichi tukuy runakunata llakichishpa yanapan. Chashnashina kankunapish Tata Diospa wambrankuna kashpaykichi payshina llakichikuk runakuna kaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Chaypina Jesuska yachachikuyllapi katishpa willarkansapa: —Ama ni pita washanchashpa yuyaychichu. Kankuna mana ni pita yuyaptikichi Tata Diospish kankunapa allillata yuyanka. Chaymanta ama ni pita chiknishpa kastigachinayaychichu. Mana kastigachinayaptikichi Tata Diospish kankunata mana kastigashunkichichu. Tukuy pita perdonanaykichi tiyan. Chashna perdonaptikichi Tata Dios kankunatapish perdonashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pitapish kaptin mana michashpa yanapaychi. Chashna mana michashpa yanapaptikichika Tata Dioska kankunatapish ashwan sukaman allita yanapashunkichi. Kankuna runamasikichita rurashkaykichishina Tata Dios kankunatapish rurashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chashna Jesus yachachikushpa suk ejempluta parlachikurkan: —Suk runa mana kawakuk kashpa mana kawakukmasinta mana ni mayta atipanchu pushayta. Pushanayashpaka suk rarkapi ishkantin urmanmansapa. Kankuna mana kreyiwashpaykichika iden mana kawakuk runakunashina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Suk disipulu maestrunmanta mana ashwan alli yachakchu. Disipulu allita yachakushpa maestrunshinalla yachan. Chayrayku ñuka yachachikuptini allita uyariwaychi kankunapish allita yachanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kankuna mana uchaykichita riksinayashpaykichi ñawinpi kaspi tiyapuk runashina kankichi. Ñawikichipi suk kaspi tiyaptin munankichi runamasikichipa ñawinmanta takshasillu susyata surkuyta. Chaykamanka kikikichipa ñawikichipi kaspi tiyaykaptin mana nima mallinkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kankunapa ñawikichipi kaspi tiyaykaptin ¿imashnatí animukunkichi wawkikichita willayta: “Ñuka ñawikimanta chay susilluta surkunayani” nishpa? Kankuna allipi tukushpa mana allikunata ruraykankichi. Chayrayku uchallikuykankichi. Kikikichipa ñawikichimantara kaspita surkushpara wawkikichipa ñawinmanta taksha susilluta atipankichiman surkuyta. Uchaykichita sakishpa kawsashpaykichira wawkikichita atipankichi yanapashpa yachachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesuska yachachikuyllapi katishpa willarkansapa: —Tukuy allima kaspi sukaman allimata wayuchakun. Mana alli kaspika mana valekta wayuchakun. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tukuy alli wayuchakuk kaspitami wayunmanta riksinchi. Kashayuk kaspika mana wayuchakunchu igo wayuta. Chaymanta sarsa waska mana wayuchakunchu uva wayuta. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chashnami alli yuyayuk runa allikunallata rimashpa kawsan. Mana alli yuyayuk runaka mana allikunata rimashpa kawsan. Rimananllamanta riksinchi suk runata alli yuyayukchu manachu nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Chaymanta Jesuska yachachikuyllapi katishpa chay runakunata willarkansapa: —Willashkaynita mana ruranayashpaykichika ¿imapati “Maestru, Maestru” niwankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mash uyariwaychi. Suk ejempluta parlachiykichi yachanaykichipa maykan runami ñukaman shamushpa kasuwashpa willanaynita ruran. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Suk runa alli yuyayuk kashpa wasinta ruran sinchi allpapi ukuta aspishpa. Payka uku aspidupi pirkata churaptin alli ruradu wasi kiparin. Yaku untaptin sukaman kallpaptinpish chay wasi mana nima tikranchu alli ruradu kashpa. Kankuna willashkaynita allita rurashpa kawsashpaykichika sinchi allpapi wasinta rurak runashina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Chaymanta suk mana alli yuyayuk runa wasinta mana ukuta aspishpa ruran. Chaymanta tamyaptin yaku untaptin sukaman kallpaptin chay wasika urman mana alli ruradu kashpa. Kankunaka willashkaynita mana rurashpaykichika iden mana alli wasinta rurak runashina kankichi. Yuyaynikichi kunanlla wakllin. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chay aypa runakunata yachachishkanwasha Kapernaum llaktaman Jesuska rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chay llaktapi tiyarkan romano gobiernupa soldadukunapa kapitannin. Paypa tiyarkan alli kuyadu wiwachun. Chay wiwachunka fatal unkudu kashpa wañunayaykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chay kapitanka yacharkan Jesus aypa unkudukunata alliyachiykananta. Chayta yachashpa judiyu ansianukunata kacharkan Jesusta willanankunapa wasinman shamunanpa wiwachunta alliyachik. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chay ansianukuna Jesusta ladunchashpankuna sukaman willarkansapa rinanpa chay kapitanpa wiwachunta alliyachik. Willarkansapa: —Alli kanman chay kapitanta yanapanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Payka romano kaykashpapish sukaman munawashpankuna yanapawashkasapa. Paymi tantanakunaynikuna wasita rurachishka. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chashna willaptinkunana chay kapitanpa wasinman Jesuska paykunawan rirkan. Manarapish wasinpi chayaptin chay kapitanka amigunkunata kacharkan Jesusta willak: —Maestru, chay kapitanka pinkakunshi wasinpi chayanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Manashi nimachu payka kanwan parlananpaka. Chayrayku judiyu ansianukunallata kachashka willashunanpa wiwachunta alliyachipunaykipa. Karullamantashi willaptiki wiwachunka alliyanka. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kashnami willachishunki: “Tata Diosmi kantaka kamachishunki. Ñukapapish tiyan kamachiwakninikuna. Paykuna kamachiwaptinkuna kasunayni tiyan. Chaymanta ñuka soldadukunata kamachiptini paykuna kasuwansapa. Suk soldaduta suk mayman rinanpa willaptini rin. Sukta shamunanpa willaptini shamun. Suk wiwachuyni imatapish rurananpa willaptini ruran. Chayrayku karullamanta wiwachuynita alliyachipay.” ");
INSERT INTO qvsNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chay kapitan willachishkanta uyarishpa Jesuska sukaman almirarkan. Chaypina chay aypa katik runakunata chapashpa willarkansapa: —Allita willaykichi. Tukuy judiyumasinikunamanta mana niman suk runa kay romano kapitanshina ñukata kreyiwankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chashna Jesus willaptinna chay kapitan kachashkan runakunaka kutirkansapana. Kapitanpa wasinpi chayashpankuna tarirkansapa wiwachuntaka alliyadutana. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesus chay kapitanpa wiwachunta alliyachishkanwasha Nayin llaktaman rirkan. Chay llaktaman Jesuswan tantalla disipulunkuna chaymanta aypa runakuna rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesus chay llaktapi chayashpa kawarkan suk wañuduta pampak pushaykaptinkuna. Chay wañudu karkan viyuda warmipa chaylla wawan. Chay viyudata llakichishpa aypa llaktamasinkuna tantalla riykarkansapa wañuduta pampak. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chaypina Jesuska chay warmita kawashpa sukaman llakichishpa willarkan: —Amana wakakuynachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chashna chay warmita willashpa Jesuska wañuduta laduncharkan. Chaypina wañuduta pushaykak runakunaka shayarirkansapa. Jesus wañudupa kamillanta llankashpa willarkan: —Wambrayni, atarimuyna. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chashna willaptin chay wañudu waynaka kawsamurkan. Tiyarimushpa kallarirkan rimakuyta. Chaypina Jesuska chay kawsachimushkan waynata mamanta kurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chayta kawashpankunana tukuy chay aypa runakuna sukaman manchakurkansapa. Tata Diosta alabashpankuna willarkansapa: —Kay wañuduta kawsachimushpa Jesuska sukaman alli yachachikuk runami. Sukkunaka rimarkansapa: —Tata Diosmi shamushka yanapawakninchikuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tukuy Judea partipi kawsak runakuna yacharkansapa Jesus chay wañudu waynata kawsachimushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Chaypina Juanpa disipulunkuna payta willarkansapa Jesus ruraykananta aypa almirana ruranata. Chayta yachashpa Juanka ishkay disipulunkunata kayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Paykunata Jesusman kacharkansapa yachanayashpa pay Tata Diosmanta shamudu runachu manachu nishpa. Mana pay kaptinka chikanta shuyanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanpa disipulunkuna Jesusta tapuk rirkansapa. Ladunchashpankuna willarkansapa: —Juan ñukaykunata kachamuwashkasapa tapukniki: ¿Kanchu deveras Tata Diosmanta shamudu runa kanki? Mana kan kaptikika chikanta shuyashasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mana aynishpara chay diya Jesuska aypa runakunata unkuyninkunamanta nanayninkunamanta alliyachiykarkansapa. Chaymanta supay unkuchishkan runakunata alliyachiykarkan. Chaymanta aypa mana kawakuk runakunapa ñawinkunata alliyachiptin allitana kawakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chay rikchak laya unkuyuk runakunata alliyachishkanwasha Jesuska chay ishkay runakunata willarkansapa: —Rillaychi Juanta willak tukuy kawashkaykichita tukuy uyarishkaykichita. Willaychi mana kawakuy atipakkunata alliyachishkaynita. Willaychi mana puriy atipakkunata lasaruyak runakunatapish alliyachishkaynita. Ñuka alliyachiptini upa runakunapish uyarikunsapana. Chaymanta willaychi wañudukunata kawsachimushkaynita. Ñuka tukuy mana nimayuk runakunata yachachiykanisapa Tata Dios salvakuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chaymanta Juantaka willaychi pipish kashpa mana pinkakushpa ñukata allita kreyiwashpa kushikuypurumi kawsanka. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa disipulunkuna kutiptinkuna Jesuska tukuy paywan kiparik runakunata willarkansapa: —¿Imatatí chunlla pampapika rishkankichi kawak? ¿Rishkankichichu pintuta wayra kuyuchiptin kawak? ");
INSERT INTO qvsNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mana chayta kawak rishpaykichika ¿imatatí rishkankichi kawak? ¿Allima llachapayuk runatachu? Kankunaka yachankichi allima llachapayuk runakuna rinankunata sinchi kamachikukkunapa wasinkunallaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Imatatí rishkankichi kawak? ¿Alli yachachikuk runatachu? Ariya, deverasmi rishkankichi alli yachachikuk runata kawak. Payka tukuy alli yachachikukkunamanta ashwan alli yachachikukmi. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tata Dios killkadunpi Juanpa rimarkan: “Ñukaka suk alli yachachikukta kachasha tukuy runakunata willananpa kachamushkayni runata allita chaskinankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Allita willaykichi. Chay yachachikuk Juanka tukuy runakunamanta ashwan alli yachakmi. Chashna Juan ashwan alli yachak kaykaptinpish Tata Diospa mandunpi mana nima yachak yuyanakuk runakuna Juanmanta ashwan yachaysapakunami. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juan yachachikushkanta uyarishpankuna aypa runakuna yacharkansapa Tata Dios alli rurak kananta. Romano gobiernupa kullkinta kobrakuk runakunapish Juanta uyarishpankuna bawtisakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo runakunawan Tata Diospa kamachikunanta yachachikuk runakuna mana munashkasapachu Tata Dios nimapi yanapanankunapa. Chayrayku mana Juanman rishkasapachu bawtisakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chaypina Jesus yachachikuyllapi katirkan: —¿Imashnatí yachachiykichiman? ¿Ima ejempluwantí yachachiykichiman? ");
INSERT INTO qvsNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kankunaka plasapi tiyarishpa pukllak wambrakunashinami kankichi. Paykunaka pukllakmasinkunata kaparikunsapa: “Ñukaykuna kenata pukuptinikuna kankuna mana tushushkankichichu. Llakinapa laya kantuta kantaptinikuna mana nima wakashkankichichu.” ");
INSERT INTO qvsNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kankuna chay pukllak wambrakunashina mana nimawan agradakunkichichu. Juan mana panta mikuptin mana vinuta upyaptin rimankichi supayuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ñuka sielumanta shamudu runa mikuptini upyaptini kankuna rimankichi mikundero upyandero kanaynita. Chaymanta rimankichi uchasapa runakunapa romano awtoridarkunapa kullki chaskikuk runakunapa purikmasinkuna kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Chashna yuyawaptikichipish willaykichi: Tukuy pi allita rurashpa kawsashpankuna runamasinkunata kawachinsapa yachaysapa kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chaymanta suk fariseo runa Jesusta konvidarkan wasinpi rinanpa mikuk. Chashna konvidaptin Jesuska rirkan. Chaypina mesapi mikuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chay fariseopa llaktanpi suk waynandera warmi kawsarkan. Chay warmika yacharkan chay fariseopa wasinpi Jesus chayashkanta. Chaypina rirkan Jesusta tarik. Suk yurak rumimanta ruradu botellapi mishkilla asnak wirata apashpa Jesusta laduncharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chay warmika kumurayashpa Jesuspa chakin kuskapi wakakurkan. Sukaman wakakushpa ñawin illiwan Jesuspa chakinta mayllapurkan. Chukchanllawan chakichipushpa chakinta mucharkan. Chaymanta chay mishkilla asnak wirata Jesuspa chakin sawapi icharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chayta kawashpana chay konvidak fariseoka shunkun ukullapi rimarkan: “Kay Jesuska deveras Tata Diospa rimananta yachachikuk runa kashpaka kay warmita riksinman uchasapa kananta.” ");
INSERT INTO qvsNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus yuyayninta yachashpa willarkan: —Simon, suk imata willanayayki. Chaypina chay fariseoka aynirkan: —Maestru, suk imata willawanayashpaka willaway. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chashna chay fariseo runa willaptinna Jesuska willarkan: —Ishkay runakuna suk patronmanta kullkita prestadu surkurkansapa. Suk runa surkurkan pichka pachak kullkita. Sukka surkurkan pichka chunkallata. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Chaymanta chay patronka kutichinankunapa willaptinna mana nima kullkiyukchu karkansapa kutichikunankunapa. Paykuna mana kutichiyta atipaptinkuna chay patronka ishkantinkunata perdonarkansapa ama kutichinankunapa. Kunanka willaway. ¿Maykan kullkita debikuk runatí chay patrontaka ashwan allita kuyan? ");
INSERT INTO qvsNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chashna Jesus willaptinna Simonka willarkan: —Ñukaka yuyani chay ashwan aypa kullkita surkushkan runa ashwan allita patronta kuyananta. Chashna willaptinna Jesuska willarkan: —Allitami ayniwashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chaypina Jesuska chay warmita chapashpa Simonta willarkan: —¿Kawashkankichu kay warmi chakinita mayllaptin? Wasikipi chayaptini kanka mana yakuta kuwashkankichu chakinita mayllanaynipa. Kay warmika ñawin illiwan chakinita mayllapashka. Chaymanta chukchanwan chakichipashka. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kanka mana nima muchawashkankichu. Kay warmika wasikipi chayamushkaynimantapacha chakinipi muchawashka. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Chaymanta kanka mishkilla wirata mana nima umaynipi ichashkankichu. Kay warmika chay mishkilla asnak wirata chakini sawanpi ichashka. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Payka yachan tukuy uchankunata perdonanaynita. Chayrayku sukaman kuyawashpa chakinita mayllapashka. Kanka yuyanakunki pishillata uchayuk kanaykita. Chayrayku mana munankichu perdonanaynipa. Chayrayku mana yakachu kuyawanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chashna Simonta willashpa Jesuska chay warmitaka willarkan: —Uchaykikunamanta perdonayki. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chashna Jesus willaptinna konvidadu runakuna sukwan sukwan tapunakurkansapa: —¿Imashnatí kay runaka atipan uchakunata perdonayta? Tata Diosllami atipan uchata perdonayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Chayta uyarishpana Jesuska chay warmitaka willarkan: —Kanmi tukuy shunkuykimantapacha kreyiwashkanki. Chayrayku tukuy uchaykita perdonani. Kushikushpana rillay wasikiman. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaymanta Jesus aypa llaktakunapi yachachikuypi purirkan. Payka tukuy runakunata willarkansapa Tata Dios sukaman alli kamachikuk kananta. Chay chunka ishkay disipulunkunaka paywan tantalla puriksapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jesus unkuyninmanta alliyachishkan warmikuna payta yanapaypi katirkansapa. Sukkunata alliyachirkansapa supaykunata llukshichishpa. Mariya Magdalenapish Jesustaka katirkan. Paymanta Jesuska kanchis supaykunata llukshichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chaymanta suk warmi Juana Jesusta katirkan. Juanapa kusanpa shutin karkan Kusa. Chay runa Kusa karkan sinchi awtoridar Herodespa atun wasinpi kamachikuk. Chaymanta Susanawan aypa warmikunapish Jesusta katirkansapa tiyapunankunawan tukuy layapi yanapashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jesus yachachikuypi puriptin aypa runakuna llaktankunamanta llukshirkansapa kawanayashpankuna. Chay aypa runakuna tantanakuptinkuna Jesuska suk ejempluta parlachirkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Suk runa rirkan tarpukuk. Murukunata shikwashpa tarpuptin sukkuna urmarkansapa ñanpi. Chay ñanka sukaman sarudu kashpa sinchi allpa karkan. Chay sinchi allpapi murukuna urmaptin pishkillukuna mikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Suk murukuna urmarkansapa rumisapa allpapi. Chay rumisapa allpapi murukuna urmaptin tipillata wiñarkan. Chaymanta chakirkansapa mana ñupu ñupu allpa kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Suk murukuna urmarkansapa kashasapa kiwa ukunpi. Chaypi wiñaykaptinkuna chay kashasapa kiwakuna makarkansapa chakinankaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Suk murukuna urmarkansapa allima allpapi. Chaykunaka sukaman allimata wiñashpa aypata wayuchakurkansapa. Suk murumanta pachakta wayuchakurkan. Chaykunata yachachishpankuna Jesuska sinchita rimakushpa willarkansapa: —Kankuna uyarikuk kashpaykichika kay yachachikunaynita allita rinrillikuychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesus yachachikuptinna disipulunkuna yachachikunanta mana entiendishpankuna tapurkansapa: —¿Imatatí yachachiwanayankisapa chay muru tarpudupa ejempluta willawashpaykisapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chashna tapuptinkuna Jesuska willarkansapa: —Tata Dios yachachishuykankichi paypa mandunpi yaykunaykichita. Manara yachachishushkaykichita ñami yachachishuykankichina. Chay mana kreyiwakkunata ejemplukunata yachachinisapa kawashpapish mana kawakuk runakunashina kiparinankunapa. Uyarishpapish mana uyarikukshina kiparikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jesuska yachachikuyllapi katirkan: —Kashna chay ejemplu riman: Tata Diospa rimananka murukunashinami. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chaymanta aypa runakuna Tata Diospa rimananta uyarishpapish mana allitachu shunkullikunsapa. Chay runakunaka sarudu sinchi allpashinami. Supay chay murukunata mikuk pishkillukunashina llullachishpa pantachichin ama Tata Diosta kreyishpa salvadu kanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tata Diospa rimananta kushikuypuru chaskik runakunaka rumisapa allpapi urmak murukunashinami. Chashna kushikuypuru kreyishpankunapish mana sapiyukshina kashpana suk tiempullata Tata Diosta katinsapa. Paykunaka nanayta llakita mallishpana manana munansapanachu Tata Diosta katiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Chaymanta suk runakuna Tata Diospa rimananta uyarishkankunamanta tipimanta tipimanta munanankunallata rurashpa kawsansapa. Kullkiyashpa vanidarkushpalla kawsansapa. Chay laya runakunaka iden kashasapa allpapi wiñak murukunashinami. Mana nima wayuchakunsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Chaymanta suk runakuna Tata Diospa rimananta tukuy shunku uyarishpa kasushpa kawsansapa. Paykunaka alli allpapi urmadu murukunashinami. Aypata wayuchakuk murukunashina tukuy shunku Tata Diosta kreyishpa mana shaykushpa kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesuska ejemplukunawan yachachikuyllapi katirkan: —Suk alkusata apichishpa mesapi churanchisapa tukuy wasipi yaykuk runakuna kawakunankunapa. Mana ni pi alkusata apichishpa pakanchimanchu suk ollawan wichkashpa. Nima kawitu sikinpi pakanchimanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chay apichidu alkusa mesapi churadu yachachikunaynishinami. Yachachikunayni tukuy runakunata riksichin upallalla rimashkankunata pakakudu rurashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chayrayku yachachikunaynita allita uyariychi. Allita kreyiwashpa kawsaptikichi Tata Dios ashwanta yanapashunkichi ashwanta yachanaykichipa. Mana allita kreyiwashpa kawsaptikichika Tata Dioska chay tipi yachashkaykichita kichushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuspa maman wawkinkunawan rirkansapa payta kawak. Chaypina paykunaka mana atiparkansapachu Jesusta ladunchayta aypa runakunapa chawpinkunapi yachachikuykaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chay runakuna Jesustaka willarkansapa: —Mamaykiwan wawkikikunami washapi shuyashuykansapa kawashunayashpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chaypina Jesuska willarkansapa: —Tukuy Tata Diospa rimananta uyarishpa rurashpa kawsak runakunami ñukapa wawkinikuna mamaynikuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chaymanta suk diya atun kanowapi Jesuska disipulunkunawan tantalla yaykurkansapa. Chaypina disipulunkunata willarkansapa: —Akuychi kay kochata chimbaypachi. Chashna Jesus willaptinkunana kallarirkansapa chimbayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chay kochata chimbaykaptinkunana Jesuska puñurkan. Puñuykaptinna sinchi wayra tiyarkan. Sukaman sinchi wayrawan yakuka kanowapi yaykurkan sumichinayanankaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaypina disipulunkunaka manchakushpankuna Jesustaka rikchachishpa willarkansapa: —¡Maestru, mash kaway! ¡Ñami suminayaykanchisapana! Chaypina Jesuska atarimushpa chay sinchi wayrataka chay olaskunataka willarkan sampayananpa. Chaypina chay wayraka sampayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wayrata sampayachishkanwasha Jesuska chay disipulunkunataka willarkan: —¿Ariya manarachu allitara kreyiwankichi? Chaypina disipulunkunaka sukaman manchakushpa almirashpankuna tapunakurkansapa: —¿Pití kay runaka? ¡Wayrata yakuta willashpalla sampayachin! ");
INSERT INTO qvsNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus disipulunkunawan chay kochata chimbashpa chayarkansapa Gerasa partipi. Gerasa karkan Galilea parti kocha chimbaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chay kanowamanta Jesus urayaptinna llakta ladunmanta suk supayadu runa laduncharkan. Unay tiemputana chay runaka mana llachapayuk mana nima wasipichu kawsarkan. Payka wañudukuna pampanankuna machaykunapi kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Aypa kuti supayka chay runataka yanaparkan mana allita rurananpa. Llaktamasinkuna aypa kuti waskawan kadenakunawan chay runapa makinta chakinta wataksapa. Chashna wataptinkuna chay runaka tipiklla. Supayka chunlla machaykunaman paytaka pushak. Chaypina chay supayadu runa ladunchaptin Jesuska supayta willarkan chay runamanta llukshinanpa. Chashna willaptin chay runaka manllaybata kaparikushpa Jesuspa ñawpakninpi kunkurikushpa willarkan: —¡Kanka sielupi kawsak Tata Diospa wambran kaykashpayki ama ñukata amichiwaychu! ¡Roygayki ama ninaman kachawanaykipa! ");
INSERT INTO qvsNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chashna chay runa willaptinna Jesuska tapurkan: —¿Ima shutiti kanki? Chaypina payka aynirkan: —Legion shutimi kani. Chay runaka chashna willarkan aypa supaykuna paypi kawsaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chaypina chay supaykuna willarkansapa ama kachanankunapa mana tukuyniyuk nina rawray ukuman. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chay chunlla urkupi aypa kuchikuna tiyarkan. Chayta kawashpana supaykunaka Jesusta roygarkansapa chay kuchikunapi yaykuk rinankunapa. Chashna roygaptinkuna Jesuska almitirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chaypina chay runamanta tukuy supaykuna llukshishpankuna rirkansapa kuchikunapi yaykuk. Paykunapi yaykuptinkunana sukaman kallpashpankuna urkumanta sinkushpa yakupi sipikurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chayta kawashpana chay kuchikuna kuydak runakuna sukaman manchakurkansapa. Kallparkansapa tukuy llaktapi chakrakunapi kawsak runakunata kawashkankunata parlachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chayta uyarishpankuna tukuy runakuna rirkansapa kawak sipikudu kuchikunata. Chayashpana tarirkansapa Jesuspa ladunpi tiyariduta chay aypa supayuk kashka runata. Payka alli llachapakudu alliyaduna karkan. Payta kawashpankuna sukaman manchakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chaypina chay kawak runakuna parlachirkansapa Jesus chay runamanta supaykunata llukshichishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chaypina tukuy Gerasa partipi kawsak runakuna manchakuypuru Jesusta roygarkansapa chayllamanta kutinanpa. Chashna roygaptinkunana Jesuska kanowapi yaykurkan kutinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Rinayaykaptinna chay alliyadu runaka Jesusta roygarkan paywan tantalla rinanpa. Sukaman pushananpa roygaptinna Jesuska willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kutiyna wasikimanna. Chaypina tukuyta parlachikuy Tata Dios kuyashushpa alliyachishushkanta. Chashna Jesus willaptinna chay runaka kushikuypuru tukuy llaktamasinkunata parlachirkan Jesus alliyachishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gerasa llaktamanta Jesuska kutirkan kocha chimbaman. Chay kocha chimbanpi aypa runakuna Jesusta shuyaykarkansapa. Chaypi chayaptinna chay llaktapi kawsakkuna sukaman kushikushpa chaskirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Jesus kanowamanta llukshiykaptin suk runa Jairo laduncharkan. Jairoka tantanakunankuna wasipi kamachikuk karkan. Paypa chaylla wambran chunka ishkay watayuk shipitas karkan. Chay shipitasnin unkudu kaptin Jairoka Jesuspa ñawpakninpi kunkurikuk rirkan. Kunkurikushpa Jesusta roygarkan wasinman rinanpa. Jesus almitishpa riykaptin aypa runakuna niti niti katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chay aypa nitik runakunapa chawpinkunapi suk unkudu warmi tiyarkan. Chay warmika chunka ishkay watatana yawar unkuywan kawsarkan. Tukuy kullkintana tukucharkan doktorkunata katishpa. Mana ni pi alliyachiyta atiparkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chay unkudu warmika Jesusta washanmanta ladunchashpa llachapan mañanta llankarkan. Llankashkan ratu yawarninka tipikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chaypina Jesuska katiykak runakunataka tapurkansapa: —¿Pití llachapaynita llankashkankichi? Chashna tapuptinkuna paykunaka willarkansapa: —Manami ni pi llankashkaykisapachu. Chashna willaptinkuna Pedru Jesusta willarkan: —Maestru, aypa runakuna laduykipi kashpa sukaman nitishushpa kayta chayta tankanakushpankuna llankashuykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Chashna Pedru willaptinna Jesuska willarkansapa: —Suk kankunami unkudu kashpaykichi llachapaynita llankashkankichi alliyachinaynipa. Chay llankawaktaka ñami alliyachishkanina. Chayrayku tapuykaykichi pití llachapaynita llankashkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chashna sukaman Jesus tapuptinkuna chay unkuymanta alliyadu warmi mana pakakuyta atiparkanchu. Rirkan sukaman manchakuywan chukchukushpa Jesuspa ñawpakninpi kunkurikuk. Chaypina willarkan: —Ñuka unkudu kashpa llachapaykita llankashkani munashpayni alliyachiwanaykita. Deverasna llachapaykita llankaptini alliyachiwashkanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chashna chay warmi willaptinna Jesuska willarkan: —Munanayni wambrayni, kanka allita ñukata kreyiwashkaykirayku alliyachishkayki. Kunanka wasikiman kushikushpa kutiy. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chashna Jesus willaykaptin Jairopa wasinmanta suk runa chayarkan. Payka Jairotaka willarkan: —Wambraykika ñami wañushkana. Amana wasikiman Jesustaka pushaynachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chayta uyarishpa Jesuska Jairotaka willarkan: —Ama manchakuychu. Tukuy shunku ñukata kreyiway. Ñukami shipashnikita kawsachimusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chaymanta Jairopa wasinpi chayashpankuna Jesuska mana munarkanchu katiykak runakuna yaykunankunapa. Pedruwan Jakobota Juanllata yaykuchirkan. Chaymanta shipashpa tatan maman yaykurkansapa Jesuswan tantalla. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aypa runakuna chay wañudu shipashpa sukaman wakakushpankuna velaykarkansapa. Jesuska paykunata willarkansapa: —Ama wakaychichu. Kay shipashka manami wañuduchu. Payka puñuykanmi. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chashna willaptinkunana chay wakakuykak runakunaka Jesusta mana kreyirkansapachu. Asikurkansapa yachashpankuna chay shipash alli wañudu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chaymanta Jesus kuartupi yaykushpa wañuduta makinmanta apishpa sinchita willarkan: —Kuyanayni wambrayni, ¡atarimuy! ");
INSERT INTO qvsNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chashna Jesus willaptinna chay shipashka kawsamushpa atarimurkan. Chaypina Jesuska willarkansapa chay shipashta karanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chayta kawashpankunana shipashpa tatan maman sukaman almirarkansapa. Paykunata Jesuska willarkan sapa ama ni pita parlachinankunapa shipashninta wañushkanmanta kawsachimushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Chaymanta suk diya Jesuska chunka ishkay disipulunkunata tantanachishpa atipachirkansapa yachanankunapa runakunamanta supaykunata llukshichiyta. Allita atipachirkansapa rikchak laya unkuyukkunata alliyachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jesuska disipulunkunata kacharkansapa yachachikunankunapa Tata Dios alli kamachikuk kananta. Kacharkansapa rikchak laya unkuyuk runakunata alliyachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Paykunata willarkansapa: —Ama apaychichu bastonnikichita nima pikshaykichita nima mirkapaykichita nima kullkikichita nima suk llachapaykichita mudakunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chaymanta maykan llaktapi chayashpaykichi suk runapa wasinpi kipariychi chikan llaktaman rinaykichi diyakaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ichará chayashkaykichi llaktapi kawsak runakuna wasinkunapi mana chaskishunayankichimanchu. Paykuna mana chaskishunayaptikichika chakikichi susyanta tapsishpa chay llaktamanta llukshiychi. Chayta rurashpaykichi paykunata willaykankichi Tata Dios uchankunarayku kastiganankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chashna Jesus kachaptinkunana disipulunkunaka llaktan llaktan yachachikuypi purirkansapa. Yachachikurkansapa Tata Dios uchankunamanta perdonanankunata. Chaymanta rikchak laya unkuyuk runakunata alliyachiypi purirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Chaypina sinchi kamachikuk Herodes uyarirkan Jesus rikchak laya ruraykananta. Runakuna Jesuspa rimarkansapa: “Juan Bawtista wañushkanmanta kawsamushpa Jesuspi tukushpa puriykan.” Sukkuna rimarkansapa: “Ichará ñawpa alli yachachikuk Eliyas kawsamushpa yachachikuykan.” Sukkuna rimarkansapa: “Kay Jesuska ñawpa wañudu yachachikuk runa kawsamushpa puriykan.” Chashna Jesuspa rimaptinkuna Herodes mana yacharkanchu imatami yuyanka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Chaypina rimarkan: —Ñukami Juantaka wañuchirkani umanta tipichipushpa. Ichará payna kawsamushka. Tukuy runakuna paypaka sukaman parlachikuykansapa. Chashna Herodes yuyaykushpa Jesusta sukaman riksinayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chay chunka ishkay disipulunkuna unkudukunata alliyachishkankunamanta kutishpankuna Jesusta rurashkankunata parlachirkansapa. Chaymanta parlachishkankunawasha Jesuska paykunallata pushashpa rirkan Betsaida llaktaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chayman rishkanta yachashpana aypa runakuna katirkansapa. Paykunata Jesuska kushikushpa yachachirkansapa Tata Dios tukuy layapi alli kamachikuk kananta. Chaymanta rikchak laya unkuyuk runakunata alliyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chaypina chay chunka ishkay disipulunkuna tardiyaptin kawashpankuna Jesusta willarkansapa: —Tukuy kay runakunata kachaysapa rinankunapa llaktakunapi chakrakunapi maskak mikunankunata. Richunsapa maskak maypimi samankasapa nishpa. Kay chunllapika manami nima laya mikuna tiyanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesuska mana rinankunapa munashpa disipulunkunata willarkansapa: —Kankuna kay runakunataka karaychi. Chaypina paykunaka willarkansapa: —Pichka pansitukuna ishkay challwillukunallami ñukaykunapaka tiyan. Kay mikuna mana aypa kaptin ichará riymansapa rantik kay aypa runakunata karanaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","15","Chashna disipulunkuna willaptinkuna Jesuska willarkansapa: —Tukuy runakunata pichka chunkamanta pichka chunkamanta tantanachishpa tiyachiychi. Jesus willashkankunata uyarishpankuna disipulunkunaka tukuy chay pichka waranka runakunata tiyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chaymanta Jesuska chay pichka pansitukunata chay ishkay challwata apishpa sieluta chapashpa Tata Diosta agradesirkan. Chaypina chay pankunata chay challwakunata pakishpa disipulunkunata kurkan chay aypa runakunata karanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tukuy paykuna mikurkansapa saksanankunakaman. Mikushkankunawasha chunka ishkay sestukunapi disipulunkuna puchudu mikunata tantachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Chaymanta suk diya Jesuska disipulunkunallawan suk chunllaman rirkansapa. Chaypina Jesuska disipulunkunamanta suchurishpa Tata Dioswan parlaykarkan. Orashkanwasha disipulunkunataka tapurkansapa: —¿Pi kanaynitatí runakuna rimaykansapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Paykunaka willarkansapa: —Sukkuna rimansapa kanshi kanki runakunata bawtisak Juan. Sukkuna rimansapa kanshi kanki ñawpa yachachikuk Eliyas. Chaymanta sukkuna rimansapa ñawpa wañudu yachachikuk runashi kawsamushka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chashna disipulunkuna willaptinkuna Jesuska tapurkansapa: —¿Pi kanaynitatí kankunaka yuyaykankichi? Chaypina disipulun Pedruka willarkan: —Kanka Tata Diosmanta shamudu salvakuk runami kanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chashna Pedru willaptinna Jesuska paykunata willarkansapa: —Mash uyariwaychi. Ama ni pita willaychichu Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chaymanta willarkansapa: —Tata Diosmanta shamudu salvakuk runa kaptinipish suk diya runakuna padesichiwankasapa. Judiyumasinchikunapa ansianunkuna, saserdotekunapa kamachikukninkuna, Moisespa killkadunta yachachikuk runakuna chikniwashpankuna wañuchiwankasapa. Paykuna wañuchiwaptinkuna kimsa diya ukun kawsamusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chaymanta Jesuska tukuy katik runakunata willarkansapa: —Kankunaka disipuluynikuna kanayashpaykichika kikikichipa munanaykichita sakishpa ñukata kasuwashpa kawsaychi. Chiknishuk runakuna wañuchishunayaptikichipish kada diya ñukallata katiwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kankuna wañuymanta kishpinayashpa sakiwashpaykichika mana kishpinkichichu mana tukuyniyuk ninamanta. Chaymanta ñukata kreyiwashkaykichirayku runakuna wañuchishuptikichipish mana tukuyniyukta Tata Dioswan kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Suk runa rikchak laya tiyapuptin mana sielupi yaykushpaka yankapa kay allpapi tukuy layayuk kashka. Tiyapunankuna mana nimapi yanapankachu ninamanta kishpinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Suk runakuna ñukata pinkakuwansapa. Rimanaynitapish mana munansapachu. Chashna pinkakuwaptinkuna ñuka kay allpaman llipyak likidu ukupi shamushpayni chay pinkakuwak runakunata willashasapa mana ñukapa kanankunata. Chay diyaka Tatayni Diospa llipyayninpi yanapawak angelkunawan tantalla kashkan shamusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mash allita uyariwaychi. Suk kankuna manara wañushpaykichira kawankichi Tata Diospa mandunpi ñuka allita kamachikuptini. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chaymanta Jesuska pusak diya yachachikushkanwasha rirkan suk urkuman. Chayman rirkan Tatan Dioswan parlak. Jesuswan tantalla Pedru, Santiago, Juan rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tata Dioswan parlaykaptin Jesuspa uyan chikan laya tukurkan. Llachapanpish yurak likidu tukushpa llipyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chaypina chay kimsa disipulunkunaka kawarkansapa Jesusta parlaykaptin ishkay runakunawan. Paykuna karkansapa ñawpa yachachikuk Moiseswan Eliyas. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Moiseswan Eliyas Jesuswan parlaykaptinkuna llipyak likidu ukupi rikurirkansapa. Chaypi parlaykarkansapa Jerusalen llaktapi Jesus wañunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Chaypina Pedruka disipulumasinkunawan sukaman puñunayashpankunapish mana puñurkansapachu. Paykuna kawarkansapa Jesusta chay ishkay runakunatapish llipyak likidu ukunpi. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chaymanta chay ishkay runakuna Jesusmanta anchuykaptinkunana Pedruka Jesusta willarkan: —Maestru, allipaka kaypi kanwan tantalla kanisapa. Munaptikika kimsa ranchituta rurashasapa sukta kanpa, sukta Moisespa, sukta Eliyaspa. Pedru chayta rimarkan sukaman manchakushpa mana allita yuyashpa imatami rimaykan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chashna Pedru willaptin suk puyu paykunata wichkamurkansapa. Disipulukuna puyu ukunpi mallinakushpankuna manchakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chaypina puyu ukunmanta uyarirkansapa Tata Dios rimakuptin: —Kay Jesuska wambraynimi. Ñukami paytaka akllashkani. Chayrayku payta allita uyariychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chay disipulunkunaka chay rimanata uyarishkankunawasha Jesusta kawarkansapa sapallanta. Chaymanta urayamushpa manara ni pita willarkansaparachu chay urkupi kawashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chaymanta kayantin chay urkumanta urayamuptinkuna aypa runakuna rirkansapa Jesusta tinkuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Paykunapa chawpinkunamanta suk runa manllaybata rimakushpa Jesustaka willarkan: —Maestru, chaylla wambrayni tiyan. ¡Llakichiwashpa unkuyninmanta alliyachipay! ");
INSERT INTO qvsNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kay wambraynita supay unkuchiptin sukaman chukchukushpa kaparikun. Shimin sukaman pusukyan. Supay unkuchiptin kikinlla waktanakun. Supay mana sakinayanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kanpa disipuluykikunata sukamannami roygashkani wambraynimanta supayta llukshichipunankunapa. Paykunaka manami atipashkasapachu llukshichipuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chashna chay runa willaptin Jesuska ladunpi tiyak runakunata willarkansapa: —¿Kunankamanchu manara allita kreyiwankichi? ¡Sukaman mana kreyikuk runakunami kankichi! ¿Aykapikamantí kankunawan kanayni tiyan? ¿Aykapikamantí amichiwankichi? Chashna rimashpa chay wambrapa tatantaka willarkan: —Chay wambraykitaka pushamuy kayman. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chaypina Jesusta ladunchaykaptin supay chay wambrataka allpapi urmachishpa sukaman chukchuchirkan. Chaypina Jesuska supayta piñayashpa willarkan: —¡Llukshiy kay wambramanta! Chashna chay wambrata alliyachishpa tatanta kurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jesus chay wambrata alliyachishkanrayku tukuy kawak runakunaka sukaman almirarkansapa. Willanakurkansapa Tata Dios sukaman alli rurak kananta. Almirashpa chayta parlaptinkuna Jesuska disipulunkunataka willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Mash allita uyariwaychi. Ama kunkaychichu. Sielumanta shamudu runa kaykaptini chikniwak runakuna wañuchiwankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Chashna Jesus willaptinkuna disipulunkunaka mana entiendirkansapachu. Paykunapa yuyayninkunata Tata Dios pantachichipurkansapa Jesus yachachishkankunata ama entiendinankunapa. Chaymanta paykunaka mancharkansapa Jesusta tapuyta ashwan allita entiendichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chaymanta Jesuspa disipulunkunaka ayninakurkansapa maykanmi ashwan alli kanman kamachikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ayninakunankunata yachashpa Jesuska suk taksha wambrilluta apishpa ladunpi churarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chaypina disipulunkunata willarkansapa: —Kankuna ñukata kreyiwashpa suk taksha wambrilluta kuyashpaykichi ñukatapish kuyawaykankichi. Ñukata kuyawashpaykichi kachamuwak Tataynitapish kuyaykankichi. Chayrayku kankuna runamasikichita kuyashpa yanapashpaykichi tukuymanta ashwanta Tata Diosta kushichinkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chaymanta disipulun Juan willarkan: —Maestru, suk runata kawashkanisapa shutikita rimashpa runakunamanta supaykunata llukshichiptin. Ñukaykuna payta michashkanisapa mana ñukanchikunawan tantalla puriptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chaypina Jesuska willarkansapa: —Ama michaychichu. Suk runa ñukata kreyiwashpa supaykunata llukshichishpaka yanapawaykanchisapami. Mana nima chikniwanchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chaypina tipilla illaptin Jesus sieluman kutinanpa mana nima manchakushpa kallarirkan Jerusalen llaktaman riyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samaria partipi chayashpankuna Jesuska ishkay runakunata kacharkansapa suk llaktillupi wasita maskanankunapa chaypi puñunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chay ishkay runakuna chay llaktapi chayaptinkuna mana ni pi Jesusta wasinkunapi samachinayarkansapachu. Samaritanokuna yacharkansapa Jesus riykananta Jerusalen llaktaman. Chayrayku mana munarkansapachu chaypi puñunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaypina Jakobowan Juan Jesustaka willarkansapa: —Maestru ¿munankichu sielumanta ninata urmachimunaynikunapa chaywan chay llaktapi kawsakkuna kullunankunapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chashna willaptinkuna Jesuska ishkantinkunata piñayarkansapa: —Ama chay runakunata chiknishpa munaychichu rupachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ñuka sielumanta shamushkani runakunata kastigumanta salvanaynipasapa. Mana shamushkanichu ni pita wañuchinaynipa. Chashna Jesus michaptinkuna rirkansapa chikan llaktapi puñuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jerusalenman riykaptinna suk runa Jesustaka willarkan: —Señor, maytapish riptiki chaytami katishkayki. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chaypina Jesuska willarkan: —Atukkunapa wasinkuna tiyan machaykunapi. Chaymanta altuta pawak pishkillukunapa wasinkuna tiyan. Ñuka sielumanta shamudu runa kashpaynipish mana nima wasiyukchu kani chaypi samanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chaymanta Jesuska suk runata willarkan: —Ñukata katiway. Chashna willaptinna chay runaka Jesustaka willarkan: —Señor, tatayni wañuptin pampashpaynira katishkayki. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chaypina Jesuska willarkan: —Tata Diosta mana kreyinayak runakunaka paykunapurana pampanakuchunsapa. Kanka rillay tukuy runakunata yachachik Tata Dios allimata kamachikunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chaymanta chikan runa Jesusta willarkan: —Señor, ñukapish sukaman kanta katinayayki. Manarapish kanwan rishpayni rinayani tukuy familyaynikunata willak kanwan rinaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chaypina Jesuska aynirkan: —Suk runa chakranta rurashpa araduwan allpata aspin. Payka araduwan aspiykashpa washanta chapashpa mana kuskatachu aspin. Kanpish mana kunanlla katiwanayashpaykika washanta chapashpa araduta aysak runashinami kanki. Chashna washaykita chapashpayki mana atipankichu Tata Diospa mandunpi kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaymanta yachachikushkanwasha Jesuska yuyarkan aypa llaktakunaman riyta. Manarapish rishpa kanchis chunka runakunata kacharkansapa ñawpaykanankunapa. Ishkaymanta ishkaymanta kacharkansapa rinankunapa yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chay runakuna yachachikuk rinankunapa Jesuska willarkansapa: —Suk runa chakranpi tarpudu murukuna allita pukuptin aypa peonkunawan pallachinsapa. Kankuna chay llaktakunapi yachachikuk riptikichi aypa runakuna Tata Diosta kreyinayansapa. Paykunaka iden chakrapi pukudu wayukunashinami. Tata Diosta kreyinayak runakuna aypa tiyaptinpish mana tiyanchu yachachikuk runakuna. Chayrayku Tata Diosta roygaychi kachananpa ashwan aypa runakunata rinankunapa yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kankuna llaktan llaktan puriptikichi runakuna chiknishunkichi. Paykunaka pumakuna ovejata wañuchikshina wañuchishunkichiman. Chayrayku rishpaykichi allita yuyaykuychi ñuka kankunata sukaman yanapanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ama nima pikshata nima kullkita nima ushutaykichita apaychichu. Chaymanta ñanpi suk runata tinkushpaykichi ama unayaychichu parlachishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Suk wasipi yaykushpaykichi chay wasiyukta rimachishpa willaychi: “Kanta tukuy wasikipi kawsakmasikikunatapish Tata Diosmi kushichishunkichi.” ");
INSERT INTO qvsNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chashna Tata Dios kushichinanpa willaptikichi ichara chay wasiyuk runaka munanman Tata Dios kushichinanpa. Paykuna munaptinkuna Tata Dioska kushichinkasapa. Mana munaptinkunaka mana kushichinkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Allita chaskishuptinkuna chay wasillapi kipariychi. Ama rillaychichu chikan chikan wasikunapi yaykuk. Chay kiparinaykichi wasipi tukuy karashunankunata mikuychi upyaychi. Paykuna chaywan yachachikushkaykichipa pagarashuykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Suk llaktapi chayaptikichi chay runakuna munashushpa karashunkichi. Imatapish kaptin karashuptinkuna mikuychilla. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chay chayashkaykichipi unkudu runakunata tarishpaykichi alliyachiychi. Tukuy paykunata willaychi: “Tata Diosmi sukaman munan mandunpi kawsanaykichipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Chaymanta chikan llaktapi chayaptikichi ichará chaypi kawsak runakuna mana chaskishunayankichimanchu. Chaymanta llukshishpa willaychi: ");
INSERT INTO qvsNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kankuna mana chaskiwaptikichika ñukaykuna chakinikuna susyanta tapsishpa llukshinisapa. Kankunapi kiparin uchaykichi. Mana chaskiwashpaykichipish allita yachaychi: Tata Diosmi sukaman munan mandunpi kawsanaykichipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Allita uyariwaychi. Mana chaskishuptikichika Tata Dioska sukaman kastigankasapa. Ñawpa Sodoma llaktapi kawsak runakunamanta Tata Dioska paykunata ashwan sinchita kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesuska yachachikuyllapi katirkan: —¡Alaw! Chay ishkay llaktakuna Korasinpi Betsaidapi kawsakkunata llakichini. Chay ishkay llaktakunapi aypa almirana ruranata rurashkani. Chaykunata kawashpankunapish uchankunata mana nima wananayansapachu. Chayrayku Tata Dioska paykunata sukaman kastigankasapa. Tiro Sidon llaktakunapi ñuka almirana ruranakunata rurashka kaptinika chaypi kawsak runakuna uchankunamanta wananmansapa karkan Tata Diosta kreyinankunapa. Llakina llachapata churakunmansapa karkan uchpapi tiyarishpa llakinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chayrayku kastigakunan diya Tiropi Sidonpi kawsakkunamanta Tata Dioska ashwanta kastigankasapa Korasinpi Betsaidapi kawsak runakunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chaymanta Kapernaum llaktapi kawsak runakuna yuyansapa sieluman riyta Tata Dioswan kawsak. Chashna yuyashpankunapish Tata Dios manami sielumanka pushankasapachu. Manllayba tuta likidu uchkuman kachankasapa mana ñukata kreyiwashkankunarayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaymanta Jesuska chay kachaykanan runakunata kashkan willarkansapa: —Yachachikuk riptikichi kankunata uyarishushpaykichika ñukatami uyariwaykansapa. Kankunata chiknishushpaykichika ñukatami chikniwaykansapa. Ñukata chikniwashpankunaka kachamuwak Tatayni Diostapish chikninsapa. Jesus chay kanchis chunka runakunata yachachishpa kacharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesus chay kanchis chunka runakunata kachaptin aypa llaktakunapi yachachikuypi purirkansapa. Chaypina kushikuypuru kutishpankuna Jesusta willarkansapa: —Maestru, kanpa shutikipi willaptinikuna supaykunapish kasuwashpankuna runakunamanta llukshishkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chashna chay runakuna willaptinkuna Jesuska willarkansapa: —Ariya shutinipi tukuy layata atipankichi rurayta. Ñuka kawashkani sielumanta supaykunapa ashwan sinchi kamachikukninta llipyakshina urmamuptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chay supaykuna machakuyshina alakrashina wakllichishunayankichi. Ñuka kankunata sukaman yanapashkaykichi tukuy laya supaykunata karkunaykichipa. Karkuptikichipish mana nimanachishunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kankuna sukaman kushikushkankichi supaykunata runakunamanta llukshichishpaykichi. Ñuka willaykichi ashwanta kushikuychi shutikichi sielupi killkaduna kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chashna chay runakunata willaptin Tata Diospa Espiritun Jesusta sukaman kushichirkan. Chaypina Tatan Diosta willarkan: —Tatayni, sielupi allpapi allima kamachikukmi kanki. Kanka tukuy mana kreyinakuk runakunallata allita yachachinki. Chaymanta kikinkunallamanta yachak runakunata mana nimata yachachishkankichu. Chayrayku Tatayni, alabayki. Ariya, Tatayni kushikushpa chashna munashkanki rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tatan Dioswan parlashkanwasha Jesuska disipulunkunata willarkansapa: —Tataynika willawarkan ñukalla tukuy layata kamachikunaynipa. Payllami ñukata allita riksiwan. Kankunaka manami allitachu riksiwankichi. Tata Diospa wambran kashpayni ñukallami payta allita riksini. Ñuka munashkayni runakunata riksichiptini Tataynita riksinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Chaymanta Jesuska disipulunkunallata pakallalla willarkansapa: —Allita willaykichi. Ñawpa tiempupi yachachikuk runakuna aypa kamachikuk runakunapish sukaman shuyawashpa ruranaynita kawanayarkansapa yachachikunaynita uyarinayarkansapa. Tukuy paykuna mana kawawashpara mana uyariwashpara wañurkansapa. Kankuna ruranaynita kawashpaykichi yachachikunaynita uyarishpaykichi sukaman kushikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chaymanta suk diya suk runa rirkan Jesusta parlachik. Chay runaka Moisespa killkashkankunata yachachikuk. Payka yachanayarkan Jesus allitachu manachu yachachikuykan nishpa. Chaypina Jesusta ladunchashpa tapurkan: —Maestru ¿imatatí ruranayni tiyan Tata Dioswan mana tukuyniyukta sielupi kawsak rinaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chashna chay runa tapuptinna Jesuska willarkan: —¿Leyishkankichu chay ñawpa killkadukunata? ¿Imata ruranaykipatí willashunki? ");
INSERT INTO qvsNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chaypina chay runaka willarkan: —Moisespa killkashkan riman: “Kamachikuk Tata Diosnikita tukuy shunku kuyanayki tiyan. Tukuy layata allita rurashpa sukaman munashpa allimata yuyashpa Tata Diosta kuyanayki tiyan. Chaymanta kikiki kuyanakukshina tukuy runamasikikunata kuyanayki tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chaypina Jesuska willarkan: —Allitami ayniwashkanki. Tukuy willawaykanaykita rurashpaykika rinkimi mana tukuyniyukta Tata Dioswan sielupi kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chaypina chay runaka runamasinta mana kuyaykashpa kuyakukshina tukushpana Jesustaka tapurkan: —¿Maykan runatatí kuyasha? ");
INSERT INTO qvsNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chashna chay runa tapuptinna Jesuska yachachishpa suk ejempluta willarkan: —Jerusalen llaktamanta Jeriko llaktaman suk runa rirkan. Ñanpi riykaptin suwakuna tinkurkansapa. Paykunaka tukuy laya tiyapunanta llachapankunatapish kichurkansapa. Wañunayanankaman sukaman makashpa sakirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ñanpi chay makadu runa wañunayaykaptin suk saserdote chay ñanta riykashpa tarirkan. Payka ladeyashpa mana nima yanapanayashpa sakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chaymanta saserdotepa yanapaknin runa chay makadu runataka tarirkan. Paypish mana yanapanayashpa sakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chaymanta Samariamanta runa chay ñanta riykashpa chay makadu runataka tarishpa llakichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Payna sukaman llakichishpa llikipushkankunata tipi wirawan tipi vinuwan ampipurkan. Chaymanta llachapawan llikipushkankunata wankupurkan. Ampishkanwasha burrunpa sawanpi churashpa llaktakaman pusharkan. Suk wasipi churak rirkan chaypi kuydanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chaymanta kayantin pakariptin chay Samariamanta runa wasi doyñunta kullkita pagararkan. Paytaka willarkan: “Kay unkudu runata allita kuydanki. Kay kushkayni kullki pishiptinka kannami paktachinki. Kutimushpayninami kutichishkayki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chay ejempluta yachachishpa Jesuska chay yachachikuk runataka tapurkan: —Chay kimsa runakunamanta ¿maykantí makadu runapa kuyak runa karkan? ");
INSERT INTO qvsNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chaypina chay runaka Jesustaka willarkan: —Chay llakichishpa yanapak runa makadu runata kuyarkan. Chaypina Jesuska willarkan: —Kanpish iden chay yanapakuk runashina tukuy runamasikikunata yanapashpa kawsay. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesuska yachachikuyllapi disipulunkunawan tantalla purirkansapa. Suk diya chayarkansapa suk llaktapi. Chaypi suk warmi Marta Jesustaka kushikushpa wasinpi chaskirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa tiyarkan suk ñañan Mariya. Mariyaka Jesuspa chakin kuskapi tiyarirkan yachachikunanta uyarinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Chaykamanka Martaka aypa mikunata yanushpa sukaman turbakuykarkan. Chaypina Jesusta willarkan: —Maestru ¿ariya ñukataka manachu llakichiwanki? Kay ñañaynika sakiwashka sapallayni yanukunaynipa. Willay yanapawak shamunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chashna willaptinna Jesuska Martataka willarkan: —Alaw Marta, rikchak layata rurashpayki sukaman turbakunki. ");
INSERT INTO qvsNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Trabajanaykimanta ashwan alli kanman Tata Diospa rimananta yachakunaykipa. Mariyaka ñami allitana yachakuykan. Mana munanichu yachakuykananta michanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Chaymanta suk diya suk chunllapi Jesuska Tata Diosta oraykarkan. Orayta tukuchashkanwasha suk disipulun ladunchashpa willarkan: —Maestru, Juan Bawtista tukuy disipulunkunata yachachirkansapa orayta. Kanpish payshina yachachiwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chashna disipulunkuna yachakunayaptinkuna Jesuska willarkansapa: —Kankunaka Tata Diosta orashpaykichi kashna willaychi: “A Tata Dios, kanmi kanki Tataynikuna. Munanisapa tukuy runakuna rimanankunapa sukaman alli rurak kanaykita. Munanisapa tukuy runakuna kanta kasushushpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tukuy diya mikunaynikunata kuwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Runamasinikuna mana allita rurawaptinkuna ñukaykuna perdonanisapa. Chashnashina kanpish uchaynikunamanta perdonawaysapa. Yanapawaysapa ama supay munachiwanankunapa mana allita rurayta.” ");
INSERT INTO qvsNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesus ashwanta entiendichinayashpankuna suk ejempluta willarkansapa: —Ichara suk amiguykichi chawpi tutapi wasikichiman rinman. Kayashushpaykichi willashunkichiman: “Amigu, suk tipi mikunaykita kuway. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wasinipi suk amiguyni yarkaymanta chayamushka. Manami nima laya mikuna tiyawanchu karanaynipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chashna amiguykichi mañashuptikichi wasikichi ukumanta manami willamunkichimanchu: “Ama shamuychu rikchachiwak. Wasini punkunka ñami alli wichkaduna. Tukuy wambraynikunawan ñami samaykanisapana. Kashna ora mananami atipaninachu nimata kuynikita.” ");
INSERT INTO qvsNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Allita willaykichi. Amiguykichi sukaman mañashuptikichika atarinaykichi tiyan mañashushkanta kuk. Mana munashpaykichipish atarishpa kunaykichi tiyan sukaman mañashuptikichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mash allita uyariwaychi. Kankuna suk imata munashpaykichi Tata Diosta mañaychi. Mañashkaykichita Tata Dioska kushunkichi. Maskashkaykichita tarinkichi. Punkuta takaptikichi kicharinka. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tata Diosta mañak runaka chaskinkami. Tata Diosta maskak runaka tarinkami. Tata Dios punkunta takak runapa kicharinkami. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kankunapa wambraykichi challwata mañashuptikichi ¿kunkichimanchu machakuyta? ");
INSERT INTO qvsNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Runtuta mañashuptikichi ¿kunkichimanchu alakrata? ");
INSERT INTO qvsNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kankuna mana alli rurak kashpaykichipish wambraykichita allikunata kunkichi. Tata Dioska kankunamanta ashwan alli rurakmi. Chayrayku roygaptikichi Espiritunta kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Suk diya suk runamanta Jesuska supayta llukshichirkan. Supay unkuchiptin chay runaka mudu karkan. Jesus supayta llukshichiptinna chay runaka atiparkan rimakuyta. Rimakuptin kawak runakuna sukaman almirarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Chaypina suk runakuna Jesuspa rimarkansapa: —Supaykunapa kamachikuknin Belsebu kay runata yanapaptin supaykunata llukshichin. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Suk runakuna Jesusta pantachichinayashpankuna willarkansapa: —Kunanlla suk almirana ruranata ruray chayta kawashpa yachanaynikunapa Tata Dios yanapashunkichu manachu nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chaypina Jesuska yuyayninkunata yachashpa willarkansapa: —Suk llaktapi kawsak runakuna chikninakushpa makanakushpankuna kikinkunapura kulluchinakunsapa. Sukaman makanakushpankuna wasinkunatapish urmachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kankunaka rimaykankichi supaykunapa kamachikuknin Belsebu yanapawananta. Chayta rimashpaykichi mana kuskatachu rimaykankichi. Supaykunapa kamachikuknin yanapawashpaka kikinpa supayninkunallawan makanakuykanmansapa. Kikinkunapura makanakushpa kulluchinakunmansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Belsebu yanapawaptinka ¿pití disipuluykikunata yanapan supaykunata llukshichinankunapa? Allita yachanchi Tata Dios paykunata yanapananta. Chayrayku ñukata yuyawashpaykichi llullachinakuykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tata Dios yanapawaptin supaykunata atipani llukshichiyta. Chayrayku yachanaykichi tiyan Tata Dios kachamuwashkanta kankuna paypa mandunpi kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Chaymanta Jesus suk ejempluta willashpa entiendichirkansapa supayta kallpachik kananta; —Suk sinchi runa wasinta kuydashpa tukuy laya tiyapunanta allita wakaychan. Alli armadu kashpa rikchak layanta amachan. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Allita kuydashpa wakaychaptinpish paymanta ashwan sinchi runa shamushpa armankunata kichushpa kallpachin. Chay wasiyuk runaka yuyarkan armankunawan makanakushpa kuydanakuyta. Chashna yuyaptinpish chay ashwan sinchi runa armankunata kichushpa tiyapunankunata kichun apananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kankuna mana kreyiwashpaykichika chikniwankichi. Mana yanapawashpaykichika sukkunata ñukamanta ashuchiykankichi. Jesus yachachikuyllapi katirkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Chaymanta suk runamanta supay llukshishpa chakidu chunlla allpapi purin samanayashpa. Mana ni maypi samananta tarishpa riman: “Shu, kutishalla chay llukshimushkayni runallaman.” ");
INSERT INTO qvsNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chay runaman kutishpa tarin iden suk wasi chuya chuya pichadutashina. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chaypina kanchis ashwan mana alli rurak supaymasinkunata rin kayak. Tukuy paykuna rinsapa chay runapi yaykuk. Chashna modomanta chay runaka ñawpa kawsashkanmanta ashwan mana allikunata rurashpana kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chashna Jesus yachachikuykaptin suk warmi chay runakunapa chawpinmanta sinchita rimashpa payta willarkan: —Mamayki kushikushpa kawsan wawayashushkanrayku wiwashushkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chashna chay warmi willaptinna Jesuska willarkan: —Mamaynimanta ashwan allita kushikunsapa Tata Diospa rimananta uyarishpa kasukuk runakuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesus yachachikuykaptin ashwan aypa runakuna tantanakurkansapa uyarik. Tukuy paykunata Jesuska yachachishpankuna willarkansapa: —Kankunaka mana alli rurak kashpaykichi sukaman roygawankichi almirana ruranakunata ruranaynipa. Roygawaptikichipish mana nimata kankunapa rurashachu. Ñuka mana niman suk almirana ruranata ruraptinipish Tata Diosmi ruranka iden ñawpa alli yachachikuk Jonaspa tiempunpishina. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonaska kimsa diyata suk atun challwa wiksanpi kawsarkan. Chaymanta kimsa diyapina kocha mañanpi chay challwaka paytaka kipnarkan. Chaypina Jonas Ninive llaktapi yachachikuptin chay mana alli rurak runakuna kreyirkansapa Tata Dios kachamushkanta. Kimsa diya ukun challwa wiksanmanta Jonas llukshimushkanshina ñukapish wañuymanta kimsa diya ukun kawsamusha. Chaypina yachankichi Tata Dios ñukata kachamuwashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Jonaska Ninive llaktapi kawsak runakunata willarkansapa Tata Dios kastiganankunata. Chayta uyarishpankuna paykuna Tata Diosta kreyishpa mana alli ruranankunamanta wanarkansapa. Tata Dios kastigakunan diya chay runakuna sukaman chatashunkichi mana ñukata kreyiwashkaykichirayku. Ñuka Jonasmanta ashwan alli yachachikukmi kani. Chaymanta ñawpa tiempu suk karu llaktamanta suk kamachikuk warmi shamurkan yachaysapa Salomonta uyarik. Ñuka Salomonmanta ashwan alli yachaysapa kani. Chayrayku Tata Dios kastigakunan diya chay alli kamachikuk warmika kankunata chatashunkichi mana kreyiwashkaykichirayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesuska yachachikuyllapi katirkan: —Alkusata apichishpanchi altupi churanchi tukuy wasipi yaykuk runakuna allita kawakunankunapa. Mana ni pi alkusata apichinchu uchku ukupi pakananpa. Nima apichinchu suk kajon ukunpi churananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kankunapa ñawikichi kuerpuykichipa lusninmi. Yuyaynikichika shunkuykichipa lusninmi. Allikunata yuyashpaykichika allita rurashpa kawsankichi. Allita rurashpa kawsashpaykichika luspishina kawsankichi. Mana allikunata yuyashpaykichi mana allita rurashpa tutapishina kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kuydanakuychi ama tutayadupi kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kankunaka allita yuyashpa allita rurashpa kawsashpaykichi lusyukna kankichi. Manana nima tutayadupishinanachu kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chaymanta Jesus yachachikushkanwasha suk fariseo runa willarkan wasinpi mikuk rinanpa. Jesus almitishpa chay runapa wasinpi yaykushpa rirkan mesapi mikuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Payka mikukpacha rirkan mana makinta mayllashpa. Chay fariseo runaka Jesusta yuyarkan mana makinta mayllashpa mikuptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chaypina Jesuska payta willarkan: —Kankuna fariseokuna Tata Diospi chuya chuya rikurinaykichipa mayllanakunkichi. Chaykamanka mana allita yuyaykushpa kawsankichi. Sukkunapa tiyapunanta munashpa suwankichi. Iden suk kallana suk vasu washanlla maylladushina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sawallamanta mayllanakushpaykichi sukaman llullachinakuykankichi. ¿Manachu yachankichi Tata Dios tukuy tiyakta rurashpa yuyaynikichitapish rurashkanta? ");
INSERT INTO qvsNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kankunaka runamasikichita tukuy shunku kuyashpa yanapashpa kawsaychi. Chaypira iden chay kallana ukun chuya chuya maylladushina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ñukaka kankuna fariseokunata llakichiykichi Tata Dios kastigashunaykichita yuyashpa. Kankunaka tukuy chakraykichipi wiñakkunata chunkamanta sukta Tata Diosta kunkichi. Chayta kushpaykichipish runamasikichita chiknishpaykichi mana allita ruraykankichi. Mana Tata Diosta kuyashpa kawsankichi. Tata Dioska munan tiyapushunaykichimanta ashwan alli kakta kunaykichipa. Chay kushkaykichimanta ashwanta munan runamasikichita yanapashpa kawsanaykichipa. Munan paytapish kuyashpa kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ñukaka kankuna fariseokunata sukaman llakichiykichi Tata Dios kastigashunaykichita yuyashpa. Tantanakunankuna wasipi ashwan alli tiyarinapi tiyarinayankichi. Chaymanta kallipi purishpaykichi munankichi tukuy runakuna manchashushpa rimachishunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Llakichiykichi Tata Dios kastigashunaykichita yuyashpa. Kankunaka mana alli rurak kashpaykichi wañudu pampanapa uchkushinami kankichi. Runakuna mana yachashpa chay uchkupi wañudukuna pampadu kanankunata sawanta purinsapa. Chashnashina runakuna mana riksishushpaykichi kreyinsapa alli yachachikuk kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chashna Jesus fariseokunata willaptin Moisespa killkadunta yachachikuk runakuna willarkansapa: —Maestru, fariseo runakunata piñayashpaykika ñukaykunatapish sientichiwaykankisapami. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chashna willaptinkuna Jesuska willarkansapa: —Moisespa killkadunta yachachikuk runakuna, kankunata llakichiykichi Tata Dios kastigashunaykichita yuyashpa. Kankunaka tukuy runakunata willankichi mana atipanankuna layata ruranankunapa. Iden llashakpuru kargata aparichikukshina kankichi. Rikchak layata ruranankunapa willashpaykichi mana niman suk tipita yanapanayankichichu nima kikikichi rurankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Kankunata llakichiykichi Tata Dios kastigashunaykichita yuyashpa. Kankunapa ñawpa awiluykichi wañuchirkansapa Tata Diospa rimananta yachachikuk runakunata. Chaymanta kankunaka chay ñawpa yachachikukkunata yuyashpa pampadukuna sawanpi suk tumbata rurankichi. Chayta rurashpaykichi entiendichikuykankichi yuyanaykichita chay ñawpa awiluykichipa rurashkan alli kashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","51","Kallarinanmantapacha ñawpa awiluykichi wañuchirkansapa alli yachachikuk runakunata. Primeruka Abelta wawkin wañuchirkan. Chaymanta wañuchikuyllapi katirkansapa Sakariyasta wañuchinankuna tiempukaman. Sakariyasta wañuchirkansapa Tata Diosta kuyanan wasi punku ladunpi altar sikinpi. Chaymanta kankuna iden ñawpa awiluykichishina Tata Diospa rimananta yachachikukkunata chikninkichi. Tata Dioska yachaysapa kashpa kankunapa rimarkan: “Ñuka kankunaman alli yachachikuk runakunata kachasha. Paykunata kachaptini sukkunata wañuchinkichi. Sukkunata chiknishpa padesichinkichi.” Chayta rimarkan Tata Dioska. Kunan allita willaykichi: Tata Dios kankunata willashunkichi uchayuk kanaykichita tukuy chay runakuna wañuchidu kashkankunarayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Moisespa killkadunta yachachikuk runakuna, kankunata llakichiykichi. Kankunaka yachachikuk runakuna kashpaykichipish Tata Diospa rimananta mana allitachu yachachikunkichi nima entiendinayankichichu. Chaymanta runakuna entiendinayaptinkuna michankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chashna Jesus willaptinna fariseo runakunaka Moisespa killkadunta yachachikuk runakunapish sukaman piñakurkansapa. Paykunaka piñakushpankuna amichishpa tapuyllapi katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jesusta rimananllawan sukaman pantachichinayarkansapa awtoridarkunapi chatanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesus yachachikuykaptin waranka waranka runakuna tantanakurkansapa uyarik. Sukaman aypa kashpankuna nitinakurkansapa. Chaypina paykuna uyariykaptinkuna Jesuska disipulunkunata yachachishpa willarkansapa: —Fariseo runakuna rimansapa Tata Diosta allita uyariykanankunata. Chashna rimashpankunapish mana allita rurashpa kawsaykansapa. Kankunaka ama paykunashina kawsaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tukuy runakuna imatapish pakallalla ruraptinkuna Tata Dioska yachan. Chayta tukuy runakunata riksichinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kankuna suk imata pakallalla rimaptikichi Tata Dioska uyarin. Chaytapish tukuy runakunata yachachinkasapa. Wasikichi ukupi suk imata pakallalla rimaptikichi chikan runakuna sinchita rimashpa tukuyta willankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ñukapa kuyanakukmasinikuna kaptikichi sukaman allita yachachishkaykichi. Runakuna wañuchishunayaptikichi ama manchakuychichu. Paykuna wañuchishushpaykichipish mana ashwanta nimanachishunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Willaykichi pitami manchanaykichi tiyan nishpa. Tata Dioska atipan wañudukunata mana tukuyniyuk ninapi churayta. Chayrayku Tata Diosllata manchanaykichi tiyan ama chaypi kastigashunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Chaymanta yachachiykichi Tata Dios sukaman kuyashunaykichita. Pichka pishkillukunata rantinchi ishkay kullkillawan. Pishkillukuna mana aypa chaniyuk kaptinpish Tata Dioska mana ni sukta kunkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Paymi aypa pishkillukunamanta kankunata ashwanta kuyashunkichi. Chaymanta yachan kankunapa chukchaykichi mashnami tiyan nishpa. Tata Dios sukaman kuyashuptikichi payllatana manchaychi. Ama runakunata manchaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesuska yachachikuypi katirkan: —Allita uyariwaychi. Kankuna runamasikichita willaptikichi kreyiwak kanaykichita ñukapish Tata Diospa angelninkunata willasha ñukapa kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Runamasikichita willaptikichi mana riksiwanaykichita ñukapish Tata Diospa angelninkunata willasha mana kankunata riksinaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ñukaka sielumanta runami kani. Chashna kaptinipish suk runa ñukata washanchawashpa mana alli kanaynita rimaptinpish Tata Dioska payta perdonanka. Chaymanta paypa Espiritunta washanchashpa chiknishpa sakra mana alli kananta rimaptin Tata Dioska mana kutin perdonankachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ichará chiknishuknikichi tantanakunankuna wasiman pushashunkichiman awtoridarpi chatashunaykichipa. Chayman pushashuptikichi ama manchakuychichu. Ama yuyaychichu imatami awtoridarkunata willasha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Awtoridarkunapi kaptikichi Tata Diospa Espiritun yachachishunkichi imatami rimankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chaymanta aypa runakunapa chawpinkunamanta suk runa Jesusta willarkan: —Maestru, wawkinita willapay tataynipa tiyapunanta patumawananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chashna chay runa willaptinna Jesuska willarkan: —Amigu, manami shamushkanichu tiyapushuknikichita patumaknikichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chaymanta Jesuska chay runakunata willarkansapa: —Ama sukaman munaychichu rikchak layayuk kayta. Tata Diosllami kawsayta kushunkichi. Chayrayku mana nimananchu tukuy layayuk mana nimayuk kanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesuska yachachikushpalla suk ejempluta parlachikurkan: —Tiyarkan suk runa tukuy layayuk. Chay runapa chakrankunapi tukuy laya tarpudukuna aypata wayuchakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chaypina chay runaka yuyayninpi rimarkan: “¿Imatatí rurasha? Muru wakaychana wasinikunapi tukuy pallashkaynikuna manana paktannachu.” ");
INSERT INTO qvsNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chayta yuyaykushpa kikinlla willanakurkan: “Ñami yuyashkanina imatami rurasha nishpa. Shu urmachisha murukunata wakaychanayni taksha wasinikunata. Chayllapi ashwan atun wasikunata rurachisha. Chaypi chay aypa muru pallashkaynita allita wakaychasha. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chayta rurashpana sukaman aypa watakunata kushikusha rikchak laya wakaychadu tiyawaptin. Manana trabajashpa sukaman kushikushpa mikusha upyasha.” ");
INSERT INTO qvsNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chashna chay runa kikinlla willanakuptin Tata Dioska willarkan: “Kanka sukaman mana alli yuyayukmi kanki. Kunan tutami wañunki. Wañuptiki ¿pipatí kiparinka tukuy kay aypa tiyashuk murukunaka?” ");
INSERT INTO qvsNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chay ejempluta yachachikushkanwasha Jesuska willarkansapa: —Chay runaka kikinllapa tukuyta tantanachishpa Tata Diospa ñawpakninpi mana nimayukchu rikurin. Tata Dioska tukuy chay laya runakunata kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus chay aypa runakunata yachachishkanwasha disipulunkunallata willarkan: —Allita uyariwaychi. Ama turbachinakushpa yuyaychichu imatami mikusha imatami llachapakusha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mana llachapaykichillatachu mikunaykichillatachu yuyashpa ashwan alli kanman Tata Diosta kasushpa kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mash yuyaykuychi imashnami pishkillukuna kawsansapa nishpa. Paykunaka mana nima murukunata tarpunsapachu. Paykunapa mana nima muru wakaychana wasinkuna tiyapunsapachu. Mana nima murukunata tarpuptinkunapish Tata Dioska aypa mikunankunata kunsapa. Kankunata Tata Dioska pishkillukunamanta ashwan allita kuyashunkichi. Chashna kuyashushpaykichi kawsanaykichipa rikchak layata kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kankunaka wiñadu kashkaykichimanta sukaman turbachinakushpa ¿atipankichimanchu ashwanta wiñaytaka? ");
INSERT INTO qvsNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mana ni chayta atipashpaykichika ¿imapatí llachapaykichillapi sukaman yuyankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mash kawaychi chay allima sisakunata. Chaykunaka mana nima trabajansapachu nima puchkakunsapachu. Mana puchkakushpankunapish sukaman allima mudakudushina rikurinsapa. Ñawpa kamachikuk Salomonpa llachapankuna sukaman allima rikurirkan. Paypa llachapanmanta chay sisakuna ashwan allimata rikurinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tata Dioska kiwakunata wiñachin sisananpa. Chay sisakuna suk diyallapa allima rikurishkanwasha rupachinchisapa. Chayta kawashpa ¿imapati mana kreyikunkichi Tata Dios chay sisakunamanta ashwan allima mudachishunaykichita? ");
INSERT INTO qvsNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ama turbachinakushpa mikunaykichita upyanaykichita maskashpalla kawsaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tata Diosta mana kasushpa kawsak runakuna tukuy chaykunallata yuyashpa kawsansapa. Ama paykunashina kawsaychichu. Kankunapaka tiyanmi kuydakuk yanapakuk Tata Diosnikichi. Paymi allita yachan imakunami illashunkichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kankunapa alli kuydakuk Tata Diosnikichi tiyaptin ashwanta munaychi paypa mandunpi kawsayta. Paypa munashkankunata rurashpa kawsaptikichika paymi rikchak layata kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kankunaka alli kuyanayni ovejaynikunami kankichi. Mana aypa kashpaykichipish ama nimata manchaychichu. Tata Dios kuyashushpaykichi munan paywan tantalla mana tukuyniyukta kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tata Dios kuyashuptikichi kankunapish runamasikichita kuyashpa yanapashpa kawsaychi. Mana kullkikichi tiyaptinka tiyapushunaykichita rantikushpa mana nimayuk runakunata yanapaychi. Paykunata yanapashpa kawsashpaykichi Tata Diosta kushichiykankichi. Paymi sielupi tukuy layata kushunkichi. Sielupi kawsaptikichi tiyapushunaykichi mana mawkayankachu. Mana nimapish illashunkichinachu. Sielupika suwa runakuna mana yaykunkasapachu. Chaypika polillakuna mana tiyanchu nimata wakllichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Imatacha tukuy shunku munashpa wakaychankichi chayllata yuyashpa kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Chaypina Jesuska disipulunkunata willarkansapa: —Uyariychi kay ejempluta: Ñukaka tataykichishinami kani. Kankunaka wiwachuynikunashinami kankichi. Chayrayku suk funsiamanta kutimuktashina shuyawaychi. Allita prontanakushpa iden tutapi alkusaykichita apichikshina shuyawaychi. Uyari uyari shuyawaychi punkuta takaptini utkakushpa kicharinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Allita prontanakushpa shuyawashpaykichi chayamuptini sukaman kushikunkichi. Allita willaykichi. Ñukami mikunaykichita karashkaykichi mesapi mikunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chayamunaynita yachashpaykichi uyari uyari shuyawanaykichi tiyan. Tutapish kaptin pakarinan orapish kaptin chayamusha. Chashna uyari uyari shuyawashpaykichi chayamuptini sukaman kushikunaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chaymanta willaykichi. Suk wasiyuk runa yachashpa imay orami suwa shamunka nishpa allita shuyanman ama nimata suwapunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kankunapish allita prontanakushpa shuyawaychi. Ñuka sielumanta shamudu runa kashpayni mana nima yuyashkaykichi orami chayamusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesus yachachikuptin Pedru tapurkan: —Maestru ¿chaytaka ñukaykunallatachu yachachiwaykankisapa? ¿Tukuy runakunatachu yachachiykanki? ");
INSERT INTO qvsNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chashna Pedru tapuptinna Jesuska suk ejempluta willarkansapa: —Mash allita uyariwaychi. Suk patron chikan llaktaman rinanpa wasinpi suk alli rurak yachaysapa wiwachunta willan tukuy wiwachumasinkunata trabajachinankunapa. Chaymanta willan oranpi karanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chay wiwachu patronnin willashkankunata ruranan tiyan. Patronnin kutimushpa tarinka allita ruraykaptin. Chaypi chay wiwachu sukaman kushikunka. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Allita willaykichi. Chay wiwachu allita rurashpa shuyaptin patronninka willanka tukuy laya tiyapunanta kuydananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ichara chay wiwachun yuyanman patronnin mana utka kutimunanta. Chaypina kallarinman wiwachumasinkunata makashpa sufrichiyta. Payllana sukaman mikushpa upyashpa machashpa kawsanman. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chashna mana allita ruraykaptin mana yuyashkan oras patronka chayamunman. Chaypina chay mana alli rurak wiwachunta sukaman kastiganka. Tukuy mana alli rurak runakunawan tantallata kastiganka. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ichara suk wiwachu patronnin willashkanta allita yachaykashpa mana nima prontanakunmanchu mana nima kasunmanchu. Willashkanta mana ruraptin patronninka sukaman makanka. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ichara suk wiwachu mana yachanmanchu imatami patronninka willashka nishpa. Chayrayku mana ruranmanchu. Paytaka patronninka mana sukamanchu makanka. Ñukami patronnikichishina kani. Kankunata sukaman allita yachachishkaykichi. Sukkunamanta kankuna ashwan allita yachankichi. Kankunata sukaman yachachishkaynirayku sukkunata yachachinaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus yachachikushpa willarkansapa: —Kay allpaman shamushka kaptini mana kreyiwak runakuna kankuna kreyiwak runakunata ninawan rupachikshina padesichishunaykichi tiyan. Sukaman munayman chay ninawanshina padesichishunaykichipa yachakunaykichipa ama uchallikushpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ñuka sukaman padesishpa wañunayni tiyan. Tata Dios willawashkanta sukaman munaykani rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ichará kankuna yuyaykankichi ñuka shamushkaynirayku runakuna mana makanakunkasapanachu nishpa. Mash allita uyariwaychi. Mana alli rurak runakuna tukuy ñukata kreyiwak runakunata chikninkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kunanmantapacha suk familyapi ishkay laya kawsak runakuna tiyankasapa. Sukkuna ñukata kreyiwankasapa. Sukkuna mana kreyiwankasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mana kreyiwak runakuna kreyiwakkunata sukaman chikninkasapa. Suk mana kreyiwak tata kreyiwak wambranta chikninka. Mana kreyiwak runa kreyiwak tatanta chikninka. Suk mana kreyiwak mama kreyiwak warmi wawanta chikninka. Mana kreyiwak warmi kreyiwak mamanta chikninka. Suk mana kreyiwak suedra kreyiwak nueranta chikninka. Mana kreyiwak nuera kreyiwak suedranta chikninka. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chashna disipulunkunata yachachishpana Jesuska tukuy katik runakunata willarkansapa: —Inti yaykunanpi yana puyukunata kawashpaykichi rimankichi tamyanayananta. Chay rimashkaykichishina deveras tamyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chaymanta uraymanta wayra shamuptin rimankichi rupay nanananta. Uraymanta wayraptin chay rimashkaykichishina deveras rupay sinchita nanan. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kankunaka yachak runakuna kashpaykichipish Tata Diospa munananta mana rurankichichu. Tamyananta rupay nanananta yachaykashpaykichi ¿imapatí mana yachankichi sielumanta shamushkaynita? ");
INSERT INTO qvsNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Imapatí mana kikikilla yachanki imami alli rurana nishpa? ");
INSERT INTO qvsNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ichara chiknishuk runa awtoridarkunapi chatashushpa pushachishunkiman. Amarapish awtoridarpi chayashpaykira chatashuk runawan allita parlay allichanaykipa debikushkaykita amana awtoridarpi yaykunaykipa. Mana allichaptiki awtoridarpi chayaptiki paymi guardiyakunata willanka karselpi wichkashunaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Allita uyariway. Tukuy debikushkaykita mana pagarakunaykikamanka manami karselmanta llukshinkichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesus yachachikushkanwasha suk runakuna laduncharkansapa. Paykunaka Jesusta willarkansapa kamachikuk Pilato Galileamanta runakunata wañuchichishkanta. Chay runakuna Tata Diosta kuyashpankuna animalkunata wañuchiykarkansapa. Animalkunata wañuchiykaptinkuna Pilatoka chay runakunata wañuchichirkansapa. Chaypina paykunapa yawarninkuna chay animalkunapa yawarninkunawan chakrunakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chayta willaptinkuna Jesuska willarkansapa: —Ichará kankunaka yuyaykankichi chay Galileamanta wañuchidu runakuna tukuy runamasinkunamanta ashwan uchasapa kashkankunata. Ichará yuyaykankichi chayrayku paykunata Pilato wañuchichishkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mash allita uyariwaychi. Chay wañuchidu runakunaka manami ashwan uchasapachu karkansapa. Kankunapish mana uchaykichimanta wanashpaykichika paykunashina wañunaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chay Siloe torre urmashpa chunka pusak runakunata nitishpa wañuchirkansapa. Ichará kankunaka yuyankichi chay wañudu runakuna Jerusalenpi kawsakmasinkunamanta ashwan uchasapakuna kashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mash allita uyariwaychi. Chay wañuk runakunaka manami ashwan uchasapachu karkansapa. Kankunapish mana uchaykichimanta wanashpaykichika paykunashina wañunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chaymanta Jesus suk ejempluta rimashpa yachachikurkan: —Suk runapa uva chakranpi suk igo kaspi tiyarkan. Chay runa rirkan chay kaspita chapak yachanayashpa wayuyuknachu manachu nishpa. Kawak rishpa mana nima wayuyuktachu tarirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chaypina chakranta kuydak runata willarkan: “Ñami kimsa watatana shamuni kay igo kaspita chapak wayunkunata munashpayni. Kunankaman mana nima wayuyuktachu tarimuni. Kunanka waktakuy ama kay allpapi yankamanta kananpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chashna waktakunanpa willaptin chakran kuydak runaka patronnintaka willarkan: “Amara waktakuyparachu. Aku suk watatara shuyaypa ichará wayuchakunka. Allpanta aspishpa ñupuyachisha. Chaymanta animalkunapa ismankunata churasha. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ichará chaywan wayuchakunka. Mana ni chaywan wayuchakuptinka willawanki waktakunaynipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Samana diya kaykaptin Jesuska yachachikuykarkan tantanakunankuna wasipi. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaypi tiyarkan suk unkudu warmi. Payka chunka pusak watatana kumurayadu kawsarkan supay unkuchiptin. Mana nima kuskayayta atiparkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesuska payta llakichishpa willarkan: —Wambrayni, ¡kuskayamuyna! ¡Ñami sanuna kanki! ");
INSERT INTO qvsNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chaypina Jesus paypi makinta churashkan oras chay warmika kuskayarkan. Chashna alliyashpana sukaman kushikushpa Tata Diosta alabarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Alliyachishkanta kawashpana chay tantanakunankuna wasipi kamachikuk runa sukaman piñakurkan. Payka piñakurkan Jesus samana diyapi chay warmita alliyachishkanrayku. Chay kamachikuk runaka chay aypa runakunata piñayashpa willarkansapa: —¡Sokta diyatami allima trabajananchipaka! Unkudu kashpaykichika shamuychi chay sokta trabajana diya kay runa alliyachishunaykichipa. ¡Ama shamuychichu samana diyapi kay runa alliyachishunaykichipa! ");
INSERT INTO qvsNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chashna chay kamachikuk runa piñakuptinna Jesuska willarkan: —Kankuna llullakushpa rimankichi alli rurak runakuna kanaykichita. ¿Manachu samana diya kaykaptinpish vakaykichita burruykichita paskankichi yakukuk pushanaykichipa? ");
INSERT INTO qvsNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Manachu Tata Dios burruykichimanta vakaykichimanta kay warmita ashwanta llakichin? Payka ñawpa awilunchi Abrahampa mirakninmi. ¿Imapatí kay samana diya mana alliyachiyman? Chunka pusak watatanami supayka kay warmitaka watashpa kumurayachishpa unkuchishka. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chashna Jesus rimaptinna chiknik runakunaka sukaman pinkachinakurkansapa. Chaymanta Jesusta kuyak runakunaka sukaman kushikurkansapa kawashpankuna chay almiranakunata ruraptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chaymanta Jesuska kashkan yachachirkansapa: —Suk ejempluta parlachiykichi entiendinaykichipa imashnami Tata Diospa mandunpi kawsankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kankuna Tata Diospa mandunpi kawsashpaykichika takshasillu mostasa murillukunashina kankichi. Suk runa chay murilluta chakranpi tarpun. Chaypi chay murillu wiñashpa ramachakun. Ramachakuptin aypa pishkillukuna chaypi wasichakunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Chaypina Jesuska willarkansapa: —Kashkan suk ejempluta yachachiykichi entiendinaykichipa imashnami Tata Diospa mandunpi kawsankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Suk warmi panta rurashpa aypa machkawan suk tipi levadurata churashpa chakrun. Levadurata churaptin tukuy chapuduta allita pukuchin. Kankuna Tata Diospa mandunpi kawsashpaykichi chay alli levadurashina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Chaymanta yachachikushkanwasha Jesuska Jerusalenman rirkan. Chayman riykashpa llaktan llaktanpi yachachikuypi rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chaypina suk runa tapurkan: —Maestru ¿manachu Tata Dioska aypa runakunata kastigunmanta salvashpa sielupi yaykuchinkasapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Chashna tapuptin Jesuska willarkan: —Tata Diospa kawsananpi yaykunayashpaykichika suk llañu punkutashina yaykunaykichi tiyan. Modosta ruraychi chaypi yaykunaykichipa. Allita willaykichi. Aypa runakuna chay punkuta yaykunayashpankunapish manami tukuychu atipansapa yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ñuka wasi doyñunshina kashpayni punkuta wichkaptini kankuna washamanta kayawashpa willawankichi: “¡Señor, punkuta kichariy yaykunaynikunapa!” Chashna willawaptikichi ukumanta willashkaykichi: “Manami riksiykichichu maymantami kankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chaypina willawankichi: “Kanwan tantalla mikushkanisapa upyashkanisapa. Llaktaynikunapi chayashpayki yachachiwarkankisapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chashna willawaptikichi kashkan willashkaykichi: “¡Manami riksiykichichu! Kankunaka sukaman mana alli rurak runakuna kankichi. ¡Chayrayku ñukamanta ashuychi!” ");
INSERT INTO qvsNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chashna willaptini kankunaka sukaman llakishpa kiruykichita mukushpa wakanaykichi tiyan. Chaypina Tata Diospa kawsananpi ñawpa awilunchi Abrahamta Isakta Jakobota kawankichi. Chaymanta tukuy ñawpa yachachikuk runakunata kawankichi. Tukuy paykunata kawashpaykichi sukaman llakishpa wakakunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Inti llukshimunanmanta inti yaykunanmanta anakmanta uraymanta aypa runakuna Tata Diospa kawsananpi yaykunkasapa. Tukuy paykuna tiyarishpa mesapi mikunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Suk kankuna yuyankichi primeru Tata Diospa mandunpi yaykuyta. Chashna yuyaptikichipish Tata Dioska washata yaykuchishunkichi. Chaymanta chay mana yaykuyta yuyanakuk runakunata Tata Dioska primeru yaykuchinka. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesus Jerusalenman riykaptin fariseo runakuna ladunchashpa willarkansapa: —Chay kamachikuk Herodesmi wañuchichishunayanki. Chayrayku kayllamanta kutiy. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chayta willaptinkunana Jesuska willarkansapa: —Herodeska suk manchana laya animalshina manchachiwanayan. Rillaychi willak: Ñuka Tatayni Dios willawashkanta tukuchanaynikaman ruranayni tiyan. Willaychi runakunamanta supaykunata llukshichiykanaynita unkudukunata alliyachiykanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kunan kaya kayawashan Tata Diospa munananllata rurashpa katisha. Tukuy chayta rurashpa Jerusalen llaktapi wañunayni tiyan. Jerusalenpi awilunchikuna ñawpa alli yachachikuk runakunata wañuchirkansapa. Chayrayku chay llaktallapi kankunapish ñukata wañuchiwanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Llakichiykichi, Jerusalenpi kawsak runakuna. Kankunaka tukuy alli yachachikuk runakunata wañuchinkichi. Chaymanta Tata Dios kachamushkan yachachikuk runakunatapish ruminchashpa wañuchinkichi. Ñuka aypa kuti kankunata amachanayashkaykichi iden suk wallpa wawankunata tantanachishpa rikran sikipi amachakshina. Sukaman kankunata amachanayaptinipish mana nima munankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mash uyariwaychi. Mana munawashkaykichirayku llaktaykichi chunlla likidu kiparinka. Chaymanta willaykichi: Suknin diya kankunaka willawanaykichi tiyan: “Kanka sukaman allimami kanki Tata Diosmanta shamudu runa kashpayki.” Chashna willawanaykichi diyakaman mananami kawawankichinachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Suk diya Jesuska rirkan kamachikuk fariseo runapa wasinpi mikuk. Chay diya karkan samana diya. Chaypi mikuykaptinna Jesusta chiknik fariseo runakuna chatanayashpankuna chapaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chaypina Jesuspa ñawpakninman shamurkan suk punkiy unkuyuk runa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus payta kawashpa fariseokunata Moisespa killkadunta yachachikuk runakunata tapurkansapa: —¿Imatatí Moisespa killkadunpi yachachiwanchisapa? ¿Almitiwanchichu manachu samana diya unkudu runata alliyachinanchipa? ");
INSERT INTO qvsNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chashna Jesus tapuptinkunana chay fariseo runakunaka mana nimata aynirkansapachu. Chaypina Jesuska chay unkudu runataka makinmanta apishpa alliyachishpa willarkan wasinman kutinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chaymanta fariseokunata willarkansapa: —May willawaychi. Samana diya ichara wambraykichi vakaykichi suk uchkupi urmanman. Samana diya kaptin ¿maykan kankunatí chay uchkupi urmaduta mana surkunkichiman? ");
INSERT INTO qvsNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chashna Jesus willaptinkunana fariseo runakunaka mana nimata atiparkansapachu ayniyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chay fariseopa wasinpi mikuk yaykushpankuna runakuna munarkansapa ashwan alli bankupi tiyariyta. Chayta kawashpana Jesuska willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mash uyariwaychi. Suk kasarachikuk runa funsiaman konvidashuptikichika ama chay kasarakkunapa ladunpi tiyariychichu. Chaypi tiyariptikichika ichara kanmanta ashwan munadu runa washata shamunman. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kankuna chay alli bankupi tiyariptikichika kasarachikuk runaka ladunchashushpaykichi willashunkichiman: “Kay bankumanta atariy kay runa tiyarinanpa.” Chashna willashuptinkuna pinkaynikichita muchushpaykichi rinkichi washa bankupi tiyarik. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chayrayku kasarachikuk runa konvidashuptikichika chayana bankullapi tiyariychi. Chayllapi tiyariptikichi ichara chay kasarachikuk runaka yaykuchishunkichiman mesapi mikunaykichipa. Chaypirami kankunawan tiyaridu runakunaka kawankasapa ashwan munadu kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kankuna kikikichilla kreyinakushpa kawsaptikichi Tata Dios pinkachishunkichi. Kankuna allillapi mana kreyinakushpa runamasikichita kuyashpa yanapaptikichi Tata Dios sukaman kushikushpa yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaymanta Jesuska chay wasinpi karak fariseota willarkan: —Kanka konvidakushpayki mikuk shamunankunapa ama konvidaychu parlakmasikikunallata, nima wawkikikunallata, nima aylluykikunallata, nima tukuy layayuk llaktamasikikunallata. Paykunata konvidaptikika kantapish konvidashunkasapa. Kankuna sukwan sukwan kutichinakushpaykichi kikikichilla kushichinakuykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ashwan allita ruranayashpa fiestaykiman yaykuchiy mikuk mana nimayuk runakunata, makin tipidukunata, kojokunata, mana kawakukkunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tukuy chay laya runakunata konvidaptiki paykunaka mana kutichishuyta atipankasapachu. Chaypira Tata Dios tukuy alli rurak runakunata kawsachimushkan diya premyuykita kushunki. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesus yachachikuptin uyarishpana chay mesapi mikuykak runakunamanta suk runa paytaka willarkan: —Tata Dios sielupi suk fiestata ruraptin chaypi mikuk runakuna sukaman kushikunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chashna chay runa willaptin Jesuska suk ejempluta rimashpa willarkan: —Suk runa atun fiestata rurashpa aypa runakunata konvidachirkan wasinpi mikuk rinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mikuna alli kaptinna suk wiwachunta kacharkan tukuy konvidadukunata kayak. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chashna kayak riptin paykunaka aynirkansapa mana atipanankunata riyta. Suk runa willarkan: “Chayrak chakrata rantishkani. Chayta kawak rinayni tiyan. Chayrayku willay ama piñakunanpa mana riptini.” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Suk konvidadu willarkan: “Chunka vakatami rantishkani. Chaytami rinayaykani kawak allichu manachu nishpa. Chayrayku willay ama piñakunanpa mana riptini.” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chaymanta suk konvidadu willarkan: “Chayrak kasarashkani. Warminita mana sakiyta atipanichu. Chayrayku mana rinichu chay fiestaman.” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chashna mana niman suk runa katinayaptinkuna chay kayakuk runaka kutirkanna. Chaypina fiestakuk runata willarkan mana ni pi shamunayanankunata mikuk. Chayta uyarishpa fiestakuk runaka sukaman piñakurkan. Piñakushpa wiwachuntaka willarkan: “Kunanka utkakushpa rillay kayamuysapa kallipi plasapi tiyak runakunata. Pushamuysapa mana nimayukkunata, makin tipidukunata, kojokunata, mana kawakuy atipakkunata. Tukuy paykunata konvidamuysapa mikuk shamunankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chashna willaptin wiwachunka tukuy willashkanta rurarkan. Chaymanta fiestayuktana willarkan: “Tata, ñami tukuy willawashkaykitana rurashkani. Aypa runakunata pushamuptinipish pishinllami kay wasiki untananpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chashna chay wiwachun willaptinna fiestakuk runaka willarkan: “Rillay ñankunamanta chaymanta wasi pampankunapi puriykak runakunata pushamuk. Apurashpa pushamuysapa kay wasini untananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Allita willaykichi. Chay ñawpakta konvidadukunaka manami kay fiestaynipika mikunkasapanachu.” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chaymanta mikushkankunawasha Jerusalen llaktaman Jesuska rirkan. Chayman riykaptin aypa runakuna katirkansapa. Jesuska tikrakushpa chay katik runakunata yachachirkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Kankuna disipuluynikuna kanayashpaykichika tataykichimanta, mamaykichimanta, warmikichimanta, wambraykichimanta, wawkikichimanta, panikichimanta ñukata ashwan allita kuyawanaykichi tiyan. Kuyanakunaykichimanta ashwan allita ñukata kuyawaychi. Mana chashna allita kuyawashpaykichika manami disipuluynikunachu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sukaman padesishpaykichipish runakuna chiknishuptikichipish ñukallata katiwanaykichi tiyan. Allita katiwashpaykichika disipuluynikunami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mash allita uyariwaychi. Suk runa kuydakunan altu wasita ruranayashpa allita yuyaykunan tiyan imakunatami chay wasipaka munan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mana allita yuyaykushpa ichara kallarinanllapi sakinman mana tukuchayta atipashpa. Chay mana tukuchadu wasita kawashpa tukuy runakuna chay wasichakuk runata asichishpa rimanmansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mash kawaychi. Chay runaka llullakushpa kallarishka wasichakuyta. Manami atipanchu tukuchayta.” Kankunapish chay wasichakunayak runashina allita yuyaykushpa ñukata katiwanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chaymanta ichara suk sinchi kamachikuk runa makanakunayanman chikan llaktapi kamachikuk runawan. Chaypaka allita yuyaykunan tiyan: “Ñukapa chunka waranka soldaduynikunalla tiyan. Chay suk kamachikuk runaka ishkay chunka waranka soldadukunawan shamuykan. ¿Atipashachu manachu makaytaka?” ");
INSERT INTO qvsNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chaypina mana makayta atipananta yuyashpa chay kamachikuktaka willachinan tiyan amana shamunankunapa makanakuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kankunapish chay makanakunayak runashina allita yuyaykuychi katiwankichichu manachu nishpa. Mana tukuy layaykichita sakishpa katiwashpaykichika manami disipuluynikunachu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Chaymanta Jesus willarkansapa: —Sinchi kachika rikchak layapami alli. Allpayuk kachi mana nimapa allichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chay allpayuk kachita allpapi churaptinchipish mana nimapa allinachu nima kiwata wiñachinanpa. Mana nimapa alli kaptin wishchunchi. Allita uyariwaychi. Kankunapish mana allita kreyiwashpa kawsashpaykichika chay mana alli kachishinami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Chaymanta Jesus yachachikushkanwasha aypa runakuna laduncharkansapa ashwanta uyarinayashpa. Suk runakuna karkansapa romano gobiernupa kullki kobrakukkuna. Sukkuna karkansapa mana allita rurashpa kawsak runakuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chay aypa runakuna Jesusta ladunchaptinkuna fariseokuna Moisespa killkashkanta yachachikuk runakuna kawarkansapa. Paykunaka Jesusta washanchashpankuna rimarkansapa: —Kay runaka chay uchasapa runakunata munashpa paykunawan mikun. Paykunawan mikushpa mana allitachu ruran. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mana allita ruraykananta rimaptinkuna Jesuska uyarirkan. Chaypina suk ejempluta willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ichara kankunapa tiyan pachak ovejaykichi. Chay pachakmanta ichara suk oveja chinkanman. Kankunaka chay aypa ovejaykichita pastupi sakishpaykichi ¿manachu chay chinkaduta rinkichi maskak tarinaykichikaman? ");
INSERT INTO qvsNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tarishpaykichi kushikuypuru wantushpa wasikichiman pushankichiman. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Chaypina familyaykichita aylluykichita tantanachishpa kushikushpa willankichiman: “Shamuychi ñukawan kushikuychi. Ñami kay ovejayni chinkadutaka tarishkanina.” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mash allita uyariwaychi. Kankuna suk chinkadu ovejaykichita tarishpaykichi sukaman kushikunkichi. Chashnami sielupi kawsakkunapish iskun chunka iskun alli rurak runakuna tiyashkanmanta ashwanta kushikunsapa suk runa uchanmanta wanaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Chaymanta Jesuska chikan ejempluta yachachikurkan: —Ichara suk warmi chunka kullkinkuna tiyapushkanmanta sukta chinkachinman. ¿Manachu chayta maskan tarinankaman? Alkusanta apichishpa wasinta kuchun mañanta pichashpa maskan. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tarishpana kushikuyninwan warmimasinkunata tantanachishpa willanka: “Ñukawan kushikuychi. Ñami chay chinkadu kullkinitaka tarishkanina.” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mash allita uyariwaychi. Chay warmi kullkinta tarishpa sukaman kushikurkan. Chashnashina angelkunapish sukaman kushikunsapa suk runa uchankunamanta wanaptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesuska chikan ejempluta yachachikurkan: —Suk runapa tiyarkan ishkay ullku wambrankuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Suk diya winshu wambran tatantaka willarkan: “Tatayni, patumawayna tukuy ñukata kuwanaykitana.” Chashna mañaptinna chay runa tukuy tiyapunanta ishkantin wambrankunata patumarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chaypina chay winshu wambranka tatan tukuy kushkanta rantikurkan. Chay kullkiwan rirkan suk karu llaktapi kawsak. Chay karu llaktapina sukaman mana allikunata rurashpa tukuy kullkinta tukucharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chaypina chay kawsanan llaktapika sinchi yarkay tiyarkan. Chay wayna mana kullkiyuk kashpana yarkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chashna sukaman yarkashpa rirkan willak suk runata trabajachinanpa. Chay patronka kacharkan chakranpi kuchinkunata karashpa trabajananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Chaypina chay waynaka kuchikunapa mikunanta sukaman mikunayarkan. Munaptinpish mana ni pi ni chay laya mikunata kararkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sukaman yarkashpana tatanta yuyashpa rimarkan: “Tataynipa trabajadorninkunapa aypa mikunankuna puchun. Chaykamanka kaypika yarkaymanta ñuka wañunayaykani. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Shu kunanlla tatayniman kutisha. Kutishpayni willasha: ‘Munanayni tatayni, kanmanta ashushpaynika uchallikushkanimi. Chaymanta mana Tata Diospa munananta rurashpa kawsashkani. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Chayrayku amana kawawaynachu wambraykitashina. Suk trabajadornikitashina trabajachiway.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chashna allita yuyaykushpa chay waynaka tatanman kutirkan. Tatanpa wasinpi manara chayaptinra karupi kaptinlla tatanka riksirkan. Sukaman llakichishpa kallparkan tinkuk. Chaypina wambranta abrasashpa mucharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Payka tatantaka willarkan: “Munanayni tatayni, kanta sakishpayni Tata Diosta rabyachirkani kantapish rabyachishkayki. Amana kawawaynachu wambraykitashina.” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Chashna willaykaptinna tatanka trabajadorninkunata kayashpa willarkansapa: “Utkakushpa apamuychi mushuk llachapata wambraynita mudachinaykichipa. Chaymanta suk anilluta dedunpi churapuychi. Mushuk ushutantapish churachiychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chaymanta rillaychi pushamuk chay ashwan gordo beshekuta. Chayta wañuchishpa fiestata rurashpa mikuypachi. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay wambrayni wañudu kashkanmantashina unay tiempumantanami rikurimushka. Chinkadu kashkanmanta ñami rikurimushkana.” Chashna chay runa rimaptin alli fiestata rurarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Chay fiestata ruraykaptinkuna chay mayor wambranka chakranpi karkan. Chakranmanta kutimuykashpa wasinpi chayaykashpa bombota kenata uyarirkan fiestata ruraykaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Fiestakuykaptinkuna uyarishpana tatanpa trabajadorninta kayashpa tapurkan: “¿Imatatí ruraykansapa tataynipa wasinpi?” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chaypina chay runaka willarkan: “Chay chinkadu wawkikika ñami rikurimushkana. Chayrayku tataykika kushikuyninwan alli fiestata ruraykan. Wawkiki sanu chayamushka kaptin ashwan gordo beshekuta wañuchichishka.” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chashna willaptinna chay mayor wambranka sukaman piñakurkan. Mana nima chay fiesta wasipi yaykunayarkanchu. Fiesta wasimanta tatanka llukshishpa rirkan willak paywan fiestakuk yaykunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chaypina chay wayna piñakushpa tatantaka willarkan: “Kanka allita yachanki aypa watatana mana ni mayman suchushpayni kanta yanapashkaynita. Chashna allita yanapaptinipish mana niman suk kuti niman suk chivuta kuwashkankichu amiguynikunawan fiestata rurashpa mikunaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kunan waynandera warmikunawan uchallikushpa kullkikita tukuchak wambrayki chayamushkana. Chayamuptin paypana chay ashwan gordo beshekuta wañuchishpa alli fiestata ruraykanki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chashna chay mayor wambran piñakushpa willaptinna tatanka willarkan: “Munanayni wambrayni, kanka tukuy diyami ñukawan kawsaykanki. Tukuy laya tiyawakmi kanpa kanan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Chaykuna kanpa kaptin ¿imapatí piñayawanki? Kay wawkikika wañudu kashkanmantashina rikurimushka. Chinkadu kashkanmanta ñami rikurimushkana. Chayrayku alli kashka fiestata rurananchipa. Akuychi kushikushpa fiestakuypachi.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Chaymanta Jesuska disipulunkunata suk ejempluta willarkansapa: —Suk kullkisapa runa tiyarkan. Chay aypa kullkiyuk runa suk empleadunta willarkan tukuy tiyapunanta kuydananpa tukuy trabajadorninkunatapish trabajachinankunapa. Suk diya chay trabajadorkuna patronninkunapi rirkansapa chay trabajachikuk runata chatakuk. Willarkansapa: “Ñami kullkikitaka tukuchaykanna mana allikunata rurashpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chashna chatakuptinkunana patronka chay empleadunta kayashpa willarkan: “Yachashkani llullachiwaykanaykita. Kunanmantapacha manana munaninachu ñukapi trabajanaykipa. Chayrayku kawachiway chay killkashkaykita imakunatami rantikushkanki imakunatami rantishkanki nishpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chashna patronnin willaptinna chay runaka sukaman llakishpa yuyaykurkan: “Patronnini kay trabajuynimanta surkuwaptinka ¿imata rurashpanatí kawsasha? Mana atipanichu chakrata rurashpa trabajayta. Pinkakuni kullkita mañakushpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mana trabajuyuk kaptini runakuna wasinkunapi chaskiwanankunapa ñami yuyashkanina imatami rurasha nishpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chashna yuyashpa chay empleaduka patronninta debik runakunata sukmanta sukmanta kayarkansapa. Sukta tapurkan: “Kanka ¿mashnatati patronninitaka debinki?” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Payka willarkan: “Ñuka pachak lata aseytitami debini.” Chaypina chay empleaduka willarkan: “Mash kaway. Ñukami yanapashkayki. Kaypimi killkadu chay debishkaykika. Kunan tiyarishpa mushuktana killkay. Pichka chunka lata aseytita debinaykillata killkay. Ñukapish chayllata killkasha patronnini kawananpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chashna chay debikuk runata killkachishkanwasha chay empleaduka sukta tapurkan: “Kanka ¿mashnatati patronninitaka debinki?” Payka willarkan: “Suk pachak kostal trigutami debini.” Chaypina chay empleaduka willarkan: “Mash kaway. Ñukami yanapashkayki. Kaypimi killkadu debishkaykika. Kunan pusak chunka kostal debinaykillata killkay. Ñukapish idenllata killkasha patronnini kawananpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chaymanta chay patron empleadun rurashkanta yachashpa rimarkan: “Chay empleaduynika yachaysapami kashka. Payka debiwak runakunata yanapashka paykunapish payta yanapanankunapa.” Chay ejempluta rimashkanwasha Jesuska disipulunkunata willarkansapa: —Mana alli rurak runakuna Tata Diosta riksik runakunamanta sukaman ashwan yachaysapakunami. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mash allita uyariwaychi. Tukuy kay allpapi tiyapushunaykichiwan sukkunata yanapaychi paykuna sukaman kuyashunankunapa. Chashna tiyapushunaykichiwan runamasikichita yanapaptikichi sielupi paykuna kushikushpa chaskishunkichi mana tukuyniyukta chaypi kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kankuna kuskata rurashpa mana llullakushpa tipi tiyashunaykichiwan runamasikichita yanapashpaykichika aypa tiyashunaykichiwanpish mana llullakushpalla yanapankichi. Chaymanta tipi tiyashunaykichiwan runamasikichita llullachishpaykichika aypa tiyashunaykichiwanpish llullachishpa mana yanapankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chashnami kankuna kay allpapi tiyashunaykichiwan mana runamasikichita yanapaptikichika Tata Dios sielupi mana premyuykichita kushunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chaymanta runamasikichipa tiyapunanta mana kuydayta yachaptikichi Tata Dioska manami ashwantachu kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Suk trabajador mana atipanchu ishkay patronpi trabajayta. Sukllallata kasunan tiyan. Suk patronninta kasushpa suktaka mana kasunnachu. Kankuna chay trabajadorshina kankichi. Kankunapish kullkiyayta munashpalla kawsashpaykichika manana atipankichinachu Tata Diosta kasushpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chashna Jesus yachachikuptin uyarishpankuna chay kullkita sukaman munak fariseokuna Jesusta asichirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chaypina Jesuska willarkansapa: —Kankuna mana alli rurak runakuna kaykashpaykichipish munankichi tukuy runakuna rimanankunapa alli rurak kanaykichita. Tata Dioska tukuy mana alli yuyaynikichita allita riksin. Chay laya yuyaynikichita Tata Dios kawan millanapa layata. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tukuy ñawpa alli yachachikuk runakuna Moisesmanta Juankaman Tata Dios kachamunan runa shamunanta yachachikurkansapa. Chay tiempumantapacha ñuka yachachiykichi Tata Diospa mandunpi yaykunaykichita. Aypa runakuna sukaman munashpa sinchikushpa padesishpa yaykuykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kay allpa chay sielu kulluptinpish Tata Dioska killkadunpi tukuy rimashkanta ruranka. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Chaymanta Jesus willarkansapa: —Kankunaka yuyankichi warmikichita wishchushpaykichika mana uchallikuykanaykichita. Chayta yuyashpaykichika kikikichilla llullachinakuykankichi. Warmikichita wishchushpa chikan warmiwan kasarashpaykichika uchallikuykankichimi. Chaymanta chay wishchudu warmiwan kasarak runapish uchallikuykan. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesuska chikan ejempluta willarkansapa: —Suk tukuy layayuk runa tiyarkan. Chay runaka sukaman allima llachapanta mudakuk. Tukuy diya allima fiestakunata rurak. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chaymanta tiyarkan suk mana nimayuk runa. Paypa shutin karkan Lasaro. Lasaroka kiri likidu karkan. Payka tukuy diya tiyarik chay aypa kullkiyuk runapa wasin punkupi. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Chay kiri likidu runa sukaman mikunayak tukuy layayuk runapa mesanmanta urmachidukunata. Chay punkupi tiyaridu kaptin allkukuna kirinkunata llakwapuksapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Suk diyana chay Lasaroka wañurkan. Tata Diospa angelninkuna payta pusharkansapa Abrahamwan sielupi kawsananpa. Chaymanta chay aypa kullkiyuk runapish wañurkanna. Paytaka pamparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chay runaka rirkan mana tukuyniyuk nina rawrakman. Chaypi sukaman padesiykashpa karumanta kawarkan Lasarota Abrahamwan tantallata. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Payta kawashpana sinchita rimashpa Abrahamtaka willarkan: “Tatayni Abraham, llakichiwashpa Lasarota willapay shamunanpa kalluyni puntata suk tipi yakuwan ñuyuchipak. Ñukaka kay ninapi sukamanmi padesiykani.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Chashna willaptinna Abrahamka willarkan: “Wambrayni, allita yuyay allpapi kawsashkaykita. Kan sukaman allita kawsashkanki. Kay Lasaroka allpapi kawsashpa sukaman yarkarkan sukaman padesirkan. Kunanka payka kushikuykan. Kanka sukaman padesiykanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chaymanta tiyan suk manllayba rarka ama ni pi pasananpa. Chayrayku kanman Lasaroka mana atipanchu riyta. Nima kanpish atipankichu kayman chayamuyta.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chashna willaptinna chay tukuy layayuk kashka runaka willarkan: “Tatayni Abraham, roygayki Lasarota kachanaykipa tataynipa wasinman. ");
INSERT INTO qvsNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Payta kachaptiki pichka wawkinikunata yachachinmansapa ama ñukashina kay mana tukuyniyuk ninaman shamunankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chashna willaptinna Abrahamka willarkan: “Paykunapa tiyan Moisespa killkadunkuna. Chay killkadunkunapi willashkankunata kasuchunsapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chaypina chay runaka aynirkan: “Ariya tata Abraham, chay wawkinikuna mana Moisespa killkadunta kasunayansapachu. Ichara suk wañudu runa kashkan kawsamushpa yachachikuk riptin kreyikunmansapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chaypina Abrahamka willarkan: “Chay wawkikikuna mana Moisespa nima alli yachachikuk runakunapa yachachikunanta kasunayansapachu. Chashnashina mana nima kreyinkasapachu suk wañudu runa kashkan kawsamushpa riptin yachachikuk.” ");
INSERT INTO qvsNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Chaymanta Jesuska disipulunkunata willarkansapa: —Kay allpapi tiyan uchallichishunayak runakuna. Tukuy paykunata Tata Dioska sukaman kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amarapish uchallichishuptinkunara alli kanman suk atun rumi makita kunkanpi watashpa atun yakupi wishchunankunapa. Sipikushpankuna manana ni pita uchallichinkasapanachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Allita kuydanakuychi ama uchallikunaykichipa. Tata Diosta kreyikmasiki rabyachishuptin rillay willak amana mana allita rurashunanpa. Chaypina almitishuptin perdonay. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kuti kuti rabyachishuptinpish perdonanayki tiyan. Ichara suk diyapi kanchis kuti rabyachishunkiman. Chaymanta ichara kanchis kuti willashunkiman: “Mana kashkan rurashanachu” nishpa. Chashna willashuptikika perdonanayki tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chashna Jesus yachachikuptinna disipulunkunaka willarkansapa: —Maestru, yanapawaysapa ashwanta kanta kreyinaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chashna disipulunkuna willaptinkuna Jesuska willarkansapa: —Ñukata tukuy shunku kreyiwashpaykichika chay wiñaykak kaspita willankichiman: “Kaymanta ashushpa rillay wiñamuy chay yaku mañanpi.” Chashna willaptikichi chay kaspika kasushunkichi. Taksha murillushina tipisitullatapish kreyiwashpaykichika tukuy willashkaynita atipankichiman rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kankunapa wiwachuykichi rinman chakraykichipi trabajak. Chaypi allpata araduwan aspin. Vakaykichitapish kuydan. Chaymanta chakraykichimanta kutimuptin kankuna mana willankichichu: “Shamuy mikuyna” nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ashwan willankichi: “Mikunaynita shamuy rurak. Ñuka mikuykaptini upyaykaptini sirvimuway. Karawashkaykiwasharami kanka mikunki upyanki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chaymanta chay wiwachuykichita mana willankichimanchu: “Allita karawashkanki” nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chay wiwachuykichishina Tata Dios willashushkanta rurashpaykichi willanaykichi tiyan: “Kan willawashkaykita rurashkanisapa. Chayrayku mana meresinisapachu alabawanaykipasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Chaymanta yachachikushkanwasha Jesuska disipulunkunawan Jerusalenman rirkansapa. Chayman rishpankuna Samaria partita Galilea partita puriykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Chayta rishpankuna suk llaktapi chayarkansapa. Chaypi chunka runakunawan tinkunakurkansapa. Tukuy paykuna kiri likidu lasaru unkuyuk karkansapa. Paykunaka mana animukurkansapachu Jesusta ladunchayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Karullamanta sinchita rimashpa willarkansapa: —Maestru, ñukaykunatapish llakichiwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chaypina Jesuska paykunata kawashpa llakichishpankuna willarkansapa: —Saserdotekunaman rillaychi paykuna yachanankunapa allinachu kankichi manachu nishpa. Chashna willaptinkuna chay chunka runakunaka rirkansapana. Manara saserdotekunapi chayashpankunara chunkantin alliyarkansapa Jesus alliyachiptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kirinmanta alliyadu kawanakushpa chay chunkamanta suk runalla Jesusman kutirkan. Kushikushpa sinchita rimashpa Tata Diosta sukaman alabarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kushikuypuru rirkan Jesuspa ñawpakninpi kunkurikushpa agradesik. Chay kutimuk runaka Samaria partimanta karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chay runalla kutimuptin Jesuska almirashpa disipulunkunata willarkansapa: —Chunkantinta alliyachishkani. ¿Maysapanatiya chay iskun runakunaka? ");
INSERT INTO qvsNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Kay Samariamanta runallachu kutimushka Tata Diosta alabananpa? ");
INSERT INTO qvsNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chaypina chay kutimushka runata Jesuska willarkan: —Atariyna. Wasikimanna rillay. Ñukata kreyiwashkaykiraykumi alliyachishkayki. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chaymanta fariseo runakunaka Jesusta tapurkansapa: —¿Aykapikamanti Tata Dios kallarinka tukuy runakunata kayayta mandunpina kawsanankunapa? Chashna tapuptinkuna Jesuska willarkansapa: —Mana kay allpapi kankunapa kamachikuknikichishinachu Tata Dios kamachikun. Mana atipankichichu kawayta kamachikunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mana atipankichichu willayta kaypimi chaypimi Tata Dios kamachikuykan nishpa. Mana kawaptikichipish Tata Dios kreyikuk runakunata shunkunkunapi kamachiykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Fariseo runakunata yachachishkanwasha Jesuska disipulunkunallata willarkansapa: —Kankunaka sukaman padesinaykichi tiempu munankichi kawawayta Tata Diosmanta shamudu runa kashpayni kallariptini kamachikuyta. Sukaman munashpaykichipish mana kawawankichichu kay allpapi kamachikuptini. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sukkuna llullakushpa rimankasapa: “Kaypinami chaypinami Jesuska” nishpa. Chashna rimaptinkunapish ama rillaychichu kawak. Nima paykunata katiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mash allita uyariwaychi. Tamyanayaptin llipyashpa tukuy sieluta lusichin. Chay llipyakshina ñukapish kashkan shamushpayni tukuy sieluta lusichisha. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Chaymanta manarapish kashkan shamuptini aypa runakuna sukaman chikniwashpa padesichiwankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Chay ñawpa Noe yachachikuptinpish tukuy runakuna chiknishpa mana munarkansapachu kreyiyta. Paykunaka mikuykarkansapa upyaykarkansapa kasaraykarkansapa kasarachikuykarkansapa yachachikuk Noe manllayba barkunpi yaykunan diyakaman. Noe chay barkupi yaykuptinna Tata Dios tamyawan allpata untachiptin tukuy runakuna sipikushpa wañurkansapa. Iden Noepa tiempunpishina aypa runakuna kankunatapish mana kreyishushpaykichi padesichishunkichi. Chaypina ñuka Tata Diosmanta shamudu runa kashpayni kashkan kutimusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chay ñawpa Lotpa tiempunpipish Tata Dios Sodoma llaktapi kawsak runakunata kastigarkansapa. Chay runakuna Tata Diosta mana kreyishpankuna mikuykarkansapa upyaykarkansapa tukuy layata rantiykarkansapa rantikuykarkansapa. Chaymanta wasinkunata ruraykarkansapa chakrankunapi tarpukuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Chaypina chay llaktamanta Tata Dios Lotta llukshichishkanwasha sielumanta chay llaktapi sinchi rawraykak ninata urmachimurkan. Chaywan tukuy runakuna rupashpa wañurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chashnashina ñukapish Tata Diosmanta shamudu runa kashpayni kashkan shamushpayni tukuy mana kreyiwak runakunata kastigashasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Chay tiempuka kankuna wasikichi sawanpi kashpaykichi ama yaykuychichu tiyapushuknikichita surkuk. Chakraykichipi kashpaykichi ama wasikichiman kutiychinachu nimata surkuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Allita yuyaychi Lotpa warmin wañushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kankunapish munanaykichillata rurashpaka wañunaykichi tiyan. Ñukata kreyiwashpa kawsashpaykichika wañushpaykichipish kashkan kawsamunaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mash allita uyariwaychi. Chay padesinaykichi tiempu suk kawitullapi ishkaymanta puñuykaptinkuna ñukaka sukllallata sieluman pushasha ñukawan kawsananpa. Sukta sakisha mana kreyiwashkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishkay warmikuna kutakuykaptinkuna ñukaka sukllallata sieluman pushasha ñukawan kawsananpa. Sukta sakisha mana kreyiwashkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishkay runakuna chakranpi trabajaykaptinkuna ñukaka sukllallata sieluman pushasha ñukawan kawsananpa. Sukta sakisha mana kreyiwashkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chashna Jesus yachachikuptin uyarishpana disipulunkunaka tapurkansapa: —Maestru ¿maypiti runakunata kastiganki? Chashna tapuptinkuna Jesuska willarkansapa: —Wañudukuna kananpi siyukakuna tantanakunsapa mikunankunapa. Ñukapish tukuy mana alli rurak runakunata tantanachishasapa kastiganaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesuska disipulunkunata suk ejempluta yachachirkansapa. Willarkansapa ama shaykushpa Tata Dioswan parlanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kay ejempluta willarkansapa: —Suk llaktapi tiyarkan suk awtoridar jues. Chay jueska mana Tata Diosta manchakchu karkan. Nima runamasinkunata kasukchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay juespa kawsanan llaktapi tiyarkan suk viyuda warmi. Suk runa chay warmitaka tiyapunanta kichunayak. Chay warmika rirkan chay runata juespi chatak. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Aypa kuti chay warmi mañakukuptinpish chay jueska mana yanapanayashpa mana kasurkanchu. Chay warmi kuti kuti amichiptinna chay jueska yuyayninllapi rimarkan: “Ñuka Tata Diosta mana nima manchanichu. Mana nima runamasinikunata kasushpaynipish shu yanapasha kay viyuda warmita. Payka sukaman unaytanami amichiwaykan yanapanaynipa. Yanapaptini ichará manana kutin shamunkanachu amichiwak.” ");
INSERT INTO qvsNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chayta yachachikushpa Jesuska willarkansapa: —Chay jueska Tata Diosta mana manchak kashpapish rimarkan chay warmita yanapananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kankunaka Tata Diospa aklladunkunami kankichi. Chayrayku tutapi diyapi roygaptikichi payka utkakushpa yanapashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mash allita uyariwaychi. Allita roygaptikichi Tata Dioska kushikushpa mana unayashpa yanapashunkichi. Ñuka Tata Diosmanta shamudu runa kashpayni kay allpaman kashkan shamushpayni ¿ariya ñukata kreyiwaptikichirachu tarimushkaykichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Chaymanta chay runakuna alli rurak kanankunata yuyanakushpa runamasinkunata mana munaksapachu. Jesuska paykunata suk ejempluta yachachirkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Tata Diospa wasinman ishkay runakuna rirkansapa Tata Dioswan parlak. Suk karkan fariseo runa. Suk karkan romano gobiernupa kullki kobrakuk runa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chay fariseo runaka Tata Diosta parlachishpa willarkan: “A Tata Dios, ñuka tukuy runamasinikunamanta ashwan alli rurakmi kani. Chayrayku sukaman kushikuni. Manami suwachu kani. Manami nima uchallikuk runachu kani. Nima suk chikan warmiwan uchallikunichu. Mana nima chay romano gobiernupa kullki kobrakuk runashinachu kani. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kada semana ishkay diyata kanta kushichishpa mana nimata mikunichu. Chaymanta kada chunka kullkinikunamanta sukta kuyki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Chashna chay fariseo rimaptin chay kullki kobrakuk runaka karullapi shayarirkan. Payka mana nima animukurkanchu altuta chapakuyta. Sukaman uchasapa kananta yuyashpa kaskunta makinwan waktashpa rimarkan: “A Tata Dios, ñuka uchasapa likidu runa kaptini llakichiwashpa perdonaway.” ");
INSERT INTO qvsNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chay ejempluta willashkanwasha Jesuska willarkansapa: —Mash allita uyariwaychi. Chay kullki kobrakuk runa uchasapa kananta willashkanrayku Tata Dios perdonarkan. Tata Dios perdonaptin kushikushpa wasinman kutirkan. Chaykamanka chay fariseotaka Tata Dios mana perdonarkanchu. Suk runa kikinlla alli rurak kananta yuyanakuptin Tata Dios payta sukaman pinkachinka. Chaymanta suk runa mana kreyinakushpa kawsaptin Tata Dios payta kushichinka. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesus yachachikuykaptin aypa runakuna taksha wambrillunkunata pushamurkansapa paykunata Jesus llankanankunapa. Chayta kawashpankuna Jesuspa disipulunkuna piñakushpa micharkansapa ama ladunchakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Michaptinkuna kawashpa Jesuska chay wambrillukunata kayarkansapa. Chaypina disipulunkunata willarkansapa: —Wambrillukunata pushamuptinkuna ama michaychichu shamunankunapa. Wambrakuna mana kreyinakushpa tatanpa mandunpi kawsansapa. Kankunapish kay wambrakunashina kawsashpaykichira Tata Diospa mandunpi yaykunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Allita willaykichi. Kankunapish chay wambrakunashina Tata Diospa munananta rurashpa kawsanaykichi tiyan. Mana paypa munananta rurashpaykichika mana mandunpika yaykunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chaymanta suk kamachikuk runa Jesusta ladunchashpa tapurkan: —Alli maestru ¿imata rurashpatí mana tukuyniyukta Tata Dioswan kawsayman? ");
INSERT INTO qvsNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chashna chay runa tapuptinna Jesuska willarkan: —¿Imapati alli kanaynita willawanki? Tata Diosllami alli rurak. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kanka allitami yachanki imatami Tata Dios kamachiwanchi nishpa. Chay killkadukunapi kashna willawanchisapa: “Ama chikan warmiwan uchallikushpa kawsaychu. Ama runamasikita wañuchiychu. Ama nimata suwaychu. Ama ni pita llullakushpa tumbaychu. Chaymanta tataykita mamaykita kuyashpa kawsay.” ");
INSERT INTO qvsNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chashna Jesus willaptinna chay runaka willarkan: —Maestru, ñuka wayna kashkaynimantapachami tukuy chayta allita kasushpa kawsaykani. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chashna chay runa willaptin Jesuska willarkan: —Manami tukuytachu kasuykanki. Rillay rantikumuy tukuy laya tiyapushunaykita. Chaypa chaninta mana nimayuk runakunata kuysapa. Chayta rurashpa sielupi tukuy layayuk kanki. Chaymanta shamuy ñukata katiway. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chashna Jesus willaptinna chay runaka sukaman llakirkan rikchak layayuk kashpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sukaman llakiptin kawashpana Jesuska disipulunkunata willarkan: —Aypa kullkiyuk runakuna tiyapunankunata sukaman munashpankunaka mana atipankasapachu Tata Diospa mandunpi kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Suk kamellu animal mana atipanmanchu suk aguja uchkunta pasayta. Chashnami suk kullki likidu runa kullkinta ashwanta munashpa mana atipankachu Tata Diospa mandunpi yaykuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chay uyarik runakuna sukaman almirashpankuna willarkansapa: —Chashna kaptinka ¿pikunatí Tata Diospa mandunpi yaykunka? ");
INSERT INTO qvsNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chashna willaptinkuna Jesuska willarkansapa: —Niman suk runa atipanchu kikinllamanta Tata Diospa mandunpi yaykuyta. Tata Diosllami atipan runakunata mandunpi yaykuchiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chaypina Pedru willarkan: —Maestru, ñukaykuna tukuy layaynikunata sakishpaynikuna kanta katiykaykisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Chashna Pedru willaptinna Jesuska willarkansapa: —Kankunaka Tata Diospa mandunpi yaykunayashpaykichi wasikichita, warmikichita, wawkikichita, tataykichita, wambraykichita sakishpa ñukata katiwaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Chayrayku kay allpapi Tata Dios tukuy sakishkaykichimanta ashwanta kushunkichi. Chaymanta wañushpaykichi rinkichi sieluman Tata Dioswan mana tukuyniyukta kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chaymanta Jesuska chay chunka ishkay disipulunkunata chikanman pusharkansapa. Chaypina willarkansapa: —Kunanka akuychina Jerusalen llaktaman. Chaypi chay ñawpa yachachikuk runakuna killkashkankunashina padesichiwankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ñuka sielumanta shamudu runa kaptini chikniwak runakuna apiwankasapa. Chaypina mana judiyu runakunapi kukuwankasapa wañuchiwanankunapa. Paykunaka asichiwankasapa. Piñayawashpa tukaychawankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Makawankasapa chaymanta wañuchiwankasapa. Chaymanta wañuchiwashkankunamanta kimsa diyapi kashkan kawsamusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chashna Jesus willaptinkuna disipulunkunaka mana nima entiendirkansapachu. Jesus willashkankuna paykunapa mana entiendina laya kaptin mana yacharkansapachu imatami willaykansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chaymanta Jesuska Jeriko llaktapi chayanayaykarkanna. Chay ñanpi suk mana kawakuk runa tiyarishpa kullkita mañakuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chaypina chay runaka uyarirkan aypa runakunata ladunta pasaykaptinkuna. Paykunata tapukurkan: —¿Pití pasaykan? ");
INSERT INTO qvsNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chashna tapukuptinna chay runakunaka willarkansapa: —Nasaret llaktamanta Jesusmi shamuykan. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chaypina chay runaka manllaybata rimakushpa Jesustaka willarkan: —¡Maestru, ñawpa Davidpa miraknin kashpayki ñukata llakichiway! ");
INSERT INTO qvsNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chayta uyarishpankunana chay ñawpakta riykak runakunaka michashpankuna willarkansapa: —¡Upallay! Ama sukaman sinchitaka kayaychu. Chashna willaptinkuna payka ashwan sinchita kayarkan: —¡Maestru, ñukatapish llakichiwayna! ");
INSERT INTO qvsNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kayashkanta uyarishpa Jesuska riykashkanmanta shayarirkan. Chaypina willarkansapa ladunman chay runata pushamunankunapa. Pushamuptinkunana Jesuska chay runataka willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Imatati munanki ruranaynipa? Chaypina chay runaka willarkan: —Maestru, ñawinita alliyachipay. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuska chay runataka willarkan: —Kanka allitami kreyiwashkanki ñuka alliyachinaynita. Chayrayku kunanlla alliyachiyki. ");
INSERT INTO qvsNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chashna Jesus willaptinna raslla chay runaka allita kawakurkan. Chaypina Jesusta katishpa Tata Diosta alabarkan. Chay runa allita kawakuptin kawashpana tukuy chay runakunapish Tata Diosta alabarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Chay mana kawakuk runata alliyachishkanwasha Jesus Jeriko llaktapi chayashpa chaypi puriykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chay llaktapi kawsarkan suk runa Sakeo. Payka romano gobiernupa kullki kobrakuk runakunapa kamachikukninkuna karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Chay runaka Jesusta sukaman riksinayarkan. Payka taksha runa kashpa mana atiparkanchu kawayta. Jesus sukaman aypa runakunapa chawpinpi riptin mana ladunchayta atiparkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mana nima kawayta atipashpa Jesuspa rinan ñanta kallpashpa ñawparkan shuyak. Chaypina suk ramasapa kaspita llukarkan chaymanta allita Jesusta kawananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chay Sakeo llukashkan kaspi kuskanta Jesuska rirkan. Ramanpi tiyariduta kawashpana Sakeotaka willarkan: —Sakeo, utkakushpa urayamuy. Kunanka wasikipimi samanayani. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chashna willaptinna Sakeoka utkakushpa urayamurkan. Chaypina kushikushpa Jesusta wasinman pusharkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jesus Sakeopa wasinpi samak rinanpa uyarishpankuna chay runakunaka Jesusta sukaman washanchashpa willanakurkansapa: —¿Imatanashi Jesuska samanka chay uchasapa runapa wasinpika? ");
INSERT INTO qvsNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chaymanta wasinpi chayaptinna Sakeo sukaman kushikuyninwan Jesusta willarkan: —Mash kaway, maestru. Kunanka tukuy tiyawaktami patumata mana nimayuk runakunata kunisapa. Chaymanta runakunata tukuy suwashkayni kullkinkunata kutichishasapa chusku kuti mirachishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chashna willaptinna Jesuska paytaka willarkan: —Kunan diya ñuka runakunapa salvakukninkuna kay wasipi chayamushkani. Kay runapish ñawpa awilunchi Abrahampa mirakninmi. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ñuka sielumanta shamushkani tukuy uchasapakunata maskak uchankunamanta perdonanaynipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sakeopa wasinpi Jesus yachachikuptin aypa runakuna uyarirkansapa. Paykuna yuyarkansapa Jesus Jerusalenman riykananta sinchi kamachikuk kananpa. Chayrayku Jesuska suk ejempluwan yachachirkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Suk runapa ayllunkuna kaypi chaypi awtoridarkuna karkansapa. Chay runapish karu llaktaman rirkan kargunta chaskikuk kutimushpa llaktanpi sinchi kamachikuk kananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chay runaka manara llaktanmanta llukshishpara chunka trabajadorninkunata kayachirkan. Paykunata aypa kullkinta kurkansapa. Chay kullkinta kushpankuna willarkansapa: “Kay kullki kushkayniwan imakunatapish rantishpaykichi rantikushpaykichi mirachipaychi. Kutimuptini chay kullki miradutana kutichiwankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Chaymanta chay karu llaktaman chay runa rirkan. Chaypina llaktamasinkuna chiknishpankuna mana munarkansapachu kutimushpa paykunapa kamachikukninkuna kananpa. Chayrayku suk komisyonta kacharkansapa chay ashwan sinchi kamachikuk runata willanankunapa: “Ñukaykunaka manami munanisapachu llaktaynikunapi chay runa kamachiwanankunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Chashna mana munaptinkunapish chay ashwan sinchi kamachikukka churarkan chay runataka kamachikukninkuna kananpa. Kargunta chaskishpa chay runaka llaktanman kashkan kutirkan. Llaktanpi chayashpana kayachirkansapa tukuy kullki chaskikuk runakunata. Yachanayarkan mashnatami kullkinta mirachishkasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tukuymanta ñawpakta shamuk trabajadornin ladunchashpana willarkan: “Señor, kay kullkikitaka chunka kuti mirachipushkayki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chashna willaptinna kamachikuknin aynirkan: “Sukaman allita trabajashpa kay kullkitaka mirachishkanki. Sukaman alli trabajakmi kanki. Kunanka allima kasuwak runa kaptiki churayki chunka llaktakunapi kamachikuk runa kanaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chaymanta ishkaynin trabajadornin ladunchashpa willarkan: “Señor, kay kullki kuwashkaykitaka pichka kuti mirachipushkayki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chashna willaptin chay kamachikukninka willarkan: “Kantapish churayki pichka llaktakunapi kamachikuk runa kanaykipa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chaymanta washata shamuk trabajadornin ladunchashpa willarkan: “Señor, kay kullki kuwashkaykitaka mana nima mirachishkanichu. Allitami suk llachapapi wankushpa wakaychashkani. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sukaman kanta manchashpayni mana nima mirachishkanichu. Allitami riksiyki sukaman sinchi shunkuyuk runa kanaykita. Kanka chikan runapa tarpushkankunata pallanki. Chikan runapa pallashkankunata kanpa wakaychanki. Chayrayku kanta manchashpayni kullkikita pampashkani.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chashna chay runa willaptinna chay kamachikuk runaka willarkan: “Kanka killa likidu trabajadormi kashkanki. Chay mana allita willawashkaykiraykumi kastigayki. Yachashkanki sinchi shunku runa kashpayni chikan runapa tarpushkanta pallashkaynita. Yachashkanki chikanpa pallashkanta wakaychashkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chayta yachashpayki ¿imapatí chay kullkinita mana churarkanki banku ofisinapi mirananpa? Chaypi churaptikika kullkinita miradutana tarimuyman karkan.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chaypina chay kamachikuk runaka chikan trabajadorninkunata willarkansapa: “Kay runataka kichuychi tukuy chay mana mirachishkan kullkita. Chayta kuychi chunka kuti mirachik runata.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chaypina chay trabajadorninkunaka willarkansapa: “Señor, ñami paytaka aypa kullkitana kushkanki.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chashna willaptinkunana chay kamachikuk runaka willarkansapa: “Mash uyariwaychi. Ñuka chay aypa tiyapuk runataka ashwantami kusha. Chaymanta mana aypa tiyapuk runataka pishilla tiyapukninta kichusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chaymanta tukuy chikniwak runakunata pushamuychi. Paykuna mana munawashkasapachu kamachikuk kanaynipa. Chayrayku tukuyta laduynipi wañuchiychi.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chayta yachachikushkanwasha Jerikomanta Jerusalenman Jesuska rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chayman riykashpa Olivos urku ladunpi chayarkan. Chay Olivos urku karkan Betfage llakta Betania llakta ladunpi. Chaypi chayashpana Jesuska ishkay disipulunkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Kankunaka rillaychi chay kawananchi llaktaman. Chayashpaykichi suk watadu burruta tarinkichi. Chay burrutaka manara ni pi montanrachu. Chayta paskashpaykichi pushamuychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Maykan imapatí paskankichi nishpa tapushuptikichi willaychi: “Señorninikunami kay burrutaka munan montananpa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Disipulunkuna rishpankuna Jesus willashkankunashina chay watadu burruta tarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Paskaykaptinkunana doyñunkuna michashpankuna tapurkansapa: —¿Imapatí chay burrutaka paskaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chashna tapuptinkunana disipulunkunaka willarkansapa: —Señorninikuna munan montananpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chashna willashpankuna chay burrutaka Jesusman pusharkansapa. Chaypina burru sawanpi llachapankunata churaptinkunana Jesuska montarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chaymanta chay burrupi Jesus riykaptin chay runakuna Jesusta kuyashpankuna chay rinan ñanpi llachapankunata mantarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalenman riykashpankuna Olivos urkuta urayaykarkansapana. Chaypina tukuy katik runakuna kushikushpankuna sinchita rimashpa Tata Diosta alabarkansapa Jesus aypa almirana ruranata rurashkanrayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Willarkansapa: —Tata Dioska Jesusta kachamushka sinchi kamachikukninchikuna kananpa. Chayrayku akuychi payta kuyaypachi. ¡Akuychi anak sielupi kawsak Tata Diosta sukaman kuyaypachi! ");
INSERT INTO qvsNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chaypina fariseo runakuna chay aypa runakunapa chawpinkunapi kashpankuna Jesusta willarkansapa: —Maestru, kay katishuknikikunata upallayachiy. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chashna willaptinkuna Jesuska willarkansapa: —Willaykichi: Ñuka chay runakunata upallayachiptini kay rumikuna kuyawashpankuna sinchita kaparikunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chaymanta Jerusalenpi chayanayaykashpana Jesuska llaktata kawashpa wakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Wakakushpa rimarkan: —Sukaman munayman chay llaktapi kawsak runakunata yachachiyta. Munayman paykunata mana tukuyniyukta kushichiyta. Chashna munaptinipish mana entiendiwanayansapachu. Mana munawaptinkuna Tata Dios mana atipanchu yachachiysapata. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mana riksiwaptinkuna kunanmantapacha sukaman padesinankuna tiyan. Aypa chiknik runakuna shamunkasapa tukuy kay llaktapa vueltashninta suk pirkata ruranankunapa. Chay pirkata ruraptinkuna manana ni pi yaykuyta nima llukshiyta atipankasapanachu. Tukuy vueltashnintinta yaykushpa makankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chaypina tukuy kay llaktapi kawsak runakunata wañuchinkasapa. Chaymanta tukuy wasinkunata wakllichishpa urmachinkasapa. Manana nima rumikuna sawapura kiparinkanachu. Tata Dioska paykunataka kastigankasapa salvakuk shamushkaynita mana kreyishkankunarayku. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalenpi chayashpana Tata Diospa wasinpi Jesuska yaykurkan. Chaypi kawarkan rantiykak rantikuykak runakunata. Mana munashpa chaypi rantikunankunapa tukuyta karkurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Karkushpa willarkansapa: —Tata Dios killkadunpi willawanchisapa: “Wasinika ñukata kuyawashpa oranaykichillapami.” Chashna Tata Dios willawaptinchikunapish kankunaka kay wasita rurankichi suwakunaykichi wasita. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chay runakunata karkushkanwasha tukuy diya Tata Diospa wasinpi Jesuska yachachikurkan. Chaypi yachachikuptin saserdotekunapa kamachikukninkuna, Moisespa killkadunta yachachikukkuna, llaktapa kamachikukninkunapish Jesusta wañuchinayashpa puriksapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mana yacharkansapachu imashnami wañuchinkasapa nishpa. Jesus yachachikuptin aypa runakuna riksapa uyarik. Chayrayku chay chiknik runakuna manara atiparkansaparachu wañuchiytaka. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Chaymanta suk diya Tata Diospa wasinpi Jesuska aypa runakunata yachachiykarkansapa. Willarkansapa Tata Dios kastigumanta salvanankunata. Chaypina saserdotekunapa kamachikukninkuna, Moisespa killkadunta yachachikukkuna, judiyukunapa ansianunkunapish Jesusta ladunchashpa willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Ariya ¿pití willashushka chashna yachachikunaykipa? ¿Pití kanki chay rantikuykak runakunata karkunaykipa? ");
INSERT INTO qvsNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chashna tapuptinkuna Jesuska aynirkansapa: —Ñukapish kankunata tapuptini ayniwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pití Juantaka kachamushka runakunata bawtisanankunapa? ¿Tata Dioschu? ¿runakunachu kachamushka? May ayniwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chashna Jesus tapuptinkuna chay runakunaka sukwan sukwan willanakurkansapa: —Mana atipanchisapachu willayta Tata Dios Juanta kachamushkanta. Chayta ayniptinchikunaka payka willawashunchisapa: “Tata Dios Juanta kachamushka kaykaptin ¿imapatí mana kreyishkankichi?” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chaymanta mana atipanchisapachu willayta runakunalla Juanta kachamushkanta. Chashna ayniptinchikunaka chay aypa runakuna ruminchawashpanchikuna wañuchiwanchimansapa. Tukuy paykuna kreyinsapa Tata Dios kachamuptin Juan yachachikushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chashna mana ayniyta atipashpankuna Jesusta willarkansapa: —Mana yachanisapachu pimi Juanta kachamushka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesuska willarkansapa: —Ñukapish mana willaykichichu pimi kachamuwashka tukuy chaykunata ruranaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaymanta Jesuska suk ejempluta chay aypa runakunata yachachishpa willarkansapa: —Suk uva chakrayuk runa tiyarkan. Chay runaka aypa uva waskata tarpurkan. Chay uva chakranta rurashkanwasha suk runakunawan paktanakurkansapa pallashpa uvakunata paywan patumanakunankunapa. Chashna paktanakushpankuna chay runaka suk karu llaktaman rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chaymanta uva pallana tiempu chayamuptin chay chakrayuk runaka chayman kacharkan suk wiwachunta patuma uvata mañak chay uva chakran kuydak runakunata. Chaypina chay runakuna chay wiwachuta sukaman makarkansapa. Mana nimata kushpankuna kacharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mana nima suk tipi uvata apaptin chay chakrayuk runaka suk wiwachunta kacharkan. Chay chakrata kuydak runakunaka paytapish sukaman makashpankuna piñayashpankuna mana nimata kushpankuna kacharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chaymanta chay chakrayuk runaka kashkan suk wiwachunta kacharkan partinta mañakuk. Chay trabajadorkuna paytapish makarkansapa. Kuchushpankuna chakranmanta karkurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mana nimayuk paypish kutiptin chay uva chakrayuk runaka sukaman yuyaykushpa rimarkan: “¿Imatati rurasha patuma uvata kachamuwanankunapaka? Shu chaylla wambraynita kachasha. Ichara payta manchashpankuna uvata kachamuwanmansapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chaypina chay chakrayuk runaka wambrantana kacharkan uva patumata mañak. Karupi kaptinlla trabajadorkuna riksirkansapa chakra doyñunpa wambran kananta. Chaypina willanakurkansapa: “Kay shamuk runapa tatan wañuptinka kay uva chakraka paypami kiparinka. Akuychi payta wañuchiypachi ñukanchikunapa kiparinanpa kay uva chakra.” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chaypina chay chakrayuk runapa wambrantaka chakra washaman pushashpankuna wañuchirkansapa. Chay ejempluta yachachikushkanwasha Jesuska chay runakunata tapurkansapa: —¿Imatatí ruranka chay chakrayuk runaka wambranta wañuchik runakunataka? ");
INSERT INTO qvsNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Paymi trabajadorkunata wañuchinankuna tiyan. Wañuchishpa chikan runakunata willanka chay uva chakranta kuydanankunapa. Chashna Jesus yachachikuptinkuna chay runakunaka rimarkansapa: —Mana munanisapachu Tata Dios chay runakunatashina rurawanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chashna chay runakuna rimaptinkuna Jesuska allita chapashpankuna willarkansapa: —¿Ariya imatati Tata Diospa killkadunka yachachiwanchisapa? Chay killkadu kashna riman: “Suk runa wasinta rumimanta ruraptin trabajadorninkuna suk rumita wishchurkansapa mana alli nishpa. Chashna wishchukuptinkunapish chay wasichakuk runaka chay wishchudu rumita wasi kallarinanpi churarkan.” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipish kashpa mitkakushpa chay wishchudu rumipi urmashpa paki paki tukunka. Chaymanta chay wishchudu rumi urmashpa pitapish kaptin apyachishpa wañuchinka. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chashna Jesus yachachikuptin saserdotekunaka kamachikukninkuna, Moisespa killkadunta yachachikukkunaka uyarirkansapa. Paykuna entiendirkansapa paykunarayku Jesus chay ejempluta yachachikuykananta. Chayrayku sukaman piñakushpankuna Jesusta apinayarkansapa wañuchinankunapa. Manara apirkansaparachu Jesusta katik runakunata manchashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sukaman Jesusta wañuchiyta munashpankuna chay chiknik runakunaka kacharkansapa suk runakunata Jesusta llullachinankunapa. Rimashkanta pantachichinayashpa munarkansapa sinchi kamachikukpi chatayta. Chaypina chay kachadu runakunaka allipi tukushpankuna Jesusman rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jesuspi chayashpankuna willarkansapa: —Maestru, ñukaykunaka allita yachanisapa mana llullakushpa sukaman allimata yachachikunaykita. Kanmi tukuy runakunapa yuyayninkunata allimata riksishpa mana manchakushpa yachachikunki. Tukuy runakunata yachachinkisapa Tata Diospa munananllata rurashpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kan allillata yachachikuykaptiki ñukaykunaka tapunayaykisapa. Chay sinchi romano kamachikuk runa kullkinchita mañawaptinchikuna ¿allichu manachu pagarakunanchikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Chashna chay runakuna tapuptinkuna Jesuska yacharkan pantachichinayashkankunata. Chaypina kullkita mañashpa tapurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—¿Pipa uyantatí kawankichi kay kullkipi? ¿Pipa shutintatí kawankichi? Chashna Jesus tapuptinkuna chay runakunaka willarkansapa: —Sinchi romano kamachikuk Sesarpa uyanta shutinta kawanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chaypina Jesuska willarkansapa: —Chay sinchi kamachikuk runapa kaktaka payta kuychi. Chaymanta tukuy laya Tata Diospa kaktaka payllata kuychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nima laya rimashkanpi Jesusta atiparkansapachu pantachichiyta. Chayrayku sukaman almirashpankuna upallayarkansapa. Chashna oras mana atiparkansapachu Jesusta apiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chay washa saduseo runakuna rirkansapa Jesusta kawak. Saduseo runakuna yuyaksapa mana ni pi wañushkanmanta kawsamunanta. Paykunaka Jesusta llullachinayashpankuna willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestru, ñawpa Moisespa killkadunpi yachachiwanchisapa: “Suk kasaradu ullku mana wambrayuk wañuptin wawkinlla chay viyuda kuñadanwan kasaranan tiyan. Chaypina chay warmi suk ullku wambrata wawayaptin wañudupa wambranshina kanan tiyan.” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kunanka willaykisapa: Suk runapa tiyarkan sokta wawkinkuna. Chay runashi kasarashpa manara niman suk wambrayuk kashpa wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chaypina chay ishkaynin wawkin viyuda kuñadanllawan kasararkan. Paypish manara niman suk wambrayukra wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chaymanta chay kimsaynin wawkin viyuda kuñadanwan kasararkan. Paypish wañurkanlla. Tukuy chay wañudupa wawkinkuna sukmanta sukmanta chay viyuda kuñadankunallawan kasararkansapa. Kanchisnintin mana niman suk wambrayuklla wañurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chaypina chay viyuda warmipish wañurkanna. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Maestru, runakuna wañushkankunamanta kawsamuptinkuna chay kanchis kusanmanta ¿maykan kakpatí kanman warminka? Tukuy paykuna chay warmiwan kasaradu karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chashna chay saduseo runakuna tapuptinkuna Jesuska willarkansapa: —Kay allpapi ullku warmi kasarashpa kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Chaymanta kawsamushpa Tata Diosta kreyik runakunalla rinkasapa sielupi kawsak. Chaypi mana ni pi wañunkanachu. Chayrayku ullku warmi mana kasarashpa kawsankasapa. Paykuna angelkunashina mana kutin wañukna kawsankasapa. Wañushkankunamanta kawsamushkanrayku Tata Diospa wambrankuna kankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ñawpa yachachikuk Moisespish yachachiwanchi wañudu runakuna kawsamunanta. Chay ramasapa taksha kaspi rawraykak ukunmanta Tata Dioska Moisestaka willarkan: “Ñukami Abrahampa Isakpa Jakobopa Tata Diosninmi kani.” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chashna Tata Dios rimaptin yachanchisapa chay kimsa ñawpa awilunchikuna wañushkankunamanta kawsamushpa Tata Dioswan kawsaykanankunata. Tata Dioska kawsak runakunallapa Diosninmi. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chashna Jesus yachachikuptin uyarishpana Moisespa killkadunta yachachikuk runakuna willarkansapa: —Maestru, allitami yachachiwaykankisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaypina saduseo runakuna manana animukurkansapanachu ashwanta tapuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chaymanta Jesuska chay runakunata willarkansapa: —Ñukapish kankunata tapuykichi. Kankuna rimankichi Tata Diosmanta shamudu salvakuk runa ñawpa awilunchi Davidpa miraknin kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mash uyariwaychi. Davidka Salmo librupi kashna killkarkan: “Tata Dioska kamachiwak runata willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘Alli laduynipi tiyariy ñukawan tantalla kamachikunaykipa ñuka chiknishuk runakunata saru saru ruranaynikaman kanta kuyashunankunapa.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chay salmopi Davidka rimarkan Tata Diosmanta shamudu salvakuk runa paypa sinchi kamachikuknin kananta. Davidpa kamachikuknin kaptinka ¿imashnatí paypa miraknin kanman? ");
INSERT INTO qvsNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chashna Jesus yachachikuptin tukuy chay runakuna almirashpankuna uyariykarkansapa. Chaypina Jesuska disipulunkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ama munaychichu Moisespa killkadunta yachachikuk runakunata uyariyta. Paykunaka suni llachapankunata churakushpankuna plasakunapi purinsapa. Sukaman munansapa tukuy runakuna manchashpankuna rimachinankunapa. Chaymanta tantanakunankuna wasikunapi ashwan alli bankukunapi tiyarinsapa. Suk fiestaman rishpankuna ashwan alli bankukunapi tiyarishpankuna mikunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Paykunaka alli rurakshina yuyanakushpankunapish viyuda warmikunapa wasinkunata kichunsapa. Chayta ruraykashpa sukaman sunita Tata Dioswan parlansapa runakuna rimanankunapa alli rurak kanankunata. Llullachikuk kaptinkuna Tata Dioska paykunataka ashwan sinchita kastiganankuna tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chaymanta suk diya Tata Diospa wasin pampapi Jesuska yachachikuykarkan. Chaypi kawarkan tukuy layayuk runakuna ofrendankunata churaykaptinkuna kullki churanankuna kajonpi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chaymanta kawarkan mana nimayuk viyuda warmi chayaptin. Chay warmika churarkan ishkay tiyapushkan kullkisitunta. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tukuy tiyapushkan kullkinta churaptin kawashpana Jesuska disipulunkunata willarkansapa: —Ñuka allita willaykichi. Kay viyuda warmika mana nimayuk kaykashpa chay aypa kullkiyuk runakunamanta ashwan alli ofrendata kukushka. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chay aypa kullkiyuk runakuna puchushkan kullkinta Tata Diosta kunsapa. Chay mana nimayuk warmika tukuy tiyapushkanta Tata Diosta kuyashpa kushka. Chayrayku payka Tata Diosta ashwanta kushichin. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chaypina disipulunkunaka Tata Diospa allima ruradu wasinta kawashpankuna willanakurkansapa: —Kay wasika sukaman allima rumikunamanta ruradumi. Tata Diosta ofresishkankunawan allima sumachidumi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Chashna disipulunkuna willanakuptinkuna Jesuska willarkansapa: —Kay wasika sukaman allima ruradu kaptinpish suknin diya urmanan tiyan. Urmaptin manana ni suk rumi sawapura kiparinkanachu. Chiknishuk runakuna tukuy kay wasita wakllichishpa urmachinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesus yachachikuptin disipulunkuna tapurkansapa: —Maestru ¿aykapiti kay Tata Diospa manllayba wasintaka urmachinkasapa? ¿Imakunata kawashpatí yachashasapa Tata Dios chay rimashkaykita rurananta? ");
INSERT INTO qvsNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chashna disipulunkuna tapuptinkuna Jesuska willarkansapa: —Allita kuydanakuychi ama ni pi llullachishunaykichipa. Aypa llullachikuk runakuna ñukapi tukushpa shamunkasapa. Rimankasapa: “Ñuka kani Tata Diosmanta shamudu salvakuk runa.” Chashna rimaptinkunapish ama paykunataka kreyiychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Chaymanta llaktan llaktan makanakunkasapa. Chaymanta llaktapura makanakushpa wañuchinakunkasapa. Chaykunata uyarishpaykichi ama manchakuychichu. Manarapish kay allpa kulluptin aypa llaktakunapi makanakunankuna tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesuska yachachikuyllapi katirkan: —Kaypi chaypi atun llaktakunapi chikninakuk runakuna suk atun llaktakunawan makanakunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chaymanta kaypi chaypi allpa sinchita kuyunka. Tukuy maypi tiyanka sinchi yarkay. Rikchak laya unkuykuna tiyanka. Chaymanta tukuy runakuna manchanapa layakunata sielupi kawankasapa yachanankunapa allpa kullunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Manarapish nima manchanapa layakunata kawaptikichira chiknishuk runakuna kankunata apishunkichi. Paykuna tantanakunankuna wasikunaman pushashunkichi chatashunaykichipa. Chaymanta karselkunapi churachishunkichi. Ñukata kreyiwashkaykichirayku sinchi kamachikuk runakunapi chatakushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Paykunapi chatashuk pushashuptikichika kankunaka atipankichi yachachikuyta ñuka salvakuk kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sinchi kamachikuk runakunapi chatakushuptikichika ama yuyaychichu imatami willasha nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ñukami allita yachachishkaykichi imatami rimankichi nishpa. Yanapaptini allita atipankichi paykunata ayniyta. Chayrayku chay chatakushuknikichi mana nima aynishuyta atipankasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chaymanta tataykichi wawkikichi aylluykichi llaktamasikichi chiknishunkichi. Llullachishushpaykichi pushashunkichi kamachikuk runakunaman paykuna wañuchichishunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ñukata kreyiwashkaykichirayku Tata Diosta mana kreyinayak runakuna chiknishunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Paykuna chiknishuptikichipish Tata Dioska sukaman kuydashuykankichi. Payka chukchaykichitapish kuydapushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Imatapish rurashuptinkuna mana shaykushpa ñukallata kreyiwashpa kawsaychi sieluman rinaykichipa paywan mana tukuyniyukta kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Chaymanta kay Jerusalenpi tukuy vueltashninpi aypa soldadukunata kawashpaykichi yachankichi kay llakta kullunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chay aypa soldadukunata kawashpa Judea partipi kashpaykichi nitikuychi urkukuna sikinpi pakakuk. Jerusalenpi kashpaykichi llukshiychi. Chakraykichipi kashpaykichi ama Jerusalenman kutimuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chay pacha Tata Dioska tukuy kay llaktapi kawsak runakunata kastigankasapa. Ñawpa yachachikuk runakuna Tata Dios kastigananta killkarkansapana. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tata Dioska tukuy kay llaktakunapi kawsak runakunata sukaman kastigaptinkuna sukaman padesinankuna tiyan. Chay padesinan tiempu chayamuptin okupada warmikuna ñuñuchikuk warmikuna llakichinapa layata padesinkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Soldadukunaka runakunata machetinkunawan wañuchinkasapa. Sukkunata watashpankuna karu llaktakunaman pushankasapa chaypi kawsanankunapa. Mana judiyu runakunaka kay Jerusalen llaktapi kamachikunkasapa Tata Diospa rimashkan tiempu paktamunankaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesus yachachikuyllapi katirkan: —Manarapish kay allpaman kashkan shamuptini tukuy pi intita killata luserukunata manchanapa layakunata kawankasapa. Chaymanta atun yakukuna sukaman untashpa kuyushpa sinchita kaparikunkasapa. Chayta uyarishpa tukuy runakuna sukaman manchakunkasapa. Sukaman manchakushpankuna sukta sukta yuyaykunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chaymanta sielupi lusichikukkuna kuyunkasapa. Chayta kawashpa runakuna yuyankasapa kay allpa kullunanta. Manchakuywan wañukshina mallinakunkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chashna oras ñukata kawawankasapa puyu ukunpi shamuptini. Llipyak likidupi shamusha tukuy runakunata sumak yachanayniwan kamachiksapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ñuka shamusha kankunata sieluman pushaknikichi amana kutin padesinaykichipana. Chayrayku chay manchanapa layakunata kawashpaykichi kushikushpalla mana manchakushpa shuyawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus yachachikuyllapi katirkan: —Mash kawaychi chay igo kaspita suk kaspikunatapish. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chay kaspikuna aypata pankayaptin kawashpaykichi yachankichi veranu katinanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chashnashina chay manchanapa layakunata kawashpaykichi yachankichi Tata Dios ñukata utka kachamuwananta kamachikunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Allita willaykichi. Manarapish kay tiempupi kawsak runakuna wañuptinkunara tukuy kay willashkaynita kawanankuna tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tukuy sielu tukuy allpa kullunan tiyan. Kay allpa kulluptinpish ñuka tukuy rimashkaynita rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Tukuy rimashkaynita yuyashpaykichi allita kuydanakuychi. Suk animal mana yuyashkan oras trampapi urman. Chashnashina mana yuyashkaykichi diya shamusha tukuy allpapi kawsak runakunata kastiganaynipa. Chayrayku ama nima laya vanidarta rurashpa nima machashpa kawsaychi. Ama tiyapushuknikichillata yuyashpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Shamunaynita yachashpa tukuy tiempu diyapi tutapi kuydanakushpa Tata Diosta orashpa kawsaychi allita rurashpa kawsanaykichipa. Chashna kuydanakuptikichi Tata Dios yanapashunkichi manchana layakunata padesishpaykichipish ñukallata katiwashpalla kawsanaykichipa. Chaykunata pasashpaykichi sieluman rinkichi ñukapi rikurik. Chaypina Tata Dios kastiguykichimanta salvashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chaymanta Jesus chayta yachachikushkanwasha Olivos urkuman rirkan. Tukuy diya Tata Diospa wasinpi yachachikuk. Tukuy tuta rik Olivos urkupi samak. ");
INSERT INTO qvsNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tukuy diya tutapacha aypa runakuna Tata Diospa wasinman riksapa Jesus yachachikuptin uyarik. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chay tiempu Paskua fiesta manana ashwannachu illarkan. Tukuy wata Paskua fiesta ukunpi amañaksapa mana levadurayuk pankunata mikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chaypina saserdotekunapa kamachikukninkunawan Moisespa killkadunta yachachikukkuna yuyaykurkansapa imashnami Jesusta wañuchinmansapa nishpa. Aypa runakuna Jesusta katirkansapa. Chayrayku paykunaka manchakurkansapa apiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chaypina Jesuspa disipulun Judas Iskariotepi Satanas yaykurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judaska rirkan parlak saserdotekunapa kamachikuknin runakunawan Tata Diospa wasin kuydak runakunawan. Paykunata willarkansapa maypimi Jesusta apinmansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chashna Judas willaptinkunana chay runakunaka sukaman kushikurkansapa. Willarkansapa kullkita pagaranankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chaypina kullkirayku Judaska almitikurkan Jesusta apichichiyta. Chay oramantapacha Judaska sukaman yuyarkan mana runakuna tiyananpi Jesusta apichichiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tukuy wata Paskua fiesta ukunpi tukuy judiyu runakuna amañaksapa mana levadurayuk pankunata mikuyta. Chaymanta Tata Diosta kuyashpankuna amañaksapa oveja wawanta wañuchiyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chay Paskua fiesta kallarinan diya Jesuska Pedruta Juanta kayashpankuna willarkansapa: —Kankunaka rillaychi Paskua fiestapa mikunanchikunata rurak amusata mikunanchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chashna Jesus willaptinkunana Pedruwan Juanka tapurkansapa: —¿Maypití munanki ruranaynikunapa mikunanchikunata? ");
INSERT INTO qvsNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chaypina Jesuska aynirkansapa: —Chay llaktapi chayashpaykichi tinkunakunkichi yaku puyñuta apaykak runawan. Paytaka katiychi suk wasipi yaykunankaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaypi yaykushpaykichi chay wasiyuk runata willaychi: “Maestruynikuna yachanayan maypishi kay Paskua fiestapi payka disipulunkunawan mikunkasapa.” ");
INSERT INTO qvsNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chashna willaptikichi chay wasiyuk runaka kawachishunkichi suk atun kuartuta. Chay kuartuka wasi altuyninpi ñami allichaduna. Chaypi mikunanchikunata ruraychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chashna Jesus willaptin chay disipulunkunaka rirkansapa. Chay llaktapi chayashpankuna Jesuska willashkankunashina tukuyta tarirkansapa. Chaypina paykunaka Paskua fiesta mikunata rurarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chaymanta mikunankuna oras chayamuptin Jesuska tukuy disipulunkunawan tiyarirkansapa mesapi churadutana mikuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tantalla mikuykashpankuna Jesuska willarkansapa: —Manara wañushpaynira sukaman munashkani kankunawan tantalla kay Paskua fiestapi mikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mash allita uyariwaychi. Suknin diya Tata Dioska ñukataka willawanka tukuy layapi kamachikunaynipa. Chay diyakaman mananami kashkan Paskua fiesta mikunata mikushanachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chaypina Jesuska vasu vinuta apishpa Tata Diosta agradesirkan. Chaymanta disipulunkunata willarkansapa: —Kankunaka sukpish sukpish kay vinuta upyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Upyashpaykichi allita yuyaychi. Kunanmantapacha manana vinuta upyashanachu Tata Dios kachamuwanan diyakaman tukuy layapi kamachikunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chaypina Jesuska panta apishpa Tata Diosta agradesirkan. Chay panta pakishpa tukuy disipulunkunata kushpa willarkansapa: —Kay panka ñukapa kuerpuynimi. Ñukami kankunapa uchaykichirayku wañusha. Kankuna kashna tantanakushpa panta mikushpaykichi wañushkaynita yuyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chay panta mikushkankunawasha Jesuska vasu vinuta tukuy disipulunkunata upyachirkansapa. Chaymanta willarkansapa: —Ñuka wañuptini yawarnini kankunarayku ichakunka. Chay ichakudu yawarniniwan ñuka kankunawan suk mushuk paktuta rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chaymanta willaykichi. Chay chikniwakkunapi rantikuwakka kay mesallapi ñukawan mikuykan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ñawpa tiempu Tata Dios killkadunpi rimarkan suk runa apichichiwaptin wañunaynita. Chayrayku sielumanta shamudu runa kashpayni wañunayni tiyan. Chaymanta chay apichichiwak runaka sukaman padesinan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chashna Jesus rimaptin uyarishpankuna disipulunkunaka paykunapura tapunakurkansapa: —¿Maykan ñukanchikunatí maestrunchikunata apichichinchisapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesus wañunanta willaptinkuna disipulunkunaka mana entiendirkansapachu. Paykuna sukwan sukwan willanakurkansapa: —Maestrunchikuna tukuy layapi kamachikuptinna ¿maykan ñukanchikunatí ashwan alli kamachikukka kashunchisapa? ");
INSERT INTO qvsNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chashna willanakuptinkunana Jesuska willarkansapa: —Kay allpapi tukuy mandulla untadu runakuna sukaman sinchita kamachikunsapa. Paykuna sinchi kamachikuk kashpankuna rimansapa alli yanapakuk kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kankunaka ama paykunashina mandulla untadu kanayaychichu. Sinchi kamachikuk kanayashpaykichika tukuy runamasikichita iden suk wiwachunshina allita yanapanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kay allpapi tukuy mandulla untadu runakuna tiyarishpa mesapi churaduta mikunsapa. Paykunataka wiwachunkuna manchaywan sirvinsapa. Ñukaka mana chay mesapi tiyarik runakunashinachu kani. Ñukaka sirvikuk wiwachushinami kani. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ñuka wiwachushina kaptini aypa runakuna chikniwashpa padesichiwashkasapa. Kankunapish ñukawan tantalla padesishkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ñukawan padesishkaykichirayku willashkaykichi suknin diya israelmasikichita kamachinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tatayni Dios kamachikunaynita willawashkantashina ñukapish willashkaykichi kamachikunaykichipa. Ñukawan tantalla mesaynipi mikunkichi upyankichi. Willashkaykichi alli bankupi tiyarinaykichipa israel runakunapa chunka ishkay juesninkuna kanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chaymanta Jesuska Pedruta willarkan: —Simon, mash allita uyariway. Satanas Tata Diosta mañashka kankunata llullachishushpaykichi trigupa karapanta pawachikshina ashuchishunaykichipa. Chashna mañaptin Tata Dioska almitishka. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ñuka Tatayni Diosta roygashkani yanapashunaykipa ama sakiwanaykipa. Chaymanta kan kashkan katiwashpa kay wawkikikunata yanapay paykunapish allita mana shaykushpa katiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chashna Jesus willaptinna Simonka willarkan: —Maestru, chiknishukkuna pushashuptinkuna ñukapish kanwan tantalla karselpi yaykusha. Chaymanta maypicha wañuchishunkisapa chaypi ñukapish kanwan tantalla wañusha. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chashna Pedru willaptinna Jesuska willarkan: —Pedru, mash allita uyariway. Kunan tutami manarapish gallo kantaptin kimsa kuti rimanki mana riksiwanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chayta willashkanwasha Jesuska disipulunkunata willarkansapa: —Ñawpa kankunata yachachikuk kachashkaykichi. Kachashpayni willashkaykichi ama pikshaykichita nima kullkikichita nima ushutaykichita apanaykichipa. Chayta willashpa kachaptini ¿suk imaykichichu pishishushkankichi? Chashna Jesus tapuptinkuna paykunaka aynirkansapa: —Manami nima laya illawashkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chaypina Jesuska willarkansapa: —Kunanmantapacha pikshaykichi tiyaptin apaychi. Kullkikichi tiyaptin chaytapish apaychi. Amachanakunaykichipa machetikichi mana tiyaptin kamisaykichita rantikuychi. Chaypa chaninwan machetikichita rantiychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mash allita uyariwaychi. Tata Diospa killkadu rimanan willawanchi: “Sielumanta shamudu runata iden suk mana alli rurak runatashina wañuchinkasapa.” Chashna Tata Diospa ñawpa killkadu rimashkanshina ñuka wañunayni tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chashna Jesus rimaptin disipulunkunaka willarkansapa: —Maestru, ñukaykunapa tiyan ishkay machetinikuna. Chaypina Jesuska willarkansapa: —Chaylla kachun. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesuska disipulunkunawan chay mikushkankuna wasimanta llukshirkansapa. Chaymanta Jesuska amañananshina Olivos urkuman rirkan. Chayman riptin tukuy disipulunkuna katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Olivos urkupi chayashpana Jesuska paykunata willarkansapa: —Kankunaka Tata Diosta roygaychi ama mana allikunata ruranaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chashna willashpankuna Jesuska paykunamanta tipita suchurirkan. Chaypina allpapi kunkurikushpa Tata Dioswan parlashpa willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—A Tatayni, munashpaykika salvaway ama sukaman padesinaynipa. Padesishpaynipish munani kanpa munanaykillata rurayta. Manami munanichu ñukapa munanaynita rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chashna Tata Dioswan parlaykaptinna sielumanta angel rikurimurkan animuchinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus sukaman padesiykashpa ashwan sinchita Tata Diosta roygarkan. Sukaman sinchita roygaptin granu granuta umpirkan iden yawartashina. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chaymanta Tata Diosta roygashkanwasha rirkan disipulunkunata tarik. Paykunaka sukaman llakishpankuna puñuykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Puñudukunata tarishpankuna Jesuska rikchachishpa tapurkansapa: —Kankunaka ¿imapatí puñunkichi? Rikchaychi. Tata Diosta roygaychi ama supay llullachishushpaykichi uchallichishunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus disipulunkunata willaykaptinlla aypa runakuna paypi chayarkansapa. Chay runakunapa ñawpakninta Jesuspa disipulun Judaska rirkan. Judaska Jesusta muchakpacha rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Muchaptin Jesuska willarkan: —Judas ¿ñukata sielumanta shamudu runata muchawashpachu rantikuwanki? ");
INSERT INTO qvsNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesusta apik shamushkankunata kawashpankuna disipulunkunaka willarkansapa: —Maestru, ¿ariya ñukaykuna kay machetinikunawan makanakushasapachu? ");
INSERT INTO qvsNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chaypina suk disipulunka suk runapa alli ladu rinrinta tipipurkan. Chay runa karkan sinchi kamachikuk saserdotepa wiwachun. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chay runapa rinrinta tipipuptinna Jesuska willarkan: —Ama makanakuychichu. Chashna willashpa Jesuska chay wiwachupa tipidu rinrinta llankashpa apichipurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chaymanta Jesuska saserdotekunapa kamachikukninkunata, Tata Diospa wasin kuydak runakunata, chay apik shamuk ansianukunatapish willarkansapa: —¿Imapatí kankunaka machetikunawan kaspikunawan shamushkankichi apiwak? Ñuka mana suwa runachu kani chashna apiwak shamunaykichipaka. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tukuy diya Tata Diospa wasinpi kankunawan kashkani. Tukuy diya chaypi kaptinipish mana apiwashkankichichu. Kunan tutapi apiwashpaykichika kamachishuknikichi Satanasta uyariykankichi. Tutapishina kankunaka kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chaypina chay chiknik runakuna Jesusta apishpankuna pusharkansapa saserdotekunapa ashwan sinchi kamachikukpa wasinman. Chayman pushaptinkuna Pedruka karu karulla katirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chay wasi pampapi chayashpankuna chay runakuna ninakushpankuna mashakuykarkansapa. Pedrupish paykunawan tantalla tiyarishpa mashakuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaypina suk shipash wiwacha allita kawashpa Pedrutaka riksirkan. Chaypi mashakuykak runakunataka willarkan: —Kay runapish Jesuswan tantallami purishka. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chashna willaptin Pedruka chay shipashta willarkan: —Manami riksinichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chayta willashkanwasha mana unaypinachu suk runa Pedruta kawashpa willarkan: —Kanpish Jesuspa purikmasinmi kanki. Chashna chay runa willaptin Pedruka willarkan: —Manami paypa purikmasinchu kani. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Suk ora washan chikan runa chaypi mashakuk runakunapi chatakushpa willarkan: —Deverasmi kay runapish Jesuswan tantalla purishka. Allitami riksinchisapa Galilea partimanta runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chashna chay runa chatakuptinna Pedruka willarkansapa: —Mana yachanichu maykan runapami willawaykankichi nishpa. Chayta Pedru rimaykaptin suk gallo kantarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chay gallo kantaptin Jesuska washanta chapashpa Pedrutaka kawarkan. Jesus kawaptinna Pedruka yuyarkan payta willashkanta: “Kunan tuta manarapish gallo kantaptin kimsa kuti rimanki mana riksiwanaykita.” ");
INSERT INTO qvsNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedruka chayta yuyashpa chay wasimanta llukshishpa mana upallayak layata wakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chaymanta Jesusta kuydak runakuna sukaman asichishpankuna waktarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawinkunata llachapawan arkapushpankuna waktashpa tapurkansapa: —May willawaysapa ¿pití waktashushka? ");
INSERT INTO qvsNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Waktashpankuna sukaman piñayashpa willarkansapa mana alli rurak runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chaymanta pakariptin chay runakunapa ansianunkuna, saserdotekunapa kamachikukninkuna, Moisespa killkadunta yachachikuk runakunapish tantanakurkansapa. Tantanakushpankuna Jesusta pusharkansapa judiyukunapa ashwan sinchi kamachikukninkunaman. Chaypi chatanayashpankuna tapurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—May willawaysapa ¿kanchu sielumanta shamushkanki salvakuk kanaykipa? Chashna tapuptinkuna Jesuska aynirkansapa: —Ñuka sielumanta salvakuk runa kanaynita willaptinipish kankuna manami kreyiwankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kankunata tapuptinika mana nimata ayniwankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kankuna mana kreyiwaptikichipish kunanmantapacha ñuka tiyarisha Tata Diospa alli ladunpi. Sielumanta shamudu runa kashpayni tukuy laya yachak Tatayni Dioswan tiyarisha. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chashna Jesus willaptinkuna tukuy chay runakunaka piñakushpankuna tapurkansapa: —¿Ariya kanchu kanki Tata Diospa wambran? Chashna tapuptinkuna Jesuska aynirkansapa: —Ñukami kani kankuna rimashkaykichishina. ");
INSERT INTO qvsNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chashna Jesus willaptinkuna chay chatakuk runakunaka mana kreyishpankuna willanakurkansapa: —Mash uyariychi. Ñami payka kikinna chatanakushka. Amana chikan chatakuk runata maskaypachinachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jesusta chiknik runakuna chay sinchi kamachikukpa wasinmanta llukshirkansapa. Paykunaka Jesusta pusharkansapa romano awtoridar Pilatoman. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pilatopi chayachishpankuna Jesustaka chatakurkansapa: —Kay runataka apishkanisapami judiyumasinikunata llullachishpa yachachikuykaptin. Yachachikushka awtoridarkunata ama kasunankunapa. Chaymanta payka tukuy runakunata yachachin romano ashwan sinchi awtoridarninchita kullkita ama pagaranankunapa. Chaymanta riman sielumanta salvakuk sinchi kamachikuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chashna chatakuptinkunana Pilatoka Jesusta tapurkan: —¿Deveraschu kanki tukuy judiyu runakunapa sinchi kamachikuknin runa? Chashna Pilato tapuptin Jesuska aynirkan: —Ariya ñukami kani. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chaypina Pilatoka saserdotekunapa kamachikukninkunata tukuy chay tantanakudu runakunata willarkansapa: —Ñukaka kay runapi mana nima uchata tarinichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chashna Pilato willaptinna chay chiknik runakunaka ashwan sinchita willarkansapa: —Kay runaka tukuy judiyu runakunata llullachishpa yachachinsapa ama awtoridarkunata kasunaynikunapa. Galilea partipi kallarirkan llullachikuyta. Kunanka kay Judea partipipish sukaman llullachikuykan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sukaman Jesusta chatakuptinkuna Pilatoka tapurkansapa: —¿Ariya payka Galileamanta runachu? ");
INSERT INTO qvsNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chaypina Galileamanta runa kananta rimaptinkuna Pilatoka Jesusta pushachirkan Herodesman. Herodeska Galilea partipi ashwan sinchi awtoridarninkuna karkan. Payka Jerusalenpi fiestakuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Unaytana Herodeska Jesusta riksinayarkan aypa runakuna parlachiptinkuna yachachikuykananta. Chayrayku Jesusta chayachiptinkuna Herodeska sukaman kushikurkan. Sukaman kawanayarkan suk almirana ruranata ruraptin. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaypina Herodeska Jesusta tukuy layata tapurkan. Tapuptinpish Jesuska mana nimata aynirkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Saserdotekunapa kamachikukninkuna Moisespa killkadunta yachachikukkunawan Herodespi Jesusta sukaman chatakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jesus mana nimata ayniptin Herodeska tukuy soldadunkunawan sukaman asichirkansapa. Ashwanta asichinankunapa kamachikukpa alli llachapanta mudachirkansapa. Chaymanta Herodeska Jesustaka kashkan pushachirkan Pilatoman. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodeska Pilatowan chikninakushpa kawsaksapa. Paykunaka chay diyamantapachana kuyanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesusta kashkan chayachiptinkuna Pilatoka saserdotekunapa kamachikukninkunata chay llaktapi ansianukunata tantanachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Paykunata willarkansapa: —Kankunaka kay runata pushamushkankichi ñukapi chatakuk. Willawashkankichi payka tukuy runakunata llullachishpa yachachikuykananta ama awtoridarkunata kasunankunapa. Ñuka allita yachanaynipa ñawpaknikichipi paytaka sukaman tapushkani. Manami nima mana alli rurashkanta tarinichu kankuna willawashkaykichishina. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chay awtoridar Herodespish ñukaman kashkan kachamushpa rimashka mana nima mana alli ruranata rurashkanta. Mash allita uyariwaychi. Kay runaka mana nimata rurashkachu ñuka wañuchichinaynipaka. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chayrayku soldaduynikunata willasha makanankunapa. Chay washa kacharichisha. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatoka amañak tukuy wata Paskua fiesta ukun karselmanta suk runata kacharichiyta. Chayrayku munarkan Jesusta kachariyta. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jesusta kacharinanpa willaptinkuna chay runakunaka tantalla sinchita rimakushpa willarkansapa: —¡Manami nima layapi munanisapachu Jesusta kacharinaykipa! ¡Wañuchiy! Munanisapa Barrabasta kacharichinaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chay tiempu Barrabaska karselpi karkan awtoridarkunata mana nima kasunayashkanrayku. Chaymanta suk runata wañuchishkanrayku karselpi wichkadu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Chaypina Pilatoka sukaman Jesusta kacharinayashpa kashkan willarkansapa kacharichinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Chashna Pilato willaptinkuna chay chatakuk runakunaka ashwan sinchita rimakushpa willarkansapa: —¡Kruspi chakatachiy! ¡Kruspi chakatachiy! ");
INSERT INTO qvsNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Paykuna sukaman amichiptinkuna kimsaynin kuti Pilatoka kashkan chay runakunataka willarkansapa: —¿Ariya ima mana allitatí rurashka? Ñukaka paypi mana nima uchanta tarinichu wañuchichinaynipa. Chayraykumi mana wañuchichinayanichu. Makachishpalla kacharichisha. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Chashna Pilato rimaptin chay runakunaka ashwan sinchita rimakushpa willarkansapa: —¡Kruspi chakatachiy! ¡Kruspi chakatachiy! Chashna sinchita rimakushpa amichiptinkuna Pilatoka willashkankunata almitirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chaypina soldadunkunata willarkansapa Barrabasta kacharinankunapa Jesusta wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barrabaska mana kasukuk wañuchikuk runa kaykaptin Pilatoka karselmanta kacharichirkan. Chay chiknik runakunata willarkansapa Jesusta munashkankuna layata ruranankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pilato chayta willaptinkunana soldadukunaka Jesusta pusharkansapa suk kruspi chakatak. Soldadukunaka Jesusta pushaykashpankuna suk runa Simonta apirkansapa Jesuspa washanta krusninta aparinanpa. Chay Simonka Sirene llaktamanta karkan. Payka chakranmanta kutiykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesusta kruspi chakatak pushaykaptinkuna aypa runakuna katirkansapa. Aypa warmikunapish sukaman llakishpa kaparikushpa wakakuypi katirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesuska paykunata chapashpa willarkansapa: —Jerusalenmanta warmikuna, ama ñukaraykuka wakakuychichu. Suk tiempukaman wawaykichiwan tantalla kankuna sukaman padesinaykichi tiyan. Chay padesinaykichita yuyashpaykichi sukaman llakishpa wakakuychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chay tiempu wawayuk warmikuna rimankasapa: “Mana wawayuk mana ñuñuchikuk warmikuna kushikuychi. Allipaka kankuna mana wawayukchu kankichi.” ");
INSERT INTO qvsNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chay tiempupi tukuy runakuna wañunayashpankuna urkukunata willankasapa urmamushpa nitinankunapa. Lomakunata willankasapa pakanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ñuka mana uchayuk runa kaykashpa sukaman padesiptini kankunaka uchayuk kashpaykichi ashwanta padesinaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chaypina soldadukunaka Jesusta kruspi chakatak pushashpankuna ishkay suwa runakunatapish pusharkansapa chakatak. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Suk lomapi chayashpankuna chay soldadukunaka Jesustaka kruspi chakatarkansapa. Chay ishkay suwa runakunatapish chakatarkansapa suktaka Jesuspa alli ladunpi suktaka lluki ladunpi. Chay lomapa shutin karkan Uma Poto. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Soldadukuna kruspi chakataptinkunana Jesuska Tata Diosta willarkan: —Tatayni, kay runakunataka perdonaysapa. Paykunaka manami yachansapachu imatami ruraykansapa nishpa. Chaypina chay soldadukunaka Jesuspa llachapankunata pukllashpa patumanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jesus kruspi chakatadu kaptin aypa runakuna kawaykarkansapa. Awtoridarkunapish kawashpankuna asichishpankuna willarkansapa: —Kay runaka aypa runakunata alliyachishkasapa. Deveras Tata Diospa aklladu sielumanta shamudu salvakuk kashpaka kikin salvanakushpa krusmanta urayamuchun. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadukunapish asichirkansapa. Paykunaka ladunchashpankuna ayak likidu vinuta upyachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chaypina soldadukunaka Jesusta asichishpankuna willarkansapa: —Kanka deveras judiyu runakunapa ashwan sinchi kamachikuknin runa kashpaykika kay krusmanta urayamuy. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesuspa uman kuskapi suk killkadu rimarkan: “Kay runaka tukuy judiyu runakunapa sinchi kamachikuknin runami.” ");
INSERT INTO qvsNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chaypina chikan kruspi chakatadu suwa runaka Jesustaka piñayashpa willarkan: —Kanka deveras sielumanta shamudu salvakuk runa kashpaykika kay krusmanta urayay. Urayashpa ñukaykunatapish urayachiwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chashna chay chakatadu suwa runa piñayaptin chikan kruspi chakatadumasinka willarkan: —Kanpish payshina kruspi chakatadu kaykashpa ¿imapatí chashnaka willanki? ¿Manachu Tata Diostaka manchanki? ");
INSERT INTO qvsNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ñukanchika uchanchiraykumi kay kruspika padesiykanchi. Mana allita rurashpa kawsaptinchi kastigawaykanchisapa. Payka mana nima uchayuk kaykaptin chakatashkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chashna chay chakatadumasinta willashpana Jesusta willarkan: —Jesus, tukuy runakunata kamachikuykashpaykina ñukatapish yuyaway. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chaypina Jesuska willarkan: —Allita willayki. Kunanlla ñukawan tantalla sielupi kanki. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jesus kruspi chakatadu kaptin rasllana chawpi diyamanta tuta likidu tukumurkan las treskaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Intipish mana nima lusichikurkannachu. Chaypina Tata Diospa wasinpi chay arkanan rakta llachapa chawpinmanta llikikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sukaman tuta likidu tukuptinna Jesuska sinchita rimashpa Tata Diosta willarkan: —¡Tatayni, chaskiwayna! ¡Ñami wañunina! Chashna rimashpana Jesuska wañurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jesus wañuptinna romano soldadukunapa kapitanninkuna Tata Diosta alabashpa rimarkan: —Deverasmi kay runaka mana uchayuk kashka. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chay aypa runakuna tukuy chay manchana layakunata kawashpankuna sukaman manchakurkansapa. Paykuna sukaman llakishpa kaskunkunata waktaypi wasinkunaman kutirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Chaymanta Jesusta riksikkuna Galileamanta katik warmikunapish karullamanta tukuy layata ruraptinkuna kawaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Chaypi tiyarkan Arimatea llaktamanta alli rurak runa Jose. Payka judiyukunapa sinchi kamachikuk runa karkan. Suk diya sinchi kamachikukmasinkuna Jesusta wañuchinankunapa rimaptinkuna Joseka mana munarkanchu. Sukaman shuyaykarkan sinchi kamachikukta Tata Dios kachamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chay Joseka Pilatota rirkan Jesuspa kuerpunta mañak pampak rinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kuerpunta mañak riptin Pilatoka almitirkan pushananpa. Chaypina Joseka krusmanta Jesuspa kuerpunta urayachimurkan. Suk allima yurak likidu sabanaswan wankurkan. Allita wankushpana pusharkan suk rumi aspidu machaypi churak. Chaypi manara niman suk wañuduta churarkansaparachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jesus wañushkan diya tukuy runakuna prontanakuykarkansapa chay samana diya atun fiestata ruranankunapa. Samanankuna diya ñami kallariykarkanna. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileamanta Jesusta katik warmikunaka allita kawarkansapa maypimi Jesusta churarkansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chay machayta allita kawashpankuna chay warmikunaka wasinkunaman kutirkansapa. Chaypina mishkilla asnak wirakunata rurarkansapa. Chaymanta Tata Diospa kamachikunanta kasushpankuna chay samanankuna diya samarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chay samanankuna diya kayantin tutapachalla chay warmikuna rirkansapa Jesuspa kuerpunta tupapuk. Chay mishkilla asnak rurashkankuna wirata apashpankuna rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pampashkankuna machaypi chayashpankuna paykunaka kawarkansapa ashuchidutana chay machay wichkanan atun rumita. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chay machaypi yaykushpankuna Jesuspa kuerpunta mana tarirkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chaypina sukaman manchakushpankuna mana yacharkansapachu imatami rurankasapa nishpa. Chaypina rasllana ladunkunapi ishkay shayaridu runakunata kawarkansapa. Paykunaka yurak llipyak likidu llachapayukkuna karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Paykunata kawashpankuna chay warmikunaka ashwanta manchakushpankuna kumurayarkansapa. Chaypina chay ishkay runakunaka paykunataka willarkansapa: —¿Imapati wañudukuna churana machaypi kawsak runata maskaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesuska mananami kaypinachu. ¡Ñami kawsamushkana! Galilea partipi yachachishushkaykichita allita yuyaychi. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Payka willashushkankichi sielumanta shamudu runa kashpa uchasapa runakunapi kukudu kananta. Chaymanta willashushkankichi kruspi wañuchinankunata chaymanta kimsa diya ukun kawsamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chashna chay ishkay angelkuna willaptinkuna chay warmikunaka yuyamurkansapa Jesus willashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chaypina chay machaymanta kutirkansapa. Rirkansapa willak Jesuspa chunka suk disipulunkunata tukuy kawashkankunata. Tukuy purikmasinkunatapish rirkansapa willak. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chay warmikuna karkansapa Mariya Magdalena, Juana, Santiagopa maman Mariya. Chaymanta suk warmikunapish paykunawan tantalla karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chay warmikuna sukaman manchakushpankuna willak riptinkuna Jesuspa disipulunkuna mana kreyirkansapachu. Rimarkansapa dementa kashpankuna shamunsapa llullachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedruka mana kreyishpapish kallparkan chay machayta kawak. Chaypi chayashpa kumurayashpa machay ukuta chunllata kawarkan. Jesusta wankushkankuna sabanasllatana chaypi kawarkan. Chaypina sukaman almirashpa wasiman kutirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay diyalla Emaus llaktaman Jesuspa ishkay purikmasinkuna riykarkansapa. Suk karkan Kleofas. Chay Emaus llaktaka Jerusalenmanta chunka suk kilometrulla karkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chay ishkay runakuna riykashpankuna Jesus wañushkanta parlaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chashna parlaykaptinkuna kikin Jesus ladunchashpa paykunawan tantalla purirkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Paykunawan tantalla puriptinpish mana atiparkansapachu riksiyta Jesus kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chay ishkay runakuna llakishpa parlaypi riykaptinkuna Jesuska tapurkansapa: —¿Imatatí parlaypi riykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chashna Jesus tapuptinkuna Kleofaska willarkan: —Jerusalen llaktapi sukaman manchakuna layata kawashkanisapa. Kanka Jerusalenmanta shamuykashpayki ¿manachu yachanki? ");
INSERT INTO qvsNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chashna willaptin Jesuska tapurkansapa: —¿Ima manchakuna layatatí kawashkankichi? Chashna Jesus tapuptinkuna willarkansapa: —Chay Nasaret llaktamanta Jesus alli yachachikuk tukuy ruray atipak runa kashka Tata Dios yanapaptin. Payka aypa almirana ruranata ruraptin tukuy runakuna kawashkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Chaypina saserdotekunapa kamachikukninkuna, chay llaktanchikunapi kamachikukkuna payta kukushkasapa romano awtoridarkunapi. Paykuna suk kruspi chakatashpa wañuchishkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ñukaykuna yuyarkanisapa payna romano awtoridarkunamanta salvawanankunata. Ñami kimsa diyana wañuchishkankunaka. Chayrayku sukaman llakinisapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Chaymanta Jesusta katikmasini warmikuna manchakuna layata willawashkasapa. Kunan tutapacha paykunaka Jesus pampashkankuna machayta rishkasapa kawak. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Chaypina Jesuspa kuerpunta mana tarishkasapachu. Paykuna wasinikunaman kutishpankuna willawashkasapa paykunapi angelkuna rikurishkankunata. Chay angelkuna willashkasapa Jesus kawsananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chayta uyarishpa suk purikmasinikunapish rishkasapa Jesusta churashkankuna machayta kawak. Paykunapish chay warmikuna willawashkankunatashina chunllata tarishkasapa. Jesusta mana ni maypi kawashkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chashna chay runakuna willaptinkunana Jesuska willarkansapa: —Kankunaka sukaman mana entiendik runakunami kankichi. Tukuy ñawpa yachachikukkunapa killkadunkunata manami kreyishkankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tata Diospa killkadunpi riman salvakuk runa manarapish tukuy layapi kamachikushpa sukaman padesinanta. Kankunaka ¿manachu chayta yachashkankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chashna rimashpa Jesuska paykunata yachachirkansapa. Entiendichirkansapa ñawpa Moisespa chaymanta ñawpa yachachikukkunapa killkadunkunapi paypa rimashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chashna yachachiypi chayarkansapa chay runakunapa llaktankunapi. Chaypina Jesuska willarkansapa sakinankunata. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mana sakinankunata munashpankuna chay runakunaka willarkansapa: —Ñami amusayanna. Ama sakiwaysapachu. Kunan tuta kaypi ñukaykunawan kipariy. Chashna willaptinkuna Jesuska chay runakunapa wasinkunapi yaykurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Paykunaka konvidarkansapa mikuk. Mesapi churaduta mikunankunapa tiyaridu kashpankuna Jesuska suk panta apishpa Tatan Diosta agradesirkan. Chaymanta chay panta pakishpa chay ishkay runakunataka kararkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Paykunaka panta chaskishpankuna chayrak riksirkansapa Jesus kananta. Chashna ora Jesuska ladunkunamanta chinkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Manana Jesusta kawashpana chay runakunaka willanakurkansapa: —Mash allita yuyaypa. Chay ñanpi Jesus Tata Diospa rimananta entiendichiwaykaptinchi sukaman kushikushpa uyarishkanchi. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chashna willanakushpankuna kushikuypuru utkalla Jerusalenman kutirkansapa. Chaypi tarirkansapa tantanakudu Jesuspa chunka suk disipulunkunata. Aypa purikmasinkunatapish chaypi tantanakudukunata tarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Manara nimata willaptinkunara Jesuspa disipulunkunaka paykunata willarkansapa: —Deverasmi maestrunchikunaka kawsamushka. Simonka ñami kawashkana. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chaypina chay ishkay runakunaka ñanpi tarinakushkankunata willarkansapa: —Ñukaykunapish ñami kawashkanisapana. Chay ñanpi puriykaptinikuna maestrunchikuna ladunchawashkasapa. Mana riksiptinikuna ñukaykunawan purirkan Tata Diospa rimananta allita entiendichiwashpankuna. Chaymanta wasinikunapi panta pakishpa karawaptinkunara riksishkanisapa Jesus kananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chashna chay ishkay runakuna willaykaptinkunallara Jesuska chawpinkunapi rikurirkan. Rimachishpa willarkansapa: —Amana llakiychinachu. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chashna rimachiptinkuna disipulunkunaka sukaman manchakurkansapa aya nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chaypina Jesuska willarkansapa: —¿Imapatí manchawankichi? ¿Imapatí mana riksiwankichi? ");
INSERT INTO qvsNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Mash makinita chakinita kawaychi! ¡Ñukami kani! Llankawaychi allita riksiwanaykichipa. Aya kaptinika manami llankawankichimanchu. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chashna Jesus disipulunkunata willashpa kawachirkansapa makinta chakinta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Paykunaka manchakushpankuna kushikuyninkunawan manara allitarachu riksirkansapa Jesus kananta. Chaypina Jesuska tapurkansapa: —¿Tiyanchu mikunaykichika? ");
INSERT INTO qvsNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chashna tapuptinkuna kurkansapa challwa kusaduta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesus chayta chaskishpa disipulunkuna kawaptinkuna mikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chay challwata mikushkanwasha willarkansapa: —Manarapish wañushpaynira aypa kuti yachachishkaykichi Tata Diospa rimananpi rimashkanshina wañunaynita. Ñawpa Moisespa killkadunka chaymanta ñawpa alli yachachikuk runakunapa killkadunkunaka Salmo librupish yachachishunkichi ñuka wañunaynita. Chaymanta yachachishunkichi wañushkaynimanta kashkan kawsamunaynita. Chay killkadukunapi rimashkanshina wañushkaynimanta kawsamushkanina. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chashna Jesus willashpankuna disipulunkunataka ashwanta yachachirkansapa Tata Diospa killkadu rimananta. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Willarkansapa: —Ñawpa yachachikuk runakunaka yachachikurkansapa ñuka sielumanta shamudu salvakuk runa wañunaynita. Chaymanta yachachikurkansapa wañushpayni kimsa diya ukun kawsamunaynita. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kunanmantapacha ñukata kasuwashpaykichi kay Jerusalen llaktamanta tukuy llaktakunaman ñukapa shutinipi rinaykichi tiyan yachachikuk. Rillaychi tukuy runakunata yachachik uchankunata wanashpa ñukata kreyiwashpa kawsanankunapa. Chashna kreyiwaptinkuna Tata Dioska tukuy uchankunamanta perdonankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kankunaka tukuy rurashkaynita kawashkankichi tukuy yachachikushkaynita uyarishkankichi. Chayrayku rillaychi tukuy runakunata parlachik. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tata Dioska ñawpa killkadunpi rimashka Espiritunta kachamunanta. Ñuka Tata Diospa Espiritunta kankunaman kachamusha allita atipanaykichipa yachachikuyta. Chayrayku Jerusalenllapi kipariychi sielumanta ñuka Tata Diospa Espiritunta kachamunaynikaman. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaymanta Jesuska disipulunkunataka Jerusalen llaktamanta pusharkansapa Betania llaktaman. Chaypina Jesuska makinta alsashpa Tata Diosta roygarkan tukuy disipulunkunata yanapanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chashna roygaykaptin Tata Dioska Jesusta pusharkan sieluman. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Paykunamanta ashuykaptin disipulunkunaka sukaman Jesusta kuyarkansapa. Chaymanta sukaman kushikushpankuna Jerusalen llaktaman kutirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chaypina tukuy diya Tata Diospa wasinpi payta sukaman alabarkansapa.");
INSERT INTO qvsNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kallarinanpi manara nima laya tiyaptinra Jesukristu Tata Dioswan tantalla kawsarkan. Payka Tata Dioswan sukllalla karkan. Payka rimashpa Tata Diospa yuyayninta yachachikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Manara nima laya tiyaptinra Jesukristuka Tata Dioswan tantalla kawsaykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tata Dios kamachiptin payka tukuy laya tiyakta rurarkan. Jesukristu mana rurashka kaptinka mana nima laya tiyanmanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Payllami tukuy runakunata kawsachiwashkanchisapa. Iden suk kawachiwakninchi lusshina kay allpaman shamurkan Tata Diospa yuyayninta tukuy runakunata yachachiwananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jesukristu lusshina kashpa Tata Diospa yuyayninta yachachiwanchisapa. Mana nima laya tuta atipanchu lusta wañuchiyta. Manami ni pi nima layapi atipansapachu paypa yachachikunanta chinkachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Tata Dioska suk runa Juanta kachamurkan runakunata yachachinankunapa Jesukristu chay lus kananta. Juanka runakunata yachachirkansapa kreyinankunapa Jesukristu lus kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanka manami luschu karkan. Paytaka Tata Dios kachamurkan yachachikunanpa Jesukristu lus kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesukristu deveras lus kashpa kay allpaman shamurkan tukuy runakunata yachachinankunapa Tata Dios sukaman allima sukaman kuyakuk kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jesukristu Tata Diospa yuyayninta yachachikuk kaykashpa kay allpaman shamurkan. Tata Dios paywan tukuy layata rurarkan. Chashna rurashka kashpapish kay allpaman shamuptin runakuna mana riksirkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jesukristu tukuy runakunata rurawashkanchikunarayku payllapami kanchisapa. Chashna rurawashkanchikuna kaptinpish aypa runakuna payta mana chaskirkansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Chaymanta ñukanchikuna Jesukristuta tukuy shunku kreyishpa payta chaskiptinchikuna Tata Dios atipachiwanchisapa wambrankuna kananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mana tatanchi mamanchikunamanta nasishkanchikunaraykuchu nima paykunapa munashkankunaraykuchu Tata Diospa wambrankuna kanchisapa. Kikin Tata Dios munashkanrayku paypa wambrankuna kanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tata Diospa yuyayninta yachachikuk Jesukristuka kay allpaman shamurkan runa kananpa. Payka ñukaykunawan tantalla kawsashpa allillata rurashpa tukuy pita kuyashpa kawsarkan. Ñukaykuna payta kawarkanisapa Tata Diospa chaylla wambran kashpa Tatan Diosshina sukaman allima kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanka aypa runakunata Jesuspa rimashpa willarkansapa: “Ñuka yachachishkaykichi suk runa shamunanta yachachishuknikichi. Manara ñuka tiyaptinira payka tiyarkanlla. Chayrayku payka ñukamanta ashwan alli yachakmi.” ");
INSERT INTO qvsNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesukristu sukaman alli yachak kashpa tukuy runakunata sukaman allita kuti kuti yanapawanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tata Dioska Moisesta willarkan kamachikunankunata killkananpa. Chaymanta Jesukristuta kachamurkan kuyawashpanchikuna paypa rimananta yachachiwananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana ni pi niman suk kuti Tata Diosta kawarkanchu. Jesukristu Tata Diospa chaylla wambran kashpa paywan sukllalla kashpa paywan sukaman kuyanakushpa kawsan. Chayrayku paylla Tata Diosta allita riksichiwanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jordan yakupi Juan aypa runakunata bawtisaykarkansapa. Chaypina Jerusalen llaktapi judiyu awtoridarkuna yachanayarkansapa pimi chay Juanka nishpa. Chayrayku saserdotekunata yanapakninkunata kacharkansapa tapunankunapa pimi payka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Paykuna tapuptinkuna Juanka allita willarkansapa: —Ñukaka manami chay shuyaykanaykichi Tata Diosmanta shamudu runachu kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Chashna willaptinkunana chay saserdotekunaka tapurkansapa: —¿Pití kanki? Ariya ¿ñawpa yachachikuk Eliyaschu kanki? Chaypina Juanka aynirkansapa: —Manami Eliyaschu kani. Kashkan tapurkansapa: —Ñawpa yachachikuk Moises rimarkan payshina alli yachachikuk runa shamunanta. ¿Ariya kanpachu rimarkan? ¿Kanchu kanki? Chashna tapuptinkuna Juanka aynirkansapa: —Manami paychu kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chaypina tapurkansapa: —¿Pití kanki? Ñukaykuna kutishpaynikuna kachamuwak awtoridarkunata willanaynikuna tiyan pimi kanki nishpa. Willawaysapa pití kanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chashna tapuptinkuna Juanka willarkansapa: —Ñawpa yachachikuk Isaiyas killkarkan: “Suk runa chunlla chakidu pampapi sinchita rimashpa yachachikunka: ‘Sinchi kamachiwakninchipa ñanta kicharishpa kuskachaychi chayta purinanpa.’ ” Chay ñawpa yachachikuk Isaiyaska ñukapami rimarkan. Chayrayku ñukaka yachachikuykani Tata Diosmanta shamudu runata uyarinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chashna Juan willaptinkuna chay fariseokuna kachashkan runakunaka tapurkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Mana Tata Diosmanta shamudu runa kashpaykika, nima Eliyas kashpaykika, nima chay alli yachachikuk shamuk runa kashpaykika ¿imapatí runakunata bawtisaykankisapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chashna tapuptinkuna Juanka aynirkansapa: —Ñukaka yakullapi bawtisaykanisapa. Chay runa kankunawan tantalla kaykaptinpish manara riksinkichirachu Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Washaynita chay ñukamanta ashwan rikchak laya atipak runa shamun. Mana animukunichu ushutan waskanta paskapuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chashna Juan willaptinkuna llaktankunaman chay tapuk runakunaka kutirkansapa. Jordan yaku mañanpi inti llukshimunan ladu Betania llaktapi tukuy chayta parlarkansapa. Chaypi Juanka aypa runakunata bawtisaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tukuy chayta parlashkankuna kayantin Juanka kawarkan Jesus payta ladunchaptin. Payta kawashpa Juanka chay runakunata willarkansapa: —Mash kawaychi. Chay shamuykak runaka Tata Diosmanta shamudu runami. Payka tukuy runakunapa uchankunarayku oveja wawanshina wañunka Tata Dios perdonanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kay runapami willashkaykichi washaynita chay ñukamanta ashwan rikchak laya atipak runa shamunanta. Manara ñuka tiyaptinira payka tiyarkanlla. Chayrayku payka ñukamanta ashwan yachaysapa runami. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Chashna rimashpaynipish manara yachashkanirachu pimi karkan nishpa. Ñukaka shamushkani kankuna israelmasinikunata yakupi bawtisaknikichi yachanaykichipa pimi Tata Diosmanta shamudu runa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Chaymanta Juanka willarkansapa: —Jesusta bawtisaykashpayni kawashkani Tata Diospa Espiritunta iden urpaytashina sielumanta urayamuptin paypi tiyarik. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ñukaka manara yachashkanirachu pimi Tata Diosmanta shamudu runa nishpa. Chayrayku Tata Dios kachamuwarkan yakupi runakunata bawtisanaynipasapa. Chashna kachamuwashpa Tata Dios willawashka: “Espirituynita suk runapi tiyarik urayamuptin kawashpayki yachanki ñukamanta shamudu runa kananta. Payka Espirituyniwan aypa runakunata bawtisanka.” ");
INSERT INTO qvsNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chaymanta ñuka tukuy Tata Dios willawashkanta allita kawashkani. Chayrayku yachachiykaykichi Jesus Tata Diospa wambran kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chaymanta kayantin tardita Jordan yaku mañanpi Juanka ishkay disipulunkunawan puriykarkansapa. Ñukawan Andres Juanpa disipulunkuna karkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus riptin kawashpa Juanka ñukaykunata willawarkansapa: —Mash kawaychi. Chay riykak runaka Tata Diosmanta shamudu runami. Paymi uchanchikunarayku oveja wawanshina wañunka. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chashna Juan willawaptinkuna ñukaykunaka Jesusta katirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chaypina Jesuska kawawashpankuna tapuwarkansapa: —¿Imatati munankichi? Willarkanisapa: —Maestru, willawaysapa ¿maypiti kawsanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chashna tapuptinikuna Jesuska willawarkansapa: —Mash shamuychi kawak. Chashna willawaptinkuna rirkanisapa kawsaykananta kawak. Tardina kaptin amusayanankaman chaypi paywan kiparirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ñukawan Andres Juanta uyarishkaynikunamantapacha Jesusta katirkanisapa. Andreska Simon Pedrupa wawkinmi karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chaypina Jesuswan parlashkanwasha Andreska kuskalla rirkan wawkin Simonta maskak. Tarishpana willarkan: —Ñami tarishkanisapana shuyaykananchi Tata Diosmanta shamudu runata. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chashna Andres willashpa Jesusman wawkin Simontaka pusharkan. Ladunchaptinkuna Jesuska Simonta willarkan: —Kanka Jonaspa wambran Simonmi kanki. Kunanmantapacha Sefas shutinami kanki. Chay Sefas shuti riman Pedru. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Chayta parlashkankunawasha kayantin diya Galilea partiman Jesuska yuyarkan riyta. Chaypina ñukaykunawan Jesus riykashpa suk runawan tinkunakurkan. Chay runa Felipi Betsaida llaktamanta karkan. Chay llaktallamanta Andreswan Pedrupish karkansapa. Chaypina Jesuska Felipita willarkan: —Shamuy ñukawan. Chashna willaptin Felipika Jesusta katirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chaypina Felipika rirkan Natanaelta maskak. Tarishpana willarkan: —Ñami tarishkanisapana Moisespa killkadunpi rimashkan runata. Tarishkanisapana ñawpa tiempu yachachikuk runakuna rimashkankuna runata. Payka Josepa wambran Nasaret llaktamanta Jesusmi. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chashna Felipi willaptin Natanaelka mana kreyishpa willarkan: —Nasaret llaktamanta ¿ima alli rurak runatí shamunman? Chaypina Felipika willarkan: —Mash shamuy riksik. Kikiki riksishpa yachanki Moises rimashkan runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chashna willaptin Jesusman rirkansapa. Chayaykaptinkuna Jesuska Natanaelta kawashpa rimarkan: —Chay runaka alli rurak israel runami. Payka mana nima llullakuyta yachanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chaypina Natanaelka Jesusta tapurkan: —¿Imashnatí allita riksiwashkanki? Jesuska aynirkan: —Manarapish Felipi parlachishuptikira igo kaspi sikinpi kaptiki riksishkayki. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chashna Jesus willaptinna Natanaelka willarkan: —Maestru, deverasmi Tata Diospa wambran kanki. Israel runakunapa sinchi kamachiwakninikunami kanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chaypina Jesuska willarkan: —Igo kaspi sikinpi kanta riksishkaynita willaptini kreyiwashkanki. Mash uyariway. Ashwan alli almirana layakunata kawanayki tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chaymanta Jesuska tukuyta willawarkansapa: —Mash allita uyariwaychi. Kankuna sieluta kawankichi kicharinakuptin. Ñuka sielumanta shamudu runa kaptini Tata Diospa angelninkunata kawankichi ñukamanta llukaptinkuna ñukaman urayamuptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chaymanta kimsa diya washan Galilea partipi Kana llaktapi suk funsia tiyarkan. Chay funsiapi Jesuspa maman karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ñukaykuna Jesuspa disipulunkuna paywan tantalla invitadu kashpaynikuna rirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chay funsiapi aypa runakuna kaptin vinu pishirkan. Chayrayku mamanka Jesustaka willarkan: —Vinuka ñami tukushkana. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chaypina Jesuska willarkan: —Mamayni ¿imapatí ñukata willawanki? Tatayni Dioska manarami willawashkarachu riksichinakunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chashna Jesus willaptinpish mamanka mikuna sirvikuk runakunata willarkansapa: —Tukuy Jesus willashunaykichita ruraychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chaypi tiyarkan sokta atun rumimanta ruradu puyñukuna yakuta churanankunapa. Chay yakuwan judiyu runakuna amañaksapa mayllakuyta chuya chuya Tata Diospi rikurinankunapa. Chay atun puyñukunapi chunka ashwan taksha puyñu yaku yaykuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chaypina Jesuska mikuna sirvikuk runakunata willarkansapa: —Kay atun puyñukunata yakuwan untachiychi. Chashna willaptinkuna shimi shimita untachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chaypina Jesuska willarkansapa: —Kunanka chay puyñukunamanta suk tipita wishishpa funsiapi kamachikukta mallichiychi. Paykunaka Jesus willashkanshina aparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chayta kuptinkuna chay kamachikukka mallirkan mishkik likidu vinuta. Chay karkan yakumanta ruradu vinu. Payka manara yacharkanrachu maymantami chay vinuta surkushkasapa nishpa. Funsiapi mikuna sirvikuk runakunalla yacharkansapa. Chaypina funsiapi kamachikuk runaka noviota kayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ladunchaptinna noviota willarkan: —Kay vinuka sukaman mishkik likidumi. Chay tukudu vinumanta ashwan mishkikmi. Tukuy funsiata rurak runakuna kallarinsapa upyachikuyta ashwan mishkik likidu vinuta. Chaymanta invitadukuna saksaptinkunana mana mishkik vinuta upyachikunsapa. Kanka mana chashnachu upyachikushkanki. Kay mishkik likidu vinutaka washanpina surkumushkanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galilea partipi Kana llaktapi Jesuska chay milagruta rurarkan. Chayta rurashpa kawachikurkan alli yachak kananta. Chay milagruta ruraptin ñukaykunaka kreyirkanisapa Tata Diospa wambran kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chay funsia washan Kapernaum llaktaman Jesuska mamanwan wawkinkunawan disipulunkunawan tantalla rirkan. Chaypi mana aypa diyatachu unayarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tukuy wata ñukaykuna judiyukuna Paskua fiestata ruranisapa yuyashpa Tata Dios ñawpa awiluynikunata Egiptomanta surkumushkankunata. Jesuska ñukaykunawan Jerusalenman rirkan chay fiestata pasananpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chaypi chayashpa Tata Diospa wasinman rirkan. Chay wasi pampapi tarirkan aypa runakunata torokunata ovejakunata urpaykunata rantikuykaptinkuna. Sukkuna tiyarishpankuna kullkita kambiaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tata Diospa wasinta merkadutashina kawashpa Jesuska piñakushpa suk waskata apishpa asoteta rurarkan. Chaywan tukuy chay rantikuykak runakunata karkurkansapa. Toronkunata ovejankunata karkupurkansapa. Kullki kambiaykak runakunapa kullkinkunata allpapi wishchupurkansapa. Mesankunatapish tikrachipurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Urpaykuna rantikuk runakunata willarkansapa: —Tukuyta surkuychi. Ama Tataynipa wasinta merkadutashina ruraychichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ñukaykuna Jesus karkushkankunata kawashpa ñawpa tiempu Tata Diospa killkadu rimananta yuyarkanisapa. Chay killkadu riman: “A, Tata Dios, wasikita sukaman munashpayni sukaman llakishpa rabyashpa turbakuni mana kuydaptinkuna.” ");
INSERT INTO qvsNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chashna Jesus karkuptinkuna chay kamachikuk judiyukuna willarkansapa: —¿Pití willashushka chay rantikuk runakunata karkunaykipa? Suk milagruta ruraptikira kreyishkaykisapa Tata Diosmanta shamudu runa kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chaypina Jesuska willarkansapa: —Almiranata ruranaynipa munashpaykichika kay Tata Diospa wasinta waktakuychi. Waktakuptikichi ñukami kimsa diya ukun kashkan rurasha. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chashna Jesus rimaptinna paykunaka willarkansapa: —Kay wasita chusku chunka sokta watata trabajashpa rurarkansapa. ¿Imashnatí kanka kimsa diya ukun atarichinkiman? ");
INSERT INTO qvsNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesuska Tata Diospa wasinta kashkan atarichinanpa rimashpa wañushkanmanta kimsa diya ukun kashkan kawsamunanta rimarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaymanta Jesus wañushkanmanta kawsamushkanwasha ñukaykunaka yuyarkanisapa rimashkanta. Chayrak allita yacharkanisapa Jesus yachachikushkan alli kashkanta. Chaymanta yacharkanisapa ñawpa killkadu Tata Diospa rimanan alli kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus Jerusalenpi kashpa chay fiesta ukun aypa almirana milagrukunata rurarkan. Tukuy chayta ruraptin aypa runakuna kreyirkansapa Jesus Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Chashna payta kreyiptinkunapish paykunapa yuyayninkunata allita riksishpa yacharkan mana allita kreyinankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mana ni pi willaptin payka tukuy runakunapa yuyayninkunata yacharkan. Chayrayku yacharkan chay runakuna mana allita kreyinankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jerusalen llaktapi tiyarkan suk runa Nikodemo. Payka judiyu awtoridar fariseo runa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Suk tuta Nikodemoka Jesusta rirkan tarik. Chaypina willarkan: —Maestru, yachanisapa Tata Dios kanta kachamushushkanta ñukaykunata yachachiwanaykipasapa. Mana Tata Dios kachamushushka kaptinka mana atipankimanchu nima milagrukunata rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chashna Nikodemo willaptinna Jesuska willarkan: —Mash allita uyariway. Suk runa mana kashkan nasishpaka manami atipanchu Tata Diospa mandunpi kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chaypina Nikodemoka sukaman almirashpa Jesustaka willarkan: —¿Imashnatí atun runa atipanman kashkan nasiyta? Manami ni pi atipanmanchu mamanpa wiksanpi yaykuyta kashkan nasinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chashna willaptinna Jesuska willarkan: —Allita willayki: Suk runa yakumanta Tata Diospa Espiritunmanta mana nasishpaka manami Tata Diospa mandunpi kawsankachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tukuy runakuna tatanmanta mamanmanta nasishpa paykuna layallami kawsansapa. Tata Diospa Espiritunmanta nasishpankunara atipansapa mushuk layata kawsayta Tata Diospa munananta rurashpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama almiraychu kashkan nasinaykichipa willaptini. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayra maymantapish kaptin shamun. Ruyduwan shamuptin uyarishpanchi mana yachanchichu maymantami shamun nishpa. Mana yachanchichu maypimi rinka sinchikuk nishpa. Chashnallami Tata Diospa Espiritunmanta nasishpayki mana payta kawashpaykipish yachanki yanapashunaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chashna Jesus willaptinna Nikodemoka kashkan tapurkan: —¿Imashnatí Tata Diospa Espiritunmanta nasiyman? ");
INSERT INTO qvsNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chaypina Jesuska willarkan: —Israel runakunapa alli yachachikukninkuna kaykashpayki ¿manachu yachanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mash allita uyariway. Ñukaykuna yachanaynikunata kawashkaynikunata yachachiykichi. Chashna yachachiptinikunapish mana kreyiwankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kay allpallapi wayrata yakuta nasinata mana kreyiwashpaykichika ¿imashnatí kreyiwankichiman sielupi kawsanaykichita yachachiptini? ");
INSERT INTO qvsNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mana ni pi sieluman rishpa kashkan shamurkanchu yachachikuk ima layami sieluka nishpa. Ñukallami sielumanta shamushkani yachachiknikichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ñawpa tiempu chunlla chakidu pampapi Moises fierrumanta ruradu machakuyta suk kaspipi timbishpa atarichirkan. Ñuka sielumanta shamudu runa kaptini chay machakuytashina ñukatapish suk kaspipi chakatawashpa atarichiwankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chashna atarichiwaptinkuna tukuy ñukata kreyiwak runakuna sieluman rinkasapa Tata Dioswan mana tukuyniyukta kawsak. Chashna Jesuska Nikodemowan parlarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tata Dioska tukuy runakunata sukaman kuyawashpanchikuna kay allpaman chaylla wambranta kachamurkan uchanchikunarayku wañunanpa. Chashna wañushpa tukuy payta kreyik runakunata wañunanchikunamanta salvawanchisapa Tata Dioswan mana tukuyniyukta kawsananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uchasapa kaptinchikuna Tata Dios kastigawananchikuna tiyan. Payka chaylla wambranta kay allpaman kachamurkan chay kastigunchikunamanta salvawananchikunapa. Mana paytaka kachamurkanchu kastigawananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tata Diospa chaylla wambranta kreyishpa kawsaptinchikuna manana kastigawashunchisapanachu. Mana payta kreyishpa kawsak runakunata Tata Dios kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tata Dios tukuy paykunata kastiganankuna tiyan mana allikunata rurashpalla kawsaptinkuna. Jesukristu kay allpaman shamurkan Tata Diospa yuyayninta yachachiwananchikunapa. Chashna yachachikuk shamushpa lusshina karkan. Mana Jesukristuta kreyik runakuna uchankunata mana sakinayashpankuna mana munarkansapachu luspishina kawsayta. Munarkansapa tutapishina kawsayllata. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mana alli rurak runakuna mana munansapachu uchankunata riksiyta. Mana uchankunata sakinayashpankuna mana munansapachu luspishina kawsayta ama Jesukristu uchankunata kawachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ñukanchikuna Tata Diospa rimananta kasushpa kawsashpanchikuna luspishina kawsanchisapa tukuy runakuna yachanankunapa Tata Diospa munananta rurananchikunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaymanta yachachikushkanwasha Jesuska Judea partiman ñukaykunawan tantalla rirkan. Chaypi suk tiempullata kiparishpaynikuna aypa runakunata bawtisarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chay yaku anakninpi Enon llaktapi Juan Bawtistapish aypa runakunata bawtisarkan. Chay llaktapi aypa yaku tiyarkan. Enon llaktaka Salim llakta ladunpi karkan. Juan chay llaktapi kaptin aypa runakuna rirkansapa bawtisakuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Manara karselpi churadu kashpa Juanka runakunata bawtisaykarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chaypina Juanpa disipulunkuna suk judiyumasinkunawan ayninakurkansapa imashnami Tata Diospi chuya chuya rikurinkasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ayninakushkankunawashana disipulunkunaka rirkansapa Juanta willak: —Maestru, Jordan yaku chimbapi suk runata bawtisashkanki. Chay runapa yachachiwashkankisapa Tata Diosmanta shamudu runa kananta. Kunanka chay runaka aypa runakunata bawtisaykansapa. Tukuy runakuna paytana katiykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chashna disipulunkuna willaptinkuna Juanka willarkansapa: —Tata Dios mana chay runata yanapaptinka manami nimata atipanmanchu rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Allitana willashkaykichi mana ñuka Tata Diosmanta shamudu salvashuknikichi runa kanaynita. Tata Dios kachamuwaptin ñuka paymanta ñawpamushkani runakunata yachachik pay shamunanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mash uyariwaychi kay ejempluta parlachikuptini. Suk funsiapi kasarakuk runa novianta kawashpa sukaman kushikun. Chaypina kasarakuk runa kushikushpa rimakuptin kuyanakukmasinpish sukaman kushikun. Ñukaka iden chay noviopa kuyanakukmasinshinami kani. Chayrayku aypa runakuna Jesusta katiptinkuna sukaman kushikuni. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aypa runakuna ñukata sakiwashpa ashwan ashwanta payta katinankuna tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Chay runaka sielumanta shamudu kashpa tukuy runakunamanta ashwan allimami. Ñukaka kay allpamanta kashpayni runakunashinalla yachachikuni. Payka sielumanta kashpa tukuy pimanta ashwan alli yachakmi. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sielumanta shamushkanrayku chaypi kawashkanta uyarishkanta yachachikun. Tukuy chayta yachachikuptinpish aypa runakuna mana kreyinsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Chaykamanka paypa yachachikunanta kreyik runakuna allita rimansapa Tata Dios mana llullakunanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tata Dioska kachamushkan runata mana michashpa Espiritunta kun. Chayrayku payka Tata Diospa yachachishkanta riman. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata Dioska chaylla wambranta sukaman kuyan. Chayrayku paypa makinpi churarkan tukuy runakunata tukuy laya tiyakta allita kamachinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chayrayku ñukanchikuna Tata Diospa wambranta kreyishpa kawsashpanchikuna mana tukuyniyukta kawsashunchisapa. Mana payta kreyinayak runakuna mana sielupi kawsankasapachu. Tata Dioska paykunata sukaman kastigankasapa. Chashna Juanka yachachikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aypa runakuna rimarkansapa Jesus Juanmanta ashwan aypa runakunata bawtisaykananta. Rimarkansapa ashwan aypa runakuna Jesusta katinankunata. Chay rimananta fariseokuna uyarirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Chashna chay runakuna rimaptinkunapish Jesuska mana ni pita bawtisarkanchu. Ñukaykuna Jesuspa disipulunkuna kashpaynikuna payta kreyik runakunata bawtisarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chaypina Jesus yacharkan fariseokuna chay rimanata uyarishkankunata. Chayrayku Judea partimanta Galilea partiman ñukaykunawan rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galileaman riykashpaynikuna Samaria partita pasashpa rinaynikuna karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria partipi puriykashpaynikuna Sikar llakta ladunpi chayarkanisapa. Chaypi tiyarkan suk pukyu. Ñawpa tiempu awiluynikuna Jakobo chay pukyuta aspishpa tukuy chay terrenuta wambran Joseta kurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jesus shaykudu kashpa chay Jakobopa pukyun ladunpi tiyarirkan. Chawpi diya karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ñukaykuna Jesusta sakishpa rirkanisapa mikunaynikunata rantik. Chaypi Jesus samaykaptin suk samaritana warmi rirkan yakuta wishik. Chaypina Jesuska payta willarkan: —Yakuykita upyachiway. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chay tiempu ñukaykuna judiyu runakuna samaritano runakunawan chikninakushpa mana parlashpa kawsarkanisapa. Chayrayku Jesus yakuta mañaptin chay warmika sukaman almirashpa willarkan: —¿Imapatí judiyu runa kashpayki yakutaka mañawanki samaritana warmi kaptini? ");
INSERT INTO qvsNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chaypina Jesuska chay warmita willarkan: —Kanka manami yachankichu Tata Dios ashwan alli yakuta kushunayananta. Manami nima ñukata riksiwankichu. Riksiwashpaykika ashwan alli yakuta mañawankiman. Mañawaptikika ñukaka kawsachikuk yakuta upyachiykiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chashna Jesus willaptinna chay warmika willarkan: —Señor, manami kanpa tiyanchu imawan yakuta wishinaykipa. Kay yakuka sukaman ukupimi. ¿Maymantatí kawsachikuk yakuta upyachiwankiman? ");
INSERT INTO qvsNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ñawpa tiempu awilunchi Jakobo kay pukyuta aspishpa ñukaykunapa sakirkan. Kayllamanta paypish upyak. Kayllamanta tukuy wambrankunata tukuy animalninkunata upyachiksapa. ¿Ariya chay ñawpa awilunchi Jakobomanta ashwan alli yachakchu kanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chashna tapuptinna Jesuska chay warmita willarkan: —Tukuy pi kay pukyumanta yakuta upyashpankuna kashkan yakunayankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ñuka kawsachikuk yakuta kankunata upyachiptinika mananami kashkan yakunayankichinachu. Chay yakuta upyachiptinika kankunapimi pachyamuk yakushina kallpashpa mana tukuyniyukta kawsachishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chashna Jesus willaptinna chay warmika mana entiendishpa willarkan: —Señor, chay alli yakuta upyachiway ama kutin yakunayanaynipa. Chayta upyachiwaptikika mana kutin shamuymannachu kay pukyumanta yakuta wishik. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chaypina Jesuska willarkan: —Rillay kusaykita pushamuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chashna willaptinna chay warmika willarkan: —Manami kasaraduchu kani. Jesuska willarkan: —Allita willawanki mana kasaradu kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pichka kusaykikuna tiyashka. Kunan soktaynin kusaykiwanpish mana kasaraduchu kanki. Chayraykumi mana llullakushpa willawanki mana kasaradu kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chaypina chay warmika willarkan: —Señor, chashna willawaptiki ñuka riksiyki Tata Diospa rimananta yachachikuk runa kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chayrayku tapunayayki. Samaritano awiluynikuna kay urkullapi Tata Diosta kuyaksapa. Kankuna judiyu runakuna rimankichi Jerusalen llaktallapi tukuy runakuna Tata Diosta kuyananchikunapa. ¿Imatatí rimanki? ¿Maypití Tata Diosta kuyananchikuna tiyan? ");
INSERT INTO qvsNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chaypina Jesuska willarkan: —Mash uyariway. Kunanmantapacha manana ni kay urkuman shamunkichinachu nima Jerusalenman rinkichinachu Tata Diosta kuyak. Payta kuyanayashpaykichika maypipish kaptin tukuy shunku kuyanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kankuna Tata Diosta mana allitachu riksinkichi kuyanaykichipa. Ñukaykuna judiyu runakuna payta allita riksishpa kuyanisapa. Salvashuknikichi runaka judiyu ayllunmantami. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ñami oraka chayamushkana Tata Diospa Espiritun yanapashunaykichipa tukuy shunku Tata Diosta kuyanaykichipa. Tata Dioska munan chashna tukuy shunku deverasta kuyanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tata Dios mana runakunashina aychayuk kaptin mana paytaka kawanchichu. Payka tukuy laya atipakmi. Chayrayku paypa Espiritun yanapawaptinchikunara yachanchisapa payta allita deverasta kuyayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chaypina chay warmika willarkan: —Yachani Tata Diosmanta salvakuk runa shamunanta. Paypa suk runakuna rimansapa Kristu. Paymi shamushpa tukuy chaykunata allita yachachiwashunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chashna willaptinna Jesuska willarkan: —Ñukami kani chay shuyanaykichi runa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesus chay warmiwan parlaykaptinna ñukaykunaka tarirkanisapa. Sukaman almirarkanisapa samaritana warmiwan parlaykaptin. Mana ni maykan animukurkanisapachu tapuyta imatami munan imatami paywan parlaykan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chaypina chay warmika puyñunta sakishpa llaktaman kallparkan. Chaypi chayashpa tukuy llaktamasinkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Akuychi kawak suk runata pukyu ladunpi. Paymi tukuy laya rurashkaynita willawashka. ¿Manachu payka shuyaykananchi Tata Diosmanta shamuk runa? ");
INSERT INTO qvsNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chashna chay warmi willaptinkunana tukuy llaktamasinkuna shamurkansapa Jesusta kawak. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Manarapish Jesuspi chayaptinkunara ñukaykunaka willarkanisapa: —Maestru, kay mikunata mikuy. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Chaypina Jesuska willawarkansapa: —Ñukapa ashwan alli mikunayni tiyan. Kankunaka manami yachankichichu imami chay mikunayni nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chayta willawaptinkunana ñukaykunaka sukwan sukwan willanakurkanisapa: —Ichará suk runa karashka. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chaypina Jesuska willawarkansapa: —Sielumanta Tatayni Dios kachamuwashka kaptin tukuy willawashkanta ruranayni tiyan. Paypa munananta rurashpayni suk alli mikunawan saksadushina kawsani. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Chaymanta willawarkansapa: —Suk chakrakunapi wiñaykak murukunata kawashpa rimankichi chusku killara illananta pallanapa. Kunan willaykichi: Chay shamuykak samaritano runakunata kawaychi. Paykunaka munansapa Tata Diospa rimananta uyariyta. Chashna uyarinayashpankuna iden pukudu wayukunashinami pallananchikunapana. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Chashna pallakushpanchikuna trabajunchikunapa chaninta chaskinchisapa. Tata Diospa rimananta yachachikuptinchikuna chay shamuykak runakunaka kreyinkasapa ñuka Tata Diosmanta shamudu runa kanaynita. Chayta kreyishpankuna mana tukuyniyukta kawsankasapa. Ñawpa yachachikuk runakuna murukunata tarpukshina kay samaritano runakunata Tata Diospa rimananta yachachirkansapa. Ñukanchikuna pallakuk runakunashina kanchisapa. Chay tarpukukshina runakunawan ñukanchikuna muruta pallakshina runakunapish tantalla kushikushunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kay rimana allita riman: “Suk runakuna tarpunsapa. Suk runakuna pallansapa.” ");
INSERT INTO qvsNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ñukaka kankunata kachaykichi murukunata pallakshina chay runakunata yachachinaykichipa. Suk runakuna tarpukukshina sukaman trabajashpa kay samaritano runakunata yachachishkasapa. Paykuna trabajashkankunapi yachachiptikichi kreyinkasapa ñuka Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chashna Jesus ñukaykunawan parlaykaptin chay warmika riduna karkan. Chayashpa llaktamasinkunata willarkansapa: “Chay pukyu ladunpi suk runa tukuy rurashkaynita willawashka.” Chashna chay warmi willaptinkuna aypa llaktamasinkuna kreyirkansapa Jesus Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chaymanta shamurkansapa payta kawak. Jesuspi chayashpankuna roygarkansapa paykunawan kiparinanpa. Chayrayku ishkay diyata paykunawan tantalla kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kikin Jesus yachachiptinkuna ashwan aypa runakuna kreyirkansapa Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Paykunaka chay warmita willarkansapa: —Kanna ñukaykunata parlachiwaptikisapa kreyishkanisapa Jesus Tata Diosmanta shamudu runa kananta. Kunan kikinna yachachiwaptinkuna ashwan allitana yachanisapa deveras tukuy runakunapa salvawakninchikuna kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesus Samariapi ishkay diyata yachachikushkanwasha rirkanisapa Galilea partiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesuska yacharkan chay partipi kawsak runakuna mana payta kreyinankunata. Chayrayku rimarkan: “Suk alli yachachikuk runa kikinpa llaktanpi yachachikuptin llaktamasinkuna mana kreyinsapachu alli yachachikuk kananta.” ");
INSERT INTO qvsNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Manarapish Galilea partita rishpaynikuna Jerusalenpi kaykaptinikunara Jesuska aypa almirana milagrukunata rurarkan. Galileamanta Jerusalenpi Paskua fiestakuk runakuna tukuy milagruta ruraptin kawarkansapa. Chayrayku llaktankunapi chayaptin Jesusta kushikushpa chaskirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chaymanta Galilea partita pasashpa Jesus Kana llaktapi chayarkan. Chay llaktapi suk tiempu yakumanta vinuta rurarkan. Chay partillapi Kapernaum llaktapi chay ashwan sinchi kamachikukpa yanapaknin kawsarkan. Chay runapa wambran kalentorawan fatal unkudu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Payka Galileapi Jesus chayashkanta yachashpa rirkan sukaman roygak rinanpa wambranta alliyachipuk amarapish wañuptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sukaman pushanayaptinna Jesuska willarkan: —Milagruta ruraptini kawashpaykichira kreyiwankichi. Mana milagruta ruraptinika manami kreyiwankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chaypina chay runaka Jesusta sukaman apurashpa willarkan: —Señor, amarapish wambrayni wañuptin utkakushpa rillay alliyachipak. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chaypina Jesuska chay runata willarkan: —Wasikiman kutiy. Wambraykika ñami alliyashkana. Chashna willaptinna chay runaka tukuy shunku kreyirkan Jesus wambranta alliyachishkanta. Chashna kreyishpa wasinman kutirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wasinman kutiykaptin wiwachunkuna riykarkansapa tinkuk. Tinkushpana kushikushpa willarkansapa: —Wambraykika ñami alliyashkana. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chay kamachikuk runaka tapurkansapa: —¿Ima oratatí kallarishka alliyayta? Paykunaka aynirkansapa: —Kayna chawpi diyata kalentoranka chiriyapushka. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chashna willaptinkuna chay runaka yuyarkan Jesus alliyachinanpa willashkan ora wambran alliyashkanta. Chay tiempumantapacha chay runaka tukuy familyanwan tantalla kreyirkansapa Jesus Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus chay wambrata alliyachishpa ishkaynin kutina Galilea partipi almirana milagruta rurarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaymanta Jesuska chay milagruta rurashkanwasha Jerusalenman rirkan fiestata pasak. Tukuy wata ñukaykuna judiyu runakuna Tata Diosta kuyashpa chay fiestata rurak kanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalen llaktaman ovejakuna yaykunan punku ladunpi suk sumak tantanakudu kocha tiyan. Chay kochapa shutin Betsata. Chayllapi pichka tambukuna tiyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chaypi aypa unkudu runakuna samaksapa. Sukkuna mana kawakuyta atipak karkansapa. Sukkuna mana puriyta atipak karkansapa. Sukkuna mana nima kuyuy atipak karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mana ni pi yachashkan ora Tata Diospa angelnin chay yakuta kuyuchik. Chay angel yakuta kuyuchiptin maykan runa ñawpakta chay yakupi yaykuk unkuyninmanta alliyak. Chayrayku aypa unkudu runakuna alliyanayashpa shuyaksapa angel chay yakuta kuyuchinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chay unkudukunawan tantalla suk runa kimsa chunka pusak watata unkudu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus chaypi chayashpana payta kawarkan. Aypa watakunata unkudu kawsashkanta yachashpa tapurkan: —¿Munankichu alliyayta? ");
INSERT INTO qvsNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chashna Jesus tapuptinna chay runaka willarkan: —Señor, yaku kuyuptin mana ni pi churawak runa tiyanchu. Ñuka sukaman yaykunayaptini sukmi mishawashpa yaykun. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chaypina Jesuska willarkan: —¡Atarimuyna! ¡Kamillaykita apishpana rillay! ");
INSERT INTO qvsNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chashna Jesus willaptin chay unkudu runaka alliyarkan. Chaypina kamillanta apishpa kushikushpana kallarirkan puriyta. Chay diya karkan samana diya. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chayrayku judiyu awtoridarkuna chay alliyadu runataka willarkansapa: —Kunanka samana diyami. Ñukanchikunapa killkadunchikunapi willawanchisapa samana diya ama nimata apananchikunapa. Chayrayku chay kamillaykita ama apaychu. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chashna michaptinkunana chay runaka aynirkansapa: —Chay alliyachiwak runami willawashka: “Kamillaykita apishpa rillay.” ");
INSERT INTO qvsNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chaypina chay awtoridarkunaka tapurkansapa: —¿Pití chay “kamillaykita apishpa rillay” willashuk runaka? ");
INSERT INTO qvsNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Chashna tapuptinkuna chay runaka mana riksirkanchu pimi alliyachishka nishpa. Jesus alliyachishkanwasha chay aypa runakunapa chawpinkunapi yaykushpa pakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaymanta Tata Diospa wasinpi Jesuska chay alliyachishkan runataka tarirkan. Chaypi willarkan: —Mash uyariway. Ñami alliyaduna kanki. Amana kutin uchallikuynachu ama ashwanta sufrishpa kawsanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chashna willaptinna chay runaka awtoridarkunata rirkan willak Jesus alliyachishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Samana diya chay unkuduta alliyachishkanrayku chay awtoridarkunaka Jesusta chiknirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Chikninankunata yachashpa Jesuska willarkansapa: —Tatayni Dioska tukuy diya tukuy runakunata yanapansapa. Ñukapish iden Tataynishina tukuy diya tukuy pita yanapaykani. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chashna willaptinkuna chay awtoridarkunaka Jesusta sukaman munarkansapa wañuchiyta samana diya rikchak layata ruraptin. Paykunaka ashwanta chiknirkansapa runalla kashpa Tata Dioswan igualanakunayashpa rimaptin Tata Dios kikinpa tatan kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chashna chay awtoridarkuna wañuchinayaptinkuna Jesuska willarkansapa: —Mash allita uyariwaychi. Tata Diospa chaylla wambran kashpayni kikinimanta mana atipanichu nimata rurayta. Tatayni Dios rurananta kawashpara chayllata rurani. Tatayni ruraykananllata ñukapish rurani. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tataynika sukaman ñukata kuyawan. Rikchak laya rurananta yachachiwan payshina ñukapish ruranaynipa. Kunanmantapacha yanapawanka ashwan almirana milagrukunata ruranaynipa. Chayta kawashpaykichi sukaman almirankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tatayni Dioska wañudu runakunata atipan kawsachimuyta paywan kuyanakushpa kawsanankunapa. Payshina ñukapish tukuy munashkayni runakunata kawsachimuni. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chaymanta Tatayni Dioska mana ni pita chatakunchu. Payka willawashka ñuka willanaynipa pitami kastiganka pitami perdonanka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chashna Tata Dios willawaptin tukuy runakuna ñukata iden Tataynitashina kuyawanankuna tiyan. Mana kuyawashpankunaka kachamuwak Tataynitapish mana kuyansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Allita willaykichi. Kankuna yachachikunaynita kreyinaykichi tiyan. Kachamuwak Tata Diostapish kreyinaykichi tiyan. Chashna yachachikushkaynita kreyiptikichika mana tukuyniyukta kawsankichi. Mana ninamanchu rinkichi. Wañudu kanaykichimanta kawsamunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Allita willaykichi. Suk tiempu chayamunka chay tiempuka ñami chayamushkana ñuka Tata Diospa wambran yachachikuptini aypa uchasapakuna uyariwanankunapa. Chay uchasapakunaka iden wañudukunashinami. Yachachikuptini tukuy uyariwakkuna mana tukuyniyukta Tata Dioswan tantalla kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tata Dioska kikinllamantami mana tukuyniyukta kawsan. Chaymanta pay munaptin ñukapish chaylla wambran kashpayni kikinillamanta mana tukuyniyukta kawsani. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tatayni kay allpaman kachamuwashka runa kanaynipa. Chayrayku ñukata willawashka tukuy runakunata willanaynipa pikunami allita rurashka pikunanami mana allitachu rurashka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Chashna ñuka yachachikuptini ama almiraychichu. Suk tiempu chayamunka ñuka kayaptini tukuy wañudu runakuna uyariwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chaypina pampadu kashkankunamanta llukshimunkasapa willanaynipa maymanmi rinkasapa nishpa. Tukuy allita rurashpa kawsak runakunata yaykuchishasapa sielupi Tata Dioswan mana tukuyniyukta kawsanankunapa. Tukuy mana allita rurashpa kawsak runakunata mana tukuyniyuk ninaman kachashasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesuska yachachikuyllapi katirkan: —Kikinillamanta mana nimata atipanichu rurayta. Tatayni Dios munashkantashina willani pimi allita rurashka pimi mana allitachu rurashka nishpa. Ñuka mana kikinipa munanaynitachu rurani. Chayrayku kuskanpi willani pimi allita rurashka pimi mana allitachu rurashka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ñuka rimani Tata Diospa wambran kanaynita. Ñuka sapallayni chayta rimaptinika kankuna rimankichiman llullakunaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mana ñukallachu chashna rimani. Tata Diospish rimashka ñuka wambran kanaynita. Chashna Tata Dios rimashpa mana llullakunchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kankunaka runakunata kachashkankichi Juanman ñukapa tapukuk. Payka allita willashushkankichi ariya ñuka Tata Diosmanta shamudu runa kanaynita. Chayta willashushpaykichi kuskanpi willashushkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Chashna Juan ñukapa allita willashuptikichipish mana payllachu chayta willashushkankichi. Tatayni Diospish willashushkankichi paypa wambran kanaynita. Chayta willaykichi uchaykichimanta Tata Dios perdonashunaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanka Tata Diospa rimananta yachachishushpaykichi suk alkusashina lusichishurkankichi. Chashna yachachishuptikichi suk tiempullapa payta uyarishpa kushikushpa kawsarkankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juanka willashurkankichi Tata Diosmanta shamudu runa kanaynita. Ñuka almirana milagrukunata rurashpayni Juanmanta ashwan allita yachachiykichi Tata Diosmanta shamushkaynita. Chay milagrukunata ruraptini atipankichi yachayta Tata Dios kachamuwashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kachamuwak Tatayni Diospish willashurkankichi ñuka wambran kanaynita. Chashna willashuptikichipish kankunaka mana payta uyarinayashkankichichu nima kasunayashkankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tata Dios kachamuwashkanta mana kreyishpaykichi paypa rimanantapish mana shunkullikunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tata Diospa killkadunta kuti kuti leyishpa yachakunkichi. Sukaman yuyankichi chashna sukaman leyishpa Tata Dioswan mana tukuyniyukta kawsanaykichita. Chay leyishkaykichi Tata Diospa killkadunka riman ñuka Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chayta leyishpaykichipish mana ñukata kreyiwanayankichichu Tata Dioswan mana tukuyniyukta kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kankuna munawaptikichi mana munawaptikichipish mana nimananchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ñuka kankunata allita riksishpayni yachani Tata Diosta mana kuyanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tata Dios kachamuwaptin shamushka kaptinipish mana nima kasuwanayankichichu. Chaykamanka suk runa kikinpa yuyayninmanta yachachikuk shamuptinka paytaka kunanlla uyarinkichiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mana Tata Diosta kuyashpaykichi kankunapura sukwan sukwan sukaman alabanakunkichi. Mana sapallan Tata Dios alabashunaykichitachu munankichi. Chayrayku mana atipankichichu ñukata kreyiwayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ama yuyaychichu ñuka Tatayni Diospi kankunata chatanaynita. Suk chatashuknikichi runami tiyan. Payka Moisesmi. Paypa killkadunta leyishpaykichi yuyankichi allita Tata Dioswan kawsanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chashna yuyashpaykichipish manami paypa killkadunta kreyinkichichu. Moiseska killkarkan ñuka shamunaynita. Chayrayku paypa killkashkanta kreyishpaykichika ñukatapish kreyiwankichiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mana Moisespa killkashkanta kreyishpaykichika mana ñuka willashkaynitapish kreyinkichichu. Chashna Jesuska chay chiknik runakunata willarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Jerusalen llaktapi kaykashpara Jesuska aypa milagrukunata rurarkan. Aypa unkudukunata alliyachirkan. Chaymanta Galilea kocha chimbaman ñukaykunawan tantalla rirkan. Chay Galilea kochapa suknin shutinka karkan Tiberias. Chay kocha chimbaman ñukaykuna riptinikuna aypa runakuna katiwarkansapa aypa milagrukunata Jesus ruraptin kawashkankunarayku. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Chay tiempu mana ashwannachu illarkan ñukaykuna judiyu runakuna Paskua fiestata pasanaynikunapa. Chay kochata chimbashpaynikuna suk urkuman Jesuska pushawarkansapa. Chaypi tiyarirkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chaymanta Jesuska kawarkan aypa runakuna payman shamuptinkuna. Paykunata kawashpa Felipita willarkan: —Chay aypa runakunata karananchikunapa ¿maypití mikunata rantishunchisapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesuska chayta tapurkan yachanayashpa imatami Felipi willanka nishpa. Manara tapushpara payka yacharkan imatami ruranka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chaypina Felipika Jesusta willarkan: —Ishkay pachak kullki tiyawaptinchipish nima chaywan panta rantishpa chay aypa runakunata paktachinchimansapachu tipisituta mikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chashna Felipi willaptinna Jesuspa disipulun Pedrupa wawkin Andreska Jesusta willarkan: ");
INSERT INTO qvsNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Kay wambrapa tiyapun sebadamanta ruradu pichka pan ishkay challwa. Chayllawan mana nima layapi kay aypa runakunata paktachinchimansapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chaypi aypa ukshakuna tiyarkan chay pichka waranka runakuna tiyarinankunapa. Chaypina Jesuska ñukaykunata willawarkansapa: —Tukuy runakunata willaychi tiyarinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tiyariptinkunana Jesuska chay pichka pankunata apishpa Tata Diosta agradesirkan. Chaymanta ñukaykunata kuwarkansapa tukuy chay tiyaridu runakunata karanaynikunapa. Idenllata rurarkan challwakunawanpish tukuy chay runakuna saksanankunakaman. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Allita mikushkankunawasha Jesuska ñukaykunata willawarkansapa: —Tukuy puchushkankunata tantachiychi ama niman suk tipi usunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chashna Jesus willawaptinkuna chay pichka panmanta puchushkanta tantachirkanisapa chunka ishkay sestuta. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chashna Jesus chay milagruta ruraptin kawashpankuna chay runakuna sukaman almirashpankuna willanakurkansapa: —Payka deveras shuyaykananchikuna alli yachachikuk runami. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chaypina Jesusta mana munakta pushanayarkansapa sinchi kamachikukninkuna kananpa. Pushanayanankunata yachashpa Jesuska paykunata sakishpa rirkan chay urku sawanman chaypi sapallan kananpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chaymanta amusayaptinna chay urkupi Jesusta sakishpa ñukaykunaka kochaman urayamurkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chay kocha mañanpi chayashpaynikuna manarapish Jesus chayamuptin atun kanowapi yaykurkanisapa Kapernaum llaktaman rinaynikunapa. Chayman riykaptinikunana tutayarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chay atun kochata chimbaykaptinikunana sukaman sinchita wayrarkan. Chay wayrawan yakuka sukaman atunta olasyarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yaka sokta kilometru chawpi kochapi kashpaynikuna kawarkanisapa Jesusta ladunchawaptinkuna. Yaku sawanpi puriykaptin kawashpaynikuna sukaman manchakurkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chaypina Jesuska willawarkansapa: —¡Ama manchakuychichu! Ñukami kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chaypina kushikushpa kanowapi Jesusta yaykuchirkanisapa. Chaypira Kapernaumpi utka chayarkanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chay aypa runakuna chay urkupi kiparirkansapa puñunankunapa. Kayantin diya yacharkansapa chay sukllalla tiyak kanowapi ñukaykuna Jesuspa disipulunkuna chimbashkaynikunata. Yacharkansapa Jesus mana ñukaykunawan rishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chay runakuna Jesusta maskashpa mana tarirkansapachu. Chaypina Tiberias llaktamanta suk runakuna kanowankunapi chayarkansapa maypicha Jesus pankunata karashkankunapi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mana ni Jesusta nima disipulunkunata chaypi tarishpankuna chay kanowakunapi tukuy chay runakunaka chimbarkansapa Kapernaum llaktapi Jesusta maskak. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chashna chay maskak runakuna chimbashpankuna Jesusta tarirkansapa. Tarishpankuna tapurkansapa: —Maestru ¿aykapití kaypika chayamushkanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chaypina Jesuska willarkansapa: —Mash uyariwaychi. Ñuka panta karaptini kankuna mikushkankichi saksanaykichikaman. Kashkan mikunayashpaykichilla ñukata maskawaykankichi. Mana nima entiendishkankichichu imapami chay almirana milagruta rurashkani nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama tukuk mikunallata maskashpa sukaman turbakuychichu. Ñukapa yachachikunaynika iden allima mikunashinami. Chayllata ashwanta munaychi Tata Dioswan mana tukuyniyukta kawsanaykichipa. Tatayni Dioska kachamuwashka milagrukunata ruranaynipa tukuy runakuna yachanankunapa paypa wambran kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chaypina chay runakunaka Jesusta tapurkansapa: —Ñukaykuna Tata Dios munashkan layata rurashpa kawsanaynikunapa ¿imatatí rurashasapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chashna tapuptinkuna Jesuska willarkansapa: —Tatayni Dios ñukataka kachamuwashka kankunata yachachinaynipasapa. Chayraykumi munan ñukata kreyiwashpa kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chaypina chay runakunaka Jesustaka willarkansapa: —¿Kan ima milagrutatí yachanki rurayta? Kawachiwaysapa almirana laya milagruta. Chayta kawashpaynikunara yachashasapa Tata Dios kachamushushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chay ñawpa chunlla chakidu pampapi tukuy diya awilunchikuna aypa pankunata mikurkansapa. Tata Diospa killkadunpi willawanchisapa payka sielumanta panta kachamurkan mikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chashna willaptinkuna Jesuska willarkansapa: —Mash uyariwaychi. Manami Moiseschu sielumanta pantaka karashushkankichi. Tatayni Diosmi sielumanta alli mikunata kachamushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tata Dios ñukata kachamuwaptin sielumanta urayamushkani runakunata kawsachinaynipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chashna Jesus willaptinkuna paykunaka mañarkansapa: —Señor, tukuy tiempu chay laya mikunata kuwaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chashna chay runakuna mikunata mañaptinkunana Jesuska willarkansapa: —Ñukaka kawsachikuk mikunaykichishinami kani. Kankuna tukuy shunku kreyiwaptikichika iden alli mikunaykichishinami kani. Ñukaman shamushpaykichi manana kutin yarkankichinachu. Ñukata kreyiwashpaykichi manana kutin yakunayankichinachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kashkan willaykichi. Kankunaka kawashpaykichipish mana kreyiwanayankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tukuy Tata Dios kuwashkan runakuna munawashpankuna ñukaman shamunkasapa. Paykunataka chaskishasapa. Mana niman suk shamukkunata karkushasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sielumanta shamushkani kachamuwak Tatayni Diospa munananllata ruranaynipa. Manami shamushkanichu kikinipa munanaynita rurak. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Sielumanta kachamuwak Tatayni munan tukuy ñukata kuwashkan runakunata allita kuydanaynipasapa ama niman suk ñukamanta ashunankunapa. Payka munan kay allpa tukunan diya tukuy paykunata kawsachimunaynipasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tatayni Dios munan tukuy runakuna ñuka wambranta tukuy shunku kuyawashpa kreyiwanankunapa. Chaypina kay allpa kullunan diya tukuy kreyiwak runakunata kawsachimushasapa Tata Dioswan mana tukuyniyukta kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chashna Jesus yachachikuptinna chay judiyu runakuna sukaman piñakurkansapa. Mana munarkansapachu Jesus willanankunapa sielumanta mikunankunashina kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Paykunapura parlanakurkansapa: —¿Manachu kay runaka Josepa wambran? Ñukanchikunaka tatanta mamanta allita riksinchisapa. ¿Imapatí riman sielumanta shamushkanta? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chashna parlanakuptinkuna Jesuska willarkansapa: —Ama piñakushpa yuyawaychichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mana ni pi atipanmanchu kreyiwayta kachamuwak Tatayni mana yanapaptin. Chaymanta kay allpa tukunan diya tukuy kreyiwak runakunata kawsachimushasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ñawpa alli yachachikuk runakuna killkarkansapa: “Tata Dios tukuy runakunata yachachinkasapa.” Chayrayku tukuy Tata Diosta kreyik runakuna tukuy paypa yachachikushkanta yachakuk runakuna ñukatapish kreyiwankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mana niman suk runa Tatayni Diosta kawashkachu. Ñukallami paymanta shamushka kashpayni paytaka allita kawashkani. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mash allita uyariwaychi. Kankuna ñukata allita kreyiwashpaykichi Tatayni Dioswanmi mana tukuyniyukta kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ñukaka kawsachishuknikichi mikunaykichishinami kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chay chunlla chakidu pampapi ñawpa awiluykichika Tata Dios kachamushkan pankunata mikushpankunapish wañurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ñuka yachachiykichi chikan laya sielumanta urayamushkan mikunaykichita. Chay mikunata mikuk runakuna mana tukuyniyukta kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ñukaka sielumanta urayamushka kawsachikuk mikunashinami kani. Wañusha runakunata kawsachimunaynipasapa. Chashna wañushpayni kuerpuynita kuykichi alli mikunaykichishina kanaynipa. Ñukata kreyiwashpaykichi mikuwakshina kankichi. Chashna kreyiwashpa kawsashpaykichika mana tukuyniyukta kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chashna Jesus yachachikuptin chay awtoridar runakuna mana entiendishpa sukwan sukwan ayninakurkansapa: —¿Imashnatí kuerpunta kuwanchisapa mikunanchikunapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chaypina Jesuska willarkansapa: —Mash allita uyariwaychi. Ñuka Tata Diosmanta shamudu runa kaptini kankuna kreyiwashpa kawsanaykichi tiyan. Kreyiwashpa kawsashpaykichi kuerpuynita mikukshina yawarninita upyakshina kankichi. Mana kuerpuynita mikushpaykichika mana yawarninita upyashpaykichika manami Tata Dioswanchu kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kuerpuynita mikushpaykichika yawarninita upyashpaykichika mana tukuyniyukta kawsankichi. Kay allpa kullunan diya ñukami kawsachimushkaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kuerpuynika deveras kawsachikuk mikunashinami. Yawarninika deveras kawsachikuk upyanashinami. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kankuna kuerpuynita mikushpaykichi yawarninita upyashpaykichi shunkuykichipi chaskiwankichi. Chashna chaskiwashpaykichi ñukawan paktanakushpa kawsankichi. Ñukapish kankunawan paktanakushpa kawsani. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kachamuwak Tatayni Dios kawsachikuk kashpa ñukata kawsachiwan. Tata Dios kawsachiwaptin ñukapish kreyiwak mikuwak runakunata kawsachini. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yachachiykichi ñuka sielumanta urayamushkaynita mikunaykichishina kanaynipa. Ñawpa awiluykichi Tata Dios karashkan pankunata mikushpankunapish wañurkansapa. Ñuka sielumanta shamudu mikunaykichi kaptini tukuy kreyiwak runakuna mana tukuyniyukta kawsankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesuska tukuy chayta yachachikurkan Kapernaum llaktapi tantanakunankuna wasipi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chashna Jesus yachachikuptinna chay katik runakunaka willanakurkansapa: —Kay runapa yachachikunanka mana munanapa layami. ¿Pití atipanman kasuyta? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus willanakushkankunata yachashpa tapurkansapa: —Ariya ¿kay yachachikunaynika rabyachishunkichichu? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Imatatí rimankichiman kawawashpaykichi sieluman kutiptini? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tata Diospa Espiritun kawsachishunkichi Tata Dioswan kawsanaykichipa. Kikikichilla mana atipankichichu Tata Dioswan kawsayta. Chayrayku rimanaynita kreyishpaykichi Tata Dioswan kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Allita yachachikuptinipish kankunamanta sukmi mana kreyiwanchu. Chayrayku willashkaykichina mana Tata Dios yanapashuptikichika mana niman suk kankuna atipankichimanchu ñukata kreyiwashpa kawsayta. Jesus chayta willarkansapa kallarinanmantapacha allita yachashpa pikunami payta mana kreyinkasapa nishpa. Chaymanta yacharkan pimi rantikunka chiknik runakuna wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chay diyamantapacha aypa katik runakuna manana katirkansapanachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chayrayku Jesuska ñukaykuna chunka ishkay disipulunkunata tapuwarkansapa: —¿Kankunapish sakiwanayankichichu? ");
INSERT INTO qvsNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chashna tapuwaptinkuna Simon Pedruka willarkan: —Maestru ¿pitatí katiymansapa? Kanllami yachachiwankisapa imashnami Tata Dioswan mana tukuyniyukta kawsashasapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ñukaykunaka rimanaykita kreyishpaynikuna yachanisapa Tata Dios akllashuptiki allpaman shamushkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chaypina Jesuska ayniwarkansapa: —Ñukaka kankunata akllashkaykichimi chunka ishkay disipuluynikuna kanaykichipa. Kankunata akllashka kaptinipish kankunamanta sukmi supayta kasushpa kawsan. ");
INSERT INTO qvsNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chashna rimashpa Jesuska rimaykarkan Simon Iskariotepa wambran Judaspa. Judas Jesuspa disipulun kaykashpapish payta rantikurkan chiknik runakuna wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaymanta Galilea partipi ñukaykunawan Jesuska llaktan llaktanpi yachachikuypi purirkan. Mana munarkanchu Judea partipi puriyta yachashpa kamachikuk judiyukuna wañuchinayanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tukuy wata ñukaykuna judiyukuna suk fiestata ruranisapa ñawpa awiluynikuna ranchunkunapi kawsashkankunata yuyashpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chay fiesta mana sukaman illaptin Jesuspa wawkinkuna willarkansapa: —Ama kaypika kipariychu. Rillay Judea partiman fiestakuk chay katishuk runakuna almirana ruranaykita kawanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Suk runa tukuy runakunapi riksichinakunayashpa mana pakallachu almirana layakunata ruran. Kan almirana layakunata ruranayashpaykika rillay chay atun llaktapi rurak tukuy runakuna kawanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesuspa wawkinkuna mana payta kreyishpankuna chayta willarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chashna willaptinkuna Jesuska willarkansapa: —Tatayni Dioska manara willawashkarachu rinaynipa. Kankunapa ima orapish kaptin allimi rinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ñukaka mana alli rurak runakunata willani mana allita rurashpa kawsaykanankunata. Chayrayku chikniwansapa. Munayninkunapi kawsak runakuna mana kankunata chiknishunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Chayrayku ima orapish kaptin kankunaka chay fiestaman rillaychi. Tatayni Dios manara willawaptin manara risharachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chashna Jesus wawkinkunata willashpa Galilea partipi kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chashna Jesus willaptinna chay fiestaman wawkinkunaka rirkansapa. Paykuna rishkankunawasha Jesuspish rirkan. Jerusalenpi chayashpaynikuna pakallalla karkanisapa ama ni pi yachananpa Jesus chaypi kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chay fiesta ukun judiyu awtoridarkuna Jesusta maskashpa tapunakurkansapa: —¿Maypirá chay runaka? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tukuy runakuna Jesus yachachikunanta sukaman parlachinakurkansapa. Sukkuna rimarkansapa alli yachachikuk runa kananta. Sukkuna rimarkansapa mana alli rurak kashpa llullachikuykananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Paykunaka awtoridarninkunata manchashpankuna upallalla parlachinakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chay fiesta chuskuynin diya Jesuska rirkan Tatan Diospa wasinpi yachachikuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chaypi yachachikuykaptin judiyu awtoridarninikunaka almirashpankuna tapunakurkansapa: —¿Imashnatí kay runaka Tata Diospa rimananta yachan mana ñukanchikuna yachachiptinchikuna? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chayta uyarishpana Jesuska willarkansapa: —Ñukaka manami kikinipa yuyayninimantachu yachachikuykani. Kachamuwak Tatayni Dios yachachiwashkanta yachachikuykani. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kankunaka Tata Diospa munananta ruranayashpaykichika yachankichiman paypa yuyaynintachu kikinipa yuyayninimantachu yachachikuni nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Suk runa kikinpa yuyayninta yachachikushpa munan runakuna payllata kuyashpa alabanankunapa. Ñukaka munani tukuy runakuna kachamuwak Tatayni Diosta kuyashpa kawsanankunapa. Chayrayku mana llullatachu yachachikuni. Mana nima llullakunichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ñawpa alli yachachikuk Moiseska killkadunpi yachachishushkankichi imashnami allita rurashpa kawsankichi nishpa. Kankuna chayta mana nima kasunkichichu. Moisespa yachachikunanta kasushpaykichika ¿imapatí ñukata wañuchiwanayankichi? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chashna Jesus sinchita willaptinkuna chay runakuna willarkansapa: —Kanka supayadumi kanki. ¿Pití wañuchishunayanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chashna willaptinkuna Jesuska willarkansapa: —Ñuka suk unkudu runata samana diya alliyachishkani. Chayrayku kankuna rabyashkankichi rimashpa mana allita rurashkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mash uyariwaychi. Kankunaka Moisespa killkadunta kasushpa ullku wambraykichi pusak diyayuk kaptin samana diya kaykaptinpish pishkitunta señalapunkichi. Awilunchi Abrahampa tiempunmantapacha chashna tukuy judiyu runakuna ruranchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","¿Manachu kankuna Moisespa killkadunta kasushpa samana diya kaykaptinpish ullku wambrata señalachinkichi? Chayrayku ¿imapatí piñakunkichi samana diya unkudu runata alliyachiptini? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ama rimaychichu suk runa mana alli rurak kananta manara allita yachashpara mana allita rurashkanta. Allita yachashpara chatakuychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chaymanta Jerusalenpi kawsak runakuna tapunakurkansapa: —¿Manachu awtoridarninchikuna kay runataka maskaykansapa wañuchinankunapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kunanka tukuy pi kawaptin kay runaka yachachikuykan. Mana ni pi paytaka michanchu yachachikuptin. Ichará awtoridarninchikuna ña kreyinsapana pay shuyaykananchikuna Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Paykuna kreyiptinkunapish ñukanchikuna allita yachanchisapa maymantami shamushka kay runaka. Shuyaykananchikuna salvakuk shamuptin mana yachashunchisapachu maymantami shamun nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chayta uyarishpana Jesus Tata Diospa wasinpi yachachikuykashpa sinchita willarkansapa: —Kankunaka rimaykankichi ñukata allita riksiwanaykichita. Rimaykankichi yachanaykichita maymantami shamushkani nishpa. Chashna rimashpaykichipish mana riksiwankichichu. Nima kachamuwaktapish riksinkichichu. Payka mana ni pita llullachinchu. Ñukaka manami kikinimantachu shamushkani. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tatayni Diosmanta shamushkani. Tata Dios kachamuwashka kaptin paytaka allita riksini. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chayta willaptinkuna chay awtoridar runakuna Jesusta apinayarkansapa wañuchinankunapa. Manara apirkansaparachu mana wañunan ora kaptinra. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jesus willashkankunata uyarishpa aypa runakuna kreyirkansapa Tata Diosmanta shamudu runa kananta. Rimarkansapa: —¿Manachu kay runaka chay shuyaykananchikuna Tata Diosmanta shamudu runa? Mana ni suk runa paymanta ashwan almirana milagrukunata ruranmanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Runakuna chayta rimaptinkuna fariseokunawan saserdotekunapa awtoridarninkuna uyarirkansapa. Chaypina Tata Diospa wasinta kuydak runakunata kacharkansapa Jesusta apinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chay kuydakuk runakuna apinayaptinkuna Jesuska willarkansapa: —Mananami ashwannachu illan kankunamanta ashunaynipa. Kachamuwak Tatayniman kutisha. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chashna riptini kankunaka maskawashpa mananami tariwankichinachu. Chay rinayniman manami atipankichichu chayayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chashna Jesus rimaptinna judiyu awtoridarkuna sukwan sukwan tapunakurkansapa: —¿Maymantí rinka kay runaka ñukanchikuna maskashpa mana tarinanchikunapa? Ichará kay llaktamanta rinayan chikan karu llaktaman chaypi judiyumasinchikunawan kawsak. Ichará chay chikan kasta runakunata yachachik rinayan. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Chayrayku payka rimashka: “Maskawashpa mana tariwankichichu. Ñuka rinayniman mana atipankichichu chayayta.” Chayta rimashpa ¿imatatí rimaykan? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tukuy wata chay fiesta tukunan diya tukuy runakuna sukaman ashwanta kushikuksapa. Chay tukunan diya Jesuska aypa runakunapa chawpinkunapi shayarishpa sinchita rimakushpa willarkansapa: —¡Mash uyariwaychi! Kankuna yakunayashpaykichi ñukaman shamuychi upyanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tata Diospa rimananpi willawananchishina tukuy ñukata kreyiwak runakuna sukaman kushikunkasapa. Shunkunkunapi kawsachikuk yaku pachyamukshina kanka. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chayta rimashpa Jesuska yachachikuykarkan payta kreyik runakuna Tata Diospa Espiritunta chaskinankunata. Jesus manara wañushkanmanta kawsamuptinra Tata Diospa Espiritun manara shamurkanrachu payta kreyik runakunapi kawsak. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus yachachikushkanta uyarishpankuna suk runakuna rimarkansapa: —Kay runaka Moises alli yachachikuk shamunanta rimashkan runami. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sukkuna rimarkansapa: —Kay runaka shuyaykananchi Tata Diosmanta shamudu runami. Sukkuna chikan layata rimarkansapa: —Kay runaka manami shuyaykananchikuna runachu. Tata Diosmanta shamudu runaka manami Galilea partimantachu shamunka. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tata Diospa killkadunpi riman Tata Diosmanta shamudu runa ñawpa kamachikuk Davidpa miraknin kananta. Chaymanta riman Davidpa Belen llaktanpi nasinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chashna Jesuspa rikchak layata yuyashpankuna chay runakunaka piñanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sukkuna Jesusta apinayarkansapa. Apinayashpapish mana ni pi animukurkansapachu apiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chay kuydakuk runakuna fariseo runakunaman saserdotekunapa kamachikukninkunaman kutirkansapa. Mana Jesusta pushashpa kutiptinkuna awtoridarkunaka tapurkansapa: —¿Imapatí chay runataka mana pushamushkankichi? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chashna tapuptinkuna kuydak runakunaka willarkansapa: —Payka sukaman allima rimanayukmi. Mana ni pi payshina allita yachachikunchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chaypina fariseo runakunaka willarkansapa: —Ariya ¿ñachu chay runaka kankunatapish llullachishushkankichina? ");
INSERT INTO qvsNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ñukaykunaka manami ni maykan paytaka kreyinisapachu. Niman suk awtoridar niman suk fariseo runa chay runataka kreyinisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aypa runakuna Tata Diospa killkadunta mana yachashpankuna paytaka kreyiykansapa. Chayrayku paykunata Tata Dios kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chay fariseo runakunawan tantalla Nikodemo karkan. Chay Nikodemoka suk kuti tutapi Jesusta rirkan parlachik. Payka fariseo runa kaykashpa fariseomasinkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Tata Diospa killkadun willawanchisapa ama ni pita kastigananchikunapa manara allita yachashpara imatami rurashka nishpa. Uchayuk kananta allita yachashpanchikunara chaypira kastigashunchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chashna Nikodemo willaptinkuna fariseomasinkunaka willarkansapa: —¿Kanpish Galileamantachu kanki? Mash Tata Diospa killkadunta yachakuy yachanaykipa mana niman suk alli yachachikuk runa Galileamanta shamushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chay fariseokuna ayninakushkankunawasha wasinkunaman kutirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fariseo runakuna wasinkunaman kutiptinkuna Jesuska Olivos urkuman rirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kayantin diya pakariykaptin Tata Diospa wasinman ñukaykunawan kutirkan. Chaypi kaptin aypa runakuna laduncharkansapa. Jesuska tiyarishpa kallarirkan paykunata yachachiysapata. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaypi yachachikuykaptin Moisespa killkadunta yachachikuk runakunawan fariseo runakuna suk warmita pusharkansapa. Payta chay runakunapa chawpinkunapi churarkansapa. Chay warmitaka tarirkansapa chikan ullkuwan uchallikuykaptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Chaypina Jesustaka willarkansapa: —Maestru, kay warmita tarishkanisapa chikan ullkuwan uchallikuykaptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisespa killkadunpi yachachiwanchi kay laya warmikunata ruminchashpa wañuchinanchipa. ¿Ima ninkití kanka? Ariya ¿wañuchishunchisapachu? ");
INSERT INTO qvsNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chayta tapushpa chay runakunaka munarkansapa pantachishpa Jesusta chatakuyta. Chashna tapuptinkuna Jesuska mana nimata aynishpa kumurayashpa allpapi dedunwan killkakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Chashna killkakuykaptin chay runakunaka kuti kuti tapuykarkansapa. Chaypina Jesuska kuskayashpa paykunata willarkansapa: —Maykan mana uchayuk kashpaykichika kallariychi kay warmita ruminchayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chashna rimashpa Jesuska kashkan kumurayashpa allpapi killkakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chaypina tukuy paykuna uchankunata yuyamushpankuna sukmanta sukmanta llukshirkansapa. Ashwan vieju runakuna kallarirkansapa llukshiyta. Chaymanta viejukunata katishpa tukuyna llukshirkansapa. Tukuy chay runakuna llukshiptinkunana Jesuska chay warmiwan kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chaypina Jesuska kuskayamushpa tapurkan: —¿Maytanatí chay chatashuk runakunaka rishkasapa? ¿Manachu niman suk animukushka ruminchashuyta? ");
INSERT INTO qvsNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chashna tapuptin chay warmika aynirkan: —Mana ni maykan, Señor. Chaypina Jesuska willarkan: —Ñukapish mana kastigaykichu. Kunan wasikiman rillay. Amana kashkan uchallikuynachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus kashkan chay runakunata yachachishpa willarkansapa: —Ñukaka tukuy runakunapa lusninshinami kani. Ñukata katiwashpaykichi manana tutapishinanachu purinkichi. Katiwaptikichi yachachiykichi allita rurashpa Tata Dioswan luspishina kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chashna Jesus willaptinkuna fariseo runakunaka willarkansapa: —Kikikilla rimaykanki lus kanaykita. Kanlla chayta rimaptiki mana kreyiykisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chaypina Jesuska willarkansapa: —Kankunaka mana yachankichichu maymantami shamushkani nima maymanmi rini nishpa. Ñukaka allita yachani maymantami shamushkani maymanmi rini nishpa. Chayrayku kikinipa rimanaynika allimi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kankuna kikikichipa yuyaynikichillamanta chatawayllapi purinkichi. Ñukaka manami kankunashinachu ni pita chataykani. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ñukaka chatakushpaynika kuskanpi chatakuni. Mana sapallaynillachu chatakuni. Kachamuwak Tatayni Dioswan pakta chatakuni. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kankunapa killkaduykichipi yachachishunkichi: Suk runa suk mana alli rurak runata kankunapi chataptin sukllalla chatakuk runata ama kreyiychichu. Ishkay runakuna idenllata chatakuptinkuna chaypira kreyiychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ñuka rimani alli yachachikuk kanaynita. Chaymanta kachamuwak Tataynipish idenllata riman. Chashna Tatayniwan ñuka idenllata yachachikuptinikuna kankuna kreyiwanaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chashna Jesus willaptinkuna chay runakunaka tapurkansapa: —¿Maypití tataykika? Chaypina Jesuska aynirkansapa: —Kankunaka ñukata manami riksiwankichichu. Nima Tataynitapish riksinkichichu. Ñukata riksiwashpaykichika Tataynitapish riksinkichiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus chaykunata yachachikurkan Tata Diospa wasinpi ofrendakuna churanankuna kajonkunapa ladunpi. Chashna yachachikuptinpish manara ni pi animukurkanrachu apiyta manara oran kaptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chashna manara apiyta animukuptinkunara Jesuska kashkan yachachikushpa willarkansapa: —Ñukaka kankunamanta anchusha. Chashna anchuptini maskawankichi. Kankunaka mana kreyiwashpaykichika uchaykichipi wañunkichi. Chayrayku mana atipankichichu chay rinayniman chayayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chashna Jesus rimaptin chay runakunaka willanakurkansapa: —Ichará kikin wañuchinakunayan. Chayrayku willawanchisapa mana atipananchikunata chay rinanman chayayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chashna willanakuptinkuna Jesuska willarkansapa: —Kankuna kay allpallapi wañuk runakuna kankichi. Ñuka sielumanta shamushkani. Kankuna uchalla runakuna kankichi. Ñukaka manami kankunashina ucha rurak runachu kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chayrayku willashkaykichina uchaykichirayku wañunaykichita. Ñuka Tata Diosmanta shamudu runa kanaynita mana kreyiptikichi uchaykichipi wañunaykichi tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chashna Jesus yachachikuptin chay chiknik runakuna tapurkansapa: —¿Pití kanki? Chaypina Jesuska aynirkansapa: —¿Imapatí kashkan tapuwankichi? Kallarinanmantapacha willashkaykichina. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tiyanra aypa layata willanaynipa aypa mana alli rurashkaykichita chatanaynipa. Kankuna mana kreyiwaptikichipish kachamuwak Tatayni yachachiwashkanta kankunata yachachiykaykichi. Payka sukaman allima kashpa mana nima llullakunchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Chashna Jesus allita yachachiptinkunapish chay chiknik runakunaka mana entiendirkansapachu Tatan Diosmanta shamushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chayrayku Jesuska willarkansapa: —Kankuna suk kruspi chakatawashpaykichira yachankichi sielumanta shamudu runa kanaynita. Ñuka mana kikinipa yuyayninitachu rurashpa kawsani. Tata Dios yachachiwashkanllatami yachachiykaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kachamuwak Tatayni ñukawan tantalla kawsan. Payka manami sakiwanchu paypa munananllata ruraptini. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chashna Jesus yachachikuptinna aypa runakuna kreyirkansapa Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chaypina Jesuska chay kreyik runakunata yachachirkansapa: —Kankuna yachachikushkaynita allita kreyishpa kawsashpaykichika deverasmi disipuluynikuna kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chaypira yachankichi kuskanpi yachachikushkaynita. Chaymanta yachachikushkaynita kreyishpaykichi mananami ñawpashina uchallikushpaykichinachu kawsankichi. Mananami patronpa mandunpishinanachu kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chaypina chay mana kreyinayak runakunaka willarkansapa: —¿Imapatí willawankisapa ñukaykuna iden patronpa mandunpishina kanaynikunata? Ñukaykunaka ñawpa awiluynikuna Abrahampa mirakninmi kanisapa. Chayrayku mana ni pipa mandunpichu kanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chaypina Jesuska willarkansapa: —Allita uyariwaychi. Kankuna uchasapa runakuna kashpaykichi mana atipankichichu allita rurashpa kawsayta. Chayrayku patronpa mandunpi runakunashina kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Patronpa mandunpi kawsak runakuna mana tukuy tiempuchu chaypi kawsansapa. Patronpa wambrankunallami wasinpi kawsansapa. Kankuna munanaykichillata rurashpa manami Tata Diospa wambrankunachu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ñuka Tata Diospa wambran kashpayni atipani yanapaynikichita amana uchallikushpa kawsanaykichipa. Chashna yanapaptinira atipankichi allita rurashpa kawsayta. Chaypirami manana patronnikichipishinanachu kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahampa miraknin kashpaykichipish mana willashkaynita chaskinkichichu. Chayrayku wañuchiwanayaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ñukami Tatayni yachachiwashkanta yachachikuni. Kankunapish tataykichi willashushkankunata ruraykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chashna Jesus willaptinkuna chay runakunaka willarkansapa: —Ñukaykunapa tataynikunaka Abrahammi. Chaypina Jesuska willarkansapa: —Abrahamka allillata rurashpa kawsarkan. Kankuna deveras paypa miraknin kashpaykichika payshina allillata rurashpa kawsankichiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mana kankunashinachu Abrahamka rurarkan. Ñuka Tata Dios yachachiwashkanta yachachiykaptinipish kankunaka wañuchiwanayankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kankuna chikan tatayuk kankichi. Chay tataykichipa mana alli rurananta kankunapish rurashpa kawsaykankichi. Chashna Jesus willaptinkuna chay runakunaka piñakushpa willarkansapa: —Manami chikan tatayukchu kanisapa. Ñukaykunapa tataynikunaka Tata Diosllami. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chashna willaptinkuna Jesuska willarkansapa: —Kankuna deveras Tata Diospa wambrankuna kashpaykichika ñukata kuyawankichiman. Tata Dios kachamuwashka kaptin kay allpaman shamushkani. Manami kikinipa yuyayninillamantachu shamushkani. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ñuka yachachikuptini kankunaka mana kreyiwanayankichichu. Chayrayku mana atipankichichu rimanaynita entiendiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Supayta uyarishpa munananllata rurashpa kawsankichi. Chayraykumi supayka tataykichi. Paypa mandunpi kawsaykankichi. Supayka kallarinanmantapacha wañuchikukmi. Sukaman llulla likidu kashpa sukaman llullachikuypi purin. Manami niman suk kuti kuskatachu riman. Kikinllamanta llullakushpa riman. Payka llullallata yachachikun. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ñuka kuskata yachachikuptinipish kankunaka manami kreyiwankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ñukami allillata rurashpa kawsaykani. ¿Maykan kankunatí willawankichi uchayuk kanaynita? Ñuka mana llullakushpa kuskata yachachikuptini ¿imapatí mana kreyiwankichi? ");
INSERT INTO qvsNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kankuna Tata Diospa wambrankuna kashpaykichika paypa rimananta uyarinkichiman. Mana Tata Diospa wambrankuna kashpaykichi rimananta mana kasunayankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chashna Jesus willaptinkuna chay runakunaka sukaman piñakushpa willarkansapa: —Kuskata rimashkanisapa samaritano runa kanaykita. Supayadumi kanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chaypina Jesuska willarkansapa: —Manami supayaduchu kani. Tatayni Diosta kushichishpalla kuyani. Payta allita kuyaptinipish kankuna mana kreyiwashpa mana nimatashina kawawankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mana allita yuyawaptikichipish ñukapa mana nimananchu. Tatayni Dios sukaman munan kankuna kuyawanaykichipa. Mana kuyawashkaykichirayku payka kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mash allita uyariwaychi. Tukuy ñukapa yachachikunaynita kasushpa kawsak runakuna manami wañunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chashna Jesus rimaptinna chay chiknik runakunaka willarkansapa: —Kunanka ñami allitana yachanisapa supayadu kanaykita. Ñawpa kawsak awilunchikuna Abrahamka tukuy ñawpa alli yachachikuk runakunapish wañurkansapa. ¿Imapatí rimanki tukuy yachachikunaykita kasushpa kawsak runakuna mana wañunankunata? ");
INSERT INTO qvsNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ariya ¿ñawpa tiempu kawsak awilunchikuna Abrahammanta ashwan alli yachakchu kanki? Payka wañurkan. Chaymanta tukuy ñawpa alli yachachikuk runakunapish wañurkansapa. ¿Ima laya runa kanaykitatí yuyanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chashna willaptinkuna Jesuska willarkansapa: —Kankunaka mana entiendiwaykankichichu. Manami kikinillachu alabanakuni. Kikinilla alabanakushpaynika mana allitachu rimayman karkan. Tataynimi ñukata alabawan. Kankuna rimankichi ñukapa Tatayni kankunapapish Diosnikichi kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Chashna rimashpaykichipish manami paytaka riksinkichichu. Ñukami esika allita riksini. Tata Diosta mana riksinaynita rimashpaynika ñukapish kankunashina llullakuk runa kayman. Tata Diosta allita riksishpayni rimananta allita kasuni. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kankunapa ñawpa awiluykichi Abrahamka kushikurkan yachashpa ñuka sielumanta shamunaynita. Chaymanta shamunaynita kawashpana sukaman kushikurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chashna Jesus willaptinkuna chay chiknik runakunaka willarkansapa: —Llullakuykankimi. Ñami aypa watakunana awilunchi Abraham wañushkan. Kanka manara nima pichka chunka watayuk kashpaykira ¿imapati rimanki Abrahamta riksishkaykita? ");
INSERT INTO qvsNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chashna willaptinkuna Jesuska willarkansapa: —Mash allita uyariwaychi. Manarapish Abraham tiyaptinra ñukami ashwan ñawpamantapacha kawsaykani. ");
INSERT INTO qvsNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chashna Jesus willaptinkuna chay runakunaka sukaman piñakushpankuna rumikunata apirkansapa ruminchanankunapa. Ruminchanayaptinkuna Jesuska chay aypa runakuna ukunpi pakakushpa Tata Diospa wasinmanta llukshirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tata Diospa wasinmanta llukshishpa Jerusalen llaktapi Jesuska ñukaykunawan puriykarkan. Chaypina suk mana kawakuk runata kawarkanisapa. Chay runaka nasishkanmantapacha mana kawakurkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Payta kawashpaynikuna Jesusta tapurkanisapa: —Maestru ¿imapatí chay runaka mana kawakuk nasishka? ¿Kikinpa uchanraykuchu? ¿Tatanpa mamanpa uchankunaraykuchu mana kawakuk nasishka? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesuska willawarkansapa: —Kay runaka manami kikinpa uchanraykuchu nima tatanpa nima mamanpa uchanraykuchu mana kawakuk nasirkan. Payka chay laya nasirkan Tata Dios kankunata kawachishunaykichipa atipananta alliyachiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wañunanchikuna diyakaman kachamuwak Tatayni willawashkanchikunata rurananchikuna tiyan. Wañushpanchikuna manami atipanchisapachu trabajayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Manarapish wañushpaynira runakunata yachachiykani. Chashna yachachikushpayni ñukaka tukuy runakunapa lusninshinami kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chayta rimashkanwasha Jesuska allpapina tukakurkan. Chay tukayninwan suk tipi turuta rurarkan. Chaypina turuwan chay mana kawakuk runapa ishkantin ñawinkunata tuparkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tupashpana willarkan: —Rillay Siloe tantanachidu yakupi ñawikita mayllamuy. Siloe shutin riman Kallpachimudu Yaku. Chashna Jesus willaptin payka rirkan ñawinta mayllakna. Mayllashkanwasha atiparkan kawakuyta. Chaypina allita kawakushpa wasinman kutirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chaypina chay alliyadu runapa ladunpi kawsakkuna chay kullkita mañakuptin kawak runakuna payta kawashpa tapunakurkansapa: —¿Manachu kayka tiyarishpa kullkita mañakuk runa? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sukkuna rimarkansapa: —Ariya paymi mana kawakuk runa karkan. Sukkuna rimarkansapa: —Payshina rikurishpapish manami paychu. Chashna chay runakuna sukaman ayninakuptinkuna chay alliyadu runaka willarkansapa: —Ñukami kani kullki mañakuk runaka. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chashna rimaptinna chay riksik runakunaka tapurkansapa: —¿Imashnatí atipanki kawakuyta? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chashna tapuptinkuna willarkansapa: —Chay runa Jesusmi suk tipi turuta rurashpa ñawinikunata tupashpa willawashka: “Rillay Siloe yakupi ñawikita mayllamuy.” Chashna willawaptinna rirkani mayllak. Mayllashkaynimantapacha atipani allita kawakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chaypina chay runakuna paytaka tapurkansapa: —¿Maypití kunanka chay alliyachishushka runaka? Chashna tapuptinkunana willarkansapa: —Manami yachanichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesus chay mana kawakukpa ñawinta turuwan tupashpa alliyachishkan diyaka samana diya karkan. Chayrayku ladunpi kawsak runakuna chay runataka fariseo awtoridarkunaman pusharkansapa chatanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chaypina fariseokunaka payta tapurkansapa: —¿Imashnatí kanka mana kawakuk kashkaykimanta atipanki kawakuytana? Chashna tapuptinkuna willarkansapa: —Suk runa turuwan ñawinita tupaptin rishkani yakuwan mayllak. Mayllashkayni ratumanta atipani kawakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chashna willaptinkuna suk fariseokunaka rimarkansapa: —Samana diya alliyachishushpa chay runaka manami Tata Diosmanta shamudu runachu. Sukkuna rimarkansapa: —Uchasapa runa kashpaka manami atipanmanchu kay almirana layata rurayta. Chashna ayninakushpankuna chay fariseokunaka mana atiparkansapachu suk yuyayllapi kipariyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chaypina kashkan chay alliyadu runataka tapurkansapa: —Chay alliyachishuk runapaka ¿imatatí kanka rimanki? Chaypina chay runaka willarkansapa: —Ñuka yuyani alli yachachikuk runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Chaypina chay awtoridarkunaka mana kreyinayarkansapachu chay runa mana kawakuk kashkanta nima alliyadu kashkanta. Chayrayku payta llukshichishpankuna tatanta mamanta kayachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tatan maman shamuptinkuna paykunata tapurkansapa: —Kankuna willawaysapa. ¿Deveraschu chay runaka wambraykichi? ¿Deveraschu mana kawakuk nasishka? Mana kawakuk nasishpaka ¿imashnatí kunanka allitana atipan kawakuyta? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chaypina tatan mamanka willarkansapa: —Ariya chay runaka wambraynikunami. Ariya mana kawakukmi nasirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Manami yachanisapachu imashnami alliyashka nishpa. Nima yachanisapachu pimi alliyachishka nishpa. Kikinta tapuychi. Payka ñami atun runana. Paymi allita willashunkichi imashnami atipashka kawakuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tatan mamanka manchakuywan chashna aynirkansapa. Manarapish Jesus chay runata alliyachiptin fariseo awtoridarkuna paktanakushpa tukuy runakunata willarkansapa: “Maykan runa rimaptin Jesus Tata Diosmanta shamudu runa kananta paytaka tantanakunanchikuna wasimanta karkushunchisapa ama kutin yaykunanpa.” ");
INSERT INTO qvsNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Fariseokunata manchashpankuna chay alliyadu runapa tatan mamanka willarkansapa: “Payka ñami atun runana. Kikinta tapuychi.” ");
INSERT INTO qvsNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaypina awtoridarkunaka chay alliyadu runata kashkan yaykuchishpankuna willarkansapa: —Tata Dioska tukuy rimanaykita uyariykan. Chayrayku kuskata rimay. Ñukaykuna yachanisapa chay alliyachishushka runaka sukaman uchasapa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chashna willaptinkuna payka willarkansapa: —Ñukaka manami yachanichu chay runa uchasapachu manachu nishpa. Allita yachani mana kawakuk kashkaynimanta allitana kawakunaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chaypina kashkan tapurkansapa: —¿Imata rurashpatí chay runaka alliyachishushka? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chaypina payka aynirkansapa: —Ñami tukuytana willashkaykichi. Willaptinipish manami kreyiwankichichu. ¿Imapatí kuti kuti tapuwankichi? Ichará kankunapish Jesustaka katinayankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chaypina chay awtoridarkunaka sukaman piñayashpa willarkansapa: —Kanmi chay runataka katinki. Ñukaykunaka ñawpa alli yachachikuk Moisesllata katinisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Allita yachanisapa Tata Dioska Moiseswan parlashkanta. Mana nima yachanisapachu pimi chay Jesusta kachamushka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chaypina chay runaka willarkansapa: —Ñukaka sukaman almirani kankuna mana yachaptikichi pimi Jesusta kachamushka nishpa. Chay runa alliyachiwashkanrayku yachankichiman Tata Dios kachamushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tukuy runakuna allita yachanchisapa Tata Dios payta kuyak payta kasuk runakunallata uyarinankunata. Manami uchasapa runakunata uyarinsapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ñawpamantapacha kunankaman mana uyarishkanchisapachu ni pi mana kawakuk nasishkata alliyachishkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kay runa mana Tata Diosmanta shamushka kashpaka manami kay almirana milagruta atipanmanchu rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chashna chay runa willaptinkuna fariseo awtoridarkunaka sukaman piñakushpa willarkansapa: —Kanka nasishkaykimantapacha sukaman uchasapami kanki. Chashna uchasapa kaykashpaykika ¿imashnatí ñukaykunata yachachiwanayankisapa? Chayta willashpankuna chay runata chay tantanakunankuna wasimanta karkurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chaymanta Jesuska yacharkan chay alliyachishkan runata karkushkankunata. Chayta yachashpa payta tarishpa tapurkan: —¿Kanka kreyinkichu Tata Diospa wambran sielumanta shamushkanta? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chashna Jesus tapuptin chay runaka willarkan: —Maestru, willaway ¿pití chay sielumanta shamudu runaka payta kreyinaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chashna chay runa willaptin Jesuska willarkan: —Ñukami kani. Mana riksiwashpaykipish parlachiwaykanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaypina chay runa Jesusta kuyashpa ñawpakninpi kunkurikushpa willarkan: —Señor, kreyikuni Tata Diosmanta shamushkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chaymanta Jesuska willarkan: —Ñukaka sielumanta kay allpaman shamushkani tukuy kreyiwak runakunata salvanaynipa mana kreyiwak runakunata kastiganaynipa. Uchasapa runakuna iden mana kawakuk runakunashina. Paykuna munaptinkuna yachachishasapa allita Tata Diosta riksinankunapa. Chaymanta suk runakuna kikinlla llullachinakushpa rimansapa Tata Diosta allita riksinankunata. Paykunaka yuyanakunsapa alli kawakuk runakunashina kanankunata. Ñukaka sielumanta shamushkani paykunata yachachinaynipa mana kawakukshina kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chayta uyarishpa suk fariseokuna willarkansapa: —¿Ñukaykunatachu willawaykankisapa iden mana kawakuk runakunashina kanaynikunata? ");
INSERT INTO qvsNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chaypina Jesuska aynirkansapa: —Kankuna llullakushpa rimankichi alli kawakuk runakunashina Tata Diosta allita riksinaykichita. Chayrayku Tata Dios kastigashunkichi. Kankuna mana kawakuk runakunashina mana Tata Diosta riksiyta yachaptikichika payka mana kastigashunkichimanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Chaymanta Jesuska chay runakunata yachachishpa willarkansapa: —Allita uyariwaychi. Tiyan ovejakunapa alli kuydak runa. Amusayaptin payka ovejankunata wertapi yaykuchin tutapi allita kuydanankunapa. Chay wertapa sukllalla punkunta chay alli kuydak runaka yaykun. Wakin runakuna suwakunayashpa maytapish kaptin chay wertata yaykunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chaymanta tukuy tuta suk runa chay werta punkunpi kiparin kuydananpa. Pakariptin punkuta kicharin ovejakuna kuydak runa yaykunanpa. Chaypina chay diyapi kuydak runa tukuy kikinpa ovejankunata sukta sukta shutinkunamanta kayashpa llukshichinsapa. Ovejakunaka kuydakpa ikunta allita riksishpa katinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chashna ovejankunata llukshichishpa ñawpakninkunata rin. Chay ovejakuna kikin kuydakninpa ikunta riksishpa katinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Chikan runapa ikunta mana riksishpa mana katinsapachu. Chay chikan runa kayaptinpish mana riksishpa manchakushpa nitikunsapalla. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chashna Jesus yachachiptinkuna chay chiknik runakunaka mana entiendirkansapachu imapami chashna yachachirkansapa nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chashna chay runakuna mana entiendiptinkuna Jesuska kashkan yachachirkansapa: —Mash allita uyariwaychi. Ñukaka ovejakunapa yaykunan punkunshinami kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ñukamanta ñawpakta aypa llullakuk runakuna shamurkansapa. Paykunaka sukaman pantachichishushpaykichi ovejakunata suwakuk runakunashinami. Ovejaynikuna ñukata allita riksiwashpa mana paykunata kasushkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ñukaka ovejaynikunapa punkunshinami kani. Ñukata katiwaptikichi amachaykichi ama ni pi wakllichishunaykichipa. Tata Diospa kawsananpi yaykuchiykichi. Yachachikunaynikunata kreyishpaykichika ovejakuna alli pastuta tarikshinami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tukuy mana alli yachachikuk runakuna ovejakuna suwak runakunashinami. Suwa runa shamun ovejakunata suwaklla wañuchiklla kulluchiklla. Ñukaka shamushkani allita yanapaknikichi sukaman allita kushikushpa Tata Dioswan kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ñukaka ovejakunata alli kuydak runashinami kani. Alli kuydak runa kashpayni wañusha ovejaynikunata yanapanaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wakin runakuna kullkita chaskinayashpalla ovejakunata kuydansapa. Chay ovejakuna mana kikinkunapa kaptin mana allitachu kuydansapa. Puma shamuptin ovejakunata sakishpa kallpansapa mana doyñunkuna kashpankuna. Chaypina puma tukuy ovejakunata chayta chayta kallpachinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay kullkita munashpalla kuydakuk runakuna mana nima llakichishpa ovejakunata sakinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ñukaka mana paykunashinachu kani. Ñukaka ovejakunata alli kuydakshinami kani. Tatayni Dios sukaman allita riksiwan. Ñukapish sukaman allita payta riksini. Chashnashina ñuka ovejaynikunata riksini. Ovejaynikunapish ñukata riksiwansapa. Kankuna riksiwashpaykichi ovejaynikunashinami kankichi. Ovejaynikunashina kaptikichi wañusha kankunata salvanaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chaymanta chikan kasta runakuna tiyan. Paykunapish ovejaynikunashinami. Paykunapish riksiwashpa kasuwashpa kawsankasapa. Chaypina kankuna paykunawan ovejaynikunashina kankichi. Ñukallami tukuy kankunata kuydashkaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kankunata kuydashpa wañusha. Wañushkaynimanta kashkan kawsamusha. Chayrayku Tatayni sukaman kuyawan. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tatayni Dioska kachamuwashka wañushpa kashkan kawsamunaynipa. Chayrayku ñuka kikini munashpa wañusha. Kikini munashpa kashkan kawsamusha. Mana munaptinika ni pi wañuchiwanmanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chashna Jesus willaptinkuna chay chiknik runakunaka suk layata suk layata ayninakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sukkuna rimarkansapa: —Kay runaka supayadu kashpa dementu likidumi. Chayrayku ama paytaka kreyiypachichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sukkuna Jesusta kreyishpa willanakurkansapa: —Payka mana supayaduchu. Supayadu runa mana chashnachu willawanchimansapa. Supayadu runa mana alliyachinmanchu mana kawakuk runata. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalen llaktapi tamya tiempu tukuy wata suk fiestata ruranisapa. Ñawpa tiempu awiluynikuna Tata Diospa wasin wakllidu kashkanmanta allicharkansapa. Chay allichashkankunata yuyashpa chay fiestata ruranisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chaypina Tata Diospa wasin atun ramadonpi Jesuska puriykarkan. Chay ramadonpa shutin karkan Salomon Yaykunan. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chay ramadonpi puriykaptin chiknik runakuna payta laduncharkansapa. Piñayashpa tapurkansapa: —¿Imapatí mana allita willawankisapa? Shuyaykanaynikuna Tata Diosmanta shamudu runa kashpaykika kunanlla willawaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chashna willaptinkuna Jesuska aynirkansapa: —Ñami kuskatana willashkaykichi. Kankunaka manami kreyiwanayankichichu. Tatayni allita willawaptin aypa almirana milagruta rurashkani. Chaykunata kawashpaykichi yachankichiman ñuka shuyaykanaykichi Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kankunaka mana ñukapa ovejaynikunachu kankichi. Chayrayku mana kreyiwanayankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ovejaynikunami ikuynita uyarishpa katiwansapa. Ñukapish paykunata allita riksinisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ñuka ovejaynikunata kuydaptinikuna makinimanta mana ni pi niman sukta kichuwankachu. Ñuka paykunata kawsachiptini Tata Dioswan mana tukuyniyukta kawsankasapa. Mana kutin wañunkasapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tatayni Dioska tukuy kreyiwak runakunata ñukapa makinipi kuwashka kuydanaynipasapa. Paypish paykunata kuydansapa. Tatayni Dioslla tukuy pimanta ashwan rikchak layata atipan rurayta. Chayrayku mana ni pi paypa makinmanta chay kreyiwak runakunata atipanchu kichuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ñuka Tatayni Dioswan sukllalla kanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chashna Jesus rimaptinna chay chiknik runakunaka kashkan rumikunata apirkansapa Jesusta ruminchanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ruminchanayaptinkuna Jesuska willarkansapa: —Tatayni Dios yanapawaptin ñuka rikchak laya alli ruranakunata rurashkani. ¿Ima alli rurashkayniraykutí wañuchiwanayankichi? ");
INSERT INTO qvsNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chashna Jesus tapuptinkuna chay chiknik runakunaka willarkansapa: —Manami alli rurashkaykiraykuchu wañuchinayaykisapa. Runalla kaykashpayki rimaykanki Tata Dioswan sukllalla kanaykita. Chashna rimashpayki sukaman uchallikuykanki. Chayrayku wañuchinayaykisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Chashna willaptinkuna Jesuska willarkansapa: —Kankunapa killkaduykichipi Tata Dios riman: “Ñuka willashkaykichi dioskunashina kanaykichita.” ");
INSERT INTO qvsNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chashna Tata Dios rimaptin mana ni pi atipanchisapachu rimayta mana alli kananta. Tata Dios suk kamachikuk runakunata willarkansapa paykuna dioskunashina kanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ñuka Tata Diospa wambran kaptini payka akllawashpa kachamuwashka kay allpaman shamunaynipa. Chayta rimaptini ¿imapatí willawaykankichi Tata Diosta piñachinaynita? ");
INSERT INTO qvsNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tatayni ruranan milagrukunata mana ruraptinika alli kanman mana kreyiwanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Chay almirana milagrukunata ruraptini kreyiwanaykichi tiyan. Mana ñukata kreyiwashpaykichipish kreyiychi Tata Dios yanapawaptin chay milagrukunata rurashkaynita. Chashnamanta yachankichi Tatayni Dios ñukawan kawsananta. Ñukapish paywan kawsani. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chashna Jesus rimaptin chay chiknik runakunaka kashkan munarkansapa apiyta. Apinayaptinkunapish Jesus paykunamanta kishpishpa ashurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ashushpana Jordan yakuta chimbashpa Jesuska ñukaykunawan kutirkan maypicha Juan bawtisashkan llaktaman. Chay llaktapi kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Chayman riptinikuna aypa runakuna rirkansapa Jesusta kawak. Paykunaka rimarkansapa: —Juanka manami niman suk almirana milagruta rurashkachu. Mana ruraptinpish tukuy Jesuspa willawashkanchikunata kawaykanchisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chashna rimashpa aypa chay llaktapi kawsak runakuna kreyirkansapa Jesus Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jesuspa tiyarkan suk parlakmasin Lasaro. Payka fatalta unkurkan. Lasaroka kawsarkan Betania llaktapi ishkay paninkunawan tantalla. Suk panin karkan Marta. Suk karkan Mariya. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chay tiempu Mariyaka manara mishkilla asnak wirata Jesuspa chakinpi ichapurkanrachu nima chukchanwan chakichirkanrachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chaypina Lasaro fatal unkudu kaptinna chay ishkay paninkunaka Jesusta kayachishpa willachirkansapa: —Señor, kuyanakukmasikika fataltami unkun. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chashna Lasaropa paninkuna willachiptinkuna Jesuska yacharkan Lasarota wañushkanmanta kawsachimunanta. Chayrayku ñukaykuna disipulunkunata willawarkansapa: —Lasaro wañushpapish mana wañuduchu kiparinka. Payka unkushka tukuy runakuna yachanankunapa Tata Dios rikchak laya atipak kananta. Unkushka tukuy runakuna yachanankunapa ñuka Tata Diospa wambran kashpa rikchak laya atipak kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesuska sukaman Lasarota paninkunata kuyashpankunapish manara rinayarkanrachu paykunata kawak. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasaro unkudu kananta yachashpapish ishkay diyatara chay llaktapi kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaypina ñukaykunata willawarkansapa: —Akuychi kashkan Judea partiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chashna Jesus willawaptinkuna willarkanisapa: —Maestru, kanimpalla Judea partipi kaptiki chiknishuk runakuna ruminchashunayarkansapa wañuchishunayashpa. ¿Imapati chayman kashkan rinayanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Chashna ñukaykuna willaptinikuna Jesuska willawarkansapa: —¿Manachu intika chunka ishkay orata lusichikun? Chashna lusichikuptin atipanchi mana mitkakushpa puriyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tutapi mitkakuypi purinchisapa mana lus tiyaptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tukuy chayta rimashkanwasha Jesuska willawarkansapa: —Chay alli parlakmasinchikuna Lasaroka ñami puñuykanna. Risha rikchachik. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Chashna willawashpankuna Jesuska rimaykarkan Lasaro wañushkanta. Ñukaykuna yuyarkanisapa puñuykananllata rimashkanta. Chayrayku willarkanisapa: —Maestru, puñushpaka alliyankami. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaypina Jesuska kuskata willawarkansapa: —Lasaroka ñami wañushkana. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kushikuni kawsaykaptinra mana rinayashkaynita. Suk alli almirana milagruta rurasha ashwan allita kreyiwanaykichipa. Kunanka akuychina kawak. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chashna Jesus willawaptinkuna disipulumasinikuna Tomas Gemelo willawarkansapa: —Akuychi ñukanchikunapish Jesuswan tantalla wañuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Chaymanta rishpaynikuna Betania llakta mañanpi chayarkanisapa. Chaypina Jesuska uyarirkan chusku diyana Lasaro pampadu kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania llaktamanta Jerusalen llaktaka kimsa kilometrullapi karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jerusalenpi kawsak runakuna Lasaro wañushkanta yachashpankuna aypa rirkansapa Mariyata Martata kushichik ama sukaman llakinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Jesus chayaykananta yachashpa llukshirkan tinkuk. Mariyaka wasillapi kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chaypi Jesusta tinkushpa willarkan: —Maestru, turinika ñami wañushkana. Kaypi kaptikika manami wañunmanchu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Chashna wañudu kaptinpish yachani kunan Tata Dios rikchak laya willanaykita rurananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chaypina Jesuska willarkan: —Turikika kawsamunan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaka willarkan: —Ariya allita yachani kay allpa tukunan diya tukuy wañudu runakuna kawsamunankunata. Chay diya turinipish kawsamunka. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chashna willaptin Jesuska willarkan: —Ñukami kawsachikuk runa kani. Ñukata kreyiwashpa kawsak runakuna wañushpapish kashkan kawsamunankuna tiyan mana kutin wañunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tukuy ñukata kreyiwashpa kawsak runakuna wañushpapish kawsamunkasapa. ¿Kay willashkaynita kreyinkichu? ");
INSERT INTO qvsNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chashna willaptin Martaka willarkan: —Ariya maestru, ñukaka tukuy shunku kreyini kanna shuyaykanaynikuna Tata Diosmanta shamudu runa kanaykita. Tata Diospa wambran kashpayki kay allpaman shamushkanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chayta willashkanwasha Martaka Jesusta sakishpa ñañan Mariyata rirkan kayak. Wasinpi chayashpa upallalla willarkan: —Maestrunchika chayrak chayamushka. Munan rinaykipa kawak. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chashna willaptin Mariyaka utkakushpa rirkan Jesusta tarik. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuska manara Betania llaktapika yaykurkanrachu. Maypicha Martawan parlashkanpi kiparirkan Mariyata shuyashpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chaypina Mariya turbakushpa wasinmanta llukshiptin chay kushichik runakuna kawarkansapa. Paykunaka katirkansapa yuyashpa Mariya riykananta turinta pampashkankunapi wakakuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya Jesuspi chayashpana ñawpakninpi kunkurikushpa willarkan: —Maestru, kaypi kaptikika turinika manami wañunmanchu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chashna willashpana Mariyaka sukaman wakakurkan. Chay katik runakunapish wakakurkansapa. Tukuy paykunata kawashpa Jesuspish sukaman turbakushpa llakirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chaypina tapurkansapa: —¿Maypiti Lasarota pampashkankichi? Paykunaka willarkansapa: —Mash akuychi kawak. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chaypina Jesuspish wakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chashna wakakuptin kawashpa chay runakuna almirashpa willanakurkansapa: —Mash kawaychi. Sukaman Lasarota kuyashka. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sukkuna rimarkansapa: —Kay runaka mana kawakuk runata alliyachirkan. Lasaro manarapish wañuptinra ¿imapatí mana alliyachishka? ");
INSERT INTO qvsNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chaypina Jesus kashkan sukaman llakishpa Lasarota pampashkankunapi chayarkan. Suk machay ukupi pampadu karkan. Chay machaypa punkun atun rumiwan wichkadu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus chaypi chayashpa katik runakunata willarkansapa: —Chay rumita ashuchiychi. Chashna Jesus willaptinkuna wañudupa panin Martaka payta willarkan: —Maestru, ñami chusku diyana turini wañushkan. Ñami sukamanna asnan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chashna willaptinna Jesuska willarkan: —¿Manachu willashkaykina tukuy shunku kreyiwashpaykika Tata Dios rikchak laya atipak kananta kawanaykita? ");
INSERT INTO qvsNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chaypina chay rumita ashuchiptinkuna Jesuska altuta chapashpa Tatanta willarkan: —Tatayni, kanta roygaptini uyariwashkanki. Chayrayku sukaman agradesiyki. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ñukaka allita yachani parlachiptini tukuy tiempu uyariwanaykita. Chayrayku kunanka roygayki yanapawanaykipa kay runakuna kreyiwanankunapa kachamuwashkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chaypina Tatanwan parlashkanwasha Jesuska sinchita kayarkan: —¡Lasaro, chay machay ukumanta llukshimuy! ");
INSERT INTO qvsNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chashna Jesus willaptinna Lasaroka kawsamushpa chay machay ukumanta llukshimurkan. Kunkanmanta chakinkaman llachapawan alli wankudu karkan. Uyanpish llachapawan arkadu karkan. Chashna llukshimuptin Jesuska chay runakunata willarkansapa: —Chay wankushkankuna llachapata surkupuychi wasinman rinanpa. Chashna Jesus willaptinkuna wankushkan llachapata surkupurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chaypina aypa Mariyawan rik runakuna Jesus Lasarota kawsachimushkanta kawashpana kreyirkansapa Jesus Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Chaypina suk kawak runakuna rirkansapa fariseo awtoridarkunata willak Jesus Lasarota wañushkanmanta kawsachimushkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaypina fariseokunawan saserdotekunapa ashwan sinchi awtoridarninkuna tantanakushpa willanakurkansapa: —¿Imatatí rurashunchisapa? Chay runaka aypa almirana milagrukunata ruraykan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sukkunaka rimarkansapa: —Ichará ashwan almirana milagrukunata ruraptin tukuy runakuna paytana kreyishpa katinkasapa. Chashna tukuy runakuna payta katiptinkuna romano kamachiwakninchikuna piñakushpa shamunmansapa Tata Diospa wasinta urmachik. Chaymanta ñukanchikunawan makanakushpa kulluchiwanchimansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chay tantanakudu awtoridarkunapi tiyarkan saserdotekunapa ashwan sinchi kamachikuk runa. Chay wata chay ashwan sinchi kamachikuk saserdote karkan Kayfas. Payna tukuy chay tantanakudu awtoridarkunata willarkansapa: —Kankunaka manami nimata yachankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Manachu yachankichi? Ashwan alli kanman suk runalla wañunanpa ama tukuy israel runakuna wañunanchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chay wata Kayfas tukuy saserdotekunapa sinchi kamachikukninkuna kaptin Tata Dioska payta yachachiykarkan. Chayrayku mana kikinpa yuyayninmantachu chayta rimarkan. Tata Dios yachachiptin rimarkan Jesus wañunanta ama judiyu runakuna wañunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tata Dios payta yachachirkan manami judiyu runakunallapachu Jesus wañunanta. Jesuska wañurkan tukuy llaktakunamanta Tata Diospa wambrankunatapish tantanachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chay judiyu awtoridarkuna parlashkankuna diyamantapacha allita yuyaykurkansapa Jesusta wañuchinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesuska chayta yachashpa manana yachachikuypinachu purirkan. Judea partimanta ñukaykunawan tantalla llukshirkan. Chaypina Efrayin llaktapi chayarkanisapa. Chay llakta ladunpi tiyarkan manllayba chunlla chakidu allpa. Chay llaktapi Jesuska ñukaykunawan kiparirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chay tiempu tipillana illarkan judiyu runakuna Paskua fiestata rurashpa Tata Diosta kuyanaynikunapa. Manarapish chay fiesta kallariptin Jerusalen llaktapi aypa runakuna chayamuykarkansapa. Paykunaka Tata Diospi chuya chuya mana uchayuk rikurinankunapa armakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chashna Jerusalen llaktapi paykuna chayashpankuna Jesusta maskarkansapa. Tata Diospa wasinman rishpa sukwan sukwan tapunakurkansapa: —¿Imatatí yuyankichi? ¿Kay Paskua fiestaman shamunkachu? ");
INSERT INTO qvsNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo runakunawan saserdotekunapa awtoridarninkuna Jesusta apinayarkansapa wañuchinankunapa. Chayrayku Paskua fiesta pasak runakunata willarkansapa: —Yachashpaykichi maypimi Jesus kananta willawaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chaymanta sokta diya Paskua fiesta illaptin Betania llaktaman Jesuska ñukaykunawan kashkan rirkan. Chay llaktapi Jesus kawsachimushkan Lasaroka kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chaypina Lasaro paninkunawan kushikushpa suk almorsuta rurarkan aypa invitadukuna Jesuswan tantalla mikunankunapa. Chaypina Lasaropish mesapi Jesuswan tantalla mikuykarkan. Panin Marta sirvikuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chaypina mikuykaptinikunana Mariyaka aypa chaniyuk mishkilla asnak wirata apamurkan. Chayta Jesuspa chakinpi icharkan. Chaymanta chukchanwan chakichipurkan. Chashna chay mishkilla asnak wirata ichaptin tukuy chay wasi uku mishkilla asnarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chayta kawashpa chay Jesusta rantikuk disipulun Judas Iskariote piñakushpa mikukmasinkunata willarkansapa: ");
INSERT INTO qvsNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Imapatí chay mishkilla wirata usuchiykan? Chayta aypa kullkipi rantikunman karkan mana nimayuk runakunata yanapananpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judaska chayta rimarkan chay kullkita kikinllapa munashpa. Mana yanapanayarkanchu mana nimayuk runakunata. Payka disipulumasinkunapa kullkinkuna wakaychak kashpa suwapuksapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chaypina Jesuska Judasta willarkan: —Ama Mariyata michaychu. Payka pampawanankunata yuyashpa chay mishkilla asnak wirata wakaychashka. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mana ni maypi mana nimayuk runakuna illanchu yanapanaykichipa. Ñuka mana unaytanachu kankunawan kawsasha. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesus Betaniapi kananta yachashpankuna aypa runakuna rirkansapa payta kawak. Chay kawsachimushkan Lasarotapish rirkansapa kawak. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Wañushkanmanta kawsamudu Lasarota kawashpankuna aypa runakuna kreyirkansapa Jesus Tata Diosmanta shamudu runa kananta. Manana saserdotekunapa awtoridarninkunataka katinayarkansapanachu. Chayrayku paykunaka Lasarotapish yuyarkansapa wañuchiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chaymanta aypa runakuna rirkansapa Jerusalen llaktaman Paskua fiestata pasanankunapa. Chayamushkankuna kayantin paykunaka yacharkansapa Jesuspish shamuykananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sukaman kushikushpa polponta pankakunata tipishpankuna rirkansapa Jesusta tinkuk. Kushikuyninkunawan sinchita willarkansapa: —¡Akuychi alabaypachi Tata Diosmanta shamudu runataka! Payka shamuykanna israel runakunata kamachiwananchikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Chay runakuna manara sukaman kushikushpa tinkuptinkunara Jesuska suk burruta tarishpa montarkan. Chashna montashpa Jerusalenpi yaykurkan. Ñawpa killkadunpi Tata Dios rimarkan: “Ama manchakuychichu, Sionpi kawsak runakuna. Mash kawaychi. Suk burru sawanpi kankunapa sinchi kamachishuknikichi runa ñami shamuykanna.” Ñawpa tiempu Tata Dios rimashkanshina Jesuska Jerusalenpi yaykurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chay tiempu ñukaykunaka manara entiendirkanisaparachu imapami chashna Jesuska Jerusalenpi yaykurkan nishpa. Jesus wañushkanmanta kawsamuptinra yuyarkanisapa Tata Diospa ñawpa killkadun rimananshina Jesus rurashkanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aypa runakuna kawarkansapa Jesus Lasarota wañushkanmanta kawsachimushkanta. Paykunaka tukuy pita chayta parlachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chay milagruta rurashkanta yachashpa aypa runakuna rirkansapa Jesusta tinkuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tinkuk riptinkunana fariseo awtoridarkuna sukaman piñakushpa willanakurkansapa: —Amana kawapayaypachinachu. ¡Mash kawaychi! Chay runakuna mananami ñukanchikunata kasuwanchisapanachu. Tukuyna chay Jesusta katinsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chay fiesta ukun Jerusalenman judiyu runakunawan tantalla Gresia partimanta runakunapish shamurkansapa Tata Diosta kuyanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chay runakunaka Jesuspa disipulun Felipita laduncharkansapa. Felipika Galilea partipi Betsaida llaktamanta karkan. Chay Gresiamanta runakunaka Felipitaka willarkansapa: —Señor, pushawaysapa Jesusman. Ñukaykunapish paywan parlanayanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chashna chay runakuna willaptinkuna Felipika rirkan Andresta willak. Chaypina paykuna rirkansapa Jesusta willak. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chashna willaptinkuna Jesuska tukuy chay runakunata willarkansapa: —Ñami wañunayni diyaka chayamunna. Wañuptini Tata Dios kawsachimuwanka tukuy runakuna yachanankunapa ñuka paypa wambran kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mash allita uyariwaychi. Suk trigu murunta tarpuptinchi allpapi pampadu kiparin. Chaypina wiñaptin aychan allpa ukupi usun. Chay muru mana allpapi pampadu kashpaka suk murulla kiparin. Manami wiñanchu. Mana wiñashpa mana wayuchakunchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kankunapish kikikichipa munanaykichillata rurashpa chay mana tarpudu murushinami kankichi. Chashna kawsashpaykichika wañunaykichi tiyan. Chaymanta mana munanaykichita rurashpa tarpudu murukunashinami kankichi. Chashna kawsashpaykichika mana tukuyniyukta kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kankuna ñukapa munanaynita ruranayashpaykichika katiwaychi. Chashna katiwashpa kawsashpaykichi maypipish kaptini kankunapish chaypimi kankichi. Munanaynita rurashpa kawsaptikichi Tatayni Dioska rimanka alli rurak kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chashna rimashpa Jesuska yachachikuyllapi katirkan: —Kunanka sukaman llakishpa turbakuni. ¿Imatati Tataynita willasha? ¿Willashachu: “Tatayni, kishpichichiway ama sukaman sufrinaynipa?” Manami chashnachu willasha. Kay allpaman shamushkani wañunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A, Tatayni, wañuptini tukuy runakunata yachachiysapa tukuy laya yachak kanaykita. Chashna Jesus Tatanta willaptin ñukaykuna uyariptinikuna sielumanta kikin Tata Dios wambran Jesusta willamurkan: —Runakunata ñami yachachishkanisapana allima kanaynita. Kashkan yachachishasapa allima kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chashna sielumanta Tata Dios wambran Jesusta willamuptin aypa runakuna uyarishpa rimarkansapa troynashkanta. Sukkuna rimarkansapa: —Tata Diospa angelninmi paytaka parlachimushka. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chashna rimaptinkuna Jesuska willarkansapa: —Sielumanta Tata Dioska ñukata parlachimuwashka kankuna yachanaykichipa paypa wambran kanaynita. Mana ñukaraykuchu parlachimuwashka. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ñami diyaka chayamushkana Tata Dios tukuy chiknik runakunata willanankunapa kastiganankunata. Chaymanta Tata Dioska kay allpapi supaykunapa kamachikukninta karkunka amana kamachikunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ñukata kruspi alsawaptinkuna tukuy kay allpapi kawsak runakunata yachachishasapa ñukata kreyiwashpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chashna rimashpa Jesuska yachachirkansapa suk kruspi chakataptinkuna wañunanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chaypina chay runakunaka willarkansapa: —Tata Diospa rimananta leyishpa yachanisapa Tata Diosmanta shamudu runa mana kutin wañunanta mana tukuyniyukta kawsananta. Chayrayku ¿imapatí willawankisapa sielumanta shamudu runa kashpayki kruspi chakatadu wañunaykita? Chakatadu wañushpaykika manami Tata Diosmanta shamudu runachu kanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chaypina Jesuska willarkansapa: —Ñuka lus likidu kashpayni rikchak layata yachachiykaykichi. Kay diyakunallatana yachachiykaykichi. Chayrayku amarapish sakiptinira ñukata allita katiwaychi ama tutapishina purinaykichipa. Tutapishina purishpaykichi mana yachankichichu maytami rinkichi nishpa. Uchaykichillapi kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ñukaka lus likidumi kani. Kankunawan kaykaptinira ñukata kreyiwaychi ñukashina allita rurashpa kawsanaykichipa. Chayta rimashkanwasha Jesuska chay runakunamanta llukshishpa pakakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus aypa almirana milagrukunata ruraptin kawashpapish chay runakunaka mana kreyinayarkansapachu Tata Diosmanta shamudu runa kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ñawpa yachachikuk Isaiyas killkarkan chay runakuna Tata Diospa rimananta mana kreyinankunata. Isaiyaska rimarkan: “A, Tata Dios, rimanaykita sukaman yachachikuptinikunapish kay runakuna mana kreyinayansapachu. Sukaman almirana milagrukunata ruraptiki kawashpankunapish mana kreyinayansapachu.” ");
INSERT INTO qvsNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chay chiknik runakuna kikinkuna llullachinakushpankuna mana atiparkansapachu Jesusta kreyiyta. Kayta Isaiyaska killkarkan: ");
INSERT INTO qvsNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tata Diosmi mana kreyik runakunapa yuyayninkunata sinchiyachipurkansapa ama entiendinankunapa. Paykunata rurashka mana kawakuktashina ama payta riksinankunapa. Mana kreyinayaptinkuna Tata Dios mana munanchu payman kutimunankunapa. Nima munanchu paykunata alliyachiysapata.” ");
INSERT INTO qvsNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aypa watakuna illaptinra Jesus shamunanpa Isaiyaska tukuy chayta rimarkan. Payka yacharkan kay allpaman Jesus shamushpa wañushkanmanta kawsamunanta. Chayta yachashpa Isaiyaska killkarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aypa runakuna Jesusta mana kreyiptinkunapish sukkuna kreyirkansapa. Suk awtoridarkunapish kreyirkansapa. Paykunaka Jesusta kreyishkankunata mana ni pita parlachirkansapachu fariseokunata manchashpankuna. Mana munarkansapachu tantanakunankuna wasimanta karkunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chashna fariseokunata manchashpankuna Tata Dios alabanankunamanta ashwanta munarkansapa runamasinkunalla alabanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chaymanta sinchita rimakushpa Jesuska willarkansapa: —Kankuna ñukata kreyiwashpa kawsaptikichika kachamuwashkan Tataynitapish kreyishpa kawsaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ñukata kawawashpaykichi kachamuwashkan Tataynitapish kawaykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ñuka lus likidu kashpayni kay allpaman shamushkani ñukata kreyiwashpa kawsashpaykichi ama tutapishina uchaykichillapi kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Rimashkaynita uyarishpaykichi mana kasukuptikichi mana ñukachu kastigashkaykichi. Kay allpaman shamushkani runakunata perdonashpa salvanaynipasapa. Mana shamushkanichu kastigaknikichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ñukata mana munawaptikichika nima yachachikunaynita kasuptikichika kay allpa kullunan diya Tata Dios rimashkaynita yuyachishushpaykichi kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kachamuwak Tatayni Dioska willawashka imatami yachachikusha nishpa. Mana kikinipa yuyayninimantachu yachachikuykani. ");
INSERT INTO qvsNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Allita yachani kankuna Tata Dios willashushkaykichita kasushpaykichika rinaykichita paywan tantalla mana tukuyniyukta kawsak. Chayrayku Tatayni willawashkanta allita yachachiykaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Chaymanta Paskua fiesta suk diyallana illaptin Jesuska yacharkan wañunan diyana chayamushkanta. Yacharkan kay allpamanta sieluman kutinanta Tatanwan tantallana kawsak. Jesuska tukuy allpapi katikninkunata sukaman kuyarkansapa. Wañunan diyakaman kuyarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chay diya amusayaptin Jesuska ñukaykunawan mikuykarkan. Satanas ñami Jesuspa disipulun Judas Iskarioteta yuyachirkanna Jesusta rantikunanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesuska allita yacharkan kay allpaman Tatan Dios kachamushkanta tukuy layapi kamachikunanpa. Yacharkan Tata Diosmanta shamushkanta kashkan payman kutinanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaypina Jesus ñukaykunawan tantalla mikuykashpa atarirkan. Kapanta surkukushpa sinturanpi suk atun towallata watarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chaymanta atun kallanapi yakuta churashpa kallarirkan ñukaykunapa chakinikunata mayllayta. Sinturanpi watadu towallawan chakinikunata chakichiparkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaypina Simon Pedru mana munashpa chakinta mayllapunanpa willarkan: —Maestru ¿ñukapa chakinitachu mayllanayanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chashna willaptinna Jesuska aynirkan: —Kunanka manara yachankirachu imapami chakikita mayllaykani nishpa. Suk ratukaman allita yachanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chaypina Pedruka willarkan: —Manami nima layapi munanichu chakinita mayllanaykipa. Chashna Pedru willaptinna Jesuska aynirkan: —Mana chakikita mayllanaynipa munashpaykika mana ñukapa disipuluynichu kanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chaypina Simon Pedru willarkan: —Chashna kaptinka ama chakinillata mayllaychu. Makinitapish umaynitapish mayllapay. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chaypina Jesuska aynirkan: —Chayrak armakudu runa chuya chuya kaptin chakinllatana mayllanan tiyan. Yaka tukuy kankuna chuya chuya armakudushina kankichi. Kankunamanta sukllalla manara armakudushinarachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chashna Jesus willawashpankuna allita yacharkan maykan disipulunmi rantikunka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chaymanta ñukaykunapa chakinikunata mayllashkanwasha Jesuska kapanta kashkan churakurkan. Chaymanta tiyarishpa willawarkansapa: —¿Yachankichichu imapami chakikichita mayllashkani? ");
INSERT INTO qvsNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kankunaka “Maestru” niwankichi. Kankunata kamachiptini “Señor” niwankichi. Ñukaka deverasmi Maestruykichi Señornikichi kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ñuka Maestruykichi Señornikichi kashpayni chakikichita mayllashkani. Ñukashina kankunapish sukpa sukpa chakikichita mayllaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ñukaka kankunata yanapashkaynishina kankunapish sukwan sukwan yanapanakuychi maylladushina kanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Allita willaykichi. Suk wiwachu wiwaknin runata kasunan tiyan. Suk kachadu runa kamachikukninta kasunan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kay yachachikushkaynita entiendishpaykichi chayta allita rurashpa kawsashpaykichika sukaman kushikuypuru kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mana tukuy kankunapachu rimaykani. Ñukaka kankunata akllashpayni allita yachani kankunamanta tiyananta suk rantikuwak runa. Tata Diospa killkadu rimananpi willawanchi: “Ñukawan tantalla mikuk runa chikniwak runa tukushka.” Tata Dios rimashkanshina chay chikniwak runa rantikuwanka. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chayta ñami willashkaykichina chay runa rantikuwaptin yachanaykichipa ñuka Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Allita willaykichi. Ñuka kankunata kachaykichi rimanaynita yachachikunaykichipa. Chashna kachaptini tukuy kankunata chaskishuknikichi runakuna ñukatapish chaskiwaykansapa. Ñukata chaskiwak runakuna kachamuwashkan Tatayni Diostapish chaskiykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chayta rimashkanwasha Jesuska tukuy shunku sukaman llakishpa ñukaykunata willawarkansapa: —Kunan allita willaykichi. Kankunamanta suk disipuluynika chikniwak runakunapi rantikuwanka. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chashna Jesus willawaptinkuna ñukaykuna manchakushpa sukwan sukwan chapanakurkanisapa. Mana yacharkanisapachu maykan ñukaykunapami rimaykan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Chaypina ñuka Juan Jesus kuyashkan disipulun kashpayni ladunpi mikuykarkani. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pedruka señaspi willawarkan Jesusta tapunaynipa pipami rimashka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chaypina Jesusta ashwanta serkashpa tapurkani: —Maestru ¿ñukaykunamanta maykantí rantikushunka? ");
INSERT INTO qvsNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chashna tapuptini Jesuska willawarkan: —Ñuka panta ñuyuchishpa paytaka chaskichisha. Chashna rimashpa chay mikukuna kallanapi Jesuska suk panta ñuyuchishpa Simonpa wambran Judas Iskarioteta kurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas chay panta chaskishkan ratu Satanas paypi yaykurkan. Chaypina Jesuska willarkan: —Chay yuyashkaykita utkakushpana ruray. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Chashna willaptin mana ni maykan ñukaykuna yacharkanisapachu imapami chashnaka Judasta willaykan nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judaska tukuy ñukaykunapa kullkinikunata wakaychak karkan. Chayrayku yuyarkanisapa ichará Jesus willashka fiestapa mikunaynikunata rantinanpa. Sukkuna yuyarkanisapa ichará Jesus willashka mana nimayuk runakunata suk imata kunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas chay panta mikushkanwasha llukshirkan. Tutana karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas llukshishkanwasha Jesuska ñukaykunata willawarkansapa: —Wañunayni ora ñami chayamushkana. Ñuka Tata Diospa wambran kaykashpayni wañusha. Wañuptini tukuy runakuna yachankasapa Tata Dios sukaman allima kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wañuptini Tata Dioska utkana suk allima almirana milagruta ruranka. Chay milagruta ruraptin tukuy runakuna yachankasapa ñuka iden payshina sukaman allima kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Munanayni wambraynikuna, ñukaka mananami unaytanachu kankunawan kawsasha. Kankunata sakiptini sukaman maskawankichi. Chay chikniwak runakunata willashkaynitashina kankunatapish willaykichi: Manami chay rinayniman atipankichichu riyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kunanka willaykichi kay mushuk kamachinaynita: Sukwan sukwan kuyanakushpa kawsanaykichi tiyan. Ñuka kankunata kuyanaynishina kankunapish sukwan sukwan kuyanakushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tukuy runakuna kuyanakushpa kawsanaykichita kawashpa yachankasapa ñukapa disipuluynikuna kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chashna Jesus rimaptin Simon Pedruka tapurkan: —Maestru ¿maymanti rinki? Jesuska aynirkan: —Kunan mana atipankichu katiwayta. Suknin diya katiwanki. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chaypina Pedruka Jesusta willarkan: —¿Imapati kunanlla mana katiykiman? Kan wañuptiki ñukapish munani wañuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chashna willaptinna Jesuska willarkan: —¿Deveraschu ñukawan tantalla wañunkiman? Mash allita uyariway. Manarapish gallo kantaptin kimsa kuti rimanki mana riksiwanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Chaymanta Jesus rinanta rimaptin tukuy ñukaykuna sukaman llakirkanisapa. Llakiptinikuna payka willawarkansapa: —Ama llakiychichu. Tata Diosta kreyishpaykichi ñukatapish kreyiwaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tatayni Diospa kawsanan sielupi aypa allima kawsanakuna tiyan. Allita willashkaykichi chayman rinaynita wasikichita rurak. Mana Tata Diospa aypa kawsanankuna tiyaptin mana willaykichimanchu karkan rinaynita wasikichita rurak. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Wasikichita rurashpana kashkan shamusha pushaknikichi chaypi ñukawan tantalla kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kunanka ñami allitana yachankichi maymanmi rini nishpa. Ñami yachankichina imashnami chay kawsanaynipi chayankichi nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chashna willawaptinkuna Tomas tapurkan: —Maestru, ñukaykunaka mana yachanisapachu maymanmi rinki nishpa. ¿Imashnati kawsanaykiman chayaymansapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chashna Tomas tapuptin Jesuska aynirkan: —Ñukalla suk ñanshina Tata Diosman pushaykichi. Mana llullakushpa allita yachachiykichi. Ñukami kawsachiykichi mana tukuyniyukta Tata Dioswan kawsanaykichipa. Ñukata mana kreyiwashpa kawsaptikichika mana Tata Diospa kawsananpika chayankichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kankuna ñukata allita riksiwashpaykichika Tatayni Diostapish riksinkichi. Kunanmantapacha payta ñami riksinkichina kawashkaykichirayku. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chaypina Felipika Jesusta willarkan: —Maestru, Tataykita kawachiwaysapa. Payta kawashpaynikuna kushikushasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chaypina Jesuska willarkan: —Felipi ¿manarachu entiendiwankira? Unaytana kankunawan tantalla kawsaykani. ¿Manarachu allitara riksiwashkankichi? Ñukata kawawashpaykichi Tatayni Diostapish kawaykankichina. ¿Imapatí willawanki Tataynita kawachinaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manachu kreyinki ñuka Tatayniwan tantalla kawsanaynita? ¿Manachu kreyinki paypish ñukawan kawsananta? Chashna Tatayni Dios ñukawan tantalla kawsaptin manami kikinipa yuyayninimantachu yachachiykaykichi. Tatayni Dios ñukawan tantalla kawsashpa yanapawan munananta ruranaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Allita kreyiwaychi. Ñukami Tatayni Dioswan kawsani. Paypish ñukawan tantalla kawsan. Yachachishkaynita mana kreyinayashpaykichika kreyiwaychi almirana milagrukunata ruraptini. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Allita willaykichi. Kankuna kreyiwashpa kawsashpaykichi iden ñuka rurashkaynikunatashina atipankichi rurayta. Ñuka Tatayniman rishkaynirayku ñukamanta ashwan almirana laya ruranakunata atipankichi rurayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ñukapa munanaynita rurashpa kawsashpaykichi imatapish kaptin mañawaptikichi ñukami rurasha. Tukuy layapi kankunata yanapaptini tukuy runakuna Tatayni Diosta sukaman kuyashpa alabankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kankuna ñukata kasuwashpa kawsashpaykichi imatapish kaptin mañawaptikichi yanapashkaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesuska ñukaykunata yachachiwaysapallapi katirkan: —Kankuna tukuy shunku kuyawashpaykichika tukuy willashkaynikunata allita rurashpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chashna allita rurashpa kawsaptikichi Tataynita roygasha Espiritunta kachamunanpa ñukashina yanapashunaykichipa. Paymi tukuy tiempu kankunawan tantalla kawsanka. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tata Diospa Espiritunka mana llullakunchu. Chayrayku mana kreyiwak runakuna llulla kashpankuna mana atipansapachu Tata Diospa Espiritunta chaskiyta. Mana payta kawansapachu nima riksinsapachu. Kankunaka ñami riksinkichina kankunapi kawsaptin. Payka tukuy tiempu kankunawan kawsanka. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mash allita uyariwaychi. Tatayni kawsananman rishpayni manami wakchakunatashinachu sakishkaykichi. Kashkan kutimusha kankunawan tantalla kawsanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mana unaynachu illan wañunaynipa. Wañuptini mana kreyiwak runakuna manana kawawankasapanachu. Kankunaka kawawankichi kankunawan tantalla kawsaptini. Wañushkaynimanta kawsamushkaynirayku kankunapish kawsamunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ñuka wañushkaynimanta kawsamuptini kankunaka allitana yachankichi Tatayni Dios ñukawan tantalla kawsananta. Ñukapish kankunawan tantalla kawsani. Kankunapish ñukawan tantalla kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kankuna kamachishkaynita chaskishpa allita kasushpa kawsashpaykichi runakunata kawachinkichi ñukata kuyawanaykichita. Chashna kuyawaptikichi Tataynipish kankunata kuyashunkichi. Ñukapish kuyashkaykichi. Kankunata kuyashpayni yanapashkaykichi ashwan allita riksiwanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chaypina disipulun Judas mana Iskariotechu Jesusta tapurkan: —Maestru ¿imapati ñukaykunallata yanapawankisapa ashwan allita riksinaynikunapa? ¿Imapati mana tukuy runakunapi riksichinakunki? ");
INSERT INTO qvsNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chashna Judas tapuptin Jesuska willarkan: —Ñukata kuyawashpa yachachishkaynita allita kasuptikichi Tataynika kuyashunkichi. Ñukapish Tatayniwan pakta shamusha kankunawan tantalla kawsanaynikunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tatayni Dioska kachamuwashka yachachikunaynipa. Manami kikinipa yuyayninimantachu yachachiykaykichi. Chayrayku mana kuyawak runakuna mana kasuwansapachu. Mana kasuwaptinkuna paykunata mana yanapanisapachu riksiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kankunawan kashpaynira tukuy layata ñami yachachishkaykichina. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Manana kankunawan kaptini Tatayni Dioska Espiritunta kachamunka ñukashina yanapashunaykichipa. Paynami tukuy yachachikushkaynita allita entiendichishunkichi. Tukuy willashkaynita yuyachishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mana kreyiwak runakuna mana atipansapachu yanapashuynikichita ama turbakushpa kawsanaykichipa. Ñukami yanapashkaykichi kushikuypuru mana turbakushpa kawsanaykichipa. Chayrayku ama llakiychichu nima manchakuychichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ñami allitana willashkaykichi Tatayniman rinaynita. Willashkaykichina rishkayniwasha kashkan shamunaynita kankunawan tantalla kawsanaynipa. Tataynika kamachiwakninimi. Chayrayku deverasta kuyawashpaykichika Tatayniman rinaynita yachashpa kushikunkichiman. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Manara rishpaynira willashkaykichi kashkan kutimunaynita chashna riptini kreyinaykichipa kutimunaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mananami unaytanachu parlachiykichi. Kay allpapi kamachikuk supaymi shamunka. Payka ladunchawashpapish mana nimapi kamachiwanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ñuka Tataynita kasushpa wañunayni tiyan. Chashna wañuptini tukuy runakuna yachankasapa Tataynita allita kuyashpa tukuy layapi kasushkaynita. Tukuy chayta rimashkanwasha Jesuska ñukaykunata willawarkansapa: —¡Atariychina! Kaymanta akuychina. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Manara chay wasimanta llukshiptinikunara Jesuska yachachiwaysapallapi katirkan: —Ñukami kani uva tronkonshina. Tataynika chay uva kuydakshinami. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tukuy ñukata kreyiwak runakuna iden chay uva tronkonpa ramankunashina kankichi. Suk ramayni mana wayuchakuptin Tataynika tipin. Suk rama allita wayuchakuptin raman puntankunallata tipin mushukta pankayashpa ashwanta wayuchakunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Chay uva ramankunapa puntan tipidukunashina kankuna rimanaynita kreyishkaykichirayku uchaykichimanta pichadu kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tukuy shunku kreyiwashpa ñukawan tantalla kawsaychi. Ñukapish tukuy tiempu kankunawan tantalla kawsasha. Suk uva raman kikinmanta mana atipanchu wayuchakuyta mana tronkonpi apikudu kashpa. Tipidu kashpa chakin. Chashnami kankunapish mana ñukawan tantalla kawsashpaykichika manami atipankichichu allita rurashpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ñukami uva tronkonshina kani. Kankunaka uva ramankunashinami kankichi. Ramakuna tronkonpi apikudu kashpa allita wayuchakunsapa. Kankuna ñukawan allita tantanakushpa kawsashpaykichi atipankichi allita rurashpa kawsayta. Ñukapish kankunawan tantanakushpa kawsasha. Mana ñukawan tantanakushpa kawsashpaykichika mana atipankichichu allita rurashpa kawsayta. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Suk uva tronkonta kuydak runa mana wayuchakuk ramakunata tipishpa tantachishpa rupachin. Chashnallami kankuna ñukamanta ashuptikichi Tata Dios chay ramata rupachikshina kastigashunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Chayrayku ñukawan tantanakushpalla kawsaychi. Tukuy yachachishkaynitapish allita kasushpa kawsaychi. Yachachishkaynita kasuptikichi ñukami tukuy mañawanaykichita kushkaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kankuna allita rurashpa kawsashpaykichika deverasmi disipuluynikuna kankichi. Allita rurashpa kawsaptikichika runakuna Tataynita kuyashpa alabankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Imashnacha Tatayni ñukata kuyawan chashnami ñukapish kuyaykichi. Kankunata sukaman kuyashkaynirayku tukuy tiempu allita kasuwashpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tukuy Tatayni kamachiwashkanta allita kasushpa kawsaptini payka sukaman kuyawan. Ñukapa kamachikunaynita allita kasuptikichi kankunatapish sukaman kuyaykichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tukuy kayta willashkaykichi ñukashina kushikunaykichipa. Kankuna kasuwashpa kawsashpaykichika kushikuypurullami kawsankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kashna kamachiykichi: Ñuka kankunata kuyanaynishina kankunapish sukwan sukwan kuyanakushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Suk kuyakuk runa kuyanakukmasinta sukaman kuyashpa wañuymanta salvanman kikin wañushpa. Ñukaka tukuy kuyanakukmasinikunapa wañusha. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kankuna tukuy kamachikushkaynita kasushpa kawsashpaykichika ñukapa kuyanakukmasinikunami kankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Suk sirvikuk runa patronpa yuyayninta mana yachanchu. Chayrayku kunanmantapacha manana willaykichinachu sirviwaknini kanaykichita. Tukuy Tatayni willawashkanta yachachishkaykichi. Chayrayku kunanmantapacha willaykichi kuyanakukmasinikuna kanaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kankunaka mana akllawashkankichichu. Ñukami kankunataka akllashkaykichi kuyanakukmasinikuna kanaykichipa. Akllashkaykichi tukuy runakunata rimanaynita yachachinaykichipa paykunapish mana tukuyniyukta kawsanankunapa. Chashna allita kuyawashpa kasuwashpa kawsaptikichika imatapish kaptin shutinipi Tataynita mañaptikichi paymi kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Allita willaykichi: Sukwan sukwan allita kuyanakushpa kawsaychi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Chaymanta Jesuska ñukaykunata willawarkansapa: —Ñukata chikniwak runakuna kankunatapish chiknishunkichi. Chiknishuptikichi yachankichi ñukata ñawpakta chikniwashkankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ñukaka akllashkaykichi amana chay mana alli rurak runakunashina kawsanaykichipa. Chayrayku allita ruraptikichi chiknishunkichi. Kankuna paykunashina mana allita ruraptikichika kuyashunkichiman paykunapuralla kuyanakukshina. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chay willashkaynita yuyaychi. Suk wiwachu wiwaknin runata allita kasunan tiyan. Kankuna wiwachuynikunashina kasuwaptikichi sufrichiwak runakuna kankunatapish sufrichishunkichi. Yachachikunaynita mana kasushkasapachu. Chayrayku kankunatapish mana kasushunkichichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chay chikniwak runakuna kachamuwak Tataynita mana riksishpankuna ñukarayku kankunatapish chiknishunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Chay chikniwak runakunata mana yachachik shamushka kaptinika mana uchayukchu kanmansapa karkan. Allita paykunata yachachiptinipish mana kreyiwanayarkansapachu. Chayrayku Tata Dioska kastigankasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ñukata chikniwashpankuna Tataynitapish chikniykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Paykunaka kawarkansapa almirana laya milagrukunata ruraptini. Tukuy chayta kawashpankunapish chikniwansapalla. Tatayni Diostapish chikninsapa. Mana almirana milagrukunata ruraptini kawashpankunaka mana uchayukchu kanmansapa karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tata Diospa ñawpa killkadunpi riman: “Mana uchayuk kaykaptinipish ñukata chikniwashkasapa.” Chay killkadupi rimashkanshina deverasta chikniwaykansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tatayniman rishpayni mana llullakuk Tata Diospa Espiritunta kachamusha kankunata yanapashunaykichipa. Tata Diosmanta Espiritun shamushpa runakunata yachachinkasapa ñuka Tata Diosmanta shamudu runa kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ñuka yachachikuyta kallarishkaynimantapacha kankuna katiwaykankichi. Chayrayku kankunapish tukuy runakunata allita yachachinkichi ñukata kreyiwanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ñami willashkaykichina suk runakuna chiknishunaykichita ama manchakushpa sakiwanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chay runakuna chiknishushpaykichi tantanakunankuna wasimanta karkushunkichi. Suk kankunata wañuchishunkichi. Paykunaka wañuchishushpaykichi yuyankasapa Tata Diosta kushichiykanankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wañuchishunkichi nima Tataynita nima ñukata riksiwashpankuna. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tukuy kayta willaykaykichi chiknishuptikichi tukuy kay willashkaynita yuyanaykichipa. Tukuy kayta manara willashkaykichirachu kankunawan kashpaynira. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesuska yachachikuypi katirkan: —Kunanka ñami rinina kachamuwashka Tatayniman. Chashna rinaynita willaptinipish kankuna mana animukunkichichu tapuwayta maymanmi rini nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kankuna mana munashpa rinaynita sukaman llakiykankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Llakiptikichipish kuskata willaykichi. Kankunapaka ashwan allimi Tatayniman rinaynipa. Mana riptinika chay yanapashuknikichi Tata Diospa Espiritunka manami shamunkachu kankunawan kawsananpa. Rinayni tiyan payta kachamunaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Payna shamushpa kay allpapi kawsak runakunata allita riksichinkasapa uchayuk kanankunata. Chaymanta willankasapa imashnami Tata Diospa munashkan layata rurashpa kawsankasapa nishpa. Chaymanta yachachinkasapa Tata Dios tukuy mana allita rurashpa kawsak runakunata kastiganankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Chay mana alli rurak runakunata willankasapa mana ñukata kreyiwashkankunarayku Tata Dios kastiganankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tatayniman riptini mananami kawawankichinachu. Tata Diospa Espiritunka runakunata yachachinkasapa ñuka mana uchayuk kashkaynirayku Tatayniman rishkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chaymanta tukuy runakunata yachachinkasapa Tata Dios kay allpapi kamachikuk Satanasta kastigashpa tukuy mana kreyiwak runakunatapish kastiganankunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Rikchak layata munani yachachiynikichita. Yachachiynikichita munaptinipish manara atipankichirachu entiendiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Chayrayku manara tukuytarachu yachachishkaykichi. Mana llullakuk Tata Diospa Espiritun shamushpana tukuy layata kuskanpi yachachishunkichi. Manami kikinpa yuyayninmantachu yachachishunkichi. Tata Dios willashkanllata willashunkichi. Chaymanta yachachishunkichi imakunami kay allpapi tiyanka nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Chaymanta tukuy yachachikunaynita kankunata entiendichishunkichi. Chashna entiendichishuptikichi yachankichi sukaman alli rurak alli yachak kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tatayni Diospa yachananta ñukapish yachani. Chayrayku willashkaykichi Tata Diospa Espiritun ñukapa yachachikunaynita entiendichishunaykichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesuska yachachiwaysapallapi katirkan: —Kunan tipillana illan Tatayniman rinaynipa. Payman riptini manana kawawankichinachu. Chaymanta suk tiempukaman kashkan kawawankichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chashna Jesus ñukaykunata willawaptinkuna sukwan sukwan tapunakurkanisapa: —¿Imapatí chashna willawanchisapa? Payka willawanchisapa tipillana illan Tatanman riptin manana kawananchikunata chaymanta suk tiempukaman kashkan kawananchikunata. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imapatí willawanchisapa suk tiempukaman kawananchikunata? Kay rimashkanta mana entiendinchisapachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chaypina Jesuska yacharkan ñukaykuna tapunayanaynikunata. Chayta yachashpa willawarkansapa: —Ñami willashkaykichina tipillana illan mana kawawanaykichita chaymanta suk tiempukaman kashkan kawawanaykichita. ¿Chaytachu kankuna tapunakuykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mash allita uyariwaychi. Ñuka wañuptini kankuna sukaman llakishpa wakankichi. Mana kreyiwak runakuna sukaman kushikunkasapa. Chaymanta kankuna sukaman llakishkaykichimanta kashkan sukaman kushikunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mash allita uyariwaychi. Suk warmi wawayananpa nanay apiptin sukaman manchakun sukaman llakin. Chaymanta wambran nasishkanwasha chay nanayta kunkan. Sukaman kushikun wambran nasiptin. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kunanka kankunapish chay warmishina sukaman llakiykankichi. Ñuka wañushkaynimanta kawsamushpayni kashkan shamusha kawaknikichi. Kankuna kawawashpa sukaman kushikunkichi. Chashna kushikuptikichi manana ni pi turbachishunkichinachu kashkan llakinaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kawsamushkayniwasha tukuy layata entiendishpaykichi manana nimata tapuwankichinachu. Allita willaykichi. Chay diyamantapacha kankuna imatapish shutinipi mañaptikichi Tataynika kushunkichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kunankaman manara yachashkankichirachu Tata Diosta shutinipi mañayta. Kunanmantapacha ñukata kreyiwashpa Tataynita mañaptikichi payka yanapashunkichi kushikuypuru kawsanaykichipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesuska yachachiwaysapallapi katirkan: —Kunankaman ejemplukunata rimashpa yachachishkaykichi. Chaymanta kawsamushkayniwasha manana ejemplukunata rimashpanachu yachachishkaykichi. Allitana willashkaykichi Tatayni tukuy laya yachak kananta. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kawsamushkayniwasha kankuna ñukata kreyiwashpa imatapish kaptin shutinipi Tatayni Diosta mañaptikichi paymi kushunkichi. Manami willaykichichu Tataynita kankunapa mañanaynita kikin Tatayni kuyashuptikichi. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Paymi kuyashunkichi ñukata kuyawashkaykichirayku. Kuyashunkichi paymanta shamushkaynita kreyishkaykichirayku. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tataynipa kawsanan sielumanta llukshimushkani shamunaynipa kay allpapi kawsak. Kunan kay allpamanta llukshishpa kashkan Tatayniman kutini. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chashna Jesus ñukaykunata willawaptinkuna willarkanisapa: —Kunanka ashwan allitanami yachachiwaykankisapa manana ejemplukunata rimashpanachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Manara tapuptinikunara kanmi yuyayninikunata allita yachanki. Chayrayku yachanisapa deveras Tata Diosmanta shamudu kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chashna willaptinikuna Jesuska ayniwarkansapa: —¿Ñachu kunanka kreyinkichina Tata Diosmanta shamushkaynita? ");
INSERT INTO qvsNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chashna rimashpaykichipish kunanlla wañunayni diya chayamuptin chayta chayta kallpashpa sapallaynita sakiwankichi. Chashna sakiwaptikichipish Tataynika manami sakiwankachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tukuy kayta willaykaykichi ñukawan tantalla kawsashpaykichi kushikushpalla kawsanaykichipa. Kay allpapi kawsashpaykichira sufrinaykichi tiyan. Chashna sufrishpaykichipish ama manchakuychichu. Tukuy chikniwakkuna ñukapa manduynipimi. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chashna yachachiwashkankunawasha Jesuska sieluta chapashpa Tatanta willarkan: —A, Tatayni, wañunayni diyaka chayamushkana. Wañuptini kashkan kawsachimuway tukuy runakuna yachanankunapa kuyadu wambrayki kanaynita. Ñuka wañushpa kashkan kawsamuptini tukuy runakuna yachankasapa sukaman alli yachak kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tatayni, kanmi kachamuwashkanki sinchi kamachikuk kanaynipa tukuy runakuna manduynipi kanankunapa. Chashna kamachikuk kashpayni tukuy kuwashkayki runakunata mana tukuyniyukta kawsachishasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chashna paykunata kawsachiptinikuna kanta riksishunkisapa mana llullakuk sapallan Tata Dios kanaykita. Ñukatapish riksiwankasapa kachamuwashkayki wambrayki kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kay allpapi kashpayni tukuy willawashkaykita ñami allitana rurashkani. Runakunata yachachishkanisapa sukaman allima kanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Manara kay allpa tiyaptinra ñukaka kanwan tantalla kawsarkani. Kunanka, Tatayni, kanman kutiptini kashkan laduykipi churaway kanwan tantalla sinchi kamachikuk kanaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kay allpapi kawsak runakunamanta kay runakunata akllashkanki disipuluynikuna kanankunapa. Paykunata yachachishkanisapa tukuy laya yachak kanaykita. Kanpa kaptinkuna ñukata kuwashkankisapa. Rimanaykita yachachiptini paykuna allita kasushkasapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kunanka ñami yachansapana kan yachachiwaptiki paykunata yachachishkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Disipuluynikunata rimanaykita ñami yachachishkanisapana. Kunanka rimanaykita chaskishkasapa. Ñami allitana yachansapa deveras kanmanta kay allpaman shamushkaynita. Allitana kreyinsapa kachamuwashkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Tatayni, sukaman roygayki paykunata yanapanaykipasapa. Mana roygaykichu mana kreyiwak runakunata yanapanaykipasapa. Roygayki kay kreyiwak runakunata yanapanaykipa kanpa kaptinkuna. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tukuy ñukata kreyiwakkunaka kanpa wambraykikunami. Kanta kreyishuk runakuna ñukatapish kreyiwansapa. Tukuy runakuna disipuluynikunata yanapashkaynita kawashpankuna yachankasapa alli yachak kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Manana kay allpapika unaytanachu kawsasha. Kanwan kashkan kawsak riptini paykunaka kay allpapi kiparinkasapa. Tatayni, kanmi sukaman allima kashpayki sukaman alli yachak kashpayki kuwashkayki disipuluynikunata kuydaysapa ama uchallikunankunapa. Tatayni, ñukanchi tantalla suk yuyaylla kawsanchi. Kunanka disipuluynikunata yanapaysapa paykunapish ñukanchishina tantalla suk yuyaylla kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kanna sukaman yanapawaptiki kay allpapi paykunawan tantalla kashpaynira kuydashkanisapa ama sakiwanankunapa. Chay kuwashkayki disipuluynikunamanta sukllalla sukaman mana allita rurayta munashpa sakiwashka. Sakiwashkanrayku kanmi kastiganayki tiyan. Ñawpa killkadu rimanaykipi riman sakiwananta. Chashna rimanayki rimaptin deverasmi payka sakiwashkana. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kunanka kawsanayki sieluman rishana. Kay allpapi kashpaynira kay disipuluynikunata rikchak layata yachachishkanisapa sukaman allimata kushikunaynishina paykunapish kushikunankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Rimanaykita allita yachachikuptini paykunaka ñukashina allita rurashpa kawsansapa. Manana chay mana alli rurak runakunashina kawsaptinkuna paykuna chikninsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Paykuna chikniptinkunapish mana roygaykichu kay allpamanta pushanaykipasapa. Roygayki kuydanaykipasapa ama supay uchallichinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kay allpapi kawsashpaynipish mana kay allpapi kawsak runakunashinachu kawsani. Allita rurashpa kawsaptini kay disipuluynikunapish ñukata kreyiwashpa manana ñawpashinanachu uchallikushpa kawsansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tatayni, kanpa rimanaykika allimata kuskatami riman. Chayrayku rimanaykita disipuluynikunata yachachiysapa allita munanaykita rurashpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kanmi kay allpaman kachamuwashkanki uchasapa runakunata rimanaykita yachachinaynipasapa. Kunanka ñukapish disipuluynikunata kachaykanisapa kay allpapi kawsak runakunata rimanaykita yachachinankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kay allpaman shamushkani kanpa munanaykita rurashpa kawsanaynipa. Rimanaykita disipuluynikunata yachachishkani paykunapish kanpa munanaykita rurashpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Chaymanta kay disipuluynikuna rimanaykita yachachikuptinkuna aypa runakuna ñukata kreyiwashpa kawsankasapa. Mana roygaykichu kay disipuluynikunallata kuydanaykipasapa. Tukuy kreyiwak runakunatapish kuydaysapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Roygayki tukuy chay kreyiwak runakunata yanapanaykipasapa sukwan sukwan tantalla kuyanakushpa kawsanankunapa. Yanapaysapa ñukanchiwan tantalla kuyanakushpa kawsanankunapa. A Tatayni, ñuka kanwan suk yuyaylla kashpa allita tantalla kuyanakushpa kawsanchi. Tukuy kreyiwak runakunata yanapaysapa paykunapish ñukanchishina suk yuyaylla kawsanankunapa. Chay layata kawsaptinkuna tukuy runakuna yachankasapa ñukata kachamuwashkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kanka kuyawashpa yanapawashkanki munanaykillata rurashpa kawsanaynipa. Ñukapish disipuluynikunata kuyashpa yanapashkanisapa munanaykita rurashpa kawsanankunapa. Paykunata yanapanisapa kan ñukawan idenllata yuyaykushpa kawsananchishina paykunapish sukwan sukwan idenllata yuyaykushpa kawsanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kanmi ñukawan tantalla kawsanki. Ñukapish disipuluynikunawan tantalla kawsani allita sukwan sukwan kuyanakushpa tantalla kawsanankunapa. Chashna kuyanakushpa kawsaptinkuna tukuy runakuna yachankasapa kay allpaman kachamuwashkaykita. Chaymanta yachankasapa iden ñukata kuyawanaykishina paykunatapish kuyanaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tatayni, manara kay allpata rurashpaykira sukaman kuyawashkanki. Ñukataka willawashkanki tukuy layapi sinchi kamachikuk kanaynipa. Munani tukuy kreyiwak runakuna kawsanayki sieluman rinankunapa ñukawan tantalla kawsak. Munani kawanankunapa sinchi kamachikuk kanaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","A Tatayni, sukaman alli rurakmi kanki. Mana kreyiwashpa kawsak runakuna mana riksishunkisapachu. Mana riksishuptinkunapish ñuka allita riksiyki. Chaymanta disipuluynikunapish yachansapana kachamuwashkaykita. ");
INSERT INTO qvsNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ñukami yachachishkanisapa sukaman alli yachak alli kuyakuk kanaykita. Chayta yachachikuyllapi katisha ñukata kuyawanaykishina paykunapish sukwan sukwan kuyanakunankunapa. Allita kuyanakuptinkuna ñukami paykunawan tantalla kawsasha. Chayllatami Jesuska Tatanta roygarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tukuy chaykunata rimashkanwasha Jesuska chay wasimanta ñukaykunawan llukshirkan. Rirkanisapa Sedron yaku chimbaman. Chay chimbapi tiyarkan suk aypa olivoyuk werta. Chay wertapi Jesuska ñukaykunawan tantalla yaykurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesuska chay wertapi amañak ñukaykunawan tantanakuyta. Chayrayku chay rantikuk disipulun Judaska riksirkan maypimi Jesuska tantanakun nishpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chay wertapi kaptinikuna Judaska chayarkan aypa soldadukunata Tata Diospa wasinta kuydakkunata pushashpa. Fariseokunawan awtoridar saserdotekuna paykunata kacharkansapa. Judas pushaptinkuna machetinkunata uchinankunata alkusankunata apashpa rirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuska allita yachashpa imapami shamunsapa nishpa rirkan paykunata tinkuk. Chaypina tapurkansapa: —¿Pitatí maskaykankichi? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chay runakunaka aynirkansapa: —Nasaret llaktamanta Jesustami maskaykanisapa. Chashna willaptinkuna Jesuska willarkansapa: —Ñukami kani. Jesusta rantikuk Judaspish chay runakunawan tantalla karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesus willaptinkuna: “Ñukami kani” nishpa paykunaka ankallimanta allpapi urmarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chaypina Jesuska kashkan tapurkansapa: —¿Pitatí maskaykankichi? Paykunaka kashkan willarkansapa: —Nasaret llaktamanta Jesustami maskaykanisapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chaypina Jesuska kashkan willarkansapa: —Ñami willashkaykichina ñuka Jesus kanaynita. Ñukata maskawashpaykichika ama michaychichu kay disipuluynikunata rinankunamanta. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chashna Jesus rimashpa ñukaykunata kuydawaykarkansapa. Paymi ñawpalla Tatanta willarkan: “Tatayni, kuwashkayki runakunata kuydashkanisapa ama sakiwanankunapa.” Chashna Jesus Tatanta roygashka kashpa kuydawarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chaypina Jesusta apinayaptinkuna disipulun Simon Pedru machetinta apishpa suk runa Malkopa alli ladu rinrinta tipipurkan. Chay runa Malko sinchi kamachikuk saserdotepa wiwachun karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chashna rinrinta tipipuptin Jesuska Pedruta willarkan: —Chay machetikita kashkan macheti churanaykipi churay. Tatayni wañunaynipa munaptin wañusha. ¿Yuyankichu manchakushpayni Tataynita mana kasunaynita? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chaypina soldadukuna kamachikukninkunawan Tata Diospa wasinta kuydak runakuna Jesusta apishpa watarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jesusta watashpana pusharkansapa awtoridar saserdote Anaspa wasinman. Anaska Kayfaspa suedrun karkan. Chay tiempu Kayfaska tukuy saserdotekunapa ashwan sinchi awtoridarninkuna karkan. Chayrayku Kayfaspa suedrun Anasman Jesusta pusharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ñawpana Kayfaska tukuy ñukaykuna judiyu runakunapa awtoridarninikunata willarkansapa: “Ashwan alli kanman suk runalla wañunanpa ama tukuy ñukanchikuna israel runakuna wañunanchikunapa.” ");
INSERT INTO qvsNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Chashna chay awtoridar Anaspa wasinman Jesusta pushaptinkunana Simon Pedruwan ñuka Juan washanta katirkanisapa. Chay saserdotekunapa awtoridarninka ñukata riksiwarkan. Chayrayku chay manllayba wasi pampapi ñukapish Jesusta katishpa yaykurkani. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ñuka yaykuptini washallapi Pedruka kiparirkan. Chaypina rirkani punku kuydak warmita willak Pedrutapish yaykuchinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedruta yaykuchishpana chay warmika tapurkan: —¿Kanpish Jesuspa disipulunchu kanki? Chashna tapuptinna Pedruka willarkan: —Manami disipulunchu kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chaypina sukaman chirishpankuna Anaspa wiwachunkunawan Tata Diospa wasinta kuydakkuna ninakushpankuna mashakuykarkansapa. Pedrupish paykunawan tantalla mashakuykarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chaypina wasin ukupi saserdotekunapa awtoridarninkuna Anaska Jesustaka kallarirkan tapuyta: —¿Pikunati disipuluykikunaka? ¿Imatati paykunata yachachinkisapa? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chashna tapuptin Jesuska willarkan: —Ñuka tukuy runakuna uyariwaptin yachachikushkani. Tantanakunankuna wasikunapi Tata Diospa wasinpipish allita yachachikushkani. Mana nimata pakallallachu yachachikushkani. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imapati ñukataka tapuwanki? Yachachikuptini aypa runakuna uyariwarkansapa. Paykunata tapuy imatami yachachishkanisapa nishpa. Paykunami allita yachansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chashna Jesus chay saserdotekunapa awtoridarninkunata ayniptin Tata Diospa wasin kuydak runa uyanpi lapyashpa willarkan: —Ariya ¿chashnachu ayninki sinchi awtoridar saserdotetaka? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chaypina Jesuska willarkan: —Ariya mana allita willaptinika willaway ima mana allitatí willashkani. Kuskata willaykaptinika ¿imapatí lapyawashkanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chaypina Anaska makin wataduta Jesustaka pushachirkan yernon Kayfasman. Paymi saserdotekunapa ashwan sinchi awtoridarninkuna karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chashna Jesusta tapunankunakaman Pedruka washapi mashakuykarkan. Chaypina paywan mashakuykak runakuna tapurkansapa: —¿Manachu kanpish chay runapa disipulun kanki? Chashna tapuptinkunana Pedruka willarkansapa: —Manami disipulunchu kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chaymanta chaypi karkan awtoridar saserdotepa suk wiwachun. Payka chay rinrin tipidu Malkopa familyan karkan. Payna Pedrutaka tapurkan: —¿Manachu kantaka kawashkayki Jesuswan tantalla chay wertapi? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chashna tapuptin Pedruka paytapish willarkan mana Jesusta riksinanta. Chayta rimaykaptinlla suk gallo kantarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chaymanta Kayfaspa wasinmanta Jesusta pusharkansapa romano awtoridar Pilatopa kamachikunan wasiman. Manara allita pakariptinra chay wasipi Jesusta chatakuk runakunaka chayarkansapa. Mana niman suk yaykunayarkansapachu. Paykunaka yuyarkansapa romanokunapa wasinpi yaykushpa Tata Diospa ñawpakninpi chuya chuya kanankunamanta chapunakunankunata. Chashna chapunakushpa Paskua fiestata rurashpa manana atipanmansapanachu mikuyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chayrayku Pilatoka llukshimurkan paykunata tapuk: —¿Ima mana allitatí kay runaka rurashka? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chaypina chay chatakuk runakunaka Pilatota willarkansapa: —Kay runaka alli rurak runa kaptinka manami pushamuymansapachu karkan kanpi chatakuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Chashna ayniptinkunana Pilatoka willarkansapa: —Kankunapa ñawpa killkaduykichipi riman imashnami kastigankichi nishpa. Chayta kasushpa kikikichilla kay runataka kastigaychi. Chaypina chay runakunaka Pilatota willarkansapa: —Kan mana willawaptikisapa ñukaykuna judiyu runakuna kashpaynikuna mana ni pita atipanisapachu wañuchiyta. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ñawpata Jesus yachachiwashpankuna ñukaykunata willawarkansapa suk kruspi wañunanta. Jesus rimashkanshina chay chiknik runakuna munarkansapa Pilato suk kruspi chakatashpa Jesusta wañuchinanpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chaypina Pilato kamachikunan wasipi kashkan yaykushpa Jesustaka ladunman kayashpa tapurkan: —¿Kanchu kanki judiyukunapa ashwan sinchi kamachikukninkuna? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chaypina Jesuska willarkan: —¿Imapati judiyukunapa kamachikukninkuna kanaynita tapuwanki? ¿Chaytaka kikikipa yuyaynikimantachu tapuwanki? Ichará maykan willashushka chashna tapuwanaykipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chashna willaptinna Pilatoka Jesusta willarkan: —Ñuka manami judiyuchu kani chaykunata yachanaynipa. Kanpa judiyumasikikunapa awtoridarninkunami pushamushushkasapa ñukapi chatashuk. ¿Ima mana allitatí rurashkanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chaypina Jesuska Pilatota willarkan: —Ñuka manami kay allpapi kamachikuk runachu kani. Kay allpapi kamachikuk kaptinika tukuy kasuwak runakuna amachawanmansapa karkan. Paykunaka judiyu awtoridarkunawan makanakunmansapa karkan ama apiwanankunapa. Ñukaka mana allpapi kamachikuk runachu kani. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chaypina Pilatoka tapurkan: —¿Deveraschu tukuy layapi alli kamachikuk kanki? Jesuska aynirkan: —Ariya rimashkaykishina sinchi kamachikuk runami kani. Shamushkani kay allpapi nasik mana llullakushpa kuskata yachachikunaynipa. Tukuy alli yachachikunata kasuk runakuna ñukapa yachachikunaynita kasunsapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chashna Jesus willaptinna Pilatoka tapurkan: —¿Imatí alli yachachikunaka? Chaymanta Pilatoka chayta tapushpalla Jesusta sakirkan. Chaypina wasimanta kashkan llukshishpa Jesusta chatak runakunata willarkansapa: —Manami kay runapika tarinichu nima laya mana alli rurashkanta kastiganaynipa. ");
INSERT INTO qvsNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kunan uyariychi. Kada Paskua fiesta ukun kankuna mañawankichi suk karselpi wichkadu runata kacharinaynipa. Kay wata ¿munankichichu kay sinchi kamachishuknikichita kacharinaynipa? ");
INSERT INTO qvsNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chashna Pilato tapuptinkunana chay runakunaka kashkan sinchita rimashpa willarkansapa: —¡Ama Jesustaka kachariychu! ¡Barrabasta kachariy! Chay wata Barrabas karselpi karkan wañuchikuk suwa runa kashpa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chashna chay chiknik runakuna willaptinkuna Pilatoka soldadunkunata willarkansapa Jesusta makanankunapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Paykunaka Jesusta makashkankunawasha kasha likidu waskamanta suk koronata rurashpankuna umanpi churapurkansapa asichinankunapa. Kamachikukpa sani llachapata mudachirkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chaymanta ladunchashpankuna uyanpi sukaman sakmashpa asichishpa willarkansapa: —¡Judiyu runakunapa kamachikuknin kaptiki sukaman munaykisapa! ");
INSERT INTO qvsNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chaymanta Pilato kashkan washaman llukshishpa chay runakunataka willarkansapa: —Mash allita uyariwaychi. Kunanka kay runataka pushamuni yachanaykichipa mana nima uchallikushkanta tarishkaynita. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chaypina Jesuska kashamanta ruradu koronayuk kamachikuk runapa sani llachapa churakudu llukshimurkan. Chashna llukshiptin Pilatoka chay runakunataka willarkansapa: —¡Kawaychina kay runataka! ");
INSERT INTO qvsNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chaypina saserdotekunapa awtoridarninkunawan Tata Diospa wasin kuydakkuna sinchita rimashpa willarkansapa: —¡Suk kruspi chakatachiy! ¡Suk kruspi chakatachiy! Chaypina Pilatoka willarkansapa: —Kankunaka pushaychi suk kruspi chakatashpa wañuchinaykichipa. Ñukaka mana nima uchanta paypika tarinichu. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chaypina chay runakunaka Pilatota aynirkansapa: —Tata Dios killkadunpi willawansapa kay laya runata wañuchinaynikunapa. Payka llullakushpa rimashka Tata Diospa chaylla wambran kananta. Chayrayku wañunan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatoka chay runakuna rimashkankunata uyarishpa ashwanta manchakurkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chaymanta kamachikunan wasiman Jesusta kashkan yaykuchishpa tapurkan: —¿Maymantati shamushkanki? Chashna Pilato tapuptinna Jesuska mana nimata aynirkanchu. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Upallalla kaptin Pilatoka willarkan: —¿Manachu nimata ayniwanki? Ñuka munashpayni suk kruspi wañuchichiykiman. Munashpayni kachariykiman. ¿Manachu chaytaka yachanki? ");
INSERT INTO qvsNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chashna willaptinna Jesuska Pilatota willarkan: —Tata Dios mana munaptinka mana nimata atipankimanchu rurawayta. Kayfas sinchi kamachikuk saserdote kaykashpa kanman pushachimuwashka wañuchichiwanaykipa. Chayrayku payka kanmanta ashwan uchayuk. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chay ratumantapacha Pilatoka sukaman munarkan Jesusta kachariyta. Chaypina Jesusta chiknik runakuna ashwanta kaparikushpa Pilatota willarkansapa: —Kay runaka rimashka sinchi kamachikuk kananta. Chayta rimashpa rimaykan manana ashwan sinchi kamachikuk Sesarta kasunanta. Kay runata kacharishpaykika kanpish mananami chay kamachikuk Sesarta kasunkinachu. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chayta uyarishpa Pilatoka Jesusta kashkan pushachirkan chay runakunapa ñawpakninkunaman. Chaypina kamachikunan sillanpi tiyarirkan chay runakunata kamachinanpa. Chay silla Gabata pampapi karkan. Chay Gabata shuti hebreo rimanapi riman Rumimanta Ruradu. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paskua fiesta suk diyallana illarkan. Chay diya yakallapa chawpi diyata Pilatoka chay runakunataka willarkansapa: —Mash kawaychi kamachishuknikichita. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Chashna Pilato willaptinkunana tukuy paykunaka sinchita rimarkansapa: —¡Wañuchun wañuchun! ¡Suk kruspi chakatachiy! Chaypina Pilatoka tapurkansapa: —¿Sinchi kamachishuknikichi runatachu wañuchichisha? Chaypina saserdotekunapa kamachikukninkunaka Pilatota willarkansapa: —Alli kamachikuk Sesarllami ñukaykunata kamachiwansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chashna willaptinkuna Pilatoka willarkansapa Jesusta suk kruspi wañuchinankunapa. Chaypina soldadukuna pusharkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Chaymanta soldadukuna Jesusta krusninta aparichishpa suk lomaman pusharkansapa. Chay lomaka iden uma poto rikurirkan. Chayrayku shutinka karkan Uma Poto. Judiyukunapa rimanaynikunapi chay lomapa shutin karkan Golgota. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chay lomapi Jesustaka chakatarkansapa. Chaymanta Jesuspa ishkantin ladunpi ishkay runakunatapish chakatarkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Chaypina suk tablapi Pilatoka killkakurkan: “Kay Nasaret llaktamanta Jesusmi judiyu runakunapa sinchi kamachikukninkuna.” Chay killkaduta Jesuspa uman kuskapi timbichichirkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chay lomaka Jerusalen llaktamanta mana karupichu karkan. Chayrayku aypa judiyu runakuna Jesusta kawak rishpankuna chay killkaduta leyirkansapa. Chayka kimsa laya rimanapi killkadu karkan. Suk killkadu karkan judiyukunapa rimanaynikunapi. Suk karkan griego runakunapa rimananpi. Kimsaynin karkan romanokunapa rimananpi. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chay killkaduta leyishpankuna saserdotekunapa awtoridarninkuna piñakushpa Pilatotaka rirkansapa willak: —¿Imapatí chay tablapi killkakushkanki “kay runami judiyukunapa kamachikukninkuna?” Kunanka chikan tablapi killkakushpa churay: “Kay runa rimashka: ‘Ñukami kani judiyukunapa sinchi kamachikukninkuna.’ ” ");
INSERT INTO qvsNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chaypina Pilatoka willarkansapa: —Ñuka killkashkaynika chashnami kiparinan tiyan. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldadukuna Jesusta chakatashkankunawasha sawa llachapankuna chuskuntinkuna patumanakurkansapa. Chaymanta suni uku llachapantapish apirkansapa. Chay suni uku llachapaka tukuy suniynintin awadu mana siraduchu karkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chayta kawashpa soldadukunaka willanakurkansapa: —Ama llikiypachichu kay allima awadu llachapata. Akuychi pukllashpa kawaypachi pipami kiparinka nishpa. Chashna rimashpankuna patumanakurkansapa. Tata Diospa ñawpa killkadunpi riman: “Llachapaynita patumanakushkasapami. Pukllashpankuna kawashkasapa pimi llachapaynita apanka nishpa.” Chay diya Tata Diospa ñawpa killkadu rimashkanshina chay soldadukuna Jesuspa llachapankunata patumanakurkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chaypina Jesuspa mamanka ñañanwan kruspa ladunllapi karkansapa. Chaymanta chaypi Kleofaspa warmin Mariyawan, Mariya Magdalena karkansapa. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesuska mamanta kawashpa ñukatapish kawawarkan. Chaypina mamantaka willarkan: —Mama, Juanka wawaykishinami kiparin. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chaymanta Jesuska ñukatapish willawarkan: —Kunanmantapacha payna mamaykishina kiparin. Chashna Jesus ñukata willawaptin chay tiempumantapacha Jesuspa maman wasinipi kawsarkan. ");
INSERT INTO qvsNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus kruspi kashpa yacharkan Tata Diospa killkadu rimashkanshina rurashkanta. Tata Diospa killkadunpi rimarkan yakuta mañakun