﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvo_vpl;
CREATE TABLE qvo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvo_vpl WRITE;
INSERT INTO qvo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Kaymi ñuka kwintaska kushi shimi Jesusmanta. Jesusmi kan ñukanchi chapaska Dios mantamuska ñukanchita kishpichi runa, Diospa churi. Kay kushi shimi kallarin imasna Dios ñupa uras kawsa Isaiasta rimaska. Chay Dios rimaskata kwinta runa Isaiaska killkarka Dios paypa kikin churita kasna niskata: Kan rurana kaskata manara kallariskapi ñuka shimita yachachi runata tukuyta alichinkapa mantashami. ");
INSERT INTO qvo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chunlla partipi kapariska uyarinka. Kasna rimanka: Dios paktamunarayku alichichi nisa. ");
INSERT INTO qvo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chay alichi runa maykamanta Isaias killkaska Juanmi karka, Diospa churi paktamunarayku alichi. Chunlla partipi runakunata bawtisasa kawsarka. Runakunata kamachisa kasna nirka: —Huchata mana ña rurasa Diosta uyasa kawsaychi. Huchata mana ña ruranayaskata rikuchisa bawtisarichi. Chasna rapi Dios kankunata huchamanta pichasa kankunawa aylluyanka.— ");
INSERT INTO qvo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea allpapi tiya Jerusalen llaktamanta, Judeapi shu llaktakunamantapas runakuna Juanpama shamunakurka payta uyankapa. Huchata raskamanta llakirisa ima hucha raskata rimapi Juan chay Jordan yakupi paykunata sampulichisa bawtisarka. ");
INSERT INTO qvo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanka ñupa uras kawsa Diospa rimaskata kwinta runakuna churariskashina churariska karka, pukri runa churarina layawa. Hatun wiwa kamellu puchkaska willmamanta awaska chushalla katanawashina churariska karka. Wiwa karamanta chumpiwa chuninkapi watariska karka. Sacha mishkita hihitapas mikusa kawsa karka. (1. Sam. 28.14; 2. Reyes 1.8; Zec. 13.4; Mt. 3.4) ");
INSERT INTO qvo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kasna rimasa kwintarka: —Ñukamanta yali ushayu runa ña paktamunkami. Chay runamanta ñuka yapa ura kasa shu imashtullatapas payrayku rankapa mana balinichu. ");
INSERT INTO qvo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ñuka kankunata yakullawa bawtisani, ranti payka Diospa Samayta kusa kankunata bawtisanka.— ");
INSERT INTO qvo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan bawtisaraska punchakunapi Jesus Galilea allpapi tiya Nazaret llaktapi karka. Nazaret llaktamanta Galilea allpamantapas Jesus llukshisa Jordan yakuma paktarka. Chaypi Juan Jesusta Jordan yakupi bawtisarka. ");
INSERT INTO qvo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yakumanta llukshirasa Jesus hawapacha paskariskata rikurka. Diospa Samay urpishina paypama uraykumuraskata rikurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chasnapi hawapachamanta shu shimi uyarirka: —Kan ñuka llakiska Churimi kanki. Kanwami kushiyani.— ");
INSERT INTO qvo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesus bawtisay tukuskawasha Diospa Samay payta yuyachirka chay chunlla parti shu partima rinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaypi supaykunapa apu Jesusta pantachinayasa chusku chunka punchata kamarka. Jesus millay aychakuna chupipi kawsararka. Anhelkuna Jesusta kuyrasa kanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanwa piñarisa apu Herodes payta mana alita rura runakunata tapana wasipi tapachipi Jesus kuti Galilea allpama rirka. Chaypi Diospamanta kushi shimita yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yachachirka kasna nisa: —Dios ñupa urasmanta yuyariskata paktachina uras ña paktamuskami. Dios kay allpapi ñami kallarinkapa rahun runakunata amuyankapa. Huchata mana ña rurasa Diosta uyasa kawsaychi. Diospamanta kushi shimiwa sinchikuychi.— ");
INSERT INTO qvo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea kucha mayata purirasa Jesus ishkay runata rikurka, Simonta Andrestapas. Paykuna wawkipura kanakurka, challwata hapikamakuna. Jesus paykuna taraharaskata rikurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chasna rikusa rimarka: —Ñuka yachachiskata katikamakuna tukunkapa shamuychi. Challwata hapinarantimanta kankunata yachachiskankichi runakunata muntuchikuna kankapa Diosta uyasa kawsakuna tukunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chay urallata tarahata sakisa Jesuswa parihu risa pay yachachiskata katikamakuna tukunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Astanipi purirasa Jesus Zebedeopa ishkay churikunata rikurka, Santiagota Juantapas. Botipi liki likata sirasa alichisa tiyaranakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus paykunata rikusa chasnallata kayarka pay yachachiskata katikamakuna tukunkapa. Kayapi uyasa paykunapa yayata trabahakunaynti botipi sakinakurka. Jesuswa risa pay yachachiskata katikamakuna tukunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus paywa parihu purikunaynti Capernaum niska llaktama paktanakurka. Samana punchapika Jesus Diospa shimita yachana wasima risa munturiska runakunata yachachinkapa kallarirka. ");
INSERT INTO qvo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesus yachachiskaka shunku ukupi yuyachi karka. Ushaywa yachachi karka. Chasna rimaskata uyasa runakuna mancharinakurka. Jesus mana yachachirkachu imana Dios ñupa uras killkachiska killkata kutillata killkakamakuna yachachiskashina. Chay killkakamakuna yuyachi ushay illa yachachinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Diospa shimita yachana wasipi shu runa supay amuyaskami karka. Chay runa ukumanta supayka kaparinkapa kallarirka: ");
INSERT INTO qvo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Nazaret llaktamanta Jesus, imapata ñukanchiwa satirinki. Ñukanchita hichusa kastigankapachu shamunki. Kanta riksini, ali yuyayllata chari runami kanki, Diosparayku kawsa runa.— ");
INSERT INTO qvo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chasna nipi Jesus chay supayta rimarka: —Upallay. Kay runa ukumanta llukshi.— ");
INSERT INTO qvo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Supayka chay runata sinchita kuchpachisa, kaparichisa llukshirka. ");
INSERT INTO qvo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chasna tukupi chayta rikukuna yapa mancharisa rimarinakurka: —Imata tukunchi. Jesus yachachina shukunapa yachachinamanta chikan kan. Ushayta riksichisa yachachinmi. Jesus rimapi supaykuna kasunakun.— ");
INSERT INTO qvo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaypawasha tukuy Galilea allpapi tiya llaktakunapi Jesusmanta kwintarinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Capernaumpi Diospa shimita yachana wasimanta llukshisa Jesus pay yachachiskata chusku katikamakunaynti Simonpa wasima rinakurka. Jesuswa parihu Simon, Andres, Santiago, Juanpas rinakurka. Chay wasi Simonpa paypa wawki Andrespapas karka. ");
INSERT INTO qvo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chaypi Simonpa warmi mama unkuywa sirirarka. Jesus paktapi unku kaskata kwintanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus unku siriraskama risa makimanta hapisa hatachirka. Chay urasllapita unku kaskamanta aliyarka. Hatarisa yanusa paykunata kararka. ");
INSERT INTO qvo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jesus Simonpa warmi mamata aliyachiska chishillata, inti ña yaykurapi runakuna tukuy unkuskakunata, supaykuna amuyaskakunatapas Jesuspama pushanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tukuy chay llaktapi kawsa runakuna chay wasi punkupi munturinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus tukuy laya unkuskakunata aliyachirka. Supaykuna amuyaska runakuna ukumanta supaykunata llukshichisa kallpachirka. Supaykuna payta riksipi Jesus paykunata rimarka mana paymanta rimankapa. ");
INSERT INTO qvo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kayanti punchapi tuta ukulla hatarisa Jesus wasimanta llukshirka. Runa illa partima rirka Dioswa kwintarinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jesus wasipi illapi Simon paywa kaskakunaynti Jesusta maskankapa rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Maskasa tupanakurka. Chasnapi Jesusta rimanakurka: —Tukuy runakuna kantami maskanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus paykunata nirka: —Hakuychi shu partima rishunchi. Maya llaktakunama rishunchi chaypipas Diospa shimita yachachinkapa. Chaypami ñuka shamuskani.— ");
INSERT INTO qvo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chasna rimasa chaymanta llukshirka. Tukuy Galilea allpapi purirarka. Diospa shimita yachana wasikunapi yachachisa, supay amuyaska runakuna ukumanta supayta llukshichisa purirarka. ");
INSERT INTO qvo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Shu puncha millay karachawa unkuska runa Jesuspama shamurka. Kunkurisa payta mañarka: —Kan munasa ñukata aliyachinata ushanki.— ");
INSERT INTO qvo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus llakisa chay runata paypa makiwa llankasami rimarka: —Munanimi. Aliyaska sakirinki.— ");
INSERT INTO qvo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Rimapi chay runa millay karacha unkuymanta pichariska ali sakirirka. ");
INSERT INTO qvo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aliyachiskawasha Jesus —samashu— nisa payta rimarka: ");
INSERT INTO qvo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ama pitapas ñuka kanta aliyachiskata kwintankichu. Ranti pakripama aliyaskata rikuchikrinki. Pakri alita rikusa kanta rimachu aliyaskachu kanki manachu. Ñupa uras kawsa Moises Dios mantaskata killkaskashina millay karacha unkuymanta aliyaska runa Diosma kuna kaskata apasa pakrikunama kukrinki. Chasna kan raskamanta tukuy runakuna kan shutipa aliyaskata yachanakunka.— ");
INSERT INTO qvo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Chay runa risa mana kwintana kaskata tukuykunama kwintankapa kallarirka. Chayrayku tukuy partimanta runakuna Jesuspama paktamunakurka. Chasna kapi Jesus mana ña usharkachu llaktakuna ukuma yaykunkapa. Llaktakuna kanchama runa illaska partipi sakiri karka. Chasna sakiripipas achka runakuna tukuy partimanta Jesuspama shamunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Shu punchakunawasha Jesus kuti Capernaum llaktama rirka. Paktapi runakuna shukratu yachanakurka pay paktana wasima paktaskata. ");
INSERT INTO qvo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chayrayku achka runakuna Jesuspama shamunakurka, wasi huntakta. Punku kanchamapas tapakta runakuna tiyarka. Jesus runakunata rikusa Dios kishpichi shimita yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chasna yachachiraskapi chusku runa suchu runata katanapi sirichiskata apamusa shamunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jesus kaskama paktankapa mana ushasa chay balla wasi kancha parti chakanata sikanakurka. Hawamanta Jesus kaska kuskalla hutkuta allanakurka. Chay hutkuta pasachisa unku runata hawamanta Jesuspa ñupama uraykuchinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus chay unkuta apakama runakunata rikusa paywa sinchikunakuskata, chay unku runata rimarka: —Wawkilla, kan huchakunamanta pichay tukusa sakirinki.— ");
INSERT INTO qvo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dios ñupa uras killkachiska killkata kutillata killkakamakunamanta maykankuna chaypi kanakurka. Jesus rimaskata uyasa paykunapa shunkupi yuyarinakurka: ");
INSERT INTO qvo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Paylla yalikta kanayasa chasna rima kan. Diosshina tukunayasa Diosta piñachiran. Dioslla ñukanchita huchakunamanta pichanata ushanmi.— ");
INSERT INTO qvo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Killkakamakuna chasna yuyariraskapi Jesus paykunapa yuyayta riksisa tapurka: —Imaraykuta waklita yuyarinkichi. ");
INSERT INTO qvo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ñuka unku runata rimarkani: —Kan huchakunamanta pichay tukusa sakirinki— nisa. Ashwan ushaypachu unku runama rimankapa: —Hatari kanpa katanata apasa purisa ri— nisa. Imata rimawankichi. ");
INSERT INTO qvo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kankuna yachankapa ñuka, Dios mantamuska runa kasa kay allpapi kawsa runakunapa huchakunata pichanata ushayu kaskata rikuchinkapa rahuni.— Chasnapi muyurisa suchu runata nirka: ");
INSERT INTO qvo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Hatari. Kanpa katanata apasa wasima ri.— ");
INSERT INTO qvo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chay uralla hatarirka. Paypa katanata hapisa tukuykuna rikuraskapi chay wasimanta llukshirka. Chayta rikusa tukuy mancharinakurka. Diosta kushiyachisa pakrachunakurka: —Mana ima uraspas chasna ruraskata rikuskanchichu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus suchu runata hampiskawasha kutillata yaku patama rirka. Yaku patama paktapi achka runakuna paypama shamusa munturinakurka. Chasnapi Jesus paykunata Diospa shimita yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaypawasha puriraskapi Alfeopa churi Levi niskata rikurka. Levi Romamanta hatun apurayku kullkita kobra kasa kobrana wasipi tiyararka. Jesus payta rikusa rimarka: —Shamuy ñuka yachachiskata katikama tukunkapa.— Chayta uyasa hatarisa Jesuswa rirka pay yachachiskata katikama tukunkapa. ");
INSERT INTO qvo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Washa Jesus pay yachachiskata katikamakunawa Levipa wasipi mikunakurka. Runakuna yuyariskapi —mana ali rura kanakun— niskakunamanta achka Jesuswa parihu mikunakurka. Chay mana ali rurakunamanta achka kanakurka Roma hatun apurayku kullkita kobrakuna. Achka chay laya ñupa mana ali rura runakuna Jesus yachachiskata katikamakuna tukunakuskawasha chaypi munturisa kanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chay wasi kanchapi maykan Dios ñupa uras killkachiska killkata kutillata killkakamakuna shayarisa kanakurka. Chay killkakamakuna Fariseokuna niska wankuriska runa bulamanta kanakurka. Romamanta hatun apurayku kullkita kobra runakunawa, shuk mana ali rurakunawapas Jesus parihu mikuraskata rikusa chay killkakamakuna Jesus yachachiskata katikamakunata tapunakurka: —Imarayku kankunata yachachikamaka Romamanta hatun apurayku kullkita kobra runakunawa, shu mana ali rura runakunawapas parihu mikun.— ");
INSERT INTO qvo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus paykunata uyasa rimarka: —Mana unkurisa kawsakunaka hampikamata mana minishtinakunchu. Ranti unkukunaka hampikamata minishtinakunmi. Ñukaka mana shamurkanichu —ali kani— nisa rimakunata maskankapa. Ranti mana ali rura runakunata maskankapa shamurkani Diosta uyasa kawsakuna tukunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Shu puncha Bawtisa Juan yachachiskata katikamakuna mana imata mikusa sasina puncha paktarirka. Fariseokuna niska wankuriska runa bulapas sasina puncha karka. Paykuna mana imata mikusa sasinakupi shu runakuna Jesuspama shamunakurka payta tapunkapa: —Juan yachachiskata katikamakuna, Fariseokuna niska wankuriska runa bulamanta runakunapas sasi kanakun. Imarayku kan yachachiskata katikamakuna mana sasinakunchu.— ");
INSERT INTO qvo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chasna payta tapunakupi Jesus kutiparka: —Kasarana hishtama kayaskakuna kari tukuna paykunawa tiyarapi sasinachu kanakun. Kari tukunawa parihu hishtapi kaskapi nima kari tukuna sasinchu, nima hishtama kayaska runakuna sasinakunchu ");
INSERT INTO qvo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kari tukuna pushay tukuna puncha paktaripi mana mikusa sasinakunkami— nisa pay kikin chay kari tukuna kaskata yuyachisa Jesus rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","Chaypawasha yachachisa katirka: —Yuyarichi. Mana pi mawka churarinata mushu churana pitiwa rimintanchu. Chasna rapika mushu churana piti wankuyasa mawka churarinata aysasa astawa likichinka. Chasnallata mana pipas mushu vinu putskuyaraskata mawka wiwa karamanta rurariska purupi huntachinchu. Mawka purupi huntachipi mushu vinuka chay mawka kara puruta tukyachisa talirinka. Chasna tukusa ishkaynti mana ña sirbinakunchu. Mushu vinuka mushu kara purupi huntachinami kanchi.— Chasna nisa ñupa urasmanta rukukuna kamachiskata pay mushu kamachiskakunawa parihu mana ishkayntita kasuypa kaskata Jesus yuyachirka. ");
INSERT INTO qvo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Shu samana punchapi Jesus pay yachachiskata katikamakunaynti shu trigo chakra ukuta puriranakurka. Chayta pasasa pay yachachiskata katikamakuna trigo muyu wankukunata pallasa mikunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo bulamanta maykan runa chayta rikusa piñarisa Jesusta rimakrinakurka: —Manachu rikunki kan yachachiskata katikamakuna samana puncha samana kaskata mana kasusa trigo muyuta pallasa puriranakuskata.— ");
INSERT INTO qvo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Samana puncha samana kaskata kasunarantimanta yalikta runata kuna kanchi pay minishtiskata Jesus yuyachinkapa paykunata kutiparka: —Killkariska kaskapi manachu leyiskankichichu ñukanchi yapa balichiska ñupa uras kawsa apu David paywa kaska runakunaynti yarkaranakuskapi ruraskata. ");
INSERT INTO qvo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chay uras Abiatar pakrikunapa hatun apu karka. David paypa runakunawa yarkasa Diosta mañana wasima yaykunakurka mikunata maskankapa. Chaypi Diosta rikuchina mesapi kaska pankunata chay pakri Davidta kupi mikurka. Chay laya pankunatami pakrikunalla mikukuna kanakurka. Chasna kapipas David chay pankunata mikurka. Mana chayllachu. Paywa puri runakunatapas kararka mana huchalisa.— ");
INSERT INTO qvo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesus paykunata rimasa katirka: —Samana punchaka runarayku raskami kan. Runa mana raskachu kan samana puncharayku. ");
INSERT INTO qvo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chasna kapi ñuka tukuypa ayllu kankapa Dios mantamuska runa kasa tukuyta manta apumi kani. Rimanata ushani imami ali kan samana punchapi rurankapa, imami mana ali kan rurankapa.— ");
INSERT INTO qvo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Shu samana puncha Jesus kuti Diospa shimita yachana wasima yaykurka. Chaypi shu suchu makiyu runa tiyarka. ");
INSERT INTO qvo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseo bulamanta runakunapas tiyarka. Paykuna Jesusta rikuranakurka —samana punchapi mana hampina kaskata kasunkachu unkuta hampinkachu— nisa. Payta hapichinayasa ima mana ali raskata maskasa chaparanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chasna kapipas Jesus chay suchu makiyu runata nirka: —Hatarisa kay runakuna chawpipi shayari shamuy.— ");
INSERT INTO qvo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Shayarikripi Jesus chaypi tiyakunata tapurka: —Dios sakiska killkapi paktachina kaskata kasusa samana punchapika imata ruraypa kan. Alita rana usharinchu. Rana usharinchu mana ali kaskata. Shu runata wañunamanta kishpichinata usharinchu. Wañunkapa sakinata usharinchu. Imata ninkichi.— Paykuna mana kutipanata munasa chunlla uyasa sakirinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chasna kapi Jesus paykunata piñaywa rikurka. Paykuna mana uyanayakuna kaskata rikusa chay unku runata mana llakikuna kaskatapas achkata llakirirka. Chaypi unku runata rimarka: —Kanpa makita chutachi— nisa. Jesus rimaskata uyasa makita chutachirka. Ali sakirirka. ");
INSERT INTO qvo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chay fariseo runa bula chay wasimanta llukshirka. Apu Herodeswa parihu yuyari runa bula kaskama rinakurka. Chay bulawa munturisa kwintarinakurka —imasnata Jesusta wañuchishunchi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus pay yachachiskata katikamakunaynti llakta ukumanta llukshisa Galilea kucha patama rinakurka. Achka runakuna katisa rinakurka. Maykankuna Galilea allpapi tiya llaktakunamanta kanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tukuy Judea allpapi tiya llaktakunamantapas runakuna tiyanakurka, Jerusalen llaktamanta, shu llaktakunamantapas. Idumea partimanta, Jordan yaku chimpa partimanta, Tiro Sidon llaktakunamantapas runakuna shamunakurka. Hatun ushaywa alikunata raskata yachasa shu partikunamanta runakunapas Jesuspama shamunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chasna yapa achka runakuna shamupi Jesus pay yachachiskata katikamakunata nirka: —Shu botita alichikrichi rinalla kankapa ñukanchi runakuna niti tukusa wañunamanta kishpinkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ña achka unkuskakunata aliyachipi unku runakuna Jesusta llankanayasa paypama pawanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Supay amuyaska runakuna Jesusta rikupi paykunapapi kawsa supaykunaka chay runakunata Jesuspa ñupama urmachisa kaparinakurka: —Kan Diospa Churimi kanki— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ranti Jesus sinchita paykunata rimarka: —Ñuka pi kaskata ama kwintankichichu.— ");
INSERT INTO qvo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus shu urkuma sikasa pay munaska runakunata kayarka: —Ñukama shamuychi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesus kayaskakuna paktapi paykunamanta chunka ishkay runakunata maskarka. Chay maskaskakunata apustulukuna nisa shutichirka. Munarka paywa parihu purikuna kankapa. Paykunata mantankapa munarka Diospa shimita shukunama pasachinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chasnallata munarka paykunama ushayta kunkapa supaykunata hichunkapa. ");
INSERT INTO qvo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay chunka ishkaykunamanta shu karka Simon. Payta Pedro niskata shutichirka (chay ninayan hatun rumi). ");
INSERT INTO qvo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Shukuna wawkipura kanakurka, Santiago, Juan shutiyukuna. Paykuna Zebedeopa churikuna kanakurka. Paykunata Boanerges niska shutichirka (chay ninayan rayushina runakuna). ");
INSERT INTO qvo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Shukuna kanakurka Andres, Felipe, Bartolome, Mateo, Tomas, Alfeopa churi Santiago, Tadeopas. Kuti shu karka Simon. Chay Simonka Israel allpata amuyaska runakunawa makarisa Israel ayllukunata lugaryachinaya wankuriska runa bulamanta karka. ");
INSERT INTO qvo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Shu karka Queriot llaktamanta runa Judas. Pay washa Jesusta hapichirka. ");
INSERT INTO qvo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesus kuti pay paktana wasima rirka. Achka runa kuti munturipi, mikunkapapas mana lugarta kunakurkachu. ");
INSERT INTO qvo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Paypa ayllukuna nima mikunata ushaskata yachasa, —paymi nuspayaska— nisa Jesusta pushakrinkapa paypa wasima shamunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalenmanta paktamuska Dios ñupa uras killkachiska killkata kutillata killkakamakunamanta maykankuna Jesusmanta rimanakurka: —Kay runapi supaykunapa apumi kawsan. Supaykunapa apupa ushaywami runakunamanta supaykunata hichun.— ");
INSERT INTO qvo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chasna paymanta rimanakupi Jesus paykunata kayasa yuyachina kwintukunawa yachachinkapa kallarirka. Supaykunata mana supaypa ushaywa hichuypa kaskata yuyachinkapa paykunata kasna rimarka: —Supaykunapa apuka paypa kikin aylluta hichunmachu. Manami hichunka.— ");
INSERT INTO qvo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Shu llaktallapi kawsakunata yuyarichi. Chay llaktapi kawsakunapura makarisa rimarisa kawsasaka shukma shukma rinakunka. Chay llakta runa illa sakirinka. ");
INSERT INTO qvo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chasnallata shu wasillapi kawsa ayllupura makarisa kawsasaka shukma shukma risa mana parihu sakirinkachu. ");
INSERT INTO qvo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chasnallata supaykunawapas kan. Supaykunapura piñanakusa kawsasaka mana sinchikunata ushasa yali tukunakunkami.— ");
INSERT INTO qvo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jesus yachachisa katirka supaykunapa apu sinchi wasi amushina kaskata yuyachisa: —Shuk yali sinchi runalla shu sinchi amupa wasipi yaykunata ushan amu chariskata kichunkapa. Amuta wataskawashalla pay chariskakunata kichunata ushanmi.— ");
INSERT INTO qvo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Alita uyawaychi. Ima laya huchamantapas, ima hirus shimi rimaskamantapas runakuna mañapi Dios paykunata kishpichinka. ");
INSERT INTO qvo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ranti maykan runa Diospa Samayta piñasa mana alita rima, mana ima uraspas kishpichi tukunkachu, chikapa huchata aparinka.— ");
INSERT INTO qvo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus chasna nirka —supaykunapa apumi paypi kawsan— nisa paymanta rimanakuskarayku. ");
INSERT INTO qvo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus rimaraskapi paypa mama paypa wawkikunaynti paktamunakurka. Mana wasipi yaykunata ushasa kanchamanta kwintankapa shimita Jesuspama pasachinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesuspa muyukta achka runakuna tiyariska kanakurka. Shukuna Jesuspama shimita pasachinakurka: —Kishpichiway shukratu. Kanpa mama, kanpa wawkikuna kanchapi kanta chaparanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus kutipasa nirka: —Kankunata rimaskankichi pikunami shuti ñuka ayllukuna kanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chasnapi muyukta tiyariskakunata rikusa Jesus nirka: —Kaykunami ñuka mama, ñuka wawkikuna. ");
INSERT INTO qvo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dios rimaskata paktachi runami ñuka wawki, ñuka pani, ñuka mama.— ");
INSERT INTO qvo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kutillata Jesus Galilea kucha patapi yachachinkapa kallaripi achka runakuna chaypi munturinakurka. Chasnapi Jesus shu boti ukuma yaykurka. Yaku chupinayashtuma wampurisa botipi tiyarisa yaku patapi sakiriska runakunata yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Paykunata achka yuyachina kwintukunawa unayta yachachirka. Chasna yachachiraskapi rimarka: ");
INSERT INTO qvo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—¡Kasilla tukusa alita uyaychi! Muyukunawa imasna pasanamanta yuyarichi. Shu runa chakrama tarpunkapa rirka. ");
INSERT INTO qvo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Shitasa tarpupi mayka muyukuna ñampipi urmanakurka. Chakrapi allpata ñutusa tikrachirka. Ranti ñampipi urmaska muyukunata pishkukuna shamusa mikunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mayka muyukunaka ansalla allpayu rumi tiyaskapi urmanakurka. Chay muyukuna mana yapa allpa ukupi kasa utkalla wiñanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ranti intiwa chay wiñaska muyukuna mana alita ankuyaska kasa illakta chakirinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Shu muyukunaka urmanakurka kashayu kiwapa muyukuna tiyaska allpapi, kashayu kiwapa muyukuna tiyaska allpapi. Kiwa ali muyuwa parihu wiñasa chay ali tarpu wiñaskata tapasa wañuchirka. Chayrayku chay tarpukuna mana aparinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Shu muyukunaka ali allpapi urmanakurka. Suma wiñanakurka, achkata aparinakurka. Mayka muyumanta wiñasa kinsa chunka muyuta aparinakurka, maykamanta sukta chunka muyuta, maykamanta shu pacha muyuta wankupi aparinakurka.— ");
INSERT INTO qvo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesus rimasa katirka: —Kankuna shutipa uyanata munasaka yachaychi imatami rimanayani.— ");
INSERT INTO qvo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus yachachiskata uya runakunamanta achka rinakuskawasha maykankunalla sakirinakurka. Chay sakiriska runakuna, Jesus yachachiskata katikamakunapas Jesusta mayayasa tapunakurka: —Kan yuyachina kwintuwa yachachiska imatami rimanayan.— ");
INSERT INTO qvo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chasna tapunakupi Jesus kutiparka: —Kankunallata Dios paypa shunku ukupi kaska yuyayta riksichirka, imasna pay kay allpapi runakunata amuyanka. Dios paykunata amuyankapa mana munakama runakunarayku ranti mana pasakta yuyachina kwintukunallawa yachachirani. ");
INSERT INTO qvo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chasna ñuka yachachipi mana pasakta yuyachina kwintukunallawa runakunawa tukunka imasna Dios ñupa uras killkachiska kasna: Kay runakuna ñuka ruranakunata rikunakusapas chaywa ñuka rikuchinayaskata mana yachanakunchu. Ñuka yachachiskata uyanakusapas mana yachanakunchu imamantami rimarani. Paykuna yachanakunma karka hucha ruranata sakisa ñukata uyasa kawsa runakuna tukunakunma karka. Chasna ñukawa aylluyasa huchamanta pichay tukunakunma karka— nisa Dios ñupa uras rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus muyukunamanta yuyachina kwintuwa yachachinayaskamanta tapukama runakunata rimarka: —Kankuna muyumanta yuyachina kwintuwa ñuka yachachiskata manachu yachankichi. Chasna kapi mana ushankichimi yachanata shu laya yuyachina kwintukuna yachachinayaskata. ");
INSERT INTO qvo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Muyumanta yuyachina kwintuwa kasnami ñuka rimani: Diospa shimita yachachikama runa chay kwintuwa yuyachiska shitasa tarpukama runashinami kan. ");
INSERT INTO qvo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Chay kwintuwa yuyachiska ñampipi urmaska muyukuna kasnami yuyachin: Maykan runakuna Diospa shimita uyanakun. Uyaskallapita supaykunapa apu shamusa chay shimita runakunapa yuyaymanta anchuchisa kunkachin. ");
INSERT INTO qvo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Chay kwintuwa yuyachiska ansalla allpayu rumi tiyaskapi urmaska muyukuna kasnami yuyachin: Maykan runakuna kushiyasa Diospa shimita uyanakun. ");
INSERT INTO qvo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Chasna kallapita paykunapa shunku ukupi mana yaykunata sakinakunchu. Shukratulla chay shimiwa sinchikunakun. Diosta kasunata kallariskarayku llaki shamupi, ñakachi tukunakupi, mana ña sinchikunakunchu. ");
INSERT INTO qvo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Chay kwintuwa yuyachiska kashayu kiwapa muyukuna tiyaska allpapi urmaska muyukuna kasnami yuyachin: Maykan runakuna Diospa shimita uyanakun. ");
INSERT INTO qvo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Chaywasha ranti kay pachapi kawsankapa munaskakunata yapa yuyarisa kawsanakun, kullkiyu tukunata yapa munasa, tukuy laya ruranakunata kamanayasa kawsanakun. Chasna tukusa chay Diospa shimi uyaskata kunkachinakun. Chay shimika yanka niskami kanka. ");
INSERT INTO qvo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Chay kwintuwa ali allpapi urmaska muyukuna kasnami yuyachin: Maykan runakunaka Diospa shimita uyasa alita yuyaypi wakachinakun. Diosta kasusa alikunata rasa kawsakuna tukunakun. Tarpu alita aparishina kanakun, maykankuna kinsa chunka muyuta aparishina, maykankuna sukta chunka muyuta aparishina, maykankuna shu pacha muyuta aparishina kanakunmi.— ");
INSERT INTO qvo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus kasna kwintasa yachachinata katirka: —Kankuna bilata hapichisa mala ukupi churankichimachu. Tiyarina ukupi churankichimachu. Manami ukupi churanchi. Ranti hawa partipi churanchimi pasakta rikuchinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Imasna bila pasakta rikuchin chasnallata runakuna pakalla ruraskakuna pasakta riksi tukuska kanakunka. Tukuy pakalla rimaskataka tukuykuna pasakta yachanakunka. ");
INSERT INTO qvo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kankuna shutipa uyanata munasaka yachaychi imatami rimanayani.— ");
INSERT INTO qvo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chasnallata Jesus rimarka: —Ali yuyaywa uyaychi tukuy kwintay tukuskata. Kankuna ali yuyaywa uyaska tuputa Dios kankunata yuyayta kusa yanapanka, chay tupumanta yaliktapas kunka. ");
INSERT INTO qvo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ña yuyayta chari runa yali achka yuyaywa yanapay tukunka. Mana yapa yuyayta chari runa ansa yuyay chariskatapas kichuy tukunka.— ");
INSERT INTO qvo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus shuk yuyachina kwintuwa yachachirka: —Dios kay allpapi runakunata amuyankapa rahun tarpu runa muyuta shitasa tarpunashina: Tarpu runa muyuta shitasa tarpukrima. ");
INSERT INTO qvo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chay muyukuna tukyarisa wiñanakunma. Mana imananchu puncha kapi tuta kapipas wiñanma. Tarpu runa puñupipas trabahapipas chay muyukuna wiñanakunllami. Tarpu runa mana yachapipas imasna wiñan, amu kunkaylla kapipas muyukuna wiñanakunmi. ");
INSERT INTO qvo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Allpaka pay kikinllata muyuta wiñachisa aparichinmi. Ñupara panka llukshin, washa wiñan, washa tuktun, washa wayuyan. ");
INSERT INTO qvo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wayu pukurapi amu ña pallanmi.— ");
INSERT INTO qvo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus kuti shuk yuyachina kwintuwa yachachirka: —Imata nisa riksichisha Dios kay allpapi imasna runakunata amuyanka. Kay kwintuwa kankunata yuyachisa riksichisha. ");
INSERT INTO qvo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Mostaza niska muyumanta yuyarichi. Tukuy muyukunamanta yali ichilla kan. Chasna ichillashitu tarpuy tukusapas wiñasa tukuy kiwakunamanta yali hawa tukun. Ichilla sacha kaspi yura tukusa pishkukuna llantuta maskasa paypa ramakunapi samanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chay laya yuyachina kwintukunawa Jesus paywa kaska runakunata yachachirarka, paykuna uyanata ushaskakamalla. ");
INSERT INTO qvo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kwintukunallawa tukuyta yuyachisa rima karka. Ranti washa pay yachachiskata katikama runakunallawa sakirisa kwintukunawa yuyachinayaskata pasakta kwintarka. ");
INSERT INTO qvo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesus runakunata kwintukunawa yuyachisa yachachiska chishillapita ña tutayaraskapi pay yachachiskata katikamakunata nirka: —Hakuychi kucha chimpa partima.— ");
INSERT INTO qvo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesus rimaskata uyasa pay yachachiskata katikamakuna paykunawa munturiska runakunata sakinakurka. Jesus tiyariska botillapita payta pushanakurka. Maykan runakuna karan shu botipi paykunawa parihu rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ña chimparaskapi sinchi wayra kallarirka. Hatun ulaskuna hatarinakurka. Yaku sinchita waktarisa botipi yaykurka. Ñalla pampariranakurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Chasnapi Jesus boti sikipi sawnapi kunkaylla puñurarka. Pay yachachiskata katikamakuna yapa manchaywa kasa Jesusta kawsachikrinakurka. Kaparisa rimanakurka: —¡Yachachikama, pampariranchimi! Ñukanchi chinkarinamanta kanta manachu llakinayan.— ");
INSERT INTO qvo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus kawsarisa wayrata ulaskunatapas sinchita rimarka: —¡Pasarichi!— Chasna rimaskallapi wayra ulaskunapas pasarinakurka. Chunlla tukurka. ");
INSERT INTO qvo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus chasnapi pay yachachiskata katikamakunata nirka: —Imaraykuta manchaywa kahunkichi. Chayra manachu ñukawa sinchikunkichi.— ");
INSERT INTO qvo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paykunapura yapa mancharisa rimarinakurka: —Manapacha, pita kan kay runa. Wayra yakupas payta uyanakunmi.— ");
INSERT INTO qvo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Galilea kuchata chimpasa Jesus pay yachachiskata katikamakunaynti Gerasa niska pampama paktanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Paktasa Jesus botimanta llukshiskapi supay amuyaska runa Jesuspama shamurka. Chay runa wañuskakunata churay tukuska urku hutkukunamanta llukshisa Jesuspama mayayarka. ");
INSERT INTO qvo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pay kawsa kaska wañuskakunata churay tukuska rumi hutkukunapi. Waklichisa puriraskapi mana pi usharkachu payta harkanata. Hapisa kadenakunawa watasapas mana charipa karka. ");
INSERT INTO qvo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Achka kuti payta kadenakunawa watanakuska karka. Hirumanta raku anillukuna makipi chakipi churasa hapinakuska karka. Chasna kallapita kadenakunata piti piti rasa llukshirka. Hirumanta raku anillukunatapas paki paki rasa kishpirka. Mana pi payta hapisa charinata usharkachu. ");
INSERT INTO qvo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tutaynti punchaynti runa wañuskakunata churay tukuska rumi hutkukunapi chay mayapi kaska urkukunapipas manchaypa layata uyachisa puri karka. Rumikunawa amullata waktarisa kuchu kuchu rasa purirarka. ");
INSERT INTO qvo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Karumanta Jesusta rikusa kallpamusa paypapi kunkurirka. ");
INSERT INTO qvo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Manchaypata kaparisa rimarka: —Tukuymanta yali Diospa Churi Jesus, ay manapacha imata ñukawa ruranayanki. Dios Yaya llakichi kaskarayku kanta mañani: —Ama ñukata ñakachiwaychu.— ");
INSERT INTO qvo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesus chay supayta ña rimaraska karka: —Hirus supay, kay runamanta llukshi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kuna payta tapurka: —Ima shutita kanki.— Tapupi kutiparka: —Ñuka shutika Hatun Bulami, yapa achka kaskamanta.— ");
INSERT INTO qvo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chaypi kuti kuti Jesusta mañaranakurka: —Kay ñukanchi kawsaraska allpamanta ama ñukanchita hichunkichu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chay uras mana karunayashtupi shu achka kuchi bula shuk urku waykupi mikuranakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chay kuchikunata rikusa chay supaykuna Jesusta mañanakurka: —Ñukanchita mantay kuchikunapi yaykunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus alimi nipi supaykuna chay runa ukumanta llukshisa kuchikunapi yaykukrinakurka. Chasnapi chay ishkay waranka tupu kuchikunaka urkumanta kallpasa yakuma shitarisa chukallisa wañunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chayta rikusa kuchita kuyrakuna kallpasa llaktama rinakurka. Kallpa riraskapi tukuy partipi, ichilla llaktakunapi, hatun llakta ukupipas, tukuy ima pasaskata kwintanakurka. Uya runakunaka kallpa rikukrinakurka shutipachu kuchikuna chinkarinakuska manachu nisa. ");
INSERT INTO qvo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesuspama paktasa chay supaykunamanta kishpichi tukuska runata Jesuswa parihu tupakrinakurka. Chay Jesus aliyachiska runa kunkaylla tiyaraskata riku shamunakurka, ali churariska kaskata. Ali yuyayuta tupa shamunakurka. Chayta rikusa yapa manchanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chay supaykuna yaykunakuska runawa, kuchikunawapas pasaskata rikusa runakuna chay paktaska runakunata tukuyta kwintanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chayta uyasa chay runakuna Jesusta mañankapa kallarinakurka: —Kaymanta llukshipay— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mañanakupi uyasa Jesus kuti botima rirka. Botipi Jesus yaykurapi chay supaykunamanta kishpichi tukuska runaka payta mañarka: —Pushaway— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mana munasa Jesus chay aliyaska runata nirka: —Kanpa wasima ri. Kanpa ayllukunata kwintakri Dios kanta yapa llakisa kanpa alipa ruraskata.— ");
INSERT INTO qvo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chasna nipi chay runa wasima rirka. Chaywasha chay allpapi tiya Chunka Llaktakunama risa kwintarka Jesus payta aliyachiskamanta. Chasna chay aliyaska runa kwintapi tukuy uyakuna mancharinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus Galilea kucha chimpa partima kuti paktamupi achka runakuna kucha mayapi muyukta paywa munturinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chasnapi Jairo shutiyu runa paypama shamurka. Jairo chay llaktapa Diospa shimita yachana wasita rikukamakunamanta shu rikukama karka. Jairo rikuraska Diospa shimita yachana wasi Galilea kuchamanta mana yapa karupi karka. Jairo kucha mayama risa Jesusta rikurka. Hatun aputashina yuyarisa paypa ñupapi kunkurirka. Allpakama kumurisa mañarka: ");
INSERT INTO qvo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Ñuka ushushi wañurapami. Utkalla shamupay. Kanpa makiwa payta llankapika aliyasa kawsankami.— ");
INSERT INTO qvo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chasna mañapi Jesus paywa rirka. Achka runakuna tankasa tankasami katiranakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jesuswa parihu puri runa bula ukupi shu unkuska warmi rirarka. Chunka ishkay watata yawar talirisa kawsa karka. ");
INSERT INTO qvo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hampikamakunama purisa kawsarka. Hampikamakuna —kanta hampisha— nisa chay warmi tukuy laya ruraskakunawa ñakariska. Chasna puriskapi achkata pagasa tukuy chariskata tukuchirka. Ranti mana aliyarkachu. Astawa astawa tukusa wañunayarkami. ");
INSERT INTO qvo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chay warmi manara runa bula ukupi kasa Jesusmanta kwintanakuskata uyarka. Chasna kasa Jesuswa tuparikrinkapa rirka. Paktasa achka runa chupipi Jesusta katirka. Washamanta Jesusma mayayarisa paypa churanata llankapi Jesus yawar taliri warmirayku hatun ushaywa raskata rarka. ");
INSERT INTO qvo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","—Jesuspa churanata llankasallata aliyashami— nisa chay warmi yuyarirka. ");
INSERT INTO qvo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Llankapi paypa yawar talirinata sakirirka. Tukuy aycha aliyaskata yacharka. ");
INSERT INTO qvo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chasnallapi Jesus paypa ushaymanta ushay llukshiskata yachasa washama rikusa tapurka: —Pita ñukapa churanata llankarka.— ");
INSERT INTO qvo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pay yachachiskata chunka ishkay katikama runakuna kutipanakurka: —Runakuna tanlla riraskapi puriranchi. Imasna tapunki —pita llankawarka— nisa.— ");
INSERT INTO qvo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ranti Jesus muyukta rikurasa katirka —pimi llankawarka— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chasna Jesus rikurapi Jesusta llankaska warmi hampiriskata yachasa manchaywa chukchurirka. Jesuspa ñupapi kunkurikrirka. Chasnapi Jesusta tukuy imasna kaskata pay raskatapas kwintarka. ");
INSERT INTO qvo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chay warmi kwintapi Jesus payta nirka: —Llakiska panishtulla, ama manchaychu. Kan ñukawa sinchikuskarayku hampirirkanki. Kushilla ri. Tukuy kan ñakariskamanta kishpichi tukuska kanki.— ");
INSERT INTO qvo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus chayra rimarapi chay rikukama Jairopa wasimanta mantaska runakuna shamuranakurka. Paktamusa Jairota rimanakurka: —Kanpa ushushi ña wañuskami. Yachachikamata ama astawa killachinkichu.— ");
INSERT INTO qvo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus paykuna rimanakuskata uyasa Jairota rimarka: —Ama manchaychu, ñukawa sinchikuylla.— ");
INSERT INTO qvo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chasnapi paywa rira runa bulata —kaykamalla ñukawa rinkichi— nisa Jesus pay yachachiskata kinsa katikamakunallawa Jairowa rirka. Pedrota, Santiagota paypa wawki Juantapas Jesus pushasa rirka. ");
INSERT INTO qvo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ña chay rikukama Jairopa wasima paktanakuskapi Jesus rikurka achka runakuna karanma puriranakuskata. Sinchi kaparisa wakaranakuskata uyarka. ");
INSERT INTO qvo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wasima yaykusa Jesus paykunata rimarka: —Imarayku chasna karanma purirasa wakarankichi. Kay wawa mana wañuskachu, puñuranmi.— ");
INSERT INTO qvo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chasna rimapi chay runakuna Jesusta asinakurka. Ranti Jesus paykunata llukshichisa paywa shamuskakunallawa wañuska wawa siriraskama yaykurka. Wawapa yayata mamatapas ukuma pusharka. ");
INSERT INTO qvo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wawata makimanta hapisa payta rimarka: —Talita kumi.— Chay ninayan: Ushushi hatari. ");
INSERT INTO qvo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jesus rimaskallawa wawa hatarisa purinkapa kallarirka. Chunka ishkay watayu karka. Tukuy rikukuna kushiyasapas yapa mancharinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus paykunata sinchi shimiwa rimarka: —Ama pitapas kay pasaskata kwintaychichu. Kunaka wawata karaychi.— ");
INSERT INTO qvo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus pay yachachiskata katikamakunaynti Galilea kucha mayamanta llukshisa paypa kikin llaktama paktarka. ");
INSERT INTO qvo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samana puncha Diospa shimita yachana wasipi yachachirarka. Chasnapi payta uyakuna mancharisa paykunapura rimarinakurka: —Maypita chasna yapakta yachakurka. Imasna pay chasna llakiwa kamachinata yachak tukurka. Hatun ushaywa ranakunata rankapa pipamanta chay ushayta charin. ");
INSERT INTO qvo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Karpintero runallami kan, Mariapa churi. Paypa wawkikunatapas riksinchi. Kanakun Santiago, Jose, Judas, Simonpas. Paypa panikunapas kaypi kawsanakun.— Chasna payta mana balichisa Jesusmanta piñarinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chasna kapi Jesus yaya rukukunamanta yachaska rimanawa, tukuy runa riksiska rimanawa paykunata kasna rimarka: —Dios rimaskata kwinta runata tukuy parti runakuna balichisa alita uyanakun. Paypa kikin llaktallapi Jesusta riksikuna, paypa ayllukunapas mana uyanata munanakunchu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chay runakuna mana yachanayanakurkachu Jesus Dios mantamuska kaskata. Chasna mana paywa sinchikunayapi Jesus chay llaktapi mana usharkachu runakunata yanapasa hatun ushaywa ruranakunata rurankapa. Maykan unku runakunallata paypa makita paykunapapi churasa hampirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chay llaktapi kawsa runakuna paywa mana sinchikunakuskamanta Jesus yuyarisalla sakirirka. Chasna kasa Nazaret llaktamanta llukshirka. Karan maya llaktakunama purisa runakunata Diosmanta yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus shu puncha pay yachachiskata chunka ishkay katikamakunata muntuchirka. Ishkay ishkayta shu partima shu partima mantankapa kallarirka. Chasna mantasa ushayta kurka runakunamanta supaykunata hichunkapa. ");
INSERT INTO qvo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Manara mantasa paykunata kamachisa rimarka: —Ñampita rirasa ama imatapas apankichichu. Shikrata, mikunata, kullkita ama apankichichu. Kankunapa sinchikuna kaspillata apaychi. ");
INSERT INTO qvo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kankuna munasaka chakipi churarinata churarisa rinkichi. Kankuna churariskallawa richi.— ");
INSERT INTO qvo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chasnallata rimasa katirka: —Shu llaktama paktasa puñunkapa wasita maskankichi. Chay wasillapi sakirinkichi llaktamanta llukshinakama. ");
INSERT INTO qvo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maykan llaktapi kankunata mana yaykuchinata munanakunka, mana uyanata munanakunka. Chasna kasa runakunama paykuna mana uyanata munaskarayku Diospa ñupapi huchayu kaskata rikuchisa chakimanta allpata chawsi chawsi rurasalla llukshinkichi.— ");
INSERT INTO qvo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chasna kamachi tukusa Jesus yachachiskata katikama runakuna rinakurka runakunata yachachinkapa: —Kankuna huchata ranata sakichi Diosta ña kasusa kawsankapa— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chasnallata achka supay amuyaska runakunamanta supaykunata llukshichinakurka, achka unku runakunatapas wirawa hawisa aliyachinakurkami. ");
INSERT INTO qvo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tukuy parti runakuna Jesusmanta kwintapi apu Herodespas paymanta uyarka. Maykan runakuna rimanakurka: —Chay runa Bawtisa Juanmi, wañuskamanta kawsarimuskami. Chayrayku hatun ushaywa ranakunata ranata ushanmi.— ");
INSERT INTO qvo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Shukuna ranti rimanakurka: —Chay runa Dios rimaskata kwinta runa Eliasmi.— Shukunaka kuti rimanakurka: —Chay runa Dios rimaskata kwinta runakunamanta shukmi Dios rimaskata ñupa uras kwintakunashina.— ");
INSERT INTO qvo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Apu Herodes runakuna kwintaskata yachasa rimarka: —Chay runa bawtisa Juan kanami kan. Ñuka paypa umata pitinkapa mantasa wañuchiskani. Kuna ranti wañuskamanta kawsarimuskami— nirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Juan manara wañuchi tukusa kasna pasarka. Apu Herodesllata Juanta hapichinkapa mantaska karka. Payta kadenawa watachisa mana ali rurakunata tapana wasipi tapachiska karka, warmi Herodias chasna munaskarayku. Chay warmika ñupa uras apu Herodespa wawki Felipepa warmi karka. Herodes paypa wawkita kichusa chay warmiwa kasarasa kawsararka. Chay warmita kushiyachinkapa Juanta chasna rarka. ");
INSERT INTO qvo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan manara tapay tukuska uras Herodesta rimasa katirka: —Mana alichu kanpa wawkipa warmiwa kawsankapa— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chayrayku chay warmi Herodias Juanmanta yapa piñarisa kawsarka: —Payta wañuchisha— nisa. Ranti mana usharkachu. ");
INSERT INTO qvo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Apu Herodes Juanta mancharkami: —Ali runami kan, Diosta sirbi runa— nisa. Chayrayku apu Herodes Juanta kuyrarka paypa warmi wañuchinamanta. Juanta kayachisa kamachiskata uyanata gustarka. Chasna kapipas yapa mancharisa uyarka. ");
INSERT INTO qvo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Shuk puncha pay pakariska puncha paktariskarayku apu Herodes hatun hishtata rarka. Payta yanapakama apukunata mikunkapa kayarka, suldaru apukunata, Galileamanta sinchikunkapa yanapa runakunatapas mikunkapa kayarka. Chay puncha apu Herodespa warmi Herodias Juanta ruranayaskata paktachina puncha paktarirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chay hishtapi mikuranakuskapi Herodiaspa ushushi tukuykuna gustankapa sapalla tushurka. Apu Herodes paywa kaskakunaynti Herodiaspa ushushi tushuraskata yapa gustanakurka. Chayrayku apu Herodes ushushi tukuta rimarka: —Kan imatapas mañawapi kuskankimi. ");
INSERT INTO qvo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Shuti paktachishami: Imata kan mañawapipas kanta kuskanki. Ñuka apu karguta chupita mañawapipas kanta yaykuchiskanki.— ");
INSERT INTO qvo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Herodes chasna rimaskata uyasa Herodiaspa ushushi mamapama tapukrirka: —Imatata mañasha.— Paypa mama kutiparka: —Bawtisa Juanpa umata mañanki.— ");
INSERT INTO qvo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pay urastalla kuti apu Herodespama risa rimarka: —Kunallata Bawtisa Juanta wanchinkapa mantay. Shuti wañuska kaskata ñuka rikunkapa Juanpa umata kallanapi churaskata kuwanki. Chayta munani— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mañaskata uyasa apu Herodes yapa llakirirka. Ranti hishtama shamuska runakuna uyaranakuskapi ushushi tukuta rimaskarayku: —Kan mañawaskata kusa shuti paktachishami— nisa mana usharkachu mitsankapa. ");
INSERT INTO qvo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chay urasllapita shu suldaruta mantarka: —Umata pitisa Juanta wañuchikrisa paypa umata apamunki— nisa. Suldaruka rirka. Mana ali rurakunata tapana wasima paktasa Juanpa kunkata pitisa wañuchirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Juanpa umata kallanapi churasa Herodias ushushipama apamurka. Chay ushushi ranti paypa mamama kukrirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan yachachiskata katikamakuna paykunapa yachachikama wañuchi tukuskata yachasa Juanpa ayata apakrinakurka. Tukuy wañuska runawa raskashina rumi hutkupi churasa tapanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apustulukuna purisa puriskawasha kuti Jesuspama rinakurka. Jesuswa munturisa tukuy raskakunata kwintanakurka, yachachiskakunatapas. ");
INSERT INTO qvo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Achka runakuna shamusa llukshisa mana ushaypa tukunakurka. Jesus mikunkapa runakuna nima mana lugarta kunakurkachu. Chayrayku pay yachachiskata katikamakunata Jesus rimarka: —Runa illa partima hakuychi ansata samankapa.— ");
INSERT INTO qvo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chasna Jesus rimapi parihu shu botipi yaykusa runa illa partima chimpanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ranti runakuna pikuna kaskata riksisa paykuna riraskata rikuranakurka. Achka llaktakunamanta runakuna ñampita kallpasa risa manara Jesus paktaskapi ñupakta paktanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus chayma paktasa botimanta llukshisa achka runakunata rikusa paykunamanta llakirirka: —Chay runakuna kuyra illa borregukunashina kanakun— nisa. Chayrayku unayta paykunata achkata yachachirarka. ");
INSERT INTO qvo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ña tutayaraskapi pay yachachiskata katikamakuna Jesusta rimanakurka: —Ña chishiyanmi, kay pampapi wasi illami. ");
INSERT INTO qvo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kay runakunata rimay maya wasikunapi, maya llaktakunapipas mikunata rantikrinkapa— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus ranti paykunata rimarka: —Kankunallata karaychi.— Paykuna rimanakurka: —¡Manapacha, chawpi wata ganaskamanta yalita minishtinchima tukuy chay runakunata karankapa! ¡Mana raypa kaskata ñukanchita rimanki!— ");
INSERT INTO qvo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus tapurka: —Masna mikunata charinkichi. Rikukrichi.— Pay yachachiskata katikamakuna rikukrinakusa kuti paktamusa rimanakurka: —Pichka pan ishkay challwapas tyanmi.— ");
INSERT INTO qvo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chayta uyasa Jesus nirka: —Runakunata allpapi tiyarichichi.— ");
INSERT INTO qvo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tiyarinkapa rimanakupi runakuna achka bulakunapi munturisa kiwa hawapi tiyarinakurka. Shuk bulakuna shuk pacha runakunawa kanakurka, shuk bulakuna pichka chunka runakunawa. ");
INSERT INTO qvo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chaywasha Jesus chay pan kuy tukuskata challwakunatapas hapisa, hawama rikusa Diosta pakrachurka. Pankunata pakisa pay yachachiskata katikamakunama kurka runakunata karankapa. Chasnallata chay ishkay challwawapas rarka. ");
INSERT INTO qvo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chasna Jesus yachachiskata katikamakuna runakunata karapi tukuy saksakta mikunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mikuskawasha puchuskata pallasa chunka ishkay ashankata huntachinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chay karay tukuska runakuna karikunallata yupasa pichka waranka kanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesus achka runata karaskawasha pay yachachiskata katikamakunata rimarka: —Kunashitu botipi chimpa partima richi. Ñukamanta ñupakta Betsaida niska llaktama chimpaychi. Ñuka chayra runakunata —samashu— nisa rinakama chapasha.— Chasna rimasa Jesus sakirirka runakuna —samashu— nisa rimanakama. ");
INSERT INTO qvo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Runakuna riskawasha Jesus shuk urkuma sikarka sapalla Dioswa kwintarinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tutayaskapi Jesus yachachiskata katikamakunapa boti chupi kuchapi rirarka. Jesuska sapalla kucha mayapi sakirirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pay yachachiskata katikamakuna sinchita kawiranakuskata rikurka, ñawipuramanta wayra sinchita nitichiskarayku. Ña pakarina mayapi Jesus yaku hawata purisa paykunapama mayayarka. Ña paykuna mayapi kasa pasakta rinashina rasa rikuchirka. ");
INSERT INTO qvo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Paykuna ranti payta yaku hawata puriraskata rikusa alma kaskata yuyarinakurka. Mancharisa —¡ayami!— nisa kaparinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tukuykunami payta rikusa yapa mancharinakurka. Chasna mancharinakupi Jesus utkalla paykunata rimarka: —Sinchikuychi ñukami kani. Ama manchaychichu.— ");
INSERT INTO qvo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chasnapi Jesus boti ukuma yaykurka. Chay uraslla wayra pasarirka. Chayta rikusa astawa mancharinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mana yuyarinata ushanakurkachu Jesus manara chimpanata kallariskapi pankunata mirachiskawa hatun ushayu kaskata rikuchiskata. ");
INSERT INTO qvo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kucha chimpama Jesus pay yachachiskata katikamakunaynti Genesaret niska partima paktasa llutarisa botita watanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Allpama llukshiska urasllapita runakuna Jesus kaskata riksinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chasna payta riksisa Jesus paktaskata tukuy partima runakunama kwintankapa rinakurka. Runakuna unkuskakunata katanapi churasa maypipas Jesus kaskama pushamunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus llaktakuna ukupi purisa, llakta mana kaskapi purisa maypipas kapi runakuna unkuskakunata munturina pampakunapi sirichinakurka. Jesusma mayayasa mañanakurka: —Unkuskakunapama mayayasa kanpa churana puntashtullatapas llankachipay— nisa. Tukuy Jesusta llankakuna aliyaska tukunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Shu puncha Jerusalen llaktamanta fariseo bulamanta runakuna Dios ñupa uras killkachiska killkata kutillata mayka killkakamakunaynti Jesuspama paktanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Chayma paktaska runakuna Jesus yachachiskata katikamakunamanta maykankuna makita mana mayllasa mikuranakuskata rikunakurka. Ñupa uras kawsa rukukuna yachachiskashina ñukanchi Israel runakuna mana mikunchichu imana maki mayllana kaskata mana mayllaskawa. Chasnallata rantichina tampukunamanta kuti wasima risa ñukanchi yachachi tukuskashina mayllarisalla miku kanchi. Yali achka yachachiskakunatapas paktachisa kawsanchi: Wishinakunata, kallanakunata, mankakunata, pilchikunatapas imasna mayllana kaskata. Chay fariseo bulapi wankuriska runakuna tukuy runakunamanta yali chaykunata paktachisa kawsakuna kanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chasna kasa fariseokuna chay killkakamakunaynti Jesusta tapunakurka: —Imaraykuta kan yachachiskata katikamakuna ñukanchipa ñupa uras kawsa rukukuna yachachiskata mana ranakun. Paktachinarantimanta makita mana mayllasa miku kanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chasna tapunakupi Jesus kutiparka: —Yanka shutipashina rikuchikama runakuna kankichi. Dios rimaskata kwinta ñupa uras kawsa runa Isaias alita rimasa killka karka. Kankunashina runakunamanta killkarka, yanka ali runashina tuku runakunamanta. Dios rimaskata kasna killkarka: Kay runakuna rimasalla ñukata balichinakun ranti paykunapa kikin shunku ukumanta mana balichiwanakunchu. ");
INSERT INTO qvo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","—Diosta kushiyachishu— nisa paykuna ruraskakuna nima imapa mana balinchu. Paykuna yachachiskaka runapa yuyaymanta surkuska paktachinakunallami kanakun nisa Isaias kankuna laya runakunamanta yuyachisami Dios rimaskata killkarka. ");
INSERT INTO qvo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kankunaka Isaias killkaska shutipa kaskata alipacha rikuchinkichi. Dios runa paktachinkapa rimaskata kasunaranti ñupa uras kawsa rukukuna yachachiskata kasunkichi. ");
INSERT INTO qvo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus paykunata rimasa katirka: —Kankuna yapa yuyaysapa kankichi yuyarinkapa imasna rasa Dios runa paktachinkapa rimaskata mana kasunata ushaypa kanma. Ñupa urasmanta yachachi tukuskata katinata ushankapa kankuna Dios rimaskata hichunkichi. ");
INSERT INTO qvo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moises ñupa uras Dios runa paktachinkapa rimaskata killkaskawa kankunata yuyachisha. Kasna Dios runa paktachinkapa rimaskata killkarka: Kanpa yayata, kanpa mamata balichisa uyana kanki nisa. Chasnallata killkarka: Mayka runa paypa yayata mamata piñasa hirusta rimasaka wañuchi tukuna kan nisa Moises killkarka. ");
INSERT INTO qvo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kankuna ranti yachachinkichi: —Shu runa paypa yayata, mamatapas rimama: —Ñuka kankunama kuyana kaskata Diosma kuyarkani. Chayrayku kankunata yanapankapa mana ña tiyawanchu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chasna rima runa yayata mamata ña mana yanapana kanchu— nisa yachachinkichi. ");
INSERT INTO qvo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chasna kankuna yachachipi Dios runa paktachinkapa rimaskata mana balichinkichichu kankunapa rukukuna yachachiskata paktachinkapa. Yali achka chasna laya ruranakunata rankichimi.— ");
INSERT INTO qvo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chasnapi Jesus chaypi munturiska runakunata kayasa rimarka: —¡Tukuy kankuna uyawaychi! Kayta yachakuychi: ");
INSERT INTO qvo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Imapas kanchamanta yaykun runa ukupi chayka mana payta harkanchu Diosma mayayankapa. Ranti imapas runamanta llukshin, chay mana ali rimanakuna, chay shuti runata harkan Diosma mayayankapa. ");
INSERT INTO qvo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kankuna shutipa uyanata munasaka yachaychi imatami rimanayani.— ");
INSERT INTO qvo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chasna nisa Jesus tapunkapa shamuska runakunata sakisa pay yachachiskata katikamakunawa paktana wasima rinakurka. Yaykupi pay yachachiskata katikamakuna payta tapunakurka: —Kan chasna yuyachina kwintuwa imatata yachachinayanki.— ");
INSERT INTO qvo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesus paykunata kutiparka: —Kankunapas yuyay tapariskachu kankichi. Manachu yachankichi imapas kanchamanta yaykun runa ukupi chayka mana payta harkanchu Diosma mayayankapa. ");
INSERT INTO qvo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Imapas kanchamanta runapi yaykun chayka mana shunkupi yaykunchu, astawa wiksapimi yaykun, chaywasha ismapi hichurin.— Jesus chasna nisa tukuy laya mikuna ali kaskata yuyachisa yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Washa rimasa katirka: —Imapas runa shunku ukumanta llukshin chay shuti runata harkan Diosma mayayankapa. ");
INSERT INTO qvo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Runapa shunku ukumanta mana ali yuyaykuna llukshinakun. Chay yuyaykunata paktachisa runa tukuy laya hiruskunata rasa kawsan. Maykanwapas kawsan. Shuwan. Runata wañuchin. ");
INSERT INTO qvo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Shukpa warmita hapin. Tukuy uras yalikta charinata munan. Mana alita ran. Shukunata llullachin. Mana pinkarisa kawsan. Shukpa chariskata munasa kawsan. Amu mana uyaskapi paymanta mana alita riman. —Tukuymanta yali balimi kani— nisa kawsan. Mana yuyarisa alichu manachu nisa imatapas rurasa kawsan. ");
INSERT INTO qvo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tukuy chay mana alikunata rurachi yuyaykuna runa shunku ukumanta llukshinakun. Chasna yuyaykuna shuti runata harkan Diosta mayayankapa— nisa Jesus rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Shuk puncha Jesus Israel allpamanta llukshisa Tiro llakta maya partima rirka. Paktasa shu wasima yaykurka —mana pi ñuka kaypi kahuskata yachachu— nisa. Ranti mana usharkachu chaypi kunkaylla samasalla kankapa. ");
INSERT INTO qvo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Shu warmi Jesus paktamuskata yachasa paypama rirka paypa ushushi supay amuyaska tukuskarayku. Chay warmi mana Israel bulamanta warmichu karka. Siria allpapi Fenicia niska partimanta warmimi karka. Jesuspa ñupapi kunkurisa paypa ushushimanta mañarka: —Supayta ñuka ushushimanta hichupay— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chay warmi mañarallapita Jesus Israel runakunamalla Dios payta mantaskata yuyarisa chay warmita rimarka: —Wawakuna ñupakta mikunakuchu. Wawakunapa mikunata kichusa allkushitukunama shitana mana alichu.— ");
INSERT INTO qvo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chasna rimapi chay warmi nirka: —Alita rimanki, chasnami kan, Señor. Chasna kapipas wawakuna mikuskamanta urmaskata allkushitukuna mesa ukupi miku kanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus rimarka: —Rilla, kan chasna alita rimawaskarayku kanpa ushushi ña aliyarka. Supay ña paymanta llukshiskami.— ");
INSERT INTO qvo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chay warmi wasima rirka. Paypa ushushi puñunapi ganas siriraskata tuparka. Supay llukshiska karka. ");
INSERT INTO qvo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro llakta maya partimanta llukshisa Sidon llaktata muyukrisa pasasa Jesus kuti Galilea kuchama rirka. Kucha mayapi Chunka Llaktakuna niskama paktarka. ");
INSERT INTO qvo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chaypi upa nikri harka harka kwinta runata Jesuspama pushamunakurka: —Kanpa makiwa llankasa kay unku runapa hawapi churapay— nisa mañanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus chay runata shuk partima pushasa rirka. Sapalla kaskapi paypa maki diduta chay runapa nikri ukupi satirka. Chaywasha tyuka yakuwa paypa kallupi tupachirka. ");
INSERT INTO qvo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chasnapi hawama rikusa samay pitikta aburisa —Efata— nisa rimarka. Chay rimanayan “paskariska kay”. ");
INSERT INTO qvo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chasnapi chay runapa nikri paskarirka. Paypa kallu aliyasa alita rimankapa kallarirka. ");
INSERT INTO qvo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chay runawa kuti runakunapama paktasa Jesus chay runakunata rimarka: —Ama pitapas kwintankichichu kay runata ñuka aliyachiskata— nisa. Jesus runakunata astawa astawan rimapi mana kwintankapa, chay runakuna astawa tukuykunama kwintanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chay runa aliyaskata riku runakuna yapa mancharinakurka. Ñupa urasmanta Dios mantana kishpichi runamanta killkariska kaskata yuyarinakurka. —Kay runa chay kishpichi runachu— nisa yapa mancharisa rimanakurka: —Tukuyta alita ruran. Upa nikriyukunata uyakunata ran. Mana kwinta runakunata pasakta kwintata ran.— ");
INSERT INTO qvo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Shu puncha kuti achka runa Jesusta katisa munturinakurka. Mikuna illapi Jesus pay yachachiskata katikamakunata kayasa nirka: ");
INSERT INTO qvo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kay runakunamanta llakirinimi. Ña kinsa punchata ñukawa kanakun. Paykunapa mikuna ña tukuripi mikuna illami kanakun. ");
INSERT INTO qvo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Maykankuna karumanta shamunakurka. Paykunata mana karasa mantapika wasima rina ñampipi sampayasa dismayanakunka.— ");
INSERT INTO qvo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ranti pay yachachiskata katikamakuna payta rimanakurka: —Kay runa illa pampapi imasnata mikunata tuparinka kay tukuy runakunata karankapa. Mana raypachu.— ");
INSERT INTO qvo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chasna rimanakupi Jesus tapurka: —Masna pankunata charinkichi.— —Kanchislla— rimanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chayta uyasa Jesus runakunata rimarka: —Allpapi tiyarichi— nisa. Chaywasha chay kanchis pankunata hapisa Diosta pakrachurka. Chay pankunata paki paki rasa pay yachachiskata katikamakunama kurka runakunata karankapa. Paykuna tukuy chay runakunata karakrinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chasnallata ansa challwatapas charinakurka. —Kay challwa mikuskashtuwa runakuna sinchikunakuchu— nisa Jesus challwakunata pay yachachiskata katikamakunama kurka: —Runakunata karaychi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chasna karay tukusa runakuna saksakta mikunakurka. Jesus yachachiskata katikamakuna puchuskata muntuchisa kanchis ashankata huntachinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chay mikuska runakunaka chusku warankashi kanakurka. Ña mikuskawasha Jesus paykunata —samashu— nisa wasima mantarka. ");
INSERT INTO qvo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chaywasha pay yachachiskata katikamakunaynti botipi yaykusa Dalmanuta niska partima rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesus Dalmanuta niska partima paktapi fariseo bulamanta runakuna paypama shamunakurka. Paywa piñarisa rimarinkapa kallarinakurka. Chasnapi payta kamasa rimanakurka: —Hatun ushaywa shuk ruranata rikuchi ñukanchi kan Dios mantamuska kaskata yachankapa— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chay runakuna mana paywa sinchikunayapi Jesus samay pitikta llakirisa rimarka: —Imapata kay mana Dioswa sinchiku runakuna hatun ushaywa shuk ruranata mañawanakun. Alita uyawaychi. Hatun ushaywa shuk ruranata manami rikuchi tukunakunkachu.— ");
INSERT INTO qvo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chasnapi Jesus chay fariseokunata chayllapi sakisa kutillata pay yachachiskata katikamakunawa botipi yaykusa chimpankapa kallarirka. ");
INSERT INTO qvo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesus yachachiskata katikamakuna mikunata mana apanakuska karka. Chasna Jesuswa Galilea kuchata chimparanakuskapi shuk panllata botipi charinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Rihuskapi Jesus paykunata nirka: —Yuyankichi. Fariseo bulamanta runakunapa pan punkichinamanta kuyrarisa kawsaychi, apu Herodespa pan punkichinamantapas.— ");
INSERT INTO qvo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chasna nipi pay yachachiskata katikamakuna paykunapura rimarinakurka: —Ñukanchi mana panta apamuskarayku chasna riman.— ");
INSERT INTO qvo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus payllata shunkupi yachasa nirka: —Imaraykuta panta mana apamuskarayku rimarinkichi. Chayra manachu yachakuskankichi. Mana yuyarinata usha kankichi. ");
INSERT INTO qvo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ñawiyu kasallata manachu rikunkichi. Nikriyu kasallata manachu uyankichi. Ñachu kunkariskankichi. ");
INSERT INTO qvo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ñuka pichka panllawa pichka waranka runakunata karaska uras, masna ashankata puchuskawa huntachirkankichi.— Paykuna kutipanakurka: —Chunka ishkay ashankata.— ");
INSERT INTO qvo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesus kuti tapurka: —Chay kanchis panwa ñuka chusku waranka runakunata karaskapika masna ashankata puchuskawa huntachirkankichi.— —Kanchis ashankata— nisa kutipanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chasna kutipanakupi Jesus nirka: —Chayra manachu yachakunkichi.— ");
INSERT INTO qvo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus pay yachachiskata katikunaynti Betsaida niska llaktama paktanakuskapi runakuna shu ñawsa runata Jesuspama pushamunakurka, —payta llankapay— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus ñawsa runapa makita hapisa aysasa llakta kanchama pusharka. Paypa ñawikunata tyuka yakuwa hukuchisa, paypa hawapi makita churasa, tapurka: ");
INSERT INTO qvo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","—Shuk imatapas rikunkichu.— Ñawsa runa ansata rikunkapa kallarisa nirka: —Runakunata purira yurakunashinata rikurani.— ");
INSERT INTO qvo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chasna nipi Jesus kutillata makita paypa ñawi hawapi churarka. Chasna rapi ñawsa runaka ña alita rikurka. Paypa ñawikuna hampiriska sakirirka, ña karumanta tukuyta pasakta rikurka. ");
INSERT INTO qvo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chasna tukupi Jesus payta wasima mantarka: —Wasima risa ama llakta ukuta pasankichu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Betsaida llaktamanta llukshisa Jesus pay yachachiskata katikamakunaynti Cesarea de Filipo niska allpapi tiya llaktakunama rinakurka. Ñampita rirasa pay yachachiskata katikamakunata tapurka: —Pi ñuka kaskata runakuna rimanakun.— ");
INSERT INTO qvo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Paykuna kutipanakurka: —Maykankuna —Bawtisa Juanmi— nisa rimanakun. Maykankunaka —ñupa uras kawsa Elias, Dios rimaskata kwinta runami— ninakun. Shukunaka —Dios rimaskata kwinta ñupa uras kawsa runakunamanta shukmi— ninakun.— ");
INSERT INTO qvo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chasna ninakupi tapurka: —Kankunaka pi ñuka kaskata yuyarinkichi.— Pedro kutiparka: —Kan ñukanchi chapaska Dios mantamuska kishpichi runami kanki.— ");
INSERT INTO qvo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus paykunata rimarka: —Chayta mana pitapas kwintankichichu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chasnapi paykunata yachachinkapa kallarirka pay kikin pasana kaskata: —Dios mantamuska runa ñakachiska tukunami kani. Ñukanchi Israel runakunapa kamachi rukukuna, pakrikunapa apukuna, Dios ñupa uras killkachiska killkata kutillata killkakamakunapas ñukawa piñarinakunka, ñukata wañuchiwanakunka. Chasna kapipas kinsa punchapi kawsarishami— nisa pay kikinmanta rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chasna pay pasanamanta kuskata rimarka. Chayta uyasa Pedro Jesusta mayama pushasa —ama sakinkichu chasna pasankapa— nisa payta rimankapa kallarirka. ");
INSERT INTO qvo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus muyurisa shuk yachachiskata katikamakunama rikusa Pedrota piñarka: —Ñukamanta anchuri, supay. Kanpa yuyayka mana Diospachu, runapa yuyaymi kan.— ");
INSERT INTO qvo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tukuy chaypi kaska runakunata pay yachachiskata katikamakunatapas kayasa Jesus rimarka: —Maykan runapas ñuka yachachiskata katikama tukunata munan pay kikin kawsankapa yuyarisa kawsanata sakichu. —Dios munaskallata rasa kawsanayani— nisa kawsachu. Runakuna kankunata ñakachinakusapas, wañuchinayanakupipas ñukawa sinchikusa katinkichilla. ");
INSERT INTO qvo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maykan runapas pay kikinlla kawsankapa yuyarisalla kawsan Dioswa chikapa kawsayta mana charinkachu. —Wañuchiwanakupipas katishami— nisa ñukawa sinchiku runa, ñukamanta kushi shimiwapas sinchiku ranti Dioswa chikapa kawsayta charinkami. ");
INSERT INTO qvo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Shuk runa tukuy kay pachapi tiyaskata chari tukunma pay ranti chikapa ñakarina kaskama rina kapi imapata balinka. Mana balinmachu. ");
INSERT INTO qvo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Masna kullkitapas paganayasaka manami ushankachu Dioswa chikapa kawsayta rantinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maykan runa kay mana ñukata yuya runakuna ñupapi, huchata rasa kawsakuna ñupapi ñukamanta pinkarinkachari, kushi shimita ñukamanta rimankapapas pinkarinkachari. Chasna pinkari runamanta ñukapas Dios mantamuska runa kuti shamuna punchapi pinkarishami. Chay uras Diosparayku kawsa anhelkuna chupipi shamusa ñuka Yayapa hatun ushaywa hawapachamanta punchaklla rikurimusa rikuchisha. ");
INSERT INTO qvo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus rimasa katirka: —Alita uyawaychi. Maykankuna kankunamanta chayra mana wañusa Dios kay allpapi hatun ushaywa mantanata kallariskata rikunkichi.— ");
INSERT INTO qvo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sukta punchawasha Jesus Pedrota, Santiagota, Juantapas pushasa paykunallawa shu hawa urkuma sikarka. Paykuna rikuranakupi Jesus shu laya rikuri tukurka. ");
INSERT INTO qvo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Paypa churana chiwlla rikurirka, yuraklla tukurka. Mana pi kay pachapi chasna yurayachinata ushanakun. ");
INSERT INTO qvo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chayllapita kinsa Jesuswa riskakuna kunkaymanta rikunakurka Dios rimaskata kwinta ñupa uras kawsa runakuna Moises Eliaspas Jesuswa kwintariranakuskata. ");
INSERT INTO qvo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro chayta rikusa nirka: —Yachachikama, alimi kaypi sakirinkapa. Kinsa tamputa rurashu, kanpa shukta, Moisespa shukta, Eliaspa shukta.— ");
INSERT INTO qvo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chay kinsa Jesuswa riska pay yachachiskata katikamakuna yapa manchariska kanakurka. Chayrayku Pedro ima rimaraskata mana yacharkachu. ");
INSERT INTO qvo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kunkaymanta shu puyu rikurisa paykunata llantuyachirka. Puyumanta shu shimi uyarirka kasna: —Kaymi ñuka llakiska churi, payta uyana kankichi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chasnapi Jesus yachachiskata katikamakuna muyukta rikunakusa Jesus sapalla shayaraskata rikunakurka. Moises Eliaspas illanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Urkumanta uraykuranakupi Jesus paykunata nirka: —Dios mantamuska runa wañuskamanta kawsarinakama, ama pitapas kuna rikuskata kwintaychichu.— ");
INSERT INTO qvo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesus chasna rimaskata kasusa mana pita kwintanakurkachu. —Dios mantamuska runa wañuskamanta kawsarinakama— nisa Jesus rimaskamanta paykunapura tapurinakurka: —Imatachari chaywa rimanayan— nisa. Pedro, Santiago, Juan ñupa uras kawsa Elias rikuriskata rikunakurka, urkupi Jesuswa kwintaskata. Dios rimaskata kwinta runa Elias rikuriskawasha mana allpapi sakiriskata rikunakurka. Dios mantamuska kishpichi runa Jesusrayku alichinkapa Elias mana sakirirkachu. ");
INSERT INTO qvo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chasna kapi Jesusta tapunakurka: —Imaraykuta Dios ñupa uras killkachiska killkata kutillata killkakamakuna rimanakun: —Dios mantamuna kishpichi runa manara shamupi ñupa uras kawsa Eliasshina runa shamuna kan, Dios rimaskata kwinta— nisa.— ");
INSERT INTO qvo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus kutipasa nirka: —Shuti, Eliasshina runa Dios mantamuna kishpichi runa ñupakta shamuna kan runakunata yachachisa yanapankapa paykunata kishpichi runa paktamunarayku paykunapa kawsayta alichinkapa. Ranti chay Eliasshina runa tukuyta alichinkapa yanapapika imarayku Dios ñupa uras killkachiskapi killkariska kan: Dios mantamuna runa yapa ñakarina kanka, runakunamanta mana balichi tukuna kanka nisa. ");
INSERT INTO qvo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eliasshina runamanta ñukaka kankunata rimani: Pay ña shamuskami. Runakuna paywa piñarisa mana ali munaskata paywa ruranakurka. Chasnami Dios ñupa uras killkachiskapi Eliasshina runamanta killkaska kan.— ");
INSERT INTO qvo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesus pay yachachiskata kinsa katikamakunawa kuti sakiriskakunapama rinakurka. Paykunama paktaraskapi achka runa paykuna muyukta kanakuskata rikunakurka. Dios ñupa uras killkachiska killkata kutillata killkakamakunamanta maykankuna chaypi kanakurka. Sakiriska Jesus yachachiskata katikamakunawa piñarisa rimariranakuskata rikunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesus kunkaymanta paktamurata rikusa runakuna kushiyasa paypama kallpanakurka —ña paktamurkankichu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus paykunata tapurka: —Imamantata rimarirarkankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chay runa bulamanta shu nirka: —Yachachikama, ñuka churita pushamurkani. Supay amuyaska kasa mana kwintanata ushan. ");
INSERT INTO qvo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chay supay payta allpapi urmachin. Shimimanta putskuta llukshichin. Kiruta kanirichin. Wañuskashina sakichin. Chasna kapi kan yachachiskata katikamakunapama pushasa mañarkani supayta llukshichinkapa. Mana ushanakurkachu.— ");
INSERT INTO qvo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chasna rimapi Jesus nirka: —Ñukawa mana sinchiku runakuna, ima uraskamata ñuka kankunamanta ñakarisa kankunawa kawsana kani. Supay amuyaska kari wamprata kayma pushamuychi.— ");
INSERT INTO qvo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chay wamprata pushamunakurka. Jesusta rikuskallapi supay chay wamprata sinchita kuchpachisa allpapi urmachirka. Chay wampraka allpapi kuchparipi shimimanta putsku llukshirka. ");
INSERT INTO qvo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus chay wamprapa yayata tapurka: —Ima urasmanta chasna tukurka.— Yaya kutiparka: —Wawa urasmanta. ");
INSERT INTO qvo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Supay maykan kuti ninapi yakupipas payta wañuchinayasa urmachin. Chasna kapi kan ushasaka ñukanchita yanapay. Ñukanchimanta llakiripay.— ");
INSERT INTO qvo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus nirka: —Imarayku —kan ushasaka— nisata niwanki. Dioswa sinchiku runarayku ñuka tukuyta ushani ruranata.— ");
INSERT INTO qvo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chayta uyasa, chay runa kaparisa nirka: —Dioswa sinchikuranimi, ñukata yanapaway astawa sinchikunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus runakuna ña munturiraskata rikusa supayta nirka: —Supay, kay wamprata mana uya mana kwintata rura, kanta rimani: Kay wampramanta llukshi. Paypapi ama kuti yaykunkichu.— ");
INSERT INTO qvo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Supayka chay wamprata sinchita kuchpachisa, kaparisa llukshirka. Wampra wañuskashina sakirirka. Chasna rikuripi maykankuna —wañuskami— rimanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ranti Jesus wamprata paypa makimanta hapisa hatachipi shayarirka. ");
INSERT INTO qvo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus wasima yaykuskawasha pay yachachiskata katikamakunawa sapalla sakirinakuskapi paykuna Jesusta tapunakurka: —Imaraykuta ñukanchi supayta hichunata mana usharkanchichu.— ");
INSERT INTO qvo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus kutipasa nirka: —Chay laya supaykuna Diosta mañaskallawa hichurinmi.— ");
INSERT INTO qvo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wampramanta supayta hichuskawasha Jesus pay yachachiskata katikamakunawa chaymanta llukshinakurka. Galilea allpapi tiya llaktakuna mayata purisa pasanakurka. Jesus mana munarkachu runakuna pay pasaraskata yachankapa. ");
INSERT INTO qvo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Pay yachachiskata katikamakunata yachachinata munarka. Chasnapi paykunata rimarka: —Dios mantamuska runa kapi ñukata hapichiwanakunkami. Piñari runakunama kuy tukusha. Ñukata wañuchiwanakunka. Kinsa punchapika kawsarishami.— ");
INSERT INTO qvo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Paykuna mana yachanakurkachu Jesus imata rimanayaskata. Chasna kasapas tapunata manchanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum llaktama paktanakurka. Wasipi kasa Jesus pay yachachiskata katikamakunata tapurka: —Imata ñampipi kwintarirarkankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Paykuna chunlla tukunakurka. Ñampipi kwintariranakuska karka —mayka paykunapuramanta shukunamanta yali pasa kanka— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chasna kapi Jesus tiyarisa chay chunka ishkayta rimarka: —Tukuymanta yali pasa tukunata muna runa tukuykunamanta yali mana balishina tukuchu. Tukuykunata yanapa kachu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesus shu wawata kayasa pay yachachiskata katikamakunapa ñupapi shayachirka. Chay wawata ukllarisa paykunata rimarka: ");
INSERT INTO qvo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ñukaparantimanta kasna wawata chaski runa ñukata chaskinmi. Ñukata chaski runaka ñukata mantamuska Yaya Diosta chaskin.— ");
INSERT INTO qvo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan Jesusta nirka: —Yachachikama, shu runata tuparkanchi, kanparantimanta supaykunata hichurarka. Chay runata nirkanchi —ama chasna raychu— nisa mana ñukanchi bulamanta kaskarayku.— ");
INSERT INTO qvo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus kutiparka: —Ama chasna rura runata rimaychichu —supayta runakunamanta ama hichunkichu— nisa. Ñukaparanti hatun ushaywa raskata ra runaka ñukawa mana piñarinkachu. ");
INSERT INTO qvo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ñukanchiwa mana piñarika ñukanchi partimanta kan. ");
INSERT INTO qvo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maykan runapas kankunata ñukaparanti shu basu yakullatapas upyachipi ñuka Dios mantamuska kishpichi runa kankunapa amu kaskamanta, chay runata Dios manami kunkarinka. Alita uyawaychi. Chasna yanapa runata Dios kushiyachinkami pay ruraskamanta.— ");
INSERT INTO qvo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus pay ukllariska wawata rikuchisa nirka: —Maykan runapas kay wawashina ñukawa sinchiku runakunamanta shu runata huchama aysan, yapa ñakachisa kastigay tukunkami. Chay laya runapa kastigu paypa kunkapi hatu rumita warkuchisa hatun kuchama shitay tukunamanta yali sinchi kanka. ");
INSERT INTO qvo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kanpa maki kanta huchata rurachinayapi, chay makita piti. Pullu maki hawapachama yaykuna Dioswa chikapa kawsankapa yali ali kanka, ishkay makiyu ukupachapi mana wañu nina kaskama rinarantimanta. ");
INSERT INTO qvo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kanpa chaki kanta huchata rurachinayapi chay chakita piti. Pullu chaki hawapachama yaykuna Dioswa chikapa kawsankapa yali ali kanka ishkay chakiwa ukupachapi mana wañu nina kaskama rinarantimanta. ");
INSERT INTO qvo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kanpa ñawi kanta huchata rurankapa rikuchipi chay ñawita surkusa hichuy. Hawapachama, Dios tukuypa apu kaskama shuklla ñawiyu rina yali ali kanka ishkay ñawiyu ukupachama rinarantimanta. ");
INSERT INTO qvo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ukupachapi runapa aychata miku kuru mana wañunchu. Manchaypa ninapas mana wañusa tukurinchu. ");
INSERT INTO qvo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Runakuna Diosma kuska aychakunata kachiwa mishkiyachiskashina tukuy kankuna ñakarinakuna pasaripi ninawashina alichi tukunkichimi. ");
INSERT INTO qvo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kachi alimi kan. Kachi upayapi ni pi mana ushankachu kutillata mishkiyachinkapa. Kankuna ali kachita charikshina ali yuyayta rikuchisa runakuna chupipi kawsaychi. Kankunapura ganaslla kawsaychi. ");
INSERT INTO qvo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaum llaktamanta llukshisa Jesus Judea partima paktarka, Jordan yaku chimpa partima. Achka runa kutillata ñampipi munturinakupi Jesus tukuy uras ruraskashina chay runakunata yachachirka. ");
INSERT INTO qvo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jesus chaypi paktaskata yachasa Fariseo bulamanta runakuna mayayasa payta kamasa tapunakurka: —Shu runa paypa warmita hichunkapa ushankachu.— ");
INSERT INTO qvo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus kutipasa nirka: —Moises imata kankunata rimarka.— ");
INSERT INTO qvo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Paykuna kutipanakurka: —Moises nirka: Shu kari paypa warmita hichunayasa warmita apukuna ñupapi hichuna killkata kusa hichuna usharin nisa.— ");
INSERT INTO qvo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus paykunata nirka: —Moises kawsaska uras kankunashina mana uyanaya runakunarayku chayta rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Chasna kapipas Dios kay pachata ruraska urasmanta kan imana Dios killkachiska killkapi rimaskashina kasna: Dios runata rurarka kari warmi kankapa nisa. Kasnapas riman: ");
INSERT INTO qvo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dios warmita karipa aychamanta ruraskarayku shu kari warmiyu tukusa paypa yayata mamata sakisa paypa warmiwa llutarinmi. ");
INSERT INTO qvo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chasna ishkayntimanta shukllashina tukunakunka nisa. Ña mana ishkaychu kanakun, ranti shukllashina kanakun. ");
INSERT INTO qvo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chasna kapi Dios llutachiskata runa ama llushpichichu— Jesus rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ña wasima ripi pay yachachiskata katikamakuna Jesusta rimaskamanta kutillata tapunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus paykunata nirka: —Maykan karikunapas kikin warmita hichusa shu warmiwa llutarisa kikin warmita mana alita ran mana payllawa sakiriskarayku. ");
INSERT INTO qvo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chasnallata warmikunapas kikin karita hichusa shu kariwa llutarisaka kikin karita mana alita ran mana payllawa sakiriskarayku.— ");
INSERT INTO qvo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Maykan runakuna paykunapa wawakunata Jesuspama pushanakurka —kanpa makita paykunapa hawapi churapay— nisa. Ranti Jesus yachachiskata katikamakuna chay wawayu runakunata piñanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chayta rikusa Jesus piñarisa rimarka: —Wawakuna ñukapama shamunata ama harkaychichu. Wawakunashina yuyayu runakunallami Dios amuyaska runa tukunata ushanakun. ");
INSERT INTO qvo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Alita uyawaychi. Maykan runa mana wawashina Dioswa mana sinchikunchu chay runaka mana nima uras Dios amuyaska runa tukunata ushankachu.— ");
INSERT INTO qvo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chasna rimaskawasha Jesus wawakunata kayarka. Paykunata markasa makita hawapi churasa —Dios kankunata alita kuyrachu— nisa rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus wasimanta llukshisa Jerusalen llaktama ñampita purisa rinkapa rahuskapi shu runa kallpasa shamurka. Jesus ñupapi kunkurisa payta tapurka: —Ali yachachikama, imata ruranata kani chikapa Dioswa kawsankapa.— ");
INSERT INTO qvo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus kutipasa nirka: —Yuyanki —ali yachachikama— nisa kan rimaskawa imata ñukata niwanki. Shukllami ali kan, chaymi kan Dios. ");
INSERT INTO qvo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kanka runa paktachinkapa Dios rimaska kamachina shimikunata yachanki: Runata ama wañuchinkichu. Ama shuk runapa warmiwa satirinkichu. Ama shuwankichu. Ama shumanta llullasa rimankichu. Ama shukunata llullachinkichu. Kanpa yayata mamatapas balichisa kawsay.— ");
INSERT INTO qvo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chayta uyasa chay runa kutipasa nirka: —Yachachikama, tukuy chayta ñuka wampra urasmanta paktachimuni.— ");
INSERT INTO qvo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chayta uyasa Jesus llakiskawa paypama rikusa nirka: —Chayra kan rurankapa pishin: Tukuy kan chariskakunata rantichikri mana imayu runakunama kuyankapa. Chasna rasa hawapachapi achka imayushina tukunki. Chaywasha ñukawa shamunki ñuka yachachiskata katikama tukunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chay runa yapa kullkiyu kasa chay shimita uyasa llakirisami rirka. ");
INSERT INTO qvo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pay rirapi Jesus muyukta rikusa pay yachachiskata katikamakunata rimarka: —Yapa kullkiyu runarayku Dios amuyaska runa tukunkapa mana yapa ushaypachu.— ");
INSERT INTO qvo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chay shimikunata uyasa Jesus yachachiskata katikamakuna yapa mancharinakurka. Jesus kutillata nirka: —Churikuna, Dios amuyaska runa tukunkapa mana chasnalla ushaypachu. ");
INSERT INTO qvo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Achka kullkita chari runa Dios amuyaska runa tukunata mana ushaypa. Hatun wiwa kamellu niska aguha hutkuta pasana yali ushaypa kan.— ");
INSERT INTO qvo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Paykuna chayta uyasa astawa mancharisa rimanakurka: —Chasna kapi ni pi kishpichi tukunata ushanakunkami.— ");
INSERT INTO qvo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus kutipasa nirka: —Runakunapa mana ushaypa kan. Ranti Dios tukuyta ushan.— ");
INSERT INTO qvo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro chayta uyasa nirka: —Ñukanchi tukuy chariskata sakirkanchi kan yachachiskata katikama tukunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Chasna rimapi Jesus payta nirka: —Alita uyawaychi. Maykan runapas kikin wasita, wawkikunata, panikunata, turikunata, ñañakunata, mamata, yayata, churikunata, allpakunatapas sakin ñuka yachachiskata katikama tukunkapa, ñukamanta kushi shimita yachachisa purinkapapas, chay runa sakiskamanta yalikta kuy tukunkami. Kay pachallapita chayra kawsaraskapi chay laya runa imakunata ayllukunata sakiskamanta yalikta kuy tukunka: wasikunata, wawkikunata, panikunata, turikunata, ñañakunata, yayakunata, mamakunata, churikunata, ushushikunata, allpakunatapas. Ranti runakuna kankunawa piñarinakunka. Washa kankuna chaparaska mushu pachapi ña Dios Yayawa chikapa kawsakrinkichi. ");
INSERT INTO qvo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ranti kuna punchakuna achka runakuna tukuy runakunamanta yapa balichiskakuna chay puncha tukuykunamanta mana balichiska tukunakunka. Kuna punchakuna tukuy runakunamanta mana balichiskakuna chay puncha tukuy runakunamanta yali balichiska tukunakunka.— ");
INSERT INTO qvo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalen llaktama sikasa puriranakuskapi Jesus pay yachachiskata katikamakunata ñupasa rirarka. Paykuna imata yuyarinkapa mana yachasa Jesusta katinakurka. Paykunawa rira runakuna manchaywa kanakurka. Jesus chunka ishkayta chikanma kayasa pay pasana kaskata kwintarka: ");
INSERT INTO qvo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Uyawaychi. Kankuna rikunkichi Jerusalenma riranchi. Chaypi Dios mantamuska runa hapi tukuska kashami. Pakrikunapa apukunama, Dios ñupa uras killkachiska killkata kutillata killkakamakunamapas kuy tukushami. —Kan wañuchi tukuna kanki— nisami ñukata rimawanakunka. Ñukata mana Israel runakunama kuwanakunka. ");
INSERT INTO qvo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ñukata asisa pukllachiwanakunka. Ñawipampapi tyukawanakunka. Liwachiwanakunka. Wañuchiwanakunka. Chasna kapipas kinsa punchawasha kawsarishami.— ");
INSERT INTO qvo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeopa ishkay churikuna, Santiago Juanpas, Jesusta mayayasa rimanakurka: —Yachachikama, ñukanchi mañankapa raskata ruranki.— ");
INSERT INTO qvo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus tapurka: —Ñukamanta imatata munankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paykuna kutipanakurka: —Kan hatun ushaywa tukuy runakunata manta apu kankapa yaykusa ñukanchita shukta yacha maki partima, shukta lluki maki partima tiyarichisa kanwa parihu apukuna kankapa yaykuchipanki.— ");
INSERT INTO qvo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chasna mañanakupi Jesus paykunata rimarka: —Kankuna mañawaskata mana yachankichichu. Ñuka apana laya llakikunata kankunapas apanata ushankichimachu. Ñuka pasana wañuywa kankunapas wañunata munankichimachu.— ");
INSERT INTO qvo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kutipasa rimanakurka: —Ushanchimi, munanchimi.— Chasna rimapi Jesus nirka: —Shutipacha, ñuka apana laya llakikunata kankunapas apankichi. Ñuka pasana wañuyllawa kankunapas wañunkichimi. ");
INSERT INTO qvo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ranti, ñuka yacha maki partima tiyarikunata, ñuka lluki maki partima tiyarikunata ñuka mana maskanachu kani. Ñuka Yayalla paykunata maskanka.— ");
INSERT INTO qvo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesus yachachiskata shu katikamakuna uyasa Santiago Juanpas Jesusta mañaskata paykunawa piñarinkapa kallarinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus tukuy paykunata kayasa nirka: —Kay pachapi kawsa apukuna runakunata sinchita mantasa kawsanakun. Apukunata yanapa apukunapas runakunata imatapas mantasa ñakachinakun. ");
INSERT INTO qvo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kankunapura mana chasna kawsana kankichi. Ranti maykanpas kankunamanta manta apu sakirinayan, tukuykunata yanapa kachu. ");
INSERT INTO qvo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maykan shu runakunamanta yali kanata muna kan, chay runa tukuykunata uyasa mantay tukusa kawsachu. ");
INSERT INTO qvo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ñuka Dios mantamuska runa kasapas mana shamurkanichu runakuna ñukata uyasa yanapasa kawsankapa. Ranti runakunata yanapankapami shamurkani. Huchata rasa kawsanakuskamanta achka runakunata kishpichisa amuyankapa wañushami. Ñuka kawsay chay runakunapa dibita paganarayku kanka.— ");
INSERT INTO qvo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus pay yachachiskata katikamakunawa puriraskapi Jerico llaktama paktanakurka. Chay llaktamanta llukshiranakuskapi achka runakuna paykunawa rinakurka. Ñampita riranakuskapi ñawsa runata rikunakurka. Bartimeo shutiyu karka. Timeopa churi karka. Ñampi mayapi kullkita mañasa tiyararka. ");
INSERT INTO qvo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Runakuna kwintariraskata uyasa ñawsa runa yacharka Jesus Nazaret runa shamuraskata. Chayta yachasa kaparirka: —Davidpa miray Jesus, ñukanchi chapaska kishpichi runa, ñukamanta llakiripay.— ");
INSERT INTO qvo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Maykankuna payta piñanakurka: —¡Amipa kaparinki! Upallay— nisa. Ranti payka yali sinchita kaparirka: —Davidpa miray ñukanchi chapaska kishpichi runa, ñukamanta llakiripay.— ");
INSERT INTO qvo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus chay kapariskata uyasa puriraskamanta chayllapi shayarirka. Paypa mayapi kaskakunata nirka: —Ñawsa runata kayaychi.— Uyasa payta kayakrinakurka: —Sinchikuy. Shayari. Jesus kanta kayaran.— ");
INSERT INTO qvo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chay ñawsa runa chayta uyasa hawa churariskata allpama shitarka. Pawarisa hatarisa Jesuspama shamurka. ");
INSERT INTO qvo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Paktapi Jesus payta tapurka: —Imatata ñuka kanrayku rurankapa munanki.— Ñawsa runa kutiparka: —Yachachikama, ñuka ñawita aliyachipay. Ñuka mushumanta riku tukunayani.— ");
INSERT INTO qvo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus payta nirka: —Rilla, kan ñukawa sinchikuskamanta aliyaska kanki.— Chay urallapi riku tukurka. Chasna tukusa Jesusta katisa rirka. ");
INSERT INTO qvo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalen llaktama mayayaraskapi Betfage Betania llaktakuna mayapi paktanakurka. Olivos urku siki pampayaskapi kanakurka. Chaypi Jesus pay yachachiskata katikamakunamanta ishkayta mantankapa rahuskapi rimarka: ");
INSERT INTO qvo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Kankuna kuskapuralla ichilla llaktama richi. Chayma paktasa shu burru wataskata tupankichi. Paypa hawapi chayra mana pi tiyariskachu karka. Paskasa pushamunkichi. ");
INSERT INTO qvo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maykanpas kankunata: —Imapata paskankichi— nipi kutipankichi: —Amuka payta minishtinmi, washa kutichinkami.— ");
INSERT INTO qvo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Paykuna risa shu burruta tupanakurka ñampipi shuk wasi punku mayapi watara kaskata. Tupasa paskanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Paskaranakupi chaypi kaska runakuna tapunakurka: —Imapata burruta paskankichi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesus yachachiskata katikamakuna Jesus rimaskashina kutipanakurka. Chayta uyasa: —Apaychilla— nisa rimanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chasna rimanakupi burruta Jesuspama pushanakurka. Chay burru hawapi paykunapa hawa churariskata mantapi Jesus sikarka chay hawapi tiyarisa rinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pay pasana ñampipi hatun apuraykulla rurana kaskata rurasa achka runakuna paykunapa hawa churariskata surkusa mantanakurka. Maykan runakunaka pankakunata karumanta apamusa ñampipi mantanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesuspa ñupapi rira runakuna washalla katirakunapas kushilla kaparinakurka: —¡Ali shamuska! ¡Dios kanta yanapachu kan Diosparanti ñukanchipama shamuskarayku! ");
INSERT INTO qvo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Diosta yuya tukuyta binsi kanki! ¡Apu wañu Davidshina apu kasa ñukanchita lugaryachinkapa paktamuranki! ¡Dios kanta yanapachu! ¡Hakuychi kushiyachishunchi hawapachapi kawsa Diosta!— nisa kaparinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus Jerusalenma yaykusa Diosta mañana wasima rirka. Tukuy chaypi pasaskata rikuraskawasha, ña chishiyapi, pay yachachiskata katikamakunaynti Betania llaktama rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kayanti punchapi Betaniamanta llukshisa Jesus yarkarka. ");
INSERT INTO qvo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Karupi shu igu kaspi yurata rikurka, achka pankayu kaskata. Chayma rirka —wayuyuchari kanka— nisa. Alita rikupika pankalla tiyarka. Mana wayu aparina uraschu karka. ");
INSERT INTO qvo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chasna kapi Jesus yurata nirka: —Mana pi kanmanta wayuta mikuchu.— Pay yachachiskata katikamakuna chay rimaskata uyanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalen llaktama paktasa Jesus kuti Diosta mañana wasima rirka. Chay wasipa punta hatun pampa wasikunawa muyukta kaska chupipi achka rantichikama runakuna, rantikamakunapas kanakurka. Paykunata rikusa chaymanta kallpachinkapa kallarirka. Runakuna paykuna apamuska kullkikunata Diosta kuyanarayku ali kullkiwa kampyana kanakurka Israel apukuna rimaskashina. Chayrayku kullkita kampyakuna achka chaypi tiyarka, yalikta kobrasa kullkiyanakurka. Jesus chayta rikusa paykunapa mesakunata tankasa urmachirka. Mana imayu runakuna Diosrayku rupachina wiwa urpikunata rantichikamakunapas yalikta kobrakuna achka tiyarka. Paykunapa urpi hawlakuna shayachiska mesakunata tankasa urmachirka. ");
INSERT INTO qvo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Diosta mañana wasipa wasikunawa muyukta kaska pampakunapi wasikuna ukupipas Jesus mana sakirkachu ni pi imatapas apasa purinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Paykunata hichuskapi rimarka: —Dios ñupa uras killkachiska killkapi kasna nin: Ñuka wasi ñukata mañana wasi kanka tukuy llaktamanta runakunarayku nisa. Ranti, kankuna chayta shuwa wasita rarkankichi— nisa Jesus rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chayta uyasa pakrikunapa apukuna, Dios ñupa uras killkachiska killkata kutillata killkakamakunapas —imana rasata payta wañuchirinka— nisa paykunapura kwintarinakurka. Ranti Jesusta manchanakurka, tukuy runakuna pay yachachiskata kushiyaskawa uyanakuskarayku. ");
INSERT INTO qvo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tutayaraskapi Jesus pay yachachiskata katikamakunaynti Jerusalen llaktamanta kuti llukshinakurka, karan chishi raskashina. ");
INSERT INTO qvo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kayanti punchapi tutamanta Jesus pay yachachiskata katikamakunaynti kuti Jerusalenma rina ñampita rinakurka. Chasna riraskapi paykuna Jesus mana wayuyu igu kaspi yura piñaskata rikunakurka, ankukunaynti chakiriska kaskata. ");
INSERT INTO qvo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro yuyarisa nirka: —Yachachikama, rikuy, kan piñasa rimaska kaspi yura chakiriskami.— ");
INSERT INTO qvo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus paykunata nirka: —Dioswa sinchikuychi. ");
INSERT INTO qvo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Alita uyawaychi. Maykan runapas kay urkuta kasna riman: —Urku anchuri, hatu kuchama shitari— nisa, paypa shunkupi chasna yuyarisa sinchikupi, pay yuyariskashinallami tukunka. ");
INSERT INTO qvo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chasna kapi kankunata rimani: Tukuy kankuna Diosmanta mañaskata —ña chaskirkanchi— nisa yuyasaka chaskinkichimi. ");
INSERT INTO qvo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kankuna Diosta mañanayasaka maykankunawa piñariska kasa ñupakta paykunawa alichisa aylluyaychi. Kankunata tukuy mana ali ruraskakunamanta paykunata kishpichichi. Chasna rapi hawapachapi kawsa kankunapa Yayapas kankunata huchamanta pichasa kishpichinkami. ");
INSERT INTO qvo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ranti kankuna shukunawa mana alichisa aylluyapika hawapachapi kawsa kankunapa Yayapas kankunata mana huchakunamanta pichasa mana kishpichinkachu.— ");
INSERT INTO qvo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus pay yachachiskata katikamakunaynti kuti Jerusalen llaktamallata paktanakurka. Chaypi Jesus Diosta mañana wasipi puriraskallapi pakrikunapa apukuna paypama mayayamunakurka. Dios ñupa uras killkachiska killkata kutillata killkakamakunapas mayayamunakurka, ñukanchi Israel runakunapa kamachi rukukunapas. Jesus chay wasimanta rantichikamakunata hichuskata yuyarisa chay apukuna paypama mayayamusa tapunakurka: ");
INSERT INTO qvo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—Ima ushaywata kan raskata ranki. Pita kanta chayta rankapa mantarka.— ");
INSERT INTO qvo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Paykuna mana ali yuyaywa tapuskata Jesus payllata shunkupi yacharka. Ima ushaywa Juan bawtisaskata paykuna mana rimanata munaskata yachasa paykunata kutipasa nirka: —Ñukapas kankunata tapuskankichi. Kankuna kutipawapi ñukapas ima ushaywa chayta raskata kankunata kwintashami. ");
INSERT INTO qvo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Rimawaychi: Pita Juanta mantarka bawtisankapa. Hawapachamantachu mantay tukurka. Runakunachu payta mantanakurka. Kutipawaychi.— ");
INSERT INTO qvo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chasna tapupi paykunapura rimarinakunkapa kallarinakurka: —Ñukanchi —hawapachamanta mantay tukurka— nisa rimapi, ñukanchita rimanka: —Imaraykuta paywa mana sinchikurkankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nima rimanata mana ushanchichu —runakunalla payta mantanakurka— nisa. —Imanachari rimashu— nisa paykunapura rimarinakurka. Tukuy runakuna Juan Dios rimaskata kwinta kaskata yuyarinakurka. Chayrayku apukuna manchanakurka rimanata: —Juan mana Dios partimanta kan— nisa. —Ñukanchi chasna rimapi runakuna ñukanchita wañuchinakunma— nisa rimanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chasna yuyarisa Jesusta rimanakurka: —Mana yachanchichu pi Juanta mantarka.— Jesus rimarka: —Kankuna mana rimanata munapi ñukapas ima ushaywa ñuka raskata ruraskani mana rimaskankichichu.— ");
INSERT INTO qvo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus Diosta mañana wasipi kasa runakunata kay yuyachina kwintuwa yachachirka: —Shu runa willasi wayushina uva niska wayu wiñankapa paypa runakunata chakrata rurachirka. Chay chakra muyukta kinchachirka. Urku rumita allachisa shuk hatun batanta rurachirka chaypi uva wayu chawachiskata shutuchinkapa. Rumikunawa achka patayu wasita rurachirka, shuk runa hawamanta rikusa chakrata kuyrankapa. Chay chakrata shu runakunawa trabahankapa sakirka —pallana uras shuk parti pallaskawa ñukapa chakra kaskamanta pagawankichi— nisa. Chasna nisa chakra amuka karu llaktama rirka. ");
INSERT INTO qvo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ña pallana uras paktaripi chakra amu karupi kawsaraskamanta shu yanapa runata mantarka pay sakiska runakunapama. Paypa partita pallaskamanta mañankapa mantarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chay chakra amuta yanapa runa paktakripi chakrata trabahakamakuna payta hapisa liwachisa kuti amupama mantanakurka. Nima imawa mantanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chakra amu kuti shu yanapa runata mantarka. Pay paktapi chakrapi trabaha runakuna umapi waktanakurka. Payta piñasa pinkachisa kuti amupama mantanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amuka kuti shuktapas mantarka. Payta wañuchinakurka. Chaypawasha astawa yanapakunata, shukta, shukta mantarka. Paykuna paktanakupi chakrapi trabahakuna maykankunata waktanakurka, maykankunata wañuchinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Shuklla tiyarka manara mantay tukuska, paypa yapa llakiska churi. —Ñuka churita kasunakunkami— nisa paytapas mantarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amupa churi paktapi chay chakrapi trabahakamakuna paykunapura kwintarinakurka: —Kayka chakra amupa churimi. Paypa yaya wañupi tukuy chariskakunata paypa churipa sakirinka. Chakra amupa churita haku wañuchishu, pay charinkapa rahuskakunata amuyashu— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chasnapi chakra amupa churita hapisa wañuchinakurka. Chakra mayama shitanakurka— nisa Jesus kwintasa yuyachirka. Uyakamakunata tapusa katirka: —Imasna yuyarinkichi. ");
INSERT INTO qvo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chakra amuka imatata chay trabahakunata ruranka. Ñuka kankunata rimaskankichi chakra amuka imatami ranka. Pay shamusa chakrapi trabaha runakunata wañuchinkami. Paypa chakrata shukunawa sakinkami. ");
INSERT INTO qvo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kankuna alita yachankichi Dios ñupa uras killkachiskata. Chasna kasapas mana munankichichu sakinata ñukata mana ali ruraraskata. Killkariska kaskata kankuna alita paktachinkichi. Kasnami nin: Rumimanta wasita rurakuna ali rumita hichusa —mana balinchu— nisa rimanakurka. Chay hichuska rumi tukuy rumikunamanta astawa wasita sinchikuchi rumi tukurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chay rumitaka astawa wasita sinchikuchi rumi kankapa tukuypa apu Dios churarka. Chasna Dios ruraskamanta yapa kushiyanchi nisa killkariska kan— nisa Jesus rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Apukuna Jesus rimaskata uyasa —ñukanchirayku chay kwintuwa yuyachirka— nisa rimanakurka. Chasnapi yuyarinakurka —imasna rasata hapirinka— nisa. Ranti runakunata manchasa mana ushanakurkachu. Chasna kasa paykuna Jesusta sakisa rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Apukuna Jesuswa piñariska kanakurka. Chasnapi fariseo bulamanta maykankunata, apu Herodeswa wankuriska bulamantapas maykankunata Jesuspama mantanakurka. Rinkapa mantanakurka Jesusta tapunawa kamasa turkachinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jesuspama shamusa rimanakurka: —Yachachikama, kan mana llullasa shutita rima kaskata yachanchi. Mana pita manchasa runakunata kuskata yachachinki. Tukuy runakunata alita yachachinki Dios munaskata rurasa kawsankapa. Kuna ñukanchita rimay: Ñukanchipa Roma hatun apurayku kullkita pagana balinchu, manachu balin. Paganachu, manachu pagana. Imata ninki.— ");
INSERT INTO qvo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus riksirka paykuna alishina tukusa payta hapichinayaskata. Jesus rimanma —pagana kanchi— nisa, chay payta turkachinayakuna ñukanchi Israel runakunamanta apukunata rimakrinakunma payta kastigachinkapa. Jesus rimanma —mana alichu pagankapa— nisa ñukanchipa Roma hatun aputa rimakrinakunma payta kastigachinkapa. Chasna payta turkachinayasa paykuna tapunakuskata uyasa Jesus nirka: —Imaraykuta ñuka rimankapa rahuskapi hapinayawankichi. Shu kullki karata rikuchiwaychi.— ");
INSERT INTO qvo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kullki karata rikuchinakurka. Jesus chayta rikusa tapurka: —Kay kullki karapi pipa umata rikuchin.— Tapupi uyasa kutipanakurka: —Ñukanchipa Roma hatun apupami.— ");
INSERT INTO qvo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus nirka: —Hatun apupata hatu apuma kuychi. Diospata Diosma kuychi.— Chasna Jesus yapa yachaywa kutipaskata uyasa runakuna yapa mancharinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pakrikuna wankuriska Saduceokuna niska bulamanta maykankuna Jesusma paktanakurka. Paykuna —wañuskakuna mana kawsarinakunkachu— nisa yuyarinakun. Chasna kapi Jesusta tapunakurka: ");
INSERT INTO qvo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yachachikama, Moises killkaskakunapi kasna killkara tiyan: Warmiyu runa wañupi paypa warmi wawa illa sakiripi kari wañupa wawki chay warmiwa kasarana kan. Paykuna kari wawata tupapi wañuskapa shutita churay tukunka nisa killkaska kan. ");
INSERT INTO qvo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kuna alita uyaway. Kanchis wawkipura kanakurka. Ruku wawki shu warmiwa kasararka. Ranti manara wawata charinakuskapi wañurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Washa chay wawki wañumanta kipa wawki chay wakcha warmillawa kasararka. Chasnallata paypas wawa illa wañurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tukuy kanchis wawkipura washa washa chay wakcha warmillawa kasaranakurka. Tukuykuna wawa illa wañunakurka. Puchkaypi warmipas wañurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ña kawsarina punchapi tukuy chay kanchis wawkikuna chay warmillawa kasaraska kapi pipa warmita kanka.— ");
INSERT INTO qvo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chasna rimanakupi Jesus kutipasa nirka: —Dios ñupa uras killkachiskata mana yachasa, Diospa ushaytapas mana riksisa pantarankichi. ");
INSERT INTO qvo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wañuskakuna kawsariskawasha kasarana mana tiyankachu. Hawapachapi kawsa anhelkunashina mana kasarasa kawsanakunka. ");
INSERT INTO qvo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Moises ñupa uras killkaskakunapi niskata alita yachankichi. Wañuskakuna mana wañuska sakirinamanta ruparaska yuramanta Dios payta kasna rimarka: Ñuka Abraham mañaraska Dios, Isaac mañaraska Dios, Jacob mañaraska Diosmi kani nisa rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Payka mana kanchu wañuskakuna mañaraska Dios, kawsakuna mañaraska Diosmi kan. Chayrayku kankunaka —ñukanchi wañupi kawsay tukurinka— nisa yuyariskawa yapa pantarankichi. ");
INSERT INTO qvo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dios ñupa uras killkachiska killkata kutillata killkakamakunamanta shu killkakama Jesus pakrikunawa kwintaskata uyarka. Chayta uyasa chay killkakama Jesus pakrikunata yachaywa kutipaskamanta kushiyarka. Chasnapi Jesusta tapurka: —Runa paktachinkapa Dios sakiska kamachina shimikunamanta maykanta yali ali kan.— ");
INSERT INTO qvo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus kutipasa nirka: —Yali ali kamachina shimi kaymi: Uyaychi, Israel runakuna: Tukuykunapa apu ñukanchi mañaraska Dios shuklla tukuykunata manta apumi kan. ");
INSERT INTO qvo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tukuykunapa apu kankuna mañaraska Diosta llakina kankichi tukuy shunkuwa, tukuy kawsaywa, tukuy yuyaywa, tukuy ushaywapas. Chaymi yali ali kamachina shimi. ");
INSERT INTO qvo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chay kamachina shimishinallata kaymi: Shukunata kan kikintashina llakina kanki. Chaykunamanta mana tiyanchu yali ali kamachina shimi.— ");
INSERT INTO qvo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chay killkakama runa Jesus rimaskata uyasa nirka: —Alimi, yachachikama, shutita nirkanki —shuklla Dios tyan— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Diosta tukuy shunkuwa, tukuy yuyaywa, tukuy kawsaywa, tukuy ushaywa llakinami kanki, shukunataka kan kikintashina llakinami kanki. Chay kamachina shimikunata paktachinkapa yali balin wañuchiska aychata Diosrayku nisa rupachinamanta.— ");
INSERT INTO qvo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Killkakama ali yuyaywa rimaskata uyasa Jesus payta nirka: —Kan ña Dios amuyaska runa tukunkapa rahunki.— Chay urasmanta tukuy manchanakurka Jesusta astawa tapunkapa. ");
INSERT INTO qvo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus Diosta mañana wasipi yachachisa nirka: —Imasna yachachinayasata Dios ñupa uras killkachiska killkata kutillata killkakamakuna rimanakun: —Dios mantana kishpichi runa ñupa uras kawsa apu Davidpa miray kana kan— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Diospa Samay payta rimankapa yuyachipi shamuna kishpichi runata yuyarisa Davidllata runakunata rimarka: Tukuykunapa apu Dios ñukapa amu kishpichi runata nirka: —Ñuka yacha maki partima tiyari, kanwa piñarikunata ñuka yalinakama— nisa Dios rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hatun apu David kawsaska uras, Dios kishpichi runata manara mantaskapi David kikin payta nirka —ñukapa amu— nisa. Chasna apu David rimaskamanta yachanchi David kawsaska uras chay kishpichi runa ña kawsa kaskata, ña Davidmanta yali hatun apu kaskata. Chasna kapi yachachiwaychi, imasnata Davidpa mirayllata kanka. Chasna rimapi tukuy chaypi kaska runakuna kushiyasa Jesus ali yachachiraskata uyanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus Diosta mañana wasipi yachachirasa katirka: —Dios ñupa uras killkachiska killkata kutillata killkakamakunamanta kuyrarinkichi. Tukuymanta yali bali runakunashina suni churariskawa purinata munanakun. Ñampikunapi balichiskatashina saluray tukunata gustanakun. ");
INSERT INTO qvo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Diospa shimita yachana wasikunapi ñupapi tiyarinakun, balichiska runakunapa tiyarinakunapi. Chasnallata hishta mikunapi ñupapi tiyarinakunapi tiyarinata munanakun. ");
INSERT INTO qvo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wakcha warmikunata llullachisa mana pinkasa paykunapa imakunata kichunakun. Paykuna kikinrayku sakirinkapa mañanakun: —Diosta kushiyachinkapa kuyana kankichi— nisa. Chay mana ali ruraskakuna pakalla sakirinkapa ali tukuskashina munturina wasikunapi unayta Diosta mañanakun. Chasna ruranakupi Dios paykunata tukuy runakunamanta yali sinchita kastiganka.— ");
INSERT INTO qvo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Shu puncha Jesus Diosta mañana wasipi tiyararka Diosma kuska kullkita wakachina kaha mayapi. Chaypi tiyarisa runakuna chay kahapi kullkita churaraskata rikurarka. Kullkiyu runakuna achka kullkita churanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chasnapi shu mana imayu wakcha warmi paktarka. Ishkay kullki karashtuta churarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chayta rikusa Jesus pay yachachiskata katikamakunata kayasa nirka: —Alita uyawaychi. Kay wakcha warmi tukuykunamanta yalikta churarka. ");
INSERT INTO qvo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chay achka kullkiyu runakuna puchuskamanta churanakurka. Ranti kay wakcha warmi pay chariskata illakta kurkami— nirka. ");
INSERT INTO qvo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus pay yachachiskata katikamakunaynti Diosta mañana wasimanta llukshirasa shu katikama chay wasi wasikunawa muyukta kaskama rikuchisa Jesusta rimarka: —Yachachikama, rikuy ¡ima hatun rumikunawa rurariska kan, ima suma rikuri wasikuna!— ");
INSERT INTO qvo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus rimarka: —Kunashitu kay hatu suma rikuri wasikunata rikunkichi. Ranti nima shuk rumi hawapura mana sakirinkachu. Illakta tulachi tukunakunkami— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Purisa riraskapi Olivos urkuma paktanakurka, Diosta mañana wasi kuskapura kaskama. Jesus chaypi tiyarirka. Pedro, Santiago, Juan, Andrespas paypama mayayarisa mana pi uyaskapi tapunakurka: ");
INSERT INTO qvo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ima urasta Diosta mañana wasi chasna tulachi tukunka. Imata rikusa ña tulachi tukunkapa rahuskata yachanchi. ");
INSERT INTO qvo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus kutipasa nirka: —Kuyrarichi ama shukunapapi llullachi tukunkapa. ");
INSERT INTO qvo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achka runakuna ñukaparanti shamuskashina rimanakunka: —Ñuka Dios mantamuska kishpichi runami kani— nisa. Chayta uyasa achka runakuna llullachi tukunakunka —shutimi rimanakun— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kankuna shu karu llakta shu karu llaktawa makariskata uyasa ama manchaywa kaychichu. Maya llaktakunapas makarinkapa rahuskata uyasa ama manchaywa kaychichu. Manara kay pacha tukuriskapi chasna makarinakuna tiyankami, ranti kay pacha chayra mana tukurina uraschu. ");
INSERT INTO qvo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Shu llaktamanta runakuna shu llaktamanta runakunawa makarinakunka. Shu laya runakuna shu laya runakunawa wañurinakunka. Maykan partikunapi allpa kuyurinakuna tiyanka. Hatun yarkaypas tiyanka. Chaykunawa kay pacha tukurinkapa rahupi ñakarinakuna kallarinakunkami. Washa yali manchaypa yali manchaypa ñakarinakuna tiyanka. ");
INSERT INTO qvo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Chay uras kuyrarisa kawsaychi. Kankunata hapisa apukuna munturinama pushanakunka kastigachinkapa. Diospa shimita yachana wasikunapi kankunata liwachinakunka. Ñukawa sinchikusa kawsakuna kaskarayku piñariska runakuna kankunata hapisa pushanakunka hatun apukunapama kastigachinkapa. Chaypi paktasa apukuna ñupapi ñukamanta rimana kankichi. ");
INSERT INTO qvo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kay pacha chayra mana tukuriskapi Diospa kushi shimita tukuy partikunapi uyachina minishtirin. ");
INSERT INTO qvo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kankunata apukunapama pushanakupi kankuna rimankapa rahuskata ama yuyarisalla kaychichu. Chay urasllapita Dios kankunata rimana kaskata yuyachinka. Mana kankuna kikin yuyaymantachu rimankichi, Diospa Samay yuyachiskallata rimankichi. ");
INSERT INTO qvo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Shu runa paypa wawkita wañuchinkapa hapichinka. Shu yaya paypa churita hapichinka —wañuchinakuchu— nisa. Chasnallata churikuna yayakunawa piñarisa yayakunata wañuchinkapa hapichinakunka. ");
INSERT INTO qvo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kankuna ñukawa sinchikusa kawsakuna kaskarayku tukuykunapapi piñay tukunkichi. Maykanpas wañunakama mana sakisa ñukawa sinchikusa kawsa runa Dios kastiganamanta kishpichi tukunkami. ");
INSERT INTO qvo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Shu puncha Diosta mana balichi runa mana alikunata Diosma rupachisa rikuchiskata rikunkichimi payrayku mana yaykuypa kaskapi. (Kay killkata leyikuna, ima pasana kaskata rikusa paktarinata yachaychi.) Chay uras Judea allpapi tiya runakuna urkukunama kallpasa mitikunakuchu. ");
INSERT INTO qvo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Balla wasi hawapi ka runakuna utkalla uraykumunakuchu. Ama imatapas apankapa wasi ukuma yaykunakuchu. ");
INSERT INTO qvo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chakrapi kakuna wasima ama kuti rinakuchu churarinakunata apakrinkapa. Chaymantalla kallpasa urkukunama mitikunakuchu. ");
INSERT INTO qvo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Aylla chichu warmikuna, wawata chuchuchira warmikunapas! Chay uras paykuna yapa ñakarinakunka. ");
INSERT INTO qvo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","—Chay mitikuna uras ama tamya chiri killakunapi kachu— nisa Diosta mañaychi. ");
INSERT INTO qvo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay punchakuna manchaypa ñakarinakuna tiyanka. Kay pacha ruray tukuska urasmanta chasnashina ñakarinakuna manara tiyarkachu, chaywashapas mana kuti tiyankachu. ");
INSERT INTO qvo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chay ñakarinakuna unayapika tukuy runakuna wañunakunma. Ranti Dios payta kasusa kawsankapa maskaska runakunata llakisa chay ñakarinakuna mana unayankapa sakinka. ");
INSERT INTO qvo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chay uras maykan runakuna rimanakunka: —Rikuy, kaypimi Dios mantamuska kishpichi runa.— Mana kasaka rimanakunka: —Chaypimi Dios mantamuska kishpichi runa— nisa. Paykunata ama uyankichichu. ");
INSERT INTO qvo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","—Ñuka Dios mantamuska kishpichi runa kani— nisa yanka rimakuna tiyanka. —Dios rimaskata kwintani— nisa llullasa rimakunapas tiyanka. Hatun ushaywa ranakunata rasa runakunata llullachinakunka. Paykuna ushasaka Dios payta kasusa kawsankapa maskaska runakunatapas llullachinakunka. ");
INSERT INTO qvo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chayra manara paktariskapi tukuy chay pasana kaskata ñuka kankunata kwintarani. Chayta yachasa yuyankichi, kuyrarisa kawsaychi. Jesus rimasa katirka: ");
INSERT INTO qvo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kay pacha tukurinkapa rahuskapi manchaypa ñakarinakunawasha, inti yana tukunka, killapas mana ña rikuchinka. ");
INSERT INTO qvo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Estrellakuna hawapachamanta urmanakunka. Hawapachapas chukchurinka. ");
INSERT INTO qvo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chasnapi Dios mantamuska runa sinchi ushaywa puyukunapi shamusa rikurisha. ");
INSERT INTO qvo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anhelkunata mantamusha Dios maskaska runakunata tukuy partimanta tantachinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Igu kaspi yurapi tukuskata rikusa yachakuychi. Igu kaspi yura rama llulluyapi mushu panka llukshipi yachankichi inti killakuna paktamuraskata. ");
INSERT INTO qvo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chasnallata kankuna ñuka kuna rimaskashina tukuraskata rikusa, ñuka paktamunkapa rahuskata yachankichi. ");
INSERT INTO qvo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Alita uyawaychi. Kuna kawsa runakuna chayra manara wañunakupi ñuka rimaskashina paktarinkami. ");
INSERT INTO qvo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hawapacha kay pachapas tukurinkami. Ranti ñuka rimaska shimi chikapami kan, tukuy paktarinkami. ");
INSERT INTO qvo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tukuy ñuka rimaskashina tukuna kan, ranti ima uras kanata mana pi yachanchu. Punchapi kasa tutapi kasa mana yachanchi. Hawapachapi kawsa anhelkunapas mana yachanakunchu, ñukapas Dios mantamuska runa mana yachanichu, Dios Yayallami yachan. ");
INSERT INTO qvo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chayta yachasa yuyankichi, kuyrarisa kawsaychi. Kay pacha tukurina urasta mana yachankichi. ");
INSERT INTO qvo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kasnashinami kanka: Shu runa karuma rinayasa manara risa pay trabahachiska runakunata rimarka: —Ñuka wasita, chakrakunata kuyraychi— nisa. Karan runama kikin trabahuta kurka. Paypa wasi punkuta kuyrakamata rimarka: —Ñuka wasita alita kuyrapanki ñuka shamunakama.— Chay rimaskawa pay trabahachiska runakunata sakisa karuma rirka. ");
INSERT INTO qvo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kankuna kankichi chay amu kuti shamunakama sakiska runakunashinami. Chasna kasa tukuy uras ali yuyaywa kawsana kankichi. Mana yachankichichu imasnapimi shamusha, tutayaraskapichu, chawpi tutachu, kari wallpa kantaraskapichu, pakarinapichu. Kankuna ima urasmi ñuka kuti paktamunata mana yachapi tukuy uras ñuka rimaskata alita kasusa kawsaychi. ");
INSERT INTO qvo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chayta kankunata rimani ñuka paktamuna uras kankunata mana puñuraskatashina tupankapa, mana alita rasa kawsaraskata. ");
INSERT INTO qvo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kankunama rimaraskata tukuy runakunaraykumi kan: Tukuy uras ñuka rimaskata rasa kawsaychi. ");
INSERT INTO qvo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paskwa hishta puncha kankapa ishkay puncha chayra pishirka. Pan mana punkichiskata mikuna punchakunapas kallarinkapa ishkay puncha chayra pishirka. Chasnapi pakrikunapa apukuna kwintariranakurka Dios ñupa uras killkachiska killkata kutillata killkakamakunawa imasnata Jesusma hawachinata usharinka hapichisa wañuchinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Paykunapura rimarinakurka: —Hishta punchakunapi payta hapinkapa mana balinchu. Runakuna piñarisa ñukanchita wañuchinakunkachari— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus Betania llaktapi karka. Simonpa wasipi kahurka. Chay Simon ñupa uras millay karachayu kaskarayku runakuna payta shutichinakurka —millay karachayu— nisa. Jesus Simonpa wasipi shukunawa parihu mikuranakuskapi shu warmi shamurka. Yapa bali suma asna nardu sisamanta wirayu alabastro rumimanta rurariska butillashtuta apamurka. Jesus tiyaskama mayayasa butillashtu kunkata pakisa chay suma asna wirata Jesuspa uma hawapi talirka. ");
INSERT INTO qvo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Maykankuna chayta rikusa, yapa piñarisa paykunapura rimariranakurka: —Imaraykuta chasna yanka hichan chay yapa bali suma asna wirata. ");
INSERT INTO qvo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ñukanchi rantichinata ushanchima karka kinsa pacha puncha yali trabahasa ganaska tupupi, chay kullkiwa mana imayu runakunata yanapankapa— nisa chay warmita piñanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chasnapi Jesus rimarka: —Ama kay warmita pinkachisa rimaychichu. Kushilla kankapa sakichi. Ñuka alipa rawarka. ");
INSERT INTO qvo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mana imayu runakuna tukuy uras kankunawa kanakunmi, kankuna munaska uras paykunata yanapanata ushankichi. Ranti ñuka mana tukuy uras kankunawa kashachu. ");
INSERT INTO qvo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kay warmi pay ushaska tuputa rarka. Ñuka wañupi ñukapa ayawa rurana kaskata ñuparisa ñuka aychata chay suma asna wirawa armachirka. ");
INSERT INTO qvo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Alita uyawaychi. Tukuy partipi ñukamanta kushi shimita kwintanakupi kay warmimanta yuyarisa pay raskata kwintanakunka.— ");
INSERT INTO qvo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesus yachachiskata chunka ishkay katikamakunamanta shuka, Queriot llaktamanta runa Judas, pakrikunapa apukunapama rirka. Paykunawa kwintarisa —ñuka Jesusta hapichisha— nirka. ");
INSERT INTO qvo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pay rimaskata uyasa pakrikunapa apukuna kushiyanakurka. —Kan payta hapichipi ñukanchi kullkita kanma kurinka— rimanakurka. Chay urasmanta Judas yuyarisa kawsarka —ima puncha, ima uras ali kanka Jesusta hapichinkapa— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan mana punkichiskata mikuna hishtapi punta puncha borreguta wañuchina uraspi Jesus yachachiskata katikamakuna payta tapunakurka: —Maypita munanki ñukanchi Paskwa mikunata alichinkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tapunakupi Jesus pay yachachiskata ishkay katikamakunata kasna nisa mantarka: —Jerusalen llaktama richi. Chaypi shu yaku mankata apa runata tupankichimi. Payta katichi. ");
INSERT INTO qvo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pay yaykuraska wasipi chayllapita yaykunkichi. Chay wasi amuta ninkichi: Ñukanchita yachachikama kanta tapun: Maypita mikuna kwartu kan ñuka yachachiskata katikamakunaynti Paskwapi borreguta mikunkapa nisa. ");
INSERT INTO qvo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pay hawa patapi shu hatu kwartuta kankunata rikuchinkami tukuy ñukanchipa minishtiskakunawa. Chaypi mikunata alichinkichi.— ");
INSERT INTO qvo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chasna Jesus rimapi chay pay yachachiskata ishkay katikamakuna rinakurka. Jerusalen llaktapi paktasa tukuy Jesus rimaskashina tupanakurka. Chayllapi Paskwa mikunata alichinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tutayapi Jesus pay yachachiskata chunka ishkay katikamakunaynti chayma rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Paykuna mesa muyukta siririsa shu parti makiwa nitirisa mikuraskapi Jesus nirka: —Alita uyawaychi. Kankunamanta shu ñukawa mikura ñukata hapichinkapa rahun wañuchiwankapa.— ");
INSERT INTO qvo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chayta uyasa pay yachachiskata katikamakuna yapa llakirinakurka. Karan shuk shuk Jesusta tapunakurka: —Mana yuyarinki ñuka kanta hapichi kaskata, manachu— nisa. Chupi mesapi shu kallana tiyarka. Chay kallanapi lapayachiska mikuna tiyarka paykuna mikuna panta hukuchinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chasna kapi Jesus kutipasa nirka: —Kankunamanta shukmi kan. Ñukawa parihu panta kallanapi hukuchi runa ñukata hapichimi kanka. ");
INSERT INTO qvo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kay Dios mantamuska runa wañuchi tukuna kani Dios ñupa uras killkachiskashina tukunkapa. Ranti ¡aylla chay ñukata hapichi runa! Yapa ñakarinkami. Ali kama karka chay runapa mama mana payta pakarichinma karka.— ");
INSERT INTO qvo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mikuranakupi Jesus mikuna panta hapirka. Diosta pakrachusa panta pakisa paykunama kurka: —Hapichi, kay pan ñuka aychashinami kan— nisa rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Washa shu basuta hapirka. Diosta pakrachusa paykunama pasachirka. Tukuy paykuna upyanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chasnapi paykunata nirka: —Kay vinu ñuka yawarshinami. Ñuka wañupi yawar shuturinarayku achka runakuna paykunapa huchakunamanta pichay tukuska kanakunka. Chaywa Dios paktachinkami —runakunawa wankurisha— nisa rimaskata. ");
INSERT INTO qvo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Alita uyawaychi. Vinuta ña mana kuti upyashachu kay pachapi. Ranti shu puncha ñuka Yaya mushu pachapi tukuypa apu kahuskapi kuti kankunawa parihu mushu vinuta upyashunchi.— ");
INSERT INTO qvo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesus chasna rimaskawasha Paskwa mikunata kantasa tukuchinakurka. Chaywasha Olivos niska urkuma rinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus pay yachachiskata katikamakunaynti Olivos urkupi paktaskapi paykunata rimarka: —Dios ñupa uras killkachiskapi kasna riman: Borregukunata kuyra runata wañuchishami. Pay wañupi borregukuna karanma mitikusa rinakunka. Chay killkapi rimaskashina kuna tuta tukuy kankuna —yankamanta paywa sinchikuskanchi— nisa ñukata sakiwankichi. ");
INSERT INTO qvo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ranti ñuka wañuskawasha Dios kawsachiwankami. Kawsachi tukusa ñuka kankunata ñupasa Galilea allpama risha.— ");
INSERT INTO qvo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro chayta uyasa nirka: —Tukuykuna kanta sakinakupipas ñuka kanta katishami.— ");
INSERT INTO qvo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus payta nirka: —Alita uyaway. Kuna tuta kari wallpa chayra ishkay kuti manara kantapi kan ñukamanta kinsa kuti rimanki: —Payta mana riksinichu— nisa.— ");
INSERT INTO qvo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro kuti rimarka: —Kanwa parihu ñuka wañuna kapipas kanta hichusa mana sakiskankichu.— Tukuy shu katikamakunapas chasnallata rimanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesus pay yachachiskata katikamakunawa kwintarisa riranakuskapi tarpuska wayu kaspi yurakuna kaskama paktanakurka, Getsemani niskama. Jesus pay yachachiskata katikamakunata nirka: —Kaypi tiyaraychi, ñuka Dioswa kwintarikrinkapa rahuni.— ");
INSERT INTO qvo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chasna nisa Pedrota, Santiagota, Juantapas pushasa chaynishtuma rirka. Shunku chukchukta llakirisa sinchi manchay Jesusta hapirka. ");
INSERT INTO qvo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chasna tukusa nirka: —Shunku llakiriskawa sinchiyanayapi wañunkapa rahuskashina tukuskani. Kankuna kayllapi Diosta mañasa sakirichi. Ama puñunkichichu.— ");
INSERT INTO qvo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Jesus chaynima risa allpama shitarisa Diosta mañarka usharipi sinchi ñakarina paktamunkapa rahuskamanta payta kishpichinkapa. Kasna nisa mañarka: —Yaya, kan tukuyta ushanki. Ñuka sinchi ñakarinkapa rahuskamanta kishpichiwanki. Ranti ama ñuka munaskashina rurarichu, kan munaskashina tukuchu.— ");
INSERT INTO qvo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chasna mañaskawasha kuti kinsa sakiska pay yachachiskata katikamakunapama risa puñuraskata tuparka. Chasnapi Pedrota ñupa shuti kaskawa rimarka: —Ay Simonlla, puñurankichu. Manachu usharkanki shu urallapas Diosta mañasa chapawankapa. ");
INSERT INTO qvo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mana puñusa Diosta mañaychi huchata ranayaskata mana rankapa. Kankuna ali munaywa kasapas mana huchalinkapa yapa sampa kankichi chay munaskata paktachinkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chasna nisa Jesus kutillata Diosta mañankapa rirka. Ñupa mañaskashina kuti mañarka. ");
INSERT INTO qvo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kuti mañaskawasha chay kinsa pay yachachiskata katikamakuna kaskama paktasa paykunata kuti puñuraskata tuparka. Yapa puñunayaywa kanakusa kuti puñuska kanakurka. Jesus paktapi kawsarisa imata rimankapa mana yachanakurkachu. ");
INSERT INTO qvo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kinsa kuti risa kinsa kuti paykunapama shamusa pay yachachiskata katikamakunata nirka: —Chayra puñurankichi. Chaykamalla karka. Ura ña paktariskami Dios mantamuska runa hapi tukunkapa. Huchasapa runakunapapi kuy tukushami. ");
INSERT INTO qvo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hatarichi. Hakuychi. Ñukata hapichikama runa ña shamuran.— ");
INSERT INTO qvo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus rimaraskapi Judas shamurka. Pay chunka ishkay Jesus yachachiskata katikamakunamanta shu karka. Paywa parihu shu runa bula kaspikunawa ishkay partimanta filuyu sawlikunawa shamunakurka. Pakrikunapa apukuna, Dios ñupa uras killkachiska killkata kutillata killkakamakuna, ñukanchi Israel runakunapa kamachi rukukunapas chay runa bulata mantanakuska karka. ");
INSERT INTO qvo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Manara paktapi Judas paykunata rimaska karka: —Ñuka muchana runa kankuna maskaska runami. Payta hapisa alita watasa pushankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chasna kapi Judas Jesusma mayayarisa —Yachachikama— nisa payta mucharka. ");
INSERT INTO qvo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Judas chasna muchaskawa Jesus kaskata riksichipi chay runa bula Jesusta hapisa pushanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesuswa kaskakunamanta shu runaka ishkay partimanta filuyu sawlita hapisa pakrikunapa hatun aputa yanapa runata kishpilla kuchusa paypa nikrillata pitirka. ");
INSERT INTO qvo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus chay runa bulata nirka: —Shuwa runachu kani, kankuna kaspikunawa, ishkay partimanta filuyu sawlikunawa ñukata hapi shamuwankapa. ");
INSERT INTO qvo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Karan puncha kankunata yachachisa Diosta mañana wasipi kankunawa parihu karkanimi. Chaypi kaskapi mana hapiwarkankichi. Kuna chasna hapi tukunimi Dios ñupa uras killkachiskashina tukunkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chasna rimapi Jesuswa parihu kaskakuna payta sakisa kallpasa mitikunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Shu malta runa katanawa pilluriska Jesusta katisa rirarka. Paytapas hapinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chasnapi katanata sakisa llushpirisa llata kara kallpasa mitikurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesusta pakrikunapa shuklla hatun apupama pushanakurka. Chaypi pakrikunapa apukuna, ñukanchi Israel runakunapa kamachi rukukuna, Dios ñupa uras killkachiska killkata kutillata killkakamakunapas munturisa chapanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro karumanta katisa pakrikunapa hatun apupa wasikunawa muyukta kaska chusha pampapi yaykurka. Chaypi kuyrakamakunawa parihu nina mayapi tiyarikrirka kununkapa. ");
INSERT INTO qvo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pakrikunapa apukuna tukuy shu apukunaynti ñukanchi Israel runakunapa apukuna munturina bulamanta, Jesusta wañuchinata munasa maykan payta hawachisa rima runata maskanakurka. Ranti mana tupanakurkachu. ");
INSERT INTO qvo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achka runakuna llullasa Jesusmanta rimanakupipas mana parihumanta rimanakurka. Paykuna rimaska karan laya karka. ");
INSERT INTO qvo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Puchkaypi mayka runakuna llullasa paymanta kasna rimanakurka: —Ñukanchi uyarkanchi pay kasna niskata: ");
INSERT INTO qvo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ñuka tulachishami kay runa raska Diosta mañana wasita. Kinsa punchapi Diosta mañana wasita rurashami, mana runa raska laya wasita— nisa.— ");
INSERT INTO qvo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chasna rimanakusapas paykuna kwintaskakuna chikan laya kanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chasna kapi pakrikunapa hatun apu tukuykuna ñupapi shayarisa Jesusta tapurka: —Kanta hawachisa rimaskata uyasa manachu imata rimanki.— ");
INSERT INTO qvo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ranti Jesus chunlla uyarka. Pakrikunapa hatun apu kutillata payta tapurka: —Kanka ñukanchi chaparaska Dios mantamuska kishpichi runachu kanki. Diospa Churichu kanki.— ");
INSERT INTO qvo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus kutipasa nirka: —Ari, ñukami kani. Shu puncha ñukata, kay Dios mantamuska runata kuti rikuwankichi. Yapa ushayu Diospa yacha maki partima tiyaraskata rikuwankichi. Puyukunawa shamurata rikuwankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chayta uyasa pakrikunapa hatun apu yapa piñarisa paypa hawa churariskata likirka piñariskata rikuchinkapa. Chasna rasa nirka: —Kuna shuti ña mana shukta minishtinchichu pay mana ali raskata rimakamata. ");
INSERT INTO qvo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kankunalla pay Dioswa parihu kanayasa Diosta piñachina rimaskata uyarkankichi. Imatata ninkichi.— Tukuykuna shu yuyayllawa rimanakurka: —Pay wañuchi tukuna kan.— ");
INSERT INTO qvo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mayka runakuna payta tyukankapa kallarinakurka. Paypa ñawita tapasa payta makasa rimanakurka: —Rimay, pita kanta makaran.— Chaypi kuyrakamakunapas payta makaranakurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jesus makay tukuskapi Pedro wasikunawa muyukta kaska chusha pampapi tiyararka. Chasnapi pakrikunapa hatun aputa shu yanapa warmi shamurka. ");
INSERT INTO qvo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro nina mayapi kunuraskata rikusa alipacha paypama rikurka. Washa payta nirka: —Kanpas chay Nazaret llaktamanta Jesuswa purira karkanki.— ");
INSERT INTO qvo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro nirka: —Chay runata mana riksinichu. Imamantachari kan rimawanki mana yachanichu.— Chasna nisa wasikunawa muyukta kaska chusha pampamanta llukshinama riska, wasikuna mayapura kaska chupi chupima. Yaykuna chimpapura punkukuna chupipi shayarikrirka. Chasnapi kari wallpa kantarka. ");
INSERT INTO qvo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chay yanapa warmi Pedrota kuti rikusa shu chaypi tiyakunata rimarka: —Kay runa chay hapi tukuska runawa purikunamantami kan.— ");
INSERT INTO qvo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro nirka: —Mana paywa purikunamantachu kani.— Shukratuwasha chaypi kaskakuna Pedrota rimanakurka: —Shutipacha kan Jesuswa purikunamantami kanki, Galileamanta runa kaskarayku.— ");
INSERT INTO qvo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro piñarisa rimankapa kallarirka: —Ñuka llullasa rimapi Dios kastigawachu. Shutipacha mana riksinichu chay runata, maykamantami kankuna rimarawankichi.— ");
INSERT INTO qvo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chay urasllapita kari wallpa kutillata kantarka. Chayta uyasa Pedro Jesus rimaskata yuyarirka: “Kari wallpa ishkay kuti chayra manara kantapi kan ñukamanta kinsa kuti rimanki —payta mana riksinichu— nisa.” Chayta yuyarisa Pedro yapa wakankapa kallarirka. ");
INSERT INTO qvo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Punchayamuraskapi tukuy ñukanchi Israel runakunapa apukuna Jesuswa imana ruranata kwintariranakurka. Kanakurka: Pakrikunapa apukuna, ñukanchi Israel runakunapa kamachi rukukuna, Dios ñupa uras killkachiska killkata kutillata killkakamakuna, shu apukunapas. Ñukanchi Israel runakuna Roma runakunapapi amuyay tukuska kapi ñukanchi apukuna shu yuyayllawa tukusa Jesusta watasa Romamanta apu Pilatopama pushanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chayma paktachinakupi Pilato Jesusta tapurka: —Kan Israel runakunapa hatun apuchu kanki.— Jesus kutiparka: —Ari, kan shutipa rimanki.— ");
INSERT INTO qvo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Pakrikunapa apukuna Jesusta achkata hawachisa rimanakupi Pilato kutillata Jesusta tapurka: —Manachu sinchikusa kutipanki. Yuyari imasna kanta achkata hawachisa rimanakunmi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ranti Jesus chunlla uyarka, mana shu shimillatapas rimarkachu. Mana imata rimapi Pilato mana yacharkachu imata yuyarisa rimanata. ");
INSERT INTO qvo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paskwa hishta punchakunapi Pilato shu mana alita rurakuna tapana wasipi tapara runata kachari karka, ñukanchi Israel runakuna mañaska runata. ");
INSERT INTO qvo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay uras shu runa tapara Barrabas shutiyu tiyarka. Roma runakunawa piñari bulamanta kasa, chay piñari bulamantalla shuk runakunawa parihu tapay tukuska kanakurka. Romamanta aputa hichunayasa paypa suldarukunawa makarinakuskapi Barrabas shuk runata wañuchirka. Chayrayku tapay tukurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Barrabas chasna tapaska kahuskapi Israel runakuna apu Pilatopama risa mañanakurka: —Karan wata kan raskata ruray. Shu tapara runata kachari— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Apu Pilato yacharka pakrikunapa apukuna paykunalla apu kanayasa Jesuswa piñariska kanakuskata. Chasna piñariskarayku Jesusta paypama pushamunakuskata yacharka. Chayrayku mañakama runakunata tapurka: —Kay Jesustachu kacharisha. Munankichichu kankuna —ñukanchi Israel runakunapa hatun apu— niska runata ñuka kacharinkapa.— ");
INSERT INTO qvo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ranti pakrikunapa apukuna chay munturiska runakunata rimanakurka —Barrabasta kachari— nisa rimanakunkapa. ");
INSERT INTO qvo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chasnapi Pilato chay runakunata tapurka: —Imata ñuka rankapa munankichi chay kankuna —ñukanchi Israel runakunapa hatun apu— niska runata. ");
INSERT INTO qvo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tapupi sinchita kaparinakurka: —Payta kruspi klabasa wañuchi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chasna kaparinakupi tapurka: —Ima mana alikunata rarka.— Paykuna astawa sinchita kaparisa rimanakurka: —Payta kruspi klabasa wañuchi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Apu Pilato runakunata kushiyachinayasa Barrabasta kacharirka. Jesusta liwachinkapa mantarka. Suldarukuna Jesusta liwachiskawasha apu Pilato paykunata rimarka: —Chay runata kruspi klabasa wañuchichi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Suldarukuna Jesusta hapisa apu Pilatopa wasikunawa muyukta kaska chusha pampama pushanakurka. Paykunapa suldarukuna bulamanta tukuy suldarukunata kayachisa muntuchinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sani bali churanata Jesusta churachinakurka hatun apu churarina kaskatashina. Kurimanta tawasampata hatun aputa churachinashina kashawa awaskata paypa umapi churanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Washa payta pukllaskashina kaparisa rimaranakurka: —Israel runakunapa hatun apu, ali shamuska kanki— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chasnapi kaspiwa paypa umapi waktasa payta tyukaranakurka. Payta balichiskashina ñupapi kunkurinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chasna payta pukllachiskashina ruraskawasha sani churanata churachiskata llatanachisa kuti kikin churanata churachinakurka. Chaywasha payta kruspi klabasa wañuchinkapa pushanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesusta kruspi shayachisa wañuchinkapa pushanakupi Cirene llaktamanta runa Simon shutiyuta tupanakurka. Payka Alejandropa, Rufopa yaya karka. Chakramanta shamuraskapi Jesuspa krusta aparichinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesusta Golgota niskama pushanakurka (Golgota yuyachin “Aya Uma Tullu Urku”). ");
INSERT INTO qvo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Suldarukuna nanayta upayachina mirra niska hampiwa masaska vinuta Jesusta upyachinayasa rikuchinakurka —upyay— nisa. Ranti Jesus mana upyanata munarkachu. ");
INSERT INTO qvo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chasnapi payta llatanachiskawasha ña kruspi klabasa shayachinakurka. Paypa churanakunata hapinakurka. Rumikunawa shitasa kamanakurka —pita amuyanka— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesusta kruspi klabasa shayachiska uras tutamanta iskun uraspi karka. ");
INSERT INTO qvo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Paypa kruspi talapa killkara tiyarka —Israel runakunapa hatun apu— nisa. Chay talapata churanakurka imarayku wañuchinakun nisa runakuna yachankapa. ");
INSERT INTO qvo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuswa parihu kruspi klabasa shayachinakurka ishkay runakunata, wañuchisa purikunata. Karan runata shuk shuk kruspi shayachinakurka, shukta Jesuspa yacha maki partima, shukta Jesuspa lluki maki partima. ");
INSERT INTO qvo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chasna ruraskawa Dios ñupa uras killkachiskashina paktarirka. Ñupa uras Dios killkachiskapi kasna nin: Huchayu runata raskashina payta ruranakurka nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Kruskuna shayaraska mayata puri runakuna umata kuyuchisa Jesusta pukllachiskashina rimanakurka: —Kan Diosta mañana wasita urmachikama kasa, chayta kinsa punchapi shayachikama kasa, krusmanta uraykusa kan kikinllata kishpiri— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pakrikunapa apukuna Dios ñupa uras killkachiska killkata kutillata killkakamakunaynti Jesusmanta asisa paykunapura rimarinakurka: —Shukunata kishpichirka, ranti pay kikinllata kishpirinata mana ushanchu. ");
INSERT INTO qvo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dios mantamuska kishpichi runa kasaka ñukanchi Israel runakunapa hatun apumi, krusmanta uraykuchu, chayta rikusa ñukanchi paywa sinchikunkapa— nisa. Jesuspa mayapi shuk kruskunapi paywa parihu wañura runakunapas paymanta asisa payta mana alita rimanakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesusta kruspi klabasa shayachinakuskawasha chupi punchamanta chupi chishikama tukuy partipi yanayarka. ");
INSERT INTO qvo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chupi chishipi Jesus sinchita kaparirka: —Eloi, Eloi, lama sabaktani. Chay rimanayan: Ñuka Dioslla, ñuka Dioslla, imaraykuta ñukata hichuwarkanki— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mayka chaypi kaskakuna rimanakurka: —Eliasta kayaran— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chasnapi shu runa kallpa risa llachapata akru vinupi hukuchirka. Pintu puntapi churasa Jesusta upyachinayasa rikuchirka: —Hakuychi rikushunchi, Elias shamunkachu manachu shamunka payta uraykuchisa kishpichinkapa. Mana imata rasa pay utka wañunkapa chayra chapashunchi— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chasnapi Jesus sinchita kaparisa wañurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chay urasllapita Jerusalenpi Diosta mañana wasipi Dioswa tupana kwartuta harkasa warkura churana hawamanta urayma pasakta likirirka. Chay kwartu kaska kinsa pasay wasikunawa muyukta kaska pampa mayapi ka wasi ukupi. ");
INSERT INTO qvo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesuspa krus shayaraska ñupapi ñawipura suldarukunapa apu shayararka. Jesus imasna wañuskata rikusa rimarka: —Shutimi kay runa Diospa Churi karka— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mayka warmikuna karumanta tukuyta rikuranakurka. Shu karka Magdala llaktamanta Maria, shu karka Santiago, Jose shutiyu wawkikunapa mama Maria, shu Salome karka. ");
INSERT INTO qvo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chay warmikuna Jesus Galilea allpapi kaska uras payta yanapasa katinakurka. Chaywasha chay warmikuna shuk warmikunawa Jesuswa parihu Jerusalenma shamunakurka. ");
INSERT INTO qvo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jesus wañuskawasha, chay chishillata Jose shutiyu runa apu Pilatopama rirka. Chay chishipi ñukanchi Israel ayllukuna samana puncharayku alichirina kanakurka. Inti yaykuraskapi ña samana kallarirka. Apu Pilatopama paktasa Jose mana manchaskawa Jesuspa ayata mañarka. Jose Arimatea llaktamanta karka, ñukanchi Israel apukuna munturina bulamanta shuk apu karka. —Ali yuyayu apumi— nisa runakuna yuyarinakurka. —Dios kallarichu kay allpapi runakunata amuyankapa— nisa yuyarisa kawsarka. ");
INSERT INTO qvo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Apu Pilato yuyarirka —Jesus chayra kawsa imachari— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chayrayku suldarukunapa aputa kayachisa tapurka: —Jesus shutipa wañuskachu— nisa. Suldarukunapa apu ari rimapi Pilato Joseta nirka: —Jesuspa ayata apaylla— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jose risa ñutu pilluna llachapata rantirka. Washa Jesuspa ayata krusmanta uraykuchisa chay llachapawa pillurka. Sunima allaska rumi wayku hutkupi churarka. Hatun rumita tankasa punkuta taparka. ");
INSERT INTO qvo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala llaktamanta Maria, Josepa mama Mariapas rikunakurka maypi Jesuspa aya churay tukuskata. ");
INSERT INTO qvo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samana puncha pasaskawasha Magdala llaktamanta Maria, Santiagopa mama Maria Salomenti suma asna wirakunata rantinakurka Jesuspa ayata armachinkapa. ");
INSERT INTO qvo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semana kallariska punchapi tutamantashitu Jesus wañuskata churay tukuska rumi hutkuma rinkapa llukshinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Chasna puriraskapi parihumanta kwintarinakurka: —Ayata churay tukuska rumi hutkumanta pimi tapara rumita anchuchinka— nisa. ");
INSERT INTO qvo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Chayma paktasa rikunakupi chay tapana hatun rumi mayama anchuchiska karka. ");
INSERT INTO qvo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chay warmikuna sunima allaska rumi wayku aya hutkuma yaykunakurka. Chasnapi suni yura churarinata churariska malta runa yacha maki partima tiyaraskata rikunakurka. Payta rikusa mancharinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chay malta runa rimarka: —Ama mancharinkichichu. Kruspi wañuska Nazaretmanta Jesusta maskankichi. Kaypi illanmi. Wañuskamanta kawsariskami. Rikuychi, pay churay tukuskapi illanmi. ");
INSERT INTO qvo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kuna Pedrota kwintakrichi, Jesus yachachiskata shu katikamakunatapas: Jesus kankunata ñupasa Galileama rinkapa rahun pay rimaskashina. Chaypi payta rikunkichimi— nisa rimakrichi. ");
INSERT INTO qvo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chay rimaskata uyasa warmikuna kallpa aya hutkumanta llukshinakurka. Manchaywa chukchurisa pitapas mana imata kwintanakurkachu. ");
INSERT INTO qvo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus semana kallariska puncha pakariraskapi wañuskamanta kawsarirka. Kawsariskawasha manara shukunama rikurisa Jesus ñupa Magdala warmi Mariama rikurirka. Ñupa uras paymanta kanchis millay supaykunata llukshichiska karka. ");
INSERT INTO qvo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Jesus kawsariska kaskata rikusa kwintakrirka Jesuswa parihu puriska runakunapama. Paykuna Jesus wañuskamanta llakirisa wakaranakuskata tuparka. ");
INSERT INTO qvo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria rimaskata uyasa: —Jesus kawsanmi. Ñuka payta rikurkani— nisa, paykuna yuyarinakurka mana shutipa kaskata. ");
INSERT INTO qvo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaywasha Jesus mana paykuna riksiska runashina pay yachachiskata ishkay katikamakunama rikurirka. Paykuna Jerusalen llaktamanta llukshiraskapi rikurirka. ");
INSERT INTO qvo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chasnapi chay Jesus yachachiskata ishkay katikamakuna kuti Jerusalenmallata rinakurka. Jesus yachachiskata shu katikamakunama rinakurka Jesus kawsa kaskata kwintankapa. Paktasa kwintanakupi mana shutipa kaskata yuyarinakurka. ");
INSERT INTO qvo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaypawasha Jesus pay yachachiskata chunka shu katikamakuna parihu mikuraskapi paykunama rikurirka. Jesus paykunata piñasa rimarka pay ñupa uras rimaskata paykuna yanka rimaskashina yuyariskamanta. Chasnallata piñasa rimarka pay kawsariskata rikukuna —yanka llullanmi— nisa yuyariskamanta. ");
INSERT INTO qvo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesus pay yachachiskata katikamakunata rimarka: —Tukuy partita purisa ñukamanta kushi shimita tukuy runakunama kwintakrichi. ");
INSERT INTO qvo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mayka runa ñukawa sinchikusa bawtisari tukusa kishpichiska kanka wañuskawasha chikapa kastigay tukunamanta. Mana ñukawa sinchikukuna wañuskawasha chikapa kastigay tukunakunka. ");
INSERT INTO qvo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ñukawa sinchiku runakuna ushanakunka hatun ushaywa ranakunata rikuchinkapa. Ñukaparantimanta supaykunata runakunamanta llukshichinakunka. Paykuna manara yachaska shimikunapi kwintanakunka. ");
INSERT INTO qvo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Machakuykunata makiwa hapinakupipas mana ushanakunkachu paykunata wañuchinata. Wañuchi hampita upyanakusapas mana imapas tukunakunka. Unkuskakunapi makita churanakupi chay unkuskakuna aliyanakunkami— nisa Jesus rimarka. ");
INSERT INTO qvo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pay yachachiskata katikamakunata rimaskawasha tukuypa amu Jesus hawapachama pushay tukurka. Diospa yacha maki partima tiyarikrirka. ");
INSERT INTO qvo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pay yachachiskata katikamakuna tukuy partipi Jesusmanta kushi shimita kwintakrinakurka. Ñukanchipa amu Jesus paykunata ushayta kusa yanaparkami. Paykuna rimaska shimi runakuna shutipa kaskata yachanakunkapa hatun ushaywa ranakunata rikuchinakurka.");
ALTER TABLE qvo_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
