﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvnNT_vpl;
CREATE TABLE qvnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvnNT_vpl WRITE;
INSERT INTO qvnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Rey Davidpa castan aywagmi cara Jesucristoga. Paypa unay awilluncunaga caycunam capäcura: ");
INSERT INTO qvnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahammi. Abrahampa churinga cara Isaacmi. Isaacpa churinga cara Jacobmi. Jacobpa churinga cara Judäwan shulca wauguencunam. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judäpa warmin cara Tamarmi. Paychru churin cara Fareswan Zaram. Farespa churin cara Esrommi. Esrompa churinga cara Arammi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa churinga cara Aminadabmi. Aminadabpa churinga cara Naasonmi. Naasonpa churinga cara Salmonmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa warmin cara Rahabmi. Paychru churin cara Boozmi. Boozpa warmin cara Rutmi. Paychru churin cara Obedmi. Obedpa churinga cara Isaïmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaïpa churinga cara Rey Davidmi. Rey Davidpa churinga cara Salomonmi. Salomonpa mamanmi cara Uriaspa viüdan. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa churinga cara Roboammi. Roboampa churinga cara Abiasmi. Abiaspa churinga cara Asam. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa churinga cara Josafatmi. Josafatpa churinga cara Jorammi. Jorampa churinga cara Uziasmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa churinga cara Jotammi. Jotampa churinga cara Acazmi. Acazpa churinga cara Ezequiasmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa churinga cara Manasesmi. Manasespa churinga cara Amonmi. Amonpa churinga cara Josiasmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa churinga cara Jeconiasmi, nätan Jeconiaspaga caram shulca wauguencunas. Jeconías cawanan wichanmi cay casta runacuna Babiloniaman aywachisha capäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chaychrümi Jeconiaspa churin Salatiel näcirura. Salatielpa churinga cara Zorobabelmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa churinga cara Abiudmi. Abiudpa churinga cara Eliaquimmi. Eliaquimpa churinga cara Azormi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa churinga cara Sadocmi. Sadocpa churinga cara Aquimmi. Aquimpa churinga cara Eliudmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa churinga cara Eleazarmi. Eleazarpa churinga cara Matanmi. Matanpa churinga cara Jacobmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa churinga cara Josëmi. Paymi cara Mariapa gowan. Nätan Mariapa wawanmi cara Jesusga. Paymi cara ‘Salvacugtam cachramushag’ Diosga ningan. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahampita Rey Davidcama Jesuspa awilluncuna cara chrunca chruscuyogmi. Nätan Rey Davidpita Babiloniaman cay casta runacunata aywachipäcungancama Jesuspa awilluncuna cara chrunca chruscuyogmi. Chay Babiloniata aywachisha capäcunganpita Jesucristo näcingancamas awilluncuna cara chrunca chruscuyogmi Jesuspagga. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesús näcingan caynuymi cara: Jesuspa maman Mariaga Josëwan nä rimasham capäcura casarapäcunanpag. Chauraga manaragsi juclapapäcuptilanmi Mariaga pachrayog ricacarura Santu Espiritupa munayninwan. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Chaymi rimaynin Josëga Dios ningannuy ali rurag car, jinaman Mariata mana wanuchipäcunanta munarga pacaylapa ushacaruyta munara. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chaynuy pinsiayaptilanmi, José punuyaptin sueñuyninchru Diospita shamusha angelga cay nirura: “Davidpa castan José, ama piñäcuychu rimashay Mariawanga casaracuy. Payga Santu Espiritupa munayninwanmi pachrayog cayan. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gueshyacungasi olgo wamratam. Jinaman jutintam chrurapunqui Jesusta. Chaynuy jutin canga juchacunapita perdonarcur runancunata salvanan captinmi” nira. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lapan caycuna ruracara Diospa unay willacugnin cay ningan ruracänanpagmi: ");
INSERT INTO qvnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mana olgo regueg jipashmi pachrayog ricacunga, jinaman gueshyacunga juc olgo wamratam. Nätan jutintam chrurapunga Emanuelta”. (‘Emanuel’ ninanga ‘Diosga cayan noganchiwan’ ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chaura Josëga punuyanganpita riccharamurga Diospa angelnin ningannuylam Mariawan casararura. ");
INSERT INTO qvnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nätan wamra näcimungancamaga Mariawan Josëga manam parëju punupäcuraragchu. Chauraga nä wamra näciruptinga jutinta chrurapura Jesustam. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesusga näcirura Belén marcachrümi Herodes nipäcungan Judea nacionchru rey cayaptin. Chauraga cieluchrüshi juc goyllar ricacarura. Chayta ricapururshi goyllarcunawan tantiag runacunaga inti yargamunan lädu caru marcapita chrarärimun Jerusalenman. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Chauraga Rey Herodesman chrarärimurga tapucarärin cay nirmi: “¿Maychrütag cayan chay Israel casta runacunapa reynin cananpag näcisha wamra? Marcäcunachrümi ricapusha capäcü paypa goyllarninta. Chaymi aywararcayämü alawapäcunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nipäcugta mayaruptinga, chay Herodespaga manam imanänansi yachracarachu. Chaynuymi ricacarärira Jerusalenchru lapan mayagcunas. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chauraga sacerdöticunapa mandagnincunatawan Moisés isquirbinganpita yachrachigcunata gayarcachimurmi tapurun: “¿Maychrütag näcinan cara ‘Salvacugtam cachramushag’ Dios ningan?” ");
INSERT INTO qvnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chaynuy tapuptin paycunaga cay nirärinmi: “Judea ningan Belén marcachrümi. Diospa willacugnin isquirbinganchru cay niyanmi: ");
INSERT INTO qvnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Gam Belén, manam ichiclapag ricashachu canqui Judeachru marcacunapita. Gampita juc mandagmi yargamunga uysha michig runanuysi Israel runacunata ricananpag’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chaynuy nigta mayarur Rey Herodesga goyllarcunapita tantiag runacunatam pacaylapa gayarachin. Jinarcurmi chraräriptin shumag musyananpag tapurun: “¿Imaynuytag chay goyllarta ricapapäcuray?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nä willaparäriptinga Belenta aywapäcunanpagmi cachrarun “Aywapäcuy wamra ashig. Tarirurga cutipäcamuy willapäcamänaypag nogas alawag aywanäpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chaynuypa rey niruptinga aywacurcaram. Nätan chay aywapäcuptin goyllarga aywara naupancunatam. Nä wamra wichanninman chrarur chay goyllarga nä manam masta cuyurachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chaura pachalanchru chay goyllar cayagta ricaparärirga aliscam cushicarärira. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nä wayiman yaycarärirga ricarärin wamrata maman Mariatawan cayagtam. Jinarcurmi naupanman gongorpacayärir wamrata alawarärin cushisha. Chaypitaga apapäcungantam gorärin öruta, inciensuta, ‘mirra’ ningan alisca chranin välig perfümita. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaura chay runacunataga sueñuyninchrümi Diosga willarunag mana Herodespa cutipäcunanpag. Chauraga marcanta cuticurcänag juclä camiñupam. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Goyllarwan tantiagcuna nä cuticurcaptinga, Munayniyog Diospa angelninmi Josëta sueñuyninchru cay nirun: “¡Jucla sharcuy! Aywacuy Egiptota, wamrata mamantinta pushacurcur. Chaychru camunqui cutimuy ningagcamam. Herodesga wamrata ashinga wanuchinanpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Niruptinga chayüram Josëga sharcurun. Chauraga wamrata mamanta pushacurcurmi pagaspa aywacun Egiptota. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chaychru yachrapäcamusha Herodes wanungancamam. Chaynuy cara Munayniyog Dios unay willacugninwan “Churïta Egiptopitam gayamusha cä” ningan ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chay goyllarwan tantiagcuna jucläpa cutipäcunganta Herodes nä musyarurga aliscam piñäcurura. Chaura chay goyllarwan tantiagcuna willanganta yuparcurmi cachrarun Belenta, jinaman muyuragninchru yachrag runacunapa olgo wamrancunata wanuchipäcamunanpag. Chauraga ishcay watayogpita iñashacamam lapanta wanurärichin. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chaynuy ruracara Diospa unay willacugnin Jeremías ");
INSERT INTO qvnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá marcachrümi mayacasha alisca gapachracungan, alisca wagangan, alisca laquicungan. Raquelmi wamrancunapita alisca juyupa waganag. Payga ama wagaychu nircayaptinsi, manam upälayta munanchu chay wanusha wamrancunapita” ningan ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Chaypitam Egiptochru José yachrayaptin, Herodesga wanurun. Chaylam Munayniyog Diospa angelnin sueñuyninchru Josëta cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“José, canan Israel castaycunacagta cuticuy wamrata mamantinta pushacurcur. Wamrata wanuchiy munagcuna nämi wanurärin”. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Niruptin Josëga chayüram Israel castancunacagta cutimura, wamrata mamantinta pushacurcur. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chaura Judeachru Herodespa churin ‘Arquelao’ jutiyog taytanpa trucan mandayanganta musyarurmi, Josëga Judeaman chrayta mancharirun. Chauraga sueñuyninchru willachisha carga ‘Galilea’ ninganta aywacura. ");
INSERT INTO qvnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nä Galileaman chrarurga aywacura Nazaret marcatam yachrag. Chaynuy ruracara Diospa unay willacugnincuna “Nazareno runa nisham canga” nipäcungan ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chay wichanmi Bautizag Juanga Judea ninganchru jäpag pampachru runacunata rimapara cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Diospa munayninchru cawanaypag nämi nachrgayämun. Chauraga juchaycunapita wanacurcur Diosman cutipäcuy” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bautizag Juan chaynuy willapacunanpita Diospa unay willacugnin Isaías nämi isquirbisha cara: “Jäpagchrümi juc runa gayacuypanuy rimayan: ‘Munayniyog Diosta chrasquicurcänaypag camaricurcay. Lutan ruraycunata dëjarcur alicagta rurapäcuy’ nir”. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nätan Bautizag Juanpa jacunmi cara ‘camellu’ jutiyog uywapa milwanpita rurasha. Jinaman wachrucunmi cara garapita rurasha, micuyninsi cara salta piricu nirayag langosta jutiyog curum, jinaman chrinyashpa mishquincunalam. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Chauraga Juan cayangancagmanmi runacuna aywapäcura Jerusalenpita, entëru Judeapita, Jordán mayu lädunchru marcacunapita. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chay Jordán mayuchru Juanga runacunata bautizara “Wactam u caytam juchäcusha cä” nigcunatam. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Chaura fariseo ningancunawan saduceo ningancuna bautizächicug achca shapäcamugta ricarmi, Bautizag Juanga cay nin: “¡Gamcuna carcayanqui acapa casta culebracunanuymi! ¿Pitag gamcunata willarärishunqui alisca cunchuy nä nachrgayämugpita gueshpipäcunaypag? ");
INSERT INTO qvnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chauraga juchaycunapita wanacurcur Diosman razonpa cutipäcungayrag musyacächun ali cawapäcungaypa. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nätan ama nicurcaychu: ‘Taytä Abrahampa castan cayarga manam cunchushagchu’ nirga. Noga nipäcug: Diosga cay rumicunatas Abrahampa churincunamanga muyurachinmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nätan monticunata sagtananpag juc runa jächan aptashanuymi Diosga nä camarayämun mana ali ruragcunata ninachru cunchuchinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Chaura jucha rurayanganpita wanacurcur Diosman cutigcagtam nogaga yacuwan bautizayä. Nätan nogapa guepäta aywayämugga mas munayniyogmi nogapitaga cayan. Nogaga manacag runam cä paypa sandalianta apapunaläpagsi. Paymi ichaga cachramunga Santu Espirituta gamcunaman Dios munangannuy ali cawayta yanapapäcushunaypag, nätan imatas nina rupar ushagnuymi juchaycunata illacächinga. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Diosga cayan trïguta wauyachinanpag wauyachicunan nä aptashanuymi. Chaypitam wauyarcachir trïguta gotunga chruracunanman. Nätan muchruntam rupachinga mana imaysi upig ninawan” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chaura Galileapitam chraramun Jesussi Juan cayangan Jordán mayuman Juan bautizänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nätan Bautizag Juanga manam munarachu, “Manam nogaga gamta bautizagmanchu, antis nogatam gamga bautizämanquiman” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chaynuy niptinmi Jesusga nirun: “Cananga ima-ayga captinsi bautizämay. Chaynuymi rurananchi cayan. Nätan chaynuy rurarga Dios mandangantam rurayanchi”. Chay niruptinmi Juanga bautizarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chaura bautizächicurcur yacupita yargayämurmi, Jesusga ricapurun Santu Espíritu jana pachapita palömanuy payman aywayämugta. ");
INSERT INTO qvnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chaylam Diosga jana pachapita rimaramun: “Payga cuyayangä Dios-mayïmi. Paypitaga alisca cushisham cayä” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaypitam Santu Espirituga Jesusta pusharunag chunyag pampaman, Asyag casquinwan juchäcachiyta munananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chaychru cara Jesusga chruscu chrunca pagaswan chruscu chrunca junagmi mana micular. Chaypitam ichaga alisca juyupa micanarura. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jinarcurmi Jesusman Asyag chrarurga cay nin: “Diospa-mayin carga mä cay rumicunata niy tantaman muyunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Niptinmi Jesusga “Dios isquirbichinganchru cay niyanmi: ‘Manam micuylawanragchu runaga cawan. Dios mandangancunata cäsucursi runaga cawanmi’ niyanmi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaura Jesusta Asyagga pusharun Diospa marcan Jerusalentam. Jinarcurmi Diospa wayin jananman jegarcachir, Asyagga cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Diospa-mayin carga mä caypita jegarpuy. Dios isquirbichinganchru cay niyanmi: ‘Cachramushag angelnïcunatam maquincunalaman ishquinaypag, chauraga manam rumicunaman sagtacunquichu’ niyanmi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chaynuy niptinmi Jesusga “Dios isquirbichinganchru caynuymi niyan: ‘Amam Munayniyog Diosniquita shongoy munangannuy rurachiyta munanquichu’ ” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaypitas yapaymi Asyagga Jesusta pusharun mas altunnin jircata. Chaychrümi ricarachin cay pachachru lapan nacioncunata jinaman chaychru ima-ayga alinnincagcunatas. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jinarcurmi cay nirun: “Naupachru gongorpacuyur alawämaptiquiga, cay lapan ricangaycunatam goshay” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chaura Jesusga cay ninmi: “Shumagla aywacuy Asyag. Diospa isquirbichinganchru cay niyanmi: ‘Munayniyog Diosniquipa naupalanchrümi gongorpacunquis, nätan pay munangantam ruranquis’ niyanmi” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chaynuypa niruptin Asyagga aywacunmi. Chaylam Diospa angelnincuna Jesusmanga chrarärin ima-aygachrüsi atendipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chaypitam Jesusga Bautizag Juan carcelchru wichrgarayanganta mayarur cutira Galileachru Nazaret marcanta. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nätan Nazaretpitaga aywacura yachrag Capernaum marcatam. Chayga cayan Galilea gochra manyanchrümi; Zabulonpa jinaman Neftalïpa mojonnincagchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nätan Capernaumchru Jesusga yachrara Diospa unay willacugnin Isaiaspa isquirbishanchru cay ningan ruracänanpagmi: ");
INSERT INTO qvnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulonwan Neftalí yachranganchrümi ali willapa willapacarun. Chayga cayan jatun gochraman camiñu aywagchrümi, Jordán mayu chimpanchrümi, juc casta runacuna yachrangan Galilea ninganchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chaychru juchäcuyälar cawag runacunam ali willapata mayacarärin. Jinaman imaycamas cunchuyman nä yaycugpag cayag runacunapagmi ali willapa willapacarun” ningan ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nätan Capernaumman chranganpita-pacham Jesusga yachrachiyta galayura cay nir: “Juchaycunapita wanacurcur, Diosman cutipäcuy. Nämi Diospa munayninchru cawapäcunay wichan nachrgayämun” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chay Galilea gochra manyanpa aywayarmi, Jesusga ishcay runata ricapurun ataräyancuna jitarpurcayagta. Paycunapaga uryaynincuna cara pescacuylam. Jucpa jutin cara Simón. Paytaga Pedro nipäcugmi, jucagpam cara Andrés. Chay runacunaga capäcura chay wauguelam. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chaura Jesusga cay nirunmi: “Shamuy, nogawan uryashun. Nogam yachrachipäcushay juc pescacugnuy imanuypa runacunata Diosman aywachimuytas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Niptinga ataräyancunata chrurayärirmi aywacurcan Jesuswan. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chaypita mas washascata aywayarmi, yapay ricapurun ishcay waugueta, Jacobotawan Juanta. Paycuna ishcayninsi capäcura Zebedeopa churinmi. Paycunaga büquinchrümi taytanwan carcayänag ataräyancunata alchayar. Chaura Jesusga ishcaynintam gayarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chaura paycunaga chayüram taytanta büquintawan dëjarcur Jesuswan aywacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nätan chay Galilea gochra ninganchrüga manyancunapam Jesusga purira, Israel castäcuna gotucarcänan wayicunachru yachrayächir. Payga purira Diospa munayninchru cawaypita ali willapata willapacuyarmi, jinaman runacunata lapan nanaycunapitawan tucuy gueshyacunapita cuticayächirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesús chaynuy cuticächinganpitaga Siria ninganchru lapanmi rimapäcura. Chaymi payman aywachipäcamura lapan gueshyayagcunata, tucuy nanaywan cunchuyagcunata, Asyagpa munayninchru cayag runacunata, wanupaywan gueshyagcunata, uncutucushacunata, nätan Jesusga lapantam cuticächira. ");
INSERT INTO qvnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chauraga achcam runacuna Jesusta gatirapäcura Decapolispita, Galileapita, Judeapita, Jerusalenpita, Jordán mayu chimpan inti yargamunan lädupita. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chaura chay alisca achca runacunata ricapururmi, Jesusga juc gotuman jegarcur tacuyun. Chayman discïpuluncuna ashuyaräriptinmi, ");
INSERT INTO qvnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yachrachira cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushisham capäcunga cay nigcuna: ‘Quiquiläpa munayläwan manam Diospag ali cawayta atipämanchu’ nir tantiacugcuna. Chaynuy nigcunaga nämi cawarcayan Diospa munayninchru. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Cushisham capäcunga laquisha cawarcayagcuna. Paycunaga cushicachisham capäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Cushisham capäcunga ima-aygata rurarcayaptinsi gasilacagcuna. Paycunaga yachrapäcunga ‘Dios goshagmi’ ningan marcachrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Cushisham capäcunga yacunaypanuy micanaypanuy Dios munanganta imanaypanuysi ali ruray munagcuna. Paycunataga Dios yanapangam chay munayangannuy ali rurayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Cushisham capäcunga cuyapäcug runacuna. Paycunata Dios cuyapangam. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Cushisham capäcunga shongoncunapita mana juchachashacuna. Paycunaga Diosta ricapäcungam. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Cushisham capäcunga runacuna gasila cawapäcunanpag yanapagcuna. Paycuna capäcunga ‘Diospa castan’ nisham. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Cushisham capäcunga ali ruranganpita chregnisha cagcuna. Paycuna cawapäcunga Diospa munayninchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Cushisham capäcunqui, runacuna nogapa janä ashlipäcushuptiqui, imatas lutanta rurapäcushuptiqui, ima-aygatas lutan manacagcunata nipäcushuptiqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chaynuy rurapäcushuptiqui cushicurcay, jana pachachru Dios gopäcushunqui aliscannintam. Chaynuymi ima lutantas rurapäcura Diospa unay willacugnincunata”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Cay pachachru gamcuna carcayanqui cachrinuymi runacunapag. Nätan chay cachri mana puchgogman muyuruptinga ¿imanayparag puchgogman yapay muyunman? Chaynuy carga manam imapagsi välinchu, antis wicapanchi washamanmi runacuna jarunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Cay pachachru gamcuna carcayanqui achquinuymi runacunapag. Juc marca gotuchru captinga, manam pacayta atipanchichu. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Manatan lamparinta ratachirsi pacayninmanchu chruranchi, antis chruranchi ricäpayninmanmi wayichru cagta lapanta achicyänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chaynuy gamcunaga alita rurarcayar cawapäcuy Diospa razonpa capäcungayta runacuna musyapäcunanpag. Chaynuy cawagta ricapäcushurniqui jana pachachru cayag Diosniquicunata alawapäcungam”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama nogapag pinsiapäcuychu cay nir: ‘Payga shamusha Moisés isquirbingancunatawan Diospa willacugnincuna isquirbinganta manacagman muyuchinanpagmi’ nirga. Nogaga manam chaypagchu shamusha cä, antis aywarayämüga paycuna isquirbingancunata imanuypa cawana cangantas cawangäwan musyachigmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nipäcushay razoncagta: Jana pachasi cay pachasi cayangancamaga chay isquirbisha cayagcuna ruracanga lapanran. Nätan manam, mana ruracälarga canganchu maygan ichic isquirbishalas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chauraga pisi chay isquirbishacunapita juc ichiclatas mana cäsucugga, jinaman runacunata mana cäsucuyta yachrachigga, manacagpag ricasham canga, Diospa munayninchru cawar. Nätan pisi lapalanta cäsucugga, jinaman lapalan cäsucuyta yachrachigga, canga alisca alinninpag ricasham Diospa munayninchru cawar. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nätan noga nipäcug: Moisés isquirbingan yachrachigcunapita jinaman fariseo ningancunapita mana mas ali cäsucurcarga, manam imanacursi yaycapäcunquichu Diospa munayninchru cawaymanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nätan gamcunaga mayapäcuraymi unay awilluycuna cay nir yachrachipäcunganta: ‘Runa-mayiquita amam wanuchinquichu. Wanuchigtaga Diosmi juc junag juchanpita cunchuchinga’ nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nätan nogaga cay nipäcugmi: Pisi runa-mayin chregnipagga canga chay juchanpita cunchuchisham. Nätan runa-mayinta ‘Wacga manam imatas musyanchu’ nigga canga marcachru mandagcunapita cunchuchisham. Nätan runa-mayinta ‘Gotara’ nir chregnipagga nä cayan nina wayiman aywananpag nisham. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Chauraga altarman u ofrendayta Diospag chrurayangay üra yarparunquiman maygansi runa-mayiqui sinticusha cayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Chauraga chay ofrendayta altar lädunman chrurayur, ayway chay runaman amistänaypag. Nä amistacurcur ichaga, chay ofrendayta altarman chruray. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Chauraga piwansi imatas ninacusha carga, fiyisman manaragsi chrälar ‘Perdonänacushun’ niy. Mana chaynuy ruraptiquiga fiyismanmi chrächishunqui; nätan fiyisga guardiacunamanmi. Nätan guardiacunam carcelman wichrgapäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Razonpam nircayag: Manam yargonquichu chay carcelpitaga ushanan golguequita pägangaycamas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gamcuna mayapäcuraymi unay awilluycuna cay nir yachrachipäcunganta: ‘Amam gowayog cayar u warmiyog cayar mansibacunquichu’ nipäcunganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nätan nogaga cay nipäcugmi: Pisi ‘Wac warmiwan punuyümanga’ nir rircaparga, nämi juchäcurun chay pinsianganwan. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chauraga ñawiqui imatas ricapuptin juchäcuyta munarga, ñawiquita jorgorcur caruman jitarignuy ‘Manam chay juchata rurashagchu’ niy. Antis shumag cuerpulaywan nina wayinman jitayusha canaypitaga, alim canman chulan ñawiquita jorgognuysi juchaman ishquiypita amachacuptiquiga. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nätan chulan maquiqui ima juchaman ishquichiyta munashuptiquis maquiquita cuchurcur caruman jitarignuysi ‘Manam chay juchata rurashagchu’ niy. Antis shumag cuerpulaywan nina wayiman jitayusha canaypitaga, alim canman chulan maquiquita cuchugnuysi juchaman ishquiypita amachacuptiquiga. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nätan gamcunaga mayapäcuraytan unay awilluycuna cay nir yachrachipäcungantas: ‘Pisi juc olgo warminpita raquicayta munagga, warminta papelta rurapuchun nä raquicasha cayangan musyacänanpag’ nipäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nätan nogaga cay nipäcugmi: Pisi raquicanmanga warmin juc olgowan captinran, nätan mana chaynuy captinga manam. Warmin wicapag runaga warmitam mansibacachiyta munayan. Chaura chay warmiwan casaracugsi mansibacuyantan”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gamcuna mayapäcuraytan unay awilluycuna cay ni yachrachipäcungantas: ‘Munayniyog Diospa jutinta janchrarcur juracurayarga chay juracungaynuymi ruranqui’ nipäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nätan nogaga cay nipäcugmi: Amam pasay imapitas juracurcanquichu. Amam janchrarcurcanquichu ni jana pachatas. Jana pachachrüga Diosmi tayayan mandayar. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Amam janchrarcurcanquichu cay pachatas. Cay pachaga Diospa chraquin jaruräcunanmi. Amam janchrarcurcanquichu Jerusalén marcatas. Jerusalenga munayniyog reypa marcanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amatan ‘Umäta jorgamächun’ ninquipishchu. Gamsi Diospam cayanqui. Manam gam munaptiquichu agchayga yuragsi u yanasi antis Dios munaptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chauraga ‘Au’ nirga, ruray ‘Au’ ningaynuy; nätan ‘Manam’ nirga, ama ruraychu. Nätan ‘Au’ ningayman u ‘Manam’ ningayman mastarag yaparga, Asyag munangaynuymi lutanta rurarcayanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gamcuna mayapäcuraymi unay awilluycuna cay nir yachrachipäcungantas: ‘Pisi jucpa ñawinta jorgoruptin, chaysi ñawin jorgosha cachun. Nätan pisi jucpa quirunta jorgoruptin, chaysi quirunta jorgosha cachun’ nipäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nätan nogaga cay nipäcugmi: Lutan runa imatas rurashuptiqui amam cutichipäcunquichu. Antismi jucnin cäraychru pi magashuptiquis, jucag cäraytas camayäpunqui magashunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pisi ashiparcushurniqui ruyin jacuyta guechrushuptiqui, goruy janan jacuytas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pisi juc lïwacama guepinta apanaypag mandashuptiqui, ishcay lïwacama apapuy. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pisi ‘Goyamaynar’ nir imatas manacushuptiqui, goyuy; u ‘Manayämay’ nishuptiquis, manayuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gamcuna mayapäcuraytan unay awilluycuna cay nir yachrachipäcungantas: ‘Runa-mayiquitaga cuyanquim’ ninganta. Nätan ‘Chregnishugniquita chregninquim’ nipäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nätan nogaga cay nipäcugmi: Chregnipapäcushugniquita cuyapäcuy, nätan alipa ricapäcuy. Jinaman Diosta manacurcay chay ima lutantas rurashugniqui runacunapag. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chaynuy rurarga jana pachachru cayag Tayta Diospa castanmi capäcunqui. Payga usyachimunmi ali runacunapagsi lutan runacunapagsi. Paytan tamyachimun ali rurag ruragcunapagsi lutan ruragcunapagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chauraga cuyapäcushungalayta cuyarga ¿imatas chrasquipäcunquichur Diospita? Cuyanacungalanwanga cuyanacurcanmi jucha rurag runacunas. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nätan reguenacungalayta ‘¿Imanuylam cayanqui?’ nirsi ¿alitachur rurayanqui? Diosta mana reguegcunas chaynuylaga rurapäcunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chauraga gamcunas alilata rurapäcuy jana pachachru Taytaycuna Diosnuy, payga ali ruragmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Amam runacuna rircararcayäshuptilayga ali ruraycunata rurapäcunquichu. Chaynuy rurapäcuptiquiga jana pachachru cayag Dios ‘Goshaymi’ nipäcushungayta manam chrasquipäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chaymi gamga ama pitas maytas willapacunquichu mana imaynagcunata yanaparsi, Israel castacuna gotucarcänan wayicunachrüsi ni cällicunachrüsi. Amam alitucug runacunanuyga rurapäcunquichu. Chaycunaga rurapäcun ‘Paycunaga capäcun ali runam’ nir alawasha capäcunalanpagmi. Chaymi noga cay nipäcug: Chaynuy ruragcuna nämi alipag ricachicarärin runacunawan, Diospita alipag ricasha capäcunan truca. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nätan gamga amam alawapäcunquichu mana imaynagcunata imata gorniquis. Amam willanquichu ni cuyanacungalaytas. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Antis ama pisi musyachunchu chay gongayta. Chaura chaynuy pacaylapa rurangayta ricashugniqui Tayta Diosmi, lapan runata musyachinga ali rurag cangayta”. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nätan gamcuna Dioswan rimar amam capäcunquichu chay alitucugcunanuyga. Paycunaga aliscam munapäcun gotucarcänan wayicunachrüsi jinaman cällipa esquinancunachrüsi shayucuyur Dioswan rimayta, runacunawan alipag ricachicurcänan raygo. Chaymi noga cay nipäcug: Chay runacunaga nämi alipag ricachicarärin runacunawan, Diospita alipag ricasha capäcunan truca. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nätan gamga Dioswan rimayta munar wayiquiman yaycuy, jinaman puncuyta wichrgapacarcamur, chaychru Tayta Dioswan rimay. Chaura pacaylachru mayashugniqui Diosmi lapan runacunata musyachinga ali rurag cangayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nätan Dioswan rimarga, amam rimanquichu Diosman mana yupachicugcunanuyga. Paycunaga chay rimangalantam yaparcur yaparcur ushay ushapäcun. Chaynuy manacurcan ‘Achcalata rimaptï Dios mayamangam’ nipäcurmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Chaura ama paycunanuyga capäcuychu. Diosga manaragsi manacurcaptilaymi nä musyayan imata manacurcänaytas. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chaymi gamcuna manacurcanqui caynuypa: ‘Jana pachachru cayag Tayta Diosnïcuna, gamga lapan juchapita caruchrümi cayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Reguechicuynar runacunawan munayniyog cangayta. Shamuynar mandag canaypag. Chaynuylar mandarcayämay imaysi. Gam munangaytachu jana pachachrüsi rurarcayan chaynuy cay pachachrüsi rurapäcushag. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Canan junagpag micunäcunata gopäcamay. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jucha rurapäcungäta perdonayärimay, lutan ruramagnïcunata nogacunas perdonapäcungänuy. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Juchäcachiyta Asyag munapäcamaptin amar cachraripäcamaychu. Antis washayärimay lutan ruraycunapita’ nirmi manacurcanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Chaura lutan rurashugniquicunata perdonapäcuptiquiga jana pachachru cayag Tayta Diossi perdonapäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nätan mana perdonapäcuptiquiga paysi manam perdonapäcushunquichu juchaycunata”. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nätan malagapäcurniqui amam aygas mayapalaga capäcunquichu chay alitucugcunanuyga. Paycunaga laquisha nirag capäcun malagayanganta runacuna musyanalanpagmi. Noga niyärishay: Chaycunaga Diospita alipag ricasha canan trucam nä runacunawan alipag ricachicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nätan gam malagarga umayta shumag nagchacuy nätan cärayta maylacuy. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chay malagayangayta ama runacuna musyachunchu, antis musyachunga Diosla. Nätan pacaylachru ricashugniqui Tayta Diosmi ali rurag cangayta musyachinga lapan runacunata”. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nätan ama gotupäcuychu ima-aygatas cay pachachru cagcunata. Cay pachachru cagtaga puyum ushan, ismunmi, jinaman suwacunam apan. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Antis imanaypanuysi alita rurapäcuyga jana pachachru alichru capäcunaypag. Wacchrüga manam canchu puyusi, manam imas ismunchu, ni manam suwas canchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chauraga pi maysi alisca välignincunata maymanmi chruran. Chaylamanmi yarparayan pagaspas junagpas. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ñawiqui cayan cuerpuypag juc achquinuymi. Chay ñawiqui shumag ricapuptin alicagta rircaraptinga alicagtam ruranqui imatas. Chaura ñawiquiwan alilata rircararga, ali cawag runam canqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nätan ñawiquiwan lutanlata rircararga, lutan rurag runam canqui. Nätan ñawiqui mana shumag ricapugnuysi lutancagta rircäriptinga manam ali ruraycunata atipanquichu imatas. Chaura canan mayacuyarsi mana cäsucurniquiga, mas lutancunatam ruranqui imatas. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Pisi manam ishcay patroncunataga servinmanchu; ümi jucagta chregninga, ümi jucninta cuyanga; ümi jucninta alinninpag ricanga, ümi jucagta manacagpag ricanga. Chaynuy carga Diostas ni alisca ima-ayga charangantas manam atendiyta atipangachu ishcaynintaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Chaymi gamcunata nipäcug: Ama pinsiarapäcuychu ‘Imatarag micushag, imatarag upushag u imatarag jacucushag’ nirga. Antis Dios munangannuy cawaymi masga välin micuypitas jacupitas, nätan cuerpusi masmi välin. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mä pinsiapäcuy pishgocunaman. Paycuna manam murupäcunchu, manam cosechapäcunchu, manam pirwacurcanchu. Paycunata jana pachachru cayag Taytaycunam micachin. Gamcunaga masmi välircayanqui pishgocunapitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Manam pisi jatun cayta munar imanacur ayganacursi mas jatun cayta atipanmanchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Chauraga ¿imanirtag gamcuna jaculaman alisca pinsiararcayanqui? Pinsiapäcuy wac waytacuna wiñarcayagman. Manam paycuna uryapäcunchu, ni puchcacurcanpishchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nätan mayapäcamay shumag: Wac waytacunanuyga manam Rey Salomonsi jacucurachu mas alinnin jacunta jacucuyarsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wac waytacuna pampachru cayag, warala hornuchru rupanan cayaptinsi, Diosmi chaynuy shumagta wiñachin. Chaura gamcunataga masran jacuchipäcushunquis, Diosman mana alila yupachicug runacuna. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chaura ama nipäcuychu ‘¿Imatarag micushun? ¿Imatarag upushun? ¿Imatarag jacucushun?’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diosman mana yupachigcunalam chaynuyga yarparapäcun. Nätan gamcunapaga jana pachachru Dios Taytaycuna musyayanmi lapan chaycuna mana capurcäshungayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Antis naupataga Dios munangannuy alicagta rurapäcuy. Chauraga Diospita chrasquinqui lapan chaycunataga mas masnintawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chaura ama pinsiararcayaychu ‘¿Imanäshagrag waraga?’ nirga. Antis warapagga waram pinsianqui. Chaura lapan junagsi cangam chaycunaman pinsianaypagga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ama runa-mayiquicunata juchachapäcuychu mana juchachasha capäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Juchachapäcuptiquiga, chaynuymi gamcunatas Dios rurapäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Imanirtag rircarayanqui runa-mayiquipa ñawinchru juc ichic puchrula cayagta, nätan ñawiquichru gueru cayagtaga mana tantiacunquichu? ");
INSERT INTO qvnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chaynuy cayarga ¡manam ‘Paypa ñawinchru ichic puchrula cayagta jorgorushag’ ninquimanchu, quiquiquipa ñawiquichru gueru chacarayaptinga! ");
INSERT INTO qvnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Alitucug! Naupataga ñawiquipita gueruta jorgognuysi juchaytarag tantiacuy, jinaman juchäcuytarag wanacuy. Chaura chay ichic puchrulata ñawinpita jorgognuysi, chay juchäcuypita yargoyta yanapanqui alim. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Diospa raquishancuna juchaman ishquipacaräriptin amam musyachipäcunquichu algonuysi cayag runacunata, chaycunaga ticrarämur imatas rurarärishunquimanmi. Amatan musyachipäcunquichu cuchinuy cayag runacunatas. Chaycunaga alisca väligta cuchicuna jaruy ushagnuymi lutanpag ricachipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nätan manacurcay gopäcushunaypag. Ashipäcuy taripäcunaypag. Töcacurcay quichrapäcushunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Manacugcagga pi maysi chrasquinmi. Ashigcagga tarinmi. Töcacugcagtaga quichranmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Maygaytag tantata wamraycuna manacushuptiqui rumita gorärinquiman? ");
INSERT INTO qvnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","U ¿pescäduta manacushuptiqui culebrata gorärinquiman? ");
INSERT INTO qvnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chauraga lutan rurag carcayarsi wamraycunata alicunata gorcayaptiquiga, jana pachachru cayag Taytaycunaga mas alicunataran gopäcushunquis manacurcaptiquiga. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nätan gamcuna ima-aygachrüsi runa-mayiquicunapita alipag ricasha cayta munapäcungaynuy, gamcunasi runa-mayiquicunata alipag ricapäcuy. Chaynuy canäpagmi nirayan Moisespa jinaman Diospa unay willacugnincuna isquirbingancunachrüsi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Chauraga quichrqui puncupa yaycugnuysi niyangäta cäsucarcämay. Juc jatun puncupa yaycugnuymi jinaman juc jatun camiñupa aywagnuymi carcayan lutan cawagcuna. Chaycuna aywarcayan nina wayimanmi, nätan chay lutan cawagcuna achca achcam carcayan. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chaura quichrqui puncupa yaycugnuymi jinaman llanu camiñupa aywagnuymi ali cawagcuna aywarcayan imaycamas cawayman. Nätan chay ali cawagcunaga walcalam carcayan. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Cuidacurcay ‘Diospa willacugninmi cä’ nir casqui yachrachigcunapita. Chaycunaga gamcunaman aywapäcamun uyshanuymi mana manchana, nätan chaycunaga capäcun micucug leonnuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Chaycunata reguepäcunqui lutan rurangancunata ricarmi. Manam cashacunapitachu üvas mishquita palanchi. Manatan cashayog montipitachu palanchi hïgos mishquitas. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chaura ali montiga ali mishquitam wayun, nätan mana alicagga wayun mana ali mishquitam. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ali montiga manam wayunchu lutan mishquita, ni lutan montisi manatan wayunchu ali mishquitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lapantasi mana ali mishqui wayug montitaga muturcurmi rupachinchi. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chauraga ruranganpam gamcunaga musyapäcunqui casqui yachrachig u razoncag yachrachig cangantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Pi maysi ‘Munayniyognï, Munayniyognï’ nimagcuna manam lapanchu Diospa munayninman yaycapäcunga. Yaycungaga pisi jana pachachru Dios-mayï munangannuy ruraglam. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nätan juchacunata taripänä junag achcam nipäcamanga: ‘Munayniyognï, Munayniyognï, nogacunaga nipäcamangaynuymi willapacurcarä. Nogacunaga gam nipäcamangaynuymi runacunapita lutan espiritucunatas gargapäcurä. Jinaman achcatam rurasha capäcü mana runala ruray atipänancunata’ nipäcamanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chaynuy nipäcamaptin: ‘Gamcunataga manam reguegchu. Naupäpita aywacurcay lutanlata ruragcuna’ nishagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Chauraga cay yachrayächingäta mayacamag jinaman cäsucamag runacunaga cayan pisi juc yarpaysapa runa gaga jananchru wayinta sharcachishanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chaura chay wayitaga alisca tamyawan, mayucuna chrarpamur alisca lagyayarsi, jinaman chay wayiman alisca walyayarsi manam juchruchishachu, gagachru rurasha captin. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nätan yachrayächingäta mayayarsi mana cäsucugcunaga cayan juc gotara runa agoysha jananchru wayinta sharcachishanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chaura chay wayitaga alisca tamyawan mayucuna chrarpamur, alisca lagyarga, jinaman chay wayiman alisca walyarga pasaymi juchrurachin. Chaynuymi mana cäsucugcunawan Dios ruracanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chaynuypa Jesús yachrachiyta nä usharuptinga, runacunaga alisca mayacasham ricacarärin ");
INSERT INTO qvnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dios ningannuyla yachrachinganpita. Payga manam yachrachira Moisés isquirbinganpita yachrachigcunanuylachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nä chay gotupita Jesús chrarparamuptinga achca achcam runacuna gatirapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jinarcurmi gueri nirayag leprawan gueshyag runaga Jesuspa naupanman gongorpacuyur “Munayniyog tayta, munargar cuticayächilämay” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Niptin Jesusga chacchayurmi yatayurun “Munayämi cuticänayta” nir. Chaura nir yatayurpuptilanmi chayüra gueshyanpita runaga cuticarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chaura Jesusga “Amam pitas willapacunquichu cuticächingagta, antis ayway Diospa wayinchru cayag sacerdötiman, jinaman Moisés mandangannuy Diospag gonaycagta aparicuy chay gueshyapita nä cuticasha cangayta musyapäcunanpag” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Chaura Capernaum marcaman Jesús nä chraruptinmi, pachrac soldäducuna mandag Roma runaga Jesusman ashuyur ");
INSERT INTO qvnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","cay nirun: “Munayniyog tayta, wayïchrümi juc rantisha runä jitarayälan uncutucusha nanaywan alisca cunchuyar”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Niptinmi Jesusga cay nin: “Cuticächinäpag noga aywashag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chay niruptin runaga cay nirunmi: “Munayniyog tayta, nogaga manam maygan alinnin runas cächu wayïman yaycunaypagga. Antis caylachru niruy cuticänanpag, chaura rantisha runäga cuticarungam. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nogasi mandagnïpa munayninchrümi cayä. Nätan nogapa munaynïchrüsi soldäducuna cayanmi. Juc soldädüta ‘Wacta ayway’ niptï aywanmi. Nätan jucta ‘Shamuy’ niptïsi shamunmi. Chaynuymi rantisha runäsi ‘Cayta ruray’ niptïsi ruran”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chay nigta mayarur Jesusga mayacasham ricacarun. Jinarcurmi gatirarcayag runacunata cay nirun: “Mayapäcamay shumag: Caynuy yupachicamag runataga manam Israel castacunachru ricarächu. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Caytas niyärishay: Achcam paynuysi mana Israel castacuna aywapäcamunga inti yargamunan lädupitas jinaman inti yaycunan lädupitas Diospa munayninchru Abrahamwan Isaacwan Jacobwan parëju tacuyur micapäcurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nätan Israel castacunaga washa yanauyagmannuymi gargosha capäcunga. Chaychrümi alisca wagapäcunga, jinaman quiruncunatasi gapapayla cachrucurcanga ‘¡Imanarärag!’ nir”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nircurmi Jesusga soldäducuna mandag runata “Yupachicamangaynuy ruracächun, wayiquita aywacuy” nirun. Chauraga chayüram chay gueshyagnin cuticasha. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chaypita Jesusga Pedropa wayintam aywacun. Chaychrümi tarirun Pedropa suydranta alisca acachaywan gueshyayar cämachru jitarayagta. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jinarcurmi chay warmipa maquinta Jesús yatayuptilan chay gueshyapitaga cuticarun. Chaura warmiga pasay-pacha sharcurcurmi micuy garachracuyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jinarcurmi nä pacha chacanayaptinga, Jesusman chrarärichimun Asyagpa munayninchru cayag achca runacunata. Chaura Jesusga juc piñapaylawanmi chay lutan espiritucunata gargorun runacunapita, jinaman lapan gueshyagcunatas cuticarachira. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chaycunata rurara unay willacugnin Isaiaswan Dios rimachingan ruracänanpagmi. Payga cay niram: “Mana ali cayasham payga yapapamasha canchi. Jinaman tucuy gueshyanchipitam cuticächimasha canchi” niram. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Chaura chay achca runacuna muyurapäcuptinmi Jesusga discïpuluncunata cay nin: “Acu pasashun wac chimpanman”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chay niyaptilanmi Moisés isquirbinganpita yachrachig juc runaga ashuyur Jesusta cay nin: “Yachrachig, maytas chaytas gamwanmi aywayta munayä”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Niptinmi Jesusga cay nirun: “Shumag pinsiay. Atogcunapasi machraynin canmi jinaman pishgocunapasi gueshan canmi. Nätan noga jana pachapita shamusha runapagga manam canchu wayiläsi jamayunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Niruptinmi waquin discïpuluncunapita jucga Jesusta cay nin: “Munayniyog tayta, gamwan purinanchipag naupataga taytärag wanuruchun. Payta enterraruptïmi ichaga purishun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chay niruptin Jesusga cay ninmi: “Gamwanga purishun. Juchalachru wanushanuysi cayagcuna pay wanuptinga enterrapäcuchun” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chay nircurga büquimanmi Jesusga yaycurun, jina guepantam discïpuluncunas yaycarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jinarcurmi chay jatun gochrapa aywarcayaptin mayänipita alisca löcu tamya galacuyun. Chauraga alisca walyaptin yacuga altumancama sharcur nämi büquitas chapanayara. Nätan Jesusga punuyaram. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chaura discïpuluncunaga ashuyurmi riccharärichin cay nir: “Munayniyog tayta, salvayärimay. Nämi talpuyanchi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chaura Jesusga cay nirunmi: “Mana alila yupachicamag runacuna, ¿imanirtag alisca manchacararcayanqui?” nirga, sharcurcurmi piñaparun walyaytawan yacutaga. Chaura chayüram walyaysi yacusi amaynarun shumag. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chaura discïpuluncuna chayta ricarurga pasay mayacasha niragmi cay ninacarärin: “¿Imannincagtag cay runaga cayan walyawan yacusi cäsucunanpagga?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chaura Gadara ningan gochra manyan chimpaman chrarärin. Jinarcurmi yargarärimun panteonpita Jesús taripäcug Asyagpa munayninchru cayag ishcay runacuna. Chay runacunaga alisca manchaymi capäcura. Chaymi mana pisi chay camiñupa puripäcugchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chaypitam chay ishcay runacunaga gayachracuypanuy cay nirärin: “Diospa-mayin Jesús, ¿imatatag nogacunawan munayanqui? Manaragsi üra aypamuptilanchu aywaramunqui cayman cunchuchipäcamänaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chay carcayanganpita mana alä caruchrümi achca cuchicunata michircayara. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jinarcurmi chay lutan espiritucunaga Jesusta cay nirärin: “Nä cay runacunapita gargarcayämaptiquiga, yaycapäcushagnar wac cuchicunaman”. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nipäcuptinmi Jesusga “Äri, yaycapäcuy” nin. Chaura chay runacunapita yargarärir, chay lutan espiritucunaga cuchicunamanmi yaycarärin. Jinarcurmi cuchicunaga lapan, waraupa jegarparärin gochraman. Chaychrümi lapan wanurärin shengaypa. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chaura cuchi michigcunaga gueshpicurcanmi. Jinarcurmi marcaman nä chrarärirga willapäcarärira cuchicunapitas jinaman chay ishcay runacunapitas. ");
INSERT INTO qvnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chauraga lapan runacunam aywayta galacayärimun Jesús cayanganman. Jinarcurmi paycagman chrarärirga “Aywacuynar cay Gadarapita” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaura Jesusga chay büquiman yaycurcurmi aywacamun waclä chimpa yachrangan marcata. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaymanmi chrarärichin quirmaypa juc uncutucusha runata. Nätan payman yupachicurcanganta Jesús tantiarurmi gueshyagtaga nirun: “Valorchacuy wamralä. Nämi juchaycunapita perdonarug”. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niptinga Moisés isquirbinganpita yachrachigcunam juc ishcay pinsiapäcura cay nir: “Cay runaga Dios tucuyanmi ‘Perdonarugmi’ nirga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Chaynuy pinsiarcayanganta musyarmi Jesusga nin: “¿Imanirtag nogapita pinsiarcayanqui lutanta? ");
INSERT INTO qvnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chaura gamcunaga ¿maygantatag rurarärinquiman? ¿‘¡Rimarilar juchacunata perdonarärinquimanchu!’ u gueshyagta ‘¡Sharcurcur! ¡Puriy!’ nilar cuticarärichinquimanchu? ");
INSERT INTO qvnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Chauraga noga jana pachapita shamusha runa cay pachachru runacunapa juchanta perdonänäpag munayniyog cayangäta musyapäcunaypag cay gueshyagta cuticächishag”. Nircurmi gueshyagta cay nin: “¡Sharcuy! ¡Quirmayta guepicurcur wayiquita aywacuy!” ");
INSERT INTO qvnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Niruptinga chayüram sharcurcur wayinta aywacun runaga shumag cuticasha. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chayta runacuna ricarärirga manchacurcaram Jesusta, jinamanmi Diosta alawapäcura “Gammi runacunata alisca munayniyog capäcunanpag nisha canqui” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaypitam chay carcayanganpita Jesusga aywayara. Jinarcurmi noga Mateota ricaparaman patenti cobracunächru tayayagta. Jinarcurmi cay niraman: “¡Shamuy, nogawan uryashun!” Nimaptin nogaga sharcurcurmi Jesuswan aywacurä. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chauraga Jesuswan jinaman discïpuluncunawan wayïchru micapäcurcayaptïmi achca runacuna chrarärimun. Paycunaga capäcura patentita cobragcunawan juchasapacunam. Jinarcurmi paycunawansi lapä micapäcurcarä. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta ricarärirmi, fariseo ningancunaga Jesuspa discïpuluncunata cay niräriman: “¿Imanirtag yachrachigniquicuna micun patentita cobragcunawan jinaman juchasapacunawan?” ");
INSERT INTO qvnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nipäcugta Jesús mayarurga cay nirunmi: “Alicunaga manam munapäcunchu jampicugta, antis jampicugtaga munapäcun gueshyagcunam. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Chauraga cutipäcuy jinaman tantiapäcamuy. ¿Imaninantatag Diosga cay niyan isquirbishanchru? ‘Uywacunata Diospag ruparcayächingay manam alichu, runa-mayiquita mana cuyapaptiquiga’ niyan. Nätan nogaga manam shamusha cä mana juchaynagcunata ashigchu, antis juchasapacunata ashigmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chauraga Bautizag Juanpa discïpuluncunam chrarärimun Jesusman cay nir: “Nogacunaga jinaman fariseo ningancunaga aliscam malagapäcü. Nätan ¿imanirtag gampa discïpuluycunaga mana malagapäcunchu?” ");
INSERT INTO qvnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nipäcuptinmi Jesusga nirun: “Musyapäcungaynuysi pisi casamintuman gayachishacunaga manam malagashaga capäcunchu noviu paycunawanrag cayaptinga. Chaynuymi nogapa discïpulücunas manam laquishaga capäcunmanchu caychru cayangäcamaga. Juc junagchru noga noviuta aywachicamaptinmi ichaga malagapäcungaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Manam pisi macwa jacuta remendanchu mushog sagpiwanga. Nätan mushog sagpiwan remendashaga guentirur macwa jacuta masmi lachichin. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Manatan chayrag rurasha aswatas wiñanchichu macwa wagalamanga. Chaynuy macwaman wiñarushaga pogorimur chay wagalata lachichinmi. Chauraga ishcayninmi manacagmanmi ruracarun. Chaymi mushog wagalacunaman chayrag rurasha aswata wiñanchi. Chauraga aswas wagalas alitacamam cachinacun” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chay nir Jesús rimayaptinmi chraramun Israelcuna gotucarcänan wayichru juc mandag runa. Jinarcurmi Jesuspa naupanman gongorpacuyur cay nin: “Warmi wamrämi chaylarag wanurun. Gam aywarcur yatayuptiquiga cawacämungam”. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chay niptin Jesusga chayüram sharcurcur aywara nogacuna discïpuluncunawan chay runapa guepanta. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Chay aywarcayaptïmi juc gueshyag warmi Jesusman ashuyurunag guepanpa. Jinarcurmi jacunpa tumanta tupayurunag. Payga nä chrunca ishcayniyog watash yawar apaywan gueshyara. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chay warmiga chaynuy ruranag “Jaculanta tupayursi cuticäshagmi” nir yupachicurshi. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chaura tuparuptin Jesusga muyurcurmi warmita ricapurun. Jinarcurmi cay nin: “Valorchacuy wamralä. Razonpa yupachimangaypam cuticarunqui”. Niptinga chayüralash yawarnin tacyarura. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaura chay mandag runapa wayinman chrarur Jesusga tarirun quëna töcarcayagtam, jinaman waquintam “Äyar, äyar” gapachracuypa wagarcayagta. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chaura chaycunatam Jesusga cay nirun: “Caypita yargapäcuy. Wamraga punuyanmi manam wanushachu”. Niptin chay runacunaga asiparärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chaura runacuna washaman nä yargaräriptinga, wamra cayangancagman yaycurcurmi Jesusga wamrapa maquinta charirun. Jinarcurmi wamraga sharcaramun. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chay runa yachrangancagpa entëruchrümi Jesús chaynuy ruranganpita mayachinacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chay mandagpa wayinpita nä Jesuswan aywarcayaptïmi, ishcay ñaushacuna gatirarcayäman gayachracuypanuy Jesusta cay nircayar: “¡Davidpa castan Jesús, cuyapayärimaynar!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nä wayiman chraräriptïga guepäcunatam chay ñaushacunas chrarärimun. Jinarcurmi Jesusga tapurun: “¿Gamcuna razonpachu yupachicarcayämanqui cuticächipäcunagpag?” Niptinmi “Au Munayniyog tayta, yupachicurcayagmi” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chaura Jesusga ñawincunatam tupayurun cay nir: “Gamcuna yupachicarcayämangaynuy ruracächun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Niruptilanmi ñawincunaga ricapurun. Chaura Jesusga cay nirunmi: “Amam pasay pitas willaparcanquichu cuticächipäcungagpita”. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Paycunaga nätan nä yargarärirga willapacarärinag lapan chaychru marcacunapam Jesús cuticächinganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chaura chay ishcay runacuna nä yargorcayaptinmi, runacunaga chrarärichimun juc runata mana rimay atipagta. Paytaga Asyagpa lutan espiritunmi mana pasay rimachinagchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jinarcurmi chay lutan espirituta gargoruptinga chay runa rimayta galacuyun. Chaura runacunaga mayacasham rircaräcurcan cay nircayar: “¡Pay rurangantanuyga manam imaysi ricaranchichu cay Israel nacionninchichru!” ");
INSERT INTO qvnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nipäcuptinmi chay fariseocunaga cay nirärin: “Cay runaga lutan espiritucunata gargoyan quiquin Asyagpa munayninwanmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nätan Jesusga entëru marcacunapam purira acapapas acraypas Israel castäcuna gotucarcänan wayicunachru yachrayächir, Diospa munayninchru cawaypita ali willapata willapacuyar, jinaman runacunata lapan nanaycunapitawan tucuy gueshyacunapita cuticayächir. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chaura chaychru achca runacunata ricapurmi Jesusga alisca cuyaparun, wicapasha uyshanuysi mana michigniynag wichicasha cawarcayagta ricapurur. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaura Jesusga nogacuna discïpuluncunatam cay nipäcaman: “Razonpa maychicachr cayan runacuna cosëchanapag micuy pogoshanuysi ali willapata mayacuy munagcuna, nätan chay willapacugcunam walcala carcayanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chauragar Munayniyog Diosta manacurcay ali willapa willapacugcunata cachrananpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaypitam Jesusga chrunca ishcayniyog discïpuluncunata gayarcärimar, “Cananga runacunapita lutan espiritucunatam gargapäcunqui, jinamanmi runacunata cuticächipäcunqui lapan nanaycunapitawan tucuy gueshyacunapita” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chay chrunca ishcayniyog cachran ruragcunapa jutïcuna cara caynuymi: Simón (Chay Simonpam juc jutin cara Pedro). Chaypitam cara Andrés. Payga cara Simonpa wauguenmi. Chaypitam cara Zebedeopa churincuna Jacobowan Juan. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Chaypitam cara Felipe, Bartolomé, Tomás, noga patenti cobrag Mateo, Alfeopa churin Jacobo, jinaman Tadeo. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Chaypitam cara ‘Cananista’ nipäcungan Simón, jinaman Jesusta wanuchipäcunanpag reguechig Judas Iscariote. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Chaura Jesusga chay chrunca ishcayniyog cachran ruragcunata cachrapäcamara cay nircärimarmi: “Amam aywapäcunquichu juc casta runacunamansi ni Samariachru marcacunamansi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Antis naupataga aywapäcuy Israel casta runacunamanrag. Paycunaga carcayan uysha ogracashanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nätan aywarcayarmi cay nipäcunqui: ‘Nämi chraramun Diospa munayninchru cawapäcunay wichan’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chaypita gueshyagcunata cuticächipäcamuy, wanushacunata cawacächipäcamuy, gueri nirayag lepra ninganwan gueshyagcunata cuticächipäcamuy, lutan espiritucunata runacunapita gargapäcamuy. Chaynuy rurapäcunaypag nipäcungagpita manam imatas gopäcamaraychu. Chaynuy gamcunas chay rurapäcungaypita ama imatas manapäcuychu. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Chay aywapäcur amam apapäcunquichu cheglaycunachru örutas yurag golguetas ni cobritas. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Amatan apapäcunquichu mircapatas müdanaytas ni guerutas, nätan languewansi aywapäcuy chay jatirarcayangalaywan. Juc uryag runataga micunanta gopäcunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nätan acapa u acray marcaman chrarursi tapucurcay pi ali runa cangantas payman gorpachacurcänaypag. Chaychru capäcunqui juc marcaman aywapäcungaycamam. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nä chay wayiman yaycurga cay nipäcunquim: ‘Diosninchi yanapapäcushunqui ima-aygachrüsi’. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chay nipäcungayta chay wayichru runacuna alipa chrasquicurga Diospita yanapasham capäcunga. Nätan mana alipa chrasquipäcurga manam nipäcungay paycunachru ruracangachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nätan chrapäcungay wayichru u marcachru mana chrasquipäcushuptiquiga. Jinaman yachrachipäcungaytas mana mayapäcushuptiquiga aywacurcanquim. ‘Cananga nämi willarärig imanuysi cawacurcay, manam mastaga cayman jarupäcamushagchu’ nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mayapäcamay shumag: Chaynuy mana chrasquicurcanganpita Dios juchacunata taripänan junagga Sodoma jinaman Gomorra marcachru yachragcuna cunchupäcunganpitaga mas juyupa cunchuchisham capäcunga chaycunaga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nätan gamcunata cachrayä atogcunapa chraupinman uyshacunata jitayognuymi. Chauragar capäcuy fisyusapa culebranuysi, nätan palömanuysi mana lutan ruragcama. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chaura chay atognuysi runacunapita cuidacurcanquim. Chaycunaga marcachru mandagcunamanmi aywachipäcushunqui, jinaman Israel castacuna gotucarcänan wayincunachrümi astipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nogapa janäga aywachipäcushunquim marcaychru mandagniquicunapa, jinaman nacionchru mandagniquicunapa naupanman juchachapäcushunaypag. Chaychrümi paycunata jinaman juc casta runacunata nogapita willapacurcanqui. Nätan marcachru mandagcunaman ");
INSERT INTO qvnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","chrächipäcushuptiqui amam laquicurcanquichu ‘¿Imatarag nishag? ¿Imanuyparag rimashag?’ nirga. Rimanay üra Diosmi nishunqui imata rimanaypagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chauraga Tayta Diosniquicunam Santu Espirituwan imata nipäcunaypagsi yanapapäcushunqui. Nätan manam quiquiquicunapa yarpaylaycunapitachu rimapäcunqui imatas. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Chaypitaga chay wauguecamam wanuyman jitayanacurcanga. Taytacagcunas churinta wanuyman jitayapäcungam. Chaynuytan churicunasi taytanta mamanta chregnirnin wanuchipäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nogapa janä lapan runacunapitam chregnipasha capäcunqui. Nätan pisi wanungancamas mana nogapita raquicagtaga Diosmi washanga ima-aygapitas. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcachru wanuchiyta munapäcushuptiqui juc marcaman gueshpipäcuy. Mayapäcamay shumag: Noga jana pachapita shamusha runa cutimushag, lapan Israel runacuna yachranganpa nä gamcuna puriyta usharäriptilaymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Pi discïpulusi manam canchu yachrachigninpita mas alipag ricashaga ni pi rantisha runasi manatan canchu alipag ricashaga rantigninpita masga. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chauraga juc tayta yupaysi cayagta nogatasi Asyag nircayämarga masran gamcunataga nipäcushunquis, runäcuna carcayaptiquiga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Chauraga amam manchacurcanquichu runacuna imatas rurapäcushunaypita. Manam pi pacaylapa ima rurangansi canchu mana musyacashaga. Manatan ima pacashasi canchu mana musyacashaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chaura mana pisi ricanganchru nipäcungagta pita maytas willapacurcanquim, nätan wishwishyayla willapapäcungagta willapacurcay wayi jananpita gayachracugnuy. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chaura ama manchapäcuychu wanuchicug runacunalataga. Antis manchacurcayga imaycamas nina wayichru almaycuna cunchuchigcagta. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ishcay pishgocunata ranticurcan uchuc golguelapagmi. Nätan juclay pishgolas wanuyanga Tayta Diosniquicuna munaptinran. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nätan gamcunapaga agchacunas aygacagsi cayan yupashalam. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chauraga ima-ayga captinsi ama manchacurcaychu. Achca pishgocunapitas masmi gamcunaga välircayanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nätan pi maysi runacunapa naupanchru nogapa runä cayar ‘Nogaga Jesuspam cä’ nigcunataga nogasi jana pachachru cayag Dios-mayïpa naupanchrümi ‘Payga cayan nogapa runämi’ nishag. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nätan pisi runacunapa naupanchru ‘Nogaga manam Jesuspachu cä’ nigcunataga Dios-mayïpa naupanchrümi ‘Manam nogapa runächu’ nishag paytas. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nätan ama nogapag pinsiapäcuychu ‘Payga aywarayämun gasilata cawachimänanchipagmi’ nirga. Manam chaypagchu shamusha cä. Antis aywarayämü nogaga chregnipasha capäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chaymi olgo churis taytanta chregnipanga, warmi wawas mamanta chregnipanga, lumchuysi suydranta chregnipanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chauraga contrapartiquicuna canga wayiquichru cagcunapitam. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pisi nogata cuyamänan truca taytanta mamanta mas cuyagga manam nogapa runäpag alichu. Manatan pisi nogata cuyamänan truca churincunata olgotas u warmitas mas cuyagsi nogapa runäpag välinchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jinaman nogapa janä wanuytas ima-ayga cunchuytas mana munagga u noga ningänuy mana cawagga, manam nogapa runäpag välinchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chaura pi maysi cunchuyta u wanuyta manchar ‘Manam Jesuspachu cä’ nimagga manam cawangachu nogawan. Nätan pi maysi wanunan u cunchunan captinsi mana mancharilar ‘Nogaga Jesuspam cä’ nigga cawanga nogawanmi imaycamas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nätan pi maysi gamcunata chrasquicurcäshugniquiga nogatam chrasquicayäman. Jinaman nogata chrasquicamagsi cachramagnï Diostam chrasquicuyan. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pisi Diospa willacugninta chrasquigga chay willacugninta chrasquinganpita Dios ricanga alinninpagmi chay willacugnintanuysi. Nätan pisi ali rurag runata chrasquigga chay ali ruragta chrasquinganpita Dios ricanga alinninpagmi chay ali rurag runatanuysi. ");
INSERT INTO qvnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chaura manacagpag ricasha cay discïpulücunata juc väsu gasag yaculatas pisi chacchayächigtaga chay discïpulüta chacchayächinganpita Diosga ricanga alinninpagmi razonpa”. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chaura Jesusga nä chrunca ishcayniyog discïpuluncunata “Chaynuypam rurapäcunqui” nircärimarga aywacura yachrachigmi. Chaura payga ali willapata willapacura marcan marcanmi chay Israel castacuna yachrapäcungäpa. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chauraga Jesús ima-aygatas rurayangantam Bautizag Juanga mayarunag carcelchru cayar. Chaymi ishcay discïpuluncunata cachraramunag ");
INSERT INTO qvnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesusta cay nir tapupäcunanpag: “¿Gamchu cayanqui chay shuyacurcayangä, ‘Juc salvacugtam cachramushag’ Dios ningan, u juctaragchu shuyapäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nipäcuptinmi Jesusga cay nirun: “Pasay cutir Juanta willapäcamuy nogapita mayacurcayangayta, jinaman cay rurayangä ricarcayangayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Payta willapäcamuy ñaushacunata ricapayächingäta, ratacunata cuticayächingäta, gueri nirayag leprawan gueshyagcunata cuticayächingäta, upacunata cuticayächingäta, wanushacunata cawacayächingäta, jinaman mana imaynagsi runacunata ali willapata willapacuyangäta. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chauraga pi maysi ‘Paychur u jucchur’ mana nimagga cushisham canga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nircuptinmi chay ishcay discïpuluncunaga cuticurcan. Chaylam Jesusga chaychru carcayag runacunata tapurun Juanpita cay nir: “¿Imanuy runa ricagtag aywapäcuray chunyag pampaman? ¿Walyaywan chagla cuyuchishatanuysi manacag runa ricagchu? ");
INSERT INTO qvnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Chauraga ¿ima ricagtag aywapäcuray? ¿Alisca alinnin jacusha runa ricagchu? Chay alinnin jacushacunaga carcayan reycunapa wayincunachrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chaura ¿ima ricagtag aywapäcuray? ¿Diospa willacugnin runa ricagchu? Au, gamcunaga razonpa Diospa willacugnin runa ricagmi aywapäcuray. Payga cayan Diospa waquin willacugnincunapitaga mas alinnincagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Paymi cara ‘Nämi aywayämun’ nir willapacug. Paypitam isquirbishachrüsi Diosga cay niyan: ‘Gampa naupaytam willacugnïta cachrayä, paymi runacunata camariyanga. Gam chraptiqui chrasquipäcushunaypag’ nirsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Shumag mayapäcamay: Bautizag Juannuyga manam canancama pi runas carachu. Nätan cananga Diospa munayninchru cawacagcuna manacagpag ricasha carcayarsi carcayan Bautizag Juanpitaga mas cushisham. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan willapacunganpita-pacha canancama Diospa munayninchru cawapäcunanpag nä alisca aliscam yaycurcayan. Nätan yaycurcayanga razonpa alisca munagcunalaran Bautizag Juan aywamunganpita canancama. Chay lutan runacuna manam pasay munapäcunchu Dios mandangan cäsucuyta, nätan chaycunaga illacarachiylatam munarcayan imanaypanuysi. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nätan Juan shamungancamam Diospa lapan willacugnincuna isquirbipäcungansi jinaman Moisés isquirbingansi willapacashalarag cara Diospa munayninchru runacuna cawapäcunanpita. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nätan gamcuna chrasquicuyta munapäcuptiquiga, Juanmi cayan isquirbinganchru ‘Aywamunga Eliasmi’ ninganga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nircurmi chay mayarcurcayagcunata “Nipäcungagta shumag tantiapäcuy jinaman cäsucurcay” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nätan gamcunaga shongoycuna munangannuy rurachiylatam munarcayanqui pitas” nircurmi, “Gamcuna carcayanqui juc pläzachrüchu tayarcayag walashcuna waquin walash-mayincunata cay nir gayararcayagnuymi: ");
INSERT INTO qvnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Quënata tushupäcunaypag töcaparcayaptïsi manam tushupäcunquichu. Jinaman wagapäcunaypag cantaparcayaptïsi manam wagapäcunquichu’ chay nipäcugnuymi carcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chaymi Juan vïnuta mana upyaptin jinaman malagaptin, ‘Wac runaga cayan lutan espiritupa munayninchrümi’ nircayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nätan noga jana pachapita shamusha runa micuptïga upyaptïga, ‘Cay runaga munan micuylatam, upyaylatam, jinaman cuyanacuyninsi patentita cobragcunawan lutan ruragcunam’ nircayämanqui. Nätan chaynuy nircayaptiquis nogacunaga rurapäcungäpam reguechicurcayä Diospita capäcungäta” nira. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chaura Jesusga chay ima-aygas mana runala ruray atipänancuna rurangan marcacunachru runacunatam piñapaypanuy rimapayta galacuyun, jucha rurarcayanganpita mana wanacurcaptin cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Laquipaypagmi carcayanqui, Corazín marcachru yachragcuna! ¡Laquipaypagmi carcayanqui, Betsaida marcachru yachragcuna! Gamcunachru chay ima-aygatas rurangäta Tïro marcachru, Sidón marcachru ruräman cara, paycunaga nämi maysi chay jucha ruraypita wanacurcur Diosman cutirärinman cara, laquisha car jacuräcurcänanta jacucurcur, jinaman uchrpawan lushicarcärir. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chaymi gamcunata willayä: Dios juchacunata taripänan junag gamcunaga mas juyupa cunchuchisham capäcunqui Tïrochru jinaman Sidonchru yachrag lutan runacunapitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nätan Capernaum marcachru yachragcuna, ¿‘Jana pachaman chräshunmi’ nircayanquichu? Antis gamcunaga capäcunqui nina wayiman jitayusham. Nätan Sodoma marcachru chay ima-aygatas rurangäcunata ruräman cara, canancamas cayanmanragchri cara chay marca. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chaymi gamcunata willayä: Dios juchacunata taripänan junag gamcunaga mas juyupa cunchuchisham capäcunqui Sodoma marcachru runacuna cunchunganpitaga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nircurmi Jesusga galacuyun cay niyta: “Tayta Dios, gam canqui alisca alim. Gampam jana pachas cay pachas. Nogaga aliscam cushirayä chay yachrag jinaman tantiag runacunapita pacarachingaypita, nätan wamranuysi carcayag runacunata musyachingaypita. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Au Tayta Dios, gamga munangaynuymi rurarunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nircurmi runacunata cay nirun: “Tayta Diosga lapan ima-aygachrüsi munayniyog cananpagmi nä nimasha. Manam pisi shumagga musyanchu Diospa-mayin cangäta. Musyayanga quiquin Dios-mayilämi. Manatan pisi musyanchu Dios-mayï pi cangantas. Musyayäga nogalam, jinaman musyapapäcungas musyachingäcaglam. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chauraga runacunapa yachrachiylanwan alisca uryashanuysi, jinaman lasag guepishanuysi cawarcayagcuna niyangäta lapay chrasquicurcay. Nogaga runapa yachrachiylanwan cawaypita jamachipäcushaymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Antis noga yachrayächingänuy cawayta galayapäcuy. Jinaman noganuy capäcuy manshu runa imatas awantagcama. Chaura chay niyangänuy cawapäcurga, cushisham capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noga yachrayächingänuy cawayga manam sasachu. Nätan rurapäcunaypag niyangäsi cayan aygas ruracuylam” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chay wichancunam juc jamana junagchru trïgu pogorayag chracrapa Jesuswan aywarcayarä. Jinarcurmi nogacunaga micanasha carga trïguta tipircur micaricurcarä. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chayta fariseo ningancuna ricaparärimarmi Jesusta cay nirärin: “Ricay, uryarcayan discïpuluycuna, jamana junagchru mana imatas rurananchipag Dios nirayämasha”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nipäcuptinmi Jesusga nirun: “¿Manachu Dios isquirbichingan libruchru leyipäcuray, unay Rey David jinaman paywan purigcuna micanasha puripäcur rurapäcunganta? ");
INSERT INTO qvnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Chaypin payga Diospa wayin ruyiman yaycurmi ‘Cay tantaga cayan Dioslapagmi’ nir chrurapäcunganta micusha. Nätan chay isquirbishachru ningannuyga chay tantacunataga micapäcunan cara sacerdöticunalam, nätan manam pisi jucga. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jinaman ¿manachu leyipäcuraytag Moisés isquirbinganchru jamana junag cayaptinsi Diospa wayinchru sacerdöticuna uryapäcunganpita? Nätan paycunaga jamana junagchru uryarcayarsi mana juchaynagmi carcayan. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mayapäcamay shumag: ¡Nätan nogaga mas munayniyognincagmi canan caychru cayä Diospa wayinpitasi jinaman sacerdöticunapitasi! ");
INSERT INTO qvnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","¿Nätan gamcuna manachu tantiapäcunquitag isquirbishachru cay niyangantas? ‘Uywacunata ruparcayächingay manam alichu, runa-mayiquita mana cuyapaptiquiga’ niyanganta. Chayta mana tantiarmi gamcunaga mana juchaynagcunata ‘Juchäsapapag ricarcayanqui’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chaura noga jana pachapita shamusha runapa munaynïchrümi cayan jamana junagsi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaura chaypita aywarmi Jesusga yaycurun nogacuna Israel castacuna gotucarcänä wayiman. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaychrümi juc maquin uncusha runa cayänag. Chauraga imanaylapas “Pagta lutanta rurarachichwansi” nirmi fariseocunaga Jesusta tapurärin cay nir: “¿Jamana junagchru juc gueshyagta cuticächinanchipag isquirbirayanchu?” ");
INSERT INTO qvnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nipäcuptinmi Jesusga nirun: “¿Manachu maygaysi jamana junagchru pucyuman uyshay ishquiruptin jorgapäcunqui? Au, pasay-pacham jorgorcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nätan chay uyshapitaga masmi välin juc runaga. Chaura imatas alicagtaga jamana junagchru rurachwanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nircurmi maquin uncusha runata Jesús cay nirun: “Chacchayuy”. Jinarcurmi chacchayuptilan maquin shumag cuticarura. Chauraga cara jucag maquinnuy alim. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Chaypitam goturarcayangan wayipita yargorcurga chay fariseo ningancunaga “¿Imanuyparag Jesusta wanurachichwan?” nir rimanacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chaura chay rimanacurcanganta musyarurmi Jesuswan aywacurcarä chay carcayangäpita. Chay aywarcayaptïmi achca achca runacuna gatirapäcamara. Nätan Jesusga lapan gueshyagcunatam cuticächira. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jinamanmi “Noga cuticächipäcungagta amam pasay pitas willapacurcanquichu” nira. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chaynuy nira Jesusga willacugnin Isaiaswan Dios rimachingan ruracänanpagmi. Diosga rimachira cay nirmi: ");
INSERT INTO qvnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Payga cayan servimagnïmi jinaman acracungämi. Payga cayan cuyashämi. Paypitaga aliscam cushirayä. Payman cachramushag Espiritütam yanapänanpag. Jinaman juc casta runacunatam musyachinga juchacunata noga taripänäpita. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Manam payga pitas ashlipangachu, ni manam yanga gaparayarsi puringachu, ni manatan pisi mayangachu cällicunachru rimangantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nätan paquinayag chaglanuysi cayag runata manam lutanpag ricangachu, ni upinayag lamparinnuysi cayag runacunatas manam masta upirpachingachu. Antismi yanapanga alita ruragman muyuchingancama. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jinaman paymanmi yupachicurcanga juc casta runacuna” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaypitam Jesusmanga pusharärimun Asyagpa lutan espirituncunapa munayninchru cayag runata. Payga canag ñausham, jinaman mana pasay rimagmi. Chaynuytam Jesusga cuticarachin. Chaura chay runaga ricapuytas jinaman rimaytas galacuyun shumagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chauraga chaychru lapan runacunam mayacasha ricacarärin. Jinamanmi cay nipäcun: “¿Paychur cayansi Davidpa castan aymug shuyarayanganchiga?” ");
INSERT INTO qvnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chay nipäcugta mayarärirmi fariseocunaga cay nirärin: “Cay runaga lutan espiritucunata gargoyan Asyagcunapa mandagnin Beelzebüpa munayninwanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Chay nir pinsiarcayanganta tantiarurmi Jesusga cay nin: “May nacionchrüsi runacuna punta punta raquicarurga quiquincama peliayälarmi ushanacurcan. Chaynuytan juc marcasi u juc wayichru yachrag runacunas raquicarärirga quiquincamam ushanacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chaura chaynuymi Asyagsi lutan espiritucunata gargorga cayan raquicasha. ¿Chauraga imanuyparag chay rurapäcunanta rurapäcunman? ");
INSERT INTO qvnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nätan Beelzebüpa munayninwan Asyagpa lutan espirituncunata noga gargoyaptïga, gamcunapa discïpuluycunaga ¿pipa munayninwantag Asyagpa lutan espirituncunata gargapäcun? Chaura discïpuluycuna nipäcushunqui alita u lutanta pinsiarcayangaytas. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nätan nogaga Diospa Espiritunpa munayninwanmi lutan espiritucunata gargoyä. Chaynuy carga nämau chraramun Diospa munayninchru cawapäcunay wichan. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Chaura ¿pirag juc calpasapa runata mana uchcular imantas suwapanman? Uchcurcurmi ichaga suwapanmanga. Chaynuymi nogaga rurayä lutan espiritucunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pisi ‘Wacga manam alitachu ruran’ nimagga conträmi cayan. Nätan pisi nogata mana yanapämagga runäcunatam wichicayächin. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chauraga mayapäcuy shumag: Dios perdonangam runacunata ima-ayga juchancunapitas jinaman pipag ima-ayga lutan rimapäcunganpitas. Nätan Santu Espiritupa munayninwan rurayagta wacga ‘Asyagpa munayninwanmi rurayan’ nigcunataga Diosga manam perdonangachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Noga jana pachapita shamusha runapag lutanta rimarcugtas Diosga perdonangam. Nätan Santu Espiritupag lutanta rimagtaga Dios manam perdonangachu ni canansi ni imaysi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Chauraga ali montinuy capäcuy ali runa. Nätan ama capäcuychu mana ali montinuyga. Nätan wayuyninpam reguenchi montitaga, ali monti cangantas u lutanta monti cangantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Gamcunaga chay acapala culebracunanuysi alisca lutanmi carcayanqui! Chaynuy lutan carmi gamcunaga lutanta rimarcayanqui. Chaura runaga riman imanuysi canganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ali runaga alicunata riman ali runa carmi. Nätan lutan runaga lutancunata riman lutan runa carmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mayapäcamay shumag: Dios juchacunata taripänan junagga pipitas chay lutanta yanga rimapäcunganta lapantam rimacurcanga pi maysi. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chaura imanuysi rimangaypitam canqui ‘Cunchuchisha cachun’ nishas u mana juchaynagpag ricashas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niruptin juc ishcay Moisés isquirbingancunapita yachrachigcunawan fariseo ningancunam Jesusta cay nirärin: “Yachrachig, imalatas rurayuynar runala mana ruray atipänanta Diospita cangayta musyapäcunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nipäcuptinmi Jesusga cay nirun: “Lutan runacunalam, jinaman Dios munangannuy mana caway munagcunalam ima-aygatas munaynïwan ruranätaga munapäcun. Nätan manam imatas rurashagchu. Antis ricapäcunquiga Diospa willacugnin Jonaswan ruracangannuysi nogawan ruracagtam. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonasga quima junagmi jinaman quima pagasmi jatun pescädupa pachranchru cara. Chaynuymi noga jana pachapita shamusha runasi cashag pampa ruyichru quima junag, quima pagas. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cay wichan runacunawan parëjum unay Nínive marcachru yachragcuna cawacapäcamunga. Chay junagmi cay wichan runacunata Dios juchancunapita taripayaptin paycunaga ‘Juchancunapita cunchuchisha capäcuchun’ nipäcunga. Ninivechru yachragcunaga cunchupäcunanta Jonaswan Dios willarachiptin jucha rurayta wanacurcurmi Diosman cutipäcusha. Nätan caychru nogaga cayä mas munayniyogmi Jonaspitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chay juchacunata taripänan junagmi Arabiachru mandag warmis cay wichan runacunawan parëju cawacapäcamunga. Chaura paysi ‘Juchanpita cunchuchisha capäcuchun’ ningam: Chay warmi alisca caru nacionpitam shamura Salomón rimanganta mayacunanpag. Nätan caychru nogaga cayä Rey Salomonpitaga mas munayniyogmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Runachru cayanganpita lutan espíritu nä yargorurga purin mana yacünag chaqui pampacunapam ‘¿Maychrütag jamayüman?’ nir. Chaura jamananpag mana tarirga ");
INSERT INTO qvnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","cay ninmi: ‘Mä yargamungä runaman cutishag’ nir, cutirga chay runata tarirun jäcachisha wayitanuymi ali pichashatanuymi jinaman shumag chrurachracushatanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaura chaynuyta tarirur lutan espirituga cutircurmi pushamun ganchris lutan espiritupa lutan espiritu-mayincunata, quiquinpita mas juyunnincunata. Chaypitam lapan yaycapäcun chay runaman. Chaura chay runaga naupa canganpitaga mas lutan ruragmanmi muyun. Chaynuymi ruracanga cay wichan lutan runacunawansi mana niyangäta chrasquicarcämaptinga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Chay nir runacunata Jesús rimapayaptinmi wauguencunawan maman chrarärimurga, washachru shuyararcayara Jesuswan rimayta munapäcur. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chaura juc runam Jesusta willarun cay nir: “Mamaywan wauguequicunam washachru carcayan rimaytash munarcayan gamwan”. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Niptinmi Jesusga chay willag runata cay nirun: “¿Pitag cayan mamä? ¿Pitag cayan wauguëcuna?” ");
INSERT INTO qvnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nirmi nogacunaman maquinta chacchayämur cay nipäcaman: “Caycunam cayan mamäsi jinaman wauguëcunas. ");
INSERT INTO qvnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nogapaga wauguësi panïsi jinaman mamäsi cayan jana pachachru cayag Dios-mayï munangannuy ruragcunam” nira. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay junagmi wayipita yargor Jesusga aywara jatun gochra manyanta. Jinarcurmi chrarurga tacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chaypitam achca runacuna chay cayanganman gotucarärimuptinga büquiman yaycurcur Jesusga tacuyun. Nätan runacunaga gochra manyanchrümi capäcura nogacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaychrümi Jesusga imacunawansi musyapäcunganwan tincuchiypacama yachrachiyta galacuyun cay nir: “Juc runam yargaramun murug. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chauraga muruta wichiptinmi waquin murucunaga camiñuman ishquirärin. Jinarcurmi pishgocuna aywarcamur chay murucunataga micarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nätan waquin murucunam shala shalaman ishquirärin walca alpayoglaman. Jinarcurmi chay murucunaga ashcamayla yargarärimun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Chaypitam inti yargaramur alisca acacharamuptinga chaquiman aywarärin mana sapichacusharag capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin murucunam ishquirärin casha cashaman. Jinarcurmi cashacuna wiñaramurga limpu nitirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nätan waquinmi ichaga ali alpaman ishquirärin. Chaycunam ichaga ali gueshpisha, waquinmi camacusha juc tullulachru pachractacama, waquinmi sogta chruncatacama, waquinmi quima chruncatacama”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nircurmi “Mayarcayämagcuna, shumag tantiapäcuy cay niyangäta” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chaura discïpuluncunaga Jesusman ashuyurmi tapurärï: “¿Imanirtag imawansi tincuchiypa cay runacunata yachrayächinqui?” ");
INSERT INTO qvnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nipäcuptïmi Jesusga cay niräriman: “Gamcunataga Diosmi nä musyarcayächishunqui canancama mana pisi musyanganta. Chay musyarcayangayga cayan runacuna Diospa munayninchru cawapäcunanmi. Nätan cay runacunaga manaran musyapäcunragchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chayta musyay munagga pisi tantiachisham canga, jinaman shumagmi tantianga. Nätan mana musyay munagcunaga tantianganpitas mana pasay tantiagmanmi muyunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chaymi noga yachrayächï imawansi tincuchiypa, rurangäta ricarcayarsi mana ricagnuy capäcuptin, yachrachingäta mayarcayarsi mana mayagnuy capäcuptin, jinaman mana pasay tantiapäcuptin. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chaura paycunawanga ruracayan unay willacugnin Isaiaswan Dios cay nir isquirbichingannuylam. Diosga cay niram: ‘Mayarcayarsi manam pasay tantiapäcungachu. Ricarcayarsi manatan tantiapäcungachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cay runacunapaga shongoncunas muyurun rumimannuymi. Chaymi mayayarsi mana mayagtucurcanchu, ricapuyarsi mana ricapugtucurcanchu. Chaymi mayayarsi ricapuyarsi mana tantiapäcunchu. Manatan jucha ruraypita wanacurcursi nogaman cutipäcamunchu quiquï cuticächinäpagsi’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nätan gamcuna ichaga cushicurcay, mayacarcayämagcuna jinaman ricaparcayämagcuna. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mayapäcuy shumag: Diospa unay willacugnincuna jinaman alita rurag runacuna achcam ricayta munapäcura canan ricarcayangayta, jinaman mayaytas munapäcura canan mayacurcayangaytas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nircurmi cay nipäcaman: “Chaura mayapäcamay chay murug runawan ima niyta munangätas. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chauraga camiñuman muru ishquishanuymi waquin runacuna carcayan Diospa munayninchru cawananpita mayacuyarsi mana tantiagcuna. Chay mana shumag tantiaglatam Asyag aywarcamur gongarachin muru wichishata pishgo palarugnuysi. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nätan shala shalaman muru ishquishanuytan carcayan waquin runacunaga: Paycunaga ali willapata mayacurcanmi, jinaman cushisham chrasquicurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chaypitam ali willapapa janan ima-aygas cunchuycuna jinaman laquicuycuna shamuptin ishquicarärin, mana shumag sapichacushanuysi capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nätan casha cashaman muru ishquishanuytan carcayan waquin runacunaga. Paycunas mayacurcanmi jinaman chrasquicurcanmi ali willapata. Nätan imas aygas cay pachachru ruraynincunam, jinaman ima-aygas capungancunalam yarpararmi Diospa willapanta gongarärin. Chauraga manam Dios munangannuychu cawapäcun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nätan waquin runacunaga ali alpaman muru ishquishanuymi carcayan. Paycunaga ali willapata mayacurcanmi jinaman tantiapäcunmi. Jinamanmi mayacurcangannuy cawapäcun. Chauraga tarpusha muru alisca gueshpishanuymi capäcun. Waquinmi capäcun chay juclay murulapita pachrac wayugnuy; waquinmi sogta chrunca wayugnuy; jinaman waquinmi quima chrunca wayugnuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nircur Jesusga yapaymi Diospa munayninchru cawayagcunapita tincuchiypa yachrachiratag cay nir: “Juc runam chracranman ali trïguta mururachin. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jinarcurmi punurcayangancama payta chregnipag runa aywarcurga, trïgu murupäcungan jananman lutan guewapa murunta wichircur cuticunag. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chaura trïgu wiñaramur nä camacuyaptinmi lutan guewas musyacarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaura rantisha runacunaga chay chracrayog runanman aywarcurmi cay nirärin: ‘Tayta, gamga ali murutatag muruchipäcamarayqui. ¿Imanirtag lutan guewa yargaramun?’ ");
INSERT INTO qvnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nipäcuptinmi chay chracrayogga cay nin: ‘Pisi chregnimagnïchri caytaga ruraraman’. Niptinmi rantisha runancunaga cay nirärin: ‘¿Chay lutan guewacunataga sapiy usharärimümanchu?’ ");
INSERT INTO qvnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nipäcuptinmi chracrayog runaga cay nin: ‘Ama, chay lutan guewata sapirga trïguntintam chutapäcarärinqui’. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Antis jina trïguwan parëju wiñachun pogongancama. Cosëchachrümi uryagnïcunata cay nishag: ‘Naupataga chay lutan guewata shuntarcur watachrapäcuy rupachinapag. Nätan trïguta ichaga shuntarcur pirwacuna wayïman chrurapäcuy’ nishag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nircur yapaymi Jesusga tincuchiypa yachrachiratag Diospa munayninchru cawayagcunapita cay nir: “Nustäsa murutam juc runa chracranman tarpurun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nätan chay muruga cayan waquin murucunapitaga mas ichiclanmi. Chay ichicla cayarsi verdüracunapitaga mastam wiñan, montinuy cangancamam. Chaymanga pishgocunas aywarcamur rämancunachru gueshyantam rurapäcun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Chaypitas yapaytan Jesusga tincuchiypa yachrachiratag Diospa munayninchru cawayagcunapita cay nir: “Juc warmi quima tupuy harinaman ichic levaduralata tacurachiptin lapan harinatam jacarichimun. Chaynuymi capäcunaga Diospa munayninchru cawag runacuna” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús runacunata yachrachira chaynuy imawansi tincuchiypam. Mana imawansi tincuchilarga manam yachrachirachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nätan Jesusga yachrachira unay willacugninwan Dios rimachingannuy ruracänanpagmi Diosga cay niram: “Imawansi tincuchiypam yachrachishag. Pachata camanganpita canancama mana pisi musyangantam tantiachishag” niram. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chaura Jesusga chay goturarcayag runacunata “Aywacurcay” nircurmi wayita aywacun. Chay wayichrümi discïpuluncunaga cay nirärï: “Chay lutan guewawan tincuchiypa yachrachingayta tantiachipäcamay”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nipäcuptïmi Jesusga cay nir tantiarärichiman: “Chay ali muruta murugnuyga noga jana pachapita shamusha runam cayä. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nätan chracranuyga cayan cay pacham. Ali murunuyga cayan Diospa munayninchru cawagcunam, nätan lutan guewanuyga cayan Asyag munanganta rurag runacunam. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chracrayogta chregnigga jinaman lutan guewata muruchigga cayan quiquin Asyagmi. Nätan cosëcha junagga cayan Dios juchacunata taripänan junagmi. Nätan trïgu rutugcunanuyga capäcunga jana pachachru angelnincunam. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chauraga lutan guewatachu goturcur ninawan rupachinchi. Chaynuymi Dios juchacunata taripänan junag lutan runacunata ruranga. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noga jana pachapita shamusha runam angelnïcunata cachramushag, paycunam Diospa munayninchru cawag runacunawan cayagpita chay juchäcachigcunata, jinaman jucha ruragcunata shuntapäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Chaypitam paycunaga goturcur nina wayiman jitayupäcunga. Chaychrümi alisca cunchur wagapäcunga, jinaman laquicuptin quiruncunas gapapaylam wagaringa. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nätan alita ruragcunaga intinuymi achicyapäcunga Tayta Diospa munayninchru nä cawayta galayarärirga. Mayacarcayämagcuna cay niyangäta shumag tantiapäcuy” niräriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Chaypitas Jesusga yapaymi tincuchiypa yachrachipäcamaratag Diospa munayninchru cawayagcunapita cay nir: “Juc pampachrümi cara alisca välig paca. Chay pacata tarirurmi runaga gangalanman pacarpuyur cushisha aywacun ima-aygantas ranticug. Jinarcurmi rantirun chay pacayog pampata. Chaynuymi rurapäcun Diospa munayninchru cawayta munagcuna”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Chaypitas yapaytan Diospa munayninchru cawayagcunapita cay niräriman: “Cara alisca välig perlam. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ali perlacunata rantig runam mas alisca välig perlata tarirurga aywacun ima-aygantas ranticug. Jinarcurmi chay alisca välig perlata rantirun. Chaynuymi rurapäcun Diospa munayninchru cawayta munagcuna”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Chaypitas yapaytan Diospa munayninchru cawayagcunapita cay nira: “Juc ataräyata, jatun gochraman runacuna jitarpuruptin tucuy casta pescädutam charimun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chaytam nä gochra manyanman chutarärimurga, tacayärir pescäducunata acrapäcurcan. Alicagtam balayman wiñapäcun, jinaman mana alicagtam gochraman jitaripäcun. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chaynuymi Dios juchacunata taripänan junag ruracanga runacunawan. Chaynuy rurananpag Diosga cachramunga angelnincunatam lutan ruragcunata ali ruragcunapita raquinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jinarcurmi lutan ruragcunata nina wayiman jitayupäcunga. Chaychrümi alisca wagapäcunga, jinamanmi quiruncunas wagaringa gapapayla”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chaynuy nircurmi Jesusga tapuräriman: “¿Yachrachingäta tantiarärinqui lapantachu?” Nipäcamaptin nogacunaga “Au tayta” nirärïmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chauraga cay nirärimanmi: “Pisi Moisés isquirbinganpita yachrachig runa Diospa munayninchru cawaypita nä musyarurga cayan chrurashanta jorgamunman mushog cagcunatas unay cagcunatas, chaynuymi juc capogniyog runanuymi. Chay runachu wayinchru ima-aygansi gamcunas yachrachipäcunqui unaycagtas jinaman mushogcagtas” niräriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nä chaynuy imawansi tincuchiypa yachrarcachir Jesusga aywacun nogacuna discïpulucunawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jinarcurmi nä Nazaret marcanman chrarurga, marca-mayincunata yachrachira Israel castäcuna gotucarcänan wayichru. Chaura chay mayacug runacunaga mayacasham ricacarärin. Jinarcurmi cay ninacurcara: “¿Maychrütag cay runaga caynuy yachracurura? jinaman ¿imanaypatag caynuy munayniyog cayan ima-aygatas mana runala ruray atipänanta rurananpag? ");
INSERT INTO qvnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nätan cayga cayan chay carpintërupa churilantag, mamansi chay Mariatag. Caypaga wauguencunas cayan chay Santiagotag, Josëtag, Simontag, Judastag. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jinaman panincunas cay marcalachrütag yachrarcayan. ¿Chauraga maychrütag cay runaga caynuy yachracaramun?” ");
INSERT INTO qvnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chay nir manacagpag ricapäcuptinmi Jesusga cay nirun: “Maychru chaychrüsi Diospa willacugnintaga alipam ricapäcun. Nätan marca-mayincunawan wayinchru cagcunam ichaga manacagpag ricapäcun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chaynuy manacagpag ricapäcuptinmi, mana ima-aygatas alisca rurarachu munayninwan. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay wichanmi Galileachru mandag Rey Herodes mayarura Jesús ima-aygatas munayninwan rurayanganpita alisca rimapäcugta. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chauraga chaychru yanapag runancunatam Herodesga cay ninag: “Chay runaga cayan fiju Bautizag Juanchri. Paychri fiju cawacarayämun. Chaymi munayninwan ima-aygatas rurayan” ninag. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nätan Juantaga quiquin Herodesmi cadenawan watashata carcelman wichrgarachinag. Chaynuy rurara Herodías jutiyog warmipa jananmi. Chay warmiga cara Herodespa wauguen Felipepa warminmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chaura Juanga nämi Herodesta yapay yapay nisha canag “Ama wauguequipa warminta warminchacuychu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chay ninganpitam Herodesga wanuchiyta munara. Nätan mana wanuchirachüga chay marcachru runacunata manchacurmi, lapan runacunas Diospa willacugninpag ricapäcuptin. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jinarcurmi Rey Herodespa diyasninchrüga Herodías warmipa jipashnin tushurunag lapan gayachimushancunapa naupanchru. Chaura chay tushungan Rey Herodesta alisca gustaruptinshi, ");
INSERT INTO qvnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","jipashtaga cay nirun: “Tushungaypita imatas munangayta manacamay. Mana ningäta goptïga Dios cunchuchimächun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Niptinshi jipashga maman nä yachrachisha captin Herodestaga manacurun cay nir: “Bautizag Juanpa umanta gomay juc plätuchru”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Niptinga Rey Herodesga aliscash laquicurun. Chaura gayachimushancunapa naupanchru nä juracusha carga, runancunatash cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","“Carcelta aywarcur Juanta mogopäcamuy, jinaman umanta apapäcamuy gopäcunaypag” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nä umanta plätuwan chrarärichimurga chay jipashtash gorärin. Nätan jipashga mamantash gorun. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chaypitam Juanpa discïpuluncuna chrarärirga ayata aywarcachir enterrarärimunag. Jinarcurmi chrarärimun Jesús willag. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nä Bautizag Juanta chaynuy pasanganta mayarur Jesusga aywacun nogacuna discïpuluncunawanmi chay carcayangäpita juc büquiman jegarcur chunyag pampata. Nätan may aywapäcungätas runacuna musyarärirga gatirapäcamänag chraquipam marcacunapita. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chaura nä büquipita Jesús yargoyarmi, alisca chranin runacuna shuyararcayagta ricapururga cuyaparun, jinarcurmi chaychru gueshyagcuna cayagta cuticarachin. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chaura nä pacha chacanayaptinmi discïpuluncunaga Jesusman ashuyur cay nirärï: “Chunyagchrümi cayanchi. Nämi chacanayan. Runacunata aywacurcay niy, mayag acapa marcacunalachrüsi micuyta rantipäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chay niräriptïmi Jesusga “¡Imapagmi aywapäcunga! Gamcuna gopäcuy micuyta”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nipäcamaptinga cay nirärïmi: “Chararcayäga pichga tantatawan ishcay pescädulatam”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nipäcuptïga “Chayta apapäcamuy cayman” nirärimanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chauraga runacunatam nirun guewa pampaman tayucurcänanpag. Jinarcurmi pichga tantatawan ishcay pescäduta aptacurcurga, jana pachata rircacurcur Diosta “Caynar aypalächun Tayta” nirun. Chauraga pescädutawan tantata partichracurcurmi nogacunata goräriman. Nätan nogacunam runacunata aypuchracurcarä. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chaura lapanmi micarärin yamay yamay. Nätan puchupacurcangantam chrunca ishcayniyog balay juntata shuntarärï. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chay micugga capäcura olgocunalam pichga waranganuy, nätan manam warmitawan wamracunataga yupapäcurächu. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaypitaga chaylam Jesusga büquiman yaycarärichiman jatun gochra chimpanman naupacurcayänäpag. Nätan payga quëdarun runacunata “Aywalayrag” nichracuyarmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nä runacuna aywacurcaptin Jesusga aywacun juc gotutam chaychru Dioswan rimananpag. Nä pacha chacashas Jesusga cayara japalanmi chaychru. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nätan nogacunaga gochra chraupitam nä aywarcayarä. Naupapita alisca walyaywan yacu sharcur büquiman lagyamuptin mana aywayta atipayar. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nä pacha waraymanga nogacunacagmanmi Jesús ichriyämunag yacu jananpa. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chay yacu jananpa aywayämugta ricaparärirmi gapachracarärï manchacaypita wacga “Almachr” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chaura Jesusga juclam rimaparäriman cay nir: “Ama manchacapäcuychu. Nogam cayä. Valorchacurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chay nipäcamaptinmi Pedroga nirun: “Munayniyog tayta, gam cayarga ‘Shamuy’ nimay yacu jananpa ichrimunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Niptin Jesusga “Shamuy” nirunmi. Jinarcurmi büquipita jegarpurcur Pedroga ichriyara yacu jananpa Jesuscagman. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Chaura alisca walyaywan yacu sharcuyagta ricapurur Pedroga manchacarunmi. Jinarcurmi nä yacuman talpuyta galayurga gapachracurun “¡Munayniyog tayta, chutamay! ¡Wanucuyushagchrau!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chauraga chayüram Pedrota maquinpita charirun. Jinarcurmi cay nirun: “¡Mana aläpa yupachicamag runa! ¿Imanirtag mana lapan shongoypa yupachicamanquichu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jinarcurmi nä büquiman paycuna yaycarärimuptinga, chaylam walyay amaynarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaura nogacunaga Jesuspa naupanmanmi gongorpacayärï “Gamga razonpa cayanqui Diospa-mayinmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chay gochrata nä chimpaman pasarärirga, chrarärï ‘Genesaret’ ninganmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jinarcurmi chaychru yachragcunaga Jesusta nä reguerärirga limpu musyachinacarärin chay Genesaret ninganpaga. Chauraga lapan gueshyayagcunatam aywachipäcamura payman. ");
INSERT INTO qvnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nätan Jesuscagman chrarärichimurga, “Tayta, jacuypa tumalantasar yatayärishunqui” nipäcuram. Jinarcurmi pi maysi tupayugcagga cuticarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chauraga fariseo ningancunawan Moisés isquirbinganpita yachrachigcunam Jesusman ashuyarärin. Paycuna aywamusha capäcunag Jerusalenpitam. Jinarcurmi Jesusta tapurärin cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imanirtag mana cäsucurcanchu gampa discïpuluycuna unay awillunchicuna ‘Micapäcunaypagga maquicunataran maylacurcanqui’ nipäcunganta?” ");
INSERT INTO qvnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nipäcuptinmi Jesusga cay nir tapurun: “¿Imanirtag gamcunasi awilluycuna ningalanta rurarcayanqui, antis Dios mandanganta mana cäsucurcar? ");
INSERT INTO qvnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosga cay niyanmi: ‘Taytayta, mamayta alipam ricanqui. Nätan pisi taytanta, mamanta lutanpa ricagga wanuchisha cachun’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Chaynuy Dios nisha cayaptinmi gamcunaga mamanta, taytanta mana yanapapäcunanpag jucnuypa yachrarcayächinqui cay nir: ‘Tayta, mama, lapan imätasi Diostam gosha cä. Chaymi nä mana gamta imalawansi yanapagmanchu’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chaynuy yachrachipäcuptiquim taytanta mamanta nä mana yanapapäcunchu. Chaynuypaga Dios mandangantam manacagman muyurcayächinqui, awilluycuna nipäcungalanta cäsucur. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Alitucugcuna! Razoncagtam Diospa willacugnin Isaías isquirbira gamcunapita cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Cay runacunapa shimilanga ‘Razón razonmi Diosga alim’ nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yangalam nogapag imatas rurapäcun, ‘Runacuna nipäcungalanta caysi Diospa mandashanmi’ nir yachrarcayächir”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chaypitam Jesusga chaychru carcayag chranin runacunata gayarcur cay nirun: “¡Shumag mayapäcamay, jinaman rimangäta shumag tantiapäcuy! ");
INSERT INTO qvnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maquinta mana maylacular micunganchu manam runataga juchäcachin, antis shimin rimanganmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chaypitas nogacunaga naupanman ashuyärirmi Jesusta nirärï: “¿Musyayanquichu chaynuy ningaypita wac fariseocuna piñararcayanganta?” ");
INSERT INTO qvnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nipäcuptïmi Jesusga niräriman: “Jana pachachru cayag Tayta Dios ningancunapita jucnuyta yachrachigga juc malqui sapishanuymi canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","¡Jina capächun imanuysi! Chaycunaga carcayan juc ñausha runa juc ñausha-mayinta pushapagnuymi. Chaynuy carga ishcayninmi mayag uchrcumansi ishquipäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaura Pedroga cay nirunmi: “Tantiachipäcamay chay micuypita rimangayta”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Niptinmi Jesusga cay nirun: “¡Ö! ¿Gamcunas manachu tantiapäcunqui? ");
INSERT INTO qvnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Micuyga lapansi pachranmanmi yaycun. Nätan pachrapitaga ishpamunchim. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nätan shimi rimanganga shongonpitam yargamun. Chaymi ichaga runacunata juchäcachin. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runacunapa shongoncunapitam yargamun lutan pinsiaycuna, runa wanuchiycuna, nä casarasha cayar warmin warmin olgon olgon puriycuna, mana casarasha cayar warmin warmin olgon olgon cawaycuna, suwacuycuna, casqui rimaycuna, manacagpita juchachaycuna, jinaman yangapita ashliyaycuna. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chaycunam runacunataga juchayogman muyuchin, nätan manam maquita mana maylacular micunganchu”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chaypita yargor Jesusga aywacura Sidonchru jinaman Tïrochru cayag marcacunamanmi nogacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chaychrümi Canaán nacionchru näcisha juc warmiga guepäcunata yargaramun cay nir gaparayar: “¡Munayniyog tayta, Davidpa churin aywag casta, cuyapayämaynar! Wariwamrätam lutan espíritu alisca cunchuyächin” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nätan Jesusga yaparcur yaparcur niyaptinsi upälalam aywayara. Chaura nogacunaga ashuyurmi nirärï: “Manacushungaynuynar yanapayuy, jinaman ‘Aywacuy’ niruy mana masta gaparayar guepanchita aymunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nipäcuptï Jesusga cay nirärimanmi: “Diosga cachrarayäman ogracasha uyshacunanuysi carcayag Israel runacunalamanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chaura warmiga Jesusta tariparcurmi naupanman gongorpacuyun cay nir: “¡Munayniyog tayta, manacungagnuynar rurayulay!” ");
INSERT INTO qvnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Niptinmi Jesusga cay nirun: “Manacamangayta rurarga, wamräcunapag cayag tantanta algocunata garagnuychri rurarushag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chaynuy niyaptinsi warmiga cay nirunmi: “Au Munayniyog tayta, alitam nirunqui. Algocunas micapäcunmi runanpa mësanpita micuy ishquiglataga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Niptinmi Jesusga cay nirun: “Gammi ichaga alisca yupachicayämänayga. Chauraga manacamangaynuy cachun”. Niruptinga chayürapitam warmipa wawanga shumag cuticarura. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nä chaypita cutimurga Jesuswan chrarärimü Galilea gochra manyanmanmi. Jinarcurmi Jesusga juc gotuman jegarcur chaychru tacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chaymanmi chrarärimun achca achca runacuna, ratacunata, ñaushacunata, mana rimay atipagcunata, maquin uncushacunata, jinaman tucuywan gueshyagcunata apacarcärimur. Jinarcurmi Jesuspa naupanman chruraräriptin payga lapanta cuticächira. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chaura chaychru chay chranin runacuna carcayagga alisca mayacasham ricacarärin mana rimay atipagcuna rimarcayagta, ratacuna purircayagta, ñaushacuna ricapurcayagta, jinaman maquin uncushacunata ali maquiyogta ricaparärir. Chaymi cushisha Israelpa Diosninta cay nipäcura: “Tayta Diosga alisca munayniyogmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chaura Jesusga discïpuluncunata gayarcärimarmi cay niräriman: “Caychru goturarcayag runacunata cuyapayämi, nä quima junagmi noganchiwan caychru carcayan, manam nä imancunas canchu micapäcunanpag. Nätan malagashataga manam cutipäcunanta munächu camiñuchru lamsupäcunanpita”. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nipäcamaptinmi nogacunaga cay nirärï: “Caychica runa micunanpagga ¿maypitatag micuyta jorgapäcamushag cay chunyag pampachrüga?” ");
INSERT INTO qvnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nipäcuptïmi Jesusga tapuräriman: “¿Ayga tantatatag chararcayanqui?” Nipäcamaptinga “Ganchrislatam jinaman ishcay quima acapa pescädulatam” nirärï. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chaura Jesusga “Pampaman iscatapäcuy” nirunmi chay runacunataga. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jinarcurmi chay ganchris tantata pescäduntinta aptacurcur Diosta “Caytanar aypayächilay Tayta” nirun. Chaypitam partircur partircur nogacunata goräriman runacunata aypupäcunäpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chauraga lapanmi micarärin yamay yamay. Nätan chay yamapacur puchupäcungantam shuntarärï ganchris acray balay juntata. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chaychru micugcuna capäcura chruscu warangam olgola, nätan warmicunawan wamracunaga manam yupacashachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Micacarcäriptinmi ichaga runacunata “Aywacurcay” nirun. Nircurga büquiman yaycurcurmi Magdala ninganman aywacun nogacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chaychrümi fariseo ningancunawan saduceocuna ningancunaga ashuyarärin Jesusman juchäcachiyta munapäcur. Chauraga cay nirärinmi: “Mä Diospa munayninwan imalatas canan rurayuy ricarcayaptï”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nipäcuptinmi Jesusga cay nirun: “Gamcunaga pacha chacanayar antagshamuptin waraga ‘Usyangam’ nircayanquim. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nätan goyapa pucutashachru antagshamuptinmi, cananga ‘Tamyamungam’ nircayanqui. Gamcunaga antagshaypa shumagmi tantiarcayanqui tamyanantas u usyanantas. Nätan cay wichan Diospa munayninwan ima-aygas ruracayagtam icha mana tantiapäcunquichüga. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cay lutan casta runacunawan, jinaman Dios ningancunata jucnuyman muyuchigcunalam munaynïwan ruranätaga munarcayan. Nätan manam mastaga imatas rurashagchu, antis ricapäcungaga Diospa willacugnin Jonaswannuysi nogawan ruracagtam”. Nircurmi Jesusga chay runacunata dëjarcur aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chaura nogacuna discïpuluncunaga chay jatun gochra chimpaman chrarärirga, tanta mana apapäcungätam yarparärï. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chaura Jesusga cay nipäcamanmi: “Fariseo ningancunapawan saduceocunapa levaduratatag ichaga chrasquirärinquiman”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nipäcamaptinmi nogacunaga mana chayta tantiar quiquïcama cay ninacarärï: “¿Tantata mana apamunganchipitachr niyämanchi?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chay ninacurcangäta tantiarurmi Jesusga nipäcaman: “Diosman mana aläpa yupachicug runacuna ¿imanirtag gamcuna tantata mana apapäcamungaypita laquirarcayanqui? ");
INSERT INTO qvnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manachu shumag tantiapäcunquirag? ¿Nä manachu yarpapäcunqui chay pichga tantalapita pichga waranga olgocuna micachingäta? Jinaman ¿manachu yarpapäcunqui ayga balay juntata shuntapäcungaytas? ");
INSERT INTO qvnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ni manachu yarpapäcunqui ganchris tantalapita chruscu waranga olgocunata micachingäta? Jinaman ¿ayga balaytam puchucunata shuntapäcurayqui? ");
INSERT INTO qvnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imanirtag mana tantiapäcunquichu? Nogaga manam tantapitachu rimä. Rimayäga fariseocunapawan saduceocunapa levaduranpitam”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nipäcamaptinran tantiarärï levadurapita mana nircayämanganta, antis fariseocunawan saduceocuna yachrarcayächinganta mana chrasquipäcunäpag nircayämanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chaura Filipochru Cesarea ninganman chraräriptïmi Jesusga tapuräriman cay nir: “¿Pimi wac runa nipäcamantag runacuna, noga jana pachapita shamusha runata?” ");
INSERT INTO qvnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Niptinga cay nirärï: “Waquinmi ‘Bautizag Juanmi’ nircayäshunqui. Waquinga ‘Diospa willacugnin Eliasmi’ nircayäshunquim. Waquincunaga ‘Diospa willacugnin Jeremiasmi’ nircayäshunquim. Nätan waquincagmi ‘Diospa willacugninchri maygansi’ cayan nircayäshunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chaypitas Jesusga cay nipäcamantan: “¿Gamcunaga ‘Pimi cayan’ nircayämanquitag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nipäcamaptinmi Pedro nipäcungä Simonga cay nin: “Gamga cayanqui chay shuyacurayangä salvacugmi jinaman cawag Diospa-mayinmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chay niruptin Jesusga cay ninmi: “¡Jonaspa churin Simón, alisca cushicuy! Gamtaga manam pi runasi tantiachishuraychu chaynuy nimänaypagga, antis jana pachachru cayag Tayta Diosmi tantiarayächishunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jinaman gamsi nogapagga cayanqui Pedrom. Nätan gam cananpita canqui juc gaganuymi. Gammi nogaman yupachicamag runacunata yanapanqui. Nätan paycunata manam Asyag illacächiyta atipangachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nätan gamga cayanqui llävi charagnuymi Diospa munayninchru cawag runacunata yanapänaypag. Gam cay pachachru ‘Alim’ ningayga jana pachachrüsi ali nisham canga, nätan cay pachachru ‘Manam alichu’ ningaysi jana pachachrüsi manam alichu nishatan canga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nircurmi discïpuluncunata cay niräriman: “Ama willapacurcaraychu shuyarcurcayangay salvacug noga cangäta”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaypinpita-pacham Jesusga discïpuluncuna willayta galayapäcamasha “Jerusalén marcataga aywanämi cayan. Chaychrümi alisca cunchurcachir wanuchipäcamanga alinninpag ricasha chacha runacuna, sacerdöticunapa mandagnincuna, Moisés isquirbinganpita yachrachigcuna, nätan quima junagtaga cawacämushagmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chaura Pedroga Jesusta jucläman gayayurmi cay nirun: “¡Munayniyog tayta, chay rurapäcushunaypitaga cuidacuy, chaynuy pasashunaytaga ama munaychu!” ");
INSERT INTO qvnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Niptinmi Jesusga Pedrocagman muyurcur cay nirun: “¡Juchäcachimaytam munayanqui Asyag, nogapita shumagla aywacuy! Gamga manam Diosnuychu pinsianqui sinuga runacunanuylam”. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nircur Jesusga discïpuluncunatam cay niräriman: “Pi maysi noga ningänuy caway munagga shongon munangan ruray munayanganpita amachacuchun. Jinaman ima-aygata cunchunan u wanunan captinsi noganuy cawachun. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chaura pi maysi noga raygo mana cunchuy munagga manam nogawan cawangachu. Nätan pi maysi noga raygo wanunan captinsi cunchugmi ichaga nogawan cawanga imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chauraga runaga ¿imatarag jorgonman paylapa cay entëru pacha capuptinsi? u ¿imatarag Diosta gorunman jana pachachru paywan cananpag? ");
INSERT INTO qvnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nätan noga jana pachapita shamusha runaga aywamushag Tayta Diosnuysi alisca munayniyogmi jinaman paypa angelnincunawanmi. Chaychrümi ali ruragcuna alipag ricasha capäcunga, nätan lutan ruragcunam cunchuchisha capäcunga jucpacama. ");
INSERT INTO qvnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Shumag mayapäcamay: Waquinniqui caychru cayagcuna manaran wanupäcungaragchu noga jana pachapita shamusha runa mandanäpag aywamungäta tantiapäcungaycama” niräriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaypita nä sogta junag pasashachrümi Jesusga Pedrota, Jacobota, Jacobopa wauguen Juanta pushacurcur aywachicun juc altu gotuman. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chaychrüshi paycunapa naupanchru Jesusga muyurun jucnuyman. Cäranshi muyurun intinuy alisca achicyagman. Nätan jacunshi muyurun alisca chipchipyag jancanuyman. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chaypitaga chaylash ricacarärin Diospa willacugnin Moisés jinaman Elías Jesuswan rimarcayar. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaura Pedroga Jesustash cay nirun: “¡Munayniyog tayta, nogacunapagga may alichr caychru cacuyga! Munaptiquiga quima chuclata rurarärishag; jucta gampag, jucta Moisespag, nätan jucta Eliaspag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro chay nir rimayaptilanshi achicyag pucutay chaparärin. Jinarcurshi pucutaypita Diosga rimaparun paycunata cay nir: “Jesusga cayan cuyashä Dios-mayïmi. Payga aliscam cushicayächiman. Payta cäsucurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chay nigta mayarärirga, chay quiman discïpulucunaga gongorpacuyurshi lipucayärin pampaman urcuncuna tupangancama alisca manchacasha. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaura Jesusga paycunacagman ashuyurshi tupayurun: “Sharcapäcuy. Ama manchacapäcuychu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Chaura niptin rircärirga ricaparärin Jesuslatash, nätan manash nä canagchu chay ishcayga. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nä chay gotupita cutirparcayämuptinshi Jesús cay nirun: “Gotuchru ricapäcungaytaga amam pitas willapacurcanquichu noga jana pachapita shamusha runa wanungäpita cawacämungäcama” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaura chay quima discïpuluncunaga tapurärin cay nirshi: “¿Imanirtag Moisés isquirbinganpita yachrachigcunaga ‘Salvacug cay pachaman shamunanpagga naupata shamunga Diospa willacugnin Eliasran’ nipäcun?” ");
INSERT INTO qvnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nipäcuptinshi Jesusga cay nin: “Eliasga razonpa naupatam shamunga. Payga alimanmi ima-aygatas muyuchinga. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nätan cayta shumag mayapäcuy: Eliasga nämi shamusha. Pay aywaramuptin runacuna manam payta reguepäcushachu pi cangantas, antis paytaga munapäcungannuymi lutanta rurapäcusha. Chaynuymi noga jana pachapita shamusha runatasi munanganta rurapäcamanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niruptinragshi paycunaga tantiarärin Bautizag Juanpita rimayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nä runacuna carcayagman chrarärimuptïga, juc runam Jesuspa naupanman gongorpacuyur cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Munayniyog tayta, churïtanar cuyapayulay. Payga imayüra aygayüras wanupanmi. Jinarmi ninamansi yacumansi ishquin. Chaynuypam alisca juyupa cunchun. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chaymi discïpuluycunaman pushamurä. Jinarcurmi paycunaga mana cuticächiyta atipapäcunchu”. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Niptinmi Jesusga nirun: “¡Ay! ¡Diosman mana yupachicug jinaman lutanla pinsiag casta runacuna! ¿Imaycamarag cashag gamcunawan? ¿Imaycamarag gamcunata awantapäcushayqui? Mä chay walashta apapäcamuy cayman”. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chaura Jesusga lutan espiritutaga piñaparunmi. Chaynuypam gargorun espiritutaga. Chauraga chay walashga chayürapitam shumag cuticarura. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaypitam nogacunaga Jesuscagman ashuyur japalanta cay nir tapurärï: “¿Imanirtag nogacuna chay Asyagpa lutan espiritun gargoyta mana atipapäcurächu?” ");
INSERT INTO qvnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Nipäcuptïmi Jesusga cay niräriman: “Mana lapan shongoypa yupachicarcämarmi. Mayapäcamay shumag: Nustäsapa murunuylas gamcunapa yupachicuyniquicuna captinga, cay gotuta ‘Caypita ashuy wacman’ nipäcuptiqui, ashurunmanmi. Chaura gamcunapagga manam ima-ayga ruraysi sasachu canman” niräriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chaypitam Galilea ninganchru carcayaptï Jesusga cay nipäcaman: “Noga jana pachapita shamusha runaga jitayusha cashag lutan runacunapa maquinmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jinarcurmi chaycunaga wanuchipäcamanga, nätan wanungäpita quima junagtaga cawacämushagmi”. Chay nipäcamaptin nogacunaga aliscam laquicarärï. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chaypitam nä Jesuswan Capernaum marcaman chraräriptïga, Diospa wayinpag patentita cobragcunaga Pedrota tapurärin cay nir: “¿Yachrachishugniquicuna pägayanchu chay ishcay dracma ningan golgueta?” ");
INSERT INTO qvnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nipäcuptinmi Pedroga “Au” nirun. Jinarcurmi nä wayiman yaycuruptin Jesusga naupata rimarun cay nir: “Simón, ¿ima ninquitag gamga? ¿Pitatag cay pachachru patentita pägachin reycuna? ¿Castancunatachu u marca-mayincunatachu?” ");
INSERT INTO qvnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Niptinmi Pedroga “Marca-mayincunatam” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Chaura Jesusga cay ninmi: “¡Au! Reypa castancunaga manam päganchu. Nätan mana pisi piñäcunanpag jatun gochraman aywarcur anzuelawan pescacamuy. Jinarcurmi naupa charingay pescädupa shiminta ricanqui. Chaychrümi juc golgueta tarinqui. Chaytam pägamunqui ishcayninchipita” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chay niruptilanmi discïpuluncunaga Jesusman ashuyur tapurärï cay nir: “¿Maygäcunatag mas munayniyog capäcushag Diospa munayninchru cawarga?” ");
INSERT INTO qvnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nipäcuptïmi Jesusga juc walashta gayarcur chraupïcunaman shayarachin. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jinarcurmi cay nipäcaman: “Mayapäcamay shumag: Cay walashnuyman mana muyupacurga, jinaman paynuy mana capäcurga manam yaycapäcunquichu Diospa munayninchru cawayman. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chauraga pi maysi Dios ninganta cay wamranuysi cushisha cäsucugmi Diospa munayninchrüga mas munayniyog canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nätan nogatanuy cay walashnuylas cayag runäcunata pi maysi chrasquigga, nogatam chrasquircayäman. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nätan cay walashnuysi cayag runäcuna yupachicayämagta juclaylatas juchäcachigga, alim canman jatun molinu rumita cuncanman watarcur jatun gochrachru jundunninman jitarparäriptinsi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“¡Ay, cay pachachru runacunapag iman mana cayanchu juchäcachicug! Chay juchäcuyga chaynuylam cayanga. Nätan runäta juchäcachig runaga alisca juyupa cunchuchisham canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Chauraga maquiquisi u chraquiquisi juchäcachiyta munashuptiquiga, cuchurcur caruman jitarignuy ima jucha ruray munayangaypitas amachacuy. Ishcaynin maquintiquinuysi ishcaynin chraquintiquinuysi imaycamas mana upig ninaman jitayusha canaypitaga. Antis alim canman juclay maquiyognuylas u juclay chraquiyognuylas Dioswan imaycamas cawag yaycuptiqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jinaman ñawiqui juchäcachiyta munashuptiquis, jorgorcur caruman jitarignuy ima jucha ruray munayangaypitas amachacuy. Antis ishcaynin ñawintiqui nina wayiman jitayusha canaypitaga alim canman juclay ñawiyognuylas Dioswan imaycamas cawag yaycuptiqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Chauraga cay walashnuysi cayag runäcunata juchaman ishquipäcuptin amam manacagpag ricapäcunquichu ni juclaylatas. Paycunapa cuidagnin cayan angelcunam. Chay cuidagnincuna chaynuylam carcayan jana pachachru cayag Tayta Diospa naupanchru. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mä tantiachipäcushay uyshayog runawan: Juc runapa canman pachrac uyshan. Chay uyshacunapita jucta ograrur ¿imanantag? ¿Manachu waquinta jircacunachru dëjarcur aywan chay ogracasha ashig? ");
INSERT INTO qvnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mayapäcamay shumag: Nä tarirurga, chay taringan uyshapitam masga cushicun manam chay isgon chrunca isgonniyog uylurpushacunapitachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chaynuymi jana pachachru cayag Tayta Diosniquicuna mana munanchu cay walashnuysi cayag runäcunapita maygalansi ogracänanta. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Chaymi Diosman yupachicug-mayiqui imatas lutanta nirushuptiqui u rurarushuptiqui aywanqui paycagta. Jinarcurmi chaychru juchanta tantiachimunqui japalanta. Juchäcunganta tantiacuruptinga chay yupachicug-mayiquiwan, amistapäcuy, yapay ali cawapäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nätan mana mayacushuptiquiga jucta u ishcay runata pushacurcur cutiy, imanuy quëdapäcungaytas chay ishcay u quima runacuna ricapäcushunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nätan paycunatas mana mayacuptinga, Diosman yupachicug gotucagcunata willapacuy. Paycunatas mana mayacuptinga, chay runa cachun mana Israel castapag ricasha, u patentita cobragcunanuy ricasha cachun. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mayapäcamay shumag: Cay pachachru ‘Cayga alim’ nipäcungayqui, jana pachachru cayagpitas ‘Alim cayan’ nisham canga. Nätan cay pachachru ‘Cayga manam alichu’ nipäcungaysi, jana pachachru cayagpitas ‘Manam alichu’ nishatan canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Caytas niyärishay: Cay pachachru gamcunapita ishcay rimanacurcur imapitas Diosta manacurcaptiqui, jana pachachru cayag Tayta Diosga manacurcangaynuymi ruranga. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nätan noga niyangänuy manacurcänanpag maychrüsi ishcay quima gotucapäcuptinsi, nogaga paycunapa chraupinchrümi cayäshag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaura Pedroga Jesuscagman ashuyurmi tapurun cay nir: “Munayniyog, ¿ayga cutitag lutanta nimag u lutanta ruramag Diosman yupachicug-mayïta perdonashag? ¿Ganchris cutichu?” ");
INSERT INTO qvnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Niptinmi Jesusga cay nirun: “Manam ganchris cutilachu, antis maychica cutis perdonanquim”. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nircurmi Diospa munayninchru cawayagcunapita tincuchiypa cay niräriman: “Juc reymi servig runancunata cobrachracura. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jinarcurmi rey nä cobrachracuyta galayuyaptinga, chrarärichin juc runanta chrunca waranga talentu ningan golgue manutucushata. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jinarcurmi chay servig runanpa mana golguen cutichinanpag aypaptinga, chay reyga cay nirun: ‘Cananga ranticushay gamtam, warmiquitam, churiquicunatam, jinamanmi lapan ima-aygaytasi, mana golguë pampanman ruracänanpag’. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Niptinmi runaga reypa naupanman gongorpacuyur yaparcur yaparcur cay nira: ‘Tayta, shuyayälämaynar, lapantam cutichishay golguequita’. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Niptinmi reyga cuyaparur cachrarirun ‘Jina cachun chay golgue cutichimänay’ nircur. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nätan chaypita yargorcur aywayarmi, chay runaga tincurun juc servig-mayinwan. Chay servig-mayinmi manutucusha canag pachrac junagchru gänana ‘denariu’ ningan golguelata. Paytam cuncanpita lapiyan cay niyar: ‘Pasay-pacha golguëta cutichimay’. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chaynuypa niptinmi chay manutucushaga naupanman gongorpacuyur cay nin: ‘Shuyayälämaynar, lapantam cutichilashayqui’. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Niyaptinsi manam chay golgueyog runaga shuyayta munarachu. Chaypitam chay runaga aywachicun carcelman chaychru golguenta cutichingancama wichrgaränanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chaynuy jinagta waquin servig-mayincuna ricarärirga aliscam laquicarärin. Chauraga chay reyninmanmi aywarärin chay lapan ricapäcunganta willapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chaura willaräriptin reyga chay manutucushata perdonanganta gayarcachirmi cay nirun: ‘¡Alisca lutan runatag gamga cacunay! Nogaga “Tayta shuyayämay, cutichishaymi” nimaptiqui, antis “Jina cachun ama cutichimaychu” nirmi perdonarag. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gamtachu noga cuyaparag, chaynuymi gamsi cuyapanquiman cara servig-mayiquita’. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nircurmi chay reyga alisca piñasha runa wanuchigcunapa maquinman jitayurun, chaychru manutucuyninta cutichingancama cunchuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chaynuymi jana pachachru cayag Tayta Diosga rurapäcushunqui gamcunatas, lapan shongoypa Diosman yupachicug-mayiquita mana perdonaptiquiga” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chaynuypa nircärimar Jesusga Galileapita aywacun Judea ningantam nogacuna discïpuluncunawan. Jinarcurmi Jordán mayu inti yargamunan lädu chimpanman chrarärï. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chaychrüsi achca achca runacunam gatirapäcura, nätan lapan gueshyagcunatam cuticächira. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chauraga ishcay quima fariseo nipäcungancunam Jesusman ashuyarärin. Jinarcurmi “Alitachush u lutantachush nimänanchi” nir tapurärin: “¿Juc runa warminpita raquicanmanchu imalapitasi icha manachu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chay nipäcuptinmi Jesusga nin: “¿Manachu leyisha capäcunqui Dios isquirbichinganta? ‘Galayunanchrüga runata Camag Diosga camara olgotawan warmitam’. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chaypitam cay nira: ‘Chaymi olgoga yargonga taytanpa, mamanpa maquinpita warminwan cawananpag. Nätan chay ishcaynin juc runanuylam capäcunga’. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chauraga nä manam ishcay runachu capäcunga, antis juc runanuylam. Chaymi mana pi runas Dios juclapangantaga mana raquingachu”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Niptinmi chay fariseocunaga tapurärin cay nir: “¿Imanirtag isquirbinganchru Moisesga ‘Pisi warminta wicapay munagga papelta rurarcapur wicapächun’ nira?” ");
INSERT INTO qvnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nipäcuptinmi Jesusga cay nirun: “Gamcuna casta rumi shongo capäcuptiquim Moisés isquirbinganchrüga niyan warmiquicunata wicapapäcunaypag. Nätan galayunanchrüga manam chaynuychu Diosga nira. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nätan cayta niyärishay: Pisi warmintaga wicapanman juc olgowan captinran sinuga manam. Chaura warmin wicapag runa jucwan casaracurga juchatam rurayan. Nätan gowan wicapasha warmiwan juc olgo casaracursi juchatam ruran”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Niptinmi discïpuluncunaga cay nirärï: “Chaynuy captinga mas alichr canman mana casaracuysi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nipäcuptïmi Jesusga cay niräriman: “Chay nircayangayta manam lapan runachu chrasquicurcanga, antis japalan cananpag camashacunalam. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquin runacunaga mana casarapäcunchu mana casaränanpag camasha capäcurmi. Nätan waquinga mana casarapäcunchu mana casaränanpag runacuna caparäriptinmi. Nätan waquinga japalan cacurcan Dioslapag cawapäcunan raygom. Cay niyangäcunata pisi chrasquicuchun. Chaura pisi ‘Chaynuy cawaytam munä’ nigga chaynuy cawachun” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chauraga wamracunatam pusharärimun umancunaman maquinta chrurayur Tayta Diosta Jesús manacapunanpag. Jinarcurmi nogacuna discïpuluncunaga wamra apamug runacunataga piñaparärï. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chaura Jesusga cay nipäcamanmi: “¡Jina wamracunaga aywacarcämuchun nogaman! Ama piñapapäcuychu. Cay wamracunanuysi cagcunam nä Diospa munayninchrüga cawarcayan”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chay nircurmi Jesusga lapan wamracunapa umanman maquinta chrurayur Tayta Diosta manacurun paycunapa janan. Jinarcurmi Jesusga chaypita aywacun nogacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chaypitam juc mözu Jesusman chraramur cay nin: “Yachrachig, alisca alim gamga canqui. ¿Imatatag alicunata ruräman Dioswan imaycamas cawanäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Niptinmi Jesusga nirun: “¿Imanirtag tapucayämanqui chay ali ruraypita? Aliga cayan juclaylam. Chay aliga Dioslam. Nätan Dioswan imaycamas cawayta munarga, pay mandangancunata cäsucuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Niptinmi mözuga tapurun: “¿Maygancunatatag cäsucushag?” Niptinmi Jesusga nin: “ ‘Runa-mayiquita amam wanuchinquichu’ ninganta, ‘Warmiyog gowayog cayar amam jucwan canquichu’ ninganta, ‘Amam suwacunquichu’ ninganta, ‘Amam manacagta pipitas rimanquichu’ ninganta, ");
INSERT INTO qvnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Taytayta, mamayta alipa ricay’ ninganta, jinaman ‘Runa-mayiquita cuyanqui quiquiquitanuymi’ ninganta”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chaynuy niptin mözuga cay nirunmi: “Wamra cangäpitam lapan ningaytaga cäsucü. ¿Imatatag masta ruräman?” ");
INSERT INTO qvnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chaura Jesusga cay nirunmi: “Alisca alinnin cayta munarga ayway lapan ima-aygaysi ranticug, jinarcur golgueta mana imaynagcunata aypuramuy. Chaynuy rurarurga jana pachachru canqui alinninpag ricasham. Chaypita cutimuy, jinaman nogawan uryashun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chaynuy niptinga chay mözu aywacun alisca laquisham alisca capogniyog car. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chauraga nogacuna discïpuluncunatam Jesusga nipäcaman: “Mayapäcamay shumag: Diospa munayninman yaycuy alisca alisca sasam capogniyogcunapagga. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yapay niyärishay: Aujapa rinrinpa juc ‘camellu’ ningan uywasi ushturunmanmi sasalataga, juc capogniyogmi ichaga alisca sasatarag Diospa munayninman yaycun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Niptin nogacunaga pasay mayacasha niragmi ricacarärï. Jinarcurmi cay ninacarärï: “Chaynuy captinga ¿pirag salvacunga?” ");
INSERT INTO qvnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chay nipäcuptïmi rircärircärimar cay nipäcaman: “Runalaga manam salvacuyta atipanchu, Dioswanmi ichaga ima ruraysi mana sasachüga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chaura Pedroga cay nirunmi: “Tayta, nogacunaga lapan imäcunatas dëjarcurmi purircayä gamwan. ¿Chaura imatatag nogacuna chrasquipäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Niptinmi Jesusga “Mayapäcamay shumag” nipäcaman: “Dios lapan ima-aygatas mushogman muyuchinan junagmi noga jana pachapita shamusha runa mandanäpag cutimushag. Chay mandanäpag alisca shumag trönuman tayurmi gamcunata nipäcushay chrunca ishcayniyog trönuman tacuyur chay chrunca ishcayniyog Israel castaycunata mandapäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nätan pisi noga raygo wayinta u wauguencunata u panincunata u taytanta u mamanta u warminta u wamrancunata u chracrancunatas lapanta dëjagga chrasquinga pachrac cuti mastam imatas, jinamanmi cawanga Dioswan imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nätan achcam alisca alinninpag canan ricashacuna capäcunga manacagpag ricasha. Nätan canan manacagpag achca ricashacunam capäcunaga mas guepamanga alinninpag ricasha”. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Chaura Diospa munayninchru cawayagcunapitam tincuchiypa cay niräriman: “Juc chracrayog runam pacha wararcushala yargorun mincay ashig üvas wiñag chracranchru uryachinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chaypitam chay mincaycunawanga ‘Juc junagchru gänanan golguetam pägashay’ nir rimarcur, chracranman uryag cachrarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chaypitam yapay yargorun goya jamaypag juc üra faltagchru. Jinarcurmi ricapurun pläzachru ishcay quima runacuna mana imatas rurarcayagta. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jinarcurmi paycunataga cay nirun: ‘Gamcunas uryag aywapäcuy chracräman, juc junagchru gänanatam pägapäcushay’. Niptinga uryagmi aywacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chaypitaga yapaytan chraupi junagnuysi, jinaman chay chraupi junagpita quima üra pasashachrüsi yargorun mincay ashig, paycunatas ‘Uryangaypita juc junag gänanatam pägashay’ nircurmi cachrarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chaypitas yapaytan nä jamacurcänanpag juc üra faltayagchru yargorsi tariruntag mana imas rurayag runacunata. Jinarcurmi paycunataga cay nirun: ‘¿Imanirtag gamcunaga caychru carcayanqui ganyas mana imatas ruralar?’ ");
INSERT INTO qvnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Niptinga cay nirärinmi: ‘Manam pisi mincacarcämarachu uryapäcunäpag’. Nipäcuptinga ‘Gamcunas aywapäcuy chracräta uryapäcunaypag’ nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chaura nä pacha chacayaptinmi chay chracrayog runaga ima-aygancunas ricag runanta cay nirun: ‘Gayay chay uryag runacunata, jinaman lapanta pägachraruy juc junagchru gänanata, guepa chrämugcunapita galayur’ nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chaura chay juc ürala uryagcunam chrarärimun, jinarcurmi lapan chrasquirärin juc junagchru gänana golguetacama. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chaura goyalapita uryagcunaga chayta ricarärirga pinsiarärin ‘Nogaga mastachr chrasquishag’ nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nätan paycunas juc junagchru gänanalatacama chrasquirärirga, chay chracrayog runapagmi lutan rimayta galacayärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jinarcurmi cay nirärin: ‘Guepata chrämugcunaga juc üralam uryarärin. ¿Imanirtag paycunata pägarunqui nogacunatanuy? ¡Nogacunaga ganyastag ushacasha uryarärï alisca usyachru!’ nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nipäcuptinmi chracrayogga jucta cay nirun: ‘Taytala, nogaga rimanganchinuymi goyag uryangaypita. ¿Manachu rimaranchi juc junagchru gänana golgueta päganagpag? ");
INSERT INTO qvnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chaura aywacuy nä gampacagta chrasquirayarga. Gamcunatanuy pägayta munarmi, guepa chrämugcunatas pägarü chaynuyta. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Golguewanga nogaga imatas ruracümanmi, u ¿chriquicayämanqui cuyapäcug runa captïchu?’ ");
INSERT INTO qvnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chay nircayangagnuymi canan naupachru carcayagcuna guepata atendisha capäcunga. Nätan canan guepachru carcayagcunam naupata atendisha capäcunga” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chaypitam Jesusga Jerusalenta jegarcayaptï nogacuna discïpuluncunalata jucläman pushayärimar cay niräriman: ");
INSERT INTO qvnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Jerusalentam canan aywayanchi. Chaychrümi noga jana pachapita shamusha runata sacerdöticuna mandagcunapa jinaman Moisés isquirbinganpita yachrachigcunapa maquinman jitayusha cashag. Jinarcurmi chay runacunaga ‘Wanuchisha cachun’ nipäcamanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jinamanmi juc casta runacunapa maquinmansi jitayusha cashag ashlipäcamänanpag, astipäcamänanpag, cruzchru wanuchipäcamänanpag. Nätan quima junagtaga cawacächimusham cashag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chauraga Zebedeopa warminmi ishcay wawantin ashuyurun Jesusman. Jinarcurmi warmiga Jesuspa naupanman gongorpacuyun manacunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chaytam Jesusga cay nir tapurun: “¿Imatatag munayanqui?” Niptinmi warmiga nirun: “Rey canaypag yaycurunnar nilay ishcaynin wawäcunata jucnin derëchaychru, jucnin ichogniquichru tayapäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Niptinmi Jesusga nirun: “Gamcunaga manam musyapäcunquichu imata manacarcayämangaytas. ¿Gamcuna awantapäcunquimanchur noga cunchunätanuy cunchuyta, jinaman noga wanungänuy wanuyta?” Niptinga “Au, awantapäcushagmi” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chaura Jesusga nirunmi: “Au, gamcunasi noga cunchunätanuy cunchupäcunquim. Jinaman noga wanunänuysi wanupäcunquim. Nätan derëchächru jinaman ichognïchru tayapäcunanpag niyga manam nogapa munaynïchrüchu. Tayta Diosmi chaytaga nä camarirayan, jinaman paymi musyayan pïcuna tayachiytas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chaynuy manacurcanganta mayarärirga chruncacag discïpulucunaga piñäcarärïmi chay ishcay wauguecunapag. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chaura lapäta gayarcärimarmi Jesusga cay niräriman: “Gamcuna musyarcayanquim nacioncunachru alisca olgosha mandapäcugta, jinaman chay mandagcuna alisca munayniyog car manchachiypa munanganta imatas rurachipäcugta. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nätan gamcunachrüga manam chaynuychu canga. Gamcunachru munayniyog cayta munagcagga waquinniquicunataran servipäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jinaman maygaysi mandag cayta munagga gamcunataran juc rantisha runanuysi atendipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noga jana pachapita shamusha runasi manam shamusha cä servisha canäpagchu, antis servigmi. Chaynuypa achca runacuna salvasha cananpag wanunäpagmi” niräriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chaypitam nä Jericó marcapita Jesuswan yargorcayaptïga, alisca chranin runacuna gatirayta galacayäriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chaura aywarcayangä camiñucagchrümi ishcay ñaushacuna tayarcayänag. Jinarcurmi nä Jesús pasayagta musyarärirga gayachracarärin cay nir: “¡Munayniyog tayta, Rey Davidpa castan, cuyapayärilämaynar!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nipäcuptinmi runacunaga “¡Upäla capäcuy!” nirärin. Nätan nircayaptinsi paycunaga masmi gayaräcurcan cay nir: “¡Munayniyog tayta, Rey Davidpa castan, cuyapayärilämaynar!” ");
INSERT INTO qvnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nipäcuptin Jesusga shayuyurmi ñaushacunata gayayur tapurun: “¿Imatatag munarcayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Niptin ñaushacunaga “Munayniyog tayta, ricapuytam munarcayä” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chaura Jesusga cuyaparunmi. Jinarcurmi yatayurun ñawincunata. Chauraga chayüram ishcaynincunas ricapuyta galayarärin. Nätan chaypitaga Jesustam gatirapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Chaypitam Jerusalenman nachrgarcayarga, chrarärï Olivos gotucagchru Betfagé marcaman. Chaypitam Jesusga cachrarun ishcay discïpulu-mayicunata ");
INSERT INTO qvnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","cay nir: “Aywapäcuy wac chimpa tacsa marcalata. Chayman chrarärirmi taripäcunqui juc chrina ashnu watarayagta. Chayga cayan wawantinmi. Chayta pasquircur aywachipäcamuy. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chaychru pisi imalatas nipäcushuptiquiga cay nipäcunquim: ‘Munayniyog Jesusmi aywachimuy nircayäman. Mas jaucascalam cutichilämunga’ nipäcunquim”. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chaynuy rurara Diospa unay willacugnin isquirbinganchru cay nisha ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chaychrüga cay niyanmi: “Willapäcamuy Jerusalenchru yachragcunata cay nir: ¡Jay! manshu reyniquim nä aywayämun, püllu ashnulan logasha. Aywayämun maticuna chrina ashnupa wawan logasham” niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chaura chay discïpuluncuna aywarga rurapäcamura Jesús ningannuylam. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chauraga chrarärichimun ashnutaga wawantintam. Jinarcurmi catäcunata suwadïrurärï ashnucunaman. Jinarcurmi Jesusga logacurun püllu ashnuman. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chaypitam chaychru achca runacuna cayagga catancunata camiñuman mashtapäcura. Nätan waquincunam monticunapa rämanta muturcur mashtapäcura aywayangan camiñuman. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chaura Jesuspa naupanta aywagcunawan guepanta aywag runacunam gaparayta galacayärin cay nir: “¡Canangar salvayärimay Rey Davidpa castan! Alisca ali nisha cachun Munayniyog Diosninchi cachramungan. Cananga salvamäshun jana pachachru cayag cachramunganmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nä Jerusalén marcaman yaycaräriptïga lapan runacunam sucsutänacarärin “¿Pitag chay runaga?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nipäcuptinmi waquin runacunaga cay nipäcura: “Payga Diospa willacugnin Jesusmi, Galilea ninganchru Nazaret marcapitam shamunga ninganmi” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chaura Jesuswanga yaycarärï Diospa wayin puncumanmi. Jinarcurmi payga washaman gargochracurun lapan chaychru ranticugcunatawan rantigcunatas. Chaypitam guellay trucagcunapa mësancunata ticpay usharun, chay palömacuna ranticugcunapa tayucurcänantawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jinarcurmi cay nirun: “Dios isquirbichinganchrüga cay ninmi: ‘Wayïga Diospa wayin’ nisham canga. ¡Nätan gamcunaga suwacunapa machrayninmanmi muyurärichinqui!” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jinarcurmi Diospa wayinchru Jesús cayaptin ñaushacunawan ratacuna ashuyarärin payman. Payga nätan lapantam cuticarachin. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jesús chaynuy ruragta ricarärirmi, chaychru wamracunaga gaparayta galacayärin “¡Cananga salvamäshun Rey Davidpa castanmi!” nir. Chay nigta mayarärirmi sacerdöticunapa mandagnincunawan Moisés isquirbinganpita yachrachigcunaga alisca piñäcarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Chauraga Jesustam tapurärin cay nir: “¿Mayayanquichu cay wamracuna nircayanganta?” Nipäcuptinmi Jesusga nirun: “Au, mayayämi. ¿Gamcunaga manachu leyipäcuray Dios isquirbichinganchru cay nishata? Chaychrüga cay ninmi: ‘Acapa wamracunatawan chuchuyagcunatam camarisha canqui alawapäcushunaypag’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nircurmi yargorun runacunapita. Jinarcurmi aywacurcarä Betaniata chay Jerusalenpita yargorga. Chaychrümi gorpachacurcarä. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chaypitam warantin goyaga nä Jerusalenman cutircayaptï, Jesusta micanarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jinarcurmi camiñu lädunchru hïgos montita ricapururga ashuyurun mishquin palag. Jinarcurmi chay montipaga mana mishquin canagchu, antis yüralanmi cayänag. Chaura Jesusga chay montita cay nirunmi: “Cananpitaga manam pasay wayunquichu”. Niruptinga chayüram montiga chaquirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chayta ricarärir discïpuluncunaga mayacasha niragmi ricacarärï. Chauraga Jesustam tapurärï: “¿Imanirtag cay monti pasay-pacha chaquirun?” ");
INSERT INTO qvnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nipäcuptïmi cay nipäcaman: “Shumag mayapäcamay: Dios rurangan nir razonpa yupachicurcaptiquiga, manam cay montiwan rurangänuylatachu rurapäcunqui. Antis ‘Cay jircata caypita ashuy, jinaman gochraman jegayuy nipäcuptiquis’ nipäcungaynuymi ruracanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nätan Diosman razonpa yupachicur manacurcaptiquiga, lapan manacurcangaymi ruracasha canga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chaypitam Diospa wayin puncuman yaycurur Jesús yachrayächiptin, payman ashuyarärin sacerdöticunapa mandagnincunawan chay marcachru alinninpag ricasha chacha olgocuna cay nir: “¿Imanirmi caycunata rurayanqui? ¿Pitag nirushunqui caycunata ruranaypag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nipäcuptinmi Jesusga nirun: “Gamcunatasi juclaylata tapuyärishay. Tapucuynïta nipäcamaptiquiga nogas nipäcushaymi pi nimaptin rurayangätas. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Chauraga ¿pitag Juanta cachramura runacunata bautizänanpag? ¿Dioschu u runacunachu?” Niptinga quiquincamam galacayärin cay ninacuyta “ ‘Diospita’ nishaga, ‘¿Imanirtag chauraga mana cäsucurcaraychu?’ nimäshunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nätan ‘Runacunam cachramusha’ nirushaga, runacunaga wanurachimäshunmi. Paytaga lapan runacunas ricarcayan Diospa willacugninpagmi” ninacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaura Jesustaga cay nirärinmi: “Manam musyapäcüchu”. Niräriptinga Jesuspis cay nirunmi: “Nogasi manam nipäcugchu pi nimaptin rurayangätas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nircurmi Jesusga cay nin: “Juc runam cara ishcay churiyog. Chauraga mayorcagtam nirun: ‘Hiju, canan aywarulaynar uryag üvas chracräta’. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Niptinmi churinga ‘Manam aywashagchu’ nirun. Chaypita nä nisha jananchrümi mas unaylantaga pinsiapacurcur aywacun uryag. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chaypitam runaga jucag churinman ashuyur cay nin: ‘Hiju, canan ayway uryag üvas chracräta’. Niptinmi churinga ‘Äri tayta, aywashagmi’ nircur mana aywashachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chauraga tapuyärishay: ¿Maygantag taytan mandangannuy rurara?” Niptinga “Naupacagmi” nirärinmi. Chaura Jesusga cay nirunmi: “Mayapäcamay shumag: Chay naupacagnuymi yaycurcayan Diospa munayninchru cawapäcunanpag patenti cobrag lutan runacunawan chuchumïcacuna. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Naupata Bautizag Juan shamura ali cawapäcunaypag yachrachipäcushugniquim, nätan gamcunaga ‘Manam Diospitachu shamun payga’ nipäcuraymi. Nätan patenti cobrag lutan runacunawan chuchumïcacunam ichaga ‘Payga Diospitam shamun’ nir wanacarärira jinaman chrasquicarärira. Gamcunaga chayta ricarcayarsi manam juchäcuypita wanacurcaraychu, ni manatan Diospitam shamun nirsi chrasquicurcaraychu. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mayapäcamay caytas: Juc runam cara jatun chracrayog. Chaypitam chay runaga üvasta tarpurun. Jinarcurmi chay chracranta guenchrarun. Chaypitam rurarun üvas gamchicunantawan juc altu törrita chracranta täpananpag. Jinarcurmi üvasninta alpartir ishcay quima runacunata gochracurcur aywacura caru marcata. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chaypitam chracrayogga nä üvas cosëcha wichanga cachrarun ishcay quima rantisha runancunata paypacagta chay alpartir ruragcunapita chrasquipäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chaura nä chraräriptinga chay alpartir ruragcunaga, chay chracrayogpa rantisha runancunata charircurmi juctaga astirärin, juctam wanurärichin, nätan waquintam rumiwan chapirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaura chracrayogga waquin rantisha runancunatam yapay cachrarun naupa cachranganpita mas achcata. Nätan alpartir ruragcunaga naupacagta rurapäcungannuymi lapanta rurarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chaura ushanantaga cachrarun churintam ‘Churïtaga manchacurcangam’ nir pinsiar. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Chauraga chracrayogpa churinta ricaparärirga, chay alpartir ruragcunaga rimanacarärin cay nirmi: ‘Chracrayog wanuptin wac churinmi ima-ayganwansi quëdanga. Antis wanurachishun cay chracra noganchipag cacunanpag’ nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chaura chracrayogpa churintaga charircur jorgarärin chracrapita jucläman. Chaypitam chaychru wanurärichin”. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chay nircurga Jesús tapurun cay nirmi: “Canan gamcuna mä nipäcamay chracrayog runa shamur ¿imatarag ruranga chay alpartir rurag runacunata?” ");
INSERT INTO qvnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chaura runacunaga cay nirärinmi: “Mana cuyapälarchri wanuchinga chay lutan runacunata. Jinarcurchri chay chracranta gorunga juc runacunata paypacagta cosëcha wichan gopäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nipäcuptinmi Jesusga nirun: “¿Gamcuna manachu leyipäcuray Dios isquirbichingancunata? Chaychrüga cay niyanmi: ‘Wayi pergag runacuna “Manam alichu cay juc rumiga” nir jitaripäcunganmi cananga cayan wayipa cimintu esquinanman chruranapag, chay alisca alinnin ruminuy. Caynuy alitaga Dioslam ruran. Jinaman caycuna ricayga alisca cushicuymi cayan noganchipag’ niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chaura cayta mayapäcamay: Chauraga gamcunaga nä manam capäcunqui Diospita yachrachigchu. Cananga Dios munanganta yachrachipäcunga juc casta runacunam. Paycunaga Dios munangaynuymi cawapäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nätan chay alinnin rumiman pisi ishquigga canga pedäzu rurasham. Nätan chay rumi pipa janamansi ishquirga pichruchingam.” ");
INSERT INTO qvnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chaynuy tincuchiypa Jesús yachrachinganta mayarärirga sacerdöticunapa mandagnincunawan fariseocunaga shumagmi tantiarärin paycunapita rimayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaura chay runacunaga Jesús chariruytam munapäcura, nätan mana charipäcurachüga runacunata manchacurmi, runacunaga “Jesusta ricapäcura Diospa willacugninpagmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nircursi Jesusga yapaytan Diospa munayninchru cawayagcunapita tincuchiypa cay niratag: ");
INSERT INTO qvnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Juc reypa olgo churinmi casaränan cara. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jinarcurmi reyga, rantisha runancunata cachrarun, casaracuy fiestaman ‘Shamunquim’ ningan runacunata gayapäcamunanpag. Nätan chay runacunaga manam munapäcushachu aywapäcamuyta. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chaypitaga yapaytan waquin rantisha runancunata cachraruntag chay gayachishacunaman cay nichig: ‘Nämi micuy camarishala cayan. Nämi wirayasha törücunas wäcäcunas pishtashala cayan. Nämi lapansi camarishala cayan. Jucla casamintuman aywapäcalämuy’. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Niyächiptinsi chay gayachishacunaga manam cäsupäcamushachu, antis jucmi aywacun chracranta, jucmi aywacun ranticug. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nätan waquin gayachisha runacunaga chay reypa rantisha runancunatam magarärin wanuchipäcungancama. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chaura reyga alisca piñasham cachrarun soldäduncunata chay wanuchig runacunata wanuchipäcamunanpag, jinaman wayincunatas rupachipäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chaypitam rantisha runancunata nirun: ‘Lapansi nä camarishalam cayan churï casaränanpag. Nätan “Shamunqui” ningä runacunaga manam cäsucug runacunachu capäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cananga aywapäcuy camiñucuna tincugcunaman chaychru lapan purigcunata gayapäcamuy churï casaracuychru capäcunanpag’. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Niptin rantisha runancunaga, camiñucunaman yargarärirga lapan tincungantam fiestaman pusharärimunag, ali runacunatas, lutan runacunatas. Chaynuypam wayiman juntarärichin. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Chaura chay reyga yaycurun fiesta cayag wayimanmi. Chaychrümi juc runata ricapurun casaray fiestachru jatiräna jacu, mana jacucushata. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chaura chay runatam tapurun cay nir: ‘Gamga ¿imanuypatag cayman yaycaramuray mana fiesta jacusha cayarga?’ Niptin runapaga manam ima ninansi yachracarachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chaura reyga chay rantisha runancunatam cay nirun: ‘Cayta chraquinta maquinta uchcurcärir jitayupäcamuy washa yanauyagman. Chaychrümi chay runaga alisca waganga, jinaman quiruntas gapapayla wagarichinga ¿Imanarärag?’ nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chaynuymi carcayan Dioswan cawapäcunanpag achcam gayachishacuna. Nätan acrashacunaga carcayan walcalam” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaura chay fariseo ningancunaga aywacurcanmi. Jinarcurmi gotucarcur rimanacarärinag imanuypas Jesusta lutanta rimarcärichir, “Wactam u caytam rimarun” nir juchachapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chay rimanacarcärirmi cachrarärin paycunapa discïpuluncunatawan Herodespa runancunata Jesusta cay nipäcunanpag: “Yachrachig, nogacuna musyarcayämi razoncag rimag cangayta. Gamga runacunata mana mancharilarmi, razonpacagta yachrayächinqui Dios ningannuy runacuna cawapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mä nipäcamay tantiayniquipita, ¿alichu cayan icha manachu, Romachru munayniyog Cesarta patenti pägay?” ");
INSERT INTO qvnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Niräriptinmi Jesusga lutanpag tapupäcunganta tantiarurga cay nirun: “¡Alitucugcuna! ¿Imanirtag lutan rimachiyta munarcayämanqui? ");
INSERT INTO qvnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä ricachipäcamay patenti pägana golgueta”. Niptinga ricarärichin denariu ningan juc golguetam. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chaura Jesusga cay ninmi: “Cay golguechru ¿pipa cärantag cayan? jinaman ¿pipa jutintag isquirbirayan?” Niptinga “Romachru munayniyog Cesarpam” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Chaura Jesusga cay ninmi: “Cesarpa cagtaga Cesarta gopäcuy. Nätan Diospa cagtaga Diosta gopäcuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesús ninganta mayarärirga mayacasha niragmi ricacarärin. Chauraga dëjarcurmi aywacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay junaglam saduceo ningancunas chrarärimun Jesusta tapupäcunanpag. Paycunaga “Manam wanushapita cawacämuy canchu” nipäcunmi. Chauraga tapurärin cay nirmi: ");
INSERT INTO qvnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yachrachig, Moisés isquirbingancunachru cay ninmi: ‘Juc casarasha olgo, warminchru mana churin captilan wanuruptinga, viüdawan shulca wauguenmi casaranga. Chaypa churin, difuntu wauguenpa jutinta apananpag’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chaura nogacuna yachrarcayangäcagchrümi cara ganchris wauguecuna. Jinarcurmi mayorcag casararun. Chaypitam manarag churin captilan wanurun. Chaura viüdanwanmi shulca wauguenga casararun. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jinarcurmi paysi wanurun, jinaman chaynuylam mas guepacag wauguencunawansi pasarun. Chaynuypam ganchrisnintin wanurärin mana churiynagla. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jina guepantaga warmis wanuruntan. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chaura chay warmi ganchrisnintinwan casararayaptinga, ¿mayganparag warmin canga, wanushacuna cawacämunan junagga?” ");
INSERT INTO qvnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nipäcuptinmi Jesusga nirun: “Lutantam rimarcayanqui. Gamcunaga Dios isquirbichinganta manam tantiapäcunquichu. Manatan tantiapäcunquichu Dios munayniyog cangantas. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nä wanushacuna cawacaramuptinga manam nä warmisi ni olgosi casarapäcungachu, antis capäcunga jana pachachru angelcunanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chay wanushacuna cawacämunanpita ¿manachu gamcunaga leyisha capäcunqui? Diosga wanushacuna cawacämunanpita caynuymi nin: ");
INSERT INTO qvnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nogaga cayä unay Abrahampa, Isaacpa, Jacobpa Diosninmi’. Paycunaga wanusha cayarsi cawarcayanmi, niram. Chaura Diosga manam wanushacunapa Diosninchu, antis cawayagcunapa Diosninmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chaynuy nigta mayarärir, runacunaga mayacasham quëdarärin, Jesús chaynuy yachrachiptin. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chaura chay saduceocuna upälächinganta musyarärirmi, fariseocunaga gotucarärin. Jinarcurmi paycunapita jucga alisca yachrara Moisés isquirbinganpita. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Paymi Jesusta juchäcachiyta munar tapurun cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yachrachig, Dios lapan mandamanganchicunapita, ¿maygantatag mas cäsucuchwan, Moisés isquirbinganchru cayagta?” ");
INSERT INTO qvnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Niptinmi Jesusga nirun: “ ‘Munayniyog Diosta cuyay lapan shongoypa. Chaynuy cuyarga alila ruraytam munanquis, jinaman paylamanmi yarparanquis’ nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chaymi cayan lapanpitas mas naupata cäsucunapag. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nätan guepancagsi cayan chaynuy niragmi: ‘Runa-mayiquita cuyay quiquiquita cuyacungaynuy’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chay ishcayninta cäsucurga rurayanqui lapantam, Moisés isquirbingantas, jinaman Diospa willacugnincuna isquirbingantas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nircurga chaychru goturarcayag fariseocunatam Jesusga tapurun: ");
INSERT INTO qvnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gamcunaga ¿ima nipäcunquitag salvacugpita? ¿Pipa castanpitatag payga shamunan cara?” Niptinga “Rey Davidpa castanpitam” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chay nipäcuptin Jesusga cay nirunmi: “Chaura Rey Davidga ¿imanirtag Santu Espíritu rimachiptin gayara ‘Munayniyognï’ nir, castalan cayaptinga? Rey Davidga cay niram: ");
INSERT INTO qvnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Munayniyog Diosnïmi nirun munayniyog salvamagnïta: “Cay derëcha lädüman tayucuy chregnishugniquicunata naupayman chruramungäcama” niram’. ");
INSERT INTO qvnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chaura Rey Davidsi ‘Munayniyognï’ niyaptinga, nätan ¿Salvacugga canman paypa castanchur?” ");
INSERT INTO qvnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niptinga manam pisi ima niytas atiparachu. Nätan chay junagpita-pacham lapansi manchacurcara Jesús tapupayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaura chaychru goturarcayag runacunatawan discïpuluncunatam Jesusga cay niräriman: ");
INSERT INTO qvnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés isquirbinganpita yachrachigcunawan fariseocunaga carcayan yachrachipäcushunaypagmi Moisesnuysi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chauraga Moisés isquirbingannuyla yachrachipäcushuptiquiga cäsucurcay jinaman rurapäcuy lapanta. Paycunanuy icha ama cawapäcuychüga. Paycunaga manam yachrachipäcungannuychu cawapäcun. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paycunaga runacunapa mandashalantam Diospa mandashantanuy rurarcayächin mana pisi rurayta atipayaptin. Chay mandashacuna cayan juc lasag guepi sasa aywachinanuymi. Nätan quiquincunaga manam maygalantas rurayta almitipäcunchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Antis ima-aygatas paycunaga rurapäcun runacunapita alipag ricasha capäcunalanpagmi. Chaypitas Diospa mandashancuna apacurcänan ichic cäjalatas mas jatunta ruracarcärirmi chruracurcan urcuncunamansi ricrancunamansi jinaman jacuncunapa burlasnincunatas mas uracamam chruracurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Paycunaga munapäcun ima micapäcuycunachrüsi alinnin tayucunachru tayuytaran, nätan Israel castacuna gotucarcänan wayichrüsi munapäcun naupa naupachru alinnin tayucunaman tayucuytaran. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pläzachru puripäcursi munapäcun runacuna manchapacuypa saludapäcunantam, jinaman ‘Yachrachigpa’ gayapäcunantam. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nätan gamcunapagga ama shongoycuna munachunchu yachrachigparag gayapäcushunayta, antis gamcunaga lapaysi carcayanqui chay wauguelam. Yachrachishugniquicunaga cayan juclaylam. Payga cayan ‘Salvacugtam cachramushag’ Dios ningalanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cay pachachru gamcunaga amam Tayta Diostanuy ricapäcunquichu pitas. Tayta Diosniquicunaga juclaylam. Payga cayan jana pachachrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Amatan shongoycuna munanganchu mandagpa gayapäcushunaytas. Diospa acrashalanmi cayan mandagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pi maysi gamcunachru mandagga gamcunata atendipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nätan pi maysi alinninpag ricachicugga manacagpag ricasham canga. Nätan pi maysi manacagpag ricachicugga alinninpag ricasham canga” niräriman. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Chaypitam chay mana cäsucugcunata cay nin: “¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcuna jinaman fariseocuna! ¡Gamcunaga carcayanqui alitucuglam! Juc wayiman mana pisi yaycunanpag llävi charicuyugnuymi gamcunaga mana munapäcunquichu Diospa munayninman runacuna yaycapäcunanta. Gamcunaga manam quiquiquicunas yaycuyta munapäcunquichu, ni manatan yaycuy munayagcunatas yaycachipäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcunawan fariseocuna! Gamcunaga carcayanqui alitucuglam. Gamcunaga viüdacunapa imalam cagtas guechrurcayanquim. Chaypitaga ali ruragpag ricasha capäcunay raygom alisca unay Dioswan rimag tucurcayanqui. Chaynuy rurapäcungaypita mas juyupa cunchuchisham capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcunawan fariseocuna! Gamcunaga carcayanqui alitucuglam. Jatun gochrapawan pampacunapa purichignuysi gamcunaga imatam mana yachrarcayächinquichu runata Diosta mana cäsucug gamcunanuysi cananpag. Nä munapäcungaynuyman muyurärichirga chay runata rurarärinqui gamcunapitaga ishcay maspa nina wayichru cunchuchisha cananpagmi. Gamcunaga jatun gochrapas pampapas aywarcayanquim runata Israel castaman muyuchipäcunaypag. Nä muyurcachirga chay runata jorgorcayanqui gamcunapitas ishcaypaypa mas lutanmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Aliscam cunchupäcunqui gamcunaga! Chaura gamcunaga ñaushanuysi mana imatas tantiarmi runacunata yachrarcayächinqui cay nir: ‘Rurashagmi’ nir, Diospa wayinta janchrarcur juracugga mana rurarsi manam lutantachu ruran. Nätan pisi ‘Rurashagmi’ nir, ‘Diospa wayinchru cayag örucunata janchrarcur juracugmi ichaga lutanta rurayan’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Gamcuna carcayanqui gotaracamam, jinaman ñaushanuymi! ¿Gamcunapitaga öruchu u Diospa wayinchu mas välig? Antis öruga ‘Cayga Diospag nisha carmi’, jinaman Diospa wayinchru carmi välin. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gamcuna yachrarcayächinquim caynuypas: Pisi ‘Rurashagmi’ nir altarta janchrarcur juracugga mana rurarsi manam lutantachu rurarun. Nätan pisi ‘Rurashagmi’ nir, ‘Altarchru ofrendata janchrarcur juracugmi ichaga juchäcun’ nirsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Gamcuna carcayanqui ñaushanuymi mana tantiagcama runa! ¿Gamcunapitaga altarchu u altarman ‘Diospag’ nir chrurashachu mas välig? Antis imasi väliyanga altarchru carmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chaura pisi altarta janchrarcur juracugga janchrarcuyan lapan chrurarayagnintawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nätan pisi ‘Rimangannuy razonpam rurashag’ nir Diospa wayinta janchrarcur juracugga manam Diospa wayilantachu janchrarcun, antis Dios chaychru cayagtawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nätan pi maysi jana pachata janchrarcur juracugga janchrarcuyan Diospa tayacunantam jinamanmi tayagnintas. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcunawan fariseocuna! ¡Gamcuna alitucuglam carcayanqui! Gamcunaga chruncapita juctam mentata anista jinaman cominosta Diospag jorgorcayanqui. Antis Moisés isquirbinganchru ‘Alitam rurapäcunqui, runatam cuyapapäcunqui, jinaman Dioslamanmi yupachicurcanqui’ ningantam rurapäcunquiman caraga chay waquin rurarcayangaycunatawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ñaushanuysi mana tantiagcama runa! Gamcunaga chuspinuysi cayag ichic mandashacunalatam imanaypanuysi cäsucurcayanqui, nätan camellu uywanuysi jatun mandashacunataga manam cäsucuyta munapäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcunawan fariseocuna! ¡Gamcuna carcayanqui alitucuglam! Gamcunaga carcayanqui väsupa plätupa janalan maylashanuymi, nätan chay väsupa plätupa ruyin mana maylashanuymi carcayanqui imatas suwacurcayangaywanga, jinaman ima-aygas lutan rurarcayangaywanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ñaushanuysi mana tantiagcama fariseocuna! Naupataga väsupa plätupa ruyin maylagnuysi jucha ruraypita wanacurcay. Chauraga capäcunqui alim jananpas. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcunawan fariseocuna! ¡Gamcuna carcayanqui alitucuglam! Gamcuna carcayanqui runa enterrashapa janan yuragwan ali shumag pintapashanuymi, nätan chay runa enterrasha ruyichrüchu tullucuna cayan mana pasay ali. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chaynuymi gamcunasi runa ricanalanpagga carcayanqui ali rurag nirag. Nätan manam razonpa alichu capäcunqui chay ima-aygas lutan rurapäcungaywan. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Alisca cunchuchisham capäcunqui, Moisés isquirbinganpita yachrachigcunawan fariseocuna! ¡Gamcuna carcayanqui alitucuglam! Gamcunaga Diospa willacugnincunapa mïchunta sharcarcayächinquim, jinaman ali ruragcunapa enterrashantas shumagyarcayächinquitan. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chayta rurarga cay nircayanquim: ‘Noganchi awillunchicuna cawanan wichan cawarga manachr yanapachwanchu cara Diospa willacugnincuna wanuchiyta’. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nipäcurniqui quiquiquicunam musyachicurcayanqui Diospa willacugnincuna wanuchigcunanuysi mana cäsucug casta capäcungayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chauraga unay awilluycuna ruray galayapäcungantar ushapapäcuy pasay-pacha. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Gamcuna carcayanqui acapa casta juyu culebracunanuymi alisca juyucama! ¿Imanuyparag gueshpipäcunqui nina wayichru Dios cunchuchipäcushunaypita? ");
INSERT INTO qvnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chaura chayman mana aywapäcunaypagmi nogaga cachramushag Diospa willacugnincunata, tantiaysapa runacunata, jinaman yachrachigcunata. Nätan gamcunaga paycunatam waquinta wanuchipäcunqui, waquintam cruzman clävapäcunqui, waquintam Israel castacunapa gotucarcänan wayincunachru alisca magapäcunqui. Jinaman waquintam marcan marcan ashipäcunqui cunchuchipäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chaynuy rurapäcungaypita alisca cunchuchisham capäcunqui. Gamcunaga cunchupäcunqui lapan ali rurag runacuna wanuchipäcunganpitam, chay ali rurag Abelpita galayur Berequiaspa churin Zacariasta wanuchipäcungaycamam. Payta wanuchipäcuray inciensuta Diospag rupachicunacagchru jinaman washa altarwan tincucugchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mayapäcamay shumag: Lapan caycuna rurangaypita cunchupäcunquim gamcunaga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nircurmi cay nirun: “¡Jerusalenchru yachrag runacuna, gamcuna Diospa willacugnincunata wanurcayächinquim, jinaman Dios cachramungancunata rumiwanmi chapircayanqui! Gamcunata maymay cutichr gotuyta munapäcurag, juc walpa chiucancunata rapran ruyiman gotugnuysi, nätan manam munapäcuraychu. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cananga yachrarcayangay wayiquicuna chunyagmanmi muyunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nätan cananga manam mastaga ricapapäcamanquipishchu ‘Alisca ali nisha cachun Munayniyog Diosninchi cachramungan’ nipäcamänaycama” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chaura Diospa wayin puncupita nä aywacunanpag Jesús yargoyaptinmi discïpuluncunaga ashuyärï Jesusman “¡Diospa wayinta! ¡Imanuy jatun, jinaman ima-ayga shumag sharcachisha canganta rircärichipäcunäpag!” ");
INSERT INTO qvnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jinarcurmi Jesusga nipäcaman: “¿Ricarcanquichu lapan caycunata? Shumag mayapäcamay: Manam juc rumilas juc rumiwan chrurcanacushaga quëdangachu. Lapanmi canga juchruchisha” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chaypitam Olivos ningan gotuman chrarur Jesús tayayaptin tapurärï cay nir: “Willapäcamay chay nircayämangayga. ¿Imaytag ruracanga? ¿Imanuypatag cay pachaman cutimunayta, jinaman cay pacha ushanan junag nachrgayämunganta musyapäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nipäcuptïmi Jesusga nipäcaman: “¡Mayag mayagmi capäcunqui! Pisi casquita alita nirag nipäcushuptiquitag ‘Razonchri’ nirärinquiman. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aywapäcamunga achcam ‘Nogam Cristo cayä’ nir casquicuyar. Chay casqui rimapäcunganta achca achca runacunam ‘Razonchri’ nipäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jinaman mayapäcunquim ‘Guërram cayan’ nigta u ‘Guërrash canga’ nigtas. Nätan gamcunaga amam manchacapäcunquichu. Chaynuymi ruracänan cayan, nätan manaran cay pacha ushanan junagragchüga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chaypitas juc nacionchru runacuna juclä nación runacunawan guërrata rurapäcungam. Chaynuytan juc reysi runacunawan guërrata ruranga juc reyta runantinta. Chaypita canga micuy wanaymi tucuy gueshyacunam jinaman pacha cuyuycunam maychrüsi chaychrüsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lapan chaycuna canga alisca cunchuycunapa galayunalanran, pachrayog warmita pachran nanapagnuysi. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nätan lapan runacunapitam chregnipasha capäcunqui nogapa janä. Chaypita mandagcunapa maquinmanmi chrächipäcushunqui tucuynaypa cunchuchipäcushunaypag jinamanga wanuchipäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chay wichan waquinga Diosman yupachicugcuna achcam nä mana yupachicurcangachu. Chaypitam jucninsi jucninsi chregninacurcanga, jinamanmi jucninsi jucninsi wanuyman jitayunacurcanga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chaypita achcam casqui rimag runacuna aywamunga ‘Diospa willacugninmi cayä’ nircayar. Chay nipäcur achca runacunatam pantacächipäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chaypitaga alisca alisca jucha rurayla captinmi, achca runacuna nä mana cuyacugman muyupäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nätan pi maysi wanungancama chaynuyla Diosta servigmi ichaga salvasha canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nätan Diospa munayninchru cawaypita ali willapam maychru chaychrüsi willapacanga lapan runacuna musyapäcunanpag. Chayran ushanan junagga chrämunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","¡Chauraga Diospa willacugnin Daniel isquirbinganta leyigcagga pisi shumag tantiachun! Payga ‘Chay Diospa wayinchru inciensuta rupachicunacagchru alisca lutan jucha ruracagtam ricapäcunqui’ niram. (Chaura chay isquirbishata leyigcagga tantiapäcuy.) ");
INSERT INTO qvnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chauraga Judeachru yachrayagcuna gueshpicurcächun jircacunaman. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nätan wayin jananchru cayagsi ama wayinman imalansi jorgog yaycuchunchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chaynuytag imaman aywasha carsi ama wayinta cutichunchu ni catan apaglas. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ay, chay wichan imanapäcungarag chrichru warmicuna jinaman wawan chuchuyagcuna! ");
INSERT INTO qvnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chauraga Diosta manacurcay chay gueshpinay junag tamya wichanchru u jamana junagchru mana cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chauraga alisca juyu cunchuymi canga. Chaynuyga manam carachu cay pacha camanganpita-pachasi, ni manatan mas guepamansi cangapishchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nätan chay cunchuna wichan mana wayrala pasaptinga manachr pisi salvasha canmanchu. Nätan chay cunchuna wichan wayrala pasanga acrashancuna raygom. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chauraga pisi ‘Caychrümi Cristo cayan’ u ‘Wacchrümi cayan’ nishuptiqui ‘Amam razonchri’ nipäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aywapäcamungam ‘Cristotucugcunawan’, ‘Diospa willacugnintucugcuna’, casquicurcayar. Alisca aliscam chaycuna ima-aygatas rurapäcunga runala mana ruray atipänancunata. Chauraga Diospa acrangancunata ichiclapitam mana pantacächipäcungachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nämi nirärig chay ima-aygas pasanancunapita. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chaymi ‘¡Wac jäpagchrümi Cristo cayan!’ nipäcushuptiquis, ama aywapäcuychu, u ‘¡Wac wayichrümi cayan!’ nipäcushuptiquis, ama ‘Razonchri’ nipäcuychu. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Noga jana pachapita shamusha runaga aywamushag inti yargamunanpita inti ishquinancama juc lipa achicyagnuysi runacunapita ricapusham. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maychrüsi wanushacagmanchu condurcuna gotucapäcun runa ricay, chaynuymi cutimushag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Chay cunchuy junagcuna pasaruptilanmi, inti yanauyagman muyunga, quillas manam nä achicyangachu, nätan goyllarcunam ishquipäcamunga, jinaman jana pachachru ima-aygas cayagcunam limpu cuyuringa. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaura noga jana pachapita shamusha runa cay pachaman aywayämugta musyapäcunanpag ricacämushag jana pachachrümi. Nä ricaparärimarga lapanmi cay pachachru runacuna wagapäcunga. Jinamanmi ricapapäcamanga pucutay jananchru alisca munayniyog, jinaman alisca shumag liplipyayar aywayämugta. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chauraga cachramushag jana pachachru angelnïcunatam cay pachachru lapan acrashäcunata gotupäcamunanpag. Chay rimangä mayacanga juc trompëta wagarignuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hïgos montipita yachracurcay. Chay montipa rämancuna llullumuptin jinaman yürancuna chicchimuptin, gamcuna musyarcayanqui nä usya wichan nachrgayämungantam. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chaynuymar chay niyangäcuna ruracagta ricapäcursi tantiapäcunqui, nä ushanan junag pasay nachrgarayämunganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Shumag mayapäcamay: Lapan caycuna ruracanga, gamcuna manaragsi wanupäcuptilaymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jana pacha ricapurcayangaysi, jinaman cay pachas ushacaglam cayan, nätan cay rimayangäcunam ichaga ruracangarag. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nätan ima junagchru u imayüra aywamunäpitaga manam pisi musyanchu, ni jana pachachru angelcunas ni nogasi. Musyayanga Tayta Dioslam. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Chauraga Noé jutiyog runa cawanan wichanchu mayänipita löcu tamyayta galacuyura, chaynuymi noga jana pachapita shamusha runasi cutimushag mayänita. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chaypin wichan runacuna cawapäcura micucularmi upyacularmi casaracurcayälarmi jinaman warmi churincunatas casararcayächilarmi, Noé büquiman yaycungan junagcama. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nätan paycuna manam tantiapäcushachu chay löcu tamyamungancama. Jinarcurmi lapan wanurärira yacuwan. Chaynuy mayänipitam noga jana pachapita shamusha runasi aywamushag. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chay aywamunä junagga ishcay runacunam chracrachru uryarcayanga. Jucnin camacushacagmi apasha canga, nätan jucnin mana camacushacagmi dëjasha canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chaynuytan ishcay warmicunas agacurcayanga. Jucnin camacushacagmi apasha canga. Nätan jucnin mana camacushacagmi dëjasha canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","¡Chauragar cacurcayay camacushala! Noga munayniyogniquicuna imayüra shamunätas mana musyarcayarga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","¡Cayta niyärishay tantiapäcunaypag! Juc wayiyog runa imayüra suwa chrämunantas musyarga mayag mayaglachr canman, nätan manachr wayinman togorcur yaycunanta cunsindinmanchu. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","¡Chaura gamcunas camacushala cacurcayay! Noga jana pachapita shamusha runaga aywamushag mana pinsiashachrümi”. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Chauraga maygaycunatag carcayanqui juc yarpaysapa jinaman yupachicuna rantisha runanuy? Chay runatam rantigninga chrurarayan wayinchru lapan cayagcunata üralachru micuyta garananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chaura chay rantignin runa chraramur ningannuyla rurayagta tariruptinga, chay rantisha runaga aliscam cushicunga. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mayapäcamay shumag: Chauraga rantigninga chay runanta chruranga wayinchru lapan imancagtas ricananpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nätan chay rantisha runa lutan rurag car shongonchru cay ninman: ‘Rantimagnï manaran cutimunmanragchu’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Galayunman rantisha-mayincuna magayta, jinaman micucular upyacular cacunman shincagcunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chauraga chay rantignin runa cutimunga mana shuyayangan junagmi jinaman mana musyangan üram. ");
INSERT INTO qvnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chaura chaynuy rurayagta tarirurga, rantigninga aliscam cunchuchinga. Payta jitayurunga alitucugcunacagmanmi cunchunanpag. Chaychrümi alisca waganga, jinaman quiruncunatam gapapayla wagarichinga laquicuypita. Chaynuymi noga cutimur rurashag runacunawan”. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Cananga tantiachipäcushay Diospa munayninchru cawagcunaman cutimuptï pasananpita chrunca jipashcunawan. Chay jipashcunam aceitiwan rupag michïruncunata achquicurcur aywarärin casarag mözu chrasquicug. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pichgacagmi capäcusha gotaracama, nätan waquin pichgacagmi capäcusha yarpaysapacama. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay gotaracagcunaga michïrunta aparcayarmi mana mas aceitita apapäcushachu michïrunman yapapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nätan yarpaysapacagcunam ichaga aceititaga apapäcusha michïruncunachrüsi jinaman juc botëllancunachrüsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chaura casarag mözu mana jucla chrämuptinga, shuyararcayaglatam pununay charirärin jinamanmi lapan punucarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chauraga chraupi pagasmi mayacaramun ‘Nämi casarag mözu yaycayämun. Yargapäcamuy chrasquicug’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Niptinga lapanmi jipashcunaga sharcarärin. Jinarcurmi michïruncunata camarirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chaypitam chay pichga gotaracunaga chay yarpaysapa jipashcunata manacarärin ‘Aceitiquicunatanar goyärimay ichiclatas. Michïrücunam upinayan’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nipäcuptinmi chay pichga yarpaysapacunaga ‘Manam gopäcugmanchu. Raquiparäriptïga manam aypangachu nogacunapagsi ni gamcunapagsi, antis aywapäcuy rantig chay ranticugcunaman’ nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Chaura chay pichga aceiti rantig aywapäcungancamam casarag mözuga chraramun. Chauraga chay shuyararcayag pichga jipashcunalam yaycarärin casamintumanga chay casaracug mözuwan. Jinarcurmi puncu wichrgacarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chaypitaran chrarärimun chay waquin pichga jipashcunaga cay nircayar: ‘¡Tayta! ¡Tayta! ¡Puncutanar quichrayulay!’ ");
INSERT INTO qvnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nipäcuptinmi casarag mözuga cay niramun: ‘Mayapäcamay shumag: Gamcunataga manam reguepäcugchu’ ” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nircurmi Jesusga nipäcaman: “Chaynuytag pasarärishunquiman gamcunatas, cacurcayay camaricushala. Manam musyapäcunquichu ima junagchru ni imayüra cutimunätas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Chaura Diospa munayninchru cawagcunawan pasanga caynuymi” nirmi willaräriman juc runapita cay nir: “Juc runam caru marcata aywacur rantisha runancunata gayarcur golguenta mirachipäcunanpag dëjaparura. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Chauraga juc rantisha runantam goyurun pichga talentu ningan golgueta, juctam ishcay talentu ninganta, nätan juctam juc talentu ninganta. Chaynuypam lapantas aypuchracurura imanuypa golgue mirachicuy yachrapäcungantas nä musyar. Chaypitam aypuchracurcurga aywacura caruta. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jinarcurmi pichga talentu ningan golgueta chrasquig runaga chay golguewan imas rantiyta jinaman ranticuyta galacuyun. Chaynuypam mirarachin juc pichga talentu masta. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ishcay talentu chrasquishasi chaynuytan ruraratag chay golguewan. Paysi mirachisha ishcay talentu mastam. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nätan juc talentu chrasquigmi icha aywarcur chay golgue chrasquinganta pacaramunag pampata uchrcuyur. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chaypitaga alisca unaytaran chay golgueyog runaga cutiramun chay rantisha runancunaman. Chaypitam gayarun aygatacama mirachisha capäcungantas nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chauraga chrarun chay pichga talentu golgue chrasquisha runam. Jinarcurmi golguenta goyurun juc pichga talentu masnintawan cay nir: ‘Tayta, gomaray pichga talentutam, nätan cay pichgacagga cayan mirayninmi, catay golguequi’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Niptinmi golgueyog runaga cay nin: ‘¡Ali servignïmi casha canqui jinaman ningänuy ruragmi! Walcalawansi ningänuy rurag cangaypitam mas achcata goshayqui yupachicuna runa captiqui. ¡Yaycamuy wayïman mirachingaypita cushisha micapäcunanchipag!’ nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chaypitaga chrarun ishcay talentu chrasquisha runatan cay nir: ‘Tayta, gomaray ishcay talentutam, nätan cay ishcayga cayan mirachingämi’ nirmi lapanta gorun. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Niptinmi golgueyog runaga nirun: ‘¡Ali servignïmi gamga casha canqui jinaman ningänuy ruragmi! Walcalawansi ningänuy rurag cangaypitam mas achcata goshayqui yupachicuna runa captiqui. ¡Yaycamuy wayïman mirachingaypita micapäcunanchipag!’ nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nätan juc talentu chrasquisha runam icha chrarurga cay nin: ‘Tayta, juyu runa cangayta musyarmi, mana mururungaypita cosechag cangayta musyarmi, jinaman mana wichingaypita palag cangayta musyarmi, ");
INSERT INTO qvnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","gamta manchacur golguequita pacaramurä pampa ruyiman. Cä cayan golguequi pachalan’. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Niptinmi golgueyog runaga cay nin: ‘Gamga guellatag jinaman munangalay ruragtag cacunayqui. Chaura mana tarpungäpitas cosechag cayaptïga, jinaman mana wichingäpitas palag cayaptïga, ");
INSERT INTO qvnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","golguëta bancumanchri chruranquiman cara, nä cutimur golguëta miraynintinwan jorgonäpag’. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nircurmi chaychru cayagcunata cay nin: ‘Cay runata guechrupäcuy golguëta. Chaypita chay golgueta gopäcuy chrunca talentu charayagcagta’ nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chaura pitas maytas ningänuy ruragcagtaga Diosga ricanga alisca alinninpagmi. Nätan ningänuy mana ruragcagtaga alipag ricasha cayanganpitas manacagpag ricasham canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nätan cay mana välig rantisha runata jitayapäcamuy washa yanauyagman. Chaychrümi waganga, jinaman quirunta gapapayla wagarichinga laquicuypita. Chaynuymi noga nä cutimunä junag pasanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Chaura noga jana pachapita shamusha runa cutimurga, aywamushag alisca shumag achicyayarmi jinaman lapan angelnïcunawanmi, jinarcurmi tayucushag alisca shumag trönuman. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chaypitam naupäman lapan nacionpita runacuna gotupäcamunga. Chay runacunatam nogaga cabracunapita uyshacunata juc michig raquignuysi raquichracushag. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uyshanuysi cagcunatam derëchäcagman raquishag, nätan cabranuysi cagcunatam ichognïcagman. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chaypitam noga reyga nishag chay derëchächru cagcunata: ‘Shapäcamuy Tayta Diospita yanapashacuna, jinaman cawapäcuy wac mandayangäcagchru. Chayga camarirayan cay pachata camacanganpita-pacham gamcunapag. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gamcunaga micanasha cayaptïsi micuyta gopäcamaraymi. Yacunasha cayaptïsi yacutas gopäcamaraymi. Mana pipita reguesha puriyaptïsi wayiquiman gorpachapäcamaraymi. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mana jacuynag cayaptïsi jacuta gopäcamaraymi. Gueshyaptïsi jampipäcamaraymi. Carcelchru wichrgaraptïsi aywapäcamuraymi ricamagnï’. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Niptï chay alita ruragcunaga cay nipäcamangam: ‘Munayniyog tayta, ¿imaytag micanashata ricar garacurcarag? ¿Imaytag yacunashata ricar yacuta gopäcurag? ");
INSERT INTO qvnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Imaytag mana reguesha purigta ricar wayïcunaman gorpachapäcurag? ¿Imaytag mana jacuynag cayaptiqui jacuta gopäcurag? ");
INSERT INTO qvnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Imaytag gueshyaptiqui u carcelchru wichrgarayaptiqui aywapäcamurä ricagniqui?’ ");
INSERT INTO qvnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nipäcamaptin noga reyga cay nishagmi: ‘Mayapäcamay shumag: Cay runäcunapita maygan manacaglatas chaynuy rurapäcurniqui nogatam atendipäcamaray’ nishagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chaypitaga chay ichognïcagchru cayagcunatas cay nishagmi: ‘Sumagla ashucurcay nogapita Diospita lutanpag ricashacuna. Gamcuna aywapäcuy nina wayiman. Chayga cayan Asyagpag jinaman angelnincunapag camarisham. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gamcunaga micanasha cayaptïsi manam micuyta gopäcamaraychu, yacunasha cayaptïsi manam yacutas gopäcamaraychu, ");
INSERT INTO qvnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mana pipita reguesha puriyaptïsi manam gorpachapäcamaraychu, mana jacuynag cayaptïsi manam jacutas gopäcamaraychu, gueshyayaptïsi jinaman carcelchru wichrgarayaptïsi manam aywapäcamuraychu ricamagnï’. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Niptïmi chay runacunasi cay nipäcamanga: ‘Munayniyog tayta, ¿imaytag micanashata, yacunashata, mana reguesha puriyagta, mana jacushata, gueshyayagta, carcelchru wichrgarayagta ricapur mana atendipäcuragchu?’ ");
INSERT INTO qvnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nipäcamaptin cay nishagmi: ‘Mayapäcamay shumag: Cay runäcunapita maygalantas mana chaynuy yanapapäcur nogatam mana atendipäcamaraychu’ nishagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chaura chay lutan ruragpag ricashacunam imaycamas cunchuchisha capäcunga. Nätan ali ruragpag ricashacunam Dioswan imaycamas cawapäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chaypitam lapan caycunata nircurga, Jesusga discïpuluncunata cay nipäcaman: ");
INSERT INTO qvnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gamcuna musyarcayangaynuysi cananpita ishcay junaglatam canga Pascua fiesta. Nätan noga jana pachapita shamusha runam chregnimagnïcunapa maquinman jitayusha cashag. Chaycunam cruzman clävapäcamanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chauraga chay junagcunam sacerdöticunapa mandagnincuna jinaman alinninpag ricasha chacha runacuna gotucarärinag Caifás jutiyog runapa wayin puncuchru. Payga cara sacerdöticunapa mandagninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chaychrümi shumag rimanacarärinag yangapita juchacharcur Jesusta charipäcunanpag jinaman wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Chauraga ninacarärinag cay nirmi: “Ama rurashunchu cay fiesta wichanga cay achca runacuna goturarcayag mana imatas ruramänanchipag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Chaura Jesús cayara Betania marcachrümi leprösu nipäcungan Simonpa wayinchru nogacuna discïpuluncunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chaychrümi juc warmiga Jesusman ashuyurun, yurag rumipita rurasha botëllachru perfümim apasha. Chayga cara alisca chranin golguewan rantinam. Chaytam Jesús mësachru cayaptin umanman jirpurun. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chaura discïpuluncunaga chayta ricarärirga piñäcarärï cay nirmi: “¡Yangam cay perfümitaga pampanman rurarun! ");
INSERT INTO qvnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Antis alim canman cara alisca chranin golguechru ranticurusha mana imaynagcunata yanapänapag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nircayangäta Jesús mayarurga cay nirärimanmi: “Cay warmipag lutantam rimarcayanqui. Cay perfümi jirpamanganwanga alitam rurarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mana imaynagcunaga chaynuylam gamcunawan carcayanga. Nätan nogaga manam alä unaychu gamcunawan cashag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cay warmi perfümita cuerpüman jirpamanganwanga camariyäman mïchuchru enterrasha canäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mayapäcamay shumag: Maychru chaychrüsi cay pachachru ali willapa willapacurcangancagchrümi cay warmi ruranganpitas willapacurcanga ali ruranganpita yarpasha cananpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chauraga chrunca ishcayniyog discïpulu-mayïcunapitam jucga aywarunag sacerdöticunapa mandagnincunaman. Chay aywagpa jutin cara Judas Iscariotem. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nä chrarurmi cay nirunag: “¿Aygatatag golgueta gopäcamanquiman Jesusta reguechipäcuptïga?” Niptinmi paycunaga gorärira quima chrunca golgueta. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chayürapitam Judasga munara imalas cananta Jesusta reguechinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chauraga mana levaduränag tanta micuna fiesta galarinan junagmi discïpuluncunaga ashuyarärï Jesusman cay nir: “¿Maychrütag camaripäcamushag Pascua micuyta micunanchipag?” ");
INSERT INTO qvnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nipäcuptïmi payga cay nipäcaman: “Aywapäcuy marcata. Juc runapa wayinman chrarurmi cay nipäcunqui: ‘Yachrachigmi cay nin: Nämi nachrgayämun ürä wayiquichrümi Pascua micuyta micushag discïpulücunawan’ nipäcunquim” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chaura Jesús ningannuylam aywapäcurä, jinamanmi camarirärï Pascua micuyta micapäcunäpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nä pacha chacarpuruptinga mësacagmanmi Jesusga iscatarayara nogacuna chrunca ishcayniyog discïpuluncunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nä micurcayaptïmi Jesusga cay nipäcaman: “Mayapäcamay shumag: Gamcunapita jucmi reguechipäcamanqui wanuchipäcamänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nipäcamaptinga alisca laquisham Jesusta tapurärï jucnïsi jucnïsi cay nir: “Munayniyog tayta, ¿nogachu cayä?” ");
INSERT INTO qvnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nipäcuptïmi Jesusga cay nin: “Nogawan parëju jitga plätuman tantata tawirpuyagmi reguechimanga wanuchipäcamänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Noga jana pachapita shamusha runawan ruracanga unaypita isquirbirayangannuyran. Nätan wanuchipäcamänanpag reguechimag runam ichaga cayan laquipaypag. Payga mana näcimursi alim canman cara”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Niptinga reguechinanpag cayag Judasga cay ninmi: “Yachrachig, ¿nogachu cayä?” Niptin Jesusga “Gammau cayanqui” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nä micuyta ushaparcayaptïmi Jesusga tantata aptarcur Diosta “Gracias” nicurun. Jinarcurmi tantata partichrarcurga aypuräriman “Micapäcuy, cay tantaga cayan cuerpünuymi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nircärimarga charirun vïnuyog cöpatam. Chaypitam Diosta “Gracias” nircurga, goräriman “Lapay caypita upyapäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cayga cayan yawarnïnuymi. Wanuchipäcamaptin yawarnï wichicanganmi, välichinga cay mushog conträtata runacuna salvacurcänanpag” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chaypitas cay nirärimanmi: “Cananpitaga manam masta upyashagchu üvaspa yacunta yapayga, upyashagga Tayta Diospa munayninchru gamcunawan gotucänä junagran” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chaypitam juc cantata cantacarcärirga aywacurcarä Olivos gotuta. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chaypitam Jesusga nipäcaman: “Canan pagas gamcuna lapaymi dëjarcärimar aywacurcanqui. Chaynuy ruracänanpagmi isquirbishachrüsi cay niyan: ‘Uysha michigtam wanuchishag. Jinarcurmi uyshancunaga wichicasha capäcunga’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nätan wanungäpita nä cawacaramurga aywashag gamcunapa naupaytam Galileata”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Niptinmi Pedroga cay nirun: “Lapan dëjapäcushuptiquis nogaga manam dëjashaychu”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Niptinmi Jesusga Pedrota nin: “Mayamay shumag: Canan pagas manaragsi gallo wagaptilanmi quima cuti ‘Manam reguëchu’ ninqui nogapag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Niptinmi Pedroga yapay cay nirun: “¡Razonpam niyag: Gamtawan wanuchimänan captinsi nogaga manam gampagga ‘Manam reguëchu’ nishagchu!” Niptinga paynuymi lapäcunas nipäcurä. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaypitaga Jesuswan chrarärï Getsemaní ninganmanmi. Chaychrümi cay nipäcaman: “Caychru tayacurcayay mas waclächru Diosta manacamungäcama”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nircurmi pusharicurun Pedrota Zebedeopa ishcay churincunatawan. Paycunawan cayarshi alisca juyupa laquicuyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Chauraga chay quimantash cay nin: “Alisca laquicuymi chariraman. Caylachru mayag mayagla riccharcayar cacurcayay”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nircur Jesusga mas waclaman ashuyurshi pampaman lipucuyun. Jinarcurshi manacuyta galacuyun cay nir: “Dios-mayï, gam munarga amar cunchuchimaychu chay cunchunäcunata. Nätan ama munangänuyga cachunchu, antis cachunga gam munangaynuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nircurga cutiramun chay quima discïpuluncunamanshi. Jinarcurshi tarirun punucashata. Chauraga Pedrotash cay nin: “Gamga manachu juc üralas nogawan parëju ricchayar cayta atiparay. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ricchayar capäcuy, jinaman manacurcay Diosta, Asyag mana juchaman ishquichishunaypag. Razonpas shongolayga munayanmi ricchayta, jinaman manacuytas, nätan cuerpuymi ichaga guellanayanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nircurga yapay cutirshi manacuruntag cay nir: “Dios-mayï. Chay cunchunäcunata cunchunärag captinga jina cunchushag. Chauraga gam munangaynuy ruracächun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nircurga yapayshi cutiyuruntag, jinarcurshi tarirun chay quima discïpulu-mayïcunataga punucashatatag. Paycunaga ricchayälar cayta mana atipapäcurachu alisca pununapäcuptinshi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chauraga jinata dëjarcurshi yapay aywacun, chaywanga manacurun nä quimapaypash naupata ningannuyla. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaura yapay cutiramurga chay quima discïpulu-mayïcunatash cay nin: “Nämi punurärinquis jamarärinquis. Nämi ürä chraramun noga jana pachapita shamusha runata juchasapa runacunapa maquincunaman jitayusha canäpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sharcapäcuy, acuchi aywacushun. Reguechimagnï nämi yaycayämun”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chay nir Jesús rimayaptilanmi chay discïpulu-mayïcuna Judasga chraramun. Payga cara chay chrunca ishcayniyog nogacuna castam. Paywanmi aywarärimunag achca runacuna espädanwan jinaman guerunwancama. Chay runacunata cachrarärimunag sacerdöticunapa mandagnincunawan, alisca alinninpag ricasha chacha runacunam. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jesusta reguechig Judasga nämi yachrarachinag chay runacunata cay nir: “Muchashagmi. Chaytam charipäcunqui” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chauraga Jesusman jucla ashuyurmi, Judasga “Yachrachig, buenas noches” nirun. Jinarcurmi mucharun razón razón. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Chaura Jesusga cay ninmi: “Judas, imata ruramänaypagmi shamuray, chayta jucla ruray”. Niptinga chaylam Jesusta charicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chaylam nogacunapita jucga espädanta jorgarcamur muturun lapan sacerdöticuna mandagpa rantisha runanpa chulan rinrinta. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chaura Jesusga cay nirunmi: “Espädayta chruray chruracunayman. Pi maysi espädawan peliagga espädawan wanuchisham canga. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nogaga canan üra Tayta Diosta manacurümanmi angelcunata ganchris chrunca warangapita masta nogata washamag cachramunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nätan manacungänuy ruracaruptinga, Dios isquirbichingancunaga ¿imaynayparag ruracanga, chaynuy ruracänanpag niyaptinga?” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chaura Jesusga chay runacunatam cay nin: “¿Imanirtag gamcunaga yargarärimunqui juc suwamannuy espädaycunawan jinaman gueruycunawan charipäcamänaypag? Nogaga waran waranmi Diospa wayinchru yachrayächir tayag cä. Nätan manatan imaysi charipäcamaraychüga. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nätan lapan caycuna ruracayan Diospa willacugnincuna isquirbipäcungan ruracänanpagmi”. Niptinga chaylam nogacunaga Jesús japalanta dëjarcur gueshpicurcarä. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chauraga charircur Jesusta aywachigcunaga chrarärichin lapan sacerdöticunapa mas mandagnincagpa wayinmanmi. Paypaga jutin cara Caifasmi. Chaychrümi Moisés isquirbinganpita yachrachigcunawan alinnin ricasha chacha runacuna goturarcayänag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nätan Pedroga Jesusta gatirara carulapam chay Caifaspa wayin puncucama. Chayman yaycururga, guardiacunawanmi tayayara imachru ushacangantas musyananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nätan sacerdöticunapa mandagnincunawan chay ganchris chrunca mandagcunaga ashipäcura Jesuspa contran pilas manacagta rimarcunantam “Cayga wanuchisha cachun” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Chauraga achca runacuna manacagpita juchacharcayaptinsi, manam paypa juchan carachu. Nä ushananmanga ishcay runacunam yaycarärin ");
INSERT INTO qvnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","cay nir: “Cay runaga ‘Diospa wayinta juchrurcachir, quima junagtaga sharcarachimanmi’ niram”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Niräriptinga lapan sacerdöticunapa mas mandagnincagmi sharcurcur Jesusta cay nirun: “¿Manachu imatas ninqui cay juchacharcayäshugniqui runacunata?” ");
INSERT INTO qvnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Niyaptinsi Jesusga upälalam cacura. Chauraga chay mandagga cay ninmi: “Cawayag Diospa naupanchrümi cayanchi. Razoncagta nipäcamay, ¿Diospa-mayinchu jinaman ‘Salvacugtam cachramushag’ Dios ninganchu cayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Niptinmi Jesusga “Au. Gam ningaynuymi cayä” nirun. Chaypitas cay niraran: “Cananpitaga gamcuna ricapapäcamanqui noga jana pachapita shamusha runata Munayniyog Diospa derëcha lädunchru tayayagtam. Jinaman ricapäcamanquitan jana pachapita pucutaychru aywamugtas”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Niruptin chay lapan sacerdöticunapa mas mandagnincagga chay sacerdöti jacuntam lachirun alisca piñasha canganta musyachinanpag. Jinarcurmi nin: “¡Chaynuypa rimayarga Diostam ashliyan! Cananga cay runapita manam pi imata nimänanchitas munanchichu. ¡Canan üram chay lutan rimanganta mayarunchi! ");
INSERT INTO qvnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ima nipäcunquitag?” Niptinmi chaychru cayag runacunaga “¡Juchayogmi! ¡Wanuchun!” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Niräriptinga Jesuspa cäranman togaparcurmi cutayta galacayärin. Jinaman waquinmi lagyay ushacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Jinarcurmi nipäcura: “Dios ‘Salvacugtam cachramushag’ ninganmi cayä niyarga, nipäcamay pi lagyashungaytas” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chaycamaga chay wayi puncuchrümi Pedroga tayayara. Jinarcurmi chay wayichru uryag jipashga Pedroman ashuyur cay nirun: “Gamsi Galilea marcapita Jesuswanmi puriray”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Niptinmi Pedroga lapanpa naupanchru “Manam musyächu imapitachr rimapayämanquis” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nircur sawancagman aywayaptinmi juc warmis ricapuruntag. Jinarcurmi chaychru cayagcunata nirun: “Cay runasi Nazaretpita Jesuswanga puriram”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Niptinga chaychrüsi yapaytagmi Pedroga juracurun “Wac runataga manam reguëchu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chaypita mas unaylantam chaychru carcayagcunaga Pedroman ashuyärir cay nirärin: “Razonpa gamga cayanqui wacwan purig castam. Rimacuylaypam tantiachicuyanqui Galileapita cangayta”. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nipäcuptin Pedroga juracuytam galacuyun “Manam wac runata reguëchu. Nätan casquicuptïga Dios cunchuchimächun” nir. Niruptilanmi gallo wagaramun. ");
INSERT INTO qvnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chaura Pedroga yarparun Jesús cay ningantam: “Manaragsi gallo wagaptilanmi quima cuti ‘Manam reguëchu’ ninqui nogapag” ningantam. Chauraga yargorun washatam. Chaychrümi wagacun alisca alisca. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chaura nä pacha wararamuptinga sacerdöti mandagcunawan Israel castachru alinninpag ricasha chacha runacunam lapan rimanacarärin Jesusta wanuchinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jinarcurmi chay gobernador Pilatoman aywachicurcan watashata. Chaura chrarärichirga paypa maquinmanshi jitayarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Chaura chay reguechig Judasga Jesús wanuchisha cananpag nipäcunganta nä musyarurga “Lutantam cayta rurarü” nirmi, chay quima chrunca golgueta apacurcur aywarunag, chay sacerdöticuna mandagcunaman jinaman chay alinninpag ricasha chacha runacunaman ");
INSERT INTO qvnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","chrarurmi cay nin: “Mana juchaynagta wanuchipäcunaypag reguechirnï alisca juchatam rurasha cä”. Niptin chay runacunaga “¿Imamantag nogacunaman aywaramunqui? ¡Ima supaysi cacuy!” nipäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chaynuy niräriptin Judasga Diospa wayin sawan ruyiman chay golgueta wicaparcurmi aywacun. Jinarcurmi jurcacurunag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chaura sacerdöticuna mandagcunaga golgueta palarcurmi cay ninacarärin: “Cay golguetaga ama chrurashunchu Diospag golgue chruracunacagmanga. Cay golguega cayan wanuchinanchipag päganganchim”. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nircurmi rimanacarärin manca rurag runapa pampanta chay golguewan rantipäcunanpag. Chayta rantipäcura juc casta runacuna wanugta chayman enterrapäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chaymi canancamas chay pampapa jutinga cayan ‘Yawar pampa’ nisha. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chaynuypam ruracara Diospa unay willacugnin Jeremías cay nir isquirbingan: “Quima chrunca golguetam charirärin. Chayga cara Israel runacuna ‘Chaynuyta pägashun’ nipäcunganmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chaywanmi rantirärira ‘Manca rurag runapa pampanta’ Munayniyog Dios ningannuyla” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chaura Jesusga cayara Pilatopa naupanchrümi. Jinarcurmi Pilatoga tapurun cay nir: “¿Gamchu Israel castacunapa reynin cayanqui?” Niptinmi Jesusga “Au, gam ningaynuymi cayä” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nätan sacerdöticunapa mandagnincunawan alinninpag ricasha chacha runacuna ima-aygata juchacharcayaptinsi, Jesús manam imatas nirachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chaura Pilatoga cay ninmi: “¿Manachu imatas ninqui chaynuy lapanta gampita rimarcayaptin?” ");
INSERT INTO qvnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nätan niyaptinsi Jesusga manam imatas pasay nirachu. Chaura chay upälala captin, gobernadorga mayacasham ricacarun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chay Pascua fiestachrüga, Pilatoga wata watam cachrarichrag cara juc runata carcelpita runacuna munanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chauraga cara juc runam carcelchru wichrgasha Barrabás jutiyog. Payga cara lapan runacunapitas alisca reguesham. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaura runacuna goturarcayaptinmi Pilatoga tapurun cay nir: “¿Maygan cachrarinätatag munarcayanqui? ¿Barrabastachu? u ¿‘Cristo’ ningan Jesustachu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatoga shumagmi tantiara Jesusta chregnipaylapita payman aywachipäcunganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chaura juchacunata taripäcunanchru tayayaptinmi Pilatopa warmin cachracurun juc runata cay nichig: “Ama chay mana juchaynag runata imatas ruraychu. Canan pagasmi sueñüchru Dios alisca cunchuyächiman paypa janan” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nätan alinninpag ricasha chacha runacunawan sacerdöticunapa mandagnincunaga runacunatam yachrarärichin “¡Barrabasta cachrariy! Nätan Jesusga ¡wanuchisha cachun!” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chauraga yapaymi Pilatoga tapurun runacunata cay nir: “Cay ishcay runapita ¿maygantatag cachrarishag?” Niptinmi paycuna “Barrabasta cachrariy” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chaura Pilatoga cay nirunshi: “Chaura ‘Cristo’ ningan Jesustaga ¿imatatag ruräman?” Niptinga lapanmi “¡Cruzchru wanuchisha cachun!” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nipäcuptin Pilatoga cay nirunmi: “Chauraga ¿ima juchatatag rurarayan?” Niptin runacuna masmi gaparäcurcan “¡Cruzchru wanuchisha cachun!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chaura Pilatoga nä pinsiangannuy mana ima ruraytas atiparga, jinaman runacuna mas gaparayta galacayäriptinga, yacuwanmi maquinta maylacurun chay runacunapa naupanchru cay nir: “Cay mana juchaynag runata wanuchipäcuptiqui nogaga manam juchayogchu cashag, ¡antis gamcunam juchayog capäcunqui!” ");
INSERT INTO qvnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Niptin chay runacuna cay nirärinmi: “Au, nogacunam jinaman castä aywagcunam juchayog capäcushag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaura nipäcuptin Pilatoga Barrabastam cachrarirachimun. Nätan Jesustam alisca astirachin soldäduncunawan. Jinarcurmi cruzchru wanuchipäcunanpag paycunapa maquinman jitayurun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chaypitam soldäduncuna Jesusta aywachicurcan Pilato mandanan wayi puncuman. Chayga cara soldäducuna cacurcänanmi. Chaychrümi Jesuspa muyurigninman lapan chaychru cag soldäducunata goturärichin. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jinarcurmi Jesusta garapachrarcurga, jatiräripun reypa puca jacunta. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chaypitam cashapita awasha corönata umanman jatiräripun. Nätan derëchacag maquintam aptarärichin juc chagla gueruta. Jinacarcärirmi naupanman gongorpacuyur asipapäcura “Cawachun Israel castacunapa reynin” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chaypitam togapapäcura. Nätan chagla charichipäcunganwanmi umanchru wipyay ushapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chaynuypa ima-aygatas ruracarcärirga, chay jacupurcangantam shogtiräripun. Jinarcurmi jacuräripun quiquinpa jacunta. Chaypitam aywachicurcan cruzman clävapäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chaypita nä yargorcayarmi tincurärin Cirene marcapita Simón jutiyog runawan. Jinarcurmi paytaga charicarärin Jesuspa cruzninta apananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chaura ‘Gólgota’ ninganmanmi chrarärin. (‘Gólgota’ ninanga ‘Uman tullu gotu’ ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaychrümi gorärin vïnuta juc atgagwan tacushata. Nä malirur Jesusga manam upyayta munarachu. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chaypitam nä Jesusta cruzman clävacarcärirga, chay soldäducuna Jesuspa jacunta aypunacarärin chüsarcur chüsarcur. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jinacarcärirga chaychrümi tacayärin ima pasanantas rircarapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nätan imapita cruzman clävapäcungantas musyapäcunanpag cruzpa umanman chrurarärin “CAYGA ISRAEL CASTACUNAPA REYNIN JESUSMI” nir isquirbishata. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chaychru capäcura ishcaymi suwacuna Jesusnuysi cruzman clävasha, jucninmi cara derëchanchru, nätan jucninmi cara ichogninchru. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nätan chaypa pasagcunam ashlipapäcug umancunata awircayar cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“¡Gam Diospa wayinta juchruchig jinaman quima junaglachru gangalanta sharcachig, razonpa Diospa-mayin carga, mä quiquiqui salvacuy! Jinaman chay cruzpita jegarpamuy” nircayar. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chaypitaga sacerdöticunapa mandagnincunawan Moisés isquirbinganpita yachrachigcunas, jinaman chay Israel castachru alinninpag ricasha chacha runacunas Jesusta nipäcura cay nirmi: ");
INSERT INTO qvnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Juccunataga salvara, nätan quiquingä manatan salvacuyta atipanchu. Razonpa Israel castacunapa reynin carga, mä canan cruzpita jegarpamuchun. Jegarparamuptinga ‘Payga razonpa reyninchim’ nishunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Payga Diosmantar yupachicura, cananga cay cruzpita Dios jorgochun munarga. Payga ‘Diospa-mayinmi cayä’ niratar” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chaynuymi chay suwacuna paywan clävarayagsi Jesusta ashlipapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jinarcurmi chraupi junag cayaptin pachaga chacarun. Chaynuyla cara quima üraran. Chauraga chay chacashala nä quima üraman nachrgarayaptinmi, ");
INSERT INTO qvnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jesusga gayachracarun lapan calpanpam cay nir: “Elí, Elí, lama sabactani”. (Chayga ‘Dios-mayï, Dios-mayï, ¿imanirtag dëjaramanqui?’ ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chaynuy niptinga chaychru cayagcunapitam juc ishcay cay nipäcura: “Cay runa gayacuyan Diospa willacugnin Eliastam” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chaylam chaychru carcayagpita jucga wayrala esponjata ogorachin puchgorisha vïnuman. Jinarcurmi juc chaglapa puntanman chrurayur Jesusta chacchayächin shogonanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nätan waquincagmi “Jina cachun, mä aywamuchun Elías cruzpita jorgonanpag” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chauraga yapaymi Jesusga lapan calpanpa gayachracaramun. Jinarcurga chaylam wanurun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chayüram Diospa wayin ruyichru chay racta telonsi lachirura ishcayman, janapita uraman. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jinamanmi pachasi alicusa cuyurun. Chay cuyuyaptilanmi gagacunas sagrarun. Jinarcurmi Dioslapag cawag unay wanusha runacunas cawacarärimun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chaura chay cawacämushacuna Jesús nä wanushapita cawacaramuptinran, yaycapäcura Diospag nisha Jerusalén marcaman. Chaychrümi achca runacuna ricapapäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Chaura chaychru pachrac soldäducunapa mandagninwan Jesusta täpag soldäducuna aliscam manchacarärin chay pacha cuyugta jinaman imas pasagta ricarärir. Chauraga “Cay runa razonpa cara Diospa-mayinmi” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chaychru capäcura achcam warmicunas carulapita rircararcayar. Chay warmicuna aywapäcamusha cara Galileapitam, paycuna Jesustam atendipäcug. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chay warmicunapita jucmi cara Magdalapita María, jucmi cara Jacobopawan Josëpa maman María, jinamanmi Zebedeopa warmin. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chaypitam nä pacha chacanayaptinga chraramun juc capogniyog runa, José jutiyog Arimatea marcapita. Paysi nä muyusha cara Jesuspa discïpulunmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Paymi aywarun Pilatoman “Jesuspa cuerpunta enterramushag” nig. Niptinmi Pilatoga “Äri” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chaura Josëga wancurun Jesustaga lïnupita rurasha allanyag tëlawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jinarcurmi chrurarun quiquinpa mïchunpag gagachru uchrcunganman. Chaypitam jatun lasag rumiwan mïchupa puncunta wichrgarcur aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chay mïchucagchrüga carcayara Magdalapita Mariawan jucag Mariam tayarcayar. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chaypitam enterracungan junag warantinga, chay jamana junag nä pasaruptinga, sacerdöticunapa mandagnincunawan fariseocuna gotucarärin Pilatocagman. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jinarcurmi payta cay nirärin: “Tayta, yarparärï chay casqui runa cawayar, cay nir rimangantam: ‘Wanungäpita quima junag pasashachrümi cawacämushag’ ningantam. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chauragar nilay soldäduycunata chay mïchu täpacug quima junagcama aywapäcunanpag, chay discïpuluncuna pagaspa aywaramur cuerpunta mana suwapäcunanpag. Jinacarcärirga ‘Cawacaramunmi’ nipäcungam. Chaynuy nipäcuptinga, chay naupacag casquipitaga masmi pantacaräringa cay guepacag casquiwanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Niräriptinmi Pilatoga cay nirun: “Cä cayan soldäducuna. Aywapäcuy paycunawan”. Jinaman nipäcuy imata rurapäcunanpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Niruptinga aywacurcan mïchuncagtam. Chayman chrarärirga chay chaparagnin rumita unancharärin runa quichraptin musyacänanpag. Chaypitam nirärin soldäducunata tapapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chaypitam jamana junag pasaruptinga, nä semäna galayunan junagchrüga yanan yananlam aywarärin Magdalapita Mariawan jucag Mariaga Jesuspa mïchun ricag. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jinarcurmi pacha cuyurun alisca juyupa. Pachaga cuyusha jana pachapita ángel aymuptinmi. Chaypitam payga Jesuspa mïchunman ashuyur chay wichrgasha rumitaga jorgorun. Jinarcurmi chay rumi jananman tacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Payga cara juc lipanuysi alisca achicyagmi. Nätan jacunmi cara jancanuysi allanyag. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chay soldäducuna angelta ricaparärirga manchacaypitam alisca chucchucyayta galacayärin. Jinarcurmi wanuparärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chaura angelga warmicunatam cay nin: “Ama manchacapäcuychu. Musyayämi cruzchru wanuchipäcungan Jesusta ashircayangayta. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Payga manam caychrüga canchu. Ningannuylam nä cawacämusha. Shapäcamuy Jesuspa cuerpun chrurapäcungancagta ricapäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cananga pasay-pacha aywapäcuy discïpuluncuna willacug, cay nipäcunquim: ‘Jesusga cawacämusham. Payga nä naupayan Galileatam. Chaychrümi tincupäcunqui’. Chaytam gamcunata nogaga willapäcunag cara”. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Niptin warmicuna manchacasham jinaman alisca cushisham chay mïchucagpita aywacarcamunag wayrala discïpuluncuna willag. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chay aywarcayämuptinmi Jesusga naupancunachru ricacarun. Jinarcurmi “Buenos días” nirun. Chaura paycuna Jesuspa naupanman ashuyurmi manchapacuypa gongorpacuyur lipucayärin. Jinarcurmi Jesuspa chraquinta macalicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chaura Jesusga cay nirunmi: “Ama manchacapäcuychu, antis aywapäcuy wauguëcunata willag Galileata aywapäcunanpag. Chaychrümi tincupäcushag” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chay warmicuna nä aywarcayaptinmi täpacug soldäducuna ishcay quima aywacurcan marcata. Nä chrarärirga willapacarärin sacerdöticunapa mandagnincunatam chay lapan ima-aygas pasanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaura sacerdöticunapa mandagnincuna aywacurcan alinninpag reguesha chacha olgocunamanmi imata rurapäcunanpagsi rimanacug. Chaychrümi rimanacarärin soldäducuna casquicurcänanpag alisca chranin golgueta gopäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jinarcurmi golgueta gorärin cay nir yachrarcärichir: “ ‘Pagaspa punurcayangäcamam, discïpuluncuna aywarcärimur Jesuspa cuerpunta suwapäcusha’. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nätan chayta Pilato mayarur imatas rurayta munapäcushuptiquiga, nogacunam paywan rimapäcushag mana imatas rurapäcushunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chay nipäcuptinmi soldäducuna golgueta chrasquirärin. Chauraga chay yachrachipäcungannuylam runacunata willapacurcara. Chay casquitam Israel castäcuna willapacurcayan canancamas. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nätan nogacuna chrunca jucniyog discïpuluncuna aywacurcarä Galileatam “Chay gotuchrümi tincucäshun” nipäcamangan cagta. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chaychru Jesusta ricaparärirga manchapäcuypam gongorpacuyur lipucayärï. Nätan waquinnïcunaga “Manachr Jesusga canmanchu” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Chaura nogacuna lipurarcayangäcagman ashuyamurmi Jesús cay nipäcaman: “Tayta Diosga nogata chrurarayäman jana pachachru cagtasi cay pachachru cagtasi lapanta munaynïchru cachinäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chauraga aywapäcuy cay pachachru lapan casta runacunaman jinaman nogapa discïpulüman muyuchipäcamuy. Nätan bautizapäcunqui ‘Tayta Dios, noga Diospa-mayin Jesucristo, jinaman Santu Espíritu nisha capäcushuptiquim’. ");
INSERT INTO qvnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jinaman lapan ningäcunatam yachrachipäcunqui paycunas cäsucurcänanpag. Nätan nogaga imay aygaysi gamcunawanmi cayäshag cay pacha ushangancama”. Chaynuy cachun.");
INSERT INTO qvnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Caynuypam galayura Diospa-mayin Jesucristopita ali willapa. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Diospa unay willacugnin Isaiaspa isquirbishanchru Jesuspag cay niyanmi: Gampa naupaytam willacugnïta cachrayä, gam chränaypag runacunata camarinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Paymi chunyag pampachru gayacuypanuy willacunga cay niyar: “Camaricurcay munayniyog chrämunanpag lutan cawarcayangaypita ali cawayta galayapäcuy” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chauraga chay isquirbishachru ningannuymi Bautizag Juanga chunyag pampachru runacunata rimapara cay nir: “Juchaycunapita wanacurcur Diosman cutipäcamuy perdonapäcushunaypag, jinaman bautizacurcay” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chaynuy niptinmi Judea ninganchru lapan marcacunapitawan Jerusalén marcapitaga aywapäcura lapan runacuna Juan rimanganta mayapäcunanpag. Nätan “Juchasapam cä” nigtam, Juanga bautizara Jordán mayuchru. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanpa jacun cara ‘camellu’ jutiyog uywapa milwanpita rurasham. Nätan wachrucunmi cara garapita rurasha. Micunanmi cara salta piricu nirayag langosta jutiyog curu, jinaman chrinyashpa mishquin. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nätan Juanga willapäcura cay nirmi: “Nogapa guepäta aywamugga cayan nogapita mas munayniyogmi, manam nogaga paypagga maygan alinninsi cächu lipurpuyur languenta pasquipunaläpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gamcunata noga bautizapäcurag yacuwanmi, nätan payga galayachipäcushunqui cawayta Santu Espíritu munangannuymi” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay junagcunalam Jesusga aywara Juan cayanganman Nazaret marcapita. (Nazaretga cayan Galilea ninganchrümi.) Jinarcurmi Juanga bautizara Jesusta Jordán mayuchru. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chaypitam bautizächicurcur mayupita yargayämur, Jesusga ricapurun jana pacha quichracayagta. Jinarcurmi ricapurun Santu Espirituta payman juc palömanuy uranpayämugta. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chaylam jana pachapita Diosga rimaparamun cay nir: “Gamga cayanqui alisca cuyashä Dios-mayïmi. Gampitaga alisca cushisham cayä” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chaypita chaylam Jesusga aywara chunyag pampata Santu Espíritu aywachiptin. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaychru payga cara chruscu chrunca junagmi, sima uywacunawan. Chaychrümi Asyagga imanuypanuysi juchäcachiyta munara. Chaypitam angelcunaga aywarcamur Jesusta atendipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chaypitam Bautizag Juan nä carcelchru wichrgarayaptin, Jesusga aywara Galilea ninganpa Diospa ali willapanta cay nir musyayächir: ");
INSERT INTO qvnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Nämi chraramun Diospa munayninchru cawapäcunay wichan. Jucha ruraypita wanacurcur Diosman cutipäcuy, jinaman ali willapa rimayangäta ‘Razonmi chayga’ nir, chrasquicurcay” niyar. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chaypitam Jesusga ricapurun Galilea ningan gochra manyanpa aywayar Simonta, jinaman Andresta, ataräyancunawan chay gochrachru pescacurcayagta. Paycunapaga chaymi uryaynincuna cara, jinaman capäcuras chay wauguelam. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chauraga paycunatam Jesusga cay nirun: “Aywashun nogawan, nogam yachrachipäcushay imanaypa runacunata Diosman aywachipäcamunaypagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chaynuy niruptinga ataräyancunata chrurayurmi Jesuswan aywacurcara pasay-pacha. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chaypita nä washascata aywarcayarmi Jesusga ricaparuntag Jacobotawan Juanta, büquinchru ataräyancuna alcharcayagta. Paycuna capäcura Zebedeopa churinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Chaura Jesusga paycunatas gayarunmi. Jinarcurmi paycunas aywacurcan Jesuswan, taytan Zebedeota mincaynincunatawan büquinchru dëjarcur. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaypitam paycunaga chrarärin Capernaum marcaman. Jinarcurmi jamana junagchrüga Jesusga yaycurun Israel castacuna gotucarcänan wayiman. Chaychrümi yachrachiyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jinarcurmi runacunaga rircaräcurcan mayacasha cay nir: “Payga yachrayächin quiquin Dios ningannuytag manatag cay yachrachimagninchi runacuna nipäcungannuylachu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chauraga chay gotucarcänan wayichrümi cayara juc runa lutan espiritupa munayninchru. Jinarcurmi mayänipita chay espirituga chay runata gayacuypanuy rimarachin cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¿Imanarayanquitag nogacunawan Nazaret marcapita Jesús, gamga nä aywarayämunqui cunchuchipäcamänaypagchu? Nogaga musyayämi gam pi cangaytas. Gamga cayanqui Diospita shamusham”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Niptinmi Jesusga lutan espirituta piñaparun cay nir: “¡Upäla mayaray! ¡Yargoy cay runapita!”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Niruptinmi espirituga chay runata wanuparcachir alisca gapachracuyar yargorun. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chayta ricarurga lapan chaychru carcayagcunam manchacarärin Jesús chaynuy ruraruptin. Jinarcurmi quiquincama tapunacarärin cay nir: “¿Imatag cayga? ¿Imatatag ricarunchi? Cay runa yachrachingantanuyga manam imaysi mayacuranchichu. Jinaman lutan espiritucunas yargoy niptinsi cäsucurcayantan” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesús chaynuy ruranganpitaga, limpum Galilea ninganpa mayachinacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nä chay Israel castäcuna gotucarcänan wayipita yargarärirga, Jesusga aywacun Jacobowanmi, Juanwanmi, Simonpa jinaman Andrespa wayinta. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chrapäcunanpagmi alisca rupariyar cämachru jitarayänag Simonpa suydranga. Chaytam Jesustaga willarärira. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chaura Jesusga gueshyagcagman ashuyurmi maquipita charircur sharcarachin. Chauraga chaylam chay acachaynin illacarura. Jinarcurmi payga garachracuyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nä pacha chacarpurayaptinmi, Jesús cayangan chay wayiman chrarärichin gueshyag runacunatawan, lutan espirituyog runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chaypitam chay marcachru yachrag runacunaga, lapalan gotucarärimun chay wayi puncuman. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chaychru Jesusga cuticarachin tucuywan gueshyagcunatam. Nätan waquinpitam gargora achca lutan espiritucunata. Chay Asyagpa espirituncuna musyaram Jesús Diospita shamusha cangantas. Chaymi Jesusga “Nogapita ama rimapäcuychu” nira chay lutan espiritucunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jinarcurmi warantinga chacay chacayla sharcurcur Jesusga aywacun chunyag pampata, chaychrümi Dioswan rimara. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Chaypitam Simonga chaychru cayag-mayincunawan Jesús ashig aywacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nä tarirurga “Lapan runacunam ashircayäshunqui” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nipäcuptinmi Jesusga nirun: “Cananga aywashun waquin marcacunatarag Dios ninganta chaycunachru musyachinäpag. Chaypagmi nogaga shamusha cä”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nircurga aywara Galileachru cayag lapan marcacunapam, Israel castäcuna gotucarcänan wayicunachru willapacuyar, nätan runacunapita lutan espiritucunata gargoyar. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Chaypitam Jesusman chrarun gueri nirayag leprawan gueshyag runa. Jinarcurmi naupanman gongorpacuyur cay nin: “Tayta, munargar cay gueshyapita cuticayächimay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Niptin Jesusga cuyaparunmi, jinarcurmi yatayurun cay nir: “Munämi cuticänayta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Niruptilanmi chay runaga chay gueshyapita cuticarura. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chaura Jesusga “Aywacuy” nircurmi, chruncay chruncay cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mayamay shumag: Amam cuticächingagpitaga pitas willapanquichu antis ayway sacerdötiman ricashunaypag. Jinarcurga Moisés mandangannuy gonaycagta gomuy, razonpa cuticasha cangayta paycuna musyapäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Chaypita aywar, chay runaga lapan runacunatam willapacuyta galacuyun imanuypa cuticächingantas. Chaura Jesusga manam yaycuyta atiparachu marcacunaman, antis puricura runacuna mana yachrangalanpam. Nätan runacunaga mayag chayagpitas aywapäcug pay cayanganmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chaypita nä ishcay quima junagtam Jesusga yapay cutirun Capernaum marcata. Chay cutinganta mayarärir runacunaga pasay-pacham gotucarärin Jesús cayangan wayiman. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nä manam jäcurachu chay wayipaga ni punculansi, nätan Jesusga ali willapatam yachrayächira. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jinarcurmi Jesús cayangan wayicagman chrarärichin chruscu runacuna juc uncutucusha runata. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nätan runacuna junta captinmi Jesús cayanganman mana yaycachiyta atipapäcurachu. Chauraga Jesús cayangan wichanninpam wayipa gatanta gachrachrärir gueshyagta quirmantinta wascawan cachrarparärin Jesuspa naupanman. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chaypitam payman yupachicurcayanganta tantiarur, Jesusga gueshyagta cay nirun: “Wamralä, juchaycunata nämi perdonarug”. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Niptinmi Moisés isquirbinganpita yachrachigcuna, juc ishcay chaychru tayarcayagcunaga shongolanchru cay nirärin: ");
INSERT INTO qvnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¡Wä! ¿Imanirtag cay runa chaynuy riman? Chaynuy rimarga Diostucuyantag. Dioslam runacunapa juchantaga perdonan, manam pisi jucga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nätan chaynuy pinsiarcayanganta tantiarurmi Jesús cay nir tapurun: “¿Imanirtag shongolaycunachru chaynuy pinsiarcayanqui? ");
INSERT INTO qvnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Imatatag mas fäsi nichwan cay uncutucusha runata? ¿‘Nämi juchaycunata perdonarug’ niytachu? u ¿‘Sharcuy, cämayta apacurcur, aywacuy’ niytachu? Ishcayninsi mana ruray atipänan runalapagga. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nätan noga jana pachapita shamusha runam ichaga munayniyog cayä juchacunata perdonänäpag. Nätan chaynuy cangäta musyapäcunaypag cay gueshyagta nishag: ");
INSERT INTO qvnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Sharcuy, cämayta apacurcur wayiquita aywacuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Niptin gueshyagga chayüram sharcurun. Jinarcurmi quirmanta apacurcur aywacun lapan runacuna rircararcayaptin. Chaynuy ruraruptinga mayacasham ricacarärin lapansi. Chaypitaga Tayta Diostam alawayta galacayärin cay nir: “Manam imaysi ricaranchichu pitas caynuy ruragtaga” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaypitam Jesusga Galilea gochra manyanman aywacun. Jinarcurmi paycagman runacuna chraräriptin yachrachira. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaypita nä aywayarmi Mateota ricapurun, Romapag patenti cobracunanchru tayayagta. Pay cara Alfeopa churinmi. Paytam Jesusga cay nirun: “¡Uryashun nogawan!” Niptin Mateoga tayayanganpita sharcurcurmi aywacun Jesuswan. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chaypita Jesusga Mateopa wayinchrümi micuyara discïpuluncunawan, patentita cobrag achca runacunawan, jinaman waquin juchasapacunawan. Jesusta chay gatirag runacuna achcam capäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chayta ricarmi Moisés isquirbinganta yachrachigcunawan fariseocunaga, jinaman jucha rurag runacunaga tapurärin Jesuspa discïpuluncunata: “¿Imanirtag wac yachrachipäcushugniqui micun upyan patenti cobragcunawan, jinaman juchasapacunawan?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chay nipäcugta mayarurmi Jesusga nirun: “Mana gueshyagcunaga manam munapäcunchu jampicugta. Jampicugtaga munapäcun gueshyagcunalam. Chaura nogaga manam aywamurä mana juchaynagcuna ashigchu, antis gueshyagcuna yupaysi cayag runacunamanmi aywarayämü salvanäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jucpaychrümi juc ishcay runacuna Jesusman chrarärin cay nir tapucug: “Fariseocunapawan Juanpa discïpuluncunaga malagapäcunmi, nätan ¿imanirtag gampa discïpuluycunaga mana malagapäcunchu?” Chay nir tapupäcura fariseocunapawan Juanpa discïpuluncuna imaysi malagag capäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chaura Jesusga nirunmi: “¿Juc runa casaraptin gayachimusha runacuna malagapäcunchu? Manam. Casaracug olgo paycunawanrag cayaptinga, chaura casaracug olgo cayangancamaga manam malagapäcunchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nätan nogata chay casaracug olgonuysi cayagta chregnimagcuna aywachipäcamänan junag chraramuptinmi ichaga malagapäcungaga. Chaymi cay mushog yachrayächingaga mana tincunchu paycuna yachrachinganwanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Shumag tantiapäcunaypag mä cayta niyärishay: Manam pisi macwa jacuta remendanchu mushog sagpiwan. Mushog sagpi guentir chay macwa jacuta mas jatuntam lachichin. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Manatan vïnu chayrag rurashatas wiñanchichu macwa wagalamanga. Macwa wagalaman wiñarushaga pogorimur lachichinmi. Chauraga ishcayninmi pampanman ruracarun. Chaymi mushog wagalaman chayrag rurasha vïnutaga wiñanchi. Chaynuymi cay mushog yachrayächingäsi cayan”. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chaypitam juc jamana junagchru Jesusga discïpuluncunawan aywarcayara trïgu wiñayag chracracagpa. Jinarcurmi discïpuluncunaga palaricurcara ishcay quima tullulata micanasha capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chayta ricarmi fariseocunaga Jesusta tapurärin: “¿Imanirtag discïpuluycunaga palarärin trïguta canan jamana junagchru?” ");
INSERT INTO qvnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nipäcuptinmi Jesusga nirun: “¿Gamcuna manachu leyipäcuray Davidpita, jinaman yanapagnincunapita micanasha car rurapäcunganta? ");
INSERT INTO qvnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Paycunaga Diospa wayinmanmi yaycapäcura, chaychrümi sacerdöticunapa mas mandagnin Abiatar jutiyogga, gorura Dioslapag nisha tantacunata. Chaytaga sacerdöticunalam micapäcug cara”. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesusga chay nircursi cay niraran: “Jamana junagtaga Dios camasha runa yanapasha cananpagmi; manam jamana junagchru mana imatas ruralar cananpagchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chauraga noga jana pachapita shamusha runapa munaynïchrümi cayan jamana junagsi” nira. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Chaura yapaytan Jesusga yaycurun Israel castacuna gotucarcänan wayiman. Chaychrümi cayänag juc runa maquin uncusha. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nätan fariseocunaga ñawilanchrümi cachipäcunag Jesustaga juchachapäcunan raygo “Mä jamana junagchru cuticächinagchush” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chaura Jesusga maquin uncusha runatam “¡Sharcuy! ¡Cay chraupiman shamuy!” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chaypitam tapurun chay runacunataga: “¿Imatatag rurananchi cayan jamana junagchru? ¿Alitachu u lutantachu? ¿Wanunayagcunata jampinapagchu icha mas wanurpachinapagchu?” Chaynuypa tapuruptin paycunaga upälalam capäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chaura Jesusga piñasham rircärirun muyurigninchru carcayag runacunata. Jinarcurmi laquicurun rimayanganta mana chrasquiyta munapäcuptin. Chaypitam maquin uncusha runata “¡Chacchayuy!” nirun. Chauraga chacchayuruptilanmi chay runapa maquin cuticarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nätan chay fariseocuna yargarärirga rimanacarärin Rey Herodespa runancunawanmi Jesusta wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chaypitam Jesusga aywacun discïpuluncunawan Galilea gochra manyanman. Jinarcurmi achca runacuna Galileapita aywapäcura guepanta. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ima-aygatas ruranganta mayarurmi, pay cayanganman shapäcamura, Judeapita, Jerusalén marcapita, Idumeapita, Jordán mayu chimpancunapita, nätan Tïro marcapitawan, Sidón marcapitas. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chaura Jesusga discïpuluncunatam “Camarishalata büquita carcayächiy, chay achca runacuna gotucarärimuptin gochraman yaycunäpag” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Chaychica runacuna capäcura achcata cuticächisha captinmi. Chaymi lapan gueshyagcunas Jesusta yatayuytarag munapäcura cuticasha capäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chaynuytan lutan espiritucunapa munayninchru cayag runacunas Jesusta ricapurga naupanman gongorpacuyur, gayacuypanuy: “Gamga Diospa-mayinmi cayanqui” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Chaynuy nipäcuptin Jesusga aliscam piñapara, Jesús pi cangantas mana masta rimapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaypitam Jesusga jegara jatun gotuman. Chaychrümi gayara quiquin munangannuy. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jinarcurmi nä Jesuscagman gotucaräriptinga, acrarun chrunca ishcayniyog runata, paywan capäcunanpag, jinaman ali willapata willapäcug cachrananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Paycunata cachrara “Runacunapita lutan espiritucunata gargapäcunquim” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay chrunca ishcayniyog acrangan runacuna capäcura caycunam: Simonmi, paytam Jesusga ‘Pedro’ nir jutinta chrurapura. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jinaman Zebedeopa churincunam, Jacobowan Juan. Paycunatas jutinta chrurapura ‘Boanerges’ nirmi. ‘Boanerges’ ninanga ‘Räyupa churi’ ninanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chaypitam cara, Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeopa churin Jacobo, Tadeo, ‘Cananista’ nipäcungan Simón, ");
INSERT INTO qvnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nätan Judas Iscariote. Paymi Jesusta wanuchipäcunanpag reguechira. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaypita cutirpamurmi Jesusga discïpuluncunawan yaycarärin juc wayiman. Jinarcurmi yapaytag chranin runacuna gotucarärimun. Chauraga manam nä micuytas atipapäcurachu achca runa captin. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chaypitam Jesuspa aylluncunaga “Jesusga löcusham cayan” nigta mayarärirga aywarärimunag aywachicurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nätan Moisés isquirbinganpita yachrachigcunam Jerusalenpita aywarärimunag, paycunam Jesuspag cay nipäcura: “Cay runaga cayan Beelzebú jutiyog Asyagpa munayninchrümi. Chaymi gargoyan lutan espiritucunata, chay mandag Beelzebú chaynuy rurananpag nisha captin”. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nipäcuptinmi Jesusga gayayur caynuypa tantiarachin: “¿Imanaypatag Asyagga gargonga lutan espiritucunataga? ");
INSERT INTO qvnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mä tantiachipäcushay: Juc nacionchru runacuna quiquincama raquicasha cawapäcur, mana ali cawayälarmi ushanacarärinman. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chaynuytan juc wayilachru runacuna chregninacur cawarsi, garganacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chaynuymi lutan espiritucunas quiquincama garganacurga ushanacarärinman. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Juc alisca calpayog runata manam pisi atipanmanchu imancunatas suwapayta, naupata chay calpayog runata watayurmi ichaga imantas apacunmanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mayapäcamay shumag: Tayta Diosga runacunapa lapan juchancunata perdonangam, ima-ayga lutanta Diospita rimasha captinsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nätan Santu Espiritupita lutanta rimagcagtam ichaga mana imaysi Diosga perdonangachüga. Chaycunaga chaynuy juchayoglam canga imaycamas”. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesusga chaynuypa nira, “Asyagpa munayninwanmi imatas rurayan” nipäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chaylam chrarärimun Jesuspa shulca wauguencunaga mamanwan Jesús cayangan wayiman. Jinarcurmi washalapita “Gayayäripamay” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chauraga Jesuspa muyurigninchru tayarcayagcunam willarärin: “Mamaymi shulca wauguequicunawan paniquicunawan washachru shuyararcayäshunqui” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nipäcuptinmi Jesusga nirun: “¿Pitag mamäga? ¿Nätan pitag wauguëcunaga panïcunaga?” ");
INSERT INTO qvnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nirga muyurigninchru tayarcayagcunata rircärircurmi nirun: “Caycunam nogapaga mamäsi, jinaman wauguësi panïsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chaura pisi Dios munanganta ruragcagmi nogapaga cayan wauguësi panïsi mamäsi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chaypita yapaytan Jesusga gochra manyanchru yachrachiyta galacuyun. Chayman alisca chranin runacuna gotucaräriptinmi, Jesusga jegarun gochrachru cayag büquiman. Jinarcurmi chaychru tacuyun. Nätan runacunaga lapansi quëdarärin gochra manyalanchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chay büquipitam achcata yachrachimura, imacunawansi tincuchiypa, cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mayapäcuy. Juc runam aywara murug. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nä wichiyaptinmi waquin muruga ishquirun camiñuman. Chaytam pishgocuna shamurga micarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquincag murum ishquirun shala shalaman. Chaychrüga rätum yargaramun mana aläpa alpan captin. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jinarcurmi inti acaramuptinga chaquirun mana sapin captin. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nätan waquincag murum ishquirun casha cashaman. Jinarcurmi cashacunaga chayrag wiñayämuglata garwashtarachin. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nätan waquincag murucunam ishquirun ali alpaman. Chaypitam ima-ayga shumag wiñarun, jinaman alisca gueshpirun. Waquinmi camacurun juc tullulachru quima chrunca muruta. Waquinmi camacurun juc tullulachru sogta chrunca muruta. Nätan waquinmi juc tullulachru camacurun pachrac muruta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chaynuy nircurmi cay nirun: “Mayacarcayämagcuna, tantiagcagga cäsucurcay” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chaypitam Jesús nä japalan quëdaruptinga, juc ishcay cayagcunaga chay chrunca ishcayniyog discïpuluncunawan, Jesusta tapurärin cay nir: “¿Imaninantag cayan chay tincuchiypa yachrachipäcamangayga?” ");
INSERT INTO qvnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nipäcuptinmi Jesusga cay nirun: “Gamcunataga Diosmi musyarcayächishunqui mana canancama pisi musyanganta. Chayga cayan Diospa munayninchru cawaymi. Nätan Diospa munayninchru mana cawagcunataga mana tantiayta munapäcuptinmi imacunawansi tincuchiypa yachrayächï. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chaynuy cagcunapita isquirbishachrüga cay niyanmi: Rircararcayarsi manam ricapapäcungachu. Nätan mayarcayarsi manam tantiapäcungachu, Diosmansi manam cutipäcungachu, ni juchancunapitas manatan perdonashas capäcungachu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nircurmi Jesusga cay nirun: “¿Gamcuna manachu tantiapäcunqui imawansi tincuchiypa yachrayächingäta? Chauraga ¿imanuyparag tantiapäcunqui imawansi tincuchiypa lapan yachrachinata?” ");
INSERT INTO qvnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Chay muruta wichig runanuymi cayan, Diospa ali willapanta willapacugga. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Chaura chay waquin mayacugcunaga capäcun anag camiñunuymi. Chaymi murunuysi cayag ali willapata mayacurayaptilan, Asyag shamurga lapan mayanganta gongarachin. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waquin mayacugcunaga capäcun shala shala chracranuymi. Paycunas mayacurcanmi ali willapata, jinaman chrasquicurcansi cushisham. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nätan chay murunuysi mana sapichacusha carmi mana awantapäcunchu imatas. Chaymi Diospa willapanta mayacurcanganpita chregnipapäcuptin, jinaman imas cunchuycunata pasapäcurga, juchaman ishquipäcun. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Waquin mayacugcunaga capäcun casha casha chracranuymi. Paycunas ali willapata mayacurcanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nätan cay pachachru ima-aygas rurayninman pinsiarmi, capogniyog car ima-ayganmansi yupachicuycunam, jinaman imansi cayaptin mastarag ashiyaycunam, ali willapata gongapäcun. Chaymi Dios ningannuyga mana cawapäcunchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nätan waquin mayacugcunaga capäcun ali chracranuymi. Paycunas ali willapata mayacurcanmi, jinamanmi chrasquicurcan. Chaypitam paycunaga Dios ningannuy alita rurayar cawapäcun. Paycunapita waquinmi capäcun juc murulapita quima chruncata camacushanuy, waquinmi sogta chruncata camacushanuy, nätan waquinmi pachracta camacushanuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Chaypitas cay niraran: “¿Juc michïru ratashata acäsu chruranchi cajón ruyimanchu u cäma pachranmanchu? Manam. Chaytaga chruranchi ricäpayninmanmi shumag achicyänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chauraga pacashanuy cay yachrachingäcuna cayagsi mas guepaman musyacasham canga. Nätan canan mana musyashacunas canga shumag tantiachisham mas guepamanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chauragar mayacarcayämagcuna cäsucurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chaypitas niraran: “Mayacurcangaynuy rurapäcuy. Chaynuy rurapäcurga noga ningäcunata mas tantiagmanmi muyupäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ningä razonpa chrasquicugcagtaga Diosga masmi yanapanga tantiayta. Nätan mana chrasquicugcagtaga ichicla mayacungalansi guechrusham canga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mastas Jesusga niraran: “Diospa munayninchru cawag runawan caynuymi ruracanga: Juc runa chracranman murururga, ");
INSERT INTO qvnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","pagaspa u junagpa, ricchayar punuyar carsi, manam musyanchu imanuypa chay muru chicchimungantas. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chaynuymi ruracan alpachrüga: Puntataga wiñamun guewanuylaran. Chaypitam masla wiñaruptinga ricacämun espïgan, jina guepantaran chay espïgaga rurugyämun alisca chranin. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chaura nä pogoruptinga chay runaga jüsiwanmi ruturun apapäcunanpag”. Chay muru alisca chranin wiñagnuymi rurapäcunga Diospa munayninchru cawag runacunas. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Chaypitas Jesusga niraran: “¿Imawantag tincuchichwan Diospa munayninchru cawag runacunata? ¿Imanirayantag? ");
INSERT INTO qvnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Paycunaga cayan nustäsa murunuymi. Chay nustäsa muruga lapan murucunapitas mas ichiclam. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nätan murunganchipita yargaramurga muyun jatun jachramanmi, canchrachru imas murushanchicunapitaga. Chaura rämancunas alisca jatunmanmi wiñan, jinaman cay pachachru pishgocunas gueshanta chaychru rurapäcunmi yachrapäcunanpag”. Chay muru chicchiramur alisca rämancuna wiñagnuymi Diospa munayninchru cawag runacunas capäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chaynuypam Jesusga ima-aygawansi tincuchiypa yachrachira, imanuysi mayacurcangannuy tantiapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Manam imatas yachrachigchu imawansi mana tincuchilarga. Nätan discïpuluncunataga japalancunatam chay yachrachingancunata shumag tantiachig. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay junaglam nä pacha chacayaptin Jesusga nirun discïpuluncunata: “Acu, aywashun cay gochra chimpata”. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chaylam runacunata “Aywalä” nircur, discïpuluncunaga aywachicurcan Jesusta chay büquilawan. Jinatam gatirapäcura chaychru waquin büquicuna cayagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nä aywarcayaptinmi gochrachru alisca walyayta galacuyun. Jinarcurmi chay walyaywanga yacus nä wiñacayara büquiman. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nätan Jesusga guepaman ashuyurmi punucarunag shumag jaunacuyur. Chaura discïpuluncunaga alisca manchacasham riccharärichin cay nir: “¡Yachrachig! ¡Ricchay, nämi talpuyanchi!” Chay niräriptin ");
INSERT INTO qvnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesusga sharcurcurmi chay walyaytawan yacutaga piñaparun cay nir: “¡Gasila cachracyay!” nir. Niptinga chayüram chay walyaysi, jinaman yacus amaynarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jinarcurmi Jesusga discïpuluncunata nirun: “¿Imanirtag gamcuna manchacararcayanqui? ¿Imanirtag mana yupachicarcämanquichu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nätan paycunaga Jesús chaynuy ruraptinmi alisca manchacasha quiquincama tapunacurcara: “¿Pitag cay runaga? ¿Paytaga gochras walyagsi cäsucuruntag?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chaypitam chrarärin chay gochra chimpan Gadara ninganman. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jinarcurmi nä büquipita Jesús yargoyaptilan panteonpita yargor chraramun lutan espiritupa munayninchru cayag runa. Chay runaga yachranag panteoncunalachrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Paytaga manash pisi cadenawan watarächiyta atipagchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Achca cutish watapäcura cadenacunawan maquintas chraquintas. Jinarcayaptinsi tipiypash usharug cadenacunataga. Chauraga nä manash pisi chay runata imanaytas atiparachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nätan chay runaga pagaspas junagpas gapachracuyarshi purig, gotucunapas panteoncunapas rumicunawan chancacuyar. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chaura Jesusta carupita ricapururga piryay piryarmi chraramun. Jinarcurmi, Jesuspa naupanman gongorpacuyun, ");
INSERT INTO qvnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","gapachracuypanuy cay niyar: “¿Imanarayanquitag nogawan, jana pachachru cayag Diospa-mayin Jesús? Diospa naupanchrümi manacuyag amar cunchuchimaychu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chaynuypa lutan espirituga rimara, “Cay runapita yargoy” Jesús nä nisha captinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chaura Jesusga “¿Imatag jutiqui?” nirmi tapurun. Chaura lutan espirituga nirunmi: “Nogapa jutïga ‘Chraninmi sogta warangapita mascasca’ capäcuptï”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nircurga Jesustam manacurun alisca, chay Gadarapita mana jucläman gargonanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chauraga cayara achca cuchicunam micurcayar chay carcayangan tunapa. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jinarcurmi chay lutan espiritucunaga manacarärin cay nir: “Wac cuchicunaman yaycapäcunäpag niyärimay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chaura Jesús “Äri” niruptinga, chay lutan espiritucunaga runapita yargorcur cuchicunamanmi yaycarärin. Chay cuchicuna capäcura ishcay waranganuymi. Jinarcurmi löcu ricacarärir waraupa jegarparärin gochraman. Chaychrümi shengaypa wanurärin lapan. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chaynuypa cuchicuna wanuräriptinga, cuchi michig runacunaga manchacasham gueshpicurcan, pitas maytas willapacurcayar marcacama. Chaura runacunaga juclam aywarärimun ricag. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nä Jesús cayanganman chrarärirga lutan espiritucuna chay löcuchingan runataga tarirärin nä fisyun chrämushatam, jinaman jacusha tayayagtam. Chaynuyta ricarur runacunaga aliscam manchacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nätan chay aywamusha runacunataga, chay ricagcunam willaparärin, chay runapita imanuypa lutan espiritucuna yargongantas jinaman cuchicunapitas. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chaypitam chay runacunaga Jesusta cay nirärin: “Cay marcäcunapitanar jucläta aywacuy”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chaura Jesús nä “Äri” nir büquiman jegayaptinmi, chay cuticächingan runaga “Aywashunnar nogawansi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Niptin Jesusga manam munarachu. Antis cay nirunmi: “Wayiquita castaycunaman aywacuy. Paycunata willapämuy lapanta Munayniyog Dios alisca cuyapäshurlay munayninwan lutan espiritucunata gampita yargonganta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Niptin chay runaga aywacunmi. Chaypitam galayurun willapacuyta Decápolis ningan marcacunapa Jesús paypita lutan espiritucunata gargonganta. Nätan mayagcunaga lapansi mayacasha niragmi ricacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaypitam caylä chimpaman nä büquiwan Jesús cutiramuptinga, paycagman chranin runacuna gotucarärimun, nätan payga nä cayara gochra manyanchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chaymanmi chraramun Jairo jutiyog runa. Payga cara Israel castacuna gotucurcänan wayichru mandagcuna castam. Jinarcurmi chay runaga Jesusta ricaparurga naupanman aywarcur gongorpacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Chaypitam manacura alisca cay nir: “Wariwamrämi nä wanunayan. Aywaläshunnar yatayuruptiqui cuticarurga cawanangam”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chaura Jesusga aywacun Jairowanmi. Chay aywaptinmi chranin runacuna guepanta aywapäcura chumi chumi. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay runacunachrümi aywanag juc gueshyag warmis. Payga nä gueshyanag chrunca ishcayniyog watam yawar apaywan. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chay gueshyawan mana ali carshi, achca jampicugcunachru purira jampichicuyta. Jinayälarshi lapan ima-aygantas usharura. Nätan manash maygalansi cuticächirachüga, antis waranpa waranpash masta chruracayara. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Payga aywaramunag Jesuspita rimagta mayarshi. Jinarcurshi Jesuspa guepanman yaycura runacuna chraupinpa, Jesuspa jacunta yatayunanpag, ");
INSERT INTO qvnNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","shongolanchru cay niyar: “Jacunta tupayularsi cuticäshagmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chay ningannuylash yatayuruptinga chayüra yawarga illacarura. Chauraga chaylash mayacurun nä cuticasha cayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chayüram Jesussi tantiarun munayninwan juc runa cuticächinganta. Jinarcurmi runacunaman muyurcamurga tapurun: “¿Pitag jacüta tuparaman?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Niptinmi discïpuluncunaga cay nirärin: “Chumi chumi aywayashachu, ‘¿Pitag tuparaman?’ niyanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Chaura Jesusga chay muyurigninchru cayag runacunatam rircapayta galacuyun pi tupangantas musyananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chaura warmiga cuticasha canganta nä musyarga, manchacasham chucchucyayar, Jesuspa naupanman gongorpacuyur willacurun tupayular cuticanganta. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chaura Jesusga nirunmi: “Wamralä, cuticäshagmi nir yupachicamarmi cuticarunqui. Chaura cananga aywacuy cushisha”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Chay niyaptilanmi Jairopa wayinpita cachramushacuna chrarärimun cay nir: “Yangam pushayanqui yachrachigtaga. Wamrayga nämi wanurun”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chay nigta mayarurmi Jesusga Jairota cay nin: “Ama manchacaychu. Yupayla yupachicamayga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chaura Jesusga Jairopa wayinta aywarga pusharicura Pedrotam, nätan ishcay wauguelatam Jacobotawan Juanta. Chaypitacagtaga manam munarachu pi aywanantas. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nä Jairopa wayinman chrarurga, tarirun wamra wanushapita gapachracuypa äyay äyar wagarcayagtam. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chaura Jesusga wayiman yaycurcurmi cay nirun: “¿Imanirtag chaynuypa wagarcayanqui? Wamraga punucashalam cayan. Manam wanushachu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Niptinmi runacunaga asiparärin. Chaura Jesusga wayipitam gargorun lapanta. Chaypitam yaycurun chay wanusha wamra cayanganman quima discïpuluncunalawan, jinaman wamrapa taytanwan mamanwan. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chauraga wamrapa maquinta chariyurmi arameo rimaychru cay nin: “Talita, cumi”. (‘Talita, cumi’ ninanga ‘Wamra, ¡sharcuy!’ ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Niptin wamraga chayüram sharcurcur puriyta galacuyun. Chay wamra cara chrunca ishcayniyog watayogmi. Chaura chaynuy ruragta ricarärir runacunaga mayacasha niragmi ricacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Chaypitam Jesusga chruncay chruncay nira mana pitas willapacurcänanpag, jinamanmi nira wamrata micuyta garapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaypitaga discïpuluncunawanmi Jesusga cutira marcanta. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jinarcurmi jamana junag chraramuptinga Israel castäcuna gotucarcänan wayiman yaycurcur yachrachira. Chaychrümi mayacugcunapita achca runacuna mayacasha nirag ricacarärir tapunacurcara cay nir: “Lapan caycunata ¿maychrütag yachracurura cay runaga? ¿Pitag yachrarachin caynuypa? ¿Imanaypatag imatas rurayan mana pisi rurananta? ");
INSERT INTO qvnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Cay runaga cayan carpintërulatag, chay Mariapa wawalantag. Caypaga wauguencunas cayan Santiagotag, Josëtag, Judastag, Simontag, nätan panincunas caychrütag carcayan”. Chay nirmi Jesusta mana cäsupapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chaymi Jesusga cay nin: “Maychru chaychrüsi Diospa willacugnincunaga alipag ricasham capäcun. Nätan manacagpag ricashaga capäcun marca-mayincunapitam, castancunapitam, wayinchru cagcunapitam” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chaura Jesusga runa mana ruray atipänanta, manam imatas rurarachu chay marcanchru. Cuticächiraga juc ishcaylatam, chay gueshyagcunaman maquinta chrurayur. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chaura Jesusga mayacasha niragmi ricacarura chay runacuna “¡Imanaypatag payga canga Dios cachramunganga!” nipäcuptin. Chaura Jesusga purira chay Nazaret marca muyurigninpam, acapa marcacunachru yachrayächir. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chaypitam Jesusga chrunca ishcayniyog discïpuluncunawan gotucarärin. Jinarcurmi paycunata cachrara wacpa caypa ishcaypacama, cay nircur: “Cananga gamcunam runacunapita lutan espiritucunata gargapäcunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nircursi cay nirunmi: “Amam chay aywapäcur apapäcunquichu ni micuytas ni guellaytas ni guepicurcänaytas apapäcunquichu. Antis garrotilayta janchraricurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jinamanga “Jatirarcayangay languelaycunawan aywapäcuy, ama müdanaytas apapäcuychu. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","May wayichrüsi gorpachapäcushuptiqui, chaylachrümi capäcunqui jucläta aywapäcungaycama. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nätan maychrüsi mana chrasquipäcushuptiquiga, jinaman mana mayacuyta munapäcushuptiquiga, ‘Cananga nämi willarärig, imanuysi cawacurcay, manam mastaga cayman jarumushagchu’ nirmi aywacurcanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesús chaynuy yachrarcachiptinga, discïpuluncunaga aywacurcara runacunata cay niyarmi: “Juchaycunapita wanacurcur Diosman cuticarcämuy” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nätan achcatam lutan espiritucunatas gargapäcura runacunapita, jinaman aceitiwan lushichrärilarmi achca gueshyagcunata cuticächipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodessi mayarunagmi Jesuspita munayninwan ima-aygatas rurayanganta. Jinaman mayanagta “Cayga Bautizag Juanchri fiju cawacarayämun. Chaymi ima-aygatas rurayan munayninwan” nipäcugtas. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nätan waquin runacunam nipäcug: “Payga Diospa willacugnin Eliasmi cayan” nir. Jinaman waquinmi nipäcura: “Payga cayan Diospa willacugninchri u maygansi Diospa unaycag willacugninchri” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chaynuy nipäcugta mayarmi Herodesga ninag: “Chay runaga fiju mogoypa wanuchingä Juanmi cawacarayämun”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chay Herodespa wauguen cara Felipem. Nätan Herodesga wauguen Felipepa warmin Herodiaswanmi ishcaychacusha canag. Chaypitam Juanga “Juchatam rurayanqui, amam wauguequipa warmintaga warmichacunquimanchu” nir piñaparura. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chay ninganpitam Juantaga cadenarcachir carcelman wichrgachira. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chaypitam Herodías warmisi chregniparura Juantaga. Jinarcurmi wanurachiylata munag, nätan manam atiparachüga. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodesga manchacuram Juanta, alita rurag runa jinaman mana juchaynag canganta musyar. Chaymi payga Juanta washag. Nätan Juan rimapaptinga manam imanänansi yachracarachu. Chaynuy jinayarsi Juan rimangantaga cushisham mayacug. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Chay warmi wanuchiyta munayaptilanmi Herodespa diyasnin chraramura. Chaymi payga micapäcura Galileachru, manday yanapagnincunawan, waranga soldädu mandagcunawan, jinaman chay Galileachru alinninpag ricasha runacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nä lapan micapacurcayaptinmi Herodiaspa jipashninga yaycurcur tushuyta galacuyun. Jinarcurmi chay tushunganga Herodestawan, chaychru cayag runacunataga, alisca cushicarachin. Chaura Herodesga jipashtam cay nin: “Imatas munangayta manacamay gonagpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Diospa naupanchrümi niyag, manam casquipagchu, imatas manacamangaytam goshayqui. ‘Mandayangay nacionpa lamitäninta gomay’ nimaptiquis goshaymi” nira. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chaura jipashga jucla mamancagta aywarcurmi tapurun: “¿Imatatag manashag?” Niptinmi mamanga nirun: “Manay Bautizag Juanpa umanta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaypitam jipashga wayrala chay Herodes cayanganman cutiyurcurga nirun: “Nogaga munayä pasay-pacha Juanpa umanta juc matichru camashata gomänaytam”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Niptinga aliscam laquicurun Herodesga. Nätan chaychru lapan carcayagcuna juracunganta mayasha captinmi mana atiparachu “Manam” niytaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chaura juclam Herodesga cachrarun juc soldäduta Juanpa umanta cuchurcur apamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Cachrangannuylam soldäduga carcelta aywarcur Juanta mogorcur umanta aparamun matichru camashata. Nä chrarachimurga jipashtam gorun. Nätan jipashga mamantam gorun. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chayta mayarärirga Juanpa discïpuluncunaga, chrarcamurmi wanushata apacurcur aywacurcan enterrag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaypitam Jesús cachrangan discïpuluncuna cutirärimurga gotucarärin Jesús cayanganman. Jinarcurmi willaparärin lapanta ima rurapäcungantas, nätan imata yachrachipäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chaura paycagman chranin runacuna aywapäcamuptinmi, jinaman paycunacagpita aywacurcaptinmi timpuncuna mana carachu ni micapäcunanpagsi. Chaymi Jesusga nirun discïpuluncunata: “Acu aywashun chunyag pampata chaychru jamananchipag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Niptinga aywacurcara chunyag pampatam büquiman jegarcur. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nä Jesús discïpuluncunawan may aywayangantas tantiarärirga, chaychru cayag marcacunapitam wayrala aywapäcura chraquiypa. Jinarcurmi Jesús nä chränanpagga naupanchru carcayänag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chaura Jesusga büquipita nä yargoyarga ricapurun achca runacunatam. Jinarcurmi paycunata cuyaparun uysha wichicashanuysi mana michigniynag capäcunganpita. Chaychrümi yachrachira achcata ima-aygapitas. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chaura nä inti jegarpunayaptinmi discïpuluncunaga Jesusman ashuyur cay nirärin: “Nämi pacha chacanayan. Caychrüga cayanchi chunyagchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","‘Aywacurcay’ niy runacunata, estanciacunapa, nätan acapa marcacunapa micuynin rantig aywapäcunanpag jinaman micapäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nipäcuptinmi Jesusga nirun: “Gamcuna micuyta gopäcuy”. Niptinga cay nirärinmi: “¡Chaura micachipäcunäpagga tantata rantipäcamushag puwag quillachru juc runa gänanan golguepagragchri! Chaura mana cayaptinga ¿maypitatag golgueta jorgapäcamushag?” ");
INSERT INTO qvnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nipäcuptinmi Jesusga “¿Ayga tantatatag chararcayanqui? Mä ricapäcamuy” nirun. Nä ricarärimurga cay nirärinmi: “Cayan pichga tantawan ishcay pescädulam”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaura Jesusga discïpuluncunatam nirun: “Guewa pampaman runacunata iscatacurcay punta punta” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nipäcungannuylam iscatarärin runacunaga, pachraccama, pichga chruncacama. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chaura Jesusga pichga tantatawan, ishcay pescäduta aptacurcurmi jana pachaman rircacurcur “Cayta aypachinar” nirun Diosta. Jinarcurmi tantacunata partichrarcur gorun discïpuluncunata, iscatararcayag runacunata aypupäcunanpag. Chaynuytan chay ishcay pescädutas aypurärin lapan runata. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chaychru lapansi micarärin yamapäcungancamam. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jinarcurmi shuntarärin pescäduwan, tanta catupacurcanganta, chrunca ishcayniyog balay juntata. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chaychru micugcuna capäcura pichga warangam olgola. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaypitam Jesusga discïpuluncunata nirun chimpa Betsaida marcaman büquiman jegarcur naupacurcayänanpag. Nä aywarcayaptinmi Jesusga runacunata “Aywacurcay” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chaypitam nä runacuna aywayta usharäriptinga aywacun juc gotuman Tayta Dioswan rimag. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nä pacha chacashaga discïpuluncuna aywarcayara gochra chraupitam. Nätan Jesusga japalanmi cayara chay gochra patan gotuchru. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chaypitam Jesusga ricapurun discïpuluncuna büqui aywachiy nacatacurcayagta, naupapita alisca walyamuptin. Jinarcurmi pacha warayman Jesusga yacu jananpa aywayara paycunacagta. Chaypitam nä tariparcurga yaligtucura. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Chaytam discïpuluncunaga ricaparärin, jinarcurmi “Almachr wacga” nir, alisca manchacasha gapachracuyta galacayärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chayta mayarmi Jesusga jucla paycunata cay nir rimaparun: “¡Ama manchacapäcuychu! Valorchacurcay, nogam cayä”. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nircur büquiman jegaruptilanmi walyayga pasay amaynarun. Chaura discïpuluncunaga mayacasham ricacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paycunaga chayta ricayarsi, jinaman chaychica runata munayninwan tantata micarayächiptinsi, manam tantiapäcurachu Jesús Diospita shamusha canganta. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chauraga nä Genesaret ninganman chrarärirga gochra manyanchrümi büquita watarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jinarcurmi büquipita yargarärimuptilan runacunaga reguerärin Jesusta. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chaura Jesusga marcan marcanmi purira chay Genesaretchru. Chaymi runacunaga gueshyagnincunata aywachipäcura quirmaypacama maymansi Jesús cayanganman. ");
INSERT INTO qvnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nätan acapa marcachrüsi, u acray marcachrüsi, u estanciapitas Jesús aywanganmanmi gueshyagcunata jorgapäcug, camiñumansi pläzamansi “Jaculaytas yatayushagnar” nipäcunanpag. Nätan nipäcungannuylam yatayugcagga cuticapäcug gueshyancunapita. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chaypitam Jerusalenpita chrarärimun Jesuscagman fariseocunawan, juc ishcay Moisés isquirbishanpita yachrachigcuna. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Paycunam ricarärin Jesuspa juc ishcay discïpuluncuna Moisés isquirbingannuy maquinta mana maylacular micurcayagta. Chay maquinta mana maylacular micuy paycunapagga cara juchäcuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nätan fariseocunawan lapan Israel castacunas unay awilluncunapa costumbrintam rurapäcug. Paycunaga micapäcunanpag maquincunataran awilluncuna ningannuysi maylacurcag, nätan mana maylacularga manam micapäcugchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Paycunaga rantipäcurcanganpita cutimursi maquincunata mana maylacularga manam micapäcugchu. Paycunapaga achcam costumbrincuna cara, imanaypa väsuncunata, jarruncunata, mancancunata, cämancunata, maylapäcunanpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chauraga chay fariseocunawan, Moisés isquirbishanpita yachrachigcunaga Jesustam tapurärin: “¿Imanirtag discïpuluycuna micapäcunanpag mana maquincunata maylacurcanchu unay awillunchicunanuy?” ");
INSERT INTO qvnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nipäcuptinmi Jesusga cay nirun: “Gamcuna alitucugcunapita, alitam Diospa unay willacugnin Isaías rimara cay nir: Cay runacunaga janan shongolam, ‘Payga alim’ nipäcun nogapita. Nätan ‘Manam’ nipäcun lapan shongonpachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‘Diospagmi rurayä’ nir, yangalam ima-aygatas rurapäcun. Nätan yachrachipäcunsi runa-mayin rimangalantam, ‘Dios ninganmi caysi’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chaynuymi gamcunas Dios mandangancunata gongayur, imatas rurarcayanqui unay awilluycuna nipäcungalanta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nircursi cay niraran: “Gamcunaga ‘Dios ruray’ nipäcushungayta manacagpag ricarmi, quiquiquicuna nipäcungalayta rurarcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nätan Moisespa isquirbishanchrüga ‘Taytayta mamayta alipam ricanqui’ ninmi. Nätan ‘Taytanta mamanta mana alipag ricagga, wanuchisha cachun’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nätan gamcunaga yachrarcayächinqui cay niytam: ‘Taytay mamay, “Yanapämay” niptin, manam yanapagmanchu. Nogaga ima-aygätas Diostam gosha cä’ niytam. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chaynuypaga yachrarcayächinqui taytanta mamanta mana pasay yanapänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chaynuy nir, gamcunaga Dios ninganta manacagpagmi ricarcayanqui, nätan juc costumbriquicunataga maymaytachr rurarcayanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chaypitaga chay achca runacunatam yapay Jesusga cay nirun: “Lapay mayapäcamay, jinaman cay ningäta shumag tantiapäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Manam imas micapäcunganchu runataga juchäcachin, antis illag rimangancuna shongonpita yargamugmi runataga juchäcachin”. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nircur runacunapita Jesús aywacurga wayimanmi yaycurun, chaychrümi tapurärin discïpuluncunaga chay yachrachinganpita. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chaura Jesusga cay nirunmi: “¿Gamcunas manachu tantiapäcunquirag? Shumag tantiapäcuptiquiga, ‘Ima-ayga micuysi manam runataga juchäcachinchu’. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Micuyga manam yaycun shongomanchu antis pachramanmi, chaypitaga ishpamunchim”. Chaynuypaga nira lapan micuycunas mana juchäcachicug captinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chaypitas niraran: “Antis lutan rimanganmi runataga juchäcachin. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chauraga runapa shongonpitam yargamun, lutan pinsiaycuna, chay olgon olgon, warmin warmin cawaycuna, suwacuycuna, runa wanuchiycuna, warmiyog gowayog cayarsi jucwan cayaycuna, ");
INSERT INTO qvnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jucpa imantas munayaycuna, ima-ayga juchas rurayaycuna, casqui rimayaycuna, mana pengacular imatas rurayaycuna, chriquicuyaycuna, jucpa washanta rimayaycuna, olgotucuycuna, warmitucuycuna, gotaranuysi lutan rurayaycuna. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lapan caycuna yargamun runapa shongonpitam. Chaycunam runacunataga juchäcachin”. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaypita yargor Jesusga aywacura Tïro ninganpam, jinaman Sidón ninganpam. Nä Tïroman chrarurmi, Jesusga juc wayiman yaycurun. Nätan payga manam munarachu paypita pi musyanantas. Chaynuy mana munayaptinsi musyaräriram. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chaymanmi chrarun juc casta warmi. Payga canag Sirofenicia nacionpitam. Paypaga warmi wawanmi cara lutan espiritupa munayninchru. Chauraga Jesuspa naupanman gongorpacuyurmi manacurun cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","“Tayta, wawäpitanar lutan espirituta gargolay” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chaura Jesusga cay nirunmi: “Naupataga Israelpa castancunataran yanapashag. Nätan canan gamta yanaparga, Israelpa wamrancunapag tanta cayagta algocunata gararugnuychri rurarushag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Niptin warmiga nirunmi: “Au tayta. Algocunas micapäcunmi chay wamrancuna micur ishquipäcungalantaga”. Chaura Jesusga ninmi: ");
INSERT INTO qvnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Alitam nirunqui. Cuticuy, nämi lutan espirituga yargorun wamraypita”. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chauraga nä wayinman chrarurga tarirun wamrantaga cämachru jamayagtam. Jinaman nä lutan espíritu dëjashatam. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chaypitam nä Tïropita yargorga, Jesusga aywara Sidonpa, chay Sidonpitam Decápolis ninganpa aywamura jatun gochra Galilea ninganman. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chaymanmi chrarärichimun juc runata. Payga canag upam, jinamanmi cacshu, jinarcurmi manacarärin Jesusta upapa jananman maquinta chrurananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chaura Jesusga chay runacunapita jucläman pushayurmi, upapa ishcaynin rinrinman dëdunta jatiyurun. Jinarcurmi dëdunman togarpuyur upapa gallunta tupayurun. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chaypitam jana pachata rircärir alisca laquisha “Efata” nirun. ‘Efata’ ninanga cara ‘Quichracay’ ninanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Niptinga chayüram upapa rinringa quichracarun, nätan gallunsi watashanuy cayanganpitam rimayta galacuyun shumag. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chaura Jesusga “Amam pitas willapäcurcanquichu” nirunmi. Nätan paycunaga masran willapacurcashas. ");
INSERT INTO qvnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jinarcurmi runacunaga alisca cushisha cay nipäcura: “Alitam rurayan lapantas. Upacunatas cuticayächin mayananpag, nätan mana rimay atipagcunatas rimayächinmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chay junagcunalam yapay, achca runacuna gotucarärin Jesuscagman. Jinarcurmi runacuna micanasha capäcuptin Jesusga discïpuluncunata gayarcur cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cuyapayämi cay runacunata, nä quima junagnintinmi caychru carcayan nogawan mana imatas micular. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jinalata ‘Wayiquicunata cuticurcay’ niptïga, camiñuchrüsi malagashaga lamsuräringachr. Waquinga aywararcayämun carupitam”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Niptinmi discïpuluncunaga cay nirärin: “¿Maypitatag jorgamushun caychica runapagga micuyta, cay chunyag pampachrüga?” ");
INSERT INTO qvnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nipäcuptinmi Jesusga tapurun: “¿Ayga tantalatatag chararcayanqui?” Niptinga “Ganchrislatam” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chauraga lapan runacunatam nirun pampaman tayucurcänanpag. Nä tayaräriptinga ganchris tantata aptacurcurmi “Cay tantatar aypachiy Tayta” nirun. Jinarcurmi partircur partircur gorun discïpuluncunata, runacunata aypupäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jinamansi charapäcuratan ishcay quima acapa pescäducunatas. Chaycunapitas Tayta Diosta manacurcurga “Caytas aypupäcamuy” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chauraga lapanmi micarärin yamapacungancama. Nätan puchugcunatam shuntarärin ganchris balay juntata. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chaychru micapäcura runacuna chruscu waranganuymi. Chaypitam Jesusga “Aywacurcay” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chaylam paysi discïpuluncunawan aywacun büquiman yaycurcur Dalmanuta ninganpa. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chauraga fariseo nipäcungan runacunam Jesusman aywarcamur juchäcachiyta munar cay nirärin: “Jana pachapita shamungayta musyapäcunäpag, mä munayniquiwan rurayuy imalatas”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nipäcuptinmi Jesusga alisca laquisha cay nirun: “¿Imanirtag cay runacuna munan munaynïwan imatas ruraypa reguechicunäta?” Chay nircurmi cay nin: “Mayapäcamay shumag: Gamcuna ricapäcunaypag manam munaynïwan imatas rurashagchu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nircurga büquinman yaycurcurmi aywacun waclä chimpa gochra manyanman. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chay aywarmi tanta aparicuyta gongarärinag. Charapäcunagga juclay tantalatam. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jinarcurmi discïpuluncunata Jesusga cay nirun: “Shumag mayapäcamay: Fariseocunapa jinaman Herodespa levadurancunapita cuidacurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Niptin discïpuluncunaga quiquincamam cay ninacarärin: “Tantata mana apamunganchipitam niyämanchi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chaynuy ninacurcayanganta tantiarurmi Jesusga nirun: “¿Imanirtag rimarcayanqui: ‘Manam tantata charanchichu’ nir? ¿Imanirtag mana tantiacug runa, jinaman rumi shongo capäcunqui? Nogaga niyä fariseocuna lutan yachrachipäcunganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Gamcunaga ricayarsi mana ricagnuymi carcayanqui. Nätan mayayarsi mana mayagnuymi carcayanqui. ¿Manachu yarpapäcunqui ");
INSERT INTO qvnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","pichga waranga runacunapag pichga tantalata aypäshingäpita? ¿Ayga balay juntatatag shuntapäcuray chay puchupäcunganta?” Niptinga “Chrunca ishcayniyogtam” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nätan “Ganchris tantata chruscu waranga runacunapag aypäshingäpita, ¿ayga balay juntatatag shuntapäcuray?” Niptinga “Ganchristam” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chaura Jesusga nirunmi: “Chayta ricararcayarsi ¿manaragchu tantiapäcunquirag?” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaypitaga chrarärira Betsaida marcamanmi. Chaychru Jesús cayaptinmi chrarärichimura ñausha runata, “Tayta, yatayulaynar ricapunanpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chauraga janchracurcurmi Jesusga pushara marcapita washaman. Chaychrümi togayninwan ñawinta lushiyur, jinamanmi ñawinta yatayur tapura: “¿Imalatas ricapuyanquichu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Niptinmi ñaushaga nira: “Au ricapuyä runacuna purircayagtam, nätan ricapuyäga monticunatanuylam”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Niptin Jesusga yapaymi ñaushapa ñawinta yatayur “Rircäriy” nin. Chaylam ñaushaga shumag ricapun, caruchru cagcunatas lapanta. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chaura Jesusga “Ama marcaman cutiyuychu, ni pitas willapacuypishchu cuticächingagpita. Antis aywacuy wayiquita” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaypitam Jesusga discïpuluncunawan aywacun Felipe mandangan Cesareachru acapa marcaman. Jinarcurmi camiñupa aywarcayar tapura discïpuluncunata: “¿Pimi nircayämantag runacuna?” ");
INSERT INTO qvnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chaura paycunaga nirärinmi: “Waquinga ‘Bautizag Juanmi’ nircayäshunquim. Waquinmi ‘Diospa willacugnin Eliasmi’ nircayäshunqui. Nätan waquinga maygansi cayan ‘Diospa unay willacugninchri’ nircayantan”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nipäcuptin Jesusga quiquincunatam tapura: “Gamcunaga, ¿pimi nipäcamanquitag?” Niptin Pedroga nira: “Gamga cayanqui ‘Salvacugtam cachramushag’ Dios ninganmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chaynuy niruptinmi Jesusga “Nä pi cangätas musyarcayarga ama pitas willapacurcaychu” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaypitam Jesusga discïpuluncunata cay nin: “Noga jana pachapita shamusha runaga alisca cunchuchisham cashag. Jinamanmi alinninpag ricasha chacha runacunapita, sacerdöticunapa mandagnincunapita, nätan Moisés isquirbingan yachrachigcunapita, manacagpag ricasha cashag. Nätan wanuchipäcamanganpita quima junagtaga cawacämushagmi” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chaura chay pasananta shumag willaruptinmi Pedroga jucläman Jesusta pushayur cay nirun: “Ama munaychu chaynuy rurapäcushunaytaga” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nätan Jesusga discïpuluncunacagman muyurcurmi Pedrota piñaparun cay nir: “¡Ashucuy nogapita Asyag! Gamga runa munangannuyla ruranätam munayanqui, manam Dios munangannuy ruranätaga tantianquichu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nircurga discïpuluncunatawan chaychru carcayag runacunata gayarcurmi cay nirun: “Gatirämay munagcagga, pisi shongon munangannuyla ruray munayanganpita amachacuchun. Jinaman ima-aygata cunchursi noganuy cawapäcuchun wanuchisha canan captinsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pisi noga raygo mana cunchuy munagga, manam nogawan cawangachu. Nätan pi maysi noga raygo, jinaman ali willapa raygo wanunan captinsi cunchugmi ichaga, nogawan cawanga imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chaura runaga ¿imatarag jorgonman paylapa cay entëru pacha capuptinsi, jana pachachru Dioswan mana cawan cayaptinga? ");
INSERT INTO qvnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Imatarag Diosta gorunman jana pachachru paywan cananpag? ");
INSERT INTO qvnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pisi juchasapacunapa naupanchru nogapita, nätan rimangäcunapita pengacugtaga, noga jana pachapita shamusha runasi paypita pengacushagmi, Dios-mayïcagpita mana juchäcug angelcunawan shamunä junagga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chaypitas niraran: “Mayapäcamay shumag: Waquin caychru cayagcuna manaran wanupäcungaragchu, Munayniyog Dios mandananpag aywamunganta tantiapäcungancama”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chaypitam nä sogta junag pasashachru Jesusga, Pedrota Jacobota Juanta pushacurcur aywacura juc altunnin jircata. Chaychrümi paycuna rircararcayaptin Jesusga muyurun jucnuyman. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jacunmi muyurun alisca chipchipyayag jancanuy yuragman. Cay pachachru manam alinnin jacu tagshacugsi chaynuy allanyagman muyuchimanchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jinarcurmi chaychrüga ricacarärin Diospa unay willacugnincuna Eliaswan Moisés, Jesuswan rimarcayar. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Chaura Pedroga Jesustam cay nira: “Yachrachig, alipagchri nogacunaga caychru carcayä. Rurarärishag quima chuclata, jucta gampag, jucta Moisespag, jucta Eliaspag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chaynuy nira Pedroga manchacaypita mana imanänansi musyacaptinmi, nätan chaynuy manchacasham capäcura waquincagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaura paycunataga pucutaymi uranparcamur chaparun. Jinarcurmi chay pucutashachru cayar Dios cay ninganta mayarärin: “Cay Jesusga Dios-mayïmi. Pay ninganta cäsucurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nigta mayar ricachracurcarga manam ricapapäcurachu pitas, antis ricaparärin Jesús japalantam. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nä chay jircapita cutirparcayämuptinmi Jesusga nirun: “Amam pitas chay ricapäcungayta willapacurcanquichu. Willapacurcanquiga noga, jana pachapita shamusha runa wanurcur cawacaramuptïran”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ningannuylam mana pitas willapacurcarachu, antis quiquincamam cay ninacurcara: “¿Imatag chay wanushapita cawacämuyga?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chauraga tapurärin Jesustam: “Moisés isquirbinganpita yachrachigcunaga ¿imanirtag nipäcun ‘Puntataga shamunga Eliasran salvacug shamunanpagga’ nir?” ");
INSERT INTO qvnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nipäcuptinmi Jesusga nirun: “Au, razonpas Eliasga puntatam shamunan cara, runacunata ‘Camaricurcay’ ninanpag, jinaman payga nämi aywamusha. Chaura Dios isquirbichinganchrüga ¿imanirtag ‘Jana pachapita shamusha runa cunchuchisham, jinaman runacunapita mana chrasquisham canga’ niyan? ");
INSERT INTO qvnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nätan nämi nirärig Elías shamunganpitaga. Paytaga nämi runacuna munanganta rurapäcusha, isquirbishachru ningannuysi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nä pampaman chrarparärimurmi, Jesusga tarirun waquin discïpuluncunata achca runacunapa chraupinchru, Moisés isquirbinganpita yachrachigcunawan tapunacurcayagta. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chaura Jesús yaycuyagta ricaparärirga manchacarärinmi. Chaypitam buryay buryar aywarärin Jesuscagta “¿Alilachu cayanqui?” nig. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chaura Jesusga tapurunmi: “¿Imapitatag tapunacurcayaray paycunawan?” ");
INSERT INTO qvnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Niptinga juc runam chay achca cayagpita nirun: “Yachrachig, olgo churïtam pusharayämü gamman, paytaga lutan espiritum mana rimachinchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jinarcurmi maychru cayaptinsi chay lutan espirituga mayänipita pampaman sagtan. Jinamanmi pogosayta jächuchimun. Nätan quiruntam gapapayla cachruchin. Chay jinayaptilanmi nä pasay agrayansi. Discïpuluycunata nämi manacurü churïpita chay lutan espirituta gargonanpag. Nätan paycunaga manam gargoyta atipapäcunchu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Niptinmi Jesusga nirun: “¡Diosman mana yupachicug runacuna! ¿Imaycamarag gamcunawan cashag? ¿Imaycamarag gamcunata awantapäcushay? ¡Cayman pushamuy chay walashta!” ");
INSERT INTO qvnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Niptinga pusharärinmi. Nätan Jesusta chay lutan espíritu ricapururga walashtam wanuparachira. Jinamanmi pampachru gochrpachira pogosay jächuyämugta. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chaura Jesusga tapurun walashpa taytantam: “¿Imaypitatag caynuy jinayan?” Niptin taytanga “Tacsala canganpitam” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Nätan achca cutim chay lutan espirituga quitichisha ninamansi yacumansi wanuchinanpag. Chauraga ¿cuticarachinquimanchur? cuyapayärimaynar nogacunata”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Niptinmi Jesusga nirun: “¿Imanirtag ‘Cuticarachinquimanchur’ niyämanqui? Yupachicugcunapagga lapanmi ima-aygas ruracan”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Niptin walashpa taytanga chayüram gayachracuypanuy cay nirun: “Au tayta, yupachicuyagmi. Yanapayämay mas yupachicug canapag” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nä achca runacuna gotucayämuptinmi Jesusga chay lutan espirituta piñaparun cay nir: “¡Runata upachig, runata mana rimachig lutan espíritu, yargoy cay walashpita! Nätan ama yaycuypishchu payman yapayga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Niptin lutan espirituga gapachracuyarmi yapay wanuparachin walashta. Jinarcurmi yargorga dëjarun wanushatanuy. Chaynuyta ricarurga achca runam “Nämi wanurun” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nätan Jesusga maquinpitam chutarcaramun, chaylam walashga shayurun. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaypitam Jesusga wayiman yaycurun discïpuluncunawan. Chaychrümi discïpuluncunaga Jesusta tapurärin cay nir: “¿Imanirtag nogacuna chay lutan espíritu yargachiyta mana atipapäcüchu?” ");
INSERT INTO qvnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nipäcuptinmi Jesusga nirun: “Chaynuy lutan espirituga manam imanuypas yargonchu, antis chayga yargon Diosninchita manacusharan”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chaypita yargorga aywacurcan Galilea ninganchru marcacunapam. Chaypa aywarcayanganta Jesusga manam munarachu pi musyanantas. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Payga discïpuluncunata cay nir yachrayächirmi aywara: “Noga jana pachapita shamusha runaga cashag lutan runacunapa maquinman jitayusham, jinaman paycunapita wanuchisham, nätan quima junagtaga cawacämushagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chay ninganta discïpuluncunaga manam tantiapäcurachu. Nätan tapucuytaga manchapäcuratan. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nä Capernaum marcaman chrarurga. Wayiman yaycurur Jesusga tapurun juc ishcay discïpuluncunatam: “¿Imatatag gamcuna, camiñupa aywayämur alisca rimapäcuray?” ");
INSERT INTO qvnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Niptinga upälalam capäcura. Nätan camiñuchrüga rimapäcura: “¿Mayganchirag mas alinninpag ricasha cashun?” nirshi. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaura Jesusga tayucuyunmi. Jinarcurmi chrunca ishcayniyog discïpuluncunata gayarcur cay nirun: “Maygansi alinninpag ricasha cayta munagga, manacagpag ricacuchun, jinaman lapanpa servigninrag cachun”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nircurga juc olgo wamratam lapanpa chraupinman pusharun. Jinarcurmi walashta macalicurcur discïpuluncunata cay nin: ");
INSERT INTO qvnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Pisi cay walashnuysi cayagta servigga, nogatam serviyäman. Nätan nogata servimagga manam nogalatachu serviman, antis cachramagnïtas serviyanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chaypitam discïpulun Juanga Jesusta cay nirun: “Tayta, juc runatam ricarärï gam rurangaynuy lutan espíritu gargoyagta. Nätan noganchiwan mana puriptinmi nogacunaga ‘Ama ruraychu mastaga’ nirärï”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chaynuy niräriptinmi Jesusga nirun: “Ama chaynuypa nipäcuychu. Pisi noga rurangänuy imatas ruragga, manam nogapita lutanta rimanchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Noganchita mana chregnimagninchiga cayan yanapämagninchim. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pisi noga ningänuy, jinaman nogapa capäcungaypita juc täza yaculatas gopäcushuptiquiga, manam yangalaga cangachu, antis chay runata razonpam yanapäshag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nätan pitas nogaman yupachicur ali rurayagcunata juchäcachigtaga, alim canman jatun tunayta cuncanman watayur gochraman jitayapäcuptinsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nätan maquiqui juchäcachishuptiquiga, alichr canman cuchuruptiquis, cutulas jana pachaman yaycunaypag, ishcay maquiyog nina wayichru imaycamas rupayänaypitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Jinaman chraquiquis juchacächishuptiquiga, alichr canman cuchucuruptiquis, jana pachaman yaycucunaypag, ishcay chraquiyog nina wayichru rupayänaypitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chaynuytag ñawiqui juchäcachishuptiquis jorgoruy. Antis alim canqui chulan ñawilaywan Diospa munayninman yaycursi, ishcay ñawiyog nina wayichru rupayänaypitaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chaychrüga curucunas manam wanunchu, ni manatan ninas upinpishchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Lapaysi aliga capäcunqui cachrichrashanuysi, jinaman rupachishanuysi capäcurniquiran. ");
INSERT INTO qvnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Alim cachriga. Nätan cachri gamyaruptinga, ¿imawanrag yapay puchgogman muyuchichwan? Chaura gamcunaga cachrichrashanuy capäcuy, jinaman cawapäcuy ali piwan maywansi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chaypitam Capernaumpita yargor Jesusga aywara Judea ninganpa, Jordán mayu chimpapa inti yargamunancagpa. Chaychrüsi yapaytam runacunaga gotucarärin Jesús cayanganman. Paysi yapaytan yachrachira imaysi yachrachingannuy. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chaypitam fariseocunaga ishcay quima ashuyarärin Jesusman, lutanta rimachipäcunan raygo. Chauraga tapurärin cay nirmi: “Olgo runa warminta wicapar ¿alitachu ruran?” ");
INSERT INTO qvnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nipäcuptinmi Jesusga nirun: “Moisesga isquirbishanchru ¿imanircayäshunquitag?” ");
INSERT INTO qvnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chaura Jesustaga cay nirärinmi: “Pisi warminta wicapagga raquinacungan papelta rurarcapur jitarichun” niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chaura Jesusga cay ninmi: “Moisesga chaynuy isquirbira unay awilluycunapita-pacha Dios nipäcushungayta mana rurayta munapäcuptiquim. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nätan Diosga galayunanchru chay ima-aygatas camar, camara olgowan warmitam. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chaymi olgoga taytanpita, mamanpita, raquicarcur ishcaychanga warmiwan. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chauraga ishcaynin capäcunga juclay runanuylam. Chaynuypam mana ishcaychu capäcunga, antis juclaynuylam. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chaymi Dios ishcaychächingantaga mana pi runas raquingachu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nä wayichru carcayaptinmi discïpuluncunas Jesusta tapurärin warmi wicapaypita. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tapuräriptin Jesusga cay ninmi: “Warminta wicaparcur, juc warmiwan ishcaycharga juchäcuyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chaynuytan warmis gowanta wicaparcur, juc olgowan ishcaychacurga juchäcuyantag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chaypitam runacunaga Jesusman pusharärin wamrancunata, yatayur paycunapa janan manacunanpag. Nätan discïpuluncunaga wamra pushamugcunatam piñaparärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chayta ricar Jesusga piñäcurunmi. Jinarcurmi cay nirun: “Ama jarcapäcuychu. Jina wamracuna nogaman aywacarcämuchun. Paycunanuy cagcunam Diospa munayninchrüga carcayan. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Shumag mayapäcamay: Pisi juc wamranuy Diospa munayninman mana yaycugga, manam Dioswan cangachu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jinarcurmi wamracunata margarcurun jucta jucta. Chaypitam wamracunapa jananman maquinta chrurayur manacura: “Tayta Dios yanapäshunqui” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jinarcurmi Jesús nä yargonanpag cayaptin, juc runa wayrala aywarcamur gongorpacuyun paypa naupanman, cay nir tapucunanpag: “Alisca ali yachrachig, ¿imatatag ruräman Dioswan imaycamas cawanäpag?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Niptinmi Jesusga nirun “ ‘Ali’ nirga, ¿alitam niyanqui? Aliga juclaylam, chayga Diosmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gamga musyayanquim, Dios caynuy ninganta: Runa-mayiquita amam wanuchinquichu. Amam mansibacunquichu. Amam suwacunquichu. Amam runa-mayiquipag yangacagta rimanquichu. Amam casquicunquichu. Taytayta, mamayta, alipa ricay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Niptinga chay runaga nirunmi: “Yachrachig, chay lapan niyangaytaga cäsucusha cä wamra cangäpita-pacham”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaura Jesusga chay runata shumagpam rircärin, jinarcurmi nirun: “Juclaylaga ruranay caturayanran. Cuticuy, jinaman lapan imaytas ranticurcur gomuy mana imaynagsi runacunata. Chaynuy rurarga jana pachachrümi imaycamas cawanqui Dioswan. Chayta rurarcur cutimuy, jinaman noganuy caway”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nigta mayarga pasaymi jucagyarun. Jinarcurmi laquisha aywacura, alisca capogniyog car. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chaura Jesusga muyurigninpa ricachracurcurmi discïpuluncunata cay nirun: “Capogniyogcunapagga alisca sasam Diospa munayninman yaycuyga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Niruptin discïpuluncunaga mayacasham ricacarärin. Chaura Jesusga yapatan nirun: “Alisca sasam Diospa munayninman yaycuy, chay ima-ayganmansi yupachicugcunapagga. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chaymi nï: Aujapa rinrinpa juc camellu ningan uywasi ushturunmanmi sasalataga, juc capogniyogmi ichaga alisca sasatarag Diospa munayninman yaycun”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chaynuy nigta mayarga mas mayacasham ricacarärira discïpuluncunaga. Jinamanmi quiquincama tapunacarärin: “Chaynuy captinga, ¿pirag salvacunga?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaura Jesusga paycunata rircärirmi cay nirun: “Runacunapagga sasam salvacuy. Nätan Diospaga manam sasachu ima-aygas”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Niptinmi Pedroga cay nin: “Nätan nogacunaga dëjasham capäcü lapan ima-aygäcunatas gamta gatirapäcunagpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Niptinmi Jesusga cay nirun: “Shumag mayapäcamay: Gamcunaga razonpam dëjararcayanqui noga raygo, jinaman ali willapa raygo, wayiquicunata, wauguequicunata, paniquicunata, taytaycunata, mamaycunata, churiquicunata, chracraycunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Chaymi gamcunapa chrasquipäcunqui cay pachachru pachracpacama wayicunatas wauguecunatas panicunatas mamacunatas wamracunatas chracracunatas chay gaticachrasha capäcur, jinaman mas guepamanga Dioswanmi imaycamas cawapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nätan achcam canan alipag ricashacuna, manacagpag ricasha capäcunga. Nätan manacagpag ricashacunas, achcatan alipag ricasha capäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chauraga Jerusalén marcaman nä aywarcayaptinmi, Jesusga discïpuluncunapa naupanta aywacun. Chaymi discïpuluncunaga “¿Imanayantag?” nir, mayacasha nirag gatirapäcura. Jinaman mas waquin gatiragcunas manchariyarmi aywapäcura. Chaura Jesusga jucläman chay chrunca ishcayniyog discïpuluncunata gayarcurmi willarun ima pasananpitas cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Cananga musyarcayangaynuysi Jerusalentam aywayanchi. Chaychrümi noga jana pachapita shamusha runaga, jitayusha cashag sacerdöticuna mandagcunapa maquinman, jinaman Moisés isquirbinganpita yachrachigcunapa maquinman. Paycunam ‘Wanuchisha cachun’ nipäcamanga. Chaypitam mana Israel castacunapa maquinman jitayapäcamanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Paycunam lutanpaypa turyapapäcamanga, togapapäcamanga, astipäcamanga, jinaman wanuchipäcamanga. Nätan wanuchipäcamanganpita quima junagtaga cawacämushagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chauraga Zebedeopa churincunam, Jacobowan Juan, Jesusman ashuyur cay nirärin: “Yachrachig, manacuytam munarcayag, amar manam nipäcamaychüga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nipäcuptinmi Jesusga tapurun: “¿Imatatag munarcayanqui?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chauraga nirärinmi: “Ali shumag mandanaypag yaycururnar nipäcamay, jucnï derëchayman, nätan jucnï ichogniquiman tayupäcunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nipäcuptinmi Jesusga cay nirun: “Gamcuna manam musyapäcunquichu imata manacarcayämaytas. Nogataga cunchuchipäcamangaran, jinaman wanuchisharan cashag. ¿Chaynuy rurapäcushuptiqui awantapäcunquichur?” ");
INSERT INTO qvnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chauraga cay nirärinmi: “Au, awantapäcushagmi”. Niräriptinmi Jesusga cay nirun: “Au, razonpam gamcunaga cunchuchisha, jinaman wanuchisha capäcunqui noga yupaysi. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nätan derëchäman, jinaman ichognïman tayachiyga manam nogapa munaynïchrüchu. Chayga nä cayan juccunapagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chaynuy nigta mayarärirga waquincag chrunca discïpulucunaga piñäcarärinmi, Jacobopag, jinaman Juanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chaura Jesusga lapanta gayayurmi cay nirun: “Gamcuna musyarcayangaynuysi, waquin nacionchru reycunaga, mandapäcun juyunaypam, jinaman chay manday yanapagnincunas chaynuytan runacunata mandapäcun. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gamcunachrüga ama chaynuy cachunchu. Nätan maygaysi mandag cayta munagga lapaycunapa servigniquicunarag cachun. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nätan maygaysi gamcunachru mandag cayta munagga, juc rantisha runanuyrag cachun. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Noga jana pachapita shamusha runasi manam aywamurä servisha canäpagchu, antis servigmi. Nätan servishagga wanungäpam achca runacuna Asyagpa munayninchu cayanganpita salvasha cananpag” nin. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chaypitam chrarärin Jericó marcaman. Nä chay marcapita Jesusga discïpuluncunawan, jinaman chranin runacunawan yargorcayaptinmi, ñausha runaga tayayänag camiñu manyanchru runacunata manacuyar. Pay cara Bartimeo jutiyogmi, Timeopa churin. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nätan Jesusga cara Nazaretpitam, jinarcurmi pay aywayagta mayarurga, gayachracurun cay nir: “¡Rey Davidpa castan Jesús, cuyapayälämaynar!” ");
INSERT INTO qvnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Niptinmi runacunaga piñaparärin “Upäla cay” nir. Niräriptin ñaushaga lapan calpanpam gayaräcun: “¡Rey Davidpa castan Jesús, cuyapayälämaynar!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaura Jesusga ichriyanganpita shayuyurmi gayachimura. Chaura chay gayamugcunaga nirärinmi: “¡Sharcuy! ¡Yupachicuy! Jesusmi gayayäshunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chayüram ñaushaga catantas jitarircur wayrala Jesusman aywarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chaura Jesusga cay nirmi tapurun: “¿Imatam munayanqui?” Chaura ñaushaga ninmi: “Yachrachig, ñawïtar cuticayächiy, yapay ricapuytam munayä”. ");
INSERT INTO qvnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Niptinmi Jesusga nirun: “Aywacuy, yupachicamangaypam cuticarunqui”. Niruptilanmi ñaushaga ricapurun, jinarcurmi Jesuspa guepanta aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nä Jerusalén marcamanmi nachrgarcayara. Chaypitam manas Betfagëman jinaman Betania marcaman chrälar, chay Olivos ningan gotu chraquinpita, Jesusga cachrarun ishcay discïpuluncunata, ");
INSERT INTO qvnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","cay nir: “Aywapäcuy wac chimpachru ichic marcalaman. Chayman chrarur taripäcunqui juc ashnu watarayagtam, chay ashnutaga manaran pisi logacusharagchu. Chayta cachrarircur aywachipäcamuy. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pisi ‘¿Imapagtag cachrariyanqui?’ nipäcushuptiquiga, ‘Munayniyogmi logacunanpag munayan. Chaypitaga cutirachimungam’ nipäcunquim”. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Niptin aywarga tarirärin juc püllu ashnutam wayi puncu camiñuchru watarayagta. Jinarcurmi pasquirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chaura chaychru ishcay quima cayag runacunam nirärin: “¿Imapagtag chay ashnuta cachrarirärinqui?” ");
INSERT INTO qvnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chay nir tapuräriptin paycunaga Jesús ningannuymi nirärin. Chaura pay niyaptinga “Aywachipäcuy” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jinarcurmi discïpuluncunaga aywachicurcan Jesuscagman. Chaypitam catancunata suwadïruräriptin Jesusga logacurun. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nä aywayaptinmi achca runacuna catancunata mashtayta galacayärin camiñuman. Nätan waquin runacunam rämacunata muturcur muturcur mashtapäcura camiñuman. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nätan Jesuspa puntanta, jinaman guepanta aywagcunam, cushicuypita gaparäcurcan cay nir: “¡Paymi cayan salvamagninchi! Alisca ali nisha cachun Munayniyog Diosninchi cachramungan. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ali nisha cachun mandananpag aywayämug, munayniyog taytanchi Davidpa castan. Payga chraramun jana pachapitam salvamänanchipag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jinarcurmi nä Jerusalenman chrarur Jesusga aywara Diospa wayinta. Chaychrümi ima-aygatas ricachracurcur aywacura Betania marcata nä pacha chacanayaptin, chrunca ishcayniyog discïpuluncunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chaypitam warantinga Betaniapita nä aywarcayaptin Jesustaga micanarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chauraga carupitam ricapurun yürasapa hïgos montita, jinarcurmi aywacun ricag, “Pagta mishquin canmansi” nir. Chayman chrarurga manam tarirachu mishquinta, antis yüralantam, mana mishqui wayuy wichan captin. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chauraga discïpuluncuna mayarcayaptinmi Jesusga chay montita cay nin: “Cananpitaga manam pisi micungachu gampa mishquiquita”. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chaypita Jerusalenman chrarärirmi Jesusga yaycurun Diospa wayinman. Jinarcurmi chaychru ranticugcunatawan, rantipacugcunata gargorun. Chaypitam golgue trucagcunapatawan, palöma ranticugcunapa mësancunata ticpay usharun. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jinarcurmi Jesusga mana munarachu Diospa wayinman imatas ranticug apapäcunanta. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jinarcurmi yachrachira cay nir: “Diospa isquirbishanchru ningannuysi: ‘Wayïga canga Dioswan rimana wayim, lapan nacioncunapita shamug runacunapagsi’. ¡Nätan gamcunaga suwacunapa machrayninmannuymi muyurärichinqui!” ");
INSERT INTO qvnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesús chaynuy ninganta mayarärirga sacerdöticunapa mandagnincunawan, Moisés isquirbinganpita yachrachigcunam rimanacarärin “¿Imanaypatag Jesusta wanuchishun?” nir. Wanuchiyta manchapäcuraga lapan runacuna Jesús yachrachinganta alipa chrasquipäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nätan Jesusga discïpuluncunawan nä pacha chacanayaptinmi chay marcapita aywacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chaypitam warantin goya discïpuluncunawan Jesús pasayar ricaparärin chay hïgos montita nä sapincama chaquishata. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chaura ganyannintin Jesús rimanganta yarparurmi Pedroga cay nin: “Yachrachig, wacta rircariy. ‘Cananpitaga manam pisi micungachu gampa mishquiquita’ ningay hïgos montim nä chaquisha”. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Niptinmi Jesusga nirun: “¡Diosman yupachicurcay! ");
INSERT INTO qvnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cayta shumag mayapäcuy: Pisi Diosman yupachicur, cay jircata ‘Caypita yargorcur wac jatun gochraman jegayuy’ niptin jegayungam. Nätan ‘Ruracangachur icha manachur’ niptinga manam ruracangachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chaymi noga nipäcug: ‘Payga gomangam’ nir gamcuna Diosta manacurcarga, nä chrasquishanuymi capäcunquiman, payga gopäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nätan Diosta manacurcayar, pisi lutan rurapäcushungayta yarparurga perdonapäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chauraga jana pachachru Dios Taytaycuna gamcunatas juchaycunapita perdonapäcushunquim.” ");
INSERT INTO qvnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chaypitam Jerusalenman yapay cutiyurur Jesusga Diospa wayinchru puriyara. Jinarcurmi payman ashuyarärin sacerdöticuna mandagcunawan, Moisés isquirbinganpita yachrachigcuna, jinaman Israel castachru alinninpag ricasha chacha runacuna. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chauraga Jesustam tapurärin cay nir: “¿Maygan munayniyogtag cayanqui? ¿Pitag nirushunqui chaycunata ruranaypag?” ");
INSERT INTO qvnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nipäcuptinmi Jesusga nirun: “Gamcunatasi juclaylata tapuyärishay. Tapungäta nipäcamaptiquiga, nogasi nipäcushaymi, pi nimaptin rurayangätas. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Chauraga Bautizag Juanta, ¿pitag bautizänanpag cachramura, Dioschu u runacunachu? Mä nipäcamay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Niruptinga quiquincamam galacayärin cay ninacuyta: “ ‘Diosmi cachramusha’ nirushaga ‘¿Imanirtag payta mana chrasquicurcaraychu?’ niramäshunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nätan ‘Runacunam cachramusha’ niytaga manam munapäcurachu, chay achca runacunata manchacur. Paycunaga lapanmi musyapäcura Bautizag Juan Diospa willacugnin razonpa canganta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chaura Jesustaga “Manam musyapäcüchu” nirärinmi. Chaura Jesusga “Nogasi manam nipäcushaychu pi nimaptin chaycunata rurangätas” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chaura Jesusga tincuchiypam rimayta galayucuyun cay nir: “Juc runam üvas malquita tarpurcur chracranta guenchrarun. Jinarcurmi jatun muchrcata rurarun üvaspa yacunta jaruypa jorgonanpag. Chaypitam törritanuy pergarcur, chaychru chuclata rurarun chracranta täpananpag. Chaynuy rurarcurmi ishcay quima uryag runacunata arrendacurcur aywacura caruta. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chaypitam nä üvas palay wichan chraramuptinga, chay chracrayogga cachrarun juc rantisha runanta chay chracra arrindupita manamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jinarcurmi chay chracrayogpa rantisha runan chraruptinga, chay uryag runacunaga charicarärin magapäcunanpag. Chaypitam magarcärirga jinalata cutirärichin. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chauraga yapay juc rantisha runantatan chay chracrayogga cachrarun. Chaytaga umantam paquirärin. Jinarcurmi alisca ashlirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chaura chay chracrayogga yapaytan cachraruntag juc rantisha runanta. Nätan paytaga wanurärichiram. Chaypitas cachraratan achca runancunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Paycunapita waquintam magarärira, nätan waquintam wanurärichira. Chauraga juclaylam puchurayara cachrananpag. Chayga cara japalan cuyay churinmi. Chauraga paytam cachrarun ‘Churïtaga manchacurcangachr’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nätan chay uryag runacunaga quiquincamam rimanacarärin cay nir: ‘Wac churinmi taytanpa ima-ayganwansi quëdanga. Antis paytaga wanurachishun chracran noganchipa cananpag’. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nipäcungannuylam chay churintaga charicarärin, jinarcurmi wanurärichin. Chaypitam chay wanushataga chracrapita jucläman wicaparärin”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chaynuypa willaparcurmi Jesús tapurun: “¿Imatarag ruranga chay chracrayog runa chay arrendacungan runacunata? Payga aywarcamurchri wanurachinga. Jinarcurmi chracranta juc runacunata gonga uryapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gamcuna manachu tantiapäcunqui Dios isquirbichinganchru cay nishata: ‘Wayipa cimintunta ruragcunam “Cay rumiga manam välinchu” nir wicapapäcusha. Chay wicapasha rumim cananga chruracarun wayipa esquinanman lapan tapyata awantänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Munayniyogninchim chaynuy rurarun, chaymi noganchiga cushisha cayanchi’ nishata”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chaura chay mandagcunaga paycunapita tincuchiypa yachrachinganta tantiarärirga, Jesusta wanurachiylatam munapäcura. Nätan mana wanuchipäcurachüga chay achca runacunata manchacurmi. Chaymi yargor aywacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaypitam Jesusman cachrarärin ishcay quima fariseocunatawan, Rey Herodespa gatiragnincunata, imalatas lutanta rimarcachir juchachapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nä Jesusman chrarärirga cay nirärinmi: “Yachrachig, nogacuna musyarcayämi runacuna imata nircayaptinsi mana cäsur, razoncaglata yachrachingayta. Gamga manam runacunapa cäranta rircarirchu imatas ruranqui, antis gamga yachrayächinqui razoncagtam Dios munangannuy cawanapag. Mä nipäcamay: ¿Pägapäcümanchu icha manachu patentita, Roma nacionchru munayniyogta?” ");
INSERT INTO qvnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Chaura Jesusga lutan rimachiy munarcayanganta tantiarurmi cay nirun: “¿Imanirtag juchaman ishquichiyta munarcayämanqui? Mä golgueta apapäcamuy ricanäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chaura nä golgueta ricarcurmi cay nir tapurun: “Cay golguechru, ¿pipa cärantag cayan?, jinaman ¿pipa jutintag isquirbirayan?” nir. Chaura paycunaga cay nirärinmi: “Romachru munayniyog Cesarpam”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nipäcuptinmi Jesusga nirun: “Cesarpa cagtaga Cesarta gopäcuy. Nätan Diospa cagtaga Diosta gopäcuy”. Niptinga mayacasham ricacarärin chay runacunaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaypitas Jesusman aywapäcuratan ishcay quima runacuna, saduceo nipäcungan. Paycunaga “Manam wanushacunaga cawacämunchu” nipäcunmi. Chaymi tapucurcara cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yachrachig, Moisespa isquirbishanchru cay ninmi: ‘Pisi warmiyog, mana churinsi captilan wanuruptin, chay wanushapa shulca wauguenmi ishcaychacunga chay warmiwan, wanushapa churin cananpag’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Chauraga ganchris wauguecunam capäcura. Mayorcagmi ishcaychacusha. Jinarcurmi wanurura manaragsi churin captilan. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chauraga shulcancagmi ishcaychacura chay warmiwan. Jinarcurmi chaysi wanusha manaragsi churin captilan. Chaynuytan chaypa shulcancagsi wanurura. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chaynuypam ganchrisnintin ishcaychacurcasha chay warmiwan. Nätan churinga manatan mayganpas carachu. Jina guepantaga warmis wanusham. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chauraga wanushacuna cawacapäcamuychrüga ¿mayganpa warminta canga ganchrisnintinwan ishcaychacurayaptinga?” ");
INSERT INTO qvnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nipäcuptinmi Jesusga nirun: “Gamcunaga pantacasha carcayanqui isquirbishacunata mana tantiarmi, jinaman Dios munayniyog canganta mana musyarmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chay wanushacuna cawacapäcamurga manam nä ishcaychacurcangachu, antis capäcunga jana pachachru Diospa angelnincunanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nätan wanushacuna cawacapäcamunanpitaga ¿gamcuna manachu leyipäcuray Moisés isquirbinganchru? Chay garajanchray rupayagpita Diosga rimamura cay nirmi: ‘Nogaga cayä cawayag Abrahampa Isaacpa Jacobpa Diosninmi’. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chaymi Diosga cawayagcunapa Diosnin, manam wanushacunapachu. Chaura gamcunaga pasaypa pantacasham carcayanqui” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chaura Jesusta ali ninganta mayarurmi Moisés isquirbinganpita yachrachig runaga, Jesuspa naupanman ashuyur tapucurun cay nir: “Dios ruray nimanganchicunapita ¿maygantatag naupataga cäsucuchwan?” ");
INSERT INTO qvnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Niptinmi Jesusga nirun: “Dios mandangancunachru mas väligga cäsucunapag caymi cayan: ‘Mayapäcuy Israel casta runacuna: Munayniyog Diosninchiga, japalaylan munayniyogmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Paytaga cuyanqui lapan shongoypam. Chaynuy cuyarga alila ruraytam munanquis, paylatam yarparanquis, jinaman paylapagmi imatas ruranqui’ niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nätan guepancagmi cay nin: ‘Runa-mayiquita cuyay quiquiqui cuyacungaynuy’. Cay ishcayninmi cayan mas naupata ruranapag Dios ningancunachru”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chauraga Moisés isquirbinganpita yachrachigga cay nirunmi: “Yachrachig, alitam nirunqui. Au, juclaylam Diosga. Manam canchu paypita juc masga. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nätan lapan shongopa cuyayga, paylaman yarparayga, paylapag imatas rurayga, Diosta cuyayga alim. Nätan runa-mayinchita quiquinchitanuy cuyayga mas alinninmi cayan, uywacunata wanurcachir altarchru rupachiypitaga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chaura Jesusga ali rimayanganta mayaparurga cay nirunmi: “Nämi pasay nachrgarayanqui Diospa munayninchru canaypag”. Chaynuypa Jesús niruptinga manchariräriram. Chaymi mana pisi tapuparachu mastaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chaypitam Jesusga Diospa wayinchru yachrayächir cay nir tapurun: “¿Imanirtag Moisés isquirbinganpita yachrachigcuna ‘Diospa acrashan Cristoga Davidpa castanpitam canga’ nipäcun? ");
INSERT INTO qvnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nätan Davidga Santu Espíritu rimachiptinmi cay nira: ‘Munayniyog Diosmi nira munayniyognïta: “Tayucuy derëchäcagman, lapan chregnishugniquicunata munayniquiman chruramungäcama” nira’. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Chauraga quiquin Davidsi ‘Munayniyognï’ niyaptinga, ¿imanuypatag Diospa acarashan Cristoga canga Davidpa castan aywaglaga?” Jesús chaynuy ninganta alisca achca runam cushisha mayacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Chaychru yachrachirmi Jesusga cay nirun: “Cuidacurcay Moisés isquirbingan yachrachigcunapitaga. Paycunaga aliscam munapäcun sulway sulway jacusha puriyta, jinaman munapäcunsi runacunapita pläzacunachru saludasha caytam. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chaynuytam paycunaga gotucarcänan wayichrüsi punta puntachru tayucuyta munapäcun. Nätan micapäcurcänanpag gotucarsi ashipäcun alinnin runa tayucurcänancagtaran. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nätan viüdacunapa imalancagtas guechrupäcunmi, jinarcurmi alisca unay Diosta manacugtucurcan runacunapita alipag ricasha capäcunanpag. Chaynuy rurapäcunganpita paycunaga mas cunchuchisham capäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jucpaychrümi Jesusga golgue jitayucurcänan chimpanchru tacuyur rircarara imanuy shongonwan golgue jitayupäcungantas. Chaychrümi achca capogniyogcuna chranin golgueta jitayucurcan. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chaymanmi chrarun mana imaynag viüdasi. Payga ishcay acapa golguelatam jitayurun, jamaycama gänanalata. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chaura Jesusga discïpuluncunatam cay nirun: “Shumag mayapäcamay: Waquin runacuna jitayunganpitaga mastam jitayurun cay mana imaynag viüdaga. ");
INSERT INTO qvnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nätan pi maysi jitayupäcun puchuglantam. Cay viüdam ichaga mana imaynag cayarsi jitayurun lapanta, chayla rantipäcunanpag cayagta” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jinarcurmi nä Diospa wayinpita yargorcayaptinga juc discïpulun Jesusta cay nin: “Yachrachig rircäriy, ¡cay wayilagä caynuy shumag, jatun rumicunawan rurasha!” ");
INSERT INTO qvnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Niptinmi Jesusga nirun: “Au, shumag rircäriy cay rurashata. Nätan caycunaga lapansi juchruchisham canga, manam quëdangachu juc rumipa jananchru ni juc rumilas”. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaypitam Jesusga Olivos ningan gotuman nä chrarurga tayayara. Chayga cara Diospa wayin chimpanmi. Chaychrümi Pedroga, Jacoboga, Juanga, Andresga juc läduman gayayur yachraylapa Jesusta tapurärin cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Willapäcamaynar. ¿Imaytag chayga ruracanga? Chay ruracänanpagga ¿imatag canga naupataga?” ");
INSERT INTO qvnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nipäcuptinmi Jesusga cay nirun: “Cuidacurcay pisi pantacarärichishunquimantag. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achcam shapäcamunga ‘Nogam cayä Diospa acrashan Cristo’ nir. Chaynuy casquicur achcatam pantacächipäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nätan gamcunaga amam manchacapäcunquichu ‘Guërrash cayan’ nigta mayarsi, u ‘Guërrash canga’ nipäcuptinsi. Chaynuyran razonpa canga. Chaynuy captinsi manaran ushacanan junagragchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Juc nacionmi guërrachru canga juc nacionwan. Chaynuytan juc reysi runancunawan guërrata ruranga juc reyta runantinta. Jinamanmi maychru chaychrüsi juyupa pacha cuyunga. Nätan micuy wanaycunas cangatan. Chaycuna canga cunchuycunapa galarinalanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nätan cuidacurcay, gamcunaga mandagcunapa maquinman chrächisham capäcunqui, nogaman yupachicurcangaypita. Jinaman Israel castacuna gotucarcänan wayicunachrüsi magapäcushunquim, nätan chrächipäcushunquitan reycunapa, jinaman manday yanapagnincunapa naupanmansi. Chaychrümi nogapita ali paycunatas willapapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nätan cay pacha ushananpagga ali willaparan willapacanga lapan casta runachru. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chaura mandagcunaman aywachipäcushuptiqui, ama laquirapäcuychu ‘¿Imatarag nishag?’ nir, antis rimapäcunqui Dios chayüra rimachipäcushungalaytam. Chaychrüga manam gamcunachu rimapäcunqui, antis Santu Espiritum. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Juc runas wauguenpag ‘Cay wauguëta wanuchipäcuy’ ningam. Chaynuytan taytacunas churinpag ‘Cay churïta wanuchipäcuy’ ninga. Jinaman churicagcunas lutanpag taytancunata ricar wanuchipäcungam. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Chaynuypam nogapa janä lapan runacunapitas chregnipasha capäcunqui, nätan pitas chay cunchuycunachru ushanancama shayapäcugtam Diosga salvanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Chaura Diospa willacugnin Daniel ningannuysi, Diospa wayinman mana chruranancunata chrurapäcungam. Chayta leyir shumag tantiapäcuy. Chaynuy ruracaptinga Judeachru cagcuna gueshpipäcuchun jircacunapa. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nätan chayüra wayin jananchru pi cayagsi, ama wayinman yaycuchunchu ‘Imalätas jorgaramushag’ nir, antis jinala aywacuchun. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chaynuytag imaman aywasha carsi, ama cutichunchu ni catan apagsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ay! chay wichan imanapäcungarag chrichru warmicuna, jinaman acapa wawayogcuna. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chaura Diosta manacurcay tamya wichanchru mana chaycuna cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay wichan alisca juyu cunchuymi canga. Chaynuyga manam cay pachata Dios camanganpitas canragchu, ni manatan imaysi cangapishchu. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nätan Munayniyog Dios, chay alisca juyu cunchuyta mana wayrala pasachiptinga manam pisi salvacunmanchu. Antis Diosga chay acrasha runancuna raygom, chay alisca cunchuy wichancunata wayrala pasachinga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chauraga pisi ‘Caychrümi cayan’ u ‘Wacchrümi cayan Diospa acrashan Cristo’ nipäcushuptiqui ‘Amam razonchri’ nipäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nätan aywapäcamungam runacuna ‘Nogaga Cristom cayä’ nir, jinaman ‘Diospa willacugninmi cayä’ nirsi, chaycunaga runacuna mana ruray atipänantam rurapäcunga ima-aygatas. Chaynuy rurapäcunganwan pantacächipäcungam runacunatas, hastaran Diospa acrashancunatas pantacächipäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nätan gamcunaga mayag mayagla cacurcayay. Noga willarcayag manaragsi chaycuna ruracaptilanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Chauraga chay alisca juyu cunchuy usharuptilanmi intis yanauyarunga, jinaman quillasi manam achicyämungachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nätan goyllarcunas ishquipäcamungam. Chauraga jana pachachru cay pachachru ima-ayga cayagcunas aliscam cuyunga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaypitaran lapan runa ricapapäcamanga, noga jana pachapita shamusha runata pucutaychru alisca munayniyog, jinaman ima-ayga shumag achicyayar aywayämugta. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jinarcurmi angelnïcunata cachrashag cay pachaman. Paycunam maypitas chaypitas acrashäcunata nogaman gotupäcamunga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hïgos montipita yachracurcay. Nä rämancuna llulluyämuptin jinaman raprancuna chicchimuptin, musyarcayanquim nä usya wichan nachrgayämunganta. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chauraga canan yachrarcayächingag nä ruracagta ricarga, tantiapäcuy nä aywamunä nachrgayämunganta u nä wayï puncuchrünuy cayangäta. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Razonpam niyä: Canan cawarcayag runacuna manaragsi wanupäcuptilanmi cay lapan nipäcungagsi ruracanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jana pachasi cay pachasi ushacangam, nätan noga ningäcunaga lapanmi ruracanga. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Chay ushanan junagpitaga Tayta Dioslam musyan, imay junag, imayüra chay lapan ningäcuna ruracänantas. Chaypitacagga manam musyanchu, jana pachachru angelcunasi ni noga, Diospa-mayinsi. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chaura imayüra ruracänantas mana musyayarga cacurcayay mayag mayagla Dioswan rimayälar. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Juc runachu caruta aywacunman wayinpita, servignincunata ‘Imalätas ricayanquim’ nircur, jinaman ‘Jucpacama imantasi rurarcayänanpag’ nircur. Chaypita wayin täpacugta ‘Mayag mayaglam cayanqui wayïpita’ nircur. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chaura chay runacunanuynar gamcunas cacurcayay pasay camaricushala, wayiyog imay chrämunantas mana musyarcayarga. Capazmi chraramunman pacha chacarpuruptilansi, u chraupi pagassi, gallo wagaysi, u pacha warashasi. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mayänipita aywamur punucashata mana taripäcushunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gamcunata ningänuymi lapan runacunatas niyä: Chaura mayag mayagla jinaman ningänuy rurarcayar cacurcayay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chauraga ishcay junaglam faltayara Pascua fiestapag, jinaman mana levaduraynag tantata micunapagsi. Nätan sacerdöticunapa mandagnincunawan Moisés isquirbinganpita yachrachigcunam rimanacarärinag yangapita juchacharcur Jesusta charipäcunanpag, jinarcur wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Chaypitas cay ninacurcaram: “Ama charishunchu fiesta wichanga, runacuna sucsutänacur mana imatas lutanta rurapäcunanpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Chaura Jesusga Betania marcachrümi cayara, leprösu nipäcungan Simonpa wayinchru. Jinarcurmi mësachru micurcayaptin chrarun juc warmi alabastrupita rurasha botëllachru mana imatas yapalar nardupita rurasha perfümita apacurcur. Chay perfümi cara alisca golgue chraninmi. Jinarcurmi chay botëllapa cuncanta paquircur, Jesuspa umanman perfümita jirpurun. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chaura chaychru carcayagpita juc ishcaymi piñäcarärin shongolanchru. Jinamanmi shongolanchru cay nipäcura: “¿Imanirtag pampanman rurarun cay perfümita? ");
INSERT INTO qvnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chayta ranticurunman cara, quima pachrac junagchru juc runa gänananpita mascascachrüchri. Jinarcurchri mana imaynagcunata gorunman cara”. Chaynuypam piñäcarärin chay warmipag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chaura Jesusga cay nirunmi: “Jina rurachun. ¿Imanirtag cay warmita imatas nircayanqui? Cay ruramanganwanga alitam rurarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gamcunachru imaysi cayangam mana imaynagcunaga. Chauraga yanapayta munarga yanapapäcunquichr. Nätan nogaga manam alä unaychu cashag gamcunawan. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmiga rurarun ali ruramayta munarmi. Cay perfümita cawayaptilä cuerpüman jirpamanganwanga camariraman enterrasha canäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Shumag mayapäcamay: Cay pachachru maychru chaychrüsi ali willapapita rimapäcunganchrümi willapacanga cay warmi ruramangansi, chaynuypa yarpasha cananpag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chauraga Jesuspa chrunca ishcayniyog discïpuluncunapitam Judas Iscariotega japalan aywarunag sacerdöticunapa mandagnincunaman “Jesusta reguechipäcushay” ninanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chaynuy nigta mayarärirga chay mandagcunaga cushicaräriram. Jinarcurmi “Golguetam gopäcushay” nipäcura. Chayürapitam Judasga shuyag shuyag cara reguechinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chauraga chay Pascua fiestam nä galarinanpag cayara, chay fiestachrümi micapäcug mana levaduraynag tantata. Chaychrümi achrcashtas mogopäcug. Chaura discïpuluncunam Jesusta tapurärin cay nir: “¿Maychrütag camaripäcamushag Pascua cënata micunanchipag?” ");
INSERT INTO qvnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nipäcuptinmi Jesusga cachrarun ishcay discïpuluncunata cay nir: “Naupapäcuy marcata. Chaychrümi tincupäcunqui wacuywan yacu apayag olgowan. Paypa guepantam aywapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chay runa yaycungan wayipa runantam nipäcunqui: ‘Yachrachigmi niyan, “¿Maychrütag cayan gorpachacurcänä wayi, discïpulücunawan Pascua micuyta micapäcunäpag?” ’ ");
INSERT INTO qvnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nipäcuptiquim ricachipäcushunqui altuschru jatun wayita nä camarishalata. Chaychru camaripäcamuy noganchi micunanchipag”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Niptin discïpuluncunaga aywapäcura. Nä marcaman chrarärirga Jesús ningannuymi tarirärin. Jinarcurmi chaychru camarirärin Pascua micuy cënata. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nätan Jesusga pacha nä chacarpuyaptinran chrunca ishcayniyog discïpuluncunawan chrarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chauraga mësachru nä micurcayaptinmi Jesusga cay nin: “Shumag mayapäcamay: Gamcunapita jucmi, nogawan canan micuyagmi chregnipämagnïcunapa maquinman jitayamanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chaynuy niruptin aliscam laquicarärin. Chauraga Jesustam tapuyta galacayärin lapan: “¿Nogachu cayä? ¿Nogachu cayä?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chaura Jesusga nirunmi: “Jitayamangaga gamcuna chrunca ishcayniyogpita jucmi, nogawan parëju juc plätulaman tantata tawiyagmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nätan noga jana pachapita runawanga, razonpa rurarcayan unay isquirbishachru ningannuymi. Nätan laquipaypagmi cayan reguechimagnï runaga. Chay runapag mas alichr canman cara mana näciptinsi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chauraga micurcayaptinmi Jesusga tantata aptarcur “Gracias, Tayta” nin. Nircurmi tantata partircur gorun discïpuluncunata cay nir: “Micapäcuy. Cayga cayan cuerpünuymi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaypitas cöpata charircurtan Diosta “Gracias” nirun. Jinarcurmi chay cöpalapita lapan discïpuluncuna upyarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chaypitam nirun: “Chayga cayan yawarnïnuymi. Chay yawarnï wichinämi välichinga cay mushog conträtata runacuna salvacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Shumag mayapäcamay: Cay üvaspa yacunta manam yapayga upyashagchu. Upyashagga Diospa munayninchru juc junag gotucasharan”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jinarcurmi juc cantata cantarcärirga aywacurcan Olivos ningan gotuta. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chaypitam Jesusga nirun: “Canan pagasmi dëjarcärimar lapay aywacurcanqui. Chaynuymi isquirbichinganchru Diosga cay niyan: ‘Uysha michigtam wanuchishag. Chauraga lapan uyshancunam wichicasha canga’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nätan wanushapita cawacaramurga gamcunapa naupaytam aywashag Galileata”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Niptinmi Pedroga nin: “Waquincuna aywacurcaptinsi nogaga manam gampitaga raquicäshagchu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chaura Jesusga nirunmi: “Shumag mayamay Pedro: Canan pagas manaragsi ishcay cuti gallo wagaptilanmi, quima cuti nogapag Jesustaga ‘Manam reguëchu’ ninqui”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Niyaptinsi Pedroga cay niraran: “Gamtawan wanuchipäcamänan captinsi, ¡nogaga manam gampitaga ‘Manam reguëchu’ nishagchu!” Pedro niruptinga lapan discïpuluncunas chaynuylam nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaypitam chrarärin Getsemaní huertaman. Chaychrümi Jesusga discïpuluncunata nin: “Caylachru tayacurcayay Dioswan rimamungäcama”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nircurga pusharicurun Pedrotam, Jacobotam, Juantam mas washascacama. Chaychrümi Jesusga alisca manchariyta, jinaman alisca laquicuyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chaura chay quimantam cay nirun: “Alicusam laquicuyä. Caylachru mayag mayagla riccharcayar cacurcayay”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nircur Jesusga mas washascaman aywarcurmi gongorpacuyur pampaman lipucuyun. Jinarcurmi Diosta manacurun cay nir: “Gam munaptiquiga ama chrämuchunchu chay alisca juyupa cunchunä üra”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chaypitas cay niratan: “Taytalä, gampagga manam ima ruraysi sasachu, amar cay alisca juyu cunchuyta cunchushagchu. Nätan amar noga munangäga cachunchu, antis gam munangaynuy ruracächun” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chaypitam nä cutiyururga chay quima discïpuluncunataga tarirun punucashata. Chaura Simón Pedrotam nirun: “¿Punuyänaychu? ¿Manachu gamga juc üralaga ricchayta atiparay? ");
INSERT INTO qvnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ricchapäcuy, jinaman Diosta manacurcay, mana Asyag juchäcachipäcushunaypag. Gamcunaga munarcayanquim Dios manacuytaga, nätan cuerpuycunam ichaga guellanayanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nircur Jesusga yapaymi cuticun. Jinarcurmi manacurun chay naupata manacungannuyla. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chaura yapaymi discïpuluncunaman cutiyururga tarirun punucashata. Paycunaga punucarärinag alisca pununasha carmi. Chaymi paycunaga mana ima niytas atipapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nä quimapaypa cutiyururga cay nirunmi: “Chayla cachun punuysi, jinaman jamaysi. Cananga nämi üra chraramun, noga jana pachapita shamusha runa juchasapacunapa maquinman jitayusha canä. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sharcapäcuy, acu aywashun. Nämi aywayämun wanuchipäcamänanpag reguechimagnï”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Chaynuypa Jesús rimayaptilanmi chay chrunca ishcayniyog discípulu castapita Judasga, chraramun achca runacunawan. Paycunaga aywarärimunag espädayogcamam, jinaman gueruwancamam. Paycunata cachrarärimunag sacerdöticunapa mandagnincunam, Moisés isquirbinganpita yachrachigcunam, jinaman marcachru Israel castachru alinninpag ricasha chacha runacunam. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesusta reguechig Judasga pushamungan runacunata nämi cay nirunag: “Muchangätam charipäcunqui, jinaman aywachipäcuy maquinta shumag watarcur” nirunag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chaura Judas chrarurga, Jesusman ashuyurcurmi. “Yachrachig” nircur mucharun. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chauraga chaylam Jesusta charicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jinarcurmi Jesuswan cayagpita jucga espädanta jorgorcur juc runapa chulam rinrinta muturun. Chay mutusha runaga canag, lapan sacerdöticunapa mas mandagnincagpa rantisha runanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chaura Jesusga chay runacunata cay nirunmi: “Gamcunaga aywarärimunqui juc suwamannuychu, espädaycunawan, gueruycunawan nogata charipäcamänaypag. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nogaga waran waranmi gamcunawan carä Diospa wayinchru runacunata yachrayächir. Manatan jinar imaysi charipäcamaraychu. Nätan cananga charirärimanqui Diospa isquirbishan ruracänanpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chaura lapan discïpuluncunam Jesusta dëjarcur gueshpirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nätan Jesusta aywarcayächiptinmi juc mözu gatiränag säbanaswan wancupacusha. Paytas chay runacunaga charicarärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jinarcurmi chay mözuga gueshpicun garapachrala, wancurayangan säbanata dëjarcur. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chaypitam Jesustaga chrarärichin sacerdöticunapa mas mandagnincagman. Chaymanmi gotucarärin manday yanapag sacerdöticunas, marcachru alinninpag ricasha chacha runacunas, jinaman Moisés isquirbinganpita yachrachigcunas. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nätan Pedroga caru guepalantam gatiränag chay mas mandagcag sacerdötipa wayin puncucama. Chaychrümi Pedroga guardiacunaman talucarcur ninachru shanapacuyara. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nätan sacerdöticunapa mandagnincunawan, chay ganchris chrunca mandagcunam tapupacurcara Jesús ima lutan rurangantas u rimangantas, chaypita juchacharcur Jesusta wanuchipäcunanpag. Nätan manatan taripäcurachu ima juchantas. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achcam Jesuspita rimapäcura manacagta juchachapäcunan raygo. Nätan jucta juctam rimapäcug manam chaynuylatachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chauraga juc ishcay runacunam shacuyur Jesuspita manacagta rimarärin cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nogacunaga mayapäcurä cay nigtam: ‘Nogaga juchruchishagmi runacuna rurapäcungan Diospa wayinta. Jinarcurmi quima junagtaga gangalanta sharcachishag runacunapa maquinwan mana rurashata’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chaynuypa nircayarsi manam rimapäcurachu chaynuylataga. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chauraga lapan sacerdöticunapas mas mandagnincagmi, chraupiman shayuyur tapurun Jesusta cay nir: “¿Manachu imatasi ninqui chaynuy nircayäshuptiqui?” ");
INSERT INTO qvnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Niptinsi Jesusga upälalam cacura. Chaypitas tapura yapaytan cay nir: “¿Gamga razonpa cayanqui Diospa-mayinchu juc ‘Salvacugtam cachramushag’ Dios ninganchu?” ");
INSERT INTO qvnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chaura Jesusga nirunmi: “Au, nogam cayä. Gamcuna ricapapäcunquim noga jana pachapita shamusha runata, Munayniyog Diospa derëchanchru mandayar tayayagta, jinaman jana pachapita pucutaychru aywayämugtas”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Niptin chay mandagga jacuntam lachirun, alisca piñasha canganta musyapäcunanpag. Chaypitam nirun: “Nä quiquin nirayämashaga manam munanchichu mas testïgucunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nätan gamcunas nämi mayarärinqui ‘Diospa-mayinmi cayä’ nir lutan rimanganta. Chaura cananga ¿ima nipäcunquitag?” Niptinga lapanmi “¡Wanuchisha cachun!” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chaura juc ishcayga togapaytam galayärin. Jinarcurmi ñawinta sagpiwan watarcur lagyacurcan, “¡Mä nipäcamay pi lagyashungaytas!” nir. Chaynuytan lagyacurcan Diospa wayinta täpagcunas. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chaycama Pedroga chay wayi puncuchrümi cayara. Chaymanmi lapan sacerdöticuna mandagpa servignincunapita juc warmi chraramun. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jinarcurmi chay warmiga Pedro ninachru shanapäcuyagta ricapururga, rircärircur cay nirun: “Gamsi puriraymi Nazaretpita wac Jesús runawanga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Niptin Pedroga cay ninmi: “Manam nogalaga reguëchu, ni manatan musyäpishchu imapita niyämangaytas”. Nircurga sawan puncumanmi aywarun. Chaylam gallo wagarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chaypitam chay warmiga Pedrota yapay ricapururga, chaychru carcayag runacunata cay nirun: “Cay runaga Jesuswan purigmi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Niptin Pedroga yapaymi “Manam reguëchu” nir casquicurun. Chaypitaga unaylantam chaychru cayagcunaga Pedrota cay nirärin: “Gamga razonpa cayanqui paycunawan purigmi. Rimacuyniquis cayan Galilea runacunapanuymi”. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Niräriptin Pedroga lutan rimaytam, jinaman juracuytam galacuyun, “Chay nircayämangay runataga manam reguëchu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Niyaptilanmi gallo yapay wagaramun. Chaura Pedroga yarparun Jesús cay ningantam: “Manaragsi ishcay cuti gallo wagaptilanmi gamga nä quima cuti ‘Manam reguëchu’ nimanqui”. Chaura chay ninganta yarpachracururga aliscam wagacura. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chaypitam nä pacha warayämuptinga sacerdöticunapa mandagnincunawan, marcachru alinninpag ricasha chacha runacunaga, jinaman Moisés isquirbinganpita yachrachigcunaga, marcachru chay lapan mandagcunaga, rimanacurcurmi Jesusta aywachicurcan maquin watashata chay nación mandag Pilatoman. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chrarärichiptinmi Pilatoga Jesusta tapurun: “¿Gam razonpachu cayanqui cay Israel runacunapa reynin?” Niptin Jesusga “Au, gam ningaynuymi cayä” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nätan sacerdöticunapa mandagnincunaga aliscam ima-aygapitas Jesusta juchachapäcura chay Pilatopa naupanchru. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chaynuy nipäcuptin yapaytan Pilatoga tapurun Jesusta cay nir: “Chaynuy ima-aygapitas juchacharcayäshuptiqui ¿manachu imatasi ninqui?” ");
INSERT INTO qvnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nätan chaynuy niyaptinsi Jesusga upälalam cacura. Chaura mana imatasi rimacuptinga Pilatoga mayacasham ricacarura. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chaura chay fiesta wichan Pilatoga cachrarichrag cara carcelpita juc runatam, runacuna manacunganta. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chauraga Barrabás jutiyog runam, waquin purig-mayincunawan carcelchru cara. Paycunaga carcelman jitayusha capäcura Roma nacionpa munayninpita yargoyta munar, runacunata wanuchipäcunganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaura runacunaga Pilatoman aywarcurmi manacarärin: “Imaysi rurachrangaynuynar carcelpita jucta cachrarï” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Niräriptinmi Pilatoga nirun: “¿Gamcuna munarcayanqui reyniqui Jesusta cachrarinätachu?” ");
INSERT INTO qvnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chaynuy nira Pilatoga sacerdöticunapa mandagnincuna chriquicuylapita payman aywachipäcunganta musyarmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chaura chay chriqui runacunaga achca runacunatam yachrachiyta galacayärin, “¡Barrabasta cachrariparcämay nishun!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chaynuy nipäcuptin Pilatoga yapaytan tapurun cay nir: “¿Chaura ima ruranätatag munarcayanqui Israel castacuna ‘Payga reynïmi’ nipäcungayta?” ");
INSERT INTO qvnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Niptin paycunaga gayachracuypanuymi gaparäcurcan: “¡Cruzchru wanuchun! ¡Cruzchru wanuchun!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nipäcuptinmi Pilatoga nirun: “Nipäcunaypagga ¿ima juchatatag rurarayan?” Niptin paycunaga masran gaparäcurcansi: “¡Cruzchru wanuchun! ¡Cruzchru wanuchun!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chaura Pilatoga chay runacuna manacurcangannuy rurarmi Barrabasta cachrarirun, nätan Jesustam alisca astircachirga nirura cruzman clävapäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chaura soldäducunaga Jesusta yaycarärichin Pilatopa mandacunan wayi puncumanmi, soldäducuna cacurcänanman. Jinarcurmi goturärin chaychru cag lapan soldäducunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chaychrümi Jesusta jatiräripun reypa puca jacunta. Chaypitam jatiräripun umanman cashapita rurasha corönata. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jinacarcärirga saludagtucuytam galacayärin “Cawachun Israelcunapa reynin” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jinarcurga chaglawanmi umachru wipyacurcan, togapäcurcan. Chaypitam gongorpayärir manchacugtucurcara. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chaynuy turyaparcärirga, chay puca jacu jatipurcangantam logtiräripun. Jinarcurmi gangalanta quiquinpa jacunta jatircaripur aywachicurcan cruzman clävapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jinarcurmi Cirene marcapita Simón runataga chracrapita aywayämuptin charirärin Jesús apayangan cruzta apananpag. Chay Simonga cara Alejandropawan Rufopa taytanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Chaypitam Jesustaga chrarärichin Golgotaman. (Golgotaga cara ‘Umam tullu’ nirayag gotupa jutinmi.) ");
INSERT INTO qvnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chaychrümi ‘mirra’ ningan usuncächicug jampita vïnuwan tacushata upyachiyta munapäcura. Nätan Jesusga manam upyayta munarachu. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chaypitam nä cruzman clävarcärir soldäducunaga chüsapäcura Jesuspa jacunta maygansi apacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chay cruzman clävapäcura pacha waranganpita nä quima üra cayaptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nätan imapita cruzman clävapäcungansi musyacänanpag, cay nir isquirbishatam cruzpa umanman chrurapäcura: “ISRAEL RUNACUNAPA REYNIN” nishata. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jinaman paytawan parëjum ishcay suwacunatas clävarärin, juctam derëchanman jucnintam ichogninman. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","29","Nätan chaypa pasagcunam umanta awircur awircur Jesusta nipäcura cay nir: “Gam ‘Diospa wayinta juchrurcachir, quima junagta yapay sharcachishag’ nigchu jinarayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mänar quiquiqui salvacuy, jinaman cruzpita mä jegarpamuy” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chaynuymi sacerdöticunapa mandagnincunas, Moisés isquirbinganpita yachrachigcunawan turyapapäcura. Jinarcurmi quiquincama cay ninacurcara: “Juccunataga salvara, nätan quiquingä manatan salvacuyta atipanchu”. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chaypitas nipäcuram: “Mänar Israel runacunapa reynin cayarga, jinaman Diospa acrashan Cristo cayarga, mä ricapäcunapag cruzpita jegarpamuy. Chaymi ichaga razonpam canag nipäcushagga”. Nätan paywan cruzchru clävarayagcunasi ashlipapäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chaypitam nä chraupi junag cayaptin, pachaga shumag chacarun, jinaman chaynuy chacashala cara quima üraran. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nä quima üra chay yanauyag cayaptinmi, Jesusga lapan calpanpa gayachracaramun cay nir: “Eloi, Eloi, ¿lama sabactani?” nir. (Chay ninan cara “Diosnilä, Diosnilä, ¿imanirtag washamayta gongarunqui?” ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chaychru juc ishcay cayagcuna mayarärirga “Diospa unay willacugnin Eliastam gayacuyan” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chauraga chaychru cayagcunapitam jucga wayrala aywarcur puchgorisha vïnuman esponjata tawirun, jinarcurmi chaglapa puntanman chriquircur Jesuspa shiminman chaccharcachir shogoyächiptinmi waquin runaga cay nirärin: “Ama shogochiychu. Mä ricashun, Elías shamunagchush cruzpita jorgonanpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chaylam Jesusga lapan calpanpa gapachracurcur wanurun. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chauraga chayüram Diospa wayin ruyichru racta telón cayagsi lachirun ishcayman, janapita uraman. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chauraga pachrac soldäducunapa mandagninga, Jesuspa naupanchru cayar imanaypa gapachracur wanugtas ricarurga “Cay runaga razonpa Diospa-mayinmi casha” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Paytaga ishcay quima warmicunas carupita rircarapäcunagmi. Paycunaga capäcura, Magdala marcapita Mariam, jinaman Jacobopa maman Mariam. Nätan Jacoboga cara Josëpa jinaman Salomëpa shulcanmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chay warmicunaga Galileachru canganpita-pacham Jesusta yanapapäcug, jinaman servipäcug. Chaychrüga capäcuratan mas achca warmicunas, Jesuswan Jerusalenta aywamushacuna. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chay junagga cara, jamana junagpag camachracuna tardim. Chauraga nämi pacha chacanayara jamayta galayapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Chaymi Arimatea marcapita Josëga manchariyanganpita Pilatoman yaycurun “Jesuspa cuerpunta enterramushag” nir, manacug. Chay Josëga cara Jerusalén marcachru mandagcuna castam. Paysi shuyarara Diospa munayninchru cawaytam. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chaura chaynuy José niruptinga Pilatoga mayacasha niragmi ricacarun. Jinarcurmi shumag musyananpag chay pachrac soldäducunapa mandagninta gayarachin. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chaura pay chrarurga razonpa nä wanusha cangantam willarun. Chayran Pilatoga “Enterraramuynar” nirura. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaura Josëga lïnu ninganpita rurasha tëlatam rantirun. Jinarcurmi Jesuspa cuerpunta jorgarcamurga chaywan wancurun. Chaypitam gagachru uchrcuchingan mïchuman chrurarun. Jinarcurmi jatuncaray rumita cuchrparcachirga chaywan mïchupa puncunta wichrgarun. ");
INSERT INTO qvnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nätan Magdala marcapita Mariawan, Josëpa maman Mariaga mayman chrurapäcungantasi shumagmi rircarapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chaypitam nä jamana junag pasaruptin Magdalapita Mariaga, Jacobopa maman Mariawan, jinaman Salomé jutiyog warmiwan rantirärimunag perfümicunata, Jesuspa cuerpunta pasachipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chaypitam semäna galarinan junagga goyashala aywacurcan. Jinarcurmi Jesuspa mïchuncagmanga chrarärin inti yargarayämuptilan. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Chaura warmicunaga quiquincamam cay ninacurcara: “¿Pirag mïchuman yaycunanchipag puncuchru jatuncaray rumita jorgapamäshun?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nätan rircaripäcunganchrüga ricaparärin chay mïchu wichrgag jatuncaray rumitaga jucläduman ashushatam. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chauraga nä mïchucagman yaycarärirga, ricaparärin juc mözutam derëchacag läduchru yurag jacusha tayayagta. Chayta ricapururga manchacarärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nätan payga chay warmicunataga cay nirunmi: “Ama manchacapäcuychu. Gamcunaga ashircayanqui chay cruzchru clävapäcungan Nazaretpita Jesustam. Payga nämi cawacaramun. Manam nä caychrüga canchu. Mansi ricapäcunqui chrurapäcunganta”. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nircurga cay nirunmi: “Aywapäcuy, willapäcamuy discïpuluncunata, jinaman Pedrota: ‘Jesusga nä naupancunatam aywayan Galileata, chaychrüshi payta ricapapäcunga pay ningannuyla’ nirun”. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chaura warmicunaga manchacaypita chucchucyarcayanganpitam gueshpig jina aywacurcan mïchucagpitaga. Nätan manam pitasi willapäcurachu pasay manchacasha capäcurnin. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chaura chay semäna galayug goyachru Jesús cawacaramurga, puntata ricapachicurun Magdalapita Mariawanmi. Paypitam Jesusga gargosha cara ganchris lutan espiritucunata. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chaura María aywarga willarun Jesuswan purigcunatam, paycunaga laquisham wagarcayänag. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nätan paycunaga “Jesusga cawacämusham. Nogam ricapurü” nigta mayarcayarsi “Yangachr” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaypitas Jesusga jucnuyman muyusham ricapachicurun ishcay discïpuluncunawan, Jerusalenpita wayinta aywarcayaptin. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chauraga paycunas waquin discïpulu-mayinmanmi aywacurcan. Jinarcurmi willarärin Jesús ricapapäcunganta. Nätan paycunatas “Yangachr nircayan” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaypitam nä ushanantaga chrunca jucniyog discïpuluncuna micurcayaptin Jesusga ricapachicurun. Chaychrümi piñaparun chay willagcunata “Yangachr” nipäcunganpita, jinaman mana chrasquicurcanganpita. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chaypitam Jesusga cay nirun: “Cay pachachru maytas chaytas aywapäcuy, jinaman lapan runacunata willapapäcamuy cay ali willapata. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lapan shongonpa chrasquicugtaga, jinaman bautizächicugga salvasham canga. Nätan ‘Yangam’ nigcunaga alisca cunchupäcunanpagmi nisha canga. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lapan shongonpa chrasquicushacunaga, noga ningänuymi, runacunapita lutan espiritucunata gargapäcunga, jinamanmi rimapäcunga mana imaysi yachrangan mushog rimaychu. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nätan aptapäcungam culebracunatas, jinaman venënuta upyapäcursi manam wanupäcungachu. Chaynuytan gueshyagcunaman maquinta chrurapäcursi cuticächipäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chaynuypa nä rimayta usharcurga Munayniyog Jesusga jana pachatam aywacura. Jinarcurmi mandananpag tayurura Diospa derëchanman. ");
INSERT INTO qvnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chaypitam discïpuluncunaga maypas chaypas puripäcura willapacurcayar, jinatam Munayniyog Diosga yanapara. Chaypitam chay willapacurcanganta runacuna chrasquipäcunanpag rurachira runala mana ruray atipänancunata. Chaynuy cachun.");
INSERT INTO qvnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Achcam isquirbipäcusha ima-ayga Jesuswan pasangantas. Chay isquirbishacunatam noganchicunacagchru purircayächin. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nätan chay isquirbigcunaga isquirbipäcura Jesuspa discïpuluncuna willapacurcangantam. Chay willapacugcunaga capäcura Jesuswan ima-ayga pasangantas ñawinpa ricagcunam, jinaman paypita willapacugcunam. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Chaymi noga, Lucassi Jesuspita musyag runacunata imanuy cangantas lapanta shumag tapupacurcurga, manyalapita isquirbimü gampag, alisca alinninpag ricasha Teófilo, ");
INSERT INTO qvnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chaynuypa naupata yachrachipäcushungaypita mas shumag musyanaypag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chauraga Judea nacionchru Rey Herodes mandanan wichanmi, cara juc sacerdötisi Zacarías jutiyog. Payga cara unay Abiaspa castan aywagmi, nätan warmin Elisabetmi cara Aaronpa castan aywag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paycunaga capäcura ishcayninsi Diospa naupanchru ali ruragcamam, mana piñapächicugcamam, jinaman cäsucurcag lapantam Dios ruray ningancunataga. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nätan paycunapaga manam wamrancuna carachu, Elisabet mana wachrayta yachraptin, jinaman nä chachacamam capäcuras. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Chaypitam juc junagchrüga, Abiaspa castan sacerdöticunata töcarura Diospa wayinchru uryay. Chaymi Zacariaspis uryayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chauraga costumbrincunanuy chüsaräriptinmi Zacariasta töcarura Diospa wayinman yaycuy, chay inciensuta rupachicunacagman. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chauraga inciensuta Zacarías rupayächiptinga, lapan runacunam washachru Diosta manacurcayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chaypitash inciensuta rupachicuna altarpa derëcha lädunchru ricacarun Diospita shamusha ángel shayayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chayta ricapurur Zacariasga aliscash manchacarun, jinaman imanaytas manash atiparachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chaura angelga nirunshi: “¡Ama manchacaychu Zacarías! Manacungayta Diosga mayasham. Chaymi Elisabet warmiqui gueshyacunga olgo wamrata. Jutintam chrurapunqui Juanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wamray näciruptinga aliscam cushicunqui, jinaman runacunas achcam cushicurcanga. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pay jatunyarurga, Diospa naupanchru alisca välig runam canga. Manam upyangachu vïnutas ni ima shincachicugcunatas. Mamanpa pachranpita-pacham Santu Espiritupa munayninchru canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Payga achcatam Israelpa castancunata tantiachinga Diosman cutipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Payga willapacunga munayniyog salvacug shuyayanganchipa naupantam. Nätan canga Diospa unay willacugnin Eliasnuysi, alisca munayniyogmi. Payga tayta cagcunatam rimapanga churincunawan ali cawapäcunanpag, jinaman munangalan ruragcunatam rimapanga ali rurag runacunamannuy muyupäcunanpag. Chaynuypam runacunata camaringa, munayniyog chrämuptin ali chrasquicurcänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Niptin Zacariasga angeltash nin: “¿Imanaypatag musyashag razonpa niyämangayta? Nogaga nä auquintag cä, warmïsi chacwantag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Niptin angelga ninshi: “Nogaga Diospa naupanchru cag Gabrielmi cayä. Paymi nogataga cachrarayäman chay shumag willapata musyachinagpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nätan cananga ‘Mana razonchri’ nimangaypitam, mana rimayta atipanquichu churiqui näcimungancama. Caycuna rimangänuymi ruracanga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nätan washachru chay goturarcayag runacunaga shuyararcayara, “¿Imanirtag chicacama mana yargamunchu inciensu rupachicunacagpita?” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Unaytaran Zacariasga yargaramun mana rimayta atipayar, umalanwan, jinaman maquilanwan runacunata tantiayächir. Chaura runacunaga “Imas Diospitachr ricäparun inciensu rupachicunacagchru” nipäcuram. Chaura Zacariasga chaynuylam cara mana rimayta atipayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chay junagcuna nä Diospa wayinchru chay ruranancuna rurayta ushacurcurga, Zacariasga wayintam aywacura. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaypita chay junagcunalam warmin Elisabetga pachrayog ricacarura. Chaychru Elisabetga cara pichga quillam mana wayinpita yargamular cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Diosmi cananga noga pachrayog canäta munarun, runacunapita mana pengapasha canäpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nä sogta quilla pachrayog cayaptinmi, Diosga cachrara ángel Gabrielta Galileachru cayag Nazaret marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chaychrümi yachrara mana olgo regueg juc jipash, María jutiyog. Payga nä rimasha cara José mözuwan ishcaychacunanpagmi. Chay mözuga cara Rey Davidpa castan aywagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel Gabrielga María cayagman chrarurga “¡Cushicuy María! Diospita alipag ricasham cayanqui. Diosga gamwanmi cayan” nirunshi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chaura angelta ricapururga, jinaman chaynuypa ángel niruptinga, Mariaga pasay mayacasha niragshi ricacarun, “¿Imatatag caynuypa niyäman?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chaynuy pinsiayaptilanshi angelga niruntag: “María, ama manchacaychu. Diosmi cuyapäshurlay gamtaga acrarayäshunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cananga pachrayogmi ricacanqui, nätan wawaymi canga olgo. Jutintam chrurapunqui Jesusta. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payga canga alisca munayniyogmi, jinaman cayansi jana pachachru cayag Diospa-mayinmi. Nätan Munayniyog Diosmi chruranga mandag cananpag, unay awillun Davidtanuysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chaura imaycamas mandagmi canga Jacobpa castan aywagchru, jinaman chaynuy mandaglam canga imay imaycamas”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chaynuy niruptin Mariaga tapurun angeltash cay nir: “¿Imanuypatag pachrayogga ricacäshag mana olgotasi regueyarga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niptinshi angelga nirun: “Santu Espiritum shamunga gamman. Chaylam Diospa munayninwan pachrayog ricacunqui. Chaymi chay näcimug wamrataga ricapäcunga Dioslapag cawagpag, jinaman Diospa-mayinpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nätan mana wachray yachrag nipäcungan castay Elisabetsi chacwanyänanchrümi nä sogta quilla pachrayog cayan. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diospagga manam ima ruraysi sasachu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Niptinshi Mariaga nirun: “Diospa maquinchrümi cayä. Gam nimangaynuy Dios rurachun nogawan”. Niruptin, angelga aywacunshi Mariacagpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chaura chay junagcunalam, Mariaga wayrala aywara Elisabet yachrangancagta. Chay marcaga cara Judea ninganchrüga mas altunpam. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nä Zacariaspa wayinman María chrarurga, Elisabettam “Wayilayman. ¿Alilachu cayanqui?” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chaura Mariapa shiminta mayaruptinga, Elisabetpa pachranchru wamrasi jucnuypash cuyurura, jinaman chayürash Elisabetga Santu Espiritupa munayninchru ricacarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chauraga gapachracuypa niragshi Elisabetga Mariata nirun: “Lapan warmicunapitas mas alinninpag ricasham gamga cayanqui Diospita, jinaman alipag ricasham cayan pachraychru wawaysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitag cä nogaga Munayniyognïpa maman nogaman shamunanpagga? ");
INSERT INTO qvnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gampa shimiquita mayaruptïga, juclam pachrächru wamräsi jucnuypa cuyurirun cushicuypita. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Chauraga alisca cushicuy Munayniyog Dios willashungayta chrasquicungaypita, Diosga nishungaynuymi ruranga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Niptin Mariaga cay ninmi: “Lapan shongöpam alawayä Diosta, ");
INSERT INTO qvnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nätan cushirayäsi aliscam Tayta Dios salvamagnï captin, ");
INSERT INTO qvnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","caynuy manacag warmilatas rircärimanganpita. Cananpitaga lapan casta runacunas ‘Ima cushisharag cayan chay warmi’ nipäcamangam. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Munayniyog ima-aygatas ruray atipag Diosmi nogachru rurarun ima-aygatas. Paypagga jutinsi ‘Lapan juchapita caruchru cayag’ nisham. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Payta manchacugcunataga chaynuylam Diosga cuyapayan imay aygaysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ima-aygatam mana rurashachu munayninman. Payga manacagmanmi muyuchin olgotucug runacuna ima-aygata rurapäcunanpag pinsiarcayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Payga munayniyog mandagcunatas jitarisham mana mandag cananpag. Nätan manacagpag ricashacunatam mas alipag ricachin. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Payga micuypita nacagcunatas capogniyogmanmi muyuchin, nätan capogniyogcunatam mana imaynagman muyuchin. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Payga yanaparam servignin Israelta jutiyog runatas. Jinaman chaynuy cuyapayälarmi yanapara imaysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chaynuy imaycamas cuyapänanpagmi nira unay taytanchicunata, taytanchi Abrahamta, jinaman castan aywagta” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Chaychrüga María, Elisabetwan yachrara quima quillanuyran. Chaypitaran cutira wayinta. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nätan Elisabetpa gueshyacunan quilla ayparamuptinga, gueshyacurura olgo wamratam. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chayta mayarärirga castancuna, jinaman wayincagpa yachragcuna aliscam cushicarärira Elisabetwan, Munayniyog Dios payta cuyapälar, chaynuy ruranganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chaypita wamra nä puwag junagniyog cayaptinmi, apapäcura costumbrincunanuy señalächig. Chaychru runacunaga wamrapa jutinta chrurayta munapäcura taytan Zacariaspa jutilantam. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Chaymi Elisabetga nira: “Manam Zacariaschu jutinga canga, antis Juanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Niptinmi runacunaga nirärin: “¿Imanir? Castaycunachrüsi mana ‘Juan’ jutiyog cayaptinga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chauraga taytan Zacariastam tapupäcura sëñasyaylapa: “¿Ima jutin canantam munayanqui?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chaura taytanga manarura tacsa tablalatam, jinamanmi goräriptinga chaychru isquirbirura: “Paypa jutinga Juanmi” nir. Chaura chaychru cayagcunaga lapansi mayacasha niragmi quëdarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chaylam Zacariaspa shimin yapay rimariramura, Diosta alawayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chauraga lapansi wayin lädunpa yachragcuna mayacasha niragmi capäcura. Jinarcurmi Judeachrüga limpu mayachinacarärira Zacarías yachrangan jircacunapa. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chauraga lapan mayacugcunas shongolanchrümi nipäcura: “¿Imarag wara raswa chay wamra canga?” nir. Nätan “Razonpam chay wamraga cayan Munayniyog Diospa maquinchru” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chaypitam wamrapa taytan Zacariasga Santu Espiritupa munayninchru cayar rimara cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Alisca ali nisha cachun noganchi Israel castapa Munayniyog Diosninchi, noganchi runancunata ricamänanchipag, jinaman jucpa munayninpita jorgamänanchipag aywamunganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Canan noganchiman cachraramun juc munayniyog salvacugtam, Diospa servignin Davidpa ayllun castapita. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Caynuy cananta Diosga nämi rimachisha cara Dioslapag cawag willacugnincunawan, ");
INSERT INTO qvnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mana ricapuy munamagninchicunapita, jinaman lapan chregnipämagninchicunapita salvamänanchita; ");
INSERT INTO qvnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Unay awillunchicunata cuyapänanpita, jinaman rimanacunganta razonpa rurananpag mana gongananpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nätan taytanchi Abrahamtasi ‘Niyangagcunata razonpam rurashag’ nirmi Diosga cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Cachramushag juc salvacugtam chregnishugniquicunapa maquinpita jorgopäshunaypag, jinaman mana mancharilar servipacamänaypag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Paypa naupanchru mana juchaynag, jinaman lapan junagcunas cawayanganchicama alita rurayar cananchipag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nätan gam, wamräga, jana pachachru cayag Diospa willacugnin nisham canqui. Chaynuy nipäcushunqui munayniyog shuyacuyanganchi chrämunanpag runacunata camariptiquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gamga musyachinqui runacunatam juc salvacugpita, juchancunapita perdonasha capäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chaynuy ruranga Diosga alisca cuyapäcug carmi. Payga jana pachapita cachramunga juc salvacugtam, ");
INSERT INTO qvnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","juchalachru cawagcunata, jinaman alisca cunchuyman aywarcayagcunata ali cawaypita musyachinanpag, chaynuypa ali cawayta yanapämänanchipag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nätan wamraga jatunyayara Diosta cäsucuyarmi, jinaman paypita yachracuyarmi. Juanga yachrara juc chunyag pampachrümi Israel runacunawan reguechicungancama. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chauraga Augusto César nipäcungan, Romachru mandag cayarmi nirura chay mandayangan nacioncunachru lapan runacuna censacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chaypin chay censa cara wamagtam, Cirenio jutiyog runa Siria nacionchru mandayaptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chaymi lapan runacuna marcantacama aywapäcura censacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chaymi Josësi Galileachru cayag Nazaret marcapitaga jegara Judeachru cayag David näcingan Belén marcata, paypa ayllun aywag car. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josëga aywara casaränanpag rimashan Mariawanmi censacurcänanpag, nätan Mariaga nämi juntaparayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chaychru carcayaptinmi María gueshyacunan junag ayparamura. Jinarcurmi jätucurcänanpag mana wayicuna jäcuptin, gorpachacurcara runapa uywan wichrgaräcunalanman. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chaychrümi Mariaga wamag wawanta gueshyacurura. Jinarcurmi pañalwan wancurcur chrachrarachira uywacuna micucunan rumipita rurasha batya niraglaman. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chaura Belén marca cercanpam uysha michigcunaga pagaspa uyshanta vïllarcayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jinarcurmi mayänipita paycunacagchrüga ricacarura munayniyog Diospa juc angelnin. Chauraga ricacarärira alisca achicyagchrümi. Jinarcurmi tantiarärira Munayniyog Diospa cachramushan canganta. Chauraga aliscam manchacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jinarcurmi angelga cay nirun: “Ama manchacapäcuychu. Cananga gamcunapag apayämü mushog willapatam cushicurcänaypag. Cay willapawanga lapan runacunas cushicurcangam. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cananmi näcirun Davidpa marcan Belenchru juc salvacug. Payga cayan Diospa acrashan munayniyogmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Caynuypam musyapäcunqui pay salvacug canganta: Aywar, taripäcunqui wamrata pañalwan wancushatam, uywacuna micucunan rumipita rurasha batya nirayagchru chrachrarayagta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chay nir rimapayaptilanmi, mayänipita chay angelcagchru ricacarärira alisca chranin angelcuna ");
INSERT INTO qvnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Alawasha cachun jana pachachru Tayta Diosga, nätan cay pachachru runacuna ali cawapäcuchun Dios yanapayaptinga” nir alawarcayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chaypita nä lapan angelcuna jana pachata cutiräriptinga, uyshanta vïllag runacunaga rimanacarärira cay nirmi: “Acuchi. Aywashun Belenta. Mä ricamushun Munayniyog Dios angelninwan willachimanganchita”. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chaura wayrala aywarcurmi Belenchrüga tarirärira Mariata, Josëta, jinaman iñashata, pañalwan wancusha chay rumi batyachru chrachrarayagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nä ricarärirga willapacurcara lapantam wamrapita ángel ninganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chaura uysha michigcuna willaparäriptinga lapan mayacugcunas mayacasha niragmi capäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Chay lapan pasanganta Mariaga shongolanchrümi musyaras, jinaman pinsiaras. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chaypitam uysha michigcunaga cuticurcara cushisha “Diosga alisca alim” nir alawarcayar, ángel musyachinganpita, jinaman ángel ningannuy ricapäcunganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nä puwag junagniyog iñasha cayaptinmi señalächipäcura. Chaychrümi jutinta chrurapäcura Jesusta, María manaragsi pachrayog cayaptin ángel ningannuyla. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chaura paycunaga Moisés ningannuymi María gueshyacungan nä chruscu chrunca junag ayparuptinga, wamrata apapäcura Jerusalenchru Diospa wayinman. Chaychrümi “Cay wamraga gamta servishunalaypagmi cayan” nipäcura Munayniyog Diosta. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chaynuy rurapäcura Moisés isquirbinganchru Dios cay nisha captinmi: “Wamag olgo wamra näcimug lapansi canga nogapagmi” niptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chaura paycunaga Dios mandangannuy apapäcunan cara ishcay wapshagtam u ishcay palömatam, sacerdöti wanurcachir Diospag rupachinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chaypin cara Jerusalenchru juc auquinmi Simeón jutiyog. Payga cara ali ruragmi, jinaman Diosta manchacugmi. Payga shuyacuyara Israelpag juc salvacug shamunantam, nätan cawaras Santu Espiritupa munayninchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Paytaga Santu Espiritum nä musyachisha cara, Munayniyog Diospa acrashan Cristota ricangancama cawananpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chauraga Santu Espiritum Diospa wayinman Simeonta aywachira. Jesusta nä taytancuna Dios ningannuy rurapäcunanpag chrarärichiptin, ");
INSERT INTO qvnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonga wamrata margacurcur, Diosta alawara cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Munayniyog Tayta, cananga cay servigniqui cushisham wanucushag. Nämi nimangaynuy rurarunqui, ");
INSERT INTO qvnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Cachramungay salvacugta ñawïwanmi nä ricarü. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Payta cachramusha canqui lapan runacunapagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Paymi juc casta runacunata salvanga, nätan Israel casta runancunapagmi canga alisca cushicuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chaynuypa wamrapita Simeón niptinga, Josëwan Mariaga mayacasha niragmi ricacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chaypitam Simeonga Diosta manacura paycunata ima-aygachrüsi yanapänagpag. Nätan Mariatam cay nira: “Shumag wiyarimay. Cay wamrata Diosga cachrarayämun Israel castacunapita, waquinta salvacunanpagmi, nätan waquincag juchaman mas ishquicapäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Payga aywarayämun achca runacuna paypa contran capäcungan musyacänanpagmi. Chaynuypam lapan runa shongolanchru alita u lutanta Diospita pinsiarcayangansi musyacanga. Nätan gampagga María, lapan caycuna pasaptin shongoy nananga cuchilluwan tucsishanuymi laquicuypita” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaychru cayaratan Ana jutiyog chacwansi. Paysi cara Diospa willacugnin warmim. Payga cara Fanuelpa churinmi, Aserpa castan aywag. Nätan casaräcunganpitaga ganchris watalatam gowan wanurura. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chauraga nämi cayara viüda cangan puwag chrunca chruscun wata. Payga Diospa wayinpita manam aläpa yargogchu, antis malagayur, malagayurmi, Dioswan rimayag pagaspas, junagpas, chaynuypam Diosta servig. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Paysi Simeón rimayangan üram, chayman chrarur Diosta “Gracias Tayta” nicura. Nircurga salvacugta shuyacurcayag lapan runacunatam willara iñasha Jesuspita chay Jerusalenchru. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chaypita nä Moisés chay isquirbingannuy ruracarcärirga, cuticurcara Josëwan Mariaga Galileachru cayag Nazaret marcantam. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chaychru Jesusga jatunyayaram, jinaman calpansi chrayämuram. Nätan wiñangan masmi alisca yachragman muyuyara Dios alisca yanapaptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nätan Josëwan María wata watam aywapäcug cara Jerusalenta Pascua fiestapag. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jinarcurmi Jesús nä chrunca ishcaynin watayog cayaptin, lapan jegapäcuratag Jerusalenta Pascua fiestapag, imaysi aywapäcungannuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chaura fiesta nä usharuptinga, cuticurcara Nazarettam. Nätan Jesusga quëdarunag Jerusalenchrümi taytantas, mamantas mana musyachilar. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chaura Josëwan Mariaga “Aywagcunawanchri nä aywayan” nirmi, aywapäcusha juc junag camiñuta. Chaura aylluncunatam, jinaman reguenacuynincunatam Jesuspita tapucurcara. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jinarcurmi mana chaychru taripäcurga, ashiyar cutipäcura Jerusalenta. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chaypitam quima junagtaga tarirärira Diospa wayinchru Moisés isquirbinganpita alisca yachrag runacunata mayacuyar, jinaman tapupayar paycunawan tayayagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chaychru lapan mayacugcunaga mayacasha niragmi capäcura walash alisca yachranganpita, jinaman lapan tapupäcunganta ali musyanganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Josëwan Mariaga Jesusta ricaparärirga mayacasha niragmi ricacarärira. Chaura Mariaga cay nirunmi: “Wamra, ¿imanirtar caynuy purirärichimanqui? Taytaywan nogaga ashircayag laquisha”. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Niptinmi mamantaga cay nin: “¿Imanirtar ashircayämanqui? ¿Manachu musyapäcunqui Dios-mayïpa ruraynincuna ruranäta?” ");
INSERT INTO qvnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Niptin paycunaga manam tantiapäcurachu imapita rimapayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaypitaga cutira paycunawanmi Nazaret marcata. Nätan Jesusga taytan maman cäsucugmi cara. Lapan chaycuna pasanganta mamanga quiquilanmi musyacug. ");
INSERT INTO qvnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nätan Jesusga jatunyayangan masmi mas yachragman muyuyara, jinaman alipag ricasham cara Diospitas, nätan runacunapitas. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chauraga Tiberio jutiyog runa chrunca pichgayog wata Romachru mandayaptinmi gobernadornincuna cara: Judeachru Poncio Pilato, nätan Galileachrümi cara Herodes, jinaman Herodespa wauguen Felipem cara Itureachru, jinaman Traconitechru, nätan Lisaniasmi cara Abiliniachru. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nätan Anaswan Caifasmi capäcura Israel casta sacerdöticunapa mandagnincuna. Chaypin wichanmi Dios rimapara Zacariaspa churin Juanta, jäpag pampachru cayaptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chaymi Juanga purira Jordán mayucagpa runacunata cay niyar: “Jucha rurarcayangaypita wanacurcur Diosman cutipäcuy perdonapäcushunaypag. Jinaman bautizacurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nätan Juanga, Diospa willacugnin Isaiaspa isquirbinganchru ningannuymi rurara. Chay isquirbishachrüga cay niyanmi: “Juc runam jäpag pampachru gayacuypanuy cay niyämun: ‘Camachracurcay Munayniyog Dios chrämunanpag, jinaman ali cawayta galayapäcuy, camiñu alchayta galayugnuysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nätan mana camaricurga carcayanqui juyu ragranuymi, juc manchacuypag jircanuymi, juyu gotunuymi, lutan muyu muyu camiñunuymi, patan ucrun lutan camiñunuymi. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jinaman chay pachachru lapan runacunam ricapäcunga Dios cachramungan chay salvacugta’ ”. Chay ningannuymi Juanga rurara. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chaura Juanga chay achca runacuna bautizächicug aywarcayämugtam cay nira: “Acapa casta culebracunanuysi lutan runacuna, ¿pitag gamcunata nirärishunqui chay alisca juyu cunchuy aywayämugpita gueshpipäcunaypag? ");
INSERT INTO qvnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Diosman razonpa cutipäcungay musyacänanpag, lapan runa ricay ali cawapäcuy. Ama nicurcaychu ‘Abrahampa ayllun aywag carmi mana imapitas wanacunächu’ nirga. Manam Abrahampa ayllun calarchu Diospagga ali capäcunqui. Munar Diosga cay rumicunatas muyurachinmanmi Abrahampa ayllun cananpagga. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nätan sapinpita monticunata sagtananpag runa jächan aptasha camarayagnuymi Diosga cayan. Chauraga montitachu lutan wayugcagtaga muturcur ninawan rupachinchi, chaynuymi Dios ruranga lutan rurag runacunawan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Niptin runacuna tapurärin cay nirmi: “¿Chauraga imatatag rurapäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nipäcuptinmi Juanga nira: “Ishcay jacuycuna captin mana jacuynagta jucninta gopäcuy. Nätan micuyniquicuna captin, gopäcuy micuypita nacagcunata” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Paymanga chraräriratan bautizächicug patentita cobrag juc ishcay runacunas. Paycunas tapucurcara Juanta cay nirmi: “Yachrachig, ¿nogacunagä? ¿Imatatag rurapäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nipäcuptin Juanga niram: “Aygatam cobrapacunay cayan chaylata cobrapäcuy, ama mastaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaynuytan juc ishcay soldäducunas tapucarärin cay nir: “Nätan ¿nogacunagä? ¿Imatatag rurapäcushag?” Nipäcuptinga paycunatas niram: “Ama pitas jorgapäcuychu imantas, wactam u caytam rurasha canqui” nir manacagpitaga, jinaman “Pägapäcushungalaywan cacurcay” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chauraga achcam runacuna salvacug shamunanta shuyag shuyag carcayarga. Jinarcurmi shongolancunachru “Paypishchri Cristoga cayan” nipäcura Juanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chay nipäcunganta tantiarurmi Juanga lapanta cay nira: “Ricarcayangaynuysi nogaga yaculawanmi bautizarcayag. Jucmi ichaga aywayämun nogapitas mas munayniyog. Nogas paypagga manam maygan alinninsi cächu sandalianta pasquipunaläpagsi. Paymi ichaga chrurapäcushunqui Santu Espiritupa munayninman, jinaman mana juchaynagman muyuchipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Payga trïguta wauyachinapag wauyachicunan aptashanuymi cayan. Jinarcurmi nä shumag wauyarcachir chruracunanman trïguta gotunga. Nätan trïgupa muchruntam ninawan rupachinga mana imaysi upig ninachru”. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chaynuypam Juanga jinaman tucuynaypam chay runacunata tantiachira chay mushog ali willapata. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jinarcurmi juc junagchrüga Galileachru mandag Herodesta Juanga piñaparura, wauguen Felipepa warmin Herodiaswan ishcaychanganpita, jinaman waquin lutancuna ruranganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chaura Herodes lutan rurag carga, mas juchataran ruraruras Juanta carcelman wichrgarachirga. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nätan Juan lapan runacunata bautizänan wichanmi, Jesustas bautizara. Jinarcurmi Jesús Dioswan rimayaptin jana pacha quichracarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chaylam Santu Espíritu payman aywaramura palöma nirag lapan runa ricay. Jinamanmi jana pachapita rimaramura: “Gamga cuyashä Dios-mayïmi cayanqui. Gampita aliscam cushirayä” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús nä quima chrunca watayog cayarmi ruranancuna rurayta galayura. Jesús cara runacunapitaga Josëpa churin nisham. Nätan Josëga cara Elïpa churinmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elïmi cara Matatpa churin, Matatmi cara Levïpa churin. Levïmi cara Melquipa churin. Melquim cara Janapa churin. Janam cara Josëpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josëmi cara Matatiaspa churin. Matatiasmi cara Amospa churin. Amosmi cara Nahumpa churin. Nahummi cara Eslipa churin. Eslim cara Nagaipa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaimi cara Maatpa churin. Maatmi cara Matatiaspa churin. Matatiasmi cara Semeipa churin. Semeimi cara Josecpa churin. Josecmi cara Judäpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judämi cara Joananpa churin. Joananmi cara Resapa churin. Resam cara Zorobabelpa churin. Zorobabelmi cara Salatielpa churin. Salatielmi cara Neripa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerim cara Melquipa churin. Melquim cara Adipa churin. Adim cara Cosampa churin. Cosammi cara Elmadampa churin. Elmadammi cara Erpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ermi cara Josuëpa churin. Josuëmi cara Eliezerpa churin. Eliezermi cara Jorimpa churin. Jorimmi cara Matatpa churin. Matatmi cara Levïpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levïmi cara Simeonpa churin. Simeonmi cara Judäpa churin. Judämi cara Josëpa churin. Josëmi cara Jonampa churin. Jonammi cara Eliaquimpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimmi cara Meleapa churin. Meleam cara Menapa churin. Menam cara Matatapa churin. Matatam cara Natanpa churin. Natanmi cara Davidpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidmi cara Isaïpa churin. Isaïmi cara Obedpa churin. Obedmi cara Boozpa churin. Boozmi cara Salmonpa churin. Salmonmi cara Naasonpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonmi cara Aminadabpa churin. Aminadabmi cara Arampa churin. Arammi cara Esrompa churin. Esrommi cara Farespa churin. Faresmi cara Judäpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judämi cara Jacobpa churin. Jacobmi cara Isaacpa churin. Isaacmi cara Abrahampa churin. Abrahammi cara Tarëpa churin. Tarëmi cara Nacorpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacormi cara Serugpa churin. Serugmi cara Ragaupa churin. Ragaumi cara Pelegpa churin. Pelegmi cara Heberpa churin. Hebermi cara Salapa churin. Salam cara Cainanpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainanmi cara Arfaxadpa churin. Arfaxadmi cara Sempa churin. Semmi cara Noëpa churin. Noëmi cara Lamecpa churin. Lamecmi cara Matusalenpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusalenmi cara Enocpa churin. Enocmi cara Jaredpa churin. Jaredmi cara Mahalaleelpa churin. Mahalaleelmi cara Cainanpa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanmi cara Enospa churin. Enosmi cara Setpa churin. Setmi cara Adanpa churin. Adanmi cara Diospa churin. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Chaura Jordán mayupita Jesusga cutira, nä Santu Espiritupa munayninchru cayarmi. Chaypitam Santu Espirituga pusharura jäpag pampata. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaychrümi cara chruscu chrunca junag Asyagpita juchäcachiy munasha. Chay junagcuna cara mana imatas micularmi. Chaypitam ichaga alisca micanarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jinarcurmi Jesusta Asyagga nirun: “Diospa-mayin cayarga, niy cay rumita tantaman muyunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Niptinmi Jesusga cay nirun: “Dios isquirbichinganchrüga cay niyanmi: ‘Manam tantalawanchu runaga cawan’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Niruptin Asyagga Jesusta pushara mas altunnin jircamanmi. Chaychrümi ricaparachira rätula cay pachachru lapan nacioncunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nä ricaparachirga Asyagga cay nirunmi: “Gamta chrurashay cay lapan nacioncunachru munayniyog canaypagmi, jinaman lapan ima-aygas gampa munayniquichrümi canga. Nogam chay lapan ricapungaycunata chrasquisha cä, chaymi munangäta nogaga pitas gö. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chaura gongorpacuyur naupächru alawämaptiquiga, lapansi gamlapam canga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Niptinmi Jesusga nirun: “Dios isquirbichinganchru cay niyanmi: ‘Munayniyog Dioslaytam gongorpacuyur alawanqui, jinaman paylatam servinquis’ ninmi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Niruptin Asyagga Jesusta pusharun Jerusalentam. Chaychrümi jegarachira Diospa wayin jananman mas altunnincagman. Jinarcurmi cay nirun: “Diospa-mayin carga, caypita ruyiman ishquiy. Diosga cay niyanmi isquirbichinganchrüga: ");
INSERT INTO qvnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‘Angelnïcunatam gamman cachramushag imapitas washashunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jinaman maquilancunamanmi ishquinqui mana rumiman sagtacunaypag’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Niptinmi Jesusga nirun: “ ‘Munayniyog Diosniquita amam juchäcachiyta munanquichu’ niyanmi isquirbishachrüga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Niruptin Asyagga nä mana juchäcachiyta atiparga paypita aywacura unaylapagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chaypita Jesusga cutira Galileata alisca munayniyogmi, Santu Espíritu yanapaptin. Nätan paypita alicusam rimapäcura Galilea muyurigninpa yachragcuna. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jinamanmi yachrachira Israel castacuna gotucarcänan wayicunachru, nätan lapan runacunas “Paymi ichaga ali yachrayächin” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chaypitam Jesusga aywara yachrangan Nazaret marcata. Chaychrümi jamana junagchru yaycura chay gotucarcänan wayiman, imaysi yaycuchräcunannuy. Jinarcurmi sharcurura leyinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chauraga chacchayarachin Diospa willacugnin Isaiaspa isquirbishantam leyinanpag. Jinarcurmi pachrgarcurga leyirun cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Munayniyog Diospa Espiritunga nogawanmi cayan Diosga acrarayäman mana imaynagcunata ali willapata musyachinäpagmi, nätan laquishacunata cushicachinäpagmi, jucpa maquinchru cayagcunata jorgonanpagmi, ñaushacunata ricapachinäpagmi, jinaman jucpa maquinchru cunchurcayagcunata ali cawayman jorgonäpagmi, ");
INSERT INTO qvnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Munayniyog Dios runacunata salvanan wichan cayanganta willanäpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chaynuy leyircurmi gangalanta wancurcur cutirachira chay chacchayächig runata. Jinarcurmi rimananpag tacuyura. Chaura chay wayichru carcayagcunaga lapansi rircararcayaram Jesusta. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaylam rimapayta galayura cay nir: “Cay leyimungäga nogawanmi canan ruracayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Niruptinga lapan runacunas paypita alitam rimapäcura. Jinamanmi mayacasha nirag capäcura ima-ayga shumag yachrachinganpita. Chaypitam cay niyta galacayärin: “Nätan wacga cayan Josëpa churilantar”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nipäcuptinmi Jesusga nira: “Rimanganchinuychri gamcunaga fijus ‘Jampicug naupataga quiquiquitarag jampicuy’ nircayämanqui. Gamcunaga ‘Capernaum marcachru mayacurcangänuy cay marcaychrüsi imalatas ruray’ nircayämanquichr. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nätan nogaga cayta niyärishay: Manam juclaylas Diospa willacugnincuna quiquinpa marcanchrüga alipag ricashaga canchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Razoncagtam nircayag, Diospa willacugnin Elías purinan wichan Israel-mayinchicunachru achcam viüdacuna cara. Chaypin wichan manam tamya carachu quima wata sogta quillantin. Chaymi cara alisca micuy wanay maychru chaychrüsi cay yachranganchicunachru. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Diosga chaypin manam maygan Israel casta viüdamansi Eliasta cachrarachu, antis cachraraga juclätam Sidón ninganchru cayag Sarepta marcachru yachrag viüda warmimanmi, Diospita yanapasha capäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chaynuytan Diospa willacugnin Eliseo purinan wichansi caratag Israel-mayinchicunachru gueri nirayag leprawan achca gueshyagcuna. Chaypin Eliseoga manam maygantas cuticächirachu Israel-mayinchicunataga. Antis cuticächiraga leprawan gueshyag Naamán jutiyog runalatam. Payga aywamusha cara Siriapitam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chay nigta mayarärirga lapansi chay wayichru goturarcayag runacuna aliscam piñäcarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jinarcurmi sharcurcurga Jesusta aywachicurcan marcapita washata warauman jitarpapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nätan Jesusga chay runacuna chraupinpa pasarcurmi aywacura. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chaypita Jesusga aywara Galileachru cayag Capernaum marcatam. Chaychrümi runacunata yachrachira jamacurcänan junagchru. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nätan runacunaga mayacasha niragmi capäcura razoncagta mana mancharilar yachrachiptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chay gotucarcänan wayichrüga cayaram Asyagpa cachran ruragpa munayninchru cawag runas. Jinarcurmi Asyag rimachiptin chay runaga gapachracuypa cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¿Imanarayanquitag nogacunawan Nazaretpita Jesús? ¿Nogacunaman aywaramunqui cunchuchipäcamänaypagchu? Nogaga regueyagmi pi cangaytas. Gamga cayanqui Diospita shamusham”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Niptinmi Jesusga piñaparun “Upäla cay, yargoy cay runapita” nir. Chaura Asyagga runacunapa naupanchru runata pampaman sagtarcurmi yargorura. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chauraga lapan runacunas manchacasham cay ninacurcara: “Caynuy rimagtaga ¿manam imaysi mayacuranchichu? Cay runaga rimarilartag munayninwan Asyagcunatas gargoyan” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nätan Jesús chaynuy rurangancunata limpum mayachinacarärira Capernaum marca muyurignincunapa yachragcuna. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jinarcurmi chay Israel castacuna gotucarcänan wayipita yargorcur, Jesusga aywara Simonpa wayinta. Chränanpagmi Simonpa suydranga chrachrarayänag alisca rupariyar. Chaura Jesustam nipäcura: “Cuticayächilaynar tayta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Niräriptinmi gueshyagcagman ashuyur, Jesusga chay acachay gueshyata piñaparura, jinaman chaylam cuticarura. Chaura sharcurcurmi atendichracuyta galayucun. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chaypitam nä inti chipallyayaptin paymanga chrarärichin tucuy gueshyawan gueshyarcayagcunata. Nätan payga lapan gueshyagcunatas maquinwan yatayularmi cuticächira. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jinaman achcapitam lutan espiritucunas yargapäcura cay nir gapachracurcayar: “Gamga cayanqui Diospa-mayinmi” nir. Nipäcuptinmi payga piñapara mana pasay rimapäcunanpag. Chay lutan espiritucunaga musyapäcuram ‘Salvacugtam cachramushag’ Dios ningan canganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chaypitam Jesusga nä pacha warayämuptin marcapita yargorcur aywara chunyag pampata. Nätan runacunaga Jesustam ashipäcura. Jinarcurmi chrarärira paycagman. Chaypitam “Amar maytas aywaychu caylachrünar cacushun” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nipäcuptinmi Jesusga cay nira: “Waquin marcacunatas aywanämi cayan Diospa munayninchru cawaypita willacug. Chaypagmi nogataga cachrarayäman” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chaynuypam Jesusga ali willapata musyayächir purira Judeachru Israel casta runacunata chay gotucarcänan wayicunachru yachrayächir. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jucpaychrümi Jesusga Genesaret gochra manyan pampachru cayaptin, achca runacuna paycagman chrarur chumi chumi carcayara Diospita rimanganta mayacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chaura Jesusga ricapurun ishcay büquicuna gochra manyanchru cayagtam. Nätan pescacugcunata büquinpita yargorcur ataräyancuna maylarcayagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chaura Jesusga jucnin büquiman ashuyurmi yaycura Simonpacagman. Chaypitam nira: “Ashuyächilaynar cay büquiquita mas ruyicascaman”. Ashuyarachiptinga, büquichru tacuyurmi yachrachira chay achca runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nä rimayta usharurga, Simontam nira: “Cay büquiquita aywachiy jundunninman. Chayman jitayapäcuy ataräyaycunata pescäducunata charipäcunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Niptin Simonga cay nirunmi: “Yachrachig, waraytam canan pagas pescarärï. Nätan manam ni juclaylatas charipäcushachu cä. Mä gam nimangaypa canan jitayamushag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chaura Jesús ningannuy jitayururga alisca chranin pescädutam charirärimura. Nätan chutarcayämuptinmi ataräyaga tipiyta galayurun. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chauraga gayapäcura waquincunawan jucnin büquichru cayag pescacug-mayincunatam yanapapäcunanpag. Chaura paycuna chrarärirga chutäshipäcuram. Jinarcurmi wiñarärira ishcaynin büquiman juntata, chay lasaylawan büquicunas nachrga nachrga, talpupäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chayta ricarur Pedro jutiyog Simonga Jesuspa naupanman gongorpacuyurmi cay nira: “Ashucuy Munayniyog tayta. Nogaga juchasapam cä”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chaychica pescäduta charirärimur Simonga aliscam manchacarura, jinaman paywan lapan cayagcunas. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Chaynuytan manchacarärira Zebedeopa churincuna Jacobowan Juansi. Paycuna capäcura Simonpa pescacug-mayinmi. Chaypitam Jesusga Simonta nira: “Ama manchacaychu. Cananpitaga pescädu charignuysi canqui runacunata Diosman aywachimugmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nä gochra manyanman büquicunata chrarärichimurga, pachalanchru lapanta dëjarcurmi, Jesuswan aywacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Chaypitam juc marcachru Jesús cayaptin, chrarura payman juc runa gueri nirayag lepra gueshyawan pasay ushasha. Chay runa Jesusta ricapururga, gongorpacuyurmi pampaman lipucuyura cay nir: “Munayniyog tayta, munarga cuticayächilämaynar cay gueshyapita”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Niptin Jesusga chacchayurmi yatayurura cay nir: “Munayämi cuticänayta”. Niruptinga chayüralam chay gueshyapita cuticarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaura Jesusga cay niram: “Amam cuticächingagpitaga pitas willapacunquichu. Antis ayway sacerdötiman ricapäcushunaypag, jinaman Moisés ningannuy ruramuy lapanta, razonpa cuticasha cangayta musyapäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nätan Jesús chaynuy ima-aygas ruranganpita aliscam maychru chaychrüsi mayachinacarärira. Chaymi alisca chranin runacuna aywapäcamug Jesús rimaptin mayacurcänanpag, jinaman gueshyancunapita cuticächinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nätan Jesusga aywachrag cara chunyag pampacunatam Diosta manacunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc junagchrümi achca runacunata Jesús juc wayichru yachrayächiptin, tayarcayara fariseocunawan Moisés isquirbinganpita yachrachigcuna. Paycuna shapäcamusha cara Galileachru cayag lapan acapa marcacunapitam, Judeachru marcacunapitam, jinaman Jerusalenpitam. Nätan Jesusga Diospa munayninwanmi gueshyagcunata cuticächira. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaura chaychru carcayaptinmi chrarärichira ishcay quima runacuna quirmaypa juc uncutucusha runata. Chay runacunaga wayi ruyimanmi yaycachiyta munapäcura Jesuspa naupanman. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nätan chranin runacuna capäcuptinmi mana yaycachiyta atipapäcurga wayi jananman jegarärichira quirmantinta. Chaypitam wayipa gatanta gachrachrärir wascawan jegarpachipäcura Jesuspa naupanman. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chaura Jesusga “Paymi icha cuticächingaga” nir yupachicurcayanganta tantiarurmi gueshyagtaga “Nämi juchayta perdonarug” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niptin Moisés isquirbinganpita yachrachigcunawan fariseocunaga alisca pinsiaytam galacayärin cay nir: “¿Pitag cay runaga cayan Diostucunanpagga? Juchataga Dioslam perdonan, manam pisi masga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chay nir pinsiarcayanganta Jesús tantiarurmi tapura cay nir: “¿Imanirtag chaynuy pinsiarcayanqui? ");
INSERT INTO qvnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gamcunapita, ¿maygantatag juc runa rimarilar atipanman rurayta? ¿‘Jucha perdonaytachu’ u gueshyagta ‘Sharcurcur aywacuy’ nilar cuticächiytachu? ");
INSERT INTO qvnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nätan cananga noga jana pachapita shamusha runa cay pachachru juchacunata perdonänäpag munayniyog cangäta musyapäcunaypagmi cay gueshyagta nishag: Sharcuy, quirmayta apacurcur wayiquita aywacuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Niruptilanmi chayüra gueshyagga lapan ricarcayaptin sharcurura. Jinarcurmi quirmanta apacurcur wayinta aywacura cushicuypita Diosta alawayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chauraga lapan runacunam mayacasha nirag ricacarärira. Jinarcurmi paycunas Diosta alawapäcura. Chaura runacunaga cay nipäcuram: “Cananmi ichaga ricarunchi mana pisi ruranganta” nirmi manchapacuypa rimapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaypitam Jesusga yargonganchru ricapurura Leví jutiyog runata, patenti cobracunanchru tayayagta, paytam cay nira: “Aywashun nogawan uryananchipag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Niptinga lapan imantas aygantas dëjarcurmi Jesuswan aywacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chaypitaga Levïpa wayinchrümi alisca yanupacuy cara Jesuswan micapacurcänanpag. Paywanga micurcayaratan patentita cobrag-mayincunas achca, jinaman juc runacunas. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chaura Moisés isquirbinganpita yachrachigcunawan fariseocunam pengapapäcura Jesuspa discïpuluncunata cay nir: “¿Imanirtag gamcunaga micurcayanquis, upyarcayanquis patentita cobragcunawan, jinaman jucha ruragcunawan?” ");
INSERT INTO qvnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nipäcuptinmi Jesusga nira: “Mana gueshyagcunaga manam munapäcunchu jampicugta. Jampicugtaga munapäcun gueshyagcunalam. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Manam nogaga shamurä ali ruragcuna ashigchu, antis aywarayämü juchasapacuna juchanpita wanacurcur Diosman cutipäcunanpag yachrachigmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Niptinmi chay runacunaga tapupäcura Jesusta cay nir: “¿Imanirtag alisca malagapäcun, jinarcur Diosta manacurcan Juanpa discïpuluncunawan fariseocunapa discïpuluncuna? Nätan gampa discïpuluycunaga micucurcantag, upyacurcantag imaysi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nipäcuptinmi Jesusga nira: “Casamintuman gayachishacunaga manam malagapäcunchu casaracuyag mözusi paycunawan cayaptinga. Chaymi nogapa discïpulücunas mana malagapäcungachu caychru cayangäcamaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Chrämungam nogata aywachicarcamänan junag. Chaymi ichaga laquicuypita malagapäcungaga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jinaman caynuypas tantiachiratan: “Manam pisi mushog jacupita uchuclata lachircur, macwa jacuman jiranchu. Chaynuy rurarurga mushog jacutam perdichin, nätan mushog sagpiwan jirashaga macwa jacusi manatan tincunchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Manatan pisi vïnuta rurarur chruranchu garapita macwa wagalamanga. Chaynuy ruraruptinga vïnu pogorimur lachichinmi macwa wagalata. Chauraga ishcayninmi manacagman ruracan. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chaymi vïnuta rurarga chruranchi mushog wagalaman mana maygansi pampanman ruracänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nätan pisi pogosha vïnu upyacugga manam munanchu chayrag rurashalataga, ‘Pogoshacagmi shumagga’ nir. Chaynuymi mushog cawaypita yachrayächingätas mana munapäcunchu ‘Unaycagmi mas aliga’ ” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jucpaychrümi jamana junagchru Jesusga discïpuluncunawan pasapäcura trïgu pogoyämug chracrapa. Jinarcurmi discïpuluncunaga juc ishcay trïguta tipiricur, maquincunawan cupachrärir micaricurcara. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chaymi juc ishcay fariseocuna Jesusta nipäcura: “¿Imanirtag gamcunaga jamana junagchru cayar chay mana ruranacunata rurarcayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nipäcuptinmi Jesusga nira: “¿Manachu gamcuna leyipäcuray juc cutichru Rey Davidwan cayag runancuna micanasha purir Diospa wayinman yaycurcur, Diospag chrurasha tantata Davidwan runancuna micapäcunganta? ");
INSERT INTO qvnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Chay tantata micapäcug cara chay Diospa wayinchu sacerdöticunalam, manam pisi jucga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nircursi Jesusga cay niraran: “Noga jana pachapita shamusha runapagga jamana junagsi cayan munaynïchrümi” niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nätan yapaytan juc jamana junagchru Jesús yaycura Israel castacuna gotucarcänan wayiman. Chaychru yachrayächiptinmi cayara juc runa derëcha maquin uncusha. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chaura Moisés isquirbingancunapita yachrachig runacunawan fariseocunam shuyararcayara jamana junagchru Jesús cuticächinanta, wactam u caytam rurarun lutanta nipäcunan raygo. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Chaynuy pinsiarcayanganta tantiarurmi Jesusga chay maquin uncusha runata cay nira: “Sharcuy. Cay chraupiman shamuy”. Niruptin runaga chraupimanmi shayurun. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chaura Jesús chaychru carcayag runacunatam cay nira: “Tapuyärishay juclaylata. ¿Jamana junagchru imata ruranapagta isquirbirayan, alita ruranapagchu u lutanta ruranapagchu? ¿Wanunanpita runata salvanapagchu u wanuyagtas rircaränapagchu?” ");
INSERT INTO qvnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nircurga muyurigninchru lapan runata rircärirmi, chay maquin uncusha runata nira: “Uncusha maquiquiwan chacchayuy”. Ningannuy chacchayuruptinga chaylam maquin cuticarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chaura Jesusta ashipag runacunaga aliscam piñäcarärira. Chaypitam quiquincama cay ninacurcara: “¿Imatatag ruraruchwan Jesusta?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay junagcunalam Jesús aywara juc gotuta Diosta manacunanpag. Chay pagas wararura Diosta manacuyälarmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nä pacha wararuptinmi acrara discïpuluncunata. Chaypitam acrara chrunca ishcayniyogta, jinarcurmi jutipara ‘Cachra rurag’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Chay acrashancuna cara: Simonmi. Payta Jesús jutipara ‘Pedro’ nirmi. Chaypitam cara Simonpa wauguen Andrés, Jacobo, Juan, ");
INSERT INTO qvnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Felipe, Bartolomé, Mateo, Tomás, Jacobo Alfeopa churin, ‘Celote’ nipäcungan Simón, ");
INSERT INTO qvnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacobopa churin Judas, nätan Jesusta wanuchipäcunanpag reguechig Judas Iscariotem. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chaypitam Jesusga chrarpamura gotu chraquin jatun pampaman lapan discïpuluncunawan. Chaymanmi alisca chranin runacuna, lapan Judeapita, Jerusalén marcapita, Mediterráneo gochra manyanchru cayag Tïrowan Sidón marcacunapita. Chay runacuna shamusha capäcura Jesús yachrachiptin mayacugmi, jinaman gueshyancunapita Jesús cuticächinanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Chaychrümi Jesusga cuticächira lutan espiritucuna cunchuyächingan runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nätan lapan runacunas Jesús yatayuytam munapäcura, imawan gueshyagcunas payta yatayular munayninwan cuticapäcuptin. Payga cuticächira lapantam. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chaypitam discïpuluncunata rircärir Jesusga cay nira: “Cushisham carcayanqui Diospa naupanchru ‘Manacagmi cayä. Yanapämay’ nigcuna. Gamcunaga Diospa munayninchrümi nä cawarcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Cushisham carcayanqui Diosta canan reguey munayagcuna. Gamcunaga Diosta reguepäcunquim. Cushisha carcayanqui canan wagayagcuna. Gamcunataga Dios perdonapäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Cushisham carcayanqui, noga jana pachapita shamusha runapa janä runa-mayiquicuna chregnipapäcushuptiqui, gargapäcushuptiqui, ashlipäcushuptiqui, lutan ruragpag ricapäcushuptiqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chaynuy rurapäcushuptiqui alisca cushicurcay, jana pachachrüga alipag ricasham capäcunqui. Chaynuymi awilluycunas alisca cunchuchipäcura Diospa unay willacugnincunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nätan cay pachachru caglata imanuypanuysi ashigcunaga aliscam cunchupäcunqui. Gamcunaga chay capogniyog capäcungaypita cushirarcayanquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nätan Dioswan mana caway munayagcunaga aliscam cunchupäcunqui. Gamcunaga timpu pasashachrüran Dioswan cawayta munapäcunqui. Jinaman juchäcurcangaypita cushirayagcuna aliscam cunchupäcunqui. Gamcunaga chaypitaran ‘¿Imanarärag?’ nir wagapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nätan lapan runacunapita alawashacunas aliscam cunchupäcunqui. Chaynuymi taytaycuna alawapäcura Diospa willacugnintucur shamugcunata”. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nätan gamcuna mayacarcayämagcuna caynuy cawapäcuy: Mana ricapuy munashugniquicunata cuyapäcuy. Chregnipäcushugniquicunata alipa ricapäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","‘Payga lutanmi’ nishugniquicunata ‘Payga alim’ nipäcuy. Lutanpa ricashugniquicunapag Diosta manacurcay. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pisi cäraychru lagyarushugniqui chulantas camayapuy. Catayta guechrushuptiqui janan jacuytawan goruy. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pisi imalatas manacurcäshuptiqui gopäcuy. Imayta guechrushuptiquis ama ‘Cutichimä’ niychu. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gamcuna munarcayanqui runa-mayiquicuna alipa ricapäcushunaytam, chaynuy gamcunas paycunata alipa ricapäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Cuyapäcushungalayta cuyapäcurniqui ¿alitachur rurarcayanqui? Juchasapacunas cuyapäcunmi cuyaglantaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Alipa ricapäcushugnilayta alipa ricapäcurniquis ¿alitachur rurarcayanqui? Juchasapacunas alipam ricapäcun alipa ricagnilantaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‘Payga imalatas gomangachr manangäpita’ nir manapäcurniquiga ¿alitachur rurarcayanqui? Juchasapacunas mananacurcanmi imalatas mananganpita chrasquinan raygoga. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nätan gamcuna cuyapäcuy mana ricapuy munapäcushugniquicunata jinaman alipa ricapäcuy. Nätan manapäcungaypita ama imatas shuyarapäcuychu. Chaynuy jinarga capäcunqui alinninpag ricasham, jinaman capäcunqui jana pachachru cayag Diospa castancunam. Diosga alisca alim lutan runapagsi, jinaman payta mana yarpagcunapagsi. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gamcunas paynuy cuyapäcug capäcuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Amatan pitas ‘Gamga juchäcurayanquim’ nipäcunquichu. Gamcunas mana chaynuy nisha capäcunaypag. Amatan pitas ‘Wacga wacnuy u caynuy rurasha’ cachun juchanpita nipäcunquipishchu, mana chaynuy nisha gamcunas capäcunaypag. Antis perdonapäcuy runa-mayiquicunata, perdonasha capäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gamcuna imanuymi runa-mayiquita rurarcayanqui, chaynuymi gamcunatas rurapäcushunqui, jinaman masran gamcunataga rurapäcushunquis. Chaura imanuymi runa-mayiquicunata rurapäcuray, chaynuymi cutichisha capäcunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesusga tantiachiratan caynuypas: “Manam juc ñausha runa pushapanmanchu ñausha-mayinta. Chaynuy carga ishcayninmi ishquirärinman uchrcuman. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Chaymi chayrag yachracuyag discïpulüsi yachrachigninnuyga mana yachranragchu. Lapanta yachracururmi ichaga cangaga yachrachigninnuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Chaura ¿imanirmi imalapitas juchachayanqui runa-mayiquita, quiquiqui mas juchasapa cayarga? ");
INSERT INTO qvnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chaynuy cayarga amam ‘Juchaypita wanacunaypag yanapäshay’ ninquimanchu. ¡Alitucug! Naupataga juchaycunapitarag wanacuy. Chaypitam ichaga “Juchaypita wanacuy” ninquiga. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Musyanganchinuysi ali montiga manam wayunchu lutan mishquitaga. Manatan lutan montis wayunchu ali mishquitaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chaura montitaga reguenchi wayuyninpam. Manam hïgos mishquita cashacunapitachu palanchi. Manatan üvas mishquitas garajanchraypitachu palanchi. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chay montinuymi ali runas alita ruran. Nätan lutan runaga lutanta ruran. Chaura runaga imatas ruran imanuysi canganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtag ‘Munayniyogmi’ nircayämanqui, rurapäcuy niyangätas mana rurarcayarga? ");
INSERT INTO qvnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pi maysi nogaman aywamugga, wiyarimagga, jinaman cäsucamagga cayan cay runanuymi; ");
INSERT INTO qvnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Juc runam wayita sharcachinanpag naupataga uchrcun gagata taringancama. Chay gagapitaran galayurun sharcachiyta. Chauraga mayu chrarparamur wayimancama lagyaptinsi manam loglachirachu chay wayi gaga jananpita sharcachisha captin. ");
INSERT INTO qvnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nätan ningäta mayacuyarsi mana cäsucugmi ichaga cayan, mana uchrcular, jinaman mana cimintuta ruralar wayi sharcachignuy. Chaura mayu chrarparamur wayimancama lagyayaptilanmi chay wayiga pasay juchrurun, pampanman ruracangancama”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chaypita nä chaychru cayag runacunata yachrarcachirga, Jesús yaycura Capernaum marcamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chaura Romapitam juc runa cara pachrac soldäducuna mandag. Paypam cara alisca cuyay rantisha runan. Chay runanmi gueshyarunag aläpangancama. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chaura chay soldäducuna mandagga Jesuspita mayarurmi, cachracamusha Jesusman juc ishcay alinninpag ricasha Israel castacunata chay cuyay rantisha runanta cuticächinanpag pushag. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chaura cachracungan runacunaga Jesuscagman chrarärirga cay nipäcuram: “Tayta, pasaynar aywaläshun, chay mandagga ali runam yanapayulaynar. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Payga Israel castacunata cuyamanchim. Chaymi gotucänanchi wayitas sharcarayächipamanchi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chaynuy niräriptin Jesusga aywara paycunawanmi. Nä wayinman nachrgarcayaptinmi, chay soldäducuna mandag runaga cachracururatag yapay juc ishcay cuyashancunata Jesusta cay nipäcunanpag: “Munayniyog tayta, manam wayïcama chrämunayragchu. Nogaga manam maygan alinninsi cächu wayïman yaycamunaypagga. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chaymi quiquïga ashigniquis shamurächu, antis cuticänanpag chay cayangalaychru niruptiquiga rantisha runäga cuticarungam. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nogas cayäga juc mandagpa munayninchrümi. Nätan nogapa munaynïchrüsi cayantan soldäducuna. Chaura juc soldäduta ‘Shamuy’ niptï shamunmi. Nätan jucta ‘Ayway’ niptïsi aywanmi. Chaynuytan rantisha runäsi niptïga ruran”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chaynuy nigta Jesús mayarurga, mayacasha niragmi ricacarura. Chauraga achca runa gatirarcayagman muyurcurmi cay nira: “Caynuy alisca yupachicamag runata manam tarirächu cay Israel casta runacunachrüga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chay cachracungan runacuna mandagpa wayinman nä cutiyarärirga tarirärira gueshyagtaga nä cuticashatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaypitam Jesusga Naín marcata aywayara achca discïpuluncunawan, jina guepantam gatirapäcura achca runacuna. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jinarcurmi nä marca yaycuna puncuman nachrgarcayaptin, yargarcayächimunag juc wanusha mözuta enterrapäcunanpag achca runacuna. Chay mözuga cara juc viüdapa japalan wawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chaura Munayniyog Jesusga wanushapa maman alisca wagayagta ricapururga cuyaparunmi. Jinarcurmi “Ama wagaychu” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nircur Jesusga wanturcayagman ashuyurmi yatayurun. Jinarcurmi wantugcuna shayaräriptin Jesusga wanusha “Mözutaga, ¡sharcuy!” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Niruptinmi wanusha mözuga tayuy pacha ratarun. Jinarcurmi rimayta galayurun. Chaura Jesusga mamantam “Cä mözuy” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chayta ricarärir lapan runacunam manchacarärira. Jinamanmi Diosta alawapäcura cay nir: “Diospa alisca munayniyog willacugninmi noganchiwan cayan. Diosmi cachraramun noganchita yanapämänanchipag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nätan Jesús chaynuy ruranganpita runacunaga mayachinacarärira Judea ninganchru lapan marcacuna cayagpam. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Chaura Jesús chay lapan ima-aygas rurayangantam Bautizag Juantaga discïpuluncuna willapacarärira yachrachignin Juanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Chay willaparäriptinmi Juanga ishcay discïpuluncunata gayarcur cachrara Jesusman “¿Gamchush, ‘Salvacugtam cachrashag’ Diosga ningan shuyacurcayangä cayanqui u juctaragchush shuyapäcushag?” nir tapug. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chaura chay cachra aywagcunaga Jesuscagman chrarärirga tapupäcura: “Bautizag Juanmi cachrararcayäman tapugniqui, ‘¿Gamchush cayanqui shuyacurcayangä Cristo u juctaragchush shuyapäcushag?’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Niräriptin Jesusga chayüram cuticächira ima-aygawansi gueshyag achca runacunata, lutan espiritupa munayninchru cayag runacunata, jinaman achca ñaushacunatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chaura Jesusga chay runacunatam cay nin: “Cutipäcuy Juanman. Willapäcamuy ricapäcungaytawan mayapäcungayta. Jinaman nipäcamuy ñaushacunata ricapayächingäta, ratacunata cuticayächingäta, gueri nirayag leprawan gueshyagcunata cuticayächingäta, upacunata cuticayächingäta, wanushacunata cawacayächingäta, nätan mana imaynagcunata ali willapata willapayangäta. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chaura pi maysi ‘Payga razonpa Diospa acrashanmi’ nimagga cushisham canga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chaura Juan cachramungancuna nä cuticurcaptinga, chaychru cayag runacunatam Jesusga rimapara Bautizag Juanpita cay nir: “¿Imanuy runa ricagtag jäpag pampata aywapäcuray? ¿Walyaywan juc chagla cuyugnuysi manacag runa ricagchu? ");
INSERT INTO qvnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chaura ¿imanuy runa ricagtag aywapäcuray? ¿Juc runa alisca alinnin jacupäcusha ricagchu? Manam. Gamcuna musyapäcungaynuysi chaynuy alinnin jacushacunaga carcayan reycunapa wayincunachrümi ima-aygatas shongon munanganta rurarcayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chaura ¿imanuy runa ricagtag aywapäcuray? ¿Diospa willacugnin runa ricagchu? Au. Payga cayan Diospa lapan willacugninpitas mas alinnincagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Paypitam isquirbirayan cay nir: ‘Naupaytam cachrayä willacugnïta, gam chränaypag runacunata camarinanpag’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nipäcushay Diospa lapan willacugnincunachru manam maygansi carachu Bautizag Juannuy Jesús chrämunanpag runacunata camarigga. Nätan canan Diospa munayninchru cawagcunaga manacagpag ricasha cayarsi carcayan Bautizag Juanpitaga mas cushisham”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chaymi Juan ninganta mayarärirga lapan runacunasi, jinaman patentita cobragcunasi tantiarärira Dios ali rurag canganta, jinamanmi bautizächicarärira Juanwan. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nätan fariseocunawan Moisés isquirbinganpita yachrachigcunaga, manam Juanwan bautizächicuyta pasay munapäcurachu. Chaynuypam paycunaga Dios salvayta munayaptin mana munapäcushachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chay nircurmi Jesusga cay nira: “¿Imawantag tincuchïman chaynuy runacunata? ¿Imaman ticragtag carcayan? ");
INSERT INTO qvnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chaycuna carcayan walashcuna pläzachru tacayärir walash-mayincunawan cay nir turyapänacugnuymi: ‘Quënäta töcaparcayaptïsi manam tushupäcunquichu, wagay wagaylata cantapapäcuptïsi manatan wagapäcunquichu’. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chay nir turyapagnuymi Bautizag Juan aywaramur mana tantata micuptin, jinaman vïnuta mana upyaptin, ‘Cay runaga lutan espiritupa munayninchrümi cayan’ nipäcuray. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nätan noga jana pachapita shamusha runa micuptïmi upyaptïmi, ‘Cay runaga micuyarsi manam yamanchu, upyayarsi manam yamanchu. Lutan ruragcunawanmi, jinaman patentita cobragcunawanmi cuyanacunsi’ nircayämanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nätan Dios ali rurag cangantaga musyapäcun paypa runancunalam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chaypitam Simón jutiyog fariseo ningan runaga, Jesusta yaparcur yaparcur cay nira: “Tayta, aywashunnar micug wayïta”. Niptinmi Jesusga aywara. Jinarcurmi nä wayiman yaycurga iscatacuyur mësachru micurcayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chaychru Jesús micuyanganta mayarurmi, chay marcachru yachrag juc lutan rurag warmiga, chay fariseopa wayinman chrarura yurag rumi botëllachru perfümin apasha. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jinarcurmi Jesuspa nä chraquincagman chrarur wagacuptin weguen shutura Jesuspa chraquinman. Chay weguen shutushataga agchanwan chaquichira Jesuspa chraquinta muchayur muchayur. Jinayanganpitam perfümi apanganwan lushirura. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chay jinagta ricarmi, micapäcunanpag pushag Simonga shongolanchru Jesuspag cay nira: “Cay runa razonpa Diospa willacugnin carga, tantianmanchri alisca lutan rurag warmi yatayanganta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chaura Simón shongolanchru niyanganta tantiarurmi Jesusga cay nira: “Simón, cayta niyushay”. Niptinmi “Mä nimay” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chaura Jesusga cay nirunmi: “Jucpaychrümi capäcura ishcay runacuna. Jucnincagmi juc golgueyog runapita manutucusha cara pichga pachrac junagchru gänanan golgueta, nätan jucnincagmi manutucusha cara pichga chrunca junagchru gänanan golgueta. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jinarcurmi chay golgue cutichiyta mana atipapäcuptinga, chay golgueyog runaga ‘Jina cachun, ama cutichipäcamaychu’ nirura ishcayninta” Nircurmi Jesusga Simonta tapura cay nir: “Mä nimä, ¿mayganrag chay manutucushacunapita masga cuyanman chay golgueyog runata?” ");
INSERT INTO qvnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Niptinmi Simonga “Nogapitaga mas achca manutucushacagchri” nira. Chaura Jesusga “Alitam nirunqui” niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chaypitam warmita rircärir Simontaga cay nira: “¿Ricayanquichu cay warmi rurayanganta? Wayiquiman yaycamuptï gamga manam gomaraychu yacuta chraquïpag. Cay warmin ichaga weguenwan maylaraman chraquïta. Jinamanmi agchanwan chaquirachin. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gamga manam muchamaraypishchu. Cay warmim ichaga yaycamunganpita-pacha chraquïta mucharun. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gamga manatan lushimaraychu aceitiwan umätas. Cay warmim ichaga perfümiwan lushiraman chraquïta. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chaymi gamta niyushay, chranin juchanpita perdonacarur runaga aliscam cuyan chay perdonagninta. Nätan walcala juchanpita perdonasha runaga manam aläpachu cuyan chay perdonagninta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nircurga warmitam cay nira: “Nämi juchaycunapita perdonarug”. ");
INSERT INTO qvnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chaynuy niruptin chaychru micug-mayincunaga cay ninacurcaram: “¿Pitag cay runaga cayan juchacunata perdonänanpagga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nipäcuptinmi payga yapay warmita nira: “Lapan shongoypa yupachicamangaypitam nä salvasha cayanqui. Cananga aywacuy cushisha”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaypitam Jesusga aywara jatun marcacunapas, jinaman ichic marcacunalapas ali willapata willapacuyar, nätan Diospa munayninchru cawaypita ali willapata willapäcuyar. Chay aywar Jesusga purira chay chrunca ishcayniyog cachran ruragcunawanmi, ");
INSERT INTO qvnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","jinaman ishcay quima warmicunawanmi. Chay warmicuna capäcura lutan espiritupa munayninpita jorgosham, jinaman gueshyacunapita Jesús cuticächingancunam. Jucpam jutin cara María. Payga cara Magdala marcapitam. Paypita Jesusga gargorura ganchris lutan espiritutam. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nätan jucmi cara Juana. Payga cara Cuzapa warminmi. Chay Cuzaga cara Rey Herodespa capuralninmi, nätan jucmi cara Susana. Jinaman capäcuratan mas achca warmicunas ima-aygawansi yanaparcayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Chaura marcacunapitam alisca chranin runacuna Jesuscagman chrarärimura. Chaychrümi Jesusga tarpug runawan tincuchiypa yachrachira cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc runam yargora murug. Jinarcurmi wichiypa tarpuyaptin waquin muruga ishquirura camiñucagman. Chaychru jarucashatam pishgocuna shamurga micarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nätan waquin murucunam shala shalaman ishquirärira. Jinarcurmi yargarcamular chaquirura mana ogo alpa captin. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nätan waquin murucunam ishquirura casha cashaman. Jinarcurmi chayrag wiñay nacayämuglata casha chicchiramurga pasay nitirura. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nätan waquin murucunam ishquirura ali alpaman. Chaymi ichaga ali yargaramura. Jinamanmi gueshpirura alisca, juclaylapita pachractacama”. Chaynuy nircurmi Jesusga gayachracuypanuy: “Mayacarcayämagcuna, tantiay munagga tantiacurcay” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Niptinmi discïpuluncunaga tapurärin: “¿Ima ninantag cayan chay rimangayga?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nipäcuptinmi Jesusga cay nira: “Gamcunataga Diosmi musyarcayächishunqui, mana pisi musyanganta Dioswan cawaypita. Nätan waquincunataga rimapayä imawansi tincuchiypam. ‘Ricarcayarsi mana ricagnuy capäcuptin, mayacayarsi mana mayagnuy capäcuptin’. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Chay tarpugpita rimangäga cay ninanmi: Chay muruga Tayta Diospa ali willapanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nätan chrucru camiñunuymi capäcun waquin runacuna. Paycuna mayacurcanmi Diospa willapanta. Jinatam Asyag aywaramur gongarachin chay mayacunganta, camiñuchru muru cayagta pishgo palarugnuysi. Diospa willapanta ‘Mana razonchri’ nipäcunanpag, jinaman chaynuypa mana salvacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nätan shala shalanuymi capäcun waquin runacuna. Paycunas Diospa willapanta mayacurcanmi, jinaman cushisham chrasquicurcan. Chaypitam unaylataga imalas caruptin ishquicarärin muru sapichacushanuysi mana capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nätan casha cashanuymi capäcun waquin runacuna. Paycunas Diospa willapanta mayacurcanmi, jinaman ima-aygas rurayninmi, iman aygansi capunganmi, shongon munangannuy cawanganmi, ishquicächin. Chaynuy capäcurmi mana imatas alitaga rurapäcunchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nätan ali alpanuymi waquin runacunaga capäcun. Paycunaga Diospa willapanta mayacur lapan shongonpam chrasquicurcan. Jinamanmi mayapäcunganta mana gongapäcunchu. Chaymi alita rurayar imaysi cawapäcun. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Musyapäcungaynuysi manam pisi michïruta ratachinchu mancawan chaparunanpagga u cäma pachranman chrurarunanpagga. Antis michïrutaga chrurapäcun cacunanmanmi yaycugcuna ali ricapapäcunanpag. Chay achquinuymi gamcunas cawayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chaura ima pacashas manam canchu mana musyacashaga, manatan pi imata pacarachingansi canchu mana musyacashaga. Chaynuymi yachrayächingäsi mas guepamanga shumag musyacasha canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chauragar tantiapäcuy shumag cay mayacurcangayta. Pisi tantiay munagga mastan tantianga. Nätan pisi mana tantiay munagga camala tantiayangantas gongarungam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chay niyaptilanmi maman, jinaman wauguencuna chrarärira Jesús cayanganman. Nätan achca runacuna captinmi, yaycuyta mana atipapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaura willarärira Jesustam cay nir: “Mamaywan wauguequicunam washachru carcayan. Gamwan tincuytash munarcayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Niräriptinmi Jesusga nira: “Pi maysi mamäga, wauguëcunaga, Diospa willapanta lapan shongonpa mayacugmi, jinaman cäsucugmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chaypitam juc junagchrüga Jesús yaycura juc büquiman discïpuluncunawan. Jinarcurmi paycunata nira: “Acu, pasashun cay gochra chimpaman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chaura nä aywarcayaptinmi Jesusga punucarura. Chaylam mayänipita alisca walyamuyta galacuyura. Chauraga yacu alisca lagyayaptinmi büquiman wiñacayta galacuyura. Jinamanmi nä talpurcayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaura Jesuscagman ashuyurmi riccharärichira cay nir: “¡Yachrachig, yachrachig! ¡Nämi talpuyanchi!” Nipäcuptinmi Jesusga riccharcamur walyaytas, jinaman yacu altumancama sharcuyagtas piñaparura. Chaylam walyaysi, yacusi shumag amaynarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chaura discïpuluncunataga cay nirunmi: “¿Imanirtag mana yupachicarcämanquichu?” Chaura paycunaga manchacasham, jinaman mayacasha niragmi ricacarärira. Chaymi quiquincama tapunacurcara: “¿Pitar cayan cay runaga? Walyaysi, yacusi rimariptilantag amaynarun” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chaypitam chrarärira Galilea chimpan Gerasa marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chaura Jesús büquipita pampaman yargoyaptinmi chraramura Gadarapita juc runa. Chay runata nä unayshi lutan espiritucuna löcurärichinag. Chaura nä manash jacucurachu, ni wayichrüsi yachrarachu, antis cacug panteoncunalachrüshi. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jinarcurmi Jesusta ricapururga gongorpaypa ratarura Jesuspa naupanman gapachracuypanuy cay niyar: “¿Imamantag aywaramunqui nogaman, jana pachachru Diospa-mayin Jesús? Amanar cunchuchimaychu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Asyagga chaynuypa Jesusta nira, cay runapita “Yargoy” niptinmi. Chay runata Asyagga nä unaypitash munanganta rurachira. Chaura runacunaga watapäcug cadenawanshi maquintas, chraquintas mana maytas aywananpag. Payga nätan watapäcunganta tipircurshi gueshpicug jäpag pampacunapa Asyag aywachiptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chaura Jesusga “¿Imam jutiqui?” nirmi tapura. Niptinmi runaga nira: “Sogta warangam”. Chaynuypa nira alisca chranin espiritupa munayninchru carmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nätan espiritucunaga Jesusta manacurcara: “Tayta, amar jitapäcamaychu mana ushayniynag yanauyagmanga” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chaura gochra tunanpa achca cuchicuna micurcayagta ricapurmi chay lutan espiritucunaga Jesusta manacarärin chay cuchicunaman yaycapäcunanpag. Manacaräriptin Jesusga “Äri” niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chaura chay runapita Asyagcuna yargaräriraga, cuchicunamanmi yaycarärira. Jinarcurmi cuchicunaga juyu waraman yaycurcur, gochraman jegarparärira. Chaychrümi shengaypa wanurärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nätan cuchi michircayagcuna chayta ricarärirga, alisca manchacasham gueshpiypa nirag aywacurcara marcata willacug. Chay aywar willapacurcara tincungan runacunatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chaymi runacunaga aywapämusha ima pasangantas ricag. Nä Jesuscagman chrarärirga, lutan espiritucuna dëjangan runataga tarirärira Jesuspa naupanchru nä fisyun chrämushatam, jinaman jacusha tayayagtam. Chaura runacunaga manchacaräriram. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chayta ricag runacunaga, chay chrämug runacunata willapacarärira shumagmi, imanuypa chay runata Jesús cuticächingantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chaura willaparäriptin, Gadara runacunaga alicusam manchacurcara Jesusta. Chaymi cay nipäcura: “Tayta, nogacunapita aywacuynar” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Chaura niräriptin Jesús büquiman nä yaycuyaptinmi, chay cuticasha runaga Jesusta cay nirun: “Tayta, aywacushunnar nogawansi” nir. Niptin Jesusga cay ninmi: ");
INSERT INTO qvnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Manam. Antis cuticuy wayiquita. Chaychru willapacamuy Tayta Dios cuyapäshurlay cuticächishungayta”. Niruptin runaga aywacura chay marcachru lapan runacunata Jesús cuticächinganpita willapacuyarmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús nä gangalanta caylä chimpaman cutiramuptinga, shuyararcayag runacunaga aliscam cushicarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chaylam Jesusman chraramura Jairo jutiyog runa. Payga Israel castacuna gotucarcänan wayichrümi mandag cara. Chaura Jesuspa naupanman gongorpacuyurmi Jairoga “Tayta, aywaläshunnar wayïta. Churïmi nä pasay wanunayan” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Paypa churin cara juclay warmi wamralam, nä chrunca ishcayniyog watayognuy. Chaura Jesús aywaptin runacunaga, alisca achcam, chumi chumi aywapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chay aywagcunachrümi aywanag yawar apaywan nä chrunca ishcayniyog wata gueshyag warmis. Payga jampicunalachru ima-aygancunatas nä usharunag, nätan maygan jampicugsi manash cuticächiyta atiparachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chaura payga guepalapa yaycurcurmi Jesuspa catanpa tumanta tupayurunag. Jinaman chayla yawarninga tacyarunag. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chauraga Jesusga “¿Pitag tuparaman?” ninmi. Niptinga lapansi “Manam nogaga” nipäcuram. Chaura Pedrom cay nira: “Yachrachig, runacunam chumircayäshunquis, cumarcayäshunquis. Chaytam ‘¿Pitag tuparaman?’ niyanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Niptinmi Jesusga nirun: “Jucmi pisi tuparaman. Musyayämi munaynïwan cuticächingäta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Niptin warmiga nä mana pacacuyta atiparga, Jesuspa naupanman chucchucyayar gongorpacuyurmi, lapanpa naupanchru nirura imanir tupayungantas, jinaman chayürala cuticangantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chaura chay warmitam Jesusga cay nirun: “Wamralä, yupachicamarmi cuticarunqui. Cananga cushisha aywacuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Warmita nir rimapayaptilanmi, chraramura mandag Jairopa wayinpita juc runa cay nig: “Nämi wamrayga wanurun. Ama Jesusta nä pushamuychu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chay niyanganta Jesús mayarurga, Jairotam cay nin: “Ama manchacaychu. Yupayla yupachicamayga, churiquiga cawangam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chaypitam nä wayiman chrarur Jesusga pitas mana yaycachirachu wanushacagmanga. Yaycachiraga Pedrotam, Jacobotam, Juantam, jinaman wamrapa taytantawan mamalantam. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nätan chaychru wamra wanushapita wagarcayagtam, racrarcayagtam Jesusga cay nira: “Ama wagapäcuychu. Wamraga manam wanushachu. Punucashalam cayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chay niruptin chay wamra wanusha cayanganta musyagcunaga asiparärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chaura Jesusga chay wanusha wamrapa maquinta chariyurmi gayachracuypanuy: “Wamra, ¡sharcuy!” ");
INSERT INTO qvnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Niruptin wanushaga cawacaramunmi. Jinarcurmi chayüra sharcurura. Chaura Jesusga micuyta gopäcuy niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nätan wamrapa taytanwan mamanga mayacasha niragmi ricacarärira. Chaura Jesusga nirura chay cawacächinganpita mana pitas willapacurcänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Chaypitam Jesusga chrunca ishcayniyog discïpuluncunata gayarcur nira lutan espirituta runacunapita gargapäcunanpag. Jinaman gueshyagcunata cuticächipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jinarcurmi cachrara Diospa munayninchru cawaypita willapacug, jinaman gueshyagcunata cuticächig. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chay cachrarmi cay nira: “Ama imatas apapäcuychu, ni garrotitas runcutas tantatas golguetas ni müdanaycunatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nätan pipa wayinchrüsi gorpachacururga, chaylachru capäcuy chay marcapita aywacurcangaycama. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nätan mayag marcachrüsi mana chrasquipäcushuptiquiga, ‘Imanuysi cacurcay manam mastaga cayman jarumushagchu’ nirmi aywacurcanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Niruptin, discïpuluncunaga aywapäcura lapan acapa marcacunapam, runacunata ali willapata willayar, jinaman gueshyagcunata cuticayächir. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chaypitam Galileachru Rey Herodesga mayarura Jesús lapan ima-aygatas rurayanganta. Chaura manam imanänansi yachracarachu, waquin runacuna “Bautizag Juanmi cawacämusha” nipäcuptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Waquin runacuna “Eliasmi ricacaramun” nipäcuptin. Nätan waquincuna “Diospa unay willacugninchri maygansi cawacaramun” nipäcuptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Chaura Herodes cay niram: “Juantaga mogochishatag cä. ¿Pitag chaura canman chay ima-aygas rurayag runaga?” nirga, Jesustam imanaypanuysi ricapuyta munara. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chaura chay cachran ruragcuna cutiyarärimurga willapacurcara Jesustam ima-ayga rurapäcungantas. Chaura payga discïpuluncunata pushacurcurmi, aywacura chunyag pampata Betsaida marcacagpa. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chay aywanganta musyarärir runacunaga gatirapäcuram. Nätan Jesusga lapantas alipa chrasquircurmi rimapara Diospa munayninchru cawaypita, jinamanga cuticächiratan gueshyagcunatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nä pacha chacanayaptinga chay chrunca ishcayniyog discïpuluncunaga Jesustam cay nirärin: “Tayta, caychrüga jäpag pampachrütag cayanchi, runacunata ‘Aywacurcay’ niruy, gorpachacugsi micuy ashigsi u maylamansi aywacurcänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nipäcuptinmi Jesusga nira: “Gamcuna micuyta gopäcuy”. Niptinmi paycunaga “Pichga tantawan, ishcay pescädulatam chararcayäga. Chauraga micuy rantig imaragchri aywapäcushag cay lapan runapagga” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaychru olgocuna capäcura pichga waranganuymi. Chaura Jesusga discïpuluncunatam cay nira: “Cay runacunata tayachipäcuy pichga chruncatacama”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ningannuymi lapan runacunata tayarärichira. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chaura Jesusga chay pichga tantatawan ishcay pescäduta aptacurcurmi, jana pachata rircarircur, Diosta “Gracias Tayta” nicura. Chaypitam discïpuluncunata gorura lapan runacunata aypuchracurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jinarcurmi lapansi micarärira yamapäcungancama. Nätan puchupacurcangantam shuntarärira chrunca ishcayniyog balay juntata. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Chaypitam juc junagchru, Jesusga Diosta manacuyara japalan. Jinarcurmi chaychru cayag discïpuluncunata Jesusga tapura: “¿Nogapag pimi nircayantag runacuna?” ");
INSERT INTO qvnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Niptinmi discïpuluncunaga cay nipäcura: “Waquinga Bautizag Juanmi nircayäshunquim. Waquinga ‘Eliasmi’ nircayäshunquitan. Nätan waquinga ‘Diospa unay willacugninchri maygansi cawacaramun’ nircayanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Niräriptinga discïpuluncunatam tapura: “Gamcunagä, ¿pimi cayan nircayämanquitag?” Niptinmi Pedroga nira: “Gamga canqui Diospita shamusha Cristom”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Niruptinmi Jesusga nira: “Amam pitas willapacurcanquichu Cristo cangäta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chaypitas cay niraran: “Noga jana pachapita shamusha runataga aliscam cunchuchipäcamanga. Jinarcurmi wanuchipacamanga. Chaynuy rurapäcamanga alinninpag ricasha chacha runacunam, Diospa wayinchru mandagcunam, jinaman Moisés isquirbinganpita yachrachigcunam. Chaypita quima junagtaga cawacämushagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nircurmi chaychru lapan carcayagcunata nira: “Pi maysi gatirämay munagga ama quiquin munangalanta rurachunchu. Jinarcur lapan junagsi gatiramächun wanuchipäcunan captinsi. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chaura pi maysi noga raygo mana cunchuy munagga manam nogawan cawangachu. Nätan pi maysi noga raygo wanungancamas cunchugmi ichaga nogawan cawanga imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Juc runalapa cay pacha cacuptin manam imapagsi välinchu, mana salvasha canan cayaptinga. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chaura pi maysi nogapita, nätan rimangäpita pengacugtaga, noga jana pachapita shamusha runas, alisca munayniyog achicyayar cutimurga pengacushagmi paypita, chay alisca ali Tayta Diospa jinaman mana juchäcug angelnincunapa naupanchru. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Razonpam nircayag, gamcunapita waquinniqui caychru carcayag manam wanupäcunquiragchu Munayniyog Dios mandanäpag cachramanganta tantiapäcungaycama”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesusga chay ninganpita puwag junagtanuyran, Pedrota, Juanta, jinaman Jacobota pushacurcur jegara juc gotuta Dios-mayinwan rimananpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nä paywan rimayaptinshi jucnuyman cäran muyurura, nätan jacunshi alisca shumag achicyag allanyagman. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chaura ricacarärin ishcay olgocunash paywan rimarcayar. Paycunapita jucninshi cara Moisés, jucagshi cara Elías. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Chaychrüga alisca shumag achicyagchrüshi rimapäcura Jesuswan, Jerusalén marcachru imas aygas paywan ruracänanpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nätan Pedroga chay ishcay aywag-mayincunawan alisca pununasha cayarsi ricchapacurash, jinarcurshi ricaparärira Jesusta alicusa shumag achicyayagta, jinaman chay ishcay olgocunatas chaynuy achicyayagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nä chay runacuna Jesuspita yargorcayaptinshi Pedroga Jesusta cay nin: “Yachrachig, ima alipagrag aywapäcamurä. Rurapäcushag quima chuclata, jucta gampag, jucta Moisespag, nätan jucta Eliaspag”. Pedro manash musyarachu imanir chaynuy rimayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chay nir rimayaptilanshi pucutay aywarcamur chaparärin. Chauraga manchacashash capäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chaylash mayarärira pucutaypita cay nir rimamugta: “Paymi cayan cachramungä salvacug. Pay nipäcushungayta cäsucurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nä rimayta usharuptinga, Jesusta ricaparärira japalan cayagtash. Chay junagcuna discïpulucunaga upälalam capäcura, chay ricapäcunganta manam pitas willapacurcarachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chaura warantin nä gotupita uranparcayämuptin, achca runacuna aywarcayämunag Jesuswan tincug. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chay achca runacunapitam juc runa gayachracuypanuy Jesusta cay nira: “Yachrachig, rircäriyulaynar cay churïta, japalanmi cayäpaman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Asyagmi mayänipita gaparächicun. Jinarmi sapapächicun pogosayta shiminpita jitachimungancama. Nätan alisca cunchurcachir sasataran cachrarin. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nämi discïpuluycunatas manacurü chay lutan espirituta gargapäcunanpag, nätan manam atipapäcunchu gargoyta. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Niptinmi Jesusga cay nira: “Diosman mana yupachicug juchasapa runacuna, ¿imaycamarag gamcunawan cashag? ¿Nätan imaycamarag awantapäcushayqui? Apamuy cayman churiquita”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nä Jesusman mözu yaycuyaptinmi, Asyagga mözuta pampaman sagtarcur wanuparachin. Chaura Jesusga Asyagta piñaparcurmi mözuta cuticarachin. Jinarcurmi “Cä churiqui” nirun taytanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chaura lapansi mayacasha niragmi ricacarärira, munayninwan Dios chaynuy ruranganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chaura Jesusga mayacasha nirag carcayaptilanmi discïpuluncunata nira: “Shumag mayapäcuy cay rimangäta mana gongapäcunaypag. Noga jana pachapita shamusha runata, runacunapa maquinmanmi jitayapäcamanga wanuchipäcamänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesús chaynuy niyanganta discïpuluncunaga manam tantiapäcurachu, Dios mana tantiachiptin. Nätan tapuytaga manchapäcuratan. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chaypitam discïpuluncunaga rimayta galacayäririn, “¿Mayganchirag mas munayniyog cashun?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chay ninacurcayanganta Jesús tantiarurga ichic walashlata lädunman shayarcachirmi discïpuluncunata cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Pi maysi cay walashta nogatanuysi alipa chrasquigga, nogatam alipa chraquiman. Nätan nogatas alipa chrasquicamagga cachramagnï Tayta Diostas chrasquicurcayanmi. Chaura gamcunachru manacapag ricasham alisca munayniyogga cayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chaura Juanga cay ninmi: “Yachrachig tayta, juc runatam ricarärï, gam ningaynuy lutan espiritucuna gargoyagta. Nätan noganchiwan mana puriptinmi ‘Ama ruraychu’ nirärï”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Niptinmi Jesusga “Ama chaynuy nipäcuychu. Mana contranchi cagga yanapämagninchim cayan” nin. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chaura Jesusga jana pachata aywacunan nä nachrgayämuptinga, calpanchacurmi Jerusalén marcata aywara, nätan payga musyaram Jerusalenchru imas pasananta. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Chaypitam naupachira juc ishcay runanta gorpachacurcänanpag wayita ashipäcunanpag. Paycunaga yaycarärinag Samariachru juc tacsa marcalamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chaychru yachrag runacunaga manam munapäcushachu gorpachayta Jerusalén aywayanganta tantiarärir. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaura chayta ricarärir Jesuspa discïpuluncuna Jacobowan Juanga Jesustam cay nirärin: “Tayta, jana pachapita nina ishquircamur cay runacunata ruparunanpag manacarärishag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chay niräriptinmi Jesusga muyurcur piñaparura. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chaypitaga aywacurcara juc ichic marcalatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chaypita aywarcayaptinmi juc runa Jesusta nira: “Tayta, maypas aywangaypa nogawansi aywacushun”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Niptinmi Jesusga cay nin: “Atogcunapas canmi machraynincuna. Pishgocunapas canmi gueshancuna chaychru cacurcänanpag, nätan noga jana pachapita shamusha runapagga manam canchu wayiläsi jamayunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nircur Jesusga nira juc runata: “Acuchi nogawan uryag”. Niptinmi chay runaga cay nin: “Naupataga taytärag wanuruchun. Payta enterrarcuptïmi icha uryashunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Niptinmi Jesusga “Chay wanushanuysi cayagcuna taytay wanuchiruptinga chapapäcungachr, nätan gamga willapacamuy Diospa munayninchru cawaypita” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chaypitaga juc runatan Jesusta cay nintag: “Tayta, nogawan aywashun. Nätan naupataga wayïchru cagcunatarag aywalä nicaramushag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chay niptinmi Jesusga cay nin: “Musyanganchinuysi, pisi aräduwan uryayta galayugga manam guepaman rircärinchu. Chaynuymi pisi nogawan uryayanganpita guepaman cutigga mana välinchu Diospa munayninchru cawananpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaypita Jesusga acraratan ganchris chrunca runacunatas. Paycunatam naupanta cachrara ishcaypacama lapan marcacunapa, jinaman mayag chayagpas ali willapata musyachimunanpag, nätan guepantaga paysi aywananmi cara. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesusga chay aywagcunata cay niram: “Tarpusha chracra pogoshanuymi carcayan runacuna, nätan uryagcunam walcala carcayanga. Chaymi gamcunaga manacurcanqui Munayniyog Diosta juc runa mincaycunata cosechananpag ashignuysi, ali willapa willapacugcunata Dios cachrananpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nogaga cachrarcayag atogcunapa chraupinman achrcashcunata jitayugnuymi. Chauraga aywapäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nä aywarga ama apapäcuychu golguetas runcutas ni languetas. Amam camiñuchru piwansi saludänacur shayäcurcanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pipa wayinman chrarsi, naupataga ‘Diosninchi yanapäshunqui ima-aygachrüsi’ nipäcunquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chay nipäcungayta chay wayichru cayag runacuna alipa chrasquipäcurga, Diospita yanapasham capäcunga. Nätan mana alipa chrasquipäcurga manam nipäcungay paycunachru ruracangachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chay gorpachacurcangay wayilachrümi capäcunqui, amam jucchru jucchrüga. Garapäcushungaytaga imalatas micapäcunquim, upyapäcunquim. Uryag runaga manam, mana micuynagga cangachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mayag marcamansi chraräriptiqui, jinaman chrasquirärishuptiqui. Garacurcäshungaytam imalatas micapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chaychru gueshyagcuna captinga cuticächipäcuy, nätan willapapäcuy Diospa munayninchru cawapäcunan wichan nä chrarayämunganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mayag marcamansi chraräriptiqui, mana chrasquipäcushuptiquiga cällincunachrümi cay nipäcunqui: ");
INSERT INTO qvnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mana chrasquicurcaptiquim cananga chraquïcunaman cay marcaychru alpa latucämushatas tapsicurcayä. Chauraga nä manam juchayogchu capäcü. Cayta icha niyärishayga: Dios cachramungan reyga nämi caychru cayan munayninchru cawapäcunaypag’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chaypitas Jesusga niraran: “Juchacunata taripänä junag chraramuptinga chay mana chrasquicushugniqui runacuna mas juyunaypa cunchuchisham capäcunga Sodoma marcachru yachrag runacunapitaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Chaypitas cay niraran: “Aliscam cunchupäcunqui Corazín marcachru yachragcuna, jinaman Betsaida marcachru yachragcuna. Antis gamcunapitaga Tïro ninganchru, Sidón ninganchru runacunam ricapäcunman cara, cay ima-aygatas munaynïwan rurayangäta. Paycunaga nä unaylachr laquicuna jacunta jacucurcur, jinaman juchancunapita wanacurcur Diosta chrasquicarärinman cara. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gamcunaga juchacuna taripänä junag chraramuptinga alisca juyupa cunchuchisham capäcunqui Tïrowan Sidonchru runacunapitaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nätan Capernaumchru yachragcuna, ‘Jana pachaman chräshunmi’ nircayanquim. Manam. Antis gamcunaga nina wayimanmi jitarpusha capäcunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaypitam Jesusga discïpuluncunata nira: “Gamcuna rimapäcungayta mayacugcunaga nogatam mayacarcayäman. Nätan gamcunata mana mayay munapäcushugniquiga, nogapitam mana mayacuyta munapäcunchu, jinaman nogapita mana mayacuy munagsi, cachramagnï Diospitam mana mayacuyta munapäcunchu” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chaura chay ganchris chrunca cachrangan runacuna cutirärimurga cushisham cay nipäcura: “Tayta, gam nipäcamangaynuymi lutan espiritus gargapäcuptï cäsucaräriman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nipäcuptin Jesusga ninmi: “¡Au! Noga ricapurämi Asyagta juc lipanuy jana pachapita ishquiyämugta. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gamcunataga munayniyog capäcunaypag nipäcurag: Culebracunatas, alacrán curucunatas jarupäcuptiqui mana imatas rurapäcushunaypagmi, jinaman munayniyog lutan espiritutas yalipäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nätan ama cushicurcaychu lutan espiritucuna cäsucurcäshungaypita, antis cushicurcayga jana pachachru jutiquicuna nä isquirbirayanganpita”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chay nircur Jesusga chayüram alisca cushicurura. Jinarcurmi Santu Espíritu rimachiptin cay nira: “Gamtam alawayag Tayta. Gampam jana pachas, cay pachas. Gamga chay alisca yachrag runacunata manam musyachiraychu munayniyog cangayta. Nätan cananga cay manacag runacunatam chay munayniyog cangayta ricarachinqui. ¡Au Tayta! Chaynuy canantam munarayqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Chaypitas Jesusga cay ninmi: “Tayta Diosga lapantas maquïmanmi chruramusha. Manam pisi musyanchu noga pi cangätas. Musyayanga Tayta Dioslam. Manatan pisi musyanchu pi Taytä cangantas, musyayäga nogalam, jinaman musyapäcungasi nogawan cagcunalam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaura discïpuluncunata rircärirmi cay nira: “Alisca cushisham carcayan waquin runacuna, gamcunanuysi ricaparcayämagcuna. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cayta niyärishay: Gamcuna ricarcayämangaynuymi, Diospa unay willacugnincunawan reycuna, alisca alisca ricayta munapäcamara, nätan manam ricapäcamarachu. Gamcuna mayacurcayangaytas aliscam mayacuyta munapäcura, nätan manam mayapäcamarachu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chauraga Moisés isquirbinganpita yachrachig runam “¿Mä musyanagchush icha manachush?” nir. Sharcurcur Jesusta cay nir tapurun: “Yachrachig, ¿imatatag ruräman imaycamas cawag canäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Niptinmi Jesusga nira: “Moisespa isquirbishancunachru ¿ima niyantag leyiptiqui?” ");
INSERT INTO qvnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Niptinmi chay runaga nirun: “ ‘Tayta Diosniquita cuyay lapan shongoypa. Chaynuy cuyarga alila ruraytam munanquis alitam ruranquis paylamanmi yarparanquis, nätan runa-mayiquita cuyay quiquiqui cuyacungaynuy’ niyanmi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Niptinmi Jesusga nira: “Alitam nirunqui chaynuy caway Dioswan imaycamas cawanaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nätan chay runaga alichru quëdayta munarmi, Jesusta tapura: “¿Pitag runa-mayïga?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Niptinmi Jesusga cay nir willapara: “Juc runam uranpayara Jerusalenpita Jericó marcaman. Chay aywayaptinmi paytaga suwacuna charirärira. Jinarcurmi lapan imalantas suwapapäcusha, jinaman jacurayangantas limpun guechrupäcusha, nätan chay suwacunaga wanupangancama magarcurmi aywacurcasha. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chaypitam jina guepanta aywayämunag juc sacerdöti. Chayga jitarayagta ricaparurga pasacunmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chaynuytan unaylanta yargaramuntag Levïpa ayllun aywag runas. Paysi jitarayagta ricapururga carulapam aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chaypitas aywayämunagtan manacagpag ricasha Samaria runas. Chayga runa jitarayagta ricapururga aliscam cuyaparura. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jinaman ashuyurmi jampirun aceitiwan, vïnuwan. Chaypitam däñashancunata sagpiwan wancurcur logarangan uywanman logarcachir aywachira juc gorpachacuna wayiman chaychru cuidananpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nä warantin aywacunanpagga chay Samariapita runaga gora ishcay junagchru gänana golguetam cay nir: ‘Ricayälanquimar cay runata. Imachrüsi mas golgueta quiquiquipacagtawan chruraruptiquiga, cutimurmi cutichilashayqui’ nira”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chaynuy willaparcurga Moisés isquirbinganpita yachrachigtaga cay nirmi tapurun: “Gampitaga cay quimanpita ¿maygantag chay magashata runa-mayinpag ricarura?” ");
INSERT INTO qvnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Niptinmi runaga “Chay cuyapagcagmi” nira. Chaura Jesusga “Au. Ayway gamsi chaynuy ruramuy” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chaypitam Jesusga discïpuluncunawan aywayar yaycura juc ichic marcalaman. Chaychrümi Marta jutiyog warmiga wayinman yaycachira. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Chaychrümi Martapa nanan Mariasi cayara. Mariaga tayucura Jesuspa naupanmanmi rimagta mayacunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nätan Martaga ima-aygatas rurayara yanucunantawanmi. Chaura Martataga Jesusman ashuyurmi cay nirun: “Tayta, ¿gamga manachu tantianqui quiquïla lapanchru nacatacuyangäta? Nilaynar nanäta yanapämänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Niptinmi Jesusga nira: “¡Ay Marta! Marta, ima-aygatas ruraytaran munayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nätan juclaylam ima rurayangaypitas mas aliga cayan. Mariaga acrarun chay mas alinnincagtam. Chaytaga manam pisi ama ruraychu ningachu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jucpaychru Jesusga Taytanwanmi rimayara juc pampachru. Nä rimayta usharuptinmi juc discïpulunga nira: “Tayta, yachrachipäcamay Dioswan rimayta, Bautizag Juan discïpuluncunata yachrachingannuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Niptinmi Jesusga nira: “Dioswan rimarga cay nipäcunquim: ‘Jana pachachru cayag Tayta Diosnïcuna, gamga lapan juchapita caruchrümi cayanqui, shamuynar mandagnïcuna canaypag. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Canan junag gopäcamay micunäcunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nätan jucha rurapäcungäcunapita perdonayärimay, lutan ruramagnïcunata perdonapäcungänuy. Jinaman lutan rurachiyta Asyag munapäcamaptin amar cachraripäcuychu’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Chay nircurmi Jesús cay nira: “Maygaypas canman cuyanacungay runa, payman chraupi pagas aywar ninquiman: ‘Prestayämaynar quima tantalata. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc cuyanacungä runam chayrag chraramun jucläpita. Manam capanmanchu imas garacunäpag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Niptiquim, chay cuyanacungayga wayin ruyipita nimunman: ‘Ama gayarämaychu. Wayïsi shumag wichrgasham cayan, nätan wamracunatam oglayä’. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chaynuy niyarsi chay cuyanacurcangay runaga, mana munayarsi sharcamunmanmi yapay yapay gayachracurcaptiquiga. Jinarcurmi gorärishunquiman lapan manacungayta. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chaymi nircayag: Manacurcay Diosta, payga yanapapäcushunquim. Ashipäcurga, taripäcunquim. Gayacurcaptiquiga, mayapäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pi maysi Diosta manacugga, chrasquinmi, ashigsi tarinmi. Diosta gayacugsi cayan mayasham. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gamcunapita maygaytas wamray pescäduta manacurcäshuptiqui, ¿culebrata gorärinquimanchu? ");
INSERT INTO qvnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nätan ruruta manacurcäshuptiqui, ¿alacrán curuta gorärinquimanchu? ");
INSERT INTO qvnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gamcunaga lutancama carcayarsi alicagtam gorcayanqui wamraycunata. Manacurcaptiquiga masran jana pachachru Taytaycunaga yanapapäcushunquis Santu Espiritunwan ali rurayta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Chaypitam juc junagchru Jesusga gargora lutan espirituta juc runapita. Chayga chay runatam mana rimachinagchu. Nä lutan espirituta Jesús gargoruptinga chay runa rimariruram. Chayta chranin runa ricarärir mayacasha niragmi ricacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nätan waquincag runacunam nipäcura: “Cay runaga lutan espirituta gargoyan, chay lutan espiritupa mandagnin Beelzebüpa munayninwanmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nätan waquinga lutan rurachiyta munarmi Jesusta nipäcura, munayninwan imatas jana pachapita ricacächimunanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chay lutan pinsiarcayanganta musyarurmi Jesusga nira: “May nacionchrüsi runacuna punta punta raquicarurga quiquincamam peliayälar ushanacurcan. Chaynuytan juc wayilachru yachragcunas chay castala cayarsi raquicarärirga quiquincamam limpu ushanacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chaynuymi Asyagsi quiquincama gargonacurga, quiquincamam ushanacarärinman. Cayta nircayag: ‘Quiquin Asyagpa munayninwanmi, lutan espiritupa cachran ruragcunata gargoyan’ nipäcamaptiquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chaura noga chay Beelzebüpa munayninwan lutan espiritucunata gargoyaptïga, nätan Israel castapita waquinniquicunaga, ¿pipa munayninwantag gargorcayanqui? Nogatanuy paycunatas nipäcuptiquiga, paycunataga ‘Manam chaynuychu’ nirärishunquimanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nätan lutan espiritucunata Diospa munayninwan noga gargoyaptïga, chaura nämau chraramun Diospa munayninchru cawapäcunay wichan. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Juc calpanlan runa alisca camapacusha wayinchru cayaptin, ima-aygansi pachalanmi cacun. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nätan paypita mas calpayog runa sharamurmi ichaga yalirunman. Jinarcurmi guechrurunman chay arman yupachicuyangantas. Chaypitam apacunman lapan ima-aygantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Chaymi pisi wacga manam alitachu ruran nimagga, nä conträ cayan. Nätan pisi nogata mana yanapämarga runäcunatam wichicayächin”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Chaura runapita lutan espíritu nä yargorurga, purin chaqui pampacunapam ‘Maychrütag jamayüman’ nir ashiyar. Chaypita jamananpag mana tarirga, ‘Mä cutishag yargocungä runaman’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nä cutirurga, chay runata tarin juc wayi alisca shumag pichachracushatanuysi, jinaman chrurachracushanuysi cayagtam. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chaynuyta tarirur lutan espirituga, ‘Caychrümi yapay yachrashag’ nirmi, cuticun lutan espiritu-mayincunaman. Chaypitam pushamun ganchrista, quiquinpitas mas juyunnincunata. Chaura chay runaga naupa canganpitaga mas lutan ruragmanmi muyun”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chay nir Jesús rimayaptinmi juc warmi chay achca runacagpita lapan calpanpa cay niramun: “¡Ima cushisharag cayan gamta wachrashugniqui, jinaman chuchushugniqui warmi!” ");
INSERT INTO qvnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Niptinmi Jesusga cay nin: “Antis cushishaga capäcunman Dios ninganta mayacugcunam, jinaman cäsucugcunam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Chaura nä chranin runacuna Jesuscagman gotucarcayämuptinmi Jesusga cay nira: “Gamcunaga carcayanqui lutancamam, munaynïwan imatas ruranalätam munarcayanqui. Nätan manam ruray nircayämangaytaga rurashagchu. Antis ricapäcunquiga Diospa unay willacugnin Jonaswannuysi ruracaglatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonastachu Ninivechru runacuna musyarärira Dios cachramunganta. Chaynuymi noga jana pachapita shamusha runapitas juc junagga musyapäcunqui Diospita shamusha cangäta. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Chaura juchacunata Dios taripänan junagga Arabiachru mandag warmiga wanushapita cawacaramur: ‘Diosta mana chrasquicurcanganpita cunchuchisha capäcuchun’ nipäcushunquim. Chay warmiga aywamura caru nacionpitam Jerusalenta, Rey Salomón rimanganta mayacunanpag. Nätan nogaga caychru cayä Salomonpitas mas munayniyogmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chaynuytan Ninivechru cagcunas wanushapita cawacarcamur ‘Diosta mana chrasquicurcanganpita cunchuchisha capäcuchun’ nipäcushunqui. Paycunaga Diosman cutipäcuram Jonasta mayacur, nätan nogaga caychru cayä Jonaspitas mas munayniyogmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Manam pisi achquita ratarcachirga, pacarunchu u imawansi chaparunchu. Antis chrurcun chruracunanmanmi, wayiman yaycugcunata achicyapänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Chaura ñawiqui shumag ricapugnuysi Diospa willapanta shumag tantiaptiquiga alila rurag runam canqui. Nätan ñawiqui mana shumag ricapugnuysi Diospa willapanta mana shumag tantiarga lutanla rurag runam canqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nätan ichic ichiclata tantiayarsi mana masta tantiayta munarga, mana pasay tantiag runamanmi muyunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chaura Diospa willapanta shumag tantiaptiquiga, jinaman tantiangaynuy cawarga, canqui alisca shumag achicyag achquinuymi. Chaura gamga manam lutan rurag runachu canqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chaychru Jesús nä rimayta usharuptinmi, juc fariseo runaga “Wayïta aywashun micug” nira. Niptin Jesusga nä wayiman chrarurga micucurcänancagman yaycurcur tayucura. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nätan chay pushag runaga mayacasha niragmi ricacarura, mana maquinta maylacular micunanpag tayuruptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chaura Jesusga nirunmi chay runata: “Gamcuna fariseocunaga, wishgocunata pucucunata janalanpa maylagnuymi ali rurag nirag carcayanqui, nätan shongoycunaga manam alichu suwacuycunawan, jinaman lutan ruraycunawan. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Gotara runacuna! ¿Manachu musyapäcunqui janan cuerpuycuna rurag Dios shongoycunatas ruranganta? ");
INSERT INTO qvnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gamcuna imalatas rurarga rurapäcuy lapan shongoycunapa. Chaynuy rurarga, alim capäcunqui Diospag. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Alisca cunchuchisham capäcunqui, fariseocuna. Gamcunaga yarpaylapam Diosta gorcayanqui chruncapita jucta, mentatas rüdatas, jinaman lapan ima-ayga verdüracunapitas. Nätan ali ruraytawan, lapan shongoypa Diosta cuyaytam icha gongarärinquiga. Chaytam naupataga rurapäcunquiman cara, mana chay naupa rurarcayangayta gongalar. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Alisca cunchuchisham capäcunqui fariseo runacuna. Gamcunaga Israel castacuna gotucarcänan wayichrüsi, alinnin tayucunachrüran tayucuyta munarcayanqui. Pläzachrüsi lapan runapitas saludasha caytaran munarcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gamcunaga alisca cunchuchisham capäcunqui. Gamcunaga carcayanqui pampachru runa enterrasha mana ricacagnuymi. Chaytachu runacuna mana ricacaptin jarur juchäcurcan. Chaynuymi gamcunaga runacunata lutanta rurarcayächinqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chaynuy niruptinga, Moisés isquirbinganpita yachrachigga cay ninmi: “Tayta, chaynuy nirga nogacunatawanmi ashlircayämanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Niptin Jesusga cay niram: “Gamcunas alisca cunchuchisham capäcunqui Moisés isquirbinganpita yachrachigcuna. Gamcunaga juc runa lasagta guepiyaptin, jananman masta chrurcapagnuymi, Dios ninganman masta yaparcur yachrarcayächinqui. Chaytaga manam pi runas rurayta atipanchu. Nätan gamcunaga manatan yanapapäcunquis ni manatan rurapäcunquipishchu yachrachipäcungaynuyga. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gamcunaga alisca cunchuchisham capäcunqui. Unay awilluycuna Diospa willacugnincunata wanurcachir enterrapäcunganta, cuyagtucur uryapapäcungaypita. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chaynuy rurapäcur aygas mayapam carcayanqui unay awilluycunanuysi lutancama. Paycuna wanurcachir enterrapäcungantam gamcunaga alchaparcayanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chaymi Diosga alisca yachrag cayninchru cay nira: “Paycunaman cachrashagmi willacugnïcunatawan cachrä ruragcunata. Paycunapitam waquinta wanuchipäcunga. Nätan waquintam ashipäcunga wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chaymi Diosga gamcunataga juchaycunapita taripapäcushunqui cay pachata camacanganpita canancama, willacugnincunata wanuchipäcungaypita. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Chaynuy ruranga Abel wanungan junagpita Zacariasta wanuchipäcungancamam. Zacariasta wanurärichira Diospa wayin ruyichrümi chay altarwan tincucugchru. Diosga razonpam gamcunataga juchachapäcushunqui lapan willacugnin wanushacunapita. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aliscam cunchupäcunqui Moisés isquirbinganpita yachrachigcuna. Gamcunaga wayipa llävinta charicuyugnuymi ali yachrayta pacararcayächinqui. Nätan manam ni quiquiquicunas yachracurcanquichu, ni manatan munapäcunquichu pi yachracunantas”. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chaynuypa Jesús niruptinga, Moisés isquirbinganpita yachrachigcunawan fariseocunaga alicusam piñäcarärira Jesuspag. Jinaman yangam tapupayta galacayärira ima-aygacunapitas. ");
INSERT INTO qvnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","“Pagta imalatas lutanta rimarachichwan” nir, chaypita juchachapäcunan raygo. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chaura alisca alisca chranin runacuna gotucarärimuptinmi, jinaman quiquincama nä jarunacurcayaptinmi, Jesusga naupata galayura discïpuluncuna rimapayta cay nir: “Amam chrasquicurcanquichu fariseocuna yachrarcayächinganta. Paycunaga alita nirag yachrarcayächin lutantam. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chaymi canan cayta yachrarcayächingä shumag musyacasha canga ima pacashasi, nätan mana musyashas canga pipitas shumag musyasham. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chaura pagaspa imata ninacur rurapäcungaysi, junagpam musyacasha canga. Nätan wayichru wichrgapacarcamur wishwishyaylapa rimangaysi, wayi jananpita gayacuypa nishanuymi canga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Chaymi cayta niyärishay cuyashäcuna: Ama manchapäcuychu runa wanuchigcunata. Wanurcärichishurniquiga manam imatas mastaga rurayta atipapäcushunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Antis pita manchacurcänaypagsi niyärishay: Manchacurcayga üra chrämuptin wanuräriptiqui, nina wayinman jitayucug Munayniyog Diosta. Au, payta icha manchacurcayga. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Musyapäcungaynuysi ishcay ichic golguelapagmi ranticurcan pichga pishgocunata. Chaynuylachru ranticurcayaptinsi Diosga manam gonganchu ni juclaylatas chay pishgocunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Chaynuymi gamcunapa umaycunachru agchaycunas yupashala cayan. Chauragar ama manchapäcuychu. Gamcunaga pishgocunapitas mas cuyasham carcayanqui Tayta Diospita”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Cayta nipäcushay: Pi maysi runacunapa naupanchru ‘Nogaga cayä Jesuspam’ nigcunataga, noga jana pachapita shamusha runasi Diospa, jinaman angelcunapa naupanchrümi payga ‘Nogapam cayan’ nishag. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nätan runacunapa naupanchru nogaga ‘Manam Jesuspachu cä’ nigtaga, nogas ‘Manam nogapachu payga’ nishagmi Tayta Diospa, jinaman angelcunapa naupanchru. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pi maysi noga jana pachapita shamusha runata imatas lutanta nimagga, perdonasham canga. Nätan pi maysi Santu Espiritupag lutanta rimagtaga, Diosga manam perdonangachu imaysi chay rimanganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Chauraga gotucarcänan wayiman, marcachru mandagcunaman, u fiyiscunaman aywachipäcushuptiqui, amam laquirapäcunquichu ‘¿Ima nishagtag?’ u ‘¿Imatarag rimashag?’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Antis rimapäcunay üram, Santu Espirituga yarpayta gopäcushunqui imanuypa nipäcunaypagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chaura chay achca runa carcayagpitam, juc runaga Jesusta cay nin: “Tayta, wauguëtanar niyulay, taytä nogapag dëjapämanganta gomänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Niptinmi Jesusga nira: “Runa, ¿pitag chrurarayäman juc fiyisnuysi gamcunachru partichracug canäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nircurmi cay nira: “Imanaypanuysi capogniyog caylatatag icha munacurcanquimanga. Runaga cawan manam ima-aygatas charalarchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chaynuy nircurga tantiachira caynuypam: Juc capogniyog runapa tarpucuyninmi alisca gueshpirura. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chaura chay capogniyog runaga pinsiara cay nirmi: ‘¿Imatatag rurashag? ¿Maymantag pirwacushag?’ ");
INSERT INTO qvnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Niyanganpita tantiachracurcurmi cay nira: ‘Antis cay pirwacuna wayïcunataga gachrarushag mas jatuntacama ruranäpag. Chaymanmi chrurashag lapan pirwäcunata, jinaman lapan ima-aygäcunatas’. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chay ningannuy rurarcurmi cay niram: ‘Achca watapagmi chrurayan ima-aygäsi. Cananga jamacushag, micushag, upyacushag, jinaman cushicushag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chaynuy niyaptilanmi Diosga nirura: ‘¡Gotara runa! Canan pagasmi wanunqui. Chay shuntangaycunaga ¿pipagrag canga?’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chaynuymi ruracanga ima-aygatas quiquilanpag gotug runawanga. Nätan chaynuy runaga manacagpag ricasham cayan Diospita”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaymi Jesusga discïpuluncunata nira: “Gamcunaga amam laquirapäcunquichu cawapäcunaypita ‘¿Imatarag micushag?’ nir, u cuerpuycunapag ‘¿Imatarag jacucushag?’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Antis noga ningänuy cawaymi masga välin micuypitas, nätan cuerpum masga välin jacupitas. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mä pinsiapäcuy pishgocunaman. Chaycunaga manam tarpucurcansi ni cosechapäcunsi. Manatan canchu micuy chruracunansi ni pirwansi. Chaycunapagga Diosmi camachipun micuynincunata, nätan gamcunaga pishgocunapitas mas väligmi carcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Maygaycunatag juc junag maslas cawarärinquiman chay imas aygas ashircayangaycunawan? ");
INSERT INTO qvnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chaura mana chaylatas atipayarga, ¿imanirtag pinsiarcayanqui, jinaman laquirarcayanqui waquin junagcunapitaga? ");
INSERT INTO qvnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pinsiapäcuy waytacuna wiñagman. Waytacunaga manam uryapäcunsi ni puchcapäcunsi. Cayta niyärishay: Unay Rey Salomonsi, alinnin jacuta jacucuyarsi, manam ni maygan shumag waytanuylas jacucuyta atiparachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diosga chaynuypam juc junaglapag waytamug guewalatas shumagta waytachin, warantilan ninachru rupanan cayaptinsi. Masran gamcunataga jacupurcäshunquis Diosga, mana aläpa yupachicug runacuna. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chaura ama laquishaga capäcuychu, ‘¿Imatarag micushag?’ u ‘¿Imatarag upyashag?’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Diosman mana yupachicugcunalam chaycunata ashiyarga laquisha puripäcun. Nätan gamcunaga nä Tayta Dioswanmi carcayanqui. Payga nämi musyayan chaycuna munarcayangayta. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Antis imanaypanuysi Dios munangannuy cawapäcuyga Tayta Diosga lapan chaycunataga mas masnintawanmi gopäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Chauraga ama manchacurcaychu, walca uyshanuyla cayag runäcuna. Tayta Diosga cuyapäcug carmi nä munayninchru cawarcayächishunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chauraga ima-aygaycunatas cayagta ranticurcay, jinaman aypupäcuy mana imaynagcunata jana pachachru alipa ricasha capäcunaypag. Chaynuy rurar mana macway yachrag costalman wiñagnuymi chrurarcayanqui. Chaynuypaga chrurarcayanqui suwa mana yaycunanmanmi, jinaman puyu mana micunanmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chauraga ima-ayga väligniquicunatas maymanmi chruranqui, chaylamanmi yarparayanqui pagaspas junagpas. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Chaura gamcunaga cacurcayay camaricushala, jinaman michïruycuna ratachipacushanuyla. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nätan cacurcay servig runacuna patronnin casamintupita cutiramur, puncuta töcacuptin jucla quichrananpag shuyararcayagnuyla. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chaynuy carga alipag ricasham capäcunga chay servig runacuna, patronnin chraramur, ricchayagta tariruptinga. Chaynuy captinga quiquin patronninchri mësaman tayachinga micuycunata garananpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Alipag ricasham capäcunga chay servig runacuna, patronnin chraupi pagas u chraupi pagas pasashachru chraramur ricchayagta tariruptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Musyapäcungaynuysi juc wayiyog runa imayüra suwa chrämunantas musyarga, ricchayälarchri cayanman, nätan manachr suwawan imantas apachinmanchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chaynuy camacushala gamcunas cacurcayay. Mana musyapäcungay üram shamushag, noga jana pachapita runaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chaura Pedrom tapura cay nir: “Tayta, ¿cayta willaparärimanqui nogacunalapagchu u lapan runacunapagwanchu?” ");
INSERT INTO qvnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Niptinmi Jesusga nira: “¿Pitag cayan ali yupachicuna, jinaman fisyog runa patronninpa wayinchru cagcunata pasay üralachru micachinanpag? ");
INSERT INTO qvnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chaynuy carga alisca alipag ricasham canga chay rantisha runa, rantignin chraramur ningancuna rurayagta tariruptinga. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mayapäcamay shumag: Chaynuy runataga rantignin chrurarunman lapan imansi aygansi ricagpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nätan chay rantisha runa ‘Rantimagnï manachr chrämungaragchu’ nir, magayta galayunman rantisha-mayincunata, warmitas olgotas jinaman micucur upyacur shincacur cacunman. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chauraga mayänita chay patrón chraramur chaynuy rurayagta tarirurga alicusam cunchuchinga. Jinamanmi chruranga juchasapacuna cacunanman. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Chay rantisha runa, patronnin ninganta musyayarsi, mana camacugga, mana cäsucugga alisca juyupa magasham canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nätan juc rantisha runa mana musyar ruranman imatas lutanta. Chaura chay lutan ruranganpita manam aläpa magashachu canga. Chaymi achcata imatas rurananpag nisha runaga, chay achcapita tapusha canga rurangansi u mana rurangansi. Chaynuytan chay patrón yupachicuptin imata rurananpag nisha runatasi, tapunga rurangantas u mana rurangantas”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nircurga cay niram: “Noga shamurä cay pachaman nina rupar imatas manacagman muyuchignuysi runacunapa juchanta manacagman muyuchinäpagmi. Nätan ima-aygachr munayä chaynuy ruracänanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nätan nogataga alisca cunchurcachirmi wanuchipäcamanga. Chaymi chaynuy rurapäcungancama juyupa laquirayä. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nätan gamcunaga, ¿‘Ali cawachimänanchipagchri cay pachaman aywarayämun’ nircayämanquichu? Manam. Antis aywarayämüga nogapa janä cay pachachru runacuna raquicasha capäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Antis cananpitaga chay castala juc wayichru pichga runacuna yachragsi chregninacurmi cawapäcunga. Quimacagmi jucmapapäcunga ishcaycagta, nätan ishcaycagmi jucmapapäcunga quimacagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taytacagmi olgo churinwan chregninacunga, jinaman mamacagmi chregninacunga warmi wawanwan. Suydrasi chregninacungatan lumchuyninwan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chaypitas Jesusga chay chranin runacuna carcayagta cay niraran: “Gamcuna yana pucutay yargamugta ricapur, ‘Tamyangam’ nircayanquim. Jinaman chay nircayangaynuylam tamyamun. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nätan wichanpita walyamuptinmi, ‘Usyamungam’ nircayanquim. Jinaman chaynuy nipäcungaynuylam usyamun. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Alitucugcuna! Gamcuna pacha tamyanantas, usyanantas tantiarcayarga nämi tantiapäcunquiman Diospa cachramushan gamcunachru nä cayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Chaura gamcunaga ¿imanirtag mana tantiapäcunquichu juchaycunapita Dios imay taripapäcushunaytas? ");
INSERT INTO qvnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Antis pisi fiyisman aywachishuptiqui, chay imatas ninacungay runawan aywayälar ushacapäcuy, mana fiyiscama chrächishunaypag. Nätan fiyisman chrarachishuptiquiga, fiyisga guardiapa maquinmanmi gorushunqui, jinamanmi guardiacunaga carcelman wichrgashunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chaypitaga manam yargamunquichu lapan golguequita ushangaycama” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chaychru Jesús runacunata rimapayaptilanmi, chrarärimura juc ishcay runacuna Jesusman cay nir willapäcug: “Pilatom Diospa wayinchru soldäduncunawan wanurärichin Galilea runacunata chay uywancunata Diospag nä mogorcayangan üra. Jinarcurmi chay uywacunapawan chay runacunapa yawarninga limpu talurun”. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Niräriptin Jesusga nira: “ ‘Gamcunaga chay runacuna chaynuypa wanuräriptin, mas juchasapachr cara lapan Galilea runacunapitas’ nircayanquichr. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Manam mas juchasapachu capäcura. Gamcunas jucha ruraypita wanacurcur Diosman mana cutipäcurga, chaynuymi lapaysi wanupäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nätan ‘Siloëchru törri juchrur chrunca puwagniyog runacuna nitiypa wanurachiptin, mas juchasapachr cara Jerusalenchru yachrag runacunapita’ nircayanquichr. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Manam mas juchasapachu capäcura. Gamcuna jucha ruraypita wanacurcur Diosman mana cutipäcurga, chaynuymi lapaysi wanupäcunqui” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chaypitam Jesusga tantiachira caynuypa: “Juc runam chracranchru wiñachira hïgos montita. Jinamanmi ‘Hïgos cayanchri’ nir, ricag aywarga mana tarirachu imatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chauraga chracran täpacug runatam nira: ‘Nä quima watam aywayämü hïgos ashig cay montiman. Nätan manam imaysi tarïchu mishquinta, antis jucla muturuy. ¡Imapagtag chracrachrüsi yangalaga canga!’ ");
INSERT INTO qvnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Niptin chracran täpacug runaga nira: ‘Tayta, cay watalaga jinalarag cayächun, alpanta apshiparcachir chrulpata chrurangäcama. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jinaparuptï mana wayuptinchri ichaga sagtarunquiga’ nira”. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jucpaychrümi jamana junagchru, Jesusga yachrayächira Israel castacuna gotucarcänan wayichru. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaychrümi cayänag juc warmi nä chrunca puwagniyog wata gueshyag. Paytaga Asyag curcucashalata cachinag. Chaura chay warmiga manam ni nuquircuytas atiparachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chaura Jesusga chay warmita gayarcurmi cay nira: “Mamala, cananga nämi cuticarayanqui gueshyaypita” ");
INSERT INTO qvnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","nir, washanta yatayuruptilanmi chay warmiga alchacarura. Jinamanmi Diosta alawara alisca. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jamana junagchru chaynuy cuticächinganpitam, gotucarcänan wayichru juc mandagga piñäcurura. Chaypitam cay nira: “Sogta junagmi cayan uryanapagga. Chay junagcuna shapäcamunquiman cuticächipäcunaypagga, amam jamana junagchrüga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Niptinmi Jesusga nira: “¡Alitucugcuna! ¿Manachu gamcuna pasquipäcunqui uryag töruycunata u ashnuycunata jamana junagchru yacuta upyachipäcamunaypag? ");
INSERT INTO qvnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cay warmiga cayan Abraham castan aywagmi. Payta Asyagga munayninchru cachira chrunca puwagniyog watam. ¿Manachu jamana junagchru watashatanuy cayagta cuticächïman?” ");
INSERT INTO qvnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chaynuy Jesús niruptinga, lapan chregnipagnincunas pengacaräriram. Nätan waquin runacunam ichaga cushisha capäcura Jesús chay ima-aygatas ruranganta ricarärir. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chaura Jesusga cay niram: “¿Imawantag tincuchïman Diospa munayninchru cawag runacunata? ¿Imanirayantag? ");
INSERT INTO qvnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Chayga cayan nustäsa muru chicchircamur alisca wiñagnuymi. Chayga yargaramur wiñan jatun jachra cangancamam. Jinaman pishgocunas chaychrüga gueshanta rurapäcunmi. Chay muru chicchimur alisca wiñagnuymi. Diospa munayninchru cawag runacunas mirapäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nircursi niraran: “¿Imawantag tincuchïman Diospa munayninchru cawag runacunata? ");
INSERT INTO qvnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Chayga cayan juc warmi chegta harinaman ichic levaduralata yautaruptin alisca jacarichimugnuymi. Chay levadura jacarichimugnuymi Diospa razoncag willapan chrasquicug runacuna, ali cawagman muyupäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesusga Jerusalenta aywar, yachrayächirmi aywara jatun marcacunapas, ichic marcacunalapas. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chaynuy aywayaptinmi juc runaga Jesusta tapura cay nir: “Tayta, ¿walcalachu runacuna salvacurcanga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Niruptin Jesusga nira: “Quichrqui puncupa yaycugnuysi Diospa munayninman yaycapäcuyga. Runacuna achcam yaycuyta munapäcunga, nätan manam atipapäcungachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wayiyog runa puncuta wichrgaramuptinragtag, washapita nircayämunquimanga, ‘Tayta, quichrapäcamay’ nir. Nipäcuptiquiga ‘Manam reguegchu may runachr cacurcanquis’ nipäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chauraga nipäcunquim: ‘Gamwanga micuranchitag, upyaranchitag, pläzäcunachrüsi yachrachipäcamaraytag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nipäcuptiquis payga ‘Nämi nircayag: ¡Maypitachr cacurcanquis! ¡Aywacurcay nogapita lapay lutan ruragcuna!’ nipäcushunquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nipäcushuptiquim ichaga alisca wagapäcunquiga. Nätan Abrahamta, Isaacta, Jacobta, jinaman lapan willacugnincunata Diospa munayninchru carcayagta ricaparäriptiquiga quiruycunas gapapaylam wagaringa laquicuypita, washachru gargosha capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chaymanga runacuna shamungam inti yargamunancagpita, inti jegarpunancagpita, naupa lädupita, guepa lädupita Diospa munayninchru tacuyur micapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chauraga canan naupata mayacarcayämagcunam, washaman gargosha capäcunqui. Nätan mas guepaman ali willapata chrasquicur cäsucugcunam jana pachaman yaycapäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chay junaglam chrarärimura Jesusman juc ishcay fariseo runacuna cay nir willacug: “Tayta, caypita aywacuy. Herodesmi wanuchiyta munayäshunqui” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Niptinmi Jesusga nira: “Aywarcur nipäcamuy chay atognuysi cayag Herodesta: ‘Canansi warasi lutan espiritucunataran gargoshag. Nätan cuticächishag gueshyagcunataran. Warapa waranmi ichaga nä usharushagga’. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aywanätaga aywashagran canansi waras warapa waransi. Diospa willacugnintaga Jerusalenchrümi imaysi wanuchipäcun, manam juclächrüchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Jerusalenchru yachrag runacuna, gamcunam carcayanqui Diospa willacugnincunata wanuchigcuna, jinaman Diospa cachramushancunata rumiwan chapigcuna! ¡Ayga cutis gamcunata gotuyta munasharagchri cä, walpa rapran ruyiman chiucancunata gotugnuysi! Nätan manam munapäcuraychu. ");
INSERT INTO qvnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chaymi wayiquicunapitas gargosha capäcunqui. Cananga manam nä ricapapäcamanquichu. Ricapapäcamanquiga jana pachapita cutimuptïran. Chaymi ichaga ‘Alisca ali nisha cachun Munayniyog Diosninchi cachramungan’ nipäcunquiga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juc jamana junagchrümi, Jesusga aywara micug, mandag fariseocunapa wayinta. Nätan waquin fariseocunaga Jesusta rircararcayara jamana junagchru “Imatash ruranag” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chaychrümi Jesuspa naupanchru cayara juc runa jacapacuywan gueshyag. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chaura Jesusga tapura Moisés isquirbinganpita yachrachigcunatawan fariseocunatam cay nir: “Jamana junagchru gueshyagta cuticächiy ¿alichu cayan, icha manachu?” ");
INSERT INTO qvnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Niptin paycunaga manam imatas nipäcurachu. Chaura Jesusga jacapacuywan gueshyag runatam, yatayur cuticarachira. Jinarcurmi “Aywacuy” nirura. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chaypitam fariseocunata nira: “¿Maygaycunatag churiqui u töruyqui pözuman ishquiruptin rircarapäcunquiman, cananga jamana junagmi ‘Ama jorgamushunchu’ niyar?” ");
INSERT INTO qvnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Niruptin, paycunaga manam ima niytas atipapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chaypitam Jesusga rircarayara micapäcuyman gayachimusha runacunata naupa naupaman alinnin runa tayucunanman tayurcayagta. Chayta ricapururmi Jesusga cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pilas casamintuchru micapäcuyman gayachipäshuptiqui, amam tayucunquichu naupa naupamanga. Chraramunmansi canchri gampita mas reguesha juc alinnin runas. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chauraga gayachipäcushugniqui ‘Aywarcamur’ nishunquiman, ‘Tayangaychru tayächun cay runa’. Nishuptiquiga, pengacusham aywanqui guepaman tayucug. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pilas gayachishuptiquiga, tayucunqui guepa guepalamanmi, chay gayachishugniqui chraramur, ‘Shamuy cay naupaman’ nishuptiquim ichaga ‘Naupaman tayucunquiga’. Chaymi ichaga ali runapag ricasha canquiga lapan runacunapitas. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chauraga pi maysi alitucugga pengacusham canga. Nätan manacag runam ichaga alinnin runapag ricasha cangaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaypitaga niratan chay gayachig runatas: “Yapaychru micapacunaypag gayachiyta munarga, amam gayachinquichu cuyangaycunalataga ni wauguelaycunataga ni aylluycunalataga ni capogniyogcunalataga. ‘Paycunaga walacämaram’ nir cutirärishunquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yapaychru yanupacurga gayachiy micuypita nacarcayagcunata, ratacunata, ñaushacunata, gueshyagtucushacunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chaynuy jinarga cushisham canqui. Paycunaga manam walac cutichishuyniquita atipapäcungachu, antis Tayta Diosmi cutichishunqui ali ruragcuna cawacämunan junagchru”. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chay nigta mayarurmi micapäcunanpag tayarcayagpita juc runaga Jesusta cay nira: “¡Ima-ayga cushisharag canga jana pachachru Dioswan alisca micapäcuychru cagcuna!” ");
INSERT INTO qvnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Niptinmi Jesusga caynuypa tantiachira: “Juc runam alicusa achca micuyta yanupacachira. Chaypitam achca runacunaman cachrara ‘Micapacunanchipag shamunquim’ nichig. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nä micapacunanpag üra ayparamuptinga, juc runantam cachrara ‘Nä garachracusham cayan micunanchipag shapäcamuy’ nichig. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nätan chay gayachisha runacunaga manam aywayta munapäcushachu. Chaura naupacag willangan runaga nira: ‘Juc chracratam chayrag rantirayä. Chay ricagran aywashag. Yapaychrüchrau, tayta. Amachrau sinticamanquichu’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Chaypitam jucagsi nira: ‘Chrunca uryag törutam rantirayä. Chaytaran imanuy uryangantas ricamushag. Yapaychrüchrau tayta. Amachrau sinticamanquichu’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chaynuytan guepacag willangansi nira: ‘Manam aywamümanchu. Chayran casarangäpita chrarayämü’. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Niptinga chay cachran runaga patronnin willagmi aywarura runacuna chaynuy ninganpita. Chaura patronninga aliscam piñäcurura. Chaypitam cay nira: ‘Jucla ayway pläzacunapa, cällicunapa, micuypita nacagcunata, ratacunata, ñaushacunata, gueshyagtucushacunata pushamunaypag’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chaypitam chay runacunata pusharcamurga chay cachrangan runaga nira: ‘Tayta, nämi rurarü nimangaynuy, nätan wayiquiga jäcuyanran’. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Niruptin wayiyog runaga nira: ‘Yapay ayway mayag chayagpas “Aywashun” nir, pasay pushamuy wayïchru junta capäcunanpag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cayta niyärishay: Chay naupa gayachimungäcunaga manam maygansi yaycapäcungachu jana pachachru nogawan micapäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chaypitam Jesusga chay achca runacuna gatirarcayagtaga muyurcur, cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Pi maysi chrasquimagga manam nogatanuy aliscaga cuyanmanchu taytantas mamantas warmintas churintas wauguentas panintas. Nätan quiquin imanuypanuysi alisca cuyacugga manam canmanchu discïpulüga. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chaynuytan pisi nogapa janä ima-ayga cuchuytas wanuytas mana munagga manam discïpulüpag välinchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gamcunaga juc wayita sharcachiyta munar, naupataga tacuyurmi cuentata shumag jorgorcayanqui golguequicuna aypanantas u mana aypanantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ñaushacurcur galariruptiquiga, jinaman mana ushaptiquiga lapan runacunam asiparärishunquiman cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Wac runalaga razón razonmi galayurun sharcachiyta. Nätan manam ushayta atipanchu’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chaynuymi juc nación mandagsi juclä nacionwan peleanan captinga, tantiachracun cay nir: ‘Cay chrunca waranga soldädulawan wac ishcay chrunca waranga soldädu aywamugta ¿yalimunchur ichaga manachur?’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nätan mana yaliyta atipänan captinga, caruchru cayaptilanmi cachrarunman willacugninta ‘Ama peliashunchu’ nichig. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chaynuymi maygaysi ima-aygatas lapanta mana dëjarga mana capäcunquichu discïpulüga. ");
INSERT INTO qvnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mä shumag tantiapäcushay chay nircayangagpita: Cachriga alim. Cachri gamyagman muyurga, ¿imanayparag muyunman yapay puchgogman? ");
INSERT INTO qvnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nä mana puchgorga, manam välinchu ni alpapagsi ni chrulpapagsi. Chaynuymi mana ali gatiramagga ruracanga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Chaypitam lapansi patenti cobrag chregnipashacuna jucha ruragcunawan ashuyapäcura Jesús rimanganta mayacug. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chayta ricapurmi fariseocunawan Moisés isquirbinganpita yachrachigcunaga cay nipäcura: “¿Imanirtag cay runaga juchasapacuna mayacunanta munan? nätan ¿imanirtag paycunawan micuyansi?” ");
INSERT INTO qvnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nipäcuptin Jesusga tantiachira caynuypam: ");
INSERT INTO qvnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pachrac uyshaycunapita juc ogracaruptin, chay isgon chrunca isgonniyog micuyagta dëjarcur gamcunaga ashigmi aywapäcunquiman taripäcungaycama. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nätan tarirurga, shawacurcurmi, aywachimunquiman cushisha. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nä wayiman chrarurga fijus gayanquiman reguenacuyniquicunatam, jinaman wayiquicagpa yachragcunatam ‘Cushicushun, nämi ogracasha uyshäta tariramü’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chaynuy alisca cushicuymi cayan jana pachachrüga chay juc juchasapa juchanpita wanacurcur, Tayta Diosman cuticämuptinga chay isgon chrunca isgonniyog ali ruragcunapitaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Juc warmi chrunca golguenpita jucta ograrur, michïrunta ratarcachirmi fiju ashinman. Jinarcurmi wayinta pichachracursi shumagmi ricachracunman. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nä tarirurga, gayachinman cuyanacungan runacunatam jinaman wayincagpa yachragcunatam. Chaypitam ninman: ‘Cushicushun, nämi tarirü golgue ograngäta’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mayapäcamay shumag: Chaynuymi jana pachachru Diospa angelnincuna cushicurcan juc juchasapa juchanpita wanacurcur, Tayta Diosman cutiptinga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesusga willaparatan caynuypas: “Juc runam cara ishcay churiyog. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Shulcancagmi taytanta cay nira: ‘Tayta, gomänay cagcunata ima-aygatas goramay’. Niptin taytanga ningannuymi gorura. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chaypitaga manas alä unaytam shulcacag churinga ranticurura limpu imantas. Chauraga chay golguenwan aywacura juclä caru nacionta. Chaychru lapan golguenta usharura munangancunalachru puriyarmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chaypita nä lapan golguenta ushacurcurga micuypita cara, chay nacionchru micuy wanay captin. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chauraga aywara juc runaman uryapacug. Chay runaga cachrarura estancianta cuchincunata michinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nätan micanaypitaga cuchipa micunanwanmi pachran juntachiyta munag. Nätan ‘Chaynuy micushag’ niyaptinsi manam pisi micuyta gopäcugchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chaura shumag tantiachracurcurmi cay nira: ‘Taytäpa wayinchrüga uryagnincuna ayga carsi yamangancamam micapäcun. Nätan nogaga caychru micuypita wanuyar cayä’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Niyanganpitam nira: ‘Antis aliga taytäcagta cuticushag. Nätan chrarurga, cay nishagmi: ");
INSERT INTO qvnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ama nä churiquipag ricamaychu, antis chrasquimay juc uryapacugnuy canäpag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chauraga sharcurcur cuticura taytanpa wayinta. Nätan taytanga caruta aywayämuptilan, churinta ricapurur cuyaparura. Chauraga wayrala tariparcurmi macalicurcur mucharura. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chaura churinga cay niram: ‘Tayta, juchäcusham cä Diospagsi, gampagsi. Manam nä churiqui nisha cämanchu’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Niptin taytanga rantisha runancunatam cay nira: ‘Pasay-pacha alinnin jacuta jorgapäcamuy jacupurcänaypag. Nätan maquinman chrurapurcay sortïjata, jinaman sandaliata jatipurcay. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Apapäcamuy wirannin torilluta pishtapäcunaypag. Cananga cushicuypita fiestata rurashun. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cay churïtaga wanushapagmi ricarä, antis cawayänagran. Cayga ogracasham cara, cananga nämi ricacaramun. Chaylam fiesta rurayta galacayärira’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Chaypagga mayorcag churinga chracratam aywasha cara. Nä wayinman cutiyämurga, mayarura müsicatam tushurcayagtam. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chauraga juc rantisha runanta gayarcurmi tapura: ‘¿Imatag cayan?’ ");
INSERT INTO qvnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Niptinmi payga nira: ‘Wauguequim cutiramun. Nätan taytaymi pishtarachin wira torilluta ali cutiyaramuptin’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Niptinga mayor wauguenga piñäcurur manam wayiman yaycuyta munarachu. Nätan taytanga yargarcamurmi ‘Yaycushunnar’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chauraga taytantam cay nira: ‘Caychica unay nimangaycunata cäsucur rurangäpita, nogataga manam gomaraychu ni juc cabralatas cuyanacuynïcunawan fiestata ruranäpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cananga cay churiqui manacagchru golguequita lutan warmicunawan ushacurcur chraramuptin ichaga, pishtarachinqui wira torillutas’. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Niptin taytanga nira: ‘Gamga cayanqui nogawantag imaysi. Lapan imä-aygäsi gampatag cayan. ");
INSERT INTO qvnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Antis cananga fiestata rurashun cushicuypita wauguequi cawayaptinga. Paytaga nä wanushapagmi, jinaman ogracashapagmi ricaranchi’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Chaypita Jesusga discïpuluncunatam cay nira: “Juc capogniyog runapam cara juc capuralnin. Paypitam runacuna willaparärira patronninta cay nir: ‘Chay capuralninga imaycunatas manacagchrümi ushayan’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Niräriptin patronninga chay runanta gayarcurmi nira: ‘Gampitaga lutantam mayacuyä. Canan ima-aygätas gongagta yupapämay. Nä manam imä-aygäsi ricag canquimanchu’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Niptin chay runaga pinsiara cay nirmi: ‘¿Imatarag rurashag cay urayangäpita gargaramaptinga? Chracra ruraytas manam atipächu, nätan manacuyar puriytas pengacütan. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Antis nämi tantiarü ima ruraytas, cay uryanganpita gargaramaptin wayincunachru chrasquipäcamänanpag’ nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Gayarura jucpacama patronninpita manutucusha runacunata. Naupata chrämugtam tapurun cay nir: ‘¿Aygatam manutucurayanqui patronnïpita?’ ");
INSERT INTO qvnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Niptinga ‘Pachrac barril aceititam’ nira. Chauraga chay capuralga cay nirunmi: ‘Cay papelchru ruraruy chrunca barril aceititam manutucurayä nishata’ nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chaypitaga guepan chrämugtam tapurun: ‘Gamgä, ¿aygatam manutucurayanqui?’ Niptinga ‘Pachrac medïda trïgutam’ nira. Chauraga paytas nira: ‘Cay papelchru ruraruy, puwag chruncalam manutucurayä nishata’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chaura patronga mayacasham ricacarun capuralnin chaynuy ruranganpita. Jinarcurmi cay nira: ‘Diosta mana reguegcunaga mas alim capäcun runa-mayincunapag chay santutucug runacunapitaga’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nircurmi cay nira cay pachachru ima-aygaycunatas shumag tantiarcur gastapäcuy runa-mayiquicunata yanapar ali cawapäcunaypag. Chaynuy rurapäcuptiquiga Dios yanapapäcushunquim cay pachachru. Nätan imas aygas cayagcuna usharuptinga jana pachachru chrasquisham capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Walcalawansi ali rurag runaga, achcawansi alitam ruranga. Jinaman walcawansi lutan rurag carga achcawansi manam alitachu ruranga. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chaura cay pachachru cayagcunalawansi mana alita rurarcayaptiquiga manam pisi yupachicurcäshunquichu chay razoncag alisca alinnin willapata willapacurcaptiqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chaura jucpacagwansi mana ali rurag carcayaptiquiga ¿imanaypam chrasquipäcunqui quiquiquicunapacagta? ");
INSERT INTO qvnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Manam pisi servinmanchu ishcay patrontaga ümi chregninga jucninta, ümi jucagta cuyanga. Ümi jucninta alipag ricacanga ümi jucninta manacagpag ricanga. Manam Diostawan golgueta ishcaynintaga juclachru cuyanmanchu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chay lapan niyanganta mayarärirmi golguela munag fariseo ningan runacunaga: “Yangam nicun” nir, asiparärin. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chaymi Jesusga nira: “Gamcunaga yangam alita ruragtucurcayanqui runacuna alipag ricapäcushunalaypag. Nätan Diosmi ichaga chaynuy lutan capäcungayta shumag reguercayäshunquiga. Runacunalapita alinninpag ricashacunaga Diospa naupanchrüga pasay lutanpag ricasham carcayan. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bautizag Juan chrämungancamaga Moisés isquirbinganchru, jinaman Diospa willacugnincuna isquirbinganchru ningannuymi cawapäcura. Nätan chaypinpitam cananga ali willapa willapacayan Diospa munayninchru cawapäcunanpag. Nätan chay willapata mana cäsucurmi, gamcunaga lapaysi calpayta camärir chayman yaycuyta munarcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Chaynuy captinga Moisés isquirbinganga ‘Manam välinchu’ nircayanquichr. Antis cay pachas, jana pachas ushacaglam cayan, nätan Moisés isquirbingancunaga lapanran ruracanga. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Chaymi cananga warminta wicaparcur, juc warmiwan ishcaychacurga, juchata rurayan, nätan chay wicapasha warmiwan ishcaychacugsi juchata rurayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Chay nircurmi Jesusga willapara cay nir: “Juc runam cara alisca capogniyog. Payga alinnin jacucunalatam jacucug, jinamanmi yanupacug shumag micuycunalata waran waransi. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chaychru caratan manacular cawag runa Lázaro jutiyogsi. Payga cara gueriwan pasay ushasham jinaman tayachragsi capogniyog runapa wayin punculachrümi. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Payga munapasham rircarayag capogniyog runa mësachru micuptin, ‘Wac ishquiglatas micuyulämanga’ nir. Paytaga algocunas lagwachräripacug gueriwan ushasha captinmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chaypitam payga wanurura. Jinarcurmi wanuruptinga, Diospa angelnincuna aparärira jana pachata Abrahamwan cananpag. Jinaman chay capogniyog runas wanururatan. Paytaga chaparärira pampamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chaypitam capogniyog runaga nina wayichru alisca cunchuyar nuquircunganchrüga, carupita ricapurura Abrahamwan Lázaro cayagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chaura chay capogniyogga gayacurun cay nirmi: ‘¡Tayta Abraham, cuyapämaynar! Aliscam cunchuyä cay nina wayichru. Lazarotar cachramuy dëdunta yacuchru ogorcachir gallüta ogoyächinanpag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Niptinmi Abrahamga nira: ‘Yarpachracuynar alisca capogniyog car, ali cawangayta, nätan Lázaro mana imaynagsi car alisca nacanganta. Canan payga caychru cayan cushisham. Nätan gamga cunchuyanquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Manatan chaylapishchu. Noganchichrüga cayan mana ushayniyog warau ragram. Caypita chayman aywamuy munagcunas, jinaman chaypita cayman aywamuy munagcunas manam atipanchu’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chaura capogniyog runaga niram: ‘Tayta Abraham, Lazarotanar cachralay taytäpa wayinta. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Wacchru pichgam cayan wauguëcuna. Paycunata rimapälämuchun mana cay cunchuyangäcagman shapäcamunanpag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Niruptin Abrahamga nira: ‘Paycunaga chararcayanmi Moisés isquirbingantas, jinaman Diospa willacugnincuna isquirbingantas. Chaycunata cäsucurcächun’. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Niruptinmi capogniyog runaga nira: ‘Manam tayta. Pilas wanushacunapita paycunaman aywaruptinga, lutan rurarcayanganpita wanacurcur Diosman cutipäcungam’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chaura Abrahamga nira: ‘Mana Moisestas ni Diospa willacugnincunatas mana cäsucuyarga, juc wanusha cawacämushatas manam cäsupäcunmanchu’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusga discïpuluncunata nira: “Imas aygas cayanmi runa juchäcachigga. Nätan laquipaypagmi cayan runa-mayinta juchäcachig runaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Alichr canman jatun tunay rumita cuncanman walgarcapur gochraman jitayusha carsi, cay chrasquicugcunata juclaylatas juchäcayächinganpitaga. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gamcuna shumag tantiacurcay mana chaynuy rurapäcunaypag. Wauguequi lutanpaypa nirushuptiqui shumag tantiachiypa piñapay. Nätan ‘Au, lutantam rurasha cä’ niptinga ‘Perdonay’. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Juc junagchru ganchris cuti lutanta rurarushurniqui, gamman shamunman ganchris cuti ‘Manam mastaga rurashaychu. Perdonämay’ niptinga perdonay”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Niptinmi discïpuluncunaga Jesusta manacurcara cay nir: “Tayta, cay ningayga alisca sasam. Yanapayärimaynar Diosman mas yupachicugcama capäcunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Niräriptin Jesusga nira: “Nustäsa murunuylas gamcunapa yupachicuyniquicuna captin, cay sicómoro montita ‘Caypita sapicarcur gochrachru sapichacuy’ nipäcuptiqui nipäcungaynuylam ruracarunman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Gamcuna manam maygaysi rantisha runay captin, chracray uryanganpita u uyway michinganpita chrämuptin, ‘Yaycamuy micunaypag’ nipäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Antis cay nircayanquim ‘Micuyta camarircur garamay. Micuruptïchri, upyaruptïchri, micunquis upyanquis gamga’ nircayanquim. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nä rurayta usharuptinga, ¿‘Gracias’ ninquimanchu chay uryag runayta? Manam. Masta ruraptinmi icha ‘Gracias’ ninquimanga. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chaynuymi gamcunas Dios ruray nipäcushungalaytam rurarcayanqui. Manam mastaga yarpayniquipita rurapäcushachu canqui. Chauraga quiquiquicuna nicurcay ‘Mana välig runam canchi, nimangalanchita ruranganchipita’ nir”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Chaypitam Jesús Jerusalenta aywayarga, aywayara Samariawan Galilea tincugpa. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nätan juc ichic marcalaman chrayaptinmi, yargarärimura taripacug chrunca olgocuna leprawan gueshyag. Paycuna shacayärira Jesuspita caruscalachru. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chaypitam gayacayärira cay niyta: “Yachrachig Jesús, cuyapayärimaynar nogacunata” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chaura Jesusga ricapurur nira: “Aywapäcuy sacerdöticunaman Moisés ningannuy ricapäcushunaypag”. “Äri” nir aywarcayaptilanmi gueshyancunapita cuticarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chaura juclaylaga gueshyapita cuticasha cayanganta tantiacururga, cutiramura gayachracuypanuy Diosta alisca alawayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jinamanmi Jesuspa naupanman gongorpacuyur lipucuyura, cäransi pampaman tupangancama Jesusta “Gracias” niyar. Pay cara Samaria runam. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chaura Jesusga nira: “¿Manachu chrunca capäcura gueshyapita cuticashacunaga? ¿Maychrütag waquin isgon cuticashacunaga carcayan? ");
INSERT INTO qvnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cay juclä nación runalam cutiramun Diosta alawag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nircurga chay runata: “Sharcurcur aywacuy. Yupachicamangaypam cuticasha cayanqui” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chaura fariseo ningan runacunam Jesusta tapurärin cay nir: “¿Imaynuytag Diospa munayninchru cawayta galayushun?” Nir tapuräriptinmi Jesusga nira: “Diospa munayninchrüga nämi cawarcayan runacunaga mana pipitas tantiashalachru. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chaypitaga manam ‘Caychrümi cayan’ u ‘Wacchrümi cayan’ ningachu pisi. Antis tantiapäcuptiquiga gamcunachru runacunaga nämi Diospa munayninchru cawarcayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chaypitam discïpuluncunata cay nira: “Chrämungam, juc junaglas ricayumanga jana pachapita shamug runata nipäcunay wichan. Nätan manam ricapäcamanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Waquincuna nipäcushunquim ‘Caychru cayan’ u ‘Wacchru cayan’. Nipäcuptin gamcuna ama aywapäcuysi ni gatirapäcuysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imanuymi juc lipa alisca achicyämun jana pachapita wacläman cayläman, chaynuymi musyacasha canga noga, jana pachapita runa yapay aywamunä junagga. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Naupataga aliscaran cunchuchipäcamanga. Nätan mana chrasquisham cashag cay guepa wiñay runacunapita. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé cawayänan wichan ruracangannuymi ruracanga jana pachapita noga aywamunä junagsi. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chaypin capäcura micucularmi, upyacularmi, casararcayarmi, jinaman casararcayächirmi Noé büquiman yaycungancama. Nätan alisca tamya chraramuptinmi, waquincunaga lapalan wanurärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chaynuytan cawapäcura Lot cawayänan wichansi micucular, upyacular, rantipäcular, ranticular, tarpucular, jinaman wayincunatas sharcachicular. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nätan Lot Sodoma marcapita yargoruptinmi ichaga, jana pachapita tamyanuysi ninawan azufri mayänipita ishquiramuptin lapan wanurärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chaynuymi canga jana pachapita cutimuptïsi. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Chay junag pilas wayin jananchru cayar ama iman jorgogsi wayin ruyiman yaycuchunchu, jinaman pampachru pi may cayagsi ama cutichunchu wayinta. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yarpachracurcay Lotpa warminpita. Paynuytag wanurärinquiman imaycunas raygo. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pi maysi cay pachachru caglaman yupachicugga manam nogawan cawangachu. Nätan pi maysi nogata cäsucamar wanunan captinsi cunchugmi ichaga nogawan cawanga imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jinaman caytas niyarärishay: Ishcaymi punurarcayanga juc cämachru. Jucninmi apasha canga, jucninmi jitarisha canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishcay warmi agacurcayagpitas, jucninmi apasha canga, jucninmi dëjarisha canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishcay olgom pampachru cayanga. Jucninmi apasha canga, jucninmi dëjarisha canga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chay nigta mayarurga tapupäcura: “¿Maychrütag chayga canga tayta?” Nipäcuptinmi Jesusga cay nira: “¡Maychrüsi wanushacagmanchu condurcuna gotucapäcun runa ricay! Chaynuymi nogas lapan runa ricay cutimushag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chaypitas musyapäcunganwan tincuchiypa willaparatag Jesusga chaynuyla imaycamas mana guellanälar Diosta manacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Chaura willapara cay nirmi: “Juc marcachrümi cara juc fiyis mana Diosta manchacug ni mana runa-mayintas manchacug. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay quiquin marcalachrütan cara juc viüdas. Nätan chay viüdaga cutichrag chay fiyisman ‘Gayachiläpamay chay chregnimag runata’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Niyaptinsi chay fiyis nä unaymi mana cäsurachu. Chaypitaga quiquin fiyismi nicura: ‘Manatag Diostas manchacüchu ni cäsüchu runa-mayïtas. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Cay viüdaga umätam nanayächin, jinas rurarushag manacayämanganta, yaparcur yaparcur cutichrayämur mana piñäcachimänanpag’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chay nircursi Jesusga cay niram: “Lutan rurag cayarsi chay fiyisga chaynuymi nirura, ");
INSERT INTO qvnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿nätan Diosga manachur washanga pagas junag manacug acrashancunata? ¿‘Shuyay’ ningaragchur? Manam. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Payga mana shuyächilarmi chayüra washanga. Nätan noga jana pachapita runaga cutimur, ¿tarishagchur cay pachachru Diosman yupachicug runacunata?” ");
INSERT INTO qvnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Chaypitam Jesusga yachrachira tantiapäcunanpag, chay waquin alitucugcuna, runa-mayinta mana alipag ricapäcuptin cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcay runacunam aywapäcura Diospa wayinta Diosta manacurcänanpag. Jucninmi cara fariseo nipäcungan, nätan jucninmi cara patenti cobrag. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseoga shacuyurmi cay nira: ‘Nogaga manam waquinnuysi suwachu, lutan ruragchu, mansibaduchu, patenti cobrag lutan runanuychu cä. Chaymi Tayta Dios, gamta gracias nicug. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nogaga malagä micuypita ishcay cutim semänachru, nätan chruncapita juctatan gogsi lapan capamagnïpitas’. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nätan patenti cobragga carulachrümi lipucuyura laquicuypita pëchunta cutacuyar ‘Dios Tayta, juchasapam cä. Cuyapayämaynar nogata’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nipäcushay cay patenti cobrag runaga wayinman cutiyurura mana juchaynagmi, nätan fariseoga pachalan juchayogmi cutiyurura. Pi maysi alawacugcagga pengacusham canga. Nätan pisi manchacuypa lipucugmi ichaga alinninpag ricasha cangaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chaypita Jesusman apapäcamuratan wamracunatas umanta yatayunanpag. Chayta ricapur discïpuluncunaga piñaparärira wamra aywachimugcunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nätan Jesusga gayarcurmi cay nira: “Wamracunaga jina aywacarcämuchun nogaman. Ama jarcapäcuychu. Paycunanuysi cagcunam Diospa munayninchrüga nä cawarcayan. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Shumag mayapäcamay: Juc wamranuy mana capäcurga manam pisi Diospa munayninchru cawapäcungachu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chaypitam juc mandag reguesha runaga Jesusta tapura cay nir: “Yachrachig, gamga cayanqui alim. ¿Imatatag ruräman imaycamas Dioswan cawanäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Niptinmi Jesusga nira: “Chaynuy nirga ¿‘Alitam’ niyämanqui? Aliga cayan Dioslam. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gamga musyayanquim Dios mandangancunata. Payga cay niram: ‘Amam mansibacunquichu. Amam wanuchinquichu. Amam suwacunquichu. Amam yanga pipitas rimanquichu manacagcunataga, jinaman alipa ricay taytaytas mamaytas’ ninganta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Niptinmi chay runaga nira: “Lapan chaycunataga wamra cangäpitam cäsucü”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chay nigta mayarurmi Jesusga nira: “Juclaylataga manaran ruranquiragchu. Ranticuruy lapanta ima-aygaycunatas, jinaman mana imaynagcunata goruy. Ningäta rurarga jana pachachru capogniyogmi canqui, jinaman, nogawan uryashun”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Niruptin runaga aliscam laquicurura, alisca capogniyog car. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chaynuy laquishata ricapurur, Jesusga nira: “Capogniyogpagga alisca sasam Diospa munayninchru cawayga. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Antis juc camellu uywasi ushturunmanmi aujapa rinrinpa, juc capogniyog runam icha alisca sasatarag yaycun Diospa munayninman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Niruptin mayacurcayagcunaga nipäcura: “¿Chauraga pitag salvashaga canga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Niräriptinmi Jesusga nira: “Runacunapagga alisca sasam, nätan Diospagmi ichaga mana sasachüga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chaura Pedroga niram: “Tayta, ¿nogacunagä? Imäcunatas dëjarcurmi gamwan purircayä”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Niptinga cay niram: “Pi maysi wayinta, taytanta, wauguenta, warminta, churinta, Diospa munayninchru cawanan raygo dëjagga, ");
INSERT INTO qvnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cay pachachru imacunatas mastam chrasquinga, nätan jana pachachrümi imaycamas cawanga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chay nircurmi Jesusga chrunca ishcayniyog discïpuluncunata jucläman gayarcur cay nira: “Cananga aywashun Jerusalentam. Chaychrümi noga jana pachapita runata imatas rurapäcamanga Diospa unay willacugnincuna isquirbipäcungannuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chaychrümi juclä nación runacunapa maquinman jitayusha cashag. Jinaman chaychrümi asipapäcamanga, ashlipapäcamanga, togapapäcamanga. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nätan alisca astircurmi wanuchipäcamanga. Chaypitam quima junagtaga cawacämushag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chay ninganta discïpuluncunaga pasay manam tantiapäcushachu, sasa tantiay captin. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chaypita nä Jericó marcaman Jesús nachrgayaptinmi, juc ñausha runa camiñuchru tayayänag, runacunata manacuyar. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nätan achca runacuna aywagta mayarurmi, ñaushaga tapucura: “¿Imam cayan?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chauraga nipäcuram: “Nazaret marcapita Jesusmi aywayan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Niräriptinga gayachracura cay nirmi: “¡Jesús! ¡Davidpa castan, cuyapämaynar nogata!” ");
INSERT INTO qvnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Niptinga naupa aywagcunaga piñapapäcura upälala cananpagmi. Nätan payga mas calpanpam gayachracura: “¡Davidpa castan, cuyapämaynar nogata!” ");
INSERT INTO qvnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nigta mayarur Jesusga shayuyurmi “Pushapäcamuy” nira. Nä paycagman chrarärichiptinga, tapura cay nirmi: ");
INSERT INTO qvnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Imachru yanapänagtam munayanqui?” Niptinmi ñaushaga nira: “Tayta, ñawï cuticächinaytam munayä”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Niruptinmi Jesusga nira: “Ricapuy. Nogaman yupachicamangaypam cuticarunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Niptinga chaylam ñawinga cuticarura. Jinamanmi Jesusta gatirara Diosta alawayar. Lapan runas chayta ricarärirga Diostam alawapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Chaura Jesusga Jericó marcaman chrarurga, chay marcapam pasara. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nätan chaychrümi cara juc capogniyog runa, patenti cobragcunapa mandagnin, Zaqueo jutiyog. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pay munara Jesús regueytam, nätan mana ricapuyta atiparachu achca runa captinmi, jinaman tacsala carmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chauraga ricapunanpag naupata wayrala aywarcur jegarura ‘sicómoro’ ningan montimanmi chaypa pasayaptin Jesusta ricapunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nä chaypa aywayarga, Zaqueotam nuquircur ricapurun. Chaypitam cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","“Wayrala jegarpamuy Zaqueo. Cananga wayiquichrümi gorpachacunä cayan”. Niruptin Zaqueoga wayrala jegarparcamur, cushisham Jesuswan aywara wayinta. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayta ricapurur, lapanmi runacuna pengapapäcura “¿Juchasapapa wayinta aywarcurchu, gorpachacurun?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chaura Zaqueoga shacuyurmi Jesusta nira: “Tayta, cananga lapan ima-aygäpitas lamitätam goshag mana imaynagsi runacunata, nätan pitas suwapasha carga, chruscu chaynuytam cutichipushag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Niptinmi Jesusga nira: “Cananga cay wayiyog runa aylluntinmi salvacarärin Abrahamnuysi yupachicug canganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Noga jana pachapita runaga aywarayämü juchacunachru carcayagta salvanäpag ashigmi” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Chauraga nämi nachrgarcayara Jerusalenman. Jinarcurmi paywan aywagcunaga chay nigta mayarärirga pinsiarärira cay nir: “Cananga chrarularchri fiju rey canganta reguechicurunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nipäcuptinmi Jesusga caynuypa tantiachira: “Juc alinnin reguesha runam cara. Payga aywasha alisca caru naciontam nombramintunta chrasquircur cutimunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nä yargorga chrunca uryagnincunata gayarcurmi aypura chranin golgueta ‘Cutimungäcama cay golguëta mirarcayächiy’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nätan marca-mayincunam chregnipar guepanta cachrapäcura ‘Manam munapäcüchu cay runata mandagnïcuna cananta’ nipäcunäpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nätan payga rey cananpag cutiramurga gayachira uryagnincunatam aygatacama mirachipäcungantas golguenpita musyananpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Naupa chrämugga cay niram: ‘Tayta, golguequita mirarayächï chrunca mastam’. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Niptinmi mandagga ‘Gamga ali uryagnïmi cayanqui. Walcalachrüsi ali rurag cangaypita chrunca marcachru mandagmi canqui’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chaypitam jucninsi chraramurga cay nira: ‘Tayta, golguequita mirarayächï pichga mastam’. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Paytas cay nirunmi: ‘Gamga canqui pichga marcachru mandagmi’. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nätan juc chraramurga cay niram: ‘Tayta, cä cayan golguequi. Sagpiwan wancurcurmi chrurarurä gamta manchacur. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jinaman rimangaynuysi rurag captiquim, mana chrurangaycunapita jorgamug captiquim, mana tarpungaypita cosechag captiquim chrurarurä’. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chaura mandagga cay niram: ‘Lutan runa. Rimacuylaypam musyarü chaynuy runa cangayta. Nätan mirayninta manag cangäta, jinaman mana chrurangäpitas jorgamug cangäta jinaman mana tarpungäpitas cosechag cangäta musyayarga, ");
INSERT INTO qvnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿imanirtag golguëtaga mana chruraraychu bancuman, wayïman cutimur miraynintinta chrasquinäpag?’ ");
INSERT INTO qvnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nircurga chaychru carcayagcunatam nira: ‘Guechrupäcuy golguë charayanganta, jinaman gopäcuy chrunca charayagcagta’. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Niptin paycuna nipäcuram: ‘¡Chrunca golgueta charayarsi mastaragchu chrasquinga!’ ");
INSERT INTO qvnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chaura mandagga cay niram: ‘Chay mirachigcagtam masta mirachinanpag goshag. Mana mirachigcagga walcala charayangansi guechrusham canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nätan chay chregnimagnïcunata mana mandagnin canäpag munagcunata pushapäcamuy cayman naupächru wanuchipäcunaypag’ niram”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chayta nircurga, Jesús aywacura Jerusalentam. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nä Betfagëman, jinaman Betania marcaman nachrgayarga, Olivos gotu chraquinpitam Jesusga cachrara ishcay discïpuluncunata ");
INSERT INTO qvnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","cay nir: “Aywapäcuy wac chimpachru cayag tacsa marcalata. Chayman chrarur taripäcunqui juc chucaru ashnu watashatam. Chayta cachrarircur aywachipäcamuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pisi ‘¿Imapagta pasquircayanqui?’ nipäcushuptiquiga, ‘Munayniyogninchim munayan logacunanpag’ nipäcunquim”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Niptinmi discïpulucunaga aywarcur tarirärira Jesús ningannuyla. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Chaypita nä ashnuta pasquircayaptinmi, ashnupa runanga nira: “¿Imapagta ashnüta pasquircayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Niptinmi paycunaga nipäcura: “Munayniyog Jesusmi ‘Aywachimuy’ nircayäman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chaura “Äri” niruptinga aywachipäcamusha. Nä Jesusman chrarärichimurga, ashnu jananman jacuncunata suwadïrurcurmi Jesusta logarärichira. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chay logasha aywayaptinmi runacunaga camiñuman jacuncunata mashtapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nä Olivos gotu chraquinpita uranpamunaman nachrgarcayämuptinmi, discïpulucunaga chranin gatirag runacunawan cushicuypita galacayärira alisca äyay äyar Dios alawayta, ima-aygatas ali ruranganta ricapäcunganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Naupapäcura cay nirmi: “Alawasha cachun Dios cachramungan aywayämug mandagninchi. ¡Payga aywarayämun ali cawayta yanapämänanchipagmi! Chaura alisca alawasha cachun jana pachacunachru cayagga” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chauraga juc ishcay chaychru cayag fariseo runacunaga Jesustam cay nirärin: “Yachrachig, upälächiy chay gaparayag runacunata”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nipäcuptinmi Jesusga nira: “Paycuna upälaptinga, rumicunam gaparapäcunga paycunapa trucan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chauraga nä Jerusalenman nachrgayarmi Jesusga wagacura chay marcachru cayag runacunata ricapurur, ");
INSERT INTO qvnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","cay nir: “¡Ay! Canan junaglaychrüsi tantiarärinquimanga alita cawachipäcunagpag aywamungäta. Nätan cananga nä manam imanacursi tantiapäcunquimanchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chaymi gamcunam aywamunga mana ali caway junagcuna. Chaychrümi chregnishugniquicuna muyurapäcushunqui, jinamanmi chay marcata muyug pergacagman lapayta goturcur yaycapäcamunga. Chaura manam imanaytas atipapäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cay marcata juchruchipäcur manam juclay rumilatas pergashata dëjapäcungachu. Jinarcurmi chaychru yachrag runacunata munanganta rurapäcunga. Chaynuy rurasha capäcunga salvacugta mana chrasquipäcunganpitam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chaypitam Jesusga yaycura Diospa wayinman. Jinarcurmi chaychru lapan ranticugcunatawan rantipacugcunata washaman gargaramura ");
INSERT INTO qvnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","cay niyar: “Isquirbishacunachrüga cay niyanmi: ‘Wayïga cayan runacunawan rimanäpagmi, nätan gamcunaga muyurärichinqui suwacunapa machraynintanuymi’ ” niyar. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jinarcurga lapan junagmi Jesusga yachrachira Diospa wayin puncuchru. Nätan sacerdöticunapa mandagnincunawan, Moisés isquirbinganpita yachrachigcunaga, alinninpag ricasha chacha runacunaga imanaypanuysi wanurachiylatam munapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nätan manam imanuypa wanuchiytas atipapäcurachu lapan runacuna shumag mayacurcaptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Juc junag Jesús Diospa wayin puncuchru yachrayächiptinmi, nätan salvacurcänanpag ali willapata musyayächiptinmi chrarärira sacerdöticunapa mandagnincuna, Moisés isquirbinganpita yachrachigcuna, alinninpag ricasha chacha runacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Chaychrümi Jesusta tapupäcura cay nir: “¿Pi nishuptiquitag rurayanqui caycunata u pitag cachraramushunqui cayta ruranaypag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nipäcuptinmi Jesusga nira: “Nogas tapuyärishay juclaylata. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitag cachramura Juanta runacunata bautizänanpag, Dioschu u runacunachu? Mä nipäcamä”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Niruptinga quiquincamam tapunacurcara cay nir: “¿Ima nishuntag? ‘Diosmi cachramura’ nirushaga, ‘¿Imanirtag mana chrasquicurcaraychu?’ nimäshunchri. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nätan ‘Runacunam cachramura’ nirushaga, lapan runachr chapiypa wanurachimäshun. Nätan lapan runas musyapäcuraga Juan Diospa willacugnin cangantam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chaypitam Jesusta nipäcura: “Manam musyapäcüchu Juanta pi cachramungantas”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nipäcuptin Jesusga “Chauraga manam nogasi nipäcushaychu, pi cachramasha captin caycunata rurayangätas” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaypita Jesusga galayura runacuna rimapaytam shumag tantiapäcunanpag cay nir: “Juc runam chracranman murura üvasta. Chaypitam ishcay quima runacunata arrendacurcur, aywacura caruta unaylapag. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chauraga nä üvas palay wichan chraramuptinga chracrayog runaga cachrara juc uryag runantam arrindupita manamunanpag. Nätan chay chracra uryagcunaga magarcurmi jinalata gargarirärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chaura chracrayog runaga yapaytan cachrara juc uryag runantatag. Paytasi ashlircurmi, jinaman magarcurmi jinalata gargapäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chay chracrayog runaga yapaymi cachraratag juc runanta. Chaytasi alisca magarcurmi jitaripäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Chaura chay chracrayog runaga: ‘¿Imanäshagtag?’ Niyanganpitam cay nira: ‘Cananga cachrashag cuyay churïtam. Pay chraruptinga manchacuylapitas gorärimungapishchri’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chaura churin cachranganta ricaparärirga chay uryagcunaga, rimanacarärinag cay nirmi: ‘¡Jay! Chracrayogpa churin aywayämun. Wacmi chrasquinga taytanpacagta lapan imantasi, antis wanurachishun noganchipag lapan imansi cananpag’. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nirga chracrapita jorgorcurmi churintaga wanurärichira”. Chayta nircurga, chaychru cayagcunata Jesús tapura cay nirmi: “¿Imatarag ruranga paycunata chay chracrayog runa? ");
INSERT INTO qvnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aywarcamurchri wanuchinga chay juyu uryagcunata, nätan chracrantachr gorunga juc runacunata”. Chay nigta mayarärirga: “Ama Dios munachunchu chaynuy cananchita” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chaura Jesusga paycunata rircärircurmi nira: “¿Imaninantatag isquirbishacuna: ‘Manam alichu cay rumi’ nir, wayi sharcachigcuna wicapapäcunganga casha ‘Mas alinnincag rumim’ niyan?” ");
INSERT INTO qvnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nircurmi cay nirun: “Pi maysi chay ruminuysi cayagta mana chrasquicamagga, lutantam ruracuyan. Nätan chay ruminuysi cayag cutimuptin alisca cunchuchisham capäcunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chauraga sacerdöticunapa mandagnincunaga, jinaman Moisés isquirbinganpita yachrachigcunaga chayüram Jesús chariyta munapäcura “Noganchitam lutan uryagcuna nirga niramanchi” nir. Nätan mana charipäcurachu runacunata manchacurmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chauraga chay ashiparcayag runacunam juc ishcay lutan runacunata yachrarcachir Jesusman cachrarärira. Paycunaga chrarärin alitucuyar lutanta rimachipäcunan raygom. Jinaman lutanta rimapacuruptin tenintiman aywachipäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chay runacunaga cay nirmi tapurärin: “Yachrachig, musyarcayämi rimangaysi, yachrachingaysi ali canganta. Gamga yachrayächinqui lapan runacunatas razoncagtam, jinaman Dios ningannuylam. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mä niyärimay: Cesarta patenti pägarcayangä ¿alichu cayan u manachu ali?” ");
INSERT INTO qvnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Chaura lutan pinsiarcayanganta tantiarurmi, Jesusga nirun: “¿Imanirtag lutan rimachimayta munarcayanqui Cesarpita? ");
INSERT INTO qvnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mä ricachipäcamay golgueta”. Ricarärichiptinga nirunmi: “¿Pipa cärantag cayga? Jinaman ¿pipa jutintag caychru isquirbisha cayan?” ");
INSERT INTO qvnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chaura paycunaga nipäcuram: “Roma nacionchru mandag Cesarpam”. Chaura Jesusga nirunmi: “Cesarpa cagta, Cesarta gopäcuy, nätan Diospa cagta, Diosta gopäcuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nätan runacunapa naupanchru mana imanaypas lutan rimachiyta atiparga, pengacusham quëdarärin alita niruptin, jinaman upäläcayäriram. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaypitam juc ishcay saduceo nipäcungan runacunaga aywapäcura Jesusman. Saduceocunaga “Manam pisi wanushapita cawacämunchu” nipäcunanpag. Chaymi Jesusta tapupäcura cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tayta, Moisespa isquirbishan charapäcunganchrüga cay niyanmi: ‘Juc olgo, warminchru mana churin captilan wanuruptinga chay wanushapa wauguenmi viüdanwan casaracunga, nätan chaypa churin caruptinga difuntupa jutintam chay wamra apanga’ niyanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nircurmi cay nipäcura: “Capäcura ganchris wauguecunam. Mayorcagmi casararcular wanurura manaragsi churin captilan. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chauraga shulcancagmi casaracura chay viüdanwan. Paysi wanurura manarag churin captilanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chaynuytan chaypa mas shulcancagsi casaracurura chay viüdanwan. Chaynuylam casararärira lapansi. Jinaman ganchrisnintinmi wanurärira churiynagla. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jina guepantaga warmis wanururam. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chauraga wanushacuna cawacämuptinga, ¿mayganpa warminrag canga ganchrisnintinsi chay warmilawan casaracurayaptinga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nipäcuptinmi Jesusga cay nira: “Cay pachachrümi olgos warmis casaracurcayanga. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nätan jana pachata aywananpag cawacämugcunaga ni manatan casaracurcangasi ni casarapäcunanpagsi rimapäcungachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wacchrüga capäcunga angelcunanuymi, jinaman Diospa castanman muyusham mana imaysi wanugpag nä cawacämusha capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Quiquin Moisespis musyachimanchim wanushapita cawacämuypitaga. Chay casha rupayagpita payga mayara cay nimugtam ‘Diosga Abrahampas Isaacpas Jacobpas Diosninmi’ nimugtam. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chaura Diosga manam wanushacunapa Diosninchu, antis cawayagcunapa Diosninmi. Paypagga lapan wanushacunas cawayanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chauraga Moisés isquirbinganpita chay juc ishcay yachrachigcuna nipäcuram: “Tayta, alitam nirunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nircurga manam mastaga tapupayta almitipäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chaura Jesusga tapura cay nirmi: “¿Imanirtag nipäcunqui: ‘Cristoga Davidpa castanpitam canga’ nirga? ");
INSERT INTO qvnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidga quiquinmi Salmos libruchru Cristopita cay nira: ‘Munayniyog Diosga munayniyognï salvacugtam cay nira: “Tayucuy derëcha lädüman ");
INSERT INTO qvnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","chregnishugniquicunata maquiquiman chruramungäcama” nir’. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chaura Rey Davidga Cristota ‘Munayniyognï’ niyaptinga, ¿imanaypatag chaura Cristoga canga Davidpa castan aywamugga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nätan lapan runacunas mayarcayaptinmi Jesusga discïpuluncunata cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gamcunaga ashucurcanquim Moisespa isquirbishan yachrachigcunapita. Paycunaga munapäcun ura uracama jacupäcusha puriytam. Paycunaga munapäcun pläzacunachru alisca saludasha caytaran. Paycunaga munapäcun gotucurcänan wayichrüsi alinnin tayucunachru tayaytaran. Nätan micunanpagsi tayayta munapäcun naupa naupamanran. ");
INSERT INTO qvnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaycunaga viüdacunapa wayinman yaycuyurmi imalancagtas suwacurcan, nätan lutan ruranganta mana pisi tantiananpagmi Diosta alisca unay yangala manacurcan. Paycunaga canga pipita maypitas mas cunchuchisham”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chaypita Jesusga rircarayara alisca capogniyog runacuna ofrenda gotucurcänanman golgue jitayuyagtam. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chaynuy rircarayaptinmi juc mana imaynagsi viüda ishcay acapa golguelata jitayurun. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chaura Jesusga nirunmi: “Cay ningäta mayapäcuy: Cay mana imaynagsi viüdaga jitayurun lapanpitas mastam. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Lapansi gorärin achcapita puchuglantam. Cay viüdam ichaga mana imaynag cayarsi, jitayurun lapanta rantipacunanpagcagtawan”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nätan waquin runacunam rimarcayara Diospa wayin, alisca shumag rumicunawan rurarayagpita, jinaman ofrenda gopäcunganwan alisca shumag quëdanganpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Chay nipäcugta mayarmi Jesús nirun: “Cay lapan ricarcayangayga juc junag shumag juchruchisham canga. Manam juc rumis pergashalaga quëdangachu, antis pampanman rurasham canga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chaura paycunaga tapupäcura cay nirmi: “Yachrachig, ¿imaytag chayga ruracanga? ¿Chaynuy ruracänanpag naupataga imarag canga?” ");
INSERT INTO qvnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nipäcuptin Jesusga nira: “Mayag mayagla cacurcayay pisi engañarärishunquimantag. Achcam aywapäcamunga ‘Nogam Cristo cayä’ nir, casquicurcayar. Cananga nä chay nipäcunan wichanmanmi yaycuyanchi. Nätan gamcunaga ama cäsucurcaychu paycunata. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","‘Guërrash cayan’ nigta mayacur u ‘Runacunash imata rurapäcunanpagsi alisca sucsutänacurcayan’ nigta mayarsi amam manchacapäcunquichu. Naupataga chaynuyran canga, nätan manaran ushanan junagragchüga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chaypitaga niratan caytas: “Juc nacionmi guërrachru canga juc nacionwan. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nätan juc reysi guërramantan yaycunga juc reywan, cay pachäsi alicusam cuyunga, micuy wanaysi juyupam canga, tucuy gueshyacunam wacagchru cayagchru canga, jinaman jana pachachrüsi alisca manchacuypagmi. ima-aygas ricacämunga. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Caycuna cananpagga naupataga gamcunataran cunchuchipäcushunqui, nätan wanuchipäcushunaypagmi gaticachrapäcushunqui. Aywachipäcushunquitan yangapita juchacharcur Israel castäcuna gotucarcänan wayimansi. Jinarcurga carcelmansi jitayapäcushunquim. Jinaman aywachipäcushunquitan nogapa janä mandagcunapa naupanmansi, gobernadorcunapa maquinmansi. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Maymansi chrächipäcushungaychrümi gamcunaga nogapita willapacurcanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amam shongolaycunachrüsi laquirapäcunquichu ‘¿Imatatag nishag?’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nogam rimachipäcushay, jinaman tantiaytas gopäcushay alicagta rimapäcunaypag. Chauraga manam maygan chregnishugniquicunas ‘Lutantam nirunqui’ niyta manam atipapäcushunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gamcunataga marcachru mandagmansi aywachipäcushunqui taytalaycunam, wauguelaycunam, castaycunalam, jinaman cuyanacungay runacunalam. Chaynuy jinar waquinniquitam wanuchipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nogapa janäga lapan runacunapitas chregnisham capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nätan gamcunapagga manam ogracangachu ni juclay agchalaysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chaura ima-aygatas awantapäcurga salvasham capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nätan cay Jerusalén marcata soldäducuna muyurayagta ricapurmi, musyapäcunqui nä Jerusalén marcata juchruchipäcunanpag üra ayparayämunganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chauraga Judea marcachru yachragcuna, gueshpicurcay gotucunaman. Jerusalén marcachru yachragsi aywacurcay, nätan pampachru cayagcuna, ama yaycapäcuychu marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chay junagcunaga canga alisca cunchuymi. Chauraga Diospa librunchru lapan isquirbisha niyangannuymi ruracanga. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Cuyapaypagmi canga chay wichan pachrayog warmicuna, jinaman iñasha wawayogcunas. Cay pachachrüga aliscam laquicuy canga. Lapan runacuna juyunaypam cunchupäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquinga wanupäcunga espädawan tucsisham, nätan waquintaga aywachipäcunga uchcurcurmi lapan nacioncunaman. Chaychrümi cay Jerusalén marcataga munanganta rurapäcunga juc casta runacuna. Chaynuy rurapäcunga Dios cay marcapita chay juc runacunata jorgongancamam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Chaypitaga intichrüsi, quillachrüsi, goyllarcunachrüsi manchacuypagmi ricacunga imacunas. Nätan cay pachachru runacunaga laquisham, manchacasham capäcunga, lapan jatun gochracuna alisca wagariptin, jinaman walyaywan lagyamuptin. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chaynuy captin runacuna wanupapäcungam manchacaypita ‘Imas cay pachachrüga carungachr’ nir, chaynuytan jana pachachru imacunas cuyurisha canga. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chauraga chaylam ricapapäcamanga runacuna, noga jana pachapita runa pucutay jananchru alisca munayniyog, jinaman mandanäpag aywamugta. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nä caycuna ruracay galayuptinga, mayag mayagla cushisha shuyacarcayämay. Chauraga nämi chay ima-aygapitas jorgosha capäcunaypag nachrgayämun”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Caynuypas tantiapäcunanpag niratan: “Ricapäcuy hïgos montita. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nä yürancuna chicchiyämugta ricapurga musyarcayanqui nä usya wichanman yargorcayangaytam. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chaynuymi chay ningäcuna ruracagta ricapursi tantiapäcunqui Diospa munayninchru cawapäcunaypag nä nachrgayämunganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cayta mayapäcamay: Lapan caycuna ruracanga canan wichan runacuna manas wanuptilanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jana pachas, cay pachas ushacaglam cayan. Cay rimangäcunam ichaga lapansi ruracangarag. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Shumagmar tantiacurcanqui, shongoycuna munangannuytag shincacular, imas lutanta ruracular u imas rurayniquicunachru cacular cacurcanquiman. Chaynuy cawarcayaptiquiga mayänipitam chraramunga chay junag, juc uywaman läsu yaycugnuysi. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chaynuymi chrämunga cay pachachru lapan cawayag runacunaman. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nätan gamcunaga camacushala cacurcayay, pagaspas junagpas Diosta manacurcayar, cay lapan imas aygas captin gueshpipäcunaypag, jinaman noga, jana pachapita shamuptï naupäman aywapäcamunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesusga junagpam yachrachira Diospa wayin puncunchru, nätan pagaspam aywachrag Olivos ningan gotuta. ");
INSERT INTO qvnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nätan lapan runacuna Diospa wayinman aywapäcug waran waransi goyashlam Jesús yachrachiptin mayacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chauraga nämi nachrgayämura mana levaduraynag tanta rurapäcunan fiesta. Chay fiestata Pascua nipäcugmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nätan sacerdöticunapa mandagnincunawan, Moisés isquirbinganpita yachrachigcunam cay ninacurcara: “¿Imanaypatag Jesusta wanurachichwansi?” nir. Nätan chaychru runacuna cayagta manchacurmi mana wanuchiyta atipapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nätan Judasga Asyagpa munayninchrümi ricacarura, Judastaga gayapäcuratan Iscariote nirsi. Payga cara chrunca ishcayniyog discïpuluncunapita jucmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Payga aywarunag Jesusta imanaypa reguechinanpagsi chay sacerdöticunapa mandagnincunawan, jinaman Diospa wayinta ricag guardiacunapa mandagnincunawan rimagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nä chraruptin paycunaga cushicaräriram. Chaypitam “Golguetam gopäcushay” nirärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chaynuypa niräriptin Judasga “Äri” nirunmi. Chauraga imalas canantam shuyag shuyagla cayara, runacuna nä chunyaruptin reguechinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chauraga nä chraramura mana levaduraynag tanta micapäcunan fiestam. Chaychrümi Pascua cënapag achrcashta wanuchipäcug. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chaura Jesusga cachrara Pedrotawan Juantam cay nir: “Aywapäcuy jinaman camaripäcamuy cënananchipag Pascua micuyta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Niptin paycunaga tapupäcura: “¿Maychru camaripäcamunätatag munayanqui?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nipäcuptinmi Jesús nira: “Nä marcaman yaycurcayarmi, wacuywan yacu apayag olgowan tincupäcunqui. Paytam gatirapäcunqui may wayiman yaycunantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaypitam chay wayiyog runata nipäcunqui: ‘Yachrachigmi niyan ¿maygan wayiquichrümi discïpulücunawan micushag Pascua micuyta?’ ");
INSERT INTO qvnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nipäcuptiquim, reguechipäcushunqui juc jatun wayipa altusninta shumag chrurachracushata. Chaychru camaripäcamuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Niptin paycuna aywacurcara marcatam. Chauraga Jesús ningannuylam tarirärira lapanta. Chaychrümi camaripäcura Pascua micuy cënata. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nä cënay üra chraramuptinmi Jesusga discïpuluncunawan ashuyarärira mësaman micapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chaychrümi Jesusga nira: “Aliscam munarä gamcunawan cay Pascua cëna micuyta manaragsi wanungäcama. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cay micuytaga mana micushagchu Diospa munayninchru yapay micunganchicamam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chauraga cöpata charircurmi, Diosta “Gracias” nicurcurga discïpuluncunata nira: “Upyapäcuy caypita. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cay üvaspa yacuntaga mana upyashagchu Diospa munayninchru cawayta galayunganchicamam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chaypitaga tantata charicurcurmi, Diosta “Gracias” nicurga, partircur gora cay niyar: “Cay tantaga cayan cuerpünuymi gamcuna raygom wanuchisha cashag. Imaysi cayta rurapäcunqui wanungäta yarpapäcunaypagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chaynuytan nä cënacurcurga cöpata charircursi niratag: “Cay vïnu cayan yawarnïnuymi. Chaura yawarnïta perdir wanungämi välichinga gamcunawan cay mushog conträta ruranganchita. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nätan wanuchipäcamänanpag reguechimag runas, chica üram cayan cay mësachru. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Noga jana pachapita runaga wanushag Dios ningannuyran. ¡Ay! Aliscam laquipä chay reguechimag runata”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Niruptinga quiquincamam tapunacuyta galacayärira: “¿Mayganchitag cayanchi?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chaypitam paycunaga galacayärira cay ninacuyta: “¿Mayganchirag cashun mas alinninpag ricasha runa?” ");
INSERT INTO qvnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nipäcuptinmi Jesusga nira: “Nacioncunachru munayniyogcuna mandapäcun juyunaypam runacunata, nätan mandayta yanapagcunatam ali rurag runa nipäcun. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nätan gamcunachrüga manam chaynuychu canga. Antis gamcunachru maygaysi mandagcagga manacag runapagrag ricacuchun, jinaman mandagcagga capäcuy juc servignuyrag. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mä tapuyärishay: Gamcunapita, ¿maygantag mas alinnin runa, micunanpag mësaman tayugchu u servicugchu? Mësaman micunanpag tayugmi, ¿au? Nätan nogaga gamcunachru cayä juc servicugnuymi. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nätan gamcunaga nogawanmi ima-ayga nacaychrüsi capäcuray. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chaymi cananga quiquï nircayag mandag capäcunaypag, nogatas Taytä mandag canäpag nimangannuy. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chaura gamcunaga, nogawanmi micapäcunquis upyapäcunquis nä munaynïchru carcayarga, jinaman tayapäcunquis reypa trönuncunachrümi Israelpa chay chrunca ishcayniyog castacunata juchanpita taripapäcunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chaypita Jesusga Simontas cay niratan: “Simón, Simón, Asyagmi Diosta manacurun gamta trïguta wauyachignuysi rurashunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nätan nogaga gampagmi Diosta manacurü chaynuyla Diosman yupachicunaypag. Chaura gam juchaman ishquirur gangalanta nogaman cutimurga wauguequicunata chaynuyla yupachicarcämänanpagmi yanapanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jesús niruptinmi Pedroga cay nin: “Tayta, nogaga camacushalam cayä gamwan carcelman aywanäpagsi u wanuchipäcushuptiqui gamwan wanunäpagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Niptinmi Jesusga “Pedro, gallo manaragsi wagamuptilanmi, canan ninqui nogapita quima cuti mana reguemangayta” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaypitam Jesusga paycunata cay nira: “Mana bolsaynagta, mana alforjaynagta, mana sandaliaynagta, naupata cachraptï ¿imalas pishipapäcushuraychu?” Niptin paycunaga nipäcuram: “Manam imas”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Nätan cananga bolsaycuna captin apapäcuy, jinaman alforjaycunatas. Nätan mana espädaynagga janan jacunta ranticurcur rantichun juc espädata. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nätan nogawanga ruracanga isquirbishachru ningannuymi. Chaychrüga cay niyanmi ‘Juchasapapag ricasham canga’ ninmi. Chaymi nogapita lapan isquirbirayagcuna nogachru ruracanga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Niptinga paycuna nipäcuram: “Tayta, caychru cayanmi ishcay espädalaga”. Niräriptinmi payga nira: “Ama antis rimashagchu mana tantiarcayämaptiquiga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chaypitam Jesusga yargor Olivos gotuta imaysi aywachrangannuy aywara, jina guepantam aywapäcura discïpuluncunatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nä gotuman chrarurga discïpuluncunatam nira: “Diosta manacurcay mana juchaman ishquipäcunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nircurga paycunapita mas wacläcascaman ashurcurmi gongorpacuyur Diosta manacura ");
INSERT INTO qvnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","cay nir: “Tayta, munarga washamay alisca nacanäpita. Nätan ama munangänuyga ruracächunchu, antis gam munangaynuy ruracächunga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jesús niyaptilanmi jana pachapita juc ángel ricacarura calpanchänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Chauraga alisca laquisha cayarmi, Jesusga Taytanta manacura lapan calpanpa, südayninsi pampaman shutura yawarnuymi. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nä manacunganpita sharcurcurga, aymura discïpuluncunacagtam. Nätan paycunataga tarirura laquicuypita punucashatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chaura Jesusga “¿Imanirtag punurcayanqui? Sharcapäcuy, Diosta manacurcay, juchaman mana ishquipäcunaypag” niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús chaynuy rimayaptilanmi achca runacuna chrarärimura. Chay runacunapa naupantam aywamunag Judas. Payga cara chay chrunca ishcayniyog discïpuluncuna castam. Paymi Jesuscagman ashuyur mucharun. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chaura Jesusga nirunmi: “Judas, ¿muchaypachu cay runacunapa maquinman jitarayämanqui, noga jana pachapita shamusha runata?” ");
INSERT INTO qvnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chay nigta mayarurmi discïpulucunaga Jesusta tapurärira cay nir: “Tayta, ¿espädawanchu tucsipäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chaylam juc discïpuluga sacerdöticuna mandagpa rantisha runanta derëchacag rinrinta cuchurura espädawan. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chaura Jesusga nirunmi: “¡Ama mastaga rurapäcuychu imatas!” Nircur chay runapa rinrinta yatayurmi, cuticarachira. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chaypitaga sacerdöticunapa mandagnincunatam, Diospa wayin ricag guardiacunapa mandagnincunatam, jinaman Israel castachru alinninpag ricasha chacha runacuna Jesusta aywachipäcunanpag chrämushacunatam nirun: “¿Imanirtag gamcuna aywarärimunqui espädawan, gueruwan, juc suwaman yupaysi? ");
INSERT INTO qvnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nogaga lapan junagtag gamcunawanga Diospa wayinchru carä chaychru manatag ni tupaylas tupapäcamaraychu. Cananga nä üraycunachr ayparamun Asyag munanganta rurapäcunaypag” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chauraga Jesusta nä charirärirga, aywachipäcura sacerdöticuna mandagpa wayinmanmi, nätan Pedroga carulapam gatirara. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chay wayipa puncun pampachrümi yantata golpurcur muyurigpa tayarärira. Chaychrümi Pedrosi paycunawan tayayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaura chay wayiyogpa rantishan warmim nina lädunchru Pedro tayayagta ricapururga, rircarayanganpita cay nirun: “¡Ä! ¡Cay runasi cayara Jesuswanmi!” ");
INSERT INTO qvnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Niptinmi Pedroga nin: “Warmi, manam Jesusta reguëchu” nin. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Unaylantam jucsi Pedrota ricapururga nirun: “¡Gamsi paycuna castam cayanqui!” Niptinmi Pedroga “¡Manam nogaga pay castachu cä tayta!” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chaypitam nä juc üratanuyga, jucsi cay niruntag: “Ä, razonpam cay runas paywan purira. Caysi Galilea runam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Niptinmi Pedroga “Runa, manam musyächu imapitachr rimacunquisi” nin. Chaynuy rimayaptilanmi juc gallo wagaramura. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chaura Jesusga muyurcurmi Pedrota rircarirura. Chaylam Pedroga yarpachracurura Jesús cay ninganta: “Manaragsi gallo wagangancamam quima cuti ‘Manam reguegchu’ ninqui nogapag” ninganta. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chaypita Pedroga washata yargarcamurmi alisca wagacura. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nätan chaychru täpag soldäducunam Jesusta turyapäcura, jinaman magapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jinaman ñawinta chapayurmi cäranchru lagyarcur “¿Pitagshi lagyarushunqui? Diospa-mayin carga mä niy pi lagyashungaytas” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jinamanmi ashlipäcura tucuyta imatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chaypitam nä pacha wararamuptinga gotucarärira Israel castachru alinninpag ricasha chacha runacunawan sacerdöticunapa mandagnincuna, jinaman Moisés isquirbinganpita yachrachigcuna. Jinarcurmi Jesusta aywachipäcura marcachru mandagcunaman. Nä chrarärichiptinmi, tapupäcura cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nipäcamay, ¿gamchu cayanqui ‘Salvacugtam cachramushag’ Dios ningan?” Nipäcuptinmi Jesusga nira: “ ‘Au, chay quiquinmi cayä’ niptïsi, ‘Manam razonchri’ nipäcamanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ni manatan noga imata tapucuptïsi contestapäcamanquipishchu. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nätan cananpitam noga jana pachapita shamusha runaga tayucushag Munayniyog Diospa derëcha lädunman”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Niptinga lapansi tapupäcura cay nirmi: “Chauraga ¿cayanqui Diospa-mayinchu?” Nipäcuptinmi Jesusga nira: “Au, gamcuna nipäcamangaynuymi cayä”. ");
INSERT INTO qvnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chaura paycunaga cay nipäcuram: “Pi maysi Jesuspita ima nimänanchitas cananga manam munanchichu. Quiquinchim cananga nä mayarunchi rimanganta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chauraga lapansi sharcurcur, Jesusta aywachipäcura mandag Pilatomanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chaura Pilatopa naupanchrümi juchachayta galacayärin cay nir: “Cay runatam tarirärï runanchicunata lutanta cay nir yachrayächigta: ‘Ama pägapäcuychu patentita Romachru mandagtaga’. Nätan ‘Munayniyog Cristom cayä’ ninran cansi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nipäcuptinmi Pilatoga tapura: “¿Gamchu Israel castacunapa reynin cayanqui?” Niptinmi Jesusga nira: “Au. Gam nimangaynuymi cayä”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chaura Pilatoga nira Diospa wayinchru mandagcunatawan waquin runacunatam: “Manam ima juchantas tarïchu cay runapataga” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nätan paycunaga yapay yapaysi gaparaypam nipäcura: “Judeachru lapan runacunatam yachrayächin lutanta rurapäcunanpag. Galayamura Galileapitam, cananga nä caychrümi yachrayächin” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chay nipäcugta Pilato mayarurmi tapura: “¿Cay runaga Galilea runachu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chay runacuna “Au” niräriptinga, pusharachira Galileachru mandag Herodesmanmi. Paysi chay junagcunaga cayara Jerusalenchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Chaura Herodes Jesusta ricapururga, aliscam cushicurura unaypita regueyta munar. Nätan paypita achca cutim ima rurangantas mayacura, “Chaymi ricayaptï imalatas rurayunmanga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaura achca cutim Herodesga tucuynaypa tapura. Chaynuy tapuyaptinsi Jesusga upälalam cacura. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chaychru carcayaratan sacerdöticunapa mandagnincunawan, Moisés isquirbinganpita yachrachigcunas, pasay chaynuyla juchacharcayar. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chaura Herodesga, jinaman soldäduncunawanmi Jesusta manacagpag ricapäcur asipapäcunanpag jacuräripura alisca shumag jacuta, reypa jacun nirayagta. Chaypitaga cutirachira Pilatomanmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay junagga Pilatowan Herodesga alipam rimapänacarärira. Nätan chaycamaga chregnipänacurcaram. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chaura Pilatoga gayachira sacerdöticunapa mandagnincunatawan, marcachru mandagcunatam, jinaman waquin runacunatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chaypitam cay nira: “Gamcuna cay runata nogaman aywachipäcamuray. ‘Runacunatam lutanta yachrayächin’ nirmi. Nätan nogaga naupaycunachru tapur manam ima juchantas tarirächu gamcuna juchacharcayangaynuyga. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Manam ni Herodessi juchanta tarishachu. Chaymi cayman cutirachimun. Ricapäcungaynuysi manam cay runaga imatas rurashachu wanuchisha cananpagga. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Astiyla astircachishag, jinarcur cachrarirushag” niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nätan Pilatoga chay fiesta wichan juc runatam carcelpita cachrarichrag cara. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chaura runacunaga lapansi gaparapäcura: “¡Manam chay Jesusta cachrarinayta munapäcüchu! ¡Antis Barrabasta cachrariparcämayga!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chay Barrabasta jitayapäcusha cara carcelman marcachru runacunata lutanta rurapäcunanpag sucsutanganpitam, nätan runata wanuchinganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nätan Pilatoga Jesús cachrariyta munar, yapaymi runacunata rimapara. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Jinaman paycunaga lapan calpanpam gaparapäcura: “¡Cruzchru wanuchun! ¡Cruzchru wanuchun!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nätan Pilatoga nä quimapaypam runacunata nira: “¿Imatamar lutantaga rurarayan? Nogaga manam tarïchu ima juchan cangantas wanuchisha cananpagga. Astiyla astircachishag, jinarcur cachrarirushag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pilato chaynuy niyaptinsi paycunaga chaynuylam gaparapäcura, cruzchru wanunanpag. Chaynuy gaparayälarmi munarcayanganta tarirärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chaura Pilatoga “Gamcuna nipäcamangannuy ruracächun” niram. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chaura cachrarirura carcelchru cayag runa wanuchig Barrabastam manacurcangannuy. Nätan Jesustam paycunata gorura munanganta rurapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusta wanuchipäcunanpag nä aywarcayächiptinmi, aywayämunag pampapita juc runa Simón jutiyog. Payga cara Cirene marcapitam. Paytam charircur cruzta apachipäcura Jesuspa guepanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Chaytam gatirapäcura chranin runacuna. Nätan waquin warmicunam Jesuspita alisca wagapäcura, jinaman laquicurcara. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jinaman Jesusga chay warmicunatam rircärir cay nira: “Jerusalén warmicuna, ama nogapita wagapäcuychu, antis wagapäcuyga quiquiquicunapita nätan wawaycunapita. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chrämungam cay nipäcunan junagcuna: ‘Imaläninrag mana wachray yachragcuna, mana chrichruy yachragcuna, wamrata mana chuchugcuna’. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chaychrümi ichaga runacuna alisca cunchur jircacunata cay nipäcungaga: ‘Nitipäcamay’. Jinaman lömacunatas nipäcunga: ‘Chapapäcamay wanupäcunäpag’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nätan juc verdi montinuysi cayagta caynuy rurarcayämarga, ima rurasharag capäcunga chaqui montinuysi cayag runacunaga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesustawan aywachipäcuratan runa wanuchigcunatas ishcayta wanuchipäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chaura ‘Uman tullu gotu’ nipäcunganman chrarärichirga Jesusta cruzmanmi clävarärira chay runa wanuchigcunatawan, jucnintam derëchanman, jucninta ichogninman. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nä cruzman clävaräriptin Jesusga Dios Taytantam cay nira: “Tayta, cay runacunatar juchancunapita perdonayuy. Manam musyapäcunchu pita rurarcayangantas” nira. Chaypitam soldäducunaga Jesuspa jacunta chüsarcur aypunacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nätan runacunam chaychru rircararcayara ima-aygatas rurapäcunganta. Jinamanmi Jesusta marca mandagcuna asipapäcura cay nir: “Juctagä salvara. Canangar quiquin salvacuchun razonpa Dios cachramungan salvacug carga” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Chaynuytan soldäducunas asipapäcura, jinaman ashuyurmi vinagrita upyachiyta munapäcura, ");
INSERT INTO qvnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cay niyar: “Gam Israel castacunapa reynin carga, quiquiqui salvacuy”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nätan caratan uman patanchru quima rimaychru, isquirbishas. Chay cara griegochrümi, latinchrümi, jinaman hebreochrümi. Chayga cara: “CAYMI CAYAN ISRAEL CASTACUNAPA REYNIN” nir isquirbisham. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chaynuytan chay runa wanuchigcunapita jucnincag cruzchru clävarayagsi Jesusta ashliparatag cay nir: “Razonpa Cristo carga, mänar quiquiqui salvacuy, jinaman nogacunatas salvapäcamay” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chaymi cruzchru clävarayag chay jucnincagga piñapara cay nir: “¿Manachu manchacunqui Diosta, paysi noganchinuysi cunchuyaptin? ");
INSERT INTO qvnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noganchiga cagpitam cunchuyanchi lutan ruranganchicunapita, nätan cay runaga manam ima lutantas rurashachu”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nircurga Jesustam nira: “Tayta, mandayta galayur nogapita yarparcunquimar”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Niptinmi Jesusga nira: “Razonpam niyag: Pasay-pacham nogawan canqui Dios cayanganchru”. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nä chraupi junagnuy cayaptinmi pacha yanauyarura. Chaynuy yanauyashala cara quima üranuyran, ");
INSERT INTO qvnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","intis pasaymi yanauyarura. Chaylam Diospa wayin ruyichru racta telonsi lachirura chraupipa. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chaura Jesusga lapan calpanpam nira: “Tayta, chrasquiynar almäta” nira. Chay nircularmi wanurura. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nätan soldäducuna mandag Roma runaga, chaynuypa Jesús wanugta ricapururga Diostam alawara. Jinarcurmi “Cay runaga razonpa mana juchaynagmi cara” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jinaman chaychru carcayag lapan runacunas Jesusta chaynuypa wanugta ricarärirga, aywacurcara pëchunta cutacurcayarmi laquicuypita. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nätan Jesuspa lapan reguenacuynincunawan Galileapita shamug warmicunaga, rircarapäcura carulapitam lapan imas pasagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nätan chaychrümi cayara José jutiyog runas. Pay cara ali runam, jinaman alita ruragmi. Payga cara Judeachru cayag Arimatea marcapitam, jinaman Israel castacunachru mandagcuna castam. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Josësi shuyayara Diospa munayninchru cawaytam. Chaymi payga mana munarachu mandag-mayincuna Jesusta wanuchipäcunanta. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chaypitam payga Pilatoman aywarcur “Noga Jesusta enterramushag” nirura. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chaura “Äri” niruptinga cruzpita jorgarcamurmi, wancurura juc yurag sagpiwan. Chaypitam chrurarura gagachru uchrcusha mushog mïchuman. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chay junag camachracurcara jamana junagpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Jesuswan shamug warmicunas aywapäcuram. Chaychrümi ricapäcura imaynuypa Jesusta chrurapäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nä cutirärimurga camaripäcura perfümicunatam Jesusta lushipäcunanpag. Jinacarcärirga jamana junagchru jamapäcura Dios ningannuylam. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chaypitam jamana junag warantin warmicunaga cutipäcura achic achicla Jesuspa mïchunman shumag asyag jampi camaripäcunganta apacurcur. Paycunawan aywapäcuram juc warmicunas. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nä chrarärirga, Jesuspa mïchun chapag rumita tarirärira jucläman ashushatam. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chaura ricag yaycarärirga manam taripäcushachu wanusha Jesusta. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chaychru mana taricarcärir manchacasha carcayaptilanmi, paycunacagchru ricacarärira ishcay olgocuna alisca shumag chipchipyar jacushacama. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chaura paycunaga manchacarur pampaman umancunas tupangancama lipucayäriptinga, chay olgocunaga cay nipäcuram: “¿Imanirtag cawayag Jesusta ashircayanqui wanushacuna cacunanchrüga? ");
INSERT INTO qvnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¡Manam payga caychru canchu! Nämi cawacämusha. Yarpachracurcay Galileachru cayar, cay nipäcushungayta: ");
INSERT INTO qvnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Noga jana pachapita shamusha runaga cashag juchasapacunapa maquinchrüran, jinaman cruzchru wanuchisharan, nätan quima junagtaga cawacämushagmi’ ninganta”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nipäcuptin paycunaga Jesús rimanganta yarpachracaräriram. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jinarcurmi mïchucagpita cutirärirga, ima-aygatas lapanta willapacurcara, chaychru carcayag lapan runacunata, chrunca jucniyog discïpuluncunatawan waquin runacunatas. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chay willapäcug warmicuna capäcura Magdalapita Mariam, Juanam, Jacobopa maman Mariam, jinaman chay aywag warmicunam. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chay willapacurcaptin discïpuluncunaga “Yangam, gotara niragsi rimacurcan” nirmi mana chrasquicurcarachu. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedrom ichaga yargorcur aywara päripa pärir Jesuspa mïchuncagta. Chrarcur anayurga, ricapurura Jesusta wancupäcungan sagpi jitarayaglatam. Chauraga chaynuy ricanganpita wayita cutira mayacasha niragmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay junagmi Jesuspa ishcay discïpuluncuna aywapäcura Emaús marcata. Emausga cara Jerusalenpita ishcay lïwa mascascachrüran. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Paycuna aywarcayara lapan imas aygas Jerusalenchru pasanganta rimarcayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chay rimayar jinaman tapunacur aywarcayaptinmi, Jesusga chay aywarcayagman ashuyur paycunawan aywayara. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nätan paycunaga manam shumag rircaripäcushachu piwan aywarcayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chaura Jesusga tapura cay nirmi: “¿Imapita tapunacurcayartag aywarcayanqui?” Nipäcuptinmi paycuna shayarärin laquisha. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chaypitam Cleofas jutiyogga cay nirun: “Lapan runacunam musyarcayan cay junagcuna Jerusalenchru imas pasanganta. Nätan Jerusalenchru lapan gorpachacushacunapita japalay imachr mana musyanquichüga imas pasangantaga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chaura Jesusga niram: “¿Imatag carun?” Niptinga nipäcuram: “Juc runam cara Nazaret marcapita. Payga cara Diospa willacugninmi. Payga alisca munayniyog canganta reguechicura rimanganpam, jinaman runala mana ruray atipänanta ruranganpam. Jinaman chaynuy munayniyogmi cara Diospa naupanchrüsi, jinaman lapan runacunapa naupanchrüsi. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytam sacerdöticunapa mandagnincunawan marcachru mandagninchicunaga nipäcusha cruzchru clävaypa wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nätan paytam noganchi Israel castaga shuyacuyaranchi Romachru runacunapa munayninpita jorgamänanchipag. Payta wanuchipäcungan cayan nä quima junagmi. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nätan cananga nogacunapita juc ishcay warmicunam aywapäcura chacay chacayla Jesuspa mïchuncagta. Paycunam mayacashata dëjaräriman. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Chaychru Jesuspa cuerpunta mana taricarcärirmi, cutiyarärimun Diospita shamusha angelcunam ricäparäriman. Jinarcurmi ‘Jesusga cawayanmi niräriman’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chaynuytan nogacunapitas aywapäcura Jesuspa mïchuncagta juc ishcay runacuna chay mïchu ricag. Nätan paycunas tarirärimun warmicuna nipäcamangannuylam”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chaura Jesusga niram: “Gamcuna capäcunqui mana tantiay atipag runam ni ‘Manam razonchri’ nipäcunquichu, Diospa willacugnincuna lapan rimapäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristoga chaynuymi cunchunan cara jana pachaman yaycunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nircurga galayura tantiachiyta paypita lapan isquirbirayagcunatam, Moisés isquirbingancunapita galayur Diospa willacugnincuna isquirbipäcungancama. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chauraga nä aywarcayangan marcaman chraräriptinga, Jesusga caruta aywayagnuymi pasagtucura. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nätan chay ishcay discïpuluga manam munapäcurachu aywacunanta, antis cay nipäcuram: “Quëdacushun tayta. Nämi pachas chacanayan” nir. Nipäcuptin Jesusga “Äri” nirmi paycunawan quëdarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nä micapäcunanpag mësachru tayarcayaptinmi, tantanta charircur, Diosta “Gracias” nircurga partircur paycunata gora. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chayüram, shumag reguerärin Jesús canganta, nätan payga chayüram illacarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chauraga jucninsi jucninsi ninacurcara: “Chaychri shongonchiga alisca cushirayara camiñupa aywayämur isquirbishacunapita tantiachimashaga” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chauraga chayüram cutipäcura Jerusalenta. Chaychru tarirärira chrunca jucniyog discïpulu-mayincunatam goturarcayagta jinaman mas juccunatam ");
INSERT INTO qvnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","cay nir rimarcayagta: “Razonpam cawacämusha Munayniyogninchi Jesusga. Simontam ricäpasha” nircayagta. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chauraga paycunas willapacurcara camiñuchru aywarcayaptin pasangantam jinaman tantata partiptin, Jesusta reguepäcungantam. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chay nir rimarcayaptilanmi Jesusga paycunapa chraupinchru ricacarura. Chaypitam “Ali caway gamcunachru cachun” nir saludarura. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Niptin paycunaga aliscam manchacarärira “Almatachr ricapuyanchi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nätan Jesusga niram: “¿Imanirtag manchacararcayanqui? ¿Imanirtag ‘Paychur u almachur’ nircayanqui? ");
INSERT INTO qvnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ricapäcuy maquïcunata, chraquïcunata. Nogam cayä. Yatapapäcamay. Rircaripäcamay. Almapaga manam canchu aychansi ni tullunsi nogata ricarcayämangaynuyga”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nirmi ricachira maquintas, chraquintas. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nätan discïpuluncunaga cushirarcayarsi, razonpam Jesusga cawacarayämun mana nipäcuptinmi payga nira: “¿Caychru chararcayanquichu imalatas micunäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Niptinga gopäcura pescädu cancashatam tipircur. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nätan payga charircur paycunapa naupanchrümi micura. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chaypitam Jesusga nira: “Caycuna pasamänantaga cawayälarmi nipäcürag. Chaynuy nogata pasamänanpitaga isquirbirayanmi Moisés isquirbingancunachrüsi, Diospa willacugnincuna isquirbingancunachrüsi, jinaman Salmos libruchrüsi”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chauraga tantiachira isquirbishacunatam ");
INSERT INTO qvnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","cay nir: “Isquirbisham cayan Cristo wanurcur quima junagta cawacämunanpita. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jinaman Jerusalenpita galayur lapan nacionchru: ‘Jucha ruraypita wanacurcur, Diosman cutipäcamuy perdonasha capäcunaypag’ nir willapacurcänaypitas. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nätan gamcunam lapan caycunata ricarcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chaura nogaga gamcunaman cachramushag Tayta Dios ‘Santu Espiritutam cachramushag’ ningantam. Chauraga cay Jerusalén marcachru cacurcayay jana pachapita shamug Santu Espirituta chrasquipäcungaycama”. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jinarcurmi Jesusga discïpuluncunata pusharura Jerusalenpita Betaniacama. Jinarcurmi maquinta wichanman chacchacurcur “Dios yanapapäcushunqui” nira. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chay manacuruptilanmi paycunacagpita jegayta galacuyura jana pachata. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chaypitam paycuna gongorpacuyur Jesusta alawarcur cuticarcämura Jerusalenta alisca cushisha. ");
INSERT INTO qvnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nätan chaynuylam waran waransi aywapäcug Diospa wayinta jinarcurmi Diosta alawapäcug. Chaynuymi cara.");
INSERT INTO qvnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mana imas camacaptilanmi payga nä cayara. Payga cara Dioswanmi. Nätan Payga cara Diosmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ima-aygas mana camacaptilanmi, payga nä cayara Tayta Dioswan. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lapan ima-aygatas rurara paymi. Nätan mana pay ruraptinga manam imas ruracanmanchu cara. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Paymi cara cawachicug. Nätan chay cawachicugmi runacunapag cara juc achquinuysi Tayta Diospita shumag musyachimagninchi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chay achquinuysi cayagmi tantiayächin yanauyagchrünuysi juchachru cawarcayagcunata, nätan chaytam chay juchäcuyagcuna mana chrasquicurcashachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chauraga cara juc runa Juan jutiyog, Tayta Diospa cachran rurag. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Payga cara chay achicyagnuysi cayagpita razoncagta willamagninchim, pay rimanganta lapan chrasquicurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanga manam chay achquinuysi cayagchu cara, antis payga cara chay achquinuysi cayagpita musyachimaglanchim. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nätan lapan runacunata chay achquinuysi razoncagta tantiachicugga nämi reguechicugpag cayara cay pachachru. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Payga nämi cayara runacunawan, nätan runacunata pay rurarayaptinsi, chay runacunaga manam reguepäcushachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Payga aywamura Israel castancunamanmi. Jinarcurmi paycunaga mana pasay chrasquiyta munapäcushachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nätan payta chrasquicurcur yupachicugcunataga lapantas “Cananpita gamcunaga nä carcayanqui Diospa castanmi” niruram. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nätan paycunaga Diospa castanman muyupäcusha manam runapita näcimuypachu, manam quiquin cayta munarchu. Manatan ni pi runas munaptinpishchu, antis Dios munaptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nätan payga muyurura runamanmi. Jinarcurmi yachrara noganchicunacagchru. Nogacuna ricapäcurä shumagmi Tayta Diospa-mayin chay japalan Diosta, jinaman munayninwan ima-ayga ruragtas. Payga cara alisca cuyapälar yanapäcugmi, jinaman razoncaglata rimagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypitam chay Bautizag Juanga gayacuypanuy rimara cay nir: “Guepäta aywamugga mas munayniyogmi cayan. Nätan payga mas unaypitam cayara nogapitaga” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chaura alisca cuyapäcug pay captinmi, Juan ningannuysi cananga nä lapanchis chaynuyla chrasquiyanchi chay lapan yanapayninta. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chaypitaga Moisespis isquirbiram. Chaura chay yanapämagninchiga, jinaman razoncagta willamagninchiga casha Jesucristom. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manam pisi ricapurachu imaysi Diostaga. Chay Tayta Dioswan cayag japalan Dios-mayilanmi, paypitaga musyachimasha canchi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Chaura Diospa wayinchru mandagcunam Jerusalenpita cachrarärimunag Israel casta sacerdöticunatawan yanapagnin Leví casta runacunata Juanman “¿Gamchu cayanqui chay shuyacurcayangä Diospa acrashan?” nir tapug. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chaura Juanga razoncagtam nirun caynuypa: “Manam. Imanaypatag Cristoga cashag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Niptinga yapaymi tapurärin: “¿Chauraga cayanqui maygantag Diospa unay willacugnin Eliaschu?” Nipäcuptin Juanga: “Manam paychu cä” nirun. Chaynuypa niptinga yapaytan tapurärin: “¿Chaura cayanqui Diospa willacugnin chay shuyacurcayangächu?” Nipäcuptin Bautizag Juanga “Manam” nira. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chauraga “¿Mayganmar cayanqui? Rimacuy, cachramagnïcunata willapäcunäpag. ¿‘Mayganmi cayä’ ninquitag?” ");
INSERT INTO qvnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nipäcuptinmi Juanga cay nin: “Noga cayä jäpag pampachru gayachracuypanuy rimamugmi ‘Camacurcay Munayniyog Diospa-mayin chrämunanpag’ ninganmi, Diospa unay willacugnin Isaiasga nogapitam chaynuy rimara” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nätan chay cachrashacunachru fariseo castacunaga ");
INSERT INTO qvnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tapurärin cay nirmi: “Mana Cristo cayarga, mana Elías cayarga, nätan Diospa chay willacugninta ‘Shuyacurcayangä’ mana cayarga, chauraga ¿imanirtag bautizayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nipäcuptinmi Juanga nin: “Nogaga bautizayä yaculawanmi. Payga nä cay runacunachrümi cayan. Paytaga manam reguepäcunquiragchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Payga nä aywayämun guepätam. Payga mas munayniyogmi cayan nogapitaga. Paypagga sandaliata pasquipunalapagsi manacagnin runam cä” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chaynuypa Juanga nira Jordán mayu wacläcag chimpan Betaniachru, runacunata bautizayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chaura warantin Bautizag Juanga ricapurun Jesustam payman aywayämugta. Jinarcurmi cay nin: “Rircäripäcuy, paymi cayan juchacunapita wanug achrcashnuysi. Paytam Dios cachrarayämun lapan runacunapa juchanpita wanunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nogaga paypitam nipäcurag: Guepätam aywayämun juc runa, nogapita mas munayniyog. ‘Payga unaylapitam nä cayara’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Manam nogas musyararagchu salvacug pay cangantaga. Nätan nogaga runacunata bautizayarä Israel runacunata pay salvacug canganta reguechinäpagmi nipäcaman”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nircursi Juanga cay nirmi willaparäriman: “Noga ricapurämi Santu Espíritu jana pachapita juc palömanuy uranparcamur payman chragta. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Chaycamaga manam musyararagchu salvacug pay canganta, runacunata bautizänäpag cachramag Diosga, nämi cay nimasha cara: ‘Santu Espíritu uranparcamur pimansi chragta ricapungay runam, Santu Espirituwan yanapapäcushunqui nogapa runäman muyuyta’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chaura nogaga ñawiwanmi ricarä payta, nätan musyayä shumagmi pay Diospa-mayin canganta niräriman”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chaura mas warantinchrüsi chaychru yapaytan carcayarä, nätan Andreswan, jinaman Bautizag Juanwan. Andreswan nogaga capäcurä Bautizag Juanpa discïpulunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jinarcurmi Jesús chaypa puriyagta ricapurur Bautizag Juanga cay nipäcaman: “Rircaripäcuy. Wacmi cayan juchanchipita wanug achrcashnuysi wanunanpag Dios cachramungan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Niptinga Andreswan nogaga aywacurcä Jesuspa guepantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chaypitam guepan aywayagta ricaparärimarga muyurcamur cay nipäcaman: “¿Imatatag munarcayanqui?” Niptinga “Yachrachig, ¿maychrümi yachrayanqui?” nipäcümi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chaura Jesusga “Shamuy ricag” nipäcaman. Jinarcurmi aywarga ricapäcamurä maychru yachragtas. Chay junagga quëdarärirä paywan, ishcay ürala chacananpag faltaptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chay aywag-mayï Andresga cara Simonpa wauguenmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chaura Andresga pasaymi aywacun wauguen Simonman. Chaypitam Simontaga willapacusha cay nir: “ ‘Salvacugtam cachramushag’ Dios ningantam tarirärimü” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chauraga chrarachimun Jesuscagmanmi. Jinarcurmi ricapururga Jesús cay nirun: “Gamga cayanqui Jonaspa churin Simonmi. Nätan cananpitaga Cefaspam gayapäcushunqui” nirun. (‘Cefas’ ninanga ‘Pedro’ ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chaypitam mas warantin Jesusga “Galilea ninganpa aywashag” niyarmi, tincurun Felipewan. Chaypitam paytaga “Nogawan uryashun” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipega cara Betsaida marcapitam. Nätan chay marcapitam capäcura Andreswan Pedrosi. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chaura Felipes aywacun Natanaelmantan. Chaypitam paytaga cay nisha: “Moisespa isquirbishanchru, jinaman Diospa willacugnincuna isquirbishanchru ningannuy runawanmi tincurärï. Payga canag Nazaret marcapita Josëpa churinmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Niptin Natanaelga cay ninshi: “¡Nazaretpita yargamunmanchur chaynuy ali!” Niptin Felipega “Shamuy ricag” nisha. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chaura Natanael nä yaycayämuptinmi Jesusga cay nin: “Wacmi icha cayanga razoncag Israel castaga. Payga manam casqui rimayta yachranchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Niptin Natanaelga “¿Imanaypatag regueyämanqui?” nin. Chaura Jesusga “Manaragsi Felipe gayashuptilaymi noga reguerag, yürasapa hïgos monti chraquinchru mana ricacayla cayaptiqui” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Niptin Natanaelga cay nin: “Tayta yachrachig, gamga cayanqui Diospa-mayinmi, jinaman cayanqui Israel runacuna shuyacurcayangä reymi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Niptin Jesusga “¿Hïgos monti chraquinchrümi reguerag niptilächu ‘Payga razonpa Diospa-mayinmi’ nir, yupachicayämanqui? Cay ningagpitaga mastam ima-aygatas ricanqui mas guepamanga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nircurmi cay nipäcaman: “Mayapäcamay shumag: Cananpita ricapäcunqui noga jana pachapita shamusha runapita, angelnincuna jegapäcugtam, jinaman nogaman uranpapäcamugtam” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chaypitam nä quima junag cayaptin, juc runa casarara Canä nipäcungä marcachru. Chay marcaga cara Galileachrümi. Chaychrümi cayara Jesuspa mamansi. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chaura Jesuswanmi discïpuluncunas aywapäcurä chay casarag gayachipäcamaptin. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jinarcurmi vïnu pishiruptinga, mamanga Jesusta cay nin: “Vïnum nä mana canchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Niptin Jesusga “Mama, ¿imanirtag nogata niyämanqui? Manaran ürä chrämunragchu lapanwan reguechicunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niruptin mamanga chay vïnu chragachracugcunatam nirun: “Ima-aygatas rurapäcunquim pay nipäcushuptiquiga” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chauraga chaychru cayara sogta botijacunam rumipita. Chaycunata Israel castäcuna charapäcug yacupagmi “Diospag ali canäpag” nir, chagchucurcänanpag. Chay botijacuna cara pachrac litrunuy yacu yaycugcamam. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chaypitam Jesusga chay chragachracugcunata “Yacuta wiñapäcuy cay botijacunaman”. Niptinga wiñarärin juntatacama. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chaura Jesusga cay ninmi: “Cananga jorgorcur, apapäcuy cay fiestachru atendig runaman”. Niptinga ningannuylam rurarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jinarcurmi atendig runaga chay yacupita vïnuman muyushataga malirun. Payga manam musyarachu maypita jorgapäcamungantas. Musyaraga chragachracugcunalam yacu wiñapäcunganta. Chaura chay atendig runaga, casarayag olgota gayarcurmi cay nin: ");
INSERT INTO qvnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Pi maysi alinnin vïnutam jorgamun naupataga. Nä alisca upyaräriptinran jorgamun jucläyacunataga. Nätan gamga alinnincagta chrurasha canqui mas guepapagtan” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chay Canä marcachrümi Jesús chayta rurara munayninwan. Chaynuypam wamagta reguechicura pi cangantas. Nätan discïpuluncunaga paylaman mas yupachicuytam galacayarärirä. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chayta ruracurcur, Jesusga uranpara mamanwan, wauguencunawan, nätan nogacuna discïpuluncunawan Capernaum marcatam. Chaychru capäcurä ishcay quima junaglam. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nä Pascua nipäcungä fiestäcuna nachrgayämuptinmi Jesús aywara Jerusalén marcata nogacuna discïpuluncunawan. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jinarcurmi Jesusga Diospa wayincag sawan ruyichru tarirun chay juc casta runacuna gotucarcänan cagchru chay golgue trucagcunata, mësayogcama tayäcurcayagta, jinaman törucuna, uyshacuna, palömacuna ranticurcayag runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaynuyta ricarur Jesusga, juc asticunata rurarcurmi chaywan gargaramun washaman lapanta, uyshantintawan töruntinta. Nätan golgue trucagcunapatam golguencunata wichircapur mësancunata ticpay usharun. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Palöma ranticugcunatam nätan cay nin: “Jucla caycunata jorgapäcuy caypita. Ama Tayta Diospa wayinta muyuchipäcuychu ima-aygas ranticuna wayiman” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chaynuy ruraruptin discïpuluncunaga yarparärï isquirbishanchru cay ningantam: “Wayiqui gamlapag canan raygoga ima-aygatas rurashagmi” ningantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chaura Diospa wayinchru mandagcunaga alisca piñasham “¿Pi nishuptiquitag gargochracurunqui? Nä cayta rurayarga, mä munayniquiwan ruray imalatas pi cangantas musyapäcunaypag” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nipäcuptinga Jesús nira: “Juchruchipäcuy Diospa cay wayinta, nätan quima junagtaga sharcachishagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Niptin chay Israel casta mandacunaga nipäcura: “Chruscu chrunca sogtayog watatam cay wayiga sharcurayan. Gamga nätan ¿quima junagtam sharcarachiman ninquichu?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nätan Jesús Diospa wayinpita rimanganga cara quiquinpa cuerpunpitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaymi wanushapita nä Jesús cawacaramuptinga discïpuluncunaga yarparärï chay cuerpunpita rimanganta. Chayran tantiapäcusha cä paypita isquirbishanuyla, nätan rimangannuyla ruracanganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Chay Pascua fiesta wichan Jesús Jerusalenchru cayaptin, achcam runacuna ima-aygatas munayninwan ruragta ricapäcur “Cay runaga razonpa Diospitam” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nätan Jesusga manam yupachicurachu paycunaman, lapalanpa shongoncunata musyar. ");
INSERT INTO qvnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Manam payga munan maygansi willanantaragchu runacunapita. Payga quiquinmi musyara runacunachru ima-aygacagtas. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Chauraga cara fariseo nipäcungan casta runam. Payga cara Israel castäcunapita, alisca alinninpag ricasha runam aliscannin yachrag runam, Nicodemo jutiyog. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi Jesusman pagaspa chrarur cay nin: “Yachrachig, musyarcayämi yachrachinaypag cayman Dios cachramushungayta, manam pisi ima-aygatas ruranmanchu gam rurayangaynuyga. Caycunataga ruranman pisi Dios yanapaptilanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Niptin Jesusga nirun: “Mayamay shumag: Pisi mana yapay näcigga manam Dioswan cawangachu imaysi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niptin Nicodemoga nisha: “¿Imanaypatag runaga nä chacha cayar yapay näcimunga? Manam pisi mamanpa pachranman yaycunmanchu yapay näcimunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Niptin Jesusga cay nin: “Mayamay shumag: Mana yacupitawan Espiritupita näcigga, manam Diospa munayninman yaycungachu imaysi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pi maysi runapita näcimugga runalam. Nätan Espiritupita näcimugga nä Diospa castanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama cay ningagpita mayacasha nirag caychu. Pi maysi näcipäcungaga yapayran. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tantiachishay caynuypa: Maypitas chaypitas walyamuptin, wagariglatam mayanchi. Nätan manam musyayanchichu maypita aywamungantas ni mayta aywayangantas. Chaynuymi mana ricapunchichu imanuypa runata chay Espíritu Diospa runanman muyuchingantas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niptin Nicodemoga cay ninmi: “¿Imanaypatag chaura chayga ruracan?” ");
INSERT INTO qvnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Niptin Jesusga nin: “Gamga cayanqui Israelchrüga aliscannin yachrachigtag. Nätan ¿manachu cay ningagta tantianqui? ");
INSERT INTO qvnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mayamay shumag: Nogacunaga rimapäcü musyapäcungätam, ñawicunawan ricapäcungätam, nätan gamcunaga manam chrasquicurcanquichu nipäcungagta. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chaura cay pachachru cagcunapita rimayaptïsi, ‘Mana razonchri’ nircayarga manam gamcunaga razonchri nipäcunquichu jana pachachru cagcunapita rimapaptïsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nätan manam pisi jegashachu jana pachaman, chaychru cagcunapita willapäcushunaypag, antis aywarayämü chaypitaga, noga jana pachapita shamusha runalam. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moiseschu unay wac jäpag pampachru culebra rurashata gueruman chrurayur shayachira, chaynuyran noga jana pachapita shamusha runasi gueruman chrurasha cashag. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chaynuypa pi maysi razonpa chrasquimagcuna, Dioswan imaycamas ali cawapäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chaura Tayta Diosga alisca cuyacugla carmi, cuyasha cay pachachru lapan runata. Chaymi cachramusha chay japalaylan Dios-mayinta lapan pi maysi “Payga razonpa Diospitam shamusha” nir, yupachicugcuna mana juchalanchru wanupäcunanpag, antis Dioswan imaycamas cawapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diosga cay pachaman cachramusha Dios-mayinta manam “Cay runacuna juchanpita cunchuchun” ninanpagchu, antis lapan runata pay salvananpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Payga razonpa Diospitam” nir, pisi chrasquicugga, “Manam nä cunchunquichu” nisham cayan. Nätan pisi mana chrasquicugga cunchunanpag nä nisham cayan, Diospa chay japalan-mayinta, mana chrasquicunganpita. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Imaycamas cunchunanpag nä nichicarärin juc achquinuysi Tayta Diospita shamushata mana chrasquicurcarmi. Antis juchäcuyälar cawacuylata munar ima-aygatas lutanlata cushisha rurapäcunganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pi maysi lutanlata ruragga chregninmi chay achquinuysi shamushata. Nätan manam ni ashuyärimunpishchu paymanga chay lutan rurarcayanganta ninanpita. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nätan pi maysi Dios ningannuy cawagga ashuyapäcun chay achquinuysi shamushamanmi Diospa yanapayninwan ima rurarcayangantas musyapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaypitam Jesusga aywara nogacuna discïpuluncunawan Jordán mayucama Judea nipäcungächru. Chaychru capäcurä Jesuswan bautizarcayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chaypinga Juansi bautizayara mas janapam, Salemman nachrgana Enón mayuchrümi chaychru yacu achca captin. Chaymanmi runacuna aywapäcug bautizächicug. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chaypinga Juanta manaran carcelman jitayapäcusharagchu cara. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chaura Juanpa ishcay quima discïpuluncunash, juc Israel casta runawan galayapäcusha tapunacuyta yacuwan maylacular Diospag nä ali capäcunanpita. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jinarcurmi paycunaga aywapäcusha Bautizag Juanman. Chrarärirga cay nipäcusha: “Yachrachig, cay Jordán mayupa waclacag chimpachru capäcungay runam. ‘Payga munayniyog’ ningaymi cananga bautizayänag. Jinarcurmi lapan runacuna aywarcayan payman”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nipäcuptinmi Juanga cay nin: “Pi maysi imatas rurayanga Dios munaptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamcunaga shumagmi musyarcayanqui cay ningäta: ‘Nogaga manam cä Cristochu, antis paypa naupanta chay aywamug willacuglanmi cayä’ nipäcungagta. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Juc casamintuchrüga chay casarag warmiga gowanpam. Nätan chay gowan rimaptinga lädunchru cayag fiadorninga aliscam cushicun. Chay fiadornuy carmi cananga nogasi cushirayä alisca paypita mayacur. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cananga paytaran ricapäcunga mas alinninpag, nätan nogatam ricapäcamanga mas manacagpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nircurga “Jana pachapita aywamugga mas munayniyogmi cay pachachru pi may runapitas. Caylapita aywamugga runalam, jinaman rimansi cay pachachru cagcunalapitam, nätan jana pachapita aywamugga cayan pi may runapitas mas munayniyogmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Payga riman ricangantam, mayangantam, nätan manam pisi chrasquicunchu rimapayaptinsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nätan maygansi pay ninganta chrasquicugga riman, razonpa Dios rimangantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chaura Dios cachramunganga riman Dios rimangantam, Santu Espíritu payta chaynuyla yanapaptin. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tayta Diosga cuyanmi chay Dios-mayinta, nätan paypa munayninmanmi chrurasha lapan ima-aygatas. ");
INSERT INTO qvnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chay Dios-mayinta razonpa chrasquicugga nä galayurun Dioswan imaycamas cawaytam. Nätan chay Diospa-mayinta mana cäsucugga manam cangachu chay ali cawaychru, antis nämi Diosga piñarayan chay runapag” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jinarcurmi fariseocunaga musyarärira Juanpita, mas achcata Jesús bautizayanganta, jinaman mas achca runa gatirarcayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Manam Jesusga bautizarachu, antis nogacuna discïpuluncunalam bautizapäcurä. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nätan Jesús chayta musyarurga nogacunawanmi yargora chay Judeachru cayanganpita Galileaman cutinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chay cutir, pasapäcunä cara Samaria marca ninganpam. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chaura aywarcayangächrümi chrarärï Sicar ningan marcaman, churin Josëta Jacob gongan pampa tincugman. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chaychrümi cara Jacobpa yacu pözun rurasha. Chaura Jesús ushacasha aywayarga, pözu manyanmanmi tayurun. Chayüra nämi nachrgayara chraupi junagman. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chaura discïpuluncunaga aywapäcurä micuy rantig Samaria marcatam. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Chaycamam juc warmiga chrarunag yacu wishicug. Chaytam Jesusga “Yaculay mama” nisha. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Niptin chay Samaria warmiga “¿Imanirtag Israel casta cayar, gamga yacuta manacayämanqui noga Samaria warmita? Manatag Israel casta runawan Samaria runacunaga rimapanacunchichu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Niptin Jesusga nisha: “Dios cuyapälar goshunayta tantiarga, nätan yacuta pi manacuyäshungaytas musyarga, gam manacamaptiqui, noga gorugman cawachicug yacutam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Niptin warmiga ninag: “Tayta, manatag charanquichu imatas yacuta jorgamunaypag, nätan yacuga cayan ruyichrüragtag. Chauraga ¿maypitatag gamga gomanqui chay cawachicug yacutaga? ");
INSERT INTO qvnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Gamga cayanqui awillücuna Jacobpita mas munayniyogchu imatag? Paymi gopäcamasha cay pözutaga, quiquinsi churincunas uywancunas upyacunanta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Niptin Jesusga cay ninag: “Cay yaculata upyagtaga pitas maytas yapaymi yacunanga. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nätan noga gongä cawachicug yacu upyagtaga, manam imaysi yacunangachu. Antis cawachicug yacuta noga gongäga runachru canga, juc pucyupita chaynuyla yacu yargayämugnuymi imaycamas cawag cananpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niptin warmiga ninag: “Tayta, gomay chay yacuta mana imaysi yacunämänanpag, nätan yacu jorgog mana cay pözuman imaysi aywamunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Niptin Jesusga “Ayway, gowayta gayamuy, jinarcur cutimuy”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Niptin warmiga cay nisha: “Manam canchu gowä”. Chaura Jesusga ninag: “ ‘Manam gowä canchu’ nirga, alitam nirunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gampaga goway cara pichgam, nätan canan cayächingaysi manam gowaychu. Chaynuy nirga razoncagtam niramanqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Niptin warmiga ninag: “Tayta, gamga cayanqui Diospa willacugninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Awillücunaga Diosta alawapäcug cay gotuchrümi. Nätan gamcuna castaga ‘Jerusalenchrümi Diosta alawachwan’ nipäcunquitan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Niptin Jesusga cay ninag: “Mamala, razonchri nï cay rimayangäta: Nämi pasay ayparayämun mana cay gotumansi u Jerusalenmansi aywalar Tayta Diosta alawapäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samariapitacagga mana reguepäcungaytam alawarcayanqui, nätan nogacunaga musyarcayämi pita alawarcayangätas. Jinamanga salvacugsi aywayämun Israel casta runapitatan. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nämi chay junag chraramun. Nätan chay junagchrümi nä cayanqui Tayta Diosta razonpa alawagcuna, lapan shongonpa alawapäcunan junagchrümi. Nätan Taytanchisi munayanga chaynuy alawapäcunantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosga Espiritum, nätan payta alawagcunaga razonpa alawapäcunman lapan shongonpam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Niptin warmiga cay ninag: “Musyayämi ‘Salvacugtam cachramushag’ Dios ningan aywamunanpita. Chaypita nä chraramur lapalanta pay tantiachipäcamänanta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Niptin Jesusga nisha: “Paymi noga cayä, gamwan canan rimayag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chay niyaptilanmi discïpuluncunaga chrarärimü micuy rantig aywapäcungäpita. Jinarcurmi mayacasha nirag ricacarärï Samaria warmiwan rimaptinga. Nätan manatan maygäsi “¿Imatatag tapurayqui? u ¿imanirtag rimaray chay warmiwan?” nipäcurachüga. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chaura warmiga wacuyninta dëjarcurmi aywacun marcata. Jinarcurmi chaychrüga cay nimusha: ");
INSERT INTO qvnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Shapäcamuy. Ricapäcamuy, lapan rurangäta nimag runata. ¡Paypishchri cayan ‘Salvacugtam cachramushag’ Dios ninganga!” ");
INSERT INTO qvnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Niruptin runacunaga aywaytam galacayärimun Jesuscagman. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chaycama nogacunaga Jesustam nircayä: “Yachrachig, micucurcuynar”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nipäcuptïga “Nogapagga cayan jucmi micunä gamcuna mana musyapäcungaymi” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chauraga “¿Pilas aparapamura micuytachur?” nir tapunacurcayaptïmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesusga cay nipäcaman: “Cachramagnï munanganta rurayaymi, nätan nimangancunata rurayaymi cayan nogapagga juc micuynuy. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gamcunaga tarpurcur ‘Chruscu quillataran chrämunga cosëcha wichan’ nircayanquim. Nätan noga nipäcug: Rircaripäcuy shumag, nä micuy pogoshanuymi cayan wac yurag jacusha aywayämugcuna Diospita mayacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pi maysi cosëchachru mincayga chrasquinmi pägunta, nätan palansi imaycamas cawag capäcunanpagmi, chay tarpucugsi cosechagwan cushisha cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chauraga alitam rimapäcun cay nir: ‘Tarpugga jucmi, nätan cosechagga juctan’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gamcunata noga cachrayä cosechag, mana uryapäcungaymanmi. Chauraga juc runacunam uryapäcura. Jinatam gamcunaga chay uryacurcanganta cananga cosecharcayanqui” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jinarcurmi manacagpag ricasha chay Samaria runacunaga Jesusman yupachicurcasha achca, chay warmi “Lapan rurangätam niraman” niruptilan. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chaura Samaria runacuna nä Jesuscagman chrarärimurga “Quëdashunnar tayta” nipäcura yapay yapay. Nipäcuptin Jesusga quëdara ishcay junagmi chaychru. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jinarcurmi quiquin Jesús rimagta mayarärir runacunaga mas achca chrasquicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chauraga chay warmita cay nipäcuram: “Cananga payman yupachicurcayä manam willapacamangalaypachu, antis quiquïcuna nogacunas mayapäcusha carmi. Nätan musyarcayäsi shumagmi lapan runa salvacug pay canganta” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chaypita nä ishcay junag Samariachru carcurga Jesusga yargora, nogacuna discïpuluncunawan Galileata aywapäcunäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesusga quiquinmi runacunata cay nira: “Diospa willacugnincuna, manam maygansi alipa chrasquisha canchu quiquinpa marcanchrüga” nira. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chay ningannuylam Galileaman chraräriptïga, Jesusta chrasquirärin alipa, Jerusalenchru Pascua fiestaman aywar ima rurangantas ricasha capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jinarcurmi cutiyarärï chay Galileachru, Canä ningan marcaman, yacuta vïnuman muyuchinganman. Chaura Capernaumchrüga cara reycagchru soldäducuna mandagmi Roma runa. Paypa churinmi gueshyasha. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jinarcurmi Judeapita Canä marcaman Jesús chrämusha canganta nä mayarurga aywaramunag paywan tincug. Chaypitam Jesustaga “Aywaläshunnar wayïta tayta, olgo churiläta cuticächinaypag. Nämar pasay wanunayan” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chaura Jesusga cay ninmi: “Ima-aygatas munaynïwan mana ruraptïga, gamcuna juc castacunas manam ‘Diospitachr payga aywarayämun’ nipäcunquichu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Niptin chay gueshyapacug runaga cay ninmi: “Tayta, aywaläshunnar pasay-pacha, manaragsi churilä wanungancama”. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Niptin Jesusga cay ninmi: “Cuticuy wayiquita. Churiquiga cawangam”. Niptin runaga Jesús ningalanman yupachicularmi, aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nä Capernaum marcaman jegarpuyaptinshi, rantisha runancunaga yargarärimun taripacug: “Churiquiga nä alim cayan” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chauraga tapurunshi: “¿Ima üranuypitam galayurun cuticayta?” Niptinga “Ganyan chraupi junag pasaruptilanmi acachaynin amaynarun” nipäcunshi. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chaura chay runaga tantiarun chayüranuy “Cawangam churiquiga” Jesús ningantash. Chaura runaga lapan aylluntin Jesusman yupachicuytam galayapäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Caywanga nä ishcay cutim Jesusga reguechicura pi cangantas Judeapita Galileata aywar. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nä chaycunata ruracurcurmi, Jesusga nogacuna discïpuluncunawan jegara Jerusalén marcata, Israel castacunapa fiestäcuna captin. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chay marcachrümi cara ‘Uyshacuna rantina puncu’ nipäcunganman nachrganachru juc gochrannuysi jatun pucyu pichga ramädayog. Chay jatun pucyutam hebreo rimaychrüga Betesda nipäcug. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chaypa puncuncunachrümi chranin gueshyagcuna capäcug, ñaushacuna, ratacuna, gueshyagtucushacuna. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chay gochranyamanga juc angelmi jana pachapita aywachrämug. Jinarcurmi yacuta cuyuchig. Nätan chayman naupata jegarpugmi nä yacu cuyuyta usharuptinga cuticag ima-ayga gueshyapitas. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chaychrümi canag juc runa nä quima chrunca puwagniyog wata gueshyagtucusha. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pay chrachrarayagta Jesús ricapururga, pasaymi tantiarun alisca unay nä gueshyayanganta. Chauraga tapurun gueshyagtam: “¿Cuticasha cayta munayanquichu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Niptinmi gueshyagga nin: “Tayta, manam pisi canchu yacu cuyurimungan üra cay gochranyaman jitayamag. Nätan imaysi, aywayta nacayaptilämi naupäta juc jegarpuyan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Niptin Jesusga nirun: “Sharcuy. Cämayta apacurcur aywacuy”. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Niptin runaga chayüram cuticarun. Jinarcurmi cämanta apacurcur aywacun. Chay junag cara jamana junagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jinarcurmi Israel castapa mandagnincunaga nirärinag chay cuticasha runata “¡Imanarayanquim! Cananga jamana junagmi. ¡Manam cämayta apanay junagchu!” ");
INSERT INTO qvnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nipäcuptin payga “Cuticächimagmi nogataga ‘Cämayta apacurcur aywacuy’ nimasha”. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Niptinga tapupäcunag: “¿Pimi ‘Cämayta apacurcur aywacuy’ nirushunqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nipäcuptin nätan runaga mana musyashachu pi cuticächingantas. Chay achca runapita Jesús nä aywasha captin. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaypitam Jesusga chay cuticächingan runata tarirun Diospa wayinchru, jinarcurmi cay nin: “Canan nä cuticarayarga, ama masta juchäcuychu, mana imas mas juyunnin pasashunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Niptin runaga aywarunag chay Israel castacunapa mandagnïcunamanmi “Jesusmi casha chay cutichimagga” nir willapäcug. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chaypinpitam Israel casta mandagcunaga Jesusta ñawilanchru cachipäcura. Jinaman wanuchiylata munapäcura, jamana junagchru chay imacunatas ruraptin. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Chaura Jesusga rimapayta galacuyun cay nirmi: “Dios-mayïga chaynuylam ruranancunata rurayan canancamas, nätan nogas paynuymi rurayä”. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chay niruptin chay mandagcunaga masran munapäcuras wanuchiyta, manam jamana junagchru uryangalanpitachu, antis “Tayta Diospa-mayinmi cä” ninganpitawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chaura Jesusga cay nirunmi: “Mayapäcamay shumag: Noga Diospa-mayinga manam pasay imatas rurächu quiquiläpitaga, antis Dios-mayï rurayangantam nogas rurayäga. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tayta Diosga cuyamarmi noga Dios-mayinta lapan rurayanganta musyachiman, nätan mas aliscacunataran musyachimangas mayacasha nirag capäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tayta Diosga wanushacunata cawacächimunmi. Chaynuymi noga, Diospa-mayinsi munangätaga cawacächimü. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tayta Diosga manam pitasi juchanta taripangachu, antis noga Diospa-mayintam chruramasha juchacunata taripänäpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chaynuypa lapan runa, noga Diospa-mayintas Tayta Diostanuy alipa ricapäcamänanpag. Pisi nogata mana alipa ricamagga, cachramagnï Tayta Diostam mana alipa ricanchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mayapäcamay shumag: Pisi, noga ningäta mayacamagga, jinaman cachramagnïman yupachicugga, nä galayurun imaycamas paywan cawaytam. Chauraga manam ‘Juchanpita imaycamas cunchuchisha cachun’ nishagchu. Nätan chaynuy mana nishagchu wanushanuysi cayanganpita imaycamas cawagman nä muyuruptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mayapäcamay shumag: Nämi chayman nachrgararcayanqui. Nätan cananmi chay junag nä chraramun wanushacunanuysi cayagcuna, noga Diospa-mayin rimangäta mayapäcunan junagchru, jinaman cäsucamagcuna Dioswan cawapäcunan junagchru. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tayta Diosga quiquinmi munayninwan cawachin pitas maytas. Chaynuymi noga Diospa-mayintas nimasha paynuysi runa cawachig canäpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nätan nimashatan runacunapa juchanta taripänäpagsi noga jana pachapita shamusha runataga. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","¿Imanirtag mana cäsucarcämanquichu? Chrämungam lapan wanushacuna shimïta mayapäcunan junag. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chaychrümi ali ruragcuna cawacapäcamunga Dioswan imaycamas cawapäcunanpag, nätan lutan ruragcunas cawacapäcamunga imaycamas cunchuchisha capäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nogaga manam imatas pasay rurächu quiquiläpitaga. Nogaga juchacunata taripayä Tayta Dios nimaptinmi, nätan nishagsi razoncagtam. Nogaga manam rurä munangätachu, antis cachramagnï munangantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Noga quiquiläpita rimaptïga, manam välinchu imapagsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nätan noga pi cangätas razoncagta musyachishugniquicuna cayanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gamcuna cachrapäcuraymi Bautizag Juanman tapug. Payga nipäcushuray razoncagtam. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Manam nogaga pisi reguechimänantaragchu munä. Rimarcuyäga Juanpitas, gamcuna salvacurcänaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanga cara juc achqui rupayagnuymi. Gamcunaga payta mayacur nä cushicugpagmi carcayaray ishcay quima junaglaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nätan, noga pi cangätas, Juanpitas mas shumag musyachicug cayanmi. Chaura Tayta Dios nimangannuy rurayangäcunam, pay cachramanganta musyarcayächishunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jinamanga cachramagnï Tayta Diossi nogapitaga musyachipäcushuraymi. Nätan gamcunaga manam imaysi paypataga shimintas mayapäcuraypishchu ni paytaga ricapapäcuraypishchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nätan rimangansi manatan shongoycunaman yaycunchu, Tayta Dios cachramunganta mana chrasquicurcaptiquim. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gamcunaga Dios isquirbichingancunata aliscam yachracurcayanqui, ‘Dioswan imaycamas cawananchipag’ nir, nätan chay isquirbishacunaga nogapitam musyarcayächishunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chaynuy niyaptinsi gamcunaga, manam ni munapäcunquichu nogaman aywamuytaga Dioswan imaycamas cawapäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nogaga manam munächu runacunapita alawasha cayta. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nätan musyayätan Diosta mana cuyapäcungaytas. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nogaga aywamurä Tayta Dios cachramaptinmi, jinatam mana chrasquipäcamanquichu, nätan quiquilanpita pisi aywamugtam ichaga chrasquicarärinquimanga. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gamcunaga jucniquis jucniquis alawasha caylatam munarcayanqui, nätan manam japalaylan Diospita alawasha caytaga munapäcunquichu. Chaynuy jinayarga manam imaysi nogaman yupachicarcämanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ama nipäcuychu nogapag ‘Paymi juchachämäshun Tayta Diospa naupanchru’ nirga. Juchachapäcushunquiga Moisespa isquirbishancunaman, chay yupachicurcayangaymi. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Razonpa Moisés ninganta chrasquicurcarga, nogatas chrasquipäcamanquimanmi. Payga isquirbira nogapitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nätan pay isquirbingancunatas ‘Manam cayga Diospitachu’ nircayarga, ¿imanaypatag ‘Diospitam payga razonpa rimayan’ nipäcamanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chayta nircurga Jesús aywacura nogacuna, discïpuluncunawan Galilea gochrapa wacläcag chimpantam. Chay quiquin gochralatam Tiberias gochra nipäcugsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Achcam runacuna Jesusta gatirapäcura, gueshyagcunata munayninwan cuticächigta ricapäcur. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chaura Jesusga jegara juc gotumanmi nogacuna discïpuluncunawan. Jinarcurmi chaychru tayarcayarä. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nämi pasay nachrgayämura Pascua nipäcunagä, Israel castacunapa fiestäcuna. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jinarcurmi Jesusga achca runa aywamushata rircärirga Felipeta cay nin: “¿Maychrütag cananga rantishun tantata cay lapan runacunapagga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Chaynuy nira: “Mä ¡imaninagshi Felipe!” nirmi. Jesusga musyara shumagmi ima ruraytas. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chaura Felipega cay ninmi: “Ishcay pachrac junagchru juc runa gänangansi manam aypanmanchu, cay lapan runacunapagga uchuc uchuclata micayärinanpagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Niptinga Simón Pedropa wauguen Andresga cay ninmi: ");
INSERT INTO qvnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Juc walash caychru charayanmi cebädapita rurasha pichga tantata, ishcay acapa pescäduntawan. Nätan ¿imatag chaylaga caychica runapagga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Niptin Jesusga cay nipäcamanmi: “Tayucurcay nipäcuy runacunata”. Chaura niräriptïga, alisca guewamanmi tayarärin pichga waranganuy olgocuna. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chaura Jesusga chay tantacunata charircur nä Tayta Diosta “Gracias” nircurga discïpuluncunatam goräriman. Jinatam nogacunaga aypupäcurä lapan tayarcayagta. Chaynuylam rurara pescäduwansi. Chaytas aypupäcurä lapantam imanuytas munapäcunganpita. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Chaura nä yamangancama micaräriptinga, discïpuluncunatam Jesusga nipäcaman: “Shuntapäcamuy wac acapa puchushacunata mana pasay usunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nipäcamaptinga palarärirä chrunca ishcayniyog balay juntatam, chay pichga tantapa puchunta. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chaura runacunaga munayninwan chay ruragta ricarärirga “Cayga cayan razonpa Diospa chay willacugninmi ‘Cay pachaman cachramushagmi’ Dios nimanganchim” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nätan paytaga “¡Imanaypas aywachishun reyninchi cananpagmi!” nipäcugta tantiarur Jesusga yargorcurmi aywacun mas janaman chaychru japalan cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chaura pacha nä chacanayaptinga, discïpuluncuna uranpapäcurä gochracagmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chaypitam nä chrarpururga yaycarärï büquiman nä chacasha. Jinarcurmi Capernaumman pasayta galayurcayarä, nätan Jesusga manaran chrämuraragchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chaura galacuyun alisca walyaytam. Jinarcurmi yacu lagyayta galacayamun. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chaypitam nä juc lïwa masta aywarayarga ricaparärï Jesusta nä büquicagman yacu jananpa ichriyämugta. Jinarcurmi nogacunaga manchacarärï. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chaura payga “Nogam cayä. Ama manchapäcuychu” nirärimanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chauraga cushisham yaycarärichï büquiman. Jinarcurmi chrarärï ashcamayla chay Capernaummanga. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Warantinga chay gochrapa waclacag chimpanchru quëdamusha runacunaga tantiarärinag chay juclay puchurayag büquilawan shapäcamungantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chauraga Tiberias marcapita juc büquicunash chrarärin Jesús “Gracias” nicuruptin tantata micapäcungan cercanman. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chaura runacunaga paycunachru mana Jesussi ni discïpuluncunas capäcungäta tantiarärirga chay büquicuna chragman yaycurcurmi aywacarcämunag Capernaumman Jesusta ashircayar. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chaura warantinga nä caylä chimpaman chrarärimurga tincurärin Jesuswanmi. Chaypitam tapurärin cay nir: “Yachrachig, ¿imaytag chraramuray cayman?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nipäcuptinmi Jesusga cay nin: “Razoncagtam nircayag: Gamcunaga ashircayämanqui yamapäcungaycama micarärirmi. Nätan manam munaynïwan imanir rurangätas tantiapäcusha carchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama uryapäcuychu caylachru ushacag micuylapagga, antis uryapacuyga imaycamas cawachicug mana ushacag micuycagpag. Chaytaga gopäcushay noga jana pachapita shamusha runam. Chaypagmi nogata Dios cachrayäman”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Niptinga tapurärin: “¿Imatatag rurapäcüman, Tayta Dios munanganta rurapäcunäpag?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chaura Jesusga cay ninmi: “Tayta Diosga munayan noga, cachramushanta chrasquicarcämänaytam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Niptin chauraga nipäcura: “¿Ricarcayaptï mas alinninta imatas rurarunquimanchu munayniquiwan chrasquicurcänagpag? ¿Imatatag ruranqui? ");
INSERT INTO qvnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay awillunchicuna wac jäpag pampachru micapäcura ‘manä’ ningantam isquirbishachru ningannuysi: Chaura Moisesmi micapäcunanpag chay micuyta gora jana pachapita”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nipäcuptin Jesús nira: “Mayapäcamay shumag: Manam Moiseschu gora chay jana pachapita micuytaga, antis Tayta Diosmi jana pachapita razoncag micuytaga gorcayäshunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tayta Dios gopäcushungay micuyga cayan jana pachapita aywamusham. Chayga lapan runatam cawachin”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niptinga cay nirärinmi: “Tayta, chaynuylar gopäcamay chay micuyta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nipäcuptinmi Jesusga cay nin: “Nogam cayä chay cawachicug micuyga. Nogaman aywamugcagga pisi chrasquimagcagga canga yamangancama micushanuymi imaycamas. Nätan pisi chrasquimagcagga canga yamangancama yacu upyashanuymi imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nätan ningagnuysi gamcunaga nä manam ‘Diospitachr’ nipäcamanquichu ima rurayagta ricarcayämarsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pi maysi Tayta Dios gomanganga nogamanmi aywamun. Nätan nogaman aywamugcagtaga manam gargoshagchu washaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nogaga jana pachapita aywamurä manam shongö munanganta ruragchu, antis cachramagnï munanganta ruragmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nätan cachramagnï Tayta Diosga munan chay lapan runa gomanganta mana maygalantas ogranätam, jinamanga ushanan junagchru cawacächimunätam. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chay cachramagnïga munan pi maysi noga Diospa-mayin cayangäta tantiarur chrasquicarcämänatam, imaycamas ali cawapäcunanpag. Nätan nogam ushanan junagchrüga cawacächimushag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chaynuypa niruptinga Israel castäcunapa mandagnincuna pengapaytam galacayärin “Nogam cayä jana pachapita aywamusha micuy” ninganpitaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Chauraga cay ninacurcaram: “Cay Jesusga Josëpa churintar. Caypataga mamantas taytantas regueyanchitag. Nätan ¿imanirtag ‘Jana pachapitam aywarayämü’ niyanga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nircayaptinmi Jesusga nirun: “Ama nä lutanta rimapäcuychu. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Manam pisi aywamuyta atipanmanchu nogaman, cachramagnï Tayta Dios mana pushamuptinga. Nätan nogaman pushamungancunata ushanan junagchru cawacächimushagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diospa unay willacugnincuna isquirbipäcunganchru ‘Diosmi yachrachinga lapan runata’ niyanmi. Chauraga lapan runas chay Tayta Diospita mayacugga, jinaman yachracugga aywamun nogamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Manam pisi ricapurachu Tayta Diosta. Ricapuräga Diospita noga aywamushalam. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mayacurcay shumag: Pisi nogata chrasquicamagga, nä galayurun Dioswan imaycamas cawaytam. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nogam cayä chay imaycamas cawachicug micuyga. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Unay awillunchicuna chay jäpag pampachru ‘manä’, micugcuna lapanmi wanupäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nätan nogaga rimaparcayag jana pachapita aywamug micuypitam. Chayta pisi micugga manam nä wanungachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nogam cayä chay jana pachapita aywamusha micuyga. Cay micuyta micugga Dioswanmi imaycamas cawanga. Nätan chay micuy gopäcunagga cayan cuerpümi. Cay cuerpütam goshag cay pachachru lapan runacuna raygo”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chaura Jesús niruptin, Israel castäcunapa mandagcunaga galacayärin quiquincamam cay ninacuyta: “¿Imanaypatag cay runaga gomäshun cuerpunta micunanchipagga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nipäcuptin Jesusga nin: “Mayapäcamay shumag: Noga jana pachapita aywamushapa cuerpüta mana micapäcurga, nätan mana yawarnïta upyapäcurga wanushanuymi carcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pisi cuerpüta micugga jinaman yawarnïta upyagga nä cawayan imaycamas Dioswanmi. Paycunatam noga cawacächimushag ushanan junagchru. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nogapa cuerpüga razoncag micuymi, nätan yawarnïsi razoncag upyaymi. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pi maysi cuerpüta micugga nätan yawarnïta upyagga nogawanmi cayan, nätan nogas paywantan cayä. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Chay cachramagnï Tayta Diosga imaycamas cawacugmi. Paynuymi nogas cayä, nätan pisi cuerpüta micugga noganuymi cawanga imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nogam cayä jana pachapita aywamusha micuyga. Cay micuyga manam unay awillunchicuna ‘manä’ ninganta micapäcungannuychu. Paycuna chayta micurayarsi wanupäcusha lapanmi. Nätan pisi cay micuynuysi cayagman yupachicugga cawanga Dioswanmi imaycamas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Caycunatam Jesús yachrachira Israel castäcuna gotucapäcunä wayichru. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chay yachrachinganta mayarärirga achcam Jesusta gatiragcuna cay nipäcura: “Cay nimanganchicunataga manam chrasquichwanchu. Nätan shauyalaga manam pisi chrasquinmanpishchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nipäcugta tantiarur Jesusga cay ninmi: “¿Piñäcarärichigchu chay rimangäwan? ");
INSERT INTO qvnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chauraga ¿imanuyrag piñäcarärinquiman, noga jana pachapita shamusha runata unay cangäman jegagta ricaparärimarga? ");
INSERT INTO qvnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiritum runataga cawachin. Cuerpuga manam quiquilanga cawanchu. Nätan niyangäta chrasquicugga pisi razonpam cawanga imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nätan gamcunachru waquinniqui carcayanquiran mana chrasquicamagcuna” ninmi. Jesusga galayunanpita-pacham musyara pïcuna mana chrasquipäcunantas, wanuchipäcunanpag pi reguechinantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chaura Jesusga yapaytan cay nin: “Chaymi nipäcurag manam pisi aywamunmanchu nogaman, Tayta Dios mana pushapäcamushuptiquiga” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Niruptin, Jesusta gatiragcunaga achcam aywacurcasha, manam nä puripäcurapishchu paywanga. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chauraga chay chrunca ishcayniyog discïpuluncunatam tapuräriman: “¿Gamcunas aywacuytachu munarcayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nipäcamaptinmi Pedro nipäcungä Simonga cay nin: “Munayniyog, ¿pimantag aywapäcushag? Gamga rimaparcayämanqui imaycamas Dioswan cawaypitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogacunaga nämi chrasquicurcasha capäcug. Nätan musyarcayämi Diospita gam shamusha cangaytas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Niptin Jesusga nipäcaman: “Nogam acrapäcurag gamcuna, chrunca ishcayniyogta, nätan gamcunapita jucga cayan Asyagpam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chaynuypa Jesús rimara Simonpa churin Judas Iscariotepitam. Paymi casha chay chrunca ishcayniyogpita Jesusta wanuchipäcunanpag reguechig. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaynuypa nircurga, Jesús purira Galilea nipäcungäpam. Judeamanga mana aywayta munarachu, Israel castachru mandagcuna wanuchiyta munapäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chaura nämi nachrgarayämura Israel castacunapa fiestäcuna, chay tolduchru yachrapäcunä junagcuna. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chaypitam wauguencunaga manacagpag ricar Jesusta cay nirärin: “Yargonquimanmi caypitaga. Aywanquimanmi Judeatas. Chaychrüsi discïpuluycuna rurangayta ricapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pisi reguechicuy munagga manam ruran imatas pacayninchrüchu. Nä caycunata rurayarga ruray lapan runa ricarcayäshuptiqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesustaga manam ni wauguencunalas “Cayga Diospitachr razonpa” nipäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chaura Jesusga cay ninmi: “Manaran chay ruranä wichan aypamunragchu. Nätan gamcunapagga imayüras alilam. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Juchasapa runacuna manam gamcunataga chregnipäcushunquimanchu, nätan nogataga chregnipäcaman lutan ruraynincunata musyachiptïmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gamcuna aywapäcuy fiestaman. Nogapagga manam üra aypamunragchu aywanäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nirga quëdacuyun Galileachrümi. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chaypita nä wauguencuna aywaräriptinga, Jesuspis jegara chay fiestaman nogacuna discïpuluncunawanmi. Aywapäcurä pacaylapa yupaymi runacunapita. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nätan Israel castacunapa mandagnïcunaga Jesusta ashipäcunag wanuchipäcunanpag “¿Maychrürag cayan chay runa?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jinarcurmi runacunaga wishwishyaylapa rimayta galacayärin Jesuspita: Waquinga “Ali runam” nir. Nätan waquinga “Casquipayan runacunatam, lutan runam” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nätan manam pisi rimarachu achca runachrüga chay mandagnïcunata manchacur. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nä chay fiesta lamitä cayaptinmi, Jesusga yaycurun Diospa wayin puncuman. Jinarcurmi galacuyun yachrachiyta. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chaura Israel castapa mandagnïcunaga mayacasha niragmi capäcura cay nir: “Cayga ¿imanaypatag musyan ima-aygatas mana yachracusha cayarga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nipäcuptin Jesusga nin: “Cay yachrayächingäga manam nogapachu, antis chay cachramagnïpam. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dios munanganta pisi ruray munagga tantiangam yachrayächingä Diospita cangantas u quiquïpa yarpaylapita rimayangätas. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pisi quiquinpa yarpaylapita rimagga runacunapita alinninpag ricasha cananpagmi riman. Nätan cachramugnin alawasha cananta munagga pisi riman razoncagtam, manam payga casqui rimagchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gamcunapagmi Dios rimanganta Moisés isquirbira, nätan manam maygalaysi cäsucurcanquichu. ¿Imanirtag wanuchiyta munarcayämanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Niptin runacunaga “Lutan espiritum gamchrüga cayan. ¿Pitag wanuchiylata munayäshunqui?”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nipäcuptinmi Jesús cay nin: “Jamana junagchru juclaylata rurarungäpitam gamcunaga lapaysi nä mana alichu capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Gamcunata Moisés nipäcushuray lapan olgota señalapäcunaypagmi, nätan manam Moiseschu galayachira chay rurachiytaga. Antis mas unaycag awillunchicunam. Chaymi gamcunas señalarcayanqui jamana junag cayaptinsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chauraga Moisés isquirbingancuna cäsusha cananpag, jina jamana junagchrüsi señalarcayarga amam piñäcurcanquimanchu nogas runata shumag cuticarayächiptïga. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gamcuna ama nipäcamaychu lutanta Moisés isquirbinganta mana shumag tantialarga, antis jamana junag imapag cangantas shumag tantiapäcuy” nira. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jesús niruptinga chay Jerusalenchru juc ishcay runacunam cay ninacarärin: “Cay runaga chay wanuchipäcunanpag ashircayangannuytag cayan. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Cayga caychru lapan runa ricaytag yachrayächin, nätan manatag pisi imatas ninchu. ¡Marca mandagcunachur icha musyarärin! ¿‘Salvacugtam cachramushag’ Dios nimanganchi pay canganta? ");
INSERT INTO qvnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Noganchiga musyayanchim wac runa maypita cangantas, nätan ‘Salvacugtam cachramushag’ Dios nimanganchi aywamunanpitaga manam musyanchichu maypita shamunantas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chay nipäcugta mayarur Jesusga Diospa wayin puncuchru yachrayächir gayacuypanuymi cay nin: “Chauraga reguercayämanquichrar, jinaman musyarcayanquichr maypita aywamungätas. Nätan nogaga manam aywamurä quiquïlapitachu, antis aywarayämü cachramagnï razonpa captinmi. Paytaga manam reguepäcunquichu gamcunaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nogaga nätan regueyämi, paypita aywamusha car. Paymi cachrarayäman nogataga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chaura niruptinga pasay chariruytam munapäcura, nätan maygansi mana charipäcurachüga, wanuchipäcunanpag manarag üran aypamuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Chaypitam achca runacuna Jesusta chrasquicarärin, jinaman cay nipäcura: “Salvacug aywamursi manam cay runapita mastaga munayninwan ruranmanchu ima-aygatas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chay runacuna Jesuspita rimagta mayarurmi, fariseocunawan sacerdöticunapa mandagnincunaga cachrarärimunag, Diospa wayin ricag guardiacunata Jesusta charipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chaura Jesusga cay ninmi: “Gamcunawan cashag manam alä unaychu. Nämi cuticushag cachramagnïman. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gamcuna ashipäcamanquim, nätan manam taripäcamanquichu. Noga cayangämanga manam chrapäcamunquichu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Niruptin Israel castacunapa mandagnïcunaga quiquincamam cay ninacurcara: “¿Maytash cay aywacunga mana tarinanchitaga? ¿Aywacunga Diosta mana regueg runacunachru yachrachimugchur? ");
INSERT INTO qvnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imaninantatag niramanchi: ‘Ashipäcamanquim, nätan manam taripäcamanquichu. Nätan cayangämansi manam chrapäcamunquichu’ nirga?” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chaura ushanan junagchrüga chay fiesta cara mas jatunmi waquin junagcunapitaga. Chay junagmi shayuyur Jesusga gayacuypanuy cay nin: “Pisi juc yacunashanuy cayagga aywamuy nogaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Isquirbishachru ningannuysi nogata chay chrasquicamagchrüga juc mayu aywayagnuymi canga chay cawachicug yacu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaynuypa nira Jesusta chrasquicugcuna Santu Espirituta chrasquipäcunanpitam. Chaypagga manaran Santu Espíritu aywasharagchu cara Jesús jana pachaman mana cutisharag captin. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chaynuypa nigta mayarärirga chay runacunachru ishcay quima rimapäcura: “Cay runaga razonpa Diospa willacugninmi” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nätan waquinmi “Cristom” nipäcura. Chaypita waquincagmi nipäcura: “¿Galileapitachu salvacug aywamunan cayan?” ");
INSERT INTO qvnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Isquirbishachrüga niyan Rey David castapita nätan Belén marcapita aywamunantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chaura Jesuspa jananmi runacuna acagyachinacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nätan juc ishcay chaychru cayagcunaga chariruytam munapäcura wanuchipäcunanpag, nätan manam juclaylas charirachüga. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chay guardiacuna aywag jinala chraräriptinga fariseocunawan sacerdöticunapa mandagnincunaga cay nipäcusha: “¿Maytag chay runaga? ¿Imanirtag mana charipäcamunquichu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nipäcuptin guardiacunaga nipäcunag: “Manam cay runanuyga pisi rimarachu imaysi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nipäcuptin fariseocunaga nirärin: “Chaura gamcunas ‘Razonmi nirchri’, chrasquicarärinqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Manam paytaga maygan mandagninchi chrurashacunas ni fariseocunas chrasquipäcunchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nätan Moisés isquirbinganta, mana imatas tantiag gotaracunaga cayan ‘Lutan’ nisham Diospitas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nipäcuptin paycuna casta Nicodemoga Jesusman chay pagaspa aywagga cay nisha: ");
INSERT INTO qvnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“¿Moisés isquirbingan nimanchi ‘Mana juchan rimacuglata pitas juchanpita cunchuchun’ ninanchipagchu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Niptinga paytas cay nipäcusha: “¿Gamsi cayanqui Galileapitachu? Isquirbishacuna tantiayta yachracuy. Chaychru tarinqui Diospa willacugnincuna mana imaysi Galileapita yargamungantam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ninacurcurga wayincunatacamam aywacurcara lapansi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nätan Jesusga aywasha Olivos ningan gotutam. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chaypitam warantinga goyashla Diospa wayinman cutiyaramun. Chaura runacunaga lapanmi Jesusman ashuyarärin. Jinarcurmi payga imaysi tayuyur yachrachingannuy yachrachiyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chauraga Moisés isquirbinganta yachrachigcunawan fariseocunaga chrarärichimun juc gowayog warmitam juc olgowan punuyagta tarirärir. Jinarcurmi chraupiman shayayachir cay nirärin Jesusta: ");
INSERT INTO qvnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Yachrachig, cay warmitam tarirärimun juc olgowan cayagta. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chaura Moisés isquirbinganchrüga niyan chaynuy warmicunataga rumiwan chapinanchipagmi, nätan gamga, ¿ima ninquitag?” ");
INSERT INTO qvnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chaynuy nipäcura: “¿Pagta lutanta rimarachichwansi juchachänanchipag?” nirmi. Chaura Jesusga lipurpuyurmi pampachru isquirbiyta galacuyun dëdunwan. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nätan chaynuyla tapupäcuptinmi Jesusga nuquircur cay nin: “Gamcunapita maygaysi mana juchaynagcag, galayapäcuy wac warmi gompayta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nircurga yapay lipurpuyurtan chay isquirbiyanganta ushapayara. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nätan chay nigta mayarärirga juchayog capäcunganta tantiacarärirga yargarärin jucpacamam, chachanninpita galayur lapan shulcacunas. Nä lapan yargaräriptin Jesusga ricacarun discïpuluncunalawanmi, jinamanmi chay warmi shayachipäcungalanwan. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chaura Jesusga sharcurcurmi warmita cay nin: “Mamala, ¿maychrütag cayan ‘Juchäcusham’ nircayäshugniquicuna? ¿Manachu maygansi ‘Juchanpita cunchuchisha cachun’ nishunqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Niptin warmiga nin: “Manatar tayta, maygansi”. Niptin Jesusga cay nin: “Manam nogasi ‘Juchanpita cunchuchisha cachun’ niyta munagchu. Gamsi aywacuy, nätan amam yapayga juchäcunquichu” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chaypita Jesusga yapaytan chay ninacurcayag runacunata rimaparatag cay nir: “Noga cä juc achquinuymi cay pachachru runacunapag. Pi maysi cäsucamagga, manam nä juchäcuyarchu cawanga juc yanauyagchru purignuysi, antis chrasquinga cay achquiynuysi cayag ali cawachicugtam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Niptin fariseocunaga cay nirärinmi: “Gamga quiquilaypita rimacunqui imapitas ali cayta munarmi. Chaynuy niptiquiga rimayangayga manam razoncagchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nipäcuptinmi Jesusga cay nin: “Rimayangäga razoncagmi. Nogapita quiquï rimayaptïsi. Nogaga musyayämi maypita aywamungätas, mayta aywayangätas. Nätan gamcunaga manam musyapäcunquichu maypita aywamungätas ni mayta aywayangätas. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gamcunaga juchata taripapäcunqui tantiaylaycunapitam. Nogaga manam pitas juchanta taripächu quiquïpa tantiaylapitaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nätan tariparga razoncagtam taripä juchanta pitas. Nogaga manam japalächu rurä, antis cachramagnï Tayta Dios munangannuymi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés isquirbinganchru cay niyanmi: ‘Ishcay runacuna ricangantas u musyangantas chaynuylata rimacurcayaptinga razoncagmi’ ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chauraga nogam cayä jucga, quiquïpita rimag, nätan cachramag Taytämi cayan jucga, nogapita rimag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Niptinga cay nipäcuram: “¿Maychrütag cayan taytayqui?” Nipäcuptin Jesusga “Gamcunaga manam musyapäcunquichu noga pi cangätas, manatan musyapäcunquichu Tayta Diospitas. Nogata reguepäcamarga Tayta Diostas reguepäcunquimanmi” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chaycunata Jesús yachrachira Diospa wayin sawan ruyichru mandagcuna goturarcayag mayananpagmi Diospag golgue gotucurcänancagpa. Nätan mana pisi charirachu wanuchipäcunanpag, manarag üran aypamuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chaura Jesusga yapaytan chay runacunata cay nin: “Nogaga aywacümi, gamcuna ashipäcamanquim. Nätan wanupäcunqui chaynuy juchasapalam. Chaura noga aywangämanga manam chrämuyta atipapäcunquichu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Niptin chay castäcunaga cay nipäcuram: “¿Maychrüsi quiquinchur wanuchicurunga? ¿Chaychur niyan mana paycagman chrayta atipänanchita?” ");
INSERT INTO qvnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nipäcuptinmi Jesusga cay nin: “Gamcunaga cayanqui caylapitam. Nogaga cayä janapitam. Gamcunaga cayanqui cay pachapitam. Nogaga manam cä cay pachapitachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chaymi nircayag juchalaycunachru wanupäcunaypita. Chauraga ‘Nogam cayä’ ningäta, mana chrasquipäcurga wanupäcunqui chaynuy juchasapalam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Niruptinga tapupäcura: “¿Pitag gam cayanqui?” Nipäcuptin Jesusga “Chaytaga galayunanpitam nä nipäcurag: ");
INSERT INTO qvnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Maymaytachr gamcunata ninä cayan, jinaman ima juchaycunatas nipäcunagran cayan. Nätan cachramagnïga razoncaglata rimagmi. Nogaga paypita mayangätam rimapayä cay pachachru runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nätan chay runacunaga manam tantiapäcurachu Tayta Diospita rimapaptin” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chaymi Jesusga cay nin: “Noga jana pachapita shamusha runata warcarärimar-ran tantiapäcunqui gamcunaga ‘Nogam cayä’ ningätas, jinaman quiquïpa yarpayläpita mana ima-ayga rurangätas, jinaman Tayta Dios yachrachimangannuyla rimangätas. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cachramagnïga nogawanmi cayan. Manam japalätaga dëjamanchu, pay munangannuyla imaysi ruraptï”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús chaynuypa niruptinga achcam runacuna payta chrasquicarärin salvacugnin cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chauraga chay chrasquicusha castäcunatam Jesusga cay nin: “Gamga noga ningäta cäsucur cawarga, capäcunqui razonpa nogapa discïpulümi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jinamanmi reguepäcunqui razoncagta, nätan chay razoncagmi jucpa munayninpita cachrarichipäcushunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Niptinmi cay nirärin: “Nogacunaga capäcü Abrahampa castan aywagmi, nätan manam imaysi capäcurächu pipa servigninsi. ¿Imanirtag nircayämanqui ‘Cachrarisham capäcunqui’ nirga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nipäcuptin Jesusga cay ninmi: “Razoncagtam nircayag: Pisi juchäcuyar cawagga, chaynuy juchäcuyälarmi cawan. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juc rantisha runaga manam chaynuylachu imaycamas chay rantigninpa maquinchru can. Nätan chay rantigpa churinmi ichaga cayan paywan imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chauraga Diospa-mayin, chay jucpa munayninpita jorgarärishuptiquim ichaga razonpa capäcunquiga juc cachrarishanuy. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Musyayämi Abrahampa castan capäcungayta. Nätan wanuchimayta munarcayämanqui nogas nircayangagta mana chrasquiyta munapäcurmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nogaga rimayä Tayta Dioscagchru ricangäcunatam. Nätan gamcunaga rurarcayanqui taytay rurachipäcushungaytam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Niptinmi “Taytäcunaga Abrahammi” nirärin. Chaura Jesusga cay ninmi: “Gamcuna razonpa Abrahampa castan aywag carga, rurapäcunquiman pay rurangannuymi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nätan gamcunaga wanuchiyta munarcayämanqui ‘Razonpacagta Dios nimanganta’ niruptïmi. Abrahamga manam chaynuychu rurara. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gamcuna rurarcayanqui taytaycuna rurangannuylam”. Niptinmi paycunaga cay nirärin: “Nogacunaga manam capäcü churipäcuychu. Nogacunapaga juclay Dioslam taytäcuna cayan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chaura Jesusga cay ninmi: “Taytaycuna razonpa Dios captinga cuyapäcamanquimanmi. Nogaga Diospitam aywarayamüsi, nätan caychrüsi cayä. Nogaga manam aywamusha cä quiquiläpitachu, antis Dios cachramasha captinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gamcunaga niyangäta mana tantiayta atipapäcunquichu imaysi, rimayangäta mana mayacuyta munapäcurmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gamcunapaga taytaycuna cayan Asyagmi. Pay munangantam gamcunaga rurayta munarcayanqui. Asyagga galayunanpita-pacham runa wanuchig, nätan payga manam imaysi razoncagpita rimanchu. Manatan imaysi razoncagtaga rimarapishchu. Nä rimarga casquitam riman, casquilata rimag car. Jinamanga paymi chay casqui rimagcunapa taytan. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nätan nogataga razoncagta rimaptïmi mana chrasquicarcämanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Maygaytag gamcunapita ‘Caytam juchäcurayanqui’ nipäcamanquiman? Nätan razoncagta rimayaptïga, ¿imanirtag ‘Payga Diospitam’ mana nipäcamanquichu? ");
INSERT INTO qvnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diospacagga pisi cäsucunmi Dios rimanganta, nätan gamcunaga Diospa mana capäcurmi cäsucuyta mana munapäcunquichu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chaura chay castäcunaga Jesús niruptinga cay nirärinmi: “Nogacunaga alitamau Samaria runanuysi pengapaypagmi, jinaman Asyagpa munayninchrümi cayanqui” nircayag. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nipäcuptinmi Jesusga cay nin: “Nogaga manam Asyagpa munayninchrüchu cä, antis nogaga Tayta Diostam alawayä. Jinatam gamcunaga nätan ashlircayämanqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nogaga manam munächu alawasha cayta. Alawasha canäta juc munayaptinsi. Payga juchacuna taripagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Shumag mayacurcay: Pisi rimayangäta cäsucamagga manam imaysi wanungachu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Niptin chay castäcunaga cay nirärinmi: “Cananga shumagmi musyarärï Asyagpa munayninchru cayangayta. Abrahamwan Diospa unay willacugnincunaga lapanmi wanupäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nätan ‘Noga ningäta cäsucamagga manam imaysi wanupäcungachu’ nircayämanquim. ¿Gamga cayanqui taytäcuna Abrahampitaga mas alinnincagchu? Payga wanusham, nätan wanupäcushatan Diospa unay willacugcunas. ¿Gamga mayganmi cayä ninquitag?”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nipäcuptin Jesusga cay ninmi: “Quiquï alawacuptïga, chay alawacuyangäga manam välinchu. Nätan nogataga alawäman. ‘Diosnïcunam’ nircayangay Dios-mayïmi nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nätan gamcunaga manam reguepäcunquichu payta. Nogam icha regueyäga. ‘Manam payta reguëchu’ nirga cäman gamcunanuysi casquim. Nätan nogaga regueyä razonpam, jinaman cäsucüsi pay nimangantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taytaycuna Abraham cushicuram unay, cayman aywamunä junagpita. Nätan aywamugta ricaramar aliscam cushirura”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Niptin chay runacunaga cay nirärinmi: “Manaran pichga chrunca watayogsi canquiragchu. Nätan ¿‘Abrahamta ricapurämi’ ninquichu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nipäcuptinmi Jesusga cay nin: “Mayapäcamay shumag: Nogam cayä chay ‘Nogam cayä’ ninganga. Chauraga Abraham manaragsi näcimungalanpitam noga Diosga cayä”. ");
INSERT INTO qvnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Niptinga rumitam charirärin Jesusta gompapäcunanpag. Payga nätan pacacurunmi. Chaypitam Diospa wayinpitaga runacunapa chraupinpa yargorcur aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chaypitam Jesusga aywayanganchru ricapurun näcimunganpita-pacha ñausha runata. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Paypitam discïpuluncunaga tapurärï cay nir: “Yachrachig, cay runa ñausha näcimunanpag ¿pipatag juchan? ¿Quiquin runapachu, icha taytanpawan mamanpachu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nipäcuptïmi Jesusga cay nipäcaman: “Cayga ñausha cayan manam quiquinpa juchanpitachu ni taytancunapa juchancunapitapishchu, antis chaynuy cayan Tayta Dios munayniyog canganta paychru reguechicunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Junagcuna cayangancama uryashagran cachramagnï ruranäpag nimangancunataga, nätan nämi aywayämun juc pagasnuysi. Chaychrüga manam pisi uryayta atipanganchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cay pachachru cayangäcamaga cayä juc achquinuymi cay pachachru runacunapag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chay nircurmi Jesusga pampaman togarpuyur rurarun uchuc isgueralata dëdunwan. Jinarcurmi chaywan lushirun chay ñaushapa ñawinta. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chaypitam cay nin: “Ayway Siloé ningan gochranyaman”. (‘Siloé’ ninanga ‘cachray’ ninanmi.) Chaura ñaushaga aywacunmi. Jinarcurmi maylacurcurga nä ricapuyar aywacun. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chauraga chay ñausha yachranganpa yachragcunaga, nätan ñausha canganta ricagcunaga cay nipäcuram: “¿Manachu cayga golgueta manacuyar tayag runa?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nipäcuptinmi waquinga “Au, paymi” nipäcura. Waquinmi “Pay nirayanmi” nipäcura. Nätan payga “Chay quiquinmi cayä” nira. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chauraga tapurärira: “¿Imanaypatag cananga ricapuyanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nipäcuptin payga cay ninmi: “Jesús nipäcungan runam isguerata rurarcur lushiraman ñawïta. Chaypitam ‘Siloé ningan gochranyata maylacug ayway’ niraman”. Nimaptinmi aywarä. Jinarcurmi maylacururga ricapurü. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Niptinga tapurärin: “¿Maychrütag cayan chay runa?” Nipäcuptin payga “Manam musyächu” niram. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chaura runacunaga pusharärin chay ñausha cuticashatash fariseocunapa naupanman. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nätan Jesús chay ñaushata isguerawan lushircur cuticächinan junag cara jamana junagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chauraga fariseocunash chay runataga tapurärintag imanuypa ricapungantas. Chaura payga cay ninshi: “Ñawïtam isguerawan lushiraman chayta maylacururmi cananga ricapuyä”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Niptinshi waquin fariseocunaga cay nipäcun: “Chay rurag runaga manam canmanchu Diospitaga jamana junagta mana cäsuyarga”. Nätan waquincunash nipäcun: “¿Imanaypatag mana pisi ruray atipänanta cayga ruranman juchasapa carga?” nirga, juc ishcay puntaman raquicarärinag. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chaura chay ñausha cuticashatam yapay tapupäcusha cay nir: “Nätan gamga ¿pimi ninquitag chay ñawiqui cuticächig runata?” Nipäcuptin payga “Nogapitaga Diospa willacugninmi” nisha. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nätan Israel castacunapa mandagnincunaga “Yangam cay runaga ‘Ñaushapitam cananga ricapuyä’ niyan” nipäcuram, chay runapa taytanwan mamanta gayapäcungancamaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nä chraruptinga tapurärin cay nirmi: “¿‘Ñausham näcimusha wamraläga’ nipäcungaychu cay runaga cayan? ¿Imanuypatag cananga ricapuyan?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nir tapupäcuptinga cay nirärinmi: “Au. Musyarcayämi cay runa wamräcuna cangantas, jinaman ñausha näcimungantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nätan manam musyapäcüchu imanuypa ñawin cuticangantas ni pi cuticächingantas. Nä chacha runam cayan. Tapupäcuy quiquinta nipäcushunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chaynuypa nipäcusha paycunata manchacurcarmi. Chaypagga nämi Diospa wayinchru chay mandagcunaga rimanacarärinag “Jesusga razonpa salvacugmi” nigcagta pitas chay Israel castäcuna gotucarcänan wayipita gargosha capäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chaymi mamanwan taytanga “Payta tapupäcuy, nä chacha runam” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaura chay mandagnincunaga yapaymi gayarärin chay ñausha cuticashata. Chaypitam cay nirärin: “Diospa naupanchrümi cayanchi. Nipäcamay razoncagta. Nogacunaga shumagmi musyarcayä chay cuticächishugniqui runa juchasapa cangantam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nipäcuptinmi payga cay nisha: “Manam noga musyächu juchasapa cangantas u mana cangantas. Musyayäga ñaushapita cuticächimangalantam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Niptinga yapaymi tapurärin: “¿Imanarushuraytag? ¿Imatam rurarushunqui ñawiqui ricapunanpag?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nipäcuptinmi payga cay nin: “Nämi nipäcurag. Gamcuna manatag mayaytas munapäcuraychu. ¿Imanirtag yapay mayayta munarcayanqui? ¿Gamcunas paypa discïpulun caytachu munarcayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Niptinga ashliytam galacayärin cay nir: “Gamchri cayanqui chaypa discïpulunga. Nogacunaga capäcü Moisespa discïpulunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nogacuna musyarcayämi Moisesta Dios rimapanganta. Nätan chay cuticächishugniqui runataga manam musyapäcüchu maypita cangantas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nipäcuptinmi runaga cay nin: “¡Chay rimayniquicunaga mayaräcuypagtag! ¿Gamcuna manachu tantiapäcunqui maypita cangantas ñawïta cuticarayächimaptin? ");
INSERT INTO qvnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Noganchiga musyayanchim juchasapacunata Dios mana mayanganta, nätan payta alawagcunalata, jinaman cäsucugnincunalata mayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manam imaysi mayaranchichu juc ñausha näcimushata pisi cuticächinganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nätan cay runa Diospita mana aywamusha carga, manam ima ruraytas atipanmanchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Niptinmi cay nirärin: “¡Näcimungaypita-pacha gam juchasapachu nogacuna yachrachipäcamayta munayanqui!” Nirmi chay Israel castäcuna gotucarcänan wayipita gargapäcusha, paycunapita juc wanushapagnuy ricasha cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nätan Jesusga musyaruram chay cuticasha runata chaynuy rurapäcunganta. Chaypitam tincurur chay runata Jesusga cay nin: “¿Gamga jana pachapita shamusha runata chrasquicunquimanchu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Niptinmi runaga cay nin: “Tayta, ¿pitag chay cayan? Niyämänar chrasquicunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Niptin Jesusga cay nin: “Nämi ricapusha canqui. Nogam cayä gamwan rimayagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaura niptin runaga Jesuspa naupanmanmi gongorpacuyur: “Salvamagnïmi cayanqui” nirmi chrasquicurun. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Niptinmi Jesusga cay nin: “Cay pachaman noga shamurä ñaushanuysi cayagcuna tantiacurcänanpagmi, nätan ricapuyagnuysi cayagcuna ñaushanuysi capäcunanpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nigta mayarärirmi juc ishcay paywan chaychru cayag fariseocunaga cay nirärin: “Nogacunaga manam capäcü ñaushanuychu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nipäcuptinmi Jesusga cay nin: “Gamcuna razonpa chay ñaushanuysi chrasquicarcämarga mana juchaynagmi capäcunquiman. Cananga nätan ricapuyarsi mana chrasquicarcämangaypitam chaynuy juchayogla capäcunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Mayapäcamay shumag: Pi maysi uysha canchraman mana puncupa yaycugga, maypas jucläpa yaycugga capäcun suwawan imas lutan ruraglam. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nätan chay canchra puncupa yaycugga cayan uyshacuna michigmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Paytaga chay puncu cuidagsi quichranmi yaycunanpag, nätan uyshacunas shiminta mayanmi. Chay michigga uyshacunatas jutinpa camam gayan. Chaypitam jorgamun washaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nä lapanta jorgarcamurga chay uyshancunapa naupantam aywan. Jinatam uyshancuna gatirapäcun michigninpa shiminta reguepäcur. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nätan mana reguengantaga manam gatirapäcunchu, antismi jucpa shiminta mayarurga gueshpicurcan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús chaynuy tincuchiypam yachrachira. Nätan paycunaga manam tantiapäcurachu ima niyta munayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chaura Jesusga yapaymi cay nin: “Razoncagtam nircayag: Nogam cayä uysha canchraman yaycuna puncunuy runacunapag. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","‘Diospitam aywarayämü’ nigtucugcuna lapansi capäcun suwacunam jinaman lutan ruragcunam. Nätan uyshacunaga manam cäsupäcushachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nogaga nätan cayä chay canchra puncunuymi. Pi maysi nogapa yaycugga salvasham canga. Chaypitam yaycunga jinaman yargamunga. Nätan micushanuymi canga. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwaga aywamun apanalanpagmi, wanuchinalanpagmi, wichicächinalanpagmi. Nätan nogaga aywarayämü imaycamas ali cawapäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Noga cayä ali michigmi. Ali michigga wanunmi uyshancuna raygo. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nätan pi maysi gänanan raygola uryagga, micug aywamugta ricapururga uyshacunata dëjarcurmi aywacun. Chaynuy jinan mana uysha michig carmi, nätan mana paypa uyshan captinmi. Chaura atog charirga wichicächinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay runaga aywacun gänanan raygola uryarmi, nätan uyshacunatas manam cäsunchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nogam cayä alisca ali michigga. Regueyämi uyshäcunata, nätan nogatas reguepäcamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nogatachu Dios-mayï regueman. Nätan nogachu payta reguë chaynuymi. Jinaman wanushagsi chay uyshäcuna raygom. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cayäpaman masmi uyshäcuna, cay canchrachru manacagcuna. Paycunatas aywachimushagmi, nätan cäsucapäcamangam paycunaga. Chauraga canga juclay canchralachrümi lapan, jinamanmi canga juclay michigla. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Dios-mayï nogata cuyaman ‘Caycuna raygo nogam wanushag’ niptïmi. Nätan nogaga gangalantam cawacämushag. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Manam pisi wanuchimanchu nogataga, antis quiquï munarmi nogaga paycuna raygo wanuyta munä. Nogapagga munaylachrümi cayan paycuna raygo wanuysi, nätan cawacämuysi. Chaynuy ruranäpagmi Tayta Dios nimasha”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nigta mayarur chay castä mandagcunaga yapaymi ishcay puntaman raquicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Achcam paycuna casta cay nipäcura: “¿Imanirtag cäsucurcayanqui Asyagcunapa munayninchru cayagta, jinaman löcusha cayaptin?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nätan waquinmi cay nipäcura: “Manam pisi Asyagpa munayninchru cagga, caynuy rimaytas ni ñaushacuna cuticächiytas atipanmanchu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Chaura Jerusalenchrüga cayara Tayta Diosta yapay ‘Gampa cay wayiquiga cachun’ nipäcungan fiestam. Nätan caras tamya wichanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chaura Jesusga puriyara Diospa chay wayinchrümi Salomonpa ramädan ninganchru. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chaypitam chay castä mandagcunaga muyurärin jinarcurmi cay nirärin: “¿Imaycamatag shuyag shuyagta cachipäcamanqui? ‘Salvacugtam cachramushag’ Dios ningan gam carga juclar willapäcamay shumag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nipäcuptinmi Jesusga cay nin: “Nämi nipäcurag, nätan ‘Manam razonchri’ nir chrasquipäcamaraychu. Dios-mayï nimanganta rurangäcunachrümi musyacayan shumag noga pi cangäsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nätan gamcunaga manam ‘Payga razonpa Diospitam’ nipäcamanquichu, mana nogapa runäcuna casta capäcur, naupata uyshacunapita rimapangänuysi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nogapa uyshäcunaga reguercayanmi shimïta. Nätan nogasi reguëtan paycunata, jinaman cäsucarcämanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nogaga paycunata cawachishagmi imaycamas, nätan manatan imaysi wanupäcungapishchu ni pisi jorgapäcungapishchu maquïpitas. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Paycunata gomag Dios-mayïga pipita maypitas mas munayniyogmi. Paypa maquinpitaga manam pisi quïtayta atipanmanchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Paywan nogaga capäcü Diosmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Niptin chay castä mandagcunaga yapaymi rumita charirärin gompapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chaura Jesusga cay ninmi: “Alicusa achcatam ima-ayga alicunatas rurasha cä gamcuna ricarcayämaptiqui chay Dios-mayïpa munayninwan. Cananga ¿maygan rurangäpitam chapipäcamanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Niptinmi chay castä mandagcunaga cay nirärin: “Manam nogacunaga chapipäcushay chay ali rurangaycunapitachu, antis Diosta ashlingaypitam, nätan runala cayar Diostucungaypitam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nipäcuptinmi Jesusga cay nin: “Gamcunaga ‘dioscunam carcayanqui’ niyanmi isquirbishachrüga. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chaura chay cäsucugcunata ‘dioscunam’ niyaptinchu ¿chay isquirbishacunaga manacagman chrurasha canga? ");
INSERT INTO qvnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Chauraga Tayta Dios munanganta ruranäpag acrarayämaptinga, jinaman cay pachaman cachrarayämaptinga ¿imanirtag gamcunaga nätan ‘Diostam ashliyanqui’ nircayamanqui, Diospa-mayin cayaptïga? ");
INSERT INTO qvnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tayta Dios nimangancunata mana rurayaptïga ama chrasquipäcamaychu. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nätan pay nimanganta ruraptïga, mana nogata chrasquimarsi ‘Cayga razonpa Diospitam’ nipäcuy, rurayangäcunalatas. Tayta Dios nogachru canganta, nätan noga Tayta Dioswan cayangäta cananpita shumag musyapäcunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Niruptinga Jesús chariruytam yapay munapäcura, nätan payga maquincunapitam gueshpirura. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chaura Jesusga cutira nogacunawanmi Jordán mayuman inti yargamun läduman, naupata Juan bautizangancagman. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Runacuna achcam aywapäcura Jesús ricag. Jinarcurmi rimapäcura cay nir: “Juanga manam rurashachu mana runa ruray atipänantaga. Nätan cay runapita Juan rimanganmi icha cayanga lapansi razoncagla” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaychru achcam runacuna “Payga Diospitam razonpa” nir chrasquicurcasha lapan shongonpa. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chauraga gueshyarunag Lázaro nipäcungan runam. Payga yachrara Betania ichic marcalachrümi ishcay paninwan. Paycunapa jutin cara Mariawan Martam. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chay gueshyag Lazaropa panin Mariam cara taytanchipa chraquinman perfümita jirpurcur chay agchanwan chaquichig. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chauraga chay panincunam ishcay junag camiñu aywanata cachrarärimunag Jesusman “Tayta, cuyangaymi gueshyayan” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nipäcugta mayarur Jesusga cay ninmi: “Cay gueshyaga charirun manam imaycamas wanusha cananpagchu. Antis chay gueshyaga charirun Dios munayniyog cananganta musyapäcunanpagmi, jinaman Diospa-mayin munayniyog cangäta runacuna musyapäcunanpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusga aliscam cuyara Martatas nanantas turin Lazarotas. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nätan Lázaro gueshyayanganta musyayarsi chaychru cara ishcay junagran. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaypitam discïpuluncunata cay nipäcaman: “Aywashun yapay Judeata”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nipäcamaptinmi nogacunaga cay nirärï: “Yachrachig, quima chruscu junaglaragtag cayan wacchru mandagcuna chapiypa wanuchiyta munapäcushungay. Nätan ¿yapaychu wac aywayta munayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nipäcuptïmi Jesusga cay nipäcaman: “Manam üraragchu wanuchipäcamänanpag. Chrunca ishcayniyog üratam noganchiga juc junag ninchi. ¿Au? Chaura junagpa purirga manam mitcanchichu achicyaptin. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nätan pagaspa purirga mitcanchi mana achicyaptinmi. Chaynuymi mana wanuchiyta atipapäcamangachu mana ürä chrämuptinga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nircurmi Jesusga cay nin: “Cuyanacunganchi Lazaroga nämi jamayan. Nätan aywayä sharcachigmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nipäcamaptin discïpuluncunaga cay nipäcümi: “Tayta, chaura jamayarga sharcungachri”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nätan Jesusga Lázaro wanusham nipäcamänagmi. Chaytam nogacunaga tantiarärinä jamaypita rimayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaura Jesusga shumagmi musyarärichiman cay nir: “Lazaroga wanusham. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Cushirayämi chaychru mana cangäpita. Chaynuy mana cangä gamcunapag mas alim, ‘Payga razonpa Diospitam’ nir mas yupachicarcämänaypag. Chauraga aywashun ricag” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nipäcamaptinmi mellïshu nipäcungä Tomasga: “Noganchisi aywashun paywan parëju wanunanchi captinsi” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nä Betaniaman chrarur Jesusga Lazarota tarirun nä chruscu junag enterracusha cayagtam. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Chay marca cara manam alä caruchrüchu Jerusalenpita. Caraga lamitä lïwapita mascascalam. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nätan achcam Diospa wayinchru uryagcuna aywarärimunag Martata Mariata “Amar wagaychu turiquipita” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Chaura Martaga nä wayinman nachrgayagta Jesuspita musyarurga yargaramun taripacugmi, nätan Mariaga wayinchrümi quëdaramunag. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chaura Martaga Jesusta cay ninmi: “Tayta, caychru gam captiquiga manachr wanunmanchu cara turilä. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nätan musyayämi Diosta canan manacuruptiqui mayashunaytas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Niptinmi Jesusga cay nin: “Turiquiga cawacämungam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Niptinmi Martaga cay nin: “Au. Musyayämi wanushacuna cawacämunan junagchru cawacämunanta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chaura niptinga cay nirunmi: “Nogam cayä wanushata cawacächimugsi, nätan cawachigsi. Pi maysi chrasquicamagga wanursi cawacämungam. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nätan lapan cawayagcunasi chrasquimagga manam imaycamas wanushalachu capäcunga. ¿Cay niyangäta ‘Razonmi’ ninquichu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Niptinmi cay nin: “Au tayta. Cananga shumagmi musyarü ‘Salvacugtam cachramushag’ Dios ningan jinaman Diospa-mayin gam cangayta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nircur Martaga aywacun nanan María gayagmi. Jinarcurmi japalanta cay nin: “Yachrachigmi chrarayämun. Gamtam gayayäshunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Niruptin Mariaga pasay-pacham aywaramunag. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Chaypagga manam Jesusga yaycuraragchu marcaman. Cayara Martawan tincungalanchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chaura María wayrala sharcurcur yargamugta ricarärirga chay wayinchru cayag runacunaga gatirapäcamunag “Mïchucagtachr aywayan wagag” nipäcurmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chaura Jesús cayanganman María chraramurga, Jesuspa naupanmanmi gongorpacuyun cay nir: “Tayta, caychru gam captiquiga manachr wanunmanchu cara turilä” ");
INSERT INTO qvnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","nir, wagacuptinga, jinaman paywan carcayag runacunatas wagarcayagta ricapururga Jesusga aliscam laquicurun jinamanmi cuyaparun. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chaypitam tapurun: “¿Maymantag enterrarärinqui?” Niptinmi “Tayta, shamuy ricanaypag” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nätan Jesusga wagacunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chaura chay sacerdöticunapa mandagnincunaga “¡Jay, aliscachrau cuyara!” nipäcunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nätan waquincagmi runacunaga “Cay runa chay ñaushapa ñawintas cuticayächirga manachrau imalatas rurayta atiparachu Lázaro mana wanunanpag” nipäcuratan. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chaura Jesusga yapay alisca laquisham mïchucagman ashuyurun. Chay mïchu canag juc machraymi juc jatun lagta rumiwan wichrgasha. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chaura Jesusga “Rumita jorgapäcuy” ninmi. Chaymi wanushapa panin Martaga cay nin: “Tayta, nächri asyarirayan, nämi wanunganga chruscu junag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Niptin Jesusga cay ninmi: “¿Manachu nogaman yupachicurga Dios munayniyog canganta ricanquim nirag?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chauraga jorgarärin rumitam. Chaypitam Jesusga jana pachata rircärir cay nin: “Tayta, ‘Gracias’ nicug, gamta manacungänuy rurangaypitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Noga musyayämi chaynuyla mayamangayta. Nätan niyagsi caychru runacuna, ");
INSERT INTO qvnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","gam cachramangayta musyarur yupachicarcämänanpagmi”. Nircurmi gayacuypanuy: “¡Lázaro, yargamuy chaypita!” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chaura wanushaga yargaramun maquinpita, chraquincama inchrasham. Nätan cäranmi juc sagpiwan wancusha. Chaura Jesusga “Pasquipäcuy purinanpag” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chauraga María ricag chay aywamusha sacerdöticunapa mandagnincunaga achcam chrasquicarärin Jesusta chay Lázaro cawacächimugta ricarärir. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nätan waquinmi aywapäcusha fariseocunaman Jesús chay ruranganta willapacug. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaura fariseocunawan sacerdöticunapa waquin mandagnincunaga gotucarärinag quiquin mandagcamalam rimanacurcänanpag. Chaychrümi cay ninacurcasha: “¿Imatatag rurachwan chay runata? Aliscatag ima-aygatas rurayan mana pisi ruray atipänancunata. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jinata rircarashaga cay runanchicunaga lapanmi chrasquicaräringa. Jinatam Romachru mandagcunaga aywarcärimur Diospa wayintas jinaman noganchi acrashan runancunatas imantawansi pampanman rurarämäshun”. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nätan nipäcuptinshi paycuna castapita Caifás nipäcunganga, chay wata Diospa wayinchru mas mandagnincagga cay nin: “Gamcunaga manam musyapäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Manatan tantiapäcunquipishchu alitaga. Nogapitaga cay lapan runacunapa janan juclay runalam wanunman lapanchita ushamänanpitaga” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nätan Caifás chaynuy nira manam quiquinpa yarpaylanpitachu, antis nira chay wata Diospa wayinchru mas mandagnincag carmi, Tayta Dios rimachiptin, Israel casta runacunapa janan Jesús wanunanpita. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Manam cay runacunalapagchu, antis Diospa lapan castancuna maychru chaychru cagtas juclaman gotunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chaura chay junagpitam chay mandagcunaga rimanacusha capäcura Jesusta wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chaymi Jesusga nä mana purirachu chay mandagcuna ricayga. Antis Judea ninganpitaga yargor, aywacura jäpag pampaman Efraín ningan marcacagpam. Chaychrümi Jesús cara nogacuna discïpuluncunawan. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chauraga nämi pasay nachrgarayämura Pascua nipäcungä fiestäcunapag. Jinarcurmi chay marcacunapita runacunaga achca aywapäcura Jerusalenta manaragsi fiesta chrämuptilan Dios ningannuy maylacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chaura chay runacunaga Jesustam ashipäcunag, nätan Diospa wayinchrüga tapucurcänag jucta juctam: “¿Ima nipäcunquitag? ¿Aywamungachur fiestaman icha manachur?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nätan fariseocunawan, sacerdöticunapa mandagnincunaga rimanacarärinag maychrüsi Jesús cayagta pisi musyarga willacurcänanpagmi, chaypita charig aywapäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chauraga sogta junagta nä Pascua fiesta galayunan cayaptinmi, Jesusga aywara Betaniata chay wanushapita cawacächimungan Lázaro yachranganta nogacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chaychrümi yanupäcarärin cënata Jesusta garapäcunanpag. Chaura Marta garachracuyaptin Lazaroga, Jesuswanmi mësacagman iscatararcayara. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chaymanmi Mariaga chrarachimun nardupita rurasha perfümita juc botëllawan alisca golgue chraninta. Jinarcurmi Jesuspa chraquinman jirpurcur, agchanwan chaquirachin. Chaypita wayiga ima-ayga shumag asyarun. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chaura Simonpa churin Judas Iscariotega chay wanuchipäcunanpag Jesusta reguechigga cay ninmi: ");
INSERT INTO qvnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imanirtag quima pachrac junag gänanachru mana ranticururanchichu cay perfümita mana imaynagcunata yanapänanchipag?” ");
INSERT INTO qvnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasga chaynuy nira manam paycunata cuyaparchu antis suwa carmi, nätan golgue runcu charanganpita jorgochrag carmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chaura Jesusga cay ninmi: “Jina rurachun. Caytaga chrurarächira wanunä junagpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mana imaynagcunaga gamcunawanmi imaysi cayanga. Nätan nogaga manam chaynuylachu cashag gamcunawan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Chaura Israel castäcunaga achcam musyapäcusha Jesús Betaniachru cayanganta. Jinarcurmi chrarärimun chayman. Manam aywapäcamusha Jesús raygolachu, antis chay wanushapita cawacämusha Lázaro ricagnuymi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Chaura Diospa wayinchru mandagcunaga rimanacarärinag Lazarotas wanuchipäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Paypa janan achca castäcuna chay mandagcunapita raquicarcur Jesusta chrasquicurcaptin. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Alicusa achcam runacuna Jerusalenman aywapäcamusha cara chay Pascua fiestapag. Jinarcurmi musyarärinag Jesús chay marcaman warantin chränanta. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chauraga rämacunata apacurcurmi yargarärimunag Jesús chrasquicug gayacuypanuy: “¡Salvapäcamay! Alisca ali nisha cachun Munayniyog Diosninchi cachramungan. ¡Alisca ali nisha cachun Israelcunapa reynin!” nircayar. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nätan Jesusga püllu ashnuta tarircurmi logacurun isquirbishachru ningannuy. Chaychrüga cay niyanmi: ");
INSERT INTO qvnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ama manchacaychu Sión gotuchru yachragcuna. ¡Rircaripäcuy ashnuta logacurcur reyniqui aywayämugta!” niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Caycuna ruracayanganta galayunalanchrüga manam pasay tantiapäcurächu nogacunaga. Chaypita nä Jesús jana pachaman aywaruptinran yarparärï lapan caycuna paypita isquirbisha canganta. Jinaman chay isquirbishanuyla paywan ruracanganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nätan Lazarota mïchupita gayagta, jinaman cawacächigta ricag runacunam willapacarärinag ricapäcunganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaymi runacunaga yargarärimunag Jesusta chrasquicug, mana pi runas ruray atipänanta ruranganta musyarärir. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chaura fariseocunaga quiquincamash cay ninacarärin: “Chägar manatag Jesusta ima ruraytas atipanchichu. Rircaripäcuy lapan runacunam aywacurcan guepanta” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jinarcurmi Diosta alawapäcunanpag fiestaman Jerusalenta aywamusha juc casta runacunaga juc ishcay, ");
INSERT INTO qvnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ashuyarärin Felipeman. Payga cara Galileachru Betsaida marcapitam. Jinarcurmi cay nirärin: “Tayta Felipe, tincuytam munarcayä Jesuswan niyäripamay”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nipäcuptin Felipega aywarcur Andrestam nirun. Jinarcurmi ishcaynin Jesusta willarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chaura Jesusga cushisham cay nin: “Nämi chraramun noga jana pachapita shamusha runa, Dios cayanganman cuticunä junag. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mayapäcamay shumag: Juc trïgu mana alpaman ishquirga, gangalanmi cacun imaycamas, nätan alpaman ishquirurga achcatam camacun palanapag. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pi maysi quiquin munangannuyla cawagga manam cawangachu nogawan. Nätan pi maysi cay pachachru wanunan captinsi cäsucamagga nä cawayan nogawanmi imaycamas. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pi maysi nogapag cawayta munagga cäsucamächun, nätan cäsucamagga noga cangächrümi canga. Jinamanga Dios-mayïpitas alinninpag ricasham canga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nircurmi Jesusga cay nin: “Cananga manam pasay imananäsi musyacanchu. ¿Ima nishagtag ‘Tayta Dios, salvamay canan pasamänanpita’ nishagchur? Manam. Antis nogaga aywarayämü chaypagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nircurmi “Reguechicuynar Dios-mayï, alisca munayniyog cangayta”. Niptinga jana pachapitam mayarärï cay nimugta: “Nämi reguechicusha cä. Nätan yapaymi reguechicushag alisca munayniyog cangäta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Niptinga chaychru cayag runacuna mayarärirga “Räyum” nipäcunmi. Nätan waquinga “Juc angelmi rimaparun” nipäcuntan. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chaura Jesusga cay ninmi: “Cay rimamugta mayarunchi manam nogapagchu, antis gamcuna pi cangätas musyapäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cananmi cay pachachru juchacuna taripacanga. Nätan cananmi cay pachachru munayniyog Asyagsi washaman gargosha canga. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nätan nogata gueruman nä warcarärimaptinga lapan runam nogaman aywamunga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chaynuypa nira, imanuypa wanunantas tantiachipäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Niptin runacunaga nipäcunmi: “Nogacunaga chay isquirbishacunata leyiptin, mayacurcarä Cristo imaycamas cawacug cangantam. Nätan ¿imanirtag ‘Gamga jana pachapita shamusha runaga sharcachisharan canga’ niyanqui? ¿Pitag cayan chay jana pachapita shamusha runaga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nipäcuptinmi Jesusga cay nin: “Ishcay quima junaglaga gamcunacagchru chay achquinuysi cayagga cashagran. Chauragar achquinuysi gamcunawan cayaptilan cawapäcuy nipäcushungaynuy, mayänipita chay juchalaychru mana quëdapäcunaypag. Pi maysi, yanauyagchru puriyagnuysi juchalanchrürag cawayagga manam musyanchu mayta aywayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chauragar gamcunachru juc achquinuysi cayaptilä chrasquicarcämay, cay achquinuysi cayagta, cay achqui cayagnuysi capäcunaypag”. Chaycunata nircurga, Jesús aywacuram. Nätan manam ricapachicurachu chay runacunawan. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maymayta paycuna ricayaptin Jesús munayninwan rurayaptinsi manam chrasquiyta munapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Diospa unay willacugnin Isaiaspa isquirbishan ningannuy ruracänanpagmi. Payga cay niram: “Tayta, gamga musyachiraymi munayniyog cangayta. Nätan manam pisi chay willapacurcangäta chrasquicurcashachu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chaynuy mana chrasquicurcaptinmi Isaiasga isquirbisha cay nirsi: ");
INSERT INTO qvnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Paycunaga ñaushanuy caytam munapäcun, nätan rumi shongom capäcun, chaymi ñaushanuysi mana tantiapäcunchu. Manatan nogamanga cutipäcamunchu ni cuticächinäpagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías chaynuy nira Jesús munayniyog canganta musyarmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chaynuy isquirbishacuna niyaptinsi achcam marca mandagcunas chrasquicurcara Jesusta. Nätan Jesusta chrasquicugcuna manam willapacurcarachu pitas fariseocunata manchacur, chay Israel castäcuna gotucarcänan wayipita mana gargachicusha capäcunanpita, chaynuypa juc wanushapagnuy ricasha capäcunanpita. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Paycunaga runacunapita alipa ricasha caytam munapäcug, nätan manam Diospita alipa ricasha caytachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chaura Jesusga gayacuypanuymi cay nin: “Pi maysi ‘Payga razonpa Diospitam’ nir chrasquicamagga, manam nogalatachu chrasquicaman, antis chrasquiyanmi cachramagnïtas. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nogata ricapamagga, ricapuyanmi cachramagnïtas. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Achquinuysi nogaga shamurä cay pachaman, chrasquicamagcuna yanauyagchrünuysi mana juchalanchru capäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nätan maygansi rimangäta mayayar mana cäsucamagta manam ‘Juchanpita cunchuchun’ nïchu. Nogaga manam aywamurä runacunata ‘Jina cunchuchun’ ninäpagchu, antis salvanäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pisi ‘Nogata manam Diospitachu’ nimagga, jinaman willacuyangäta mana cäsucamagpagga cayan jucmi ‘Jina cunchuchun’ ninanpag. Cay willayangämi ushanan junagchrüga ‘Cunchuchun’ nipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nogaga manam rimä quiquiläpitachu. Cachramagnï Tayta Diosmi nogata nimara imata ninäpagsi u imata yachrachinagpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nätan musyayämi Tayta Dios mandanganta cäsucugcuna imaycama cawapäcunantas. Chaura rimaparcayag rimanäpag pay nimangalantam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua fiesta manaragsi galariptilanmi Jesusga nä musyara cay pachata dëjananpag, jinaman Dios-mayincagta aywananpag nä üra ayparayämunganta. Payga cay pachachru runancunata alisca cuyarmi wanura, nätan cuyaras wanungancamam. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chauraga cënarcayarämi, nätan chaypagga nämi Simonpa churin Judas Iscarioteta Asyagga tantiarachinag imanaypa Jesusta reguechinanpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusga musyaram Diospita shamungantas payman gangalanta cutinantas, jinaman lapan ima-aygata munayninman Dios chrurangantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaura Jesusga cënarcayaptïmi sharcurun iscatarayanganpita. Jinarcurmi catatanuysi chay alisca shumag jatirayanganta jorgorun. Jinarcurmi toällata cheglanman watacurun. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chauraga maylacurcänä gueshpi batyamanmi yacuta wiñarun. Jinarcurmi chraquïcunata maylarcur chay toälla watacunganwan chaquichiyta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nä Pedro nipäcungan Simonpa chraquinta maylananpag chraruptinmi payga cay nin: “Tayta, ¿gamchu chraquïta maylamanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Niptinmi Jesusga cay nin: “Cananga manam tantianquichu cay rurayangäta. Chaypitaran tantianqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Niptinmi Pedroga nin: “Manam gamga imaysi chraquïtaga maylamanquimanchu”. Niptinmi Jesusga “Mana maylapuptïga manam canqui nogapachu” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Niptin Pedro nipäcungan Simonga: “Chauraga tayta, ama maylamaychu chraquïlataga, maylamay maquïtawan umätas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Niruptinmi Jesusga “Nä maylashataga manam nä maylachwanchu yapayga. Lapansi nä maylasham cayan. Maylashäga chraquilaytam. Nätan gamcunaga carcayanqui nä maylashanuymi mana juchaynag, mana lapay carsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chaura manam lapaychu mana juchaynag capäcunqui” nirun, nätan wanuchipäcunanpag pi reguechinantas Jesusga nämi musyara. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chaypita nä chraquïcunata maylarcärimarga gangalantam jaticurun chay catatanuysi jorgongan jacunta. Jinarcurmi yapay cutirun chay micuyangancagman. Chaypitam cay nipäcaman: “¿Tantiarcayanquichu chraquiquicunata imanir maylangätasi? ");
INSERT INTO qvnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gamcuna gayarcayämanqui ‘Yachrachigpam’, nätan ‘Munayniyogpam’. Chaynuypa gayapäcamar, alitam nircayämanqui, nätan chaynuy captïmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Chauraga noga chay yachrachig, chay munayniyog, chraquiquicunata maylarayaptïga gamcunas maylapunacurcanquimanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Cayta rurayä gamcunas atendinacurcänaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mayapäcamay shumag: Maygan rantisha runasi manam mas munayniyogchu rantigninpitaga. Manatan cachra rurag runas mas alinnintagchu cachragninpitas. Nätan noga munayniyogsi cayta rurayaptïga gamcunaga masran rurapäcunquimansi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chaura caycunata nä musyarcayarga, jinaman rurapäcurga capäcunqui cushisham. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Cayta nircayag manam lapaypagchu. Noga musyayämi pïcunata acrangätas, nätan ruracangaran ‘Nogawan micugmi muyunga contrapartinman’ nir isquirbishaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cayta nircayag manas ruracaptilanmi, nätan ruracaruptin noga Dios cangäta shumagmi musyapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cayta shumag mayacurcay: Pisi cachrashäcunata chrasquicugga, chrasquicayäman nogatam, nätan nogata chrasquicamagga chrasquicuyan cachramagnïtam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chaynuypa nircur Jesusga alisca laquisham willaräriman cay nir: “Razonpacagtam nircayag, gamcunapita jucmi wanuchipäcamänanpag reguechimanga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chaura nipäcamaptinga rircanacuytam galacayärï maygäpita rimayangantas mana musyarga. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Chaypagga Jesuspa cuyay discïpulunga cënayarä Jesuspa naupanchru iscatarayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chaura Pedro nipäcungä Simonga sëñasyaraman maygäcunapita rimayangantas tapunäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chauraga Jesuspa pëchuncagman muyurcurmi yachraylapa tapurü: “Tayta, ¿maygäcunatag cayä?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Niptïmi Jesusga niman: “Atgag jitagman tantata ogorcachir gongämi canga” nircamarga, uchuc tantalata ogorcachirmi goyurun Simonpa churin Judas Iscarioteta. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chaura Judas tantata chrasquiruptilanmi Asyagga munangan rurachiyta galacuyun. Chaura Jesusga cay ninmi: “Ruranayta ruray wayrala”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Niptinga manam maygaläsi chay mësachru carcayagga tantiayta atipapäcurachu imanir chaynuypa niyangantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chaura Judas golgue runcu charag captinga waquinnïga tantiarärï fiestapag imatas rantimuy Jesús niyangantam u mana imaynagcunata imalatas gomunantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas nä tantata chrasquirurga aywacunmi, nätan nä chacagmi cara. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chaura nä Judas yargoruptin Jesusga cay nipäcamanmi: “Cananmi noga, jana pachapita shamusha runaga reguechicushag imapag aywamungätas, nätan Tayta Diossi reguechicuyan noga rurangäpam alisca ali canganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chaura Tayta Dios nogawan ali canganta reguechicurayaptinga, Tayta Diossi quiquinmi reguechinga runacunata nogas alisca ali cangäta, nätan reguechinga pasay-pacham. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cuyay wamräcuna manam alä unaychu cashag gamcunawan. Gamcuna ashipäcamanquim, nätan chay mandagniquicunata ningänuy niyärishay canan gamcunatas: Noga aywayangäman gamcunaga manam aywamuyta atipapäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nätan juc mushogtas niyärishay cäsucurcänaypag: Cuyanacurcanquim jucniquis jucniquis noga gamcunata cuyangänuy, gamcunas cuyanacurcayay jucniquis jucniquis. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chaynuy cawapäcuptiquiga lapan runam tantiapäcunga discïpulü capäcungayta”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Niptinmi Pedro nipäcungä Simonga Jesusta tapurun: “Tayta, ¿maytatag aywanqui?”. Niptinmi Jesusga “Noga aywangätaga manam cananga gatirämayta atipanquichu. Mas guepätaran aywamunqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Niptinmi Pedroga cay nin: “Tayta, ¿imanirtag canan mana gatiragmanchu? Nogaga camaricusham cayä gampa janay wanunäpagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Niptinmi Jesusga “¿Gamchu nogapa janä wanunqui? Razonpacagtam niyag, manarag gallo wagangancama nämi quima cuti nirayanqui mana reguemangayta” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Amar nä, ‘¿Imanashagrag ayganashagrag?’ nipäcuychu. Diosman yupachicurcayarga, nogamansi yupachicarcämay. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tayta Diospa jatun wayinchrüga achcam cayan yachranapag wayicuna. Chaynuy mana captinga nächri nirärigman cara, antis cananga aywayä maychru capäcunaypagsi camariglam. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chaypitam nä aywarurga maychru capäcunaypagsi nä camarircurga yapay cutimushag. Jinarcurmi noga quiquï chrasquicurcäshay gamcunas noga cangächru capäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gamcunaga musyarcayanquim may aywayangätas, jinaman musyarcayanquitan imanuypa chrämuytas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Niptinmi Tomasga cay nin: “Munayniyog, manam musyapäcüchu may aywayangaytas. ¿Imanaypatag chrapäcamüman chay aywayangayman?” ");
INSERT INTO qvnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Niptinmi Jesusga cay nirun: “Nogam cayä juc camiñunuysi chayman chrächigga, nogam cayä razoncagta rimagsi, nogatan cayä chay cawachicugsi. Mana nogaman aywamugga, manam pisi chrayta atipanchu Tayta Diosman. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nogata reguepäcamarga Taytätas reguepäcunquimanmi. Cananpitam nä reguercayanqui, nätan nämi ricapapäcuraysi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Niptinmi Felipega cay nin: “Munayniyog, regueyärichimay Tayta Diosninchita. Chaylatam munarcayä manam mastaga imatas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Niptinmi Jesusga nin: “Felipe, ¿nä may unaychri cayä gamcunawan, nätan manachu reguemanquirag? Pisi nogata reguemagga, reguesha nämi Tayta Diostaga. Chauraga ¿imanirtag manacayamanqui: ‘Diosta regueyärichimay’ nirga? ");
INSERT INTO qvnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manachu tantiapäcunqui Tayta Diospa-mayin cayangäta, nätan Dios-mayï pay cayanganta? Rimangäcunata manam rimapapäcug quiquïpa yarpaynïpitachu, antis nogawan cayag Tayta Dios nimangancunatam rimayäsi, rurayäsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chauraga Dioswan noga cayangäta, nätan Tayta Dios nogawan cayanganta razonmi nipäcuy, nätan mana chaynuy nipäcamarsi razonpa chaynuymi nipäcamay rurayangäcunalapas. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Shumag mayapäcuy cayta: Nogaman yupachicamagga ruranga noga rurayangätam, nätan rurangas mastaran noga Dios-mayïcagman aywacuptïga. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chauraga ima-aygatas nogata manacarcamaptiqui rurashagmi, Tayta Diosta alisca alipag noga Diospa-mayin ricachinäpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nogata imalata manacarcamaptiquis rurashagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Chaura razonpa cuyapäcamarga ningäcunata cäsucurcay. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nätan nogaga manacushag Tayta Diostam juc yanapagniquicunata cachramunanpag, gamcunawan imay aygaysi cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Chay razoncag Espirituta, shongon munangalanta ruragcunaga manam chrasquipäcunchu, mana ricarnin, jinaman mana reguermi. Nätan gamcunaga reguercayanquim gamcunawan captin. Chauraga payga munangantam rurachipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Manam dëjapäcushaychu juc wacchacunatanuyga. Cutimushagmi gamcunawan canäpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cananpita mana alä unaytam runacuna nä mana ricapapäcamangachu, nätan gamcunaga ricapapäcamanquim. Noga cawaptïmi gamcunas cawapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chay junagga tantiapäcunquim Tayta Dioswan noga cayangäta, gamcuna nogawan carcayangayta, nätan gamcunawan noga cayangätas. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pi maysi ningäcunata chrasquicur cäsucugga cuyamanmi. Nätan cuyamagtaga Tayta Diossi cuyangam. Nogas cuyamagtaga cuyashagtan, jinaman reguechicushagmi chay cuyamagwan”. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Niptinmi jucnincag Judasga cay nin: “Tayta, ¿imanirtag nogacunalawan reguechicunqui, nätan waquin runacunataga mana?” ");
INSERT INTO qvnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Niptinmi Jesusga nin: “Pi maysi cuyamagga ningätam cäsucaman. Chaura Dios-mayïga cuyangam. Jinarcurmi Dios-mayïwan noga aywapäcamushag paywan cawag. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pi maysi mana cuyamagga, manam noga ningäta cäsucamanchu. Nätan rimayangäta mayapäcungayga manam nogapachu, cayan chayga cachramagnïpam. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Gamcunawan cayälarmi rimaparcayag caycunata. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nätan nogapa trucä chay yanapapäcushugniqui Santu Espirituga Tayta Dios chay cachramunanga tantiachipäcushunqui lapan mana tantiay atipapäcungaytam. Jinamanmi yarpachipäcushunqui lapan rimapapäcungagta. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Payga ali cawaytam yanapapäcushunqui. Nätan nämi nirärig noganuy cawapäcunaypagsi. Cay gasila cawayga manam cay pachachru cagnuylachu. Chauraga ama ‘¿Imanashunrag?’ nipäcuysi ni manchacapäcuysi. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nämi mayarärinqui aywayämi ningäta, nätan gamcunawan canäpag yapay cutimunätas. Gamcuna razonpa cuyapäcamarga cushicurcanquimanmi Tayta Dioscagta aywayaptïga. Nätan Tayta Diosga nogapitaga mas munayniyogmi cayan. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cayta nircayag mana imas cayangancamalam nä imas captin razonpa rimangäta tantiapäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Manam nä rimapapäcushaychu aläpa unayga. Nämi nachrgayämun cay pachachru munayniyog Asyagga, nätan imata ruramarsi manam munangantaga taringachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chaynuymi ruracänan cayan Tayta Dios cuyangäta, cay pachachru runacuna musyapäcunanpag, jinamanga pay nimangannuylam rurayäsi” nircurga, “Sharcapäcuy aywashun caypita” nipäcamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Chaypitam aywarcayaptïga cay nin: “Noga cayä razonpacag üvas wiñayagnuymi. Nätan wac üvas wiñayagta uryapagnuymi cayan Tayta Diosga. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Payga mana wayugcag palgaycunataga jorgonmi, nätan wayugcag palgaynincunatam pichapan masta wayunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamcunaga willapäcungagta chrasquisha capäcurmi nä carcayanqui mana juchaynag. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nogawan chaynuyla cacurcayay, noga gamcunawan cayangänuy. Üvas plantapita tipicarurga manam chay räma quiquilanga atipanchu wayuyta. Chaynuymi gamcunas mana atipapäcunquichu Dios munangannuy cawayta, mana nogawan capäcurga. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nogaga cayä üvas wiñayagpa tullunnuymi, nätan gamcunam carcayanqui rämacunanuy. Pi maysi nogachru chaynuyla cayagga, nätan nogas paychru chaynuyla captïga, alisca alim cawan. Nätan nogapita raquirurga manam pasay ima ali ruraytas atipapäcunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pi maysi nogawan mana chaynuylacagga, washaman jitarisham canga. Jinarcurmi räma chaquinuysi, palarcur rupachisha canga. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Chaura chaynuyla nogawan capäcurga, jinaman yachrachingänuyla cawapäcurga, munangayta ima-aygatas manacurcangaytam chrasquipäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tayta Diosga alisca cushisham cayan gamcuna juc üvas planta alisca wayugnuysi noga ningänuy ali cawapäcuptiquiga. Chaynuy cawarga nä carcayanqui razonpa discïpulümi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nogata Dios-mayï cuyamangannuymi nogas cuyarcayag gamcunata. Gamcunas chaynuy cawapäcuy, noga gamcunata cuyarcayangagnuy. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Cay ningäcunata cäsucurcaptiquiga nogaga cuyapäcushaymi. Nogatachu Dios-mayï cäsucuptï cuyayäman chaynuymi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Chaynuypa noga rimaparcayag nogata cushicarcächimänaypagmi, nätan gamcunas cushisha capäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Chaura cäsucarcämänaypag caymi cayan: Cuyanacur jucniquis jucniquis cawapäcunaymi, noga gamcunata cuyangänuysi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Alicusa cuyacug canganta tantiachicun pisi, amïguncunapa janan wanularmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Niyangagcunata cäsucurcarga capäcunqui amïgücunam. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Manam nä cananpita ricapäcug juc rantisha runatanuychu. Rantisha runaga manam musyanchu rantignin ima rurayangantas, nätan gamcunata nogaga ricapäcug amïgücunapagmi. Chaymi Tayta Dios ima ruranancuna nimangantas nä musyarärichig. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Manam nogataga gamcunachu acrapäcamaray, antis nogam gamcunata acrapäcurag maypas aywapäcunaypag. Jinaman chaynuyla Dios munangannuy ali cawapäcunaypag üvas planta alisca wayugnuysi. Chaura noga ningänuy Tayta Diosta manacurga lapan manacurcangaytam chrasquipäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yapay cayta niyärishay: Jucniquis jucniquis cuyanacurmi cawapäcunqui” nirärimanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nätan Diosman mana yupachicug runacuna chregnipäcushuptiqui yarpachracurcay nogatas chregnipäcamanganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Gamcuna paycunanuysi lutan capäcuptiquiga chay runacuna cuyapäcushunquimanmi. Nätan gamcunataga nogam acrapäcurag chay runacunachru cayagta. Chaymi chay lutan runacuna chregnircayäshunqui paycunanuy nä mana capäcuptiqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yarpachracurcay cay nipäcungagta: Maygan rantisha runasi manam mas munayniyogchu rantigninpitaga. Nogatas chregniparcayämarga, ashiparcayämarga, gamcunatas chaynuymi jinapäcushunqui. Nätan yachrachingäta cäsucarcayämagcunaga gamcuna yachrachipäcungaytas cäsucurcangam. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lapan caycunata rurapäcushunqui nogapa capäcuptiquim chay cachramagnïta mana reguepäcur. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Chay runacuna mana juchaynagmi capäcunman cara, mana noga musyachig aywamuptïga. Cananga nätan chay juchancunapita mana cuyapasham capäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pi maysi nogata chregnimagga, Tayta Diostas chregniyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mana juchaynagmi capäcunman mana munaynïwan paycunachru mana ima-aygatas rurasha captïga. Nätan cananga nämi ricapäcusha ima-aygatas. Chaynuy ricarcayarmi chregnircayäman, jinaman Tayta Diostas chregnircayan. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chaynuy jinarcayäman isquirbishacunachru: ‘Mana juchaynagtam chregnipäcamara’ ningan ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nätan yanapapäcushugniqui chay razoncag Espirituga Tayta Dioscagpita cachramunäga runacunata tantiachingam nogapita. ");
INSERT INTO qvnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jinamanga gamcunas rimapäcunquitan galayunanpita-pacha nogawan capäcusha capäcur”. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Caycunata nircayag, nä ima-aygas captin mana nogapita raquicapäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gamcunataga chay Israel castäcuna gotucarcänan wayipitas gargaripäcushunquim, jinaman chrämungatan maygansi wanurcärichishurniqui ‘Caynuypam Diosta servinchi’ nipäcunan junagsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chaynuy rurapäcunga mana Tayta Diostas ni nogatas reguepäcamasha carmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nätan nircayag, nä caycuna pasaptin yarpachracurcänaypagmi”. Nircurmi Jesusga cay nipäcaman: “Galayunanpita-pacha mana cayta nipäcuragchu, gamcunawan quiquï carmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nätan cananga cachramagnïwan canäpagmi aywacü. Niyaptïsi manam maygalaysi: ‘¿Maytatag aywacunqui?’ nir, tapupäcamanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Antis cay ningäcunawanga aliscam laquicarärinqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nätan mayapäcamay shumag: Antis aywaptïga alim canga gamcunapag. Mana noga aywaptïga manam aywamungachu chay tantiayta yanapapäcushugniqui. Nätan aywacurga nogam cachramushag payta. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nä pay aywaramurga Diosman mana yupachicug runacunata tantiachinga juchasapa capäcungantam, Dios ningannuy ali cawaypitam, nätan juchancunapita taripasha capäcunantam. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Juchasapa paycuna carcayan ‘Payga razonpa Diospitam’ nir, mana chrasquicarcämanganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nätan tantiapäcungam Dios munangannuy noga ali cawangäta. Chaymi nogaga aywayä Tayta Dioscagta. Nä manam nogataga ricapapäcamanquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jinaman tantiapäcungam cay pachachru munayniyog Asyag juchanpita ‘Cunchuchisha cachun’ Dios nä nirayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Maymayragchri cayan nipäcunag, nätan cananga manam tantiayta atipapäcunquimanchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nä razoncag Espíritu aywaramurmi ichaga lapanta shumag tantiachipäcushunquiga. Payga manam rimapapäcushunqui quiquinpa tantiaylanpitachu, antis rimanga Diospita mayangantam, nätan musyachingatan mas guepaman ima-aygacuna cananpitas. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Payga tantiachipäcushunqui nogata alawapäcamänaypagmi. Nätan nogapita musyangantam gamcunata musyachipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chay Santu Espirituga nogapita musyangantam gamcunata musyachipäcushunqui. Chaynuy nircayag Tayta Diospacag ima-aygas nogapa captinmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nircurmi Jesusga cay nipäcaman: “Cananpita ishcay quima junagtaga manam ricapapäcamanquichu, nätan ishcay quima junagtaga yapaymi ricapapäcamanqui. Nogaga aywacushag Tayta Dioscagtam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chaura juc ishcay discïpuluncunaga tapunacuytam galacayärï cay nir: “¿Ima ninantatag niyämanchi: ‘Ishcay quima junagga manam ricapapäcamanquichu, chaypita ishcay quima junagtaga yapaymi ricapapäcamanqui, nätan aywashag Tayta Dioscagtam’ nirga? ");
INSERT INTO qvnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Manatag tantianchichu imapita rimayangantas. ¿Ima ninantatag niyämanchi?” ");
INSERT INTO qvnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nir tapucuyta munarcayangätam Jesusga tantiarun. Jinarcurmi cay nipäcaman: “ ‘Cananpita ishcay quima junagta manam ricapapäcamanquichu, chaypita ishcay quima junagtaga ricapapäcamanqui’ ¿ningäpitachu tapunacurcayanqui? ");
INSERT INTO qvnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mayapäcamay shumag: Gamcuna wagapäcunquim, jinaman alisca laquisham capäcunqui. Chaynuy capäcuptiqui Diosman mana yupachicug runacunaga cushipapäcushunquim. Nätan chay laquirarcayangaypitaga cushicurcanquim. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Juc pachrayog warmichu nä gueshpicunan üra chraramuptinga, naupataga nanaywan cayan. Chaypita nä gueshpicururga gongarunmi chay nanangantaga, wamran näciramuptin cushicurur. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chaynuymi gamcunas cananga laquirarcayanqui. Nätan yapayran ricapäcushay. Chauraga aliscam shongoycuna cushicunga, nätan chay cushicuyniquicunata manam pisi guechrupäcushunquichu. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chay ricapapacunay junagga manam nä tapupäcamanquichu imatas. Nätan shumag mayapäcamay: Noga ningänuy ima-aygatas Tayta Diosta manacurcarga chrasquipäcunquim. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Canancama gamcunaga manam noga ningänuy manacurcanquiragchu. Manacurcay, chrasquipäcunquim alisca cushisha capäcunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nätan canancama caycunata nirärig imawansi tincuchiypam. Nätan mana tincuchiypa rimanä junag chrämungam. Chay junagga Tayta Diospita rimaptï shumagmi tantiapäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay junag noga ningäta yarparcurmi manacurcanqui payta. Nätan manam Tayta Diosta manacushag gamcunapita nipäcugchu. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Antis gamcunataga quiquin Tayta Diosmi cuyarcayäshunqui. Nätan cuyarcayäshunqui nogata cuyapäcamaptiquim, jinaman Tayta Diospita shamungäta chrasquicurcasha capäcuptiquim. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Noga yargamurä Tayta Dioscagpitam. Jinarcurmi aywamurä cay pachaman. Cananga nätan cay pachapita cuticü yapay Tayta Dioscagtam”. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nipäcamaptin discïpuluncunaga cay nipäcümi: “Cananmi icha rimayanquiga shumag, mana imawansi tincuchilar. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cananga tantiarcayämi lapan ima-aygas musyangayta, jinamanga manam pisi tapucushunaytaragchu munanqui. Chaymi ‘Payga razonpa Diospita aywamusham’ nirsi chrasquicurcarag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nipäcuptïmi Jesusga cay nipäcaman: “Cananga ¿razonpachu yupachicarcayämanqui? ");
INSERT INTO qvnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nämi nachrgayämun ürä, nätan nagascalam nä carunga. Gamcuna jucpacama wichicapäcunay, jinaman japaläta dëjapäcamänay üra. Nätan manam japalächu cäga. Tayta Diosga nogawanmi cayan. ");
INSERT INTO qvnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lapan caycunata nircayag nä ushanantam, cay pachachru gamcuna nacatacurcanquiran, nätan valorchacurcay. Nogaga cay pachachru chay juchäcachigta nä yalisham cä. Chaylatam nircärig”. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chaynuy nircärimarmi Jesusga jana pachata rircacurcur Tayta Diosta cay nin: “Tayta Dios, nämi chraramun üra Dios-mayiqui cangäta runacunata musyachinaypag. Chaynuytan nogasi gampita musyachishag Dios-mayï cangayta. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gamga nogata chruramasha canqui lapan runacunachru munayniyog canäpagmi, jinaman nogaman lapan runata aywachimungayta imaycamas cawachinäpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nätan chay imaycamas cawagga canga, gam japalay razoncag Diosta reguepäcushurniquim, nätan noga, Jesucristo cachramangayta reguepäcurninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nogaga cay pachachru gampita musyachisham cä, lapan nimangaycunata rurangäwan. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chauraga Tayta Dios, manaragsi cay pachas camacaptilan cangänuynar canansi cashag gamcagchru cushisha. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nogaga gamman mana yupachicug runacunapita acrarcur nogaman aywachimungaycunata musyachisham cä, gam imanuy cangaytas. Paycunaga gampam cara. Nätan nogatam gomasha canqui, jinaman paycunaga cäsucurcasham ningayta. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cananga musyapäcunmi lapan nimangaycuna gampita shamusha canganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chaura nimangaytaga nisham cä, nätan paycuna chrasquicurcasham. Shumagmi tantiapäcusha razonpa gampita aywamusha cangätas, jinamanga chrasquicarcämasham. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Chaymi noga manacuyag paycunapita. Manam manacug chay lutan runacunapitachu, antis manacuyag chay gomangay runacunapagmi gampa captin. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ima-aygas nogapacagga gampam, gampacagsi nogapam, nätan nogata cay runacunaga alisca alipagmi nä ricarcayächiman. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nogaga nä manam cashagchu cay pachachrüga. Nogaga aywayämü gam cayangaymanmi, nätan cay runacunaga canga caychrüran. Lapan juchapita caruchru cayag Dios-mayï, nimangaynuynar caycunata washay ima-aygapitas munayniquiwan. Nogachu gamwan cayanchi juc runanuyla chaynuy paycunas mana pasay raquicälar cawapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cay pachachru paycunawan carga, nimangaynuymi ñawilächru cachirä cay gomangaycunata. Manam maygansi caycunapita ogracashachu. Ogracarayanga nä ogracasha cayaglam, Salmoschru isquirbishanuy ruracänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Cananga aywamushag gam cayangaymanmi. Nätan cay pachachru cayälar niyag cayta, noga cushirayangänuy caycunas alisca cushicurcänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nogaga willasham cä nimangaytaga. Chaymi mana cäsucugcunaga chregnipapäcun, mana paycunanuy capäcuptin. Nätan nogasi manam paycunanuy lutanchu cä. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Chaura manam manacug, chay mana cäsucugcunapita jorgonaypagchu, antis manacuyag Asyagpita washanaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Chaura noga mana lutan captïmi, caycunas mana capäcunchu lutancamaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gamlapag capäcunanpag raquiruy razoncagta gampita rimapayangäwan. Gam nimangayga razoncagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nogatachu cachramaray cay pachachru runacunam, chaynuymi nogas caycunata cachrayä cay pachachru runacunaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nätan nogaga cäsucurag lapanchru, paycunas noganuy cäsucurcäshunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Manam caycunalapagchu manacug, antis manacuyagmi paycuna rimaptin mas guepaman chrasquicamagcunapagsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Paycunas lapan mana raquicälar capäcunanpag. Tayta, gamchu nogawan cayanqui, nätan nogachu gamwan cayä, chaynuy paycunas noganchipita mana raquicälar capäcunanpag, cay pachachru runacuna gam cachramangayta chrasquicarcämänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gam nogata alipa ricamangaynuymi nogas paycunata ricarä, nogawan gam mana raquicälar cawanganchinuy paycunas mana raquicälar capäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nogaga cayäshag paycunawanmi, nätan gammi canqui nogawan, mana pasay raquicapäcunanpag. Chaynuypaga cay pachachru runacuna tantiapäcungam gampa cachramushay cangäta, jinaman nogata cuyamangaynuy paycunatas alisca cuyayangayta. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tayta, chay gomangaycunata munä noga canächru paycunas capäcunantam, munayniyog canäpag nimasha cangayta tantiapäcunanpag. Nätan gamga cuyayämanqui mana cay pachas camacangalanpitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Alila rurag Tayta, cay pachachru runacunaga manam reguepäcushunquichu. Nätan nogaga regueyagmi, jinaman cay runacunas musyarcayanmi cachramaptiqui aywamusha cangätas. ");
INSERT INTO qvnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Paycunata tantiarayächïmi gampita, imanuy cangaytas. Nätan chaynuylam tantiayächishag, chay cuyamangaynuyla paycunas cuyanacurcänanpag, jinaman nogasi paycunawan canäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chaynuypa Jesús Tayta Diosta manacurcurga, aywara nogacuna discïpulunwanmi Cedrón ragra nipäcungä wacläcag chimpanta. Chaychrümi cara juc canchra ima-aygas wiñag. Chaymanmi Jesuswan yaycarärï. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesusta wanuchipäcunanpag reguechig Judassi regueram chay aywapäcungäcagtaga. Chayman achca cutim Jesusga pushapäcamara nogacunata. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaura Judasga chraramun chaymanmi achca soldäducunawan, jinaman Diospa wayinta ricag guardiacuna pushasham. Chaycuna aywarärimunag sacerdöticunapa mandagnincuna nätan fariseocuna cachramuptinmi. Chaura chrarärimun tucuywan achquishacamam, jinaman alisca camapacusha armacunawancamam. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nätan Jesusga lapan ima-aygas pasananta musyarga aywarcurmi tapurun: “¿Pitatag ashircayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Niptinmi paycunaga “Nazaretpita Jesustam” nirärin. Chaura Jesusga “Nogam cayä” ninmi. Jesusta reguechig Judasga paycunawanmi cayänag. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Chauraga “Nogam cayä” niruptinga runacunaga guepatarcurmi ancalarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chaura Jesusga yapaymi cay nin: “¿Pitatag ashircayanqui?” Niptin paycunaga “Nazaretpita Jesustam” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chaura Jesusga cay ninmi: “Nämi nircayag, nogam cayä. Nä ashircayämarga nogalata charipäcamay, nätan cay runacunaga aywacurcächun”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chaynuy nira: “Tayta Dios gomangancunata manam ograshachu cä maygantas” nir, quiquin Jesús rimangannuy ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chaura Pedro nipäcungä Simonga espäda charayanganta jorgarcamurmi Malco jutiyog runapata derëchacag rinrinta muturun. Payga canag Diospa wayinchru mandagcunapa mas mandagnincagpa rantisha runanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chaura Jesusga Pedrotam cay nin: “Chay espädata chruracunanman cutiyächiy. Nogaga Tayta Dios nimangancunataga rurashagran alisca cunchunä cayaptinsi” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Niptin chay soldäducunaga mandagnintinmi, sacerdöticuna cachramungan guardiacunawan Jesusta charirärin. Jinarcurmi watarärin maquinta. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chaypitam aywachicurcan chay mandag Anaspa naupanman. Payga cara Caifaspa suydrunmi. Chay wata cara Caifás chaychru sacerdöticunapa mas mandagnincagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nätan chay Caifasmi cara “Cay Israel castacunapa jananchi wanuchun juc runa” nir mandagcunata nigsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nätan Pedro nipäcungä Simonwanga noga Juanga, gatirapäcurä Jesustam. Chaura chay sacerdöticunapa mas mandagninpita reguesha carmi, nogaga yaycurü Jesuswanga chay mas mandagcagpa wayin puncuman. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroga nätan washa puncuchrümi quëdarun. Chaura chay mandagpita noga reguesha carga, chay puncuta quichrachrag warmiwanmi rimarü Pedropita. Jinarcurmi yaycarachï Pedrotas. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chaura chay warmiga Pedrotam cay nin: “¿Manachu gamga canqui wac runapa discïpulun?” Niptinmi Pedroga “Manam nogaläga cächu” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jinarcurmi alisca alalaptinga, chay rantisha runacunawan guardiacunaga ninata ratarcärichir shayarcayara shanapacurcayar. Chaychru paycunawanmi Pedrosi cayara shanapacuyar. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chaycama chay mandag Anasga tapupaytam galacuyun Jesustaga “¿Pïcunam discïpuluycuna? Nätan ¿imatam yachrayächinqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Niptinmi Jesusga cay nin: “¿Manachu musyapäcunqui? Nogaga lapan runacunatas rimaparä runa ricaymi. Chaynuylam yachrachirä Israel castäcuna gotucarcänan wayichrüsi, jinaman Diospa wayinchrüsi paycuna gotucapäcunanchrüga. Chauraga manam imatas nirächu pacayninchrüga. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imanirtag tapuyämanqui nogata? Tapuyga chay mayamagcunata. Paycunaga musyarcayanmi imapita yachrachingätas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chaynuypa Jesús niruptinga, chaychru cayag Diospa wayinta ricag guardiacunapitam jucga, Jesusta cäranchru lagyarun cay nir: “Amam chaynuypa ninquimanchu Diospa wayinchru mandagcunapa mas mandagnincagtaga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Niptinmi Jesusga nirun: “Chaura lutanta rimayaptïga nimay lutan rimayangäta. Nätan rimayangä ali captinga ¿imanirtag lagyayämanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chaura Anasga chaynuy watashalatam Jesustaga “Aywachipäcuy Caifasman” nirun. Chay Caifasga cara Anasnuysi mas mandagnincagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nätan Pedroga chay ninacagchrüran shayayara shanapacuyar. Jinarcurmi cay nirärin yapay: “Gamga cayanqui wac runapa discïpulunmi ¿au?” Nipäcuptinmi Pedroga cay nin: “Manam nogaga calächu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chauraga chay mas mandagcagpa rantisha runacunapitam, jucga cay nin: “Nogaga ricapurag gamtaga chay ima-aygas wiñag canchrachrüga paywan cayagtam”. Chay nig runaga cara Pedro rinrinta mutungan olgopa ayllunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Niptin Pedroga yapaymi “Manam reguëchu” nirun. Chaura chaylam gallo wagarun. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chaura chay Caifaspa wayinpitaga Jesusta aywachicurcan mandag Pilato cacunan wayimanmi. Nämi warayämura, nätan chay mandacunan wayimanga manam Israel castacunaga yaycapäcurachu “Juchäcurushunmi” nir. Nätan chayman yaycurga manam micapäcunmanchu cara Pascua micuy cënata. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chaura Pilatoga chay runacunata tapunanpagmi yargaramun. Chaypitam cay nin: “¿Imatam alisca juyuta juchäcusha cay runa?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Niptinmi cay nirärin: “Chay runa mana lutan rurag captinga, manachr gamman aywachipäcamümanchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nipäcuptinmi Pilatoga nin: “Aywachicurcay, quiquiquicuna juchanta taripapäcamuy Moisés isquirbingannuy”. Niptinmi chay Israel castäcunaga cay nirärin: “Nogacunaga manam pitas wanuchiyta atipapäcüchu gam mana nipäcamaptiquiga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chaynuypa nipäcura imanuypa wanunanpitas Jesús rimangannuy ruracänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chaura nipäcuptin Pilatoga cutiyurun chay cacunan wayimanmi. Jinarcurmi Jesusta gayarcur tapurun: “¿Gamchu cayanqui cay Israel castacunapa reynin?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Niptinmi Jesusga nin: “¿Chaynuy niyämanqui quiquiquipa yarpayniquipitachu, icha pisi Israel castäcuna nogapita nipäcushuptiquichu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Niptinmi Pilatoga nin: “¡Nogaga Israel castachu imatag cayä! Cay castaycunam, Diospa wayinchru mandagcunam aywarayächimushunqui nogamanga. ¿Imatamar alisca juyuta rurarayanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nir tapuptinmi Jesusga cay nin: “Noga reyga manam cä cay pachapitachu. Cay pachapita captïga runäcuna peliapäcunmanmi cara mandagcunapa maquinman mana gopäcamänanpag. Nätan noga reyga manam cä cay pachapitachu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Niptinmi Pilatoga “¿Chaura gamga reychu cayanqui?” Niptinmi Jesusga cay nin: “Reymi cayä, gam niyangaynuymi. Nogaga näciräsi, nätan aywamuräsi cay pachaman lapan razoncagta ninäpagmi. Pi maysi chay razoncagta musyay munagga cäsucanmanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Niptinmi Pilatoga nin: “Manam canchu imas razoncagga”. Nircur Pilatoga yapaymi yargorun chay Israel castacunaman. Jinarcurmi cay nin: “Manam cay runapaga canchu ima juchansi wanuchiy ninanpagnuyga. ");
INSERT INTO qvnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gamcunaga nätan cay Pascua fiestachrüga imaysi munarcayanquim cachrarinäta juclaylataga carcelpita. Chauraga ¿munarcayanqui cachrarinäta cay reyniquicunatachu?” ");
INSERT INTO qvnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Niptinmi yapay gaparäcurcan lapan: “¡Ama chaytaga cachrariychu! ¡Cachrariyga Barrabasta!” nir. Chay Barrabasga cara reypa contran, imatas lutanta rurapäcamunanpag runacuna sucsutagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chaura Pilatoga “Cay Jesusta astipäcuy rimacunanpag” nirunmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jinarcurmi soldäducunaga Jesuspa umanman jatiräripun cashapita rurasha corönata. Chaypitam jacuräripun yana puca color jacuta. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jinarcurmi payman ashuyärirga “Cushicuynar Israel castacunapa reynin” nir cäranchru lagyacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chaura Pilatoga yapay yargorcurmi, runacunata chay nin: “¡Jay! Cananga cayman yargachimushag, cay runa mana imatas juchäcusha canganta musyapäcunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nirga Jesusta yargarachin antay antaytam cashapita rurasha corönan jatishata. Jinaman chay yana puca color jacu jacushata. Chaura Pilatoga “Caymi cayan chay runa” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nä Jesusta ricaparärirga, sacerdöticunapa mandagnincunawan Diospa wayinta ricag chay guardiacunaga mandagnincunaga gaparaytam galacayärin: “¡Cruzchru wanuchun! ¡Cruzchru wanuchun!” Nipäcuptin Pilatoga nira: “Quiquiquicuna aywachicurcay cruzchrüsi u imachrüsi wanuchicarcämuy. Nogaga manam tarïchu cay runapa juchantaga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Niptinmi chay castäcunaga nirärin: “Nogacunapagga cayanmi Moisés isquirbinganchru, ‘Diospa-mayinmi cayä’ nigtaga pitas wanuchipäcunäpag. Chauraga wanunmanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chay nigta mayarur, Pilatoga masmi manchacarun. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chauraga yapaymi yaycurun Pilatoga chay wayiman. Jinarcurmi tapurun Jesusta: “¿Maypitatag cayanqui?” Niptin Jesusga upälalam cara. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chaura Pilatoga cay ninmi: “¿Manachu imatas nimanqui? ¿Manachu musyanqui gamta ‘Cachrariysi’ u ‘Cruzchru wanuchipäcamuy’ niysi munaynïchru canganta?” ");
INSERT INTO qvnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Niptinmi Jesusga nin: “Gampaga manam ima munayniquis canmanchu imata ruramänaypagsi, Tayta Dios chaynuy munayniyog canayta mana munaptinga. Chaymi gampa maquiquiman nogata chrächimagga cayan mas alisca juchäcusha gampitaga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chayürapita Pilatoga munara imanaypanuysi Jesús cachrariruytam. Nätan chay castäcunaga gaparäcurcan cay nirmi: “Chayta cachrarirurga musyachipäcamanqui munayniyogninchi Cesarpa amïgun mana cangaytam. Nätan pisi ‘Reymi cayä’ nigga Romachru munayniyogninchitam mana manchacunchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nigta mayarur Pilatoga Jesusta jorgarachimun washamanmi. Jinarcurmi tacuyun juchacunata taripäcunancagman, ‘Gabata’ nipäcunganman. ‘Gabataga’ ‘Rumipita rurasha patiu’ ninanmi hebreochrüga. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chauraga cara Pascua fiesta ganyannintinmi nä chraupi junagnuy. Jinarcurmi Pilatoga chay castäcunata nin: “Caymi cayan reyniquicunaga”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Niptin paycunaga gaparäcurcan cay nir: “¡Chayta jitamuy! ¡Chayta jitamuy! ¡Jucla niy cruzchru wanuchisha cananpag!” Nipäcuptin Pilatoga “ ‘Cruzchru wanuchipäcamuy’ ¿nishag reyniquicunatachu?” Niruptinmi sacerdöticunapa mandagnincunaga nirärin: “Romachru munayniyoglam reynïcunaga. Manam jucga pisi mas canchu”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chaura Pilatoga “Cä cayan. Nipäcamangaynuy cruzchru wanuchun” nirura. Chaylam Jesustaga aywachicurcan. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Chaypitam Jesusga yargorun cruzninta umrucurcur, ‘Uman tullu’ nipäcungan gotuman aywananpag. Chay ‘Uman tullu’ ninanga hebreo rimaychrüga ‘Gólgota’ ninanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chaychrümi cruzman clävarärin ishcay runacunatawan, jucnintam wacläninman jucnintam cayläninman, nätan Jesustam chraupiman. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Chaypitam Pilatoga cruzpa umancagman chrurarachira cay nir isquirbishata “NAZARETPITA JESUSMI CAYAN ISRAEL CASTACUNAPA REYNIN” nishata. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chay cruzchru isquirbishata achcam Israel casta runacuna leyipäcura marca lädulan captin. Nätan isquirbisha cara quima rimaychrümi, hebreochru, griegochru, latinchru. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaura sacerdöticunapa mandagnincunaga Pilatotam cay nirärin: “ ‘Israel castacunapa reynin’ nirga ama chruraychu, antis chrurayga ‘Israel castacunapa reyninmi cayä nigmi cay cayan’ nishata”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nipäcuptinmi Pilatoga “Isquirbingäga nä isquirbisham imanuysi” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nä soldäducuna Jesusta cruzman chrurarärirga, jacuntam aypunacarärin juctacama chruscu soldäducuna. Jinaman charirärintan ruyin jacuntas. Chayga cara mana tinquisham, janapita galayur uracama awasha. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chaura soldäducunaga lapanmi “Ama lachishunchu, antis mayganchis apacunanchipag chüsarushun” ninacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús clävarayangancagchrüga cayaram mamansi nananwan, nätan Cleofaspa warmin Marias, jinamanmi cayara Magdalapita Marias. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chaypita mamanta Jesús ricapururga, jinaman chaychru shayayagta noga cuyay discïpuluntas ricaparamarga, mamantam cay nin: “Mama, paymi canga wawayqui”. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nätan nogatam “Paymi canga mamayqui” niraman. Chaypinpita-pacham wayïchru atendirä payta. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chayta nircurga, jinaman ima-aygas nä isquirbishacuna ruracasha canganta Jesús musyarga, isquirbisha ruracänanpagmi “Yacunayäman” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaura chaychrüga cayara puchgorisha vïnum junta wiñasha alpapita rurasha matichru. Jinarcurmi chaychru juc esponjata ogorcachirga Jesuspa shiminman chaccharcarärichin juc chaglawan. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús chay puchgorisha vïnuta upyarurga “Ruranäcagta nämi usharü rurayta” ninmi. Jinarcurmi lipurpular wanurun. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chay junag cara Pascua fiesta ganyannintinmi. Chaura Israel castäcunaga manam munapäcurachu jamana junagchru chay runacunapa cuerpuncuna cruzlachru cananta. Chay jamana junagga cara alisca välig junagmi. Chaymi Pilatota “Cruzchru cayag runacunapatanar chrancancunata paquipäcamuchun. Chaypita ashuchipäcuchun” nirärinag. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chaura soldäducuna chrarärimurga manyachru cayagpa ishcaynin chrancantam paquirärin. Chaynuymi rurarärin Jesuspa wacläninchru cayagpatas. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nätan Jesuscagman ashuyurga ricaparärin nä wanushatam. Chaymi mana paquipäcurachu chrancanta. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jinatam juc soldäduga Jesuspa wagtancagpa lanzawan tucsirun. Jinarcurmi chayla yargaramun yawarwan yacu. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Cayta willaparcayag noga quiquï ñawïwan ricasha carmi razoncagta. Nätan musyayäsi shumagmi razoncagta rimayangätas, gamcunas razonpa payta chrasquicurcänaypag. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Caycuna ruracara “Manam paquipäcungächu ni juclay tullulantas” nir, Jesuspita isquirbisha captinmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Cayantan isquirbishacunachru “Rircarapäcungam tucsiyagta” nishas. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaypitam Arimatea marcapita Josëga manacurun Pilatota Jesús wanushata jucläman ashuchinanpag. Josëga cara Jesuspa discïpulunmi, Israel castäcuna manchaypam payga mana reguechicurachu. Chaura Pilato “Äri” niruptinga aywarcamurmi apacura Jesusta. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chayman chraramuratan Jesusman chay pagaspa aywag Nicodemos, quima chrunca kïlunuy mirratawan áloes ningan tacusha shumag asyag jampicunata apacurcur. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chaura Josëwan Nicodemoga Jesusta wancurärin, chay mushog sagpi charapäcunganman chay alisca shumag asyag jampita wichiyurmi, imaysi chay Israel castäcuna rurachrapäcungannuy. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta cruzman chay clävapäcungancagchru juc canchram cara ima-aygas wiñag. Nätan chay chracrachrüga caratan juc mïchusi, mushog rurashala. Chaymanga manaran pisi enterrasharagchu cara. ");
INSERT INTO qvnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chaymanmi Jesusta chrurarärin wayrala, chay lädulan captin, nätan Israel castacuna jamapäcunä junag nä galayunan captin. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Chaura semäna galayunan junagshi goyash yanan yananla Magdalapita Mariaga aywara Jesuspa mïchuncagta. Nä chrarurga, mïchu chapag jatun rumitaga ricapurun jucläman ashushata. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chaura cutiramunag päripa pärirmi Pedro nipäcungä Simontawan nogata ashimag. Nogaga carä Jesuspa cuyayninmi. Chaura chraramurga cay nipäcamanmi: “Taytanchitaga mïchupita jorgapäcusham. Nätan manam musyacanchu mayman chrurapäcungansi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nirärimaptin Pedrowan nogaga aywacurcarä mïchucagtam. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishcaynïsi aywapäcurä päripa pärirmi. Nätan nogaga mas wayralam aywarä Pedropitaga. Jinarcurmi chrarü mas naupata. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chaura lipuyurga ricapurü chay wancupäcungan mushog sagpitaga pachan wancushalatam, nätan manam yaycurächüga. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chaypita chraramunmi Simón Pedrosi guepätaga. Payga yaycurun ruyicamam. Nätan ricarun paysi chay mushog sagpicuna cayaglatam. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jinamanmi ricarun Jesuspa uman wancusha sagpitaga chay waquin mushog sagpicunapitaga juclächru doblarayagta. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chaypitaga nogas yaycurümi. Chaura chayta ricarurga “Razonpam payga cawacämusha” nïmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chaycamaga manaran tantiapäcuräragchu wanurcur cawamunanpag isquirbirayaptinsi. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaypitaga cuticurcarä jäturarcayangä wayitam. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nätan Mariaga wagayarshi cayara mïchucagpitaga washachru. Chaypitash wagaräcur mïchuta anayun. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jinarcurshi ricapurun ishcay angelcunata yullag jacushatacama Jesusta chrurapäcungancagchru tayarcayagta. Jucagshi tayänag umancagpa, nätan jucninshi chraquincagpa. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chaura angelcunaga cay ninshi: “Mamala, ¿imanirtag wagayanqui?” Nipäcuptinshi payga nin: “Munayniyog Jesusnïtam apapäcusha, nätan manam musyächu mayman chrurapäcungantas”. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nir muyurcurshi ricapurun Jesustaga. Nätan manash regueshachu pay canganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chaura Jesusga tapurunshi: “Mamala, ¿imanirtag wagayanqui? ¿Pitatag ashiyanqui?” Niptinshi payga “Cay chracra tapäcugchrau cayan” nirshi, cay nirun: “Tayta, gam jorgosha carga, nimay mayman chruramungaytas, noga apacunäpag”. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Niptinshi Jesusga “¡María!” nin. Chaura Mariaga muyurcurshi hebreo rimaychru “¡Rabuni!” nir, chraquinta margapacurun. (‘Rabuni’ ninanga ‘Yachrachig’ ninanmi.) ");
INSERT INTO qvnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Niptinshi Jesusga cay nin: “Cachrarimay. Nogaga manaran jegäragchu Tayta Dios-mayïcagman. Antis nimuy runäcunata: ‘Dios-mayïcagta, nätan Diosniquicunacagta aywayangäta, jinaman Diosnïman, nätan Diosniquicunaman aywayangätas’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Niruptin Magdalapita Mariaga aywaramunag tayta Jesús ricapungantawan pay ningancunata willapapäcamänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chaura chay semäna galayunan junagmi nä inti jegarpunayaptin discïpulucunaga goturarcayarä, chay mandagcunata manchacurga wayi puncucunata shumag wichrgapäcurcur. Jinarcurmi Jesusga yaycarcamur chraupïcunaman shayuyur saludarärinman “Shumagla cawapäcuy” nir. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nircurmi Jesusga shumag ricarärichiman maquincunatawan wagtanta. Chaura ricaparärirga aliscam cushicarärï. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chaypitam yapay cay nipäcaman: “Gamcuna, ama manchapäcuychu. Nogatachu Tayta Dios cachrarayäman, chaynuymi nogas cachrarcayag gamcunata”. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nircurmi pücarcamurga “Santu Espirituta chrasquipäcuy. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pisi perdonapäcungayga, perdonasham capäcunga, nätan mana perdonapäcungayga mana perdonasham capäcunga” nipäcaman. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nätan Tomasga chay chrunca ishcayniyog discïpulu-mayïcunapita mellïshu nipäcungäga manam Jesús chrämunanpag carachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chaypitam waquin discïpulu-mayïcunaga “Jesustam ricaparärï” nirärin. Chaura nipäcuptin Tomasga “Manam razonchri nipäcugmanchu. Chay clävu yaycusha maqui mogonta mana ricarga, nätan clävu yaycushaman dëdüta mana jatirga, nätan wagtanta mana yatarga” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chaypitam nä puwag junag pasashachrüga yapaytag discïpulucunaga goturarcayarä wayichru. Tomás cayara nogacunawanmi. Chaura puncucunas wichrgarayaptinmi Jesusga yaycaramun. Jinarcurmi chraupïcunaman shayuyur “Shumag cawapäcuy” nir, saludaräriman. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chaypitam Tomasta cay nin: “Maquïman jatiyuy dëduyta, maquïcunata ricay. Nätan maquiquita chacchayämuy wagtäta yatayunaypag. Amam ‘Yangachr’ ninquimanchu, antis ‘Razonpachr’ ninquimanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Niptin Tomasga “¡Munayniyoglä, jinaman Diosnilä!” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chaura Jesusga cay ninmi: “Tomás, ¿canan ricaramar-ragchu, ‘Razonpam cawacämusha’ niyämanqui? Alipag ricasham, jinaman cushisham carcayan pisi mana ricapamälar ‘Razonchri’ nigcunaga” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusga rurasha ima-aygacunatas achcatam pi cangantas reguechicunanpag nogacuna ricarcayaptï. Chay waquin ima-aygas rurangancunataga manam isquirbishachu cä cay libruchru. ");
INSERT INTO qvnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nätan caycunataga isquirbirayä “Payga cayan razonpa ‘Salvacugtam cachramushag’ Dios ninganmi, jinaman Diospa-mayinmi” nir, Jesusta chrasquicurcänaypagmi, nätan payta chrasquicurur imaycamas cawapäcunaypagmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaypitaga yapaytan Jesusga ricapachicuruntag nogacunawan, Galilea gochra manyanchru. Chay gochrataga Tiberias nipäcugsi cämi, nätan caynuypam casha: ");
INSERT INTO qvnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Carcayarä Pedro nipäcunganwanmi, ‘Mellïshu’ nipäcunagä Tomaswanmi, Galileachru Canaán ningan marcapita Natanaelwanmi, jinaman wauguë Jacobowanmi. Nogacunapa taytäcunaga Zebedeom, jinaman carcayarämi ishcay mas discïpulu-mayïcunawansi. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Chaura Pedroga “Pescacugmi aywayä” nipäcamanmi. Niptinga “Nogacunas gamwan aywashun” nirmi, aywacurcä chay büquiman jegarcur. Chaypitam chay pagasga mana pasay charipäcamushachu capäcü ni juclaylatas pescädutaga. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jinarcurmi Jesusga warag waragla ricacarun gochra manyanchru. Nätan nogacunaga manam musyapäcurächu pay canganta. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chauraga cay nipäcamanmi: “Wamraläcuna, ¿micunanchipag charirarcayämunquichu pescäduta?” Nipäcamaptinga “Manam” nirärïmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chaura Jesusga cay nipäcamanmi: “Ataräyaycunata jitayapäcamuy cay büquipa derëchancagman. Chaychrüga charipäcamunquim”. Nirärimaptinga jitayarärimümi. Jinarcurmi chay ataräya chutarcamuyta mana atipapäcüchu, achca pescäduyog captin. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chaura nogaga Jesuspa chay cuyayninga, Pedrotam cay nï: “¡Payga cayan Munayniyogninchi Jesusmi!” Ningäta Simón Pedro mayarurga janan jacun jorgonganta jucla jaticurcurmi gochraman jegarpurun, Jesusman aywananpag. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nätan waquinnïcunaga chrarärï gochra manyanman büquiwanmi, junta pescäduyog ataräyata garashtarcayämur. Chaypitaga gochra manyanman cara pachrac ichriychrünuylam. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nä gochra manyan pampaman yargaramurga tarirärï nina rupayagtam, nätan ishcay acapa pescädu shanshachru cayagtam, jinaman juc tantatam. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chaura Jesusga “Apapäcamuy ishcay quima pescäduta chayrag charipäcamungayta” nipäcamanmi. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chaura Pedroga büquimanmi jegarun. Chaypitam junta pescäduyog ataräyata garashtaramun, pachrac pichga chrunca quimayog acray pescädutam. Antis chaychica cayaptinsi manam ataräyaga tipishachu. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chaypitam Jesusga “Shapäcamuy micapäcunaypag” nipäcaman. Nätan maygä discïpulus “¿Pimi cayanqui?” niytaga manam atipapäcurächu, Munayniyog Jesús canganta musyapäcurnï. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chaypitam ashuyamur Jesusga, tantata aptarcur aypuräriman, jinaman pescädutas chaynuy. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Caywanga nä quimapaypam Jesusga ricapachicusha nogacunawan, wanushapita cawacaramur. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nä micaräriptïga Simón Pedrotam Jesusga tapurun: “Jonaspa churin Simón, ¿paycunapita maschu cuyayämanqui?” Niptinmi Pedroga cay nin: “Au tayta. Gam musyayanquim cuyayangagta”. Niptinmi Jesusga “Achrcashtanuysi cuyangä runäcunata, cananpita shumagpa michiy” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chaypitaga yapaytan: “Jonaspa churin Simón, ¿cuyayämanquichu?” Niptinmi Pedroga “Au tayta. Gam musyayanquim cuyayangagta” nin. Chaura Jesusga nirun: “Uyshanuysi cayag runäcunata michiy”. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Chaura yapaytan Jesusga cay nin: “Jonaspa churin Simón, ¿cuyayämanquichu?” Nir cuyanganta quimapaypa tapuruptinga Pedroga alisca laquisham cay nin: “Tayta, gam musyayanqui lapantam. Gam musyayanquim cuyayangagta”. Niptinmi Jesusga nin: “Chauraga uyshanuysi cayag runäcunata shumagpa michiy. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mayamay shumag: Mözu carga quiquiquim jacucug canqui. Jinarcurmi munangayta aywag canqui maytas. Nätan nä auquinyarurga ricralaytam chacchayunqui, jinatam juc jacapushunqui. Nätan aywachishunquis mana ayway munangaymanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Cayta nira Jesusga Pedro tantiananpagmi, chaynuypa Pedro wanunganpa Tayta Diosta alipag ricapäcunanpagmi. Chaypitam Pedrotaga “Rashchrüman jaruy” nin. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chaura muyurcamur Pedroga, guepan aywayagtam ricaparaman, Jesuspa noga chay cuyaynintam, chay Pascua cënachru Jesusman iscataragtam “¿Pitag cayan chay reguechishugniqui?” nigtam. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro ricaparamarga Jesustam cay nin: “Tayta, nätan paytaga ¿imatag pasanga?” ");
INSERT INTO qvnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Niptinmi Jesusga “Noga munaptïga cayächun cutimungäcamas. Nätan gamtaga ¿imanayäshunquitag? Gam ichaga gatiramay” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chaynuy Jesús ningantaga, Jesusman yupachicugcunachrüga mayachinacurcasha jucnuypam nogapitaga “Manam wanungachu payga” nirmi. Nätan Jesusga nira manam “Mana wanunäpitachu” antis niraga “Noga munaptïga payga cayächun cutimungäcamas. Nätan ¿gamtaga imanayäshunquitag?” niypam. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Noga quiquï Juanmi caycunapita willaparcayag. Quiquïtan isquirbirä caycunatas. Jinaman musyapäcunmi razoncagta rimag cangätas. ");
INSERT INTO qvnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nätan maymaychri cayan juccunas Jesús rurangancuna. Chaycuna lapan isquirbicaruptinga nogapa tantiaynïpita manapishchri cay pachas aypanmanchu chruranapag. Chaynuy cachun.");
INSERT INTO qvnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tayta Teófilo, naupacag libruchrüga gamman isquirbimurä Jesuspitam, nätan isquirbimuräga cay pachachru cayar jana pachata cuticungancama galayunanpita-pacha ima-aygatas ruranganpitam, jinaman yachrachinganpitam. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Chaura payga manaragsi jana pachata cutilarmi, chay acrashan cachran ruragcunata Santu Espíritu rimachiptin nirura imata rurapäcunanpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chaypita Jesusga wanunganpita cawacaramur, chay cachran ruragcunawan ricapachicura chruscu chrunca junagran, wanushapita razonpa cawacämusha canganta tucuynaypa tantiayächir, jinaman Tayta Diospa munayninchru cawaypita rimapayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chay junagcunam Jesusga micuyar chay runancunata cay nira: “Tayta Dios cachramunan Santu Espíritu chraramuptinran gamcunaga cay Jerusalenpita yargapäcunqui, chaura shuyacurcayay chay cachramunanta. Paypitaga nämi nipäcurag mas naupatas. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Musyapäcungaynuysi Bautizag Juanga runacunata bautizara yacuwanmi. Nätan gamcunaga cananpita manas alä unaytam Santu Espíritu munangannuy cawayta galayapäcunqui” nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chaypitam Jesuswan goturarcayar chay cachran ruragcunaga Jesusta tapurärin cay nir: “Munayniyog, ¿cananchu Roma runacunapa munayninpita jorgapäcamanqui gampa munayniquichru capäcunäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nipäcuptinmi Jesusga cay nira: “Gamcunataga manam chaypita musyapäcunay töcapäcushunquichu. Chaytaga Tayta Dioslam imay ruracuytas musyacun. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Antis gamcunaga shuyacurcayay Santu Espíritu chrämuptin calpanchasha capäcunayta. Chaura gamcunaga mana mancharilarmi wanushapita noga cawamungäta willapacurcanqui cay Jerusalenchru, Judea ninganchru, Samaria ninganchru, jinaman chaynuytan willapacurcanqui cay pachapa tumancama”. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chay nir rimayta usharuptilanmi, Jesustaga Tayta Dios pushacura jana pachata paycuna rircararcayaptin. Jinarcurmi juc pucutay chaparuptin nä mana mastaga ricapapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chay rircararcayaptinmi mayänipita ishcay olgocuna ricacarärin yurag jacushacama paycuna lädunchru. Jinarcurmi cay nirärin: ");
INSERT INTO qvnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilea runacuna, ¿imanirtag jana pachata rircararcayanqui? Gamcunacagpita wac aywayag quiquin Jesusmi yapay cutimunga canan ricapapäcungaynuy” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nä chaynuy niräriptinga, Olivos ningan gotuchru carcayanganpitaga Jesuspa cachran ruragcunaga cuticurcara Jerusalentam. Chay gotupitaga cara Jerusalenmanga juc waranga metrunuylam. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nä chrarärirga, gorpachacurcangan wayi altusmanmi jegarärin. Chaychrüga capäcura Pedrom, Juanmi, Jacobom, Andresmi, Felipem, Tomasmi, Bartolomëmi, Mateom, Alfeopa churin Jacobom, ‘Celote’ ningan Simonmi, Jacobopa wauguen Judasmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Paycunaga juc shongola carmi gotucapäcug chaynuyla Tayta Dioswan rimapäcunanpag, Jesuspa wauguencunawan, maman Mariawan, juc mas warmicunawan. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay junagcunam pachrac ishcay chrunca Jesusman yupachicugcuna goturarcayaptin Pedroga shayuyur cay nira: ");
INSERT INTO qvnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wauguecuna, panicuna, Judas Iscariotewan pasananpitaga unaylam Santu Espirituga Rey Davidwan isquirbichira. Chay isquirbingannuylam Judasga chay lutan runacunata pushara Jesusta wanuchipäcunanpag reguechig, ");
INSERT INTO qvnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","nogacunanuy Jesuspa cachran ruragpag acrasha cayarsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chaura Judas lutan rurayanganta tantiarur golgue cutichinganwanmi, sacerdöticunaga rantirärira Judas wanungan pampata. Judasga wanusha caynuypam: Payga jurcacusham. Jinarcurmi uman turpuypa ishquisha pegan wichangancama. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nätan chaytaga cay Jerusalenchru yachragcunaga lapanmi musyarcayan. Chaymi chay pampata jutipapäcura ‘Acéldama’ nir. Chayga ‘Yawar jichrasha pampa’ ninanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chay Judaspitaga Salmos libruchru Rey Davidga isquirbiratan cay nirsi: ‘Wayin jitarisha cachun. Amam pisi yachrangachu chay wayinchru, nätan juc runam paypa trucan chrurasha canga’ nirsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Chaymi cananga acrashun Judaspa trucanta nogacunawan cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Chay runa cachun Bautizag Juanpita, Jesús jana pachata aywangancama nogacunawan parëju purig casta, jinaman cachun Jesús cawacämushata ricag-mayïcuna razonpam chaynuy ruracara” ninanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chauraga Pedro ningannuylam chaychru goturarcayagcunapita acrarärira ishcay runata. Jucpam jutin cara José Barsabás. Paytam Justo nipäcug. Nätan jucpam jutin cara Matías. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jinarcurmi Tayta Diosta manacurcara cay nir: “Munayniyog Diosnïcuna, gamga shumagmi musyayanqui lapan runacunapa imanuy shongon cangantas. Canangar reguechipäcamä cay ishcayninpita mayganta acrangaytas. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Chay acrangay runa cachun Judaspa trucan. Canan Judasga cachray rurag mana cangachu juchanpitam, jinaman quiquin munarmi gampita raquicarun” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nä manacurcurga maygan canantas musyapäcunanpagmi chüsarärin. Jinarcurmi töcarura Matiasta. Chaura Matiaswanga yapaytan capäcura Jesuspa cachran ruragcunaga chrunca ishcayniyog. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chaypitam Pascua fiestapita pichga chrunca junag pasashachrüga chraramura ‘Pentecostés fiesta’ ningan. Chayga cara Israel castacunapa fiestanmi. Nätan chay fiesta galayunan junagmi Jesusman yupachicugcunaga juc wayilachru goturarcayara lapan. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chaypitam mayänipita mayacaramun jana pachapita juc alisca walyay wagarignuy chay carcayangan wayiman. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chaura wayichru lapan cayag runacunam ricapapäcusha Santu Espirituta, achicyayar juc ninanuy lapancunaman chragta. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chauraga lapan goturarcayag runacunam ricacarärin Santu Espiritupa munayninchru. Jinarcurmi galayarärin tucuy casta rimaycuna rimayta mana yachrapäcunganta, Santu Espíritu rimachiptin. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chaura Jerusalenchru chay fiestamanga lapan nacionpitam aywapäcamusha cara Dios manchacug Israel castacuna. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chay wagarigta mayarärirga achcam runacuna juntacarärimun chay wayicagman. Chaura chay runacuna lapanpa rimaynincunachru cama rimapäcugta mayarärirga manam tantiayta atipapäcurachu ima pasayangantas. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jinamanmi pasay manchacasha nirag capäcurga cay ninacurcara: “Lapansi cay rimarcayagcunaga Galilea ninganchru yachragmi carcayan. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Imanaypatag cananga nätan rimayninchichru cama lapanchitas rimapayämanchi? ");
INSERT INTO qvnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Caychrüga cayanchitag Partiapita, Mediapita, Elampita, Mesopotamiapita, Judeapita, Capadociapita, Pontopita, Asiapita, ");
INSERT INTO qvnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptopita, Cirenepa wac lädun Libia ninganpita. Carcayantan Romapita aywacamusha Israel castacunas, nätan juc casta runacuna Israel castaman muyushacunas. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jinaman carcayantan Cretapitas, Arabiapitas. Nätan cananga lapanchitan mayayanchi rimayninchichru cama Tayta Dios noganchipag ima-aygata rurayangantas” ninacurcaram. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chay runacuna lapansi manchacasha, jinaman mayacasha nirag capäcurga quiquincamam tapunacurcara: “¿Imatag cay runacunawan pasayan?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nätan waquin runacunam asipapäcura “Shincararcayanmau” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nipäcuptinmi Pedroga shayurun jinaman shayaräriratan chay chrunca jucniyog Jesuspa cachran rurag-mayincunas. Chaypitam Pedroga gayacuypanuy cay nira: “Israel castäcuna, jinaman cay Jerusalén marcachru lapay yachrayagcuna, cananga shumag mayacarcämay imata nipäcunagtas: ");
INSERT INTO qvnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gamcunaga ‘Shincararcayanmi’ nircayämanquim. Nogacunaga manam shincashachu capäcü. Chayragtag nachrgayan goya jamaymansi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Antis cay ricarcayangayga ruracayan Diospa unay willacugnin Joel isquirbingannuymi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Paywan Tayta Diosga isquirbichira cay nirmi: “Ushanan junagcunachrümi cachramushag Santu Espirituta lapan runacunaman. Chaura paymi lapan wamraycunata, warmitas, olgotas Diospita rimachinga. Nätan mözuycunatam ricapachishag ima-aygatas, jinaman auquincunatam imatas sueñuyninchru ricachishag. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chay junagcuna cachramushag Santu Espirituta servimagnïcunamanmi warmimansi, olgomansi. Chaymi ningäta rimapäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jana pachachrümi ricacächimushag manchacuypagcunata, nätan cay pachachrümi canga yawarla, nina rupayla, jinaman goshchrila. Chaynuy ruracanga chay ali willapa Diospita cangan tantiapäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Intim yanauyagman muyunga, nätan quillam muyunga yawarmannuy. Chaycuna ruracanga Munayniyog Dios aywamunan junag nachrgarayämuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Chaura pi maysi Munayniyog Diosta ‘Cuyapämaynar’ nigga salvasham canga” niram Diosga. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Chaura Israel casta runacuna, cay rimangäta shumag mayapäcamay: Nazaret marcapita Jesusga cara Dios cachramungan runam. Chaymi musyapäcungaynuysi payga mana pi runas ruray atipänancunata ima-aygatas rurara gamcunachru. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Paytam gamcunaga charircur wanurärichiray chay tucuy jucha rurag runacunawan cruzman clävachiypa. Nätan unaylapitam Tayta Diosga munara, jinaman musyara paywan chaynuy ruracänanpitaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nätan Tayta Diosga Jesusta cawacarachimura munayninwanmi mana chaynuy wanushala cananpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chay cawacächimunanpita Rey Davidga isquirbira cay nirmi: ‘Munayniyog Diosga, nogawan chaynuylam cayan. Payga cayan derëcha läduchrümi mana pisi manchachimänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chaymi alisca cushirayä, nätan alawayäsi cushicuypita jinaman cuerpüsi jamanga gamta shuyacuyälarmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gamga manam dëjamanquichu wanuptïsi wanushacuna cacunanchrüga. Amatan munanquichu Dioslapag cawag servigniquipa cuerpü ismunantas. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gamga musyarachimanquim imaycamas cawacugla canäta. Gam nogawan captiquiga alisca alisca cushisham cashag’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Chauraga Israel casta-mayïcuna, unay Reyninchi David wanuruptin, payta enterraräriram, jinaman canancamam noganchicagchru chay enterrapäcungan cayan. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidga chaynuy rimara Diospa willacugnin runa carmi. Pay musyara shumagmi Dios razonpa cay ninganta: ‘Gampa castaypitam jucta acrashag gamnuysi rey cananpag’. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chaypitas Davidga isquirbira nä pasay ricayagnuytan. Chaymi Diospa acrashan Jesús cawacämunanpita isquirbira: ‘Manam pay cangachu enterrapäcungancagchru, manatan cuerpunsi ismungachu’ nin. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chaura Rey David isquirbingannuymi Jesusta Diosga cawacächimura. Nätan chay cawacämushata lapämi nogacunaga ricapäcurä. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Chaura mandag cananpag Dios chruraptinmi, jinaman Santu Espirituta ‘Gammi cachranqui’ Dios nisha captinmi, Jesusga Santu Espirituta cachraramun. Chaytam canan gamcunaga mayarcayanqui. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Chaura Jesús mandag cananpitaga Rey Davidga jana pachata mana jegarayarsi isquirbira cay nirmi: ‘Tayta Diosmi nira Munayniyognïta: “Gam tayucuy cay derëcha läduman mandag canaypag. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Gampa maquiquiman lapan chregnishugniquicunata chruramungäcama” niram’. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Chaura cayta shumag tantiapäcuy lapay Israel castacuna: Cruzchru chay wanuchipäcungay Jesustam. Diosga chrurarun munayniyogpag jinaman salvacugpag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chaynuy nigta mayarärirga aliscam laquicarärin. Jinarcurmi Pedrowan waquin shayarcayagta tapurärin cay nir: “¿Imatatag chauraga rurapäcushag?” ");
INSERT INTO qvnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nipäcuptinmi Pedroga nira: “Jucha rurarcayangaypita wanacurcur, Diosman cutipäcuy juchaycunapita perdonapäcushunaypag, jinaman bautizacurcay Jesucristo ningannuy. Chauraga Santu Espirituta Dios cachramungam gamcunaman pay munangannuy ali cawayta yanapapäcushunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tayta Diosga Santu Espirituta cachramura gamcunamanmi, churiquicunamanmi, juc casta runacunamanmi, jinaman Munayniyog Dios acrangan runacunamanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chaynuypam jinaman mascunawanmi Pedroga tantiachira cay nir: “Ama cay lutan rurag runacunanuyga cawapäcuychu salvasha capäcunaypag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Chaura Pedro ninganta chrasquicugcunaga bautizächicaräriram. Chaynuypam Jesusman yupachicugcunamanga quima warangannuy yapacarärira chay junag. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chay runacuna cawapäcug Jesuspa cachran ruragcuna yachrachipäcungannuymi. Lapansi cawapäcug juc shongola gotucarcayarmi, jinaman tantawan vïnuwan Jesús wanunganta yarpachracurcänanpag micapacurcayarmi, Dioswan chaynuyla rimarcayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nätan Jesuspa cachran ruragcuna ima-aygatas runala mana ruray atipänancunata Diospa munayninwan rurapäcuptinga lapan runacunam manchapacur mayacasha nirag capäcura. Chaynuy rurapäcura chay willapacurcayangan Diospita canganta runacuna tantiapäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesusman chay yupachicugcuna mana raquicälar lapalanmi cawapäcug, jinaman ima-ayga charapäcungantas “Cayga lapanchipam” nipäcugmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nätan imantas capunganpitam ranticurcag. Jinarcurmi chay golguetaga lapan pishipacug cagcunata aypupäcug. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Chaura lapan junagmi juc runanuyla gotucapäcug lapansi Diospa wayin puncuchru. Chaynuytan gotucapäcug juclä wayicunachrüsi, jinaman mana jitapänacularmi cushisha micapäcurcag lapan. ");
INSERT INTO qvnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Chaynuytan Tayta Diostas alawapäcug, nätan runacunaga alipam ricapäcug Jesusman yupachicugcunata, jinaman Munayniyog Diosga waran waranmi yapayag chay salvangancunata Jesusman yupachicug gotucagcunaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Chay junagcunam jucpaychrüga, lastresnuy jegapäcura Pedrowan Juan Diospa wayinta. Chayüram Dioswan rimachrapäcug cara. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nätan juc runam näcinganpita-pacha cara rata. Paytam aylluncuna apapäcug lapan junag Diospa wayinman yaycuna sawan puncuman, chay wayipa puncuman yaycug runacunata golgueta manacunanpag. Chay puncutaga ‘Shumag puncu’ nipäcugmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chauraga Pedrotawan Juanta Diospa wayinman yaycuyagta ricapururmi chay runaga “Golguelaynar taytacuna” nir manacurun. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Niptinmi Pedrowan Juanga runata rircarirärin. Chaypitam Pedroga cay nin: “¡Rircäripäcamay shumag!” ");
INSERT INTO qvnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Niptin rata runaga rircarayara shuyag shuyagmi “Cananga goramangachr aygalatas” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Chaura Pedroga cay nirunmi: “Manam golguësi, örüsi canchu nogapaga. Antis Nazaretpita Jesucristo nimasha captinmi cuticächishay. Chaura ¡sharcuy, puriy!” nirmi, ");
INSERT INTO qvnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","derëcha maquinpita charircur sharcarachin. Chauraga chayüram chay runapa chraquincuna wichuncuna cuticarura. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chaura chayüram saltaypa shayucurun. Jinarcurmi puriyta galacuyun. Chaypitam Diospa wayin puncuman paycunawan yaycura saltaycachrayar, jinaman Diosta alawayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Chauraga lapan runacunam chay purigtas, jinaman Diosta alawagtas ricapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jinarcurmi mayacasha nirag ricacarärira chay sawan puncuchru golgue manacug canganta reguerärirga. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nätan chay cuticasha runaga manam cachracarachu Pedropitawan Juanpitaga. Chaura Salomonpa puncun nipäcunganman aywaräriptin runacunaga mayacasha nirag carcayanganpitam wayrala gotucarärin paycunacagman. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chaura Pedroga cay nirunmi chay runacunata: “Israel casta-mayïcuna, ¿imanirtag mayacasha carcayanqui? ¿Imanirtag rircararcayämanqui ‘Paycunam cuyapälar munayninwan cuticarachin’ nir? ");
INSERT INTO qvnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Antis castanchi Abrahampa, Isaacpa, Jacobpa Diosninmi, servignin Jesús alisca munayniyog canganta musyayächin. Paytam gamcunaga mandag Pilatoman aywachipäcuray, ‘Wanuchisha cachun’ nir. Jinarcurmi pay cachrariyta munaptinsi, gamcunaga mana munapäcuraychu. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Antis gamcunaga Pilatota manacaräriray runa wanuchig Barrabasta cachrarinanpagmi, Dioslapag cawag jinaman alila rurag Jesusta cachrariy nipäcunay trucaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chaynuypam gamcunaga wanuchisha capäcunqui cawachimagninchi Jesusta, nätan Diosga cawacächimusham. Chayta nogacunaga ñawicunawanmi ricapäcurä. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nätan ricapäcungaynuysi, jinaman musyapäcungaynuysi cay rata runaga Jesusman yupachicurmi shumag cuticarun, jinaman yupachicunanpagsi Jesustan yanaparun. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Israel-mayïcuna, gamcunas, jinaman mandagniquicunas mana musyarmi Jesusta wanuchisha capäcunqui. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nätan Tayta Dios unay willacugnincunawan ‘Acrashäga cunchungam’ nichingannuylam Jesuswanga ruracasha. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chaura cananga chay jucha rurarcayangaypita wanacurcur Diosman cutipäcuy perdonapäcushunaypag. Quizämi alisca cushishatas Munayniyog Diosga cachipäcushunqui ");
INSERT INTO qvnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","chay cachramunan Jesustaga cachraramuptinga. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nätan cananga jana pachachrüran Jesusga canga, Dioslapag cawag willacugnincuna unay rimapäcungan lapan ruracangancama. Chaypitaran yapay cay pachaman cutimunga. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Chaura Moisespis taytaycunata cay niram Jesuspitaga: ‘Tayta Diosmi, gamcunapa castay aywagpita cachramunga nogatanuysi juc willacugnin runata gamcunaman. Pay lapan nipäcushungaytam cäsucurcanqui. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nätan pi maysi pay ninganta mana cäsucugga Diospa runancunapita jorgosham canga cunchuchisha cananpag’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nätan Samuelpita galayurmi Diospa willacugnincunaga rimapäcura cay junagcunachru pasayangancunapitaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chaura Diospa chay willacugnincuna rimapäcunganga cara gamcunapagmi, jinaman gamcunapagtan caras taytaycuna Abrahamwan rimanacur Dios cay ningansi: ‘Gampa castaypita aywamugwanmi nogaga yanapäshag cay pachachru lapan casta runacunata’ ningansi. ");
INSERT INTO qvnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chaymi servignin Jesusta cawacarcachimursi naupataga gamcunamanrag cachramura yanapapäcushunaypag, chaynuypa jucha ruraypita wanacurcur Diosman lapay cutipäcunay raygo”. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Chaynuypa Pedrowan Juan chay goturarcayag runacunata rimaparcayaptinmi chrarärimun sacerdöticuna, Diospa wayinta ricag guardiacunapa mandagnin, jinaman saduceocuna. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Chaycunaga alisca piñasha chrarärimun Pedrowan Juan “Jesucristoga razonpam cawacämusha, chaura cananga paynuymi noganchis cawacämushun” nir yachrachipäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chaura Pedrotawan Juantaga aywachicurcan carcelmanmi. Jinarcurmi nä pacha chacanaptinga wichrgarärira warantincama. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nätan Jesuspita rimapäcunganta mayacug runacunaga Jesusta chrasquicurcasha achcam. Chay chrasquicushacuna capäcura pichga waranganuymi olgola. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chaura warantinga, gotucarärin chay Jerusalén marcachru mandagcunam, Israel castachru alinninpag ricasha chacha runacunam, Moisés isquirbinganta yachrachigcunam. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jinaman capäcuratan sacerdöticunapa mas mandagnincunas. Paycuna capäcura Anasmi, Caifasmi. Nätan Juanwan Alejandroga capäcura paycuna castam. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chaura Pedrotawan Juantaga carcelpita pusharcachimurmi chraupincunaman shayarärichin. Jinarcurmi tapupäcura cay nir: “Gamcunaga, ¿pi nirärishuptiquitag cay rata runata cutirärichinqui?” ");
INSERT INTO qvnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nipäcuptinmi Pedroga Santu Espíritu rimachiptin cay nirun: “Cay marcachru mandagcuna, jinaman alinninpag ricasha Israel casta taytacuna, ");
INSERT INTO qvnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿cay rata runata cuticächipäcungäpitachu juc juchäcushata yupaysi tapuparcayämanqui? ");
INSERT INTO qvnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chaura nipäcushay caychru lapan Israel castanchicuna musyapäcunanpag: Cay runa cuticarayan Jesucristopa munayninwanmi. Paytam gamcunaga cruzchru wanuchipäcuray, jinatam Tayta Diosga cawacächimusha. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Chay Jesustam gamcunaga mana chrasquicurcaraychu, wayi ruragcuna ‘Manam alichu cay rumiga’ nir wicapagnuysi. Chay wicapasha ruminuysi cayag Jesusmi, cananga cayan chay mas alinnincag ruminuy”. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nircurmi “Manam pisi canchu cay pachachru runacunata salvananpag. Manatan Tayta Diosga pitas nishapishchu salvamänanchipagsi, antis nirayanga Jesuslatam” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chaura Pedrowan Juan mana mancharilar chay nir rimapäcuptinga, Israel castacunapa mandagnincunaga mayacasha niragmi ricacarärin leyiytas ni isquirbiytas mana yachrapäcunganta musyarärirga. Nätan regueräriratagmi Jesuswan purig capäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chauraga Pedrotawan Juanta juchachayta munarsi manam ima niytas atipapäcurachu, chaychru chay cuticasha runa paycunawan shayaptin. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chauraga Pedrotawan Juantam “Caypita rätula yargapäcuy” nirärin quiquincamala chay runacuna rimanacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chauraga cay ninacurcaram: “¿Imatatag chay olgocunawan rurashun? Paycunaga runala mana ruray atipänantam rurararcayan. Chaytaga cay Jerusalenchrüga lapanmi musyarcayan. Nätan ‘Chayga yangam’ niytaga manam atipanchichu. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Antis chay runacunata nirushun manchachiypa mana masta cay marcachru pitas Jesuspita willapacurcänanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ninacarcärirmi Pedrotawan Juanta gayarcachir cay nirärin: “Cananpitaga ama pasay rimapäcuypishchu ni yachrachipäcuypishchu Jesuspitaga”. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Niräriptinga Pedrowan Juanga cay nirärinmi: “¿Gamcunapitaga Diosta cäsucuychu ali u runacunata cäsucuychu? ");
INSERT INTO qvnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nätan nogacunaga chaynuylam rimarcayäshag ricapapäcungätaga mayapäcungätaga”. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Chaura chaynuypa niräriptinga chay mandagcunaga cachrarirärira mas manchachiypa nircärirmi. Nätan ima ruraytas mana atipapäcurachu Jerusalenchru lapan yachragcuna chay pasanganpita Diosta alawapäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jinaman chay cuticasha runas nämi aywayara chruscu chrunca watapita masta. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chaypita nä cachrariräriptinga, Pedrowan Juanga Jesusman yupachicug-mayincunamanmi aywacurcan. Chrarurga willapacarärin chay sacerdöticunapa mandagnincuna, Israel castachru alinninpag ricasha chacha runacuna manchachiypa nipäcungantam. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Willaparäriptinga Diosman yupachicugcunaga Tayta Diostam manacuyta lapalan galacayärin cay nir: “Munayniyog Diosnïcuna, gammi camaray jana pachatas cay pachatas jatun gochratas, jinaman chaycunachru lapan ima-aygatas. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gampa servigniqui Rey Davidga unaylam Santu Espíritu rimachiptin Jesuspa contran sharcapäcunanpita cay nira: ‘¿Imanirtag lapan casta runacuna lutanta rurananpag sucsutänacurcan, jinaman lutanta rurapäcunanpag rimanacurcan? ");
INSERT INTO qvnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cay pachachru marca mandagcunawan reycunam juc runanuyla gotucarcur rimanacurcayan Munayniyog Diosninchipa, jinaman salvacugninchipa contran’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Chay ningaynuylam cay Jerusalén marcachru Rey Herodesga, Romapita mandag Poncio Pilatowan, juc casta runacunawan Israelpa mandagnincunawan gotucapäcusha, gam acrangay mana juchaynag servigniqui Jesusta wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chaynuy rurar paycunaga rurarärira gam unaypita chaynuy ruracänanpag pinsiangaynuylam. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Munayniyog Dios chay mandagcuna manchachiypa nipäcamanganpita musyayanquim. Nätan nogacuna cay servigniquicunata yanapapäcamay gampita mana manchacular willapacurcänäpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chaynuytag yanapapäcamay munayniquiwan gueshyagcunata cuticächipäcunäpag, jinaman runala mana ruray atipänanta rurapäcushag mana juchaynag servigniqui Jesús nipäcamangannuyla” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chaura Tayta Diosta nä manacuyta usharäriptinga, chay goturarcayangan wayiga cuyurunmi. Jinarcurmi chayla Santu Espiritupa munayninchru ricacarärin. Chaypitam Diospa willapanta rimapäcura mana manchacular. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Chaura Jesusman chay yupachicugcunaga alisca chranin carcayarsi, cawapäcura juc shongolam, jinaman munapäcugsi ali ruraytam lapansi. Chaymi mana maygansi “Cayga nogapam” nigchu imantas, antis “Cayga lapanchipam” nipäcug. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nätan Jesuspa cachran ruragcunaga Dios yanapaptin mana pasay mancharilarmi Munayniyog Jesús cawacämunganpita rimapäcug. Jinapäcuptin Tayta Diosga Jesusman lapan yupachicugcunata aliscam yanapara ima-aygatas rurapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Manam paycunachru pisi carachu imapitas nacatacug. Capunganpitam chracrancunatas, wayincunatas ranticurcurga, golgueta apapäcug Jesuspa cachran ruragcunata gopäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Goräriptinga paycunam chay golgueta aypupäcug lapan chaychru cagcunata ushapanganpita imancunatas rantipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chaynuymi Josësi rurara. Payta Jesuspa cachran ruragcuna jutiparärira “Bernabé” nirmi. ‘Bernabé’ ninanga ‘Cushicachicug’ ninanmi. Payga cara Levïpa castanmi, Chipre tishgopita. ");
INSERT INTO qvnNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Chaura paysi juc chracran cayagta ranticurcurmi golgueta gorura Jesuspa cachran ruragcunata. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chaynuytan Ananiaspis warmin Safirawan juc chracranta ranticarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Chaura Ananiasga warminwan rimanacurcurmi puchuchicarärinag chay golgueta. Jinarcurmi Jesuspa cachran ruragcunataga waquilanta gorun “Caychicalachrümi ranticarärï chracrata. Cä golgue” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Niptinmi Pedroga cay nin: “Ananías, ¿imanirtag Asyag munanganta rurarunqui? Gamga Santu Espiritutam casquiparunqui ‘Chay waquilan golgueta caychicalachrümi ranticurü’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Gampam cara chracraysi, jinaman ranticuruptiqui golguesi. ¿Imanirtag chaynuy rurayta pinsiaruray? Gamga casquipasha canqui Tayta Diostam, manam runacunalatachu”. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Niruptilanmi Ananiasga pampaman quitirun, jinaman wanurun. Chayta mayarärirga lapan runacunas aliscam manchacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chauraga ishcay quima mözucunam Ananiaspa cuerpunta wancurcur apacurcan enterrag. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chaypitam nä quima üranuy pasashachrüga Ananiaspa warmin chrarun, gowan wanusha canganta mana musyayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chraruptin Pedroga paytas tapurun cay nirmi: “¿Caylachu cayan chay chracra ranticurcangay golgue?” Niptinga Safiras “Au. Chaynuylachrümi ranticurcarä” ninmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chaura Pedroga cay nirunmi: “¿Imanirtag gamcunaga ninacaräriray Munayniyog Dios cachramungan Espirituta casquipapäcunaypag? Nä wac yaycarcayämun goway enterrag mözucuna, cananga gamtas enterrapäcushunquim”. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Niruptinga chayüram, Safiras wanurun Pedropa naupanchru. Nä mözucuna wayiman yaycarärirga wanushatam tarirärin. Chauraga paytas aywachicurcan gowan lädunman enterragmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chaynuy pasanganta musyarärirga Tayta Diosta alicusam manchacurcara Jesusman lapan yupachicug gotucagcunas, nätan lapan mayacugcunas. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jinaman Jesuspa cachran ruragcunaga Diospa munayninwan aliscam runala mana ruray atipänancunata ima-aygatas rurapäcug chay runacunachru. Nätan Jesusman yupachicugcunaga lapalanmi juc runanuyla gotupäcug Diospa wayinchru, Salomonpa ramädan nipäcunganchru. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesusman yupachicugcunata chay marca runacuna alisca alipag ricarcayarsi manam paycunawan gotucayta munapäcugchu. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nätan Munayniyog Jesusman yupachicugcunaga alisca achcam olgos warmis yapacarcayara Diospa runancuna castaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Chaypitas runacunaga gueshyagnincunata cämantintam apapäcug cällicunaman, Pedro chaypa pasaptin maygalanmansi “Pagta lantuynin chranman cuticasha cananpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Chaynuytan Jerusalén muyurignin marcacunachru yachragcunas apapäcamug gueshyagcunata, jinaman lutan espiritupa munayninchru cunchurcayagcunata. Nätan paycunaga lapantam cuticächipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chayta ricarmi sacerdöticunapa mas mandagnincagga, saduceocunawan alisca chriquicuyta galacayärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chaura Jesuspa cachran ruragcunataga charircurmi carcelman wichrgarärin lapan runa ricarcayaptin. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Chaypitam Munayniyog Dios cachramungan angelga carcelpa puncunta pagaspa quichrarun. Jinarcurmi paycunata cälliman jorgaramurga cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aywapäcuy Diospa wayin puncuta. Chaychru shayuyur willapapäcamuy runacunata Dioswan mushog cawaypita” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chauraga ángel ningannuylam warag waragla Diospa wayinman yaycarärin. Jinarcurmi galayarärin runacuna yachrachiyta. Nätan chaypagga sacerdöticunapa mas mandagninga chay saduceocunawanmi gayarärichin alinninpag ricasha Israel castacunatam alisca jatun gotucaypag. Jinarcurmi cachrarärin guardiacunata Jesuspa cachran ruragcunata carcelpita aywachipäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nä carcelman chrarärirga Jesuspa cachran ruragcunataga manam taripäcushachu. Chaura carcelpita cutirga willapacarärin cay nirmi: ");
INSERT INTO qvnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Taytacuna, carcelta shumag wichrgashatam tarirärï. Nätan ricag soldäducunatas puncuchru ali cuidarcayagtam. Nätan cárcel puncuta quichrarurga manam pitas ruyichrüga taripäcüchu” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chaynuypa willaräriptin sacerdöticunapa mandagnincunaga, jinaman Diospa wayin ricag guardiacunapa mandagninga cay ninacurcaram: “¿Imanaruntag? ¿Imatag pasarun chaura chay runacunawanga?” ");
INSERT INTO qvnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ninacurcayaptilanmi chrarun juc runa cay nir: “Carcelman wichrgapäcungay runacunaga Diospa wayinchrümi yachrarcayächin”. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Niruptinga Diospa wayin ricag guardiacunapa mandagninga runancunata pushacurcurmi aywacun Jesuspa cachran ruragcunata aywachipäcamunanpag. Pushapäcamura mana magalarmi, chay mayacug runacunapita rumiwan chapisha cayta manchapäcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chaura nä chrarärichimurga, lapan goturarcayagpa naupanmanmi shayarärichin. Chauraga sacerdöticunapa mas mandagnincagmi cay nin: ");
INSERT INTO qvnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nogacunaga ‘Amam pitas cananpitaga pasay yachrachipäcunquichu chay Jesuspita’ nipäcuragmi. Nätan ¿imanirtag cay Jerusalén marcachru lapan runacunata Jesuspita musyarärichinqui? Chaypitaga juchachapäcamaytas munarcayanquitan ‘Jesustaga gamcunam wanurärichinqui’ nirsi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Niptinmi Jesuspa cachran rurag-mayincunawan Pedroga cay nipäcura: “Naupataga Tayta Dios nipäcamangantaran rurapäcushag, chaypitaran runacuna nipäcamangantaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Awillunchicunapa Tayta Diosninmi cawacächimusha Jesusta, cruzchru clävachiypa gamcuna wanuchipäcungayta. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nätan paytam Tayta Diosga jana pachachru chrurarun derëcha lädunman mandag cananpag, jinaman salvacug cananpag. Paymi Israel castacunata juchanpita wanacurcur Diosman cutigcunata perdonayan. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pay Jesuspita nogacunaga ricapäcungätam, mayapäcungätam rimarcayä, jinaman cäsucug runacunaman Dios cachramungan Santu Espiritus chaypitaga musyayanmi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chay nigta mayarärirga alisca piñasham wanuchiylata munapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Chaychru mandagcunawan cayaram Gamaliel jutiyog runas. Payga cara Moisés isquirbinganpita alisca ali yachrachigmi, jinaman cara fariseo nipäcungan castam. Payta lapan runacunam alinninpag ricapäcug. Paymi shayuyur “Cay runacuna washata yargayärichun” nirun, Jesuspa cachran ruragcunapag. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nä yargaräriptin Gamalielga cay ninmi: “Israel casta-mayïcuna, ama cay runacunata imatas rurapäcuychu mana shumag pinsialarga. Yarpachipäcushay ishcay runapita. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jucmi cara Teudas jutiyog. Paymi ‘Nogam Roma runacunapa maquinpita jorgapäcushay’ nira. Chaymi chruscu pachrac runacuna paywan puripäcura. Chaypitam nä Teudasta wanurärichiptinga, chay gatiragnincuna limpu wichicar illacayman aywarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chaypa guepantam censa canan junagcuna Galileapita Judas jutiyog runasi puriratag chranin runacunawan. Payta wanurärichiptin, paypa purig-mayincunas wichicar illacaymanmi aywarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chaymi noga nipäcug: Ama cay runacunata imatas nipäcuychu, antis jina rurapächun. Cay runacunaga quiquilancunapita rurapäcurga illacaymanmi aywapäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nätan Dios ninganta rurapäcuptinga manam ima ruraytas atipapäcunquichu. Diospa contranta ichaga imatas rurarcayanquimanga” niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Niruptinmi chay mandagcunaga “Razonpas” nirärin. Chaura gayarärichin Jesuspa chay cachran ruragcunatam. Jinarcurmi antay antangancama astircurga “Amam masta Jesuspita rimapäcunquichu” nir cachrarirärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nätan Jesuspa cachran ruragcunaga chay mandagcunapa naupanpita yargarärin alisca cushisham Jesuspa janan astisha capäcunganpita. ");
INSERT INTO qvnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Paycunaga lapan junagsi chaynuylam yachrachipäcugsi jinaman willapacurcagsi Jesuspitaga, Diospa wayinchru jinaman juc wayicunachrüsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay junagcunam Jesusman yupachicugcuna nä achca capäcurga chriquinacuyta galacayärira. Chaura Griego castacunam Israel castacunapag cay nir rimapäcusha: “¿Imanirmi nogacuna castachru cayag viüdäcunata mana atendipäcunchu?” ");
INSERT INTO qvnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nigta mayarärirga, chay chrunca ishcayniyog Jesuspa cachran rurag runacunaga, Jesusman lapan yupachicugcunatam goturärichin. Nä gotucarärimuptinga cay nirärinmi: “Jesusman yupachicug-mayïcuna, nogacunaga Jesuspita yachrachiyta dëjarcur manam micuyta aypupäcümanchu. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Antis gamcunapita acrapäcuy ganchris olgocunata. Paycuna capäcuchun Diospa naupanchru ali cawagcama, Santu Espíritu munangannuy cawagcama, jinaman alisca yachragcama, paycuna micuyta aypupäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nätan nogacunaga chaynuylam Diosta manacurcayäshag, jinaman Jesuspita willapatas yachrarcayächishag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nipäcuptinmi Jesusman lapan yupachicugcunaga “Au, alim canga” nipäcura. Chauraga acrarärin Estebantam. Payga cara Jesusman alisca yupachicugmi, jinaman Santu Espíritu munangannuy cawagmi. Chaypitam acrarärin Felipeta, Procorota, Nicanorta, Timonta, Parmenasta, Nicolasta. Nicolasga cara Antioquía marcapitam. Payga mana Israel casta cayarmi Israel castaman muyusha cara. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chaypitam chay acrapäcungantaga Jesuspa cachran ruragcunaman pusharärichin. Chaychrümi paycunaga umancunaman maquincunata chrurayärir Tayta Diosta manacarärin chay acrashacunapa janan. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chaura Tayta Diospa willapanga maychru chaychrüsi masmi willapacayara. Nätan Jesuspa discïpuluncunamansi alisca chraninmi muyurcayara chay Jerusalenchru, jinaman achcam sacerdöticunas Jesús yachrachingannuy cawayta galayarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nätan Estebanga Tayta Dios cuyapälar yanapaptinmi Santu Espiritupa munayninwan ima-aygatas alisca rurayara chay Jerusalenchru. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chaura Estebanpa contranmi sharcarärin Cirenepita, Alejandriapita, Ciliciapita, Asiapita Israel casta runacuna. Paycuna gotupäcug juc wayichrümi. Chay wayipa jutin cara ‘Runapa munayninpita yargoshacunapa gotucarcänan wayi’ nisham. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Chaura Estebanta, Santu Espíritu rimachiptinga chay runacunaga manam ima niytas atipapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chaura chaycunaga juc ishcay runacunatam golgueta gorärin yangacagta “Cay Estebanga Diospitas, Moisespa isquirbishancunapitas lutantam rimara” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chaura chay pägasha runacunaga sucsutarärin alinninpag ricasha chacha runacunatam, Moisés isquirbinganpita yachrachigcunatam. Jinarcurmi lapan chaycunaga Estebanta charircur aywachicurcan chay marcachru mandagcunapa naupanman. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chaypitam Estebanta juchachapäcunanpag ashirärinag mas runacunata, casquicurcur cay nir rimapäcunanpag: “Cay runaga chaynuylam alisca lutanta rimayan Diospa wayinpitas, nätan Moisespa isquirbishancunapitas”. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chaypitas cay Estebanga cay niratan: “Nazaretpita Jesusga Diospa wayinta juchruchingam, jinamanmi imanuy cawapäcunaypagsi Moisés isquirbinganta pampanman rurayur jucnuypa cawachipäcushunqui” niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chaynuy juchachapäcuptinga chay mandagcunaga Estebantam rircärirärin. Jinarcurmi ricaparärin Estebanpa cärantaga angelpa cärantanuy. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chaura sacerdöticunapa mas mandagninga Estebantam cay nin: “¿Cay runacuna razoncagtachu nircayäshunqui?” ");
INSERT INTO qvnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Niruptin payga cay ninmi: “Taytäcuna, wauguëcuna, chaytaga casquitam nircayäman, antis shumag mayapäcamay: Alisca ali Diosga unay taytanchi Abrahamta ricäparura Mesopotamia ningan nacionchru yachrayaptilanmi, manaragsi Haranman aywamuptilanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chaypin Diosga Abrahamta cay niram: ‘Cay Caldea marcaypita, jinaman lapan aylluycunapita aywacuy. Nogam reguechishay maychru yachranaypagsi’. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chaura Tayta Dios ningannuylam Abrahamga Caldea marcanpita Haranman aywacura yachrag. Chay Haranchru yachrayaptinmi Abrahampa taytan wanurura. Chaypitaran Diosga Abrahamta pushamura cay yachrayanganchicagman. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nätan Diosga caychru manam Abrahamta gorachu quiquin cananpag ni juc chraqui jaruyuylatas. Chaypin Abrahampa churin manaragsi cayaptinmi. Diosga ‘Castay aywagtam cay yachrayangaycagta goshag’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chaypitas Tayta Diosga cay niraran: ‘Castaycuna juclä caru nacionchrümi yachranga. Chaychrümi magasha, jinaman juc rantisha runatanuysi chruscu pachrac watantin uryachisha capäcunga. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nätan nogaga cunchuchishagmi chay nacionchru runacunataga. Chaypitaran chay castaycunata yargachimushag caychru servipäcamänanpag’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Chaypitas Diosga conträtatam rurara Abrahamwan señalächicunanpag. Chaymi Abrahamga churin Isaac näciruptin, nä puwag junagniyog cayaptin señalarura. Chaynuymi Isaacsi churin Jacob näciramuptin señalaratag. Chaynuytan Jacobsi chrunca ishcayniyog churincunata señalaratag. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nätan Jacobpa churincunaga chriquicurmi wauguen Josëta ranticarärira Egipto nacionman aywayag runata. Nätan Diosga Josëta manam pasay dëjarachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Paymi ima-ayga laquicuyninchrüsi yanapara. Paytan Faraón nipäcunganpa naupanmanchru alipag ricachicunanpagsi yanapara, jinaman imata rurananpagsi alita tantiachira. Chaypitam Josëta Faraón nipäcungan chrurarura chay Egiptochru mandayta yanapänanpag, jinaman wayinchru capuralnin cananpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Chaypitam José yachrangan Egipto nacionchrüga, jinaman Canaán nacionchrüga micuy wanay alisca carura. Chaypin aliscam runacuna cunchupäcura micuypita. Nätan castanchicunapas manam imas micapäcunanpag carachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chaura Jacobga ‘Egiptochru trïgu taricayanshi’ nigta mayarurga, churincunata cachrarura wamagtam trïgu rantig. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chaypita yapay trïgu rantig cutiräriptinmi ichaga wauguencunata Josëga cay nira: ‘¿Manachu reguepäcamanqui? Nogaga ranticarcämangay Josëmi cayä’ nir, reguechicura. Chaynuypam Rey Faraonga reguerura Josëtaga pipa ayllun cangantas. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chaypitam Josëga Egiptoman gayachira taytan Jacobta lapan castancunatawan. Chaura aywapäcura ganchris chrunca pichgayog runacunam. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chaynuypam Jacobga lapan castancunawan aywacurcara Egiptota yachrag. Chaychrümi taytanchi Jacob wanurura, jinaman churincunasi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chaura Jacobta enterrag aywachipäcamura Siquem ninganmanmi Abraham rantingan machrayman. Chayta Abrahamga rantira Hamor jutiyog runapa churincunapitam. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Chaypitam Abrahamta Dios ningannuyla nä chruscu pachrac watacuna ushanayara. Chaypagga Jacobpa castancunaga alisca achca achcamanmi mirararcayara Egiptochrüga. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chaura José nä wanuruptinga juc reymi yaycurura Egiptochru. Payga manam Josëta reguerachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chay reyga quiquinpa yarpaylanpitam lutanta pinsiacurcur castanchicunata alisca cunchuchira. Jinamanmi ‘Olgo näcimug wamrancunata wicapapäcuchun wanunanpag’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chay junagcunam näcirura Moisés jutiyog wamra. Payga cara Diospitaga alisca cuyasham. Chauraga Moisesta taytancuna wayinchru cachipäcura pacaylapa quima quillayog cangancamam. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chaura nä mana masta cachiyta atiparga, mayu quirunmanmi washachru chruraramura. Chaypitam Egiptochru reypa warmi churinga taricurura. Chauraga cachicura quiquinpa wawantanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chaynuypam Moisestaga Egipto runacuna lapan yachracurcänanta yachrachipäcura. Chauraga alisca ali rimay yachrag runam cara, jinaman alila ruragmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Chaypitam payga nä chruscu chrunca watayog cayar, Israel castancunaman aywara ‘Yanapämushag’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chaychrümi yanapag aywarga ricarura Israel castanchita juc Egipto runa magayagta. Jinarcurmi washanganchrüga chay Egipto runataga wanupacurura. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Chay washarnin Moisés pinsiara cay nirmi: ‘Israel castäcuna musyachun Egipto runacunapa munayninpita Diospa munayninwan noga jorgonäta’ nirmi. Nätan castanchicunaga manam tantiapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chaypitam warantinsi Moisesga tariruratag ishcay Israel castacama peliarcayagta. Chauraga Moisés amachayta munarga cay niram: ‘Runacuna, ¿imanirtag chay castala carcayar peliarcayanqui? Ama chaynuypa ruranacurcaychu’. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Niptinga chay jucninta magag runaga Moisesta cumarirura cay nirmi: ‘¿Pitag gamta chrurarushunqui mandagnïcuna, jinaman fiyisnïcuna canaypag? ");
INSERT INTO qvnNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ganyan Egipto runata wanuchingaynuychu ¿nogatas wanuchimayta munayanqui?’ ");
INSERT INTO qvnNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Niruptin Moisesga gueshpicura Madián ninganmanmi. Chay Madianchru yachrara gorpachacushanuylam. Nätan chaychru cara ishcaymi churinsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Chaura nä chruscu chrunca wata Moisés chay Madianchru yachrayaptinmi, juc junag Sinaí ningan jirca cercan jäpag pampachru ricapurura garajanchray jachra rupayagchru Diospa juc angelninta. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chayta ricapur Moisesga mayacasha niragmi ricacarura. Jinarcurmi ‘Mä shumag ricayamushag’ nir yaycuyar mayarura Munayniyog Dios cay nir rimamugta: ");
INSERT INTO qvnNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moisés, nogam cayä awilluycuna Abrahampa, Isaacpa, Jacobpa Diosnin’. Niruptinga manchacuypita chucchucyaytam galacuyun. Jinaman manam rircäriyta pasay atiparachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chaura Munayniyog Diosga cay niyanmi: ‘Jorgoy sandaliayta. Chay jarurayangay pampachrüga nogam cayä. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nogaga ricayämi Israel casta runäcunata Egiptochru alisca cunchugta, jinaman wagapäcugtas. Chaymi aywarayämü Egiptopita jorgamunäpag. Chauraga gamtam cachrashay paycunata jorgamunaypag’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Chaura Moisesta Israel castanchicuna ‘¿Pitag chrurarushunqui mandagnïcuna jinaman fiyisnïcuna canaypag?’ nir, mana chrasquipäcungantam chay quiquin Moisestam Diosga cachrarura Israelcunata jorgamunanpag, jinaman mandagnin cananpag. Chay jorgamuptin ricapungan angelmi yanapara. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Paymi jorgamura awillunchicunata Dios munayninwan runala mana ruray atipänancunata rurayar. Chaynuy ima-aygatas rurara payga Egiptochrümi, chay jatun Puca Gochra ninganchrümi, jinaman jäpag pampachrümi chruscu chrunca watantin. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Chaura Dios cachrangan Moisesmi Israel castanchicunata cay nira: ‘Tayta Diosga gamcunapa castaycunapitam cachramunga gamcunaman juc willacugnin runata nogata cachramangannuy’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Chay Moisestam Sinaí jircachru ángel rimapara. Chaytam Moisesga jäpag pampachru rimapara awillunchicunata Dios munangannuy ali cawapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nätan awillunchicunaga manam munapäcurachu pay ningan rurayta, antis paycunaga Egiptoman cuticuylatam munapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chaymi Moisespa wauguen Aaronta cay nipäcura: ‘Dioscunata ruraparcämay naupäcunata aywananpag. Egiptopita jorgamagninchi Moisesga illacaruntag manam musyanchichu ima pasangantas’. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chaura niptinmi rurarärira örupita juc becërruta. Jinarcurmi uywacunata wanurcachir rupachipäcura chay diosnincunapag. Chaypitam cushisha fiestata rurapäcura cay nir: ‘Cay ruranganchi diosninchiga maquinchiwan ruracunganchim’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chaura ‘Diosga munanganta rurapäcuy’ nirmi, castanchicunata dëjarura. Chaymi alawapäcura goyllarcunatas. Chaynuy rurar paycunaga rurapäcura Diospa willacugnincuna unay isquirbingannuymi. Diosga isquirbichira cay nirmi: ‘Israel castacuna, gamcunaga manam nogapag ofrendaycunata apapäcamaraychu ni uywaycunata wanurcachirsi rupachipäcuraychu, chay chruscu chrunca watantin wac jäpag pampachru capäcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Antis gamcunaga purichipäcuray Moloc jutiyog diostam wayintinta, nätan Refán jutiyog diosniquicunapa goyllarnintam. Chaycunata quiquiquicunam rurapäcuray, Diosta yupaysi alawapäcunaypag. Chaymi gamcunaga wac caru Babilonia nación wacläninman aywachisha capäcunqui’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Chay jäpag pampachru unay castanchicuna capäcur Diosninchipa wayin nipäcura garapita jatun toldu rurashatam. Nätan Moisesmi chayta rurara ‘Cay ricayangaynuytam ruranqui’ Dios ningannuylam. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chaura unay awillunchicunaga, chay jatun toldu chrasquipäcunganta Josuëwanmi yaycachimura juc casta runacuna yachrarcayanganman. Chaynuypam Diosga chay runacunata gargorura paycuna yachrapäcunanpag. Nätan chaychrüga capäcura Rey David cawangancamam. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nätan Davidtaga cuyapälar aliscam ima-aygachrüsi yanapara Tayta Diosga. Chaymi chay Jacobpa Diosninta manacura: ‘Wayiquitanar rurashag’ nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Chaypita mas guepamanga Davidpa churin Salomonmi sharcachira Diospa wayintaga, ");
INSERT INTO qvnNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","jana pachachru cayag Dios runacuna rurangan wayichru mana yachrag cayaptinsi. Chaymi Diosga Isaiaswan isquirbichira runacuna rurangan wayichru mana yachrag canganpita cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Jana pachaga tayäcunä trönümi, nätan cay pachaga chraquï jaruräcunanmi. ¿Imanuy wayitatag sharcachipäcunqui noga yachranäpag u maylas cayanchu jamanäpagnuy? ");
INSERT INTO qvnNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Lapan ima-aygas noga rurangalämi cayan’ niram. Dios chaynuy rimanganpitam nogataga juchacharcayäman. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nätan gamcunaga rumi shongom carcayanqui. Manam Diospita mayacuytas ni tantiaytas munapäcunquichu. Gamcunaga Santu Espíritu munangannuy cawaytas manam munapäcunquichu chay unay castaycunanuysi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Awilluycunaga Diospa willacugnincunata gaticachrapäcuram, jinaman wanuchipäcuram. Chaynuymi rurapäcura salvacug shamunanpita willacugcunatas. Chay salvacug nä chraramuptinsi contranmi sharcaräriray, jinamanmi wanurärichiray. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gamcunataga angelmi rimapapäcushuray Dios munangannuy cawapäcunaypagsi, nätan manam cäsucurcaraychu”. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chaynuypa nigta mayarärirga Estebanpag aliscam piñäcarärin. Chay piñäcuylapitam quiruncunas wagaricun. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nätan Estebanga Santu Espiritupa munayninchru cayarga jana pachatam rircärirun. Jinarcurmi ricapurun Tayta Diostaga alisca chipchipyar cayagta, nätan Jesustam Diospa derëcha lädunchru shacuyur mandayagta. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chaura Estebanga gayachracuypanuymi cay nin: “Jana pachatam ricapuyä quichrarayagta. Ricapuyätan jana pachapita shamusha runatas Diospa derëcha lädunchru mandayagta”. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Chay nigta mayarärirga alisca gaparayarmi rinrincunata chaparärin. Jinarcurmi paytaga lapan charicarärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Chaypitam marcapita washaman yargarcärichir rumiwan chapirärira. Chay runacunaga chapipäcura Saulo jutiyog runapa naupanman jacuncunata chrurayärirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nätan rumiwan chaynuy chapircayaptinmi, Estebanga manacurun: “¡Munayniyog Jesús, chrasquimaynar!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chaypitam gongorpacuyur gayachracuypanuy cay nira: “Munayniyog Jesús, cay runacunata amam cunchuchinquichu nogata caynuy rurapäcamanganpita”. Chaynuy nircularmi wanurura. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Chaychru Estebanta wanurcayächigta ricar “Wac runataga alitam rurarcayan” niram Sauloga. Chay junagmi galayarärira Jerusalenchru Jesusman yupachicug gotucagcuna ashiyta wanuchipäcunanpag. Chaymi Jesusman yupachicugcunaga Judea ninganpa, jinaman Samaria ninganpa gueshpirärira. Chaura Jerusalenchrüga quëdarärira Jesuspa cachran ruragcunalam. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nätan Estebantaga enterrapacurcara Diosta manchacug ishcay quima olgocunalam alisca wagayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nätan chay Sauloga Jesusman yupachicugcunata ashira wayin wayinmi. Tarirurga warmitas olgotas aywachicug calpanta camärirmi carcelman wichrgananpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chauraga chay Jerusalenpita gueshpig, Jesusman yupachicugcunaga, maypas aywapäcunganpam Jesuspita willapacurcag. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Chaynuytan Felipesi Samaria marcaman gueshpirurga willapacuratag: “Jesusga cara juc ‘Salvacugtam cachramushag’ Dios ninganmi” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chaura runacunaga juc runanuylam Felipe rimanganta shumag mayacurcara Diospa munayninwan runala mana ruray atipänan ruragta ricapäcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chaura achca runacunapitam lutan espiritucuna gapachracuyar yargapäcug, jinaman achcatam cuticächira uncutucushacunatas, rata runacunatas. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chayta ricar aliscam cushicurcara chay marcachru runacunaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nätan Samaria marcachrümi cara juc runa Simón jutiyog. Payga cara unaypita malruragmi. Jinamanmi runacunata engañag “Alisca munayniyogmi cayä” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Chay niptin Samariachru runacunaga lapalanmi chachas wamras shumag mayacurcag. Chaypitam nipäcug: “Cay runaga Diospa munayninwanmi ima-aygatas alisca rurayan” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chaura pay ninganta cäsucurcag, munayninwan ima-aygatas ruragta ricapäcurmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nätan Jesucristopita, jinaman Diospa munayninchru cawaypita Felipe rimagta mayarärirga Jesusman yupachicuytam galacayärira. Jinamanmi bautizächicarärira olgocunas, warmicunas. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chaura chay Simonsi Jesusmanmi yupachicuratag. Jinarcurmi bautizächicurura. Chaypitam Felipeta latucurcura pasay. Nätan Diospa munayninwan ima-aygatas runala mana ruray atipänancuna ruragta ricarga cara pasay mayacasha niragmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nätan Jerusalenchru Jesuspa cachran ruragcunaga Samariachru achca runacuna Diospa willapanta chrasquicurcanganta mayarärirga cachrarärira Pedrotawan Juantam. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chayman Pedrowan Juan chrarärirga Jesusman yupachicugcunapagmi Diosta manacurcara: “Paycunamansi Santu Espirituta cachramuy” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Paycunamanga manaran mayganmansi Santu Espíritu aywamusharagchu cara. Nätan bautizacuytam icha bautizächicarärinagga Jesús ningannuyla. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chaura Pedrowan Juan paycunapa umancunaman maquincunata chrurayur manacaräriptinga, Santu Espiritum aywaramun. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Chaura chay Simonga, chaynuypa Santu Espíritu chrasquipäcugta ricarurga Pedrotawan Juantam cay nirun: ");
INSERT INTO qvnNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Golguetam gopäcushayqui nogamansi maquiquicunata chrurayärimuy gamcunanuysi munayniyog canäpag, pimansi nogas maquïta chruraptï Santu Espirituta chrasquipäcunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Niptinmi Pedroga cay nirun: “Gamtaga golguequi aywayächishunqui cunchuymanmi. Gamga lutantam pinsiayanqui Diospa cagcunata golguewan rantiyta munar. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gamga manam ali runachu canqui nogacuna rurarcayangänuy ruranaypag. Gamga lutan rurag runam cayanqui Diospa naupanchru. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cananga chay juchaycunapita wanacuy, jinaman manacuy Diosta pagta chay lutan pinsiangaycunapita perdonarushunquimansi. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tantiaptïga gamga alisca chriqui runam cayanqui, nätan pachan juchalaychrüran cayanquis”. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Niptinmi Simonga cay nin: “Manacurcaynar nogapag, Munayniyog Diosta chay nipäcamangay nogawan mana ruracänanpag” nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chaura Jesús Dios canganta, jinaman paypita masta willapacarcärirga Pedrowan Juanga achca marcacunapam Jesuspita ali willapata willapacurcayar cutipäcura Jerusalenta chay Samaria marcapita. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chaypitam Munayniyog Dios cachramungan angelga Felipeta cay nin: “Felipe, pasay-pacha ayway Egipto läduman, nätan aywanquiga Jerusalenpita Gaza marcaman aywana camiñumanmi. Chay camiñuga cayan pasay jäpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Niruptinga pasay-pacham Felipega chay jäpag camiñuman aywara. Jinarcurmi chay aywayarga ricapurun Etiopía nacionpita juc runata. Chay runaga cara capasham, jinaman Etiopiachru Candace nipäcungan reinapa golguen charagmi. Payga aywamusha cara Jerusalenta Diosta alawänanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chaura chay runaga cutiyänag cärrunchru tacuyurmi Etiopiata, Diospa willacugnin Isaías isquirbingan libruta leyiräcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chauraga Felipetam Santu Espirituga cay nin: “Felipe, ayway wayrala, jinaman ashuyuy wac cärruyogman”. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Niptin ashuyur Felipega mayarun Isaías isquirbingan leyiyagtam. Chauraga Felipega tapurun: “¿Tantiayanquichu leyiyangayta?” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Chaura chay runaga “¿Imanaypatag tantiashag mana pisi tantiachimag cayaptinga?” nirunmi. Chaura Felipetaga “Jegamuy, jinaman cay lädüman tayucuy” nirunmi. Chaypitam aywacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Chay runa leyiyanganga cara cay nir isquirbisham: “Juc uyshanuymi wanuchisha cara. Nätan juc uyshachu rutupäcuptin upälala cacun, chaynuymi payga mana rimacurachu imatas. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Paytaga chay upälala cangan raygom munanganta rurarärira. Chaynuy wanuchipäcunganpita ¿maygan castanrag rimarcunga paypita?” nir isquirbishatam. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chaura chay Etiopiapita runaga Felipetam tapurun cay nir: “Niyämaynar, ¿pipitatag isquirbira cayta Diospa willacugnin runa? ¿Isquirbira quiquinpitachu u pipitas juc runapitachu?” ");
INSERT INTO qvnNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Niptin Felipega chay runa leyiyanganpita galayurmi willapara Jesuspita ali willapata. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chaypitam chay aywarcayanganchrüga chrarärin yacucagman. Chaura chay runaga Felipetam cay nin: ");
INSERT INTO qvnNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“Caychru cayantag yacu. ¿Imanirtag mana bautizacümanchu?” ");
INSERT INTO qvnNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chaura Felipe “Au, bautizacunquimanmi” niruptinga, chay runaga cärruta shayachinanpagmi nirun. Jinarcurmi cärrupita jegarpurcur yacucagman ishcaynin aywarärin. Chaychrümi Felipega chay Etiopía runata bautizara. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Chaura nä yacupita yargarärimuptinga, Munayniyog Dios cachramungan Santu Espiritum Felipeta mayänipita illacarachin chay runacagpita. Chauraga chay Etiopía runaga manam masta Felipeta ricapurachu. Jinaman cushisham aywacura marcanta. ");
INSERT INTO qvnNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nätan Felipega Azoto marcachrümi ricacarura. Chaypita yargorga marcan marcanmi aywara ali willapata Jesuspita willapacuyar Cesarea marcaman chrangancama. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Chaypita Sauloga chaynuylam Munayniyog Jesuspa discïpuluncunata ashira wanuchinanpag. Chaymi sacerdöticunapa mas mandagnincagman aywara ");
INSERT INTO qvnNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Ordinta gomay Damasco marcachru Israel castäcuna gotucarcänan wayichru Jesús yachrachingannuy cawagcunata tarir, olgocunatas warmicunatas cay Jerusalén carcelman aywachimunäpag” nig. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Chauraga Saulo ordinta apacurcur camiñupa aywayaptinmi nä Damasco marcaman nachrgayaptinga, mayänita jana pachapita alisca achicyaramura. Chauraga ricacarun alisca achicyayag chraupinchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Chaura Sauloga pampamanmi ishquirun. Chaypitam mayasha cay nigta: “Saulo, Saulo, ¿imanirtag nogata gaticachrayämanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Niptinmi Sauloga cay nin: “Tayta, ¿pitag cayanqui?” Niptinga cay nirunmi: “Noga cayä Jesusmi. Nogatam gamga gaticachrayämanqui. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Cananga sharcuy jinaman yaycuy Damasco marcaman. Chaychrümi nishunqui juc runa imata ruranaypagsi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Niruptinga Saulowan aywag runacunaga mana pitas ricapapäcurga aliscam manchacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chaura Sauloga pampapita sharcurcur rircäringanchrüga manam ima ricapuytas atiparachu. Chauraga paywan aywagcunam Saulotaga maquipita janchraypa pushapäcura Damasco marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chaychrümi cara quima junag mana ricapuyta atipayar, manatan imatas micurapishchu ni upyarapishchu. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nätan chay marcachrümi yachrara Jesuspa juc discïpulun Ananías jutiyog. Paytam Munayniyog Jesusga ricäparun jinarcurmi rimaparun: “Ananías” nir. Niptinmi payga “Munayniyog tayta, ¿imalapagmi gayayämanqui?” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Chaura Munayniyog Jesusga cay nirunmi: “Ayway ‘Derëcha’ jutiyog cälliman Judas jutiyog runapa wayinta. Chaychrümi tarinqui Tarso marcapita Saulo jutiyog runata. Payga canan üra nogatam manacayäman. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Chay manacayämarmi ricapurun Ananías jutiyog runa paycagman yaycur maquinta umanman chrurayur ñawin cuticächigta”. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Niptin Ananiasga cay ninmi: “Munayniyog tayta, achca runam willapapäcamara chay Saulopita Jerusalenchru gamlapag cawag runacunata ima-aygatas lutan rurayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nätan cananga cayman aywarayämun fiju sacerdöticunapa mandagnin ordinta gosha captinmi, caychru gamman yupachicugcunata Jerusalén carcelman lapanta aywachinanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Niptinmi Munayniyog Jesusga cay nin: “Ayway Saulocagta. Paytaga acrarayä juc casta runacunata, reycunata, nätan Israel castacunata nogapita willapacamunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nätan quiquïmi tantiachishag nogapa janä ima-aygatas alisca cunchunanta”. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Chaura Ananiasga Judaspa wayinman chrarurga Saulopa umanman maquinta chrurayurmi cay nin: “Jesusman yupachicug-mayï Saulo, cay marcaman aywamuna camiñuchru rimapäshungay Munayniyog Jesusmi cachrayäman ñawiquita cuticächinäpag, jinaman Santu Espiritupa munayninchru cawanayta” ninagpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Niptinga chayüram Saulopa ñawinpitaga ishquirun pescädupa escämannuy. Jinarcurmi ricapuyta yapay galayurun. Jinaman chaylam bautizächicurura. Nätan micuruptinga yapaymi calpansi chraramura. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chay Damasco marcachru Jesusman yupachicugcunawan Saulo cara ishcay quima junagran. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chaypitaga chaylam Israel castacuna gotucarcänan wayicunachru Jesuspita willapacuyta galacuyura cay nir: “Jesusga Diospa-mayinmi cara” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Chay niptin runacunaga mayacasha niragmi ricacarärin. Chaypitam tapunacurcara cay nir: “¿Manachu cay runaga wac Jerusalenchru Jesusman yupachicugcunata gaticachrag? Cay runaga fiju aywarayämun Jesusman yupachicugcunata sacerdöticuna mandagpa naupanman chrarcachir carcelman jitayunanpagmi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nipäcuptin Sauloga masmi Santu Espíritu yanapaptin “Jesusga Dios cachramungan salvacugmi” nir willapacura. Chaynuy niptin Israel casta runacunapagga manam ima nipäcunansi yachracarachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Chaypita achca junag pasashachrümi Israel castacunapa mandagnincunaga rimanacarärira: “Saulota wanuchishun” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nätan chay rimanacurcanganta Sauloga musyaruram. Chaura chay runacunaga pagas junagmi Damasco marcapa puncuncunachru shuyarapäcura, Saulo yargoptin wanuchipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nätan Jesuspa discïpulucunaga jatun canastaman Saulota wiñarcurmi marca muyug altu pergapa, wascawan warcaypa pagaspa yargarärichira gueshpicunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Chaypitam Jerusalenman nä chrarur Sauloga, Jesusman yupachicugcunawan gotucayta munara. Nätan paycunaga lapanmi manchapäcura “¿Razonpachur Jesusman yupachicugman muyurayan u yangachur niyan?” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Chaura Bernabëga pushacurcurmi Saulotaga chrarachin Jesuspa cachran ruragcunaman. Chaychrümi Saulopita willapara Damascoman aywayaptin camiñuchru Munayniyog Jesusta ricapunganta, jinaman Saulota rimapanganta, nätan willaparatan Damascochru yachragcunata mana mancharilar Jesuspita willapangantas. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Chaura Sauloga Jerusalenchru Jesusman yupachicugcunawanmi puripäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jinaman mana mancharilarmi Jesuspita willapacura. Chaynuytan griegopa rimag Israel castacunawansi alisca plëtupäcura. Chaura chay runacunaga Saulota wanuchiytam munapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chayta Jesusman yupachicugcuna tantiarärirga Saulota pusharärira Cesarea ningan marcamanmi. Chaypitam cachrarärira Tarso marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chaura chay wichancunaga Judeapas Galileapas Samariapas Jesusman yupachicug gotucagcuna cawapäcura shumaglam mana pisi gaticachraptin. Nätan waranpa waranpam mas aliman muyurcayara, nätan cawapäcuras Munayniyog Diosta manchacurmi, jinaman Santu Espíritu yanapaptin mas chraninmanmi muyurcayara Jesusman yupachicugcunaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nätan Pedroga marcan marcan Jesusman yupachicugcuna ricapacuyta puriyarmi, yaycuratag Lida marcachru Diospa raquishancunamansi ricapacug. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chaychrümi tarirura uncutucuywan gueshyag Eneas jutiyog runata. Chay Eneasga nä puwag watam uncutucusha cara. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Chaura Pedroga cay ninmi: “Eneas, cananmi Jesucristo cuticächishunqui. ¡Sharcuy! ¡Cämayta alichay!” Niptin chayüram Eneasga sharcurun. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chayta ricarärirga lapanmi Lidachru yachragcunawan Sarón marcachru yachragcunaga muyurärin Munayniyog Jesucristopa runanman. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chaypin caratan Jope marcachru Jesusman yupachicug juc warmis. Paypa jutin cara Tabitam. Griego rimaychrüga ‘Tabita’ ninanga cara ‘Dorcas’ ninanmi. Payga cawag ali ruraycunalata rurayarmi, jinaman mana imaynag runacunata yanapayarmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chaura Dorcasga gueshyaruram, jinamanmi wanurura. Jinarcurmi cuerpunta maylarcurga altusman chrurarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopepita Lidaman cercalam cara. Chaura Pedro Lidachru cayanganta mayarärirmi Jesusman yupachicugcunaga ishcay runata cachracarärira Pedroman “¡Pasay-pachanar aywaläshun Jopeta!” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Chaynuy niräriptin chayüram Pedroga paycunawan aywara. Nä Jope marcaman chraruptinga, Pedrotaga yaycarärichin Dorcas chutarayangan wayimanmi. Chaychrümi Pedrota viüdacunaga lapan muyurärin wagaräcur. Jinarcurmi ricachipäcura Dorcas rurarcur gongan tünicacunata, jinaman jacuncunata. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chaura Pedroga lapan runacunatam washaman yargarachimun. Jinarcurmi gongorpacuyur Diosta manacurun. Chaypitam chay ayacagman rircärirga cay nirun: “Tabita, ¡sharcuy!” Niptinmi wanushaga rircäriramun. Jinarcurmi Pedrota ricapururga tayurpurura. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Chaura Pedroga maquinpita charircurmi yanaparun sharcuyta. Chaypitam chaychru lapan viüdacunata, jinaman Jesusman yupachicugcunata gayarun, Dorcas cawayagta ricapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dorcas cawacämunganpita musyarärira lapan runacunam chay Jope marcachru, jinaman achca runacunam Munayniyog Jesusta chrasquicarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nätan Pedroga chay marcachru cara achca junagcunaran. Chaychru gorpachacusha cara Simón jutiyog runapa wayinchrümi. Chay gorpachag Simón cara garacunata curtig runam. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Chaypinmi Cesarea marcachru cara Cornelio jutiyog runa. Payga cara pachrac Roma soldäducuna mandagmi. Payga lapan soldäduntin capäcura Italiapitam. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Chay Cornelioga, juc casta runa cayarsi, cuyapäcugmi cara, jinaman Dios manchacugmi wayinchru lapan aylluntinsi. Payga mana imaynag runacunatam alisca yanapag, jinaman Dioswansi chaynuylam rimayag. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chaura juc tardim lastresnuy Cornelioga Diosta manacuyara. Jinarcurmi ricapurun Diospita shamusha juc ángel paycagman yaycuyagta. Jinarcurmi chay angelga “Cornelio” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Niptin Cornelioga alisca manchacasham angelta rircärirga cay nin: “Munayniyog tayta, ¿imatatag munayanqui?” Niptinmi angelga cay nin: “Diosga mayasham manacuyniquita, nätan mana imaynagcuna yanapangaytas Diosga musyayanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cananga cachray servigniquicunata Jope marcaman, Pedro nipäcungan Simonta pushapäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payga gorpachacurayan garacunata curtig Simón jutiyog runapa wayinchrümi. Chayga cayan jatun gochra manyanchrümi. Paymi nishunqui imata ruranaypagsi” nin. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chaura ángel nä aywacuptinga Cornelioga gayarun ishcay servignintam, jinaman Diosta manchacug cuyapäcug soldäduntam. Chay soldädu cara Cornelio yupachicunanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Chay quima runancunata ángel lapan ninganta willaparcurga Jope marcatam cachrarun. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chaypitam warantinga chraupi junagnuy Jope marcaman chay quima runacuna nachrgarcayaptin, Pedroga jegarun wayi jananman Diosta manacunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Chaychrümi alisca micanay charirun. Chaura micuyta camarircayangancamam Diosga Pedrota ricaparachin jana pacha quichrarayagta. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jinamanmi ricapurun juc jatun catanuy chruscun manyanpita watasha pay cayanganman uranpayämugta. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chay catachru canag Israel castacuna mana micapäcunan tucuy uywacunam, chruscun chraquinpa purigcunam, raprayogcunam, culebracunam, jinaman pampachru logaypa purigcunam. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chaura Pedroga mayarun jana pachapita cay nimugtam: “Pedro, sharcuy, cay uywacunata wanuchiy micunaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Niptinmi Pedroga cay nin: “Manam Munayniyog tayta. Manam imaysi micurächu cay mana micuna ganra uywacunataga”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Chay niptinga yapaymi Diosga cay nin: “Noga ‘Micuy’ ningagtaga amam lutanpag ricanquimanchu”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chaynuy rimaramun quima cutim. Chaypitaran chay jatun cataga lapan uywantin jana pachata cutircurura. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Chaura Pedro chay ricanganpita mayacasha nirag cayaptilanmi, Cornelio cachracungan runacunaga tapupacur chrarärin chay wayi puncuman. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chaura chay wayichru yachragcunata gayarcurga tapurärin: “¿Caychrüchu gorpachacurayan Simón jutiyog, Pedro nipäcungan runa?” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nätan Pedroga chay ricapunganman aliscam pinsiayara. Chaylam Santu Espirituga payta rimaparun cay nir: “Quima runam ashircayäshunqui. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sharcuy, yarpuy, jinaman paycunawan ayway mana mancharilar. Noga quiquïmi chay runacunata cachrarayämü” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Chaura Pedroga yargorcurmi Cornelio cachramungan runacunata cay nin: “Ashircayangay runaga nogam cayä. ¿Imapagtag munarcayämanqui?” ");
INSERT INTO qvnNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Niptinga cay nirärinmi: “Tayta, aywarcayämü Roma soldäducunapa mandagnin Cornelio cachracarcämaptinmi. Payga Dios manchacugmi, jinaman ali rurag runam. Paytaga Israel castacuna ali runapagmi ricapäcun. Paytam ganyan Diospita shamusha ángel rimapasha wayinman gamta gayachishunaypag, jinaman gam rimangayta mayacur cäsucunanpag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chaura Pedroga chay quiman runacunatam yaycarachin, jinaman gorpacharun. Warantinmi ichaga paycunawan aywacun. Pedrowan aywapäcuratan chay Jopepita, ishcay quima Jesusman yupachicugcunas. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chaura warantin Cesareaman chrapäcunanpagga Cornelioga shuyarayänag aylluncunawanmi, jinaman cuyanacungan runacunawanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chaura Pedro Corneliopa wayin puncuman chraruptinga, yargaramun Cornelioga chrasquicugmi. Jinarcurmi naupanman gongorpacuyun Diospa naupanchrünuy. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Chaura Pedroga sharcarachin cay nirmi: “¡Sharcuy! ¡Ama chaynuy ruramaychu! Nogas gamnuy runalam cayä” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Chaura rimapa wayiman yaycurga tarirun achca runacuna goturarcayagtam. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Chaura Pedroga cay ninmi: “Gamcuna musyapäcungaynuysi nogacuna Israel castaga, manam juc casta runacunawan gotucapäcüchu ni wayinmansi yaycapäcüchu. Nätan Diosga rimaparaman pi casta runacunatas alipa ricanäpagmi, jinaman paycunawan carga manam juchäcunquichu nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chaymi cachramungay runacunawan pasay-pacha aywaramü mana anagyälar, nätan cananga musyaytam munayä imapag gayachimangaytas”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Niptinmi Cornelioga cay nin: “Cananwanga nä chruscu junagmi cayan. Chica lastresnuymi cay wayïchru malagayar Diosta manacuyaptï naupächru ricacarun juc olgo, alisca shumag chipchipyag jacusha. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Chaypitam cay niman: ‘Cornelio, Diosmi mayasha manacungayta, nätan musyayanmi mana imaynagcunata yanapayangaytas. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jinaman cachray servigniquicunata Jope marcaman Pedro nipäcungan Simonta pushapäcamunanpag. Payga gorpachacurayan jatun gochra manyanchru Simonpa wayinchrümi. Chay Simonga garacunatam curtin. Chaura chraramurmi nishunqui ima ruranaytas’ nimanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chaymi cachracamurä pasay-pacha gamman. Nätan alitam rurarunqui aywaramur. Cananga caychru lapanchi goturayanchi Diospa naupanchrümi. Chaura nogacunapag Dios nishungayta lapantam mayacuyta munarcayä”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Cornelio niptin Pedroga cay ninmi: “Mayacamag runacuna: Cananmi ichaga shumag tantiarü Israel castas, juc casta runacunas Diospa naupanchru chaynuyla capäcunganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Antis Diosga pi casta runacunapitas payta manchacugpitaga, jinaman alila ruragpitaga cushicunmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosga naupalatam nogacuna Israel castata musyachipäcamasha Jesucristowan ali willapata, chayta cäsucur shumagla cawapäcunäpag. Pay Jesusmi cananga cayan lapan runapas Munayniyog Diosnin. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nätan gamcunaga shumagmi musyarcayanqui Bautizag Juan bautizanganpitarag Galileapita galayamur Judea ninganchru chay ali willapa willapacanganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Chaytaga willapacura Nazaret marcapita Jesusmi. Paytam Diosga Santu Espiritupa munayninman chrurasha munayniyog cananpag. Chaymi payga alicunata rurayar purira, jinaman lutan espiritucunatas runacunapita gargoyar. Chaynuy rurara Dios paywan captinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nogacunam capäcü Jesús lapan rurangancunata ricagcuna, Judeachrüsi Jerusalenchrüsi. Ricapäcurätan runacuna Jesusta cruzchru clävaypa wanuchipäcungantas. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Paytam Diosga cawacarachimura wanunganpita quima junagta. Nä cawarachimuptinga nogacunalawanmi cara, ");
INSERT INTO qvnNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","manam lapan runacunawanchu. Nogacunatam Diosga acrapäcamasha unaypita-pacha Jesús cawacaramuptin paywan capäcunäpag. Nogacunam cawacaramuptinsi paywanga micapäcuräsi, jinaman upyapäcuräsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Paymi cachrapäcamasha paypita willapacurcänäpag, jinaman cachrapäcamashatan wanushacunapas, cawayagcunapas pay fiyisnin cananpag Dios chruranganta willapacurcänäpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Chay Jesuspitaga mas naupalapitam Diospa willacugnincunas lapan rimapäcura: ‘Payman yupachicugcunaga pi maysi juchancunapita perdonasham canga’ ”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Chay nir Pedro mana rimaytas ushaptilanmi chay lapan mayacurcayag runacunaga mayänipita ricacarärin Santu Espiritupa munayninchru. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Chauraga Santu Espíritu chay juc casta runacunata juc rimaychru rimachigta, jinaman Dios alawagta ricarärirga Jopepita Pedrowan aywamug Israel casta señalächicusha runacunaga mayacasham cay nipäcura: ");
INSERT INTO qvnNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","“Cay juc casta runacunamansi Diosga cachramunagtag Santu Espiritutaga”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nipäcuptinmi Pedroga cay nin: “Diosga cay runacunaman cachraramun Santu Espirituta noganchimannuymi. Chauraga manam pisi paycunataga ‘Ama bautizächicurcaychu’ ninmanchu”. ");
INSERT INTO qvnNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Chaypitam Pedroga mandarun Jesús ningannuy bautizacurcänanpag. Nätan paycunaga Pedrota ishcay quima junaglas “Cayushunragnar” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Chauraga Judea ningan marcacunachru Jesusman yupachicugcunam, Jesuspa cachran ruragcunawan mayarärira juc casta runacuna Diospa willapanta chrasquicurcanganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chauraga Cesareapita cutir Jerusalenman Pedro nä chrarcuruptinmi Moisés ningannuy señalächicushacunaga Pedrota nipäcura cay nir: ");
INSERT INTO qvnNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“¿Imanirtag juc casta runacunapa wayinman yaycuray, jinarcur paycunawan micuray?” ");
INSERT INTO qvnNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nipäcuptinmi Pedroga cay nira: “Canan willapapäcushay lapan pasamangancunata. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Juc tardim Jope marcachru gorpachacurayar, Diosta manacuyarä. Chay manacuyarmi ricapusha cä jana pachapita juc jatun catanuy chruscun manyanpita watasha nogapa naupäman ishquiyämugta. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chauraga naupäman chraramuptin ima cangantas shumag anayunäpagmi cayänag chruscu chraquiyog uywacuna, sima uywacuna, pampachru logaypa purigcuna, pishgocuna. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Chauraga chaylam mayarü Dios cay nimagta: ‘Pedro, sharcuy, cay uywacunata wanuchiy micunaypag’. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nimaptinga cay nïmi: ‘Munayniyog tayta, manam micümanchu. Nogaga manam imaysi micurächu ganra mana micuna uywacunataga’. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Chauraga yapaymi rimaparaman jana pachapita cay nir: ‘Noga “Micuy” ningagtaga amam gamga lutanpag ricanquimanchu’. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chaynuy quima cuti nircamarga jana pachamanmi Diosga cutichicun chay jatun catanuytaga lapan uywantinta. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Chaylam quima olgocuna chay gorpachacungä wayiman chrarärimun. Paycunataga cachramusha Cesarea marcapitam nogata pushapäcamänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nätan nogataga Santu Espiritum nimasha mana anagyälar paycunawan aywanäpag. Aywapäcurätan caychru sogta cayag Jesusman yupachicugcunawansi. Cesareaman nä chrarurga, yaycarärï chay cachracamug runapa wayinmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Chaychrümi chay runaga willaparäriman juc angelta wayinchru ricapunganta. Jinaman naupanchru shacuyur cay ninganta: ‘Cachray runaycunata Jope marcata Pedro nipäcungan Simonta pushapäcamunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paymi ali willapata willapapäcushunqui. Chay willapata chrasquicurmi gamsi, jinaman wayiquichru cagcunas lapay salvacurcanqui’ ninganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chauraga ali willapata willapayaptïmi chay runacunaman aywaramun Santu Espíritu noganchiman aywamungannuy. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chauraga yarparü Munayniyog Jesús cay ningantam: ‘Bautizag Juanga yacuwanmi bautizara, Dios munangannuyla cawashag nigcunatam. Nätan gamcunaga Santu Espíritu munangannuymi cawapäcunqui’ ningantam. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nätan noganchiman Diosga Santu Espirituta cachramura Munayniyog Jesusman yupachicusham. Nätan paycunamansi Santu Espirituta Diosga cachraramun Munayniyog Jesusman yupachicurcaptinmi. Chaura nogaga ¿pitag cayä Diosta ‘Ama chaynuy ruraychu’ ninäpag?” ");
INSERT INTO qvnNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chaura Pedro ninganta mayarärirga upäläcayäriram. Jinarcurmi Diosta alawapäcura cay nir: “¡Chaura cananga juc casta runacunas juchanpita wanacugcagga Dioswanmi imaycamas cawapäcunga!” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Chauraga Estebanta wanurärichiptinga Jesusman yupachicugcunataga masmi ashipäcura wanuchipäcunanpag. Chaymi waquinga gueshpirärira Feniciacama, Chiprecama, jinaman Antioquía marcacama. Chay gueshpirga ali willapata willapacurcara Israel castacunalatam, nätan manam juc casta runacunataga. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chay gueshpigcuna waquinga capäcura Chiprepitam, jinaman Cirenepitam. Paycunaga Antioquiaman chrarurga manam Israel castacunalatachu willapacurcara Munayniyog Jesuspita, willapacuratan juc casta runacunatas. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nätan paycunataga Munayniyog Jesusmi yanapara chay willapacurcaptin, jinaman achca runacunam juchancunapita wanacurcur Munayniyog Jesusman yupachicurcara. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chauraga chay juc casta runacuna Jesusta chrasquicurcanganta musyarärirga, Jerusalenchru Jesusman yupachicug gotucagcunaga Bernabëtam cachrarärin Antioquiata. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nä chrarurga ricarura juc casta runacunata Dios cuyapälar alisca yanapayangantam. Chaura alisca cushisham cay nira: “Gamcunaga lapan shongoypa Jesusman yupachicurcayay, jinaman chaynuyla paywan cacurcayay” nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabëga cara ali runam, Santu Espiritupa munayninchru cawagmi, nätan Jesusman alisca yupachicugmi. Chaynuy captinmi Antioquiachru runacunaga Munayniyog Jesuspa runancunaman alisca achca yapacarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chaypitam Bernabëga Tarso marcata aywara Saulo ashig. Nä Saulowan tincururga Antioquiatam pusharamura. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chauraga chay Antioquiachru Jesusman yupachicug gotucagcunawanga capäcura juc watam achca runacunata yachrarcayächir. Chay marcachrümi Jesusman yupachicugcunata runacunaga jutiparärira wamagta “Cristiano” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chay wichanmi Antioquiaman chrarärimura Jerusalenpita Diospa willacugnin runacuna ishcay quima. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Paycunapitam Agabo jutiyog runaga Santu Espíritu rimachiptin shayuyur cay nira: “Canga alisca micuy wanaymi cay pachachru”. Chauraga chay ningannuylam carura micuy wanay, Claudio jutiyog runa Romachru mandayaptin. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Chauraga Antioquiachru Jesusman yupachicugcunaga rimanacarärira capunganpita gotupäcunanpagmi, Judea ninganchru Jesusman yupachicugcunaman apachipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Chaypitam nä goturärirga aparärichira Bernabëwan, jinaman Saulowan Judeachru Jesusman yupachicugcunapa mandagnincunaman paycuna aypupäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nätan chay wichanmi Rey Herodesga Jesusman yupachicug gotucagcunapitaga juc ishcayta charirachira cunchuchinanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jinamanmi Juanpa wauguen Jacobota espädawan tucsiypa wanurärichira. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chay wanuchinganpita Israel castacunapa mandagnincuna “Alitam rurarun” nipäcuptinmi, Herodesga Pedrotas charirachira. Chay junagcunaga cara fiestam. Chay fiestachru micapäcug mana levaduraynag tantatam. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Chaura Pedrota nä carcelman wichrgacurcurga, Herodesga chrurarun chrunca sogtayog soldäducunatam, chruscucama raquinacurcur Pedro wichrgarayanganta ricapäcunanpag. Chaynuy rurara “Cay Pascua fiesta pasaruptinran Pedrota runacunapa naupanman jorgoshag, runacuna juchachapäcunanpag” nir pinsiarmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Chaura Pedroga alisca cuidasham carcelchru wichrgarara. Nätan Jesusman yupachicug gotucagcunaga chaynuylam Diosta alisca manacurcayara Pedropa janan. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chaura Rey Herodes “Waram jorgoshag” ningan pagas Pedroga punurayara ishcay soldäducunapa chraupinchrümi ishcay cadenawan watasha ichog maquinpita juc soldäduman watasha jinaman derëcha maquinpita jucag soldäduman watasha. Nätan waquin soldäducunam capäcura cárcel puncuchru cuidarcayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chauraga Munayniyog Dios cachramungan angelmi mayänipita ricacarun Pedropa lädunchru. Jinarcurmi cárcel ruyisi alisca shumag achicyarun. Chaura angelga Pedropa wagtantam tupayurun ricchananpag. Chaypitam cay nin: “Pedro, ¡wayrala sharcuy!” Niptinga chaylam Pedropa maquinpita cadenaga cachracarun. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Chaura angelga yapaymi cay nin: “Jacucuy, jinaman sandaliayta jaticuy”. Chaypitam nä limpu jaticuruptinga angelga cay nintag: “Cananga catayta catacurcur guepäta shamuy”. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Niptin Pedroga angelpa guepantam yargaramun. Nätan payga manash ni yangalas tantiarachu ángel rurayangantaga, antis pinsiara cay nirshi: “Jorgayäman cay ángel ¿razonpachur u Dioschur chaynuypa ricapayächimansi?” nirshi. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Chauraga pasarärimun ruyicag puncutam soldäducuna shararcayaptin. Chaypitam chraupicag puncutas soldäducuna shararcayaptin. Jinarcurmi cälliman yargona jatun fierru puertaman chrarärimuptinga quichracarun quiquilan. Chauraga yargarärimun cällimanmi. Chaypitam nä juc cällicama pusharcurga, angelga illacarun. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Chaura chaylam Pedroga shumag tantiarun. Jinarcurmi cay nin: “Cananmi ichaga musyarü razonpa canganta. Munayniyog Diosmi angelninwan jorgarachiman Herodespa maquinpita, jinaman Israel castäcuna lutanta rurapäcamänanpita”. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chaura chay nir tantiachracurcurmi Pedroga aywacun Mariapa wayinta. Mariaga cara Juanpa mamanmi. Nätan chay Juantam, Marcos nipäcug. Paypa wayinchrümi Jesusman yupachicugcunaga achca goturapäcunag Diosta manacurcayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chay wayiman chrarur, Pedro sawanta töcacuruptinga Rode jutiyog jipashmi yargaramun pi cangantas ricag. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Chaura Pedropa shiminta mayarurga, alisca cushicuypitam puertata mana quichralar chay goturarcayangan wayi ruyiman wayrala yaycurcur cay nirun: “¡Pedrom washa puncuchru cayan!” ");
INSERT INTO qvnNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Niptinga goturarcayag runacunaga “¿Imanuypatag Pedroga canga? Fisyuychri perdirayan” nirärin. Nätan jipashga yaparcur yaparcurmi “Razonpa, Pedromar cayan” nira. Chaura paycunaga “Almanchri cayan” nipäcuram. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nätan chaycama Pedroga chaynuylam puertata tocacuyara. Jinarcurmi puncuta quichrarärir Pedrota ricaparärirga mayacasha nirag ricacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Chaura upälala capäcunanpagmi Pedroga maquinwan sëñasta rurarun. Jinarcurmi willaparun imanuypa carcelpita Munayniyog Dios jorgamungantas. Chaypitam cay nira: “Chayta willapäcamuy Santiagotawan Jesusman lapan yupachicugcunata”. Nircurga yargormi jucläpa aywacura. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nä pacha wararamuptin soldäducunaga aliscam löcutacarärira Pedropita imatas mana musyapäcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Chaura Rey Herodesga soldäducunawanmi ashichira. Mana tarirga cuidag soldäducunatam Pedro imanaypa illacangantas tapupara, mana imatas musyapäcuptinga, chay soldäducunata wanuchipäcamunanpagmi nirura. Jinarcurmi Rey Herodesga Judeachru cayanganpitaga aywacura Cesareata yachrag. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Chaypin Rey Herodesga alisca piñasham cara Tïro marcachru, jinaman Sidón marcachru runacunapag. Chay runacuna cawapäcug cara Herodes micuy ranticungalanwanmi. Chaymi paycunaga rimanacarärira Herodesman aywapäcamunanpag. Chaura nä Cesareaman chraramurga Blasto jutiyog runatam shumaglapa rimaparärira Herodeswan rimananpag. Chay Blastoga cara Herodespa golguen charagmi. Chauraga Blastopash Herodesta manacarärin cay nir: “Cananpita alinar cawashun yapay”. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chaynuy nipäcuptin Herodesga jitarura juc junagchru gotucapäcunanpagmi. Chaura ningan junag chraramuptin Herodesga rey jacuränan jacunta jacucurcurmi tacuyun, juchacuna taripäcunancagman. Chaychrümi runacuna rimapayta galacuyun. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Chay rimanganta mayarmi runacunaga gaparäcurcan: “Cay rimayämugga Diosmi. Manam runachu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chaylam Munayniyog Dios cachramungan angelga Herodesta gueshyarachira “Diosta alawapäcuyga ama nogataga”, chay runacunata mana ninganpita. Chaylam curucuna micuyaptilan wanurura. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Chaura Munayniyog Diospa ali willapanga masmi maychru chaychrüsi willapacayara. ");
INSERT INTO qvnNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nätan Bernabëwan Sauloga chay apachicuy apapäcamunganta Jerusalenchru Jesusman yupachicug gotucagcunata gorcärirga Antioquía marcatam cuticurcara Marcos nipäcungan Juan jutiyog mözuta pushacurcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Chaypagga Antioquía marcachru Jesusman yupachicugcuna gotucagchru carapäcura juc ishcayga, Diospa willacugnincunam, jinaman capäcuratan Jesuspita yachrachigcunas. Paycuna capäcura Bernabëmi, ‘Yana’ nipäcungan Simonmi, Cirene marcapita Luciom. Chaypitam cara Saulo, jinaman Manaén. Chay Manaenga cara Galileachru Rey Herodes cachicungan runam. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Chaypitam juc junagchru Jesusman chay yupachicugcuna Tayta Diosta alawarcayaptin, jinaman malagarcayaptin Santu Espíritu cay nirun: “Bernabëtawan Saulota niyärilay. Paycunataga nogam nä acrarayä Jesuspita willapacug aywapäcunanpag” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chaura malagarcärirga, jinaman Diosta manacarcärirga, Bernabëpa Saulopa umanman maquincunata chrurayärirmi cananpitaga “Jesuspitam willapacurcanqui” nirärin, jinamanmi “Aywapäcuy” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Chaypitam nä Santu Espíritu cachraruptinga Bernabëwan Sauloga jatun gochra manyanchru Seleucia ningan marcaman chrarärin. Chaypitam büquiman jegarcur, aywacurcan Chipreta. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chaura nä Salamina ningan marcaman chrarärirga, Dios ningantam willapacarärin Israel castacuna gotucarcänan wayicunachru. Nätan Juan Marcosmi paycunawan cayara yanapänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Chauraga chay tishgochrüga lapan marcacunatam purirärin Dios ninganta willapacurcayar Pafos ningan marcaman chrapäcungancama. Chaychrümi tincurärin Barjesús jutiyog Israel casta runawan. Payga cara malrurag runam. Jinamanmi “Nogaga cayä Diospa willacugninmi” nir casquita rimag. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Chay runaga pasay purig cara Chipre tishgochru mandag Sergio Paulo jutiyog runawanmi. Sergio Pauloga cara alisca yarpaysapa runam. Paymi Diospita mayayta munar, Bernabëtawan Saulota gayarachin Diospa ali willapanta willapapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Chauraga Bernabëwan Saulo, Sergio Pauloman chraräriptinga, chay malrurag runaga manam munarachu Jesuspita chay mandag Sergio mayacunanta Jesusman mana yupachicunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Chauraga Pablo jutiyog Sauloga Santu Espiritupa munayninchru carmi, chay malruragta rircacurcur, ");
INSERT INTO qvnNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","cay nirun: “¡Runacunawan alipa ricachicug casqui, tucuy lutan rurag runa! ¡Asyagpa runan! Ali ruraycuna chregnig. ¿Imaycamatag ‘Dios mandangancunataga ama cäsucurcaychu’ nir runacunata amachanqui? ");
INSERT INTO qvnNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Canan üram Dios cunchuchishunqui. Cananga ñausham unaylarag canqui. Chaura manam ricapunquichu achicyagta”. Niruptinga chayüram chay malrurag Elimasga ricacarun pasay yanauyagchru. Nä mana aywayta atiparga, runacunatam jucta jucta “Janchralämaynar” nin. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chaura Sergio Pauloga Elimas ñaushata ricarurga, Jesusman yupachicuytam galacuyun. Chaypitaga Munayniyog Jesuspita yachrachipäcunganpitas mayacasha niragmi cara. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chay Pafospita Pabloga purig-mayin runacunawanmi awacurcan büquiman jegarcur Panfiliachru cayag Perge ningan marcaman. Nätan Juan Marcosga paycunata dëjarcurmi, Jerusalenta cuticura. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nätan paycunaga Perge marcapita aywacurga chrarärin Pisidiachru Antioquía marcamanmi. Jinarcurmi jamana junagchrüga Israel castacuna gotucarcänan wayiman yaycurcur tayarärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Chaura Moisés isquirbinganta, jinaman Diospa willacugnincuna isquirbinganta leyircurga, chay gotucarcänan wayichru mandagcunaga cachrarärin juc runatam Pabloman “Wauguecuna, imalatas rimapapäcamayta munarga mä rimapayärimay” nichig. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Chaura niräriptin Pabloga sharcurcurmi, maquinwan sëñasyarun cachracyapäcunanpag. Chaypitam cay nin: “Israel castäcuna, jinaman Diosta manchacug taytacuna, canan mayapäcamay shumag: ");
INSERT INTO qvnNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Unay castanchi Israelcunata Tayta Diosmi acrara paypa runam capäcunanpag. Paycunata Egipto marcachru jucläpita aywacusha cayaptinsi, Tayta Diosmi achcaman mirananta munara, jinaman Diosga jorgaramura munayninwanmi chay marcapita. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Chaypitaga jäpag pampachrüsi chruscu chrunca watanuyran mana ali cawarcayaptinsi Diosga awantara. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Chaypitaga Canaán ninganchrüsi ganchris marcachru yachrag runacunata guërrachru yalipäcunanpagmi chay castanchita Diosga yanapara chaychru yachrapäcunanpag. Chauraga chruscu pachrac pichga chrunca watanuymi Diosga chay unay castanchicunata yanapara. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Chaypitaran Diosga chrurara fiyiscunata chay castanchicunata mandananpag. Chay fiyiscuna mandapäcura Diospa willacugnin Samuelcamam. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chaypitam castanchicunaga Samuel mandanan wichanga Diosta manacurcasha cay nir: ‘Juclä marcacunapatanuynar reynïcunata chruraparcämä’. Nipäcuptinmi Dios chrurapura Saúl jutiyog runata reynincuna cananpag. Payga cara Benjaminpa castanmi, Cis jutiyog runapa churinmi. Payga chruscu chrunca watam rey cara. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chaypitam Saultaga rey cayaptin Dios jorgorura. Jinarcurmi trucanta acrarura Davidta. Paypitam Diosga cay nira: ‘Isaïpa churin Davidtam tarirü shongöman yaycugta. Payga lapan ningätam cäsucamanga’ nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Chay Davidpa castan shamugpitam Diosga cachramusha Jesusta, ima-aygapitas Israel castata jorgonanpag, awillunchicunata unay ningannuyla. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nätan manaragsi Jesús reguechicungancamaga Bautizag Juanmi lapan runacunata rimapara: ‘Israel casta-mayïcuna, jucha rurayangaypita wanacurcur, Diosman cutipäcuy, jinaman bautizacurcay’ nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Chaypita nä wanunan nachrgayämuptinsi Juanga rimara cay nirmi: ‘Gamcuna pinsiarcayangaynuysi nogaga manam cä salvacugchu. Nogapa guepätam icha aywayämunga salvacugga. Paypagga manam maygan alinnin runas cächu ni sandalianta pasquipunaläpagsi’ niram. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abrahampa ayllun aywag castäcuna, jinaman Diosta manchacug taytacuna, gamcunapagmi Diosga Jesusta cachramusha ima-aygapitas jorgapäcushunaypag. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nätan Jesuspitaga wac Jerusalenchru yachragcunapa mandagnincuna manam tantiapäcushachu imapag pay aywamusha cangantas, jamana junagcunachru Diospa unay willacugnincuna isquirbingancunata chaynuyla leyircayarsi. Chaynuypam paycunaga Diospa willacugnincuna isquirbinganchru ‘Jesustaga wanuchipäcungam’ ninganta quiquincuna rurapäcusha. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Paytaga mana juchaynag cayaptinsi mandag Pilatota manacurcara wanuchinanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chaura Diospa willacugnincuna Jesuspita isquirbipäcungannuyla lapan nä ruracaruptinga, cruzpita Jesuspa cuerpunta jorgarcärimurmi enterrapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nätan Diosga cawacächimusha chay wanushapitam. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galilea ninganpita Jerusalenta paywan aywasha runacunatawan chay cawacaramur Jesusga ricapachicura achca junagran. Chay ricag runacunam cananga Jesuspita willapacurcayan lapan runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Chay unay awillunchicunata ‘Salvacugtam cachramushag’ Dios ninganpitam nogacunas willaparcayag ali willapata. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nätan noganchi castacuna aywag casta raygom Diosga Jesusta cawacächimusha, Salmoschru cay nir isquirbirayangannuy: ‘Gam cayanqui churïmi. Cananpitaga noganuymi imaycamas cawanqui’ nir isquirbishanuymi. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Chauraga chaynuy nirga nämi Dios nisha cara Jesusta cawacächimunanpita, jinaman mana cuerpun ismunanpita. Chaymi isquirbishacunachrüsi cay niyan: ‘Rey Davidta ningäcunataga razonpam rurashag’ niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yapaytan Jesusta Dios cawacächimunanpitaga Salmoschrüsi cay niyan: ‘Tayta Dios, amam munanquichu Dioslapag cawag servigniquipa cuerpü ismunantas’ niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Chaura Davidga razonpam cay pachachru cawarnin Israelcunapa reynin carga, Dios ningannuy rurara. Chaypitam wanuruptinga taytancunacagman enterraräriptin cuerpunsi ismurura. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nätan Jesuspaga manam cuerpun ismushachu Dios cawacächimusha captin. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Chaymi gamcuna castäcunaga, nä tantiapäcunquiman runacunapa juchancunata Dios nä perdonayanganta, jinaman Jesuspita nä willapacayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chaura cananga lapan runacunasi Jesusman yupachicugcuna carcayan ‘Nä mana juchaynagmi cayanqui’ nisham Diospita. Nätan Moisés isquirbinganta cäsucugcuna manam chaynuy nisha cayta atipapäcuraychu. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Chaura mayapäcamay shumag: Ali willapata chrasquicurcay gamcunatatag ichaga pasarärishunquiman Diospa willacugnin cay ningan: ");
INSERT INTO qvnNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Gamcuna mana cäsucugcuna, manchacapäcuy, jinaman illacapäcuy. Noga Diosmi rurashag gamcuna cawarcayangay wichan juc rurayta, nätan manam chay rurayangäpita pi willapapäcushuptiquis “Razonpachr Diosga rurayan” nipäcunquichu maygaysi’ nira”. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Chaura nä rimayta ushacurcur Israel castacuna gotucarcänan wayipita yargarcayamuptinmi Israelman muyusha runacunaga Pablotawan paywan purig runacunata cay nirärin: “Sábadu aywayämugchrüsar yapay yachrachipäcamay, cay yachrachipäcamangaycunapita” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chauraga chay wayipita nä wichicaräriptinga, Pablotawan Bernabëtaga Israel castacuna achcam gatirapäcura. Jinaman gatirapäcuram Israel castaman muyusha ali cawag runacunas, nätan Pablowan Bernabëga chay runacunata cay nipäcuram: “Canannuylar imaycamas cacurcayay, cuyamarlanchi ima-aygachrüsi yanapämagninchi Diosninchita servircayar”. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chauraga chay jamana junag yapay chraramuptinga nachrga lapalanmi gotucarärin Israel castacuna gotucarcänan wayiman, Diospita yachrachipäcuptin mayacurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Chaura chay achca runacuna goturarcayagta ricaparärirga, waquin Israel castacunaga aliscam piñäcarärin. Jinarcurmi Pablowan Bernabé ali willapata willapäcurcayaptin chaycunaga contran sharcarärin. Jinamanmi waccuna “Yachrayächinganta ama cäsucurcaychu” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chaynuy nipäcuptin Pablowan Bernabëga mana mancharilarmi cay nirärin: “Gamcunamanmi naupata Tayta Diosga cachrararcayäman pay nipäcamanganta willapapäcunagpag. Chaura canan yachrarcayächingagta mana chrasquiyta munarcayarga Dioswan imaycamas cawaytam mana munapäcunquichu. Chaymi cananga ali willapa willapacug aywacurcäshag juc casta runacunaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Paycunaman aywapäcunäpagmi Diosga cachrarcayäman cay nir: ‘Gam canqui juc achicyagnuymi juc casta runacunapag. Gammi ali willapata willapacunqui salvacugpita cay pachapa tumancama’ nir”. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chaura juc casta runacuna chay nigta mayarärirga, aliscam cushicarärin, jinaman “Munayniyog Jesuspita willapämanganchiga alisca alim” nipäcuram. Chaura chay juc casta runacunapitas, ali willapataga chrasquicurcara Dioswan imaycamas cawapäcunanpag unaypita acrasha cagcunalam. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chaynuypam Jesuspita willapaga limpu mayacasha chay puripäcungancagpaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nätan waquin Israel castacunaga alinninpag ricasha warmicunatawan marca mandag olgocunatam nirärin cay nir sucsutapäcunanpag: “Cay runacunata gargoshun cay marcanchipita” nipäcunanpag. Chay nipäcungannuylam Pablotawan Bernabëtaga gargarärira chay marcanpita. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chaura Pablowan Bernabëga chay marcapita yargarärin chraquincunaman alpa latucashata tapsicarcärirmi. Chaynuy rurapäcura: “Gamcunapitachr cananga imanuysi cacurcanqui nipäcunan trucam”. Jinarcurmi aywacurcara Iconio marcata. ");
INSERT INTO qvnNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nätan Jesusman yupachicugcunaga Santu Espiritupa munayninchru alisca cushisham capäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chaypitam Iconio marcaman nä chrarärirga, Israel castacuna gotucarcänan wayiman yaycarärin. Jinarcurmi Jesuspita yachrarärichiptin, Israel castacunawan juc casta runacunaga Jesusta chrasquicarärira achca. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nätan Jesusta mana chrasquicug Israel castacunaga, juc casta runacunatam yachrarärichin: “Jesusman yupachicugcunaga lutan runacunam” nipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chay nircayaptinsi Pablowan Bernabëga Munayniyog Jesusman yupachicurmi mana mancharilar yachrachipäcura unaylarag. Nätan Tayta Diosga cuyapälarmi chay yachrarcayächingan razoncag willapa canganta musyachira, mana runala ruray atipänancunata ima-aygatas rurachiypa. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Chay marcachru yachragcunaga ishcay puntamanmi raquicarärira. Waquinmi “Pablowan Bernabëga alim” nipäcura. Nätan waquinga “Israel casta yachrachigcunam mas aliga” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chauraga Israel castacunawan juc casta runacunam chay marcachru mandagnincunawan rimanacarärin Pablotawan Bernabëta ashlipäcunanpag, jinaman rumiwan chapipäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Chayta musyarärirga Pablowan Bernabëga gueshpicurcara Licaonia ninganchru Listra marcamanmi, jinaman Derbe marcamanmi. Aywapäcuratan chaypa cayag lapan marcacunamansi. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chaycunapam puripäcura Jesuspita willapacurcayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Chaura Listra marcachrüga tayayänag juc rata runam mana pasay puriy atipag. Chay runataga maman gueshyacurura ratatash. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Chaura payga Pablo rimayangantam mayacuyara, nätan Pabloga chay runata rircärirga tantiarun Dios cuticächinanpag yupachicuyangantam. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Chaura Pabloga gayacuypa niragmi cay nirun: “¡Sharcuy. Shumag shayuy!” Niptinmi runaga chayüra shayurun. Jinarcurmi puriyta galayurun. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Chaura runacunaga Pablo chay rata cuticächigta ricarärirga, gayacuypanuymi Licaonia rimayninchru: “¡Caycunaga diosmi runaman muyusha chrarärimun!” nipäcura. Chay rimayta manam paycunaga tantiapäcurachu. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Chaura Bernabëpagmi nipäcura: “Payga mayorcag diosmi” nir, jinaman Diospita yachrachig captinmi Pablopag nipäcura: “Payga dios Hermesmi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Chay marca yaycunachrümi canag juc wayi Júpiter ningan diospag rurasha. Chaura chay wayichru sacerdötim alisca shumag waytapasha törucunata gaticurcur chrarachin marca puncuman. Chay törucunatam payga chaychru waquin runacunawan wanurcachir rupachiyta munapäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Chauraga Pablowan Bernabëga paycunapag rupachiyta munapäcunganta tantiarärirga jatirarcayangan jacuncunatam lachirärin piñasha. Jinarcurmi chay achca runacuna cayagman yaycarärirga gayachracuypanuy cay nipäcura: ");
INSERT INTO qvnNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Taytacuna, ¿imanirtag cayta rurarcayanqui? Nogacunaga manam dioschu capäcü antis gamcunanuysi runalam. Nätan canan aywararcayämü chay lutan rurarcayangaypita wanacurcur imaycamas cawag Diospa runanman muyupäcunaypag, ali willapa musyachigmi. Pay Diosmi wac jana pachatas cay pachatas jatun gochratas lapan imantawansi camara. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nätan unay wichancuna Tayta Diosga rircaylam rircarara pi may runatas shongon munanganta rurapäcuptin. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Chaynuy cawarcayaptinsi Diosga chaynuylam reguechicura, imas aygas yanapanganwan. Chaura paymi tamyachimunsi usyachimunsi tarpucunganchi ali gueshpinanpag. Chaynuypam micuyta aypata gomanchi cushisha cawananchipag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chaynuypa nircayaptinsi runacunaga manam wiyaripäcurachu. Alisca sasataran chay runacuna törucunata wanurcachir rupachipäcunanpita amachacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chauraga Antioquiapitam, jinaman Iconio marcapitam Pablotawan Bernabëta chregnig Israel-mayincuna Listraman chrarärimun. Chaypitam chaychru yachrag runacunataga cay nirärin: “Caycunaga alisca lutantam rurarcayan. Wanuchishun”. Nipäcuptin chay runacunaga “Äri” nirmi, Pablota rumiwan chapirärira. Jinarcurmi “Nä wanushachr cayan” nir garashtapäcura marcapita washaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Chaypitam Jesusman yupachicugcuna muyuräriptinga Pabloga sharcaramun. Jinarcurmi yaycurun marcaman yapay. Warantinmi ichaga Listrapita aywacurcara Pablowan Bernabëga Derbe marcata. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chaura Derbe marcachru Jesuspita willapacaräriptinga, achca runacunam Jesuspa discïpulunman muyurärin. Chaypitaga cutipäcamura Listrapam, Iconiopam, Pisidiachru Antioquía marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chay marcacunapa cutirga Jesusman yupachicugcunata cay nirmi valorchapäcura: “Jesuspita mana raquicälar, jinaman Jesusman chaynuyla yupachicular cawapäcuy” nipäcura. Chaypitas cay nipäcuraran: “Diospa munayninmanga yaycushun ima-ayga cunchuytas awantar-ran” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chaypitas paycunaga marcan marcanmi chrurapäcura Jesusman yupachicug gotucagcunachru mandagcunata. Jinarcurmi chay chrurapäcungan runacunapa janan manacarcärirga malagayärirga, cay nipäcura: “Munayniyog Dios, gamnar cay yupachicushugniqui runaycunata yanapay” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chaypitam Pisidia ninganpa pasarga chrarärin Panfilia ninganman. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Chaypitam Panfiliachru cayag Perge marcaman chrarärirga Jesuspita willapacurcara. Jinarcurmi chaypitaga uranpapäcura Atalia marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chay Atalia marcapitam büquiwan cuticurcara Siriachru Antioquía marcaman. Chay Antioquiapitam paycunaga yargapäcusha cara Jesuspita willapäcug, Dios cuyapälar yanapänanpag paycunapita manacarcäriptin. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nä Antioquía marcaman chrarärirga, Jesusman lapan yupachicug gotucagcunatam goturärin. Chaychrümi paycunata Pablowan Bernabëga willaparärin lapan ima-aygatas Diospa munayninwan rurapäcunganta, jinaman juc casta runacuna Jesusman yupachicurcanganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chaura chaychru, Pablowan Bernabëga capäcura unayran Jesusman yupachicugcunawan. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chay wichanmi Judea ninganpita Antioquía marcaman juc ishcay Israel casta runacuna chrarärin. Jinarcurmi Jesusman yupachicug-mayinchicunata cay nir yachrachipäcura: “Moisés isquirbinganchru ningannuy mana señalacurcarga manam salvacurcanquichu” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chaynuy yachrachipäcuptinmi Pablowan Bernabëga “Manam chaynuychu” nir, alisca tapunacuyta galacayärin chay runacunawan. Chaymi Antioquiachru Jesusman yupachicugcunaga cachrarärin Jerusalenta Pablotawan Bernabëta, Jesusman juc ishcay yupachicugcunatawan. Chaychru Jesuspa cachran ruragcunawan, jinaman Jesusman yupachicug gotucagcunachru mandagcunawan chay yachrachipäcunganpita rimapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chaura Antioquiachru Jesusman yupachicug gotucagcuna nipäcungannuymi Pablowan Bernabëga aywapäcura. Chay aywar pasapäcura Fenicia ninganpam, jinaman Samaria ninganpam. Chay marcacunachrümi Jesusman yupachicugcunata willapacurcara, juc casta runacunas Jesusta chrasquicurcayanganta. Chayta mayar paycunaga aliscam cushicurcara. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chaura Pablowan Bernabé nä Jerusalenman chraräriptinga, chaychru Jesusman yupachicug gotucagcunam, Jesuspa cachran ruragcunam, jinaman Jesusman yupachicugcunachru mandagcunam chrasquirärin. Chaychrümi willapacurcara Dios ima-ayga alitas paycunawan rurayanganta. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jinaman willapacuratan Jesusman chay juc ishcay yupachicugcuna cay nipäcunganpitas: “Juc casta runacuna Jesusman yupachicugcunata nishun señalächicurcänanpag, jinaman nishun Moisés isquirbingannuy rurapäcunanpag” nipäcungantas. Chay nigcuna capäcura fariseo castapita Jesuspa runanman muyushacunam. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nipäcuptinmi Jesuspa cachran ruragcunaga gotucarärin Jesusman yupachicugcunachru mandagcunawan chay nipäcunganpita rimapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Chauraga chaychru goturarcayagcuna alisca tapunacurcayaptinmi, Pedroga shayuyur cay nin: “Jesusman yupachicug-mayïcuna, gamcunaga shumagmi musyarcayanqui mas naupalapita Dios ali willapata willapacunäpag nimanganta. Nätan chay willapacuptïmi juc casta runacuna Jesusta chrasquicurcara. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Chaura ima pinsianganchis musyag Diosga, paycunata chrasquiyanganta musyachira noganchimannuysi Santu Espiritunta paycunaman cachramunganpam. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nätan Diospa naupanchrüga Israel castas, juc castas chaynuylam canchi. Chaymi payman yupachicugcunata juchancunapitas perdonara. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Chaura ¿imanirtag gamcunaga munarcayanqui Diosninchi lutan rurananta? ¿Imanirtag awillunchicuna, jinaman noganchicuna mana ruray atipanganchita ‘Ruray’ nircayanqui Jesuspa chay juc casta discïpuluncunata? ");
INSERT INTO qvnNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nätan noganchiga shumagmi musyayanchi Munayniyog Jesús cuyapämarlanchi paycunatas noganchitas salvamanganchita”. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chaura chaychru goturarcayag runacunaga lapansi upälalam mayacurcara, Pablowan Bernabé willapapäcunganta. Nätan willapacurcaraga juc casta runacunachru ima-aygatas Diospa munayninwan runala mana ruray atipänanta rurapäcungantam. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Chaura willapayta nä usharäriptinmi, Santiagosi cay nin: “Jesusman yupachicug-mayïcuna, mayapäcamay: ");
INSERT INTO qvnNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedroga willaparamanchi juc casta runacunata galayunanpita-pacha runancunapag Dios acrangantam. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Cay willapämanganchiga ruracayan Diospa willacugnincuna isquirbingannuymi. Chay isquirbishachrüga cay niyanmi: ");
INSERT INTO qvnNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Chaypitaran cutimushag Davidpa castan aywagcunata yapay yanapänäpag. Cananga mana cäsucarcämanganpita juc wayi juchrushanuymi carcayan. Chauraga juchrusha wayita sharcachignuymi chay mana cäsucug runacunata muyuchishag cäsucugman. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chaynuy rurashag waquin runacunas Munayniyog Diosta ashipäcunanpagmi, jinaman chay juc casta runacuna Diosta alawapäcungancagchru waquin runacunas Munayniyog Diosta ashipäcunanpagmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Chaynuypam Munayniyog Diosga unaylapita nä musyachimasha canchi caycuna ruracänanpita’ niyanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Chaymi juc castacuna Diospa runanman muyushacunataga ama nichwanchu: ‘Moisés isquirbingannuyrag cawapäcuy’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Antis cartata apachishun mana juchäcurcänanpag cay nishata: ‘Chay diosnincunapag micuy garapäcungancunataga amam micapäcunquichu, nätan wanuypa wanusha uywapa aychantas amam micapäcunquichu, yawartas amam micapäcunquichu, jinaman warmin warminsi olgon olgonsi amam cawapäcunquichu’ nishata. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Chaycunapitaga unay unaypitam mayag marcacunachrüsi Israel castanchicunaga lapan jamana junagmi chay gotucarcänan wayicunachrüga Moisés isquirbingancunata leyircayan”. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Niptinmi Jesuspa cachran ruragcunawan, Jesusman yupachicugcunachru mandagcunaga, jinaman Jesusman yupachicug gotucagcunaga, paycuna castapita acrarärin ishcay alinnin runacunata, Pablowan Bernabëwan Antioquía marcata aywapäcunanpag. Paycuna capäcura Barsabás nipäcungan Judasmi, jinaman Silas jutiyog runam. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Chauraga paycunawanmi cartata rurarcurga apachipäcura cay nir isquirbishata: —“Antioquía marcachru, Siria ninganchru, jinaman Cilicia ningan lapan marcacunachru juc casta Jesusman yupachicug-mayïcuna: Cay Jerusalenpita Jesuspa cachran ruragcunam, Jesusman yupachicugcunachru mandagcunawan, cay cartata isquirbircayämü: ");
INSERT INTO qvnNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","¡Imanuylam carcayanqui! Nogacuna musyasham capäcü Jesusman yupachicug Israel castäcuna, gamcunacagman aywarcamur ‘Señalächicurcayrag’ nir pantacächiy munarcayäshungayta. Paycunataga manam cachrapäcamurächu ni ‘Yachrachipäcamuy’ nipäcuräpishchu. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chaymi cananga lapäcuna caychru rimanacurcur juc ishcay runacunata cachrarcayämü. Paycunaga aywarcayämun alisca cuyashäcuna Pablowan Bernabëwan parëjum. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paycunaga wanupäcunan captinsi mana imatas mancharilarmi servipäcun Munayniyog Jesucristota. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Chauraga Judastawan Silastam cachrarcayämü, paycunam cay cartapita maslata tantiachipäcushunqui. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nätan Santu Espiritusi ni nogacunas manam munapäcüchu cay nircayangagpita mastarag rurapäcunayta. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Caylata nircärishay: Chauragar ama micapäcuychu chay diosnincunata micuy garapäcungantas, ni yawartas, ni wanuypa wanug uywacunapa aychantas. Amatag warmin warminsi olgon olgonsi cawapäcuychu. Caycunata mana rurarga alim capäcunqui. Chauraga alila cawapäcuy”.— ");
INSERT INTO qvnNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chay nir isquirbisha cartata apacurcurmi Jerusalenchru cagcunata “Aywalä” nicurga, aywapäcura Antioquiata. Nä chrarurga Jesusman lapan yupachicugcunata gayarcachirmi cartata gorärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chaura chay carta leyigta mayarärirga aliscam cushicarärin chay cartachu ninganpita. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Chaylam Judaswan Silasga Diospa willacugnin capäcur, Jesusman yupachicugcunata rimapapäcura shumag tantiapäcunanpag. Chaura paycunaga calpanchasham quëdarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chay marcachru unaylaran capäcura. Chaypitam Jesusman yupachicugcunaga “Diosninchi yanapapäcushunqui” nircur cutirärichimura Jerusalenta chay cachrapäcamungan runacunaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Nätan Pablowan Bernabëmi ichaga Antioquiachru quëdarärirga, capäcura Munayniyog Jesuspita chaynuyla yachrarcayächir, jinaman ali willapata mas achca runacunawan willapacurcayar. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chaura nä ishcay quima junag pasaruptinmi Pabloga Bernabëta cay nin: “Acu, Munayniyog Jesuspita willapacunganchi marcacunapa cutishun, Jesusman yupachicugcunata ricamushun imanuy carcayangantas”. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Niptinmi Bernabëga “Juan Marcostas pushashun” nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Niptinmi Pabloga Juan Marcos aywananta mana munarga cay nin: “Payga Panfiliachru dëjamanganchinuysi lamitä camiñupitas cutiramunmanchri ali willapa willapacuyta dëjarcursi”. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Chay niptinmi jucninsi jucninsi mana tantiachinacurga raquicarärin. Chaura Bernabëga Marcoswanmi aywacurcan Chipre tishgota aywag büquiman jegarcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nätan Pabloga Silastam acrarura puripäcunanpag. Chaura Jesusman yupachicugcunaga “Munayniyog Diosninchi cachrarcayäshuptiquiga aywapäcuy” nircärirmi manacarärin Tayta Diosta paycunata yanapänanpag. Chauraga aywacurcara ");
INSERT INTO qvnNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siriapam, jinaman Ciliciapam, Jesusman yupachicug gotucagcunata yachrarcayächir. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Chaypita Derbe marcaman chrarurga aywacurcara Listra marcatam. Chaychrümi yachrara juc discípulu Timoteo jutiyog. Chay mözupa maman canag Jesusman yupachicugmi, jinaman Israel castam. Nätan taytanmi canag juc casta runa. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Chay Timoteopag Listrachru Iconiochru Jesusman yupachicugcuna rimapäcunag: “Payga ali mözum” nirmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Chaura Pabloga Timoteota pushayta munarga señalarachiram, chaychru yachrag Israel casta-mayincuna mana imatas rimarcayänanpag. Chaynuy rurara Timoteopa taytan juc casta runa canganta lapan musyapäcuptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nätan chay marcan marcan puripäcurga, Jerusalenchru Jesuspa cachran ruragcuna, jinaman Jesusman yupachicugcunachru mandagcuna rimanacurcangantam willapacurcag Jesusman yupachicugcuna chayta cäsucurcänanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chayta mayacur Jesusman yupachicug gotucagcunaga muyupäcura Jesusman alisca yupachicugmanmi. Jinamanmi waranpa, waranpa Jesusman yupachicurcag mas achca runacuna. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Chaypitam Pablowan chay ishcay aywagcunaga chrarärin Frigia ninganman. Chaypitam aywapäcura Galacia ninganman. Chaychrümi Santu Espirituga paycunata nirura Asia ninganchru Jesuspita mana rimapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Chaura nä Misia chimpanman chrarärirga aywayta munapäcura Bitinia ninganmanmi. Jinarcurmi Santu Espirituga “Ama aywapäcuychu” nirura. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Chauraga Misiaman mana yaycularmi uranpapäcura Troas marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Diosga chaychrümi pagaspa Pablota ricaparachin, Macedonia ninganpita juc runata. Payshi shacuyur “Aywalämuynar Macedonia ninganman yanapapäcamänaypag” nirun. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Chaura Pablota chaynuypa niruptinga, camachracuytam galacayärï Diosmi “Macedoniata aywapäcuy Jesuspita ali willapata willapacurcänaypag niyämanchi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Chaura Troas marcapitaga juc büquiman yaycurcurmi aywacurcarä Samotracia ningan tishgota. Chaypitam warantinga büquiwantag chrarärï Neápolis marcaman. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chay Neapolispitaga aywapäcurä Filipos marcatam. Chay Filipos marca cara Macedonia ninganchru mas alinnin marcam. Jinaman Romapita runacunam chaychru yachrapäcug. Chay marcachru capäcurä ishcay quima junagran. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Chauraga jamana junagchrümi, chay marcapita yargorga aywapäcurä mayu manyanta. Chay mayu manyanchrümi Israel castacunaga Diosta manacurcag. Chaura tacuyurmi chaychru gotucag warmicunata Jesuspita willapapäcurä. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Chay warmicunachrümi canag Tiatira marcapita Lidia jutiyog warmi. Payga canag alisca välig yana puca color tëlacuna ranticugmi, jinaman canag Diosta manchacug warmim. Pablo rimanganta mayacuyaptinmi Munayniyog Dios yanapaptin payga alisca shumag mayacura. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Chaura Lidiaga wayinchru cagcunawan bautizächicurcurga cay nirärimanmi: “Chaura Munayniyog Diosman razonpa yupachicug cayaptïga, acu aywashun wayïta gorpachacurcänaypag” nir, yapay yapay nipäcamaptinga wayinmanmi aywapäcurä gorpachacug. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Chaypitam juc junagchrüga Diosta manacug mayucagta aywarcayar, juc rantisha jipashwan tincurärï. Chay jipashga lutan espíritu yanapaptinmi musyapacur chranin golgueta gänanag chay rantignin runapag. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chauraga Pablotawan nogacunatam gatirayta galacayäriman cay nir gaparayar: “Cay runacunaga jana pachachru Munayniyog Diospa servignincunam. Paycunaga willaparcayäshunqui Jesuspita ali willapatam salvacurcänaypag”. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Chay niyar gatirapäcamara achca junagran. Chaynuyla nipäcamaptinmi Pabloga, mana masta awantayta atipar jipashcagman muyurcur lutan espirituta cay nin: “Jesucristo ningannuy noga nishay: ¡Yargoy cay jipashpita!”. Niruptinga chayüram lutan espirituga yargorura chay jipashpita. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Chaura chay jipashpa rantignin runacunaga paycunapag nä mana masta golgue gänananta tantiarärirga, charirärin Pablotawan Silastam. Jinarcurmi pläzaman aywachicurcan, chaychru marca mandagcunapa naupanman. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Chaypitam chay mandagcunapa naupanman nä chrarärichirga cay nirärin: “Cay Israel casta runacunam cay marcanchichru runanchicunata lutanta rurapäcunanpag sucsutarcayan. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Jinamanmi yachrarcayächin ‘Jucnuypa cawapäcuy’ nir. Noganchiga manam chaycuna ningantaga chrasquicuchwanchu ni rurachwanpishchu Roma nacionpita cayarga”. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Chay niräriptin runacunaga Pablopawan Silaspag contranmi sharcarärin. Jinarcurmi chay marca mandagcunaga, jacuncunata lachircapur vära gueruwan alisca wipyachipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Chaypitam nä alisca wipyarcachirga chaychru carcelman wichrgarärichira. Jinarcurmi chay cárcel ricag runata “Caycunata shumagmi ricanqui mana gueshpipäcunanpag” nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chaynuy niräriptinga Pablotawan Silastaga chay cárcel ricag runaga, mas ruyicagmanmi wichrgarun. Nätan chraquincunatam cëpuwan charirärichira. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Chaypitash chraupi pagasnuyga Pablowan Silasga Diosta manacurcur cantarcayara himnucunata. Chay jinapäcugtash chay carcelchru waquin wichrgaragcunaga mayacurcara. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chaylash mayänipita pacha cuyuyta alisca galacuyun, chay carcelpa cimintunsi aliscash cuyuricun. Jinarcurshi carcelpa puncuncunas lapalan quichracarun. Nätan cadenashacunapas lapanpash cadenancuna cachracarun. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Chaura chay cárcel ricag runa riccharamurga ricapurun lapan puncucuna quichracashatash. Jinarcurshi manchacarur espädanta jorgarcamurga nä tucsicunanpag cayara “Carcelchru cagcunaga lapanchri nä gueshpirun” nir pinsiar. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nätan Pabloga gayacurun: “Ama imatas ruracuychu. Lapämi caychru carcayä” nirshi. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Niruptinga cárcel ricag runaga achquita manarcurshi, cárcel ruyiman pachrpachryayla yaycurun. Chaypitash manchacaypita chucchucyayar gongorpacuyun Pablopa, jinaman Silaspa naupanman ");
INSERT INTO qvnNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jinarcurshi chay ruyipita jorgarcamurga cay nin: “Taytacuna, juchasapa runam cä. ¿Imatatag ruräman Tayta Dios salvamänanpag?” ");
INSERT INTO qvnNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Niptinshi Pablowan Silasga cay nirärin: “Munayniyog Jesusman yupachicuy. Chauraga salvasham canqui gamsi, jinaman wayiquichru lapan yachragcunas”. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Chauraga paytash, wayinchru lapan cagcunatawan rimapapäcura Munayniyog Jesuspita. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Chaura chay cárcel ricag runaga chayürash chraupi pagas cayaptinsi Pablopawan Silaspa däñashancunata maylarcur jampira. Nä jampiyta usharcularshi chay runaga bautizacurura lapan castancunawan. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jinarcurshi Pablotawan Silasta wayinman pusharcurga micuyta garacurun. Chay runaga alisca cushishash cara lapan aylluncunawan Tayta Diosman yupachicurcanganpita. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chaura pacha nä wararuptinga chay marca mandagcunaga chay cárcel ricagmanshi cachrarärin guardiancunata cay nig: “Ganyan carcelman wichrganganchi runacunata cachrariruy” nig. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Niruptin chay cárcel ricag runaga Pablotam cay nin: “Marca mandagcunam willarärichiman gamcunata cachraripäcunagpag. Chauragar yargorcur gasila aywacurcay”. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Niptinshi Pabloga chay guardiacunata cay nin: “¿Paycunaga juchayog u mana juchayog capäcungätas mana shumag musyalar, runa ricay astircärimarchu, jinaman carcelman wichrgarcärimarchu cananga pacaylapa cachrarircayäman? Nogacunaga Roma runam capäcü. Chauraga manash yargapäcushagchu, antis quiquincuna aywapäcamuchun jorgapäcamänanpag” nirärinshi. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Chaura guardiacunaga Pablo ningantash chay marca mandagcunata willarärin. Nätan Roma runa capäcunganta musyarärirga aliscash manchacarärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Chauraga carcelta aywarcamurshi Pablotawan Silasta cay nirärin: “¿Gamcunaga razonpachu carcayanqui Roma runacuna?” Nipäcuptinshi Pabloga “Au” nirun. Chaura chay marca mandagcunaga washata jorgarcamurshi yaparcur yaparcur “Mana musyarmi chay imatas rurasha capäcug. Amar imas cachunchu. Aywacurcaynar cay marcapita” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nä carcelpita yargorga aywapäcamura Lidiapa wayintam. Chaychrümi Jesusman yupachicugcunata “Amamar Jesuspitaga raquicapäcunquichu” nircurga aywacurcarä. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Chaura Filipos marcapita yargorga, Pablowan Silasga aywapäcura Anfípolis marcatam. Chaypita yargormi aywapäcura Apolonia marcata. Chaypitam aywapäcura Tesalónica marcata. Chaychrüga canag Israel castacuna gotucarcänan juc wayim. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Chauraga imaysi aywachrangannuymi Pabloga aywacun chay wayita, chay marcachru cara quima semänaran. Chaymi chaychrüga quima jamana junagrag paycunawan rimara. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rimaparaga isquirbishacunapitam cay nir: “Diospa cachran salvacug Jesusga cunchunanmi, jinaman wanunanmi cara. Chaypitam cawacämunan cara. Pay Jesuspitam nogaga willaparcayag. Paymi cayan Diospa cachran salvacugta shuyacuyanganchi” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Chaynuypa rimaruptin waquin Israel castacunaga “Razonpam chayga” nirmi Jesusman yupachicuyta galacayärira. Jinarcurmi Pablowan Silaswan shuntacapäcura. Paycunamanga shuntacapäcuratan Dios manchacug juc casta runacunas alisca achca, jinaman alipag ricasha warmicunas achcam. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nätan Jesusman mana yupachicuy munag Israel castacunaga chriquicurmi shuntarärin pläzacunalachru cacug guella, jinaman lutan runacunata. Chaycunawanmi achca runata shuntarcurga chay marcachru runacunata sucsutarärin. Jinarcurmi Pablotawan Silasta ashir, Jasonpa wayinman yaycarärin runacunapa naupanman jorgapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Chaura mana taricarcärirga Jasontawan waquin Jesusman yupachicugcunatam aywachicurcan calpanta camärir marcachru mandagcunapa naupanman cay nir gapararcayar: “Cay runacunaga mayag chayagchrüsi lapan runacunata pantacarcayächirmi purircayan. Jinarcurmi cananga cay marcamansi chrarärimun, chaynuy runacunatam Jasonga gorpachasha. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Chaycunaga lapanmi Romachru Munayniyog César ninganta mana cäsucurcanchu, ‘Jesusmi reyga’ nir”. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chay nigta mayarärirga goturarcayag runacunawan marca mandagcunaga alisca piñasham “Äyay äyar” rimacurcan. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Chaura Jasonpita, jinaman Jesusman yupachicugcunapita golgueta chrasquirärirga marca mandagcunaga cachrariräriram. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chaura Jesusman yupachicugcunaga chay pagaslam Pablotawan Silasta chay marcapita yargarärichira Berea marcata aywacurcänanpag. Nä Berea marcaman chrarärirga Israel castacuna gotucarcänan wayitam aywacurcan pasay-pacha. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Chay marcachru Israel castacunaga mas alicamam capäcunag, Tesalonicachru Israel castacunapitaga. Chay Bereachru Pablo Jesuspita yachrachiptin alisca shumagmi mayacurcara. Chaypitam Diospa isquirbishancunawan tincuchipäcura waran waran Pablo yachrachingan razoncag u casqui cangantas musyapäcunanpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Chaura chaychru Israel casta runacunaga Jesusman yupachicuyta galayarärira achcam. Chaynuytan yupachicuyta galayaräriratag juc casta runacunapitas alisca achca. Chaynuytan yupachicurcaratag alipag ricasha warmicunas olgocunas, alisca achca. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Chaura Tesalónica marcachru Israel castacunaga, Berea marcachru Jesuspita Pablo yachrayächinganta mayarärirga, aywarcamurmi Pablopa contran sharcapäcunanpag runacunata sucsutarärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Chauraga chayüram Jesusman yupachicugcunaga Pablota yargarärichin jatun gochra manyanman pushapäcunanpag. Nätan Silaswan Timoteoga quëdarärin Berea marcachrümi Jesusman yupachicugcunawan. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Chaura Pablotaga pushapäcura Atenas marcatam. Chaypitam chay pushag runacuna nä cuticunanpag cayaptin Pabloga cay nira: “Silaswan Timoteo cayman pasay-pacha aywapäcamuchun” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Chaura Atenas marcachrümi Silastawan Timoteota Pabloga shuyara. Chaychrümi imatas “Caymi diosnï” nir alawapäcugta ricarga alisca piñäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Chay shuyar Pabloga Israel castacuna gotucarcänan wayichrümi Israel castacunawan, jinaman Diosta manchacug runacunawan rimapäcura Jesuspita. Nätan chay marcapa pläzanman aywarcursi chaychru lapan gotucag runacunawanmi Jesuspita rimapäcura waran waran. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Chaura chaychrümi tincurärin juc ishcay alisca pinsiag runacunawan Epicúreos ninganwan, jinaman Estoicos ningancunawan. Chaycunawan rimaptinmi runacunaga cay nipäcug: “¿Imatatag cay runa yanga riman?” nir. Jinaman waquinmi “Cay runaga mana reguenganchi dioscunapitam willapacuyan” nipäcug. Chaynuy nipäcura Jesuspita ali willapata, jinaman wanurur cawacämuypita rimaptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chaura Pablotaga pusharärin Areópago jutiyog lömamanmi. Chaychru paycunaga gotucapäcug imas alisca väligpita rimapäcunanpagmi. Nä chrarärichirga cay nirärinmi: “Nogacunaga musyaytam munarcayä chay mushog yachrayächingaypita. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Gamga imaysi mana mayacurcangäpitam rimayanqui. Chaymi musyayta munarcayä” nirärinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Chay Atenaschru lapan yachragcunas, jinaman carupita shamusha chaychru yachrag runacunas munapäcug imas mushog yachrachiycunapita mayacuytam jinaman rimaytam. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Chaura Pabloga chay goturarcayagcunapa chraupinman shayuyurmi cay nirun: “Cay Atenas marcachru yachrag taytacuna, nogaga cay ima-ayga rurarcayangaytas ricar tantiayä diosniquicunata, alisca manchacug capäcungaytam. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Chaura diosniquicuna alawapäcungaycagpa pasarmi ricapurü juc altarchru ‘MANA REGUENGANCHI DIOSMI’ nir isquirbishata. Chaura chay mana regueyar alawarcayangay Diospitam nogaga rimaparcayag. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Paymi cay pachatas jinaman cay pachachru ima-aygacagtas camara. Paymi alisca munayniyog jana pachachrüsi cay pachachrüsi. Chaymi payga mana yachranchu runacuna rurapäcungan wayicunachrüga. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Chaura Dioslapam ima-aygas, chaymi runacuna paypag ima ruranantas mana munanchu, antis payga lapanchitam cawachimanchi, jinaman paymi walyaytas, lapan ima-aygatas gomanchi. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Payga juc castalapitam mirachimasha canchi tucuy castaman, cay pachachru mayag chayagchrüsi yachrananpag. Chaynuytan payga nirayan imaypita imaycama runa cawananpagsi, jinaman maypita maycama yachrapäcunanpagsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Chaynuy rurara runacuna payta ashipäcunanpagmi. Chaura ashirga tarishunmi. Payga manam caruchrüchu noganchipitaga. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Chauraga Diospitam cawayanchis cuyuyanchis cayanchis. Cay marca-mayiquicunapita juc ishcay runacuna ‘Diospa castan aywagmi canchi’ nipäcungannuysi. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Chaura Diospa castan cayarga amam pinsiachwanchu ‘Camacug Diosga cayan örupita, golguepita, guerupita, u rumipita rurasha dioscunanuymi’ nirga. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nätan Diosga unaypitas mana musyar juchäcurcanganta mana cuentalarmi, cananga ‘Lapan runacunata maychru chaychru yachragtas jucha rurarcayangaypita wanacurcur nogaman cuticarcämuy’ niyan. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Jinamansi Diosga nämi musyayan ima junagchru lapan runacunapa juchancunata taripänantas. Nätan juchancunata taripanga acrashan Jesuspam, nätan chay razoncag cangantaga musyayanchi Jesucristota wanushapita cawacächimunganpam” nira. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Chaura wanushapita cawacämuypita rimagta mayarärirga, waquin runacunaga asipäcurcanmi. Nätan waquincunam “Yapaychrüsi caypitaga mayacushunchri” nipäcura. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Chauraga chay goturarcayag runacunapita yargorcurmi, Pabloga aywacura. ");
INSERT INTO qvnNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nätan Jesusta juc ishcay chrasquicugcunaga Pablowanmi shuntacarärira. Paycuna capäcura Dionisio jutiyog runawan Dámaris jutiyog warmim, jinaman mas juc runacunam. Chay Dionisio cara Areopagochru yachrachig casta runam. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chaypitam Pabloga Atenaspita yargorcur Corinto marcata aywarura. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nä Corintoman chrarurga, tincurura Ponto ninganpita Israel castan Aquilawanmi. Payga chayran chrarayämura warmin Priscilawan Italiapita. Paycunaga Italiapita yargarärimura Romachru munayniyog Claudio “Cay Romapita lapan Israel castacuna yargapäcuchun” niptinmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Chaura Pabloga paycunawanmi yachrapäcura. Chaypita ishcayninsi toldu ruraytam yachrapäcura, chaymi tolducunata rurapäcug. (Chay toldu cara juc wayinuysi rurasham runa yachrananpag.) ");
INSERT INTO qvnNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Jinaman lapan jamana junagmi Pabloga aywachrag Israel castacuna gotucarcänan wayita. Chaychrümi Israel castacunatas, juc casta runacunatas tucuynaypa tantiachira Jesuspita. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nätan Silaswan Timoteo Macedoniapita nä chraräriptinmi ichaga, Pabloga Jesuspita rimapaylata galayurura. Chaymi ichaga Israel castacunata mas shumag tantiachira Jesús salvacug canganpita. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nätan paycunaga “Yangam chaytaga nircayämanqui” nirmi, piñasha galayarärin Pablo ashliyta. Chaura Pabloga jacuntam tapsirun cay nir: “Quiquiquicunapa juchaycunapitachr cananga Diospis cunchuchipäcushunqui. Nogaga nämi Jesuspita willapäcungagwan rurarü Dios nimanganta. Cananpitam ichaga aywacü juc casta runacunaman”. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nirmi yargorun. Jinarcurmi aywacun Diosta manchacug Ticio Justopa wayinta. Chay runa yachrara Israel castacuna gotucarcänan wayipitaga lädulanchrümi. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nätan Crispo jutiyog runaga lapan aylluntinmi Jesusman yupachicuyta galacayärira Israel castacuna gotucarcänan wayichru mandag cayarsi. Chaynuytan chay Corintochru yachragcunas mayacarärirga Jesusman yupachicuyta galacayärira, jinaman bautizächicarärira. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Chaypitam juc pagaschru Munayniyog Diosta, Pabloga ricapurun cay nir rimapayagta: “Ama manchacuychu ni upälalas caypishchu, antis chaynuyla rimapayay runacunata. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nogaga gamwanmi cayä. Manam pisi ima lutan rurashuyniquitasi atipäshunquichu. Achcaran runäcuna cayan cay marcachru nogaman yupachicarcämänanpag” nir. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Chaura Pabloga yachrara Corintochru juc wata sogta quillaran runacunata Diospa willapanta yachrayächir. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nätan chaypinga Galión jutiyog runa, Acayachrümi mandag cara. Jinarcurmi Israel castacunaga juc runanuyla gotucarcur Pablota charircur aywachicurcan chay Galionpa mandacunanman. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Jinarcurmi Galionpa naupanchru cay nicurcan: “Cay runacunaga Diosta servinanpag manam yachrachin Moisés isquirbingannuychu, antis jucnuypam” nirärin. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Chaura Pablo nä rimayta munayaptinmi Galionga Israel castacunata cay nirun: “Imatas juchäcusha captinga u runata wanuchisha captinga atendipäcugmanmi. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nätan imas yachrachiycunapitaga, juticunapitaga u Moisés isquirbingancunapitaga quiquiquicama tantiachinacamuy. Nogaga manam munächu chaycunapita fiyisniquicuna cayta”. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nirga washamanmi gargaramun. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Chauraga chaychru cayag runacunaga lapalanmi charicarärin Sóstenes jutiyog runata. Chaypitam magacurcan Galionpa naupanchru. Chay Sostenesga canag Israel castacuna gotucarcänan wayichru mandagmi. Nätan Galiontaga manam imas gocurachu chay Sostenesta magarcayaptinsi. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Chaypitas Corintochrüga Pablo yachrara unaylaran. Chaypitam ichaga, Jesusman yupachicugcunata “Aywalä” nircur, aywacura Priscilawan Aquilawan Cencreata, Siria ninganpa aywapäcunanpag. Cencreaman chrarur Pabloga agchantam rutuchicurura Diosta “Gampagmi caycunata rurashag” nirmi. Chaypitam ichaga büquiman jegarcur aywacurcara Siriata. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nä Efeso marcaman chrarärirga, Pablo dëjarura chaychrümi Priscilatawan Aquilataga. Chaura aywacura japalanmi Israel castacuna gotucarcänan wayita, chaychru gotucag Israel castacunawan rimananpag. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nätan paycunaga Pablota “Yachrashunragnar” nipäcuram. Nätan Pabloga manam munarachu, antis cay niram: ");
INSERT INTO qvnNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Jerusalentaran aywanä cayan cay nachrgayämug fiestachru canäpag. Chaypitachr cutimushag Dios munaptinga” nircurmi, aywacura Efesopita juc büquiman jegarcur. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Chaypitam nä Cesareaman chrarurga, Pablo pasara Jerusalenta Jesusman yupachicug gotucagcunata “Imanuylam carcayanqui” nicug. Nircurga chaylam aywacura Antioquiata. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chaypita nä Antioquiachru unayla cacurcurga, yapaytan aywaratag Galaciachru, Frigiachru lapan marcacunapa, lapan discïpulucunata “Chaynuyla yupachicurcayay Jesusmanga” niyar. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Chaypitam Efesoman chrarura Israel casta runa Alejandría marcapita Apolos jutiyog. Payga aliscam yachrara Diospa isquirbishacunata, jinaman yachrachig aygas mayacuylatam. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Payga Munayniyog Jesuspita walcalatam mayacusha cara. Nätan rimaparas runacunata alisca cushisham, jinaman yachrachiras lapan musyangantam Munayniyog Jesuspitaga. Chaycamaga musyara payga Bautizag Juan yacuwan runacunata bautizangalanpitam. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Chaypitam Apolosga Israel castacuna gotucarcänan wayichru Jesuspita yachrachiyta galayurun mana pitas manchacular. Chaypitam nä yachrachiyta usharuptinga, Priscilawan Aquilaga quiquilanta mas shumag tantiachipäcura Jesuspita. ");
INSERT INTO qvnNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Chauraga Apolos nä Acayaman aywayta munaptinga, Jesusman yupachicugcunaga yanapapäcura aywananp