﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvmNT_vpl;
CREATE TABLE qvmNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvmNT_vpl WRITE;
INSERT INTO qvmNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo rey David castapita yuregmi cargan. Davidnami cargan Abrahampa castanpita yureg. Tsaymi Abrahampita galaycur Jesucristupa unay castancuna caycuna cargan: ");
INSERT INTO qvmNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa tsurinmi cargan Isaac. Isaacpa tsurinmi cargan Jacob. Jacobpa tsurinmi cargan Judá y waquin wauguincunapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judäpa tsurincunami cargan Fareswan Zara. Paycunapa mamanmi cargan Tamar. Farespa tsurinmi cargan Esrom. Esrompa tsurinmi cargan Aram. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa tsurinmi cargan Aminadab. Aminadabpa tsurinmi cargan Naasón. Naasonpa tsurinmi cargan Salmón. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa tsurinmi cargan Booz. Boozpa mamanmi cargan Rahab. Boozpa tsurinmi cargan Obed. Obedpa mamanmi cargan Rut. Obedpa tsurinmi cargan Isaí. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaïpa tsurinmi cargan rey David. Rey Davidpa tsurinmi cargan Salomón. Salomón yurergan Uriaspa viüdanchömi. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa tsurinmi cargan Roboam. Roboampa tsurinmi cargan Abías. Abiaspa tsurinmi cargan Asa. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa tsurinmi cargan Josafat. Josafatpa tsurinmi cargan Joram. Jorampa tsurinmi cargan Uzías. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa tsurinmi cargan Jotam. Jotampa tsurinmi cargan Acaz. Acazpa tsurinmi cargan Ezequías. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa tsurinmi cargan Manasés. Manasespa tsurinmi cargan Amón. Amonpa tsurinmi cargan Josías. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa tsurinmi cargan Jeconías y waquin wauguincunapis. Jeconías cawanan witsanmi Israel runacunata Babilonia soldäducuna prësu tsarircur apargan Babilonia nacionman. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tsaychönami Jeconiaspa tsurin Salatiel yurergan. Salatielpa tsurinmi cargan Zorobabel. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa tsurinmi cargan Abiud. Abiudpa tsurinmi cargan Eliaquim. Eliaquimpa tsurinmi cargan Azor. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa tsurinmi cargan Sadoc. Sadocpa tsurinmi cargan Aquim. Aquimpa tsurinmi cargan Eliud. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa tsurinmi cargan Eleazar. Eleazarpa tsurinmi cargan Matán. Matanpa tsurinmi cargan Jacob. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa tsurinmi cargan Mariapa runan José. Mariapa wawanmi cargan Jesús. Paymi cargan Tayta Dios cachamushgan salvamagnintsi. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tsauraga Abraham cawashgan witsanpita hasta David yurishganyag chunca chuscu (14) generación cargan. Tsaynoglami David cawashgan witsanpita Israel runacunata Babiloniaman apashgan witsanyag chunca chuscu (14) generación cargan. Tsaynoglami Babiloniaman apashgan witsanpita hasta Jesucristo yurishganyag chunca chuscu (14) generación cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo caynogmi yurergan. Mariawan tänanpag José parlacushga caycarpis paywan manami punorganragtsu. Tsaynog caycaptinpis María gueshyag ricacorgan Santu Espiritupa munayninwanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gueshyag ricacuptinpis Josëga ali runa car manami munargantsu runacuna Mariata jamurpänanta. Tsaymi mana quejacuylapa cachariyta yarpargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cacharinanpag yarpachacuycaptinmi Tayta Diosnintsipa angilnin Josëta sueñuynincho caynog nergan: “Rey Davidpa castan José, Mariaga manami pï runawanpis punushgatsu gueshyag ricacunanpag, sinöga Santu Espiritupa munayninwanmi gueshyag ricacushga. Tsaynog caycaptenga mana rabiacuylapa warmiquipag Mariata shuntacuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Olgu wamratami María wachanga. Runacuna jutsa rurashgancunata perdonar salvananpag captinmi tsay wamrapa jutin canga Jesús.” Tsaynog nirmi Josëta sueñuynincho ángil parlapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jesús yurinanpagmi Tayta Diosnintsipa profëtan caynog nir escribergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Juc doncëlla jipashmi gueshyag ricacur olgu wamrata wachanga. Tsay wamrapagmi nipäconga ‘Emanuel’ cashganta.” (Emanuel ninanga caycan “Tayta Diosnintsi nogantsiwanmi caycan” ninanmi.) ");
INSERT INTO qvmNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tsaynog niptinmi José punuycashganpita riccharcamur Tayta Diosnintsipa angilnin nishgannogla Mariata shuntacorgan warminpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Itsanga Mariawan taycarpis paywan manami punorganragtsu hasta wawan yurinanyag. Wawan yuriptinnami jutinta José churapargan Jesús jutin cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Israel nacioncho Herodes rey caycaptinmi Judea provinciacho caycag Belén marcacho Jesús yurergan. Yuriycuptinmi inti jegamunan cag lädupita estrella estudiag runacuna Jerusalenman chayaycur caynog tapucorgan: ");
INSERT INTO qvmNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“¿Maychötag Israel runacunapa mandagnin rey cananpag yureg iti caycan? Inti jegamunan lädupa estrellan jegamogtami ricapäcushcä. Tsaymi payta adorag shapäcamushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey cananpag wamra yurishganta mayaycurmi rey Herodes pasaypa rabiar yarpachacorgan imanogpapis tsay wamrata wanutsinanpag. Tsaymi Jerusalencho tag runacuna pasaypa mantsacorgan caynog yarpashpan: “Cananga ¿imatarag ruranga Herodes?” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rey Herodisga mandag cüracunata y Moisés escribishganta yachatsegcunata gayaycatsir taporgan caynog nir: “¿Maychötag Tayta Dios cachamunanpag cag Cristo yurinanpag caycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tsaynog tapuptinmi paycuna nipäcorgan: “Judea provinciacho caycag Belén marcacho yurinanpagmi escribiraycan, tayta. Tsaycho yurinanpagmi Tayta Diosnintsipa profëtan escribergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belenchömi Israel runacunapa mandagnin rey yurengapag. Tsaychömi yurenga Judea provinciacho jatusag marcacunapita tacshala caserío captinpis.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsayta mayaycurmi Herodes pacaylapa gayatsergan estrella estudiagcunata. Paycuna chayaycuptinmi taporgan tsay estrellata imaypitana ricapäcushgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Imaypita-patsa ricashgantapis wilaptinmi Herodes caynog nergan: “Belenman aywaycur tsay wamrata ashipäcamuy. Tariycorga wilapäcamanqui nogapis adorag aywanäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tsaynog niptinmi estrella estudiag runacuna aywapäcorgan. Aywarcaycaptinna tsay ricashgan estrellapis paycunapa naupagninta aywargan hasta wamra caycashgan cag wayiman chayananyag. Chayaycuptinna tsay pushag estrella ichicuycorgan wayi direccionnin ciëlucho. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tsaycho ichicuycogta ricarmi estrella estudiagcuna pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tsaymi tsay wayiman yaycushpanna taripäcorgan Jesusta y maman Mariatapis. Jesusta ricaycurmi naupanman gongurpacuycushpan payta adorapäcorgan. Nircurnami apashgan öruta, inciensuta y mïrra nishgan perfümitapis regalaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cuticunanpag caycaptinnami paycunata Tayta Diosnintsi sueñuynincho revelargan Herodes cagman manana cutipäcunanpag. Tsaynog revelaptinmi juc lädu caminupana marcanman cuticärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Estrella estudiag runacuna marcanman cuticuptinnami Josëta sueñuynincho Tayta Diosnintsipa angilnin revelargan caynog nir: “Rey Herodismi ñïñu Jesusta wanutsinanpag ashitsenga. Mana wanutsinanpag mamantinta Jesusta Egipto nacionman gueshpitsiy. Tsaychöna tanqui cutimunayquipag wilanäyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tsaynog niptinmi Josëga riccharcamur jinan höra patsa manarag waraptin mamantinta Jesusta apacurcur Egiptupa aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tsaychömi paycuna targan hasta Herodes wanunanyag. Tsaynog cananpag captinmi Tayta Diosnintsi tantyatsergan wilacognin profëtata caynog nir escribinanpag: “Wamrä captinmi Egiptupita gayamushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Estrellata estudiag runacuna Jesús maycho cashgantapis wilag mana cutiycuptinmi rey Herodisga fiyupa rabiacorgan. Tsaymi Jesusta wanutsiyta munar soldäduncunata cachargan Belén marcacho y naupan estanciacunachöpis olgu wamracunata wanutsinanpag. Estrellata estudiag runacuna imaypita-patsa estrellata ricashganta wilapashga captinmi Herodes tantyacorgan Jesús juc o ishcay watayogna cashganta. Tsaymi wamracunata wanutsergan tsayrag yurishga caycagcunapita ishcay watayogyag. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tsaynog pasaptinmi Tayta Diosnintsipa unay profëtan Jeremías escribishgannog cumplergan. Paymi escribergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá nishgan marcachömi pï-maypis fiyupa laquicushpan wagarcaycan. Wawancuna wanuycuptinmi shogaptinpis mana chawaypa Raquel wagaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Egiptucho José caycaptinmi Herodes wanorgan. Tsaymi sueñuynincho Tayta Diosnintsipa angilnin Josëta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mamantinta Jesusta apacurcur Israelmanna cuticuy. Jesusta wanutsiyta munagcuna wanushganami caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ángil tsaynog niptinmi jinan höra Josëga Israelman cuticorgan mamantinta wamrata apacurcur. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cutiycarnami José musyargan Judea provinciacho rey Herodispa trucan tsurin Arquelao mandag caycashganta. Tsayta musyarmi José mantsacorgan Judeaman cutiyta. Tsaynog mantsacuptinmi sueñuynincho Tayta Diosnintsi nergan Judeaman aywananpa trucanga Galilea provinciamanna aywacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea provinciaman chayarnami Nazaret marcaman aywargan tsaycho tänanpag. Tsaycho tänanpag cashganpitami Tayta Diosnintsipa profëtancuna escribergan caynog nir: “Runacuna nenga Nazaret runa cashgantami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús wilacuyta manarag galaycuptinmi Juan Bautista Tayta Diosnintsipa wilacuyninta wilacuyta galaycorgan. Judea provinciacho caycag chunyagcunapa puriptinmi runacuna tsayman aywargan wilacushganta mayananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Chayaptinmi pay wilapargan caynog nir: “Tayta Diosnintsipa maquincho ali cawanapag cag tiempo chämushganami. Tsaynog captenga jutsa ruraycunata cacharir Tayta Diosnintsi munashgannogna cawapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan Bautista manarag yuriptinmi Tayta Diosnintsipa profëtan Isaías paypita escribergan caynog nir: “Chunyag jircachömi juc runa fuertipa wilaconga caynog nir: ‘Mandag runa shamuptin chasquicunayquipag caminuta pitsar camaricushgayquinog jutsa ruraycunata cacharir camaricäriy Tayta Diosnintsi shamuptin chasquicärinayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan Bautistapa röpan cargan camëllupa milwalanpita awashgami. Wachcunpis cargan camëllo garapita rurashgami. Chucluscunata y tinyaypa mishquinta micularmi pay purergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wilacur puriycashganta mayarmi Jerusalenpita y Judea provinciacho cag may-tsay marcacunapitapis atsca runacuna Juan cashgan cagman aywargan wilacushganta mayananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juan wilacushganta chasquicurmi tsay runacuna tantyacärergan jutsayog cashganta. Tsaymi Tayta Diosta perdonta manacuptin Jordán mayucho paycunata Juan bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tsayman atsca fariseo y saduceo runacuna bautizacunanpag shamogta ricarmi Juan Bautista caynog nergan: “¡Culebra casta runacuna! ¿Imanirtag gamcuna yarparcaycanqui jutsayog captiquipis Tayta Diosnintsi infiernuman mana gaycushunayquipag cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tayta Diosnintsi infiernuman mana gaycushunayquipäga jutsa ruraycunata cacharir pay munashgannogna cawapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama yarpapäcuytsu Abrahampa castan cashgalayquipita Tayta Diosnintsi salvashunayquipag cashganta. Tayta Dios munarga cay rumicunatapis Abrahampa castanman ticraratsinmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Mana ali wayog yöracunata sapipita muturir ninaman gaycushgantsinogmi Tayta Diosnintsega jutsa ruragcunata infiernuman gaycunanpag listuna caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nogaga yaculawanmi gamcunata bautizä jutsa rurayta cacharir Tayta Dios munashgannog cawapäcunayquipag. Tayta Diosnintsi cachamushgan Cristumi itsanga munayniyog caycan Santu Espirituwan y ninawanpis bautizashunayquipag. Nogaga manami paynog munayniyogtsu caycä. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Payga jurquëtan aptashgami caycan trïguta wayrananpag. Nircurmi trïgu cagta churanga wayinman. Y punshantana gayconga imaypis mana upeg ninaman tsaycho rupananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesuspis Galilea provinciapitami aywargan Jordán mayuman bautizacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsayman chayaptinmi paytaga Juan bautizayta mana munargantsu caynog nishpan: “Tayta Diosnintsi cachamushgan Cristo caycaptiquega ¿imanogpatag gamta bautizäman? Bautizanäpa trucanga nogatachari bautizaycalämanquimanga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsaynog niptinmi Jesús caynog nergan: “Imanog captinpis bautizaycalämay. Bautizamänayquitami Tayta Diosnintsi munan.” Tsaynog niptinmi Juan bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yacupita sharcurcurmi Jesús ricargan jana patsa quichacarcuptin Santu Espíritu palomanog payman uraycämogta. ");
INSERT INTO qvmNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tsaymi ciëlupita mayacämorgan Tayta Dios caynog nimushgan: “Payga cuyay tsurëmi. Noga munashgänog lapanta cumpliptinmi cushishga caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsaypitanami Jesusta Santu Espíritu pushargan chunyag jircaman Satanás jutsata ruratsiyta camananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tsaychömi chuscu chunca (40) junag y chuscu chunca pagas ayunashpan Tayta Diosta Jesús manacorgan. Tsaypitanami Jesusta wanuyparag micanay tsaricuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsaynog micanaycaptinmi Satanás yuripaycur caynog nergan: “Diospa tsurin caycarga micunayquipag cay rumicunata tantaman ticratsiy, ari.” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tsaynog niptin Jesús caynog nergan: “Tayta Diospa palabrancho caynogmi niycan: ‘Manami micuyta miculartsu runacuna cawan, sinöga Tayta Dios nishgancunata cäsucushpanpis cawanmi.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsaypitanami elagpita Jesusta Satanás ricacatsergan Jerusalén templo janancho. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tsaychönami payta caynog nergan: “Diospa tsurin carga caypita pampaman tuniy. Diospa palabranchöga caynogmi escribiraycan: ‘Angilnincunatami Tayta Dios cachamonga maycho captiquipis cuidashunayquipag. Paycunami tsarishunqui pampaman tuniptiqui ni chaquilayquitapis rumicunaman mana tacacunayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Niptinmi Jesús nergan: “Tayta Diospa palabranchöga caynogmi niycan: ‘Tayta Diosta ama obligaytsu quiquiqui munashgayquita ruratsinayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tsaypitanami altunnin jirca puntacho Jesusta Satanás elagpita ricacätsergan. Tsaypitanami ricatsergan may-tsay nacioncunata y tsay nacioncunacho cag riquëzacunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nircurmi nergan: “Gongurpaycur nogata adoramaptiquega cay ricashgayqui nacioncunata y tsaycho cag riquëzacunatami goycushayqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tsaynog niptinmi Jesús caynog nergan: “¡Witicuy, Satanás! Tayta Diospa palabranchöga caynogmi escribiraycan: ‘Tayta Dioslatami adoranqui y pay japalantami sirvinqui.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tsaynog niptinmi Satanás aywacorgan. Tsaypitami angilcunapis tsayman chayargan Jesusta yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista carcilcho wichgaraycaptinnami Galilea provinciacho caycag Nazaret marcaman Jesús cuticorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tsaypitanami Nazaret marcacho tänanpa trucanga Capernaum marcamanna aywargan tsaycho tänanpag. Tsay marcaga cargan Galilea lagüna cuchunchömi, Zabulonpa y Neftalïpa castan runacuna tashgan cagcho. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesús tsaycho tänanpag captinmi Tayta Diosnintsipa profëtan Isaías caynog escribergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Galilea lagünapa naupancunacho tag mana Israel runacuna, Jordán mayupa wac tsimpancho tag runacuna, y Zabulonpa y Neftalïpa castan runacunapis, lapayqui mayapäcamay. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tsacäpacushganog jutsa ruraycho cawag runacunami Tayta Diosnintsipa wilacuyninta mayapäcushga. Tayta Dios nishganta mana cäsucogcunapagmi inti atsicyashgannog Tayta Diosnintsipa wilacuynin chayashga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Isaías escribishgannog Capernaumcho tashpanmi Jesús wilacuyta galaycorgan caynog nir: “Tayta Diosnintsipa maquincho ali cawanapag cag tiempo chämushganami. Tsaynog captenga jutsa ruraycunata cacharir Tayta Diosnintsi munashgannogna cawapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tsaypita Galilea lagüna cuchunpa aywaycashganchömi Jesús ricargan ishcay runacuna redninta yacuman mashtarcaycagta. Paycunami cargan Simón y wauguin Andrés. Simonpa jucag jutinmi cargan Pedro. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Paycunatami Jesús caynog nergan: “Discïpulö canayquipag nogawan aywashun. Gamcunata yachatsishayqui pescäduta tsarinayquipa trucanga runacunatana Tayta Diosnintsipa wilacuyninta wilapänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsaynog niptinmi redninta cachariycushpan jucla Jesuswan aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsaypita más wac lädupa aywarcaycashganchönami ricargan Santiaguta y Juanta. Paycunaga taytan Zebedeuwanmi büquincho rednincunata altsarcaycargan. Paycunatapis discïpulun cananpagmi Jesús gayargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gayaptinmi paycunapis jucla Jesuswan aywapäcorgan taytanta büquicho cachaycur. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tsaypitanami marcan marcan intëru Galilea provinciapa Jesús purergan Tayta Diosnintsipa wilacuyninta sinagogacunacho yachatsishpan. Tsaynogpis tucuy-nirag gueshyawan gueshyagcunata aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria nación marcacunachöpis gueshyagcunata Jesús aliyätsishgan musyacargan. Tsaymi paycunapis Jesús cagman apapäcorgan tucuy-nirag gueshyawan gueshyagcunata, demonio nacatsishgan runacunata, wanuy gueshyawan nacagcunata y paralïticucunatapis. Tsay gueshyagcunata lapantami Jesús aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tsaytsica runacunami Jesusta gatirpargan Galilea marcacunapita, Decápolis marcacunapita, Jerusalenpita, Judea marcacunapita y Jordán mayu wac tsimpancunapitapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Tsaypita juc junagnami atsca runacunata ricar lömaman Jesús discïpuluncunawan witsargan tsaycho yachatsinanpag. Tsaycho jamaycurmi Jesús yachatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushishgami cawanga Tayta Dioslaman imaypis yäracur cawag runacunaga. Paycunatami Tayta Diosnintsi naupanman pushangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Cushishgami cawanga laquicogcunaga. Paycunatami Tayta Diosnintsi tantyatsenga mana laquicunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Cushishgami cawanga mana yachag-tucuypa runa mayinwan ali cawagcunaga. Paycunami mushog patsata Tayta Diosnintsipita herenciata chasquengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Cushishgami cawanga micanaypanograg y yacunaypanograg Tayta Diosnintsi munashgannog cawayta munagcunaga. Paycunatami Tayta Diosnintsi imaypis yanapangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Cushishgami cawanga runa mayinta cuyapagcunaga. Paycunatami Tayta Diosnintsi cuyapangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Cushishgami cawanga jutsata mana ruraypa Tayta Dios munashgannog cawagcunaga. Paycunami Tayta Diosnintsipa naupanman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Cushishgami cawanga runa mayinta amistatsegcunaga. Paycunatami Tayta Diosnintsi: ‘Wamrämi canqui’ nengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Cushishgami cawanga Tayta Diosnintsi munashgannog cawashganpita chiquishga cagcunaga. Paycunatami Tayta Diosnintsi naupanman pushangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nogata chasquicamashgayquipita runacuna ashlishuptiqui, chiquishuptiqui y imaycatapis jitapäshuptiqui ama laquicäriytsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsaynog nacashgayquipitami Tayta Diosnintsi premiuta gloriacho camaripäshunquipag. Gamcunatanogmi Tayta Diosnintsipa unay profëtancunatapis nacatsipäcorgan. Tsaynog caycaptenga imanog nacarpis cushicäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamcuna cay patsacho cachinogmi carcaycanqui. Cachi tsulur rumilan quëdaptin manami imapagpis välintsu. Tsay mana välegta jitariptin pï-maypis jarucunmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tsaynogpis atsquinogmi cay patsacho carcaycanqui. Tsaynog caycaptenga alayrinnincho marca cashgannog gamcunapis runacuna ricacushunayquipag shumag cawapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Manami pipis atsquita ratatsintsu cajun rurinman pacananpag, ni cawitu rurinman pacananpäga. Tsaypa trucanga alayrinninmanmi churan wayicho lapanta atsicyapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Runacuna tsacaypa ricananpag atsqui rataraycashgannog gamcunapis runacuna ricacushunayquipag Tayta Dios munashgannog cawapäcuy. Tsaynog cawashgayquita ricacurmi paycunapis tantyaconga Tayta Diosnintsi munashgannogna cawananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama yarpapäcuytsu Moisés escribishgan leycunata y profëtacuna escribishgancunata manacagman churanäpag shamushgäta. Tsaypa trucanga shamushcä tsay escribiraycashganta runacuna imanogpa cumplinanpag cashganta yachatsinäpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jana patsa y cay patsa manarag ushacaptinmi Moisés y Tayta Diospa waquin profëtancuna escribishgancunapis lapan cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tsaynog caycaptenga pipis tsay escribishgancunata mana cäsucur y waquin runatapis mana cäsucunanpag yachatserga Tayta Diospa naupancho manacagman churashgami canga. Tsay escribishgancunata cäsucur y waquin runatapis cäsucunanpag yachatsirmi itsanga Tayta Diospa naupancho aliman churashga canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tsaynog caycaptenga Tayta Diosnintsipa palabran nishgannog cawapäcuy. Fariseo runacunanog y Moisés escribishgan leycunata yachatseg runacunanog janan shongula cumpleg-tucorga gamcunapis manami Tayta Diosnintsipa naupanman imaypis chayanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gamcuna musyanquimi Moisés escribishgancho caynog nishganta: ‘Runa mayiquita ama wanutsinquitsu. Runa mayinta wanutseg cäga juzgashgami cangapag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tsaynog niptinpis noga caynogmi në: Manami runa mayinta wanutseg caglatatsu Tayta Diosnintsi juzganga, sinöga runa mayinta rabiapag cagtapis, runa mayinta ashleg cagtapis y runa mayinta manacagman churag cagtapis Tayta Diosnintsi juzgar infiernumanmi gaycongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Tsaynog caycaptenga Tayta Diosnintsipag ofrendata altarman aparpis runa mayiquiwan jagayätsinacushga cashgayquita yarpar ofrendayquita tsaycho cachaycur aywanqui jagayätsinacushgayquiwan amistanayquipag. Nircurrag ofrendata Tayta Diosnintsipag entreganqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tsaynogpis jaganta mana pägaptiqui quejashuptiquega autoridäman manarag chayar arreglapäcuy. Mana arreglaptiquega juezmanmi apatsishunquipag. Jueznami wardiacunawan carcilman wichgatsishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tsaypitaga manami yargunquipagtsu lapan jagan cashgayquita manarag pägarga. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gamcuna musyanquimi Moisés escribishgancho caynog nishganta: ‘Adulterio jutsata ama ruranquitsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tsaynog niptinpis noga caynogmi në: Yarpaynilayquichöpis juc warmita munaparga maynami adulterio jutsata ruragnog caycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Tsaynog captenga warmita ricar munaparga nawiquita jorgurir jitariycuy, derëcha cag nawiqui captinpis. Infiernuman gaycushga canayquipa trucanga más alimi canman wisculapis gloriaman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tsaynogla munapashgayqui warmita yataparga maquiquita cutsurir jitariycuy, derëcha cag maquiqui captinpis. Infiernuman gaycushga canayquipa trucanga más alimi canman juc maquiyoglapis gloriaman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gamcuna musyanquimi Moisés escribishgan leycunacho caynog nishganta: ‘Pipis warminwan raquicar imarga papilta firmapätsun raquicashgan musyacänanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tsaynog niptinpis noga caynogmi në: Pipis warminpita ama raquicätsuntsu. Mana jarucuycaptinpis raquicarga jutsayogmi caycan warmin juc runawan tar adulterio jutsata rurananpag. Tsaynoglami raquicashga warmiwan tag runapis adulterio jutsata ruraycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tsaynogpis gamcuna musyanquimi Moisés escribishgan leycunacho caynog nishganta: ‘Imatapis ruranayquipag jurashpayquega mana gongaylapa cumplinqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Tsaynog niptinpis noga caynogmi në: Imaypis ama juraytsu ‘Por Dios’ nirpis, ni ‘Por la tierra’ nirpis ni ‘Por ciëlo’ nirpis ni ‘Por Jerusalén’ nirpis. Cay patsaga Tayta Diosnintsipa chaquin jaruräcunanmi caycan. Ciëloga Tayta Diosnintsipa trönunmi caycan. Jerusalenga Tayta Dios acrashgan marcami caycan. Tsaymi ‘Por la tierra’ o ‘Por ciëlo’ o ‘Por Jerusalén’ nir jurashpayquega Tayta Diospa jutinta lutala jogaregnog caycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Waquincunanami: ‘Por mi cabëza’ nishpan jurapäcun. Ni tsaynogpis ama jurapäcuytsu. Tayta Diosnilantsimi munayniyog caycan agtsayquita yanaman y yoragman ticratsinanpagpis. Tsaymi ‘Por mi cabëza’ nir jurarpis Tayta Diospa jutinta lutala jogaregnog caycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Juranayquipa trucanga aunerga auninqui, mana aunerga ama auninquitsu. Jurayparag auniparga jutsatami ruraycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Musyanquimi Moisés escribishgan leycunacho caynog nishganta: ‘Nawinta jorguptenga quiquinpa nawintapis jorgutsun. Quirunta jorguptenga quiquinpa quiruntapis jorgutsun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tsaynog niptinpis noga caynogmi në: Chiquishuptiquipis ama nanaparaytsu. Lagyashuptiquipis jucag cärayquita camapanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pipis demandashushpayqui chompayquita guechushuptiquega punchuyquitapis apacunanpag cachaparinqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Guepinta pulan lëwayag apapänayquipag obligashuptiquega juc lëwayagpis apapanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Imatapis ‘Goycalämay’ nir manacushuptiquega goycunqui. Tsaynogla imatapis ‘Manaycalämay’ nir manacushuptiquega manaycunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tsaynogpis musyanquimi runacuna caynog nishganta: ‘Cuyanacushgayquiwanga cuyanacunqui. Chiquishogniquitaga chiquinqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tsaynog nipäcuptinpis noga caynogmi në: Chiquishogniquicunata cuyanqui. Contrayqui ali cawananpagpis Tayta Diosnintsita manacunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tayta Diosnintsega ali runacunapag y mana ali runacunapagpis intita jegatsimunmi. Tsaynoglami ali runacunapag y mana ali runacunapagpis tamyatsimun. Tayta Diosnintsi cuyapäcog cashgannog gamcunapis cuyapäcog carga paypa wamranmi carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cuyanacushgalayquiwan cuyanacorga ama yarpapäcuytsu ali runa cashgayquita. Impuesto cobrag runacunapis cuyanacushgalanwanga cuyanacärinmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Quiruyqui tincushgalanwan ali cawarga ama yarpapäcuytsu ali runa cashgayquita. Jutsasapa runacunapis tsaynoglaga cawapäcunmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tsaynog caycaptenga Tayta Diosnintsi cuyapäcog cashgannog gamcunapis cuyapäcog capäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Runa mayiquita yanaparga alabashga canalayquipäga ama yarpapäcuytsu. Tsaynog captiquega Tayta Diosnintsi manami ima premiutapis goshunquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Wactsacunata yanapashpayquega tsay yanapashgayquita ama sumätsiytsu waquin runacunanöga. Paycunaga pilatapis yanapaycorga pï-maypis musyapäcunanpagmi cornëtata tucashpan sinagogacunacho y cällicunachöpis wilacärin. Tsaynog cashganpitami runacuna alabashgalanna premiun canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wactsacunata yanapashpayquega ama pitapis wilapanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pitapis mana wilapaypa wactsacunata yanapaptiquega Tayta Diosnintsimi premiuta goshunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Runacuna ricanalanpagmi waquin runacunaga yachag-tucushpan may höra Tayta Diosta manacärin sinagogacunacho y cälli esquïnacunachöpis. Gamcunaga ama paycunanog capäcuytsu. Paycunapäga runacuna alabashgalannami premiun canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gamcunaga Tayta Diosta manacur pipis mana ricashunayquipag wayiquiman yaycuycur Tayta Diosta manacäriy. Tayta Diosla mayashunayquipag manacuptiquega paymi premiuta goshunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Waquin runacuna Tayta Diosta manacorga yaparir yaparir tsay palabralawanmi manacärin. Tsaynog manacärin tsaynogparag Tayta Diosnintsi mayananpag cashganta yarparmi. Gamcunaga ama tsaynog manacäriytsu. Manarag manacuptiquipis Tayta Diosnintsega imata nistaycashgayquitapis maynami musyaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gamcunaga Tayta Diosta caynog manacärinqui: Gloriacho caycag Tayta Dios, pï-maytapis tantyaycatsilay respitaycushunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lapan runacuna gam munashgayquinog cawayculätsun. Gloriacho munashgayquita rurapäcushgannog cay patsachöpis munashgayquita ruracayculätsun. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Micunäpag micuynë ama pishiyculätsuntsu, Tayta. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chiquimagnëcunata noga perdonashgänog jutsa rurashgäcunatapis perdonaycalämay. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jutsaman Satanás tunitsimayta munaptinpis tsapaycalämay, Tayta. Tsaynogpis yanapaycalämay jutsata mana ruraypa imaypis cawanäpag. Lapanpagpis munayniyog captiquimi gampa maquiquicho imaycapis caycan, Tayta. Tsaymi imayyagpis alabashga canquipag. Amén. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Runa mayiquita perdonaptiquega Tayta Diosnintsi gamcunatapis perdonashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Runa mayiquita mana perdonaptiquega Tayta Diosnintsi manami gamcunatapis jutsa rurashgayquita perdonashunquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tayta Diosta manacunayquipag ayunarga ama waquin runacunanöga capäcuytsu. Paycunaga ayunaycashganta runacuna tantyacunanpagmi jan-jampaycachaycan. Tsaynog ayunaycashganta ricar runacuna alabashgalannami premiun canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gamcuna ayunashpayquega pipis mana tantyananpag cärayquita shumag maylacur umayquitapis nagtsacurcur ayunapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tsaynog ruraptiquega runacuna manami musyangatsu ayunarcaycashgayquita. Ayunaycashgayquita runacuna mana musyaptinpis Tayta Diosnintsi musyanmi. Tsaymi paypita premiuta chasquinquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Rïcu canalayquipäga ama yarpachacäriytsu. Cay patsachöga riquëzayquita puyupis ushanmi, ismurpis ushacanmi y runapis suwanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cay patsacho rïcu canalayquipag yarpachacärinayquipa trucanga yarpachacäriy wactsacunata yanapanayquipag. Tsaynog cawarga gloriacho riquëzayquita churacognogmi carcaycanqui. Gloriachöga manami puyupis ushangatsu, ni ismongatsu ni runapis suwangatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Rïcu canalayquipag yarpachacorga manami Tayta Dios munashgannog cawanayquipag yarpachacuycanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Cay nishgäcunata tantyacur cäsucushpayquega Tayta Dios munashgannogmi cawaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mana cäsucorga manami Tayta Dios munashgannogtsu cawaycanqui. Tsaynog carmi jutsata ruraycashgayquitapis mana tantyanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Manami pipis ishcay patronta sirvinmantsu. Ishcay patronyog carga jucninta cäsucur jucnintaga manami cäsucongatsu. Jucninta cuyar jucnintaga manami cuyangatsu. Tsaynoglami rïcu canalanpag yarpachacogcunaga: ‘Tayta Diospa maquinchömi caycä’ niycarpis pay munashgannog cawayta mana camäpacuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tsaynog caycaptenga ama yarpachacäriytsu: ‘¿Imatarag micushag? ¿Imatarag upushag? ¿Imatarag jaticushag?’ nishpayqui. Micuynintsi captinpis y röpantsi captinpis manami tsaylachötsu ali cawayta tarintsi. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Shumag tantyacäriy pishgucuna imanog cawashgantapis. Paycunaga manami murucuntsu, ni cosechantsu ni pirwacuntsu. Tsaynog captinpis Tayta Diosnintsimi micuyta camaripan. Tayta Diosnintsipäga tsay pishgucunapitapis gamcuna masmi välipäcunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Mayjina yarpachacurpis ¿pirag winarcunman tamäñunpita juc cuchus maslatapis? ");
INSERT INTO qvmNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tsaynog caycaptenga ¿imanirtag gamcuna yarpachacunqui ali röpayog canalayquipäga? Tantyacäriy waytacuna imanog cuyaylapag tuctushgantapis. Waytacunaga mana aruycarpis mana putscacuycarpis cuyaylapagmi ricacun. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tsay waytacuna cuyaylapag cashgannöga manami unay rey Salomón jaticushgan röpancunapis cuyaylapag cashgatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tsaquiptin rupatsishga cananpag captinpis Tayta Diosnintsega alimi guewacunata winatsin. Yäracuyniynag runacuna, waytacunatapis cuyaylapagta tuctuycätserga ¿manatsurag gamcunatapis Tayta Diosnintsi yanapashunqui röpayquita tarinayquipag? ");
INSERT INTO qvmNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Tsaynog caycaptenga ama laquicäriytsu: ‘¿Imatarag micushag? ¿Imatarag upushag? ¿Imatarag jaticushag?’ nishpayqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tsaynöga laquicärin Tayta Diosman mana yäracog runacunalami. Gamcunaga ama paycunanog laquicäriytsu. Imata nistashgayquitapis Tayta Diosnintsega musyaycanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nistashgayquicunapag yarpachacunayquipa trucanga Tayta Diosnintsi munashgannog cawanayquipag imaypis yarpachacäriy. Pay munashgannog cawaptiquega imata nistashgayquitapis camaripäshunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsaynog caycaptenga ama laquicäriytsu wara junagpäga. Tayta Dios canan junag yanapashushgayquinoglami wara junagpis yanapashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tayta Dios mana juzgashunayquipag runa mayiquita ama jamurpaytsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Runa mayiquita jamurpar wasanta rimashgayquipitami Tayta Diosnintsi gamcunatapis juzgashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Quiquiquipa nawiquicho jatuncaray ganra jatiraycaptenga ¿imanirtag runa mayiquipa nawincho ichicnayla ganra caycagta ricapanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nawiquicho jatuncaray ganra caycaptenga ¿imanogparag runa mayiquita: ‘Nawiquicho ichicnayla ganra caycagta jorgapäshayqui’ ninquiman? ");
INSERT INTO qvmNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ishcay cära runacuna! Puntataga jorguy nawiquicho ganra caycagtarag. Tsayragmi ricanquipag runa mayiquipa nawincho ichicnayla ganra caycagta jorgupänayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tayta Diosnintsipa wilacuyninta wilapaptiqui mana chasquishuptiquega ama wilapaytsu mastaga. Chasquicuyta mana munaycagta wilapaptiquega öru sortëjata cuchi jarucunalanpag jitapaycognogmi carcaycanqui. Tsaynoglami wilapar exigiptiquega rabiacongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Imaypis Tayta Diosta manacäriy. Imata nistarpis ruwacäriy. Puncuta tacacognogpis payta gayacäriy. Tayta Diosta manacogcunaga manacushganta chasquinmi. Imata nistarpis ruwacogcunaga tarinmi. Puncuta tacacognog gayacogtaga Tayta Dios mayanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Maygayquitapis wamrayqui tantata manacushuptiquega ¿rumita garanquimantsurag? ");
INSERT INTO qvmNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tsaynogla pescäduta manacushuptiquipis ¿culebrata garanquimantsurag? ");
INSERT INTO qvmNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mayjina fiyu carpis ¿manacu wamrayquicunata ali caglata garanqui? Tsaynoglami Tayta Diosnintsita manacäriptiquega ali cagcunata camaripäshunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Runa mayiqui ali ricashunayquita munarga gamcunapis paycunata ali ricapäcuy. Tsaynog ali ricanacur cawanantsipagmi Moisés escribishgancho y profëtacuna escribishganchöpis niycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Infiernuman aywag puncupis caminupis anchumi caycan. Atscagmi tsay puncupa yaycurcaycan. Gloriaman aywanapag cagmi itsanga puncupis caminupis llanula caycan. Walcaglami tsay puncupa yaycurcaycan. Tsaynog caycaptenga imanogpapis quichqui puncupa gloriaman yaycapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ ‘Tayta Diospa wilacogninmi cä’ nir shamog lutan yachatsicogcunata ama chasquipaytsu. Paycunaga Tayta Diosman yäracog-tucurpis atognog fiyumi carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lutan yachatsicog cashganta musyapäcunqui imanog cawashganta ricarmi. Manami imaypis cashacunapita üvata palantsitsu. Ni hïgustapis manami wallancapita cosechantsitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Trïgupis manami wayuntsu cebadillutaga. Tsaynoglami cebadillupis mana wayuntsu trïgutaga. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Trïguta cebadillu mana wayushgannogmi lutan yachatsicogcunapis Dios munashgannog mana cawantsu, sinöga mana alicunata rurar cawapäcun. Tsaynog cawaptinmi musyapäcunqui lutan yachatsicog cashganta. Chacracho cebadillu captenga sapipita luquirir rupatsishgannogmi paycunapis infiernuman gaycushga cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manami jutëta jogarishgalanpitatsu pipis Tayta Diospa naupanman chayanga. Tsaymanga chayanga pay munashgannog cawagcunalami. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juicio final junäga atscagmi nimanga: ‘Gampa wilacuyniquitami wilacur purergä, Tayta. Tsaynogpis gamman yäracurmi demoniucunatapis gargorgä. Tsaynoglami gamman yäracur milagrucunatapis rurargä.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tsaynog nimaptinpis nogaga caynogmi nishag: ‘Gamcunataga manami reguëtsu. ¿Pirag cacunquipis? ¡Naupäpita witicäriy, jutsasapa runacuna!’ ");
INSERT INTO qvmNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nishgäcunata cäsucamag runaga caycan cimientuta shumag ruraycur sharcatsishga wayinogmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fiyupa tamyar yacu shamuptinpis y shucucuy wayra shamuptinpis ali cimintushga wayega manami juchongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nishgäcunata mayaycar mana cäsucamag cagmi itsanga caycan aguysha janancho sharcatsishga wayinog. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aguysha janancho sharcatsishga captinmi tamya yacu shamuptin y wayra fiyupa wayraptin tsay wayi juchongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús tsaynog yachatsiptinmi runacuna pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Payga manami Moisés escribishgan leycunata yachatsegnogtsu yachatsergan, sinöga paycunapita más alimi yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lömacho yachatsishganpita Jesús urämuptinmi tsaytsica runacuna payta gatirargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tsauraga leprawan gueshyaycag runami Jesuspa naupanman gongurpacuycur caynog nir ruwacorgan: “Sänu canäpag aliyaycatsilämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsaynog ruwacuptinmi Jesús yataycur caynog nergan: “Cananpitaga aliyashganami canqui.” Tsaynog niptinmi jinan höra leprawan gueshyaycashganpita aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nircurmi Jesús caynog nergan: “Ama pitapis wilanquitsu noga aliyätsishgäta. Tsaypa trucanga Moisés escribishgancho nishgannogpis templuman ayway aliyashgana cashgayquita cüra ricashunayquipag. Nircurna Moisés escribishgancho nishgannogla aliyashgayquipita lapantapis ruranqui. Aliyashgana cashgayquita cüra nishuptiquimi lapanpis musyanga rasunpa aliyashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tsaypita Capernaum marcaman Jesús chayaptinmi Roma soldäducunapa capitannin Jesusman aywaycur ruwacorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ashmaynëmi pasaypa antsa wayëcho jitaraycan, tayta. Mananami sharcunanpag valorninpis cannatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tsaynog niptinmi Jesús nergan: “Aywashun aliyätsinäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsaynog niptinmi capitán caynog nergan: “Israel runacunawan mana Israel runacuna mana chayanacuycaptenga ¿imanogparagchi wayëmanpis chayanquiman, tayta? Tsaymi ruwacö ashmaynëta caylapita aliyaycatsinayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nogapis mandamagnëpa munayninchömi caycä. Tsaynoglami munaynëcho soldädöcunapis caycan. Maygantapis: ‘Ayway’ niptëga aywanmi. ‘Shamuy’ niptëga shamunmi. Imatapis rurananpag niptëga ashmaynëpis ruranmi. Gamga nogapita más munayniyogmi canqui. Tsaymi yäracö nishgayqui lapanpis ruracänanpag cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitán tsaynog yäracuptinmi Jesús cushicorgan. Tsaymi paywan aywag runacunata caynog nergan: “Paynog ali yäracamag runataga manami ni Israel runacunachöpis tarishcätsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","May-tsay nacionpita shamog runacunaga atscagmi gloriaman chayanga Tayta Diosnintsi camarishgan micuyta Abrahamwan, Isaacwan y Jacobwanpis cushishgala micunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waquin runacunami itsanga Tayta Diosnintsipa wilacuyninta yacharpis nogata mana chasquicamashganpita gloriaman mana chayangatsu. Tsaypa trucanga pasaypa tsacaymanmi gaycushga cangapag. Tsaychömi fiyupa wagar quiruntapis uchupäcongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nircurnami capitanta Jesús nergan: “Wayiquipa cuticuy. Yäracamashgayquipitami ashmayniqui aliyashgana caycan.” Tsay nishgan hörami capitanpa ashmaynin aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsaypita Pedrupa wayinman Jesús aywar tarergan Pedrupa suedran pasaypa antsa fiebriwan jitaraycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsaymi gueshyagpa maquinta Jesús yataycuptin jinan höra aliyargan. Aliyarcurnami micuyta paycunata garargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Patsa tsacaycaptinnami Jesusman apapäcamorgan demoniucuna nacatsishgan atsca runacunata. Tsay runacunapitami demoniucunata Jesús juc shimila gargorgan. Tsaynoglami tucuy gueshyawan gueshyagcunatapis aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tsaynog aliyätsinanpag captinmi profëta Isaías caynog escribergan: “Paymi gueshyantsita apashga. Fiyupa nacanantsipag cagtapis paymi nacashga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Atsca runacuna juntapaycuptinmi discïpuluncunata Jesús caynog nergan: “Büquiwan wac tsimpaman pasashun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Büquiwan pasananpag caycaptinmi Moisés escribishgan leycunata yachatseg runa Jesusta caynog nergan: “Maypa aywaptiquipis gatiräshayquimi, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tsaynog niptinmi Jesús caynog nergan: “Atogcunapaga machaynin canmi. Tsaynogmi pishgucunapapis gueshwancuna can. Nogapagmi itsanga mana cantsu maycho punuycunaläpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsaypitanami juc discïpulun caynog nergan: “Papänë wanuptin pampaycurragmi gamwan aywashag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tsauraga Jesús caynog nergan: “Wanushcunaga wanush mayinta pampapäcutsun. Gamwanga aywashun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsaynog nircushpanmi büquiman discïpuluncunawan Jesús witsargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lagünata tsimparcaycaptinmi Jesús punucäcorgan. Tsayyagmi fiyupa wayrawan yacu pulchagyar büquita talpucätsinanpagna caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsaymi discïpuluncuna Jesusta ricchatsergan caynog nir: “¡Talpucaycantsinami! ¡Salvaycalämay, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tsaynog niptinmi Jesús caynog nergan: “¿Imanirtag gamcuna tsayjinanpa mantsacashga carcaycanqui? ¿Manacu nogaman yäracamanqui?” Nircurmi sharcurcur wayratapis yacutapis chawänanpag Jesús olgöpargan. Tsaynog olgöpaptinmi wayrapis yacupis chawarganna. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tsayta ricarmi discïpuluncunaga quiquinpura mantsacashga caynog nipäcorgan: “Yacupis wayrapis tsaynog cäsunanpäga ¡imajinanparag munayniyog payga caycan!” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lagünapa tsimparmi discïpuluncunawan Jesús chayapäcorgan Gadara marca washa lädunman. Tsaychömi panteonpita demoniucuna löcuyätsishgan ishcay runacuna yargamorgan. Paycuna pasaypa mantsacuypag captinmi pipis mana pasagtsu tsay panteón puncupaga. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesusta ricärishpanmi fiyupa gaparashpan caynog nipäcorgan: “¡Diospa tsurin Jesús! Infiernuman gaycamänayquipag höra manarag chämuptin ¡cay runapita ama gargaycalämaytsu!” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paycuna caycashganpita más washa lädunchömi atsca cuchicuna micurcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsaymi demoniucuna ruwacorgan Jesusta caynog nir: “Cay runacunapita gargamarga tagay cuchicunaman yaycunäpag cachapaycalämay.” ");
INSERT INTO qvmNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tsaynog manacuptinmi Jesús aunergan manacushganta. Tsauraga demoniucuna ishcan runacunapita yargurir yaycapäcorgan tsay cuchicunaman. Tsaymi cuchicunaga löcutashpan tunapa cörrir lagünaman jegacurporgan. Tsaychömi shengaypa wanupäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tsayta ricaycurmi cuchi mitsegcunaga mantsacashga cörrila aywargan marcaman runacunata wilananpag. Chayaycurmi wilacärergan löcuyashga runacunapita demoniucunata Jesús gargushganta y cuchicuna lagünaman jegar shengaypa wanushgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wilapäcuptinmi marcapita runacuna aywapäcorgan Jesús caycashgan cagman ima pasaycashgantapis ricananpag. Chayaycurmi pasaypa mantsacashga lapanpis Jesusta nipäcorgan tsaypita aywacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsaypitanami büquiman witsarcur Jesusga cutergan taycashgan marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsaychömi paralítico runata quirmawan apapäcorgan Jesús cagman. Apagcuna payman yäracärishganta musyarmi tsay gueshyagta Jesús caynog nergan: “Ama laquicuytsu, hïjo. Lapan jutsayquipita perdonashganami caycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsaynog niptinmi Moisés escribishganta yachatseg runacuna yarpachacorgan caynog nir: “¡Tsaynog nerga Diospa contranmi rimaycan!” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tsaynog yarparcaycashganta musyarmi Jesús caynog taporgan: “¿Imanirtag gamcuna tsaynog lutanta yarparcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Maygantag más sasa caycan? ¿Runapa jutsancunata perdonaycu? ¿O gueshyaycashganta aliyätsiycu? ");
INSERT INTO qvmNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nogami munayniyog caycä runapa jutsancunata perdonanäpag. Tsayta musyapäcunayquipagmi cay runata aliyätsishag.” Nircur tsay gueshyaycag runata caynog nergan: “¡Sharcuy! Quirmayquita apacurcur wayiquipa aywacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsaynog niptinmi tsay gueshyaycag runa jinan höra aliyarcur wayinpa aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tsayta ricaycurmi runacuna cushicushpan Tayta Diosta alabargan caynog nir: “¡Manami imaypis musyashcantsitsu runacunata Tayta Diosnintsi tsaynog yanapananpag cashgantaga!” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsaypita aywacur Jesús ricargan Mateo jutiyog runata impuestuta cobrar jamaraycagta. Tsaymi payta caynog nergan: “Discïpulö canayquipag nogawan aywashun.” Tsaynog niptinmi Jesuswan Mateo aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsaypitanami Jesusta y discïpuluncunata Mateo gayatsergan wayincho micapäcunanpag. Tsaycho micuycaptinmi impuesto cobrag runacuna y Diosta mana cäsucog runacunapis chayaycur micapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tsayta ricarmi fariseo runacuna jamurpashpan Jesuspa discïpuluncunata caynog nergan: “¿Imanirtag impuesto cobragcunawan y Diosta mana cäsucogcunawanpis talucaycur Jesús micuycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tsaynog nishganta mayarmi Jesús caynog nergan: “Gueshyagcuna jampicogta nistashgannoglami jutsasapacunapis Tayta Diosnintsipa wilacuyninta pilapis tantyatsinanta nistapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tayta Diosnintsipa palabranchöpis caynogmi niycan: ‘Nogapag uywacunata altarcho rupatsishgayquipitapis runa mayiquita más cuyapänayquitami munä.’ Tsaynog escribiraycaptinpis gamcunaga ¿imanirtag jutsasapacunata mana cuyapanquitsu? Nogaga manami Tayta Diosnintsi munashgannog cawag runacunalata Diospa wilacuyninta wilapänäpagtsu shamushcä, sinöga pay munashgannog mana cawag runacunatapis wilapänäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juc cutichömi Juan Bautistapa discïpuluncuna Jesusta taporgan caynog nir: “Nogacunapis y fariseo runacunapis cadalami ayunapäcö. Gampa discïpuluyquicunaga ¿imanirtag mana ayunapäcuntsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tsaynog tapuptinmi Jesús caynog nergan: “Casaray fiestaman gayatsishgan cagcuna ¿ayunanmantsurag? Casarag mözu wanuptinmi itsanga ayunapäcongapag. Tsaynoglami discïpulöcunapis paycunawan cashgäyäga mana ayunanmantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Manami pipis macwa röpata shilpantsu mushog träpuwanga. Mushog träpoga guentir masmi rachicätsenga macwa röpata. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tsaynogpis tsayrag rurashga aswata manami winantsitsu shilicaycag urpumanga. Shilicaycag urpuman winaptintsega aswa pogur tsay urputa latsquiriycongami. Tsauraga aswapis jichangami y urpupis paquir ushacangami. Tsaymi sänu urpuman tsayrag rurashga aswata winantsi. Tsaynoglami nogapa yachatsicuynëpis mushog car gamcunapa costumbriquicunamanga mana tincuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsaynog parlaycaptinmi sinagogacho mandag runa chayaycushpan Jesuspa naupanman gongurpacuycushpan caynog nergan: “Warmi tsurëmi pasacurishga, tayta. Jucla aywayculäshun cawaritsimunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsaynog ruwacuptinmi discïpuluncunawan Jesús aywargan tsay runapa wayinman. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aywarcaycaptinmi chunca ishcay (12) wata yawar apaywan gueshyaycag warmi guepalanpa yaycuycur paypa röpanta yataycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tsaynog rurargan: “Jesuspa röpanta yataycularpis aliyäshagmi” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yataycuptinmi ticraycur Jesús ricargan warmita. Tsauraga nergan: “Ama laquicuytsu, hïja. Yäracuyniquipami aliyashgana caycanqui.” Tsaynog niptinmi jinan höra tsay warmi aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tsaypitanami tsay Israel runacunapa autoridäninpa wayinman chayargan. Chayarmi taripäcorgan músico tucagcuna tsaycho caycagta y runacunapis fiyupa wagarcaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Paycunatami Jesús nergan: “Wagtapa yargucäriy. Autoridäpa tsurin manami wanushgatsu caycan, sinöga punuycanlami.” Tsaynog niptinmi wanushga caycashganta musyashpan tsaycho caycag runacuna Jesús nishganta mana criyergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tsaynog captinpis Jesús nishgannoglami wagtapa yargucärergan. Yargurcuptinnami wanushga caycag tsutaraycashgan cagman Jesús yaycorgan. Maquinpita aptarcuptinmi autoridäpa tsurenga cawarircamur sharcamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tsaynog cawaritsimushgantami tsay marcacho y waquin marcacunachöpis runacuna musyapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsaypita Jesús aywacuptinmi ishcay gapracuna guepanpa aywargan caynog nir: “¡Rey Davidpa castan Jesús, nogacunata cuyapaycalämay!” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Posädacushgan wayiman Jesús yaycuptinpis tsay gapracunaga paypa guepantami yaycorgan. Tsaymi Jesús paycunata taporgan caynog nir: “¿Gamcuna criyipäcunquicu nawiquita aliyätsinäpag cashganta?” “Au, criyëmi aliyätsimänayquipag cashganta, tayta” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsauraga nawincunata Jesús yataycur caynog nergan: “Yäracamashgayquipitami nawiqui aliyashgana caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsaynog niptinmi jucla nawin aliyargan. Tsauraga paycunata Jesús caynog nergan: “Pitapis ama wilapanquitsu aliyätsishgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tsaynog niptinpis yargurilarmi pï-maytapis wilapargan Jesús aliyätsishganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tsay gapracuna aywacurcaycaptinnami Jesús cagman pushargan shimin mana pashtag runata. Tsay runataga demoniumi shiminta watacätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tsay runapita demoniuta Jesús garguptinmi shimin pashtarganna. Tsayta ricarmi runacuna cushicushpan caynog nipäcorgan: “¡Manami imaypis ricashgantsitsu caynog aliyätsegtaga!” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo runacunami itsanga caynog nipäcorgan: “Manami Tayta Diospa munayninwantsu demoniucunata runacunapita gargun, sinöga demoniucunapa mandagninpa munayninwanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tsaypitanami lapan marcacunapa Jesús purergan Tayta Diosnintsipa wilacuyninta sinagogacunacho yachatsishpan. Tsaynogpis tucuy-nirag gueshyawan gueshyagcunatami aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Marcan marcan purir yachatsiptinmi tsaytsica runacuna juntacargan payta mayananpag. Mitsegniynag y ogracashga uyshacunanog caycagta ricarmi Jesús cuyapashpan laquicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsaymi discïpuluncunata caynog nergan: “Cosëcha poguraycagnogmi tsaytsica runacuna caycan Tayta Diosnintsipa wilacuyninta jucla chasquicunanpag. Tsaynog captinpis walcaglami ali wilacuyta wilacogcunaga carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsaymi Tayta Diosta manacäriy wilacogcuna más atsca cananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tsaypitanami chunca ishcay (12) apostolnincunata Jesús nergan paypa jutincho runacunapita demoniucunata gargunanpag y tucuy-nirag gueshyagcunata aliyätsinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tsay apostolcuna cargan Simón (paypa jucag jutinmi cargan Pedro), Simonpa wauguin Andrés, Zebedeupa tsurincuna Santiago y Juan, ");
INSERT INTO qvmNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo (payga Roma nacionpag impuestuta cobragmi cargan), Alfeupa tsurin Santiago, Tadeo paypa jucag jutin cargan Lebeo, ");
INSERT INTO qvmNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Celote” nishgan Simón y Jesusta entregag cag Judas Iscariote. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tsay chunca ishcay (12) apostolnincuna wilacog aywananpag cacharmi Jesús caynog nergan: “Ama aywanquitsu mana Israel runacunapa marcancunamanga, ni yaycapäcunquitsu Samaria provinciacho caycag marcacunamanpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tsaypa trucanga aywapäcuy Israel runacunalaman. Paycunaga ogracashga uyshanogmi carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Paycunata wilapanqui caynog nir: ‘Tayta Diosnintsipa maquincho ali cawanapag cag tiempo chämushganami.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gueshyagcunata aliyätsinqui. Wanushcunatapis cawaritsinqui. Leprawan gueshyagcunatapis aliyätsinqui. Demoniucunatapis runacunapita gargunqui. Gamcunata yanapashgänogla gamcunapis waquinta yanapay. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Arupacog runa arushganpita imatapis chasquishgannogmi gamcunapis wilacushgayquipita imatapis chasquinquipag. Tsaynog caycaptenga ama apapäcunquitsu guellayta ni örutapis. Tsaynogpis ama apapäcunquitsu guepinayquita, trucacunayquipag röpayquita ni tucruyquitapis. Jatirashgayqui llanquilayquiwan aywapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“May marcaman o may jalgacunaman chayarpis tapucunqui mayganpis ali runa cashganta. Mayganpis ali runa captenga paypa wayilancho posädacärinqui juc marcapa pasanayquiyag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tsay runapa wayinman chayar caynog nipäcunqui: ‘Ali cawanayquipag Tayta Diosnintsi yanapayculäshunqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ali chasquishuptiquega nipäcushgayquinogmi paypag ali caway canga. Mana chasquishuptiquega juc wayimanna aywanqui posädata ashinayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Runacuna wilacushgayquita mana chasquishuptiquega marcapitapis aywacärinqui llanquiquicho caycag polvuta tapshirishpayqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tsaynog mana chasquishushgayquipitami Sodoma y Gomorracho tag runacuna infiernucho nacananpag cashganpitapis paycuna más fiyupa infiernucho nacangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Shumag tantyacäriy. Gamcunata fiyu runacuna cashganman cachaycä uyshacunata atogman gaycognogmi. Tsaynog caycaptenga culebranogpis alcäbula puricunqui. Itsanga imatapis lutanta ama rurapäcuytsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chiquishogniqui runacunaga autoridäcunamanpis prësu tsarircur apapäcushunqui juzgashga canayquipag. Tsaynoglami sinagogancunachöpis astashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nogata chasquicamashgayquipitami nación mandag reycunamanpis apapäcushushpayqui castigashunquipag. Tsaynogpami wilacuynëta paycunata y tsaycho cag waquin mana Israel runacunatapis wilapanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Autoridäcunaman entregapäcushuptiquipis ama laquicärinquitsu: ‘¿Imatarag nishag?’ nishpayqui. Autoridäcunapa naupancho manami quiquiquipa yarpaynilayquipitatsu parlapäcunquipag, sinöga Tayta Dios cachamushgan Santu Espiritumi tantyatsishunqui imata parlanayquipagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nogata chasquicamashganpita chiquirmi wauguintapis autoridäcunaman entreganga wanutsishga cananpag. Waquinnami tsurinta entreganga wanutsishga cananpag y waquinnami taytantapis entreganga wanutsishga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nogata chasquicamashgayquipitami pï-maypis chiquishunquipag. Tsaynog chiquishuptiquipis hasta wanunayquiyag nogaman yäracamashpayquimi Tayta Diospa naupanman chayanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcacho chiquishuptiquega juc marcaman gueshpicärinqui. Manarag lapan Israel nacioncho cag marcacunapa puriptiquimi noga cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maygan yachacogpis manami yachatsegninpita mastaga yachantsu. Tsaynogla ashmaypis manami patronninpita más munayniyogtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nogatapis chiquiycämarga gamcunata masragmi chiquishunquipag. Nogatapis: ‘Satanasmi payga’ niycämarga gamcunatapis Satanás cashgayquitami runacuna nishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Cay patsacho runacuna chiquishuptiquipis mana mantsacuypa wilacuynëta wilacäriy. Tayta Diospa wilacognin cashgayquita cay patsacho runacuna mana tantyaptinpis Tayta Diospa naupanman chayaptiquimi itsanga lapanpis musyapäconga wilacognin cashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tsaynog caycaptenga yachatsishgäta mana mayagcunata gamcunana mana mantsacuypa wilapanqui. Tsaynog wilacunayquipagmi gamcunata yachaycätsë. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama mantsacäriytsu pipis wanutsishunayquipag jurapäshuptiqui. Wanutsishushpayquipis almayquitaga manami wanutsengatsu. Chiquishogniquicunata mantsacunayquipa trucanga Tayta Diosnintsita cäsucäriy. Paymi itsanga munayniyog caycan almantinta pitapis infiernuman gaycunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Tantyacäriy. Pichiuchancacunata runacuna mana cäsupaptinpis Tayta Diosnintsi lapantami ricaycan. Pichiuchancatapis tsaynog ricaycarga gamcunata masragmi Tayta Diosnintsi ricaycäshunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tsaynoglami agtsayqui ayca cashgantapis payga musyaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pishgucunapitapis más väleg captiqui Tayta Dios cuidaycäshuptiquega pitapis ama mantsacäriytsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pipis nogata chasquicamashganta mana pengacuypa wilacuptenga nogapis Tayta Diospa naupancho paycunapa favorninmi parlashagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pipis runacunapa naupancho pengacushpan chasquicamashganta ñëgamaptenga nogapis Tayta Diospa naupancho paycunata: ‘Manami reguëtsu’ nishagpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gamcuna ama yarpapäcuytsu nogata chasquicamashgayquipita runacuna mana chiquishunayquipag cashganta. Tsaypa trucanga nogata chasquicamagcunata runacuna chiquengapagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nogata chasquicamashganpitami tsurinpis taytanpa contran sharconga. Mamanpa contranmi wawanpis sharconga. Tsaynoglami lumtsuyninpis suedranpa contran sharconga. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tsaymi cuyashunayquipa trucanga castayquicunapis chiquishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nogata chasquicamashganpita maman chiquiptinpis, taytan chiquiptinpis o tsurin chiquiptinpis noga munashgänog imaypis cawatsun. Noga nishgäta cäsucunanpa trucanga maman, taytan o tsurin nishganta cäsucogcunaga manami rasunpatsu chasquicamashga. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tsaynog captenga imanog nacarpis noga munashgänogla imaypis cawatsun. Wanunanyag noga munashgänog mana cawag cäga manami rasunpatsu chasquicamashga. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noga munashgänog cawananpa trucan quiquin munashgannog cawagcunaga infiernuman gaycushgami cangapag. Ima nacaycho carpis noga munashgänog cawagcunami itsanga gloriaman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Gamcunata chasquishushpayquega nogatami chasquicaycäman. Tsaynogpis nogata chasquicamag cäga Taytätapis chasquicuycanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tayta Diospa wilacogninta wayinman chasquicog cäga gloriaman chayar wilacogcuna premiuta chasquishgannogmi paypis premiuta chasquengapag. Tsaynoglami Tayta Dios munashgannog cawag ali runata wayinman chasquicog cäga gloriaman chayar tsay ali runa premiuta chasquishgannog paypis premiuta chasquengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chasquicamagcunata pipis noga-raycu juc pusillu yaculatapis macyaptenga Tayta Diosnintsi paytapis premiutami gongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chunca ishcay (12) apostolnincunata yachatsiyta usharcurnami Jesusga Galilea provinciapa marcan marcan purergan Tayta Diosnintsipa wilacuyninta wilacur. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Carcilcho caycarmi Juan Bautista mayargan Jesús milagrucunata ruraycashganta y Tayta Diosnintsipa wilacuyninta wilacur puriycashgantapis. Tsaymi discïpuluncunata Jesús cagman cachargan caynog nir tapumunanpag: ");
INSERT INTO qvmNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“¿Gamcush caycanqui Tayta Dios cachamushgan Cristo, o juctaragcush shuyarpäshag?” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tsaynog tapuptinmi Jesús nergan: “Cutishpayqui Juanta wilapäcuy ricashgayquita y mayashgayquitapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gapracuna ricannami. Puriyta mana puëdeg wegrucuna purinnami. Leprawan gueshyagcuna aliyashganami caycan. Upacuna mayannami. Juc ishcay wanushcunapis cawarimushganami. Wactsacunapis Tayta Diosnintsipa wilacuyninta mayaycannami. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nogaman yäracamashgannogla imaypis Juan yäracamätsun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanpa cachancuna cuticäriptinnami runacunata Jesús caynog nergan: “Chunyag jircaman Juanta ricanayquipag aywar manami jachata wayra cuyutsegta ricanayquipagtsu aywapäcorgayqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsaynogpis manami fïnu röpan jatishga runata ricanayquipagtsu aywapäcorgayqui. Reypa wayincho tagcunalami ali röpan jatishga carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Manami tsaycunata ricagtsu aywapäcorgayqui, sinöga Tayta Diosnintsipa profëtanta ricanayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanpagmi Tayta Diosnintsipa palabrancho caynog escribiraycan: ‘Wilacognëtami cachashag runacunata camaricatsinanpag. Tsaynogpami camaricushga canga shamuptë chasquicamänanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Juanpag tsaynog escribishga captinmi lapan runacunapitapis payga más puntata tantyashga Tayta Dios cachamushgan Cristo cashgäta. Tsaynog captinpis discïpulöcunaga nogawan purishga carmi Juanpita masla tantyapäcun Dios cachamushgan Cristo cashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Moisés escribishgancuna, Tayta Diosnintsipa profëtancuna escribishgancuna y Juan Bautista wilacushgancunapis niycan noga shamunäpag cagpitami. Tsaymi Juan wilacuyta galaycushganpita-patsa atsca runacuna Tayta Diosnintsipa wilacuyninta chasquicurcaycan. Tsaynog caycaptinpis waquin runacunaga manami munantsu tsay wilacuyta wilacunanta, sinöga imanogpapis tsapatami churapaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tsaynoglami Tayta Diospa palabrancho escribiraycan Elías shamur wilacunanpag cashganta. Tantyanayquipag sasa captinpis Juan Bautista wilacuptinmi cumplergan Elías shamur wilacunanpag escribiraycashgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Tsaynog nircushpan Jesús mastapis caynog nergan: “Canan tiempo runacunaga yupay-tucog wamracunanogmi carcaycan. Manami chasquicamantsu noga yachatsishgäcunata ni Juan Bautista yachatsishgancunatapis. Wamracuna: ‘Puclar fiestata rurashun’ nir quënata tucaptin yanasancuna gatswayta mana munashgannogmi noga yachatsishgäcunatapis mana chasquicärintsu. ‘Aya pampayta puclar laquicuypa cantashun’ niptinpis yanasancuna puclayta mana munashgannogmi Juan Bautista yachatsishgancunatapis chasquicuyta mana munantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan Bautista imaypis ayunaptin y vïnuta mana upuptin: ‘¡Payga demoniupa munaynincho carmi tsaynog caycan!’ nipäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pï-may runawanpis juntacar noga ima micuytapis micuptë y vïnutapis upuptë ‘Micular upular puricun’ nipäcaman. Tsaynogpis: ‘Jutsasapa runacunawan y Romapag impuesto cobragcunawan puricog’ nipäcaman. Tsaynog mana chasquicamaptinpis Juanta y nogata Tayta Dios cachamashgan tantyacaycan Tayta Dios munashgannog cawapäcuptëmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Milagrucunata Jesús rurashganta ricarpis waquin runacuna jutsa ruraycunata manami cacharergantsu. Tsaymi paycunapag Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Corazín marcacho tag runacuna! ¡Betsaida marcacho tag runacuna! ¡Juicio final junäga pasaypami laquicunquipag! Gamcunacho milagrucunata rurashgänog Tiro y Sidón marcacunacho milagrucunata ruraptëga maynami jutsa ruraycunata cacharinman cargan. Tsaynogpis jutsa rurashganpita laquicur maynami cotenciapita rurashga röpata jaticurcur uchpaman jamaycur wagapäcunman cargan. Gamcunaga milagrucunata rurashgäta ricaycarpis jutsa ruraycunata cachariyta manami munapäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tsaynog cashgayquipitami Tiro y Sidón marca runacuna infiernucho nacashganpitapis gamcunaga infiernucho más fiyupa nacanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Capernaum marcacho tag runacuna, ¿gamcunaga Tayta Diosnintsipa naupanman chayanayquipag cashgan imatachari yarparcaycanqui? Tayta Diosnintsipa naupanman chayanayquipa trucanga Hadisman gaycushgami capäcunquipag. Gamcunacho rurashgä milagrucunata Sodoma marcacho ruraptëga jutsancunata cachariptin hasta cananyagmi tsay marca caycanman cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sodoma marca runacuna infiernucho nacananpag cashganpitapis gamcuna más fiyupami infiernucho nacanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tsaychömi pasaypa cushicushpan Tayta Diosnintsita Jesús manacorgan caynog nir: “Jana patsacho y cay patsachöpis gam munayniyogmi caycanqui, papá. Yachag-tucogcunata manami tantyatsishcanquitsu nogata cachamashgayquita. Paycunata tantyatsinayquipa trucanga yachacuyta munagcunalatami tantyatsishcanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tsaynog canantami munashcanqui, papá.” ");
INSERT INTO qvmNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nircurnami discïpuluncunata caynog nergan: “Taytämi lapantapis munaynëman churamushga, tsurin captë. Noga imanog cashgätapis Taytalämi musyan. Tsaynogmi pay imanog cashgantapis nogala musyä. Tsaymi tantyatsishgä cagcunala musyapäcun Taytä imanog cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tayta Diosnintsi munashgannog cawayta mana camäpacorga nogaman yäracamay. Yäracamaptiquega yanapashayquimi. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noga yachatsishgänogla cawapäcuy. Tsaynogpis shumag tantyacäriy cuyapäcog y mana runa-tucog cashgäta. Tsaynog cawarga ali cawaytami tarinquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noga yanapaptë Tayta Dios munashgannog cawanayquipäga manami sasatsu caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tsaypita sábado jamay junagchömi discïpuluncunawan Jesús pasarcaycargan trïgu poguraycag chacracuna cuchunpa. Tsaymi discïpuluncunaga pasaypa yarganashpan trïguta palarcur cuparishpan micapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tsaynog rurashganta ricarmi fariseo runacuna Jesusta caynog nergan: “Discïpuluyquicuna sábado jamay junagcho trïguta palarga Moisés escribishgan leycunata manami cäsucuycantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsaymi Jesús caynog nergan: “Sábado jamay junagcho trïguta palarpis paycunaga manami jutsatatsu rurashga. Atsca cutimi gamcuna liyipäcushcanqui David yanapagnincunawan micanar imata rurapäcushgantapis. Atsca cuti liyiycarpis ¿manacu tantyapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Paymi Tayta Diosta manacuna wayi rurinman yaycur Tayta Diosnintsipag churaraycag tantata paywan aywag runacunawan micorgan. Tsay tanta cüracunala micunanpag caycaptinpis tsayta micur Davidga manami jutsata rurashgatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Tsaynogpis Moisés escribishgan leycunata atsca cuti liyirpis ¿manacu tantyapäcunqui sábado jamay junag templucho cüracuna rurashgancuna jutsa mana cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tsaynoglami discïpulöcunapis mana jutsayogtsu caycan, sábado jamay junagcho mana jamarpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Gamcunaga manami tantyacunquitsu Tayta Diospa palabrancho caynog escribiraycashganta: ‘Nogapag uywacunata altarcho rupatsishgayquipitapis runa mayiquita más cuyapänayquitami munä.’ Tsay escribiraycashganta tantyacorga manami discïpulöcunata jamurpaycanquimantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nogami munayniyog caycä sábado jamay junagcho runa rurananpag mana rurananpag cagtapis ninäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsaypita aywar Jesús yaycorgan tsay marcacho sinagogaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tsaycho juntacashga caycag runacunawanmi wanushga maquiyog runapis caycargan. Tsaymi fariseo runacuna Jesusta taporgan caynog nir: “Sábado jamay junag caycaptin wanushga maquiyog runata ¿aliyätsinquimancu o manacu?” Tsaynog taporgan aliyätsiptin tsay achäquilawan Jesuspa contran sharcapäcunanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tsauraga Jesús nergan: “Maygayquipapis uyshayqui pözuman jegaptin ¿manacu jinan höra jorgog aywanqui, sábado jamay junag caycaptinpis? ");
INSERT INTO qvmNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Uyshapitapis más cuyaymi runacunaga caycan. Tsaynog caycaptenga sábado jamay junagchöpis gueshyagcunata aliyätsishagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nircur tsay gueshyaycag runata Jesús nergan: “¡Maquiquita jogariy!” Jogarcuptinmi maquin sänuna ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sábado jamay junagcho tsaynog aliyätsiptinmi fariseo runacuna tsay sinagogapita yargurcur wilanacärergan Jesusta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsauraga Jesús tsaynog parlapäcushganta musyaycur aywacorgan tsay marcapita. Aywacuptinmi atsca runacuna guepanpa aywargan. Guepanpa aywag runacuna mayganpis gueshyaptin Jesús aliyätserganmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aliyarcatsirmi Jesús nergan: “Pitapis ama wilapanquitsu noga aliyätsishgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesús tsaynog cuyapäcog cananpag cashganpitami profëta Isaías Tayta Diosnintsi nishgancunata escribergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Juc sirvimagnë runami shamonga. Acrashgä captinmi paypita fiyupa cushicö. Paytami Santu Espíritu shumag yanapanga. Tsaynog yanapaptinmi ali cawayta cay patsaman apamonga may-tsay nacionchöpis runacuna noga munashgänog cawananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Runacuna gayapaptinpis manami imatapis nengatsu. Tsaynogpis manami purengatsu: ‘Nogaga más yachagmi cä’ nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pasaypa laquicogcunata manami manacagman churangatsu, sinöga cuyapangami. Jutsa rurag runacunata manami juclatsu castiganga, sinöga munashgänog cawananpagmi tantyatsenga. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tsaynogpami may-tsay nación runacunapis payman yäracur salvacongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsaypita demonio gaprayätsishgan y shiminta watacätsishgan runata Jesús cagman pushargan aliyätsinanpag. Tsay runapita demoniuta Jesús garguptinmi rimarganna y ricarganna. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tsaynog aliyätsegta ricarmi runacuna cushicushpan caynog nipäcorgan: “¿Salvamänantsipag Tayta Dios cachamushgan rey Davidpa castantsurag payga caycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsaynog nishganta mayar fariseo runacuna caynog nipäcorgan: “Tagay runaga manami Tayta Diospa munayninwantsu demoniucunata runacunapita gargun, sinöga demoniucunapa mandagnin Beelzebupa munayninwanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tsaynog parlashganta mayarmi Jesús caynog nergan: “Juc nacioncho runacuna quiquinpura chiquinacorga ¿manatsurag wanutsinacur ushacanman? Tsaynogpis juc marcacho o juc wayicho tagcuna quiquinpura chiquinacorga ¿manatsurag wacpa caypa aywacur ushacanman? ");
INSERT INTO qvmNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tsaynog captenga ¿imanirtag yarparcaycanqui Satanaspa munayninwan demoniucunata gargushgäta? Quiquinpura gargunacorga Satanás ushacanmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Waquin runacuna demoniucunata garguptin gamcunaga yarpaycanqui Tayta Diosnintsipa munayninwan gargushgantami. Noga garguptëga ¿imanirtag yarparcaycanqui Satanaspa munayninwan demoniucunata gargushgäta? Tsaynog yarparga lutantami yarparcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tayta Dios cachamushgan Santu Espíritu yanapamaptinmi demoniucunata gargö. Gargushgäta ricarmi musyapäcunqui Tayta Diospa munayninwan Satanasta vincishgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Satanaspita más munayniyog cashganta tantyatsirmi Jesús yachatsergan caynog nir: “Calpayog runa wayinta täpaycaptenga manami pipis suwapanmantsu. Tsaynog täpaycaptinpis paypita más calpayog runa shamurmi itsanga matwaycur imancunatapis apacurcur aywaconga. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mayganpis mana chasquicamag cäga conträmi caycan. Nogata mana cäsumag cäga Satanás munashgantami ruraycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Runacuna ima jutsa rurashganta y lutancunata parlashgantapis perdonta manacuptenga Tayta Dios perdonangapagmi. Tsaynoglami Tayta Diospita shamushgäta mana tantyar conträ rimaptinpis Tayta Dios perdonanga. Tayta Dios cachamushgan Cristo cashgäta Santu Espíritu tantyaycätsiptin conträ rimagcunatami itsanga Tayta Diosnintsi imaypis mana perdonangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tsaynog nircushpan Jesús mastapis caynog nergan: “Wayuyninpa yörata reguishgantsinogmi parlacuyninpa musyantsi pipis ali runa cashganta o mana ali runa cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Fiyu runacuna! Gamcuna fiyu caycarga ¿imanogpashi alita rimapäcunquiman? Alita rimanayquipa trucanga shonguyqui lutancunata yarpashgalantami imaypis rimapäcunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Pipis shonguncho alita yarparga alitami parlan. Shonguncho mana alita yarparmi itsanga mana alicunata parlan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tsaymi juicio final junagchöga manacagcunata parlashgayquipita Tayta Diosnintsi juzgashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Alita parlaptiquega jutsaynag cashgayquitami Tayta Diosnintsi nishunquipag. Mana alita parlaptiquimi itsanga jutsayog cashgayquita nishunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tsaypitanami waquin fariseo runacuna y Moisés escribishgan leycunata yachatseg runacuna Jesusta nipäcorgan: “Tayta Diosnintsi rasunpa cachamushushgayquita musyapäcunäpag ima milagrutapis rurayculay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tsauraga Jesús caynog nergan: “Gamcunaga manami rasunpatsu Tayta Diosman yäracärinqui. Tsaymi pay cachamashganta criyinayquipag milagruta ruranätarag munarcaycanqui. Munashgayquinöga manami milagruta rurashagtsu. Tsaypa trucanga Tayta Dios juc milagrutaragmi ruranga profëta Jonasta pescädupa pachancho caycashganpita yargatsimur milagruta rurashgannog. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Quimsa junag quimsa pagas jatuncaray pescädupa pachancho caycashganpita Tayta Diosnintsi Jonasta yargatsimushgannogmi nogatapis quimsa junag quimsa pagas pamparashgäpita cawaritsimangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Jonás wilacushganta mayarmi Nínivicho tag runacuna jutsa rurashganta cacharergan. Jonaspita más munayniyog noga caycaptëpis wilacushgäta canan witsan runacuna manami chasquicärintsu. Tsaymi juicio final junag Nínivicho tag runacuna sharcamongapag canan witsan runacunata: ‘Nogacuna Jonás wilacushganta chasquicuycaptëga ¿imanirtag gamcuna Tayta Diospa tsurin wilacushganta mana chasquicärergayquitsu?’ ninanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Musyashgayquinogpis Salomonpa yachatsicuyninta mayananpagmi Sabá nacionpita-patsa mandag warmi shamorgan Jerusalenman. Paymi juicio final junag sharcamongapag canan witsan runacunata: ‘Salomón yachatsishganta noga chasquicuycaptëga ¿imanirtag gamcuna Tayta Diospa tsurin yachatsishganta mana chasquicärergayquitsu?’ ninanpag. Salomonpita noga más yachag captëpis canan witsan runacunaga manami wiyacärintsu noga wilacushgäcunata. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Runapita demonio yargurna chunyagcunapa purin maychöpis tänanpag ashir. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mana tariycorga yarpan yargushgan runaman yapay cutiyta. Cutiycushpanmi tarin pitsapacushga y churapacushga jäcuycag wayitanog. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsaynog jäcuycagta tariycurmi paypita más fiyu ganchis demoniucunata pushacurcur tsay runaman cutin paycho tänanpag. Tsaymi naupata cashganpitaga tsay runa más fiyuna ricacun. Tsaynogmi pasanga canan witsan fiyu runacunatapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús tsaynog yachaycätsiptinmi mamanwan wauguincuna tsayman chayargan. Chayaycurmi punculacho shuyarpaycargan Jesuswan parlayta munashpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Paycunata ricarmi juc runa Jesusta wilargan caynog nir: “Mamayqui y wauguiquicunami puncucho shuyarpaycäshunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Tsaynog wilaptinmi discïpuluncunata ricärir Jesús caynog nergan: “Paycunami mamänog y wauguëcunanogpis caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pipis mamänog, wauguëcunanog y panëcunanog carcaycan Tayta Dios munashgannog cawag cagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsay junaglami wayipita yargurir Jesús aywargan Galilea lagüna cuchunman. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsaymanmi atsca runacuna juntacargan Jesús yachatsishganta mayayta munar. Aläpa quichquipaptinmi lagüna cuchuncho caycag büquiman Jesús witsargan tsaypitana yachatsimunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nircurnami imamanpis tincutsiypa atsca yachatsicuyta yachatsimorgan caynog nir: “Juc runashi aywargan trïgu murog. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tsayshi muruta matsiptin waquin chayargan näniman. Tsaycho matsiraycagtami pishgucuna shamur upshacurcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","“Waquin cag murunashi chayargan shalaman. Tsaycho winamurpis alpa aläpa mana captin shanaywan tsaquicäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin cag murunashi chayargan cashacuna rurinman. Cashacuna rurincho garwashtaycälar winamurshi mana wayorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Waquin cag murunashi hondu alpaman chayargan. Tsaycunaga ali winamurshi ali espïjayog cargan. Waquin espïjashi wayorgan pachac (100) trïguta, waquin espïjacunashi wayorgan sogta chunca (60) trïguta y waquinnashi wayorgan quimsa chunca (30) trïguta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tsaynog yacharcatsir Jesús caynog nergan: “Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsaynog yachatsiptinmi discïpuluncuna Jesusta caynog nipäcorgan: “Imamanpis tincutsiypa yachatsipäcamaptiqui manami shumag tantyapäcötsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tsaymi Jesús caynog nergan: “Gamcunataga tincutsiypa yachatsishgäcunata shumagmi tantyatsishayqui. Mana cäsucamagcunatami itsanga mana tantyatsiylapa yachatsishag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tsaynog captenga mayganpis yachacuyta munagcunaga yachatsishgäcunata tantyangapagmi. Mana yachacuyta munagcunami itsanga mayarpis mana tantyangapagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsaymi noga yachatsë imamanpis tincutsiypa. Tsaynogpami yachacuyta mana munagcunaga ricaycarpis mana tantyantsu y mayaycarpis mana chasquicuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tsaynog cananpag cashganpitami Tayta Dios nishganta profëta Isaías escribergan caynog nir: ‘Gamcuna mayaycarpis manami tantyanquitsu. Ricaycarpis manami chasquicunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cay runacunapa shongun chucruyashgami caycan. Tsaymi rinrincunapis tsapacashganog caycan. Nawincunapis mana ricagnog caycan. Tsaynog carmi paycunaga imata yachatsishgätapis mana tantyacuntsu. Tsaymi mana chasquicamantsu jutsancunapita perdonashga cananpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gamcunami itsanga ricashpayqui y mayashpayqui imata yachatsishgätapis tantyacurcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Unay profëtacuna y Tayta Dios munashgannog cawag runacunapis reguimaytami munargan. Reguimayta munarpis cay patsaman manarag shamuptëmi mana reguimashgatsu. Tsaynogpis noga wilacushgäcunata mayayta munarpis manami mayapäcamashgatsu. Gamcunami itsanga ricarcaycämanqui y mayarcaycämanquipis. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Canan tantyatsishayqui murog runaman tincutsiypa yachatsishgäta. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Trïgu muroga Tayta Diosnintsipa wilacuyninmi caycan. Chucru näninogmi waquin runacunapa shongun chucru caycan. Tsaynog chucru shongu carmi Tayta Diosnintsipa wilacuyninta mayarpis mana chasquicuntsu. Tsaymi mayashgalantapis Satanás gongaycatsin. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Waquin runacunapa shongonga shalanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta mayar cushishgami chasquicärin. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Cushishga chasquicurpis shalacho alpa aläpa mana captin trïgu jegarcamur tsaquicäcushgannogmi paycunapis carcaycan. Tsaymi runacuna chiquiptinpis o ima nacaycho carpis cuticärin naupata cawashganmannog. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Waquin runacunapa shongonga casha rurincho cag alpanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta mayarpis más yarpachacun rïcu canalanpag y quiquin munashgannog cawanalanpagmi. Tsauraga tsaycunalapag yarpachacorga manami Tayta Diosnintsi munashgannogtsu cawarcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Waquin runacunapa shongonga hondu alpanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta cushishga chasquicur Tayta Diosnintsi munashgannogmi cawan. Tsaymi ali alpacho juc murulapita pachac (100) trïgu o sogta chunca (60) trïgu o quimsa chunca (30) trïgu wayushgannog tsay runa Tayta Diosnintsi munashgannog cawanga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Juicio final junagchörag runacuna juzgashga cananpag cashganpita yachatsir Jesús caynog nergan: “Juc runashi chacraman aywargan trïguta murunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mururcuptinnashi chiquegnin runa tsacaypa aywarcur trïgu murushgan chacraman cebadilluta murorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trïgu winamuptinshi cebadillupis winamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsaynog winamuptinshi trïgu tirapagcuna trïgupa duëñunta caynog nergan: ‘Acraylata muruycaptiquega ¿maypitatag cebadillu winamushga, tayta?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tsaynog wilaptinshi trïgupa duëñun caynog nergan: ‘Mayganpis chiquipämagnëmi tsaytaga muruycushga.’ Tsaynog niptinshi arogcuna caynog taporgan: ‘¿Munanquicu tsay cebadilluta tirapanäta?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tsaynog niptin caynog nergan: ‘Ama tsaytaga tirapaytsu. Cebadilluta tiraparga trïgutapis luquinquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jina winacutsun trïguwan cebadillu cosëchayag. Cosecharnami achogcuna acrapaylapa achongapag. Tsay acrashgan cag cebadillutanami achurcur ninaman gaycupäcongapag. Trïgutami itsanga shuntarcur pirwapäcongapag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mastapis Jesús tincutsiypa yachatsir caynog nergan: “Tayta Diospa ali wilacuynenga ñäpush murunogmi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ñäpushpa muronga pasaypa tacshala caycarpis muruptin winamur waquin jachacunapitapis más jatunmi ricacun. Tsaymi pishgucunapis gueshwancunata rämancunacho ruran. Tsay tacshala murulapita ñäpush winarcamur räman mashtacashgannogmi Tayta Diospa ali wilacuynenga may-tsaymanpis chayaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nircur Jesús caynogpis nergan: “Tayta Diospa ali wilacuynenga levadüranogmi caycan. Tantata rurananpag warmi quimsa arröba harinaman levadürata winaptenga mäsa shumagmi jacan. Ichicla levadüra mäsata jacatsishgannogmi Tayta Diosnintsipa wilacuyninpis may-tsayman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Runacunata Jesús yachatsishpanmi imamanpis tincutsiypa imaypis yachatsergan. Imamanpis mana tincutsiypaga manami imaypis yachatsergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tsaynog yachatsergan Tayta Diosnintsipa profëtan escribishgan cumplinanpagmi. Tsay escribishganga caynogmi niycan: “Imamanpis tincutsiypami runacunata yachatsishag. Patsata camashganpita-patsa pipis mana tantyashgancunatami yachatsishag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsaypitanami runacunata despacharcur discïpuluncunawan Jesús yaycorgan juc wayiman. Tsaychömi discïpuluncuna ruwacorgan tsay cebadillupita yachatsishganta tantyatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tsaymi Jesús caynog nergan: “Trïguta murog runaga nogami caycä. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tsay chacraga caycan intëru cay patsami. Tsay trïgu muroga caycan Tayta Diosnintsipa wilacuyninta chasquicog runacunami. Tsay cebadilloga caycan Satanás munashgannog cawag runacunami. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tsay cebadilluta murog cäga Satanasmi caycan. Cosëchaga caycan juicio finalmi. Cosëchata shuntagcunaga caycan angilcunami. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Cebadilluta shuntarcur ninaman gaycushgannogmi juicio final junagchöpis Satanás munashgannog cawag runacunata infiernuman gaycongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nogami angilnëcunata cachamushag jutsa ruratsegcunata y jutsa ruragcunatapis shuntarcur infiernuman gaycunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tsaychömi pasaypa wagar quiruntapis uchupäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tayta Diosnintsi munashgannog cawagcunami itsanga paypa naupancho car cushishga cawapäcongapag. Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mastapis Jesús yachatsergan caynog nir: “Tayta Diospa naupanman chayanantsipag cashganga caynogmi caycan. Juc runashi chacrapa purir tarergan tsaytsica guellay pamparaycagta. Tsay guellayta tariycurshi cushicushpan yarpachacorgan: ‘¿Imatatag ruräman tsay guellay nogapa cananpag?’ nir. Tsayshi tsay guellayta cashgalanman pampaycur cushishga aywar ranticorgan lapan imaycancunatapis. Tsay guellaywannashi rantergan guellay pamparaycashgan cag chacrata. Tsaynogpashi pamparaycag guellayta jorgur rïcu ricacorgan. Tsaynoglami Tayta Diospa naupanman chayayga más cushicuypag caycan cay patsacho imaycayog cashgantsipitapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tsaynogpis Jesús caynog nergan: “Tayta Diosnintsipa wilacuyninta chasquicog runaga öru ranteg negocianti runanogmi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tsay runaga más alinnin cag öruta tariycorga wayintapis chacrantapis ranticun tsay öruta rantinan cashga. Tsaynoglami Tayta Diospa naupanman chayayga más ali caycan cay patsacho imaycapitapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tsaynogmi Jesús yapay caynog yachatsergan: “Musyashgayquinogpis lamarman redta jitarcur lapan casta pescädutami tsaripäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nircurmi lamar cuchunman jorgupäcun tsaycho acrapäcunanpag. Tsaychömi micuna cagta canastaman winan y mana micuna cagtanami jitarin. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pescäduta acrashgannoglami juicio final junag lapan runacunata acrananpag Tayta Diosnintsi angilnincunata cachamonga. Tsaynogmi ali runacunata raquenga jutsa rurag runacunapita. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jutsa rurag runacunatami infiernuman gaycongapag. Tsaychömi fiyupa wagar quiruntapis uchupäcongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsaynog yacharcatsirmi Jesús taporgan discïpuluncunata caynog nir: “¿Cay yachatsishgäcunata gamcuna tantyanquicu?” Tsaynog tapuptinmi: “Au, tantyämi, tayta” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsauraga Jesús caynog nergan: “Tayta Dios munashgannog runacuna cawananpag yachatsishgäcunata tantyarga waquin runacunata gamcunapis yachatsinqui. Tsaynog yachatserga pirwapita maran cagcunata y tsayrag churashgan cagcunata jorgarcamur garagnogmi gamcunapis naupa cag yachatsicuycunata y mushog yachatsicuycunatapis yacharcaycätsinqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tsaynog yacharcatsirmi Jesús tsaypita aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Marcanman chayarnami Tayta Diosnintsipa wilacuyninta yachatsergan sinagogacho. Tsaycho yachatsiptinmi cushicushpan caynog nipäcorgan: “Tsaynog yachatsinanpäga ¿maychötag payga yachacushga? Tsaynogpis ¿imanogpatag payga milagrucunata ruran? ");
INSERT INTO qvmNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manacu payga carpintëro Josëpa tsurin caycan? Tsaynogpis paypa maman ¿manacu María? ¿Manacu paypa wauguincuna caycan Santiago, José, Simón y Judaspis? ");
INSERT INTO qvmNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tsaynoglami panincunatapis reguintsi. Tsaynog caycaptenga ¿maychötag yachacamushga tsayjinanpa yachaycunanpäga?” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsaynog nirmi Jesús yachatsishgancunata mana chasquicärergantsu. Tsaymi Jesús nergan: “Waquin marcacunacho Diospa profëtanta chasquicäriptinpis castancuna y marca mayincunaga manami chasquicärintsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tsaynog mana chasquicuptinmi juc ishcay milagrucunalata tsaycho rurargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tsay witsanmi Galilea provinciapa mandagnin Herodista runacuna wilargan Diospa wilacuyninta wilacur y milagruta rurar Jesús puriycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsaymi ashmaynincunata Herodes caynog nergan: “Tsay runaga Juan Bautistami cawarimushga canga. Cawarimushga carmi munayniyog caycan milagrucunata rurananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Juan Bautista manarag wanuptinmi Herodisga wauguin Felipipa warmin Herodiasta suwargan warmin cananpag. Tsaynog suwashga captinmi Juan Bautista caynog nergan: “Wauguiquipa warminta suwamushpayqui jutsatami rurashcanqui.” Tsaynog nishganpitami Juan Bautistata Herodes carcilman wichgatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tayta Diosnintsipa profëtan Juan cashganta lapan runacuna niptinmi Herodisga wanutsiyta munarpis mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsaypita Herodispa diancho fiesta captinmi Herodiaspa jipash wawan gatswargan lapan gayatsishgancunapa naupancho. Shumag gatswashganta ricarmi Herodes pasaypa cushicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tsaymi tsay jipashta caynog nergan: “Imatapis manacamashgayquitami camaripäshayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsaynog niptinmi tsay jipashga maman yachatsishgannogla Herodista nergan: “Plätuwan Juan Bautistapa umanta goycamay.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tsaynog manacuptinmi rey Herodes pasaypa laquicorgan. Juanta wanutsiyta mana munarpis gayatsishgancunapa naupancho tsay jipashta promitishga carmi wardiata cachargan Juanpa umanta rogurir tsay jipashta goycunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tsaymi carcilman wardia aywaycur Juanta wanutsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nircurna umanta roguriycur plätuwan apaycur jipashta entregargan. Chasquircurnami jipashga mamanta entregaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsaynog rurashganta mayaycurmi Juanpa discïpuluncuna aywar ayanta shuntacärergan pampananpag. Tsaypitanami Jesusta wilapäcorgan Juanta wanutsishganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsaypitanami Herodes musyargan milagrucunata rurar Jesús puriycashganta. Herodes musyashganta mayaycurmi büquiman witsarcushpan Jesús chunyagninman aywacorgan. Japalan aywacuptinpis runacuna musyargan mayman aywaycashgantapis. Tsaymi chaquilapa aywapäcorgan Jesusta tarinanyag. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Büquipita urarcurnami Jesús tarergan atsca runacuna tsaycho shuyarpaycagta. Paycunata ricaycurmi Jesús cuyapashpan tsayman apashgan gueshyagcunata aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Patsa tardiyaptinnami Jesusta discïpuluncuna nipäcorgan: “Caychöga manami imapis cantsu runacunata garanantsipag. Tardina caycaptenga lapan runacuna aywacutsun cercacho cag marcacunapa micuyta rantipäcunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tsaynog niptin Jesús caynog nergan: “Manami paycunaga micuy asheg aywanmantsu. Paycunataga micuyta gamcuna garapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tsaynog niptinmi discïpuluncuna caynog nipäcorgan: “Pitsga tanta y ishcay pescädulami mircapäcuna caycan, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tsauraga Jesús caynog nergan: “Tsay mircapayquita apamuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nircur discïpuluncunata Jesús nergan runacunata pashpaman jamatsinanpag. Tsaypitanami pitsga tantata y ishcay pescäduta aptarcur Jesús jana patsata ricärishpan Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paquircur discïpuluncunata macyargan lapan runacunata aypunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tsaymi lapan micapäcorgan sacsashganyag. Nircurna putsushgancunata discïpulucuna shuntapäcorgan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tsaycho micogcunaga cargan pitsga waranganog (5,000) runacuna, warmicunata y wamracunata mana yupaylapa. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsaypitana discïpuluncunata Jesús nergan büquiman witsarcur wac tsimpaman naupapäcunanpag. Discïpuluncuna aywacuptinmi tsaycho cag runacunata despachacur Jesús quëdacorganrag. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nircurnami jircaman witsargan Tayta Diosta manacunanpag. Tsaycho manacuycaptinmi patsa tsacaycarganna. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tsayyäga büquiwan naupagcuna carutanami aywarcaycargan. Tsaynog aywarcaycaptinna yacuta wayra fiyupa altuparag sharcatsimorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsaypita walpa wagay höranog caycaptinna yacu jananpa Jesús aywargan discïpuluncuna cagman. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yacu jananpa aywaycagta ricaycurmi discïpuluncuna fiyupa mantsacar gaparargan: “¡Achachalay! ¡Almachag yacu jananpa aywaycämun!” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tsaynog mantsacuptinmi Jesús caynog nergan: “¡Ama mantsacamaytsu! Nogami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsaymi Pedro caynog nergan: “Rasunpa gam carga nogapis yacu jananpa gam cagman shamunäpag niycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tsaynog niptin Jesusga nergan: “Shamuy, ari.” Tsauraga büquipita yargurir yacu jananpa Jesús cagman Pedro aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aywaycashganchömi fiyupa wayrar yacuta jananman pulchagyätsiptin pasaypa mantsacargan. Talpucarnami gaparargan caynog nir: “¡Salvaycalämay, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tsaynog niptinmi Jesús jucla maquinpita tsutarcur caynog nergan: “¡Yäracuyniynag runa! ¿Imanirtag mana yäracamanquitsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tsaypita büquiman witsarcuptin wayrapis chawarganna. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tsayta ricaycurmi büquicho caycagcuna Jesuspa naupanman gongurpacuycur caynog nipäcorgan: “¡Rasunpami Tayta Diospa tsurin gam caycanqui, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Galilea lagünata tsimparcurnami chayapäcorgan Genesaret pampaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tsayman Jesús chayashganta musyaycurmi gueshyagcunata runacuna may-tsay marcacunapitapis apargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tsay apashgan gueshyagcunami Jesusta ruwacorgan röpanpa cuchulantapis yataycunanpag. Tsaynog ruwacur yataycogcuna aliyarganmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tsaypitanami fariseucuna y Moisés escribishgan leycunata yachatsegcuna Jerusalenpita shamorgan Jesusta tapupäcunanpag. Chayaycurnami Jesusta taporgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imanirtag discïpuluyquicuna unay runacunapa costumbrincunata mana cäsur micapäcunanpag maquincunata mana maylacuntsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tsaynog niptin paycunatapis Jesús nergan: “Gamcunapis ¿imanirtag Tayta Diosnintsipa palabranta cumplinayquipa trucanga tsay costumbrilayquicunata más cumplipäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tayta Diosnintsipa palabranchöga caynogmi niycan: ‘Mamayquita y taytayquita ali ricanqui. Pipis mamanta o taytanta maldicionag cäga wanutsishga catsun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mamayquita y taytayquita ali ricanayquipag niptinpis gamcunaga manami yanapaycanquitsu. Tsaymi runacunata yachaycätsinqui: ‘Tayta Dioslapagmi imaycäpis caycan’ nerga mamanta y taytanta manana yanapananpag. Tsaynog yachatsirmi gamcunaga Tayta Diosnintsipa palabranta manacagman churarcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ishcay cära runacuna! Gamcuna tsaynog canayquipag cashganta musyarmi Santu Espíritu profëta Isaiasta tantyatsergan caynog escribinanpag: ");
INSERT INTO qvmNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay runacunaga janan shongulami: “Tayta Dios, Tayta Dios” nipäcaman. Tsaynogpis manami lapan shongunwantsu nogata chasquicaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Paycunaga wilacuynëta yachatsinanpa trucanga runacunapa costumbrilantami yacharcaycätsin. Tsaynog captinmi adorapäcamaptinpis paycunata mana cäsupäshagtsu.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nircurnami runacunata gayaycur Jesús caynog nergan: “Cay nishgäcunata lapayqui shumag tantyacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Manami imatapis micushganpitatsu pipis jutsayog ricacun, sinöga lutancunata rimashganpitami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tsauraga discïpuluncuna Jesusta caynog nipäcorgan: “Tsaynog niptiqui fariseo runacuna pasaypami rabiacärishga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tsaynog wilaptinmi Jesús caynog nergan: “Paycuna ima nishgantapis ama cäsupaytsu. Chacrapita mana ali jachacunata luquir jitarishgannogmi paycunatapis Tayta Diosnintsi juzgar naupanpita gargongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paycunaga yachag-tucurpis gapranogmi carcaycan. Gapra mayinta gapra pushar ishcan pözuman tunishgannogmi paycuna y yachatsishgancunata chasquipagcunapis infiernuman gaycushga cangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsaynog niptinmi Pedro caynog nergan: “Ima micuyta micurpis jutsaynag cashganta y lutancunata rimar jutsayog cashganta tantyaycatsilämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tsauraga Jesús nergan: “¿Gamcunapis manacu tantyapäcunquirag? ");
INSERT INTO qvmNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Imata micushgantsipis manami jutsayogyätsimantsitsu, sinöga micurcuptintsi pasacunlami. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Shonguncho lutancunata yarpachacurmi itsanga pipis jutsayog ricacun. Tsaynog carmi runa lutanta riman y lutanta ruranpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runacunaga shonguncho lutancunata yarpachacurmi runa mayinta wanutsipäcun, suwacärin, lulacärin y runa mayintapis ashlipäcun. Tsaynogpis adulterio jutsata rurapäcun, runacuna chinëru capäcun y warmicunapis waynan waynan puricärin. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tsaycunata rurarmi runacuna jutsayog ricacun. Tsaynog captenga manami micuycunata micurtsu o maquintsita mana awicuylapa micurtsu jutsayog ricacuntsi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tsaypitanami Jesús aywargan Tiro y Sidón provinciacunaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tsay marcacunachömi Cananea runacuna targan. Tsaymi juc Cananea warmi Jesús cagman aywaycur ruwacorgan caynog nir: “¡Rey Davidpa castan Jesús, cuyapaycalämay! ¡Warmi wawätami demonio löcayätsishga!” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tsaynog niptin Jesús manami imatapis parlacorgantsu. Tsaymi discïpuluncuna Jesusta caynog nergan: “Pasaypa gaparashpan tagay warmega umantsitapis nanätsimantsichag. Jucla aywacunanpag niyculay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsaynog nipäcuptinmi tsay warmita Jesús caynog nergan: “Tayta Diosnintsi cachamashga Israel runacunalata yanapanäpagmi. Paycunaga ogracashga uyshanogmi carcaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tsaynog niptinmi tsay warmi Jesuspa naupanman gongurpacuycur caynog nergan: “¡Ama fiyu caytsu! ¡Yanapaycalämay ari, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tsaynog ruwacuptinmi Jesús nergan: “Israel mayëcunataragmi yanapashag. Gamcunata yanapaptëga canman wamracunapa tantanta guechurir algucunata jitapaycognogmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tsaynog niptin warmi nergan: “Au, tayta. Tsaynog captinpis duëñun putsupacushgantami alguncunapis micapäcun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsauraga Jesús caynog nergan tsay warmita: “¡Lapan shonguyquiwan tsaynog yäracamashgayqui alimi caycan! Tsaynog yäracamashgayquipitami wawayqui aliyashgana caycan.” Tsay hörami tsay warmipa wawan aliyashgana cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsaypita aywacurnami Jesús chayargan Galilea lagüna cuchunman. Nircurnami juc lömaman witsarcur tsaycho jamacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsaymi Jesús cagman atsca runacuna juntacargan. Tsaynog juntacarmi apapäcorgan puriyta mana puëdeg wegrucunata, gapracunata, macllucunata, parlayta mana puëdegcunata y waquin gueshyawan gueshyagcunatapis. Paycunatami Jesús lapanta aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tsaynog aliyätsishganta ricaycurmi runacuna pasaypa cushicushpan caynog nipäcorgan: “Cananga upacuna rimannami, macllucunapis aliyashganami caycan, puriyta mana puëdeg wegrucunapis purinnami y gapracunapis ricannami.” Tsaynog nirmi Israel runacuna adorashgan Tayta Diosta paycunapis alabapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tsauraga discïpuluncunata gayaycur Jesús nergan: “Cuyapämi caycho nogantsiwan caycag runacunata. Paycuna quimsa junagnami nogantsiwan caycho caycan micuyta mana yawaylapa. Micönila wayincunapa cuticunanpag niptëga aywaycaptilannami vëtapis tsarenga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tsaynog niptinmi discïpuluncuna nergan: “¿Chunyag jircacho caycarga maychörag tariycushwan micuyta caytsica runacuna micunanpäga, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsauraga paycunata Jesús taporgan: “¿Aycalatag tantayqui caycan?” “Ganchis tantalami y juc ishcay pescädulami caycan, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsaynog niptinmi lapan runacunata nergan jamacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jamacäriptinnami pescäduta y ganchis tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata macyargan paycuna aypupäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tsaymi lapan micapäcorgan sacsashganyag. Putsushgancunatanami shuntargan ganchis canasta juntata. ");
INSERT INTO qvmNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tsaycho micogcunaga cargan warmicunata wamracunatapis mana yupaylapa chuscu waranganogmi (4,000). ");
INSERT INTO qvmNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tsaypitanami büquiman witsarcur discïpuluncunawan Jesús aywacorgan Magdala partiman. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Magdala partiman chayaycuptinmi fariseo y saduceo runacuna aywaycur Jesusta caynog nipäcorgan: “Tayta Diosnintsi rasunpa cachamushushgayquita musyapäcunäpag mä ima milagrutapis ruray.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tsauraga Jesús caynog nergan: “Inti jegashgan höra pucutay garwashtaptin gamcuna nipäcunqui: ‘Waraga usyangami.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tsaynogpis pasaypa pucutaraycar patsa waraptin gamcuna nipäcunqui: ‘Canan junäga tamyangami.’ Tsaycunata tantyaycarga ¿imanirtag mana tantyapäcunquitsu Tayta Diosnintsi cachamashganta? ");
INSERT INTO qvmNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gamcunaga manami rasunpatsu Tayta Diosman yäracärinqui. Tsaymi pay cachamashganta criyinayquipag milagruta ruranätarag munarcaycanqui. Munashgayquinöga manami milagruta rurashagtsu. Tsaypa trucanga Tayta Dios juc milagrutaragmi ruranga profëta Jonasta pescädupa pachancho caycashganpita yargatsimur milagruta rurashgannog.” Tsaynog nircurmi tsaypita Jesús aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Galilea lagünata tsimpaycashganchömi Jesuspa discïpuluncuna yarparcorgan mircapanpag tantata mana apashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tsaymi Jesús caynog nergan: “Fariseo y saduceo runacunapa levadüranta cuidädu chasquipäcunquiman.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsaynog niptin discïpuluncuna quiquinpura caynog nipäcorgan: “Tantata mana mircapacamushgantsipitami tsaynog niycämantsi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tsaynog parlaycashganta tantyarmi Jesús caynog nergan: “¡Yäracuyniynag runacuna! ¿Imanirtag parlarcaycanqui tantata mana apamushgayquipita? Manami tantapitatsu parlaycä. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manacu yarpapäcunqui pitsga tantalapita pitsga waranga (5,000) runacuna micapäcunanpag milagruta rurashgäta? ¿Manacu yarpapäcunqui putsog tantata tsay junag ayca canastata shuntapäcushgayquitapis? ");
INSERT INTO qvmNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tsaynogpis ¿manacu yarpapäcunqui ganchis tantalapita chuscu waranga (4,000) runacuna micapäcunanpag milagruta rurashgäta? ¿Manacu yarpapäcunqui putsog tantata tsay junag ayca canastata shuntapäcushgayquitapis? ");
INSERT INTO qvmNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tsaynog caycaptenga manami tantapitatsu parlaycä. Nogaga parlaycä fariseo y saduceo runacunapa levadüranpita cuidacärinayquipagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Levadüraman jitaycular tsaynog niptinmi discïpuluncuna tantyapäcorgan fariseucunapa y saduceucunapa yachatsicuyninta mana chasquipänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea de Filipos distrïtupa caseriuncunaman chayaycurmi discïpuluncunata Jesús taporgan caynog nir: “¿Pï cashgätatag nogapag runacuna yarpapäcun?” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsaynog tapuptin discïpuluncuna caynog nipäcorgan: “Waquin runacunaga nipäcun Juan Bautista cashgayquitami. Waquinnami nipäcun profëta Elías cashgayquita. Waquinnami nipäcun profëta Jeremías cashgayquita. Y waquinnami nipäcun maygan profëtapis cawarimushga cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsaynog niptin paycunata Jesús taporgan: “Gamcunaga ¿pï cashgätatag yarpapäcunqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsauraga Simón Pedro nergan: “Gamga Tayta Dios cachamushgan Cristumi canqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsauraga Jesús caynog nergan: “Alitami nishcanqui, Jonaspa tsurin Simón. Tsaynog ninayquipäga manami runatsu tantyatsishushcanqui, sinöga jana patsacho caycag Taytämi. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gamta në Pedro cashgayquita. Cay rumi jananchömi iglesiäta sharcatsishag. Tsay iglesiataga Satanaspis ni demoniucunapis manami vincengatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gamta goycushayqui gloria puncupa llävinpa wawancunata. Tsaymi cay patsacho lläviptiqui gloriachöpis llävishga canga. Cay patsacho quichaptiquega gloriachöpis quichashgami canga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tsaynog nircushpanmi discïpuluncunata Jesús caynog nergan: “Gamcuna pitapis ama wilapanquitsu Tayta Diosnintsi cachamushgan Cristo cashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tsaypitanami discïpuluncunata Jesús wilapargan Jerusalenman aywaptin Israel mayor runacuna, mandag cüracuna y Moisés escribishganta yachatsegcuna contran sharcur nacatsinanpag cashganta. Tsaynoglami wilapargan wanutsiptinpis quimsa junagta cawarimunanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsaynog niptinmi juc läduman gayaycur Pedro olgöpar caynog nergan: “Tayta Dios cachamushgan Cristo caycarga ¿imanirtag tsaynog parlaycanqui? Tsaynog pasashunayquitaga ama cachapaytsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tsaynog niptinmi Jesús tantyargan Pedro tsaynog parlananpag Satanás yarpayta goshganta. Tsaymi Pedruta Jesús caynog nergan: “¡Naupäpita witicuy, Satanás! Tsaynog michämashpayquega manami munanquitsu Tayta Diosnintsi munashganta ruranäta, sinöga yarpashgayquinogla cananta munarmi tsapata churapaycämanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nircur discïpuluncunata Jesús caynog nergan: “Pipis discïpulö cayta munarga shongun yarpashgannog jutsata rurar ama cawatsuntsu. Tsaypa trucanga imanog nacarpis noga munashgänogla imaypis cawatsun. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Noga munashgänog cawananpa trucan quiquin munashgannog cawagcunaga infiernuman gaycushgami cangapag. Ima nacaycho carpis noga munashgänog cawagcunami itsanga gloriaman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Infiernuman gaycushga cananpag caycaptenga ¿imapagtag välin mayjina rïcu cashganpis? Mayjina rïcu carpis manami rïcu cashgalanwanga salvacionta rantengatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Angilnëcunawan y Taytäpa munayninwan noga cutimurmi runacuna alita rurashganpita premiuta goshag y mana alita rurashganpita juzgashagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Manaragpis wanurmi waquinniqui nogata ricamanquipag lapanpagpis munayniyog cashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tsaypita sogta junagtami Pedruta, Santiaguta y Santiagupa wauguin Juanta pushacurcur Jesús witsargan chunyag jircaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tsaychömi paycuna ricaycaptin Jesuspa cäran intinograg chip-chipyargan. Röpanpis pasaypa yorag ricacur empañayparag atsicyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tsaychömi ricapäcorgan Moisés y Elías yuriparcur Jesuswan parlaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsaymi Jesusta Pedro nergan: “Alipagmi nogacuna cayman shapäcamushcä, tayta. Cananga rurapäcushag quimsa tsuclata: jucta gampag, jucta Moisespag y jucta Eliaspag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsaynog Pedro parlapaycaptinmi chip-chipyaycag pucutay paycunata tsapacurcorgan. Tsaymi pucutay rurinpita Tayta Dios caynog nimorgan: “Payga cuyay tsurëmi. Munashgänog cawaptinmi noga cushishga caycä. ¡Pay nishushgayquicunata cäsucäriy!” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsaynog nimogta mayaycurmi discïpuluncunaga pasaypa mantsacashpan pampaman lätacuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsaynog lätaraycaptinmi paycunata yataycur Jesús caynog nergan: “Ama mantsacäriytsu. Sharcapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tsaynog niptin ricärinanpagmi Jesús japalanna caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jircapita cutimurmi paycunata Jesús caynog nergan: “Jircacho ricashgayquita pitapis ama wilapanquiragtsu wanushgäpita noga cawarimunäyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsaypitanami discïpuluncuna Jesusta taporgan caynog nir: “Moisés escribishgan leycunata yachatsegcuna nipäcun Cristo shamunanpag puntata Eliasrag shamunanpag cashgantami. Tsaynog niycaptenga ¿imanirtag Elías mana shamunragtsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Tsaynog niptinmi Jesús caynog nergan: “Elías yapay shamunanpag cashganta nipäcushgannoglami Elías mayna shamushga. Elías shamur wilacuptinpis manami runacuna chasquicushgatsu wilacushganta. Chasquicunanpa trucanga payta chiquirmi wanutsipäcushga. Tsaynoglami runacuna nogatapis chiquimar wanutsimangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesús tsaynog niptin discïpulucuna tantyapäcorgan Juan Bautistapag parlaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jircapita cutimurmi runacuna juntacashga caycashganman Jesús chayargan. Tsaychömi Jesuspa naupanman gongurpacuycur juc runa ruwacur caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tsurëta aliyaycatsilay, tayta. Payta wanuy gueshya tsariptinmi ninamanpis yacumanpis tunin. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Discïpuluyquicunaman apamuptëpis manami aliyätsiyta camäpacushgatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tsaynog niptin Jesús caynog nergan: “¡Yäracuyniynag jutsasapa runacuna! ¿Imayyagrag gamcunawan caycäshag? Mä apamuy tsay mözuta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naupanman apaycuptinmi tsay mözuta nacaycätseg demoniuta Jesús olgöpargan. Olgöpaycuptinmi demonioga jinan höra mözupita yargurir aywacorgan. Tsay hörapitanami mözu sänuna ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsaypitanami quiquilancuna caycar discïpuluncuna Jesusta taporgan caynog nir: “¿Imanirtag nogacuna garguyta mana camäpacushcätsu tsay demoniuta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tsaymi paycunata Jesús caynog nergan: “Janan shongula Tayta Diosman yäracurmi gamcunaga garguyta mana camäpacushcanquitsu. Ñäpushpa murunnog tacshalapis yäracuyniqui captenga manami imapis sasatsu gamcunapag canga. Tagay jircata witicunanpag niptiquipis witicunmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tsaynog captinpis caynog cag demoniucunaga yargun ayunashpantsi Tayta Diosta manacuptintsiragmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea provinciacho discïpuluncunawan purirmi Jesús caynog nergan: “Juc runami nogata entregamanga conträcunapa maquinman. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tsaynog captinpis wanutsimashganpita quimsa junagtami cawarimushagpag.” Tsaynog niptinmi discïpuluncuna fiyupa laquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tsaypitanami Capernaumman discïpuluncunawan Jesús chayargan. Tsaychömi templupag impuesto cobragcuna Pedruta taporgan caynog nir: “¿Jesusga manacu pägan templunpag impuestuta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tsaynog tapuptinmi Pedroga caynog nergan: “Au, päganmi.” Tsaynog nishpanmi Jesús caycashgan cag wayiman aywargan tapunanpag. Manarag tapuptinmi Jesús caynog nergan: “¿Imaninquitag Simón? Nación mandag reycuna ¿pitatag impuestuta cobran? ¿Tsurincunatacu o munaynincho caycag jäpa runacunatacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tsaynog tapuptinmi Pedro caynog nergan: “Munaynincho cag jäpa runacunatami impuestutaga cobran, tayta.” Tsaynog niptin Jesús nergan: “Tsauraga nación mandagpa tsurin impuestuta mana pägashgannogmi nogapis, Tayta Diospa tsurin car, templunpag impuestuta mana pägämantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tsaynog captinpis cobragcuna mana rabiacunanpag lagünaman aywar ansuëlayquiwan pescäduta tsarimuy. Punta cag pescäduta tsarimushgayquipa shiminchömi guellay caycangapag. Tsay guellaywan nogapita y gampitapis impuestuta pägaycuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Juc cutimi discïpuluncuna Jesusta taporgan caynog nir: “Lapanpis munayniquichöna captin ¿mayganëtatag churamanqui más mandag canäpag, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsaynog tapuptinmi juc wamrata naupanman Jesús gayargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nircurmi discïpuluncunata caynog nergan: “Wamracuna mandag cananpag mana yarpachacushgannog gamcunapis ama yarpachacuytsu mandag canalayquipäga. Mandag canalayquipag yarpachacorga Tayta Diospa naupanman manami chayanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yanapäcog canayquipag yarpachacuptiquega Tayta Diospa naupancho mandag canayquipagmi churashayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tsaynogla mayganiquipis cay wamratanog mana cäsushga cagcunata chasquicorga nogata chasquicamagnogmi carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tayta Diosman yäracogta cuidädu pitapis jutsaman tunitsinquiman. Jutsaman tunitsicogcunataga más alimi canman mulïnu rumita cuncanman wataparcur lamarman garpuriptinpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tsaynog captinpis jutsaman tunitsicogcuna imaypis cangami. ¡Paycunaga juicio final junag pasaypami laquicongapag! ");
INSERT INTO qvmNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Tsaynog cananpag caycaptenga maquiqui o chaquiqui jutsata ruratsishuptiqui cutsurir jitariycuy. Imaypis mana upeg ninaman ishcan chaquiyog o ishcan maquiyog gaycushga canayquipa trucanga más alimi canman juc chaquiyoglapis o juc maquiyoglapis Tayta Diosnintsipa naupanman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tsaynogla nawiquipis jutsata ruratsishuptiquega ogtirir jitariycuy. Ishcan nawiyog infiernuman gaycushga canayquipa trucanga más alimi canman wiscu nawilapis Tayta Diosnintsipa naupanman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tayta Diospa naupancho caycag angilcunami payman yäracogcunata imay hörapis ricaycan. Tsaynog caycaptenga payman yäracogcunata manacagman ama churapäcuytsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Runacuna jutsata rurashganpita salvanäpagmi Tayta Diosnintsi cachamashga. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pipis pachac (100) uyshanpita jucta ograycorga ¿manacu waquin cagta juc patsaman aylurcur jucla aywan ashimunanpag? ");
INSERT INTO qvmNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tariycorga pasaypami cushicun. Manami tsaynöga cushicuntsu mana ogracag uyshancunapäga. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tsaynoglami jana patsacho caycag Tayta Diosnintsi mana munantsu payman yäracogcuna ni juclaylapis ogracänanta. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tayta Diosman yäracog mayiqui manacagta jitapäshushpayqui contrayqui sharcuptin, perjuiciuta rurashuptiqui, lulapäshuptiqui puntata japalanwan parlanqui tantyatsinayquipag. Tantyatsiptiqui chasquicuptenga perdonanqui. Tsaynog perdonarga alitami ruraycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tantyatsiptiquipis mana chasquishuptiquega ishcay o quimsa yäracog mayiquita pushanqui jutsata ruraycashganta tantyatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Paycunatapis mana cäsucuptenga lapan yäracog mayiquicuna juntacashganman pushaycur tantyatsipäcunqui jutsata ruraycashganta. Tsaychöpis mana cäsucuptenga gampis y lapan yäracog mayiquicunapis paywan amana juntacaynatsu. Payga jutsasapanog y runacuna chiquishgan impuesto cobrag runanogmi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tsaynog mana cäsucogcunata corriginayquipag munayniyogmi gamcuna caycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yapaypis gamcunata në: Juc ishcayla carpis Tayta Diosta manacuptiquega paymi yanapashunqui munashganta ruranayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Juc ishcayla carpis Diosta manacunayquipag nogapa jutëcho juntacaptiquega gamcunawanmi caycäshag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsaynog yachatsiptinmi Pedro taporgan caynog nir: “Pipis rabianätsimaptenga ¿ayca cutitag perdonäman, tayta? ¿Ganchis cutitsurag?” ");
INSERT INTO qvmNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tsaynog tapuptinmi Jesús caynog nergan: “Manami ganchis cutilatsu perdonanquiman, sinöga perdonta manacushuptiquega ayca cutipis perdonanqui. Tsaynogla ayca cuti rabianätsishuptiquipis ama yarparaycanquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tsaypitanami Jesús caynog nergan: “Juc nación mandag runapashi cargan atsca yanapagnin runacuna. Tsay yanapagnincunatashi tsay mandag nergan cuentata gonanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Tsaynog cuentata manaptinshi jagan runata apargan. Tsay runaga yupaytapis mana atipaypagshi tsay mandagpa jagan cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jaganta pägananpag mana aypäpacuptinshi ashmaynincunata tsay mandag caynog nergan: ‘Cay runata, warminta, tsurincunata y imaycancunatapis ranticäriy. Ranticurcurna guellayta apamunqui jagäpita.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tsaynog niptinshi tsay runaga gongurpacuycur ruwacorgan caynog nir: ‘Tayta, ama ari ranticaycamaytsu. Imanogpapis jagayquitaga pägashayquichari.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tsaynog ruwacuptinshi tsay mandag cuyapashpan lapan jaganta perdonar manana ranticorgannatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tsaynog perdonarcuptin aywacuycashganchöshi tsay runa tincorgan juc arog mayinwan. Tsay arog mayenga pachac (100) denariushi jagan cargan tsay aywaycag runapa. Tsayshi aywaycag runaga cuncapita aptacurcorgan: ‘¡Jagäta pägamay!’ nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsaynog ruraptinshi arog mayenga gongurpacuycur ruwacorgan caynog nir: ‘Jagayquitaga pägaläshayquichari, tayta. Ichiclata shuyaycalämay, ari.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tsaynog ruwacuptinpis manashi arog mayinta perdonayta munargantsu. Tsaypa trucanga carcilmanshi wichgatsergan hasta jaganta pägananyag. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Tsaynog rurashganta ricaycurshi waquin arog mayincunaga pasaypa rabianargan. Tsayshi mandagman aywar wilapäcorgan tsay perdonashgan runa arog mayinta carcilman wichgatsishganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tsayshi tsay perdonashgan runata gayaycatsir tsay mandag caynog nergan: ‘¡Mana cuyapäcog runa! ¿Manacu yarpanqui tsayjinanpa jagä captiquipis ruwacamaptiqui lapanta perdonashgäta? ");
INSERT INTO qvmNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tsaynog perdonaycaptëga ¿imanirtag gamga arog mayiquita mana perdonashcanquitsu?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsaynog fiyupa rabiacurshi tsay mandag carcilman quiquintapis wichgatsergan. Tsaychömi wardia castigargan hasta tsay mandagpa jaganta pägananyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tsaynog wilaparcurmi Jesús caynog nergan: “Runa mayiquicunata lapan shonguyquiwan mana perdonaptiquega gamcunatapis Tayta Diosnintsi manami perdonashunquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tsaynog yacharcatsirmi Galilea provinciapita aywar Jordán mayupa wac tsimpanpa Jesús tumargan Judea provinciaman chayananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsay quinranpa puriptin atsca runacunami guepanta aywargan. Tsaychömi gueshyagcunatapis Jesús aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tsaymanmi fariseo runacuna aywaycur lutanta rimatsinan cashga ali shimilanpa Jesusta tapupäcorgan caynog nir: “¿Ima achäquilapis warminpita runa raquicanmancu o manacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tsaynog tapuptinmi Jesús caynog nergan: “¿Manacu gamcuna liyishcanqui Tayta Diosnintsipa palabranta? Tsaycho niycan olguta warmita Tayta Dios camashgantami. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tsaynog camarcurmi Tayta Dios caynog nergan: ‘Tsaynog captinmi warmita ashir runa promitin mana raquicaypa tänanpag. Tsaymi majatsacarna mamanpa y taytanpa maquincho caycashganpita runa yargucun warminwan tänanpag. Warminwan tarnami jäpa jäpa carpis paywan tsay castalana ricacun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsaynog cananpag Tayta Dios niycaptenga mananami ishcay castanatsu caycan, sinöga juc castalanami caycan. Tsaymi Tayta Diosnintsi juclatsashgantaga pipis mana raquinmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsaynog niptinmi fariseo runacuna taporgan caynog nir: “Tsauraga ¿imanirtag Moisés escribishgancho niycan raquicar papilta firmaparcuptin warmi aywacunanpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tsaynog tapuptinmi Jesús caynog nergan: “Tayta Diosnintsega runata warmita camargan majatsacarnaga mana raquicaypa tänanpagmi. Tsaynog captinpis runacuna mana cäsucog captinmi Moisesta Tayta Dios tantyatsergan tsaynog escribinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tsaynog captinpis nogaga caynogmi në: Maygan runapis warmin mana jarucuycaptin warminpita raquicarcur juc warmiwan targa adulterio jutsatami ruraycan. Tsaynogpis runanpita raquicashga cag warmiwan pipis targa adulterio jutsatami ruraycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tsauraga discïpuluncuna caynog nergan: “Tsaynog captenga mejor warmitapis ama ashishwantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tsaynog niptin Jesús nergan: “Tsaynog niptiquipis manami lapantsu majaynag cawayta camäpacun. Waquilanmi majaynag täcunanpag caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquin runacunaga yurishga majaynagla täcunanpagmi. Waquincunaga capashga carmi majatsacaytapis mana munannatsu. Waquinnami itsanga Tayta Diosnintsipa wilacuyninta wilacur puricunan cashga mana majatsacaylapa täcun. Pipis mana majatsacaylapa täcuyta munarga japala täcutsun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsaypitanami wamracunata Jesús cagman apapäcorgan umanman maquinta churaycur Tayta Diosta manacunanpag. Wamracunata apaycagta ricarmi discïpuluncuna michargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tsaymi discïpuluncunata Jesús caynog nergan: “Wamracunata apacamunanta ama michäpäcuytsu. Wamranog cagcunami Tayta Diospa naupanman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tsaynog nircushpanmi wamracunapa umanta yataycushpan Tayta Diosta manacorgan. Nircurnami tsaypita aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juc cutichömi juc mözu Jesusman aywaycur caynog nergan: “Gam imaycatapis musyanquimi, tayta. Tsaymi tapuculäshayqui. ¿Imatatag ruräman Tayta Diospa naupanman chayanäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tsauraga Jesús caynog nergan: “Tayta Diosnilantsimi lapantapis musyaycan. Tsaymi mayna nimashcantsi mandamientuncunata cumplir naupanman chayanantsipag cashganta. Tsayta musyaycarga ¿imanirtag tapumanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tsaynog niptin tsay mözu taporgan: “¿Maygan mandamientucunatatag cumplëman, tayta?” Tsaymi Jesús nergan: “Runa mayiquita ama wanutsinquitsu. Adulterio jutsata ama ruranquitsu. Ama suwacunquitsu. Manacagtaga ama pitapis tumpanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mamayquita y taytayquita ali ricanqui. Tsaynogpis runa mayiquita lapan shonguyquiwan cuyanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tsauraga mözu caynog nergan: “Tsaycunataga wamra cashgäpitami lapanta cumplishcä, tayta. ¿Imatag más pishiycäman cumplinäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Niptin Jesús caynog nergan: “Lapanta cumpliycarpis Tayta Diospa naupanman chayanayquipäga lapan imayquicunatapis ranticuycur guellayta wactsacunata aypuy. Tsaynog rurashpayquega gloriaman riquëzayquita churacognogmi caycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsaynog niptinmi pasaypa rïcu car tsay mözu laquishga aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mözu tsaynog aywacuptinmi discïpuluncunata Jesús caynog nergan: “¡Sasami caycan rïcu runacuna Tayta Diospa naupanman chayananpäga! ");
INSERT INTO qvmNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Auja uchcupa camëllo päsayta mana camäpacushgannog rïcu runapis quiquilanpitaga Tayta Diospa naupanman chayayta manami camäpacuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsayta mayar discïpuluncuna pasaypa mantsacashga caynog nipäcorgan: “Tsaynog captenga ¿pirag salvacongapag?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tsaymi paycunata ricärishpan Jesús caynog nergan: “Quiquilanpitaga runacuna manami salvacuyta camäpacuntsu. Tayta Dioslami pitapis salvan. Tsaymi Tayta Diosnintsipäga imapis mana sasatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsauraga Pedro caynog nergan: “Nogacunaga lapantami imaycätapis cacharishcä gamwan purinäpag, tayta. Tsauraga ¿imatag canga nogacunapäga?” ");
INSERT INTO qvmNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tsaynog niptinmi Jesús nergan: “Juicio final junag lapan runacunata noga juzgaptëmi chunca ishcay (12) trönucunacho jamacärinquipag. Tsaychömi gamcunapis chunca ishcay castapita mirag Israel mayintsicunata juzganquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Noga munashgäta ruranan cashga pipis wayinta, wauguincunata, panincunata, mamanta, taytanta, tsurincunata y chacrancunatapis cachareg cäga pachac (100) cuti mastami chasquengapag. Tsaynogpis wanucur Tayta Diospa naupancho imayyagpis cushishgami cawangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Waquin runacuna, rïcu cashganpita respitädu carpis, gloriaman manami chayangatsu. Waquin runacunami itsanga, mana cäsushga wactsa carpis, gloriaman chayar cushicongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tsaypitami Jesús caynog nergan: “Tayta Diospa maquincho cawagcuna imanog cananpag cashganpitapis canan tantyatsishayqui. Juc runashi tuta tutala mincay asheg aywargan üva chacrancho arutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mincayta tariycur aycata pägananpagpis parlarcurshi üva chacrancho arunanpag cachargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tsaypita las nuëvimannog pläzapa yapay yargurshi runacunata tarergan aruyniynag purircaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tsayshi nergan: ‘Gamcunapis üva chacrächo arunayquipag aywayculay. Arushgayqui-tupuymi pägaläshayqui.’ Tsaynog niptin paycunapis cushishga aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Pulan junag caycaptinpis y tardi malway inti caycaptinpis tsay chacrayog runaga yapay mincay asheg aywargan. Tsayshi tarishgan runacunatapis mincacorgan chacranman arog aywananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Tsaypita inti jegaycaptinnashi yapay pläzaman aywar runacunata tarergan aruyniynag caycagta. Tsayshi paycunatapis caynog nergan: ‘Gamcunapaga ¿manacu aruyniqui can caycho goyaylata puricunayquipag?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Tsaynog niptinshi paycuna caynog nipäcorgan: ‘Manami pipis mincacamashgatsu arupänäpag, tayta.’ “Tsaymi nergan: ‘Tsauraga gamcunapis aywayculay chacrächo arupämänayquipag. Arupämashgayquipita pägashayquipagmi.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Patsa tsacaycaptinnashi tsay duëño capatazninta nergan: ‘Lapan arogcunata gayaycatsimur pägay guepata arog yaycogcunapita galaycur tutapita yaycogcunayag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tsaynog gayatsimuptinshi shapäcamorgan inti jegaycaptin arog yaycogcuna. Paycunashi chasquergan juc jornal complëtu päguta. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsaynog chasquishganta ricarshi tutapita arogcunaga shapäcamorgan más atscata chasquinanpag cashganta yarpar. Tsaynog yarparpis juc jornal complëtulatashi chasquipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Waquin chasquishgannogla chasquirshi puntata yaycogcunaga chacrayogta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Último yaycamogcuna juc hörala arurcaycaptenga ¿imanirtag nogacunataga tsayjina shanaycho arurcaycaptëpis paycunata pägashgayquinogla pägaycämanqui?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tsaynog nipäcuptinmi chacrayog runa caynog nergan: ‘Parlashgantsinogla pägaycarga manami gamcunata engañaycätsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Parlashgantsinog päguta chasquiycarga ¿imatanatag más munanqui? Nogapitanachari cacun guepa yaycamogcunatapis gamcunatanogla pägaptëga. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gamcunaga ¿ima cuentayogtag canqui aycata pägacuptëpis? ¿Ali runa cashgäpitacu jamurpämanqui?’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tsaynog wilaparcurmi Jesús caynog nergan: “Tsay arupacuyman punta yaycogwan guepa yaycogpis iwal päguta chasquishgannogmi Diospa wilacuyninta más puntata chasquicogcuna y guepatarag chasquicogcunapis gloriaman chayangapag. Salvananpag atscagta Tayta Diosnintsi gayatsiptinpis walcaglami naupanman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalenman aywarcaycashganchömi chunca ishcay (12) acrashgan discïpuluncunata juc läduman gayaycur Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Musyapäcunquimi Jerusalenpa aywaycashgantsita. Tsaychömi mandag cüracuna y Moisés escribishganta yachatsegcunapis nogata prësu tsaripäcamanga. Nircurmi wanutsimänanpag mana Israel runacunapa maquinman entregapäcamanga. Paycunanami asipämanga, astamanga y crucificamangapis. Tsaynog captinpis quimsa junagtaga cawarimushagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsaypitami Santiaguta y Juanta pushacurcur maman aywargan Jesús cagman. Paymi Jesuspa naupanman gongurpacuycur caynog nergan: “Ruwaculäshayqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsaynog niptin Jesús nergan: “Captenga alichari canman.” Tsauraga tsay warmi ruwacur caynog nergan: “Mandag canayquipag Tayta Diosnintsi churashuptiqui cay ishcay wawäcunata churayculanqui gamta mandäshishunayquipag, tayta. Jucta derëchayqui cagman y jucagtana itsogniqui cagman jamaycatsilanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tsauraga mamanta, Santiaguta y Juanta Jesús caynog nergan: “Gamcunaga manami musyanquitsu imata manacamashgayquitapis. ¿Gamcuna awantapäcunquimantsurag nogata nacatsimashgannog nacatsipäcushuptiqui?” Tsauraga paycuna nipäcorgan: “Au, awantapäcushagmi, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tsaynog niptin Jesús nergan: “Rasunpami noga nacashgänog gamcunapis nacapäcunquipag. Tsaynog captinpis itsognëman y derëchämanga pitapis jamatsishag Tayta Dios nimashgan caglatami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Santiagupa y Juanpa maman ruwacushganta mayarmi waquin cag discïpuluncuna fiyupa rabiacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tsauraga discïpuluncunata gayaycur Jesús caynog nergan: “Gamcuna musyapäcushgayquinogpis nación mandag runacunaga mandag cayninman atiënicuycur runacunata mandan. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Gamcunachöga manami tsaynog canmantsu. Tsaypa trucanga waquin runacunapita más ali ricashga cayta munarga runa mayiquita ashmaynogla yanapay. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Manami runacunata munashgäta ruratsinäpagtsu noga shamushcä, sinöga runacunata yanapanäpagmi shamushcä. Tsaynogpis shamushcä runacuna-raycu wanur salvanäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó marcapita Jesús aywacuptinmi atsca runa payta gatirargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tsay caminuchömi ishcay gapra runacuna jamarpaycargan. Paycunami Jesús pasaycagta mayar gayacorgan caynog nir: “¡Rey Davidpa castan Jesús, nogacunata cuyapaycalämay!” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tsaynog gayacuptinmi runacuna olgöpargan upälacärinanpag. Tsaynog olgöpaptinpis masragmi gayacorgan caynog nir: “¡Rey Davidpa castan Jesús, nogacunata cuyapaycalämay, ari!” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tsaynog gayacushganta mayarmi Jesusga ichicuycorgan. Nircurnami gayaycur taporgan caynog nir: “¿Imacho yanapanätatag munaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Niptin paycuna caynog nipäcorgan: “Nawëcunata aliyaycatsilämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tsaynog manacuptinmi paycunata cuyapar nawincunata yataycorgan. Tsaynog yataycuptinmi jinan höra nawin aliyargan. Tsaymi paycunapis Jesusta gaticurcur aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tsaypitanami discïpuluncunawan Jesús aywargan Jerusalenman. Olivos lömacho caycag Betfagé marcaman chayananpagna caycar ishcay discïpuluncunata puntata cachargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Aywapäcuy Betfagé marcaman. Marca yaycunalanchömi taripäcunqui manta wawayog bürru wataraycagta. Tsayta pascarir apamunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pipis: ‘¿Imapagtag bürröta pascaycanqui?’ nishuptiquega nipäcunqui: ‘Señor Jesusmi nistaycan muntacunanpag. Más tsicalami cutiratsimushag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tsaynog cananpagmi Tayta Diosnintsipa profëtan escribergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén marcacho tag runacuna, ricapäcuy mandagniqui rey aywaycämogta. Payga humildi runanoglami manta bürrun muntashga aywaycämun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús nishgannoglami discïpuluncunaga aywar manta bürruta apamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mamantinta apaycur punchuncunata tsay manta bürruta carunaparcuptinmi Jesús muntacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tsaynog aywaptinmi atsca runacuna marcapita aywargan Jesusta chasquicog. Tsaymi waquincuna jacuncunata y punchuncunata jorgurir Jesús aywashgan caminuman mashtapäcorgan. Waquinnami palmata muturir muturir caminuman mashtapäcorgan payta cushishga chasquicushpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tsaymi puntanta aywagcuna y guepanta aywagcunapis cushicushpan caynog nipäcorgan: “¡Tayta Diosnintsi cachamushgan mandamagnintsi caychönami caycan! ¡Paymi David castapita mandamagnintsi rey caycan! ¡Tayta Diosnintsi imayyagpis alabashga cayculätsun!” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalenman Jesús tsaynog yaycuptinmi runacuna yargapäcamorgan payta ricananpag. Tsaymi jucnin jucninpis tapunacärergan: “¿Pitag yaycaycämun?” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tsauraga runacuna nipäcorgan: “Payga caycan Galileacho caycag Nazaret marcapita shamog Jesusmi. Payga Tayta Diosnintsipa profëtanmi caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Templo patiuman yaycurirmi tsaypita Jesús gargorgan ranticuycagcunata y rantipacuycagcunatapis. Tsaynoglami guellay ranticogcunapa mësantapis y paloma ranticogcunapa mësantapis ticrar ushargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gargurmi paycunata caynog nergan: “Tayta Diosnintsipa palabranchöga caynogmi escribiraycan: ‘Templöga canga nogata manacamänanpagmi.’ Tsaynog escribiraycaptenga ¿imanirtag gamcuna ticratsishcanqui suwacunapa machayninmannog?” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsaychömi gapracuna y wegrucunapis Jesuspa naupanman aywapäcorgan. Paycunataga lapantami aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsaynog aliyaycätsegta ricaycurmi mandag cüracuna y Moisés escribishganta yachatseg runacunapis pasaypa rabiacärergan. Tsaynoglami rabiacärergan wamracunatapis caynog negta mayar: “¡Mandamänantsipag rey Davidpa castan chämushganami! ¡Gloria Dios!” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tsaynog rabiacurmi Jesusta caynog nergan: “¿Mayanquicu tsay wamracuna niycashganta?” Tsaymi Jesús caynog nergan: “Au, mayämi. ¿Manacu gamcuna liyishcanqui caynog escribiraycashganta: ‘Gamta alabashunayquipag wasguishga wamracunata y chuchuycag wamracunatami tantyatsishcanqui, Tayta Dios’?” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Paycunata tsaynog nircurmi Betania marcaman cutergan tsaycho posädacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wara tuta Jerusalenman Jesús cutiycarmi micanargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsaymi hïgus yörata ricaycur aywargan wayuyninta ashinanpag. Wayuyninta ashir manami juclaylatapis tarergantsu. Rapralanta tariycurmi caynog nergan: “¡Cananpitaga manami imaypis wayunquipagnatsu!” Tsaynog niptin jinan hörami tsay hïgus yöra tsaquicäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tsayta ricaycurmi discïpuluncuna Jesusta tapupäcorgan caynog nir: “¿Imanogpatag tsay hïgus yöra rasla tsaquishga?” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tsauraga Jesús caynog nergan: “Lapan shonguyquiwan Tayta Diosman yäracorga cay hïgus yörata tsaquitsishgänoglami gamcunapis mana criyiypag cag milagrucunata ruranquipag. Tagay jircata witicunanpag niptiquipis witicongami. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lapan shonguyquiwan yäracur imatapis Tayta Diosta manacorga manacushgayquita chasquinquipagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tsaypita Jerusalenman cutirmi templo patiuman Jesús yaycorgan. Tsaycho yachaycätsiptinmi mandag cüracuna y Israel mayor runacuna Jesusta caynog taporgan: “Gamga ¿ima munayniquiwantag templo patiucho ranticogcunata gargushcanqui? ¿Pitag nishushcanqui tsaynog gargunayquipag?” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Tsaynog nipäcuptinmi paycunatapis Jesús caynog taporgan: “Gamcunatapis canan tapushayqui. ¿Pitag Juanta cachamorgan bautizananpag? ¿Tayta Diosnintsicu o runacunacu? Tapushgäta nipäcamaptiquega nogapis wilashayquimi pipa munayninwan templo patiupita gargushgätapis.” Tsauraga quiquinpura caynog wilanacärergan: “Ama nishuntsu Tayta Diosnintsi cachamushganta. ‘Tayta Diosnintsimi cachamushga’ niptintsega: ‘¿Imanirtag mana criyipäcorgayquitsu?’ nimäshunmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tsaynogpis ama nishuntsu runacuna cachamushganta. Tsaynog niptintsega sagmaycälarmi runacuna wanutsimäshun. Lapanmi yarpapäcun Juanga Tayta Diosnintsipa profëtan cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsaynog wilanacurcurmi paycuna caynog nipäcorgan: “Manami musyapäcötsu pï cachamushgantapis.” Tsaynog nipäcuptinmi Jesús caynog nergan: “Gamcuna mana wilamaptiquega nogapis manami wilashayquitsu pipa munayninwan templo patiupita ranticogcunata gargushgätapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tsaypitana Jesús caynog nergan: “Juc runapashi ishcay tsurincuna cargan. Tsayshi mayor cag tsurinta caynog nergan: ‘Hïjo, canan junag arupaycalämay.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tsaynog ruwacuptin tsurin caynog nergan: ‘¡Manami tiempö cantsu yanapanäpag!’ Tsaynog nircurpis yarpachacurerga taytanta yanapag aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mayor tsurin cagta mincacushgannoglashi shulca cag tsurintapis mincacorgan. Tsayshi tsay tsurenga: ‘Yanapashayqui ari, papá’ nergan. Tsaynog aunircurpis manashi arösheg aywargantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tsaynog wilaparcurmi mandag cüracunata y autoridäcunatapis Jesús taporgan: “Tsay ishcan wauguipita ¿maygantag taytan munashganta rurashga?” Tsaynog niptin: “Mayor cag tsurinmi” nipäcorgan. Tsauraga Jesús caynog nergan: “Tsay mayor cag tsurin ñëgarcurpis yanapashgannogmi Romapag impuesto cobragcuna y jutsa rurag warmicunapis carcaycan. Jutsancunata cacharir Tayta Dios munashgannog cawashpanmi paypa naupanman chayangapag. Gamcunami itsanga Tayta Diosta mana cäsucur naupanman mana chayanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautistaga yachatsergan jutsa ruraycunata cacharir Tayta Dios munashgannog cawapäcunanpagmi. Tsaynog wilacuycaptinpis gamcunaga manami chasquicushcanquitsu. Runacuna chiquishgan impuesto cobragcuna y jutsa rurag warmicunami itsanga pay wilacushganta chasquicärishga. Paycuna chasquicärishganta ricaycarpis gamcunaga imaypis manami chasquicärishcanquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mastapis Jesús tincutsiypa yachatsergan caynog nir: “Juc runashi juc chacra üvata plantargan. Nircurnashi uywacuna mana yaycunanpag guenchatsergan. Tsaypitanashi üva jarucuna pözutapis jinan chacracho ruratsergan. Nircurnashi tsuclatapis ruratsergan üvata täpananpag. Lapanta ruraycatsirnashi chacra arog runacunata arrendacuycur juc lädu marcapa aywacorgan tsaycho tänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Tsauraga cosëcha galaycuptinnashi cachargan ashmaynincunata üva chacra arrindunpita cobramunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cobracog chayaptinshi chacra arrendagcunaga tsay ashmaycunata waquinta magapäcorgan, waquinta wanutsergan y waquintanashi sagmar ushapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsaynog ruraptinpis chacrayöga yapayshi waquin ashmaynincunata cachargan. Paycunatapis tsaynoglashi rurapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ultimutaga cuyay tsurintanashi cachargan: ‘Tsurëtaga chasquicärengami’ nir. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tsayshi tsay tsurin chayaycagta ricaycur chacra arrendagcuna wilanacärergan caynog nir: ‘Tagaymi cay chacrawan quëdananpag caycan. Nogantsina cay chacrawan quëdacunantsipag payta wanuratsishun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsayshi chayaycuptin üva chacrapita juc läduman jorgurir wilanacushgannogla wanutsipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Tsaynog rurashganpita tsay üva chacrayöga ¿imatatag ruranga tsay chacrata guechuyta munag runacunata?” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesús tsaynog tapuptinmi paycuna nipäcorgan: “Tsay mana ali runacunataga mana cuyapaypami wanutsenga. Nircurmi tiempulancho chacra arrindupita pägag cagtana chacranta arrendacuycongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Tsaynog niptinmi Jesús caynog nergan: “Tsay chacra arrendag mana ali runacunata wanutsishgannogmi gamcunatapis Tayta Diosnintsi infiernuman gaycushunquipag. Pay munashgannog cawagcunatami itsanga salvangapag. Infiernuman gaycushunayquita mana munarga Tayta Diosnintsipa palabrancho caynog escribirashganta tantyacäriy: ‘Wayi sharcatsegcuna: “Manami alitsu cay rumi” nir jitariycuptinpis wayi esquïnaman cimientupag tsay rumi churashganami caycan. Cimientu cananpäga Tayta Diosnintsimi churashga. Tsaynog churashga captinmi cushicuypag caycan.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pipis tsay cimientu rumi jananman tuneg cäga ushacangami. Tsaynoglami pipa jananmanpis tsay rumi tunerga pasaypa ushacätsenga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsaynog tincutsiypa yachatsiptinmi mandag cüracuna y fariseo runacuna tantyapäcorgan tumatsipaylapa paycunata Jesús tsaynog niycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tsaymi rabianashpan prësu tsariyta munarpis mana camäpacorgantsu runacunata mantsacushpan. Lapan runacunami parlapäcog Jesusga Tayta Diosnintsipa profëtan cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tsaypitanami casaracuy fiestaman tincutsiypa Jesús yachatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Juc mandag reyshi olgu tsurin casaraptin fiestata rurargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tsayshi ashmaynincunata cachargan gayatsishgancunata fiestaman pushamunanpag. Tsauraga tsay gayatsishgan runacuna manashi mayganpis aywayta munargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tsaypita yapayshi waquin ashmaynincunatana cachargan caynog nir: ‘Töröcunata y wera cag wäcäcunatapis pishtarcatsir micuyta ruratsishgä listunami caycan. Gayatsishgäcuna jucla shamutsun tsurë casaraptin fiestacho canantsipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tsaynog gayatsiptinpis manashi mayganpis tsay fiestaman aywapäcorgantsu. Tsaypa trucanga chacran arogshi waquin aywacorgan. Waquinshi negociun ranticog aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquinnashi tsay reypa ashmaynincunata magaycashgalancho wanutsipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Tsayshi fiesta rurag reyga fiyupa rabiacur soldäduncunata cachargan ashmaynin wanutseg runacunata wanutsinanpag y marcantapis rupatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nircurshi ashmaynincunata nergan: ‘Tsurë casaraptin fiestata ruranäpag lapanpis camarishganami caycan. Tsaynog captinpis tsay gayatsishgä runacuna manacagman churamarmi mana shamushgatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cananga cällicunapa aywar tarishgayqui cag runacunata wilapäcuy camarishgantsi fiestaman shamunanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Tsaynog niptinshi ashmaynincuna yargur wilaptin ali runapis mana ali runapis fiestaman chayargan wayi juntagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tsauraga wayicho caycag runacunata ricananpag yaycur tsay rey ricargan juc runa casarag mözuta mana respitashpan trucacöni tsaycho caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsay respëtuynag runata ricaycurmi caynog taporgan: ‘Amïgo, trucacurcur shamunayquipag cashganta musyaycar ¿imanirtag mana trucacuylapa cayman shamushcanqui?’ Tsaynog tapuptinmi tsay runa pengacushpan imaniytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsauraga ashmaynincunata tsay rey nergan: ‘Tsurë casaraycaptin trucacöni shamur manacagman churashganpita chaquinta maquinta matwapäcuy. Nircurna yanauyaycag tsacayman jitarpuy. Tsaychömi fiyupa wagar quiruntapis uchongapag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsaynog wilaparcurmi Jesús caynog nergan: “Tayta Dios lapan runacunata gloriaman chayananpag gayatsiptinpis waquilanmi gloriaman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsaypita fariseo runacuna templupita yargurcur wilanacärergan ali shimilanpa Jesusta parlapar lutanta parlatsinanpag, nircur lutanta parlatsishgalanwanna acusapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tsaymi imata ninanpagpis shumag yacharcatsir fariseo runacuna cachargan discïpuluncunata y Herodispa favornin sharcog runacunata. Paycunami Jesusta caynog nergan: “Nogacuna musyapäcömi imata yachatsirpis Tayta Dios munashgannog shumag yachaycätsishgayquita, tayta. Tsaymi yachagtapis mana yachagtapis Diospa wilacuynin nishgannogla yachatsinqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gampa yarpayniquipitaga Romacho emperador Cesarpag impuestuta ¿pägashwancu o manacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lutanta parlatsiyta munar tsaynog tapushganta tantyarmi Jesús caynog nergan: “¡Ishcay cära runacuna! ¿Imanirtag lutanta parlatsimayta munapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä ricatsimay tsay impuesto päganayquipag cag guellayta.” Tsaynog niptinmi tsararashgan guellayta Jesusta aptapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tsayta ricaycur Jesús caynog taporgan: “Cay guellaycho ¿pï runapa reträtuntag caycan? Tsaynogpis ¿pipa jutintag escribiraycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tsaynog tapuptin nipäcorgan: “Emperador Cesarpami.” Tsaymi Jesús nergan: “Emperador Cesarpa cagta Cesarta goycuy. Tayta Diospa cagtaga Tayta Diosnintsita goycuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsaynog niptinmi tsay runacuna imaniytapis mana camäpacur aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tsay junaglami saduceo runacunapis Jesusman aywapäcorgan pay yachatsishganta manacagman churananpag. Tsaymi Jesusta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Moisés escribishgancho caynogmi niycan, tayta: ‘Warmiyog runa tsuriynag wanuptin shulca wauguin cuñädan viüdawan tätsun. Tsaynogpami wamrancuna tsay wanog cag runapa tsurinnogna canga.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tsaynog captenga tapucushayqui, tayta. Juc marcachöshi ganchis wauguicuna cargan. Mayor cagshi juc warmiwan targan. Tsayshi manarag tsurin captin wanorgan. Tsauraga shulca cag wauguinnashi targan tsay viüdawan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Paypis tsurin manarag captinshi wanorgan. Tsaypita más shulcan cagna targan tsay viüdawan. Paypis wanorgan tsurin manarag captinshi. Tsaynogla lapan wauguincuna tsay viüdawan targan. Tsuriynagla lapanpis wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsaypitanashi tsay viüdapis wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wanushcunata Tayta Diosnintsi cawaritsimunan junäga tsay warmilachi ganchis wauguipa warmin canga.” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tsaynog nipäcuptinmi Jesús caynog nergan: “Tsaynog nishpayquega gamcuna manami tantyapäcunquitsu Tayta Diospa palabrancho escribiraycashganta. Tsaynogpis manami tantyapäcunquitsu wanushcunata cawaritsimunanpag Tayta Dios munayniyog cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wanushganpita cawarimorga mananami pipis warmiyogtsu ni runayogtsu canga, sinöga gloriacho caycag angilcunanoglanami majaynagla cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wanushcuna cawarimunanpag cashgantaga ¿manacu liyipäcushcanqui Tayta Diospa palabrancho escribiraycashganta? Abraham, Isaac y Jacob wanushganpita atsca wata guepataragmi Tayta Diosnintsi Moisesta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ Wanogcuna mana cawarimunanpag captenga ¿imanogpatag Abrahampa, Isaacpa y Jacobpa Diosnin canman? Tsaynog caycaptenga ¿imanirtag gamcuna mana criyinquitsu wanogcuna cawarimunanpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tsaynog yachatsishganta mayaycur tsaycho caycag waquin runacuna pasaypa cushicärergan caynog nir: “¡Jesusga alimi yachatsimantsi!” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceo runacunata Jesús upälatsishganta musyaycurmi fariseo runacuna juntacaycur wilanacorgan imanogpapis Jesusta lutanta parlatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tsaynog wilanacurcurmi Moisés escribishganta yachatseg fariseo runa lutanta parlatsinan cashga ali shimilanpa Jesusta taporgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tayta, ¿maygan mandamientutatag más cäsucushwan?” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tsaynog tapuptinmi Jesús caynog nergan: “ ‘Shumag tantyacur lapan shonguyquiwan y lapan voluntäniquiwan Tayta Diosta cuyanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tsay mandamientumi lapan mandamientupitapis más cumplinantsipag caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tsaynoglami jucag mandamientupis caynog niycan: ‘Runa mayiquita lapan shonguyquiwan cuyanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cay ishcay mandamientuta cumplerga Moisés escribishgan lapan mandamientucunata y Diospa profëtancuna escribishgan mandamientucunatapis cumpliycanquimi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsaypita fariseo runacuna tsaycho juntacashga caycaptinmi paycunatana Jesús taporgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gamcunapitaga ¿maygan castapitatag Cristo yurenga?” Tsaynog tapuptinmi nergan: “David castapitami, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsauraga Jesús nergan: “David castapita captinpis ama yarpapäcuytsu Davidnogla mandag rey cashganta. Davidnogla mandag rey captenga ¿imanirtag quiquin Davidpis Santu Espíritu tantyatsiptin mandagnin rey cashganta ninman cargan? Tsayta nirmi David caynog escribergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Munaynincho tsararämag mandag reyta Tayta Diosnintsi caynogmi nergan: Jamacamuy derëcha cag naupäman lapan contrayquita vincinäyag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tsauraga ¿imanogpatag Cristoga Davidnogla mandag rey canman quiquin Davidpis mandagnin rey cashganta niycaptenga?” ");
INSERT INTO qvmNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tsaynog niptin manami pipis contestayta camäpacorgantsu. Tsay junagpita-patsaga manami pipis tapupayta almitergannatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nircurnami runacunata y discïpuluncunatapis Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","“Moisés escribishganta yachatsegcuna y fariseo runacuna Tayta Diospa palabranta yachatsishuptiqui chasquicäriy. Itsanga paycuna cawashgannöga ama cawapäcuytsu. Diospa palabranta yachatsirpis quiquincunaga manami cumplipäcuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paycunaga runacuna ima ruraytapis mana camäpacushganyagmi Moisés escribishgan leycunamanpis yapa yaparcur imatapis cumplinanpag nipäcun. Tsaynog yachatsishganta runacuna cumpliyta mana camäpacuptinpis shacyätsinanpa trucanga olgöpanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Paycunaga waquin runacunapitapis filacteriancunata más jatunta ruraycur puritsipäcun ricagcuna: ‘Payga Tayta Diosta cäsucog ali runami caycan’ nipäcunalanpagmi. Tsaynogpis waquin runacunapita más jatun flëcucunata röpanpa chuscun cuchunman jiraycur puripäcun ricagcuna: ‘Payga Tayta Diosta cäsucog ali runami caycan’ nipäcunalanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Micunanpag gayatsiptinpis paycunaga mësamanragmi jamacuyta munapäcun. Tsaynoglami sinagogacunachöpis alinnin bancumanrag jamacuyta munapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Paycunaga pläzacunachöpis yachatsicog cashganpita alabashga caylatami munapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Gamcunaga ama paycunanog capäcuytsu. Manami yachag-tucunayquipagtsu noga yachatsishcä. Tsaypa trucanga tantyacäriy discïpulöcuna car tsay wauguila carcaycashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pï yachatsicogtapis Tayta Diosnintsitanogräga ama ricanquitsu. Tayta Diosmanga manami pipis iwalantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tsaynog captenga gamcuna wilacuynëta wilacur ama alabashga cayta munalar purinquitsu. Manami alabashga cayta munalar purinayquipagtsu gamcunata yachatsishcä. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maygayquipis respitashga cayta munarga mana yachag-tucuypa runa mayiquita yanapanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Maygantapis yachag-tucogtaga Tayta Diosnintsi manami cäsupangatsu. Mana yachag-tucuypa pï-maytapis yanapagcunatami itsanga Tayta Diosnintsi cuyapar yanapangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Moisés escribishganta yachatsegcuna y fariseo runacuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Wayiman pipis mana yaycunanpag puncuta wichgapagnogmi runacunata wichgaparcaycanqui Tayta Diosnintsi munashganta mana yachacärinanpag. Tsaynoglami quiquiquicunapis Tayta Diosnintsi munashgannog mana cawapäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Moisés escribishganta yachatsegcuna y fariseo runacuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Gamcunaga Tayta Diosnintsita manacuycarpis ali-tupaylapa viüdacunapa ima pobrëzalantapis apacurcaycanqui. Tsaynog rurashgayquipitami infiernucho más fiyupa nacanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Moisés escribishganta yachatsegcuna y fariseo runacuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Gamcunaga may-tsaypapis yachatseg aywapäcunqui fariseo cayman runacuna yaycunalanpag. Yachatsishgayquicunata yachacurcurnami gamcunapita masna ishcay cära capäcun. Tsaynog cashgayquipitami gamcunapis y paycunapis infiernucho pasaypa nacapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Juicio final junäga pasaypami laquicunquipag! Gamcunaga nircaycanqui Moisés escribishgan leycunata yachatseg car gaprata pusharagnog caycashgayquitami. Tsaynog nishpayquipis quiquiquicunaga manami tantyacunquitsu lutanta yachaycätsishgayquita. Tsaynog mana tantyacushpayquimi runacunata yachatsir caynog nircaycanqui: ‘Pipis templupa jutinta jogarcur promitishganta mana cumpliptinpis manami imananpistsu. Templo rurincho caycag örupa jutinta jogarcur promiteg cagmi itsanga tsayta cumplitsun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana tantyacog upa runacuna! ¿Manacu tantyapäcunqui templupa jutinta jogarerga templo rurincho caycag örupa jutintapis jogarishgayquita? ");
INSERT INTO qvmNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Tsaynogpis gamcunaga runacunata caynog nir yacharcaycätsinqui: ‘Altarpa jutinta jogarcur promitishganta mana cumpliptiquipis manami imananpistsu. Altar janancho churashgan ofrendapa jutinta jogarcur promitirmi itsanga tsayta cumplipäcunqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mana tantyacog upa runacuna! ¿Manacu tantyapäcunqui altarpa jutinta jogarerga altar jananman churashgan ofrendapa jutintapis jogarishgayquita? ");
INSERT INTO qvmNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Altarpa jutincho jurarga manami altarpa jutilanchötsu juraycanqui, sinöga altar jananman churashgan ofrendacunapa jutinchöpis jurarcaycanquimi. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Templupa jutincho jurarpis manami templupa jutilanchötsu juraycanqui, sinöga templucho caycag Tayta Diosnintsipa jutinchöpis jurarcaycanquimi. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ciëlupa jutincho jurarpis tsaycho Tayta Dios jamaraptin quiquin Tayta Diosnintsipa jutinchömi juraycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Moisés escribishganta yachatsegcuna y fariseucuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Gamcunaga templuman apanayquipag mentata, anista y comïnustapis chunca (10) wancuypita juc wancuyta imaypis raquircaycanqui: ‘Tayta Diospa palabrancho nishgannogla lapantami ruraycä’ nishpayqui. Tsaynog rurarpis manami cäsucärinquitsu más cäsucunayquipag cag mandamientucunata. Tsay mandamientucunata mana cäsucurmi runa mayiquita mana ali ricaycanqui, mana cuyapaycanquitsu y aunishgayquitapis mana cumpliycanquitsu. Chunca wancuypita juc wancuyta templuman apar Tayta Diosnintsipa palabranta cumplishgayquinogla runa mayiquitapis ali ricanquiman, cuyapanquiman y imata aunirpis cumplinquiman. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Mana tantyacog upa runacuna! Tayta Dios nishgancunata waquinta cumplirpis más cumplinayquipag cagcunata manami cumplipäcunquitsu. Tsaynog carmi yacucho chuspita shuyshuycurrag upurpis mana mayayla jatuncaray camëlluta ultacurcognog carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Moisés escribishganta yachatsegcuna y fariseo runacuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Gamcunaga pusillupa y plätupa janalanta maylar rurintaga mana maylagnogmi carcaycanqui. Tsaymi pusillupa y plätupa rurincho ganra cashgannog mana ali yarpashgayqui y ambiciöso cashgayquipis shonguyquicho caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Mana tantyacog fariseucuna! Tayta Diosnintsi munashgannog cawanayquipäga puntata jutsa rurashgayquicunatarag cachapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Moisés escribishganta yachatsegcuna y fariseo runacuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Gamcunaga cuyaylapag rurashga nïchu-niragmi carcaycanqui. Nïchupa janan cuyaylapag captinpis rurinchöga tulucunapis ismurmi pasaypa asyaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tsaynoglami gamcunapis runacuna ricashunalayquipag pï-maytapis ali-tupanqui. Tsaynog captiquipis ishcay cära cashgayqui y lutan rurashgayquicunaga pasaypa pengacuypagmi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Moisés escribishganta yachatsegcuna y fariseo runacuna! ¡Ishcay cära cashgayquipitami juicio final junag pasaypa laquicunquipag! Gamcunaga profëtacuna pamparashgan janancho capillancunata ruraycur adornarcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nircurnami caynog nircaycanqui: ‘Tsay witsan cawarga nogacuna manami profëtacunata wanutsëmantsu cargan.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tsaynog niycarpis profëtacuna escribishganta mana cäsucurmi runacunata musyaycätsinqui tsay profëtacunata wanutsegcunanogla gamcunapis carcaycashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Profëtacunata wanutsishgannog cananpis Tayta Diospa wilacognin captë wanutsipäcamay, ari! Unay profëtacunata wanutseg runacunata juzganan junag gamcunataga masmi juzgashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Culebra casta runacuna! Tayta Diosnintsi infiernuman gaycushunayquipag cashganpita ¿imanogparag salvacunqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gamcunamanmi cachamushag wilacognëcunata y yachatsegnëcunatapis. Tsaynog captinpis gamcunaga waquinta crucificaypa wanutsipäcunquipag, waquinta sinagogacunacho astapäcunquipag y waquintana marcan marcan gaticachanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Abelta wanutsishganpita-patsami Tayta Diosnintsipa profëtancunata runacuna imaypis wanutsipäcorgan hasta Berequiaspa tsurin Zacariasta altarpa naupancho wanutsishganyag. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tsay wanutseg runacunatanogmi canan witsan Israel runacunata Tayta Diosnintsi juzgangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tsaypita Jesús caynog nergan: “¡Jerusalén runacuna! ¿Imanirtag Tayta Diosnintsipa profëtancunata y cachamushgan wilacogcunata naupapita-patsa wanurcaycätsinqui? Chipshancunata maman shuntarcur oglacognogpis gamcunata atsca cutimi shuntayta munargä. Tsaynog munaptëpis gamcunaga manami munapäcushcanquitsu shuntanäta. ");
INSERT INTO qvmNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Tsaymi gamcunata Tayta Diosnintsi manana tsapäshuptiqui contrayquicuna shamur marcayquitapis ushacätsengapag. Manami yapay ricapäcamanquipagnatsu: ‘¡Tayta Diosnintsi cachamushgan runa caycarga shacalämuy, tayta!’ nimänayquiyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Templo patiupita yargurir Jesús aywacuycaptinmi discïpuluncuna caynog nergan: “¡Cuyaylapag jatusag rumicunawan templuntsita sharcatsipäcushga, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tsaynog niptin Jesús caynog nergan: “Cay lapan ricaycashgayqui cuyaylapag caycaptinpis chipyagmi juchutsishga cangapag. Manami ni juc rumilapis canan pergaraycashgannöga quëdangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olivos lömacho jamapagnogmi discïpuluncuna Jesusta taporgan caynog nir: “Nishgayquinöga ¿imaytag templo juchutsishga canga? Tsaynogpis cutimunayquipag y cay patsa ushacänanpäga ¿imatag puntata canga, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tsaynog tapuptinmi Jesús caynog nergan: “Pipis lutanta mana criyitsishunayquipag shumag tantyacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Atscagmi shapäcamonga: ‘Nogaga Cristumi cä’ nir. Tsaynog nirmi atsca runacunata engañangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","May-tsay nacioncunachöpis guërra captin y wanutsinacuy captin ama mantsacärinquitsu. Puntataga tsaycunaragmi pasanga. Tsaynog captinpis cay patsa manaragmi ushacangaragtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Juc nacionwan juc nacionmi pelyapäconga. Tsaynoglami muchuypis terremötupis may-tsaycho cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tsaynog captinpis nacaycuna galaycunalanragmi tsaycunaga canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tsay witsanmi nogata chasquicamagcunata pï-maypis chiquishpan prësu tsarengapag, nacatsengapag y wanutsengapagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tsaynog nacatsipäcuptinmi yäracaycämashganpita guepaman atsca cuticärenga. Nircurnami guepaman mana cutegcunata chiquir autoridäcunaman apatsenga castigashga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tsay witsanmi lutan yachatsicogcuna Tayta Diosnintsipa wilacuyninta wilacog-tucur runacunata lutanta criyitsengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","May-tsaychöpis runacuna chiquinacurmi cawapäconga. Tsaynog cawarmi runacuna mana cuyanaconganatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tsaynog captinpis hasta wanunanyag noga munashgänog cawagcunaga Tayta Diospa naupanman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tayta Diosnintsipa wilacuyninta may-tsay nacioncunachöpis wilacushga captinragmi noga cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tayta Diosnintsipa profëtan Daniel escribishgannoglami Diosta mana cäsucog runa templo ruriman yaycongapag. (Cay escribishgäta liyeg cäga shumag tantyacutsun.) ");
INSERT INTO qvmNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tsay fiyu runa templuman yaycuptin Jerusalén marcapita y Judea provinciacho caycag waquin marcacunapitapis gueshpir aywacäritsun. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wayi janancho cagcunapis jucla gueshpir aywacutsun. Imata jorgunanpagpis wayinman amana yaycutsuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chacrancho caycagcunapis jucla gueshpir aywacutsun. Ama cutitsuntsu wayinman trucacunanpag röpata jorgogpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tsaynog gueshpirmi pasaypa cuyapaypag nacanga chichu warmicuna y iti wawayog warmicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tamya quillacho ni sábado jamay junagcho tsay gueshpinayqui junag mana cananpag Tayta Diosnintsita manacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsay junagcunaga fiyupami runacuna nacangapag. Cay patsata Tayta Diosnintsi camashganpita-patsa manami imaypis tsaynöga runacuna nacashgatsu. Tsaynogpis yapayga mananami tsaynog nacaycuna cangapagnatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Acrashgancunata cuyaparmi tsay nacaycunata Tayta Diosnintsi pasatsenga. Tsay nacay junagcunata mana pasatsiptenga lapanpis wanupäcunmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Tsay junagcuna: ‘Tayta Dios cachamushgan Cristo caychömi wacchömi caycan’ nishuptiquipis ama criyipäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tsaynogpis waquenga: ‘Tayta Dios cachamushgan Cristumi caycä’ o ‘Tayta Diosnintsipa profëtanmi caycä’ nir lulacushpanmi puripäcongapag. Runacunata criyitsinan cashgami ima milagrucunatapis ruranga. Atsca runacunata tsaynogpa engañarpis Tayta Diosman yäracogcunataga manami engañayta camäpacongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tsaycuna manarag captinmi gamcunata wilaycä lutan yachatsicogcunata mana chasquipänayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Pipis: ‘Tayta Dios cachamushgan Cristo chunyag jircachömi caycan’ nishuptiquipis ricag ama aywaytsu. ‘Washachömi pacaraycan’ nishuptiquipis ama criyinquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ciëlucho juc lädupita juc läduman elguy elagpita atsicyagta lapan runacuna ricashgannogmi noga cutimuptëpis lapan runacuna ricamangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wisculcuna juntacaycagta ricarmi musyantsi wanushga uywa tsaycho jitaraycashganta. Tsaynoglami cay nishgäcuna pasaycagta ricar musyanqui cutimunäpagna caycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Cay patsacho fiyupa nacaycuna pasariptinragmi intipis y quillapis tsacacäconga. Tsaynoglami lapan estrellacunapis shicwamonga y ciëlupis sicsicyanga. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tsaypitanami nogata ricapäcamanga pucutay janancho chip-chipyaycar cutiycämogta. Tsaynog aywaycämogta ricamashpanmi may-tsaychöpis runacuna mantsarir wagapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsay junag Tayta Diosnintsi cornëtata fuerti tucatsimuptinmi angilnëcunata cachamushag. Paycunami may-tsaypitapis nogaman yäracamagcunata shuntamongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Cay yachatsishgäta shumag tantyacäriy. Tamya tiempo galaycuptin musyapäcunquimi hïgus yöra tsintsimunanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tsaynoglami tsay nishgä nacaycuna chämuptin gamcunapis musyanquipag cutimunäpagna caycashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Canan cawaycag runacuna manarag wanuptinmi lapan tsay nishgäcuna cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jana patsa y cay patsa ushacaptinpis noga nishgäcunaga lapanmi cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Imay junag imay höra cutimunäpag cashgantaga manami angilcunapis ni nogapis musyätsu. Tsaytaga Tayta Dioslami musyan. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé cawanan witsan diluvio elagpita cashgannogmi nogapis elagpita cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noé cawanan witsanpis diluvio manarag captinmi runacunaga micur, upyar y majatsacar caycargan. Tsaynog cawapäcorgan arcaman Noé yaycushgan junagyagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tsaynog carcaycaptinmi elagpita fiyupa tamyar cay patsaman yacu juntargan. Tsaynogpami arcaman mana yaycog lapan runacuna shengaypa wanorgan. Tsaynoglami runacuna mana musyashgan höra nogapis elagpita cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Cutimunä junagmi ishcay runacuna chacrancho aruycagpita chasquicamag cagta pushacushag y mana chasquicamag cagtanami cacharishag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maraycho ishcay warmicuna agacuycagpita chasquicamag cagta pushacushag y mana chasquicamag cagtanami cacharishag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tsaynog caycaptenga gamcuna shuyarpaycämanqui camaricushgala. Manami musyanquitsu imay höra cutimunäpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Pipis wayinta suwapänanpag cashganta musyarga mana punuypami wayinta täpanman. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tsaynogla gamcunapis camaricushgala carcaycay. Mana musyashgayqui hörami elagpita noga cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Patronnin maypapis ilarga más yäracuypag cag ashmaynintami haciendancho patronyapänanpag churan. Tsaymi tsay ashmayga mincaynincunatapis höralancho garatsin. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Patronnin cutimur yätsishgannog ali ruraycagta tariycorga: ‘Ali ashmaymi canqui’ nengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tsaynog nishpanmi patronnin tsay ashmaypa maquinman churanga lapan imaycantapis ricananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Mana yäracuypag cag ashmaymi itsanga: ‘Patronnë manaragmi cutimongaragtsu’ nir ashmay mayinta magan y borrächucunawan micur upyar jitaräcun. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tsaynog caycaptinmi mana musyashgan höra elagpita patronnin cutimonga. ");
INSERT INTO qvmNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Patronnin yätsishganta mana cäsucur lutanta ruraycagta tariycurmi patronnin mana cuyapaypa tsay ashmayta castigangapag. Ishcay cära runacunatawan juntumi Tayta Diosnintsi mana cuyapaypa infiernuman payta gaycongapag. Tsaychömi fiyupa wagar quiruntapis uchongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Cutimuptin imanog cananpag cashgantapis tantyatsishpanmi Jesús caynog nergan: “Chunca (10) jipashcunashi farolnincunata camaricurcur shuyarag aywargan casaracog mözu shamuptin paywan fiestaman aywapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Shuyarag aywarshi pitsga cag jipashcuna aceitinta apargan farolnincunaman yapananpag. Pitsga cag jipashcunanashi itsanga aceitinta mana apargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Casarag mözu mana chayaptinshi shuyarpaycashgalancho lapan punucäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tsaynog punucashga caycaptinshi pulan pagas höranog caynog gayacamushgan mayacämorgan: ‘¡Casaracog mözu aywaycämunnami!’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tsaynog gayacamushganta mayarshi lapan jipashcuna jucla sharcorgan payta chasquicunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tsaychömi farolnincunaman yapananpag aceitita mana apag jipashcuna waquin cag jipashcunata caynog nergan: ‘Farolnë upicaycannami. Aceitiquita raquipaycalämay farolnëman winanäpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tsaynog niptinmi aceiti apag jipashcuna caynog nergan: ‘Raquipaptëga manami aypangatsu quiquëcunapagpis. Tsaypa trucanga aceiti ranticogcunaman aywar jucla rantipäcamuy.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aceiti ranteg aywapäcushganyagshi casarag mözu chämorgan. Listu shuyarpaycagcunatashi fiestaman pushargan. Fiestaman yaycurirnashi puncuta wichgacarcamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aceitita ranteg aywashganpita cutirnashi tarergan puncu wichgaraycagta. Tsayshi gayacärergan: ‘¡Puncuta quichapaycalämay, tayta!’ nir. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tsauraga casaracog mözushi ruripita contestamorgan caynog nir: ‘Gamcunataga manami reguëtsu. ¿Pirag cacunquipis?’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tsaynog yacharcatsir Jesús caynog nergan: “¡Gamcunapis camaricushgala carcaycay! Nogaga elagpitami cutimushag. Manami musyapäcunquitsu imay junag ni imay höra cutimunäpag cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tsaypitanami Jesús caynog nergan: “Juc rïcu runashi juc nacionpa aywacur ashmaynincunata guellayninta cachapargan cutimushganyag tsay guellaywan arunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Habilidänincuna imanog cashgantapis shumag tantyaycurshi jucninta cachapargan pitsga waranga (5,000) guellayta, jucninta ishcay waranga (2,000) guellayta y jucnintanashi cachapargan juc waranga (1,000) guellayta. Nircurshi carupa aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pitsga waranga guellayta chasqueg cäga shumag negociuta rurarshi pitsga waranga masta gänargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ishcay waranga guellayta chasqueg cagpis tsaynoglashi shumag negociuta rurar ishcay waranga masta gänargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Juc waranga guellayta chasqueg cagshi itsanga pañuëluwan shumag guepiycur pampaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tsaypitanashi tsay ashmaycunapa patronnin cutimur camaripashgan guellaynincunata cuentata manargan aycata guellaynin wachashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsaynog cuentata manaptinshi pitsga waranga guellayta chasqueg cäga pitsga waranga masta entregargan. Tsayshi tsay ashmay caynog nergan: ‘Pitsga waranga guellayta cachapämashgayquiwan pitsga waranga mastami gänashcä, tayta.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tsaynog niptinshi patronnin caynog nergan: ‘Gamga ali ashmaymi canqui. Walcalapitapis shumag guellayta miratsishgayquipitami cananga más mandag canayquipag churashayqui. Tsaynog cashgayquipitami cananga cushicur fiestata rurashun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tsaynoglashi chayargan ishcay waranga guellayta chasqueg cagpis caynog nishpan: ‘Tayta, ishcay waranga guellayta cachapämashgayquiwan ishcay waranga mastami gänashcä.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsaynog niptinshi patronnin caynog nergan: ‘Gampis ali arog ashmaymi canqui. Walcalapitapis shumag guellayta miratsishgayquipitami cananga más mandag canayquipag churashayqui. Tsaynog cashgayquipitami cananga cushicur fiestata rurashun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tsaynoglashi juc waranga guellayta chasqueg ashmayninpis chayaycur caynog nergan: ‘Noga musyämi fiyu cashgayquita, tayta. Gamga mana murushgayquimanmi cosechag aywanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsaynog fiyu cashgayquita musyarmi gamta mantsacur guellayniquita pampaycorgä. Tsaymi gayatsimaptiqui cashgalanta guellayniquita apamushcä.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Tsaynog niptinshi patronnin caynog nergan: ‘¡Gamga mana yäracuypag guella ashmaymi canqui! Mana murushgäpita cosechag cashgäta musyaycarga ¿imanirtag guellaynëta banculamanpis mana churargayquitsu mirashgatana cutimur shuntacunäpag?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nircurnashi tsaycho caycag runacunata patrón caynog nergan: ‘¡Shuntapäcuy tsararaycashgan guellaynëta! ¡Nircur goycuy chunca (10) cuti más guellay miratseg cagta! ");
INSERT INTO qvmNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Guellayta camaripashgäta miratsegcunaga mastami chasquenga. Mana miratsegcunami itsanga tsararashgalantapis guechushga canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tsaynog captenga cay mana ali ashmayta tsacayman garguy. Tsaychömi fiyupa wagar quiruntapis uchongapag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lapan angilnëcunawan cutimurmi chip-chipyaycag trönöman noga jamacushag lapan runacunata juzganäpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tsay junäga may-tsay nacionpitami lapan runacunata angilnëcunawan shuntatsimushag. Tsaynog shuntarcatsimurnami raquishagpag uysha mitseg uyshancunata cabracunapita raquishgannog. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tsaychömi mana chasquicamag runacunata raquishag itsognë cagman y chasquicamag runacunatana derëchä cagman. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsaynog raquircurnami derëchächo caycagcunata caynog nishag: ‘Gamcunataga Tayta Dios pasaypami cuyashunqui. Naupäman shapäcamuy lapan camarishgäcunata chasquipäcunayquipag. Tsaytaga Tayta Diosnintsi gamcunapag camarishga cay patsata manarag camarmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gamcunami yarganaycar puriptë garamashcanqui. Tsaynogpis yacunaycar puriptë upunäpag yacuta gomashcanqui. Tsaynoglami wayiquiman chämuptëpis posädatsimashcanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Röpaynag captëpis gamcunami jaticunäpag röpata camaripämashcanqui. Gueshyaptëpis gamcunami jampimashcanqui. Carcilcho captëpis gamcunami watucamashcanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tsaynog niptëmi tsay runacuna caynog tapumangapag: ‘Tayta, ¿imaytag micanar puriycagta garashcä? Tsaynogpis ¿imaytag yacunar puriycagta upunayquipag yacuta goshcä? ");
INSERT INTO qvmNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tsaynogpis ¿imaytag wayëman chämushcanqui posädatsinäpag? Tsaynogpis ¿imaytag röpaynag caycaptiqui jaticunayquipag röpata camaripashcä? ");
INSERT INTO qvmNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tsaynogpis ¿imaytag gueshyaptiqui o carcilcho captiqui watucog shamushcä?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tsaynog nimaptinmi caynog nishag: ‘Yäracamagcunata mayganpis yanapag cagcuna nogata yanapamagnogmi cashcanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nircurmi itsognëcho caycag runacunata caynog nishag: ‘¡Gamcunataga Satanaspag y demoniucunapag camarishga caycag infiernumanmi canan gaycushayqui imayyagpis tsaycho rupar nacanayquipag! ");
INSERT INTO qvmNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gamcunaga yarganaycar puriptëpis manami garamashcanquitsu. Tsaynogla yacunaycar puriptëpis manami upunäpag yacuta gomashcanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tsaynoglami wayiquiman chämuptëpis mana posädatsimashcanquitsu. Röpaynag caycaptëpis manami jaticunäpag röpata camaripämashcanquitsu. Gueshyaptëpis carcilcho wichgaraptëpis manami watucamashcanquitsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tsaynog niptëmi itsognëcho cag runacunapis caynog tapumanga: ‘¿Imaytag gam micanaycagta, yacunaycagta, wayëman chayaycämogta, röpaynagta, gueshyaycagta, carcilcho wichgaraycagta ricaycar mana yanapashcätsu, tayta?’ ");
INSERT INTO qvmNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tsaymi paycunata caynog nishag: ‘Nacaycho cagcunata mana cuyapar nogatami mana cuyapämashcanquitsu.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tsaynog wilaparcushpan Jesús caynog nergan: “Tsay mana cuyapäcog runacunaga infiernuchömi imayyagpis nacapäcongapag. Tayta Dios munashgannog yanapäcog runacunami itsanga imayyagpis gloriacho cawangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tsaynog yacharcatsirmi discïpuluncunata Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Musyashgayquinogpis Pascua aniversario galaycunanpag ishcay junaglanami pishiycan. Tsaychömi runacuna nogata crucificamangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tsaypita mandag cüracuna y Israel mayor runacuna juntacargan más mandag cüra Caifaspa wayinman. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tsaychömi wilanacärergan runacunata mana musyatsiylapa Jesusta tsarircur wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tsaymi caynog wilanacärergan: “Fiestachöga ama tsarishuntsu. Fiestacho tsariptintsega contrantsimi runacuna sharcongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tsaypitanami Betania marcaman Jesús aywargan lepröso nipäcushgan Simonpa wayinman. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tsaymanmi juc warmi chayargan “alabastro” nishgan rumipita rurashgan botëllanwan perfümin aptashga. Tsay perfümega pasaypa chaninmi cargan. Mësacho Jesús caycaptinmi tsay warmega paypa umanman tsay perfümita winapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Discïpuluncuna tsayta ricar rabiashpan caynog nipäcorgan: “¿Imapagtag manacaglapag jichar perditsishga tsay perfümita? ");
INSERT INTO qvmNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tsaynog perditsinanpa trucanga nogantsita goycamashwan cargan ali chanincho ranticuycur wactsacunata yanapanantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tsay nishgancunata mayarmi Jesús caynog nergan: “Cay warmi alitami ruraycan. Tsaynog caycaptenga ¿imanirtag payta jamurpaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wactsacunaga yanapanayquipag imaypis caycangami. Nogaga mananami gamcunawan cashagpagnatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pampashga canäpagmi cay warmega perfümita winapämar camariycäman. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Perfümita cay warmi winapämashgantaga may-tsaychöpis musyapäcongami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tsaypitanami Jesuspa discïpulun Judas Iscariote aywargan mandag cüracunaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Chayaycurmi paycunata caynog nergan: “Runacuna mana cashgancho Jesusta prësu tsarinayquipag wilaptë ¿aycatatag pägamanquipag?” Tsaynog niptinmi: “Nogacuna pägashayqui quimsa chunca (30) yorag guellaytami” nishpan guellayta yupapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsaynog päguta chasquircurmi Judas yarpachacorgan imay höra wilacog cutinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Levadüraynag Tantata Micunan aniversario galaycunan junagmi discïpuluncuna Jesusta taporgan caynog nir: “¿Maychötag camaripäcamushag Pascua cënayta micunantsipag, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tsaynog niptinmi Jesús caynog nergan: “Marcaman aywar juc runata caynog nipäcunqui: ‘Wanunanpag höran cercana captinshi discïpuluncunawan Pascua cënayta wayiquicho micuyta munaycan.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesús yätsishgannogla aywarmi discïpuluncunaga Pascua cënayta tsay wayicho camaripäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Patsa tsacaycaptinnami chunca ishcay (12) acrashgan cag discïpuluncunawan Jesús mësaman jamacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tsauraga micurcaycashgancho Jesús caynog nergan: “Gamcunapita jucniquimi conträcunapa maquinman entregamangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Niptin laquicärishpan jucnin jucnin caynog nir Jesusta tapupäcorgan: “¿Nogatsurag caycä, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsauraga Jesús nergan: “Plätucho nogawan juntu tantata ushmatseg cagmi conträcunapa maquinman entregamangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tayta Diospa palabrancho escribiraycashgannogla fiyupa nacar wanunäpagmi caycä. Nogata entregamag runami itsanga juicio final junag pasaypa laquicongapag. Payga ama yurinmanpistsu cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsaynog niptinmi contran sharcog Judasga Jesusta taporgan caynog nir: “¿Nogatsurag caycä, tayta?” Niptin Jesús nergan: “Quiquiquimi nishcanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsaypitanami tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata ayporgan caynog nishpan: “Cay tantata lapayqui micapäcuy. Cay tantaga cuerpömi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsaynoglami vïnuyog väsuta aptarcur Tayta Diosta manacur agradëcicorgan. Nircurnami discïpuluncunata macyargan caynog nir: “Lapayqui cay vïnuta upupäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay vïnoga yawarnëmi. Yawarnëta jichar wanushgä hörami Tayta Dios mushog conträtuta ruranga pï-maytapis chasquicamagcunata perdonananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yapayga manami vïnuta upushagnatsu Tayta Diospa naupancho gamcunawan upunantsiyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Salmucunata cantarcurnami discïpuluncunawan Jesús aywapäcorgan Olivos lömaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olivos lömaman chayaycurmi Jesús nergan: “Canan tsacay lapayqui cachariycamarmi gueshpir aywacärinquipag. Tayta Diosnintsipa palabranchöpis caynogmi niycan: ‘Uysha mitsegta wanuycatsiptë uyshancuna mashtacarmi aywacärenga.’ ");
INSERT INTO qvmNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tsaynog captinpis wanushgäpita cawarircamur gamcunapita más puntatami Galileaman aywashag tsaycho tincunantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tsauraga Pedro nergan: “Waquin cag cacharishuptiquipis nogaga manami cachashayquipagtsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tsaynog niptinmi Pedruta Jesús caynog nergan: “Canan tsacay gällu manarag cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tsauraga Pedro caynog nergan: “¡Ishcantsita wanutsimänantsi captinpis manami ñëgashayquipagtsu, tayta!” Waquin cag discïpuluncunapis tsaynoglami nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Olivos lömacho caycag Getsemaní huertaman discïpuluncunawan chayaycurmi Jesús caynog nergan: “Tayta Diosta manacamushgäyag gamcuna caylacho jamarpaycay.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nircur Pedruta y Zebedeupa tsurincuna Santiaguta y Juanta más washa läduman pushargan. Tsaychömi fiyupa laquicur caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Wanuyparagmi laquicuy tsarimashga. Gamcunapis Tayta Diosta manacushpayqui caylacho shuyarpaycämay.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsaynog nircurmi más washa läduman aywargan Tayta Diosta manacunanpag. Tsaychömi gongurpacuycorgan hasta urcunpis pampaman töpananyag. Tsaynog gongurpacuycurmi Tayta Diosta manacorgan caynog nir: “Papá, nacanäpag caycashgäpita salvaycalämay. Itsanga noga munashgänöga ama catsuntsu, sinöga gam munashgayquinog cayculätsun.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsaynog manacushganpita cutishpanmi tarergan quimsan discïpuluncuna punucashga caycagta. Tsauraga Pedruta caynog nergan: “Tayta Diosta manacushgäyag ¿manacu juc höralapis ricchayta camäpacärishcanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Punushgayquipita ricchayna. Diosta manacäriy Satanasta mana cäsupänayquipag. Cäsupayta mana munarpis Tayta Diosta mana manacorga cäsupanquipagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tsaynog nircurmi yapay cutiycur Tayta Diosta manacorgan caynog nir: “Runacuna nacatsimar wanutsimänanpag captinpis gam munashgayquinog cayculätsun, papá.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tayta Diosta manacushganpita yapay cutiycur tarergan quimsan discïpuluncuna pasaypa punucashga caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsaynog caycagta ricaycurpis yapay cutiycurmi Tayta Diosta manacorgan puntata manacushgannogla. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsaypitanami yapay cutiycur paycunata nergan: “¿Cananpis gamcuna jinalacu punurcaycanqui? ¡Ricchapäcuy! Tayta Diospita shamushga captëpis höra chämushganami jutsasapa runacunapa maquinman nogata entregamänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Sharcapäcuyna! Conträcunapa maquinman entregamänanpag cag runa aywaycämunnami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Discïpuluncunawan Jesús parlaycaptinmi Judas Iscariote chayargan atsca runacunata pushashga. Judasga Jesuspa discïpulunmi cargan. Tsay runacunami chayargan espädancuna y garrotincuna aptashga. Jesusta prësu tsarinanpag tsay runacunata cachargan mandag cüracuna y Israel mayor runacunami. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tsayman manarag chayarmi Judasga pushashgan runacunata yätsergan caynog nir: “Mayganpis mutsashgä cagmi Jesusga canga. Payta prësu tsaripäcunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsaymi chayaycur Judasga Jesusta saludashpan mutsaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tsaynog saludaptinmi Jesús caynog nergan: “Judas, ¿caymanpis aywaycamunquiragcu?” Tsaynog niptinmi runacunaga Jesusta jucla prësu tsarergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Prësu tsariptinmi espädanta jorgurishpan juc discïpulun más mandag cürapa ashmayninpa rinrinta roguriycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsaynog ruraptinmi Jesús caynog nergan: “Espädayquita cutitsiy churaräcunanman. Pipis espädawan runa mayinta wanutseg cäga espädawanmi wanutsishga canga. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Gam manacu musyanqui Tayta Diosta manacuptëga washämänanpag chunca ishcay (12) tröpa angilcunata cachamunanpag cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Washämänanpag manacuptëga ¿imanogparag cumplenga runacuna wanutsimänanpag Tayta Diospa palabrancho escribiraycashganpis?” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nircurna tsay runacunata Jesús caynog nergan: “¿Imanirtag suwa captënogpis gamcuna shamushcanqui espädayquiwan y garrotiquiwanpis prësu tsarimänayquipag? Nogaga waran waranmi templo patiucho yachatsergä. ¿Imanirtag tsaychöga prësu mana tsarimargayquitsu? ");
INSERT INTO qvmNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tsaynog captinpis prësu tsarimänayquipag gamcuna shapäcamuptiquimi Tayta Diosnintsipa profëtancuna escribishgan cumpliycan.” Jesusta prësu tsariptinnami discïpuluncuna gueshpir aywacärergan japalanta cachaycur. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta prësu tsarircurmi apapäcorgan más mandag cüra Caifaspa wayinman. Tsaychömi Moisés escribishganta yachatsegcuna y Israel mayor runacunapis juntacashga caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesusta tsayman apapäcuptinmi caru guepalanta Pedro gatirargan. Caifaspa wayinman chayaycur paypis yaycorgan patio rurinyag. Tsayman yaycurir templo täpag wardiacunawan jamaraycargan ima pasashgantapis ricananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mandag cüracuna y autoridäcunanaga imanogpapis Jesusta wanutsinantami munapäcorgan. Tsaymi ashipäcorgan pilapis Jesús mana parlacushganta jitapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tsaynog ashiptin atscagmi Jesús mana parlacushganta tumpargan. Tsaynog tumpaptinpis manami ima jutsantapis taripäcorgantsu wanutsishga cananpag. Tsaypita ishcay runacuna caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Cay runaga nergan templuta juchuratsir quimsa junaglata yapay sharcatsinanpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsauraga más mandag cüra caynog nir Jesusta taporgan: “¿Manacu imatapis ninqui tsaynog jitapäshuptiqui? ¿Imanirtag contrayqui tsaynog parlarcaycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tsaynog tapuptinpis manami imatapis Jesús parlacorgantsu. Tsaymi más mandag cüra caynog nergan: “Lapanpag munayniyog Tayta Dios ricaycämaptintsimi gamta tapö: ¿Rasunpacu Tayta Dios cachamushgan Cristo caycanqui? Tsaynogpis ¿rasunpacu Diospa tsurin canqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tsaynog tapuptinmi Jesús nergan: “Au, nishgayquinog rasunpami caycä. Tsaymi nogata ricapäcamanquipag lapanpag munayniyog Tayta Diospa derëcha cag naupancho jamaraycagta. Tsaynogpis pucutay janancho aywaycämogtami ricapäcamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsaynog niptin más mandag cüra pasaypa rabiashpan sotänantapis rachir ushar caynog nergan: “¡Cay runaga Dios-tucuycanmi! Tsaynog niycaptenga ¿imapagnatag más testïgutapis ashishun? Gamcuna mayapäcushcanquimi Dios-tucur parlaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tsaynog captenga ¿imanipäcunquitag?” Tsauraga tsaycho caycag runacuna caynog nipäcorgan: “¡Jutsayogmi caycan! ¡Wanutsishga catsun!” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsaynog nirmi Jesuspa cäranman paycuna togapargan y cutapäcorgan. Waquinnami lagyar ushapäcorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Tayta Diosnintsi cachamushgan Cristo carga mä nimay pï magashushgayquitapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsayyäga Pedro jamaraycargan sawan rurinchömi. Tsaycho jamaraycagta ricarmi juc ashmay jipash caynog nergan: “Gamta ricashcä Galileapita cag Jesuswan puriycagtami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsaynog niptinmi lapan runacuna mayaycaptin Pedro caynog nergan: “Manami musyätsu imapita parlapaycämashgayquitapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsaynog nircushpanmi Pedroga puncu naupanman aywargan. Tsaychöpis juc jipash payta ricaycur runacunata caynog nergan: “Nogapis cay runataga ricargä Nazaretpita cag Jesuswan puriycagtami.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tsaynog niptin Pedro jurashpan caynog nergan: “¡Nogaga manami reguëtsu tsay runataga!” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tsaypita maylantana tsaycho caycag runacuna Pedruman aywaycur caynog nipäcorgan: “¡Gamga rasunpami paywan pureg canqui! Parlacuyniquipis pay-niragmi caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsaynog niptinmi Pedro jurashpan caynog nergan: “¡Tsay runaga pishi cacunpis! ¡Paytaga manami reguëtsu!” Tsaynog niycaptinmi gällu cantarcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsaynog cantarcuptinmi Pedro jinan höra yarparcorgan Jesús caynog nishganta: “Manarag gällu cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipag.” Tsay nishganta yarparcurmi Pedro wagtaman yargurir pasaypa laquicushpan maquinta chogpacurcur wagargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsaypita patsa waraycaptinnami lapan mandag cüracuna y Israel mayor runacuna juntacaycur wilanacorgan Jesusta imanogpapis wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wilanacurcurnami liyarcur Jesusta apatsipäcorgan Israel nacionpa mandagnin Pilätuman. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusta wanutsinanpag Israel mayor runacuna wilanacushganta musyaycurmi Judas Iscariote fiyupa laquicorgan. Tsaymi chasquishgan quimsa chunca (30) yorag guellayta cutitsergan mandag cüracunaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cutitsirmi paycunata caynog nergan: “Jutsaynag runata maquiquiman entregar jutsatami rurashcä, taytacuna.” Tsaynog niptinmi caynog nipäcorgan: “¡Imanogpis cacuy! ¡Nogacunataga manami imapis gocamantsu!” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tsaynog niptinmi Judasga chasquishgan guellayta templuman jitariycur aywacorgan. Nircurnami jurcacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsauraga mandag cüracuna tsay guellayta shuntarcur caynog nipäcorgan: “Cay guellayga runapa yawarninpa chaninmi. Tsaynog caycaptenga manami ofrendacunaman talutsishwantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsaynog nirmi wilanacorgan tsay guellaywan manca rurag runapa chacranta rantinanpag. Tsay chacrata rantergan jäpa runacuna wanuptin tsayman pampananpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jesuspa yawarnin chanin captinmi tsay chacrata runacuna jutinta churapargan “Yawar Pampa” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mandag cüracuna chacrata tsaynog rantiptinmi Tayta Diosnintsipa unay profëtan Jeremías escribishgan cumplergan. Tsay escribishganga caynogmi niycan: “Paypa preciun ayca cananpagpis Israel runacuna nishgannoglami quimsa chunca (30) guellayta chasquipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tsay guellaywanmi Tayta Dios nimashgannogla manca rurag runapa chacranta rantipäcorgan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Israel nacionpa mandagnin Pilätuman Jesusta prësu chayatsiptinmi pay Jesusta taporgan caynog nir: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” Tsaynog tapuptinmi Jesús caynog nergan: “Gam nishgayquinoglami rasunpa caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tsaycho mandag cüracuna y Israel mayor runacuna imaycata jitapaptinpis Jesús manami imatapis rimacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tsaymi Pilato taporgan: “¿Manacu imatapis ninqui contrayqui jitapaycäshuptiquipis?” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tsaynog niptinpis Jesusga manami imatapis rimacorgantsu. Tsaymi Pilätoga imaniytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cada watami Pascua aniversariucho Pilato cachareg juc prësuta runacuna manacushgan cagta. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsaychömi prësu wichgaraycargan pï-maypitapis reguishga Barrabás jutiyog fiyu runa. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Israel runacunapa autoridänincuna Jesusta chiquir payman prësu apashganta musyarmi tsaycho juntacashga caycag runacunata Pilato taporgan caynog nir: “¿Maygan prësutatag cacharinäta munapäcunqui? ¿Barrabastacu? ¿O Cristo nishgan Jesustacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato tsaycho juzgar jamaraycaptinmi warmin wilacatsergan caynog nir: “Tsay runaga jutsaynagmi. Ama imatapis ruraytsu paypa contran. Canan pagas pasaypa mana alicunatami sueñupäcushcä prësu tsarishganpita.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tsaynog wilacatsiptin Jesusta Pilato cachariyta munaptinpis tsaycho caycag mandag cüracuna y Israel mayor runacunapis runacunata shimita jatipargan Barrabasta cacharir Jesusta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsaymi: “¿Maygantatag cacharishag?” nir Pilato tapuptin runacuna: “Barrabasta cachariyga” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsaynog niptin Pilato caynog nergan: “Tsaynog captenga prësu apamushgayqui Cristo nishgan Jesustaga ¿imatatag rurashag?” Tsaynog niptinmi lapan runacuna: “¡Crucificashga catsun!” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tsauraga Pilato caynog nergan: “Crucificashga cananpäga ¿ima jutsatatag rurashga?” Tsaynog niptin runacuna masrag nipäcorgan: “¡Crucificatsiy!” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Runacuna tsaynog gaparpaptinmi ima ruraytapis Pilato mana camäpacorgantsu. Tsaymi yacuta apaycatsimur lapanpa naupancho maquinta maylacushpan caynog nergan: “Nogaga manami jutsayogtsu cä cay jutsaynag runata wanutsishgayquipita. ¡Gamcuna munashgayquita ruracäriy!” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsaynog niptin runacuna caynog nipäcorgan: “Nogacuna y wamräcunami cay runa wanushganpita jutsayog capäcushag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Runacuna tsaynog niptinmi Barrabasta Pilato cacharergan. Nircurna Jesusta astarcatsir entregaycorgan crucificashga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsaypita soldäducuna Jesusta apargan palacio patiuman. Tsaymanmi lapan soldäducuna juntapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nircurmi payta asipänan cashga röpanta logtiparir aylupargan rey jaticunan puca-chicnu cäpata ");
INSERT INTO qvmNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tsaynogpis cashapita awashga corönata umanman jatipargan. Derëcha cag maquinmannami värata aptapargan. Nircurmi naupanman gongurpacuycur asipar caynog nergan: “¡Alabashga catsun Israel runacunapa mandagnin rey!” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tsaynogpis togapar ushargan. Aptaraycashgan värata guechurir trucapänacuypa tsaywan umacho wirupäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsaynog asiparcurmi aylupashgan puca cäpata logtiparcur quiquinpa röpantana Jesusta jatipargan. Nircurmi crucificananpag apapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Crucificananpag apaycarmi tincorgan Cirene marcapita Simón runawan. Paytami Jesús apaycashgan cruzta umrutsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nircurnami Jesusta chayatsipäcorgan Gólgota nishganman. Gólgota ninanga cargan “Calavëra” ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tsaychömi vïnuta talutsergan asgag jachawan Jesusta uputsinanpag. Tsaynog uputsiyta munapäcuptinpis Jesús yawarcur manami upuyta munargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nircurnami Jesusta crucificapäcorgan. Crucificaycurnami Jesuspa röpanpag soldäducuna suertita jitapäcorgan mayganpis gänag cag apacunanpag. Tsaynogpami Tayta Diosnintsipa profëtan caynog escribishgan cumplergan: “Quiquinpura raquipänacunanpagmi röpäpag suertita jitapäcorgan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Soldäducunanami tsaycho täpar quëdacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tsaypitanami juc tablaman letrëruta escribircur cruzpa puntanman clävargan. Tsay letrëruchömi caynog escribiraycargan: “Cay runaga Israel runacunapa mandagnin reymi.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesús crucificaraycashgan naupanmanmi ishcay suwa runacunatapis crucificargan, jucnin cagta derëcha cag naupanman y jucagtana itsog cag naupanman. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cruzcho caycashganta ricarmi tsaypa pasag runacuna Jesusta asipargan umanta awishpan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Templutapis juchurcatsir quimsa junaglata sharcatsinayquipag cashganta niycarga mä salvacuy, ari. Tayta Diosnintsi cachamushgan Cristo rasunpa carga ¿imanirtag cruzpita mana urämunquitsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tsaynogpis mandag cüracuna, Moisés escribishganta yachatsegcuna, fariseo runacuna y Israel mayor runacunapis Jesusta asipashpan caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Waquinta salvarpis ¿imanirtag quiquenga salvacuyta mana camäpacuntsu? Israel runacunapa mandagnin rey carga mä cruzpita urämutsun nogantsipis criyinantsipag. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‘Tayta Diosmanmi yäracö’ nimargantsichag. Tsaynogpis: ‘Tayta Diospa tsurinmi cä’ nimargantsichag. Rasunpa tsurin captenga cuyapashpan Tayta Diosnintsi maynami cruzpita jorgunman cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tsaynoglami naupancho crucificaraycag suwa runacunapis payta ashlergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pulan junag caycaptinmi patsa tsacacäcorgan malway intiyag. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Malway inti caycaptinmi Jesús fuertipa caynog nergan: “Elí, Elí, ¿lama sabactani?” Tsay ninanga caycan: “Diosnë, Diosnë ¿imanirtag cachaycamashcanqui?” ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tsaynog nishganta mayarmi tsaycho caycag runacuna waquin nipäcorgan: “Tayta Diosnintsipa profëtan Eliastami gayacuycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tsaynog niptin juc runa gueru puntanman hisöputa rurarcur pochgog vïnuman ushmatsergan. Nircurna Jesusta shogutsiyta munargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shiminman churapaptinmi runacuna caynog nipäcorgan: “Ama shogutsiytsu. Canan ricashun mä cruzpita jorgunanpag Elías shamunagcu o manacush.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tsaypitanami yapay fuertipa gapararcur Jesús wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesús wanushgan hörami templo rurincho tsaparag racta cortïna rachicäcorgan janapita urayag. Tsaymi patsa fiyupa sicsicyaptin gagacunapis rachicargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Tsaypita Jesucristo cawarimuptinnami Tayta Dios munashgannog cawag runacunapis panteoncho pamparaycashganpita atsca cawarimorgan. Jerusalén marcaman yaycuptinnami atsca runacuna paycunata ricapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesusta täpaycag capitán y soldäduncunapis patsa sicsicyaycagta mayar tsaynogla lapan pasashgancunatapis ricar fiyupa mantsacargan. Tsaymi caynog nipäcorgan: “¡Rasunpami cay runaga Diospa tsurin cashga!” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tsaychömi atsca warmicuna carulapita ricarpaycargan. Tsay warmicunami Galileapita-patsa Jesusta yanapar paywan aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paycunawanmi caycargan María Magdalena, Santiagupa y Josëpa maman María y Zebedeupa warminpis. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Patsa tsacaycaptinnami Pilato cagman chayargan Arimateapita cag José. Payga rïcumi cargan. Tsaynogpis Jesucristuman yäracog runami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato cagman aywaycurmi manacorgan caynog nir: “Jesuspa ayanta cachapaycalämay pampag apanäpag.” Tsaynog manacuptinmi Pilato soldäducunata nergan Jesuspa ayanta cachapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tsaynog cachapaycuptinnami lïnupita rurashga fïnu säbanaswan pitorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nircurnami gagacho tsayrag uchcutsishga sepultüraman Jesusta pampargan. Tsay sepultürataga quiquin pampacunanpagmi uchcutsishga cargan. Tsaypitanami jatuncaray rumiwan sepultürapa puncunta tsapaycur aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pay aywacuptinpis María Magdalena y jucag Mariapis Jesuspa sepultüran naupanchömi jamaraycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Jesús wanushganpita wara sábado jamay junagnami mandag cüracuna y fariseo runacunapis Pilato cagman aywaycur caynog nipäcorgan: “Tayta, tsay lulacog runa: ‘Wanushgäpita quimsa junagtami cawarimushag’ nishgantami yarparcushcä. ");
INSERT INTO qvmNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsaymi shamushcä gamta manacog, tayta. Soldäduyquicunawan sepultürata quimsa junagyag täpaycatsilay. Mana täpatsiptiquega tsacaypa shamur discïpuluncuna Jesuspa ayanta suwangapagmi. Nircurnami runacunata criyitsenga: ‘Wanushganpita cawarimushganami’ nir. Tsaynog lulacuptenga masragmi runacuna criyipäconga Jesús ‘Cawarimushagmi’ nishgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsaynog niptinmi Pilato nergan: “Soldäducunata churapäcamuy täpananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tsaynog niptinmi aywaycur sepultüra tsaparaycashgan rumipa juc cuchunta cërawan lagargan pipis quichaptin imaptenga musyacänanpag. Nircurnami soldäducunata tsaycho täparänanpag cachaycur cuticärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sábado jamay junag jamaparcurnami domingo tuta tsaca tsacala María Magdalenawan jucnin María aywargan Jesuspa ayanman perfümita winapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsaynog aywarcaycaptinmi Tayta Diosnintsi cachamushgan ángil ciëlupita urämuptin patsa fiyupa sicsicyargan. Jesús pamparaycashgan sepultüraman chayaycurmi tsaparag rumita witircatsir jananman jamacuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tsay ángil elguynogragmi atsicyargan. Röpanpis rajunog yoragmi cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Angilta ricaycurmi soldäducunaga pasaypa ucacashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Warmicuna chayaptinnami ángil caynog nergan: “Ama mantsacamaytsu. Musyämi crucificaypa wanutsishgan Jesusta ricag shamushgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mananami caychönatsu caycan. Manarag wanur nishushgayquinoglami cawarimushga. Mayman pampashgantapis masqui ricay. Mananami cannatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nircurnami tsay warmicunata caynog nergan: “Cananga aywar discïpuluncunata wilapäcuy Jesús cawarimushganta. Tsaynogpis wilanqui Galileaman aywar tsaycho Jesuswan tincunanpag cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ángil tsaynog niptinmi warmicunaga mantsacashga caycashgancho fiyupa cushicushpan Jesuspa discïpuluncunata wilag apurädu aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsaynog apurädu aywarcaycaptinmi paycunata Jesús yuriparcur saludargan. Tsaymi gongurpacuycur chaquinta macalacurcur adorapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tsauraga Jesús caynog nergan: “Ama mantsacamaytsu. Discïpulöcunata wilanqui Galileaman jucla aywananpag. Tsaychönami paycunawan tincushagpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmicuna cuticäriptinmi sepultürata täpag soldäducunapis Jerusalenman aywar mandag cüracunata wilargan lapan ima pasashgancunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wilaptinmi mandag cüracunaga Israel mayor runacunawan wilanacurcur soldäducunata atsca guellayta pägargan caynog nishpan: ");
INSERT INTO qvmNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","14","“Jesuspa ayan elgashganta Pilato musyaptenga nogacunami paywan parlashag imatapis gamcunata mana jitapäshunayquipag. Gamcunanami runacunata caynog nipäcunqui: ‘Punucashgäyagmi Jesuspa discïpuluncuna tsacaypa shaycamur ayanta suwar apacushga.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tsaymi guellayta chasquircur cüracuna nishgannogla soldäducunaga aywargan runacunata wilapäcunanpag. Tsaynog wilashganpitami hasta cananyagpis Israel runacunaga mana criyipäcuntsu Jesús cawarimushganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesuspa chunca juc (11) acrashgan discïpuluncunanami Galilea provinciaman chayaycur aywapäcorgan mayninchöpis tincunanpag Jesús nishgan jircaman. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tsaychömi Jesuswan tincur payta adorapäcorgan. Payta ricaycarpis waquenga manami criyipäcorganragtsu cawarimushganta. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naupanman aywaycurmi discïpuluncunata Jesús caynog nergan: “Cay patsachöpis y gloriachöpis lapanpag munayniyog canäpagmi Tayta Dios churamashga. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsaymi gamcunata cachä may-tsay nacionpapis aywar discïpulö cananpag pï-maytapis yachatsinayquipag. Chasquicamagcunataga bautizapäcunqui Taytäpa jutincho, nogapa jutëcho y Santu Espiritupa jutincho. ");
INSERT INTO qvmNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsaynogpis paycunata yachatsinqui lapan nishgäcunata cäsucärinanpag. Cay patsa ushacaptinpis nogaga gamcunawanmi imaypis caycäshag.” Amén.");
INSERT INTO qvmNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cay libruchömi escribiraycan Tayta Diospa tsurin Jesucristupa ali wilacuynin. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jesucristuta runacuna chasquicunanpagmi puntata Juan Bautista wilacur purergan. Juan Bautista manarag yuriptinmi Tayta Diosnintsipa profëtan Isaías paypita escribergan caynog nir: “Wilacognëtami cachashag runacunata camaricatsinanpag. Tsaynogpami camaricushga canga shamuptë chasquicamänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chunyag jircachömi juc runa fuertipa wilaconga caynog nir: ‘Mandag runa shamuptin chasquicunayquipag caminuta pitsar camaricushgayquinog jutsa ruraycunata cacharir camaricäriy Tayta Diosnintsi shamuptin chasquicärinayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Isaías unay escribishgannoglami chunyag jircacho Juan Bautista puriptin Judea provinciapita y Jerusalenpita atsca runacuna pay cashgan cagman aywargan wilacushganta mayananpag. Chayaptinmi paycunata caynog nergan: “Tayta Diosnintsi perdonashunayquipag jutsa rurashgayquicunata cacharir bautizacäriy.” Juan Bautista wilacushganta chasquicurmi runacuna tantyacärergan jutsayog cashganta. Tsaymi Tayta Diosta perdonta manacuptin Jordán mayucho paycunata Juan bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan Bautistapa röpan cargan camëllupa milwanpita awashgami. Wachcunpis cargan camëllo garapita rurashgami. Chucluscunata y tinyaypa mishquinta micularmi pay purergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan Bautista wilacorgan caynog nir: “Chämonganami nogapita más munayniyog cag runa. Nogaga manami paynog munayniyogtsu cä. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nogaga yaculawanmi gamcunata bautizä. Paymi itsanga Santu Espirituwan bautizashunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tsaypitanami Galilea provinciacho cag Nazaret marcapita Jesús chayargan Juan bautizaycashgan cagman. Chayaycuptinmi paytapis Jordán mayucho Juan bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yacupita sharcurcurmi Jesús ricargan jana patsa quichacarcuptin Santu Espíritu palomanog payman uraycämogta. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tsaymi ciëlupita mayacämorgan Tayta Dios caynog nimushgan: “Gamga cuyay tsurëmi canqui. Noga munashgänog lapanta cumpliptiquimi cushishga caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsaypitanami Santu Espíritu Jesusta pushargan chunyag jircaman. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tsay jircachömi fiyu uywacuna caycashgancho chuscu chunca (40) junag Jesús goyargan Tayta Diosta manacushpan. Tsaycho caycaptinmi Satanás jutsata ruratsiyta munargan. Tsaypitami angilcunapis tsayman chayargan Jesusta yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tsaypitanami Galilea provinciaman Jesús aywargan Tayta Diosnintsipa wilacuyninta wilacunanpag. Tsay witsanga Juan Bautistata Herodes maynami carcilcho wichgaraycätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Galilea provinciacho wilacurmi Jesús caynog nergan: “Tayta Diosnintsipa maquincho ali cawanapag cag tiempo chämushganami. Tsaynog captenga wilacushgäta chasquicushpayqui jutsa ruraycunata cacharir Tayta Diosnintsi munashgannogna cawapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tsaypita Galilea lagüna cuchunpa aywaycashganchömi Jesús ricargan ishcay runacuna redninta yacuman mashtarcaycagta. Paycunami cargan Simón y wauguin Andrés. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paycunatami Jesús caynog nergan: “Discïpulö canayquipag nogawan aywashun. Gamcunata yachatsishayqui pescäduta tsarinayquipa trucanga runacunatana Tayta Diosnintsipa wilacuyninta wilapänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsaynog niptinmi redninta cachariycushpan Jesuswan aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsaypita más wac lädupa aywarcaycashganchönami ricargan Santiaguta y Juanta. Paycunaga cargan Zebedeupa tsurincunami. Büquinchömi paycunaga rednincunata altsarcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsauraga paycunatapis Jesús caynog nergan: “Discïpulö canayquipag nogawan aywashun.” Tsaynog niptinmi paycunapis Jesuswan aywapäcorgan taytan Zebedeuta y mincaynincunata büquincho cachaycur. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tsaypitanami discïpuluncunawan Jesús chayargan Capernaum marcaman. Sábado jamay junag captinmi sinagogaman yaycorgan runacunata yachatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Payga manami Moisés escribishgan leycunata yachatsegnogtsu yachatsergan, sinöga paycunapita más alimi yachatsergan. Tsaynog yachatsiptinmi runacuna pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsay sinagogachömi caycargan demonio löcuyätsishgan runa. Jesusta ricarmi tsay runacho caycag demonio gaparargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¡Nazaret marcapita cag Jesús! ¿Imatatag munanqui nogacunawan? ¿Nogacunata gargamänayquipagcu shamushcanqui? ¡Noga musyämi Dios cachamushgan Cristo cashgayquita!” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsaynog niptin Jesús olgöpargan tsay demoniuta caynog nir: “¡Upälala cay runapita jucla yarguy!” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsaynog niptinmi tsay runata tapsiriycur demonio fiyupa gaparar aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tsayta ricaycurmi lapan runacuna cushicushpan jucnin jucninpis caynog parlapäcorgan: “¡Imajinanparag munayniyog caycan demoniucuna payta cäsucunanpäga! ¡Tsaynogpis manami pipis yachatsintsu pay yachatsishgannöga!” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Demoniuta gargushganta musyarmi intëru Galilea provinciacho runacuna parlapäcorgan Jesús munayniyog cashganpita. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsay sinagogapita Jesús yargurnami Simonpa y Andrespa wayinman aywargan Santiaguta y Juanta pushacurcur. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tsayman chayananpäga Simonpa suedran fiebriwan antsa jitaraycargan. Tsaymi tsaycho caycag runacuna Jesusta wilapäcorgan tsay chacwan gueshyaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tsaynog wilaptinmi gueshyag jitaraycashganman Jesús yaycorgan. Nircur maquipita tsarircur sharcatsiptinmi jinan höra aliyargan. Chacwanga aliyarcurnami micuyta paycunata garargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Patsa tsacaycaptinnami Jesús caycashgan wayi puncuman atsca runacuna juntacargan. Tsaymanmi apapäcorgan tucuy-nirag gueshyawan gueshyagcunata y demoniucuna nacatsishgan runacunatapis Jesús aliyätsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tsaynog apapäcuptinmi Jesús aliyätsergan gueshyagcunata. Tsaynoglami runacunapita demoniucunata gargorgan. Tayta Dios cachamushgan Cristo cashganta tsay demoniucuna musyaptinmi Jesús olgöpargan imatapis mana rimacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wara tsaca tsacala marcapita Jesús aywargan chunyag jircaman Tayta Diosta manacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tsaymi Jesusta watucurir discípulu mayincunawan Simón aywapäcorgan payta ashir. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesusta tarircurna caynog nipäcorgan: “Gamtami runacuna ashiycäshunqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsaynog niptin Jesús caynog nergan: “Paycuna ashimaptinpis waquin marcacunapana aywashun Tayta Diosnintsipa wilacuyninta wilacunäpag. Waquin marcacunachöpis Tayta Diosnintsipa wilacuyninta wilacunäpagmi shamushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsaymi marcan marcan intëru Galilea provinciapa Jesús purergan Tayta Diosnintsipa wilacuyninta sinagogacunacho wilacushpan y demoniucunata runacunapita gargushpan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Juc marcachömi leprawan gueshyaycag runa Jesuspa naupanman gongurpacuycur ruwacorgan caynog nir: “Sänu canäpag aliyaycatsilämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsaynog ruwacuptinmi Jesús cuyapashpan yataycur caynog nergan: “Cananpitaga aliyashganami canqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsaynog niptinmi jinan höra aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aliyarcuptinnami Jesús payta yätsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ama pitapis wilanquitsu noga aliyätsishgäta. Tsaypa trucanga Moisés escribishgancho nishgannogpis templuman ayway aliyashgana cashgayquita cüra ricashunayquipag. Nircurna Moisés escribishgancho nishgannogla aliyashgayquipita lapantapis ruranqui. Aliyashgana cashgayquita cüra wilashuptiquimi lapanpis musyanga rasunpa aliyashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsaynog niycaptinpis tsay runaga aliyashganta pï-maytapis wilacuraycarmi Jerusalenpa aywargan. Tsaymi may-tsaypitapis runacuna Jesús cashgan cagman aywapäcorgan gueshyaycashganpita aliyätsinanpag. Aläpa runacuna juntapaptinmi Jesusga marcamanpis mana yaycorgannatsu. Chunyag jircalacho quëdaptinpis runacuna tsaymanna aywapäcorganmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Tsaypita atsca junagta Jesús yapay cutergan Capernaum marcaman. Tsaycho caycashganta musyarmi atsca runacuna chayargan pay caycashgan cag wayiman. Wayi rurincho pasaypa quichqui captinmi puncuchöpis atsca juntacargan. Tsaychömi Tayta Diosnintsipa wilacuyninta Jesús paycunata yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsaycho yachaycätsiptinmi chuscu runacuna apapäcorgan paralítico runata. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tsay wayicho runacuna atsca captinmi puncupaga tsay gueshyagta yaycatsiyta mana camäpacärergantsu. Tsaymi wayi jananman witsarcatsir wayi gataraycashganta uchcurergan. Nircur wascawan warcuypa quirmantinta urätsergan Jesuspa naupanman. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tsay runacuna payman yäracärishganta musyarmi tsay gueshyaycag runata Jesús caynog nergan: “Lapan jutsayquipita perdonashganami caycanqui, hïjo.” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gueshyagta Jesús tsaynog niptinmi Moisés escribishganta yachatseg runacuna shongulancho yarpachacärergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Imanirtag cay runa tsaynog parlan? Tayta Dioslami munayniyog caycan runacunata perdonananpag. ¡Dios-tucur tsaynog nerga lutantami rimaycan!” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsaynog yarparcaycashganta musyarmi Jesús caynog taporgan: “¿Imanirtag tsaynog yarparcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Maygantag más sasa caycan? ¿Runapa jutsancunata perdonaycu? ¿O gueshyaycashganta aliyätsiycu? ");
INSERT INTO qvmNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nogami munayniyog caycä runapa jutsancunata perdonanäpag. Tsayta musyapäcunayquipagmi cay runata aliyätsishag.” Nircur tsay gueshyaycag runata caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“¡Sharcuy! Quirmayquita apacurcur wayiquipa aywacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsaynog niptin jinan höra gueshyaycag runa aliyashgana sharcorgan. Nircur quirmanta apacurcur aywacorgan lapan runacuna ricaycaptin. Tsayta ricaycurmi runacuna cushicushpan Tayta Diosta alabargan caynog nir: “¡Manami imaypis ricashcantsitsu pitapis caynog aliyätsegtaga!” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsaypitanami Jesús aywargan Galilea lagüna cuchunman. Tsayman atsca runacuna juntacaptinmi paycunatapis yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tsaypita marcaman cutirnami ricargan Alfeupa tsurin Mateuta impuestuta cobrar jamaraycagta. Tsaymi Jesús payta caynog nergan: “Discïpulö canayquipag nogawan aywashun.” Tsaynog niptinmi Jesuswan Mateo aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsaypitanami Jesusta y discïpuluncunata Mateo gayatsergan wayincho micapäcunanpag. Tsaychömi impuesto cobrag runacuna y Diosta mana cäsucog runacunapis paywan micorgan. Paycunaga atscami Jesusta gatirpargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsauraga paycunawan juntu micuycagta ricarmi Moisés escribishgan leycunata yachatsegcuna y fariseucuna Jesuspa discïpuluncunata caynog nergan: “¿Imanirtag impuesto cobragcunawan y Diosta mana cäsucogcunawanpis talucaycur Jesús micuycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsaynog nishganta mayarmi Jesús caynog nergan: “Gueshyagcuna jampicogta nistashgannoglami jutsasapacunapis Tayta Diosnintsipa wilacuyninta pilapis tantyatsinanta nistapäcun. Nogaga manami Tayta Diosnintsi munashgannog cawag runacunalata Diospa wilacuyninta wilapänäpagtsu shamushcä, sinöga pay munashgannog mana cawag runacunatapis wilapänäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutichömi Jesusta runacuna taporgan caynog nir: “Juan Bautistapa discïpuluncuna y fariseucunapa discïpuluncunaga imaypis ayunapäcunmi. Gampa discïpuluyquicunaga ¿imanirtag paycunanog mana ayunapäcuntsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tsaynog tapuptinmi Jesús caynog nergan: “Casaray fiestaman gayatsishgan cagcuna ¿ayunanmantsurag? Casarag mözu paycunawan caycashganyäga manami ayunantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Casarag mözu wanuptinmi itsanga ayunapäcongapag. Tsaynoglami discïpulöcunapis paycunawan cashgäyäga mana ayunanmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Manami pipis macwa röpata shilpantsu mushog träpuwanga. Mushog träpoga guentir masmi rachicätsenga macwa röpata. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsayrag rurashga aswatapis manami winantsitsu shilicaycag urpumanga. Shilicaycag urpuman winaptintsega aswa pogur tsay urputa latsquiriycongami. Tsauraga aswapis jichangami y urpupis paquir ushacangami. Tsaymi sänu urpuman tsayrag rurashga aswata winantsi. Tsaynoglami nogapa yachatsicuynëpis mushog car gamcunapa costumbriquicunamanga mana tincuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sábado jamay junagchömi discïpuluncunawan Jesús pasarcaycargan trïgu poguraycag chacracuna cuchunpa. Tsaypa pasarmi Jesuspa discïpuluncuna trïguta palarcur cuparishpan micapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsayta ricarmi fariseo runacuna caynog nergan: “Sábado jamay junag mana arunapag Moisés escribishgan leycunacho niycaptenga ¿imanirtag discïpuluyquicuna trïguta palarcaycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tsaymi Jesús caynog nergan: “Sábado jamay junagcho trïguta palarpis paycunaga manami jutsatatsu rurashga. Atsca cutimi gamcuna liyipäcushcanqui David yanapagnincunawan micanar imata rurapäcushgantapis. Atsca cuti liyiycarpis ¿manacu tantyapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cüracunapa más mandagnin Abiatar caycaptin Tayta Diosta manacuna wayi rurinman David yaycur Tayta Diosnintsipag churaraycag tantata micorgan. Nircur paywan aywag runacunata tsay tantata garargan paycunapis micunanpag. Tsay tanta cüracunala micunanpag captinpis tsayta micur Davidga manami jutsata rurashgatsu.” Tsaynog nirmi Jesús tantyatsergan discïpuluncuna sábado jamay junagcho trïguta micurpis jutsata mana rurashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nircur Jesús caynog nergan: “Sábado jamay junagta Tayta Dios manami runacuna nacananpagtsu camargan, sinöga ali cawananpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nogami munayniyog caycä sábado jamay junagcho runa rurananpag mana rurananpag cagtapis ninäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tsaypita tsay marcacho sinagogaman yaycurir Jesús ricargan juc runa jucag maquin wanushga caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tsauraga chiquegnincuna Jesusta ricapaycargan sábado jamay junagcho aliyätsiptenga tsay achäquilawan contran sharcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsaynog yarpaycashganta musyarmi wanushga maquiyog runata Jesús caynog nergan: “Sharcurcur runacunapa naupanman ichicuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nircurna runacunata Jesús taporgan: “Sábado jamay junagcho ¿gueshyaycag runata aliyätsishwancu o ‘Jina nacacutsunpis’ nishwancu?” Tsaynog niptin runacuna manami imatapis nipäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mana cuyapäcog cashganta musyarmi Jesús rabianashga paycunata ricärergan. Nircurnami maquin wanushga runata caynog nergan: “¡Maquiquita jogariy!” Jogarcuptinmi maquin sänuna ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sábado jamay junagcho tsaynog aliyätsiptinmi fariseo runacuna yargurcur Herodispa favornin cag runacunawan wilanacärergan Jesusta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sinagogapita yargurirnami discïpuluncunawan Jesús aywacärergan Galilea lagüna cuchunman. Tsaypa aywaptinmi Galilea runacuna tsaytsica paypa guepanpa aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Milagro rurashgancunata musyashpanmi runacuna Jesús cagman aywargan Judea provinciapita, Jerusalenpita, Idumea provinciapita, Jordán mayu wac tsimpanpita, Tiro marcapita y Sidón marcapitapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Gueshyagcunata tsaycho aliyätsiptinmi waquin gueshyagcunapis Jesús caycashgan cagman imaycanogpa yaycuyta munapäcorgan yataylapis yataycunanpag. Tsaynog juntapaptinmi discïpuluncunata Jesús caynog nergan: “Büquita camarishgala caycätsiy runacuna aläpa quichquipämaptin tsayman witsänäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tsaychömi demoniucuna löcuyätsishgan runacunapis Jesuspa naupanman gongurpacuycur gaparashpan caynog nipäcorgan: “¡Gamga canqui lapanpag munayniyog Diospa tsurinmi!” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tsaynog gaparaptinmi tsay demoniucunata Jesús olgöpargan upälacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Tsaypitanami jircaman Jesús witsaptin paywan aywagcuna quëdargan jirca chaquincho. Nircurmi paycunapita chunca ishcayta (12) gayatsergan tsay jircaman witsänanpag. Paycunatami acrargan paywan purinanpag, Tayta Diosnintsipa wilacuyninta wilacunanpag, ");
INSERT INTO qvmNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","runacunapita demoniucunata gargunanpag y gueshyagcunata aliyätsinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tsay acrashgancunapa jutincunami cargan Simón (paypa jutinta trucatsergan Pedro cananpag) ");
INSERT INTO qvmNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","y Zebedeupa tsurincuna Santiago y Juan. Santiaguta y Juanta Jesús cuyay jutinta churapargan “Boanerges” nishpan. “Boanerges” nishganga “Räyupa Tsurin” ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Waquin cagcunapa jutinmi cargan Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeupa tsurin Santiago, Tadeo, “Celote” nishgan Simón, ");
INSERT INTO qvmNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Jesusta entregag cag Judas Iscariote. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsaypita posädaraycashgan wayiman Jesús cutiptinmi tsaymanpis atsca runacuna yapay juntacargan. Tsaymi tiempun mana cargantsu discïpuluncunawan micapäcunalanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús tsaynog caycashganta musyarmi castancuna yarpapäcorgan löcuyashga caycashganta. Tsaymi pay caycashgan cag wayiman aywapäcorgan pushananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tsaynogpis Jerusalenpita chayaycur Moisés escribishgan leycunata yachatsegcunami caynog nipäcorgan: “Cay runaga manami Tayta Diospa munayninwantsu demoniucunata runacunapita gargun, sinöga demoniucunapa mandagnin Beelzebupa munayninwanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lutanta tsaynog parlaycashganta musyarmi Jesús paycunata gayarcatsir tantyatsergan caynog nir: “Satanasga manami pitapis yanapantsu demoniucunata gargunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Musyashgantsinogpis juc nación ishcayman raquicashga car quiquinpura chiquinacorga ushacanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tsaynogpis juc wayicho tagcuna quiquinpura chiquinacorga ¿manatsurag wacpa caypa aywacur ushacanman? ");
INSERT INTO qvmNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsaynoglami demoniucunata gargunanpag Satanás pitapis yanaparga gargunacur ushacanman.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Satanaspita más munayniyog cashganta tantyatsirmi Jesús yachatsergan caynog nir: “Calpayog runa wayinta täpaycaptenga manami pipis suwapanmantsu. Tsaynog täpaycaptinpis paypita más calpayog runa shamurmi itsanga matwaycur imancunatapis apacurcur aywaconga. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Runacuna ima jutsa rurashganta y lutancunata parlashgantapis perdonta manacuptenga Tayta Dios perdonangapagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tayta Dios cachamushgan Cristo cashgäta Santu Espíritu tantyaycätsiptin conträ rimagcunatami itsanga Tayta Diosnintsi imaypis mana perdonangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Satanaspa munayninwanmi runacunapita demoniucunata garguycan” nir runacuna contran rimaptinmi Jesús tsaynog nergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsaypitami Jesuspa mamanwan wauguincuna chayargan pay yachaycätsishgan wayi puncuman. Tsaycho atsca runacuna captinmi yaycuyta mana camäpacur Jesusta gayatsergan wagtalaman. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsauraga Jesuspa naupancho waquin jamarpaycagcuna caynog wilargan: “Mamayqui y wauguiquicunami puncucho shuyarpaycäshunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Tsaynog wilaptinmi naupancho jamarpaycagcunata ricärir Jesús caynog nergan: “Paycunami mamänog y wauguëcunanog carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pipis mamänog, wauguëcunanog y panëcunanog carcaycan Tayta Dios munashgannog cawag cagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tsaypita lagüna cuchuncho Jesús yapay yachatsiptinmi atsca runacuna juntacargan. Aläpa quichquipaptinmi lagüna cuchuncho caycag büquiman Jesús witsargan tsaypitana yachatsimunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nircurnami imamanpis tincutsiypa atsca yachatsicuyta yachatsimorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yachatsimushgäta shumag tantyacäriy. Juc runashi aywargan trïgu murog. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tsayshi muruta matsiptin waquin chayargan näniman. Tsaycho matsiraycagtami pishgucuna shamur upshacurcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Waquin cag murunashi chayargan shalaman. Tsaycho winamurpis alpa aläpa mana captin shanaywan tsaquicäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin cag murunashi chayargan cashacuna rurinman. Cashacuna rurincho garwashtaycälar winamurshi mana wayorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquin cag murunashi hondu alpaman chayargan. Tsaycunaga ali winamurshi ali espïjayog cargan. Waquin espïjashi wayorgan quimsa chunca (30) trïguta, waquin espïjacunashi wayorgan sogta chunca (60) trïguta y waquinnashi wayorgan pachac (100) trïguta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tsaynog yacharcatsir Jesús caynog nergan: “Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tsaypita runacuna aywacäriptin Jesús quëdargan chunca ishcay (12) acrashgan cag discïpuluncunawan y paywan aywagcunawanpis. Imapita yachatsishganpitapis mana tantyarmi Jesusta manacärergan tantyatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tsaynog manacäriptinmi Jesús caynog nergan: “Gamcunataga tincutsiypa yachatsishgäcunata shumagmi tantyatsishayqui. Mana cäsucamagcunatami itsanga yachatsë imaman tincutsirpis mana tantyatsiylapa. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tsaynog yachatsë ricaycarpis mana tantyananpag y mayaycarpis mana chasquicunanpag. Janan shongula chasquicamarmi paycunaga jutsancunapita mana perdonashgatsu canga.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsauraga discïpuluncunata Jesús caynog nergan: “Tsay yachatsishgäta mana tantyarga masta yachatsiptëpis manami tantyanquipagtsu. Tsaymi shumag tantyanayquipag canan yachatsishayqui. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Trïgu murunogmi Tayta Diosnintsipa wilacuynin caycan. Trïgu murog runanogmi Diospa wilacuyninta wilacogcuna caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Chucru näninogmi waquin runacunapa shongun chucru caycan. Tsaynog chucru shongu carmi Tayta Diosnintsipa wilacuyninta mayarpis mana chasquicuntsu. Tsaymi mayashgalantapis Satanás gongaycatsin. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Waquin runacunapa shongonga shalanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta mayar cushishgami chasquicärin. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cushishga chasquicurpis shalacho alpa aläpa mana captin trïgu jegarcamur tsaquicäcushgannogmi paycunapis carcaycan. Tsaymi runacuna chiquiptinpis o ima nacaycho carpis cuticärin naupata cawashganmannog. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","“Waquin runacunapa shongonga casha rurincho cag alpanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta mayarpis más yarpachacun rïcu canalanpag y quiquin munashgannog cawanalanpagmi. Tsauraga tsaycunalapag yarpachacorga manami Tayta Diosnintsi munashgannogtsu cawarcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Waquin runacunapa shongonga hondu alpanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta cushishga chasquicur Tayta Diosnintsi munashgannogmi cawan. Tsaymi ali alpacho juc murulapita quimsa chunca (30) trïgu o sogta chunca (60) trïgu o pachac (100) trïgu wayushgannog tsay runa Tayta Diosnintsi munashgannog cawanga.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tsaynog nircushpanmi discïpuluncunata caynog nergan: “Manami pipis atsquita ratatsintsu cajun rurinman pacananpag, ni cawitu rurinman pacananpäga. Tsaypa trucanga alayrinninmanmi churan lapanta atsicyapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tsaynoglami gamcunapis yachatsishgäcunata pï-maytapis wilapanqui. Tsaynog wilapaptiquimi pï-maypis wilacuynëta musyangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tsaynog tantyarcatsirmi Jesús caynog nergan: “Yachatsinayquipäga nishgäcunata shumag yachacäriy. Tsaynog mayarga yachatsishgäta masmi tantyapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsaynog captenga mayganpis yachacuyta munagcunaga yachatsishgäcunata tantyangapagmi. Mana yachacuyta munagcunami itsanga mayarpis mana tantyangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","Tsaypitanami mastapis Jesús caynog nergan: “Tayta Diospa ali wilacuyninta chasquicog runa trïgu winamognogmi caycan. Trïguta muruptin puntataga pashtamun guewanoglami. Winarcurnami tsay trïgoga shicshiyta galaycun. Pogurcuptinnami cosechan. Trïgu murog runa cosecharpis manami tantyantsu murushgan trïgu imanog pashtarcamur winashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","32","Mastapis Jesús caynog nergan: “Tayta Diospa ali wilacuynenga ñäpush murunogmi caycan. Ñäpushpa muronga pasaypa tacshala caycarpis muruptin winamur waquin jachacunapitapis más jatunmi ricacun. Tsaymi pishgucunapis gueshwancunata rämancunacho ruran. Tsay tacshala murulapita ñäpush winarcamur räman mashtacashgannogmi Tayta Diospa ali wilacuynenga may-tsaymanpis chayaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tsaynoglami tincutsiypa mastapis Tayta Diosnintsipa wilacuyninta Jesús yachatsergan. Tsaynogpis yachatsergan runacuna tantyananpag-tupuylami. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imamanpis mana tincutsiypaga manami imaypis yachatsergantsu. Discïpuluncunatanami itsanga tincutsiypa yachatsishgancunata lapanta tantyatseg. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Runacunata büquipita yacharcatsimurnami patsa tsacaycaptin Jesús caynog nergan discïpuluncunata: “Acu pasashun lagüna wac tsimpaman.” Tsaynog nirmi caycashgan büquilawan wac tsimpaman aywapäcorgan. Aywaptinmi atsca büquicunawan runacunapis guepanpa aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lagünapa pasaycaptinmi fiyupa wayra galaycorgan. Tsauraga fiyupa wayraptin yacu pulchagyarmi büquita cäsi cäsi talpucätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tsaynog caycaptinpis büquicho shumag jaunacuycurmi Jesús punuraycargan. Tsaymi Jesusta discïpuluncuna fiyupa mantsacashpan ricchatsergan caynog nir: “¡Ricchay, tayta! ¡Talpucaycantsinami!” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsaymi Jesús sharcurcur wayrata y yacuta olgöpargan chawänanpag. Tsauraga jinan höra wayrawan yacu chawargan. Tsaypitanami lapanpis tranquïluna ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nircurna discïpuluncunata Jesús nergan: “¿Imanirtag gamcuna tsayjinanpa mantsacashga carcaycanqui? ¿Manacu nogaman yäracamanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsauraga discïpuluncuna quiquinpura mantsacashga caynog nipäcorgan: “Yacupis wayrapis tsaynog cäsunanpäga ¡imajinanparag munayniyog payga caycan!” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lagünata tsimparcurna chayapäcorgan Gadara nishgan partiman. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Büquipita Jesús urarcuptinmi demoniucuna löcuyätsishgan runa panteonpita yargamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Tsay runaga panteonchömi täcog. Atsca cuti runacuna cadënawan chaquinpita maquinpita watashgantapis rachirmi ushareg. Tsaynog captinmi pipis ima ruraytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tsaymi gaparaycar chunyag jircapa y panteonpa pagasta junagta puricog. Tsaynogpis rumicunawan tacacuraycarmi maypapis pureg. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tsauraga Jesusta ricarmi cörrila aywaycur paypa naupanman tsay runa gongurpacuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Payta ricaycurmi Jesús caynog nergan: “¡Demonio, yarguy cay runapita!” Tsaynog niptinmi tsay runacho cag demoniucuna fiyupa gaparashpan caynog nergan: “¡Munayniyog Diospa tsurin Jesús! ¡Cay runapita ama gargaycalämaytsu!” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsauraga tsay demoniucunata Jesús taporgan caynog nir: “¿Imatag jutiqui?” Tsaynog tapuptin demoniucuna caynog nergan: “Nogapa jutëga Legionmi. Tsay jutëga caycan tsaytsica captëmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tsaynog nircur demoniucuna Jesusta ruwacärergan tsaypita caruman mana gargunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Paycuna caycashgan washa lädunchömi ishcay waranganog (2,000) cuchicuna micurcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tsauraga tsay demoniucuna Jesusta manacärergan cuchicunaman yaycapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tsaynog manacäriptinmi cuchicunaman yaycunanpag aunergan. Tsauraga demoniucuna runapita yargurir yaycapäcorgan tsay cuchicunaman. Tsaymi cuchicunaga löcutashpan tunapa cörrir lagünaman jegacurporgan. Tsaychömi shengaypa wanupäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tsayta ricaycurmi cuchi mitsegcunaga mantsacashga cörrila aywargan marcacho tag runacunata y cercancho tag runacunatapis wilananpag. Wilapäcuptinmi runacuna aywapäcorgan ima pasashgantapis ricananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tsayman chayapäcushpanmi tsay löcu runata taripäcorgan Jesuspa naupancho aliyashgana caycagta. Ali yarpayninchöna cashpanmi röpashgana jamaraycargan. Tsayta ricaycurmi runacuna mantsacashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Cuchi mitsegcunami shamog runacunata wilargan demoniucuna löcuyätsishganpita imanogpa tsay runa aliyashganta y cuchicuna shengaypa wanushgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsayta mayaycurmi pasaypa mantsacashga lapanpis Jesusta nipäcorgan tsaypita aywacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuticunanpag büquiman Jesús witsarcuptinmi tsay aliyag runa Jesusta manacorgan paywan aywacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tsaynog manacuptinmi Jesús caynog nergan: “Nogawan aywanayquipa trucanga wayiquipa cuticuy. Tsaychöna castayquicunata wilapanqui Tayta Diosnintsi cuyapäshushpayqui aliyätsishushgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsaynog niptinmi tsay runa jinan Decápolis provinciacho mayman chayarpis wilapargan Jesús aliyätsishganta. Tsaynog wilacuptinmi lapan mayagcuna cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsaypita Jesús büquiwan lagüna wac tsimpanman chayananpäga tsaytsica runacuna juntacashga payta shuyarpaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsaymanmi chayargan sinagogacho mandag Jairo jutiyog runa. Paymi Jesuspa naupanman gongurpacuycushpan caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Warmi tsurë wanuycannami. Aywayculäshun aliyätsinayquipag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tsaynog ruwacuptin Jesús aywargan Jairuwan. Paywan aywaptinmi atsca runacuna Jesusta gatirpargan quichquiypa quichquirrag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tsay runacunawanmi aywaycargan chunca ishcay (12) watana yawar apaywan gueshyaycag warmipis. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tsay gueshyawan fiyupa nacarmi imaycancunatapis ranticur ushargan mëdicucunata pägananpag. Imanogpa jampicurpis manashi aliyargantsu. Aliyänanpa trucanga masshi antsargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesús aliyätsinanpag munayniyog cashganta musyarmi tsay warmega guepalanpa yaycuycur paypa röpanta yataycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tsaynog rurargan: “Jesuspa röpanta yataycularpis aliyäshagmi” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yataycuptinmi jinan höra yawar apaynin chawarganna. Tsaymi tantyargan aliyashgana caycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsauraga röpanta yataycur pipis aliyashganta musyarmi Jesús caynog nergan: “¿Pitag röpäta yataycamashga?” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tsauraga discïpuluncuna nipäcorgan: “Tayta, caynog quichqui aywaycaptintsega ¿imanogparag musyashwan maygan yatashushgayquitapis?” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsaynog nipäcuptinpis Jesús ricchacuycargan pï yataycushgantapis musyananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsauraga tsay warmi mantsacushpan sicsicyaycar Jesuspa naupanman gongurpacuycorgan. Nircurmi wilargan paypa röpanta yataycur aliyashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tsaynog wilaptinmi Jesús caynog nergan: “Nogaman yäracamashgayquipitami aliyashgana caycanqui. Cananga cushishgana cuticuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús tsaynog parlaycaptinragmi Jairupa wayinpita wilacog chayaycur Jairuta caynog nergan: “Tsuriqui wanushganami caycan. Amana Jesusta pushaynatsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tsaynog niptinmi Jairuta Jesús caynog nergan: “Ama laquicuytsu. Nogaman yäracamaptiquega tsuriqui cawarimongami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsaynog nircushpanmi Jairupa wayinman Jesús aywargan Pedruta, Santiaguta y Juanta pushacurcur. Waquincuna aywanantaga manami munargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairupa wayinman chayaycurmi Jesús tarergan runacuna tsaycho pasaypa laquicushpan wagarcaycagta. Tsaymi Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","“¿Imanirtag tsayjinanpa wagarcaycanqui? Jairupa tsurenga manami wanushgatsu caycan, sinöga punuycanlami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tsaynog niptinmi wanushga caycashganta musyashpan tsaycho caycag runacuna Jesús nishganta mana criyergantsu. Tsaynog captinpis lapan runacunata tsay wayipita wagtaman yargunanpag nergan. Nircurmi Jairuta, warminta y discïpuluncunata pushacurcur Jairupa tsurin tsutaraycashgan cagman yaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yaycurir wamrata maquinpita aptarcur caynog nergan: “Talita, cumi.” (“Talita, cumi” nishganga “Jipash, sharcuyna” ninanmi.) ");
INSERT INTO qvmNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tsaynog niptinmi Jairupa tsurin jinan höra cawarircamur sharcurcur purergan. (Payga cargan chunca ishcay (12) watayognami.) Jipashita cawarimushganta ricaycurmi lapan tsaycho cagcuna pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nircurmi mamanta y taytanta Jesús nergan aliyätsishganta pitapis mana wilapänanpag. Nircurnami jipashitata garananpag nergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tsaypitana discïpuluncunawan Jesús aywargan Nazaret marcanman. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado jamay junag captinmi yaycorgan sinagogaman. Tsaycho yachatsiptinmi runacuna caynog nergan: “Cay runaga ¿maychötag tsayjinanpa yachacuycushga? Tsaynogpis ¿imanogpatag milagrucunata ruran? ");
INSERT INTO qvmNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manacu payga caycan Mariapa wawan? Tsaynogpis ¿manacu payga carpintëro? ¿Manacu Santiago, José, Judas y Simonpis paypa wauguin caycan? Tsaynoglami panincunatapis reguintsi.” Tsaynog nirmi Jesús yachatsishgancunata mana chasquicärergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsaymi Jesús nergan: “Waquin marcacunacho Tayta Diosnintsipa profëtanta chasquicäriptinpis castancuna y marca mayincunaga manami chasquicärintsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsaynog nirmi juc ishcay gueshyagcunalata quiquinpa marcancho aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Marca mayincuna payman mana yäracuptinmi Jesús pasaypa laquicorgan. Tsaypitanami marcacunapapis y jalgacunapapis runacunata yachatsiraycar Jesús purergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nircurmi chunca ishcay (12) acrashgan cag discïpuluncunata gayaycur Jesús nergan may-tsaypapis ali wilacuyninta wilacog ishcay ishcay aywananpag. Tsaynogpis nergan paypa jutincho runacunapita demoniucunata gargunanpag. Nircurmi paycunata caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“May marcapa aywarpis ama apapäcunquitsu guepinayquita, mircapayquita ni guellayniquitapis, sinöga tucrulayquita apanqui. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jatirashgayqui llanquilayquiwan aywanqui. Ama apapäcunquitsu trucacunayquipag röpayquitapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","May marcaman chayarpis posädacushgayqui wayilacho posädacärinqui juc marcapa pasanayquiyag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","May marcachöpis mana chasquishuptiquega tsaypita aywacärinqui llanquiquicho caycag polvuta tapshirishpayqui. Tsaynog ruranqui Tayta Diosnintsi paycunata juzgananpag cashganta tantyacunanpag. Tsaynog mana chasquishushgayquipitami Sodoma y Gomorracho tag runacuna infiernucho nacananpag cashganpitapis paycuna más fiyupa infiernucho nacangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsaynog niptinmi acrashgan cag discïpuluncuna aywargan marcan marcan Tayta Diosnintsipa wilacuyninta wilacuraycar. Tsaynogpis wilacärergan jutsa rurashgancunata cacharir Tayta Dios munashgannogna cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tsaynog wilacur purirmi demoniucunatapis runacunapita gargorgan. Tsaynogpis gueshyagcunapa umanman aceitita winaparcur Tayta Diosta manacorgan aliyätsinanpag. Tsaynogpami gueshyashganpita atsca runacuna aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Milagrucunata Jesús rurashgancunapitami may-tsaychöpis runacuna parlapäcorgan. Waquin runacuna nipäcorgan Tayta Diosnintsipa profëtan Elías cashganta. Y waquinnami nipäcorgan unay profëtacunanog profëta cashganta. Tsaynog parlapäcushganta mayarmi rey Herodes caynog nergan: “Tsay runaga Juan Bautistami cawarimushga canga. Cawarimushga carmi munayniyog caycan milagrucunata rurananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Naupatami Herodisga wauguin Felipipa warmin Herodiasta suwargan warmin cananpag. Tsaynog suwashga captinmi Juan Bautista caynog nergan: “Wauguiquipa warminta suwamushpayqui jutsatami rurashcanqui.” Tsaynog nishganpitami Juan Bautistata Herodes carcilman wichgatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Carcilman wichgatsirpis jutsaynag ali runa cashganta musyashpanmi Juanta Herodes respitargan. Tsaymi warmin Herodías Juanta wanutsiyta munaptinpis rey Herodisga imaycanogpapis payta tsapargan pipis mana wanutsinanpag. Itsanga Juan wilacushgan ali cashganta tantyarpis Herodes manami chasquergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsaypita rey Herodes diancho fiestata rurarmi gayatsergan autoridäcunata, soldäducunapa más mandagnincunata y Galileacho tag rïcu runacunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mësacho lapan jamarpaycaptinmi Herodiaspa jipash wawan yaycurir gatswargan. Tsaynog gatswashganta ricarmi pasaypa cushicorgan rey Herodes y mësacho jamaraycag runacunapis. Tsauraga jipashta rey Herodes caynog nergan: “Manacamay imata munashgayquitapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","‘Mandashgayqui nacionta pulanta raquipaycamay’ nimaptiquipis raquipäshayquimi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsaynog niptin maman cagman tsay jipash aywaycur taporgan caynog nir: “¿Imatatag manacöman, mamä?” Tsauraga maman caynog nergan: “Juan Bautistata wanurcatsir paypa umanta apamunanpag manacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maman tsaynog yätsiptinmi rey Herodes cagman cutiycur caynog nergan: “Noga munä canan höra Juan Bautistapa umanta plätucho gomänayquitami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","27","Tsaynog manacuptinmi rey Herodes pasaypa laquicorgan. Juanta wanutsiyta mana munarpis gayatsishgancunapa naupancho tsay jipashta promitishga carmi wardiata cachargan Juanpa umanta rogurir tsay jipashta goycunanpag. Tsaymi carcilman wardia aywaycur Juanta wanutsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nircurna umanta roguriycur plätuwan apaycur jipashta entregargan. Chasquircurnami jipashga mamanta entregaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsaynog rurashganta mayaycur Juanpa discïpuluncuna aywar ayanta shuntacärergan pampananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesuspa apostolnincunanami ali wilacuyta wilacushganpita lapan cutipäcamorgan. Nircurnami Jesusta wilapäcorgan may-tsaychöpis yachatsir purishgancho imanog cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Atsca runacuna payman juntapaptin micunanpagpis tiempun mana captinmi apostolnincunata Jesús caynog nergan: “Acu aywashun chunyagninman tsaycho jamapänantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsaynog nirmi apostolnincunawan büquiman Jesús witsarcur lagünata pasapäcorgan chunyagninman aywananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tsaypa aywaptinpis runacuna tantyargan maypa aywaycashgantapis. Tsaymi may-tsay marcacunapita apurayla aywapäcorgan Jesuspita más puntata chunyagman chayananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Büquipita urarcurnami Jesús tarergan atsca runacuna tsaycho shuyarpaycagta. Mitsegniynag uyshacunanog caycagta ricarmi Jesús cuyapashpan paycunata yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Patsa tardiyaptinnami Jesusta discïpuluncuna nipäcorgan: “Caychöga manami imapis cantsu runacuna micunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tardina caycaptenga lapan runacuna aywacutsun micuyta rantipäcunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tsaynog niptin Jesús caynog nergan: “Manami paycunaga micuy asheg aywanmantsu. Paycunataga micuyta gamcuna garapäcuy.” Tsaynog niptinmi discïpuluncuna caynog nipäcorgan: “¿Imatatag paycunata garapäcushag? ¡Pusag (8) quilla arur gänashgantsinogragmi guellay aypanga caytsica runacunata garapäcunäpäga!” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tsaynog niptin Jesús nergan: “Guepiquicho ayca tantayqui cashgantapis ricapäcamuy.” Ricaycurmi caynog nipäcorgan: “Caycan pitsga tanta y ishcay pescädulami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nircur discïpuluncunata Jesús nergan runacunata raquircur raquircur pashpaman jamatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tsaynog niptin jamacärergan pachac-cama (100) y pitsga chunca-cama (50). ");
INSERT INTO qvmNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tsaypitanami pitsga tantata y ishcay pescäduta aptarcur Jesús jana patsata ricärishpan Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paquircur discïpuluncunata macyargan lapan runacunata aypunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsaymi lapan micapäcorgan sacsashganyag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nircurna putsushgancunata discïpulucuna shuntapäcorgan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tsaycho micogcunaga cargan pitsga waranga (5,000) runacunami. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsaypitana discïpuluncunata Jesús nergan büquiman witsarcur Betsaida marcaman naupapäcunanpag. Discïpuluncuna aywacuptinmi tsaycho cag runacunata despachapacur Jesús quëdacorganrag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nircurnami jircaman witsargan Tayta Diosta manacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Patsa tsacaycaptinnami discïpuluncuna büquiwan carutana aywaycargan. Tsayyäga jircalachöragmi Jesús caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tsaypita ricargan wayra cutitsimuptin büquiwan nacar discïpuluncuna aywaycagta. Walpa wagay höranog captinnami paycuna cagman yacu jananpa Jesús aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Büqui naupanpa pasag-tucuycaptinmi discïpuluncuna payta ricargan. Tsaymi alma cashganta yarpashpan fiyupa mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tsaynog mantsacuptinmi Jesús caynog nergan: “¡Ama mantsacamaytsu! Nogami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsaynog nir büquiman witsarcuptin wayrapis jucla chawargan. Tsaycunata ricarmi discïpuluncunaga pasaypa mantsacashganog ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paycunaga pitsga waranga (5,000) runacunata garananpag milagruta rurashganta ricarpis manami tantyapäcorgantsu rasunpa munayniyog Jesús cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Galilea lagünata tsimparcurnami chayapäcorgan Genesaret pampaman. Tsaychömi discïpuluncuna büquita watargan yacu mana apananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Büquipita Jesús urarcuptinnami runacuna jucla payta reguipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jesús tsaycho cashganta mayashpanmi may-tsaypitapis runacuna gueshyagcunata quirmawan apargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tsaypita marcacunapa y jalgacunapapis Jesús puriptinmi pasananpag cag nänimanpis gueshyagcunata churapäcorgan. Tsaypa pasaptinmi gueshyagcuna payta ruwacärergan röpanpa cuchunta yataylapis yataycunanpag. Lapanpis Jesuspa röpanta yataycogcunaga aliyarganmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Juc cutimi Jerusalenpita aywar fariseucuna y Moisés escribishgan leycunata yachatsegcuna Jesús cagman chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsaychömi Jesuspa discïpuluncuna maquinta mana maylacuylapa micuycagta ricar paycuna jamurpargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseucuna y Israel mayincunaga unay runacunapa costumbrincunata cumplirmi manarag micur maquintarag maylacog limpio caycaptinpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tsaynog costumbricunata cumplirmi pusilluncunatapis, plätuncunatapis, mancancunatapis, y catrincunatapis maylagrag limpio caycaptinpis. Tsaynogmi rantipacushganpita cutirpis maquinta manarag maylacorga mana jamacäregtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsaymi fariseucuna y Moisés escribishgan leycunata yachatseg runacuna Jesusta tapupäcorgan caynog nir: “¿Imanirtag discïpuluyquicuna unay runacunapa costumbrincunata mana cäsur micapäcunanpag maquincunata mana maylacuntsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tsaynog nipäcuptinmi Jesús caynog nergan: “¡Ishcay cära runacuna! Gamcuna tsaynog canayquipag cashganta musyarmi Santu Espíritu profëta Isaiasta tantyatsergan caynog escribinanpag: ‘Cay runacunaga janan shongulami: “Tayta Dios, Tayta Dios” nipäcaman. Tsaynogpis manami lapan shongunwantsu nogata chasquicaman. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Paycunaga wilacuynëta yachatsinanpa trucanga runacunapa costumbrilantami yacharcaycätsin. Tsaynog captinmi adorapäcamaptinpis paycunata mana cäsupäshagtsu.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Mastapis Jesús caynog nergan: “Isaías nishgannoglami gamcunapis Tayta Diosnintsipa leynincunata mana cäsucurcaycanquitsu. Cäsucunayquipa trucanga runacunapa costumbrincunalatami cumplircaycanqui. Tsaymi wichicunatapis pusillucunatapis y más waquincunatapis maylanquirag. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés escribishganchöga caynogmi niycan: ‘Mamayquita y taytayquita ali ricanqui. Pipis mamanta o taytanta maldicionag cäga wanutsishga catsun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mamayquita y taytayquita ali ricanayquipag niycaptinpis gamcunaga manami yanapaycanquitsu. Tsaymi runacunata yachaycätsinqui: ‘Tayta Dioslapagmi imaycäpis caycan’ nerga mamanta y taytanta manana yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tsaynog yachatsirmi gamcunaga Tayta Diosnintsipa palabranta manacagman churarcaycanqui. Tsaynoglami imatapis gamcunaga quiquiqui yarpashgalayquita rurarcaycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nircurnami runacunata gayaycur Jesús caynog nergan: “Cay nishgäcunata lapayqui shumag tantyacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Manami imatapis micushganpitatsu pipis jutsayog ricacun, sinöga shonguncho mana alita yarpashganpitami. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsaytsica runacuna tsaycho captinmi paycunapita witicushpan juc wayiman discïpuluncunawan Jesús aywargan. Tsaychönami discïpuluncuna ruwacorgan yachatsishgancunata tantyatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","20","Tsaymi Jesús caynog nergan: “¿Gamcunapis manacu tantyapäcunquirag? ¿Manacu runa imata micushganpis pasagla caycan? Tsaymi micushganpitatsu runaga jutsayog ricacun, sinöga shonguncho lutancunata yarpashganpitami.” Jesús tsaynog nergan ima micuypis ima aytsapis micunantsipag ali cashganta tantyatsishpanmi. Nircur mastapis Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","“Shonguncho lutancunata yarpachacurmi adulterio jutsata rurapäcun, runacuna chinëru capäcun, warmicunapis waynan waynan puricärin, wanutsinacärin, ");
INSERT INTO qvmNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","suwacärin, codiciöso capäcun, lulacärin, chiquinacärin, jucpa wasanta rimapäcun, yachag-tucärin y ima jutsacunatapis rurapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lapan tsay mana ali ruraycunaga shonguncho lutanta yarpashganpitami caycan. Tsaynogpami runacuna jutsayog ricacun.” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","26","Tsaypita Jesús aywargan Sirofenicia nacioncho cag Tiro marcapa. Tsayman chayashganta runacuna mana musyananpagmi pipis mana ricayla juc wayiman posädacorgan. Tsaynog captinpis juc warmi musyargan Jesús tsayman chayashganta. Paypa wawantami gueshyawan demonio nacaycätsergan. Tsaymi Jesús cagman aywaycur paypa naupanman gongurpacuycur ruwacorgan wawanpita demoniuta gargunanpag. Tsay warmega manami Israel warmitsu cargan, sinöga jinan Sirofenicia nacionpitami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsaynog ruwacuptinmi Jesús nergan: “Puntataga yanapashag Israel mayëcunataragmi. Gamcunata yanapaptëga canman wamracunapa tantanta guechurir algucunata jitapaycognogmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tsaynog niptin warmi nergan: “Au, tayta. Tsaynog captinpis wamracuna shicwapacushgantami algucunapis micapäcun.” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tsaynog niptin Jesús nergan: “Tsaynog niycanqui rasunpa yäracamashpayquimi. Tsaynog yäracamashgayquipitami wawayquita nacatseg demonio yargushgana caycan. Cananga wayiquipa cushishga cuticuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsaynog niptin wayinman cutirmi wamranta tarergan aliyashgana cämancho caycagta. Wamrata gueshyatseg demonioga yargucushganami caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro marcapitanami Jesús pasargan Sidón marcapa. Tsaypita cutirnami Galilea lagüna cuchunpa pasar chayargan Decápolis provinciaman. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tsaycho caycaptinmi apapäcorgan mana mayag ni mana rimag runata. Chayaycatsirna Jesusta ruwapäcorgan tsay upata aliyätsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsauraga quiquilanta juc läduman pusharcur upapa rinrinman dëdunta Jesús jatergan. Nircur togayninwan dëdunta ushmarcatsirmi upapa galluntapis yataycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsaynog rurarcurna jämayta cacharcur jana patsata ricärir: “¡Efata!” nergan. (“Efata” ninanga caycan “¡Quichacay!” ninanmi.) ");
INSERT INTO qvmNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tsauraga jinan höra upapa rinrin mayargan y shiminpis pashtarganna. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tsaynog aliyarcatsirmi tsaycho caycag runacunata Jesús nergan aliyätsishganta pitapis mana wilapänanpag. Tsaynog niycaptinpis pï-maytapis wilapargan upata Jesús aliyätsishganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Milagruta Jesús rurashganpita pasaypa cushicur may-tsaychöpis tincushgan runacunata caynog nipäcorgan: “¡Imaycatapis Jesusga ruraycun pasaypa espantaypagmi! ¡Cananga upacunapis mayannami y mana rimagcunapis parlannami!” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tsaypita atsca runacuna Jesús cagman juntacaptin micapäcunanpag imapis mana cargantsu. Tsaymi discïpuluncunata Jesús gayaycur caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cuyapämi caycho nogantsiwan caycag runacunata. Paycuna quimsa junagnami nogantsiwan caycho caycan micuyta mana yawaylapa. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waquin cäga shapäcamushga caru marcapitami. Micönila wayincunapa cuticunanpag niptëga aywaycaptilannami vëtapis tsarenga.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tsaynog niptinmi discïpuluncuna nergan: “¿Chunyag jircacho caycarga maychörag tarishwan micuyta caytsica runacunapäga, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tsauraga paycunata Jesús taporgan: “¿Aycalatag tantayqui caycan?” Tsauraga nipäcorgan: “Ganchislami caycan, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsaynog niptinmi lapan runacunata nergan jamacärinanpag. Jamacäriptinnami ganchis tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata macyargan paycuna aypupäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tsaynoglami juc ishcay acapala pescädutapis Jesusman apapargan. Tsaycunatapis aptarcushpan Tayta Diosta manacur agradëcicorgan. Nircur tsaycunatapis discïpuluncunata macyargan runacunata aypunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsaymi lapan micapäcorgan sacsashganyag. Putsushgancunatanami shuntargan ganchis canasta juntata. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsaycho micogcunaga cargan chuscu waranganogmi (4,000). Micuyta usharcuptinnami lapan runacunata Jesús despachargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsaypitanami büquiman witsarcur discïpuluncunawan Jesuspis aywacorgan Dalmanuta nishgan partiman. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dalmanuta nishgan partiman chayaycuptinmi fariseucuna aywaycur Jesusta achäquita ashipar caynog nipäcorgan: “Tayta Diosnintsi rasunpa cachamushushgayquita musyapäcunäpag mä ima milagrutapis ruray.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tsaynog niptinmi Jesús laquicushpan caynog nergan: “¿Imanirtag munarcaycanqui milagrutarag ruranäta? Gamcuna munashgayquinöga manami ima milagrutapis rurashagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nircurna runacunata tsaycho cachaycur büquiman witsarcushpan discïpuluncunawan aywacorgan lagünapa jucag cuchunman. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lagünata tsimpaycashganchömi Jesuspa discïpuluncuna yarparcorgan mircapanpag juc tantalata aparcaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tsaymi Jesús caynog nergan: “Fariseo runacunapa y rey Herodispa levadüranta cuidädu chasquipäcunquiman.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tsaynog niptin discïpuluncuna quiquinpura caynog nipäcorgan: “Tantata mana mircapacamushgantsipitami tsaynog niycämantsi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsaynog parlaycashganta tantyarmi Jesús nergan: “¿Imanirtag parlarcaycanqui tantata mana apamushgayquipita? ¿Gamcuna manacu tantyapäcunquirag imata niycashgätapis? ");
INSERT INTO qvmNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Milagrucunata rurashgäta ricaycarpis gamcunaga mana ricagnogmi carcaycanqui. Yachatsishgäcunata mayaycarpis mana mayagnogmi carcaycanqui. ¿Manacu yarpapäcunqui ricashgayquita y mayashgayquitapis? ");
INSERT INTO qvmNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pitsga tantalapita pitsga waranga (5,000) runacunapag milagruta rurashgäpita putsogta ¿ayca canasta juntatatag shuntapäcorgayqui?” “Chunca ishcay (12) canasta juntatami shuntapäcorgä, tayta” nipäcorgan discïpuluncuna. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Tsaynogpis ganchis tantata chuscu waranga (4,000) runacunapag milagruta ruraptë putsogta ¿ayca canastatatag shuntapäcorgayqui?” “Ganchis canasta juntatami shuntapäcorgä, tayta” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsauraga Jesús nergan: “Milagrucunata rurashgäta ricaycarpis ¿manacu tantyapäcunquirag?” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsaypita discïpuluncunawan Jesús chayargan Betsaida marcaman. Tsaycho caycaptinna payman pushapäcorgan gapra runata. Nircur ruwapäcorgan gaprata aliyätsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tsauraga maquinpita janchacurcur marcapita Jesús jorgorgan. Tsaychöna gaprapa nawinman togaycur maquinta jananman churargan. Nircurna taporgan: “¿Ricanquinacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tsauraga gapra rama ramala ricar nergan: “Au, ricänami rama ramalaga runacunata yöracunanog caycagta. Itsanga purircaycanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsauraga nawinta yapay yataycuptin shumagna ricargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsaynog aliyarcatsirmi tsay runata Jesús nergan: “Marcaman mana chayaylapa y pitapis mana wilapaylapa wayiquiman cuticuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsaypita Jesús discïpuluncunawan aywargan Cesarea de Filipuspa caseriuncunaman. Aywarcaycashganchömi discïpuluncunata Jesús caynog nir taporgan: “¿Pï cashgätatag nogapag runacuna yarpapäcun?” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tsaynog tapuptin discïpuluncuna caynog nipäcorgan: “Waquin runacunaga nipäcun Juan Bautista cashgayquitami. Waquinnami nipäcun Elías cashgayquita. Y waquinnami nipäcun maygan profëtapis cawarimushga cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tsaynog niptin paycunata Jesús taporgan: “Gamcunaga, ¿pï cashgätatag yarpapäcunqui?” Tsauraga Pedro nergan: “Gamga Tayta Dios cachamushgan Cristumi canqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsaynog niptinmi Jesús caynog nergan: “Tsaytaga pitapis ama wilapanquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tsaypitanami discïpuluncunata Jesús wilapargan caynog nir: “Noga fiyupa nacatsishgaragmi cashagpag. Israel mayor runacuna, mandag cüracuna y Moisés escribishgan leycunata yachatsegcuna conträ sharcurmi wanutsimanga. Tsaypita quimsa junagtaga cawarimushagpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tsaynog cananpag cashganta wilapaptinmi Jesusta Pedro gayargan juc läduman quiquilanta parlapänanpag. Nircurnami Jesusta nergan wanutsinanpag cashganta musyaycarga Jerusalenman mana aywananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tsaynog niptinmi Jesús tantyargan Pedro tsaynog parlananpag Satanás yarpayta goshganta. Tsaymi Pedruta Jesús caynog nergan: “¡Naupäpita witicuy, Satanás! Tsaynog michämashpayquega manami munanquitsu Tayta Diosnintsi munashganta ruranäta, sinöga yarpashgayquinogla cananta munarmi tsapata churapaycämanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nircur discïpuluncunata y runacunata gayaycur caynog nergan: “Pipis discïpulö cayta munarga shongun yarpashgannog jutsata rurar ama cawatsuntsu. Tsaypa trucanga imanog nacarpis noga munashgänogla imaypis cawatsun. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Noga munashgänog cawananpa trucan quiquin munashgannog cawagcunaga infiernuman gaycushgami cangapag. Ima nacaycho carpis noga munashgänog cawagcunami itsanga gloriaman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Infiernuman gaycushga cananpag caycaptenga ¿imapagtag välin mayjina rïcu cashganpis? ");
INSERT INTO qvmNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mayjina rïcu carpis manami rïcu cashgalanwanga salvacionta rantengatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pipis runacunapa naupancho nogapita y wilacuynëpita pengacuptenga nogapis Tayta Diospa angilnincunawan chip-chipyaycar cutimushpä payta manami cäsushagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tsaypita Jesús caynog nergan: “Manarag wanurmi waquinniqui ricamanquipag lapanpagpis munayniyog cashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tsaypita sogta junagtami Pedruta, Santiaguta y Juanta pushacurcur Jesús witsargan jirca puntaman. Tsaychömi paycuna ricaycaptin pasaypa chip-chipyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tsaynogmi röpanpis rajunog yorag ricacur empañayparag atsicyargan. Mayjina tagsharpis manami pipis tsaynöga yoragätsintsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tsaychömi ricapäcorgan Moisés y Elías yuriparcur Jesuswan parlaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Tsayta ricaycurmi paycuna mantsacashga ricacorgan. Tsauraga Pedro mana yarpachacuylapa caynog nergan Jesusta: “Alipagmi nogacuna cayman shapäcamushcä, tayta. Cananga rurapäcushag quimsa tsuclata: jucta gampag, jucta Moisespag y jucta Eliaspag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsaynog parlaycaptinmi pucutay tsapacurcorgan. Tsaypitami Tayta Diosnintsi caynog nimorgan: “Payga cuyay tsurëmi. Pay nishushgayquicunata cäsucäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsaypitaga yapay ricärinanpagmi Jesús japalanna caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nircurnami jircapita cutiycämur paycunata Jesús caynog nergan: “Jircacho ricashgayquita pitapis ama wilapanquiragtsu wanushgäpita noga cawarimunäyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tsaynog Jesús niptinmi paycunaga tsay ricashgancunata pitapis mana wilapargantsu. Tsaynog carpis “Wanushgäpita cawarimushagmi” nishganta manami tantyargantsu. Tsaymi quiquinpura parlarcaycargan: “¿Imanirtag niycämantsi cawarimunanpag cashganta?” nir. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsaypitanami paycuna Jesusta taporgan caynog nir: “Moisés escribishgan leycunata yachatsegcuna nipäcun Cristo shamunanpag puntata Eliasrag shamunanpag cashgantami. Tsaynog niycaptenga ¿imanirtag Elías mana shamunragtsu?” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Tsaynog niptinmi Jesús caynog nergan: “Elías yapay shamunanpag cashganta nipäcushgannoglami Elías mayna shamushga. Elías shamur wilacuptinpis manami runacuna chasquicushgatsu wilacushganta. Chasquicunanpa trucanga payta wanutsipäcorgan Tayta Diosnintsipa palabrancho nishgannoglami. Tsaynoglami runacuna nogatapis chiquimar fiyupa nacatsimangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Quimsa discïpuluncunawan Jesús tsay jircapita cutimurmi tarergan Moisés escribishganta yachatsegcunawan waquin cag discïpuluncuna rimanacuycagta. Paycunatami atsca runacuna juntaparaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsayman Jesús chayaycagta ricarmi runacuna cushishga cörrila taripargan saludananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nircurmi discïpuluncunata Jesús taporgan caynog nir: “¿Imanirtag Moisés escribishganta yachatsegcunawan rimanacurcaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsaynog tapuycaptinmi juc runana caynog nergan: “Demonio upayätsishgan tsurëtami apamushcä aliyätsipämänayquipag, tayta. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maycho caycaptinpis tsay demoniumi elagpita tsurëta gaparätsin, pampaman sagtan, pogshaytapis agtutsin y quiruntapis uchutsin. Tsaynogpis wanuy gueshyami tsarin. Tsaymi discïpuluyquicunaman apamuptëpis demoniuta garguyta mana camäpacushgatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tsaymi Jesús caynog nergan tsaycho cag runacunata: “¡Yäracuyniynag runacuna! ¿Imayyagrag gamcunawan caycäshag? Mä apamuy tsay mözuta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsauraga Jesuspa naupanman tsay mözuta apapäcorgan. Tsaymi Jesusta ricärir mözuta demonio pampaman sagtariycorgan. Tsaymi tsay mözu pogshayta agtur pampacho gochpargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tsauraga mözupa papäninta Jesús taporgan caynog nir: “¿Imaypitanatag tsuriquita demonio tsaynog nacaycätsin?” Tsaynog tapuptin papänin nergan: “Wamra cashganpita-patsami tsaynog nacaycätsin, tayta. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Atsca cuti wanutsiyta munashpanmi ninamanpis yacumanpis tsay demonio sagtashga. Tsaynog mana nacananpag tsurëta aliyätsipaycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tsaynog ruwacuptinmi Jesús caynog nergan: “Rasunpa yäracamaptiquega aliyätsipäshayquimi. Yäracamagcunapäga manami imapis sasatsu caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsauraga mözupa papänin cushishga caynog nergan: “Shumag mana yäracuptëpis yanapaycalämay lapan shongöwan gamman yäracunäpag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsauraga atsca runacuna burrurruyla aywaycämogta ricarmi tsay mözucho caycag demoniuta jucla Jesús gargorgan caynog nir: “¡Upayätseg y mana rimatseg demonio! ¡Cay mözupita jucla yarguy! ¡Cananpitaga imaypis amana cutiynatsu cay mözuman!” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsauraga tsay demonio gaparar yapay sagtargan mözuta. Nircurna yargurir aywacorgan wanushgatanog cachariycur. Tsaynog jitaraycagta ricarmi runacuna yarpapäcorgan wanushgana cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tsauraga maquipita tsarircur Jesús tsay mözuta aliyashgatana sharcatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsaypitana discïpuluncunawan Jesús juc wayiman yaycorgan. Tsaychönami discïpuluncuna Jesusta taporgan caynog nir: “¿Imanirtag nogacuna garguyta mana camäpacushcätsu tsay demoniuta?” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tsauraga Jesús nergan: “Ayunar Tayta Diosnintsita manacurragmi tsay-nirag demoniutaga gargunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsaypita aywacushpannami discïpuluncunawan pasapäcorgan Galilea provinciapa. Discïpuluncunawan parlacunan cashgami Jesús mana munargantsu tsayman aywashganta runacuna musyananta. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tsaychömi discïpuluncunata Jesús caynog nergan: “Juc runami nogata entregamanga conträcunapa maquinman. Tsaynog captinpis wanutsimashganpita quimsa junagtami cawarimushagpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tsauraga Jesús nishgancunata paycuna manami tantyapäcorgantsu. Tsaynog mana tantyarpis tapuytami itsanga mantsacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsaypita Capernaum marcaman chayaycur wayicho caycashpanna discïpuluncunata taporgan caynog nir: “Nänipa shamur ¿imapita parlartag aywaycämushcanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Discïpuluncunaga mandag cayta guechunacur rimanacushga carmi Jesús tapuptinpis pengacushpan upälacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsaypita Jesús jamaycushpan chunca ishcay (12) discïpuluncunata caynog nergan: “Mayganiquipis más munayniyog cayta munarga ashmaynogla pï-maytapis yanapay.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nircurnami juc wamrata margarcur paycunata caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Cay wamratanog mana cäsushga cagcunata chasquicorga nogata chasquicamagnogmi carcaycanqui. Nogata chasquicamarga cachamag Taytätapis chasquicuycanquimi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tsauraga discïpulun Juan caynog nergan: “Nogacuna ricapäcushcä juc runata gampa jutiquicho demoniucunata garguycagta, tayta. Tsaymi nogantsiwan mana puriptin jutiquita mana jogarinanpag michäpäcushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsauraga Jesús caynog nergan: “Cananpitaga ama michanquitsu. Nogantsiwan mana purirpis jutëcho demoniucunata gargorga alitami ruraycan. Tsaynog carga manami conträtsu caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pipis contrantsi mana sharcorga favornintsimi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chasquicamagcunata pipis noga-raycu juc pusillu yaculatapis macyaptenga Tayta Diosnintsi paytapis premiutami gongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús mastapis caynog nergan: “Tayta Diosman yäracogta cuidädu pitapis jutsaman tunitsinquiman. Jutsaman tunitsicogcunataga más alimi canman mulïnu rumita cuncanman wataparcur lamarman garpuriptinpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Tsaynog cananpag caycaptenga maquiqui jutsata ruratsishuptiqui roguriycuy. Imaypis mana upeg ninaman ishcan maquiquiwan gaycushga canayquipa trucanga más alimi canman juc maquiyoglapis Tayta Diosnintsipa naupanman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Infiernuman chayagcunaga mana ushacaypami nacangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Chaquiquipis jutsata ruratsishuptiquega roguriycuy. Imaypis mana upeg ninaman ishcan chaquiquiwan gaycushga canayquipa trucanga más alimi canman juc chaquiyoglapis Tayta Diosnintsipa naupanman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Infiernuman chayagcunaga mana ushacaypami nacangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nawiquipis jutsata ruratsishuptiquega ogtiriycuy. Ishcan nawiyog infiernuman gaycushga canayquipa trucanga más alimi canman wiscu nawilapis Tayta Diosnintsipa naupanman chayaptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Infiernuman chayagcunaga mana ushacaypami nacangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Jutsata mana cachagcunaga lapanmi infiernucho imayyagpis nacapäcongapag. Noga nishgäcunata chasquicogcunami itsanga cay patsacho mayjina nacarpis gloriaman chayar ali cawangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Musyashgayquinogpis cachega alimi caycan micuyta gustuta gonanpag. Micuyta gustuta gonanpag cachi ali cashgannog gamcunapis runa mayiquiwan cuyanacur ali cawapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaumpita Jesús aywashpan chayargan Judea provinciaman. Nircurna pasargan Jordán mayu tsimpanman. Tsaychöpis atsca runacuna juntapaptinmi Jesús yachatsergan imaypis yachatsishgannogla. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsaycho yachaycätsiptinmi fariseo runacuna aywaycur lutanta rimatsinan cashga ali shimilanpa Jesusta tapupäcorgan caynog nir: “¿Warminpita runa raquicanmancu o manacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsauraga Jesús nergan: “Moisés escribishgancho ¿imatatag niycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tsaynog niptinmi fariseucuna nipäcorgan: “Moisés yachatsergan pipis warminpita raquicayta munarga papilta firmaparcur raquicänanpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsauraga Jesús caynog nergan: “Moisés tsaynog yachatsergan runacuna mana cäsucog captinmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Musyashgantsinogpis Tayta Diosnintsimi cay patsata camar olguta y warmita camargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘Tsaynog captinmi warmita ashir runa promitin mana raquicaypa tänanpag. Tsaymi majatsacarna mamanpa y taytanpa maquincho caycashganpita runa yargucun warminwan tänanpag. Warminwan tarnami jäpa jäpa carpis paywan tsay castalana ricacun.’ Tsaynog cananpag Tayta Dios niycaptenga mananami ishcay castanatsu caycan, sinöga juc castalanami caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tsaymi Tayta Diosnintsi juclatsashgantaga pipis mana raquinmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsaypita posädacushgan wayicho caycarnami discïpuluncuna Jesusta tapupäcorgan tsay yachatsishganpita. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tapuptin Jesús caynog nergan: “Pï runapis warminpita raquicaycur juc warmiwan targa adulterio jutsatami ruraycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsaynogla pï warmipis runanpita raquicarcur juc runawan targa adulterio jutsatami ruraycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsaypitanami wamracunata Jesús cagman apapäcorgan umanman maquinta churaycur Tayta Diosta manacunanpag. Wamracunata apaycagta ricarmi discïpuluncuna michargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tsaymi discïpuluncunata Jesús caynog nir olgöpargan: “Wamracunata apacamunanta ama michäpäcuytsu. Wamranog cagcunami Tayta Diospa naupanman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pipis Tayta Diosnintsipa naupanman chayayta munarga papänin nishganta wamra criyishgannog Tayta Diosnintsi nishganta criyitsun. Wamranog criyegcunalami Tayta Diospa naupanman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nircurnami tsaycho caycag wamracunata jucta jucta margarcur umanta yataycushpan Tayta Diosnintsita manacorgan paycunata yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tsaypita Jesús aywacunanpagna caycaptinmi juc mözu cörriyla chayargan Jesús cagman. Paymi gongurpacuycur caynog nergan: “Gam imaycatapis musyanquimi, tayta. Tsaymi tapuculäshayqui. ¿Imatatag ruräman Tayta Diospa naupanman chayanäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tsauraga Jesús caynog nergan: “¿Imanirtag yarpanqui lapantapis musyashgäta? Tayta Diosnilantsimi lapantapis musyaycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tayta Diosnintsipa naupanman chayanayquipäga paypa mandamientucunata cumpliy. Musyanquimi mandamientucuna caynog nishganta: ‘Adulterio jutsata ama ruranquitsu. Runa mayiquita ama wanutsinquitsu. Ama suwacunquitsu. Manacagtaga ama pitapis tumpanquitsu. Runa mayiquita ama lulapanquitsu. Mamayquita y taytayquita ali ricanqui.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Niptin tsay mözu nergan: “Tsaycunataga wamra cashgäpita-patsami lapanta cumplishcä, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tsaynog niptin Jesús cuyapar ricärishpan caynog nergan: “Lapanta cumpliycarpis Tayta Diospa naupanman chayanayquipäga jucragmi pishëshunqui ruranayquipag. Lapan imayquicunatapis ranticuycur guellayta wactsacunata aypuy. Nircur nogawan aywashun yachatsishgäta yachacunayquipag. Tsaynog rurashpayquega gloriaman riquëzayquita churacognogmi caycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tsaynog niptinmi pasaypa rïcu car tsay mözu laquishga aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsauraga tsaycho caycag runacunata ricärishpan discïpuluncunata Jesús nergan: “¡Sasami caycan rïcu runacuna Tayta Diospa naupanman chayananpäga!” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesús parlashganta mayarmi discïpuluncuna mantsacashganog ricacorgan. Tsauraga Jesús yapay nergan: “¡Sasami caycan rïcu runacuna Tayta Diospa naupanman chayananpäga! ");
INSERT INTO qvmNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Auja uchcupa camëllo päsayta mana camäpacushgannog rïcu runapis quiquilanpitaga Tayta Diospa naupanman chayayta manami camäpacuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsaynog niptin discïpuluncuna pasaypa mantsacashga quiquinpura parlapäcorgan caynog nir: “Tsaynog captenga ¿pirag salvaconga?” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tsaymi paycunata ricärishpan Jesús caynog nergan: “Quiquilanpitaga runacuna manami salvacuyta camäpacuntsu. Tayta Dioslami pitapis salvan. Tsaymi Tayta Diosnintsipäga imapis mana sasatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsauraga Pedro caynog nergan: “Nogacunaga lapantami imaycätapis cacharishcä gamwan purinäpag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Tsaynog niptin Jesús nergan: “Noga munashgäta ruranan cashga y Tayta Diosnintsipa wilacuyninta wilacunan cashga pipis wauguincunata, panincunata, mamanta, taytanta, tsurincunata, wayinta o chacrancunatapis cachareg cäga cay patsacho pachac (100) cuti mastami chasquengapag. Tsaynogpami paninpis, wauguinpis, mamanpis, taytanpis, chacrancunapis y wayincunapis paypa canga. Itsanga wilacuynëta wilacushganpita runacuna chiquengapagmi. Tsaynog captinpis Tayta Diospa naupanman chayar imayyagpis cushishgami cawangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Waquin runacuna, rïcu cashganpita respitädu carpis, gloriaman manami chayangatsu. Waquin runacunami itsanga, mana cäsushga wactsa carpis, gloriaman chayar cushicongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nircurnami Jerusalenpa aywar discïpuluncunapa puntanta Jesús aywaycargan. Jerusalén autoridäcuna Jesusta wanutsiyta munaycashganta musyarmi discïpuluncuna y paywan waquin aywagcunapis mantsariycar aywapäcorgan. Tsaynog caycagta ricarmi chunca ishcay (12) acrashgan cag discïpuluncunata juc läduman Jesús gayargan. Nircurmi ima pasananpag cashgantapis wilargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Musyapäcunquimi Jerusalenpa aywaycashgantsita. Tsaychömi mandag cüracuna y Moisés escribishganta yachatsegcunapis nogata prësu tsaripäcamanga. Nircurmi wanutsimänanpag mana Israel runacunapa maquinman entregapäcamanga. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Paycunami asipämanga, togapämanga y astamanga. Tsaypitanami wanutsimangapag. Tsaynog captinpis quimsa junagtaga cawarimushagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsauraga Jesusman aywaycur Zebedeupa tsurincuna Santiago y Juan caynog nipäcorgan: “Ruwaculäshayqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tsaynog nipäcuptin Jesús caynog nergan: “Captenga alichari canman.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsaymi paycuna nipäcorgan: “Mandag canayquipag Tayta Dios churashuptiqui gamta mandäshinäpag nogacunata churaycalämay, tayta. Jucnëta jamaycatsilämanqui derëchayqui cagman y jucnëtana itsogniqui cagman.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsauraga Jesús caynog nergan: “Gamcunaga manami musyanquitsu imata manacamashgayquitapis. ¿Gamcuna awantapäcunquimantsurag nogata nacatsimashgannog nacatsipäcushuptiqui? ¿Pasamänanpag caycashganta gamcuna pasapäcunquimantsurag?” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsauraga paycuna nipäcorgan: “Au, awantapäcushagmi.” Tsaynog niptin Jesús nergan: “Rasunpami noga nacashgänog gamcunapis nacapäcunquipag y pasamashgannog pasashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tsaynog captinpis itsognëman y derëchämanga pitapis jamatsishag Tayta Dios nimashgan caglatami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiago y Juan ruwacushganta mayarmi waquin cag discïpuluncuna fiyupa rabiacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsauraga discïpuluncunata gayaycur Jesús caynog nergan: “Gamcuna musyashgayquinogpis nación mandag runacunaga mandag cayninman atiënicuycur runacunata mandan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Gamcunachöga manami tsaynog canmantsu. Tsaypa trucanga waquin runacunapita más ali ricashga cayta munarga runa mayiquita ashmaynogla yanapay. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Manami runacunata munashgäta ruratsinäpagtsu noga shamushcä, sinöga runacunata yanapanäpagmi shamushcä. Tsaynogpis shamushcä runacuna-raycu wanur salvanäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsaypitanami discïpuluncunawan Jesús chayapäcorgan Jericó marcaman. Discïpuluncunawan y más atsca runacunawan Jericöpita yarguycaptinmi Timeupa tsurin Bartimeo caridäta manacur caminucho jamaraycargan. Payga gaprami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Nazaretpita cag Jesús pasaycan” nir wilaptinmi gayacur caynog nergan: “¡Rey Davidpa castan Jesús, cuyapaycalämay!” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tsaynog gayacuptinmi runacuna olgöpargan upälacunanpag. Tsaynog olgöpaptinpis masragmi gayacorgan caynog nir: “¡Rey Davidpa castan Jesús, cuyapaycalämay, ari!” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsaynog gayacushganta mayarmi Jesusga ichicuycorgan. Nircur gayatsiptin aywagcuna Bartimeuta caynog nipäcorgan: “Upälacuyna. Jesusmi gayaycäshunqui. Jucla aywashun.” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tsauraga jucla sharcurcur punchunta jitariycushpan Jesús cagman cushishga aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chayaycuptinna Jesús taporgan: “¿Imacho yanapanätatag munaycanqui?” Tsauraga Bartimeo caynog nergan: “¡Nawëta aliyaycatsilämay, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Niptin Jesús caynog nergan: “Yäracamashgayquipitami canan nawiqui aliyashgana caycan.” Tsauraga jinan hörami Bartimeupa nawin aliyargan. Aliyarcuptinnami Jesusta gaticurcur aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalenman manarag chayarmi Olivos lömacho caycag Betfagé y Betania marcacunaman chayananpagna caycar ishcay discïpuluncunata Jesús puntata cachargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Aywapäcuy Betfagé marcaman. Tsayman chayarnami taripäcunquipag pipis manarag muntacushgan manta bürru wataraycagta. Tsayta pascarir apamunqui. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tsaycho pipis: ‘Bürröta ¿imapagtag pascaycanqui?’ nishuptiquega: ‘Señor Jesusmi nistaycan muntacunanpag. Más tsicalami cutiratsimushag’ nipäcunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsaymi discïpuluncuna aywar taripäcorgan Jesús nishgannogla wayi puncucho manta bürru wataraycagta. Nircurna apananpag pascapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pascaycagta ricaycurmi tsaycho caycag runacuna caynog taporgan: “¿Imapagtag bürruta pascaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsaynog niptinmi discïpulucuna nipäcorgan Jesús yachatsishgannogla. Tsaynog nipäcuptin: “Tsauraga apay, ari” nergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tsaymi bürruta janchacurcur Jesús caycashgan cagman cutipäcorgan. Chayaycatsirna punchuncunata bürruman carunarcuptinmi Jesús muntacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Muntashga aywaptinnami runacuna cushicushpan jacuncunata y punchuncunata aywashgan caminuman mashtapäcorgan. Waquincunana palmata muturir muturir caminuman mashtapäcorgan payta cushishga chasquicushpan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tsaymi puntanta aywagcuna y guepanta aywagcunapis cushicushpan nipäcorgan: “¡Tayta Diosnintsi cachamushgan mandamagnintsi caychönami caycan! ");
INSERT INTO qvmNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Paymi David castapita mandamagnintsi rey caycan! ¡Tayta Diosnintsi imayyagpis alabashga cayculätsun!” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalenman chayarna Jesús aywargan templo patiuman. Tsaycho ricapacurirmi tardina captin chunca ishcay (12) acrashgan cag discïpuluncunawan cutergan Betania marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wara tuta Betaniapita Jerusalenman Jesús cutiycarmi micanargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tsauraga carupita ricargan hïgus yöra atsca raprayog caycämogta. Tsaymi wayuynin cashganta yarpar aywargan palananpag. Chayananpäga manashi wayuynin cargantsu manarag tiempun captin. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsauraga Jesús nergan hïgus yörata: “¡Cananpitaga manami imaypis wayunquipagnatsu!” Tsaynog nishgantami discïpuluncuna mayargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tsaypita Jerusalenman chayashpanna templo patiuman yaycorgan. Tsaychönami ranticogcunata y rantegcunatapis gargorgan. Tsaynoglami guellay ranticogcunapa mësantapis y paloma ranticogcunapa mësantapis ticrar ushargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tsaynogpis runacunata michargan cargancunata templo patiupa mana pasatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsaypitanami yachatsergan caynog nir: “Tayta Diosnintsipa palabranchöga caynogmi escribiraycan: ‘Templöga canga may-tsay nacionpitapis shamog runacuna nogata manacamänanpagmi.’ Tsaynog escribiraycaptenga ¿imanirtag gamcuna ticratsishcanqui suwacunapa machayninmannog?” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Templo patiupita runacunata Jesús tsaynog gargushganta musyarmi mandag cüracuna y Moisés escribishganta yachatsegcuna wilanacärergan imanogpapis wanutsinanpag. Jesús yachatsishganta runacuna cushishga chasquicuptinmi paycunata mantsacur prësu mana tsaritsergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Patsa tsacaptinnami discïpuluncunawan Jerusalenpita Jesús cuticorgan posädarashganman. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wara tuta Jerusalenman discïpuluncunawan Jesús cutir ricapäcorgan hïgus yöra pasaypa tsaquishgana caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsaymi yöra tsaquishga caycagta ricaycur Pedro caynog nergan: “Manami wayunquinatsu nishgayqui hïgus yörata ricäriy, tayta. Pasaypa tsaquishgana caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pedro tsaynog niptin Jesús nergan: “Tayta Diosman yäracäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Lapan shonguyquiwan Tayta Diosman yäracorga gamcunapis mana criyiypag cag milagrucunatami ruranquipag. Tagay jircata witicunanpag niptiquipis witicongami. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lapan shonguyquiwan yäracur Tayta Diosta manacorga criyinqui chasquinayquipag cashganta. Tsaynog criyerga rasunpami chasquipäcunqui manacushgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Tsaynogpis Tayta Diosta manacuycashgayqui höra piwanpis jagayätsinacushga cashgayquita yarparga ayway perdonanayquipag. Tsaynog perdonaptiquega gamcunatapis jutsa rurashgayquita Tayta Diosnintsi perdonashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Runa mayiquita mana perdonaptiquega Tayta Diosnintsi manami gamcunatapis jutsa rurashgayquita perdonashunquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsaypita discïpuluncunawan Jesús chayargan Jerusalenman. Templo patiucho Jesús puriycaptin payman shapäcamorgan mandag cüracuna, Moisés escribishganta yachatsegcuna y Israel mayor runacunapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Paycunami Jesusta caynog nir tapupäcorgan: “Gamga ¿ima munayniquiwantag templo patiucho ranticogcunata gargushcanqui? ¿Pitag nishushcanqui tsaynog gargunayquipag?” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Tsaynog tapuptinmi paycunatapis Jesús caynog taporgan: “Gamcunatapis canan tapushayqui. ¿Pitag Juanta cachamorgan bautizananpag? ¿Tayta Diosnintsicu o runacunacu? Tapushgäta nipäcamaptiquega nogapis wilashayquimi pipa munayninwan templo patiupita gargushgätapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsauraga quiquinpura caynog wilanacärergan: “Ama nishuntsu Tayta Diosnintsi cachamushganta. ‘Tayta Diosnintsimi cachamushga’ niptintsega: ‘¿Imanirtag mana criyipäcorgayquitsu?’ nimäshunmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tsaynogpis ama nishuntsu runacuna cachamushganta. Tsaynog niptintsega sagmaycälarmi runacuna wanutsimäshun. Lapanmi yarpapäcun Tayta Diospa wilacognin Juan cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsaynog wilanacurcurmi paycuna caynog nipäcorgan: “Manami musyapäcötsu pï cachamushgantapis.” Tsaynog nipäcuptinmi Jesús caynog nergan: “Gamcuna mana wilamaptiquega nogapis manami wilashayquitsu pipa munayninwan templo patiupita ranticogcunata gargushgätapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsaypita Jesús tincutsiypa yachatsergan caynog nir: “Juc runashi juc chacra üvata plantargan. Nircurnashi uywacuna mana yaycunanpag guenchatsergan. Tsaypitanashi üva jarucuna pözutapis jinan chacracho ruratsergan. Nircurnashi tsuclatapis ruratsergan üvata täpananpag. Lapanta ruraycatsirnashi chacra arog runacunata arrendacuycur juc lädu marcapa aywacorgan tsaycho tänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Tsauraga cosëcha galaycuptinnashi cachargan juc ashmayninta üva chacra arrindunpita cobramunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tsay ashmay chayaptinshi pasaypa magarcärir jinaylata gargurergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jinayla cutiycuptinnashi chacrayog yapay juc ashmaynintana cachargan. Tsay ashmaytapis chacraman chayagta ashlergan y magar umantapis rachipargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsaynog ruraptinpis yapayshi cachargan más juc ashmayninta. Paytaga wanutsipäcorganshi. Tsaynoglashi rurapäcorgan waquin cachacushgancunatapis. Waquintashi magapäcorgan y waquintanashi wanutsipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Lapan ashmaynincuna ushacaptinnashi juclaylana cargan cachananpag. Payga cargan japalan cuyay tsurinshi. Ultimutaga tsay cuyay tsurintanashi cachargan: ‘Tsurëtaga chasquicärengami’ nir. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tsayshi tsay tsurin chayaycuptinna chacra arrendagcuna wilanacärergan caynog nir: ‘Tagaymi cay chacrawan quëdananpag caycan. Nogantsina cay chacrawan quëdacunantsipag payta wanuratsishun.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsayshi chayaycuptin üva chacrapita juc läduman jorgurir wilanacushgannogla wanutsipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tsaynog rurashganpita tsay üva chacrayöga ¿imatarag ruranga tsay chacrata guechuyta munag runacunata? ¿Manatsurag tsay fiyu runacunata lapanta wanutsenga? Nircurna chacranta juctana arrendacuycongapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tsaynog pasashunayquita mana munashpayquega Tayta Diosnintsipa palabrancho caynog escribiraycashganta tantyacäriy: ‘Wayi sharcatsegcuna: “Manami alitsu cay rumi” nir jitariycuptinpis wayi esquïnaman cimientupag tsay rumi churashganami caycan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cimientu cananpäga Tayta Diosnintsimi churashga. Tsaynog churashga captinmi cushicuypag caycan.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsaynog tincutsiypa Jesús yachatsiptinmi mandag cüracuna, Moisés escribishganta yachatsegcuna y waquin Israel mayor runacunapis tantyapäcorgan tumatsipaylapa paycunata Jesús tsaynog niycashganta. Tsaymi Jesusta prësu tsariyta munarpis atsca runacuna favornin captin mantsacushpan aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsaypita tsay autoridäcuna cachargan fariseucunata y Herodispa favornin cag runacunatapis Jesús cagman ali shimilanpa lutanta parlatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tsauraga Jesusman chayaycur caynog nipäcorgan: “Nogacuna musyapäcömi rasun caglata imatapis parlashgayquita, tayta. Tsaymi yachagtapis mana yachagtapis Diospa wilacuynin nishgannogla yachatsinqui. ¿Romacho emperador Cesarpag impuestuta pägashwancu o manacu?” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lutanta rimatsinanpag tapushganta tantyarmi Jesús caynog nergan: “¿Imanirtag lutanta parlatsimayta munapäcunqui? Mä apamuy guellayta ricanäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Guellayta ricaycurnami caynog nergan: “Cay guellaycho ¿pï runapa reträtuntag caycan? Tsaynogpis ¿pipa jutintag escribiraycan?” Tsaynog tapuptin nipäcorgan: “Emperador Cesarpami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsaymi Jesús nergan: “Emperador Cesarpa cagta Cesarta goycuy. Tayta Diospa cagtaga Tayta Diosnintsita goycuy.” Tsaynog niptinmi tapogcuna imaniytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsaypitami saduceo runacunapis Jesusman aywapäcorgan pay yachatsishganta manacagman churananpag. Tsaymi Jesusta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Moisés escribishgancho caynogmi niycan, tayta: ‘Warmiyog runa tsuriynag wanuptin shulca wauguin cuñädan viüdawan tätsun. Tsaynogpami wamrancuna tsay wanog cag runapa tsurinnogna canga.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tsaynog captenga tapucushayqui, tayta. Juc marcachöshi ganchis wauguicuna cargan. Mayor cagshi juc warmiwan targan. Tsayshi manarag tsurin captin wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tsauraga shulca cag wauguinnashi targan tsay viüdawan. Paypis tsurin manarag captinshi wanorgan. Tsaypita más shulcan cagna targan tsay viüdawan. Paypis wanorgan tsurin manarag captinshi. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tsaynogla lapan wauguincuna tsay viüdawan targan. Tsuriynagla lapanpis wanorgan. Tsaypitanashi tsay viüdapis wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wanushcunata Tayta Diosnintsi cawaritsimunan junäga tsay warmilachi ganchis wauguipa warmin canga.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tsaynog nipäcuptinmi Jesús caynog nergan: “Tsaynog nishpayquega gamcuna manami tantyapäcunquitsu Tayta Diospa palabrancho escribiraycashganta. Tsaynogpis manami tantyapäcunquitsu wanushcunata cawaritsimunanpag Tayta Dios munayniyog cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanushganpita cawarimorga mananami pipis warmiyog o runayog cangatsu, sinöga gloriacho caycag angilcunanoglanami majaynagla cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wanushcuna cawarimunanpag cashgantaga ¿manacu liyipäcushcanqui Moisés escribishgancho niycashganta? Abraham, Isaac y Jacob wanushganpita atsca wata guepataragmi Tayta Diosnintsi rupaycag shiracapita Moisesta caynog nergan: ‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wanogcuna mana cawarimunanpag captenga ¿imanogpatag Abrahampa, Isaacpa y Jacobpa Diosnin canman? Tsaynog caycaptenga ¿imanirtag gamcuna mana criyinquitsu wanogcuna cawarimunanpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesús ali contestashganta wiyarmi Moisés escribishganta yachatseg runapis taporgan caynog nir: “Tayta, ¿maygan mandamientutatag más cäsucushwan?” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tsaynog tapuptinmi Jesús caynog nergan: “Más cäsucunantsipag cag mandamientoga caynogmi escribiraycan: ‘Israel runacuna, mayapäcuy. Tayta Diosnintsega juclaylami. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Shumag tantyacur lapan shonguyquiwan y lapan voluntäniquiwan Tayta Diosta cuyanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Caynogpis escribiraycanmi: ‘Runa mayiquita lapan shonguyquiwan cuyanqui.’ Tsay ishcan mandamientucunata más cumplinantsitami Tayta Diosnintsi munan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsauraga Moisés escribishgan leycunata yachatseg runa caynog nergan: “Rasun cagtami nishcanqui, tayta. Rasunpapis juclaylami Tayta Diosga. Manami más juc Diosga cantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tsaynogpis rasun cagtami nishcanqui más cäsucunantsipag cag mandamientucuna maygan cashgantapis. Tsay ishcan mandamientucunata cumplishgantsega uywacunata altarcho rupatsishgantsipitapis más alimi caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tsaynog niptinmi Jesús caynog nergan: “Alitami nishcanqui. Nishgayquinog cawarga Tayta Diosnintsipa naupanmanmi chayanquipag.” Tsay junagpita-patsaga manami pipis tapupayta almitergannatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Templo patiucho yachaycätsirmi runacunata Jesús caynog nergan: “¿Imanirtag Moisés escribishganta yachatsegcuna nipäcun Cristo Davidnogla mandag rey cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Santu Espíritu tantyatsiptin quiquin Davidpis caynogmi escribergan: ‘Munaynincho tsararämag mandag reyta Tayta Diosnintsi caynogmi nergan: Jamacamuy derëcha cag naupäman lapan contrayquita vincinäyag.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Tsauraga ¿imanogpatag Cristoga Davidnogla mandag rey canman quiquin Davidpis mandagnin rey cashganta niycaptenga?” Jesús tsaynog yachatsiptinmi atsca runacuna cushishga mayapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tsaynogpis Jesús caynog nergan: “Cuidädu Moisés escribishganta yachatseg runacunanog capäcunquiman. Tayta Dios munashgannog cawaycashganta runacuna yarpänalanpagmi paycunaga puripäcun chaqui puntanyag sotänan jatishga. Tsaynogpis más munapäcun yachatsicog cashganpita pläzacunacho y cällicunachöpis alabashga caylatami. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tsaynogpis sinagogacunacho alinnin cag bancumanrag jamacuytami munapäcun. Micunanpag gayatsiptinpis mësamanragmi jamacuyta munapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tsaynogmi viüdacunapa ima pobrëzalantapis apacärin. Nircurnami alita rurashganta runacuna yarpänanpag may hörarag Tayta Diosta manacärin. Tsaynog rurashganpitami infiernucho más fiyupa nacangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tsaypita templucho Jesús jamaraycargan ofrendacunata winacunan naupancho. Tsaychömi rïcu runacuna atsca guellayta tsayman winaycagta ricaraycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Juc wactsa viüdapis tsayman chayaycushpan ishcayla cobri guellayninta winargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Tsayta ricar discïpuluncunata gayaycur Jesús nergan: “Rïcu runacunaga winashga putsog guellaynilantami. Viüdami itsanga wactsa caycarpis winashga lapan guellayninta, tsaylawan rantipacunanpag caycaptinpis.” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Templupita yargurirna juc discïpulun Jesusta caynog nergan: “¡Cuyaylapag jatusag rumicunawanmi templuntsita sharcatsipäcushga, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tsaynog niptin Jesús caynog nergan: “Cay lapan ricaycashgayqui cuyaylapag caycaptinpis chipyagmi juchutsishga cangapag. Manami ni juc rumilapis canan pergaraycashgannöga quëdangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Templo tsimpan Olivos lömacho jamapagnogmi Pedro, Santiago, Juan y Andrés Jesusta tapupäcorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nishgayquinöga ¿imaytag templo juchutsishga canga, tayta? Tsaynog cananpäga ¿puntata imatag canga?” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tsaynog tapuptinmi Jesús caynog nergan: “Pipis lutanta mana criyitsishunayquipag shumag tantyacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Atscagmi shapäcamonga: ‘Nogaga Cristumi caycä’ nir. Tsaynog nirmi atsca runacunata engañangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","May-tsay nacioncunachöpis guërra captin y wanutsinacuy captin ama mantsacärinquitsu. Puntataga tsaycunaragmi pasanga. Tsaynog captinpis cay patsa manaragmi ushacangaragtsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Juc nacionwan juc nacionmi pelyapäconga. Tsaynoglami muchuypis terremötupis may-tsaycho cangapag. Tsaynog captinpis nacaycuna galaycunalanragmi tsaycunaga canga. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nogata chasquicamashgayquipitami autoridäcunamanpis prësu tsarircur apapäcushunqui. Israel mayiquicunapis contrayqui sharcur sinagogancunacho astashunquipag. Nación mandag reycunamanpis apapäcushunqui juzgashga canayquipag. Tsaychömi wilacuynëta paycunatapis wilapanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tsaynogpami cay patsa manarag ushacaptin may-tsay nacionchöpis nogapita wilacärengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Autoridäcunaman entregapäcushuptiquipis ama laquicärinquitsu: ‘¿Imatarag nishag?’ nishpayqui. Paycunapa naupancho imata ninayquipagpis Santu Espiritumi tantyatsishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nogata chasquicamashganpita chiquirmi wauguintapis autoridäcunaman entreganga wanutsishga cananpag. Waquinnami tsurinta entreganga wanutsishga cananpag y waquinnami taytantapis entreganga wanutsishga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nogata chasquicamashgayquipitami pï-maypis chiquishunquipag. Tsaynog captinpis hasta wanunayquiyag noga munashgänog cawarmi Tayta Diospa naupanman chayanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tayta Diosnintsipa profëtan Daniel escribishgannoglami Diosta mana cäsucog runa templo ruriman yaycongapag. (Cay escribishgäta liyeg cäga shumag tantyacutsun.) Tsay fiyu runa templuman yaycuptin Jerusalén marcapita y Judea provinciacho caycag waquin marcacunapitapis gueshpir aywacäritsun. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wayi janancho cagcunapis jucla gueshpir aywacutsun. Imata jorgunanpagpis wayinman amana yaycutsuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chacrancho caycagcunapis jucla gueshpir aywacutsun. Ama cutitsuntsu wayinman trucacunanpag röpata jorgogpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tsaynog gueshpirmi pasaypa cuyapaypag nacanga chichu warmicuna y iti wawayog warmicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tamya quillacho tsay gueshpinayqui junag mana cananpag Tayta Diosnintsita manacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Tsay junagcunaga fiyupami runacuna nacangapag. Cay patsata Tayta Diosnintsi camashganpita-patsa manami imaypis tsaynöga runacuna nacashgatsu. Tsaynogpis yapayga mananami tsaynog nacaycuna cangapagnatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Acrashgancunata cuyaparmi tsay nacaycunata Tayta Diosnintsi pasatsenga. Tsay nacay junagcunata mana pasatsiptenga lapanpis wanupäcunmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tsay junagcuna: ‘Tayta Dios cachamushgan Cristo caychömi wacchömi caycan’ nishuptiquipis ama criyipäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tsaynogpis waquenga: ‘Tayta Dios cachamushgan Cristumi caycä’ o ‘Tayta Diosnintsipa profëtanmi caycä’ nir lulacushpanmi puripäcongapag. Runacunata criyitsinan cashgami ima milagrucunatapis ruranga. Atsca runacunata tsaynogpa engañarpis Tayta Diosman yäracogcunataga manami engañayta camäpacongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tsaycuna manarag captinmi gamcunata wilaycä tsay lutan yachatsicogcunata mana chasquipänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Cay patsacho fiyupa nacaycuna pasariptinragmi intipis y quillapis tsacacäconga. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tsaynoglami lapan estrellacunapis shicwamonga y ciëlupis sicsicyanga. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tsaychömi nogata ricapäcamanga pucutay janancho chip-chipyaycar aywaycämogta. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tsay junagmi angilnëcunata cachamushag may-tsaypitapis nogaman yäracamagcunata shuntamunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Cay yachatsishgäta shumag tantyapäcuy. Tamya tiempo galaycuptin musyapäcunquimi hïgus yöra tsintsimunanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tsaynoglami tsay nishgä nacaycuna chämuptin gamcunapis musyanquipag cutimunäpagna caycashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Canan cawaycag runacuna manarag wanuptinmi lapan tsay nishgäcuna cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jana patsa y cay patsa ushacaptinpis noga nishgäcunaga lapanmi cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Imay junag imay höra cutimunäpag cashgantaga manami angilcunapis ni nogapis musyätsu. Tsaytaga Tayta Dioslami musyan. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gamcunapis camaricushgala car Tayta Diosta imaypis manacurcaycay. Manami musyapäcunquitsu imay cutimunäpag cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tsaymi mastapis Jesús caynog nergan: “Juc wayiyog aywacur wayinta ricananpag ashmayninta cachapan imata rurananpag cagtapis tantyarcatsir. Puncu quichapagnintapis tantyatsin imay hörapis mayag mayagla caycänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tsaynoglami nogapis elagpita cutimushag: patsa tsacaycashgan höra, pulan pagas höra, walpa wagay höra o patsa waraycashgan hörapis. Tsaynog caycaptenga shuyarpaycämanqui camaricushgala. Manami musyapäcunquitsu imay höra cutimunäpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mayag mayagla caycaptiquega elagpita shamur jutsa ruraycagta manami tarishayquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Manami gamcunalatatsu caynog niycä, sinöga lapan runacunatami. Tsaynog wilaycaptëga mayag mayagla carcaycay.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jesús tsaynog yachatsergan Pascua aniversario y Levadüraynag Tantata Micunan aniversario galaycunanpag ishcay junag pishiycaptinmi. Tsay junagmi mandag cüracuna y Moisés escribishganta yachatsegcuna wilanacärergan runacunata mana musyatsiylapa Jesusta tsarircur wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tsaynog wilanacurmi waquincuna caynog nergan: “Ama tsarishuntsu Pascua aniversariuchöga. Tsaycho tsariptintsega atsca runacunami favornin sharcur ticrapämäshun.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania marcachömi Jesús posädaraycargan lepröso nipäcushgan Simonpa wayincho. Tsaymanmi juc warmi chayargan “alabastro” nishgan rumipita rurashgan botëllanwan perfümin aptashga. Tsay perfümi nardupita rurashga carmi pasaypa chanin cargan. Tsauraga mësacho Jesús caycaptin botëllapa shiminta paquirir tsay perfümita Jesuspa umanman warmi winapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tsayta ricarmi waquin tsaycho caycagcuna rabiashpan caynog nergan: “¿Imapagtag manacaglapag jichar perditsishga tsay perfümita? ");
INSERT INTO qvmNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tsayta ranticushwan cargan juc wata arupacur gänashgantsipita maschömi. Nircur tsay guellaywanna wactsacunata yanapashwan cargan.” Tsaynog nirmi tsay warmita jamurpargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tsauraga Jesús nergan: “Cay warmi alitami ruraycan. Tsaynog caycaptenga ¿imanirtag payta jamurpaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Imaypis wactsacunaga cangami munashgayqui höra yanapanayquipag. Nogaga mananami gamcunawan cashagpagnatsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmega perfümita winapämar camariycäman pampashga canäpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Perfümita cay warmi winapämashgantaga may-tsaychöpis musyapäcongapagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tsaypitanami Jesuspa discïpulun Judas Iscariote mandag cüracunaman aywaycur paycunawan parlacorgan Jesusta entregananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tsaymi cüracuna cushicushpan Judasta pägananpag nipäcorgan. Tsaypita wilanacurcurmi Judas yarpachacorgan imay höra wilacog cutinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Levadüraynag Tantata Micunan aniversario y Pascua aniversariupis galaycunan junagmi Israel runacuna templucho carnishta pishtapäcog. Tsay junagmi discïpuluncuna Jesusta taporgan caynog nir: “¿Maychötag camaripäcamushag Pascua cënayta micunantsipag, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsaynog nipäcuptin Jesús ishcay discïpuluncunata nergan: “Aywapäcuy marcaman. Tsayman chayarnami ricanquipag juc runa puynunwan yacuta apaycagta. Paypa guepalanta aywapäcunqui hasta may wayimanpis chayananyag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tsaychömi wayiyogta caynog nipäcunqui: ‘¿Mayninchöshi cuarto caycan discïpuluncunawan Pascua cënayta Jesús micunanpag?’ ");
INSERT INTO qvmNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tsaynog niptiquimi pay ricatsishunquipag altuscho pitsapacushga jatun cuartuta. Tsay cuartucho cënayta camaricärinqui micunantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tsaynog niptin aywarmi discïpuluncunaga chayapäcorgan marcaman. Tsayman chayaycurmi Jesús nishgannogla lapanpis cargan. Tsay wayichönami paycuna camarergan Pascua cënayta. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Patsa tsacaycaptinnami chunca ishcay (12) acrashgan cag discïpuluncunawan Jesús tsayman chayargan cënapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tsauraga micurcaycashgancho Jesús caynog nergan: “Gamcunapita jucniquimi conträcunapa maquinman entregamangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Niptin laquicärishpan jucnin jucnin caynog nir Jesusta tapupäcorgan: “¿Nogatsurag caycä, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tsauraga Jesús nergan: “Nogawan juntu tantata plätucho ushmatseg cagmi conträcunapa maquinman entregamangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tayta Diospa palabrancho escribiraycashgannogla fiyupa nacar wanunäpagmi caycä. Nogata entregamag runami itsanga juicio final junag pasaypa laquicongapag. Payga ama yurinmanpistsu cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tsaypitanami tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata ayporgan caynog nishpan: “Cay tantata lapayqui micapäcuy. Cay tantaga cuerpömi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsaynoglami vïnuyog väsuta aptarcur Tayta Diosta manacur agradëcicorgan. Nircurnami discïpuluncunata macyargan upupäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tsaypitana paycunata Jesús nergan: “Cay vïnoga yawarnëmi. Yawarnëta jichar wanushgä hörami Tayta Dios mushog conträtuta ruranga pï-maytapis chasquicamagcunata perdonananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yapayga manami vïnuta upushagnatsu Tayta Diospa naupancho upunantsiyag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tsaypita juc salmuta cantarcur aywapäcorgan Olivos lömaman. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Olivos lömaman chayaycurmi Jesús nergan: “Canan tsacay lapayqui cachariycamarmi gueshpir aywacärinquipag. Tayta Diosnintsipa palabranchöpis caynogmi niycan: ‘Uysha mitsegta wanuycatsiptë uyshancuna mashtacarmi aywacärenga.’ ");
INSERT INTO qvmNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tsaynog captinpis wanushgäpita cawarircamur gamcunapita más puntatami Galileaman aywashag tsaycho tincunantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tsauraga Pedro nergan: “Waquin cag cacharishuptiquipis nogaga manami cachashayquipagtsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tsaynog niptinmi Pedruta Jesús caynog nergan: “Canan tsacay ishcay cuti gällu manarag cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tsauraga Pedro caynog nergan: “¡Ishcantsita wanutsimänantsi captinpis manami ñëgashayquipagtsu, tayta!” Waquin cag discïpuluncunapis tsaynoglami nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Olivos lömacho caycag Getsemaní huertaman discïpuluncunawan chayaycurmi Jesús caynog nergan: “Tayta Diosta manacamushgäyag gamcuna caylacho jamarpaycay.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nircur Pedruta, Santiaguta y Juanta más washa läduman pushargan. Tsaychömi fiyupa laquicur caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Wanuyparagmi laquicuy tsarimashga. Gamcunapis Tayta Diosta manacushpayqui caylacho shuyarpaycämay.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Tsaynog nircurmi más washa läduman aywargan Tayta Diosta manacunanpag. Tsaychömi gongurpacuycorgan hasta urcunpis pampaman töpananyag. Tsaynog gongurpacuycurmi Tayta Diosta manacorgan caynog nir: “Papá, gampäga imapis manami sasatsu. Nacanäpag caycashgäpita salvaycalämay. Itsanga noga munashgänöga ama catsuntsu, sinöga gam munashgayquinog cayculätsun.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsaynog manacushganpita cutishpanmi tarergan quimsan discïpuluncuna punucashga caycagta. Tsauraga Pedruta caynog nergan: “Simón, ¿imanirtag punucashga caycanqui? ¿Manacu juc höralapis ricchayta camäpacushcanqui? ");
INSERT INTO qvmNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Punushgayquipita ricchayna. Diosta manacäriy Satanasta mana cäsupänayquipag. Cäsupayta mana munarpis Tayta Diosta mana manacorga cäsupanquipagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yapay cutiycurmi Jesusga puntata manacushgannogla Tayta Diosta manacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tayta Diosta manacushganpita yapay cutiycur tarergan quimsan discïpuluncuna pasaypa punucashga caycagta. Tsaynog tariycuptinmi discïpuluncuna imaniytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quimsa cuti Diosta manacushganpita cutirnami paycunata caynog nergan: “¿Cananpis gamcuna jinalacu punurcaycanqui? ¡Ricchapäcuy! Tayta Diospita shamushga captëpis höra chämushganami jutsasapa runacunapa maquinman nogata entregamänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Sharcapäcuyna! Conträcunapa maquinman entregamänanpag cag runa aywaycämunnami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Discïpuluncunawan Jesús parlaycaptinmi Judas Iscariote chayargan atsca runacunata pushashga. Judasga Jesuspa discïpulunmi cargan. Tsay runacunami chayargan espädancuna y garrotincuna aptashga. Jesusta prësu tsarinanpag tsay runacunata cachargan mandag cüracuna, Moisés escribishganta yachatsegcuna y Israel mayor runacunami. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tsayman manarag chayarmi Judasga pushashgan runacunata yätsergan caynog nir: “Mayganpis mutsashgä cagmi Jesusga canga. Payta prësu tsaripäcunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tsaymi chayaycur Judasga Jesusta saludashpan mutsaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsaynog mutsarcuptinmi Jesusta jucla prësu tsarergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Prësu tsariptinmi espädanta jorgurishpan juc discïpulun más mandag cürapa ashmayninpa rinrinta roguriycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nircurna tsay runacunata Jesús caynog nergan: “¿Imanirtag suwa captënogpis gamcuna shamushcanqui espädayquiwan y garrotiquiwanpis prësu tsarimänayquipag? ");
INSERT INTO qvmNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nogaga waran waranmi templo patiucho yachatsergä. Tsaycho caycaptëga ¿imanirtag tsaychöga prësu mana tsarimargayquitsu? Tsaynog captinpis prësu tsarimänayquipag gamcuna shapäcamuptiquimi Tayta Diosnintsipa palabrancho nishgannogla cumpliycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesusta prësu tsariptinnami discïpuluncuna gueshpir aywacärergan japalanta cachaycur. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Juc mözulami säbanasnin aylushgala guepanta gatipargan. Tsaychömi tsay mözuta tsaripäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tsaynog tsariptin aylurashgan säbanasta logtiriycur tsay mözu garapächula gueshpir aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsaypita Jesusta prësu apapäcorgan más mandag cürapa wayinman. Tsaymanmi juntacargan mandag cüracuna, Israel mayor runacuna y Moisés escribishgan leycunata yachatsegcunapis. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesusta tsayman apapäcuptinmi caru guepalanta Pedro gatirargan. Más mandag cürapa wayinman chayaycur paypis yaycorgan patio rurinyag. Tsayman yaycurir templo täpag wardiacunawan jamaraycargan ninacho mashacushpan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mandag cüracuna y autoridäcunanaga imanogpapis Jesusta wanutsinantami munapäcorgan. Tsaynog captinpis manami ima jutsantapis tarergantsu wanutsishga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jesuspa contran atsca runacuna sharcurpis manami mayganpis juc yarpaylaga nipäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsaypitanami waquin runacuna Jesuspa contran sharcur caynog nipäcorgan: ");
INSERT INTO qvmNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nogacuna mayapäcushcä cay runa templuta juchuratsir quimsa junaglacho juc templutana sharcatsinanpag nishgantami. Tsaynogpis payga nergan runa mana sharcatsishgan templo cananpag cashgantami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jesuspa contran tsaynog nipäcuptinpis manami waquin runacuna nishgancunaman tincorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsauraga más mandag cüra Jesusta caynog nir taporgan: “¿Manacu imatapis ninqui tsaynog jitapäshuptiqui? ¿Imanirtag contrayqui tsaynog parlarcaycan?” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tsaynog tapuptinpis Jesús upälala cacorgan. Tsaymi más mandag cüra yapay taporgan caynog nir: “¿Rasunpacu Tayta Dios cachamushgan Cristo caycanqui? Tsaynogpis ¿rasunpacu Diospa tsurin caycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tsaynog tapuptinmi Jesús nergan: “Au, nishgayquinog rasunpami caycä. Tsaymi nogata ricapäcamanquipag lapanpag munayniyog Tayta Diospa derëcha cag naupancho jamaraycagta. Tsaynogpis pucutay janancho aywaycämogtami ricapäcamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tsaynog niptin más mandag cüra pasaypa rabiashpan sotänantapis rachir tsaycho caycag runacunata caynog nergan: “Tsaynog niycaptenga ¿imapagnatag más testïgutapis ashishun? ");
INSERT INTO qvmNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamcuna mayapäcushcanquimi Dios-tucur parlaycashganta. Tsaynog captenga gamcuna ¿imanipäcunquitag?” Tsauraga lapan tsaycho juntaraycag autoridäcunami juc yarpayla nipäcorgan payta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tsaymi Jesusta togapashpan nawinta träpuwan vendaparcur waquin autoridäcuna magapäcorgan: “¡Mä adivinay pï magashushgayquitapis!” nipäcushpan. Tsaynoglami templo täpag wardiacunapis payta lagyargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Patiucho Pedro caycaptin más mandag cürapa ashmaynin warmi tsayman chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nina rataycagcho Pedro mashacuycagta ricarmi tsay warmi nergan: “Gamta ricashcä Nazaretpita cag Jesuswan puriycagtami.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tsaynog niptin Pedro caynog nergan: “Nogaga manami payta reguëtsu, ni tantyätsu imapita parlaycashgayquitapis.” Tsaynog nishpanmi sawan yaycuna puncuman witicorgan. Tsayman witicuptinmi gällu cantarcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tsaychöpis tsay ashmay warmi tsaycho caycag runacunata caynog nergan: “¡Cay runataga Jesuswan puriycagtami ricashcä!” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tsaynog niptinmi mana reguishganta Pedro yapay nergan. Tsaypita más rätuta tsaycho caycag runacuna Pedruta caynog nergan: “Rasunpami gamga paywan pureg caycanqui. Galilea runami canquipis.” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tsaynog niptinmi Jesusta manacagman churashpan jurar Pedro nergan: “¡Tsay runaga pishi cacunpis! ¡Paytaga manami reguëtsu!” ");
INSERT INTO qvmNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tsaynog niycaptinmi gällu yapay cantarcorgan. Gällu cantagta mayarmi Pedro yarparcorgan Jesús caynog nishganta: “Manarag ishcay cuti gällu cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipag.” Tsay nishganta yarparcurmi Pedro fiyupa laquicushpan wagargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsaypita patsa waraycaptinnami lapan mandag cüracuna, Israel mayor runacuna, Moisés escribishgan leycunata yachatsegcuna y waquin autoridäcunapis juntacaycur wilanacorgan Jesusta wanutsinanpag. Wilanacurcurnami liyarcur Jesusta apatsipäcorgan Israel nacionpa mandagnin Pilätuman. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tsayman chayatsiptinmi Pilato caynog taporgan: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” Tsaynog tapuptin Jesús nergan: “Gam nishgayquinoglami rasunpa caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tsaychömi mandag cüracuna Jesuspa contran imaycatapis nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tsaymi Pilato yapay taporgan Jesusta caynog nir: “¿Manacu imatapis ninqui tsayjina contrayqui rimaycaptin?” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tsaynog niptinpis Jesusga manami imatapis rimacorgantsu. Tsaymi Pilätoga imaniytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada watami Pascua aniversariucho Pilato cachareg juc prësuta runacuna manacushgan cagta. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tsay wata prësu wichgaraycargan Barrabás jutiyog runa. Payga carcilcho wichgaraycargan mandag emperadorpa contran sharcushganpita y runata wanutsishganpitami. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tsaymi runacuna Pilätuman aywaycur manacärergan juc prësuta tsay watapis cacharinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Mandag cüracuna Jesusta chiquir payman apapäcushganta musyashpanmi Pilato caynog nergan: “¿Israel runacunapa mandagnin rey Jesustacu cacharinäta munapäcunqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tsaynog niptinmi mandag cüracuna tsaycho cag runacunata yachatsergan: “Barrabasta cachariyga” nipäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Barrabasta cacharinanpag nipäcuptin Pilato taporgan lapan runacunata: “Israel runacunapa mandagnin rey Jesustaga ¿imata ruranätatag munapäcunqui?” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsaynog tapuptinmi paycuna nipäcorgan: “¡Crucificashga catsun!” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tsaynog nipäcuptinmi Pilato caynog nergan: “Crucificashga cananpäga ¿ima jutsatatag rurashga?” Tsaynog niptin masrag runacuna nipäcorgan: “¡Crucificatsiy!” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsauraga Pilato runacunawan ali quëdayta munashpan Barrabasta cacharergan. Nircurna Jesusta astarcatsir entregaycorgan crucificashga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tsaypita soldäducuna Jesusta apargan palacio patiuman. Tsaymanmi lapan soldäducuna juntapargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nircurmi payta asipänan cashga aylupargan rey jaticunan puca-chicnu cäpata. Tsaynogpis cashapita awashga corönata umanman jatipargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsaynog jatiparcurmi nipäcorgan: “¡Alabashga catsun Israel runacunapa mandagnin rey!” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tsaypitana tsay soldäducuna trucapänacuypa gueruwan Jesusta umacho wirupäcorgan. Nircurmi togapashpan respitag-tucur naupanman gongurpacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tsaynog asiparcurmi aylupashgan puca-chicnu cäpata logtiparcur quiquinpa röpantana Jesusta jatipargan. Nircurmi crucificananpag apapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesusta crucificananpag apaycarmi Cirene marcapita Simonwan tincorgan. Payga cargan Alejandrupa y Rufupa papäninmi. Paytami Jesús apaycashgan cruzta umrutsergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nircurnami Jesusta chayatsipäcorgan Gólgota nishgan lömaman. Gólgota ninanga cargan “Calavëra” ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tsaychömi mïrra nishgan asgag jachawan vïnuta talutsergan Jesusta uputsinanpag. Tsaynog uputsiyta munapäcuptinpis Jesús manami uporgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nircurnami Jesusta crucificapäcorgan. Crucificaycurnami soldäducuna Jesuspa röpanpag suertita jitapäcorgan mayganpis gänag cag apacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Crucificashgan höra cargan tuta las nuëvinogmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tsaypitanami juc tablaman letrëruta escribircur cruzpa puntanman clävargan. Tsay letrëruchömi caynog escribiraycargan: “Cay runaga Israel runacunapa mandagnin reymi.” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesús crucificaraycashgan naupanmanmi ishcay suwa runacunatapis crucificargan, jucnin cagta derëcha cag naupanman y jucagtana itsog cag naupanman. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tsay suwa runacunawan crucificaptinmi Tayta Diospa palabrancho escribiraycashgannogla pasargan. Tsay escribiraycashganga caynogmi niycan: “Paytapis fiyu runatanogmi runacuna chiquipäcongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Cruzcho caycashganta ricarmi tsaypa pasag runacuna Jesusta asipargan umanta awishpan caynog nir: “Templutapis juchurcatsir quimsa junaglata sharcatsinayquipag cashganta niycarga mä quiquiqui salvacushpayqui cruzpita urämuy, ari.” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tsaynogpis mandag cüracuna y Moisés escribishganta yachatsegcunapis Jesusta asipashpan caynog nergan: “Waquinta salvarpis ¿imanirtag quiquenga salvacuyta mana camäpacuntsu? ");
INSERT INTO qvmNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel runacunapa mandagnin rey cananpag Tayta Diosnintsi cachamushgan Cristo carga mä cruzpita urämutsun nogantsipis criyinantsipag.” Tsaynoglami Jesuspa naupancho crucificaraycag runacunapis payta ashlergan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pulan junag caycaptinmi patsa tsacäcorgan malway intiyag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Malway inti caycaptinmi Jesús fuertipa caynog nergan: “Eloi, Eloi, ¿lama sabactani?” Tsay ninanga caycan “Diosnë, Diosnë ¿imanirtag cachaycamashcanqui?” ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tsaynog nishganta mayarmi tsaycho caycag runacuna waquin nipäcorgan: “Tayta Diosnintsipa profëtan Eliastami gayacuycan.” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tsaymi juc runa gueru puntanman hisöputa rurarcur pochgog vïnuman ushmatsergan. Nircurna Jesusta shogutsiyta munargan. Shiminman churapaptinmi juc runa caynog nergan: “Ama shogutsiytsu. Canan ricashun mä cruzpita jorgunanpag Elías shamunagcu o manacush.” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsaypitana fuertipa gapararcur Jesús wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesús wanushgan höra templo rurincho tsaparag racta cortïna rachicäcorgan janapita urayag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldäducunapa capitanninnami Jesús wanushganta ricar caynog nergan: “¡Rasunpami cay runaga Diospa tsurin cashga!” ");
INSERT INTO qvmNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tsay höra waquin warmicunapis carulapita ricarpaycargan. Paycunawanmi caycargan María Magdalena, shulca cag nipäcushgan Santiagupa y Josëpa maman María y Salomëpis. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tsay warmicunami Galileacho Jesús puriptin yanapar gatirpargan. Paycunawanmi waquin warmicunapis tsaycho caycargan. Tsay warmicunaga Galileapita Jerusalenman Jesús aywaptin paywan aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesús wanorgan viernes tardimi. Cada viernes tardimi Israel runacuna camaricäreg sábado jamay junagpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tsay junag inti jegaycaptinnami Arimatea marcapita cag José aywargan Pilato cagman. Chayaycurmi caynog manacorgan: “Jesuspa ayanta cachapaycalämay pampag apanäpag.” José cargan Israel runacunapa autoridäninmi. Payga shuyaraycargan Tayta Diosnintsi promitishgannogla salvadorta cachamunanpag cashgantami. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ayata cachapänanpag manacuptinmi Pilato yarpachacorgan: “¿Wanushganatsurag o manatsurag?” nishpan. Tsauraga capitanta gayatsergan wanushganta o manarag wanushgantapis tapunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jesús wanushgana caycashganta wilaptinmi tsay capitanta mandargan Jesuspa ayanta entregananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tsauraga José aywargan lïnupita rurashga fïnu säbanasta rantimunanpag. Nircurnami cruzpita jorgurir Jesuspa ayanta tsay tëlawan pitorgan. Tsaynog rurarcurmi pampag apargan gagacho uchcushga sepultüraman. Aywacunanpagnami sepultürapa puncunta tsapargan jatuncaray rumiwan. ");
INSERT INTO qvmNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mayman pampashgantapis musyananpagmi María Magdalena y Josëpa maman Mariapis carulapita ricarpaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado jamay junag pasariptin patsa tsacaycaptinnami María Magdalena, Santiagupa maman María y Salomëpis ali asyag perfümita rantimorgan Jesuspa ayanman winapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo tuta inti jegaycämuptinnami Jesús pamparashganman aywapäcorgan ayanta ricananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aywapäcushpanmi paycuna caynog parlapäcorgan: “¿Pirag sepultüra tsaparag rumita quichapämäshun?” ");
INSERT INTO qvmNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sepultüraman chayaycurnami ricapäcorgan tsaparag rumi quicharaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tsaymi sepultüra rurinman yaycuycur ricapäcorgan juc mözu yorag röpashga jamaraycagta. Payga jamaraycargan Jesuspa ayan cashgan derëcha cag naupanchömi. Payta ricaycurmi pasaypa mantsacashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tsauraga tsay mözu caynog nergan: “Ama mantsacamaytsu. Musyämi crucificaypa wanutsishgan Jesusta ricag shamushgayquita. Payga manami caychönatsu caycan, sinöga cawarimushganami. Masqui ricay, pamparashgancho mananami cannatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nircurnami tsay warmicunata caynog nergan: “Cananga aywapäcuy Pedruta y waquin discïpulucunatapis caynog nir wilanayquipag: ‘Manarag wanur nishushgayquinoglami Jesús Galileaman naupaycan paywan tsaycho tincunayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tsauraga warmicuna jucla aywacärergan mantsacashga sicsicyaycar. Mantsacärishpanmi ricashgancunata pitapis mana wilapargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo tuta Jesús cawarimur puntata yuripargan María Magdalenata. Paypitami naupata Jesús gargorgan ganchis demoniucunata. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yuriparcuptinmi María aywar wilargan Jesuspa discïpuluncunata. Chayananpäga paycuna Jesús wanushganpitami laquishga wagarcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tsaymi María chayaycur Jesús cawarimushganta wilapaptinpis paycuna mana criyipäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsaypitanami Jesuspa ishcay discïpuluncuna Jerusalenpita aywarcaycaptin Jesús tariparcur paycunawan juntu aywargan tsay caminupa. Tsay discïpuluncunaga manami tantyargantsu Jesús cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsaypita pay cashganta reguircurnami Jerusalenman cutergan discípulu mayincunata Jesús yuripashganta wilananpag. Jerusalenman chayaycur wilaptinpis manami criyipäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsaypitanami Jesús yuripargan chunca juc (11) acrashgan discïpuluncunata mësacho micur jamarpaycaptin. Yuriparcurmi caynog nergan: “Yäracuyniynag runacuna, cawarimushgäta wilashuptiqui ¿imanirtag mana criyipäcushcanquitsu? ");
INSERT INTO qvmNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cananpitaga may-tsaypapis aywapäcuy lapan runacunata ali wilacuynëta wilapänayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mayganpis chasquicamar bautizacorga salvashgami canga. Mana chasquicamagcunami itsanga infiernuman gaycushga cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Runacuna tantyacunanpäga milagrucunapis cangapagmi. Tsaymi nogaman yäracamagcuna jutëcho demoniucunata gargonga y juc idiömacunatapis rimanga. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Culebra picaptinpis, venënuta garaptinpis manami wanongapagtsu. Tsaynoglami gueshyagcunapa jananman maquinta churar Tayta Diosta manacuptin aliyangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Discïpuluncunata parlapayta usharcuptinmi Jesucristuta Tayta Diosnintsi gloriaman pushacorgan. Nircurna derëcha cag lädunman Tayta Dios jamatsergan mandag cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tsaypita discïpuluncuna may-tsaychöpis wilacärergan Jesucristupa wilacuyninta. Paycuna wilacäriptinmi Jesucristo ali yanapargan milagrucunatapis rurananpag. Tsayta ricarmi runacuna tantyacärergan tsay wilacushgan Jesucristupa wilacuynin rasunpa cashganta. Amén.");
INSERT INTO qvmNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Cuyay waugui Teófilo: Noga Lucasmi cay libruta Jesucristupita gampag escribimö. Jesucristo wilacuyta galaycushganpita-patsami lapan rurashgancunata apostolnincuna ricargan. Ricashgancunata wilacärinanpagmi apostolnincunata Jesús cachargan. Paycuna wilacäriptinmi mayagcuna Jesuspita atscag escribipäcushga. Tsaymi nogapis cay libruta escribë, galaycushganpita-patsa imanog cashgantapis shumag tapucurcur. Tsaynogpami Jesucristupita yachatsishushgayquita más tantyanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Israel nacioncho Herodes mandag rey cashgan witsanmi juc cüra cargan Zacarías jutiyog. Paymi cargan Abías cürapa castan. Zacariaspa warminmi cargan Elisabet. Paypa taytanpis cürami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paycunaga Tayta Diosnintsi mandashgancunata cumplirmi imaypis cawapäcog. Tsaymi paycunapa wasanta pipis mana rimapäcogtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ishcanpis chachanami capäcorgan. Chacwanyashganyagpis Elisabetpa wawan manami cargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tsaypitami Zacariaspa y cüra mayincunapapis turnun chayaptinna Jerusalenman aywapäcorgan templucho Tayta Diosnintsita sirvinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tsaychömi imaypis rurashgannog suertitarag jitapäcorgan maygan cürapis templuman incienso rupatseg yaycunanpag. Tsaymi suerti yargamorgan Zacariaspag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tsauraga Zacarías templo rurinman yaycuycur inciensuta rupatsishganyagmi lapan runacuna Tayta Diosta manacurcaycargan templo patiucho. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Templucho inciensuta rupaycätsiptinmi altarpa derëcha cag läduncho Tayta Diosnintsipa angilnin Zacariasta yuripargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tsay angilta ricaycurmi Zacarías fiyupa mantsacargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tsauraga ángil caynogmi nergan: “Zacarías, ama mantsacamaytsu. Tayta Diosnintsimi mayashushcanqui manacushgayquita. Tsaymi warmiqui Elisabet wachangapag olgu wamrata. Paypa jutinta churapanqui Juan cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tsuriqui yuriptinmi pasaypa cushicunquipag. Tsaynogpis lapan runacunami cushicongapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tayta Diosnintsipa wilacuyninta wilacogmi tsuriqui cangapag. Manami vïnuta ni ima shincatsicogtapis upongatsu. “Mamanpa pachancho cashganpita-patsami Santu Espíritu payta yanapangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tsaymi Diospa wilacuyninta wilacuptin Israel runacuna jutsancunata cacharir Tayta Diosnintsi munashgannog cawapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tayta Diosnintsipa profëtan Elías wilacushgannogmi paypis wilacongapag. Tsaynogmi runacunata tantyatsenga wayinchöpis cuyanacur cawananpag. Jutsata rurar cawacogcunatami tantyatsenga Tayta Diosnintsi munashgannogna cawapäcunanpag. Tsaynogpami runacunata yachatsenga Cristo shamuptin ali chasquicärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ángil tsaynog niptinmi Zacarías caynog taporgan: “¿Imanogpatag musyashag nimashgayquicuna rasunpa cashganta? Nogaga auquinnami cä. Tsaynogmi warmëpis chacwanna caycan. Tsaynog caycaptëga ¿imanogpatag tsurë canman?” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tsaymi ángil caynog nergan: “Tayta Diosnintsipa wilacognin Gabrielmi caycä. Paymi cachamashga tsuriqui yurinanpag cashganta wilanäpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gamta wilashgäcunaga lapanpis cumplengapagmi. Nishgäcunata mana criyishgayquipitami cananga shimiqui watacashga cangapag hasta tsuriqui yurinanyag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tsayyagmi templo patiucho runacuna shuyarpaycargan: “¿Imanirtag cay hörayag Zacarías mana yargamuntsu?” nipäcushpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tsaymi templupita yargarcamurna shimin watacäcushga captin sëñalapana parlapargan shuyarpaycagcunata. Tsauraga shuyarpaycagcunaga yarpapäcorgan templo rurincho imapis yuripashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsauraga turnunta usharcurnami wayinpana Zacarías cuticorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tsaypitanami warmin Elisabet gueshyag ricacur pitsga quilla wayinpita mana yarguypa täcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cushicushpanmi caynog nergan: “Tayta Diosmi nogata cuyapämashga. Cananpitaga runacuna mananami jamurpämanganatsu wawaynag cashgäpita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet gueshyag ricacushganpita sogta quillatanami Tayta Diosnintsi cachamorgan ángil Gabrielta Galilea provinciacho caycag Nazaret marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tsaychömi virgen Mariata watucorgan. Mariami parlashgana caycargan rey Davidpa castan Josëwan tänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chayaycurmi ángil caynog nergan: “¡María! ¡Tayta Diosnintsi acrashganmi caycanqui!” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsaynog niptinmi María yarpachacorgan: “¿Imanirtag tsaynog niman?” nir. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tsaynog yarpachacuycaptinmi ángil caynog nergan: “María, ama mantsacamaytsu. Tayta Diosnintsimi gamta cuyashunqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cananpitaga gueshyagmi ricacunqui. Wawayqui yurenga olgumi. Paypa jutinmi canga Jesús. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payga munayniyogmi cangapag. Tsaymi payta nipäconga Diospa tsurin cashganta. Paytami Tayta Diosnintsi churanga mandag rey cananpag, unay castan Davidtanog. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paypa maquinchömi Israel runacuna imayyagpis cangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsauraga María caynog taporgan: “Runata manarag reguerga ¿imanogpatag gueshyag ricacöman?” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niptinmi ángil caynog nergan: “Santu Espíritu gamman shamuptinmi Tayta Diosnintsipa munayninwan gueshyag ricacunquipag. Tsaymi wawayquipag runacuna nenga Diospa tsurin cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tsaynogmi castayqui Elisabetpis, chacwanna caycar, wachangapag. Paytami runacuna: ‘Mana wachayta yachag’ nipäcorgan. Sogta quillanami payga gueshyag caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tayta Diosnintsipäga manami imapis sasatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsauraga María caynog nergan: “Nogaga Tayta Diospa maquinchömi caycä. Tsauraga pay munashgannog cayculätsun.” Tsaypitanami ángil aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ángil nishganpita warantincuna María aywargan Judea provincia jircacho caycag marcaman Elisabetta watucunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacariaspa wayinman chayaycurmi saludargan Elisabetta. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Saludaptinmi Elisabetpa pachancho caycag wamrapis cuyorgan. Tsauraga Santu Espiritupa munayninwanmi Elisabet cushicushpan caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“¡Lapan warmicunapitami Tayta Diosnintsi gamta acrashushcanqui! Gueshyag caycashgayqui wawayquita paymi imaypis yanapanga. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cristupa maman caycar watucamänayquipäga ¿pitag cä noga? ");
INSERT INTO qvmNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludamashgayquita mayaycur pachächo caycag wawäpis cushicuypita cuyushgami. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Tayta Diosnintsi nishushgayquita cumplinanpag cashganta criyishgayquipitami imaypis yanapashunquipag!” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsauraga María caynog nergan: “Lapan shongöwanmi Tayta Diosnintsita alabä. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Salvacog Tayta Diosnintsi acramashganpitami cushicö. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mana digno captëpis Tayta Dios cuyapämarmi acramashga. Cananpitaga imaypis runacuna nipäconga Tayta Dios acramashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Munayniyog Tayta Diosnintsi alimi ricamashga. Paynöga manami pipis cantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pay munashgannog cawagcunataga imaypis cuyapanmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pipis mana rurashgancunatami payga ruran. Yachag-tucogcunataga manacagmanmi churan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandag cashganpita nación mandagcunatapis gargun. Mana musyag-tucogcunatami itsanga ali cawananpag yanapan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Muchogcunata micuyta camaripan. Mana cuyapäcog rïcucunatanami itsanga mana yanapannatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Abrahamta promitishganta cumplirmi paypita miragcunata imaypis yanapan. Tsaymi Israel runacunata mana gongaylapa cuyapan.” Tsaynog nirmi Tayta Diosnintsita María alabargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabet cagcho quimsa quillanog goyarcurnami wayinpana María cuticorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetpa quillan aypämushgana captinnami olgu wamrata wachargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wawayog cananpag Tayta Diosnintsi payta yanapashganpitami castancuna y reguinacushgancunapis cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tsaymi pusag (8) junagniyog wamran caycaptin Zacariaspa wayinman paycuna aywapäcorgan wamranpa cuerpunta señalananpag. Tsaychömi taytanpa jutinta churapayta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tsauraga maman caynog nergan: “¡Manami tsaynogtsu jutin canga! Juanmi jutin canga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Elisabet tsaynog niptinmi waquin runacuna nipäcorgan: “Castayquicuna tsay jutiyog mana caycaptenga ¿imanirtag munanqui Juan jutin cananta?” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsauraga ima jutita churapänanpagpis sëñalapa Zacariasta tapupäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tapuptinmi pay manacorgan tacshala tablata tsaycho escribinanpag. Nircurna tsaycho escribergan: “Juanmi jutin canga” nishpan. Zacariaspis tsurinpa jutin Juan cananta munaptinmi tsaycho cag runacuna äyacashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tsauraga jinan hörami shimin pashtarcuptin Zacarías Tayta Diosnintsita alabargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsaycunata ricaycur lapan reguinacushgancuna cushicärergan. Tsay pasashganpitami pï-maypis parlapäcorgan intëru tsay marcacunacho. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tsayta mayagcuna yarpachacärergan caynog nir: “¡Cay wamra winarcur ima munayniyograg cayconga!” Runacuna parlashgannoglami tsay wamrata Tayta Diosnintsi yanapargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tsauraga Santu Espíritu tantyatsiptinmi Zacarías caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel runacunata yanapag Tayta Diosnintsi alabashga cayculätsun. Payga salvamänantsipagnami caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pay munashgannog cawag Davidpa castancunapitami munayniyog salvador yurengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tsaynog cananpagmi unaypita-patsa musyatsimargantsi wilacog profëtancunawan. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tsaynogpis musyatsimargantsi contrantsicunapita jorgamänantsipag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Abrahamta y paypita miragcunatapis promitishgancunataga manami gongashgatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Tsaymi cananga chiquimagnintsicunapa maquincho cashgantsipita Tayta Diosnintsi jorgamäshun pay munashgannog mana mantsacuypa waran waran cawanantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacarías tsaynog niyta usharcurmi tsurintana caynog nergan: “Cristuta chasquicärinanpag wilacuptiquimi runacuna musyapäconga Tayta Diosnintsipa profëtan cashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wilacognin carmi runacunata tantyatsinquipag Tayta Diosnintsi perdonar salvananpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Runacunata cuyaparmi Tayta Diosnintsi Cristuta cachamonga. ");
INSERT INTO qvmNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsaymi Cristo shamur jutsata rurar cawagcunata tantyatsengapag jutsancunata cacharir Tayta Dios munashgannogna cawapäcunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Juanga winashgan-tupumi Tayta Dios munashgannog ali cawargan. Chunyag jircalacho targan hasta Tayta Diosnintsipa wilacuyninta Israel runacunata wilapayta galaycushganyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tsay witsanmi Augusto jutiyog runa emperador César cargan. Paymi mandargan mandashgan cag nacioncunacho lapan runacuna censacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tsay censacuy cargan Cirenio jutiyog runa Siria provinciacho gobernador caycaptin punta cag censacuymi. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tsauraga lapan runacuna aywapäcorgan marcanman-cama censacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josëpa marcanga Judea provinciacho cag Belenmi cargan. Belén marcaga marcan cargan unay castan rey David tsaycho yurishga captinmi. Tsaymi Mariawan Josëpis Galilea provinciacho cag Nazaret marcapita Belén marcaman aywapäcorgan censacärinanpag. Tsay junagcuna María quillanchönami caycargan wachacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belencho caycaptinnami Mariata wachay nanay tsarergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maychöpis posädacärinanpag mana captinmi guechpa wawanta wachacorgan uywacuna punucunalancho. Inchanawan piturcurmi naupalanman punuycatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén marca naupanchömi uyshayogcuna täparcaycargan uyshancunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsaymanmi Tayta Diosnintsipa angilnin elagpita atsicyaypa atsicyar yuripargan. Tsayta ricarmi uysha täpagcuna fiyupa mantsacargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Tsaymi ángil caynog nergan: “Ama mantsacamaytsu. Tayta Diosnintsi cachamushgan Cristumi runacunata salvananpag Davidpa marcancho yurishga. Pay yurishganta musyarmi lapan runacuna cushicongapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Belenman aywarmi tsay itita taripäcunquipag uywacuna punucunalancho mamanpa naupancho inchanawan pitushga caycagta. Tsaynog caycagta tarirmi cay niycashgä rasunpa cashganta musyapäcunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tsaynog niycaptinmi elagpita tsay angilpa naupancho ricacämorgan más atsca angilcunapis Tayta Diosnintsita caynog alabar: ");
INSERT INTO qvmNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Jana patsacho Tayta Diosnintsi adorashga cayculätsun! ¡Cay patsachöpis Tayta Diosnintsi cuyashgancunapag ali caway cayculätsun!” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tsaypita angilcuna gloriaman cuticäriptinna uysha täpagcuna jucnin jucninpis caynog parlapäcorgan: “Tayta Diosnintsi wilatsimashgantsinog acu aywashun Belenman tsay itita ricanantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tsaynog nirmi apurädu aywapäcorgan Belén marcaman. Chayaycurna taripäcorgan Josëta, Mariata y itintapis uywacuna punucunalancho carcaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tsaynog tariycushpanna wilapargan itipita ángil wilashgancunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tsaynog wilapaptinmi lapan mayagcuna cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marianami paycuna nishgancunata shongulancho imaypis yarparargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ángil wilashgannogla ricaycurmi uysha täpagcuna Tayta Diosnintsita alabashpan cuticärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tsaypita pusag (8) junagniyog caycaptinmi costumbrin cashgannog itipa cuerpunta señalatsergan. Tsaychömi jutinta churapargan María manarag gueshyag captin ángil nishgannogla. Tsay junagpitanami tsay itipa jutin cargan Jesús. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","María wachashganpita chuscu chunca (40) junagtanami Josëwan aywargan Jerusalén templuman Moisés escribishgancho nishgannog purificacunanpag. Itintapis templuman apapäcorgan Tayta Diosnintsipa munayninman churapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tsayta rurargan: “Tayta Diospa munayninman churapäcuy lapan guechpa olgu wamrayquicunata” nir Moisés escribishgannoglami. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Warmicuna wachacushganpita templuman imata apananpagpis caynogmi Moisés escribergan: “Ishcay culcushcunata o ishcay pushapa paloma malwacunata carpis apanqui.” Tsaymi Mariapis tsay escribiraycashgannogla tsaycunata apargan templuman. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Tsay witsanmi Jerusalencho targan Simeón jutiyog runa. Paymi alilata rurashpan Tayta Diosnintsita alabar cawargan. Tsaynogpis shuyarargan Israel runacuna nacaycashganpita Cristo shamur jorgunanpag cashganta. Santu Espiritumi payta musyatsergan Cristuta ricaycurrag wanunanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Templuman aywananpag Santu Espíritu tantyatsiptin Simeón aywarmi ricargan Mariawan José itita tsayman apaycagta. Tsayman paycuna aywapäcorgan Moisés escribishgancunata tsaycho cumplipäcunanpagmi. Tsauraga tsay itita margarcurnami Tayta Diosnintsita Simeón alabargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tayta Dios, cananga cumplishcanquinami nimashgayquita. Cananga ricashcänami cachamushgayqui salvadorta. Ricashgächönaga cushishganami wanucushagpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","May-tsaychöpis tag runacuna musyapäcongami cay wamrata gam cachamushgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tsaymi mana Israel runacunapis tantyapäconga runacunata salvanayquipag cashganta. Tsaynog captinmi gamta alabapäcushunqui: ‘¡Imajinanparag Israel runacunata Tayta Diosnintsi cuyargan tsay castapita salvadornintsita cachamunanpag!’ nishpan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón tsaynog nishgancunata mayarmi Josëwan María cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tsauraga Tayta Diosnintsita Simeón manacorgan paycunata yanapananpag. Nircurna Mariata caynog nergan: “Cay itita Tayta Diosnintsi cachamushga captinmi waquin Israel mayintsipis gloriaman chayangapag. Waquin cagnami infiernuman gaycushga cangapag. Cay iti winarcur Tayta Diosnintsipa wilacuyninta wilacuptinmi atsca runacuna payta chiquengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tsaynogpami musyacanga runacuna yarpashgan ali o mana ali cashganpis. Tsaynog pasaptinmi gampa shonguyqui tucsishganograg laquicongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Templo patiucho caycargan Tayta Diosnintsipa profëtan Ana jutiyog chacwanpis. Paypa taytanmi cargan Fanuel, Aser castapita. Anami wamra jipashla caycar runawan targan. Runawan tashganpita ganchis watalatami runan wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tsaymi viüdala cacorgan pusag chunca chuscu (84) wata. Payga pagasta junagtami templucho ayunashpan Tayta Diosnintsita manacur cacog. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anapis Jesús caycashgan cagman chayaycushpannami payta ricar Tayta Diosnintsita manacur agradëcicorgan. Tsaynogpis Jesuspita wilapargan Tayta Dios cachamushgan Cristuta shuyarpaycag runacunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tayta Diosnintsipa palabrancho nishgancunata templucho cumplircurnami Josëwan María cuticärergan Galilea provinciacho caycag Nazaret marcanman. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tayta Diosnintsi ali yanapaptinmi winashgan-tupu Jesús más yarpayniyog ricacorgan y calpanpis yurergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa maman María y Josëpis cada watami Jerusalenman aywapäcog Pascua aniversariupag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tsaymi Jesús chunca ishcay (12) watayog caycaptinna paywanpis aywapäcorgan tsay aniversariuman. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pascua ushaynami Josëwan María marcanpana cuticärergan. Jerusalencho Jesús quëdacushgantaga manami cuentata gocärergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tsaymi waquin runacunawan Jesús aywaycashganta yarpashpan juc junag goyaytana aywapäcorgan. Tsaypita castancunacho y reguinacushganchöpis Jesusta ashir manami taripäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tariycushpanmi cutipäcorgan Jerusalenman tsaycho ashipäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cutishganpita wara junagragmi Jesusta taripäcorgan templucho caycagta. Tsaychömi masta yachacunanpag yachag runacunata tapucur jamaraycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Shumag tantyaycur tapucushganta mayarmi lapan mayagcuna cushicärergan. Tsaynogpis cushicärergan yachag runacuna tapushganta Jesús ali contestaptinmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tsauraga tsaycho tariycurmi Josëwan María pasaypa cushicärergan. Tsaychömi maman caynog nergan: “¿Imanirtag caycho quëdacorgayqui? Nogacuna pasaypa laquicurmi gamta ashipäcushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tsaynog niptin Jesús nergan: “¿Imanirtag ashipäcamanqui? ¿Manacu musyapäcunqui Taytäpa templuncho canäpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tsaynog niptin paycunaga manami tantyapäcorgantsu imanir tsaynog niycashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nircur Jesuswanna cuticärergan Nazaretman. Tsaychömi maman y taytan mandashgancunata Jesús rurargan. Mamanga shongulanchömi yarparargan ima pasashgancunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Winashgan-tupumi Jesús más yachayniyog ricacorgan. Tsaynoglami respitösu captin Tayta Diosnintsipis y runacunapis payta cuyargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zacariaspa tsurin Juan chunyag jircacho caycaptinmi Tayta Diosnintsi nergan wilacuyninta wilacunanpag. Tsay witsanmi Tiberio jutiyog runa emperador César caycargan. Paymi chunca pitsga (15) watana lapan nacionpa mandagnin caycargan. Tsaynogpis Poncio-Pilato gobernador caycargan Judea provinciacho. Herodisnami mandag caycargan Galilea provinciacho. Herodispa wauguin Felipe mandag caycargan Iturea y Traconite nishgancho. Tsaynogmi Lisaniaspis mandag caycargan Abiliniacho. Jerusalenchönami Anaswan Caifás más mandag cüra caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsaymi Jordán mayu naupancho cag marcacunapa Juan purergan caynog wilacushpan: “Tayta Diosnintsi perdonashunayquipag jutsa rurashgayquita cacharir bautizacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan Bautista manarag yuriptinmi Tayta Diosnintsipa profëtan Isaías paypita escribergan caynog nir: “Chunyag jircachömi juc runa fuertipa wilaconga caynog nir: ‘Mandag runa shamuptin chasquicunayquipag caminuta pitsar camaricushgayquinog jutsa ruraycunata cacharir camaricäriy Tayta Diosnintsi shamuptin chasquicärinayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tsaynog camaricäriy ragracunata pampatsagnog, jircacunata pampatsagnog, wicsu nänicunata derechagnog y uchcu uchcu nänita pampatsagnogpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tsaynogpami lapan runacuna tantyacärenga Tayta Diosnintsi salvananpag cashganta.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Runacuna bautizacärinanpag shamuptinmi Juan caynog nergan: “¡Culebra casta runacuna! ¿Imanirtag gamcuna yarparcaycanqui jutsayog captiquipis Tayta Diosnintsi infiernuman mana gaycushunayquipag cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tayta Diosnintsi infiernuman mana gaycushunayquipäga jutsa rurayta cacharir pay munashgannogna cawapäcuy. Ama yarpapäcuytsu Abrahampa castan cashgalayquipita Tayta Diosnintsi salvashunayquipag cashganta. Tayta Dios munarga cay rumicunatapis Abrahampa castanman ticraratsinmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mana ali wayog yöracunata sapipita muturir ninaman gaycushgantsinogmi Tayta Diosnintsega jutsa ruragcunata infiernuman gaycunanpag listuna caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juan tsaynog niptinmi runacuna caynog tapupäcorgan: “Tsauraga ¿imatatag rurapäcöman salvacunäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tsaynog tapuptinmi caynog nergan: “Ishcay trucana röpayog carga jucag cag röpayquita goycuy röpaynag cagta. Tsaynogpis micuyniyog carga raquipaycuy micuyniynag cagta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tsaynoglami impuestuta cobragcunapis, bautizacunanpag shamur, caynog tapupäcorgan: “Tayta, nogacunaga ¿imatatag rurapäcöman salvacunäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tsauraga Juan caynog nergan: “Cobranayquipag cashganpita mastaga ama cobrapäcunquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tsaynoglami taporgan soldäducunapis caynog nir: “Nogacunaga ¿imatatag rurapäcöman salvacunäpag?” Tsaymi Juan caynog nergan: “Ama pipa guellaynintapis guechupäcunquitsu. Tsaynog ama pipagpis manacagtaga tumpanquitsu. Arushgayquipita chasquishgalayquiwan contentacärinqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tsauraga Cristo cay patsaman shamunanpag cashganta shuyarag runacuna yarpachacushpan caynog nergan: “¿Juantsurag Tayta Dios cachamushgan Cristo caycan?” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tsaymi Juan caynog nergan: “Cristoga tsayragmi shamonga. Nogaga yaculawanmi gamcunata bautizä. Tayta Diosnintsi cachamushgan Cristumi itsanga Santu Espirituwan y ninawanpis bautizapäcushunquipag. Nogaga manami paynog munayniyogtsu caycä. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Payga jurquëtan aptashgami caycan trïguta wayrananpag. Nircurmi trïgu cagta churanga wayinman. Y punshantana gayconga imaypis mana upeg ninaman tsaycho rupananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tsaynog parlaparmi Juan yachatsergan Tayta Diosnintsipa wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tsaynogpis runacunata Juan caynog nergan: “Wauguin Felipipa warminta suwapar rey Herodes jutsatami rurashga. Tsaynoglami más jutsatapis payga ruraycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tsaynog parlaycashganta musyarmi Juanta prësu tsarircatsir Herodes wichgatsergan carcilman. Tsaynog wichgatsirmi más jutsayog ricacushga. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Carcilman Juan manarag yaycurmi runacunata bautizaycaptin Jesuspis chayargan bautizacunanpag. Bautizacurcur Tayta Diosta manacuycaptinmi jana patsa quichacäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tsaychömi Jesusman Santu Espíritu urämorgan palomanog. Tsaymi ciëlupita mayacämorgan Tayta Dios caynog nimushgan: “Gamga cuyay tsurëmi canqui. Noga munashgänog lapanta cumpliptiquimi cushishga caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quimsa chunca (30) watayognogna caycar bautizacurcurmi Jesús wilacuyta galaycorgan Tayta Diosnintsipa wilacuyninta. Paypäga runacuna yarpargan Josëpa tsurin cashgantami. Josënami Elïpa tsurin cargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elïmi cargan Matatpa tsurin. Matatmi cargan Levïpa tsurin. Levïmi cargan Melquipa tsurin. Melquimi cargan Janapa tsurin. Janami cargan Josëpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josëmi cargan Matatiaspa tsurin. Matatiasmi cargan Amospa tsurin. Amosmi cargan Nahumpa tsurin. Nahummi cargan Eslipa tsurin. Eslimi cargan Nagaipa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaimi cargan Maatpa tsurin. Maatmi cargan Matatiaspa tsurin. Matatiasmi cargan Semeipa tsurin. Semeimi cargan Josëpa tsurin. Josëmi cargan Judäpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judämi cargan Joanapa tsurin. Joanami cargan Resapa tsurin. Resami cargan Zorobabelpa tsurin. Zorobabelmi cargan Salatielpa tsurin. Salatielmi cargan Neripa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerimi cargan Melquipa tsurin. Melquimi cargan Adipa tsurin. Adimi cargan Cosampa tsurin. Cosammi cargan Elmodampa tsurin. Elmodammi cargan Erpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ermi cargan Josuëpa tsurin. Josuëmi cargan Eliezerpa tsurin. Eliezermi cargan Jorimpa tsurin. Jorimmi cargan Matatpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatmi cargan Levïpa tsurin. Levïmi cargan Simeonpa tsurin. Simeonmi cargan Judäpa tsurin. Judämi cargan Josëpa tsurin. Josëmi cargan Jonanpa tsurin. Jonanmi cargan Eliaquimpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimmi cargan Meleapa tsurin. Meleami cargan Mainanpa tsurin. Mainanmi cargan Matatapa tsurin. Matatami cargan Natanpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanmi cargan Davidpa tsurin. Davidmi cargan Isaïpa tsurin. Isaïmi cargan Obedpa tsurin. Obedmi cargan Boozpa tsurin. Boozmi cargan Salmonpa tsurin. Salmonmi cargan Naasonpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonmi cargan Aminadabpa tsurin. Aminadabmi cargan Arampa tsurin. Arammi cargan Esrompa tsurin. Esrommi cargan Farespa tsurin. Faresmi cargan Judäpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judämi cargan Jacobpa tsurin. Jacobmi cargan Isaacpa tsurin. Isaacmi cargan Abrahampa tsurin. Abrahammi cargan Tarëpa tsurin. Tarëmi cargan Nacorpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacormi cargan Serugpa tsurin. Serugmi cargan Ragaupa tsurin. Ragaumi cargan Pelegpa tsurin. Pelegmi cargan Heberpa tsurin. Hebermi cargan Salapa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salami cargan Cainanpa tsurin. Cainanmi cargan Arfaxadpa tsurin. Arfaxadmi cargan Sempa tsurin. Semmi cargan Noëpa tsurin. Noëmi cargan Lamecpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecmi cargan Matusalenpa tsurin. Matusalenmi cargan Enocpa tsurin. Enocmi cargan Jaredpa tsurin. Jaredmi cargan Mahalaleelpa tsurin. Mahalaleelmi cargan Cainanpa tsurin. ");
INSERT INTO qvmNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanmi cargan Enospa tsurin. Enosmi cargan Setpa tsurin. Setmi cargan Adanpa tsurin. Y Adanmi cargan Tayta Diosnintsi camashgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jordán mayucho Jesús bautizacushganpitanami Santu Espíritu payta pushargan chunyag jircaman. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tsaychömi chuscu chunca (40) junag Satanás payta camargan jutsata ruratsinanpag. Tsay junagcuna ayunar manami imatapis micorgantsu. Tsaymi wanuyparag Jesusta micanay tsaricuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tsaynog micanaycaptinmi Satanás yuripaycur caynog nergan: “Diospa tsurin caycarga micunayquipag cay rumita tantaman ticraratsiy, ari.” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tsaynog niptin Jesús nergan: “Tayta Diospa palabrancho caynogmi niycan: ‘Manami micuyta miculartsu runacuna cawan, sinöga Tayta Dios nishgancunata cäsucushpanpis cawanmi.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsaypitanami altunnin puntapita Satanás elagpita ricatsergan may-tsay nacioncunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nircurmi nergan: “Gongurpaycur nogata adoramaptiquega cay ricashgayqui nacioncunata y tsaycho cag riquëzacunatami goycushayqui. Lapan ricashgayquicunataga noga chasquishcä munashgä cagta pitapis goycunäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tsaymi Jesús caynog nergan: “¡Witicuy, Satanás! Tayta Diospa palabranchöga caynogmi escribiraycan: ‘Tayta Dioslatami adoranqui y pay japalantami sirvinqui.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tsaypitanami elagpita Jesusta Satanás ricacatsergan Jerusalén templo janancho. Tsaychönami payta caynog nergan: “Diospa tsurin carga caypita pampaman tuniy. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diospa palabranchöga caynogmi escribiraycan: ‘Angilnincunatami Tayta Diosnintsi cachamonga maycho captiquipis cuidashunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Paycunami tsarishunqui pampaman tuniptiqui ni chaquilayquitapis rumicunaman mana tacacunayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Niptinmi Jesús nergan: “Tayta Diospa palabranchöga caynogmi niycan: ‘Tayta Diosta ama obligaytsu quiquiqui munashgayquita ruratsinayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tsauraga yarpashganta ruratsiyta mana camäpacurcurnami payta cachariycur Satanás aywacorgan yapay cutimunanyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tsaypitami Santu Espiritupa munayninwanna Jesús cutergan Galilea provinciaman. Intëru tsay marcacunachömi paypita runacuna parlapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tsay marcacunacho cag sinagogacunacho Jesús yachatsiptinmi lapan runacuna: “Ali yachatsicogmi payga” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsaypitanami Jesús aywargan naupata tashgan Nazaret marcaman. Tsaymi imaypis aywashgannog sábado jamay junagcho aywargan sinagogaman. Tsaychönami runacunapa naupagninman aywargan Tayta Diosnintsipa palabranta liyimunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsaycho liyimunanpagmi macyargan profëta Isaías escribishganta. Tsaymi liyimorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Santu Espiritutami Tayta Dios nogaman cachamushga yanapamänanpag. Paymi acrarcamar yanapaycäman wactsa runacunaman ali wilacuyta apanäpag. Tsaynogpis paymi cachamashga laquishga cagcunata shacyätsinäpag. Tsaynogpis cachamashga carcilcho cagcuna librina cananpag cashganta wilanäpag, gapracunapa nawinta aliyätsinäpag, jucpa maquincho nacaycag runacunata jorgunäpag ");
INSERT INTO qvmNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y Tayta Diosnintsita cäsucur ali cawapäcunanpag cag tiempo chämushgantana wilacunäpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsaynog liyircurnami Isaías escribishganta Jesús cutiycatsergan sinagogacho yanapag runata. Cutiycatsir jamacuycuptinmi tsaycho caycag runacuna payta ricarpaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsaymi Jesús caynog nergan: “Tsay liyimushgäta unay escribergan noga ruranäpag cagcunapitami. Tsay escribiraycashgannog cumpliycashgäta gamcuna ricarcaycanquinami.” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tsaynog niptinmi runacuna Jesuspa contran parlapäcorgan caynog nir: “¿Imatatag pay musyan tsaynog parlananpag? ¿Manacu payga Josëpa tsurin?” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsauraga Jesús caynog nergan: “Gamcuna capaschari yarparcaycanqui Capernaumcho milagruta rurashgänog cay marcantsichöpis milagruta ruranäpag cashganta. Tsaynog yarpashgayquega runacuna caynog nipäcushgannoglami caycan: ‘Jampicog carga quiquiquirag jampicuy.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nircurmi Jesús caynog nergan: “Tayta Diosnintsipa profëtancuna quiquinpa marcancho mana chasquishga cashgannogmi gamcunapis mana chasquiycämanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Yarpapäcuy Tayta Diosnintsipa wilacognin Elías cawanan witsan imanog pasashgantapis. Quimsa wata sogta quillan mana tamyaptin lapan marcacunachöshi muchuy cargan. Tsay witsan Israel nacioncho atsca viüdacuna caycaptinpis Tayta Diosnintsi manashi cachargantsu Eliasta maygan viüdata yanapananpagpis. Tsaypa trucanga cachargan Sidoncho cag Sarepta nishgan marcacho tag viüdalata yanapananpagshi. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tsaynogpis Tayta Diosnintsipa wilacognin Eliseo cawanan witsan Israel nacioncho atscagshi cargan leprawan gueshyaycagcuna. Tsay gueshyawan atscag gueshyaycaptinpis Eliseo manashi aliyätsergantsu maygantapis. Siria nacionpita cag Naamantashi itsanga aliyätsergan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tsauraga Jesús tsaynog nishganta mayapäcushpan tsaycho cagcuna tantyacärergan paycunapag milagruta rurananpa trucanga juc lädu marcacunalacho rurananpag cashgantami. Tsaymi fiyupa rabiacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gaga janancho paycunapa marcan captinmi Jesusta apapäcorgan gaga quirunman tsaypita tangarinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tsaypita tangananpag aparcaycaptinmi paycunapa chaupinpita yargurir Jesús aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsaypitami Galilea provinciacho cag Capernaum marcaman Jesús aywargan. Tsaychömi cada sábado jamay junag runacunata yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jesusga manami waquin yachatsegcunanogtsu yachatsergan, sinöga paycunapita más alimi yachatsergan. Tsaynog yachatsiptinmi runacuna pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tsay sinagogachömi caycargan demonio löcuyätsishgan runa. Paymi gaparargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¡Nazaret marcapita cag Jesús! ¿Imatatag munanqui nogacunawan? ¿Nogacunata gargamänayquipagcu shamushcanqui? ¡Noga musyämi Dios cachamushgan Cristo cashgayquita!” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsaynog niptinmi Jesús olgöpargan demoniuta caynog nir: “¡Upälala cay runapita jucla yarguy!” Tsaynog niptinmi lapan runacunapa naupancho tsay runata sagtariycur demonio aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tsayta ricaycurmi lapan runacuna cushicushpan jucnin jucninpis caynog parlapäcorgan: “¡Imajinanparag munayniyog caycan demoniucuna payta cäsucunanpäga!” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Demoniuta gargushganta musyarmi lapan marcacunacho runacuna parlapäcorgan Jesús munayniyog cashganpita. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsauraga sinagogapitanami Jesús aywargan Simonpa wayinman. Chayananpagmi Simonpa suedran fiebriwan antsa jitaraycargan. Tsaymi tsaycho caycag runacuna Jesusta ruwacärergan payta aliyätsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tsay fiebrita Jesús olgöpaptinmi Simonpa suedran jinan höra aliyargan. Aliyarcurnami micuyta paycunata garargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsaypita inti jegaycaptinnami Jesusman apapäcorgan tucuy-nirag gueshyawan gueshyaycagcunata. Tsay gueshyagcuna yatayculaptinmi aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tsaynogmi waquin gueshyagcunapitapis demoniucuna yargapäcorgan caynog gaparpashpan: “¡Gamga Diospa tsurinmi canqui!” Tayta Dios cachamushgan Cristo cashganta wilacäriptinmi demoniucunata Jesús olgöpargan imatapis mana rimacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Patsa wararcuptinnami marcapita Jesús aywargan chunyagninman. Tsauraga runacuna ashishpan pay caycashgan cagman chayapäcorgan. Tsaycho tariycur manacärergan paycuna cagpita mana aywacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tsaymi Jesús caynog nergan: “Waquin marcacunachöpis Tayta Diosnintsipa wilacuyninta wilacunämi caycan. Tsaypagmi Tayta Diosnintsi cachamashga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsauraga sinagogacunacho may-tsaychöpis Jesús wilacorgan Tayta Diosnintsipa wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","2","Tayta Diosnintsipa wilacuyninta Genesaret lagünacho atsca runacunata yachaycätsishpanmi Jesús ricargan ishcay büquicuna lagüna cuchuncho jinayla caycagta. Pescädo tsaregcunaga büquincunapita yargurishpanmi rednincunata tagsharcaycargan. Jesús yachatsishganta mayayta munarmi atsca runacuna pay cagman juntacargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsaymi Simonpa büquinman Jesús witsarcur Simonta manacorgan cuchunpita más washa lädunman büquinta apananpag. Tsay büquiman jamaycushpanmi tsaypitana runacunata yachatsimorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachatsiyta usharcushpannami Simonta caynog nergan: “Cananga büquiquita apay más chaupin-niragman. Nircur tsaycho mashtay redniquita pescäduta tsarimunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tsaynog niptin Simón caynog nergan: “Waraylata pescacuycarpis manami ni juclaylatapis tsaripäcushcätsu, tayta. Imanog captinpis nimaptiquega yapay mashtapäcushag rednëta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tsaynog nishpanmi redninta mashtar atsca pescäducunata tsaripäcorgan, hasta redninpis rachinashganyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsaymi jucag büquicho pescädo tsareg mayincunata guemlaypa gayacärergan yanapananpag. Paycuna chayaycurmi ishcan büquiman pescäducunata winapäcorgan büquincunapis talpunashganyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Tsaychömi caycargan Zebedeupa tsurincuna Santiago y Juanpis. Paycunami cargan Simonpa pescädo tsareg mayincuna. Atsca pescäducunata tsarirmi lapanpis fiyupa mantsacashganog ricacärergan. Tsaymi Jesuspa naupanman gongurpacuycur Simón Pedro caynog nergan: “Jutsasapa runami cä, tayta. Tsaynog caycarga manami naupayquichöpis calämantsu.” Niptinmi Jesús caynog nergan: “Ama mantsacuytsu. Pescäduta tsarinayquipa trucanga runacunatanami Tayta Diosnintsipa wilacuyninta wilapanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tsaynog niptinmi lagüna cuchuncho büquincunata y lapan imancunatapis cachariycushpan Jesuswan aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús juc marcacho caycaptinmi chayargan leprawan pasaypa gueshyaycag runa. Tsay runami Jesuspa naupanman gongurpacuycushpan caynog nergan: “Sänu canäpag aliyaycatsilämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsaynog ruwacuptinmi Jesús yataycur caynog nergan: “Cananpitaga aliyashganami canqui.” Tsaynog niptinmi jinan höra aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nircurnami Jesús caynog nergan: “Ama pitapis wilanquitsu noga aliyätsishgäta. Tsaypa trucanga Moisés escribishgancho nishgannogpis templuman ayway aliyashgana cashgayquita cüra ricashunayquipag. Nircurna Moisés escribishgancho nishgannogla aliyashgayquipita lapantapis ruranqui. Aliyashgana cashgayquita cüra nishuptiquimi lapanpis musyanga rasunpa aliyashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aliyätsishganta pipis musyananta mana munaycaptinpis may-tsaychömi runacuna musyargan. Tsaymi atsca runacuna pay cagman juntacargan yachatsishgancunata mayapäcunanpag y gueshyaycashganpita aliyätsishga cananpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesusga imaypis chunyagninmanmi aywag Tayta Diosta manacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc wayicho runacunata Jesús yachaycätsiptinmi tsaycho jamarpaycargan Moisés escribishganta yachatsegcuna y fariseucuna. Paycuna shapäcamorgan Galilea provinciapita, Judea provinciapita y Jerusalenpitapis. Tayta Diosnintsipa munayninwanmi Jesús caycargan gueshyagcunata aliyätsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsaymanmi runacuna quirmawan apapäcorgan paralítico runata. Chayaycatsirmi imaycanogpapis Jesuspa naupanman yaycatsiyta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Atsca runacuna tsaycho captinmi wayi puncunpa yaycatsiyta mana camäpacärergantsu. Tsaymi wayi jananman witsarcatsir wayi gataraycashganta uchcurergan. Nircur wascawan warcuypa quirmantinta urätsergan Jesuspa naupanman. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tsay runacuna payman yäracärishganta musyarmi tsay gueshyaycag runata Jesús caynog nergan: “Lapan jutsayquipita perdonashganami caycanqui, hïjo.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsaynog niptinmi Moisés escribishgan leycunata yachatsegcuna y fariseucuna yarpachacärergan caynog nir: “¿Pitag cay runaga Dios-tucur lutanta parlananpäga? Tayta Dioslami munayniyog caycan runacunata perdonananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tsaynog yarparcaycashganta musyarmi Jesús caynog taporgan: “¿Imanirtag tsaynog yarparcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Maygantag más sasa caycan? ¿Runapa jutsancunata perdonaycu? ¿O gueshyaycashganta aliyätsiycu? ");
INSERT INTO qvmNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nogami munayniyog caycä runapa jutsancunata perdonanäpag. Tsayta musyapäcunayquipagmi cay runata aliyätsishag.” Nircur tsay gueshyaycag runata caynog nergan: “¡Sharcuy! Quirmayquita apacurcur wayiquipa aywacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tsaynog niptinmi jinan höra gueshyaycag runa aliyashgana sharcorgan. Nircur quirmanta apacurcur wayinpa aywacorgan Tayta Diosnintsita alabashpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsayta ricaycurmi runacuna cushicushpan Tayta Diosta alabapäcorgan caynog nir: “¡Cay runa aliyätsishgantanöga manami imaypis ricashcantsitsu!” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsay wayipita Jesús aywaycashganchömi Mateo jutiyog runata ricargan impuestuta cobrar jamaraycagta. Tsaymi Jesús payta caynog nergan: “Discïpulö canayquipag nogawan aywashun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tsauraga cobracuyta cachariycur Jesuswan Mateo aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Discïpulun cananpag Jesús acrashganpita cushicushpanmi micuyta wayincho Mateo ruratsergan discïpuluncunawan Jesús micunanpag. Tsaychömi impuestuta cobrag mayincuna y waquin runacunapis Jesuswan atsca micurcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tsay runacunawan Jesús caycagta ricaycurmi Moisés escribishganta yachatsegcuna y fariseucuna Jesuspa discïpuluncunata caynog nergan: “¿Imanirtag gamcuna impuesto cobragcunawan y Tayta Diosta mana cäsucogcunawanpis micapäcunqui y upupäcunqui?” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tsaynog nishganta mayarmi Jesús caynog nergan: “Gueshyagcuna jampicogta nistashgannoglami jutsasapacunapis Tayta Diosnintsipa wilacuyninta pilapis tantyatsinanta nistapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nogaga manami Tayta Diosnintsi munashgannog cawag runacunalata Diospa wilacuyninta wilapänäpagtsu shamushcä, sinöga pay munashgannog mana cawag runacunatapis wilapänäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tsaypitanami Jesusta taporgan caynog nir: “Juan Bautistapa discïpuluncuna y fariseucunapa discïpuluncunaga ayunar Tayta Diosta imaypis manacärinmi. Gampa discïpuluyquicunaga ¿imanirtag paycunanog mana ayunapäcuntsu?” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tsaynog tapuptinmi Jesús caynog nergan: “Casaray fiestaman gayatsishgan cagcuna ¿ayunanmantsurag? ");
INSERT INTO qvmNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Casarag mözu wanuptinmi itsanga ayunapäcongapag. Tsaynoglami discïpulöcunapis paycunawan cashgäyäga mana ayunanmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tsaymi Jesús mastapis caynog nergan: “Manami pipis mushog röpata rachintsu macwa röpata shilpananpag. Tsaynog rurarga perditsengami mushog röpata. Tsay mushog röpapita rachishga träpoga manami camarangatsu macwa röpachöga. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tsaynogpis tsayrag rurashga aswata manami winantsitsu shilicaycag urpumanga. Shilicaycag urpuman winaptintsega aswa pogur tsay urputa latsquiriycongami. Tsauraga aswapis jichangami y urpupis paquir ushacangami. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tsaymi sänu urpuman tsayrag rurashga aswata winantsi. Tsaynog ruraptintsega aswapis manami jichangatsu ni urpupis paquengatsu. Tsaynoglami nogapa yachatsicuynëpis mushog car gamcunapa costumbriquicunamanga mana tincuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Tsaynogpis manami pipis pogushga vïnuta yawarcur tsayrag rurashga vïnuta upuyta munantsu: ‘Pogushga vïnoga manami tincuntsu tsayrag rurashga vïnuman’ nishpan. Tsaynoglami unay yachatsicuycunawan yachacashga car noga yachatsishgäcunata runacuna chasquicuyta mana munantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sábado jamay junagchömi discïpuluncunawan Jesús pasarcaycargan trïgu poguraycag chacracuna cuchunpa. Tsaypa pasarmi Jesuspa discïpuluncuna trïguta palarcur cuparishpan micapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tsayta ricarmi fariseo runacuna caynog nergan: “Sábado jamay junag mana arunapag Moisés escribishgan leycunacho niycaptenga ¿imanirtag discïpuluyquicuna trïguta palarcaycan?” ");
INSERT INTO qvmNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tsaymi Jesús caynog nergan: “Sábado jamay junagcho trïguta palarpis paycunaga manami jutsata rurashgatsu. Atsca cutimi gamcuna liyipäcushcanqui David yanapagnincunawan micanar imata rurapäcushgantapis. Atsca cuti liyiycarpis ¿manacu tantyapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davidga Tayta Diosta manacuna wayi rurinman yaycurmi Tayta Diosnintsipag churaraycag tantata micorgan. Nircur paywan aywag runacunata tsay tantata garargan paycunapis micunanpag. Tsay tanta cüracunala micunanpag captinpis tsayta micur Davidga manami jutsata rurashgatsu.” Tsaynog nirmi Jesús tantyatsergan discïpuluncuna sábado jamay junagcho trïguta micurpis jutsata mana rurashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nircur Jesús caynog nergan: “Nogami munayniyog caycä sábado jamay junagcho runa rurananpag mana rurananpag cagtapis ninäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tsaypita juc sábado jamay junagchönami sinagogaman Jesús yaycorgan yachatsinanpag. Tsaychömi caycargan juc runa, derëcha cag maquin wanushga. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tsauraga Moisés escribishganta yachatsegcuna y fariseucunami Jesusta ricapaycargan caynog yarpashpan: “Mä sábado jamay junag caycaptin ¿aliyätsinagcush tagay gueshyagta? Aliyätsiptenga tsay achäquilawanmi contran sharcushunpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tsaynog yarpaycashganta tantyarmi wanushga maquiyog runata Jesús caynog nergan: “Sharcurcur runacunapa naupanman ichicuy.” Tsaynog niptinmi tsay runa ichircorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nircurna runacunata Jesús taporgan: “Sábado jamay junagcho ¿gueshyaycag runata aliyätsishwancu o ‘Jina nacacutsunpis’ nishwancu?” ");
INSERT INTO qvmNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tsaypita naupancho caycag runacunata ricärishpan maquin wanushga caycag runata caynog nergan: “¡Maquiquita jogariy!” Jogarcuptinmi maquin sänuna ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sábado jamay junagcho tsaynog aliyätsiptinmi fariseucuna fiyupa rabiacärergan. Nircur wilanacärergan Jesusta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tsaypita juc tsacayna Jesús aywargan jircaman Tayta Diosta manacunanpag. Tsaychömi warargan Tayta Diosnintsita manacuycar. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsauraga patsa wararcuptinnami discïpuluncunata gayargan. Nircur paycunapita acrargan chunca ishcay (12) runacunata apostolnincuna cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paycunami cargan Simón (paytami jutinta churapargan Pedro nir), Simonpa wauguin Andrés, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO qvmNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeupa tsurin Santiago, “Celote” nishgan Simón, ");
INSERT INTO qvmNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa wauguin Judas y Jesusta entregag cag Judas Iscariotipis. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jircapita Jesús urämurnami juc pataccho atsca discïpuluncuna y tsaytsica runacunapis juntaraycagta tarergan. Tsay runacunami shapäcamorgan Judea provinciapita, Jerusalenpita, Tiro marcapita y Sidón marcapitapis. Paycunami juntacargan Jesús yachatsishganta mayayta munar y gueshyashgancunapita aliyashga cayta munashpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tsaycho waquincunata aliyätsishgannoglami demonio nacatsishgan runacunatapis Jesús aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aliyätsiptinmi pï-maypis Jesusta yataylapis yatayta munapäcorgan, gueshyashganpita aliyashga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsauraga discïpuluncunata ricärishpanmi Jesús caynog nergan: “Cay patsacho wactsa caycarpis cushishgami cawanquipag. Gamcunatami Tayta Diosnintsi naupanman pushashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Cay patsacho micanarpis cushishgami cawanquipag. Gloriachöga manami micananquipagnatsu. “Cay patsacho wagarpis cushishgami cawanquipag. Gamcunatami gloriacho Tayta Diosnintsi cushicuyta goshunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nogata chasquicamashgayquipita runacuna chiquishuptiqui, gargushuptiqui y ashlishuptiquipis ama laquicäriytsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tsaynog nacashgayquipitami Tayta Diosnintsi premiuta gloriacho camaripäshunquipag. Gamcunatanogmi Tayta Diosnintsipa unay profëtancunatapis nacatsipäcorgan. Tsaynog caycaptenga imanog nacarpis cushicäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nircurnami Jesús caynog nergan: “¡Rïcucuna! Cay patsacho imaycayogpis car runa mayiquita manami yanapashcanquitsu. ¡Tsaymi gamcunata Tayta Diosnintsi mana cuyapaypa infiernuman gaycushunquipag! ");
INSERT INTO qvmNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Imaycayquicunapis atsca captin cushicogcuna! Infiernuchöga pasaypami nacanquipag. “¡Quiquilayquipag imatapis yarpar cushishga cawagcuna! Gamcunaga laquicushpayquimi wagapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Lapan runapita alabashga cagcuna! Unay lutan yachatsicogcuna alabashga canalanpag yarpashgannogmi gamcunapis alabashga canalayquipag yarpachacuycanqui. Tsaynog cashgayquipitami Tayta Diosnintsi mana cuyapaypa infiernuman gaycushunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Cäsucamagcunatami itsanga caynog në: Cuyanqui chiquishogniquicunata. Contrayquicunatapis ali ricanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gayapäshogniquicunapag Tayta Diosta manacunqui ali cawananpag. Tsaynogla ashlishogniquicunapagpis Tayta Diosta manacunqui perdonananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pipis lagyashuptiquega jucag cärayquitapis camapanqui. Punchuyquita guechushuptiquega chompayquitapis cachaparinqui apacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Runacuna imalatapis manacushuptiquega goycunqui. Tsaynog imatapis guechurishushpayqui apacuptenga ama ‘Cutitsimay’ ninquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Runa mayiqui ali ricashunayquita munarga gamcunapis paycunata ali ricapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cuyanacushgalayquiwan cuyanacorga ama yarpapäcuytsu ali runa cashgayquita. Jutsasapa runacunapis cuyanacushgalanwanga cuyanacärinmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Quiruyqui tincushgalanwan ali cawarga ama yarpapäcuytsu ali runa cashgayquita. Jutsasapa runacunapis tsaynoglaga cawapäcunmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yanapashogniquicunalata imachöpis yanaparga ama yarpapäcuytsu ali runa cashgayquita. Fiyu runacunapis yanapagnincunalataga yanapanmi imatapis chasquinan-rayculaga. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Gamcunaga chiquishogniquicunata cuyapäcuy. Paycunawan ali cawapäcuy. Imatapis manarga ama yarpapäcuytsu pägashunayquitaräga. Tayta Diosnintsega jutsasapa runacunata cuyapanmi. Munayniyog Tayta Diosnintsi cuyapäcog cashgannog gamcunapis cuyapäcog carga paypa wamranmi carcaycanqui. Cuyapäcog cashgayquipitami gloriacho premiuta chasquipäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tsaynog caycaptenga Tayta Diosnintsi cuyapäcog cashgannog gamcunapis cuyapäcog capäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tayta Diosnintsi mana juzgashunayquipag runa mayiquita ama jamurpaytsu. Tsaynogpis runa mayiquita manacagman ama churaytsu. Tayta Diosnintsi perdonashunayquipäga chiquishuptiquipis perdonapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pï-maywanpis ali cawar yanapanacunqui. Runa mayiquita yanapashgayquinoglami gamcunatapis Tayta Diosnintsi yanapashunquipag. Yanapashushpayquega yarpashgayquipitapis mastami yanapashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“¿Gapra runa gapra mayinta pushanmantsurag? Pushaycashgancho ¿manatsurag pözuman ishcan jegacurpunman? Tsaynoglami noga yachatsishgäta manarag yachacorga gamcunapis gapranogla carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maygan yachacogpis manami yachatsegninpita mastaga yachantsu. Tsaynog captinpis shumag yachacorga yachatsegninta taripangami. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Quiquiquipa nawiquicho jatuncaray ganra jatiraycaptenga ¿imanirtag runa mayiquipa nawincho ichicnayla ganra caycagta ricapanqui? ");
INSERT INTO qvmNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nawiquicho jatuncaray ganra caycaptenga ¿imanogparag runa mayiquita: ‘Nawiquicho tacshala ganra caycagta jorgapäshayqui’ ninquiman? ¡Ishcay cära runacuna! Puntataga jorguy nawiquicho ganra caycagtarag. Tsayragmi ricanquipag runa mayiquipa nawincho tacshala ganra caycagta jorgupänayquipag. Tsaynogla runa mayiquita jamurpänayquipa trucanga yarpachacäriy quiquiquipa jutsayquicunata cacharinayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Yöracuna manami wayuntsu juc casta yörapa wayuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tsaynogla manami hïguscunata palantsitsu cashacunapita, ni üvacunata cosechantsitsu shiracacunapitaga. Ima yöratapis wayuyninpa reguishgantsinoglami runacunatapis parlacuyninpa reguintsi ali runa cashganta o fiyu runa cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tsaymi ali runaga shongun alita yarpashgannog alita parlan. Fiyu runami itsanga shongun mana alita yarpashgannog mana alita parlan. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtag gamcuna: ‘Maquiquichömi caycä’ nipäcamanqui, noga nishgäta mana cäsucuycarga? ");
INSERT INTO qvmNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nishgäcunata cäsucamag runa imanog cashgantapis canan tantyatsishayqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Payga caycan cimientuta shumag ruraycur sharcatsishga wayinogmi. Atsca yacu chämur jaytaptinpis ali cimintushga wayega manami juchongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nishgäcunata mana cäsucamag cagmi itsanga alpa janalancho sharcatsishga wayinog caycan. Fiyupa tamyaptin yacu shamur tsaynog sharcatsishga wayega juchurmi ushacangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Runacunata tsaynog parlapayta usharcurmi Jesús aywargan Capernaum marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tsaychömi juc capitanpa cuyay ashmaynin pasaypa antsa caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tsauraga Jesuspita parlapäcushganta tsay capitán mayaycurmi Jesusman cachargan Israel mayor runacunata caynog nir: “Ayway ruwaycamunqui ashmaynëta aliyätsipaycamänanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tsaymi paycuna chayaycur Jesusta ruwacorgan caynog nir: “Capitanpa ashmayninta aliyätsipayculay, tayta. Capitanga ali runami. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Marca mayintsicunawanpis payga alimi cawan. Tsaynog ali carmi sinagogantsitapis sharcatsishga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsaynog ruwacuptinmi Jesús aywargan paycunawan. Tsauraga capitanpa wayinman Jesús chayananpag caycaptinnami tsay capitán cachargan amïguncunata Jesusta caynog ninanpag: “Amashi jagayaycunquitsu, tayta. Capitán musyanshi wayinman yaycuptiqui Israel runacuna jamurpäshunayquipag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Israel runacuna mana Israel runacunawanga ni parlaylapis mana parlashganta musyarshi quiquenga mana shamushgatsu manacushunayquipag. Tsayshi caylapita niycunqui ashmaynin aliyänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Paypis mandagninpa munayninchöshi caycan. Tsaynogshi paypa munaynincho soldäducunapis caycan. Tsayshi maygantapis ‘Ayway’ niptin aywan, ‘Shamuy’ niptin shamun y ashmayninta ‘Cayta ruray’ niptinpis ruran. Gamga paypita más munayniyogshi caycanqui. Tsaymi yäracun nishgayqui lapanpis ruracänanpag cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tsaynog wilapäcuptinmi Jesús cushicorgan. Tsaymi paywan aywaycag runacunata caynog nergan: “Paynog ali yäracamag runataga manami ni Israel runacunachöpis tarishcätsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tsaynog niptinmi capitanpa cachancuna cutiycur taripäcorgan tsay ashmay aliyashgana caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsaypitana discïpuluncunawan Jesús aywargan Naín marcaman. Paycunawanmi atsca runacuna aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Marcaman yaycuycarna Jesús ricargan ayata pampananpag aparcaycagta. Tsay apaycashgan ayaga cargan viüdapa juclayla mözu wawanmi. Tsaymi atsca runacunapis yanagaycargan pampäshinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Viüda fiyupa wagaptinmi cuyapar Jesús nergan: “Ama wagaytsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nircur apaycagcunaman witiycur quirmanta yataycorgan. Tsauraga ayata apagcuna ichiycuptin wanushga caycag mözuta Jesús nergan: “¡Mözu, sharcuy!” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tsaynog niptinmi wanushga caycag mözu jamarcamur parlayta galaycorgan. Nircurna Jesús tsay viüdata caynog nergan: “¡Ama wagaynatsu! ¡Wawayqui cawarimushganami!” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tsayta ricaycur lapan runacuna cushicushpan Tayta Diosnintsita alabapäcorgan caynog nir: “¡Tayta Diosnintsipa profëtanmi nogantsiman chämushga! ¡Tayta Diosnintsimi payta cachamushga yanapamänantsipag!” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tsaymi Judea provinciacho y naupan marcacunachöpis Jesús rurashgancuna musyacargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús rurashgancunatami Juan Bautistapa discïpuluncuna Juanta wilargan. Tsauraga ishcay discïpuluncunata Jesusman cachargan caynog nir tapumunanpag: ");
INSERT INTO qvmNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“¿Gamcush caycanqui Tayta Dios cachamushgan Cristo, o juctaragcush shuyarpäshag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tsauraga Juanpa cachancuna Jesús cagman chayaycur payta tapupäcorgan caynog nir: “Juanmi musyayta munaycan, tayta. ¿Gamcush caycanqui Tayta Dios cachamushgan Cristo, o juctaragcush shuyarpäshag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tsaynog tapog chayashgan hörami Jesús aliyaycätsergan atsca gueshyagcunata, demonio gueshyatsishgancunata y gapracunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsay gueshyagcunata aliyarcatsir Jesús caynog nergan: “Cutishpayqui Juanta wilapäcuy ricashgayquita y mayashgayquitapis. Gapracuna ricannami. Puriyta mana puëdeg wegrucuna purinnami. Leprawan gueshyagcuna aliyashganami caycan. Upacuna mayannami. Juc ishcay wanushcunapis cawarimushganami. Wactsacunapis Tayta Diosnintsipa wilacuyninta mayaycannami. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nogaman yäracamashgannogla imaypis Juan yäracamätsun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa cachancuna cuticäriptinnami runacunata Jesús caynog nergan: “Chunyag jircaman Juanta ricanayquipag aywar manami jachata wayra cuyutsegta ricanayquipagtsu aywapäcorgayqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tsaynogpis manami fïnu röpan jatishga runata ricanayquipagtsu aywapäcorgayqui. Reypa wayincho tagcunalami ali röpan jatishga carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Manami tsaycunata ricagtsu aywapäcorgayqui, sinöga Tayta Diosnintsipa profëtanta ricanayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpagmi Tayta Diosnintsipa palabrancho caynog escribiraycan: ‘Wilacognëtami cachashag runacunata camaricatsinanpag. Tsaynogpami camaricushga canga shamuptë chasquicamänanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Juanpag tsaynog escribishga captinmi lapan runacunapitapis payga más puntata tantyashga Tayta Dios cachamushgan Cristo cashgäta. Tsaynog captinpis discïpulöcunaga nogawan purishga carmi Juanpita masla tantyapäcun Dios cachamushgan Cristo cashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tsaypita Jesús mastapis caynog nergan: “Juan nishganta mayagcuna, hasta más jutsasapa cagcunapis, tantyapäcorganmi Tayta Diosnintsipa wilacuynin ali cashganta. Tsaymi paycunata Juan bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseucuna y Moisés escribishganta yachatsegcunami itsanga mana bautizacärergantsu, Tayta Diosnintsi nishgancunata chasquicuyta mana munashpan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tsaynog nircushpan Jesús mastapis caynog nergan: “Canan tiempo runacunaga yupay-tucog wamracunanogmi carcaycan. Manami chasquicamantsu noga yachatsishgäcunata ni Juan Bautista yachatsishgancunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wamracuna: ‘Puclar fiestata rurashun’ nir quënata tucaptin yanasancuna gatswayta mana munashgannogmi noga yachatsishgäcunatapis mana chasquicärintsu. ‘Aya pampayta puclar laquicuypa cantashun’ niptinpis yanasancuna puclayta mana munashgannogmi Juan Bautista yachatsishgancunatapis chasquicuyta mana munantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautista imaypis ayunaptin y vïnuta mana upuptin: ‘¡Payga demoniupa munaynincho carmi tsaynog caycan!’ nipäcun. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pï-may runawanpis juntacar noga ima micuytapis micuptë y vïnutapis upuptë ‘Micular upular puricun’ nipäcaman. Tsaynogpis: ‘Jutsasapa runacunawan y Romapag impuesto cobragcunawan puricog’ nipäcaman. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tsaynog mana chasquicamaptinpis Juanta y nogata Tayta Dios cachamashgan tantyacaycan Tayta Dios munashgannog cawapäcuptëmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsaypitami fariseo runa wayinman Jesusta pushargan tsaycho paywan micapäcunanpag. Wayinman chayaycatsirmi mësaman jamatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tsayman Jesús aywashganta mayaycurmi jutsasapa warmi aywargan “alabastro” nishgan rumipita rurashgan botëllanwan perfümin aptashga. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuspa naupanman jamaycur wagaptinmi Jesuspa chaquinman weguin jutorgan. Tsay jutushgantanami agtsanwan sëcapargan. Nircur Jesuspa chaquinta mutsarcur winapargan apashgan perfümita. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tsayta ricaycurmi fariseo runa caynog yarpargan: “Tayta Diospa profëtan carga Jesús tantyanmanmi ima-nirag warmi yataycashgantapis. Mañösa warmi cashganta musyarga manami munanmantsu cargan yataycunantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsaynog yarpaycashganta musyarmi Jesús caynog nergan fariseo runata: “Simón, rätula mayarcamay wilapänäpag cashganta.” Tsaynog niptinmi payga nergan: “Mä wilaycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tsauraga Jesús caynog nergan: “Ishcay runashi juc runapa jagan cargan. Jucninshi jagan cargan ishcay wata arupänanpag. Jucagnashi jagan cargan ishcay quilla arupänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tsauraga tsay runacuna jagan cashganta pägayta mana puëdiptinshi ishcantapis mana cobrargannatsu. Canan nimay. ¿Maygan cagtag tsay guellayniyog runata más cuyanga?” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tsauraga Simón caynog nergan: “Más atsca jagan cag runachari, tayta.” Niptinmi Jesús nergan: “Alitami nishcanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tsauraga warmita ricärir Simonta Jesús caynog nergan: “Cay warmi wagar chaquëta mutsashga jutsasapa cashganpita perdonashga carmi. Costumbrintsi caycaptinpis wayiquiman yaycamuptë gamga manami yacuta camaripämashcanquitsu chaquëta awicunäpag. Cay warmimi itsanga chaquëman weguin jutushgantapis agtsanwan pitsapämashga. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yaycamuptë manami mutsamargayquitsu. Paymi itsanga yaycamushganpita-patsa mana uticaypa chaquëta mutsashga. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Umämanpis manami aceitita winapämashcanquitsu. Paymi itsanga chaquëman perfümita winapämashga. ");
INSERT INTO qvmNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cay warmega jutsasapa cashganpita perdonashga carmi tsaynog ruraycan. Waquincunaga jutsaynag cashganta yarparmi perdonashga carpis mana tsaynogtsu ruran.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nircur tsay warmita caynog nergan: “Lapan jutsayquicunapita perdonashganami caycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tsaymi mësacho jamarpaycag runacuna quiquinpura caynog parlapäcorgan: “¿Pitag payga runapa jutsancunata perdonananpäga?” ");
INSERT INTO qvmNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tsauraga Jesús caynog nergan tsay warmita: “Yäracamashgayquipitami salvashga caycanqui. Cananga cushishgana aywacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsaypitanami chunca ishcay (12) acrashgan cag discïpuluncunawan Jesús purergan marcan marcan, Tayta Diosnintsipa wilacuyninta wilacushpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Paywanmi aywapäcorgan demoniupa munayninpita jorgushgan warmicuna y gueshyashganpita aliyätsishgan warmicunapis. Tsaynogpis aywargan María Magdalena. Paypitami Jesús gargorgan ganchis demoniucunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tsaynogpis aywapäcorgan Herodispa yanapagnin Chuzapa warmin Juana, Susana y waquin warmicunapis. Jesusta y discïpuluncunata paycuna yanapargan imalawanpis cashganpita. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tsauraga marcacunapita atsca runacuna Jesús cagman aywar juntacashga caycaptinmi Jesús wilapargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc runashi aywargan trïgu murog. Tsayshi muruta matsiptin waquin chayargan näniman. Tsauraga runacuna tsay nänipa purir murucunata jarucorgan. Tsaynogshi pishgucunapis tsay murucunata upshacurcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquin cag murunashi chayargan shalaman. Tsaycho winamurpis alpa aläpa mana captin shanaywan tsaquicäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquin cag murunashi chayargan cashacuna rurinman. Cashacuna rurincho garwashtaycälar winamurshi mana wayorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waquin cag murunashi hondu alpaman chayargan. Tsaycunaga ali winamurshi wayorgan juc espïjalacho pachac (100) trïguta.” Tsaynog yacharcatsir Jesús caynog nergan: “Nishgäta mayag cäga shumag tantyacäriy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tsaypita discïpuluncuna Jesusta manacorgan caynog nir: “Tantyatsipäcamay tsay tincutsiypa yachatsishgayquita, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tsauraga Jesús paycunata nergan: “Gamcunataga tincutsiypa yachatsishgäcunata shumagmi tantyatsishayqui. Mana cäsucamagcunatami itsanga yachatsë imaman tincutsirpis mana tantyatsiylapa. Tsaynog yachatsë ricaycarpis mana tantyananpag y mayaycarpis mana chasquicunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tsay wilapashgäcunaga caynogmi caycan: Trïgu murunogmi Tayta Diosnintsipa wilacuynin caycan. Trïgu murog runanogmi Diospa wilacuyninta wilacogcuna caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Chucru näninogmi waquin runacunapa shongun chucru caycan. Tsaynog chucru shongu carmi Tayta Diosnintsipa wilacuyninta mayarpis mana chasquicuntsu. Tsaymi mayashgalantapis Satanás gongaycatsin mana salvacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Waquin runacunapa shongonga shalanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta mayar cushishgami chasquicärin. Cushishga chasquicurpis shalacho alpa aläpa mana captin trïgu jegarcamur tsaquicäcushgannogmi paycunapis carcaycan. Tsaymi runacuna chiquiptinpis o ima nacaycho carpis cuticärin naupata cawashganmannog. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Waquin runacunapa shongonga casha rurincho cag alpanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta mayarpis más yarpachacun warantincuna imanogpis cawanalanpag, rïcu canalanpag y quiquin munashgannog cawanalanpagmi. Tsauraga tsaycunalapag yarpachacorga manami Tayta Diosnintsi munashgannogtsu cawarcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Waquin runacunapa shongonga hondu alpanogmi caycan. Paycunaga Tayta Diosnintsipa wilacuyninta cushishga chasquicur Tayta Diosnintsi munashgannogmi cawan. Tsaymi ali alpacho muru winarcamur shumag wayushgannog Tayta Diosnintsi munashgannogla shumag cawapäcun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tsaynog nircushpanmi discïpuluncunata caynog nergan: “Manami pipis atsquita ratatsintsu cajun rurinman pacananpag, ni cawitu rurinman pacananpäga. Tsaypa trucanga alayrinninmanmi churan wayiman yaycogcunata atsicyapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tsaynoglami gamcunapis yachatsishgäcunata pï-maytapis wilapanqui. Tsaynog wilapaptiquimi pï-maypis wilacuynëta musyangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yachatsinayquipäga shumag yachacäriy. Yachatsishgäta cäsucogcunaga yachashganpitapis masmi yachaconga. Mana cäsucog cagcunami itsanga ichicla yachashgalantapis gongangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsaypita Jesuspa mamanwan wauguincuna chayargan Jesús caycashgan cag wayiman. Atsca runacuna captinmi pay caycashgan cagman yaycuyta mana puëdipäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tsaymi juc runa Jesusta wilargan caynog nir: “Mamayqui y wauguiquicunami puncucho shuyarpaycäshunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tsaynog niptinmi Jesús caynog nergan: “Pipis Tayta Diosnintsipa wilacuyninta cäsucogcunami mamänog y wauguëcunanog carcaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","23","Juc junagmi discïpuluncunawan büquiman yaycur Jesús caynog nergan: “Acu pasashun lagüna wac tsimpaman.” Tsaymi tsimparcaycaptin Jesús punucäcorgan. Tsayyagmi fiyupa wayrawan yacu pulchagyar büquita talpucätsinanpagna caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tsaymi discïpuluncuna Jesusta ricchatsergan caynog nir: “¡Tayta, tayta! ¡Talpucaycantsinami!” Tsaynog niptinmi Jesús sharcurcur olgöpargan wayrata y yacuta. Olgöpaptinmi wayrapis yacupis chawargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nircurna discïpuluncunata caynog nergan: “¿Imanirtag gamcuna mana yäracamanquitsu?” Tsauraga quiquinpura mantsacashga caynog nipäcorgan: “Yacupis wayrapis tsaynog cäsunanpäga ¡imajinanparag munayniyog payga caycan!” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tsaypita chayapäcorgan Gadara nishgan partiman. Tsayga cargan Galilea provinciapa tsimpanchömi. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Büquipita Jesús urarcuptinmi demonio löcuyätsishgan runa marcapita shamorgan. Tsay runami naupapita-patsa garapächula puricorgan. Tsaynogpis panteonlachömi täcog. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tsay runataga atsca cutimi demonio ruratsergan munashganta. Maquinta y chaquinta cadënawan watapäcuptinpis cadënata rachiriycurmi chunyag jircacunaman aywacog. Demoniucuna paypita yargunanpag Jesús niptinmi naupanman gongurpacuycuptin paycho cag demoniucuna gaparargan caynog nir: “¡Munayniyog Diospa tsurin Jesús! ¡Cay runapita ama gargaycalämaytsu!” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tsauraga Jesús tsay runata taporgan: “¿Imatag jutiqui?” nir. Niptinmi: “Nogapa jutëga Legionmi” nergan. Tsaynog nergan atsca demoniucuna payman yaycushga captinmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tsaymi tsay demoniucuna Jesusta manacärergan jiu-jiuyaycag ragraman mana garpunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Paycuna caycashganpita más washa lädu lömachömi atsca cuchicuna micurcaycargan. Tsaymi demoniucuna Jesusta manacärergan cuchicunaman yaycapäcunanpag. Tsauraga Jesús aunergan manacushganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tsaymi demoniucuna runapita yargurir yaycapäcorgan tsay cuchicunaman. Tsauraga cuchicuna löcutashpan tunapa cörrir jegacurporgan lagünaman. Tsaychömi shengaypa wanupäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tsayta ricaycurmi cuchi mitsegcunaga mantsacashga cörrila aywargan marcacho tag runacunata y cercancho tag runacunatapis wilananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wilapäcuptinmi runacuna aywapäcorgan ima pasashgantapis ricananpag. Tsayman chayapäcushpanmi tsay löcu runata taripäcorgan Jesuspa naupancho aliyashgana caycagta. Ali yarpayninchöna cashpanmi röpan jatishgana jamaraycargan. Tsayta ricaycurmi runacuna mantsacashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cuchi mitsegcunami shamog runacunata wilargan demoniucuna löcuyätsishganpita imanogpa tsay runa aliyashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsaymi pasaypa mantsacashga lapanpis Jesusta nipäcorgan tsaypita aywacunanpag. Tsauraga büquiman witsarcur Jesús cuticorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Manarag aywacuptinmi tsay aliyag runa Jesusta ruwacorgan paywan aywacunanpag. Tsauraga Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nogawan aywanayquipa trucanga wayiquipa cuticuy. Tsaycho wilacunqui Tayta Diosnintsi aliyätsishushgayquita.” Tsaynog niptinmi marcapa aywar runacunata wilapargan Jesús aliyätsishganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gadara nishgan partipita Jesús cutiptinmi shuyarpaycag runacuna cushishga chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Tsaymanmi chayargan sinagogacho mandag Jairo jutiyog runa. Chunca ishcay (12) watayog juclayla warmi tsurinmi pasaypa antsa caycargan. Tsaymi Jesuspa naupanman gongurpacuycur manacorgan tsurinta aliyätseg aywananpag. Tsauraga Jesús aywaycaptinmi tsaytsica runacuna payta gatirpargan quichquiypa quichquirrag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tsaymi runacunapa chaupincho aywaycargan chunca ishcay (12) watana yawar apaywan gueshyaycag warmipis. Sänu cayta munarshi tsay warmi imaycantapis ranticur ushargan mëdicucunata pägananpag. Imanogpa jampicurpis manashi aliyargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tsauraga Jesuspa guepanpa yaycuycur röpanpa cuchunta yataycorgan. Yataycuptinmi jinan höra yawar apaynin chawarganna. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tsauraga Jesús caynog nergan: “¿Pitag röpäta yataycamashga?” Tsaycho lapanpis: “Manami noga yatashcätsu” niptinmi Pedro caynog nergan: “Quichqui aywarcaycashgaga maygan yatashushgayquitapis ¿imanogparag musyashwan, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tsaynog niptinpis Jesús yapay nergan: “Musyämi mayganpis yataycamar aliyashga cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsauraga tsay warmi imaniytapis mana camäpacurmi sicsicyaycar gongurpacuycorgan Jesuspa naupanman. Nircurmi wilargan imanir yataycushganta y jinan höra aliyashga cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tsauraga Jesús caynog nergan: “Nogaman yäracamashgayquipitami aliyashgana caycanqui. Cananga cushishgana cuticuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús tsaynog parlaycaptinragmi Jairupa wayinpita wilacog chayaycur Jairuta caynog nergan: “Tsuriqui wanushganami caycan. Amana Jesusta pushaynatsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tsaynog negta mayaycurmi Jesús caynog nergan: “Ama laquicuytsu. Nogaman yäracamaptiquega tsuriqui cawarimongami.” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Tsauraga Jairupa wayinman chayaycurmi tsay wanushga wamrapag wagarcaycagta ricar Jesús caynog nergan: “Ama wagapäcuytsu. Jairupa tsurenga manami wanushgatsu caycan, sinöga punuycanlami.” Tsaynog niptinmi wanushga caycashganta musyashpan tsaycho caycag runacuna Jesús nishganta mana criyergantsu. Tsaymi Jairupa tsurin wanushga caycashgan cagman Jesús yaycatsergan Pedruta, Juanta, Santiaguta y Jairutapis warmintinta. Waquin cagcuna yaycunantami itsanga mana munargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nircurna wanushga caycagpa maquinpita tsarircur Jesús caynog nergan: “¡Jipashita, sharcuy!” ");
INSERT INTO qvmNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tsaynog niptin wanushga caycag jipashita jinan höra cawarircamur sharcorgan. Tsauraga Jesús nergan tsay jipashitata garananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jipashita cawarimushganta ricaycur mamanwan taytan pasaypa cushicärergan. Itsanga cawaritsimushganta pitapis wilapänanta Jesús manami munargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tsaypita chunca ishcay (12) apostolnincunata gayaycur Jesús nergan paypa jutincho runacunapita tucuy-nirag demoniucunata gargunanpag y gueshyagcunata aliyätsinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nircurna paycunata cachargan Tayta Diosnintsipa wilacuyninta wilacärinanpag y gueshyaycagcunata aliyätsinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tsauraga paycunata caynog nergan: “May marcapa aywarpis ama apapäcunquitsu tucruyquita, guepinayquita, mircapayquita, guellayniquita, ni trucacunayquipag röpayquitapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","May wayiman posädacurpis tsaylacho posädacärinqui juc marcapa pasanayquiyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","May marcachöpis mana chasquishuptiquega tsaypita aywacärinqui llanquiquicho caycag polvuta tapshirishpayqui. Tsaynog ruranqui Tayta Diosnintsi paycunata juzgananpag cashganta tantyacunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsauraga apostolnincuna aywargan marcan marcan Tayta Diosnintsipa wilacuyninta wilacuraycar. Tsaynogmi gueshyagcunatapis atscagta aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Jesús pï cashgantapis mana musyarmi waquin runacuna nipäcorgan Juan Bautista wanushganpita cawarimushga cashganta. Waquin nipäcorgan Tayta Diosnintsipa profëtan Elías cashganta. Y waquinnami nipäcorgan maygan profëtapis cawarimushga cashganta. Juan cawarimushganta runacuna niptinmi Galilea provinciapa mandagnin Herodes imanogpa yarpachacuytapis mana camäpacorgantsu. Tsaymi caynog nergan: “Juanpa umanta rogutsishga caycaptëga ¿pirag canman tsay runaga? Tsay runata nogapis reguiycöman itsanga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wilacärishganpita apostolcuna cutiycamurmi Jesusta wilapargan lapan rurashgancunata. Tsaypita paycunata pushacurcur Jesús aywargan Betsaida marcapa cercanman. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tsaypa aywapäcushganta musyaycurmi guepanta atsca runacuna aywapäcorgan. Pay cashgan cagman chayaycuptin Jesús paycunata chasquicorgan. Nircurna yachatsergan Tayta Diosnintsipa wilacuyninta. Tsaychömi gueshyaycagcunatapis aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tsaymi patsa tardiyaptinna apostolnincuna Jesusta caynog nergan: “Runacuna aywacäritsunna maylachöpis posädata ashipäcunanpag. Caychöga manami imapis cantsu garanantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tsauraga Jesús caynog nergan: “Paycunataga micuyta gamcuna garapäcuy.” Tsaynog niptinmi caynog nipäcorgan: “Pitsga tanta y ishcay pescädulami mircapäcuna caycan. Micuy ranteg mana aywarga ¿imatatag caytsica runacunataga garapäcushag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsaychömi runacuna caycargan pitsga waranganog (5,000). Tsauraga discïpuluncunata Jesús caynog nergan: “Jamatsiy lapan runacunata pitsga chunca-camala (50).” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tsaynog niptinmi tsaycho cagcunata lapanta jamacärinanpag nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tsaypitanami pitsga tantata y ishcay pescäduta aptarcur Jesús jana patsata ricärishpan Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paquircur discïpuluncunata macyargan lapan runacunata aypunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tsaymi lapan micapäcorgan sacsashganyag. Nircurna putsushgancunata discïpuluncuna shuntapäcorgan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc junagmi discïpuluncunawan Jesús caycashpan Tayta Diosta manacorgan. Manacuyta usharcur paycunata taporgan caynog nir: “¿Pï cashgätatag nogapag runacuna yarpapäcun?” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tsauraga discïpuluncuna nipäcorgan: “Waquin runacunaga nipäcun Juan Bautista cashgayquitami. Waquinnami nipäcun Elías cashgayquita. Y waquin cagnami nipäcun maygan profëtapis wanushganpita cawarimushga cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tsaypita yapay taporgan: “Gamcunaga ¿pï cashgätatag yarpapäcunqui?” Tsauraga Pedro caynog nergan: “Gamga Tayta Dios cachamushgan Cristumi canqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tsaynog Pedro niptinmi discïpuluncunata Jesús caynog nergan: “Tsaytaga pitapis ama wilapanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Noga fiyupa nacatsishgaragmi cashagpag. Israel mayor runacuna, mandag cüracuna y Moisés escribishgan leycunata yachatsegcuna chiquimarmi wanutsimanga. Tsaypita quimsa junagtaga cawarimushagpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nircur mastapis Jesús caynog nergan: “Pipis discïpulö cayta munarga shongun yarpashgannog jutsata rurar ama cawatsuntsu. Tsaypa trucanga imanog nacarpis waran waran noga munashgänogla imaypis cawatsun. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Noga munashgänog cawananpa trucan quiquin munashgannog cawagcunaga infiernuman gaycushgami cangapag. Ima nacaycho carpis noga munashgänog cawagcunami itsanga gloriaman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Infiernuman gaycushga cananpag caycaptenga ¿imapagtag välin mayjina rïcu cashganpis? ");
INSERT INTO qvmNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pipis nogapita y wilacuynëpita pengacuptenga nogapis Tayta Diospa angilnincunawan chip-chipyaycar cutimushpä payta manami cäsushagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Manarag wanurmi waquinniqui ricamanquipag lapanpagpis munayniyog cashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tsaypita pusag (8) junagtanognami Jesús witsargan juc jircaman Tayta Diosta manacunanpag. Tsaypa aywar pushargan Pedruta, Juanta y Santiaguta. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tayta Diosta Jesús manacuycaptinmi cäranpis jucnogman ticrargan y röpanpis chip-chipyaycag ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tsaychömi ricapäcorgan Moisés y Elías yuriparcur Jesuswan parlaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Shumag chip-chipyaycagpa chaupinchömi quimsan parlarcaycargan Tayta Dios munashgannog Jerusalencho Jesús wanunanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tsay hörami ishcay discípulu mayincunawan Pedro fiyupa pununaycashpanpis riccharcaycargan. Tsaychömi ricapäcorgan paycunawan Jesús chip-chipyaycar parlaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tsauraga tsay runacuna elgacäcuptinnami mana yarpachacuylapa Pedro caynog nergan: “Alipagmi nogacuna cayman shapäcamushcä, tayta. Cananga rurapäcushag quimsa tsuclata: jucta gampag, jucta Moisespag y jucta Eliaspag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsaynog parlaycaptinmi pucutay tsapacurcorgan. Tsaymi discïpulucuna fiyupa mantsacargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tsauraga pucutay rurinpitami Tayta Diosnintsi caynog nimorgan: “¡Payga cuyay tsurëmi! ¡Pay nishushgayquicunata cäsucäriy!” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tsaypitaga quiquilanna Jesús ricacorgan. Discïpuluncunaga tsay ricashganta pitapis manami wilaparganragtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wara junag tsay jircapita cutipäcamuptinmi atsca runacuna Jesusta taripargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tsay runacuna chaupinpitami juc runa fuertipa caynog nimorgan: “¡Cuyapayculay cay juclayla tsurëta, tayta! ");
INSERT INTO qvmNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Demoniumi elagpita gaparätsin, pampaman sagtan, pogshaytapis agtutsin. Manami cachantsu fiyupa nacatsishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Demoniuta gargunanpag discïpuluyquicunaman apamuptëpis manami garguyta camäpacushgatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tsaymi Jesús caynog nergan: “¡Yäracuyniynag jutsasapa runacuna! ¿Imayyagrag gamcunawan caycäshag? Mä apamuy tsuriquita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tsauraga Jesuspa naupanman tsay runapa tsurin witiycaptinna pampaman demonio sagtariycorgan. Tsayta ricaycurmi demoniuta Jesús olgöpargan mözupita yargunanpag. Tsauraga cachariycur aywacuptinnami jinan höra mözu sänuna ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tayta Diospa munayninwan demoniuta gargushganta ricarmi lapan cushicärergan. Tsaynog rurashgancunata ricar runacuna cushicuptinmi discïpuluncunata Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Juc runami nogata entregamanga conträcunapa maquinman.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tsauraga Jesús nishgancunata paycuna manami tantyapäcorgantsu. Tsaynog mana tantyarpis tapuytami itsanga mantsacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsaypitanami Jesuspa discïpuluncuna mandag cayta guechunacur rimanacärergan: “Nogatami Jesús churamanga gamcunapita más mandag canäpag” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tsaynog rimanacäriptinmi Jesús juc wamrata gayargan naupanman. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nircur caynog nergan: “Cay wamratanog mana cäsushga cagcunata chasquicorga nogata chasquicamagnogmi carcaycanqui. Nogata chasquicamarga cachamag Taytätapis chasquicuycanquimi. Tsaymi manacagman mana churaypa pitapis yanaparga mandag canquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tsauraga discïpulun Juan caynog nergan: “Nogacuna ricapäcushcä juc runata gampa jutiquicho demoniucunata garguycagta, tayta. Tsaymi nogantsiwan mana puriptin jutiquita mana jogarinanpag michäpäcushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tsauraga Jesús caynog nergan: “Cananpitaga ama michanquitsu. Pipis contrantsi mana sharcorga favornintsimi caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tayta Diosman cuticunanpag tiempo chaycämuptinnami wanunanpag cashganta musyarpis mana mantsacuypa Jesús aywargan Jerusalenpa. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aywaycarnami waquin discïpuluncunata cachargan Samaria provinciacho cag juc marcaman, tsaycho posädacärinanpag wayi asheg. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tsauraga tsay marcacho runacuna manami chasquicuyta munapäcorgantsu, Jerusalenpa aywaycashganta musyashpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tsaynog mana chasquicäriptinmi Santiago y Juan caynog nipäcorgan: “¿Elías manacushgannog Tayta Diosnintsita manacärëmancu ciëlupita shamog ninawan cay runacunata ushacätsinanpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tsauraga paycunata Jesús olgöpargan caynog nir: “Tayta Diosnintsipa wilacognin caycarga ¿imanirtag tsaynog parlapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Manami runacunata ushacätsinäpagtsu cay patsaman noga shamushcä, sinöga runacunata salvanäpagmi.” Tsaypitanami juc marcapana aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tsaynog aywarcaycaptinmi juc runa Jesusta caynog nergan: “Maypa aywaptiquipis gatiräshayquimi, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tsaynog niptinmi Jesús caynog nergan: “Atogcunapaga machaynin canmi. Tsaynogmi pishgucunapapis gueshwancuna can. Nogapagmi itsanga mana cantsu maycho punuycunaläpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tsaypita juc runata caynog nergan: “Discïpulö canayquipag nogawan aywashun.” Niptin tsay runa caynog nergan: “Papänë wanuptin pampaycurragmi gamwan aywashag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tsauraga Jesús caynog nergan: “Wanushcunaga wanush mayinta pampapäcutsun. Gamwanga aywashun Tayta Diosnintsipa wilacuyninta wilacunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tsaynogmi juc runapis nergan: “Nogapis gamwan aywaytami munä, tayta. Itsanga wayëcho cagcunatarag wilaycamushag aywanantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tsauraga Jesús caynog nergan: “Pipis guepapa ricaraycar töruwan arog cäga mana ali arogmi caycan. Tsaynogpis naupata cawashgannog cawayta munagcunaga manami discïpulö canmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsaypita Jesús acrargan ganchis chunca ishcay (72) gatiragnincunata. Nircur ishcay ishcay cachargan pay aywananpag cag marcacunaman wilacuyninta wilacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Paycunata cacharmi Jesús caynog nergan: “Cosëcha poguraycagnogmi tsaytsica runacuna caycan Tayta Diosnintsipa wilacuyninta jucla chasquicunanpag. Tsaynog captinpis walcaglami ali wilacuyta wilacogcunaga carcaycan. Tsaymi Tayta Diosta manacäriy wilacogcuna más atsca cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Shumag tantyacäriy. Gamcunata fiyu runacuna cashganman cachaycä uyshacunata atogman gaycognogmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Ama apapäcunquitsu guellayniquita, jacuyquita, ni llanquiquitapis. Piwanpis nänicho tincorga parlar ama täcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pipa wayinman chayarpis wayiyogta caynog nipäcunqui: ‘Ali cawanayquipag Tayta Diosnintsi yanapayculäshunqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tsay wayiyog chasquishuptiquega nipäcushgayquinogmi paypag ali caway canga. Mana chasquishuptiquega juc wayimanna aywanqui posädata ashinayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tsay chasquishogniquicunapa wayilancho posädacärinqui. Ama wayin wayenga posädata ashipäcunquitsu. Arupacog runa arushganpita imatapis chasquishgannogmi gamcunapis wilacushgayquipita imatapis chasquinquipag. Tsaymi imalatapis garashushgayquita micapäcunqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“May marcamanpis chayaptiqui runacuna chasquishuptiquega tsaycho imalatapis garashushgalayquita micapäcunqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tsay marcacho gueshyaycagcunata aliyätsinqui. Aliyarcatsir caynog nipäcunqui: ‘Tayta Diosnintsipa maquincho ali cawanapag cag tiempo chämushganami.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Itsanga may marcamanpis chayaptiqui runacuna mana chasquishuptiquega cälliman yargurcur caynog ninqui: ");
INSERT INTO qvmNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Chaquëcunacho caycag polvutapis tapshipäcö fiyu capäcushgayqui musyacänanpagmi. Ima captinpis musyapäcuy Tayta Diosnintsipa maquincho ali cawanapag cag tiempuchöna caycashgantsita.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tsaynog mana chasquishushgayquipitami Sodoma marca runacuna infiernucho nacananpag cashganpitapis paycuna más fiyupa infiernucho nacangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Corazín marcacho tag runacuna! ¡Betsaida marcacho tag runacuna! ¡Gamcunaga juicio final junag pasaypami laquicunquipag! Gamcunacho milagrucunata rurashgänog Tiro y Sidón marcacunacho milagrucunata ruraptëga maynami jutsa ruraycunata cacharinman cargan. Tsaynogpis jutsa rurashganpita laquicur maynami cotenciapita rurashga röpata jaticurcur uchpaman jamaycur wagapäcunman cargan. Gamcunaga milagrucunata rurashgäta ricaycarpis jutsa ruraycunata cachariyta manami munapäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tsaynog cashgayquipitami Tiro y Sidón marca runacuna infiernucho nacashganpitapis gamcunaga más fiyupa infiernucho nacanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum marcacho tag runacuna, ¿gamcunaga Tayta Diosnintsipa naupanman chayanayquipag cashgan imatachari yarparcaycanqui? Tayta Diosnintsipa naupanman chayanayquipa trucanga Hadisman gaycushgami capäcunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tsaynog nircushpanmi discïpuluncunata caynog nergan: “Gamcuna wilacushgayquita chasquicogcunaga nogatami chasquicaycäman. Tsaynogpis gamcunata mana chasquishushpayquega nogatapis manami chasquicaycämantsu. Tsaynog carga Taytätapis manami chasquicuycantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wilacushganpita ganchis chunca ishcay (72) cachashgancuna cushishga cutirmi Jesusta caynog wilargan: “¡Runacunapita demoniucunata jutiquicho garguptë yargushgami, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tsauraga Jesús caynog nergan: “Tsaynog garguptiquimi ricashcä Satanás ciëlupita räyunograg ratamushganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Demoniucunata gargunayquipäga munaynëtami chasquipäcushcanqui. Tsaymi demoniucunata garguptiquipis paycuna mana ticrapäshunquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Demoniucunata gargur cushicushgayquipitaga masrag cushicäriy libro de la vïdacho jutiquicuna escribiraycashganpita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tsaychömi pasaypa cushicushpan Tayta Diosnintsita Jesús manacorgan caynog nir: “Jana patsacho y cay patsachöpis gam munayniyogmi caycanqui, papá. Yachag-tucogcunata manami tantyatsishcanquitsu nogata cachamashgayquita. Paycunata tantyatsinayquipa trucanga yachacuyta munagcunalatami tantyatsishcanqui. Tsaynog canantami munashcanqui, papá.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nircurnami discïpuluncunata caynog nergan: “Taytämi lapantapis munaynëman churamushga, tsurin captë. Noga imanog cashgätapis taytalämi musyan. Tsaynogmi pay imanog cashgantapis nogala musyä. Tsaymi tantyatsishgä cagcunala musyapäcun Taytä imanog cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsaypitami discïpuluncunata mastapis caynog nergan: “Noga rurashgäcunata ricarmi gamcunaga ricarcaycanqui unay runacuna mana ricashgancunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Unay profëtacuna y mandag reycunapis reguimaytami munargan. Reguimayta munarpis cay patsaman manarag shamuptëmi mana reguimashgatsu. Tsaynogpis noga wilacushgäcunata mayayta munarpis manami mayapäcamashgatsu. Gamcunami itsanga ricarcaycämanqui y mayarcaycämanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Juc cutichömi juc yachag runa, Jesús yachashganta o mana yachashgantapis musyayta munar, Jesusta caynog taporgan: “Tayta, ¿imatatag ruräman gloriaman chayanäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tsaynog niptin Jesús caynog nergan: “¿Imatatag tantyanqui Tayta Diosnintsipa palabranta liyir?” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tsauraga tsay yachag runanami caynog nergan: “Gloriaman runa chayananpäga Tayta Diosnintsipa palabrancho caynogmi niycan: ‘Shumag tantyacur lapan shonguyquiwan y lapan voluntäniquiwan Tayta Diosta cuyanqui. Tsaynogla runa mayiquita lapan shonguyquiwan cuyanqui.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tsaynog niptin Jesús caynog nergan: “Alitami nishcanqui. Tsay nishgayquita rurarga gloriachömi imayyagpis cawanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tsaynog niptinmi tsay yachag runa Jesusta yapay taporgan caynog nir: “Runa mayëta cuyarga ¿lapan runacunatacu cuyapäman?” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tsauraga Jesús caynog wilapargan: “Juc runashi aywaycargan Jerusalén marcapita Jericó marcaman. Aywaycaptinshi suwacuna payta magargan. Nircur jatirashgan röpanta y guepintapis guechurishpanshi wanushgatanog cachaycur aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tsauraga tsay nänipashi pasaycargan juc cüra. Tsaycho wanushganog jitaraycagta ricaycarpis mana ricag-tucushpanshi pasacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tsaypita Leví casta runapis jitaraycashgan cagman chayargan. Paypis mana ricag-tucushpanshi pasacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaria runapis tsaymanshi chayargan. Israel runacuna Samaria runacunawan chiquinacuycarpis tsay Samaria runashi itsanga jitaraycagta ricaycur cuyapargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tsayshi aceitiwan y vïnuwan jampircur träpucunawan watapargan. Nircurna bürrunman muntarcatsir apargan posädacuna wayiman, tsaycho shumag jampinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tsaypitashi wara tuta tsay cuyapäcog runa aywacunanpagna caycar wayiyogta pägargan ishcay junag arur gänashgantanog caynog nir: ‘Gueshyagnëta ricapaycälanqui, tayta. Masta gastaptiquipis cutimurnami pägaläshayquipag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús tsaynog wilapayta usharcur tsay yachag runata taporgan caynog nir: “Tsay quimsan runapita ¿maygan cagtag runa mayinta cuyapargan?” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tsaynog niptin tsay yachag runa caynog nergan: “Samaria runami, tayta.” Tsaymi Jesús caynog nergan: “Tsauraga gampis tsay runanogla runa mayiquita cuyapay.” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tsaypita discïpuluncunawan aywar Jesús chayargan juc tacsha marcaman. Tsay marcaman chayaptinmi wayinman Marta chasquicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa nanan María, Jesús yachatsishganta mayayta munarmi, paypa naupanman jamaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martami itsanga wayicho ruraynincunata ruraycargan. Tsauraga atsca ruraynincuna captinmi Jesusta caynog nergan: “¿Imanirtag nanä tsaycho jamaräcun noga caycho nacaycaptë? ¡Niyculay yanapamänanpag, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tsaymi Jesús caynog nergan: “Marta, gamga aläpa yarpachacuycanqui rurayniquicunalapagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tsaypa trucanga Tayta Diosnintsi nishgancunata yachacunayquipag más yarpachacunquiman. Mariami itsanga yachacuyta munar yachatsishgäcunata mayaycäman. Tsaynog yachacunantaga manami pipis michanmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tsaypita juc cutichömi Jesús manacuycargan Tayta Diosnintsita. Manacuyta usharcuptin juc discïpulun Jesusta caynog nergan: “Discïpuluncunata Juan Bautista yachatsishgannog nogacunatapis yachaycatsilämay Tayta Diosta manacärinäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsauraga Jesús nergan: “Tayta Diosnintsita manacur caynog nipäcunqui: ‘Gloriacho caycag Tayta Dios, pï-maytapis tantyaycatsilay respitaycushunayquipag. Lapan runacuna gam munashgayquinog cawayculätsun. Gloriacho munashgayquita rurapäcushgannog cay patsachöpis munashgayquita ruracayculätsun. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Micunäpag micuynë ama pishiyculätsuntsu, Tayta. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chiquimagnëcunata noga perdonashgänog jutsa rurashgäcunatapis perdonaycalämay. Jutsaman Satanás tunitsimayta munaptinpis tsapaycalämay, Tayta. Tsaynogpis yanapaycalämay jutsata mana ruraypa imaypis cawanäpag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nircur Tayta Diosta imaypis manacunantsipag Jesús caynog wilapargan: “Juc runashi pulan pagas aywargan amïgunpa wayinman caynog nir: ‘Amïgo, quimsala tantayquita manaculäshayqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc amïgömi wayëman chämushga posädatsinäpag. Manami imaläpis cantsu garanäpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tsaynog manacuptinshi amïgonga caynog nimorgan: ‘Ama fastidiamaytsu. Puncöpis trancashganami caycan. Wamräcunapis punucashganami caycan. Mananami sharcamömannatsu tantata camaripänäpag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tsaymi Jesús caynog nergan: “Sharcamuyta mana munaycarpis yaparir yaparir manacuptenga camaripangapagmi. Fiyu runacunapis tsaynog yanapäcog caycaptenga Tayta Diosnintsi masragmi yanapamäshun. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Imaypis Tayta Diosta manacäriy. Imata nistarpis ruwacäriy. Puncuta tacacognogpis payta gayacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tayta Diosta manacogcunaga manacushganta chasquinmi. Imata nistarpis ruwacogcunaga tarinmi. Puncuta tacacognog gayacogtaga Tayta Dios mayanmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Maygayquitapis wamrayqui tantata manacushuptiquega ¿rumita garanquimantsurag? Pescäduta manacushuptiquega ¿culebrata garanquimantsurag? ");
INSERT INTO qvmNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tsaynogpis runtuta manacushuptiquega ¿alacranta garanquimantsurag? ");
INSERT INTO qvmNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mayjina fiyu caycarpis ¿manacu wamrayquicunata ali caglata garanqui? Tsaynoglami Tayta Diosnintsita manacäriptiquega Santu Espirituta gamcunaman cachamongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cutimi shimin mana pashtag runapita demoniuta Jesús gargorgan. Demonio yarguptinnami tsay runa parlayta galaycorgan. Tsayta ricaycur waquin runacuna cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waquin runacunanami nipäcorgan: “Manami Tayta Diospa munayninwantsu demoniucunata runacunapita gargun, sinöga demoniucunapa mandagnin Beelzebupa munayninwanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquin runacunanami Jesusta caynog nipäcorgan: “Tayta Diosnintsipa munayninwan demoniuta gargushgayquita musyanäpäga más juc milagrutarag ruray.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tsauraga lutanta yarpashgancunata musyar Jesús caynog nergan: “Juc nacioncho runacuna quiquinpura chiquinacorga ¿manatsurag wanutsinacur ushacanman? Tsaynogpis juc wayicho tagcuna quiquinpura chiquinacorga ¿manatsurag wacpa caypa aywacur ushacanman? ");
INSERT INTO qvmNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tsaynog captenga ¿imanirtag yarparcaycanqui Satanaspa munayninwan demoniucunata gargushgäta? Quiquinpura gargunacorga Satanás ushacanmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Waquin runacuna demoniucunata garguptin gamcunaga yarpaycanqui Tayta Diosnintsipa munayninwan gargushgantami. Noga garguptëga ¿imanirtag yarparcaycanqui Satanaspa munayninwan demoniucunata gargushgäta? Tsaynog yarparga lutantami yarparcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Santu Espíritu yanapamaptin demoniucunata gargushgäta ricarmi musyapäcunqui Tayta Diospa munayninwan Satanasta vincishgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Satanaspita más munayniyog cashganta tantyatsirmi Jesús yachatsergan caynog nir: “Calpayog runa garrotinwan wayinta täpaycaptenga manami imantapis suwa apangatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tsaynog täpaycaptinpis paypita más calpayog runa shamurmi itsanga garrotinta guechurir wayinpita munashganta apaconga. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mayganpis mana chasquicamag cäga conträmi caycan. Nogata mana cäsumag cäga Satanás munashgantami ruraycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tsaynog nircushpan Jesús mastapis caynog nergan: “Runapita demonio yargurmi chunyagcunapa purin maychöpis tänanpag ashir. Mana tariycorga yarpan yargushgan runaman yapay cutiyta. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cutiycushpanmi tarin pitsapacushga y churapacushga wayitanog. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsaynog caycagta tariycurmi paypita más fiyu ganchis demoniucunata pushacurcur tsay runaman cutin paycho tänanpag. Tsaymi naupata cashganpitaga tsay runa más fiyuna ricacun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús tsaynog parlaycaptinragmi runacunapa chaupinpita juc warmi caynog nimorgan: “Tayta Diospa wilacognin cashgayquipita ¡ima cushishgarag mamayqui caycan!” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tsaynog niptin Jesús nergan: “Mamä cushicushgannoglami Tayta Diosnintsipa wilacuyninta chasquicur cäsucogcunapis cushishga carcaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsaypitami tsaytsica runacuna Jesús cashgan cagman juntacargan. Tsaymi Jesús caynog nergan: “Gamcunaga manami rasunpatsu Tayta Diosman yäracärinqui. Tsaymi pay cachamashganta criyinayquipag milagruta ruranätarag munarcaycanqui. Munashgayquinöga manami milagruta rurashagtsu. Tsaypa trucanga Tayta Dios juc milagrutaragmi ruranga profëta Jonasta pescädupa pachancho caycashganpita yargatsimur milagruta rurashgannog. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wilacognin Jonás cashganta unay Nínive marcacho tag runacuna tantyananpag Tayta Dios milagruta rurashgannogmi juc milagruta ruranga pay cachamashganta runacuna tantyapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Musyashgayquinogpis Salomonpa yachatsicuyninta mayananpagmi Sabá nacionpita-patsa mandag warmi shamorgan Jerusalenman. Paymi juicio final junag sharcamongapag canan witsan runacunata: ‘Salomón yachatsishganta noga chasquicuycaptëga ¿imanirtag gamcuna Tayta Diospa tsurin yachatsishganta mana chasquicärergayquitsu?’ ninanpag. Salomonpita noga más yachag captëpis canan witsan runacunaga manami wiyacärintsu noga wilacushgäcunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tsaynogpis Jonás wilacushganta mayarmi Nínivicho tag runacuna jutsa rurashganta cacharergan. Jonaspita más munayniyog noga caycaptëpis wilacushgäta canan witsan runacuna manami chasquicärintsu. Tsaymi juicio final junag Nínivicho tag runacuna sharcamongapag canan witsan runacunata: ‘Nogacuna Jonás wilacushganta chasquicuycaptëga ¿imanirtag gamcuna Tayta Diospa tsurin wilacushganta mana chasquicärergayquitsu?’ ninanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tsaypitami Jesús caynog nergan: “Manami pipis atsquita ratatsintsu pacagninman churananpag, ni cajun rurinman pacananpäga. Tsaypa trucanga alayrinninmanmi churan wayiman yaycogcunata atsicyapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lapanta atsicyapänanpag runacuna atsquita ratatsishgannoglami nogapis wilacuycä lapan runacuna tantyapäcunanpag. Pipis tantyacog cäga wilacushgäta tantyar chasquicärinmi. Mana tantyacog cagmi itsanga wilacushgäta mana tantyar mana chasquicärintsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Waquin runacuna wilacushgäta chasquicushganta niycarpis janan shongulami chasquicushga. Cuidädu tsay runacunanog capäcunquiman. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wilacushgäta rasunpa chasquicushga carga atsqui atsicyashgannogmi runacuna ricacunanpag wilacuynë nishgannog cawanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús parlayta usharcuptinnami juc fariseo runa pushargan wayincho micapäcunanpag. Chayaycurmi mësaman Jesús jamacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Micunanpag manami maquinta awicorgantsu fariseo runacunapa costumbrin cashgannöga. Tsaymi pushag fariseo runa yarpachacushpan Jesusta ricapargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tsauraga Jesús caynog nergan: “Gamcunaga pusillupa y plätupa janalanta maylar rurintaga mana maylagnogmi carcaycanqui. Tsaymi pusillupa y plätupa rurincho ganra cashgannog mana ali yarpashgayqui y ambiciöso cashgayquipis shonguyquicho caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana tantyacog fariseucuna! ¿Manacu musyanqui Tayta Diosnintsi cuerpuyquita camar shonguyquitapis camashganta? Tsaymi cuerpuyqui limpio cananpag yarpachacushgayquinog shonguyquipis limpio cananpag yarpachacunquiman. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gamcunaga wactsacunata imalachöpis yanapay. Tsaynog ruraptiquiragmi pusillupa rurin maylashga cashgannog shonguyquipis limpio cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Fariseucuna! ¡Juicio final junag pasaypami laquicunquipag! Gamcunaga templuman apanayquipag mentata, rüdata y waquin jachatapis chunca (10) wancuypita juc wancuyta imaypis raquircaycanqui: ‘Tayta Diospa palabrancho nishgannogla lapantami cumpliycä’ nishpayqui. Tsaynog rurarpis runa mayiquitaga manami ali ricaycanquitsu ni cuyapaycanquitsu. Chunca wancuypita juc wancuyta templuman apar Tayta Diosnintsipa palabranta cumplishgayquinogla runa mayiquitapis cuyanquiman. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Fariseucuna! ¡Juicio final junag pasaypami laquicunquipag! Gamcunaga imaypis munarcaycanqui sinagogacunacho alinnin bancumanrag jamacuytami. Tsaynogpis gamcuna munarcaycanqui cällicunacho waquin runacunapita más respëtuwan saludashga caylatami. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Gamcunaga juicio final junag pasaypami laquicunquipag! Melanaypag pamparaycag ayanogmi carcaycanqui. Tsay pamparashgan jananpa mana musyar pipis purishgannogmi mana musyantsu fiyu runa cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tsayta mayar Moisés escribishganta yachatsegpis caynog nergan: “Tsaynog nishpayquega nogacunatapis mayaycätsimanquichag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Niptin Jesús nergan: “¡Moisés escribishganta yachatsegcuna! ¡Tsaynoglami gamcunapis juicio final junag pasaypa laquicunquipag! Gamcunaga runacuna ima ruraytapis mana camäpacushganyagmi Moisés escribishgan leycunamanpis yapa yaparcur imatapis cumplinanpag nipäcunqui. Tsaynog yachatsishgayquita cumpliyta runacuna mana camäpacushganta ricaycarpis shacyätsinayquipa trucanga olgöpaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Juicio final junag pasaypami laquicunquipag! Unay runacuna wanutsishgan profëtacuna pamparashgan janancho gamcunaga capillancunata rurarcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tsaynog sharcatsirpis manami cäsucärinquitsu profëtacuna nishgancunata. Tsaynog mana cäsucurmi runacunata musyaycätsinqui tsay profëtacunata wanutsegcunanogla gamcunapis carcaycashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Tsaynog captinmi imanog cananpag cagtapis musyar Tayta Diosnintsi unay caynog nergan: ‘Paycunamanmi cachamushag wilacognëcunata y apostolnëcunatapis. Tsaynog captinpis paycunaga waquincunatami wanutsipäconga y waquin cagcunatanami marcan marcan gaticachangapag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Tsay nishgannoglami Abelta wanutsishganpita-patsa Tayta Diosnintsipa profëtancunata runacuna imaypis wanutsipäcorgan hasta Zacariasta templo puncucho wanutsinanyag. Tsay wanutseg runacunatanogmi canan witsan Israel runacunata Tayta Diosnintsi juzgangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Moisés escribishgan leycunata yachatsegcuna! ¡Juicio final junag pasaypami laquicunquipag! Wayiman pipis mana yaycunanpag llävipa wawanta tsaricuycognogmi runacunata wichgaparcaycanqui Tayta Diosnintsi munashganta mana yachacärinanpag. Tsaynoglami quiquiquicunapis mana chasquicärinquitsu Tayta Diosnintsipa wilacuyninta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesús tsaynog niptin Moisés escribishganta yachatsegcuna y fariseucuna rabiacarcärergan. Tsaypitana achäquita ashipar Jesusta imaycatapis nipäcorgan lutanta parlaptin tsaylawan acusananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesús tsaynog parlaycaptinmi waranganpa runacuna wayi puncuman juntacargan. Jesusta mayayta munashpanmi tanganacurrag tsaycho carcaycargan. Tsauraga discïpuluncunata Jesús caynog nergan: “Fariseucunaga runacuna ricanalanpagmi ali-tucärin. Cuidädu paycunanog ishcay cära carcaycanquiman. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pacaylapa jutsa rurashgayquipis juicio final junag musyacangami. Manami ima jutsa rurashgayquipis mana musyacaypaga cangatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tsaynogmi pacaylapa wilanacushgayquipis y puncuta wichgacuycur parlacushgayquipis juicio final junag lapan musyacangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Cuyaynëcuna, ama mantsacäriytsu pipis wanutsishunayquipag jurapäshuptiqui. Wanutsishushpayquipis almayquitaga manami wanutsengatsu ");
INSERT INTO qvmNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Chiquishogniquicunata mantsacur cäsucunayquipa trucanga Tayta Diosnintsita cäsucäriy. Paymi itsanga munayniyog caycan almantinta pitapis infiernuman gaycunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tantyacäriy. Pichiuchancacunata runacuna mana cäsupaptinpis Tayta Diosnintsi lapantami ricaycan. Pichiuchancatapis tsaynog ricaycarga gamcunata masragmi Tayta Diosnintsi ricaycäshunqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Agtsayqui ayca cashgantapis payga musyaycanmi. Tayta Diosnintsi tsaynog ricaycäshuptiquega ama mantsacäriytsu pipis wanutsiyta munashuptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Pipis nogata chasquicamashganta mana pengacuypa wilacuptenga nogapis angilcunapa naupancho paycunapa favorninmi parlashagpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pipis runacunapa naupancho pengacushpan chasquicamashganta ñëgamaptenga nogapis angilcunapa naupancho paycunata: ‘Manami reguëtsu’ nishagpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tayta Dios cachamushgan Cristo cashgäta mana tantyar conträ parlaptenga Tayta Dios perdonangapagmi. Santu Espíritu nogapita tantyaycätsiptin conträ rimaptinmi itsanga Tayta Dios imaypis mana perdonangatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Gamcunata juzgashunayquipag sinagogacunaman, juezcunaman y waquin autoridäcunaman apashuptiquipis ama laquicärinquitsu: ‘¿Imatarag nishag?’ nishpayqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Santu Espiritunami tantyatsishunquipag imata ninayquipagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Runacunapa chaupinpita juc runa caynog nimorgan Jesusta: “Wauguëta niycuy herenciäta raquipämänanpag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tsauraga Jesús caynog nergan: “Amïgo, manami juezniquitsu ni alfasyayquitsu noga cä tsaynog manacamänayquipäga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nircur runacunata caynog nergan: “Ama imaycapagpis codiciöso capäcuytsu. Ali cawayga manami rïcu caylachöragtsu caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tsaymi Jesús wilapargan caynog nir: “Juc rïcu runashi murushganpita atsca cosëchata shuntargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tsauraga tsay rïcu runa yarpachacorgan caynog nishpan: ‘Cananga ¿maymantag tsaytsica micuyta churashag? Wayë manami aypannatsu micuynëcunata churanäpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tsaynog yarpachacuycashganchöshi caynog nergan: ‘Canan churacuna wayëta juchurcatsirmi jucta sharcatsishag más jatuncarayta. Nircurmi tsayman lapan shuntashgä micuynëta pirwashagpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tsaynog pirwacuycuptëga atsca watapagmi micuynë cangapag. Nircurnami micur upur cushishgala cawacushagpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tsaynog yarpachacuycaptinshi Tayta Diosnintsi caynog nergan: ‘¡Mana ali yarpayniyog runa! ¡Canan tsacaymi wanunquipag! Lapan pirwacushgayqui ¿pipagrag canga?’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesús tsaynog parlayta usharcurmi caynog nergan: “Tsay wanog rïcu runa manacagpag cosëchata shuntashgannogmi quiquilanpag imatapis munagcunaga wanur mana imatapis chasquengapagtsu Tayta Diosnintsipita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nircur discïpuluncunatapis Jesús caynog nergan: “Gamcunaga ama yarpachacäriytsu: ‘¿Imatarag micushag? ¿Imatarag jaticushag?’ nir. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Micuynintsi captinpis y röpantsi captinpis manami tsaylachötsu ali cawayta tarintsi. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Shumag tantyacäriy pishgucuna imanog cawashgantapis. Paycunaga manami murucuntsu, ni cosechantsu ni pirwacuntsu. Tsaynog captinpis Tayta Diosnintsimi micuyta camaripan. Tayta Diosnintsipäga tsay pishgucunapitapis gamcuna masmi välipäcunqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mayjina yarpachacurpis ¿pirag winarcunman tamäñunpita juc cuchus maslatapis? ");
INSERT INTO qvmNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tsaynoglami mayjina yarpachacurpis tsay yarpachacushgalanwanga mana pipis tarengatsu röpatapis ni micuytapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tantyacäriy waytacuna imanog cuyaylapag tuctushgantapis. Waytacunaga mana aruycarpis mana putscacuycarpis cuyaylapagmi ricacun. Tsay waytacuna cuyaylapag cashgannöga manami unay rey Salomón jaticushgan röpancunapis cuyaylapag cashgatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tsaquiptin rupatsishga cananpag captinpis Tayta Diosnintsega alimi guewacunata winatsin. Yäracuyniynag runacuna, waytacunatapis cuyaylapagta tuctuycätserga ¿manatsurag gamcunatapis Tayta Diosnintsi yanapashunqui röpayquita tarinayquipag? ");
INSERT INTO qvmNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Tsaynog caycaptenga ama laquicäriytsu imata micapäcunayquipag ni imata upupäcunayquipagpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsaynöga laquicärin Tayta Diosman mana yäracog runacunalami. Gamcunaga ama paycunanog laquicäriytsu. Imata nistashgayquitapis Tayta Diosnintsega musyaycanmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nistashgayquicunapag yarpachacunayquipa trucanga Tayta Diosnintsi munashgannog cawanayquipag imaypis yarpachacäriy. Pay munashgannog cawaptiquega imata nistashgayquitapis camaripäshunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tsaynog caycaptenga, cuyaynëcuna, ama laquicäriytsu. Gamcunatami Tayta Diosnintsi acrapäcushushcanqui imayyagpis paypa naupancho cawapäcunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Tsaynog caycaptenga imayquicunatapis ranticuycur tsay guellaywan wactsacunata yanapay. Tsaynog yanaparga gloriaman riquëzayquita churacognogmi carcaycanqui. Tsaynogpami gloriaman chayar cay patsacho ima riquëzapitapis más ali cagcunata chasquipäcunquipag. Tsaytaga manami suwapis apangatsu ni puyupis ushangatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Rïcu canalayquipag yarpachacorga manami Tayta Dios munashgannog cawanayquipag yarpachacuycanquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Noga cutimuptë chasquicamänayquipag camaricushga mayag mayagla carcaycay. Patronnin casaray fiestapita cutimunanta shuyarpaycag ashmaycunanogla nogatapis shuyämay cutimuptë chasquicamänayquipag. Puncuta jucla quichapänanpag ashmaynincuna atsquinwan shuyaragnog gamcunapis camaricushgala carcaycay. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tsaynog shuyämagcunataga mësaman jamaycatsir quiquë sirviptëmi pasaypa cushicärengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Imay hörapis cutimushagmi: pulan pagas carpis o walpa wagay carpis. Tsaymi mayag mayagla cutimunäta shuyarpämay. Shuyarpaycämagta gloriaman pushaptëmi cushicärengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Pipis wayinta suwapänanpag cashganta musyarga mana punuypami wayinta täpanman. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tsaynogla gamcunapis camaricushgala carcaycay. Mana musyashgayqui hörami elagpita noga cutimushagpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsauraga Pedro caynog taporgan: “Tsaynog yachatsishgayquega ¿nogacunalapagcu o lapan runacunapagwancu caycan?” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Niptin Jesús caynog nergan: “Patronnin maypapis ilarga más yäracuypag cag ashmaynintami haciendancho patronyapänanpag churan. Tsaymi tsay ashmayga mincaynincunatapis höralancho garatsin. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Patronnin cutimur yätsishgannog ali ruraycagta tariycorga: ‘Ali ashmaymi canqui’ nengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tsaynog nishpanmi patronnin tsay ashmaypa maquinman churanga lapan imaycantapis ricananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mana yäracuypag cag ashmaymi itsanga: ‘Patronnë manaragmi cutimongaragtsu’ nir ashmay mayinta magan y micur upyar jitaräcun. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tsaynog caycaptinmi mana musyashgan höra elagpita patronnin cutimonga. Patronnin yätsishganta mana cäsucur lutanta ruraycagta tariycurmi mana cuyapaypa tsay ashmayta castigangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","“Mana musyayninpa juc ashmay lutanta ruraptenga patronnin manami aläpatsu castiganga. Patronnin nishganta musyaycar mana wiyacuypa lutanta ruraptinmi itsanga patronnin fiyupa castiganga. Tsaynoglami Tayta Diosnintsipa wilacuyninta musyaycar pipis mana cäsucuptenga infiernucho fiyupa castigashga canga. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Cay patsaman noga shamushcä chasquicamagcuna salvashga cananpag y mana chasquicamagcuna juzgashga cananpagmi. ¡Maynapis runacunata juzgayta galaycömanna! ");
INSERT INTO qvmNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Itsanga runacunata salvanäpäga fiyupa nacarragmi wanushagpag. Nacanäpag cashganta musyarmi pasaypa laquicö. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Gamcunaga yarparcaycanqui cay patsaman shamushga captë runacuna cuyanacur alina cawapäcunanpag cashgantami. Manami yarpashgayquinogtsu canga. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpitaga yäracamagcunata mana yäracamagcuna chiquipäcongami. Tsaynog carmi juc wayicho quiquinpura chiquinacärenga. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taytanmi chiquenga tsurinta y tsurinmi chiquenga taytanta. Mamanmi chiquenga wawanta y wawannami chiquenga mamanta. Lumtsuyninmi chiquenga suedranta y suedrannami chiquenga lumtsuyninta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tsaypitanami runacunata Jesús caynog nergan: “Inti jeganan cagpa pucutay yurimuptenga: ‘Tamyanganami’ nipäcunqui, y nipäcushgayquinoglami tamyan. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inti jegamunan cag derëcha cag lädupita wayra wayrämuptenga: ‘Shanangami’ nipäcunqui, y nipäcushgayquinoglami shanan. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Musyag-tucogcuna! Ciëluta ricar y cay patsata ricar imanog tiempo cashgantapis tantyaycarga ¿imanirtag mana tantyapäcunquitsu jutsata rurashgayquipita Tayta Diosnintsi juzgashunayquipag cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tiempo cashganyag ¿imanirtag mana yarpachacunquitsu salvashga canayquipag? ");
INSERT INTO qvmNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","¿Manacu pipis quejashuptiquega autoridäman manarag chayar arreglapäcunqui? Mana arreglaptiquega juezmanmi apatsishunqui. Jueznami wardiacunawan carcilman wichgatsishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tsaypitaga manami yargunquipagtsu lapan jagan cashgayquita manarag pägarga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tsay hörami runacuna Jesusta wilargan caynog nir: “¡Galilea runacuna templucho Tayta Diosnintsipag uywacunata rupaycätsiptinshi Pilato soldäduncunata cachargan wanutsinanpag!” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tsauraga Jesús caynog nergan: “Ama yarpapäcuytsu waquin Galilea runacunapita tsay wanog runacuna más jutsayog cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Manami Tayta Diosnintsipa castïgunwantsu paycuna wanushga. Gamcunami itsanga Tayta Diosnintsipa castïgunwan infiernucho nacapäcunquipag jutsa rurayta mana cacharishpayquega. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tsaynogpis Siloé nishgancho törri juchur chunca pusag (18) runacunatami nitergan. Tsaynog captinpis ama yarpapäcuytsu Jerusalencho tag waquin runacunapita tsay wanog runacuna más jutsayog cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Manami Tayta Diosnintsipa castïgunwantsu paycunapis tsaynog wanushga. Gamcunami itsanga Tayta Diosnintsipa castïgunwan infiernucho nacapäcunquipag jutsa rurayta mana cacharishpayquega.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsaymi mana cäsucog runata mana wayog hïgusman tincutsishpan Jesús caynog nergan: “Juc runapa chacranchöshi cargan hïgus. Tsayshi hïgusta palag aywar mana tarergantsu ni juclaylatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsauraga caynog nergan chacran arogta: ‘Quimsa watanami shamö cay hïgus yörapa wayuyninta palag y manami ni juclaylatapis tarishcätsu. Muturir jucla jitariy cay chacrapita. Mana wayog hïgustaga ¿imapagtag chacrachöpis tsararäshun?’ ");
INSERT INTO qvmNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tsaynog niptin chacran arog runa caynog nergan: ‘Shuyaycushun juc watayag, tayta. Chulpata winaparcurrag uryashag. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsaynog ruraptëga pagta wayunmanpis. Tsaycho mana wayuptinmi itsanga muturir jitarishunpag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juc sábado jamay junagchömi sinagogacho Jesús yachaycätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tsaychömi caycargan demonio curcuyätsishgan warmi. Paymi nacaycargan chunca pusag (18) watana derechacayta mana puëdishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tsay warmita gayaycurmi Jesús caynog nergan: “Cananga aliyashganami caycanqui curcu cashgayquipita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tsaynog nir yataycuptin jinan höra aliyargan. Aliyarcurna tsay warmi Tayta Diosnintsita alabargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sábado jamay junagcho Jesús aliyätsiptinmi tsay sinagogacho mandag rabiacorgan. Tsaymi runacunata caynog nergan: “Sogta junagmi caycan runacuna arunanpäga. Tsay junagcunacho shapäcamunqui aliyashga cayta munarga. ¡Ama sábado jamay junagchöräga shapäcamunquitsu!” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsauraga Jesús caynog nergan: “¡Ishcay cära runacuna! Sábado jamay junag captinpis ¿manacu töruyquita bürruyquita pascarcur yacuta uputseg gatinqui? ");
INSERT INTO qvmNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chunca pusag (18) watami cay warmita curcuyaycatsir Satanás nacatsishga. Uywayquicunatapis sábado jamay junagcho tsaynog cuyapaycaptiquega ¿manacu cay Israel warmitapis cuyapashwan, sábado jamay junag caycaptinpis?” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tsaynog niptinmi chiquegnincuna pucayayparag pengacärergan. Waquin runacunami itsanga cushicärergan tsay warmita aliyätsishganta ricar. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Mastapis Jesús tincutsiypa yachatsir caynog nergan: “Tayta Diospa ali wilacuynenga ñäpush murunogmi caycan. Ñäpushta muruptin winamun ata cashganyag. Tsaymi pishgucunapis gueshwancunata rämancunacho ruran. Tsay tacshala murulapita ñäpush winarcamur räman mashtacashgannogmi Tayta Diospa ali wilacuynenga may-tsaymanpis chayaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Nircur Jesús caynogpis nergan: “Tayta Diospa ali wilacuynenga levadüranogmi caycan. Tantata rurananpag warmi quimsa arröba harinaman levadürata winaptenga mäsa shumagmi jacan. Ichicla levadüra mäsata jacatsishgannogmi Tayta Diosnintsipa wilacuyninpis may-tsayman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsaypita Jerusalenpa Jesús aywarmi marcacunapa y jalgacunapapis yachatsiraycar pasargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tsaychömi juc runa caynog nir taporgan: “Tayta, ¿walcaglacu salvaconga?” Tsaymi Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Salvacärinayquipäga quichqui puncupanogragmi gloriaman yaycapäcuy. Atscag yaycuyta munarpis walcaglami tsay puncupa yaycapäconga. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wayipa duëñun puncunta wichgacarcamuptin wagtacho quëdagcuna caynog nirmi tacacongapag: ‘Quichapaycalämay, tayta.’ Tsauraga pay nengapag: ‘Gamcunataga manami reguëtsu. ¿Pirag cacunquipis?’ ");
INSERT INTO qvmNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsaymi nipäcongapag: ‘¿Imanirtag mana reguimanquitsu? Micur upurmi purergantsi. Y marcäcunachöpis yachatsergayquimi.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tsauraga yapaymi nengapag: ‘Gamcunataga manami reguëtsu. ¿Pirag capäcunquipis? ¡Nogapita witicäriy, jutsasapa runacuna!’ ");
INSERT INTO qvmNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Gloriaman mana yaycur, Abrahamta, Isaacta, Jacobta y Tayta Diosnintsipa profëtancunatapis ruricho caycagta ricashpan fiyupami wagapäcongapag. Pasaypa laquicurmi quiruntapis uchupäconga, yaycuyta mana puëdishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","May-tsaypitapis shamog runacuna gloriaman yaycog cagmi itsanga Tayta Diosnintsi camarishgan micuyta cushishgala micapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Cay patsacho mana ali ricashga cagcunaga Tayta Diosnintsi juzganan junag ali ricashgami cangapag. Yachag-tucogcunami itsanga tsay junag infiernuman gaycushga cangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tsayman waquin fariseucuna chayaycurmi Jesusta caynog nipäcorgan: “¡Caypita aywacuy! Herodismi wanutsiyta yarpaycäshunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tsauraga Jesús caynog nergan: “Tsay alguta caynog nir wilay: ‘Juc ishcay junaglanashi demoniucunata runacunapita Jesús gargonga y gueshyagcunatapis aliyätsenga. Tsaycunalawannashi ushanga lapan rurananpag cagcunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tsaypitanashi Jerusalenman aywanga wanutsishga cananpag. Diospa wilacognincuna Jerusalencho wanushgannogshi paypis, Diospa wilacognin car, Jerusalenchörag wanonga.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tsaypita Jesús caynog nergan: “¡Jerusalén runacuna! ¿Imanirtag Tayta Diosnintsipa profëtancunata y cachamushgan wilacogcunata naupapita-patsa wanurcaycätsinqui? Chipshancunata maman shuntarcur oglacognogpis gamcunata atsca cutimi shuntayta munargä. Tsaynog munaptëpis gamcunaga manami munapäcushcanquitsu shuntanäta. ");
INSERT INTO qvmNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tsaymi gamcunata Tayta Diosnintsi manana tsapäshuptiqui contrayquicuna shamur marcayquitapis ushacätsengapag. Manami yapay ricapäcamanquipagnatsu: ‘¡Tayta Diosnintsi cachamushgan runa caycarga shacalämuy, tayta!’ nimänayquiyag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tsaypitana sábado jamay junagcho Jesús aywargan mandag fariseupa wayinman micog. Tsaycho waquin fariseucuna Jesusta ricapaycargan: “Mä sábado jamay caycaptin ¿imatashi ruranga?” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Intëru cuerpun jacapäcuycag runata Jesús ricarmi Moisés escribishganta yachatsegcunata y fariseucunata taporgan caynog nir: “Sábado jamay junagcho ¿aliyätsishwancu o manacu?” nir. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Imatapis mana rimacäriptinmi gueshyaycag runata Jesús yataycur aliyätsergan. Aliyarcatsirna caynog nergan: “Cananga wayiquipana aywacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nircur fariseucunata caynog nergan: “Maygayquipapis tsuriqui o töruyqui pözuman jegaptin ¿manacu jinan höra jorgog aywanqui, sábado jamay junag caycaptinpis? Tsay rurashgayquinoglami nogapis gueshyagcunata aliyätsë, sábado jamay junag caycaptinpis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tsaynog niptin manami imatapis rimacärergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tsaychömi waquin gayatsishgan runacuna, ali ricashga cayta munar, mësamanrag aywapäcorgan jamacärinanpag. Tsayta ricaycurmi Jesús yachatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Pipis casaray fiestaman gayatsishuptiquega juclaga mësaman ama jamacärinquitsu. Gamcunapita más respitädu runa chämuptin: ‘Mësapita witicuy pay jamacunanpag’ nishuptiqui pengay-tucushgami mësacho jamaraycashgayquipita yargunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mësaman jucla jamacunayquipa trucanga shuyaranqui gayatsishogniqui: ‘Pasacalämuy mësaman jamacunayquipag’ nishunayquitarag. Tsaynog jamatsishuptiquimi mësacho gamwan jamacogcuna ali respitashunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tsaynog nishpanmi Jesús nergan: “Mayganpis musyag-tucogcunaga pengaymanmi churashga canga. Mana musyag-tucogcunami itsanga ali respitashga canga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nircur wayinman pushag runatapis Jesús caynog nergan: “Micapäcunayquipag pitapis gayatserga ama gayatsinquitsu cuyanacushgalayquitaga, wauguilayquitaga, castalayquitaga ni rïcu cag vecïnulayquitaga. Paycunata gayatsiptiquega garashgayquinoglami paycunapis garashunquipag. Tsaymi paycuna garashushgalayqui premiuyqui canga. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tsaypa trucanga gayatsinqui wactsacunata, wegrucunata y gapracunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paycunaga manami ni imanogpapis cutitsishunquipagtsu. Paycunata garashgayquipitaga Tayta Diosnintsinami premiuta goshunqui jutsaynag runacunata cawaritsimushgan junag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tsaymi mësacho jamaraycashganpita juc runa caynog nergan Jesusta: “¡Ima cushishgarag canga Tayta Diosnintsi camarishgan micuyta gloriacho micogcuna!” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tsaynog niptin tincutsiypa Jesús caynog yachatsergan: “Juc runashi atsca runacunata wilacatsergan juc junagcho wayinman micog aywananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tsay junag chämuptinnashi ashmayninta cachargan tsay wilacatsishgan runacunata pushamunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tsay ashmay wilag chayaptinshi jucnin caynog nergan: ‘Rantishgä chacrata ricagragmi aywashag. Nogapita ama jagayayculätsuntsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jucagnashi caynog nergan: ‘Pitsga par törutami rantishcä. Tsaymi ali arog o mana ali arog cashgantapis musyanäpag canan junag arog aywashag. Nogapita ama jagayayculätsuntsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jucagnashi caynog nergan: ‘Tsayragmi warmita jorgushcä. Tsaymi gayatsimashganman aywayta mana camäpacushagtsu.’ Tsaynoglashi lapan gayatsishgan runa aywayta mana munargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tsauraga tsay cachashgan ashmay cutiycur patronninta wilargan runacuna imanog nishgantapis. Tsaynog wilaptin patronnin fiyupa rabiacorgan. Nircurna ashmayninta caynog nergan: ‘Cällicunapa aywaycur jucla pushamuy wactsacunata, gapracunata y wegrucunatapis.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tsauraga patronnin nishganta rurarcurnashi ashmaynin caynog nergan: ‘Nimashgayquinoglami pushamushcä, tayta. Tsaynog captinpis mësaman manaragmi runacuna juntanragtsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tsaynashi patronnin caynog nergan: ‘Nänicunapa y chacracunapapis aywarcur tsaycho tarishgayqui runacunata imaycanogpapis wayëman juntananyag pushamuy. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Puntata gayatsimushgäcunaga perdishganami yanucatsishgä micuyta.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Atsca runacuna gatirpaptinmi Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mayganpis discïpulö cayta munarga mamanpag, taytanpag, warminpag, tsurincunapag, wauguincunapag y panincunapag yarpachacunanpa trucanga más yarpachacutsun noga munashgäta rurananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Discïpulöcunaga imanog nacarpis noga munashgänogla imaypis cawatsun. Wanunanyag noga munashgänog mana cawarga manami discïpulö canmantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Discïpulö caycashganpita witicogcunaga wayi rurayta galaycatsir mana ushatsegnogmi caycan. Pipis wayita rurananpäga shumagragmi yarpachacärin tsay wayita ushatsinanpag gastun aypashganta o mana aypashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cimientuta ruraycular cachariptenga lapan ricagcunami payta jamurpanga caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Tsay runaga puëdegnogpis wayi rurayta galaycatsishga mana ushatsinanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Maygan nacionpis juc nacionwan manarag pelyar ¿manacu puntataga mandagnin reycuna shumagrag yarpachacärin ishcay chunca waranga (20,000) soldäducunata chunca waranga (10,000) soldädulanwan vincinanpag o mana vincinanpag cashgantapis? ");
INSERT INTO qvmNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pelyayta mana puëdinan captenga jucag cag mandag carucho caycaptilanragmi wilacogninta cachan: ‘Mananashi pelyashunnatsu. Munashgayqui cagtashi imäcunatapis apacunqui’ nir wilananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tsaynogla discïpulö canayquipag listula carcaycay noga-raycu lapan imayquicunatapis cacharinayquipag. Imayquicunatapis cachariyta mana munarga manami discïpulö capäcunquimantsu. Nishgäta mayag cäga shumag tantyacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Musyashgayquinogpis cachega alimi caycan micuyta gustuta gonanpag. Tsulur rumilan quëdaptinnami itsanga imapagpis mana välinnatsu alpapag ni chulpapagpis. Tsaynog captenga jitariycuntsinami. Wanunayquiyag discïpulö mana carga cuidädu gamcunapis Tayta Diosnintsipa naupanpita jitarishga capäcunquiman.” ");
INSERT INTO qvmNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impuesto cobragcunawan Diosta mana cäsucog runacunapis aywapäcorgan Jesús yachatsishganta mayapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tsayta ricar fariseucuna y Moisés escribishganta yachatsegcuna Jesusta jamurpargan caynog nir: “¿Imanirtag cay runaga Diosta mana cäsucogcunawan juntacaycur micun?” ");
INSERT INTO qvmNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsaynog nipäcuptinmi Jesús tantyatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pipis pachac (100) uyshanpita jucta ograycorga ¿manacu waquin cagta juc patsaman ayluycur jucla aywan ashimunanpag? ");
INSERT INTO qvmNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tariycorga cushishgami apricurcur apan waquin cagman talutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wayinman chayaycurnami vecïnuncunata y reguinacushgancunatapis shuntaycur cushicushpan wilapan caynog nir: ‘¡Ograshgä uyshätami tarimushcä!’ ");
INSERT INTO qvmNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tsay runa uyshata tariycur cushicushgannoglami Tayta Diosnintsiwan angilcunapis cushicärin juclaylapis jutsasapa runa Diosta chasquicuptin. Tsaynog cushicärin isgun chunca isgun (99) Dios munashgannog cawag runacunapag cushicushganpita masmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tsaynog pï warmipis chunca (10) guellayninpita jucta ograycorga atsquita ratarcatsirmi jucla wayinta pitsapacun ograshgan guellayta ashinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ashiycashgancho tariycorga vecïnancunata y reguinacushgancunatapis shuntaycur cushishgami wilapan caynog nir: ‘¡Ograshgä guellaynëtami tarishcä!’ ");
INSERT INTO qvmNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tsaynogmi Tayta Diosnintsipa angilnincunapis cushicärin juc runalapis jutsa ruraycunata cacharir Tayta Diosnintsita chasquicuptin.” ");
INSERT INTO qvmNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mastapis Jesús caynog nergan: “Juc runapashi ishcay olgu tsurincuna cargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tsayshi shulca cag tsurin papäninta caynog nergan: ‘Papá, herenciäta jucla raquipaycalämay.’ Tsaynog niptinshi papänin raquipaycorgan paypag cagcunata. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tsaypita juc ishcay junaglatanashi lapan chasquishgancunata ranticuycorgan. Nircur tsay guellaywan aywacorgan caru marcaman. Tsaychönashi munashganta rurar lapan guellayninta manacagcunacho ushargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","15","“Tsay marcacho caycaptinnashi fiyupa muchuy cargan. Tsayshi tsay mözu fiyupa yarganar aruyta ashiptin hacendädo runa payta chasquergan cuchinta mitsipänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cuchita mitsirnashi pasaypa yarganar cuchipa micuynintapis micuyta munargan. Tsaynog yargaycaptinpis micuy mana captinshi pipis mana garargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tsayshi yarpachacorgan caynog nir: ‘Papänëpa mincaynincunaga sacsagpag micushgachari carcaycan, caycho yargaypita wanuycaptë. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Caynog canäpa trucanga papänë cagpa cuticushag. Chayaycorga caynogmi nishag: “Papá, perdonaycalämay. Gomashgayquicunata manacagcho ushar jutsatami rurashcä. Manami gam munashgayquinogtsu ni Tayta Diosnintsi munashgannogtsu rurashcä. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cananpitaga ama chasquimaytsu tsuriquitanöga, sinöga mincayniquitanoglana chasquiycalämay.” ’ ");
INSERT INTO qvmNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tsaynog yarpachacurcurnashi cuticorgan papänin cagpa. “Tsayshi caruta aywaycämogta ricaycur papänin cushicushpan cörrila aywaycur macalacurcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tsayshi tsurin caynog nergan: ‘¡Perdonaycalämay, papá! Gomashgayquicunata manacagcho ushar jutsatami rurashcä. Manami gam munashgayquinogtsu ni Tayta Diosnintsi munashgannogtsu rurashcä. Cananpitaga ama tsuriquitanog chasquimaytsu, sinöga mincayniquitanoglana chasquiycalämay.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tsaynog niycaptinshi papänin ashmaynincunata caynog nergan: ‘Más ali cag röpata jucla jorgapäcamuy tsurë trucacunanpag. Tsaynogpis sortëjata y zapatuta jorgapäcamuy jaticunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nircur werannin turituta pishtapäcuy fiestata ruranantsipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Cay tsurëga wanushganog cashganpita cawarimushganogmi caycan! ¡Ogracashga cashganpitami yurimushga!’ Tsaynog nir cushicurshi fiestata rurapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tsayyäga mayor cag tsurenga chacrachöshi caycargan. Tsaypita cutimur wayiman chayaycashganchöshi mayargan wayincho fiestata rurarcaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsauraga juc ashmayninta gayaycur taporgan wayincho imanir fiestata rurarcaycashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tapuptin ashmaynin caynog nergan: ‘Wauguiquimi cutimushga. Tsaymi papäniqui pishtatsishga werannin turituta wauguiqui chämushganpita cushicur.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tsaynog wilaptinshi fiyupa rabiashpan wayinman yaycuyta mana munargantsu. Tsauraga papänin aywaycurshi ruwargan wayiman yaycunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tsayshi papäninta caynog nergan: ‘Gam musyashgayquinogpis mana yarguypami gamta yanapaycä lapan nimashgayquicunata rurar. Tsaynog yanapaycaptëpis manami imaypis gomashcanquitsu ni juc cabralatapis amïgöcunawan fiestata ruranäpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","¡Cay guella tsuriqui jutsa ruraylacho cawag warmicunawan guellayniquita usharcur cutiycamuptinmi itsanga pishtatsishcanqui werannin turituta!’ ");
INSERT INTO qvmNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tsaynog niptin taytan nergan: ‘Imanog captinpis gamga mana yargucuypami nogawan caycanqui, hïjo. Tsaymi lapan imaycäcunapis gamlapagna caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wauguiqui jutsa rurayta cacharir cutimushga caycaptenga imanog captinpis fiestata rurashun.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tsaymi discïpuluncunata yachatsir Jesús caynog nergan: “Juc ashmaynintashi patronnin churargan imaycantapis shumag ricananpag. Tsaypitashi tsay patronninta runacuna wilapargan imaycantapis lutala ashmaynin ushaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsayta musyaycurna patronnin gayatsimorgan. Nircurna caynog nergan: ‘Runacuna gampag rimapäcun imäcunatapis lutala ushaycashgayquitami. Cananga wilamay lapan imata rurashgayquitapis. Cananpitaga mananami imaycäcunatapis ricanquipagnatsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tsauraga tsay runa yarpachacorgan caynog nir: ‘¿Imatarag canan rurashag patronnë gargamaptenga? Manami calpä cantsu chacracho arunäpag. Caridäta manacuytapis pengacömi. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Alfin patronnë gargamaptin jina ¿imanäshagtag? Jagan runacuna yanapamänanpag mejor cobrashag pulalanta.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tsayshi patronninpa jagan cag runacunata juc juclayla gayaycatsir punta cagta taporgan caynog nir: ‘¿Aycatag patronnëpa jagan caycanqui?’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tsaynog tapuptin nergan: ‘Paypa jagan caycä ishcay pachac (200) läta aceitimi.’ Tsauraga tsay runa caynog nergan: ‘Canan escribishun pachac (100) läta aceitilatana päganayquipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tsaypita jucnin cagtana caynog taporgan: ‘Gamga ¿aycatag jagan caycanqui?’ Tsay runa caynog nergan: ‘Paypa jagan caycä ishcay waranga (2,000) arröba trïgumi.’ Tsaynog niptinshi nergan: ‘Canan escribishun waranga pitsga pachac (1,500) arröba trïgulatana päganayquipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","9","Tsaynog rurashganta musyaycur patronnin caynog nergan: ‘Yanapashga cayta munarga ¡tsay runa amistä rurayta yachanmi!’ ” Tsaynog wilaparcur Jesús caynog nergan: “Mana nacananpag tsay runa yarpachacushgannog gamcunapis yarpachacäriy imanogpapis gloriaman chayanayquipag. Tsaynogla imalawanpis runa mayiquita yanapay paycunapis Diospa wilacuyninta chasquicur gloriaman chayananpag. Tsaynog ruraptiquimi gloriaman chayaptiqui cushishga chasquishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Walcalata tsararashgayquiwan runa mayiquita yanaparga atscata tsarararpis yanapanquipagmi. Mana yanapäcog carga atscata tsarararpis manami yanapäcunquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Tsaynogla imata paytacushuptiquipis mana yatapacuylapa ali ricanqui. Mana yatapacog captiquega Diospa ali wilacuyninta wilapaptiquipis chasquishunquipagmi. Mana yäracuypag captiquega manami cäsushunquipagtsu ni imata niptiquipis. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Manami pipis ishcay patronta sirvinmantsu. Ishcay patronyog carga jucninta cäsucur jucnintaga manami cäsucongatsu. Jucninta cuyar jucnintaga manami cuyangatsu. Tsaynoglami rïcu canalanpag yarpachacogcunaga: ‘Tayta Diospa maquinchömi caycä’ niycarpis pay munashgannog cawayta mana camäpacuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tsaynog yachatsishganta mayaycurmi fariseo runacuna Jesusta asipargan. Tsaynog asipargan imaypis rïcu canalanpag yarpachacog carmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tsauraga Jesús caynog nergan: “Gamcuna ishcay cära captiquipis Tayta Diosnintsi musyanmi shonguyqui imanog cashgantapis. Tsaymi runacuna respitashuptiquipis Tayta Diosnintsipäga ishcay cära cashgayqui pasaypa mana ali caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moisés escribishgancuna, Tayta Diosnintsipa profëtancuna escribishgancuna y Juan Bautista wilacushgancunapis niycan noga shamunäpag cagpitami. Tsaymi Juan wilacuyta galaycushganpita-patsa atsca runacuna Tayta Diosnintsipa wilacuyninta imanogpapis chasquicurcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Jana patsa y cay patsa ushacaptinpis Moisés y waquin profëtacuna escribishgancunaga lapanmi cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pï runapis warminpita raquicaycur juc warmiwan targa adulterio jutsatami ruraycan. Tsaynogpis runanpita raquicashga warmiwan pipis targa adulterio jutsatami ruraycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tsaypitanami Jesús caynog wilapargan: “Juc rïcu runashi cargan ali röpacunalata jaticog. Tsaynogpis waran waran amïguncunawan fiestata rurar ali micuycunalata micapäcog. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tsay rïcu runapa wayi puncunchöshi wactsa runa Lázaro jutiyog jamarargan. Läzarupa intëru cuerpuntashi gueri ushaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Payshi rïcu runa micur shicwapacushgalantapis micuyta munapargan. Tsaychöshi algucunapis Läzarupa guerinta lagwapargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lázaro wanuycuptinnashi angilcuna almanta apapäcorgan Abraham caycashgan cagman. Y rïcu runa wanuycuptinnashi castancuna pampapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Mana cuyapäcog rïcu runapa almannashi aywargan Hadisman. Tsaychöshi fiyupa nacaycashgancho carupita ricargan Läzaruta Abrahampa naupancho caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsauraga rïcu runa gayacorgan caynog nir: ‘Tayta Abraham, cuyapaycalämay. Läzaruta cachaycalämuy dëdunta ushmarcatsir shimëta ushmatsipämänanpag. Fiyupami nacaycä cay ninacho rupar.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tsaynog niptinshi Abraham caynog nergan: ‘Yarpay manarag wanur imaycayogpis cashpayqui ali cawashgayquita. Läzarunami itsanga wactsa cashpan fiyupa nacargan. Tsaymi cananga pay cushishga caycho caycan y gamna tsaycho nacaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tsaynogpis jatuncaray jiu-jiuyaycag ragrami raquiycämantsi. Tsaymi gam cashgayqui cagman mana pipis tsimpamuyta puëdintsu. Tsaynog gampis mana puëdimunquitsu tsimpamuyta noga caycashgä cagman.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tsaynog niptinshi rïcu runa caynog nergan: ‘Tayta Abraham, papänëpa wayinman Läzaruta cachayculay. ");
INSERT INTO qvmNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tsaycho pitsgaragmi wauguëcuna caycan. Paycunaman wilag aywayculätsun cay nacayman mana shamunanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tsauraga Abraham caynog nergan: ‘Paycuna tsararanmi Moisés y waquin profëtacuna escribishgancunata. Tsaycunata cäsucäritsun.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tsayshi rïcu runa nergan: ‘Tayta Abraham, tsarararpis tsaytaga manami cäsucärengatsu. Juc runa wanushganpita cawarircur wilacuptinmi itsanga jutsa ruraycunata cacharenga.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tsaynog niptin Abraham caynog nergan: ‘Moisés y waquin profëtacuna escribishgancunata mana cäsucuycarga wanushganpita cawarircur wilacog aywaptinpis manami cäsucärengatsu.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nircurna discïpuluncunata Jesús caynog nergan: “Jutsata ruranayquita Tayta Diosnintsi mana munaptinpis jutsaman tunitsicogcuna imaypis cangami. ¡Paycunaga juicio final junag pasaypami laquicongapag! ");
INSERT INTO qvmNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tayta Diosman yäracogcunata jutsaman tunitsiptenga más alimi canman mulïnu rumita cuncanman wataparcur lamarman garpuriptinpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuidädu gamcunapis jutsaman tunitsicog runacunanog capäcunquiman. “Tayta Diosman yäracog mayiqui imalachöpis rabianätsishuptiquega jutsa ruraycashganta tantyatsinqui. Tantyatsiptiqui chasquicuptenga perdonanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Juc junaglacho ganchis cuti rabianätsishuptiquipis: ‘Perdonaycalämay’ nishuptiquega perdonanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tsaynog niptin apostolnincuna Jesusta caynog nergan: “Yanapaycalämay Tayta Diosnintsiman más yäracur runa mayëta nishgayquinog perdonanäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tsauraga Jesús caynog nergan: “Ñäpushpa murunnog tacshalapis yäracuyniqui captenga cay jatuncaray sicómoro yörata: ‘Sapipita tsutacarcur lamarman jawicämuy’ niptiquipis jawicämongami.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ashmaynincuna arushganpita o mitsicushganpita chayaptin manami pipis ashmayninta: ‘Jamayculay micunayquipag’ nintsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tsaypa trucanga lapanpis nipäcun: ‘Yanucamuyrag garamänayquipag. Noga micuyta usharcuptëragmi gamga micunquipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mandashganta ruraycaptinpis manami ‘Graciaslä’ nintsu ashmayninta. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Ashmaycunanoglami gamcunapis carcaycanqui. Tsaymi Tayta Diosnintsi munashganta rurarpis ama shuyarpanquitsu pipis: ‘Alitami rurashcanqui’ nishunayquita. Tsaypa trucanga caynog nipäcuy: ‘Nogacunaga Tayta Diosnintsipa ashmayninmi carcaycä. Tsaymi munashgalanta ruraycä.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalenpa aywarmi Jesús pasargan Samaria y Galilea provinciacuna cuchulanpa. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tacsha marcaman chayananpag caycaptinmi leprawan gueshyaycag chunca (10) runacuna payta ricargan. Tsaymi carulapitana gayacorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“¡Tayta Jesús, nogacunata cuyapaycalämay!” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tsaymi Jesús caynog nergan: “Aywapäcuy cüracunaman ricashunayquipag.” Tsaynog niptin aywarcaycashgalanchöna aliyargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tsaymi aliyashganta ricaycur juc cutergan Jesús cagman Tayta Diosnintsita alabaraycar. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chayaycurnami gongurpacuycorgan Jesuspa naupanman: “¡Graciaslä, tayta!” nishpan. Tsay cuteg runaga cargan Samariapitami. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsaymi Jesús nergan tsaycho cag runacunata: “Leprapita aliyagcunaga ¿manacu chunca (10) cargan? ¿Maytag waquin cagcunaga? ");
INSERT INTO qvmNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Waquin cagcuna Israel runa caycarpis aliyashganpita Tayta Diosta alabananpag manami cutimushgatsu. Cay runami itsanga, mana Israel runa caycarpis, cutimushga Tayta Diosnintsita alabananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nircur tsay runata nergan: “Cananga aywacuyna. Tayta Diosman yäracushgayquipitami salvashgana caycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Juc cutimi Jesusta fariseucuna tapupäcorgan caynog nir: “Israel runacunapa mandagnin Cristo chämunanpagna caycashganta ¿imanogpatag musyapäcöman?” Tsaynog tapuptin caynog nergan: “Tayta Dios cachamushgan Cristo chämunanpagna caycashganta manami lapan runacunatsu tantyacärenga. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manami pipis nengatsu maychöpis caycashganta. Tsaypa trucanga Tayta Diosnintsi cachamushgan Cristo gamcunawannami caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsaypita más rätuntanami discïpuluncunata caynog nergan: “Gloriamanna aywacuptë gamcuna pasaypami munapäcunqui jucla noga cutimunäta. Tsaynog munaptiquipis manami juclatsu cutimushag. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pipis: ‘Tsaychömi o wacchömi Tayta Dios cachamushgan Cristo caycan’ nishuptiquipis ama cäsupäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wisculcuna juntacaycagta ricarmi musyantsi wanushga uywa tsaycho jitaraycashganta. Tsaynoglami cay nishgäcuna pasaycagta ricar musyanqui noga cutimunäpagna caycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tsaynog manarag captinmi puntataga runacuna chiquimar fiyupa nacatsimanga. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noé cawanan witsan diluvio elagpita cashgannogmi nogapis elagpita cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé cawanan witsanpis runacunaga micur, upyar y majatsacarmi caycargan. Tsaynog cawapäcorgan arcaman Noé yaycushgan junagyagmi. Tsaynog caycaptinmi elagpita fiyupa tamyar cay patsaman yacu juntargan. Tsaynogpami lapan runacuna shengaypa wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tsaynoglami Lot cawanan witsanpis runacuna micur, upyar, rantir, ranticur, murucur y wayitapis sharcatsir caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma marcapita Lot yarguptinnami ciëlupita tamyamorgan azufriyog nina. Tsaychömi lapan runacuna rupaycar wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tsaycuna elagpita pasashgannogmi nogapis elagpita cutimushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tsay junäga wayinpita wagtacho caycagcuna ama wayinman yaycutsuntsu imancunata jorgunanpagpis. Tsaynogla chacracho caycagcunapis wayinman ama cutitsuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cuidädu Lotpa warmin Diosta mana cäsucog cashgannog gamcunapis canquiman. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tayta Diosta cäsucunanpa trucan quiquin munashgannog cawacuyta munagcunaga manami pipis gloriaman chayangatsu. Tayta Dios munashgannog cawag cagcunami itsanga gloriaman chayar imayyagpis cawapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Cutimunä junagmi juc cämalacho ishcag punuycagpita chasquicamag cagta apacushag y mana chasquicamag cagtanami cacharishag. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Maraycho ishcay warmicuna agacuycagpita chasquicamag cagta pushacushag y mana chasquicamag cagtanami cacharishag. ");
INSERT INTO qvmNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chacracho ishcay runacuna aruycagpita nogaman yäracamag cagtami apacushag y mana yäracamag cagtanami cacharishag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsauraga tsayta mayaycur discïpuluncuna tapupäcorgan caynog nir: “Tsaynog shuntashgayqui höra nogacuna ¿maychötag capäcushag, tayta? ¿Gamwancu o manacu?” Tsaynog tapuptinmi Jesús nergan: “Wisculcuna uywa wanushga caycagman juntacashgannogmi gamcunapis noga cashgä cagcho juntacashga canquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mana ajayaypa Tayta Diosta manacärinanpag discïpuluncunata Jesús yachatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Juc marcachöshi Tayta Diosta ni runacunatapis mana mantsacog juez cargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tsay marcachöshi targan juc viüda warmipis. Payshi tsay juezman aywargan: ‘Quejacushgäta arreglaycalämay, tayta’ nir. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Tsaynog yaparir yaparir aywaptinpis juezga manashi cäsorgantsu. Nircurnashi tsay juez caynog yarpachacorgan: ‘Diosta mana mantsacurpis ni runacunata mana mantsacurpis cay warmipa demandunta jucla arreglashag. Mana arreglaptëga imay hörapis cutiycämongami fastidiamar umäta nanätsinanpag’.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Tsaynog wilaparcurmi Jesús caynog nergan: “Tsay juez fiyu runa caycarpis viüda quejacushganta arreglaycaptenga ¿manatsurag Tayta Diosnintsipis mayanga payman yäracogcuna manacushganta? Manami manacaglapagtsu pagasta junagta Tayta Diosnintsita manacärenga. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Manacog cagtaga Tayta Diosnintsi mana shuyarätsiylapami yanapanga. Tsaynog captinpis cay patsaman noga cutimushpä ¿tarishagtsurag pilapis yäracaycämagta?” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Juc cutichömi ishcay cära runacunata Jesús caynog wilapargan: ");
INSERT INTO qvmNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcay runashi aywargan templuman Diosta manacunanpag. Jucagshi cargan fariseo y jucagnashi cargan impuesto cobrag. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tsayshi fariseo cäga ichircur manacorgan caynog nir: ‘Gracias, Tayta Dios. Gamta agradëcicö waquin runacunanog mana cashgäpitami. Paycunaga capäcun suwa, Diosta mana cäsucog, adulterio jutsata rurag. Tsaynogpis gamta agradëcicö tagay impuesto cobrag runanog mana cashgäpita. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ayunäpis semänacho ishcay cutimi. Tsaynoglami imaypis diezmöta apä templuman.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Impuesto cobrag cagnashi itsanga carulacho ichicuycorgan. Payga jutsasapa carshi ciëluman ricäriylapis ricärergantsu. Tsaypa trucanga pasaypa laquicushpan caynog nergan: ‘Cuyapaycalämay, Tayta Dios. Nogaga jutsasapa runami cä.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tsaymi impuestuta cobrag cäga wayinman cutergan jutsanpita perdonashgana. Fariseo cagtami itsanga Tayta Diosnintsi mana perdonargantsu. Tsaynoglami pipis ishcay cära cagtaga Tayta Diosnintsi mana perdonangatsu. Jutsayog cashganta tantyacog cagtami itsanga perdonangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsaypitanami wamracunata Jesús cagman apapäcorgan umanman maquinta churaycur Tayta Diosta manacunanpag. Wamracunata apaycagta ricarmi discïpuluncuna michargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsaynog michaptinpis wamracunata Jesús gayargan shapäcamunanpag. Nircurnami discïpuluncunata caynog nergan: “Wamracunata apacamunanta ama michäpäcuytsu. Wamranog cagcunami Tayta Diospa naupanman chayangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pipis Tayta Diosnintsipa naupanman chayayta munarga papänin nishganta wamra criyishgannog Tayta Diosnintsi nishganta criyitsun. Wamranog criyegcunalami Tayta Diospa naupanman chayangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juc mandag runami Jesusta caynog nergan: “Gam imaycatapis musyanquimi, tayta. Tsaymi tapuculäshayqui. ¿Imatatag ruräman Tayta Diospa naupanman chayanäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tsauraga Jesús caynog nergan: “¿Imanirtag yarpanqui lapantapis musyashgäta? Tayta Diosnilantsimi lapantapis musyaycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tayta Diosnintsipa naupanman chayanayquipäga mandamientucunata cumpliy. Musyanquimi mandamientucuna caynog nishganta: ‘Adulterio jutsata ama ruranquitsu. Runa mayiquita ama wanutsinquitsu. Ama suwacunquitsu. Manacagtaga ama pitapis tumpanquitsu. Mamayquita y taytayquita ali ricanqui.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Niptin tsay runa nergan: “Tsaycunataga wamra cashgäpita-patsami lapanta cumplishcä, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tsaynog niptin Jesús caynog nergan: “Lapanta cumpliycarpis Tayta Diospa naupanman chayanayquipäga jucragmi pishëshunqui ruranayquipag. Lapan imayquicunatapis ranticuycur guellayta wactsacunata aypuy. Nircur nogawan aywashun yachatsishgäta yachacunayquipag. Tsaynog rurashpayquega gloriaman riquëzayquita churacognogmi caycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tsaynog niptinmi tsay runa laquicorgan pasaypa rïcu cashpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Laquishga caycagta ricar Jesús caynog nergan: “¡Sasami caycan rïcu runacuna Tayta Diospa naupanman chayananpäga! ");
INSERT INTO qvmNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Auja uchcupa camëllo päsayta mana camäpacushgannog rïcu runapis quiquilanpitaga Tayta Diospa naupanman chayayta manami camäpacuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tsaynog niptinmi mayagcuna Jesusta tapupäcorgan: “Tsaynog captenga ¿pirag salvaconga?” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Niptin Jesús caynog nergan: “Quiquilanpitaga runacuna manami salvacuyta camäpacuntsu. Tayta Dioslami pitapis salvan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsauraga Pedro caynog nergan: “Nogacunaga lapantami imaycätapis cacharishcä gamwan purinäpag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Tsaynog niptin Jesús nergan: “Tayta Diosnintsipa wilacuyninta wilacunayqui cashga wauguiquicunata, paniquicunata, mamayquita, taytayquita, tsuriquicunata, wayiquita y chacrayquicunatapis cacharerga cay patsacho pachac (100) cuti mastami chasquinquipag. Tsaynogpami paniquipis, wauguiquipis, mamayquipis, taytayquipis, chacrayquicunapis y wayiquicunapis gampa canga. Itsanga wilacuynëta wilacushgayquipita runacuna chiquishunquipagmi. Tsaynog captinpis Tayta Diospa naupanman chayar imayyagpis cushishgami cawanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tsaypitami chunca ishcay (12) acrashgan cag discïpuluncunata gayaycur Jesús caynog nergan: “Musyapäcunquimi Jerusalenpa aywaycashgantsita. Jerusalenman chayaptintsimi Tayta Diosnintsipa profëtancuna escribishgannogla lapanpis nogata pasamanga. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tsaymi wanutsimänanpag mana Israel runacunapa maquinman autoridäcuna entregapäcamanga. Paycunami asipämanga, ashlimanga y togapämanga. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tsaynogpis astarcamar wanutsimanga. Tsaynog captinpis quimsa junagtaga cawarimushagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tsaynog niptin discïpuluncunaga manami tantyapäcorgantsu imapita parlaycashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tsaypita Jericó marcaman Jesús yaycuycaptinna caminucho jamaraycargan juc gapra runa caridäta manacur. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tsauraga atsca runacuna aywarcaycagta mayashpanmi tsay gapra runa tapucorgan pï pasaycashgantapis musyananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tapucuptinmi wilapäcorgan caynog nir: “Nazaretpita cag Jesusmi pasaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wilaycuptinmi gayacorgan caynog nir: “¡Rey Davidpa castan Jesús, cuyapaycalämay!” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tsaymi puntanta aywaycagcunaga tsay gaprata olgöpargan upälacunanpag. Tsaynog olgöpaptinpis masragmi gayacorgan: “¡Rey Davidpa castan Jesús, cuyapaycalämay, ari!” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tsaynog gayacushganta mayarmi Jesusga ichicuycushpan gayatsimorgan. Naupanman chayaycatsiptinna caynog taporgan: ");
INSERT INTO qvmNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Imacho yanapanätatag munaycanqui?” Gapranami caynog nergan: “¡Nawëta aliyaycatsilämay, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Niptin Jesús caynog nergan: “¡Ricayna! Yäracamashgayquipitami canan nawiqui aliyashgana caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tsauraga jinan hörami gaprapa nawin aliyargan. Aliyarcuptinnami Jesuspa guepanpa aywargan Tayta Diosnintsita alabaraycar. Tsayta ricaycur lapan runacuna Tayta Diosnintsita alabapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Jericó marcachömi targan Zaqueo jutiyog rïcu runa. Paymi cargan impuesto cobragcunapa mandagnin. Tsauraga Jericó marcapa atsca runacunawan Jesús pasaptinmi tacshala car ricayta mana puëdergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsaymi Jesús pasaycagta ricananpag cörrila aywar Zaqueo witsargan sicómoro yöraman. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tsaypa pasaycashgancho Zaqueuta ricärir Jesús caynog nergan: “Zaqueo, jucla urämuy. Wayiquimanmi aywaycä posädatsimänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tsauraga Zaqueo jucla urarcur Jesusta cushishga pushargan wayinman. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tsayta ricaycur lapan runacuna Jesusta jamurpargan caynog nir: “¿Imanirtag jutsasapa runapa wayinman aywaycan posädacunanpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wayinchöna caycarmi Jesusta Zaqueo caynog nergan: “Tsararashgäpita pulantami imätapis wactsacunata raquipaycushag, tayta. Tsaynog pipa imantapis guechushgäpita chuscu cuti mastami cutitsishag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tsaynog niptin Jesús nergan: “Cananga salvashganami caycanqui gampis y wayiquicho tagcunapis. Abraham yäracushgannogmi gampis Tayta Diosnintsiman yäracuycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jutsasapa runacunata salvanäpagmi Tayta Diosnintsi nogata cachamashga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalenman Jesús aywaycaptinnami runacuna yarpapäcorgan tsayman chayaycuptin jucla rey cananpag payta churananpag cashganta. Tsaynog mana cananpag cashganta tantyatsinanpagmi Jesús quiquin tincutsicorgan rïcu runaman caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Juc rïcu runashi aywargan juc lädu nacionman mandag cayta chasquimunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manarag aywarshi gayatsergan chunca (10) ashmaynincunata. Nircur jucninta jucnintapis ayporgan atsca guellayta caynog nir: ‘Cutimunäyag cay guellaywan arurcaycanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tsaynog nir aywacuptin marca mayincuna payta chiquishpan guepanta runacunata cachargan caynog nipäcunanpag: ‘Manami tsay runata mandagnë rey cananpag munapäcötsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tsaynog marca mayincuna mana munaycaptinpis mandag cayta chasquergan. Tsaypita marcanman cutiycurnashi gayatsergan guellaynin tsararag ashmaynincunata guellaynin aycata wachashgantapis musyananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tsayshi puntata shamog cag caynog nergan: ‘Guellayniqui mirashga chunca (10) cuti mastami, tayta.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tsauraga mandagnin nergan: ‘¡Ali ashmaymi gam canqui! Walcalapitapis shumag guellayta miratsishgayquipitami chunca (10) marcapa mandagnin canayquipag churashayqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jucagpis shamur caynog nergan: ‘Guellayniqui mirashga pitsga cuti mastami, tayta.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Paytapis nergan: ‘Pitsga marcapa mandagnin canayquipagmi gamta churashayqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tsaynogpis jucag ashmaynin shamur caynog nergan: ‘Caycho caycan guellayniqui, tayta. Pañuëluwan guepircurmi churaycorgä. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gamga shuntanqui mana churashgayquipita y cosechanqui mana murushgayquipitami. Tsaynog fiyu cashgayquita musyarmi churaycorgä.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Tsayshi patronnin caynog nergan: ‘¡Gamga mana yäracuypag ashmaymi canqui! Quiquiquipa shimilayquipitami juzgashayqui. Fiyu cashgäta musyaycar, mana churaycar shuntashgäta musyaycar y mana muruycar cosechashgätapis musyaycarga ¿imanirtag banculaman mana churargayquitsu mirashgatana cutimur shuntacunäpag?’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tsayshi nergan tsaycho caycag runacunata: ‘¡Shuntapäcuy tsararaycashgan guellaynëta! ¡Nircur goycuy chunca (10) cuti más guellay miratseg cagta!’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tsaynog niptinshi nipäcorgan: ‘Payga maynami tsararaycan chunca (10) cuti masta, tayta.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nipäcuptinshi patronnin caynog nergan: ‘Guellayta camaripashgäta miratsegcunaga mastami chasquenga. Mana miratsegcunami itsanga tsararashgalantapis guechushga canga. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mandagnin canäta mana munar chiquimagnëcunataga ¡cayman apaycamur wanutsipäcuy noga ricaycaptë!’ ” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tsaynog wilaparcurmi Jerusalenpa Jesús aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olivos lömacho cag Betania y Betfagé nishgan marcacunaman chayaycarna ishcay discïpuluncunata puntata cachargan caynog nishpan: ");
INSERT INTO qvmNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Aywapäcuy Betfagé marcaman. Chayarnami taripäcunquipag pipis manarag muntacushgan manta bürru wataraycagta. Tsayta pascarir apamunqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tsaycho pipis: ‘Bürröta ¿imapagtag pascaycanqui?’ nishuptiquega: ‘Jesusmi munaycan muntacunanpag’ nipäcunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tsaynog cachaptinmi discïpuluncuna aywar taripäcorgan Jesús nishgannogla. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tsaypita bürruta pascarcaycaptinmi ämun caynog taporgan: “¿Imapagtag bürröta pascaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tsaynog niptinmi nipäcorgan: “Jesusmi munaycan muntacunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tsaymi bürruta janchacurcur Jesús caycashgan cagman cutipäcorgan. Tsaychönami punchuncunata carunarcur tsaripargan Jesús muntacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Muntashga aywaptinnami runacuna cushicushpan jacuncunata y punchuncunata aywaycashgan caminuman mashtapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tsauraga Olivos lömapa urarcaycaptinnami gatiragnincuna cushicur Diosta alabapäcorgan lapan milagrucunata ricashganpita caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“¡Tayta Diosnintsi cachamushgan mandamagnintsi rey caychönami caycan! ¡Tayta Diosnintsi imayyagpis alabashga cayculätsun!” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsauraga tsaycho caycag fariseucuna runacunapa chaupinpita caynog nergan: “Olgöpay gatiräshogniquicuna upälacärinanpag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tsaynog nipäcuptinmi Jesús caynog nergan: “Paycuna upälacäriptenga rumicunapis Tayta Diosnintsita alabangami.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tsaypitami Jerusalén marcata ricärir tsaycho tag runacunapag Jesús wagargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ali cawayta apamushgäta canan junaglapis tantyarga alimi cawapäcunquiman. Tsaynog caycaptinpis manami tantyapäcunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tsaymi gamcunapag chämonga nacanayquipag cag junagcuna. Chiquishogniquicuna jiruruypa tsapäshuptiquega manami maypapis gueshpinquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tsaypita marcaman yaycur atacashushpayqui wamrantintami wanutsishunquipag. Wayiquicunatapis chipyagmi juchutsir ushangapag. Manami ni juc rumilapis pergaraycar quëdangapagtsu. Tsaynogmi canga Tayta Diosnintsi salvashunayquipag shamushganta mana cäsucushgayquipita.” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalenman Jesús chayaycurnami templo patiuman yaycuycur tsaycho ranticuycagcunata gargorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gargurmi paycunata caynog nergan: “Tayta Diosnintsipa palabranchöga caynogmi escribiraycan: ‘Templöga canga nogata manacamänanpagmi.’ Tsaynog escribiraycaptenga ¿imanirtag gamcuna ticratsishcanqui suwacunapa machayninmannog?” ");
INSERT INTO qvmNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nircurnami templo patiucho waran waran Jesús yachatsergan. Tsaymi mandag cüracuna, Moisés escribishganta yachatsegcuna y autoridäcunapis wilanacärergan Jesusta imanogpapis wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lapan runacuna Jesús yachatsishganta shumag mayaptinmi ima ruraytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tsaypitami Diospa ali wilacuyninta templo patiucho Jesús yachaycätsiptin chayapäcorgan mandag cüracuna, Moisés escribishganta yachatsegcuna y Israel mayor runacunapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Paycunami caynog tapupäcorgan: “Gamga ¿ima munayniquiwantag templo patiucho ranticogcunata gargushcanqui? ¿Pitag nishushcanqui tsaynog gargunayquipag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tsaynog tapuptin Jesús caynog nergan: “Gamcunatapis canan tapushayqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitag Juanta cachamushga bautizananpag? ¿Tayta Diosnintsicu o runacunacu?” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tsauraga quiquinpura caynog wilanacärergan: “Ama nishuntsu Tayta Diosnintsi cachamushganta. ‘Tayta Diosnintsimi cachamushga’ niptintsega: ‘¿Imanirtag mana criyipäcorgayquitsu?’ nimäshunmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tsaynogpis ama nishuntsu runacuna cachamushganta. Tsaynog niptintsega sagmaycälarmi runacuna wanutsimäshun. Lapanmi yarpapäcun Diospa wilacognin Juan cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsaynog wilanacurcurmi paycuna caynog nergan: “Manami musyapäcötsu pï cachamushgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tsaynog nipäcuptinmi Jesús caynog nergan: “Gamcuna mana wilamaptiquega nogapis manami wilashayquitsu pipa munayninwan templo patiupita ranticogcunata gargushgätapis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsaypita Jesús tincutsiypa yachatsergan caynog nir: “Juc runashi juc chacra üvata plantargan. Nircur tsay chacranta arrendacuycur juc lädu marcapa aywacorgan tsaycho tänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tsauraga cosëcha galaycuptinnashi cachargan juc ashmayninta üva chacra arrindunpita cobracamunanpag. Tsay ashmay chayaptinshi pasaypa magarcärir jinaylata gargurergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsaynog jinayla cutiycuptinshi tsay runaga yapay cachargan juc ashmayninta. Tsaytapis ashlircur y magarcurshi jinaylata gargurergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tsaypita yapay cachargan juc ashmayninta. Tsaytapis tsaynogla yawar yawar magarcärishpan jinaylata gargurergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tsauraga chacrayog yarpachacorgan caynog nir: ‘Canan ¿imatatag rurashag? Cachashag juclayla cuyay tsurëta. Paytaga pagta chasquinmanpis.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tsayshi tsay tsurin aywaycagta ricaycur wilanacärergan caynog nir: ‘Tagaymi cay chacrawan quëdangapag. Nogantsina cay chacrawan quëdacunantsipag payta wanuratsishun.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsayshi wilanacushgannogla chayaycuptin üva chacrapita juc läduman jorgurir wanutsipäcorgan. “Tsaynog rurashganpita tsay üva chacrayöga ¿imatarag ruranga tsay chacrata guechuyta munag runacunata? ");
INSERT INTO qvmNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿Manatsurag tsay fiyu runacunata lapanta wanutsenga? Nircurna chacranta juctana arrendacuycongapag.” Tsaynog niptinmi runacuna nipäcorgan: “¡Tayta Diosnintsi cuyapaycalämäshun tsaynog nogantsitapis mana castigamänantsipag!” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tsaymi paycunata ricärir Jesús caynog nergan: “Tsaynog pasashunayquita mana munashpayquega Tayta Diosnintsipa palabrancho caynog escribiraycashganta tantyacäriy: ‘Wayi sharcatsegcuna: “Manami alitsu cay rumi” nir jitariycuptinpis wayi esquïnaman cimientupag tsay rumi churashganami caycan.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipis tsay rumi jananman tuneg cäga ushacangami. Tsaynoglami pipa jananmanpis tsay rumi tunerga pasaypa ushacätsenga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tsaynog niptinmi mandag cüracuna y Moisés escribishganta yachatsegcuna tantyapäcorgan tumatsipaylapa paycunata Jesús tsaynog niycashganta. Tsaymi jinan höra prësu tsaritsiyta munapäcorgan. Tsaynog munarpis manami Jesusta prësu tsaritsergantsu, runacunata mantsacushpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tsaymi autoridäman prësu apatsinan cashga Jesús cagman runacunata cachapäcorgan ali shimilanpa parlapar lutanta rimatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chayaycurmi tsay runacuna Jesusta caynog nergan: “Nogacuna musyapäcömi imata yachatsirpis Tayta Dios munashgannog shumag yachaycätsishgayquita, tayta. Tsaymi yachagtapis mana yachagtapis Diospa wilacuynin nishgannogla yachatsinqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Romacho emperador Cesarpag impuestuta pägashwancu o manacu?” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lutanta rimatsinanpag tapushganta tantyarmi Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mä ricatsimay guellayta.” Guellayta ricatsiptinmi caynog nergan: “Cay guellaycho ¿pï runapa reträtuntag caycan? Tsaynogpis ¿pipa jutintag escribiraycan?” Tsaynog tapuptin nipäcorgan: “Emperador Cesarpami.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tsaymi Jesús nergan: “Emperador Cesarpa cagta Cesarta goycuy. Tayta Diospa cagtaga Tayta Diosnintsita goycuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesús tsaynog niptin imatapis lutanta parlatsiyta mana camäpacushpan tsay runacuna upälacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsaypitami saduceo runacunapis Jesusman aywapäcorgan pay yachatsishganta manacagman churananpag. Tsaymi Jesusta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Moisés escribishgancho caynogmi niycan, tayta: ‘Warmiyog runa tsuriynag wanuptin shulca wauguin cuñädan viüdawan tätsun. Tsaynogpami wamrancuna tsay wanog cag runapa tsurinnogna canga.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tsaynog captenga tapucushayqui, tayta. Juc marcachöshi ganchis wauguicuna cargan. Mayor cagshi juc warmiwan targan. Payshi manarag tsurin captin wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tsauraga shulca cag wauguinnashi targan tsay viüdawan. Paypis tsurin manarag captinshi wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tsaypita más shulcan cagna targan tsay viüdawan. Paypis wanorgan tsurin manarag captinshi. Tsaynogla lapan wauguincuna tsay viüdawan targan. Tsuriynagla lapanpis wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsaypitanashi tsay viüdapis wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wanushcunata Tayta Diosnintsi cawaritsimunan junäga tsay warmilachi ganchis wauguipa warmin canga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tsaynog nipäcuptinmi Jesús caynog nergan: “Tsay warmi manami mayganpapis warminnatsu canga. Cay patsalachömi runacuna warmiyog y warmicuna runayog capäcun. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wanushganpita cawarircamur gloriaman chayaycurmi itsanga majaynaglana cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Angilcuna mana wanog cashgannogmi paycunapis mana wanog cangapag. Tayta Diosnintsipa wamran carmi gloriacho cawananpag cawarimonga. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Wanushcuna cawarimunanpag cashgantaga Moisespis escribishgancho tantyatsimantsimi. Abraham, Isaac y Jacob wanushganpita atsca wata guepataragmi Tayta Diosnintsi rupaycag shiracapita Moisesta caynog nergan: ‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wanogcuna mana cawarimunanpag captenga ¿imanogpatag Abrahampa, Isaacpa y Jacobpa Diosnin canman? Tsaynog caycaptenga ¿imanirtag gamcuna mana criyinquitsu wanogcuna cawarimunanpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tsauraga Moisés escribishganta yachatseg runacuna waquin caynog nipäcorgan: “¡Alitami nishcanqui, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tsaypitanaga manami pipis tapupayta almitergannatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tsaypitanami runacunata Jesús caynog nergan: “¿Imanirtag runacuna nipäcun Cristo Davidnogla mandag rey cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Quiquin Davidpis Salmo librucho caynogmi escribergan: ‘Munaynincho tsararämag mandag reyta Tayta Diosnintsi caynogmi nergan: Jamacamuy derëcha cag naupäman lapan contrayquita vincinäyag.’ ");
INSERT INTO qvmNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tsauraga ¿imanogpatag Cristoga Davidnogla mandag rey canman quiquin Davidpis mandagnin rey cashganta niycaptenga?” ");
INSERT INTO qvmNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lapan runacuna mayaycaptinmi discïpuluncunata Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cuidädu Moisés escribishganta yachatseg runacunanog capäcunquiman. Tayta Dios munashgannog cawaycashganta runacuna yarpänalanpagmi paycunaga puripäcun chaqui puntanyag sotänan jatishga. Tsaynogpis más munapäcun yachatsicog cashganpita pläzacunacho y cällicunachöpis alabashga caylatami. Tsaynogpis sinagogacunacho alinnin cag bancumanrag jamacuytami munapäcun. Micunanpag gayatsiptinpis mësamanragmi jamacuyta munapäcun. ");
INSERT INTO qvmNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tsaynogmi viüdacunapa ima pobrëzalantapis apacärin. Nircurnami alita rurashganta runacuna yarpapäcunanpag may hörarag Tayta Diosta manacärin. Tsaynog rurashganpitami infiernucho más fiyupa nacangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsaypitami templucho Jesús ricaraycargan ofrenda winacunanman rïcucuna winarcaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsaychömi ricargan wactsa viüdatapis ishcayla cobri guellayninta winaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Tsayta ricar discïpuluncunata Jesús nergan: “Rïcu runacunaga winashga putsog guellaynilantami. Viüdami itsanga wactsa caycarpis winashga lapan guellayninta, tsaylawan rantipacunanpag caycaptinpis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nircurmi templo pergarashgan rumicuna cuyaylapag cashganpita y shumag adornashga cashganpitapis discïpulucuna parlarcaycargan. Tsaymi Jesús caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Cay lapan ricaycashgayqui cuyaylapag caycaptinpis chipyagmi juchutsipäcongapag. Manami ni juc rumilapis canan pergaraycashgannöga quëdangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsauraga discïpuluncuna tapupäcorgan caynog nir: “Nishgayquinöga ¿imaytag templo juchutsishga canga, tayta? Tsaynog cananpäga ¿puntata imatag canga?” ");
INSERT INTO qvmNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tsaynog tapuptinmi Jesús caynog nergan: “Pipis lutanta mana criyitsishunayquipag shumag tantyacäriy. Atscagmi shapäcamonga: ‘Cristumi noga cä’ nir. Tsaynogpis nipäcushunquipag: ‘Tiempo chämushganami cay patsa ushacänanpag.’ Tsaynog nishuptiquipis gamcuna ama cäsupanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","May-tsay nacioncunachöpis guërra captin y wanutsinacuy captin ama mantsacärinquitsu. Puntataga tsaycunaragmi pasanga. Tsaynog captinpis templuta manami juchutsengaragtsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Juc nacionmi pelyanga juc nacionwan. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tsaynogmi may-tsaychöpis canga terremöto, fiyupa muchuy y tucuy-nirag gueshyacunapis. Tsaynogpis jana patsacho ricacämonga mantsariypag imaycacunapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tsaycuna manarag captinmi chiquishushpayqui prësu tsaripäcushunquipag. Israel runa mayiquicunapis contrayqui sharcur juzgapäcushunquipag. Tsaynogpis carcilcunaman wichgapäcushunquipag. Nogata chasquicamashgayquipitami apapäcushunquipag nación mandag reycunamanpis juzgashunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tsaynogpami wilacuynëta paycunatapis wilapanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ama yarpachacäriytsu autoridäcunaman apashuptiqui: ‘¿Imatarag cananga parlashag?’ nir. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nogami shumag tantyatsishayqui imata nipäcunayquipagpis. Tsaymi maygan chiquishogniquipis imaniytapis mana camäpacongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gamcunapa contrayquimi sharcapäconga taytayqui, mamayqui, wauguiquicuna, castayquicuna y reguinacushgayquicunapis. Tsaynogpis waquinniquitaga wanutsishunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tsaynoglami nogata chasquicamashgayquipita pï-maypis chiquishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tsaynog captinpis ama laquicäriytsu. Ima pasashuptiquipis Tayta Diosnintsi yanapashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hasta wanunayquiyag Tayta Diosnintsi munashgannog cawarga paypa naupanmanmi chayapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalén ushacänanpagna caycashganta musyapäcunquipag soldäducuna tumaparaycagta ricarmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tsauraga Judea provinciacho caycagcuna aywacäritsun jircacunaman. Marcacho caycagcunapis marcapita gueshpir aywacäritsun. Chacracho caycagcunapis marcaman ama aywatsuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsay junagcunami fiyupa nacaycuna cangapag. Tsaynogpami Tayta Diosnintsipa palabrancho escribiraycashgancuna lapanpis cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tsaynog gueshpirmi pasaypa cuyapaypag nacanga chichu warmicuna y iti wawayog warmicunapis. Tayta Diosnintsi castigaptin runacuna fiyupami laquicärengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquincunatami wanutsipäconga y waquin cagtanami apapäconga caru nacioncunaman. Mana Israel cag runacunami Jerusalenta munaynincho tsararangapag hasta tiempun cumplishganyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Inti, quilla y estrellacunapis mantsariypagmi ricaconga. Cay patsachönami lapan runacuna mantsacuywan turwatanga lamar yacu bunyaypa bunyar fiyupa gaparaptin. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Estrellacuna wacman cayman cuyogta ricarmi runacuna mantsarishpan ilabacäconga. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tsaychömi nogata ricapäcamanga pucutay janancho chip-chipyaycar aywaycämogta. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tsay nishgänogla lapanpis ruracaycagta galaycuptenga cushicärinqui. Musyanquinami nacaycunapita jorgunäpagna caycashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nircur caynogpis tantyatsergan: “Tamya tiempo galaycuptin musyapäcunquimi hïgus yöra y waquin yöracunapis tsintsimunanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tsaynoglami tsay nishgä nacaycuna chämuptin gamcunapis musyanquipag cutimunäpagna caycashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Canan cawaycag runacuna manarag wanuptinmi lapan tsay nishgäcuna cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jana patsa y cay patsa ushacaptinpis noga nishgäcunaga lapanmi cumplengapag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mana musyashgayqui höra elagpita noga cutimur cuidädu gamcunata tarëman jutsata ruraycagta, shincashga caycagta y imaycayogpis canayquipag yarpachacur gongamashga caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jutsata ruragcunaga manami pipis gueshpengatsu juicio finalpita. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tsaynog cananpag caycaptenga Tayta Diosnintsita imaypis manacur listula carcaycay. Tsaynogpami shamunanpag cag nacaycunapita gueshpir nogapa naupächo cushishgala cawanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Templucho Jesús junagpa yacharcatsir tsacaypana Olivos lömaman aywargan tsaycho posädacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsaymi tutala cutiptin templuman runacuna aywapäcog yachatsishganta mayananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Pascua aniversario chaycämuptinmi tsaytsica runacuna Jerusalencho juntacargan. Jesuswan atsca runacuna tutapita-patsa captinmi mandag cüracuna y Moisés escribishganta yachatsegcuna Jesusta prësu tsariyta mantsacärergan. Tsaymi wilanacärergan walcala runa cashgan höra Jesusta prësu tsariycatsir wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsaynog yarparcaycaptinmi Satanás yaycorgan Judas Iscariotipa shongunman. Judaspis Jesuspa apostolninmi cargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paymi mandag cüracunaman y templo täpag wardiacunapa mandagnincunaman aywaycur caynog nergan: “Jesusta prësu tsariyta munaptiquega cutimur wilashayqui runacuna mana cashgancho Jesús imay caycashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tsaynog niptinmi cushicärishpan parlapäcorgan Judasta pägananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsaynog wilanacurcurmi Judas yarpachacorgan imay höra wilacog cutinanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Levadüraynag Tantata Micunan aniversario y Pascua aniversariupis galaycunan junagmi Israel runacuna templucho carnishta pishtapäcog. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tsaymi Jesús cachargan Pedruta y Juanta caynog nishpan: “Pascua cënayta micunantsipag camaricamuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tsauraga paycuna taporgan: “¿Maychötag camaripäcamushag, tayta?” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tsaynog niptinmi Jesús caynog nergan: “Marcaman chayarnami tincupäcunquipag juc runa puynuwan yacuta apaycagwan. Tsay runapa guepalanpa aywapäcunqui hasta may wayimanpis chayananyag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tsaychömi wayiyogta caynog nipäcunqui: ‘¿Mayninchöshi cuarto caycan discïpuluncunawan Pascua cënayta Jesús micunanpag?’ ");
INSERT INTO qvmNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tsaynog niptiquimi pay ricatsishunquipag altuscho pitsapacushga jatun cuartuta. Tsay cuartucho cënayta camaricärinqui micunantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tsaymi paycuna aywar taripäcorgan Jesús nishgannogla. Tsaychömi camaripäcorgan Pascua cënayta. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tsauraga cënay höra chayaptinnami apostolnincunawan Jesús jamacorgan micapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tsaychömi Jesús caynog nergan: “Pascua aniversario cënayta gamcunawan micur cushicömi. Manarag wanurmi gamcunawan cay cënayta micuyta munargä. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mananami cay cënayta micushagnatsu Tayta Diosnintsipa naupancho micunantsiyag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tsaynog nircushpanmi vïnuyog väsuta aptarcushpan Tayta Diosta manacur agradëcicorgan. Nircur apostolnincunata macyashpanmi caynog nergan: “Caypita lapayqui upupäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yapayga manami vïnuta upushagnatsu Tayta Diospa naupancho upunantsiyag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsaynogpis tantata aptarcur Tayta Diosta manacur agradëcicorgan. Nircurnami paycunata paquipargan caynog nishpan: “Cay tantaga cuerpömi caycan. Cay tantata micur imaypis yarpapäcunqui gamcuna-raycu wanushgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tsaynoglami cënayta usharcur vïnuyog väsuta aptarcur caynog nergan: “Cay vïnuta upur tantyacäriy yawarnëta jichar gamcuna-raycu wanushgäta. Tsaynog wanuptëmi Tayta Diosnintsi mushog conträtuta ruranga chasquicamagcunata perdonananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Conträman entregamänanpag cag runapis nogantsiwanmi cay mësacho caycan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tayta Diospa palabrancho escribiraycashgannogla fiyupa nacar wanunäpagmi caycä. Nogata entregamag runami itsanga juicio final junag pasaypa laquicongapag. Payga ama yurinmanpistsu cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tsaynog niptinmi jucnin jucninpis apostolnincuna tapunacärergan: “¿Maygantsirag tsay entregag caycantsi?” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsaypitami mandag cayta guechunacur apostolcuna rimanacuycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tsaynog rimanacuptinmi Jesús caynog nergan: “Nación mandag reycuna mandag cayninman atiënicuycurmi runacunata mandan. Tsaynog mandaptinpis: ‘Ali runami payga’ nipäcun. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gamcunaga manami tsaynog canquimantsu. Tsaypa trucanga waquin runacunapita más ali ricashga cayta munarga runa mayiquita ashmaynogla yanapay. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Musyapäcunquimi mësacho patrón micuptin ashmaynincuna sirvishganta. Nogaga ashmaynoglami gamcunapag caycä. Tsaymi gamcunapis ashmaynogla canquiman. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ima nacaycho captëpis gamcuna nogawanmi imaypis cashcanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tsaymi gamcunata churashayqui mandag canayquipag, Taytä nogata mandag canäpag churamashgannog. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tsaymi mandashgä cagcho gamcuna nogawan micunquipag y upunquipag. Tsaynogpis lapan runacunata juzgaptëmi gamcunapis cada ünuyqui juc trönucho jamanquipag chunca ishcay (12) castapita mirag Israel mayintsicunata juzganayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tsaypitami Jesús caynog nergan: “Simón, Satanasmi Tayta Diosnintsita manacushga gamcuna lapayqui cacharimänayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tsaynog captinpis gampag Tayta Diosta manacushcä Satanás munashganta ruratsishuptiquipis Tayta Diosnintsiman yapay shumag yäracunayquipag. Yapay yäracurnami apóstol mayiquicunata shacyätsinqui paycunapis nogaman shumag yäracamänanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tsaynog niptinmi Pedro caynog nergan: “Carcilman apashuptiquipis gamwanmi aywashag, tayta. Gamta wanutsishushpayquega nogatapis wanutsimätsun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tsauraga Jesús caynog nergan: “Pedro, canan tsacay gällu manarag cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsaypita apostolnincunata Jesús taporgan: “Guellayniynagta, jacuynagta y llanquiynagta wilacärinayquipag cachaptë ¿imalapis pishëshorgayquicu?” Tsauraga paycuna nipäcorgan: “Manami imapis pishëmargantsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Tsaynog niptinmi Jesús nergan: “Tayta Diosnintsipa palabrancho caynog nirmi escribiraycan: ‘Jutsasapa runatanogpis runacuna payta ricashga.’ Tsay escribiraycashganga nogapitami niycan. Cananpitaga wilacog aywar jacuyquitapis guellayniquitapis apanqui. Espädayqui mana captenga punchuyquita ranticuycur espädata rantipäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tsauraga discïpuluncuna nipäcorgan: “Caycho caycan ishcay espädacuna, tayta.” Niptin Jesús nergan: “¡Imata niycashgätapis manami tantyamanquitsu!” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsaypitami Jesús aywargan cadala aywashgannog Olivos lömaman discïpuluncunawan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tsayman chayaycurnami discïpuluncunata caynog nergan: “Punushgayquipita ricchayna. Diosta manacäriy Satanasta mana cäsupänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsaynog nircushpan más washa läduman aywargan Tayta Diosta manacunanpag. Tsaychönami gongurpacuycur Tayta Diosta manacorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Papá, nacanäpag caycashgäpita salvaycalämay. Itsanga noga munashgänöga ama catsuntsu, sinöga gam munashgayquinog cayculätsun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsaynog laquicur manacuycaptinmi juc ángil yuriparcur shacyätsergan nacananpag captinpis mana mantsacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsaynog pasaypa laquicur Jesús lapan shongunwan Tayta Diosta manacuycaptinmi südayninpis yawarnograg pampaman jutorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tayta Diosta tsaynog manacushganpita discïpuluncuna cagman cutiycur Jesús tarergan laquicuypita punucashga carcaycagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsauraga Jesús caynog nergan: “¿Imanirtag punurcaycanqui? Sharcurcur Tayta Diosta manacäriy Satanasta mana cäsupänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tsaynog parlaycaptinragmi Judas Iscariote chayargan atsca runacunata pushashga. Judasga Jesuspa discïpulunmi cargan. Nircurnami Jesusman witiycur payta mutsargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tsauraga Jesús caynog nergan: “Judas, conträman entregamänayquipag ¿imanirtag nogata mutsamanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tsaymi Jesusta prësu apacunanpag cashganta tantyashpan discïpuluncuna caynog taporgan: “Tayta, ¿wanutsipäcushagcu paycunata?” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsaynog nir juc discïpulun más mandag cürapa ashmayninpa derëcha cag rinrinta espädanwan roguriycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tsaymi Jesús nergan: “¡Tsaytaga ama ruraytsu!” Nircur tsay ashmaypa rinrinta yataycur aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesusta prësu apananpag shamogcuna cargan mandag cüracuna, templo täpag wardiacunapa mandagnincuna y Israel mayor runacunapis. Paycunatami Jesús caynog nergan: “¿Imanirtag suwa captënogpis gamcuna shamushcanqui espädayquiwan y garrotiquiwanpis prësu tsarimänayquipag? ");
INSERT INTO qvmNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nogaga waran waranmi gamcunawan templo patiucho caycargä. ¿Imanirtag tsaychöga prësu mana tsarimargayquitsu? ¿Imanirtag Satanaspa munayninta rurar prësu tsarimänayquipag cananrag shapäcamunqui?” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsauraga Jesusta prësu tsarircur apapäcorgan más mandag cürapa wayinman. Payta prësu apacuptinmi Pedro caru guepalanta aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tsaymi sawan rurincho ninata ratarcatsir runacuna mashacuycargan. Tsayman yaycurirmi Pedrupis paycunawan mashacuycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tsaymi juc ashmay warmi, Pedro mashacuycagta ricaycur caynog nergan: “Cay runapis Jesuswanmi purergan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tsayta mayaycurmi Pedro nergan: “Nogaga payta manami reguëtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Maylantanami juc runapis payta ricaycur nergan: “Gampis paywan puregmi caycanqui.” Niptinmi Pedro nergan: “Nogaga manami paywan imaypis purishcätsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsaypita juc höratanog jucna nergan: “Rasunpami cay runaga paywan caycargan. Galilea runami canpis.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tsaynog niptinmi Pedro nergan: “¡Manami musyätsu imapita parlaycashgayquitapis!” Pedro tsaynog niycaptinmi gällu cantarcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tsauraga Jesús ticraycur ricäriptinmi Pedro yarparcorgan Jesús caynog nishganta: “Manarag gällu cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsaymi Pedro wagtaman yargurir pasaypa laquicushpan maquinta chogpacurcur wagargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tsaypitanami prësu tsararag runacuna asipashpan Jesusta magapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nawinta vendarcur lagyapäcorgan caynog nir: “¡Mä nimay! ¡Pitag lagyashushcanqui!” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tsaynog nir tucuyta ashlipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Patsa wararcuptinnami Israel mayor runacuna, mandag cüracuna y Moisés escribishganta yachatsegcunapis juntacargan. Tsayman apaycurmi Jesusta tapupäcorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","“Mä wilapäcamay. ¿Rasunpacu Tayta Diosnintsi cachamushgan Cristo caycanqui?” Tsauraga Jesús caynog nergan: “ ‘Cristumi caycä’ niptëpis ni imanogpa tantyatsiptëpis gamcunaga manami criyipäcamanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cananpitaga noga caycäshag munayniyog Tayta Diosnintsipa derëcha cag naupanchömi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsaypita lapan autoridäcuna tapupäcorgan: “Tsauraga ¿Diospa tsurincu caycanqui?” Tsaynog niptinmi Jesús nergan: “Gamcuna nishgayquinoglami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tsauraga paycuna nipäcorgan: “Quiquinpis Diospa tsurin caycashganta niycämaptintsega ¿imapagnatag más testïgutapis ashishun? Tsaynog Dios-tucushganta niycämaptintsega ¡wanutsishga catsun!” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsaypitana Jesusta apapäcorgan Pilato cagman. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tsaychönami Pilätuta caynog nipäcorgan: “¡Cay runataga taripäcushcä lutancunata yachaycätsegtami! Manami munantsu impuestuta runacuna pägananta. Tsaynogpis niycan Tayta Dios cachamushgan Cristo car nogacunapa mandagnë cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsaymi Jesusta Pilato taporgan: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” Tsauraga Jesús caynog nergan: “Gam nishgayquinoglami rasunpa caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsauraga Pilato nergan mandag cüracunata y tsaycho juntaraycag runacunatapis: “Manami ima jutsantapis tarëtsu cay runapataga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tsaynog niptin paycunaga masrag nipäcorgan: “¡Mandamagnintsi emperadorpa contran sharcapäcunanpag shimita jatiparmi jutsayog caycan! Galilea provinciachöpis cay Judea provinciachöpis tsaynoglami shimita jatipaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tsayta mayar Pilato caynog taporgan: “¿Galileapitacu cay runaga?” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Au, payga Galileapitami” nipäcorgan. Tsaymi Galilea provinciapa gobernadornin Herodes captin Jesusta payman apatsergan juzgananpag. Tsay junagcuna Jerusalenchömi Herodes caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesuspita parlashganta mayashpanmi naupapita-patsa Herodes ricayta munargan milagruta ruraycagta. Tsaymi Jesusta ricaycur cushicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tsaycho yaparir yaparir Herodes tapuptinpis Jesús manami imatapis rimacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tsaychömi mandag cüracuna y Moisés escribishganta yachatsegcunapis Jesuspa contran tucuyta nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tsauraga soldäduncunawan Herodes asipänan cashga Jesusta aylupargan Herodispa cäpanta. Nircurnami cutitsergan Pilato cagman. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tsay junagpitanami Herodiswan Pilato amistargan naupata contra contra ricanacushganpita. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesusta cutitsiptinnami Pilato gayatsergan mandag cüracunata, autoridäcunata y waquin runacunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tsaycho juntacashga caycaptinnami caynog nergan: “Gamcuna cay runata apapäcamushcanqui: ‘Mandamagnintsi emperadorpa contranmi sharcuycan’ nipäcushpayqui. Tsaynog niptiquipis naupayquicho tapur manami ima jutsantapis tarishcätsu contran nipäcushgayquinöga. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tsaynogmi Herodispis mana tarishgatsu ima jutsantapis. Tsaynog captenga cay runa manami ima jutsatapis rurashgatsu wanutsishga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tsaymi payta astarcatsilar cacharishag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cada watami Pascua aniversariucho Pilato cachareg juc prësuta runacuna manacushgan cagta. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tsauraga Jesusta cachariyta munaptin lapan gaparpargan: “¡Wanutsiy paytaga! ¡Barrabasta itsanga cachariy!” nir. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabasga carcilcho wichgaraycargan mandag emperadorpa contran Jerusalencho sharcushganpita y runata wanutsishganpitami.) ");
INSERT INTO qvmNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tsaymi Pilato yapay runacunata nergan Jesusta cacharinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Niptinpis masragmi gaparpargan: “¡Crucificashga catsun! ¡Crucificashga catsun!” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tsauraga Pilato yapay caynog nergan: “Crucificashga cananpäga ¿ima jutsatatag rurashga? Manami tarëtsu ima jutsantapis wanutsishga cananpäga. Astarcatsilarmi cacharishag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","25","Tsaynog niptinpis runacuna masrag gaparpargan crucificatsinanpag. Tsauraga runacuna manacushgannogla Jesusta Pilato entregaycorgan crucificashga cananpag. Tsaynogpis runacuna manacushgannoglami Barrabasta cacharergan mandag emperadorpa contran sharcushga caycaptinpis y runata wanutsishga caycaptinpis. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tsaypita Jesusta crucificananpag aparcaycaptinmi marcaman yaycuycargan Cirene marcacho tag Simón. Tsauraga Jesús apaycashgan cruzta paytanami umrutsergan Jesuspa guepanpa apananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Atsca runacunami Jesuspa guepanta aywapäcorgan. Tsaychömi atsca warmicunapis laquicushpan wagaraycar aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tsaymi wagaycag warmicunata Jesús caynog nergan: “Jerusalén warmicuna, ama nogapäga wagapäcuytsu. Tsaypa trucanga wawayquicuna y quiquiquicunapis nacanayquipag cashganpita wagapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Fiyupa nacaycunami chämongapag. Tsaymi laquicuypita runacuna caynog nipäconga: ‘¡Ima cushishgarag caycan wawaynag warmicuna!’ ");
INSERT INTO qvmNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tsaychömi runacuna pasaypa mantsarishpan jircacunatapis: ‘¡Janäcunaman juchumuy jucla wanunäpag!’ nenga. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nogatapis caynog nacaycätsimarga ¡ima fiyuparag gamcunata y waquin Israel runacunatapis nacatsishunquipag!” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Crucificananpag Jesusta apar ishcay jutsasapa runacunatapis apapäcorgan Jesuspa naupanman crucificananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calavëra nishgan lömaman chayaycatsirmi Jesusta crucificargan. Apashgan jutsasapa runacunatapis crucificargan jucnin cagta Jesuspa derëchan cagman y jucagtana itsognin cagman. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tsay hörami Jesús caynog nergan: “Taytalä, cay crucificamag runacunata perdonayculay. Manami musyapäcuntsu imata ruraycashgantapis.” Soldäducunanami Jesuspa röpanpag suertita jitapäcorgan mayganpis gänag cag apacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tsaycho runacuna ricarpaycaptin autoridäcuna Jesusta asipargan caynog nir: “Tayta Dios cachamushgan Cristo carga jucta salvashgannogla mä quiquin salvacutsun.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tsaynoglami soldäducunapis asipashpan Jesusta shogutsergan pochgog vïnuta caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Israel runacunapa mandagnin rey cashpayquega mä quiquiqui salvacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cruzpa puntanchömi clävaraycargan caynog escribishga: “Cay runaga Israel runacunapa mandagnin reymi” nishpan. Tsayga escribiraycargan griego, latín y hebreo idiömacunachömi. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tsaypitana jucag crucificaraycag runa Jesusta manacagman churar caynog nergan: “Tayta Dios cachamushgan Cristo cashpayquega mä tsaypita salvacuy. Nircur nogacunatapis caypita jorgapäcamay.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tsaynog niptinmi jucnin cag olgöpargan caynog nir: “Gampis paynog nacaycarga ¿manacu Tayta Diosta mantsacunqui? ");
INSERT INTO qvmNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nogantsega jutsantsicunapitami nacaycantsi. Paypaga manami ima jutsanpis cantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nircur Jesusta caynog nergan: “Mandag canayquipag cutimushpayquega nogata yarparcalämanqui, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Niptinmi Jesús caynog nergan: “Cananpitaga nogawanmi canquipag Taytäpa naupancho.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Pulan junag caycaptinmi patsa tsacäcorgan malway intiyag. Tsay hörami templo rurincho cag cuartuman pipis mana yaycunanpag tsaparag cortïnapis janapita uraypa rachicäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tsaypitami Jesús fuertipa caynog nergan: “¡Taytalä! ¡Maquiquimanmi almäta cachaycö!” Tsaynog nircushpannami wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tsauraga tsaycunata ricaycurmi soldäducunapa capitannin: “¡Rasunpami cay runaga jutsaynag cashga!” nir Tayta Diosnintsita alabargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tsaycho caycag runacunapis aywacärergan fiyupa laquishgami. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuswan reguinacogcunami itsanga carulapita ricarpaycar tsaycho quëdacärergan. Tsaynoglami Galileapita-patsa gatirag warmicunapis tsaycho quëdacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juc runami cargan Dios munashgannog cawag, José jutiyog. Paymi shuyaraycargan Tayta Diosnintsi promitishgannog lapan runacuna Cristupa maquincho cawananpag cashganta. Tsay runapa marcan cargan Judea provinciacho cag Arimatea. Paypis cargan Israel runacunapa autoridäninmi. Waquin autoridäcuna Jesusta wanutsinanpag wilanacäriptinpis payga manami munargantsu wanutsinanta. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Paymi Pilätuta manacorgan caynog nir: “Jesuspa ayanta cachapaycalämay pampag apanäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato auniptinmi Jesuspa ayanta cruzpita jorgurishpan lïnupita rurashga fïnu säbanaswan pitorgan. Nircur pampag apargan manarag pipis pampacushgan gagacho uchcushga sepultüraman. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tsaynog rurargan sábado jamay junag galaycunanpagna caycaptinmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Jesuswan shamog warmicuna Josëta gatipargan Jesuspa sepultüran maycho cashgantapis musyapäcunanpag. Tsaycho ricapäcorgan Jesuspa ayanta imanog churashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsaypita wayinman cutiycärishpan camaricärergan ali asyag perfümita Jesuspa ayanman winapänanpag. Camaricurcurnami Tayta Diosnintsipa palabrancho nishgannog jamapäcorgan sábado jamay junag captin. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tsaypita domingo tsaca tsacala warmicuna cutipäcorgan Jesús pamparashgan cagman, camaricushgan ali asyag perfümita apacurcur ayanman winapänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chayapäcunanpäga pamparashgan uchcuta tsaparag rumi juc läduman wititsishgana caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsayman yaycushpan manami taripäcorgannatsu Jesuspa ayanta. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tsaymi mantsacashga car ima ruraytapis mana camäpacorgantsu. Tsaynog caycaptinmi ishcay runacuna chip-chipyaycag röpashga paycunapa naupancho ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Paycunata ricaycur fiyupa mantsacashpanmi gongurpacuycorgan. Tsay runacunanami caynog nipäcorgan: “¿Imanirtag wanushcuna cashgan cagcho gamcuna ashiycanqui cawarimushgana caycaptenga? ");
INSERT INTO qvmNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Manami caychönatsu caycan. ¡Payga cawarimushganami! Yarpapäcuy Galilea provinciacho caycashpan jutsasapa runacunapa maquinman entregashga cananpag cashganta nipäcushushgayquita. ¿Manacu tsaycho nipäcushushcanqui crucificaypa wanurcatsiptinpis quimsa junagta cawarimunanpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsaynog niptinmi paycuna yarparcorgan Jesús tsaynog nishganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsaymi Jesús pamparashgan cagpita cutiycärishpan lapan ricashgancunata y mayashgancunatapis wilargan chunca juc (11) apostolnincunata y tsaycho cag runacunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tsay warmicunaga cargan María Magdalena, Juana, Santiagupa maman María y paycunawan aywag warmicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Warmicuna tsaynog wilaptinpis apostolcuna manami criyipäcorgantsu, löcutaycashganta yarpar. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Waquin cag mana criyiptinpis Pedrumi itsanga cörrila aywargan Jesusta pampashgan cagman. Pamparashgan cagta arcaycurmi säbanaslatana tarergan. Tsaylatana tariycurmi mantsacashga cuticorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tsay junagmi Jesuspa ishcay discïpuluncuna aywaycargan Emaús marcapa. Emaús cargan Jerusalenpita ishcay lëwanoglami. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Paycunaga aywaycargan Jesús wanushganpita parlaraycarmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tsaynog parlaraycar aywaycaptinmi Jesús taripaycur paycunawan iwal aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Paycunawan aywaycaptinpis manami tantyapäcorgantsu Jesús cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsaymi Jesús caynog nir taporgan: “¿Imata parlartag aywarcaycanqui?” Tsaynog niptin laquishga aywaycashgancho ichiycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsauraga Cleofas jutiyog runa caynog nergan: “Pascua aniversariuman shamog runacunapis lapanmi musyapäcun cay junagcuna Jerusalencho ima pasashgantapis. ¿Manacu gam musyanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niptinmi Jesús caynog taporgan: “¿Imatag cashgaga?” Tsaynog tapuptin nipäcorgan: “Nazaret marcapita cag Jesusmi cargan Tayta Diosnintsipa profëtan. Paymi Tayta Diosnintsipa munayninwan milagrucunata rurashpan lapan runacunata wilapargan Diospa wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytami mandag cüracuna y lapan autoridäcuna Pilätuman entregapäcushga crucificaypa wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nogacuna yarpapäcorgä Roma runacunapa munayninpita pay jorgamänantsipag cashganta. Canan junagwanga quimsa junagnami Jesús wanushgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Canan tuta nogacunawan cag waquin warmicuna mantsatsipäcamashga. Paycunami Jesusta pampashgan cagman tsaca tsacala aywar ayanta mana taripäcushgatsu. Tsaypita wayiman cutiycamur wilapäcamashga Jesusta mana tarishganta. Angilcuna yuriparcurshi wilashga Jesús cawarimushganta. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tsauraga waquin cag discïpuluncunapis pamparashgan cagman aywar warmicuna wilashgannoglami Jesuspa ayanta mana taripäcushgatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Tsaymi paycunata Jesús nergan: “Tayta Dios cachamushgan Cristo wanushganpita cawarimur paypa naupanman cutinanpäga nacananragmi cargan. ¿Imanirtag gamcunaga mana tantyapäcunquitsu? ¿Imanirtag sasatarag criyipäcunqui Tayta Diosnintsipa profëtancuna nishgancunatapis?” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsaynog nishpanmi paycunata tantyatsergan quiquinpag imanog escribiraycashgantapis. Tsaynog yarpätsergan Moisés escribishgancunapita galaycur hasta waquin profëtacuna escribishganyagmi. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tsaymi Emaús marcaman chayaycushpanna paycunapita Jesús pasag-tucorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pasacuyta munaptinmi payta quëdatsergan caynog nir: “Patsa tsacaycannami, tayta. Caylachöna quëdacushun.” Tsaynog niptinmi Jesús paycunawan quëdacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tsaypita mësaman Jesús jamaycurnami tantata aptarcur Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paycunata ayporgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tsaynog ruraptinmi Jesús cashganta tantyapäcorgan. Tantyaptinnami elgacäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Elgacäcuptinnami quiquinpura caynog parlapäcorgan: “¡Jesusmi cashga! ¡Rasuntachari shonguntsipis cushicorgan caminucho Tayta Diosnintsipa palabranta parlapämaptintsi!” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tsauraga jinan höra Jerusalenman cuticärergan. Chayaycurnami taripäcorgan chunca juc (11) apostolcunata y waquin discïpuluncunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chayaycuptinnami paycunata apostolcuna caynog wilapargan: “¡Rasunpami Señornintsi Jesucristo cawarimushga! ¡Simontapis yuripashgami!” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niptinnami paycunapis wilapargan caminucho ima pasashgancunatapis y tantata Jesús paquishgan höra payta reguishgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsaynog parlarcaycaptinmi elagpita Jesús paycunapa naupancho ricacorgan. Nircurnami saludargan caynog nir: “Tayta Diosnintsi yanapayculäshunqui ali cawanayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tsaynog niptin paycuna fiyupa mantsacargan alma cashganta yarpashpan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tsauraga Jesús caynog nergan: “¿Imanirtag mantsacashga carcaycanqui? ¿Imanirtag noga cashgäta mana criyipäcunquitsu? ");
INSERT INTO qvmNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Noga cashgäta musyanayquipag maquëta y chaquëta yatapäcamay. Ricamashgayquinogpis manami almatsu caycä. Almaga aytsaynag y tuluynagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tsaynog nishpan ricatsergan maquinta y chaquintapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tsaynog ricar pasaypa cushicuycarpis manaragmi shumag criyipäcorganragtsu pay cashganta. Tsaynog mana criyiptinmi Jesús caynog taporgan: “¿Imalapis caycancu micurcunäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tsaynog niptinmi garargan juc pedäzo cancashga pescäduta y tinyaypa mishquinta. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tsaytami micorgan paycuna ricaycaptin. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Micurcurnami caynog nergan: “Moisés, waquin profëtacuna y salmucunata escribegcunapis lapanmi escribipäcorgan nogata pasamänanpag cagcunata. Gamcunawan caycar maynami wilargä lapan tsay escribiraycashgancuna cumplinanpag cashganta. Tsay wilashgänoglami pasamashga.” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsaynog nirmi Tayta Diosnintsipa palabranta tantyatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Tayta Diosnintsipa profëtancuna escribipäcorgan pay cachamushgan Cristo wanunanpag cashganta y wanushganpita quimsa junagta cawarimunanpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tsay escribishgancuna cumplishgana captinmi runacunata wilapanqui nogata chasquicamar jutsa ruraycunata cacharinanpag. Tsaynogpami Tayta Diosnintsi perdonangapag jutsa rurashgancunata. Jerusalenpita galaycur may-tsaypapis aywar lapan runacunata tsaynog wilapanqui. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wilacunayquipäga gamcuna ricashcanquimi ima pasashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gamcunamanmi noga cachamushag Taytä promitishgan Santu Espirituta. Itsanga Jerusalenlacho shuyarpaycanqui Santu Espirituta chasquinayquiyag. Chasquircuptiquinami yanapashunquipag wilacuynëta wilacunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsaypitana discïpuluncunata Jesús pushargan Jerusalenpita Betaniaman. Tsaycho caycarna maquinta jogarcur Tayta Diosnintsita manacorgan paycunata yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tsaynog paycunapag manacuycaptinmi Tayta Diosnintsi gloriaman pushacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tsaycho discïpulucuna Jesusta adorarcurmi cushishgala cuticärergan Jerusalenman. ");
INSERT INTO qvmNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tsay junagpitanami Tayta Diosnintsita alabananpag waran waran templuman juntacag. Amén.");
INSERT INTO qvmNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Imapis manarag captinmi Jesucristo mayna caycargan. Tayta Dioswanmi pay caycargan. Payga Diosnintsimi. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paywanmi Tayta Dios camargan lapan imaycatapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Paymi cay patsacho cagtaga lapantapis cawayta gon. Tsaynog cawayta gon runacuna Tayta Dios munashgannog cawapäcunanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tsaynog captinpis runacuna jutsalancho cawarmi tsacäpacushganog carcaycan. Tsaymi mana tantyantsu Tayta Diosnintsi munashgannog cawananpag. Tsaynog captinmi Jesucristo runacunata tantyatsin jutsa ruraycunata cacharir Tayta Dios munashgannogna cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Jesucristuta runacuna chasquicunanpagmi Juan Bautista wilacorgan. Tsaynog wilacunanpagmi Tayta Dios payta acrargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Shumag wilacuptinmi runacuna yarpapäcorgan Juan Bautista salvacog Jesucristo cashganta. Tsaynog yarpaptinpis manami Jesucristutsu payga cargan, sinöga Jesucristuta chasquicärinanpag wilacoglami. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesucristoga atsquinogmi caycan. Tsaymi cay patsaman shamorgan runacunapag atsquinog cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","Cay patsaman shamuptinpis runacuna manami tantyargantsu Jesucristoga Tayta Diospa naupanpita shamushganta. Tsaynogpis payta manami chasquicärergantsu, Tayta Dioswan cay patsata camashga caycaptinpis. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tsaynog captinpis Jesucristuta chasquicogcunami itsanga Tayta Diosnintsipa wamrancunana carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tsaynog niycaptenga manami mamanpita yurishganpitatsu Tayta Diospa wamrancuna carcaycan, sinöga Jesucristuta chasquicushganpitami. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tayta Dioswan caycashganpita cay patsacho runanog yurishpanmi Jesucristoga nogacunawan purergan. Paywan purirmi ricapäcorgä cuyacog cashganta. Tsaynogpis mayapäcorgä Diospa wilacuyninta yachatsishganta. Payga Tayta Diospa japalan cuyay tsurinmi. Tsaymi payta ricar quiquin Tayta Diosta ricagnogna capäcorgä. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypitami Juan Bautista caynog nir wilacorgan: “Jesucristoga nogapita más munayniyogmi caycan. Payga manaragpis yuriptë maynami caycarganna.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Moisesga Tayta Diospa mandamientuncunalatami tantyatsergan. Jesucristumi itsanga cuyamashpantsi tantyatsimantsi Tayta Dios salvamänantsipag cag mushog wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manami pipis Tayta Diosta ricashgatsu. Paytaga ricashga japalan cuyay tsurin Jesucristulami. Tsaymi pay cagpita shamushga car tantyatsimashcantsi Tayta Dios imanog cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jordán mayucho Juan Bautista runacunata bautizaycaptinmi Jerusalenpita autoridäcuna Juan cagman cachargan cüracunata y Leví casta runacunata. Paycunata cachargan Cristo cashganta o juc cashgantapis tapumunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tsay runacuna tapuptinmi Juan caynog nergan: “Nogaga manami Cristutsu cä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsaynog niptinmi yapay taporgan: “Tsauraga ¿pitag caycanqui? ¿Tayta Diospa unay wilacognin Eliascu?” Tsaymi Juan Bautista nergan: “Manami Eliastsu caycä.” Tsaymi yapay taporgan: “Tsauraga ¿Moisés nishgannog shamunanpag cag wilacog profëtacu caycanqui?” Niptinmi nergan: “Manami paytsu cä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsaynog niptinmi nipäcorgan: “Tsauraga ¿pitag canqui? Autoridäcunata wilanäpag pï cashgayquitapis wilapäcamay.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tsauraga Juan caynog nergan: “Nogaga Isaías escribishgannoglami Tayta Diospa wilacognin caycä. Tsaymi chunyag jircaman shamog runacunata wilapaycä jutsancunata cacharir Cristo shamuptin chasquicärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanta tapunanpag autoridä cachashgan runacunaga waquin cargan fariseo runacunami. Paycunami Juanta taporgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Tsauraga ni Cristo, ni Elías, ni Moisés escribishgannog shamunanpag caycag profëtapis mana caycarga ¿imanirtag runacunata bautizaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Tsaynog tapuptin Juan nergan: “Nogaga yaculawanmi bautizaycä. Itsanga jucragmi shamonga nogapita más munayniyog. Nogaga manami paynog munayniyogtsu caycä. Cay patsachöna caycaptinpis runacuna manami tantyacuntsu salvamagnintsi Cristo cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tsaynöga Juanta tapupäcorgan Jordán mayu tsimpan Betaniachömi. Tsaychömi runacunata Juan bautizaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsaypita wara junag Jesús aywaycämogta ricarmi Juan Bautista caynog nergan: “¡Ricapäcuy Tayta Dios cachamushgan runa aywaycämogta! Pascua aniversariucho carnishta wanutsipäcushgannogmi pay wanonga runacuna jutsa rurashgancunapita perdonashga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nogapita más munayniyog cashganta y manaragpis yuriptë pay mayna caycashgantami noga wilacö. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Naupataga manami musyargätsu Tayta Dios cachamushgan Cristo pï runa cashgantapis. Pï cashganta manarag musyarpis nogaga runacunata bautizaycashcä shamuptin payta chasquicärinanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jesucristo pï cashgantapis musyanäpagmi Tayta Dios caynog nimargan: ‘Bautizarcuptiqui maygan runapa jananman Santu Espíritu palomanog rataptinmi musyanquipag tsay runa Jesucristo cashganta. Paymi munayniyog caycan Santu Espirituwan runacunata bautizananpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tsay nimashgannoglami Jesusta bautizarcuptë paypa jananman Santu Espíritu palomanog rataycagta ricargä. Tsaymi gamcunata wilapä Tayta Diosnintsipa tsurin pay cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Tsaypita wara junag ishcay discïpuluncunawan caycarmi Juan Bautista ricargan Jesús pasaycagta. Payta ricarmi Juan Bautista caynog nergan: “¡Ricapäcuy! ¡Salvamagnintsi Cristo pasaycan!” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tsaynog niptinmi Jesuspa guepanpa tsay ishcay discïpulucuna aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ticraycamushganchömi Jesús ricargan guepanpa paycuna aywaycagta. Tsaymi taporgan: “¿Maypatag aywarcaycanqui?” Niptinmi nipäcorgan: “Gam cagmanmi aywaycämorgä, rabí. ¿Maychötag posädaraycanqui?” (Rabí ninanga yachatsicog ninanmi.) ");
INSERT INTO qvmNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tsaymi Jesús: “Acu, posädacushgä wayita reguitsishayqui” nergan. Tsaymi reguitsergan maycho posädarashgantapis. Tardina captinnami Jesuswan quëdacorgan posädacushgan cagcho. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tsay ishcay discïpuluncuna jucag cargan Simón Pedrupa wauguin Andresmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tsauraga jinan hörami Andrés aywargan wauguin Simón cagman. Chayaycurmi wilargan caynog nir: “¡Tincupäcushcä Tayta Dios cachamushgan Cristuwanmi!” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nircurnami Jesús cagman pushargan. Chayaycuptinnami Simonta ricaycur Jesús caynog nergan: “Jonaspa tsurin Simón, cananpitaga Pedrunami jutiqui canga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tsaypita wara junag Galilea provinciapa Jesús aywananpagna caycarmi tincorgan Felipiwan. Tsaymi payta nergan: “Discïpulö canayquipag nogawan aywashun.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipega cargan Betsaida marcapitami. Andreswan Pedrupis tsay marcalapitami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Discïpulun cananpag Jesús niptinmi Felipe aywargan Natanaelta caynog wilananpag: “¡Tayta Dios cachamushgan Cristuwanmi tincupäcushcä! ¡Payga Josëpa tsurin Nazaret marcapita Jesusmi! ¿Yarpanquicu Moisés y waquin profëtacuna pay shamur salvamänantsipag escribishganta? ¡Paywanmi tincupäcushcä!” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Niptinmi Natanael nergan: “¿Imanogpatag Nazaret marcapita Tayta Dios cachamushgan Cristo canman?” Tsaynog niptinmi Felipe nergan: “Acu aywashun ricanayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tsaymi Natanael aywaycämogta ricar runacunata Jesús nergan: “Tagay aywaycämog runaga ali runami. Payga rasun caglata imatapis parlan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tsay nishganta mayashpanmi Natanael taporgan: “¿Imanogpatag musyanqui ali runa cashgäta?” Tsauraga Jesús nergan: “Manami ali runa cashgalayquitatsu musyä, sinöga maycho cashgayquitapis musyämi. Tsaymi Felipe manarag gayashuptiquipis nogaga ricashcä hïgus yöra chaquincho jamaraycashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsaynog niptinmi Natanael nergan: “¡Tayta Diospa tsurinmi gam caycanqui, tayta! ¡Tsaynogpis Israel runacunapa mandagnin reymi caycanqui!” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tsaynog niptinmi Jesús nergan: “¿Hïgus yöra chaquincho jamaraycashgayquita ricashgäta nishgaläpitacu tsaynog nimanqui? Cananpitaga milagrucunata rurashgätapis ricanquipagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tsauraga tsaycho caycag runacunata Jesús caynog nergan: “Angilcuna ciëlupita uraycämogta y witsaycagta sueñuynincho ricarmi Jacob tantyargan Tayta Dios yanapaycashganta. Tsayta ricar Jacob tantyashgannogmi gamcunapis tantyanquipag Tayta Dios nogata yanapaycämashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tsaypita quimsa junagtanami casaray fiesta cargan Galilea provinciacho cag Caná marcacho. Tsay fiestachömi caycargan Jesuspa mamanpis. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tsay fiestamanmi Jesusta y discïpuluncunatapis gayatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Manarag fiesta ushacaptinmi vïnu ushacäcorgan. Tsauraga Jesusta maman caynog nergan: “Vïnu ushacashganami. ¿Maypitarag canan vïnuta jorgamonga?” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tsaynog niptin mamanta Jesús nergan: “Manami hörä chämunragtsu munashgayquinog milagruta ruranäpag, mamä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tsaynog niptinpis serviciucunata maman caynog nergan: “Imata ruranayquipag Jesús nishuptiquega cäsucärinqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tsaychömi caycargan rumipita rurashga yacuynag sogta urpucuna. Tsay urpucunamanmi yacuta winapäcog costumbrin cashgannog maquinta maylacärinanpag. Waquin urpucunamanmi yaycog ganchis chunca (70) litro yacu y waquinmannami yaycog pitsga chunca (50) litro yacu. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tsauraga serviciucunata Jesús caynog nergan: “Tsay urpucunaman yacuta juntagpag winapäcuy.” Tsaymi yacuta winapäcorgan urpucunaman juntashganyag. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Juntarcuptinnami Jesús nergan: “Ichiclata chagarcur apay mayor servicio yawananpag.” Jesús nishgannog rurapäcuptinmi tsay yacu ticrargan vïnuman. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tsaymi apapashgan vïnuta yawarcorgan mayor servicio. Itsanga manami musyargantsu maypita apashgantapis. Yanapag cag serviciucunalami musyargan yacupita vïnuman Jesús ticratsishganta. Tsay vïnuta yawarcurnami casarag mözuta gayaycur caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“¡Tsayrag apamushgan vïnoga waquin vïnupitapis más alimi caycan! ¿Maychötag tsay vïnutaga tarishcanqui? Waquin runacunaga fiesta galaycunalanchömi alinnin cag vïnuta sirvicun. Gammi itsanga fiesta ushananchörag más alinnin cag vïnuta sirvicuycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tsaynogmi Galileacho cag Caná marcacho Jesús rurargan punta cag milagruta. Munayniyog cashganta ricarmi discïpuluncuna tantyapäcorgan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsaypitanami mamanwan, wauguincunawan y discïpuluncunawanpis Jesús aywargan Capernaum marcaman. Tsaychömi goyargan juc ishcay junag. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua aniversario galaycunanpagna caycaptinmi Jesús aywargan Jerusalén marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chayashpannami templo patiucho tarergan atsca runacuna ranticurcaycagta. Tsaychömi ranticuycargan törucunata, uyshacunata y palomacunatapis. Tsaynogpis tarergan guellay ranticogcunata. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsaynog ranticuycagta tariycushpanmi sumbadorta rurarcur uyshantinta wäcantinta Jesús gargorgan templo patiupita. Guellayta ranticogcunapa mësancunatapis ticrar ushargan guellaynincunatapis mashtariycushpan. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tsaynog gargurmi paloma ranticogcunatapis caynog nergan: “¡Caycunata jorgapäcuy! Taytäta adoracuna wayichöga ¿imanirtag mercädo captinnogpis caycho ranticurcaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesús tsaynog ruraptinmi discïpuluncuna tantyapäcorgan Tayta Diospa palabrancho escribiraycashgannogla ruraycashganta. Tsay escribirashganga caynogmi niycan: “Templuchöga Tayta Diosta adorapäcunalantami munä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tsaynog garguptinmi Israel runacunapa autoridänincuna payta nipäcorgan: “¿Ima munayniquiwantag ranticogcunata gargushcanqui? Mä milagruta ruray munayniyog cashgayquita musyapäcunäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tsaynog niptinmi Jesús caynog nergan: “Milagruta ricayta munarga cay templuta juchutsipäcuy. Juchutsiptiquega quimsa junaglatami noga sharcatsishagpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsaynog niptinmi autoridäcuna nipäcorgan: “Cay templuta sharcatsipäcorgan chuscu chunca sogta (46) watatami. ¿Imanogpatag canan gam quimsa junaglata yapay sharcaratsinquiman?” ");
INSERT INTO qvmNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tsaynog nir Jesús manami templuta yapay sharcatsinanpagtsu nergan, sinöga quiquin wanushganpita quimsa junagta cawarimunanpag cashgantami niycargan. Tsaymi autoridäcuna Jesús imapita parlaycashgantapis mana tantyapäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Discïpuluncunapis manami juclaga tantyapäcorgantsu. Jesús wanushganpita cawarimushganta ricarragmi tantyapäcorgan templuman jitaycular quiquinpag parlashganta. Tsaynogpami musyapäcorgan Tayta Diosnintsipa palabrancho Jesuspita escribiraycashgan y Jesús nishgancunapis rasun cag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua aniversariucho atsca runacunami ricapäcorgan milagrucunata Jesús ruraycashganta. Tsaynogpami tantyapäcorgan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tsaynog tantyacuptinpis Jesús musyarganmi payman mana yäracuycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mana wilaptinpis payga musyarganmi runacuna imata yarpashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juc fariseo runami cargan Nicodemo jutiyog. Payga Israel runacunapa autoridäninmi cargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi tsacaylapa Jesús cagman aywargan parlananpag. Chayaycurmi caynog nergan: “Milagrucunata rurashgayquita musyarmi tantyapäcö Tayta Dios yanapaycäshushgayquita, tayta. Tsaymi musyapäcö nogacunata yachatsimänayquipag cachamushushgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tsauraga Jesús caynog nergan: “Runacuna Tayta Diospa naupanman chayananpäga yapayragmi yurinman. Yapay mana yurerga manami pipis gloriaman chayangapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tsauraga Nicodemo caynog taporgan: “¿Imanogpatag runacuna yapay yurinman yurishgana caycarga? ¿Cutinmantsurag mamanpa pachanman yapay yurinanpag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tsauraga Jesús caynog nergan: “Manami runacuna mamanpa pachanman cutinanpagtsu niycä, sinöga Santu Espiritupa munayninwan yapay yurinanpagmi. Pipis yacuwan y Santu Espiritupa munayninwan yapay mana yurerga manami Tayta Diospa naupanman chayangapagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Manami pipis mamanpita yurishgalanpitatsu salvashga canga, sinöga Santu Espiritupa munayninwan yurishganpitaragmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gloriaman chayananpag lapan runa yapayragmi yurinman niptë ama mantsacaytsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayrämogta mayarpis runacuna manami musyantsu maypita wayra shamushganta ni maypa aywashgantapis. Tsaynoglami runacuna mana tantyapäcuntsu yapay yurishganog cananpag Santu Espíritu imata rurashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsaynog niptinmi Nicodemo nergan: “Nogaläpis tsaytaga manami tantyätsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tsaynog niptinmi Jesús caynog nergan: “Israel runacunapa yachatsegnin caycar ¿manacu tsayta tantyanqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tsay nishgäcunata mana tantyaptiquipis nogaga gamta wilapaycä musyashgätami. Tsaynog captinpis gamcuna manami criyipäcunquitsu nishgäta. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Runacuna yapay yurishganog cananpag nishgäta mana criyiycarga ¿imanogpatag criyipäcunquiman masta niptëpis? ");
INSERT INTO qvmNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Manami pipis gloriaman aywarcur cutimushgatsu tsaycho imanog cashgantapis runacunata wilananpag. Nogami itsanga gloriapita cay patsaman shamushcä. Tsaymi rasun cagta runacunata wilapä. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Pipis nogata chasquicamagcunaga gloriacho cushishgami imayyagpis cawangapag. Tsaynog cawananpäga puntata noga wanushagragmi. Chunyag tsaqui jircacho culebra picashganpita runacuna aliyänanpag broncipita rurashga culebrata Moisés shawashgannogmi nogapis cruzcho wanushag chasquicamag runacuna salvacärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Runacunata cuyashpanmi Tayta Dios cachamorgan cuyay tsurinta. Tsaynogpami pipis Tayta Diospa tsurinta chasquicur payman yäracog cäga infiernuman manana gaycushgatsu canga, sinöga gloriamanmi chayanga imayyagpis tsaycho cawananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","18","Tayta Diosnintsega tsurinta cachamorgan payman yäracogcunata salvananpagmi. Tsaymi Tayta Diospa tsurinman yäracog cäga gloriaman chayangapag. Mana yäracog cagmi itsanga infiernuman gaycushga cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Paycunaga jutsa rurashgancunata cachariyta manami munantsu. Tsaymi Tayta Diospa tsurin cay patsaman shamushga captinpis payta mana chasquicärintsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tayta Diospa tsurinta chasquicog cagmi itsanga jutsa ruraycunata cacharin. Tsaynog cacharinanpäga Tayta Diosnintsimi payta yanapan. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsaypitanami Jesuswan discïpuluncuna aywapäcorgan Judea provinciaman. Tsaychömi runacunata bautizapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan Bautistanami bautizaycargan Enón nishgan ragracho, tsaycho atsca yacu captin. Enón cargan Salim marca cercanchömi. Tsaycho bautizaycashganta musyarmi waquin runacunaga tsayman aywargan bautizacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tsay witsanga Juan manaragmi carcilcho wichgararganragtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tsaychömi Israel runacunapa juc ishcay autoridänincuna Juan Bautistapa discïpuluncunata nergan: “Jesús bautizashganmi más ali caycan Juan bautizashganpitaga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tsaynog niptinmi discïpuluncuna Juanta caynog nipäcorgan: “Tayta, ¿yarpanquicu Jordán tsimpancho caycar juc runapita wilapämashgayquita? Cananga paymannami lapan runacuna aywarcaycan bautizacärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tsaynog nipäcuptinmi Juan caynog nergan: “Nogapita más munayniyog captinmi runacuna payman aywarcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamcunata nishgänogpis manami Tayta Dios cachamushgan Cristutsu nogaga caycä. Tsaypa trucanga Cristuta runacuna chasquicunanpag wilacunaläpagmi Tayta Dios cachamashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jipashwan juc mözu casaraptin amïgun cushicushgannoglami nogapis cushicö runacuna Jesucristumanna aywapäcuptin. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nogaman shapäcamunanpa trucanga más alimi caycan paymanna runacuna aywaptin. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Gloriapita shamushga carmi Jesucristo musyan tsaycho imanog cashgantapis. Nogaga cay patsalapita carmi mana paynöga musyätsu. Tsaymi tantyashgaläta wilacö. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jesucristumi itsanga wilacuycan gloriacho ricashgancunata y mayashgancunatapis. Tsaynog wilacuptinpis mana chasquicogcunaga manami tantyapäcuntsu rasun cagta wilacushganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Chasquicogcunami itsanga tantyapäcun rasun cagta wilacuycashganta. Jesucristoga tsaynog wilacuycan Tayta Diosnintsipita shamushga carmi. Tsaynog wilacunanpäga Santu Espiritumi payta yanapaycan. Tsaymi pay wilacushgannöga pipis mana wilacuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Tsurinta cuyarmi Tayta Diosnintsi lapantapis paypa munayninman cachaycushga. ");
INSERT INTO qvmNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tsaymi Diospa tsurin Jesucristuta chasquicog cagtaga gloriaman shuntanga tsaycho imayyagpis cushishga cawananpag. Payta mana chasquicog cagtami itsanga Tayta Diosnintsi rabiashpan infiernuman gayconga imayyagpis tsaycho nacananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo runacunami musyapäcorgan Juan Bautista bautizashganpita más atsca runacunata Jesús bautizaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","3","Fariseo runacuna tsaynog musyashganta tantyarmi Jesuswan discïpuluncuna cutergan Judea provinciapita Galilea provinciaman. Itsanga manami quiquintsu Jesús bautizargan, sinöga discïpuluncunami runacunata bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilea provinciaman chayapäcunanpäga Samaria provinciaparagmi pasapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tsaypa pasarmi Samariacho cag Sicar nishgan marca naupanman chayapäcorgan. Tsaychömi Jacobpa chacran cargan. Tsay chacratami tsurin Josëta unay goycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tsay chacrachömi cargan Jacob yacuta jorgunanpag uchcutsishgan pözu. Tsay pözu cagman chayaycurmi Jesús uticashga jamaycorgan. Tsay höra cargan pulan junagnognami. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Tsaycho Jesús jamapashganyagmi discïpuluncuna micuyta ranteg marcapa aywapäcorgan. Micuyta ranteg aywashganyagmi Jesús jamaraycashgan cagman Samaria warmi chayargan yacucog. Tsaymi yacunashpan yacuta Jesús manacorgan tsay warmita. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tsay witsanga Samaria runacunawan Israel runacuna contra contra ricanacorgan. Tsaymi yacuta manacuptin tsay warmi caynog nergan Jesusta: “Israel runa caycarga ¿imanirtag yacuta manacamanqui Samaria warmi cashgäta musyaycar?” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tsauraga Jesús caynog nergan: “Tayta Diosnintsipa palabranta tantyar y noga pï cashgätapis musyarga gampis yacuta manacamanquimanmi. Manacamaptiquega cawatsicog yacutami camaripäshayqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tsauraga tsay warmi nergan: “Yacoga rurichöragmi caycan. Jorgunayquipag imayquipis mana caycaptenga ¿imanogpatag jorgamunquiman cawatsicog yacuta camaripämänayquipäga? ");
INSERT INTO qvmNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacobmi cay pözuta unay uchcutsergan. Cay pözupitami yacuta upupäcorgan uywancunapis, tsurincunapis y quiquinpis. Paypis cay pözupitarag yacuta jorgamushga caycaptenga gam ¿maypitatag tsay yacuta jorgamunquiman?” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tsaynog niptinmi Jesús nergan: “Cay pözupita yacuta upog cäga yapaypis yacunangapagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noga camaripashgä yacuta upog cagmi itsanga imaypis manana yacunangapagnatsu. Paycunaga Tayta Diospa naupanchömi imayyagpis cawangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tsauraga Jesusta tsay warmi caynog nergan: “Imaypis mana yacunänäpag ni cay pözumanpis yacucog manana cutiycämunäpag tsay yacuta camaripaycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tsaymi Jesús nergan: “Ayway runayquita pushamunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Tsauraga tsay warmi nergan: “Manami runä cantsu, tayta.” Tsaynog niptinmi Jesús nergan: “Rasun cagtami gam nimashcanqui. Gamga pitsga runawannami tashcanqui. Canan taycashgayqui runapis puripänacushgayqui runalami caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsaynog niptin tsay warmi nergan: “Diospa profëtan imachari gam caycanqui, tayta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nogacunapa auquilöcunaga tagay jircachömi Tayta Diosta adorapäcog. Gamcunaga, Israel runacuna carmi, ‘Jerusalenchörag Tayta Diosta adorashun’ nircaycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tsaynog niptinmi Jesús caynog nergan: “Tagay jircaman mana aywaypa ni Jerusalenmanpis mana aywaypa Tayta Diosta adoranayquipag cag höra chaycämunnami. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tayta Diosta adorarpis Samariapita cashpayquimi gamcuna shumag mana musyanquitsu Tayta Diospa wilacuyninta. Tayta Dios cachamushgan salvacog runa Israel runa captinmi nogacuna musyapäcö paypa wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Israel runacuna y mana Israel runacunapis Santu Espíritu munashgannog lapan shongunwan Tayta Diosta adorapäcunanpag cag höra chämushganami. Tsaynog adoranantsitami Tayta Dios munan. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tayta Diosnintsega Espiritumi caycan. Tsaymi lapan shonguntsiwan maychöpis payta adorashun.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tsauraga tsay warmi nergan: “Cristo shamunanpag cashganta musyämi, tayta. Pay shamurnami tsaycunata tantyatsimäshunpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tsaymi Jesús caynog nergan: “Tsay shamunanpag cäga nogami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Micuyta rantimushganpita cutiycurmi discïpuluncuna Jesusta tarergan tsay warmiwan parlaycagta. Tsaymi quiquinpura caynog nir parlapäcorgan: “¿Imanirtag tagay warmiwan Jesús parlaycan?” Itsanga mayganpis manami taporgantsu imapita parlaycashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tsauraga puynunta cachariycushpan marcaman tsay warmi aywargan runacunata caynog nir wilananpag: ");
INSERT INTO qvmNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Juc runami pözu cagcho caycan. Paymi nimashga imanog cashgätapis. Acu aywashun ricapäcunayquipag. ¿Manatsurag pay caycan salvamagnintsi Cristo?” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tsauraga runacuna aywapäcorgan Jesús caycashgan cagman payta ricapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tsayyäga discïpuluncuna Jesusta nergan: “Micushunna, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tsauraga Jesús caynog nergan: “Nogapa micuynë jucmi caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tsaymi discïpuluncuna quiquinpura parlar caynog nergan: “¿Pirag micuyta apapämushga micunanpag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tsaynog yarpashganta tantyarmi Jesús nergan: “Nogapa micuynëga caycan cachamagnë nimashganta ruraymi. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¡Tantyacäriy! ¡Diospa wilacuyninta chasquicunanpag runacuna listunami carcaycan! Cananpita chuscu quillacho cosëcha listu cananpag cashgannogmi tagay aywaycämog Samaria runacunapis listuna caycan wilacuynëta chasquicunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wilacuynëta chasquicorga gloriacho cushishgami imayyagpis cawapäcongapag. Ali cosëcha cashganpita murog cagpis cosechag cagpis cushicushgannogmi Diospa wilacuyninta punta wilacogcuna y guepa wilacogcunapis cushicärin wilacushganta chasquicuptin.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Nircurnami Jesús nergan: “Diospa wilacuyninta wilacur unay profëtacuna murucognogpis maynami wilacärishga noga shamunäpag cashganta. Tsay unay profëtacuna wilacärishganmanmi gamcunatapis cachaycä wilacuynëta wilacärinayquipag. Tsaymi wilacärishgayquita runacuna wiyar chasquicuptin: ‘Juc muruptinpis jucnami cosechan’ nishgannogla caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Marcaman cutiycur: “Jesusmi nimashga imanog cashgätapis” nir tsay warmi wilacuptinmi atsca runacuna criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tsauraga runacuna Jesús cagman chayaycur ruwacärergan paycunawan quëdananpag. Tsaynog ruwacuptinmi paycuna cagcho Jesús goyargan ishcay junag. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Paycuna cagcho goyar wilapaptinmi más atsca runacuna criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tsaymi tsay warmita runacuna caynog nipäcorgan: “¡Gam nipäcamashgayquega rasun cagmi caycan! Cananga quiquëcunanami pay yachatsishganta mayashcä. Tsaymi musyapäcö runacunata salvananpag Tayta Dios cachamushganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tsaycho ishcay junag goyarcurmi Galilea provinciaman Jesús cutergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Galileaman cutiptinmi marca mayincuna cushicärergan Jerusalencho milagruta rurashgannog paycuna cagchöpis milagruta rurananpag cashganta yarpar. Jerusalencho milagruta rurashganta ricashga carpis manami criyipäcorgantsu Tayta Diospa wilacognin cashganta. Marca mayincuna tsaynog mana criyiptinmi Jesús caynog nergan: “Tayta Diosnintsipa profëtantaga marca mayincuna manami chasquicärintsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Tsaypitana Jesús cutergan Galilea provinciacho caycag Caná marcaman. Tsaychömi yacuta vïnuman naupata ticratsergan. Canácho cashganta musyaycurmi Capernaum marcapita juc autoridä tsayman aywargan. Chayaycurmi Jesusta ruwacorgan wayinman aywaycur antsa caycag tsurinta aliyätsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tsauraga Jesús caynog nergan: “¿Imanirtag gamcuna milagrutarag ricayta munarcaycanqui Tayta Dios cachamashganta criyipäcunayquipag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tsaynog niptinpis tsay runa caynog nergan: “Imanog captinpis tsurëta aliyätsinayquipag wayëman jucla aywayculäshun, tayta. Mana aywaptiquega tsurë wanongachari.” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tsaynog niptin Jesús nergan: “Tsuriqui aliyashganami caycan. Cananga cushishgana wayiquipa cuticuy.” Tsauraga Jesús nishganta criyir wayinpa cuticorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wayinman chayaycaptinnashi ashmaynincuna taripaycur caynog nergan: “¡Tsuriqui aliyashganami caycan, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tsaynog niptin ashmaynincunata taporgan imay höra aliyashgantapis. Tsauraga ashmaynincuna wilargan ganyan pulan junagna tsurin aliyashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsauraga tsay runa yarpargan Jesús tsay höra: “Tsuriqui aliyashganami caycan” nishganta. Tsaypitanami tsay runa wayincho cagcunawan criyipäcorgan Jesusga Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tsay wamrata aliyätsishganwanga ishcay cutinami milagruta Jesús rurargan Galilea provinciacho. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsaypitana Jerusalencho Tayta Diosta adorapäcunanpag fiesta captin Jesuspis aywargan tsay fiestaman. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén yaycunachömi “Uysha yargunan” nishgan puncu caycan. Tsaychömi caycan jatun pözu. Hebreo idiömachöga tsay pözupa jutin caycan Betesdami. Tsay jatun pözupa naupanchöga caycan pitsga alarcunami. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pitsgan alarcunachömi jitarpaycargan atsca gueshyaycag runacuna, gapra runacuna y puriyta mana puëdeg runacunapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tsaychömi paycuna shuyarpaycargan ciëlupita ángil urarcamur yacuta cuyutsipänanpag. Yacuta cuyurcatsiptinna maygan gueshyagpis puntata yacuman yaycog cäga aliyashgana yargamog. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tsaychömi juc runa gueshyar jitaraycargan quimsa chunca pusag (38) watana. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tsay runa unaypitana gueshyashganta musyarmi Jesús caynog taporgan: “¿Aliyashga cayta munanquicu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tsaynog niptinmi tsay gueshyaycag runa nergan: “Au, aliyashga caytami munä, tayta. Tsaynog captinpis manami pïnëpis cantsu yacuta ángil cuyutsiptin jatun pözuman yaycatsimänanpag. Yaycunäpag caycaptëpis jucmi yaliman.” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tsaynog niptinmi Jesús caynog nergan: “¡Sharcuy! Quirmayquita apacurcur aywacuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","10","Tsaynog niptin tsay gueshyaycag runa jinan höra aliyargan. Nircurna quirmanta apacurcur cushishga aywacorgan. Quirmanta apaycagta ricarmi Israel runacunapa autoridänincuna caynog nergan: “Sábado jamay junag caycaptenga ¿imanirtag quirmayqui apashga aywaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tsauraga tsay runa caynog nergan: “Aliyätsimagnë runami nimashga quirmäta apacurcur aywacunäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsaymi tsay runata tapupäcorgan caynog nir: “¿Pitag tsaynog nishushcanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tsaynog tapuptin pï aliyätsishgantapis manami musyargantsu, atsca runacuna tsaycho captin. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsaypitana tsay aliyätsishgan runawan templucho tincurcur Jesús nergan: “Aliyashgana caycarga amana yapay jutsata ruraynatsu. Jutsata yapay rurarga gueshyashgayquipitapis masmi imapis pasashunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tsaynog niptin tsay runa autoridäcunaman aywar wilargan aliyätsegnin runa Jesús cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wilaptinmi autoridäcuna Jesuspa contran sharcapäcorgan sábado jamay junagcho aliyätsishganpita. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tsaypitanami paycunawan tincur Jesús caynog nergan: “Taytä alita rurashgannogmi nogapis alita rurar tsay runata aliyätsishcä, sábado jamay junag captinpis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tsaynog niptinmi autoridäcuna Jesusta wanutsiyta munapäcorgan. Tsaynog wanutsiyta munargan manami sábado jamay junagcho runata aliyätsishgalanpitatsu, sinöga: “Diosmi Taytä” nishganpitami. “Diosmi Taytä” niptin paycuna yarpapäcorgan Dios-tucuycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tsauraga Jesús caynog nergan: “Diospa tsurin carmi lapantapis rurä Taytä munashgannogla. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Imatapis ruranäpäga Taytäragmi cuyay tsurin captë tantyatsiman. Tsaymi runacunata aliyätsishgalätatsu ricanquipag, sinöga más espantaypag cag milagrutapis ricanquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tsaymi juicio final junag wanushcunata Taytä cawaritsimunanpag munayniyog cashgannog nogapis munayniyog caycä runacunata perdonar mushog cawayta gonäpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Tsaynogpis juicio final junag Taytä manami pitapis juzgangatsu, sinöga tsurin captë nogatami nimashga pï-maytapis juzganäpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tsaynog nimashga quiquinta respitashgannogla nogatapis lapan runacuna respitamänanpagmi. Tsaymi nogata mana respitamag cäga Taytätapis mana respitaycantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Shumag tantyacäriy. Wilacuynëta chasquicur cachamagnë Taytäman yäracogcunaga infiernuman manami gaycushgatsu canga, sinöga gloriachömi imayyagpis cawangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tsaynogpis wilacuynëta chasquicorga wanushganog cashganpita mushog cawaytami chasquengapag. Tsay cawayta gonäpag cag höra maynami chämushgana. Tsaynoglami höra chämonga wanushcunatapis cawaritsimunäpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pitapis cawayta gonanpag Tayta Dios munayniyog cashgannogmi nogapis munayniyog caycä pitapis mushog cawayta gonäpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tsaynoglami Tayta Diospita noga shamushga captë lapan runacunata juzganäpag churamashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ama yarpapäcuytsu wanushcunata mana cawaritsimunäpag cashganta. Höran chämuptenga lapan wanushcunatami cawaritsimushag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Alita ruragcunaga cawarircamur imayyagpis gloriachömi cawapäcongapag. Mana alita ruragcunami itsanga cawarimurpis infiernucho imayyagpis nacapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Cachamagnë Taytä munashgantami imaypis rurä. Tsaymi pay munashgannogla lapan runacunata juzgashagpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","“Tayta Dios cachamashgantaga manami quiquilätsu në, sinöga milagrucunata ruranäpag yanapamashpan Tayta Diospis runacunata musyaycätsinmi paypita shamushgäta. Tsaynog musyaycätsishuptiquega tantyapäcuy nishgäcuna rasunpa cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Tsaynoglami Tayta Dios cachamashganta Juan Bautistapis wilacushga. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Tsaynog wilacuptin atscagmi cushicärergan shamunäpag cagta musyashpan. Nogapita Juan wilacushganta yarpaycätsë manami ali wilacog cashganta yarpänayquipagtsu, sinöga Tayta Dios cachamashganta criyishpayqui salvacärinayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nogapita Juan wilacushganta mana criyirpis milagro rurashgäcunata ricar y yachatsishgäcunata mayarga Tayta Dios cachamashganta criyipäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tsaynogpami quiquin mana parlapäshushpayquipis y mana yuripäshushpayquipis Tayta Dios musyaycätsishunqui nogata cachamashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tsaynog musyaycätsishuptiquipis nogata mana chasquicamarga Tayta Diostapis manami chasquicurcaycanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Gamcunaga Tayta Diosnintsipa palabranta liyir yachacurcaycanqui gloriaman chayayta munarmi. Tsaynog yachacurpis manami tantyapäcunquitsu tsay escribishgancuna noga shamunäpag escribiraycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tsaymi nogata chasquicamayta mana munarga Tayta Diosnintsipa palabranta mayjina yachacurpis gloriaman imaypis mana chayanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","“Noga musyämi janan shongula Tayta Diosman yäracuycashgayquita. Tsaymi gamcuna mana chasquicamaptiquipis nogaga imaypis Taytä nimashganta ruraycäshag. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","“Tayta Diospita shamushga captëpis gamcunaga chasquicamayta manami munapäcunquitsu. Quiquilanpa yarpaynilanpita shamog runacuna nishgancunatami itsanga chasquicurcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tsaynog chasquicurcaycanqui paycunapita ali ricashga cayta munarmi. Tsaynog caycarga ¿imanirtag yarparcaycanqui Tayta Dios munashgannog cawaycashgayquita? ");
INSERT INTO qvmNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","“Gamcuna yarpapäcunqui nogata mana chasquicamarpis Moisés escribishgan leycunata cumplir salvacärinayquipag cashganta. Tsaynog yarpaptiquipis Moisesga noga shamunäpag cagpitami escribergan. Moisés escribishgancunata rasunpa chasquicushpayquega noga nishgäcunatapis chasquicärinquimanmi. Mana chasquicushgayquipitami juicio final junag Taytäpa naupancho Moisespis nishunquipag jutsayog cashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nogapita Moisés escribishgantapis mana chasquicuycarga ¿imanogparag noga nishgäcunata chasquicärinquiman?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsaypitanami Galilea lagünata Jesús tsimpargan. (Cananga tsay lagünata nipäcun “Tiberias.”) ");
INSERT INTO qvmNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gueshyagcunata aliyätsishganta ricarmi paypa guepanta atsca runacuna aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tsaychönami lömaman aywaycur discïpuluncunawan Jesús jamacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Tsay witsan Pascua aniversario chaycämorgannami.) ");
INSERT INTO qvmNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Paycuna caycashganman atsca runacuna chaycämushganta ricarmi Felipita Jesús caynog nergan: “Caytsica runacunapäga ¿maypitatag micuyta rantimushun?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tsaynog nergan: “Mä imanimänagshi Felipe” nishpanmi. Jesús musyargannami imanogpa micuyta camaripänanpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tsauraga Felipe caynog nergan: “Pusag (8) quilla gänapacushgantsiwannog rantimuptintsipis manami aypanmantsu caytsica runacuna walca walcala micapäcunanpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsaymi Simón Pedrupa wauguin Andrés nergan: ");
INSERT INTO qvmNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Caycho juc wamra tsararaycan pitsga cebäda tantata y ishcay pescädulatami, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Niptinmi Jesús discïpuluncunata nergan: “Lapan runacunata nipäcuy jamacunanpag.” Tsaymi jamacunanpag discïpuluncuna niptin pashpaman lapan runacuna jamacärergan. Tsaychömi olgu cagcunalata yupaptin cargan pitsga waranganog (5,000). ");
INSERT INTO qvmNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nircurnami tsay pitsga tantata y ishcay pescäducunata Jesús aptarcur Tayta Diosta manacur agradëcicorgan. Agradëcicurcurnami discïpuluncunata macyargan runacunata aypunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lapan runacuna sacsashganyag micurcuptinnami discïpuluncunata Jesús nergan: “Putsushgancunata lapanta shuntamuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tsaynog niptinmi putsushgan tantata discïpuluncuna shuntargan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tsay milagro rurashganta ricaycurmi runacuna cushicushpan caynog nipäcorgan: “Cay runaga Tayta Dios cachamunanpag cag profëta imachari caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tsaynog nishpanmi runacuna imanogpapis nacionninpa mandagnin rey cananpag churayta munapäcorgan. Tsaynog churananta mana munarmi jircapa Jesús japalan aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Patsa tsacaycaptinnami Jesuspa discïpuluncuna cutergan lagüna cuchunman. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesusmi itsanga jircapita manarag cutimorganragtsu. Tsaymi büquiman witsarcur discïpuluncunala Capernaum marcaman aywaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aywaycaptinmi fiyupa wayraptin yacu pulchagyayta galaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tsaypita juc lëwatanog aywaycarna Jesusta ricapäcorgan yacu jananpa paycuna cagman aywaycagta. Payta ricaycurmi fiyupa mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tsauraga Jesús caynog nergan: “¡Ama mantsacamaytsu! ¡Nogami caycä!” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsaynog niptinmi büquita ichitsipäcorgan Jesús witsänanpag. Tsaypita maylantanami lagüna cuchunman chayapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Milagruta Jesús rurashgan cagcho quëdag runacuna ricargan tsaycho caycag juclayla büquiwan discïpuluncuna aywacärishgantami. Paycunawan Jesús mana aywashga captinmi yarpapäcorgan jircacho quëdacushganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Tsauraga Jesustapis ni discïpuluncunatapis mana tarishpanmi Tiberias marcapita büquicuna chayaptin tsay büquicunawanna Capernaum marcaman tsay runacuna aywapäcorgan Jesusta ashinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Capernaumcho Jesusta tariycurmi payta tapupäcorgan: “Tayta, ¿imay höratag cayman shamorgayqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tsauraga Jesús nergan: “Gamcuna ashircaycämanqui manami Tayta Dios cachamashganta tantyartsu, sinöga sacsagpag micushgalayquipitami. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pachalayquipäga ama yarpachacuytsu. Tsaypa trucanga yarpachacäriy mana ushacag cawayta taripäcunayquipag. Tsay cawaytaga nogapitaragmi chasquinquipag. Tsaypagmi Tayta Diosnintsi churamashga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tsaynog niptinmi paycuna tapupäcorgan: “Tayta, ¿imatatag rurapäcöman gloriaman aywapäcunäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tsauraga Jesús caynog nergan: “Gloriaman aywanayquipäga nishgäcunata chasquicäriy. Tsaytami Tayta Dios munan. Yäracamagcunata gloriaman pushanäpagmi Tayta Dios cachamashga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tsaynog niptinmi caynog nipäcorgan: “Nishgayquicunata chasquicunäpäga mä ricanäpag milagruta ruray. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chunyag tsaqui jircacho unay Israel mayintsicunapag maná nishgan micuyta Moisés camaripashgannog gampis mä nogacunapag micuyta waran waran camaripämay. Micuyta Moisés camaripashganpitaga Tayta Diosnintsipa palabranchöpis caynogmi niycan: ‘Tayta Diosmi jana patsapita micuyta paycunapag camaripargan.’ Tsaynogla gampis nogacunapag camarimuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tsauraga Jesús caynog nergan: “Shumag tantyacäriy. Moisés unay camaripashgan micuyga manami runacuna imayyagpis cawananpagtsu cargan. Cananmi itsanga runacuna imayyagpis cawananpag Taytä gloriapita juc micuytana camarimushga. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tsay micuytaga maynami ciëlupita cachamushga. Tsay micuyta micurmi runacuna imayyagpis gloriacho cawangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tsauraga paycuna nipäcorgan: “Tsay micuytaga waran waran camaripaycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tsaynog niptinmi Jesús nergan: “Imayyagpis cawatsicog micuyga nogami caycä. Nogata chasquicamag cäga sacsagpag micushgannogmi imaypis cushishga cawanga. Tsaynogpis nogaman yäracamag cäga yacuta yamashganyag upushgannogmi imaypis cushishga cawanga. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tsaynog captinpis gamcunaga yachatsishgäcunata mayaycarpis y milagro rurashgäcunata ricaycarpis manami chasquicamanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“Gamcuna mana chasquicamaptiquipis Taytä acrashgan cagcunaga lapanpis nogata chasquicamanmi. Nogata chasquicamagtaga manami pitapis gargushagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","39","Gargunäpa trucanga nogata chasquicamag cagtaga lapantapis juicio final junag cawaritsimushag. Taytä manami munantsu nogaman yäracamagcuna mayganpis guepaman cuticunanta. Paycunata shumag ricanäpagmi cay patsaman Taytä cachamashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tsaynogpami chasquicamagcunataga cawaritsimushag gloriacho imayyagpis cawananpag. Tsaycho cawanantami Taytä munan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gloriapita shamog micuy cashganta Jesús niptinmi tsaycho caycag Israel runacunapa autoridänincuna caynog nipäcorgan: ");
INSERT INTO qvmNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Cay runaga ¿manacu Josëpa tsurin? Nogantsega musyantsimi maman y taytan pï cashgantapis. ¿Imanirtag payga: ‘Gloriapitami shamushcä’ niycämantsi?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tsaynog nipäcuptinmi Jesús caynog nergan: “Gamcuna mana tantyashpayquimi tsaynog nircaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cachamagnë Tayta Dios tantyatsishganta chasquicogcunalami nogata chasquicaman. Chasquicamag cagtaga gloriacho imayyagpis cawananpagmi wanuptinpis cawaritsimushag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Tayta Diosnintsipa profëtancuna escribishganchöpis caynogmi niycan: ‘Lapan runacunatapis quiquëmi musyatsishag noga munashgänog cawananpag.’ Tsay escribirashgannoglami gamcunatapis Tayta Dios musyaycätsishunqui. Tsaynog captinpis pay tantyatsishganta chasquicog cagcunalami nogata chasquicaman. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gloriapita shamushga car nogalami Tayta Diosta reguë. Manami pipis más paytaga reguintsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tsaynog captenga nogata chasquicamag caglami Tayta Diospa naupancho imayyagpis cawangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Nogaga imayyagpis cawatsicog micuymi caycä. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","¿Manacu chunyag tsaqui jircacho unay Israel mayintsicuna micapäcorgan maná nishgan micuyta? Tsayta micurpis wanupäcorganmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gloriapita shamog micuyta micog cagmi itsanga imayyagpis cawangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nogami gloriapita shamog cag micuyga caycä. Runacuna gloriacho imayyagpis cawananpagmi noga wanushagpag. Tsaymi nogata micamag cäga wanurpis cawarimonga imayyagpis gloriacho cawananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tsaynog niptinmi tsay autoridäcuna jucninpis jucninpis caynog nipäcorgan: “¿Imanogpatag paytaga micushun?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tsauraga Jesús caynog nergan: “Nogata mana micamarga y yawarnëta mana uporga manami pipis gloriaman chayangatsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nogata micamag cagtami y yawarnëta upog cagtami itsanga cawaritsimushag gloriacho imayyagpis cawananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nogaga caycä rasunpa cag micuymi y yawarnëga rasunpa cag yacumi. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nogata micamag cagwan y yawarnëta upog cagwanmi imaypis caycäshag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Cachamagnë Taytä imayyagpis cawashgannogmi nogapis cawaycä. Tsaynoglami nogata chasquicamag cäga imayyagpis cawanga. Taytäpitarag cawayta chasquishgänoglami nogata chasquicamagcunapis nogapita cawayta chasquircaycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gamcunataga musyaycätsë gloriapita shamog micuy cashgätami. Unay Israel mayintsicuna maná micuyta micurpis wanorganmi. Gloriapita shamog micuyta micog cagmi itsanga gloriacho imayyagpis cushishgala cawangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús tsaynog yachatsergan Capernaum sinagogachömi. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tsay yachatsishganta mayar Jesuspa gatiragnincuna atscagmi caynog nipäcorgan: “Tsaynog parlaptenga ¿pitag paytaga criyenga?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tsaynog niycashganta tantyarmi Jesús caynog nergan: “¿Imanirtag gamcuna tsaynog yarparcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Canan tsaynog yarparpis gloriaman noga cutiycagta ricamashpayquimi tantyapäcunquipag Tayta Dios cachamashgan Cristo cashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Noga nishgäcunata chasquicuptiquega Santu Espiritumi yanapashunqui ali cawanayquipag y gloriacho cushishgala imayyagpis cawanayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Santu Espíritu yanapashunayquipag caycaptinpis waquinniquega nishgäcunata manami chasquicärinquitsu.” Jesús tsaynog nergan maygan runacunapis payta mana chasquicärishganta musyarmi. Tsaynogpis musyarganmi maygan discïpulun autoridäcunaman payta entregananpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tsauraga Jesús caynog nergan: “Waquinniqui mana chasquicamänayquipag cashganta musyarmi mayna caynog nishcä: ‘Tayta Dios tantyatsishganta chasquicogcunalami nogata chasquicaman.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tsay nishganta mana tantyarmi atsca runacuna Jesusta cachariycur aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Runacuna tsaynog aywacuptinmi chunca ishcay (12) acrashgan cag discïpuluncunata Jesús nergan: “¿Gamcunapis paycunanog aywacuytacu munarcaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tsauraga Simón Pedro nergan: “Gloriaman aywapäcunäpag shumag yachaycätsimaptiquega ¿imata ashirtag maypapis aywapäcöman, tayta? ");
INSERT INTO qvmNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogacunaga criyipäcömi Tayta Dios cachamushgan Cristo cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tsauraga Jesús caynog nergan: “Chunca ishcay (12) acrashgan cag discïpulöcuna canayquipäga nogami gamcunata acrashcä. Tsaynog captinpis gamcunapita jucmi diablo munashganta rurangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús tsaynog nergan Simonpa tsurin Judas Iscariotipagmi. Chunca ishcay acrashgan cag discïpuluncunapita carpis paymi autoridäcunata pushargan Jesusta prësu tsaripäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tsaypitanami Galilea provinciacho cag marcacunapa Jesús purergan. Judea provinciaman manami aywayta munargantsu Israel runacunapa autoridänincuna payta wanutsiyta munapäcuptin. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Jerusalencho Ramäda fiestapag walca junagla pishiycaptinmi wauguincuna Jesusta caynog nergan: “Fiestapag Jerusalenman ayway. Tsaychöpis milagrucunata ruray discïpuluyquicuna ricapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Reguishga cayta munarga manami caylachötsu milagrucunata ruranquiman. Jerusalén marcachöpis milagrucunata ruray lapanpis ricananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesuspa wauguincuna tsaynog nergan Tayta Dios cachamushgan Cristo cashganta mana criyishpanmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsauraga wauguincunata Jesús nergan: “Nogaga manami aywashagragtsu. Gamcunami itsanga imay hörapis aywapäcunquiman. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tsaychöga runacuna manami chasquicamantsu, jutsata rurashganta niptë. Gamcunatami itsanga chasquicushunqui, jutsata rurashganta mana niptiqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gamcunala aywapäcuy tsay fiestamanga. Manami hörä chämunragtsu tsayman aywanäpäga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tsaynog nirmi Galilea provinciacho Jesús quëdacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wauguincuna Ramäda fiestaman aywacuptinnami pitapis mana wilapaylapa Jesuspis aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiestacho Jesusta mana ricarmi Israel runacunapa autoridänincuna parlapäcorgan caynog nir: “¿Maychörag tsay runa caycan?” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Waquin runacuna nipäcorgan Jesús ali runa cashganta. Y waquincunanami nipäcorgan lutanta yachatsir puriycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Itsanga autoridäcunata mantsacärishpan manami pipis Jesuspita parlacorgantsu runacuna mayayga. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ramäda fiesta pulancho caycaptinnami Jerusalenman Jesús chayargan. Nircurnami templo patiuman aywaycur Tayta Diosnintsipa wilacuyninta yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tsaycho yachatsishganta mayaycur yachag cashganta tantyarmi autoridäcuna nipäcorgan: “Mana estudiashga caycarga ¿imanogpatag cay runa ali yachan?” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tsaynog nipäcuptinmi Jesús caynog nergan: “Nogaga yachä cachamagnë Tayta Dios yachatsimashga captinmi. Manami quiquiläpitatsu caynog yachä. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yachatsishgäcuna Tayta Dios munashgannog cashganta musyayta munarga pay munashgannog cawapäcuy. Tsaynogparagmi tantyapäcunquipag yachatsishgäcuna Tayta Diospita cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Waquin runacunaga, ali ricashga cayta munar, quiquinpa yarpaynilanpitami yachatsir puripäcun. Nogaga manami paycunanogtsu yachatsë, sinöga cachamagnë Tayta Dios munashgannoglami yachatsë. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gamcunaga Moisés escribishgancunata tsararaycanquimi tsaycunata yachacur Tayta Dios munashgannog cawapäcunayquipag. Tsaynog tsarararpis manami maygayquipis pay munashgannogtsu cawarcaycanqui. Tsaymi wanutsimayta munarcaycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jesús tsaynog niptinmi runacuna caynog nipäcorgan: “¿Pitag gamta wanutsiyta munaycäshunqui? ¡Demonio imachari gamta löcutaycätsishunqui!” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tsaymi Jesús caynog nergan: “Sábado jamay junagcho puriyta mana puëdeg runata aliyätsishgaläpitami gamcunaga wanutsimayta munarcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tantyacäriy. Moisés yachatsergan olgu wamra yurishganpita pusag (8) junagniyog caycaptin cuerpunta señalatsinantsipagmi. (Moisés yachatsiptinpis tsay costumbrega cargan más unaypitanami.) Moisés escribishgancunata cumplir ¿manacu sábado jamay junag captinpis olgu wamrapa cuerpunta señalapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Olgu wamrayquicunapa cuerpunta sábado jamay junag caycaptinpis señalaycarga ¿imanirtag nogata rabiapaycämanqui sábado jamay junagcho gueshyag runata aliyätsishgäpita? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pï cashgätapis manarag shumag tantyarga ¿imanirtag jutsayog cashgäta yarpapäcunqui? Shumag juiciuyquiwan parlapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tsauraga Jerusalencho tag waquin runacuna quiquinpura parlar caynog nipäcorgan: “¿Manacu cay runataga ashircaycan wanutsinanpag? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Atsca runacunapa naupancho yachatsiptinpis ¿imanirtag autoridäcuna upälacärin? ¿Autoridäcunapis Tayta Dios cachamushgan Cristo cashgantatsurag yarparcaycan? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Manami payga Tayta Dios cachamushgan Cristutsu canman. Musyantsimi may marcapita pay cashgantapis. Tayta Dios cachamushgan Cristo shamuptenga manami pipis musyangapagtsu maypita cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Runacuna tsaynog parlaycashgantami templo patiucho yachatsishgan höra Jesús mayargan. Tsaymi caynog nergan: “Gamcuna manami rasunpatsu musyapäcunqui maypita shamushgätapis. Manami quiquëpa munayniläpitatsu cay patsaman shamushcä, sinöga Tayta Dios cachamaptinmi shamushcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tayta Diospita shamushga carmi noga musyä pay imanog cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tsaynog niptinmi waquin runacuna rabiacushpan Jesusta prësu tsaritsiyta munapäcorgan. Itsanga prësu mana tsaripäcorgantsu tsarinanpag cag höra manarag chayaptinmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tsaynog captinpis atscagmi criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. Tsaymi paycuna nipäcorgan: “Milagrucunata rurashganta ricarmi criyintsi Tayta Dios cachamushgan Cristo cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Runacuna Jesuspa favornin tsaynog niycashganta mayaycurmi fariseo runacunawan mandag cüracuna cachapäcorgan templo täpag wardiacunata Jesusta prësu tsarimunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Prësu tsaregcuna chayananpäga Jesús caynogmi yachaycätsergan: “Gamcunawanga manami atsca watatsu caycäshagpag. Nogaga cachamagnë Taytä cagmanmi cuticushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ashimashpayquipis manami taripäcamanquipagtsu. Noga aywashgä cagmanga manami aywayta camäpacunquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesús tsaynog niptinmi Israel runacunapa autoridänincuna quiquinpura parlar caynog nipäcorgan: “Mana tarinantsipäga ¿mayparag aywaconga? ¿Juc lädu nacioncho tag marca mayintsicunamantsurag aywanga Diosta mana criyegcunata yachatsinanpag? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imanirtag ashirpis mana tarinantsipag cashganta niycämantsi? ¿Imanirtag pay aywashgan cagman chayayta mana camäpacunantsipag cashganta niycämantsi?” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ramäda fiesta día junagmi lapan runa mayananpag Jesús caynog nergan: “Pasaypa yacunaypanograg Tayta Diospa maquincho cawayta munag cäga nogata chasquicamätsun. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tayta Diosnintsipa palabrancho nishgannogpis pucyupita chuya yacuta upur cushicushgannogmi chasquicamagcunapis pasaypa cushicongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tsaynog nishpanmi Jesús tantyatsergan runacunapa shonguncho Santu Espíritu cananpag cashganta. Tsay witsanga Santu Espíritu manami chämorganragtsu. Gloriaman Jesús cuticuptinragmi payta chasquicogcunaman Santu Espíritu shamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús tsaynog nishganta mayaycurmi tsaycho cag waquin runacuna nipäcorgan: “Moisés nishgannog shamunanpag cag profëta imachari payga caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquin runacuna nipäcorgan: “Paytami Tayta Dios cachamushga salvamänantsipag.” Y waquinnami nipäcorgan: “Galilea runa caycarga ¿imanogpatag payga Tayta Dios cachamushgan Cristo canman? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tayta Diosnintsipa palabranchöga niycan mandag rey David castapita Cristo yurinanpag cashgantami. Tsaynogpis niycan Belenchörag yurinanpag cashgantami. Belencho mana yurishga carga manami payga salvamagnintsi Cristo canmantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tsaynog nirmi waquincunaga Jesuspa contran parlargan y waquinnami favornin sharcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Chasquicuyta mana munarmi waquincuna prësu tsariyta munapäcorgan. Tsaynog munarpis manami mayganpis tsarergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsaypitami templo täpag wardiacuna cuticärergan mandag cüracuna y fariseo runacuna cashgan cagman. Cutiycuptinmi tapupäcorgan caynog nir: “¿Imanirtag Jesusta prësu mana apamushcanquitsu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tsaynog tapuptinmi wardiacuna caynog nipäcorgan: “¡Pay parlashgantanöga manami imaypis mayapäcushcätsu!” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tsaynog niptinmi fariseo runacuna nipäcorgan: “¿Gamcunatapis criyitsishushcanquicu Tayta Dios cachamushgan Cristo cashganta? ");
INSERT INTO qvmNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tsay runataga manami maygan autoridäcunapis ni fariseo runacunapis criyipäcuntsu Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mana yachag runacunalami paytaga criyipäcun. ¡Tsay runacunaga manami musyantsu maycho sengan cashgantapis!” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Tsaynog nipäcuptinmi Nicodemo caynog nergan: “Leynintsicuna nishgannogpis puntata quiquin parlashgantarag mayashun imanog cashgantapis ninantsipäga.” (Nicodemoga cargan fariseo runami. Paymi naupata Jesús cagman aywargan paywan parlananpag.) ");
INSERT INTO qvmNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tsauraga paycuna caynog nipäcorgan: “¿Gampis paypa marca mayincu caycanqui favornin sharcunayquipag? ¡Tayta Diosnintsipa palabranchöpis manami imaypis nimantsitsu Galileapita profëta cananpag cashganta!” ");
INSERT INTO qvmNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tsaypitanami wayincunapana lapan cuticärergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tsaypitanami Jesús aywargan Olivos lömaman. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tsaypita wara tuta templo patiuman cutiptinmi runacuna pay cashgan cagman juntacargan. Tsaychömi Jesús paycunata yachatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tsaymanmi Moisés escribishgan leycunata yachatsegcuna y fariseo runacuna apapäcorgan jutsa rurag warmita. Tsay warmita taripäcorgan runanta jarucuycagta. Tsaynog tariycurmi tsaycho caycag runacunapa naupanman tsay warmita ichiycatsir Jesusta caynog tapupäcorgan: ");
INSERT INTO qvmNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Cay warmita taripäcushcä runanta jarucur juc runawan punuycagtami, tayta. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés escribishganchöga nimantsi caynog warmicunataga sagmaycälar wanutsinantsipagmi. Gamga ¿imaninquitag, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tsaynog tapupäcorgan Jesusta lutanta rimatsiyta munapäcushpanmi. Tsaynog tapuptinmi Jesús dëdunwan escribergan pampacho. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaparir yaparir tapupäcuptinnami ichircur Jesús caynog nergan: “Maygayquipis jutsaynag carga mä tsay warmita sagmapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsaynog nircurmi pampacho yapay escribergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tsauraga tsaynog nishganta mayaycärishpanmi auquincunapita galaycur lapanpis juc juclayla yargurir yargurir aywacärergan. Lapan aywacäriptinnami tsay warmilana Jesuspa naupancho quëdargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tsauraga tsay warmita Jesús caynog nergan: “¿Maytag sagmashunayquipag pushamushogniquicuna? ¿Manacu ni juclaylapis sagmashushcanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tsaynog niptin tsay warmi nergan: “Manami mayganpis sagmamashgatsu, tayta.” Tsauraga Jesús nergan: “Nogapis manami munätsu sagmashga canayquita. Cananga wayiquipana aywacuy. Itsanga amana jutsata ruraynatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tsaypitanami runacunata Jesús caynog nergan: “Cay patsacho runacunapäga atsquinogmi caycä. Tsaymi nogata chasquicamag cäga manami Satanaspa munayninchönatsu canga, sinöga Tayta Diospa maquincho car atsquichönog cushishga cawangapag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tsaynog niptinmi fariseo runacuna nipäcorgan: “Tsaynog cashgayquita quiquilayqui niycaptiquega ¿imanogpatag nogacuna criyipäcöman?” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tsaynog nipäcuptinmi Jesús nergan: “Quiquilä niptëpis noga nishgäcunaga rasun cagmi caycan. Taytäpa naupanpita shamushgäta y tsayman cuticunäpag cashgantapis musyämi. Gamcunaga manami musyapäcunquitsu maypita shamushgäta y mayman cuticunäpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tsaymi yarpaynilayquipita juzgaycämanqui. Nogaga manami gamcunanogtsu pitapis juzgä. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cachamagnë Taytä nogawan imaypis captinmi pitapis juzgarga rasun caglata juzgä. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Moisés escribishganchöpis caynogmi niycan: ‘Ishcay testïgucuna tsay yarpayla niptinragmi criyipäcunquiman imapis rasun cag cashganta.’ ");
INSERT INTO qvmNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tsay nishgannoglami ishcay testïgucuna caycan Tayta Dios cachamashgan Cristo cashgäta ninanpag. Cachamagnë Taytämi juc testïgo, y jucag testïgöga quiquëmi caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tsaynog niptinmi tapupäcorgan: “Nishgayqui rasunpa cashganta tapupäcunäpag ¿maychötag taytayqui caycan?” Tsauraga Jesús nergan: “Gamcunaga manami musyapäcunquitsu Taytä pï cashgantapis ni noga pï cashgätapis. Noga pï cashgäta musyarga Taytä pï cashgantapis musyanquimanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Templucho Jesús tsaynog nergan ofrendata shuntacuna churarashgan cagchömi. Runacunapa naupancho yachatsiptinpis manami pipis payta prësu tsarergantsu, prësu tsarinanpag cag höra manarag chayaptin. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tsauraga Jesús nergan: “Jutsata rurashgayquipita mana perdonashga carmi gamcunaga aywanäpag cashgan cagman imaypis mana chayanquipagtsu. Tsaymi aywacuptë ashimarpis mana taripäcamanquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tsaynog niptinmi Israel runacunapa autoridänincuna nipäcorgan: “¿Imanirtag aywacunanpag cashganta niycämantsi? ¿Wanutsicuytatsurag payga yarpaycan? Tsaychari pay cashgan cagman mana chayanantsipag cashgantaga niycämantsi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tsauraga Jesús nergan: “Nogaga gloriapitami shamushcä. Gamcunaga cay patsacho yureglami carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsaymi pï cashgäta wilaptëpis mana criyipäcamanquitsu. Tsaynog mana criyipäcamashgayquipitami gloriaman imaypis mana chayanquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsaynog niptin caynog nipäcorgan: “Tsaynog parlanayquipäga ¿pitag gam canqui?” Tsauraga Jesús nergan: “Pï cashgätapis maynami wilashcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gamcunata tantyatsinäpag atscaragmi caycan. Tsaynog captinpis noga yachatsishgäcuna manami quiquëpa yarpayniläpitatsu caycan, sinöga cachamagnë Taytä tantyatsimashgalanmi. Pay nimashgancunaga lapanpis rasun caglami caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesús tsaynog parlapaycaptinpis paycunaga manami tantyapäcorgantsu Tayta Diosnintsi paypa taytan cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tsaynog mana tantyapäcuptinmi Jesús nergan: “Noga pï cashgäta canan mana tantyarpis wanutsimashgayqui hörami tantyapäcunquipag pï cashgäta y Taytä nimashgannogla wilacushgätapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cachamagnë Taytäga imaypis nogawanmi caycan. Pay munashgannogla ruraptëmi imaypis yanapaycäman.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús tsaynog niptinmi atsca criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tsaypitanami payman criyeg Israel runacunapa autoridänincunata Jesús caynog nergan: “Yachatsishgänogla imaypis cawarga rasunpami discïpulöcuna canquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tsaynog cawarmi tantyapäcunquipag yachatsishgäcuna rasun cag cashganta. Tsaynog tantyacorga manami diablupa munayninchönatsu cawapäcunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tsaynog niptinmi caynog nipäcorgan: “Abrahampa castan caycaptëga ¿imanirtag tsaynog nipäcamanqui? Nogacunaga manami imaypis diablupa munayninchötsu cawapäcushcä, sinöga Tayta Diospa maquilanchömi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tsauraga Jesús nergan: “Shumag tantyacäriy. Jutsa ruraycho cawarga manami Tayta Diospa maquinchötsu cawaycanqui. Jutsata rurag cäga lapanpis diablupa munayninchömi carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Diablupa munaynincho cawarga manami Diospa wamrantsu caycan, sinöga diablupami. Nogaga Diospa tsurin carmi munayniyog caycä diablupa munaynincho caycagcunata jorgunäpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Diablupa munaynincho cashgayquipita noga jorguptëmi Tayta Diospa wamran rasunpa canquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Musyämi Abrahampa castan gamcuna cashgayquita. Abrahampa castan caycarpis manami nishgäcunata chasquicamanquitsu. Chasquicamänayquipa trucanga ¿imanirtag wanutsimayta munarcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taytäpa naupancho caycar musyashgäcunatami gamcunata wilapaycä. Tsaynog wilapaptëpis gamcunaga taytayqui munashgalantami rurarcaycanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tsauraga paycuna nipäcorgan: “¡Abrahampa castan captë paymi nogacunapa taytäga!” Tsaynog nipäcuptinmi Jesús caynog nergan: “Abrahampa castan caycarpis manami pay cawashgannogtsu cawarcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Abrahamga manami imaypis yarpargantsu Tayta Diospa wilacogninta wanutsiyta. Gamcunaga wanutsimayta munarcaycanqui Tayta Dios nimashgancunata wilacuptëmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mana chasquicamaptiquimi musyacaycan gamcunapa taytayqui diablo cashganta. Tsaymi pay rurashgannogla imaypis rurarcaycanqui.” Tsaynog niptin paycuna nipäcorgan: “Nogacunapa Taytäga Tayta Diosmi. Manami diablupa tsurintsu capäcö.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tsauraga Jesús caynog nergan: “Tayta Dios rasunpa taytayqui captenga nogata cuyamanquimanmi. Paymi gloriapita cachamashga cay patsaman shamunäpag. Manami quiquëpa munayniläpitatsu noga shamushcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imanirtag gamcuna mana tantyamanquitsu nishgäcunata? Chasquicamayta mana munarmi yaparir yaparir niptëpis gamcunaga mana tantyacunquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Gamcunapa taytayquega diablumi caycan. Tsaymi pay munashgalanta imatapis rurarcaycanqui. Unaypita-patsa runa wanutseg pay cashgannogmi gamcunapis nogata wanutsimayta munarcaycanqui. Tsaynogpis lula carmi diabloga imaypis rasun cagtaga mana rimantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nogaga rasun caglatami Tayta Diosnintsipa wilacuyninta gamcunata yachatsë. Tayta Diosnintsipa wilacuyninta chasquicuyta mana munarmi nogatapis mana chasquicamanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Jutsata imaypis mana rurashga captëmi maygayquipis mana careamanquimantsu noga jutsayog cashgäta. Rasun cagta wilacuycaptëga ¿imanirtag mana chasquicamanquitsu? ");
INSERT INTO qvmNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tayta Dios taytayqui captenga wilacuyninta cäsucärinquimanmi. Wilacuyninta mana cäsucäriptiquimi musyä Diospa wamran mana cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tsaynog niptinmi tsay autoridäcuna caynog nipäcorgan: “¡Gamga Samaria runacunanogmi lutanta rimaycanqui! ¡Gamtaga demoniumi mepareci löcutaycätsishunqui!” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tsauraga Jesús nergan: “Nogaga manami löcutsu caycä, sinöga Taytä munashgalantami parlaycä. Tsaynog parlaptëpis gamcunaga mana tantyashpayquimi chiquiycämanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Runacuna chasquicamaptinpis o mana chasquicamaptinpis nogaga Taytä munashgannoglami wilacuycä. Mana chasquicamag cagtaga Taytämi juzganga. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nishgäcunata chasquicogcunami itsanga gloriaman chayar imaypis mana wanongapagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tsauraga autoridäcuna caynog nipäcorgan: “Cananmi itsanga rasunpa musyapäcö demonio löcutaycätsishushgayquita. Abraham y Tayta Diosnintsipa profëtancunapis lapanmi wanupäcushga. Tsaynog caycaptinpis gamga niycanqui: ‘Nishgäcunata chasquicogcunaga manami wanongapagtsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tsaynog nerga ¿mana wanunayquipag cashgantacu yarpaycanqui? Mana wanunayquipäga manami Abrahampita más munayniyogtsu caycanqui. Paypis y Tayta Diosnintsipa profëtancunapis wanushga caycaptenga ¿pï cashgayquitatag gamga yarpanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tsauraga Jesús caynog nergan: “Tsaynog nishgäpitaga ama yarpapäcuytsu alabacuycashgäta. Taytä cachamashga captinmi rasun caglata niycä. Gamcunaga Taytäta ‘Diosnëmi’ niycarga ¿imanirtag mana criyimanquitsu nishgäcunata? ");
INSERT INTO qvmNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Taytä imanog cashgantapis gamcuna manami musyapäcunquitsu. Nogami itsanga lapanta musyä imanog cashgantapis. Tsaymi Taytä nimashgancunalata parlaycä. Gamcuna munashgayquinog yachatserga manami rasun cagtatsu parläman, sinöga gamcunanoglami lulacuycäman. ");
INSERT INTO qvmNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","‘Abrahampa castanmi nogacuna caycä’ niptiquipis Abrahamga manami gamcunanogtsu cargan. Payga cushicorganmi cay patsaman shamunäpag cashganta musyashpan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tsauraga autoridäcuna Jesusta nipäcorgan: “Manaragpis pitsga chunca (50) watayog caycarga ¿imanogpatag Abrahamta reguinquiman cargan?” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tsaynog niptinmi Jesús caynog nergan: “Tantyacäriy. Abraham manaragpis yuriptin nogaga maynami caycargäna.” ");
INSERT INTO qvmNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesús tsaynog niptinmi rumita aptacärergan sagmaypa wanutsipäcunanpag. Tsauraga sagmayta munapäcuptinmi runacunapa chaupinpa pasarir templo patiupita Jesús aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jerusalencho puriycarmi Jesuspa discïpuluncuna ricargan yurishganpita-patsa gapra runata. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tsaymi Jesusta tapupäcorgan caynog nir: “Tayta, ¿imanirtag cay runa gapra yurishga? ¿Mamanpa y taytanpa jutsanpitacu o quiquinpa jutsanpitacu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tsaynog tapuptinmi Jesús caynog nergan: “Manami quiquinpa ni mamanpa ni taytanpa jutsanpitatsu gapra yurishga, sinöga aliyätsiptë Tayta Dios munayniyog cashganta runacuna tantyacunanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsaymi cay patsacho cashgäyag cachamagnë Tayta Dios munashgannog runacunata aliyaycätsë. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cay patsacho cashgäyäga runacunapag atsquinogmi caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tsaynog nishpanmi pampaman Jesús togaycur mituta rurargan. Nircurna tsay mituwan gaprapa nawinta lushipargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Lushiparcurmi caynog nergan: “Siloé nishgan pözuman ayway tsaycho maylacamunayquipag.” (Siloé ninanga “Cachamushga” ninanmi.) Tsauraga Jesús nishgannog maylacaramurnami ricaycarna cutergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tsaymi vecïnuncuna y payta reguegcuna caynog nipäcorgan: “¿Manacu cay runaga limushnata manacog gapra runa caycan?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquincuna nipäcorgan: “Au, paymi.” Waquincunanami nipäcorgan: “Manami paytsu. Itsanga pay-niragmi.” Tsaynog niptinmi quiquin caynog nergan: “Au, nogami yurishgäpita-patsa gapra cargä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsauraga payta tapupäcorgan: “¿Imanogpatag nawiqui aliyashga?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tsaynog tapuptinmi caynog nergan: “Jesusmi togayninwan mituta rurarcur nawëta lushipämashga. Nircurnami cachamashga Siloé nishgan pözuman nawëta maylacunäpag. Tsaycho maylacushgäpitami cananga nawë ricaycanna.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsauraga payta yapay tapupäcorgan: “¿Maychötag caycan tsay aliyätsishogniqui runaga?” Tsaynog tapuptin nergan: “Manami musyätsu maycho caycashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tsaypitana tsay gapra cashganpita aliyashga runata pushapäcorgan fariseo runacunaman. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Sábado jamay junag aliyashga captinmi fariseo runacuna payta tapupäcorgan imanogpa aliyashgantapis. Tapuptinmi caynog nergan: “Juc runami nawëta mituwan lushipämargan. Tsay lushipämashgan mituta maylacuptënami nawë ricaycanna, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tsaymi waquin fariseo runacuna caynog nipäcorgan: “Tsay aliyätsishogniqui runaga manami Tayta Dios cachamushgantsu canman. Tayta Dios cachamushgan runa carga sábado jamay junagchöga manami aliyätsinmantsu pitapis.” Tsaycho caycag waquin runacunanami caynog nipäcorgan: “Tayta Dios mana cachamushga captenga ¿imanogpatag aliyätsinman cargan tsay runata?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tsauraga yapay tapupäcorgan gapra cashganpita aliyashga runata: “Gamga ¿pï cashgantatag yarpanqui tsay aliyätsishogniqui runapäga?” Tsaynog tapupäcuptinmi caynog nergan: “Nogaga yarpä Tayta Diosnintsipa profëtan cashgantami.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tsaynog niptinpis Israel runacunapa autoridänincunaga manami criyipäcorgantsu rasunpa gapra cashganta. Tsaymi mamanta y taytanta gayaycatsimur tapupäcorgan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“¿Cay runa tsuriquicu? ¿Rasunpacu gapra yurergan? ¿Imanogpatag aliyashga?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tsauraga maman y taytan caynog nipäcorgan: “Au, payga tsurëmi. Rasunpami yurishganpita-patsa gapra cashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Itsanga manami musyapäcötsu imanogpa aliyashgantapis ni pï aliyätsishgantapis. Payga caycan auquis runanami. Quiquinta tapupäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maman y taytan tsaynog nipäcorgan autoridäcunata mantsacushpanmi. Autoridäcunaga wilanacushganami caycargan mayganpis: “Jesusga Tayta Dios cachamushgan Cristumi” neg cagtaga sinagogapita gargunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tsayta mantsacurmi maman y taytan caynog nipäcorgan: “Payga auquis runanami. Quiquinta tapupäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tsauraga gapra cashganpita aliyashga runata autoridäcuna yapay gayatsimorgan caynog nir tapupäcunanpag: “Tayta Dios ricaycäshunquimi. Rasun cagta wilapäcamay. Musyapäcömi tsay aliyätsishogniqui runataga Tayta Dios mana cachamushganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tsauraga tsay runa caynog nergan: “Nogaga manami musyätsu Tayta Dios cachamushganta o mana cachamushgantapis. Itsanga musyä gapra cashgäpita aliyätsimashgantami.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tsaynog niptin yapay tapupäcorgan: “¿Imatatag rurashga aliyätsishunayquipag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Niptinmi caynog nergan: “Maynami gamcunata wilashcä. Wilaptëpis gamcunaga manami criyimanquitsu. ¿Imanirtag yaparir yaparir tsaynog tapupäcamanqui? ¿Gamcunapis payta gatiraytacu munarcaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsaynog niptinmi rabiacushpan nipäcorgan: “Gamchari paypa discïpulonga caycanqui. Nogacunaga Moisés yachatsishgancunatami cäsucärë. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Musyapäcömi Moisesta Tayta Dios mandamientuncunata entregashganta. Tsay aliyätsishogniqui runataga, jutsasapa captin, Tayta Dios manami imatapis musyatsishgatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tsaynog niptinmi gapra cashganpita aliyashga runa caynog nergan: “¿Imanogtag tsayga? Tsay runa nawëta aliyaycätsimaptenga ¿imanirtag mana tantyapäcunquitsu Tayta Dios cachamushganta? ");
INSERT INTO qvmNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Milagruta rurananpäga Tayta Dios manami imaypis jutsasapacunata yanapantsu, sinöga payta adorar munashgannog cawagcunalatami. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manami imaypis mayashcantsitsu yurishganpita-patsa gapra runata pipis aliyätsishganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tayta Dios mana yanapaptenga tsay runa manami imanogpapis aliyätsimanmantsu cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tsaynog niptinmi autoridäcuna nipäcorgan: “¡Gamga jutsasapa carmi gapra yurishcanqui! ¡Tsaynog caycarga manami imatapis nogacunata yachatsimanquimantsu!” Tsaynog nipäcushpanmi sinagogapita tsay runata gargapäcorgan imaypis manana cutinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tsay aliyätsishgan runata sinagogapita gargushgantami Jesús musyargan. Tsaymi paywan tincurcur nergan: “¿Tayta Dios cachamushgan runaman yäracunquicu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Niptin tsay runa caynog nergan: “Reguerga payman yäracömanmi, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tsauraga Jesús nergan: “Tayta Dios cachamushgan runawanga maynami tincushcanqui. Tsay runaga nogami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tsaynog niptinmi Jesuspa naupanman gongurpacuycur caynog nergan: “Gamman yäracömi, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tsaynog niptinmi Jesús nergan: “Nogaga cay patsaman shamushcä mana tantyacogcunata tantyatsinäpag y yachag-tucogcunata upatacätsinäpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tsaynog nishganta mayapäcushpanmi tsaycho caycag waquin fariseo runacuna nipäcorgan: “¿Nogacunapis upatacashga cashgätacu yarpanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tsaynog niptin Jesús nergan: “Gapra runa chasquicamashgannog gamcunapis chasquicamaptiquega Tayta Dios jutsayquicunata perdonashunquimanmi. ‘Salvashganami caycä’ niycarpis nogata mana chasquicamaptiquega Tayta Dios manami perdonashunquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mastapis Jesús caynog nergan: “Uysha cunchaman puncupa mana yaycog cäga suwami caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Cuncha puncupa yaycog cagmi itsanga uyshapa duëñun caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Musyashgantsinogpis cuncha puncuta quichapaptin uyshapa duëñonga jutinpa jutinpa gayan uyshancunata. Tsaynog gayashganta mayashpanmi cunchapita uyshancuna yargapäcamun. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lapan yargamurnami duëñunpa guepanta aywapäcun, duëñunta reguishpan. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jäpa captenga manami gatirantsu. Gatiränanpa trucanga gueshpirmi aywacärin.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tincutsiypa tsaynog Jesús yachatsiptinmi tsaycho cag runacuna mana tantyapäcorgantsu tsaynog tincutsir imata yachaycätsishgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tsauraga Jesús caynog nergan: “Nogaga caycä uysha cuncha puncunogmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","9","Tsaymi cuncha puncupa uyshacuna yaycushgannog nogata chasquicamag runacuna gloriaman yaycapäcongapag. Uyshacuna ali guewacho weray weray cashgannogmi nogata chasquicamagcuna ali cawayta tarengapag. Manarag shamuptë waquin runacuna lutanta yachatsishpan puripäcorgan caynog nir: ‘Nogatami Tayta Dios cachamashga wilacuyninta wilacunäpag.’ Tsaynog yachatsiptinpis Tayta Diosman rasunpa yäracogcuna paycunata manami chasquicärergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwaga shamun suwacunanpag, wanutsinanpag y ushacätsinanpagmi. Nogami itsanga shamushcä chasquicamag runacuna imayyagpis cushishgala cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Tsaynogpis uyshanta ali mitseg runanogmi caycä. Uyshancunata wanuy caway mitsegnin salvashgannogmi nogapis uyshäcunata salvanä-raycu wanushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pägu-raycula mitsipacog cäga löbu shamuptin gueshpirmi aywacun. Tsaynog aywacun duëñun mana cashpanmi. Tsauraga löbu gaticachaptin uyshacuna gueshpir matsipa matsirmi may-tsaypapis aywacärin. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tsaynog mitsipacog cäga uyshacuna elgaptinpis manami imapis gocuntsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nogaga rasunpa ali mitseg runanogmi caycä. Tsaymi Taytäta reguishgänog y pay nogata reguimashgannog nogapis uyshäcunata reguë y uyshäcunapis nogata reguiman. Tsaynogpis uyshäcuna-raycumi wanushagpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Manami caylachötsu uyshäcuna caycan, sinöga may-tsaychöpis caycanmi. Paycunapis nishgäcunata mayar cäsucärimangami. Tsaymi paycunatapis shuntamushag juc cunchalachöna cananpag. Tsaynogpis juclaylanami uysha mitsegnin cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taytäta cäsucur uyshäcuna-raycumi wanushag. Nircurnami cawarimushagpag. Tsaynog cäsucog captëmi Taytä cushicun. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Noga munayniyogmi caycä wanunäpag y cawarimunäpagpis. Tsaymi quiquë mana munaptëga pipis mana wanutsimanmantsu. Tsaynog captinpis Taytä nimashgannogmi wanushag y wanushgäpita cawarimushag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús tsaynog parlaptinmi Israel runacunapa waquin autoridänincuna yarpargan rasun cagta niycashganta y waquin cagna yarpargan quiquinpa yarpaynilanpita parlaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tsaymi waquin nipäcorgan: “Payta demonio löcutaycätsiptenga ¿imapagtag cäsucushun?” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Y waquin cagnami nipäcorgan: “Demonio löcutätsishga captenga manami tsaynog parlanmantsu. Tsaynogpis gapra runata manami aliyätsinmantsu cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Diciembri quilla templupa aniversariuncho fiestata rurapäcuptinmi templucho Jesús puriycargan Salomón nishgan alarcho. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tsaychömi Israel runacunapa autoridänincuna Jesusta tapupäcorgan: “¿Imayyagtag shuyäshayqui rasun cagta wilapäcamänayquipag? Tayta Dios cachamushgan Cristo cashgayquita o mana cashgayquitapis jucla wilapäcamay.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tsaynog nipäcuptinmi Jesús nergan: “Maynami gamcunata wilashcä. Wilaptëpis manami criyipäcamanquitsu. Taytäpa munayninwan milagrucunata ruraycaptëpis manami criyipäcamanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gamcunaga mana criyipäcamanquitsu uyshäcuna mana cashpayquimi. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Uyshäcunami itsanga pï cashgätapis tantyashpan cäsucaman. Tsaynogpis reguëmi uyshäcuna maygan maygan cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nogata chasquicamashganpitami Tayta Diospa naupancho imayyagpis cawangapag. Maquëcho captinnaga manami pipis guechumanganatsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maquëcho caycarga Taytäpa maquinchöpis caycanmi. Taytä lapanpagpis munayniyog captinmi diablupis ni demoniupis ni pipis paypa maquinpita guechongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taytäwan nogaga juclaylami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tsaynog niptinmi tsay autoridäcuna Jesusta sagmayta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tsauraga Jesús nergan: “Gamcuna ricashcanquimi atsca milagrucunata Taytäpa munayninwan rurashgäta. ¿Tsaynog alita rurashgäpitacu sagmayta munaycämanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tsauraga tsay runacuna nipäcorgan: “Manami alita rurashgayquipitatsu sagmayta munapäcö, sinöga runala caycar Dios-tucuycashgayquipitami.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tsaynog nipäcuptin Jesús nergan: “Tayta Diosnintsipa palabrancho caynogmi niycan: ‘Gamcunaga dioscunami carcaycanqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Musyapäcunquimi Tayta Diospa palabrancho lapanpis rasun cagla cashganta. Tsaymi Diospa wilacuyninta unay mayagcunapag: ‘Gamcunaga dioscunami carcaycanqui’ niycaptenga ¿imanirtag: ‘Diospa tsurinmi caycä’ niptë yarpapäcunqui lutanta niycashgäta? Quiquin Tayta Diosnintsimi cay patsaman cachamashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Milagruta rurashgäcuna Taytä munashgannog mana captenga ama criyipäcamaytsu: ‘Diospa tsurinmi caycä’ niptëpis. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nishgäcunata mana criyirpis milagruta rurashgäcunata ricaycarga tantyacäriy Taytäwan tsay yarpayla cashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tsaynog nishganpitami Jesusta yapay prësu tsaritsiyta munargan. Tsaynog munaptinpis Jesús tsaypita aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nircurnami Jordán mayu tsimpanman Jesús cutergan. Tsaychömi naupata Juan Bautista bautizargan runacunata. ");
INSERT INTO qvmNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jesús tsaycho cashganta musyarmi tsayman atsca runacuna aywargan. Paycuna caynogmi nipäcorgan: “Ima milagrutapis Juan Bautista manami rurashgatsu. Tsaynog captinpis Jesuspita lapan nishgancunaga rasun caglami caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tsaynog nirmi atsca runacuna criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania marcachömi targan juc runa Lázaro jutiyog. Paymi antsa gueshyaycargan. Paypa panincunami cargan María y Marta. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mariami Jesuspa chaquinman perfümita winaparcur agtsanwan pitsapargan.) ");
INSERT INTO qvmNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro antsa gueshyaptinmi panincuna juc runata Jesusman cachacorgan: “Cuyanacushgayqui Läzarumi pasaypa antsa caycan, tayta” nir wilananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tsaynog wilaptinmi Jesús caynog nergan: “Läzarutaga tsay gueshya tsarishga manami wanushgalancho quëdananpagtsu, sinöga noga cawaritsimuptë munayniyog cashgäta runacuna tantyacunanpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","7","Läzaruwan y panincunawan cuyanacurpis Jesús manami juclaga aywargantsu. Tsaypa trucanga pasaypa antsa cashganta wilaycaptinpis cashgan caglachömi ishcay junag goyargan. Tsaypitanami discïpuluncunata nergan: “Acu cutishun Judea provinciapa.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tsauraga discïpuluncuna caynog nipäcorgan: “Ganyancunaragchag tsaycho cag runacuna sagmaypa wanutsiyta munapäcushushcanqui, tayta. ¿Tsaynog caycaptincu tsayman yapay cutiyta munaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Tsauraga Jesús caynog nergan: “Ama mantsacäriytsu. Wanutsimänanpäga manami hörä chämunragtsu. Musyashgantsinogpis tsacaypa puregcunalami mantsacun. Junagpa puregcunaga manami mantsacuntsu. Tsaynoglami wanutsimänanpag hörä manarag chämuptin gamcunaga ama mantsacäriytsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nircurnami Jesús discïpuluncunata nergan: “Cuyashgantsi Läzaroga punucashgalami caycan. Acu aywashun ricchatsinantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tsaynog niptinmi discïpuluncuna caynog nergan: “Ali punuyta tariptinmi musyantsi aliyänanpag cashganta, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lázaro punucashga cashganta nirpis wanushga cashgantami Jesús tumatsipaylapa nergan. Tsaymi discïpuluncunaga mana tantyar punucashga caycashgalanta yarpargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tsaynog yarpaptinmi Jesús discïpuluncunata caynog nergan: “Läzaroga wanushgami caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wanushganpita cawaritsimuptëmi gamcuna más tantyapäcunquipag Tayta Dios cachamashganta. Tsaymi cushicö Lázaro cashgan cagcho mana cashgäpita. Pay cagman acu aywashun.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tsauraga Milïshu nipäcushgan Tomasmi discípulu mayincunata caynog nergan: “Tsaynog captenga nogantsipis wanunantsipag aywashun.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betaniaman chayarnami Jesús musyargan chuscu junagna Lázaro pamparaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Jerusalenpita Betaniaman pulan lëwanogla captinmi atsca runacuna aywapäcorgan Martata y Mariata yanagänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","“Jesusmi aywaycämun” negta mayarmi Marta aywargan taripänanpag. Mariami itsanga wayicho quëdacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesuswan tincurmi Marta caynog nergan: “Caycho captiquega turë manami wanunmantsu cargan, tayta. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Imanog captinpis gammanmi imaypis yäracö. Noga musyämi imata manacuptiquipis Tayta Dios mayashushgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tsaynog niptinmi Jesús nergan: “Turiqui cawarimongami.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tsauraga Marta caynog nergan: “Au, musyämi juicio final junag wanushcuna cawarimuptin turëpis cawarimunanpag cashganta, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Niptinmi Jesús nergan: “Nogami cawaritsimö wanushcunata. Nogata chasquicamag cagtaga wanuptinpis cawaritsimushagmi gloriacho imayyagpis cawananpag. ¿Tsayta criyinquicu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tsaynog niptinmi Marta nergan: “Au, tayta. Noga criyëmi. Gammi Tayta Diospa tsurin caycanqui. Tsaynogpis caycanqui Tayta Dios cachamushgan Cristumi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tsaynog nircushpanmi Marta cutergan nanan María cagman paypis Jesuswan tincog aywananpag. Chayaycushpanna gayaycur caynog wilargan: “Jesusmi chämushga. Paymi gayaycäshunqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tsaynog niptin María jucla aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús manaragmi marcaman chayarganragtsu, sinöga Martawan tincushgalanchöragmi caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wayipita María jucla yargogta ricapäcushpanmi payta yanagag runacuna guepanta aywapäcorgan: “Turin pamparaycashganmanchari aywaycan wagananpag” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tsauraga Jesús cagman María chayaycurmi naupanman gongurpacuycur nergan: “Gam caycho captiquega manami turë wanunmantsu cargan, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tsauraga Mariata y yanagagnin runacunatapis wagaycagta ricarmi Jesuspis fiyupa laquicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tsaymi paycunata taporgan: “¿Mayninchötag pamparaycan?” Tapuptinmi nipäcorgan: “Maynincho pamparaycashgantapis ricanayquipag aywashun, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tsauraga pamparashgan cagman aywaycarmi Jesuspis laquicushpan Läzarupag wagargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tsaymi waquin runacuna caynog nipäcorgan: “Ricay, pasaypachari cuyanacorgan Läzaruwan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waquincunami itsanga nipäcorgan: “Gapra runatapis aliyaycätserga ¿manatsurag Läzarutapis aliyätsinman cargan mana wanunanpag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pasaypa laquishgami Jesús chayargan Lázaro pamparashgan cagman. Tsay pamparashgan sepultüraga cargan gagacho uchcushgami. Puncunnami tsaparargan jatun rumiwan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tsayman chayaycurmi Jesús caynog nergan: “Tsaparaycag rumita wititsipäcuy.” Tsaynog niptinmi Läzarupa panin Marta nergan: “Chuscu junagnami pamparaycan, tayta. Cananyäga fiyupanachari asyaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tsaynog niptin Jesús nergan: “¿Manacu nishcä nogaman yäracamaptiquega turiquita cawaritsimunäpag cashganta?” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Tsauraga tsaparaycag rumita witircatsiptinnami jana patsata ricärir Jesús caynog nergan: “Manacushgäta imaypis mayamashgayquipitami gamta agradëcicamö, papá. Yanapamashgayquita ricarmi caycho carcaycag runacuna tantyapäcongapag gam cachamashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nircushpannami Jesús fuertipa caynog nergan: “¡Lázaro, yargamuy!” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsaynog niptinmi wanushga jitaraycashganpita cawarircamur Lázaro yargamorgan uman wancushga y maquin chaquin wancushga. Yargaramuptinnami Jesús nergan: “Purinanpag pascapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tsauraga Läzaruta cawaritsimushganta ricaycurmi Mariata yanagag runacuna atscag criyipäcorgan Jesusta Tayta Dios cachamushganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin cagnami fariseo runacunaman aywaycur wilapargan Läzaruta cawaritsimuptin atsca runacuna payman criyiycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tsayta mayaycurmi mandag cüracuna y fariseo runacuna Israel runacunapa autoridänincunata gayaycatsir caynog nipäcorgan: “Milagrucunata ruraptin aläpanami runacuna criyiycan Dios cachamushgan Cristo cashganta. ¿Imatatag rurashun tsay runata? ");
INSERT INTO qvmNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Payta prësu mana tsaritsiptintsega milagro rurashgancunata ricar lapan runacunami munapäconga nacionnintsipa mandagnin rey cananta. Tsayta mayaycurmi Romacho mandag emperador fiyupa rabiacushpan soldäduncunata cachamonga templuntsita juchutsinanpag y lapantsitapis wanutsimänantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tsaynog nipäcuptin más mandag cüra Caifás caynog nergan: “¡Gamcunaga manami imatapis tantyapäcunquitsu! ");
INSERT INTO qvmNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Templuntsita mana juchutsinanpag y mana wanutsimänantsipag tsay runala wanutsun. Tsaynogpami lapantsipis salvacushunpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","“Tsay runala wanutsun lapantsi salvacunantsipag” nir Caifás nergan Roma runacuna Israel runacunata wanutsinanta mana munarmi. Payga manami tantyargantsu jutsantsicunapita wanur Jesús salvamänantsipag cashganta. Mana tantyaptinpis tsaynog parlananpag Tayta Dios yarpätsergan más mandag cüra tsay wata captinmi. Caifás nishgannoglami Jesús wanorgan Israel runacunata y mana Israel runacunatapis salvananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tsauraga tsay junagpitanami autoridäcuna wilanacärergan Jesusta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tsayta musyarmi Israel runacunapa autoridänincunapita pacaylapana Jesús purergan. Tsaymi Judea provinciapita Jesús discïpuluncunawan aywacorgan Efraín nishgan marcaman tsaycho goyänanpag. Tsay marcaga chunyag jirca cercalanchömi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tsay junagcuna Pascua aniversario galaycunanpagna caycaptinmi marcancunapita atsca runacuna Jerusalenman aywapäcorgan Tayta Dios nishgannog tsay aniversariupag camaricog. ");
INSERT INTO qvmNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Templo patiuchönami runacuna caynog nergan: “Gamcunaga ¿imatatag yarpapäcunqui? ¿Aniversariupag Jesús shamongatsurag o manatsurag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo runacunawan mandag cüracuna maynami runacunata caynog nipäcorgan: “Jesusta maychöpis ricashpayquega jucla wilapäcamanqui prësu tsaritsipäcunäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua aniversariupag sogta junag pishiycaptinmi Jesús aywargan Betania marcaman. Tsaychömi wanushganpita cawaritsimushgan Lázaro targan. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tsayman Jesús chayashganpita cushicurmi Läzarupa panincuna cënayta yanucärergan paywan micapäcunanpag. Waquin runacunawan mësaman Jesús jamacuptinmi Läzarupis jamacorgan paycunawan micunanpag. Tsaymanmi panin Marta paycunata garargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tsaycho micurcaycaptinmi botëllawan María apamorgan nardu jachapita rurashga chanin cuestag perfümita. Nircurmi Jesuspa chaquinman winaparcur agtsanwan sëcapargan. Tsay perfümimi wayi junta asyargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tsauraga Jesusta entregananpag cag discïpulun Judas Iscariote caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imanirtag cay perfümita perdiycätsin? Tsaypa trucanga ranticushwan cargan juc wata arupacur gänashgantsichönog. Nircur tsay guellaywanna wactsacunata yanapashwan cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasmi shuntapäcushgan guellay tsararag cargan. Tsaynog nergan manami wactsacunata yanapayta munartsu, sinöga quiquinpag guellayta raquinan cashgami. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tsauraga Jesús nergan: “Winapämashganpita ama jamurpaytsu. Tsay perfümitaga churarätsergan manaragpis wanuptë winapämänanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wactsacunaga yanapanayquipag imaypis caycangami. Nogaga mananami gamcunawan cashagpagnatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Betania marcacho Jesús caycashganta musyarmi atsca runacuna tsayman aywapäcorgan. Manami Jesusta ricaglatsu aywapäcorgan, sinöga Lázaro cawarimushganta ricananpagwanmi aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Läzaruta cawaritsimushganpita Jesusman atsca runacuna criyiptinmi mandag cüracuna Läzarutapis wanutsiyta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Wara tuta runacuna musyapäcorgan Jerusalenman Jesús aywaycashganta. Tsaymi Pascua aniversariuman aywag atsca runacuna, palmacunata muturcur, apapäcorgan Jesusta chasquicärinanpag. Jesús chayaptinna caynog nipäcorgan: “¡Tayta Diosnintsi cachamushgan mandamagnintsi caychönami caycan! ¡Paymi mandamagnintsi rey caycan!” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tayta Diosnintsipa palabrancho escribiraycashgannoglami manta orgu bürrun muntashga Jerusalenman Jesús chayargan. Tsay escribiraycashganga caynogmi niycan: ");
INSERT INTO qvmNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalén marcacho tag runacuna, ricapäcuy humildi runanogla mandagniqui rey manta bürrun muntashga aywaycämogta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jerusalenman bürrun muntashga Jesús chayaptinmi discïpuluncuna mana tantyapäcorgantsu imanir tsaynog ruraycashgantapis. Wanushganpita cawarircamuptinragmi tantyapäcorgan Jesús rurashgancuna Tayta Diospa palabrancho nishgannogla caycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Läzaruta cawaritsimushganta musyashpanmi atsca runacuna cushishga Jesusta taripag shapäcamorgan. Pay cawaritsimushganta ricag runacunapis Tayta Diosta alabaraycar aywarcaycargan. Nänipa aywashpanmi pï-maytapis tincushgan cagta wilapargan Läzaruta cawaritsimushganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jesusman atsca runacuna criyishganta ricarmi fariseo runacuna caynog nipäcorgan: “Cananga ¿imatatag rurashun? ¡Lapan runacunami payman criyiycan!” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua aniversario captinmi may-tsay nacioncunapitapis Jerusalenman aywapäcorgan mana Israel runacunapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paycunapita waquin runacunami Felipita ruwacärergan: “Jesusta reguiycatsilämay, tayta” nir. (Felipega cargan Galilea provinciacho Betsaida marcapitami.) ");
INSERT INTO qvmNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tsaynog manacäriptinmi Felipe aywaycur Andresta wilargan. Nircurnami ishcan aywaycur Jesusta wilargan mana Israel runacuna paywan tincuyta munarcaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wilaptinmi Jesús caynog nergan: “Noga wanunäpag cag höra chaycämunnami. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Shumag tantyacäriy. Musyashgantsinogpis trïguta murur mana pampaptintsega manami winamuntsu. Pampaptintsimi itsanga winamur ali wayun. Tsaynoglami noga mana wanuptë pipis mana salvacongatsu. Wanuptëmi itsanga atsca runacuna salvacärengapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Tayta Diosta cäsucunanpa trucan quiquin munashgannog cawacuyta munagcunaga manami pipis gloriaman chayangatsu. Tayta Dios munashgannog cawag cagcunami itsanga gloriaman chayar imayyagpis cawapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pipis discïpulö cayta munarga noga cawashgänog cawatsun. Imanog nacarpis mana ajayaypa gatirämätsun. Tsaynog gatirämagcunataga Taytä cushishgalami chasquengapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Cananga fiyupa laquishgami caycä. Tsaynog laquishga caycarpis manami Taytäta manacömantsu wanunäpag cashganpita tsapämänanpag. Tsaynog wanunäpagmi cay patsaman shamushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tsaynog nishpanmi Tayta Diosta manacorgan caynog nir: “Munayniyog cashgayquita runacuna tantyacunanpag gam munashgayquinog lapanpis cayculätsun, papá.” Tsaynog manacuptinmi jana patsapita Tayta Dios caynog nimorgan: “Manacamashgayquita imaypis rurashgänoglami cananpis rurashag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tsayta mayarmi tsaycho cag waquin runacuna: “¡Räyumi cashga!” nipäcorgan. Waquincunanami: “¡Angilmi rimamushga!” nipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tsauraga Jesús caynog nergan: “Manami gamcuna nishgayquinogtsu caycan. Tayta Diosmi tsaynog parlamushga nogaman yäracamänayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Runacunata Tayta Diosnintsi juzgananpag cag höra chayaycämunnami. Tsaynogmi runacunata munaynincho tsararag diablupis vincishga cananpag höran chämongana. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tsaymi crucificamashganpita cawarircamur Israel runacunata y mana Israel runacunatapis tantyatsishag nogaman yäracamänanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tsaynog nirmi Jesús tantyatsergan crucificaypa wanutsishga cananpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tsaymi runacuna caynog nipäcorgan: “Tayta Diosnintsipa palabranchöga niycan salvamagnintsi Cristo imayyagpis cawananpag cashgantami. Tsauraga ¿imanirtag niycanqui wanunayquipag cashganta? Tsaynog captenga ¿rasunpacu Cristo caycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tsaynog niptinmi Jesús caynog nergan: “Au, Tayta Dios cachamashgan Cristumi caycä. Tsaynog captinpis walca junaglanami gamcunawan cashagpag. Tsaymi gamcunawan caycashgäyag jutsayquicunata cacharir yachatsishgäcunata chasquicäriy. Chasquicorga wanutsimaptinpis Tayta Diospa naupanman chayanquipagmi. Jutsayquicunata mana cacharerga manami imanogpapis paypa naupanman chayanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tsaynog caycaptenga yachatsishgäcunata chasquicäriy. Tsaynogpami gamcunapis Tayta Diospa wamrancuna canquipag.” Tsaynog nircushpanmi Jesús aywacorgan. Tsaynog aywacuptinnami runacuna mana musyapäcorgantsu maypa aywacushgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Atsca milagrucunata Jesús ruraycashganta ricarpis runacuna manami criyipäcorgantsu Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tsaynog mana criyinanpag cashganpitami Tayta Diosnintsipa profëtan Isaías unay escribergan caynog nir: “Tayta Dios, wilacuyniquita wilacuptëpis runacuna manami chasquicuntsu. Milagrucunata ricarpis manami criyipäcuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mastapis paycunapag Isaías caynogmi escribergan: ");
INSERT INTO qvmNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tayta Diosmi yarpayninta upatacätsergan wilacuyninta mana tantyapäcunanpag. Tsaynogmi shonguntapis chucruyätsergan payman mana yäracärinanpag. Tsaymi payta mana chasquicuntsu jutsancunapita perdonashga cananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías tsaynog escribergan runacuna Jesusta mana chasquicärinanpag cashganta musyarmi. Paytami Tayta Diosnintsi ricatsergan Jesucristo gloriacho munayniyog caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jesucristuta waquin Israel runacuna mana chasquicuptinpis waquin cag Israel runacunami itsanga criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. Tsaynoglami Israel autoridäcunapis waquenga criyipäcorgan Tayta Dios cachamushgan Cristo cashganta. Tsaynog criyipäcurpis sinagogapita fariseo autoridäcuna gargunanta mantsacushpanmi Jesusman yäracushganta mana wilacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tayta Diospita ali ricashga cananpa trucanga paycunaga más munapäcorgan runacunalapita ali ricashga caytami. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tsaypitana fuertipa Jesús caynog nergan: “Nogata chasquicamag cäga cachamagnë Taytätapis chasquicuycanmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tsaynogpis nogata reguimag cäga cachamagnë Taytätapis reguiycanmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Chasquicamagcuna Tayta Diosta reguir tsacäpacushganog mana cananpagmi cay patsaman shamushcä. Tsaymi runacunapag noga atsquinog caycä. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","“Manami runacunata juzganäpagtsu cay patsaman shamushcä, sinöga jutsancunata perdonar salvanäpagmi. Tsaynog captinpis nishgäcunata mana cäsucamagcunaga manami perdonashgatsu canga, sinöga juicio final junag infiernuman gaycushgami cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Manami quiquiläpa yarpayniläpitatsu wilacuycä, sinöga Taytä nimashgancunalatami wilacuycä. Paymi imata wilacunäpagpis tantyatsimashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tsaynog wilacuptëmi runacuna chasquicur gloriaman chayangapag. Tsaymi Taytä nimashgannogla imaypis wilacuycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","5","Jesusga musyarganmi paypa munayninman lapantapis Tayta Dios churamushganta. Tsaynogpis musyarganmi cay patsapita taytan cagman cuticunanpag caycashganta. Tsaymi Pascua aniversario galaycunanpagna caycaptin discïpuluncunawan cënananpag juntacargan. Tsaypäga Simonpa tsurin Judas Iscariotita Satanás maynami tantyatsishgana cargan autoridäcunaman Jesusta entregananpag. Discïpuluncunawan Jesús cënaycarmi mësapita sharcurcur janan cag röpanta jorgorgan. Nircurna discïpuluncunata cuyashganta tantyatsinanpag toällata tseglanman watacurcur paycunapa chaquincunata maylapargan. Maylaparcurnami toällawan chaquincunata sëcapargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaquinta maylapänanpag caycaptinmi Simón Pedro caynog nergan: “Tayta, chaquëta manami maylapämanquimantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tsauraga Jesús caynog nergan: “Gam manami tantyanquitsu imanir maylapänäpag cashgantapis. Nircurragmi tantyanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tsauraga Pedro nergan: “Imanog captinpis chaquëta manami maylapämanquimantsu, tayta.” Tsaynog niptinmi Jesús nergan: “Chaquiquita mana maylapaptëga manami discïpulö canquimantsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Niptinmi nergan: “Tsaynog captenga maquëtapis y umätapis maylapaycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tsauraga Jesús nergan: “Tsayrag armacushcunapaga chaquilanmi maylaypag caycan. Tsayrag armacushcuna limpio cashgannogmi jutsa rurashgayquipita perdonashgana car limpiuna carcaycanqui. Jucniquimi itsanga jutsancunata mana cachariptin armacöninog caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tsaynog nergan juc discïpulun payta entregananpag cashganta musyarmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Discïpuluncunapa chaquinta maylapayta usharcurnami jorgushgan röpanta jaticurcur mësaman yapay jamacorgan. Nircurnami caynog nergan: “¿Tantyapäcunquicu imanir chaquiquicunata maylapashgätapis? ");
INSERT INTO qvmNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","14","Yachatsicog caycar chaquiquicunata maylapaycaptëga gamcunapis ricacamashgayquinogla chaquiquicunata jucniqui jucniquipis maylapänacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ashmaynogla tsaynog rurashcä ricacamar gamcunapis ashmaynogla canayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Musyashgantsinogpis ashmayga manami patronninpita más munayniyogtsu caycan. Tsaynoglami cacha aywagpis cachagninpita más munayniyogtsu caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tsaynog captenga yätsishgänogla yanapanacorga cushishgami cawapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Manami lapayquipagtsu tsaynog niycä. Noga musyämi mayganiqui entregamänayquipag cashganta. Tayta Diospa palabranchöpis tsaynog cananpagmi caynog escribiraycan: ‘Nogawan micog cagmi conträ sharcushga.’ Tsay escribiraycashganga cumplengami. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tsay escribiraycashgannog manarag pasaptinmi gamcunata wilapaycä tsaynog cananpag cashganta. Tsaymi nishgänogla pasaptin musyapäcunquipag Tayta Dios cachamashgan Cristo cashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cachashgäcunata chasquicogcunaga nogatami chasquicaycäman. Tsaymi nogata chasquicamag cäga Taytätapis chasquicuycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tsaynog nircurmi Jesús pasaypa laquicushpan caynog nergan: “Gamcunapitami jucniqui conträcunapa maquinman entregamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jesús tsaynog niptinmi discïpuluncuna jucnin jucninpis ricapänacorgan mayganpag niycashgantapis mana musyashpan. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tsaychömi Jesuspa cuyay discïpulun paypa naupancho weguraycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Paytami Simón Pedro sëñata gorgan mayganpag parlaycashgantapis Jesusta tapunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tsaymi caynog taporgan: “¿Maygantag entregashogniqui caycan, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tsaynog tapuptinmi payta Jesús nergan: “Tsayga caycan tantata ushmarcatsir macyashgä cagmi.” Tsaynog nirmi tantata ushmarcatsir aptapargan Simonpa tsurin Judas Iscariotita. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tsay tantata chasquircuptinmi payman Satanás yaycorgan. Nircurnami Jesús caynog nergan: “Ruranayquipag cagtaga jucla ruray.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tsaynog niptinpis manami discïpuluncuna tantyargantsu imanir tsaynog niycashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gastuncunapag guellayta puritseg captinmi waquincuna yarpapäcorgan cënaypag rantipacamog Jesús cachaycashganta. Waquin discïpuluncunami yarpapäcorgan wactsacunata yanapananpag cachaycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tantata chasquircurnami Judas jucla aywargan yarpashgannog rurananpag. Tsayga cargan patsa tsacaycaptinnami. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Judas yarguptinnami Jesús discïpuluncunata caynog nergan: “Hörä chaycämunnami noga wanunäpag y nircur cawarimunäpagpis. Tsaynogpami runacuna tantyapäconga noga pï cashgäta y Tayta Dios munayniyog cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Cuyay wamränog cagcuna, gamcunapita aywacunäpagnami caycä. Autoridänintsicunata nishgänoglami gamcunatapis caynog niycä: Nogata ashimarpis manami tarimanquipagtsu. Gamcunaga aywashgä cagman manaragmi chayanquipagragtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Aywacuptëpis jucniqui jucniqui cuyanacärinqui noga gamcunata cuyashgänogla. Tsay nishgäga mushog mandamientumi gamcunapag caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nishgänogla cuyanacäriptiquimi pï-maypis tantyapäconga discïpulöcuna cashgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tsauraga Simón Pedro taporgan: “¿Maypatag aywacunquipag, tayta?” Tsaynog tapuptin Jesús caynog nergan: “Noga aywashgä cagmanga manaragmi aywanquipagragtsu. Nircurnami itsanga aywanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tsaynami Pedro taporgan: “¿Imanirtag gamwan mana aywämantsu, tayta? Gam-raycu wanunäpagpis nogaga listumi caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tsauraga Jesús nergan: “¿Rasunpacu noga-raycu wanunayquipag listu caycanqui? Tsaynog nirpis gällu manarag cantaptinmi reguimashgayquitapis quimsa cuti ñëgamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ama laquicäriytsu. Tsaypa trucanga Tayta Diosman yäracäriy. Tsaynogla nogamanpis yäracamay. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taytä cashgan cagchöga atscami wayicuna caycan tänayquipag. Tsaymanmi aywashag camarimunäpag. Tsay wayicuna mana captenga manami: ‘Camaricog aywashag’ nëmantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Camarircamurnami cutimushag gamcunata pushanäpag. Tsaynogpami noga tashgä cagcho gamcunapis tanquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gamcuna musyanquimi mayman aywanäpag cashgantapis. Tsaynogpis musyanquimi maygan nänipa tsayman chayanayquipag cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tsauraga Tomás caynog nergan: “Mayman aywanayquipag cashgantapis mana musyaycarga ¿imanogpatag musyapäcöman maygan nänipa aywanäpag cashgantapis, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tsauraga Jesús nergan: “Nogami nänega caycä. Tsaynogpis nogapa wilacuynëga rasun cagmi caycan. Nogami runacunapag ali cawayta apamushcä. Tsaymi nogata mana chasquicamarga Taytä cashgan cagman mana pipis chayangapagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nogata reguimag cäga Taytätapis reguinmi. Tsaymi cananpitaga musyapäcunquina Taytä imanog cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tsauraga Felipe nergan: “Nogaga manaragmi reguëragtsu. Tayta Diosta reguiycatsilämay nogapis reguinäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tsauraga Jesús nergan: “Naupapitana gamcunawan caycaptëga ¿manacu cananyag reguimanquirag? Reguimag cäga Tayta Diostapis reguinmi. Reguiycämarga ¿imanirtag manacamanqui Tayta Diosta reguitsinäpag? ");
INSERT INTO qvmNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manacu criyinqui Tayta Dios nogawan caycashganta y nogapis paywan caycashgäta? Tsaymi imatapis parlarga pay munashgannogla parlaycä. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tayta Dioswan noga caycashgäta y paypis nogawan caycashganta niycaptëga criyipäcamay. Nishgäcunata mana criyirpis milagro rurashgäcunata ricaycarga tantyacäriy rasun cagta niycashgäta. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Wanushgäpita cawarircamur Taytä cagman cuticuptëmi chasquicamagcunaga noga rurashgänog milagruta rurangapag. Tsaynog milagruta ruraptinmi más atsca runacuna tantyacur nogata chasquicamanga. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nogapa jutëcho Taytäta manacuptiquega manacushgayquita rurashagmi. Tsaynog rurashag may-tsaychöpis Tayta Dios alabashga cananpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nogapa jutëcho manacuptiquega imatapis rurashagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nogata cuyamarga lapan nishgäcunata cäsucäriy. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tayta Diostami manacushag Santu Espirituta gamcunaman cachamunanpag. Paynami imayyagpis gamcunawan caycanga yanapashunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tayta Diosta mana cäsucogcunaga Santu Espirituta manami chasquicärengatsu. Paycunaga manami tantyapäcuntsu Santu Espíritu cashgantapis. Gamcunami itsanga nogawan purir tantyanqui Santu Espíritu cashganta. Santu Espíritu shamurnami gamcunawan imayyagpis cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","19","“Ama yarpapäcuytsu manana tincunantsipag cashgantaga, sinöga wanushgäpita cawarircamuptë yapaymi tincushunpag. Tayta Diosta mana cäsucogcunawanga manami tincushagnatsu. Noga wanurpis cawarimushgänoglami gamcunapis cawarimunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tsay hörami tantyapäcunquipag Tayta Dioswan caycashgäta y gamcunawan caycashgätapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Nishgäcunata cäsucog cäga rasunpami cuyaman. Paytaga Taytäpis y nogapis cuyashagmi. Tsaynogpis tantyatsishagmi imaypis paywan caycashgäta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tsaynog niptinmi Santiagupa tsurin cag Judas caynog taporgan: “Nogacunawan canayquipag caycaptenga ¿imanirtag waquin runacunawanpis mana canquipagtsu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tsauraga Jesús nergan: “Pipis cuyamarga nishgäcunata cäsucunmi. Cuyamar cäsucamagcunatami Taytäwan noga cuyashag. Tsaymi cawarircamur paycunawan imayyagpis cashag. Tsaynoglami Taytäpis paycunawan cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nogata mana cuyamag cäga manami nishgäcunata cäsucuntsu. Y noga nishgäcunaga manami quiquëpa yarpayniläpitatsu caycan, sinöga cachamagnë Taytäpitami. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Lapan caycunata niycä gamcunawan caycashgäyagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aywacuptënami Tayta Dios nogapa trucä gamcunaman Santu Espirituta cachamonga. Paymi lapan yachatsishgäcunata yarpätsishunquipag y tantyatsishunquipagpis. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Gamcunapita aywacuptë ama laquicäriytsu ni mantsacäriytsu. Aywacurpis yanapaycäshayquimi ima pasashuptiquipis tranquïlo cawanayquipag. Noga yanapashgänöga manami pipis yanapashunquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gamcunata nishcänami aywacurpis cutimunäpag cashganta. Lapanpagpis munayniyog Taytä cagman aywacuptë ama laquicunquitsu. Rasunpa cuyamarga laquicunayquipa trucanga cushicäriy. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Gamcunata tsaynog wilapaycä manarag aywacurmi. Aywacuptënami musyapäcunquipag nishgäcuna rasunpa cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Satanás yarpätsishganta rurar prësu tsarimänanpag cag runacuna shamonganami. Tsaymi gamcunawan parlanäpag tiempo mana canganatsu. Satanasga imata ruramänanpagpis manami munayniyogtsu caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tsaynog caycaptinpis Taytäta cuyar cäsucushgäta lapan runacuna musyananpagmi pay nimashgannogla lapantapis cumplishag. Acu, caypita aywacushunna.” ");
INSERT INTO qvmNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tsaypitanami Jesús caynog nergan: “Nogaga caycä üva yöranogmi. Taytänami caycan üva uryagnog. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nogaman yäracamagcuna üvapa rämancunanogmi caycan. Tsaymi maygan rämapis mana wayuptenga Taytä muturiycun. Wayog cagtami itsanga Taytä shumag rämapan más wayunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Üvata rämapaptin limpio cashgannogmi gamcunapis nishgäcunata chasquicur jutsayquicunapita limpiuna carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","“Ima rämapis yörancho mana carga manami wayuntsu. Tsaynoglami gamcunapis nogaman mana yäracamaptiquega Tayta Diosnintsi mana yanapashunquipagtsu pay munashgannog cawanayquipag. Tsaynog caycaptenga nogaman yäracamashpayqui imaypis cawapäcuy. Tsaynog yäracamaptiquega gamcunawanmi imaypis caycäshagpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Noga caycä üva yöranogmi. Gamcunanami rämäcunanog carcaycanqui. Tsaymi cäsucamarga üva ali wayushgannog gamcunapis alita rurar cawapäcunquipag. Mana cäsucamarga manami imanogpapis Tayta Dios munashgannog cawanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pipis mana cäsucamag cäga yöranpita mutushga rämanogmi canga. Tsaynogpis tsay mutushga rämata shuntarcur rupatsishga cashgannogmi rupatsishga cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Nogapa munaynëcho cawashpayqui yachatsishgäcunata imaypis cumpliptiquega Tayta Diosnintsi imata manacushgayquitapis mayashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Noga munashgänog cawashpayquimi rasunpa discïpulöcuna carcaycanqui. Tsaynog cawaptiquimi runacuna tantyacushpan Tayta Diosta chasquicongapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Taytä cuyamashgannogmi nogapis gamcunata cuyä. Tsaynog cuyaycaptëga imaypis cäsucamar cawapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nishgäcunata cäsucamaptiquega imaypis cuyashayquimi. Tsaynoglami nimashgancunata cäsucuptë nogatapis Taytä cuyaman. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gamcunata tsaynog niycä noga cushishga cawashgänog gamcunapis cushishga cawapäcunayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Nishgäcunata cäsucamashpayquega jucniqui jucniquipis cuyanacäriy gamcunata noga cuyashgänog. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cuyashgantsi runataga ima pasaptinpis wanuy cawaymi yanapantsi. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lapan nishgäcunata cäsucamaptiquega gamcunatapis wanuy cawaymi yanapashayqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ashmaytaga manami patronnin wilapantsu imata yarpashgantapis. Gamcunata cuyarmi Taytä nimashgancunata lapanta wilapashcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Manami acramashgayquipitatsu cuyä, sinöga gamcunata noga acrashgäpitami. Tsaymi gamcunata cachaycä Tayta Diosnintsipa wilacuyninta wilacuptiqui runacuna salvacionta tarinanpag. Wilacuptiqui yanapashunayquipäga nogapa jutëcho Taytäta manacärinqui. Manacuptiquega yanapashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tsaynog caycaptenga jucniqui jucniquipis cuyanacur cawapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Runacuna chiquishuptiquega ama laquicäriytsu. Nogata chiquimashgannoglami gamcunatapis chiquishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Paycunanog jutsata rurar cawaptiquimi itsanga cuyashunquiman. Chiquishuptiquipis Tayta Dios munashgannog cawanayquipagmi gamcunata acrashcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“ ‘Ashmayga manami patronninpita más munayniyogtsu’ nishgänoglami cananpis gamcunata caynog në: Patronta chiqueg cäga ashmaynincunatapis chiquinmi. Tsaynoglami nogata chiquimag cäga gamcunatapis chiquishunquipag, y nogata chasquicamag cäga gamcunatapis chasquishunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Runacuna chiquishunquipag discïpulöcuna cashgayquipitami. Paycunaga cachamagnë Taytä nishgancunata manami cäsucärintsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","24","“Tayta Diosnintsipa wilacuyninta wilacur y pipis mana rurashgan milagrucunata rurarmi runacunata tantyatsishcä pay cachamashganta. Tsaynog tantyaycätsiptëpis runacunaga chiquimarmi jutsayog caycan. Mayganpis nogata chiquimag cäga Taytätapis chiquiycanmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tayta Diosnintsipa palabranchöpis caynogmi niycan: ‘Jutsaynag caycaptëpis runacuna chiquimashgami.’ Tsay escribirashgannoglami lapanpis cumpliycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Gamcunamanmi Taytä cagpita Santu Espirituta cachamushag imaypis yanapashunayquipag. Tsaynogpis paymi nogapita tantyatsishunqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gamcunapis nogawan imaypis purishga caycarga nogapita runacunata tantyatsipäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tsay lapanta gamcunata niycä runacuna chiquishuptiquipis nogaman imaypis yäracamänayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chiquishushpayquimi sinagogapitapis gargushunquipag. Tsaynogpis Tayta Dios munashganta ruraycashganta yarparmi wanutsishunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tsaynog rurapäcushunquipag nogata ni Taytätapis mana chasquicamarmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tsaynog pasashuptiqui yarpapäcuy nishgänogla lapanpis cumpliycashganta. Naupataga gamcunata manami wilargäragtsu tsaynog pasashunayquipag cashganta. Aywacunäpag carnami chiquishga canayquipag cashganta wilaycä. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","“Cananga Taytä cagman cuticunäpagnami caycä. Tsaynog captinpis: ‘¿Maypatag aywanqui?’ nir tapumänayquipa trucanga ¿imanirtag laquishga carcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama laquicäriytsu. Aywacurpis Santu Espiritutami cachamushag gamcunawan cananpag. Mana aywacuptëga manami Santu Espíritu shamongatsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pay shamurnami runacunata tantyatsenga jutsayog cashganta, Tayta Diosta mana cäsucog cashganta y jutsata rurashganpita juzgashga cananpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jutsayog cashgantaga Santu Espíritu tantyatsenga nogata mana chasquicamaptinmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tayta Diosta mana cäsucog cashgantaga Santu Espíritu tantyatsenga Taytä cagman cuticuptëmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Runacunata Tayta Dios juzgananpag cashganta Santu Espíritu tantyatsenga Satanás vincishgana captinmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Atscaragmi caycan gamcunata yachatsinäpag. Tsaynog captinpis manami lapantaga yachatsishayquiragtsu. Lapanta yachatsiptëga manami yarpanquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Santu Espíritu shamurnami mana yachatsishgä cagcunata tantyatsishunquipag. Tsaynoglami tantyatsishunquipag ima pasananpag cagcunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Santu Espíritu nogapita tsaynog tantyatsishunquipag noga alabashga canäta munarmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Taytäpa maquincho cagcunaga nogapa maquëchömi carcaycan. Tsaynog captinmi nishcä Santu Espíritu nogapita tantyatsishunayquipag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Más rätutaga nogata manami ricapäcamanquipagnatsu. Tsaypita warantincunaga yapaymi gamcuna ricamanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tsaynog niptin discïpuluncuna jucninpis jucninpis caynog nipäcorgan: “Tsaynog nishpan ¿imatarag niycämantsi? ¿Imanirrag nimantsi: ‘Más rätutaga manami ricamanquipagnatsu’? Y nircorga ¿imanirrag niycan: ‘Tsaypita warantincunaga yapaymi ricamanquipag’? Tsaynogpis ¿imanirrag: ‘Taytä cagman aywacushagmi’ niycämantsi? ");
INSERT INTO qvmNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imaypitarag payta mana ricashuntsu? Manami tantyantsitsu imata parlaycashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Discïpuluncuna tsaynog yarpachacärishganta musyarmi Jesús caynog nergan: “¿‘Más rätutaga manami ricapäcamanquipagnatsu’ y ‘Tsaypita warantincunaga yapaymi ricapäcamanquipag’ nishgäpitacu gamcuna yarpachacurcaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aywacuptë waquincuna cushicuptinpis gamcunaga laquicushpayqui wagapäcunquipagmi. Tsaynog laquicurpis nircorga cushicärinquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Musyantsimi wachay nanay tsariptin warmicuna laquicärishganta. Yuripacurirnami itsanga cushicur manana yarpannatsu nanaywan nacashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tsaynoglami gamcuna canan laquicurpis yapay tincuptintsi cushicärinquipag. Tsay cushicushgayquitaga ima pasashuptiquipis manami gonganquipagtsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yapay tincuptintsega mananami tapupäcamanquipagnatsu imanir tsaynog parlashgätapis. “Shumag tantyacäriy. Nogapa jutëcho manacuptiquega Taytä mayashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Naupataga Taytäta manacurpis manami jutëchötsu manacärishcanqui. Cananpitaga nogapa jutëcho Taytäta imatapis manacäriy. Manacuptiquega manacushgayquita mayashunquipagmi. Manacushgayquita mayaptinmi cushicärinquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gamcunata cananyag imamanpis tincutsiypa yachatsiptë manami shumag tantyapäcamashcanquitsu. Nircurmi itsanga gamcunata yachatsishayqui imamanpis mana tincutsiylapana. Tsaynog yachatsiptëmi itsanga lapan nishgäcunatapis tantyapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yachatsishgäcunata tantyacurnami nogapa jutëchöna Tayta Diosta manacärinquipag. Tsaymi mana shuyarangatsu nogarag gamcunapag manacunäta, sinöga gamcuna manacushgayquitapis mayashunquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tayta Diosnintsega gamcunata cuyashunquimi. Tsaynog cuyashunqui paypita shamushgäta criyir cuyapäcamaptiquimi. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taytäpa naupanpitami cay patsaman noga shamushcä. Tsaynoglami Taytäpa naupanman cuticushagpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tsauraga discïpuluncuna caynog nergan: “¡Cananmi itsanga nimashgayquicunata tantyapäcö! Mananami tumatsipaylapanatsu parlapaycämanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tsaynogpami musyapäcö gam lapanta musyashgayquita. Tantyatsimänayquipag mana manacuptëpis tantyatsipäcamanquimi. Tsaymi Tayta Diospa naupanpita shamushgayquita criyipäcö.” ");
INSERT INTO qvmNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tsauraga Jesús caynog nergan: “¿Rasunpacu criyircaycämanqui? ");
INSERT INTO qvmNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cananga höra chämushganami japaläta cachariycamar wacpa caypa aywacärinayquipag. Tsaynog cacharimaptiquipis manami japalätsu caycäshag, sinöga Taytäwanmi cashagpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Gamcunata tsaynog niycä runacuna chiquishuptiquipis mana ajayaypa imaypis yäracamänayquipagmi. Cay patsacho cashgayquiyäga nacapäcunquiragmi. Nogapis nacar gamcuna-raycu wanurmi Satanasta vincishagpag. Tsaynog captenga cay patsacho nacarpis ama laquicäriytsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tsaypitanami jana patsata ricärir Tayta Diosta Jesús manacorgan caynog nir: “Wanunäpag cag hörä chayaycämunnami, papá. Wanuptëpis cawariycatsilämay munayniyog cashgayquita runacuna tantyapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gammi lapan runapagpis munayniyog canäpag churamashcanqui. Tsaynogpis churamashcanqui acrashgayqui cagcunata perdonar salvanäpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Salvashgana car gloriaman chayarmi reguishushpayqui gam japalayqui Dios cashgayquita musyangapag, papá. Tsaynoglami naupayquicho caycagta ricamashpan cay patsaman cachamashgayquitapis musyangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Lapan shongöwanmi nimashgayquicunata cay patsacho cumplishcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cay patsata manarag camar naupayquicho munayniyog cashgänog cananpis munayniyog canäpag pushacalämayna, papá. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tsaynoglami discïpulöcunapagpis gamta manacamö, papá. Paycunataga acrashcanqui maquëcho cawapäcunanpagmi. Tsaymi paycunaga wilacuyniquita yachatsiptë chasquicärishga. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Tsaynog chasquicurmi cananga musyapäcunna lapan yachatsishgäcuna gam munashgayquinogla cashganta. Tsaynogpis yachatsishgäta chasquicurmi tantyapäcushga gam cachamashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Discïpulöcunapag manacamur manami lapan runacunapagtsu manacamö, sinöga maquëman churamushgayqui cagcunalapagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nogapa maquëcho carga gampa maquiquichöpis caycanmi, papá. Paycunaga tantyacärishgami gam cachamashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nogaga gampa naupayquimanna shacamur manami cay patsacho cashagpagnatsu. Paycunami itsanga cay patsacho caycangarag. Tsaymi paycunapag gamta manacamö imaypis yachatsishgänogla cawapäcunanpag. Tsaynogpami nogantsi tsay yarpayla cashgantsinog paycunapis cuyanacur tsay yarpayla cangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cay patsacho cashpä maquëman churamushgayqui cagcunataga lapantami shumag ricashcä. Tsaynog ricaptëmi mayganpis nogaman yäracamashganpita mana witicushgatsu. Jucmi itsanga Satanás munashganta rurar witicushga. Pay witicunanpäga palabrayquicho maynami escribiraycashga. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gampa naupayquiman cutimunäpag captinmi cushishga caycä, papá. Tsaymi discïpulöcunapag gamta manacamö noga cushishga cashgänog paycunapis cushishga cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gampa wilacuyniquita paycunata maynami wilapashcä. Tsayta cäsucur manami waquin runacunanognatsu cawarcaycan, sinöga noga cawashgänognami cawarcaycan. Tsaynog cawaptinmi runacuna paycunata chiquipäcun. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Runacuna chiquiptinpis manami cay patsapita jucla pushacunayquipagtsu gamta manacamö, sinöga cay patsacho cashganyag Satanaspita tsapaycunayquipagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Imanog captinpis naupayquicho cawanäpag cashgannogmi paycunapis naupayquicho cawananpag carcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Wilacuyniquita wilapashgäta paycunata shumag yarpaycatsilay, papá. Wilacuyniquita yarpashpanmi gam munashgayquinog shumag cawapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wilacunäpag cachamashgayquinoglami paycunatapis noga cachaycä ali wilacuyniquita wilacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Munashgayquinog paycuna cawananpagmi nogapis wilacuyniqui nishgannogla cawaycä. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manami paycunalapagtsu gamta manacamö, sinöga paycuna wilacushganta chasquicogcunapagpis manacamömi. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nogantsi juc yarpayla cashgantsinog paycunapis juc yarpayla cananpagmi gamta manacamö, papá. Tsaynog cawashganta ricacurmi cachamashgayquita tantyar waquin runacunapis chasquicamangapag. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nogantsi cuyanacur cawashgantsinog paycunapis cuyanacur cawapäcunanpagmi wilacuyniquita yachatsishcä. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Cuyanacur cawapäcunanpagmi paycunawan imaypis caycäshag. Tsaynoglami gampis nogawan caycanqui. Cuyanacur cawapäcushganta ricarmi cachamashgayquita tantyashpan waquin runacunapis chasquicamangapag. Tsaynogpis tantyapäconga nogata cuyamashgayquinog paycunatapis cuyashgayquita. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Lapan acrashgayqui cagcuna gloriacho nogawan canantami munä. Gloriacho carnami ricapäcamanga pasaypa chip-chipyaycar munayniyog cashgäta. Tsaynogmi cargä cay patsata manarag camaptintsipis. Tsaynog munayniyog caycagta ricamänantami munä, papá. ");
INSERT INTO qvmNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","26","“Gam imata munashgayquitapis runacuna manami tantyantsu. Nogami itsanga tantyä, gampa naupayquipita shamushga car. Chasquicamagcunapis munashgayquita tantyananpagmi paycunata yachatsishcä. Wanushgäpita cawarircamur mastapis munashgayquita yachatsishagragmi. Tsaynogpami cuyanacushgantsinog paycunapis cuyanacur cawangapag. Tsaycunatami gamta manacamö, papá.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tayta Diosta Jesús manacuyta usharcurmi discïpuluncunawan tsimpapäcorgan Cedrón nishgan ragrata. Tsimparirnami chayapäcorgan Olivos yöracuna cashgan chacraman. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Discïpuluncunawan Jesús cadala tsayman aywashga captinmi Jesusta entregag cag Judas Iscariote musyargan tsayman aywapäcushganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tsaymi Jesuspa contran cag runacunata pushacurcur Judas tsayman aywargan Jesusta entregananpag. Tsay runacunaga cargan mandag cüracuna y fariseo runacuna cachashgan wardiacuna y atsca soldäducunami. Paycunami aywapäcorgan atsquincunawan y espädancunawanpis. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Prësu tsarinanpag shamushganta musyaycarpis Jesús aywargan tsay runacunawan tincunanpag. Tincurmi caynog taporgan: “¿Pitatag gamcuna ashircaycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tsauraga caynog nipäcorgan: “Nazaret marcapita cag Jesustami ashircaycä.” Tsaymi Jesús nergan: “Nogami caycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús: “Nogami caycä” niptinmi lapan runacuna mantsarishpan ancalaypa tunicärergan. Judas Iscariotipis paycunawanmi caycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tsauraga Jesús yapay taporgan: “¿Pitatag ashircaycanqui?” Niptinmi yapay nipäcorgan: “Nazaret marcapita cag Jesustami ashircaycä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tsauraga Jesús nergan: “Maynami nishcä noga cashgäta. Nogata ashimarga nogalata prësu apapäcamay. Discïpulöcunataga ama tsaripäcuytsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tsaynog pasananpagmi discïpuluncunapag mayna caynog nergan: “Discïpulöcunataga shumagmi ricashcä nogaman yäracamashganpita mayganpis mana witicärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tsauraga Simón Pedro espädanta jorgurir juc runapa derëcha cag rinrinta roguriycorgan. Tsay runa cargan más mandag cürapa ashmayninmi. Paypa jutinmi cargan Malco. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tsaynog ruraptinmi Pedruta Jesús nergan: “¡Espädayquita cutitsiy churaräcunanman! Wanunäta Taytä munaptenga listumi caycä wanunäpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nircurnami Jesusta liyacurcur lapan soldäducuna mandagninwan y wardiacunapis payta apapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nircurnami chayatsipäcorgan Anaspa wayinman. Anasga cargan Caifaspa suedrunmi. Caifasga cargan más mandag cürami. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Autoridä mayincunata Caifasga maynami caynog nergan: “Tsay runala wanutsun lapantsi salvacunantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedruwan jucag discïpulunmi Jesusta gatirargan caru guepalanta. Jucag discïpulunmi más mandag cürawan reguinacushga car sawan rurinman yaycorgan Jesuspa guepanta. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroga quëdacuycorgan punculachömi. Tsaymi puncucho cuidag warmita más mandag cürawan reguinacog discïpuloga ruwacorgan Pedrutapis ruriman yaycatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tsaymi puncucho cuidag warmi Pedruta caynog taporgan: “¿Manacu gampis tsay runapa discïpulun caycanqui?” Tsauraga Pedro nergan: “Manami nogaga paypa discïpuluntsu cä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tsauraga fiyupa gasaptinmi ninata ratarcatsir mashacurcaycargan ashmaycuna y templo täpag wardiacunapis. Tsaychömi Pedrupis paycunawan mashacuycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tsaypitanami Jesusta Anás taporgan discïpuluncuna pï cashganta y imata yachatsishgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","Tsaymi Jesús caynog nergan: “¿Imanirtag tsaynog tapumanqui? Nogaga manami imatapis pacaylapaga yachatsishcätsu. Sinagogacunacho y templuchöpis yachatsiptë lapan runacunami mayamashga. Yachatsishgäta mayamag runacunata tapumuy. Paycunami musyan imata yachatsishgätapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tsaynog niptinmi juc wardia Jesusta lagyargan caynog nir: “¿Imanirtag más mandag cürata tsaynog ninqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tsaynog niptinmi Jesús nergan: “¿Imatatag mana alita parlashcä? Mana alita parlashga captëga mä tantyatsimay. Lutanta mana parlaycaptëga ¿imanirtag lagyamanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nircurnami liyashgalata Jesusta Anás apatsergan más mandag cüra Caifás cagman. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tsayyagmi Simón Pedro mashacuycargan waquin runacuna mashacuycashgan cagcho. Tsaycho mashacuycaptinmi caynog nipäcorgan: “¿Gampis manacu tsay runapa discïpulun canqui?” Tsauraga Pedro nergan: “Nogaga manami paypa discïpuluntsu cä.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Maylantanami más mandag cürapa ashmayninpis caynog nergan: “Gamta paywan caycagtami ricashcä olivos yöracuna cashgan chacracho.” (Tsaynog neg runapa castanpa rinrintami Pedro rogurergan.) ");
INSERT INTO qvmNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tsauraga Pedro yapay caynog nergan: “Manami paypa discïpuluntsu cä.” Tsaynog niycaptinmi gällu cantarcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Patsa manarag waraptinmi Caifaspa wayinpita Jesusta apapäcorgan Pilätupa despächunman. Payga Roma autoridämi cargan. Israel autoridäcunami itsanga tsayman mana yaycapäcorgantsu caynog nishpan: “Roma runapa wayinman yaycorga leynintsi nishgannog Pascua aniversario micuycunata manami micushunpagnatsu.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsaymi despächunpita yargurir Pilato taporgan caynog nir: “¿Ima jutsatatag cay runa rurashga cayman apamunayquipäga?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tsaynog tapuptinmi nipäcorgan: “Jutsayog captinmi cayman apapäcamushcä. Jutsan mana captenga manami apapäcamömantsu cargan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tsauraga Pilato caynog nergan: “Noga juzganäta munarga wilapäcamay ima jutsan cashgantapis. Sinöga, payta apacäriy leyniquicuna escribirashgannog quiquiquicuna juzgapäcunayquipag.” Tsaynog niptinmi Israel runacunapa autoridänincuna nipäcorgan: “Musyashgayquinogpis nogacunaga manami munayniyogtsu carcaycä pitapis wanutsinäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tsaynog nirmi Pilätuta manacärergan Jesusta cruzcho wanutsinanpag. Cruzcho wanutsiptinmi cumplergan Jesús crucificashga cananpag nishganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Despächunman Pilato yaycurirmi Jesusta gayaycur taporgan caynog nir: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tsauraga Jesús caynog nergan: “¿Musyayta munarcu tsaynog tapumanqui, o Israel autoridäcuna nishuptiquicu tsaynog tapumanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tsaynog niptin Pilato nergan: “Nogaga manami Israel runatsu cä tsaycunata musyaycänäpäga. Marca mayiquicunawan mandag cüracunami prësu apamushushcanqui. ¿Imatatag rurashcanqui prësu apamushunayquipag?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tsauraga Jesús nergan: “Nogaga manami cay patsacho mandagtsu cä. Cay patsacho mandag captëga nogaman yäracamagcuna pelyanmanmi cargan autoridäcuna prësu mana tsarimänanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tsaynog niptin Pilato taporgan: “¿Tsaynog captenga rasunpacu Israel runacunapa mandagnin rey caycanqui?” Tsauraga Jesús nergan: “Au, gam nishgayquinoglami mandag rey caycä. Mandag rey canäpagmi cay patsacho yurishcä. Tsaynogpis cay patsaman shamushcä Tayta Diosnintsipa wilacuyninta wilacunäpagmi. Tayta Diosnintsipa wilacuyninta chasquicogcunaga nishgäcunata chasquicärinmi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tsaynog niptin Pilato nergan: “¿Cantsuragpis manatsuragpis Diospa wilacuynenga?” Jesusta tapurcushpan despächunpita Pilato yapay yargurir Israel runacunapa autoridänincunata caynog nergan: “Noga manami tarëtsu cay runapa ima jutsantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gamcunaga musyapäcunquimi Pascua aniversariucho juc prësuta cacharinäpag cashganta. ¿Munapäcunquicu Israel runacunapa mandagnin rey Jesusta cacharinäta?” ");
INSERT INTO qvmNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsaynog niptin nipäcorgan: “¡Barrabasta cachariyga! ¡Jesustaga ama cachariytsu!” Barrabasga cargan Romacho mandag emperadorpa contranmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mana cacharinanpag nipäcuptinmi Pilato astatsergan Jesusta. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldäducunami cashapita corönata rurarcur Jesuspa umanman jatipargan. Tsaynogpis puca-chicnu cäpata aylupargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nircurnami Jesusta lagyashpan caynog nipäcorgan: “¡Alabashga catsun Israel runacunapa mandagnin rey!” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Despächunpita Pilato yapay yargurcur caynog nergan: “Yapaymi tsay runata jorgamushag jutsaynag cashganta tantyapäcunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tsaynog nirmi Jesusta jorgamorgan cashapita rurashga corönan jatishgata y puca-chicnu cäpan jatishgata. Tsauraga Pilato nergan: “¡Ricapäcuy cay runata!” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tsauraga Jesusta ricaycurmi Israel runacunapa autoridänincunawan templo täpag wardiacunapis nipäcorgan: “¡Crucificashga catsun! ¡Crucificashga catsun!” Tsaynog nipäcuptinmi Pilato nergan: “Crucificashga cananta munarga quiquiquicuna crucificay ima, ari. Nogaga manami ima jutsantapis paypata tarëtsu wanutsishga cananpäga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tsaynog niptinmi tsay autoridäcuna nipäcorgan: “Cay runaga: ‘Diospa tsurinmi cä’ nishganpita wanutsishga catsun. Tsaynog negcuna wanutsishga cananpagmi leynëcunacho niycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","“Diospa tsurinmi cä” nishganta wilapäcuptinmi Pilato fiyupa mantsarergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tsauraga despächunman cutiycur Jesusta yapay taporgan caynog nir: “¿Gam maypitatag caycanqui?” Tsaynog tapuptin Jesús manami imatapis rimacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tsauraga Pilato nergan: “Tapuycaptëga ¿manacu imatapis contestamanqui? Crucificatsinäpag o cacharinäpagpis munayniyog cashgäta ¿gam manacu musyanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tsaynog niptin Jesús nergan: “Gampa maquiquiman Tayta Dios mana churamaptenga manami ima munayniquipis canmantsu crucificatsimänayquipag ni cacharimänayquipagpis. Tsaymi gampita más jutsayog caycan maquiquiman entregamag cag runa.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tsaynog niptinmi Pilätoga cachariyta munargan. Cachariyta munaptinmi Israel runacunapa autoridänincuna masrag gaparpargan caynog nir: “¡Mandag-tucurmi Jesusga emperador Cesarpa contran caycan! ¡Tsaymi Jesusta cacharerga gampis emperador Cesarpa contran canquipag!” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tsaynog nipäcuptinmi Pilato jorgatsimorgan Jesusta. Nircurnami “Gábata” nishgan alarman aywaycur mandacunan sillëtaman jamacorgan. (Hebreo idiömachöga Gábata nishganga “Läja rumicunawan rurashga” ninanmi.) ");
INSERT INTO qvmNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tsaypitami Israel runacunapa autoridänincunata caynog nergan: “¡Mandagniqui reyta ricapäcuy!” (Tsaycuna pasargan viernes pulan junagmi. Tsay tardi sábado jamay junag galaycorgan.) ");
INSERT INTO qvmNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tsauraga runacuna fuertipa caynog nipäcorgan: “¡Wanutsishga catsun! ¡Wanutsishga catsun! ¡Crucificatsiy!” Tsaymi Pilato nergan: “¿Mandagniquita crucificatsinätacu munapäcunqui?” Tsauraga cürapa mandagnincunami caynog nipäcorgan: “¡Nogacunapa mandagnëga emperador Cesarlami! ¡Paypita juc mandagnëga manami pipis cantsu!” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tsaynog nipäcuptinmi Jesusta Pilato entregaycorgan crucificashga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tsaymi Jesusta apapäcorgan cruzta umrurcatsir “Calavëra” nishgan jircaman. (Hebreo idiömachöga Gólgota nipäcun tsay jircata.) ");
INSERT INTO qvmNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tsayman chayaycatsirnami Jesusta crucificargan. Tsaynogmi ishcay runacunatapis crucificapäcorgan Jesuspa ishcan naupanman. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tsaypitanami Pilato clävatsergan cruzpa puntanman juc letrëruta. Tsay letrëruchömi caynog escribirargan: “Nazaretpita cag Jesús, Israel runacunapa mandagnin reymi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jerusalenpa cercalancho crucificashga captinmi Israel runacuna atsca liyipäcorgan tsay letrërucho escribiraycagta. Tsay letrëroga escribirargan hebreo, latín y griego idiömacunachömi. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tsaymi mandag cüracuna caynog nipäcorgan Pilätuta: “ ‘Israel runacunapa mandagnin reymi’ nerga ama escribirätsuntsu, sinöga: ‘Israel runacunapa mandagnin rey-tucogmi’ nishpan escribirätsonga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tsaynog niptin Pilato nergan: “Escribishgäga escribishganami caycan.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesusta crucificaycurnami paypa röpanta tsaycho cag chuscu soldäducuna aypunacärergan. Rurincho cag jatirashgan röpata aypunacunanpagmi itsanga, costüraynag captin, caynog nipäcorgan: ");
INSERT INTO qvmNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Tsaytaga ama rachishuntsu, sinöga suertitarag jitashun maygantsipis apacunantsipag.” Tsaynogpami cumplergan Tayta Diospa palabrancho Jesuspag caynog escribirashgan: “Suertitami jitapäcushga mayganpis röpäta apacunanpag.” Tsay nishgannoglami soldäducuna rurapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Crucificaraycashgan cagchömi caycargan Jesuspa maman, mamanpa nanan, Cleofaspa warmin María y María Magdalenapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tsaymi mamanta y cuyashgan discïpulunta ricärishpan Jesús caynog nergan: “Mamä, nogapa trucä Juannami wawayqui canga.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nircurnami cuyashgan discïpuluntapis caynog nergan: “Cananga mamäta ricayculanqui mamayquitanog.” Jesús tsaynog niptinmi tsay junagpitana mamanta pushacorgan wayinman. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wanunanpag carnami Tayta Diosnintsipa palabrancho escribiraycashgan cumplinanpag Jesús caynog nergan: “Yacunaycämi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tsaychömi soldäducuna upunanpag cag pochgog vïnu caycargan wichi junta. Tsaymi gueru puntanman hisöputa rurarcur tsay pochgog vïnuman ushmarcatsir Jesusta shogutsiyta munargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tsay vïnuta yawarcurnami Jesús nergan: “Lapantanami cumplishcä.” Tsaynog nircushpannami wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua aniversariucho sábado jamay junag galaycunanpagna caycaptinmi Israel runacunapa autoridänincuna mana munapäcorgantsu pipis crucificaraycar quëdananta. Tsaymi Pilätuta manacärergan cruzcho wanuyta nacaycagcunapa chancancunata paquircur cruzpita jorgunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsaymi soldäducuna aywaycushpan Jesuspa naupancho crucificaraycag runacunapa chancancunata paquipäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesuspa chancancunatami itsanga manana paquergannatsu, wanushgana caycagta tariycur. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wanushgana caycaptinpis lapsha pachanpa Jesusta tucsergan juc soldädo. Tsaynog tucsiptinmi yargamorgan yawarwan yacu. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jesuspa discïpulun carmi lapan tsaycunata ricargä. Tsaymi imanog cashgantapis escribiycä salvamagnintsi Cristo cashganta gamcunapis criyipäcunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lapan tsaycunaga pasargan: “Manami ni juc tululanpis paquishgatsu canga” nir Tayta Diosnintsipa palabrancho escribiraycashgan cumplinanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“Runacuna ricapäcongami tucsishganta” nir escribiraycashganpis cumplerganmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tsaypitami Arimatea marcapita José jutiyog runa Pilätuta manacorgan caynog nir: “Jesuspa ayanta cachapaycalämay pampag apanäpag.” Israel autoridäcunata mantsacushpanmi payga Jesusman yäracushganta mana wilacorgantsu. Manacushganta Pilato auniptinmi Jesuspa ayanta apargan pampananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tsaynogmi Nicodemupis paywan aywargan quimsa arröba mïrra y aloe nishganta apacurcur. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Israel runacunapa costumbrin cashgannogmi tsay apashganta Josëwan Nicodemo säbanasman winapäcorgan. Winarcurnami Jesuspa ayanta pitupäcorgan pampananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta crucificashgan naupanchömi cargan frütacuna plantarashgan juc huerta. Tsaychömi cargan pitapis manarag pampapäcushgan mushog sepultüra. ");
INSERT INTO qvmNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sábado jamay junag galaycunanpagna captinmi tsay sepultüralamanna Jesusta pampapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo tutami María Magdalena tsaca tsacala aywargan Jesús pamparaycashgan cagman. Tsayman chayarmi tarergan sepultüra tsaparag rumi wititsishga caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsayta ricaycurmi cörrila cutergan Jesús cuyashgan discïpulunta y Simón Pedruta wilananpag. Chayaycurnami paycunata caynog wilargan: “¡Jesuspa ayantami apacärishga! ¡Manami musyapäcötsu maypa apacärishgantapis!” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Tsaynog wilaptinmi Pedruwan Jesús cuyashgan discïpulun cörrila aywargan Jesús pamparashgan cagman. Pedruta yalirirmi puntata jucag discípulu chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tsaychönami punculapita watgaycur ricargan säbanaslana caycagta. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Simón Pedrumi itsanga ruriman yaycorgan. Tsaychömi paypis säbanaslata tarergan. Jesuspa umanta watapashgan träputapis juc läducho churaraycagtami tarergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsaypitaragmi jucag discïpulunpis ruriman yaycur Jesús cawarimushganta criyergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tsaynog caycaptinpis manami tantyapäcorganragtsu Tayta Diospa palabrancho cawarimunanpag escribiraycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsaypitanami discïpuluncuna cuticärergan posädarashgan wayiman. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Marianami itsanga pamparashgan cagman cutiycur wagar puncucho quëdacorgan. Wagaycashgancho ruriman watgaycurmi ricargan ishcay angilcuna yorag röpashga caycagta. Jucag jamaraycargan Jesuspa uman cashgan cagcho y jucagnami jamaraycargan chaquin cashgan cagcho. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tsay angilcunami Mariata taporgan caynog nir: “¿Imanirtag wagaycanqui?” Tsaynog tapuptin caynog nergan: “Jesuspa ayantami apacärishga, tayta. Manami musyätsu maypa apacärishgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tsaynog nir ticraycushganchömi Jesusta ricargan. Itsanga manami reguergantsu pay cashgantaga. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tsaymi Jesús caynog taporgan: “¿Imanirtag wagaycanqui? ¿Pitatag ashiycanqui?” Tsauraga huertacho arog runa cashganta yarparmi María nergan: “Maymanpis Jesuspa ayanta apashga carga shuntacunäpag wilaycalämay, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tsauraga Jesús caynog nergan: “¡María!” Mariata jutinpa gayaptinmi tantyargan Jesús cashganta. Tsaymi “¡Raboni!” nergan. Raboni ninanga yachatsicog ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nircurmi Jesús nergan: “Ama tsarimaytsu. Manaragmi Taytä cagman cutishcäragtsu. Tsaypa trucanga ayway wilamuy discïpulöcunata Taytäman cuticunäpag cashganta. Paycunaga wauguëcunami caycan. Nogapa Taytäga gamcunapapis taytayquimi y Diosnëga gamcunapapis Diosniquimi.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tsaynog niptinmi María jucla aywargan Jesús yuripashganta y nishgancunatapis wilananpag. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jesús cawarimushgan tsacaymi discïpuluncuna juntacargan juc wayiman. Israel runacunapa autoridänincunata mantsacurmi puncuta trancacurcur carcaycargan. Tsaycho carcaycaptinmi elagpita paycunapa naupancho Jesús ricacorgan. Nircurnami saludargan caynog nir: “Tayta Diosnintsi yanapayculäshunqui ali cawanayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tsaynog nirmi maquinta y lapsha pachanta ricatsergan. Tsaymi Jesusta ricaycur discïpuluncuna pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tsaypitana Jesús yapay caynog nergan: “Tayta Diosnintsi yanapayculäshunqui ali cawanayquipag.” Nircurna nergan: “Taytä cachamashgannoglami gamcunatapis cachaycä wilacuynëta wilacärinayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tsaynog nishpanmi discïpuluncuna cagman pücashpan caynog nergan: “Santu Espirituta chasquipäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Cananpitaga nogata chasquicamagcunata tantyatsinqui jutsancunapita perdonashgana cashganta y mana chasquicamagcunataga wilanqui jutsancunapita mana perdonashga cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Discïpuluncuna juntaraycashgan cagman Jesús chayananpäga Milïshu nishgan Tomás manami tsaychötsu cargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomaswan tincurnami waquin cag discípulu mayincuna caynog wilapäcorgan: “¡Señornintsi Jesustami ricapäcushcä!” Tsauraga Tomás nergan: “¡Quevä! Rasunpa cawarimushganta criyinäpäga maquinman clävo yaycushgantaragmi ricäman y tsayman dëdötaragmi jatëman, tsaynogpis lapsha pachanpa tucsishgantaragmi yatäman.” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tsaypita juc semänata discïpuluncuna yapay juntacargan juc wayiman. Tsaychömi itsanga Tomaspis caycargan. Tsaycho puncuta trancacurcur carcaycaptinmi Jesús paycunapa naupancho elagpita yurircur saludargan caynog nir: “¡Tayta Diosnintsi yanapayculäshunqui ali cawanayquipag!” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nircurnami Tomasta nergan: “Tomás, maquëta ricay y clävo yaycushganman dëduyquita jatiy. Lapsha pachäpa tucsimashgantapis yatay. ¿Imanirtag cawarimushgäta mana criyinquitsu?” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tsaynog niptinmi Tomás nergan: “¡Gamga Diosnëmi canqui, tayta!” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusnami nergan: “¿Ricaycamarragcu criyinqui? ¡Mana ricaycämarpis cawarimushgäta criyegcunaga cushishgami cangapag!” ");
INSERT INTO qvmNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Atsca milagrucunatami Jesús rurargan discïpuluncuna ricaycaptin. Tsaycunaga manami lapantsu cay librucho escribiraycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Cay librucho cagcunaga escribiraycan Jesusga salvamagnintsi Cristo cashganta y Diospa tsurin cashganta criyipäcunayquipagmi. Tsaymi payta chasquicorga gloriacho cushishgala imayyagpis cawapäcunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsaypitanami Tiberias nishgan lagüna cuchuncho Jesús yapay discïpuluncunata yuripargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tsay lagüna cuchunchömi caycargan Simón Pedro, Milïshu nishgan Tomás y Natanaelpis. Natanaelga cargan Galilea provinciacho Caná marcapitami. Zebedeupa ishcan tsurincuna más ishcay discípulu mayincunapis tsaychömi carcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tsaymi Simón Pedro caynog nergan: “Pescädo tsaregmi aywaycä.” Tsaynog niptinmi discípulu mayincuna nergan: “Nogacunatapis yanapanäpag pushaycalämay.” Tsauraga büquiman witsarcur lapan aywargan. Tsay tsacay waraylata pescacuycarpis manami ni juc pescädulatapis tsaripäcorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Patsa waraycaptinnami discïpulucuna ricargan juc runa lagüna cuchuncho caycagta. Itsanga manami musyapäcorgantsu Jesús cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Paymi caynog gayacorgan: “¿Naganacu pescäduta tsaripäcushcanqui?” Tsauraga discïpulucuna caynog nergan: “Manami ni juclaylatapis tsaripäcöragtsu, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tsaymi Jesús discïpulucunata caynog nergan: “Redniquita mashtapäcuy büquipa derëcha cag lädunman. Tsaypitami pescäduta tsaripäcamunquipag.” Nishgannog redta mashtarnami tsaripäcorgan tsaytsica pescäduta, hasta tsutaytapis mana puëdishganyag. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tsauraga cuyashgan cag discïpulun Jesús cashganta reguiycur Pedruta caynog nergan: “¡Payga Jesusmi!” Tsaynog niptinmi jorgushgan cag röpanta jaticurcur Simón Pedro jucla Jesús cagman nadyaypa aywargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquin cag discïpuluncunami itsanga büquiwan aywapäcorgan. Lagüna cuchunpita pachac (100) metrunogla captinmi red junta pescäduta yacu cuchunman garachapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tsayman chayarnami redta cachaycur büquipita yargapäcorgan. Tsaychömi taripäcorgan shansha janancho pescädo cancashga caycagta y tantatapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tsauraga Jesús caynog nergan: “Tsay tsaripäcamushgayqui pescäduta juc ishcayta apamuy cancanantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tsaynog niptinmi Simón Pedro büquiman witsarcur redta garachamorgan pescäducunata shuntapäcunanpag. Tsay redchöga cargan pachac pitsga chunca quimsa (153) jatusag pescäducunami. Tsaytsica pescädo caycaptinpis red manami rachergantsu. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tsauraga Jesús nergan: “Micunantsipag shapäcamuyna.” Jesús cashganta musyarmi maygan discïpulunpis mana tapupargantsu pï cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús cashgan cagman chayaptinnami tantata y pescäduta paycunata ayporgan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tsaywanga quimsa cutinami discïpuluncunata Jesús yuripargan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micuyta usharcurnami Jesús taporgan Simón Pedruta caynog nir: “Jonaspa tsurin Pedro, ¿lapanpitapis mascu gam cuyamanqui?” Tsaynog tapuptin Pedro nergan: “Au tayta, gam musyanquimi cuyashgäta.” Tsauraga Jesús nergan: “Tsaynog carga mitsicog runa uyshancunata ricashgannog nogaman yäracamagcunata shumag ricanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús yapay taporgan Simón Pedruta: “Jonaspa tsurin Simón, ¿gam cuyamanquicu?” Tsaynog tapuptin Pedro nergan: “Au tayta, gam musyanquimi cuyashgäta.” Niptinmi nergan: “Tsaynog carga mitsicog runa uyshancunata ricashgannog nogaman yäracamagcunata shumag ricanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tsaypita Jesús yapay taporgan Simón Pedruta: “Jonaspa tsurin Simón, ¿gam rasunpacu cuyamanqui?” Quimsa cuti Jesús tsaynogla tapuptinmi Pedro laquishga nergan: “Gam lapantapis musyanquimi, tayta. Tsaynogpis musyanquimi gamta cuyashgäta.” Niptinmi Jesús nergan: “Tsauraga mitsicog runa uyshancunata ricashgannog nogaman yäracamagcunata shumag ricanqui. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mözularag carga quiquilayquimi röpayquita jaticorgayqui maypapis munashgayquipa aywanayquipag. Auquinna captiquinami itsanga ricrayquita mashtarcuptiqui jucna röpayquita jatipäshunquipag. Tsaynogpis aywayta mana munashgayquipami apashunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tsaynog nirmi Jesús tantyatsergan payman yäracushganpita Pedro crucificaypa wanutsishga cananpag cashganta. Nircurnami Pedruta caynog nergan: “Nishgäcunata imaypis cumpliy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Tsaypitanami Pedro ticrarcamur Jesús cuyashgan cag discïpulunta ricargan pay cagman aywaycagta. Payta ricärirmi Jesusta caynog taporgan: “Tayta, paytaga ¿imatag pasanga?” (Manarag Jesús wanuptinmi cuyashgan discïpulun naupalancho micorgan. Tsaychömi payta taporgan maygan discïpulun contran sharcunanpag cashgantapis.) ");
INSERT INTO qvmNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pedro tsaynog tapuptinmi Jesús nergan: “¿Imanirtag paypag tapuycämanqui? Cutimunäyag cawanan captinpis gamga nishgäcunata lapanta cumpliy.” ");
INSERT INTO qvmNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tsaynog niptinmi waquin discïpulucuna yarpapäcorgan tsay cuyashgan discïpulun imaypis mana wanunanpag cashganta. Tsaynog yarpapäcuptinpis Jesusga manami mana wanunanpag cashgantatsu nergan, sinöga: “Cutimunäyag cawanan captinpis ¿imanirtag paypag tapuycämanqui?” nergan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesuspa cuyashgan discïpulun carmi caycunata escribishcä. Lapan escribishgäcunaga rasun caglami caycan. ");
INSERT INTO qvmNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús rurashgancunaga cay escribishgäcunapitapis masragmi caycan. Lapan rurashgancunata escriberga manami imaypis ushämantsu cargan. Amén.");
INSERT INTO qvmNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Jesucristo lapan rurashgancunata y yachatsishgancunatami punta cag libröcho escribimorgä. Tsayta escribimorgä ima pasashgancunatapis gam musyanayquipagmi, Teófilo. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Jesús wanushganpita cawarircamurnami ciëluman manarag aywacur apostolnincunata chuscu chunca (40) junagyag atsca cuti yuripargan. Rasunpa cawarimushganta musyapäcunanpagmi tucuynogpa paycunata tantyatsergan. Nircurmi paycunata nergan Santu Espíritu yanapaptin wilacuyninta wilacur puripäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Apostolnincunawan Jesús caycashpanmi paycunata caynog nergan: “Jerusalenpita maypapis amarag aywacunquiragtsu. Tsaypa trucanga jinalancho shuyarpanqui Taytä promitishgan Santu Espirituta chasquinayquipag. Santu Espirituta chasquinayquipag cashgantaga maynami nergä. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Naupataga Juan Bautista yacuwanmi runacunata bautizargan. Cananmi itsanga gamcuna Santu Espirituwan bautizashga canquipag. Tsaynog bautizashga canayquipäga walca junaglanami pishiycan.” ");
INSERT INTO qvmNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesucristuwan juntacashga caycarmi apostolnincuna taporgan caynog nir: “Tayta, ¿canantsurag cay Israel nacionpita Roma runacunata gargunqui, paycunapa maquincho capäcushgäpita gampa maquiquichöna capäcunäpag?” ");
INSERT INTO qvmNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tsaynog tapuptinmi Jesús caynog nergan: “Imaypis tsay pasananpag cashgantaga Tayta Dioslami musyan. Paylami munayniyog caycan tsaycunata rurananpäga. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tsaynog captinpis Santu Espíritu gamcunaman shamuptinmi poderninta chasquinquipag. Tsayta chasquircurmi wilacuynëta wilacärinquipag Jerusalencho, Judea provinciacho, Samaria provinciacho y may-tsay nacioncunachöpis.” ");
INSERT INTO qvmNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tsaynog parlayta usharcuptinmi Tayta Diosnintsi gloriaman Jesusta pushacorgan. Apostolnincuna ricarpaycaptinmi pucutay rurinman yaycur elgacäcorgan. Tsaypitaga mananami ricapäcorgannatsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tsaynog ricarpaycaptinmi elagpita ishcay runacuna yorag röpashga naupancho ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tsay runacunami caynog nergan: “Galilea runacuna, ¿imanirtag jana patsapa ricarpaycanqui? Naupayquipita Jesucristo jana patsaman aywacushganta ricapäcushgayquinoglami yapay cutimongapag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tsauraga Olivos lömacho caycashganpitami Jesucristupa apostolnincuna cuticärergan Jerusalenman. Tsay lömapita Jerusalenman cargan pulan lëwanoglami. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chayaycushpannami witsäpäcorgan posädarashgan altusman. Paycunami cargan Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeupa tsurin Santiago, Simón “Celote” nishgan y Santiagupa tsurin Judas. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tsay wayichömi Tayta Diosta manacärinanpag imaypis paycuna juntacag. Paycunawanmi juntacag Jesucristupa maman María, Jesucristupa wauguincuna y waquin warmicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tsay junagcunami Jesucristuman yäracogcuna pachac ishcay chuncanog (120) juntacargan apostolcunawan. Tsaymi Pedro caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","19","“Waugui-panicuna, musyashgantsinogpis Judas Iscariote nogacunawanmi purergan. Paytapis apóstol cananpagmi nogacunatanogla Jesús acrargan. Tsaynog acrashga caycarpis Judasmi runacunata pushargan Jesusta prësu tsaripäcunanpag.” (Tsaynog pushashganpita guellayta chasquishganwanmi chacrata rantergan. Tsay chacrachömi uray sengaypa jegacorgan pachan pashtagpag. Tsaypitami Jerusalencho tag runacuna tsay chacrapa jutinta churapargan “Acéldam” nir. Acéldama ninanga “Yawar Pampa” ninanmi.) Nircurmi Pedro mastapis caynog nergan: “Jesucristuta entregar Judas wanunanpag cashganta musyarmi rey Davidta Santu Espíritu tantyatsergan Judaspita escribinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tsay escribishganga Salmo librucho caynog nirmi escribiraycan: ‘Tashgan wayi cacharishga catsun. Ama pipis tsaycho tätsuntsu.’ Tsaynoglami juc salmuchöpis Judaspita caynog escribiraycan: ‘Pay rurananpag cagta jucna ruratsun.’ “Tsay salmo escribirashgannoglami Judasta pasashga. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Tsaymi juctana churashun paypa trucan apóstol cananpag. Tsay runata acrashun Jesús bautizacushganpita-patsa hasta jana patsaman cuticushganyag paywan puregta. Jesucristuwan tsaynog puregcunaga nogantsiwanmi caycan. Tsaymi paycunapita maygantapis jucta churashun Judaspa trucan apóstol cananpag. Paymi nogacunanog apóstol car Jesús cawarimushganta wilacur purenga.” ");
INSERT INTO qvmNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro tsaynog niptinmi ishcay runacunapag yarpapäcorgan. Jucmi cargan Matías. Jucagnami cargan José. Waquin runacuna Josëta nipäcog Barsabás y waquinnami nipäcog Justo. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Paycunapita mayganpis apóstol cananpag cashganta musyananpagmi Tayta Diosnintsita manacärergan caynog nir: “Tayta, gammi musyanqui lapan runacunapa shongun imanog cashgantapis. Tsaymi canan munapäcö cay ishcay runacunapita mayganta acrashgayquitapis musyatsimänayquita. ");
INSERT INTO qvmNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mayganpis acrashgayqui cagmi apostolniqui canga Judas Iscariotipa trucan. Judasga jutsata rurarmi apóstol caycashganpita yargucushga destïnunman aywacunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tayta Diosta tsaynog manacurishpanmi suertita jitapäcorgan. Tsaymi suerti yargamorgan Matiaspag. Tsauraga tsay junagpitanami Matiaspis Jesucristupa apostolninna cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jesucristo cawarimushganpita ganchis semänata Pentecostés fiesta junagmi Jesucristuman lapan yäracogcuna juc wayicho juntacashga carcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tsaycho jamarpaycaptinmi elagpita mayacämorgan fiyupa gaparar shucucuy wayranogpis jana patsapita aywaycämushgan. Tsayga chayargan paycuna juntaraycashgan wayimanmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsaymi tsay wayicho juntaraycagcuna ricapäcorgan mechëro rataycagnogla ninacuna paycunaman chayagta. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tsay hörami Santu Espirituta lapan chasquipäcorgan. Santu Espíritu parlatsiptinmi paycuna parlapäcorgan imaypis mana parlashgan idiömacunapa. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tsay witsanmi may-tsay nacioncunapitapis Israel runacuna Jerusalenman chayapäcorgan Pentecostés fiestapag. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tsaymi tsay wayicho shucucuy wayranog gaparashganta mayashpan runacuna tsayman aywapäcorgan ima pasashgantapis ricananpag. Tsaychömi lapanpis mayapäcorgan may-tsaypitapis shamog runacunapa idiömancunacho parlarcaycagta. Tsaynog parlashganta mayarmi cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tsaynog cushicushpanmi caynog nipäcorgan: “Lapan cay parlaycagcunaga ¿manacu Galilea runacuna carcaycan? ");
INSERT INTO qvmNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Galilea runacuna caycarga ¿imanogpatag paycuna yachacushga nogantsipa idiömantsicho rimananpag? ");
INSERT INTO qvmNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Shamushcantsi Partiapita, Mediapita, Elampita, Mesopotamiapita, Judeapita, Capadociapita, Pontupita, Asiapita, ");
INSERT INTO qvmNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptupita, Libiacho cag Cirenipa cercancunapita y Romapitapis. Waquinnintsega yurishgantsipita-patsami Israel runacuna caycantsi. Y waquinnintsinami mana Israel runacuna caycarpis Diosta chasquicushcantsi Israel runana canantsipag. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretapitapis, Arabiapitapis caycho juntacashgami caycantsi. May-tsaypita captintsipis quiquintsipa idiömantsichömi Tayta Diosnintsipa wilacuyninta parlapaycämantsi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tsaymi pasaypa cushicur quiquinpura parlapäcorgan caynog nir: “¿Imatag pasaycan?” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tsaynog niptinmi burlacushpan waquin runacuna caynog nipäcorgan: “Caycunaga shincashga carmi imata rimashgantapis mana musyapäcuntsu.” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tsaynog niptinmi apóstol mayincunawan jamarpaycashganpita ichircushpan Pedro caynog nergan: “Jerusalencho y may-tsaychöpis tag Israel mayëcuna, shumag mayapäcamay. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Manami gamcuna yarpashgayquinogtsu nogacuna shincashga carcaycä. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tsaypa trucanga Tayta Diosnintsipa profëtan Joel escribishgannoglami canan cumpliycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Paymi Tayta Diosnintsi nishgancunata caynog escribergan: ‘Tiempo chämuptinnami Santu Espirituta cachamushag lapan chasquicamagcunaman. Santu Espirituta chasquicurnami nogapa wilacuynëta wilacärenga olgu tsuriquicuna y warmi tsuriquicunapis. Mözucunapis noga ricatsishgäcunatami elagpita ricangapag. Tsaynoglami auquincunata sueñuynincunacho ima pasananpag cagcunatapis musyatsishag. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tsay witsanmi munashgäta ruragcunaman Santu Espirituta cachamushagpag. Tsaynogpami warmipis olgupis wilacuynëta wilacongapag. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ciëluchömi ricacätsimushag imaypis mana ricapäcushgayquita. Intimi tsacacäconga. Quillami yawar-nirag ricacäconga. Cay patsachöpis runacuna pasaypa wanutsinacogtami ricapäcunquipag. May-tsaychöpis rupaptinmi cay patsa goshtaywan quilushga caycagta ricapäcunquipag. Tsaypitaragmi chämonga noga juzganä junag. Tsay chämushgan junagnöga manami imaypis yapay canganatsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tsaynog cananpag captinpis nogata manacamag cäga salvashgami cangapag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tayta Diosnintsipa profëtan Joel tsaynog escribishganta yarparcatsirmi Pedro caynog nergan: “Israel mayëcuna, cay parlamushgäcunata shumag mayapäcamay. Nazaret marcapita cag Jesusga Tayta Diosnintsi cachamushgan runami cargan. Tsaynog cashgantaga Tayta Diosnintsi musyatsimashcantsi milagrucunata ruraptinmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tsaynog caycaptinpis gamcunami Jesusta prësu tsarircur jutsasapa runacunapa maquinman entregashcanqui crucificaypa wanutsinanpag. Tsaynog entregaptiquimi Tayta Diosnintsi palabrancho escribirashgancuna cumplergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tsaynog wanutsiptinpis manami wanushgalanchöga usharashgatsu. Tsaypa trucanga Tayta Diosnintsimi payta cawaritsimushga. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tsaynog cawarimunanpag cashganpitami rey David caynog escribergan: ‘Imaypis nogawanmi caycanqui, Tayta Dios. Tsaymi imatapis mana mantsacötsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Shongöpis cushicunmi. Cushishgalami cantashagpis. Tsaymi gamman yäracular cawaycä. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Munashgayquita ruraptëmi almäta Hadischo mana cachanquipagtsu. Tsaynogpis manami cacharinquipagtsu pamparashgalächo ayä ismunanta. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gammi tantyatsimashcanqui munashgayquinog cawanäpag. Imaypis yanapamaptiquimi cushishgala cawaycä.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tsaynog David escribishganta wilapayta usharcurmi Pedro caynog nergan: “Israel mayëcuna, tsaynog escribir unay rey David manami quiquinpitatsu escribergan, sinöga Jesucristupitami. Musyantsimi David wanur maynincho pamparashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tayta Diosnintsipa profëtanmi rey Davidga cargan. Paytami Tayta Diosnintsi nergan castanpita juc runa yurir imayyagpis mandag rey cananpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tsaymi Davidga quiquinpag escribinanpa trucan tsay yurinanpag cagpita escribergan. Payga salvamagnintsi Jesucristumi caycan. Jesucristo cawarimushganta ricaycagnogpis paypagmi David escribergan Hadischo almanta Tayta Dios mana cacharinanpag cashganta y cuerpun pamparashgalancho mana quëdananpag cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","David escribishgannoglami Jesucristuta Tayta Diosnintsi cawaritsimushga. Cawarircamur puriptinmi lapanë ricapäcushcä. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cawarircatsimurnami Jesusta derëcha cag lädunman Tayta Diosnintsi jamatsishga lapanpagpis munayniyog cananpag. Tsaypitanami Tayta Diosnintsi promitishgan Santu Espirituta nogacunaman cachamushga. Tsaynog cachamushga captinmi juc idiömacunapa parlatsipäcamashganta canan mayarcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Shumag tantyacäriy. Davidga manami wanushganpita cawarircamur jana patsaman witsashgatsu. Señornintsi Jesucristumi itsanga wanushganpita cawarircamur jana patsaman witsashga. Jana patsaman witsarcur Tayta Diospa naupanman jamacunanpag cashganpitami David caynog escribergan: ‘Mandag reyta Tayta Diosnintsi caynogmi nergan: “Jamacamuy derëcha cag naupäman lapan contrayquita vincinäyag.” ’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tsaypita Pedro yapay caynog nergan: “Israel mayëcuna, shumag tantyacäriy. Gamcuna Jesusta cruzcho wanutsishga captiquipis Tayta Diosnintsimi payta churashga maquincho tsararämänantsipag y salvamagnintsi cananpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tsaynog niptinmi runacuna fiyupa laquicushpan tapupäcorgan Pedruta y waquin cag apostolcunatapis caynog nir: “Tsaynog captenga ¿imatatag rurapäcöman?” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tsaymi Pedro caynog nergan: “Tayta Diosnintsi jutsayquicunata perdonashunayquipag jutsa rurashgayquita cacharir Jesucristupa jutincho bautizacäriy. Tsaynogpami gamcunapis Santu Espirituta chasquicunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Santu Espiritutaga manami nogacunalapagtsu Tayta Diosnintsi cachamushga. Tsaypa trucanga cachamushga gamcunapag, tsuriquicunapag y Jesucristuta chasquicogcunapäga may-tsaycho taptinpis lapanpagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro mastapis tantyatsergan caynog nir: “¡Waquin runacuna jutsata rurar cawaptinpis gamcunaga ama jutsata rurapäcuytsu!” ");
INSERT INTO qvmNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tsauraga Pedro nishganta chasquicogcuna lapanmi tsay junag bautizacärergan. Tsay bautizacogcunaga cargan quimsa waranganogmi (3,000). ");
INSERT INTO qvmNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Paycunami imaypis juntacag apostolcuna yachatsishgancunata yachacärinanpag, Santa Cënata upupäcunanpag y Tayta Diosnintsita manacunanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolcuna milagrucunata rurashganta ricarmi lapan yäracogcuna espantashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Paycunaga imaypis juntacashpanmi cashganpita imatapis nistashganman-tupu raquipänacog. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tsaynogmi chacrancunatapis y imaycancunatapis ranticäreg. Tsay guellaytanami nistashganman-tupu aypunacäreg. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Waran waranmi templo patiuman juntacag Tayta Diosta manacärinanpag. Wayincunachöpis juntacashpan Santa Cënata upurcur cushishgalami micuytapis micapäcog. ");
INSERT INTO qvmNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Paycunaga imaypis Tayta Diosta agradëcicäreg yanapashganpita. Lapan runacunami paycunata respitapäcog. Tsaynogpis waran waranmi runacuna Jesucristuta chasquicäreg. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc junagmi, malway inti caycaptin, Pedruwan Juan imaypis aywashgannog templuman aywargan Tayta Diosta manacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tsaychömi juc runa caycargan yurishganpita-patsa ishcan chaquin wanushga. Tsay runatami waran waran castancuna apapäcog templucho “Cuyaylapag” nishgan puncuman. Tsay puncuchömi templo patiuman yaycogcunata limushnata manacog. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedruwan Juan templo patiuman yaycuycagta ricarmi paycunatapis tsay runa limushnata manacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsaynog manacuptinmi Pedro caynog nergan: “¡Ricapäcamay!” ");
INSERT INTO qvmNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tsaymi tsay runa paycunata ricarargan imalawanpis yanapananpag cashganta yarpashpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nircurmi tsay runata Pedro caynog nergan: “Manami guellaynëpis ni öröpis cantsu gamta yanapanäpag. Tsaynog captinpis ¡Nazaret marcapita cag Jesucristupa jutincho jucla sharcur puriy!” ");
INSERT INTO qvmNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tsaynog nishpan Pedro derëcha cag maquinpita tsarircur sharcatsiptinmi jinan höra chaqui moguncunapis sänu ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsauraga jucla sharcurcur tsay runa puriyta galaycorgan. Nircurmi paycunawan templo patiuman yaycorgan cushicuypita saltashpan y Tayta Diosta alabashpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Tayta Diosta alabashpan saltaycachar puriycagta ricarmi lapan runacuna cushicärergan. Tsaymi caynog nipäcorgan: “¡Ricay! ¡Cuyaylapag nishgan puncucho limushnata manacog mana pureg runa puriycanna!” ");
INSERT INTO qvmNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tsauraga ishcan chaquin wanushga cashganpita sänag runa manami cachaycorgantsu Pedruta y Juanta. Paycuna Salomón nishgan alarcho caycagta ricarmi runacuna cushicushpan tsayman cörrila aywapäcorgan ricapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chayaptinnami runacunata Pedro caynog nergan: “Israel mayëcuna, ¿imanirtag nogacunata ricapaycämanqui? Manami quiquëcunapa munaynëwantsu ni jutsaynag cashgäpitatsu cay runata aliyätsishcä. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tsaypa trucanga Jesucristupa munayninwanmi aliyätsishcä. Paytami Abraham, Isaac, Jacob y unay Israel runacuna yäracushgan Tayta Diosnintsi churashga lapanpita más munayniyog cananpag. Tsaynog captinpis gamcunaga payta autoridäcunaman entregashcanqui wanutsishga cananpag. Pilato cachariyta munaptinpis gamcunaga manami munapäcushcanquitsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tsaypa trucanga Pilätuta manacärishcanqui jutsayog cagta cacharir jutsaynag alilata rurag cagta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tsaynogpami wanutsipäcushcanqui cawayta gomagnintsita. Tsaynog wanutsiptiquipis paytami Tayta Diosnintsi cawaritsimushga. Cawarircamur yuripämaptinmi nogacuna ricapäcushcä. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Paymi aliyätsishga puriyta mana puëdeg runata. Jesucristuman yäracäriptëmi ricapäcushgayquinogpis cananga sänuna caycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Israel mayëcuna, gamcuna y autoridänintsicunapis manami tantyapäcushcanquitsu salvamänantsipag Tayta Diosnintsi payta cachamushganta. Tsaynog mana tantyarmi Jesusta wanutsipäcushcanqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tayta Diosnintsipa unay profëtancuna maynami escribergan Cristuta runacuna wanutsinanpag cashganta. Tsaymi gamcuna payta wanutsipäcuptiqui cumplishga tsay profëtacuna escribishgannogla. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Cananga Cristuta wanutsishgayquipita perdonashunayquipag Tayta Diosta manacäriy. Tsaynogpis jutsa rurashgayquicunata cacharir pay munashgannogna cawapäcuy. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tsaynogpami Tayta Diosnintsi lapan jutsa rurashgayquicunata perdonashuptiqui cushishga cawapäcunquipag. Tsaynogpis Jesucristuta gamcunaman yapay cachamonga munaynincho lapantapis tsararänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cutimunanpag cag höra manarag chämuptinmi Jesucristoga ciëluchörag caycan. Cutimurnami lapantapis churanga Tayta Dios munashgannogna cananpag. Tsaynog cananpag cashgantaga Tayta Diosnintsipa profëtancuna unaypita-patsami wilacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Tsaynogmi Moisespis unay Israel runacunata Jesucristo shamunanpag cashganta wilapargan caynog nir: ‘Tayta Diosnintsimi castantsipita juc runata churanga noganog wilacog cananpag. Payta gamcunaga cäsucäriy.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mastapis Moisés caynogmi nergan: ‘Pipis tsay wilacogta mana cäsucog cäga juzgashgami canga.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Moisés wilacushgannogmi Tayta Diospa waquin profëtancunapis wilacärergan canan witsan pasaycashganta. Tsaynog wilacärergan Samuel wilacushganpita-patsami. ");
INSERT INTO qvmNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tsaymi Jesucristuta chasquicuptiqui profëtacuna wilacushgannogla Tayta Diosnintsi salvashunquipag. Tsaynogpami Tayta Diosnintsi cumpliycan Abrahamta, Isaacta y Jacobta caynog nir promitishganta: ‘Gampita miragpitami pï-may runacunapis bendicionta chasquengapag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abrahamta promitishgannoglami Jesucristuta chasquicur tsay bendicionta chasquiycantsi. Tsay bendicionga jutsa rurashgantsicunata cacharir Tayta Dios munashgannog cawanantsipag Jesucristo salvamashgantsimi caycan. Paytami Tayta Diosnintsi nogantsiman cachamorgan waquin runacunapita gamcuna puntata payta chasquicunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro y Juan tsaycho wilacuycaptinmi chayargan cüracuna y saduceucunapis. Tsaynogpis chayargan templo täpag wardiacunapa capitanninpis. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paycuna chayaycurmi mayargan Pedro y Juan caynog nir yachaycätsishganta: “Wanushganpita Jesús cawarimushga captinmi lapantsipis wanushgantsipita cawarimushunpag.” Tsaynog yachatsishganta mayarmi fiyupa rabiacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tsaynog rabiacushpanmi Pedruta y Juanta prësu tsaripäcorgan. Tardina captinmi carcilman wichgaycärergan wara tutayag. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tsaynog captinpis Pedro y Juan wilacushgancunata mayar atscagmi Jesucristuta chasquicärergan. Tsay chasquicogcunaga cargan pitsga waranganogmi (5,000), warmicunata ni wamracunatapis mana yupaylapa. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wara tutanami Jerusalencho juntacargan Israel runacunapa autoridänincuna, Israel mayor runacuna y Moisés escribishgan leycunata yachatsegcunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Paycunawanmi juntacargan cüracunapa más mandagnin Anaspis. Tsaychömi caycargan Caifás, Juan, Alejandro y Anaspa waquin castancunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsaycho lapan juntacaycur Pedruta y Juanta carcilpita jorgarcatsimur tapupäcorgan caynog nir: “¿Ima munayniquiwantag gamcuna aliyätsishcanqui ishcan chaquin wanushga runata? Tsaynog aliyätsinayquipäga ¿pitag gamcunata cachamushushcanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tsauraga Santu Espíritu valorta goptin Pedro caynog nergan: “Israel mayor runacuna, mayapäcamay. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Ishcan chaquin wanushga runata imanogpa aliyätsishgätapis musyayta munapäcuptiquega canan tantyatsishayqui imanogpa aliyätsishgätapis. Paytaga aliyätsishcä Nazaret marcapita cag Jesuspa jutinchömi. Jesustami gamcuna crucificaypa wanutsipäcushcanqui. Tsaynog wanutsipäcuptiquipis paytaga Tayta Diosnintsimi cawaritsimushga. Tsayta musyapäcuy gamcuna y Israelcho tag lapan runacunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tsaymi Tayta Diosnintsipa palabrancho Jesuspag caynog niycan: ‘Wayi sharcatsegcuna: “Manami alitsu cay rumi” nir jitariycuptinpis wayi esquïnaman cimientupag tsay rumi churashganami caycan.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tsaymi Jesucristo japalan salvamagnintsi caycan. Manami paypita más jucga cantsu salvamänantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tsauraga ishcan apostolcuna mana mantsacuypa wilacäriptinmi autoridäcuna quiquinpura caynog nipäcorgan: “Paycunaga shumag mana estudiashga caycar ¿imanogpatag tsaynog ali wilacärin?” Tsaynogpami tantyacärergan Jesuspa discïpuluncuna cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tsaymi imata niytapis mana camäpacorgantsu, tsay aliyätsishgan runa tsaycho captin. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Tsauraga Pedruta y Juanta wagtaman jorgarcatsir quiquinpura wilanacärergan caynog nir: “¿Imatatag rurashun paycunata? Jerusalencho tag lapan runacunami musyan tsay runata aliyätsishganta. Tsaytaga manami ñëgashwantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Waquin marcacunachöpis tsay aliyätsishgan mana mayacänanpag paycunata mandashun cananpitaga Jesuspita pitapis manana wilapänanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsaynog wilanacurcurmi apostolcunata wagtapita gayarcatsimur caynog nipäcorgan: “Canan junagpitaga ama pitapis Jesuspita wilapanquitsu ni yachatsinquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Niptinmi Pedro y Juan caynog nipäcorgan: “Shumag tantyacäriy, taytacuna. Manami alitsu canman Tayta Diosnintsita cäsucunäpa trucan gamcunata cäsucuptëga. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ricapäcushgäta mayapäcushgätaga nogacuna pitapis wilapäshagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ishcan chaquin wanushga runata aliyätsishganpita lapan runacuna Tayta Diosnintsita alabaptinmi autoridäcuna paycunata manana castigargannatsu. Tsaypa trucanga caynog nergan: “Tsaynogla wilacur puriptiquega castigashayquimi.” Tsaynog anyaparcurmi cacharergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jesuspa munayninwan sänag runaga chuscu chunca (40) watapita masnami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro y Juan carcilpita yargurirna aywapäcorgan waugui-panicuna juntaraycashgan wayiman. Paycunatami wilapargan mandag cüracuna y Israel mayor runacuna jurapashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tsaynog wilapaptinmi lapanpis Tayta Diosta manacärergan caynog nir: “Tayta Dios, gammi camashcanqui jana patsatapis, cay patsatapis, lamartapis y lapan imacunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Santu Espiritupa munayninwanmi rey Davidta tantyatsishcanqui caynog nir escribinanpag: ‘¿Imanirtag runacuna rabiashga carcaycan? ¿Imanirtag manacagcunata wilanacärin? ");
INSERT INTO qvmNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tsaynoglami más mandag autoridäcunapis juntacaycur wilanacärin Tayta Diospa contran y cachamushgayqui salvacogpa contranpis sharcapäcunanpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Rey David escribishgancho nishgannoglami Herodispis, Poncio-Pilätupis, Israel mayëcunapis y may-tsaypita shamog runacunapis cay Jerusalén marcacho juntacargan cachamushgayqui Jesucristupa contran sharcapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Paypa contran sharcunanpag cashgantaga unaypita-patsami musyashcanqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cananpis autoridäcuna jurapämashganta ricaycanquimi, Tayta Dios. Gamlamanmi nogacuna yäracärë. Canan valorta goycalämay, wilacuyniquita mana mantsacuypa wilacärinäpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yanapaycalämay Jesucristupa jutincho gueshyagcunata aliyätsinäpag y milagrucunatapis rurapäcunäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tayta Diosta manacuyta usharcuptinmi juntaraycashgan wayi sicsicyargan. Tsaymi Santu Espíritu paycunata valorta gorgan Jesucristupa wilacuyninta mana mantsacuypa wilacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tsaycho Jesucristuman lapan yäracogcuna, atsca carpis, tsay yarpaylami capäcorgan. Quiquincunapag quëdatsicunanpa trucanga lapantami aypunacäreg. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mana mantsacuypami apostolcunaga Señornintsi Jesucristo cawarimushganta wilacäreg. Jesucristuta chasquicogcunata Tayta Diosnintsi lapanchöpis shumagmi yanapargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Paycunaga manami mayganpis muchorgantsu. Muchuycho pipis mana cananpagmi chacrancunata wayincunata ranticuycur tsay guellayta apostolcunaman apapäcog. Paycunanami muchuycho cagcunata aypupäcog nistashganman-tupu. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tsaynoglami rurargan José jutiyog runapis. Pay cargan Leví castami. Tsaynogpis cargan Chipre islapitami. Paypa cuyay jutintami apostolcuna churapargan “Bernabé” nir. Tsay jutega “cuyapäcog runa” ninanmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Paypis chacranta ranticuycurmi apostolcunaman guellayta apargan paycunana tsay guellaywan wactsacunata yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tsaychömi caycargan Ananías warmin Safirawan. Paycunapis wilanacurirmi chacranta ranticärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tsaymi ishcan yachatsinacurcur chacranta ranticushgan guellayta raquicurergan. Nircur waquilantana apostolcunaman Ananías apargan: “Caylami chacräpa chanin guellay” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tsaynog lulacuptinmi Pedro caynog nergan: “Ananías, ¿imanirtag Satanás yätsishushgayquita chasquipar Santu Espirituta lulapaycanqui? ¿Imanirtag waquin guellayta raquicurir: ‘Caylami chacräpa chanin guellay’ niycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ranticärishgayqui chacraga ¿manacu quiquiquicunapa cashga? Chacrayquipa chanin guellaypis ¿manacu quiquiquicunapana cashga? Tsaynog caycaptenga ¿imanirtag tsaynog rurashcanqui? Runacunata lulaparpis Tayta Diosta manami lulapayta camäpacunquipagtsu.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pedro tsaynog nishganta mayarmi Ananías jinan höra wanorgan. Tsaynog wanushganta musyarmi runacuna fiyupa mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mözucuna chayaycamurmi Ananiaspa ayantana piturcur pampananpag apapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsaypita quimsa höratanog chayargan Ananiaspa warmin Safira. Pay manami musyargantsu runan wanushganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tsauraga Pedro caynog taporgan: “Mä wilamay. ¿Runayqui apamushgan guellaylachöcu chacrayquita ranticärishcanqui?” Tsauraga Safira caynog nergan: “Au, tsaylachömi ranticärishcä.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Niptin Pedro nergan: “Santu Espíritu musyaycaptin ¿imanirtag yachatsinacushcanqui lulacärinayquipag? ¡Ricay! Puncuchönami carcaycan runayquipa ayanta pamparcur cutimog mözucuna. Lulacushgayquipita canan gampis runayquinoglami wanunquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tsauraga jinan hörami Pedrupa naupancho Safirapis wanorgan. Tsaypita mözucuna yaycur tarergan wanushgana jitaraycagta. Tsaymi paytapis apapäcorgan runanpa naupanman pampananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ananiaswan Safira lulacushganpita wanushganta musyaycurmi waugui-panincuna y waquin runacunapis fiyupa mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Runacuna ricaycaptinmi Diospa munayninwan apostolcuna milagrucunata rurapäcog. Tsaynogpis Tayta Diosnintsiman yäracogcuna imaypis templuman juntacag Salomón nishgan alarman. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ananiasta Tayta Diosnintsi tsaynog castigashganta musyaycurmi waquin runacuna paycunawan mana juntacargannatsu. Paycunawan mana juntacarpis paycunata alimi respitapäcog. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ali wilacuyta mayagcunaga waran waranmi warmipis olgupis Jesucristuta chasquicärergan. Tsaynogpami más atscayargan Jesucristuman yäracogcuna. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cällipa Pedro pasaptinmi gueshyagcunata jorgapäcamog cämantinta caynog yarpashpan: “Pedro pasaptin lantuynilanpis jananman chayaptenga aliyangami.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Cercacho cag marcacunapitapis gueshyagcunata y demonio nacatsishgancunatapis apacurcurmi Jerusalenman runacuna shapäcamog. Tsay apashgan gueshyagcunatami apostolcuna lapanta aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gueshyagcunata aliyätsishganta musyarmi más mandag cüra y paywan pureg saduceo runacunapis apostolcunapa contran sharcapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tsaymi prësu tsarircatsir carcilman wichgatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tsay tsacaymi Tayta Diosnintsipa angilnin chayaycur cárcil puncucunata quichapargan. Nircurmi wagtaman jorgurir apostolcunata caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aywapäcuy templupa jatun patiunman. Tsaycho runacunata wilapanqui Jesucristuta chasquicuptin Tayta Diosnintsi salvananpag cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tsauraga templupa jatun patiunman wara tuta apostolcuna yaycapäcorgan. Tsaychömi ángil nishgannogla runacunata wilapargan. Más mandag cüranami cüra mayincunawan gayatsimorgan Israel runacunapa lapan autoridänincunata sesionta rurapäcunanpag. Paycunawan wilanacurcurmi wardiacunata cachargan carcilpita apostolcunata jorgamunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wardiacuna carcilman chayaycushpan manami taripäcorgannatsu apostolcunata. Tsauraga cutiycushpan caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Cárcil puncuta shumag wichgaraycagtami taripäcushcä. Prësu cuidagcunatapis puncucunacho ichirpaycagtami taripäcushcä. Ruriman yaycurmi itsanga maygan prësutapis mana taripäcushcätsu.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tsayta mayaycurmi más mandag cürapis, templucho wardiacunapa capitanninpis y waquin mandag cüracunapis yarpachacärergan: “¿Imanogparag gueshpishga? ¿Imatarag masta rurapäconga?” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tsaynog yarpachacurcaycaptinmi juc runa chayaycur caynog nergan: “¡Carcilman wichgapäcushgayqui runacunaga templo patiuchömi runacunata yapay yacharcaycätsin!” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsaynog niptin wardiacunata pushacurcur capitán aywargan apostolcunata prësu tsarimunanpag. Mana magaylapami prësu tsarircur apapäcorgan runacuna sagmananta mantsacushpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tsaymi apostolcunata chayatsergan autoridäcuna juntacashga caycashganman. Tsaychönami más mandag cüra caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“¿Manacu gamcunata nipäcushcä imaypis Jesuspita manana yachatsinayquipag? Tsaynog niycaptëga ¿imanirtag yacharcaycätsinqui runacunata? Nircurpis nogacunata jitapaycämanqui: ‘Paycunami Jesusta wanutsishga’ nir.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tsaynog niptin Pedro y waquin cag apostolcunapis caynog nipäcorgan: “Runacunata cäsucunäpa trucanga Tayta Diosnintsitami cäsucushag. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gamcuna Jesusta crucificaypa wanutsiptiquipis unay Israel mayintsicuna yäracushgan Tayta Diosnintsimi wanushganpita cawaritsimushga. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nircurmi lapanpita más munayniyog cananpag payta derëcha cag lädunman jamatsishga. Tsaynogpis churashga mandamagnintsi y salvamagnintsi cananpagmi. Tsaynog churashga carmi payta chasquicogcunata lapantapis jutsa rurashgancunata perdonashga. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tsaycunata wilacärinäpagmi Santu Espirituta Tayta Diosnintsi nogacunaman cachamushga. Pï-maytapis pay nishganta cäsucogtaga Santu Espíritu yanapaycanmi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tsaynog nipäcushganta mayaycurmi autoridäcuna pasaypa rabiacushpan wanutsiyta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Paycunawanmi caycargan Moisés escribishgan leycunata yachatseg juc fariseo runa. Paypa jutinmi cargan Gamaliel. Lapan runacunami payta respitapäcog. Paymi wardiacunata mandargan apostolcunata wagtaman rätula jorgunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tsaynog jorgarcatsirmi tsaycho caycag autoridäcunata caynog nergan: “Israel mayëcuna, cay runacunapa contran imatapis manarag rurar shumag yarpachacäriy. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Yarpapäcunquicu juc cuticho Teudas jutiyog runa: ‘Yachag runami cä’ nir sumätsir purishganta? Paytami gatirpargan chuscu pachac (400) runacuna. Tsaynog puriycagta wanuycatsiptin gatiragnincuna wacpa caypami mashtacar aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsaypita censacuy cashgan witsan purergan Galilea provinciapita shamog Judaspis. Tsaynoglami paytapis wanuycatsiptin lapan gatiragnincuna, atsca carpis, mashtacar aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tsaymi noga yätsë cay runacunapa contran mana sharcunantsipag. Tsaypa trucanga paycunata amana cäsupäshuntsu. Quiquinpa yarpaynilanpita wilacuptenga tsaylachönami usharanga. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tayta Diosnintsipa wilacuynin captenga imata ruraptintsipis sïguengami. Shumag mana yarpachacur paycunata wanutserga cuidädu Diospa contran ruraycashwan.” ");
INSERT INTO qvmNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tsaymi Gamaliel nishganta cäsucärishpan apostolcunata manana wanutsergannatsu. Wanutsinanpa trucanga cutiycatsimurmi astatsergan. Astarcatsirmi caynog nergan: “¡Cananpitaga amana wilacärinquitsu Jesuspita!” Tsaynog juraparcurmi cacharergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Cachariptinmi apostolcuna cushishga aywacärergan. Tsaynog cushicärergan Jesucristu-raycu autoridäcuna astashganpitami. ");
INSERT INTO qvmNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Autoridäcuna michaycaptinpis paycunaga waran waranmi runacunata yachatsergan: “Jesusga salvamagnintsi Cristumi” nishpan. Tsaynoglami templo patiucho y wayicunachöpis wilacäreg. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Apostolcuna tsaynog wilacäriptinmi Jesucristuta chasquicärergan atsca runacuna. Tsay chasquicogcuna waquincuna cargan griego idiömata rimagcuna y waquincunanami cargan hebreo idiömata rimagcuna. Paycunacho wactsa viüdacuna captinmi waran waran micuyta aypupäcog. Hebreo rimag viüdacunata más yanapaptinmi griego rimagcuna jamurpar caynog nipäcorgan: “Griego rimag cag viüdacunata mana cäsuypami hebreo rimagcunaga quiquinpurala micuyta aypunacärin.” ");
INSERT INTO qvmNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","4","Tsaynog nipäcuptinmi Jesucristuman yäracogcunata shuntarcur apostolcuna caynog nipäcorgan: “Waugui-panicuna, micuycunata aypupäcunanpäga nogantsipita acrashun ganchis yäracog mayintsicunata. Paycuna catsun respitashga runacuna, Santu Espíritu munashgannog cawag y ali yarpayniyog. Tsaynogpami nogacunapa tiempö canga Tayta Diosnintsita manacärinäpag y ali wilacuyninta wilacur purinäpagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tsaynog wilanacurcurmi ganchis yäracog mayincunata acrapäcorgan. Paycunapa jutincuna cargan Esteban, Felipe, Prócoro, Nicanor, Timón, Parmenas y Antioquía marcapita cag Nicolaspis. Nicolasga naupatanami Tayta Diosta chasquicur cuerpunta señalacorgan Israel runa cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nircur tsay acrashgan ganchis wauguicunapa umanman maquinta churaycur apostolcuna Tayta Diosnintsita manacärergan paycunata yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tsaymi Jesucristupa wilacuyninta Jerusalencho wilacäriptin Jesucristuman yäracogcuna atscayargan. Tsaynoglami waquin cüracunapis chasquicärergan tsay wilacuyta. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebantaga Tayta Diosnintsi shumagmi yanapargan pay munashgannog cawar wilacuyninta wilacunanpag. Tsaynogpis yanapargan atsca milagrucunata rurananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tsaynog milagrucunata rurar Jesucristupa wilacuyninta wilacuptinmi paywan rimanacärergan waquin Israel mayincuna. Tsay runacuna cargan Cirene marcapita, Alejandría marcapita, Cilicia provinciapita y Asia provinciapitapis. Paycunami juntacargan “Ashmay cashganpita yargushga” nishgan sinagogacho. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Santu Espiritupa munayninwan Esteban parlaptinmi rimanacurpis paycunaga imata contestaytapis mana camäpacorgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsaymi tsay runacuna pacaylapa waquin runacunata pägapäcorgan Estebanpa contran sharcur autoridäcunata caynog nipäcunanpag: “Moisespa y Tayta Diosnintsipa contranmi Estebanga rimaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tsaynog nishganta mayaycurmi Israel mayor runacuna, Moisés escribishgan leycunata yachatsegcuna y waquin runacunapis fiyupa rabiacärergan. Nircurnami Estebanta prësu tsarircur apapäcorgan más mandag autoridäcuna juntacashganman. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tsaymanmi pägashgan cag runacunata pushapäcorgan Estebanpa contran caynog ninanpag: “Cay runaga templuntsipa contran y Moisés escribishgan leycunapa contranmi imaypis rimaycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tsaynogpis cay runaga nishga Tayta Diosnintsipa templunta Nazaret marcapita cag Jesús juchutsinanpag cashganta. Tsaynogpis yachaycätsin Moisés escribishgan leycunata mana cäsucunantsipagmi. Tsaynog parlashgantaga quiquëcunami mayapäcushcä.” ");
INSERT INTO qvmNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tsaynog rimapäcuptin autoridäcuna y paycunawan caycagcunapis Estebanpa cäranta ricärishgancho angilpa cärantanog ricapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tsaypita más mandag cüra taporgan Estebanta caynog nir: “¿Rasunpacu cay runacuna nishgannog gam parlashcanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tsauraga Esteban nergan: “Shumag mayapäcamay, taytacuna. Musyashgantsinogpis Abrahamta munayniyog Tayta Diosnintsi yuripargan. Tsaynog yuripargan Mesopotamialachörag taycaptinshi. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tsaycho yuriparcurshi caynog nergan: ‘Taycashgayqui marcata y castayquita cachaycur aywacuy maychöpis tänayquipag ricatsinäpag cagman.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Tsaynog niptinshi Mesopotamiapita Abraham aywacorgan Harán marcacho tänanpag. Taytan Taré wanuycuptinnashi Tayta Diosnintsi pushamorgan taycashgantsi cagmanna. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cayman pushaycamurpis quiquinpa cananpag manashi chacratapis ricatsergantsu. Mana ricatsirpis tsurin manarag captinshi Tayta Diosnintsi Abrahamta caynog nergan: ‘Cay taycashgayqui naciontami gampita miragcunata ricatsishag paycunapana cananpag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tsaynogpis Tayta Diosnintsi payta caynog nergan: ‘Gampita miragcunami chuscu pachac (400) wata juc nacioncho jäpa runacunapa ashmaynin canga. Tsay nacionchömi pasaypa nacapäcongapag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ashmaytanog tsararashganpitami tsay nación runacunata noga castigashagpag. Ashmay caycashganpita yargamurnami caycho cushishgalana tangapag munashgäta rurar.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Tsaypitanashi Abrahamta nergan cuerpunta quiquin señalacunanpag y olgu tsurincuna yuriptin paycunapa cuerpuntapis señalananpag. Tsayshi Tayta Diosnintsi nishgannogla Abraham señalacorgan. Nircurshi tsurin Isaacpa cuerpuntapis señalatsergan yurishganpita pusag (8) junagniyog caycaptin. Tsaynoglashi Isaacpis tsurin Jacobta señalatsergan y Jacobpis chunca ishcay (12) tsurincunata señalatsergan. Tsay chunca ishcay tsurincunapitami lapan Israel runacuna mirashga. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Jacobpa tsurin Josëtashi wauguincuna chiquipäcushpan Egiptupa aywag negocianticunata ranticorgan. Tsay negocianticunanashi Egiptuman chayaycatsir ranticorgan. Egiptuchöpis Tayta Diosnintsi imaypis Josëta yanapagshi. Tsayshi yachag cananpag yanapaptin Egipto nacionpa mandagnin faraón payta churargan palaciuncho arogcunata mandananpag y Egipto naciontapis mandäshinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tsay witsanshi Egipto nacioncho y Canaán nacionchöpis fiyupa usya cargan. Tsayshi unay Israel mayintsicuna micunanpagpis mana cargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egiptuchöshi itsanga usya manarag captin atsca trïguta José pirwatsergan. Muchuy captinnashi tsay pirwashgan trïguta Egiptucho ranticuycashganta musyaycur tsurincunata Jacob cachargan trïgu ranteg aywapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tsaypita trïgu ranteg yapay cutirpis manaragshi tantyapäcorgantsu José paycunapa wauguin cashganta. Tsaynog mana tantyaptinshi José wilapargan paycunapa wauguin cashganta. Nircurnashi mandag faraonwan wauguincunata reguinacatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsaypitana José gayatsergan castancunatawan taytan Jacobta Egipto nacionman. Tsayshi Egiptuman aywagcuna lapan cargan ganchis chunca pitsga (75) runacuna. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tsaynogpashi Egiptuman tsurincunawan Jacob aywargan tsaycho tänanpag. Tsaylachönashi paypis y tsurincunapis wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","“Paycuna wanuycuptinnashi ayanta tsaquircatsir Siquem marcaman apapäcorgan pampapäcunanpag. Tsaychöshi Abraham pamparashgan machayman pampapäcorgan. Tsay machayga Abraham rantishgan chacrachöshi cargan. Tsay chacrataga rantergan Hamor jutiyog runapa tsurincunapitashi. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tayta Diosnintsega manashi gongargantsu Abrahamta caynog nir promitishganta: ‘Gampita miragcunatami Egiptucho ashmay cashganpita noga shuntamushagpag.’ Nishgannogla shuntamunanpag cag tiempo chämunanpagna caycaptinshi Israel runacuna Egiptucho aläpa mirargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tsay witsanshi juc runana yaycorgan Egiptucho mandag faraón cananpag. José wanushgana captinshi payga mana musyargantsu José pï cashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tsayshi Israel runacuna mirananta mana munar tsay mandag faraón waran waran paycunata arutsergan. Tsaynogpis Israel castacho olgu yureg cagtaga yuriylanta wanutsinanpag nergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Tsay witsanshi Moisespis yurergan. Paytashi Tayta Diosnintsi pasaypa cuyargan. Tsaynoglashi taytan mamanpis cuyar wayilancho pacaylapa ashmargan hasta quimsa quillayog cashganyag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tsaypita wanutsinanta mana munashpan Moisesta mayu cuchunman pacaycorgan. Tsayshi faraonpa warmi tsurin shuntacur quiquinpa wawantanog ashmacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsaypita Egiptucho estudiarshi yachag y munayniyog ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chuscu chunca (40) watayog caycarnashi Moisés yarpargan marca mayincunaman watucog aywayta. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yarpashgannogla watucog aywarshi tarergan Israel runata Egipto runa magaycagta. Tsauraga Israel runapa favornin sharcurshi Moisés wanuratsergan tsay Egipto runata. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés yarpargan Egiptupita jorgamunanpag Tayta Diosnintsi acrashganta Israel mayincuna tantyacunantashi. Tsaynog yarpaptinpis Israel mayincunaga Moisesta manashi cäsupargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Tsaypita wara junagshi Moisés tarergan ishcay Israel mayincuna pelyaycagta. Tsayshi paycunata washashpan caynog nergan: ‘Gamcuna tsay castala caycarga ¿imanirtag pelyarcaycanqui?’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tsauraga magag cag runaga Moisesta tangarishpan caynog nergan: ‘Gamta ¿pitag churashushcanqui nogacunapa mandagnë y jueznë canayquipag? ");
INSERT INTO qvmNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Egipto runata ganyan wanutsishgayquinogcu nogatapis wanutsimayta munaycanqui?’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tsaynog niptinshi Moisés fiyupa mantsacorgan, Egipto runata wanutsishganta faraonpis musyashganta yarpashpan. Tsayshi gueshpir aywacorgan Madián partiman. Gorpanogla tsaycho taycaptinshi ishcay olgu tsurincuna yurergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Madiancho chuscu chunca (40) wata taycarnashi Moisés aywargan Sinaí nishgan chunyag jircapa cercanman. Tsaychöshi shiraca rupaycagcho juc ángil yuripargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tsayta ricarshi Moisés ima ruraytapis mana camäpacorgantsu. Tsayshi shumag ricananpag yaycuycashgancho mayargan Tayta Diosnintsi caynog nimogta: ");
INSERT INTO qvmNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Unay castayquicuna Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ Tsayta mayarshi Moisés sicsicyashpan ricäriytapis mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tsaynogpis Tayta Diosnintsi caynog nergan: ‘Caychöga nogami caycä. Tsaynog caycaptenga respitamashpayqui jatirashgayqui llanquiquita jorguy.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nircurnashi nergan: ‘Noga ricaycämi Israel runacuna Egipto nacioncho nacar wagarcaycashganta. Tsaymi Egiptuman gamta cachashayqui paycunata jorgamunayquipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mandagnin ni jueznin Moisés cananta Israel mayincuna mana munaycaptinpis Tayta Diosnintsi rupaycag shiracacho yuripag angilwan paytashi cachargan Egiptupita jorgamunanpag y mandagninpis cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tsayshi Egipto nacionpita Israel mayincunata jorgamunanpag Moisés milagrucunata rurargan Egiptucho y Puca lamarchöpis. Tsaynoglashi chuscu chunca (40) wata chunyag jircacho caycarpis milagrucunata rurargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisesshi Israel mayincunata caynog nergan: ‘Tayta Diosnintsimi gamcunapa castayquipita juc runata churanga noganog wilacog cananpag. Payta gamcunaga cäsucäriy.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tsaynogpis Moisesshi Sinaí jircacho Tayta Diosnintsi cachamushgan angilpita chasquergan mandamientucunata. Tsay mandamientucunatami runacunata yachatsergan Tayta Diosnintsi munashgannog cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Unay Israel runacunaga chunyag tsaqui jircachöpis manashi Moisesta cäsucärergantsu. Mana cäsushpanshi Egiptuman cuticuyta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tsayshi Sinaí jircaman witsashganpita Moisés jucla mana cutimuptin Aaronta caynog nipäcorgan: ‘Manami musyantsitsu Egiptupita jorgamagnintsi Moisesta ima pasashgantapis. Moisés elgashgana caycaptenga yanapamänantsipag örupita juc diosta rurapaycalämay.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsaynog manacäriptinshi örupita rurapargan becërru-nirag ïduluta diosnin cananpag. Nircur tsay rurashgan diosnin paycuna manacushganta mayananpagshi uywacunata wanurcatsir payta adorashpan rupatsipäcorgan. Nircurnashi tsay ïdulupag fiestata rurapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Tsaynog rurapäcuptinshi Tayta Diosnintsi fiyupa rabiacushpan paycunata manana yanapargannatsu. Tsayshi estrellacunamanna, intimanna y quillamanpis yäracur manacärergan. Tsayshi unay profëtan escribinanpag Tayta Diosnintsi caynog nergan: ‘Chuscu chunca (40) wata chunyag jircapa puripäcushpayqui gamcunaga uywacunata altarcho nogapag rupatsirpis janan shongulami adorapäcamashcanqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tsaynog cashcanqui rurashgayqui Moloc ïdulupag yarpäcushga purirmi. Tsaynogpis Refán nishgan ïdulupa estrellan-niragta adorapäcushcanqui. Tsaynog rurapäcushgayquipitami gargushayquipag Babilonia marcaman.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Chunyag tsaqui jircacho unay Israel runacunaga toldërapita rurashga tabernäculutashi puritsipäcorgan tsaycho Tayta Diosta manacur adorapäcunanpag. Tsay tabernäculutaga rurapäcorgan Moisesta Tayta Diosnintsi tantyatsishgannoglashi. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tsay tabernäculuta apacurcurshi Josué y lapan Israel runacuna chämorgan cay taycashgantsi nacionman. Chämuptinshi Tayta Diosnintsi cay marcacunacho tag runacunata gargorgan. Tsaynog garguptinnashi unay Israel runacuna duëño ricacorgan. Tsay tabernäculoga cay marcantsicunachöshi quëdargan rey David cawashgan witsanyag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tayta Diosnintsi yanapaptinshi Davidga templutana sharcatsiyta munargan Tayta Diosnintsipag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tsaynog yarpaptinpis tsurin Salomonragshi sharcatsergan tsay templuta. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Templuta Salomón sharcatsiptinpis lapanpag munayniyog Tayta Diosnintsega manami tantsu runacuna rurashgan templuchöga. Tsayshi unay profëtan escribinanpag Tayta Diosnintsi caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Jana patsaga trönömi. Runa tashgan patsaga chaquë jaruräcunanmi. Tsaynog caycaptenga manami ima wayipis nogapag aypangatsu. Jatuncaray wayita rurapämaptiquipis manami aypanmantsu tsaycho tänäpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nogami camashcä ciëlutapis y runa tashgan patsatapis.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tsaynog nircushpanmi Esteban caynog nergan: “Gamcunaga unay Israel mayintsicunanoglami Santu Espiritupa contran carcaycanqui. Tayta Diosta mana cäsucog cashpayquimi mana yäracog runacunanogla carcaycanqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tayta Diosnintsipa profëtancunata unay runacuna chiquishgannogmi gamcunapis Tayta Diosnintsipa wilacognincunata chiquircaycanqui. Tayta Dios cachamushgan salvacog shamunanpag cashganta wilacuptinpis wanutsipäcushgannogmi gamcunapis Tayta Dios cachamushgan salvamagnintsi Jesucristuta entregapäcushcanqui wanutsishga cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","¡Gamcunaga manami Tayta Diosnintsita cäsucärinquitsu, leynincunata angilcunawan apatsimuptinpis!” ");
INSERT INTO qvmNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban nishganta mayashpanmi autoridäcuna fiyupa rabiacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebannami Santu Espíritu yanapaptin jana patsata ricärishgancho ricargan chip-chipyaycag munayniyog Tayta Diospa derëcha cag läduncho Jesús ichiraycämogta. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tsauraga tsayta ricaycur caynog nergan: “¡Ricaycämi jana patsa quicharaycämogta! ¡Tsaynogpis ricaycämi Diospa derëcha cag läduncho Jesucristo caycämogta!” ");
INSERT INTO qvmNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tsaynog niptin paycuna rinrincunatapis tsapacärergan masta mana mayapäcunanpag. Tsaypita fiyupa rabiashpan Estebanman cörricaycärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nircurna marcapita jorgurcur sagmapäcorgan. Runacuna payta sagmananpag janan cag röpancunata jorgurir paytacärergan Saulo jutiyog mözuta. ");
INSERT INTO qvmNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paycuna sagmaycaptinmi Esteban caynog nir manacorgan: “Señor Jesús, ¡maquiquimanmi almäta cachaycö!” ");
INSERT INTO qvmNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsaypitana gongurpacuycur fuertipa nergan: “¡Cay sagmaycämag runacunata perdonayculay, tayta!” Tsaynog nircushpan wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Estebanta wanutsishganta ricarmi Sauloga cushicorgan. Tsaynog wanutsiptinmi Tayta Diosnintsi munashgannog cawagcuna Estebanpa ayanta pampapäcorgan pasaypa laquicushpan. Estebanta wanutsishgan junagpitanami Jesucristuta chasquicogcunata runacuna pasaypa chiquipäcorgan. Tsaynog captinmi Judea y Samaria provinciacunapa gueshpir aywacärergan. Apostolcunalanami Jerusalencho quëdacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulunami Jesucristuta chasquicogcunata wayin wayin ashir tarishgan cagta warmitapis olgutapis carcilman wichgatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalenpita gueshpegcunami may-tsaychöpis wilacärergan Jesucristo salvamagnintsi cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tsaynogmi Felipipis gueshpir Samaria provinciacho cag juc marcaman aywargan. Tsaychömi runacunata salvananpag Jesucristo shamushganta wilacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jesucristupa munayninwanmi milagrucunatapis Felipe rurargan. Tsayta ricarmi wilacushgantapis atsca runacuna chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tsaynogpis Jesucristupa munayninwan demoniucunata runacunapita garguptinmi gaparashpan yargorgan. Tsaynogmi atsca wegrucunatapis y paralïticucunatapis aliyätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tsaynog ruraptinmi tsay marcacho tagcuna cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","10","Tsaychömi cargan juc brüju. Paypa jutinmi cargan Simón. “Nogaga yachag runami cä” nishpanmi Samaria runacunata naupapita-patsa criyitsergan. Olgupis, warmipis y wamracunapis lapanmi Simón nishgancunata mayashpan caynog nipäcorgan: “¡Cay runataga Tayta Diosnintsimi yanapaycan imatapis rurananpag!” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tsaynog yarpargan Simonga brüju cashpan imatapis rurashganta ricarmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jesucristo salvamagnintsi cashganta Felipe wilacuptinnami runapis warmipis pay wilacushgantana chasquicushpan bautizacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tsaychömi Simonpis Jesucristuta chasquicushpan bautizacorgan. Nircurna milagrucunata Felipe rurashganta ricarmi paywanna cushishga purergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tsaypita Jerusalencho caycag apostolcuna mayapäcorgan Jesucristupa wilacuyninta Samaria provinciacho runacuna chasquipäcushganta. Tsayta musyarmi tsayman cachapäcorgan Pedruta y Juanta. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Tsayman chayaycurmi musyapäcorgan Jesuspa jutincho bautizacushga caycarpis Santu Espirituta paycuna manarag chasquipäcushganta. Tsaymi Pedruwan Juan Tayta Diosnintsita manacärergan paycunapis Santu Espirituta chasquipäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Paycunapa umanman maquinta churaycur tsaynog manacuptinmi Santu Espirituta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Tsauraga Santu Espirituta chasquicushganta ricarmi tsay brüju Simonga apostolcunata caynog nergan: “Tsay munayniquita ranticaycalämay nogapis runapa umanta yataycur manacuptë Santu Espirituta chasquicärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tsaynog niptinmi Pedro caynog nergan: “¿Imanirtag Tayta Diosnintsipa munaynin rantina cashganta yarpaycanqui? ¡Tsaynog yarpashgayquipita guellaynintintami supayniqui apashunqui! ");
INSERT INTO qvmNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","¡Gamga manami Tayta Diosnintsi munashgannogtsu cawaycanqui! ¡Tsaymi Tayta Dios mana yanapashunquipagtsu nogacuna rurashgänog ruranayquipag! ");
INSERT INTO qvmNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lutancunata yarpänayquipa trucanga Tayta Diosta manacuy perdonashunayquipag. Tsaynog manacuptiquega pagta perdonashunquimanpis. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gamga envidiöso car lutan ruraycunatapis manami cacharinquitsu.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tsaynog niptinmi Pedruta y Juanta caynog nergan: “Tsaynog captëga Tayta Diosnintsita manacuyculay perdonaycamänanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tsaycho runacunata yacharcatsirnami Pedro y Juan tsaypita aywapäcorgan Samaria provinciacho cag waquin marcacunachöpis Jesucristupa wilacuyninta wilacärinanpag. Tsaypitanami yapay cuticärergan Jerusalenman. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tsaypita Tayta Diosnintsi cachamushgan ángil Felipita caynog nergan: “Jerusalenpita Gaza marcaman aywag caminupa ayway. Tsay caminoga chunyag jircapami pasaycan.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Tsauraga ángil nishgannog Felipe tsay caminupa aywargan. Tsaynog aywarmi ricargan Etiopía nacionman capashga runa cuticuycagta. Paymi reina Candacipa tesorërun cargan. Tayta Diosnintsita adorag Jerusalenman aywashganpitami tsay runaga cuticuycargan. Tsaypa aywagnog liyiycargan profëta Isaías escribishgan libruta. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tsaymi Felipita Santu Espíritu nergan: “Tsay cärruwan aywaycag runapa naupanman ayway.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tsay nishgannog aywarmi Felipe ricargan tsay Etiopía runa Isaías escribishgan libruta liyiycagta. Tsaymi Felipe taporgan caynog nir: “¿Tantyanquicu tsay liyiycashgayquita?” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tsaynog niptinmi caynog nergan: “Pipis mana tantyatsimaptenga ¿imanogpatag tantyashag? Cayman witsämuy tantyatsimänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tsay liyiycashgan libruchöga caynogmi escribiraycargan: “Wanutsinanpag uyshata apashgannogmi payga apashga cargan. Milwanta rutuptin uysha upälala cashgannogmi payga upälala cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Manacagman churaptinpis manami favornin pipis sharcorgantsu. Payta wanutsipäcushpan pasaypa jutsayogmi ricacorgan.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tsauraga Etiopía runa Felipita taporgan: “Tantyaycatsilämay, tayta. Profëta Isaías cayta escribir ¿pipagtag escribergan? ¿Quiquinpagcu o jucpagcu?” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tsaymi Felipe tantyatsergan tsay liyishgan Jesucristupita escribiraycashganta. Nircurmi tantyatsergan runacunata salvananpag Jesucristuta Tayta Diosnintsi cachamushganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tsaypita aywarcaycashgancho yacu cashganman chayaycur tsay Etiopía runa caynog nergan: “Caycho yacu caycaptenga ¿manatsurag bautizaycalämanquiman?” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tsauraga Felipe nergan: “Lapan shonguyquiwan criyir Jesucristuta chasquicuptiquega bautizashayqui, ari.” Tsaynog niptinmi Etiopía runa caynog nergan: “Rasunpami criyë Jesucristo Tayta Diosnintsipa tsurin cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsauraga aywaycashgan cärruta ichiycatsir yacu cagman uräpäcorgan. Tsaychömi tsay runata Felipe bautizargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","40","Yacupita yargarcamuptin Santu Espíritu Felipita Azoto marcacho elagpita ricacätsimorgan. Tsaypitaga Etiopía runa Felipita mananami ricargannatsu. Payta mana ricarpis cushishgami marcanpa aywacorgan. Felipinami marcan marcan purergan Jesucristupa wilacuyninta wilacushpan. Tsaynog wilacuraycarmi Cesarea marcaman chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Saulunami Jesucristuta chasquicogcunata wanutsiyta yarpar prësu tsareg aywargan. Tsaymi más mandag cüraman aywargan ordinta jorgamunanpag. Tsay ordinwannami Damascuman aywargan sinagogacunacho Jesucristuta chasquicogcunata tarerga warmitapis olgutapis prësu apananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tsauraga tsay ordinwan Damasco marcaman chayaycaptinnami elagpita atsqui payman chip-chipyämorgan jana patsapita. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsaynog chip-chipyämuptinmi pampaman Saulo tunicorgan. Tsaychönami mayargan jana patsapita caynog nimogta: “Saulo, Saulo, ¿imanirtag nogapa conträ sharcuycanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tsayta mayarmi taporgan: “¿Pitag canqui, tayta?” Tapuptinmi caynog nergan: “Nogaga Jesucristumi caycä. Yäracamagcunata gaticacharga nogapa conträmi caycanqui. Tsaynog rurashpayquega picata jaytag törunogpis quiquiquimi nacanquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tsayta mayarmi mantsacashga sicsicyashpan Saulo caynog nergan: “¿Imata ruranätatag munanqui, tayta?” Tsaynami Jesús nergan: “Ayway Damasco marcaman. Tsaychönami nishunquipag imata ruranayquipag cashgantapis.” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauluwan aywaycagcunaga parlamushganta mayarpis manami pitapis ricapäcorgantsu. Pitapis mana ricarmi fiyupa mantsacargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tunishganpita sharcur Saulo gaprayashgana car manami imatapis ricargantsu. Tsaymi paywan aywag runacuna janchaylapa chayatsipäcorgan Damasco marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tsaycho quimsa junagmi gaprayashgala cargan. Manami micuytapis micorgantsu ni yacutapis uporgantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascuchömi targan Jesucristuta chasquicog Ananías. Paytami Jesucristo yuriparcur caynog nergan: “¡Ananías!” Niptin nergan: “¿Imatag, tayta?” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tsaynog niptinmi Jesucristo nergan: “Ayway Derëcha nishgan cälliman. Judaspa wayinman chayaycur tapucunqui Tarso marcapita Saulo jutiyog runapag. Tsay wayichömi Tayta Diosta pay manacuycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Manacuycashganchömi ricashushcanqui payman chayaycashgayquita. Tsaychömi ricashushcanqui gapra caycashganpita yapay ricananpag payta yataycur manacushgayquita.” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Niptinmi Ananías caynog nergan: “Payman aywaytaga mantsacömi, tayta. Atscagmi wilapäcamashga tsay runa pasaypa fiyu car gamman yäracogcunata chiquishganta. Jerusalencho gamman yäracogcunatashi gaticachar pasaypa nacatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cananpis más mandag cürapa ordinninwanshi cay marcaman shamushga gamman yäracogcunata prësu apananpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tsauraga Jesús caynog nergan: “¡Mana mantsacuypa ayway! Nogami tsay runataga acrashcä wilacuynëta wilacunanpag. Paymi wilapanga juc lädu nación runacunata, más mandag autoridänincunata y Israel runacunatapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Paytami noga musyatsishag noga-raycu fiyupa nacananpag cashganta.” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsauraga Ananías aywargan Saulo caycashgan cag wayiman. Chayaycurna Saulupa umanta yataycur caynog nergan: “Waugui Saulo, aywaycämuptiqui yuripäshogniqui Señor Jesusmi cachamashga gapra caycashgayquipita aliyänayquipag y Santu Espirituta chasquicunayquipagpis.” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananías parlayta usharcuptinmi jinan höra Saulupa nawinpita pescädupa escämannog shicwaptin ricarganna. Nircurnami bautizacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tsaypita micurcurnami cawarircorgan. Nircurnami atsca junagrag Jesucristuta chasquicogcunawan Damascucho goyargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsaypitanami sinagogacunacho Saulo tantyatsergan Jesucristo Tayta Diosnintsipa tsurin cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tsaymi lapan mayagcunaga mantsacashganog ricacur caynog nergan: “¿Manacu cay runaga Jesucristuta chasquicogcunata Jerusalencho prësu tsareg caycan? ¿Manacu caymanpis shamushga Jesucristuta chasquicogcunata prësu tsarircur mandag cüracunaman apananpag?” ");
INSERT INTO qvmNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tsaynog nipäcuptinpis mana mantsacuypami Saulo tantyatsergan cruzcho wanog Jesús salvamagnintsi Cristo cashganta. Tsaymi Damascucho tag Israel runacuna fiyupa yarpachacorgan: “¿Alitatsurag o mana alitatsurag niycämantsi?” nishpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tsaypitanami Israel runacunapa autoridänincuna wilanacärergan Sauluta wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wanutsiyta munarmi pagasta junagta paycuna shuyarpargan marca yargunan puncucho. Tsaynog wanutsiyta munashgantami Saulo musyargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tsayta musyaycurmi Jesucristuta chasquicogcuna Sauluta yanapargan gueshpinanpag. Tsaymi Jesucristuta chasquicog mayincuna juc pagas jatun canastaman winarcur marca tumarag jatun perga jananpa urätsergan gueshpicunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tsaypita Jerusalenman Saulo chayaycur Jesucristuta chasquicogcunawan juntacayta munargan. Juntacayta munaptinpis manami criyipäcorgantsu Jesusman yäracushganta. Tsaymi paywan juntacayta mantsacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tsaynog mantsacäriptinmi apostolcunaman Sauluta Bernabé pushargan. Chayaycatsirnami paycunata wilapargan Señornintsi Jesucristuta caminucho Saulo ricashganta. Tsaynogpis wilapargan payta Jesús parlapashganta. Nircur wilapargan Damascucho mana mantsacuypa Jesucristupa wilacuyninta Saulo wilacushgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bernabé tsaynog wilapaptinmi apostolcuna Sauluta chasquicärergan. Tsauraga Jerusalencho goyarnami paycunawanna Saulo purergan. Runacunatapis mana mantsacuypa wilapargan salvamänantsipag Jesucristuta Tayta Dios cachamushganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Griego idiömata parlag Israel runacunatapis wilapaptinmi tsay runacuna payta wanutsiyta munapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tsayta musyarmi waugui-panicuna Sauluta pushapäcorgan Cesarea marcaman. Tsaypitana marcan Tarsuman aywacunanpag payta despachapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsay witsanga Jesucristuta chasquicogcunata autoridäcuna manami pitapis prësu tsaritsergannatsu. Tsaymi Judea, Galilea y Samaria provinciacunachöpis Jesucristuta chasquicogcuna tranquïluna cawapäcorgan. Waran waranmi Jesucristupa wilacuyninta yachacärergan pay munashgannog cawananpag. Tsaynogpis Santu Espíritu yanapaptinmi Jesucristuta chasquicogcuna más atscayarganna. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedrunami may-tsaypa purir Lida marcamanpis chayargan Jesucristuta chasquicogcunata watucunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tsaychömi tarergan Eneasta. Paymi paralítico car pusag (8) wata cämalancho jitarargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tsauraga Pedro caynog nergan: “Eneas, Jesucristumi aliyätsishunqui. ¡Sharcuy! ¡Cämayquita shuntay!” Tsauraga Eneas jinan hörami sänuna sharcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tsaymi Lida marcacho tag runacuna y Sarón marcacho tag runacunapis sänuna caycagta ricashpan Jesucristuta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tsay witsanmi Jope marcacho Tabita jutiyog warmi targan. Tabita ninanga griego idiömachöga Dorcas ninanmi. Tsay warmimi Jesusman yäracur imaypis alilata rurag y wactsacunatapis yanapag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tsay marcachömi gueshyawan Tabita wanorgan. Wanuycuptin armarcatsir tsutargan altuscho caycag cuartuman. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopipita Lida marcamanga cercalami caycan. Tsaymi Lidacho Pedro caycashganta mayar ishcay runacunata cachargan payta jucla pushamunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tsaymi Pedro paycunawan aywargan. Chayaycuptinmi pushargan Tabita tsutaraycashgan cag cuartuman. Tsaychömi Tabita yanapashgan viüdacuna wagashpan Pedruta ricatsergan paycunapag rurapashgan röpancunata. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tsauraga Pedro tsaycho caycagcunata wagtaman gargurir gongurpacuycur Tayta Diosnintsita manacorgan. Manacurirna wanushga caycagta caynog nergan: “¡Tabita, sharcuy!” Tsaynog niptinmi wanushga caycashganpita jucla cawarimorgan. Cawarircamurmi Pedruta ricärir jamarcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nircur maquinpita tsarircur Pedro ichitsergan. Tsaypita wagtacho caycagcunata gayargan Tabita cawarimushganta ricapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tabita cawarimushgantaga musyapäcorgan intëru Jope marcachömi. Tsaynogpami Señornintsi Jesucristuta atsca chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tsay marcacho atsca junagmi Pedro posädacorgan suëla rurag Simonpa wayincho. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea marcachömi targan juc runa Cornelio jutiyog. Payga “Italiano” nishgan batallunpa capitanninmi cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Paymi wayincho tagcunawan Tayta Dios munashgannog cawapäcorgan. Tsaynog carmi nisidächo cagcunata imaypis yanapargan y Tayta Diosnintsita imaypis manacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tsaymi juc junag, malway intinog caycaptin, Cornelio ricargan Tayta Diosnintsipa angilninta. Tsay angilmi caynog nergan: “¡Cornelio!” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tsauraga pasaypa mantsacashga ricaraycashganchömi angilta caynog taporgan: “¿Imatag, tayta?” nishpan. Tsaynog niptinmi ángil caynog nergan: “Tayta Diosnintsi mayashushcanquimi manacushgayquita. Wactsacunata yanapashgayquitapis ricashgami. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cananga Tayta Diosnintsipa wilacuyninta tantyatsishunayquipag cachacuy Jope marcaman Simonta pushamunanpag. Simonpa jucag jutinmi caycan Pedro. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payga posädaraycan suëla rurag Simonpa wayinchömi. Paypa wayin caycan lamar cuchunchömi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tsauraga ángil aywacuptinnami Cornelio gayargan ishcay ashmaynincunata y juc yäracushgan soldädutapis. Tsay soldädoga cargan Tayta Diosnintsi munashgannog cawagmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Paycunatami ángil nishgancunata wilaparcur cachargan Jope marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","11","Wara pulan junagnami Cornelio cachashgan runacuna Jope marcaman chayaycargan. Pedro posädacushgan wayichönami micuyta tsayrag yanucuycargan. Tsaymi micanaycarpis Pedro witsargan wayi jananman Tayta Diosnintsita manacunanpag. Tayta Diosta manacuycashganchömi elagpita ricargan jana patsa quicharaycämogta. Tsaychömi ricapacorgan jatuncaray jacu-nirag uraycämogta. Tsay jacutaga chuscun puntanpita watashgatami urätsimorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naupanman chayaycuptinmi ricargan lapan mana micunapag cag uywacunata. Tsaychömi caycargan chuscun chaquinpa pureg tucuy casta uywacuna, lashtaypa puregcuna y päregcunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tsaypitanami mayargan jana patsapita caynog nimogta: “Pedro, tsay uywacunata pishtarcur micuy.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tsaynog niptinmi Pedro caynog nergan: “Manami tsay uywacunataga noga micömantsu, tayta. Manami imaypis micushcätsu mana micunäpag nishgayqui uywacunataga.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tsaynog niptin yapay caynog nimorgan: “Micunayquipag niycaptënaga ama yupaytupämaytsu: ‘Tsay uywacunataga manami micömantsu’ nishpayqui.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pedruta tsaynog nimorgan quimsa cutimi. Nircurnami tsay jacuta uywantinta jana patsapa cutitsicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","“¿Imapagrag cayta ricatsimashga?” nir yarpachacuycaptinmi Cornelio cachashgan runacuna chayargan posädaraycashgan wayiman. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chayaycushpannami caynog nergan: “Tapuculäshayqui, tayta. Simón Pedro ¿caychöcu posädaraycan?” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tsay hörami ricashganpita Pedro pasaypa yarpachacuycargan. Tsaynog yarpachacuycaptinmi Santu Espíritu payta caynog nergan: “Simón, quimsa runacunami ashiycäshunqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ama mantsacuytsu paycunawan aywayta. Nogami tsay runacunata cachamushcä paycunawan aywanayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tsaynog niptinmi jucla urarcur tsay runacunata Pedro caynog nergan: “Tsay ashiycashgayqui runaga nogami caycä. ¿Imapagtag ashiycämanqui, taytacuna?” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tsauraga paycuna nergan: “Capitán Corneliumi cachapäcamashga gamman shamunäpag, tayta. Payga Tayta Diosnintsi munashgannog cawag ali runami. Tsaynog captinmi payta cuyan Israel runacunapis. Gamta gayatsishunayquipagshi Tayta Diosnintsipa angilnin payta nishga. Wayinmanshi aywayculäshun Tayta Diosnintsipa wilacuyninta yachatsinayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Patsa tardina captinmi Pedro paycunata posädatsergan posädarashgan wayicho. Tsaypita wara tutanami Pedro aywargan Cornelio cachamushgan runacunawan. Paycunawanmi aywapäcorgan Jopicho tag waquin wauguicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aywapäcushganpita ishcay junagtaragmi chayargan Cesarea marcaman. Paycuna chayananpagmi castancunawan y cuyanacushgancunawanpis wayincho Cornelio shuyarpaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chayaycuptinnami Cornelio yargamorgan payta chasquicunanpag. Nircur Pedrupa naupanman maquinta chogpacuycur gongurpacuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tsauraga Corneliuta Pedro caynog nergan: “¡Sharcuy! Nogapis gamnog runalami cä.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tsaypitanami parlaraycar yaycapäcushpan tarergan atsca runacuna Corneliupa wayincho juntaraycagta. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tsauraga Pedro caynog nergan: “Gamcuna musyanquimi mana Israel runacunawanga mana juntacänäpag ni wayinmanpis mana chayanäpag cashganta. Tsaynog caycaptinpis Tayta Diosmi tantyatsimashga mana Israel runacunamanpis chayanäpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tsaymi gayatsimaptiqui jucla shamushcä. Canan nimay imapag gayatsimashgayquitapis, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tsaymi Cornelio caynog nergan: “Ayunar Tayta Diosnintsita manacuycaptëmi cay höranog chip-chipyaycag röpashga runa yuripämashga. Tsay yuripämashgan cananwanga chuscu junagnami pasashga. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yuriparcamarmi caynog nimashga: ‘¡Cornelio! Tayta Diosnintsega mayashgami manacushgayquita. Ricashgami wactsacunata yanapashgayquitapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cachacuy Jope marcaman Simonta pushamunanpag. Paypa jucag jutinmi caycan Pedro. Paymi Tayta Diosnintsipa wilacuyninta tantyatsishunquipag. Pedroga posädaraycan suëla rurag Simonpa wayinchömi. Suëla rurag Simonpa wayenga caycan lamarpa cuchunchömi.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tsaynog nimaptinmi jucla cachamushcä pushamushunayquipag. Gam shamushgayquipita cushicö, tayta. Tayta Diosnintsipa wilacuyninta mayayta munarmi lapanë juntacaycur caycho shuyarpaycashcä.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsauraga Pedro caynog nergan: “Canan rasunpami musyä Tayta Diosnintsega pï-maytapis cuyapashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Payga cuyapanmi munashgannog cawag cagtaga pitapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gamcuna musyanquimi Israel runacunata Tayta Diosnintsi musyatsishgan ali wilacuy ima cashgantapis. Tsay wilacuymi niycan Jesucristuta chasquicogcunata Tayta Diosnintsi perdonananpag cashganta. Jesucristoga lapan runacunapa Diosninmi caycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jesucristo manarag wilacuptinmi Juan Bautista Galilea provinciapita-patsa runacuna bautizacunanpag wilacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tsay witsanmi Nazaret marcapita cag Jesuspis wilacuyta galaycorgan. Paymanmi Santu Espirituta Tayta Diosnintsi cachamorgan munayniyog cananpag. Tsaymi marcan marcan purergan milagrucunata rurar y diablo gueshyatsishgan runacunata aliyätsir. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","40","“Nogacunami ricapäcushcä Jerusalencho, Judea provinciacho y waquin marcacunachöpis Jesús rurashgancunata. Cruzcho wanutsiptinpis quimsa junagtami Tayta Diosnintsi payta cawaritsimushga. Tsaymi paywan tincupäcushcä. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Cawarircamuptin manami lapan runacunatsu paywan tincushga, sinöga nogacunalami. Paywan tincupäcunäpäga Tayta Diosnintsimi naupapita-patsa acrapäcamashga. Tsaymi wanushganpita cawarimuptin paywan juntu micur capäcorgä. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nircurnami lapan runacunaman Jesús cachapäcamashga caynog nir wilacärinäpag: ‘Jesustami Tayta Diosnintsi churashga lapan runacunata juzgananpag. Manami cawagcunalatatsu juzganga, sinöga wanushcunatapis cawarircatsimur juzgangapagmi.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Manami nogacunalatsu Tayta Diosnintsipa wilacuyninta wilacuycä, sinöga Tayta Diosnintsipa unay profëtancunapis wilacärishgami. Paycunapis caynog nirmi wilacärergan: ‘Tayta Diosnintsi cachamushgan salvadorta pipis chasquicuptenga jutsa rurashgancunapita perdonashgami canga.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tayta Diosnintsipa wilacuyninta wilapaycaptinmi Corneliupa wayincho lapan juntacashga caycagcunaman Santu Espíritu chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Tsaynog chayarmi paycunata juc idiömacunapa rimatsergan. Tsaynog rimatsiptinmi Tayta Diosnintsi cuyapäcog cashganta cushishgala lapanpis parlapäcorgan. Tsaynog parlapäcushganta mayarmi Pedruwan aywag Israel runacuna caynog nergan: “¡Mana Israel runa caycaptinpis Tayta Diosnintsi paycunaman Santu Espirituta cachamushga!” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tsaymi paywan aywag Israel runacunata Pedro caynog nergan: “Nogantsinog paycunapis Santu Espirituta chasquicuycaptenga jucla paycunatapis bautizashun.” ");
INSERT INTO qvmNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pedro tsaynog niptinmi Jesucristupa jutincho paycunata bautizapäcorgan. Tsaypitanami Corneliupa wayincho juntaraycag runacuna Pedruta ruwapäcorgan ishcay quimsa junaglapis paycunata goyäpänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mana Israel runacunapis Jesucristupa wilacuyninta chasquicärishgantami Judea provinciacho musyapäcorgan apostolcuna y waquin waugui-panicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Tsaymi Jerusalenman Pedro cutiycuptin waquin wauguicuna payta jamurpargan caynog nir: “Israel runa caycarga ¿imanirtag mana Israel runacunapa wayinman yaycushcanqui? Tsaynogpis ¿imanirtag paycunawan micushcanqui?” ");
INSERT INTO qvmNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tsaynog niptinmi paycunata Pedro wilapargan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tayta Diosnintsita Jope marcacho manacuycashgächömi ricargä jatuncaray jacu-nirag jana patsapita uraycämogta. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tsaycho shumag ricaycunäpagmi caycargan lapanpis mana micunapag cag uywacuna. Tsaycunaga cargan chuscun chaquinpa pureg uywacuna, chucaru uywacuna, lashtaypa puregcuna y päregcunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tsaychömi mayargä jana patsapita caynog nimogta: ‘Tsay uywacunata pishtarcur micuy.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Tsaynog nimaptinmi nergä: ‘Manami tsay uywacunataga noga micömantsu, tayta. Manami imaypis micushcätsu mana micunäpag nishgayqui uywacunataga.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Tsauraga jana patsapita yapay caynog nimargan: ‘Tsaynog nishga captëpis micunayquipag niycaptënaga ama yupaytupämaytsu: “Tsay uywacunataga manami micömantsu” nishpayqui.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tsaynöga nimargan quimsa cutimi. Nircurnami tsay jacuta jana patsapa cutitsicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Tsay hörami nogata ashimashpan posädaraycashgä wayiman chämorgan quimsa runacuna Cesarea marcapita. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tsauraga Santu Espiritumi nimargan mana mantsacuypa paycunawan aywanäpag. Tsaynog nimaptinmi aywargä cay sogta wauguicunawan. Lapanëmi yaycapäcorgä mana Israel runapa wayinman. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tsaychömi wayiyog wilapäcamargan wayincho juc ángil yuriparcur caynog nishganta: ‘Cachacuy Jope marcaman Simonta pushamunanpag. Paypa jucag jutinmi caycan Pedro. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paymi tantyatsishunquipag lapan castayquicunawan imanogpa salvacärinayquipagpis.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Wayiyog tsaynog wilamaptinmi Jesucristupa wilacuyninta parlapayta galaycorgä. Tsaycho parlapaycaptëmi nogantsiman shamushgannogla paycunamanpis Santu Espíritu shamushga. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsaychömi noga yarpargä Jesucristo caynog nimashgantsita: ‘Juan Bautistaga yaculawanmi bautizargan runacunata. Tayta Diosnintsimi itsanga Santu Espirituwan bautizapäcushunquipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tsay nishgannoglami Jesucristuman yäracuptintsi Santu Espirituta Tayta Diosnintsi nogantsiman cachamushga. Nogantsiman cachamushgannog paycunamanpis cachamuptenga ¿pitag cä noga Tayta Diosnintsita tsapata churapänäpäga?” ");
INSERT INTO qvmNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tsaynog wilapaptinmi waugui-panicuna Pedruta manana jamurpargannatsu. Tsaypa trucanga cushicushpan caynog nipäcorgan: “¡Tsaynog captenga mana Israel runacunatapis Tayta Diosnintsi salvaycanmi!” ");
INSERT INTO qvmNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wanurcatsirnami Israel runacunapa autoridänincuna Jesucristuta chasquicogcunata waquinta prësu tsarircur carcilman wichgapäcorgan. Tsaynog carcilman wichgaptinmi waquincuna Jerusalenpita gueshpicärergan Feniciaman, Chipriman y Antioquiamanpis. Tsay marcacunaman chayaycurmi Israel runacunalata wilapargan Jesucristupa ali wilacuyninta. Mana Israel runacunataga manami pitapis wilapargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chipripita y Cirenipita Antioquiaman aywag runacunami itsanga tantyargan Jesucristupa wilacuynin mana Israel runacunapagpis cashganta. Tsaymi mana Israel runacunatapis wilapargan Jesucristuta chasquicur salvacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tsaynog wilacärinanpäga Tayta Diosnintsimi yanapargan. Tsaynogpami jutsa ruraycunata cacharir Jesucristuta atsca chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tsayta mayashpanmi apostolcuna Jerusalenpita Bernabëta cachargan Antioquiaman tsaycho cagcunata yachatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Bernabëga ali runami cargan. Tsaynogpis Tayta Diosnintsiman yäracur Santu Espíritu munashgannogmi imaypis cawag. Antioquiaman Bernabé chayaycurmi ricargan runacuna Tayta Diosnintsi munashgannog ali cawarcaycashganta. Tsaymi cushicushpan paycunata shacyätsergan Tayta Diosnintsiman yäracur imaypis cawananpag. Tsaycho Bernabé yachatsiptinmi más atsca runacuna Jesucristuta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsaypitami Tarso marcaman Bernabé aywargan Sauluta Antioquiaman pushananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Antioquiaman paywan cutiycurnami juc wata atsca runacunata yachatsishpan Bernabëwan Saulo tsaycho targan. Antioquía marcachöragmi “Cristiäno” niyta runacuna galaycorgan Jesucristuta chasquicogcunata. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tsay witsanmi Tayta Diosnintsipa profëtancuna aywapäcorgan Jerusalenpita Antioquiaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Tsaychömi profëta Agabuta Santu Espíritu musyatsergan: “Fiyupa muchuymi canga may-tsaychöpis” nir wilacunanpag. Tsaynog wilacuptinmi Jesucristuta chasquicogcuna wilanacorgan imatapis cashganpita shuntarcur Judea provinciacho cag waugui-panicunapag apatsinanpag. Tsay shuntashgantami Bernabëwan Saulo apapäcorgan Judea provinciaman. Tsaychönami mayor wauguicunata entregargan paycunana muchuy witsan aypupäcunanpag. Agabo nishgannoglami rasunpapis muchuy cargan. Tsay muchuyga cargan Romacho emperador Claudio mandashgan witsanmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tsay witsanmi Jerusalencho rey Herodes Jesucristuta chasquicogcunata prësu tsaritsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tsaychömi apóstol Juanpa wauguin Santiaguta espädawan wanutsinanpag mandargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Santiaguta wanutsiptinmi Israel runacunapa autoridänincuna cushicärergan. Tsaymi Levadüraynag Tantata Micunan aniversario witsan Pedrutapis prësu tsaritsergan wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedruta tsarircatsirmi Herodes wichgatsergan carcilman. Carcilchömi chunca sogta (16) soldäducunata churargan chuscu-cama trucanacuypa Pedruta cuidananpag. Pascua aniversario ushayrag lapan runacunapa naupancho Herodes juzgananpag captinmi carcilcho wichgarätsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tsauraga carcilcho Pedro wichgaraycaptinmi Jesucristuta chasquicogcuna Tayta Diosnintsita manacurcaycargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wara tuta juzgananpag captinmi carcilcho Pedro ishcan maquinpita cadënawan llävishga punuycargan ishcay soldäducunapa chaupincho. Waquin cag soldäducunanami täparcaycargan cárcil puncucho. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tsauraga Tayta Diosnintsi cachamushgan ángil elagpita atsicyar Pedruta yuripargan cárcil rurincho. Riccharcatsirmi caynog nergan: “¡Apuray, sharcuy Pedro!” Niptinmi jinan höra Pedrupa maquinpita lläviraycashgan cadënacuna cachacäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tsaypitami ángil yapay caynog nergan: “¡Wachcacurcur jucla llanquiquita jaticuy!” Jaticurcuptinnami ángil nergan: “¡Punchuyquitapis jaticurcur guepaläpa yargamuy!” ");
INSERT INTO qvmNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tsauraga angilpa guepalanpa Pedro aywargan. Manami shumag tantyargantsu rasunpa yarguycashganta o sueñuynilancho yarguycashgantapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ruricho cag soldäducunata y chaupi puncucho cag soldäducunata pasarcur chayargan cälliman yarguna cag fiërro puncuman. Tsay puncu quiquilan quichacäcuptinmi yargapäcorgan cällimanna. Tsaypita juc esquïnata aywarcaycaptinmi ángil elgacäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tsaymi japalanna caycashganta tantyacurir Pedro caynog nergan: “Cananmi itsanga rasunpa musyä Tayta Dios nogaman angilninta cachamushganta. Tsaynog cachamurmi salvamashga Herodispa maquinpita y Israel autoridäcuna wanutsimänanpag caycashganpita.” ");
INSERT INTO qvmNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Carcilpita yargushganta shumag tantyarnami Pedro aywargan Juanpa maman Mariapa wayinman. Juanpa jucag jutinmi cargan Marcos. Tsaychömi atsca juntacaycur Pedrupag manacurcaycargan Tayta Diosnintsita. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chayaycur sawan puncuta Pedro tacacuptinmi yargamorgan Rode jutiyog jipash, pï cashgantapis ricananpag. Tsay jipashga cargan Mariapa yanapagninmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Manaragpis sawan puncuta quicharmi rimayninpa Pedro cashganta reguergan. Tsaymi ruriman cörriyla cutergan puncucho Pedro caycashganta wilananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wilaptinmi ruricho caycagcuna caynog nergan: “¿Imanogpatag pay canga? ¡Mayapacushcanqui imachari!” Nipäcuptinpis: “Manami mayapacushcätsu. ¡Rasunpami pay caycan!” nergan. Tsauraga paycuna caynog nipäcorgan: “Manami payga canmantsu. Paypa angilnin parlamog imatachari mayapacushcanqui.” ");
INSERT INTO qvmNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tsayyäga Pedro yaparir yaparirmi puncuta tacacorgan. Puncuta quicharir pay cashganta ricaycurnami tsaycho cagcuna ucacashga ricacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tsaymi maquinwan Pedro sëñata gorgan upälacärinanpag. Nircur wilapargan carcilpita Tayta Diosnintsi imanogpa jorgamushgantapis. Tsaypitana caynog nergan: “Carcilpita yargamushgäta wilayculay Santiaguta y waquin waugui-panicunatapis.” Tsaypita yargurir aywacorgan juc lädupana. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Patsa wararcuptinnami Pedruta täpag soldäducuna ima pasashgantapis mana tantyar quiquinpura tapunacärergan: “¿Maytag Pedro?” nipäcushpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Carcilcho mana tariycushpannami soldäducunawan Herodes may-tsaypapis ashitsergan. Mana tariycuptinmi täpag soldäducunatana wanutsergan. Tsaypitana Herodes aywacorgan Judea provinciapita Cesarea marcacho tänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tiro y Sidón marca runacuna Herodispa contran rurashga captinmi Herodes rabiacushpan tsay marcacunaman micuyta apapäcunanta mana munargannatsu. Tsaymi tsay marcacunacho fiyupa muchuy cargan. Tsaynog captinmi tsay runacuna wilanacärergan Herodisman parlag aywapäcunanpag. Manarag Herodiswan parlarmi paypa yanapagnin Blastuwan amistäta rurapäcorgan. Paynami Herodiswan parlargan Tiro y Sidón runacunawan parlananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tsauraga Herodes jitapargan juc junag Tiro y Sidón runacunawan parlananpag. Tsay jitapashgan junagmi jaticorgan más alinnin cag röpanta. Nircurnami trönunman jamaycushpan runacunata parlapämorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Parlamushganta mayaycurmi runacuna fuertipa nipäcorgan: “¡Cay rimaycämog runaga manami runalatsu! ¡Payga Tayta Diosnintsimi!” ");
INSERT INTO qvmNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tsaymi: “Tayta Dioslata alabapäcuy” ninanpa trucanga Herodes cushicorgan runacuna: “Gamga Diosmi canqui” nipäcuptin. Tsaynog Dios-tucuptinmi jinan höra Tayta Diosnintsipa angilnin castigargan. Tsaymi curu ushaypa wanorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tsaypitanami Jesucristupa wilacuyninta wilacäriptin may-tsaychöpis Jesucristuta runacuna chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabëwan Saulunami waugui-panicuna shuntashganta entregaycur Antioquiaman cutipäcorgan Marcos nishgan Juanta pushacurcur. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquiachömi cargan Tayta Diosnintsipa profëtancuna y yachatsicogcunapis. Paycuna cargan Bernabé, “Yana Runa” nishgan Simón, Cirenipita cag Lucio, Manaén y Saulupis. Manaentami ashmapäcorgan rey Herodistawan tsay wayilacho. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jesucristuman yäracogcuna ayunar Tayta Diosta alabaycaptinmi Santu Espíritu caynog nergan: “Bernabëta y Saulutami acrashcä ali wilacuyta wilacur puripäcunanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tsaynog niptinmi umancunaman maquinta churaycur paycunata yanapananpag Tayta Diosnintsita manacärergan. Nircurnami paycunata despachargan Jesucristupa wilacuyninta wilacur puripäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Tsauraga Santu Espíritu nishgannog wilacunanpag aywarmi Bernabëwan Saulo chayargan Seleucia marcaman. Marcos nishgan Juantapis paycuna pushargan yanapananpag. Tsaymi büquiman witsarcur Seleuciapita aywapäcorgan Chipre nishgan islaman. Salamina marcaman chayaycurmi sinagogacunacho wilacuyta galaycärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jesucristupa wilacuyninta wilacur intëru Chipripa puripäcorgan hasta Pafos marcaman chayananyag. Tsaychömi taripäcorgan Israel runa Barjesús jutiyog brüjuta. Paymi: “Diospa wilacogninmi cä” nir runacunata criyitsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","8","Brüju captinmi payta Elimas nipäcog. Tsay brüjoga amistäta rurargan Chipre isla marcacunapa mandagnin Sergio Pauluwanmi. Sergio Pauloga ali yarpayniyog runa carmi Bernabëta y Sauluta gayatsergan wilacushganta mayananpag. Paycuna wilapashganta tantyarmi Jesucristuta chasquicuyta munargan. Chasquicuyta munaptinmi tsay brüju payta michargan mana chasquicunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tsaynog michaptinmi Saulo rabianargan. Saulupanami jucag jutin cargan Pablo. Paymi Santu Espiritupa munayninwan tsay brüjuta caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“¡Gamga ruraycanqui diablo munashgantami! ¡Tsaymi Tayta Diospa contran caycanqui! ¿Imanirtag Jesucristupa wilacuyninta runacuna chasquicunanta michaycanqui? ");
INSERT INTO qvmNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","¡Tsaynog cashgayquipitami Tayta Diospa castïgunwan gapra ricacunquipag! Tsaymi juc tiempuyag atsicyag patsata mana ricanquipagtsu.” Tsaynog niptinmi jinan höra Elimas gapra ricacorgan. Tsaymi ruwacorgan pilapis jancharcur wayinman pushananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tsaynog gaprayashganta ricarmi Sergio Paulo tantyargan Tayta Diosnintsi rasunpa munayniyog cashganta. Tsaymi Jesucristuta jucla chasquicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tsaypitanami büquiman witsarcur yanapagnincunawan Pablo aywapäcorgan Pafos marcapita Panfiliacho caycag Perge marcaman. Tsaycho paycunata cachariycurmi Marcos nishgan Juan cuticorgan Jerusalenman. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tsaypitanami Bernabé y Pablulana aywargan Pisidiacho cag Antioquía marcaman. Sábado jamay junag captinnami sinagogaman aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tsaychömi yachatsegcuna Tayta Diosnintsipa palabranta liyimorgan. Nircurmi Pablo y Bernabé jamaraycashgan cagman juc runata cachapäcorgan caynog ninanpag: “Wauguicuna, imalapis yachatsimänayquipag captenga naupagmanshi aywanqui yachatsipäcamänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsaymi naupagman aywarcur maquinta Pablo jogarergan upälacärinanpag. Nircurmi caynog nergan: “Israel runacuna y mana Israel runacunapis, yachatsimushgäta shumag mayapäcamay. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tayta Diosnintsimi Abrahamta, Isaacta y Jacobta nergan paycunapita miragcunata imaypis yanapananpag. Tsay nishgannoglami Egipto nacionchöna taycar Jacobpa wilcancunapita mirapäcorgan hasta jatun nación ricacushganyag. Nircurnami Tayta Diosnintsi milagrucunata rurashpan Egiptupita paycunata shuntamorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tsaypita chuscu chunca (40) watanog chunyag jircapa puripäcorgan. Tsaynog purir Tayta Dios nishgancunata mana cäsucuptinpis Tayta Diosnintsi pacenciacorganmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tsaypita Canaán nacionman chayaycatsirnami ganchis nacioncunata ushacätsinanpag Tayta Diosnintsi yanapargan. Tsaynogpami paycuna tsay marcancunata aypunacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","21","Egiptucho cashganpita hasta Canaán nacioncho marcacunata aypunacunanyag pasargan chuscu pachac pitsga chunca (450) watanogmi. “Canaáncho carnami Israel runacuna quejanacuptin arreglananpag Tayta Diosnintsi churargan juezcunata. Tsaypitanami profëtan Samuel witsanna juezcuna cananpa trucanga Israel runacuna Tayta Diosnintsita manacärergan rey cananpag. Tsaymi rey cananpag Dios churapargan Benjamín casta Cispa tsurin Saulta. Paymi chuscu chunca (40) wata mandag rey cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsaypitanami Saulpa trucan Davidtana churargan mandag rey cananpag. Manarag rey captin Davidpäga Tayta Diosnintsi caynogmi nergan: ‘Isaïpa tsurin Davidmi itsanga munashgänog cawag runa caycan. Payga lapan nishgäcunatami cäsucongapag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Rey David castapitanami Tayta Diosnintsi promitishgannogla Israel nacioncho juc salvador yurergan. Payga Jesucristumi. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesucristo manarag wilacuptinmi Israel runacunata Juan Bautista wilapargan jutsancunata cacharir bautizacärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nircurnami Juan Bautista caynog nergan: ‘Manami yarpapäcushgayquinogtsu noga salvador cä. Runacunata salvananpäga jucragmi shamonga. Nogaga manami paynog munayniyogtsu caycä.’ Tsaynog nergan Jesucristo wilacur puriyta galaycunanpag caycaptinmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Israel runacuna y mana Israel runacunapis, shumag mayapäcamay. Gamcunamanmi chämushga salvacunayquipag cag ali wilacuy. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalencho tag runacuna y autoridänincunapis manami tantyapäcorgantsu salvamänantsipag Jesucristuta Tayta Dios cachamushganta. Tsaynog mana tantyapäcorgantsu Tayta Diosnintsipa profëtancuna Jesucristupag escribishganta cada sábado jamay junagcho liyirpis. Mana tantyarmi paycuna Jesucristuta wanutsergan. Tsaynog wanutsiptinmi Cristuta wanutsinanpag cashganta Tayta Diospa wilacognin profëtacuna escribishgannogla pasargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wanutsishga cananpäga manami ni ima jutsantapis taripäcorgantsu. Tsaynog captinpis Pilätuman entregaycorgan jutsayogtanogpis wanutsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tsaynog entregaptinmi lapanpis pasargan Tayta Diosnintsipa profëtancuna escribishgannogla. Wanurcuptinnami payman yäracogcuna pampapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pampashga caycagtanami Tayta Diosnintsi cawaritsimorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wanushganpita cawarircatsimuptinmi atsca cuti Jesús yuripargan Galileapita Jerusalenman paywan aywag discïpuluncunata. Paycunami Jesús cawarimushganta wilacurcaycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Tsaymi Bernabëwan caycho carcaycä Jesucristupa wilacuyninta gamcunata musyatsinäpag. Canan witsanmi Tayta Diosnintsi unay promitishganta cumplishga Jesucristuta wanushganpita cawaritsimur. Ishcay cag salmuchöpis Tayta Diosnintsi Jesucristupita caynog nergan: ‘Gamga cuyay tsurëmi canqui. Tsaymi gamta churä lapanta mandanayquipag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Jesucristo wanushganpita cawarimunanpag cashgantaga Tayta Diosnintsi palabrancho mastapis caynogmi niycan: ‘Davidta promitishgäcunataga lapantami cumplishag.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tsay promitishganpitami Salmo libruchöpis David caynog escribergan: ‘Cuyashgayqui cagtaga manami pamparashgalanchöga cacharinquipagtsu, ni ayantapis ismunanta munanquipagtsu.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Manami quiquinpagtsu David tsaynog escribergan. Davidga pamparashgalanchömi ismur ushacargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesuspa ayanmi itsanga mana ismushgatsu. Tsaypa trucanga Tayta Diosnintsi payta cawaritsimorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Waugui-panicuna, canan nishgäta shumag tantyacäriy. Tayta Diosnintsi cawaritsimushgan Jesucristuta chasquicur payman yäracäriptiquimi jutsayquicunata perdonashunquipag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Payman yäracuptiqui tsaynog perdonashunquipag Moisés escribishgan leycunata mana cumpliyta camäpacuptiquipis. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Jesucristuta mana chasquicogcunapäga Tayta Diosnintsipa profëtancunapis caynogmi escribergan: ‘Tayta Diosnintsi nishganta mana cäsucogcuna, fiyupa nacanayquipag cashganta tantyacäriy. Manami yarpanquiragtsu imanog nacanayquipag cashgantapis.’ ” Tsauraga Pablo y Bernabé tsaynog wilaparcurmi caynog nergan: “Cuidädu profëta escribishgancho nishgannog gamcunatapis pasashunquiman.” ");
INSERT INTO qvmNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tsaypitanami sinagogapita lapan yargapäcorgan. Ali yachatsiptinmi paycunata ruwacärergan jucag cag säbadupis yapay yachatsinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sinagogapita Pabluwan Bernabé aywaptinmi Israel runacuna y mana Israel runacunapis paycunawan atsca aywapäcorgan. Paycunatami Pablo shacyätsergan cuyapäcog Tayta Diosnintsiman imaypis yäracärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tsaypita sábado jamay junag Pablo y Bernabé yapay cutiptin tsay marcacho cagcuna cäsi lapan juntacargan Jesucristupa wilacuyninta mayapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tsaynog juntacashganta ricaycurmi Israel runacuna Pablupa contran caynog nir sharcorgan: “Pabloga lutantami yachaycätsin.” ");
INSERT INTO qvmNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsaynog nipäcuptinmi Pablo y Bernabé mana mantsacuypa caynog nipäcorgan: “Israel mayëcuna capäcuptiquimi Jesucristupa wilacuyninta puntata gamcunata wilapaycä. Tsaynog wilapaptëpis Tayta Diospa naupancho imayyagpis cawayta mana munarmi mana chasquicärinquitsu. Tsaymi wilapashgäta mana chasquicuptiqui mana Israel runacunatana wilapäshag. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mana Israel runacunapis Jesucristupa wilacuyninta chasquicunanpagmi caynog nir escribiraycan: ‘Mana Israel runacunapagpis atsquinog canayquipagmi gamta churashcä. Tsaynogpami may-tsaychöpis runacuna salvacärengapag.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pabluwan Bernabé tsaynog parlashganta mayarmi mana Israel runacuna cushicärergan, paycunapagpis salvación cashganta tantyashpan. Tsaynogpami Tayta Diosnintsi acrashgan cagcuna gloriacho cawananpag Jesucristuta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tsaynogpami Jesucristupa wilacuynin wilacushga cargan tsaycho cag lapan marcacunapa. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tsaymi tsay marcacho cag respitashga warmicunata y runacunatapis Israel runacuna shimita gorgan Bernabëta y Pabluta chiquipäcunanpag. (Tsay warmicunaga sinagogacho sábado junagcuna juntacag.) Tsaynog chiquipäcushpanmi Israel runacuna Pabluta y Bernabëta gargapäcorgan tsay marcacunapita. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsaynog garguptinmi llanquincho caycag polvuta tapshirishpan aywacorgan Iconio marcamanna. ");
INSERT INTO qvmNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesucristuta chasquicogcunaga Santu Espíritu imachöpis yanapaptin cushishgami cawapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio marcachöna caycar Pablo y Bernabé aywapäcorgan sinagogaman. Tsaycho shongunman chayagpag Jesuspita wilapaptinmi Israel runacuna y mana Israel runacunapis Jesucristuta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tsaynog chasquicäriptinmi waquin cag Israel runacuna rabianashpan runacunata shimita gorgan Jesucristuta chasquicogcunata chiquipäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tsaychömi Pablo y Bernabé atsca quilla targan. Tsaycho tarmi Tayta Diosnintsiman yäracushpan pitapis mana mantsacuypa Jesucristupa ali wilacuyninta wilapargan. Tsay wilacärishgan rasunpa cashganta runacuna musyananpagmi Bernabëta y Pabluta Tayta Diosnintsi yanapargan milagrucunata rurananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jesucristupa wilacuyninta wilacuptinmi Israel runacuna paycunata chiquipäcorgan. Tsaymi waquin runacuna apostolcunapa contran sharcorgan y waquin cagnami apostolcunapa favornin sharcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Apostolcunapa contran sharcogcunaga, Israel runacuna y mana Israel runacunapis, autoridäcunawan wilanacärergan apostolcunata sagmaypa wanutsipäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Tsayta musyaycurmi Pablo y Bernabé gueshpicärergan Licaonia provinciaman. Nircurnami Listraman, Derbiman y tsay provinciacho cag waquin marcacunamanpis aywar Jesucristupa wilacuyninta wilacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra marcachömi juc wegru runa cargan, yurishganpita-patsa mana pureg. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tsay runami jamaraycargan Pablo parlashganta mayar. Payta ricärirmi Pablo tantyargan aliyänanpag Tayta Diosnintsiman yäracuycashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tsaymi fuertipa caynog nergan: “¡Sharcurcur shumag ichiy!” Tsaynog niptinmi jucla ichircushpan puriyta galaycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tsayta ricaycurmi quiquincunapa idiömancho runacuna cushishga caynog nipäcorgan: “¡Dioscunami runa-tucular nogantsicunaman shamushga!” ");
INSERT INTO qvmNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabëpag yarpapäcorgan Zeus nishgan diosnin cashganta. Y Pablupagna, wilacog captin, yarpapäcorgan Hermes nishgan diosnin cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tsay marca yaycunachömi Zeus nishgan diosninta adoracunan templo cargan. Tsauraga tsay templucho cag cürami puncuman apamorgan waytan walgashga törucunata. Tsaycho lapan runacunawan törucunata wanutsiyta munapäcorgan apostolcunata adorananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Paycunata adorayta munapäcushganta tantyaycurmi Pablo y Bernabé laquicushpan jatirashgan röpanta rachiriycorgan. Tsaymi runacunaman aywaycur caynog nergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“¡Ama tsayta rurapäcuytsu! Nogacunapis gamcunanog runalami capäcö. Gamcunaman yachatseg shapäcamushcä tsay manacag dioscunata cacharir rasunpa cag Tayta Diosnintsitana adorapäcunayquipagmi. Paymi jana patsatapis, cay patsatapis, lamartapis y lapan imatapis camargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jesucristupa ali wilacuynin gamcunaman manarag chämuptinmi Tayta Diosnintsi cachaparishushcanqui manacag dioscunata adorar cawapäcunayquipag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tsaynog captinpis tantyaycätsishunqui rasunpa cag Dios cashganta musyapäcunayquipagmi. Tsaymi cuyapäshushpayqui tamyatsimun ali cosëchata shuntar cushishga cawapäcunayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Apóstol Pablo tsaynog nir tantyatsiptinpis sasataragmi runacuna tantyargan Pabluta y Bernabëta mana adorananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsaypita warantincunami apostolcunata chiqueg Israel runacuna Antioquiapita y Iconiupitapis Listraman chayapäcorgan. Tsay runacunami shimita gorgan Pablupa contran sharcapäcunanpag. Paycuna nishganta chasquiparmi runacuna Pabluta sagmapäcorgan pitegpag. Nircur wanushgana cashganta yarparmi garachaypa apaycur marca cuchunman jitarergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tsauraga Jesucristuta chasquicogcuna Pablo jitaraycashgan cagman juntacargan ayanta shuntananpag. Tsaynog juntaparaycaptinmi cawarircamurna marcaman cutergan. Tsaypita wara junagna Bernabëwan aywacorgan Derbe marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbiman chayaycurnami Jesucristupa wilacuyninta wilacärergan. Tsaynog wilacuptinmi atsca runacuna Jesusta chasquicärergan. Nircurnami cutipäcorgan Antioquía, Listra y Iconio marcacunaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tsay marcacunaman chayarmi Jesucristuta chasquicogcunata shacyätsergan Tayta Diosnintsiman mana ajayaypa yäracärinanpag. Tsaynogpis tantyatsergan Diospa naupanman manarag chayaptin runacuna chiquinanpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tsaynogpis cada marcacho mayor wauguicunata churapäcorgan waugui-panicunata tsaycho yachatsinanpag. Nircurnami ayunashpan Tayta Diosnintsita manacärergan paycunata yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia provinciapita aywacurmi Panfilia provinciamanna chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tsaychönami Perge marcachöpis Jesucristupa wilacuyninta yapay wilacärergan. Nircurna aywapäcorgan Atalia marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tsaypitanami büquiwan Antioquiaman cuticärergan. Tsaychömi yapay juntacargan waugui-panicunawan. Tsay waugui-panicunami Tayta Diosta manacurir Bernabëta y Pabluta naupata cachargan may-tsaypapis wilacur puripäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquía marcaman chayarnami waugui-panicuna juntacaptin cushishga wilapargan caynog nir: “¡Wilacuyninta wilacärinäpag Tayta Diosnintsi alimi yanapamashga! ¡Tsaymi mana Israel runacunapis Jesucristuta chasquicärishga! ¡Paycunapis cananga Tayta Diosmannami yäracurcaycan!” Tsaynog wilaptinmi mayagcunapis pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pabluwan Bernabé tsaycho atsca quillami waugui-panicunata yachatsir targan. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tsay witsanmi Judea provinciapita Antioquiaman waquin wauguicuna aywargan. Chayaycurmi waugui-panicunata caynog yachatsergan: “Moisés escribishgan leycunata cumplir cuerpuyquita señalacurragmi salvacärinquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tsaynog yachatsiptinmi Pablo y Bernabé paycunata michargan tsaynog mana yachatsinanpag. Tsaymi tsay yachatsicogcuna Pabluwan y Bernabëwan fiyupa rimanacärergan. Tsaynog rimanacuptinmi Antioquía waugui-panicuna Bernabëta y Pabluta caynog nergan: “Tsaypita parlapäcunayquipag mejor aywapäcuy Jerusalenman. Tsaychönami apostolcunawan y mayor wauguicunawanpis shumag parlapäcunqui señalacunantsipag o mana señalacunantsipag cashgantapis.” Tsaynog nishpanmi waquin wauguicunatapis acrapäcorgan paycunawan Jerusalenman aywapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jerusalenpa aywarmi Fenicia y Samaria provinciacunamanpis chayargan. Tsayman chayarmi wilacärergan mana Israel runacunapis Tayta Diosnintsita chasquicärishganta. Tsaynog wilapaptinmi waugui-panicuna cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalenman chayaptinnami Pabluta y Bernabëta chasquicärergan apostolcuna, mayor wauguicuna y tsaycho cag lapan waugui-panicunapis. Paycunatami Pablo y Bernabé wilapargan may-tsaychöpis Tayta Diosnintsi yanapashganta. Tsaynogpis wilapargan mana Israel runacunapis salvacärinanpag Jesucristuta chasquicärishganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tsaymi Jesucristuta chasquicog fariseo runacuna caynog nergan: “Manami paycuna salvacärengatsu Moisespa leynincunata mana cumplir. Tsaynogpis manami salvacärengatsu cuerpunta mana señalacorga.” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tsaynog niptinmi apostolcuna y mayor wauguicunapis juntacargan tsay nishganpita parlapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tsaycho waquin wauguicuna parlamushganta mayarmi Pedro caynog nergan: “Wauguicuna, musyapäcunquimi mana Israel runacunata wilapänäpag Tayta Diosnintsi cachamashganta. Tsaynog cachamashga paycunapis wilacuyninta chasquicur salvacärinanpagmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Cachamashgannogla mana Israel runacunata wilapaptëmi paycunapis Jesucristuta chasquicärishga. Rasunpa chasquicushganta musyarmi Tayta Diosnintsi Santu Espirituta paycunamanpis cachamushga. Nogantsi chasquicushgantsinoglami paycunapis Santu Espirituta chasquicärishga. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tsaynogpami musyantsi Jesucristuta chasquicog cagta, Israel runa captinpis mana Israel runa captinpis, Tayta Diosnintsi perdonar salvashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tsaynog caycaptenga shumag yarpachacäriy. Mana Israel runacunata ama obligashuntsu Moisés escribishgan leycunata cumplinanpag. Tsaycunataga unay Israel runacuna ni quiquintsipis manami cumpliyta puëdishcantsitsu. Mana Israel runacunata Tayta Diosnintsi salvashganta ¿imanirtag manacagman churayta munapäcunqui? ");
INSERT INTO qvmNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","¡Manami Moisés escribishgan leycunata cumplishgantsipitatsu Tayta Diosnintsi salvamantsi, sinöga Señornintsi Jesucristuta chasquicushgantsipitami cuyapämashpantsi salvamantsi Israel runa captintsipis mana Israel runa captintsipis!” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pedro tsaynog niptinmi tsaycho cag runacuna lapan upälacärergan. Tsaynami Pablo y Bernabé wilapargan Tayta Diosnintsi yanapaptin mana Israel runacuna cagchöpis milagrucunata rurashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tsaynog wilapayta usharcuptinmi Santiago caynog nergan: “Wauguicuna, mayapäcamay. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro wilamashcantsi mana Israel runacunatapis cuyapashpan Tayta Diosnintsi salvashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pedro wilamashgantsinoglami unay profëtancunawanpis Tayta Diosnintsi caynog wilacatsergan: ");
INSERT INTO qvmNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Israel nacioncho Davidpa castan rey mana captinpis juctami paypa castanpita churashag rey cananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tsaynog rurashagpag Israel runacunapis y mana Israel runacunapis nogaman yäracamänanpagmi. Tsaynog ruraptëmi lapan acrashgä cag runacuna salvacärengapag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tsaynog pasananpag cagtami Tayta Diosnintsi unaypita-patsana tsaycunata musyatsimashcantsi.’ ” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tsayta yarparcatsirmi Santiago mastapis caynog nergan: “Tayta Diosnintsi palabrancho tsaynog niycaptenga imatapis ama tsapata churapäshuntsu mana Israel runacunapis Jesucristuta chasquicärinanpag. Tsaynogpis ama obligashuntsu Moisés escribishgan leycunata cumplinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Imanog captinpis Israel waugui-panicunawan mana Israel waugui-panicuna ali ricanacunanpag cartata apatsishun. Tsay cartacho mana Israel waugui-panicunata wilashun ïdulucunapa jutincho pishtashgan aytsata mana micunanpag, runacuna chinëru mana cananpag, warmicunapis waynan waynan mana puricunanpag, mana pishtaypa wanushga uywacunapa aytsanta mana micunanpag y uywapa yawarnintapis mana upunanpag ni micunanpagpis. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tsaycunata cumplipäcunanpäga sinagogacunachömi Moisés escribishgan leycunata cada sábado jamay junag yachaycätsin.” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tsaynog niptin apostolcuna, mayor wauguicuna y waquin waugui-panicunapis ishcay wauguicunata acrapäcorgan Pablo y Bernabé Antioquiaman cutiptin tsaycho cag waugui-panicunata imata wilanacushgantapis wilananpag. Tsay wauguicunami cargan Judaswan Silas. Judaspa jucag jutinmi cargan Barsabás. Judasta y Silastami lapan waugui-panicunapis cuyashpan respitapäcog. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawanmi cartata apatsergan Antioquiacho cag waugui-panicunaman. Tsay cartatami escribipäcorgan caynog nir: Antioquía marcacho cag waugui-panicuna y Siria y Cilicia provinciacunacho cag waquin waugui-panicunapis: Apostolcuna y mayor wauguicuna carmi gamcunapag salüdöta apatsimö. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nogacuna musyapäcushcämi waquin wauguicuna gamcuna cagman shamur lutanta yachatsipäcushushgayquita. Paycunataga nogacuna manami cachapäcamushcätsu. Mana cachaycämuptëpis paycunaga gamcunata pantacätsir lutantashi yachatsishushcanqui caynog nir: “Salvacärinayquipäga cuerpuyquitarag señalacäriy. Tsaynogpis Moisés escribishgan leycunatarag cumplipäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","Tsayta musyarmi lapanë wilanacärishcä gamcuna cagman Judasta y Silasta cachapäcamunäpag. Paycunami tantyatsishunqui cay cartacho escribiraycashgancunata. Bernabëwan Pabluwanmi paycuna shapäcamonga. Bernabëwan Pablumi wanuytapis mana mantsacuypa may-tsaychöpis Jesucristupa wilacuyninta wilacuycan. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Santu Espiritumi tantyatsimashga cuerpuyquita mana señalacurpis salvacärishgayquita. Tsaymi wilanacärishcä salvashgana caycarga ïdulucunapa jutincho pishtashgan aytsata mana micapäcunayquipag, ima uywapa yawarnintapis mana upupäcunayquipag, jurcacaypa wanushga uywacunapa aytsanta mana micapäcunayquipag, runacuna chinëru mana cananpag y warmicunapis waynan waynan mana puricunanpag. Cay cartacho nishgäcunata cumplipäcuptiquega alimi canga. Tsaylatami nipäcamö cay cartacho. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tsauraga tsay wilanacärishgannoglami tsay chuscun wauguicuna aywacärergan Antioquiaman. Tsayman chayaycurmi waugui-panicunata shuntargan apashgan cartata liyipänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tsay cartata liyipaptinmi lapan cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judaswan Silaspis Tayta Diosnintsipa profëtancunami cargan. Tsaymi waugui-panicunata shumag tantyatsir shacyätsergan Tayta Diosnintsi munashgannog imaypis cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tsaycho goyarcuptinnami Tayta Diosta agradëcicushpan waugui-panicuna Judasta y Silasta despachargan Jerusalenman cuticärinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tsaynog captinpis Silasmi itsanga yarpachacurir Antioquiacho quëdacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pabluwan Bernabëpis Antioquiachömi quëdacärergan. Tsaychömi waquin wauguicunawan Jesucristupa ali wilacuyninta yachatsir targan. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tsaypita atsca quillatanami Bernabëta Pablo caynog nergan: “Acu cutishun Jesucristupa wilacuyninta wilacushgantsi cag marcacunaman waugui-panicunata watucamunantsipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tsauraga Bernabé pushayta munargan Juanta. Juanpa jucag jutinmi cargan Marcos. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablumi itsanga Marcusta pushayta mana munargantsu, punta cag aywaynincho Panfiliapita cachariycur cuticushga captin. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tsaymi Pabluwan Bernabé tsay janan rimanacorgan. Tsaynog rimanacurcurnami Marcusta pushacurcur büquiwan Bernabé aywargan Chipriman. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablunami Silasta pushacurcur aywargan wilacushgan marcacunaman. Tsaypa aywananpagmi waugui-panicuna Jesucristuta manacärergan paycunata yanapananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria y Cilicia provinciacunacho cag marcacunaman chayarmi Pabluwan Silas waugui-panicunata shacyätsergan Tayta Diosnintsi munashgannog shumag cawapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tsaypita Derbe y Listra marcacunaman Pabluwan Silas chayapäcorgan. Listra marcachömi Timoteuwan reguinacorgan. Timoteupa taytan mana Israel runa captinpis mamanga Israel warmimi cargan. Tsaynogpis Timoteupa mamanga Jesucristuta chasquicushgami cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra y Iconio marcacunacho tag waugui-panicuna lapanpis parlapäcorgan Timoteo ali mözu cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Timoteupa taytan mana Israel runa captinmi Israel runacuna musyargan Timoteupa cuerpun mana señalashga cashganta. Tsaymi yanagänanpag Pablo pushayta munar Israel runacuna mana jamurpänanpag Timoteupa cuerpunta señalatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tsaypita quimsanna marcan marcan aywapäcorgan Jesucristupa wilacuyninta wilacunanpag. Marcan marcan chayaycurmi apostolcuna y mayor wauguicuna apatsishgan cartata liyipashpan waugui-panicunata shacyätsergan cartacho escribishgannogla lapantapis cumplipäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tsaynog tantyatsiptinmi waugui-panicuna pasaypa cushicärergan. Tsaymi waran waran runacuna Jesusta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsaypitami Pablo yanagagnincunawan Asia provinciaman aywayta munargan Jesucristupa ali wilacuyninta wilacunanpag. Tsaynog yarpaptinpis Santu Espíritu manami tsaypa aywananta munargantsu. Tsaynami Frigia y Galacia provinciacunacho cag marcacunaman chayaycushpan Jesucristupa wilacuyninta wilacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia provinciaman chayaycurnami aywayta yarpargan Bitinia provinciapa. Tsaychöpis Santu Espíritu manami munargantsu tsaypa aywapäcunanta. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tsauraga Misia provinciapa pasarmi chayapäcorgan Troas marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tsaychönami sueñuynincho Pablo ricargan Macedonia provinciapita juc runa caynog nir gayacaycämogta: “Cayman shaycalämuy nogacunata yanapamänayquipag, tayta.” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo tsaynog ricashganta wilapäcamaptinmi tantyapäcorgä tsay marcacunamanpis wilacuyninta chayatsinäpag Tayta Dios munashganta. Tsaymi jucla camaricärergä Macedoniaman aywapäcunäpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tsauraga Troas marcapita büquiwan aywar chayapäcorgä Samotracia islaman. Tsaypita wara junagragmi chayapäcorgä Neápolis marcaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tsaypitana Macedonia provinciaman aywar chayapäcorgä Filipos marcamanpis. Tsay marcaga cargan Roma runacuna tashgan marcami. Tsay marcachömi nogacuna juc ishcay junag goyargä. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tsaycho goyarmi yarpapäcorgä Tayta Diosnintsita manacärinanpag Israel runacuna sábado jamay junag captin mayu cuchuncho juntacashganta. Tsayman aywarmi taripäcorgä juntacashga caycag warmicunata. Paycunatami Jesucristupa ali wilacuyninta wilapargä. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tsay warmicunawanmi caycargan Tayta Diosnintsiman yäracog Lidia jutiyog warmipis. Payga Tiatira marcapita carmi morädo fïnu tëlacunata ranticog. Jesucristo salvamagnintsi cashganta Pablo wilapaptinmi Lidia shumag tantyacur Jesucristuta chasquicorgan. Tsaynog chasquicunanpäga Tayta Diosnintsimi payta tantyatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Tsaypita Lidiapa castancunapis Jesucristuta chasquicuptinmi paycunata bautizapäcorgä. Nircurnami nogacunata Lidia ruwacamargan caynog nir: “Nogapis Jesucristuta chasquicushgana caycaptëga wayëman aywayculäshun, tayta, tsaycho goyäpämänayquipag.” Tsaynog nipäcamaptinmi posädacärergä paypa wayinchöna. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Juc cutimi Diosta manacärinäpag cagman aywaycashgächo tincupäcorgä demoniupa munayninwan adivinag jipashwan. Tsay jipash adivinaptinmi patronnincuna atsca guellayta gänargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tsay jipashmi nogacunata gatirämargan caynog nir: “¡Cay runacunaga munayniyog Tayta Dios munashgannog cawagmi! ¡Paycunami gamcunata tantyatsishunquipag imanog salvacärinayquipag cashgantapis!” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tsaynog waran waran büllata rurar gatirpämaptinmi Pablo rabiacushpan jipashcho caycag demoniuta caynog nergan: “¡Jesucristupa jutinchömi gamta gargö cay jipashpita yargunayquipag!” Tsaynog niptinmi jinan höra tsay jipashpita demonio yargorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tsauraga tsay jipashpa patronnincuna guellayta mana gänananpag captinna prësu tsaripäcorgan Pabluta y Silasta. Nircurna autoridäcunaman apapäcorgan pläzacho lapan runacunapa naupancho juzgananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","22","Autoridäcunaman apapäcuptinmi atsca runacunapis paycunata gatirpargan. Chayaycatsirmi Pabluta tumpashpan caynog nipäcorgan: “Cay Israel runacunami marcantsicho yachaycätsin Israel runacunapa costumbrincunata rurananpag. Nogantsega Roma runa cashpantsi manami tsay costumbricunataga chasquipashwantsu. Tsaynog yachatsiptinmi runacuna pasaypa rabiashga carcaycan.” Tsaynog niptinmi tsaycho caycag runacunapis paycunapa contran sharcapäcorgan. Tsaymi autoridäcunapis Pablupa y Silaspa janan cag röpanta logtircatsir fiyupa wirutsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tsaynog wirurcatsirnami paycunata carcilman wichgatsergan. Nircurna prësucuna cuidag runata caynog nergan: “Mana gueshpinanpag paycunata seguro llävinqui.” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tsaynog niptinmi wichgargan más ruri cag calapösuman. Nircurmi chaquincunata “cëpo” nishgan racta tablapa ishcay uchcuncunaman jatergan mana yargunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tsaypita pulan pagasnog caycaptinmi Silaswan Pablo Tayta Diosnintsita manacurir cantapäcorgan. Tsaynog cantapäcushgantami waquin cag prësucunapis mayargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tsaynog cantaycaptinmi elagpita fiyupa patsa sicsicyar carcilta cuyutsergan. Tsaynogpis lapan puncucuna jucla quichacäcorgan y prësucuna watarashgan cadënacunapis pascacäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tsauraga prësucunata cuidag runapis patsa sicsicyaptin riccharcamunanpäga puncucuna quichacashga caycargan. Tsaymi prësucuna gueshpicushganta yarpar espädanta jorgurir quiquin wanutsicuyta munargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tsaynog wanutsicuyta munaptinmi Pablo fuertipa caynog nergan: “¡Ama wanutsicuytsu! ¡Caycho lapanëmi carcaycä!” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tsaymi prësucunata cuidag runaga atsquicurcur carcilman cörrila yaycorgan. Pablo y Silas caycashganman chayaycur sicsicyashpan naupanman gongurpacuycorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nircurna carcilpita paycunata jorgurir taporgan caynog nir: “¿Imatatag ruräman salvacunäpag, taytacuna?” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tsaynog tapuptinmi Pablo y Silas caynog nergan: “Señor Jesucristuta chasquicuy. Tsaynog chasquicurmi gam salvacunquipag. Gam chasquicuptiquega wayiquicho tagcunapis chasquicushpan salvacärengapagmi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nircurnami tsay runata y wayincho caycagcunatapis tantyatsergan Jesucristupa ali wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tsaymi prësucunata cuidag runaga Pabluta y Silasta jampergan runacuna wirur däñashganta. Nircurnami Jesucristuta chasquicushpan paypis y wayincho tagcunapis jucla bautizacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tsaypita wayinman pushaycur micuyta garargan. Jesucristuta chasquicur Tayta Diosnintsiman yäracushpanmi wayincho tagcunawan pasaypa cushicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wara tutanami autoridäcuna wardiacunata cachargan prësucuna cuidag runaman, Pabluta y Silasta cacharinanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tsauraga prësucunata cuidag runa Pabluta wilargan: “Autoridäcuna wilacatsimushga gamcunata cacharinäpagmi. Cananga aywacärinquinashi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tsaymi wardiacunata Pablo caynog nergan: “Roma runa caycaptëpis lapanpa naupancho mana tapupämaylapa nogacunata wirutsimashga. Tsaynog mana tapupämaylapami cay carcilman wichgatsipäcamashga. ¿Tsaynog wirurcatsimarcu carcilpita pacaylapa jorgatsimayta munarcaycan? ¡Quiquincunarag shapäcamutsun caypita jorgapäcamänanpag!” ");
INSERT INTO qvmNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","39","Tsaynog niptinmi wardiacuna autoridäcunaman cutiycushpan wilapäcorgan Silaswan Pablo Roma runa cashganta. Tsayta musyaycurmi autoridäcuna mantsarishpan aywapäcorgan Pablo y Silas wichgaraycashgan cagman. Chayaycurnami nergan: “Roma runa cashgayquita mana musyarmi castigatsishcä, tayta. Tsaynog castigatsishgäpita perdonaycalämay.” Nircurnami carcilpita jorgurir paycunata autoridäcuna ruwacorgan tsay marcapita aywacunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tsaypitanami Silaswan Pablo aywargan Lidiapa wayinman. Tsaychömi waugui-panicunata shacyätsergan Tayta Diosman imaypis yäracunanpag. Nircurnami Filipos marcapita aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tsaypita Anfípolis y Apolonia marcacunapa pasar Pablo y Silas Tesalónica marcaman chayargan. Tsaychömi sinagoga cargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tsaymi sinagogaman imaypis aywashgannog Pablo tsay sinagogamanpis aywargan. Tsaychömi quimsa sábado yachatsergan caynog nir: ");
INSERT INTO qvmNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Palabranchöga Tayta Diosnintsi nimantsi salvamagnintsi wanunanpag cashganta y nircur cawarimunanpag cashgantami. Tsay escribirashgannoglami wanushganpita Jesusga cawarimushga. Tsaynogpami musyantsi salvamagnintsi Cristo cashganta. Tsaycunatami noga wilacur puriycä.” ");
INSERT INTO qvmNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tsaynog yachatsiptinmi waquin Israel runacuna, waquin mana Israel runacuna y waquin rïca warmicunapis Jesucristuta chasquicärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Israel runacunapa autoridänincunami itsanga fiyu runacunata shuntaycur shimita gorgan Pablupa y Silaspa contran sharcapäcunanpag. Tsay fiyu runacunanami atsca runacunata shuntarcur Jasunpa wayinman rabiashga aywargan Pabluta y Silasta prësu tsaripäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tsaycho mana tariycurna Jasunta y waquin wauguicunatana autoridäcunaman garachaypa apapäcorgan caynog nishpan: “¡Pablo y paywan pureg runacunami may-tsaychöpis lutanta yachaycätsin! ¡Cananga nogantsimanna shapäcamushga lutanta yachatsimänantsipag! ");
INSERT INTO qvmNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Jasunmi tsay runacunata wayinman posädatsishga! ¡Tsay runacunaga nipäcun Romacho mandamagnintsi emperadorpitapis Jesús jutiyog runa más munayniyog rey cashgantami! ¡Tsaynog nishpanmi leynintsicunataga mana cäsucärinnatsu!” ");
INSERT INTO qvmNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tsaynog nipäcuptinmi tsaycho cag runacuna y autoridäcunapis fiyupa rabiacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tsaynog rabiacuptinpis Jasunwan waquin cag wauguicuna guellayta garantía churaycur yargapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tsauraga tsay tsacaymi Pabluta y Silasta waugui-panicuna cachapäcorgan Berea marcaman. Bereaman chayaycurmi sábado jamay junag aywapäcorgan sinagogaman. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea marca runacunaga manami Tesalónica marcacho runacunanogtsu cargan, sinöga Jesucristupa wilacuyninta cushishgami chasquicärergan. Tsaynog carmi waran waran Pablo yachatsishgancunata Tayta Diosnintsipa palabranman tincutsergan rasun cagta yachatsishganta musyapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tsay marcachöga Jesucristuta atscagmi chasquicärergan, Israel runacuna y mana Israel runacunapis. Tsaynogmi chasquicärergan mana Israel rïca warmicunapis. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Berea marcachöna Pablo yachaycätsishganta mayarmi Tesalónica marcacho contran cag runacuna Bereaman aywapäcorgan tsaychöpis Pablupa contran sharcapäcunanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tsaymi waugui-panicuna Pabluta gueshpitsergan lamar cuchunman juc lädupa aywacunanpag. Silaswan Timoteunami Bereacho quëdacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lamarpa cuchunman chayaycurmi yanagagnincuna Pabluta pushapäcorgan Atenas marcaman. Tsaypitana Bereaman cutipäcorgan Silasta y Timoteuta Pablo cagman jucla cachananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","17","Atenas marcacho Silasta y Timoteuta shuyashganyagmi sinagogaman Pablo aywargan. Tsaychömi Israel runacunata y mana Israel runacunatapis tantyatsergan Jesucristo pï-maytapis chasquicogcunataga salvananpag cashganta. Tsaynogpis Atenas marca cällicunapa puriycashgancho Pablo ricargan atsca ïdulucuna caycagta. Tsayta ricarmi Pablo fiyupa laquicorgan. Tsaymi pläzacho caycag runacunata tantyatsergan Jesucristuta chasquicur Tayta Dioslatana adorananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pläzachömi Epicúrio nishgan y Estoico nishgan yachag runacuna imaypis juntacag. Tsaymi paycunatapis Pablo tantyatsergan Jesucristupa ali wilacuyninta. Tsaynogpis wilapargan wanushcuna cawarimunanpag cashganta. Tsaycunapita tantyatsiptinmi waquin runacuna caynog nergan: “Cayga yachag-tucushpan ¿imatarag rimacunpis?” Y waquincunana caynog nergan: “Cayga mana reguishgantsi dioscuna imapitachari parlapaycämantsi.” ");
INSERT INTO qvmNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Tsauraga Pabluta pushargan yachag runacuna juntacashgan Areópago nishganman. Tsaychömi wilanacunanpag mayor runacuna imaypis juntacag. Tsay runacunami Pabluta nipäcorgan: “Gam yachaycätsinqui imaypis mana mayashgätami. Tsay yachatsishgayquita nogacuna shumag musyaytami munapäcö.” ");
INSERT INTO qvmNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atenas runacunaga y tsaycho tag jäpa runacunapis mushog yachatsicuy captenga shumag mayaytami munapäcog. Nircurmi waran waran tsay mayashgancunalapita parlapäcog.) ");
INSERT INTO qvmNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tsaymi yachatsishganta mayayta munapäcuptin Pablo caynog nergan: “¡Atenas runacuna! Atsca dioscunata adorapäcunayquipag capillancunata rurapäcushgayquitami ricashcä. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Capillacunata ricapacur puriycashgächömi ricashcä juc capillacho caynog nir escribiraycagta: ‘Cay capillaga mana musyashgantsi diospagmi.’ Cananga mana musyaycarpis tsay adorashgayqui Dios pï cashgantapis gamcunata tantyatsishayqui. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Paymi cay patsata y lapan imaycatapis camashga. Jana patsatapis y cay patsatapis munaynincho tsarararmi runa rurashgan capillacho mana tantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Paymi cawanantsipag jämaytapis gomantsi. Tsaynoglami cawanantsipag nistashgantsicunatapis camaripämantsi. Manami nogantsitsu payta imatapis camaripantsi, sinöga paymi nogantsita lapantapis camaripämantsi. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Juc runalata camashganpitami atscaman mirashcantsi. Paymi destinamashcantsi maycho tänantsipag y imay wanunantsipagpis. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","28","Cananpis pay mana yanapamaptintsega manami cawashwantsu. Tsaynog captinmi mana sasatsu caycan Dios cashganta tantyacunantsipag. Marca mayiquipis shumag yarpachacurir caynog nirmi unay escribergan: ‘Lapantsitapis Tayta Diosnintsimi camamashcantsi.’ ");
INSERT INTO qvmNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Tsaynog caycaptenga ama yarpäshuntsu örupita, guellaypita, o rumipita rurashgan ïdulucunanog Tayta Dios cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ïdulunog cashganta runacuna yarpaptinpis naupataga manami castigargantsu. Cananmi itsanga lapan runacunata niycan ïdulucunata manana adoraypana pay munashgannogna cawananpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pay munashgannog mana cawagcunata juc junag juzgananpagmi juc runata churashga. Tsay runa pï cashgantapis musyanantsipagmi wanushganpita cawaritsimushga.” ");
INSERT INTO qvmNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wanushganpita cawarimushganta Pablo niptinmi waquin runacuna burlacur asipargan. Waquin runacunanami caynog nipäcorgan: “Yapaypis cutiycalämunqui, tayta, mastapis tantyatsipäcamänayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tsaypitanami tsay mayor runacuna juntacashganpita Pablo aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tsaynog captinpis juc ishcay runacunalami Pablo wilapashgancunata chasquicorgan. Paycunachömi Areopagucho juntacag autoridä Dionisio jutiyog runapis cargan. Nircur Dámaris jutiyog warmi y más waquin cagcunapis Pablo wilacushganta chasquicorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Atenas marcapita aywacurmi Corinto marcamanna Pablo chayargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tsaychömi Aquila jutiyog Israel runawan reguinacorgan. Aquilaga Ponto nishgan provinciacho yureg runami cargan. Payga Romacho tashganpitami warmin Priscilawan tsayrag Corinto marcaman chayargan. Tsayman aywacärergan lapan Israel runacunata Romapita emperador Claudio gargushga captinmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Priscilawan Aquilami toldëra rurayta yachapäcorgan. Pablupis toldëra rurayta yacharmi paycunawan targan toldërata rurashpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cada sábado jamay junagmi sinagogaman Pablo aywargan. Tsaychömi Israel runacunata y mana Israel runacunatapis yachatsergan Jesucristuta Tayta Diosnintsi salvamänantsipag cachamushganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia provinciapita Silaswan Timoteo chayaptinnami Pabloga aruyninta cachaycur waran waran Jesucristupa wilacuyninta wilacorgan. Wilacurmi Israel mayincunata tantyatsergan runacunata salvananpag Jesucristo shamushganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tsauraga Israel runacuna Pablupa contran sharcapäcushpan payta tucuyta ashlergan. Tsaymi röpanta tapshirishpan Pablo caynog nergan: “Jesucristuta mana chasquicushpayquimi quiquiquicuna jutsayog caycanqui Tayta Diosnintsi infiernuman gaycushunayquipag. Jesucristupa wilacuyninta wilapashgächönaga manami jutsayognatsu cä. Gamcuna chasquicuyta mana munapäcuptiquimi mana Israel runacunamanna aywashag Jesucristupa wilacuyninta wilapänäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tsauraga tsay sinagogacho yachatsinanpa trucanga Pablo aywargan Ticio Justupa wayinman tsaychöna yachatsinanpag. Justoga mana Israel runa caycarpis Tayta Diosnintsi munashgannog cawag runami cargan. Paypa wayenga cargan sinagogapa naupalanchömi. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tsaycho yachatsiptinmi sinagogapa mandagnin Crispo jutiyog runa wayincho tagcunawan Jesucristuta chasquicärergan. Jesucristuta Crispo chasquicushganta mayaycurmi Corinto marcacho waquin runacunapis Jesucristuta chasquicur bautizacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Juc tsacaymi Pabluta yuriparcur Jesucristo caynog nergan: “Mana mantsacuypa pitapis wilacuynëta wilapay. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mana cachaypami gamta yanapaycä cay marcacho imapis mana pasashunayquipag. Nogata chasquicamänanpäga atsca runacunami caycan cay marcacho.” ");
INSERT INTO qvmNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tsaynog niptinmi Corinto marcacho Pablo targan juc wata sogta quilla, Jesucristupa ali wilacuyninta yachatsishpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galión jutiyog runa Acaya provinciapa mandagnin canan witsanmi Pabluta tsarircur Israel runacuna apapäcorgan Galionpa despächunman. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Tsaychömi paycuna nipäcorgan: “Cay runaga Romacho mandamagnintsi emperador mana munashgan religiontami yachaycätsin. Tsaymi payta gamman apamushcä lutanta yachatsishganpita castiganayquipag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tsauraga Pablo rimananpag caycaptin Israel runacunata Galión caynog nergan: “Cay runa leynintsicuna nishganta rasunpa mana cäsuptenga nimashgayquicunata chasquëmanmi. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Costumbrilayquicunapita rimanacuptiquega manami imatapis musyayta munätsu. Tsay rimanacushgayquitaga quiquiquicuna arreglapäcuy.” ");
INSERT INTO qvmNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tsaynog nirmi paycunata despächunpita gargorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Paycunawanmi caycargan sinagogapa mandagnin Sóstenes. Israel runacunata garguptinmi despächo puncucho mana Israel cag runacuna chiquishpan Sóstenesta magapäcorgan. Despächo puncucho magapäcuptinpis Galionga manami washargantsu. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Tsaypita atsca quillaragmi Pablo targan Corinto marcacho. Nircurnami waugui-panicunapita despidicur Cencrea marcaman aywargan. Tsaychönami agtsanta rutucorgan Tayta Diosnintsita promitishganta cumplinanpag. Tsaypitanami Priscilawan y Aquilawan Siria provinciaman büquiwan aywapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso marcaman chayaycurmi sinagogaman aywargan Jesucristo salvamagnintsi cashganta wilacunanpag. Tsaypitanami Priscilata y Aquilata cachaycur Efesupita Pablo aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tsaynog aywacuycaptinmi tsay sinagogacho juntacag runacuna Pabluta ruwacärergan paycunata goyäpänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tsaynog ruwacuptinpis Pablo despidicorgan caynog nir: “Cananga Pascua aniversariupagmi Jerusalenman imaycanogpis chayayta munaycä. Tayta Dios munaptenga yapaymi cutimushag.” Tsaynog nishpanmi büquiwan Efesupita Pablo aywacorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea marcaman chayarna Jerusalenman aywargan tsaycho cag waugui-panicunata watucunanpag. Tsaypitana aywargan Antioquía marcaman tsaycho tänanpag. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tsaycho tarcurnami Galacia y Frigia provinciacunapa yapay aywargan marcan marcan, waugui-panicunata Jesucristupa wilacuyninta yachatsishpan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","25","Tsay witsanmi Efeso marcaman chayargan Apolos jutiyog Israel runa. Payga cargan Alejandría marcapitami. Tayta Diosnintsipa palabranta ali yacharmi churaypa churar runacunata shumag yachatseg. Tsaynog captinpis Jesucristupita Juan Bautista wilacushgalantami payga musyargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Sinagogachömi Jesucristupita Apolos pitapis mana mantsacuypa wilacorgan. Juan Bautista yachatsishgancunalata Apolos yachatsiptinmi Priscilawan Aquila wayinman pushaycur Jesucristupita masta tantyatsergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tsaypita Acaya provinciaman Apolos aywayta yarpaptin waugui-panicuna shacyätsergan tsaypa aywananpag. Tsaymi cartatapis apatsergan Acayacho cag waugui-panicuna Apolos chayaptin ali chasquicärinanpag. Tsayman chayaycurna waugui-panicunata shumag tantyatsergan Jesucristupa ali wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tsaynogpis Israel runacunata tantyatsergan Tayta Diosnintsipa palabrancho Jesuspita escribiraycashgancunata. Tsaynogpami tantyatsergan Jesusga salvamagnintsi Cristo cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Corintucho Apolos caycaptinmi Antioquiapita Pablo chaquilapa aywargan Efesuman. Chayaycurmi tarergan Juan Bautista yachatsishganta chasquicogcunata. Paycunatanami caynog taporgan: “¿Gamcunaga Santu Espirituta chasquicärishcanquicu?” Tsaynog tapuptinmi paycuna nergan: “Manami imaypis mayapäcushcätsu Santu Espíritu cashgantaga.” ");
INSERT INTO qvmNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tsaymi Pablo yapay taporgan: “Tsauraga ¿pipa yachatsicuynintatag wilapäshushcanqui bautizacärinayquipag?” Tsaynog niptinmi nipäcorgan: “Juan Bautistapa yachatsicuynintami wilapämashga bautizacärinäpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tsauraga Pablo nergan: “Juan Bautistaga runacunata bautizargan jutsancunata cacharir Dios munashgannog cawananpagmi. Nircurmi paycunata yachatsergan Jesucristo shamuptin payman yäracärinanpag.” ");
INSERT INTO qvmNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pablo tsaynog niptinmi tsay wauguicuna Jesucristupa jutincho bautizacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nircurnami paycunapa umanta yataycur Tayta Diosnintsita Pablo manacorgan. Tsay hörami Santu Espirituta lapanpis chasquicärergan. Tsaymi juc idiömacunapa parlashpan Tayta Diosnintsi tantyatsishgancunata parlapäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tsay wauguicuna chunca ishcaynogmi (12) capäcorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Efesucho tarmi quimsa quilla Pablo aywargan sinagogaman. Tsaychömi runacunata shumag tantyatsergan Jesucristupa ali wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","10","Tsaynog yachatsiptinpis waquin runacunaga manami chasquicuyta munapäcorgantsu. Chasquicuyta mana munarmi paycunaga runacunata shimita gorgan Pablo yachatsishganta mana chasquicärinanpag. Tsaynog captinmi waugui-panicunawan Tiranno jutiyog runapa escuëlanman Pablo aywargan. Tsaychönami ishcay wata waran waran yachatsergan. Tsaynogpami Asia provinciacho tagcuna, Israel runa carpis y mana Israel runa carpis, mayapäcorgan Jesucristupa wilacuyninta. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tsaychömi Tayta Dios yanapaptin milagrucunatapis Pablo rurargan. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Tsaymi runacuna pañuëlunta o ima röpantapis Pabluta töparcatsir gueshyagcunaman apapäcorgan. Tsayta yataycurnami tsay gueshyagcuna aliyargan. Tsaynoglami demoniucunapis runacunapita yargorgan. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jesuspa jutincho demoniucunata runacunapita gargushganta musyarmi waquin Israel runacunapis Jesuspa jutincho demoniucunata garguyta munargan. Tsaymi caynog nipäcorgan: “Pablo wilacushgan Jesuspa jutinchömi cay nacatsishgayqui runapita gamta gargö.” ");
INSERT INTO qvmNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tsaynog rurapäcorgan Esceva jutiyog runapa ganchis tsurincunami. Escevaga cargan mandag cürami. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Paycuna juc cuticho tsaynog garguyta camaptinmi demonio caynog nergan: “Noga reguëmi Jesusta. Tsaynogmi Pablo pï cashgantapis musyä. Gamcunaga ¿pitag canqui nogata gargamänayquipäga?” ");
INSERT INTO qvmNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tsaynog nirmi tsay demonio nacatsishgan runa löcutashpan Escevapa tsurincunata pasaypa magar röpancunatapis rachir ushargan. Tsaymi pasaypa yawarlana garapächula tsay wayipita gueshpir aywacärergan. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Tsaynog rurashgancunata mayar Efesucho Israel runacuna y mana Israel runacunapis fiyupa mantsacorgan. Tsay pasashganta mayarmi may-tsaychöpis runacuna musyapäcorgan Jesucristo munayniyog cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tsaynogpis waquin runacuna Jesucristuta chasquicushpan jutsa rurashgancunata wilacorgan caynog nir: “Jesucristuta chasquicushgana carmi cananga tsay jutsa ruraycunata cacharishcäna.” ");
INSERT INTO qvmNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tsaynoglami brüju ruracunan libruncunatapis atscata apapäcamorgan lapanpa naupancho rupatsipäcunanpag. Tsay librucuna ayca cuestashgantapis cuentata jorguptin chayargan pitsga chunca waranga (50,000) jornalpa chaninman. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tsaynogpami Jesucristupa wilacuynin may-tsaymanpis chayaptin runacuna tantyargan lapanpagpis Jesucristo munayniyog cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tsaypitanami Pablo yarpargan Jerusalenpa aywananpäga Macedoniacho cag waugui-panicunata y Acayacho cag waugui-panicunata watucuytarag. Tsaynogpis yarpargan Jerusalenpitaga Romapana aywananpag cashganta. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tsaynog yarparmi Macedonia provinciaman naupananpag cachargan Timoteuta y Erastuta. Pablumi itsanga Asia provinciacho quëdacorganrag. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tsay witsanmi Efesucho waquin runacuna fiyupa rabiacärergan Jesucristuta chasquicunanpag Pablo wilacuptin. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tsaychömi Artemisa nishgan ïdulupa tacsha capillanta runacuna rantipäcog wayincho tsararänanpag. Tsay capillacunatami Demetrio jutiyog runa guellaypita rurag. Tsay capillacunata ranticurmi Demetrioga capilla rurag mayincunawan atsca guellayta gänapäcog. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tsauraga arog mayincunata shuntaycurmi Demetrio caynog nergan: “Gamcuna musyapäcunquimi cay capillacunata rurar ali gänashgantsita. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gamcuna ricashgayquinogpis y mayashgayquinogpis Pablo yachaycätsin: ‘Runa rurashgan ïdulucunaga manami rasunpa Diostsu’ nishpan. Tsaynog yachatsir criyitsishga atsca runacunatami. Manami cay Efeso marcalachötsu tsaynog yachatsishga, sinöga intëru Asia provinciachöpis tsaynoglami yachatsishga. ");
INSERT INTO qvmNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Runacunata tsaynog criyitsiptin capilla rurashgantsita mananami rantimäshunpagnatsu. Tsaynogmi Artemisa diosnintsipa templuntapis manacagman churapäconga. Tsaynog captenga Artemisatapis runacuna mananami adoranganatsu. Paytaga may-tsaychöpis runacuna ad