﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvhNT_vpl;
CREATE TABLE qvhNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvhNT_vpl WRITE;
INSERT INTO qvhNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo rey David castapita aywaragmi cargan. Davidnami cargan Abrahampa castanpita aywarag. Saymi Abrahampita galaycur Jesucristupa unay castancuna caycuna cayargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa surinmi cargan Isaac. Isaacpa surinmi cargan Jacob. Jacobpa surinmi cargan Judá y waquin wauguincunapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judäpa surincunami cayargan Fareswan Zara. Paycunapa mamanmi cargan Tamar. Farespa surinmi cargan Esrom. Esrompa surinmi cargan Aram. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa surinmi cargan Aminadab. Aminadabpa surinmi cargan Naasón. Naasonpa surinmi cargan Salmón. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa surinmi cargan Booz. Boozpa mamanmi cargan Rahab. Boozpa surinmi cargan Obed. Obedpa mamanmi cargan Rut. Obedpa surinmi cargan Isaí. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaïpa surinmi cargan rey David. Rey Davidpa surinmi cargan Salomón. Salomón yurergan Uriaspa viüdanchömi. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa surinmi cargan Roboam. Roboampa surinmi cargan Abías. Abiaspa surinmi cargan Asa. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa surinmi cargan Josafat. Josafatpa surinmi cargan Joram. Jorampa surinmi cargan Uzías. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa surinmi cargan Jotam. Jotampa surinmi cargan Acaz. Acazpa surinmi cargan Ezequías. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa surinmi cargan Manasés. Manasespa surinmi cargan Amón. Amonpa surinmi cargan Josías. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa surinmi cargan Jeconías y waquin wauguincunapis. Jeconías cawanan wisanmi Israel runacunata Babilonia soldäducuna prësu sarircur apayargan Babilonia nacionman. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Saychönami Jeconiaspa surin Salatiel yurergan. Salatielpa surinmi cargan Zorobabel. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa surinmi cargan Abiud. Abiudpa surinmi cargan Eliaquim. Eliaquimpa surinmi cargan Azor. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa surinmi cargan Sadoc. Sadocpa surinmi cargan Aquim. Aquimpa surinmi cargan Eliud. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa surinmi cargan Eleazar. Eleazarpa surinmi cargan Matán. Matanpa surinmi cargan Jacob. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa surinmi cargan Mariapa runan José. Mariapa wawanmi cargan Jesús. Paymi cargan Tayta Dios cachamushgan salvamagninsi. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Saymi Abraham cawashgan wisanpita David yurishganyag chunca chuscu (14) generación cargan. Saynölami David cawashgan wisanpita Israel runacunata Babiloniaman apayashgan wisanyag chunca chuscu (14) generación cargan. Saynölami Babiloniaman apayashgan wisanpita Jesucristo yurishganyag chunca chuscu (14) generación cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo caynömi yurergan. Mariawan tänanpä José parlacush caycarpis paywan manami punorganräsu. Sayno caycaptinpis María gueshyag ricacorgan Santu Espiritupa munayninwanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gueshyag ricacuptinpis Josëga ali runa car manami munargansu runacuna Mariata jamuränanta. Saymi mana quejacuylapa cachariyta yarpargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cacharinanpä yarpachacuycaptinmi Tayta Diosninsipa angilnin Josëta sueñuynincho nergan: “Rey Davidpa castan José, Mariaga manami pï runawanpis punushgasu gueshyag ricacunanpä, sinöga Santu Espiritupa munayninwanmi gueshyag ricacush. Sayno caycaptenga mana rabiacuylapa warmiquipä Mariata shuntacuy. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Olgu wamratami María gueshyaconga. Runacuna jusalicushgancunata perdonar salvananpä captinmi say wamrapa jutin canga Jesús.” Sayno nirmi Josëta sueñuynincho ángil parlapargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jesús yurinanpämi Tayta Diosninsipa profëtan guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Juc doncëlla jipashmi gueshyag ricacur olgu wamrata gueshyaconga. Say wamrapämi niyanga ‘Emanuel’ cashganta.” (Emanuel ninanga caycan “Tayta Diosninsi nogansiwanmi caycan” ninanmi.) ");
INSERT INTO qvhNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sayno niptinmi José punuycashganpita riccharcamur Tayta Diosninsipa angilnin nishgannöla Mariata shuntacorgan warminpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Isanga Mariawan taycarpis paywan manami punorganräsu wawan yurishganyag. Mariapa wawan yuriycuptinmi jutinta José churapargan Jesús jutin cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Israel nacioncho Herodes rey caycaptinmi Judea provinciacho caycag Belén marcacho Jesús yurergan. Yuriycuptinmi inti jegamunan cag lädupita goyllar estudiag runacuna Jerusalenman chaycur tapucuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“¿Maychötä Israel runacunapa mandagnin rey cananpä yureg iti caycan? Inti jegamunan lädupa goyllarnin jegamogtami ricayashcä. Saymi payta adorag shayämushcä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey cananpä wamra yurishganta wiyaycurmi rey Herodes fiyupa rabiar yarpachacorgan imanöpapis say wamrata wanusinanpä. Saymi Jerusalencho tag runacuna segaypa mansacäyargan cayno yarpäyashpan: “Cananga ¿imatarä ruranga Herodes?” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rey Herodisga mandag cüracunata y Moisés guelgashganta yachasegcunata gayaycasir taporgan: “¿Maychötä Tayta Dios cachamunanpä cag Cristo yurinanpä caycan?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sayno tapuptinmi paycuna niyargan: “Judea provinciacho caycag Belén marcacho yurinanpämi guelgaraycan, taytay. Saycho yurinanpämi Tayta Diosninsipa profëtan cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belenchömi Israel runacunapa mandagnin rey yurengapä. Saychömi yurenga Judea provinciacho jatusag marcacunapita tacshala caserío captinpis.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sayta wiyaycurmi Herodes pacaylapa gayasergan goyllar estudiagcunata. Paycuna chaycuyaptinmi taporgan say goyllarta imaypitana ricayashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Imaypita-pasa ricayashgantapis wilayaptinmi Herodes nergan: “Belenman aywaycur say wamrata ashiyämuy. Tariycorga wilayämanqui nogapis adorag aywanäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Sayno niptinmi goyllar estudiag runacuna aywayargan. Aywaycäyaptinna say ricayashgan goyllarpis paycunapa puntanta aywargan wamra caycashgan cag wayiman chäyashganyag. Chaycuyaptinna say pushag goyllar ichicuycorgan wayi janan ciëlucho. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Saycho ichicuycogta ricarmi goyllar estudiagcuna fiyupa cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Saymi say wayiman yaycuyashpanna tariyargan Jesusta y maman Mariatapis. Jesusta ricaycurmi puntanman gongurpacuycuyashpan payta adorayargan. Nircurnami garayänanpä apayashgan gorita, inciensuta y mïrra nishgan perfümitapis churapäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cuticuyänanpä caycäyaptinnami paycunata Tayta Diosninsi sueñuynincho parlapargan Herodes cagman manana cutiyänanpä. Sayno parlapaptinmi juc nänipana marcanman cuticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Goyllar estudiag runacuna marcanman cutisquiyaptinnami Josëta sueñuynincho Tayta Diosninsipa angilnin wilargan: “Rey Herodismi ñïñu Jesusta wanusinanpä ashisenga. Mana wanusinanpä mamantinta Jesusta Egipto nacionman gueshpisiy. Saychöna tanqui cutimunayquipä wilashgäyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sayno niptinmi Josëga riccharcamur jinan höra pasa manarä waraptin mamantinta Jesusta apacurcur Egiptupa aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Saychömi paycuna täyargan Herodes wanushganyag. Sayno cananpä captinmi Tayta Diosninsi tantyasergan wilacognin profëtata guelgananpä: “Wamrä captinmi Egiptupita gayamushcä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Goyllarta estudiag runacuna Jesús maycho cashgantapis wilag mana cutiycuptinmi rey Herodisga fiyupa rabiacorgan. Saymi Jesusta wanusiyta munar soldäduncunata cachargan Belén marcacho y naupan estanciacunachöpis olgu wamracunata wanusiyänanpä. Goyllarta estudiag runacuna imaypita-pasa goyllarta ricashganta wilapash captinmi Herodes tantyacorgan Jesús juc o ishcay watayogna cashganta. Saymi wamracunata wanusiyargan sayrä yurish caycagcunapita ishcay watayogyag. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sayno päsaptinmi Tayta Diosninsipa unay profëtan Jeremías guelgashganno cumplergan. Paymi cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá nishgan marcachömi pï-maypis laquicuyashpan segaypa wagaycäyan. Wawancuna wanuycuptinmi shogayaptinpis mana chawaypa Raquel wagaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Egiptucho José caycaptinmi Herodes wanorgan. Saymi sueñuynincho Tayta Diosninsipa angilnin Josëta nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mamantinta Jesusta apacurcur Israelmanna cuticuy. Jesusta wanusiyta munagcuna wanuyashganami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ángil sayno niptinmi jinan höra Josëga Israelman cuticorgan mamantinta wamrata apacurcur. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cutiycarnami José musyargan Judea provinciacho rey Herodispa trucan surin Arquelao mandag caycashganta. Sayta musyarmi José mansarergan Judeaman cutiyta. Sayno mansariptinmi sueñuynincho Tayta Diosninsi nergan Judeaman aywananpa trucanga Galilea provinciamanna aywacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea provinciaman charnami Nazaret marcaman aywargan saycho tänanpä. Saycho tänanpä cashganpitami Tayta Diosninsipa profëtancuna cayno guelgayargan: “Runacuna niyanga Nazaret runa cashgantami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús wilacuyta manarä galaycuptinmi Juan Bautista Tayta Diosninsipa wilacuyninta wilacur galaycorgan. Judea provinciacho caycag sunyag pasapa puriptinmi runacuna sayman aywayargan wilacushganta wiyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Chäyaptinmi pay wilapargan: “Tayta Diosninsipa maquincho ali cawanapä cag tiempo chämushganami. Sayno captenga jusalicuycunata cacharir Tayta Diosninsi munashgannöna cawayay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan Bautista manarä yuriptinmi Tayta Diosninsipa profëtan Isaías paypita cayno guelgargan: “Sunyag jircachömi juc runa gayacuypa wilaconga: ‘Mandag runa shamuptin chasquicunayquipä nänita pisar puestucuyashgayquino jusalicuycunata cacharir puestucuyay Tayta Diosninsi shamuptin chasquicuyänayquipä’ ” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan Bautistapa mödanan cargan camëllupa milwalanpita awashmi. Wachcunpis cargan camëllo garapita rurashmi. Chucluscunata y tinyagpa mishquinta micularmi pay purergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wilacur puriycashganta wiyarmi Jerusalenpita y Judea provinciacho cag may-say marcacunapitapis asca runacuna Juan cashgan cagman aywayargan wilacushganta wiyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juan wilacushganta chasquicurmi say runacuna tantyacuyargan jusayog cayashganta. Saymi Tayta Diosta perdonta manacuyaptin Jordán mayucho paycunata Juan bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sayman asca fariseo y saduceo runacuna bautizacuyänanpä shamogta ricarmi Juan Bautista nergan: “¡Culebra casta runacuna! ¿Imanirtä gamcuna yarpaycäyanqui jusayog captiquipis Tayta Diosninsi infiernuman mana gaycuyäshunayquipä cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tayta Diosninsi infiernuman mana gaycuyäshunayquipäga jusalicuycunata cacharir pay munashgannöna cawayay. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama yarpäyaysu Abrahampa castan cayashgalayquipita Tayta Diosninsi salvayäshunayquipä cashganta. Tayta Dios munarga cay rumicunatapis Abrahampa castanman ticrarasinmanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Mana ali wayog jachacunata chaquipita muturir ninaman gaycushgansinömi Tayta Diosninsega jusalicogcunata infiernuman gaycunanpä listuna caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nogaga yaculawanmi gamcunata bautizä jusalicuyta cacharir Tayta Dios munashganno cawayänayquipä. Tayta Diosninsi cachamushgan Cristumi isanga munayyog caycan Santu Espirituwan y ninawanpis bautizayäshunayquipä. Nogaga manami payno munayyogsu caycä. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Payga jurquëtan aptashmi caycan trïguta wayrananpä. Nircurmi trïgu cagta churanga wayinman. Y punshan cagtana gayconga imaypis mana upeg ninaman saycho rupananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesuspis Galilea provinciapitami aywargan Jordán mayuman bautizacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sayman chaptinmi paytaga Juan bautizayta munargansu: “Tayta Diosninsi cachamushgan Cristo caycaptiquega ¿imanöpatä gamta bautizäman? Bautizanäpa trucanga nogatacher antes bautizaycalämanquimanga” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sayno niptinmi Jesús nergan: “Imano captinpis bautizaycalämay. Bautizamänayquitami Tayta Diosninsi munan.” Sayno niptinmi Juan bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yacupita sharcurcurmi Jesús ricargan ciëlo quichacascamuptin Santu Espíritu palomano payman uraycämogta. ");
INSERT INTO qvhNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Saymi ciëlupita wiyacämorgan Tayta Dios cayno nimushgan: “Payga cuyay surëmi caycan. Noga munashgäno lapanta ruraptinmi cushish caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Saypitanami Jesusta Santu Espíritu pushargan sunyag jircaman Satanás jusalicasiyta camananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Saychömi chuscu chunca (40) junag y chuscu chunca pagas ayunashpan Tayta Diosta Jesús manacorgan. Saypitanami Jesusta wanunayparä micanay saricuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sayno micanaycaptinmi Satanás yuripaycur nergan: “Diospa surin caycarga micunayquipä cay rumicunata tantaman ticrasiy, ari.” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sayno niptin Jesús nergan: “Tayta Diospa palabrancho caynömi nican: ‘Manami micuyta micularsu runacuna cawayan, sinöga Tayta Dios nishgancunata cäsucuyashpanpis cawayanmi.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Saypitanami elagpita Jesusta Satanás ricacascasergan Jerusalén templo janancho. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Saychönami payta nergan: “Diospa surin carga caypita pampaman saltarpuy. Diospa palabranchöga caynömi guelgaraycan: ‘Angilnincunatami Tayta Dios cachamonga maycho captiquipis cuidashunayquipä. Paycunami sariyäshunqui pampaman jegaptiqui ni chaquilayquitapis rumicunaman mana tacacunayquipä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Niptinmi Jesús nergan: “Tayta Diospa palabranchöga caynömi nican: ‘Tayta Diosta ama obligaysu quiquiqui munashgayquita rurasinayquipä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Saypitanami altunnin jirca puntacho Jesusta Satanás elagpita ricacascasergan. Saypitanami ricasergan may-say nacioncunata y say nacioncunacho cag riquëzacunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nircurmi nergan: “Gongurpaycur nogata adoramaptiquega cay ricashgayqui nacioncunata y saycho cag riquëzacunatami goycushayqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sayno niptinmi Jesús nergan: “¡Witicuy, Satanás! Tayta Diospa palabranchöga caynömi nican: ‘Tayta Dioslatami adoranayqui y pay japalantami sirvinayqui.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sayno niptinmi Satanás aywacorgan. Saypitami angilcunapis sayman chäyargan Jesusta yanapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista carcilcho wichgaraycaptinnami Galilea provinciacho caycag Nazaret marcaman Jesús cuticorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Saypitanami Nazaret marcacho tänanpa trucanga Capernaum marcamanna aywargan saycho tänanpä. Say marcaga cargan Galilea gocha cuchunchömi, Zabulonpa y Neftalïpa castan runacuna täyashgan cagcho. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesús saycho tänanpä captinmi Tayta Diosninsipa profëtan Isaías cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Galilea gochapa naupancunacho tag mana Israel runacuna, Jordán mayupa wac simpancho tag runacuna, y Zabulonpa y Neftalïpa castan runacunapis, lapayqui wiyayämay. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Sacäpacushno lutan ruraycho cawag runacunami Tayta Diosninsipa wilacuyninta wiyayash. Tayta Dios nishganta mana cäsucogcunapämi inti asicyashganno Tayta Diosninsipa wilacuynin chash.” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Isaías guelgashganno Capernaumcho tashpanmi Jesús wilacur galaycorgan: “Tayta Diosninsipa maquincho ali cawanapä cag tiempo chämushganami. Sayno captenga jusalicuycunata cacharir Tayta Diosninsi munashgannöna cawayay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Saypita Galilea gocha cuchunpa aywaycashganchömi Jesús ricargan ishcay runacuna redninta yacuman mashtaycäyagta. Paycunami cayargan Simonwan wauguin Andrés. Simonpa jucag jutinmi cargan Pedro. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Paycunatami Jesús nergan: “Discïpulö cayänayquipä nogawan aywashun. Gamcunata yachasishayqui pescäduta sariyänayquipa trucanga runacunatana Tayta Diosninsipa wilacuyninta wilapäyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sayno niptinmi redninta cachariycuyashpan jucla Jesuswan aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Saypita más wacläpa aywaycäyashganchönami ricargan Santiagutawan Juanta. Paycunaga taytan Zebedeuwanmi büquincho rednincunata shilpaycäyargan. Paycunatapis discïpulun cananpämi Jesús gayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gayaptinmi paycunapis jucla Jesuswan aywayargan taytanta büquicho cachaycur. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Saypitanami marcan marcan intëru Galilea provinciapa Jesús purergan Tayta Diosninsipa wilacuyninta sinagogacunacho yachasishpan. Saynöpis tucuy-nirag gueshyawan gueshyagcunata aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria nación marcacunachöpis gueshyagcunata Jesús aliyäsishgan musyacargan. Saymi paycunapis Jesús cagman apayargan tucuy-nirag gueshyawan gueshyagcunata, supay nacasishgan runacunata, wanuy gueshyawan nacagcunata y paralïticucunatapis. Say gueshyagcunata lapantami Jesús aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Saysica runacunami Jesusta gatiräyargan Galilea marcacunapita, Decápolis marcacunapita, Jerusalenpita, Judea marcacunapita y Jordán mayu wac simpancunapitapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Saypita juc junagnami asca runacunata ricar jircanninman Jesús discïpuluncunawan wisargan saypita yachasimunanpä. Saycho jamaycurmi Jesús yachasergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushishmi cawayanga Tayta Dioslaman imaypis yäracur cawag runacunaga. Paycunatami Tayta Diosninsi naupanman pushangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Cushishmi cawayanga laquicogcunaga. Paycunatami Tayta Diosninsi tantyasenga mana laquicuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Cushishmi cawayanga mana yachag-tucuypa runa mayinwan ali cawagcunaga. Paycunami mushog pasata Tayta Diosninsipita herenciata chasquiyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Cushishmi cawayanga micanaypanörä y yacunaypanörä Tayta Diosninsi munashganno cawayta munagcunaga. Paycunatami Tayta Diosninsi imaypis yanapangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Cushishmi cawayanga runa mayinta cuyapagcunaga. Paycunatami Tayta Diosninsi cuyapangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Cushishmi cawayanga mana jusalicuypa Tayta Dios munashganno cawagcunaga. Paycunami Tayta Diosninsipa naupanman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Cushishmi cawayanga runa mayinta amistasegcunaga. Paycunatami Tayta Diosninsi: ‘Wamrämi canqui’ nengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Cushishmi cawayanga Tayta Diosninsi munashganno cawayashganpita chiquish cagcunaga. Paycunatami Tayta Diosninsi naupanman pushangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nogata chasquicayämashgayquipita runacuna ashliyäshuptiqui, chiquiyäshuptiqui y lulacur imaycatapis jitapäyäshuptiqui ama laquicuyaysu. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sayno nacayashgayquipitami Tayta Diosninsi premiuta gloriacho puestupäyäshunquipä. Gamcunatanömi Tayta Diosninsipa unay profëtancunatapis nacasiyargan. Sayno caycaptenga imano nacarpis cushicuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamcuna cay pasacho cachinömi caycäyanqui. Cachi sulur rumilan quëdaptin manami imapäpis välinsu. Say mana välegta jitariptin pï-maypis jarucunmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Saynöpis acsinömi cay pasacho caycäyanqui. Sayno caycaptenga alayrinnincho marca cashganno gamcunapis runacuna ricacuyäshunayquipä shumag cawayay. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Manami pipis acsita sarisinsu cajun rurinman pacananpä, ni cawitu rurinman pacananpäga. Saypa trucanga alayrinninmanmi churan wayicho lapanta asicyapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Runacuna sacaypa ricayänanpä acsi rataraycashganno gamcunapis runacuna ricacuyäshunayquipä Tayta Dios munashganno cawayay. Sayno cawayashgayquita ricacurmi paycunapis tantyacuyanga Tayta Diosninsi munashgannöna cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama yarpäyaysu Moisés guelgashgan leycunata y profëtacuna guelgayashgancunata manacagman churanäpä shamushgäta. Saypa trucanga shamushcä say guelgaraycashganta runacuna imanöpa cumplinanpä cashganta tantyasinäpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ciëluwan cay pasa manarä ushacaptinmi Moisés y Tayta Diospa waquin profëtancuna guelgayashgancunapis lapan cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sayno caycaptenga pipis say guelgayashgancunata mana cäsucur y waquin runatapis mana cäsucunanpä yachaserga Tayta Diospa naupancho manacagman churashmi canga. Say guelgayashgancunata cäsucur y waquin runatapis cäsucunanpä yachasirmi isanga Tayta Diospa naupancho aliman churash canga. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sayno caycaptenga Tayta Diosninsipa palabran nishganno cawayay. Fariseo runacunano y Moisés guelgashgan leycunata yachaseg runacunano janan shongula cumpleg-tucorga gamcunapis manami Tayta Diosninsipa naupanman imaypis chäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gamcuna musyayanquimi Moisés guelgashgancho cayno nishganta: ‘Runa mayiquita ama wanusinquisu. Runa mayinta wanuseg cäga juzgashmi cangapä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sayno niptinpis noga caynömi në: Manami runa mayinta wanuseg caglatasu Tayta Diosninsi juzganga, sinöga runa mayinta rabiapag cagtapis, runa mayinta ashleg cagtapis y runa mayinta manacagman churag cagtapis Tayta Diosninsi juzgar infiernumanmi gaycongapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Sayno caycaptenga Tayta Diosninsipä ofrendata altarman aparpis runa mayiquiwan resientisinacush cashgayquita yarpar ofrendayquita saycho cachaycur aywanqui resientisinacuyashgayquiwan amistanayquipä. Nircurrä ofrendata Tayta Diosninsipä entreganqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Saynöpis jaganta mana pägaptiqui quejacushuptiquega autoridäman manarä char arreglayay. Mana arreglaptiquega juezmanmi apasishunquipä. Jueznami wardiacunawan carcilman wichgasishunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Saypitaga manami yarguyanquipäsu lapan jagan cashgayquita manarä pägapacorga. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gamcuna musyayanquimi Moisés guelgashgancho cayno nishganta: ‘Ama adulteriucho cayanquisu.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sayno niptinpis noga caynömi në: Yarpaylayquichöpis juc warmita munaparga maynami adulteriucho cagno caycanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Sayno captenga warmita ricar munaparga nawiquita jorgurir jitariycuy, derëcha cag nawiqui captinpis. Infiernuman gaycush canayquipa trucanga más alimi canman wisculapis gloriaman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Saynöla munapashgayqui warmita yataparga maquiquita cusurir jitariycuy, derëcha cag maquiqui captinpis. Infiernuman gaycush canayquipa trucanga más alimi canman juc maquiyoglapis gloriaman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gamcuna musyayanquimi Moisés guelgashgan leycunacho cayno nishganta: ‘Pipis warminwan raquicar imarga papilta firmapäsun raquicashgan musyacänanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sayno niptinpis noga caynömi në: Pipis warminpita ama raquicäsunsu. Mana jarucuycaptinpis raquicarga jusayogmi caycan warmin juc runawan tar adulteriucho cananpä. Saynölami raquicash warmiwan tag runapis adulteriucho caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Saynöpis gamcuna musyayanquimi Moisés guelgashgan leycunacho cayno nishganta: ‘Imatapis ruranayquipä jurashpayquega mana gongaylapa cumplinqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Sayno niptinpis noga caynömi në: Imaypis ama juraysu ‘Por Dios’ nirpis, ni ‘Por la tierra’ nirpis ni ‘Por ciëlo’ nirpis ni ‘Por Jerusalén’ nirpis. Cay pasaga Tayta Diosninsipa chaquin jaruräcunanmi caycan. Ciëloga Tayta Diosninsipa trönunmi caycan. Jerusalenga Tayta Dios acrashgan marcami caycan. Saymi ‘Por la tierra’ o ‘Por ciëlo’ o ‘Por Jerusalén’ nir jurashpayquega Tayta Diospa jutinta lutala jogaregno caycanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Waquinnami: ‘Por mi cabëza’ nishpan jurayan. Ni saynöpis ama jurayaysu. Tayta Diosnilansimi munayyog caycan agsayquita yanaman y yuragman ticrasinanpäpis. Saymi ‘Por mi cabëza’ nir jurarpis Tayta Diospa jutinta lutala jogaregno caycanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Juranayquipa trucanga aunerga auninqui, mana aunerga ama auninquisu. Jurayparä auniparga jusalicuycanquimi. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Musyanquimi Moisés guelgashgan leycunacho cayno nishganta: ‘Nawinta jorguptenga quiquinpa nawintapis jorgusun. Quirunta jorguptenga quiquinpa quiruntapis jorgusun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sayno niptinpis noga caynömi në: Chiquishuptiquipis ama nanaparaysu. Lagyayäshuptiquipis jucag cärayquita camapäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pipis demandacushushpayqui chompayquita guechuyäshuptiquega punchuyquitapis cachapariycuyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Guepinta media lëwayag apapänayquipä obligashuptiquega juc lëwayagpis apaparinqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Imatapis ‘Garaycalämay’ nir manacushuptiquega garaycunqui. Saynöla imatapis ‘Manaycalämay’ nir manacushuptiquega manaycunqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Saynöpis musyayanquimi runacuna cayno niyashganta: ‘Cuyanacuyashgayquiwanga cuyanacuyanqui. Chiquishogniquitaga chiquiyanqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sayno niyaptinpis noga caynömi në: Chiquishogniquicunata cuyayanqui. Contrayqui ali cawayänanpäpis Tayta Diosninsita manacuyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tayta Diosninsega ali runacunapä y mana ali runacunapäpis intita jegasimunmi. Saynölami ali runacunapä y mana ali runacunapäpis tamyasimun. Tayta Diosninsi cuyapäcog cashganno gamcunapis cuyapäcog carga paypa wamranmi caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cuyanacuyashgalayquiwan cuyanacorga ama yarpäyaysu ali runa cayashgayquita. Impuesto cobrag runacunapis cuyanacuyashgalanwanga cuyanacuyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Quiruyqui tincushgalanwan ali cawarga ama yarpäyaysu ali runa cayashgayquita. Jusasapa runacunapis saynölaga cawayanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sayno caycaptenga Tayta Diosninsi cuyapäcog cashganno gamcunapis cuyapäcog cayay. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Runa mayiquita yanaparga alabash cayänalayquipäga ama yarpachacuyaysu. Sayno cayaptiquega Tayta Diosninsi manami ima premiutapis goyäshunquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Muchogcunata yanapashpayquega say yanapashgayquita ama sumäsiyaysu waquin runacunanöga. Paycunaga pilatapis yanapaycorga pï-maypis musyayänanpämi cornëtata tucashpan sinagogacunacho y cällicunachöpis wilacuyan. Sayno cayaptinmi runacuna alabayashgalanna premiun canga. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Muchogcunata yanapashpayquega ama pitapis wilapanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pitapis mana wilapaypa muchogcunata yanapaptiquega Tayta Diosninsimi premiuta goshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Runacuna ricayänalanpämi waquin runacunaga yachag-tucuyashpan may höra Tayta Diosta manacuyan sinagogacunacho y cälli esquïnacunachöpis. Gamcunaga ama paycunano cayaysu. Paycunapäga runacuna alabayashgalannami premiun canga. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gamcunaga Tayta Diosta manacur pipis mana ricayäshunayquipä wayiquiman yaycuycur Tayta Diosta manacuyay. Tayta Diosla wiyashunayquipä manacuyaptiquega paymi premiuta goyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Waquin runacuna Tayta Diosta manacorga yaparir yaparir say palabralawanmi manacuyan. Sayno manacuyan saynöparä Tayta Diosninsi wiyananpä cashganta yarparmi. Gamcunaga ama sayno manacuyaysu. Manarä manacuyaptiquipis Tayta Diosninsega imata nistaycäyashgayquitapis maynami musyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gamcunaga Tayta Diosta cayno manacuyanqui: Gloriacho caycag Tayta Dios, pï-maytapis tantyaycasilay respitaycuyäshunayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lapan runacuna gam munashgayquino cawaycuyäläsun. Gloriacho munashgayquita rurayashganno cay pasachöpis munashgayquita ruracaycuyäläsun. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Micuyänäpä micuynë ama pishiyculäsunsu, Taytay. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chiquimagnëcunata nogacuna perdonayashgäno jusalicuyashgäcunatapis perdonaycayälämay. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jusalicasiyämayta Satanás munaptinpis sapaycayälämay, Taytay. Saynöpis yanapaycayälämay mana jusalicuypa imaypis cawayänäpä. Lapanpäpis munayyog captiquimi gampa maquiquicho imaycapis caycan, Taytay. Saymi imayyagpis alabash canquipä. Amén. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Runa mayiquita perdonayaptiquega Tayta Diosninsi gamcunatapis perdonayäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Runa mayiquita mana perdonayaptiquega Tayta Diosninsi manami gamcunatapis jusalicuyashgayquita perdonayäshunquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tayta Diosta manacuyänayquipä ayunarga ama waquin runacunanöga cayaysu. Paycunaga ayunaycäyashganta runacuna tantyacuyänanpämi aywapacashga puriyan. Sayno ayunaycashganta ricar runacuna alabayashgalannami premiun canga. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gamcuna ayunayashpayquega pipis mana tantyananpä cärayquita shumag maylacur umayquitapis nagsacurcur ayunayay. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Sayno rurayaptiquega runacuna manami musyayangasu ayunaycäyashgayquita. Ayunaycäyashgayquita runacuna mana musyaptinpis Tayta Diosninsi musyaycanmi. Saymi paypita premiuta chasquiyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Rïcu canalayquipäga ama yarpachacuyaysu. Cay pasachöga riquëzayquita puyupis ushanmi, ismurpis ushacanmi y runapis suwanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cay pasacho rïcu cayänalayquipä yarpachacuyänayquipa trucanga yarpachacuyay muchogcunata yanapäyänayquipä. Sayno cawarga gloriacho riquëzayquita churacognömi caycäyanqui. Gloriachöga manami puyupis ushangasu, ni ismongasu ni runapis suwangasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Rïcu canalayquipä yarpachacorga manami Tayta Dios munashganno cawayänayquipä yarpachacuycäyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Cay nishgäcunata tantyacur cäsucuyashpayquega Tayta Dios munashgannömi cawaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mana cäsucorga manami Tayta Dios munashgannösu cawaycäyanqui. Sayno carmi jusalicuycäyashgayquitapis tantyayanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Manami pipis ishcay patronta sirvinmansu. Ishcay patronyog carga jucninta cäsucur jucnintaga manami cäsucongasu. Jucninta cuyar jucnintaga manami cuyangasu. Saynölami rïcu canalanpä yarpachacogcunaga: ‘Tayta Diospa maquinchömi caycä’ nicarpis pay munashganno cawayta camäpacuyansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sayno caycaptenga ama yarpachacuyaysu: ‘¿Imatarä micuycushä? ¿Imatarä upuycushä? ¿Imatarä jaticuycushä?’ niyashpayqui. Micuyninsi captinpis y mödanansi captinpis manami saylachösu ali cawayta tarinsi. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Shumag tantyacuyay pishgucuna imano cawayashgantapis. Paycunaga manami murucuyansu, ni cosechayansu ni pirwacuyansu. Sayno cayaptinpis Tayta Diosninsimi micuyta puestupan. Tayta Diosninsipäga say pishgucunapitapis gamcuna masmi väliyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Mayjina yarpachacurpis ¿pirä winarcunman tamäñunpita juc cucush maslatapis? ");
INSERT INTO qvhNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sayno caycaptenga ¿imanirtä gamcuna yarpachacuyanqui ali mödanayog cayänalayquipäga? Tantyacuyay waytacuna imano cuyaylapä tuctuyashgantapis. Waytacunaga mana aruycarpis mana puscacuycarpis cuyaylapämi ricacuyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Say waytacuna cuyaylapä cayashgannöga manami unay rey Salomón jaticushgan mödanancunapis cuyaylapä cashgasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Saquiptin rupasish cananpä captinpis Tayta Diosninsega alimi guewacunata winasin. Yäracuyniynag runacuna, waytacunatapis cuyaylapäta tuctuycäserga ¿manasurä gamcunatapis Tayta Diosninsi yanapäyäshunqui mödanayquita tariyänayquipä? ");
INSERT INTO qvhNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Sayno caycaptenga ama laquicuyaysu: ‘¿Imatarä micushä? ¿Imatarä upushä? ¿Imatarä jaticushä?’ niyashpayqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Saynöga laquicuyan Tayta Diosman mana yäracog runacunalami. Gamcunaga ama paycunano laquicuyaysu. Imata nistashgayquitapis Tayta Diosninsega musyaycanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nistashgayquicunapä yarpachacuyänayquipa trucanga Tayta Diosninsi munashganno cawayänayquipä imaypis yarpachacuyay. Pay munashganno cawayaptiquega imata nistäyashgayquitapis puestupäyäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sayno caycaptenga ama laquicuyaysu waray junagpäga. Tayta Dios canan junag yanapäshushgayquinölami waray junagpis yanapäyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tayta Dios mana juzgayäshunayquipä runa mayiquita ama jamuräyaysu. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Runa mayiquita jamurar washanta rimayashgayquipitami Tayta Diosninsi gamcunatapis juzgayäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Quiquiquicunapa nawiquicunacho jatuncaray ganra jatiraycaptenga ¿imanirtä runa mayiquicunapa nawincho ichicnayla ganra caycagta ricapäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nawiquicunacho jatuncaray ganra caycaptenga ¿imanöparä runa mayiquita: ‘Nawiquicho ichicnayla ganra caycagta jorgapäshayqui’ niyanquiman? ");
INSERT INTO qvhNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ishcay cära runacuna! Puntataga jorguyay nawiquicunacho ganra caycagtarä. Sayrämi ricayanquipä runa mayiquipa nawincho ichicnayla ganra caycagta jorgupäyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tayta Diosninsipa wilacuyninta wilapaptiqui mana chasquicuyäshuptiquega ama wilapaysu mastaga. Chasquicuyta mana munaycagta wilapaptiquega gori sortïjata cuchi jarucunalanpä jitapaycognömi caycäyanqui. Saynölami wilapar exigiptiquega rabiacongapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Imaypis Tayta Diosta manacuyay. Imata nistarpis ruwacuyay. Puncuta tacacognöpis payta gayacuyay. Tayta Diosta manacogcunaga manacuyashganta chasquiyanmi. Imata nistarpis ruwacogcunaga tariyanmi. Puncuta tacacogno gayacogtaga Tayta Dios wiyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Maygayquicunatapis wamrayquicuna tantata manacuyäshuptiqui ¿rumita aptaparcuyanquimansurä? ");
INSERT INTO qvhNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Saynöla pescäduta manacuyäshuptiquipis ¿culebrata janchaparcuyanquimansurä? ");
INSERT INTO qvhNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mayjina fiyu carpis ¿manacu wamrayquicunata ali caglata aptapäyanqui? Saynölami Tayta Diosninsita manacuyaptiquega ali cagcunata puestupäyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Runa mayiqui ali ricayäshunayquita munarga gamcunapis paycunata ali ricayay. Sayno ali ricanacur cawanansipämi Moisés guelgashgancho y profëtacuna guelgayashganchöpis nican. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Infiernuman aywag puncupis nänipis anchumi caycan. Ascagmi say puncupa yaycuycäyan. Gloriaman aywanapä cagmi isanga puncupis nänipis llanula caycan. Walcaglami say puncupa yaycuycäyan. Sayno caycaptenga imanöpapis quichqui puncupa gloriaman yaycuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ ‘Tayta Diospa wilacogninmi cä’ nir shamog lutan yachasicogcunata ama chasquipäyaysu. Paycunaga Tayta Diosman yäracog-tucurpis atogno fiyumi caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lutan yachasicog cashganta musyayanqui imano cawayashganta ricarmi. Manami imaypis cashacunapita üvata palansisu. Ni jïgustapis manami wallancapita cosechansisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Trïgupis manami wayunsu cebadillutaga. Saynölami cebadillupis wayunsu trïgutaga. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Trïguta cebadillu mana wayushgannömi lutan yachasicogcunapis Dios munashganno cawansu, sinöga mana alicunata rurar cawayan. Sayno cawayaptinmi musyayanqui lutan yachasicog cayashganta. Chacracho cebadillu captenga sapipita luquirir rupasishgannömi paycunapis infiernuman gaycush cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manami jutëta jogarishgalanpitasu pipis Tayta Diospa naupanman changa. Saymanga chäyanga pay munashganno cawagcunalami. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juicio finalchöga ascagmi niyämanga: ‘Gampa wilacuyniquitami wilacur purergä, Taytay. Saynöpis gamman yäracurmi supaycunatapis gargorgä. Saynölami gamman yäracur milagrucunatapis rurargä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sayno niyämaptinpis nogaga caynömi nishä: ‘Gamcunataga manami reguësu. ¿Pirä cacuyanquipis? ¡Naupäpita witicuyay, jusasapa runacuna!’ ");
INSERT INTO qvhNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nishgäcunata wiyacamag runaga caycan cimientuta shumag ruraycur sharcasish wayinömi. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fiyupa tamyar yacu shamuptinpis y shucucuy vientu shamuptinpis ali cimientush wayega manami juchongasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nishgäcunata wiyaycar mana wiyacamag cagmi isanga caycan aguysha janancho sharcasish wayino. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aguysha janancho sharcasish captinmi tamya yacu shamuptin y vientu fiyupa vientuptin say wayi juchongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús sayno yachasiptinmi runacuna cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Payga manami Moisés guelgashgan leycunata yachasegnösu yachasergan, sinöga paycunapita más alimi yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lömacho yachasishganpita Jesús urämuptinmi saysica runacuna payta gatiräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Leprawan gueshyaycag runami Jesuspa puntanman gongurpacuycur ruwacorgan: “Sänu canäpä aliyaycasilämay, taytay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sayno ruwacuptinmi Jesús yataycorgan: “Cananpitaga aliyashganami canqui” nir. Sayno nisquiptinmi jinan höra leprawan gueshyaycashganpita aliyasquergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nircurmi Jesús nergan: “Ama pitapis wilanquisu noga aliyäsishgäta. Saypa trucanga Moisés guelgashgancho nishgannöpis templuman ayway aliyashgana cashgayquita cüra ricashunayquipä. Nircurna Moisés guelgashgancho nishgannöla aliyashgayquipita lapantapis ruranqui. Aliyashgana cashgayquita cüra nishuptiquimi lapanpis musyayanga rasunpaypa aliyashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Saypita Capernaum marcaman Jesús chaptinmi Roma soldäducunapa capitannin Jesusman aywaycur ruwacorgan: ");
INSERT INTO qvhNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ashmaynëchä pasaypa ansa wayëcho jitaraycan, taytay. Mananami sharcunanpä valorninpis cannasu” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sayno niptinmi Jesús nergan: “Aywashä ari, aliyäsinäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sayno niptinmi capitán nergan: “Israel runacunawan mana Israel runacuna mana chänacuycäyaptenga ¿imanöparächi wayëmanpis chanquiman, taytay? Saymi ruwacö ashmaynëta caylapita aliyaycasinayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nogapis mandamagnëpa munayninchömi caycä. Saynölami munaynëcho soldädöcunapis caycäyan. Maygantapis: ‘Ayway’ niptëga aywanmi. ‘Shamuy’ niptëga shamunmi. Imatapis rurananpä niptëga ashmaynëpis ruranmi. Gamga nogapita más munayyogmi canqui. Saymi yäracö nishgayqui lapanpis ruracänanpä cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitán sayno yäracuptinmi Jesús cushicorgan. Saymi paywan aywag runacunata nergan: “Payno ali yäracamag runataga manami ni Israel runacunachöpis tarishcäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","May-say nacionpita shamog runacunaga ascagmi gloriaman chäyanga Tayta Diosninsi puestushgan micuyta Abrahamwan, Isaacwan y Jacobwanpis cushishla micunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waquin runacunami isanga Tayta Diosninsipa wilacuyninta yacharpis nogata mana chasquicayämashganpita gloriaman chäyangasu. Saypa trucanga mansariypä sacaymanmi gaycush cayangapä. Saychömi fiyupa wagar quiruntapis uchuyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nircurnami capitanta Jesús nergan: “Wayiquipa cuticuy. Yäracamashgayquipitami ashmayniqui aliyashna.” Say nishgan hörami capitanpa ashmaynin aliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Saypita Pedrupa wayinman Jesús aywar tarergan Pedrupa suedran pasaypa ansa fiebriwan jitaraycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Saymi gueshyagpa maquinta Jesús yataycuptin jinan höra aliyasquergan. Aliyarcurnami micuyta paycunata garargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pasa sacaycaptinnami Jesusman apayämorgan supaycuna nacasishgan asca runacunata. Say runacunapitami supaycunata Jesús juc shimila gargorgan. Saynölami tucuy gueshyawan gueshyagcunatapis aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sayno aliyäsinanpä captinmi profëta Isaías cayno guelgargan: “Paymi gueshyansita apash. Fiyupa nacanansipä cagtapis paymi nacash” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Asca runacuna juntapaycuyaptinmi discïpuluncunata Jesús nergan: “Büquiwan wac simpaman päsashun.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Büquiwan päsananpä caycaptinmi Moisés guelgashgan leycunata yachaseg runa Jesusta nergan: “Maypa aywaptiquipis gatiräshayquimi, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sayno niptinmi Jesús nergan: “Atogcunapaga machaynincuna canmi. Saynömi pishgucunapapis gueshuncuna can. Nogapämi isanga cansu maycho punuycunaläpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Saypitanami juc discïpulun nergan: “Papänë wanuptin pampaycurrämi gamwan aywashä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Saymi Jesús nergan: “Wanushcunaga wanush mayinta pampayäsun. Gamwanga aywashun.” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sayno nircurmi büquiman discïpuluncunawan Jesús wisargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gochata simpaycäyaptinmi Jesús punucäcorgan. Sayyagmi fiyupa vientuwan yacu pulchagyar büquita talpucäsinanpäna caycargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Saymi discïpuluncuna Jesusta ricchasiyargan: “¡Talpucaycansinami! ¡Salvaycayälämay, taytay!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sayno niyaptinmi Jesús nergan: “¿Imanirtä gamcuna sayjinanpa mansacash caycäyanqui? ¿Manacu nogaman yäracayämanqui?” Nircurmi sharcurcur vientutapis yacutapis chawänanpä Jesús olgutupargan. Sayno olgutupasquiptinmi vientupis yacupis chawasquerganna. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sayta ricarmi discïpuluncunaga quiquinpura mansacash niyargan: “Yacupis vientupis sayno cäsucuyänanpäga ¡imajinanparä munayyog payga caycan!” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gochapa simparmi discïpuluncunawan Jesús chäyargan Gadara marca washaläninman. Saychömi panteonpita supaycuna löcuyäsiyashgan ishcay runacuna yargayämorgan. Paycuna segaypa mansaypä cayaptinmi pipis päsagsu say panteón puncupaga. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesusta ricäriyashpanmi fiyupa gaparäyashpan niyargan: “¡Diospa surin Jesús! Infiernuman gaycamänayquipä höra manarä chämuptin ¡cay runapita ama gargaycalämaysu!” ");
INSERT INTO qvhNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paycuna caycäyashganpita más washaläninchömi asca cuchicuna micuycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Saymi supaycuna ruwacuyargan Jesusta: “Cay runacunapita gargamarga tagay cuchicunaman yaycuyänäpä cachapaycayälämay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sayno manacuyaptinmi Jesús aunergan manacuyashganta. Auniptinmi supaycuna ishcan runacunapita yargurir yaycucuycuyargan say cuchicunaman. Saymi cuchicunaga löcutäyashpan tunapa cörrir gochaman jegacurpuyargan. Saychömi shengaypa wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sayta ricaycurmi cuchi misegcunaga mansacash cörrila aywayargan marcaman runacunata wilayänanpä. Chaycurmi wilacuyargan löcuyash runacunapita supaycunata Jesús gargushganta y cuchicuna gochaman jegar shengaypa wanuyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wilayaptinmi marcapita runacuna aywayargan Jesús caycashgan cagman ima päsaycashgantapis ricayänanpä. Chaycurmi segaypa mansacash lapanpis Jesusta niyargan saypita aywacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Saypitanami büquiman wisarcur Jesusga cutergan taycashgan marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Saychömi paralítico runata quirmawan apayargan Jesús cagman. Apagcuna payman yäracuyashganta musyarmi say gueshyagta Jesús nergan: “Ama laquicuysu, hïjo. Lapan jusayquipita perdonashganami caycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sayno niptinmi Moisés guelgashganta yachaseg runacuna yarpachacuyargan: “¡Sayno nerga Diospa contranmi parlaycan!” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sayno yarpaycäyashganta musyarmi Jesús taporgan: “¿Imanirtä gamcuna sayno lutanta yarpaycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Maygantä más aja caycan? ¿Runapa jusancunata perdonaycu? ¿O gueshyaycashganta aliyäsiycu? ");
INSERT INTO qvhNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nogami munayyog caycä runapa jusancunata perdonanäpä. Sayta musyayänayquipämi cay runata aliyäsishä.” Nircur say gueshyaycag runata nergan: “¡Sharcuy! Quirmayquita apacurcur wayiquipa aywacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sayno niptinmi say gueshyaycag runa jinan höra aliyarcur wayinpa aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sayta ricaycurmi runacuna cushicuyashpan Tayta Diosta alabayargan: “¡Manami imaypis musyashcansisu runacunata Tayta Diosninsi sayno yanapänanpä cashgantaga!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Saypita aywacur Jesús ricargan Mateo jutiyog runata impuestuta cobrar jamaraycagta. Saymi payta nergan: “Discïpulö canayquipä gatirämay.” Sayno niptinmi Jesuswan Mateo aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Saypitanami Jesusta y discïpuluncunata Mateo gayasergan wayincho micuyänanpä. Saycho micuycaptinmi impuesto cobrag runacuna y Diosta mana cäsucog runacunapis chaycur micuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sayta ricarmi fariseo runacuna jamuräyashpan Jesuspa discïpuluncunata niyargan: “¿Imanirtä impuesto cobragcunawan y Diosta mana cäsucogcunawanpis talucaycur Jesús micuycan?” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sayno nishganta wiyarmi Jesús nergan: “Gueshyagcuna jampicogta nistäyashgannölami jusasapacunapis Tayta Diosninsipa wilacuyninta pilapis tantyasinanta nistäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tayta Diosninsipa palabranchöpis caynömi nican: ‘Nogapä uywacunata altarcho rupasishgayquipitapis runa mayiquita más cuyapänayquitami munä.’ Sayno guelgaraycaptinpis gamcunaga ¿imanirtä jusasapacunata cuyapanquisu? Nogaga manami Tayta Diosninsi munashganno cawag runacunalata Diospa wilacuyninta wilapänäpäsu shamushcä, sinöga pay munashganno mana cawag runacunatapis wilapänäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juc cutichömi Juan Bautistapa discïpuluncuna Jesusta tapuyargan: “Nogacunapis y fariseo runacunapis cadalami ayunayä. Gampa discïpuluyquicunaga ¿imanirtä ayunayansu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sayno tapuyaptinmi Jesús nergan: “Casaray fiestaman gayasishgan cagcuna ¿ayunayanmansurä? Casarag magta wanuptinmi isanga ayunayangapä. Saynölami discïpulöcunapis paycunawan cashgäyäga ayunayanmansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Manami pipis macwa mödanata remendansu mushog träpuwanga. Mushog träpoga guentir masmi rachicäsenga macwa mödanata. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Saynöpis sayrä rurash aswata manami winansisu shilicaycag urpumanga. Shilicaycag urpuman winashgaga aswa pogur say urputa lacsiriycongami. Sayno captenga aswapis jichacangami y urpupis paquir ushacangami. Saymi sänu urpuman sayrä rurash aswata winansi. Saynölami nogapa yachasicuynëpis mushog car gamcunapa costumbriquicunamanga tincunsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sayno parlaycaptinmi sinagogacho mandag runa chaycushpan Jesuspa puntanman gongurpacuycushpan nergan: “Warmi surëmi päsarpush, taytay. Jucla aywayculäshun cawarisimunayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sayno ruwacuptinmi discïpuluncunawan Jesús aywayargan say runapa wayinman. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aywaycäyaptinmi chunca ishcay (12) wata yawar apaywan gueshyaycag warmi guepalanpa yaycuycur paypa mödananta yataycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sayno rurargan: “Jesuspa mödananta yataycularpis aliyäshämi” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yataycuptinmi ticraycur Jesús ricargan warmita. Saymi nergan: “Ama laquicuysu, hïja. Yäracuyniquipami aliyashcanqui.” Sayno niptinmi jinan höra say warmi aliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Saypitanami say Israel runacunapa autoridäninpa wayinman chargan. Charmi tariyargan músico tucagcuna saycho caycagta y runacunapis fiyupa wagaycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Paycunatami Jesús nergan: “Wagtapa yargucuyay. Autoridäpa surin manami wanushgasu, sinöga punuycanlami.” Sayno niptinmi wanush caycashganta musyayashpan saycho caycag runacuna Jesús nishganta criyiyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sayno captinpis Jesús nishgannölami wagtapa yargucuyargan. Yargusquiyaptinnami wanush caycag sutaraycashgan cagman Jesús yaycorgan. Maquinpita aptarcuptinmi autoridäpa surenga cawarircamur sharcarcamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sayno cawarisimushgantami say marcacho y waquin marcacunachöpis runacuna musyayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Saypita Jesús aywacuptinmi ishcay gapracuna paypa guepanpa aywayargan: “¡Rey Davidpa castan Jesús, nogacunata cuyapaycayälämay!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Posädacushgan wayiman Jesús yaycuptinpis say gapracunaga paypa guepantami yaycuyargan. Saymi Jesús paycunata taporgan: “¿Gamcuna criyiyanquicu nawiquita aliyäsinäpä cashganta?” “Au, criyiyämi aliyäsiyämänayquipä cashganta, taytay” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sayno niyaptinmi nawincunata Jesús yataycur nergan: “Yäracayämayniquipami nawiqui ricangana.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sayno niptinmi jucla nawin aliyargan. Saymi paycunata Jesús nergan: “Pitapis ama wilapäyanquisu aliyäsishgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sayno niptinpis yargurilarmi pï-maytapis wilapäyargan Jesús aliyäsishganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Say gapracuna aywacuycäyaptinnami Jesús cagman pushayargan shimin mana pashtag runata. Say runataga supaymi shiminta watpäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Say runapita supayta Jesús gargusquiptinmi shimin pashtarcorgan. Sayta ricarmi runacuna cushicuyashpan niyargan: “¡Manami imaypis ricashgansisu cayno cachacäsegtaga!” ");
INSERT INTO qvhNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo runacunami isanga: “Manami Tayta Diospa munayninwansu supaycunata runacunapita gargun, sinöga supaycunapa mandagninpa munayninwanmi” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Saypitanami lapan marcacunapa Jesús purergan Tayta Diosninsipa wilacuyninta sinagogacunacho yachasishpan. Saynöpis tucuy-nirag gueshyawan gueshyagcunatami aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Marcan marcan purir yachasiptinmi saysica runacuna shuntacäyargan payta wiyananpä. Misegniynag y ogracash uyshacunano caycagta ricarmi Jesús cuyapashpan laquicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Saymi discïpuluncunata nergan: “Cosëcha poguraycagnömi saysica runacuna caycäyan Tayta Diosninsipa wilacuyninta jucla chasquicuyänanpä. Sayno captinpis walcaglami ali wilacuyta wilacogcuna caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sayno caycaptenga Tayta Diosta manacuyay wilacogcuna más asca cayänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Saypitanami chunca ishcay (12) apostolnincunata Jesús nergan paypa jutincho runacunapita supaycunata garguyänanpä y tucuy-nirag gueshyagcunata aliyäsiyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Say apostolcuna cayargan Simón (paypa jucag jutinmi cargan Pedro), Simonpa wauguin Andrés, Zebedeupa surincuna Santiaguwan Juan, ");
INSERT INTO qvhNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo (payga Roma nacionpä impuestuta cobragmi cargan), Alfeupa surin Santiago, Tadeo paypa jucag jutin cargan Lebeo, ");
INSERT INTO qvhNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Celote” nishgan Simón y Jesusta entregag cag Judas Iscariote. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Say chunca ishcay (12) apostolnincuna wilacog aywayänanpä cacharmi Jesús nergan: “Ama aywayanquisu mana Israel runacunapa marcancunamanga, ni yaycuyanquisu Samaria provinciacho caycag marcacunamanpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Saypa trucanga aywayay Israel runacunalaman. Paycunaga ogracash uyshanömi caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Paycunata wilapäyanqui: ‘Tayta Diosninsipa maquincho ali cawanapä cag tiempo chämushganami’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gueshyagcunata aliyäsiyanqui. Wanushcunatapis cawarisiyanqui. Leprawan gueshyagcunatapis aliyäsiyanqui. Supaycunatapis runacunapita garguyanqui. Gamcunata yanapashgänöla gamcunapis waquinta yanapäyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Arupacog runa arushganpita imatapis chasquishgannömi gamcunapis wilacuyashgayquipita imatapis chasquiyanquipä. Sayno caycaptenga ama apayanquisu guellayta ni goritapis. Saynöpis ama apayanquisu guepinayquita, trucacunayquipä mödanayquita ni tucruyquitapis. Jatiräyashgayqui languilayquiwan aywayay. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“May marcaman o may jalgacunaman charpis tapucuyanqui mayganpis ali runa cashganta. Mayganpis ali runa captenga paypa wayilancho posädacuyanqui juc marcaman päsayashgayquiyag. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Say runapa wayinman char niyanqui: ‘Ali cawayänayquipä Tayta Diosninsi yanapaycuyäläshunqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ali chasquiyäshuptiquega niyashgayquinömi paypä ali caway canga. Mana chasquiyäshuptiquega juc wayimanna aywayanqui posädata ashiyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Runacuna wilacuyashgayquita mana chasquiyäshuptiquega marcapitapis aywacuyanqui languiquicho caycag polvuta tapshirishpayqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sayno mana chasquiyäshushgayquipitami Sodoma y Gomorracho tag runacuna infiernucho nacayänanpä cashganpitapis paycuna más fiyupa infiernucho nacayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Shumag tantyacuyay. Gamcunata fiyu runacuna cayashganman cachaycä uyshacunata atogman gaycognömi. Sayno caycaptenga culebranöpis alcäbula puricuyanqui. Isanga imatapis lutanta ama rurayaysu. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chiquishogniqui runacunaga autoridäcunamanpis prësu sarircur apayäshunqui juzgash canayquipä. Saynölami sinagogancunachöpis astayäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nogata chasquicayämashgayquipitami nación mandag reycunamanpis apayäshushpayqui castigayäshunquipä. Saynöpami wilacuynëta paycunata y saycho cag waquin mana Israel runacunatapis wilapäyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Autoridäcunaman entregayäshuptiquipis ama laquicuyanquisu: ‘¿Imatarä nishä?’ niyashpayqui. Autoridäcunapa naupancho manami quiquiquipa yarpaylayquipitasu parlayanquipä, sinöga Tayta Dios cachamushgan Santu Espiritumi tantyasiyäshunqui imata parlayänayquipäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nogata chasquicamashganpita chiquirmi wauguintapis autoridäcunaman entregayanga wanusish cananpä. Waquinnami surinta entregayanga wanusish cananpä y waquinnami taytantapis entreganga wanusish cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nogata chasquicayämashgayquipitami pï-maypis chiquiyäshunquipä. Sayno chiquiyäshuptiquipis wanushgayquiyag nogaman yäracayämashpayquimi Tayta Diospa naupanman chäyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcacho chiquiyäshuptiquega juc marcaman gueshpicuyanqui. Manarä lapan Israel nacioncho cag marcacunapa puriyaptiquimi noga cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maygan yachacogpis manami yachasegninpita mastaga yachansu. Saynöla ashmaypis manami patronninpita más munayyogsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nogatapis chiquiycämarga gamcunata masrämi chiquiyäshunquipä. Nogatapis: ‘Satanasmi payga’ nicäyämarga gamcunatapis Satanás cayashgayquitami runacuna niyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Cay pasacho runacuna chiquiyäshuptiquipis mana mansacuypa wilacuynëta wilacuyay. Tayta Diospa wilacognin cayashgayquita cay pasacho runacuna mana tantyayaptinpis Tayta Diospa naupanman chäyaptiquimi isanga lapanpis musyayanga wilacognin cayashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sayno caycaptenga yachasishgäta mana mayagcunata gamcunana mana mansacuypa wilapäyay. Sayno wilacuyänayquipämi gamcunata yachaycäsë. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama mansayanquisu pipis wanusishunayquipä jurapäshuptiqui. Wanusiyäshushpayquipis almayquitaga manami wanusengasu. Chiquishogniquicunata mansapäyänayquipa trucanga Tayta Diosninsita mansapacuyay. Paymi isanga munayyog caycan almantinta pitapis infiernuman gaycunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Tantyacuyay. Chanquishcunata runacuna mana cäsupaptinpis Tayta Diosninsi lapantami ricaycan. Chanquishtapis sayno ricaycarga gamcunata masrämi Tayta Diosninsi ricaycäshunqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Saynölami agsayqui ayca cashgantapis payga musyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pishgucunapitapis más väleg captiqui Tayta Dios cuidaycäshuptiquega pitapis ama mansaysu. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pipis nogata chasquicamashganta mana pengacuypa wilacuptenga nogapis Tayta Diospa naupancho paycunapa favorninmi parlashäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pipis runacunapa naupancho pengacushpan chasquicamashganta ñëgamaptenga nogapis Tayta Diospa naupancho paycunata: ‘Manami reguësu’ nishäpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gamcuna ama yarpäyaysu nogata chasquicayämashgayquipita runacuna mana chiquiyäshunayquipä cashganta. Saypa trucanga nogata chasquicamagcunata runacuna chiquiyangapämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nogata chasquicayämashganpitami surinpis taytanpa contran sharconga. Mamanpa contranmi wawanpis sharconga. Saynölami lumsuyninpis suedranpa contran sharconga. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Saymi cuyashunayquipa trucanga castayquicunapis chiquiyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nogata chasquicayämashganpita maman chiquiptinpis, taytan chiquiptinpis o surin chiquiptinpis noga munashgäno imaypis cawayäsun. Noga nishgäta cäsucuyänanpa trucanga maman, taytan o surin nishganta cäsucogcunaga manami rasunpaypasu chasquicayämash. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sayno captenga imano nacarpis noga munashgänöla imaypis cawayäsun. Wanushganyag noga munashgäno mana cawag cäga manami rasunpaypasu chasquicamash. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noga munashgäno cawananpa trucan quiquin munashganno cawagcunaga infiernuman gaycushmi cayangapä. Ima nacaycho carpis noga munashgäno cawagcunami isanga gloriaman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Gamcunata chasquicuyäshushpayquega nogatami chasquicaycäyäman. Saynöpis nogata chasquicamag cäga Taytätapis chasquicuycäyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tayta Diospa wilacogninta wayinman chasquicog cäga gloriaman char wilacogcuna premiuta chasquishgannömi paypis premiuta chasquengapä. Saynölami Tayta Dios munashganno cawag ali runata wayinman chasquicog cäga gloriaman char say ali runa premiuta chasquishganno paypis premiuta chasquengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chasquicamagcunata pipis noga-raycu juc pusillu yaculatapis macyaptenga Tayta Diosninsi paytapis premiutami gongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chunca ishcay (12) apostolnincunata yachasiyta ushasquirnami Jesusga Galilea provinciapa marcan marcan purergan Tayta Diosninsipa wilacuyninta wilacur. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Carcilcho caycarmi Juan Bautista wiyargan Jesús milagrucunata ruraycashganta y Tayta Diosninsipa wilacuyninta wilacur puriycashgantapis. Saymi discïpuluncunata Jesús cagman cachargan tapumunanpä: ");
INSERT INTO qvhNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“¿Gamcush caycanqui Tayta Dios cachamushgan Cristo, o juctaräcush shuyacuyäshä?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sayno tapuyaptinmi Jesús nergan: “Cutiyashpayqui Juanta wilayay ricayashgayquita y wiyayashgayquitapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gapracuna ricayannami. Puriyta mana puëdeg wegrucuna puriyannami. Leprawan gueshyagcuna aliyashnami caycäyan. Upacuna wiyayannami. Juc ishcay wanushcunapis cawariyämushganami. Muchogcunapis Tayta Diosninsipa wilacuyninta wiyaycäyannami. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nogaman yäracamashgannöla imaypis Juan yäracamäsun.” ");
INSERT INTO qvhNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanpa cachancuna cutisquiyaptinnami runacunata Jesús nergan: “Sunyag jircaman Juanta ricayänayquipä aywar manami jachata vientu cuyusegta ricayänayquipäsu aywayargayqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Saynöpis manami fïnu mödanan jatish runata ricayänayquipäsu aywayargayqui. Reypa wayincho tagcunalami ali mödanan jatish caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Manami saycunata ricagsu aywayargayqui, sinöga Tayta Diosninsipa profëtanta ricayänayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanpämi Tayta Diosninsipa palabrancho cayno guelgaraycan: ‘Wilacognëtami cachashä runacunata puestucasinanpä. Saynöpami puestucush cayanga shamuptë chasquicayämänanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Juanpä sayno guelgash captinmi lapan runacunapitapis payga más puntata tantyash Tayta Dios cachamushgan Cristo cashgäta. Sayno captinpis discïpulöcunaga nogawan purish carmi Juanpita masla tantyayan Dios cachamushgan Cristo cashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Moisés guelgashgancuna, Tayta Diosninsipa profëtancuna guelgayashgancuna y Juan Bautista wilacushgancunapis nicäyan noga shamunäpä cagpitami. Saymi Juan wilacuyta galaycushganpita-pasa asca runacuna Tayta Diosninsipa wilacuyninta chasquicuycäyan. Sayno caycaptinpis waquin runacunaga manami munayansu say wilacuyta wilacunanta, sinöga imanöpapis sapatami churapaycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Saynölami Tayta Diospa palabrancho guelgaraycan Elías shamur wilacunanpä cashganta. Tantyanayquipä aja captinpis Juan Bautista wilacuptinmi Elías shamur wilacunanpä guelgaraycashgan cumplergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Sayno nircur Jesús mastapis nergan: “Canan tiempo runacunaga yupay-tucog wamracunanömi caycäyan. Manami chasquicuyämansu noga yachasishgäcunata ni Juan Bautista yachasishgancunatapis. Wamracuna: ‘Puclar fiestata rurashun’ nir quënata tucaptin yanasancuna tushuyta mana munayashgannömi noga yachasishgäcunatapis chasquicuyansu. ‘Aya pampayta puclar laquicuypa cantashun’ niptinpis yanasancuna puclayta mana munayashgannömi Juan Bautista yachasishgancunatapis chasquicuyta munayansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan Bautista imaypis ayunaptin y vïnuta mana upuptin: ‘¡Payga supaypa munaynincho carmi sayno caycan!’ niyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pï-may runawanpis shuntacar noga ima micuytapis micuptë y vïnutapis upuptë ‘Micular upular puricun’ niyäman. Saynöpis: ‘Jusasapa runacunawan y Romapä impuesto cobragcunawan puricog’ niyäman. Sayno mana chasquicayämaptinpis Juantawan nogata Tayta Dios cachamashgan tantyacaycan Tayta Dios munashganno cawayaptëmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Milagrucunata Jesús rurashganta ricarpis waquin runacuna jusalicuycunata manami cachariyargansu. Saymi paycunapä Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Corazín marcacho tag runacuna! ¡Betsaida marcacho tag runacuna! ¡Juicio finalchöga fiyupami laquicuyanquipä! Gamcunacho milagrucunata rurashgäno Tiro y Sidón marcacunacho milagrucunata ruraptëga maynami jusalicuycunata cachariyanman cargan. Saynöpis jusalicuyashganpita laquicur maynami cotenciapita rurash mödanata jatish uchpaman jamaycur wagayanman cargan. Gamcunaga milagrucunata rurashgäta ricaycarpis jusalicuycunata cachariyta manami munayanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sayno cayashgayquipitami Tiro y Sidón marca runacuna infiernucho nacayashganpitapis gamcunaga infiernucho más fiyupa nacayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Capernaum marcacho tag runacuna, ¿gamcunaga Tayta Diosninsipa naupanman chäyänayquipä cashgantachi yarpaycäyanqui? Tayta Diosninsipa naupanman chäyänayquipa trucanga Hadisman gaycushmi cayanquipä. Gamcunacho rurashgä milagrucunata Sodoma marcacho ruraptëga jusancunata cachariptin cananyagmi say marca caycanman cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sodoma marca runacuna infiernucho nacayänanpä cashganpitapis gamcuna más fiyupami infiernucho nacayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saychömi fiyupa cushicushpan Tayta Diosninsita Jesús manacorgan: “Ciëlucho y cay pasachöpis gam munayyogmi caycanqui, papá. Yachag-tucogcunata manami tantyasishcanquisu nogata cachamashgayquita. Paycunata tantyasinayquipa trucanga yachacuyta munagcunalatami tantyasishcanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sayno canantami munashcanqui, papá.” ");
INSERT INTO qvhNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nircurnami discïpuluncunata nergan: “Taytämi lapantapis munaynëman churamush, surin captë. Noga imano cashgätapis Taytalämi musyan. Saynömi pay imano cashgantapis nogala musyä. Saymi tantyasishgä cagcunala musyayan Taytä imano cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tayta Diosninsi munashganno cawayta mana camäpacorga nogaman yäracayämay. Yäracayämaptiquega yanapäyäshayquimi. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noga yachasishgänöla cawayay. Saynöpis shumag tantyacuyay cuyapäcog y mana runa-tucog cashgäta. Sayno cawarga ali cawaytami tariyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noga yanapaptë Tayta Dios munashganno cawayänayquipäga manami ajasu caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Saypita sábado jamay junagchömi discïpuluncunawan Jesús päsaycäyargan trïgu poguraycag chacracuna cuchunpa. Saymi discïpuluncunaga segaypa micanäyashpan trïguta palarcur cuparishpan micuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sayno rurayashganta ricarmi fariseo runacuna Jesusta niyargan: “Discïpuluyquicuna sábado jamay junagcho trïguta palarga Moisés guelgashgan leycunata manami cäsucuycansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Saymi Jesús nergan: “Sábado jamay junagcho trïguta palarpis paycunaga manami jusalicuycansu. Asca cutimi gamcuna liyiyashcanqui David yanapagnincunawan micanar imata rurayashgantapis. Asca cuti liyiycarpis ¿manacu tantyayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Paymi Tayta Diosta manacuna wayi rurinman yaycur Tayta Diosninsipä churaraycag tantata paywan aywag runacunawan micuyargan. Say tanta cüracunala micuyänanpä caycaptinpis sayta micur Davidga manami jusalicushgasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Saynöpis Moisés guelgashgan leycunata asca cuti liyirpis ¿manacu tantyayanqui sábado jamay junag templucho cüracuna rurayashgancuna jusa mana cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Saynölami discïpulöcunapis jusayogsu caycäyan, sábado jamay junagcho mana jamarpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gamcunaga manami tantyacuyanquisu Tayta Diospa palabrancho cayno nishganta: ‘Nogapä uywacunata altarcho rupasiyashgayquipitapis runa mayiquita más cuyapäyänayquitami munä.’ Say guelgaraycashganta tantyacorga manami discïpulöcunata jamuraycäyanquimansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nogami munayyog caycä sábado jamay junagcho runa rurananpä mana rurananpä cagtapis ninäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Saypita aywar Jesús yaycorgan say marcacho sinagogaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Saycho shuntacash caycag runacunawanmi wanush maquiyog runapis caycargan. Saymi fariseo runacuna Jesusta tapuyargan: “Sábado jamay junag caycaptin wanush maquiyog runata ¿aliyäsinquimancu o manacu?” nir. Sayno tapuyargan aliyäsiptin say achäquila Jesuspa contran sharcuyänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Saymi Jesús nergan: “Maygayquipapis uyshayqui pözuman jegaptin ¿manacu jinan höra jorgog aywayanqui, sábado jamay junag caycaptinpis? ");
INSERT INTO qvhNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Uyshapitapis más cuyaymi runacunaga caycäyan. Sayno caycaptenga sábado jamay junagchöpis gueshyagcunata aliyäsishämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nircur say gueshyaycag runata Jesús nergan: “¡Maquiquita jogariy!” Jogarcuptinmi maquin sänuna ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sábado jamay junagcho sayno aliyäsiptinmi fariseo runacuna say sinagogapita yarguriyashpan wilanacuyargan Jesusta wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sauraga Jesús sayno wilanacuyashganta musyaycur aywacorgan say marcapita. Aywacuptinmi asca runacuna guepanpa aywayargan. Guepanpa aywag runacuna mayganpis gueshyaptin Jesús aliyäserganmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aliyarcasirmi Jesús nergan: “Pitapis ama wilapäyanquisu noga aliyäsishgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesús sayno cuyapäcog cananpä cashganpitami profëta Isaías Tayta Diosninsi nishgancunata cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Juc sirvimagnë runami shamonga. Acrashgä captinmi paypita fiyupa cushicö. Paytami Santu Espíritu shumag yanapanga. Sayno yanapaptinmi ali cawayta cay pasaman apamonga may-say nacionchöpis runacuna noga munashgäno cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Runacuna gayapaptinpis manami imatapis nengasu. Saynöpis manami purengasu: ‘Nogaga más yachagmi cä’ nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Fiyupa laquicogcunata manami manacagman churangasu, sinöga cuyapangami. Jusalicur cawag runacunata manami juclasu castiganga, sinöga munashgäno cawananpämi tantyasenga. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Saynöpami may-say nación runacunapis payman yäracur salvacuyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Saypita supay gaprayäsishgan y shiminta watpäsishgan runata Jesús cagman pushayargan cachacäsinanpä. Say runapita supayta Jesús gargusquiptinmi parlarganna y ricarganna. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sayno aliyäsegta ricarmi runacuna cushicuyashpan niyargan: “¿Salvamänansipä Tayta Dios cachamushgan rey Davidpa castansurä payga caycan?” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sayno niyashganta wiyar fariseo runacuna niyargan: “Tagay runaga manami Tayta Diospa munayninwansu supaycunata runacunapita gargun, sinöga supaycunapa mandagnin Beelzebupa munayninwanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sayno parlaycäyashganta wiyarmi Jesús nergan: “Juc nacioncho runacuna quiquinpura chiquinacorga ¿manasurä wanusinacur ushacäyanman? Saynöpis juc marcacho o juc wayicho tagcuna quiquinpura chiquinacorga ¿manasurä wacpa caypa aywacur ushacäyanman? ");
INSERT INTO qvhNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sayno captenga ¿imanirtä yarpaycäyanqui Satanaspa munayninwan supaycunata gargushgäta? Quiquinpura gargunacorga Satanás ushacanmanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Waquin runacuna supaycunata garguyaptin gamcunaga yarpaycanqui Tayta Diosninsipa munayninwan garguyashgantami. Noga garguptëga ¿imanirtä yarpaycäyanqui Satanaspa munayninwan supaycunata gargushgäta? Sayno yarparga lutantami yarpaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tayta Dios cachamushgan Santu Espíritu yanapämaptinmi supaycunata gargö. Gargushgäta ricarmi musyayanqui Tayta Diospa munayninwan Satanasta vincishgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Satanaspita más munayyog cashganta tantyasirmi Jesús yachasergan: “Calpayog runa wayinta täpaycaptenga manami pipis suwapanmansu. Sayno täpaycaptinpis paypita más calpayog runa shamurmi isanga pancaycur imancunatapis apacurcur aywaconga. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mayganpis mana chasquicamag cäga conträmi caycan. Nogata mana cäsumag cäga Satanás munashgantami ruraycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Runacuna jusalicuyashganta y lutancunata parlayashgantapis perdonta manacuyaptenga Tayta Dios perdonangapämi. Saynölami Tayta Diospita shamushgäta mana tantyar conträ parlayaptinpis Tayta Dios perdonanga. Tayta Dios cachamushgan Cristo cashgäta Santu Espíritu tantyaycäsiptin conträ parlagcunatami isanga Tayta Diosninsi imaypis perdonangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sayno nircur Jesús mastapis nergan: “Wayuyninpa jachata reguishgansinömi parlacuyninpa musyansi pipis ali runa cashganta o mana ali runa cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Fiyu runacuna! Gamcuna ¿imanöpashi alita parlaycuyanquiman? Alita parlayänayquipa trucanga shonguyqui lutancunata yarpashgalantami imaypis parlayanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Pipis shonguncho alita yarparga alitami parlan. Shonguncho mana alita yarparmi isanga mana alicunata parlan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Saymi juicio finalchöchöga manacagcunata parlayashgayquipita Tayta Diosninsi juzgayäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Alita parlayaptiquega jusaynag cayashgayquitami Tayta Diosninsi niyäshunquipä. Mana alita parlayaptiquimi isanga jusayog cayashgayquita niyäshunquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Saypitanami waquin fariseo runacuna y Moisés guelgashgan leycunata yachaseg runacuna Jesusta niyargan: “Tayta Diosninsi rasunpaypa cachamushushgayquita musyayänäpä ima milagrutapis rurayculay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Saymi Jesús nergan: “Gamcunaga manami rasunpaypasu Tayta Diosman yäracuyanqui. Saymi pay cachamashganta criyinayquipä milagruta ruranätarä munaycäyanqui. Munayashgayquinöga manami milagruta rurashäsu. Saypa trucanga Tayta Dios juc milagrutarämi ruranga profëta Jonasta pescädupa pachancho caycashganpita yargasimur milagruta rurashganno. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Quimsa junag quimsa pagas jatuncaray pescädupa pachancho caycashganpita Tayta Diosninsi Jonasta yargasimushgannömi nogatapis quimsa junag quimsa pagas pamparashgäpita cawarisimangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Jonás wilacushganta wiyarmi Nínivicho tag runacuna jusalicuyashganta cachariyargan. Jonaspita más munayyog noga caycaptëpis wilacushgäta canan wisan runacuna manami chasquicuyansu. Saymi juicio finalcho Nínivicho tag runacuna sharcayämongapä canan wisan runacunata: ‘Nogacuna Jonás wilacushganta chasquicuycäyaptëga ¿imanirtä gamcuna Tayta Diospa surin wilacushganta chasquicuyargayquisu?’ niyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Musyashgayquinöpis Salomonpa yachasicuyninta wiyananpämi Sabá nacionpita-pasa mandag warmi shamorgan Jerusalenman. Paymi juicio finalcho sharcamongapä canan wisan runacunata: ‘Salomón yachasishganta noga chasquicuycaptëga ¿imanirtä gamcuna Tayta Diospa surin yachasishganta chasquicuyargayquisu?’ ninanpä. Salomonpita noga más yachag captëpis canan wisan runacunaga manami wiyacuyansu noga wilacushgäcunata. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Runapita supay yargurna sunyagcunapa purin maychöpis tänanpä ashir. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mana tariycorga yarpan yargushgan runaman yapay cutiyta. Cutiycushpanmi tarin pisapacush y churapacush jäcuycag wayitano. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sayno jäcuycagta tariycurmi paypita más fiyu ganchis supaycunata pushacurcur say runaman cutin paycho tänanpä. Saymi naupata cashganpitaga say runa más fiyuna ricacun. Saynömi päsanga canan wisan fiyu runacunatapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús sayno yachaycäsiptinmi mamanwan wauguincuna sayman chäyargan. Chaycurmi punculacho shuyaraycäyargan Jesuswan parlayta munayashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Paycunata ricarmi juc runa Jesusta wilargan: “Mamayquiwan wauguiquicunami puncucho shuyaraycäyäshunqui” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Sayno wilaptinmi discïpuluncunata ricärir Jesús nergan: “Paycunami mamäno y wauguëcunanöpis caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pipis mamäno, wauguëcunano y panëcunano caycäyan Tayta Dios munashganno cawag cagmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Say junaglami wayipita yargurir Jesús aywargan Galilea gocha cuchunman. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Saymanmi asca runacuna shuntacäyargan Jesús yachasishganta wiyayta munar. Aläpa quichquipäyaptinmi gocha cuchuncho caycag büquiman Jesús wisargan saypitana yachasimunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nircurnami imamanpis tincusiypa asca yachasicuyta yachasimorgan: “Juc runashi aywargan trïgu murog. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sayshi muruta shicaptin waquin chäyargan näniman. Saycho mashiraycagtami pishgucuna shamur upshacurcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","“Waquin cag murunashi chäyargan shalaman. Saycho winamurpis alpa aläpa mana captinshi shanaywan saquicäcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin cag murunashi chäyargan cashacuna cashganman. Cashacuna rurincho garwashtaycälar winamurshi wayuyninpis cargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Waquin cag murunashi ali alpaman chäyargan. Saycunaga ali winamurshi ali espïgayog cayargan. Waquin espïgashi wayorgan pachac (100) trïgucunata, waquin espïgacunashi wayorgan sogta chunca (60) trïgucunata y waquinnashi wayorgan quimsa chunca (30) trïgucunata.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sayno yacharcasir Jesús nergan: “Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sayno yachasiptinmi discïpuluncuna Jesusta niyargan: “Imamanpis tincusiypa yachasiyämaptiqui manami shumag tantyayäsu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Saymi Jesús nergan: “Gamcunataga tincusiypa yachasishgäcunata shumagmi tantyasiyäshayqui. Mana cäsucamagcunatami isanga mana tantyasiylapa yachasishä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sayno captenga mayganpis yachacuyta munagcunaga yachasishgäcunata tantyangapämi. Mana yachacuyta munagcunami isanga wiyarpis tantyangapäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Saymi noga yachasë imamanpis tincusiypa. Saynöpami yachacuyta mana munagcunaga ricaycarpis tantyayansu y wiyaycarpis chasquicuyansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sayno cananpä cashganpitami Tayta Dios nishganta profëta Isaías cayno guelgargan: ‘Gamcuna wiyaycarpis manami tantyayanquisu. Ricaycarpis manami chasquicuyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cay runacunapa shonguncuna chucruyashmi caycäyan. Saymi rinrincunapis sapacashno caycäyan. Nawincunapis mana ricagno caycäyan. Sayno carmi paycunaga imata yachasishgätapis tantyacuyansu. Saymi chasquicayämansu jusalicuyashganpita perdonash cayänanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gamcunami isanga ricayashpayqui y wiyayashpayqui imata yachasishgätapis tantyacuycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Unay profëtacuna y Tayta Dios munashganno cawag runacunapis reguimaytami munayargan. Reguimayta munarpis cay pasaman manarä shamush captë manami reguiyämashgasu. Saynöpis noga wilacushgäcunata wiyayta munarpis manami wiyayämashgasu. Gamcunami isanga ricaycäyämanqui y wiyaycäyämanquipis. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Canan tantyasiyäshayqui murupacog runaman tincusiypa yachasishgäta. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Trïgu muroga Tayta Diosninsipa wilacuyninmi caycan. Chucru näninömi waquin runacunapa shongun chucru caycan. Sayno chucru shongu carmi Tayta Diosninsipa wilacuyninta wiyarpis chasquicuyansu. Saymi wiyashgalantapis Satanás gongaycasin. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Waquin runacunapa shongonga shalanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta wiyar cushishmi chasquicuyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Cushish chasquicurpis shalacho alpa aläpa mana captin trïgu jegarcamur saquicäcushgannömi paycunapis caycäyan. Saymi runacuna chiquiyaptinpis o ima nacaycho carpis cuticuyan naupata cawayashganmanno. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Waquin runacunapa shongonga casha rurincho cag alpanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta wiyarpis más yarpachacuyan rïcu cayänalanpä y quiquin munashganno cawayänalanpämi. Saycunalapä yarpachacurmi Tayta Diosninsi munashganno cawayansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Waquin runacunapa shongonga ali alpanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta cushish chasquicur Tayta Diosninsi munashgannömi cawayan. Saymi ali alpacho juc murulapita pachac (100) trïgu o sogta chunca (60) trïgu o quimsa chunca (30) trïgu wayushganno say runa Tayta Diosninsi munashganno cawanga.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Juicio finalchöchörä runacuna juzgash cayänanpä cashganpita yachasir Jesús nergan: “Juc runashi chacraman aywargan trïguta murunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mururcuptinnashi chiquegnin runa sacaypa aywarcur trïgu murushgan jananman cebadilluta shicargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trïgu winamuptinshi cebadillupis winamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sayno winamuptinshi trïgu tirapagcuna trïgupa duëñunta niyargan: ‘Acraylata muruycaptiquega ¿maypitatä cebadillu winamush, taytay?’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sayno wilayaptinshi trïgupa duëñun nergan: ‘Mayganpis chiquipämagnëmi saytaga shicaycush.’ Sayno niptinshi arogcuna tapuyargan: ‘¿Munanquicu say cebadilluta tirapäyänäta?’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Sayno niyaptin nergan: ‘Ama saytaga tirapäyaysu. Cebadilluta tiraparga trïgutapis luquiyanquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jina winacusun trïguwan cebadillu cosëchayag. Cosecharnami achogcuna acrapaylapa achuyangapä. Say acrashgan cag cebadillutanami achurcur ninaman gaycuyangapä. Trïgutami isanga shuntarcur pirwayangapä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mastapis Jesús tincusiypa yachasir nergan: “Tayta Diospa ali wilacuynenga ñäbus murunömi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ñäbuspa muronga pasaypa tacshala caycarpis muruptin winamur waquin guewacunapitapis más jatunmi ricacun. Saymi pishgucunapis gueshuncunata rämancunacho rurayan. Say tacshala murulapita ñäbus winarcamur räman mashtacashgannömi Tayta Diospa ali wilacuynenga may-saymanpis chaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Masta yachasir Jesús nergan: “Tayta Diospa ali wilacuynenga levadüranömi caycan. Tantata rurananpä warmi quimsa arröba jarinaman levadürata winaptenga mäsa shumagmi jacan. Ichicla levadüra mäsata jacasishgannömi Tayta Diosninsipa wilacuyninpis may-sayman changapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Runacunata Jesús yachasiyashpanmi imamanpis tincusiypa imaypis yachasergan. Imamanpis mana tincusiypaga manami imaypis yachasergansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sayno yachasergan Tayta Diosninsipa profëtan guelgashgan cumplinanpämi. Say guelgashganga caynömi nican: “Imamanpis tincusiypami runacunata yachasishä. Pasata camashganpita-pasa pipis mana tantyashgancunatami yachasishä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Saypitanami runacunata despacharcur discïpuluncunawan Jesús yaycorgan juc wayiman. Saychömi discïpuluncuna ruwacuyargan say cebadillupita yachasishganta tantyasinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Saymi Jesús nergan: “Trïguta murog cäga nogami caycä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Say chacraga caycan intëru cay pasami. Say trïgu muroga caycan Tayta Diosninsipa wilacuyninta chasquicog runacunami. Say cebadilloga caycan Satanás munashganno cawag runacunami. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Say cebadilluta murog cäga Satanasmi caycan. Cosëchaga caycan juicio finalmi. Cosëchata shuntagcunaga caycan angilcunami. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Cebadilluta shuntarcur ninaman gaycushgannömi juicio finalchöchöpis Satanás munashganno cawag runacunata infiernuman gaycongapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nogami angilnëcunata cachamushä jusalicasegcunata y jusalicogcunatapis shuntarcur infiernuman gaycuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Saychömi fiyupa wagar quiruntapis uchuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tayta Diosninsi munashganno cawagcunami isanga paypa naupancho car cushish cawayangapä. Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mastapis Jesús yachasergan: “Tayta Diospa naupanman chänansipä cashganga caynömi caycan. Juc runashi chacrapa purir tarergan saysica guellay pamparaycagta. Say guellayta tariycurshi cushicushpan yarpachacorgan: ‘¿Imatatä ruräman cay guellay nogapa cananpä?’ nir. Sayshi say guellayta cashgalanman pampaycur cushish aywar ranticorgan lapan imaycancunatapis. Say guellaywannashi rantergan guellay pamparaycashgan cag chacrata. Saynöpashi pamparaycag guellayta jorgur rïcu ricacorgan. Saynölami Tayta Diospa naupanman chayga cay pasacho imaycayog cashgansipitapis más cushicuypä caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Saynöpis Jesús nergan: “Tayta Diosninsipa wilacuyninta chasquicog runaga gori ranteg negocianti runanömi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Say runaga más alinnin cag gorita tariycorga wayintapis chacrantapis ranticun say gorita rantinan cash. Saynölami Tayta Diospa naupanman chayga más ali caycan cay pasacho imaycapitapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Saynömi Jesús yapay cayno yachasergan: “Musyayashgayquinöpis lamarman redta jitarcur lapan casta pescädutami sariyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nircurmi lamar cuchunman jorguyan saycho acrayänanpä. Saychömi micuna cagta canastaman winayan y mana micuna cagtanami jitariyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pescäduta acrashgannölami juicio finalcho lapan runacunata acrananpä Tayta Diosninsi angilnincunata cachamonga. Saynömi ali runacunata raquenga jusalicur cawag runacunapita. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jusalicur cawag runacunatami infiernuman gaycongapä. Saychömi fiyupa wagar quiruntapis uchuyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sayno yacharcasirmi Jesús taporgan discïpuluncunata: “¿Cay yachasishgäcunata gamcuna tantyayanquicu?” nir. Sayno tapuptinmi: “Au, tantyämi, taytay” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Saymi Jesús nergan: “Tayta Dios munashganno runacuna cawayänanpä yachasishgäcunata tantyarga waquin runacunata gamcunapis yachasiyanqui. Sayno yachaserga pirwapita maran cagcunata y sayrä churashgan cagcunata jorgarcamur garacognömi gamcunapis naupa cag yachasicuycunata y mushog yachasicuycunatapis yachaycäsiyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sayno yacharcasirmi Jesús saypita aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Marcanman charnami Tayta Diosninsipa wilacuyninta yachasergan sinagogacho. Saycho yachasiptinmi cushicuyashpan niyargan: “Sayno yachasinanpäga ¿maychötä payga yachacush? Saynöpis ¿imanöpatä payga milagrucunata ruran? ");
INSERT INTO qvhNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manacu payga carpintëro Josëpa surin caycan? Saynöpis paypa maman ¿manacu María? ¿Manacu paypa wauguincuna caycäyan Santiago, José, Simón y Judaspis? ");
INSERT INTO qvhNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Saynölami panincunatapis reguinsi. Sayno caycaptenga ¿maychötä yachacamush sayjinanpa yachaycunanpäga?” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sayno nirmi Jesús yachasishgancunata chasquicuyargansu. Saymi Jesús nergan: “Waquin marcacunacho Diospa profëtanta chasquicuyaptinpis castancunawan marca mayincunaga manami chasquicuyansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sayno mana chasquicuyaptinmi juc ishcay milagrucunalata saycho rurargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Say wisanmi Galilea provinciapa mandagnin Herodista runacuna wilayargan Diospa wilacuyninta wilacur y milagruta rurar Jesús puriycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Saymi ashmaynincunata Herodes nergan: “Say runaga Juan Bautistami cawarimush canga. Cawarimush carmi munayyog caycan milagrucunata sayno rurananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Juan Bautista manarä wanuptinmi Herodisga wauguin Felipipa warmin Herodiasta suwargan warmin cananpä. Sayno suwash captinmi Juan Bautista nergan: “Wauguiquipa warminta suwamushpayqui jusalicushcanquimi.” Sayno nishganpitami Juan Bautistata Herodes carcilman wichgasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tayta Diosninsipa profëtan Juan cashganta lapan runacuna niyaptinmi Herodisga wanusiyta munarpis mansarergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Saypita Herodispa diancho fiesta captinmi Herodiaspa jipash wawan tushorgan lapan gayasishgancunapa naupancho. Shumag tushushganta ricarmi Herodes selläma cushicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Saymi say jipashta nergan: “Imatapis manacamashgayquitami puestupäshayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sayno niptinmi say jipashga maman yachasishgannöla Herodista nergan: “Plätuwan Juan Bautistapa umanta goycamay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sayta manacuptinmi rey Herodes fiyupa laquicorgan. Juanta wanusiyta mana munarpis gayasishgancunapa naupancho say jipashta promitish carmi wardiata cachargan Juanpa umanta rogurir say jipashta goycunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Saymi carcilman wardia aywaycur Juanta wanusergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nircurna umanta roguriycur plätuwan apaycur jipashta entregargan. Chasquircurnami jipashga mamanta entregaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sayno rurashganta wiyaycurmi Juanpa discïpuluncuna aywar ayanta shuntacuyargan pampayänanpä. Saypitanami Jesusta wilayargan Juanta wanusiyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Saypitanami Herodes musyargan milagrucunata rurar Jesús puriycashganta. Herodes musyashganta wiyaycurmi büquiman wisarcushpan Jesús sunyagninman aywacorgan. Japalan aywacuptinpis runacuna musyayargan mayman aywaycashgantapis. Saymi chaquilapa aywayargan Jesusta tariyashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Büquipita urarcurnami Jesús tarergan asca runacuna saycho shuyacuycagta. Paycunata ricaycurmi Jesús cuyapashpan sayman apayashgan gueshyagcunata aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pasa tardiyaptinnami Jesusta discïpuluncuna niyargan: “Caychöga manami imapis cansu runacunata garanansipä. Tardina caycaptenga lapan runacuna aywacuyäsun cercacho cag marcacunapa micuyta rantiyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sayno niptin Jesús nergan: “Manami paycunaga micuy asheg aywayanmansu. Paycunataga gamcuna garayay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sayno niptinmi discïpuluncuna niyargan: “Pisga tantawan ishcay pescädulami mircapäcuna caycan, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Saymi Jesús nergan: “Say mircapayquita apayämuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nircur discïpuluncunata Jesús nergan runacunata pashpaman jamasiyänanpä. Saypitanami pisga tantatawan ishcay pescäduta aptarcur Jesús ciëlupa ricärishpan Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paquircur discïpuluncunata macyargan lapan runacunata aypuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Saymi lapan micuyargan pacha junta. Nircurna pusupacuyashgancunata discïpulucuna shuntayargan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Saycho micogcunaga cayargan pisga warangano (5,000) runacuna, warmicunata y wamracunata mana yupaylapa. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Saypitana discïpuluncunata Jesús nergan büquiman wisarcur wac simpaman naupayänanpä. Discïpuluncuna aywacuyaptinmi saycho cag runacunata despachacur Jesús quëdacorganrä. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nircurnami jircaman wisargan Tayta Diosta manacunanpä. Saycho manacuycaptinmi pasa sacaycarganna. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sayyäga büquiwan naupagcuna carutanami aywaycäyargan. Sayta aywaycäyaptinna yacuta vientu fiyupa sharcasimorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Saypita walpa wagay hörano caycaptinna yacu jananpa Jesús aywargan discïpuluncuna cagman. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yacu jananpa aywaycagta ricaycurmi discïpuluncuna fiyupa mansacar gaparäyargan: “¡Achachalay! ¡Almachä yacu jananpa shamuycan!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sayno mansacäyaptinmi Jesús nergan: “¡Ama mansayämaysu! Nogami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Saymi Pedro nergan: “Rasunpaypa gam carga nogapis yacu jananpa gam cagman shamunäpä niycalämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sayno niptin Jesusga nergan: “Shamuy, ari.” Sauraga büquipita yargurir yacu jananpa Jesús cagman Pedro aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aywaycashganchömi fiyupa vientu yacuta jananman pulchagyäsiptin segaypa mansacargan. Talpucarnami gaparargan: “¡Salvaycalämay, taytay!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sayno niptinmi Jesús jucla maquinpita sutarcur nergan: “¡Yäracuyniynag runa! ¿Imanirtä yäracamanquisu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Saypita büquiman wisarcuyaptin vientupis chawarganna. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sayta ricaycurmi büquicho caycagcuna Jesuspa puntanman gongurpacuycur niyargan: “¡Rasunpaypami Tayta Diospa surin gam caycanqui, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Galilea gochata simparcurnami chäyargan Genesaret pampaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sayman Jesús chashganta musyaycurmi gueshyagcunata runacuna may-say marcacunapitapis apayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Say apayashgan gueshyagcunami Jesusta ruwacuyargan mödananpa cuchulantapis yataycunanpä. Sayno ruwacur yataycogcuna aliyäyarganmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Saypitanami fariseucuna y Moisés guelgashgan leycunata yachasegcuna Jerusalenpita shayämorgan Jesusta tapuyänanpä. Chaycurnami Jesusta tapuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imanirtä discïpuluyquicuna unay runacunapa costumbrincunata mana cäsur micuyänanpä maquincunata maylacuyansu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sayno niyaptin paycunatapis Jesús nergan: “Gamcunapis ¿imanirtä Tayta Diosninsipa palabranta cumpliyänayquipa trucanga say costumbrilayquicunata más cumpliyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tayta Diosninsipa palabranchöga caynömi nican: ‘Mamayquitawan taytayquita ali ricanqui. Pipis mamanta o taytanta maldicionag cäga wanusish casun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mamayquitawan taytayquita ali ricayänayquipä niptinpis gamcunaga manami yanapaycäyanquisu. Saymi runacunata yachaycäsiyanqui: ‘Tayta Dioslapämi imaycäpis caycan’ nerga mamantawan taytanta manana yanapänanpä. Sayno yachasirmi gamcunaga Tayta Diosninsipa palabranta manacagman churaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ishcay cära runacuna! Gamcuna sayno cayänayquipä cashganta musyarmi Santu Espíritu profëta Isaiasta tantyasergan. Saymi pay cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay runacunaga janan shongulami: “Tayta Dios, Tayta Dios” nicäyäman. Saynöpis manami lapan shongunwansu nogata chasquicayäman. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Paycunaga wilacuynëta yachasiyänanpa trucanga runacunapa costumbrilantami yachaycäsiyan. Sayno captinmi adorayämaptinpis paycunata cäsupäshäsu.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nircurnami runacunata gayaycur Jesús nergan: “Cay nishgäcunata lapayqui shumag tantyacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Manami imatapis micushganpitasu pipis jusayog ricacun, sinöga lutancunata parlashganpitami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Saymi discïpuluncuna Jesusta niyargan: “Sayno niptiqui fariseo runacuna fiyupami rabiacuyash.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sayno wilayaptinmi Jesús nergan: “Paycuna ima nishgantapis ama chasquipäyaysu. Chacrapita mana ali jachacunata luquir jitarishgannömi paycunatapis Tayta Diosninsi juzgar naupanpita gargongapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paycunaga yachag-tucurpis gapranömi caycäyan. Gapra mayinta gapra pushar ishcan pözuman jegayashgannömi paycunapis y yachasishgancunata chasquipagcunapis infiernuman gaycush cayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sayno niptinmi Pedro nergan: “Ima micuyta micurpis jusaynag cashganta y lutancunata rimar jusayog cashganta tantyaycasilämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Saymi Jesús nergan: “¿Gamcunapis manacu tantyayanquirä? ");
INSERT INTO qvhNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Imata micushgansipis manami jusayogyäsimansisu, sinöga micurcushga päsacunlami. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Shonguncho lutancunata yarpachacurmi isanga pipis jusayog ricacun. Sayno carmi runa lutanta riman y lutanta ruranpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runacunaga shonguncho lutancunata yarpachacurmi runa mayinta wanusiyan, suwacuyan, lulacuyan y runa mayintapis ashliyan. Saynöpis adulteriucho cayan, runacuna chinëru cayan y warmicunapis waynäcuyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Saycunata rurarmi runacuna jusayog ricacuyan. Sayno captenga manami micuycunata micursu o maquinsita mana awicuylapa micursu jusayog ricacunsi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Saypitanami Jesús aywargan Tiro y Sidón provinciacunaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Say marcacunachömi Cananea runacuna täyargan. Saymi juc Cananea warmi Jesús cagman aywaycur ruwacorgan: “¡Rey Davidpa castan Jesús, cuyapaycalämay! ¡Warmi wawätami supay löcayäsish!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sayno niptin Jesús manami imatapis parlacorgansu. Saymi discïpuluncuna Jesusta niyargan: “Segaypa gaparashpan tagay warmega umansitapis nanäsinnachä. Jucla aywacunanpä niyculay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sayno niyaptinmi say warmita Jesús nergan: “Tayta Diosninsi cachamash Israel runacunalata yanapänäpämi. Paycunaga ogracash uyshanömi caycäyan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sayno niptinmi say warmi Jesuspa puntanman gongurpacuycur nergan: “¡Ama fiyu caysu! ¡Yanapaycalämay ari, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sayno ruwacuptinmi Jesús nergan: “Israel mayëcunatarämi yanapäshä. Gamcunata yanapaptëga canman wamracunapa tantanta guechurir algucunata jitapaycognömi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sayno niptin warmi nergan: “Au, taytay. Sayno captinpis ämun pusupacushgantami alguncunapis micuyan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Saymi Jesús nergan say warmita: “¡Lapan shonguyquiwan sayno yäracamashgayqui alimi caycan! Sayno yäracamashgayquipitami wawayqui cachacashgana caycan.” Say hörami say warmipa wawan cachacargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Saypita aywacurnami Jesús chargan Galilea gocha cuchunman. Nircurnami juc jircanninman wisarcur saycho jamacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Saymi Jesús cagman asca runacuna shuntacäyargan. Sayno shuntacarmi apayargan puriyta mana puëdeg wegrucunata, gapracunata, macllucunata, parlayta mana puëdegcunata y waquin gueshyawan gueshyagcunatapis. Paycunatami Jesús lapanta aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sayno aliyäsishganta ricaycurmi runacuna fiyupa cushicuyashpan niyargan: “Cananga upacuna parlayannami, macllucunapis aliyaycäyannami, puriyta mana puëdeg wegrucunapis puriyannami y gapracunapis ricayannami.” Sayno nirmi Israel runacuna adorayashgan Tayta Diosta paycunapis alabayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Saypitanami discïpuluncunata gayaycur Jesús nergan: “Cuyapämi caycho nogansiwan caycag runacunata. Paycuna quimsa junagnami nogansiwan caycho caycäyan micuyta mana yawaylapa. Micönila wayincunapa cuticuyänanpä niptëga aywaycäyaptilannami vëtapis sarenga imanga.” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sayno niptinmi discïpuluncuna niyargan: “¿Sunyag jircacho caycarga maychörä tariycushwan micuyta caysica runacuna micuyänanpäga, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sayno niyaptinmi paycunata Jesús taporgan: “¿Aycalatä tantayqui caycan?” “Ganchis tantawan juc ishcay pescädulami caycan, taytay” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sayno niyaptinmi lapan runacunata nergan jamacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jamaycuyaptinnami pescädutawan ganchis tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata macyargan paycuna aypucuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Saymi lapan micuyargan pacha junta. Pusushgancunatanami shuntayargan ganchis canasta juntata. ");
INSERT INTO qvhNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Saycho micogcunaga cayargan warmicunata wamracunatapis mana yupaylapa chuscu waranganömi (4,000). ");
INSERT INTO qvhNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Saypitanami büquiman wisarcur discïpuluncunawan Jesús aywacuyargan Magdala partiman. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Magdala partiman chaycuyaptinmi fariseo y saduceo runacuna aywaycur Jesusta niyargan: “Tayta Diosninsi rasunpaypa cachamushushgayquita musyayänäpä mä ima milagrutapis ruray.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Saymi Jesús nergan: “Inti jegashgan höra pucutay garwashtaptin gamcuna niyanqui: ‘Warayga usyangami.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Saynöpis segaypa pucutaraycar pasa waraptin gamcuna niyanqui: ‘Canan junäga tamyangami.’ Saycunata tantyaycarga ¿imanirtä tantyayanquisu Tayta Diosninsi cachamashganta? ");
INSERT INTO qvhNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gamcunaga manami rasunpaypasu Tayta Diosman yäracuyanqui. Saymi pay cachamashganta criyinayquipä milagruta ruranätarä munaycäyanqui. Munayashgayquinöga manami milagruta rurashäsu. Saypa trucanga Tayta Dios juc milagrutarämi ruranga profëta Jonasta pescädupa pachancho caycashganpita yargasimur milagruta rurashganno.” Sayno nisquirmi saypita Jesús aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Galilea gochata simpaycäyashganchömi Jesuspa discïpuluncuna yarparcuyargan mircapanpä tantata mana apayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Saymi Jesús nergan: “Fariseo y saduceo runacunapa levadüranta cuidä chasquicuyanquiman.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sayno niptin discïpuluncuna quiquinpura niyargan: “Tantata mana mircapacamushgansipitami sayno nicämansi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sayno parlaycäyashganta tantyarmi Jesús nergan: “¡Yäracuyniynag runacuna! ¿Imanirtä parlaycäyanqui tantata mana apayämushgayquipita? Manami tantapitasu parlaycä. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manacu yarpäyanqui pisga tantalapita pisga waranga (5,000) runacuna micuyänanpä milagruta rurashgäta? ¿Manacu yarpäyanqui pusog tantata say junag ayca canastata shuntayashgayquitapis? ");
INSERT INTO qvhNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Saynöpis ¿manacu yarpäyanqui ganchis tantalapita chuscu waranga (4,000) runacuna micuyänanpä milagruta rurashgäta? ¿Manacu yarpäyanqui pusog tantata say junag ayca canastata shuntayashgayquitapis? ");
INSERT INTO qvhNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sayno caycaptenga manami tantapitasu parlaycä. Nogaga parlaycä fariseo y saduceo runacunapa levadüranpita cuidacuyänayquipämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Levadüraman ituycasilar sayno niptinmi discïpuluncuna tantyayargan fariseucunapa y saduceucunapa yachasicuyninta mana chasquipäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea de Filipos distrïtupa caseriuncunaman chaycurmi discïpuluncunata Jesús taporgan: “¿Pï cashgätatä nogapä runacuna yarpäyan?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sayno tapuptin discïpuluncuna niyargan: “Waquin runacunaga niyan Juan Bautista cashgayquitami. Waquinnami niyan profëta Elías cashgayquita. Waquinnami niyan profëta Jeremías cashgayquita. Y waquinnami niyan maygan profëtapis cawarimush cashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sayno niyaptin paycunata Jesús taporgan: “Gamcunaga ¿pï cashgätatä yarpäyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saymi Simón Pedro nergan: “Gamga Tayta Dios cachamushgan Cristumi canqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Saymi Jesús nergan: “Alitami nishcanqui, Jonaspa surin Simón. Sayno ninayquipäga manami runasu tantyasishushcanqui, sinöga ciëlucho caycag Taytämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gamta në Pedro cashgayquita. Cay rumi jananchömi iglesiäta sharcasishä. Say iglesiataga Satanaspis ni supaycunapis manami vinciyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gamta goycushayqui gloria puncupa llävinpa wawancunata. Saymi cay pasacho lläviptiqui gloriachöpis llävish canga. Cay pasacho quichaptiquega gloriachöpis quichashmi canga.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sayno nircurmi discïpuluncunata Jesús nergan: “Gamcuna pitapis ama wilapäyaysu Tayta Diosninsi cachamushgan Cristo cashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Saypitanami discïpuluncunata Jesús wilapargan Jerusalenman aywaptin Israel mayor runacuna, mandag cüracuna y Moisés guelgashganta yachasegcuna chiquir nacasiyänanpä cayashganta. Saynölami wilapargan wanusiptinpis quimsa junagta cawarimunanpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sayno niptinmi jucläman gayaycur Pedro olgutupar nergan: “Tayta Dios cachamushgan Cristo caycarga ¿imanirtä sayno parlaycanqui? Sayno päsashunayquitaga ama cachapaysu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sayno niptinmi Jesús tantyargan Pedro sayno parlananpä Satanás yarpayta goshganta. Saymi Pedruta Jesús nergan: “¡Naupäpita witicuy, Satanás! Sayno michämashpayquega manami munanquisu Tayta Diosninsi munashganta ruranäta, sinöga yarpashgayquinöla cananta munarmi sapata churapaycämanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nircur discïpuluncunata Jesús nergan: “Pipis discïpulö cayta munarga shongun yarpashganno jusalicur ama cawasunsu. Saypa trucanga imano nacarpis noga munashgänöla imaypis cawasun. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Noga munashgäno cawananpa trucan quiquin munashganno cawagcunaga infiernuman gaycushmi cayangapä. Ima nacaycho carpis noga munashgäno cawagcunami isanga gloriaman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Infiernuman gaycush cananpä caycaptenga ¿imapätä välin mayjina rïcu cashganpis? Mayjina rïcu carpis manami rïcu cashgalanwanga salvacionta rantiyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Angilnëcunawan y Taytäpa munayninwan noga cutimurmi runacuna alita rurayashganpita premiuta goshä y mana alita rurayashganpita juzgashäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Manarä wanurmi waquinniqui nogata ricayämanquipä lapanpäpis munayyog cashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Saypita sogta junagtami Pedruta, Santiaguta y Santiagupa wauguin Juanta pushacurcur Jesús wisargan sunyag jircaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Saychömi paycuna ricaycäyaptin Jesuspa cäran intinörä chipipergan. Mödananpis segaypa yurag ricacur empañayparä asicyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Saychömi ricayargan Moiseswan Elías yuriparcur Jesuswan parlaycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Saymi Jesusta Pedro nergan: “Alipärä nogacuna cayman shayämushcä, taytay. Cananga rurayäshä quimsa suclata: jucta gampä, jucta Moisespä y jucta Eliaspä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sayno Pedro parlapaycaptinmi chipipiycag pucutay paycunata sapacurcorgan. Saymi pucutay rurinpita Tayta Dios nimorgan: “Payga cuyay surëmi. Noga munashgäno lapanta ruraptinmi cushish caycä. ¡Pay nishushgayquicunata cäsucuyay!” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sayno nimogta wiyaycurmi discïpuluncunaga pasaypa mansacäyashpan pampaman lätacuycuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sayno lätaraycäyaptinmi paycunata yataycur Jesús nergan: “Ama mansacäyaysu. Sharcuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sayno niptin nuquircuyänanpäga Jesús japalannami caycänä. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jircapita cutimurmi paycunata Jesús nergan: “Jircacho ricashgayquita pitapis ama wilapäyanquiräsu wanushgäpita noga cawarimushgäyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Saypitanami discïpuluncuna Jesusta tapuyargan: “Moisés guelgashgan leycunata yachasegcuna niyan Cristo shamunanpä puntata Eliasrä shamunanpä cashgantami. Sayno nicaptenga ¿imanirtä Elías shamunräsu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Sayno niyaptinmi Jesús nergan: “Elías yapay shamunanpä cashganta niyashgannölami Elías mayna shamush. Elías shamur wilacuptinpis manami runacuna chasquicuyashgasu wilacushganta. Chasquicuyänanpa trucanga payta chiquirmi wanusiyash. Saynölami runacuna nogatapis chiquimar wanusiyämangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesús sayno niptin discïpulucuna tantyayargan Juan Bautistapä parlaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jircapita cutimurmi runacuna shuntacäyashganman Jesús chargan. Saychömi Jesuspa puntanman gongurpacuycur juc runa ruwacur nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Surëta cachacaycasilay, taytay. Payta wanuy gueshya sariptinmi ninamanpis yacumanpis jegan. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Discïpuluyquicunaman apamuptëpis manami cachacäsiyta camäpacuyashgasu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sayno niptin Jesús nergan: “¡Yäracuyniynag jusasapa runacuna! ¿Imayyagrä gamcunawan caycäshä? Mä apamuy say magtata.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naupanman apaycaptinmi say magtata nacaycäseg supayta Jesús olgutupargan. Olgutupaycuptinmi supayga jinan höra magtapita yargurir aywacorgan. Say hörapitanami magta sänuna ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Saypitanami quiquilancuna caycar discïpuluncuna Jesusta tapuyargan: “¿Imanirtä nogacuna garguyta camäpacuyashcäsu say supayta?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Saymi paycunata Jesús nergan: “Janan shongula Tayta Diosman yäracurmi gamcunaga garguyta camäpacuyashcanquisu. Ñäbuspa murunno tacshalapis yäracuyniqui captenga manami imapis ajasu gamcunapä canga. Tagay jircata witicunanpä niyaptiquipis witicunmanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sayno captinpis cayno cag supaycunaga yarguyan ayunashpansi Tayta Diosta manacushgarämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea provinciacho discïpuluncunawan purirmi Jesús nergan: “Juc runami nogata entregamanga chiquimagnëcunapa maquinman. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Sayno captinpis wanusimashganpita quimsa junagtami cawarimushäpä.” Sayno niptinmi discïpuluncuna fiyupa laquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Saypitanami Capernaumman discïpuluncunawan Jesús chäyargan. Saychömi templupä impuesto cobragcuna Pedruta tapuyargan: “¿Jesusga manacu pägan templunpä impuestuta?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sayno tapuyaptinmi Pedroga nergan: “Au, päganmi.” Sayno nishpanmi Jesús caycashgan cag wayiman aywargan tapunanpä. Manarä tapuptinmi Jesús nergan: “¿Imaninquitä Simón? Nación mandag reycuna ¿pitatä impuestuta cobrayan? ¿Surincunatacu o munaynincho caycag jäpa runacunatacu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sayno tapuptinmi Pedro nergan: “Munaynincho cag jäpa runacunatami impuestutaga cobrayan, taytay.” Sayno niptin Jesús nergan: “Sauraga nación mandagpa surin impuestuta mana pägashgannömi nogapis, Tayta Diospa surin car, templunpä impuestuta pägämansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sayno captinpis cobragcuna mana rabiacuyänanpä gochaman aywar anzuëluyquiwan pescäduta sarimuy. Punta cag pescäduta sarimushgayquipa shiminchömi guellay caycangapä. Say guellaywan nogapita y gampitapis impuestuta pägaycuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Juc cutimi discïpuluncuna Jesusta tapuyargan: “Lapanpis munayniquichöna captin ¿maygäcunatatä churayämanqui más mandag cayänäpä, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sayno tapuyaptinmi juc wamrata naupanman Jesús gayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nircurmi discïpuluncunata nergan: “Wamracuna mandag cananpä mana yarpachacushganno gamcunapis ama yarpachacuyaysu mandag cayänalayquipäga. Mandag cayänalayquipä yarpachacorga Tayta Diospa naupanman manami chäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yanapäcog canayquipä yarpachacuyaptiquega Tayta Diospa naupancho mandag cayänayquipämi churayäshayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Saynöla maygayquicunapis cay wamratano mana cuentash cagcunata chasquicorga nogata chasquicamagnömi caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tayta Diosman yäracogta cuidä pitapis jusalicasiyanquiman. Jusaman tunisicogcunataga más alimi canman mulïnu rumita cuncanman sheguparcur lamarman garpuriyaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sayno captinpis jusalicasicog runaga imaypis cangami. ¡Paycunaga juicio finalcho fiyupami laquicuyangapä! ");
INSERT INTO qvhNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Sayno cananpä caycaptenga maquiqui o chaquiqui jusalicasishuptiqui cusurir jitariycuy. Imaypis mana upeg ninaman ishcay chaquiyog o ishcay maquiyog gaycush canayquipa trucanga más alimi canman juc chaquiyoglapis o juc maquiyoglapis Tayta Diosninsipa naupanman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Saynöla nawiquipis jusalicasishuptiquega ogtirir jitariycuy. Ishcan nawiyog infiernuman gaycush canayquipa trucanga más alimi canman wiscu nawilapis Tayta Diosninsipa naupanman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tayta Diospa naupancho caycag angilcunami payman yäracogcunata imay hörapis ricaycan. Sayno caycaptenga payman yäracogcunata manacagman ama churayaysu. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Runacuna jusalicushganpita salvanäpämi Tayta Diosninsi cachamash. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pipis pachac (100) uyshanpita jucta ograycorga ¿manacu waquin cagta juc pasaman aylurcur jucla aywan ashimunanpä? ");
INSERT INTO qvhNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tariycorga fiyupami cushicun. Manami saynöga cushicunsu mana ogracag uyshancunapäga. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Saynölami ciëlucho caycag Tayta Diosninsi munansu payman yäracogcuna ni juclaylapis ogracänanta. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tayta Diosman yäracog mayiqui manacagta jitapäshushpayqui contrayqui sharcuptin, perjuiciuta rurashuptiqui, lulapäshuptiqui puntata japalanwan parlanqui jusalicuycashganta tantyasinayquipä. Tantyasiptiqui chasquicuptenga perdonanqui. Sayno perdonarga alitami ruraycanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tantyasiptiquipis mana chasquishuptiquega ishcay o quimsa yäracog mayiquita pushanqui jusalicuycashganta tantyasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Paycunatapis mana cäsucuptenga lapan yäracog mayiquicuna shuntacäyashganman pushaycur tantyasiyanqui jusalicuycashganta. Saychöpis mana cäsucuptenga gampis y lapan yäracog mayiquicunapis paywan amana shuntacäyaynasu. Payga jusasapano y runacuna chiquishgan impuesto cobrag runanömi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Sayno mana cäsucogcunata corrigiyänayquipä munayyogmi gamcuna caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yapaypis gamcunata në: Juc ishcayla carpis Tayta Diosta manacuptiquega paymi yanapäshunqui munashganta ruranayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Juc ishcayla carpis Diosta manacuyänayquipä nogapa jutëcho shuntacäyaptiquega gamcunawanmi caycäshä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sayno yachasiptinmi Pedro taporgan: “Pipis rabianäsimaptenga ¿ayca cutitä perdonäman, taytay? ¿Ganchis cutisurä?” ");
INSERT INTO qvhNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sayno tapuptinmi Jesús nergan: “Manami ganchis cutilasu perdonanquiman, sinöga perdonta manacushuptiquega ayca cutipis perdonanqui. Saynöla ayca cuti rabianäsishuptiquipis ama yarparaycanquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Saypitanami Jesús nergan: “Juc nación mandag runapashi cargan asca yanapagnin runacuna. Say yanapagnincunatashi say mandag nergan cuentata goyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Sayno cuentata manaptinshi jagan runata apayargan. Say runaga yupaytapis mana atipaypäshi say mandagpa jagan cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jaganta pägananpä mana aypäpacuptinshi ashmaynincunata say mandag nergan: ‘Cay runata, warminta, surincunata y imaycancunatapis ranticuyay. Ranticurcurna guellayta apayämunqui jagäpita.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sayno niptinshi say runaga gongurpacuycur ruwacorgan: ‘Taytay, ama ari ranticaycamaysu. Imanöpapis jagayquitaga pägaycushayquicher’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sayno ruwacuptinshi say mandag cuyapashpan lapan jaganta perdonar manana ranticorgannasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Sayno perdonarcuptin aywacuycashganchöshi say runa tincorgan juc arog mayinwan. Say arog mayenga pachac (100) denariushi jagan cargan say aywaycag runapa. Sayshi aywaycag runaga cuncapita aptacurcorgan: ‘¡Jagäta pägamay!’ nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Sayno ruraptinshi arog mayenga gongurpacuycur ruwacorgan: ‘Jagayquitaga pägayculäshayquicher, taytay. Ichiclata shuyaycalämay, ari’ nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sayno ruwacuptinpis manashi arog mayinta perdonayta munargansu. Saypa trucanga carcilmanshi wichgasergan jaganta pägashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Sayno rurashganta ricaycurshi waquin arog mayincunaga fiyupa rabianäyargan. Sayshi mandagman aywar wilayargan say perdonashgan runa arog mayinta carcilman wichgasishganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sayshi say perdonashgan runata gayaycasir say mandag nergan: ‘¡Mana cuyapäcog runa! ¿Manacu yarpanqui sayjinanpa jagä captiquipis ruwacamaptiqui lapanta perdonashgäta? ");
INSERT INTO qvhNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sayno perdonaycaptëga ¿imanirtä gamga arog mayiquita perdonashcanquisu?’ ");
INSERT INTO qvhNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sayno fiyupa rabiacurshi say mandag carcilman quiquintapis wichgasergan. Saychömi wardia castigargan say mandagpa jaganta pägananyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sayno wilaparcurmi Jesús nergan: “Runa mayiquicunata lapan shonguyquiwan mana perdonayaptiquega gamcunatapis Tayta Diosninsi manami perdonayäshunquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sayno yacharcasirmi Galilea provinciapita aywar Jordán mayupa wac simpanpa Jesús tumargan Judea provinciaman chänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Say quinranpa puriptin asca runacunami guepanta aywayargan. Saychömi gueshyagcunatapis Jesús aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Saymanmi fariseo runacuna aywaycur lutanta parlasinan cash ali shimilanpa Jesusta tapuyargan: “¿Ima achäquilapis warminpita runa raquicanmancu o manacu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sayno tapuyaptinmi Jesús nergan: “¿Manacu gamcuna liyiyashcanqui Tayta Diosninsipa palabranta? Saycho nican olguta warmita Tayta Dios camashgantami. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sayno camarcurmi Tayta Dios nergan: ‘Sayno captinmi warmita ashir runa promitin mana raquicaypa tänanpä. Saymi majasacarna mamanpa taytanpa maquincho caycashganpita runa yargucun warminwan tänanpä. Warminwan tarnami jäpa carpis paywan say castalana ricacun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sayno cananpä Tayta Dios nicaptenga mananami ishcay castanasu caycäyan, sinöga juc castalanami caycan. Saymi Tayta Diosninsi juclasashgantaga pipis raquinmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sayno niptinmi fariseo runacuna tapuyargan: “Sayno captenga ¿imanirtä Moisés guelgashgancho nican raquicar papilta firmaparcuptin warmi aywacunanpä cashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sayno tapuptinmi Jesús nergan: “Tayta Diosninsega runata warmita camargan majasacarnaga mana raquicaypa täyänanpämi. Sayno captinpis runacuna mana cäsucog cayaptinmi Moisesta Tayta Dios tantyasergan sayno guelgananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sayno captinpis nogaga caynömi në: Maygan runapis warmin mana jarucuycaptin warminpita raquicarcur juc warmiwan targa adulteriuchömi caycan. Saynöpis runanpita raquicash cag warmiwan pipis targa adulteriuchömi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Saymi discïpuluncuna niyargan: “Sayno captenga mejor warmitapis ama ashishwansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sayno niyaptin Jesús nergan: “Sayno niyaptiquipis manami lapansu majaynag cawayta camäpacuyan. Waquilanmi majaynag täcuyänanpä caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquin runacunaga yurish majaynagla täcunanpämi. Waquenga capash carmi majasacaytapis munayannasu. Waquinnami isanga Tayta Diosninsipa wilacuyninta wilacur puricunan cash mana majasacaylapa täcuyan. Pipis mana majasacaylapa täcuyta munarga japala täcusun.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Saypitanami wamracunata Jesús cagman apayargan umanman maquinta churaycur Tayta Diosta manacunanpä. Wamracunata apaycagta ricarmi discïpuluncuna michäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Saymi discïpuluncunata Jesús nergan: “Wamracunata apacayämunanta ama michäyaysu. Wamrano cagcunami Tayta Diospa naupanman chäyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sayno nircurmi wamracunapa umanta yataycushpan Tayta Diosta manacorgan. Nircurnami saypita aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juc cutichömi juc magta Jesusman aywaycur nergan: “Gam imaycatapis musyanquimi, taytay. Saymi tapuculäshayqui. ¿Imatatä ruräman Tayta Diospa naupanman chänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Saymi Jesús nergan: “Tayta Diosnilansimi lapantapis musyaycan. Saymi mayna nimashcansi mandamientuncunata cumplir naupanman chänansipä cashganta. Sayta musyaycarga ¿imanirtä tapumanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sayno niptin say magta taporgan: “¿Maygan mandamientucunatatä cumplëman, taytay?” Saymi Jesús nergan: “Runa mayiquita ama wanusinquisu. Ama adulteriucho canquisu. Ama suwacunquisu. Manacagtaga ama pitapis tumpanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mamayquitawan taytayquita ali ricanqui. Saynöpis runa mayiquita lapan shonguyquiwan cuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Saymi magta nergan: “Saycunataga wamra cashgäpitami lapanta cumplishcä, taytay. ¿Imatä más pishiycäman cumplinäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Niptin Jesús nergan: “Lapanta cumpliycarpis Tayta Diospa naupanman chänayquipäga lapan imayquicunatapis ranticuycur guellayta muchogcunata aypuy. Sayno rurashpayquega gloriaman riquëzayquita churacognömi caycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sayno niptinmi segaypa rïcu car say magta laquish aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Magta sayno aywacuptinmi discïpuluncunata Jesús nergan: “¡Ajami caycan rïcu runacuna Tayta Diospa naupanman chäyänanpäga! ");
INSERT INTO qvhNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Auja uchcupa camëllo päsayta mana camäpacushganno rïcu runapis quiquilanpitaga Tayta Diospa naupanman chayta manami camäpacunsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sayta wiyar discïpuluncuna segaypa mansacash niyargan: “Sayno captenga ¿pirä salvacongapä?” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Saymi paycunata ricärishpan Jesús nergan: “Quiquilanpitaga runacuna manami salvacuyta camäpacuyansu. Tayta Dioslami pitapis salvan. Saymi Tayta Diosninsipäga imapis ajasu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Saymi Pedro nergan: “Nogacunaga lapantami imaycätapis cachariyashcä gamta gatiräyänäpä, taytay. Sayno ruraycäyaptëga ¿imatä canga nogacunapäga?” ");
INSERT INTO qvhNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sayno niptinmi Jesús nergan: “Juicio finalcho lapan runacunata noga juzgaptëmi chunca ishcay (12) trönucunacho jamacuyanquipä. Saychömi gamcunapis chunca ishcay castapita mirag Israel mayinsicunata juzgayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Noga munashgäta ruranan cash pipis wayinta, wauguincunata, panincunata, mamanta, taytanta, surincunata y chacrancunatapis cachareg cäga pachac (100) cuti mastami chasquengapä. Saynöpis wanucur Tayta Diospa naupancho imayyagpis cushishmi cawangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Waquin runacuna, rïcu cashganpita respitädu carpis, gloriaman manami chäyangasu. Waquin runacunami isanga, mana cäsush pobri carpis, gloriaman char cushicuyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Saypitami Jesús nergan: “Tayta Diospa maquincho cawagcuna imano cananpä cashganpitapis canan tantyasiyäshayqui. Juc runashi tuta tutala mincay asheg aywargan üva chacrancho arusinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mincayta tariycur aycata pägananpäpis parlarcurshi üva chacrancho arunanpä cachargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Saypita las nuëvimanno pläzapa yapay yargurshi runacunata tarergan aruyniynag puriycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sayshi nergan: ‘Gamcunapis üva chacrächo aruyänayquipä aywaycuyay. Aruyashgayqui-tupumi pägayäshayqui.’ Sayno niptin paycunapis cushish aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Pulan junag caycaptinpis y tardi malway inti caycaptinpis say chacrayog runaga yapay mincay asheg aywargan. Sayshi tarishgan runacunatapis mincacorgan chacranman arog aywayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Saypita inti jegaycaptinnashi yapay pläzaman aywar runacunata tarergan aruyniynag caycagta. Sayshi paycunatapis nergan: ‘Gamcunapaga ¿manacu aruyniqui can caycho goyaypa puricuyänayquipä?’ ");
INSERT INTO qvhNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Sayno niptinshi paycuna niyargan: ‘Manami pipis mincacayämashgasu arupäyänäpä, taytay.’ “Saymi nergan: ‘Sauraga gamcunapis aywaycuyay chacrächo arupäyämänayquipä. Aruptiquega pägashayquimi.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pasa sacaycaptinnashi say ämu capatazninta nergan: ‘Lapan arogcunata gayaycasimur pägay guepata arog yaycogcunapita galaycur tutapita yaycogcunayag.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sayno gayasimuptinshi shayämorgan inti jegaycaptin arog yaycogcuna. Paycunashi chasquiyargan juc jornal complëtu päguta. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sayno chasquiyashganta ricarshi tutapita arogcunaga shayämorgan más ascata chasquiyänanpä cayashganta yarpar. Sayno yarparpis juc jornal complëtulatashi chasquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Waquin chasquishgannöla chasquirshi puntata yaycogcunaga chacrayogta niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Último yaycamogcuna juc hörala aruycäyaptenga ¿imanirtä nogacunataga sayjina shanaycho aruycäyaptëpis paycunata pägashgayquinöla pägaycäyämanqui?’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Sayno niyaptinmi chacrayog runa nergan: ‘Parlashgansinöla pägaycarga manami gamcunata engañaycäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Parlashgansino päguta chasquiycarga ¿imatanatä más munanqui? Nogapitanacher cacun guepa yaycamogcunatapis gamcunatanöla pägaptëga. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gamcunaga ¿ima cuentayogtä cayanqui aycata pägacuptëpis? ¿Ali runa cashgäpitacu jamuräyämanqui?’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sayno wilaparcurmi Jesús nergan: “Say arupacuyman punta yaycogwan guepa yaycogpis iwal päguta chasquishgannömi Diospa wilacuyninta más puntata chasquicogcuna y guepatarä chasquicogcunapis gloriaman chäyangapä. Salvananpä ascagta Tayta Diosninsi gayasiptinpis walcaglami naupanman changapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalenman aywaycäyashganchömi chunca ishcay (12) acrashgan discïpuluncunata jucläman gayaycur Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Musyayanquimi Jerusalenpa aywaycashgansita. Saychömi mandag cüracuna y Moisés guelgashganta yachasegcunapis nogata prësu sariyämanga. Nircurmi wanusiyämänanpä mana Israel runacunapa maquinman entregayämanga. Paycunanami asipäyämanga, astayämanga y crucificayämangapis. Sayno captinpis quimsa junagtaga cawarimushämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Saypitami Santiaguta y Juanta pushacurcur maman aywargan Jesús cagman. Paymi Jesuspa puntanman gongurpacuycur nergan: “Ruwaculäshayqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sayno niptin Jesús nergan: “Captenga alicher canman.” Saymi say warmi ruwacur nergan: “Mandag canayquipä Tayta Diosninsi churashuptiqui cay ishcay wawäcunata churayculanqui gamta mandäsishunayquipä, taytay. Jucta derëchayqui cagman y jucagtana isogniqui cagman jamaycasilanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Saymi mamantawan Santiaguta y Juanta Jesús nergan: “Gamcunaga mana tantyacuypachä manacaycäyämanqui. ¿Gamcuna awantayanquimansurä nogata nacasimashganno nacasiyäshuptiqui?” Saymi paycuna niyargan: “Au, awantayäshämi, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sayno niyaptin Jesús nergan: “Rasunpaypami noga nacashgäno gamcunapis nacayanquipä. Sayno captinpis isognëman y derëchämanga pitapis jamasishä Tayta Dios nimashgan caglatami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Santiagupawan Juanpa maman ruwacushganta wiyarmi waquin cag discïpuluncuna rabianäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Saymi discïpuluncunata gayaycur Jesús nergan: “Gamcuna musyayashgayquinöpis nación mandag runacunaga mandag cayninman atiënicuycur runacunata mandayan. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Gamcunachöga manami sayno canmansu. Saypa trucanga waquin runacunapita más ali ricash cayta munarga runa mayiquita ashmaynöla yanapäyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Manami runacunata munashgäta rurasinäpäsu noga shamushcä, sinöga runacunata yanapänäpämi shamushcä. Saynöpis shamushcä runacuna-raycu wanur salvanäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó marcapita Jesús aywacuptinmi asca runa payta gatiräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Say nänichömi ishcay gapra runacuna jamaraycäyargan. Paycunami Jesús päsaycagta wiyar gayacuyargan: “¡Rey Davidpa castan Jesús, nogacunata cuyapaycayälämay!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sayno gayacuyaptinmi runacuna olgutupäyargan upälacuyänanpä. Sayno olgutupäyaptinpis masrämi gayacuyargan: “¡Rey Davidpa castan Jesús, nogacunata cuyapaycayälämay, ari!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sayno gayacuyashganta wiyarmi Jesusga ichisquergan. Nircurnami gayaycur taporgan: “¿Imacho yanapänätatä munaycanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Niptin paycuna niyargan: “Nawëcuna ricanantanami munayä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sayno manacuyaptinmi paycunata cuyapar nawincunata yataycorgan. Sayno yataycuptinmi jinan höra nawincuna ricarganna. Saymi paycunapis Jesusta gaticurcur aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Saypitanami discïpuluncunawan Jesús aywayargan Jerusalenman. Olivos lömacho caycag Betfagé marcaman chäyänanpäna caycar ishcay discïpuluncunata puntata cachargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Aywayay Betfagé marcaman. Marca yaycunalanchömi tariyanqui malta wawayog ashnu wataraycagta. Sayta pascarir apayämunqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pipis: ‘¿Imanirtä ashnöta pascaycäyanqui?’ niyäshuptiquega niyanqui: ‘Señor Jesusmi nistaycan muntacunanpä. Rätumanpaypami cutirasiyämushä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sayno cananpämi Tayta Diosninsipa profëtan cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén marcacho tag runacuna, ricayay mandagniqui rey shamuycagta. Payga mana runa-tucuylapami manarä amansashga ashnun muntash shamuycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús nishgannölami discïpuluncunaga aywar malta ashnuta apayämorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mamantinta apaycur punchuncunata say malta ashnuta carunaparcuyaptinmi Jesús muntacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sayno aywaptinmi asca runacuna marcapita aywayargan Jesusta chasquicog. Saymi waquin jacuncunata punchuncunata jorgurir Jesús aywashgan näniman mashtayargan. Waquinnami palmata muturir muturir näniman mashtayargan payta cushish chasquicuyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Saymi puntanta aywagcuna y guepanta aywagcunapis cushicuyashpan niyargan: “¡Tayta Diosninsi cachamushgan mandamagninsi caychönami caycan! ¡Paymi David castapita mandamagninsi rey caycan! ¡Tayta Diosninsi imayyagpis alabash cayculäsun!” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalenman Jesús sayno yaycuptinmi runacuna yargayämorgan payta ricayänanpä. Saymi jucninpis jucninpis tapunacuyargan: “¿Pitä yaycaycämun?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Saymi runacuna niyargan: “Payga caycan Galileacho caycag Nazaret marcapita shamog Jesusmi. Payga Tayta Diosninsipa profëtanmi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Templo patiuman yaycurirmi saypita Jesús gargorgan ranticuycagcunata y rantipacuycagcunatapis. Saynölami guellay ranticogcunapa mësantapis y paloma ranticogcunapa mësantapis ticwar ushargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gargurmi paycunata nergan: “Tayta Diosninsipa palabranchöga caynömi guelgaraycan: ‘Templöga canga nogata manacayämänanpämi.’ Sayno guelgaraycaptenga ¿imanirtä gamcuna ticrasiyashcanqui suwacunapa machayninmanno?” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Saychömi gapracuna y wegrucunapis Jesuspa naupanman aywayargan. Paycunataga lapantami aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sayno aliyaycäsegta ricaycurmi mandag cüracuna y Moisés guelgashganta yachaseg runacunapis fiyupa rabianäyargan. Saynölami rabianäyargan wamracunatapis cayno negta wiyar: “¡Mandamänansipä rey Davidpa castan chämushganami! ¡Gloria Dios!” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sayno rabianäyarmi Jesusta niyargan: “¿Wiyanquicu say wamracuna nicäyashganta?” Saymi Jesús nergan: “Au, wiyämi. ¿Manacu gamcuna liyiyashcanqui cayno guelgaraycashganta: ‘Gamta alabayäshunayquipä wasguish wamracunata y chuchuycag wamracunatami tantyasishcanqui, Tayta Dios’?” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Paycunata sayno nisquirmi Betania marcaman cutergan saycho posädacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Waraynin tuta Jerusalenman Jesús cutiycarmi micanargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Saymi jïgus jachata ricaycur aywargan wayuyninta ashinanpä. Wayuyninta ashir manami juclaylatapis tarergansu. Rapralanta tariycurmi nergan: “¡Cananpitaga manami imaypis wayunquipänasu!” Sayno niptin jinan hörami say jïgus jacha saquicäcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sayta ricaycurmi discïpuluncuna Jesusta tapuyargan: “¿Imanöpatä say jïgus jacha rasla saquisquish?” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Saymi Jesús nergan: “Lapan shonguyquiwan Tayta Diosman yäracorga cay jïgus jachata saquisishgänölami gamcunapis mana criyiypä cag milagrucunata rurayanquipä. Tagay jircata witicunanpä niyaptiquipis witicongami. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lapan shonguyquiwan yäracur imatapis Tayta Diosta manacorga manacuyashgayquita chasquiyanquipämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Saypita Jerusalenman cutirmi templo patiuman Jesús yaycorgan. Saycho yachaycäsiptinmi mandag cüracuna y Israel mayor runacuna Jesusta tapuyargan: “Gamga ¿ima munayniquiwantä templo patiucho ranticogcunata gargushcanqui? ¿Pitä nishushcanqui sayno gargunayquipä?” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Sayno niyaptinmi paycunatapis Jesús taporgan: “Gamcunatapis canan tapuyäshayqui. ¿Pitä Juanta cachamorgan bautizananpä? ¿Tayta Diosninsicu o runacunacu? Tapushgäta niyämaptiquega nogapis wilashayquimi pipa munayninwan templo patiupita gargushgätapis.” Sayno niptinmi quiquinpura wilanacuyargan: “Ama nishunsu Tayta Diosninsi cachamushganta. ‘Tayta Diosninsimi cachamush’ nishgaga: ‘¿Imanirtä criyiyargayquisu?’ nimäshunmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Saynöpis ama nishunsu runacuna cachayämushganta. Sayno nishgaga runacuna samgarpis ushaycamashwanmi. Lapanmi yarpäyan Juanga Tayta Diosninsipa profëtan cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sayno wilanacurcurmi paycuna niyargan: “Manami musyayäsu pï cachamushgantapis.” Sayno niyaptinmi Jesús nergan: “Gamcunapis mana wilaycäyämaptiquega nogapis manami wiläsu pipa munayninwan templo patiupita ranticogcunata gargushgätapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Saypitana Jesús nergan: “Juc runapashi ishcay surincuna cargan. Sayshi mayor cag surinta nergan: ‘Ay, hïjo, canan junag arupaycalämay.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Sayno ruwacuptin surin nergan: ‘¡Manami tiempö cansu yanapänäpä!’ Sayno nircurpis yarpachacurerga taytanta yanapag aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mayor surin cagta mincacushgannölashi shulca cag surintapis mincacorgan. Sayshi say surenga: ‘Yanapäshayqui ari, papá’ nergan. Sayno aunircurpis manashi aröseg aywargansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sayno wilaparcurmi mandag cüracunata y autoridäcunatapis Jesús taporgan: “Say ishcan wauguipita ¿maygantä taytan munashganta rurash?” nir. Sayno niptin: “Mayor cag surinmi” niyargan. Saymi Jesús nergan: “Say mayor cag surin ñëgarcurpis yanapashgannömi Romapä impuesto cobragcuna y jusalicog warmicunapis caycäyan. Jusancunata cacharir Tayta Dios munashganno cawayashpanmi paypa naupanman chäyangapä. Gamcunami isanga Tayta Diosta mana cäsucur naupanman chäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautistaga yachasergan jusalicuycunata cacharir Tayta Dios munashganno cawayänanpämi. Sayno wilacuycaptinpis gamcunaga manami chasquicuyashcanquisu. Runacuna chiquiyashgan impuesto cobragcuna y jusalicog warmicunami isanga pay wilacushganta chasquicuyash. Paycuna chasquicuyashganta ricaycarpis gamcunaga imaypis manami chasquicuyashcanquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mastapis Jesús tincusiypa yachasergan: “Juc runashi juc chacra üvata plantargan. Nircurnashi uywacuna mana yaycunanpä guenchasergan. Saypitanashi üva jarucuna pözutapis jinan chacracho rurasergan. Nircurnashi suclatapis rurasergan üvata täpananpä. Lapanta ruraycasirnashi chacra arog runacunata arrendacuycur juclä marcapa aywacorgan saycho tänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Cosëcha galaycuptinnashi cachargan ashmaynincunata üva chacra arrindunpita cobramunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cobracog chaptinshi chacra arrendagcunaga say ashmaycunata waquinta magayargan, waquinta wanusiyargan y waquintanashi samgar ushayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sayno rurayaptinpis chacrayöga yapayshi waquin ashmaynincunata cachargan. Paycunatapis saynölashi rurayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ultimutaga cuyay surintanashi cachargan: ‘Surëtaga chasquicuyangami’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sayshi say surin chaycagta ricaycur chacra arrendagcuna wilanacuyargan: ‘Tagaymi cay chacrawan quëdananpä caycan. Nogansipäna cay chacra cananpä payta wanuriycasishun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sayshi chaycuptin üva chacrapita jucläman jorgurir wilanacuyashgannöla wanusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Sayno rurayashganpita say üva chacrayöga ¿imatatä ruranga say chacrata guechuyta munag runacunata?” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesús sayno tapuptinmi paycuna niyargan: “Say mana ali runacunataga mana cuyapaypami wanusir ushanga. Nircurmi tiempulancho chacra arrindupita pägag cagtana chacranta arrendacuycongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Sayno niptinmi Jesús nergan: “Say chacra arrendag mana ali runacunata wanusiyashgannömi gamcunatapis Tayta Diosninsi infiernuman gaycuyäshunquipä. Pay munashganno cawagcunatami isanga salvangapä. Infiernuman gaycuyäshunayquita mana munarga Tayta Diosninsipa palabrancho cayno guelgarashganta tantyacuyay: ‘Wayi sharcasegcuna: “Manami alisu cay rumi” nir jitariycuyaptinpis wayi esquïnaman cimientupä say rumi churashganami caycan. Cimiento cananpäga Tayta Diosninsimi churash. Sayno churash captinmi cushicuypä caycan.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pipis say cimiento rumi jananman tuneg cäga ushacangami. Saynölami pipa jananmanpis say rumi unyarga pasaypa ushacäsenga.” ");
INSERT INTO qvhNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sayno tincusiypa yachasiptinmi mandag cüracuna y fariseo runacuna tantyayargan tumasipaylapa paycunata Jesús sayno nicashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Saymi rabianäyashpan prësu sariyta munarpis camäpacuyargansu runacunata mansapäyashpan. Lapan runacunami parlayag Jesusga Tayta Diosninsipa profëtan cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Saypitanami casaracuy fiestaman tincusiypa Jesús yachasergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Juc mandag reyshi olgu surin casaraptin fiestata rurargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sayshi ashmaynincunata cachargan gayasishgancunata fiestaman pushayämunanpä. Sayno gayasiptin say gayasishgan runacuna manashi mayganpis aywayta munayargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Saypita yapayshi waquin ashmaynincunatana cachargan: ‘Töröcunata y wera cag wäcäcunatapis pishtarcasir micuyta rurasishgä listunami caycan. Gayasishgäcuna jucla shayämusun surë casaraptin fiestacho canansipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sayno gayasiptinpis manashi mayganpis say fiestaman aywayargansu. Saypa trucanga chacran arogshi waquin aywacuyargan. Waquinshi negociun ranticog aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquinnashi say reypa ashmaynincunata magaycashgalancho wanusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Sayshi fiesta rurag reyga fiyupa rabiacur soldäduncunata cachargan ashmaynin wanuseg runacunata wanusiyänanpä y marcantapis rupasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nircurshi ashmaynincunata nergan: ‘Surë casaraptin fiestata ruranäpä lapanpis puestushganami caycan. Sayno captinpis say gayasishgä runacuna manacagman churamarmi shayämushgasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cananga cällicunapa aywar tariyashgayqui cag runacunata wilayay puestucushgansi fiestaman shayämunanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Sayno niptinshi ashmaynincuna yargur wilayaptin ali runapis mana ali runapis fiestaman chäyargan wayi juntagpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sayshi wayicho caycag runacunata ricananpä yaycur say rey ricargan juc runa casarag magtata mana respitashpan trucacöni saycho caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Say respëtuynag runata ricaycurmi taporgan: ‘Amïgo, trucacurcur shamunayquipä cashganta musyaycar ¿imanirtä mana trucacuylapa cayman shamushcanqui?’ Sayno tapuptinmi say runa pengacushpan imaniytapis camäpacorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sauraga ashmaynincunata say rey nergan: ‘Surë casaraycaptin trucacöni shamur manacagman churashganpita chaquipita maquipita pancayay. Nircurna yanauyaycag sacayman jitarpuyay. Saychömi fiyupa wagar quiruntapis uchongapä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sayno wilaparcurmi Jesús nergan: “Tayta Dios lapan runacunata gloriaman chänanpä gayasiptinpis waquilanmi gloriaman chäyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Saypita fariseo runacuna templupita yargurcur wilanacuyargan ali shimilanpa Jesusta parlapar lutanta parlasiyänanpä, nircur lutanta parlasishgalanwanna acusayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Saymi imata ninanpäpis shumag yacharcasir fariseo runacuna cachayargan discïpuluncunatawan Herodispa favornin sharcog runacunata. Paycunami Jesusta niyargan: “Nogacuna musyayämi imata yachasirpis Tayta Dios munashganno shumag yachaycäsishgayquita, taytay. Saymi yachagtapis mana yachagtapis Diospa wilacuynin nishgannöla yachasinqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gampa yarpayniquipitaga Romacho emperador Cesarpä impuestuta ¿pägashwancu o manacu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lutanta parlasiyta munar sayno tapushganta tantyarmi Jesús nergan: “¡Ishcay cära runacuna! ¿Imanirtä lutanta parlasimayta munayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä ricasimay say impuesto päganayquipä cag guellayta.” Sayno niptinmi sararashgan guellayta Jesusta aptaparcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sayta ricaycur Jesús taporgan: “Cay guellaycho ¿pï runapa reträtuntä caycan? Saynöpis ¿pipa jutintä guelgaraycan?” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sayno tapuptin niyargan: “Emperador Cesarpami.” Saymi Jesús nergan: “Emperador Cesarpa cagta Cesarta goycuyay. Tayta Diospa cagtaga Tayta Diosninsita goycuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sayno niptinmi say runacuna imaniytapis mana camäpacur aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Say junaglami saduceo runacunapis Jesusman aywayargan pay yachasishganta manacagman churananpä. Saymi Jesusta niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Moisés guelgashgancho caynömi nican, taytay: ‘Warmiyog runa suriynag wanuptin shulca wauguin cuñädan viüdawan täsun. Saynöpami wamrancuna say wanog cag runapa surinnöna cayanga.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sayno captenga tapucushayqui, taytay. Juc marcachöshi ganchis wauguicuna cayargan. Mayor cagshi juc warmiwan targan. Sayshi manarä surin captin wanorgan. Sauraga shulca cag wauguinnashi targan say viüdawan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Paypis surin manarä captinshi wanorgan. Saypita más shulcan cagna targan say viüdawan. Paypis wanorgan surin manarä captinshi. Saynöla lapan wauguincuna say viüdawan täyargan. Suriynagla lapanpis wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Saypitanashi say viüdapis wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wanushcunata Tayta Diosninsi cawarisimunan junäga say warmilachi ganchis wauguipa warmin canga.” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sayno niyaptinmi Jesús nergan: “Sayno niyashpayquega gamcuna manami tantyayanquisu Tayta Diospa palabrancho guelgaraycashganta. Saynöpis manami tantyayanquisu wanushcunata cawarisimunanpä Tayta Dios munayyog cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wanushganpita cawarimorga mananami pipis warmiyogsu ni runayogsu canga, sinöga gloriacho caycag angilcunanölanami majaynagla cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wanushcuna cawariyämunanpä cashgantaga ¿manacu liyiyashcanqui Tayta Diospa palabrancho guelgaraycashganta? Abraham, Isaac y Jacob wanushganpita asca wata guepatarämi Tayta Diosninsi Moisesta nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ Wanogcuna mana cawariyämunanpä captenga ¿imanöpatä Abrahampa, Isaacpa y Jacobpa Diosnin canman? Sayno caycaptenga ¿imanirtä gamcuna criyiyanquisu wanogcuna cawariyämunanpä cayashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sayno yachasishganta wiyaycur saycho caycag waquin runacuna fiyupa cushicuyargan: “¡Jesusga alimi yachasimansi!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceo runacunata Jesús upälasishganta musyaycurmi fariseo runacuna shuntacaycur wilanacuyargan imanöpapis Jesusta lutanta parlasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sayno wilanacurcurmi Moisés guelgashganta yachaseg fariseo runa lutanta parlasinan cash ali shimilanpa Jesusta taporgan: ");
INSERT INTO qvhNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Taytay, ¿maygan mandamientutatä más cäsucushwan?” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sayno tapuptinmi Jesús nergan: “ ‘Shumag tantyacuycur lapan shonguyquiwan y lapan voluntäniquiwan Tayta Diosta cuyay.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Say mandamientumi lapan mandamientupitapis más cumplinansipä caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Saynölami jucag mandamientupis nican: ‘Runa mayiquita lapan shonguyquiwan cuyay.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cay ishcay mandamientuta cumplerga Moisés guelgashgan lapan mandamientucunata y Diospa profëtancuna guelgayashgan mandamientucunatapis cumpliycäyanquimi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Saypita fariseo runacuna saycho shuntacash caycäyaptinmi paycunatana Jesús taporgan: ");
INSERT INTO qvhNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gamcunapäga ¿maygan castapitatä Cristo yurenga?” Sayno tapuptinmi niyargan: “David castapitami, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Saymi Jesús nergan: “David castapita captinpis ama yarpäyaysu Davidnöla mandag rey cashganta. Davidnöla mandag rey captenga ¿imanirtä quiquin Davidpis Santu Espíritu tantyasiptin mandagnin rey cashganta ninman cargan? Sayta nirmi David cayno guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Munaynincho sararämag mandag reyta Tayta Diosninsi caynömi nergan: Jamacamuy derëcha cag naupäman lapan contrayquicunata vincishgäyag.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Sayno nicaptenga ¿imanöpatä Cristoga Davidnöla mandag rey canman quiquin Davidpis mandagnin rey cashganta nicaptenga?” ");
INSERT INTO qvhNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sayno niptin manami pipis contestayta camäpacuyargansu. Say junagpita-pasaga manami pipis tapupayta almitergannasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nircurnami runacunatawan discïpuluncunatapis Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","“Moisés guelgashganta yachasegcuna y fariseo runacuna Tayta Diospa palabranta yachasiyäshuptiqui chasquicuyay. Isanga paycuna cawayashgannöga ama cawayaysu. Diospa palabranta yachasirpis quiquincunaga manami cumpliyansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paycunaga runacuna ima ruraytapis mana camäpacuyashganyagmi Moisés guelgashgan leycunamanpis yapa yaparcur imatapis cumpliyänanpä niyan. Sayno yachasiyashganta runacuna cumpliyta mana camäpacuyaptinpis shacyäsinanpa trucanga olgutupäyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Paycunaga waquin runacunapitapis filacteriancunata más jatunta ruraycur purisiyan ricagcuna: ‘Payga Tayta Diosta cäsucog ali runami caycan’ niyänalanpämi. Saynöpis waquin runacunapita más jatun flëcucunata mödananpa chuscun cuchunman jiraycur puriyan ricagcuna: ‘Payga Tayta Diosta cäsucog ali runami caycan’ niyänalanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Micuyänanpä gayasiyaptinpis paycunaga mësa cagmanrämi jamacuyta munayan. Saynölami sinagogacunachöpis alinnin bancumanrä jamacuyta munayan. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Paycunaga pläzacunachöpis yachasicog cashganpita alabash caylatami munayan. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Gamcunaga ama paycunano cayaysu. Manami yachag-tucunayquipäsu noga yachasishcä. Saypa trucanga tantyacuyay discïpulöcuna car say wauguila caycäyashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pï yachasicogtapis Tayta Diosninsitanöräga ama ricanquisu. Tayta Diosmanga manami pipis iwalansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sayno captenga gamcuna wilacuynëta wilacur ama alabash cayta munalar puriyanquisu. Manami alabash cayta munalar puriyänayquipäsu gamcunata yachasishcä. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maygayquipis ali ricash cayta munarga mana yachag-tucuypa runa mayiquita yanapanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Maygantapis yachag-tucogtaga Tayta Diosninsi manami cäsupangasu. Mana yachag-tucuypa pï-maytapis yanapagcunatami isanga Tayta Diosninsi cuyapar yanapangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Moisés guelgashganta yachasegcuna y fariseo runacuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Wayiman pipis mana yaycunanpä puncuta wichgapagnömi runacunata wichgapaycäyanqui Tayta Diosninsi munashganta mana yachacuyänanpä. Saynölami quiquiquicunapis Tayta Diosninsi munashganno cawayanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Moisés guelgashganta yachasegcuna y fariseo runacuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Gamcunaga Tayta Diosninsita manacuycarpis ali-tupaylapa viüdacunapa ima pobrëzalantapis apacuycäyanqui. Sayno rurayashgayquipitami infiernucho más fiyupa nacayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Moisés guelgashganta yachasegcuna y fariseo runacuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Gamcunaga may-saypapis yachaseg aywayanqui fariseo cayman runacuna yaycuyänalanpä. Yachasiyashgayquicunata yachacurcurnami gamcunapita masna ishcay cära cayan. Sayno cashgayquipitami gamcunapis y paycunapis infiernucho segaypa nacayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Juicio finalchöga fiyupami laquicuyanquipä! Gamcunaga nicäyanqui Moisés guelgashgan leycunata yachaseg car gaprata pusharagno caycäyashgayquitami. Sayno niyashpayquipis quiquiquicunaga manami tantyacuyanquisu lutanta yachaycäsishgayquita. Sayno mana tantyacuyashpayquimi runacunata yachasir nicäyanqui: ‘Pipis templupa jutinta jogarcur promitishganta mana cumpliptinpis manami imananpissu. Templo rurincho caycag goripa jutinta jogarcur promiteg cag isanga sayta cumplisun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana tantyacog upa runacuna! ¿Manacu tantyayanqui templupa jutinta jogarerga templo rurincho caycag goripa jutintapis jogarishgayquita? ");
INSERT INTO qvhNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Saynöpis gamcunaga runacunata yachaycäsiyanqui: ‘Altarpa jutinta jogarcur promitishganta mana cumpliptiquipis manami imananpissu. Altar janancho churashgan ofrendapa jutinta jogarcur promitirmi isanga sayta cumpliyanqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mana tantyacog upa runacuna! ¿Manacu tantyayanqui altarpa jutinta jogarerga altar jananman churashgan ofrendapa jutintapis jogarishgayquita? ");
INSERT INTO qvhNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Altarpa jutincho jurarga manami altarpa jutilanchösu juraycanqui, sinöga altar jananman churashgan ofrendacunapa jutinchöpis juraycäyanquimi. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Templupa jutincho jurarpis manami templupa jutilanchösu juraycäyanqui, sinöga templucho caycag Tayta Diosninsipa jutinchöpis juraycäyanquimi. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ciëlupa jutincho jurarpis saycho Tayta Dios jamaraptin quiquin Tayta Diosninsipa jutinchömi juraycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Moisés guelgashganta yachasegcuna y fariseucuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Gamcunaga templuman apayänayquipä mentapita, anispita y comïnuspitapis diezmuta imaypis raquiycäyanqui: ‘Tayta Diospa palabrancho nishgannöla lapantami ruraycä’ niyashpayqui. Sayno rurarpis manami cäsucuyanquisu más cäsucuyänayquipä cag mandamientucunata. Say mandamientucunata mana cäsucurmi runa mayiquicunata mana ali ricaycäyanqui, cuyapaycäyanquisu y auniyashgayquitapis cumpliycäyanquisu. Diezmuta templuman apar Tayta Diosninsipa palabranta cumpliyashgayquinöla runa mayiquitapis ali ricayanquiman, cuyapäyanquiman y imata aunirpis cumpliyanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Mana tantyacog upa runacuna! Tayta Dios nishgancunata waquinta cumplirpis más cumpliyänayquipä cagcunata manami cumpliycäyanquisu. Sayno carmi yacucho chushpita shuyshuycurrä upurpis mana mayayla jatuncaray camëlluta ultacurcogno caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Moisés guelgashganta yachasegcuna y fariseo runacuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Gamcunaga pusillupa y plätupa janalanta maylar rurintaga mana maylagnömi caycäyanqui. Saymi pusillupa y plätupa rurincho ganra cashganno mana ali yarpäyashgayquiwan ambiciöso cayashgayquipis shonguyquicunacho caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Mana tantyacog fariseucuna! Tayta Diosninsi munashganno cawayänayquipäga puntata jusalicuyashgayquicunatarä cachariyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Moisés guelgashganta yachasegcuna y fariseo runacuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Gamcunaga cuyaylapä rurash nïchu-niragmi caycäyanqui. Nïchupa janan cuyaylapä captinpis rurinchöga tulucunapis ismurmi segaypa asyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Saynölami gamcunapis runacuna ricayäshunalayquipä pï-maytapis ali-tupäyanqui. Sayno cayaptiquipis ishcay cära cayashgayqui y lutan rurayashgayquicunaga pasaypa pengacuypämi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Moisés guelgashganta yachasegcuna y fariseo runacuna! ¡Ishcay cära cayashgayquipitami juicio finalcho fiyupa laquicuyanquipä! Gamcunaga profëtacuna pamparäyashgan janancho nïchuncunata ruraycur adornaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nircurnami nicäyanqui: ‘Say wisan cawarga nogacuna manami profëtacunata wanusiyämansu cargan.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sayno nicarpis profëtacuna guelgayashganta mana cäsucurmi runacunata musyaycäsiyanqui say profëtacunata wanusegcunanöla gamcunapis caycäyashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Profëtacunata wanusishganno cananpis Tayta Diospa wilacognin captë wanusiyämay, ari! Unay profëtacunata wanuseg runacunata juzganan junag gamcunataga masmi juzgashunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Culebra casta runacuna! Tayta Diosninsi infiernuman gaycuyäshunayquipä cashganpita ¿imanöparä salvacuyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gamcunamanmi cachamushä wilacognëcunata y yachasegnëcunatapis. Sayno captinpis gamcunaga waquinta crucificaypa wanusiyanquipä, waquinta sinagogacunacho astayanquipä y waquintana marcan marcan gaticachäyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Abelta wanusishganpita-pasami Tayta Diosninsipa profëtancunata runacuna imaypis wanusiyargan Berequiaspa surin Zacariasta altarpa naupancho wanusishganyag. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Say wanuseg runacunatanömi canan wisan Israel runacunata Tayta Diosninsi juzgangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Saypita Jesús nergan: “¡Jerusalén runacuna! ¿Imanirtä Tayta Diosninsipa profëtancunata y cachamushgan wilacogcunata naupapita-pasa wanuycäsiyanqui? Chipshancunata maman shuntarcur oglacognöpis gamcunata asca cutimi shuntayta munargä. Sayno munaptëpis gamcunaga manami munayashcanquisu shuntanäta. ");
INSERT INTO qvhNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Saymi gamcunata Tayta Diosninsi manana sapäshuptiqui chiquishogniquicuna shamur marcayquitapis ushacäsiyangapä. Manami yapay ricayämanquipänasu: ‘¡Tayta Diosninsi cachamushgan runa caycarga shacalämuy, taytay!’ niyämashgayquiyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Templo patiupita yargurir Jesús aywacuycaptinmi discïpuluncuna niyargan: “¡Cuyaylapä jatusag rumicunawan templunsita sharcaycasiyashga, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sayno niyaptin Jesús nergan: “Cay lapan ricaycäyashgayqui cuyaylapä caycaptinpis chipyagmi juchusiyangapä. Manami ni juc rumilapis canan pergaraycashgannöga quëdangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olivos lömacho jamapagnömi discïpuluncuna Jesusta tapuyargan: “Nishgayquinöga ¿imaytä templo juchusish canga? Saynöpis cutimunayquipä y cay pasa ushacänanpäga ¿imatä puntata canga, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sayno tapuyaptinmi Jesús nergan: “Pipis lutanta mana criyisiyäshunayquipä shumag tantyacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ascagmi shayämonga: ‘Nogaga Cristumi cä’ niyashpan. Sayno nirmi asca runacunata engañayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","May-say nacioncunachöpis guërra captin y wanusinacuy captin ama mansacäyanquisu. Puntataga saycunalarämi canga. Sayno captinpis cay pasa manarämi ushacangaräsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Juc nacionwan juc nacionmi pelyayanga. Saynölami muchuypis terremötupis may-saycho cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sayno captinpis nacaycuna galaycunalanrämi saycunaga canga. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Say wisanmi nogata chasquicamagcunata pï-maypis chiquishpan prësu sariyangapä, nacasiyangapä y wanusiyangapäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sayno nacasiyaptinmi yäracaycäyämashganpita guepaman ascag cuticuyanga. Nircurnami guepaman mana cutegcunata chiquir autoridäcunaman apasiyanga castigash cayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Say wisanmi lutan yachasicogcuna Tayta Diosninsipa wilacuyninta wilacog-tucur runacunata lutanta criyisiyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","May-saychöpis runacuna chiquinacularmi cawayanga. Sayno cawarmi runacuna cuyanacuyanganasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sayno captinpis wanushganyag noga munashgäno cawagcunaga Tayta Diospa naupanman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tayta Diosninsipa wilacuyninta may-say nacioncunachöpis wilacusquiyaptinrämi noga cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tayta Diosninsipa profëtan Daniel guelgashgannölami Diosta mana cäsucog runa templo ruriman yaycongapä. (Cay guelgashgäta liyegcunaga shumag tantyacuyäsun.) ");
INSERT INTO qvhNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Say fiyu runa templuman yaycuptin Jerusalén marcapita y Judea provinciacho caycag waquin marcacunapitapis gueshpir aywacuyäsun. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wayi janancho cagcunapis jucla gueshpir aywacuyäsun. Imata jorgunanpäpis wayinman amana yaycuyäsunsu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chacrancho caycagcunapis jucla gueshpir aywacuyäsun. Ama cutiyäsunsu wayinman trucacunanpä mödanacunata jorgogpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sayno gueshpirmi pasaypa cuyapaypä nacayanga gueshyag warmicuna y iti wawayog warmicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tamya quilacho ni sábado jamay junagcho say gueshpinayqui junag mana cananpä Tayta Diosninsita manacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Say junagcunaga fiyupami runacuna nacayangapä. Cay pasata Tayta Diosninsi camashganpita-pasa manami imaypis sayjinanpaga runacuna nacayashgasu. Saynöpis yapayga mananami sayno nacaycuna cangapänasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Acrashgancunata cuyaparmi say nacaycunata Tayta Diosninsi päsasenga. Say nacay junagcunata mana päsasiptenga lapanpis wanurmi ushacäyanman. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Say junagcuna: ‘Tayta Dios cachamushgan Cristo caychömi wacchömi caycan’ niyäshuptiquipis ama criyiyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Saynöpis waquenga: ‘Tayta Dios cachamushgan Cristumi caycä’ o ‘Tayta Diosninsipa profëtanmi caycä’ nir lulacuyashpanmi puriyangapä. Runacunata criyisinan cashmi ima milagrucunatapis rurayanga. Asca runacunata saynöpa engañarpis Tayta Diosman yäracogcunataga manami engañayta camäpacuyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Saycuna manarä captinmi gamcunata wilaycä lutan yachasicogcunata mana chasquipäyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Pipis: ‘Tayta Dios cachamushgan Cristo sunyag jircachömi caycan’ niyäshuptiquipis ricag ama aywayaysu. ‘Washachömi pacaraycan’ niyäshuptiquipis ama criyiyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ciëlucho jucläpita jucläman elgucuy elagpita asicyagta lapan runacuna ricayashgannömi noga cutimuptëpis lapan runacuna ricayämangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wiscurcuna shuntacagta ricarmi musyansi wanush uywa saycho jitaraycashganta. Saynölami cay nishgäcuna päsaycagta ricar musyayanqui cutimunäpäna caycashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Cay pasacho fiyupa nacaycuna casquiptinrämi intipis y quilapis sacacurponga. Saynölami lapan goyllarcunapis shicwayämonga y ciëlupis sucsucyanga. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Saypitanami nogata ricayämanga pucutay janancho chipipiycar cutiycämogta. Sayno shamuycagta ricayämashpanmi may-saychöpis runacuna mansarir wagayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Say junag Tayta Diosninsi cornëtata fuerti tucasimuptinmi angilnëcunata cachamushä. Paycunami may-saypitapis nogaman yäracamagcunata shuntayämongapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Cay yachasishgäta shumag tantyacuyay. Tamya tiempo galaycuptin musyayanquimi jïgus jacha chinquimunanpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Saynölami say nishgä nacaycuna chämuptin gamcunapis musyayanquipä cutimunäpäna caycashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Canan cawaycag runacuna manarä wanuyaptinmi lapan say nishgäcuna cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ciëlupis y cay pasa ushacaptinpis noga nishgäcunaga lapanmi cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Imay junag imay höra cutimunäpä cashgantaga manami angilcunapis ni nogapis musyäsu. Saytaga Tayta Dioslami musyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé cawanan wisan diluvio elagpita cashgannömi nogapis elagpita cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noé cawanan wisanpis diluvio manarä captinmi runacunaga micur, upyar y majasacar caycäyargan. Sayno cawayargan arcaman Noé yaycushgan junagyagmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sayno caycäyaptinmi elagpita fiyupa tamyar cay pasaman yacu juntargan. Saynöpami arcaman mana yaycog lapan runacuna shengaypa wanur ushacäyargan. Saynölami runacuna mana musyashgan höra nogapis elagpita cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Cutimushgä junagmi ishcay runacuna chacrancho aruycagpita chasquicamag cagta pushacushä y mana chasquicamag cagtanami cacharishä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maraycho ishcay warmicuna agacuycagcunapita chasquicamag cagta pushacushä y mana chasquicamag cagtanami cacharishä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sayno caycaptenga gamcuna shuyacayämay puestucushla. Manami musyayanquisu imay höra cutimunäpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Pipis wayinta suwapänanpä cashganta musyarga mana punuypami wayinta täpanman. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Saynöla gamcunapis puestucushla caycäyay. Mana musyayashgayqui hörami elagpita noga cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Patronnin maypapis ilarga más yäracuypä cag ashmaynintami haciendancho lapantapis shumag ricananpä churan. Saymi say ashmayga mincaynincunatapis höralancho garasin. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Patronnin cutimur yäsishganno ali ruraycagta tariycorga: ‘Ali ashmaymi canqui’ nengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sayno nishpanmi patronnin say ashmaypa maquinman churanga lapan imaycantapis ricananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Mana yäracuypä cag ashmaymi isanga: ‘Patronnë manarämi cutimongaräsu’ nir ashmay mayinta magan y upyagcunawan micur upyar jitaräcun. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sayno caycaptinmi mana yarpashgan höra elagpita patronnin cutimonga. ");
INSERT INTO qvhNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Patronnin yäsishganta mana cäsucur lutanta ruraycagta tariycurmi patronnin mana cuyapaypa say ashmayta castigangapä. Ishcay cära runacunatawan juntumi Tayta Diosninsi mana cuyapaypa infiernuman payta gaycongapä. Saychömi fiyupa wagar quiruntapis uchongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Cutimuptin imano cananpä cashgantapis tantyasishpanmi Jesús nergan: “Chunca (10) jipashcunashi farolnincunata alistacurcur shuyacog aywayargan casaracog magta shamuptin paywan fiestaman aywayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Shuyacog aywarshi pisga cag jipashcuna aceitinta apayargan farolnincunaman yapayänanpä. Pisga cag jipashcunanashi isanga aceitinta apayargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Casarag magta mana chaptinshi shuyaraycäyashgalancho lapan punucäcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Sayno punucash caycäyaptinshi pulan pagas hörano gayacamushgan wiyacämorgan: ‘¡Casaracog magta shamuycannami!’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sayno gayacamushganta wiyarshi lapan jipashcuna jucla sharcuyargan payta chasquicuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Saychömi farolnincunaman yapayänanpä aceitita mana apag jipashcuna waquin cag jipashcunata niyargan: ‘Farolnë upicaycannami. Aceitiquita raquipaycayälämay farolnëcunaman winayänäpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sayno niyaptinmi aceiti apag jipashcuna niyargan: ‘Raquipäyaptëga manami aypäyämangasu quiquëcunapäpis. Saypa trucanga aceiti ranticogcunaman aywar jucla rantiyämuy.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aceiti ranteg aywayashganyagshi casarag magta chämorgan. Listu shuyaraycagcunatashi fiestaman yaycasergan. Fiestaman yaycurirnashi puncuta wichgacarcamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aceitita ranteg aywayashganpita cutirnashi tariyargan puncu wichgaraycagta. Sayshi gayacuyargan: ‘¡Puncuta quichapaycayälämay, taytay!’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sayno gayacuyaptinshi casaracog magta ruripita contestamorgan: ‘Gamcunataga manami reguësu. ¿Pirä cacuyanquipis?’ nir.” ");
INSERT INTO qvhNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sayno yacharcasir Jesús nergan: “¡Gamcunapis alistacushla caycäyay! Nogaga elagpitami cutimushä. Manami musyayanquisu imay junag ni imay höra cutimunäpä cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Saypitanami Jesús nergan: “Juc rïcu runashi juc nacionpa aywacur ashmaynincunata guellayninta cachapargan cutimushganyag say guellaywan aruyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Habilidänincuna imano cashgantapis shumag tantyaycurshi jucninta cachapargan pisga waranga (5,000) guellayta, jucninta ishcay waranga (2,000) guellayta y jucnintanashi cachapargan juc waranga (1,000) guellayta. Nircurshi carupa aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pisga waranga guellayta chasqueg cäga shumag negociuta rurarshi pisga waranga masta gänargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ishcay waranga guellayta chasqueg cagpis saynölashi shumag negociuta rurar ishcay waranga masta gänargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Juc waranga guellayta chasqueg cagshi isanga pañuëluwan shumag guepiycur pampaycunä. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Saypitanashi say ashmaycunapa patronnin cutimur puestupashgan guellaynincunata cuentata manargan aycata guellaynin wachashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sayno cuentata manaptinshi pisga waranga guellayta chasqueg cäga pisga waranga masta entregargan. Sayshi say ashmay nergan: ‘Pisga waranga guellayta cachapämashgayquiwan pisga waranga mastami gänashcä, taytay.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sayno niptinshi patronnin nergan: ‘Gamga ali ashmaymi canqui. Walcalapitapis shumag guellayta mirasishgayquipitami cananga más mandag canayquipä churashayqui. Sayno cashgayquipita cananga cushicur fiestata rurashun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Saynölashi chargan ishcay waranga guellayta chasqueg cagpis: ‘Taytay, ishcay waranga guellayta cachapämashgayquiwan ishcay waranga mastami gänashcä’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sayno niptinshi patronnin nergan: ‘Gampis ali arog ashmaymi canqui. Walcalapitapis shumag guellayta mirasishgayquipitami cananga más mandag canayquipä churashayqui. Sayno cashgayquipita cananga cushicur fiestata rurashun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Saynölashi juc waranga guellayta chasqueg ashmayninpis chaycur nergan: ‘Noga musyämi fiyu cashgayquita, taytay. Gamga mana murushgayquimanmi cosechag aywanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sayno fiyu cashgayquita musyarmi gamta mansacur guellayniquita pampaycorgä. Saymi gayasimaptiqui cashgalanta guellayniquita apamushcä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Sayno niptinshi patronnin nergan: ‘¡Gamga mana yäracuypä guela ashmaymi canqui! Mana murushgäpita cosechag cashgäta musyaycarga ¿imanirtä guellaynëta banculamanpis churargayquisu mirashtana cutimur shuntacunäpä?’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nircurnashi saycho caycag runacunata patrón nergan: ‘¡Guechuyay sararaycashgan guellaynëta! ¡Nircur goycuyay chunca (10) cuti más guellay miraseg cagta! ");
INSERT INTO qvhNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Guellayta puestupashgäta mirasegcunaga mastami chasquiyanga. Mana mirasegcunami isanga sararashgalantapis guechushga cayanga. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sayno captenga cay mana ali ashmayta sacayman garguyay. Saychömi fiyupa wagar quiruntapis uchongapä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lapan angilnëcunawan cutimurmi chipipiycag trönöman noga jamacushä lapan runacunata juzganäpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Say junäga may-say nacionpitami lapan runacunata angilnëcunawan shuntasimushä. Sayno shuntarcasimurnami raquishäpä uysha miseg uyshancunata cabracunapita raquishganno. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Saychömi mana chasquicamag runacunata raquishä isognë cagman y chasquicamag runacunatana derëchä cagman. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sayno raquircurnami derëchächo caycagcunata nishä: ‘Gamcunataga Tayta Dios segaypami cuyayäshunqui. Naupäman shayämuy lapan puestushgäcunata chasquiyänayquipä. Saytaga Tayta Diosninsi gamcunapä puestush cay pasata manarä camarmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gamcunami micanaycar puriptë pachä garayämashcanqui. Saynöpis yacunaycar puriptë upunäpä yacuta goyämashcanqui. Saynölami wayiquiman chämuptëpis posädasiyämashcanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mödanaynag captëpis gamcunami jaticunäpä mödanata puestupäyämashcanqui. Gueshyaptëpis gamcunami jampiyämashcanqui. Carcilcho captëpis gamcunami watucayämashcanqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sayno niptëmi say runacuna tapuyämangapä: ‘Taytay, ¿imaytä micanar puriycagta garayashcä? Saynöpis ¿imaytä yacunar puriycagta upunayquipä yacuta goyashcä? ");
INSERT INTO qvhNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Saynöpis ¿imaytä wayëman chämushcanqui posädasiyänäpä? Saynöpis ¿imaytä mödanaynag caycaptiqui jaticunayquipä mödanata puestupäyashcä? ");
INSERT INTO qvhNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Saynöpis ¿imaytä gueshyaptiqui o carcilcho captiqui watucag shayämushcä?’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sayno nimaptinmi nishä: ‘Yäracamagcunata mayganpis yanapag cagcuna nogata yanapämagnömi cayashcanqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nircurmi isognëcho caycag runacunata nishä: ‘¡Gamcunataga Satanaspä y supaycunapä camarish caycag infiernumanmi canan gaycushayqui imayyagpis saycho rupar nacayänayquipä! ");
INSERT INTO qvhNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gamcunaga micanaycar puriptëpis manami garayämashcanquisu. Saynöla yacunaycar puriptëpis manami upunäpä yacuta goyämashcanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Saynölami wayiquiman chämuptëpis posädasiyämashcanquisu. Mödanaynag caycaptëpis manami jaticunäpä mödanata puestupäyämashcanquisu. Gueshyaptëpis carcilcho wichgaraptëpis manami watucayämashcanquisu.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Sayno niptëmi isognëcho cag runacunapis tapuyämanga: ‘¿Imaytä gam micanaycagta, yacunaycagta, wayëman chaycämogta, mödanaynagta, gueshyaycagta, carcilcho wichgaraycagta ricaycar yanapäyashcäsu, taytay?’ ");
INSERT INTO qvhNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Saymi paycunata nishä: ‘Nacaycho cagcunata mana cuyapar nogatami cuyapäyämashcanquisu.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sayno wilaparcushpan Jesús nergan: “Say mana cuyapäcog runacunaga infiernuchömi imayyagpis nacayangapä. Tayta Dios munashganno yanapäcog runacunami isanga imayyagpis gloriacho cawayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sayno yacharcasirmi discïpuluncunata Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Musyayashgayquinöpis Pascua galaycunanpä ishcay junaglanami pishiycan. Saychömi runacuna nogata crucificamangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Saypita mandag cüracuna y Israel mayor runacuna shuntacäyargan más mandag cüra Caifaspa wayinman. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Saychömi wilanacuyargan runacunata mana musyasiylapa Jesusta sarircur wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Saymi wilanacuyargan: “Fiestachöga ama sarishunsu. Fiestacho sarishgaga contransimi runacuna sharcuyangapä” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Saypitanami Betania marcaman Jesús aywargan lepröso niyashgan Simonpa wayinman. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Saymanmi juc warmi chargan “alabastro” nishgan rumipita rurashgan botëllanwan perfümin aptash. Say perfümega selläma chaninmi cargan. Mësacho Jesús caycaptinmi say warmega paypa umanman say perfümita winapargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Discïpuluncuna sayta ricar rabiashpan niyargan: “¿Imapätä waläla jichar perdisish say perfümita? ");
INSERT INTO qvhNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sayno perdisinanpa trucanga nogansita goycamashwan cargan ali chanincho ranticuycur muchogcunata yanapänansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Say nishgancunata wiyarmi Jesús nergan: “Cay warmi alitami ruraycan. Sayno caycaptenga ¿imanirtä payta jamuraycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Muchogcunaga yanapäyänayquipä imaypis caycäyangami. Nogami isanga gamcunawan cashäpänasu. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pampash canäpämi cay warmega perfümita winapämar alistaycäman. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Perfümita cay warmi winapämashgantaga may-saychöpis musyayangami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Saypitanami Jesuspa discïpulun Judas Iscariote aywargan mandag cüracunaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Chaycurmi paycunata nergan: “Runacuna mana cashgancho Jesusta prësu sariyänayquipä wilaptë ¿aycatatä pägayämanquipä?” nishpan. Sayno niptinmi: “Nogacuna pägayäshayqui quimsa chunca (30) yurag guellaytami” nishpan guellayta yupapasquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sayno päguta chasquircurmi Judas yarpachacorgan imay höra wilacog cutinanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Levadüraynag Tantata Micunan fiesta galaycunan junagmi discïpuluncuna Jesusta tapuyargan: “¿Maychötä puestucayämushä Pascua merendata micunansipä, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sayno niyaptinmi Jesús nergan: “Marcaman aywar juc runata niyanqui: ‘Wanunanpä höran cercana captinshi discïpuluncunawan Pascua merendata wayiquicho micuyta munaycan.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesús yäsishgannöla aywarmi discïpuluncunaga Pascua merendata say wayicho puestucuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pasa sacaycaptinnami chunca ishcay (12) acrashgan cag discïpuluncunawan Jesús mësa cagman jamacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Saymi micuycäyashgancho Jesús nergan: “Gamcunapita jucniquimi chiquimagnëcunapa maquinman entregamangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Niptin laquicuyashpan jucnin jucnin Jesusta tapuyargan: “¿Nogasurä caycä, taytay?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Saymi Jesús nergan: “Plätucho nogawan juntu tantata ushmaseg cagmi chiquimagnëcunapa maquinman entregamangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tayta Diospa palabrancho guelgaraycashgannöla fiyupa nacar wanunäpämi caycä. Nogata entregamag runami isanga juicio finalcho fiyupa laquicongapä. Payga ama yurinmanpissu cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sayno niptinmi contran sharcog Judasga Jesusta taporgan: “¿Nogasurä caycä, taytay?” Niptin Jesús nergan: “Quiquiquimi nishcanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Saypitanami tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata ayporgan: “Cay tantata lapayqui micuyay. Cay tantaga cuerpömi” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Saynölami vïnuyog väsuta aptarcur Tayta Diosta manacur agradëcicorgan. Nircurnami discïpuluncunata macyargan: “Lapayqui cay vïnuta upuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay vïnoga yawarnëmi. Yawarnëta jichar wanushgä hörami Tayta Dios mushog conträtuta ruranga pï-maytapis chasquicamagcunata perdonananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yapayga manami vïnuta upushänasu Tayta Diospa naupancho gamcunawan upushgansiyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Salmucunata cantasquirnami discïpuluncunawan Jesús aywayargan Olivos lömaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olivos lömaman chaycurmi Jesús nergan: “Canan sacay lapayqui cachariycamarmi gueshpir aywacuyanquipä. Tayta Diosninsipa palabranchöpis caynömi nican: ‘Uysha misegta wanuycasiptë uyshancuna mashtacarmi aywacuyanga.’ ");
INSERT INTO qvhNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sayno captinpis wanushgäpita cawarircamur gamcunapita más puntatami Galileaman aywashä saycho tincunansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sayno niptinmi Pedro nergan: “Waquin cag cachariyäshuptiquipis nogaga manami cachashayquipäsu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sayno niptinmi Pedruta Jesús nergan: “Canan sacay cacash manarä cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sayno niptinmi Pedro nergan: “¡Ishcansita wanusimänansi captinpis manami ñëgashayquipäsu, taytay!” Waquin cag discïpuluncunapis saynölami niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Olivos lömacho caycag Getsemaní huertaman discïpuluncunawan chaycurmi Jesús nergan: “Tayta Diosta manacamushgäyag gamcuna caylacho jamaraycäyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nircur Pedruta y Zebedeupa surincuna Santiagutawan Juanta más washaläman pushargan. Saychömi fiyupa laquicur nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Wanunayparämi laquicuy sarimash. Gamcunapis Tayta Diosta manacushpayqui caylacho shuyaraycäyämay.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sayno nircurmi más washaläman aywargan Tayta Diosta manacunanpä. Saychömi gongurpacuycorgan urcunpis pampaman töpashganyag. Sayno gongurpacuycurmi Tayta Diosta manacorgan: “Papá, nacanäpä caycashgäpita salvaycalämay. Isanga noga munashgänöga ama casunsu, sinöga gam munashgayquino cayculäsun.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sayno manacushganpita cutishpanmi tarergan quimsan discïpuluncuna punucash caycagta. Saymi Pedruta nergan: “Tayta Diosta manacushgäyag ¿manacu juc höralapis ricchayta camäpacuyashcanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Punushgayquipita ricchayayna. Diosta manacuyay Satanasta mana cäsupäyänayquipä. Cäsupayta mana munarpis Tayta Diosta mana manacorga cäsupäyanquipämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sayno nircurmi yapay cutiycur Tayta Diosta manacorgan: “Runacuna nacasimar wanusimänanpä captinpis gam munashgayquino cayculäsun, papá.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tayta Diosta manacushganpita yapay cutiycur tarergan quimsan discïpuluncuna pasaypa punucash caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sayno caycagta ricaycurpis yapay cutiycurmi Tayta Diosta manacorgan puntata manacushgannöla. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Saypitanami yapay cutiycur paycunata nergan: “¿Cananpis gamcuna jinalacu punuycäyanqui? ¡Ricchayayna! Tayta Diospita shamush captëpis höra chämushganami jusasapa runacunapa maquinman nogata entregayämänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Sharcuyayna! Chiquimagnëcunapa maquinman entregamänanpä cag runa shamuycannami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Discïpuluncunawan Jesús parlaycaptinmi Judas Iscariote chargan asca runacunata pushash. Judasga Jesuspa discïpulunmi cargan. Say runacunami chäyargan espädancuna y garrotincuna aptash. Jesusta prësu sariyänanpä say runacunata cachargan mandag cüracuna y Israel mayor runacunami. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sayman manarä charmi Judasga pushashgan runacunata yäsergan: “Mayganpis musashgä cagmi Jesusga caycan. Payta prësu sariyanqui” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Saymi chaycur Judasga Jesusta saludashpan musaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sayno saludaptinmi Jesús nergan: “Judas, ¿caymanpis shamuycunquiräcu?” Sayno niptinmi runacunaga Jesusta jucla prësu sariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Prësu sariyaptinmi espädanta jorgurishpan juc discïpulun más mandag cürapa ashmayninpa rinrinta waluriycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sayno ruraptinmi Jesús nergan: “Espädayquita cutisiy churaräcunanman. Pipis espädawan runa mayinta wanuseg cäga espädawanmi wanusish canga. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Gam manacu musyanqui Tayta Diosta manacuptëga washämänanpä chunca ishcay (12) tröpa angilcunata cachamunanpä cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Washämänanpä manacuptëga ¿imanöparä cumplicanga runacuna wanusiyämänanpä Tayta Diospa palabrancho guelgaraycashganpis?” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nircurna say runacunata Jesús nergan: “¿Imanirtä suwa captënöpis gamcuna shayämushcanqui espädayquicunawan y garrotiquiwanpis prësu sariyämänayquipä? Nogaga waran waranmi templo patiucho yachasergä. ¿Imanirtä saychöga prësu sariyämargayquisu? ");
INSERT INTO qvhNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sayno captinpis prësu sariyämänayquipä gamcuna shayämuptiquimi Tayta Diosninsipa profëtancuna guelgayashgan cumplicaycan.” Jesusta prësu sariyaptinnami discïpuluncuna gueshpir aywacuyargan japalanta cachaycur. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta prësu sarircurmi apayargan más mandag cüra Caifaspa wayinman. Saychömi Moisés guelgashganta yachasegcuna y Israel mayor runacunapis shuntacash caycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesusta sayman apayaptinmi caru guepalanta Pedro gatirargan. Caifaspa wayinman chaycur paypis yaycorgan patio rurinyag. Sayman yaycurir templo täpag wardiacunawan jamaraycargan ima päsashgantapis ricananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mandag cüracunawan autoridäcunanaga imanöpapis Jesusta wanusiyänantami munayargan. Saymi ashiyargan pilapis Jesús mana parlacushganta jitapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sayno ashiptin ascagmi Jesús mana parlacushganta jitapäyargan. Sayno jitapäyaptinpis manami ima jusantapis tariyargansu wanusish cananpä. Saypita ishcay runacuna niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Cay runaga nergan templuta juchurasir quimsa junaglata yapay sharcasinanpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Saymi más mandag cüra Jesusta taporgan: “¿Manacu imatapis ninqui sayno jitapäshuptiqui? ¿Imanirtä contrayqui sayno parlaycäyan?” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sayno tapuptinpis manami imatapis Jesús parlacorgansu. Saymi más mandag cüra nergan: “Lapanpä munayyog Tayta Dios ricaycämashgami gamta tapö: ¿Rasunpacu Tayta Dios cachamushgan Cristo caycanqui? Saynöpis ¿rasunpacu Diospa surin canqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sayno tapuptinmi Jesús nergan: “Au, nishgayquino rasunpaypami caycä. Saymi nogata ricayämanquipä lapanpä munayyog Tayta Diospa derëcha cag naupancho jamaraycagta. Saynöpis pucutay janancho shamuycagtami ricayämanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sayno niptin más mandag cüra fiyupa rabiashpan sotänantapis rachir ushar nergan: “¡Cay runaga Dios-tucuycanmi! Sayno nicaptenga ¿imapänatä más testïgutapis ashishun? Gamcuna wiyayashcanquimi Dios-tucur parlaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sayno captenga ¿imaniyanquitä?” Sayno niptinmi saycho caycag runacuna niyargan: “¡Jusayogmi caycan! ¡Wanusish casun!” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sayno nirmi Jesuspa cäranman togapäyargan y cutayargan. Waquinnami lagyar ushayargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Tayta Diosninsi cachamushgan Cristo carga mä niyämay pï magashushgayquitapis” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sayyäga Pedro jamaraycargan sawan rurinchömi. Saycho jamaraycagta ricarmi juc ashmay jipash nergan: “Gamta ricashcä Galileapita cag Jesuswan puriycagtami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sayno niptinmi lapan runacuna wiyaycäyaptin Pedro nergan: “Manami musyäsu imapita parlapaycämashgayquitapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sayno nircurmi Pedroga puncu naupanman aywargan. Saychöpis juc jipash payta ricaycur runacunata nergan: “Nogapis cay runataga ricargä Nazaretpita cag Jesuswan puriycagtami.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sayno niptin Pedro jurashpan nergan: “¡Nogaga manami reguësu say runataga!” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Saypita maylantana saycho caycag runacuna Pedruman aywaycur niyargan: “¡Gamga rasunpaypami paywan pureg canqui! Parlacuyniquipis pay-niragmi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sayno niyaptinmi Pedro jurashpan nergan: “¡Say runaga pishi cacunpis! ¡Paytaga manami reguësu!” Sayno nicaptinmi cacash cantarcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sayno cantarcuptinmi Pedro jinan höra yarparcorgan Jesús cayno nishganta: “Manarä cacash cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipä.” Say nishganta yarparcurmi Pedro wagtaman yargusquir fiyupa laquicushpan maquinta chogpacurcur wagargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Saypita pasa waraycaptinnami lapan mandag cüracuna y Israel mayor runacuna shuntacaycur wilanacuyargan Jesusta imanöpapis wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wilanacurcurnami liyarcur Jesusta apasiyargan Israel nacionpa mandagnin Pilätuman. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusta wanusinanpä Israel mayor runacuna wilanacuyashganta musyaycurmi Judas Iscariote fiyupa laquicorgan. Saymi chasquishgan quimsa chunca (30) yurag guellayta cutisergan mandag cüracunaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cutisirmi paycunata nergan: “Jusaynag runata maquiquiman entregar jusalicushcämi, taytacuna.” Sayno niptinmi niyargan: “¡Imanöpis cacuy! ¡Nogacunataga manami imapis gocayämansu!” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sayno niyaptinmi Judasga chasquishgan guellayta templuman jitariycur aywacorgan. Nircurnami jurcacusquergan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sauraga mandag cüracuna say guellayta shuntarcur niyargan: “Cay guellayga runapa yawarninpa chaninmi. Sayno caycaptenga manami ofrendacunaman talusishwansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sayno nirmi wilanacuyargan say guellaywan manca rurag runapa chacranta rantiyänanpä. Say chacrata rantiyargan jäpa runacuna wanuptin sayman pampayänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jesuspa yawarnin chanin captinmi say chacrata runacuna jutinta churapäyargan “Yawar Pampa” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mandag cüracuna chacrata sayno rantiyaptinmi Tayta Diosninsipa unay profëtan Jeremías guelgashgan cumplicargan. Say guelgashganga caynömi nican: “Paypa chanin ayca cananpäpis Israel runacuna niyashgannölami quimsa chunca (30) guellayta chasquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Say guellaywanmi Tayta Dios nimashgannöla manca rurag runapa chacranta rantiyargan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Israel nacionpa mandagnin Pilätuman Jesusta prësu chäsiyaptinmi pay Jesusta taporgan: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” nir. Sayno tapuptinmi Jesús nergan: “Gam nishgayquinölami rasunpaypa caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Saycho mandag cüracuna y Israel mayor runacuna imaycata jitapäyaptinpis Jesús manami imatapis parlacorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Saymi Pilato taporgan: “¿Manacu imatapis ninqui contrayqui imaycata jitapaycäyäshuptiquipis?” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sayno niptinpis Jesusga manami imatapis parlacorgansu. Saymi Pilätoga imaniytapis camäpacorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cada watami Pascuacho Pilato cachareg juc prësuta runacuna manacuyashgan cagta. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saychömi prësu wichgaraycargan pï-maypitapis reguish Barrabás jutiyog fiyu runa. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Israel runacunapa autoridänincuna Jesusta chiquir payman prësu apayashganta musyarmi saycho shuntacash caycag runacunata Pilato taporgan: “¿Maygan prësutatä cacharinäta munayanqui? ¿Barrabastacu? ¿O Cristo nishgan Jesustacu?” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato saycho juzgar jamaraycaptinmi warmin wilacasergan: “Say runaga jusaynagmi. Ama imatapis ruraysu paypa contran. Canan pagas pasaypa mana alicunatami sueñupäcushcä prësu sariyashganpita.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sayno wilacasiptin Jesusta Pilato cachariyta munaptinpis saycho caycag mandag cüracuna y Israel mayor runacunapis runacunata shimita goyargan Barrabasta cacharir Jesusta wanusinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Saymi: “¿Maygantatä cacharishä?” nir Pilato tapuptin runacuna: “Barrabasta cachariyga” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sayno niptin Pilato nergan: “Sayno captenga prësu apayämushgayqui Cristo nishgan Jesustaga ¿imatatä rurashä?” Sayno niptinmi lapan runacuna: “¡Crucificash casun!” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Saymi Pilato nergan: “Crucificash cananpäga ¿imatatä jusalicush?” Sayno niptin runacuna masrä niyargan: “¡Crucificasiy!” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Runacuna timpuypa timpur gayaraptinmi ima ruraytapis Pilato camäpacorgansu. Saymi yacuta apaycasimur lapanpa naupancho maquinta maylacushpan nergan: “Nogaga manami jusayogsu cä cay jusaynag runata wanusiyashgayquipita. ¡Gamcuna munayashgayquita ruracuyay!” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sayno niptin runacuna niyargan: “Nogacuna y wamräcunami cay runa wanushganpita jusayog cayäshä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Runacuna sayno niyaptinmi Barrabasta Pilato cacharergan. Nircurna Jesusta astarcasir entregaycorgan crucificash cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Saypita soldäducuna Jesusta apayargan palacio patiuman. Saymanmi lapan soldäducuna juntapäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nircurmi payta asipäyänan cash mödananta logtiparir aylupäyargan rey jaticunan puca-chiclu cäpata ");
INSERT INTO qvhNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Saynöpis cashapita awash corönata umanman jatipäyargan. Derëcha cag maquinmannami värata aptapäyargan. Nircurmi puntanman gongurpacuycur asipar niyargan: “¡Alabash casun Israel runacunapa mandagnin rey!” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Saynöpis togapar ushayargan. Aptaraycashgan värata guechurir trucapänacuypa saywan umacho wiruyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sayno asiparcurmi aylupashgan puca cäpata logtiparcur quiquinpa mödanantana Jesusta jatipäyargan. Nircurmi crucificayänanpä apayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Crucificayänanpä apaycarmi tincuyargan Cirene marcapita Simón runawan. Paytami Jesús apaycashgan cruzta umrusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nircurnami Jesusta chäsiyargan Gólgota nishganman. Gólgota ninanga cargan “Calavëra” ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Saychömi vïnuta talusergan ayag jachawan Jesusta upusinanpä. Sayno upusiyta munayaptinpis Jesús yawarcur manami upuyta munargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nircurnami Jesusta crucificayargan. Crucificarcurnami Jesuspa mödananpä soldäducuna suertita jitayargan mayganpis gänag cag apacunanpä. Saynöpami Tayta Diosninsipa profëtan cayno guelgashgan cumplergan: “Quiquinpura raquipänacuyänanpämi mödanäpä suertita jitayargan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Soldäducunanami saycho täpar quëdacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Saypitanami juc tablaman letrëruta guelgarcur cruzpa puntanman clävayargan. Say letrëruchömi guelgaraycargan: “Cay runaga Israel runacunapa mandagnin reymi” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesús crucificaraycashgan naupanmanmi ishcay suwa runacunatapis crucificayargan, jucnin cagta derëcha cag naupanman y jucagtana isog cag naupanman. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cruzcho caycashganta ricarmi saypa päsag runacuna Jesusta asipäyargan umanta awishpan: ");
INSERT INTO qvhNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Templutapis juchurcasir quimsa junaglata sharcasinayquipä cashganta nicarga mä salvacuy, ari. Tayta Diosninsi cachamushgan Cristo rasunpaypa carga ¿imanirtä cruzpita urämunquisu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Saynöpis mandag cüracuna, Moisés guelgashganta yachasegcuna, fariseo runacuna y Israel mayor runacunapis Jesusta asipäyashpan niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Waquinta salvarpis ¿imanirtä quiquenga salvacuyta camäpacunsu? Israel runacunapa mandagnin rey carga mä cruzpita urämusun nogansipis criyinansipä. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‘Tayta Diosmanmi yäracö’ nimargansichä. Saynöpis: ‘Tayta Diospa surinmi cä’ nimargansichä. Rasunpaypa surin captenga cuyapashpan Tayta Diosninsi maynami cruzpita jorgunman cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Saynölami naupancho crucificaraycag suwa runacunapis payta ashliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pulan junag caycaptinmi pasa sacacäcorgan malway intiyag. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Malway inti caycaptinmi Jesús fuertipa nergan: “Elí, Elí, ¿lama sabactani?” Say ninanga caycan: “Diosnë, Diosnë ¿imanirtä cachariycamashcanqui?” ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sayno nishganta wiyarmi saycho caycag runacuna waquin niyargan: “Tayta Diosninsipa profëtan Eliastami gayacuycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sayno niptin juc runa gueru puntanman esponjata watarcur pochgog vïnuman ushmasergan. Nircurna Jesusta shogusiyta munargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shiminman churapaptinmi runacuna niyargan: “Ama shogusiysu. Canan ricashun mä cruzpita jorgunanpä Elías shamunäcush o manacush.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Saypitanami yapay fuertipa gapararcur Jesús päsarporgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesús wanushgan hörami templo rurincho saparag racta cortïna rachicäcorgan janapita urayag. Saymi pasa fiyupa sucsucyaptin gagacunapis rachicäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Saypita Jesucristo cawarimuptinnami Tayta Dios munashganno cawag runacunapis panteoncho pamparaycashganpita ascag cawariyämorgan. Jerusalén marcaman yaycuyaptinnami asca runacuna paycunata ricayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesusta täpaycag capitán y soldäduncunapis pasa sucsucyaycagta mayar saynöla lapan päsashgancunatapis ricar fiyupa mansacäyargan. Saymi niyargan: “¡Rasunpaypami cay runaga Diospa surin cash!” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Saychömi asca warmicuna carulapita ricaraycäyargan. Say warmicunami Galileapita-pasa Jesusta yanapar paywan aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paycunawanmi caycargan María Magdalena, Santiagupa y Josëpa maman María y Zebedeupa warminpis. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pasa sacaycaptinnami Pilato cagman chargan Arimateapita cag José. Payga rïcumi cargan. Saynöpis Jesucristuman yäracog runami cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato cagman aywaycurmi manacorgan: “Jesuspa ayanta cachapaycalämay pampag apanäpä” nir. Sayno manacuptinmi Pilato soldäducunata nergan Jesuspa ayanta cachapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sayno cachapasquiyaptinnami lïnupita rurash fïnu säbanaswan wancorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nircurnami gagacho sayrä uchcusish sepultüraman Jesusta pampargan. Say sepultürataga quiquin pampacunanpämi uchcusish cargan. Saypitanami jatuncaray rumiwan sepultürapa puncunta sapaycur aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pay aywacuptinpis María Magdalena y jucag Mariapis Jesuspa sepultüran naupanchömi jamaraycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Jesús wanushganpita waraynin sábado jamay junagnami mandag cüracuna y fariseo runacunapis Pilato cagman aywaycur niyargan: “Taytay, say lulacog runa: ‘Wanushgäpita quimsa junagtami cawarimushä’ nishgantami yarparcuyashcä. ");
INSERT INTO qvhNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Saymi shayämushcä gamta manacog, taytay. Soldäduyquicunawan sepultürata quimsa junagyag täpaycasilay. Mana täpasiptiquega sacaypa shamur discïpuluncuna Jesuspa ayanta suwayangapämi. Nircurnami runacunata criyisiyanga: ‘Wanushganpita cawarimushganami’ nir. Sayno lulacuyaptenga masrämi runacuna criyiyanga Jesús ‘Cawarimushämi’ nishgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sayno niyaptinmi Pilato nergan: “Soldäducunata churayämuy täpayämunanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sayno niptinmi aywaycur sepultüra saparaycashgan rumipa juc cuchunta cërawan lagayargan pipis quichaptin imaptenga musyacänanpä. Nircurnami soldäducunata saycho täpayänanpä cachaycur cuticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sábado jamay junag jamaparcurnami domingo tuta saca sacala María Magdalenawan jucnin María aywayargan Jesuspa ayanman perfümita winapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sayno aywaycäyaptinmi Tayta Diosninsi cachamushgan ángil ciëlupita urämuptin pasa fiyupa sucsucyargan. Jesús pamparaycashgan sepultüraman chaycurmi saparag rumita witircasir jananman jamacuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Say ángil elgucuynörämi asicyargan. Mödananpis rashtano yuragmi cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Angilta ricaycurmi soldäducunaga segaypa watpash ricacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Warmicuna chäyaptinnami ángil nergan: “Ama mansayämaysu. Musyämi crucificaypa wanusiyashgan Jesusta ricag shayämushgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mananami caychönasu caycan. Manarä wanur niyäshushgayquinölami cawarimush. Mayman sutaycuyashgantapis masqui ricayay. Mananami cannasu.” ");
INSERT INTO qvhNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nircurnami say warmicunata nergan: “Cananga aywar discïpuluncunata wilayay Jesús cawarimushganta. Saynöpis wilayanqui Galileaman aywar saycho Jesuswan tincuyänanpä cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ángil sayno niptinmi warmicunaga mansacash caycäyashgancho fiyupa cushicuyashpan Jesuspa discïpuluncunata wilag apurä aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sayno apurä aywaycäyaptinmi paycunata Jesús yuriparcur saludargan. Saymi gongurpacuycur chaquinta macalacurcur adorayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Saymi Jesús nergan: “Ama mansayämaysu. Discïpulöcunata wilayanqui Galileaman jucla aywayänanpä. Saychönami paycunawan tincushäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmicuna cuticuyaptinmi sepultürata täpag soldäducunapis Jerusalenman aywar mandag cüracunata wilayargan lapan ima päsashgancunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wilayaptinmi mandag cüracunaga Israel mayor runacunawan wilanacusquir soldäducunata asca guellayta pägayargan cayno niyashpan: ");
INSERT INTO qvhNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","14","“Jesuspa ayan elagashganta Pilato musyaptenga nogacunami paywan parlayäshä imatapis gamcunata mana jitapäyäshunayquipä. Gamcunanami runacunata niyanqui: ‘Punucasquiyashgäyagmi Jesuspa discïpuluncuna sacaypa shamuycur ayanta suwar apacuyash.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Saymi guellayta chasquircur cüracuna niyashgannöla soldäducunaga aywayargan runacunata wilayänanpä. Sayno wilacuyashganpitami cananyagpis Israel runacunaga mana criyiyansu Jesús cawarimushganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesuspa chunca juc (11) acrashgan discïpuluncunanami Galilea provinciaman chaycur aywayargan mayninchöpis tincuyänanpä Jesús nishgan jircaman. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Saychömi Jesuswan tincur payta adorayargan. Payta ricaycarpis waquenga manami criyiyarganräsu cawarimushganta. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naupanman aywaycurmi discïpuluncunata Jesús nergan: “Cay pasachöpis y gloriachöpis lapanpä munayyog canäpämi Tayta Dios churamash. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Saymi gamcunata cachä may-say nacionpapis aywar discïpulö cayänanpä pï-maytapis yachasiyänayquipä. Chasquicamagcunataga bautizayanqui Taytäpa jutincho, nogapa jutëcho y Santu Espiritupa jutincho. ");
INSERT INTO qvhNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Saynöpis paycunata yachasiyanqui lapan nishgäcunata cäsucuyänanpä. Cay pasa ushacaptinpis nogaga gamcunawanmi imaypis caycäshä.” Amén.");
INSERT INTO qvhNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cay libruchömi guelgaraycan Tayta Diospa surin Jesucristupa ali wilacuynin. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jesucristuta runacuna chasquicuyänanpämi puntata Juan Bautista wilacur purergan. Juan Bautista manarä yuriptinmi Tayta Diosninsipa profëtan Isaías paypita cayno guelgargan: “Wilacognëtami cachashä runacunata puestucasinanpä. Saynöpami puestucush cayanga shamuptë chasquicayämänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sunyag jircachömi juc runa gayacuypa wilaconga: ‘Mandag runa shamuptin chasquicunayquipä nänita pisar puestucuyashgayquino jusalicuycunata cacharir puestucuyay Tayta Diosninsi shamuptin chasquicuyänayquipä.’ ” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Isaías unay guelgashgannölami sunyag jircacho Juan Bautista puriptin Judea provinciapita y Jerusalenpita asca runacuna pay cashgan cagman aywayargan wilacushganta wiyayänanpä. Chäyaptinmi paycunata nergan: “Tayta Diosninsi perdonayäshunayquipä jusalicuyashgayquita cacharir bautizacuyay.” Juan Bautista wilacushganta chasquicurmi runacuna tantyacuyargan jusayog cayashganta. Saymi Tayta Diosta perdonta manacuyaptin Jordán mayucho paycunata Juan bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan Bautistapa mödanan cargan camëllupa milwanpita awashmi. Wachcunpis cargan camëllo garapita rurashmi. Chucluscunata y tinyagpa mishquinta micularmi pay purergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan Bautista wilacorgan: “Chämonganami nogapita más munayyog cag runa. Nogaga manami payno munayyogsu cä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nogaga yaculawanmi gamcunata bautizä. Paymi isanga Santu Espirituwan bautizayäshunquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Saypitanami Galilea provinciacho cag Nazaret marcapita Jesús chargan Juan bautizaycashgan cagman. Chaycuptinmi paytapis Jordán mayucho Juan bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yacupita sharcurcurmi Jesús ricargan ciëlo quichacascamuptin Santu Espíritu palomano payman uraycämogta. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Saymi ciëlupita wiyacämorgan Tayta Dios cayno nimushgan: “Gamga cuyay surëmi canqui. Noga munashgäno lapanta cumpliptiquimi cushish caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Saypitanami Santu Espíritu Jesusta pushargan sunyag jircaman. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Say jircachömi munti uywacuna caycäyashgancho chuscu chunca (40) junag Jesús goyargan Tayta Diosta manacushpan. Saycho caycaptinmi Satanás jusalicasiyta munargan. Saypitami angilcunapis sayman chäyargan Jesusta yanapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Saypitanami Galilea provinciaman Jesús aywargan Tayta Diosninsipa wilacuyninta wilacunanpä. Say wisanga Juan Bautistata Herodes maynami carcilcho wichgaraycäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Galilea provinciacho wilacurmi Jesús nergan: “Tayta Diosninsipa maquincho ali cawanapä cag tiempo chämushganami. Sayno captenga wilacushgäta chasquicuyashpayqui jusalicuycunata cacharir Tayta Diosninsi munashgannöna cawayay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saypita Galilea gocha cuchunpa aywaycashganchömi Jesús ricargan ishcay runacuna redninta yacuman mashtaycäyagta. Paycunami cayargan Simonwan wauguin Andrés. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paycunatami Jesús nergan: “Discïpulö cayänayquipä nogawan aywashun. Gamcunata yachasishayqui pescäduta sariyänayquipa trucanga runacunatana Tayta Diosninsipa wilacuyninta wilapäyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sayno niptinmi redninta cachariycuyashpan Jesuswan aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Saypita más wacläpa aywaycäyashganchönami ricargan Santiagutawan Juanta. Paycunaga cayargan Zebedeupa surincunami. Büquinchömi paycunaga rednincunata shilpaycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Saymi paycunatapis Jesús nergan: “Discïpulö cayänayquipä nogawan aywashun.” Sayno niptinmi paycunapis Jesuswan aywayargan taytan Zebedeuta y mincaynincunata büquincho cachaycur. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Saypitanami discïpuluncunawan Jesús chäyargan Capernaum marcaman. Sábado jamay junag captinmi sinagogaman yaycorgan runacunata yachasinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Payga manami Moisés guelgashgan leycunata yachasegnösu yachasergan, sinöga paycunapita más alimi yachasergan. Sayno yachasiptinmi runacuna fiyupa cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Say sinagogachömi caycargan supay löcuyäsishgan runa. Jesusta ricarmi say runacho caycag supay gaparargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¡Nazaret marcapita cag Jesús! ¿Imatatä munanqui nogacunawan? ¿Nogacunata gargayämänayquipäcu shamushcanqui? ¡Noga musyämi Dios cachamushgan Cristo cashgayquita!” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sayno niptin Jesús olgutupargan say supayta: “¡Upälala cay runapita jucla yarguy!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sayno niptinmi say runata chapiriycur supay fiyupa gaparar aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sayta ricaycurmi lapan runacuna cushicuyashpan jucninpis jucninpis cayno parlayargan: “¡Imajinanparä munayyog caycan supaycuna payta cäsucuyänanpäga! ¡Saynöpis manami pipis yachasinsu pay yachasishgannöga!” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Supayta gargushganta musyarmi intëru Galilea provinciacho runacuna parlayargan Jesús munayyog cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Say sinagogapita Jesús yargurnami Simonpa y Andrespa wayinman aywargan Santiaguta y Juanta pushacurcur. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sayman chäyänanpäga Simonpa suedran fiebriwan ansa jitaraycargan. Saymi saycho caycag runacuna Jesusta wilayargan say chacwan gueshyaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sayno wilayaptinmi gueshyag jitaraycashganman Jesús yaycorgan. Nircur maquipita sarircur sharcasiptinmi jinan höra aliyasquergan. Chacwanga aliyarcurnami micuyta paycunata garargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Pasa sacaycaptinnami Jesús caycashgan wayi puncuman asca runacuna shuntacäyargan. Saymanmi apayargan tucuy-nirag gueshyawan gueshyagcunata y supaycuna nacasishgan runacunatapis Jesús cachacäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sayno apayaptinmi Jesús aliyäsergan say gueshyagcunata. Saynölami runacunapita supaycunata gargorgan. Tayta Dios cachamushgan Cristo cashganta say supaycuna musyaptinmi Jesús olgutupargan imatapis mana parlacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Waraynin saca sacala marcapita Jesús aywargan sunyag jircaman Tayta Diosta manacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saymi Jesusta watucarir discípulu mayincunawan Simón aywayargan payta ashir. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesusta tarircurna niyargan: “Runacunami ashiycäyäshunqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sayno niyaptin Jesús nergan: “Paycuna ashiyämaptinpis waquin marcacunapana aywashun Tayta Diosninsipa wilacuyninta wilacunäpä. Waquin marcacunachöpis Tayta Diosninsipa wilacuyninta wilacunäpämi shamushcä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Saymi marcan marcan intëru Galilea provinciapa Jesús purergan Tayta Diosninsipa wilacuyninta sinagogacunacho wilacushpan y supaycunata runacunapita gargushpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Juc marcachömi leprawan gueshyaycag runa Jesuspa puntanman gongurpacuycur ruwacorgan: “Sänu canäpä aliyaycasilämay, taytay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sayno ruwacuptinmi Jesús cuyapashpan yataycur nergan: “Cananpitaga aliyashganami canqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sayno niptinmi jinan höra aliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aliyarcuptinnami Jesús payta yäsir nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ama pitapis wilanquisu noga aliyäsishgäta. Saypa trucanga Moisés guelgashgancho nishgannöpis templuman ayway aliyashgana cashgayquita cüra ricashunayquipä. Nircurna Moisés guelgashgancho nishgannöla aliyashgayquipita lapantapis ruranqui. Aliyashgana cashgayquita cüra wilashuptiquimi lapanpis musyayanga rasunpaypa aliyashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sayno nicaptinpis say runaga aliyashganta pï-maytapis wilacuraycarmi Jerusalenpa aywargan. Saymi may-saypitapis runacuna Jesús cashgan cagman aywayargan gueshyaycashganpita aliyäsinanpä. Aläpa runacuna juntapäyaptinmi Jesusga marcamanpis yaycognasu. Sunyag jircalacho quëdaptinpis runacuna saymanpis aywayagmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Saypita asca junagta Jesús yapay cutergan Capernaum marcaman. Saycho caycashganta musyarmi asca runacuna chäyargan pay caycashgan cag wayiman. Wayi rurincho segaypa quichqui captinmi puncumanpis asca shuntacäyargan. Saychömi Tayta Diosninsipa wilacuyninta Jesús paycunata yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Saycho yachaycäsiptinmi chuscu runacuna apayargan paralítico runata. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Say wayicho runacuna asca captinmi puncupaga say gueshyagta yaycasiyta camäpacuyargansu. Saymi wayi jananman wisarcasir wayi gataraycashganta quichayargan. Nircur wascawan warcuypa quirmantinta uräsiyargan Jesuspa naupanman. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Say runacuna payman yäracuyashganta musyarmi say gueshyaycag runata Jesús nergan: “Lapan jusayquipita perdonashganami caycanqui, hïjo.” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gueshyagta Jesús sayno niptinmi Moisés guelgashganta yachaseg runacuna shongulancho yarpachacuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Imanirtä cay runa sayno parlan? Tayta Dioslami munayyog caycan runacunata perdonananpä. ¡Dios-tucur sayno nerga lutantami parlaycan!” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sayno yarpaycäyashganta musyarmi Jesús taporgan: “¿Imanirtä sayno yarpaycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Maygantä más aja caycan? ¿Runapa jusancunata perdonaycu? ¿O gueshyaycashganta aliyäsiycu? ");
INSERT INTO qvhNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nogami munayyog caycä runapa jusancunata perdonanäpä. Sayta musyayänayquipämi cay runata aliyäsishä.” Nircur say gueshyaycag runata nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“¡Sharcuy! Quirmayquita apacurcur wayiquipa aywacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sayno niptin jinan höra gueshyaycag runa aliyashgana sharcorgan. Nircur quirmanta apacurcur aywacorgan lapan runacuna ricaycäyaptin. Sayta ricaycurmi runacuna cushicuyashpan Tayta Diosta alabayargan: “¡Manami imaypis ricashcansisu pitapis cayno aliyäsegtaga!” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Saypitanami Jesús aywargan Galilea gocha cuchunman. Sayman asca runacuna shuntacäyaptinmi paycunatapis yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Saypita marcaman cutirnami ricargan Alfeupa surin Mateuta impuestuta cobrar jamaraycagta. Saymi Jesús payta nergan: “Discïpulö canayquipä gatirämay.” Sayno niptinmi Jesuswan Mateo aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Saypitanami Jesusta y discïpuluncunata Mateo gayasergan wayincho micuyänanpä. Saychömi impuesto cobrag runacuna y Diosta mana cäsucog runacunapis paywan micuyargan. Paycunaga ascagmi Jesusta gatiräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Paycunawan juntu micuycagta ricarmi Moisés guelgashgan leycunata yachasegcunawan fariseucuna Jesuspa discïpuluncunata niyargan: “¿Imanirtä impuesto cobragcunawan y Diosta mana cäsucogcunawanpis talucaycur Jesús micuycan?” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sayno niyashganta wiyarmi Jesús nergan: “Gueshyagcuna jampicogta nistäyashgannölami jusasapacunapis Tayta Diosninsipa wilacuyninta pilapis tantyasinanta nistäyan. Nogaga manami Tayta Diosninsi munashganno cawag runacunalata Diospa wilacuyninta wilapänäpäsu shamushcä, sinöga pay munashganno mana cawag runacunatapis wilapänäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutichömi Jesusta runacuna tapuyargan: “Juan Bautistapa discïpuluncunawan fariseucunapa discïpuluncunaga imaypis ayunayanmi. Gampa discïpuluyquicunaga ¿imanirtä paycunano ayunayansu?” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sayno tapuyaptinmi Jesús nergan: “Casaray fiestaman gayasishgan cagcuna ¿ayunayanmansurä? Casarag magta paycunawan caycashganyäga manami ayunayansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Casarag magta wanuptinmi isanga ayunayangapä. Saynölami discïpulöcunapis paycunawan cashgäyäga ayunayanmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Manami pipis macwa mödanata remendansu mushog träpuwanga. Mushog träpoga guentir masmi rachicäsenga macwa mödanata. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sayrä rurash aswatapis manami winansisu shilicaycag urpumanga. Shilicaycag urpuman winashgaga aswa pogur say urputa lacsiriycongami. Sayno captenga aswapis jichacangami y urpupis paquir ushacangami. Saymi sänu urpuman sayrä rurash aswata winansi. Saynölami nogapa yachasicuynëpis mushog car gamcunapa costumbriquicunamanga tincunsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sábado jamay junagchömi discïpuluncunawan Jesús päsaycäyargan trïgu poguraycag chacracuna cuchunpa. Saypa päsarmi Jesuspa discïpuluncuna trïguta palarcur cuparishpan micuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sayta ricarmi fariseo runacuna niyargan: “Sábado jamay junag mana arunapä Moisés guelgashgan leycunacho nicaptenga ¿imanirtä discïpuluyquicuna trïguta palaycäyan?” ");
INSERT INTO qvhNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Saymi Jesús nergan: “Sábado jamay junagcho trïguta palarpis paycunaga manami jusalicuycäyansu. Asca cutimi gamcuna liyiyashcanqui David yanapagnincunawan micanar imata rurayashgantapis. Asca cuti liyiycarpis ¿manacu tantyayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cüracunapa más mandagnin Abiatar caycaptin Tayta Diosta manacuna wayi rurinman David yaycur Tayta Diosninsipä churaraycag tantata micorgan. Nircur paywan aywag runacunata say tantata garargan paycunapis micuyänanpä. Say tanta cüracunala micuyänanpä captinpis sayta micur Davidga manami jusalicuyashgasu.” Sayno nirmi Jesús tantyasergan discïpuluncuna sábado jamay junagcho trïguta micurpis mana jusalicuyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nircur Jesús nergan: “Sábado jamay junagta Tayta Dios manami runacuna nacayänanpäsu camargan, sinöga ali cawayänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nogami munayyog caycä sábado jamay junagcho runa rurananpä mana rurananpä cagtapis ninäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saypita say marcacho sinagogaman yaycurir Jesús ricargan juc runa jucag maquin wanush caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Saymi chiquegnincuna Jesusta ricapaycäyargan sábado jamay junagcho aliyäsiptenga say achäquila contran sharcuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sayno yarpaycäyashganta musyarmi wanush maquiyog runata Jesús nergan: “Sharcurcur runacunapa naupanman ichicuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nircurna runacunata Jesús taporgan: “Sábado jamay junagcho ¿gueshyaycag runata aliyäsishwancu o ‘Jina nacacusunpis’ nishwancu?” Sayno niptin runacuna manami imatapis niyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mana cuyapäcog cayashganta musyarmi Jesús ajanash paycunata ricärergan. Nircurnami maquin wanush runata nergan: “¡Maquiquita jogariy!” Jogarcuptinmi maquin sänuna ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sábado jamay junagcho sayno aliyäsiptinmi fariseo runacuna yarguriyashpan Herodispa favornin cag runacunawan wilanacuyargan Jesusta wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sinagogapita yargurirnami discïpuluncunawan Jesús aywacorgan Galilea gocha cuchunman. Saypa aywaptinmi Galilea runacuna saysica paypa guepanpa aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Milagro rurashgancunata musyashpanmi runacuna Jesús cagman aywayargan Judea provinciapita, Jerusalenpita, Idumea provinciapita, Jordán mayu wac simpanpita, Tiro marcapita y Sidón marcapitapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Gueshyagcunata saycho aliyäsiptinmi waquin gueshyagcunapis Jesús caycashgan cagman imaycanöpa yaycuyta munayargan yataylapis yataycuyänanpä. Sayno juntapäyaptinmi discïpuluncunata Jesús nergan: “Büquita alistashla caycäsiyay runacuna aläpa juntapäyämaptin sayman wisänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Saychömi supaycuna löcuyäsiyashgan runacunapis Jesuspa puntanman gongurpacuycur gaparashpan niyargan: “¡Gamga canqui lapanpä munayyog Diospa surinmi!” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sayno gaparäyaptinmi say supaycunata Jesús olgutupargan upälacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Saypitanami jircaman Jesús wisaptin paywan aywagcuna quëdayargan jirca chaquincho. Nircurmi paycunapita chunca ishcayta (12) gayasergan say jircaman wisäyänanpä. Paycunatami acrargan paywan puriyänanpä, Tayta Diosninsipa wilacuyninta wilacuyänanpä, ");
INSERT INTO qvhNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","runacunapita supaycunata garguyänanpä y gueshyagcunata aliyäsiyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Say acrashgancunapa jutincunami cayargan Simón (paypa jutinta trucasergan Pedro cananpä) ");
INSERT INTO qvhNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","y Zebedeupa surincuna Santiago y Juan. Santiagutawan Juanta Jesús cuyay jutinta churapargan “Boanerges” nishpan. “Boanerges” nishganga “Magacuypa Surin” ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Waquin cagpa jutinmi cargan Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeupa surin Santiago, Tadeo, “Celote” nishgan Simón, ");
INSERT INTO qvhNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Jesusta entregag cag Judas Iscariote. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Saypita posädaraycashgan wayiman Jesús cutiptinmi saymanpis asca runacuna yapay shuntacäyargan. Saymi tiempun cargansu discïpuluncunawan micuyänalanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús sayno caycashganta musyarmi castancuna yarpäyargan löcuyash caycashganta. Saymi pay caycashgan cag wayiman aywayargan shuntayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Saynöpis Jerusalenpita chaycur Moisés guelgashgan leycunata yachasegcuna niyargan: “Cay runaga manami Tayta Diospa munayninwansu supaycunata runacunapita gargun, sinöga supaycunapa mandagnin Beelzebupa munayninwanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lutanta sayno parlaycäyashganta musyarmi Jesús paycunata gayarcasir tantyasergan: “Satanasga manami pitapis yanapansu supaycunata gargunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Musyashgansinöpis juc nación ishcayman raquicash car quiquinpura chiquinacorga ushacäyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Saynöpis juc wayicho tagcuna quiquinpura chiquinacorga ¿manasurä wacpa caypa aywacur ushacäyanman? ");
INSERT INTO qvhNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Saynölami supaycunata gargunanpä Satanás pitapis yanaparga gargunacur ushacanman.” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Satanaspita más munayyog cashganta tantyasirmi Jesús yachasergan: “Calpayog runa wayinta täpaycaptenga manami pipis suwapanmansu. Sayno täpaycaptinpis paypita más calpayog runa shamurmi isanga pancaycur imancunatapis apacurcur aywaconga. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Runacuna ima jusalicuyashganta y lutancunata parlayashgantapis perdonta manacuyaptenga Tayta Dios perdonangapämi. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tayta Dios cachamushgan Cristo cashgäta Santu Espíritu tantyaycäsiptin conträ parlagcunatami isanga Tayta Diosninsi imaypis perdonangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Satanaspa munayninwanmi runacunapita supaycunata garguycan” nir runacuna contran parlaptinmi Jesús sayno nergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Saypitami Jesuspa mamanwan wauguincuna chäyargan pay yachaycäsishgan wayi puncuman. Saycho asca runacuna cayaptinmi yaycuyta mana camäpacur Jesusta gayasiyargan wagtalaman. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Saymi Jesuspa naupancho waquin jamaraycagcuna wilayargan: “Mamayquiwan wauguiquicunami puncucho shuyaraycäyäshunqui” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Sayno wilayaptinmi naupancho jamaraycagcunata ricärir Jesús nergan: “Paycunami mamäno y wauguëcunano caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pipis mamäno, wauguëcunano y panëcunano caycäyan Tayta Dios munashganno cawag cagmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Saypita gocha cuchuncho Jesús yapay yachasiptinmi asca runacuna shuntacäyargan. Aläpa quichquipäyaptinmi gocha cuchuncho caycag büquiman Jesús wisargan saypitana yachasimunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nircurnami imamanpis tincusiypa asca yachasicuyta yachasimorgan: ");
INSERT INTO qvhNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yachasimushgäta shumag tantyacuyay. Juc runashi aywargan trïgu murog. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sayshi muruta shicaptin waquin chäyargan näniman. Saycho shicaraycagtami pishgucuna shamur upshacurcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Waquin cag murunashi chäyargan shalaman. Saycho winamurpis alpa aläpa mana captinshi shanaywan saquicäcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin cag murunashi chäyargan cashacuna cashganman. Cashacuna rurincho garwashtaycälar winamurshi wayuyninpis cargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquin cag murunashi ali alpaman chäyargan. Saycunaga ali winamurshi ali espïgayog cayargan. Waquin espïgashi wayorgan quimsa chunca (30) trïgucunata, waquin espïgacunashi wayuyargan sogta chunca (60) trïgucunata y waquinnashi wayorgan pachac (100) trïgucunata.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sayno yacharcasir Jesús nergan: “Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saypita runacuna aywacuyaptin Jesús quëdargan chunca ishcay (12) acrashgan cag discïpuluncunawan y paywan aywagcunawanpis. Imapita yachasishgantapis mana tantyarmi Jesusta manacuyargan tantyasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sayno manacuyaptinmi Jesús nergan: “Gamcunataga tincusiypa yachasishgäcunata shumagmi tantyasiyäshayqui. Mana cäsucamagcunatami isanga yachasë imaman tincusirpis mana tantyasiylapa. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Sayno yachasë ricaycarpis mana tantyayänanpä y wiyaycarpis mana chasquicuyänanpämi. Janan shongula chasquicamash carmi paycunaga jusancunapita perdonashgasu cayanga.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Saymi discïpuluncunata Jesús nergan: “Say yachasishgäta mana tantyarga masta yachasiptëpis manami tantyayanquipäsu. Saymi shumag tantyayänayquipä canan yachasiyäshayqui. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Trïgu murunömi Tayta Diosninsipa wilacuynin caycan. Trïgu murupacog runanömi Diospa wilacuyninta wilacogcuna caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Chucru näninömi waquin runacunapa shongun chucru caycan. Sayno chucru shongu carmi Tayta Diosninsipa wilacuyninta wiyarpis chasquicuyansu. Saymi wiyashgalantapis Satanás gongaycasin. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Waquin runacunapa shongonga shalanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta wiyar cushishmi chasquicuyan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cushish chasquicurpis shalacho alpa aläpa mana captin trïgu jegarcamur saquicäcushgannömi paycunapis caycäyan. Saymi runacuna chiquiyaptinpis o ima nacaycho carpis cuticuyan naupata cawayashganmanno. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","“Waquin runacunapa shongonga casha rurincho cag alpanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta wiyarpis más yarpachacuyan rïcu cayänalanpä y quiquin munashganno cawayänalanpämi. Saycunalapä yarpachacurmi Tayta Diosninsi munashganno cawayansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Waquin runacunapa shongonga ali alpanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta cushish chasquicur Tayta Diosninsi munashgannömi cawayan. Saymi ali alpacho juc murulapita quimsa chunca (30) trïgu o sogta chunca (60) trïgu o pachac (100) trïgu wayushganno say runa Tayta Diosninsi munashganno cawanga.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sayno nircurmi discïpuluncunata nergan: “Manami pipis acsita sarisinsu cajun rurinman pacananpä, ni cawitu rurinman pacananpäga. Saypa trucanga alayrinninmanmi churan lapanta asicyapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Saynölami gamcunapis yachasiyashgäcunata pï-maytapis wilapanqui. Sayno wilapaptiquimi pï-maypis wilacuynëta musyayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sayno nircurmi Jesús nergan: “Yachasinayquipäga nishgäcunata shumag wiyacayämay. Sayno wiyarga yachasishgäta masmi tantyacuyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sayno captenga mayganpis yachacuyta munagcunaga yachasishgäcunata tantyangapämi. Mana yachacuyta munagcunami isanga wiyarpis tantyangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","Saypitanami mastapis Jesús nergan: “Tayta Diospa ali wilacuyninta chasquicog runa trïgu winamognömi caycan. Trïguta muruptin puntataga pashtamun guewanölami. Winarcurnami say trïgoga espigayta galaycun. Pogurcuptinnami cosechan. Trïgu murog runa cosecharpis manami tantyansu murushgan trïgu imano pashtarcamur winashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","32","Mastapis Jesús nergan: “Tayta Diospa ali wilacuynenga ñäbus murunömi caycan. Ñäbuspa muronga pasaypa tacshala caycarpis muruptin winamur waquin guewacunapitapis más jatunmi ricacun. Saymi pishgucunapis gueshuncunata rämancunacho rurayan. Say tacshala murulapita ñäbus winarcamur räman mashtacashgannömi Tayta Diospa ali wilacuynenga may-saymanpis chaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Saynölami tincusiypa mastapis Tayta Diosninsipa wilacuyninta Jesús yachasergan. Saynöpis yachasergan runacuna tantyayänanpä-tupulami. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imamanpis mana tincusiypaga manami imaypis yachasergansu. Discïpuluncunatanami isanga tincusiypa yachasishgancunata lapanta tantyaseg. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Runacunata büquipita yacharcasimurnami pasa sacaycaptin Jesús nergan discïpuluncunata: “Acu päsashun gocha wac simpaman.” Sayno nirmi caycashgan büquilawan wac simpaman aywayargan. Aywayaptinmi asca büquicunawan runacunapis guepanpa aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gochapa päsaycäyaptinmi fiyupa vientu galaycorgan. Fiyupa vientuptin yacu pulchagyarmi büquita cäsi cäsi talpucäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sayno caycaptinpis büquicho shumag jaunacuycurmi Jesús punuraycargan. Saymi Jesusta discïpuluncuna fiyupa mansacäyashpan ricchasiyargan: “¡Ricchay, taytay! ¡Talpucaycansinami!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Saymi Jesús sharcurcur vientutawan yacuta olgutupargan chawänanpä. Saymi jinan höra vientuwan yacu chawasquergan. Saypitanami lapanpis tranquïluna ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nircurna discïpuluncunata Jesús nergan: “¿Imanirtä gamcuna sayjinanpa mansacash caycäyanqui? ¿Manacu nogaman yäracayämanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sauraga discïpuluncuna quiquinpura mansacash niyargan: “Yacupis vientupis sayno cäsunanpäga ¡imajinanparä munayyog payga caycan!” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gochata simparcurna chäyargan Gadara nishgan partiman. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Büquipita Jesús urarcuptinmi supaycuna löcuyäsiyashgan runa panteonpita yargamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Say runaga panteonlachömi täcog. Asca cuti runacuna cadinawan chaquinpita maquinpita watashgantapis rachirmi ushasqueg. Sayno captinmi pipis ima ruraytapis camäpacuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Saymi gaparaycar sunyag jircapa y panteonpa pagasta junagta puricog. Saynöpis rumicunawan tacacurmi maypapis pureg. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sauraga Jesusta ricarmi cörrila aywaycur paypa puntanman say runa gongurpacuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Payta ricaycurmi Jesús nergan: “¡Supay, yarguy cay runapita!” Sayno niptinmi say runacho cag supaycuna fiyupa gaparäyashpan niyargan: “¡Munayyog Diospa surin Jesús! ¡Cay runapita ama gargaycalämaysu!” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sauraga say supaycunata Jesús taporgan: “¿Imatä jutiqui?” Sayno tapuptin supaycuna niyargan: “Nogapa jutëga Legionmi. Say jutëga caycan saysica cayaptëmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sayno nircur supaycuna Jesusta ruwacuyargan saypita caruman mana gargunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Paycuna caycäyashgan washaläninchömi ishcay warangano (2,000) cuchicuna micuycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Saymi say supaycuna Jesusta manacuyargan cuchicunaman yaycuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sayno manacuyaptinmi cuchicunaman yaycuyänanpä aunergan. Auniptinmi supaycuna runapita yargurir yaycucuycuyargan say cuchicunaman. Saymi cuchicunaga löcutashpan tunapa cörrir gochaman jegacurpuyargan. Saychömi shengaypa wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sayta ricaycurmi cuchi misegcunaga mansacash cörrila aywayargan marcacho tag runacunata y cercancho tag runacunatapis wilayänanpä. Wilayaptinmi runacuna aywayargan ima päsashgantapis ricayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sayman chäyashpanmi say löcuyash runata tariyargan Jesuspa puntancho juiciunchöna caycagta. Ali yarpayninchöna carmi mödanashgana jamaraycargan. Sayta ricaycurmi runacuna mansariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Cuchi misegcunami shamogcunata wilargan supaycuna löcuyäsishganpita imanöpa say runa cachacashganta y cuchicuna shengaypa wanuyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sayta wiyaycurmi segaypa mansacash lapanpis Jesusta niyargan saypita aywacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuticunanpä büquiman Jesús wisarcuptinmi say cachacag runa Jesusta manacorgan paywan aywacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sayno manacuptinmi Jesús nergan: “Nogawan aywanayquipa trucanga wayiquipa cuticuy. Saychöna castayquicunata wilapanqui Tayta Diosninsi cuyapäshushpayqui cachacäsishushgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sayno niptinmi say runa jinan Decápolis provinciacho mayman charpis wilapargan Jesús cachacäsishganta. Sayno wilacuptinmi lapan wiyagcuna cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Saypita Jesús büquiwan gocha wac simpanman chänanpäga saysica runacuna shuntacash payta shuyaraycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Saymanmi chargan sinagogacho mandag Jairo jutiyog runa. Paymi Jesuspa puntanman gongurpacuycushpan nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Warmi surë wanuycannami. Aywayculäshun aliyäsinayquipä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sayno ruwacuptin Jesús aywargan Jairuwan. Paywan aywaptinmi asca runacuna quichquiyparä Jesusta gatiräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Say runacunawanmi aywaycargan chunca ishcay (12) watana yawar apaywan gueshyaycag warmipis. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Say gueshyawan segaypa nacarmi imaycancunatapis ranticur ushargan mëdicucunata pägananpä. Imanöpa jampiyaptinpis manashi aliyargansu. Aliyänanpa trucanga masshi ansargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesús aliyäsinanpä munayyog cashganta musyarmi say warmega guepalanpa yaycuycur paypa mödananta yataycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sayno rurargan: “Jesuspa mödananta yataycularpis aliyäshämi” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yataycuptinmi jinan höra yawar apaynin saquisquergan. Saymi tantyargan aliyasquishganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mödananta yataycur pipis aliyashganta musyarmi Jesús nergan: “¿Pitä mödanäta yataycamash?” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Saymi discïpuluncuna niyargan: “Taytay, cayno quichqui aywaycashgaga ¿imanöparä musyashwan maygan yataycushushgayquitapis?” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sayno niyaptinpis Jesús ricachacuycargan pï yataycushgantapis musyananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sauraga say warmi mansarishpan sucsucyaycar Jesuspa puntanman gongurpacuycorgan. Nircurmi wilargan paypa mödananta yataycur aliyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sayno wilaptinmi Jesús nergan: “Nogaman yäracamashgayquipitami aliyashcanqui. Cananga cushishgana cuticuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús sayno parlaycaptinrämi Jairupa wayinpita wilacog taripaycur Jairuta nergan: “Suriqui wanusquishganami. Amana Jesusta pushaynasu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sayno niptinmi Jairuta Jesús nergan: “Ama laquicuysu. Nogaman yäracamaptiquega suriqui cawarimongami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sayno nircurmi Jairupa wayinman Jesús aywargan Pedruta, Santiaguta y Juanta pushacurcur. Waquin aywanantaga manami munargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairupa wayinman chaycurmi Jesús tarergan runacuna saycho fiyupa laquicushpan wagaycäyagta. Saymi Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","“¿Imanirtä sayjinanpa wagaycäyanqui? Jairupa surenga manami wanushgasu, sinöga punuycanlami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sayno niptinmi wanush caycashganta musyayashpan saycho caycag runacuna Jesús nishganta criyiyargansu. Sayno captinpis lapan runacunata say wayipita wagtaman yarguyänanpä nergan. Nircurmi Jairutapis, warmintapis discïpuluncunatapis pushacurcur Jairupa surin sutaraycashgan cagman yaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yaycurir wamrata maquinpita aptarcur nergan: “Talita, cumi.” (“Talita, cumi” nishganga “Jipash, sharcuyna” ninanmi.) ");
INSERT INTO qvhNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sayno niptinmi Jairupa surin jinan höra cawarircamur sharcur purergan. (Payga cargan chunca ishcay (12) watayognami.) Jipachita cawarimushganta ricaycurmi lapan saycho cagcuna selläma cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nircurmi mamantawan taytanta Jesús nergan aliyäsishganta pitapis mana wilapäyänanpä. Nircurnami jipachitata pachan garayänanpä nergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Saypitana discïpuluncunawan Jesús aywargan Nazaret marcanman. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado jamay junag captinmi yaycorgan sinagogaman. Saycho yachasiptinmi runacuna niyargan: “Cay runaga ¿maychötä sayjinanpa yachacuycush? Saynöpis ¿imanöpatä milagrucunata ruran? ");
INSERT INTO qvhNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manacu payga caycan Mariapa wawan? Saynöpis ¿manacu payga carpintëro? ¿Manacu Santiago, José, Judas y Simonpis paypa wauguincuna caycäyan? Saynölami panincunatapis reguinsi.” Sayno nirmi Jesús yachasishgancunata chasquicuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Saymi Jesús nergan: “Waquin marcacunacho Tayta Diosninsipa profëtanta chasquicuyaptinpis castancunawan marca mayincunaga manami chasquicuyansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sayno nirmi juc ishcay gueshyagcunalata quiquinpa marcancho aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Marca mayincuna payman mana yäracuyaptinmi Jesús fiyupa laquicorgan. Saypitanami marcacunapapis jalgacunapapis runacunata yachasiraycar Jesús purergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nircurmi chunca ishcay (12) acrashgan cag discïpuluncunata gayaycur Jesús nergan may-saypapis ali wilacuyninta wilacog ishcag ishcag aywayänanpä. Saynöpis nergan paypa jutincho runacunapita supaycunata garguyänanpä. Nircurmi paycunata nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“May marcapa aywarpis ama apayanquisu guepinayquita, mircapayquita ni guellayniquitapis, sinöga tucrulayquita apayanqui. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jatiräyashgayqui languilayquiwan aywayanqui. Ama apayanquisu trucacuyänayquipä mödanayquicunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","May marcaman charpis posädacuyashgayqui wayilacho posädaräcuyanqui juc marcaman päsayashgayquiyag. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","May marcachöpis mana chasquiyäshuptiquega saypita aywacuyanqui languiquicho caycag polvuta tapshirishpayqui. Sayno rurayanqui Tayta Diosninsi paycunata juzgananpä cashganta tantyacunanpä. Sayno mana chasquishushgayquipitami Sodoma y Gomorracho tag runacuna infiernucho nacayänanpä cashganpitapis paycuna más fiyupa infiernucho nacayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sayno niptinmi acrashgan cag discïpuluncuna aywayargan marcan marcan Tayta Diosninsipa wilacuyninta wilacuraycar. Saynöpis wilacuyargan jusalicuyashgancunata cacharir Tayta Dios munashgannöna cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sayno wilacur purirmi supaycunatapis runacunapita garguyargan. Saynöpis gueshyagcunapa umanman aceitita winaparcur Tayta Diosta manacuyargan aliyäsinanpä. Saynöpami gueshyashganpita asca runacuna aliyäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Milagrucunata Jesús rurashgancunapitami may-saychöpis runacuna parlayargan. Waquin runacuna niyargan Tayta Diosninsipa profëtan Elías cashganta. Y waquinnami niyargan unay profëtacunano profëta cashganta. Sayno parlayashganta wiyarmi rey Herodes nergan: “Say runaga Juan Bautistami cawarimush canga. Cawarimush carmi munayyog caycan milagrucunata sayno rurananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Naupatami Herodisga wauguin Felipipa warmin Herodiasta suwargan warmin cananpä. Sayno suwash captinmi Juan Bautista nergan: “Wauguiquipa warminta suwamushpayqui jusalicushcanquimi.” Sayno nishganpitami Juan Bautistata Herodes carcilman wichgasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Carcilman wichgasirpis jusaynag ali runa cashganta musyashpanmi Juanta Herodes respitargan. Saymi warmin Herodías Juanta wanusiyta munaptinpis rey Herodisga imaycanöpapis payta sapargan pipis mana wanusinanpä. Isanga Juan wilacushgan ali cashganta tantyarpis Herodes manami chasquicorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Saypita rey Herodes diancho fiestata rurarmi gayasergan autoridäcunata, soldäducunapa más mandagnincunata y Galileacho tag rïcu runacunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mësacho lapan jamaraycäyaptinmi Herodiaspa jipash wawan yaycurir tushorgan. Sayno tushushganta ricarmi selläma cushicuyargan rey Herodes y mësacho jamaraycag runacunapis. Saymi jipashta rey Herodes nergan: “Manacamay imata munashgayquitapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","‘Mandashgayqui nacionta pulanta raquipaycamay’ nimaptiquipis raquipäshayquimi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sayno niptin maman cagman say jipash aywaycur taporgan: “¿Imatatä manacöman, mamay?” nir. Saymi maman nergan: “Juan Bautistata wanurcasir paypa umanta apamunanpä manacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maman sayno yäsiptinmi rey Herodes cagman cutiycur nergan: “Noga munä canan höra Juan Bautistapa umanta plätucho gomänayquitami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","27","Sayta manacuptinmi rey Herodes fiyupa laquicorgan. Juanta wanusiyta mana munarpis gayasishgancunapa naupancho say jipashta promitish carmi wardiata cachargan Juanpa umanta rogurir say jipashta goycunanpä. Saymi carcilman wardia aywaycur Juanta wanusergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nircurna umanta roguriycur plätuwan apaycur jipashta entregargan. Chasquircurnami jipashga mamanta entregaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sayno rurashganta wiyaycur Juanpa discïpuluncuna aywar ayanta shuntacuyargan pampayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesuspa apostolnincunanami ali wilacuyta wilacushganpita lapan cutiyämorgan. Nircurnami Jesusta wilayargan may-saychöpis yachasir purishgancho imano cayashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Asca runacuna payman juntapäyaptin micunanpäpis tiempun mana captinmi apostolnincunata Jesús nergan: “Acu aywashun sunyagninman saycho jamapänansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sayno nirmi apostolnincunawan büquiman Jesús wisarcur gochata päsayargan sunyagninman aywayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Saypa aywaptinpis runacuna tantyayargan maypa aywaycashgantapis. Saymi may-say marcacunapita jucla aywayargan Jesuspita más puntata sunyagman chäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Büquipita urarcurnami Jesús tarergan asca runacuna saycho shuyaraycagta. Misegniynag uyshacunano caycagta ricarmi Jesús cuyapashpan paycunata yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pasa tardiyaptinnami Jesusta discïpuluncuna niyargan: “Caychöga manami imapis cansu runacuna micuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tardina caycaptenga lapan runacuna aywacuyäsun micuyta rantiyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sayno niptin Jesús nergan: “Manami paycunaga micuy asheg aywayanmansu. Paycunataga micuyta gamcuna garayay.” Sayno niptinmi discïpuluncuna niyargan: “¿Imatatä paycunata garayäshä? ¡Puwag (8) quila arur gänashgansinörämi guellay aypanga caysica runacunata garayänäpäga!” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sayno niptin Jesús nergan: “Guepiquicho ayca tantayquicuna cashgantapis ricayämuy.” Ricaycurmi niyargan: “Caycan pisga tantawan ishcay pescädulami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nircur discïpuluncunata Jesús nergan runacunata raquircur raquircur pashpaman jamasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sayno niptin jamacuyargan pachac-cama (100) y pisga chunca-cama (50). ");
INSERT INTO qvhNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Saypitanami pisga tantatawan ishcay pescäduta aptarcur Jesús ciëlupa ricärishpan Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paquircur discïpuluncunata macyargan lapan runacunata aypuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Saymi lapan micuyargan pacha junta. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nircurna pusupacuyashgancunata discïpulucuna shuntayargan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Saycho micogcunaga cayargan pisga waranga (5,000) runacunami. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Saypitana discïpuluncunata Jesús nergan büquiman wisarcur Betsaida marcaman naupayänanpä. Discïpuluncuna aywacuyaptinmi saycho cag runacunata despachapacur Jesús quëdacorganrä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nircurnami jircaman wisargan Tayta Diosta manacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pasa sacaycaptinnami discïpuluncuna büquiwan carutana aywaycäyargan. Sayyäga jircalachörämi Jesús caycargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Saypita ricargan vientu cutisimuptin büquiwan nacar discïpuluncuna aywaycäyagta. Walpa wagay hörano captinnami paycuna cagman yacu jananpa Jesús aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Büqui naupanpa päsag-tucuycaptinmi discïpuluncuna payta ricargan. Saymi alma cashganta yarpäyashpan fiyupa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sayno mansacäyaptinmi Jesús nergan: “¡Ama mansayämaysu! Nogami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sayno nir büquiman wisarcuyaptin vientupis jucla chawargan. Saycunata ricarmi discïpuluncunaga segaypa mansacashno ricacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paycunaga pisga waranga (5,000) runacunata garananpä milagruta rurashganta ricarpis manami tantyacuyargansu rasunpaypa munayyog Jesús cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Galilea gochata simparcurnami chäyargan Genesaret pampaman. Saychömi discïpuluncuna büquita watargan yacu mana apananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Büquipita Jesús urarcuptinnami runacuna jucla payta reguiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jesús saycho cashganta wiyashpanmi may-saypitapis runacuna gueshyagcunata quirmawan apayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Saypita marcacunapa y jalgacunapapis Jesús puriptinmi päsananpä cag nänimanpis gueshyagcunata churayargan. Saypa päsaptinmi gueshyagcuna payta ruwacuyargan mödananpa cuchunta yataylapis yataycuyänanpä. Lapanpis Jesuspa mödananta yataycogcunaga aliyäyarganmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Juc cutimi Jerusalenpita aywar fariseucuna y Moisés guelgashgan leycunata yachasegcuna Jesús cagman chäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Saychömi Jesuspa discïpuluncuna maquinta mana maylacuylapa micuycagta ricar paycuna jamuräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseucuna y Israel mayincunaga unay runacunapa costumbrincunata cumplirmi manarä micur maquintarä maylacuyag limpio caycaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sayno costumbricunata cumplirmi pusilluncunatapis, plätuncunatapis, mancancunatapis, y catrincunatapis maylagrä limpio caycaptinpis. Saynömi rantipacuyashganpita cutirpis maquinta manarä maylacorga jamacuyagsu. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Saymi fariseucunawan Moisés guelgashgan leycunata yachaseg runacuna Jesusta tapuyargan: “¿Imanirtä discïpuluyquicuna unay runacunapa costumbrincunata mana cäsur micuyänanpä maquincunata maylacuyansu?” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sayno niyaptinmi Jesús nergan: “¡Ishcay cära runacuna! Gamcuna sayno cayänayquipä cashganta musyarmi Santu Espíritu profëta Isaiasta tantyasergan. Saymi pay cayno guelgargan: ‘Cay runacunaga janan shongulami: “Tayta Dios, Tayta Dios” nicäyäman. Saynöpis manami lapan shongunwansu nogata chasquicayäman. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Paycunaga wilacuynëta yachasiyänanpa trucanga runacunapa costumbrilantami yachaycäsiyan. Sayno captinmi adorayämaptinpis paycunata cäsupäshäsu.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Mastapis Jesús nergan: “Isaías nishgannölami gamcunapis Tayta Diosninsipa leynincunata cäsucuycäyanquisu. Cäsucunayquipa trucanga runacunapa costumbrincunalatami cumpliycäyanqui. Saymi wichicunatapis pusillucunatapis y más waquintapis maylanquirä. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés guelgashganchöga caynömi nican: ‘Mamayquitawan taytayquita ali ricanqui. Pipis mamanta o taytanta maldicionag cäga wanusish casun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mamayquitawan taytayquita ali ricayänayquipä nicaptinpis gamcunaga manami yanapaycäyanquisu. Saymi runacunata yachaycäsiyanqui: ‘Tayta Dioslapämi imaycäpis caycan’ nerga mamantawan taytanta manana yanapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sayno yachasirmi gamcunaga Tayta Diosninsipa palabranta manacagman churaycäyanqui. Saynölami imatapis gamcunaga quiquiqui yarpäyashgalayquita ruraycäyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nircurnami runacunata gayaycur Jesús nergan: “Cay nishgäcunata lapayqui shumag tantyacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Manami imatapis micushganpitasu pipis jusayog ricacun, sinöga shonguncho mana alita yarpashganpitami. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Saysica runacuna saycho captinmi paycunapita witicushpan juc wayiman discïpuluncunawan Jesús aywargan. Saychönami discïpuluncuna ruwacuyargan yachasishgancunata tantyasinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","20","Saymi Jesús nergan: “¿Gamcunapis manacu tantyayanquirä? ¿Manacu runa imata micushganpis päsagla caycan? Saymi micushganpitasu runaga jusayog ricacun, sinöga shonguncho lutancunata yarpashganpitami.” Jesús sayno nergan ima micuypis micunansipä ali cashganta tantyasishpanmi. Nircur mastapis Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","“Shonguncho lutancunata yarpachacurmi adulteriucho cayan, runacuna chinëru cayan, warmicunapis waynäcuyan, wanusinacuyan, ");
INSERT INTO qvhNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","suwacuyan, wachacash cayan, lulacuyan, chiquinacuyan, jucpa washanta rimayan, yachag-tucuyan y luta jusalicuyan. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lapan say mana ali ruraycunaga shonguncho lutanta yarpashganpitami caycan. Saynöpami runacuna jusayog ricacuyan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","26","Saypita Jesús aywargan Sirofenicia nacioncho cag Tiro marcapa. Sayman chashganta runacuna mana musyayänanpämi pipis mana ricayla juc wayiman posädacorgan. Sayno captinpis juc warmi musyargan Jesús sayman chashganta. Paypa wawantami gueshyawan supay nacaycäsergan. Saymi Jesús cagman aywaycur paypa puntanman gongurpacuycur ruwacorgan wawanpita supayta gargunanpä. Say warmega manami Israel warmisu cargan, sinöga jinan Sirofenicia nacionpitami cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sayno ruwacuptinmi Jesús nergan: “Puntataga yanapäshä Israel mayëcunatarämi. Gamcunata yanapaptëga canman wamracunapa tantanta guechurir algucunata jitapaycognömi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sayno niptin warmi nergan: “Au, taytay. Sayno captinpis wamracuna shicwapacuyashgantami algucunapis micuyan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sayno niptin Jesús nergan: “Sayno nicanqui rasunpaypa yäracamashpayquimi. Sayno yäracamashgayquipitami wawayquita nacaseg supay yargushgana caycan. Cananga wayiquipa cushish cuticuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sayno niptin wayinman cutirmi wamranta tarergan cachacashgana cämancho caycagta. Wamrata gueshyaseg supayga yargucushganami cash. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro marcapitanami Jesús päsargan Sidón marcapa. Saypita cutirnami Galilea gocha cuchunpa päsar chargan Decápolis provinciaman. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Saycho caycaptinmi apayargan mana wiyag ni mana parlag runata. Chaycasirna Jesusta ruwayargan say upata aliyäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sauraga quiquilanta jucläman pusharcur upapa rinrinman dëdunta Jesús jatergan. Nircur togayninwan dëdunta ushmarcasirmi upapa galluntapis yataycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sayno rurarcurna jämayta cacharcur ciëluta ricärir: “¡Efata!” nergan. (“Efata” ninanga caycan “¡Quichacay!” ninanmi.) ");
INSERT INTO qvhNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sayno niptinmi jinan höra upapa rinrin wiyargan y shiminpis pashtarganna. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sayno aliyarcasirmi saycho caycag runacunata Jesús nergan aliyäsishganta pitapis mana wilapänanpä. Sayno nicaptinpis pï-maytami wilapäyargan upata Jesús aliyäsishganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Milagruta Jesús rurashganpita fiyupa cushicur may-saychöpis tincushgan runacunata niyargan: “¡Imaycatapis Jesusga ruraycun segaypa espantaypämi! ¡Cananga upacunapis wiyayannami y mana parlagcunapis parlayannami!” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saypita asca runacuna Jesús cagman shuntacäyaptin micuyänanpä imapis cargansu. Saymi discïpuluncunata Jesús gayaycur nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cuyapämi caycho nogansiwan caycag runacunata. Paycuna quimsa junagnami nogansiwan caycho caycäyan micuyta mana yawaylapa. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waquin cäga shayämush caru marcapitami. Micönila wayincunapa cuticuyänanpä niptëga aywaycäyaptilannami vëtapis sarenga imanga.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sayno niptinmi discïpuluncuna niyargan: “¿Sunyag jircacho caycarga maychörä tarishwan micuyta caysica runacunapäga, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sayno niyaptinmi paycunata Jesús taporgan: “¿Aycalatä tantayqui caycan?” Saymi niyargan: “Ganchislami caycan, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sayno niyaptinmi lapan runacunata nergan jamacuyänanpä. Jamaycuyaptinnami ganchis tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata macyargan paycuna aypucuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Saynölami juc ishcay acapala pescädutapis Jesusman apapäyargan. Saycunatapis aptarcushpan Tayta Diosta manacur agradëcicorgan. Nircur saycunatapis discïpuluncunata macyargan runacunata aypucuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Saymi lapan micuyargan pacha junta. Pusushgancunatanami shuntayargan ganchis canasta juntata. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Saycho micogcunaga cayargan chuscu waranganömi (4,000). Micuyta ushasquiptinnami lapan runacunata Jesús despachargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Saypitanami büquiman wisarcur discïpuluncunawan Jesuspis aywacuyargan Dalmanuta nishgan partiman. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dalmanuta nishgan partiman chaycuyaptinmi fariseucuna aywaycur Jesusta wajupar niyargan: “Tayta Diosninsi rasunpaypa cachamushushgayquita musyayänäpä mä ima milagrutapis ruray.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sayno niptinmi Jesús laquicushpan nergan: “¿Imanirtä munaycäyanqui milagrutarä ruranäta? Gamcuna munayashgayquinöga manami ima milagrutapis rurashäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nircurna runacunata saycho cachaycur büquiman wisarcushpan discïpuluncunawan aywacuyargan gochapa jucag cuchunman. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gochata simpaycäyashganchömi Jesuspa discïpuluncuna yarparcuyargan mircapanpä juc tantalata apaycäyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Saymi Jesús nergan: “Fariseo runacunapa y rey Herodispa levadüranta cuidä chasquicuyanquiman.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sayno niptin discïpuluncuna quiquinpura niyargan: “Tantata mana mircapacamushgansipitami sayno nicämansi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sayno parlaycäyashganta tantyarmi Jesús nergan: “¿Imanirtä parlaycäyanqui tantata mana apayämushgayquipita? ¿Gamcuna manacu tantyayanquirä imata nicashgätapis? ");
INSERT INTO qvhNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Milagrucunata rurashgäta ricaycarpis gamcunaga mana ricagnömi caycäyanqui. Yachasishgäcunata wiyaycarpis mana wiyagnömi caycäyanqui. ¿Manacu yarpäyanqui ricashgayquita y wiyashgayquitapis? ");
INSERT INTO qvhNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pisga tantalapita pisga waranga (5,000) runacunapä milagruta rurashgäpita pusogta ¿ayca canasta juntatatä shuntayargayqui?” “Chunca ishcay (12) canasta juntatami shuntayargä, taytay” niyargan discïpuluncuna. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Saynöpis ganchis tantata chuscu waranga (4,000) runacunapä milagruta ruraptë pusogta ¿ayca canastatatä shuntayargayqui?” “Ganchis canasta juntatami shuntayargä, taytay” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Saymi Jesús nergan: “Say milagrucunata rurashgäta ricaycarpis ¿manacu tantyayanquirä?” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Saypita discïpuluncunawan Jesús chäyargan Betsaida marcaman. Saycho caycaptinna payman pushayargan gapra runata. Nircur ruwayargan gaprata aliyäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sauraga maquinpita janchacurcur marcapita Jesús jorgorgan. Saychöna gaprapa nawinman togaycur maquinta jananman churargan. Nircurna taporgan: “¿Ricanquinacu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Saymi gapra ampi ampila ricar nergan: “Au, ricänami ampi ampilaga runacunata jachacunano caycagta. Isanga puriycäyanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sauraga nawinta yapay yataycuptin shumagna ricargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sayno aliyarcasirmi say runata Jesús nergan: “Marcaman mana chaylapa y pitapis mana wilapaylapa wayiquiman cuticuy.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Saypita Jesús discïpuluncunawan aywargan Cesarea de Filipuspa caseriuncunaman. Aywaycäyashganchömi discïpuluncunata Jesús taporgan: “¿Pï cashgätatä nogapä runacuna yarpäyan?” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sayno tapuptin discïpuluncuna niyargan: “Waquin runacunaga niyan Juan Bautista cashgayquitami. Waquinnami niyan Elías cashgayquita. Y waquinnami niyan maygan profëtapis cawarimush cashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sayno niyaptin paycunata Jesús taporgan: “Gamcunaga, ¿pï cashgätatä yarpäyanqui?” Saymi Pedro nergan: “Gamga Tayta Dios cachamushgan Cristumi canqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sayno niptinmi Jesús nergan: “Saytaga pitapis ama wilapäyaysu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Saypitanami discïpuluncunata Jesús wilapargan: “Noga fiyupa nacasishgarämi cashäpä. Israel mayor runacuna, mandag cüracuna y Moisés guelgashgan leycunata yachasegcuna chiquimarmi wanusimanga. Saypita quimsa junagtaga cawarimushäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sayno cananpä cashganta wilapaptinmi Jesusta Pedro gayargan jucläman quiquilanta parlapänanpä. Nircurnami Jesusta nergan wanusinanpä cashganta musyaycarga Jerusalenman mana aywananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sayno niptinmi Jesús tantyargan Pedro sayno parlananpä Satanás yarpayta goshganta. Saymi Pedruta Jesús nergan: “¡Naupäpita witicuy, Satanás! Sayno michämashpayquega manami munanquisu Tayta Diosninsi munashganta ruranäta, sinöga yarpashgayquinöla cananta munarmi sapata churapaycämanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nircur discïpuluncunatawan runacunata gayaycur nergan: “Pipis discïpulö cayta munarga shongun yarpashganno jusalicur ama cawasunsu. Saypa trucanga imano nacarpis noga munashgänöla imaypis cawasun. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Noga munashgäno cawananpa trucan quiquin munashganno cawagcunaga infiernuman gaycushmi cayangapä. Ima nacaycho carpis noga munashgäno cawagcunami isanga gloriaman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Infiernuman gaycush cananpä caycaptenga ¿imapätä välin mayjina rïcu cashganpis? ");
INSERT INTO qvhNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mayjina rïcu carpis manami rïcu cashgalanwanga salvacionta rantiyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pipis runacunapa naupancho nogapita y wilacuynëpita pengacuptenga nogapis Tayta Diospa angilnincunawan chipipiycar cutimushpä payta manami cäsushäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Saypita Jesús nergan: “Manarä wanurmi waquinniqui ricayämanquipä lapanpäpis munayyog cashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Saypita sogta junagtami Pedruta, Santiaguta y Juanta pushacurcur Jesús wisargan jirca puntaman. Saychömi paycuna ricaycaptin segaypa chipipergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Saynömi mödananpis rashtano yurag ricacur empañayparä asicyargan. Mayjina tagsharpis manami pipis saynöga yoragäsinsu. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Saychömi ricayargan Moiseswan Elías yuriparcur Jesuswan parlaycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Sayta ricaycurmi paycuna mansacash ricacuyargan. Sauraga Pedro mana yarpachacuylapa nergan Jesusta: “Alipämi nogacuna cayman shayämushcä, taytay. Cananga rurayäshä quimsa suclata: jucta gampä, jucta Moisespä y jucta Eliaspä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sayno parlaycaptinmi pucutay sapacurcorgan. Saypitami Tayta Diosninsi nimorgan: “Payga cuyay surëmi. Pay nishushgayquicunata cäsucuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Saypitaga yapay nuquircuyänanpä Jesús japalannami caycänä. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nircurnami jircapita cutiycämur paycunata Jesús nergan: “Jircacho ricashgayquita pitapis ama wilapäyanquiräsu wanushgäpita noga cawarimushgäyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sayno Jesús niptinmi paycunaga say ricashgancunata pitapis wilapäyargansu. Sayno carpis “Wanushgäpita cawarimushämi” nishganta manami tantyayargansu. Saymi quiquinpura parlaycäyargan: “¿Imanirtä nicämansi cawarimunanpä cashganta?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Saypitanami paycuna Jesusta tapuyargan: “Moisés guelgashgan leycunata yachasegcuna niyan Cristo shamunanpä puntata Eliasrä shamunanpä cashgantami. Sayno nicaptenga ¿imanirtä Elías shamunräsu?” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Sayno niyaptinmi Jesús nergan: “Elías yapay shamunanpä cashganta niyashgannölami Elías mayna shamush. Elías shamur wilacuptinpis manami runacuna chasquicuyashgasu wilacushganta. Chasquicuyänanpa trucanga payta wanusiyargan Tayta Diosninsipa palabrancho nishgannölami. Saynölami runacuna nogatapis chiquimar fiyupa nacasiyämangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Quimsa discïpuluncunawan Jesús say jircapita cutimurmi tarergan Moisés guelgashganta yachasegcunawan waquin cag discïpuluncuna rimanacuycagta. Paycunatami asca runacuna juntaparaycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sayman Jesús chaycagta ricarmi runacuna cushish cörrila taripäyargan saludananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nircurmi discïpuluncunata Jesús taporgan: “¿Imanirtä Moisés guelgashganta yachasegcunawan rimanacuycäyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sayno tapuycaptinmi juc runana nergan: “Supay upayäsishgan surëtami apamushcä cachacäsipämänayquipä, taytay. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maycho caycaptinpis say supay elagpitami surëta gaparäsin, pampaman sagtan, pogushaytapis agtusin y quiruntapis uchusin. Saynöpis wanuy gueshyami sarin. Saymi discïpuluyquicunaman apamuptëpis say supayta garguyta camäpacuyashgasu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Saymi Jesús nergan saycho cag runacunata: “¡Yäracuyniynag runacuna! ¿Imayyagrä gamcunawan caycäshä? Mä apamuy say magtata.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sayno niptinmi Jesuspa puntanman say magtata apayargan. Saymi Jesusta ricärir magtata supay pampaman sagtariycorgan. Saymi say magta pogushayta agtur pampacho goshpargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Saymi magtapa papäninta Jesús taporgan: “¿Imaypitanatä suriquita supay sayno nacaycäsin?” Sayno tapuptin papänin nergan: “Wamra cashganpita-pasami sayno nacaycäsin, taytay. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Asca cuti wanusiyta munashpanmi ninamanpis yacumanpis say supay sagtash. Sayno mana nacananpä surëta cachacäsipaycalämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sayno ruwacuptinmi Jesús nergan: “Rasunpaypa yäracamaptiquega cachacäsipäshayquimi. Yäracamagcunapäga manami imapis ajasu caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sauraga magtapa papänin cushish nergan: “Shumag mana yäracuptëpis yanapaycalämay lapan shongöwan gamman yäracunäpä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sauraga asca runacuna burrurruyla shamuycagta ricarmi say magtacho caycag supayta jucla Jesús gargorgan: “¡Upayäseg y mana parlaseg supay! ¡Cay magtapita jucla yarguy! ¡Cananpitaga imaypis amana cutiynasu cay magtaman!” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sauraga say supay gaparar yapay sagtargan magtata. Nircurna yargurir aywacorgan wanushtano cachariycur. Sayno jitaraycagta ricarmi runacuna yarpäyargan wanushgana cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sauraga maquipita sarircur Jesús say magtata cachacashtana sharcasergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Saypitana discïpuluncunawan Jesús juc wayiman yaycorgan. Saychönami discïpuluncuna Jesusta tapuyargan: “¿Imanirtä nogacuna garguyta camäpacuyashcäsu say supayta?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Saymi Jesús nergan: “Ayunar Tayta Diosninsita manacurrämi say-nirag supaytaga garguyanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Saypita aywacuyashpannami discïpuluncunawan päsayargan Galilea provinciapa. Discïpuluncunawan wilanacuyänan cashgami Jesús munargansu sayman aywashganta runacuna musyayänanta. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Saychömi discïpuluncunata Jesús nergan: “Juc runami nogata entregamanga chiquimagnëcunapa maquinman. Sayno captinpis wanusimashganpita quimsa junagtami cawarimushäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sayno wilaptinpis Jesús nishgancunata paycuna manami tantyayargansu. Sayno mana tantyarpis tapuytami isanga mansapäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Saypita Capernaum marcaman chaycur wayicho caycashpanna discïpuluncunata taporgan: “Nänipa shamur ¿imapitatä parlaycäyashcanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Discïpuluncunaga mandag cayta guechunacur rimanacuyash carmi Jesús tapuptinpis pengacuyashpan upälacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Saypita Jesús jamaycushpan chunca ishcay (12) discïpuluncunata nergan: “Maygayquicunapis más munayyog cayta munarga ashmaynöla pï-maytapis yanapäyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nircurnami juc wamrata margarcur paycunata nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Cay wamratano mana cuentash cagcunata chasquicorga nogata chasquicamagnömi caycäyanqui. Nogata chasquicamarga cachamag Taytätapis chasquicuycäyanquimi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Saymi discïpulun Juan nergan: “Nogacuna ricayashcä juc runata gampa jutiquicho supaycunata garguycagta, taytay. Saymi nogansiwan mana puriptin jutiquita mana jogarinanpä michäyashcä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Saymi Jesús nergan: “Cananpitaga ama michäyanquisu. Nogansiwan mana purirpis jutëcho supaycunata gargorga alitami ruraycan. Sayno carga manami conträsu caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pipis contransi mana sharcorga favorninsimi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chasquicamagcunata pipis noga-raycu juc pusillu yaculatapis macyaptenga Tayta Diosninsi paytapis premiutami gongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús cayno mastapis nergan: “Tayta Diosman yäracogta cuidä pitapis jusalicasiyanquiman. Jusaman tunisicogcunataga más alimi canman mulïnu rumita cuncanman sheguparcur lamarman garpuriyaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Sayno cananpä caycaptenga maquiqui jusalicasishuptiqui roguriycuy. Imaypis mana upeg ninaman ishcan maquiquiwan gaycush canayquipa trucanga más alimi canman juc maquiyoglapis Tayta Diosninsipa naupanman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Infiernuman chagcunaga mana ushacaypami nacangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Chaquiquipis jusalicasishuptiquega roguriycuy. Imaypis mana upeg ninaman ishcan chaquiquiwan gaycush canayquipa trucanga más alimi canman juc chaquiyoglapis Tayta Diosninsipa naupanman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Infiernuman chagcunaga mana ushacaypami nacangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nawiquipis jusalicasishuptiquega ogtiriycuy. Ishcan nawiyog infiernuman gaycush canayquipa trucanga más alimi canman wiscu nawilapis Tayta Diosninsipa naupanman chaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Infiernuman chagcunaga mana ushacaypami nacangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Jusata mana cacharegcunaga lapanmi infiernucho imayyagpis nacayangapä. Noga nishgäcunata chasquicogcunami isanga cay pasacho mayjina nacarpis gloriaman char ali cawayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Musyashgayquinöpis cachega alimi caycan micuyta gustuta gonanpä. Micuyta gustuta gonanpä cachi ali cashganno gamcunapis runa mayiquiwan cuyanacur ali cawayay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaumpita Jesús aywashpan chargan Judea provinciaman. Nircurna päsargan Jordán mayu simpanman. Saychöpis asca runacuna juntapäyaptinmi Jesús yachasergan imaypis yachasishgannöla. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Saycho yachaycäsiptinmi fariseo runacuna aywaycur lutanta parlasinan cash ali shimilanpa Jesusta tapuyargan: “¿Warminpita runa raquicanmancu o manacu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Saymi Jesús nergan: “Moisés guelgashgancho ¿imatatä nican?” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sayno niptinmi fariseucuna niyargan: “Moisés yachasergan pipis warminpita raquicayta munarga papilta firmaparcur raquicänanpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Saymi Jesús nergan: “Moisés sayno yachasergan runacuna mana cäsucog cayaptinmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Musyashgansinöpis Tayta Diosninsimi cay pasata camar olgutawan warmita camargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘Sayno captinmi warmita ashir runa promitin mana raquicaypa tänanpä. Saymi majasacarna mamanpa taytanpa maquincho caycashganpita runa yargucun warminwan tänanpä. Warminwan tarnami jäpa carpis paywan say castalana ricacun.’ Sayno cananpä Tayta Dios nicaptenga mananami ishcay castanasu caycäyan, sinöga juc castalanami caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Saymi Tayta Diosninsi juclasashgantaga pipis raquinmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Saypita posädacuyashgan wayicho caycarnami discïpuluncuna Jesusta tapuyargan say yachasishganpita. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tapuyaptin Jesús nergan: “Pï runapis warminpita raquicarcur juc warmiwan targa adulteriuchömi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Saynöla pï warmipis runanpita raquicarcur juc runawan targa adulteriuchömi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Saypitanami wamracunata Jesús cagman apayargan umanman maquinta churaycur Tayta Diosta manacunanpä. Wamracunata apaycagta ricarmi discïpuluncuna michäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Saymi discïpuluncunata Jesús olgutupargan: “Wamracunata apacayämunanta ama michäyaysu. Wamrano cagcunami Tayta Diospa naupanman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pipis Tayta Diosninsipa naupanman chayta munarga papänin nishganta wamra criyishganno Tayta Diosninsi nishganta criyisun. Wamrano criyegcunalami Tayta Diospa naupanman changa.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nircurnami saycho caycag wamracunata margarcur margarcur umanta yataycushpan Tayta Diosninsita manacorgan paycunata yanapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Saypita Jesús aywacunanpäna caycaptinmi juc magta cörriyla chargan Jesús cagman. Paymi gongurpacuycur nergan: “Gam imaycatapis musyanquimi, taytay. Saymi tapuculäshayqui. ¿Imatatä ruräman Tayta Diospa naupanman chänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Saymi Jesús nergan: “¿Imanirtä yarpanqui lapantapis musyashgäta? Tayta Diosnilansimi lapantapis musyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tayta Diosninsipa naupanman chänayquipäga paypa mandamientucunata cumpliy. Musyanquimi mandamientucuna cayno nishganta: ‘Ama adulteriucho canquisu. Runa mayiquita ama wanusinquisu. Ama suwacunquisu. Manacagtaga ama pitapis tumpanquisu. Runa mayiquita ama lulapanquisu. Mamayquitawan taytayquita ali ricanqui.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Niptin say magta nergan: “Saycunataga wamra cashgäpita-pasami lapanta cumplishcä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sayno niptin Jesús cuyapar ricärishpan nergan: “Lapanta cumpliycarpis Tayta Diospa naupanman chänayquipäga jucrämi pishëshunqui ruranayquipä. Lapan imayquicunatapis ranticuycur guellayta muchogcunata aypuy. Nircur nogawan aywashun yachasishgäta yachacunayquipä. Sayno rurashpayquega gloriaman riquëzayquita churacognömi caycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sayno niptinmi segaypa rïcu car say magta laquish aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sauraga saycho caycag runacunata ricärishpan discïpuluncunata Jesús nergan: “¡Ajami caycan rïcu runacuna Tayta Diospa naupanman chäyänanpäga!” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesús parlashganta wiyarmi discïpuluncuna mansacashno ricacuyargan. Saymi Jesús yapay nergan: “¡Ajami caycan rïcu runacuna Tayta Diospa naupanman chäyänanpäga! ");
INSERT INTO qvhNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Auja uchcupa camëllo päsayta mana camäpacushganno rïcu runapis quiquilanpitaga Tayta Diospa naupanman chayta manami camäpacunsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sayno niptin discïpuluncuna segaypa mansacash quiquinpura parlayargan: “Sayno captenga ¿pirä salvaconga?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Saymi paycunata ricärishpan Jesús nergan: “Quiquilanpitaga runacuna manami salvacuyta camäpacuyansu. Tayta Dioslami pitapis salvan. Saymi Tayta Diosninsipäga imapis ajasu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Saymi Pedro nergan: “Nogacunaga lapantami imaycätapis cachariyashcä gamta gatiräyänäpä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Sayno niptin Jesús nergan: “Noga munashgäta ruranan cash y Tayta Diosninsipa wilacuyninta wilacunan cash pipis wauguincunata, panincunata, mamanta, taytanta, surincunata, wayinta o chacrancunatapis cachareg cäga cay pasacho pachac (100) cuti mastami chasquengapä. Saynöpami paninpis, wauguinpis, mamanpis, taytanpis, chacrancunapis y wayincunapis paypa canga. Isanga wilacuynëta wilacushganpita runacuna chiquiyangapämi. Sayno captinpis Tayta Diospa naupanman char imayyagpis cushishmi cawangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Waquin runacuna, rïcu cashganpita respitädu carpis, gloriaman manami chäyangasu. Waquin runacunami isanga, mana cäsush pobri carpis, gloriaman char cushicuyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nircurnami Jerusalenpa aywar discïpuluncunapa puntanta Jesús aywaycargan. Jerusalén autoridäcuna Jesusta wanusiyta munaycashganta musyarmi discïpuluncuna y paywan waquin aywagcunapis mansariycar aywayargan. Sayno caycäyashganta ricarmi chunca ishcay (12) acrashgan cag discïpuluncunata jucläman Jesús gayargan. Nircurmi ima päsananpä cashgantapis wilargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Musyayanquimi Jerusalenpa aywaycashgansita. Saychömi mandag cüracuna y Moisés guelgashganta yachasegcunapis nogata prësu sariyämanga. Nircurmi wanusimänanpä mana Israel runacunapa maquinman entregayämanga. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Paycunami asipäyämanga, togapäyämanga y astayämangapis. Sayno nacarcasiyämarmi wanusiyämangapä. Sayno captinpis quimsa junagtaga cawarimushämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sauraga Jesusman aywaycur Zebedeupa surincuna Santiaguwan Juan niyargan: “Ruwacuyäläshayqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sayno niyaptin Jesús nergan: “Captenga alicher canman.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Saymi paycuna niyargan: “Mandag canayquipä Tayta Dios churashuptiqui gamta mandäsiyänäpä nogacunata churaycalämay, taytay. Jucnëta jamaycasilämanqui derëchayqui cagman y jucnëtana isogniqui cagman.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Saymi Jesús nergan: “Gamcunaga mana tantyacuypachä manacaycäyämanqui. ¿Gamcuna awantayanquimansurä nogata nacasimashganno nacasiyäshuptiqui? ¿Päsamänanpä caycashganta gamcuna päsayanquimansurä?” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Saymi paycuna niyargan: “Au, awantayäshämi.” Sayno niyaptin Jesús nergan: “Rasunpaypami noga nacashgäno gamcunapis nacayanquipä y päsamashganno päsayäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sayno captinpis isognëman y derëchämanga pitapis jamasishä Tayta Dios nimashgan caglatami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiaguwan Juan manacuyashganta wiyarmi waquin cag discïpuluncuna rabianäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Saymi discïpuluncunata gayaycur Jesús nergan: “Gamcuna musyayashgayquinöpis nación mandag runacunaga mandag cayninman atiënicuycur runacunata mandayan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Gamcunachöga manami sayno canmansu. Saypa trucanga waquin runacunapita más ali ricash cayta munarga runa mayiquita ashmaynöla yanapäyay. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Manami runacunata munashgäta rurasinäpäsu noga shamushcä, sinöga runacunata yanapänäpämi shamushcä. Saynöpis shamushcä runacuna-raycu wanur salvanäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Saypitanami discïpuluncunawan Jesús chäyargan Jericó marcaman. Discïpuluncunawan y más asca runacunawan Jericöpita yarguycaptinmi Timeupa surin Bartimeo caridäta manacur nänicho jamaraycargan. Payga gaprami cargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Nazaretpita cag Jesús päsaycan” nir wilayaptinmi gayacur nergan: “¡Rey Davidpa castan Jesús, cuyapaycalämay!” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sayno gayacuptinmi runacuna olgutupäyargan upälacunanpä. Sayno olgutupäyaptinpis masrämi gayacorgan: “¡Rey Davidpa castan Jesús, cuyapaycalämay, ari!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sayno gayacushganta wiyarmi Jesusga ichisquergan. Nircur gayasiptin aywagcuna Bartimeuta niyargan: “Upälacuyna. Jesusmi gayaycäshunqui. Jucla aywashun.” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Sauraga jucla sharcurcur punchunta jitariycushpan Jesús cagman cushish aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chaycuptinna Jesús taporgan: “¿Imacho yanapänätatä munaycanqui?” nir. Saymi Bartimeo nergan: “¡Nawë ricanantami munaycä, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Niptin Jesús nergan: “Yäracamayniquipami canan nawiqui ricangana.” Sayno niptinmi jinan höra Bartimeupa nawincuna ricarganna. Ricarnami Jesusta gaticurcur aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalenman manarä charmi Olivos lömacho caycag Betfagé y Betania marcacunaman chäyänanpäna caycar ishcay discïpuluncunata Jesús puntata cachargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Aywayay Betfagé marcaman. Sayman charnami tariyanquipä pipis manarä muntacushgan malta ashnu wataraycagta. Sayta pascarir apayämunqui. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Saycho pipis: ‘Ashnöta ¿imanirtä pascaycäyanqui?’ niyäshuptiquega: ‘Señor Jesusmi nistaycan muntacunanpä. Rätumanpaypami cutirasiyämushä’ niyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Saymi discïpuluncuna aywar tariyargan Jesús nishgannöla wayi puncucho malta ashnu wataraycagta. Nircurna apananpä pascayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pascaycagta ricaycurmi saycho caycag runacuna tapuyargan: “¿Imanirtä ashnuta pascaycäyanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sayno niptinmi discïpulucuna niyargan Jesús yachasishgannöla. Sayno niyaptin: “Sauraga apay, ari” nergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Saymi ashnuta janchacurcur Jesús caycashgan cagman cutiyargan. Chaycasirna punchuncunata ashnuman carunarcuyaptinmi Jesús muntacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Muntash aywaptinnami runacuna cushicuyashpan jacuncunata punchuncunata aywashgan näniman mashtayargan. Waquinna palmata muturir muturir näniman mashtayargan payta cushish chasquicuyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Saymi puntanta aywagcuna y guepanta aywagcunapis cushicuyashpan niyargan: “¡Tayta Diosninsi cachamushgan mandamagninsi caychönami caycan! ");
INSERT INTO qvhNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Paymi David castapita mandamagninsi rey caycan! ¡Tayta Diosninsi imayyagpis alabash cayculäsun!” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalenman charna Jesús aywargan templo patiuman. Saycho ricapacusquirmi tardina captin chunca ishcay (12) acrashgan cag discïpuluncunawan cutergan Betania marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Waraynin tuta Betaniapita Jerusalenman Jesús cutiycarmi micanargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sauraga carupita ricargan jïgus jacha asca raprayog caycämogta. Saymi wayuynin cashganta yarpar aywargan palananpä. Chänanpäga manashi wayuynin cargansu manarä tiempun captin. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Saymi Jesús nergan jïgus jachata: “¡Cananpitaga manami imaypis wayunquipänasu!” Sayno nishgantami discïpuluncuna wiyayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Saypita Jerusalenman chashpanna templo patiuman yaycorgan. Saychönami ranticogcunata y rantegcunatapis gargorgan. Saynölami guellay ranticogcunapa mësantapis y paloma ranticogcunapa mësantapis ticwar ushargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Saynöpis runacunata michargan cargancunata templo patiupa mana päsasinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Saypitanami yachasergan: “Tayta Diosninsipa palabranchöga caynömi guelgaraycan: ‘Templöga canga may-say nacionpitapis shamog runacuna nogata manacayämänanpämi.’ Sayno guelgaraycaptenga ¿imanirtä gamcuna ticrasiyashcanqui suwacunapa machayninmanno?” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Templo patiupita runacunata Jesús sayno gargushganta musyarmi mandag cüracuna y Moisés guelgashganta yachasegcuna wilanacuyargan imanöpapis wanusinanpä. Jesús yachasishganta runacuna cushiyash chasquicuyaptinmi paycunata mansar prësu sarisergansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pasa sacaptinnami discïpuluncunawan Jerusalenpita Jesús cuticuyargan posädaräyashganman. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Waraynin tuta Jerusalenman discïpuluncunawan Jesús cutir ricayargan jïgus jacha pasaypa saquishgana caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Saymi jacha saquish caycagta ricaycur Pedro nergan: “Manami wayunquinasu nishgayqui jïgus jachata ricäriy, taytay. Pasaypa saquishgana caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pedro sayno niptin Jesús nergan: “Tayta Diosman yäracuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Lapan shonguyquiwan Tayta Diosman yäracorga gamcunapis mana criyiypä cag milagrucunatami rurayanquipä. Tagay jircata witicunanpä niyaptiquipis witicongami. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lapan shonguyquiwan yäracur Tayta Diosta manacorga criyinqui chasquinayquipä cashganta. Sayno criyerga rasunpaypami chasquiyanqui manacuyashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Saynöpis Tayta Diosta manacuycashgayqui höra piwanpis resientisinacush cashgayquita yarparga ayway perdonanayquipä. Sayno perdonayaptiquega gamcunatapis jusalicuyashgayquita Tayta Diosninsi perdonayäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Runa mayiquita mana perdonayaptiquega Tayta Diosninsi manami gamcunatapis jusalicuyashgayquita perdonayäshunquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Saypita discïpuluncunawan Jesús chargan Jerusalenman. Templo patiucho Jesús puriycaptin payman shayämorgan mandag cüracuna, Moisés guelgashganta yachasegcuna y Israel mayor runacunapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Paycunami Jesusta tapuyargan: “Gamga ¿ima munayniquiwantä templo patiucho ranticogcunata gargushcanqui? ¿Pitä nishushcanqui sayno gargunayquipä?” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Sayno tapuptinmi paycunatapis Jesús taporgan: “Gamcunatapis canan tapuyäshayqui. ¿Pitä Juanta cachamorgan bautizananpä? ¿Tayta Diosninsicu o runacunacu? Tapushgäta niyämaptiquega nogapis wilashayquimi pipa munayninwan templo patiupita gargushgätapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sayno niptinmi quiquinpura wilanacuyargan: “Ama nishunsu Tayta Diosninsi cachamushganta. ‘Tayta Diosninsimi cachamush’ nishgaga: ‘¿Imanirtä criyiyargayquisu?’ nimäshunmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Saynöpis ama nishunsu runacuna cachayämushganta. Sayno nishgaga runacuna samgarpis ushaycamashwanmi. Lapanmi yarpäyan Tayta Diospa wilacognin Juan cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sayno wilanacurcurmi paycuna niyargan: “Manami musyayäsu pï cachamushgantapis.” Sayno niyaptinmi Jesús nergan: “Gamcunapis mana wilaycäyämaptiquega nogapis manami wiläsu pipa munayninwan templo patiupita ranticogcunata gargushgätapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Saypita Jesús tincusiypa yachasergan: “Juc runashi juc chacra üvata plantargan. Nircurnashi uywacuna mana yaycunanpä guenchasergan. Saypitanashi üva jarucuna pözutapis jinan chacracho rurasergan. Nircurnashi suclatapis rurasergan üvata täpananpä. Lapanta ruraycasirnashi chacra arog runacunata arrendacuycur juclä marcapa aywacorgan saycho tänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cosëcha galaycuptinnashi cachargan juc ashmayninta üva chacra arrindunpita cobramunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Say ashmay chaptinshi fiyupa magarcur jinaylata gargusquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jinayla cutiycuptinnashi chacrayog yapay juc ashmaynintana cachargan. Say ashmaytapis chacraman chagta ashliyargan y magar umantapis rachiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sayno ruraptinpis yapayshi cachargan más juc ashmayninta. Paytaga wanusiyarganshi. Saynölashi rurayargan waquin cachacushgancunatapis. Waquintashi magayargan y waquintanashi wanusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Lapan ashmaynincuna ushacaptinnashi juclaylana cargan cachananpä. Payga cargan japalan cuyay surinshi. Ultimutaga say cuyay surintanashi cachargan: ‘Surëtaga chasquicuyangami’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sayshi say surin chaycuptinna chacra arrendagcuna wilanacuyargan: ‘Tagaymi cay chacrawan quëdananpä caycan. Nogansipäna cay chacra cananpä payta wanuriycasishun.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sayshi chaycuptin üva chacrapita jucläman jorgurir wilanacuyashgannöla wanusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sayno rurayashganpita say üva chacrayöga ¿imatarä ruranga say chacrata guechuyta munag runacunata? ¿Manasurä say fiyu runacunata lapanta wanusir ushanga? Nircorga chacrantapis juctanami arrendacuycongapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sayno päsayäshunayquita mana munayashpayquega Tayta Diosninsipa palabrancho cayno guelgaraycashganta tantyacuyay: ‘Wayi sharcasegcuna: “Manami alisu cay rumi” nir jitariycuyaptinpis wayi esquïnaman cimientupä say rumi churashganami caycan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cimiento cananpäga Tayta Diosninsimi churash. Sayno churash captinmi cushicuypä caycan.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sayno tincusiypa Jesús yachasiptinmi mandag cüracuna, Moisés guelgashganta yachasegcuna y waquin Israel mayor runacunapis tantyayargan tumasipaylapa paycunata Jesús sayno nicashganta. Saymi Jesusta prësu sariyta munarpis asca runacuna favornin cayaptin mansapäyashpan aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Saypita say autoridäcuna cachayargan fariseucunata y Herodispa favornin cag runacunatapis Jesús cagman ali shimilanpa lutanta parlasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Saymi Jesusman chaycur niyargan: “Nogacuna musyayämi rasun caglata imatapis parlashgayquita, taytay. Yachagtapis mana yachagtapis Diospa wilacuynin nishgannöla yachasinqui. ¿Romacho emperador Cesarpä impuestuta pägashwancu o manacu?” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lutanta parlasinanpä tapuyashganta tantyarmi Jesús nergan: “¿Imanirtä lutanta parlasimayta munayanqui? Mä apamuy guellayta ricanäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Guellayta ricaycurnami nergan: “Cay guellaycho ¿pï runapa reträtuntä caycan? Saynöpis ¿pipa jutintä guelgaraycan?” Sayno tapuptin niyargan: “Emperador Cesarpami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Saymi Jesús nergan: “Emperador Cesarpa cagta Cesarta goycuyay. Tayta Diospa cagtaga Tayta Diosninsita goycuyay.” Sayno niptinmi tapogcuna imaniytapis camäpacuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saypitami saduceo runacunapis Jesusman aywayargan pay yachasishganta manacagman churananpä. Saymi Jesusta niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Moisés guelgashgancho caynömi nican, taytay: ‘Warmiyog runa suriynag wanuptin shulca wauguin cuñädan viüdawan täsun. Saynöpami wamrancuna say wanog cag runapa surinnöna cayanga.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sayno captenga tapucushayqui, taytay. Juc marcachöshi ganchis wauguicuna cayargan. Mayor cagshi juc warmiwan targan. Sayshi manarä surin captin wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sauraga shulca cag wauguinnashi targan say viüdawan. Paypis surin manarä captinshi wanorgan. Saypita más shulcan cagna targan say viüdawan. Paypis wanorgan surin manarä captinshi. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Saynöla lapan wauguincuna say viüdawan täyargan. Suriynagla lapanpis wanuyargan. Saypitanashi say viüdapis wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wanushcunata Tayta Diosninsi cawarisimunan junäga say warmilachi ganchis wauguipa warmin canga.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sayno niyaptinmi Jesús nergan: “Sayno niyashpayquega gamcuna manami tantyayanquisu Tayta Diospa palabrancho guelgaraycashganta. Saynöpis manami tantyayanquisu wanushcunata cawarisimunanpä Tayta Dios munayyog cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanushganpita cawarimorga mananami pipis warmiyog o runayog cangasu, sinöga gloriacho caycag angilcunanölanami majaynagla cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wanushcuna cawariyämunanpä cashgantaga ¿manacu liyiyashcanqui Moisés guelgashganta? Abraham, Isaac y Jacob wanushganpita asca wata guepatarämi Tayta Diosninsi rupaycag shiracapita Moisesta nergan: ‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wanogcuna mana cawariyämunanpä captenga ¿imanöpatä Abrahampa, Isaacpa y Jacobpa Diosnin canman? Sayno caycaptenga ¿imanirtä gamcuna criyiyanquisu wanogcuna cawariyämunanpä cayashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesús ali contestashganta wiyarmi Moisés guelgashganta yachaseg runapis taporgan: “Taytay, ¿maygan mandamientutatä más cäsucushwan?” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sayno tapuptinmi Jesús nergan: “Más cäsucunansipä cag mandamientoga caynömi guelgaraycan: ‘Israel runacuna, wiyayay. Tayta Diosninsega juclaylami. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Shumag tantyacuycur lapan shonguyquiwan y lapan voluntäniquiwan Tayta Diosta cuyay.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Caynöpis guelgaraycanmi: ‘Runa mayiquita lapan shonguyquiwan cuyay.’ Say ishcan mandamientucunata más cumplinansitami Tayta Diosninsi munan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sauraga Moisés guelgashgan leycunata yachaseg runa nergan: “Rasun cagtami nishcanqui, taytay. Rasunpaypapis juclaylami Tayta Diosga. Manami más juc Diosga cansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Saynöpis rasun cagtami nishcanqui más cäsucunansipä cag mandamientucuna maygan cashgantapis. Say ishcay mandamientucunata cumplishgansega uywacunata altarcho rupasishgansipitapis más alimi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sayno niptinmi Jesús nergan: “Alitami nishcanqui. Nishgayquino cawarga Tayta Diosninsipa naupanmanmi chanquipä.” Saypitaga manami pipis tapupayta almitergannasu. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Templo patiucho yachaycäsirmi runacunata Jesús nergan: “¿Imanirtä Moisés guelgashganta yachasegcuna niyan Cristo Davidnöla mandag rey cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Santu Espíritu tantyasiptin quiquin Davidpis caynömi guelgargan: ‘Munaynincho sararämag mandag reyta Tayta Diosninsi caynömi nergan: Jamacamuy derëcha cag naupäman lapan contrayquicunata vincishgäyag.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Sayno nicaptenga ¿imanöpatä Cristoga Davidnöla mandag rey canman quiquin Davidpis mandagnin rey cashganta nicaptenga?” Jesús sayno yachasiptinmi asca runacuna cushish wiyayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Saynöpis Jesús nergan: “Cuidä Moisés guelgashganta yachaseg runacunano cayanquiman. Tayta Dios munashganno cawaycashganta runacuna yarpäyänalanpämi paycunaga puriyan chaqui puntanyag sotänan jatish. Saynöpis más munayan yachasicog cayashganpita pläzacunacho y cällicunachöpis alabash caylatami. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Saynöpis sinagogacunacho alinnin cag bancumanrä jamacuytami munayan. Micunanpä gayasiyaptinpis mësa cagmanrämi jamacuyta munayan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Saynömi viüdacunapa ima pobrëzalantapis apacuyan. Nircurnami alita rurashganta runacuna yarpäyänanpä may rätu Tayta Diosta manacuyan. Sayno rurayashganpitami infiernucho más fiyupa nacayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Saypita templucho Jesús jamaraycargan ofrendacunata winacuyänan naupancho. Saychömi rïcu runacuna saysica guellayta sayman winaycäyagta ricaraycargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Juc muchog viüdapis sayman chaycushpan ishcayla cobri guellayninta winargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Sayta ricar discïpuluncunata gayaycur Jesús nergan: “Rïcu runacunaga winayash pusog guellaylantami. Viüdami isanga pobri caycarpis winash lapan guellayninta, saylana rantipacunanpä caycaptinpis.” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Templupita yargurirna juc discïpulun Jesusta nergan: “¡Cuyaylapä jatusag rumicunawanmi templunsita sharcaycasiyashga, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sayno niyaptin Jesús nergan: “Cay lapan ricaycäyashgayqui cuyaylapä caycaptinpis chipyagmi juchusiyangapä. Manami ni juc rumilapis canan pergaraycashgannöga quëdangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Templo simpan Olivos lömacho jamapagnömi Pedro, Santiago, Juan y Andrés Jesusta tapuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nishgayquinöga ¿imaytä templo juchusish canga, taytay? Sayno cananpäga ¿puntata imatä canga?” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sayno tapuyaptinmi Jesús nergan: “Pipis lutanta mana criyisiyäshunayquipä shumag tantyacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ascagmi shayämonga: ‘Nogaga Cristumi caycä’ niyashpan. Sayno nirmi asca runacunata engañayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","May-say nacioncunachöpis guërra captin y wanusinacuy captin ama mansacäyanquisu. Puntataga saycunalarämi canga. Sayno captinpis cay pasa manarämi ushacangaräsu. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Juc nacionwan juc nacionmi pelyayanga. Saynölami muchuypis terremötupis may-saycho cangapä. Sayno captinpis nacaycuna galaycunalanrämi saycunaga canga. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nogata chasquicayämashgayquipitami autoridäcunamanpis prësu sarircur apayäshunqui. Israel mayiquicunapis contrayqui sharcur sinagogancunacho astayäshunquipä. Nación mandag reycunamanpis apayäshunqui juzgash cayänayquipä. Saychömi wilacuynëta paycunatapis wilapäyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Saynöpami cay pasa manarä ushacaptin may-say nacionchöpis nogapita wilacuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Autoridäcunaman entregayäshuptiquipis ama laquicuyanquisu: ‘¿Imatarä nishä?’ nishpayqui. Paycunapa naupancho imata ninayquipäpis Santu Espiritumi yarpayta goyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nogata chasquicamashganpita chiquirmi wauguintapis autoridäcunaman entregayanga wanusish cananpä. Waquinnami surinta entregayanga wanusish cananpä y waquinnami taytantapis entregayanga wanusish cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nogata chasquicayämashgayquipitami pï-maypis chiquiyäshunquipä. Sayno captinpis wanushgayquiyag noga munashgäno cawarmi Tayta Diospa naupanman chäyanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tayta Diosninsipa profëtan Daniel guelgashgannölami Diosta mana cäsucog runa templo ruriman yaycongapä. (Cay guelgashgäta liyegcunaga shumag tantyacuyäsun.) Say fiyu runa templuman yaycuptin Jerusalén marcapita y Judea provinciacho caycag waquin marcacunapitapis gueshpir aywacuyäsun. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wayi janancho cagcunapis jucla gueshpir aywacuyäsun. Imata jorgunanpäpis wayinman amana yaycuyäsunsu. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chacrancho caycagcunapis jucla gueshpir aywacuyäsun. Ama cutiyäsunsu wayinman trucacunanpä mödanacunata jorgogpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sayno gueshpirmi pasaypa cuyapaypä nacayanga gueshyag warmicuna y iti wawayog warmicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tamya quilacho say gueshpinayqui junag mana cananpä Tayta Diosninsita manacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Say junagcunaga fiyupami runacuna nacayangapä. Cay pasata Tayta Diosninsi camashganpita-pasa manami imaypis sayjinanpaga runacuna nacayashgasu. Saynöpis yapayga mananami sayno nacaycuna cangapänasu. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Acrashgancunata cuyaparmi say nacaycunata Tayta Diosninsi päsasenga. Say nacay junagcunata mana päsasiptenga lapanpis wanurmi ushacäyanman. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Say junagcuna: ‘Tayta Dios cachamushgan Cristo caychömi wacchömi caycan’ niyäshuptiquipis ama criyiyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Saynöpis waquenga: ‘Tayta Dios cachamushgan Cristumi caycä’ o ‘Tayta Diosninsipa profëtanmi caycä’ nir lulacuyashpanmi puriyangapä. Runacunata criyisinan cashmi ima milagrucunatapis rurayanga. Asca runacunata saynöpa engañarpis Tayta Diosman yäracogcunataga manami engañayta camäpacuyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Saycuna manarä captinmi gamcunata wilaycä say lutan yachasicogcunata mana chasquipäyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Cay pasacho fiyupa nacaycuna casquiptinrämi intipis y quilapis sacacurponga. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Saynölami lapan goyllarcunapis shicwayämonga y ciëlupis sucsucyanga. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Saychömi nogata ricayämanga pucutay janancho chipipiycar shamuycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Say junagmi angilnëcunata cachamushä may-saypitapis nogaman yäracamagcunata shuntayämunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Cay yachasishgäta shumag tantyayay. Tamya tiempo galaycuptin musyayanquimi jïgus jacha chinquimunanpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Saynölami say nishgä nacaycuna chämuptin gamcunapis musyayanquipä cutimunäpäna caycashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Canan cawaycag runacuna manarä wanuyaptinmi lapan say nishgäcuna cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ciëlupis y cay pasa ushacaptinpis noga nishgäcunaga lapanmi cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Imay junag imay höra cutimunäpä cashgantaga manami angilcunapis ni nogapis musyäsu. Saytaga Tayta Dioslami musyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gamcunapis alistacushla car Tayta Diosta imaypis manacuycäyay. Manami musyayanquisu imay cutimunäpä cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Saymi mastapis Jesús nergan: “Juc wayiyog aywacur wayinta ricananpä ashmayninta cachapan imata rurananpä cagtapis yäsircur. Puncu quichapagnintapis tantyasin imay hörapis maya mayala caycänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Saynölami nogapis elagpita cutimushä: pasa sacaycashgan höra, pulan pagas höra, walpa wagay höra o pasa waraycashgan hörapis. Sayno caycaptenga shuyacayämay puestucushla. Manami musyayanquisu imay höra cutimunäpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Maya mayala caycaptiquega elagpita shamur jusalicuycagta manami tarishayquisu. ");
INSERT INTO qvhNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Manami gamcunalatasu nicä, sinöga lapan runacunatawanmi. Sayno wilaycaptëga maya mayala caycäyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jesús sayno yachasergan Pascua y Levadüraynag Tantata Micunan fiesta galaycunanpä ishcay junag pishiycaptinmi. Say junagmi mandag cüracunawan Moisés guelgashganta yachasegcuna wilanacuyargan runacunata mana musyasiylapa Jesusta sarircur wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sayno wilanacurmi waquin niyargan: “Ama sarishunsu Pascuachöga. Saycho sarishgaga asca runacunami favornin sharcur ticrapämäshun.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania marcachömi Jesús posädaraycargan lepröso niyashgan Simonpa wayincho. Saymanmi juc warmi chargan “alabastro” nishgan rumipita rurashgan botëllanwan perfümin aptash. Say perfümi nardupita rurash carmi selläma chanin cargan. Sauraga mësacho Jesús caycaptin botëllapa shiminta paquirir say perfümita Jesuspa umanman warmi winapargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sayta ricarmi waquin saycho caycagcuna rabiashpan niyargan: “¿Imapätä waläla jichar perdisish say perfümita? ");
INSERT INTO qvhNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sayta ranticushwan cargan juc wata arupacur gänashgansipita maschömi. Nircur say guellaywanna muchogcunata yanapashwan cargan.” Sayno nirmi say warmita jamuräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Saymi Jesús nergan: “Cay warmi alitami ruraycan. Sayno caycaptenga ¿imanirtä payta jamuraycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Imaypis pobricunaga cangami munashgayqui höra yanapäyänayquipä. Nogami isanga gamcunawan cashäpänasu. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmega perfümita winapämar alistaycäman pampash canäpämi. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Perfümita cay warmi winapämashgantaga may-saychöpis musyayangapämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Saypitanami Jesuspa discïpulun Judas Iscariote mandag cüracunaman aywaycur paycunawan wilanacorgan Jesusta entregananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Saymi cüracuna cushicuyashpan aycata pägananpäpis Judasta niyargan. Sayno wilanacurcurmi Judas yarpachacorgan imay höra wilacog cutinanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Levadüraynag Tantata Micunan fiesta y Pascuapis galaycunan junagmi Israel runacuna templucho carnishta pishtayag. Say junagmi discïpuluncuna Jesusta tapuyargan: “¿Maychötä puestucayämushä Pascua merendata micunansipä, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sayno niyaptin Jesús ishcay discïpuluncunata nergan: “Aywayay marcaman. Sayman charnami ricayanquipä juc runa uylunwan yacuta apaycagta. Paypa guepalanta aywayanqui may wayimanpis chashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Saychömi wayiyogta niyanqui: ‘¿Mayninchöshi cuarto caycan discïpuluncunawan Pascua merendata Jesús micunanpä?’ ");
INSERT INTO qvhNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Sayno niyaptiquimi pay ricasiyäshunquipä altuscho pisapacush jatun cuartuta. Say cuartucho merendata puestucuyanqui micunansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sayno niptin aywarmi discïpuluncunaga chäyargan marcaman. Sayman chaycurmi Jesús nishgannöla lapanpis cargan. Say wayichönami paycuna puestucuyargan Pascua merendata. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pasa sacaycaptinnami chunca ishcay (12) acrashgan cag discïpuluncunawan Jesús sayman chäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Saymi micuycäyashgancho Jesús nergan: “Gamcunapita jucniquimi chiquimagnëcunapa maquinman entregamangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Niptin laquicuyashpan jucnin jucnin Jesusta tapuyargan: “¿Nogasurä caycä, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Saymi Jesús nergan: “Nogawan juntu tantata plätucho ushmaseg cagmi chiquimagnëcunapa maquinman entregamangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tayta Diospa palabrancho guelgaraycashgannöla fiyupa nacar wanunäpämi caycä. Nogata entregamag runami isanga juicio finalcho fiyupa laquicongapä. Payga ama yurinmanpissu cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Saypitanami tantata aptarcur Tayta Diosta Jesús manacur agradëcicorgan. Nircurnami paquircur paquircur discïpuluncunata ayporgan: “Cay tantata lapayqui micuyay. Cay tantaga cuerpömi” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Saynölami vïnuyog väsuta aptarcur Tayta Diosta manacur agradëcicorgan. Nircurnami discïpuluncunata macyargan upuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Saypitana paycunata Jesús nergan: “Cay vïnoga yawarnëmi. Yawarnëta jichar wanushgä hörami Tayta Dios mushog conträtuta ruranga pï-maytapis chasquicamagcunata perdonananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yapayga manami vïnuta upushänasu Tayta Diospa naupancho upushgansiyag.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Saypita juc salmuta cantasquir aywayargan Olivos lömaman. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Olivos lömaman chaycurmi Jesús nergan: “Canan sacay lapayqui cachariycamarmi gueshpir aywacuyanquipä. Tayta Diosninsipa palabranchöpis caynömi nican: ‘Uysha misegta wanuycasiptë uyshancuna mashtacarmi aywacuyanga.’ ");
INSERT INTO qvhNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sayno captinpis wanushgäpita cawarircamur gamcunapita más puntatami Galileaman aywashä saycho tincunansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sayno niptinmi Pedro nergan: “Waquin cag cachariyäshuptiquipis nogaga manami cachashayquipäsu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sayno niptinmi Pedruta Jesús nergan: “Canan sacay ishcay cuti cacash manarä cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sayno niptinmi Pedro nergan: “¡Ishcansita wanusimänansi captinpis manami ñëgashayquipäsu, taytay!” Waquin cag discïpuluncunapis saynölami niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Olivos lömacho caycag Getsemaní huertaman discïpuluncunawan chaycurmi Jesús nergan: “Tayta Diosta manacamushgäyag gamcuna caylacho jamaraycäyay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nircur Pedruta, Santiaguta y Juanta más washaläman pushargan. Saychömi fiyupa laquicur nergan: ");
INSERT INTO qvhNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Wanunayparämi laquicuy sarimash. Gamcunapis Tayta Diosta manacushpayqui caylacho shuyaraycäyämay.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Sayno nircurmi más washaläman aywargan Tayta Diosta manacunanpä. Saychömi gongurpacuycorgan urcunpis pampaman töpashganyag. Sayno gongurpacuycurmi Tayta Diosta manacorgan: “Papá, gampäga imapis manami ajasu. Nacanäpä caycashgäpita salvaycalämay. Isanga noga munashgänöga ama casunsu, sinöga gam munashgayquino cayculäsun.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sayno manacushganpita cutishpanmi tarergan quimsan discïpuluncuna punucash caycagta. Saymi Pedruta nergan: “Simón, ¿imanirtä punucash caycanqui? ¿Manacu juc höralapis ricchayta camäpacushcanqui? ");
INSERT INTO qvhNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Punushgayquipita ricchayayna. Diosta manacuyay Satanasta mana cäsupäyänayquipä. Cäsupayta mana munarpis Tayta Diosta mana manacorga cäsupäyanquipämi.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yapay cutiycurmi Jesusga puntata manacushgannöla Tayta Diosta manacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tayta Diosta manacushganpita yapay cutiycur tarergan quimsan discïpuluncuna pasaypa punucash caycagta. Sayno tariycuptinmi discïpuluncuna imaniytapis camäpacuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quimsa cuti Diosta manacushganpita cutirnami paycunata nergan: “¿Cananpis gamcuna jinalacu punuycäyanqui? ¡Ricchayayna! Tayta Diospita shamush captëpis höra chämushganami jusasapa runacunapa maquinman nogata entregayämänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Sharcuyayna! Chiquimagnëcunapa maquinman entregamänanpä cag runa shamuycannami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Discïpuluncunawan Jesús parlaycaptinmi Judas Iscariote chargan asca runacunata pushash. Judasga Jesuspa discïpulunmi cargan. Say runacunami chäyargan espädancuna y garrotincuna aptash. Jesusta prësu sariyänanpä say runacunata cachargan mandag cüracuna, Moisés guelgashganta yachasegcuna y Israel mayor runacunami. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sayman manarä charmi Judasga pushashgan runacunata yäsergan: “Mayganpis musashgä cagmi Jesusga caycan. Payta prësu sariyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Saymi chaycur Judasga Jesusta saludashpan musaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sayno musarcuptinmi Jesusta jucla prësu sarergan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Prësu sariyaptinmi espädanta jorgurishpan juc discïpulun más mandag cürapa ashmayninpa rinrinta waluriycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nircurna say runacunata Jesús nergan: “¿Imanirtä suwa captënöpis gamcuna shayämushcanqui espädayquicunawan y garrotiquicunawanpis prësu sariyämänayquipä? ");
INSERT INTO qvhNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nogaga waran waranmi templo patiucho yachasergä. Saycho caycaptëga ¿imanirtä saychöga prësu sariyämargayquisu? Sayno captinpis prësu sariyämänayquipä gamcuna shayämuptiquimi Tayta Diosninsipa palabrancho nishgannöla cumplicaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesusta prësu sariyaptinnami discïpuluncuna gueshpir aywacuyargan japalanta cachaycur. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Juc magtalami säbanasnin aylushla guepanta gatipargan. Saychömi say magtata sariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sayno sariptin aylurashgan säbanasta logtiriycur say magta garapächula gueshpir aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Saypita Jesusta prësu apayargan más mandag cürapa wayinman. Saymanmi shuntacäyargan mandag cüracuna, Israel mayor runacuna y Moisés guelgashgan leycunata yachasegcunapis. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesusta sayman apayaptinmi caru guepalanta Pedro gatirargan. Más mandag cürapa wayinman chaycur paypis yaycorgan patio rurinyag. Sayman yaycurir templo täpag wardiacunawan jamaraycargan ninacho mashacushpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mandag cüracunawan autoridäcunanaga imanöpapis Jesusta wanusiyänantami munayargan. Sayno captinpis manami ima jusantapis tariyargansu wanusish cananpänöga. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jesuspa contran asca runacuna sharcurpis manami mayganpis juc yarpaylaga niyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Saypitanami waquin runacuna Jesuspa contran sharcur niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nogacuna wiyayashcä cay runa templuta juchurasir quimsa junaglacho juctana sharcasinanpä nishgantami. Saynöpis payga nergan runa mana sharcasishgan templo cananpä cashgantami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jesuspa contran sayno niyaptinpis manami waquin runacuna niyashgancunaman tincorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Saymi más mandag cüra Jesusta taporgan: “¿Manacu imatapis ninqui sayno jitapäshuptiqui? ¿Imanirtä contrayqui sayno parlaycäyan?” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sayno tapuptinpis Jesusga upälalami cacorgan. Saymi más mandag cüra yapay taporgan: “¿Rasunpacu Tayta Dios cachamushgan Cristo caycanqui? Saynöpis ¿rasunpacu Diospa surin caycanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sayno tapuptinmi Jesús nergan: “Au, nishgayquino rasunpaypami caycä. Saymi nogata ricayämanquipä lapanpä munayyog Tayta Diospa derëcha cag naupancho jamaraycagta. Saynöpis pucutay janancho shamuycagtami ricayämanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sayno niptin más mandag cüra fiyupa rabiashpan sotänantapis rachir saycho caycag runacunata nergan: “Sayno nicaptenga ¿imapänatä más testïgutapis ashishun? ");
INSERT INTO qvhNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamcuna wiyayashcanquimi Dios-tucur parlaycashganta. Sayno captenga gamcuna ¿imaniyanquitä?” Sauraga lapan saycho juntaraycag autoridäcunami juc yarpayla niyargan payta wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Saymi Jesusta togapashpan nawinta träpuwan vendaparcur waquin autoridäcuna magayargan: “¡Mä adivinay pï magashushgayquitapis!” niyashpan. Saynölami templo täpag wardiacunapis payta lagyayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Patiucho Pedro caycaptin más mandag cürapa ashmaynin warmi sayman chargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nina sindiycagcho Pedro mashacuycagta ricarmi say warmi nergan: “Gamta ricashcä Nazaretpita cag Jesuswan puriycagtami.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sayno niptin Pedro nergan: “Nogaga manami payta reguësu, ni tantyäsu imapita parlaycashgayquitapis.” Sayno nishpanmi sawan yaycuna puncuman witicorgan. Sayman witicuptinmi cacash cantarcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Saychöpis say ashmay warmi saycho caycag runacunata nergan: “¡Cay runataga Jesuswan puriycagtami ricashcä!” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sayno niptinmi mana reguishganta Pedro yapay nergan. Saypita más rätuta saycho caycag runacuna Pedruta niyargan: “Rasunpaypami gamga paywan pureg caycanqui. Galilea runami canquipis.” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sayno niyaptinmi Jesusta manacagman churashpan jurar Pedro nergan: “¡Say runaga pishi cacunpis! ¡Paytaga manami reguësu!” ");
INSERT INTO qvhNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sayno nicaptinmi cacash yapay cantarcorgan. Cacash cantagta wiyarmi Pedro yarparcorgan Jesús cayno nishganta: “Manarä ishcay cuti cacash cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipä.” Say nishganta yarparcurmi Pedro fiyupa laquicushpan wagargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Saypita pasa waraycaptinnami lapan mandag cüracuna, Israel mayor runacuna, Moisés guelgashgan leycunata yachasegcuna y waquin autoridäcunapis shuntacaycur wilanacuyargan Jesusta wanusiyänanpä. Wilanacurcurnami liyarcur Jesusta apasiyargan Israel nacionpa mandagnin Pilätuman. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sayman chäsiyaptinmi Pilato taporgan: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” Sayno tapuptin Jesús nergan: “Gam nishgayquinölami rasunpaypa caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Saychömi mandag cüracuna Jesuspa contran imaycatapis niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Saymi Pilato yapay taporgan Jesusta: “¿Manacu imatapis ninqui sayjina contrayqui nicäyaptin?” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sayno niptinpis Jesusga manami imatapis parlacorgansu. Saymi Pilätoga imaniytapis camäpacorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada watami Pascuacho Pilato cachareg juc prësuta runacuna manacuyashgan cagta. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Say wata prësu wichgaraycargan Barrabás jutiyog runa. Payga carcilcho wichgaraycargan mandag emperadorpa contran sharcushganpita y runata wanusishganpitami. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Saymi runacuna Pilätuman aywaycur manacuyargan juc prësuta say watapis cacharinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Mandag cüracuna Jesusta chiquir payman apayashganta musyashpanmi Pilato nergan: “¿Israel runacunapa mandagnin rey Jesustacu cacharinäta munayanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sayno niptinmi mandag cüracuna saycho cag runacunata yachasiyargan: “Barrabasta cachariyga” niyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Barrabasta cacharinanpä niyaptin Pilato taporgan lapan runacunata: “Israel runacunapa mandagnin rey Jesustaga ¿imata ruranätatä munayanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sayno tapuptinmi paycuna niyargan: “¡Crucificash casun!” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sayno niyaptinmi Pilato nergan: “Crucificash cananpäga ¿imatatä jusalicush?” Sayno niptin masrä runacuna niyargan: “¡Crucificasiy!” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sauraga Pilato runacunawan ali quëdayta munashpan Barrabasta cacharergan. Nircurna Jesusta astarcasir entregaycorgan crucificash cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Saypita soldäducuna Jesusta apayargan palacio patiuman. Saymanmi lapan soldäducuna juntapäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nircurmi payta asipäyänan cash aylupäyargan rey jaticunan puca-chiclu cäpata. Saynöpis cashapita awash corönata umanman jatipäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sayno jatiparcurmi niyargan: “¡Alabash casun Israel runacunapa mandagnin rey!” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Saypitana say soldäducuna trucapänacuypa gueruwan Jesusta umacho wiruyargan. Nircurmi togapashpan respitag-tucur puntanman gongurpacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sayno asiparcurmi aylupashgan puca-chiclu cäpata logtiparcur quiquinpa mödanantana Jesusta jatipäyargan. Nircurmi crucificayänanpä apayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesusta crucificayänanpä apaycarmi Cirene marcapita Simonwan tincuyargan. Payga cargan Alejandrupa y Rufupa taytanmi. Paytami Jesús apaycashgan cruzta umrusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nircurnami Jesusta chäsiyargan Gólgota nishgan lömaman. Gólgota ninanga cargan “Calavëra” ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Saychömi mïrra nishgan ayag jachawan vïnuta talusergan Jesusta upusinanpä. Sayno upusiyta munayaptinpis Jesús manami uporgansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nircurnami Jesusta crucificayargan. Crucificarcurnami soldäducuna Jesuspa mödananpä suertita jitayargan mayganpis gänag cag apacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Crucificashgan höra cargan tuta las nuëvinömi. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Saypitanami juc tablaman letrëruta guelgarcur cruzpa puntanman clävayargan. Say letrëruchömi guelgaraycargan: “Cay runaga Israel runacunapa mandagnin reymi” nir. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesús crucificaraycashgan naupanmanmi ishcay suwa runacunatapis crucificayargan, jucnin cagta derëcha cag naupanman y jucagtana isog cag naupanman. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Say suwa runacunawan crucificaptinmi Tayta Diospa palabrancho guelgaraycashgannöla päsargan. Say guelgaraycashganga caynömi nican: “Paytapis fiyu runatanömi runacuna chiquiyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Cruzcho caycashganta ricarmi saypa päsag runacuna Jesusta asipäyargan umanta awishpan: “Templutapis juchurcasir quimsa junaglata sharcasinayquipä cashganta nicarga mä quiquiqui salvacushpayqui cruzpita urämuy, ari” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Saynöpis mandag cüracunawan Moisés guelgashganta yachasegcunapis Jesusta asipäyashpan niyargan: “Waquinta salvarpis ¿imanirtä quiquenga salvacuyta camäpacunsu? ");
INSERT INTO qvhNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel runacunapa mandagnin rey cananpä Tayta Diosninsi cachamushgan Cristo carga mä cruzpita urämusun nogansipis criyinansipä.” Saynölami Jesuspa naupancho crucificaraycag runacunapis payta ashliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pulan junag caycaptinmi pasa sacäcorgan malway intiyag. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Malway inti caycaptinmi Jesús fuertipa nergan: “Eloi, Eloi, ¿lama sabactani?” Say ninanga caycan “Diosnë, Diosnë ¿imanirtä cachariycamashcanqui?” ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sayno nishganta wiyarmi saycho caycag runacuna waquin niyargan: “Tayta Diosninsipa profëtan Eliastami gayacuycan.” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Saymi juc runa gueru puntanman esponjata watarcur pochgog vïnuman ushmasergan. Nircurna Jesusta shogusiyta munargan. Shiminman churapaptinmi juc runa nergan: “Ama shogusiysu. Canan ricashun mä cruzpita jorgunanpä Elías shamunäcush o manacush.” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Saypitana fuertipa gapararcur Jesús päsarporgan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesús wanushgan höra templo rurincho saparag racta cortïna rachicäcorgan janapita urayag. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldäducunapa capitanninnami Jesús wanushganta ricar nergan: “¡Rasunpaypami cay runaga Diospa surin cash!” ");
INSERT INTO qvhNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Say höra waquin warmicunapis carulapita ricaraycäyargan. Paycunawanmi caycargan María Magdalena, shulca cag niyashgan Santiagupa y Josëpa maman María y Salomëpis. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Say warmicunami Galileacho Jesús puriptin yanapar gatiräyargan. Paycunawanmi waquin warmicunapis saycho caycäyargan. Say warmicunaga Galileapita Jerusalenman Jesús aywaptin paywan aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesús wanorgan viernes tardimi. Cada viernes tardimi Israel runacuna puestucuyag sábado jamay junagpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Say junag inti jegaycaptinnami Arimatea marcapita cag José aywargan Pilato cagman. Chaycurmi cayno manacorgan: “Jesuspa ayanta cachapaycalämay pampag apanäpä.” José cargan Israel runacunapa autoridäninmi. Payga shuyaraycargan Tayta Diosninsi promitishgannöla salvadorta cachamunanpä cashgantami. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ayata cachapänanpä manacuptinmi Pilato yarpachacorgan: “¿Wanushganasurä o manasurä?” nishpan. Sauraga capitanta gayasergan wanushganta o manarä wanushgantapis tapunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jesús wanushgana caycashganta wilaptinmi say capitanta mandargan Jesuspa ayanta entregananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Saymi José aywargan lïnupita rurash fïnu säbanasta rantimunanpä. Nircurnami cruzpita jorgurir Jesuspa ayanta say tëlawan wancorgan. Sayno rurarcurmi pampag apargan gagacho uchcush sepultüraman. Aywacunanpänami sepultürapa puncunta sapargan jatuncaray rumiwan. ");
INSERT INTO qvhNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mayman pampashgantapis musyananpämi María Magdalena y Josëpa maman Mariapis carulapita ricaycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado jamay junag päsariptin pasa sacaycaptinnami María Magdalena, Santiagupa maman María y Salomëpis mushcog perfümita rantiyämorgan Jesuspa ayanman winapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo tuta inti jegaycämuptinnami Jesús pamparashganman aywayargan ayanta ricayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aywayashpanmi paycuna niyargan: “¿Pirä sepultüra saparag rumita quichapämäshun?” ");
INSERT INTO qvhNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sepultüraman chaycurnami ricayargan saparag rumi quicharaycagta. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Saymi sepultüra rurinman yaycuycur ricayargan juc magta yurag mödanash jamaraycagta. Payga jamaraycargan Jesuspa ayanta sutayashgan derëcha cag naupanchömi. Payta ricaycurmi pasaypa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Saymi say magta paycunata nergan: “Ama mansayämaysu. Musyämi crucificaypa wanusishgan Jesusta ricag shayämushgayquita. Payga manami caychönasu caycan, sinöga cawarimushganami. Masqui ricayay, sutarashgancho mananami cannasu.” ");
INSERT INTO qvhNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nircurnami say warmicunata nergan: “Cananga aywayay waquin discïpulucunatawan Pedruta wilanayquipä: ‘Manarä wanur niyäshushgayquinölami Jesús Galileaman naupaycan paywan saycho tincunayquipä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sayno niptinmi warmicuna jucla aywacuyargan mansacaywan sucsucyaycar. Mansacäyashpanmi ricashgancunata pitapis wilapäyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo tuta Jesús cawarimur puntata yuripargan María Magdalenata. Paypitami naupata Jesús gargorgan ganchis supaycunata. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yuriparcuptinmi María aywar wilargan Jesuspa discïpuluncunata. Chänanpäga paycuna Jesús wanushganpitami laquish wagaycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Saymi María chaycur Jesús cawarimushganta wilapaptinpis paycuna criyiyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Saypitanami Jesuspa ishcay discïpuluncuna Jerusalenpita aywaycäyaptin Jesús tariparcur paycunawan juntu aywargan say nänipa. Say discïpuluncunaga manami tantyayargansu Jesús cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Saypita pay cashganta reguircurnami Jerusalenman cutergan discípulu mayincunata Jesús yuripashganta wilayänanpä. Jerusalenman chaycur wilayaptinpis manami criyiyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Saypitanami Jesús yuripargan chunca juc (11) acrashgan discïpuluncunata mësacho micur jamaraycäyaptin. Yuriparcurmi nergan: “Yäracuyniynag runacuna, cawarimushgäta wilayäshuptiqui ¿imanirtä criyiyashcanquisu? ");
INSERT INTO qvhNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cananpitaga may-saypapis aywayay lapan runacunata ali wilacuynëta wilapäyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mayganpis chasquicamar bautizacorga salvashmi canga. Mana chasquicamagcunami isanga infiernuman gaycush cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Runacuna tantyacuyänanpäga milagrucunapis cayangapämi. Saymi nogaman yäracamagcuna jutëcho supaycunata gargonga y juc idiömacunatapis parlanga. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Culebra picaptinpis, venënuta garaptinpis manami wanuyangapäsu. Saynölami gueshyaycagcunapa jananman maquinta churar Tayta Diosta manacuptin aliyäyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Discïpuluncunata parlapayta ushasquiptinmi Jesucristuta Tayta Diosninsi gloriaman pushacorgan. Nircurna derëcha cag lädunman Tayta Dios jamasergan mandag cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Saypita discïpuluncuna may-saychöpis wilacuyargan Jesucristupa wilacuyninta. Paycuna wilacuyaptinmi Jesucristo ali yanapargan milagrucunatapis rurayänanpä. Sayta ricarmi runacuna tantyacuyargan say wilacushgan Jesucristupa wilacuynin rasunpaypa cashganta. Amén.");
INSERT INTO qvhNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Cuyay waugui Teófilo: Noga Lucasmi cay libruta Jesucristupita gampä guelgamö. Jesucristo wilacuyta galaycushganpita-pasami lapan rurashgancunata apostolnincuna ricayargan. Ricayashganta wilacuyänanpämi apostolnincunata Jesús cachargan. Paycuna wilacuyaptinmi wiyagcuna Jesuspita ascag guelgayash. Saymi nogapis cay libruta guelgä, galaycushganpita-pasa imano cashgantapis shumag tapucurcur. Saynöpami Jesucristupita yachasiyäshushgayquita más tantyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Israel nacioncho Herodes mandag rey caycänan wisanmi juc cüra cargan Zacarías jutiyog. Paymi cargan Abías cürapa castan. Zacariaspa warminmi cargan Elisabet. Paypa taytanpis cürami cargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paycunaga Tayta Diosninsi mandashgancunata cumplirmi imaypis cawayag. Saymi paycunapäga washanta pipis parlayagsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ishcanpis chachanami cayargan. Chacwanyashganyagpis Elisabetpa wawan manami cargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Saypitami Zacariaspa y cüra mayincunapapis turnun chämuptinna Jerusalenman aywayargan templucho Tayta Diosninsita sirviyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Saychömi imaypis rurayashganno suertitarä jitayargan maygan cürapis templuman incienso rupaseg yaycuyänanpä. Saymi suerti yargamorgan Zacariaspä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sauraga Zacarías templo rurinman yaycuycur inciensuta rupasishganyagmi lapan runacuna Tayta Diosta manacuycäyargan templo patiucho. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Templucho inciensuta rupaycäsiptinmi altarpa derëcha cag läduncho Tayta Diosninsipa angilnin Zacariasta yuripargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Say angilta ricaycurmi Zacarías fiyupa mansacargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Saymi ángil cayno nergan: “Zacarías, ama mansamaysu. Tayta Diosninsimi wiyashushcanqui manacushgayquita. Saymi warmiqui Elisabet gueshyacongapä olgu wamrata. Paypa jutinta churapanqui Juan cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Suriqui yuriycuptinmi fiyupa cushicunquipä. Saynöpis lapan runacunami cushicuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tayta Diosninsipa wilacuyninta wilacogmi suriqui cangapä. Manami vïnuta ni ima shincäsicogcunatapis upongasu. “Mamanpa pachancho cashganpita-pasami Santu Espíritu payta yanapangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Saymi Diospa wilacuyninta wilacuptin Israel runacuna jusancunata cacharir Tayta Diosninsi munashganno cawayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tayta Diosninsipa profëtan Elías wilacushgannömi paypis wilacongapä. Saynömi runacunata yäsenga wayinchöpis cuyanacur cawayänanpä. Jusalicur cawacogcunatami yäsenga Tayta Diosninsi munashgannöna cawayänanpä. Saynöpami runacunata yachasenga Cristo shamuptin ali chasquicuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ángil sayno niptinmi Zacarías taporgan: “¿Imanöpatä musyäman nimashgayquicuna rasunpaypa cashganta? Nogaga auquinnami cä. Saynömi warmëpis chacwanna caycan. Sayno caycaptëga ¿imanöpatä surë canman?” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Saymi ángil nergan: “Tayta Diosninsipa wilacognin Gabrielmi caycä. Paymi cachamash suriqui yurinanpä cashganta wilanäpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cay wilashgäcunaga lapanpis cumplengapämi. Nishgäcunata mana criyishgayquipitami cananga shimiqui watpash cangapä suriqui yurishganyag.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sayyagmi templo patiucho runacuna shuyaraycäyargan: “¿Imanirtä cay hörayag Zacarías yargamunsu?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Saymi templupita yargarcamurna shimin watpash captin sëñalapana tantyasergan shuyaraycagcunata. Sauraga shuyaraycagcuna tantyayargan templo rurincho imapis yuripashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Saypitaga turnunta ushasquirnami wayinpana Zacarías cuticorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Saypitanami warmin Elisabet gueshyag ricacur pisga quilantin wayinpita mana yarguypa täcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cushicushpanmi nergan: “Tayta Diosmi nogata cuyapämash. Cananpitaga runacuna mananami jamuräyämanganasu wawaynag cashgäpita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet gueshyag ricacushganpita sogta quilatanami Tayta Diosninsi cachamorgan ángil Gabrielta Galilea provinciacho caycag Nazaret marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Saychömi virgen Mariata watucargan. Mariami aunishgana caycargan rey Davidpa castan Josëwan tänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chaycurmi ángil nergan: “¡María! ¡Tayta Diosninsi acrashganmi caycanqui!” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sayno niptinmi María yarpachacorgan: “¿Imanirtä sayno niman?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sayno yarpachacuycaptinmi ángil nergan: “María, ama mansamaysu. Tayta Diosninsimi gamta cuyashunqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cananpitaga gueshyagmi ricacunqui. Wawayqui yurenga olgumi. Paypa jutinmi canga Jesús. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payga munayyogmi cangapä. Saymi payta niyanga Diospa surin cashganta. Paytami Tayta Diosninsi churanga mandag rey cananpä, unay castan Davidtano. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paypa maquinchömi Israel runacuna imayyagpis cayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sauraga María taporgan: “Runata manarä reguerga ¿imanöpatä gueshyag ricacöman?” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niptinmi ángil nergan: “Santu Espíritu gamman shamuptinmi Tayta Diosninsipa munayninwan gueshyag ricacunquipä. Saymi wawayquipä runacuna niyanga Diospa surin cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Saynömi castayqui Elisabetpis, chacwanna caycar, gueshyacongapä. Paytami runacuna: ‘Golog warmi’ niyargan. Sogta quilanami payga gueshyag caycan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tayta Diosninsipäga manami imapis ajasu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Saymi María nergan: “Nogaga Tayta Diospa maquinchömi caycä. Sayno captenga pay munashganno cayculäsun.” Saypitanami ángil aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ángil nishganpita waraynincuna María aywargan Judea provincia jircacho caycag marcaman Elisabetta watucananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacariaspa wayinman chaycurmi saludargan Elisabetta. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Saludaptinmi Elisabetpa pachancho caycag wamrapis cuyorgan. Sauraga Santu Espiritupa munayninwanmi Elisabet cushicushpan nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“¡Lapan warmicunapitami Tayta Diosninsi gamta acrashushcanqui! Gueshyag caycashgayqui wawayquita paymi imaypis yanapanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cristupa maman caycar watucamänayquipäga ¿pitä cä noga? ");
INSERT INTO qvhNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludamashgayquita wiyaycur pachächo caycag wawäpis cushicur cuyushmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Tayta Diosninsi nishushgayquita cumplinanpä cashganta criyishgayquipitami imaypis yanapäshunquipä!” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Saymi María nergan: “Lapan shongöwanmi Tayta Diosninsita alabä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Salvacog Tayta Diosninsi acramashganpitami cushicö. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mana merëceg captëpis Tayta Dios cuyapämarmi acramash. Cananpitaga imaypis runacuna niyanga Tayta Dios acramashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Munayyog Tayta Diosninsi alimi ricamash. Paynöga manami pipis cansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pay munashganno cawagcunataga imaypis cuyapanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pipis mana rurashgancunatami payga ruran. Yachag-tucogcunataga manacagmanmi churan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandag cashganpita nación mandagcunatapis gargun. Mana runa-tucogcunatami isanga ali cawayänanpä yanapan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Muchuycho cagcunatami micuyta puestupan. Mana cuyapäcog rïcucunatanami isanga yanapannasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Abrahamta promitishganta cumplirmi paypita miragcunata imaypis yanapan. Saymi Israel runacunata mana gongaylapa cuyapan.” Sayno nirmi Tayta Diosninsita María alabargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabet cagcho quimsa quilano tarcurnami wayinpana María cuticorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetpa quilan tincusquiptinnami olgu wamrata gueshyacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wawayog cananpä Tayta Diosninsi payta yanapashganpitami castancuna y reguinacuyashgancunapis cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Saymi puwag (8) junagyog wamran caycaptin Zacariaspa wayinman paycuna aywayargan wamranpa cuerpunta señalayänanpä. Saychömi taytanpa jutilanta jutisiyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Saymi maman nergan: “¡Manami sayno jutin canmansu, sinöga Juan casun jutenga!” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Elisabet sayno niptinmi waquin runacuna niyargan: “Castayquicuna say jutiyog mana caycaptenga ¿imanirtä munanqui Juan jutin cananta?” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sauraga ima jutita churayänanpäpis sëñalapa Zacariasta tapuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tapuyaptinmi pay manacorgan tacshala tablata saycho guelgananpä. Nircurna saycho guelgargan: “Juanmi jutin canga” nir. Zacariaspis surinpa jutin Juan cananta munaptinmi saycho cag runacuna äyacash ricacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sauraga jinan hörami shimin pashtarcuptin Zacarías Tayta Diosninsita alabargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Saycunata ricaycur lapan reguinacuyashgan cushicuyargan. Say päsashganpitami pï-maypis parlayargan intëru say marcacunacho. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sayta wiyagcuna yarpachacuyargan: “¡Cay wamra winarcur ima munayyogrä cayconga!” Runacuna parlayashgannölami say wamrata Tayta Diosninsi yanapargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Saymi Santu Espíritu tantyasiptin Zacarías nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel runacunata yanapag Tayta Diosninsi alabash cayculäsun. Payga salvamänansipänami caycan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pay munashganno cawag Davidpa castancunapitami munayyog salvador yurengapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sayno cananpämi unaypita-pasa musyasimargansi wilacog profëtancunawan. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Saynöpis musyasimargansi contransicunapita jorgamänansipä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Abrahamta y paypita miragcunatapis promitishgancunataga manami gongashgasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Saymi cananga chiquimagninsicunapa maquincho cashgansipita Tayta Diosninsi jorgamäshun pay munashganno mana mansacuypa waran waran cawanansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacarías sayno niyta ushasquirmi wamrantana nergan: “Cristuta chasquicuyänanpä wilacuptiquimi runacuna musyayanga Tayta Diosninsipa profëtan cashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wilacognin carmi runacunata tantyasinquipä Tayta Diosninsi perdonar salvananpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Runacunata cuyaparmi Tayta Diosninsi Cristuta cachamonga. ");
INSERT INTO qvhNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Saymi Cristo shamur sacäpacushno cawagcunata tantyasengapä jusancunata cacharir Tayta Dios munashgannöna cawayänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Juanga winaylantami Tayta Dios munashganno ali cawargan. Sunyag jircalacho targan Tayta Diosninsipa wilacuyninta Israel runacunata wilapayta galaycushganyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Say wisanmi Augusto jutiyog runa emperador César cargan. Paymi mandargan mandashgan cag nacioncunacho lapan runacuna censacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Say censacuy cargan Cirenio jutiyog runa Siria provinciacho gobernador caycaptin punta cag censacuymi. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Saymi lapan runacuna aywayargan marcancunacho censacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josëpa marcanga Judea provinciacho cag Belenmi cargan. Belén marcaga marcan cargan unay castan rey David saycho yurish captinmi. Saymi Mariawan Josëpis Galilea provinciacho cag Nazaret marcapita Belén marcaman aywayargan censacuyänanpä. Say junagcuna María quilanchönami caycargan gueshyacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belencho caycaptinnami Mariata wachay nanay sarergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maychöpis posädacuyänanpä mana captinmi guechpa wawan yurergan uywacuna punucunalancho. Incharcurnami naupalanman punuycasergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén marcapa naupanchömi uyshayogcuna täpaycäyargan uyshancunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Saymanmi Tayta Diosninsipa angilnin elagpita chipipiycar yuripargan. Sayta ricarmi uysha täpagcuna fiyupa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Saymi ángil nergan: “Ama mansacäyaysu. Tayta Diosninsi cachamushgan Cristumi runacunata salvananpä Davidpa marcancho yurisquishga. Pay yurishganta musyarmi lapan runacuna cushicuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Belenman aywarmi say itita tariyanquipä uywacuna punucunalancho mamanpa naupancho inchash caycagta. Sayno caycagta tarirmi cay nicashgä rasunpaypa cashganta musyayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sayno nicaptinmi elagpita say angilpa naupancho yuriyargan más asca angilcuna Tayta Diosninsita cayno alabar: ");
INSERT INTO qvhNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Ciëlucho Tayta Diosninsi adorash cayculäsun! ¡Cay pasachöpis Tayta Diosninsi cuyashgancunapä ali caway cayculäsun!” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Saypita angilcuna gloriaman cutisquiyaptin uysha täpagcuna jucninpis jucninpis cayno ninacuyargan: “Tayta Diosninsi wilasimashgansino acu aywashun Belenman say itita ricanansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sayno nirmi apurä aywayargan Belén marcaman. Chaycurna tariyargan Josëta, Mariata y itintapis uywacuna punucunalancho caycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sayno tariycurna wilapäyargan itipä ángil wilashgancunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sayno wilapäyaptinmi lapan wiyagcuna cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marianami paycuna niyashgancunata shongulancho yarparag. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ángil wilashgannöla ricaycurmi uysha täpagcuna Tayta Diosninsita alabayashpan cuticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Saypita puwag (8) junagyog caycaptinmi costumbrin cashganno itipa cuerpunta señalasergan. Saychömi jutinta churapargan María manarä gueshyag captin ángil nishgannöla. Say junagpitanami say itipa jutin cargan Jesús. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","María gueshyacushganpita chuscu chunca (40) junagtanami Josëwan aywayargan Jerusalén templuman Moisés guelgashgancho nishganno purificacunanpä. Itintapis templuman apayargan Tayta Diosninsipa munayninman churayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sayta rurargan: “Tayta Diospa munayninman churayay lapan guechpa olgu wamrayquicunata” nir Moisés guelgashgannölami. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Warmicuna gueshyacuyashganpita templuman imata apayänanpäpis caynömi Moisés guelgargan: “Ishcay culcushcunata o ishcay pushapa palomata carpis apayanqui.” Saymi Mariapis say guelgaraycashgannöla saycunata apargan templuman. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Say wisanmi Jerusalencho targan Simeón jutiyog runa. Paymi alilata rurashpan Tayta Diosninsita alabar cawargan. Saynöpis shuyarargan Israel runacuna nacaycäyashganpita Cristo shamur jorgunanpä cashganta. Santu Espiritumi payta musyasergan Cristuta ricaycurrä wanunanpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Templuman aywananpä Santu Espíritu tantyasiptin Simeón aywarmi ricargan Mariawan José itita sayman yaycaycäsegta. Sayman paycuna aywayash cash Moisés guelgashgancunata saycho cumpliyänanpämi. Saymi say itita margarcurna Tayta Diosninsita Simeón alabargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tayta Dios, cananga cumplishcanquinami nimashgayquita. Cananga ricashcänami cachamushgayqui salvadorta. Ricashgächönaga cushishganami wanucushäpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","May-saychöpis tag runacuna musyayangami cay wamrata gam cachamushgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Saymi mana Israel runacunapis tantyayanga runacunata salvanayquipä cashganta. Sayno captinmi gamta alabayäshunqui: ‘¡Imajinanparä Israel runacunata Tayta Diosninsi cuyargan say castacho salvadorninsita cachamunanpä!’ niyashpan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón sayno nishgancunata wiyarmi Josëwan María cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sauraga Tayta Diosninsita Simeón manacorgan paycunata yanapänanpä. Nircurna Mariata nergan: “Cay itita Tayta Diosninsi cachamush captinmi waquin Israel mayinsipis gloriaman chäyangapä. Waquin cagnami infiernuman gaycush cayangapä. Cay iti winarcur Tayta Diosninsipa wilacuyninta wilacuptinmi asca runacuna payta chiquiyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Saynöpami musyacanga runacuna yarpäyashgan ali o mana ali cashganpis. Sayno päsaptinmi gampa shonguyqui tucsishnörä laquicongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Templo patiucho caycargan Tayta Diosninsipa profëtan Ana jutiyog chacwanpis. Paypa taytanmi cargan Fanuel, Aser castapita. Anami wamra jipashla caycar runawan targan. Runawan tashganpita ganchis watalatami runan wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Saymi viüdala cacorgan puwag chunca chuscu (84) wata. Payga pagasta junagtami templucho ayunashpan Tayta Diosninsita manacur cacog. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anapis Jesús caycashgan cagman chaycushpannami payta ricar Tayta Diosninsita manacur agradëcicorgan. Saynöpis Jesuspita wilapargan Tayta Dios cachamushgan Cristuta shuyaraycag runacunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tayta Diosninsipa palabrancho nishgancunata templucho cumplircurnami Josëwan María cuticuyargan Galilea provinciacho Nazaret marcanman. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tayta Diosninsi ali yanapaptinmi winaylanta Jesús más yarpayyog ricacorgan y calpanpis yurergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa maman Mariawan José cada watami Jerusalenman aywayag Pascuapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Saymi Jesús chunca ishcay (12) watayog caycaptinna paywanpis aywayargan say fiestaman. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pascua ushaynami Josëwan María marcanpana cuticuyargan. Jerusalencho Jesús quëdacushgantaga manami cuentata gocuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Saymi waquin runacunawan Jesús aywaycashganta yarpäyashpan juc junag goyati aywayargan. Saypita castancunacho y reguinacuyashganchöpis Jesusta ashir manami tariyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tariycurmi cutiyargan Jerusalenman saycho ashiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cutishganpita waraynin junagrämi Jesusta tariyargan templucho caycagta. Saychömi masta yachacunanpä yachag runacunata tapucur jamaraycargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Shumag tantyaycur tapucushganta wiyarmi lapan wiyagcuna cushicuyargan. Saynöpis cushicuyargan yachag runacuna tapuyashganta Jesús ali contestaptinmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sauraga saycho tariycurmi Josëwan María fiyupa cushicuyargan. Mamanmi nergan: “¿Imanirtä caycho quëdacuycorgayqui? Nogacuna fiyupa laquicurmi gamta ashiyashcä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sayno niptin Jesús nergan: “¿Imanirtä ashiycäyämanqui? ¿Manacu musyayanqui Taytäpa templuncho canäpä cashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sayno niptin paycunaga manami tantyayargansu imanir sayno nicashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nircur Jesuswanna cuticuyargan Nazaretman. Saychömi mamanwan taytan mandashgancunata Jesús rurargan. Mamanga shongulanchömi yarparag lapan ima päsashgancunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Winaylantami Jesús más yachayyog ricacorgan. Saynölami respitösu captin Tayta Diosninsipis y runacunapis payta cuyayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zacariaspa surin Juan sunyag jircacho caycaptinmi Tayta Diosninsi nergan wilacuyninta wilacunanpä. Say wisanmi Tiberio jutiyog runa emperador César caycargan. Paymi chunca pisga (15) watana lapan nacionpa mandagnin caycargan. Saynöpis Poncio-Pilato gobernador caycargan Judea provinciacho. Herodisnami mandag caycargan Galilea provinciacho. Herodispa wauguin Felipe mandag caycargan Iturea y Traconite nishgancho. Saynömi Lisaniaspis mandag caycargan Abiliniacho. Jerusalenchönami Anaswan Caifás más mandag cüra caycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Saymi Jordán mayu naupancho cag marcacunapa Juan purergan wilacushpan: “Tayta Diosninsi perdonayäshunayquipä jusalicuycunata cacharir bautizacuyay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan Bautista manarä yuriptinmi Tayta Diosninsipa profëtan Isaías paypita cayno guelgargan: “Sunyag jircachömi juc runa gayacuypa wilaconga: ‘Mandag runa shamuptin chasquicunayquipä nänita pisar puestucuyashgayquino jusalicuycunata cacharir puestucuyay Tayta Diosninsi shamuptin chasquicuyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sayno puestucuyay ragracunata pampasagno, jircacunata pampasagno, wicsu nänicunata derechagno y uchcu uchcu nänita pampasagnöpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Saynöpami lapan runacuna tantyacuyanga Tayta Diosninsi salvananpä cashganta.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Runacuna bautizacuyänanpä shayämuptinmi Juan nergan: “¡Culebra casta runacuna! ¿Imanirtä gamcuna yarpaycäyanqui jusayog captiquipis Tayta Diosninsi infiernuman mana gaycuyäshunayquipä cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tayta Diosninsi infiernuman mana gaycuyäshunayquipäga jusalicuycunata cacharir pay munashgannöna cawayay. Ama yarpäyaysu Abrahampa castan cayashgalayquipita Tayta Diosninsi salvayäshunayquipä cashganta. Tayta Dios munarga cay rumicunatapis Abrahampa castanman ticrarasinmanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mana ali wayog jachacunata chaquipita muturir ninaman gaycushgansinömi Tayta Diosninsega jusalicogcunata infiernuman gaycunanpä listuna caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juan sayno niptinmi runacuna tapuyargan: “Sauraga ¿imatatä rurayäman salvacuyänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sayno tapuyaptinmi nergan: “Ishcay trucana mödanayog carga jucag cag mödanayquicunata goycuyay mödanaynag cagta. Saynöpis micuyyog carga raquipaycuyay micuyniynag cagta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Saynölami impuestuta cobragcunapis, bautizacunanpä shamur, tapuyargan: “Taytay, nogacunaga ¿imatatä rurayäman salvacuyänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Saymi Juan nergan: “Cobrayänayquipä cashganpita mastaga ama cobrayanquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Saynölami tapuyargan soldäducunapis: “Nogacunaga ¿imatatä rurayäman salvacuyänäpä?” Saymi Juan nergan: “Ama pipa guellaynintapis guechuyanquisu. Sayno ama pitapis manacagtaga tumpanquisu. Aruyashgayquipita chasquiyashgalayquiwan contentacuyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sauraga Cristo cay pasaman shamunanpä cashganta shuyarag runacuna yarpachacuyashpan niyargan: “¿Juansurä Tayta Dios cachamushgan Cristo caycan?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Saymi Juan nergan: “Cristoga sayrämi shamonga. Nogaga yaculawanmi gamcunata bautizä. Tayta Diosninsi cachamushgan Cristumi isanga Santu Espirituwan y ninawanpis bautizayäshunquipä. Nogaga manami payno munayyogsu caycä. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Payga jurquëtan aptashmi caycan trïguta wayrananpä. Nircurmi trïgu cagta churanga wayinman. Y punshan cagtana gayconga imaypis mana upeg ninaman saycho rupananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sayno parlaparmi Juan yachasergan Tayta Diosninsipa wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Saynöpis runacunata Juan nergan: “Wauguin Felipipa warminta suwapar rey Herodes jusalicush. Saynölami más jusatapis payga ruraycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Sayno parlaycashganta musyarmi Juanta prësu sariycasir Herodes wichgasergan carcilman. Sayno wichgasirmi más jusayog ricacush. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Carcilman Juan manarä yaycurmi runacunata bautizaycaptin Jesuspis chargan bautizacunanpä. Bautizacurcur Tayta Diosta manacuycaptinmi ciëlo quichacascamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Saychömi Jesusman Santu Espíritu urämorgan palomano. Saymi ciëlupita wiyacämorgan Tayta Dios cayno nimushgan: “Gamga cuyay surëmi canqui. Noga munashgäno lapanta cumpliptiquimi cushish caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quimsa chunca (30) watayognöna caycar bautizacurcurmi Jesús wilacur galaycorgan Tayta Diosninsipa wilacuyninta. Jesuspäga runacuna yarpäyargan Josëpa surin cashgantami. Josënami Elïpa surin cargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elïmi cargan Matatpa surin. Matatmi cargan Levïpa surin. Levïmi cargan Melquipa surin. Melquimi cargan Janapa surin. Janami cargan Josëpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josëmi cargan Matatiaspa surin. Matatiasmi cargan Amospa surin. Amosmi cargan Nahumpa surin. Nahummi cargan Eslipa surin. Eslimi cargan Nagaipa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaimi cargan Maatpa surin. Maatmi cargan Matatiaspa surin. Matatiasmi cargan Semeipa surin. Semeimi cargan Josëpa surin. Josëmi cargan Judäpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judämi cargan Joanapa surin. Joanami cargan Resapa surin. Resami cargan Zorobabelpa surin. Zorobabelmi cargan Salatielpa surin. Salatielmi cargan Neripa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerimi cargan Melquipa surin. Melquimi cargan Adipa surin. Adimi cargan Cosampa surin. Cosammi cargan Elmodampa surin. Elmodammi cargan Erpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ermi cargan Josuëpa surin. Josuëmi cargan Eliezerpa surin. Eliezermi cargan Jorimpa surin. Jorimmi cargan Matatpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatmi cargan Levïpa surin. Levïmi cargan Simeonpa surin. Simeonmi cargan Judäpa surin. Judämi cargan Josëpa surin. Josëmi cargan Jonanpa surin. Jonanmi cargan Eliaquimpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimmi cargan Meleapa surin. Meleami cargan Mainanpa surin. Mainanmi cargan Matatapa surin. Matatami cargan Natanpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanmi cargan Davidpa surin. Davidmi cargan Isaïpa surin. Isaïmi cargan Obedpa surin. Obedmi cargan Boozpa surin. Boozmi cargan Salmonpa surin. Salmonmi cargan Naasonpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonmi cargan Aminadabpa surin. Aminadabmi cargan Arampa surin. Arammi cargan Esrompa surin. Esrommi cargan Farespa surin. Faresmi cargan Judäpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judämi cargan Jacobpa surin. Jacobmi cargan Isaacpa surin. Isaacmi cargan Abrahampa surin. Abrahammi cargan Tarëpa surin. Tarëmi cargan Nacorpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacormi cargan Serugpa surin. Serugmi cargan Ragaupa surin. Ragaumi cargan Pelegpa surin. Pelegmi cargan Heberpa surin. Hebermi cargan Salapa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salami cargan Cainanpa surin. Cainanmi cargan Arfaxadpa surin. Arfaxadmi cargan Sempa surin. Semmi cargan Noëpa surin. Noëmi cargan Lamecpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecmi cargan Matusalenpa surin. Matusalenmi cargan Enocpa surin. Enocmi cargan Jaredpa surin. Jaredmi cargan Mahalaleelpa surin. Mahalaleelmi cargan Cainanpa surin. ");
INSERT INTO qvhNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanmi cargan Enospa surin. Enosmi cargan Setpa surin. Setmi cargan Adanpa surin. Y Adanmi cargan Tayta Diosninsi camashgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jordán mayucho Jesús bautizacushganpitanami Santu Espíritu payta pushargan sunyag jircaman. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Saychömi chuscu chunca (40) junagnintin Satanás payta camargan jusalicasinanpä. Say junagcuna ayunar manami imatapis micorgansu. Saymi wanunayparä Jesusta micanay saricuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sayno micanaycaptinmi Satanás yuripaycur nergan: “Diospa surin caycarga micunayquipä cay rumita tantaman ticrarasiy, ari.” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sayno niptin Jesús nergan: “Tayta Diospa palabrancho caynömi nican: ‘Manami micuyta micularsu runacuna cawayan, sinöga Tayta Dios nishgancunata cäsucuyashpanpis cawayanmi.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Saypitanami altunnin puntapita Satanás elagpita ricasergan may-say nacioncunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nircurmi nergan: “Gongurpaycur nogata adoramaptiquega cay ricashgayqui nacioncunata y saycho cag riquëzacunatami goycushayqui. Lapan ricashgayquicunataga noga chasquishcä munashgä cagta pitapis goycunäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Saymi Jesús nergan: “¡Witicuy, Satanás! Tayta Diospa palabranchöga caynömi nican: ‘Tayta Dioslatami adoranayqui y pay japalantami sirvinayqui.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Saypitanami elagpita Jesusta Satanás ricacascasergan Jerusalén templo janancho. Saychönami payta nergan: “Diospa surin carga caypita pampaman saltarpuy. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diospa palabranchöga caynömi guelgaraycan: ‘Angilnincunatami Tayta Diosninsi cachamonga maycho captiquipis cuidashunayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Paycunami sariyäshunqui pampaman jegaptiqui ni chaquilayquitapis rumicunaman mana tacacunayquipä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Niptinmi Jesús nergan: “Tayta Diospa palabranchöga caynömi nican: ‘Tayta Diosta ama obligaysu quiquiqui munashgayquita rurasinayquipä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sauraga yarpashganta rurasiyta mana camäpacurcurnami payta cachaycur Satanás aywacorgan yapay cutimunanyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Saypitami Santu Espiritupa munayninwanna Jesús cutergan Galilea provinciaman. Intëru say marcacunachömi paypita runacuna parlayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Say marcacunacho cag sinagogacunacho Jesús yachasiptinmi lapan runacuna: “Ali yachasicogmi payga” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Saypitanami Jesús aywargan naupata tashgan Nazaret marcaman. Saymi imaypis aywashganno sábado jamay junagcho aywargan sinagogaman. Saychönami runacunapa puntanman aywargan Tayta Diosninsipa palabranta liyimunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Saycho liyimunanpämi macyargan profëta Isaías guelgashganta. Saymi liyimorgan: ");
INSERT INTO qvhNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Santu Espiritutami Tayta Dios nogaman cachamush yanapämänanpä. Paymi acrarcamar yanapaycäman muchog runacunaman ali wilacuyta apanäpä. Saynöpis paymi cachamash laquish cagcunata cushisinäpä. Saynöpis cachamash carcilcho cagcuna librina cayänanpä cashganta wilanäpä, gapracunapa nawinta aliyäsinäpä, jucpa maquincho nacaycag runacunata jorgunäpä ");
INSERT INTO qvhNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y Tayta Diosninsita cäsucur ali cawayänanpä cag tiempo chämushgantana wilacunäpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sayno liyircurnami Isaías guelgashganta Jesús cutiycasergan sinagogacho yanapag runata. Cutiycasir jamacuycuptinmi saycho caycag runacuna payta ricaraycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Saymi Jesús nergan: “Say liyimushgäta unay guelgargan noga ruranäpä cagcunapitami. Say guelgaraycashganno cumpliycashgäta gamcuna ricaycäyanquinami.” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sayno niptinmi runacuna Jesuspa contran parlayargan: “¿Imatatä pay musyan sayno parlananpä? ¿Manacu cayga Josëpa surin?” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Saymi Jesús nergan: “Gamcuna capascher yarpaycäyanqui Capernaumcho milagruta rurashgäno cay marcansichöpis milagruta ruranäpä cashganta. Sayno yarpäyashgayquega runacuna cayno niyashgannölami caycan: ‘Jampicog carga quiquiquirä jampicuy.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nircurmi Jesús nergan: “Tayta Diosninsipa profëtancuna quiquinpa marcancho mana chasquish cashgannömi gamcunapis chasquiycäyämanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Yarpäyay Tayta Diosninsipa wilacognin Elías cawanan wisan imano päsashgantapis. Quimsa wata sogta quilantin mana tamyaptin lapan marcacunachöshi muchuy cargan. Say wisan Israel nacioncho asca viüdacuna caycaptinpis Tayta Diosninsi manashi cachargansu Eliasta maygan viüdata yanapänanpäpis. Saypa trucanga cachargan Sidoncho cag Sarepta nishgan marcacho tag viüdalata yanapänanpäshi. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Saynöpis Tayta Diosninsipa wilacognin Eliseo cawanan wisan Israel nacioncho ascagshi cayargan leprawan gueshyaycagcuna. Say gueshyawan ascag gueshyaycäyaptinpis Eliseo manashi aliyäsergansu maygantapis. Siria nacionpita cag Naamantashi isanga aliyäsergan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sauraga Jesús sayno nishganta wiyaycur saycho cagcuna tantyacuyargan paycunapä milagruta rurananpa trucanga juclä marcacunalacho rurananpä cashgantami. Saymi fiyupa rabianäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gaga janancho paycunapa marcan captinmi Jesusta apayargan gaga quilunman saypita tangariyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Saypita tangayänanpä apaycäyaptinmi paycunapa chaupinpita yargurir Jesús aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Saypitami Galilea provinciacho cag Capernaum marcaman Jesús aywargan. Saychömi cada sábado jamay junag runacunata yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jesusga manami waquin yachasegcunanösu yachasergan, sinöga paycunapita más alimi yachasergan. Sayno yachasiptinmi runacuna fiyupa cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Say sinagogachömi caycargan supay löcuyäsishgan runa. Paymi gaparargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¡Nazaret marcapita cag Jesús! ¿Imatatä munanqui nogacunawan? ¿Nogacunata gargayämänayquipäcu shamushcanqui? ¡Noga musyämi Dios cachamushgan Cristo cashgayquita!” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sayno niptinmi Jesús olgutupargan supayta: “¡Upälala cay runapita jucla yarguy!” nir. Sayno niptinmi lapan runacunapa naupancho say runata sagtariycur supay aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sayta ricaycurmi lapan runacuna cushicuyashpan jucninpis jucninpis cayno parlayargan: “¡Imajinanparä munayyog caycan supaycuna payta cäsucuyänanpäga!” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Supayta gargushganta musyarmi lapan marcacunacho runacuna parlayargan Jesús munayyog cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sauraga sinagogapitanami Jesús aywargan Simonpa wayinman. Chänanpämi Simonpa suedran fiebriwan ansa jitaraycargan. Saymi saycho caycag runacuna Jesusta ruwacuyargan payta aliyäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Say fiebrita Jesús olgutupaptinmi Simonpa suedran jinan höra aliyasquergan. Aliyarcurnami micuyta paycunata garargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Saypita inti jegaycaptinnami Jesusman apayargan tucuy-nirag gueshyawan gueshyaycagcunata. Say gueshyagcuna yatayculaptinmi aliyäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Saynömi waquin gueshyagcunapitapis supaycuna yarguyargan cayno gaparäyashpan: “¡Gamga Diospa surinmi canqui!” nir. Tayta Dios cachamushgan Cristo cashganta wilacuyaptinmi supaycunata Jesús olgutupargan imatapis mana parlacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pasa wararcuptinnami marcapita Jesús aywargan sunyagninman. Saymi runacuna ashishpan pay caycashgan cagman chäyargan. Saycho tariycur manacuyargan paycuna cagpita mana aywacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Saymi Jesús nergan: “Waquin marcacunachöpis Tayta Diosninsipa wilacuyninta wilacunämi caycan. Saypämi Tayta Diosninsi cachamash.” ");
INSERT INTO qvhNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Saymi sinagogacunacho may-saychöpis Jesús wilacorgan Tayta Diosninsipa wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","2","Tayta Diosninsipa wilacuyninta Genesaret gochacho asca runacunata yachaycäsishpanmi Jesús ricargan ishcay büquicuna gocha cuchuncho jinayla caycagta. Pescagcunaga büquincunapita yargurirmi rednincunata tagshaycäyargan. Jesús yachasishganta wiyayta munarmi asca runacuna payta quichquiparäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Saymi Simonpa büquinman Jesús wisarcur Simonta manacorgan cuchunpita más washaläman büquinta apananpä. Say büquiman jamaycurmi saypitana runacunata yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachasiyta ushasquirnami Simonta nergan: “Cananga büquiquita apay más chaupi-niragman. Nircur saycho jitay redniquita pescäducunata sariyämunayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sayno niptin Simón nergan: “Warati pescaycarpis manami ni juclaylatapis sariyashcäsu, taytay. Imano captinpis nicämaptiquega yapay jitayäshä rednëta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sayno nirmi redninta jitarcur saysica pescäducunata sariyargan, redninpis rachinashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Saymi jucag büquicho pescag mayincunata guemlacuyargan yanapäyänanpä. Paycuna chaycurmi ishcan büquiman pescäducunata winayargan büquincunapis talpunäyashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Saychömi caycargan Zebedeupa surincuna Santiaguwan Juanpis. Paycunami cayargan Simonpa pescag mayincuna. Saysica pescäducunata sarirmi lapanpis segaypa mansacashno ricacuyargan. Saymi Jesuspa puntanman gongurpacuycur Simón Pedro nergan: “Jusasapa runami cä, taytay. Sayno caycarga manami naupayquichöpis cämansu.” Niptinmi Jesús nergan: “Ama mansacaysu. Pescäduta sarinayquipa trucanga runacunatanami Tayta Diosninsipa wilacuyninta wilapanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sayno niptinmi gocha cuchuncho büquincunata y lapan imancunatapis cachariycuyashpan Jesuswan aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús juc marcacho caycaptinmi chargan leprawan fiyupa gueshyaycag runa. Say runami Jesuspa puntanman gongurpacuycur nergan: “Sänu canäpä aliyaycasilämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sayno ruwacuptinmi Jesús yataycorgan: “Cananpitaga aliyashganami canqui” nir. Sayno nisquiptinmi jinan höra aliyasquergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nircurnami Jesús nergan: “Ama pitapis wilanquisu noga aliyäsishgäta. Saypa trucanga Moisés guelgashgancho nishgannöpis templuman ayway aliyashgana cashgayquita cüra ricashunayquipä. Nircurna Moisés guelgashgancho nishgannöla aliyashgayquipita lapantapis ruranqui. Aliyashgana cashgayquita cüra nishuptiquimi lapanpis musyayanga rasunpaypa aliyashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aliyäsishganta pipis musyananta mana munaycaptinpis may-saychömi runacuna musyayargan. Saymi asca runacuna pay cagman shuntacäyargan yachasishgancunata wiyayänanpä y gueshyaycashganpita aliyäyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesusga imaypis sunyagninmanmi aywag Tayta Diosta manacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc wayicho runacunata Jesús yachaycäsiptinmi saycho jamaraycargan Moisés guelgashganta yachasegcunawan fariseucuna. Paycuna shayämorgan Galilea provinciapita, Judea provinciapita y Jerusalenpitapis. Tayta Diosninsipa munayninwanmi Jesús caycargan gueshyagcunata aliyäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Saymanmi runacuna quirmawan apayargan paralítico runata. Chaycasirmi imaycanöpapis Jesuspa naupanman yaycasiyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Asca runacuna saycho captinmi wayi puncunpa yaycasiyta camäpacuyargansu. Saymi wayi jananman wisarcasir wayi gataraycashganta quichayargan. Nircur wascawan warcuypa quirmantinta uräsiyargan Jesuspa naupanman. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Say runacuna payman yäracuyashganta musyarmi say gueshyaycag runata Jesús nergan: “Lapan jusayquipita perdonashganami caycanqui, hïjo.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sayno niptinmi Moisés guelgashgan leycunata yachasegcunawan fariseucuna yarpachacuyargan: “¿Pitä cay runaga Dios-tucur lutanta parlananpäga? Tayta Dioslami munayyog caycan runacunata perdonananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sayno yarpaycäyashganta musyarmi Jesús taporgan: “¿Imanirtä sayno yarpaycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Maygantä más aja caycan? ¿Runapa jusancunata perdonaycu? ¿O gueshyaycashganta aliyäsiycu? ");
INSERT INTO qvhNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nogami munayyog caycä runapa jusancunata perdonanäpä. Sayta musyayänayquipämi cay runata aliyäsishä.” Nircur say gueshyaycag runata nergan: “¡Sharcuy! Quirmayquita apacurcur wayiquipa aywacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sayno niptinmi jinan höra gueshyaycag runa aliyashgana sharcurcorgan. Nircur quirmanta apacurcur wayinpa aywacorgan Tayta Diosninsita alabashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sayta ricaycurmi runacuna cushicuyashpan Tayta Diosta alabayargan: “¡Cay runa aliyäsishgantanöga manami imaypis ricashcansisu!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Say wayipita Jesús aywaycashganchömi Mateo jutiyog runata ricargan impuestuta cobrar jamaraycagta. Saymi Jesús payta nergan: “Discïpulö canayquipä gatirämay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sayno niptinmi cobracuyta cachariycur Jesuswan Mateo aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Discïpulun cananpä Jesús acrashganpita cushicushpanmi micuyta wayincho Mateo rurasergan discïpuluncunawan Jesús micunanpä. Saychömi impuestuta cobrag mayincunawan waquin runacunapis Jesuswan ascag micuycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Say runacunawan Jesús caycagta ricaycurmi Moisés guelgashganta yachasegcunawan fariseucuna Jesuspa discïpuluncunata niyargan: “¿Imanirtä gamcuna impuesto cobragcunawan y Tayta Diosta mana cäsucogcunawanpis micuyanqui y upuyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sayno niyashganta wiyarmi Jesús nergan: “Gueshyagcuna jampicogta nistäyashgannölami jusasapacunapis Tayta Diosninsipa wilacuyninta pilapis tantyasinanta nistäyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nogaga manami Tayta Diosninsi munashganno cawag runacunalata Diospa wilacuyninta wilapänäpäsu shamushcä, sinöga pay munashganno mana cawag runacunatapis wilapänäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Saypitanami Jesusta tapuyargan: “Juan Bautistapa discïpuluncunawan fariseucunapa discïpuluncunaga ayunar Tayta Diosta imaypis manacuyanmi. Gampa discïpuluyquicunaga ¿imanirtä paycunano ayunayansu?” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sayno tapuyaptinmi Jesús nergan: “Casaray fiestaman gayasishgan cagcuna ¿ayunayanmansurä? ");
INSERT INTO qvhNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Casarag magta wanuptinmi isanga ayunayangapä. Saynölami discïpulöcunapis paycunawan cashgäyäga ayunayanmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Saymi Jesús mastapis nergan: “Manami pipis mushog mödanata rachinsu macwa mödanata remendananpä. Sayno rurarga perdisengami mushog mödanata. Say mushog mödanapita rachishgan träpoga manami camarangasu macwa mödanachöga. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Saynöpis sayrä rurash aswata manami winansisu shilicaycag urpumanga. Shilicaycag urpuman winashgaga aswa pogur say urputa lacsiriycongami. Sayno captenga aswapis jichacangami y urpupis paquir ushacangami. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Saymi sänu urpuman sayrä rurash aswata winansi. Sayno rurashgaga aswapis manami jichangasu ni urpupis paquengasu. Saynölami nogapa yachasicuynëpis mushog car gamcunapa costumbriquicunamanga tincunsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Saynöpis manami pipis pogush vïnuta yawarcur sayrä rurash vïnuta upuyta munansu: ‘Pogush vïnoga manami tincunsu sayrä rurash vïnuman’ nishpan. Saynölami unay yachasicuycunawan yachacash car noga yachasishgäcunata runacuna chasquicuyta munayansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sábado jamay junagchömi discïpuluncunawan Jesús päsaycäyargan trïgu poguraycag chacracuna cuchunpa. Saypa päsarmi Jesuspa discïpuluncuna trïguta palarcur cuparishpan micuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sayta ricarmi fariseo runacuna niyargan: “Sábado jamay junag mana arunapä Moisés guelgashgan leycunacho nicaptenga ¿imanirtä discïpuluyquicuna trïguta palaycäyan?” ");
INSERT INTO qvhNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Saymi Jesús nergan: “Sábado jamay junagcho trïguta palarpis paycunaga manami jusalicuycäyansu. Asca cutimi gamcuna liyiyashcanqui David yanapagnincunawan micanar imata rurayashgantapis. Asca cuti liyiycarpis ¿manacu tantyayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davidga Tayta Diosta manacuna wayi rurinman yaycurmi Tayta Diosninsipä churaraycag tantata micorgan. Nircur paywan aywag runacunata say tantata garargan paycunapis micuyänanpä. Say tanta cüracunala micuyänanpä captinpis sayta micur Davidga manami jusalicuyashgasu.” Sayno nirmi Jesús tantyasergan discïpuluncuna sábado jamay junagcho trïguta micurpis mana jusalicuyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nircur Jesús nergan: “Nogami munayyog caycä sábado jamay junagcho runa rurananpä mana rurananpä cagtapis ninäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Saypita juc sábado jamay junagchönami sinagogaman Jesús yaycorgan yachasinanpä. Saychömi caycargan juc runa, derëcha cag maquin wanush. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sauraga Moisés guelgashganta yachasegcunawan fariseucunami Jesusta ricapaycäyargan cayno yarpäyashpan: “Mä sábado jamay junag caycaptin ¿aliyäsinäcush tagay gueshyagta? Aliyäsiptenga say achäquilami contran sharcushunpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sayno yarpaycäyashganta tantyarmi wanush maquiyog runata Jesús nergan: “Sharcurcur runacunapa naupanman ichicuy.” Sayno niptinmi say runa ichircorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nircurna runacunata Jesús taporgan: “Sábado jamay junagcho ¿gueshyaycag runata aliyäsishwancu o ‘Jina nacacusunpis’ nishwancu?” ");
INSERT INTO qvhNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Saypita naupancho caycag runacunata ricärishpan maquin wanush caycag runata nergan: “¡Maquiquita jogariy!” Jogarcuptinmi maquin sänuna ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sábado jamay junagcho sayno aliyäsiptinmi fariseucuna fiyupa rabiacuyargan. Nircur wilanacuyargan Jesusta wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Saypita juc sacayna Jesús aywargan jircaman Tayta Diosta manacunanpä. Saychömi warargan Tayta Diosninsita manacuycar. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pasa wararcuptinnami discïpuluncunata gayargan. Nircur paycunapita acrargan chunca ishcay (12) runacunata apostolnincuna cayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paycunami cayargan Simón (paytami jutinta churapargan Pedro nir), Simonpa wauguin Andrés, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO qvhNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeupa surin Santiago, “Celote” nishgan Simón, ");
INSERT INTO qvhNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa wauguin Judas y Jesusta entregag cag Judas Iscariotipis. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jircapita Jesús urämurnami juc pataccho asca discïpuluncuna y saysica runacunapis juntaraycagta tarergan. Say runacunami shayämorgan Judea provinciapita, Jerusalenpita, Tiro marcapita y Sidón marcapitapis. Paycunami juntacäyargan Jesús yachasishganta wiyayta munar y gueshyashgancunapita aliyash cayta munayashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Saycho waquinta aliyäsishgannölami supay nacasishgan runacunatapis Jesús cachacäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aliyäsiptinmi pï-maypis Jesusta yataylapis yatayta munayargan, gueshyashganpita aliyäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sauraga discïpuluncunata ricärirmi Jesús nergan: “Cay pasacho pobri caycarpis cushishmi cawayanquipä. Gamcunatami Tayta Diosninsi naupanman pushayäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Cay pasacho micanarpis cushishmi cawayanquipä. Gloriachöga manami micanäyanquipänasu. “Cay pasacho wagarpis cushishmi cawayanquipä. Gamcunatami gloriacho Tayta Diosninsi cushicuyta goyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nogata chasquicayämashgayquipita runacuna chiquiyäshuptiqui, garguyäshuptiqui ni ashliyäshuptiquipis ama laquicuyaysu. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sayno nacayashgayquipitami Tayta Diosninsi premiuta gloriacho puestupäyäshunquipä. Gamcunatanömi Tayta Diosninsipa unay profëtancunatapis nacasiyargan. Sayno caycaptenga imano nacarpis cushicuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nircurnami Jesús nergan: “¡Rïcucuna! Cay pasacho imaycayogpis car runa mayiquita manami yanapäyashcanquisu. ¡Saymi gamcunata Tayta Diosninsi mana cuyapaypa infiernuman gaycuyäshunquipä! ");
INSERT INTO qvhNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Imaycayquicunapis asca captin cushicogcuna! Infiernuchöga segaypami nacayanquipä. “¡Quiquilayquicunapä imatapis yarpar cushish cawagcuna! Gamcunaga laquicuyashpayquimi wagayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Lapan runacunapita alabash cagcuna! Unay lutan yachasicogcuna alabash cayänalanpä yarpashgannömi gamcunapis alabash cayänalayquipä yarpachacuycäyanqui. Sayno cayashgayquipitami Tayta Diosninsi mana cuyapaypa infiernuman gaycushunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Cäsucamagcunatami isanga në: Cuyayanqui chiquishogniquicunata. Contrayquicunatapis ali ricayanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gayapäshogniquicunapä Tayta Diosta ruwacuyanqui ali cawayänanpä. Saynöla ashlishogniquicunapäpis Tayta Diosta manacuyanqui perdonananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pipis lagyayäshuptiquega jucag cärayquitapis camapäyanqui. Punchuyquita guechuyäshuptiquega chompayquitapis cachapariycuyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Runacuna imalatapis manacushuptiquega goycunqui. Sayno imatapis guechurishushpayqui apacuptenga cachapariycuyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Runa mayiqui ali ricayäshunayquita munarga gamcunapis paycunata ali ricayay. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cuyanacuyashgalayquiwan cuyanacorga ama yarpäyaysu ali runa cayashgayquita. Jusasapa runacunapis cuyanacuyashgalanwanga cuyanacuyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Quiruyqui tincushgalanwan ali cawarga ama yarpäyaysu ali runa cayashgayquita. Jusasapa runacunapis saynölaga cawayanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yanapäyäshogniquicunalata imachöpis yanaparga ama yarpäyaysu ali runa cayashgayquita. Fiyu runacunapis yanapagnincunataga yanapäyanmi imatapis chasquiyänan-rayculaga. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Gamcunaga chiquishogniquicunata cuyayay. Paycunawan ali cawayay. Imatapis pägu-rayculaga manayaysu. Tayta Diosninsega jusasapa runacunata cuyapanmi. Munayyog Tayta Diosninsi cuyapäcog cashganno gamcunapis cuyapäcog carga paypa wamranmi caycäyanqui. Cuyapäcog cayashgayquipitami gloriacho premiuta chasquiyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sayno caycaptenga Tayta Diosninsi cuyapäcog cashganno gamcunapis cuyapäcog cayay. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tayta Diosninsi mana juzgayäshunayquipä runa mayiquita ama jamuräyaysu. Saynöpis runa mayiquita manacagman ama churayaysu. Tayta Diosninsi perdonashunayquipäga chiquishuptiquipis perdonayay. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pï-maywanpis ali cawar yanapänacuyay. Runa mayiquita yanapashgayquinölami gamcunatapis Tayta Diosninsi yanapäyäshunquipä. Yanapäshushpayquega yarpashgayquipitapis mastami yanapäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“¿Gapra runa gapra mayinta pushanmansurä? Pushaycashgancho ¿manasurä pözuman ishcan jegacurpuyanman? Saynölami noga yachasishgäta manarä yachacorga gamcunapis gapranöla caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maygan yachacogpis manami yachasegninpita mastaga yachansu. Sayno captinpis shumag yachacorga yachasegninta tariparcongami. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Quiquiquicunapa nawiquicunacho jatuncaray ganra jatiraycaptenga ¿imanirtä runa mayiquicunapa nawincho ichicnayla ganra caycagta ricapäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nawiquicunacho jatuncaray ganra caycaptenga ¿imanöparä runa mayiquita: ‘Nawiquicho tacshala ganra caycagta jorgapäshayqui’ niyanquiman? ¡Ishcay cära runacuna! Puntataga jorguyay nawiquicunacho ganra caycagtarä. Sayrämi ricayanquipä runa mayiquipa nawincho tacshala ganra caycagta jorgupäyänayquipä. Saynöla runa mayiquita jamuränayquipa trucanga yarpachacuyay quiquiquipa jusayquicunata cacharinayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Jachacuna manami wayunsu juc casta jachapa wayuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Saynöla manami jïguscunata palansisu cashacunapita, ni üvata cosechansisu shiracacunapitaga. Ima jachatapis wayuyninpa reguishgansinölami runacunatapis parlacuyninpa reguinsi ali runa cashganta o fiyu runa cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Saymi ali runaga shongun alita yarpashganno alita parlan. Fiyu runami isanga shongun mana alita yarpashganno mana alita parlan. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtä gamcuna: ‘Maquiquichömi caycä’ niyämanqui, noga nishgäta mana cäsucuycarga? ");
INSERT INTO qvhNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nishgäcunata wiyacamag runa imano cashgantapis canan tantyasiyäshayqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Payga caycan cimientuta shumag ruraycur sharcasish wayinömi. Asca yacu miramur jaytaptinpis ali cimientush wayega manami juchongasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nishgäcunata mana wiyacamag cagmi isanga alpa janalancho sharcasish wayino caycan. Segaypa tamyar yacu shamuptin sayno sharcasish wayega juchurmi ushacangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Runacunata sayno parlapayta ushasquirmi Jesús aywargan Capernaum marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Saychömi juc capitanpa cuyay ashmaynin wanuycargannana. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sauraga Jesuspä parlayashganta say capitán mayaycurmi Jesusman cachacorgan Israel mayor runacunata: “Ruwacaycayämuy ashmaynëta aliyäsipaycamänanpä” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Saymi paycuna chaycur Jesusta ruwacuyargan: “Capitanpa ashmayninta aliyäsipayculay, taytay. Capitanga ali runami. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Marca mayinsicunawanpis payga alimi cawan. Sayno ali carmi sinagogansitapis sharcasipäyämash.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sayno ruwacuyaptinmi Jesús aywargan paycunawan. Capitanpa wayinman Jesús chänanpä caycaptinnami say capitán cachargan amïguncunata Jesusta ninanpä: “Amashi afanacuycunquisu, taytay. Capitán musyanshi wayinman yaycuptiqui Israel runacuna jamuräyäshunayquipä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Israel runacuna mana Israel runacunawanga ni parlaylapis mana parlashganta musyarshi quiquenga shamushgasu manacushunayquipä. Sayshi caylapita niycunqui ashmaynin aliyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Paypis mandagninpa munayninchöshi caycan. Saynöshi paypa munaynincho soldäducunapis caycäyan. Sayshi maygantapis ‘Ayway’ niptin aywan, ‘Shamuy’ niptin shamun y ashmayninta ‘Cayta ruray’ niptinpis ruran. Gamga paypita más munayyogshi caycanqui. Saymi yäracun nishgayqui lapanpis ruracänanpä cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sayno wilayaptinmi Jesús cushicorgan. Saymi paywan aywaycag runacunata nergan: “Payno ali yäracamag runataga manami ni Israel runacunachöpis tarishcäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sayno niptinmi capitanpa cachancuna cutiycur tariyargan say ashmay aliyashgana caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Saypitana discïpuluncunawan Jesús aywargan Naín marcaman. Paycunawanmi asca runacuna aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Marcaman yaycuycarna Jesús ricargan ayata pampayänanpä apaycäyagta. Say apaycashgan ayaga cargan viüdapa juclayla magta wawanmi. Saymi asca runacunapis walquiycäyargan pampäsiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Viüda segaypa wagaptinmi cuyapar Jesús nergan: “Ama wagaysu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nircur apagcunaman witiycur quirmanta yataycorgan. Sauraga ayata apagcuna ichiycuptin wanush caycag magtata Jesús nergan: “¡Magta, sharcuy!” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sayno niptinmi wanush caycag magta jamarcamur parlar galaycorgan. Nircurna Jesús say viüdata nergan: “¡Ama wagaynasu! ¡Wawayqui cawarimushganami!” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sayta ricaycur lapan runacuna cushicuyashpan Tayta Diosninsita alabayargan: “¡Tayta Diosninsipa profëtanmi nogansiman chämush! ¡Tayta Diosninsimi payta cachamush yanapämänansipä!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Saymi Judea provinciacho y naupan marcacunachöpis Jesús rurashgancuna musyacargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús rurashgancunatami Juan Bautistapa discïpuluncuna Juanta wilayargan. Sauraga ishcay discïpuluncunata Jesusman cachargan tapumunanpä: ");
INSERT INTO qvhNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“¿Gamcush caycanqui Tayta Dios cachamushgan Cristo, o juctaräcush shuyacuyäshä?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sauraga Juanpa cachancuna Jesús cagman chaycur payta tapuyargan: “Juanmi musyayta munaycan, taytay. ¿Gamcush caycanqui Tayta Dios cachamushgan Cristo, o juctaräcush shuyacuyäshä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sayno tapog chashgan hörami Jesús aliyaycäsergan asca gueshyagcunata, supay gueshyasishgancunata y gapracunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Say gueshyagcunata aliyarcasir Jesús nergan: “Cutiyashpayqui Juanta wilayay ricayashgayquita y wiyayashgayquitapis. Gapracuna ricayannami. Puriyta mana puëdeg wegrucuna puriyannami. Leprawan gueshyagcuna aliyashnami caycäyan. Upacuna wiyayannami. Juc ishcay wanushcunapis cawariyämushganami. Muchogcunapis Tayta Diosninsipa wilacuyninta wiyaycäyannami. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nogaman yäracamashgannöla imaypis Juan yäracamäsun.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa cachancuna cutisquiyaptinnami runacunata Jesús nergan: “Sunyag jircaman Juanta ricayänayquipä aywar manami jachata vientu cuyusegta ricayänayquipäsu aywayargayqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Saynöpis manami fïnu mödanan jatish runata ricayänayquipäsu aywayargayqui. Reypa wayincho tagcunalami ali mödanan jatish caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Manami saycunata ricagsu aywayargayqui, sinöga Tayta Diosninsipa profëtanta ricayänayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpämi Tayta Diosninsipa palabrancho cayno guelgaraycan: ‘Wilacognëtami cachashä runacunata puestucasinanpä. Saynöpami puestucush cayanga shamuptë chasquicayämänanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Juanpä sayno guelgash captinmi lapan runacunapitapis payga más puntata tantyash Tayta Dios cachamushgan Cristo cashgäta. Sayno captinpis discïpulöcunaga nogawan purish carmi Juanpita masla tantyayan Dios cachamushgan Cristo cashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Saypita Jesús mastapis nergan: “Juan nishganta wiyagcuna, hasta más jusasapa cagcunapis, tantyayarganmi Tayta Diosninsipa wilacuynin ali cashganta. Saymi paycunata Juan bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseucunawan Moisés guelgashganta yachasegcunami isanga bautizacuyargansu, Tayta Diosninsi nishgancunata chasquicuyta mana munayashpan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sayno nircur Jesús mastapis nergan: “Canan tiempo runacunaga yupay-tucog wamracunanömi caycäyan. Manami chasquicuyämansu noga yachasishgäcunata ni Juan Bautista yachasishgancunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wamracuna: ‘Puclar fiestata rurashun’ nir quënata tucaptin yanasancuna tushuyta mana munayashgannömi noga yachasishgäcunatapis chasquicuyansu. ‘Aya pampayta puclar laquicuypa cantashun’ niptinpis yanasancuna puclayta mana munashgannömi Juan Bautista yachasishgancunatapis chasquicuyta munayansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautista imaypis ayunaptin y vïnuta mana upuptin: ‘¡Payga supaypa munaynincho carmi sayno caycan!’ niyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pï-may runawanpis shuntacar noga ima micuytapis micuptë y vïnutapis upuptë ‘Micular upular puricun’ niyäman. Saynöpis: ‘Jusasapa runacunawan y Romapä impuesto cobragcunawan puricog’ niyäman. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sayno mana chasquicayämaptinpis Juantawan nogata Tayta Dios cachamashgan tantyacaycan Tayta Dios munashganno cawayaptëmi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Saypitami fariseo runa wayinman Jesusta pushargan saycho paywan micuyänanpä. Wayinman chaycasirmi mësa cagman jamasergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sayman Jesús aywashganta mayaycurmi jusasapa warmi aywargan “alabastro” nishgan rumipita rurashgan botëllanwan perfümin aptash. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuspa naupanman jamaycur wagaptinmi Jesuspa chaquinman weguin jutorgan. Say jutushgantanami agsanwan saquisipargan. Nircur Jesuspa chaquinta musarcur winapargan apashgan perfümita. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sayta ricaycurmi fariseo runa cayno yarpargan: “Tayta Diospa profëtan carga Jesús tantyanmanmi ima-nirag warmi yataycashgantapis. Mañösa warmi cashganta musyarga manami munanmansu cargan yataycunantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sayno yarpaycashganta musyarmi Jesús nergan fariseo runata: “Simón, rätula wiyarcamay wilapänäpä cashganta.” Sayno niptinmi payga nergan: “Mä wilaycalämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Saymi Jesús nergan: “Ishcay runashi juc runapa jagan cargan. Jucninshi jagan cargan ishcay wata arupänanpä. Jucagnashi jagan cargan ishcay quila arupänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Say runacuna jagan cayashganta pägayta mana puëdiyaptinshi ishcantapis cobrargannasu. Canan nimay. ¿Maygan cagtä say guellayyog runata más cuyanga?” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saymi Simón nergan: “Más aypala jagan cag runacher, taytay.” Niptinmi Jesús nergan: “Alitami nishcanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sayno nirmi warmita ricärir Simonta Jesús nergan: “Cay warmi wagar chaquëta musash jusasapa cashganpita perdonash carmi. Costumbrinsi caycaptinpis wayiquiman yaycamuptë gamga manami yacuta puestupämashcanquisu chaquëta awicunäpä. Cay warmimi isanga chaquëman weguin jutushgantapis agsanwan pisapämash. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yaycamuptë manami musamargayquisu. Paymi isanga yaycamushganpita-pasa mana uticaypa chaquëta musash. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Umämanpis manami aceitita winapämashcanquisu. Paymi isanga chaquëman perfümita winapämash. ");
INSERT INTO qvhNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cay warmega jusasapa cashganpita perdonash carmi sayno ruraycan. Waquenga jusaynag cashganta yarparmi perdonash carpis saynösu ruran.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nircur say warmita nergan: “Lapan jusayquicunapita perdonashganami caycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Saymi mësacho jamarpaycag runacuna quiquinpura cayno ninacuyargan: “¿Pitä pay runapa jusancunata perdonananpäga?” ");
INSERT INTO qvhNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Saymi Jesús nergan say warmita: “Yäracamashgayquipitami salvash caycanqui. Cananga cushishgana aywacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Saypitanami chunca ishcay (12) acrashgan cag discïpuluncunawan Jesús purergan marcan marcan, Tayta Diosninsipa wilacuyninta wilacuyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Paywanmi aywayargan supaypa munayninpita jorgushgan warmicuna y gueshyancunapita aliyäsishgan warmicunapis. Saynöpis aywargan María Magdalena. Paypitami Jesús gargorgan ganchis supaycunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Saynöpis aywayargan Herodispa yanapagnin Chuzapa warmin Juana, Susana y waquin warmicunapis. Jesusta y discïpuluncunata paycuna yanapäyargan imalancunawanpis cashganpita. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Marcacunapita asca runacuna Jesús cagman aywar shuntacäyaptinmi Jesús wilapargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc runashi aywargan trïgu murog. Sayshi muruta shicaptin waquin chäyargan näniman. Nänipa runacuna purirshi say murucunata jarucuyargan. Saynöshi pishgucunapis say murucunata upshacurcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquin cag murunashi chäyargan shalaman. Saycho winamurpis alpa aläpa mana captinshi shanaywan saquicäcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquin cag murunashi chäyargan cashacuna cashganman. Cashacuna rurincho garwashtaycälar winamurshi wayuyninpis cargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waquin cag murunashi ali alpaman chäyargan. Saycunaga ali winamurshi wayorgan juc espïgalacho pachacta (100).” Sayno yacharcasir Jesús nergan: “Nishgäta wiyag cäga shumag tantyacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Saypita discïpuluncuna Jesusta manacuyargan: “Tantyasiyämay say tincusiypa yachasishgayquita, taytay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Saymi Jesús paycunata nergan: “Gamcunataga tincusiypa yachasishgäcunata shumagmi tantyasiyäshayqui. Mana cäsucamagcunatami isanga yachasë imaman tincusirpis mana tantyasiylapa. Sayno yachasë ricaycarpis mana tantyayänanpä y wiyaycarpis mana chasquicuyänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Say wilapashgäcunaga caynömi caycan: Trïgu murunömi Tayta Diosninsipa wilacuynin caycan. Trïgu murupacog runanömi Diospa wilacuyninta wilacogcuna caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Chucru näninömi waquin runacunapa shongun chucru caycan. Sayno chucru shongu carmi Tayta Diosninsipa wilacuyninta wiyarpis chasquicuyansu. Saymi wiyashgalantapis Satanás gongaycasin mana salvacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Waquin runacunapa shongonga shalanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta wiyar cushishmi chasquicuyan. Cushish chasquicurpis shalacho alpa aläpa mana captin trïgu jegarcamur saquicäcushgannömi paycunapis caycäyan. Saymi runacuna chiquiyaptinpis o ima nacaycho carpis cuticuyan naupata cawayashganmanno. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Waquin runacunapa shongonga casha rurincho cag alpanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta wiyarpis más yarpachacuyan waraynincuna imanöpis cawayänalanpä, rïcu cayänalanpä y quiquin munashganno cawayänalanpämi. Saycunalapä yarpachacurmi Tayta Diosninsi munashganno cawayansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Waquin runacunapa shongonga ali alpanömi caycan. Paycunaga Tayta Diosninsipa wilacuyninta cushish chasquicur Tayta Diosninsi munashgannömi cawayan. Saymi ali alpacho muru winarcamur segaypa wayushganno Tayta Diosninsi munashgannöla shumag cawayan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sayno nircurmi discïpuluncunata nergan: “Manami pipis acsita sarisinsu cajun rurinman pacananpä, ni cawitu rurinman pacananpäga. Saypa trucanga alayrinninmanmi churan wayiman yaycogcunata asicyapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Saynölami gamcunapis yachasiyashgäcunata pï-maytapis wilapanqui. Sayno wilapaptiquimi pï-maypis wilacuynëta musyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yachasiyänayquipäga nishgäcunata shumag wiyacuyay. Yachasishgäta cäsucogcunaga yachayashganpitapis masmi yachacuyanga. Mana cäsucog cagcunami isanga ichiclata yachayashgalantapis gongaycongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Saypita Jesuspa mamanwan wauguincuna chäyargan Jesús caycashgan cag wayiman. Asca runacuna captinmi pay caycashgan cagman yaycuyta puëdiyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Saymi juc runa Jesusta wilargan: “Mamayquiwan wauguiquicunami puncucho shuyaraycäyäshunqui” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sayno niptinmi Jesús nergan: “Pipis Tayta Diosninsipa wilacuyninta cäsucogcunami mamäno y wauguëcunano caycäyan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","23","Juc junagmi discïpuluncunawan büquiman yaycur Jesús nergan: “Acu päsashun gocha wac simpaman.” Saymi simpaycäyaptin Jesús punucäcorgan. Sayyagmi fiyupa vientuwan yacu pulchagyar büquita talpucäsinanpäna caycargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Saymi discïpuluncuna Jesusta ricchasergan: “¡Taytay, taytay! ¡Talpucaycansinami!” nir. Sayno niyaptinmi Jesús sharcurcur olgutupargan vientutawan yacuta. Olgutupasquiptinmi vientupis yacupis chawasquergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nircurna discïpuluncunata nergan: “¿Imanirtä yäracayämanquisu?” Saymi quiquinpura mansacash niyargan: “Yacupis vientupis sayno cäsunanpäga ¡imajinanparä munayyog payga caycan!” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Saypita chäyargan Gadara nishgan partiman. Say cargan Galilea provinciapa simpanchömi. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Büquipita Jesús urarpuptinmi supay löcuyäsishgan runa marcapita shamorgan. Say runami löcuyashganpita-pasa garapächula puricog. Saynöpis panteonlachömi täcog. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Say runataga asca cutimi supay rurasergan munashganta. Maquinta y chaquinta cadinawan watayaptinpis cadinata rachiriycurmi sunyag jircacunaman aywacog. Supaycuna paypita yargunanpä Jesús niptinmi puntanman gongurpacuycuptin paycho cag supaycuna gaparäyargan: “¡Munayyog Diospa surin Jesús! ¡Cay runapita ama gargaycalämaysu!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sauraga Jesús say runata taporgan: “¿Imatä jutiqui?” nir. Niptinmi: “Nogapa jutëga Legionmi” nergan. Sayno nergan asca supaycuna payman yaycush captinmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Saymi say supaycuna Jesusta manacuyargan jiu-jiuyaycag ragraman mana garpunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Paycuna caycäyashganpita más washalä lömachömi asca cuchicuna micuycäyargan. Saymi supaycuna Jesusta manacuyargan cuchicunaman yaycuyänanpä. Sauraga Jesús aunergan manacuyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Saymi supaycuna runapita yargurir yaycucuycuyargan say cuchicunaman. Sauraga cuchicuna löcutashpan tunapa cörrir jegacurpuyargan gochaman. Saychömi shengaypa wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sayta ricaycurmi cuchi misegcunaga mansacash cörrila aywayargan marcacho tag runacunata y cercancho tag runacunatapis wilayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wilayaptinmi runacuna aywayargan ima cashgantapis ricayänanpä. Sayman chäyashpanmi say löcuyash runata tariyargan Jesuspa puntancho juiciunchöna caycagta. Ali yarpayninchöna carmi mödanan jatishgana jamaraycargan. Sayta ricaycurmi runacuna mansariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cuchi misegcunami shamogcunata wilargan supaycuna löcuyäsishganpita imanöpa say runa cachacashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Saymi segaypa mansacash lapanpis Jesusta niyargan saypita aywacunanpä. Sayno niyaptinmi büquiman wisarcur Jesús cuticorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Manarä aywacuptinmi say cachacag runa Jesusta ruwacorgan paywan aywacunanpä. Saymi Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nogawan aywanayquipa trucanga wayiquipa cuticuy. Saycho wilacunqui Tayta Diosninsi cachacäsishushgayquita.” Sayno niptinmi marcapa aywar runacunata wilapargan Jesús cachacäsishganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gadara nishgan partipita Jesús cutiptinmi shuyarpaycag runacuna cushish chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Saymanmi chargan sinagogacho mandag Jairo jutiyog runa. Chunca ishcay (12) watayog juclayla warmi surinmi wanuycarganna. Saymi Jesuspa puntanman gongurpacuycur manacorgan surinta aliyäseg aywananpä. Sauraga Jesús aywaycaptinmi saysica runacuna quichquiyparä payta gatiräyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Saymi runacunapa chaupincho aywaycargan chunca ishcay (12) watana yawar apaywan gueshyaycag warmipis. Sänu cayta munarshi say warmi imaycantapis ranticur ushargan mëdicucunata pägananpä. Imanöpa jampiyaptinpis manashi aliyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesuspa guepanpa yaycuycur mödananpa cuchunta yataycorgan. Yataycuptinmi jinan höra yawar apaynin saquisquergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Saymi Jesús nergan: “¿Pitä mödanäta yataycamash?” Saycho lapanpis: “Manami noga yatashcäsu” niyaptinmi Pedro nergan: “Quichqui aywaycashgaga maygan yatashushgayquitapis ¿imanöparä musyashwan, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sayno niptinpis Jesús yapay nergan: “Musyämi mayganpis yataycamar aliyashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Saymi say warmi imaniytapis mana camäpacur sucsucyaycar gongurpacuycorgan Jesuspa puntanman. Nircurmi wilargan imanir yataycushganta y jinan höra aliyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Saymi Jesús nergan: “Nogaman yäracamashgayquipitami aliyashcanqui. Cananga cushishgana cuticuy.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús sayno parlaycaptinrämi Jairupa wayinpita wilacog taripaycur Jairuta nergan: “Suriqui wanusquishganami. Amana Jesusta pushaynasu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sayno wilaptinmi Jesús nergan: “Ama laquicuysu. Nogaman yäracamaptiquega suriqui cawarimongami.” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Sauraga Jairupa wayinman chaycurmi say wanush wamrapä wagaycäyagta ricar Jesús nergan: “Ama wagayaysu. Jairupa surenga manami wanushgasu, sinöga punuycanlami.” Sayno niptinmi wanush caycashganta musyayashpan saycho caycag runacuna Jesús nishganta criyiyargansu. Saymi Jairupa surin wanush caycashgan cagman Jesús yaycasergan Pedruta, Juanta, Santiaguta y Jairutapis warmintinta. Waquin cag yaycuyänantami isanga munargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nircurna wanush caycagpa maquinpita sarircur Jesús nergan: “¡Jipachita, sharcuy!” ");
INSERT INTO qvhNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sayno niptin wanush caycag jipachita jinan höra cawarircamur sharcorgan. Saymi Jesús mandargan say jipachitata pachan garayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jipachita cawarimushganta ricaycur mamanwan taytan selläma cushicuyargan. Isanga cawarisimushganta pitapis wilapäyänanta Jesús manami munargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Saypita chunca ishcay (12) apostolnincunata gayaycur Jesús nergan paypa jutincho runacunapita tucuy-nirag supaycunata garguyänanpä y gueshyagcunata aliyäsiyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nircur paycunata cachargan Tayta Diosninsipa wilacuyninta wilacuyänanpä y gueshyaycagcunata aliyäsiyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Saymi paycunata nergan: “May marcapa aywarpis ama apayanquisu tucruyquicunata, guepinayquicunata, mircapayquicunata, guellayniquicunata, ni trucacuyänayquipä mödanayquicunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","May wayiman posädacurpis saylacho posädaräcuyanqui juc marcaman päsayashgayquiyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","May marcachöpis mana chasquiyäshuptiquega saypita aywacuyanqui languiquicho caycag polvuta tapshirishpayqui. Sayno rurayanqui Tayta Diosninsi paycunata juzgananpä cashganta tantyacuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sayno niptinmi apostolnincuna aywayargan marcan marcan Tayta Diosninsipa wilacuyninta wilacuraycar. Saynömi gueshyagcunatapis ascagta aliyäsiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Jesús pï cashgantapis mana musyarmi waquin runacuna niyargan Juan Bautista wanushganpita cawarimushganta. Waquin niyargan Tayta Diosninsipa profëtan Elías cashganta. Y waquinnami niyargan maygan profëtapis cawarimushganta. Juan cawarimushganta runacuna niyaptinmi Galilea provinciapa mandagnin Herodes imanöpa yarpachacurpis atipargansu. Saymi nergan: “Juanpa umanta rogusish caycaptëga ¿pirä canman say runa? Say runata nogapis reguiycöman isanga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wilacuyashganpita apostolcuna cutiycamurmi Jesusta wilapäyargan lapan rurayashgancunata. Saypita paycunata pushacurcur Jesús aywargan Betsaida marcapa cercanman. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Saypa aywayashganta musyaycurmi guepanpa asca runacuna aywayargan. Pay caycashgan cagman chaycuptin Jesús paycunata chasquicorgan. Nircurna yachasergan Tayta Diosninsipa wilacuyninta. Saynömi gueshyagcunatapis aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Saymi pasa tardiyaptinna apostolnincuna Jesusta niyargan: “Runacuna aywacuyäsunna maylachöpis posädata ashiyänanpä. Caychöga manami imapis cansu garanansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Saymi Jesús nergan: “Paycunataga micuyta gamcuna garayay.” Sayno niptinmi niyargan: “Pisga tantawan ishcay pescädulami mircapäcuna caycan. Micuy ranteg mana aywarga ¿imatarä caysica runacunata garayäshä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Saychömi runacuna caycäyargan pisga warangano (5,000). Saymi discïpuluncunata Jesús nergan: “Jamasiyay lapan runacunata pisga chunca-camala (50).” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sayno niptinmi saycho cagcunata lapanta jamacuyänanpä niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Saypitanami pisga tantatawan ishcay pescäduta aptarcur Jesús ciëlupa ricärishpan Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paquircur discïpuluncunata macyargan lapan runacunata aypuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Saymi lapan micuyargan pacha junta. Nircurna pusupacuyashgancunata discïpuluncuna shuntayargan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc junagmi discïpuluncunawan Jesús caycar Tayta Diosta manacorgan. Manacuyta ushasquir paycunata taporgan: “¿Pï cashgätatä nogapä runacuna yarpäyan?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Saymi discïpuluncuna niyargan: “Waquin runacunaga niyan Juan Bautista cashgayquitami. Waquinnami niyan Elías cashgayquita. Y waquin cagnami niyan maygan profëtapis wanushganpita cawarimush cashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Saypita yapay taporgan: “Gamcunaga ¿pï cashgätatä yarpäyanqui?” Saymi Pedro nergan: “Gamga Tayta Dios cachamushgan Cristumi canqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sayno Pedro niptinmi discïpuluncunata Jesús nergan: “Saytaga pitapis ama wilapäyaysu. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Noga segaypa nacasishgarämi cashäpä. Israel mayor runacuna, mandag cüracuna y Moisés guelgashgan leycunata yachasegcuna chiquimarmi wanusiyämanga. Saypita quimsa junagtaga cawarimushäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nircur mastapis Jesús nergan: “Pipis discïpulö cayta munarga shongun yarpashganno jusalicur ama cawasunsu. Saypa trucanga imano nacarpis waran waran noga munashgänöla imaypis cawasun. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Noga munashgäno cawananpa trucan quiquin munashganno cawagcunaga infiernuman gaycushmi cayangapä. Ima nacaycho carpis noga munashgäno cawagcunami isanga gloriaman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Infiernuman gaycush cananpä caycaptenga ¿imapätä välin mayjina rïcu cashganpis? ");
INSERT INTO qvhNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pipis nogapita y wilacuynëpita pengacuptenga nogapis Tayta Diospa angilnincunawan chipipiycar cutimushpä payta manami cäsushäsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Manarä wanurmi waquinniqui ricayämanquipä lapanpäpis munayyog cashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Saypita puwag (8) junagtanönami Jesús wisargan juc jircaman Tayta Diosta manacunanpä. Saypa aywar pushargan Pedruta, Juanta y Santiaguta. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tayta Diosta Jesús manacuycaptinmi cäranpis jucnöman ticrargan y mödananpis chipipiycag ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Saychömi ricayargan Moiseswan Elías yuriparcur Jesuswan parlaycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Shumag chipipiycagpa chaupinchömi quimsan parlaycäyargan Tayta Dios munashganno Jerusalencho Jesús wanunanpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Say hörami ishcay discípulu mayincunawan Pedro segaypa pununaycashpanpis ricchaycäyargan. Saychömi ricayargan paycunawan Jesús chipipiycar parlaycagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sauraga say runacuna elagasquiyaptinnami mana yarpachacuylapa Pedro nergan: “Alipärä nogacuna cayman shayämushcä, taytay. Cananga rurayäshä quimsa suclata: jucta gampä, jucta Moisespä y jucta Eliaspä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sayno parlaycaptinmi pucutay sapacurcorgan. Saymi discïpulucuna segaypa mansariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sauraga pucutay rurinpitami Tayta Diosninsi nimorgan: “¡Payga cuyay surëmi! ¡Pay niyäshushgayquicunata cäsucuyay!” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Saypitaga quiquilanna Jesús ricacorgan. Discïpuluncunaga say ricayashgancunata pitapis manami wilapäyarganräsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Waraynin junag say jircapita cutiycäyämuptinmi asca runacuna Jesusta taripäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Say runacuna chaupinpitami juc runa fuertipa nimorgan: “¡Cuyapayculay cay juclayla surëta, taytay! ");
INSERT INTO qvhNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Supaymi elagpita gaparäsin, pampaman sagtan, pogushaytapis agtusin. Mana cachaypami fiyupa nacasin. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Supayta gargunanpä discïpuluyquicunaman apamuptëpis manami garguyta puëdiyashgasu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Saymi Jesús nergan: “¡Yäracuyniynag jusasapa runacuna! ¿Imayyagrä gamcunawan caycäshä? Mä apamuy wamrayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sayno niptin Jesuspa puntanman say runapa surin witiycaptinnami pampaman supay sagtariycorgan. Sayta ricaycurmi supayta Jesús olgutupargan magtapita yargunanpä. Cachariycur aywacuptinnami jinan höra magta sänuna ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tayta Diospa munayninwan supayta gargushganta ricarmi lapan cushicuyargan. Sayno rurashgancunata ricar runacuna cushicuyaptinmi discïpuluncunata Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Juc runami nogata entregamanga chiquimagnëcunapa maquinman.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sayno wilaptinpis Jesús nishgancunata paycuna manami tantyayargansu. Sayno mana tantyarpis tapuytami isanga mansapäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Saypitanami Jesuspa discïpuluncuna mandag cayta guechunacur rimanacuyargan: “Nogatami Jesús churamanga gamcunapita más mandag canäpä” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sayno rimanacuyaptinmi Jesús juc wamrata gayargan naupanman. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nircur nergan: “Cay wamratano mana cuentash cagcunata chasquicorga nogata chasquicamagnömi caycäyanqui. Nogata chasquicamarga cachamag Taytätapis chasquicuycäyanquimi. Saymi manacagman mana churaypa pitapis yanaparga mandag cayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Saymi discïpulun Juan nergan: “Nogacuna ricayashcä juc runata gampa jutiquicho supaycunata garguycagta, taytay. Saymi nogansiwan mana puriptin jutiquita mana jogarinanpä michäyashcä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Saymi Jesús nergan: “Cananpitaga ama michäyanquisu. Pipis contransi mana sharcorga favorninsimi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tayta Diosman cutinanpä tiempo chaycämuptinnami wanunanpä cashganta musyarpis mana mansacuypa Jesús aywargan Jerusalenpa. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aywaycarnami cachacorgan Samaria provinciacho cag juc marcaman, saycho posädacuyänanpä wayi asheg. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Say marcacho runacuna manami chasquicuyta munayargansu, Jerusalenpa aywaycashganta mayar. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sayno mana chasquicuyaptinmi Santiaguwan Juan niyargan: “¿Elías manacushganno Tayta Diosninsita manacuyämancu ciëlupita shamog ninawan cay runacunata ushacäsinanpä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sayno niyaptinmi paycunata Jesús rimargan: “Tayta Diosninsipa wilacognin caycarga ¿imanirtä sayno parlayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Manami runacunata ushacäsinäpäsu cay pasaman noga shamushcä, sinöga runacunata salvanäpämi.” Saypitanami juc marcapana aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sayno aywaycäyaptinmi juc runa Jesusta nergan: “Maypa aywaptiquipis gatiräshayquimi, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sayno niptinmi Jesús nergan: “Atogcunapaga machaynincuna canmi. Saynömi pishgucunapapis gueshuncuna can. Nogapämi isanga cansu maycho punuycunaläpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Saypita juc runata nergan: “Discïpulö canayquipä nogawan aywashun.” Niptin say runa nergan: “Papänë wanuptin pampaycurrämi gamwan aywashä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Saymi Jesús nergan: “Wanushcunaga wanush mayinta pampayäsun. Gamwanga aywashun Tayta Diosninsipa wilacuyninta wilacunayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Saynömi juc runapis nergan: “Nogapis gamwan aywaytami munä, taytay. Isanga wayëcho caycagcunatarä wilaycamushä aywanansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Saymi Jesús nergan: “Pipis guepapa ricacush yapyag cäga mana alimi yapyan. Saynöpis naupata cawashganno cawayta munagcunaga manami discïpulö cayanmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Saypita Jesús acrargan ganchis chunca ishcay (72) gatiragnincunata. Nircur ishcay ishcay cachargan pay aywananpä cag marcacunaman wilacuyninta wilacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Paycunata cacharmi Jesús nergan: “Cosëcha poguraycagnömi saysica runacuna caycäyan Tayta Diosninsipa wilacuyninta jucla chasquicuyänanpä. Sayno captinpis walcaglami ali wilacuyta wilacogcuna caycäyan. Sayno caycaptenga Tayta Diosta manacuyay wilacogcuna más asca cayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Shumag tantyacuyay. Gamcunata fiyu runacuna cayashganman cachaycä uyshacunata atogman gaycognömi. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Ama apayanquisu guellayniquicunata, jacuyquicunata, ni languiquicunatapis. Piwanpis nänicho tincorga parlar ama ichiräcuyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pipa wayinman charpis wayiyogta niyanqui: ‘Ali cawayänayquipä Tayta Diosninsi yanapaycuyäläshunqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Say wayiyog chasquiyäshuptiquega niyashgayquinömi paypä ali caway canga. Mana chasquiyäshuptiquega juc wayimanna aywayanqui posädata ashiyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Say chasquishogniquicunapa wayilancho posädaräcuyanqui. Ama wayin wayenga posädata ashiyanquisu. Arupacog runa arushganpita imatapis chasquishgannömi gamcunapis wilacuyashgayquipita imatapis chasquiyänayqui. Saymi imalatapis garashushgayquita micuyänayqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“May marcamanpis chäyaptiqui runacuna chasquicuyäshushpayqui saycho imalatapis garayäshushgalayquita micuyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Say marcacho gueshyaycagcunata aliyäsiyanqui. Aliyarcasir niyanqui: ‘Tayta Diosninsipa maquincho ali cawanapä cag tiempo chämushganami.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Isanga may marcaman chäyaptiquipis runacuna mana chasquiyäshuptiquega cälliman yargurcur niyanqui: ");
INSERT INTO qvhNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Chaquëcunacho caycag polvutapis tapshiyä fiyu cayashgayqui musyacänanpämi. Ima captinpis musyayay Tayta Diosninsipa maquincho ali cawanapä cag tiempuchöna caycashgansita.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sayno mana chasquiyäshushgayquipitami Sodoma marca runacuna infiernucho nacayänanpä cashganpitapis paycuna más fiyupa infiernucho nacayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Corazín marcacho tag runacuna! ¡Betsaida marcacho tag runacuna! ¡Gamcunaga juicio finalcho fiyupami laquicuyanquipä! Gamcunacho milagrucunata rurashgäno Tiro y Sidón marcacunacho milagrucunata ruraptëga maynami jusalicuycunata cachariyanman cargan. Saynöpis jusalicuyashganpita laquicur maynami cotenciapita rurash mödanata jatish uchpaman jamaycur wagayanman cargan. Gamcunaga milagrucunata rurashgäta ricaycarpis jusalicuycunata cachariyta manami munayanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sayno cayashgayquipitami Tiro y Sidón marca runacuna infiernucho nacayashganpitapis gamcunaga más fiyupa infiernucho nacayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum marcacho tag runacuna, ¿gamcunaga Tayta Diosninsipa naupanman chäyänayquipä cashgantachi yarpaycäyanqui? Tayta Diosninsipa naupanman chäyänayquipa trucanga Hadisman gaycushmi cayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sayno nircurmi discïpuluncunata nergan: “Gamcuna wilacuyashgayquita chasquicogcunaga nogatami chasquicaycäyäman. Saynöpis gamcunata mana chasquicuyäshushpayquega nogatapis manami chasquicaycämansu. Sayno carga Taytätapis manami chasquicuycäyansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wilacuyashganpita ganchis chunca ishcay (72) cachashgancuna cushish cutirmi Jesusta wilayargan: “¡Runacunapita supaycunata jutiquicho garguyaptë yarguyashmi, taytay!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Saymi Jesús nergan: “Sayno garguptiquimi ricashcä Satanás ciëlupita magacuynörä ratamushganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Supaycunata garguyänayquipäga munaynëtami chasquiyashcanqui. Saymi supaycunata garguptiquipis paycuna ticrapäyäshunquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Supaycunata gargur cushicuyashgayquipitaga masrä cushicuyay libro de la vïdacho jutiquicuna guelgaraycashganpita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saychömi fiyupa cushicushpan Tayta Diosninsita Jesús manacorgan: “Ciëlucho y cay pasachöpis gam munayyogmi caycanqui, papá. Yachag-tucogcunata manami tantyasishcanquisu nogata cachamashgayquita. Paycunata tantyasinayquipa trucanga yachacuyta munagcunalatami tantyasishcanqui. Sayno canantami munashcanqui, papá.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nircurnami discïpuluncunata nergan: “Taytämi lapantapis munaynëman churamush, surin captë. Noga imano cashgätapis taytalämi musyan. Saynömi pay imano cashgantapis nogala musyä. Saymi tantyasishgä cagcunala musyayan Taytä imano cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Saypitami discïpuluncunata mastapis nergan: “Noga rurashgäcunata ricarmi gamcunaga ricaycäyanqui unay runacuna mana ricashgancunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Unay profëtacuna y mandag reycunapis reguimaytami munayargan. Reguimayta munarpis cay pasaman manarä shamush captë manami reguiyämashgasu. Saynöpis noga wilacushgäcunata wiyayta munarpis manami wiyayämashgasu. Gamcunami isanga ricaycäyämanqui y wiyaycäyämanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Juc cutichömi juc yachag runa, Jesús yachashganta o mana yachashgantapis musyayta munar, Jesusta taporgan: “Taytay, ¿imatatä ruräman gloriaman chänäpä?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sayno niptin Jesús nergan: “¿Imatatä tantyanqui Tayta Diosninsipa palabranta liyir?” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Saymi say yachag runana nergan: “Gloriaman runa chänanpäga Tayta Diosninsipa palabrancho caynömi nican: ‘Shumag tantyacuycur lapan shonguyquiwan y lapan voluntäniquiwan Tayta Diosta cuyay. Saynöla runa mayiquita lapan shonguyquiwan cuyay.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sayno niptin Jesús nergan: “Alitami nishcanqui. Say nishgayquita rurarga gloriachömi imayyagpis cawanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sayno niptinmi say yachag runa Jesusta yapay taporgan: “Runa mayëta cuyarga ¿lapan runacunatacu cuyapäman?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Saymi Jesús wilapargan: “Juc runashi aywaycargan Jerusalén marcapita Jericó marcaman. Aywaycaptinshi suwacuna payta magargan. Nircur jatirashgan mödananta y guepintapis guechurishpanshi wanushtano cachariycur aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Say nänipashi päsaycargan juc cüra. Saycho wanushno jitaraycagta ricaycarpis mana ricag-tucushpanshi päsacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Saypita Leví casta runapis jitaraycashgan cagman chargan. Paypis mana ricag-tucushpanshi päsacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaria runapis saymanshi chargan. Israel runacuna Samaria runacunawan chiquinacuycarpis say Samaria runashi isanga jitaraycagta ricaycur cuyapargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sayshi aceitiwan y vïnuwan jampircur träpucunawan watapargan. Nircur ashnunman muntarcasir apargan posädacuna wayiman, saycho shumag jampinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Saypitashi waraynin tuta say cuyapäcog runa aywacunanpäna caycar wayiyogta pägargan ishcay junag arur gänashgantano: ‘Gueshyagnëta ricaycälanqui, taytay. Masta gastaptiquipis cutimurnami pägaläshayquipä’ ” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús sayno wilapayta ushasquir say yachag runata taporgan: “Say quimsan runacunapita ¿maygan cagtä runa mayinta cuyapargan?” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sayno niptin say yachag runa nergan: “Samaria runami, taytay.” Saymi Jesús nergan: “Sauraga gampis say runanöla runa mayiquita cuyapay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Saypita discïpuluncunawan aywar Jesús chargan juc tacsha marcaman. Say marcaman chaptinmi wayinman Marta chasquicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa nanan María, Jesús yachasishganta wiyayta munarmi, paypa naupanman jamacuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martami isanga wayicho ruraynincunata ruraycargan. Saymi asca ruraynincuna captin Jesusta nergan: “¿Imanirtä nanä saycho jamaräcun noga caycho nacaycaptë? ¡Niyculay yanapämänanpä, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Saymi Jesús nergan: “Marta, gamga aläpa yarpachacuycanqui rurayniquicunalapämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Saypa trucanga Tayta Diosninsi nishgancunata yachacunayquipä más yarpachacunayqui. Mariami isanga yachacuyta munar yachasishgäcunata wiyaycäman. Sayno yachacunantaga manami pipis michanmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Saypita juc cutichömi Jesús manacuycargan Tayta Diosninsita. Manacuyta ushasquiptin juc discïpulun Jesusta nergan: “Discïpuluncunata Juan Bautista yachasishganno nogacunatapis yachaycasiyälämay Tayta Diosta manacuyänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Saymi Jesús nergan: “Tayta Diosninsita manacur niyanqui: ‘Gloriacho caycag Tayta Dios, pï-maytapis tantyaycasilay respitaycuyäshunayquipä. Lapan runacuna gam munashgayquino cawaycuyäläsun. Gloriacho munashgayquita rurayashganno cay pasachöpis munashgayquita ruracaycuyäläsun. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Micuyänäpä micuynë ama pishiyculäsunsu, Taytay. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chiquimagnëcunata nogacuna perdonayashgäno jusalicuyashgäcunatapis perdonaycayälämay. Jusalicasiyämayta Satanás munaptinpis sapaycayälämay, Taytay. Saynöpis yanapaycayälämay mana jusalicuypa imaypis cawayänäpä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nircur Tayta Diosta imaypis manacunansipä Jesús wilapargan: “Juc runashi pulan pagas aywargan amïgunpa wayinman: ‘Amïgo, quimsalata tantayquita manaculäshayqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc amïgömi wayëman posädacamush. Manami imaläpis cansu garanäpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sayno manacuptinshi amïgun nergan: ‘Ama fastidiamaysu. Puncöpis trancashganami caycan. Wamräcunapis punucashganami caycäyan. Mananami sharcamömannasu tantata macyanäpä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Saymi Jesús nergan: “Sharcamuyta mana munaycarpis yaparir yaparir manacuptenga macyangapämi. Fiyu runacunapis sayno yanapäcog caycaptenga Tayta Diosninsi masrämi yanapämäshun. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Imaypis Tayta Diosta manacuyay. Imata nistarpis ruwacuyay. Puncuta tacacognöpis payta gayacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tayta Diosta manacogcunaga manacuyashganta chasquinmi. Imata nistarpis ruwacogcunaga tariyanmi. Puncuta tacacogno gayacogtaga Tayta Dios wiyanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Maygayquicunatapis wamrayquicuna tantata manacuyäshuptiqui ¿rumita aptaparcuyanquimansurä? Pescäduta manacuyäshuptiqui ¿culebrata janchaparcuyanquimansurä? ");
INSERT INTO qvhNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Saynöpis runtuta manacuyäshuptiqui ¿alacranta aptapanquimansurä? ");
INSERT INTO qvhNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mayjina fiyu caycarpis ¿manacu wamrayquicunata ali caglata aptapäyanqui? Saynölami Tayta Diosninsita manacuyaptiquega Santu Espirituta gamcunaman cachamongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cutimi shimin mana pashtag runapita supayta Jesús gargorgan. Supay yargusquiptinnami say runa parlayta galaycorgan. Sayta ricaycur waquin runacuna cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waquin runacunanami niyargan: “Manami Tayta Diospa munayninwansu supaycunata runacunapita gargun, sinöga supaycunapa mandagnin Beelzebupa munayninwanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquin runacunanami Jesusta niyargan: “Tayta Diosninsipa munayninwan supayta gargushgayquita musyanäpäga más juc milagrutarä ruray.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Paycuna lutanta yarpäyashganta musyarmi Jesús nergan: “Juc nacioncho runacuna quiquinpura chiquinacorga ¿manasurä wanusinacur ushacäyanman? Saynöpis juc wayicho tagcuna quiquinpura chiquinacorga ¿manasurä wacpa caypa aywacur ushacäyanman? ");
INSERT INTO qvhNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sayno captenga ¿imanirtä yarpaycäyanqui Satanaspa munayninwan supaycunata gargushgäta? Quiquinpura gargunacorga Satanás ushacanmanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Waquin runacuna supaycunata garguyaptin gamcunaga yarpaycanqui Tayta Diosninsipa munayninwan garguyashgantami. Noga garguptëga ¿imanirtä yarpaycäyanqui Satanaspa munayninwan supaycunata gargushgäta? Sayno yarparga lutantami yarpaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Santu Espíritu yanapämaptin supaycunata gargushgäta ricarmi musyayanqui Tayta Diospa munayninwan Satanasta vincishgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Satanaspita más munayyog cashganta tantyasirmi Jesús yachasergan: “Calpayog runa ali tucrush wayinta täpaycaptenga manami imantapis suwa apangasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sayno täpaycaptinpis paypita más calpayog runa shamurmi isanga tucrunta guechurir wayinpita munashganta apaconga. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mayganpis mana chasquicamag cäga conträmi caycan. Nogata mana cäsumag cäga Satanás munashgantami ruraycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sayno nircur Jesús mastapis nergan: “Runapita supay yargurmi sunyagcunapa purin maychöpis tänanpä ashir. Mana tariycorga yarpan yargushgan runaman yapay cutiyta. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cutiycushpanmi tarin pisapacush y churapacush wayitano. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sayno caycagta tariycurmi paypita más fiyu ganchis supaycunata pushacurcur say runaman cutin paycho tänanpä. Saymi naupata cashganpitaga say runa más fiyuna ricacun.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús sayno parlaycaptinrämi runacunapa chaupinpita juc warmi nimorgan: “Tayta Diospa wilacognin cashgayquipita ¡ima cushishgarä mamayqui caycan!” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sayno niptin Jesús nergan: “Mamä cushicushgannölami Tayta Diosninsipa wilacuyninta chasquicur wiyacogcunapis cushish caycäyan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Saypitami saysica runacuna Jesús cashgan cagman shuntacäyargan. Saymi Jesús nergan: “Gamcunaga manami rasunpaypasu Tayta Diosman yäracuyanqui. Saymi pay cachamashganta criyinayquipä milagruta ruranätarä munaycäyanqui. Munayashgayquinöga manami milagruta rurashäsu. Saypa trucanga Tayta Dios juc milagrutarämi ruranga profëta Jonasta pescädupa pachancho caycashganpita yargasimur milagruta rurashganno. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wilacognin Jonás cashganta unay Nínive marcacho tag runacuna tantyayänanpä Tayta Dios milagruta rurashgannömi juc milagruta ruranga pay cachamashganta runacuna tantyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Musyashgayquinöpis Salomonpa yachasicuyninta wiyananpämi Sabá nacionpita-pasa mandag warmi shamorgan Jerusalenman. Paymi juicio finalcho sharcamongapä canan wisan runacunata: ‘Salomón yachasishganta noga chasquicuycaptëga ¿imanirtä gamcuna Tayta Diospa surin yachasishganta chasquicuyargayquisu?’ ninanpä. Salomonpita noga más yachag captëpis canan wisan runacunaga manami wiyacuyansu noga wilacushgäcunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Saynöpis Jonás wilacushganta wiyarmi Nínivicho tag runacuna jusalicuyashganta cachariyargan. Jonaspita más munayyog noga caycaptëpis wilacushgäta canan wisan runacuna manami chasquicuyansu. Saymi juicio finalcho Nínivicho tag runacuna sharcayämongapä canan wisan runacunata: ‘Nogacuna Jonás wilacushganta chasquicuycäyaptëga ¿imanirtä gamcuna Tayta Diospa surin wilacushganta chasquicuyargayquisu?’ ninanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Saypitami Jesús nergan: “Manami pipis acsita sarisinsu pacagninman churananpä, ni cajun rurinman pacananpäga. Saypa trucanga alayrinninmanmi churan wayiman yaycogcunata asicyapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lapanta asicyapänanpä runacuna acsita sarisishgannölami nogapis wilacuycä lapan runacuna tantyayänanpä. Pipis tantyacog cäga wilacushgäta tantyar chasquicuyanmi. Mana tantyacog cagmi isanga wilacushgäta mana tantyar chasquicuyansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Waquin runacuna wilacushgäta chasquicushganta nicarpis janan shongulami chasquicush. Cuidä say runacunano cayanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wilacushgäta rasunpaypa chasquicush carga acsi asicyashgannömi runacuna ricacuyänanpä wilacuynë nishganno cawanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús parlayta ushasquiptinnami juc fariseo runa pushargan wayincho micuyänanpä. Chaycurmi mësa cagman Jesús jamacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Micunanpä manami maquinta awicorgansu fariseo runacunapa costumbrin cashgannöga. Saymi pushag fariseo runa yarpachacushpan Jesusta ricapargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Saymi Jesús nergan: “Gamcunaga pusillupa y plätupa janalanta maylar rurintaga mana maylagnömi caycäyanqui. Saymi pusillupa y plätupa rurincho ganra cashganno mana ali yarpäyashgayquiwan ambiciöso cayashgayquipis shonguyquicunacho caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana tantyacog fariseucuna! ¿Manacu musyayanqui Tayta Diosninsi cuerpuyquita camar shonguyquitapis camashganta? Saymi cuerpuyqui limpio cananpä yarpachacushgayquino shonguyquipis limpio cananpä yarpachacuyanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gamcunaga muchogcunata imalachöpis yanapäyay. Sayno rurayaptiquirämi pusillupa rurin maylash cashganno shonguyquicunapis limpio cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Fariseucuna! ¡Juicio finalcho fiyupami laquicuyanquipä! Gamcunaga templuman apayänayquipä mentapita, rüdapita y waquin jachacunapitapis diezmuta imaypis raquiycäyanqui: ‘Tayta Diospa palabrancho nishgannöla lapantami cumpliycä’ niyashpayqui. Sayno rurarpis runa mayiquicunataga manami ali ricaycäyanquisu ni cuyapaycäyanquisu. Diezmuta templuman apar Tayta Diosninsipa palabranta cumpliyashgayquinöla runa mayiquitapis cuyayanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Fariseucuna! ¡Juicio finalcho fiyupami laquicuyanquipä! Gamcunaga imaypis munaycäyanqui sinagogacunacho alinnin bancumanrä jamacuytami. Saynöpis gamcuna munaycäyanqui cällicunacho waquin runacunapita más respëtuwan saludash caylatami. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Gamcunaga juicio finalcho fiyupami laquicuyanquipä! Melanaypä pamparaycag ayanömi caycäyanqui. Say pamparashgan jananpa mana musyar pipis purishgannömi musyansu fiyu runa cayashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sayta wiyar Moisés guelgashganta yachasegpis nergan: “Sayno nerga nogacunatapis wiyaycäsimanquichä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Niptin Jesús nergan: “¡Moisés guelgashganta yachasegcuna! ¡Saynölami gamcunapis juicio finalcho fiyupa laquicuyanquipä! Gamcunaga runacuna ima ruraytapis mana camäpacuyashganyagmi Moisés guelgashgan leycunamanpis yapa yaparcur imatapis cumplinanpä niyanqui. Sayno yachasiyashgayquicunata cumpliyta runacuna mana camäpacuyashganta ricaycarpis yanaparcuyänayquipa trucanga olgutupaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Juicio finalcho fiyupami laquicuyanquipä! Unay runacuna wanusiyashgan profëtacuna pamparäyashgan janancho gamcunaga nïchuncunata ruraycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sayno sharcasirpis manami cäsucuyanquisu profëtacuna niyashgancunata. Sayno mana cäsucuyashpayquimi runacunata musyaycäsiyanqui say profëtacunata wanusegcunanöla gamcunapis caycäyashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Sayno captinmi imano cananpä cagtapis musyar Tayta Diosninsi unay nergan: ‘Paycunamanmi cachamushä wilacognëcunata y apostolnëcunatapis. Sayno captinpis paycunaga waquintami wanusiyanga y waquin cagtanami marcan marcan gaticachäyangapä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Say nishgannölami Abelta wanusishganpita-pasa Tayta Diosninsipa profëtancunata runacuna imaypis wanusiyargan Zacariasta templo puncucho wanusishganyag. Say wanuseg runacunatanömi canan wisan Israel runacunata Tayta Diosninsi juzgangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Moisés guelgashgan leycunata yachasegcuna! ¡Juicio finalcho fiyupami laquicuyanquipä! Wayiman pipis mana yaycunanpä llävipa wawanta saricuycognömi runacunata wichgapaycäyanqui Tayta Diosninsi munashganta mana yachacuyänanpä. Saynölami quiquiquicunapis chasquicuyanquisu Tayta Diosninsipa wilacuyninta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesús sayno niptin Moisés guelgashganta yachasegcunawan fariseucuna rabiacurcuyargan. Saypitana wajupar Jesusta imaycatapis niyargan lutanta parlaptin saylawan acusayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesús sayno parlaycaptinmi waranganpa runacuna wayi puncuman shuntacäyargan. Jesusta wiyayta munayashpanmi tanganacurrä saycho caycäyargan. Saymi discïpuluncunata Jesús nergan: “Fariseucunaga runacuna ricayänalanpämi ali-tucuyan. Cuidä paycunano ishcay cära caycäyanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pacaylapa jusalicuyashgayquipis juicio finalcho musyacangami. Manami ima jusalicuyashgayquipis mana musyacaypaga cangasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Saynömi pacaylapa wilanacuyashgayquipis y puncuta wichgacuycur parlacuyashgayquipis juicio finalcho lapan mayacangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Cuyaynëcuna, ama mansayanquisu pipis wanusishunayquipä jurapäshuptiqui. Wanusiyäshushpayquipis almayquitaga manami wanusengasu ");
INSERT INTO qvhNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Chiquishogniquicunata mansacur cäsucuyänayquipa trucanga Tayta Diosninsita cäsucuyay. Paymi isanga munayyog caycan almantinta pitapis infiernuman gaycunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tantyacuyay. Chanquishcunata runacuna mana cäsupaptinpis Tayta Diosninsi lapantami ricaycan. Chanquishtapis sayno ricaycarga gamcunata masrämi Tayta Diosninsi ricaycäshunqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Agsayqui ayca cashgantapis payga musyaycanmi. Tayta Diosninsi sayno ricaycäyäshuptiquega ama mansayaysu pipis wanusiyta munayäshuptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Pipis nogata chasquicamashganta mana pengacuypa wilacuptenga nogapis angilcunapa naupancho paycunapa favorninmi parlashäpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pipis runacunapa naupancho pengacushpan chasquicamashganta ñëgamaptenga nogapis angilcunapa naupancho paycunata: ‘Manami reguësu’ nishäpämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tayta Dios cachamushgan Cristo cashgäta mana tantyar conträ parlaptenga Tayta Dios perdonangapämi. Santu Espíritu nogapita tantyaycäsiptin conträ parlaptinmi isanga Tayta Dios imaypis perdonangasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Gamcunata juzgashunayquipä sinagogacunaman, juezcunaman y waquin autoridäcunaman apayäshuptiquipis ama laquicuyanquisu: ‘¿Imatarä nishä?’ nishpayqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Santu Espiritunami tantyasishunquipä imata niyänayquipäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Runacunapa chaupinpita juc runa nimorgan Jesusta: “Wauguëta niycuy herenciata raquipämänanpä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Saymi Jesús nergan: “Amïgo, manami juezniquisu ni albasyayquisu noga cä sayno manacamänayquipäga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nircur runacunata nergan: “Ama imapäpis wachacash cayaysu. Ali cawayga manami imaycayogpis caylachöräsu caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Saymi Jesús wilapargan: “Juc rïcu runashi murushganpita ascata cosechargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sayshi say rïcu runa yarpachacorgan: ‘Cananga ¿maymantä saysica micuyta churashä? Wayë manami aypannasu micuynëcunata pirwanäpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sayno yarpachacuycashganchöshi nergan: ‘Canan pirwa wayëta juchurcasirmi jucta sharcasishä más jatuncarayta. Nircurmi sayman lapan shuntashgä micuynëta pirwashäpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sayno pirwacuycuptëga asca watapämi micuynë cangapä. Nircurnami micur upur cushishla cawacushäpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sayno yarpachacuycaptinshi Tayta Diosninsi nergan: ‘¡Mana ali yarpayyog runa! ¡Canan sacaymi wanunquipä! Lapan pirwacushgayqui ¿pipärä canga?’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesús sayno parlayta ushasquirmi nergan: “Say wanog rïcu runa waläla cosëchata shuntashgannömi quiquilanpä imatapis munagcunaga wanur imatapis chasquiyangapäsu Tayta Diosninsipita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nircur discïpuluncunatapis Jesús nergan: “Gamcunaga ama yarpachacuyaysu: ‘¿Imatarä micuycushä? ¿Imatarä jaticuycushä?’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Micuyninsi captinpis y mödanansi captinpis manami saylachösu ali cawayta tarinsi. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Shumag tantyacuyay pishgucuna imano cawayashgantapis. Paycunaga manami murucuyansu, ni cosechayansu ni pirwacuyansu. Sayno captinpis Tayta Diosninsimi micuyta puestupan. Tayta Diosninsipäga say pishgucunapitapis gamcuna masmi väliyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mayjina yarpachacurpis ¿pirä winarcunman tamäñunpita juc cucush maslatapis? ");
INSERT INTO qvhNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Saynölami mayjina yarpachacurpis say yarpachacushgalanwanga pipis tarengasu mödanatapis ni micuytapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tantyacuyay waytacuna imano cuyaylapä tuctuyashgantapis. Waytacunaga mana aruycarpis mana puscacuycarpis cuyaylapämi ricacuyan. Say waytacuna cuyaylapä cayashgannöga manami unay rey Salomón jaticushgan mödanancunapis cuyaylapä cashgasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Saquiptin rupasish cananpä captinpis Tayta Diosninsega alimi guewacunata winasin. Yäracuyniynag runacuna, waytacunatapis cuyaylapäta tuctuycäserga ¿manasurä gamcunatapis Tayta Diosninsi yanapäyäshunqui mödanayquita tariyänayquipä? ");
INSERT INTO qvhNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Sayno caycaptenga ama laquicuyaysu imata micuyänayquipä ni imata upuyänayquipäpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Saynöga laquicuyan Tayta Diosman mana yäracog runacunalami. Gamcunaga ama paycunano laquicuyaysu. Imata nistashgayquitapis Tayta Diosninsega musyaycanmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nistashgayquicunapä yarpachacuyänayquipa trucanga Tayta Diosninsi munashganno cawayänayquipä imaypis yarpachacuyay. Pay munashganno cawayaptiquega imata nistäyashgayquitapis puestupäyäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sayno caycaptenga, cuyaynëcuna, ama laquicuyaysu. Gamcunatami Tayta Diosninsi acrayäshushcanqui imayyagpis paypa naupancho cawayänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Sayno caycaptenga imayquicunatapis ranticuycur say guellaywan muchogcunata yanapäyay. Sayno yanaparga gloriaman riquëzayquita churacognömi caycäyanqui. Saynöpami gloriaman char cay pasacho ima riquëzapitapis más ali cagcunata chasquiyanquipä. Saytaga manami suwapis apangasu ni puyupis ushangasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Rïcu canalayquipä yarpachacorga manami Tayta Dios munashganno cawanayquipä yarpachacuycanquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Noga cutimuptë chasquicamänayquipä puestucush maya mayala caycäyay. Patronnin casaray fiestapita cutimunanta shuyaraycag ashmaycunanöla nogatapis shuyacayämay cutimuptë chasquicayämänayquipä. Puncuta jucla quichapäyänanpä ashmaynincuna acsinwan shuyaragno gamcunapis puestucushla caycäyay. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sayno shuyämagcunataga mësa cagman jamaycasir quiquë sirviptëmi fiyupa cushicuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Imay hörapis cutimushämi: pulan pagas carpis o walpa wagay carpis. Sayno caycaptenga maya mayala cutimunäta shuyarämay. Shuyacamagcunaga gloriaman pushaptëmi cushicuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Pipis wayinta suwapänanpä cashganta musyarga mana punuypami wayinta täpanman. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Saynöla gamcunapis puestucushla caycäyay. Mana musyayashgayqui hörami elagpita noga cutimushäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sayno niptinmi Pedro taporgan: “Sayno yachasishgayquega ¿nogacunalapäcu o lapan runacunapäwancu caycan?” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Niptin Jesús nergan: “Patronnin maypapis ilarga más yäracuypä cag ashmaynintami haciendancho lapantapis shumag ricananpä churan. Saymi say ashmayga mincaynincunatapis höralancho garasin. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Patronnin cutimur yäsishganno ali ruraycagta tariycorga: ‘Ali ashmaymi canqui’ nengapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sayno nishpanmi patronnin say ashmaypa maquinman churanga lapan imaycantapis ricananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mana yäracuypä cag ashmaymi isanga: ‘Patronnë manarämi cutimongaräsu’ nir ashmay mayinta magan y micur upyar jitaräcun. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sayno caycaptinmi mana yarpashgan höra elagpita patronnin cutimonga. Patronnin yäsishganta mana cäsucur lutanta ruraycagta tariycurmi mana cuyapaypa say ashmayta castigangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","“Mana musyayninpa juc ashmay lutanta ruraptenga patronnin manami aläpasu castiganga. Patronnin nishganta musyaycar mana wiyacuypa lutanta ruraptinmi isanga patronnin segaypa castiganga. Saynölami Tayta Diosninsipa wilacuyninta musyaycar pipis mana cäsucuptenga más fiyupa juzgash canga. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Cay pasaman noga shamushcä chasquicamagcuna salvash cayänanpä y mana chasquicamagcuna juzgash cayänanpämi. ¡Maynapis runacunata juzgar galaycömanna! ");
INSERT INTO qvhNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Isanga runacunata salvanäpäga fiyupa nacarrämi wanushäpä. Nacanäpä cashganta musyarmi fiyupa laquicö. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Gamcuna yarpaycäyanqui cay pasaman shamush captë runacuna cuyanacur alina cawayänanpä cashgantami. Manami yarpäyashgayquinösu canga. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpitaga yäracamagcunata mana yäracamagcuna chiquiyangami. Sayno carmi juc wayicho quiquinpura chiquinacuyanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taytanmi chiquenga surinta y surinmi chiquenga taytanta. Mamanmi chiquenga wawanta y wawannami chiquenga mamanta. Lumsuyninmi chiquenga suedranta y suedrannami chiquenga lumsuyninta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Saypitanami runacunata Jesús nergan: “Inti jeganan cagpa pucutay yurimuptenga: ‘Tamyanganami’ niyanqui, y niyashgayquinölami tamyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inti jegamunan cag derëcha cag lädupita vientu vientumuptenga: ‘Shanangami’ niyanqui, y niyashgayquinölami shanan. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Musyag-tucogcuna! Ciëluta ricar y cay pasata ricar imano tiempo cashgantapis tantyaycarga ¿imanirtä tantyacuyanquisu jusalicuyashgayquipita Tayta Diosninsi juzgayäshunayquipä cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tiempo cashganyag ¿imanirtä yarpachacuyanquisu salvash cayänayquipä? ");
INSERT INTO qvhNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","¿Manacu pipis quejacuyäshuptiquega autoridäman manarä char arreglayanqui? Mana arreglayaptiquega juezmanmi apasiyäshunqui. Jueznami wardiacunawan carcilman wichgasiyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Saypitaga manami yarguyanquipäsu lapan jagan cashgayquita manarä pägapacorga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sayman chaycurmi runacuna Jesusta wilayargan: “¡Galilea runacuna templucho Tayta Diosninsipä uywacunata rupaycäsiyaptinshi Pilato soldäduncunata cachargan wanusiyänanpä!” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sayno wilayaptinmi Jesús nergan: “Ama yarpäyaysu waquin Galilea runacunapita say wanog runacuna más jusayog cayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Manami Tayta Diosninsipa castïgunwansu paycuna wanuyash. Gamcunami isanga Tayta Diosninsipa castïgunwan infiernucho nacayanquipä jusalicuyta mana cachariyashpayquega. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Saynöpis Siloé nishgancho törri juchur chunca puwag (18) runacunatami nitergan. Sayno captinpis ama yarpäyaysu Jerusalencho tag waquin runacunapita say wanog runacuna más jusayog cayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Manami Tayta Diosninsipa castïgunwansu paycunapis sayno wanuyash. Gamcunami isanga Tayta Diosninsipa castïgunwan infiernucho nacayanquipä jusalicuyta mana cachariyashpayquega.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Saymi mana cäsucog runata mana wayog jïgusman tincusishpan Jesús nergan: “Juc runapa chacranchöshi cargan jïgus. Sayshi jïgusta palag aywar tarergansu ni juclaylatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Saymi nergan chacran arogta: ‘Quimsa watanami shamö cay jïguspa wayuyninta palag y manami ni juclaylatapis tarishcäsu. Muturir jucla jitariy cay chacrapita. Mana wayogtaga ¿imapätä walälaga chacrachöpis sararäshun?’ ");
INSERT INTO qvhNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sayno niptin chacran arog runa nergan: ‘Shuyaycushun juc watayag, taytay. Iscata winaparcurrä uryashä. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sayno ruraptëga pagta wayunmanpis. Saycho mana wayuptinmi isanga muturir jitariycushunpä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juc sábado jamay junagchömi sinagogacho Jesús yachaycäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Saychömi caycargan supay curcuyäsishgan warmi. Paymi nacaycargan chunca puwag (18) watana derechacayta mana puëdishpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Say warmita gayaycurmi Jesús nergan: “Cananga aliyashganami caycanqui curcuyash cashgayquipita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sayno nir yataycuptin jinan höra aliyargan. Aliyarcurna say warmi Tayta Diosninsita alabargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sábado jamay junagcho Jesús aliyäsish captinmi say sinagogacho mandag ajanargan. Saymi runacunata nergan: “Sogta junagmi caycan runacuna aruyänanpä. Say junagcunacho shayämunqui aliyayta munarga. ¡Ama sábado jamay junagchöräga shayämunquisu!” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Saymi Jesús nergan: “¡Ishcay cära runacuna! Sábado jamay junag captinpis ¿manacu töruyquicunata ashnuyquicunata pascarcur yacuseg gatiyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chunca puwag (18) watami cay warmita curcuyaycasir Satanás nacasish. Uywayquicunatapis sábado jamay junagcho sayno cuyapaycäyaptiquega ¿manacu cay Israel warmitapis cuyapashwan, sábado jamay junag caycaptinpis?” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sayno niptinmi chiquegnincuna pucayayparä pengacuyargan. Waquin runacunami isanga cushicuyargan say warmita aliyäsishganta ricar. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Mastapis Jesús tincusiypa yachasir nergan: “Tayta Diospa ali wilacuynenga ñäbus murunömi caycan. Ñäbusta muruptin winamun ata cashganyag. Saymi pishgucunapis gueshuncunata rämancunacho rurayan. Say tacshala murulapita ñäbus winarcamur räman mashtacashgannömi Tayta Diospa ali wilacuynenga may-saymanpis chaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Nircur Jesús caynöpis nergan: “Tayta Diospa ali wilacuynenga levadüranömi caycan. Tantata rurananpä warmi quimsa arröba jarinaman levadürata winaptenga mäsa shumagmi jacan. Ichicla levadüra mäsata jacasishgannömi Tayta Diosninsipa wilacuyninpis may-sayman changapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Saypita Jerusalenpa Jesús aywarmi marcacunapa y jalgacunapapis yachasiraycar päsargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Saychömi juc runa taporgan: “Taytay, ¿walcaglacu salvacuyanga?” Saymi Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Salvacuyänayquipäga quichqui puncupanörämi gloriaman yaycuyänayqui. Ascag yaycuyta munarpis walcaglami say puncupa yaycuyanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wayipa duëñun puncunta wichgacarcamuptin wagtacho quëdagcuna cayno nirmi tacacuyangapä: ‘Quichapaycalämay, taytay’ nir. Sayno gayacuyaptinmi pay nengapä: ‘Gamcunataga manami reguësu. ¿Pirä cacuyanquipis?’ ");
INSERT INTO qvhNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Saymi niyangapä: ‘¿Imanirtä reguiyämanquisoga? Micurchä upurchä purergansi. Y marcäcunachöpis yachasergayquichä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Saymi yapay nengapä: ‘Gamcunataga manami reguësu. ¿Pirä cayanquipis? ¡Nogapita witicuyay, jusasapa runacuna!’ ");
INSERT INTO qvhNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Gloriaman mana yaycur, Abrahamta, Isaacta, Jacobta y Tayta Diosninsipa profëtancunatapis saycho caycagta ricayashpan segaypami wagayangapä. Fiyupa laquicurmi quiruntapis uchuyanga, yaycuyta mana puëdiyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","May-saypitapis shamog runacuna gloriaman yaycog cagmi isanga Tayta Diosninsi camarishgan micuyta cushishla micuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Cay pasacho mana ali ricash cagcunaga Tayta Diosninsi juzganan junag ali ricashmi cayangapä. Yachag-tucogcunami isanga say junag infiernuman gaycush cayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sayman waquin fariseucuna chaycurmi Jesusta niyargan: “¡Caypita aywacuy! Herodismi wanusiyta yarpaycäshunqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Saymi Jesús nergan: “Say alguta wilay: ‘Juc ishcay junaglanashi supaycunata runacunapita Jesús gargonga y gueshyagcunatapis aliyäsenga. Saycunalawannashi ushanga lapan rurananpä cagcunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Saypitanashi Jerusalenman aywanga wanusish cananpä. Diospa wilacognincuna Jerusalencho wanuyashgannöshi paypis, Diospa wilacognin cayninpa, Jerusalenchörä wanonga.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Saypita Jesús nergan: “¡Jerusalén runacuna! ¿Imanirtä Tayta Diosninsipa profëtancunata y cachamushgan wilacogcunata naupapita-pasa wanuycäsiyanqui? Chipshancunata maman shuntarcur oglacognöpis gamcunata asca cutimi shuntayta munargä. Sayno munaptëpis gamcunaga manami munayashcanquisu shuntanäta. ");
INSERT INTO qvhNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Saymi gamcunata Tayta Diosninsi manana sapäshuptiqui chiquishogniquicuna shamur marcayquitapis ushacäsiyangapä. Manami yapay ricayämanquipänasu: ‘¡Tayta Diosninsi cachamushgan runa caycarga shacalämuy, taytay!’ niyämashgayquiyag.” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Saypitana sábado jamay junagcho Jesús aywargan mandag fariseupa wayinman micog. Saycho waquin fariseucuna Jesusta ricapaycäyargan: “Mä sábado jamay caycaptin ¿imatashi ruranga?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Intëru cuerpun jacapäcuycag runata Jesús ricarmi Moisés guelgashganta yachasegcunatawan fariseucunata taporgan: “Sábado jamay junagcho ¿aliyäsishwancu o manacu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Imatapis mana parlacuyaptinmi gueshyaycag runata Jesús yataycur aliyäsergan. Aliyarcasirna nergan: “Cananga wayiquipana aywacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nircur fariseucunata nergan: “Maygayquipapis suriqui o töruyqui pözuman jegaptin ¿manacu jinan höra jorgog aywayanqui, sábado jamay junag caycaptinpis? Say rurashgayquinölami nogapis gueshyagcunata aliyäsë, sábado jamay junag caycaptinpis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sayno niptin manami imatapis parlacuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Saychömi waquin gayasishgan runacuna, ali ricash cayta munar, mësa cagmanrä aywayargan jamacuyänanpä. Sayta ricaycur Jesús yachasergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Pipis casaray fiestaman gayasiyäshuptiquega mësa cagmanräga ama jamacuyanquisu. Gamcunapita más respitädu runa chämuptin: ‘Mësapita witicuy pay jamacunanpä’ niyäshuptiqui pengacushmi mësacho jamaraycashgayquipita yargunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mësa cagman jucla jamacunayquipa trucanga shuyaranqui gayasiyäshogniqui: ‘Päsacalämuy mësa cagman jamacunayquipä’ nishunayquitarä. Sayno jamasishuptiquimi mësacho gamwan jamacogcuna ali respitayäshunquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sayno nishpanmi Jesús nergan: “Mayganpis runa-tucogcunaga pengaymanmi churash canga. Mana runa-tucogcunami isanga ali ricash canga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nircur wayinman pushag runatapis Jesús nergan: “Micuyänayquipä pitapis gayaserga ama gayasiyanquisu cuyanacuyashgalayquita, wauguilayquita, castalayquita ni rïcu cag vecïnulayquitaga. Paycuna tumayquita cutisishushgalayquimi premiuyqui canga. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Saypa trucanga gayasiyanqui muchogcunata, wegrucunata y gapracunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paycunaga manami ni imanöpapis cutisiyäshunquipäsu. Paycunata garashgayquipitaga Tayta Diosninsinami premiuta goshunqui jusaynag runacunata cawarisimushgan junag.” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Saymi mësacho jamaraycashganpita juc runa nergan Jesusta: “¡Ima cushishgarä cayanga Tayta Diosninsi camarishgan micuyta gloriacho micogcuna!” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sayno niptin tincusiypa Jesús cayno yachasergan: “Juc runashi asca runacunata invitargan juc junagcho wayinman micog aywayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Say junag chämuptinnashi ashmayninta cachargan say invitashgan runacunata pushananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Say ashmay wilag chaptinshi jucnin nergan: ‘Rantishgä chacrata ricagrämi aywanä caycan. Nogapita ama resienticuyculäsunsu.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jucagnashi nergan: ‘Pisga par törutami rantishcä. Saymi ali o mana ali cashgantapis musyanäpä canan junag yapyag aywashä. Nogapita ama resienticuyculäsunsu.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jucagnashi nergan: ‘Sayrämi warmita jorgushcä. Saymi gayasimashganman aywayta camäpacushäsu.’ Saynölashi lapan invitashgan runacuna aywayta munayargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sauraga say cachashgan ashmay cutiycur patronninta wilargan runacuna imano nishgantapis. Sayno wilaptin patronnin fiyupa rabiacorgan. Nircurna ashmayninta nergan: ‘Cällicunapa aywaycur jucla pushamuy muchogcunata, gapracunata y wegrucunatapis.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Patronnin nishganta rurarcurnashi ashmaynin nergan: ‘Nimashgayquinölami pushamushcä, taytay. Sayno captinpis mësaman manarämi runacuna juntäyanräsu.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Saynashi patronnin nergan: ‘Nänicunapa y chacracunapapis aywar saycho tarishgayqui runacunata imaycanöpapis wayëman juntäyashganyag pushamuy. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Naupata gayasimushgäcunaga perdiyashganami yanucasishgä micuyta.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ascag runacuna gatiräyaptinmi Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mayganpis discïpulö cayta munarga mamanpä, taytanpä, warminpä, surincunapä, wauguincunapä y panincunapä yarpachacunanpa trucanga más yarpachacusun noga munashgäta rurananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Discïpulöcunaga imano nacarpis noga munashgänöla imaypis cawayäsun. Wanushganyag noga munashgäno mana cawarga manami discïpulö canmansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Discïpulö caycashganpita witicogcunaga wayi rurayta galaycasir mana ushasegnömi caycäyan. Pipis wayita rurananpäga shumagrämi yarpachacun say wayita ushasinanpä gastun aypashganta o mana aypashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cimientuycular cachaycuptenga lapan ricagcunami payta jamuräyanga: ");
INSERT INTO qvhNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Say runaga puëdegnöpis wayita rurar galaycasish manapis ushasinanpä’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Maygan nacionpis juc nacionwan manarä pelyar ¿manacu puntataga mandagnin reycuna shumagrä yarpachacuyan ishcay chunca waranga (20,000) soldäducunata chunca waranga (10,000) soldädulanwan vincinanpä o mana vincinanpä cashgantapis? ");
INSERT INTO qvhNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pelyayta mana puëdinan captenga jucag cag mandag carucho caycaptilanrämi wilacogninta cachan: ‘Mananashi pelyashunnasu. Munashgayqui cagtashi imäcunatapis apacunqui’ nir wilananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Saynöla discïpulö cayänayquipä listula caycäyay noga-raycu lapan imayquicunatapis cachaycuyänayquipä. Imayquicunatapis cachariyta mana munarga manami discïpulö cayanquimansu. Nishgäta wiyag cäga shumag tantyacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Musyashgayquinöpis cachega alimi caycan micuyta gustuta gonanpä. Sulur rumilan quëdaptinnami isanga imapäpis välinnasu alpapä ni iscapäpis. Sayno captenga jitariycunsinami. Wanushgayquiyag discïpulö mana carga cuidä gamcunapis Tayta Diosninsipa naupanpita jitarish cayanquiman.” ");
INSERT INTO qvhNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impuesto cobragcunawan Diosta mana cäsucog runacunapis aywayargan Jesús yachasishganta wiyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sayta ricar fariseucunawan Moisés guelgashganta yachasegcuna Jesusta jamurargan: “¿Imanirtä cay runaga Diosta mana cäsucogcunawan shuntacaycur micun?” ");
INSERT INTO qvhNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sayno niyaptinmi Jesús tantyasergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pipis pachac (100) uyshanpita jucta ograycorga ¿manacu waquin cagta juc pasaman ayluycur jucla aywan ashimunanpä? ");
INSERT INTO qvhNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tariycorga cushishmi aparicurcur apan waquin cagman talunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wayinman chaycurnami vecïnuncunatawan reguinacuyashgancunata shuntaycur cushish wilapan: ‘¡Ograshgä uyshätami tarishcä!’ ");
INSERT INTO qvhNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Say runa uyshata tariycur cushicushgannölami Tayta Diosninsiwan angilcunapis cushicuyan juclaylapis jusasapa runa Diosta chasquicuptin. Sayno cushicuyan isgun chunca isgun (99) Dios munashganno cawag runacunapä cushicushganpita masmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Sayno pï warmipis chunca (10) guellayninpita jucta ograycorga acsita sarircasirmi jucla wayinta pisapacun ograshgan guellayta ashinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ashiycashgancho tariycorga vecïnancunata y reguinacuyashgancunatapis shuntaycur cushishmi wilapan: ‘¡Ograshgä guellaynëtami tarishcä!’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Saynömi Tayta Diosninsipa angilnincunapis cushicuyan juc runalapis jusalicuycunata cacharir Tayta Diosninsita chasquicuptin.” ");
INSERT INTO qvhNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mastapis Jesús nergan: “Juc runapashi ishcay olgu surincuna cayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sayshi shulca cag surin papäninta nergan: ‘Papá, nogata raquipämänayquipä cagcunata jucla raquipaycalämay.’ Sayno niptinshi papänin raquipaycorgan paypä cagcunata. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Saypita juc ishcay junaglatanashi lapan chasquishgancunata ranticuycorgan. Nircur say guellaywan aywacorgan caru marcapa. Saychönashi munashganta rurar lapan guellayninta manacagcunacho ushargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","15","“Say marcacho caycaptinnashi fiyupa muchuy cargan. Sayshi say magta fiyupa micanar aruyta ashiptin hacendädo runa payta chasquergan cuchinta misipänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cuchita misirnashi segaypa micanar cuchipa micuynintapis micuyta munargan. Sayno micanaycaptinpis micuy mana captinshi pipis garargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sayshi yarpachacorgan: ‘Papänëpa arognincunaga pacha junta micushcher caycäyan, caycho micanaypita wanunaptë. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cayno canäpa trucanga papänë cagpa cuticushä. Chaycorga caynömi nishä: “Papá, perdonaycalämay. Gomashgayquicunata manacagcho usharmi jusalicushcä. Manami gam munashgayquinösu ni Tayta Diosninsi munashgannösu rurashcä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cananpitaga ama chasquimaysu suriquitanöga, sinöga mincayniquitanölana chasquiycalämay.” ’ ");
INSERT INTO qvhNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sayno yarpachacusquir cuticorgan papänin cagpa. “Sayshi carulatarä shamuycagta ricaycur papänin cushicushpan cörrila aywar macalacurcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sayshi surin nergan: ‘¡Perdonaycalämay, papá! Gomashgayquicunata manacagcho ushar jusalicushcämi. Manami gam munashgayquinösu ni Tayta Diosninsi munashgannösu rurashcä. Cananpitaga ama suriquitano chasquimaysu, sinöga mincayniquitanölana chasquiycalämay.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Sayno nicaptinshi papänin ashmaynincunata nergan: ‘Más ali cag mödanata jucla jorgayämuy surë trucacunanpä. Saynöpis sortïjata y zapatuta jorgayämuy jaticunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nircur werannin turishta pishtayay fiestata ruranansipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Cay surëga wanushno cashganpita cawarimushnömi caycan! ¡Ogracash cashganpitami yurimush!’ Sayno nir cushicurshi fiestata rurayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sayyag mayor cag surenga chacrachöshi caycargan. Saypita cutimur wayiman chaycashganchöshi wiyargan wayincho fiestata ruraycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sauraga juc ashmayninta gayaycur taporgan wayincho imanir fiestata ruraycäyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tapuptin ashmaynin nergan: ‘Wauguiquimi cutimush. Saymi papäniqui pishtasish werannin turishta wauguiqui chämushganpita cushicur.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sayno wilaptinshi fiyupa rabiashpan wayinman yaycuyta munargansu. Sauraga papänin aywaycurshi ruwargan wayiman yaycunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sayshi papäninta nergan: ‘Gam musyashgayquinöpis mana yargucuypami gamta yanapaycä lapan nimashgayquicunata rurar. Sayno yanapaycaptëpis manami imaypis gomashcanquisu ni juc cabralatapis amïgöcunawan fiestata ruranäpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","¡Cay guela suriqui jusalicuylacho cawag warmicunawan guellayniquita ushasquir cutiycamuptinmi isanga pishtasishcanqui werannin turishtarä!’ ");
INSERT INTO qvhNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Sayno niptin taytan nergan: ‘Imano captinpis gamga mana yargucuypami nogawan caycanqui, hïjo. Saymi lapan imaycäcunapis gamlapäna caycan. ");
INSERT INTO qvhNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wauguiqui jusalicuyta cacharir cutimush caycaptenga imano captinpis fiestata rurashun.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Saymi discïpuluncunata yachasir Jesús nergan: “Juc ashmaynintashi patronnin churargan imaycantapis shumag ricananpä. Saypitashi say patronninta runacuna wilapäyargan imaycantapis lutala ashmaynin ushaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sayta musyaycurna patronnin gayasimorgan. Nircurna nergan: ‘Runacuna gampä parlayan imäcunatapis lutala ushaycashgayquitami. Cananga wilamay lapan imata rurashgayquitapis. Cananpitaga mananami imaycäcunatapis ricanquipänasu.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sayno niptinmi say runa yarpachacorgan: ‘¿Imatarä canan rurashä patronnë gargamaptenga? Manami calpä cansu chacracho arunäpä. Caridäta manacuytapis pengacömi. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Alfin patronnë gargamaptin jina ¿imanäshätä? Jagan runacuna yanapäyämänanpä mejor cobrashä pulalanta.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sayshi patronninpa jagan cag runacunata juc jucla gayaycasir punta cagta taporgan: ‘¿Aycatä patronnëpa jagan caycanqui?’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sayno tapuptin nergan: ‘Paypa jagan caycä ishcay pachac (200) läta aceitimi.’ Saymi say runa nergan: ‘Canan guelgashun pachac (100) läta aceitilatana päganayquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Saypita jucnin cagtana taporgan: ‘Gamga ¿aycatä jagan caycanqui?’ Say runa nergan: ‘Paypa jagan caycä ishcay waranga (2,000) arröba trïgumi.’ Sayno niptinshi nergan: ‘Canan guelgashun waranga pisga pachac (1,500) arröba trïgulatana päganayquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","9","Sayno rurashganta musyaycur patronnin nergan: ‘Yanapash cayta munarga ¡say runa amistä rurayta yachanmi!’ ” Sayno wilaparcur Jesús nergan: “Mana nacananpä say runa yarpachacushganno gamcunapis yarpachacuyay imanöpapis gloriaman chäyänayquipä. Saynöla imalayquiwanpis runa mayiquita yanapäyay paycunapis Diospa wilacuyninta chasquicur gloriaman chäyänanpä. Sayno rurayaptiquimi gloriaman chäyaptiqui cushish chasquicuyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Walcalata sararashgayquiwan runa mayiquita yanaparga ascata sarararpis yanapanquipämi. Mana yanapäcog carga ascata sarararpis manami yanapäcunquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Saynöla imata paytacushuptiquipis mana yatapacuylapa ali ricanqui. Mana yatapacog captiquega Diospa ali wilacuyninta wilapaptiquipis chasquishunquipämi. Mana yäracuypä captiquega manami cäsushunquipäsu ni imata niptiquipis. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Manami pipis ishcay patronta sirvinmansu. Ishcay patronyog carga jucninta cäsucur jucnintaga manami cäsucongasu. Jucninta cuyar jucnintaga manami cuyangasu. Saynölami rïcu canalanpä yarpachacogcunaga: ‘Tayta Diospa maquinchömi caycä’ nicarpis pay munashganno cawayta camäpacuyansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sayno yachasishganta wiyarmi fariseo runacuna Jesusta asipäyargan. Sayno asipargan imaypis rïcu canalanpä yarpachacog carmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Saymi Jesús nergan: “Gamcuna ishcay cära captiquipis Tayta Diosninsi musyanmi shonguyquicuna imano cashgantapis. Saymi runacuna respitayäshuptiquipis Tayta Diosninsipäga ishcay cära cayashgayqui segaypa mana ali caycan. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moisés guelgashgancuna, Tayta Diosninsipa profëtancuna guelgayashgancuna y Juan Bautista wilacushgancunapis nicäyan noga shamunäpä cagpitami. Saymi Juan wilacuyta galaycushganpita-pasa asca runacuna Tayta Diosninsipa wilacuyninta imanöpapis chasquicuycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ciëluwan cay pasa ushacaptinpis Moisés y waquin profëtacuna guelgayashgancunaga lapanmi cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pï runapis warminpita raquicarcur juc warmiwan targa adulteriuchömi caycan. Saynöpis runanpita raquicash warmiwan pipis targa adulteriuchömi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Saypitanami Jesús wilapargan: “Juc rïcu runashi cargan ali mödanacunalata jaticog. Saynöpis waran waran amïguncunawan fiestata rurar ali micuycunalata micuyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Say rïcu runapa wayin puncuchöshi muchog runa Lázaro jutiyog jamarargan. Läzarupa intëru cuerpuntashi gueri ushaycargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Payshi rïcu runa micur shicwapacushgalantapis micuyta munargan. Y saychöshi algucunapis Läzarupa guerinta lagwapäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lázaro wanusquiptinnashi angilcuna almanta apayargan Abraham caycashgan cagman. Y rïcu runa wanuycuptinnashi castancuna pampayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Mana cuyapäcog rïcu runapa almannashi aywargan Hadisman. Saychöshi fiyupa nacaycashgancho carupita ricargan Läzaruta Abrahampa naupancho caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sauraga rïcu runa gayacorgan: ‘Tayta Abraham, cuyapaycalämay. Läzaruta cachaycalämuy dëdunta ushmarcasir shimëta ushmasipämänanpä. Segaypami nacaycä cay ninacho rupar.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sayno niptinshi Abraham nergan: ‘Yarpay manarä wanur imaycayogpis cashpayqui ali cawashgayquita. Läzarunami isanga pobri cashpan segaypa nacargan. Saymi cananga pay cushish caycho caycan y gamna saycho nacaycanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Saynöpis jatuncaray jiu-jiuyaycag ragrami raquiycämansi. Saymi gam cashgayqui cagman pipis simpämuyta puëdinsu. Sayno gampis puëdimunquisu simpämuyta noga caycashgä cagman.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Sayno niptinshi rïcu runa nergan: ‘Tayta Abraham, papänëpa wayinman Läzaruta cachayculay. ");
INSERT INTO qvhNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Saycho pisgarämi wauguëcuna caycäyan. Paycunaman wilacog aywayculäsun cay nacayman mana shayämunanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Saymi Abraham nergan: ‘Paycuna sararanmi Moisés y waquin profëtacuna guelgayashgancunata. Saycunata cäsucuyäsun.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sayshi rïcu runa nergan: ‘Tayta Abraham, sarararpis saytaga manami cäsucuyangasu. Juc runa wanushganpita cawarircur wilacuptinmi isanga jusalicuycunata cachariyanga.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sayno niptin Abraham nergan: ‘Moisés y waquin profëtacuna guelgayashgancunata mana cäsucuycarga wanushganpita cawarircur wilacog aywaptinpis manami cäsucuyangasu.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nircurna discïpuluncunata Jesús nergan: “Jusalicunayquita Tayta Diosninsi mana munaptinpis jusaman tunisicogcuna imaypis cayangami. ¡Paycunaga juicio finalcho fiyupami laquicongapä! ");
INSERT INTO qvhNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tayta Diosman yäracogcunata jusalicasiyaptenga más alimi canman mulïnu rumita cuncanman sheguparcur lamarman garpuriyaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuidä gamcunapis jusaman tunisicogcunano cayanquiman. “Tayta Diosman yäracog mayiqui imalachöpis rabianäsishuptiquega jusalicuycashganta tantyasinqui. Tantyasiptiqui chasquicuptenga perdonanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Juc junagcho ganchis cuti rabianäsishuptiquipis: ‘Perdonaycalämay’ nishuptiquega perdonanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sayno niptin apostolnincuna Jesusta niyargan: “Yanapaycayämay Tayta Diosninsiman más yäracur runa mayëta nishgayquino perdonayänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sayno niptinmi Jesús nergan: “Ñäbuspa murunno tacshalapis yäracuyniqui captenga cay jatuncaray sicómoro jachata: ‘Sapipita luquicarcur lamarman jawicämuy’ niyaptiquipis jawicämongami.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ashmaynincuna arushganpita o misicushganpita chaptin manami pipis ashmayninta: ‘Jamayculay micuyänayquipä’ ninsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Saypa trucanga lapanpis niyan: ‘Yanucamuyrä garamänayquipä. Micusquiptërämi gamga micunquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mandashganta ruraycaptinpis manami ‘Päquilä’ ninsu say ashmayninta. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Ashmaynölami gamcunapis caycäyanqui. Saymi Tayta Diosninsi munashganta rurarpis ama shuyacuyanquisu pipis: ‘Alitami rurashcanqui’ niyäshunayquita. Saypa trucanga niyay: ‘Nogacunaga Tayta Diosninsipa ashmayninmi caycäyä. Saymi munashgalanta ruraycäyä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalenpa aywarmi Jesús päsargan Samaria y Galilea provinciacuna cuchulanpa. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tacsha marcaman chänanpä caycaptinmi leprawan gueshyaycag chunca (10) runacuna payta ricayargan. Saymi carulapitana gayacuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“¡Tayta Jesús, nogacunata cuyapaycayälämay!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Saymi Jesús nergan: “Aywayay cüracunaman ricayäshunayquipä.” Sayno niptin aywaycäyashgalanchöna aliyäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Saymi aliyashganta tantyaycur juc cutergan Jesús cagman Tayta Diosninsita alabaraycar. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chaycurnami gongurpacuycorgan Jesuspa puntanman: “¡Päquilä, taytay!” nishpan. Say cuteg runaga cargan Samariapitami. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Saymi Jesús nergan saycho cag runacunata: “Leprapita aliyagcunaga ¿manacu chuncag (10) cayargan? ¿Maytä waquin cäga? ");
INSERT INTO qvhNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Waquin cag Israel runa caycarpis aliyashganpita Tayta Diosta alabayänanpä manami cutiyämushgasu. Cay runami isanga, mana Israel runa caycarpis, cutimush Tayta Diosninsita alabananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nircur say runata nergan: “Cananga aywacuyna. Tayta Diosman yäracushgayquipitami salvashgana caycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Juc cutimi Jesusta fariseucuna tapuyargan: “Israel runacunapa mandagnin Cristo chämunanpäna caycashganta ¿imanöpatä musyayäman?” Sayno tapuptin nergan: “Tayta Dios cachamushgan Cristo chämunanpäna caycashganta manami lapan runacunasu tantyacuyanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manami pipis nengasu maychöpis caycashganta. Saypa trucanga Tayta Diosninsi cachamushgan Cristo gamcunawannami caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Saypita más rätuntanami discïpuluncunata nergan: “Gloriaman aywasquiptë gamcuna segaypami munayanqui jucla noga cutimunäta. Sayno munayaptiquipis manami jucla cutimushäsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pipis: ‘Saychömi o wacchömi Tayta Dios cachamushgan Cristo caycan’ nishuptiquipis ama cäsuyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wiscurcuna shuntacagta ricarmi musyansi wanush uywa saycho jitaraycashganta. Saynölami cay nishgäcuna päsaycagta ricar musyayanqui noga cutimunäpäna caycashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sayno manarä captinmi puntataga runacuna chiquimar segaypa nacasimanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noé cawanan wisan diluvio elagpita cashgannömi nogapis elagpita cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé cawanan wisanpis runacunaga micur, upyar y majasacarmi caycäyargan. Sayno cawayargan arcaman Noé yaycushgan junagyagmi. Sayno caycaptinmi elagpita fiyupa tamyar cay pasaman yacu juntargan. Saynöpami lapan runacuna shengaypa wanur ushacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Saynölami Lot cawanan wisanpis runacuna micur, upyar, rantir, ranticur, murupacur y wayitapis sharcasir caycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma marcapita Lot yargusquiptinnami ciëlupita tamyamorgan azufriyog nina. Saychömi lapan runacuna rupaycar wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Saycuna elagpita päsashgannömi nogapis elagpita cutimushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Say junäga wayinpita wagtacho caycagcuna ama wayinman yaycuyäsunsu imancunata jorguyänanpäpis. Saynöla chacracho caycagcunapis wayinman amana cutiyäsunsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cuidä Lotpa warmin Diosta mana cäsucog cashganno gamcunapis cayanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tayta Diosta cäsucunanpa trucan quiquin munashganno cawacuyta munagcunaga manami pipis gloriaman chäyangasu. Tayta Dios munashganno cawag cagcunami isanga gloriaman char imayyagpis cawayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Cutimushgä junagmi juc cämalacho ishcag punuycagpita chasquicamag cagta apacushä y mana chasquicamag cagtanami cacharishä. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Maraycho ishcay warmicuna agacuycagcunapita chasquicamag cagta pushacushä y mana chasquicamag cagtanami cacharishä. ");
INSERT INTO qvhNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chacracho ishcay runacuna aruycagpita nogaman yäracamag cagtami apacushä y mana yäracamag cagtanami cacharishä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sauraga sayta wiyaycur discïpuluncuna tapuyargan: “Sayno shuntashgayqui höra nogacuna ¿maychötä cayäshä, taytay? ¿Gamwancu o manacu?” Sayno tapuyaptinmi Jesús nergan: “Wiscurcuna uywa wanush caycagman juntacäyashgannömi gamcunapis noga cashgä cagcho shuntacash cayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mana ajayaypa Tayta Diosta manacuyänanpä discïpuluncunata Jesús yachasir nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Juc marcachöshi Tayta Diosta ni runacunatapis mana mansapacog juez cargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Say marcachöshi targan juc viüda warmipis. Payshi say juezman aywargan: ‘Quejacushgäta arreglaycalämay, taytay’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Sayno yaparir yaparir aywaptinpis juezga manashi cäsorgansu. Nircurnashi say juez cayno yarpachacorgan: ‘Diosta mana mansapacurpis ni runacunata mana mansaparpis cay warmipa demandunta jucla arreglashä. Mana arreglaptëga imay hörapis cutiycämongami fastidiamar umäta nanäsinanpä’.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Sayno wilaparcurmi Jesús nergan: “Say juez fiyu runa caycarpis viüda quejacushganta arreglaycaptenga ¿manasurä Tayta Diosninsipis wiyanga payman yäracogcuna manacuyashganta? Manami walälasu pagasta junagta Tayta Diosninsita manacuyanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Manacog cagtaga Tayta Diosninsi mana shuyaräsiylapami yanapanga. Sayno caycaptinpis cay pasaman noga cutimushpä ¿tarishäsurä pilapis yäracaycämagta?” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Juc cutichömi ishcay cära runacunata Jesús wilapargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcay runashi aywayargan templuman Diosta manacuyänanpä. Jucagshi cargan fariseo y jucagnashi cargan impuesto cobrag. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sayshi fariseo cäga ichircur manacorgan: ‘Päquilä, Tayta Dios. Gamta agradëcicö waquin runacunano mana cashgäpitami. Paycunaga cayan suwa, Diosta mana cäsucog, adulteriucho cag. Saynöpis gamta agradëcicö tagay impuesto cobrag runano mana cashgäpita. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ayunäpis semänacho ishcay cutimi. Saynölami imaypis diezmöta apä templuman.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Impuesto cobrag cagnashi isanga carulacho ichicuycorgan. Payga jusasapa carshi ciëluman rircäriylapis rircärergansu. Saypa trucanga fiyupa laquicushpan: ‘Cuyapaycalämay, Tayta Dios. Nogaga jusasapa runami cä’ nergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Saymi impuestuta cobrag cäga wayinman cutergan jusanpita perdonashgana. Fariseo cagtami isanga Tayta Diosninsi perdonargansu. Saynölami mayganpis ishcay cära cagtaga Tayta Diosninsi perdonangasu. Jusayog cashganta tantyacog cagtami isanga perdonangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Saypitanami wamracunata Jesús cagman apayargan umanman maquinta churaycur Tayta Diosta manacunanpä. Wamracunata apaycagta ricarmi discïpuluncuna michäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sayno michäyaptinpis wamracunata Jesús gayargan shayämunanpä. Nircurnami discïpuluncunata nergan: “Wamracunata apacayämunanta ama michäyaysu. Wamrano cagcunami Tayta Diospa naupanman chäyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pipis Tayta Diosninsipa naupanman chayta munarga papänin nishganta wamra criyishganno Tayta Diosninsi nishganta criyisun. Wamrano criyegcunalami Tayta Diospa naupanman chäyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juc mandag runami Jesusta nergan: “Gam imaycatapis musyanquimi, taytay. Saymi tapuculäshayqui. ¿Imatatä ruräman Tayta Diospa naupanman chänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Saymi Jesús nergan: “¿Imanirtä yarpanqui lapantapis musyashgäta? Tayta Diosnilansimi lapantapis musyaycan. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tayta Diosninsipa naupanman chänayquipäga mandamientucunata cumpliy. Musyanquimi mandamientucuna cayno nishganta: ‘Ama adulteriucho canquisu. Runa mayiquita ama wanusinquisu. Ama suwacunquisu. Manacagtaga ama pitapis tumpanquisu. Mamayquitawan taytayquita ali ricanqui.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Niptin say runa nergan: “Saycunataga wamra cashgäpita-pasami lapanta cumplishcä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sayno niptin Jesús nergan: “Lapanta cumpliycarpis Tayta Diospa naupanman chänayquipäga jucrämi pishëshunqui ruranayquipä. Lapan imayquicunatapis ranticuycur guellayta muchogcunata aypuy. Nircur nogawan aywashun yachasishgäta yachacunayquipä. Sayno rurashpayquega gloriaman riquëzayquita churacognömi caycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sayno niptinmi say runa laquicorgan segaypa rïcu cashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Laquish caycagta ricar Jesús nergan: “¡Ajami caycan rïcu runacuna Tayta Diospa naupanman chäyänanpäga! ");
INSERT INTO qvhNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Auja uchcupa camëllo päsayta mana camäpacushganno rïcu runapis quiquilanpitaga Tayta Diospa naupanman chayta manami camäpacunsu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sayno niptinmi wiyagcuna Jesusta tapuyargan: “Sayno captenga ¿pirä salvaconga?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Niyaptin Jesús nergan: “Quiquilanpitaga runacuna manami salvacuyta camäpacuyansu. Tayta Dioslami pitapis salvan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Saymi Pedro nergan: “Nogacunaga lapantami imaycätapis cachariyashcä gamta gatiräyänäpä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Sayno niptin Jesús nergan: “Tayta Diosninsipa wilacuyninta wilacunayqui cash wauguiquicunata, paniquicunata, mamayquita, taytayquita, suriquicunata, wayiquita y chacrayquicunatapis cacharerga cay pasacho pachac (100) cuti mastami chasquinquipä. Saynöpami paniquipis, wauguiquipis, mamayquipis, taytayquipis, chacrayquicunapis y wayiquicunapis gampa canga. Isanga wilacuynëta wilacushgayquipita runacuna chiquiyäshunquipämi. Sayno captinpis Tayta Diospa naupanman char imayyagpis cushishmi cawanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Saypitami chunca ishcay (12) acrashgan cag discïpuluncunata gayaycur Jesús nergan: “Musyayanquimi Jerusalenpa aywaycashgansita. Jerusalenman chashgami Tayta Diosninsipa profëtancuna guelgayashgannöla lapanpis nogata päsamanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Saymi wanusimänanpä mana Israel runacunapa maquinman autoridäcuna entregayämanga. Paycunami asipäyämanga, ashliyämanga y togapäyämangapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Saynöpis astarcamar wanusiyämanga. Sayno captinpis quimsa junagtaga cawarimushämi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sayno niptin discïpuluncuna manami tantyayargansu imapita parlaycashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Saypita Jericó marcaman Jesús yaycuycaptinna nänicho jamaraycargan juc gapra runa caridäta manacur. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sauraga asca runacuna aywaycagta mayarmi say gapra runa tapucorgan pï päsaycashgantapis musyananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tapucuptinmi wilayargan: “Nazaretpita cag Jesusmi päsaycan” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wilaycuptinmi gayacorgan: “¡Rey Davidpa castan Jesús, cuyapaycalämay!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Saymi puntanta aywaycagcunaga say gaprata olgutupäyargan upälacunanpä. Sayno olgutupäyaptinpis masrämi gayacorgan: “¡Rey Davidpa castan Jesús, cuyapaycalämay, ari!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sayno gayacushganta wiyarmi Jesusga ichicuycushpan gayasimorgan. Naupanman chaycasiyaptinna taporgan: ");
INSERT INTO qvhNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Imacho yanapänätatä munaycanqui?” nir. Gapranami nergan: “¡Nawë ricanantami munaycä, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Niptin Jesús nergan: “¡Ricayna! Yäracamayniquipami canan nawiqui ricangana.” ");
INSERT INTO qvhNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sayno niptinmi jinan höra gaprapa nawincuna ricarganna. Ricarnami Jesuspa guepanpa aywargan Tayta Diosninsita alabaraycar. Sayta ricaycur lapan runacuna Tayta Diosninsita alabayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Jericó marcachömi targan Zaqueo jutiyog rïcu runa. Paymi cargan impuesto cobragcunapa mandagnin. Sauraga Jericó marcapa asca runacunawan Jesús päsaptinmi tacshala car ricayta puëdergansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Saymi Jesús päsaycagta ricananpä cörrila aywar Zaqueo wisacurcorgan sicómoro gueruman. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Saypa päsaycashgancho Zaqueuta ricärir Jesús nergan: “Zaqueo, jucla urämuy. Wayiquimanmi aywaycä posädasimänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sayno niptinmi Zaqueo jucla urarcur Jesusta cushish pushargan wayinman. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sayta ricaycur lapan runacuna Jesusta jamuräyargan: “¿Imanirtä jusasapa runapa wayinman aywaycan posädacunanpä?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wayinchöna caycarmi Jesusta Zaqueo nergan: “Sararashgäpita pulantami imätapis muchogcunata raquipaycushä, taytay. Sayno pipa imantapis guechushgäpita chuscu cuti mastami cutisishä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sayno niptin Jesús nergan: “Cananga salvashganami caycanqui gampis y wayiquicho tagcunapis. Abraham yäracushgannömi gampis Tayta Diosninsiman yäracuycanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jusasapa runacunata salvanäpämi Tayta Diosninsi nogata cachamash.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalenman Jesús aywaycaptinnami runacuna yarpäyargan sayman chaycuptin jucla rey cananpä payta churayänanpä cashganta. Yarpäyashganno mana cananpä cashganta tantyasinanpämi Jesús quiquin tincusicorgan rïcu runaman: ");
INSERT INTO qvhNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Juc rïcu runashi aywargan juclä nacionman mandag cayta chasquimunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manarä aywarshi gayasergan chunca (10) ashmaynincunata. Nircur jucnintapis jucnintapis ayporgan asca guellayta: ‘Cutimushgäyag cay guellaywan aruycäyanqui’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sayno nir aywacuptin marca mayincuna payta chiquiyashpan guepanta comisionta cachayargan: ‘Manami say runata mandagnë rey cananpä munayäsu’ niyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Sayno marca mayincuna mana munaycaptinpis mandag cayta chasquergan. Saypita marcanman cutiycurnashi gayasergan guellaynin sararag ashmaynincunata guellaynin aycata wachashgantapis musyananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sayshi puntata shamog cag nergan: ‘Guellayniqui mirash gomashgayquipita chunca (10) cuti mastami, taytay.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Saymi mandagnin nergan: ‘¡Ali ashmaymi gam canqui! Walcalapitapis shumag guellayta mirasishgayquipitami chunca (10) marcapa mandagnin canayquipä churashayqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jucagpis shamur nergan: ‘Guellayniqui mirash gomashgayquipita pisga cuti mastami, taytay.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Paytapis nergan: ‘Pisga marcapa mandagnin canayquipämi gamta churashayqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Saynöpis jucag ashmaynin shamur nergan: ‘Caycho caycan guellayniqui, taytay. Pañuëluwan guepircurmi churaycorgä. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gamga shuntanqui mana churashgayquipita y cosechanqui mana murushgayquipitami. Sayno fiyu cashgayquita musyarmi churaycorgä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Sayshi patronnin nergan: ‘¡Gamga mana yäracuypä ashmaymi canqui! Quiquiquipa shimilayquipitami juzgashayqui. Fiyu cashgäta musyaycar, mana churaycar shuntashgäta musyaycar y mana muruycar cosechashgätapis musyaycarga ¿imanirtä banculamanpis churargayquisu mirashtana cutimur shuntacunäpä?’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sayshi nergan saycho caycag runacunata: ‘¡Guechuyay sararaycashgan guellaynëta! ¡Nircur goycuyay chunca (10) cuti más guellay miraseg cagta!’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sayno niptinshi niyargan: ‘Payga maynami sararaycan chunca (10) cuti masta, taytay.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Niptinshi patronnin nergan: ‘Guellayta puestupashgäta mirasegcunaga mastami chasquiyanga. Mana mirasegcunami isanga sararashgalantapis guechushga cayanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mandagnin canäta mana munar chiquimagnëcunataga ¡cayman apaycamur wanusiyay noga ricaycaptë!’ ” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sayno wilaparcurmi Jerusalenpa Jesús aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olivos lömacho cag Betania y Betfagé nishgan marcacunaman chaycarna ishcay discïpuluncunata puntata cachargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Aywayay Betfagé marcaman. Charnami tariyanquipä pipis manarä muntacushgan ashnu wataraycagta. Sayta pascarir apayämunqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Saycho pipis: ‘Ashnöta ¿imanirtä pascaycäyanqui?’ niyäshuptiquega: ‘Jesusmi munaycan muntacunanpä’ niyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sayno cachaptinmi discïpuluncuna aywar tariyargan Jesús nishgannöla. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Saypita ashnuta pascaycäyaptinmi ämun taporgan: “¿Imanirtä ashnöta pascaycäyanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sayno niptinmi niyargan: “Jesusmi munaycan muntacunanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Saymi ashnuta janchacurcur Jesús caycashgan cagman cutiyargan. Saychönami punchuncunata carunarcur saripäyargan Jesús muntacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Muntash aywaptinnami runacuna cushicuyashpan jacuncunata punchuncunata aywaycashgan näniman mashtayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos lömapa uraycäyaptinnami gatiragnincuna cushicur Diosta alabayargan lapan milagrucunata ricayashganpita: ");
INSERT INTO qvhNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“¡Tayta Diosninsi cachamushgan mandamagninsi rey caychönami caycan! ¡Tayta Diosninsi imayyagpis alabash cayculäsun!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Saymi saycho caycag fariseucuna runacunapa chaupinpita niyargan: “Olgutupay gatiräshogniquicuna upälacuyänanpä, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sayno niyaptinmi Jesús nergan: “Paycuna upälacuyaptenga rumicunapis Tayta Diosninsita alabayangami.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Saypitami Jerusalén marcata ricärir saycho tag runacunapä Jesús wagargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ali cawayta apamushgäta canan junaglapis tantyarga alimi cawayanquiman. Sayno caycaptinpis manami tantyayanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Saymi gamcunapä chämonga nacayänayquipä cag junagcuna. Chiquishogniquicuna jiruruypa sapäyäshuptiquega manami maypapis gueshpiyanquipänasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Saypita marcaman yaycur atacashushpayqui wamrantintami wanusiyäshunquipä. Wayiquicunatapis chipyagmi juchusir ushayangapä. Manami ni juc rumilapis pergaraycar quëdangapäsu. Saynömi canga Tayta Diosninsi salvayäshunayquipä shamushganta mana cäsucuyashgayquipita.” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalenman Jesús chaycurnami templo patiuman yaycuycur saycho ranticuycagcunata gargorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gargurmi paycunata nergan: “Tayta Diosninsipa palabranchöga caynömi guelgaraycan: ‘Templöga canga nogata manacayämänanpämi.’ Sayno guelgaraycaptenga ¿imanirtä gamcuna ticrasiyashcanqui suwacunapa machayninmanno?” ");
INSERT INTO qvhNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nircurnami templo patiucho waran waran Jesús yachasergan. Saymi mandag cüracuna, Moisés guelgashganta yachasegcuna y autoridäcunapis wilanacuyargan Jesusta imanöpapis wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lapan runacuna Jesús yachasishganta shumag wiyaptinmi ima ruraytapis camäpacuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Saypitami Diospa ali wilacuyninta templo patiucho Jesús yachaycäsiptin chäyargan mandag cüracuna, Moisés guelgashganta yachasegcuna y Israel mayor runacunapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Paycunami tapuyargan: “Gamga ¿ima munayniquiwantä templo patiucho ranticogcunata gargushcanqui? ¿Pitä nishushcanqui sayno gargunayquipä?” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sayno tapuyaptin Jesús nergan: “Gamcunatapis canan tapushayqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitä Juanta cachamush bautizananpä? ¿Tayta Diosninsicu o runacunacu?” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sayno niptinmi quiquinpura wilanacuyargan: “Ama nishunsu Tayta Diosninsi cachamushganta. ‘Tayta Diosninsimi cachamush’ nishgaga: ‘¿Imanirtä criyiyargayquisu?’ nimäshunmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Saynöpis ama nishunsu runacuna cachayämushganta. Sayno nishgaga runacuna samgarpis ushaycamashwanmi. Lapanmi yarpäyan Diospa wilacognin Juan cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sayno wilanacurcurmi paycuna niyargan: “Manami musyayäsu pï cachamushgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sayno niyaptinmi Jesús nergan: “Gamcunapis mana wilaycäyämaptiquega nogapis manami wiläsu pipa munayninwan templo patiupita ranticogcunata gargushgätapis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Saypita Jesús tincusiypa yachasergan: “Juc runashi juc chacra üvata plantargan. Nircur say chacranta arrendacuycur juclä marcapa aywacorgan saycho tänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cosëcha galaycuptinnashi cachargan juc ashmayninta üva chacra arrindunpita cobracamunanpä. Say ashmay chaptinshi fiyupa magarcur jinaylata gargusquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sayno jinayla cutiycuptinshi say runaga yapay cachargan juc ashmayninta. Saytapis ashlircur y magarcurshi jinaylata gargusquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Saypita yapay cachargan juc ashmayninta. Saytapis saynöla magar ushasquir yawarlatana jinaylata gargusquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Sauraga chacrayog yarpachacorgan: ‘Canan ¿imatatä rurashä? Cachashä juclayla cuyay surëta. Paytaga pagta chasquicuycunmanpis.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sayshi say surin aywaycagta ricasquir wilanacuyargan: ‘Tagaymi cay chacrawan quëdangapä. Nogansipäna cay chacra cananpä payta wanuriycasishun.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sayshi wilanacuyashgannöla chaycuptin üva chacrapita jucläman jorgurir wanusiyargan. “Sayno rurayashganpita say üva chacrayöga ¿imatarä ruranga say chacrata guechuyta munag runacunata? ");
INSERT INTO qvhNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿Manasurä say fiyu runacunata lapanta wanusir ushanga? Nircorga chacrantapis juctanami arrendacuycongapä.” Sayno niptinmi runacuna niyargan: “¡Tayta Diosninsi cuyapaycalämäshun sayno nogansitapis mana castigamänansipä!” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Saymi paycunata ricärir Jesús nergan: “Sayno päsayäshunayquita mana munayashpayquega Tayta Diosninsipa palabrancho cayno guelgaraycashganta tantyacuyay: ‘Wayi sharcasegcuna: “Manami alisu cay rumi” nir jitariycuyaptinpis wayi esquïnaman cimientupä say rumi churashganami caycan.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipis say rumi jananman tuneg cäga ushacangami. Saynölami pipa jananmanpis say rumi unyarga pasaypa ushacäsenga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sayno niptinmi mandag cüracuna y Moisés guelgashganta yachasegcuna tantyayargan tumasipaylapa paycunata Jesús sayno nicashganta. Saymi jinan höra prësu sarisiyta munayargan. Sayno munarpis manami Jesusta prësu sarisiyargansu, runacunata mansapäyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Saymi autoridäman prësu apasinan cash Jesús cagman runacunata cachayargan ali shimilanpa parlapar lutanta parlasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chaycurmi say runacuna Jesusta niyargan: “Nogacuna musyayämi imata yachasirpis Tayta Dios munashganno shumag yachaycäsishgayquita, taytay. Saymi yachagtapis mana yachagtapis Diospa wilacuynin nishgannöla yachasinqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Romacho emperador Cesarpä impuestuta pägashwancu o manacu?” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lutanta parlasinanpä tapuyashganta tantyarmi Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mä ricasimay guellayta.” Guellayta ricasiptinmi nergan: “Cay guellaycho ¿pï runapa reträtuntä caycan? Saynöpis ¿pipa jutintä guelgaraycan?” Sayno tapuptin niyargan: “Emperador Cesarpami.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Saymi Jesús nergan: “Emperador Cesarpa cagta Cesarta goycuyay. Tayta Diospa cagtaga Tayta Diosninsita goycuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesús sayno niptin imatapis lutanta parlasiyta mana camäpacuyashpan say runacuna upälacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saypitami saduceo runacunapis Jesusman aywayargan pay yachasishganta manacagman churananpä. Saymi Jesusta niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Moisés guelgashgancho caynömi nican, taytay: ‘Warmiyog runa suriynag wanuptin shulca wauguin cuñädan viüdawan täsun. Saynöpami wamrancuna say wanog cag runapa surinnöna cayanga.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sayno captenga tapucushayqui, taytay. Juc marcachöshi ganchis wauguicuna cayargan. Mayor cagshi juc warmiwan targan. Payshi manarä surin captin wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sauraga shulca cag wauguinnashi targan say viüdawan. Paypis surin manarä captinshi wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Saypita más shulcan cagna targan say viüdawan. Paypis wanorgan surin manarä captinshi. Saynöla lapan wauguincuna say viüdawan täyargan. Suriynagla lapanpis wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Saypitanashi say viüdapis wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wanushcunata Tayta Diosninsi cawarisimunan junäga say warmilachi ganchis wauguipa warmin canga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sayno niyaptinmi Jesús nergan: “Say warmi manami mayganpapis warminnasu canga. Cay pasalachömi runacuna warmiyog y warmicuna runayog cayan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wanushganpita cawarircamur gloriaman chaycurmi isanga majaynaglana cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Angilcuna mana wanog cayashgannömi paycunapis mana wanog cayangapä. Tayta Diosninsipa wamran carmi gloriacho cawananpä cawariyämonga. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Wanushcuna cawariyämunanpä cashgantaga Moisespis guelgashgancho tantyasimansimi. Abraham, Isaac y Jacob wanushganpita asca wata guepatarämi Tayta Diosninsi rupaycag shiracapita Moisesta nergan: ‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wanogcuna mana cawariyämunanpä captenga ¿imanöpatä Abrahampa, Isaacpa y Jacobpa Diosnin canman? Sayno caycaptenga ¿imanirtä gamcuna criyiyanquisu wanogcuna cawariyämunanpä cayashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sauraga Moisés guelgashganta yachaseg runacuna waquin niyargan: “¡Alitami niycushcanqui, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Saypitaga manami pipis tapupayta almitiyargannasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Saypitanami runacunata Jesús nergan: “¿Imanirtä runacuna niyan Cristo Davidnöla mandag rey cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Quiquin Davidpis Salmo librucho caynömi guelgargan: ‘Munaynincho sararämag mandag reyta Tayta Diosninsi caynömi nergan: Jamacamuy derëcha cag naupäman lapan contrayquicunata vincishgäyag.’ ");
INSERT INTO qvhNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sayno nicaptenga ¿imanöpatä Cristoga Davidnöla mandag rey canman quiquin Davidpis mandagnin rey cashganta nicaptenga?” ");
INSERT INTO qvhNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lapan runacuna wiyaycäyaptinmi discïpuluncunata Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cuidä Moisés guelgashganta yachaseg runacunano cayanquiman. Tayta Dios munashganno cawaycashganta runacuna yarpäyänalanpämi paycunaga puriyan chaqui puntanyag sotänan jatish. Saynöpis más munayan yachasicog cayashganpita pläzacunacho y cällicunachöpis alabash caylatami. Saynöpis sinagogacunacho alinnin cag bancumanrä jamacuytami munayan. Micunanpä gayasiyaptinpis mësa cagmanrämi jamacuyta munayan. ");
INSERT INTO qvhNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Saynömi viüdacunapa ima pobrëzalantapis apacuyan. Nircurnami alita rurashganta runacuna yarpäyänanpä may rätu Tayta Diosta manacuyan. Sayno rurayashganpitami infiernucho más fiyupa nacayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Saypitami templucho Jesús ricaraycargan ofrenda winacuyänanman rïcucuna winaycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Saychömi ricargan muchog viüdatapis ishcayla cobri guellayninta winaycagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Sayta ricar discïpuluncunata Jesús nergan: “Rïcu runacunaga winayash pusog guellaylantami. Viüdami isanga pobri caycarpis winash lapan guellayninta, saylana rantipacunanpä caycaptinpis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nircurmi templo pergarashgan rumicuna cuyaylapä cashganpita y shumag adornash cashganpitapis discïpulucuna parlaycäyargan. Saymi Jesús nergan: ");
INSERT INTO qvhNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Cay lapan ricaycäyashgayqui cuyaylapä caycaptinpis chipyagmi juchusiyangapä. Manami ni juc rumilapis canan pergaraycashgannöga quëdangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sauraga discïpuluncuna tapuyargan: “Nishgayquinöga ¿imaytä templo juchusish canga, taytay? Sayno cananpäga ¿puntata imatä canga?” ");
INSERT INTO qvhNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sayno tapuyaptinmi Jesús nergan: “Pipis lutanta mana criyisiyäshunayquipä shumag tantyacuyay. Ascagmi shayämonga: ‘Cristumi noga cä’ niyashpan. Saynöpis niyäshunquipä: ‘Tiempo chämushganami cay pasa ushacänanpä.’ Sayno niyäshuptiquipis gamcuna ama cäsupäyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","May-say nacioncunachöpis guërra captin y wanusinacuy captin ama mansacäyanquisu. Puntataga saycunalarämi canga. Sayno captinpis templuta manami juchusengaräsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Juc nacionmi pelyanga juc nacionwan. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Saynömi may-saychöpis canga terremöto, segaypa muchuy y tucuy-nirag gueshyacunapis. Saynöpis ciëlucho ricacämonga mansariypä imaycacunapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Saycuna manarä captinmi chiquishushpayqui prësu sariyäshunquipä. Israel runa mayiquicunapis contrayqui sharcur juzgayäshunquipä. Saynöpis carcilcunaman wichgayäshunquipä. Nogata chasquicayämashgayquipitami apayäshunquipä nación mandag reycunamanpis juzgash cayänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Saynöpami wilacuynëta paycunatapis wilapäyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ama yarpachacuyaysu autoridäcunaman apayäshuptiqui: ‘¿Imatarä cananga parlashä?’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nogami shumag tantyasishayqui imata niyänayquipäpis. Saymi maygan chiquishogniquipis imaniytapis camäpacuyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gamcunapa contrayquicunami sharcuyanga taytayqui, mamayqui, wauguiquicuna, castayquicuna y reguinacuyashgayquicunapis. Saynöpis waquinniquitaga wanusiyäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Saynölami nogata chasquicayämashgayquipita pï-maypis chiquishunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sayno captinpis ama laquicuyanquisu. Ima päsayäshuptiquipis Tayta Diosninsi yanapäyäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wanushgayquiyag Tayta Diosninsi munashganno cawarga paypa naupanmanmi chäyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalén ushacänanpäna caycashganta musyayanquipä soldäducuna tumaparaycagta ricarmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sauraga Judea provinciacho caycagcuna aywacuyäsun jircacunaman. Marcacho caycagcunapis marcapita gueshpir aywacuyäsun. Chacracunacho caycagcunapis marcaman ama aywayäsunsu. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Say junagcunami fiyupa nacaycuna cangapä. Saynöpami Tayta Diosninsipa palabrancho guelgaraycashgancuna lapanpis cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sayno gueshpirmi pasaypa cuyapaypä nacayanga gueshyag warmicuna y iti wawayog warmicunapis. Tayta Diosninsi castigaptin runacuna fiyupami laquicuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquintami wanusiyanga y waquin cagtanami apayanga caru nacioncunaman. Mana Israel cag runacunami Jerusalenta munaynincho saräyanga tiempun cumplishganyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Inti, quila y goyllarcunapis mansariypämi ricacuyanga. Cay pasachönami lapan runacuna mansariywan turbatäyanga lamar yacu bunyaypa bunyar segaypa gayaraptin. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Goyllarcuna wacman cayman cuyogta ricarmi runacunata desmäyupis sarenga. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Saychömi nogata ricayämanga pucutay janancho chipipiycar shamuycagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Say nishgänöla lapanpis ruracar galaycuptenga cushicuyanqui. Musyanquinami nacaycunapita jorgunäpäna caycashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nircur caynöpis tantyasergan: “Tamya tiempo galaycuptin musyayanquimi jïgus jacha y waquin jachacunapis chinquimunanpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Saynölami say nishgä nacaycuna chämuptin gamcunapis musyayanquipä cutimunäpäna caycashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Canan cawaycag runacuna manarä wanuyaptinmi lapan say nishgäcuna cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ciëlupis y cay pasa ushacaptinpis noga nishgäcunaga lapanmi cumplengapä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mana musyayashgayqui höra elagpita noga cutimur cuidä gamcunata tarëman jusalicuycäyagta, shincash caycäyagta y imaycayogpis cayänayquipä yarpachacur gongämash caycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jusalicogcunaga manami pipis gueshpengasu juicio finalpita. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sayno cananpä caycaptenga Tayta Diosninsita imaypis manacur listula caycäyänayqui. Saynöpami shamunanpä cag nacaycunapita gueshpir nogapa naupächo cushishla cawayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Templucho Jesús junagpa yacharcasir sacaypana Olivos lömaman aywag saycho posädacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Saymi tutala cutiptin templuman runacuna aywayag yachasishganta wiyananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Pascua chaycämuptinmi saysica runacuna Jerusalencho shuntacäyargan. Jesuswan asca runacuna tutapita-pasa captinmi mandag cüracunawan Moisés guelgashganta yachasegcuna Jesusta prësu sariyta mansacuyargan. Saymi wilanacuyargan walcala runa cashgan höra Jesusta prësu sariycur wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sayno yarpaycäyaptinmi Satanás yaycorgan Judas Iscariotipa shongunman. Judaspis Jesuspa apostolninmi cargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paymi mandag cüracunaman y templo täpag wardiacunapa mandagnincunaman aywaycur nergan: “Jesusta prësu sariyta munaptiquega cutimur wilashayqui runacuna mana cashgancho Jesús imay caycashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sayno niptinmi cushicuyashpan wilanacuyargan Judasta pägayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sayno wilanacurcurmi Judas yarpachacorgan imay höra wilacog cutinanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Levadüraynag Tantata Micunan fiesta y Pascua fiestapis galaycunan junagmi Israel runacuna templucho carnishta pishtayag. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Saymi Jesús cachargan Pedrutawan Juanta: “Pascua merendata micunansipä puestucayämuy” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Saymi paycuna tapuyargan: “¿Maychötä puestucayämushä, taytay?” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sayno niyaptinmi Jesús nergan: “Marcaman chaycurmi tincuyanquipä juc runa uyluwan yacuta apaycagwan. Say runapa guepalanpa aywayanqui may wayimanpis chashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Saychömi wayiyogta niyanqui: ‘¿Mayninchöshi cuarto caycan discïpuluncunawan Pascua merendata Jesús micunanpä?’ ");
INSERT INTO qvhNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sayno niyaptiquimi pay ricasiyäshunquipä altuscho pisapacush jatun cuartuta. Say cuartucho merendata puestucuyanqui micunansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Saymi paycuna aywar tariyargan Jesús nishgannöla. Saychömi puestucuyargan Pascua merendata. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Merenday höranami apostolnincunawan Jesús jamacorgan micuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Saychömi Jesús nergan: “Pascua merendata gamcunawan micur cushishmi caycä. Manarä wanushgäyagmi gamcunawan cay merendata micuyta munargä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mananami cay merendata micushänasu Tayta Diosninsipa naupancho micushgansiyag.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sayno nirmi vïnuyog väsuta aptarcur Tayta Diosta manacur agradëcicorgan. Nircur apostolnincunata macyashpanmi nergan: “Caypita lapayqui upuyay. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yapayga manami vïnuta upushänasu Tayta Diospa naupancho upushgansiyag.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Saynöpis tantata aptarcur Tayta Diosta manacur agradëcicorgan. Nircurnami paycunata paquipargan: “Cay tantaga cuerpömi caycan. Cay tantata micur imaypis yarpäyanqui gamcuna-raycu wanushgäta” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Saynölami merendasquir vïnuyog väsuta aptarcur nergan: “Cay vïnuta upur tantyacuyay yawarnëta jichar gamcuna-raycu wanushgäta. Sayno wanuptëmi Tayta Diosninsi mushog conträtuta ruranga chasquicamagcunata perdonananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chiquimagnëcunaman entregamänanpä cag runapis nogansiwanmi cay mësacho caycan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tayta Diospa palabrancho guelgaraycashgannöla fiyupa nacar wanunäpämi caycä. Nogata entregamag runami isanga juicio finalcho fiyupa laquicongapä. Payga ama yurinmanpissu cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sayno niptinmi jucninpis jucninpis apostolnincuna tapunacuyargan: “¿Maygansirä say entregag caycansi?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Saypitami mandag cayta guechunacur apostolcuna rimanacuycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sayno rimanacuyaptinmi Jesús nergan: “Nación mandag reycuna mandag cayninman atiënicuycurmi runacunata mandayan. Sayno mandaptinpis: ‘Ali runami payga’ niyan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gamcunaga manami sayno cayanquimansu. Saypa trucanga waquin runacunapita más ali ricash cayta munarga runa mayiquita ashmaynöla yanapäyay. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Musyayanquimi mësacho patrón micuptin ashmaynincuna sirviyashganta. Nogaga ashmaynölami gamcunapä caycä. Saymi gamcunapis ashmaynöla cayanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ima nacaycho captëpis gamcuna nogawanmi imaypis cayashcanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Saymi gamcunata churashayqui mandag cayänayquipä, Taytä nogata mandag canäpä churamashganno. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Saymi mandashgä cagcho gamcuna nogawan micuyanquipä y upuyanquipä. Saynöpis lapan runacunata juzgaptëmi gamcunapis cada ünuyqui juc trönucho jamacuyanquipä chunca ishcay (12) castapita mirag Israel mayinsicunata juzganayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saypitami Jesús nergan: “Simón, Satanasmi Tayta Diosninsita manacush gamcuna lapayqui cachariyämänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sayno captinpis gampä Tayta Diosta manacushcä Satanás munashganta rurasishuptiquipis Tayta Diosninsiman yapay shumag yäracunayquipä. Yapay yäracurnami apóstol mayiquicunata shacyäsinqui paycunapis nogaman shumag yäracayämänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sayno niptinmi Pedro nergan: “Carcilman apashuptiquipis gamwanmi aywashä, taytay. Gamta wanusishushpayquega nogatapis wanusimäsun.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Saymi Jesús nergan: “Pedro, canan sacay cacash manarä cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Saypita apostolnincunata Jesús taporgan: “Guellayniynagta, jacuynagta y languiynagta wilacuyänayquipä cachaptë ¿imalapis pishëyäshorgayquicu?” Saymi paycuna niyargan: “Manami imapis pishëyämargansu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Sayno niyaptinmi Jesús nergan: “Tayta Diosninsipa palabrancho cayno nirmi guelgaraycan: ‘Jusasapa runatanöpis runacuna payta ricash.’ Say guelgaraycashganga nogapämi nican. Cananpitaga wilacog aywar jacuyquitapis guellayniquitapis apayanqui. Espädayqui mana captenga punchuyquita ranticuycur espädata rantiyay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Saymi discïpuluncuna niyargan: “Caycho caycan ishcay espädacuna, taytay.” Niptin Jesús nergan: “¡Imata nicashgätapis manami tantyamanquisu!” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Saypitami Jesús aywargan cadala aywashganno Olivos lömaman discïpuluncunawan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sayman chaycurnami discïpuluncunata nergan: “Punushgayquipita ricchayayna. Diosta manacuyay Satanasta mana cäsupäyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sayno nircur más washaläman aywargan Tayta Diosta manacunanpä. Saychönami gongurpacuycur Tayta Diosta manacorgan: ");
INSERT INTO qvhNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Papá, nacanäpä caycashgäpita salvaycalämay. Isanga noga munashgänöga ama casunsu, sinöga gam munashgayquino cayculäsun.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sayno laquicur manacuycaptinmi juc ángil yuriparcur shacyäsergan nacananpä captinpis mana mansacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sayno fiyupa laquicur Jesús lapan shongunwan Tayta Diosta manacuycaptinmi südayninpis yawarnörä pampaman jutorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tayta Diosta sayno manacushganpita discïpuluncuna cagman cutiycur Jesús tarergan laquicuypita punucash caycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Saymi Jesús nergan: “¿Imanirtä punucuyanqui? Sharcur Tayta Diosta manacuyay Satanasta mana cäsupäyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sayno parlaycaptinrämi Judas Iscariote chargan asca runacunata pushash. Judasga Jesuspa discïpulunmi cargan. Nircurnami Jesusman witiycur payta musargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Saymi Jesús nergan: “Judas, chiquimagnëcunaman entregamänayquipä ¿imanirtä nogata musamanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Saymi Jesusta prësu apacunanpä cashganta tantyayashpan discïpuluncuna tapuyargan: “Taytay, ¿espädäcunawancu goriyäshä paycunata?” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sayno nir juc discïpulun más mandag cürapa ashmayninpa derëcha cag rinrinta espädanwan waluriycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Saymi Jesús nergan: “¡Saytaga ama ruraysu!” Nircur say ashmaypa rinrinta yataycur aliyascasergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesusta prësu apananpä shamogcuna cayargan mandag cüracuna, templo täpag wardiacunapa mandagnincuna y Israel mayor runacunapis. Paycunatami Jesús nergan: “¿Imanirtä suwa captënöpis gamcuna shayämushcanqui espädayquicunawan y garrotiquiwanpis prësu sariyämänayquipä? ");
INSERT INTO qvhNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nogaga waran waranmi gamcunawan templo patiucho caycargä. ¿Imanirtä saychöga prësu sariyämargayquisu? ¿Imanirtä Satanaspa munayninta rurar prësu sariyämänayquipä cananrä shayämushcanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta prësu sarircur apayargan más mandag cürapa wayinman. Payta prësu apacuyaptinmi Pedro caru guepalanta aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Saymi sawan rurincho ninata sarircasir runacuna mashacuycäyargan. Sayman yaycurirmi Pedrupis paycunawan mashacuycargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Saymi juc ashmay warmi, Pedro mashacuycagta ricaycur nergan: “Cay runapis Jesuswanmi purergan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sayta wiyaycurmi Pedro nergan: “Nogaga payta manami reguësu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Maylantanami juc runapis payta ricaycur nergan: “Gampis paywan puregmi caycanqui.” Niptinmi Pedro nergan: “Nogaga manami paywan imaypis purishcäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Saypita juc höratano jucna nergan: “Rasunpaypami cay runaga paywan caycargan. Galilea runami canpis.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sayno niptinmi Pedro nergan: “¡Manami musyäsu imata parlaycashgayquitapis!” Pedro sayno nicaptinmi cacash cantarcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sauraga Jesús ticraycur ricäriptinmi Pedro yarparcorgan Jesús cayno nishganta: “Manarä cacash cantaptinmi quimsa cuti reguimashgayquita ñëgamanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Saymi Pedro wagtaman yargusquir fiyupa laquicushpan maquinta chogpacurcur wagargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Saypitanami prësu sararag runacuna asipäyashpan Jesusta magayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nawinta vendarcur lagyayargan: “¡Mä niyämay! ¡Pitä lagyashushcanqui!” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sayno nir tucuyta ashliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pasa wararcuptinnami Israel mayor runacuna, mandag cüracuna y Moisés guelgashganta yachasegcunapis shuntacäyargan. Sayman apaycurmi Jesusta tapuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","“Mä wilayämay. ¿Rasunpacu gam Tayta Diosninsi cachamushgan Cristo caycanqui?” nir. Saymi Jesús nergan: “ ‘Cristumi caycä’ niptëpis ni imanöpa tantyasiptëpis gamcunaga manami criyiyämanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cananpitaga noga caycäshä munayyog Tayta Diosninsipa derëcha cag naupanchömi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Saypita lapan autoridäcuna tapuyargan: “Sauraga ¿Diospa surincu canqui?” nir. Sayno niptinmi Jesús nergan: “Gamcuna niyashgayquinölami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Saymi paycuna niyargan: “Quiquinpis Diospa surin caycashganta nicämashgaga ¿imapänatä más testïgutapis ashishun? Sayno Dios-tucuycarga ¡wanusish casun!” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Saypitana Jesusta apayargan Pilato cagman. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Saychönami Pilätuta niyargan: “¡Cay runataga tariyashcä lutancunata yachaycäsegtami! Manami munansu impuestuta runacuna pägayänanta. Saynöpis nican Tayta Dios cachamushgan Cristo car nogacunapa mandagnëcuna cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Saymi Jesusta Pilato taporgan: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” nir. Saymi Jesús nergan: “Gam nishgayquinölami rasunpaypa caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Saymi Pilato nergan mandag cüracunata y saycho shuntacash caycag runacunatapis: “Manami ima jusantapis tarësu cay runapataga.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sayno niptin paycunaga masrä niyargan: “¡Mandamagninsi emperadorpa contran runacuna sharcuyänanpä shimita gormi jusayog caycan! Galilea provinciachöpis cay Judea provinciachöpis saynölami runacunata shimita goycan.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sayta wiyar Pilato taporgan: “¿Galileapitacu cay runa?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Au, payga Galileapitami” niyargan. Saymi Galilea provinciapa gobernadornin Herodes captin Jesusta payman apasergan juzgananpä. Say junagcuna Jerusalenchömi Herodispis caycargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesuspä parlashganta wiyashpanmi naupapita-pasa Herodes ricayta munargan milagruta ruraycagta. Saymi Jesusta ricaycur cushicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Saycho yaparir yaparir Herodes tapuptinpis Jesús manami imatapis parlacorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Saychömi mandag cüracunawan Moisés guelgashganta yachasegcunapis Jesuspa contran imaycatapis niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Saymi soldäduncunawan Herodes asipäyänan cash Jesusta aylupargan Herodispa cäpanta. Nircurnami cutisiyargan Pilato cagman. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Say junagpitanami Herodiswan Pilato amistayargan naupata chiquinacuyashganpita. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesusta cutiycasiptinnami Pilato gayasergan mandag cüracunata, autoridäcunata y waquin runacunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Saycho shuntacasquiyaptinnami nergan: “Gamcuna cay runata apayämushcanqui: ‘Mandamagninsi emperadorpa contranmi sharcuycan’ niyashpayqui. Sayno niyaptiquipis naupayquicho tapur manami ima jusantapis tarishcäsu contran niyashgayquinöga. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Saynömi Herodispis tarishgasu ima jusantapis. Sayno captenga cay runa manami imatapis jusalicushgasu wanusish cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Saymi payta astarcasilar cacharishä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cada watami Pascuacho Pilato cachareg juc prësuta runacuna manacuyashgan cagta. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Saymi Jesusta cachariycuyta munaptin lapan gaparäyargan: “¡Wanusiy paytaga! ¡Barrabasta isanga cachariycuy!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabás carcilcho wichgaraycargan mandag emperadorpa contran Jerusalencho sharcushganpita y wanusicog cashganpitami.) ");
INSERT INTO qvhNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Saymi Pilato yapay runacunata nergan Jesusta cacharinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Niptinpis masrämi gayaräyargan: “¡Crucificash casun! ¡Crucificash casun!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Saymi Pilato yapay nergan: “Crucificash cananpäga ¿imatatä jusalicush? Manami tarësu ima jusantapis wanusish cananpäga. Astarcasilarmi cacharishä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","25","Sayno niptinpis runacuna masrä gayaräyargan crucificasinanpä. Sauraga runacuna manacuyashgannöla Jesusta Pilato entregaycorgan crucificash cananpä. Saynöpis runacuna manacuyashgannölami Barrabasta cacharergan mandag emperadorpa contran sharcush caycaptinpis y wanusicog caycaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Saypita Jesusta crucificayänanpä apaycäyaptinmi marcaman yaycuycänä Cirene marcacho tag Simón. Sauraga Jesús apaycashgan cruzta paytanami umrusiyargan Jesuspa guepanpa apananpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Saysica runacunami Jesuspa guepanta aywaycäyargan. Saychömi ascag warmicunapis laquicuyashpan wagaraycar aywaycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Saymi wagaycag warmicunata Jesús nergan: “Jerusalén warmicuna, ama nogapäga wagayaysu. Saypa trucanga wawayquicuna y quiquiquicunapis nacayänayquipä cashganpita wagayay. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Fiyupa nacaycunami chämongapä. Saymi laquicuypita runacuna niyanga: ‘¡Ima cushishgarä caycan wawaynag warmicuna!’ ");
INSERT INTO qvhNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Saychömi runacuna segaypa mansariyashpan jircacunatapis: ‘¡Janäcunaman juchumuy jucla wanunäpä!’ niyanga. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nogatapis cayno nacaycäsiyämarga ¡ima fiyuparä gamcunata y waquin Israel runacunatapis nacasiyäshunquipä!” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Crucificananpä Jesusta apar ishcay jusasapa runacunatapis apayargan Jesuspa naupanman crucificayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calavëra nishgan lömaman chaycasirmi Jesusta crucificayargan. Apashgan jusasapa runacunatapis crucificayargan jucnin cagta Jesuspa derëchan cagman y jucagtana isognin cagman. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Say hörami Jesús nergan: “Taytay, cay crucificamag runacunata perdonayculay. Manami musyayansu imata ruraycäyashgantapis.” Soldäducunanami Jesuspa mödananpä suertita jitayargan mayganpis gänag cag apacunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Saycho runacuna ricaraycaptin autoridäcuna Jesusta asipäyargan: “Tayta Dios cachamushgan Cristo carga jucta salvashgannöla mä canan quiquin salvacusun.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Saynölami soldäducunapis asipashpan Jesusta shogusiyargan pochgog vïnuta: ");
INSERT INTO qvhNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Israel runacunapa mandagnin rey cashpayquega mä quiquiqui salvacuy” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cruzpa puntanchömi clävaraycargan cayno guelgash: “Cay runaga Israel runacunapa mandagnin reymi” nishpan. Sayga guelgaraycargan griego, latín y hebreo idiömacunachömi. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Saypitana jucag crucificaraycag runa Jesusta manacagman churar nergan: “Tayta Dios cachamushgan Cristo carga mä canan saypita salvacuy, ari. Nircur nogacunatapis caypita jorgayämay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sayno niptinmi jucnin cag olgutupargan: “Gampis payno nacaycarga ¿manacu Tayta Diosta mansapacunqui? ");
INSERT INTO qvhNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nogansega jusansicunapitami nacaycansi. Paypaga manami ima jusanpis cansu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nircur Jesusta nergan: “Mandag canayquipä cutimur nogata yarparcalämanqui, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Niptinmi Jesús nergan: “Cananpitaga nogawanmi canquipä Taytäpa naupancho.” ");
INSERT INTO qvhNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Pulan junag caycaptinmi pasa sacäcorgan malway intiyag. Say hörami templo rurincho cag cuartuman pipis mana yaycunanpä saparag cortïnapis janapita uraypa rachicäcurergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Saypitami Jesús fuertipa nergan: “¡Taytay! ¡Maquiquimanmi almäta churaycö!” Sayno nisquirnami päsarporgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Saycunata ricaycurmi soldäducunapa capitannin: “¡Rasunpaypami cay runaga jusaynag cash!” nir Tayta Diosninsita alabargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Saycho caycag runacunapis aywacuyargan fiyupa laquishmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuswan reguinacogcunami isanga carulapita ricaraycar quëdacuyargan. Saynölami Galileapita-pasa gatirag warmicunapis saycho quëdacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juc runami cargan Dios munashganno cawag, José jutiyog. Paymi shuyaraycargan Tayta Diosninsi promitishganno lapan runacuna Cristupa maquincho cawayänanpä cashganta. Say runapa marcan cargan Judea provinciacho cag Arimateami. Paypis cargan Israel runacunapa autoridäninmi. Waquin autoridäcuna Jesusta wanusinanpä wilanacuyaptinpis payga manami munargansu wanusiyänanta. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Paymi Pilätuta manacorgan: “Jesuspa ayanta cachapaycalämay pampag apanäpä” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato auniptinmi Jesuspa ayanta cruzpita jorgusquir lïnupita rurash fïnu säbanaswan pitorgan. Nircur pampag apargan manarä pipis pampacushgan gagacho uchcush sepultüraman. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sayno rurargan sábado jamay junag galaycunanpäna caycaptinmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Jesuswan shamog warmicuna Josëta gatipargan Jesuspa sepultüran maycho cashgantapis musyayänanpä. Saycho ricayargan Jesuspa ayanta imano churashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Saypita wayinman cutiycuyashpan puestucuyargan mushcog perfümita Jesuspa ayanman winapäyänanpä. Puestucurcurnami Tayta Diosninsipa palabrancho nishganno jamayargan sábado jamay junag captin. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saypita domingo saca sacala warmicuna cutiyargan Jesús pamparashgan cagman, puestucuyashgan mushcog perfümita apacurcur ayanman winapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chaycuyänanpäga pamparashgan uchcuta saparag rumi jucläman witisishgana caycänä. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sayman yaycur manami tariyargannasu Jesuspa ayanta. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Saymi mansacash ima ruraytapis camäpacuyargansu. Sayno caycäyaptinmi ishcay runacuna chipipiycag mödanash paycunapa naupancho ricacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Paycunata ricaycur segaypa mansacäyashpanmi gongurpacuycuyargan. Say runacunanami niyargan: “¿Imanirtä wanushcuna cayashgan cagcho gamcuna ashiycäyanqui cawarimushgana caycaptenga? ");
INSERT INTO qvhNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Manami caychönasu caycan. ¡Payga cawarimushganami! Yarpäyay Galilea provinciacho caycashpan jusasapa runacunapa maquincunaman entregash cananpä cashganta niyäshushgayquita. ¿Manacu saycho niyäshushcanqui crucificaypa wanusiyaptinpis quimsa junagta cawarimunanpä cashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sayno niptinmi paycuna yarparcuyargan Jesús sayno nishganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Saymi Jesús pamparashgan cagpita cutiycuyashpan lapan ricashgancunata y wiyashgancunatapis wilayargan chunca juc (11) apostolnincunata y saycho cag runacunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Say warmicunaga cayargan María Magdalena, Juana, Santiagupa maman María y paycunawan aywag warmicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Warmicuna sayno wilayaptinpis apostolcuna manami criyiyargansu, löcutaycäyashganta yarpar. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Waquin cag mana criyiyaptinpis Pedrumi isanga cörrila aywargan Jesusta pampashgan cagman. Pamparashgan cagta arcaycurmi säbanaslatana tarergan. Saylatana tariycurmi mansacash cuticorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Say junagmi Jesuspa ishcay discïpuluncuna aywaycäyargan Emaús marcapa. Emaús cargan Jerusalenpita ishcay lëwanölami. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Paycunaga aywaycäyargan Jesús wanushganpita parlaraycarmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sayno parlaraycar aywaycäyaptinmi Jesús taripasquir paycunawan iwal aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Paycunawan aywaycäyaptinpis manami tantyayargansu Jesús cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Saymi Jesús taporgan: “¿Imata parlartä aywaycäyanqui?” nir. Sayno niptin laquish aywaycäyashgancho ichisquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sauraga Cleofas jutiyog runa nergan: “Pascuaman shamog runacunapis lapanmi musyayan cay junagcuna Jerusalencho ima päsashgantapis. ¿Manacu gam musyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niptinmi Jesús taporgan: “¿Imatä cashgaga?” nir. Sayno tapuptin niyargan: “Nazaret marcapita cag Jesusmi cargan Tayta Diosninsipa profëtan. Paymi Tayta Diosninsipa munayninwan milagrucunata rurashpan lapan runacunata wilapargan Diospa wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytami mandag cüracunawan lapan autoridäcuna Pilätuman entregayash crucificaypa wanusinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nogacuna yarpäyargä Roma runacunapa munayninpita pay jorgamänansipä cashganta. Canan junagwanga quimsa junagnami Jesús wanushgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Canan tuta nogacunawan cag waquin warmicuna mansacäsiyämash. Paycunami Jesusta pampashgan cagman saca sacala aywar ayanta tariyashgasu. Saypita wayiman cutiycamur wilayämash Jesusta mana tariyashganta. Angilcuna yuriparcurshi wilash Jesús cawarimushganta. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sauraga waquin cag discïpuluncunapis pamparäyashgan cagman aywar warmicuna wilayashgannölami Jesuspa ayanta tariyashgasu.” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Saymi paycunata Jesús nergan: “Tayta Dios cachamushgan Cristo wanushganpita cawarimur paypa naupanman cutinanpäga nacananrämi cargan. ¿Imanirtä gamcuna tantyayanquisu? ¿Imanirtä ajatarä criyiyanqui Tayta Diosninsipa profëtancuna niyashgancunatapis?” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sayno nishpanmi paycunata tantyasergan quiquinpä imano guelgaraycashgantapis. Sayno yarpäsergan Moisés guelgashgancunapita galaycur waquin profëtacuna guelgayashganyagmi. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Saymi Emaús marcaman chaycuyashpanna paycunapita Jesús päsag-tucorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Päsacuyta munaptinmi payta quëdasergan: “Pasa sacaycannami, taytay. Caylachöna quëdacushun” nir. Sayno niyaptinmi Jesús paycunawan quëdacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Saypita mësa cagman Jesús jamaycurnami tantata aptarcur Tayta Diosta manacur agradëcicorgan. Nircurna paquircur paycunata ayporgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sayno ruraptinmi Jesús cashganta tantyasquiyargan. Tantyasquiyaptinmi elagasquergan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Elagasquiptinnami quiquinpura cayno parlayargan: “¡Jesusmi cash! ¡Rasuntacher shongunsipis cushicorgan nänicho Tayta Diosninsipa palabranta parlapämashga!” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Saymi jinan höra Jerusalenman cutiyargan. Chaycurnami tariyargan chunca juc (11) apostolcunata y waquin discïpuluncunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chaycuyaptinnami paycunata apostolcuna wilapäyargan: “¡Rasunpaypami Señorninsi Jesucristo cawarimush! ¡Simontapis yuripashmi!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niptinnami paycunapis wilapäyargan nänicho ima päsashgancunatapis y tantata Jesús paquishgan höra payta reguiyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sayno parlaycäyaptinmi elagpita Jesús paycunapa naupancho yuripargan. Jesús yuriparcur saludargan: “Tayta Diosninsi yanapaycuyäläshunqui ali cawayänayquipä” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sayno niptin paycuna fiyupa mansacäyargan alma cashganta yarpäyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Saymi Jesús nergan: “¿Imanirtä mansacash caycäyanqui? ¿Imanirtä noga cashgäta criyiyanquisu? ");
INSERT INTO qvhNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Noga cashgäta musyanayquipä maquëta y chaquëta yatayämay. Ricayämashgayquinöpis manami almasu cä. Almaga aysaynag y tuluynagmi.” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sayno nishpan ricasergan maquinta y chaquintapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sayno ricar fiyupa cushicuycarpis manarämi shumag criyiyarganräsu pay cashganta. Sayno mana criyiyaptinmi Jesús taporgan: “¿Imalapis cancu micurcunäpä?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sayno niptinmi garayargan juc pedäzo cancash pescädutawan tinyagpa mishquinta. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Saycunatami micorgan paycuna ricaycäyaptin. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Micusquirnami nergan: “Moisés, waquin profëtacuna y salmucunata guelgagcunapis lapanmi guelgayargan nogata päsamänanpä cagcunata. Gamcunawan caycar maynami wilargä lapan say guelgaraycashgancuna cumpliyänanpä cashganta. Say wilashgänölami päsamash.” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sayno nirmi Tayta Diosninsipa palabranta tantyasergan cayno nir: ");
INSERT INTO qvhNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Tayta Diosninsipa profëtancuna guelgayargan pay cachamushgan Cristo wanunanpä cashganta y wanushganpita quimsa junagta cawarimunanpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Say guelgashgancuna cumpliyashgana captinmi runacunata wilapäyänayqui nogata chasquicamar jusalicuycunata cachariyänanpä. Saynöpami Tayta Diosninsi perdonangapä jusalicuyashgancunata. Jerusalenpita galaycur may-saypapis aywar lapan runacunata sayno wilapäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wilacunayquipäga gamcuna ricayashcanquimi ima päsashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gamcunamanmi noga cachamushä Taytä promitishgan Santu Espirituta. Isanga Jerusalenlacho shuyaraycäyanqui Santu Espirituta chasquiyashgayquiyag. Chasquircuyaptiquinami yanapäshunquipä wilacuynëta wilacunayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Saypitana discïpuluncunata Jesús pushargan Jerusalenpita Betaniaman. Saycho caycarna maquinta jogarcur Tayta Diosninsita manacorgan paycunata yanapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sayno paycunapä manacuycaptinmi Tayta Diosninsi gloriaman pushacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Saycho discïpulucuna Jesusta adorasquirmi cushish cuticuyargan Jerusalenman. ");
INSERT INTO qvhNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Say junagpitanami Tayta Diosninsita alabayänanpä waran waran templuman shuntacäyag. Amén.");
INSERT INTO qvhNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Imapis manarä captinmi Jesucristo mayna caycarganna. Tayta Dioswanmi pay caycargan. Paymi Diosninsi. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paywanmi Tayta Dios camargan lapan imaycatapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Paymi cay pasacho cagtaga lapantapis cawayta gon. Sayno cawayta gon runacuna Tayta Dios munashganno cawayänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sayno captinpis runacuna jusalancho cawarmi sacäpacushno caycäyan. Saymi tantyayansu Tayta Diosninsi munashganno cawayänanpä cagtapis. Sayno captinmi Jesucristo runacunata tantyasin jusalicuyta cacharir Tayta Dios munashgannöna cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Jesucristuta runacuna chasquicuyänanpämi Juan Bautista wilacorgan. Sayno wilacunanpämi Tayta Dios payta acrargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Shumag wilacuptinmi runacuna yarpäyargan Juan Bautista salvacog Jesucristo cashganta. Sayno yarpäyaptinpis manami Jesucristusu payga cargan, sinöga Jesucristuta chasquicuyänanpä wilacoglami. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesucristoga acsinömi caycan. Saymi cay pasaman shamorgan runacunapä acsino cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","Cay pasaman shamuptinpis runacuna manami tantyayargansu Jesucristoga Tayta Diospa naupanpita shamushganta. Saynöpis payta manami chasquicuyargansu, Tayta Dioswan cay pasata camash caycaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sayno captinpis Jesucristuta chasquicogcunami isanga Tayta Diosninsipa wamrancunana caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sayno nicaptenga manami mamanpita yurishganpitasu Tayta Diospa wamrancuna caycäyan, sinöga Jesucristuta chasquicuyashganpitami. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tayta Dioswan caycashganpita cay pasacho runano yurishpanmi Jesucristoga nogacunawan purergan. Paywan purirmi ricayargä cuyacog cashganta. Saynöpis wiyayargä Diospa wilacuyninta yachasishganta. Payga Tayta Diospa japalan cuyay surinmi. Saymi payta ricar quiquin Tayta Diosta ricagnöna cayargä. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypämi Juan Bautista wilacorgan: “Jesucristoga nogapita más munayyogmi caycan. Payga manarä yuriptë maynami caycarganna” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Moisesga Tayta Diospa mandamientuncunalatami tantyasergan. Jesucristumi isanga cuyamashpansi tantyasimansi Tayta Dios salvamänansipä cag mushog wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manami pipis Tayta Diosta ricashgasu. Paytaga ricash japalan cuyay surin Jesucristulami. Saymi pay cagpita shamush car tantyasimashcansi Tayta Dios imano cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jordán mayucho Juan Bautista runacunata bautizaycaptinmi Jerusalenpita autoridäcuna Juan cagman cachayargan cüracunatawan Leví casta runacunata. Paycunata cachayargan Cristo cashganta o juc cashgantapis tapuyämunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Say runacuna tapuyaptinnami Juan nergan: “Nogaga manami Cristusu cä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sayno niptinmi yapay tapuyargan: “Sayno captenga ¿pitä caycanqui? ¿Tayta Diospa unay wilacognin Eliascu?” nir. Saymi Juan Bautista nergan: “Manami Eliassu caycä.” Saymi yapay tapuyargan: “Sauraga ¿Moisés nishganno shamunanpä cag wilacog profëtacu caycanqui?” nir. Niptinmi nergan: “Manami paysu cä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Sayno niptinmi niyargan: “Sauraga ¿pitä canqui? Autoridäcunata wilayänäpä pï cashgayquitapis wilayämay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saymi Juan nergan: “Nogaga Isaías guelgashgannölami Tayta Diospa wilacognin caycä. Saymi sunyag jircaman shamog runacunata wilapaycä jusancunata cacharir Cristo shamuptin chasquicuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanta tapunanpä autoridä cachashgan runacunaga waquin cargan fariseo runacunami. Paycunami Juanta tapuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Cristo, ni Elías, ni Moisés guelgashganno shamunanpä caycag profëtapis mana caycarga ¿imanirtä runacunata bautizaycanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Sayno tapuyaptin Juan nergan: “Nogaga yaculawanmi bautizaycä. Isanga jucrämi shamonga nogapita más munayyog. Nogaga manami payno munayyogsu caycä. Cay pasachöna caycaptinpis runacuna manami tantyacuyansu salvamagninsi Cristo cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sayno Juanta tapuyargan Jordán mayu simpan Betaniachömi. Saychömi runacunata Juan bautizaycargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Saypita waraynin junag Jesús shamuycagta ricarmi Juan Bautista nergan: “¡Ricayay Tayta Dios cachamushgan runa shamuycagta! Pascuacho carnishta wanusiyashgannömi pay wanonga runacuna jusalicuyashganpita perdonash cayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nogapita más munayyog cashganta y manarä yuriptë pay mayna caycashgantami noga wilacö. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Naupataga manami musyargäsu Tayta Dios cachamushgan Cristo pï runa cashgantapis. Pï cashganta manarä musyarpis nogaga runacunata bautizaycashcä shamuptin payta chasquicuyänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jesucristo pï cashgantapis musyanäpämi Tayta Dios nimargan: ‘Bautizarcuptiqui maygan runapa jananman Santu Espíritu palomano rataptinmi musyanquipä say runa Jesucristo cashganta. Paymi munayyog caycan Santu Espirituwan runacunata bautizananpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Say nimashgannölami Jesusta bautizarcuptë paypa jananman Santu Espíritu palomano rataycagta ricargä. Saymi gamcunata wilapä Tayta Diosninsipa surin pay cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Saypita waraynin junag ishcay discïpuluncunawan caycarmi Juan Bautista ricargan Jesús päsaycagta. Payta ricarmi Juan Bautista nergan: “¡Ricayay! ¡Salvamagninsi Cristo päsaycan!” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sayno niptinmi Jesuspa guepanpa say ishcay discïpulucuna aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ticraycamushganchömi Jesús ricargan guepanpa paycuna aywaycagta. Saymi taporgan: “¿Maypatä aywaycäyanqui?” nir. Niptinmi niyargan: “Gam cagmanmi shamuycäyargä, rabí. ¿Maychötä posädaraycanqui?” (Rabí ninanga yachasicog ninanmi.) ");
INSERT INTO qvhNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Saymi Jesús: “Acu, posädacushgä wayita reguisiyäshayqui” nergan. Saymi reguisergan maycho posädarashgantapis. Tardina captinnami Jesuswan quëdacuyargan posädarashgalanchöna. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Say ishcay discïpuluncuna jucag cargan Simón Pedrupa wauguin Andresmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Saymi jinan höra Andrés aywargan wauguin Simón cagman. Chaycurmi wilargan: “¡Tincuyashcä Tayta Dios cachamushgan Cristuwanmi!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nircurnami Jesús cagman pushargan. Chaycuptinnami Simonta ricaycur Jesús nergan: “Jonaspa surin Simón, cananpitaga Pedrunami jutiqui canga.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Saypita waraynin junag Galilea provinciapa Jesús aywananpäna caycarmi tincorgan Felipiwan. Saymi payta nergan: “Discïpulö canayquipä nogawan aywashun.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipega cargan Betsaida marcapitami. Andreswan Pedrupis say marcalapitami cayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Discïpulun cananpä Jesús niptinmi Felipe aywargan Natanaelta wilananpä: “¡Tayta Dios cachamushgan Cristuwanmi tincuyashcä! ¡Payga Josëpa surin Nazaret marcapita Jesusmi! ¿Yarpanquicu Moisés y waquin profëtacuna pay shamur salvamänansipä guelgashganta? ¡Paywanmi tincuyashcä!” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Niptinmi Natanael nergan: “¿Imanöpatä Nazaret marcapita Tayta Dios cachamushgan Cristo canman?” Sayno niptinmi Felipe nergan: “Acu aywashun ricanayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Saymi Natanael shamuycagta ricar runacunata Jesús nergan: “Tagay shamuycag runaga ali runami. Payga rasun caglata imatapis parlan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Say nishganta wiyashpanmi Natanael taporgan: “¿Imanöpatä musyanqui ali runa cashgäta?” Niptinmi Jesús nergan: “Manami ali runa cashgalayquitasu musyä, sinöga maycho cashgayquitapis musyämi. Saymi Felipe manarä gayashuptiquipis nogaga ricargä jïgus jacha chaquincho jamaraycashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sayno niptinmi Natanael nergan: “¡Tayta Diospa surin imacher gam caycanqui, taytay! ¡Saynöpis Israel runacunapa mandagnin rey imacher caycanqui!” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sayno niptinmi Jesús nergan: “¿Jïgus jacha chaquincho jamaraycashgayquita ricashgäta nishgaläpitacu sayno nimanqui? Cananpitaga milagrucunata rurashgätapis ricanquipämi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nircurmi saycho caycag runacunata Jesús nergan: “Angilcuna ciëlupita uraycämogta y wisaycagta sueñuynincho ricarmi Jacob tantyargan Tayta Dios yanapaycashganta. Sayta ricar Jacob tantyashgannömi gamcunapis tantyayanquipä Tayta Dios nogata yanapaycämashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Saypita quimsa junagtanami casaray fiesta cargan Galilea provinciacho cag Caná marcacho. Say fiestachömi caycargan Jesuspa mamanpis. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Say fiestamanmi Jesusta y discïpuluncunatapis gayasiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Manarä fiesta ushacaptinmi vïnuta ushacäpacuyargan. Saymi Jesusta maman nergan: “Vïnuncunami ushacasquishga. ¿Maypitarä canan vïnuta jorgayämonga?” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sayno niptin mamanta Jesús nergan: “Manami hörä chämunräsu munashgayquino milagruta ruranäpä, mamay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sayno niptinpis sirvienticunata maman nergan: “Imata ruranayquipä Jesús nishuptiquega cäsucuyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Saychömi caycargan rumipita rurash yacuynag sogta urpucuna. Say urpucunamanmi yacuta winayag costumbrin cashganno maquinta maylacuyänanpä. Waquin urpucunamanmi yaycog ganchis chunca (70) botëlla yacu y waquinmannami yaycog pisga chunca (50) botëlla yacu. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Saymi sirvienticunata Jesús nergan: “Say urpucunaman yacuta juntagpä winayay.” Saymi yacuta winayargan urpucunaman juntashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Juntarcasiyaptinnami Jesús nergan: “Ichiclata chagarcur apay mayor sirvienti yawananpä.” Jesús nishganno rurayaptinmi say yacu ticrargan vïnuman. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Saymi apapashgan vïnuta yawarcorgan mayor sirvienti. Isanga manami musyargansu maypita apayashgantapis. Yanapag cag sirvienticunalami musyayargan yacupita vïnuman Jesús ticrasishganta. Say vïnuta yawarcurnami casarag magtata gayaycur nergan: ");
INSERT INTO qvhNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“¡Sayrä apamushgan vïnoga waquin vïnupitapis más alimi caycan! ¿Maychötä say vïnutaga tarishcanqui? Waquin runacunaga fiesta galaycunalanchömi alinnin cag vïnuta sirvicuyan. Gammi isanga fiesta ushananchörä más alinnin cag vïnuta sirvicuycanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Saynömi Galileacho cag Caná marcacho Jesús rurargan punta cag milagruta. Munayyog cashganta ricarmi discïpuluncuna tantyayargan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Saypitanami mamanwan, wauguincunawan y discïpuluncunawanpis Jesús aywargan Capernaum marcaman. Saychömi goyäyargan juc ishcay junag. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua galaycunanpäna caycaptinmi Jesús aywargan Jerusalén marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chashpannami templo patiucho tarergan asca runacuna ranticuycäyagta. Saychömi ranticuycäyargan törucunata, uyshacunata y palomacunatapis. Saynöpis tarergan guellay ranticogcunata. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sayno ranticuycäyagta tariycushpanmi sumbadorta rurarcur uyshantinta wäcantinta Jesús gargorgan templo patiupita. Guellay ranticogcunapa mësancunatapis ticrar ushargan guellaynincunatapis mashishpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sayno gargurmi paloma ranticogcunatapis nergan: “¡Caycunata jorguyay! Taytäta adoracuna wayichöga ¿imanirtä mercädo captinnöpis caycho ranticuycäyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesús sayno ruraptinmi discïpuluncuna tantyayargan Tayta Diospa palabrancho guelgaraycashgannöla ruraycashganta. Say guelgarashganga caynömi nican: “Templuchöga Tayta Diosta adorayänalantami munä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sayno garguptinmi Israel runacunapa autoridänincuna payta niyargan: “¿Ima munayniquiwantä ranticogcunata gargushcanqui? Mä milagruta ruray munayyog cashgayquita musyayänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sayno niyaptinmi Jesús nergan: “Milagruta ricayta munarga cay templuta juchusiyay. Juchusiyaptiquega quimsa junaglatami noga sharcasishäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sayno niptinmi autoridäcuna niyargan: “Cay templuta sharcasiyargan chuscu chunca sogta (46) watatarämi. ¿Imanöpatä canan gam quimsa junaglata yapay sharcarasinquiman?” ");
INSERT INTO qvhNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sayno nir Jesús manami templuta yapay sharcasinanpäsu nergan, sinöga quiquin wanushganpita quimsa junagta cawarimunanpä cashgantami nicargan. Saymi autoridäcuna Jesús imapita parlaycashgantapis tantyayargansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Discïpuluncunapis manami juclaga tantyayargansu. Jesús wanushganpita cawarimushganta ricarrämi tantyayargan templuman ituycasilar quiquinpä parlashganta. Saynöpami musyayargan Tayta Diosninsipa palabrancho Jesuspita guelgaraycashgan y Jesús nishgancunapis rasun cag cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascuacho asca runacunami ricayargan milagrucunata Jesús ruraycashganta. Saynöpami tantyayargan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sayno tantyacuptinpis Jesús musyarganmi payman mana yäracuycäyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mana wilaptinpis payga musyarganmi runacuna imata yarpaycäyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juc fariseo runami cargan Nicodemo jutiyog. Payga Israel runacunapa autoridäninmi cargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi sacaylapa Jesús cagman aywargan parlananpä. Chaycurmi nergan: “Milagrucunata rurashgayquita musyarmi tantyayä Tayta Dios yanapaycäshushgayquita, taytay. Saymi musyayä nogacunata yachasiyämänayquipä cachamushushgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Saymi Jesús nergan: “Runacuna Tayta Diospa naupanman chäyänanpäga yapayrämi yurinman. Yapay mana yurerga manami pipis gloriaman changapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Sayno niptinmi Nicodemo taporgan: “¿Imanöpatä runacuna yapay yuriyanman yurishgana caycarga? ¿Cutiyanmansurä mamanpa pachanman yapay yuriyänanpä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Saymi Jesús nergan: “Manami runacuna mamanpa pachanman cutiyänanpäsu nicä, sinöga Santu Espiritupa munayninwan yapay yuriyänanpämi. Pipis yacuwan y Santu Espiritupa munayninwan yapay mana yurerga manami Tayta Diospa naupanman changapäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Manami pipis mamanpita yurishgalanpitasu salvash canga, sinöga Santu Espiritupa munayninwan yurishganpitarämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gloriaman chänanpä lapan runacuna yapayrämi yuriyänan niptë ama mansacaysu. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vientumushganta wiyarpis runacuna manami musyayansu maypita vientu shamushganta ni maypa aywashgantapis. Saynölami runacuna tantyayansu yapay yurishno cananpä Santu Espíritu imata rurashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sayno niptinmi Nicodemo nergan: “Nogaläpis saytaga manami tantyäsu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sayno niptinmi Jesús nergan: “Israel runacunapa yachasegnin caycarpis ¿manacu sayta tantyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Say nishgäcunata mana tantyaptiquipis nogaga gamta wilapaycä musyashgätami. Sayno captinpis gamcuna manami criyiyanquisu nishgäta. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Runacuna yapay yurishno cayänanpä nishgäta mana criyiycarga ¿imanöpatä criyiyanquiman masta niptëpis? ");
INSERT INTO qvhNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Manami pipis gloriaman aywarcur cutimushgasu saycho imano cashgantapis runacunata wilananpä. Nogami isanga gloriapita cay pasaman shamushcä. Saymi rasun cagta runacunata wilapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Pipis nogata chasquicamagcunaga gloriacho cushishmi imayyagpis cawangapä. Sayno cawayänanpäga puntata noga wanushärämi. Sunyag saqui jircacho culebra picashganpita runacuna aliyäyänanpä broncipita fundish culebrata Moisés shawashgannömi nogapis cruzcho wanushä chasquicamag runacuna salvacuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Runacunata cuyashpanmi Tayta Dios cachamorgan cuyay surinta. Saynöpami pipis Tayta Diospa surinta chasquicur payman yäracog cäga infiernuman gaycushganasu cayanga, sinöga gloriamanmi chäyanga imayyagpis saycho cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","18","Tayta Diosninsega surinta cachamorgan payman yäracogcunata salvananpämi. Saymi Tayta Diospa surinman yäracog cäga gloriaman changapä. Mana yäracog cagmi isanga infiernuman gaycush cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Paycunaga sacäpacushno cawar jusalicuyashgancunata cachariyta manami munayansu. Saymi Tayta Diospa surin cay pasaman shamush captinpis payta chasquicuyansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tayta Diospa surinta chasquicog cagmi isanga jusalicuycunata cacharin. Sayno cacharinanpäga Tayta Diosninsimi payta yanapan. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Saypitanami Jesuswan discïpuluncuna aywayargan Judea provinciaman. Saychömi runacunata bautizayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan Bautistanami bautizaycargan Enón nishgan ragracho, saycho asca yacu captin. Enón cargan Salim marca cercanchömi. Saycho bautizaycashganta musyarmi waquin runacunaga sayman aywayargan bautizacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Say wisanga Juan manarämi carcilcho wichgararganräsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Saychömi Israel runacunapa juc ishcay autoridänincuna Juan Bautistapa discïpuluncunata nergan: “Jesús bautizashganmi más ali caycan Juan bautizashganpitaga.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sayno niptinmi discïpuluncuna Juanta niyargan: “Taytay, ¿yarpanquicu Jordán simpancho caycar juc runapä wilapäyämashgayquita? Cananga paymannami lapan runacuna aywaycäyan bautizacuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sayno niyaptinmi Juan nergan: “Nogapita más munayyog captinmi runacuna payman aywaycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamcunata nishgänöpis manami Tayta Dios cachamushgan Cristusu nogaga caycä. Saypa trucanga Cristuta runacuna chasquicuyänanpä wilacunaläpämi Tayta Dios cachamash. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jipashwan juc magta casaraptin amïgun cushicushgannölami nogapis cushicö runacuna Jesucristumanna aywayaptin. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nogaman shayämunanpa trucanga más alimi caycan paymanna runacuna aywayaptin. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Gloriapita shamush carmi Jesucristo musyan saycho imano cashgantapis. Nogaga cay pasalapita carmi mana paynöga musyäsu. Saymi tantyashgaläta wilacö. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jesucristumi isanga wilacuycan gloriacho ricashgancunata y wiyashgancunatapis. Sayno wilacuptinpis mana chasquicogcunaga manami tantyayansu rasun cagta wilacushganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Chasquicogcunami isanga tantyayan rasun cagta wilacuycashganta. Jesucristoga sayno wilacuycan Tayta Diosninsipita shamush carmi. Sayno wilacunanpäga Santu Espiritumi payta yanapaycan. Saymi pay wilacushgannöga pipis wilacunsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Surinta cuyarmi Tayta Diosninsi lapantapis paypa munayninman churash. ");
INSERT INTO qvhNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Saymi Diospa surin Jesucristuta chasquicog cagtaga gloriaman shuntanga saycho imayyagpis cushish cawayänanpä. Payta mana chasquicog cagtami isanga Tayta Diosninsi rabiashpan infiernuman gayconga imayyagpis saycho nacananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo runacunami musyayargan Juan Bautista bautizashganpita más asca runacunata Jesús bautizaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","3","Fariseo runacuna sayno musyayashganta tantyaycurmi Jesuswan discïpuluncuna cutiyargan Judea provinciapita Galilea provinciaman. Isanga manami quiquinsu Jesús bautizargan, sinöga discïpuluncunami runacunata bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilea provinciaman chäyänanpäga Samaria provinciaparämi päsayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Saypa päsarmi Samariacho cag Sicar nishgan marca naupanman chäyargan. Saychömi Jacobpa chacran cargan. Say chacratami surin Josëta unay goycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Say chacrachömi cargan Jacob yacuta jorgunanpä uchcusishgan pözu. Say pözu cagman chaycurmi Jesús uticash jamaycorgan. Say höra cargan pulan junagnönami. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Saycho Jesús jamapashganyagmi discïpuluncuna micuyta ranteg marcapa aywayargan. Micuyta ranteg aywayashganyagmi Jesús jamaraycashgan cagman Samaria warmi chargan yacucog. Saymi yacunashpan yacuta Jesús manacorgan say warmita. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Say wisanga Samaria runacunawan Israel runacuna contra contrami ricanacuyargan. Saymi yacuta manacuptin say warmi nergan Jesusta: “Israel runa caycarga ¿imanirtä yacuta manacamanqui Samaria warmi cashgäta musyaycar?” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Saymi Jesús nergan: “Tayta Diosninsipa palabranta tantyar y noga pï cashgätapis musyarga gampis yacuta manacamanquimanmi. Manacamaptiquega cawasicog yacutami puestupäshayqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Saymi say warmi nergan: “Yacoga rurichörämi caycan. Jorgunayquipä imayquipis mana caycaptenga ¿imanöpatä jorgamunquiman cawasicog yacuta puestupämänayquipäga? ");
INSERT INTO qvhNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Unay awilunsi Jacobmi cay pözuta uchcusergan. Cay pözupitami yacuta upuyargan uywancunapis, surincunapis y quiquinpis. Paypis cay pözupitarä yacuta jorgamush caycaptenga gam ¿maypitatä say yacuta jorgamunquiman?” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sayno niptinmi Jesús nergan: “Cay pözupita yacuta upog cäga yapaypis yacunaycäyangami. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noga puestupashgä yacuta upog cagmi isanga imaypis manana yacunäyangapänasu. Paycunaga Tayta Diospa naupanchömi imayyagpis cawayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sayno niptinmi Jesusta say warmi nergan: “Imaypis mana yacunänäpä ni cay pözumanpis yacucog manana cutiycämunäpä say yacuta puestupaycalämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Saymi Jesús nergan: “Ayway runayquita pushamuy.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Niptinmi say warmi nergan: “Manami runä cansu, taytay.” Sayno niptinmi Jesús nergan: “Rasun cagtami gam nimashcanqui. Gamga pisga runawannami tashcanqui. Canan taycashgayqui runapis puripänacuyashgayqui runalami caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sayno niptin say warmi nergan: “Diospa profëtan imacher gam caycanqui, taytay. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nogacunapa awilöcunaga tagay jircachömi Tayta Diosta adorayag. Gamcunaga, Israel runacuna carmi, ‘Jerusalenchörä Tayta Diosta adorashun’ nicäyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sayno niptinmi Jesús nergan: “Tagay jircaman mana aywaypa ni Jerusalenmanpis mana aywaypa Tayta Diosta adorayänayquipä cag höra chaycämunnami. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tayta Diosta adorarpis Samariapita cayashpayquimi gamcuna shumag musyayanquisu Tayta Diospa wilacuyninta. Tayta Dios cachamushgan salvacog runa Israel runa captinmi nogacuna musyayä paypa wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Israel runacuna y mana Israel runacunapis Santu Espíritu munashganno lapan shongunwan Tayta Diosta adorayänanpä cag höra chämushganami. Sayno adoranansitami Tayta Dios munan. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tayta Diosninsega Espiritumi caycan. Saymi lapan shongunsiwan maychöpis payta adoranansi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sayno niptinmi say warmi nergan: “Cristo shamunanpä cashganta musyämi, taytay. Pay shamurnami saycunata tantyasimäshunpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Saymi Jesús nergan: “Say shamunanpä cäga nogami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Micuyta rantiyämushganpita cutiycurmi discïpuluncuna Jesusta tarergan say warmiwan parlaycagta. Saymi quiquinpura: “¿Imanirtä cay warmiwan Jesús parlaycan?” niyargan. Isanga mayganpis manami tapupäyargansu imata parlayashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Warminami uylunta cachariycushpan marcaman aywar runacunata wilargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Juc runami pözu cagcho caycan. Paymi nimash imano cashgätapis. Acu aywashun ricayänayquipä. ¿Manasurä pay caycan salvamagninsi Cristo?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sayno niptinmi runacuna aywayargan Jesús caycashgan cagman payta ricayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sayyagmi discïpuluncuna Jesusta nergan: “Micushunna, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Saymi Jesús nergan: “Nogapa micuynë jucmi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Saymi discïpuluncuna quiquinpura parlar niyargan: “¿Pirä micuyta apapämush micunanpä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sayno yarpashganta tantyarmi Jesús nergan: “Nogapa micuynëga caycan cachamagnë nimashganta ruraymi. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¡Tantyacuyay! ¡Diospa wilacuyninta chasquicuyänanpä runacuna listunami caycäyan! Cananpita chuscu quilacho cosëcha listu cananpä cashgannömi tagay shamuycag Samaria runacunapis listuna caycan wilacuynëta chasquicuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wilacuynëta chasquicorga gloriacho cushishmi imayyagpis cawayangapä. Ali cosëcha cashganpita murog cagpis cosechag cagpis cushicushgannömi Diospa wilacuyninta punta wilacogcuna y guepa wilacogcunapis cushicuyan wilacushganta chasquicuptin.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Nircurnami Jesús nergan: “Diospa wilacuyninta wilacur unay profëtacuna murupacognöpis maynami wilacuyash noga shamunäpä cashganta. Say unay profëtacuna wilacuyashganmanmi gamcunatapis cachaycä wilacuynëta wilacuyänayquipä. Saymi wilacuyashgayquita runacuna wiyar cushicuyaptin: ‘Juc muruptinpis jucnami cosechan’ niyashgannöla caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Marcaman cutiycur: “Jesusmi nimash imano cashgätapis” nir say warmi wilacuptinmi asca runacuna criyiyargan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Saymi runacuna Jesús cagman chaycärir ruwacuyargan paycunawan quëdananpä. Sayno ruwacuyaptinmi paycuna cagcho Jesús goyargan ishcay junag. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Paycuna cagcho goyar wilapaptinmi más asca runacuna criyiyargan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Saymi say warmita runacuna niyargan: “¡Gam niyämashgayquega rasun cagmi caycan! Cananga quiquëcunanami pay yachasishganta wiyayashcä. Saymi tantyayä runacunata salvananpä Tayta Dios cachamushganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Saycho ishcay junag goyarcurmi Galilea provinciaman Jesús cutergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Galileaman cutiptinmi marca mayincuna cushicuyargan Jerusalencho milagruta rurashganno paycuna cagchöpis milagruta rurananpä cashganta yarpar. Jerusalencho milagruta rurashganta ricash carpis manami criyiyargansu Tayta Diospa wilacognin cashganta. Marca mayincuna sayno mana criyiyaptinmi Jesús nergan: “Tayta Diosninsipa profëtantaga marca mayincuna manami chasquicuyansu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Saypitana Jesús cutergan Galilea provinciacho caycag Caná marcaman. Saychömi yacuta vïnuman naupata ticrasergan. Canácho cashganta musyaycurmi Capernaum marcapita juc autoridä sayman aywargan. Chaycurmi Jesusta ruwacorgan wayinman aywaycur ansa caycag surinta aliyäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Saymi Jesús nergan: “¿Imanirtä gamcuna milagrutarä ricayta munaycäyanqui Tayta Dios cachamashganta criyiyänayquipä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sayno niptinpis say runa nergan: “Imano captinpis surëta aliyäsinayquipä wayëman jucla aywayculäshun, taytay. Mana aywaptiquega surë wanongacher.” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sayno niptin Jesús nergan: “Suriqui aliyashganami caycan. Cananga cushishgana wayiquipa cuticuy.” Sayno niptinmi Jesús nishganta criyir wayinpa cuticorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wayinman chaycaptinnashi ashmaynincuna taripaycur niyargan: “¡Suriqui aliyashganami caycan, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sayno niyaptin ashmaynincunata taporgan imay höra aliyashgantapis. Sayno tapuptinmi ashmaynincuna wilayargan ganyan pulan junagna surin aliyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sayno wilayaptinmi say runa yarpargan Jesús say höra: “Suriqui aliyashganami caycan” nishganta. Saypitanami say runa wayincho cagcunawan criyiyargan Jesusga Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Say wamrata aliyäsishganwanga ishcay cutinami milagruta Jesús rurargan Galilea provinciacho. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Saypitana Jerusalencho Tayta Diosta adorayänanpä fiesta captin Jesuspis aywargan say fiestaman. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén yaycunachömi “Uysha yargunan” nishgan puncu caycan. Saychömi caycan jatun pözu. Hebreo idiömachöga say pözupa jutin caycan Betesdami. Say jatun pözupa naupanchöga caycan pisga alarcunami. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pisgan alarcunachömi jitaraycäyargan asca gueshyaycag runacuna, gapra runacuna y puriyta mana puëdeg runacunapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Saychömi paycuna shuyaraycäyargan ciëlupita ángil urarcamur yacuta cuyusipänanpä. Yacuta cuyurcasiptinna maygan gueshyagpis puntata yacuman yaycog cäga aliyashgana yargamog. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Saychömi juc runa gueshyar jitaraycargan quimsa chunca puwag (38) watana. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Say runa unaypitana gueshyashganta musyarmi Jesús taporgan: “¿Aliyayta munanquicu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sayno niptinmi say gueshyaycag runa nergan: “Au, aliyaytami munä, taytay. Sayno captinpis manami pïnëpis cansu yacuta ángil cuyusiptin jatun pözuman yaycasimänanpä. Yaycunäpä caycaptëpis jucmi yaliman.” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sayno niptinmi Jesús nergan: “¡Sharcuy! Quirmayquita apacurcur aywacuy.” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","10","Sayno niptin say gueshyaycag runa jinan höra aliyargan. Nircurna quirmanta apacurcur cushish aywacorgan. Quirmanta apaycagta ricarmi Israel runacunapa autoridänincuna niyargan: “Sábado jamay junag caycaptenga ¿imanirtä quirmayqui apash aywaycanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Saymi say runa nergan: “Aliyäsimagnë runami nimash quirmäta apacurcur aywacunäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Saymi say runata tapuyargan: “¿Pitä sayno nishushcanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sayno tapuyaptin pï aliyäsishgantapis manami musyargansu, asca runacuna saycho captin. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Saypitana say aliyäsishgan runawan templucho tincurcur Jesús nergan: “Aliyashgana caycarga amana yapay jusalicuynasu. Yapay jusalicorga gueshyashgayquipitapis masmi imapis päsashunquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sayno niptin say runa autoridäcunaman aywar wilargan aliyäsegnin runa Jesús cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wilaptinmi autoridäcuna Jesuspa contran sharcuyargan sábado jamay junagcho aliyäsishganpita. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Saypitanami paycunawan tincur Jesús nergan: “Taytä alita rurashgannömi nogapis alita rurar say runata aliyäsishcä, sábado jamay junag captinpis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sayno niptinmi autoridäcuna Jesusta wanusiyta munayargan. Sayno wanusiyta munayargan manami sábado jamay junagcho runata aliyäsishgalanpitasu, sinöga: “Diosmi Taytä” nishganpitawanmi. “Diosmi Taytä” niptin paycuna yarpäyargan Dios-tucuycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Saymi Jesús nergan: “Diospa surin carmi lapantapis rurä Taytä munashgannöla. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Imatapis ruranäpäga Taytärämi cuyay surin captë tantyasiman. Saymi runacunata aliyäsishgalätasu ricayanquipä, sinöga más espantaypä cag milagrutapis ricayanquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Saymi juicio finalcho wanushcunata Taytä cawarisimunanpä munayyog cashganno nogapis munayyog caycä runacunata perdonar mushog cawayta gonäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Saynöpis juicio finalcho Taytä manami pitapis juzgangasu, sinöga surin captë nogatami nimash pï-maytapis juzganäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Sayno nimash quiquinta respitayashgannöla nogatapis lapan runacuna respitayämänanpämi. Saymi nogata mana respitamag cäga Taytätapis respitaycansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Shumag tantyacuyay. Wilacuynëta chasquicur cachamagnë Taytäman yäracogcunaga infiernuman manami gaycushgasu cayanga, sinöga gloriachömi imayyagpis cawayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Saynöpis wilacuynëta chasquicorga wanushno cashganpita mushog cawaytami chasquengapä. Say cawayta gonäpä cag höra maynami chämushgana. Saynölami höra chämonga wanushcunatapis cawarisimunäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pitapis cawayta gonanpä Tayta Dios munayyog cashgannömi nogapis munayyog caycä pitapis mushog cawayta gonäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Saynölami Tayta Diospita noga shamush captë lapan runacunata juzganäpä churamash. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ama yarpäyaysu wanushcunata mana cawarisimunäpä cashgäta. Höran chämuptenga lapan wanushcunatami cawarisimushä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Alita ruragcunaga cawarircamur imayyagpis gloriachömi cawayangapä. Mana alita ruragcunami isanga cawarimurpis infiernucho imayyagpis nacayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Cachamagnë Taytä munashgantami imaypis rurä. Saymi pay munashgannöla lapan runacunata juzgashäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","“Tayta Dios cachamashgantaga manami quiquiläsu në, sinöga milagrucunata ruranäpä yanapämashpan Tayta Diospis runacunata musyaycäsinmi paypita shamushgäta. Sayno musyaycäsishuptiquega tantyayay nishgäcuna rasunpaypa cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Saynölami Tayta Dios cachamashganta Juan Bautistapis wilacush. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Sayno wilacuptin ascagmi cushicuyargan shamunäpä cagta musyashpan. Nogapita Juan wilacushganta yarpaycäsë manami ali wilacog cashganta yarpänayquipäsu, sinöga Tayta Dios cachamashganta criyishpayqui salvacuyänayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nogapä Juan wilacushganta mana criyirpis milagro rurashgäcunata ricaycar y yachasishgäcunata wiyaycarga Tayta Dios cachamashganta criyiyay. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Saynöpami quiquin mana parlapäyäshushpayquipis y mana yuripäshushpayquipis Tayta Dios musyaycäsiyäshunqui nogata cachamashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sayno musyaycäsishuptiquipis nogata mana chasquicamarga Tayta Diostapis manami chasquicuycäyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Gamcunaga Tayta Diosninsipa palabranta liyir yachacuycäyanqui gloriaman chayta munarmi. Sayno yachacurpis manami tantyayanquisu say guelgashgancuna noga shamunäpä guelgaraycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Saymi nogata chasquicamayta mana munarga Tayta Diosninsipa palabranta mayjina yachacurpis gloriaman imaypis chäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","“Noga musyämi janan shongula Tayta Diosman yäracuycäyashgayquita. Saymi gamcuna mana chasquicayämaptiquipis nogaga imaypis Taytä nimashganta ruraycäshä. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","“Tayta Diospita shamush captëpis gamcunaga chasquicamayta manami munayanquisu. Quiquilanpa yarpaylanpita shamog runacuna nishgancunatami isanga chasquicuycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sayno chasquicuycäyanqui paycunapita ali ricash cayta munarmi. Sayno caycarga ¿imanirtä yarpaycäyanqui Tayta Dios munashganno cawaycashgayquita? ");
INSERT INTO qvhNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","“Gamcuna yarpäyanqui nogata mana chasquicamarpis Moisés guelgashgan leycunata cumplir salvacuyänayquipä cashganta. Sayno yarpäyaptiquipis Moisesga noga shamunäpä cagpitami guelgargan. Moisés guelgashgancunata rasunpaypa chasquicuyashpayquega noga nishgäcunatapis chasquicuyanquimanmi. Mana chasquicuyashgayquipitami juicio finalcho Taytäpa naupancho Moisespis niyäshunquipä jusayog cayashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nogapita Moisés guelgashgantapis mana chasquicuycarga ¿imanöparä noga nishgäcunata chasquicuyanquiman?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Saypitanami Galilea gochata Jesús simpargan. (Cananga say gochata niyan “Tiberias.”) ");
INSERT INTO qvhNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gueshyagcunata aliyäsishganta ricarmi paypa guepanta asca runacuna aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Saychönami jircanninman aywaycur discïpuluncunawan Jesús jamacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Say junagcuna Pascua chaycämorgannami.) ");
INSERT INTO qvhNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Paycuna caycäyashganman asca runacuna chaycäyämushganta ricarmi Felipita Jesús nergan: “Caysica runacunapäga ¿maypitatä micuyta rantimushun?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sayno nergan: “Mä imanimänäshi Felipe” nishpanmi. Jesús musyargannami imanöpa micuyta yurisinanpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Saymi Felipe nergan: “Puwag (8) quilantin arupacuycur gänapacushgansiwan rantimushgapis manami aypanmansu caysica runacuna walca walcala micuyänanpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Saymi Simón Pedrupa wauguin Andrés nergan: ");
INSERT INTO qvhNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Caycho juc wamra sararaycan pisga cebäda tantatawan ishcay pescädulatami, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Niptinmi Jesús discïpuluncunata nergan: “Lapan runacunata niyay jamacuyänanpä.” Saymi jamacuyänanpä discïpuluncuna niyaptin pashpaman lapan runacuna jamacuyargan. Saychömi olgu cagcunalata yupaptin cayargan pisga warangano (5,000). ");
INSERT INTO qvhNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nircurnami say pisga tantatawan ishcay pescäducunata Jesús aptarcur Tayta Diosta manacur agradëcicorgan. Agradëcicurcurnami discïpuluncunata macyargan runacunata aypuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lapan runacuna pacha junta micurcuptinnami discïpuluncunata Jesús nergan: “Pusupacuyashgancunata lapanta shuntayämuy.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sayno niptinmi pusushgan tantata discïpuluncuna shuntayargan chunca ishcay (12) canasta juntata. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Say milagro rurashganta ricaycurmi runacuna cushicur niyargan: “Cay runaga Tayta Dios cachamunanpä cag profëta imacher caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sayno niyashpanmi runacuna imaycanöpapis nacionninpa mandagnin rey cananpä churayta munayargan. Sayno churayänanta mana munarmi jircapa Jesús japalan aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pasa sacaycaptinnami Jesuspa discïpuluncuna cutiyargan gocha cuchunman. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesusmi isanga jircapita cutimorganräsu. Saymi büquiman wisarcur discïpuluncunala Capernaum marcaman aywaycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aywaycäyaptinmi fiyupa vientuptin yacu pulchagyar galaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Saypita juc lëwatano aywaycarna Jesusta ricayargan yacu jananpa paycuna cagmanpa aywaycagta. Payta ricaycurmi fiyupa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Saymi Jesús nergan: “¡Ama mansayämaysu! ¡Nogami caycä!” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sayno niptinmi büquita ichisiyargan Jesús wisänanpä. Saypita maylantanami gocha cuchunman chäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Milagruta Jesús rurashgan cagcho quëdag runacuna ricayargan saycho caycag juclayla büquiwan discïpuluncuna aywacuyashgantami. Paycunawan Jesús mana aywash captinmi yarpäyargan jircacho quëdacushganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Jesustapis ni discïpuluncunatapis mana tariyashpanmi Tiberias marcapita büquicuna chasquiyaptin say büquicunawanna Capernaum marcaman say runacuna aywayargan Jesusta ashishpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Capernaumcho Jesusta tariycurmi payta tapuyargan: “Taytay, ¿imay höratä caypa shamorgayqui?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Saymi Jesús nergan: “Gamcuna ashiycäyämanqui manami Tayta Dios cachamashganta tantyarsu, sinöga pacha junta micushgalayquipitami. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pachalayquipäga ama yarpachacuyaysu. Saypa trucanga yarpachacuyay mana ushacag cawayta tariyänayquipä. Say cawaytaga nogapitarämi chasquinquipä. Saypämi Tayta Diosninsi churamash.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sayno niptinmi paycuna tapuyargan: “Taytay, ¿imatatä rurayäman gloriaman aywayänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Saymi Jesús nergan: “Gloriaman aywayänayquipäga nishgäcunata chasquicuyay. Saytami Tayta Dios munan. Yäracamagcunata gloriaman pushanäpämi Tayta Dios cachamash.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sayno niptinmi niyargan: “Nishgayquicunata chasquicuyänäpäga mä ricayänäpä milagruta ruray. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sunyag saqui jircacho unay Israel mayinsicunapä maná nishgan micuyta Moisés puestupashganno gampis mä nogacunapä micuyta waran waran puestupäyämay. Micuyta Moisés puestupashganpitaga Tayta Diosninsipa palabranchöpis caynömi nican: ‘Tayta Diosmi ciëlupita micuyta paycunapä puestupargan.’ Saynöla gampis nogacunapä puestumuy.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Saymi Jesús nergan: “Shumag tantyacuyay. Moisés unay puestupashgan micuyga manami runacuna imayyagpis cawayänanpäsu cargan. Cananmi isanga runacuna imayyagpis cawayänanpä Taytä gloriapita juc micuytana puestumush. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Say micuytaga maynami ciëlupita cachamush. Say micuyta micurmi runacuna imayyagpis gloriacho cawayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Saymi paycuna niyargan: “Say micuytaga waran waran puestupaycayämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sayno niyaptinmi Jesús nergan: “Imayyagpis cawasicog micuyga nogami caycä. Nogata chasquicamag cäga pacha junta micushnömi imaypis cushish cawanga. Saynöpis nogaman yäracamag cäga yacuta jimashganyag upushnömi imaypis cushish cawanga. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sayno captinpis gamcunaga yachasishgäcunata wiyaycarpis y milagro rurashgäcunata ricaycarpis manami chasquicayämanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“Gamcuna mana chasquicayämaptiquipis Taytä acrashgan cagcunaga lapanpis nogata chasquicayämanmi. Nogata chasquicamagtaga manami pitapis gargushäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","39","Gargunäpa trucanga nogata chasquicamag cagtaga lapantapis juicio finalcho cawarisimushä. Taytä manami munansu nogaman yäracamagcuna mayganpis guepaman cuticunanta. Paycunata shumag ricanäpämi cay pasaman Taytä cachamash. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Saynöpami chasquicamagcunataga cawarisimushä gloriacho imayyagpis cawananpä. Saycho cawayänantami Taytä munan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gloriapita shamog micuy cashganta Jesús niptinmi saycho caycag Israel runacunapa autoridänincuna niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Cay runaga ¿manacu Josëpa surin? Nogansega musyansimi maman taytan pï cashgantapis. ¿Imanirtä payga: ‘Gloriapitami shamushcä’ nicämansi?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sayno niyaptinmi Jesús nergan: “Gamcuna mana tantyayashpayquimi sayno nicäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cachamagnë Tayta Dios tantyasishganta chasquicogcunalami nogata chasquicayäman. Chasquicamag cagtaga gloriacho imayyagpis cawananpämi wanuptinpis cawarisimushä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Tayta Diosninsipa profëtancuna guelgayashganchöpis caynömi nican: ‘Lapan runacunatapis quiquëmi musyasishä noga munashgäno cawayänanpä.’ Say guelgarashgannölami gamcunatapis Tayta Dios musyaycäsishunqui. Sayno captinpis pay tantyasishganta chasquicog cagcunalami nogata chasquicayäman. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gloriapita shamush car nogalami Tayta Diosta ricashcä. Manami pipis más paytaga ricashsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sayno captenga nogata chasquicamag caglami Tayta Diospa naupancho imayyagpis cawangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Nogaga imayyagpis cawasicog micuymi caycä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","¿Manacu sunyag saqui jircacho unay Israel mayinsicuna micuyargan maná nishgan micuyta? Sayta micurcaycarpis wanuyarganmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gloriapita shamog micuyta micog cagmi isanga imayyagpis cawangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nogami gloriapita shamog cag micuyga caycä. Runacuna gloriacho imayyagpis cawananpämi noga wanushäpä. Saymi say micuyta micog cäga wanurpis cawarimonga imayyagpis gloriacho cawayänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sayno niptinmi say autoridäcuna jucninpis jucninpis ninacuyargan: “¿Imanöpatä paytaga micushun?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Saymi Jesús nergan: “Say micuyta mana micorga y yawarnëta mana uporga manami pipis gloriaman chäyangasu. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Say micuyta micog cagtami y yawarnëta upog cagtami isanga cawarisimushä gloriacho imayyagpis cawananpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nogaga caycä rasunpaypa cag micuymi y yawarnëga rasunpaypa cag yacumi. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Say micuyta micog cagwan y yawarnëta upog cagwanmi imaypis caycäshä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Cachamagnë Taytä imayyagpis cawashgannömi nogapis cawaycä. Saynölami nogata chasquicamag cäga imayyagpis cawanga. Taytäpitarä cawayta chasquishgänölami nogata chasquicamagcunapis nogapitarä cawayta chasquiycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gamcunataga musyaycäsë gloriapita shamog micuy cashgätami. Unay Israel mayinsicuna maná micuyta micurpis wanuyarganmi. Gloriapita shamog micuyta micog cagmi isanga gloriacho imayyagpis cushishla cawayangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús sayno yachasergan Capernaum sinagogachömi. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Say yachasishganta wiyayashpan Jesuspa gatiragnincuna ascagmi niyargan: “Sayno parlaptenga ¿pitä paytaga criyenga?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sayno nicäyashganta tantyarmi Jesús nergan: “¿Imanirtä gamcuna sayno yarpaycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Canan sayno yarparpis gloriaman noga cutiycagta ricayämashpayquimi tantyayanquipä Tayta Dios cachamashgan Cristo cashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Noga nishgäcunata chasquicuyaptiquega Santu Espiritumi yanapäyäshunqui ali cawayänayquipä y gloriacho cushishla imayyagpis cawayänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Santu Espíritu yanapäyäshunayquipä caycaptinpis waquinniquega nishgäcunata manami chasquicuyanquisu.” Jesús sayno nergan maygan runacunapis payta mana chasquicuyashganta musyarmi. Saynöpis musyarganmi maygan discïpulun autoridäcunaman payta entregananpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Saymi Jesús nergan: “Waquinniqui mana chasquicayämänayquipä cashganta musyarmi mayna nishcä: ‘Tayta Dios tantyasishganta chasquicogcunalami nogata chasquicayäman.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Say nishganta mana tantyarmi asca runacuna Jesusta cachariycur aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Runacuna sayno aywacuyaptinmi chunca ishcay (12) acrashgan cag discïpuluncunata Jesús nergan: “¿Gamcunapis paycunano aywacuytacu munaycäyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saymi Simón Pedro nergan: “Gloriaman aywayänäpä shumag yachaycäsiyämaptiquega ¿imata ashirtä maypapis aywayäman, taytay? ");
INSERT INTO qvhNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogacunaga criyiyämi Tayta Dios cachamushgan Cristo cashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Saymi Jesús nergan: “Chunca ishcay (12) acrashgan cag discïpulöcuna cayänayquipäga nogami gamcunata acrashcä. Sayno captinpis gamcunapita jucmi diablo munashganta rurangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús sayno nergan Simonpa surin Judas Iscariotipämi. Chunca ishcay acrashgan cag discïpuluncunapita carpis paymi autoridäcunata pushargan Jesusta prësu sariyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Saypitanami Galilea provinciacho cag marcacunapa Jesús purergan. Judea provinciaman manami aywayta munargansu Israel runacunapa autoridänincuna payta wanusiyta munayaptin. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Jerusalencho Ramäda fiestapä walca junagla pishiycaptinmi wauguincuna Jesusta niyargan: “Fiestapä Jerusalenman ayway. Saychöpis milagrucunata ruray discïpuluyquicuna ricayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Reguish cayta munarga manami caylachösu milagrucunata ruranquiman. Jerusalén marcachöpis milagrucunata ruray lapanpis ricayänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesuspa wauguincuna sayno niyargan Tayta Dios cachamushgan Cristo cashganta mana criyiyashpanmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Saymi wauguincunata Jesús nergan: “Nogaga manami aywashäräsu. Gamcunami isanga imay hörapis aywayanquiman. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Saychöga runacuna manami chasquicayämansu, jusalicushgancunata niptë. Gamcunatami isanga chasquicuyäshunqui, jusalicushganta mana niyaptiqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gamcunala aywayay say fiestamanga. Manami hörä chämunräsu sayman aywanäpäga.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sayno nirmi Galilea provinciacho Jesús quëdacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wauguincuna Ramäda fiestaman aywasquiyaptinrämi pitapis mana wilapaylapa Jesuspis aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiestacho Jesusta mana ricarmi Israel runacunapa autoridänincuna parlayargan: “¿Maychörä say runa caycan?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Waquin runacuna niyargan Jesús ali runa cashganta. Y waquinnami niyargan lutanta yachasir puriycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Isanga autoridäcunata mansapäyashpan manami pipis lutalaga Jesuspita parlacorgansu runacuna wiyayga. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ramäda fiesta pulancho caycaptinnami Jerusalenman Jesús chargan. Nircurnami templo patiuman aywaycur Tayta Diosninsipa wilacuyninta yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Saycho yachasishganta wiyaycur yachag cashganta tantyarmi autoridäcuna niyargan: “Mana estudiash caycarga ¿imanöpatä cay runa ali yachan?” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sayno niyaptinmi Jesús nergan: “Nogaga yachä cachamagnë Tayta Dios yachasimash captinmi. Manami quiquiläpitasu cayno yachä. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yachasishgäcuna Tayta Dios munashganno cashganta musyayta munarga pay munashganno cawayay. Saynöparämi tantyayanquipä yachasishgäcuna Tayta Diospita cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Waquin runacunaga, ali ricash cayta munar, quiquinpa yarpaylanpitami yachasir puriyan. Nogaga manami paycunanösu yachasë, sinöga cachamagnë Tayta Dios munashgannölami yachasë. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gamcunaga Moisés guelgashgancunata sararaycanquimi saycunata yachacur Tayta Dios munashganno cawayänayquipä. Sayno sarararpis manami maygayquipis pay munashgannösu cawaycäyanqui. Saymi wanusimayta munaycäyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jesús sayno niptinmi runacuna niyargan: “¿Pitä gamta wanusiyta munaycäshunqui? ¡Supay imacher gamta löcutaycäsishunqui!” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Saymi Jesús nergan: “Sábado jamay junagcho puriyta mana puëdeg runata aliyäsishgaläpitami gamcunaga wanusimayta munaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tantyacuyay. Moisés yachasergan olgu wamra yurishganpita puwag (8) junagyog caycaptin cuerpunta señalasinansipämi. (Moisés yachasiptinpis say costumbrega cargan más unaypitanami.) Moisés guelgashgancunata cumplir ¿manacu sábado jamay junag captinpis olgu wamrapa cuerpunta señalayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Olgu wamrayquicunapa cuerpunta sábado jamay junag caycaptinpis señalaycarga ¿imanirtä nogata rabiapaycäyämanqui sábado jamay junagcho gueshyag runata aliyäsishgäpita? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pï cashgätapis manarä shumag tantyarga ¿imanirtä jusayog cashgäta yarpäyanqui? Shumag juiciuyquiwan parlayay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Saymi Jerusalencho tag waquin runacuna quiquinpura parlar niyargan: “¿Manacu cay runataga ashiycäyan wanusiyänanpä? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Asca runacunapa naupancho yachasiptinpis ¿imanirtä autoridäcuna upälacuyan? ¿Autoridäcunapis Tayta Dios cachamushgan Cristo cashgantasurä yarpaycäyan? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Manami payga Tayta Dios cachamushgan Cristusu canman. Musyansimi may marcapita pay cashgantapis. Tayta Dios cachamushgan Cristo shamuptenga manami pipis musyangapäsu maypita cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Runacuna sayno parlaycäyashgantami templo patiucho yachasishgan höra Jesús wiyargan. Saymi nergan: “Gamcuna manami rasunpaypasu musyayanqui maypita shamushgätapis. Manami quiquëpa munayläpitasu cay pasaman shamushcä, sinöga Tayta Dios cachamaptinmi shamushcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tayta Diospita shamush carmi noga musyä pay imano cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sayno niptinmi waquin runacuna rabiacuyashpan Jesusta prësu sarisiyta munayargan. Isanga prësu sariyargansu höran manarä captinmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sayno captinpis ascagmi criyiyargan Tayta Dios cachamushgan Cristo cashganta. Saymi paycuna niyargan: “Milagrucunata rurashganta ricarmi criyinsi Tayta Dios cachamushgan Cristo cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Runacuna Jesuspa favornin sayno nicäyashganta wiyaycurmi fariseo runacunawan mandag cüracuna cachayargan templo täpag wardiacunata Jesusta prësu sariyämunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Prësu saregcuna chäyänanpäga Jesús caynömi yachaycäsergan: “Gamcunawanga manami asca watasu caycäshäpä. Nogaga cachamagnë Taytä cagmanmi cuticushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ashiyämashpayquipis manami tariyämanquipäsu. Noga aywashgä cagmanga manami aywayta camäpacuyanquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesús sayno niptinmi Israel runacunapa autoridänincuna quiquinpura parlar niyargan: “Mana tarinansipäga ¿mayparä aywaconga? ¿Juclä nacioncho tag marca mayinsicunamansurä aywanga Diosta mana criyegcunata yachasinanpä? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imanirtä ashirpis mana tarinansipä cashganta nicämansi? ¿Imanirtä pay aywashgan cagman chayta mana camäpacunansipä cashganta nicämansi?” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ramäda fiestacho día junagmi lapan runacuna wiyayänanpä Jesús nergan: “Segaypa yacunaypanörä Tayta Diospa maquincho cawayta munag cäga nogata chasquicayämäsun. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tayta Diosninsipa palabrancho nishgannöpis pucyupita chuya yacuta upur cushicushgannömi chasquicamagcunapis fiyupa cushicuyangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sayno nishpanmi Jesús tantyasergan runacunapa shonguncho Santu Espíritu cananpä cashganta. Say wisanga Santu Espíritu manami chämorganräsu. Gloriaman Jesús cuticuptinrämi payta chasquicogcunaman Santu Espíritu shamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús sayno nishganta wiyaycurmi saycho cag waquin runacuna niyargan: “Moisés nishganno shamunanpä cag profëta imacher payga caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquin runacuna niyargan: “Paytami Tayta Dios cachamush salvamänansipä.” Y waquinnami niyargan: “Galilea runa caycarga ¿imanöpatä payga Tayta Dios cachamushgan Cristo canman? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tayta Diosninsipa palabranchöga nican mandag rey David castapita Cristo yurinanpä cashgantami. Saynöpis nican Belenchörä yurinanpä cashgantami. Belencho mana yurish carga manami payga salvamagninsi Cristo canmansu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sayno nirmi waquenga Jesuspa contran parlayargan y waquinnami favornin sharcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Chasquicuyta mana munarmi waquincuna prësu sariyta munayargan. Sayno munarpis manami sariyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Saypitami templo täpag wardiacuna cuticuyargan mandag cüracunawan fariseo runacuna caycäyashgan cagman. Cutiycuyaptinmi tapuyargan: “¿Imanirtä Jesusta prësu apayämushcanquisu?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sayno tapuyaptinmi wardiacuna niyargan: “¡Pay parlashgantanöga manami imaypis wiyayashcäsu!” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sayno niyaptinmi fariseo runacuna niyargan: “¿Gamcunatapis criyisiyäshushcanquicu Tayta Dios cachamushgan Cristo cashganta? ");
INSERT INTO qvhNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Say runataga manami maygan autoridäcunapis ni fariseo runacunapis criyiyansu Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mana yachag runacunalami paytaga criyiyan. ¡Say runacunaga manami musyayansu maycho sengan cashgantapis!” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Sayno niyaptinmi Nicodemo nergan: “Leyninsicuna nishgannöpis puntata quiquin parlashgantarä wiyashun imano cashgantapis ninansipäga.” (Nicodemoga cargan fariseo runami. Paymi naupata Jesús cagman aywargan paywan parlananpä.) ");
INSERT INTO qvhNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Saymi paycuna niyargan: “¿Gampis paypa marca mayincu caycanqui favornin sharcunayquipä? ¡Tayta Diosninsipa palabranchöpis manami imaypis nimansisu Galileapita profëta cananpä cashganta!” ");
INSERT INTO qvhNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Saypitanami wayincunapana lapan cuticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Saypitanami Jesús aywargan Olivos lömaman. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Saypita waraynin tuta templo patiuman cutiptinmi runacuna pay cashgan cagman shuntacäyargan. Saychömi Jesús paycunata yachasergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Saymanmi Moisés guelgashgan leycunata yachasegcunawan fariseo runacuna apayargan jusalicog warmita. Say warmita tariyargan runanta ganrataycagta. Sayno tariycurmi saycho caycag runacunapa naupanman say warmita ichiycasir Jesusta tapuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Cay warmita tariyashcä runanta ganratar juc runawan punuycagtami, taytay. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés guelgashganchöga nimansi cayno warmicunataga samgaypa wanusinansipämi. Gamga ¿imaninquitä, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sayno tapuyargan Jesusta lutanta parlasiyta munayashpanmi. Sayno tapuyaptinmi Jesús dëdunwan guelgargan pampacho. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaparir yaparir tapuyaptinnami ichircur Jesús nergan: “Maygayquipis jusaynag carga mä say warmita samgayay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sayno nircurmi pampacho yapay guelgargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sayno nishganta wiyaycuyashpanmi auquincunapita galaycur lapanpis gatimaylaman yargur aywacuyargan. Lapan aywacuyaptinnami say warmilana Jesuspa naupancho quëdargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Saymi say warmita Jesús nergan: “¿Maytä samgashunayquipä apamushogniquicuna? ¿Manacu ni juclaylapis samgashushcanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sayno niptin say warmi nergan: “Manami mayganpis samgayämashgasu, taytay.” Saymi Jesús nergan: “Nogapis manami munäsu samgash canayquita. Cananga wayiquipana aywacuy. Isanga amana jusalicuynasu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Saypitanami runacunata Jesús nergan: “Cay pasacho runacunapäga acsinömi caycä. Saymi nogata chasquicamag cäga manami Satanaspa munayninchönasu canga, sinöga Tayta Diospa maquincho car acsichöno cushish cawangapä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sayno niptinmi fariseo runacuna niyargan: “Sayno cashgayquita quiquilayqui nicaptiquega ¿imanöpatä nogacuna criyiyäman?” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sayno niyaptinmi Jesús nergan: “Quiquilä niptëpis noga nishgäcunaga rasun cagmi caycan. Taytäpa naupanpita shamushgäta y sayman cuticunäpä cashgantapis musyämi. Gamcunaga manami musyayanquisu maypita shamushgäta y mayman cuticunäpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Saymi yarpaylayquicunapita juzgaycäyämanqui. Nogaga manami gamcunanösu pitapis juzgä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cachamagnë Taytä nogawan imaypis captinmi pitapis juzgarga rasun caglata juzgä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Moisés guelgashganchöpis caynömi nican: ‘Ishcay testïgucuna say yarpayla niyaptinrämi criyiyanqui imapis rasun cag cashganta.’ ");
INSERT INTO qvhNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Say nishgannölami ishcay testïgucuna caycäyan Tayta Dios cachamashgan Cristo cashgäta ninanpä. Cachamagnë Taytämi juc testïgo, y jucag testïgöga quiquëmi caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sayno niptinmi tapuyargan: “Nishgayqui rasunpaypa cashganta tapuyänäpä ¿maychötä taytayqui caycan?” Saymi Jesús nergan: “Gamcunaga manami musyayanquisu Taytä pï cashgantapis ni noga pï cashgätapis. Noga pï cashgäta musyarga Taytä pï cashgantapis musyayanquimanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Templucho Jesús sayno nergan ofrendata shuntacuna churarashgan cagchömi. Runacunapa naupancho yachasiptinpis manami pipis payta prësu sariyargansu, höran manarä captinmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Saymi Jesús nergan: “Jusalicushgayquipita mana perdonash carmi gamcunaga aywanäpä cashgan cagman imaypis chanquipäsu. Saymi aywacuptë ashimarpis tariyämanquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sayno niptinmi Israel runacunapa autoridänincuna niyargan: “¿Imanirtä aywacunanpä cashganta nicämansi? ¿Wanusicuytasurä payga yarpaycan? Saycher pay cashgan cagman mana chänansipä cashgantaga nicämansi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Saymi Jesús nergan: “Nogaga gloriapitami shamushcä. Gamcunaga cay pasacho yureglami caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Saymi pï cashgäta wilaptëpis criyiyämanquisu. Sayno mana criyiyämashgayquipitami gloriaman imaypis chäyanquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sayno niptin niyargan: “Sayno parlanayquipäga ¿pitä gam canqui?” Saymi Jesús nergan: “Pï cashgätapis maynami wilashcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gamcunata tantyasinäpä ascarämi caycan. Sayno captinpis noga yachasishgäcuna manami quiquëpa yarpayläpitasu caycan, sinöga cachamagnë Taytä tantyasimashgalanmi. Pay nimashgancunaga lapanpis rasun cagmi caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesús sayno parlapaycaptinpis paycunaga manami tantyayargansu Tayta Diosninsi paypa taytan cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sayno mana tantyayaptinmi Jesús nergan: “Noga pï cashgäta canan mana tantyarpis wanusimashgayqui hörami tantyayanquipä pï cashgäta y Taytä nimashgannöla wilacushgätapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cachamagnë Taytäga imaypis nogawanmi caycan. Pay munashgannöla ruraptëmi imaypis yanapaycäman.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús sayno niptinmi ascag criyiyargan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Saypitanami payman criyeg Israel runacunapa autoridänincunata Jesús nergan: “Yachasishgänöla imaypis cawarga rasunpaypami discïpulöcuna cayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sayno cawarmi tantyayanquipä yachasishgäcuna rasun cag cashganta. Sayno tantyacorga manami diablupa munayninchönasu cawayanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sayno niptinmi niyargan: “Abrahampa castan caycäyaptëga ¿imanirtä sayno niyämanqui? Nogacunaga manami imaypis diablupa munayninchösu cawayashcä, sinöga Tayta Diospa maquilanchömi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Saymi Jesús nergan: “Shumag tantyacuyay. Jusalicuycho cawarga manami Tayta Diospa maquinchösu cawaycäyanqui. Jusalicog cäga lapanpis diablupa munayninchömi caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Diablupa munaynincho cawarga manami Diospa wamransu caycan, sinöga diablupami. Nogaga Diospa surin carmi munayyog caycä diablupa munaynincho caycagcunata jorgunäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Diablupa munaynincho cayashgayquipita noga jorguptëmi Tayta Diospa wamran rasunpaypa cayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Musyämi Abrahampa castan gamcuna cayashgayquita. Abrahampa castan caycarpis manami nishgäcunata chasquicayämanquisu. Chasquicamänayquipa trucanga ¿imanirtä wanusimayta munaycäyämanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taytäpa naupancho caycar musyashgäcunatami gamcunata wilapaycä. Sayno wilapaptëpis gamcunaga taytayqui munashgalantami ruraycäyanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Saymi paycuna niyargan: “¡Abrahampa castan cayaptë paymi nogacunapa taytä!” Sayno niyaptinmi Jesús nergan: “Abrahampa castan caycarpis manami pay cawashgannösu cawaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Abrahamga manami imaypis yarpargansu Tayta Diospa wilacogninta wanusiyta. Gamcunaga wanusimayta munaycäyanqui Tayta Dios nimashgancunata wilacuptëmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mana chasquicamaptiquimi musyacaycan gamcunapa taytayqui diablo cashganta. Saymi pay rurashgannöla imaypis ruraycäyanqui.” Sayno niptin paycuna niyargan: “Nogacunapa Taytäga Tayta Diosmi. Manami diablupa surinsu cayä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Saymi Jesús nergan: “Tayta Dios rasunpaypa taytayqui captenga nogata cuyayämanquimanmi. Paymi gloriapita cachamash cay pasaman shamunäpä. Manami quiquëpa munayläpitasu noga shamushcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imanirtä gamcuna tantyayämanquisu nishgäcunata? Chasquicamayta mana munarmi yaparir yaparir niptëpis gamcunaga tantyacuyanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Gamcunapa taytayquega diablumi caycan. Saymi pay munashgalanta imatapis ruraycäyanqui. Unaypita-pasa runa wanuseg pay cashgannömi gamcunapis nogata wanusimayta munaycäyämanqui. Saynöpis lula carmi diabloga imaypis rasun cagtaga parlansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nogaga rasun caglatami Tayta Diosninsipa wilacuyninta gamcunata yachasë. Tayta Diosninsipa wilacuyninta chasquicuyta mana munarmi nogatapis chasquicayämanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Imaypis mana jusalicush captëmi imatapis niyämänayquipä tariyanquisu. Rasun cagta wilacuycaptëga ¿imanirtä chasquicayämanquisu? ");
INSERT INTO qvhNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tayta Dios taytayqui captenga wilacuyninta cäsucuyanquimanmi. Wilacuyninta mana cäsucuyaptiquimi musyä Diospa wamran mana cayashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sayno niptinmi say autoridäcuna niyargan: “¡Gamga Samaria runacunanömi lutanta parlaycanqui! ¡Gamtaga supay imacher löcutaycäsishunqui!” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sayno niyaptinmi Jesús nergan: “Nogaga manami löcusu caycä, sinöga Taytä munashgalantami parlaycä. Sayno parlaptëpis gamcunaga mana tantyashpayquimi chiquiycäyämanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Runacuna chasquicayämaptinpis o mana chasquicayämaptinpis nogaga Taytä munashgannölami wilacuycä. Mana chasquicamag cagtaga Taytämi juzganga. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nishgäcunata chasquicogcunami isanga gloriaman char imaypis wanuyangapäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Saymi autoridäcuna niyargan: “Cananmi isanga rasunpaypa musyayä supay löcutaycäsishushgayquita. Abraham y Tayta Diosninsipa profëtancunapis lapanmi wanuyash. Sayno caycaptinpis gamga nicanqui: ‘Nishgäcunata chasquicogcunaga manami wanuyangapäsu.’ ");
INSERT INTO qvhNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sayno nerga ¿mana wanunayquipä cashgantacu yarpaycanqui? Mana wanunayquipäga manami Abrahampita más munayyogsu caycanqui. Paypis y Tayta Diosninsipa profëtancunapis wanush caycäyaptenga ¿pï cashgayquitatä gamga yarpanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Saymi Jesús nergan: “Sayno nishgäpita ama yarpäyaysu alabacuycashgäta. Taytä cachamash captinmi rasun caglata nicä. Gamcunaga Taytäta ‘Diosnëmi’ nicarga ¿imanirtä criyiyämanquisu nishgäcunata? ");
INSERT INTO qvhNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Taytä imano cashgantapis gamcuna manami musyayanquisu. Nogami isanga lapanta musyä imano cashgantapis. Saymi Taytä nimashgancunalata parlaycä. Gamcuna munayashgayquino yachaserga manami rasun cagtasu parläman, sinöga gamcunanölami lulacuycäman. ");
INSERT INTO qvhNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","‘Abrahampa castanmi nogacuna caycäyä’ niyaptiquipis Abrahamga manami gamcunanösu cargan. Payga cushicorganmi cay pasaman shamunäpä cashganta musyashpan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Saymi autoridäcuna Jesusta niyargan: “Manarä ni pisga chunca (50) watayoglapis caycarga ¿imanöpatä Abrahamta reguinquiman cargan?” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sayno niyaptinmi Jesús nergan: “Tantyacuyay. Abraham manarä yuriptin nogaga maynami caycargäna.” ");
INSERT INTO qvhNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesús sayno niptinmi rumita aptacuyargan samgaypa wanusiyänanpä. Sayno samgayta munayaptinmi runacunapa chaupinpa päsarir templo patiupita Jesús aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jerusalencho puriycarmi Jesuspa discïpuluncuna ricayargan yurishganpita-pasa gapra runata. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Saymi Jesusta tapuyargan: “Taytay, ¿imanirtä cay runa gapra yurish? ¿Mamanpawan taytanpa jusanpitacu o quiquinpa jusanpitacu?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sayno tapuyaptinmi Jesús nergan: “Manami quiquinpa ni mamanpa ni taytanpa jusanpitasu cay runa gapra yurish, sinöga aliyäsiptë Tayta Dios munayyog cashganta runacuna tantyacuyänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Saymi cay pasacho cashgäyag cachamagnë Tayta Dios munashganno runacunata aliyaycäsë. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cay pasacho cashgäyäga runacunapä acsinömi caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sayno nishpanmi pampaman Jesús togaycur mituta rurargan. Nircurna say mituwan gaprapa nawinta püchapargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Püchaparcurmi nergan: “Siloé nishgan pözuman ayway saycho maylacamunayquipä.” (Siloé ninanga “Cachamush” ninanmi.) Jesús nishganno maylacaramurnami ricaycarna cutergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Saymi vecïnuncuna y payta reguegcuna niyargan: “¿Manacu cay runaga caridäta manacog gapra runa caycan?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquin niyargan: “Au, paymi.” Waquinnami niyargan: “Manami paysu. Isanga pay-niragmi.” Sayno niyaptinmi quiquin nergan: “Au, nogami yurishgäpita-pasa gapra cargä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Saymi payta tapuyargan: “¿Imanöpatä aliyaycushcanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sayno tapuyaptinmi nergan: “Jesusmi togayninwan mituta rurarcur nawëta püchapämash. Nircurnami cachamash Siloé nishgan pözuman nawëta maylacunäpä. Saycho maylacushgäpitami cananga nawë ricaycanna.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Saymi payta yapay tapuyargan: “¿Maychötä caycan say aliyäsishogniqui runaga?” Sayno tapuyaptin nergan: “Manami musyäsu maycho caycashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Saypitana say gapra cashganpita aliyash runata pushayargan fariseo runacunaman. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Sábado jamay junag aliyash captinmi fariseo runacuna payta tapuyargan imanöpa aliyashgantapis. Tapuyaptinmi nergan: “Juc runami nawëta mituwan püchapämargan. Say püchapämashgan mituta maylacusquiptëmi nawë ricaycanna, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Saymi waquin fariseo runacuna niyargan: “Say aliyäsishogniqui runaga manami Tayta Dios cachamushgansu canman. Tayta Dios cachamushgan runa carga sábado jamay junagchöga manami aliyäsinmansu pitapis.” Saycho caycag waquin runacunanami niyargan: “Tayta Dios mana cachamush captenga ¿imanöpatä aliyäsinman cargan say runata?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Saymi yapay tapuyargan gapra cashganpita aliyash runata: “Gamga ¿pï cashgantatä yarpanqui say aliyäsishogniqui runapäga?” Sayno tapuyaptinmi nergan: “Nogaga yarpä Tayta Diosninsipa profëtan cashgantami.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sayno niptinpis Israel runacunapa autoridänincunaga manami criyiyargansu rasunpaypa gapra cashganta. Saymi mamantawan taytanta gayaycasimur tapuyargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“¿Cay runa suriquicu? ¿Rasunpacu gapra yurergan? ¿Imanöpatä aliyash?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Saymi mamanwan taytan niyargan: “Au, payga surëmi. Rasunpaypami yurishganpita-pasa gapra cash. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Isanga manami musyayäsu imanöpa aliyashgantapis ni pï aliyäsishgantapis. Payga caycan juiciuyog runanami. Quiquinta tapuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mamanwan taytan sayno niyargan autoridäcunata mansacuyashpanmi. Autoridäcunaga wilanacuyashganami caycäyargan mayganpis: “Jesusga Tayta Dios cachamushgan Cristumi” neg cagtaga sinagogapita garguyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sayta mansacurmi mamanwan taytan niyargan: “Payga juiciuyog runanami. Quiquinta tapuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Saymi gapra cashganpita aliyash runata autoridäcuna yapay gayasiyämorgan tapuyänanpä: “Tayta Dios ricaycäshunquimi. Rasun cagta wilayämay. Musyayämi say aliyäsishogniqui runataga Tayta Dios mana cachamushganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Saymi say runa nergan: “Nogaga manami musyäsu Tayta Dios cachamushganta o mana cachamushgantapis. Isanga musyä gapra cashgäpita aliyäsimashgantami.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sayno niptin yapay tapuyargan: “¿Imatatä rurash aliyäsishunayquipä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Niptinmi nergan: “Maynami gamcunata wilashcäna. Wilaptëpis manami criyiyämanquisu. ¿Imanirtä yaparir yaparir tapuyämanqui? ¿Gamcunapis payta gatiraytacu munaycäyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sayno niptinmi rabiacuyashpan niyargan: “Gamcher paypa discïpulonga caycanquega. Nogacunaga Moisés yachasishgancunatami cäsucuyä. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Musyayämi Moisesta Tayta Dios mandamientuncunata entregashganta. Say aliyäsishogniqui runataga, jusasapa captin, Tayta Dios manami imatapis musyasishgasu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sayno niyaptinmi gapra cashganpita aliyash runa nergan: “¿Imanötä sayga? Say runa nawëta aliyaycäsimaptenga ¿imanirtä tantyayanquisu Tayta Dios cachamushganta? ");
INSERT INTO qvhNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Milagruta rurananpäga Tayta Dios manami imaypis jusasapacunata yanapansu, sinöga payta adorar munashganno cawagcunalatami. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manami imaypis wiyashcansisu yurishganpita-pasa gapra runata pipis aliyäsishganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tayta Dios mana yanapaptenga say runa manami imanöpapis aliyäsimanmansu cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sayno niptinmi autoridäcuna niyargan: “¡Gamga jusasapa carmi gaprapis yurishcanqui! ¡Sayno caycarga manami imatapis nogacunata yachasiyämanquimansu!” Sayno niyashpanmi sinagogapita say runata garguyargan imaypis manana cutinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Say aliyäsishgan runata sinagogapita garguyashgantami Jesús musyargan. Saymi paywan tincurcur nergan: “¿Tayta Dios cachamushgan runaman yäracunquicu?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Niptin say runa nergan: “Reguerga payman yäracömanmi, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Saymi Jesús nergan: “Tayta Dios cachamushgan runawanga maynami tincushcanqui. Say runaga nogami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sayno niptinmi Jesuspa puntanman gongurpacuycur nergan: “Gamman yäracömi, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sayno niptinmi Jesús nergan: “Nogaga cay pasaman shamushcä mana tantyacogcunata tantyasinäpä y yachag-tucogcunata upatacäsinäpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sayno nishganta wiyayashpanmi saycho caycag waquin fariseo runacuna niyargan: “¿Nogacunapis upa cayashgätacu yarpanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sayno niyaptin Jesús nergan: “Gapra runa chasquicamashganno gamcunapis chasquicayämaptiquega Tayta Dios jusayquicunata perdonayäshunquimanmi. ‘Salvashganami caycä’ nicarpis nogata mana chasquicamaptiquega Tayta Dios manami perdonayäshunquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mastapis Jesús nergan: “Uysha cunchaman puncupa mana yaycog cäga suwami caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Cuncha puncupa yaycog cagmi isanga uyshapa ämun caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Musyashgansinöpis cuncha puncuta quichapasquiptin uyshapa ämonga jutinpa jutinpa gayan uyshancunata. Sayno gayashganta wiyashpanmi cunchapita uyshancuna yargayämun. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lapan yargamurnami ämunpa guepanta aywayan, ämunta reguiyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jäpa captenga manami gatiräyansu. Gatiräyänanpa trucanga gueshpirmi aywacuyan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tincusiypa sayno Jesús yachasiptinmi saycho cag runacuna tantyayargansu sayno tincusir imata yachaycäsishgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Saymi Jesús nergan: “Nogaga caycä uysha cuncha puncunömi. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","9","Saymi cuncha puncupa uyshacuna yaycuyashganno nogata chasquicamag runacuna gloriaman yaycuyangapä. Uyshacuna ali guewacho weray weray cayashgannömi nogata chasquicamagcuna ali cawayta tariyangapä. Manarä shamuptë waquin runacuna lutanta yachasiyashpan puriyargan: ‘Nogatami Tayta Dios cachamash wilacuyninta wilacunäpä’ niyashpan. Sayno yachasiyaptinpis Tayta Diosman rasunpaypa yäracogcuna paycunata manami chasquicuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwaga shamun suwacunanpä, wanusinanpä y ushacäsinanpämi. Nogami isanga shamushcä chasquicamag runacuna imayyagpis cushishla cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Saynöpis uyshanta ali miseg runanömi caycä. Uyshancunata wanuy caway misegnin salvashgannömi nogapis uyshäcunata salvanä-raycu wanushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pägu-raycula misipacog cäga löbu shamuptin gueshpirmi aywacun. Sayno aywacun ämun mana cashpanmi. Sauraga löbu gaticachaptin uyshacuna gueshpir mashipa mashirmi may-saypapis aywacuyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Sayno misipacog cäga uyshacuna elagaptinpis manami imapis gocunsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nogaga rasunpaypa ali miseg runanömi caycä. Saymi Taytäta reguishgäno y pay nogata reguimashganno nogapis uyshäcunata reguë y uyshäcunapis nogata reguiyäman. Saynöpis uyshäcuna-raycumi wanushäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Manami caylachösu uyshäcuna caycan, sinöga may-saychöpis caycanmi. Paycunapis nishgäcunata wiyar cäsucayämangami. Saymi paycunatapis shuntamushä juc cunchalachöna cananpä. Saynöpis juclaylanami uysha misegnin cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taytäta cäsucur uyshäcuna-raycumi wanushä. Nircurnami cawarimushäpä. Sayno cäsucog captëmi Taytä cushicun. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Noga munayyogmi caycä wanunäpä y cawarimunäpäpis. Saymi quiquë mana munaptëga pipis wanusimanmansu. Sayno captinpis Taytä nimashgannömi wanushä y wanushgäpita cawarimushä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús sayno parlaptinmi Israel runacunapa waquin autoridänincuna yarpäyargan rasun cagta nicashganta y waquin cagna yarpäyargan quiquinpa yarpaylanpita parlaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Saymi waquin niyargan: “Payta supay löcutaycäsiptenga ¿imapätä cäsushunpis?” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Y waquin cagnami niyargan: “Supay löcutäsish captenga manami sayno parlanmansu. Saynöpis gapra runata manami aliyäsinmansu cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Diciembri quila templupa aniversariun fiestata rurayaptinmi templucho Jesús puriycargan Salomón nishgan alarcho. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Saychömi Israel runacunapa autoridänincuna Jesusta tapuyargan: “¿Imayyagtä shuyäshayqui rasun cagta wilayämänayquipä? Tayta Dios cachamushgan Cristo cashgayquita o mana cashgayquitapis jucla wilayämay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sayno niyaptinmi Jesús nergan: “Maynami gamcunata wilashcä. Wilaptëpis manami criyiyämanquisu. Taytäpa munayninwan milagrucunata ruraycaptëpis manami criyiyämanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gamcunaga criyiyämanquisu uyshäcuna mana cayashpayquimi. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Uyshäcunami isanga pï cashgätapis tantyayashpan cäsucayäman. Saynöpis reguëmi uyshäcuna maygan maygan cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nogata chasquicamashganpitami Tayta Diospa naupancho imayyagpis cawayangapä. Maquëcho captinnaga manami pipis guechumanganasu. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maquëcho caycarga Taytäpa maquinchöpis caycanmi. Taytä lapanpäpis munayyog captinmi diablupis ni supaypis ni pipis paypa maquinpita jorgongasu. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taytäwan nogaga juclaylami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sayno niptinmi say autoridäcuna Jesusta samgayta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Saymi Jesús nergan: “Gamcuna ricayashcanquimi asca milagrucunata Taytäpa munayninwan rurashgäta. ¿Sayno alita rurashgäpitacu samgayta munaycäyämanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Saymi say runacuna niyargan: “Manami alita rurashgayquipitasu samgayta munayä, sinöga runala caycar Dios-tucuycashgayquipitami.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sayno niyaptin Jesús nergan: “Tayta Diosninsipa palabrancho caynömi nican: ‘Gamcunaga dioscunami caycäyanqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Musyayanquimi Tayta Diospa palabrancho lapanpis rasun cagla cashganta. Saymi Diospa wilacuyninta unay wiyagcunapä: ‘Gamcunaga dioscunami caycäyanqui’ nicaptenga ¿imanirtä: ‘Diospa surinmi caycä’ niptë yarpäyanqui lutanta nicashgäta? Quiquin Tayta Diosninsimi cay pasaman cachamash. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Milagruta rurashgäcuna Taytä munashganno mana captenga ama criyiyämaysu: ‘Diospa surinmi caycä’ niptëpis. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nishgäcunata mana criyirpis milagruta rurashgäcunata ricaycarga tantyacuyay Taytäwan say yarpayla cayashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sayno nishganpitami Jesusta yapay prësu sarisiyta munayargan. Sayno munayaptinpis Jesús saypita aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nircurnami Jordán mayu simpanman Jesús cutergan. Saychömi naupata Juan Bautista bautizargan runacunata. ");
INSERT INTO qvhNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jesús saycho cashganta musyarmi sayman asca runacuna aywayargan. Paycunami niyargan: “Ima milagrutapis Juan Bautista mana ruraptinpis Jesuspä lapan nishgancunaga rasun caglami caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sayno nirmi asca runacuna criyiyargan Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania marcachömi targan juc runa Lázaro jutiyog. Paymi pasaypa ansa caycargan. Paypa panincunami cayargan Mariawan Marta. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mariami Jesuspa chaquinman perfümita winaparcur agsanwan pisapargan.) ");
INSERT INTO qvhNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro ansa caycaptinmi panincuna juc runata Jesusman cachacorgan: “Cuyanacuyashgayqui Läzarumi wanuycanna, taytay” nir wilananpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sayno wilaptinmi Jesús nergan: “Läzaruta say gueshya sarish manami wanushgalancho quëdananpäsu, sinöga noga cawarisimuptë munayyog cashgäta runacuna tantyacuyänanpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","7","Läzaruwan y panincunawan cuyanacurpis Jesús manami juclaga aywargansu. Saypa trucanga wanunaycashganta wilaycaptinpis cashgan caglachömi ishcay junag goyäcorgan. Saypitanami discïpuluncunata nergan: “Acu cutishun Judea provinciapa.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Saymi discïpuluncuna niyargan: “Ganyancunarächä saycho cag runacuna samgaypa wanusiyta munayäshushcanqui, taytay. ¿Sayno caycaptincu sayman yapay cutiyta munaycanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Saymi Jesús nergan: “Ama mansacuyaysu. Wanusimänanpäga manami hörä chämunräsu. Musyashgansinöpis sacaypa puregcunalami mansacuyan. Junagpa puregcunaga manami mansacuyansu. Saynölami wanusiyämänanpä hörä manarä chämuptin gamcunaga mansacuyänayquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nircurnami Jesús discïpuluncunata nergan: “Cuyashgansi Läzaroga punucashlami caycan. Acu aywashun ricchasinansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Sayno niptinmi discïpuluncuna niyargan: “Ali punuyta tariptinmi musyansi aliyänanpä cashganta, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lázaro punucash cashganta nirpis wanush cashgantami Jesús tumasipaylapa nergan. Saymi discïpuluncunaga mana tantyar punucash caycashgalanta yarpäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sayno yarpäyaptinmi Jesús discïpuluncunata nergan: “Läzaroga wanushmi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wanushganpita cawarisimuptëmi gamcuna más tantyayanquipä Tayta Dios cachamashganta. Saymi cushicö Lázaro cashgan cagcho mana cashgäpita. Pay cagman acu aywashun.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Saymi Milish niyashgan Tomás discípulu mayincunata nergan: “Sayno captenga nogansipis wanunansipä aywashun.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betaniaman charnami Jesús musyargan chuscu junagna Lázaro pamparaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Jerusalenpita Betaniaman media lëwanöla captinmi asca runacuna aywayargan Martatawan Mariata walquiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","“Jesusmi shamuycan” negta wiyarmi Marta aywargan taripänanpä. Mariami isanga wayicho quëdacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesuswan tincurmi Marta nergan: “Caycho captiquega turë manachi wanuycunmansu cargan, taytay. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Imano captinpis gammanmi imaypis yäracö. Noga musyämi imata manacuptiquipis Tayta Dios wiyashushgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sayno niptinmi Jesús nergan: “Turiqui cawarimongami.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Saymi Marta nergan: “Au, musyämi juicio finalcho wanushcuna cawarimuptin turëpis cawarimunanpä cashganta, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Niptinmi Jesús nergan: “Nogami cawarisimö wanushcunata. Nogata chasquicamag cagtaga wanuptinpis cawarisimushämi gloriacho imayyagpis cawananpä. ¿Sayta criyinquicu?” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Sayno niptinmi Marta nergan: “Au, taytay. Noga criyëmi. Gammi Tayta Diospa surin caycanqui. Saynöpis caycanqui Tayta Dios cachamushgan Cristumi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sayno nircurmi Marta cutergan nanan María cagman paypis Jesuswan tincog aywananpä. Chaycushpanna gayaycur wilargan: “Jesusmi chämush. Paymi gayaycäshunqui” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sayno niptin María jucla aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús manarämi marcaman charganräsu, sinöga Martawan tincushgalanchörämi caycargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wayipita María jucla yargogta ricayashpanmi payta walqueg runacuna guepanta aywayargan: “Turin pamparaycashganmancher aywaycan wagananpä” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesús cagman María chaycurmi puntanman gongurpacuycur nergan: “Gam caycho captiquega manami turë wanunmansu cargan, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariata y walquegnin runacunatapis wagaycagta ricarmi Jesuspis fiyupa laquicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Saymi paycunata taporgan: “¿Mayninchötä pamparaycan?” nir. Tapuptinmi niyargan: “Maynincho pamparaycashgantapis ricanayquipä aywashun, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pamparashgan cagman aywaycarmi Jesuspis laquicushpan Läzarupä wagargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Saymi waquin runacuna niyargan: “Ricay, segaypacher cuyanacuyargan Läzaruwan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waquinnami niyargan: “Gapra runatapis aliyaycäserga ¿manasurä Läzarutapis aliyäsinman cargan mana wanunanpä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Fiyupa laquishmi Jesús chargan Lázaro pamparashgan cagman. Say pamparashgan sepultüraga cargan gagacho uchcushmi. Puncunnami saparargan jatun rumiwan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sayman chaycurmi Jesús nergan: “Saparaycag rumita witisiyay.” Sayno niptinmi Läzarupa panin Marta nergan: “Chuscu junagnami pamparaycan, taytay. Cananyäga segaypanacher asyaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sayno niptin Jesús nergan: “¿Manacu nishcä nogaman yäracamaptiquega turiquita cawarisimunäpä cashganta?” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Sauraga saparaycag rumita witircasiyaptinnami ciëluta ricärir Jesús nergan: “Manacushgäta imaypis wiyamashgayquipitami gamta agradëcicamö, papá. Yanapämashgayquita ricarmi caycho caycag runacuna tantyayangapä gam cachamashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nircurnami Jesús fuertipa nergan: “¡Lázaro, yargamuy!” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sayno niptinmi wanush jitaraycashganpita cawarircamur Lázaro yargamorgan uman wancush y maquin chaquin wancush. Yargaramuptinnami Jesús nergan: “Purinanpä pascayay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Läzaruta cawarisimushganta ricaycurmi Mariata walqueg runacuna ascag criyiyargan Jesusta Tayta Dios cachamushganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin cagnami fariseo runacunaman aywaycur wilayargan Läzaruta cawarisimuptin asca runacuna payman criyiycäyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sayta wiyaycurmi mandag cüracunawan fariseo runacuna Israel runacunapa autoridänincunata gayaycasir niyargan: “Milagrucunata ruraptin aläpanami runacuna criyiycäyan Dios cachamushgan Cristo cashganta. ¿Imatatä rurashun say runata? ");
INSERT INTO qvhNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Payta prësu mana sarisishgaga milagro rurashgancunata ricar lapan runacunami munayanga nacionninsipa mandagnin rey cananta. Sayta wiyaycurmi Romacho mandag emperador fiyupa rabiacushpan soldäduncunata cachamonga templunsita juchusiyänanpä y lapansitapis wanusimänansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sayno niyaptin más mandag cüra Caifás nergan: “¡Gamcunaga manami imatapis tantyayanquisu! ");
INSERT INTO qvhNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Templunsita mana juchusinanpä y mana ushacäsimänansipä say runala wanusun. Saynöpami lapansipis salvacushunpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","“Say runala wanusun lapansi salvacunansipä” nir Caifás nergan Roma runacuna Israel runacunata ushacäsiyänanta mana munarmi. Payga manami tantyargansu jusansicunapita wanur Jesús salvamänansipä cashganta. Mana tantyaptinpis sayno parlananpä Tayta Dios yarpayninman churargan más mandag cüra say wata captinmi. Caifás nishgannölami Jesús wanorgan Israel runacunata y mana Israel runacunatapis salvananpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Say junagpitanami autoridäcuna wilanacuyargan Jesusta wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sayta musyarmi Israel runacunapa autoridänincuna ricayga Jesús purergannasu. Saymi Judea provinciapita Jesús discïpuluncunawan aywacuyargan Efraín nishgan marcaman saycho goyäyänanpä. Say marcaga sunyag jirca cercalanchömi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Say junagcuna Pascua galaycunanpäna caycaptinmi marcancunapita asca runacuna Jerusalenman aywayargan Tayta Dios nishganno say fiestapä puestucog. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Templo patiuchönami runacuna niyargan: “Gamcunaga ¿imatatä yarpäyanqui? ¿Fiestapä Jesús shamongasurä o manasurä?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo runacunawan mandag cüracuna maynami runacunata nish cashga: “Jesusta maychöpis ricashpayquega jucla wilayämanqui prësu sarisiyänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascuapä sogta junag pishiycaptinmi Jesús aywargan Betania marcaman. Saychömi wanushganpita cawarisimushgan Lázaro targan. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sayman Jesús chashganpita cushicurmi Läzarupa panincuna merendata yanucuyargan paywan micuyänanpä. Waquin runacunawan mësa cagman Jesús jamacuptinmi Läzarupis jamargan paycunawan micunanpä. Saymanmi panin Marta paycunata garargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Saycho micuycäyaptinmi botëllawan María apamorgan nardu jachapita rurash chanin cuestag perfümita. Nircurmi Jesuspa chaquinman winaparcur agsanwan saquisipargan. Say perfümimi wayi junta mushcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Saymi Jesusta entregananpä cag discïpulun Judas Iscariote nergan: ");
INSERT INTO qvhNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imanirtä cay perfümita perdiycäsin? Saypa trucanga ranticushwan cargan juc wata arupacur gänashgansichöno. Nircur say guellaywanna muchogcunata yanapashwan cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasmi shuntayashgan guellay sararag cargan. Sayno nergan manami muchogcunata yanapayta munarsu, sinöga quiquinpä guellayta raquinan cashmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Saymi Jesús nergan: “Winapämashganpita ama jamuraysu. Say perfümitaga churaräsish manarä wanuptë winapämänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Muchogcunaga yanapäyänayquipä imaypis caycäyangami. Nogami isanga gamcunawan cashäpänasu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Betania marcacho Jesús caycashganta musyarmi asca runacuna sayman aywayargan. Manami Jesusta ricaglasu aywayargan, sinöga Lázaro cawarimushganta ricayänanpäwanmi aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Läzaruta cawarisimushganpita Jesusman asca runacuna criyiptinmi mandag cüracuna Läzarutapis wanusiyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Waraynin tuta runacuna musyayargan Jerusalenman Jesús aywaycashganta. Saymi Pascuaman aywag asca runacuna, palmacunata muturcur, apayargan Jesusta chasquicuyänanpä. Jesús chaptinna niyargan: “¡Tayta Diosninsi cachamushgan mandamagninsi caychönami caycan! ¡Paymi mandamagninsi rey caycan!” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tayta Diosninsipa palabrancho guelgaraycashgannölami manarä amansashga orgu ashnun muntash Jerusalenman Jesús chargan. Say guelgaraycashganga caynömi nican: ");
INSERT INTO qvhNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalén marcacho tag runacuna, ricayay humildi runanöla mandagniqui rey manarä amansashga ashnun muntash shamuycagta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jerusalenman ashnun muntash Jesús chaptinmi discïpuluncuna tantyayargansu imanir sayno ruraycashgantapis. Wanushganpita cawarircamuptinrämi tantyayargan Jesús rurashgancuna Tayta Diospa palabrancho nishgannöla caycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Läzaruta cawarisimushganta musyashpanmi asca runacuna cushish Jesusta taripag shayämorgan. Pay cawarisimushganta ricag runacunapis Tayta Diosta alabaraycar aywaycäyargan. Nänipa aywayashpanmi pï-maytapis tincushgan cagta wilapäyargan Läzaruta cawarisimushganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jesusman asca runacuna criyiyashganta ricarmi fariseo runacuna niyargan: “Cananga ¿imatatä rurashun? ¡Lapan runacunami payman criyiycäyan!” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua captinmi may-say nacioncunapitapis Jerusalenman aywayargan mana Israel runacunapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paycunapita waquin runacunami Felipita ruwacuyargan: “Jesusta reguiycasiyälämay, taytay” nir. (Felipega cargan Galilea provinciacho Betsaida marcapitami.) ");
INSERT INTO qvhNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sayno manacuyaptinmi Felipe aywaycur Andresta wilargan. Nircurnami ishcan aywaycur Jesusta wilayargan mana Israel runacuna paywan tincuyta munaycäyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wilayaptinmi Jesús nergan: “Noga wanunäpä cag höra chaycämunnami. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Shumag tantyacuyay. Musyashgansinöpis trïguta murur mana pampashgaga manami winamunsu. Pampashgami isanga winamur ali wayun. Saynölami noga mana wanuptë pipis salvacongasu. Wanuptëmi isanga asca runacuna salvacuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Tayta Diosta cäsucunanpa trucan quiquin munashganno cawacuyta munagcunaga manami pipis gloriaman chäyangasu. Tayta Dios munashganno cawag cagcunami isanga gloriaman char imayyagpis cawayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mayganpis discïpulö cayta munag cäga noga cawashgäno cawasun. Imano nacarpis mana ajayaypa gatiräyämäsun. Sayno gatirämagcunataga Taytä cushishgami chasquengapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Fiyupa laquicuymi sarimash. Sayno laquish caycarpis manami Taytäta manacömansu wanuypita sapämänanpä. Sayno wanunäpämi cay pasaman shamushcä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sayno nishpanmi Tayta Diosta manacorgan: “Munayyog cashgayquita runacuna tantyacuyänanpä gam munashgayquino lapanpis cayculäsun, papá.” Sayno manacuptinmi ciëlupita Tayta Dios nimorgan: “Manacamashgayquita imaypis rurashgänölami cananpis rurashä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sayta wiyarmi saycho cag waquin runacuna: “¡Magacuymi cash!” niyargan. Waquinnami: “¡Angilmi parlamush!” niyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Saymi Jesús nergan: “Manami gamcuna niyashgayquinösu caycan. Tayta Diosmi sayno parlamush nogaman yäracayämänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Runacunata Tayta Diosninsi juzgananpä cag höra chaycämunnami. Saynömi runacunata munaynincho sararag diablupis vincish cananpä höran chämongana. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Saymi crucificamashganpita cawarircamur Israel runacunata y mana Israel runacunatapis tantyasishä nogaman yäracayämänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sayno nirmi Jesús tantyasergan crucificaypa wanusish cananpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Saymi runacuna niyargan: “Tayta Diosninsipa palabranchöga nican salvamagninsi Cristo imayyagpis cawananpä cashgantami. Sayno nicaptenga ¿imanirtä nicanqui wanunayquipä cashganta? Sayno captenga ¿rasunpacu Cristo caycanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sayno niyaptinmi Jesús nergan: “Au, Tayta Dios cachamashgan Cristumi caycä. Sayno captinpis walca junaglanami gamcunawan cashäpä. Saymi gamcunawan caycashgäyag jusayquicunata cacharir yachasishgäcunata chasquicuyänayqui. Chasquicorga wanusimaptinpis Tayta Diospa naupanman chäyanquipä. Jusayquicunata mana cacharerga manami imanöpapis paypa naupanman chäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sayno caycaptenga yachasishgäcunata chasquicuyay. Saynöpami gamcunapis Tayta Diospa wamrancuna cayanquipä.” Sayno nircurmi Jesús aywacorgan. Sayno aywacuptinnami runacuna musyayargansu maypa aywacushgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Asca milagrucunata Jesús ruraycashganta ricarpis runacuna manami criyiyargansu Tayta Dios cachamushgan Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sayno mana criyiyänanpä cashganpitami Tayta Diosninsipa profëtan Isaías unay cayno guelgargan: “Tayta Dios, wilacuyniquita wilacuptëpis runacuna manami chasquicuyansu. Milagrucunata ricarpis manami criyiyansu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mastapis paycunapä Isaías caynömi guelgargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tayta Diosmi yarpayninta upatacäsergan wilacuyninta mana tantyayänanpä. Saynömi shonguntapis chucruyäsergan payman mana yäracuyänanpä. Saymi payta chasquicuyansu jusalicuyashganpita perdonash cayänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías sayno guelgargan runacuna Jesusta mana chasquicuyänanpä cashganta musyarmi. Paytami Tayta Diosninsi ricasergan Jesucristo gloriacho munayyog caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jesucristuta waquin Israel runacuna mana chasquicuyaptinpis waquin cag Israel runacunami isanga criyiyargan Tayta Dios cachamushgan Cristo cashganta. Saynölami Israel autoridäcunapis waquenga criyiyargan Tayta Dios cachamushgan Cristo cashganta. Sayno criyiycarpis sinagogapita fariseo autoridäcuna gargunanta mansacuyashpanmi Jesusman yäracuyashganta wilacuyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tayta Diospita ali ricash cayänanpa trucanga paycunaga más munayargan runacunalapita ali ricash caytami. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Saypitana fuertipa Jesús nergan: “Nogata chasquicamag cäga cachamagnë Taytätapis chasquicuycanmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Saynöpis nogata reguimag cäga cachamagnë Taytätapis reguiycanmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Chasquicamagcuna Tayta Diosta reguir sacäpacushno mana cayänanpämi cay pasaman shamushcä. Saymi runacunapä noga acsino caycä. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","“Manami runacunata juzganäpäsu cay pasaman shamushcä, sinöga jusancunata perdonar salvanäpämi. Sayno captinpis nishgäcunata mana cäsucamagcunaga manami perdonashgasu cayanga, sinöga juicio finalcho infiernuman gaycushmi cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Manami quiquiläpa yarpayläpitasu wilacuycä, sinöga Taytä nimashgancunalatami wilacuycä. Paymi imata wilacunäpäpis tantyasimash. ");
INSERT INTO qvhNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sayno wilacuptëmi runacuna chasquicur gloriaman chäyangapä. Saymi Taytä nimashgannöla imaypis wilacuycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","5","Jesusga musyarganmi paypa munayninman lapantapis Tayta Dios churamushganta. Saynöpis musyarganmi cay pasapita taytan cagman cuticunanpä caycashganta. Saymi Pascua galaycunanpäna caycaptin discïpuluncunawan merendananpä shuntacäyargan. Saypäga Simonpa surin Judas Iscariotita Satanás maynami yarpayninman churashganna cash autoridäcunaman Jesusta entregananpä. Discïpuluncunawan Jesús merendaycashganchömi mësapita sharcurcur janan cag mödananta jorgorgan. Nircurna discïpuluncunata cuyashganta tantyasinanpä toällata seglanman watacurcur paycunapa chaquincunata maylapargan. Maylaparcurnami toällawan chaquincunata saquisipargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaquinta maylapänanpä caycaptinmi Simón Pedro nergan: “Taytay, ¿imanöpatä gamga chaquëta maylapaycamanquiman?” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sayno niptinmi Jesús nergan: “Gam manami tantyanquisu imanir maylapänäpä cashgantapis. Nircurrämi tantyanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Saymi Pedro nergan: “Imano captinpis chaquëta manami maylapämanquimansu, taytay.” Sayno niptinmi Jesús nergan: “Chaquiquita mana maylapaptëga manami discïpulö canquimansu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Niptinmi nergan: “Sayno captenga maquëtapis y umätapis maylapaycalämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Saymi Jesús nergan: “Sayrä armacushcunapaga chaquilanmi maylaypä caycan. Sayrä armacushcuna limpio cashgannömi jusalicuyashgayquipita perdonashgana car limpiuna caycäyanqui. Jucniquimi isanga jusancunata mana cacharishpan armacönino caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sayno nergan juc discïpulun payta entregananpä cashganta musyarmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Discïpuluncunapa chaquinta maylapayta ushasquirnami jorgushgan mödananta jaticurcur mësa cagman yapay jamacorgan. Nircurnami nergan: “¿Tantyayanquicu imanir chaquiquicunata maylapashgätapis? ");
INSERT INTO qvhNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","14","Yachasicog caycar chaquiquicunata maylapaycaptëga gamcunapis ricacayämashgayquinöla chaquiquicunata jucniqui jucniquipis maylapänacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ashmaynöla sayno rurashcä ricacamar gamcunapis ashmaynöla cayänayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Musyashgansinöpis ashmayga manami patronninpita más munayyogsu caycan. Saynölami cacha aywagpis cachagninpita más munayyogsu caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sayno captenga yäsishgänöla yanapänacorga cushishmi cawayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Manami lapayquipäsu sayno nicä. Noga musyämi maygayquicuna entregamänayquipä cashganta. Tayta Diospa palabranchöpis sayno cananpämi cayno guelgaraycan: ‘Nogawan micog cagmi conträ sharcush.’ Say guelgaraycashganga cumplengami. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Say guelgaraycashganno manarä päsaptinmi gamcunata wilapaycä sayno cananpä cashganta. Saymi nishgänöla päsaptin musyayanquipä Tayta Dios cachamashgan Cristo cashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cachashgäcunata chasquicogcunaga nogatami chasquicaycäyäman. Saymi nogata chasquicamag cäga Taytätapis chasquicuycäyan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sayno nircurmi Jesús fiyupa laquicushpan nergan: “Gamcunapitami jucniqui chiquimagnëcunapa maquinman entregamanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jesús sayno niptinmi discïpuluncuna jucninpis jucninpis ricapänacuyargan mayganpä nicashgantapis mana musyayashpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Saychömi Jesuspa cuyay discïpulun paypa naupancho weguraycargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Paytami Simón Pedro sëñargan mayganpä parlaycashgantapis Jesusta tapunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Saymi taporgan: “¿Maygantä entregashogniqui caycan, taytay?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sayno tapuptinmi payta Jesús nergan: “Sayga caycan tantata ushmarcasir macyashgä cagmi.” Sayno nirmi tantata ushmarcasir aptapargan Simonpa surin Judas Iscariotita. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Say tantata chasquircuptinmi payman Satanás yaycorgan. Nircurnami Jesús nergan: “Ruranayquipä cagtaga jucla ruray.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sayno niptinpis manami discïpuluncuna tantyayargansu imanir sayno nicashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gastuncunapä guellayta puriseg captinmi waquin yarpäyargan merendapä rantipacamog Jesús cachaycashganta. Waquin discïpuluncunami yarpäyargan muchogcunata yanapänanpä cachaycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tantata chasquircurnami Judas jucla aywargan yarpashganno rurananpä. Sayga cargan pasa sacaycaptinnami. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Judas yargusquiptinnami Jesús discïpuluncunata nergan: “Hörä chaycämunnami noga wanunäpä y nircur cawarimunäpäpis. Saynöpami runacuna tantyayanga noga pï cashgäta y Tayta Dios munayyog cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Cuyay wamräno cagcuna, gamcunapita aywacunäpänami caycä. Autoridäninsicunata nishgänölami gamcunatapis nicä: Nogata ashimarpis manami tariyämanquipäsu. Gamcunaga aywashgä cagman manarämi chäyanquipäräsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Aywacuptëpis jucniqui jucniqui cuyanacuyanqui noga gamcunata cuyashgänöla. Say nishgäga mushog mandamientumi gamcunapä caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nishgänöla cuyanacuyaptiquimi pï-maypis tantyayanga discïpulöcuna cayashgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sayno niptinmi Simón Pedro taporgan: “¿Maypatä aywacunquipä, taytay?” nir. Sayno tapuptin Jesús nergan: “Noga aywashgä cagmanga manarämi aywayanquipäräsu. Nircurnami isanga aywanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Saynami Pedro taporgan: “¿Imanirtä gamwan aywämansu, taytay? Gam-raycu wanunäpäpis nogaga listumi caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Saymi Jesús nergan: “¿Rasunpacu noga-raycu wanunayquipä listu caycanqui? Sayno nirpis cacash manarä cantaptinmi reguimashgayquitapis quimsa cuti ñëgamanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ama laquicuyaysu. Saypa trucanga Tayta Diosman yäracuyay. Saynöla nogamanpis yäracayämay. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taytä cashgan cagchöga ascami wayicuna caycan täyänayquipä. Saymanmi aywashä alistacamunäpä. Say wayicuna mana captenga manami: ‘Alistacog aywashä’ nëmansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Alistarcamurnami cutimushä gamcunata pushanäpä. Saynöpami noga tashgä cagcho gamcunapis täyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gamcuna musyayanquimi mayman aywanäpä cashgantapis. Saynöpis musyanquimi maygan nänipa sayman chäyänayquipä cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Sayno niptinmi Tomás nergan: “Mayman aywanayquipä cashgantapis mana musyaycarga ¿imanöpatä musyayäman maygan nänipa aywayänäpä cashgantapis, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Saymi Jesús nergan: “Nogami nänega caycä. Saynöpis nogapa wilacuynëga rasun cagmi caycan. Nogami runacunapä ali cawayta apamushcä. Saymi nogata mana chasquicamarga Taytä cashgan cagman mana pipis changapäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nogata reguimag cäga Taytätapis reguinmi. Saymi cananpitaga musyayanquina Taytä imano cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Saymi Felipe nergan: “Nogaga manarämi reguëräsu. Tayta Diosta reguiycasilämay nogapis reguinäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Saymi Jesús nergan: “Naupapitana gamcunawan caycaptëga ¿manacu cananyag reguiyämanquirä? Reguimag cäga Tayta Diostapis reguinmi. Reguiycämarga ¿imanirtä manacamanqui Tayta Diosta reguisinäpä? ");
INSERT INTO qvhNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manacu criyinqui Tayta Dios nogawan caycashganta y nogapis paywan caycashgäta? Saymi imatapis parlarga pay munashgannöla parlaycä. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tayta Dioswan noga caycashgäta y paypis nogawan caycashganta nicaptëga criyiyämänayqui. Nishgäcunata mana criyirpis milagro rurashgäcunata ricaycarga tantyacuyay rasun cagta nicashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Wanushgäpita cawarircamur Taytä cagman cuticuptëmi chasquicamagcunaga noga rurashgäno milagruta rurayangapä. Sayno milagruta rurayaptinmi más asca runacuna tantyacur nogata chasquicayämanga. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nogapa jutëcho Taytäta manacuptiquega manacushgayquita rurashämi. Sayno rurashä may-saychöpis Tayta Dios alabash cananpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nogapa jutëcho manacuptiquega imatapis rurashämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nogata cuyamarga lapan nishgäcunata cäsucuyay. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tayta Diostami manacushä Santu Espirituta gamcunaman cachamunanpä. Paynami imayyagpis gamcunawan caycanga yanapäyäshunayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tayta Diosta mana cäsucogcunaga Santu Espirituta manami chasquicuyangasu. Paycunaga manami tantyayansu Santu Espíritu cashgantapis. Gamcunami isanga nogawan purir tantyanqui Santu Espíritu cashganta. Santu Espíritu shamurnami gamcunawan imayyagpis cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","19","“Ama yarpäyaysu manana tincunansipä cashgantaga, sinöga wanushgäpita cawarircamuptë yapaymi tincushunpä. Tayta Diosta mana cäsucogcunaga mananami ricayämanganasu. Noga wanurpis cawarimushgänölami gamcunapis cawariyämunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Say hörami tantyayanquipä Tayta Dioswan caycashgäta y gamcunawan caycashgätapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Nishgäcunata cäsucog cäga rasunpaypami cuyaman. Paytaga Taytäpis y nogapis cuyashämi. Saynöpis tantyasishämi imaypis paywan caycashgäta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sayno niptinmi Santiagupa surin cag Judas taporgan: “Nogacunawan canayquipä caycaptenga ¿imanirtä waquin runacunawanpis canquipäsu?” ");
INSERT INTO qvhNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Saymi Jesús nergan: “Pipis cuyamarga nishgäcunata cäsucamanmi. Cuyamar cäsucamagcunatami Taytäwan noga cuyashä. Saymi cawarircamur paycunawan imayyagpis cashä. Saynölami Taytäpis paycunawan cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nogata mana cuyamag cäga manami nishgäcunata cäsucunsu. Y noga nishgäcunaga manami quiquëpa yarpayläpitasu caycan, sinöga cachamagnë Taytäpitami. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Lapan caycunata nicä gamcunawan caycashgäyagmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aywacuptënami Tayta Dios nogapa trucä gamcunaman Santu Espirituta cachamonga. Paymi lapan yachasishgäcunata yarpäsiyäshunquipä y tantyasiyäshunquipäpis. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Gamcunapita aywacuptë ama laquicuyaysu ni mansacäyaysu. Aywacurpis yanapaycäshayquimi ima päsashuptiquipis tranquïlo cawayänayquipä. Noga yanapashgänöga manami pipis yanapäyäshunquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gamcunata nishcänami aywacurpis cutimunäpä cashganta. Lapanpäpis munayyog Taytä cagman aywacuptë ama laquicunquisu. Rasunpaypa cuyamarga laquicuyänayquipa trucanga cushicuyay. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Gamcunata sayno wilapaycä manarä aywacurmi. Aywacuptënami musyayanquipä nishgäcuna rasunpaypa cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Satanás yarpäsishganta rurar prësu sarimänanpä cag runacuna shayämonganami. Saymi gamcunawan parlanäpä tiempo canganasu. Satanasga imata ruramänanpäpis manami munayyogsu caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sayno caycaptinpis Taytäta cuyar cäsucushgäta lapan runacuna musyayänanpämi pay nimashgannöla lapantapis cumplishä. Acu, caypita aywacushunna.” ");
INSERT INTO qvhNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Saypitanami Jesús nergan: “Nogaga caycä üvapa guerunnömi. Taytänami caycan üva uryagno. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nogaman yäracamagcuna üvapa rämancunanömi caycäyan. Saymi maygan rämapis mana wayuptenga Taytä muturiycun. Wayog cagtami isanga Taytä shumag rämapan más wayunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Üvata rämapaptin limpio cashgannömi gamcunapis nishgäcunata chasquicur jusayquicunapita limpiuna caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","“Ima rämapis gueruncho mana carga manami wayunsu. Saynölami gamcunapis nogaman mana yäracayämaptiquega Tayta Diosninsi yanapäyäshunquipäsu pay munashganno cawayänayquipä. Sayno caycaptenga nogaman yäracayämashpayqui imaypis cawayay. Sayno yäracayämaptiquega gamcunawanmi imaypis caycäshäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Noga caycä üvapa guerunnömi. Gamcunanami rämäcunano caycäyanqui. Saymi cäsucayämarga üva ali wayushganno gamcunapis alita rurar cawayanquipä. Mana cäsucamarga manami imanöpapis Tayta Dios munashganno cawayanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pipis mana cäsucamag cäga guerunpita mutush rämanömi canga. Saynöpis say mutush rämata shuntarcur rupasish cashgannömi rupasish cangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Nogapa munaynëcho cawayashpayqui yachasishgäcunata imaypis cumpliyaptiquega Tayta Diosninsi imata manacuyashgayquitapis wiyayäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Noga munashgäno cawashpayquimi rasunpaypa discïpulöcuna caycäyanqui. Sayno cawayaptiquimi runacuna tantyacuyashpan Tayta Diosta chasquicuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Taytä cuyamashgannömi nogapis gamcunata cuyä. Sayno cuyaycaptëga imaypis cäsucamar cawayay. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nishgäcunata cäsucayämaptiquega imaypis cuyashayquimi. Saynölami nimashgancunata cäsucuptë nogatapis Taytä cuyaman. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gamcunata sayno nicä noga cushish cawashgäno gamcunapis cushish cawayänayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Nishgäcunata cäsucayämashpayquega jucniqui jucniquipis cuyanacuyay gamcunata noga cuyashgäno. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cuyashgansi runataga ima päsaptinpis wanuy cawaymi yanapansi. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lapan nishgäcunata cäsucayämaptiquega gamcunatapis wanuy cawaymi yanapäshayqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ashmaytaga manami patronnin wilapansu imata yarpashgantapis. Gamcunata cuyarmi Taytä nimashgancunata lapanta wilapashcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Manami acrayämashgayquipitasu cuyä, sinöga gamcunata noga acrashgäpitami. Saymi gamcunata cachaycä Tayta Diosninsipa wilacuyninta wilacuptiqui runacuna salvacionta tariyänanpä. Wilacuyaptiqui yanapäyäshunayquipäga nogapa jutëcho Taytäta manacuyanqui. Manacuyaptiquega yanapäyäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sayno caycaptenga jucniqui jucniquipis cuyanacur cawayay. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Runacuna chiquiyäshuptiquega ama laquicuyaysu. Nogata chiquiyämashgannölami gamcunatapis chiquiyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Paycunano jusalicur cawayaptiquimi isanga cuyayäshunquiman. Chiquiyäshuptiquipis Tayta Dios munashganno cawayänayquipämi gamcunata acrashcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“ ‘Ashmayga manami patronninpita más munayyogsu’ nishgänölami cananpis gamcunata në: Patronta chiqueg cäga ashmaynincunatapis chiquinmi. Saynölami nogata chiquimag cäga gamcunatapis chiquiyäshunquipä, y nogata chasquicamag cäga gamcunatapis chasquicuyäshunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Runacuna chiquiyäshunquipä discïpulöcuna cayashgayquipitami. Paycunaga cachamagnë Taytä nishgancunata manami cäsucuyansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","24","“Tayta Diosninsipa wilacuyninta wilacur y pipis mana rurashgan milagrucunata rurarmi runacunata tantyasishcä pay cachamashganta. Sayno tantyaycäsiptëpis runacunaga chiquimarmi jusayog caycäyan. Mayganpis nogata chiquimag cäga Taytätapis chiquiycanmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tayta Diosninsipa palabranchöpis caynömi nican: ‘Jusaynag caycaptëpis runacuna chiquiyämashmi.’ Say guelgarashgannölami lapanpis cumplicaycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Gamcunamanmi Taytä cagpita Santu Espirituta cachamushä imaypis yanapäyäshunayquipä. Saynöpis paymi nogapita tantyasiyäshunqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gamcunapis nogawan imaypis purish caycarga nogapita runacunata tantyasiyay. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Say lapanta gamcunata nicä runacuna chiquiyäshuptiquipis nogaman imaypis yäracayämänayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chiquiyäshushpayquimi sinagogapitapis garguyäshunquipä. Saynöpis Tayta Dios munashganta ruraycashganta yarparmi wanusiyäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sayno rurayäshunquipä nogata ni Taytätapis mana chasquicayämarmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sayno päsayäshuptiqui yarpäyay nishgänöla lapanpis cumpliycashganta. Naupataga gamcunata manami wilargäräsu sayno päsayäshunayquipä cashganta. Aywacunäpä carnami chiquish cayänayquipä cashganta wilaycä. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","“Cananga Taytä cagman cuticunäpänami caycä. Sayno captinpis: ‘¿Maypatä aywanqui?’ nir tapumänayquipa trucanga ¿imanirtä laquish caycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama laquicuyaysu. Aywacurpis Santu Espiritutami cachamushä gamcunawan cananpä. Mana aywacuptëga manami Santu Espíritu shamongasu. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pay shamurnami runacunata tantyasenga jusayog cayashganta, Tayta Diosta mana cäsucog cayashganta y jusalicushganpita juzgash cayänanpä cayashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jusayog cayashgantaga Santu Espíritu tantyasenga nogata mana chasquicayämaptinmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tayta Diosta mana cäsucog cashgantaga Santu Espíritu tantyasenga Taytä cagman cuticuptënami. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Runacunata Tayta Dios juzgananpä cashganta Santu Espíritu tantyasenga Satanás vincishgana captinmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ascarämi caycan gamcunata yachasinäpä. Sayno captinpis manami lapantaga yachasishayquiräsu. Lapanta yachasiptëga manami yarpäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Santu Espíritu shamurnami mana yachasishgä cagcunata tantyasiyäshunquipä. Saynölami tantyasiyäshunquipä ima päsananpä cagcunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Santu Espíritu nogapita sayno tantyasiyäshunquipä noga alabash canäta munarmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Taytäpa maquincho cagcunaga maquëchömi caycäyan. Sayno captinmi nishcä Santu Espíritu nogapita tantyasishunayquipä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Más rätutaga nogata manami ricayämanquipänasu. Saypita waraynincunaga yapaymi gamcuna ricayämanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sayno niptin discïpuluncuna jucninpis jucninpis niyargan: “Sayno nishpan ¿imatarä nicämansi? ¿Imanirrä nimansi: ‘Más rätutaga manami ricamanquipänasu’? Y nircorga ¿imanirrä nican: ‘Saypita waraynincunaga yapaymi ricayämanquipä’? Saynöpis ¿imanirrä: ‘Taytä cagman aywacushämi’ nicämansi? ");
INSERT INTO qvhNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imaypitarä payta ricashunsu? Manami tantyansisu imapita parlaycashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Discïpuluncuna sayno yarpachacuyashganta musyarmi Jesús nergan: “¿‘Más rätutaga manami ricayämanquipänasu’ y ‘Saypita waraynincunaga yapaymi ricayämanquipä’ nishgäpitacu gamcuna yarpachacuycäyanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aywacuptë waquin cushicuptinpis gamcunaga laquicuyashpayqui wagayanquipämi. Sayno laquicurpis nircorga cushicuyanquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Musyansimi wachay nanay sariptin warmicuna laquicuyashganta. Yuripacurirnami isanga cushicur manana yarpäyannasu nanaywan nacashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Saynölami gamcuna canan laquicurpis yapay tincushga cushicuyanquipä. Say cushicuyashgayquitaga ima päsashuptiquipis manami gongäyanquipäsu. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yapay tincushgaga mananami tapuyämanquipänasu imanir sayno parlashgätapis. “Shumag tantyacuyay. Nogapa jutëcho manacuyaptiquega Taytä wiyashunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Naupataga Taytäta manacurpis manami jutëchösu manacuyashcanqui. Cananpitaga nogapa jutëcho Taytäta imatapis manacuyay. Manacuyaptiquega manacuyashgayquita wiyashunquipämi. Manacuyashgayquita wiyaptinmi cushicuyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gamcunata cananyag imamanpis tincusiypa yachasiptë manami shumag tantyayämashcanquisu. Nircurmi isanga gamcunata yachasishayqui imamanpis mana tincusiylapana. Sayno yachasiptëmi isanga lapan nishgäcunatapis tantyayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yachasishgäcunata tantyacurnami nogapa jutëchöna Tayta Diosta manacuyanquipä. Saymi shuyarangasu nogarä gamcunapä manacunäta, sinöga gamcuna manacuyashgayquitapis wiyashunquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tayta Diosninsega gamcunata cuyayäshunquimi. Sayno cuyayäshunqui paypita shamushgäta criyir cuyayämaptiquimi. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taytäpa naupanpitami cay pasaman noga shamushcä. Saynölami Taytäpa naupanman cuticushäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sayno niptinmi discïpuluncuna niyargan: “¡Cananmi isanga niyämashgayquicunata tantyayä! Mananami tumasipaylapanasu parlapaycäyämanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Saynöpami musyayä gam lapanta musyashgayquita. Tantyasiyämänayquipä mana manacuyaptëpis tantyaycäsiyämanquimi. Saymi Tayta Diospa naupanpita shamushgayquita criyiyä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Saymi Jesús nergan: “¿Rasunpacu criyiycäyämanqui? ");
INSERT INTO qvhNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cananga höra chämushganami japaläta cachariycamar wacpa caypa aywacuyänayquipä. Sayno cachariyämaptiquipis manami japaläsu caycäshä, sinöga Taytäwanmi cashäpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Gamcunata sayno nicä runacuna chiquiyäshuptiquipis mana ajayaypa imaypis yäracayämänayquipämi. Cay pasacho cayashgayquiyäga nacayanquirämi. Nogapis nacar gamcuna-raycu wanurmi Satanasta vincishäpä. Sayno captenga cay pasacho nacarpis ama laquicuyaysu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Saypitanami junagpa nuquircur Tayta Diosta Jesús manacorgan: “Wanunäpä cag hörä chaycämunnami, papá. Wanuptëpis cawariycasilämay munayyog cashgayquita runacuna tantyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gammi lapan runacunapäpis munayyog canäpä churamashcanqui. Saynöpis churamashcanqui acrashgayqui cagcunata perdonar salvanäpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Salvashgana car gloriaman charmi reguishushpayqui gam japalayqui Dios cashgayquita musyayangapä, papá. Saynölami naupayquicho caycagta ricamashpan cay pasaman cachamashgayquitapis musyayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Lapan shongöwanmi nimashgayquicunata cay pasacho cumplishcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cay pasata manarä camar naupayquicho munayyog cashgäno cananpis munayyog canäpä pushacalämayna, papá. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Saynölami discïpulöcunapäpis gamta manacamö, papá. Paycunataga acrashcanqui maquëcho cawayänanpämi. Saymi paycunaga wilacuyniquita yachasiptë chasquicuyash. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Sayno chasquicurmi cananga musyayanna lapan yachasishgäcuna gam munashgayquinöla cashganta. Saynöpis yachasishgäta chasquicurmi tantyayash gam cachamashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Discïpulöcunapä manacamur manami lapan runacunapäsu manacamö, sinöga maquëman churamushgayqui cagcunalapämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nogapa maquëcho carga gampa maquiquichöpis caycanmi, papá. Paycunaga tantyacuyashmi gam cachamashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nogaga gampa naupayquimanna shacamur manami cay pasacho cashäpänasu. Paycunami isanga cay pasacho caycangarä. Saymi paycunapä gamta manacamö imaypis yachasishgänöla cawayänanpä. Saynöpami nogansi say yarpayla cashgansino paycunapis cuyanacur say yarpayla cayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cay pasacho cashpä maquëman churamushgayqui cagcunataga lapantami shumag ricashcä. Sayno ricaptëmi mayganpis nogaman yäracamashganpita witicushgasu. Jucmi isanga Satanás munashganta rurar witicush. Pay witicunanpäga palabrayquicho maynami guelgaraycash. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gampa naupayquiman cutimunäpä captinmi cushish caycä, papá. Saymi discïpulöcunapä gamta manacamö noga cushish cashgäno paycunapis cushish cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gampa wilacuyniquita paycunata maynami wilapashcä. Sayta cäsucur manami waquin runacunanönasu cawaycäyan, sinöga noga cawashgänönami cawaycäyan. Sayno cawayaptinmi runacuna paycunata chiquiyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Runacuna chiquiyaptinpis manami cay pasapita jucla pushacunayquipäsu gamta manacamö, sinöga cay pasacho cayashganyag Satanaspita sapaycunayquipämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Imano captinpis naupayquicho cawanäpä cashgannömi paycunapis naupayquicho cawayänanpä caycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Wilacuyniquita wilapashgäta paycunata shumag yarpaycasilay, papá. Wilacuyniquita yarpäyashpanmi gam munashgayquino shumag cawayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wilacunäpä cachamashgayquinölami paycunatapis noga cachaycä ali wilacuyniquita wilacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Munashgayquino paycuna cawayänanpämi nogapis wilacuyniqui nishgannöla cawaycä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manami paycunalapäsu gamta manacamö, sinöga paycuna wilacuyashganta chasquicogcunapäpis manacamömi. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nogansi juc yarpayla cashgansino paycunapis juc yarpayla cayänanpämi gamta manacamö, papá. Sayno cawayashganta ricacurmi cachamashgayquita tantyar waquin runacunapis chasquicayämangapä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nogansi cuyanacur cawashgansino paycunapis cuyanacur cawayänanpämi wilacuyniquita yachasishcä. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Cuyanacur cawayänanpämi paycunawan imaypis caycäshä. Saynölami gampis nogawan caycanqui. Cuyanacur cawayashganta ricarmi cachamashgayquita tantyashpan waquin runacunapis chasquicayämangapä. Saynöpis tantyayanga nogata cuyamashgayquino paycunatapis cuyashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Lapan acrashgayqui cagcuna gloriacho nogawan canantami munä. Gloriacho carnami ricayämanga segaypa chipipiycar munayyog cashgäta. Saynömi cargä cay pasata manarä camashgapis. Sayno munayyog caycagta ricayämänantami munä, papá. ");
INSERT INTO qvhNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","26","“Gam imata munashgayquitapis runacuna manami tantyayansu. Nogami isanga tantyä, gampa naupayquipita shamush car. Chasquicamagcunapis munashgayquita tantyananpämi paycunata yachasishcä. Wanushgäpita cawarircamur mastapis munashgayquita yachasishärämi. Saynöpami cuyanacushgansino paycunapis cuyanacur cawayangapä. Saycunatami gamta manacamö, papá.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tayta Diosta Jesús manacuyta ushasquirmi discïpuluncunawan simpäyargan Cedrón nishgan ragrata. Simpärirnami chäyargan Olivos jachacuna cashgan chacraman. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Discïpuluncunawan Jesús cadala sayman aywash captinmi Jesusta entregag cag Judas Iscariote musyargan sayman aywayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Saymi Jesuspa contran cag runacunata pushacurcur Judas sayman aywargan Jesusta entregananpä. Say runacunaga cayargan mandag cüracunawan fariseo runacuna cachayashgan wardiacuna y asca soldäducunami. Paycunami aywayargan acsincunawan y espädancunawanpis. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Prësu sarinanpä shamushganta musyaycarpis Jesús aywargan say runacunawan tincunanpä. Tincurmi taporgan: “¿Pitatä gamcuna ashiycäyanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Saymi niyargan: “Nazaret marcapita cag Jesustami ashiycäyä.” Saymi Jesús nergan: “Nogami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús: “Nogami caycä” niptinmi lapan runacuna mansacaywan ancalaypa tuniyargan. Judas Iscariotipis paycunawanmi caycargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús yapay taporgan: “¿Pitatä ashiycäyanqui?” nir. Niptinmi yapay niyargan: “Nazaret marcapita cag Jesustami ashiycäyä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Saymi Jesús nergan: “Maynami nishcä noga cashgäta. Nogata ashimarga nogalata prësu apayämay. Discïpulöcunataga ama sariyaysu.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sayno päsananpämi discïpuluncunapä mayna nergan: “Discïpulöcunataga shumagmi ricashcä nogaman yäracamashganpita mayganpis mana witicuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saymi Simón Pedro espädanta jorgurir juc runapa derëcha cag rinrinta waluriycorgan. Say runa cargan más mandag cürapa ashmayninmi. Paypa jutinmi cargan Malco. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sayno ruraptinmi Pedruta Jesús nergan: “¡Espädayquita cutisiy churaräcunanman! Wanunäta Taytä munaptenga listumi caycä wanunäpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nircurnami Jesusta liyarcur lapan soldäducuna mandagninwan y wardiacunapis payta apayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nircurnami chäsiyargan Anaspa wayinman. Anasga cargan Caifaspa suedrunmi. Caifasga cargan más mandag cürami. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Autoridä mayincunata Caifasga maynami nergan: “Say runala wanusun lapansi salvacunansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedruwan jucag discïpulunmi Jesusta gatiräyargan caru guepalanta. Jucag discïpulunmi más mandag cürawan reguinacuyash car sawan rurinman yaycorgan Jesuspa guepanta. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroga quëdacuycorgan punculachömi. Saymi puncucho cuidag warmita más mandag cürawan reguinacog discïpuloga ruwacorgan Pedrutapis ruriman yaycasinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Saymi puncucho cuidag warmi Pedruta taporgan: “¿Manacu gampis say runapa discïpulun caycanqui?” Saymi Pedro nergan: “Manami nogaga paypa discïpulunsu cä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Saypitanami fiyupa alaptin ninata sarircasir mashacuycäyargan ashmaycuna y templo täpag wardiacunapis. Saychömi Pedrupis paycunawan mashacuycargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Saypitanami Jesusta Anás taporgan discïpuluncuna pï cashganta y imata yachasishgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","Saymi Jesús nergan: “¿Imanirtä sayno tapumanqui? Nogaga manami imatapis pacaylapaga yachasishcäsu. Sinagogacunacho y templuchöpis yachasiptë lapan runacunami wiyamash. Yachasishgäta wiyamag runacunata tapumuy. Paycunami musyayan imata yachasishgätapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sayno niptinmi juc wardia Jesusta lagyaycorgan: “¿Imanirtä más mandag cürata sayno ninqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sayno niptinmi Jesús nergan: “¿Imatatä mana alita parlashcä? Mana alita parlash captëga mä tantyasimay. Lutanta mana parlaycaptëga ¿imanirtä lagyamanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nircurnami liyashlata Jesusta Anás apasergan más mandag cüra Caifás cagman. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sayyagmi Simón Pedro mashacuycargan waquin runacuna mashacuycäyashgan cagcho. Saycho mashacuycaptinmi niyargan: “¿Gampis manacu say runapa discïpulun canqui?” Saymi Pedro nergan: “Nogaga manami paypa discïpulunsu cä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Maylantanami más mandag cürapa ashmayninpis nergan: “Gamta paywan caycagtami ricashcä olivos jachacuna cashgan chacracho.” (Sayno neg runapa castanpa rinrintami Pedro walurish cash.) ");
INSERT INTO qvhNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Saymi Pedro yapay nergan: “Manami paypa discïpulunsu cä.” Sayno nicaptinmi cacash cantarcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pasa manarä waraptinmi Caifaspa wayinpita Jesusta apayargan Pilätupa despächunman. Payga Roma autoridämi cargan. Israel autoridäcunami isanga sayman yaycuyargansu: “Roma runapa wayinman yaycorga leyninsi nishganno Pascua micuycunata manami micushunpänasu” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Saymi despächunpita yargurir Pilato taporgan: “¿Ima jusatatä cay runa rurash cayman apayämunayquipäga?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Sayno tapuptinmi niyargan: “Jusayog captinmi cayman apayämushcä. Jusan mana captenga manami apayämömansu cargan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Saymi Pilato nergan: “Noga juzganäta munarga wilayämay ima jusan cashgantapis. Sinöga, payta apacuyay leyniquicuna guelgarashganno quiquiquicuna juzgayänayquipä.” Sayno niptinmi Israel runacunapa autoridänincuna niyargan: “Musyashgayquinöpis nogacunaga manami munayyogsu cayä pitapis wanusiyänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sayno nirmi Pilätuta manacuyargan Jesusta cruzcho wanusiyänanpä. Cruzcho wanusiyaptinmi cumplergan Jesús crucificash cananpä nishganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Despächunman Pilato yaycurirmi Jesusta gayaycur taporgan: “¿Rasunpacu gamga canqui Israel runacunapa mandagnin rey?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Saymi Jesús nergan: “¿Musyayta munarcu sayno tapumanqui, o Israel autoridäcuna nishuptiquicu sayno tapumanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Sayno niptin Pilato nergan: “Nogaga manami Israel runasu cä saycunata musyaycänäpäga. Marca mayiquicunawan mandag cüracunami prësu apamushushcanqui. ¿Imatatä rurashcanqui prësu apayämushunayquipä?” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Saymi Jesús nergan: “Nogaga manami cay pasacho mandagsu cä. Cay pasacho mandag captëga nogaman yäracamagcuna pelyanmanmi cargan autoridäcuna prësu mana sariyämänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sayno niptin Pilato taporgan: “¿Sayno captenga rasunpacu Israel runacunapa mandagnin rey caycanqui?” Saymi Jesús nergan: “Au, gam nishgayquinölami mandag rey caycä. Mandag rey canäpämi cay pasacho yurishcä. Saynöpis cay pasaman shamushcä Tayta Diosninsipa wilacuyninta wilacunäpämi. Tayta Diosninsipa wilacuyninta chasquicogcunaga nishgäcunata chasquicuyanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sayno niptin Pilato nergan: “¿Cansuräpis manasurä Diospa wilacuynenga?” Jesusta tapurcushpan despächunpita Pilato yapay yargurir Israel runacunapa autoridänincunata nergan: “Noga manami tarësu cay runapa ima jusantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gamcunaga musyayanquimi Pascuacho juc prësuta cacharinäpä cashganta. ¿Munayanquicu Israel runacunapa mandagnin rey Jesusta cacharinäta?” ");
INSERT INTO qvhNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sayno niptin niyargan: “¡Barrabasta cachariyga! ¡Jesustaga ama cachariysu!” Barrabasga cargan Romacho mandag emperadorpa contranmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mana cacharinanpä niyaptinmi Pilato astasergan Jesusta. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldäducunami cashapita corönata rurarcur Jesuspa umanman jatipäyargan. Saynöpis puca-chiclu cäpata aylupäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nircurnami Jesusta lagyayashpan niyargan: “¡Alabash casun Israel runacunapa mandagnin rey!” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Despächunpita Pilato yapay yargurcur nergan: “Yapaymi say runata jorgamushä jusaynag cashganta tantyayänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sayno nirmi Jesusta jorgamorgan cashapita rurash corönan jatishta y puca-chiclu cäpan jatishta. Saymi Pilato nergan: “¡Ricayay cay runata!” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesusta ricaycurmi Israel runacunapa autoridänincunawan templo täpag wardiacunapis niyargan: “¡Crucificash casun! ¡Crucificash casun!” Sayno niyaptinmi Pilato nergan: “Crucificash cananta munarga quiquiquicuna crucificayay ima, ari. Nogaga manami ima jusantapis paypata tarësu wanusish cananpäga.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sayno niptinmi say autoridäcuna niyargan: “Cay runaga: ‘Diospa surinmi cä’ nishganpita wanusish casun. Sayno negcuna wanusish cayänanpämi leynëcunacho nican.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","“Diospa surinmi cä” nishganta wilayaptinmi Pilato fiyupa mansarergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Saymi despächunman cutiycur Jesusta yapay taporgan: “¿Gam maypitatä caycanqui?” nir. Sayno tapuptin Jesús manami imatapis parlacorgansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Saymi Pilato nergan: “Tapuycaptëga ¿manacu imatapis contestamanqui? Crucificasinäpä o cacharinäpäpis munayyog cashgäta ¿gam manacu musyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sayno niptin Jesús nergan: “Gampa maquiquiman Tayta Dios mana churamaptenga manami ima munayniquipis canmansu crucificasimänayquipä ni cacharimänayquipäpis. Saymi gampita más jusayog caycan maquiquiman entregamag cag runa.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sayno niptinmi Pilätoga cachariyta munargan. Cachariyta munaptinmi Israel runacunapa autoridänincuna masrä gaparäyargan: “¡Mandag-tucurmi Jesusga emperador Cesarpa contran caycan! ¡Saymi Jesusta cacharerga gampis emperador Cesarpa contran canquipä!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sayno niyaptinmi Pilato jorgasimorgan Jesusta. Nircurnami “Gábata” nishgan alarman aywaycur mandacunan sillëtaman jamacorgan. (Hebreo idiömachöga Gábata nishganga “Läja rumicunawan rurash” ninanmi.) ");
INSERT INTO qvhNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Saypitami Israel runacunapa autoridänincunata nergan: “¡Mandagniqui reyta ricayay!” (Saycuna päsayargan viernes pulan junagmi. Say tardi sábado jamay junag galaycorgan.) ");
INSERT INTO qvhNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Saymi runacuna fuertipa niyargan: “¡Wanusish casun! ¡Wanusish casun! ¡Crucificasiy!” nir. Saymi Pilato nergan: “¿Mandagniquita crucificasinätacu munayanqui?” Saymi cürapa mandagnincuna niyargan: “¡Nogacunapa mandagnëga emperador Cesarlami! ¡Paypita juc mandagnëga manami pipis cansu!” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sayno niyaptinmi Jesusta Pilato entregaycorgan crucificayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Saymi Jesusta apayargan cruzta umrurcasir “Calavëra” nishgan jircaman. (Hebreo idiömachöga Gólgota niyanmi say jircata.) ");
INSERT INTO qvhNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Sayman chaycasirnami Jesusta crucificayargan. Saynömi ishcay runacunatapis crucificayargan Jesuspa ishcan lädunman. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Saypitanami Pilato clävasergan cruzpa puntanman juc letrëruta. Say letrëruchömi cayno guelgarargan: “Nazaretpita cag Jesús, Israel runacunapa mandagnin reymi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jerusalenpa cercalancho crucificash captinmi Israel runacuna ascag liyiyargan say letrërucho guelgaraycagta. Say letrëroga guelgarargan hebreo, latín y griego idiömacunachömi. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Saymi mandag cüracuna Pilätuta niyargan: “ ‘Israel runacunapa mandagnin reymi’ nerga ama guelgaräsunsu, sinöga: ‘Israel runacunapa mandagnin rey-tucogmi’ nir guelgaräsonga.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sayno niptin Pilato nergan: “Guelgashgäga guelgashganami caycan.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesusta crucificasquirnami paypa mödananta saycho cag chuscu soldäducuna aypunacuyargan. Rurincho cag jatirashgan mödanata aypunacuyänanpämi isanga, costüraynag captin, niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Saytaga ama rachishunsu, sinöga suertitarä jitashun maygansipis apacunansipä.” Saynöpami cumplergan Tayta Diospa palabrancho Jesuspä cayno guelgarashgan: “Suertitami jitayash mayganpis mödanäta apacunanpä.” Say nishgannölami soldäducuna rurayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Crucificaraycashgan cagchömi caycargan Jesuspa maman, mamanpa nanan, Cleofaspa warmin María y María Magdalenapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Saymi mamanta y cuyashgan discïpulunta ricärishpan Jesús nergan: “Mamay, nogapa trucä Juannami wawayqui canga.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nircurnami cuyashgan discïpuluntapis nergan: “Cananga mamäta ricayculanqui mamayquitano.” Jesús sayno niptinmi say junagpitana mamanta pushacorgan wayinman. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wanunanpä carnami Tayta Diosninsipa palabrancho guelgaraycashgan cumplinanpä Jesús nergan: “Yacunaycämi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Saychömi soldäducuna upuyänanpä cag pochgog vïnu caycargan wichi junta. Saymi gueru puntanman esponjata watarcur say pochgog vïnuman ushmarcasir Jesusta shogusiyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Say vïnuta yawarcurnami Jesús nergan: “Lapantanami cumplishcä.” Sayno nisquirnami päsarporgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascuacho sábado jamay junag galaycunanpäna caycaptinmi Israel runacunapa autoridänincuna munayargansu pipis crucificaraycar quëdayänanta. Saymi Pilätuta manacuyargan cruzcho wanuyta nacaycagcunapa chancancunata paquircur cruzpita jorgunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Saymi soldäducuna aywaycushpan Jesuspa naupancho crucificaraycag runacunapa chancancunata paquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesuspa chancancunatami isanga manana paquergannasu, wanushgana caycagta tariycur. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wanushgana caycaptinpis llapsha pachanpa Jesusta tucsergan juc soldädo. Sayno tucsiptinmi yargamorgan yawarwan yacu. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jesuspa discïpulun carmi lapan saycunata ricargä. Saymi imano cashgantapis guelgaycä salvamagninsi Cristo cashganta gamcunapis criyiyänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lapan saycuna päsargan: “Manami ni juc tululanpis paquishgasu canga” nir Tayta Diosninsipa palabrancho guelgaraycashgan cumplinanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“Runacuna ricayangami tucsishganta” nir guelgaraycashganpis cumplerganmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Saypitami Arimatea marcapita José jutiyog runa Pilätuta manacorgan: “Jesuspa ayanta cachapaycalämay pampag apanäpä” nir. Israel autoridäcunata mansacushpanmi payga Jesusman yäracushganta wilacorgansu. Manacushganta Pilato auniptinmi Jesuspa ayanta apargan pampananpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Saynömi Nicodemupis paywan aywargan quimsa arröba mïrra y aloe nishganta apacurcur. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Israel runacunapa costumbrin cashgannömi say apashganta Josëwan Nicodemo säbanasman winayargan. Winarcurnami Jesuspa ayanta pituyargan pampayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta crucificayashgan naupanchömi cargan frütacuna plantarashgan juc huerta. Saychömi cargan pitapis manarä pampayashgan mushog sepultüra. ");
INSERT INTO qvhNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sábado jamay junag galaycunanpäna captinmi say sepultüralamanna Jesusta pampayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo tutami María Magdalena saca sacala aywargan Jesús pamparaycashgan cagman. Sayman charmi tarergan sepultüra saparag rumi witisish caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sayta ricaycurmi cörrila cutergan Jesús cuyashgan discïpulunta y Simón Pedruta wilananpä. Chaycurnami paycunata wilargan: “¡Jesuspa ayantami apacuyash! ¡Manami musyayäsu maypa apacuyashgantapis!” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Sayno wilaptinmi Pedruwan Jesús cuyashgan discïpulun cörrila aywayargan Jesusta pampayashgan cagman. Pedruta yalirirmi puntata jucag discípulu chargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Saychönami punculapita watgaycur ricargan säbanaslana jitaraycagta. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Simón Pedrumi isanga ruriman yaycorgan. Saychömi paypis säbanaslata tarergan. Jesuspa umanta watapashgan träputapis juclächo churaraycagtami tarergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Saypitarämi jucag discïpulunpis ruriman yaycur Jesús cawarimushganta criyergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sayno caycaptinpis manami tantyayarganräsu Tayta Diospa palabrancho cawarimunanpä guelgaraycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Saypitanami discïpuluncuna cuticuyargan posädaräyashgan wayiman. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Marianami isanga pamparashgan cagman cutiycur wagar puncucho quëdacorgan. Wagaycashgancho ruriman watgaycurmi ricargan ishcay angilcuna yurag mödanash caycagta. Jucag jamaraycargan Jesuspa uman cashgan cagcho y jucagnami jamaraycargan chaquin cashgan cagcho. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Say angilcunami Mariata tapuyargan: “¿Imanirtä wagaycanqui?” nir. Sayno tapuyaptin nergan: “Jesuspa ayantami apacuyash, taytay. Manami musyäsu maypa apacuyashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sayno nir ticraycushganchömi Jesusta ricargan. Isanga manami tantyargansu pay cashgantaga. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Saymi Jesús taporgan: “¿Imanirtä wagaycanqui? ¿Pitatä ashiycanqui?” nir. Sayno tapuptinmi huertacho arog runa cashganta yarpar María nergan: “Maymanpis Jesuspa ayanta apash carga shuntacamunäpä wilaycalämay, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Saymi Jesús nergan: “¡María!” Mariata jutinpa gayaptinmi tantyargan Jesús cashganta. Saymi “¡Raboni!” nergan. Raboni ninanga yachasicog ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nircurmi Jesús nergan: “Ama sarimaysu. Manarämi Taytä cagman cutishcäräsu. Saypa trucanga ayway wilamuy discïpulöcunata Taytäman cuticunäpä cashganta. Paycunaga wauguëcunami caycäyan. Nogapa Taytäga gamcunapapis taytayquimi y Diosnëga gamcunapapis Diosniquimi.” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sayno niptinmi María jucla aywargan Jesús yuripashganta y nishgancunatapis wilananpä. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jesús cawarimushgan sacaymi discïpuluncuna shuntacäyargan juc wayicho. Israel runacunapa autoridänincunata mansacurmi puncuta trancacurcur caycäyargan. Saycho caycäyaptinmi elagpita paycunapa naupancho Jesús ricacorgan. Elagpita Jesús yuriparcur saludargan: “Tayta Diosninsi yanapaycuyäläshunqui ali cawayänayquipä” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Sayno nirmi maquinta y llapsha pachanta ricasergan. Saymi Jesusta ricaycur discïpuluncuna fiyupa cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Saypitana Jesús yapay nergan: “Tayta Diosninsi yanapaycuyäläshunqui ali cawayänayquipä.” Nircurna nergan: “Taytä cachamashgannölami gamcunatapis cachaycä wilacuynëta wilacuyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sayno nishpanmi discïpuluncuna cagman pücashpan nergan: “Santu Espirituta chasquiyay. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Cananpitaga nogata chasquicamagcunata tantyasinqui jusancunapita perdonashgana cayashganta y mana chasquicamagcunataga wilayanqui jusancunapita mana perdonash cayashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Discïpuluncuna juntaraycäyashgan cagman Jesús chänanpäga Milish nishgan Tomás manami saychösu cargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomaswan tincurnami waquin cag discípulu mayincuna wilayargan: “¡Señorninsi Jesustami ricayashcä!” niyashpan. Saymi Tomás nergan: “¡Quevä! Rasunpaypa cawarimushganta criyinäpäga maquinman clävo yaycushgan uchcutarämi ricäman y sayman dëdötarämi jatëman, saynöpis llapsha pachanpa tucsishgantarämi yatäman.” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Saypita juc semänata discïpuluncuna yapay shuntacäyargan juc wayiman. Saychömi isanga Tomaspis caycargan. Saycho puncuta trancacurcur caycäyaptinmi Jesús paycunapa naupancho elagpita yurircur saludargan: “¡Tayta Diosninsi yanapaycuyäläshunqui ali cawayänayquipä!” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nircurnami Tomasta nergan: “Tomás, maquëta ricay y clävo yaycushganman dëduyquita jatiy. Llapsha pachäpa tucsimashgantapis yatay. ¿Imanirtä cawarimushgäta criyinquisu?” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Sayno niptinmi Tomás nergan: “¡Gamga Diosnëmi canqui, taytay!” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusnami nergan: “¿Ricaycamarräcu criyinqui? ¡Mana ricaycämarpis cawarimushgäta criyegcunaga cushishmi cayangapä!” ");
INSERT INTO qvhNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Asca milagrucunatami Jesús rurargan discïpuluncuna ricaycaptin. Saycunaga manami lapansu cay librucho guelgaraycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Cay librucho cagcunaga guelgaraycan Jesusga salvamagninsi Cristo cashganta y Diospa surin cashganta criyiyänayquipämi. Saymi payta chasquicorga gloriacho cushishla imayyagpis cawayanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Saypitanami Tiberias nishgan gocha cuchuncho Jesús yapay discïpuluncunata yuripargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Say gocha cuchunchömi caycäyargan Simón Pedro, Milish nishgan Tomás y Natanaelpis. Natanaelga cargan Galilea provinciacho Caná marcapitami. Zebedeupa ishcan surincuna más ishcay discípulu mayincunapis saychömi caycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saymi Simón Pedro nergan: “Pescagmi aywaycä.” Sayno niptinmi discípulu mayincuna niyargan: “Nogacunatapis yanapäyänäpä pushayämay.” Sayno nirmi büquiman wisarcur lapan aywayargan. Say sacay warati pescaycarpis manami ni juc pescädulatapis sariyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pasa waraycaptinnami discïpulucuna ricayargan juc runa gocha cuchuncho caycagta. Isanga manami musyayargansu Jesús cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Paymi gayacorgan: “¿Naganacu pescäduta sariyashcanqui?” nir. Saymi discïpulucuna niyargan: “Manami ni juclaylatapis sariyäräsu, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Saymi Jesús discïpulucunata nergan: “Redniquita mashtayay büquipa derëcha cag lädunman. Saypitami pescäduta sariyämunquipä.” Nishganno redta mashtarnami sariyargan saysica pescäduta, sutaytapis mana puëdiyashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Saymi cuyashgan cag discïpulun Jesús cashganta tantyasquir Pedruta nergan: “¡Payga Jesusmi!” Sayno niptinmi jorgushgan cag mödananta jaticurcur Simón Pedro jucla Jesús cagman nadyaypa aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquin cag discïpuluncunami isanga büquiwan aywayargan. Gocha cuchunpita pachac (100) metrunöla captinmi red junta pescäduta yacu cuchunman garachayargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sayman charnami redta cachaycur büquipita yarguyargan. Saychömi tariyargan shansha janancho pescädo cancash caycagta y tantatapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Saymi Jesús nergan: “Say sariyämushgayqui pescäduta juc ishcayta apayämuy cancanansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sayno niptinmi Simón Pedro büquiman wisarcur redta garachamorgan pescäducunata shuntayänanpä. Say redchöga cargan pachac pisga chunca quimsa (153) jatusag pescäducunami. Saysica pescädo caycaptinpis red manami rachergansu. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Saymi Jesús nergan: “Micunansipä shayämuyna.” Jesús cashganta musyarmi maygan discïpulunpis tapupargansu pï cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús cashgan cagman chaptinnami tantatawan pescäduta paycunata ayporgan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Saywanga quimsa cutinami discïpuluncunata Jesús yuripargan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micuyta ushasquirnami Jesús taporgan Simón Pedruta: “Jonaspa surin Pedro, ¿lapanpitapis mascu gam cuyamanqui?” Sayno tapuptin Pedro nergan: “Au taytay, gam musyanquimi cuyashgäta.” Saymi Jesús nergan: “Sayno carga misicog runa uyshancunata ricashganno nogaman yäracamagcunata shumag ricanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús yapay taporgan Simón Pedruta: “Jonaspa surin Simón, ¿gam cuyamanquicu?” Sayno tapuptin Pedro nergan: “Au taytay, gam musyanquimi cuyashgäta.” Niptinmi nergan: “Sayno carga misicog runa uyshancunata ricashganno nogaman yäracamagcunata shumag ricanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Saypita Jesús yapay taporgan Simón Pedruta: “Jonaspa surin Simón, ¿gam rasunpacu cuyamanqui?” Quimsa cuti Jesús saynöla tapuptinmi Pedro laquish nergan: “Gam lapantapis musyanquimi, taytay. Saynöpis musyanquimi gamta cuyashgäta.” Niptinmi Jesús nergan: “Sayno carga misicog runa uyshancunata ricashganno nogaman yäracamagcunata shumag ricanqui. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Magtalarä carga quiquilayquimi mödanayquita jaticorgayqui maypapis munashgayquipa aywanayquipä. Auquinna captiquinami isanga ricrayquita mashtarcuptiqui jucna mödanayquita jatipäshunquipä. Saynöpis aywayta mana munashgayquipami apayäshunquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sayno nirmi Jesús tantyasergan payman yäracushganpita Pedro crucificaypa wanusish cananpä cashganta. Nircurnami Pedruta nergan: “Nishgäcunata imaypis cumpliy.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Saypitanami Pedro ticrarcamur Jesús cuyashgan cag discïpulunta ricargan pay cagman aywaycagta. Payta ricärirmi Jesusta taporgan: “Taytay, paytaga ¿imatä päsanga?” (Manarä Jesús wanuptinmi cuyashgan discïpulun naupalancho micorgan. Saychömi payta taporgan maygan discïpulun contran sharcunanpä cashgantapis.) ");
INSERT INTO qvhNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pedro sayno tapuptinmi Jesús nergan: “¿Imanirtä paypä tapuycämanqui? Cutimushgäyag cawanan captinpis gamga nishgäcunata lapanta cumpliy.” ");
INSERT INTO qvhNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sayno niptinmi waquin discïpulucuna yarpäyargan say cuyashgan discïpulun imaypis mana wanunanpä cashganta. Sayno yarpäyaptinpis Jesusga manami mana wanunanpä cashgantasu nergan, sinöga: “Cutimushgäyag cawanan captinpis ¿imanirtä paypä tapuycämanqui?” nergan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesuspa cuyashgan discïpulun carmi caycunata guelgashcä. Lapan guelgashgäcunaga rasun caglami caycan. ");
INSERT INTO qvhNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús rurashgancunaga cay guelgashgäcunapitapis masrämi caycan. Lapan rurashgancunata guelgarga manami imaypis ushämansu cargan. Amén.");
INSERT INTO qvhNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Jesucristo lapan rurashgancunata y yachasishgancunatami punta cag libröcho guelgamorgä. Sayta guelgamorgä ima päsashgancunatapis gam musyanayquipämi, Teófilo. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Jesús wanushganpita cawarircamurnami ciëluman manarä aywacur apostolnincunata chuscu chunca (40) junagyag asca cuti yuripargan. Rasunpaypa cawarimushganta musyayänanpämi tucuynöpa paycunata tantyasergan. Nircurmi paycunata nergan Santu Espíritu yanapaptin wilacuyninta wilacur puriyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Apostolnincunawan Jesús caycashpanmi paycunata nergan: “Jerusalenpita maypapis aywacuyanquiräsu. Saypa trucanga jinalancho shuyaräyanqui Taytä promitishgan Santu Espirituta chasquiyänayquipä. Santu Espirituta chasquiyänayquipä cashgantaga maynami nergä. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Naupataga Juan Bautista yacuwanmi runacunata bautizargan. Cananmi isanga gamcuna Santu Espirituwan bautizash cayanquipä. Sayno bautizash cayänayquipäga walca junaglanami pishiycan.” ");
INSERT INTO qvhNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesucristuwan shuntacash caycarmi apostolnincuna tapuyargan: “Taytay, ¿canansurä cay Israel nacionpita Roma runacunata gargunqui, paycunapa maquincho cayashgäpita gampa maquiquichöna cayänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sayno tapuyaptinmi Jesús nergan: “Imaypis say päsananpä cashgantaga Tayta Dioslami musyaycan. Paylami munayyog caycan saycunata rurananpäga. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sayno captinpis Santu Espíritu gamcunaman shamuptinmi poderninta chasquiyanquipä. Sayta chasquircurmi wilacuynëta wilacuyanquipä Jerusalencho, Judea provinciacho, Samaria provinciacho y may-say nacioncunachöpis.” ");
INSERT INTO qvhNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sayno parlayta ushasquiptinmi Tayta Diosninsi gloriaman Jesusta pushacorgan. Apostolnincuna ricaraycäyaptinmi pucutay rurinman yaycur elagasquergan. Saypitaga mananami ricayargannasu. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sayno ricaraycäyaptinmi elagpita ishcay runacuna yurag mödanash naupancho yuripäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Say runacunami niyargan: “Galilea runacuna, ¿imanirtä ciëlupa ricaraycäyanqui? Naupayquicunapita Jesucristo ciëluman aywacushganta ricayashgayquinölami yapay cutimongapä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sayno niptinmi Olivos lömacho caycäyashganpita Jesucristupa apostolnincuna cuticuyargan Jerusalenman. Say lömapita Jerusalenman cargan media lëwanölami. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chaycuyashpannami wisäyargan posädaräyashgan altusman. Paycunami cayargan Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeupa surin Santiago, Simón “Celote” nishgan y Santiagupa surin Judas. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Say wayichömi Tayta Diosta manacuyänanpä imaypis paycuna shuntacäyag. Paycunawanmi shuntacäyag Jesucristupa maman María, Jesucristupa wauguincuna y waquin warmicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Say junagcunami Jesucristuman yäracogcuna pachac ishcay chuncano (120) shuntacäyargan apostolcunawan. Saymi Pedro nergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","19","“Waugui-panicuna, musyashgansinöpis Judas Iscariote nogacunawanmi purergan. Paytapis apóstol cananpämi nogacunatanöla Jesús acrargan. Sayno acrash caycarpis Judasmi runacunata pushargan Jesusta prësu sariyänanpä.” (Sayno pushashganpita guellayta chasquishganwanmi chacrata rantergan. Say chacrachömi uray sengaypa jegargan pachan pashtagpä. Saypitami Jerusalencho tag runacuna say chacrapa jutinta churapäyargan ‘Acéldama’ nir. Acéldama ninanga ‘Yawar Pampa’ ninanmi.) Nircurmi Pedro mastapis nergan: “Jesucristuta entregar Judas wanunanpä cashganta musyarmi rey Davidta Santu Espíritu tantyasergan Judaspä guelgananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Say guelgashganga Salmo librucho cayno nirmi guelgaraycan: ‘Tashgan wayi cacharish casun. Ama pipis saycho täsunsu.’ Saynölami juc salmuchöpis cayno guelgaraycan: ‘Pay rurananpä cagta jucna rurasun.’ “Say salmo guelgarashgannölami Judasta päsash. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Saymi juctana churanansi paypa trucan apóstol cananpä. Say runata acrashun Jesús bautizacushganpita-pasa ciëluman cuticushganyag paywan puregta. Jesucristuwan sayno puregcunaga nogansiwanmi caycäyan. Saymi paycunapita maygantapis jucta churanansi Judaspa trucan apóstol cananpä. Paymi nogacunano apóstol car Jesús cawarimushganta wilacur purenga.” ");
INSERT INTO qvhNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro sayno niptinmi ishcay runacunapä yarpäyargan. Jucmi cargan Matías. Jucagnami cargan José. Waquin runacuna Josëta niyag Barsabás y waquinnami niyag Justo. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Paycunapita mayganpis apóstol cananpä cashganta musyayänanpämi Tayta Diosninsita manacuyargan: “Taytay, gammi musyanqui lapan runacunapa shongun imano cashgantapis. Saymi canan munayä cay ishcay runacunapita mayganta acrashgayquitapis musyasiyämänayquita. ");
INSERT INTO qvhNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mayganpis acrashgayqui cagmi apostolniqui canga Judas Iscariotipa trucan. Judasga jusalicurmi apóstol caycashganpita yargucush destïnunman aywacunanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tayta Diosta sayno manacusquiyashpanmi suertita jitayargan. Saymi suerti yargamorgan Matiaspä. Say junagpitanami Matiaspis Jesucristupa apostolninna cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jesucristo cawarimushganpita ganchis semänata Pentecostés fiesta junagmi Jesucristuman lapan yäracogcuna juc wayicho shuntacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Saycho jamaraycäyaptinmi elagpita wiyacämorgan fiyupa gaparar shucucuy vientunöpis ciëlupita shamuycashgan. Sayga chargan paycuna shuntaraycäyashgan wayimanmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Saymi say wayicho shuntaraycagcuna ricayargan mechëro sindiycagnöla ninacuna paycunaman chagta. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Say hörami Santu Espirituta lapan chasquiyargan. Santu Espíritu parlasiptinmi paycuna parlayargan imaypis mana parlayashgan idiömacunapa. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Say wisanmi may-say nacioncunapitapis Israel runacuna Jerusalenman chäyargan Pentecostés fiestapä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Saymi say wayicho shucucuy vientuno gaparashganta wiyayashpan runacuna sayman aywayargan ima päsashgantapis ricayänanpä. Saychömi lapanpis wiyayargan may-saypitapis shamog runacunapa idiömancunacho parlaycäyagta. Sayno parlaycäyashganta wiyarmi cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sayno cushicuyashpanmi niyargan: “Lapan cay parlaycagcunaga ¿manacu Galilea runacuna caycäyan? ");
INSERT INTO qvhNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Galilea runacuna caycarga ¿imanöpatä paycuna yachacuyash nogansipa idiömansicho parlayänanpä? ");
INSERT INTO qvhNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Shamushcansi Partiapita, Mediapita, Elampita, Mesopotamiapita, Judeapita, Capadociapita, Pontupita, Asiapita, ");
INSERT INTO qvhNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptupita, Libiacho cag Cirenipa cercancunapita y Romapitapis. Waquinninsega yurishgansipita-pasami Israel runacuna caycansi. Y waquinninsinami mana Israel runacuna caycarpis Diosta chasquicushcansi Israel runana canansipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretapitapis, Arabiapitapis caycho shuntacashmi caycansi. May-saypita cashgapis quiquinsipa idiömansichömi Tayta Diosninsipa wilacuyninta parlapaycämansi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Saymi fiyupa cushicur quiquinpura parlayargan: “¿Imatä päsaycan?” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sayno niyaptinmi burlacuyashpan waquin runacuna niyargan: “Caycunaga shincash carmi imata parlayashgantapis musyayansu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sayno niyaptinmi apóstol mayincunawan jamaraycashganpita ichircur Pedro nergan: “Jerusalencho y may-saychöpis tag Israel mayëcuna, shumag wiyayämay. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Manami gamcuna yarpäyashgayquinösu nogacuna shincash caycäyä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Saypa trucanga Tayta Diosninsipa profëtan Joel guelgashgannölami canan cumplicaycan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Paymi Tayta Diosninsi nishgancunata cayno guelgargan: ‘Tiempo chämuptinnami Santu Espirituta cachamushä lapan chasquicamagcunaman. Santu Espirituta chasquicurnami nogapa wilacuynëta wilacuyanga olgu suriquicuna y warmi suriquicunapis. Magtacunapis noga ricasishgäcunatami elagpita ricayangapä. Saynölami auquincunata sueñuynincunacho ima päsananpä cagcunatapis musyasishä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Say wisanmi munashgäta ruragcunaman Santu Espirituta cachamushäpä. Saynöpami warmipis olgupis wilacuynëta wilacuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ciëluchömi ricacäsimushä imaypis mana ricayashgayquita. Intimi sacacäconga. Quilami yawar-nirag ricacäconga. Cay pasachöpis runacuna segaypa wanusinacogtami ricayanquipä. May-saychöpis rupaptinmi cay pasa goshtaywan sapash caycagta ricayanquipä. Saypitarämi chämonga noga juzganä junag. Say chämushgan junagnöga manami imaypis yapay canganasu. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sayno cananpä captinpis nogata manacamag cäga salvashmi cayangapä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tayta Diosninsipa profëtan Joel sayno guelgashganta yarparcasirmi Pedro nergan: “Israel mayëcuna, cay parlamushgäcunata shumag wiyayämay. Nazaret marcapita cag Jesusga Tayta Diosninsi cachamushgan runami cargan. Sayno cashgantaga Tayta Diosninsi musyasimashcansi milagrucunata ruraptinmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sayno caycaptinpis gamcunami Jesusta prësu sarircur jusasapa runacunapa maquinman entregayashcanqui crucificaypa wanusinanpä. Sayno entregaptiquimi Tayta Diosninsi palabrancho guelgarashgancuna cumpliyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sayno wanusiptinpis manami wanushgalanchöga usharashgasu. Saypa trucanga Tayta Diosninsimi payta cawarisimush. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sayno cawarimunanpä cashganpitami rey David cayno guelgargan: ‘Imaypis nogawanmi caycanqui, Tayta Dios. Saymi imatapis mansarësu. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Shongöpis cushicunmi. Cushishlami cantashäpis. Saymi gamman yäracular cawaycä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Munashgayquita ruraptëmi almäta Hadischo cachanquipäsu. Saynöpis manami cacharinquipäsu pamparashgalächo ayä ismunanta. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gammi tantyasimashcanqui munashgayquino cawanäpä. Imaypis yanapämaptiquimi cushishla cawaycä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Sayno David guelgashganta wilapayta ushasquirmi Pedro nergan: “Israel mayëcuna, sayno guelgar unay rey David manami quiquinpäsu guelgargan, sinöga Jesucristupämi. Musyansimi David wanur maynincho pamparashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tayta Diosninsipa profëtanmi rey Davidga cargan. Paytami Tayta Diosninsi nergan castanpita juc runa yurir imayyagpis mandag rey cananpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Saymi Davidga quiquinpä guelgananpa trucan say yurinanpä cagpita guelgargan. Payga salvamagninsi Jesucristumi caycan. Jesucristo cawarimushganta ricaycagnöpis paypämi David guelgargan Hadischo almanta Tayta Dios mana cacharinanpä cashganta y cuerpun pamparashgalancho mana quëdananpä cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","David guelgashgannölami Jesucristuta Tayta Diosninsi cawarisimush. Cawarircamur puriptinmi lapä ricayashcä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cawarircasimurnami Jesusta derëcha cag lädunman Tayta Diosninsi jamasish lapanpäpis munayyog cananpä. Saypitanami Tayta Diosninsi promitishgan Santu Espirituta nogacunaman cachamush. Sayno cachamush captinmi juc idiömacunapa parlasiyämashganta canan wiyaycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Shumag tantyacuyay. Davidga manami wanushganpita cawarircamur ciëluman wisashgasu. Señorninsi Jesucristumi isanga wanushganpita cawarircamur ciëluman wisash. Ciëluman wisarcur Tayta Diospa naupanman jamacunanpä cashganpitami David cayno guelgargan: ‘Mandag reyta Tayta Diosninsi caynömi nergan: “Jamacamuy derëcha cag naupäman lapan contrayquicunata vincishgäyag.” ’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Saypita Pedro yapay nergan: “Israel mayëcuna, shumag tantyacuyay. Gamcuna Jesusta cruzcho wanusish captiquipis Tayta Diosninsimi payta churash maquincho sararämänansipä y salvamagninsi cananpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sayno niptinmi runacuna fiyupa laquicuyashpan tapuyargan Pedruta y waquin cag apostolcunatapis: “Sayno captenga ¿imatatä rurayäman?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Saynami Pedro nergan: “Tayta Diosninsi jusayquicunata perdonayäshunayquipä jusalicuyashgayquita cacharir Jesucristupa jutincho bautizacuyay. Saynöpami gamcunapis Santu Espirituta chasquicuyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Santu Espiritutaga manami nogacunalapäsu Tayta Diosninsi cachamush. Saypa trucanga cachamush gamcunapä, suriquicunapä y Jesucristuta chasquicogcunapäga may-saycho taptinpis lapanpämi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro mastapis tantyasergan: “¡Waquin runacuna jusalicur cawayaptinpis gamcunaga ama jusalicuyaysu!” ");
INSERT INTO qvhNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro nishganta chasquicogcuna lapan say junag bautizacuyargan. Say bautizacogcunaga cayargan quimsa waranganömi (3,000). ");
INSERT INTO qvhNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Paycunami imaypis shuntacäyag apostolcuna yachasiyashgancunata yachacuyänanpä, Santa Cënata upuyänanpä y Tayta Diosninsita manacuyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolcuna milagrucunata rurayashganta ricarmi lapan yäracogcuna espantash ricacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Paycunaga imaypis shuntacäyashpanmi cashganpita imatapis nistashgan-tupu raquipänacuyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Saynömi chacrancunatapis y imaycancunatapis ranticuyag. Say guellaytanami nistäyashgan-tupu aypunacuyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Waran waranmi templo patiuman shuntacäyag Tayta Diosta manacuyänanpä. Wayincunachöpis shuntacäyashpan Santa Cënata upurcur cushishlami micuytapis micuyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Paycunaga imaypis Tayta Diosta agradëcicuyag yanapashganpita. Lapan runacunami paycunata respitayag. Saynöpis waran waranmi runacuna Jesucristuta chasquicuyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc junagmi, malway inti caycaptin, Pedruwan Juan imaypis aywayashganno templuman aywayargan Tayta Diosta manacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Saychömi juc runa caycargan yurishganpita-pasa ishcan chaquin wanush. Say runatami waran waran castancuna apayag templucho “Cuyaylapä” nishgan puncuman. Say puncuchömi templo patiuman yaycogcunata caridäta manacog. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedruwan Juan templo patiuman yaycuycagta ricarmi paycunatapis say runa caridäta manacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sayno manacuptinmi Pedro nergan: “¡Ricayämay!” ");
INSERT INTO qvhNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Saymi say runa paycunata ricarargan imalawanpis yanapänanpä cashganta yarpashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nircurmi say runata Pedro nergan: “Manami guellaynëpis ni gorëpis cansu gamta yanapänäpä. Sayno captinpis ¡Nazaret marcapita cag Jesucristupa jutincho jucla sharcur puriy!” ");
INSERT INTO qvhNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sayno nishpan Pedro derëcha cag maquinpita aptarcur sharcasiptinmi jinan höra chaqui moguncunapis sänu ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Saymi jucla sharcurcur say runa puriyta galaycorgan. Nircurmi paycunawan templo patiuman yaycorgan cushicur saltashpan y Tayta Diosta alabashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Tayta Diosta alabashpan saltaycachar puriycagta ricarmi lapan runacuna cushicuyargan. Saymi niyargan: “¡Ricay! ¡Cuyaylapä nishgan puncucho caridäta manacog mana pureg runa puriycanna!” ");
INSERT INTO qvhNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ishcan chaquin wanush cashganpita aliyag runa manami cachaycorgansu Pedrutawan Juanta. Paycuna Salomón nishgan alarcho caycagta ricarmi runacuna cushicuyashpan sayman cörrila aywayargan ricayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chaptinnami runacunata Pedro nergan: “Israel mayëcuna, ¿imanirtä nogacunata ricapaycäyämanqui? Manami quiquëcunapa munaynëwansu ni jusaynag cayashgäpitasu cay runata aliyäsiyashcä. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Saypa trucanga Jesucristupa munayninwanmi aliyäsiyashcä. Paytami Abraham, Isaac, Jacob y unay Israel runacuna yäracuyashgan Tayta Diosninsi churash lapanpita más munayyog cananpä. Sayno captinpis gamcunaga payta autoridäcunaman entregayashcanqui wanusish cananpä. Pilato cachariyta munaptinpis gamcunaga manami munayashcanquisu. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Saypa trucanga Pilätuta manacuyashcanqui jusayog cagta cacharir jusaynag alilata rurag cagta wanusinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Saynöpami wanusiyashcanqui cawayta gomagninsita. Sayno wanusiyaptiquipis paytami Tayta Diosninsi cawarisimush. Cawarircamur yuripäyämaptinmi nogacuna ricayashcä. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Paymi aliyäsish puriyta mana puëdeg runata. Jesucristuman yäracuyaptëmi ricayashgayquinöpis cananga sänuna caycan. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Israel mayëcuna, gamcuna y autoridäninsicunapis manami tantyayashcanquisu salvamänansipä Tayta Diosninsi payta cachamushganta. Sayno mana tantyarmi Jesusta wanusiyashcanqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tayta Diosninsipa unay profëtancuna maynami guelgargan Cristuta runacuna wanusiyänanpä cashganta. Saymi gamcuna payta wanusiyaptiqui cumplish say profëtacuna guelgayashgannöla. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Cananga Cristuta wanusiyashgayquipita perdonashunayquipä Tayta Diosta manacuyay. Saynöpis jusalicuyta cacharir pay munashgannöna cawayay. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Saynöpami Tayta Diosninsi lapan jusalicuyashgayquicunata perdonayäshuptiqui cushish cawayanquipä. Saynöpis Jesucristuta gamcunaman yapay cachamonga maquincho lapantapis sararänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cutimunanpä cag höra manarä chämuptinmi Jesucristoga ciëluchörä caycan. Cutimurnami lapantapis churanga Tayta Dios munashgannöna cananpä. Sayno cananpä cashgantaga Tayta Diosninsipa profëtancuna unaypita-pasami wilacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Saynömi Moisespis unay Israel runacunata Jesucristo shamunanpä cashganta wilapargan: ‘Tayta Diosninsimi castansipita juc runata churanga nogano wilacog cananpä. Payta gamcunaga cäsucuyay.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mastapis Moisés caynömi nergan: ‘Pipis say wilacogta mana cäsucog cäga juzgashmi canga.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Moisés wilacushgannömi Tayta Diospa waquin profëtancunapis wilacuyargan canan wisan päsaycashganta. Sayno wilacuyargan Samuel wilacushganpita-pasami. ");
INSERT INTO qvhNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Saymi Jesucristuta chasquicuptiqui profëtacuna wilacuyashgannöla Tayta Diosninsi salvayäshunquipä. Saynöpami Tayta Diosninsi cumpliycan Abrahamta, Isaacta y Jacobta promitishganta: ‘Gampita miragpitami pï-may runacunapis bendicionta chasquiyangapä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abrahamta promitishgannölami Jesucristuta chasquicur say bendicionta chasquiycansi. Say bendicionga jusalicushgansicunata cacharir Tayta Dios munashganno cawanansipä Jesucristo salvamashgansimi caycan. Paytami Tayta Diosninsi nogansiman cachamorgan waquin runacunapita gamcuna puntata payta chasquicuyänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedruwan Juan saycho wilacuycaptinmi chäyargan cüracunawan saduceucunapis. Saynöpis chargan templo täpag wardiacunapa capitanninpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paycuna chaycurmi wiyayargan Pedruwan Juan yachaycäsishganta: “Wanushganpita Jesús cawarimush captinmi lapansipis wanushgansipita cawarimushunpä.” Sayno yachasiyashganta wiyarmi fiyupa rabianäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sayno rabiacuyashpanmi Pedrutawan Juanta prësu sariyargan. Tardina captinmi carcilman wichgaycuyargan waraynin tutayag. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sayno captinpis Pedruwan Juan wilacuyashgancunata wiyar ascagmi Jesucristuta chasquicuyargan. Say chasquicogcunaga cayargan pisga waranganömi (5,000), warmicunata ni wamracunatapis mana yupaylapa. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Waraynin tutanami Jerusalencho shuntacäyargan Israel runacunapa autoridänincuna, Israel mayor runacuna y Moisés guelgashgan leycunata yachasegcunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Paycunawanmi shuntacäyargan cüracunapa más mandagnin Anaspis. Saychömi caycäyargan Caifás, Juan, Alejandro y Anaspa waquin castancunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Saycho lapan shuntacaycur Pedrutawan Juanta carcilpita jorgurcasimur tapuyargan: “¿Ima munayniquiwantä gamcuna aliyäsiyashcanqui ishcan chaquin wanush runata? Sayno aliyäsiyänayquipäga ¿pitä gamcunata cachayämushushcanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Sauraga Santu Espíritu valorta goptin Pedro nergan: “Israel mayor runacuna, wiyayämay. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Ishcan chaquin wanush runata imanöpa aliyäsiyashgätapis musyayta munayaptiquega canan tantyasishayqui imanöpa aliyäsiyashgätapis. Paytaga aliyäsiyashcä Nazaret marcapita cag Jesuspa jutinchömi. Jesustami gamcuna crucificaypa wanusiyashcanqui. Sayno wanusiyaptiquipis paytaga Tayta Diosninsimi cawarisimush. Sayta musyayay gamcuna y Israelcho tag lapan runacunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Saymi Tayta Diosninsipa palabrancho Jesuspä nican: ‘Wayi sharcasegcuna: “Manami alisu cay rumi” nir jitariyaptinpis wayi esquïnaman cimientupä say rumi churashganami caycan.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Saymi Jesucristo japalan salvamagninsi caycan. Manami paypita más jucga cansu salvamänansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ishcan apostolcuna mana mansariypa wilacuyaptinmi autoridäcuna quiquinpura niyargan: “Paycunaga shumag mana estudiash caycar ¿imanöpatä sayno ali wilacuyan?” Saynöpami tantyacuyargan Jesuspa discïpuluncuna cayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Saymi imata niytapis camapacuyargansu, say aliyäsishgan runa saycho captin. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Nircurmi Pedrutawan Juanta wagtaman jorgurcasir quiquinpura wilanacuyargan: “¿Imatatä rurashun paycunata? Jerusalencho tag lapan runacunami musyayan say runata aliyäsiyashganta. Saytaga manami ñëgashwansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Waquin marcacunachöpis say aliyäsishgan mana mayacänanpä paycunata mandashun cananpitaga Jesuspita pitapis manana wilapäyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sayno wilanacurcuyarmi apostolcunata wagtapita gayascasimur niyargan: “Canan junagpitaga ama pitapis Jesuspita wilapäyanquisu ni yachasiyanquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Niptinmi Pedruwan Juan niyargan: “Shumag tantyacuyay, taytacuna. Manami alisu canman Tayta Diosninsita cäsucuyänäpa trucan gamcunata cäsucuyaptëga. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ricayashgäta wiyayashgätaga nogacuna pitapis wilapäyäshämi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ishcan chaquin wanush runata aliyäsiyashganpita lapan runacuna Tayta Diosninsita alabayaptinmi autoridäcuna paycunata manana castigayargannasu. Saypa trucanga niyargan: “Saynöla wilacur puriyaptiquega castigayäshayquimi.” Sayno juraparcurmi cachariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jesuspa munayninwan aliyag runaga chuscu chunca (40) watapita masnami cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedruwan Juan carcilpita yargusquirna aywayargan waugui-panicuna juntaraycäyashgan wayiman. Paycunatami wilapäyargan mandag cüracuna y Israel mayor runacuna jurapäyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sayno wilapäyaptinmi lapanpis Tayta Diosta manacuyargan: “Tayta Dios, gammi camashcanqui ciëlutapis, cay pasatapis, lamartapis y lapan imacunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Santu Espiritupa munayninwanmi rey Davidta tantyasishcanqui guelgananpä: ‘¿Imanirtä runacuna rabiash caycäyan? ¿Imanirtä manacagcunata wilanacuyan? ");
INSERT INTO qvhNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Saynölami más mandag autoridäcunapis shuntacaycur wilanacuyan Tayta Diospa contran y cachamushgayqui salvacogpa contranpis sharcuyänanpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Rey David guelgashgancho nishgannölami Herodispis, Poncio-Pilätupis, Israel mayëcunapis y may-saypita shamog runacunapis cay Jerusalén marcacho shuntacäyargan cachamushgayqui Jesucristupa contran sharcuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Paypa contran sharcuyänanpä cashgantaga unaypita-pasami musyashcanqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cananpis autoridäcuna jurapäyämashganta ricaycanquimi, Tayta Dios. Gamlamanmi nogacuna yäracuyä. Canan valorta goycayälämay, wilacuyniquita mana mansariypa wilacuyänäpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yanapaycayälämay Jesucristupa jutincho gueshyagcunata aliyäsiyänäpä y milagrucunatapis rurayänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tayta Diosta manacuyta ushasquiyaptinmi shuntaraycäyashgan wayi sucsucyargan. Saymi Santu Espíritu paycunata valorta gorgan Jesucristupa wilacuyninta mana mansariypa wilacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Saycho Jesucristuman lapan yäracogcuna, ascag carpis, say yarpaylami cayargan. Quiquincunapä quëdasicunanpa trucanga lapantami aypunacuyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mana mansacuypami apostolcunaga Señorninsi Jesucristo cawarimushganta wilacuyag. Jesucristuta chasquicogcunata Tayta Diosninsi lapanchöpis shumagmi yanapargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Paycunaga manami mayganpis muchuyargansu. Muchuycho pipis mana cayänanpämi chacrancunata wayincunata ranticuycur say guellayta apostolcunaman apayag. Paycunanami muchuycho cagcunata aypuyag nistäyashgan-tupu. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Saynölami rurargan José jutiyog runapis. Pay cargan Leví castami. Saynöpis cargan Chipre islapitami. Paypa cuyay jutintami apostolcuna churapäyargan “Bernabé” nir. Say jutega “cuyapäcog runa” ninanmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Paypis chacranta ranticusquirmi apostolcunaman guellayta apargan paycunana say guellaywan muchogcunata yanapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Saychömi caycargan Ananías warmin Safirawan. Paycunapis wilanacurirmi chacranta ranticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Saymi ishcan yachasinacurcur chacranta ranticuyashgan guellayta raquicuriyargan. Nircur waquilantana apostolcunaman Ananías apargan: “Caylami chacräpa chanin guellay” nishpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sayno lulacuptinmi Pedro nergan: “Ananías, ¿imanirtä Satanás yäsishushgayquita chasquipar Santu Espirituta lulapänayquipä wilanacuyashcanqui? ¿Imanirtä waquin guellayta raquicurir: ‘Caylami chacräpa chanin guellay’ nicanqui? ");
INSERT INTO qvhNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ranticuyashgayqui chacraga ¿manacu quiquiquicunapa cash? Chacrayquipa chanin guellaypis ¿manacu quiquiquicunapana cash? Sayno caycaptenga ¿imanirtä sayno rurayashcanqui? Runacunata lulaparpis Tayta Diosta manami lulapayta camäpacunquipäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pedro sayno nishganta wiyarmi Ananías jinan höra wanusquergan. Sayno wanushganta musyarmi runacuna segaypa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Magtacuna chaycamurmi Ananiaspa ayantana piturcur apar pampayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Saypita quimsa höratano chargan Ananiaspa warmin Safira. Pay manami musyargansu runan wanushganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chaycuptinmi Pedro taporgan: “Mä wilamay. ¿Runayqui apamushgan guellaylachöcu chacrayquita ranticuyashcanqui?” Saymi Safira nergan: “Au, saylachömi ranticuyashcä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Niptin Pedro nergan: “Santu Espíritu musyaycaptin ¿imanirtä yachasinacuyashcanqui lulacuyänayquipä? ¡Ricay! Puncuchönami caycäyan runayquipa ayanta pamparcur cutimog magtacuna. Lulacushgayquipita canan gampis runayquinölami wanunquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sayno niptinmi Pedrupa naupancho Safirapis wanusquergan. Saypita magtacuna yaycur tarergan wanushgana jitaraycagta. Saymi paytapis piturcur apar runanpa naupanman pampayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ananiaswan Safira lulacuyashganpita wanuyashganta musyaycurmi waugui-panincuna y waquin runacunapis fiyupa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Runacuna ricaycäyaptinmi Diospa munayninwan apostolcuna milagrucunata rurayag. Saynöpis Tayta Diosninsiman yäracogcuna imaypis templuman shuntacäyag Salomón nishgan alarman. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ananiasta Tayta Diosninsi sayno castigashganta musyaycurmi waquin runacuna paycunawan shuntacäyargannasu. Paycunawan mana shuntacarpis paycunata alimi ricayag. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ali wilacuyta wiyagcunaga waran waranmi warmipis olgupis Jesucristuta chasquicuyargan. Saynöpami más ascayäyargan Jesucristuman yäracogcuna. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cällipa Pedro päsaptinmi gueshyagcunata jorgayämog cämantinta cayno yarpäyashpan: “Pedro päsaptin lantuylanpis jananman chaptenga aliyangami.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Cercacho cag marcacunapitapis gueshyagcunatawan supay nacasishgancunatapis apacurcurmi Jerusalenman runacuna shayämog. Say apayashgan gueshyagcunatami apostolcuna lapanta aliyäsiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gueshyagcunata aliyäsishganta musyarmi más mandag cüra y paywan pureg saduceo runacunapis apostolcunapa contran sharcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Saymi prësu sariycasir carcilman wichgasiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Say sacaymi Tayta Diosninsipa angilnin chaycur cárcil puncucunata quichapargan. Nircurmi wagtaman jorgurir apostolcunata nergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aywayay templupa jatun patiunman. Saycho runacunata wilapäyay Jesucristuta chasquicuptin Tayta Diosninsi salvananpä cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Saymi templupa jatun patiunman waraynin tuta apostolcuna yaycuyargan. Saychömi ángil nishgannöla runacunata wilapäyargan. Más mandag cüranami cüra mayincunawan gayasimorgan Israel runacunapa lapan autoridänincunata sesionta rurayänanpä. Paycunawan wilanacurcurmi wardiacunata cachayargan carcilpita apostolcunata jorgayämunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wardiacuna carcilman chaycuyashpan manami tariyargannasu apostolcunata. Saymi cutiycur niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Cárcil puncuta shumag wichgaraycagtami tariyashcä. Prësu cuidagcunatapis puncucunacho ichiraycäyagtami tariyashcä. Ruriman yaycurmi isanga maygan prësutapis tariyashcäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sayta wiyaycurmi más mandag cürapis, templucho wardiacunapa capitanninpis y waquin mandag cüracunapis yarpachacuyargan: “¿Imanöparä gueshpisquiyash? ¿Imatanarä masta rurasquiyanga?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sayno yarpachacuycäyaptinmi juc runa chaycur nergan: “¡Carcilman wichgayashgayqui runacunaga templo patiuchömi runacunata yapay yachaycäsiyan!” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sayno niptin wardiacunata pushacurcur capitán aywargan apostolcunata prësu sarimunanpä. Mana magaylapami prësu sarircur apayargan runacuna samgayänanta mansacuyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Saymi apostolcunata chäsiyargan autoridäcuna shuntaraycäyashganman. Saychönami más mandag cüra nergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“¿Manacu gamcunata niyashcä imaypis Jesuspita manana yachasiyänayquipä? Sayno nicäyaptëga ¿imanirtä yachaycäsiyanqui runacunata? Nircurpis nogacunata jitapaycäyämanqui: ‘Paycunami Jesusta wanusiyash’ niyashpayqui.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sayno niptin Pedro y waquin cag apostolcunapis niyargan: “Runacunata cäsucuyänäpa trucanga Tayta Diosninsitami cäsucuyäshä. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gamcuna Jesusta crucificaypa wanusiyaptiquipis unay Israel mayinsicuna yäracuyashgan Tayta Diosninsimi wanushganpita cawarisimush. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nircurmi lapanpita más munayyog cananpä payta derëcha cag lädunman jamasish. Saynöpis churash mandamagninsi y salvamagninsi cananpämi. Sayno churash carmi payta chasquicogcunata lapantapis jusalicushgancunata perdonash. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Saycunata wilacuyänäpämi Santu Espirituta Tayta Diosninsi nogacunaman cachamush. Pï-maytapis pay nishganta cäsucogtaga Santu Espíritu yanapaycanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sayno niyashganta wiyaycurmi autoridäcuna fiyupa rabiacuyashpan wanusiyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Paycunawanmi caycargan Moisés guelgashgan leycunata yachaseg juc fariseo runa. Paypa jutinmi cargan Gamaliel. Lapan runacunami payta respitayag. Paymi wardiacunata mandargan apostolcunata wagtaman rätula jorgusquiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sayno jorgurcasirmi saycho caycag autoridäcunata nergan: “Israel mayëcuna, cay runacunapa contran imatapis manarä rurar shumag yarpachacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Yarpäyanquicu juc cuticho Teudas jutiyog runa: ‘Yachag runami cä’ nir sumäsir purishganta? Paytami gatirargan chuscu pachac (400) runacuna. Sayno puriycagta wanuscasiyaptin gatiragnincuna wacpa caypami mashtacar aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Saypita censacuy cashgan wisan purergan Galilea provinciapita shamog Judaspis. Saynölami paytapis wanuscasiptin lapan gatiragnincuna, asca carpis, mashtacar ushacäcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Saymi noga yäsë cay runacunawan mana churacänansipä. Saypa trucanga paycunata amana cäsupäshunsu. Quiquinpa yarpaylanpita wilacuyaptenga saylachönami usharanga. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tayta Diosninsipa wilacuynin captenga imata rurashgapis sïguengami. Shumag mana tantyacuypa paycunata wanuserga cuidä Diospa contran ruraycashwan.” ");
INSERT INTO qvhNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Saymi Gamaliel nishganta cäsucuyashpan apostolcunata manana wanusiyargannasu. Wanusiyänanpa trucanga cutiycasimurmi astasergan. Astarcasirmi niyargan: “¡Cananpitaga amana wilacuyanquisu Jesuspita!” Sayno juraparcurmi cachasquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Cachasquiyaptinmi apostolcuna cushish aywacuyargan. Sayno cushicuyargan Jesucristu-raycu autoridäcuna astayashganpitami. ");
INSERT INTO qvhNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Autoridäcuna michaycäyaptinpis paycunaga waran waranmi runacunata yachasiyargan: “Jesusga salvamagninsi Cristumi” niyashpan. Saynölami templo patiucho y wayicunachöpis wilacuyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Apostolcuna sayno wilacuyaptinmi Jesucristuta chasquicuyargan asca runacuna. Say chasquicogcuna waquin cayargan griego idiömata parlagcuna y waquinnami cayargan hebreo idiömata parlagcuna. Paycunacho muchog viüdacuna captinmi waran waran micuyta aypuyag. Hebreo parlag viüdacunata más yanapäyaptinmi griego parlagcuna jamurar niyargan: “Griego parlag cag viüdacunata mana cäsuypami hebreo parlagcunaga quiquinpurala micuyta aypunacuyan” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","4","Sayno niyaptinmi Jesucristuman yäracogcunata shuntarcur apostolcuna niyargan: “Waugui-panicuna, micuycunata aypucuyänanpäga nogansipita acrashun ganchis yäracog mayinsicunata. Paycuna cayäsun ali ricash runacuna, Santu Espíritu munashganno cawag y ali yarpayyog. Saynöpami nogacunapa tiempöcuna canga Tayta Diosninsita manacuyänäpä y ali wilacuyninta wilacur puriyänäpäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Sayno wilanacurcurmi ganchis yäracog mayincunata acrayargan. Paycunapa jutincuna cayargan Esteban, Felipe, Prócoro, Nicanor, Timón, Parmenas y Antioquía marcapita cag Nicolaspis. Nicolasga naupatanami Tayta Diosta chasquicur cuerpunta señalacorgan Israel runa cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nircur say acrayashgan ganchis wauguicunapa umancunaman maquinta churaycur apostolcuna Tayta Diosninsita manacuyargan paycunata yanapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Saymi Jesucristupa wilacuyninta Jerusalencho wilacuyaptin Jesucristuman yäracogcuna ascayäyargan. Saynölami waquin cüracunapis chasquicuyargan say wilacuyta. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebantaga Tayta Diosninsi shumagmi yanapargan pay munashganno cawar wilacuyninta wilacunanpä. Saynöpis yanapargan asca milagrucunata rurananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sayno milagrucunata rurar Jesucristupa wilacuyninta wilacuptinmi paywan rimanacuyargan waquin Israel mayincuna. Say runacuna cayargan Cirene marcapita, Alejandría marcapita, Cilicia provinciapita y Asia provinciapitapis. Paycunami shuntacäyargan “Ashmay cashganpita yargush” nishgan sinagogacho. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Santu Espiritupa munayninwan Esteban parlaptinmi rimanacurpis paycunaga vinciyta puëdiyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Saymi say runacuna pacaylapa waquin runacunata pägayargan Estebanpa contran sharcur autoridäcunata niyänanpä: “Moisespa y Tayta Diosninsipa contranmi Estebanga parlaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sayno nishganta wiyaycurmi Israel mayor runacuna, Moisés guelgashgan leycunata yachasegcuna y waquin runacunapis fiyupa rabiacuyargan. Nircurnami Estebanta prësu sarircur apayargan más mandag autoridäcuna shuntaraycäyashganman. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Saymanmi pägayashgan cag runacunata pushayargan Estebanpa contran niyänanpä: “Cay runaga templunsipa contran y Moisés guelgashgan leycunapa contranmi imaypis parlaycan. ");
INSERT INTO qvhNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Saynöpis cay runaga nish Tayta Diosninsipa templunta Nazaret marcapita cag Jesús juchusinanpä cashganta. Saynöpis yachaycäsin Moisés guelgashgan leycunata mana cäsucunansipämi. Sayno parlashgantaga quiquëcunami wiyayashcä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sayno niyaptin autoridäcuna y paycunawan caycagcunapis Estebanpa cäranta ricäriyashgancho angilpa cärantano ricayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Saypita más mandag cüra taporgan Estebanta: “¿Rasunpacu cay runacuna niyashganno gam parlashcanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Saymi Esteban nergan: “Shumag wiyayämay, taytacuna. Musyashgansinöpis unay awilunsi Abrahamta munayyog Tayta Diosninsi yuripargan. Sayno yuripargan Mesopotamialachörä taycaptinshi. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Saycho yuriparcurshi nergan: ‘Taycashgayqui marcata y castayquita cachaycur aywacuy maychöpis tänayquipä ricasinäpä cagman.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Sayno niptinshi Mesopotamiapita Abraham aywacorgan Harán marcacho tänanpä. Taytan Taré wanuycuptinnashi Tayta Diosninsi pushamorgan taycashgansi cagmanna. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cayman pushaycamurpis quiquinpa cananpä manashi chacratapis ricasergansu. Mana ricasirpis surin manarä captinshi Tayta Diosninsi Abrahamta nergan: ‘Cay taycashgayqui naciontami gampita miragcunata ricasishä paycunapana cananpä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Saynöpis Tayta Diosninsi payta nergan: ‘Gampita miragcunami chuscu pachac (400) wata juc nacioncho jäpa runacunapa ashmaynin cayanga. Say nacionchömi segaypa nacayangapä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ashmaytano sararäyashganpitami say nación runacunata noga castigashäpä. Ashmay caycäyashganpita yargamurnami caycho cushishlana täyanga munashgäta rurar.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Saypitanashi Abrahamta nergan cuerpunta quiquin señalacunanpä y olgu surincuna yuriptin paycunapa cuerpuntapis señalananpä. Sayshi Tayta Diosninsi nishgannöla Abraham señalacorgan. Nircurshi surin Isaacpa cuerpuntapis señalasergan yurishganpita puwag (8) junagyog caycaptin. Saynölashi Isaacpis surin Jacobta señalasergan y Jacobpis chunca ishcay (12) surincunata señalasergan. Say chunca ishcay surincunapitami lapan Israel runacuna mirayash. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Jacobpa surin Josëtashi wauguincuna chiquiyashpan Egiptupa aywag negocianticunata ranticusquiyargan. Say negocianticunanashi Egiptuman chaycasir ranticuycuyargan. Egiptuchöpis Tayta Diosninsi imaypis Josëta yanapagshi. Sayshi yachag cananpä yanapaptin Egipto nacionpa mandagnin faraón payta churargan palaciuncho arogcunata mandananpä y Egipto naciontapis mandäsinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Say wisanshi Egipto nacioncho y Canaán nacionchöpis fiyupa usya cargan. Sayshi unay Israel mayinsicuna micuyänanpäpis cargansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egiptuchöshi isanga usya manarä captin asca trïguta José pirwasergan. Muchuy captinnashi say pirwashgan trïguta Egiptucho ranticuycashganta musyaycur surincunata Jacob cachargan trïgu ranteg aywayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Saypita trïgu ranteg yapay cutirpis manaräshi tantyayargansu José paycunapa wauguin cashganta. Sayno mana tantyayaptinshi José wilapargan paycunapa wauguin cashganta. Nircurnashi mandag faraonwan wauguincunata reguinacuyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Saypitana José gayasergan castancunatawan taytan Jacobta Egipto nacionman. Sayshi Egiptuman aywagcuna lapan cayargan ganchis chunca pisga (75) runacuna. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Saynöpashi Egiptuman surincunawan Jacob aywayargan saycho täyänanpä. Saylachönashi paypis y surincunapis wanuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","“Paycuna wanuycuyaptinnashi ayanta saquircasir Siquem marcaman apayargan pampayänanpä. Saychöshi Abraham pamparashgan machayman pampayargan. Say machayga Abraham rantishgan chacrachöshi cargan. Say chacrataga rantergan Hamor jutiyog runapa surincunapitashi. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tayta Diosninsega manashi gongargansu Abrahamta promitishganta: ‘Gampita miragcunatami Egiptucho ashmay cashganpita noga shuntamushäpä.’ Nishgannöla shuntamunanpä cag tiempo cumplinanpäna caycaptinshi Israel runacuna Egiptucho aläpa mirayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Say wisanshi juc runana yaycorgan Egiptucho mandag faraón cananpä. José wanushgana captinshi payga musyargansu José pï cashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sayshi Israel runacuna mirananta mana munar say mandag faraón waran waran paycunata aläpa arusergan. Saynöpis Israel castacho olgu yureg cagtaga yuriylanta wanusinanpä nergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Say wisanshi Moisespis yurergan. Paytashi Tayta Diosninsi segaypa cuyargan. Saynölashi taytan mamanpis cuyar wayilancho pacaylapa ashmayargan quimsa quilayog cashganyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Saypita wanusinanta mana munashpan Moisesta mayu cuchunman pacaycuyargan. Sayshi faraonpa warmi surin shuntacur quiquinpa wawantano ashmacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Saypita Egiptucho estudiarshi yachag y munayyog ricacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chuscu chunca (40) watayog caycarnashi Moisés yarpargan marca mayincunaman watucag aywayta. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yarpashgannöla watucag aywarshi tarergan Israel runata Egipto runa magaycagta. Sayshi Israel runapa favornin sharcur Moisés wanurasergan say Egipto runata. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés yarpargan Egiptupita jorgamunanpä Tayta Diosninsi acrashganta Israel mayincuna tantyacunantashi. Sayno yarpaptinpis Israel mayincunaga Moisesta manashi cäsupäyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Saypita waraynin junagshi Moisés tarergan ishcay Israel mayincuna pelyaycagta. Sayshi paycunata washashpan nergan: ‘Gamcuna say castala caycarga ¿imanirtä pelyaycäyanqui?’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sayshi magag cag runaga Moisesta tangarishpan nergan: ‘Gamta ¿pitä churashushcanqui nogacunapa mandagnë y jueznë canayquipä? ");
INSERT INTO qvhNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Egipto runata ganyan wanusishgayquinöcu nogatapis wanusimayta munaycanqui?’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sayno niptinshi Moisés fiyupa mansacorgan, Egipto runata wanusishganta faraonpis musyashgantana yarpashpan. Sayshi gueshpir aywacorgan Madián partiman. Gorpanöla saycho taycaptinshi ishcay olgu surincuna yurergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Madiancho chuscu chunca (40) wata taycarnashi Moisés aywargan Sinaí nishgan sunyag jircapa cercanman. Saychöshi shiraca rupaycagcho juc ángil yuripargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sayta ricarshi Moisés ima ruraytapis camäpacorgansu. Sayshi shumag ricananpä yaycuycashgancho wiyargan Tayta Diosninsi cayno nimogta: ");
INSERT INTO qvhNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Unay castayquicuna Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä.’ Sayta wiyarshi Moisés sucsucyashpan ricäriytapis mansarergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Saynöpis Tayta Diosninsi nergan: ‘Caychöga nogami caycä. Sayno caycaptenga respitamashpayqui jatirashgayqui languiquita jorguy.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nircurnashi nergan: ‘Noga ricaycämi Israel runacuna Egipto nacioncho nacar wagaycäyashganta. Saymi Egiptuman gamta cachashayqui paycunata jorgamunayquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mandagnin ni jueznin Moisés cananta Israel mayincuna mana munaycaptinpis Tayta Diosninsi rupaycag shiracacho yuripag angilwan wilacasergan Egiptupita jorgamunanpä y mandagninpis cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sayshi Egipto nacionpita Israel mayincunata jorgamunanpä Moisés milagrucunata rurargan Egiptucho y Puca lamarchöpis. Saynölashi chuscu chunca (40) wata sunyag jircacho caycarpis milagrucunata rurargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisesshi Israel mayincunata nergan: ‘Tayta Diosninsimi gamcunapa castayquipita juc runata churanga nogano wilacog cananpä. Payta gamcunaga cäsucuyay.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Saynöpis Moisesshi Sinaí jircacho Tayta Diosninsi cachamushgan angilpita chasquergan mandamientucunata. Say mandamientucunatami runacunata yachasergan Tayta Diosninsi munashganno cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Unay Israel runacunaga sunyag saqui jircachöpis manashi Moisesta cäsucuyargansu. Mana cäsuyashpanshi Egiptuman cuticuyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Sayshi Sinaí jircaman wisashganpita Moisés jucla mana cutimuptin Aaronta niyargan: ‘Manami musyansinasu Egiptupita jorgamagninsi Moisesta ima päsashgantapis. Moisés elagashgana caycaptenga yanapämänansipä goripita juc diosta rurayculay.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sayno manacuyaptinshi goripita rurapargan becërru-nirag ïduluta diosnin cananpä. Nircur say rurayashgan diosnin paycuna manacuyashganta wiyananpäshi uywacunata wanurcasir payta adorayashpan rupasiyargan. Nircurnashi say ïdulupä fiestata rurayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Sayno rurayaptinshi Tayta Diosninsi fiyupa rabiacushpan paycunata manana yanapargannasu. Sayshi goyllarcunamanna, intimanna y quilamanpis yäracur manacuyargan. Sayshi unay profëtan guelgananpä Tayta Diosninsi nergan: ‘Chuscu chunca (40) watantin sunyag jircapa puriyashpayqui gamcunaga uywacunata altarcho nogapä rupasirpis janan shongulami adorayämashcanqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Sayno cashcanqui rurayashgayqui Moloc ïdulupä yarpacush purirmi. Saynöpis Refán nishgan ïdulupa goyllarnin-niragta adorayashcanqui. Sayno rurayashgayquipitami garguyäshayquipä Babilonia marcaman.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sunyag saqui jircacho unay Israel runacunaga toldërapita rurash tabernäculutashi purisiyargan saycho Tayta Diosta manacur adorayänanpä. Say tabernäculutaga rurayargan Moisesta Tayta Diosninsi tantyasishgannölashi. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Say tabernäculuta apacurcurshi Josué y lapan Israel runacuna yaycayämorgan cay taycashgansi nacionman. Yaycayämuptinshi Tayta Diosninsi cay marcacunacho tag runacunata gargorgan. Sayno garguptinnashi cay nación unay Israel runacunapana ricacorgan. Say tabernäculoga cay marcansicunachöshi quëdargan rey David cawashgan wisanyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tayta Diosninsi yanapaptinshi Davidga templutana sharcasiyta munargan Tayta Diosninsipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sayno yarpaptinpis surin Salomonräshi sharcasergan say templuta. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Templuta Salomón sharcasiptinpis lapanpä munayyog Tayta Diosninsega manami tansu runacuna rurayashgan templuchöga. Sayshi unay profëtan guelgananpä Tayta Diosninsi nergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ciëloga trönömi. Runa tashgan pasaga chaquë jaruräcunanmi. Sayno caycaptenga manami ima wayipis nogapä aypangasu. ¿Ima wayirä noga tänäpä aypaycunman? ");
INSERT INTO qvhNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nogami camashcä ciëlutapis y runa tashgan pasatapis.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sayno nircurmi Esteban nergan: “Gamcunaga unay Israel mayinsicunanölami Santu Espiritupa contran caycäyanqui. Tayta Diosta mana cäsucog cayashpayquimi mana yäracog runacunanöla caycäyanqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tayta Diosninsipa profëtancunata unay runacuna chiquiyashgannömi gamcunapis Tayta Diosninsipa wilacognincunata chiquiycäyanqui. Tayta Dios cachamushgan salvacog shamunanpä cashganta wilacuyaptinpis wanusishgannömi gamcunapis Tayta Dios cachamushgan salvamagninsi Jesucristuta entregayashcanqui wanusish cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","¡Gamcunaga manami Tayta Diosninsita cäsucuyanquisu, leynincunata angilcunawan apasimuptinpis!” ");
INSERT INTO qvhNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban nishganta wiyashpanmi autoridäcuna fiyupa rabianäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebannami Santu Espíritu yanapaptin ciëluta ricärishgancho ricargan chipipiycag munayyog Tayta Diospa derëcha cag läduncho Jesús ichiraycämogta. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sayta ricaycur nergan: “¡Ricaycämi ciëlo quicharaycämogta! ¡Saynöpis ricaycämi Diospa derëcha cag läduncho Jesucristo caycämogta!” ");
INSERT INTO qvhNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sayno niptin paycuna rinrincunatapis sapacurcuyargan masta mana wiyayänanpä. Saypita fiyupa rabiashpan Estebanman cörricuycuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nircurna marcapita jorgurcur samgayargan. Runacuna payta samgayänanpä janan cag mödanancunata jorgurir paytacuyargan Saulo jutiyog magtata. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paycuna samgaycäyaptinmi Esteban manacorgan: “Señor Jesús, ¡maquiquimanmi almäta churaycö!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Saypitana gongurpacuycur fuertipa nergan: “¡Cay samgaycämag runacunata perdonayculay, taytay!” Nircur päsarporgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Estebanta wanusiyashganta ricarmi Sauloga cushicorgan. Wanuscasiyaptinmi Tayta Diosninsi munashganno cawagcuna Estebanpa ayanta pampayargan fiyupa laquicur wagayashpan. Estebanta wanusiyashgan junagpitanami Jesucristuta chasquicogcunata runacuna segaypa chiquiyargan. Sayno captinmi Judea y Samaria provinciacunapa gueshpir aywacuyargan. Apostolcunalanami Jerusalencho quëdacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulunami Jesucristuta chasquicogcunata wayin wayin ashir tarishgan cagta warmitapis olgutapis carcilman wichgasergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalenpita gueshpegcunami may-saychöpis wilacuyargan Jesucristo salvamagninsi cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Saynömi Felipipis gueshpir Samaria provinciacho cag juc marcaman aywargan. Saychömi runacunata salvananpä Jesucristo shamushganta wilacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jesucristupa munayninwanmi milagrucunatapis Felipe rurargan. Sayta ricarmi wilacushgantapis asca runacuna chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Saynöpis Jesucristupa munayninwan supaycunata runacunapita garguptinmi gaparäyashpan yarguyargan. Saynömi asca wegrucunatapis y paralïticucunatapis aliyäsergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sayno ruraptinmi say marcacho tagcuna cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","10","Saychömi cargan juc brüju. Paypa jutinmi cargan Simón. “Nogaga yachag runami cä” nishpanmi Samaria runacunata naupapita-pasa criyisergan. Olgupis, warmipis y wamracunapis lapanmi Simón nishgancunata wiyashpan niyargan: “¡Cay runataga Tayta Diosninsimi yanapaycan imatapis rurananpä!” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sayno yarpäyargan Simonga brüju cashpan imatapis rurashganta ricarmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jesucristo salvamagninsi cashganta Felipe wilacuptinnami runapis warmipis pay wilacushgantana chasquicuyashpan bautizacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saychömi Simonpis Jesucristuta chasquicushpan bautizacorgan. Nircurna milagrucunata Felipe rurashganta ricar paywanna cushish purergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Saypita Jerusalencho caycag apostolcuna mayayargan Jesucristupa wilacuyninta Samaria provinciacho runacuna chasquiyashganta. Sayta musyarmi sayman cachayargan Pedrutawan Juanta. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Sayman chaycurmi musyayargan Jesuspa jutincho bautizacush caycarpis Santu Espirituta paycuna manarä chasquiyashganta. Saymi Pedruwan Juan Tayta Diosninsita manacuyargan paycunapis Santu Espirituta chasquiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Paycunapa umancunaman maquinta churaycur sayno manacuyaptinmi Santu Espirituta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Santu Espirituta chasquicushganta ricarmi say brüju Simonga apostolcunata nergan: “Say munayniquita ranticaycalämay nogapis runapa umanta yataycur manacuptë Santu Espirituta chasquicuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sayno niptinmi Pedro nergan: “¿Imanirtä Tayta Diosninsipa munaynin rantina cashganta yarpaycanqui? ¡Sayno yarpashgayquipita guellaynintintami supayniqui apashunqui! ");
INSERT INTO qvhNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","¡Gamga manami Tayta Diosninsi munashgannösu cawaycanqui! ¡Saymi Tayta Dios yanapäshunquipäsu nogacuna rurayashgäno ruranayquipä! ");
INSERT INTO qvhNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lutancunata yarpänayquipa trucanga Tayta Diosta manacuy perdonashunayquipä. Sayno manacuptiquega pagta perdonashunquimanpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gamga envidiöso car lutan ruraycunatapis manami cacharinquisu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sayno niptinmi Pedrutawan Juanta nergan: “Sayno captëga Tayta Diosninsita manacuycuyälay perdonaycamänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Saycho runacunata yacharcasirnami Pedruwan Juan saypita aywayargan Samaria provinciacho cag waquin marcacunachöpis Jesucristupa wilacuyninta wilacuyänanpä. Saypitanami Jerusalenpa cuticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Saypita Tayta Diosninsi cachamushgan ángil Felipita nergan: “Jerusalenpita Gaza marcaman aywag nänipa ayway. Say nänega sunyag jircapami päsaycan.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Saymi ángil nishganno Felipe say nänipa aywargan. Sayno aywarmi ricargan Etiopía nacionman capash runa cuticuycagta. Paymi reina Candacipa tesorërun cargan. Tayta Diosninsita adorag Jerusalenman aywashganpitami say runaga cuticuycargan. Saypa aywagno liyiycargan profëta Isaías guelgashgan libruta. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Saymi Felipita Santu Espíritu nergan: “Say cärruwan aywaycag runapa naupanman ayway.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Say nishganno aywarmi Felipe ricargan say Etiopía runa Isaías guelgashgan libruta liyiycagta. Saymi Felipe taporgan: “¿Tantyanquicu say liyiycashgayquita?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Sayno niptinmi nergan: “Pipis mana tantyasimaptenga ¿imanöparä tantyashä? Cayman wisämuy tantyasimänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Say liyiycashgan libruchöga caynömi guelgaraycargan: “Wanusinanpä uyshata apashgannömi payga apash cargan. Milwanta rutuptin uysha upälala cashgannömi payga upälala cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Manacagman churayaptinpis manami favornin pipis sharcorgansu. Payta wanusiyashpan segaypa jusayogmi ricacorgan.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Saymi Etiopía runa Felipita taporgan: “Tantyaycasilämay, taytay. Profëta Isaías cayta guelgar ¿pipätä guelgargan? ¿Quiquinpäcu o jucpäcu?” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Saymi Felipe tantyasergan say liyishgan Jesucristupita guelgaraycashganta. Nircurmi tantyasergan runacunata salvananpä Jesucristuta Tayta Diosninsi cachamushganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Saypita aywaycäyashgancho yacu cashganman chaycur say Etiopía runa nergan: “Caycho yacu caycaptenga ¿manasurä bautizaycalämanquiman?” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Saymi Felipe nergan: “Lapan shonguyquiwan criyir Jesucristuta chasquicuptiquega bautizashayqui, ari.” Sayno niptinmi Etiopía runa nergan: “Rasunpaypami criyë Jesucristo Tayta Diosninsipa surin cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Saymi aywaycäyashgan cärruta ichiycasir yacu cagman uräyargan. Saychömi say runata Felipe bautizargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","40","Yacupita yargarcayämuptin Santu Espíritu Felipita Azoto marcacho elagpita ricacäsimorgan. Saypitaga Etiopía runa Felipita mananami ricargannasu. Payta mana ricarpis cushishmi marcanpa aywacorgan. Felipinami marcan marcan purergan Jesucristupa wilacuyninta wilacushpan. Sayno wilacuraycarmi Cesarea marcaman chargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Saulunami Jesucristuta chasquicogcunata wanusiyta yarpar prësu sareg aywargan. Saymi más mandag cüraman aywargan ordinta jorgamunanpä. Say ordinwannami Damascuman aywargan sinagogacunacho Jesucristuta chasquicogcunata tarerga warmitapis olgutapis prësu apananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Say ordinwan Damasco marcaman chaycaptinnami elagpita acsi payman chilapyämorgan ciëlupita. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sayno chilapyämuptinmi pampaman Saulo tunergan. Saychönami wiyargan ciëlupita cayno nimogta: “Saulo, Saulo, ¿imanirtä nogapa conträ sharcuycanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sayta wiyarmi taporgan: “¿Pitä canqui, taytay?” nir. Tapuptinmi nergan: “Nogaga Jesucristumi caycä. Yäracamagcunata gaticacharga nogapa conträmi caycanqui. Sayno rurashpayquega picata jaytag törunöpis quiquiquimi nacanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sayta wiyarmi mansacash sucsucyashpan Saulo nergan: “¿Imata ruranätatä munanqui, taytay?” Saynami Jesús nergan: “Ayway Damasco marcaman. Saychönami nishunquipä imata ruranayquipä cashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauluwan aywaycagcunaga parlamushganta wiyarpis manami pitapis ricayargansu. Pitapis mana ricarmi fiyupa mansacäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tunishganpita sharcur Saulo gaprayashgana car manami imatapis ricargansu. Saymi paywan aywag runacuna janchaylapa chäsiyargan Damasco marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saycho quimsa junagmi gaprayashla cargan. Manami micuytapis micorgansu ni yacutapis uporgansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascuchömi targan Jesucristuta chasquicog Ananías. Paytami Jesucristo yuriparcur nergan: “¡Ananías!” Niptin nergan: “¿Imatä, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sayno niptinmi Jesucristo nergan: “Ayway Derëcha nishgan cälliman. Judaspa wayinman chaycur tapucunqui Tarso marcapita Saulo jutiyog runapä. Say wayichömi Tayta Diosta pay manacuycan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Manacuycashganchömi ricashushcanqui payman chaycashgayquita. Saychömi ricashushcanqui gapra caycashganpita yapay ricananpä payta yataycur manacushgayquita.” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Niptinmi Ananías nergan: “Payman aywaytaga mansarëmi, taytay. Ascagmi wilayämash say runa segaypa fiyu car gamman yäracogcunata chiquishganta. Jerusalencho gamman yäracogcunatashi gaticachar segaypa nacasergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cananpis más mandag cürapa ordinninwanshi cay marcaman shamush gamman yäracogcunata prësu apananpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Saymi Jesús nergan: “¡Mana mansacuypa ayway! Nogami say runataga acrashcä wilacuynëta wilacunanpä. Paymi wilapanga juclä nación runacunata, más mandag autoridänincunata y Israel runacunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Paytami noga musyasishä noga-raycu fiyupa nacananpä cashganta.” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Sayno niptinmi Ananías aywargan Saulo caycashgan cag wayiman. Chaycurna Saulupa umanta yataycur nergan: “Waugui Saulo, shamuycaptiqui yuripäshogniqui Señor Jesusmi cachamash gapra caycashgayquipita aliyänayquipä y Santu Espirituta chasquicunayquipäpis.” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananías parlayta ushasquiptinmi jinan höra Saulupa nawinpita pescädupa escämanno shicwasquiptin ricarganna. Nircurnami bautizacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saypita micurcurnami cawarircorgan. Nircurnami asca junagrä Jesucristuta chasquicogcunawan Damascucho goyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saypitanami sinagogacunacho Saulo tantyasergan Jesucristo Tayta Diosninsipa surin cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saymi lapan wiyagcunaga mansacashno ricacur niyargan: “¿Manacu cay runaga Jesucristuta chasquicogcunata Jerusalencho prësu sareg caycan? ¿Manacu caymanpis shamush Jesucristuta chasquicogcunata prësu sarircur mandag cüracunaman apananpä?” ");
INSERT INTO qvhNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sayno niyaptinpis mana mansacuypami Saulo tantyasergan cruzcho wanog Jesús salvamagninsi Cristo cashganta. Saymi Damascucho tag Israel runacuna segaypa yarpachacuyargan: “¿Alitasurä o mana alitasurä nicämansi?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saypitanami Israel runacunapa autoridänincuna wilanacuyargan Sauluta wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wanusiyta munarmi pagasta junagta paycuna shuyaräyargan marca yarguna puncucho. Sayno wanusiyta munashgantami Saulo musyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sayta musyaycurmi Jesucristuta chasquicogcuna Sauluta yanapäyargan gueshpinanpä. Saymi Jesucristuta chasquicog mayincuna juc pagas jatun canastaman winarcur marca tumarag jatun perga jananpa uräsiyargan gueshpicunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saypita Jerusalenman Saulo chaycur Jesucristuta chasquicogcunawan shuntacayta munargan. Shuntacayta munaptinpis manami criyiyargansu Jesusman yäracushganta. Saymi paywan shuntacayta mansariyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Sayno mansariyaptinmi apostolcunaman Sauluta Bernabé pushargan. Chaycasirnami paycunata wilapargan Señorninsi Jesucristuta nänicho Saulo ricashganta. Saynöpis wilapargan payta Jesús parlapashganta. Nircur wilapargan Damascucho mana mansacuypa Jesucristupa wilacuyninta Saulo wilacushgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bernabé sayno wilapaptinmi apostolcuna Sauluta chasquicuyargan. Jerusalencho goyarnami paycunawanna Saulo purergan. Saychömi runacunatapis mana mansacuypa wilapargan salvamänansipä Jesucristuta Tayta Dios cachamushganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Griego idiömata parlag Israel runacunatapis wilapaptinmi say runacuna payta wanusiyta munayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sayta musyarmi waugui-panicuna Sauluta pushayargan Cesarea marcaman. Saypitana marcan Tarsuman aywacunanpä payta despachayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Say wisanga Jesucristuta chasquicogcunata autoridäcuna manami pitapis prësu sarisiyargannasu. Saymi Judea, Galilea y Samaria provinciacunachöpis Jesucristuta chasquicogcuna tranquïluna cawayargan. Waran waranmi Jesucristupa wilacuyninta yachacuyargan pay munashganno cawayänanpä. Saynöpis Santu Espíritu yanapaptinmi Jesucristuta chasquicogcuna más ascayarganna. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedrunami may-saypa purir Lida marcamanpis chargan Jesucristuta chasquicogcunata watucananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Saychömi tarergan Eneasta. Paymi paralítico car puwag (8) wata cämalancho jitarargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Saymi Pedro nergan: “Eneas, Jesucristumi aliyäsishunqui. ¡Sharcuy! ¡Cämayquita shuntay!” Sayno niptinmi Eneas jinan höra sänuna sharcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Saymi Lida marcacho tag runacuna y Sarón marcacho tag runacunapis sänuna caycagta ricashpan Jesucristuta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Say wisanmi Jope marcacho Tabita jutiyog warmi targan. Tabita ninanga griego idiömachöga Dorcas ninanmi. Say warmimi Jesusman yäracur imaypis alilata rurag y muchogcunatapis yanapag. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Say marcachömi gueshyawan Tabita wanorgan. Wanuycuptin armarcasir sutayargan altuscho caycag cuartuman. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopipita Lida marcamanga cercalami caycan. Saymi Lidacho Pedro caycashganta wiyar ishcay runacunata cachayargan payta jucla pushamunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Saymi Pedro paycunawan aywargan. Chaycuptinmi yaycasiyargan aya sutaraycashgan cag cuartuman. Saychömi Tabita yanapashgan viüdacuna wagashpan Pedruta ricasiyargan paycunapä rurapashgan mödanancunata. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sauraga Pedro saycho caycagcunata wagtaman gargurir gongurpacuycur Tayta Diosninsita manacorgan. Manacurirna wanush caycagta nergan: “¡Tabita, sharcuy!” Sayno niptinmi wanush caycashganpita jinan höra cawarimorgan. Cawarircurmi Pedruta ricärir jamarcorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nircur maquinpita sarircur Pedro ichisergan. Saypita wagtacho caycagcunata gayargan Tabita cawarimushganta ricayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tabita cawarimushgantaga musyayargan intëru Jope marcachömi. Saynöpami Señorninsi Jesucristuta ascag chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Say marcacho asca junagmi Pedro posädacorgan suëla rurag Simonpa wayincho. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea marcachömi targan juc runa Cornelio jutiyog. Payga “Italiano” nishgan batallunpa capitanninmi cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Paymi wayincho tagcunawan Tayta Dios munashganno cawargan. Sayno carmi nisidächo cagcunata imaypis yanapargan y Tayta Diosninsita imaypis manacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Saymi juc junag, malway intino caycaptin, Cornelio ricargan Tayta Diosninsipa angilninta. Say angilmi nergan: “¡Cornelio!” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Saymi segaypa mansacash ricaraycashgancho angilta taporgan: “¿Imatä, taytay?” nishpan. Sayno niptinmi ángil nergan: “Tayta Diosninsi wiyashushcanquimi manacushgayquita. Muchogcunata yanapashgayquitapis ricashmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cananga Tayta Diosninsipa wilacuyninta tantyasishunayquipä cachacuy Jope marcaman Simonta pushamunanpä. Simonpa jucag jutinmi caycan Pedro. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payga posädaraycan suëla rurag Simonpa wayinchömi. Paypa wayin caycan lamar cuchunchömi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ángil aywacuptinnami Cornelio gayargan ishcay ashmaynincunata y juc yäracushgan soldädutapis. Say soldädoga cargan Tayta Diosninsi munashganno cawagmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Paycunatami ángil nishgancunata wilaparcur cachargan Jope marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","11","Waraynin pulan junagnami Cornelio cachashgan runacuna Jope marcaman chaycargan. Pedro posädacushgan wayichönami micuyta sayrä yanucuycargan. Saymi micanaycarpis Pedro wisargan wayi jananman Tayta Diosninsita manacunanpä. Tayta Diosta manacuycashganchömi elagpita ricargan ciëlo quicharaycämogta. Saychömi ricapacorgan jatuncaray jacu-nirag uraycämogta. Say jacutaga chuscun puntanpita watashtami uräsimorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naupanman chaycuptinmi ricargan lapan mana micunapä cag uywacunata. Saychömi caycargan chuscun chaquinpa pureg tucuy casta uywacuna, lashtaypa puregcuna y vuelagcunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Saypitanami wiyargan ciëlupita: “Pedro, say uywacunata pishtarcur micuy” nimogta. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Sayno niptinmi Pedro nergan: “Manami say uywacunataga noga micömansu, taytay. Manami imaypis micushcäsu mana micunäpä nishgayqui uywacunataga.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sayno niptin yapay nimorgan: “Micunayquipä nicaptënaga ama yupaytupämaysu: ‘Say uywacunataga manami micömansu’ nishpayqui.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pedruta sayno nimorgan quimsa cutimi. Nircurnami say jacuta uywantinta ciëlupa cutisicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","“¿Imapärä cayta ricasimash?” nir yarpachacuycaptinmi Cornelio cachashgan runacuna chäyargan posädaraycashgan wayiman. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chaycuyashpannami niyargan: “Tapuculäshayqui, taytay. Simón Pedro ¿caychöcu posädaraycan?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Say hörami ricashganpita Pedro yarpachacuycargan. Sayno yarpachacuycaptinmi Santu Espíritu payta nergan: “Simón, quimsa runacunami ashiycäyäshunqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ama mansariysu paycunawan aywayta. Nogami say runacunata cachamushcä paycunawan aywanayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Sayno niptinmi jucla tincupar say runacunata Pedro nergan: “Say ashiycashgayqui runaga nogami caycä. ¿Imalapätä ashiycäyämanqui, taytacuna?” nergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Saymi paycuna niyargan: “Capitán Corneliumi cachayämash gamman shayämunäpä, taytay. Payga Tayta Diosninsi munashganno cawag ali runami. Sayno captinmi payta cuyan Israel runacunapis. Gamta gayasishunayquipäshi Tayta Diosninsipa angilnin payta nish. Wayinmanshi aywayculäshun Tayta Diosninsipa wilacuyninta yachasinayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pasa tardina captinmi Pedro paycunata posädasergan posädarashgan wayicho. Saypita waraynin tutanami Pedro aywargan Cornelio cachacushgan runacunawan. Paycunawanmi aywayargan Jopicho tag waquin wauguicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aywayashganpita warayninrämi chäyargan Cesarea marcaman. Paycuna chäyänanpämi castancunawan y cuyanacuyashgancunawanpis wayincho Cornelio shuyacuycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chaycuyaptinnami Cornelio yargamorgan payta chasquicunanpä. Nircur Pedrupa puntanman maquinta chogpacuycur gongurpacuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Saymi Corneliuta Pedro nergan: “¡Sharcuy! Nogapis gamno runalami cä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Saypitanami parlaraycar yaycuyashpan tarergan asca runacuna Corneliupa wayincho juntaraycäyagta. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Saymi Pedro nergan: “Gamcuna musyayanquimi mana Israel runacunawanga mana shuntacäyänäpä ni wayinmanpis mana chäyänäpä cashganta. Sayno caycaptinpis Tayta Diosmi tantyasimash mana Israel runacunamanpis chänäpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Saymi gayasimaptiqui jucla shamushcä. Canan nimay imapä gayasimashgayquitapis, taytay.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Saymi Cornelio nergan: “Ayunar Tayta Diosninsita manacuycaptëmi cay hörano chipipiycag mödanash runa yuripämash. Say yuripämashganpita cananwanga chuscu junagnami päsash. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yuriparcamarmi nimash: ‘¡Cornelio! Tayta Diosninsi wiyashmi manacushgayquita. Ricashmi muchogcunata yanapashgayquitapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cachacuy Jope marcaman Simonta pushamunanpä. Paypa jucag jutinmi caycan Pedro. Paymi Tayta Diosninsipa wilacuyninta tantyasishunquipä. Pedroga posädaraycan suëla rurag Simonpa wayinchömi. Suëla rurag Simonpa wayenga caycan lamarpa cuchunchömi.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sayno nimaptinmi jucla cachacamushcä pushamushunayquipä. Shamushgayquipita cushicö, taytay. Tayta Diosninsipa wilacuyninta wiyayta munarmi lapäcuna shuntacaycur caycho shuyaraycäyashcä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Saymi Pedro nergan: “Canan rasunpaypami musyä Tayta Diosninsega pï-maytapis cuyapashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Payga cuyapanmi munashganno cawag cagtaga pitapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gamcuna musyayanquimi Israel runacunata Tayta Diosninsi musyasishgan ali wilacuy ima cashgantapis. Say wilacuymi nican Jesucristuta chasquicogcunata Tayta Diosninsi perdonananpä cashganta. Jesucristoga lapan runacunapa Diosninmi caycan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jesucristo manarä wilacuptinmi Juan Bautista Galilea provinciapita-pasa runacuna bautizacuyänanpä wilacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Say wisanmi Nazaret marcapita cag Jesuspis wilacur galaycorgan. Paymanmi Santu Espirituta Tayta Diosninsi cachamorgan munayyog cananpä. Saymi marcan marcan purergan milagrucunata rurar y diablo gueshyasishgan runacunata cachacäsir. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","40","“Nogacunami ricayashcä Jerusalencho, Judea provinciacho y waquin marcacunachöpis Jesús rurashgancunata. Cruzcho wanusiyaptinpis quimsa junagtami Tayta Diosninsi payta cawarisimush. Saymi paywan tincuyashcä. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Cawarircamuptin manami lapan runacunasu paywan tincush, sinöga nogacunalami. Paywan tincuyänäpäga Tayta Diosninsimi naupapita-pasa acrayämash. Saymi wanushganpita cawarimuptin paywan juntu micur upur cayargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nircurnami lapan runacunaman Jesús cachayämash wilacuyänäpä: ‘Jesustami Tayta Diosninsi churash lapan runacunata juzgananpä. Manami cawagcunalatasu juzganga, sinöga wanushcunatapis cawarircasimur juzgangapämi.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Manami nogacunalasu Tayta Diosninsipa wilacuyninta wilacuycä, sinöga Tayta Diosninsipa unay profëtancunapis wilacuyashmi. Paycunapis cayno nirmi wilacuyargan: ‘Tayta Diosninsi cachamushgan salvadorta pipis chasquicuptenga jusancunapita perdonashmi canga.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tayta Diosninsipa wilacuyninta wilapaycaptinmi Corneliupa wayincho lapan shuntacash caycagcunaman Santu Espíritu chargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Sayno charmi paycunata juc idiömacunapa parlasergan. Sayno parlasiptinmi Tayta Diosninsi cuyapäcog cashganta cushishla lapanpis parlayargan. Sayno parlayashganta wiyarmi Pedruwan aywag Israel runacuna niyargan: “¡Mana Israel runa caycaptinpis Tayta Diosninsi paycunaman Santu Espirituta cachamush!” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Saymi paywan aywag Israel runacunata Pedro nergan: “Nogansino paycunapis Santu Espirituta chasquicuycäyaptenga jucla paycunatapis bautizashun.” ");
INSERT INTO qvhNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pedro sayno niptinmi Jesucristupa jutincho paycunata bautizayargan. Saypitanami Corneliupa wayincho juntaraycag runacuna Pedruta ruwayargan ishcay quimsa junaglapis paycunata goyäpänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mana Israel runacunapis Jesucristupa wilacuyninta chasquicuyashgantami Judea provinciacho musyayargan apostolcuna y waquin waugui-panicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Saymi Jerusalenman Pedro cutiycuptin waquin wauguicuna payta jamuräyargan: “Israel runa caycarga ¿imanirtä mana Israel runacunapa wayinman yaycushcanqui? Saynöpis ¿imanirtä paycunawan micushcanqui?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Sayno niyaptinmi paycunata Pedro wilapargan: ");
INSERT INTO qvhNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tayta Diosninsita Jope marcacho manacuycashgächömi ricargä jatuncaray jacu-nirag ciëlupita uraycämogta. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Saycho shumag ricaycunäpämi caycänä lapanpis mana micunapä cag uywacuna. Saycunaga cargan chuscun chaquinpa pureg uywacuna, chucaru uywacuna, lashtaypa puregcuna y vuelagcunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Saychömi wiyargä ciëlupita: ‘Say uywacunata pishtarcur micuy’ nimagta. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Sayno nimaptinmi nergä: ‘Manami say uywacunataga noga micömansu, taytay. Manami imaypis micushcäsu mana micunäpä nishgayqui uywacunataga.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Saymi ciëlupita yapay nimargan: ‘Sayno nish captëpis micunayquipä nicaptënaga ama yupaytupämaysu: “Say uywacunataga manami micömansu” nishpayqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Saynöga nimargan quimsa cutimi. Nircurnami say jacuta ciëlupa cutisicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Say hörami nogata ashimashpan posädaraycashgä wayiman chäyämorgan quimsa runacuna Cesarea marcapita. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Saymi Santu Espíritu nimargan mana mansariypa paycunawan aywayänäpä. Sayno nimaptinmi aywayargä cay sogta wauguicunawan. Lapämi yaycuyargä mana Israel runapa wayinman. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Saychömi wayiyog wilayämargan wayincho juc ángil yuriparcur cayno nishganta: ‘Cachacuy Jope marcaman Simonta pushamunanpä. Paypa jucag jutinmi caycan Pedro. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paymi tantyasishunquipä lapan castayquicunawan imanöpa salvacuyänayquipäpis.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Wayiyog sayno wilamaptinmi Jesucristupa wilacuyninta parlapar galaycorgä. Saycho parlapaycaptëmi nogansiman shamushgannöla paycunamanpis Santu Espíritu shamush. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Saychömi noga yarparcorgä Jesucristo cayno nimashgansita: ‘Juan Bautistaga yaculawanmi bautizargan runacunata. Tayta Diosninsimi isanga Santu Espirituwan bautizayäshunquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Say nishgannölami Jesucristuman yäracushga Santu Espirituta Tayta Diosninsi nogansiman cachamush. Nogansiman cachamushganno paycunamanpis cachaycämuptenga ¿pitä cä noga Tayta Diosninsita sapata churapänäpä?” ");
INSERT INTO qvhNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sayno wilapaptinmi waugui-panicuna Pedruta manana jamuräyargannasu. Saypa trucanga cushicuyashpan niyargan: “¡Sayno captenga mana Israel runacunatapis Tayta Diosninsi salvaycanmi!” ");
INSERT INTO qvhNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wanurcasirnami Israel runacunapa autoridänincuna Jesucristuta chasquicogcunata waquinta prësu sarircur carcilman wichgayargan. Sayno carcilman wichgayaptinmi waquin Jerusalenpita gueshpicuyargan Feniciapa, Chipripa y Antioquiapapis. Say marcacunaman chaycurmi Israel runacunalata wilapäyargan Jesucristupa ali wilacuyninta. Mana Israel runacunataga manami pitapis wilapäyargansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chipripita y Cirenipita Antioquiaman aywag runacunami isanga tantyargan Jesucristupa wilacuynin mana Israel runacunapäpis cashganta. Saymi mana Israel runacunatapis wilapäyargan Jesucristuta chasquicur salvacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sayno wilacuyänanpäga Tayta Diosninsimi yanapargan. Saynöpami jusalicuycunata cacharir Jesucristuta ascag chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Sayta wiyashpanmi apostolcuna Jerusalenpita Bernabëta cachayargan Antioquiaman saycho cagcunata yachasinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Bernabëga ali runami cargan. Saynöpis Tayta Diosninsiman yäracur Santu Espíritu munashgannömi imaypis cawag. Antioquiaman Bernabé chaycurmi ricargan runacuna Tayta Diosninsi munashganno ali cawaycäyashganta. Saymi cushicushpan paycunata shacyäsergan Tayta Diosninsiman yäracur imaypis cawayänanpä. Saycho Bernabé yachasiptinmi más asca runacuna Jesucristuta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Saypitami Tarso marcaman Bernabé aywargan Sauluta Antioquiaman pushananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Antioquiaman paywan cutiycurnami juc wata asca runacunata yachasiyashpan Bernabëwan Saulo saycho täyargan. Antioquía marcachörämi “Cristiäno” niyta runacuna galaycuyargan Jesucristuta chasquicogcunata. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Say wisanmi Tayta Diosninsipa profëtancuna aywayargan Jerusalenpita Antioquiaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Saychömi profëta Agabuta Santu Espíritu musyasergan: “Fiyupa muchuymi canga may-saychöpis” nir wilacunanpä. Sayno wilacuptinmi Jesucristuta chasquicogcuna wilanacuyargan imatapis cashganpita shuntarcur Judea provinciacho cag waugui-panicunapä apasiyänanpä. Say shuntayashgantami Bernabëwan Saulo apayargan Judea provinciaman. Saychönami mayor wauguicunata entregayargan paycunana muchuy wisan aypucuyänanpä. Agabo nishgannölami rasunpaypapis muchuy cargan. Say muchuyga cargan Romacho emperador Claudio mandashgan wisanmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Say wisanmi Jerusalencho rey Herodes Jesucristuta chasquicogcunata prësu sarisergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Saychömi apóstol Juanpa wauguin Santiaguta espädawan wanusinanpä mandargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Santiaguta wanusiptinmi Israel runacunapa autoridänincuna cushicuyargan. Saymi Levadüraynag Tantata Micunan fiesta wisan Pedrutapis prësu sarisergan wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedruta sarircasirmi Herodes wichgasergan carcilman. Carcilchömi chunca sogta (16) soldäducunata churargan chuscu-cama trucanacuypa Pedruta cuidayänanpä. Pascua ushayrä lapan runacunapa naupancho Herodes juzgananpä captinmi carcilcho wichgaräsergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Carcilcho Pedro wichgaraycaptinmi Jesucristuta chasquicogcuna Tayta Diosninsita manacuycäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Waraynin tuta juzgananpä captinmi carcilcho Pedro ishcan maquinpita cadinawan llävish punuycargan ishcay soldäducunapa chaupincho. Waquin cag soldäducunanami täpaycäyargan cárcil puncucho. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sauraga Tayta Diosninsi cachamushgan ángil elagpita asicyar Pedruta yuripargan cárcil rurincho. Riccharcasirmi nergan: “¡Apurä sharcuy, Pedro!” Niptinmi jinan höra Pedrupa maquinpita lläviraycashgan cadinacuna cachacasquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Saypitami ángil yapay nergan: “¡Wachcacurcur jucla languiquita jaticuy!” Jaticurcuptinnami ángil nergan: “¡Punchuyquitapis jaticurcur guepaläpa yargamuy!” ");
INSERT INTO qvhNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Saymi angilpa guepalanpa Pedro aywargan. Manami shumag tantyargansu rasunpaypa yarguycashganta o sueñuylancho yarguycashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ruricho cag soldäducunata y chaupi puncucho cag soldäducunata päsarcur chargan cälliman yarguna cag fiërro puncuman. Say puncu quiquilan quichacasquiptinmi yarguyargan cällimanna. Saypita juc esquïnata aywaycäyaptinmi ángil elagasquergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Saymi japalanna caycashganta tantyacusquir Pedro nergan: “Cananmi isanga rasunpaypa musyä Tayta Dios nogaman angilninta cachamushganta. Sayno cachamurmi salvamash Herodispa maquinpita y Israel autoridäcuna wanusiyämänanpä caycashganpita.” ");
INSERT INTO qvhNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Carcilpita yargushganta shumag tantyarnami Pedro aywargan Juanpa maman Mariapa wayinman. Juanpa jucag jutinmi cargan Marcos. Saychömi ascag shuntacaycur Pedrupä manacuycäyargan Tayta Diosninsita. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chaycur sawan puncuta Pedro tacacuptinmi yargamorgan Rode jutiyog jipash, pï cashgantapis ricananpä. Say jipashga cargan Mariapa yanapagninmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Manarä sawan puncuta quicharmi parlacuyninpa Pedro cashganta reguisquergan. Saymi ruriman cörriyla cutergan puncucho Pedro caycashganta wilananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wilaptinmi ruricho caycagcuna niyargan: “¿Imanöpatä pay canga? ¡Wiyapacushcanqui imacher!” Niyaptinpis: “Manami wiyapacushcäsu. ¡Rasunpaypami pay caycan!” nergan. Saymi paycuna niyargan: “Manami payga canmansu. Paypa angilnin parlamog imatacher wiyapacushcanqui.” ");
INSERT INTO qvhNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sayyäga Pedro yaparir yaparirmi puncuta tacacorgan. Puncuta quicharir payta ricaycurnami saycho cagcuna watpash ricacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Saymi maquinwan Pedro sëñargan upälacuyänanpä. Nircur wilapargan carcilpita Tayta Diosninsi imanöpa jorgamushgantapis. Saypitana nergan: “Carcilpita yargamushgäta wilayculay Santiagutawan waquin waugui-panicunatapis.” Saypita yargurir aywacorgan jucläpana. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pasa wararcuptinnami Pedruta täpag soldäducuna ima päsashgantapis mana tantyar quiquinpura tapunacuyargan: “¿Maytä Pedro?” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Carcilcho mana tariycuyashpannami soldäducunawan Herodes may-saypapis ashisergan. Mana tariycuyaptinmi täpag soldäducunatana wanusiyargan. Saypitana Herodes aywacorgan Judea provinciapita Cesarea marcacho tänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tiro y Sidón marca runacuna Herodispa contran rurash captinmi Herodes rabiacushpan say marcacunaman micuyta apayänanta munargannasu. Saymi say marcacunacho fiyupa muchuy cargan. Sayno captinmi say runacuna wilanacuyargan Herodisman parlag aywayänanpä. Manarä Herodiswan parlarmi paypa yanapagnin Blastuwan amistäta rurayargan. Paynami Herodiswan parlargan Tiro y Sidón runacunawan parlayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Saymi Herodes jitapargan juc junag Tiro y Sidón runacunawan parlayänanpä. Say jitapashgan junagmi jaticorgan más alinnin cag mödananta. Nircurnami trönunman jamaycushpan runacunata parlapämorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Parlamushganta wiyaycurmi runacuna fuertipa niyargan: “¡Cay parlaycämog runaga manami runalasu! ¡Payga Tayta Diosninsimi!” ");
INSERT INTO qvhNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Saymi: “Tayta Dioslata alabayay” ninanpa trucanga Herodes cushicorgan runacuna: “Gamga Diosmi canqui” niyaptin. Sayno Dios-tucuptinmi jinan höra Tayta Diosninsipa angilnin castigargan. Saymi curu ushaypa wanorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Saypitanami Jesucristupa wilacuyninta wilacuyaptin may-saychöpis Jesucristuta runacuna chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabëwan Saulunami waugui-panicuna shuntayashganta entregaycur Antioquiaman cutiyargan Marcos nishgan Juanta pushacurcur. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquiachömi cargan Tayta Diosninsipa profëtancuna y yachasicogcunapis. Paycuna cayargan Bernabé, “Yana Runa” nishgan Simón, Cirenipita cag Lucio, Manaén y Saulupis. Manaentami ashmayargan rey Herodistawan say wayilacho. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jesucristuman yäracogcuna ayunar Tayta Diosta alabaycäyaptinmi Santu Espíritu nergan: “Bernabëtawan Saulutami acrashcä ali wilacuyta wilacur puriyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sayno niptinmi umancunaman maquinta churaycur paycunata yanapänanpä Tayta Diosninsita manacuyargan. Nircurnami paycunata despachargan Jesucristupa wilacuyninta wilacur puriyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Santu Espíritu nishganno wilacuyänanpä aywarmi Bernabëwan Saulo chäyargan Seleucia marcaman. Marcos nishgan Juantapis paycuna pushayargan yanapänanpä. Saymi büquiman wisarcur Seleuciapita aywayargan Chipre nishgan islaman. Salamina marcaman chaycurmi sinagogacunacho wilacuyta galaycuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jesucristupa wilacuyninta wilacur intëru Chipripa puriyargan Pafos marcaman chäyashganyag. Saychömi tariyargan Israel runa Barjesús jutiyog brüjuta. Paymi: “Diospa wilacogninmi cä” nir runacunata criyisergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","8","Brüju captinmi payta Elimas niyag. Say brüjoga amistäta rurargan Chipre isla marcacunapa mandagnin Sergio Pauluwanmi. Sergio Pauloga ali yarpayyog runa carmi Bernabëtawan Sauluta gayasergan wilacuyashganta wilapänanpä. Paycuna wilapäyashganta tantyarmi Jesucristuta chasquicuyta munargan. Chasquicuyta munaptinmi say brüju payta michargan mana chasquicunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sayno michaptinmi Saulo rabianargan. Saulupanami jucag jutin cargan Pablo. Paymi Santu Espiritupa munayninwan say brüjuta nergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“¡Gamga ruraycanqui diablo munashgantami! ¡Saymi Tayta Diospa contran caycanqui! ¿Imanirtä Jesucristupa wilacuyninta runacuna chasquicuyänanta michaycanqui? ");
INSERT INTO qvhNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","¡Sayno cashgayquipitami Tayta Diospa castïgunwan gapra ricacunquipä! Saymi juc tiempuyag asicyag pasata ricanquipäsu.” Sayno niptinmi jinan höra Elimas gapra ricacorgan. Saymi ruwacorgan pilapis jancharcur wayinman pushananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sayno gaprayashganta ricarmi Sergio Paulo tantyargan Tayta Diosninsi rasunpaypa munayyog cashganta. Saymi Jesucristuta jucla chasquicorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Saypitanami büquiman wisarcur yanapagnincunawan Pablo aywayargan Pafos marcapita Panfiliacho caycag Perge marcaman. Saycho paycunata cachariycurmi Marcos nishgan Juan cuticorgan Jerusalenman. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Saypitanami Bernabëwan Pablulana aywayargan Pisidiacho cag Antioquía marcaman. Sábado jamay junag captinnami sinagogaman aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Saychömi yachasegcuna Tayta Diosninsipa palabranta liyimorgan. Nircurmi Bernabëwan Pablo jamaraycäyashgan cagman juc runata cachayargan ninanpä: “Wauguicuna, imalapis yachasimänayquipä captenga puntamanshi aywayanqui yachasiyämänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Saymi puntanman aywarcur maquinta Pablo jogarergan upälacuyänanpä. Nircurmi nergan: “Israel runacuna y mana Israel runacunapis, yachasimushgäta shumag wiyayämay. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tayta Diosninsimi Abrahamta, Isaacta y Jacobta nergan paycunapita miragcunata imaypis yanapänanpä. Say nishgannölami Egipto nacionchöna taycar Jacobpa wilcancunapita mirayargan jatun nación ricacuyashganyag. Nircurnami Tayta Diosninsi milagrucunata rurashpan Egiptupita paycunata shuntamorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Saypita chuscu chunca (40) watano sunyag jircapa puriyargan. Sayno purir Tayta Dios nishgancunata mana cäsucuptinpis Tayta Diosninsi pacenciacorganmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Saypita Canaán nacionman chaycasirnami ganchis nacioncunata ushacäsiyänanpä Tayta Diosninsi yanapargan. Saynöpami paycuna say marcancunata aypunacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","21","Egiptucho cayashganpita Canaán nacioncho marcacunata aypunacuyashganyag päsargan chuscu pachac pisga chunca (450) watanömi. “Canaáncho carnami Israel runacuna quejanacuyaptin arreglananpä Tayta Diosninsi churargan juezcunata. Saypitanami profëtan Samuel wisanna juezcuna cananpa trucanga Israel runacuna Tayta Diosninsita manacuyargan rey cananpä. Saymi rey cananpä Dios churapargan Benjamín casta Cispa surin Saulta. Paymi chuscu chunca (40) wata mandag rey cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saypitanami Saulpa trucan Davidtana churargan mandag rey cananpä. Manarä rey captin Davidpäga Tayta Diosninsi caynömi nergan: ‘Isaïpa surin Davidmi isanga munashgäno cawag runa caycan. Payga lapan nishgäcunatami cäsucongapä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Rey David castapitanami Tayta Diosninsi promitishgannöla Israel nacioncho juc salvador yurergan. Payga Jesucristumi. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesucristo manarä wilacuptinmi Israel runacunata Juan Bautista wilapargan jusancunata cacharir bautizacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nircurnami Juan Bautista nergan: ‘Manami yarpäyashgayquinösu noga salvador cä. Runacunata salvananpäga jucrämi shamonga. Nogaga manami payno munayyogsu caycä.’ Sayno nergan Jesucristo wilacur puriyta galaycunanpä caycaptinnami. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Israel runacuna y mana Israel runacunapis, shumag wiyayämay. Gamcunamanmi chämush salvacunayquipä cag ali wilacuy. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalencho tag runacuna y autoridänincunapis manami tantyayargansu salvamänansipä Jesucristuta Tayta Dios cachamushganta. Sayno tantyayargansu Tayta Diosninsipa profëtancuna Jesucristupä guelgashganta cada sábado jamay junagcho liyirpis. Mana tantyarmi paycuna Jesucristuta wanusiyargan. Sayno wanusiyaptinmi Cristuta wanusiyänanpä cashganta Tayta Diospa wilacognin profëtacuna guelgayashgannöla päsargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wanusish cananpäga manami ni ima jusantapis tariyargansu. Sayno captinpis Pilätuman entregayargan jusayogtanöpis wanusinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sayno entregayaptinmi lapanpis päsargan Tayta Diosninsipa profëtancuna guelgayashgannöla. Wanurcuptinnami payman yäracogcuna pampayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pampash caycagtanami Tayta Diosninsi cawarisimorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wanushganpita cawarircasimuptinmi asca cuti Jesús yuripargan Galileapita Jerusalenman paywan aywag discïpuluncunata. Paycunami Jesús cawarimushganta wilacuycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Saymi Bernabëwan caycho caycäyä Jesucristupa wilacuyninta gamcunata musyasiyänäpä. Canan wisanmi Tayta Diosninsi unay promitishganta cumplish Jesucristuta wanushganpita cawarisimur. Ishcay cag salmuchöpis Tayta Diosninsi Jesucristupita nergan: ‘Gamga cuyay surëmi canqui. Saymi gamta churä lapanta mandanayquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Jesucristo wanushganpita cawarimunanpä cashgantaga Tayta Diosninsi palabrancho mastapis caynömi nican: ‘Davidta promitishgäcunataga lapantami cumplishä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Say promitishganpitami Salmo libruchöpis David cayno guelgargan: ‘Cuyashgayqui cagtaga manami pamparashgalanchöga cacharinquipäsu, ni ayantapis ismunanta munanquipäsu.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Manami quiquinpäsu David sayno guelgargan. Davidga pamparashgalanchömi ismur ushacargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesuspa ayanmi isanga ismushgasu. Saypa trucanga Tayta Diosninsi payta cawarisimorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Waugui-panicuna, canan nishgäta shumag tantyacuyay. Tayta Diosninsi cawarisimushgan Jesucristuta chasquicur payman yäracuyaptiquimi jusayquicunata perdonayäshunquipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Payman yäracuyaptiqui sayno perdonayäshunquipä Moisés guelgashgan leycunata mana cumpliyta camäpacuyaptiquipis. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Jesucristuta mana chasquicogcunapäga Tayta Diosninsipa profëtancunapis caynömi guelgayargan: ‘Tayta Diosninsi nishganta mana cäsucogcuna, segaypa nacanayquipä cashganta tantyacuyay. Manami yarpanquiräsu imano nacanayquipä cashgantapis.’ ” Saymi Pabluwan Bernabé sayno wilaparcur nergan: “Cuidä profëta guelgashgancho niycashganno gamcunatapis päsayäshunquiman.” ");
INSERT INTO qvhNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Saypitanami sinagogapita lapan yarguyargan. Ali yachasish captinmi paycunata ruwacuyargan jucag cag säbadupis yapay yachasiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sinagogapita Pabluwan Bernabé aywaptinmi Israel runacuna y mana Israel runacunapis paycunawan ascag aywayargan. Paycunatami Pablo shacyäsergan cuyapäcog Tayta Diosninsiman imaypis yäracuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Saypita sábado jamay junag Pabluwan Bernabé yapay cutiptin say marcacho cagcuna cäsi lapan shuntacäyargan Jesucristupa wilacuyninta wiyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sayno shuntacäyashganta ricaycurmi Israel runacuna Pablupa contran sharcuyargan: “Pabloga lutantami yachaycäsin” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Sayno niyaptinmi Pabluwan Bernabé mana mansacuypa niyargan: “Israel mayëcuna cayaptiquimi Jesucristupa wilacuyninta puntata gamcunata wilapaycä. Sayno wilapaptëpis Tayta Diospa naupancho imayyagpis cawayta mana munarmi chasquicuyanquisu. Saymi wilapashgäta mana chasquicuyaptiqui mana Israel runacunatana wilapäyäshä. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mana Israel runacunapis Jesucristupa wilacuyninta chasquicunanpämi guelgaraycan: ‘Mana Israel runacunapäpis acsino canayquipämi gamta churashcä. Saynöpami may-saychöpis runacuna salvacuyangapä.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pabluwan Bernabé sayno parlayashganta wiyarmi mana Israel runacuna cushicuyargan, paycunapäpis salvación cashganta wiyayashpan. Saynöpami Tayta Diosninsi acrashgan cagcuna gloriacho cawayänanpä Jesucristuta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Saynöpami Jesucristupa wilacuynin wilacush cargan saycho cag lapan marcacunapa. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Saymi say marcacho cag ali ricash warmicunata y runacunatapis Israel runacuna shimita goyargan Pablutawan Bernabëta chiquiyänanpä. (Say warmicunaga sinagogacho sábado junagcuna shuntacäyag.) Sayno chiquiyashpanmi Israel runacuna Pablutawan Bernabëta garguyargan say marcacunapita. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sayno garguyaptinmi languincho caycag polvuta tapshirishpan aywacuyargan Iconio marcapana. ");
INSERT INTO qvhNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesucristuta chasquicogcunaga Santu Espíritu imachöpis yanapaptin cushishmi cawayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio marcachöna caycar Pabluwan Bernabé aywayargan sinagogaman. Saycho shonguncunaman chagpä Jesuspä wilapäyaptinmi Israel runacuna y mana Israel runacunapis Jesucristuta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Sayno chasquicuyaptinmi waquin cag Israel runacuna rabianäyashpan runacunata shimita goyargan Jesucristuta chasquicogcunata chiquiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Saychömi Pabluwan Bernabé täyarganrä. Saycho tarmi Tayta Diosninsiman yäracuyashpan pitapis mana mansacuypa Jesucristupa ali wilacuyninta wilapäyargan. Say wilacuyashgan rasunpaypa cashganta runacuna musyayänanpämi Pablutawan Bernabëta Tayta Diosninsi yanapargan milagrucunata rurayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jesucristupa wilacuyninta wilacuyaptinmi Israel runacuna paycunata chiquiyargan. Saymi waquin runacuna apostolcunapa contran sharcuyargan y waquin cagnami apostolcunapa favornin sharcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Apostolcunapa contran sharcogcunaga, Israel runacuna y mana Israel runacunapis, autoridäcunawan wilanacuyargan apostolcunata samgaypa wanusiyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Sayta musyaycurmi Pabluwan Bernabé gueshpicuyargan Licaonia provinciaman. Nircurnami Listraman, Derbiman y say provinciacho cag waquin marcacunamanpis aywar Jesucristupa wilacuyninta wilacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra marcachömi juc wegru runa cargan, yurishganpita-pasa mana pureg. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Say runami jamaraycargan Pablo parlashganta wiyar. Payta ricärirmi Pablo tantyargan aliyänanpä Tayta Diosninsiman yäracuycashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Saymi fuertipa nergan: “¡Sharcurcur shumag ichiy!” Sayno niptinmi jucla ichircushpan puriyta galaycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sayta ricaycurmi quiquincunapa idiömancho runacuna cushicuyashpan niyargan: “¡Dioscunami runa-tucular nogansiman shayämush!” ");
INSERT INTO qvhNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabëpä yarpäyargan Zeus nishgan diosnin cashganta. Y Pablupäna, wilacog captin, yarpäyargan Hermes nishgan diosnin cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Say marca yaycunachömi Zeus nishgan diosninta adoracuyänan templo cargan. Say templucho cag cürami puncuman apamorgan waytan walgash törucunata. Saycho lapan runacunawan törucunata wanusiyta munayargan apostolcunata adorayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Paycunata adorayta munayashganta tantyasquirmi Bernabëwan Pablo laquicuyashpan jatirashgan mödananta rachiriycuyargan. Saymi runacunaman aywaycur niyargan: ");
INSERT INTO qvhNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“¡Ama sayta rurayaysu! Nogacunapis gamcunano runalami cayä. Gamcunaman yachaseg shayämushcä say manacag dioscunata cacharir rasunpaypa cag Tayta Diosninsitana adorayänayquipämi. Paymi ciëlutapis, cay pasatapis, lamartapis y lapan imatapis camargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jesucristupa ali wilacuynin gamcunaman manarä chämuptinmi Tayta Diosninsi cachaparishushcanqui manacag dioscunata adorar cawayänayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Sayno captinpis tantyaycäsishunqui rasunpaypa cag Dios cashganta musyayänayquipämi. Saymi cuyapäshushpayqui tamyasimun ali cosëchata shuntar cushish cawayänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Apóstol Pablo sayno nir tantyasiptinpis ajatarämi runacuna tantyayargan Pablutawan Bernabëta mana adorayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Saypita waraynincunami apostolcunata chiqueg Israel runacuna Antioquiapita y Iconiupitapis Listraman chäyargan. Say runacunami shimita goyargan Pablupa contran sharcuyänanpä. Paycuna niyashganta chasquiparmi runacuna Pabluta samgayargan pitegpä. Nircur wanushgana cashganta yarparmi garachashga apaycur marca cuchunman jitasquiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Saymi Jesucristuta chasquicogcuna Pablo jitaraycashgan cagman shuntacäyargan ayanta shuntayänanpä. Sayno juntaparaycäyaptinmi cawarircamurna marcaman cutergan. Saypita warayninna Bernabëwan aywacuyargan Derbe marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbiman chaycurnami Jesucristupa wilacuyninta wilacuyargan. Sayno wilacuyaptinmi asca runacuna Jesusta chasquicuyargan. Nircurnami cutiyargan Antioquía, Listra y Iconio marcacunaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Say marcacunaman charmi Jesucristuta chasquicogcunata shacyäsiyargan Tayta Diosninsiman mana ajayaypa yäracuyänanpä. Saynöpis tantyasiyargan Diospa naupanman manarä chaptin runacuna chiquiyänanpä cayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Saynöpis cada marcacho mayor wauguicunata churayargan waugui-panicunata saycho yachasiyänanpä. Nircurnami ayunayashpan Tayta Diosninsita manacuyargan paycunata yanapäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia provinciapita aywacurmi Panfilia provinciamanna chäyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Saychönami Perge marcachöpis Jesucristupa wilacuyninta yapay wilacuyargan. Nircurna aywayargan Atalia marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Saypitanami büquiwan Antioquiaman cuticuyargan. Saychömi yapay shuntacäyargan waugui-panicunawan. Say waugui-panicunami Tayta Diosta manacurir Pabluta y Bernabëta naupata cachargan may-saypapis wilacur puriyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquía marcaman charnami waugui-panicuna shuntacaptin cushish wilapäyargan: “¡Wilacuyninta wilacuyänäpä Tayta Diosninsi alimi yanapäyämash! ¡Saymi mana Israel runacunapis Jesucristuta chasquicuyash! ¡Paycunapis cananga Tayta Diosmannami yäracuycäyan!” nir. Sayno wilayaptinmi wiyagcunapis fiyupa cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pabluwan Bernabé saycho asca quilami waugui-panicunata yachasir täyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Say wisanmi Judea provinciapita Antioquiaman waquin wauguicuna aywayargan. Chaycurmi waugui-panicunata cayno yachasiyargan: “Moisés guelgashgan leycunata cumplir cuerpuyquita señalacurrämi salvacuyanquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Sayno yachasiyaptinmi Pabluwan Bernabé paycunata michäyargan sayno mana yachasiyänanpä. Saymi say yachasicogcuna Pabluwan Bernabëwan fiyupa rimanacuyargan. Sayno rimanacuyaptinmi Antioquía waugui-panicuna Pablutawan Bernabëta niyargan: “Saypita wilanacuyänayquipä mejor aywayay Jerusalenman. Saychönami apostolcunawan y mayor wauguicunawanpis shumag parlayanqui señalacunansipä o mana señalacunansipä cashgantapis.” Sayno niyashpanmi waquin wauguicunatapis acrayargan paycunawan Jerusalenman aywayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jerusalenpa aywarmi Fenicia y Samaria provinciacunamanpis chäyargan. Sayman charmi wilacuyargan mana Israel runacunapis Tayta Diosninsita chasquicuyashganta. Sayno wilapäyaptinmi waugui-panicuna cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalenman chäyaptinnami Pablutawan Bernabëta chasquicuyargan apostolcuna, mayor wauguicuna y saycho cag lapan waugui-panicunapis. Paycunatami Pabluwan Bernabé wilapäyargan may-saychöpis Tayta Diosninsi yanapashganta. Saynöpis wilapäyargan mana Israel runacunapis salvacuyänanpä Jesucristuta chasquicuyashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Saymi Jesucristuta chasquicog fariseo runacuna niyargan: “Manami paycuna salvacuyangasu Moisespa leynincunata mana cumplir. Saynöpis manami salvacuyangasu cuerpunta mana señalacorga.” ");
INSERT INTO qvhNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sayno niyaptinmi apostolcuna y mayor wauguicunapis shuntacäyargan say nishganpita wilanacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Saycho waquin cag wauguicuna parlayämushganta wiyarmi Pedro nergan: “Wauguicuna, musyayanquimi mana Israel runacunata wilapänäpä Tayta Diosninsi cachamashganta. Sayno cachamash paycunapis wilacuyninta chasquicur salvacuyänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Cachamashgannöla mana Israel runacunata wilapaptëmi paycunapis Jesucristuta chasquicuyash. Rasunpaypa chasquicushganta musyarmi Tayta Diosninsi Santu Espirituta paycunamanpis cachamush. Nogansi chasquicushgansinölami paycunapis Santu Espirituta chasquicuyash. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Saynöpami musyansi Jesucristuta chasquicog cagta, Israel runa captinpis mana Israel runa captinpis, Tayta Diosninsi perdonar salvashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sayno caycaptenga shumag yarpachacuyay. Mana Israel runacunata ama obligashunsu Moisés guelgashgan leycunata cumpliyänanpä. Saycunataga unay Israel runacuna ni quiquinsipis manami cumpliyta puëdishcansisu. Mana Israel runacunata Tayta Diosninsi salvashganta ¿imanirtä manacagman churayta munayanqui? ");
INSERT INTO qvhNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","¡Manami Moisés guelgashgan leycunata cumplishgansipitasu Tayta Diosninsi salvamansi, sinöga Señorninsi Jesucristuta chasquicushgansipitami cuyapämashpansi salvamansi Israel runa cashgapis mana Israel runa cashgapis!” ");
INSERT INTO qvhNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pedro sayno niptinmi saycho cag runacuna lapan upälacuyargan. Saynami Pabluwan Bernabé wilapäyargan Tayta Diosninsi yanapaptin mana Israel runacuna cagchöpis milagrucunata rurayashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sayno wilapayta ushasquiyaptinmi Santiago nergan: “Wauguicuna, wiyayämay. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro wilamashcansi mana Israel runacunatapis cuyapashpan Tayta Diosninsi salvashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pedro wilamashgansinölami unay profëtancunawanpis Tayta Diosninsi wilacasergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Israel nacioncho Davidpa castan rey mana captinpis juctami paypa castanpita churashä rey cananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Sayno rurashäpä Israel runacunapis y mana Israel runacunapis nogaman yäracayämänanpämi. Sayno ruraptëmi lapan acrashgä cag runacuna salvacuyangapä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sayno päsananpä cagtami Tayta Diosninsi unaypita-pasana saycunata musyasimashcansi.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sayta yarparcasirmi Santiago mastapis nergan: “Tayta Diosninsi palabrancho sayno nicaptenga imatapis ama sapata churapäshunsu mana Israel runacunapis Jesucristuta chasquicuyänanpä. Saynöpis ama obligashunsu Moisés guelgashgan leycunata cumpliyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Imano captinpis Israel waugui-panicunawan mana Israel waugui-panicuna ali ricanacuyänanpä cartacushun. Say cartacho mana Israel waugui-panicunata wilashun ïdulucunapa jutincho pishtashgan aysata mana micuyänanpä, runacuna chinëru mana cayänanpä, warmicunapis mana waynäcuyänanpä, mana pishtaypa wanush uywacunapa aysanta mana micuyänanpä y uywapa yawarnintapis mana upuyänanpä ni micuyänanpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Saycunata cumpliyänanpäga sinagogacunachömi Moisés guelgashgan leycunata cada sábado jamay junag yachaycäsiyan.” ");
INSERT INTO qvhNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Sayno niptin apostolcuna, mayor wauguicuna y waquin waugui-panicunapis ishcay wauguicunata acrayargan Pabluwan Bernabé Antioquiaman cutiyaptin saycho cag waugui-panicunata imata wilanacuyashgantapis wilayänanpä. Say wauguicunami cayargan Judaswan Silas. Judaspa jucag jutinmi cargan Barsabás. Judastawan Silastami lapan waugui-panicunapis cuyashpan respitayag. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawanmi cartacuyargan Antioquiacho cag waugui-panicunaman. Say cartatami cayno guelgayargan: Antioquía marcacho cag waugui-panicuna y Siria y Cilicia provinciacunacho cag waquin waugui-panicunapis: Apostolcuna y mayor wauguicuna carmi gamcunapä salüdöta apasiyämö. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nogacuna musyayashcä waquin wauguicuna gamcuna cagman shamur lutanta yachasiyäshushgayquitami. Paycunataga nogacuna manami cachayämushcäsu. Mana cachaycäyämuptëpis paycunaga gamcunata pantacäsir lutantashi yachasiyäshushcanqui: “Salvacuyänayquipäga cuerpuyquitarä señalacuyay. Saynöpis Moisés guelgashgan leycunatarä cumpliyay” niyäshushpayqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","Sayta musyarmi lapä wilanacuyashcä gamcuna cagman Judasta y Silasta cachayämunäpä. Paycunami tantyasiyäshunqui cay cartacho guelgaraycashgancunata. Pabluwan Bernabëwanmi paycuna shayämonga. Pabluwan Bernabëmi wanuytapis mana mansaypa may-saychöpis Jesucristupa wilacuyninta wilacuycäyan. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Santu Espiritumi tantyasiyämashga cuerpuyquita mana señalacurpis salvacuyashgayquita. Saymi wilanacuyashcä salvashgana caycarga ïdulucunapa jutincho pishtashgan aysata mana micuyänayquipä, ima uywapa yawarnintapis mana upuyänayquipä, jurcacaypa wanush uywacunapa aysanta mana micuyänayquipä, runacuna chinëru mana cayänanpä y warmicunapis mana waynäcuyänanpä. Cay cartacho nishgäcunata cumpliyaptiquega alimi canga. Saylatami niyämö cay cartacho. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Say wilanacuyashgannölami say chuscun wauguicuna aywacuyargan Antioquiaman. Sayman chaycurmi waugui-panicunata shuntayargan apayashgan cartata liyipäyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Say cartata liyipäyaptinmi lapan cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judaswan Silaspis Tayta Diosninsipa profëtancunami cayargan. Saymi waugui-panicunata shumag tantyasir shacyäsiyargan Tayta Diosninsi munashganno imaypis cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Saycho goyarcuyaptinnami Tayta Diosta agradëcicuyashpan waugui-panicuna Judastawan Silasta despachayargan Jerusalenman cuticuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sayno captinpis Silasmi isanga shumag yarpachacurir Antioquiacho quëdacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pabluwan Bernabëpis Antioquiachömi quëdacuyargan. Saychömi waquin wauguicunawan Jesucristupa ali wilacuyninta yachasir täyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Saypita asca quilatanami Bernabëta Pablo nergan: “Acu cutishun Jesucristupa wilacuyninta wilacushgansi cag marcacunaman waugui-panicunata watucamunansipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Sayno wilanacurmi Bernabé pushayta munargan Juanta. Juanpa jucag jutinmi cargan Marcos. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablumi isanga Marcusta pushayta munargansu, punta cag aywaynincho Panfiliapita cachariycur cuticush captin. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Saymi Pabluwan Bernabé say janan rimanacuyargan. Sayno rimanacurcurnami Marcusta pushacurcur büquiwan Bernabé aywargan Chipriman. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablunami Silasta pushacurcur aywargan wilacuyashgan marcacunaman. Saypa aywayänanpämi waugui-panicuna Jesucristuta manacuyargan paycunata yanapänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria y Cilicia provinciacunacho cag marcacunaman charmi Pabluwan Silas waugui-panicunata shacyäsiyargan Tayta Diosninsi munashganno shumag cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Saypita Derbe y Listra marcacunaman Pabluwan Silas chäyargan. Listra marcachömi Timoteuwan reguinacuyargan. Timoteupa taytan mana Israel runa captinpis mamanga Israel warmimi cargan. Saynöpis Timoteupa mamanga Jesucristuta chasquicushmi cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra y Iconio marcacunacho tag waugui-panicuna lapanpis parlayargan Timoteo ali magta cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Timoteupa taytan mana Israel runa captinmi Israel runacuna musyayargan Timoteupa cuerpun mana señalash cashganta. Saymi walquinanpä Pablo pushayta munar Israel runacuna mana jamuräyänanpä Timoteupa cuerpunta señalasergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Saypita quimsanna marcan marcan aywayargan Jesucristupa wilacuyninta wilacuraycar. Marcan marcan charmi apostolcuna y mayor wauguicuna apasiyashgan cartata liyipashpan waugui-panicunata shacyäsergan cartacho guelgashgannöla lapantapis cumpliyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sayno tantyasiyaptinmi waugui-panicuna fiyupa cushicuyargan. Saymi waran waran runacuna Jesusta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Saypitami Pablo walquegnincunawan Asia provinciaman aywayta munayargan Jesucristupa ali wilacuyninta wilacuyänanpä. Sayno yarpaptinpis Santu Espíritu manami saypa aywayänanta munargansu. Saynami Frigia y Galacia provinciacunacho cag marcacunaman chaycuyashpan Jesucristupa wilacuyninta wilacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia provinciaman chaycurnami aywayta yarpäyargan Bitinia provinciapa. Saychöpis Santu Espíritu manami munargansu saypa aywayänanta. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misia provinciapa päsarmi chäyargan Troas marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Saychönami sueñuynincho Pablo ricargan Macedonia provinciapita juc runa gayacaycämogta: “Cayman simpaycalämuy nogacunata yanapäyämänayquipä, taytay” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo sayno ricashganta wilayämaptinmi tantyayargä say marcacunamanpis wilacuyninta chäsiyänäpä Tayta Dios munashganta. Saymi jucla puestucuyargä Macedoniaman aywayänäpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas marcapita büquiwan aywar chäyargä Samotracia islaman. Saypita waraynin junagrämi chäyargä Neápolis marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Saypitana Macedonia provinciaman aywar chäyargä Filipos marcamanpis. Say marcaga cargan Roma runacuna täyashgan marcami. Say marcachömi nogacuna juc ishcay junag goyäyargärä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Saycho goyarmi yarpäyargä Tayta Diosninsita manacuyänanpä Israel runacuna sábado jamay junag captin mayu cuchuncho shuntacäyashganta. Sayman aywarmi tariyargä shuntacash caycag warmicunata. Paycunatami Jesucristupa ali wilacuyninta wilapäyargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Say warmicunawanmi caycänä Tayta Diosninsiman yäracog Lidia jutiyog warmipis. Payga Tiatira marcapita carmi morädo fïnu tëlacunata ranticog. Jesucristo salvamagninsi cashganta Pablo wilapaptinmi Lidia shumag tantyacur Jesucristuta chasquicorgan. Sayno chasquicunanpäga Tayta Diosninsimi payta tantyasergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Saypita Lidiapa castancunapis Jesucristuta chasquicuyaptinmi paycunata bautizayargä. Nircurnami nogacunata Lidia ruwacayämargan: “Nogapis Jesucristuta chasquicushgana caycaptëga wayëman aywayculäshun, taytay, saycho goyäpäyämänayquipä” nir. Sayno niyämaptinmi posädacuyargä paypa wayinchöna. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Juc cutimi Diosta manacuyänäpä cagman aywaycashgächo tincuyargä supaypa munayninwan adivinag jipashwan. Say jipash adivinaptinmi patronnincuna asca guellayta gänayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Say jipashmi nogacunata gatiräyämargan: “¡Cay runacunaga munayyog Tayta Dios munashganno cawagmi! ¡Paycunami gamcunata tantyasiyäshunquipä imano salvacuyänayquipä cashgantapis!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Sayno waran waran büllata rurar gatiräyämaptinmi Pablo rabiacushpan jipashcho caycag supayta nergan: “¡Jesucristupa jutinchömi gamta gargö cay jipashpita yargunayquipä!” Sayno niptinmi jinan höra say jipashpita supay yargorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Saymi say jipashpa patronnincuna guellayta mana gänayänanpä captinna prësu sariyargan Pablutawan Silasta. Nircurna autoridäcunaman apayargan pläzacho lapan runacunapa naupancho juzgayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","22","Autoridäcunaman apayaptinmi asca runacunapis paycunata gatiräyargan. Chaycasirmi Pabluta tumpayashpan niyargan: “Cay Israel runacunami marcansicho yachaycäsin Israel runacunapa costumbrincunata rurayänanpä. Nogansega Roma runa cashpansi manami say costumbricunataga chasquipashwansu. Sayno yachasiptinmi runacuna fiyupa rabiash caycäyan.” Sayno niyaptinmi saycho caycag runacunapis paycunapa contran sharcuyargan. Saymi autoridäcunapis Pablupa y Silaspa janan cag mödananta logtirir fiyupa wirusiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sayno wirurcasirnami paycunata carcilman wichgasiyargan. Nircurna prësucuna cuidag runata nergan: “Mana gueshpiyänanpä paycunata seguro llävinqui.” ");
INSERT INTO qvhNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Sayno niyaptinmi wichgargan más ruri cag calapösuman. Nircurmi chaquincunata “cëpo” nishgan racta tablapa ishcay uchcuncunaman jatergan mana yargunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Saypita pulan pagasno caycaptinmi Pabluwan Silas Tayta Diosninsita manacurir cantayargan. Sayno cantayashgantaga waquin cag prësucunapis wiyayarganmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sayno cantaycäyaptinmi elagpita fiyupa pasa sucsucyar carcilta cuyusergan. Saynöpis lapan puncucuna jucla quichacäcorgan y prësucuna wataräyashgan cadinacunapis pascacäcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Saymi prësucunata cuidag runapis pasa sucsucyaptin riccharcamunanpäga puncucuna quichacash caycäyargan. Saymi prësucuna gueshpicuyashganta yarpar espädanta jorgurir quiquin wanusicuyta munargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sayno wanusicuyta munaptinmi Pablo fuertipa nergan: “¡Ama wanusicuysu! ¡Caycho lapämi caycäyä!” ");
INSERT INTO qvhNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Saymi prësucunata cuidag runaga acsicurcur carcilman cörrila yaycorgan. Pabluwan Silas caycäyashganman chaycur sucsucyashpan puntanman gongurpacuycorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nircurna carcilpita paycunata jorgurir taporgan: “¿Imatarä ruräman salvacunäpä, taytacuna?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Sayno tapuptinmi Pabluwan Silas niyargan: “Señor Jesucristuta chasquicuy. Sayno chasquicurmi gam salvacunquipä. Gam chasquicuptiquega wayiquicho tagcunapis chasquicuyashpan salvacuyangapämi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nircurnami say runata y wayincho caycagcunatapis tantyasergan Jesucristupa ali wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Saymi prësucunata cuidag runaga Pablutawan Silasta jampergan garanpis pashtagpä runacuna wiruyashganta. Nircurnami Jesucristuta chasquicushpan paypis y wayincho tagcunapis jucla bautizacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Saypita wayinman pushaycur micuyta garargan. Jesucristuta chasquicur Tayta Diosninsiman yäracuyashpanmi wayincho tagcunawan fiyupa cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Waraynin tutanami autoridäcuna wardiacunata cachayargan prësucuna cuidag runaman, Pablutawan Silasta cacharinanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Saymi prësucunata cuidag runa Pabluta wilargan: “Autoridäcuna wilacasiyämush gamcunata cacharinäpämi. Cananga aywacuyanquinashi” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Saymi wardiacunata Pablo nergan: “Roma runa caycaptëpis lapanpa naupancho mana tapupämaylapa nogacunata wirusiyämash. Sayno mana tapupämaylapami cay carcilman wichgasiyämash. ¿Sayno wirurcasimarcu carcilpita pacaylapa gargasimayta munaycäyan? ¡Quiquincunarä shayämusun caypita jorgayämänanpä!” ");
INSERT INTO qvhNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","39","Sayno niptinmi wardiacuna autoridäcunaman cutiycuyashpan wilayargan Pabluwan Silas Roma runacuna cayashganta. Sayta musyaycurmi autoridäcuna mansariyashpan aywayargan Pabluwan Silas wichgaraycashgan cagman. Chaycurnami niyargan: “Roma runa cashgayquita mana musyarmi castigasiyashcä, taytay. Sayno castigasiyashgäpita perdonaycayälämay.” Nircurnami carcilpita jorgurir paycunata autoridäcuna ruwacuyargan say marcapita aywacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Saypitanami Pabluwan Silas aywayargan Lidiapa wayinman. Saychömi waugui-panicunata shacyäsergan Tayta Diosman imaypis yäracuyänanpä. Nircurnami Filipos marcapita aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Saypita Anfípolis y Apolonia marcacunapa päsar Pabluwan Silas Tesalónica marcaman chäyargan. Saychömi sinagoga cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Saymi sinagogaman imaypis aywashganno Pablo say sinagogamanpis aywargan. Saychömi quimsa sábado yachasergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Palabranchöga Tayta Diosninsi nimansi salvamagninsi wanunanpä cashganta y nircur cawarimunanpä cashgantami. Say guelgarashgannölami wanushganpita Jesusga cawarimush. Saynöpami musyansi salvamagninsi Cristo cashganta. Saycunatami noga wilacur puriycä” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sayno yachasiptinmi waquin Israel runacuna, waquin mana Israel runacuna y waquin rïca warmicunapis Jesucristuta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Israel runacunapa autoridänincunami isanga fiyu runacunata shuntaycur shimita goyargan Pablupa y Silaspa contran sharcuyänanpä. Say fiyu runacunanami asca runacunata shuntarcur Jasunpa wayinman rabiash aywayargan Pablutawan Silasta prësu sariyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Saycho mana tariycurna Jasuntawan waquin wauguicunatana autoridäcunaman garachashga apayargan. Paycunami levantayargan: “¡Pablo y paywan pureg runacunami may-saychöpis lutanta yachaycäsin! ¡Cananga nogansimanna shayämush lutanta yachasimänansipä! ");
INSERT INTO qvhNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Jasunmi say runacunata wayinman posädasish! ¡Say runacunaga niyan Romacho mandamagninsi emperadorpitapis Jesús jutiyog runa más munayyog rey cashgantami! ¡Sayno niyashpanmi leyninsicunataga cäsucuyannasu!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sayno niyaptinmi saycho cag runacuna y autoridäcunapis fiyupa rabiacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Sayno rabiacuyaptinpis Jasunwan waquin cag wauguicuna guellayta garantía churaycur yarguyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Say sacaymi Pablutawan Silasta waugui-panicuna cachayargan Berea marcaman. Bereaman chaycurmi sábado jamay junag aywayargan sinagogaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea marca runacunaga manami Tesalónica marcacho runacunanösu cayargan, sinöga Jesucristupa wilacuyninta cushishmi chasquicuyargan. Sayno carmi waran waran Pablo yachasishgancunata Tayta Diosninsipa palabranman tincusiyargan rasun cagta yachaycäsishganta musyayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Say marcachöga Jesucristuta ascagmi chasquicuyargan, Israel runacuna y mana Israel runacunapis. Saynömi chasquicuyargan mana Israel rïca warmicunapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Berea marcachöna Pablo yachaycäsishganta wiyarmi Tesalónica marcacho contran cag runacuna Bereaman aywayargan saychöpis Pablupa contran sharcuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Saymi waugui-panicuna Pabluta gueshpisiyargan lamar cuchunman jucläpa aywacunanpä. Silaswan Timoteunami Bereacho quëdacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lamarpa cuchunman chaycurmi walquegnincuna Pabluta pushayargan Atenas marcaman. Saypitana Bereaman cutiyargan Silastawan Timoteuta Pablo cagman jucla cachayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","17","Atenas marcacho Silastawan Timoteuta shuyacushganyagmi sinagogaman Pablo aywargan. Saychömi Israel runacunata y mana Israel runacunatapis tantyasergan Jesucristo pï-maytapis chasquicogcunataga salvananpä cashganta. Saynöpis Atenas marca cällicunapa puriycashgancho Pablo ricargan asca ïdulucuna caycagta. Sayta ricarmi Pablo fiyupa laquicorgan. Saymi pläzacho caycag runacunata tantyasergan Jesucristuta chasquicur Tayta Dioslatana adorayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pläzachömi Epicúrio nishgan y Estoico nishgan yachag runacuna imaypis shuntacäyag. Saymi paycunatapis Pablo tantyasergan Jesucristupa ali wilacuyninta. Saynöpis wilapargan wanushcuna cawariyämunanpä cayashganta. Saycunapita tantyasiptinmi waquin runacuna niyargan: “Cayga yachag-tucushpan ¿imatarä parlacunpis?” Y waquinna niyargan: “Cayga mana reguishgansi dioscuna imapitacher parlapaycämansi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Sayno nirmi Pabluta pushargan yachag runacuna shuntacäyashgan Areópago nishganman. Saychömi wilanacuyänanpä mayor runacuna imaypis shuntacäyag. Say runacunami Pabluta niyargan: “Gam yachaycäsinqui imaypis mana wiyayashgätami. Say yachaycäsishgayquita nogacunapis shumag musyaytami munayä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atenas runacunaga y saycho tag jäpa runacunapis mushog yachasicuy captenga shumag mayaytami munayag. Nircurmi waran waran say wiyashgancunalapita parlayag.) ");
INSERT INTO qvhNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Saymi yachasishganta wiyayta munayaptin Pablo nergan: “¡Atenas runacuna! Asca dioscunata adorayänayquipä capillancunata rurayashgayquitami ricashcä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Capillacunata ricapacur puriycashgächömi ricashcä juc capillacho guelgaraycagta: ‘Cay capillaga mana musyashgansi diospämi’ nir. Cananga mana musyaycarpis say adorashgayqui Dios pï cashgantapis gamcunata tantyasiyäshayqui. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Paymi cay pasata y lapan imaycatapis camash. Ciëlutapis y cay pasatapis munaynincho sarararmi runa rurashgan capillacho tansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Paymi cawanansipä jämaytapis gomansi. Saynölami cawanansipä nistashgansicunatapis puestupämansi. Manami nogansisu payta imatapis puestupansi, sinöga paymi nogansita lapantapis puestupämansi. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Juc runalata camashganpitami ascaman mirashcansi. Paymi destinamashcansi maycho tänansipä y imay wanunansipäpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","28","Cananpis pay mana yanapämashgaga manami cawashwansu. Sayno captenga manami ajasu caycan Dios cashganta tantyacunansipä. Marca mayiquipis shumag yarpachacurir cayno nirmi unay guelgargan: ‘Lapansitapis Tayta Diosninsimi camamashcansi.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Sayno caycaptenga ama yarpäshunsu goripita, guellaypita, o rumipita rurashgan ïdulucunano Tayta Dios cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ïduluno cashganta runacuna yarpäyaptinpis naupataga manami castigargansu. Cananmi isanga lapan runacunata nican ídolo adorayta cacharir pay munashgannöna cawayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pay munashganno mana cawagcunata juc junag juzgananpämi juc runata churash. Say runa pï cashgantapis musyanansipämi wanushganpita cawarisimush.” ");
INSERT INTO qvhNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wanushganpita cawarimushganta Pablo niptinmi waquin runacuna burlacur asipäyargan. Waquin runacunanami niyargan: “Yapaypis cutiycalämunqui, taytay, mastapis tantyasiyämänayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Saypitanami say mayor runacuna shuntacäyashganpita Pablo aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sayno captinpis juc ishcay runacunalami Pablo wilapashgancunata chasquicuyargan. Paycunachömi Areopagucho shuntacag autoridä Dionisio jutiyog runapis cargan. Nircur Dámaris jutiyog warmi y más waquin cagpis Pablo wilacushganta chasquicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Atenas marcapita aywacurmi Corinto marcamanna Pablo chargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Saychömi Aquila jutiyog Israel runawan reguinacuyargan. Aquilaga Ponto nishgan provinciacho yureg runami cargan. Payga Romacho tashganpitami warmin Priscilawan sayrä Corinto marcaman chäyash caycäyargan. Sayman aywacuyargan lapan Israel runacunata Romapita emperador Claudio garguptinmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Priscilawan Aquilami toldëra rurayta yachayargan. Pablupis toldëra rurayta yacharmi paycunawan targan toldërata rurayashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cada sábado jamay junagmi sinagogaman Pablo aywargan. Saychömi Israel runacunata y mana Israel runacunatapis yachasergan Jesucristuta Tayta Diosninsi salvamänansipä cachamushganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia provinciapita Silaswan Timoteo chäyaptinnami Pabloga aruyninta cachaycur waran waran Jesucristupa wilacuyninta wilacorgan. Wilacurmi Israel mayincunata tantyasergan runacunata salvananpä Jesucristo shamushganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Saymi Israel runacuna Pablupa contran sharcuyashpan payta tucuyta ashliyargan. Saymi mödananta tapshirishpan Pablo nergan: “Jesucristuta mana chasquicuyashpayquimi quiquiquicuna jusayog caycäyanqui Tayta Diosninsi infiernuman gaycushunayquipä. Jesucristupa wilacuyninta wilapashgächönaga manami jusayognasu cä. Gamcuna chasquicuyta mana munayaptiquimi mana Israel runacunamanna aywashä Jesucristupa wilacuyninta wilapänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Sayno nirmi say sinagogacho yachasinanpa trucanga Pablo aywargan Ticio Justupa wayinman saychöna yachasinanpä. Justoga mana Israel runa caycarpis Tayta Diosninsi munashganno cawag runami cargan. Paypa wayenga cargan sinagogapa naupalanchömi. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Saycho yachasiptinmi sinagogapa mandagnin Crispo jutiyog runa wayincho tagcunawan Jesucristuta chasquicuyargan. Jesucristuta Crispo chasquicushganta wiyaycurmi Corinto marcacho waquin runacunapis Jesucristuta chasquicur bautizacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Juc sacaymi Pabluta yuriparcur Jesucristo nergan: “Mana mansapaypa pitapis wilacuynëta wilapay. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mana cachaypami gamta yanapaycä cay marcacho imapis mana päsashunayquipä. Nogata chasquicamänanpäga asca runacunami caycäyan cay marcacho.” ");
INSERT INTO qvhNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Sayno niptinmi Corinto marcacho Pablo targan juc wata sogta quilantin, Jesucristupa ali wilacuyninta yachasishpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galión jutiyog runa Acaya provinciapa mandagnin canan wisanmi Pabluta sarircur Israel runacuna apayargan Galionpa despächunman. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Saychömi paycuna niyargan: “Cay runaga Romacho mandamagninsi emperador mana munashgan religiontami yachaycäsin. Saymi payta gamman apayämushcä lutanta yachasishganpita castiganayquipä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo parlananpä caycaptin Israel runacunata Galión nergan: “Cay runa leyninsicuna niyashganta rasunpaypa mana cäsuptenga nimashgayquicunata chasquëmanmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Costumbrilayquicunapita rimanacuyaptiquega manami imatapis musyayta munäsu. Say rimanacuyashgayquitaga quiquiquicuna arreglacuyay.” ");
INSERT INTO qvhNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Sayno nirmi paycunata despächunpita gargorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Paycunawanmi caycargan sinagogapa mandagnin Sóstenes. Israel runacunata garguptinmi despächo puncucho mana Israel cag runacuna chiquishpan Sóstenesta magayargan. Despächo puncucho magayaptinpis Galionga manami washargansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Saypita asca quilarämi Pablo targan Corinto marcacho. Nircurnami waugui-panicunapita despidicur Cencrea marcaman aywargan. Saychönami agsanta rutucorgan Tayta Diosninsita promitishganta cumplinanpä. Saypitanami Priscilawan y Aquilawan Siria provinciaman büquiwan aywayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso marcaman chaycurmi sinagogaman aywargan Jesucristo salvamagninsi cashganta wilacunanpä. Saypitanami Priscilatawan Aquilata cachaycur Efesupita Pablo aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Sayno aywacuycaptinmi say sinagogacho shuntacag runacuna Pabluta ruwacuyargan paycunata goyäpänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Sayno ruwacuyaptinpis Pablo despidicorgan: “Cananga Pascuapämi Jerusalenman imaycanöpis chayta munaycä. Tayta Dios munaptenga yapaymi cutimushä.” Sayno nishpanmi büquiwan Efesupita Pablo aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea marcaman charna Jerusalenman aywargan saycho cag waugui-panicunata watucananpä. Saypitana aywargan Antioquía marcaman saycho tänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Saycho tarcurnami Galacia y Frigia provinciacunapa yapay aywargan marcan marcan, waugui-panicunata Jesucristupa wilacuyninta yachasishpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","25","Say wisanmi Efeso marcaman chargan Apolos jutiyog Israel runa. Payga cargan Alejandría marcapitami. Tayta Diosninsipa palabranta ali yacharmi churaypa churar runacunata shumag yachaseg. Sayno captinpis Jesucristupita Juan Bautista wilacushgalantami payga musyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Sinagogachömi Jesucristupita Apolos pitapis mana mansapaypa wilacorgan. Juan Bautista yachasishgancunalata Apolos yachasiptinmi Priscilawan Aquila wayinman pushaycur Jesucristupita masta tantyasiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Saypita Acaya provinciaman Apolos aywayta yarpaptin waugui-panicuna shacyäsiyargan saypa aywananpä. Saymi cartacorgan Acayacho cag waugui-panicuna Apolos chaptin ali chasquicuyänanpä. Sayman chaycurna waugui-panicunata shumag tantyasergan Jesucristupa ali wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Saynöpis Israel runacunata tantyasergan Tayta Diosninsipa palabrancho Jesuspä guelgaraycashgancunata. Saynöpami tantyasergan Jesusga salvamagninsi Cristo cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Corintucho Apolos caycaptinmi Antioquiapita Pablo chaquilapa aywargan Efesuman. Chaycurmi tarergan Juan Bautista yachasishganta chasquicogcunata. Paycunatanami nergan: “¿Gamcunaga Santu Espirituta chasquicuyashcanquicu?” Sayno tapuptinmi paycuna niyargan: “Manami imaypis mayayashcäsu Santu Espíritu cashgantaga.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Saymi Pablo yapay taporgan: “Sayno captenga ¿pipa yachasicuynintatä wilapäshushcanqui bautizacuyänayquipä?” Sayno niptinmi niyargan: “Juan Bautistapa yachasicuynintami wilapäyämash bautizacuyänäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Saymi Pablo nergan: “Juan Bautistaga runacunata bautizargan jusancunata cacharir Dios munashganno cawayänanpämi. Nircurmi paycunata yachasergan Jesucristo shamuptin payman yäracuyänanpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pablo sayno niptinmi say wauguicuna Jesucristupa jutincho bautizacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nircurnami paycunapa umanta yataycur Tayta Diosninsita Pablo manacorgan. Say hörami Santu Espirituta lapanpis chasquicuyargan. Saymi juc idiömacunapa parlayashpan Tayta Diosninsi tantyasishgancunata parlargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Say wauguicuna chunca ishcaynömi (12) cayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Efesucho tarmi quimsa quila Pablo aywargan sinagogaman. Saychömi runacunata shumag tantyasergan Jesucristupa ali wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","10","Sayno yachasiptinpis waquin runacunaga manami chasquicuyta munayargansu. Chasquicuyta mana munarmi paycunaga runacunata shimita goyargan Pablo yachasishganta mana chasquicuyänanpä. Sayno cayaptinmi waugui-panicunawan Tiranno jutiyog runapa escuëlanman Pablo aywargan. Saychönami ishcay wata waran waran yachasergan. Saynöpami Asia provinciacho tagcuna, Israel runa carpis y mana Israel runa carpis, wiyayargan Jesucristupa wilacuyninta. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Saychömi Tayta Dios yanapaptin milagrucunatapis Pablo rurargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Saymi runacuna pañuëlunta o ima mödanantapis Pabluta töparcasir gueshyagcunaman apayargan. Sayta yataycurnami say gueshyagcuna aliyäyargan. Saynölami supaycunapis runacunapita yarguyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jesuspa jutincho supaycunata runacunapita gargushganta musyarmi waquin Israel runacunapis Jesuspa jutincho supaycunata garguyta munayargan. Saymi niyargan: “Pablo wilacushgan Jesuspa jutinchömi cay nacasishgayqui runapita gamta gargö.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sayno rurayargan Esceva jutiyog runapa ganchis surincunami. Escevaga cargan mandag cürami. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Paycuna juc cuticho sayno garguyta camaptinmi supay nergan: “Noga reguëmi Jesusta. Saynömi Pablo pï cashgantapis musyä. Gamcunaga ¿pitä cayanqui nogata gargamänayquipäga?” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Sayno nirmi say supay nacasishgan runa löcutashpan Escevapa surincunata fiyupa magar mödanancunatapis rachir ushargan. Saymi pasaypa yawarlana garapächula say wayipita gueshpir aywacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Sayno rurashgancunata wiyar Efesucho Israel runacuna y mana Israel runacunapis fiyupa mansariyargan. Say päsashganta wiyarmi may-saychöpis runacuna musyayargan Jesucristo munayyog cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Saynöpis waquin runacuna Jesucristuta chasquicuyashpan jusalicuyashganta wilacuyargan: “Jesucristuta chasquicushgana carmi cananga say jusalicuycunata cachariyashcäna.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Saynölami brüju ruracunan libruncunatapis ascata apayämorgan lapanpa naupancho rupasiyänanpä. Say librucuna ayca cuestashgantapis cuentata jorguptin chargan pisga chunca waranga (50,000) jornalpa chaninman. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Saynöpami Jesucristupa wilacuynin may-saymanpis chaptin runacuna tantyayargan lapanpäpis Jesucristo munayyog cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Saypitanami Pablo yarpargan Jerusalenpa aywananpäga Macedoniacho cag waugui-panicunata y Acayacho cag waugui-panicunata watucaytarä. Saynöpis yarpargan Jerusalenpitaga Romapana aywananpä cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Sayno yarparmi Macedonia provinciaman naupananpä cachargan Timoteutawan Erastuta. Pablumi isanga Asia provinciacho quëdacorganrä. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Say wisanmi Efesucho waquin runacuna fiyupa rabiacuyargan Jesucristuta chasquicuyänanpä Pablo wilacuptin. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Saychömi Artemisa nishgan ïdulupa tacsha capillanta runacuna rantiyag wayincho sararäyänanpä. Say capillacunatami Demetrio jutiyog runa guellaypita rurag. Say capillacunata ranticurmi Demetrioga capilla rurag mayincunawan asca guellayta gänayag. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Sauraga arog mayincunata shuntaycurmi Demetrio nergan: “Gamcuna musyayanquimi cay capillacunata rurar ali gänashgansita. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gamcuna ricayashgayquinöpis y wiyayashgayquinöpis Pablo yachaycäsin: ‘Runa rurashgan ïdulucunaga manami rasunpaypa Diossu’ nishpan. Sayno yachasir criyisishga asca runacunatami. Manami cay Efeso marcalachösu sayno yachasish, sinöga intëru Asia provinciachöpis saynölami yachasish. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Runacunata sayno criyisiptin capilla rurashgansita mananami rantimäshunpänasu. Saynömi Artemisa diosninsipa templuntapis manacagman churayanga. Sayno captenga Artemisatapis runacuna mananami adorayanganasu. Paytaga may-saychöpis runacuna adorayanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetrio sayno niptinmi arog mayincuna fiyupa rabiacur niyargan: “¡Artemisa diosninsi ali ricash casun!” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Artemisata manacagman Pablo churashganta nir puriyaptinmi say marcacho runacunapis rabiacuyargan. Saymi fiyupa büllata rurayashpan Gayutawan Aristarcuta prësu sarircur apayargan runacuna shuntacäyänan pampaman. (Gayuwan Aristarcoga Macedoniapitami shayämorgan Pabluta yanapäyashpan.) ");
INSERT INTO qvhNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Sayno apayaptinmi runacunawan parlananpä Pablo sayman aywayta munargan. Aywayta munaptinpis waugui-panicuna payta michäyargan mana aywananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Waquin autoridäcunapis, Pabluwan reguinacurmi, wilacasergan runacuna shuntacash caycäyashganman mana aywananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Runacuna shuntacäyashganchömi waquin cag jucno parlayargan y waquin cagna jucno parlayargan. Sayno büllata rurar gaparäyaptinmi runacuna musyayargansu imapä sayman shuntacäyashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Paycunatapis jitapänanpä cashganta yarparmi Israel runacuna Alejandro jutiyog runata yaycasiyargan paycunapa favornin parlamunanpä. Saymi runacunapa naupanman Alejandro yaycuycur maquinwan sëñargan upälacuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Alejandroga Israel runa cashganta musyashpanmi say runacuna masrä ishcay hörano rabiashpan niyargan: “¡Diosninsi Artemisa ali ricash casun!” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Sayno niyaptinmi más mandag autoridä sëñata rurargan runacuna upälacuyänanpä. Upälacuyaptinmi nergan: “¡Efeso runacuna! May-saychöpis runacuna musyayanmi Artemisapa templun cay marcacho caycashganta. Saynöpis musyayanmi ciëlupita unyamushgan Artemisa-nirag rumitapis sararashgansita. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Saytaga manami pipis ñëgayta puëdinsu. Imanir gaparashgayquitapis mana musyaycarga upälacuyay. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gamcuna apayämushgayqui runacuna manami imatapis lutantaga rurayashgasu. Ni diosninsi Artemisatapis manami manacagman churayashgasu. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sayno caycaptenga Demetrio y arog mayincuna cay runacunata quejacuyta munarga autoridäcunaman quejacuyäsun sayta arreglayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Saypita maspis quejacuyänayquipä captenga lapan autoridäcunata shuntaycur saycunapita parlacushun. ");
INSERT INTO qvhNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Cayno büllata rurar puriyaptiquega Roma autoridäcuna: ‘¿Imanirtä shuntacar büllata rurayashcanqui?’ nir tapumashgaga manami imaniytapis camäpacushunpäsu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sayno nircurmi lapan runacunata nergan wayinpana cuticuyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bülla chawarcuptinnami waugui-panicunata Pablo gayaycasir shacyäsergan Tayta Diosninsi munashganno imaypis cawayänanpä. Saypitanami aywacorgan Macedonia provinciapana. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Macedonia provinciachöna marcan marcan purergan Jesucristuta chasquicogcunata shumag tantyasir. Saypitana päsargan Acaya provinciaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Saychömi targan quimsa quila. Saypita Siria provinciaman büquiwan cuticunanpä caycar mayargan Acayacho tag Israel runacuna payta wanusiyänanpä wilanacuyashganta. Saymi büquiwan aywananpa trucanga Macedonia provinciapa päsar chaquilapana aywargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Paywanmi aywayargan Pirrupa surin Sópater, Aristarco, Segundo, Gayo, Timoteo, Tíquico y Trófimupis. Pirrupa surin Sópaterga Berea marcapitami cargan. Aristarcuwan Segundoga Tesalónica marcapitami cayargan. Gayoga Derbe marcapitami cargan. Tíquico y Trófimunami Asia provinciapita cayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Paycuna naupacur nogacunata shuyäyämargan Troas marcacho. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Levadüraynag Tantata Micunan fiesta päsariptinmi Filipos marcapita nogacuna büquiwan aywayargä Troas marcaman. Saypita pisga junagta Troas marcacho naupagcunata taripäyargä. Saychömi quëdacuyargä ganchis junag. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Troaschönami Jesucristuta chasquicog mayëcunawan domingo junag shuntacäyargä Tayta Diosta alabayänäpä y Santa Cënata upuyänäpäpis. Waraynin tuta Pablo aywacunanpäna carmi juc wayipa quimsa cag pïsuncho yachasergan pulan pagasyag. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Saychömi asca mechërucunata sarisiyargan asicyänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Say shuntacäyashgä cuartupa ventänanchömi juc magta Eutico jutiyog jamaraycargan. Pablo yachaycäsiptinmi say magta punucäcushpan ventänapita jegacurporgan pampaman. Saypita wanushtana jogarcuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Sauraga Pablo urarpur say wanush magtata macalacurcorgan. Nircur waugui-panicunata nergan: “Ama mansacäyaysu. Cawarimushganami.” ");
INSERT INTO qvhNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nircur Pablo yapay wisargan yachaycäsishgan cagman Santa Cënata upuyänäpä. Saycho pasa warashganyag yacharcasir aywacorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Say magtatanami cawaycagtana wayinman pushayargan. Magta cawarimushganpitami lapanpis cushicuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Troas marcapita Asonyag Pablo chaquilapami aywargan. Nogacunanami büquiwan naupacuyargä, Asonchöna Pabluta shuntayänäpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asoncho shuntacarnami lapäcuna aywacuyargä büquiwan Mitilene marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mitilenipitanami waraynin junag chäyargä Quío nishgan islapa simpanman. Saypita waraynin junagna chäyargä Samos nishgan islaman. Saypita Trogilio marcacho punurcur juc junagtarä chäyargä Mileto nishgan marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pentecostés nishgan fiestapä Jerusalenman imaycanöpapis Pablo chayta munaptinmi Efesuman mana chaylapana aywayargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto marcachönami Pablo gayasimorgan Efesucho tag mayor wauguicunata paycunawan parlananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chäyämuptinmi nergan: “Gamcunaga musyanquimi cay Asia provinciaman chämushgä junagpita-pasa imano cashgätapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Israel runacuna chiquimaptinpis nacashpä wagarpis Tayta Diosninsi munashgantami imaypis rurashcä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Jesucristupa ali wilacuyninta lapantami gamcunata yachasishcä cällicunachöpis y wayiquicunachöpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Israel runacunata y mana Israel runacunatapis wilapashcä jusancunata cacharir Señorninsi Jesucristuta chasquicuyänanpämi. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Santu Espíritu nimaptinmi cananga Jerusalenman aywaycä. Isanga sayman chaptë ima päsamänanpä cagtapis manami musyäsu. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","May marcacunachöpis runacuna carcilman wichgamänanpä y nacasimänanpä cashgantami isanga Santu Espíritu musyasimash. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sayta musyarpis manami laquicösu. Nogaga wanushgäyagmi cumplishä wilacuyninta wilacunäpä Jesucristo churamashganta. Saymi pï-maytapis wilapäshä Jesucristo salvamagninsi cashganta. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","27","“Cananpitaga manami maygayquipis ricayämanquipänasu. Jesucristupa wilacuyninta lapantami wilapashcä. Wilapashgäpitanaga manami jusayogsu cä runacuna mana chasquicuyaptinpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ama gongäyaysu salvamänansipä Jesucristo cruzcho wanur yawarninta jichashganta. Nogansi-raycu wanush caycaptenga cuidä jusalicuyanquiman. Saynöpis mayor wauguicuna cayänayquipä Santu Espíritu churaycäyäshuptiquega waugui-panicunata shumag ricayay misicog runa uyshancunata ali ricashganno. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","“Noga musyämi aywacuptëga lutan yachasicogcuna fiyu atognöpis shayämunanpä cayashganta. Paycunaga waugui-panicunata pantacäsirmi lutancunata yachasenga. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Manami paycunalasu lutanta yachasenga, sinöga gamcunapitapis waquin sharcuyangami lutanta yachasicog. Manami Jesucristo munashganno cawananta munarsu yachasenga, sinöga quiquincunata cäsucuyänanta munarmi. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Sayno mana cayänayquipä shumag tantyacuyay. Yarpäyay quimsa wata sacaypapis junagpapis avëcis hasta wagapaypapis lapayquita shumag yachasishgäta. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Wauguicuna, Tayta Diosninsi munashganno cawanayquipämi imaypis payta manacuycä. Ama gongäyaysu cuyamagninsi Jesucristupa wilacuyninta yachasishgäcunata. Say wilacuyninta cäsucorga Tayta Diosninsi munashgannömi cawayanquipä. Saynöpami gloriaman char lapan yäracogcunawan juntu herenciata chasquicuyanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Gamcuna cagcho caycar manami pitapis resientipashcäsu ni guellayninpä, ni gorinpä, ni mödananpäpis. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Musyayashgayquinöpis quiquëmi arorgä nistashgäcunapäga. Sayno arurmi yanapargä nogawan puregcunatapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Gamcunapis sayno rurar waquin cagta yanapänayquipämi imaypis yachasishcä. Sayno yanapänacur cawanansipämi Jesucristupis yachasergan: ‘Pipis yanapäshunayquita shuyacunayquipa trucanga runa mayiquita yanapänayquitami Tayta Diosninsi munan.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Sayno yäsircurmi Pablo gongurpacuycur paycunawan Tayta Diosninsita manacuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","“Cananga manami más ricayämanquipänasu” nishganpitami lapanpis laquish wagar Pabluta macalayargan. Nircurnami büqui caycashgan cagman aywayargan payta despachayänanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Saycho yäracog mayëcunapita despidicurir büquiwan aywayargä Cos nishgan islayag. Warayninnami aywayargä Rodas nishgan islayag y saypitana chäyargä Pátara nishgan marcayag. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","3","Pátaracho tariyargä Feniciaman aywag büquita. Saymi say büquiwanna aywar Chipre isla naupanpa päsayargä. Saynöpami chäyargä Tiro marcaman, saycho say büqui cargancunata cacharinanpä captin. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Saycho waugui-panicunawan tincurmi paycuna cagcho goyäyargä ganchis junagnintin. Paycunami Santu Espíritu tantyasiptin Pabluta niyargan Jerusalenman mana aywananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nircurnami say marcapita aywacuyaptë wauguicunapis panicunapis y wamracunapis lamar cuchunyag churayämargan. Saychömi gongurpacuycur Tayta Diosninsita manacuyargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Saypita despidinacurir wisäyargä büquiman. Y paycunana wayincunapa cuticuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro marcapita yargurmi Tolemaida marcayag chäyargä. Saycho waugui-panicunawan tincurmi paycunawan quëdayargä juc junag. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Say marcapita waraynin junag aywar chäyargä Cesarea marcaman. Saycho posädacuyargä Felipipa wayincho. Paymi Jesucristupa ali wilacuyninta wilacog cargan. Paytami sogta wauguicunatawan naupata acrayargan Jerusalencho micuyta aypunanpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipipa chuscu japala warmi surincuna cargan. Paycunami cayargan Tayta Diosninsipa profetïsancuna. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Saycho asca junagna caycäyaptë Judea provinciapita shamorgan Agabo jutiyog waugui. Paypis Tayta Diosninsipa profëtanmi cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nogacuna cayashgä cagman shamur Pablupa wachcunta aptarcur maquinta y chaquintapis quiquin pancacorgan. Nircurnami nergan: “Cay pancarashgänömi cay wachcupa duëñunta Israel autoridäcuna pancaräsiyanga Jerusalencho. Nircur mana Israel runacunapa maquinmanmi entregayanga. Sayno päsananpä cashgantami Santu Espíritu tantyasimash.” ");
INSERT INTO qvhNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Say nishganta wiyaycur nogacunapis Cesareacho caycag waugui-panicunapis Pabluta ruwayargä Jerusalenman mana aywananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Sayno ruwacuyaptë Pablo niyämargan: “Nogatapis laquinaycäsimanquinami. Ama wagayaysu. Señorninsi Jesucristupa wilacuyninta wilacushgäpita manami pancaränaläpäsu listu caycä, sinöga Jerusalencho wanunäpäpis listumi caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Niyashgäcunata Pablo mana cäsuyämaptinmi mana más ruwayargänasu. Saypa trucanga: “Tayta Dios munaptenga jina saynöpis cangacher” niyargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Saypitanami puestucuyargä Jerusalenman aywayänäpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Saymi waquin wauguicuna Jerusalenyag pushayämargan. Saychönami Mnasonpa wayinman posädacuyänäpä aywayargä. Mnasonga Chipripitami cargan. Payga naupapitanami Jesucristuta chasquicog cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalenchönami waugui-panicuna cushish chasquicayämargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Waraynin junagnami Pabluwan aywayargä Santiaguta watucayänäpä. Saychömi tariyargä lapan mayor wauguicunatapis shuntacash caycagta. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paycunata saludarcurmi Pablo wilapargan: “Jesucristupa wilacuyninta mana Israel runacunata wilapaptë Tayta Diosninsi paycunatapis tantyasish chasquicuyänanpä.” Sayno wilashpanmi mana Israel runacuna cagcho lapan päsashgancunatapis wilapargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sayta wiyaycushpan Tayta Diosninsita paycuna manacur agradëcicuyargan. Nircurmi Pabluta wilayargan: “Waugui Pablo, waranganpami Israel runacuna Jesucristuta chasquicuyash. Jesucristuta chasquicurpis paycuna munaycäyan Moisés guelgashgan leycunata pï-maypis cumpliyänantami. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Paycunatami jucläpita shamog runacuna gampa contrayqui shimita gosh: ‘Pabloga may-saycho tag Israel runa mayinsitami yachaycäsin Moisés yachasishgan leycunata mana cumpliyänanpä. Saynöpis yachaycäsin costumbrinsicunata mana cumpliyänanpä y wamrancunapa cuerpunta mana señalasiyänanpä’ nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Cananga chämushgayquita musyashpan shuntacaycur ¿imatarä rurayäshunqui? ");
INSERT INTO qvhNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Imanöpapis paycunata tantyasishun Moisés guelgashgan leycunapa contran mana yachaycäsishgayquita. Nogacunapa yarpaynëpitaga cayno rurashun: Chuscu wauguicunami Moisés guelgashgancho nishgannöla Nazareo runa cayman yaycuyash. Nazareo runa carmi agsanta templucho rutusicongapä. Say rutusicunanpä cag junag chaycämunnami. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Saymi costumbrinsi cashganno templo yaycunacho purificacurir paycunawan yaycunqui templo patiuman. Saychöna chuscu wauguicuna nistäyashgancunata rantipanqui Moisés guelgashgan leycunacho nishganno altarman apayänanpä. Saynöpami runacuna tantyayanga gampis Moisés guelgashgan leycunata cumpliycashgayquita. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Mana Israel cag waugui-panicunapä maynami cartacushcansi Moisés guelgashgan leycunata mana cumplirpis Jesucristuta chasquicur salvacuyänanpä cayashganta. Say cartacho nishgansinöla salvashgana caycarga ïdulucunapa jutincho pishtashgan aysata ama micuyäsunsu, ima uywapa yawarnintapis ama upuyäsunsu ni micuyäsunsu, mana pishtaypa wanush uywacunapa aysanta ama micuyäsunsu, runacuna chinëru ama cayäsunsu y warmicunapis ama waynäcuyäsunsu.” ");
INSERT INTO qvhNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Sayno niyaptinmi waraynin tuta wilanacuyashgannöla say chuscun wauguicunawan templuman Pablo aywargan. Saychönami cüracunata wilargan say wauguicunawan agsan rutusicog ganchis junagta cutiyämunanpä cayashgantapis. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","Saypita ganchis junagtanami templuman Pablo yaycorgan say chuscun wauguicunawan. Saycho caycaptinmi Asia provinciapita shamog Israel runacuna ricayargan templucho Pablo caycagta. Sauraga fiyupa rabiar Pabluta prësu saripacuyargan: “¡Israel mayëcuna, cay runata prësu sarësiyämay! Cay runami may-say marcacunapa purin contransi parlar. Saynöpis lutanta yachasirmi leyninsita y templunsitapis manacagman churaycan. Templunsita mana respitashpanmi mana Israel runacunatapis yaycasimush” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mana Israel runata templuman yaycasishganta yarpäyargan Trófimutawan Pabluta cällicho puriycagta ricash carmi. Trófimoga Efeso marcapita mana Israel runami cargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Sayno niyaptinmi runacuna rabiashpan Pabluta garachashga jorguyargan Israel runacunala shuntacäyänan templo patiupita jucag cag patiuman. Jorgurcurna puncuta wichgayargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nircurmi saysica runacuna Pabluta wanusiyta munar magayargan. Sayno magaycashgantanami Roma soldäducunapa comandantin wiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Saymi soldäducunata shuntarcur jucla aywargan Pabluta magaycäyashgan cagman. Soldäducuna chaycagta ricasquirmi Pabluta cachariycuyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Say comandantinami Pabluta prësu sarircur ishcay cadinawan watasergan. Saypita runacunata taporgan: “¿Pitä cay runa? ¿Imatatä rurash?” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Sayno tapuptinmi waquin juc yarpayta niyargan y waquinna juc yarpayta niyargan. Sayno niyaptinmi ima päsashgantapis mana musyar Pabluta cuartilman apasergan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Apaycäyaptin runacuna magayta munaptinmi soldäducuna Pabluta wintuypa cuartilman wisäsiyargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Paycunata asca runacunami gatiräyargan: “¡Wanusish casun!” niyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Cuartilman yaycasinanpä caycaptinnami Pablo nergan say comandantita: “Rätula gamwan parlaytami munaycä, taytay.” Niptin say comandanti Pabluta nergan: “¿Griego parlayta yachanquicu? ");
INSERT INTO qvhNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Gam Egipto runami canqui, ¿au? ¿Manacu gam gobiernupa contran naupata sharcorgayqui? ¿Manacu gam purergayqui sunyag jircapa chuscu waranga (4,000) wanusicog runacunata pushacurcur?” ");
INSERT INTO qvhNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Saymi Pablo nergan: “Nogaga manami Egipto runasu caycä, sinöga Israel runami, taytay. Cilicia provinciacho cag Tarso marcacho yuregmi cä. Cananga rätula cachaparcamay Israel mayëcunawan parlarcunäpä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Sayno niptinmi say comandanti ruwacushganta aunergan. Saymi Pablo grädacho ichiycur maquinwan sëñargan runacuna upälacuyänanpä. Lapan upälacuyaptinna hebreo idiömapa parlapargan. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Saymi Pablo nergan: “Taytacuna, wiyayämay.” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Quiquincunapa idiömancho Pablo parlashganta wiyarmi lapanpis upälacuyargan. Saymi nergan: ");
INSERT INTO qvhNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nogapis Israel runami caycä. Cilicia provinciacho cag Tarso marcachömi yurishcä. Isanga winashcä Jerusalenchömi. Gamalielmi yachasimash Moisés guelgashgan leycunata. Sayno carmi Tayta Diosninsipa leynincunata lapan shongöwan cumplir gamcunano cargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Alita ruraycashgäta yarparmi Jesusta chasquicogcunata ushacäsiyta munar warmitapis olgutapis carcilman wichgasergä. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sayno rurashgäta musyarmi más mandag cüra y lapan Israel mayor runacunapis ordinta goyämargan Damascucho cag autoridäcuna yanapäyämänanpä. Saymi aywaycargä Jesucristuta chasquicogcunata Jerusalenman prësu apaycamur castigasinäpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Damascuman chänäpäna caycaptëmi pulan junagno elagpita nogaman ciëlupita elgucuyno chipipimorgan. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Saymi pasaman tunir wiyargä cayno nimogta: ‘Saulo, Saulo, ¿imanirtä nogapa conträ sharcuycanqui?’ ");
INSERT INTO qvhNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Sauraga taporgä ‘¿Pitä canqui, taytay?’ Sayno niptëmi nimargan: ‘Nogaga Jesucristumi caycä. Yäracamagcunata gaticacharga nogapa conträmi caycanqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“Say asicyämogta ricar nogawan aywagcuna fiyupa mansacäyargan. Isanga Jesucristo parlapämashgantaga manami wiyayargansu. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Payta chiquiycashgäta nimaptinmi taporgä: ‘¿Imatatä ruräman, taytay?’ Saynami nimargan: ‘Sharcurcur ayway Damasco marcaman. Saychönami juc runa nishunquipä imata ruranayquipä cashgantapis.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ciëlupita asicyämushganwan gaprayash captëmi nogawan aywaycagcuna janchaylapa chäsiyämargan Damasco marcaman. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Say marcachömi targan Ananías jutiyog runa. Paymi Moisés guelgashgan leycunata cumplir Tayta Diosninsi munashganno cawargan. Damascucho tag Israel runacuna payga ali runa cashgantami niyan. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías ricamagnë shamurmi nimargan: ‘Waugui Saulo, cananpita yapaynami ricanqui.’ Sayno nimaptinmi jinan höra ricargä. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nircurmi nimargan: ‘Israel runacuna adorayashgan Tayta Diosninsimi acrashushcanqui pay munashganno cawanayquipä, Jesucristo yuripäshunayquipä y parlashgancunatapis wiyanayquipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sayno ricash y wiyash carmi pï-maytapis Jesucristupa wilacuyninta wilapanquipä. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Canan jucla bautizacur Tayta Diosninsita manacuy lapan jusalicushgayquicunata perdonashunayquipä.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","“Sauraga Jerusalenman cutiycamur templucho Tayta Diosninsita manacuycaptë Jesucristo yuriparcamar nimargan: ‘Jerusalenpita jucla yarguy. Caychöga manami chasquicuyangasu wilacuynëta wilacuptiqui.’ ");
INSERT INTO qvhNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Sayno nimaptinmi noga nergä: ‘Paycuna musyayanmi contrayqui naupata cashgäta. Saynöpis musyayanmi may-say sinagogaman aywar gamman yäracogcunata maga magarcur carcilman apashgäta. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Wilacogniqui Estebanta wanusiyaptinpis saychömi caycargä “¡Wanusiy!” nishpä. Nogami sararargä wanusegcunapa janan cag mödanancunatapis. Sayno contrayqui caycarpis gamta chasquicushgäta runacuna musyayanmi. Sayta musyaycarga ¿manasurä paycunapis ricacayämashpan chasquicuyäshunquipä, taytay?’ ");
INSERT INTO qvhNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Sayno niptëpis Jesucristo nimargan: ‘Sayno yarpaptiquipis gamta cachaycä caru marcacunapa aywar mana Israel runacunata nogapa wilacuynëta wilapänayquipämi.’ ” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mana Israel runacunaman wilacog aywananpä nishganta Pablo wilaptinmi runacuna fiyupa rabiashpan niyargan: “¡Say runa ama cawasunsu! ¡Jucla wanusishun!” nir. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Sayno rabiashpanmi janan cag mödanancunatapis logtirir tapshiyargan. Nircurmi alpatapis junagpa mashiyargan fiyupa gaparäyashpan. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Sayno niyaptinmi Pabluta cuartil rurinman yaycaycasir say comandanti soldäducunata nergan: “Cay runata castigayay. Sayrämi wilamäshun imanir paypa contran runacuna sharcuyashgantapis.” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Castigananpä wataraycäsiptinnami say soldäducunapa capitanninta Pablo nergan: “Nogaga Roma runami caycä. Autoridäcunapis manarämi juzgayämanräsu. Sayno caycaptenga ¿imanirtä castigamayta munaycäyanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sayno niptinmi capitán aywargan comandantiman Pablo nishganta wilananpä. Saymi chaycur nergan: “Say runaga Roma runashi. ¿Cananga imatatä rurashun, taytay?” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sayno niptinmi say comandanti aywaycur Pabluta taporgan: “¿Rasunpacu Roma runa canqui?” nir. Niptin Pablo nergan: “Au, taytay. Roma runami caycä.” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Saymi comandanti nergan: “Noga Roma runa canäpäga asca guellaytarämi pägashcä.” Saymi Pablo nergan: “Nogaga Roma runa cä yurishgäpita-pasami.” ");
INSERT INTO qvhNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sayno niptinmi castigananpä sararag soldäducuna Pabluta cachariycuyargan. Say comandantipis Roma runa cashganta musyar mansarergan cadinasishganpita. ");
INSERT INTO qvhNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Waraynin junag say comandanti musyayta munargan Pabluta imanir runacuna chiquiyashgantapis. Saymi mandag cüracunatawan Israel runacunapa autoridänincunata gayasergan. Nircur Pabluta apasergan say autoridäcuna shuntacäyashgan cagman. ");
INSERT INTO qvhNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Saymi autoridäcunata ricärir Pablo nergan: “Taytacuna, manami imatapis lutantaga rurashcäsu. Sayno cawashgätaga Tayta Dios musyanmi.” ");
INSERT INTO qvhNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sayno niptinmi runacunata más mandag cüra Ananías nergan Pabluta shimicho lagyananpä. ");
INSERT INTO qvhNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Sayno lagyasiptin Pablo nergan: “Sayno lagyasimashgayquipita quiquiquitami Tayta Diosninsi castigashunquipä. Caycho gam jamaraycanqui leyninsicuna niyashganno jusä cashganta mana cashgantapis juzgamänayquipämi. Leyninsichöga manami ninsu pita lagyasinayquipäpis. Sayno caycaptenga ¿imanirtä leyninsicunata mana cäsur lagyasimashcanqui?” ");
INSERT INTO qvhNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sayno niptinmi saycho caycag runacuna niyargan: “¿Imanirtä gayapanqui Tayta Diosninsi acrashgan más mandag cürata?” ");
INSERT INTO qvhNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Saymi Pablo nergan: “Mandag cüra cashgantaga manami musyargäsu. Tayta Diosninsipa palabrancho nican autoridäninsita mana gayapänansipä cashgantami.” ");
INSERT INTO qvhNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pablo musyargan say autoridäcuna waquin cag saduceo cashganta y waquin cagna fariseo cashganta. Saymi fuertipa nergan: “¡Taytacuna! Awilöcuna fariseo runa cashgannömi nogapis fariseo runa cä. Wanushcunata Tayta Diosninsi cawarisimunanpä cashganta yac